       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02171.                                         
COB303 DATE-WRITTEN.      SEPTEMBER 25, 1995.                           
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S171                                           *00120000
      *  PROGRAM:       S171                                           *00130000
      *  CALLING SP:    PA_S171                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES DEPOSIT-ON-HAND, REFUND, AR-CONTROL AND  *00200000
      *  OTHER AR-JOURNAL DETAIL FOR THE REFUND OF DEPOSIT AMOUNT.     *00210000
      *  THE DEPOSIT AMOUNT CAN BE REFUNDED BACK TO THE CUSTOMER THRU' *00220000
      *  CHECK OR CASH OR THE AMOUNT CAN BE CREDITED TO OTHER          *00230000
      *  RECEIVABLES FOR THE CUSTOMER.                                 *00240000
      *                                                                *00250000
      *  PARAMETERS:                                                   *00260000
      *    USERID                                                      *00270000
      *    RESP-AREA-ID                                                *00280000
      *    OTHERS PARAMTERS TO BE FILLED UP                            *00290000
      *  RETURNS:                                                      *00300000
      *    RETURN-CODE                                                 *00310000
      *                                                                *00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                     PROGRAM MODIFICATION LOG                   *00350000
      *                                                                *00360000
      *    DATE    INITIALS   COMMENTS                                 *00370000
      *  --------  --------   ---------------------------------------  *00380000
      *  09/25/95    SK       RPC ORIGINALLY ADDED.                    *00390000
      *  01/31/96    MR       ADDED TABLE  TBMFWQ FOR CPD0010S         *00400000
      *                       TBDEPREQ , TBDELQ FOR CPD00068           *00410000
      *  03/28/96    LMB      TPR 2508 - ADDED TBLIEAP                 *00411000
      *  03/28/96    LMB      TPR 2585 - ADDED TBNSFHST, TBCRPROF      *00412000
      *  04/16/96    SONALI   TPR#3853 & TPR#3918                      *00412100
      *                            AR-REFUNDED-IND SET TO 'Y' FOR      *00412400
      *                       PAYMENTS THAT ARE REFUNDED THRU PAN#259  *00412500
      *                       ADDED PARA  8530-UPDATE-AR-HIST          *00412600
      *  06/20/96    CSG      TPR 3228 - ADDED TBPRJSHR.               *00412700
      *  07/01/96    SONALI   TPR#4783 - MOVE -AT_CODES_... TO WS_CODES*00412800
      *                       IN 5010-CREATE-REFUND                    *00412900
      *                                                                *00413000
      *  07/18/96    SR       PCR#052.                                 *00413100
      *  09/04/96    AG       TPR#4158 - GET ADDRESS ID FROM A NEW     *00413200
      *                       COPYBOOK.                                *00413300
P353  *  09/18/96    JBW      PCR 353.  ADDED CSR-PC-ID AS A PARM THAT *00413400
      *                       WILL BE WRITTEN TO CSS_CSH_DRWR_JRNL.    *00413500
PCR360*  10/18/96    JRX      PCR360 ADD RS-CANCELDNP-FLAG TO THE      *00413600
PCR360*                       RESULT SET AND PERFORM LIMIT CHECK FROM  *00413700
PCR360*                       CPD00068 BEFORE SETTING THE FLAG.        *00413800
PCR360*                       WHEN THE DEPOSIT IS REFUNDED, DELETE DNP *00413900
PCR360*                       AND NOTICE ROWS(I, O) IF THEY ARE IN THE *00414000
PCR360*                       FUTURE.                                  *00414100
      *  10/30/96   JRX       ADD RS-CANCELDNP-TO-FLAG TO THE RESULT   *00414200
      *                       SET AND PERFORM LIMIT CHECK ON THE       *00414300
      *                       SPEC-ACCOUNT-NO.                         *00414400
      *  12/09/96   KG        TPR-5932. ADDED CODE TO SET COMPANY_NO & *00414500
      *                       LOCAL_OFFICE FOR THE ACCOUNT TO ALLOW    *00414600
      *                       JOURNALING TO OCCUR.                     *00414700
      *                                                                *00415000
TP8882*  03/17/97   CSS       CORRECT JOURNALLING PROBLEM BY SETTING   *00415100
      *                       TRANS APPL NO TO ONE                     *00415200
      *                                                                *00415300
      *  03/18/97   MAD       CORRECT NULL VALUE PROBLEM WITH DATE_    *00415400
      *                       PYMT_START IN CSS_DEP_ON_HAND.           *00415500
TP9728** 03/19/97     PD       ADD DCLGEN TBWOARGM FOR CPD73 CHANGES. * 00415600
PCR482*  03/19/97   MAD       COMPLETION OF PCR482 WITH DCR FOR NEW    *00415700
      *                        FIELD ACCT_NO_CREDITED ON CSS_REFUND.   *00415800
PCR404*  03/27/97   MAD       ADDED SWITCH TO BYPASS CURRENCY TYPE     *00415900
      *                        ASSIGNMENT IN CPD00010 FOR REFUNDS.    * 00416000
      *                       MODIFIED PROGRAM TO ASSIGN AR-CODE-TRAN * 00416100
      *                        TYPE OF 'R' FOR REFUNDS INITIATED THRU * 00416200
      *                        PANEL 259.                             * 00416300
T10266*  04/09/97   MAD       MODIFIED PROGRAM TO CORRECTLY INSERT A  * 00416400
      *                        ROW INTO CSS_REFUND WHEN A "SUPERUSER" * 00416500
      *                        COMPLETES A CASH REFUND  -  I.E. HE/SHE* 00416600
      *                        SETS UP, APPROVES AND CASHIERS THE     * 00416700
      *                        REFUND IN ONE STEP.                    * 00416800
T10315*  04/10/97   MAD       CHECK_STATUS_CD WILL BE POPULATED WITH  * 00416900
      *                        SPACES WHEN THE REFUND IS NOT CASH OR  * 00417000
      *                        CHECK.                                 * 00417100
T10426*  04/16/97   MAD       FIXED A JOURNALLING PROBLEM WITH DEPOSIT* 00417200
      *                        REFUNDS WHEN INTEREST IS INVOLVED AND  * 00417300
      *                        MULTIPLE REFUND OPTIONS ARE CHOSEN.    * 00417400
T10658*  04/29/97   MAD       ADDED AR_LOCKOUT FUNCTIONALITY - SEEMED * 00417500
      *                        THAT IT WAS REMOVED SOMEWHERE ALONG THE* 00417600
      *                        LINE.                                  * 00417700
T11712*  06/18/97   MAD       WHEN CREDITING ANOTHER ACCOUNT WITH THE * 00417800
      *                        PROCEEDS FROM A REFUND, THE TRAN TYPE  * 00417900
      *                        ON THE "TO" ACCOUNT MUST BE AN 'A'.    * 00418000
MAD620*  06/20/97   MAD       MADE MODIFICATIONS TO ALLOW MULTIPLE    * 00418100
      *                        REFUNDS OF THE SAME TYPE ON THE SAME   * 00418200
      *                        DEPOSIT TO PROCESS CORRECTLY.          * 00418300
T11846*  06/26/97   MAD       MADE MODIFICATIONS TO DELETE/UPDATE THE * 00418400
      *                        CREDIT COLLECTION 'I' AND 'O' ROWS FOR * 00418500
      *                        BILL IMMEDIATE DEPOSITS WHEN PERFORMING* 00418600
      *                        THE REFUND PROCESS.                    * 00418700
NONUTL** 7/11/97    CHANDRA    ADDED CPD00312, CWS10016, TBHLDAY      * 00418800
PCR526*  7/22/97    MAD       MADE MODIFICATIONS TO SUPPORT PCR526    * 00418900
      *                        TRANSACTION HISTORY SPECIFICATIONS.    * 00419000
T12460*  8/01/97    EMS       ADDED CSS_DNP DCLGEN FOR CPD68 CHANGES  * 00419100
T13084*  9/16/97    BAB       UPDATED WS-CODES-DATA-PRESENT WHEN THE  * 00419200
      *                        REFUND IS APPROVED.                    * 00419300
T16631*  6/01/98    EMS       CHANGED THE CASH GL FROM MNEMONIC       * 00419400
      *                       'ACASH' - 135.2000 TO 'CLR-CASH' -      * 00419500
      *                       184.2000.                               * 00419600
PCR307*    09/03/98  AMG      IF THE PAYMENT IS NOT ENOUGH TO CANCEL   *        
PCR307*                       THE DNP, THEN INSERT A ROW INTO          *        
PCR307*                       CSS_SO_DNP_CANCEL WITH A FLAG OF 'U'     *        
CBSI  *  09/10/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T17071*  11/19/98   MDJ       ADDED INCLUDE TBCSTALT FOR CUST_ALERT IN *        
      *                       CPD00068.                                *        
T19068*  02/11/99   MDJ       WRITE RECORD TO CSS_REFUND WHEN REFUND IS*        
      *                       REQUESTED.  IT WAS ONLY WRITING THE      *        
      *                       RECORD WHEN IT WAS APPROVED.             *        
      *                       UPDATE CODES-DATA-PRESENT IF REFUND IS   *        
      *                       REQUESTED OR APPROVED AND CASH OR CHECK. *        
      *                       PREVIOUSLY WAS ONLY UPDATING IF IT WAS A *        
      *                       CHECK.                                   *        
T20346*  08/12/99   CBSI      TO STOP A DIRECTED DEPOSIT REFUND WHEN   *        
      *             MADRAS    THE REFUND AMOUNT IS GREATER THAN THE    *        
      *                       RECEIVABLE FULL-BALANCE                  *        
TPRNEW*  09/15/99   KSB       TO JOURNAL TO THE 'TO' LOCAL OFFICE WHEN *        
      *                       A SPECIFIC ACCOUNT IS SELECTED FOR       *        
      *                       CREDIT OF THE DEPOSIT                    *        
T21024*  11/16/99   CBSI      CALL SUB ROUTINE SCSCA182 AND CHECK IF   *        
T21024*             MADRAS    THE PARM-LAST-UPDATE-TS AND THE ONE      *        
T21024*                       OBTAINED FROM THE SUB ROUTINE ARE SAME,  *        
T21024*                       IF THEY ARE SAME UPDATES AR_CNTL ELSE    *        
T21024*                       SENDS ERROR MSG TO THE PANEL             *        
T19557* 04/04/00     CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*              MADRAS   SCSCO068.                                *        
T20626* 05/22/00     CBSI     TO UPDATE REQUEST_DT IN CSS_REFUND WITH  *        
T20626*              MADRAS   DELINQUENCY TABLE VALUE.                 *        
T22359* 06/23/00    KDF      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *         
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
      *                       ALWAYS SCSCO068 OR SCSCB068.             *        
      * 04/26/01    CHANELLE  MCR310 PSNC.  ALWAYS USE COMPANY '01'    *        
      *                       REFERRING TO GL NUMBERS.                 *        
T24367* 06/26/01     SFH      ADDED LOGIC TO SEND CANCEL NOT FLAG TO   *        
      *                       PANEL 259.                               *        
T23235* 07/12/01     SFH      ADDED DCLGEN FOR CSS_UTIL_ENVRNMT.       *        
T24555* 08/07/01     SFH      REPLACED WS-GL-SUB WITH WS-VALID-CO-SUB  *        
      *                       AS AN INDEX TO WS-VALID-CO-NO. THIS WILL *        
      *                       PREVENT A SUBSCRIPT OUT OF BOUNDS ERROR. *        
T24436**10/16/01    COVANSYS  COPYBOOK CPD00061 CHANGED TO SUB        **        
T24436*             CHENNAI   PROGRAM  SCSCO061.                      **        
C28788* 07/03/03    MDJ       ADD IVR-EXEMPT-CD FOR CPD00068.         **        
T29481* 09/03/03    COVANSYS  TO HAVE TRANSACTION HISTORY TO DISPLAY  **        
T29481*                       "INTEREST ONLY" IN DESCRIPTION WHILE    **        
T29481*                       REFUNDING INTEREST ONLY.                **        
C29752* 11/10/03    MDJ       ONLY SELECT ROWS FROM DEP_INT_RATE IF   **        
      *                       THE EFFECTIVE DATE IS = < CURRENT DATE. **        
      * 11/11/03    MDJ       USE CPD00023, CWS00023 AND CPD00128 TO  **        
      *                       INSERT/UPDATE CSS_INTERST_HIST CORRECTLY.*        
      * 12/9/03     MDJ       DON'T ADD 1 DAY TO DO-DATE-INST-CALC-TO. *        
T31755* 11/16/04    CVNS      MADE CHANGES TO 7305- NOT TO SELECT      *        
      *             CHENNAI   DEPOSIT AMOUNT                           *        
REARCH* 09/26/05    CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T33431** 03/16/06   SK88120        COG PROJECT CHANGES -               *        
T33431**                           A- ADD NEW COPYBOOKS                *        
T33431**                           B- CHANGE IN CPD00073               *        
C32206* 05/23/06    LG41184   INCREASED THE LENGTH OF CHECK-ISS-REAS-CD*        
C32206* 12/11/06    CB18344   FIXED PROBLEM WITH MISSING REFUND REASON *        
C32206*                       CODE CAUSING REFUNDS TO NOT BE GENERATED.*        
T34097* 02/07/07    MC95456  REPLACED CSS_MODEL_SQL WITH SET STATEMENTS*        
C35743* 05/14/07    MELISSA JOHNSON IF DATE-CERT-ISSUE IS SPACES OR LOW*        
C35743*                      VALUES, MOVE -1 TO NULL IND,ELSE MOVE 0 TO*        
C35743*                      NULL IND.                                 *        
C35671* 11/27/07    CVNS     NAME AND ADDRESS FORMAT CHANGES           *        
C35671*             CHENNAI                                            *        
CSR501* 12/03/08    MJ13662 INTIALIZE RN-ADDRESS-ID TO STOP ABENDS.    *        
A00956* 03/26/09    CVNS     REPLACE CPD00006 WITH CPD0006A.           *        
A00956*             CHENNAI                                            *        
A00870* 05/27/09    SK42147  IF NO OTHER DEPOSIT EXIST FOR AN ACCOUNT  *        
A00870*                      DELETE SUMMARY ROW ALONG WITH DETAIL.     *        
A36248* 06/12/09    LG41184  CALL NEW SUBPROGRAM MCSCB371 TO UPDATE    *        
A36248*                      DNP BALANCE REAL TIME FOR CSR.            *        
A37302* 07/07/09    LG41184  DCLGEN TBRVCACT REMOVED.                  *        
A01370* 07/15/09    CVNS     WHEN SUPERVISOR APPROVES THE REFUND THEN  *        
A01370*             CHENNAI  THE CHECK STATUS CODE SHOULD BE CHANGED   *        
A01370*                      FROM REQUESTED TO APPROVED.               *        
A01731* 12/17/09    CVNS     INTEREST CALCULATION LOGIC CHANGED TO USE *        
A01731*             CHENNAI  REFUND DATE RATHER CURRENT DATE DURING    *        
A01731*                      SUPERVISOR APPROVAL                       *        
A37666* 04/28/10    FMB      COMMETED OUT ADDRESS DELETE.              *        
P00641* 05/01/12    DB41297  GET GL-ACCT-NAME-DESC FROM CSS_GL_ACCT_NO *        
      *                                                                *        
A05154* 23 FEB 2015 RF10596  REMOVE UNUSED CODE                        *        
A04860*  04/04/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT105    CSS_WQ_ITEMS TABLE                        *01790200
P0087A* 01/20/17    WR19680  FIXING ISSUES WITH DEPOSIT REFUNDS FROM   *        
P0087A*                      MOD                                       *        
      ************************CORRECTLY*********************************00419400
      *                                                                *00419500
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00419600
      *                                                                *00419700
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00419800
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00419900
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00421000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
      *                                                                 00500000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02171'.
MSQ017     COPY MFASQLM.
      *                                                                 00540000
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02171 STARTS HERE'.                  
      *                                                                 00570000
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
      *                                                                 00610000
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
      *                                                                 00650000
      *---< CSS_ACCOUNT      - AT >                                     00660000
           EXEC SQL                                                     00670000
              INCLUDE TBACCT                                            00680000
           END-EXEC.                                                    00690000
      *                                                                 00691000
      *---< CSS_CNT_DETAIL   - EA >                                     00692000
           EXEC SQL                                                     00693000
              INCLUDE TBCNTDET                                          00694000
           END-EXEC.                                                    00695000
      *                                                                 00700000
      *---< CSS_CUSTOMER     - CU >                                     00710000
           EXEC SQL                                                     00720000
              INCLUDE TBCUST                                            00730000
           END-EXEC.                                                    00740000
      *                                                                 00752000
      *---< CSS_PREMISE      - PR >                                     00760000
           EXEC SQL                                                     00770000
              INCLUDE TBPREM                                            00780000
           END-EXEC.                                                    00790000
      *                                                                 00800000
      *---< CSS_REFUND       - RN >                                     00810000
           EXEC SQL                                                     00820000
              INCLUDE TBREFUND                                          00830000
           END-EXEC.                                                    00840000
      *                                                                 00850000
C32206*---< CSS_REFUND_REASON -RU >                                     00810000
C32206     EXEC SQL                                                     00820000
C32206        INCLUDE TBRFNRSN                                          00830000
C32206     END-EXEC.                                                    00840000
      *                                                                 00850000
      *---< CSS_DEP_INT_RATE   - P6 >                                   00860000
           EXEC SQL                                                     00870000
              INCLUDE TBDEPINT                                          00880000
           END-EXEC.                                                    00890000
      *                                                                 00900000
      *---< CSS_DEP_ON_HAND    - DO >                                   00910000
           EXEC SQL                                                     00920000
              INCLUDE TBDEPHND                                          00930000
           END-EXEC.                                                    00940000
      *                                                                 00950000
      *---< CSS_DEP_PAY_HST    - DP >                                   00960000
           EXEC SQL                                                     00970000
              INCLUDE TBDEPHST                                          00980000
           END-EXEC.                                                    00990000
      *                                                                 01000000
      *---< CSS_INTEREST_HIST  - IH >                                   01010000
           EXEC SQL                                                     01020000
              INCLUDE TBINTHST                                          01030000
           END-EXEC.                                                    01040000
      *                                                                 01050000
      *---< CSS_AR_CNTL        - AC >                                   01060000
           EXEC SQL                                                     01070000
              INCLUDE TBARCNTL                                          01080000
           END-EXEC.                                                    01090000
      *                                                                 01100000
      *---< CSS_AR_TRANS_HIST  - AR >                                   01110000
           EXEC SQL                                                     01120000
              INCLUDE TBARHIST                                          01130000
           END-EXEC.                                                    01140000
      *                                                                 01150000
      *---< CSS_AR_TRN_HST_DET - AU >                                   01160000
           EXEC SQL                                                     01170000
              INCLUDE TBARHDT                                           01180000
           END-EXEC.                                                    01190000
      *                                                                 01200000
      *---< CSS_CSH_DRWR_JRNL - CJ >                                    01210000
           EXEC SQL                                                     01220000
              INCLUDE TBCDJRNL                                          01230000
           END-EXEC.                                                    01240000
      *                                                                 01250000
      *---< CSS_CSH_DRWR_CNTL - CS >                                    01260000
           EXEC SQL                                                     01270000
              INCLUDE TBCDCNTL                                          01280000
           END-EXEC.                                                    01290000
      *                                                                 01300000
      *---< CSS_BCH_JRNL_CNTL  - BC >                                   01310000
           EXEC SQL                                                     01320000
              INCLUDE TBBJCNTL                                          01330000
           END-EXEC.                                                    01340000
      *                                                                 01350000
      *---< CSS_BATCH_JRNL    - BJ >                                    01360000
           EXEC SQL                                                     01370000
              INCLUDE TBBTJRNL                                          01380000
           END-EXEC.                                                    01390000
      *                                                                 01400000
      *---< CSS_MISC_JRNL     - MJ >                                    01410000
           EXEC SQL                                                     01420000
              INCLUDE TBMSJRNL                                          01430000
           END-EXEC.                                                    01440000
      *                                                                 01450000
      *---< CSS_GL_ACCT_NO     - GO >                                   01460000
           EXEC SQL                                                     01470000
              INCLUDE TBGLATNO                                          01480000
           END-EXEC.                                                    01490000
      *                                                                 01500000
      *---< CSS_MNT_TRANS_HIST - MH >                                   01510000
           EXEC SQL                                                     01520000
              INCLUDE TBMNHIST                                          01530000
           END-EXEC.                                                    01540000
      *                                                                 01550000
      *---< CSS_USER_PROFILE  - PF >                                    01560000
           EXEC SQL                                                     01570000
              INCLUDE TBUSRPRF                                          01580000
           END-EXEC.                                                    01590000
      *                                                                 01600000
      *---< CSS_ADDR_ID_CNTL  - I8>                                     01610000
           EXEC SQL                                                     01620000
              INCLUDE TBADDRID                                          01630000
           END-EXEC.                                                    01640000
      *                                                                 01650000
      *---< CSS_ADDR_FREEFORM  - SI>                                    01660000
           EXEC SQL                                                     01670000
              INCLUDE TBADRFRE                                          01680000
           END-EXEC.                                                    01690000
      *                                                                 01700000
      *--- <CSS_MT_TRN_HST_DET - MI >                                   01710000
           EXEC SQL                                                     01720000
              INCLUDE TBMNHDT                                           01730000
           END-EXEC.                                                    01740000
      *                                                                 01750000
      *---< CSS_AR_PMT_PRTY    - C9>                                    01760000
           EXEC SQL                                                     01770000
              INCLUDE TBARPMT                                           01780000
           END-EXEC.                                                    01790000
      *                                                                 01800000
      *---< CSS_CONTRACT       - CT>                                    01860000
           EXEC SQL                                                     01870000
              INCLUDE TBCNTRCT                                          01880000
           END-EXEC.                                                    01890000
      *                                                                 01900000
      *--- <CSS_DFA_RECVBLE    - DV >                                   01910000
           EXEC SQL                                                     01920000
              INCLUDE TBDFARCV                                          01930000
           END-EXEC.                                                    01940000
      *                                                                 01950000
      *--- <CSS_DFA_ACCT       - DA >                                   02010000
           EXEC SQL                                                     02020000
              INCLUDE TBDFAACT                                          02030000
           END-EXEC.                                                    02040000
      *                                                                 02050000
      *---< CSS_RECONNECT      - DL>                                    02060000
           EXEC SQL                                                     02070000
              INCLUDE TBRECNCT                                          02080000
           END-EXEC.                                                    02090000
      *                                                                 02100000
      *---< CSS_CRED_COLL     - CL >                                    02110000
           EXEC SQL                                                     02120000
              INCLUDE TBCRCOLL                                          02130000
           END-EXEC.                                                    02140000
      *                                                                 02150000
      *---< CSS_CHRG_OFF      - CO >                                    02160000
           EXEC SQL                                                     02170000
              INCLUDE TBCHGOFF                                          02180000
           END-EXEC.                                                    02190000
      *                                                                 02200000
      *---< CSS_AR_LOCKOUT     - AL >                                   02210000
           EXEC SQL                                                     02220000
              INCLUDE TBARLOCK                                          02230000
           END-EXEC.                                                    02240000
      *                                                                 02300000
      *---< CSS_BUDGET_PLAN    - BU >                                   02310000
           EXEC SQL                                                     02320000
              INCLUDE TBBGTPLN                                          02330000
           END-EXEC.                                                    02340000
      *                                                                 02350000
      *---< CSS_BUDGET_HIST    - BH >                                   02360000
           EXEC SQL                                                     02370000
              INCLUDE TBBGTHST                                          02380000
           END-EXEC.                                                    02390000
      *                                                                 02400000
      *---< CSS_DEP_REQ        - DR >                                   02460000
           EXEC SQL                                                     02470000
              INCLUDE TBDEPREQ                                          02480000
           END-EXEC.                                                    02490000
      *                                                                 02500000
      *---< CSS_DELINQUENCY    - C8 >                                   02510000
           EXEC SQL                                                     02520000
              INCLUDE TBDELQ                                            02530000
           END-EXEC.                                                    02540000
      *                                                                 02550000
TP2508*---< CSS_LIEAP          - LI >                                   02560000
TP2508     EXEC SQL                                                     02570000
TP2508        INCLUDE TBLIEAP                                           02580000
TP2508     END-EXEC.                                                    02590000
      *                                                                 02600000
TP2585*---< CSS_NSF_HIST       - NH >                                   02610000
TP2585     EXEC SQL                                                     02620000
TP2585        INCLUDE TBNSFHST                                          02621000
TP2585     END-EXEC.                                                    02622000
      *                                                                 02623000
TP2585*---< CSS_CREDIT_PROFILE - CZ >                                   02623100
TP2585     EXEC SQL                                                     02623200
TP2585        INCLUDE TBCRPROF                                          02623300
TP2585     END-EXEC.                                                    02623400
      *                                                                 02623500
TP3228*---< CSS_PROJ_SHAR      - CG >                                   02623600
TP3228     EXEC SQL                                                     02623700
TP3228        INCLUDE TBPRJSHR                                          02623800
TP3228     END-EXEC.                                                    02623900
PCR360*                                                                 02624000
PCR360*---< CSS_LOCAL_OFFICE        >                                   02624100
PCR360     EXEC SQL                                                     02624200
PCR360        INCLUDE TBLOCOFC                                          02624300
PCR360     END-EXEC.                                                    02624400
PCR360*                                                                 02624500
PCR072     EXEC SQL                                                     02624600
PCR072        INCLUDE TBCCCHRG                                          02624700
PCR072     END-EXEC.                                                    02624800
PCR072*                                                                 02624900
PCR072     EXEC SQL                                                     02625000
PCR072        INCLUDE TBRCNCHR                                          02625100
PCR072     END-EXEC.                                                    02625200
                                                                        
PCR307     EXEC SQL                                                             
PCR307        INCLUDE TBSODNPC                                                  
PCR307     END-EXEC.                                                            
PCR360*                                                                 02625300
TP9728******************************************************************02625400
TP9728*    CSS_WO_ARRANGEMENT                                           02625500
TP9728******************************************************************02625600
TP9728*                                                                 02625700
TP9728     EXEC SQL                                                     02625800
TP9728         INCLUDE TBWOARGM                                         02625900
TP9728     END-EXEC.                                                    02626000
      *                                                                 02626100
                                                                        
NONUTL******************************************************************02626300
NONUTL*    CSS_HOLIDAY                                                  02626400
NONUTL******************************************************************02626500
NONUTL     EXEC SQL                                                     02626600
NONUTL         INCLUDE TBHLDAY                                          02626700
NONUTL     END-EXEC.                                                    02626800
NONUTL     EXEC SQL                                                     02627000
NONUTL         INCLUDE TBGTNTR                                          02627100
NONUTL     END-EXEC.                                                    02627200
                                                                        
NONUTL     EXEC SQL                                                     02627500
NONUTL         INCLUDE TBMSTSUB                                         02627600
NONUTL     END-EXEC.                                                    02627700
      *                                                                 02627800
T33431     EXEC SQL                                                             
T33431       INCLUDE TBJBPARM                                                   
T33431     END-EXEC.                                                            
      *                                                                 02628500
           EXEC SQL                                                     02628600
A00956        INCLUDE CWS0013B                                          02628700
           END-EXEC.                                                    02628800
      *                                                                 02628900
C29752/*****                                                                    
C29752     EXEC SQL                                                             
C29752         INCLUDE CWS0223B                                                 
C29752     END-EXEC.                                                            
      *                                                                 02628900
C29752     EXEC SQL                                                             
C29752         INCLUDE CWS0024B                                                 
C29752     END-EXEC.                                                            
C29752                                                                  
           EXEC SQL                                                     02629000
              INCLUDE CWS00017                                          02629100
           END-EXEC.                                                    02630000
      *                                                                 02640000
           EXEC SQL                                                     02650000
              INCLUDE CWS00061                                          02660000
           END-EXEC.                                                    02670000
      *                                                                 02680000
           EXEC SQL                                                     02690000
              INCLUDE CWS00068                                          02700000
           END-EXEC.                                                    02710000
      *                                                                 02720000
           EXEC SQL                                                     02730000
              INCLUDE CWS00073                                          02740000
           END-EXEC.                                                    02750000
      *                                                                 02751000
           EXEC SQL                                                     02752000
              INCLUDE CWS0090A                                          02753000
           END-EXEC.                                                    02754000
      *                                                                 02760000
      ******************************************************************02770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02780000
      ******************************************************************02790000
      *                                                                 02800000
      * ADDED FOR JOURNALING                                            02840000
      *                                                                 02841000
           COPY CCA00001.                                               02850000
           COPY CJF00101.                                               02860000
ACT105     COPY CWS00077.                                                       
           COPY CJF00102.                                               02870000
           COPY CJF00105.                                               02871000
           COPY CWS00071.                                               02880000
           COPY CWS00004.                                               02881000
           COPY CWS00007.                                               02890000
T11466     EXEC SQL                                                     02900000
T11466        INCLUDE CWS00008                                          02901000
T11466     END-EXEC.                                                    02902000
T19557     COPY CWS0068L.                                                       
T24436     COPY CWS0061L.                                                       
           COPY CWS00027.                                               02920000
           COPY CWS00056.                                               02930000
           COPY CWS00100.                                               02940000
           COPY CWS00303.                                               02950000
T33431     COPY CWSCA225.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*                                                                         
NONUTL******************************************************************02952000
NONUTL*    HOLIDAY CHECK                                                02953000
NONUTL******************************************************************02954000
NONUTL     EXEC SQL                                                     02955000
NONUTL         INCLUDE CWS10016                                         02956000
NONUTL     END-EXEC.                                                    02957000
      *                                                                 02960000
      ******************************************************************02970000
      *    WORK AREAS                                                  *02980000
      ******************************************************************02990000
      *                                                                 03000000
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                 03130000
       01  PARM-FIELDS.                                                 
           05  PARM-COMMENTS.                                           
REARCH         10  PARM-COMMENTS-LEN                                    
                                   PIC S9(04) COMP SYNC VALUE +0.       
REARCH         10  PARM-COMMENTS-TEXT  PIC X(72) VALUE SPACES.          
REARCH     05  PARM-BALANCE-AMT-TEMP   PIC X(11).                       
REARCH     05  PARM-BALANCE-AMT-NUM    REDEFINES PARM-BALANCE-AMT-TEMP  
                                       PIC 9(09)V99.                    
REARCH     05  PARM-THIS-CR-AMT-TEMP   PIC X(11).                       
REARCH     05  PARM-THIS-CR-AMT-NUM    REDEFINES PARM-THIS-CR-AMT-TEMP  
                                       PIC 9(09)V9(2).                  
REARCH     05  PARM-SPEC-CR-AMT-TEMP   PIC X(11).                       
REARCH     05  PARM-SPEC-CR-AMT-NUM    REDEFINES PARM-SPEC-CR-AMT-TEMP  
                                       PIC 9(09)V9(2).                  
REARCH     05  PARM-AMT-CHK-TEMP       PIC X(11).                       
REARCH     05  PARM-AMT-CHK-NUM        REDEFINES PARM-AMT-CHK-TEMP      
                                       PIC 9(09)V9(2).                  
REARCH     05  PARM-AMT-CASH-TEMP      PIC X(11).                       
REARCH     05  PARM-AMT-CASH-NUM       REDEFINES PARM-AMT-CASH-TEMP     
                                       PIC 9(09)V9(2).                  
REARCH     05  PARM-CASH-DRAWER-ID-TMP PIC X(04).                       
REARCH     05  PARM-CASH-DRWR-ID-NUM   REDEFINES PARM-CASH-DRAWER-ID-TMP
                                       PIC 9(04).                       
           05  PARM-TRAN-COMMENT.                                       
REARCH         10  PARM-TRAN-COMMENT-LEN                                
                                   PIC S9(04) COMP SYNC VALUE +0.       
REARCH         10  PARM-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.      
REARCH     05  PARM-INTEREST-AMOUNT-TMP PIC X(11).                      
REARCH     05  PARM-INTEREST-AMOUNT-NUM REDEFINES                       
REARCH         PARM-INTEREST-AMOUNT-TMP PIC 9(09)V9(2).                 
      *                                                                 03700000
       01  WS-SAVE-DEP-ON-HAND.                                         
COB305     05 WS-DO-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05 WS-DO-DEPOSIT-CERT-NO      PIC S9(9) USAGE COMP.          
COB305     05 WS-DO-AMT-DEPOSIT        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-DO-DATE-INTST-CALC-TO   PIC X(10).                     
COB305     05 WS-DO-INTRST-YTD        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-DO-TOTAL-INTRST        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-DO-CODE-REFUND-STATUS   PIC X(1).                      
           05 WS-DO-CODE-REFUND-REASON   PIC X(1).                      
           05 WS-DO-DEPOSIT-STATUS-CD    PIC X(1).                      
COB305     05 WS-DO-AMT-REFUNDED        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.    
      *                                                                 03820000
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
ACT105     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT105     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT105         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT105         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
T21024     05  WS-LAST-UPDATE-TS       PIC X(26).                       
           05  WS-LAST-REFUND-ITEM-ID      PIC S9(9) USAGE COMP.        
           05  WS-NEW-ADDRESS-ID       PIC 9(13) VALUE ZERO.            
           05  ONE-YEAR                    PIC S9(03) COMP VALUE 365.   
COB305     05 WS-INTEREST-REMAIN        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305     05 WS-AMT-TRAN-BALANCE        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-SUMM-AMT-TRAN-BALANCE        PIC S9(09)V99 
COB305       USAGE COMP-3 VALUE 0.  
COB305     05 WS-THIS-AR-AMOUNT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-SPEC-AR-AMOUNT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO        PIC X(02).                   
               10  WS-CD-LOCAL-OFFICE      PIC X(03).                   
               10  WS-CD-REPORT-NO         PIC X(03).                   
               10  WS-CD-REPORT-DATE       PIC X(10).                   
               10  WS-CASH-DRAWER-ID       PIC S9(04) COMP.             
           05  WS-GL-ACCT-NAME-CR          PIC X(10).                   
           05  WS-GL-ACCT-NAME-DB          PIC X(10).                   
COB305     05 WS-AU-AMOUNT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.  
           05  WS-AMT-BILLED-UNPAID        PIC S9(09)V99 USAGE COMP-3   
                                           VALUE 0.                     
           05  WS-THIS-ACCOUNT-SW          PIC X(01) VALUE 'Y'.         
               88 WS-THIS-ACCOUNT          VALUE 'Y'.                   
               88 WS-SPEC-ACCOUNT          VALUE 'N'.                   
PCR482     05  WS-SPEC-CR-FLAG             PIC X(01) VALUE 'N'.         
PCR482         88 NOT-SPECIFIED-CREDIT     VALUE 'N'.                   
PCR482     05  WS-UPDATE-FLAG              PIC X(01) VALUE 'N'.         
PCR482         88 UPDATE-IS-NEEDED         VALUE 'Y'.                   
           05  WS-THIS-TRAN-APPL-NO    PIC S9(4) USAGE COMP.            
           05  WS-SPEC-TRAN-APPL-NO    PIC S9(4) USAGE COMP.            
           05  WS-THIS-TIMESTAMP       PIC X(26)  VALUE SPACES.         
           05  WS-SPEC-TIMESTAMP       PIC X(26)  VALUE SPACES.         
           05  WS-DEP-REQ-EXISTS       PIC X(01)  VALUE 'N'.            
           05  WS-DEP-ON-HAND-EXISTS   PIC X(01)  VALUE 'N'.            
           05  WS-CHECK-AMOUNT         PIC 9(09)V9(2) VALUE 0.          
T19068     05  WS-CASH-AMOUNT          PIC 9(09)V9(2) VALUE 0.          
PCR482     05  WS-TOTAL-PAYMENTS       PIC S9(09)V9(2) COMP-3 VALUE 0.  
PCR526     05  WS-FROM-ACCT-COMMENT.                                    
PCR526         10  FILLER              PIC X(26)  VALUE                 
PCR526             'APPLIED TO SPECIFIC ACCT: '.                        
PCR526         10  WS-TO-ACCT-NUM-CM   PIC X(13).                       
PCR526         10  FILLER              PIC X(11)  VALUE                 
PCR526             '; AMOUNT: $'.                                       
PCR526         10  WS-FROM-ACCT-AMT-CM PIC ZZZ,ZZZ,ZZ9.99.              
PCR526         10  FILLER              PIC X(01)  VALUE                 
PCR526             ';'.                                                 
PCR526     05  WS-TO-ACCT-COMMENT.                                      
PCR526         10  FILLER              PIC X(34)  VALUE                 
PCR526             'APPLIED DEPOSIT REFUND FROM ACCT: '.                
PCR526         10  WS-FROM-ACCT-NUM-CM PIC X(13).                       
PCR526         10  FILLER              PIC X(01)  VALUE                 
PCR526             ';'.                                                 
                                                                        
PCR526     05  WS-STARTING-POS          PIC S9(04) COMP.                
PCR526     05  WS-COUNT                 PIC S9(04) COMP.                
T20346     05  WS-AR-AMT                PIC S9(11)V99 COMP-3 VALUE 0.   
T20346     05  WS-CURR-FULL-BAL         PIC S9(11)V99 COMP-3 VALUE 0.   
T19557     05  WS-EIBRESP               PIC S9(8)  COMP SYNC VALUE 0.   
A36248     05  WS-DNP-UPDATE-FL         PIC X(01)  VALUE 'N'.           
P0087A     05  WS-AMT-REFUNDED          PIC S9(11)V99 COMP-3 VALUE 0.   
      *                                                                 04290000
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
PCR307     05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  WS-NO-ERROR              PIC  X(05) VALUE 'NOERR'.       
T20346     05  WS-CIA                   PIC  X(04) VALUE '0070'.        
REARCH     05  MCSCA182                 PIC X(08)  VALUE 'MCSCA182'.    
T33431     05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
T33431     05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
A00870     05  WS-DEP-DET-FOUND         PIC X(01)  VALUE 'N'.           
      *                                                                 04750000
PCR360 01  WS-NULL-IND-VARS.                                            
PCR360     05  WS-NULL-INDICATOR-1      PIC S9(04) COMP.                
PCR360     05  WS-NULL-INDICATOR-2      PIC S9(04) COMP.                
PCR360     05  WS-NULL-INDICATOR-3      PIC S9(04) COMP.                
PCR360     05  WS-NULL-INDICATOR-4      PIC S9(04) COMP.                
C29752     05  WS-NULL-INDICATOR-5       PIC S9(04) COMP.               
T20626     05  WS-RN-NULL-IND-1         PIC S9(04) COMP.                
T11846     05  DATE-CREDIT-ACTION-NI    PIC S9(04) COMP.                
T11846     05  DATE-NOTICE-MAIL-NI      PIC S9(04) COMP.                
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
      *                                                                 04890000
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 04930000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 04990000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 05010000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ERROR-MESSAGE-NO     PIC X(05) VALUE SPACES.          
PCR360     05  RS-CANCELDNP-FLAG       PIC X(01) VALUE SPACES.          
PCR360     05  RS-CANCELDNP-TO-FLAG    PIC X(01) VALUE SPACES.          
T24367     05  RS-CANCELNOT-FLAG       PIC X(01) VALUE SPACES.          
T24367     05  RS-CANCELNOT-TO-FLAG    PIC X(01) VALUE SPACES.          
      *                                                                 05050000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-ERROR-MESSAGE-NO      PIC X(05) VALUE SPACES.          
REARCH     05  S-CANCELDNP-FLAG        PIC X(01) VALUE SPACES.          
REARCH     05  S-CANCELDNP-TO-FLAG     PIC X(01) VALUE SPACES.          
REARCH     05  S-CANCELNOT-FLAG        PIC X(01) VALUE SPACES.          
REARCH     05  S-CANCELNOT-TO-FLAG     PIC X(01) VALUE SPACES.          
REARCH*                                                                 05050000
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-REFUND-ITEM-ID-NI      PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-INTST-CALC-TO-NI  PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-CALC-FROM-NI      PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-ORIG-PYMT-IND     PIC S9(4) COMP VALUE 0.        
           05  WS-DEP-PAY-DT-NI          PIC S9(4) COMP VALUE 0.        
PCR482     05  WS-DATE-CERT-ISSUE-NI     PIC S9(4) COMP VALUE 0.        
PCR482     05  WS-TOTAL-PAYMENTS-NI      PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-PYMT-START-NI     PIC S9(4) COMP VALUE 0.        
      *                                                                 05170000
       01  WS-REFUND-TYPE.                                              
           05  WS-DEPOSIT-ONLY           PIC X(01) VALUE 'D'.           
           05  WS-DEP-AND-INTR           PIC X(01) VALUE 'A'.           
           05  WS-INTEREST-ONLY          PIC X(01) VALUE 'I'.           
      *                                                                 05220000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
C32206     05  WS-REFUND-REAS-EXISTS   PIC X(01) VALUE 'N'.             
      *                                                                 05300000
       01  WS-MISC1.                                                    
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
                                                                        
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02171'.     
REARCH     05  EIBTRNID                 PIC X(04) VALUE 'S171'.         
REARCH     05  MCSCO061                 PIC X(08) VALUE 'MCSCO061'.     
REARCH     05  MCSCB068                 PIC X(08) VALUE 'MCSCB068'.     
A36248     05  MCSCB371                 PIC X(08) VALUE 'MCSCB371'.     
      *                                                                 05360000
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
T21024 COPY CWS00182.                                                           
      *                                                                 05380000
      ******************************************************************05390000
      * CURSOR DECLARATION                                             *05400000
      ******************************************************************05410000
      *                                                                 05420000
           EXEC SQL                                                     
              DECLARE DEP_PAY_HST CURSOR FOR                            
              SELECT DEP_PAY_DT, DEP_PAY_AMT                            
              FROM   CSS_DEP_PAY_HST WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO    = :DP-ACCOUNT-NO   AND               
                     DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO              
              ORDER BY DEP_PAY_DT                                       
              FOR READ ONLY                                     
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05540000
MFA-TR*       DECLARE DEP_PAY_HST CURSOR FOR                            05550000
MFA-TR*       SELECT DEP_PAY_DT, DEP_PAY_AMT                            05560000
MFA-TR*       FROM   CSS_DEP_PAY_HST                                    05570000
MFA-TR*       WHERE  ACCOUNT_NO    = :DP-ACCOUNT-NO   AND               05580000
MFA-TR*              DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO              05590000
MFA-TR*       ORDER BY DEP_PAY_DT                                       05600000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                    05610000
      *                                                                 05620000
           EXEC SQL                                                     
              DECLARE DEP_ON_HAND CURSOR FOR                            
              SELECT DEPOSIT_CERT_NO,                                   
                     AMT_DEPOSIT,                                       
                     AMT_REFUNDED,                                      
                     INTRST_YTD,                                        
                     TOTAL_INTRST,                                      
                     DATE_PYMT_START,                                   
                     DATE_INTST_CALC_TO,                                
                     CODE_REFUND_STATUS,                                
                     CODE_REFUND_REASON,                                
                     DEPOSIT_STATUS_CD,                                 
PCR482               DATE_CERT_ISSUE                                    
              FROM   CSS_DEP_ON_HAND                                    
              WHERE  ACCOUNT_NO = :DO-ACCOUNT-NO AND                    
                     SERVICE_TYPE_CD = :DO-SERVICE-TYPE-CD AND          
PCR482               DEPOSIT_STATUS_CD IN ('A','P') AND                 
PCR482               DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO              
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     05630000
MFA-TR*       DECLARE DEP_ON_HAND CURSOR FOR                            05640000
MFA-TR*       SELECT DEPOSIT_CERT_NO,                                   05650000
MFA-TR*              AMT_DEPOSIT,                                       05660000
MFA-TR*              AMT_REFUNDED,                                      05670000
MFA-TR*              INTRST_YTD,                                        05680000
MFA-TR*              TOTAL_INTRST,                                      05690000
MFA-TR*              DATE_PYMT_START,                                   05700000
MFA-TR*              DATE_INTST_CALC_TO,                                05710000
MFA-TR*              CODE_REFUND_STATUS,                                05730000
MFA-TR*              CODE_REFUND_REASON,                                05740000
MFA-TR*              DEPOSIT_STATUS_CD,                                 05750000
MFA-TR*              DATE_CERT_ISSUE                                    05751000
MFA-TR*       FROM   CSS_DEP_ON_HAND                                    05760000
MFA-TR*       WHERE  ACCOUNT_NO = :DO-ACCOUNT-NO AND                    05770000
MFA-TR*              SERVICE_TYPE_CD = :DO-SERVICE-TYPE-CD AND          05780000
MFA-TR*              DEPOSIT_STATUS_CD IN ('A','P') AND                 05790000
MFA-TR*              DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO              05791000
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC.                                                    05800000
      *                                                                 05810000
           EXEC SQL                                                     
              DECLARE DEP_REQ CURSOR FOR                                
              SELECT   'Y'                                              
              FROM     CSS_DEP_REQ WITH(READUNCOMMITTED)                        
              WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 
                       PYMT_PRIORITY_LVL = 080                          
A36248        FOR READ ONLY                                     
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05820000
MFA-TR*       DECLARE DEP_REQ CURSOR FOR                                05830000
MFA-TR*       SELECT   'Y'                                              05840000
MFA-TR*       FROM     CSS_DEP_REQ                                      05850000
MFA-TR*       WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 05860000
MFA-TR*                PYMT_PRIORITY_LVL = 080                          05870000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                    05880000
      *                                                                 05890000
           EXEC SQL                                                     
              DECLARE DEP_EXISTS  CURSOR FOR                            
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD IN ('A', 'P')                  
P00641                                                      
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE DEP_EXISTS  CURSOR FOR                            05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 05940000
MFA-TR*                DEPOSIT_STATUS_CD IN ('A', 'P')                  05950000
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                 05970000
T21024 LINKAGE SECTION.                                                 
REARCH 01  PARM-ACTION-CODE             PIC X(01).                      
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
REARCH 01  PARM-PREMISE-NO              PIC X(10).                      
REARCH 01  PARM-SERVICE-TYPE-CD         PIC X(01).                      
REARCH 01  PARM-DEPOSIT-CERT-NO         PIC X(09).                      
REARCH 01  PARM-CODE-REFUND-REASON      PIC X(01).                      
C32206 01  PARM-CHECK-ISS-REAS-CD       PIC X(02).                      
REARCH 01  PARM-CMNTS-LEN               PIC S9(04) COMP.                
REARCH 01  PARM-CMNTS-TEXT              PIC X(72).                      
REARCH 01  PARM-BALANCE-AMT             PIC X(11).                      
REARCH 01  PARM-THIS-CR-AMT             PIC X(11).                      
REARCH 01  PARM-THIS-AR-TYPE            PIC X(04).                      
REARCH 01  PARM-THIS-ITEM-ID            PIC X(09).                      
REARCH 01  PARM-SPEC-ACCOUNT-NO         PIC X(13).                      
REARCH 01  PARM-SPEC-CR-AMT             PIC X(11).                      
REARCH 01  PARM-SPEC-AR-TYPE            PIC X(04).                      
REARCH 01  PARM-SPEC-ITEM-ID            PIC X(09).                      
REARCH 01  PARM-AMT-CHK                 PIC X(11).                      
REARCH 01  PARM-AMT-CASH                PIC X(11).                      
REARCH 01  PARM-CASHIER-CODE            PIC X(02).                      
REARCH 01  PARM-ADDRESS-CHANGED         PIC X(01).                      
C35671 01  PARM-ADDR-STREET             PIC X(55).                      
C35671 01  PARM-ADDR-CITY-STATE         PIC X(30).                      
REARCH 01  PARM-ADDR-ZIP-CODE           PIC X(09).                      
REARCH 01  PARM-ADDR-COUNTRY            PIC X(35).                      
REARCH 01  PARM-ADDRESS-OVERFLOW        PIC X(35).                      
REARCH 01  PARM-SUPERVISOR-ID           PIC X(09).                      
REARCH 01  PARM-APPROVE-IND             PIC X(01).                      
REARCH 01  PARM-CD-COMPANY-NO           PIC X(02).                      
REARCH 01  PARM-CD-LOCAL-OFFICE         PIC X(03).                      
REARCH 01  PARM-CD-REPORT-DATE          PIC X(10).                      
REARCH 01  PARM-CD-REPORT-NO            PIC X(03).                      
REARCH 01  PARM-CASH-DRAWER-ID          PIC X(04).                      
REARCH 01  PARM-USER-ID                 PIC X(09).                      
REARCH 01  PARM-RESP-AREA-ID            PIC X(03).                      
REARCH 01  PARM-TRAN-CMNT-LEN           PIC S9(04) COMP.                
REARCH 01  PARM-TRAN-CMNT-TEXT          PIC X(210).                     
REARCH 01  PARM-CSR-PC-ID               PIC X(04).                      
REARCH 01  PARM-REFUND-TYPE             PIC X(01).                      
REARCH 01  PARM-INTEREST-AMOUNT         PIC X(11).                      
REARCH 01  PARM-SUPERUSER-CD            PIC X(01).                      
REARCH 01  PARM-APPROVE-CHK-IND         PIC X(01).                      
REARCH 01  PARM-LAST-UPDATE-TS          PIC X(26).                      
REARCH 01  PARM-REQUEST-DATE            PIC X(10).                      
T21024*                                                                 05970000
REARCH PROCEDURE DIVISION USING  PARM-ACTION-CODE                       
REARCH                           PARM-ACCOUNT-NO                        
REARCH                           PARM-PREMISE-NO                        
REARCH                           PARM-SERVICE-TYPE-CD                   
REARCH                           PARM-DEPOSIT-CERT-NO                   
REARCH                           PARM-CODE-REFUND-REASON                
REARCH                           PARM-CHECK-ISS-REAS-CD                 
REARCH                           PARM-CMNTS-LEN                         
REARCH                           PARM-CMNTS-TEXT                        
REARCH                           PARM-BALANCE-AMT                       
REARCH                           PARM-THIS-CR-AMT                       
REARCH                           PARM-THIS-AR-TYPE                      
REARCH                           PARM-THIS-ITEM-ID                      
REARCH                           PARM-SPEC-ACCOUNT-NO                   
REARCH                           PARM-SPEC-CR-AMT                       
REARCH                           PARM-SPEC-AR-TYPE                      
REARCH                           PARM-SPEC-ITEM-ID                      
REARCH                           PARM-AMT-CHK                           
REARCH                           PARM-AMT-CASH                          
REARCH                           PARM-CASHIER-CODE                      
REARCH                           PARM-ADDRESS-CHANGED                   
REARCH                           PARM-ADDR-STREET                       
REARCH                           PARM-ADDR-CITY-STATE                   
REARCH                           PARM-ADDR-ZIP-CODE                     
REARCH                           PARM-ADDR-COUNTRY                      
REARCH                           PARM-ADDRESS-OVERFLOW                  
REARCH                           PARM-SUPERVISOR-ID                     
REARCH                           PARM-APPROVE-IND                       
REARCH                           PARM-CD-COMPANY-NO                     
REARCH                           PARM-CD-LOCAL-OFFICE                   
REARCH                           PARM-CD-REPORT-DATE                    
REARCH                           PARM-CD-REPORT-NO                      
REARCH                           PARM-CASH-DRAWER-ID                    
REARCH                           PARM-USER-ID                           
REARCH                           PARM-RESP-AREA-ID                      
REARCH                           PARM-TRAN-CMNT-LEN                     
REARCH                           PARM-TRAN-CMNT-TEXT                    
REARCH                           PARM-CSR-PC-ID                         
REARCH                           PARM-REFUND-TYPE                       
REARCH                           PARM-INTEREST-AMOUNT                   
REARCH                           PARM-SUPERUSER-CD                      
REARCH                           PARM-APPROVE-CHK-IND                   
REARCH                           PARM-LAST-UPDATE-TS                    
REARCH                           PARM-REQUEST-DATE.                     

SCA006        SET WS-GL-SUB TO 1.
      *                                                                 05990000
      ******************************************************************06000000
      * 0000-MAINLINE                                                  *06010000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06020000
      ******************************************************************06030000
      *                                                                 06040000
       0000-MAINLINE.                                                   
      *                                                                 06060000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 06110000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06140000
      ******************************************************************06150000
      * 0100-INITIALIZE                                                *06160000
      *                                                                *06170000
      *     1. RESET DB2 ERROR HANDLERS                                *06180000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *06190000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *06200000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*06210000
      *                                                                *06220000
      ******************************************************************06230000
      *                                                                 06231000
       0100-INITIALIZE.                                                 
      *                                                                 06250000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 06290000
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE                AS RETURN_CODE          
REARCH           ,LTRIM(RTRIM(:S-ERROR-MESSAGE-NO))    AS 
           ERROR_MESSAGE_NO     
REARCH           ,LTRIM(RTRIM(:S-CANCELDNP-FLAG))      AS CANCELDNP_FLAG       
REARCH           ,LTRIM(RTRIM(:S-CANCELDNP-TO-FLAG))   AS 
           CANCELDNP_TO_FLAG    
REARCH           ,LTRIM(RTRIM(:S-CANCELNOT-FLAG))      AS CANCELNOT_FLAG       
REARCH           ,LTRIM(RTRIM(:S-CANCELNOT-TO-FLAG))   AS 
           CANCELNOT_TO_FLAG    
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE                AS RETURN_CODE                  
MFA-TR*          ,STRIP(:S-ERROR-MESSAGE-NO)    AS ERROR_MESSAGE_NO             
MFA-TR*          ,STRIP(:S-CANCELDNP-FLAG)      AS CANCELDNP_FLAG               
MFA-TR*          ,STRIP(:S-CANCELDNP-TO-FLAG)   AS CANCELDNP_TO_FLAG            
MFA-TR*          ,STRIP(:S-CANCELNOT-FLAG)      AS CANCELNOT_FLAG               
MFA-TR*          ,STRIP(:S-CANCELNOT-TO-FLAG)   AS CANCELNOT_TO_FLAG            
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06490000
      ******************************************************************06520000
      * 1000-PROCESS-INPUT.                                            *06530000
      *                                                                *06540000
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *06550000
      *     2.  FORMAT PACKED NUMERICS.                                *06560000
      *                                                                *06570000
      ******************************************************************06580000
      *                                                                 06581000
       1000-PROCESS-INPUT.                                              
      *                                                                 06600000
T21024     INITIALIZE SCSCA182-LINK-RECORD.                             
REARCH     MOVE PARM-CMNTS-LEN              TO PARM-COMMENTS-LEN.       
REARCH     MOVE PARM-CMNTS-TEXT             TO PARM-COMMENTS-TEXT.      
REARCH     MOVE PARM-BALANCE-AMT            TO PARM-BALANCE-AMT-TEMP.   
REARCH     MOVE PARM-THIS-CR-AMT            TO PARM-THIS-CR-AMT-TEMP.   
REARCH     MOVE PARM-SPEC-CR-AMT            TO PARM-SPEC-CR-AMT-TEMP.   
REARCH     MOVE PARM-AMT-CHK                TO PARM-AMT-CHK-TEMP.       
REARCH     MOVE PARM-AMT-CASH               TO PARM-AMT-CASH-TEMP.      
REARCH     MOVE PARM-CASH-DRAWER-ID         TO PARM-CASH-DRAWER-ID-TMP. 
REARCH     MOVE PARM-TRAN-CMNT-LEN          TO PARM-TRAN-COMMENT-LEN.   
REARCH     MOVE PARM-TRAN-CMNT-TEXT         TO PARM-TRAN-COMMENT-TEXT.  
REARCH     MOVE PARM-INTEREST-AMOUNT        TO PARM-INTEREST-AMOUNT-TMP.
           MOVE PARM-AMT-CHK-NUM            TO WS-CHECK-AMOUNT.         
T19068     MOVE PARM-AMT-CASH-NUM           TO WS-CASH-AMOUNT.          
FCS        MOVE PARM-CD-COMPANY-NO          TO WS-CD-COMPANY-NO.        
FCS        MOVE PARM-CD-LOCAL-OFFICE        TO WS-CD-LOCAL-OFFICE.      
FCS        MOVE PARM-CD-REPORT-DATE         TO WS-CD-REPORT-DATE.       
FCS        MOVE PARM-CD-REPORT-NO           TO WS-CD-REPORT-NO.         
FCS        MOVE PARM-CASH-DRWR-ID-NUM       TO WS-CASH-DRAWER-ID.       
P353       MOVE PARM-CSR-PC-ID              TO WS-JRNL-OL-CSR-PC-ID.    
T21024     MOVE PARM-ACCOUNT-NO             TO SCSCA182-ACCOUNT-NO.     
                                                                        
                                                                        
                                                                        
      *                                                                 06680000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10480000
      ******************************************************************10490000
      *   2000-PROCESS-OUTPUT                                          *10500000
      *                                                                *10510000
      *       1. DESCRIBE RESULT SET                                   *10520000
      *       2. UPDATE DB2 DATA                                       *10530000
      *       3. BUILD RESULT SET                                      *10540000
      *       4. SEND RESULT SET                                       *10550000
      *                                                                *10560000
      ******************************************************************10570000
      *                                                                 10571000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 10590000
T10685     PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
T10685     IF AL-AR-LOCKOUT-IND = 'Y'                                   
T10685        MOVE 5000 TO RS-RETURN-CODE                               
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO   CTR-ROWS               
T10685        GO TO 2000-EXIT                                           
T10685     END-IF.                                                      
      *                                                                 10609000
T21024     PERFORM 9200-LINK-SCSCA182          THRU 9200-EXIT.          
T21024     IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                      
T21024         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
T21024         MOVE SCSCA182-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE 
T21024                                            SQLCODE               
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
REARCH         ADD +1                          TO   CTR-ROWS            
T21024         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21024         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21024     ELSE                                                         
T21024         MOVE SCSCA182-LAST-UPDATE-TS    TO WS-LAST-UPDATE-TS     
T21024         IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS              
T21024             NEXT SENTENCE                                        
T21024         ELSE                                                     
T21024             MOVE 5272                   TO RS-RETURN-CODE        
REARCH             PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
REARCH             ADD +1                      TO   CTR-ROWS            
T21024             GO TO 2000-EXIT                                      
T21024         END-IF                                                   
T21024     END-IF.                                                      
      *                                                                 10609000
           MOVE SPACES                     TO WS-PAR-MESSAGE-NO.        
      *                                                                 10620000
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
      *                                                                 10640000
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-PAR-MESSAGE-NO          TO RS-ERROR-MESSAGE-NO.      
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
PCR360     MOVE WS-NO                      TO RS-CANCELDNP-FLAG         
PCR360                                        RS-CANCELDNP-TO-FLAG      
T24367                                        RS-CANCELNOT-FLAG         
T24367                                        RS-CANCELNOT-TO-FLAG.     
PCR360     MOVE WS-YES                     TO CALC-DNP-BAL-SW           
PCR360                                     CALC-ARREARS-SW              
PCR360                                     CALC-BALANCE-SW              
T24367                                     CALC-NOT-BAL-SW.             
PCR360     MOVE WS-CURRENT-DATE            TO WS-HOLD-DATE.             
PCR360     MOVE PARM-ACCOUNT-NO            TO AT-ACCOUNT-NO.            
      *                                                                 10687200
PCR360     PERFORM 7010-CHECK-PENDING-DNP  THRU 7010-EXIT.              
      *                                                                 10687400
PCR360     IF WS-CODE-PENDING-DNP EQUAL WS-A                            
T19557         PERFORM 9450-LINK-SCSCO068  THRU 9450-EXIT               
PCR360         IF WS-AMT-DNP-BAL EQUAL ZEROS                            
PCR360             MOVE WS-YES             TO RS-CANCELDNP-FLAG         
PCR360         ELSE                                                     
PCR360             MOVE WS-NO              TO RS-CANCELDNP-FLAG         
A36248             IF CSR-DATABASE-CPD68                                
A36248                MOVE 'Y'             TO WS-DNP-UPDATE-FL          
A36248             END-IF                                               
PCR360         END-IF                                                   
T24367         IF WS-AMT-NOT-BAL EQUAL ZEROS                            
T24367             MOVE WS-YES             TO RS-CANCELNOT-FLAG         
T24367         ELSE                                                     
T24367             MOVE WS-NO              TO RS-CANCELNOT-FLAG         
T24367         END-IF                                                   
T24367     ELSE                                                         
T24367         PERFORM 9450-LINK-SCSCO068  THRU 9450-EXIT               
T24367         IF WS-AMT-NOT-BAL EQUAL ZEROS                            
T24367             MOVE WS-YES             TO RS-CANCELNOT-FLAG         
T24367         ELSE                                                     
T24367             MOVE WS-NO              TO RS-CANCELNOT-FLAG         
T24367         END-IF                                                   
PCR360     END-IF.                                                      
PCR360*                                                                 10689600
PCR360     IF PARM-SPEC-ACCOUNT-NO NOT EQUAL SPACES                     
PCR360         MOVE WS-YES                 TO CALC-DNP-BAL-SW           
PCR360                                         CALC-ARREARS-SW          
PCR360                                         CALC-BALANCE-SW          
T24367                                         CALC-NOT-BAL-SW          
PCR360         MOVE WS-CURRENT-DATE        TO WS-HOLD-DATE              
PCR360         MOVE PARM-SPEC-ACCOUNT-NO   TO AT-ACCOUNT-NO             
PCR360         PERFORM 7010-CHECK-PENDING-DNP THRU 7010-EXIT            
PCR360         IF WS-CODE-PENDING-DNP EQUAL WS-A                        
T19557             PERFORM 9450-LINK-SCSCO068                           
T19557                                     THRU 9450-EXIT               
PCR360             IF WS-AMT-DNP-BAL EQUAL ZEROS                        
PCR360                 MOVE WS-YES         TO RS-CANCELDNP-TO-FLAG      
PCR360             ELSE                                                 
PCR360                 MOVE WS-NO          TO RS-CANCELDNP-TO-FLAG      
PCR360             END-IF                                               
T24367             IF WS-AMT-NOT-BAL EQUAL ZEROS                        
T24367                 MOVE WS-YES         TO RS-CANCELNOT-TO-FLAG      
T24367             ELSE                                                 
T24367                 MOVE WS-NO          TO RS-CANCELNOT-TO-FLAG      
T24367             END-IF                                               
T24367         ELSE                                                     
T24367             PERFORM 9450-LINK-SCSCO068                           
T24367                                     THRU 9450-EXIT               
T24367             IF WS-AMT-NOT-BAL EQUAL ZEROS                        
T24367                 MOVE WS-YES         TO RS-CANCELNOT-TO-FLAG      
T24367             ELSE                                                 
T24367                 MOVE WS-NO          TO RS-CANCELNOT-TO-FLAG      
T24367             END-IF                                               
PCR360         END-IF                                                   
PCR360     END-IF.                                                      
PCR360*                                                                 10691400
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARCH     ADD +1                              TO   CTR-ROWS.           
A36248*                                                                         
A36248     IF WS-DNP-UPDATE-FL = 'Y'                                    
A36248        PERFORM 8999-ISSUE-COMMIT       THRU 8999-EXIT            
A36248        PERFORM 8555-CALL-MCSCB371      THRU 8555-EXIT            
A36248     END-IF.                                                      
      *                                                                 10692000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10720000
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-ERROR-MESSAGE-NO      TO S-ERROR-MESSAGE-NO.        
REARCH     MOVE  RS-CANCELDNP-FLAG        TO S-CANCELDNP-FLAG.          
REARCH     MOVE  RS-CANCELDNP-TO-FLAG     TO S-CANCELDNP-TO-FLAG.       
REARCH     MOVE  RS-CANCELNOT-FLAG        TO S-CANCELNOT-FLAG.          
REARCH     MOVE  RS-CANCELNOT-TO-FLAG     TO S-CANCELNOT-TO-FLAG.       
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 11220000
      ******************************************************************11230000
      *   5000-UPDATE.                                                 *11240000
      *                                                                *11250000
      *       1.   BASED ON THE ACTION CODE (INSERT/UPDATE/DELETE),    *11260000
      *            PERFORM FUNCTIONALITY.                              *11270000
      *                                                                *11280000
      ******************************************************************11290000
      *                                                                 11291000
       5000-UPDATE.                                                     
      *                                                                 11310000
PCR482     INITIALIZE RN-ACCT-NO-CREDITED                               
CSR501                RN-ADDRESS-ID.                                    
      *                                                                 11312000
           PERFORM 7000-GET-CURRENT-DATE           THRU 7000-EXIT.      
      *                                                                 11321000
           MOVE PARM-ACCOUNT-NO     TO AT-ACCOUNT-NO.                   
           MOVE PARM-PREMISE-NO     TO PR-PREMISE-NO.                   
      *                                                                 11341000
           PERFORM 7250-SELECT-ACCOUNT        THRU 7250-EXIT.           
           PERFORM 7260-SELECT-PREMISE        THRU 7260-EXIT.           
      *                                                                 11361000
TP5932     MOVE AT-COMPANY-NO              TO P6-COMPANY-NO             
TP5932                                        WS-100-COMPANY-NO.        
TP5932     MOVE AT-LOCAL-OFFICE            TO P6-LOCAL-OFFICE           
TP5932                                        WS-100-LOCAL-OFFICE-CD.   
           MOVE PR-REV-DISTRICT-CD         TO P6-REV-DISTRICT-CD.       
      *                                                                 11391000
           PERFORM 5250-LOAD-GL-NUMBERS    THRU 5250-EXIT.              
      *                                                                 11401000
           MOVE WS-CURRENT-DATE            TO WS-REFUND-DATE.           
      *                                                                 11420000
           IF PARM-ACTION-CODE = 'U' OR 'I'                             
              PERFORM 5600-EDIT-AR-TYPE            THRU 5600-EXIT       
      *                                                                 11441000
              IF WS-PAR-MESSAGE-NO > SPACES                             
                 GO TO 5000-EXIT                                        
              END-IF                                                    
      *                                                                 11480000
T20626        IF  PARM-REQUEST-DATE > SPACES                            
T20626            MOVE PARM-REQUEST-DATE   TO RN-REQUEST-DT             
T20626            MOVE +0                  TO WS-RN-NULL-IND-1          
T20626        ELSE                                                      
T20626            MOVE -1                  TO WS-RN-NULL-IND-1          
T20626        END-IF                                                    
              IF PARM-APPROVE-IND = SPACES                              
T19068           PERFORM 5010-CREATE-REFUND        THRU 5010-EXIT       
              END-IF                                                    
      *                                                                 11520000
              IF PARM-APPROVE-IND = 'D'                                 
                 PERFORM 5020-DISAPPROVE-REFUND    THRU 5020-EXIT       
              END-IF                                                    
      *                                                                 11560000
              IF PARM-APPROVE-IND = 'A'                                 
T20626           MOVE WS-CURRENT-DATE      TO RN-REQUEST-DT             
P0087A*          IF PARM-AMT-CASH-NUM > 0 AND PARM-CASHIER-CODE = SPACES11580000
P0087A*             PERFORM 5030-APPROVE-REFUND    THRU 5030-EXIT       11590000
P0087A*          ELSE                                                   11600000
                    PERFORM 5040-CLEAR-REFUND      THRU 5040-EXIT       
P0087A*          END-IF                                                 11620000
              END-IF                                                    
      *                                                                 11640000
           ELSE                                                         
              PERFORM 5050-DELETE-REFUND           THRU 5050-EXIT       
           END-IF.                                                      
      *                                                                 11680000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11710000
      ***************************************************************** 11720000
      * 5010-CREATE-REFUND                                            * 11730000
      *                                                               * 11740000
      *      WHEN THE REFUND REQUEST IS PENDING APPROVAL, CREATE      * 11750000
      *      REFUND REQUEST RECORDS IN CSS_REFUND TABLE. TWO RECORDS  * 11760000
      *      WILL BE CREATED ONE EACH FOR CASH AND CHECK              * 11770000
      ***************************************************************** 11780000
      *                                                                 11790000
       5010-CREATE-REFUND.                                              
      *                                                                 11810000
           MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED            
                                            RN-REFUND-STATUS-DT         
                                            WS-REFUND-DATE.             
           MOVE SPACES                   TO RN-USER-ID-APPRVD-BY.       
      *                                                                 11870000
           IF PARM-AMT-CHK-NUM > 0                                      
              MOVE 'R'                      TO RN-CHECK-STATUS-CD       
              MOVE 'M'                      TO RN-MANUAL-INDICATOR      
              MOVE PARM-AMT-CHK-NUM         TO RN-AMT-REFUNDED          
              PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT              
TP4783        MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
                                                                        
              MOVE 'A'                      TO WS-CODE-CHECK-REFUND     
              MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
              PERFORM 8520-UPDATE-ACCOUNT   THRU 8520-EXIT              
           END-IF.                                                      
      *                                                                 11930000
           IF PARM-AMT-CASH-NUM > 0                                     
              MOVE 'R'                      TO RN-CHECK-STATUS-CD       
              MOVE 'C'                      TO RN-MANUAL-INDICATOR      
              MOVE PARM-AMT-CASH-NUM        TO RN-AMT-REFUNDED          
              PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT              
T19068        MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
T19068        MOVE 'A'                      TO WS-CODE-CHECK-REFUND     
T19068        MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
T19068        PERFORM 8520-UPDATE-ACCOUNT   THRU 8520-EXIT              
           END-IF.                                                      
      *                                                                 11999400
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12020000
      ***************************************************************** 12030000
      * 5020-DISAPPROVE-REFUND                                        * 12040000
      *                                                               * 12050000
      *      WHEN THE SUPERVISOR DISAPPROVES THE REFUND REQUEST       * 12060000
      *      UPDATE CSS_REFUND TABLE WITH CHECK_STATUS_CD = 'D'       * 12070000
      *      FOR BOTH CHECK AND CASH RECORDS                          * 12080000
      ***************************************************************** 12090000
      *                                                                 12100000
       5020-DISAPPROVE-REFUND.                                          
      *                                                                 12120000
           MOVE PARM-ACCOUNT-NO       TO RN-ACCOUNT-NO.                 
PCR482     MOVE PARM-DEPOSIT-CERT-NO  TO RN-DEPOSIT-CERT-NO.            
           MOVE 'P259'                TO RN-PANEL-NO.                   
           MOVE 'R'                   TO RN-CHECK-STATUS-CD.            
      *                                                                 12151000
           IF PARM-AMT-CHK-NUM > 0                                      
              MOVE 'M'      TO RN-MANUAL-INDICATOR                      
              PERFORM 7110-SELECT-REFUND        THRU 7110-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'D'          TO RN-CHECK-STATUS-CD                
                 MOVE PARM-SUPERVISOR-ID      TO RN-USER-ID-APPRVD-BY   
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 8210-UPDATE-REFUND        THRU 8210-EXIT       
              ELSE                                                      
                 MOVE 'D'                      TO RN-CHECK-STATUS-CD    
                 MOVE ZEROES                   TO RN-AMT-REFUNDED       
                 MOVE PARM-SUPERVISOR-ID       TO RN-USER-ID-APPRVD-BY  
                 MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED      
                                                  RN-REFUND-STATUS-DT   
                                                  WS-REFUND-DATE        
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12310000
           MOVE 'R'                   TO RN-CHECK-STATUS-CD.            
      *                                                                 12321000
           IF PARM-AMT-CASH-NUM > 0                                     
              MOVE 'C'      TO RN-MANUAL-INDICATOR                      
              PERFORM 7110-SELECT-REFUND        THRU 7110-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'D'          TO RN-CHECK-STATUS-CD                
                 MOVE PARM-SUPERVISOR-ID      TO RN-USER-ID-APPRVD-BY   
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 8210-UPDATE-REFUND        THRU 8210-EXIT       
              ELSE                                                      
                 MOVE 'D'                      TO RN-CHECK-STATUS-CD    
                 MOVE ZEROES                   TO RN-AMT-REFUNDED       
                 MOVE PARM-SUPERVISOR-ID       TO RN-USER-ID-APPRVD-BY  
                 MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED      
                                                  RN-REFUND-STATUS-DT   
                                                  WS-REFUND-DATE        
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12480000
       5020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12510000
      ***************************************************************** 12520000
      * 5030-APPROVE-REFUND                                           * 12530000
      *                                                               * 12540000
      *     WHEN THE SUPERVISOR APPROVES THE REFUND REQUEST CHANGE    * 12550000
      *     THE STATUS TO 'A' FOR BOTH CHECK AND CASH                 * 12560000
      ***************************************************************** 12570000
      *                                                                 12580000
       5030-APPROVE-REFUND.                                             
      *                                                                 12600000
           IF PARM-AMT-CHK-NUM > 0                                      
              MOVE PARM-ACCOUNT-NO       TO RN-ACCOUNT-NO               
              MOVE 'P259'                TO RN-PANEL-NO                 
              MOVE 'R'                   TO RN-CHECK-STATUS-CD          
              MOVE 'M'                   TO RN-MANUAL-INDICATOR         
PCR482        MOVE PARM-DEPOSIT-CERT-NO  TO RN-DEPOSIT-CERT-NO          
                                                                        
T13084        MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
                                                                        
T13084        MOVE 'A'                      TO WS-CODE-CHECK-REFUND     
T13084        MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
T13084        PERFORM 8520-UPDATE-ACCOUNT   THRU 8520-EXIT              
                                                                        
              PERFORM 7110-SELECT-REFUND        THRU 7110-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE RN-DATE-REFUNDED     TO WS-REFUND-DATE            
                 MOVE PARM-SUPERVISOR-ID   TO RN-USER-ID-APPRVD-BY      
                 MOVE 'A'                  TO RN-CHECK-STATUS-CD        
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 8210-UPDATE-REFUND        THRU 8210-EXIT       
              ELSE                                                      
                 MOVE PARM-AMT-CHK-NUM         TO RN-AMT-REFUNDED       
                 MOVE PARM-SUPERVISOR-ID       TO RN-USER-ID-APPRVD-BY  
                 MOVE 'A'                      TO RN-CHECK-STATUS-CD    
                 MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED      
                                                  RN-REFUND-STATUS-DT   
                                                  WS-REFUND-DATE        
                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12890000
           IF PARM-AMT-CASH-NUM > 0                                     
              MOVE PARM-ACCOUNT-NO       TO RN-ACCOUNT-NO               
              MOVE 'P259'                TO RN-PANEL-NO                 
              MOVE 'R'                   TO RN-CHECK-STATUS-CD          
              MOVE 'C'                   TO RN-MANUAL-INDICATOR         
PCR482        MOVE PARM-DEPOSIT-CERT-NO  TO RN-DEPOSIT-CERT-NO          
T19068        MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
T19068        MOVE 'A'                   TO WS-CODE-CHECK-REFUND        
T19068        MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT       
T19068        PERFORM 8520-UPDATE-ACCOUNT   THRU 8520-EXIT              
              PERFORM 7110-SELECT-REFUND THRU 7110-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE RN-DATE-REFUNDED   TO WS-REFUND-DATE              
                 MOVE 'A'                TO RN-CHECK-STATUS-CD          
                 MOVE PARM-SUPERVISOR-ID TO RN-USER-ID-APPRVD-BY        
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
                 PERFORM 8210-UPDATE-REFUND        THRU 8210-EXIT       
              ELSE                                                      
                 MOVE PARM-AMT-CASH-NUM        TO RN-AMT-REFUNDED       
                 MOVE 'A'                      TO RN-CHECK-STATUS-CD    
                 MOVE PARM-SUPERVISOR-ID       TO RN-USER-ID-APPRVD-BY  
                 MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED      
                                                  RN-REFUND-STATUS-DT   
                                                  WS-REFUND-DATE        
                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 13180000
MAD620     IF PARM-SPEC-CR-AMT-NUM > 0                                  
  *           MOVE WS-YES             TO WS-SPEC-CR-FLAG                
  *           MOVE SPACES             TO RN-CHECK-STATUS-CD             
  *           MOVE 'B'                TO RN-MANUAL-INDICATOR            
  *           MOVE SPACES             TO RN-USER-ID-APPRVD-BY           
  *           MOVE PARM-SPEC-CR-AMT-NUM                                 
  *                                   TO RN-AMT-REFUNDED                
  *           MOVE PARM-SPEC-ACCOUNT-NO                                 
  *                                   TO RN-ACCT-NO-CREDITED            
  *           MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED               
  *                                      RN-REFUND-STATUS-DT            
  *                                      WS-REFUND-DATE                 
  *           PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT              
MAD620     END-IF.                                                      
      *                                                                 13189500
PCR482     INITIALIZE RN-ACCT-NO-CREDITED.                              
      *                                                                 13189700
MAD620     IF PARM-THIS-CR-AMT-NUM > 0                                  
  *           MOVE SPACES             TO RN-CHECK-STATUS-CD             
  *           MOVE 'A'                TO RN-MANUAL-INDICATOR            
  *           MOVE SPACES             TO RN-USER-ID-APPRVD-BY           
  *           MOVE PARM-THIS-CR-AMT-NUM                                 
  *                                   TO RN-AMT-REFUNDED                
  *           MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED               
  *                                      RN-REFUND-STATUS-DT            
  *                                      WS-REFUND-DATE                 
  *           PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT              
MAD620     END-IF.                                                      
      *                                                                 13193000
MAD620     IF PARM-BALANCE-AMT-NUM > 0                                  
  *           MOVE SPACES                TO RN-CHECK-STATUS-CD          
  *           MOVE 'E'                   TO RN-MANUAL-INDICATOR         
  *           MOVE SPACES                TO RN-USER-ID-APPRVD-BY        
  *           MOVE PARM-BALANCE-AMT-NUM  TO RN-AMT-REFUNDED             
  *           MOVE WS-CURRENT-DATE       TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *           PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT              
MAD620     END-IF.                                                      
      *                                                                 13195000
       5030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13210000
      ***************************************************************** 13220000
      * 5040-CLEAR-REFUND                                             * 13230000
      *                                                               * 13240000
      *     AFTER APPROVAL AND CASH PAYMENT UPDATE CSS_REFUND TABLE   * 13250000
      *     AND UPDATE AR-CNTL TABLE ALONG WITH AR-JOURNALS           * 13260000
      ***************************************************************** 13270000
      *                                                                 13280000
       5040-CLEAR-REFUND.                                               
      *                                                                 13300000
           IF PARM-AMT-CHK-NUM > 0                                      
              MOVE PARM-ACCOUNT-NO       TO RN-ACCOUNT-NO               
              MOVE 'P259'                TO RN-PANEL-NO                 
              MOVE 'M'                   TO RN-MANUAL-INDICATOR         
PCR482        MOVE PARM-DEPOSIT-CERT-NO  TO RN-DEPOSIT-CERT-NO          
T19068        PERFORM 7115-SELECT-REFUND        THRU 7115-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A01731           MOVE RN-DATE-REFUNDED         TO WS-CURRENT-DATE       
                 IF PARM-COMMENTS-TEXT = SPACES                         
                    MOVE ZERO                  TO RN-COMMENTS-LEN       
                 ELSE                                                   
                    MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
                 END-IF                                                 
                 MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
A01370           MOVE 'A'                      TO RN-CHECK-STATUS-CD    
                 PERFORM 8215-UPDATE-REFUND2       THRU 8215-EXIT       
              ELSE                                                      
                 MOVE PARM-AMT-CHK-NUM         TO RN-AMT-REFUNDED       
                 MOVE PARM-SUPERVISOR-ID       TO RN-USER-ID-APPRVD-BY  
                 MOVE 'A'                      TO RN-CHECK-STATUS-CD    
                 MOVE WS-CURRENT-DATE          TO RN-DATE-REFUNDED      
                                                  RN-REFUND-STATUS-DT   
                                                  WS-REFUND-DATE        
                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 13610000
           IF PARM-AMT-CASH-NUM > 0                                     
              MOVE PARM-ACCOUNT-NO        TO RN-ACCOUNT-NO              
              MOVE 'P259'                 TO RN-PANEL-NO                
              MOVE 'C'                    TO RN-MANUAL-INDICATOR        
PCR482        MOVE PARM-DEPOSIT-CERT-NO   TO RN-DEPOSIT-CERT-NO         
T19068        PERFORM 7115-SELECT-REFUND        THRU 7115-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
PCR052           MOVE RN-DATE-REFUNDED TO WS-REFUND-DATE                
PCR052           IF PARM-COMMENTS-TEXT = SPACES                         
PCR052              MOVE ZERO                  TO RN-COMMENTS-LEN       
PCR052           ELSE                                                   
PCR052              MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN       
PCR052           END-IF                                                 
                 MOVE 'I'                      TO RN-CHECK-STATUS-CD    
PCR052           MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT      
PCR052           PERFORM 8215-UPDATE-REFUND2       THRU 8215-EXIT       
T10266        ELSE                                                      
T10266             MOVE PARM-AMT-CASH-NUM      TO RN-AMT-REFUNDED       
T10266             MOVE 'I'                    TO RN-CHECK-STATUS-CD    
T10266             MOVE PARM-SUPERVISOR-ID     TO RN-USER-ID-APPRVD-BY  
T10266             MOVE WS-CURRENT-DATE        TO RN-DATE-REFUNDED      
T10266                                            RN-REFUND-STATUS-DT   
T10266                                            WS-REFUND-DATE        
T10266             PERFORM 5090-SET-UP-REFUND      THRU 5090-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 13730000
MAD620     IF PARM-BALANCE-AMT-NUM > 0                                  
  *           IF PARM-ACTION-CODE EQUAL 'U'                             
  *              IF PARM-APPROVE-CHK-IND EQUAL 'A'                      
  *                 MOVE SPACES          TO RN-CHECK-STATUS-CD          
  *                 MOVE 'E'             TO RN-MANUAL-INDICATOR         
  *                 MOVE SPACES          TO RN-USER-ID-APPRVD-BY        
  *                 MOVE PARM-BALANCE-AMT-NUM                           
  *                                      TO RN-AMT-REFUNDED             
  *                 MOVE WS-CURRENT-DATE TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT        
  *              ELSE                                                   
  *                 NEXT SENTENCE                                       
  *              END-IF                                                 
  *           ELSE                                                      
  *              MOVE SPACES             TO RN-CHECK-STATUS-CD          
  *              MOVE 'E'                TO RN-MANUAL-INDICATOR         
  *              MOVE SPACES             TO RN-USER-ID-APPRVD-BY        
  *              MOVE PARM-BALANCE-AMT-NUM                              
  *                                      TO RN-AMT-REFUNDED             
  *              MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *              PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
  *           END-IF                                                    
MAD620     END-IF.                                                      
      *                                                                 13733200
MAD620     IF PARM-SPEC-CR-AMT-NUM > 0                                  
  *           IF PARM-ACTION-CODE EQUAL 'U'                             
  *              IF PARM-APPROVE-CHK-IND EQUAL 'A'                      
  *                 MOVE SPACES          TO RN-CHECK-STATUS-CD          
  *                 MOVE 'B'             TO RN-MANUAL-INDICATOR         
  *                 MOVE SPACES          TO RN-USER-ID-APPRVD-BY        
  *                 MOVE PARM-SPEC-CR-AMT-NUM                           
  *                                      TO RN-AMT-REFUNDED             
  *                 MOVE WS-CURRENT-DATE TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT        
  *              ELSE                                                   
  *                 NEXT SENTENCE                                       
  *              END-IF                                                 
  *           ELSE                                                      
  *              MOVE SPACES             TO RN-CHECK-STATUS-CD          
  *              MOVE 'B'                TO RN-MANUAL-INDICATOR         
  *              MOVE SPACES             TO RN-USER-ID-APPRVD-BY        
  *              MOVE PARM-SPEC-CR-AMT-NUM                              
  *                                      TO RN-AMT-REFUNDED             
  *              MOVE PARM-SPEC-ACCOUNT-NO                              
  *                                      TO RN-ACCT-NO-CREDITED         
  *              MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *              PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
  *           END-IF                                                    
MAD620     END-IF.                                                      
      *                                                                 13741100
PCR482     INITIALIZE RN-ACCT-NO-CREDITED.                              
      *                                                                 13741300
MAD620     IF PARM-THIS-CR-AMT-NUM > 0                                  
  *           IF PARM-ACTION-CODE EQUAL 'U'                             
  *              IF PARM-APPROVE-CHK-IND EQUAL 'A'                      
  *                 MOVE SPACES          TO RN-CHECK-STATUS-CD          
  *                 MOVE 'A'             TO RN-MANUAL-INDICATOR         
  *                 MOVE SPACES          TO RN-USER-ID-APPRVD-BY        
  *                 MOVE PARM-THIS-CR-AMT-NUM                           
  *                                      TO RN-AMT-REFUNDED             
  *                 MOVE WS-CURRENT-DATE TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *                 PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT        
  *              ELSE                                                   
  *                 NEXT SENTENCE                                       
  *              END-IF                                                 
  *           ELSE                                                      
  *              MOVE SPACES             TO RN-CHECK-STATUS-CD          
  *              MOVE 'A'                TO RN-MANUAL-INDICATOR         
  *              MOVE SPACES             TO RN-USER-ID-APPRVD-BY        
  *              MOVE PARM-THIS-CR-AMT-NUM                              
  *                                      TO RN-AMT-REFUNDED             
  *              MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED            
  *                                         RN-REFUND-STATUS-DT         
  *                                         WS-REFUND-DATE              
  *              PERFORM 5090-SET-UP-REFUND    THRU 5090-EXIT           
  *           END-IF                                                    
MAD620     END-IF.                                                      
      *                                                                 13744600
           PERFORM 5300-PROCESS-DEPOSIT            THRU 5300-EXIT.      
           PERFORM 5370-UPDATE-CODES-DATA-PRESENT  THRU 5370-EXIT.      
      *                                                                 13760000
       5040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13790000
      ***************************************************************** 13810000
      * 5050-DELETE-REFUND                                            * 13820000
      *                                                               * 13830000
      *     WHEN THE USER OPTS TO DELETE THE REFUND REQUEST DETAIL,   * 13840000
      *     DELETE THE REFUND RECORDS FROM CSS_REFUND TABLE           * 13850000
      ***************************************************************** 13860000
      *                                                                 13870000
       5050-DELETE-REFUND.                                              
      *                                                                 13890000
           MOVE PARM-ACCOUNT-NO        TO RN-ACCOUNT-NO.                
           MOVE 'P259'                 TO RN-PANEL-NO.                  
           MOVE 'R'                    TO RN-CHECK-STATUS-CD.           
PCR482     MOVE PARM-DEPOSIT-CERT-NO   TO RN-DEPOSIT-CERT-NO.           
           IF PARM-AMT-CASH-NUM > 0                                     
              MOVE 'C'                 TO RN-MANUAL-INDICATOR           
              PERFORM 7110-SELECT-REFUND        THRU 7110-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8220-DELETE-REFUND        THRU 8220-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 14000000
           IF PARM-AMT-CHK-NUM > 0                                      
              MOVE 'M'                 TO RN-MANUAL-INDICATOR           
              PERFORM 7110-SELECT-REFUND        THRU 7110-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8220-DELETE-REFUND        THRU 8220-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 14080000
           IF RN-ADDRESS-ID > 0                                         
              MOVE RN-ADDRESS-ID       TO DZ-ADDRESS-ID                 
              PERFORM 5510-DELETE-ADDR-JRNL        THRU 5510-EXIT       
A37666*       PERFORM 8320-DELETE-ADDR-FREEFORM    THRU 8320-EXIT       14120000
           END-IF.                                                      
      *                                                                 14140000
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14170000
      ***************************************************************** 14180000
      * 5090-SET-UP-REFUND                                            * 14190000
      *                                                               * 14200000
      *      ASSIGN VALUES TO THE COLUMNS OF CSS_REFUND BEFORE INSERT * 14210000
      ***************************************************************** 14220000
      *                                                                 14230000
       5090-SET-UP-REFUND.                                              
      *                                                                 14250000
           MOVE PARM-ACCOUNT-NO          TO RN-ACCOUNT-NO.              
      *                                                                 14261000
           IF WS-LAST-REFUND-ITEM-ID = 0                                
              PERFORM 7100-GET-REFUND-ITEM-ID     THRU 7100-EXIT        
           END-IF.                                                      
      *                                                                 14291000
           ADD 1                         TO WS-LAST-REFUND-ITEM-ID.     
           MOVE WS-LAST-REFUND-ITEM-ID   TO RN-REFUND-ITEM-ID.          
C32206     PERFORM 5200-VERIFY-REFUND-REASON THRU 5200-EXIT.            
           MOVE PARM-CHECK-ISS-REAS-CD   TO RN-CHECK-ISS-REAS-CD.       
      *                                                                 14321000
           IF PARM-COMMENTS-TEXT = SPACES                               
              MOVE ZERO                  TO RN-COMMENTS-LEN             
           ELSE                                                         
              MOVE PARM-COMMENTS-LEN     TO RN-COMMENTS-LEN             
           END-IF.                                                      
      *                                                                 14371000
           MOVE PARM-COMMENTS-TEXT       TO RN-COMMENTS-TEXT.           
           MOVE PARM-DEPOSIT-CERT-NO     TO RN-DEPOSIT-CERT-NO          
           MOVE PARM-USER-ID             TO RN-USER-ID-RQSTED-BY.       
           MOVE 'P259'                   TO RN-PANEL-NO.                
           MOVE WS-CURRENT-TIMESTAMP     TO RN-TRANS-HIST-SEQ-NO.       
           MOVE 0                        TO RN-ADDRESS-ID.              
      *                                                                 14511000
           IF PARM-ADDRESS-CHANGED = 'T'                                
              IF WS-NEW-ADDRESS-ID = 0                                  
                 PERFORM 5500-INSERT-ADDR-JRNL  THRU 5500-EXIT          
                 PERFORM 5100-INSERT-ADDRESS    THRU 5100-EXIT          
              END-IF                                                    
              MOVE WS-NEW-ADDRESS-ID         TO RN-ADDRESS-ID           
           END-IF.                                                      
      *                                                                 14581000
           MOVE SPACES                   TO RN-REFUND-CHECK-NO,         
                                            RN-ORIGINAL-CHECK-NO,       
                                            RN-RETURNED-REASON.         
           MOVE AT-LOCAL-OFFICE          TO RN-LOCAL-OFFICE.            
      *                                                                 14621000
           PERFORM 8200-INSERT-REFUND    THRU 8200-EXIT.                
      *                                                                 14640000
       5090-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14670000
      ***************************************************************** 14684000
      * 5100-INSERT-ADDRESS                                           * 14690000
      *                                                               * 14700000
      *     GET THE LAST ADDRESS-ID USED FROM ADDRESS-CNTL TABLE.     * 14710000
      *     ADD 1 TO IT TO GET GET THE NEW ADDRESS-ID TO BE USED.     * 14720000
      *     UPDATE ADDRESS-CNTL TABLE WITH NEW ID AND ADD RECORD TO   * 14730000
      *     CSS-ADDR-FREEFORM TABLE.                                  * 14740000
      ***************************************************************** 14750000
      *                                                                 14760000
       5100-INSERT-ADDRESS.                                             
      *                                                                 14780000
*T4158      MOVE 'PANEL259'                    TO WS-90-PANEL-NO.       
*T4158      MOVE PARM-USER-ID                  TO WS-90-USERID.         
*T4158      MOVE PARM-ACCOUNT-NO               TO WS-90-ACCOUNT-NO.     
*T4158      MOVE ZEROES                        TO WS-90-CUSTOMER-NO.    
*T4158      MOVE ZEROES                        TO WS-90-PREMISE-NO.     
      *                                                                 14860700
*T4158      PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT.          
      *                                                                 14860900
*T4158      MOVE WS-90-NEW-ADDRESS-ID          TO WS-NEW-ADDRESS-ID.    
            MOVE WS-NEW-ADDRESS-ID        TO DZ-ADDRESS-ID.             
      *                                                                 14871000
            PERFORM 8310-INSERT-ADDR-FREEFORM  THRU 8310-EXIT.          
      *                                                                 14890000
       5100-EXIT.                                                       
           EXIT.                                                        
C32206******************************************************************15950000
C32206**                                                              **15960000
C32206**    5200-VERIFY-REFUND-REASON                                 **15970000
C32206**                                                              **15980000
C32206**        VERIFY THE REFUND REASON CODE THAT IS IN THE          **15990000
C32206**        PARM-CHECK-ISS-REAS-CD FIELD EXISTS.  IF NOT, MOVE    **16000000
C32206**        'C' (CLEAR A CREDIT BALANCE) TO THIS FIELD.           **16010000
C32206**                                                              **15960000
C32206******************************************************************16020000
C32206*                                                                 16030000
C32206 5200-VERIFY-REFUND-REASON.                                       
C32206                                                                  
C32206     EXEC SQL                                                     
C32206         SELECT DISTINCT ('Y')                                    
C32206           INTO :WS-REFUND-REAS-EXISTS                            
C32206           FROM CSS_REFUND_REASON WITH(READUNCOMMITTED)                   
C32206          WHERE CHECK_ISS_RSN_CD = :PARM-CHECK-ISS-REAS-CD        
A36248                                                           
P00641                                                      
C32206     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT ('Y')                                            
MFA-TR*          INTO :WS-REFUND-REAS-EXISTS                                    
MFA-TR*          FROM CSS_REFUND_REASON                                         
MFA-TR*         WHERE CHECK_ISS_RSN_CD = :PARM-CHECK-ISS-REAS-CD                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 5200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32206                                                                  
C32206     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C32206     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C32206        MOVE 'C' TO PARM-CHECK-ISS-REAS-CD                        
C32206     ELSE                                                         
C32206        IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL        
C32206           MOVE WS-ACTIVE-RETURN-CODE TO WS-ACTIVE-RETURN-CODE    
C32206           MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
C32206           MOVE '5200' TO ACTIVE-PARAGRAPH                        
C32206           MOVE 'SELECT' TO ABEND-FUNCTION                        
C32206           MOVE SPACES TO ABEND-SQL-PREDICATES                    
C32206                          ABEND-TABLES                            
C32206           MOVE 'CSS_REFUND_REASON' TO TABLE-1                    
C32206           MOVE 'CHECK_ISS_RSN_CD' TO TABLE-ELEMENT-1             
C32206           MOVE PARM-CHECK-ISS-REAS-CD TO HOSTVAR-ELEMENT-1       
C32206           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C32206           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C32206        END-IF                                                    
C32206     END-IF.                                                      
C32206                                                                  
C32206 5200-EXIT.                                                       
C32206     EXIT.                                                        
C32206                                                                  
      ******************************************************************15950000
      **                                                              **15960000
      **    5230-CALCULATE-INTEREST                                   **15970000
      **                                                              **15980000
      **        CALCULATE INTEREST ACCRUED FOR THE DEPOSIT OVER TIME. **15990000
      **        ACCOUNT FOR CHANGES IN INTEREST RATE OVER TIME.       **16000000
      **                                                              **16010000
      ******************************************************************16020000
      *                                                                 16030000
       5230-CALCULATE-INTEREST.                                         
C29752     PERFORM 7305-SELECT-DEP-ON-HAND           THRU 7305-EXIT.    
C29752     PERFORM 5995-DEPOSIT-INTEREST-CALC        THRU 5995-EXIT.    
       5230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16760000
       5250-LOAD-GL-NUMBERS.                                            
      *                                                                 16780000
T24436     PERFORM 9350-LINK-SCSCO061             THRU 9350-EXIT.       
T24555     PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
T24555        UNTIL WS-VALID-CO-SUB > 5                                 
T24555           OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'             
T24555           OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99         
T24555        IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                
                 MOVE 'Y'             TO WS-COMPANY-IN-TABLE            
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 16920000
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16950000
      ***************************************************************** 16970000
      * 5300-PROCESS-DEPOSIT                                          * 16980000
      *                                                               * 16990000
      *     RETRIEVE DEPOSIT CERTIFICATE DETAILS                      * 17000000
      *     FORGIVE ANY BALANCE AMOUNT LEFT FOR THE DEPOSIT (IN       * 17010000
      *        AR-CNTL TABLE SET THE TRAN-AMOUNT TO 0.00)             * 17020000
      *     IF REFUND OF INTEREST IS SELECTED THEN COMPUTE INTEREST,  * 17030000
      *        UPDATE INTRST-HISTORY AND REFUND THE INTEREST          * 17040000
      *     IF REFUND OF DEPOSIT IS SELECTED THEN REFUND THE          * 17050000
      *        DEPOSIT AMOUNT                                         * 17060000
      ***************************************************************** 17070000
      *                                                                 17080000
       5300-PROCESS-DEPOSIT.                                            
      *                                                                 17100000
           MOVE PARM-ACCOUNT-NO          TO DO-ACCOUNT-NO.              
           MOVE PARM-SERVICE-TYPE-CD     TO DO-SERVICE-TYPE-CD.         
           MOVE PARM-DEPOSIT-CERT-NO     TO DO-DEPOSIT-CERT-NO.         
      *                                                                 17161000
           PERFORM 5360-SET-100-JRNL-VARS               THRU 5360-EXIT. 
      *                                                                 17190000
           ADD  PARM-THIS-CR-AMT-NUM                                    
                PARM-SPEC-CR-AMT-NUM                                    
                PARM-AMT-CHK-NUM                                        
                PARM-AMT-CASH-NUM                                       
                PARM-BALANCE-AMT-NUM  GIVING WS-THIS-AR-AMOUNT.         
      *                                                                 17241000
           MOVE PARM-SPEC-CR-AMT-NUM     TO WS-SPEC-AR-AMOUNT.          
      *                                                                 17260000
           PERFORM 7310-OPEN-DEP-ON-HAND                THRU 7310-EXIT. 
           PERFORM 7320-FETCH-DEP-ON-HAND               THRU 7320-EXIT. 
      *                                                                 17281000
T20346     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T20346         PERFORM 5800-VALIDATE-AR-AMT             THRU 5800-EXIT  
T20346     END-IF.                                                      
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 5310-UPDATE-AR-CONTROL            THRU 5310-EXIT  
      *                                                                 17301000
PCR482        IF PARM-REFUND-TYPE = WS-INTEREST-ONLY OR                 
PCR482                              WS-DEP-AND-INTR                     
PCR482           PERFORM 5320-REFUND-INTEREST           THRU 5320-EXIT  
A01731           MOVE RN-DATE-REFUNDED   TO DO-DATE-INTST-CALC-TO       
PCR482        END-IF                                                    
      *                                                                 17350000
              IF DO-DATE-INTST-CALC-TO = SPACES                         
                 MOVE -1                 TO WS-DATE-INTST-CALC-TO-NI    
              ELSE                                                      
                 MOVE 0                  TO WS-DATE-INTST-CALC-TO-NI    
              END-IF                                                    
      *                                                                 17401000
              MOVE PARM-CODE-REFUND-REASON TO DO-CODE-REFUND-REASON     
      *                                                                 17421000
              PERFORM 8400-UPDATE-DEP-ON-HAND           THRU 8400-EXIT  
              PERFORM 7320-FETCH-DEP-ON-HAND            THRU 7320-EXIT  
           END-PERFORM.                                                 
      *                                                                 17451000
           PERFORM 7330-CLOSE-DEP-ON-HAND               THRU 7330-EXIT. 
      *                                                                 17470000
           PERFORM 7310-OPEN-DEP-ON-HAND                THRU 7310-EXIT. 
           PERFORM 7320-FETCH-DEP-ON-HAND               THRU 7320-EXIT. 
      *                                                                 17491000
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
      *                                                                 17510000
PCR482        IF PARM-REFUND-TYPE = WS-DEPOSIT-ONLY OR                  
PCR482                              WS-DEP-AND-INTR                     
PCR482           PERFORM 5330-REFUND-DEPOSIT            THRU 5330-EXIT  
PCR482        END-IF                                                    
      *                                                                 17560000
              IF DO-DATE-INTST-CALC-TO = SPACES                         
                 MOVE -1                 TO WS-DATE-INTST-CALC-TO-NI    
              ELSE                                                      
                 MOVE 0                  TO WS-DATE-INTST-CALC-TO-NI    
              END-IF                                                    
      *                                                                 17611000
PCR482        MOVE PARM-ACCOUNT-NO       TO DP-ACCOUNT-NO               
PCR482        MOVE DO-DEPOSIT-CERT-NO    TO DP-DEPOSIT-CERT-NO          
      *                                                                 17631000
PCR482        PERFORM 7990-SELECT-DEP-PAY-AMT           THRU 7990-EXIT  
      *                                                                 17640100
PCR482        IF DO-AMT-DEPOSIT < WS-TOTAL-PAYMENTS                     
PCR482           MOVE SPACES             TO DO-CODE-REFUND-STATUS       
PCR482           MOVE 'P'                TO DO-DEPOSIT-STATUS-CD        
                 IF DO-DATE-CERT-ISSUE EQUAL SPACES                     
PCR482             MOVE WS-CURRENT-DATE  TO DO-DATE-CERT-ISSUE          
                 END-IF                                                 
PCR482           MOVE WS-YES             TO WS-UPDATE-FLAG              
PCR482        END-IF                                                    
      *                                                                 17642200
PCR482        IF DO-AMT-DEPOSIT < 0 OR DO-AMT-DEPOSIT = 0               
PCR482           MOVE '0'                TO DO-CODE-REFUND-STATUS       
PCR482           MOVE 'R'                TO DO-DEPOSIT-STATUS-CD        
PCR482           MOVE WS-YES             TO WS-UPDATE-FLAG              
              END-IF                                                    
      *                                                                 17651000
PCR482        IF NOT-SPECIFIED-CREDIT AND UPDATE-IS-NEEDED              
PCR482           PERFORM 8530-UPDATE-AR-HIST            THRU 8530-EXIT  
PCR482        END-IF                                                    
      *                                                                 17654000
PCR482        MOVE WS-NO                 TO WS-UPDATE-FLAG              
PCR482        MOVE WS-NO                 TO WS-SPEC-CR-FLAG             
      *                                                                 17657000
              MOVE PARM-CODE-REFUND-REASON TO DO-CODE-REFUND-REASON     
      *                                                                 17671000
C35743        IF DO-DATE-CERT-ISSUE = SPACES OR LOW-VALUES              
C35743           MOVE -1                 TO WS-DATE-CERT-ISSUE-NI       
C35743        ELSE                                                      
C35743           MOVE 0                  TO WS-DATE-CERT-ISSUE-NI       
C35743        END-IF                                                    
                                                                        
              PERFORM 8400-UPDATE-DEP-ON-HAND           THRU 8400-EXIT  
              PERFORM 7320-FETCH-DEP-ON-HAND            THRU 7320-EXIT  
           END-PERFORM.                                                 
      *                                                                 17701000
           PERFORM 7330-CLOSE-DEP-ON-HAND               THRU 7330-EXIT. 
      *                                                                 17980000
           MOVE PARM-ACCOUNT-NO          TO CL-ACCOUNT-NO.              
           MOVE PARM-DEPOSIT-CERT-NO     TO CL-ITEM-ID.                 
           MOVE 'I'                      TO CL-CODE-NOTICE-TYPE.        
      *                                                                 17980500
           PERFORM 7380-SELECT-CRED-COLL                THRU 7380-EXIT. 
      *                                                                 17980700
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CL-DATE-CREDIT-ACTION >= WS-CURRENT-DATE               
                 IF DO-AMT-DEPOSIT <= ZEROES                            
                    PERFORM 7385-DELETE-CRED-COLL  THRU 7385-EXIT       
                 ELSE                                                   
                    PERFORM 7390-UPDATE-CRED-COLL  THRU 7390-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE 'O'                   TO CL-CODE-NOTICE-TYPE.           
                                                                        
           PERFORM 7380-SELECT-CRED-COLL    THRU 7380-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              IF CL-DATE-NOTICE-MAIL   >= WS-CURRENT-DATE               
                 IF DO-AMT-DEPOSIT <= ZEROES                            
                    PERFORM 7385-DELETE-CRED-COLL  THRU 7385-EXIT       
                 ELSE                                                   
                    PERFORM 7390-UPDATE-CRED-COLL  THRU 7390-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18010000
      ***************************************************************** 18020000
      * 5310-UPDATE-AR-CONTROL                                        * 18030000
      *     FORGIVE (CREDIT DEPOSIT) ANY BALANCE LEFT OVER ON DEPOSIT * 18040000
      *     BEFORE REFUNDING THE DEPOSIT.                             * 18050000
      *     SUBTRACT ANY BILLED BALANCE BEING CREDITED FROM           * 18060000
      *     TOTAL-AR-BALANCE OF CSS_ACCOUNT TABLE                     * 18070000
      ***************************************************************** 18080000
      *                                                                 18090000
       5310-UPDATE-AR-CONTROL.                                          
      *                                                                 18110000
           MOVE PARM-ACCOUNT-NO        TO AC-ACCOUNT-NO                 
                                          AT-ACCOUNT-NO.                
           MOVE DO-DEPOSIT-CERT-NO     TO AC-ITEM-ID.                   
           MOVE +80                    TO AC-PYMT-PRIORITY-LVL.         
      *                                                                 18151000
           PERFORM 7400-SELECT-AR-CNTL   THRU 7400-EXIT.                
      *                                                                 18170000
           IF AC-AMT-TRAN-BALANCE > 0                                   
              MOVE AC-AMT-TRAN-BALANCE   TO WS-AMT-TRAN-BALANCE         
      *                                                                 18191000
              PERFORM 7410-SELECT-AR-SUMM    THRU 7410-EXIT             
      *                                                                 18201000
              SUBTRACT AC-AMT-AR-DAY-00 FROM WS-SUMM-AMT-AR-DAY-00      
              SUBTRACT AC-AMT-AR-DAY-30 FROM WS-SUMM-AMT-AR-DAY-30      
              SUBTRACT AC-AMT-AR-DAY-60 FROM WS-SUMM-AMT-AR-DAY-60      
              SUBTRACT AC-AMT-AR-DAY-90 FROM WS-SUMM-AMT-AR-DAY-90      
              ADD      AC-AMT-AR-DAY-00, AC-AMT-AR-DAY-30,              
                       AC-AMT-AR-DAY-60, AC-AMT-AR-DAY-90               
                       GIVING WS-AMT-BILLED-UNPAID                      
      *                                                                 18271000
              PERFORM 8510-UPDATE-AR-SUMM    THRU 8510-EXIT             
      *                                                                 18290000
              ADD AC-AMT-TRAN-BALANCE     TO DO-AMT-REFUNDED            
              SUBTRACT AC-AMT-TRAN-BALANCE FROM DO-AMT-DEPOSIT          
      *                                                                 18311000
              PERFORM 8500-DELETE-AR-CNTL    THRU 8500-EXIT             
A00870*                                                                         
A00870        MOVE 'N'                       TO WS-DEP-DET-FOUND        
A00870        PERFORM 7430-SELECT-ARCNTL         THRU 7430-EXIT         
A00870        IF WS-DEP-DET-FOUND = 'N'                                 
A00870           PERFORM 8540-DELETE-SUMMARY    THRU 8540-EXIT          
A00870        END-IF                                                    
A00870*                                                                         
              MOVE 'Y'                       TO WS-THIS-ACCOUNT-SW      
              MOVE 'AR-DEP'                  TO WS-GL-ACCT-NAME-CR      
              MOVE 'DEP-DEP'                 TO WS-GL-ACCT-NAME-DB      
              MOVE WS-AMT-TRAN-BALANCE       TO WS-AU-AMOUNT            
                                              WS-JRNL-GEN-LEG-DEBIT-AMT 
                                              WS-JRNL-RCV-CREDIT-AMT    
              MOVE ' '                       TO WS-CURRENCY-TYPE        
      *                                                                 18401000
              PERFORM 5340-UPDATE-AR-JRNL    THRU 5340-EXIT             
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
      *                                                                 18421000
              SUBTRACT WS-AMT-BILLED-UNPAID  FROM AT-TOTAL-AR-BALANCE   
      *                                                                 18431000
              PERFORM 8520-UPDATE-ACCOUNT    THRU 8520-EXIT             
      *                                                                 18441000
              MOVE 0  TO       WS-AMT-BILLED-UNPAID                     
           END-IF.                                                      
      *                                                                 18470000
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18500000
      ***************************************************************** 18510000
      * 5320-REFUND-INTEREST                                          * 18520000
      *                                                               * 18530000
      ***************************************************************** 18540000
      *                                                                 18550000
       5320-REFUND-INTEREST.                                            
      *                                                                 18584100
           PERFORM 5230-CALCULATE-INTEREST       THRU 5230-EXIT         
      *                                                                 18612000
P0087A     MOVE WS-CURR-INTRST-CALC TO PARM-INTEREST-AMOUNT-NUM.        
                                                                        
           MOVE PARM-INTEREST-AMOUNT-NUM TO WS-INTEREST-REMAIN.         
           ADD PARM-INTEREST-AMOUNT-NUM  TO DO-INTRST-YTD.              
           ADD PARM-INTEREST-AMOUNT-NUM  TO DO-TOTAL-INTRST.            
           MOVE PARM-USER-ID           TO DO-USER-ID-UPDT-BY.           
      *                                                                 18660000
           IF WS-INTEREST-REMAIN > 0 AND PARM-THIS-CR-AMT-NUM > 0       
      *                                                                 18681000
              IF WS-INTEREST-REMAIN > PARM-THIS-CR-AMT-NUM              
                 MOVE PARM-THIS-CR-AMT-NUM  TO WS-PAYMENT-AMOUNT        
                 SUBTRACT PARM-THIS-CR-AMT-NUM FROM                     
                                           WS-INTEREST-REMAIN           
                 MOVE 0           TO PARM-THIS-CR-AMT-NUM               
              ELSE                                                      
                 MOVE WS-INTEREST-REMAIN    TO WS-PAYMENT-AMOUNT        
                 SUBTRACT WS-INTEREST-REMAIN  FROM                      
                                  PARM-THIS-CR-AMT-NUM                  
                 MOVE 0 TO        WS-INTEREST-REMAIN                    
              END-IF                                                    
      *                                                                 18791000
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
              MOVE WS-DEP-INT-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB   
              MOVE PARM-THIS-AR-TYPE     TO WS-PAR-TYPE                 
              MOVE PARM-THIS-ITEM-ID     TO WS-PAR-TYPE-NO              
              MOVE SPACES                TO WS-PAR-PAY-AHEAD            
                                            WS-PAR-PAY-CHRG-OFF         
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE WS-PAYMENT-AMOUNT     TO WS-AMT-CASH                 
PCR404        MOVE 'Y'                   TO WS-DEPOSIT-REFUND-SW        
              PERFORM 5400-CALL-APPLY-PAYMENT   THRU 5400-EXIT          
PCR404        MOVE 'N'                   TO WS-DEPOSIT-REFUND-SW        
           END-IF.                                                      
      *                                                                 18900000
           IF WS-INTEREST-REMAIN > 0 AND PARM-SPEC-CR-AMT-NUM > 0       
              MOVE 'CLR-AR-XFR'    TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-INT'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 18941000
              IF WS-INTEREST-REMAIN > PARM-SPEC-CR-AMT-NUM              
                 MOVE PARM-SPEC-CR-AMT-NUM  TO WS-PAYMENT-AMOUNT        
                                               WS-AU-AMOUNT             
                 SUBTRACT PARM-SPEC-CR-AMT-NUM FROM                     
                                           WS-INTEREST-REMAIN           
                    MOVE 0           TO PARM-SPEC-CR-AMT-NUM            
              ELSE                                                      
                 MOVE WS-INTEREST-REMAIN    TO WS-PAYMENT-AMOUNT        
                                               WS-AU-AMOUNT             
                 SUBTRACT WS-INTEREST-REMAIN  FROM                      
                                        PARM-SPEC-CR-AMT-NUM            
                 MOVE 0 TO        WS-INTEREST-REMAIN                    
              END-IF                                                    
      *                                                                 19071000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
              MOVE ' '                   TO WS-CURRENCY-TYPE            
      *                                                                 19121000
              PERFORM 5340-UPDATE-AR-JRNL   THRU 5340-EXIT              
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
      *                                                                 19150000
              MOVE PARM-SPEC-ACCOUNT-NO  TO AT-ACCOUNT-NO               
              MOVE WS-CLR-AR-XFR-GL-NO (WS-GL-SUB) TO                   
                                          WS-PAR-GEN-LEDG-DB            
              MOVE PARM-SPEC-AR-TYPE     TO WS-PAR-TYPE                 
              MOVE PARM-SPEC-ITEM-ID     TO WS-PAR-TYPE-NO              
              MOVE SPACES                TO WS-PAR-PAY-AHEAD            
                                            WS-PAR-PAY-CHRG-OFF         
              MOVE 'N'                   TO WS-THIS-ACCOUNT-SW          
              MOVE WS-PAYMENT-AMOUNT     TO WS-AMT-CASH                 
PCR404        MOVE 'Y'                   TO WS-DEPOSIT-REFUND-SW        
              PERFORM 5400-CALL-APPLY-PAYMENT   THRU 5400-EXIT          
PCR404        MOVE 'N'                   TO WS-DEPOSIT-REFUND-SW        
           END-IF.                                                      
      *                                                                 19270000
           IF WS-INTEREST-REMAIN > 0 AND PARM-AMT-CHK-NUM > 0           
              MOVE 'CLR-CK-ISS'    TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-INT'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 19311000
P0087A        IF PARM-CD-LOCAL-OFFICE = '998'                           
P0087A           MOVE WS-INTEREST-REMAIN     TO WS-AU-AMOUNT            
P0087A           MOVE DP-DEP-PAY-AMT         TO PARM-AMT-CHK-NUM        
P0087A           COMPUTE WS-AMT-REFUNDED = WS-INTEREST-REMAIN +         
P0087A                                     DP-DEP-PAY-AMT               
P0087A           MOVE WS-AMT-REFUNDED TO RN-AMT-REFUNDED                
P0087A                                   WS-THIS-AR-AMOUNT              
P0087A           PERFORM 8225-UPDATE-REFUND3 THRU 8225-EXIT             
P0087A           MOVE 0 TO        WS-INTEREST-REMAIN                    
P0087A        ELSE                                                      
                 IF WS-INTEREST-REMAIN > PARM-AMT-CHK-NUM               
                   MOVE PARM-AMT-CHK-NUM     TO WS-AU-AMOUNT            
                   SUBTRACT PARM-AMT-CHK-NUM FROM WS-INTEREST-REMAIN    
                   MOVE 0           TO PARM-AMT-CHK-NUM                 
                 ELSE                                                   
                   MOVE WS-INTEREST-REMAIN     TO WS-AU-AMOUNT          
                   SUBTRACT WS-INTEREST-REMAIN FROM PARM-AMT-CHK-NUM    
                   MOVE 0 TO        WS-INTEREST-REMAIN                  
                 END-IF                                                 
P0087A         END-IF                                                   
      *                                                                 19401000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE 'C'                   TO WS-CURRENCY-TYPE            
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
      *                                                                 19414100
              PERFORM 5340-UPDATE-AR-JRNL    THRU 5340-EXIT             
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
           END-IF.                                                      
      *                                                                 19418000
           IF WS-INTEREST-REMAIN > 0 AND PARM-AMT-CASH-NUM > 0          
              MOVE 'CLR-CASH'      TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-INT'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 19441000
              IF WS-INTEREST-REMAIN > PARM-AMT-CASH-NUM                 
                 MOVE PARM-AMT-CASH-NUM     TO WS-AU-AMOUNT             
                 SUBTRACT PARM-AMT-CASH-NUM FROM WS-INTEREST-REMAIN     
                 MOVE 0           TO PARM-AMT-CASH-NUM                  
              ELSE                                                      
                 MOVE WS-INTEREST-REMAIN     TO WS-AU-AMOUNT            
                 SUBTRACT WS-INTEREST-REMAIN FROM PARM-AMT-CASH-NUM     
                 MOVE 0 TO        WS-INTEREST-REMAIN                    
              END-IF                                                    
      *                                                                 19531000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-CASH-CREDIT-AMT     
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE 'A'                   TO WS-CURRENCY-TYPE            
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
      *                                                                 19581000
              PERFORM 5340-UPDATE-AR-JRNL    THRU 5340-EXIT             
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
           END-IF.                                                      
      *                                                                 19620000
       5320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19650000
      ***************************************************************** 19660000
      * 5330-REFUND-DEPOSIT                                           * 19670000
      *                                                               * 19680000
      ***************************************************************** 19690000
      *                                                                 19700000
       5330-REFUND-DEPOSIT.                                             
      *                                                                 19720000
           IF DO-AMT-DEPOSIT > 0 AND PARM-THIS-CR-AMT-NUM > 0           
      *                                                                 19741000
              IF DO-AMT-DEPOSIT > PARM-THIS-CR-AMT-NUM                  
                 MOVE PARM-THIS-CR-AMT-NUM TO WS-PAYMENT-AMOUNT         
                 SUBTRACT PARM-THIS-CR-AMT-NUM FROM                     
                                           DO-AMT-DEPOSIT               
                 ADD PARM-THIS-CR-AMT-NUM TO DO-AMT-REFUNDED            
                 MOVE 0           TO PARM-THIS-CR-AMT-NUM               
              ELSE                                                      
                 MOVE DO-AMT-DEPOSIT       TO WS-PAYMENT-AMOUNT         
                 SUBTRACT DO-AMT-DEPOSIT  FROM                          
                                  PARM-THIS-CR-AMT-NUM                  
                 ADD DO-AMT-DEPOSIT       TO DO-AMT-REFUNDED            
                 MOVE 0 TO        DO-AMT-DEPOSIT                        
              END-IF                                                    
      *                                                                 19871000
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
              MOVE WS-DEP-DEP-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB   
              MOVE PARM-THIS-AR-TYPE     TO WS-PAR-TYPE                 
              MOVE PARM-THIS-ITEM-ID     TO WS-PAR-TYPE-NO              
              MOVE SPACES                TO WS-PAR-PAY-AHEAD            
                                            WS-PAR-PAY-CHRG-OFF         
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE WS-PAYMENT-AMOUNT     TO WS-AMT-CASH                 
PCR404        MOVE 'Y'                   TO WS-DEPOSIT-REFUND-SW        
              PERFORM 5400-CALL-APPLY-PAYMENT   THRU 5400-EXIT          
PCR404        MOVE 'N'                   TO WS-DEPOSIT-REFUND-SW        
           END-IF.                                                      
      *                                                                 19980000
           IF DO-AMT-DEPOSIT > 0 AND PARM-SPEC-CR-AMT-NUM > 0           
              MOVE 'CLR-AR-XFR'    TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-DEP'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 20021000
              IF DO-AMT-DEPOSIT > PARM-SPEC-CR-AMT-NUM                  
                 MOVE PARM-SPEC-CR-AMT-NUM   TO WS-AU-AMOUNT            
                                                WS-PAYMENT-AMOUNT       
                 SUBTRACT PARM-SPEC-CR-AMT-NUM FROM                     
                                           DO-AMT-DEPOSIT               
                 ADD PARM-SPEC-CR-AMT-NUM TO DO-AMT-REFUNDED            
                 MOVE 0           TO PARM-SPEC-CR-AMT-NUM               
              ELSE                                                      
                 MOVE DO-AMT-DEPOSIT     TO WS-AU-AMOUNT                
                                            WS-PAYMENT-AMOUNT           
                 SUBTRACT DO-AMT-DEPOSIT  FROM                          
                                        PARM-SPEC-CR-AMT-NUM            
                 ADD DO-AMT-DEPOSIT       TO DO-AMT-REFUNDED            
                 MOVE 0 TO        DO-AMT-DEPOSIT                        
              END-IF                                                    
      *                                                                 20171000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
              MOVE ' '                   TO WS-CURRENCY-TYPE            
      *                                                                 20221000
              PERFORM 5340-UPDATE-AR-JRNL   THRU 5340-EXIT              
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
      *                                                                 20250000
              MOVE 'N'                   TO WS-THIS-ACCOUNT-SW          
              MOVE PARM-SPEC-ACCOUNT-NO  TO AT-ACCOUNT-NO               
              MOVE WS-CLR-AR-XFR-GL-NO (WS-GL-SUB) TO                   
                                          WS-PAR-GEN-LEDG-DB            
              MOVE PARM-SPEC-AR-TYPE     TO WS-PAR-TYPE                 
              MOVE PARM-SPEC-ITEM-ID     TO WS-PAR-TYPE-NO              
              MOVE SPACES                TO WS-PAR-PAY-AHEAD            
                                            WS-PAR-PAY-CHRG-OFF         
              MOVE WS-PAYMENT-AMOUNT     TO WS-AMT-CASH                 
PCR404        MOVE 'Y'                   TO WS-DEPOSIT-REFUND-SW        
              PERFORM 5400-CALL-APPLY-PAYMENT   THRU 5400-EXIT          
PCR404        MOVE 'N'                   TO WS-DEPOSIT-REFUND-SW        
           END-IF.                                                      
      *                                                                 20370000
           IF DO-AMT-DEPOSIT > 0 AND PARM-AMT-CHK-NUM > 0               
              MOVE 'CLR-CK-ISS'    TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-DEP'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 20411000
              IF DO-AMT-DEPOSIT > PARM-AMT-CHK-NUM                      
                 MOVE PARM-AMT-CHK-NUM      TO WS-AU-AMOUNT             
                 SUBTRACT PARM-AMT-CHK-NUM FROM DO-AMT-DEPOSIT          
                 ADD PARM-AMT-CHK-NUM      TO DO-AMT-REFUNDED           
                 MOVE 0           TO PARM-AMT-CHK-NUM                   
              ELSE                                                      
                 MOVE DO-AMT-DEPOSIT        TO WS-AU-AMOUNT             
                 SUBTRACT DO-AMT-DEPOSIT FROM PARM-AMT-CHK-NUM          
                 ADD DO-AMT-DEPOSIT       TO DO-AMT-REFUNDED            
                 MOVE 0 TO                DO-AMT-DEPOSIT                
              END-IF                                                    
      *                                                                 20521000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE 'C'                   TO WS-CURRENCY-TYPE            
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
      *                                                                 20571000
              PERFORM 5340-UPDATE-AR-JRNL   THRU 5340-EXIT              
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
           END-IF.                                                      
      *                                                                 20610000
           IF DO-AMT-DEPOSIT > 0 AND PARM-AMT-CASH-NUM > 0              
              MOVE 'CLR-CASH'      TO WS-GL-ACCT-NAME-CR                
              MOVE 'DEP-DEP'       TO WS-GL-ACCT-NAME-DB                
      *                                                                 20651000
              IF DO-AMT-DEPOSIT > PARM-AMT-CASH-NUM                     
                 MOVE PARM-AMT-CASH-NUM     TO WS-AU-AMOUNT             
                 SUBTRACT PARM-AMT-CASH-NUM FROM DO-AMT-DEPOSIT         
                 ADD PARM-AMT-CASH-NUM     TO DO-AMT-REFUNDED           
                 MOVE 0           TO PARM-AMT-CASH-NUM                  
              ELSE                                                      
                 MOVE DO-AMT-DEPOSIT        TO WS-AU-AMOUNT             
                 SUBTRACT DO-AMT-DEPOSIT FROM PARM-AMT-CASH-NUM         
                 ADD DO-AMT-DEPOSIT       TO DO-AMT-REFUNDED            
                 MOVE 0                   TO DO-AMT-DEPOSIT             
              END-IF                                                    
      *                                                                 20761000
              MOVE WS-AU-AMOUNT          TO WS-JRNL-GEN-LEG-DEBIT-AMT   
                                            WS-JRNL-CASH-CREDIT-AMT     
              MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW          
              MOVE 'A'                   TO WS-CURRENCY-TYPE            
              MOVE PARM-ACCOUNT-NO       TO AT-ACCOUNT-NO               
      *                                                                 20811000
              PERFORM 5340-UPDATE-AR-JRNL   THRU 5340-EXIT              
              PERFORM 5350-UPDATE-CD-JRNL    THRU 5350-EXIT             
           END-IF.                                                      
      *                                                                 20860700
       5330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20880000
      ***************************************************************** 20893000
      * 5340-UPDATE-AR-JRNL                                           * 20900000
      *                                                               * 20910000
      *     SELECT THE GL-CODES FOR 'AR-DEP' AND 'DEP-DEP'            * 20920000
      *     INITIALISE ALL THE 'AR' AND 'AU' VARIABLES WITH           * 20930000
      *     APPROPRIATE VALUES AND CALL CPD00008 TO CREATE AR-JOURNAL * 20940000
      ***************************************************************** 20950000
      *                                                                 20960000
       5340-UPDATE-AR-JRNL.                                             
      *                                                                 20980000
           PERFORM 7250-SELECT-ACCOUNT   THRU 7250-EXIT.                
      *                                                                 20991000
           MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO.             
           MOVE AT-PREMISE-NO            TO PR-PREMISE-NO.              
      *                                                                 21011000
           PERFORM 7280-SELECT-CUSTOMER  THRU 7280-EXIT.                
           PERFORM 7260-SELECT-PREMISE   THRU 7260-EXIT.                
      *                                                                 21040000
           MOVE AT-COMPANY-NO             TO GO-COMPANY-NO.             
           MOVE WS-GL-ACCT-NAME-CR        TO GO-GL-ACCT-NAME.           
      *                                                                 21061000
           PERFORM 7420-SELECT-GL-ACCT-NO THRU 7420-EXIT.               
      *                                                                 21071000
           MOVE GO-GL-ACCT-NO             TO AU-GL-ACCT-CREDIT.         
           MOVE WS-GL-ACCT-NAME-DB        TO GO-GL-ACCT-NAME.           
      *                                                                 21101000
           PERFORM 7420-SELECT-GL-ACCT-NO THRU 7420-EXIT.               
      *                                                                 21111000
           MOVE GO-GL-ACCT-NO             TO AU-GL-ACCT-DEBIT.          
           MOVE AT-ACCOUNT-NO              TO AR-ACCOUNT-NO             
                                              AU-ACCOUNT-NO.            
      *                                                                 21160000
           IF WS-THIS-ACCOUNT                                           
              MOVE WS-THIS-TRAN-APPL-NO   TO WS-PAR-TRAN-APPL-NO        
              ADD  1                      TO WS-PAR-TRAN-APPL-NO        
      *                                                                 21211000
              IF WS-PAR-TRAN-APPL-NO = 1                                
                 PERFORM 7000-GET-CURRENT-DATE   THRU 7000-EXIT         
                 MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO     
                                               WS-THIS-TIMESTAMP        
              ELSE                                                      
                 MOVE WS-THIS-TIMESTAMP     TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO     
                                               WS-CURRENT-TIMESTAMP     
              END-IF                                                    
      *                                                                 21311000
              MOVE WS-PAR-TRAN-APPL-NO       TO AU-TRAN-APPL-NO         
              MOVE WS-PAR-TRAN-APPL-NO       TO WS-THIS-TRAN-APPL-NO    
              MOVE WS-THIS-AR-AMOUNT         TO AR-AMT-ORIG-ENTERED     
T11712        MOVE 'R'                       TO AR-CODE-TRAN-TYPE       
           ELSE                                                         
              MOVE WS-SPEC-TRAN-APPL-NO   TO WS-PAR-TRAN-APPL-NO        
              ADD  1                      TO WS-PAR-TRAN-APPL-NO        
      *                                                                 21371000
              IF WS-PAR-TRAN-APPL-NO = 1                                
                 PERFORM 7000-GET-CURRENT-DATE   THRU 7000-EXIT         
                 MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO     
                                               WS-SPEC-TIMESTAMP        
              ELSE                                                      
                 MOVE WS-SPEC-TIMESTAMP     TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO     
                                               WS-CURRENT-TIMESTAMP     
              END-IF                                                    
      *                                                                 21471000
              MOVE WS-PAR-TRAN-APPL-NO       TO AU-TRAN-APPL-NO         
              MOVE WS-PAR-TRAN-APPL-NO       TO WS-SPEC-TRAN-APPL-NO    
              MOVE WS-SPEC-AR-AMOUNT         TO AR-AMT-ORIG-ENTERED     
PCR526        MOVE 'I'                       TO AR-CODE-TRAN-TYPE       
           END-IF.                                                      
      *                                                                 21511000
           MOVE WS-CURRENT-DATE            TO AR-DATE-TRANS.            
           SUBTRACT WS-AMT-BILLED-UNPAID FROM AT-TOTAL-AR-BALANCE       
              GIVING AR-AMT-BILLED-UNPAID.                              
           MOVE PARM-RESP-AREA-ID          TO AR-RESP-AREA-ID.          
                                                                        
T29481     IF PARM-REFUND-TYPE = WS-INTEREST-ONLY                       
T29481          MOVE 'PANEL259I'             TO AR-APPL-PROGRAM-ID      
T29481     ELSE                                                         
PCR526       IF WS-THIS-ACCOUNT                                         
PCR526          MOVE 'PANEL259'              TO AR-APPL-PROGRAM-ID      
PCR526       ELSE                                                       
PCR526          MOVE 'PANEL259B'             TO AR-APPL-PROGRAM-ID      
PCR526       END-IF                                                     
T29481     END-IF.                                                      
                                                                        
           MOVE SPACES                     TO AR-PYMT-FACILITY-CD.      
           MOVE PARM-USER-ID               TO AR-USER-ID.               
           MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
           MOVE PARM-TRAN-COMMENT-TEXT     TO AR-TRAN-COMMENT-TEXT.     
           MOVE PARM-TRAN-COMMENT-LEN      TO AR-TRAN-COMMENT-LEN.      
                                                                        
PCR526     IF WS-THIS-ACCOUNT AND WS-SPEC-AR-AMOUNT > 0                 
PCR526        MOVE PARM-SPEC-ACCOUNT-NO    TO WS-TO-ACCT-NUM-CM         
PCR526        MOVE WS-SPEC-AR-AMOUNT       TO WS-FROM-ACCT-AMT-CM       
                                                                        
PCR526        IF AR-TRAN-COMMENT-TEXT = SPACES                          
PCR526           MOVE 0                    TO WS-COUNT                  
PCR526        ELSE                                                      
PCR526           PERFORM VARYING WS-COUNT FROM 210 BY -1                
PCR526             UNTIL AR-TRAN-COMMENT-TEXT (WS-COUNT:1) > SPACES     
PCR526              OR WS-COUNT = 1                                     
PCR526                CONTINUE                                          
PCR526           END-PERFORM                                            
PCR526        END-IF                                                    
                                                                        
PCR526        IF WS-COUNT = 0                                           
PCR526           MOVE 1                    TO WS-STARTING-POS           
PCR526           MOVE WS-FROM-ACCT-COMMENT                              
PCR526              TO AR-TRAN-COMMENT-TEXT (WS-STARTING-POS:65)        
PCR526           MOVE 65                   TO AR-TRAN-COMMENT-LEN       
PCR526        ELSE                                                      
PCR526           COMPUTE WS-STARTING-POS = WS-COUNT + 2                 
PCR526           MOVE WS-FROM-ACCT-COMMENT                              
PCR526              TO AR-TRAN-COMMENT-TEXT (WS-STARTING-POS:65)        
PCR526           COMPUTE AR-TRAN-COMMENT-LEN = WS-COUNT + 67            
PCR526        END-IF                                                    
PCR526     END-IF.                                                      
                                                                        
           MOVE SPACES                     TO AR-RECORD-ONLY-FL.        
FCS        MOVE WS-CD-COMPANY-NO           TO AR-CASH-COMPANY-NO.       
FCS        MOVE WS-CD-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.     
FCS        MOVE WS-CD-REPORT-DATE          TO AR-DATE-CASH-REPORT.      
FCS        MOVE WS-CD-REPORT-NO            TO AR-CASH-REPORT-NO.        
FCS        MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
           MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
           MOVE DO-DEPOSIT-CERT-NO         TO AU-ITEM-ID.               
           MOVE SPACES                     TO AU-CODE-AR-AGE            
                                              AU-CODE-CONTRACT-TYPE.    
           MOVE WS-CURRENCY-TYPE           TO AU-CURRENCY-TYPE.         
           MOVE WS-AU-AMOUNT               TO AU-CURRENCY-AMT           
                                              AU-AMT-POSTED.            
      *                                                                 21760000
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST      THRU 6500-EXIT.   
      *                                                                 21780000
       5340-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21810000
      ******************************************************************21820000
      * 5350-UPDATE-CD-JRNL                                            *21830000
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *21840000
      ******************************************************************21850000
      *                                                                 21851000
       5350-UPDATE-CD-JRNL.                                             
      *                                                                 21870000
           PERFORM 7280-SELECT-CUSTOMER        THRU 7280-EXIT.          
      *                                                                 21890000
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
FCS        MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE WS-THIS-AR-AMOUNT       TO WS-101-AMOUNT-ENTERED        
           MOVE WS-AU-AMOUNT            TO WS-101-AMT-POSTED.           
           MOVE AU-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE AU-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE AU-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO            
                                           WS-101-DETAIL-END-BAL        
                                           WS-101-DETAIL-END-AR-BAL.    
           MOVE AT-TOTAL-AR-BALANCE     TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
      *                                                                 22130000
           MOVE AU-CURRENCY-TYPE        TO WS-JRNL-CURRENCY-TYPE.       
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
TP5932     MOVE AT-COMPANY-NO           TO WS-100-COMPANY-NO.           
           MOVE AT-ACCOUNT-NO           TO WS-100-ACCT-NO.              
           MOVE AT-CUSTOMER-NO          TO WS-100-CUSTOMER-NO.          
           MOVE PR-PREMISE-NO           TO WS-100-PREMISE-NO.           
           MOVE AT-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE AT-DATE-LAST-ACTION     TO WS-100-DATE-LAST-ACTION.     
      *                                                                 22140900
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
      *                                                                 22141100
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
      *                                                                 22142100
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 22144000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 22160000
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
      *                                                                 22171000
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 22190000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 22260000
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22290000
      ******************************************************************22300000
      * 5360-SET-100-JRNL-VARS.                                        *22310000
      *        INITIALISE ALL 100 CODE WORKING STORAGE VARIABLES THAT  *22320000
      *        ARE USED IN THE CASH AND MISCELLANEOUS JOURNALING       *22330000
      ******************************************************************22340000
      *                                                                 22341000
       5360-SET-100-JRNL-VARS.                                          
      *                                                                 22360000
           MOVE 9                          TO WS-TRAN-OPER-LEVEL.       
           MOVE 1                          TO WS-TRAN-OCAP-FIELD.       
           MOVE 1                          TO WS-TRAN-OCAP-VALUE.       
           MOVE 'C'                        TO WS-TRAN-JRNL-TYPE         
           MOVE 'N'                        TO WS-TRAN-HOLD-EXEMPT-FLAG. 
      *                                                                 22450000
           MOVE PARM-USER-ID               TO WS-JRNL-OL-TEMP-ID.       
           MOVE WS-JRNL-CK-OPER-ID         TO WS-JRNL-OPERATION-RQST.   
      *                                                                 22501000
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 22520000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 22590000
           MOVE WS-JRNL-OL-OPR-LOC         TO WS-TERM-LOC.              
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
FCS        MOVE WS-CD-COMPANY-NO           TO WS-JRNL-OL-COMPANY.       
FCS        MOVE WS-CD-LOCAL-OFFICE         TO WS-JRNL-OL-LOC-OFF.       
FCS        MOVE WS-CD-REPORT-DATE          TO WS-JRNL-OL-REPORT-DT.     
FCS        MOVE WS-CD-REPORT-NO            TO WS-JRNL-OL-REPORT-NO.     
FCS        MOVE WS-CASH-DRAWER-ID          TO WS-JRNL-OL-CASH-DRWR.     
FCS        MOVE SPACES                     TO WS-JRNL-CODE-PYMT-FACILITY
      *                                                                 22800000
           MOVE WS-JRNL-VALIDATE-OPER      TO WS-JRNL-OPERATION-RQST.   
           MOVE 'C'                        TO WS-JRNL-SOURCE-CODE.      
      *                                                                 22821000
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF.                                                      
      *                                                                 22862000
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 22880000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 22950000
FCS        IF PARM-AMT-CASH-NUM > 0                                     
FCS           MOVE EIBTRNID             TO WS-100-CODE-TERMINAL-TRAN    
FCS        ELSE                                                         
FCS           MOVE '171B'               TO WS-100-CODE-TERMINAL-TRAN    
FCS        END-IF.                                                      
      *                                                                 23001000
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
      *                                                                 23050000
       5360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23080000
      ******************************************************************23090000
      * 5370-UPDATE-CODES-DATA-PRESENT                                 *23100000
      *    -- THIS MODULE CHECKS IF ANY DEP_REQ AND DEP_ON_HAND RECORD *23110000
      *       PRESENT TO UPDATE THE CODES_DATA_PRESENT OF CSS_ACCOUNT  *23120000
      ******************************************************************23130000
      *                                                                 23131000
       5370-UPDATE-CODES-DATA-PRESENT.                                  
      *                                                                 23150000
           MOVE PARM-ACCOUNT-NO      TO AT-ACCOUNT-NO.                  
      *                                                                 23161000
           PERFORM 7250-SELECT-ACCOUNT       THRU 7250-EXIT.            
      *                                                                 23171000
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
      *                                                                 23190000
           PERFORM 7500-OPEN-DEP-REQ         THRU 7500-EXIT.            
           PERFORM 7510-FETCH-DEP-REQ        THRU 7510-EXIT.            
           PERFORM 7520-CLOSE-DEP-REQ        THRU 7520-EXIT.            
      *                                                                 23230000
           IF WS-DEP-REQ-EXISTS = 'N'                                   
              MOVE SPACES         TO WS-CODE-DEP-REQ                    
           END-IF.                                                      
      *                                                                 23270000
           PERFORM 7600-OPEN-DEP-EXISTS      THRU 7600-EXIT.            
           PERFORM 7610-FETCH-DEP-EXISTS     THRU 7610-EXIT.            
           PERFORM 7620-CLOSE-DEP-EXISTS     THRU 7620-EXIT.            
      *                                                                 23310000
           IF WS-DEP-ON-HAND-EXISTS = 'N'                               
              MOVE SPACES          TO WS-CODE-DEP-ON-HAND               
           END-IF.                                                      
      *                                                                 23350000
T19068     IF WS-CHECK-AMOUNT > 0 OR WS-CASH-AMOUNT > 0                 
              MOVE 'A'          TO WS-CODE-CHECK-REFUND                 
           END-IF.                                                      
      *                                                                 23400000
           MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT.       
           PERFORM 8520-UPDATE-ACCOUNT       THRU 8520-EXIT.            
      *                                                                 23430000
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ***************************************************************** 23470000
      * 5400-CALL-APPLY-PAYMENT                                       * 23480000
      *                                                               * 23490000
      *     INITIALISE ALL THE WORKING STORAGES REQUIRED BEFORE       * 23500000
      *     CALLING 6700-APPLY-PAYMENT (CPD00010)                     * 23510000
      ***************************************************************** 23520000
      *                                                                 23530000
       5400-CALL-APPLY-PAYMENT.                                         
      *                                                                 23550000
           PERFORM 7250-SELECT-ACCOUNT   THRU 7250-EXIT.                
      *                                                                 23561000
TPRNEW     IF WS-THIS-ACCOUNT                                           
TPRNEW        CONTINUE                                                  
TPRNEW     ELSE                                                         
TPRNEW        MOVE AT-COMPANY-NO           TO P6-COMPANY-NO             
TPRNEW                                        WS-100-COMPANY-NO         
TPRNEW        MOVE AT-LOCAL-OFFICE         TO P6-LOCAL-OFFICE           
TPRNEW                                        WS-100-LOCAL-OFFICE-CD    
TPRNEW     END-IF                                                       
                                                                        
           MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO.             
           MOVE AT-PREMISE-NO            TO PR-PREMISE-NO.              
      *                                                                 23581000
           PERFORM 7280-SELECT-CUSTOMER  THRU 7280-EXIT.                
           PERFORM 7260-SELECT-PREMISE   THRU 7260-EXIT.                
      *                                                                 23610000
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE AT-ACCOUNT-NO            TO DL-ACCOUNT-NO.              
      *                                                                 23681000
           PERFORM 7290-SELECT-RECONNECT THRU 7290-EXIT.                
      *                                                                 23691000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                   TO WS-PAR-RECONNECT-EXIST      
           ELSE                                                         
              MOVE 'N'                   TO WS-PAR-RECONNECT-EXIST      
           END-IF.                                                      
      *                                                                 23741000
           IF WS-PAR-TYPE = 0                                           
              MOVE 'N'                   TO WS-IS-THIS-DIRECTED-PYMT    
              MOVE 1                     TO C9-PMT-PRTY-SCHEDULE        
              PERFORM 6722B-OPEN-AR-PMT-PRTY THRU 6722B-EXIT            
              PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT           
              PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT           
                 VARYING WS-PAR-SUB FROM 1 BY 1                         
                    UNTIL WS-PAR-SUB > 52                               
                       OR WS-ACTIVE-RETURN-CODE = NOT-FOUND             
              PERFORM 6722E-CLOSE-AR-PMT-PRTY  THRU 6722E-EXIT          
           ELSE                                                         
              MOVE 'Y'                   TO WS-IS-THIS-DIRECTED-PYMT    
           END-IF.                                                      
      *                                                                 23910000
           PERFORM 5550-SAVE-DEP-ON-HAND      THRU 5550-EXIT.           
      *                                                                 23951000
           IF WS-THIS-ACCOUNT                                           
              MOVE WS-THIS-TRAN-APPL-NO  TO WS-PAR-TRAN-APPL-NO         
              MOVE WS-THIS-TIMESTAMP     TO WS-CURRENT-TIMESTAMP        
              MOVE WS-THIS-AR-AMOUNT     TO AR-AMT-ORIG-ENTERED         
                                            WS-PAYMENT-AMOUNT-TOTAL     
T11712        MOVE 'R'                   TO WS-PAR-CODE-TRAN-TYPE       
           ELSE                                                         
              MOVE WS-SPEC-TRAN-APPL-NO  TO WS-PAR-TRAN-APPL-NO         
              MOVE WS-SPEC-TIMESTAMP     TO WS-CURRENT-TIMESTAMP        
              MOVE WS-SPEC-AR-AMOUNT     TO AR-AMT-ORIG-ENTERED         
                                            WS-PAYMENT-AMOUNT-TOTAL     
PCR526        MOVE 'I'                   TO WS-PAR-CODE-TRAN-TYPE       
           END-IF.                                                      
      *                                                                 24061000
FCS        MOVE WS-JRNL-OL-COMPANY       TO WS-PAR-COMPANY-NO.          
FCS        MOVE WS-JRNL-OL-LOC-OFF       TO WS-PAR-LOCAL-OFFICE.        
FCS        MOVE WS-JRNL-OL-REPORT-NO     TO WS-PAR-REPORT-NO.           
FCS        MOVE WS-JRNL-OL-REPORT-DT     TO WS-PAR-REPORT-DATE.         
FCS        MOVE WS-JRNL-OL-CASH-DRWR     TO WS-PAR-CASH-DRAWER.         
           MOVE WS-TERM-LOC              TO WS-PAR-ACCESS-LOC.          
           MOVE PARM-USER-ID             TO WS-PAR-OPERATOR-ID.         
           MOVE PARM-RESP-AREA-ID        TO WS-PAR-RESP-AREA.           
                                                                        
T29481     IF PARM-REFUND-TYPE = WS-INTEREST-ONLY                       
T29481        MOVE 'PANEL259I'             TO WS-PAR-APPL-PROG-ID       
T29481     ELSE                                                         
PCR526       IF WS-THIS-ACCOUNT                                         
PCR526          MOVE 'PANEL259'            TO WS-PAR-APPL-PROG-ID       
PCR526       ELSE                                                       
PCR526          MOVE 'PANEL259B'           TO WS-PAR-APPL-PROG-ID       
PCR526       END-IF                                                     
T29481     END-IF.                                                      
                                                                        
           MOVE WS-100-CODE-TERMINAL-TRAN TO WS-PAR-EIBTRNID.           
           MOVE SPACES                   TO WS-PAR-PYMT-FACILITY-CD.    
           MOVE PARM-TRAN-COMMENT-TEXT TO WS-PAR-AR-TRAN-COMMENT-TEXT.  
           MOVE PARM-TRAN-COMMENT-LEN  TO WS-PAR-AR-TRAN-COMMENT-LEN.   
                                                                        
PCR526     IF WS-SPEC-ACCOUNT AND WS-SPEC-AR-AMOUNT > 0                 
PCR526        MOVE PARM-ACCOUNT-NO         TO WS-FROM-ACCT-NUM-CM       
                                                                        
PCR526        IF WS-PAR-AR-TRAN-COMMENT-TEXT = SPACES                   
PCR526          MOVE 0                     TO WS-COUNT                  
PCR526        ELSE                                                      
PCR526          PERFORM VARYING WS-COUNT FROM 210 BY -1                 
PCR526           UNTIL WS-PAR-AR-TRAN-COMMENT-TEXT (WS-COUNT:1) > SPACES
PCR526             OR WS-COUNT = 1                                      
PCR526               CONTINUE                                           
PCR526          END-PERFORM                                             
PCR526        END-IF                                                    
                                                                        
PCR526        IF WS-COUNT = 0                                           
PCR526           MOVE 1                 TO WS-STARTING-POS              
PCR526           MOVE WS-TO-ACCT-COMMENT                                
PCR526            TO WS-PAR-AR-TRAN-COMMENT-TEXT (WS-STARTING-POS:48)   
PCR526           MOVE 48                TO WS-PAR-AR-TRAN-COMMENT-LEN   
PCR526        ELSE                                                      
PCR526           COMPUTE WS-STARTING-POS = WS-COUNT + 2                 
PCR526           MOVE WS-TO-ACCT-COMMENT                                
PCR526            TO WS-PAR-AR-TRAN-COMMENT-TEXT (WS-STARTING-POS:48)   
PCR526           COMPUTE WS-PAR-AR-TRAN-COMMENT-LEN = WS-COUNT + 50     
PCR526        END-IF                                                    
PCR526     END-IF.                                                      
      *                                                                 24215000
           PERFORM 6700-APPLY-PAYMENT    THRU 6700-EXIT.                
      *                                                                 24230000
           PERFORM 5555-RESTORE-DEP-ON-HAND      THRU 5555-EXIT.        
      *                                                                 24260000
           IF WS-THIS-ACCOUNT                                           
              MOVE WS-PAR-TRAN-APPL-NO   TO WS-THIS-TRAN-APPL-NO        
              MOVE WS-CURRENT-TIMESTAMP  TO WS-THIS-TIMESTAMP           
           ELSE                                                         
              MOVE WS-PAR-TRAN-APPL-NO   TO WS-SPEC-TRAN-APPL-NO        
              MOVE WS-CURRENT-TIMESTAMP  TO WS-SPEC-TIMESTAMP           
           END-IF.                                                      
      *                                                                 24331000
           IF PYMT-WAS-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PAR-MESSAGE-NO     TO RS-ERROR-MESSAGE-NO         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5400'                TO ACTIVE-PARAGRAPH            
              MOVE 'USERABEN'            TO ABEND-FUNCTION              
              MOVE 'Y'                   TO WS-USER-FORCE-ABEND         
              MOVE 'PAYMENT ABEND'       TO DSNTIAR-MESSAGE-1           
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 24460000
           MOVE WS-JRNL-CNTRL-ONLY       TO WS-JRNL-OPERATION-RQST.     
      *                                                                 24471000
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
      *                                                                 24490000
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24520000
      ***************************************************************** 24530000
      * 5500-INSERT-ADDR-JRNL                                         * 24540000
      *                                                               * 24550000
      *     CREATE MAINTENANCE TRANSACTION HISORY DETAILS FOR         * 24560000
      *     MAILING ADDRESS DETAILS                                   * 24570000
      ***************************************************************** 24580000
      *                                                                 24590000
       5500-INSERT-ADDR-JRNL.                                           
      *                                                                 24610000
           PERFORM 5520-SET-UP-JRNL-HDR    THRU 5520-EXIT.              
      *                                                                 24630000
           IF PARM-ADDR-STREET > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-ADDR-STREET                           
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDR-STREET      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MAIL ADDR STREET '   TO MI-COLUMN-DESC              
              MOVE '  '                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                 24760000
           IF PARM-ADDR-CITY-STATE > SPACES                             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-ADDR-CITY-STATE                       
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDR-CITY-STATE  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MAIL ADDR CITY   '   TO MI-COLUMN-DESC              
              MOVE '  '                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                 24910000
           IF PARM-ADDR-ZIP-CODE > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-ADDR-ZIP-CODE                         
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDR-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MAIL ADDR ZIP    '   TO MI-COLUMN-DESC              
              MOVE '  '                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                 25050000
           IF PARM-ADDR-COUNTRY > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-ADDR-COUNTRY                          
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDR-COUNTRY     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MAIL ADDR COUNTRY'   TO MI-COLUMN-DESC              
              MOVE '  '                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                 25180000
           IF PARM-ADDRESS-OVERFLOW > SPACES                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-ADDRESS-OVERFLOW                      
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MAIL ADDR OVERFLO'   TO MI-COLUMN-DESC              
              MOVE '  '                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                 25320000
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25350000
      ***************************************************************** 25360000
      * 5510-DELETE-ADDR-JRNL                                         * 25370000
      *                                                               * 25380000
      *     CREATE MAINTENANCE TRANSACTION HISORY DETAILS FOR         * 25390000
      *     DELETION OF MAILING ADDRESS DETAILS                       * 25400000
      ***************************************************************** 25410000
      *                                                                 25411000
       5510-DELETE-ADDR-JRNL.                                           
                                                                        
           PERFORM 5520-SET-UP-JRNL-HDR     THRU 5520-EXIT.             
      *                                                                 25450000
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE +0                         TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE '*DELETED*'                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE 'MAIL ADDRESS   '          TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                 25550000
       5510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25580000
       5520-SET-UP-JRNL-HDR.                                            
      *                                                                 25600000
           PERFORM 7000-GET-CURRENT-DATE    THRU 7000-EXIT.             
      *                                                                 25611000
           MOVE WS-CURRENT-DATE       TO MH-DATE-TRANS.                 
           MOVE WS-CURRENT-TIMESTAMP  TO MH-TRANS-HIST-SEQ-NO.          
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
      *                                                                 25651000
           IF PARM-TRAN-COMMENT-TEXT = SPACES                           
              MOVE ZERO                   TO MH-TRAN-COMMENT-LEN        
           ELSE                                                         
              MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN        
           END-IF.                                                      
      *                                                                 25701000
           MOVE PARM-TRAN-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.      
           MOVE PARM-ACCOUNT-NO           TO MH-ACCOUNT-NO.             
           MOVE ZEROES                    TO MH-CUSTOMER-NO.            
           MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
T29481     IF PARM-REFUND-TYPE = WS-INTEREST-ONLY                       
T29481        MOVE 'PANEL259I'            TO MH-APPL-PROGRAM-ID         
T29481     ELSE                                                         
              MOVE 'PANEL259'             TO MH-APPL-PROGRAM-ID         
T29481     END-IF.                                                      
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
      *                                                                 25790000
       5520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25820000
       5550-SAVE-DEP-ON-HAND.                                           
      *                                                                 25840000
           MOVE DO-ACCOUNT-NO         TO WS-DO-ACCOUNT-NO.              
           MOVE DO-DEPOSIT-CERT-NO    TO WS-DO-DEPOSIT-CERT-NO.         
           MOVE DO-AMT-DEPOSIT        TO WS-DO-AMT-DEPOSIT.             
           MOVE DO-DATE-INTST-CALC-TO TO WS-DO-DATE-INTST-CALC-TO.      
           MOVE DO-INTRST-YTD         TO WS-DO-INTRST-YTD.              
           MOVE DO-TOTAL-INTRST       TO WS-DO-TOTAL-INTRST.            
           MOVE DO-CODE-REFUND-STATUS TO WS-DO-CODE-REFUND-STATUS.      
           MOVE DO-CODE-REFUND-REASON TO WS-DO-CODE-REFUND-REASON.      
           MOVE DO-DEPOSIT-STATUS-CD  TO WS-DO-DEPOSIT-STATUS-CD.       
           MOVE DO-AMT-REFUNDED       TO WS-DO-AMT-REFUNDED.            
      *                                                                 25950000
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25980000
       5555-RESTORE-DEP-ON-HAND.                                        
      *                                                                 26000000
           MOVE WS-DO-ACCOUNT-NO          TO  DO-ACCOUNT-NO.            
           MOVE WS-DO-DEPOSIT-CERT-NO     TO  DO-DEPOSIT-CERT-NO.       
           MOVE WS-DO-AMT-DEPOSIT         TO  DO-AMT-DEPOSIT.           
           MOVE WS-DO-DATE-INTST-CALC-TO  TO  DO-DATE-INTST-CALC-TO.    
           MOVE WS-DO-INTRST-YTD          TO  DO-INTRST-YTD.            
           MOVE WS-DO-TOTAL-INTRST        TO  DO-TOTAL-INTRST.          
           MOVE WS-DO-CODE-REFUND-STATUS  TO  DO-CODE-REFUND-STATUS.    
           MOVE WS-DO-CODE-REFUND-REASON  TO  DO-CODE-REFUND-REASON.    
           MOVE WS-DO-DEPOSIT-STATUS-CD   TO  DO-DEPOSIT-STATUS-CD.     
           MOVE WS-DO-AMT-REFUNDED        TO  DO-AMT-REFUNDED.          
      *                                                                 26110000
       5555-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26140000
      ******************************************************************26550000
      * 5600-EDIT-AR-TYPE                                              *26560000
      *                                                                *26570000
      *     WHEN THE USER ADJUSTS THE REFUND AMOUNT AGAINST ANOTHER    *26580000
      *     DEPOSIT, CHECK IF THE OTHER DEPOSIT BELONGS TO SAME        *26590000
      *     SERVICE-TYPE (I.E. UTILITY OR CONTRACT)                    *26600000
      ******************************************************************26610000
      *                                                                 26611000
       5600-EDIT-AR-TYPE.                                               
      *                                                                 26630000
           IF PARM-THIS-CR-AMT-NUM > 0 AND PARM-THIS-AR-TYPE = '0080'   
              MOVE PARM-ACCOUNT-NO          TO  DO-ACCOUNT-NO           
              MOVE PARM-THIS-ITEM-ID        TO  DO-DEPOSIT-CERT-NO      
              PERFORM 7300-SELECT-DEP-ON-HAND   THRU 7300-EXIT          
      *                                                                 26671000
              IF DO-SERVICE-TYPE-CD NOT = PARM-SERVICE-TYPE-CD          
                 MOVE 'D5061'               TO WS-PAR-MESSAGE-NO        
              END-IF                                                    
      *                                                                 26771000
           END-IF.                                                      
      *                                                                 26790000
           IF PARM-SPEC-CR-AMT-NUM > 0 AND PARM-SPEC-AR-TYPE = '0080'   
              MOVE PARM-SPEC-ACCOUNT-NO     TO  DO-ACCOUNT-NO           
              MOVE PARM-SPEC-ITEM-ID        TO  DO-DEPOSIT-CERT-NO      
              PERFORM 7300-SELECT-DEP-ON-HAND   THRU 7300-EXIT          
      *                                                                 26831000
              IF DO-SERVICE-TYPE-CD NOT = PARM-SERVICE-TYPE-CD          
                 MOVE 'D5061'               TO WS-PAR-MESSAGE-NO        
              END-IF                                                    
      *                                                                 26931000
           END-IF.                                                      
      *                                                                 26941000
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26970000
T20346******************************************************************        
T20346* VALIDATES THE AR-AMT DIRECTED FOR A RECEIVABLE WHEN A DEPOSIT  *        
T20346* REFUND IS DIRECTED AGAINST A RECEIVABLE OF THE SAME ACCOUNT OR *        
T20346* A SPECIFIC ACCOUNT WITH SAME CUSTOMER NUMBER                   *        
T20346******************************************************************        
T20346 5800-VALIDATE-AR-AMT.                                            
T20346*                                                                         
T20346     MOVE WS-THIS-AR-AMOUNT            TO WS-AR-AMT               
T20346     IF  PARM-THIS-CR-AMT-NUM  > 0      AND                       
T20346         PARM-THIS-AR-TYPE NOT = SPACES AND                       
T20346         PARM-THIS-AR-TYPE NOT = '0000' AND                       
T20346         PARM-THIS-AR-TYPE NOT = WS-CIA                           
T20346         SUBTRACT PARM-SPEC-CR-AMT-NUM PARM-AMT-CHK-NUM           
T20346                  PARM-AMT-CASH-NUM PARM-BALANCE-AMT-NUM FROM     
T20346                  WS-AR-AMT                                       
T20346         MOVE PARM-ACCOUNT-NO          TO AC-ACCOUNT-NO           
T20346         MOVE PARM-THIS-AR-TYPE        TO AC-PYMT-PRIORITY-LVL    
T20346         MOVE PARM-THIS-ITEM-ID        TO AC-ITEM-ID              
T20346         PERFORM 5900-VALIDATE-INPUT   THRU 5900-EXIT             
T20346     END-IF                                                       
T20346*                                                                         
T20346     MOVE WS-THIS-AR-AMOUNT            TO WS-AR-AMT               
T20346     IF  PARM-SPEC-CR-AMT-NUM > 0       AND                       
T20346         PARM-SPEC-AR-TYPE NOT = SPACES AND                       
T20346         PARM-SPEC-AR-TYPE NOT = '0000' AND                       
T20346         PARM-SPEC-AR-TYPE NOT = WS-CIA                           
T20346         SUBTRACT PARM-THIS-CR-AMT-NUM  PARM-AMT-CHK-NUM          
T20346                  PARM-AMT-CASH-NUM PARM-BALANCE-AMT-NUM FROM     
T20346                  WS-AR-AMT                                       
T20346         MOVE PARM-SPEC-ACCOUNT-NO     TO AC-ACCOUNT-NO           
T20346         MOVE PARM-SPEC-AR-TYPE        TO AC-PYMT-PRIORITY-LVL    
T20346         MOVE PARM-SPEC-ITEM-ID        TO AC-ITEM-ID              
T20346         PERFORM 5900-VALIDATE-INPUT   THRU 5900-EXIT             
T20346     END-IF.                                                      
T20346*                                                                         
T20346 5800-EXIT.                                                       
T20346     EXIT.                                                        
T20346*                                                                         
T20346*****************************************************************         
T20346*   VALIDATES WHETHER THE REFUND AMOUNT DIRECTED FOR A RECEIVABLE         
T20346*   EXCEEDS FULL BALANCE OF RECEIVALBLE AND STOPS PROCESSING IF           
T20346*   IT EXCEEDS AND SENDS A ERROR MSG TO THE PANEL                         
T20346*****************************************************************         
T20346 5900-VALIDATE-INPUT.                                             
T20346*                                                                         
T20346      MOVE AC-ACCOUNT-NO               TO AT-ACCOUNT-NO           
T20346      MOVE AC-ACCOUNT-NO               TO CT-ACCOUNT-NO           
T20346      MOVE AC-PYMT-PRIORITY-LVL        TO CT-PYMT-PRIORITY-LVL    
T20346      MOVE AC-ITEM-ID                  TO CT-CNT-ITEM-ID          
T20346                                                                  
T20346      PERFORM 6702A-SELECT-AGING-DETAIL THRU 6702A-EXIT           
T20346                                                                  
T20346      IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
T20346         MOVE 'D5212'                 TO   WS-PAR-MESSAGE-NO      
T20346         MOVE 100                     TO   WS-ACTIVE-RETURN-CODE  
T20346         MOVE PROGRAM-NAME            TO   ABEND-PROGRAM          
T20346         MOVE '5900'                  TO   ACTIVE-PARAGRAPH       
T20346         MOVE 'USERABEN'              TO   ABEND-FUNCTION         
T20346         MOVE WS-YES                  TO   WS-USER-FORCE-ABEND    
T20346         MOVE SPACES                  TO   DSNTIAR-MESSAGE-1      
T20346         PERFORM 9000A-SEND-ERROR-RESULT   THRU 9000A-EXIT        
T20346         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
T20346      END-IF                                                      
T20346                                                                  
T20346      COMPUTE   WS-CURR-FULL-BAL  =  AC-AMT-AR-DAY-00 +           
T20346                                     AC-AMT-AR-DAY-30 +           
T20346                                     AC-AMT-AR-DAY-60 +           
T20346                                     AC-AMT-AR-DAY-90 +           
T20346                                     AC-AMT-UNUSED-CR +           
T20346                                     AC-TOT-SUMM-UNBILLED         
T20346                                                                  
T20346      IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
T20346          IF ( AC-PYMT-PRIORITY-LVL EQUAL                         
T20346                    19 OR 20 OR 29 OR 30 OR 39 OR 40 OR 45)       
T20346              IF ( WS-CURR-FULL-BAL < WS-AR-AMT)                  
T20346                  MOVE 'D5212'              TO   WS-PAR-MESSAGE-NO
T20346                  MOVE 100                  TO                    
T20346                                         WS-ACTIVE-RETURN-CODE    
T20346                  MOVE PROGRAM-NAME         TO   ABEND-PROGRAM    
T20346                  MOVE '5900'               TO   ACTIVE-PARAGRAPH 
T20346                  MOVE 'USERABEN'           TO   ABEND-FUNCTION   
T20346                  MOVE WS-YES               TO WS-USER-FORCE-ABEND
T20346                  MOVE SPACES               TO   DSNTIAR-MESSAGE-1
T20346                  PERFORM 9000A-SEND-ERROR-RESULT THRU 9000A-EXIT 
T20346                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT  
T20346              END-IF                                              
T20346          ELSE                                                    
T20346                                                                  
T20346              IF ( AC-PYMT-PRIORITY-LVL = 100 )                   
T20346                  MOVE AC-ACCOUNT-NO        TO CT-ACCOUNT-NO      
T20346                  MOVE AC-PYMT-PRIORITY-LVL TO                    
T20346                                              CT-PYMT-PRIORITY-LVL
T20346                  MOVE AC-ITEM-ID           TO CT-CNT-ITEM-ID     
T20346                  PERFORM 5950-SELECT-CONTRACT THRU 5950-EXIT     
T20346                  MOVE CT-INTRST-PRIOR-YR   TO                    
T20346                                                 WS-FINANCE-CHARGE
T20346                  MOVE CT-NO-SCHED-PYMTS    TO WS-NO-OF-PYMTS     
T20346                                                                  
T20346                  PERFORM 6100-COMPUTE-REBATE-AMOUNT              
T20346                                            THRU 6100-EXIT        
T20346                                                                  
T20346                  IF ( WS-AR-AMT >                                
T20346                     ( AC-AMT-TRAN-BALANCE - WS-REBATE-AMOUNT))   
T20346                      MOVE 'D5212'          TO WS-PAR-MESSAGE-NO  
T20346                      MOVE 100              TO                    
T20346                                            WS-ACTIVE-RETURN-CODE 
T20346                      MOVE PROGRAM-NAME     TO ABEND-PROGRAM      
T20346                      MOVE '5900'           TO ACTIVE-PARAGRAPH   
T20346                      MOVE 'USERABEN'       TO ABEND-FUNCTION     
T20346                      MOVE WS-YES           TO WS-USER-FORCE-ABEND
T20346                      MOVE SPACES           TO DSNTIAR-MESSAGE-1  
T20346                      PERFORM 9000A-SEND-ERROR-RESULT             
T20346                                            THRU 9000A-EXIT       
T20346                      PERFORM 9900-SQL-ERROR-ROUTINE              
T20346                                            THRU 9900-EXIT        
T20346                  END-IF                                          
T20346              ELSE                                                
T20346                                                                  
T20346                  IF ( AC-PYMT-PRIORITY-LVL >= 50 )               
T20346                      IF ( AC-AMT-TRAN-BALANCE < WS-AR-AMT)       
T20346                          MOVE 'D5212'      TO WS-PAR-MESSAGE-NO  
T20346                          MOVE 100          TO                    
T20346                                       WS-ACTIVE-RETURN-CODE      
T20346                          MOVE PROGRAM-NAME TO ABEND-PROGRAM      
T20346                          MOVE '5900'       TO ACTIVE-PARAGRAPH   
T20346                          MOVE 'USERABEN'   TO ABEND-FUNCTION     
T20346                          MOVE WS-YES       TO WS-USER-FORCE-ABEND
T20346                          MOVE SPACES       TO DSNTIAR-MESSAGE-1  
T20346                          PERFORM 9000A-SEND-ERROR-RESULT         
T20346                                            THRU 9000A-EXIT       
T20346                          PERFORM 9900-SQL-ERROR-ROUTINE          
T20346                                            THRU 9900-EXIT        
T20346                      ELSE                                        
T20346                          IF ( WS-CURR-FULL-BAL < WS-AR-AMT)      
T20346                              MOVE WS-PAR-P TO WS-PAR-PAY-AHEAD   
T20346                          END-IF                                  
T20346                      END-IF                                      
T20346                  END-IF                                          
T20346              END-IF                                              
T20346          END-IF                                                  
T20346      END-IF.                                                     
T20346                                                                  
T20346 5900-EXIT.                                                       
T20346     EXIT.                                                        
T20346                                                                  
T20346 5950-SELECT-CONTRACT.                                            
T20346                                                                  
T20346     EXEC SQL                                                     
T20346         SELECT NO_SCHED_PYMTS                                    
T20346              , INTRST_PRIOR_YR                                   
T20346           INTO :CT-NO-SCHED-PYMTS                                
T20346              , :CT-INTRST-PRIOR-YR                               
T20346           FROM  CSS_CONTRACT WITH(READUNCOMMITTED)                       
T20346          WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO               
T20346            AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL        
T20346            AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID              
P00641                                                           
P00641                                                      
T20346     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NO_SCHED_PYMTS                                            
MFA-TR*             , INTRST_PRIOR_YR                                           
MFA-TR*          INTO :CT-NO-SCHED-PYMTS                                        
MFA-TR*             , :CT-INTRST-PRIOR-YR                                       
MFA-TR*          FROM  CSS_CONTRACT                                             
MFA-TR*         WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO                       
MFA-TR*           AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL                
MFA-TR*           AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 5950                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20346                                                                  
T20346     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20346     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
T20346        MOVE WS-ACTIVE-RETURN-CODE TO WS-ACTIVE-RETURN-CODE       
T20346        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20346        MOVE '5950'                TO ACTIVE-PARAGRAPH            
T20346        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20346        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20346                                      ABEND-TABLES                
T20346        MOVE 'CSS_CONTRACT'        TO TABLE-1                     
T20346        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20346        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
T20346        MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-3             
T20346        MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20346        MOVE CT-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T20346        MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-3           
T20346        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20346        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20346     END-IF.                                                      
T20346                                                                  
T20346 5950-EXIT.                                                       
T20346     EXIT.                                                        
T20346                                                                  
           EXEC SQL                                                     27012000
              INCLUDE CPD00090                                          27013000
           END-EXEC.                                                    27014000
      *                                                                 27015000
      ************************                                          27020000
T11466     EXEC SQL                                                     27030000
T11466       INCLUDE CPD00003                                           27030100
T11466     END-EXEC.                                                    27030200
      *                                                                 27030300
      ******************************************************************27050000
      *  JOURNALING COPYBOOK.                                          *27060000
      ******************************************************************27070000
      *                                                                 27080000
           EXEC SQL                                                     27090000
              INCLUDE CPD00067                                          27100000
           END-EXEC.                                                    27110000
      *                                                                 27120000
C29752*                                                                 08290000
C29752******************************************************************09290100
C29752*  INCLUDE CPD00023 TO PROCESS DEPOSIT INTEREST CALCULATIONS     *09290200
C29752******************************************************************09290300
C29752*                                                                 09290400
C29752     EXEC SQL                                                     09291000
C29752        INCLUDE CPD00023                                          09292000
C29752     END-EXEC.                                                    09293000
C29752*                                                                 09293100
C29752*****************************************************************         
C29752* INCLUDE CPD00128 INSERT/UPDATE DEPOSIT INTEREST HISTORY       *         
C29752*****************************************************************         
C29752     EXEC SQL                                                             
C29752         INCLUDE CPD00128                                                 
C29752     END-EXEC.                                                            
C29752                                                                  
      ***************************************************************** 27130000
      *  INCLUDE COPY BOOK TO COMPUTE THE CHECK DIGIT FOR ADDRESS-ID  * 27140000
      ***************************************************************** 27150000
      *                                                                 27160000
           EXEC SQL                                                     27170000
              INCLUDE CPD00071                                          27180000
           END-EXEC.                                                    27190000
      *                                                                 27200000
      ******************************************************************27210000
      *  INCLUDE COPYBOOKS FOR A/R AND CASH DRAWER JOURNALING          *27220000
      ******************************************************************27230000
      *                                                                 27240000
           EXEC SQL                                                     27250000
A00956        INCLUDE CPD0006A                                          27260000
           END-EXEC.                                                    27270000
      *                                                                 27280000
           EXEC SQL                                                     27290000
              INCLUDE CPD00008                                          27300000
           END-EXEC.                                                    27310000
      *                                                                 27320000
           COPY CPD00010.                                               27330000
      *                                                                 27331000
           EXEC SQL                                                     27340000
              INCLUDE CPD0010S                                          27350000
           END-EXEC.                                                    27360000
      *                                                                 27370000
           EXEC SQL                                                     27380000
              INCLUDE CPD00073                                          27390000
           END-EXEC.                                                    27400000
      *                                                                 27410000
           EXEC SQL                                                     27420000
              INCLUDE CPD00075                                          27430000
           END-EXEC.                                                    27440000
      *                                                                 27450000
      ***************************************************************** 27520000
      * 7000-GET-CURRENT-DATE                                         * 27530000
      *                                                               * 27540000
      *      GET CURRENT DATE AND TIMESTAMP TO UPDATE THE JOURNALS    * 27550000
      ***************************************************************** 27560000
      *                                                                 27570000
       7000-GET-CURRENT-DATE.                                           
      *                                                                 27590000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( MONTH, -6, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE,
              :WS-DATE-6-MNT-AGO       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     27600000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             27610000
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-DATE-6-MNT-AGO    = CURRENT DATE - 6 MONTHS               
MFA-TR*    END-EXEC                                                     27720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27730000
              MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE           
      *                                                                 27760000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 27870000
       7000-EXIT.                                                       
           EXIT.                                                        
PCR360*                                                                 27900000
PCR360**************************************************************    27910000
PCR360*  7010-CHECK-PENDING-DNP                                    *    27920000
PCR360*       CHECK TO SEE IF THE ACCOUNT HAS A PENDING DNP        *    27930000
PCR360**************************************************************    27940000
PCR360*                                                                 27950000
PCR360 7010-CHECK-PENDING-DNP.                                          
PCR360*                                                                 28201000
PCR360     EXEC SQL                                                     
PCR360         SELECT CODES_DATA_PRESENT                                
PCR360          INTO  :AT-CODES-DATA-PRESENT                            
PCR360          FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                         
PCR360          WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
P00641                                                           
P00641                                                      
PCR360     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28202000
MFA-TR*        SELECT CODES_DATA_PRESENT                                28203000
MFA-TR*         INTO  :AT-CODES-DATA-PRESENT                            28204000
MFA-TR*         FROM  CSS_ACCOUNT                                       28205000
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 28206000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                    28207000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR360*                                                                 28208000
PCR360     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
PCR360         MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT  
PCR360     ELSE                                                         
PCR360         MOVE SQLCODE              TO RS-RETURN-CODE              
PCR360         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PCR360         MOVE '7010'               TO ACTIVE-PARAGRAPH            
PCR360         MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
PCR360         MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
PCR360         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
PCR360         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
PCR360         PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT   
PCR360         PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT   
PCR360     END-IF.                                                      
PCR360*                                                                 28210300
PCR360 7010-EXIT.                                                       
PCR360     EXIT.                                                        
      *                                                                 28210600
      ***************************************************************** 28211000
      * 7100-GET-REFUND-ITEM-ID                                       * 28220000
      *                                                               * 28230000
      *     GET THE LAST REFUND-ITEM-ID USED FOR THE ACCOUNT IN       * 28240000
      *     CSS_REFUND TABLE                                          * 28250000
      ***************************************************************** 28260000
      *                                                                 28270000
       7100-GET-REFUND-ITEM-ID.                                         
      *                                                                 28290000
           EXEC SQL                                                     
              SELECT MAX(REFUND_ITEM_ID)                                
              INTO   :WS-LAST-REFUND-ITEM-ID :WS-REFUND-ITEM-ID-NI       
              FROM   CSS_REFUND                                         
              WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                        
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     28300000
MFA-TR*       SELECT MAX(REFUND_ITEM_ID)                                28310000
MFA-TR*       INTO   :WS-LAST-REFUND-ITEM-ID:WS-REFUND-ITEM-ID-NI       28320000
MFA-TR*       FROM   CSS_REFUND                                         28330000
MFA-TR*       WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                        28340000
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    28350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28360000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 28380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-REFUND-ITEM-ID-NI < 0                               
                 MOVE 0      TO WS-LAST-REFUND-ITEM-ID                  
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 28540000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28570000
      ***************************************************************** 28580000
      * 7110-SELECT-REFUND                                            * 28590000
      *                                                               * 28600000
      *     GET THE REFUND RECORD DETAILS FOR THE ACCOUNT FROM        * 28610000
      *     CSS_REFUND TABLE                                          * 28620000
      ***************************************************************** 28630000
      *                                                                 28640000
       7110-SELECT-REFUND.                                              
      *                                                                 28660000
           EXEC SQL                                                     
              SELECT REFUND_ITEM_ID,                                    
                     AMT_REFUNDED,                                      
                     CHECK_ISS_REAS_CD,                                 
                     COMMENTS,                                          
                     DATE_REFUNDED,                                     
                     DATEADD( MONTH, -6, DATE_REFUNDED ),                       
                     DEPOSIT_CERT_NO,                                   
                     USER_ID_RQSTED_BY,                                 
                     CHECK_STATUS_CD,                                   
                     ADDRESS_ID                                         
              INTO   :RN-REFUND-ITEM-ID,                                
                     :RN-AMT-REFUNDED,                                  
                     :RN-CHECK-ISS-REAS-CD,                             
                     :RN-COMMENTS,                                      
                     :RN-DATE-REFUNDED,                                 
                     :WS-DATE-6-MNT-AGO,                                
                     :RN-DEPOSIT-CERT-NO,                               
                     :RN-USER-ID-RQSTED-BY,                             
                     :RN-CHECK-STATUS-CD,                               
                     :RN-ADDRESS-ID                                     
              FROM   CSS_REFUND WITH(READUNCOMMITTED)                           
              WHERE  ACCOUNT_NO       = :RN-ACCOUNT-NO AND              
                     MANUAL_INDICATOR = :RN-MANUAL-INDICATOR AND        
                     PANEL_NO         = :RN-PANEL-NO AND                
                     CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD AND         
PCR482               DEPOSIT_CERT_NO  = :RN-DEPOSIT-CERT-NO             
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     28670000
MFA-TR*       SELECT REFUND_ITEM_ID,                                    28680000
MFA-TR*              AMT_REFUNDED,                                      28690000
MFA-TR*              CHECK_ISS_REAS_CD,                                 28700000
MFA-TR*              COMMENTS,                                          28710000
MFA-TR*              DATE_REFUNDED,                                     28720000
MFA-TR*              DATE_REFUNDED - 6 MONTHS,                          28730000
MFA-TR*              DEPOSIT_CERT_NO,                                   28740000
MFA-TR*              USER_ID_RQSTED_BY,                                 28750000
MFA-TR*              CHECK_STATUS_CD,                                   28760000
MFA-TR*              ADDRESS_ID                                         28770000
MFA-TR*       INTO   :RN-REFUND-ITEM-ID,                                28780000
MFA-TR*              :RN-AMT-REFUNDED,                                  28790000
MFA-TR*              :RN-CHECK-ISS-REAS-CD,                             28800000
MFA-TR*              :RN-COMMENTS,                                      28810000
MFA-TR*              :RN-DATE-REFUNDED,                                 28820000
MFA-TR*              :WS-DATE-6-MNT-AGO,                                28830000
MFA-TR*              :RN-DEPOSIT-CERT-NO,                               28840000
MFA-TR*              :RN-USER-ID-RQSTED-BY,                             28850000
MFA-TR*              :RN-CHECK-STATUS-CD,                               28860000
MFA-TR*              :RN-ADDRESS-ID                                     28870000
MFA-TR*       FROM   CSS_REFUND                                         28880000
MFA-TR*       WHERE  ACCOUNT_NO       = :RN-ACCOUNT-NO AND              28890000
MFA-TR*              MANUAL_INDICATOR = :RN-MANUAL-INDICATOR AND        28900000
MFA-TR*              PANEL_NO         = :RN-PANEL-NO AND                28910000
MFA-TR*              CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD AND         28920000
MFA-TR*              DEPOSIT_CERT_NO  = :RN-DEPOSIT-CERT-NO             28921000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                    28930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28940000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 28960000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'MANUAL_INDICATOR'       TO TABLE-ELEMENT-2          
              MOVE 'PANEL_NO'               TO TABLE-ELEMENT-3          
              MOVE 'CHECK_STATUS_CD'        TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-MANUAL-INDICATOR      TO HOSTVAR-ELEMENT-2        
              MOVE RN-PANEL-NO              TO HOSTVAR-ELEMENT-3        
              MOVE RN-CHECK-STATUS-CD       TO HOSTVAR-ELEMENT-4        
PCR360        PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                 29210000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29240000
      *                                                                 28570000
T19068***************************************************************** 28580000
      * 7115-SELECT-REFUND                                            * 28590000
      *                                                               * 28600000
      *     GET THE REFUND RECORD DETAILS FOR THE ACCOUNT FROM        * 28610000
      *     CSS_REFUND TABLE WHOSE CHECK-STATUS-CODE = 'A' APPROVED   * 28620000
      *     OR 'R' REQUESTED.                                         *         
      ***************************************************************** 28630000
      *                                                                 28640000
T19068 7115-SELECT-REFUND.                                              
      *                                                                 28660000
           EXEC SQL                                                     
              SELECT REFUND_ITEM_ID,                                    
                     AMT_REFUNDED,                                      
                     CHECK_ISS_REAS_CD,                                 
                     COMMENTS,                                          
                     DATE_REFUNDED,                                     
                     DATEADD( MONTH, -6, DATE_REFUNDED ),                       
                     DEPOSIT_CERT_NO,                                   
                     USER_ID_RQSTED_BY,                                 
                     CHECK_STATUS_CD,                                   
                     ADDRESS_ID                                         
              INTO   :RN-REFUND-ITEM-ID,                                
                     :RN-AMT-REFUNDED,                                  
                     :RN-CHECK-ISS-REAS-CD,                             
                     :RN-COMMENTS,                                      
                     :RN-DATE-REFUNDED,                                 
                     :WS-DATE-6-MNT-AGO,                                
                     :RN-DEPOSIT-CERT-NO,                               
                     :RN-USER-ID-RQSTED-BY,                             
                     :RN-CHECK-STATUS-CD,                               
                     :RN-ADDRESS-ID                                     
              FROM   CSS_REFUND WITH(READUNCOMMITTED)                           
              WHERE  ACCOUNT_NO       = :RN-ACCOUNT-NO AND              
                     MANUAL_INDICATOR = :RN-MANUAL-INDICATOR AND        
                     PANEL_NO         = :RN-PANEL-NO AND                
                     CHECK_STATUS_CD  IN ('A','R') AND                  
                     DEPOSIT_CERT_NO  = :RN-DEPOSIT-CERT-NO             
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     28670000
MFA-TR*       SELECT REFUND_ITEM_ID,                                    28680000
MFA-TR*              AMT_REFUNDED,                                      28690000
MFA-TR*              CHECK_ISS_REAS_CD,                                 28700000
MFA-TR*              COMMENTS,                                          28710000
MFA-TR*              DATE_REFUNDED,                                     28720000
MFA-TR*              DATE_REFUNDED - 6 MONTHS,                          28730000
MFA-TR*              DEPOSIT_CERT_NO,                                   28740000
MFA-TR*              USER_ID_RQSTED_BY,                                 28750000
MFA-TR*              CHECK_STATUS_CD,                                   28760000
MFA-TR*              ADDRESS_ID                                         28770000
MFA-TR*       INTO   :RN-REFUND-ITEM-ID,                                28780000
MFA-TR*              :RN-AMT-REFUNDED,                                  28790000
MFA-TR*              :RN-CHECK-ISS-REAS-CD,                             28800000
MFA-TR*              :RN-COMMENTS,                                      28810000
MFA-TR*              :RN-DATE-REFUNDED,                                 28820000
MFA-TR*              :WS-DATE-6-MNT-AGO,                                28830000
MFA-TR*              :RN-DEPOSIT-CERT-NO,                               28840000
MFA-TR*              :RN-USER-ID-RQSTED-BY,                             28850000
MFA-TR*              :RN-CHECK-STATUS-CD,                               28860000
MFA-TR*              :RN-ADDRESS-ID                                     28870000
MFA-TR*       FROM   CSS_REFUND                                         28880000
MFA-TR*       WHERE  ACCOUNT_NO       = :RN-ACCOUNT-NO AND              28890000
MFA-TR*              MANUAL_INDICATOR = :RN-MANUAL-INDICATOR AND        28900000
MFA-TR*              PANEL_NO         = :RN-PANEL-NO AND                28910000
MFA-TR*              CHECK_STATUS_CD  IN ('A','R') AND                  28920000
MFA-TR*              DEPOSIT_CERT_NO  = :RN-DEPOSIT-CERT-NO             28921000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7115                                                      
MFA-TR*    END-EXEC.                                                    28930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28940000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 28960000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7115'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'MANUAL_INDICATOR'       TO TABLE-ELEMENT-2          
              MOVE 'PANEL_NO'               TO TABLE-ELEMENT-3          
              MOVE 'CHECK_STATUS_CD'        TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-MANUAL-INDICATOR      TO HOSTVAR-ELEMENT-2        
              MOVE RN-PANEL-NO              TO HOSTVAR-ELEMENT-3        
              MOVE RN-CHECK-STATUS-CD       TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                 29210000
       7115-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 30120000
      * 7250-SELECT-ACCOUNT                                           * 30130000
      *                                                               * 30140000
      *     SELECT THE DETAILS FROM CSS_ACCOUNT TABLE                 * 30150000
      ***************************************************************** 30160000
      *                                                                 30170000
       7250-SELECT-ACCOUNT.                                             
      *                                                                 30190000
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     TOTAL_AR_BALANCE,                                  
                     CODES_DATA_PRESENT,                                
                     CODE_COMPANY_ACCT,                                 
                     CODE_ACCT_STAT,                                    
                     COMPANY_NO,                                        
                     DATE_LAST_ACTION,                                  
                     AR_XFER_IND,                                       
                     ACCT_XFER_TO,                                      
                     BANKRUPTCY_IND,                                    
PCR360               NOTICE_EXEMPT_CD,                                  
PCR360               CODE_DISC_OK,                                      
PCR360               DATE_BILL_DAY_00,                                  
PCR360               DATE_BILL_DAY_30,                                  
PCR360               DATE_BILL_DAY_60,                                  
PCR360               DATE_BILL_DAY_90,                                  
                     CREDIT_GROUP,                                      
C28788               IVR_EXEMPT_CD                                      
              INTO   :AT-LOCAL-OFFICE,                                  
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CODE-COMPANY-ACCT,                             
                     :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :AT-DATE-LAST-ACTION,                              
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
PCR360               :AT-NOTICE-EXEMPT-CD,                              
PCR360               :AT-CODE-DISC-OK,                                  
PCR360               :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,         
PCR360               :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,         
PCR360               :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,         
PCR360               :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,         
                     :AT-CREDIT-GROUP,                                  
C28788               :AT-IVR-EXEMPT-CD                                  
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30200000
MFA-TR*       SELECT LOCAL_OFFICE,                                      30210000
MFA-TR*              CUSTOMER_NO,                                       30220000
MFA-TR*              PREMISE_NO,                                        30230000
MFA-TR*              TOTAL_AR_BALANCE,                                  30240000
MFA-TR*              CODES_DATA_PRESENT,                                30250000
MFA-TR*              CODE_COMPANY_ACCT,                                 30260000
MFA-TR*              CODE_ACCT_STAT,                                    30270000
MFA-TR*              COMPANY_NO,                                        30280000
MFA-TR*              DATE_LAST_ACTION,                                  30290000
MFA-TR*              AR_XFER_IND,                                       30300000
MFA-TR*              ACCT_XFER_TO,                                      30310000
MFA-TR*              BANKRUPTCY_IND,                                    30320000
MFA-TR*              NOTICE_EXEMPT_CD,                                  30321000
MFA-TR*              CODE_DISC_OK,                                      30322000
MFA-TR*              DATE_BILL_DAY_00,                                  30323000
MFA-TR*              DATE_BILL_DAY_30,                                  30324000
MFA-TR*              DATE_BILL_DAY_60,                                  30325000
MFA-TR*              DATE_BILL_DAY_90,                                  30326000
MFA-TR*              CREDIT_GROUP,                                      30330000
MFA-TR*              IVR_EXEMPT_CD                                              
MFA-TR*       INTO   :AT-LOCAL-OFFICE,                                  30340000
MFA-TR*              :AT-CUSTOMER-NO,                                   30350000
MFA-TR*              :AT-PREMISE-NO,                                    30360000
MFA-TR*              :AT-TOTAL-AR-BALANCE,                              30370000
MFA-TR*              :AT-CODES-DATA-PRESENT,                            30380000
MFA-TR*              :AT-CODE-COMPANY-ACCT,                             30390000
MFA-TR*              :AT-CODE-ACCT-STAT,                                30400000
MFA-TR*              :AT-COMPANY-NO,                                    30410000
MFA-TR*              :AT-DATE-LAST-ACTION,                              30420000
MFA-TR*              :AT-AR-XFER-IND,                                   30430000
MFA-TR*              :AT-ACCT-XFER-TO,                                  30440000
MFA-TR*              :AT-BANKRUPTCY-IND,                                30450000
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                              30451000
MFA-TR*              :AT-CODE-DISC-OK,                                  30452000
MFA-TR*              :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,         30453000
MFA-TR*              :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,         30454000
MFA-TR*              :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,         30455000
MFA-TR*              :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,         30456000
MFA-TR*              :AT-CREDIT-GROUP,                                  30460000
MFA-TR*              :AT-IVR-EXEMPT-CD                                          
MFA-TR*       FROM   CSS_ACCOUNT                                        30470000
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        30480000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                    30490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30500000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 30520000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 30650000
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30680000
      ***************************************************************** 30690000
      * 7260-SELECT-PREMISE                                           * 30700000
      *                                                               * 30710000
      *     SELECT THE DETAILS FROM CSS_PREMISE TABLE                 * 30720000
      ***************************************************************** 30730000
      *                                                                 30740000
       7260-SELECT-PREMISE.                                             
      *                                                                 30760000
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD,                                   
                     CODE_PREMISE_STAT                                  
              INTO   :PR-REV-DISTRICT-CD,                               
                     :PR-CODE-PREMISE-STAT                              
              FROM   CSS_PREMISE WITH(READUNCOMMITTED)                          
              WHERE  PREMISE_NO = :PR-PREMISE-NO                        
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30770000
MFA-TR*       SELECT REV_DISTRICT_CD,                                   30780000
MFA-TR*              CODE_PREMISE_STAT                                  30790000
MFA-TR*       INTO   :PR-REV-DISTRICT-CD,                               30800000
MFA-TR*              :PR-CODE-PREMISE-STAT                              30810000
MFA-TR*       FROM   CSS_PREMISE                                        30820000
MFA-TR*       WHERE  PREMISE_NO = :PR-PREMISE-NO                        30830000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                    30840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30850000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 30870000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE PR-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-2        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 31000000
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31030000
      ******************************************************************31370000
      * 7280-SELECT-CUSTOMER                                           *31380000
      *    -- THIS MODULE OBTAINS THE EMPLOYEE ACCOUNT CODE.           *31390000
      ******************************************************************31400000
      *                                                                 31401000
       7280-SELECT-CUSTOMER.                                            
      *                                                                 31420000
           EXEC SQL                                                     
               SELECT CODE_EMPL_ACCT,                                   
                      CODE_CUST_STATUS                                  
                 INTO :CU-CODE-EMPL-ACCT,                               
                      :CU-CODE-CUST-STATUS                              
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31430000
MFA-TR*        SELECT CODE_EMPL_ACCT,                                   31440000
MFA-TR*               CODE_CUST_STATUS                                  31450000
MFA-TR*          INTO :CU-CODE-EMPL-ACCT,                               31460000
MFA-TR*               :CU-CODE-CUST-STATUS                              31470000
MFA-TR*          FROM CSS_CUSTOMER                                      31480000
MFA-TR*         WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    31490000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                    31500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31510000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 31540000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7280'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 31650000
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31680000
      ******************************************************************31690000
      * 7290-SELECT-RECONNECT                                          *31700000
      *    -- THIS MODULE OBTAINS THE RECONNECT DETAIL                 *31710000
      ******************************************************************31720000
      *                                                                 31721000
       7290-SELECT-RECONNECT.                                           
      *                                                                 31740000
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT                                 
                 INTO :DL-AMT-TOT-RECONNECT                             
                 FROM CSS_RECONNECT                                     
                WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     31750000
MFA-TR*        SELECT AMT_TOT_RECONNECT                                 31760000
MFA-TR*          INTO :DL-AMT-TOT-RECONNECT                             31770000
MFA-TR*          FROM CSS_RECONNECT                                     31780000
MFA-TR*         WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      31790000
MFA-TR*       QUERYNO 7290                                                      
MFA-TR*    END-EXEC.                                                    31800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31810000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 31840000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7290'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 31970000
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32000000
      ***************************************************************** 32010000
      * 7300-SELECT-DEP-ON-HAND                                       * 32020000
      *                                                               * 32030000
      *     SELECT THE DETAILS FROM CSS_DEP_ON_HAND TABLE             * 32040000
      ***************************************************************** 32050000
      *                                                                 32060000
       7300-SELECT-DEP-ON-HAND.                                         
      *                                                                 32080000
           EXEC SQL                                                     
              SELECT AMT_DEPOSIT,                                       
                     AMT_REFUNDED,                                      
                     INTRST_YTD,                                        
                     TOTAL_INTRST,                                      
                     DATE_PYMT_START,                                   
C29752               DATE_INTST_CALC_TO,                                
                     CODE_REFUND_STATUS,                                
                     CODE_REFUND_REASON,                                
                     DEPOSIT_STATUS_CD,                                 
                     SERVICE_TYPE_CD                                    
              INTO   :DO-AMT-DEPOSIT,                                   
                     :DO-AMT-REFUNDED,                                  
                     :DO-INTRST-YTD,                                    
                     :DO-TOTAL-INTRST,                                  
                     :DO-DATE-PYMT-START :WS-DATE-PYMT-START-NI,         
C29752               :DO-DATE-INTST-CALC-TO :WS-DATE-INTST-CALC-TO-NI,   
                     :DO-CODE-REFUND-STATUS,                            
                     :DO-CODE-REFUND-REASON,                            
                     :DO-DEPOSIT-STATUS-CD,                             
                     :DO-SERVICE-TYPE-CD                                
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          
                     ACCOUNT_NO      = :DO-ACCOUNT-NO                   
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32090000
MFA-TR*       SELECT AMT_DEPOSIT,                                       32100000
MFA-TR*              AMT_REFUNDED,                                      32110000
MFA-TR*              INTRST_YTD,                                        32120000
MFA-TR*              TOTAL_INTRST,                                      32130000
MFA-TR*              DATE_PYMT_START,                                   32140000
MFA-TR*              DATE_INTST_CALC_TO,                                32150000
MFA-TR*              CODE_REFUND_STATUS,                                32170000
MFA-TR*              CODE_REFUND_REASON,                                32180000
MFA-TR*              DEPOSIT_STATUS_CD,                                 32190000
MFA-TR*              SERVICE_TYPE_CD                                    32200000
MFA-TR*       INTO   :DO-AMT-DEPOSIT,                                   32210000
MFA-TR*              :DO-AMT-REFUNDED,                                  32220000
MFA-TR*              :DO-INTRST-YTD,                                    32230000
MFA-TR*              :DO-TOTAL-INTRST,                                  32240000
MFA-TR*              :DO-DATE-PYMT-START:WS-DATE-PYMT-START-NI,         32250000
MFA-TR*              :DO-DATE-INTST-CALC-TO:WS-DATE-INTST-CALC-TO-NI,   32260000
MFA-TR*              :DO-CODE-REFUND-STATUS,                            32280000
MFA-TR*              :DO-CODE-REFUND-REASON,                            32290000
MFA-TR*              :DO-DEPOSIT-STATUS-CD,                             32300000
MFA-TR*              :DO-SERVICE-TYPE-CD                                32310000
MFA-TR*       FROM   CSS_DEP_ON_HAND                                    32320000
MFA-TR*       WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          32330000
MFA-TR*              ACCOUNT_NO      = :DO-ACCOUNT-NO                   32340000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    32350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32360000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 32380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-INTST-CALC-TO-NI < 0                           
                 MOVE SPACES      TO DO-DATE-INTST-CALC-TO              
              END-IF                                                    
              IF WS-DATE-PYMT-START-NI < 0                              
                 MOVE SPACES      TO DO-DATE-PYMT-START                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-1          
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 32530000
       7300-EXIT.                                                       
           EXIT.                                                        
C29752*                                                                 13810000
      ******************************************************************13820000
      * 7305-SELECT-DEP-ON-HAND                                        *13830000
      *                                                                *13840000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13850000
      *                 9900-SQL-ERROR-ROUTINE                         *13860000
      *                                                                *13870000
      *     SELECT DEP ON HAND INFO FOR A SINGLE DEPOSIT.              *13900000
      *     PUTS DO-DATE-INTST-CAL-TO + 1 DAY IN DO-DATE-INTST-CAL-TO  *        
      ******************************************************************13910000
      *                                                                 13920000
       7305-SELECT-DEP-ON-HAND.                                         
      *                                                                 13940000
           MOVE '7305'                          TO ACTIVE-PARAGRAPH.    
      *                                                                 13960000
           EXEC SQL                                                     
               SELECT                                                   
                      SERVICE_TYPE_CD,                                  
                      DEPOSIT_CERT_NO,                                  
                      DATE_PYMT_START,                                  
                      DATE_CERT_ISSUE,                                  
                      COMMENTS,                                         
C29752                DATE_INTST_CALC_TO                                
T31755         INTO  :DO-SERVICE-TYPE-CD,                               
                     :DO-DEPOSIT-CERT-NO,                               
                     :DO-DATE-PYMT-START :WS-NULL-IND-1,                
                     :DO-DATE-CERT-ISSUE :WS-NULL-IND-2,                
                     :DO-COMMENTS,                                      
                     :DO-DATE-INTST-CALC-TO :WS-NULL-INDICATOR-5        
               FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO          = :DO-ACCOUNT-NO               
                 AND DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO          
                 AND (DEPOSIT_STATUS_CD = 'A' OR                        
                      DEPOSIT_STATUS_CD = 'P')                          
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13970000
MFA-TR*        SELECT                                                   13980000
MFA-TR*               SERVICE_TYPE_CD,                                  14000000
MFA-TR*               DEPOSIT_CERT_NO,                                  14010000
MFA-TR*               DATE_PYMT_START,                                  14020000
MFA-TR*               DATE_CERT_ISSUE,                                  14030000
MFA-TR*               COMMENTS,                                         14040000
MFA-TR*               DATE_INTST_CALC_TO                                14050000
MFA-TR*        INTO  :DO-SERVICE-TYPE-CD,                               14070000
MFA-TR*              :DO-DEPOSIT-CERT-NO,                               14080000
MFA-TR*              :DO-DATE-PYMT-START :WS-NULL-IND-1,                14090000
MFA-TR*              :DO-DATE-CERT-ISSUE :WS-NULL-IND-2,                14100000
MFA-TR*              :DO-COMMENTS,                                      14110000
MFA-TR*              :DO-DATE-INTST-CALC-TO :WS-NULL-INDICATOR-5        14120000
MFA-TR*        FROM CSS_DEP_ON_HAND                                     14130000
MFA-TR*        WHERE ACCOUNT_NO          = :DO-ACCOUNT-NO               14140000
MFA-TR*          AND DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO          14150000
MFA-TR*          AND (DEPOSIT_STATUS_CD = 'A' OR                        14160000
MFA-TR*               DEPOSIT_STATUS_CD = 'P')                          14161000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7305                                                      
MFA-TR*    END-EXEC.                                                    14170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14171000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 14181000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1 < ZERO                                   
                  MOVE LOW-VALUES            TO DO-DATE-PYMT-START      
              END-IF                                                    
              IF WS-NULL-IND-2 < ZERO                                   
                  MOVE LOW-VALUES            TO DO-DATE-CERT-ISSUE      
              END-IF                                                    
              IF WS-NULL-INDICATOR-5 < ZERO                             
                  MOVE LOW-VALUES            TO DO-DATE-INTST-CALC-TO   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEP_ON_HAND'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE DO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO'         TO TABLE-ELEMENT-2         
              MOVE DO-DEPOSIT-CERT-NO        TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 14371000
       7305-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32560000
      ***************************************************************** 32570000
      * 7310-OPEN-DEP-ON-HAND                                         * 32580000
      *                                                               * 32590000
      *     OPEN THE CURSOR TO SELECT DETAILS FROM CSS_DEP_ON_HAND    * 32600000
      ***************************************************************** 32610000
      *                                                                 32620000
       7310-OPEN-DEP-ON-HAND.                                           
      *                                                                 32640000
           EXEC SQL                                                     
              OPEN DEP_ON_HAND                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32680000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 32700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'OPEN'                   TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'SERVICE_TYPE_CD'        TO TABLE-ELEMENT-2          
CBSI          MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-3          
              MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DO-SERVICE-TYPE-CD       TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 32830000
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32860000
      ***************************************************************** 32870000
      * 7320-FETCH-DEP-ON-HAND                                        * 32880000
      *                                                               * 32890000
      *    FETCH THE DETAILS FROM DEP_ON_HAND CURSOR                  * 32900000
      ***************************************************************** 32910000
      *                                                                 32920000
       7320-FETCH-DEP-ON-HAND.                                          
      *                                                                 32940000
           EXEC SQL                                                     
              FETCH  DEP_ON_HAND                                        
              INTO   :DO-DEPOSIT-CERT-NO,                               
                     :DO-AMT-DEPOSIT,                                   
                     :DO-AMT-REFUNDED,                                  
                     :DO-INTRST-YTD,                                    
                     :DO-TOTAL-INTRST,                                  
                     :DO-DATE-PYMT-START :WS-DATE-PYMT-START-NI,         
C29752               :DO-DATE-INTST-CALC-TO :WS-DATE-INTST-CALC-TO-NI,   
                     :DO-CODE-REFUND-STATUS,                            
                     :DO-CODE-REFUND-REASON,                            
                     :DO-DEPOSIT-STATUS-CD,                             
PCR482               :DO-DATE-CERT-ISSUE :WS-DATE-CERT-ISSUE-NI          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33090000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 33110000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-INTST-CALC-TO-NI < 0                           
                 MOVE SPACES      TO DO-DATE-INTST-CALC-TO              
              END-IF                                                    
PCR482        IF WS-DATE-CERT-ISSUE-NI < 0                              
PCR482           MOVE SPACES      TO DO-DATE-CERT-ISSUE                 
PCR482        END-IF                                                    
              IF WS-DATE-PYMT-START-NI < 0                              
                 MOVE SPACES      TO DO-DATE-PYMT-START                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'FETCH'                  TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'SERVICE_TYPE_CD'        TO TABLE-ELEMENT-2          
CBSI          MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-3          
              MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DO-SERVICE-TYPE-CD       TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 33260000
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33290000
      ***************************************************************** 33300000
      * 7330-CLOSE-DEP-ON-HAND                                        * 33310000
      *                                                               * 33320000
      *     CLOSE THE DEP_ON_HAND CURSOR                              * 33330000
      ***************************************************************** 33340000
      *                                                                 33350000
       7330-CLOSE-DEP-ON-HAND.                                          
      *                                                                 33370000
           EXEC SQL                                                     
              CLOSE DEP_ON_HAND                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33410000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 33430000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7330'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'CLOSE'                  TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'SERVICE_TYPE_CD'        TO TABLE-ELEMENT-2          
CBSI          MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-3          
              MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DO-SERVICE-TYPE-CD       TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 33560000
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33590000
      ******************************************************************33600000
      **    7350-OPEN-DEP-PAY-HST                                     **33610000
      **                                                              **33620000
      **    OPEN CURSOR FOR     CSS_DEP_PAY_HST                       **33630000
      **                                                              **33640000
      ******************************************************************33650000
      *                                                                 33660000
       7350-OPEN-DEP-PAY-HST.                                           
      *                                                                 33680000
           EXEC SQL                                                     
               OPEN DEP_PAY_HST                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33720000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 33731000
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7350'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
              MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 33870000
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33900000
      ******************************************************************33910000
      **    7360-FETCH-DEP-PAY-HST                                    **33920000
      **                                                              **33930000
      **    FETCH  COLUMNS FROM CSS_DEP_PAY_HST                       **33940000
      **                                                              **33950000
      ******************************************************************33960000
      *                                                                 33961000
       7360-FETCH-DEP-PAY-HST.                                          
      *                                                                 33980000
           EXEC SQL                                                     
               FETCH  DEP_PAY_HST                                       
               INTO   :DP-DEP-PAY-DT :WS-DEP-PAY-DT-NI,                 
                      :DP-DEP-PAY-AMT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34040000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 34051000
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              OR NOT-FOUND                                              
              IF WS-DEP-PAY-DT-NI < 0                                   
                  MOVE LOW-VALUES TO DP-DEP-PAY-DT                      
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7360'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
              MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 34220000
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34250000
      ******************************************************************34260000
      **    7370-CLOSE-DEP-PAY-HST                                    **34270000
      **                                                              **34280000
      **    CLOSE CURSOR FOR    CSS_DEP_PAY_HST                       **34290000
      **                                                              **34300000
      ******************************************************************34310000
      *                                                                 34320000
       7370-CLOSE-DEP-PAY-HST.                                          
      *                                                                 34340000
           EXEC SQL                                                     
               CLOSE DEP_PAY_HST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34380000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 34391000
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7370'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
              MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 34530000
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34560000
T11846 7380-SELECT-CRED-COLL.                                           
                                                                        
T11846     EXEC SQL                                                     
                SELECT DATE_CREDIT_ACTION,                              
                       DATE_NOTICE_MAIL                                 
                INTO   :CL-DATE-CREDIT-ACTION :DATE-CREDIT-ACTION-NI,    
                       :CL-DATE-NOTICE-MAIL :DATE-NOTICE-MAIL-NI         
                FROM   CSS_CRED_COLL WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
                       ITEM_ID          = :CL-ITEM-ID    AND            
                       CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     34560300
MFA-TR*         SELECT DATE_CREDIT_ACTION,                              34560400
MFA-TR*                DATE_NOTICE_MAIL                                 34560500
MFA-TR*         INTO   :CL-DATE-CREDIT-ACTION:DATE-CREDIT-ACTION-NI,    34560600
MFA-TR*                :CL-DATE-NOTICE-MAIL:DATE-NOTICE-MAIL-NI         34560700
MFA-TR*         FROM   CSS_CRED_COLL                                    34560800
MFA-TR*         WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            34560900
MFA-TR*                ITEM_ID          = :CL-ITEM-ID    AND            34561000
MFA-TR*                CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          34561100
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7380                                                      
MFA-TR*    END-EXEC.                                                    34561200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T11846     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF DATE-CREDIT-ACTION-NI < ZEROES                         
                 MOVE SPACES                    TO CL-DATE-CREDIT-ACTION
              END-IF                                                    
              IF DATE-NOTICE-MAIL-NI < ZEROES                           
                 MOVE SPACES                    TO CL-DATE-NOTICE-MAIL  
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
CBSI             MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7380'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
CBSI             MOVE SPACES                    TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
                 MOVE 'CSS_CRED_COLL'           TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2      
                 MOVE 'CODE_NOTICE_TYPE'        TO TABLE-ELEMENT-3      
                 MOVE CL-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
                 MOVE CL-ITEM-ID                TO HOSTVAR-ELEMENT-2    
                 MOVE CL-CODE-NOTICE-TYPE       TO HOSTVAR-ELEMENT-3    
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
T11846 7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T11846 7385-DELETE-CRED-COLL.                                           
                                                                        
T11846     EXEC SQL                                                     
                DELETE FROM CSS_CRED_COLL                               
                WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
                       ITEM_ID          = :CL-ITEM-ID    AND            
                       CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     34564600
MFA-TR*         DELETE FROM CSS_CRED_COLL                               34564700
MFA-TR*         WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            34564800
MFA-TR*                ITEM_ID          = :CL-ITEM-ID    AND            34564900
MFA-TR*                CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          34565000
MFA-TR*       QUERYNO 7385                                                      
MFA-TR*    END-EXEC.                                                    34565100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T11846     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7385'                       TO ACTIVE-PARAGRAPH     
              MOVE 'DELETE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_CRED_COLL'              TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'ITEM_ID'                    TO TABLE-ELEMENT-2      
              MOVE 'CODE_NOTICE_TYPE'           TO TABLE-ELEMENT-3      
              MOVE CL-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE CL-ITEM-ID                   TO HOSTVAR-ELEMENT-2    
              MOVE CL-CODE-NOTICE-TYPE          TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
T11846 7385-EXIT.                                                       
           EXIT.                                                        
                                                                        
T11846 7390-UPDATE-CRED-COLL.                                           
                                                                        
T11846     EXEC SQL                                                     
                UPDATE CSS_CRED_COLL                                    
                SET    AMT_NOTICE       = :DO-AMT-DEPOSIT               
                WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
                       ITEM_ID          = :CL-ITEM-ID    AND            
                       CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T11846     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7390'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_CRED_COLL'              TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'ITEM_ID'                    TO TABLE-ELEMENT-2      
              MOVE 'CODE_NOTICE_TYPE'           TO TABLE-ELEMENT-3      
CBSI          MOVE 'AMT_NOTICE'                 TO TABLE-ELEMENT-4      
              MOVE CL-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE CL-ITEM-ID                   TO HOSTVAR-ELEMENT-2    
              MOVE CL-CODE-NOTICE-TYPE          TO HOSTVAR-ELEMENT-3    
CBSI          MOVE DO-AMT-DEPOSIT               TO HOSTVAR-ELEMENT-4-N  
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
T11846 7390-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 34571000
      * 7400-SELECT-AR-CNTL                                           * 34580000
      *                                                               * 34590000
      *     SELECT THE DETAILS FROM CSS_AR_CNTL TABLE                 * 34600000
      ***************************************************************** 34610000
      *                                                                 34620000
       7400-SELECT-AR-CNTL.                                             
      *                                                                 34640000
           EXEC SQL                                                     
              SELECT AMT_TRAN_BALANCE,                                  
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90                                      
              INTO   :AC-AMT-TRAN-BALANCE,                              
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90                                  
              FROM   CSS_AR_CNTL                                        
              WHERE  ACCOUNT_NO = :AC-ACCOUNT-NO  AND                   
                     ITEM_ID    = :AC-ITEM-ID     AND                   
                     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     34650000
MFA-TR*       SELECT AMT_TRAN_BALANCE,                                  34660000
MFA-TR*              AMT_AR_DAY_00,                                     34670000
MFA-TR*              AMT_AR_DAY_30,                                     34680000
MFA-TR*              AMT_AR_DAY_60,                                     34690000
MFA-TR*              AMT_AR_DAY_90                                      34700000
MFA-TR*       INTO   :AC-AMT-TRAN-BALANCE,                              34710000
MFA-TR*              :AC-AMT-AR-DAY-00,                                 34720000
MFA-TR*              :AC-AMT-AR-DAY-30,                                 34730000
MFA-TR*              :AC-AMT-AR-DAY-60,                                 34740000
MFA-TR*              :AC-AMT-AR-DAY-90                                  34750000
MFA-TR*       FROM   CSS_AR_CNTL                                        34760000
MFA-TR*       WHERE  ACCOUNT_NO = :AC-ACCOUNT-NO  AND                   34770000
MFA-TR*              ITEM_ID    = :AC-ITEM-ID     AND                   34780000
MFA-TR*              PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          34790000
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                    34800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34810000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 34830000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0       TO AC-AMT-TRAN-BALANCE                    
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2          
              MOVE AC-ITEM-ID               TO HOSTVAR-ELEMENT-2        
              MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-3          
              MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 35020000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35050000
      ***************************************************************** 35060000
      * 7410-SELECT-AR-SUMM                                           * 35070000
      *                                                               * 35080000
      *     SELECT THE SUMMARY RECORD FROM CSS_AR_CNTL TABLE          * 35090000
      ***************************************************************** 35100000
      *                                                                 35110000
       7410-SELECT-AR-SUMM.                                             
      *                                                                 35130000
           EXEC SQL                                                     
              SELECT AMT_TRAN_BALANCE,                                  
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90                                      
              INTO   :WS-SUMM-AMT-TRAN-BALANCE,                         
                     :WS-SUMM-AMT-AR-DAY-00,                            
                     :WS-SUMM-AMT-AR-DAY-30,                            
                     :WS-SUMM-AMT-AR-DAY-60,                            
                     :WS-SUMM-AMT-AR-DAY-90                             
              FROM   CSS_AR_CNTL                                        
              WHERE  ACCOUNT_NO = :AC-ACCOUNT-NO  AND                   
                     ITEM_ID    = 0               AND                   
                     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     35140000
MFA-TR*       SELECT AMT_TRAN_BALANCE,                                  35150000
MFA-TR*              AMT_AR_DAY_00,                                     35160000
MFA-TR*              AMT_AR_DAY_30,                                     35170000
MFA-TR*              AMT_AR_DAY_60,                                     35180000
MFA-TR*              AMT_AR_DAY_90                                      35190000
MFA-TR*       INTO   :WS-SUMM-AMT-TRAN-BALANCE,                         35200000
MFA-TR*              :WS-SUMM-AMT-AR-DAY-00,                            35210000
MFA-TR*              :WS-SUMM-AMT-AR-DAY-30,                            35220000
MFA-TR*              :WS-SUMM-AMT-AR-DAY-60,                            35230000
MFA-TR*              :WS-SUMM-AMT-AR-DAY-90                             35240000
MFA-TR*       FROM   CSS_AR_CNTL                                        35250000
MFA-TR*       WHERE  ACCOUNT_NO = :AC-ACCOUNT-NO  AND                   35260000
MFA-TR*              ITEM_ID    = 0               AND                   35270000
MFA-TR*              PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          35280000
MFA-TR*       QUERYNO 7410                                                      
MFA-TR*    END-EXEC.                                                    35290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35300000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 35320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7410'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2          
              MOVE '0'                      TO HOSTVAR-ELEMENT-2        
              MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-3          
              MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 35490000
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35520000
      ******************************************************************35530000
      * 7420-SELECT-GL-ACCT-NO                                         *35540000
      *    -- THIS MODULE OBTAINS THE GL ACCOUNT NUMBER FOR A DEPOSIT  *35550000
      ******************************************************************35560000
      *                                                                 35561000
       7420-SELECT-GL-ACCT-NO.                                          
      *                                                                 35580000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
MCR310*         WHERE COMPANY_NO   = :GO-COMPANY-NO                     35630000
MCR310          WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35590000
MFA-TR*        SELECT GL_ACCT_NO                                        35600000
MFA-TR*          INTO :GO-GL-ACCT-NO                                    35610000
MFA-TR*          FROM CSS_GL_ACCT_NO                                    35620000
MFA-TR*         WHERE COMPANY_NO   = :GO-COMPANY-NO                     35630000
MFA-TR*         WHERE COMPANY_NO   = '01'                               35630000
MFA-TR*           AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   35640000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7420                                                      
MFA-TR*    END-EXEC.                                                    35650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35660000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 35690000
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO GO-GL-ACCT-NO               
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7420'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 35860000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35890000
A00870*************************************************************     15470000
A00870* THIS PARA READS CSS_AR_CNTL TO FIND IF THERE ARE ANY DEPOSIT    15480000
A00870* RECORD. IF NOT FOUND, THEN THE SUMMARY RECORD CAN BE DELETED.   15490000
A00870*************************************************************     15500000
A00870 7430-SELECT-ARCNTL.                                              
A00870                                                                  
A00870     EXEC SQL                                                     
A00870        SELECT TOP(1) 'Y'                                                
A00870           INTO :WS-DEP-DET-FOUND                                 
A00870        FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
A00870           WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO AND                
A00870                  PYMT_PRIORITY_LVL = 080      AND                
A00870                  ITEM_ID  <>  0               AND                
A00870                  ITEM_ID  <> :DO-DEPOSIT-CERT-NO                 
A00870                                              
P00641                                                           
P00641                                                      
A00870     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15530000
MFA-TR*       SELECT 'Y'                                                15540000
MFA-TR*          INTO :WS-DEP-DET-FOUND                                 15550000
MFA-TR*       FROM CSS_AR_CNTL                                          15560000
MFA-TR*          WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO AND                15570000
MFA-TR*                 PYMT_PRIORITY_LVL = 080      AND                15580000
MFA-TR*                 ITEM_ID  <>  0               AND                15590000
MFA-TR*                 ITEM_ID  <> :DO-DEPOSIT-CERT-NO                 15600000
MFA-TR*       FETCH FIRST ROW ONLY                                      15610000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7430                                                      
MFA-TR*    END-EXEC.                                                    15620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00870*                                                                 15630000
A00870     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A00870*                                                                 15650000
A00870     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00870        CONTINUE                                                  
A00870     ELSE                                                         
A00870        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
A00870        MOVE 'SELECT'                     TO ABEND-FUNCTION       
A00870        MOVE '7430'                       TO ACTIVE-PARAGRAPH     
A00870        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
A00870                                             ABEND-TABLES         
A00870        MOVE 'CSS_AR_CNTL'                TO TABLE-1              
A00870        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
A00870        MOVE AC-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
A00870        MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
A00870        MOVE DO-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2    
A00870        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
A00870     END-IF.                                                      
A00870                                                                  
A00870 7430-EXIT.                                                       
A00870      EXIT.                                                       
      *                                                                 15790000
      ******************************************************************35900000
      * 7500-OPEN-DEP-REQ                                              *35910000
      *      OPEN THE CURSOR TO SELECT DEP_REQ DETAILS FOR A GIVEN     *35920000
      *      ACCOUNT-NO WITH PAYMENT PRIORITY = 80                     *35930000
      ******************************************************************35940000
      *                                                                 35950000
       7500-OPEN-DEP-REQ.                                               
      *                                                                 35970000
           EXEC SQL                                                     
                OPEN DEP_REQ                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36010000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36021000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE '7500'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'          TO TABLE-ELEMENT-2      
CBSI          MOVE '080'                        TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
            END-IF.                                                     
      *                                                                 36160000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36190000
       7510-FETCH-DEP-REQ.                                              
      *                                                                 36210000
           EXEC SQL                                                     
                FETCH  DEP_REQ                                          
                INTO   :WS-DEP-REQ-EXISTS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36260000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36271000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-DEP-REQ-EXISTS                       
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7510'                       TO ACTIVE-PARAGRAPH     
              MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT-PRIORITY-LVL'          TO TABLE-ELEMENT-2      
              MOVE '080'                        TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 36430000
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36460000
       7520-CLOSE-DEP-REQ.                                              
      *                                                                 36480000
           EXEC SQL                                                     
                CLOSE DEP_REQ                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36520000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36531000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7520'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'          TO TABLE-ELEMENT-2      
              MOVE '080'                        TO HOSTVAR-ELEMENT-2    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 36670000
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36700000
      ******************************************************************36710000
      * 7600-OPEN-DEP-EXISTS                                           *36720000
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *36730000
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A' OR 'P'               *36740000
      ******************************************************************36750000
      *                                                                 36760000
       7600-OPEN-DEP-EXISTS.                                            
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN DEP_EXISTS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE '7600'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
            END-IF.                                                     
      *                                                                 36950000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36980000
       7610-FETCH-DEP-EXISTS.                                           
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  DEP_EXISTS                                       
                INTO   :WS-DEP-ON-HAND-EXISTS                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-DEP-ON-HAND-EXISTS                   
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7610'                       TO ACTIVE-PARAGRAPH     
              MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 37200000
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37230000
       7620-CLOSE-DEP-EXISTS.                                           
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE DEP_EXISTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7620'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 37420000
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37450000
      ***************************************************************** 37450100
      * 7990-SELECT-DEP-PAY-AMT                                       * 37451000
      *                                                               * 37452000
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 37453000
      ***************************************************************** 37454000
      *                                                                 37455000
PCR482 7990-SELECT-DEP-PAY-AMT.                                         
      *                                                                 37457000
PCR482     EXEC SQL                                                     
PCR482        SELECT   SUM(DEP_PAY_AMT)                                 
PCR482          INTO   :WS-TOTAL-PAYMENTS :WS-TOTAL-PAYMENTS-NI          
PCR482          FROM   CSS_DEP_PAY_HST                                  
PCR482         WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
PCR482           AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
P00641                                                      
PCR482     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     37458000
MFA-TR*       SELECT   SUM(DEP_PAY_AMT)                                 37459000
MFA-TR*         INTO   :WS-TOTAL-PAYMENTS:WS-TOTAL-PAYMENTS-NI          37459100
MFA-TR*         FROM   CSS_DEP_PAY_HST                                  37459200
MFA-TR*        WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               37459300
MFA-TR*          AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          37459400
MFA-TR*       QUERYNO 7990                                                      
MFA-TR*    END-EXEC.                                                    37459500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37459600
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 37459800
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PCR482         IF WS-TOTAL-PAYMENTS-NI < 0                              
PCR482             MOVE ZEROES      TO WS-TOTAL-PAYMENTS                
PCR482         END-IF                                                   
PCR482     ELSE                                                         
CBSI           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
PCR482         MOVE '7990'                       TO ACTIVE-PARAGRAPH    
PCR482         MOVE 'SELECT'                     TO ABEND-FUNCTION      
CBSI           MOVE SPACES                       TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
PCR482         MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1             
PCR482         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
CBSI           MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2     
PCR482         MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
CBSI           MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2   
PCR482         PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT      
PCR482     END-IF.                                                      
      *                                                                 37461100
PCR482 7990-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                 37461400
      ***************************************************************** 37462000
      * 8200-INSERT-REFUND                                            * 37470000
      *                                                               * 37480000
      *      INSERT REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 37490000
      ***************************************************************** 37500000
      *                                                                 37510000
       8200-INSERT-REFUND.                                              
      *                                                                 37530000
           EXEC SQL                                                     
              INSERT INTO CSS_REFUND                                    
                     (ACCOUNT_NO,                                       
                      REFUND_ITEM_ID,                                   
                      AMT_REFUNDED,                                     
                      CHECK_STATUS_CD,                                  
                      CHECK_ISS_REAS_CD,                                
                      COMMENTS,                                         
                      DATE_REFUNDED,                                    
                      REQUEST_DT,                                       
                      DEPOSIT_CERT_NO,                                  
                      PANEL_NO,                                         
                      USER_ID_RQSTED_BY,                                
                      MANUAL_INDICATOR,                                 
                      REFUND_CHECK_NO,                                  
                      LOCAL_OFFICE,                                     
                      ORIGINAL_CHECK_NO,                                
                      RETURNED_REASON,                                  
                      USER_ID_APPRVD_BY,                                
                      REFUND_STATUS_DT,                                 
                      TRANS_HIST_SEQ_NO,                                
                      ADDRESS_ID,                                       
PCR482                ACCT_NO_CREDITED)                                 
              VALUES (:RN-ACCOUNT-NO,                                   
                      :RN-REFUND-ITEM-ID,                               
                      :RN-AMT-REFUNDED,                                 
                      :RN-CHECK-STATUS-CD,                              
                      :RN-CHECK-ISS-REAS-CD,                            
                      :RN-COMMENTS,                                     
                      IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) ),                           
T20626                IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                            :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-1) ),            
                      :RN-DEPOSIT-CERT-NO,                              
                      :RN-PANEL-NO,                                     
                      :RN-USER-ID-RQSTED-BY,                            
                      :RN-MANUAL-INDICATOR,                             
                      :RN-REFUND-CHECK-NO,                              
                      :RN-LOCAL-OFFICE,                                 
                      :RN-ORIGINAL-CHECK-NO,                            
                      :RN-RETURNED-REASON,                              
                      :RN-USER-ID-APPRVD-BY,                            
                      IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
                      CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                
                      :RN-ADDRESS-ID,                                   
                      :RN-ACCT-NO-CREDITED)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     37540000
MFA-TR*       INSERT INTO CSS_REFUND                                    37550000
MFA-TR*              (ACCOUNT_NO,                                       37560000
MFA-TR*               REFUND_ITEM_ID,                                   37570000
MFA-TR*               AMT_REFUNDED,                                     37580000
MFA-TR*               CHECK_STATUS_CD,                                  37590000
MFA-TR*               CHECK_ISS_REAS_CD,                                37600000
MFA-TR*               COMMENTS,                                         37610000
MFA-TR*               DATE_REFUNDED,                                    37620000
MFA-TR*               REQUEST_DT,                                       37621000
MFA-TR*               DEPOSIT_CERT_NO,                                  37630000
MFA-TR*               PANEL_NO,                                         37640000
MFA-TR*               USER_ID_RQSTED_BY,                                37650000
MFA-TR*               MANUAL_INDICATOR,                                 37660000
MFA-TR*               REFUND_CHECK_NO,                                  37670000
MFA-TR*               LOCAL_OFFICE,                                     37680000
MFA-TR*               ORIGINAL_CHECK_NO,                                37690000
MFA-TR*               RETURNED_REASON,                                  37700000
MFA-TR*               USER_ID_APPRVD_BY,                                37710000
MFA-TR*               REFUND_STATUS_DT,                                 37720000
MFA-TR*               TRANS_HIST_SEQ_NO,                                37730000
MFA-TR*               ADDRESS_ID,                                       37740000
MFA-TR*               ACCT_NO_CREDITED)                                 37741000
MFA-TR*       VALUES (:RN-ACCOUNT-NO,                                   37750000
MFA-TR*               :RN-REFUND-ITEM-ID,                               37760000
MFA-TR*               :RN-AMT-REFUNDED,                                 37770000
MFA-TR*               :RN-CHECK-STATUS-CD,                              37780000
MFA-TR*               :RN-CHECK-ISS-REAS-CD,                            37790000
MFA-TR*               :RN-COMMENTS,                                     37800000
MFA-TR*               :RN-DATE-REFUNDED,                                37810000
MFA-TR*               :RN-REQUEST-DT:WS-RN-NULL-IND-1,                  37811000
MFA-TR*               :RN-DEPOSIT-CERT-NO,                              37820000
MFA-TR*               :RN-PANEL-NO,                                     37830000
MFA-TR*               :RN-USER-ID-RQSTED-BY,                            37840000
MFA-TR*               :RN-MANUAL-INDICATOR,                             37850000
MFA-TR*               :RN-REFUND-CHECK-NO,                              37860000
MFA-TR*               :RN-LOCAL-OFFICE,                                 37870000
MFA-TR*               :RN-ORIGINAL-CHECK-NO,                            37880000
MFA-TR*               :RN-RETURNED-REASON,                              37890000
MFA-TR*               :RN-USER-ID-APPRVD-BY,                            37900000
MFA-TR*               :RN-REFUND-STATUS-DT,                             37910000
MFA-TR*               :RN-TRANS-HIST-SEQ-NO,                            37920000
MFA-TR*               :RN-ADDRESS-ID,                                   37930000
MFA-TR*               :RN-ACCT-NO-CREDITED)                             37931000
MFA-TR*    END-EXEC.                                                    37940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37950000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 37970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'AMT_REFUNDED'           TO TABLE-ELEMENT-3          
CBSI          MOVE 'CHECK_STATUS_CD'        TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE RN-AMT-REFUNDED          TO HOSTVAR-ELEMENT-3-N      
CBSI          MOVE RN-CHECK-STATUS-CD       TO HOSTVAR-ELEMENT-4        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 38140000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38170000
      ***************************************************************** 38180000
      * 8210-UPDATE-REFUND                                            * 38190000
      *                                                               * 38200000
      *      UPDATE REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 38210000
      ***************************************************************** 38220000
      *                                                                 38230000
       8210-UPDATE-REFUND.                                              
      *                                                                 38250000
           EXEC SQL                                                     
              UPDATE CSS_REFUND                                         
              SET    CHECK_STATUS_CD = :RN-CHECK-STATUS-CD,             
                     USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY,         
                     COMMENTS        = :RN-COMMENTS,                    
T20626               REQUEST_DT      = IIF(TRY_CONVERT(DATE, 
                                                        :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-1) ) 
              WHERE  ACCOUNT_NO     = :RN-ACCOUNT-NO AND                
                     REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38260000
MFA-TR*       UPDATE CSS_REFUND                                         38270000
MFA-TR*       SET    CHECK_STATUS_CD = :RN-CHECK-STATUS-CD,             38280000
MFA-TR*              USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY,         38290000
MFA-TR*              COMMENTS        = :RN-COMMENTS,                    38291000
MFA-TR*              REQUEST_DT      = :RN-REQUEST-DT :WS-RN-NULL-IND-1         
MFA-TR*       WHERE  ACCOUNT_NO     = :RN-ACCOUNT-NO AND                38300000
MFA-TR*              REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                38310000
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                    38320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 38330000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 38350000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'CHECK_STATUS_CD'        TO TABLE-ELEMENT-3          
CBSI          MOVE 'USER_ID_APPRVD_BY'      TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE RN-CHECK-STATUS-CD       TO HOSTVAR-ELEMENT-3        
CBSI          MOVE RN-USER-ID-APPRVD-BY     TO HOSTVAR-ELEMENT-4        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 38510000
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38540000
      ***************************************************************** 38550000
      * 8215-UPDATE-REFUND2                                           * 38551000
      *                                                               * 38552000
      *      UPDATE REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 38553000
      ***************************************************************** 38554000
      *                                                                 38555000
       8215-UPDATE-REFUND2.                                             
      *                                                                 38557000
           EXEC SQL                                                     
              UPDATE CSS_REFUND                                         
              SET    CHECK_STATUS_CD = :RN-CHECK-STATUS-CD,             
                     COMMENTS        = :RN-COMMENTS                     
              WHERE  ACCOUNT_NO     = :RN-ACCOUNT-NO AND                
                     REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 38559700
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 38559900
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8215'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'CHECK_STATUS_CD'        TO TABLE-ELEMENT-3          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE RN-CHECK-STATUS-CD       TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 38561300
       8215-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38561600
      ***************************************************************** 38562000
      * 8220-DELETE-REFUND                                            * 38570000
      *                                                               * 38580000
      *      DELETE REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 38590000
      ***************************************************************** 38600000
      *                                                                 38610000
       8220-DELETE-REFUND.                                              
      *                                                                 38630000
           EXEC SQL                                                     
              DELETE FROM CSS_REFUND                                    
              WHERE  ACCOUNT_NO     = :RN-ACCOUNT-NO AND                
                     REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 38690000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 38710000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 38870000
       8220-EXIT.                                                       
           EXIT.                                                        
P0087A***************************************************************** 38550000
P0087A* 8225-UPDATE-REFUND3                                           * 38551000
P0087A*                                                               * 38552000
P0087A*      UPDATE REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 38553000
P0087A***************************************************************** 38554000
P0087A*                                                                 38555000
P0087A 8225-UPDATE-REFUND3.                                             
P0087A*                                                                 38557000
P0087A     EXEC SQL                                                     
P0087A        UPDATE CSS_REFUND                                         
P0087A        SET    AMT_REFUNDED = :RN-AMT-REFUNDED                    
P0087A        WHERE  ACCOUNT_NO     = :RN-ACCOUNT-NO AND                
P0087A               REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                
P0087A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0087A*                                                                 38559700
P0087A     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
P0087A*                                                                 38559900
P0087A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0087A        NEXT SENTENCE                                             
P0087A     ELSE                                                         
P0087A        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P0087A        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P0087A        MOVE '8225'                   TO ACTIVE-PARAGRAPH         
P0087A        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
P0087A        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
P0087A                                         ABEND-TABLES             
P0087A        MOVE 'CSS_REFUND'             TO TABLE-1                  
P0087A        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P0087A        MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
P0087A        MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P0087A        MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
P0087A        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
P0087A     END-IF.                                                      
P0087A*                                                                 38561300
P0087A 8225-EXIT.                                                       
P0087A     EXIT.                                                        
      *                                                                 39200000
      ***************************************************************** 39216000
      * 8310-INSERT-ADDR-FREEFORM                                     * 39220000
      *                                                               * 39230000
      *    INSERT FREFORM ADDRESS DETAIL INTO CSS_ADDR_FREEFORM TABLE * 39240000
      ***************************************************************** 39250000
      *                                                                 39260000
       8310-INSERT-ADDR-FREEFORM.                                       
      *                                                                 39280000
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                     (ADDRESS_ID,                                       
                      ADDR_STREET,                                      
                      ADDR_CITY_STATE,                                  
                      ADDR_ZIP_CODE,                                    
                      ADDR_COUNTRY,                                     
                      ADDRESS_OVERFLOW)                                 
              VALUES                                                    
                    (:DZ-ADDRESS-ID,                                    
                     :PARM-ADDR-STREET,                                 
                     :PARM-ADDR-CITY-STATE,                             
                     :PARM-ADDR-ZIP-CODE,                               
                     :PARM-ADDR-COUNTRY,                                
                     :PARM-ADDRESS-OVERFLOW)                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 39450000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 39470000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8310'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ADDR-CITY-STATE TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ADDR-ZIP-CODE   TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 39600000
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39630000
      ***************************************************************** 39650000
      * 8320-DELETE-ADDR-FREEFORM                                     * 39660000
      *                                                               * 39670000
      *    DELETE FREFORM ADDRESS DETAIL FROM CSS_ADDR_FREEFORM TABLE * 39680000
      ***************************************************************** 39690000
      *                                                                 39700000
       8320-DELETE-ADDR-FREEFORM.                                       
      *                                                                 39720000
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
              WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 39770000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 39790000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8320'          TO ACTIVE-PARAGRAPH                  
              MOVE 'DELETE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 39920000
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39950000
      ***************************************************************** 39960000
      * 8400-UPDATE-DEP-ON-HAND                                       * 39970000
      *                                                               * 39980000
      *     UPDATE THE DETAILS IN CSS_DEP_ON_HAND TABLE               * 39990000
      ***************************************************************** 40000000
      *                                                                 40010000
       8400-UPDATE-DEP-ON-HAND.                                         
      *                                                                 40030000
           EXEC SQL                                                     
              UPDATE CSS_DEP_ON_HAND                                    
              SET    AMT_DEPOSIT        = :DO-AMT-DEPOSIT,              
                     AMT_REFUNDED       = :DO-AMT-REFUNDED,             
                     INTRST_YTD         = :DO-INTRST-YTD,               
                     TOTAL_INTRST       = :DO-TOTAL-INTRST,             
                     DATE_INTST_CALC_TO =                               
                      IIF(TRY_CONVERT(DATE, :DO-DATE-INTST-CALC-TO 
                                            :WS-DATE-INTST-CALC-TO-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 0) OR (LEN(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ), CONVERT(DATE, :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) ),  
                     DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,        
PCR482               DATE_CERT_ISSUE    =                               
PCR482                IIF(TRY_CONVERT(DATE, :DO-DATE-CERT-ISSUE 
                                            :WS-DATE-CERT-ISSUE-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) <> 0) OR (LEN(:DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ), CONVERT(DATE, :DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) ),        
PCR482               CODE_REFUND_STATUS = :DO-CODE-REFUND-STATUS        
              WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          
                     ACCOUNT_NO      = :DO-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     40040000
MFA-TR*       UPDATE CSS_DEP_ON_HAND                                    40050000
MFA-TR*       SET    AMT_DEPOSIT        = :DO-AMT-DEPOSIT,              40060000
MFA-TR*              AMT_REFUNDED       = :DO-AMT-REFUNDED,             40070000
MFA-TR*              INTRST_YTD         = :DO-INTRST-YTD,               40080000
MFA-TR*              TOTAL_INTRST       = :DO-TOTAL-INTRST,             40090000
MFA-TR*              DATE_INTST_CALC_TO =                               40100000
MFA-TR*               :DO-DATE-INTST-CALC-TO:WS-DATE-INTST-CALC-TO-NI,  40110000
MFA-TR*              DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,        40140000
MFA-TR*              DATE_CERT_ISSUE    =                               40151000
MFA-TR*               :DO-DATE-CERT-ISSUE:WS-DATE-CERT-ISSUE-NI,        40152000
MFA-TR*              CODE_REFUND_STATUS = :DO-CODE-REFUND-STATUS        40153000
MFA-TR*       WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          40160000
MFA-TR*              ACCOUNT_NO      = :DO-ACCOUNT-NO                   40170000
MFA-TR*    END-EXEC.                                                    40180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 40190000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 40210000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
CBSI          MOVE 'DATE_INTST_CALC_TO'     TO TABLE-ELEMENT-3          
CBSI          MOVE 'DATE_CERT_ISSUE'        TO TABLE-ELEMENT-4          
              MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-1        
              MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DO-DATE-INTST-CALC-TO    TO HOSTVAR-ELEMENT-3        
CBSI          MOVE DO-DATE-CERT-ISSUE       TO HOSTVAR-ELEMENT-4        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 40360000
       8400-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 41310000
      * 8500-DELETE-AR-CNTL                                           * 41320000
      *                                                               * 41330000
      *      UPDATE CSS_AR_CNTL DETAILS                               * 41340000
      ***************************************************************** 41350000
      *                                                                 41360000
       8500-DELETE-AR-CNTL.                                             
      *                                                                 41380000
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
              WHERE  ACCOUNT_NO     = :AC-ACCOUNT-NO AND                
                     ITEM_ID        = :AC-ITEM-ID    AND                
                     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 41450000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 41470000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
CBSI          MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2          
              MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-3          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AC-ITEM-ID               TO HOSTVAR-ELEMENT-2        
              MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 41650000
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 41680000
      ***************************************************************** 41690000
      * 8510-UPDATE-AR-SUMM                                           * 41700000
      *                                                               * 41710000
      *      UPDATE CSS_AR_CNTL TABLE FOR SUMMARY RECORD (ITEM_ID = 0)* 41720000
      ***************************************************************** 41730000
      *                                                                 41740000
       8510-UPDATE-AR-SUMM.                                             
      *                                                                 41760000
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
              SET    AMT_TRAN_BALANCE = :WS-SUMM-AMT-TRAN-BALANCE,      
                     AMT_AR_DAY_00    = :WS-SUMM-AMT-AR-DAY-00,         
                     AMT_AR_DAY_30    = :WS-SUMM-AMT-AR-DAY-30,         
                     AMT_AR_DAY_60    = :WS-SUMM-AMT-AR-DAY-60,         
                     AMT_AR_DAY_90    = :WS-SUMM-AMT-AR-DAY-90,         
                     LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()               
              WHERE  ACCOUNT_NO     = :AC-ACCOUNT-NO AND                
                     ITEM_ID        = 0              AND                
                     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     41770000
MFA-TR*       UPDATE CSS_AR_CNTL                                        41780000
MFA-TR*       SET    AMT_TRAN_BALANCE = :WS-SUMM-AMT-TRAN-BALANCE,      41790000
MFA-TR*              AMT_AR_DAY_00    = :WS-SUMM-AMT-AR-DAY-00,         41800000
MFA-TR*              AMT_AR_DAY_30    = :WS-SUMM-AMT-AR-DAY-30,         41810000
MFA-TR*              AMT_AR_DAY_60    = :WS-SUMM-AMT-AR-DAY-60,         41820000
MFA-TR*              AMT_AR_DAY_90    = :WS-SUMM-AMT-AR-DAY-90,         41830000
MFA-TR*              LAST_UPDATE_TS   = CURRENT TIMESTAMP               41840000
MFA-TR*       WHERE  ACCOUNT_NO     = :AC-ACCOUNT-NO AND                41850000
MFA-TR*              ITEM_ID        = 0              AND                41860000
MFA-TR*              PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          41870000
MFA-TR*    END-EXEC.                                                    41880000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 41890000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 41910000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE '8510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
CBSI          MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2          
              MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-3          
CBSI          MOVE 'AMT_TRAN_BALANCE'       TO TABLE-ELEMENT-4          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE '0'                      TO HOSTVAR-ELEMENT-2        
              MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-3        
CBSI          MOVE WS-SUMM-AMT-TRAN-BALANCE TO HOSTVAR-ELEMENT-4-N      
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 42090000
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42120000
      ***************************************************************** 42130000
      * 8520-UPDATE-ACCOUNT                                           * 42140000
      *                                                               * 42150000
      *     UPDATE THE DETAILS INTO CSS_ACCOUNT TABLE                 * 42160000
      ***************************************************************** 42170000
      *                                                                 42180000
       8520-UPDATE-ACCOUNT.                                             
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     DATE_LAST_ACTION   = CAST(SYSDATETIMEOFFSET() 
           AS DATE),                 
T21024               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_ACCOUNT                                        42220000
MFA-TR*       SET    TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         42230000
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       42240000
MFA-TR*              DATE_LAST_ACTION   = CURRENT DATE,                 42250000
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        42260000
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'TOTAL_AR_BALANCE'       TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE AT-TOTAL-AR-BALANCE      TO HOSTVAR-ELEMENT-2-N      
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 42430000
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42450100
      ***************************************************************** 42451000
      * 8530-UPDATE-AR-HIST                                           * 42452000
      *                                                               * 42453000
      *     UPDATE SUMMARY OF AR_TRANS_HIST; SET REFUNDED INDICATOR   * 42454000
      *     TO 'Y' FOR FULLY REFUNDED DEPOSITS                        * 42454100
      ***************************************************************** 42455000
      *                                                                 42456000
       8530-UPDATE-AR-HIST.                                             
      *                                                                 42457100
           EXEC SQL                                                     
             SELECT GL_ACCT_NO                                          
             INTO   :GO-GL-ACCT-NO                                      
             FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                        
             WHERE  GL_ACCT_NAME      = 'AR-DEP'                        
P00641                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42457200
MFA-TR*      SELECT GL_ACCT_NO                                          42458000
MFA-TR*      INTO   :GO-GL-ACCT-NO                                      42458100
MFA-TR*      FROM   CSS_GL_ACCT_NO                                      42459000
MFA-TR*      WHERE  GL_ACCT_NAME      = 'AR-DEP'                        42459100
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 8530                                                       
MFA-TR*    END-EXEC.                                                    42459200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42459300
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42459500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_GL_ACCT_NO'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 42460800
           EXEC SQL                                                     
             UPDATE CSS_AR_TRANS_HIST                                   
             SET    PYMT_REFUNDED_IND = 'Y'                             
             WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                  
             AND  ( CODE_TRAN_TYPE    = 'P'                             
                   AND   TRANS_HIST_SEQ_NO IN                           
                   ( SELECT DISTINCT  TRANS_HIST_SEQ_NO                 
                    FROM   CSS_AR_TRN_HST_DET                           
                    WHERE  ACCOUNT_NO    = :AT-ACCOUNT-NO               
                    AND    GL_ACCT_CREDIT = :GO-GL-ACCT-NO              
                    AND    ITEM_ID        = :DO-DEPOSIT-CERT-NO))       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42470100
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42470300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
CBSI          MOVE 'CSS_AR_TRN_HST_DET'     TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'GL_ACCT_CREDIT'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'ITEM_ID'                TO TABLE-ELEMENT-3          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE GO-GL-ACCT-NO            TO HOSTVAR-ELEMENT-2-N      
CBSI          MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-3        
PCR360        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                 42471600
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00870***************************************************************** 41310000
A00870* 8540-DELETE-SUMMARY.                                          * 41320000
A00870***************************************************************** 41350000
A00870*                                                                 41360000
A00870 8540-DELETE-SUMMARY.                                             
A00870*                                                                 41380000
A00870     EXEC SQL                                                     
A00870        DELETE FROM CSS_AR_CNTL                                   
A00870        WHERE  ACCOUNT_NO     = :AC-ACCOUNT-NO AND                
A00870               ITEM_ID        = 0              AND                
A00870               PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
A00870     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00870*                                                                 41450000
A00870     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
A00870*                                                                 41470000
A00870     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00870        NEXT SENTENCE                                             
A00870     ELSE                                                         
A00870        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00870        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00870        MOVE '8540'                   TO ACTIVE-PARAGRAPH         
A00870        MOVE 'DELETE'                 TO ABEND-FUNCTION           
A00870        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A00870                                         ABEND-TABLES             
A00870        MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
A00870        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
A00870        MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-2          
A00870        MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
A00870        MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2        
A00870        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
A00870     END-IF.                                                      
A00870*                                                                 41650000
A00870 8540-EXIT.                                                       
A00870     EXIT.                                                        
A36248*                                                                         
A36248*****************************************************************         
A36248*8555-CALL-MCSCB371.                                            *         
A36248*CALL MCSCB371 TO UPDATE DNP-BALANCE RETURNED BY CPD00068.      *         
A36248*IF MCSCB371 FAILS, INSERT 'U' ROW IN CSS_SO_DNP_CANCEL TABLE   *         
A36248*TO BE PROCESSED BY BATCH PROGRAM.                              *         
A36248*****************************************************************         
A36248 8555-CALL-MCSCB371.                                              
A36248     MOVE SPACES                       TO ABEND-FUNCTION.         
A36248     MOVE ZERO                         TO RS-RETURN-CODE.         
A36248*                                                                         
A36248     CALL MCSCB371    USING  AT-ACCOUNT-NO,                       
A36248                             AT-DATE-BILL-DAY-00,                 
A36248                             AT-CREDIT-GROUP,                     
A36248                             WS-AMT-DNP-BAL,                      
A36248                             ABEND-FILE,                          
A36248                             RS-RETURN-CODE.                      
A36248*                                                                         
A36248     MOVE RS-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE   
A36248     IF ABEND-FUNCTION > SPACES OR WS-ACTIVE-RETURN-CODE NOT      
A36248                                EQUAL SUCCESSFUL-CALL             
A36248        PERFORM 8610-INSERT-SO-DNP-CANCEL THRU 8610-EXIT          
A36248     END-IF.                                                      
A36248*                                                                         
A36248 8555-EXIT.                                                       
A36248     EXIT.                                                        
      *                                                                 41680000
PCR307 8610-INSERT-SO-DNP-CANCEL.                                       
PCR307                                                                  
PCR307     MOVE WS-U                         TO XK-SO-UPDT-ACTION-FL.   
PCR307     MOVE AT-ACCOUNT-NO                TO XK-ACCOUNT-NO.          
PCR307                                                                  
PCR307     EXEC SQL                                                     
PCR307        INSERT INTO CSS_SO_DNP_CANCEL                             
PCR307          ( ACCOUNT_NO,                                           
PCR307            SO_UPDT_ACTION_FL )                                   
PCR307        VALUES ( :XK-ACCOUNT-NO,                                  
PCR307                 :XK-SO-UPDT-ACTION-FL )                          
PCR307     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR307                                                                  
PCR307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PCR307                     RS-RETURN-CODE.                              
PCR307     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
PCR307        WS-ACTIVE-RETURN-CODE EQUAL -803                          
PCR307        MOVE ZERO TO WS-ACTIVE-RETURN-CODE                        
PCR307                     RS-RETURN-CODE                               
PCR307     ELSE                                                         
PCR307        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PCR307        MOVE '8610'                    TO ACTIVE-PARAGRAPH        
PCR307        MOVE 'INSERT'                  TO ABEND-FUNCTION          
PCR307        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PCR307                                          ABEND-TABLES            
PCR307        MOVE 'CSS_SO_DNP_CANCEL'       TO TABLE-1                 
PCR307        MOVE XK-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PCR307        MOVE XK-SO-UPDT-ACTION-FL      TO HOSTVAR-ELEMENT-2       
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE 'SO_UPDT_ACTION_FL'       TO TABLE-ELEMENT-2         
PCR307        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
PCR307     END-IF.                                                      
PCR307 8610-EXIT.                                                       
PCR307     EXIT.                                                        
A36248*                                                                         
A36248*****************************************************************         
A36248*8999-ISSUE-COMMIT.                                             *         
A36248*****************************************************************         
A36248 8999-ISSUE-COMMIT.                                               
A36248     EXEC SQL                                                             
A36248        INCLUDE CPD00047                                                  
A36248     END-EXEC.                                                            
                                                    
A36248 8999-EXIT.                                                       
A36248     EXIT.                                                        
      *                                                                 42475000
      ************************                                          42475100
PCR360     EXEC SQL                                                     42475200
PCR360        INCLUDE CPD0023C                                          42475300
PCR360     END-EXEC.                                                    42475400
PCR360*                                                                 42475500
T20346******************************************************************14920000
T20346* 9000A-SEND-ERROR-RESULT                                        *        
T20346******************************************************************        
T20346 9000A-SEND-ERROR-RESULT.                                         
T20346                                                                  
T20346     MOVE 'N'           TO SEND-DONE-SW.                          
T20346     MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
T20346     MOVE WS-PAR-MESSAGE-NO          TO RS-ERROR-MESSAGE-NO.      
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
REARCH     ADD +1                        TO   CTR-ROWS.                 
T20346     PERFORM 8900-SEND-DONE        THRU 8900-EXIT.                
T20346                                                                  
T20346 9000A-EXIT.                                                      
T20346     EXIT.                                                        
T20346                                                                  
T21024*                                                                         
T21024 9200-LINK-SCSCA182.                                              
T21024*                                                                         
T21024     MOVE '9200'                        TO ACTIVE-PARAGRAPH.      
T21024                                                                  
REARCH     CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
REARCH                          ,SCSCA182-RETURN-CODE                   
REARCH                          ,SCSCA182-LAST-UPDATE-TS                
REARCH                          ,ABEND-FILE.                            
REARCH*                                                                 24120000
T21024 9200-EXIT.                                                       
T21024     EXIT.                                                        
T21024*                                                                         
T24436******************************************************************        
T24436* LOADING GL NUMBERS                                             *        
T24436******************************************************************        
T24436* 9350-LINK-SCSCO061.                                            *        
T24436*    CALLS THE SUBPROGRAM SCSCO061*                                       
T24436******************************************************************        
T24436*                                                                         
T24436 9350-LINK-SCSCO061.                                              
T24436*                                                                         
T24436     MOVE SPACES                    TO ABEND-FUNCTION.            
T24436     PERFORM 9400-CALL-CPD00061     THRU 9400-EXIT.               
T24436     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
T24436                                       SQLCODE.                   
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
T24436     END-IF.                                                      
T24436                                                                  
T24436 9350-EXIT.                                                       
T24436     EXIT.                                                        
T24436*                                                                         
T24436******************************************************************        
T24436* 9400-CALL-CPD00061                                             *        
T24436*     CALLS THE COPYBOOK CPD00061                                *        
T24436******************************************************************        
T24436*                                                                         
T24436 9400-CALL-CPD00061.                                              
T24436                                                                  
REARCH     CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
REARCH                           WS-GL-ACCT-MAJOR-FIELDS                
REARCH                           WS-VALID-COMPANY-NOS                   
REARCH                           WS-GL-NAME-INFO                        
REARCH                           WS-GL-ACCT-NO-TABLE                    
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO RS-RETURN-CODE,            
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH     END-IF.                                                      
REARCH*                                                                         
T24436 9400-EXIT.                                                       
T24436     EXIT.                                                        
T24436                                                                  
T19557******************************************************************        
T19557* 9450-LINK-SCSCO068.                                            *        
T19557*    CALLS THE THE SUBPROGRAM SCSCO068.                          *        
T19557******************************************************************        
T19557*                                                                         
T19557 9450-LINK-SCSCO068.                                              
T19557*                                                                         
T19557     MOVE SPACES                        TO ABEND-FUNCTION .       
T19557     PERFORM 9500-CALL-CPD00068         THRU 9500-EXIT.           
T19557     MOVE RS-RETURN-CODE                TO WS-ACTIVE-RETURN-CODE, 
T19557                                           SQLCODE.               
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T19557     END-IF.                                                      
T19557                                                                  
T19557 9450-EXIT.                                                       
T19557     EXIT.                                                        
T19557*                                                                         
T19557 9500-CALL-CPD00068.                                              
T19557                                                                  
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE,           
REARCH                                 S-RETURN-CODE.                   
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1           TO S-RETURN-CODE,                   
REARCH                                 WS-ACTIVE-RETURN-CODE            
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
REARCH*                                                                         
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
T19557*                                                                         
      ***************************************************************** 42476000
      * 9900 - JOURNALING AND ERROR HANDLING INCLUDE                  * 42480000
      ***************************************************************** 42490000
      *                                                                 42491000
           EXEC SQL                                                     42500000
REARCH        INCLUDE CPDSP300                                          42510000
           END-EXEC.                                                    42520000
      *                                                                 42530000
      ************************.                                         42540000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
      *                                                                 42560000
                                                                        
NONUTL     EXEC SQL                                                     42580000
NONUTL        INCLUDE CPD00312                                          42590000
NONUTL     END-EXEC.                                                    42600000
                                                                        
