       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02167.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 25, 1995                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S167                                           *00120000
      *  PROGRAM:       S167                                           *00130000
      *  CALLING SP:    PA_S167                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES DATA FROM THE CSS_ACCT_WHT_CROSS       *00190000
      *  TABLE. THE DATA IS RETREIVED BASED ON ACCOUNT NUMBER AND      *00200000
      *  PREMISE NUMBER.                                               *00201000
      *                                                                *00201100
      ******************************************************************00201200
      *                                                                *00201300
      *                     PROGRAM MODIFICATION LOG                   *00201400
      *                                                                *00201500
      *    DATE    INITIALS   COMMENTS                                 *00201600
      *  --------  --------   ---------------------------------------  *00201700
      *  09/25/95  TCB        PROCEDURE ORIGINALLY CODED.              *00201800
      *                                                                *00201900
T4755 *  11/06/96  CSG        CHANGE DEFINITION OF POINT-ID WORKING    *00202000
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *00202100
      *  01/05/98  AMG        FIXED SO THAT NO MORE EXTRANEOUS         *00202200
      *                       MESSAGES APPEAR IN MC05.                 *00202300
T15408*  03/13/98  GAC        PROGRAM WAS NOT RETURNING A 100 IF SELECT*00202400
      *                       NOT-FOUND.                               *00202500
C24056*  01/24/03  FMB        ADD GIS_POINT_ID FOR OMS.                *00202600
REARCH*  08/04/05  CVNS       RPC TO COBOL SP CONVERSION               *00202700
REARCH*            CHENNAI                                             *00202800
P33272*  01/04/07  AW41078    PARA 4000 AND 4010- RET CODE_CRIT_OUTAGE *00202900
P33272*                       AND SECURE_FL WHICH WILL BE USED TO      *00203000
P33272*                       DISABLE PANEL280 IF SECURE_FL FOR        *00203100
P33272*                       CODE_CRIT_OUTAGE IS Y                    *00203200
P33272* 03/29/07   AW41078    ADDED CHECK FOR AT-CODE-CRIT-OUTAGE      *00203300
P33272*                       TO CORRECT ISSUE OCCURRING AFTER REARCH  *00203400
P33272*                       CHANGE                                   *00203500
P33743* 05/09/08   SC41135    POINT ID PROJECT - REPLACE SNE_POINT     *00203600
P33743*                       CSS_PIM_POINT TABLE.                     *00203700
      ******************************************************************00203800
      ******************************************************************00203900
      *                                                                *00204000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00205000
      *                                                                *00206000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00207000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00208000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00209000
      *  3000 - 4999  DB2 STATEMENTS                                   *00210000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00220000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00230000
      *  7000 - 7999  INPUT MODULES                                    *00240000
      *  8000 - 8999  OUTPUT MODULES                                   *00250000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00260000
      *                                                                *00270000
      ******************************************************************00280000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02167'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02167 STARTS HERE'.                  
                                                                        
      ******************************************************************00370000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00380000
      ******************************************************************00390000
                                                                        
REARCH*    COPY SYGWCOB.                                                00410000
REARCH*    COPY SYDBCOB.                                                00420000
REARCH*    COPY CWS00010.                                               00430000
REARCH     EXEC SQL                                                     00431000
REARCH         INCLUDE CWSX0010                                         00432000
REARCH     END-EXEC.                                                    00433000
           COPY CWS00027.                                               00440000
           COPY CWS00303.                                               00450000
                                                                        
      ******************************************************************00470000
      *    WORK AREAS                                                  *00480000
      ******************************************************************00490000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02167'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          00600000
REARCH*    05  GWL-PROC                 POINTER.                        00610000
REARCH*    05  GWL-INIT-HANDLE          POINTER.                        00620000
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                 00630000
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 00640000
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 00650000
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 00660000
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 00670000
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 00680000
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 00690000
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
REARCH*01  PARM-FIELDS.                                                 00720000
REARCH*    05  PARM-L                   PIC S9(09) COMP.                00730000
REARCH*    05  PARM-ID1                 PIC S9(09) COMP VALUE 1.        00740000
REARCH*    05  PARM-PREMISE-NO          PIC  X(10)  VALUE SPACES.       00750000
REARCH*    05  PARM-ACCOUNT-NO          PIC  X(13)  VALUE SPACES.       00760000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  REDEFINE-FIELDS.                                             
           05  WS-ACCOUNT-NO             PIC X(13).                     
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                         PIC 9(13).                     
           05  WS-ACCOUNT-NO-COMP3       PIC S9999999999999V            
                                         COMP-3 VALUE +0.               
           05  WS-PREMISE-NO             PIC X(10).                     
           05  WS-PREMISE-NO-NUM REDEFINES WS-PREMISE-NO                
                                         PIC 9(10).                     
           05  WS-PREMISE-NO-COMP3       PIC S9999999999V               
                                         COMP-3 VALUE +0.               
                                                                        
       01  WS-DB2-DATE.                                                 
           05  WS-DB2-YEAR               PIC X(04)  VALUE SPACES.       
           05  WS-DB2-DASH1              PIC X(01)  VALUE SPACES.       
           05  WS-DB2-MTH                PIC X(02)  VALUE SPACES.       
           05  WS-DB2-DASH2              PIC X(01)  VALUE SPACES.       
           05  WS-DB2-DAY                PIC X(02)  VALUE SPACES.       
                                                                        
       01  WS-SYB-DATE.                                                 
           05  WS-SYB-MTH                PIC X(02)  VALUE SPACES.       
           05  FILLER                    PIC X(01)  VALUE '/'.          
           05  WS-SYB-DAY                PIC X(02)  VALUE SPACES.       
           05  FILLER                    PIC X(01)  VALUE '/'.          
           05  WS-SYB-YEAR               PIC X(04)  VALUE SPACES.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09)  COMP VALUE +0.      
T4755 *    05  RS-POINT-ID              PIC S9(09)  COMP VALUE +0.      01120000
T4755      05  RS-POINT-ID              PIC  X(10)  VALUE SPACES.       
           05  RS-ACCOUNT-NO            PIC  X(13)  VALUE SPACES.       
           05  RS-CODE-WC-EQUIP         PIC  X(02)  VALUE SPACES.       
           05  RS-WC-EQUIP-INST-DATE    PIC  X(10)  VALUE SPACES.       
           05  RS-WC-BACKUP-HOURS       PIC S9(03)  COMP-3 VALUE +0.    
           05  RS-WC-COMMENTS           PIC X(200)  VALUE SPACES.       
P33272     05  RS-CODE-CRIT-OUTAGE      PIC  X(02)  VALUE SPACES.       
P33272     05  RS-SECURE-FL             PIC  X(01)  VALUE SPACES.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09)  COMP VALUE +0.      
REARCH     05  S-POINT-ID               PIC  X(10)  VALUE SPACES.       
REARCH     05  S-ACCOUNT-NO             PIC  X(13)  VALUE SPACES.       
REARCH     05  S-CODE-WC-EQUIP          PIC  X(02)  VALUE SPACES.       
REARCH     05  S-WC-EQUIP-INST-DATE     PIC  X(10)  VALUE SPACES.       
REARCH     05  S-WC-BACKUP-HOURS        PIC S9(03)  COMP-3 VALUE +0.    
REARCH     05  S-WC-COMMENTS            PIC X(200)  VALUE SPACES.       
P33272     05  S-CODE-CRIT-OUTAGE       PIC  X(02)  VALUE SPACES.       
P33272     05  S-SECURE-FL              PIC  X(01)  VALUE SPACES.       
REARCH*                                                                 01154200
REARCH*01  CNS-COLUMN-NAMES.                                            01154300
REARCH*    05  CNS-RETURN-CODE          PIC X(11) VALUE                 01155000
REARCH*                                       'RETURN_CODE'.            01156000
REARCH*    05  CNS-POINT-ID             PIC X(08) VALUE                 01157000
REARCH*                                       'POINT_ID'.               01158000
REARCH*    05  CNS-CODE-WC-EQUIP        PIC X(13) VALUE                 01159000
REARCH*                                       'CODE_WC_EQUIP'.          01160000
REARCH*    05  CNS-WC-EQUIP-INST-DATE   PIC X(18) VALUE                 01170000
REARCH*                                       'WC_EQUIP_INST_DATE'.     01180000
REARCH*    05  CNS-WC-BACKUP-HOURS      PIC X(15) VALUE                 01190000
REARCH*                                       'WC_BACKUP_HOURS'.        01191000
REARCH*    05  CNS-WC-COMMENTS          PIC X(11) VALUE                 01192000
REARCH*                                       'WC_COMMENTS'.            01193000
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH        10  S-SP-NAME               PIC X(18)      VALUE SPACES.  
REARCH        10  S-SQLCODE               PIC S9(9) COMP VALUE 0.       
REARCH        10  S-SQLSTATE              PIC X(5)       VALUE ' '.     
REARCH        10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.  
REARCH        10  S-HOST-VARIABLES.                                     
REARCH              49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.       
REARCH              49  S-HOST-VARIABLES-V  PIC X(255).                 
REARCH        10  S-SQL-STATEMENT.                                      
REARCH              49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.       
REARCH              49  S-SQL-STATEMENT-V   PIC X(255).                 
REARCH        10  S-SQL-DESCRIPTION.                                    
REARCH              49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.       
REARCH              49  S-SQL-DESCRIPTION-V PIC X(255).                 
REARCH*                                                                 01195500
           EXEC SQL                                                     01195600
              INCLUDE SQLCA                                             01196000
           END-EXEC.                                                    01197000
                                                                        
                                                                        
           EXEC SQL                                                     01199700
              INCLUDE TBWCACCT                                          01200000
           END-EXEC.                                                    01210000
                                                                        
*********CSS_PIM_POINT *************                                    01220500
P33743     EXEC SQL                                                     01220600
P33743        INCLUDE TBPIMPNT                                          01220700
P33743     END-EXEC.                                                    01220800
                                                                        
                                                                        
P33272     EXEC SQL                                                     01221100
P33272        INCLUDE TBACCT                                            01221200
P33272     END-EXEC.                                                    01221300
                                                                        
P33272     EXEC SQL                                                     01221500
P33272        INCLUDE TBCRITOG                                          01221600
P33272     END-EXEC.                                                    01221700
                                                                        
REARCH*                                                                 01221900
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACCOUNT-NO          PIC  X(13).                          
REARCH 01 PARM-PREMISE-NO          PIC  X(10).                          
REARCH PROCEDURE DIVISION USING    PARM-ACCOUNT-NO                      
REARCH                             PARM-PREMISE-NO.                     
                                                                        
      ******************************************************************01224000
      * 0000-MAINLINE                                                  *01225000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01226000
      ******************************************************************01227000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
REARCH*    PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             01240000
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
REARCH     PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
REARCH     ADD +1                           TO CTR-ROWS.                
REARCH*    PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             01242000
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01247000
      * 0100-INITIALIZE                                                *01248000
      *                                                                *01249000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01250000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01260000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01270000
      *                                                                *01280000
      ******************************************************************01290000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
REARCH*    MOVE '0100' TO ACTIVE-PARAGRAPH.                             01320000
REARCH*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              01330000
REARCH*    EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                01340000
REARCH*    EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               01350000
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     01360000
REARCH*                                                                 01370000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     01380000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         01390000
REARCH*                                                                 01400000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      01410000
REARCH*                                                                 01420000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             01430000
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     01440000
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  01450000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      01460000
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      01470000
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        01480000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            01490000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            01500000
REARCH*    END-IF.                                                      01510000
REARCH*                                                                 01510100
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR  FOR                         
REARCH        SELECT                                                    
REARCH              :S-RETURN-CODE               AS  RETURN_CODE        
REARCH             ,LTRIM(RTRIM(:S-POINT-ID))           AS  POINT_ID           
REARCH             ,LTRIM(RTRIM(:S-CODE-WC-EQUIP))      AS  
           CODE_WC_EQUIP      
REARCH             ,LTRIM(RTRIM(:S-WC-EQUIP-INST-DATE)) AS  
           WC_EQUIP_INST_DATE 
REARCH             ,:S-WC-BACKUP-HOURS           AS  WC_BACKUP_HOURS    
REARCH             ,LTRIM(RTRIM(:S-WC-COMMENTS))        AS  WC_COMMENTS        
P33272             ,LTRIM(RTRIM(:S-CODE-CRIT-OUTAGE))   AS  
           CODE_CRIT_OUTAGE   
P33272             ,LTRIM(RTRIM(:S-SECURE-FL))          AS  SECURE_FL          
P33272             ,'1900-01-01'                 AS  DUMMY1             
REARCH        FROM                                                      
REARCH            CIS.SYSDUMMY1                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01510200
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         01510300
MFA-TR*       SELECT                                                    01510400
MFA-TR*             :S-RETURN-CODE               AS  RETURN_CODE        01511000
MFA-TR*            ,STRIP(:S-POINT-ID)           AS  POINT_ID           01512000
MFA-TR*            ,STRIP(:S-CODE-WC-EQUIP)      AS  CODE_WC_EQUIP      01513000
MFA-TR*            ,STRIP(:S-WC-EQUIP-INST-DATE) AS  WC_EQUIP_INST_DATE 01514000
MFA-TR*            ,:S-WC-BACKUP-HOURS           AS  WC_BACKUP_HOURS    01515000
MFA-TR*            ,STRIP(:S-WC-COMMENTS)        AS  WC_COMMENTS        01516000
MFA-TR*            ,STRIP(:S-CODE-CRIT-OUTAGE)   AS  CODE_CRIT_OUTAGE   01516100
MFA-TR*            ,STRIP(:S-SECURE-FL)          AS  SECURE_FL          01516200
MFA-TR*            ,'1900-01-01'                 AS  DUMMY1             01516300
MFA-TR*       FROM                                                      01517000
MFA-TR*           SYSIBM.SYSDUMMY1                                      01518000
MFA-TR*    END-EXEC.                                                    01519000
REARCH*                                                                 01519100
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01540000
      * 1000-PROCESS-INPUT.                                            *01550000
      *                                                                *01560000
      *     1. RECEIVE PARMS.                                          *01570000
      *                                                                *01580000
      ******************************************************************01590000
                                                                        
REARCH*1000-PROCESS-INPUT.                                              01610000
                                                                        
REARCH*    MOVE '1000' TO ACTIVE-PARAGRAPH.                             01620000
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   01630000
                                                                        
REARCH*1000-EXIT.                                                       01640000
REARCH*    EXIT.                                                        01650000
                                                                        
      ***************************************************************** 01670000
      * 1100-RECEIVE-PARMS                                            * 01680000
      *                                                               * 01690000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          * 01700000
      *                                                               * 01710000
      ***************************************************************** 01720000
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              01740000
REARCH*                                                                 01741000
REARCH*    MOVE '1100' TO ACTIVE-PARAGRAPH.                             01750000
REARCH*                                                                 01760000
REARCH*    MOVE 1                   TO PARM-ID1.                        01770000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,           01780000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              01790000
REARCH*                          GWL-RC,                                01800000
REARCH*                          PARM-ID1,                              01810000
REARCH*                          PARM-ACCOUNT-NO,                       01820000
REARCH*                          TDSCHAR,                               01830000
REARCH*                          MAX-LENGTH-PARM,                       01840000
REARCH*                          PARM-L.                                01850000
REARCH*                                                                 01860000
REARCH*    ADD 1                    TO PARM-ID1.                        01870000
REARCH*    MOVE LENGTH OF PARM-PREMISE-NO TO MAX-LENGTH-PARM,           01880000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              01890000
REARCH*                          GWL-RC,                                01900000
REARCH*                          PARM-ID1,                              01910000
REARCH*                          PARM-PREMISE-NO,                       01911000
REARCH*                          TDSCHAR,                               01912000
REARCH*                          MAX-LENGTH-PARM,                       01913000
REARCH*                          PARM-L.                                01914000
REARCH*                                                                 01915000
REARCH*1100-EXIT.                                                       01916000
REARCH*    EXIT.                                                        01917000
                                                                        
      ******************************************************************01919000
      * 2000-PROCESS-OUTPUT.                                           *01920000
      *                                                                *01930000
      *     1. DESCRIBE RESULT SET                                     *01931000
      *     2. UPDATE DB2 DATA                                         *01932000
      *     3. BUILD RESULT SET                                        *01933000
      *     4. SEND RESULT SET                                         *01934000
      *                                                                *01934100
      ******************************************************************01934200
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH*    PERFORM 2100-DESCRIBE-RESULT   THRU 2100-EXIT.               01934700
           PERFORM 2200-REDEFINE-PARMS    THRU 2200-EXIT.               
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3       TO WH-ACCOUNT-NO              
P33272                                       AT-ACCOUNT-NO.             
           MOVE WS-PREMISE-NO-COMP3       TO WH-PREMISE-NO.             
                                                                        
P33272     PERFORM 4000-SELECT-ACCOUNT THRU 4000-EXIT.                  
P33272     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P33272        MOVE AT-CODE-CRIT-OUTAGE TO RS-CODE-CRIT-OUTAGE           
P33272        MOVE 'N'                 TO RS-SECURE-FL                  
P33272        IF AT-CODE-CRIT-OUTAGE NOT = SPACES                       
P33272           PERFORM 4010-SELECT-CRIT-OUTAGE THRU 4010-EXIT         
P33272        END-IF                                                    
P33272     END-IF.                                                      
                                                                        
           PERFORM 3000-SELECT-WHITE-CROSS THRU 3000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33743        MOVE PP-AREA-ID                TO RS-POINT-ID(1:3)        
C33743        MOVE PP-TAG-NM                 TO RS-POINT-ID(4:7)        
              MOVE WH-CODE-WC-EQUIP          TO RS-CODE-WC-EQUIP        
              MOVE WH-WC-EQUIP-INST-DATE     TO WS-DB2-DATE             
              MOVE WS-DB2-YEAR               TO WS-SYB-YEAR             
              MOVE WS-DB2-MTH                TO WS-SYB-MTH              
              MOVE WS-DB2-DAY                TO WS-SYB-DAY              
              STRING WS-SYB-DATE(1:2) DELIMITED BY SIZE                 
                     WS-SYB-DATE(4:2) DELIMITED BY SIZE                 
                     WS-SYB-DATE(7:4) DELIMITED BY SIZE                 
                     INTO  RS-WC-EQUIP-INST-DATE                        
                                                                        
      *       MOVE WS-SYB-DATE               TO RS-WC-EQUIP-INST-DATE   01938700
              MOVE WH-WC-BACKUP-HOURS        TO RS-WC-BACKUP-HOURS      
              MOVE WH-WC-COMMENTS-TEXT       TO RS-WC-COMMENTS          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                 01941300
REARCH******************************************************************01941400
REARCH*2000A-MOVE-RESULT.                                              *01941500
REARCH******************************************************************01941600
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE  RS-RETURN-CODE        TO  S-RETURN-CODE.               
REARCH     MOVE  RS-POINT-ID           TO  S-POINT-ID.                  
REARCH     MOVE  RS-ACCOUNT-NO         TO  S-ACCOUNT-NO.                
REARCH     MOVE  RS-CODE-WC-EQUIP      TO  S-CODE-WC-EQUIP.             
REARCH     MOVE  RS-WC-EQUIP-INST-DATE TO  S-WC-EQUIP-INST-DATE.        
REARCH     MOVE  RS-WC-BACKUP-HOURS    TO  S-WC-BACKUP-HOURS.           
REARCH     MOVE  RS-WC-COMMENTS        TO  S-WC-COMMENTS.               
P33272     MOVE  RS-CODE-CRIT-OUTAGE   TO  S-CODE-CRIT-OUTAGE.          
P33272     MOVE  RS-SECURE-FL          TO  S-SECURE-FL.                 
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 01942900
                                                                        
      ******************************************************************01943100
      * 2100-DESCRIBE-RESULT                                           *01943200
      *                                                                *01943300
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *01943400
      *                                                                *01943500
      ******************************************************************01943600
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                            01943800
REARCH*                                                                 01943900
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             01944000
REARCH*                                                                 01944100
REARCH*    MOVE 1       TO CTR-COLUMN.                                  01944200
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                01944300
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              01944400
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    01944500
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE TO WRKLEN2.                   01944600
REARCH*                                                                 01944700
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              01944800
REARCH*                          GWL-RC,                                01944900
REARCH*                          CTR-COLUMN,                            01945000
REARCH*                          DB-HOST-TYPE,                          01945100
REARCH*                          WRKLEN1,                               01945200
REARCH*                          RS-RETURN-CODE,                        01945300
REARCH*                          DB-NULL-INDICATOR,                     01945400
REARCH*                          TDS-FALSE,                             01945500
REARCH*                          DB-CLIENT-TYPE,                        01945600
REARCH*                          WRKLEN1,                               01945700
REARCH*                          CNS-RETURN-CODE,                       01945800
REARCH*                          WRKLEN2.                               01945900
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01946000
REARCH*                                                                 01946100
REARCH*    ADD 1        TO CTR-COLUMN.                                  01947000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                01948000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              01949000
REARCH*    MOVE LENGTH OF RS-POINT-ID TO WRKLEN1.                       01950000
REARCH*    MOVE LENGTH OF CNS-POINT-ID TO WRKLEN2.                      01960000
REARCH*                                                                 01970000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              01980000
REARCH*                          GWL-RC,                                01990000
REARCH*                          CTR-COLUMN,                            02000000
REARCH*                          DB-HOST-TYPE,                          02010000
REARCH*                          WRKLEN1,                               02020000
REARCH*                          RS-POINT-ID,                           02030000
REARCH*                          DB-NULL-INDICATOR,                     02040000
REARCH*                          TDS-FALSE,                             02041000
REARCH*                          DB-CLIENT-TYPE,                        02042000
REARCH*                          WRKLEN1,                               02043000
REARCH*                          CNS-POINT-ID,                          02044000
REARCH*                          WRKLEN2.                               02045000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02046000
REARCH*                                                                 02047000
REARCH*    ADD 1        TO CTR-COLUMN.                                  02048000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02049000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02050000
REARCH*    MOVE LENGTH OF RS-CODE-WC-EQUIP TO WRKLEN1.                  02060000
REARCH*    MOVE LENGTH OF CNS-CODE-WC-EQUIP TO WRKLEN2.                 02070000
REARCH*                                                                 02080000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02090000
REARCH*                          GWL-RC,                                02100000
REARCH*                          CTR-COLUMN,                            02110000
REARCH*                          DB-HOST-TYPE,                          02120000
REARCH*                          WRKLEN1,                               02130000
REARCH*                          RS-CODE-WC-EQUIP,                      02140000
REARCH*                          DB-NULL-INDICATOR,                     02150000
REARCH*                          TDS-FALSE,                             02160000
REARCH*                          DB-CLIENT-TYPE,                        02170000
REARCH*                          WRKLEN1,                               02180000
REARCH*                          CNS-CODE-WC-EQUIP,                     02190000
REARCH*                          WRKLEN2.                               02200000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02210000
REARCH*                                                                 02220000
REARCH*    ADD 1        TO CTR-COLUMN.                                  02230000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02240000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02250000
REARCH*    MOVE LENGTH OF RS-WC-EQUIP-INST-DATE TO WRKLEN1.             02260000
REARCH*    MOVE LENGTH OF CNS-WC-EQUIP-INST-DATE TO WRKLEN2.            02270000
REARCH*                                                                 02271000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02272000
REARCH*                          GWL-RC,                                02272100
REARCH*                          CTR-COLUMN,                            02272200
REARCH*                          DB-HOST-TYPE,                          02272300
REARCH*                          WRKLEN1,                               02272400
REARCH*                          RS-WC-EQUIP-INST-DATE,                 02272500
REARCH*                          DB-NULL-INDICATOR,                     02272600
REARCH*                          TDS-FALSE,                             02272700
REARCH*                          DB-CLIENT-TYPE,                        02272800
REARCH*                          WRKLEN1,                               02272900
REARCH*                          CNS-WC-EQUIP-INST-DATE,                02273000
REARCH*                          WRKLEN2.                               02273100
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02273200
REARCH*                                                                 02273300
REARCH*    ADD 1        TO CTR-COLUMN.                                  02273400
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02273500
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02273600
REARCH*    MOVE LENGTH OF RS-WC-BACKUP-HOURS TO WRKLEN1.                02273700
REARCH*    MOVE LENGTH OF CNS-WC-BACKUP-HOURS TO WRKLEN2.               02273800
REARCH*                                                                 02273900
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02274000
REARCH*                          GWL-RC,                                02274100
REARCH*                          CTR-COLUMN,                            02274200
REARCH*                          DB-HOST-TYPE,                          02274300
REARCH*                          WRKLEN1,                               02274400
REARCH*                          RS-WC-BACKUP-HOURS,                    02274500
REARCH*                          DB-NULL-INDICATOR,                     02274600
REARCH*                          TDS-FALSE,                             02274700
REARCH*                          DB-CLIENT-TYPE,                        02274800
REARCH*                          WRKLEN1,                               02274900
REARCH*                          CNS-WC-BACKUP-HOURS,                   02275000
REARCH*                          WRKLEN2.                               02275100
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02275200
REARCH*                                                                 02275300
REARCH*    MOVE +0 TO WRKLEN2.                                          02275400
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              02275500
REARCH*                          GWL-RC,                                02275600
REARCH*                          TDS-OBJECT-COL,                        02275700
REARCH*                          CTR-COLUMN,                            02275800
REARCH*                          WRKLEN1,                               02275900
REARCH*                          WRKLEN2.                               02276000
REARCH*                                                                 02276100
REARCH*    ADD 1        TO CTR-COLUMN.                                  02276200
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02276300
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02276400
REARCH*    MOVE LENGTH OF RS-WC-COMMENTS TO WRKLEN1.                    02276500
REARCH*    MOVE LENGTH OF CNS-WC-COMMENTS TO WRKLEN2.                   02276600
REARCH*                                                                 02276700
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02276800
REARCH*                          GWL-RC,                                02276900
REARCH*                          CTR-COLUMN,                            02277000
REARCH*                          DB-HOST-TYPE,                          02277100
REARCH*                          WRKLEN1,                               02277200
REARCH*                          RS-WC-COMMENTS,                        02277300
REARCH*                          DB-NULL-INDICATOR,                     02277400
REARCH*                          TDS-FALSE,                             02277500
REARCH*                          DB-CLIENT-TYPE,                        02277600
REARCH*                          WRKLEN1,                               02277700
REARCH*                          CNS-WC-COMMENTS,                       02277800
REARCH*                          WRKLEN2.                               02277900
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02278000
REARCH*                                                                 02278100
REARCH*2100-EXIT.                                                       02278200
REARCH*    EXIT.                                                        02278300
                                                                        
      ******************************************************************02278500
      *  2200-REDEFINE-PARMS                                           *02278600
      *                                                                *02278700
      *     CONVERT THE NUMERIC PARAMETERS TO COMP-3 WORKING STORAGE   *02278800
      *     SO THESE CAN BE USED AS RETRIEVAL CRITERIA.                *02278900
      *                                                                *02279000
      ******************************************************************02279100
                                                                        
       2200-REDEFINE-PARMS.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO-COMP3.       
           MOVE PARM-PREMISE-NO           TO WS-PREMISE-NO.             
           MOVE WS-PREMISE-NO-NUM         TO WS-PREMISE-NO-COMP3.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02280300
      *                                                                *02280400
      *   3000-SELECT-WHITE-CROSS                                      *02280500
      *                                                                *02280600
      *   SELECT FIELDS FROM THE CSS_ACCT_WHT_CROSS TABLE.             *02280700
      *                                                                *02280800
      ******************************************************************02280900
                                                                        
       3000-SELECT-WHITE-CROSS.                                         
                                                                        
           EXEC SQL                                                     
C24056       SELECT WC.POINT_ID,                                        
                    CODE_WC_EQUIP,                                      
                    WC_EQUIP_INST_DATE,                                 
                    WC_BACKUP_HOURS,                                    
                    WC_COMMENTS,                                        
C24056              TAG_NM,                                             
C33743              AREA_ID                                             
             INTO :WH-POINT-ID,                                         
                  :WH-CODE-WC-EQUIP,                                    
                  :WH-WC-EQUIP-INST-DATE,                               
                  :WH-WC-BACKUP-HOURS,                                  
                  :WH-WC-COMMENTS,                                      
C33743            :PP-TAG-NM,                                           
C33743            :PP-AREA-ID                                           
             FROM CSS_ACCT_WHT_CROSS WC,                                
C33743            CSS_PIM_POINT PP                                      
             WHERE ACCOUNT_NO = :WH-ACCOUNT-NO                          
               AND PREMISE_NO = :WH-PREMISE-NO                          
C33743         AND WC.GIS_POINT_ID = PP.POINT_ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T15408        NEXT SENTENCE                                             
T15408     ELSE                                                         
T15408        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T15408        IF WS-ACTIVE-RETURN-CODE NOT EQUAL NOT-FOUND              
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '3000'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                  
C33743           MOVE 'CSS_PIM_OPINT'       TO TABLE-2                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
                 MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2          
                 MOVE WH-PREMISE-NO         TO HOSTVAR-ELEMENT-2        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
T15408        END-IF                                                    
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P33272******************************************************************02363100
P33272*                                                                *02363200
P33272*  4000-SELECT-ACCOUNT                                           *02363300
P33272*                                                                *02363400
P33272*  SELECT FIELDS FROM CSS_ACCOUNT TABLE                          *02363500
P33272*                                                                *02363600
P33272******************************************************************02363700
P33272                                                                  
P33272 4000-SELECT-ACCOUNT.                                             
P33272     EXEC SQL                                                     
P33272       SELECT AT.CODE_CRIT_OUTAGE,                                
P33272              AT.COMPANY_NO                                       
P33272       INTO :AT-CODE-CRIT-OUTAGE,                                 
P33272            :AT-COMPANY-NO                                        
P33272       FROM CSS_ACCOUNT AT                                        
P33272       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
P33272     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P33272                                                                  
P33272     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P33272     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P33272       IF AT-CODE-CRIT-OUTAGE < SPACES                            
P33272          MOVE SPACES TO AT-CODE-CRIT-OUTAGE                      
P33272       END-IF                                                     
P33272     ELSE                                                         
P33272       MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
P33272       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
P33272       MOVE '4000'                TO ACTIVE-PARAGRAPH             
P33272       MOVE 'SELECT'              TO ABEND-FUNCTION               
P33272       MOVE SPACES                TO ABEND-SQL-PREDICATES         
P33272                                     ABEND-TABLES                 
P33272       MOVE 'CSS_ACCOUNT'         TO TABLE-1                      
P33272       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1              
P33272       MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
P33272       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
P33272       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
P33272     END-IF.                                                      
P33272                                                                  
P33272 4000-EXIT.                                                       
P33272     EXIT.                                                        
P33272                                                                  
P33272                                                                  
P33272******************************************************************02367800
P33272*                                                                *02367900
P33272*  4010-SELECT-CRIT-OUTAGE                                       *02368000
P33272*                                                                *02368100
P33272*  SELECT FIELDS FROM CSS_CRIT_OUTAGE TABLE                      *02368200
P33272*                                                                *02368300
P33272******************************************************************02368400
P33272                                                                  
P33272 4010-SELECT-CRIT-OUTAGE.                                         
P33272     EXEC SQL                                                     
P33272       SELECT Q2.SECURE_FL                                        
P33272       INTO :Q2-SECURE-FL                                         
P33272       FROM CSS_CRIT_OUTAGE Q2                                    
P33272       WHERE CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE              
P33272         AND COMPANY_NO       = :AT-COMPANY-NO                    
P33272     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P33272                                                                  
P33272     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P33272     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P33272       MOVE Q2-SECURE-FL          TO RS-SECURE-FL                 
P33272     ELSE                                                         
P33272       MOVE SPACES                TO RS-SECURE-FL                 
P33272       MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
P33272       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
P33272       MOVE '4010'                TO ACTIVE-PARAGRAPH             
P33272       MOVE 'SELECT'              TO ABEND-FUNCTION               
P33272       MOVE SPACES                TO ABEND-SQL-PREDICATES         
P33272                                     ABEND-TABLES                 
P33272       MOVE 'CSS_CRIT_OUTAGE'     TO TABLE-1                      
P33272       MOVE 'CODE_CRIT_OUTAGE'    TO TABLE-ELEMENT-1              
P33272       MOVE AT-CODE-CRIT-OUTAGE   TO HOSTVAR-ELEMENT-1            
P33272       MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2              
P33272       MOVE AT-COMPANY-NO         TO HOSTVAR-ELEMENT-2            
P33272       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
P33272       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
P33272     END-IF.                                                      
P33272                                                                  
P33272 4010-EXIT.                                                       
P33272     EXIT.                                                        
P33272                                                                  
P33272                                                                  
                                                                        
      ******************************************************************02372100
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *02372200
      ******************************************************************02372300
REARCH*    EXEC SQL                                                     02372400
REARCH*       INCLUDE CPD00300                                          02372500
REARCH*    END-EXEC.                                                    02372600
REARCH     EXEC SQL                                                     02372700
REARCH        INCLUDE CPDSP300                                          02372800
REARCH     END-EXEC.                                                    02372900
                                                                        
      ******************************************************************02373100
      *       END PROGRAM COPYLIB                                      *02373200
      ******************************************************************02373300
REARCH*    COPY CPD00302.                                               02373400
REARCH     EXEC SQL                                                     02373500
REARCH        INCLUDE CPD00321                                          02373600
REARCH     END-EXEC.                                                    02374000
                                                                        
