       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02165.                                     
COB303 DATE-WRITTEN.                                                    
COB303            JULY 05, 2005.                                        
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).            
C26266*  THIS RPC IS ALSO CALLED FROM SERVICE ORDER PANEL 038                   
      *  FOR SYSTEM TRANSFER LOGIC.                                             
      *                                                                         
      *  TRANID:        S165                                                    
      *  PROGRAM:       S165                                                    
      *  CALLING SP:    PA_S165                                                 
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM                      
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                                
      *                                                                         
      *  THIS PROGRAM INSERTS OR UPDATES OR DELETES THE                         
      *  WAIVER DETAILS FOR AN ACCOUNT,                                         
C26266*  BASED ON THE VALUE IN PARM-ACTION-CODE (I, U, D OR X)                  
      *  PARAMETER.                                                             
      *                                                                         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/26/95    SS       CREATED.                                 *        
CBSI  *  09/10/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
      *                                                                *        
C26266*  04/26/02    MDJ      MADE CHANGE TO VERIFY THAT A WAIVER TYPE *        
      *                       'C' DOES NOT EXIST PRIOR TO INSERTING A  *        
      *                       WAIVER.  THIS WAS NEEDED BECAUSE SERVICE *        
      *                       ORDER TRANSFER PROCESS WILL CALL S165    *        
      *                       IN ORDER TO ADD WAIVER.                  *        
      *                       LOGIC WAS ADDED TO DELETE A WAIVER IF THE*        
      *                       STATUS IS ACTIVE OR PENDING,             *        
      *                       BOND TYPE = 'C' (WAIVER) AND WAIVER TYPE =        
      *                       'C' AND ACTION INDICATOR = 'X' (TRANSFER *        
      *                       DELETED).                                *        
REARCH*  07/05/05    CVNS     RPC TO DB2 SP CONVERSION.                *        
REARCH*              CHENNAI                                           *        
C36164*  08/13/07    FMB      CORRECTED TRANSHIST TABLE ID.            *        
      ******************************************************************        
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02165'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02165 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
REARCH*COPY SYGWCOB.                                                            
REARCH*COPY SYDBCOB.                                                            
       COPY CCA00001.                                                           
REARCH*COPY CWS00010.                                                           
REARCH      EXEC SQL                                                            
REARCH         INCLUDE CWSX0010                                                 
REARCH      END-EXEC.                                                           
       COPY CWS00027.                                                           
       COPY CWS00056.                                                           
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02165'.     
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZERO.           
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-WAIVER-TYPE-CD        PIC X(1) VALUE SPACES.          
           05  WS-CODE-STATUS           PIC X(1) VALUE SPACES.          
           05  WS-CODE-BOND-TYPE        PIC X(1) VALUE SPACES.          
           05  WS-CODE-STATUS-REAS      PIC X(20) VALUE SPACES.         
           05  WS-WAIVER-SOURCE-DESC    PIC X(35) VALUE SPACES.         
           05  WS-TRIGGER-DATE          PIC X(10).                      
           05  WS-TRAN-COMMENT-LEN      PIC 9(4) VALUE 0.               
           05  WS-TRAN-COMMENT-LEN-NUM  PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-TRAN-COMMENT-TEXT     PIC X(210) VALUE SPACES.        
           05  WS-COMMENT-LEN           PIC 9(4) VALUE 0.               
           05  WS-COMMENTS.                                             
               49  WS-COMMENT-LEN-NUM   PIC S9(4) USAGE COMP.           
               49  WS-COMMENT-TEXT      PIC X(72).                      
           05  WS-BOND-ITEM-ID          PIC 9(9) VALUE 0.               
           05  WS-BOND-ITEM-ID-NUM      PIC S9(9) USAGE COMP VALUE 0.   
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE 0.              
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-P                     PIC X(01) VALUE 'P'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-55                    PIC X(02) VALUE '55'.           
           05  WS-56                    PIC X(02) VALUE '56'.           
           05  WS-TRIGGER-DATE-NI       PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-NULL-IND              PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-POINTER               PIC S9(3) COMP-3 VALUE ZERO.    
           05  WS-TEMP-TEXT             PIC X(72).                      
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  MNT-TRANSACTION-STORAGE.                                     
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                 POINTER.                                
REARCH*    05  GWL-INIT-HANDLE          POINTER.                                
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02165_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
REARCH*    05  PARM-ACTION-CODE        PIC X(1).                                
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.                  
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                       PIC 9(13).                       
REARCH*    05  PARM-WAIVER-TYPE-CD     PIC X(01) VALUE SPACES.                  
REARCH*    05  PARM-CODE-STATUS        PIC X(01) VALUE SPACES.                  
REARCH*    05  PARM-COMMENTS-LEN       PIC X(04) VALUE SPACES.                  
REARCH*    05  PARM-COMMENTS-TEXT      PIC X(72) VALUE SPACES.                  
REARCH*    05  PARM-CODE-STATUS-REAS   PIC X(20) VALUE SPACES.                  
REARCH*    05  PARM-WAIVER-SOURCE-DESC PIC X(35) VALUE SPACES.                  
REARCH*    05  PARM-TRIGGER-DATE       PIC X(10) VALUE SPACES.                  
REARCH*    05  PARM-BOND-ITEM-ID       PIC X(09) VALUE SPACES.                  
REARCH*    05  PARM-USER-ID            PIC X(07) VALUE SPACES.                  
REARCH*    05  PARM-TRAN-COMMENT-LEN   PIC X(04) VALUE SPACES.                  
REARCH*    05  PARM-TRAN-COMMENT-TEXT  PIC X(210) VALUE SPACES.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE  PIC X(11) VALUE 'RETURN_CODE'.                   
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                  
              SELECT 'Y'                                                
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO = :SB-ACCOUNT-NO AND                    
                     CODE_BOND_TYPE = :SB-CODE-BOND-TYPE AND            
                     ( CODE_STATUS = 'A' OR                             
                       CODE_STATUS = 'P' )                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                   
              SELECT 'Y'                                                
                FROM CSS_GUARANTOR                                      
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO AND                    
                     ( GUAR_STATUS_CD = 'A' OR                          
                       GUAR_STATUS_CD = 'P' )                           
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACTION-CODE        PIC X(01).                           
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-WAIVER-TYPE-CD     PIC X(01).                           
REARCH 01  PARM-CODE-STATUS        PIC X(01).                           
REARCH 01  PARM-COMMENTS-LEN       PIC X(04).                           
REARCH 01  PARM-COMMENTS-TEXT      PIC X(72).                           
REARCH 01  PARM-CODE-STATUS-REAS   PIC X(20).                           
REARCH 01  PARM-WAIVER-SOURCE-DESC PIC X(35).                           
REARCH 01  PARM-TRIGGER-DATE       PIC X(10).                           
REARCH 01  PARM-BOND-ITEM-ID       PIC X(09).                           
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH 01  PARM-TRAN-COMMENT-LEN   PIC X(04).                           
REARCH 01  PARM-TRAN-COMMENT-TEXT  PIC X(210).                          
REARCH PROCEDURE DIVISION USING PARM-ACTION-CODE                        
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-WAIVER-TYPE-CD                     
REARCH                          PARM-CODE-STATUS                        
REARCH                          PARM-COMMENTS-LEN                       
REARCH                          PARM-COMMENTS-TEXT                      
REARCH                          PARM-CODE-STATUS-REAS                   
REARCH                          PARM-WAIVER-SOURCE-DESC                 
REARCH                          PARM-TRIGGER-DATE                       
REARCH                          PARM-BOND-ITEM-ID                       
REARCH                          PARM-USER-ID                            
REARCH                          PARM-TRAN-COMMENT-LEN                   
REARCH                          PARM-TRAN-COMMENT-TEXT.                 
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH* CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.                
REARCH*                                                                         
REARCH* CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,                
REARCH*                       SNA-CONNECTION-NAME, SNA-SUBC.                    
REARCH*                                                                         
REARCH* CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                                 
REARCH*                                                                         
REARCH* IF GWL-RC NOT = TDS-PARM-PRESENT                                        
REARCH*    MOVE PROGRAM-NAME    TO ABEND-PROGRAM                                
REARCH*    MOVE '0100'          TO ACTIVE-PARAGRAPH                             
REARCH*    MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION                 
REARCH*    MOVE 'CICS TRANSACTION'   TO TABLE-1                                 
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE      AS  RETURN_CODE                  
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE      AS  RETURN_CODE                          
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *****************************************************************         
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1100-RECEIVE-PARMS                                                      
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE                    
      *****************************************************************         
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*    MOVE 1                            TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-ACTION-CODE   TO MAX-LENGTH-PARM,                
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACTION-CODE,                              
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                            TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,                   
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-WAIVER-TYPE-CD                                   
REARCH*                                      TO MAX-LENGTH-PARM,                
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-WAIVER-TYPE-CD,                           
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-CODE-STATUS   TO MAX-LENGTH-PARM,                
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CODE-STATUS,                              
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-COMMENTS-LEN     TO MAX-LENGTH-PARM,             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-COMMENTS-LEN,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                              TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-COMMENTS-TEXT  TO MAX-LENGTH-PARM,               
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-COMMENTS-TEXT,                            
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                              TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-CODE-STATUS-REAS TO MAX-LENGTH-PARM,             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CODE-STATUS-REAS,                         
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                           TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-WAIVER-SOURCE-DESC TO MAX-LENGTH-PARM,           
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-WAIVER-SOURCE-DESC,                       
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                               TO PARM-ID1.                     
REARCH*    MOVE LENGTH OF PARM-TRIGGER-DATE    TO MAX-LENGTH-PARM,              
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-TRIGGER-DATE,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-BOND-ITEM-ID       TO MAX-LENGTH-PARM,           
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-BOND-ITEM-ID,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-USER-ID       TO MAX-LENGTH-PARM,                
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-USER-ID,                                  
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-TRAN-COMMENT-LEN TO MAX-LENGTH-PARM,             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-TRAN-COMMENT-LEN,                         
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-TRAN-COMMENT-TEXT TO MAX-LENGTH-PARM,            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-TRAN-COMMENT-TEXT,                        
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                         
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *****************************************************************         
      * 2100-DESCRIBE-RESULT                                                    
      *                                                                         
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                             
      *                                                                         
      *****************************************************************         
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                                     
REARCH*                                                                         
REARCH*    MOVE 1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
           PERFORM 5100-MOVE-PARM-FIELDS  THRU 5100-EXIT.               
           MOVE WS-C                      TO WS-CODE-BOND-TYPE.         
                                                                        
           EVALUATE PARM-ACTION-CODE                                    
                                                                        
            WHEN 'I'                                                    
C26266        MOVE WS-C                    TO SB-CODE-BOND-TYPE         
C26266        PERFORM 7810-OPEN-SEC-CURSOR         THRU 7810-EXIT       
C26266        PERFORM 7820-FETCH-SEC-CURSOR        THRU 7820-EXIT       
C26266        PERFORM 7830-CLOSE-SEC-CURSOR        THRU 7830-EXIT       
C26266        IF EXISTS-NO                                              
                 PERFORM 5400-INITIALIZE-FIELDS    THRU 5400-EXIT       
                 PERFORM 7600-SELECT-MAX-WAIVER    THRU 7600-EXIT       
                 IF WS-NULL-IND < 0                                     
                    MOVE 0 TO  WS-BOND-ITEM-ID-NUM                      
                 END-IF                                                 
                 ADD 1                     TO WS-BOND-ITEM-ID-NUM       
                 PERFORM 5250-JRNL-TRAN-HEAD       THRU 5250-EXIT       
                 PERFORM 5300-INSERT-UPDATE-JRNL   THRU 5300-EXIT       
                 PERFORM 8150-INSERT-WAIVER        THRU 8150-EXIT       
C26266        END-IF                                                    
                                                                        
            WHEN 'U'                                                    
              PERFORM 7100-SELECT-WAIVER        THRU 7100-EXIT          
              PERFORM 5250-JRNL-TRAN-HEAD       THRU 5250-EXIT          
              PERFORM 5300-INSERT-UPDATE-JRNL   THRU 5300-EXIT          
              PERFORM 5600-UPDATE-PARMS         THRU 5600-EXIT          
              PERFORM 8200-UPDATE-WAIVER        THRU 8200-EXIT          
                                                                        
            WHEN 'D'                                                    
              PERFORM 7100-SELECT-WAIVER        THRU 7100-EXIT          
              PERFORM 5250-JRNL-TRAN-HEAD       THRU 5250-EXIT          
              PERFORM 5300-INSERT-UPDATE-JRNL   THRU 5300-EXIT          
              PERFORM 8400-DELETE-WAIVER        THRU 8400-EXIT          
                                                                        
C26266      WHEN 'X'                                                    
C26266        PERFORM 7110-SELECT-BOND-WAIVER   THRU 7110-EXIT          
C26266        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C26266           PERFORM 5250-JRNL-TRAN-HEAD       THRU 5250-EXIT       
C26266           PERFORM 5300-INSERT-UPDATE-JRNL   THRU 5300-EXIT       
C26266           PERFORM 8400-DELETE-WAIVER        THRU 8400-EXIT       
C26266        ELSE                                                      
C26266           MOVE +0              TO WS-ACTIVE-RETURN-CODE          
C26266        END-IF                                                    
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
           PERFORM 5500-UPDATE-CODES-DATA       THRU 5500-EXIT.         
           MOVE '5000'                TO ACTIVE-PARAGRAPH.              
REARCH     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
REARCH     ADD +1                     TO   CTR-ROWS.                    
REARCH*    PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                             
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE PARAMETER FIELDS INTO WORKING STORAGE                 *            
      **************************************************************            
                                                                        
       5100-MOVE-PARM-FIELDS.                                           
                                                                        
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO SB-ACCOUNT-NO              
                                             GU-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
           MOVE PARM-WAIVER-TYPE-CD       TO WS-WAIVER-TYPE-CD.         
           MOVE PARM-CODE-STATUS          TO WS-CODE-STATUS.            
           MOVE PARM-COMMENTS-LEN         TO WS-COMMENT-LEN.            
           MOVE WS-COMMENT-LEN            TO WS-COMMENT-LEN-NUM.        
           MOVE PARM-COMMENTS-TEXT        TO WS-COMMENT-TEXT.           
           MOVE PARM-CODE-STATUS-REAS     TO WS-CODE-STATUS-REAS.       
           MOVE PARM-WAIVER-SOURCE-DESC   TO WS-WAIVER-SOURCE-DESC.     
           MOVE PARM-TRIGGER-DATE         TO WS-TRIGGER-DATE.           
           MOVE PARM-BOND-ITEM-ID         TO WS-BOND-ITEM-ID.           
           MOVE WS-BOND-ITEM-ID           TO WS-BOND-ITEM-ID-NUM.       
           MOVE WS-BOND-ITEM-ID-NUM       TO SB-BOND-WAIV-ITEM-ID.      
           MOVE PARM-USER-ID              TO PF-USER-ID.                
           MOVE PARM-TRAN-COMMENT-LEN     TO WS-TRAN-COMMENT-LEN.       
           MOVE WS-TRAN-COMMENT-LEN       TO WS-TRAN-COMMENT-LEN-NUM.   
           MOVE PARM-TRAN-COMMENT-TEXT    TO WS-TRAN-COMMENT-TEXT.      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * JOURNAL MAINTENANCE TRANSACTION HEADER                      *           
      ***************************************************************           
                                                                        
       5250-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7300-SELECT-TIMESTAMP      THRU 7300-EXIT.           
           PERFORM 7400-SELECT-DATE           THRU 7400-EXIT.           
           PERFORM 7500-SELECT-RESP-AREA      THRU 7500-EXIT.           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE WS-ACCOUNT-NO-NUM         TO MH-ACCOUNT-NO.             
           MOVE PF-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE PF-USER-ID                TO MH-USER-ID.                
           MOVE 'PANEL246'                TO MH-APPL-PROGRAM-ID.        
           MOVE WS-TRAN-COMMENT-LEN-NUM   TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-TRAN-COMMENT-TEXT      TO MH-TRAN-COMMENT-TEXT.      
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * JOURNAL EVERY CHANGED ENTRY FIELD                          *            
      **************************************************************            
                                                                        
       5300-INSERT-UPDATE-JRNL.                                         
                                                                        
           PERFORM 5305-TYPE-CODE-JRNL    THRU 5305-EXIT.               
           PERFORM 5310-CODE-STAT-JRNL    THRU 5310-EXIT.               
           PERFORM 5315-STAT-REAS-JRNL    THRU 5315-EXIT.               
           PERFORM 5320-COMMENT-JRNL      THRU 5320-EXIT.               
           PERFORM 5325-SOURCE-JRNL       THRU 5325-EXIT.               
           PERFORM 5330-TRIG-DATE-JRNL    THRU 5330-EXIT.               
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL WAIVER TYPE CODE                                      *         
      *****************************************************************         
                                                                        
       5305-TYPE-CODE-JRNL.                                             
                                                                        
           IF SB-WAIVER-TYPE-CD   NOT = WS-WAIVER-TYPE-CD               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
C36164        MOVE 'A6'                   TO MI-TABLE-ID                
                                                                        
              IF WS-WAIVER-TYPE-CD > SPACES                             
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-WAIVER-TYPE-CD   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-WAIVER-TYPE-CD > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-WAIVER-TYPE-CD   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'WAIVER TYPE CD'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL CODE STATUS                                           *         
      *****************************************************************         
                                                                        
       5310-CODE-STAT-JRNL.                                             
                                                                        
           IF SB-CODE-STATUS      NOT = WS-CODE-STATUS                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE WS-56                  TO MI-TABLE-ID                
                                                                        
              IF WS-CODE-STATUS    > SPACES                             
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-CODE-STATUS      TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-CODE-STATUS    > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-CODE-STATUS      TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'CODE STATUS'          TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL CODE STATUS REASON                                    *         
      *****************************************************************         
                                                                        
       5315-STAT-REAS-JRNL.                                             
                                                                        
           IF SB-CODE-STATUS-REAS NOT = WS-CODE-STATUS-REAS             
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
                                                                        
              IF WS-CODE-STATUS-REAS > SPACES                           
                 MOVE +20                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-CODE-STATUS-REAS TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-CODE-STATUS-REAS > SPACES                           
                 MOVE +20                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-CODE-STATUS-REAS TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'STATUS REASON'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL COMMENTS                                              *         
      *****************************************************************         
                                                                        
       5320-COMMENT-JRNL.                                               
                                                                        
           IF SB-COMMENTS-TEXT      NOT = WS-COMMENT-TEXT               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
                                                                        
              IF WS-COMMENT-TEXT      > SPACES                          
                 MOVE WS-COMMENT-LEN-NUM  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-COMMENT-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-COMMENTS-TEXT      > SPACES                         
                 MOVE SB-COMMENTS-LEN     TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-COMMENTS-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'COMMENTS'             TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL WAIVER SOURCE                                         *         
      *****************************************************************         
                                                                        
       5325-SOURCE-JRNL.                                                
                                                                        
           IF SB-WAIVER-SOURCE-DESC NOT = WS-WAIVER-SOURCE-DESC         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
                                                                        
              IF WS-WAIVER-SOURCE-DESC > SPACES                         
                 MOVE +35                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-WAIVER-SOURCE-DESC TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-WAIVER-SOURCE-DESC > SPACES                         
                 MOVE +35                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-WAIVER-SOURCE-DESC TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'WAIVER SOURCE'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL TRIGGER DATE                                          *         
      *****************************************************************         
                                                                        
       5330-TRIG-DATE-JRNL.                                             
                                                                        
           IF SB-TRIGGER-DATE       NOT = WS-TRIGGER-DATE               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
                                                                        
              IF WS-TRIGGER-DATE       > SPACES                         
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-TRIGGER-DATE     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF SB-TRIGGER-DATE       > SPACES                         
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE SB-TRIGGER-DATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'TRIGGER DATE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  INITIALIZE PREVIOUS VALUES FOR TABLE FIELDS FOR MAINTENANCE   *        
      *  TRANS ENTRY IN CASE OF INSERT OF NEW WAIVER                   *        
      ******************************************************************        
                                                                        
       5400-INITIALIZE-FIELDS.                                          
                                                                        
           MOVE SPACES                       TO SB-WAIVER-TYPE-CD       
                                                SB-CODE-STATUS          
                                                SB-CODE-STATUS-REAS     
                                                SB-WAIVER-SOURCE-DESC   
                                                SB-TRIGGER-DATE         
                                                SB-COMMENTS-TEXT.       
           MOVE 0                            TO SB-COMMENTS-LEN.        
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * UPDATE CODES DATA PRESENT                                     *         
      *****************************************************************         
                                                                        
       5500-UPDATE-CODES-DATA.                                          
                                                                        
           MOVE '5500'                       TO ACTIVE-PARAGRAPH.       
           PERFORM 7700-SELECT-ACCOUNT          THRU 7700-EXIT.         
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE WS-A                  TO WS-CODE-SEC-ACCT.              
C26266     IF PARM-ACTION-CODE = 'D' OR 'X'                             
              MOVE WS-A                  TO SB-CODE-BOND-TYPE           
              PERFORM 7810-OPEN-SEC-CURSOR         THRU 7810-EXIT       
              PERFORM 7820-FETCH-SEC-CURSOR        THRU 7820-EXIT       
              PERFORM 7830-CLOSE-SEC-CURSOR        THRU 7830-EXIT       
              MOVE WS-B                  TO SB-CODE-BOND-TYPE           
              IF EXISTS-NO                                              
                 PERFORM 7810-OPEN-SEC-CURSOR      THRU 7810-EXIT       
                 PERFORM 7820-FETCH-SEC-CURSOR     THRU 7820-EXIT       
                 PERFORM 7830-CLOSE-SEC-CURSOR     THRU 7830-EXIT       
              END-IF                                                    
              IF EXISTS-NO                                              
                 PERFORM 7850-OPEN-GUAR-CURSOR     THRU 7850-EXIT       
                 PERFORM 7860-FETCH-GUAR-CURSOR    THRU 7860-EXIT       
                 PERFORM 7870-CLOSE-GUAR-CURSOR    THRU 7870-EXIT       
              END-IF                                                    
              IF EXISTS-NO                                              
                 MOVE SPACES                TO WS-CODE-SEC-ACCT         
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
           PERFORM 8300-UPDATE-ACCOUNT          THRU 8300-EXIT.         
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * POPULATE FIELDS FOR UPDATING WAIVER DETAILS                   *         
      *****************************************************************         
       5600-UPDATE-PARMS.                                               
                                                                        
           MOVE '5600'                  TO ACTIVE-PARAGRAPH.            
           MOVE WS-WAIVER-TYPE-CD       TO SB-WAIVER-TYPE-CD.           
           MOVE WS-CODE-STATUS          TO SB-CODE-STATUS.              
           MOVE WS-COMMENTS             TO SB-COMMENTS.                 
           MOVE WS-CODE-STATUS-REAS     TO SB-CODE-STATUS-REAS.         
           MOVE WS-WAIVER-SOURCE-DESC   TO SB-WAIVER-SOURCE-DESC.       
           MOVE WS-TRIGGER-DATE         TO SB-TRIGGER-DATE.             
           MOVE WS-BOND-ITEM-ID-NUM     TO SB-BOND-WAIV-ITEM-ID.        
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * SELECT EXISTING FIELD VALUES FROM CSS_SURETY_BOND FOR          *        
      * MAINTENANCE TRANSACTION HISTORY UPDATE                         *        
      ******************************************************************        
                                                                        
       7100-SELECT-WAIVER.                                              
                                                                        
           MOVE '7100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT WAIVER_TYPE_CD,                                    
                     CODE_STATUS,                                       
                     COMMENTS,                                          
                     CODE_STATUS_REAS,                                  
                     WAIVER_SOURCE_DESC,                                
                     CIS.CHAR2$DATE(TRIGGER_DATE,'USA')                         
                INTO :SB-WAIVER-TYPE-CD,                                
                     :SB-CODE-STATUS,                                   
                     :SB-COMMENTS,                                      
                     :SB-CODE-STATUS-REAS,                              
                     :SB-WAIVER-SOURCE-DESC,                            
                     :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI                
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO                 
                 AND BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WAIVER_TYPE_CD,                                            
MFA-TR*              CODE_STATUS,                                               
MFA-TR*              COMMENTS,                                                  
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              WAIVER_SOURCE_DESC,                                        
MFA-TR*              CHAR(TRIGGER_DATE,USA)                                     
MFA-TR*         INTO :SB-WAIVER-TYPE-CD,                                        
MFA-TR*              :SB-CODE-STATUS,                                           
MFA-TR*              :SB-COMMENTS,                                              
MFA-TR*              :SB-CODE-STATUS-REAS,                                      
MFA-TR*              :SB-WAIVER-SOURCE-DESC,                                    
MFA-TR*              :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI                        
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO                         
MFA-TR*          AND BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-TRIGGER-DATE-NI EQUAL -1                            
                 MOVE SPACES            TO SB-TRIGGER-DATE              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-2              
              MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-BOND-ITEM-ID      TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-BOND-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SELECT EXISTING FIELD VALUES FROM CSS_SURETY_BOND FOR          *        
      * MAINTENANCE TRANSACTION HISTORY UPDATE AND WAIVER DELETION     *        
      * DUE TO SYSTEM TRANFER DELETION.                                *        
      * CODE_STATUS = 'A' OR 'P'.                                      *        
      * WAIVER_TYPE_CD = 'K' (SYSTEM TRANSFER)                         *        
      ******************************************************************        
                                                                        
C26266 7110-SELECT-BOND-WAIVER.                                         
                                                                        
           MOVE '7110'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT WAIVER_TYPE_CD,                                    
                     BOND_WAIV_ITEM_ID,                                 
                     CODE_STATUS,                                       
                     COMMENTS,                                          
                     CODE_STATUS_REAS,                                  
                     WAIVER_SOURCE_DESC,                                
                     CIS.CHAR2$DATE(TRIGGER_DATE,'USA')                         
                INTO :SB-WAIVER-TYPE-CD,                                
                     :SB-BOND-WAIV-ITEM-ID,                             
                     :SB-CODE-STATUS,                                   
                     :SB-COMMENTS,                                      
                     :SB-CODE-STATUS-REAS,                              
                     :SB-WAIVER-SOURCE-DESC,                            
                     :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI                
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO AND             
                   ( CODE_STATUS = 'A' OR                               
                     CODE_STATUS = 'P' ) AND                            
                     CODE_BOND_TYPE    = 'C' AND                        
                     WAIVER_TYPE_CD    = 'K'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WAIVER_TYPE_CD,                                            
MFA-TR*              BOND_WAIV_ITEM_ID,                                         
MFA-TR*              CODE_STATUS,                                               
MFA-TR*              COMMENTS,                                                  
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              WAIVER_SOURCE_DESC,                                        
MFA-TR*              CHAR(TRIGGER_DATE,USA)                                     
MFA-TR*         INTO :SB-WAIVER-TYPE-CD,                                        
MFA-TR*              :SB-BOND-WAIV-ITEM-ID,                                     
MFA-TR*              :SB-CODE-STATUS,                                           
MFA-TR*              :SB-COMMENTS,                                              
MFA-TR*              :SB-CODE-STATUS-REAS,                                      
MFA-TR*              :SB-WAIVER-SOURCE-DESC,                                    
MFA-TR*              :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI                        
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO AND                     
MFA-TR*            ( CODE_STATUS = 'A' OR                                       
MFA-TR*              CODE_STATUS = 'P' ) AND                                    
MFA-TR*              CODE_BOND_TYPE    = 'C' AND                                
MFA-TR*              WAIVER_TYPE_CD    = 'K'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-TRIGGER-DATE-NI EQUAL -1                            
                 MOVE SPACES            TO SB-TRIGGER-DATE              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-2              
              MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-BOND-ITEM-ID      TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-BOND-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
C26266 7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SELECT CURRENT TIMESTAMP                                       *        
      ******************************************************************        
                                                                        
       7300-SELECT-TIMESTAMP.                                           
                                                                        
           MOVE '7300'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
              INTO :MH-TRANS-HIST-SEQ-NO                                
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP                                          
MFA-TR*       INTO :MH-TRANS-HIST-SEQ-NO                                        
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_MODEL_SQL'      TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-DATE.                                                
                                                                        
           MOVE '7400'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
              INTO :MH-DATE-TRANS                                       
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*       INTO :MH-DATE-TRANS                                               
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_MODEL_SQL'      TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-SELECT-RESP-AREA.                                           
                                                                        
           MOVE '7500'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
              INTO :PF-RESP-AREA-ID                                     
              FROM CSS_USER_PROFILE                                     
              WHERE USER_ID = :PF-USER-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-SELECT-MAX-WAIVER.                                          
                                                                        
CBSI       MOVE '7600' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT MAX( BOND_WAIV_ITEM_ID )                           
                INTO :WS-BOND-ITEM-ID-NUM :WS-NULL-IND                   
                FROM CSS_SURETY_BOND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
                INTO :AT-CODES-DATA-PRESENT                             
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7810-OPEN-SECURITY-CURSOR                                  *            
      **************************************************************            
       7810-OPEN-SEC-CURSOR.                                            
           MOVE '7810'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN SECURITY-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE SB-CODE-BOND-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7820-FETCH-SECURITY-CURSOR                                 *            
      **************************************************************            
       7820-FETCH-SEC-CURSOR.                                           
           MOVE '7820'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH SECURITY-CURSOR                                     
               INTO :EXISTS-SW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE SB-CODE-BOND-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7830-CLOSE-SECURITY-CURSOR                                 *            
      **************************************************************            
       7830-CLOSE-SEC-CURSOR.                                           
           MOVE '7830'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE SECURITY-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE SB-CODE-BOND-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7850-OPEN-GUARNTR-CURSOR                                   *            
      **************************************************************            
       7850-OPEN-GUAR-CURSOR.                                           
           MOVE '7850'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN GUARNTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7860-FETCH-GUARNTR-CURSOR                                  *            
      **************************************************************            
       7860-FETCH-GUAR-CURSOR.                                          
           MOVE '7860'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH GUARNTR-CURSOR                                      
               INTO :EXISTS-SW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7870-CLOSE-GUARNTR-CURSOR                                  *            
      **************************************************************            
       7870-CLOSE-GUAR-CURSOR.                                          
           MOVE '7870'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE GUARNTR-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT.                                                                   
                                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN CSS_SURETY_BOND FOR WAIVER DETAILS.        *           
      ***************************************************************           
                                                                        
       8150-INSERT-WAIVER.                                              
           MOVE '8150' TO ACTIVE-PARAGRAPH.                             
           IF WS-TRIGGER-DATE     <= SPACES                             
              MOVE -1                     TO WS-TRIGGER-DATE-NI         
           ELSE                                                         
              MOVE 0                      TO WS-TRIGGER-DATE-NI         
           END-IF.                                                      
           EXEC SQL                                                     
           INSERT INTO CSS_SURETY_BOND                                  
                  ( ACCOUNT_NO         ,                                
                    BOND_WAIV_ITEM_ID  ,                                
                    WAIVER_TYPE_CD     ,                                
                    CODE_STATUS        ,                                
                    COMMENTS           ,                                
                    CODE_STATUS_REAS   ,                                
                    WAIVER_SOURCE_DESC ,                                
                    TRIGGER_DATE       ,                                
                    CODE_BOND_TYPE     )                                
           VALUES (:WS-ACCOUNT-NO-NUM     ,                             
                   :WS-BOND-ITEM-ID-NUM   ,                             
                   :WS-WAIVER-TYPE-CD     ,                             
                   :WS-CODE-STATUS        ,                             
                   :WS-COMMENTS           ,                             
                   :WS-CODE-STATUS-REAS   ,                             
                   :WS-WAIVER-SOURCE-DESC ,                             
                   IIF(TRY_CONVERT(DATE, :WS-TRIGGER-DATE 
                                         :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:WS-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :WS-TRIGGER-DATE :WS-TRIGGER-DATE-NI) ),        
                   :WS-C                  )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_SURETY_BOND                                          
MFA-TR*           ( ACCOUNT_NO         ,                                        
MFA-TR*             BOND_WAIV_ITEM_ID  ,                                        
MFA-TR*             WAIVER_TYPE_CD     ,                                        
MFA-TR*             CODE_STATUS        ,                                        
MFA-TR*             COMMENTS           ,                                        
MFA-TR*             CODE_STATUS_REAS   ,                                        
MFA-TR*             WAIVER_SOURCE_DESC ,                                        
MFA-TR*             TRIGGER_DATE       ,                                        
MFA-TR*             CODE_BOND_TYPE     )                                        
MFA-TR*    VALUES (:WS-ACCOUNT-NO-NUM     ,                                     
MFA-TR*            :WS-BOND-ITEM-ID-NUM   ,                                     
MFA-TR*            :WS-WAIVER-TYPE-CD     ,                                     
MFA-TR*            :WS-CODE-STATUS        ,                                     
MFA-TR*            :WS-COMMENTS           ,                                     
MFA-TR*            :WS-CODE-STATUS-REAS   ,                                     
MFA-TR*            :WS-WAIVER-SOURCE-DESC ,                                     
MFA-TR*            :WS-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                         
MFA-TR*            :WS-C                  )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-2              
CBSI          MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'TRIGGER_DATE'       TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-BOND-ITEM-ID-NUM  TO HOSTVAR-ELEMENT-2            
              MOVE WS-C                 TO HOSTVAR-ELEMENT-3            
CBSI          MOVE WS-TRIGGER-DATE      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE RECORD IN CSS_SURETY_BOND FOR WAIVER DETAILS.        *           
      ***************************************************************           
                                                                        
       8200-UPDATE-WAIVER.                                              
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
           IF WS-TRIGGER-DATE     <= SPACES                             
              MOVE -1                     TO WS-TRIGGER-DATE-NI         
           ELSE                                                         
              MOVE 0                      TO WS-TRIGGER-DATE-NI         
           END-IF.                                                      
           EXEC SQL                                                     
           UPDATE CSS_SURETY_BOND                                       
           SET      WAIVER_TYPE_CD     = :SB-WAIVER-TYPE-CD,            
                    CODE_STATUS        = :SB-CODE-STATUS,               
                    COMMENTS           = :SB-COMMENTS,                  
                    CODE_STATUS_REAS   = :SB-CODE-STATUS-REAS,          
                    WAIVER_SOURCE_DESC = :SB-WAIVER-SOURCE-DESC,        
                    TRIGGER_DATE       = IIF(TRY_CONVERT(DATE, 
                                                      :SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI) )         
           WHERE    ACCOUNT_NO         = :SB-ACCOUNT-NO                 
           AND      BOND_WAIV_ITEM_ID  = :SB-BOND-WAIV-ITEM-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    UPDATE CSS_SURETY_BOND                                               
MFA-TR*    SET      WAIVER_TYPE_CD     = :SB-WAIVER-TYPE-CD,                    
MFA-TR*             CODE_STATUS        = :SB-CODE-STATUS,                       
MFA-TR*             COMMENTS           = :SB-COMMENTS,                          
MFA-TR*             CODE_STATUS_REAS   = :SB-CODE-STATUS-REAS,                  
MFA-TR*             WAIVER_SOURCE_DESC = :SB-WAIVER-SOURCE-DESC,                
MFA-TR*             TRIGGER_DATE       = :SB-TRIGGER-DATE                       
MFA-TR*                                  :WS-TRIGGER-DATE-NI                    
MFA-TR*    WHERE    ACCOUNT_NO         = :SB-ACCOUNT-NO                         
MFA-TR*    AND      BOND_WAIV_ITEM_ID  = :SB-BOND-WAIV-ITEM-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-2              
CBSI          MOVE 'TRIGGER_DATE'       TO TABLE-ELEMENT-3              
CBSI          MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-BOND-ITEM-ID-NUM  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE SB-TRIGGER-DATE      TO HOSTVAR-ELEMENT-3            
CBSI          MOVE SB-CODE-STATUS       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8300-UPDATE-ACCOUNT.                                        *           
      ***************************************************************           
                                                                        
       8300-UPDATE-ACCOUNT.                                             
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           UPDATE CSS_ACCOUNT                                           
           SET      CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT         
           WHERE    ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODES_DATA_PRESENT' TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AT-CODES-DATA-PRESENT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DELETE RECORD IN CSS_SURETY_BOND FOR WAIVER DETAILS.        *           
      ***************************************************************           
                                                                        
       8400-DELETE-WAIVER.                                              
           MOVE '8400' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           DELETE FROM CSS_SURETY_BOND                                  
           WHERE    ACCOUNT_NO         = :SB-ACCOUNT-NO                 
           AND      BOND_WAIV_ITEM_ID  = :SB-BOND-WAIV-ITEM-ID          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'S165'               TO ABEND-PROGRAM                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-2              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
REARCH*       EXEC SQL                                                          
REARCH*          INCLUDE CPD00300                                               
REARCH*       END-EXEC.                                                         
                                                                        
REARCH        EXEC SQL                                                          
REARCH           INCLUDE CPDSP300                                               
REARCH        END-EXEC.                                                         
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
REARCH*COPY CPD00302.                                                           
                                                                        
REARCH        EXEC SQL                                                          
REARCH           INCLUDE CPD00321                                               
REARCH        END-EXEC.                                                         
