       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02164.                                     
COB303 DATE-WRITTEN.                                                    
COB303            JULY 07, 2005.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S164                                           *        
      *  PROGRAM:       S164                                           *        
      *  CALLING SP:    PA_S164                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES WAIVER DETAILS FOR A CUSTOMER'S ACCOUNT*        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/19/95    SS       CREATED.                                 *        
T16174*  05/08/98    SHF      MODIFIED SQL QUERY IN PARA 7200.         *        
CBSI  *  09/02/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
REARCH*  07/07/05   CVNS      RPC TO DB2 SP CONVERSION.                *        
REARCH*             CHENNAI                                            *        
REARCH*  08/16/05   CVNS      STRIP ADDED FOR COMMENTS FIELD.          *        
REARCH*             CHENNAI                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02164'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02164 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_SURETY_BOND >                                                   
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUSTOMER >                                                      
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUST_STAT >                                                     
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                POINTER.                                 
REARCH*    05  GWL-INIT-HANDLE         POINTER.                                 
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02164_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-BOND-TYPE          PIC X(01) VALUE SPACES.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.                  
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                                 PIC 9(13).             
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02164'.      
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 50 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-RETURN-DATE.                                          
               10  WS-MONTH                PIC X(02) VALUE SPACES.      
               10  WS-DAY                  PIC X(02) VALUE SPACES.      
               10  WS-YEAR                 PIC X(04) VALUE SPACES.      
           05  WS-DB2-DATE.                                             
               10  WS-DB2-MONTH            PIC X(02) VALUE SPACES.      
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-DB2-DAY              PIC X(02) VALUE SPACES.      
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-DB2-YEAR             PIC X(04) VALUE SPACES.      
                                                                        
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-TRIGGER-DATE-NI        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-C                    PIC X(01) VALUE 'C'.             
           05  WS-100                  PIC S9(9) VALUE +100.            
           05  WS-200                  PIC S9(9) VALUE +200.            
           05  WS-S                    PIC X(01) VALUE 'S'.             
           05  WS-0                    PIC S9(9) VALUE +0.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-WAIVER-TYPE-CD       PIC X(2) VALUE SPACES.           
           05  RS-CODE-STATUS          PIC X(1) VALUE SPACES.           
           05  RS-COMMENTS             PIC X(72) VALUE SPACES.          
           05  RS-CODE-STATUS-REAS     PIC X(20) VALUE SPACES.          
           05  RS-WAIVER-SOURCE-DESC   PIC X(35) VALUE SPACES.          
           05  RS-TRIGGER-DATE         PIC X(08) VALUE SPACES.          
           05  RS-BOND-ITEM-ID         PIC S9(9) COMP VALUE 0.          
           05  RS-SSN-NUMBER           PIC X(09) VALUE SPACES.          
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-WAIVER-TYPE-CD        PIC X(2) VALUE SPACES.           
REARCH     05  S-CODE-STATUS           PIC X(1) VALUE SPACES.           
REARCH     05  S-COMMENTS              PIC X(72) VALUE SPACES.          
REARCH     05  S-CODE-STATUS-REAS      PIC X(20) VALUE SPACES.          
REARCH     05  S-WAIVER-SOURCE-DESC    PIC X(35) VALUE SPACES.          
REARCH     05  S-TRIGGER-DATE          PIC X(08) VALUE SPACES.          
REARCH     05  S-BOND-ITEM-ID          PIC S9(9) COMP VALUE 0.          
REARCH     05  S-SSN-NUMBER            PIC X(09) VALUE SPACES.          
                                                                        
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE        PIC X(11) VALUE                           
REARCH*                                        'RETURN_CODE'.                   
REARCH*    05  CNS-WAIVER-TYPE-CD     PIC X(14) VALUE                           
REARCH*                                        'WAIVER_TYPE_CD'.                
REARCH*    05  CNS-CODE-STATUS        PIC X(11) VALUE                           
REARCH*                                        'CODE_STATUS'.                   
REARCH*    05  CNS-COMMENTS           PIC X(08) VALUE 'COMMENTS'.               
REARCH*    05  CNS-CODE-STATUS-REAS   PIC X(16) VALUE                           
REARCH*                                        'CODE_STATUS_REAS'.              
REARCH*    05  CNS-WAIVER-SOURCE-DESC PIC X(18) VALUE                           
REARCH*                                        'WAIVER_SOURCE_DESC'.            
REARCH*    05  CNS-TRIGGER-DATE       PIC X(12) VALUE 'TRIGGER_DATE'.           
REARCH*    05  CNS-BOND-ITEM-ID       PIC X(12) VALUE 'BOND_ITEM_ID'.           
REARCH*    05  CNS-SSN-NUMBER         PIC X(09) VALUE 'SS NUMBER'.              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE WAIVER-CURSOR CURSOR FOR                    
              SELECT WAIVER_TYPE_CD,                                    
                     CODE_STATUS,                                       
                     COMMENTS,                                          
                     CODE_STATUS_REAS,                                  
                     WAIVER_SOURCE_DESC,                                
                     CIS.CHAR2$DATE(TRIGGER_DATE,'USA'),                        
                     BOND_WAIV_ITEM_ID                                  
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO = :SB-ACCOUNT-NO AND                    
                     CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE WAIVER-CURSOR CURSOR FOR                            
MFA-TR*       SELECT WAIVER_TYPE_CD,                                            
MFA-TR*              CODE_STATUS,                                               
MFA-TR*              COMMENTS,                                                  
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              WAIVER_SOURCE_DESC,                                        
MFA-TR*              CHAR(TRIGGER_DATE,USA),                                    
MFA-TR*              BOND_WAIV_ITEM_ID                                          
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO = :SB-ACCOUNT-NO AND                            
MFA-TR*              CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                        
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACCOUNT-NO         PIC X(13).                            
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
RERACH             :S-RETURN-CODE                AS  RETURN_CODE        
RERACH            ,:S-WAIVER-TYPE-CD             AS  WAIVER_TYPE_CD     
RERACH            ,:S-CODE-STATUS                AS  CODE_STATUS        
RERACH            ,LTRIM(RTRIM(:S-COMMENTS))            AS  COMMENTS           
RERACH            ,LTRIM(RTRIM(:S-CODE-STATUS-REAS))    AS  
           CODE_STATUS_REAS   
RERACH            ,LTRIM(RTRIM(:S-WAIVER-SOURCE-DESC))  AS  
           WAIVER_SOURCE_DESC 
RERACH            ,LTRIM(RTRIM(:S-TRIGGER-DATE))        AS  TRIGGER_DATE       
RERACH            ,:S-BOND-ITEM-ID               AS  BOND_ITEM_ID       
RERACH            ,:S-SSN-NUMBER                 AS  SSN_NUMBER         
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE                AS  RETURN_CODE                
MFA-TR*           ,:S-WAIVER-TYPE-CD             AS  WAIVER_TYPE_CD             
MFA-TR*           ,:S-CODE-STATUS                AS  CODE_STATUS                
MFA-TR*           ,STRIP(:S-COMMENTS)            AS  COMMENTS                   
MFA-TR*           ,STRIP(:S-CODE-STATUS-REAS)    AS  CODE_STATUS_REAS           
MFA-TR*           ,STRIP(:S-WAIVER-SOURCE-DESC)  AS  WAIVER_SOURCE_DESC         
MFA-TR*           ,STRIP(:S-TRIGGER-DATE)        AS  TRIGGER_DATE               
MFA-TR*           ,:S-BOND-ITEM-ID               AS  BOND_ITEM_ID               
MFA-TR*           ,:S-SSN-NUMBER                 AS  SSN_NUMBER                 
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO SB-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*    MOVE 1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-WAIVER-TYPE-CD      TO S-WAIVER-TYPE-CD.             
REARCH     MOVE RS-CODE-STATUS         TO S-CODE-STATUS.                
REARCH     MOVE RS-COMMENTS            TO S-COMMENTS.                   
REARCH     MOVE RS-CODE-STATUS-REAS    TO S-CODE-STATUS-REAS.           
REARCH     MOVE RS-WAIVER-SOURCE-DESC  TO S-WAIVER-SOURCE-DESC.         
REARCH     MOVE RS-TRIGGER-DATE        TO S-TRIGGER-DATE.               
REARCH     MOVE RS-BOND-ITEM-ID        TO S-BOND-ITEM-ID.               
REARCH     MOVE RS-SSN-NUMBER          TO S-SSN-NUMBER.                 
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*    MOVE '2100'          TO ACTIVE-PARAGRAPH                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-RETURN-CODE>                                            
REARCH*    MOVE 1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RETURN-CODE,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-WAIVER-TYPE-CD >                                        
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-WAIVER-TYPE-CD  TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-WAIVER-TYPE-CD TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-WAIVER-TYPE-CD,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-WAIVER-TYPE-CD,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-CODE-STATUS >                                           
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR      TO DB-HOST-TYPE.                                   
REARCH*    MOVE TDSCHAR      TO DB-CLIENT-TYPE.                                 
REARCH*    MOVE LENGTH OF RS-CODE-STATUS     TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-CODE-STATUS    TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-STATUS,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-CODE-STATUS,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-COMMENTS >                                              
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-COMMENTS     TO WRKLEN1.                           
REARCH*    MOVE LENGTH OF CNS-COMMENTS    TO WRKLEN2.                           
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COMMENTS,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-COMMENTS,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-CODE-STATUS-REAS >                                      
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-CODE-STATUS-REAS TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-CODE-STATUS-REAS TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-STATUS-REAS,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-CODE-STATUS-REAS,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-WAIVER-SOURCE-DESC >                                    
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-WAIVER-SOURCE-DESC  TO WRKLEN1.                    
REARCH*    MOVE LENGTH OF CNS-WAIVER-SOURCE-DESC  TO WRKLEN2.                   
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-WAIVER-SOURCE-DESC,                         
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-WAIVER-SOURCE-DESC,                        
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-TRIGGER-DATE >                                          
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-TRIGGER-DATE   TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CNS-TRIGGER-DATE  TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TRIGGER-DATE,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TRIGGER-DATE,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-BOND-ITEM-ID >                                          
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-BOND-ITEM-ID   TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CNS-BOND-ITEM-ID  TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BOND-ITEM-ID,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BOND-ITEM-ID,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-SSN-NUMBER >                                            
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-SSN-NUMBER   TO WRKLEN1.                           
REARCH*    MOVE LENGTH OF CNS-SSN-NUMBER  TO WRKLEN2.                           
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-SSN-NUMBER,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-SSN-NUMBER,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7100-SELECT-ACCOUNT            THRU 7100-EXIT.       
           IF AT-MST-SUB-ACCT-IND EQUAL WS-S                            
              MOVE WS-200                 TO RS-RETURN-CODE             
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
REARCH        ADD +1                      TO CTR-ROWS                   
REARCH*       PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                        
              GO TO 2200-EXIT                                           
           END-IF.                                                      
           MOVE AT-CUSTOMER-NO            TO CE-CUSTOMER-NO.            
           PERFORM 7200-SELECT-SSNUMBER   THRU 7200-EXIT.               
           MOVE WS-C                      TO SB-CODE-BOND-TYPE.         
           PERFORM 7000-OPEN-WAIVER-CURSOR        THRU 7000-EXIT.       
           PERFORM 7010-FETCH-WAIVER-CURSOR       THRU 7010-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-100                    TO RS-RETURN-CODE          
              MOVE CE-SSN                    TO RS-SSN-NUMBER           
           END-IF.                                                      
           PERFORM 7020-CLOSE-WAIVER-CURSOR       THRU 7020-EXIT.       
           IF RS-RETURN-CODE NOT EQUAL WS-100                           
              PERFORM 2300-MOVE-RESULT          THRU 2300-EXIT
           END-IF.         
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
REARCH     ADD +1                               TO CTR-ROWS.            
REARCH*    PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2300-MOVE-RESULT                                             *          
      ****************************************************************          
       2300-MOVE-RESULT.                                                
                                                                        
           MOVE WS-0                         TO RS-RETURN-CODE.         
           MOVE SB-WAIVER-TYPE-CD            TO RS-WAIVER-TYPE-CD.      
           MOVE SB-CODE-STATUS               TO RS-CODE-STATUS.         
           MOVE SB-COMMENTS-TEXT             TO RS-COMMENTS.            
           MOVE SB-CODE-STATUS-REAS          TO RS-CODE-STATUS-REAS.    
           MOVE SB-WAIVER-SOURCE-DESC        TO RS-WAIVER-SOURCE-DESC.  
           MOVE SB-BOND-WAIV-ITEM-ID         TO RS-BOND-ITEM-ID.        
           MOVE CE-SSN                       TO RS-SSN-NUMBER.          
           IF WS-TRIGGER-DATE-NI < 0                                    
              MOVE SPACES                       TO RS-TRIGGER-DATE      
           ELSE                                                         
              MOVE SB-TRIGGER-DATE              TO WS-DB2-DATE          
              MOVE WS-DB2-MONTH                 TO WS-MONTH             
              MOVE WS-DB2-DAY                   TO WS-DAY               
              MOVE WS-DB2-YEAR                  TO WS-YEAR              
              MOVE WS-RETURN-DATE               TO RS-TRIGGER-DATE      
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-WAIVER-CURSOR                                      *          
      *                                                              *          
      *      OPEN WAIVER-CURSOR (WHICH WILL SELECT ALL THE WAIVER    *          
      *      DETAILS AVAILABLE FOR THE ACCOUNT NUMBER)               *          
      ****************************************************************          
                                                                        
       7000-OPEN-WAIVER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN WAIVER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7000'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'OPEN'             TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
CBSI          MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
CBSI          MOVE SB-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
CBSI          MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7010-FETCH-WAIVER-CURSOR                                     *          
      *                                                              *          
      *      FETCH RECORDS FROM WAIVER-CURSOR                        *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7010-FETCH-WAIVER-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH WAIVER-CURSOR                                       
               INTO :SB-WAIVER-TYPE-CD,                                 
                    :SB-CODE-STATUS,                                    
                    :SB-COMMENTS,                                       
                    :SB-CODE-STATUS-REAS,                               
                    :SB-WAIVER-SOURCE-DESC,                             
                    :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI,                
                    :SB-BOND-WAIV-ITEM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7010'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'FETCH '           TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
CBSI          MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
CBSI          MOVE SB-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
CBSI          MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7020-CLOSE-WAIVER-CURSOR                                     *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7020-CLOSE-WAIVER-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE WAIVER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7020'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'CLOSE'            TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
CBSI          MOVE SB-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-SELECT-ACCOUNT                                          *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7100-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,MST_SUB_ACCT_IND                       
                INTO :AT-CUSTOMER-NO,:AT-MST-SUB-ACCT-IND               
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7100'             TO ACTIVE-PARAGRAPH               
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_ACCOUNT'      TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
CBSI          MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-SELECT-SSNUMBER                                         *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7200-SELECT-SSNUMBER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT SSN                                                
                INTO :CE-SSN                                            
T16174          FROM CSS_CUST_STATS CE                                  
T16174         WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                   
T16174           AND CE.CUSTOMER_TYPE = 'C'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7200'             TO ACTIVE-PARAGRAPH               
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_CUST_STATS'   TO TABLE-1                        
              MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1                
CBSI          MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-2                
              MOVE CE-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1              
CBSI          MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
