       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02161.                                         
       DATE-WRITTEN.  09/20/95.                                         
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S161 CONVERTED TO DB2 SP CSR02161 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S161                                           *        
      *  PROGRAM:       S161                                           *        
      *  CALLING SP:    PA_S161                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE BILLING NAME AND           *        
      *  ADDRESS VIA A CALL TO CPD00074.                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/20/95    SAG      PROCEDURE ORIGINALLY CODED.              *        
TP4657*  06/26/96    LMB      ADD TBATMISC FOR CPD00074                *        
TP5109*  08/07/96    CSG      ADD COPYLIB CPD0023C TO USE WITH CPD00074*        
T9324 *  02/20/97    SG       ADDED SSN, DL NO & STATE FOR PANEL 015.  *        
CBSI  *  09/01/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T35434*  06/15/07   SP94986   ADDED WITH UR CHANGES TO SINGLETON SELECT*        
      *                       TO AVOID LOCKS.                                   
A04527*  06/07/13   MR7E794   REMOVED UNUSED COPYBOOK CWS00056.        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02161'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    PF - CSS_USER_PROFILE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CU - CSS_CUSTOMER                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DM - CSS_CUST_ADDR_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DZ - CSS_ADDR_FREEFORM                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    A4 - CSS_ZIP_CODE                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    TA - CSS_ACCT_MISC_INFO                                     *        
      ******************************************************************        
TP4657     EXEC SQL                                                             
TP4657         INCLUDE TBATMISC                                                 
TP4657     END-EXEC.                                                            
                                                                        
T9324 ******************************************************************        
T9324 *    CE - CSS_CUST_STATS                                         *        
T9324 ******************************************************************        
T9324      EXEC SQL                                                             
T9324          INCLUDE TBCSTSTS                                                 
T9324      END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
      * -- COBOL EQUATES FOR SYBASE OPEN SERVER FOR CICS FACILITIES             
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      * -- SUPPORT FOR CICS RPCS                                                
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      * -- ERROR HANDLING                                                       
CVT999*    COPY CWS00010.                                                       
                                                                        
                                                                        
      * -- SUPPORTS DB2 AND SQL ERROR CHECKING                                  
           COPY CWS00303.                                                       
                                                                        
      * -- USED BY CPD00074                                                     
           COPY CWS00074.                                                       
      * -- USED BY CPD00004                                                     
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                     POINTER.                            
CVT999*    05  GWL-INIT-HANDLE              POINTER.                            
CVT999*    05  GWL-RC                       PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-NR                PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-DONE              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COMM              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.                     
           05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.             
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(4) VALUE 'S161'.      
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
CVT999*    05  PARM-ID1                     PIC S9(9) COMP VALUE 1.             
           05  PARM-ACCT-NO                 PIC X(13).                  
           05  PARM-ACCT-NO-NUM             REDEFINES PARM-ACCT-NO      
                                            PIC 9(13).                  
           05  PARM-USER-ID                 PIC X(7).                   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
CVT999*    05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.             
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM              PIC S9(9) COMP.                     
CVT999*    05  WRKLEN1                      PIC S9(9) COMP.                     
CVT999*    05  WRKLEN2                      PIC S9(9) COMP.                     
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ADDR-LINE-1               PIC X(50).                  
           05  RS-ADDR-LINE-2               PIC X(50).                  
           05  RS-ADDR-LINE-3               PIC X(50).                  
           05  RS-ADDR-LINE-4               PIC X(50).                  
           05  RS-ADDR-LINE-5               PIC X(50).                  
           05  RS-ADDR-LINE-6               PIC X(50).                  
           05  RS-NAME                      PIC X(50).                  
           05  RS-SERV-ADDR                 PIC X(50).                  
           05  RS-USER-NAME                 PIC X(50).                  
           05  RS-CUSTOMER-NAME             PIC X(50) VALUE SPACES.     
           05  RS-ACCOUNT-NAME              PIC X(50) VALUE SPACES.     
T9324      05  RS-DL-NO                     PIC X(19) VALUE SPACES.     
T9324      05  RS-DL-STATE                  PIC X(02) VALUE SPACES.     
T9324      05  RS-SSN                       PIC X(09) VALUE SPACES.     
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RETURN-CODE               PIC X(11)                           
CVT999*                                     VALUE 'RETURN_CODE'.                
CVT999*    05  CN-ADDR-LINE-1               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_1'.                
CVT999*    05  CN-ADDR-LINE-2               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_2'.                
CVT999*    05  CN-ADDR-LINE-3               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_3'.                
CVT999*    05  CN-ADDR-LINE-4               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_4'.                
CVT999*    05  CN-ADDR-LINE-5               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_5'.                
CVT999*    05  CN-ADDR-LINE-6               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_6'.                
CVT999*    05  CN-NAME                      PIC X(4)                            
CVT999*                                     VALUE 'NAME'.                       
CVT999*    05  CN-SERV-ADDR                 PIC X(9)                            
CVT999*                                     VALUE 'SERV_ADDR'.                  
CVT999*    05  CN-USER-NAME                 PIC X(9)                            
CVT999*                                     VALUE 'USER_NAME'.                  
CVT999*    05  CN-CUSTOMER-NAME             PIC X(13)                           
CVT999*                                     VALUE 'CUSTOMER_NAME'.              
CVT999*    05  CN-ACCOUNT-NAME              PIC X(12)                           
CVT999*                                     VALUE 'ACCOUNT_NAME'.               
CVT999*    05  CN-SSN                       PIC X(3)                            
CVT999*                                     VALUE 'SSN'.                        
CVT999*    05  CN-DL-NO                     PIC X(5)                            
CVT999*                                     VALUE 'DL_NO'.                      
CVT999*    05  CN-DL-STATE                  PIC X(8)                            
CVT999*                                     VALUE 'DL_STATE'.                   
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8) VALUE 'S161'.      
           05  WS-USER-NAME                 PIC X(50).                  
           05  WS-DBA-NAME                  PIC X(02) VALUE 'DB'.       
           05  WS-NAME-ADDRESS-SWITCH       PIC X(01).                  
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
HPCCDM*    EJECT                                                                
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCT-NO             PIC X(13)                .          
CVT000 01  LINK-USER-ID             PIC X(7)                 .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCT-NO                                            
CVT000         ,LINK-USER-ID                                            
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9999-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-ADDR-LINE-1              AS    ADDR_LINE_1            
CVT000       ,:RS-ADDR-LINE-2              AS    ADDR_LINE_2            
CVT000       ,:RS-ADDR-LINE-3              AS    ADDR_LINE_3            
CVT000       ,:RS-ADDR-LINE-4              AS    ADDR_LINE_4            
CVT000       ,:RS-ADDR-LINE-5              AS    ADDR_LINE_5            
CVT000       ,:RS-ADDR-LINE-6              AS    ADDR_LINE_6            
CVT000       ,LTRIM(RTRIM(:RS-NAME))              AS    NAME                   
CVT000       ,:RS-SERV-ADDR                AS    SERV_ADDR              
CVT000       ,:RS-USER-NAME                AS    USER_NAME              
CVT000       ,:RS-CUSTOMER-NAME            AS    CUSTOMER_NAME          
CVT000       ,:RS-ACCOUNT-NAME             AS    ACCOUNT_NAME           
CVT000       ,:RS-SSN                      AS    SSN                    
CVT000       ,:RS-DL-NO                    AS    DL_NO                  
CVT000       ,:RS-DL-STATE                 AS    DL_STATE               
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-ADDR-LINE-1              AS    ADDR_LINE_1                    
MFA-TR*      ,:RS-ADDR-LINE-2              AS    ADDR_LINE_2                    
MFA-TR*      ,:RS-ADDR-LINE-3              AS    ADDR_LINE_3                    
MFA-TR*      ,:RS-ADDR-LINE-4              AS    ADDR_LINE_4                    
MFA-TR*      ,:RS-ADDR-LINE-5              AS    ADDR_LINE_5                    
MFA-TR*      ,:RS-ADDR-LINE-6              AS    ADDR_LINE_6                    
MFA-TR*      ,STRIP(:RS-NAME)              AS    NAME                           
MFA-TR*      ,:RS-SERV-ADDR                AS    SERV_ADDR                      
MFA-TR*      ,:RS-USER-NAME                AS    USER_NAME                      
MFA-TR*      ,:RS-CUSTOMER-NAME            AS    CUSTOMER_NAME                  
MFA-TR*      ,:RS-ACCOUNT-NAME             AS    ACCOUNT_NAME                   
MFA-TR*      ,:RS-SSN                      AS    SSN                            
MFA-TR*      ,:RS-DL-NO                    AS    DL_NO                          
MFA-TR*      ,:RS-DL-STATE                 AS    DL_STATE                       
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCT-NO              TO PARM-ACCT-NO             . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-ACCT-NO     TO MAX-LENGTH-PARM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCT-NO,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
           MOVE PARM-ACCT-NO-NUM TO AT-ACCOUNT-NO.                      
                                                                        
CVT999*    ADD  1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-USER-ID     TO MAX-LENGTH-PARM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USER-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-1 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-1 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-1,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-1,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-2 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-2 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-2,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-2,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-3 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-3 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-3,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-3,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-4 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-4 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-4,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-4,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-5 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-5 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-5,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-5,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-6 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-6 TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-6,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-6,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-NAME TO WRKLEN1.                                   
CVT999*    MOVE LENGTH OF CN-NAME TO WRKLEN2.                                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NAME,                                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-NAME,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-SERV-ADDR TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-SERV-ADDR TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-SERV-ADDR,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-USER-NAME TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-USER-NAME TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-USER-NAME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-USER-NAME,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CUSTOMER-NAME TO WRKLEN1.                          
CVT999*    MOVE LENGTH OF CN-CUSTOMER-NAME TO WRKLEN2.                          
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUSTOMER-NAME,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CUSTOMER-NAME,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NAME TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CN-ACCOUNT-NAME TO WRKLEN2.                           
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NAME,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ACCOUNT-NAME,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-SSN TO WRKLEN1.                                    
CVT999*    MOVE LENGTH OF CN-SSN TO WRKLEN2.                                    
T9324                                                                   
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SSN,                                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-SSN,                                        
CVT999*                          WRKLEN2.                                       
T9324                                                                   
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
T9324                                                                   
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-DL-NO TO WRKLEN1.                                  
CVT999*    MOVE LENGTH OF CN-DL-NO TO WRKLEN2.                                  
T9324                                                                   
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DL-NO,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-DL-NO,                                      
CVT999*                          WRKLEN2.                                       
T9324                                                                   
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
T9324                                                                   
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-DL-STATE TO WRKLEN1.                               
CVT999*    MOVE LENGTH OF CN-DL-STATE TO WRKLEN2.                               
T9324                                                                   
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DL-STATE,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-DL-STATE,                                   
CVT999*                          WRKLEN2.                                       
T9324                                                                   
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
T9324                                                                   
           PERFORM 7000-SELECT-ACCOUNT                  THRU 7000-EXIT. 
T9324      PERFORM 7050-SELECT-CUST-STATS               THRU 7050-EXIT. 
                                                                        
T9324      MOVE CE-SSN                TO RS-SSN.                        
T9324      MOVE CE-DRIVERS-LICENSE-NO TO RS-DL-NO.                      
T9324      MOVE CE-CODE-STATE-ID      TO RS-DL-STATE.                   
           MOVE PARM-USER-ID          TO PF-USER-ID.                    
           PERFORM 7100-SELECT-USER                     THRU 7100-EXIT. 
                                                                        
           PERFORM 4000-MAIL-NAME-ADDRESS               THRU 4000-EXIT. 
           MOVE WS-NAME-ADDR-LINE (1) TO RS-ADDR-LINE-1.                
           MOVE WS-NAME-ADDR-LINE (2) TO RS-ADDR-LINE-2.                
           MOVE WS-NAME-ADDR-LINE (3) TO RS-ADDR-LINE-3.                
           MOVE WS-NAME-ADDR-LINE (4) TO RS-ADDR-LINE-4.                
           MOVE WS-NAME-ADDR-LINE (5) TO RS-ADDR-LINE-5.                
           MOVE WS-NAME-ADDR-LINE (6) TO RS-ADDR-LINE-6.                
           MOVE WS-SALUTATION-NAME    TO RS-NAME.                       
           MOVE WS-PREMISE-ADDR       TO RS-SERV-ADDR.                  
           MOVE WS-USER-NAME          TO RS-USER-NAME.                  
           MOVE WS-CUSTOMER-NAME      TO RS-CUSTOMER-NAME.              
           SET WS-NM-ADDR-INDX        TO 1.                             
           SEARCH WS-NAME-ADDR-ENTRY                                    
               AT END                                                   
                   MOVE WS-N          TO WS-NAME-ADDRESS-SWITCH         
                   MOVE SPACES        TO RS-ACCOUNT-NAME                
               WHEN WS-NAME-ADDR-TYPE(WS-NM-ADDR-INDX) = WS-DBA-NAME    
                   MOVE WS-NAME-ADDR-LINE(WS-NM-ADDR-INDX)              
                       TO RS-ACCOUNT-NAME                               
                   MOVE WS-Y          TO WS-NAME-ADDRESS-SWITCH.        
                                                                        
           PERFORM 8100-SEND-RESULT                     THRU 8100-EXIT. 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *                                                                *        
      *     RETRIEVE NEEDED DATA FROM ACCOUNT BEFORE CALL TO CPD00074. *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      ADDRESS_FORMAT,                                   
T9324                 CUSTOMER_NO                                       
                 INTO :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
T9324                 :AT-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*          INTO :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
CBSI           MOVE SPACES                 TO ABEND-SQL-PREDICATES      
CBSI                                          ABEND-TABLES              
               MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
T9324 ******************************************************************        
T9324 * 7050-SELECT-CUST-STATS                                         *        
T9324 *                                                                *        
T9324 *     RETRIEVE NEEDED DATA FROM CUST_STATS.                      *        
T9324 *                                                                *        
T9324 ******************************************************************        
T9324                                                                   
T9324  7050-SELECT-CUST-STATS.                                          
T9324                                                                   
T9324      EXEC SQL                                                     
T9324          SELECT SSN,                                              
T9324                 DRIVERS_LICENSE_NO,                               
T9324                 CODE_STATE_ID                                     
T9324            INTO :CE-SSN,                                          
T9324                 :CE-DRIVERS-LICENSE-NO,                           
T9324                 :CE-CODE-STATE-ID                                 
T9324            FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
T9324           WHERE CUSTOMER_NO   = :AT-CUSTOMER-NO                   
T9324             AND CUSTOMER_TYPE = 'C'                               
T35434                                                           
T9324      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN,                                                      
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               CODE_STATE_ID                                             
MFA-TR*          INTO :CE-SSN,                                                  
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-CODE-STATE-ID                                         
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO   = :AT-CUSTOMER-NO                           
MFA-TR*           AND CUSTOMER_TYPE = 'C'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T9324                                                                   
T9324      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T9324                                                                   
T9324      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T9324          NEXT SENTENCE                                            
T9324      ELSE                                                         
T9324          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T9324              MOVE SPACES TO CE-SSN                                
T9324                             CE-DRIVERS-LICENSE-NO                 
T9324                             CE-CODE-STATE-ID                      
T9324          ELSE                                                     
T9324              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                 
T9324              MOVE '7050'         TO ACTIVE-PARAGRAPH              
T9324              MOVE 'SELECT'       TO ABEND-FUNCTION                
CBSI               MOVE SPACES         TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
T9324              MOVE 'CSS_CUST_STATS' TO TABLE-1                     
T9324              MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
CBSI               MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-2             
T9324              MOVE AT-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
CBSI               MOVE PARM-ACCT-NO     TO HOSTVAR-ELEMENT-2           
T9324              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT      
T9324              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT      
T9324          END-IF                                                   
T9324      END-IF.                                                      
T9324                                                                   
T9324  7050-EXIT.                                                       
T9324      EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7100-SELECT-USER                                               *        
      *                                                                *        
      *     RETRIEVE NEEDED DATA FROM ACCOUNT BEFORE CALL TO CPD00074. *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-SELECT-USER.                                                
                                                                        
           EXEC SQL                                                     
               SELECT FIRST_NAME,                                       
                      LAST_NAME,                                        
                      MIDDLE_NAME                                       
                 INTO :PF-FIRST-NAME,                                   
                      :PF-LAST-NAME,                                    
                      :PF-MIDDLE-NAME                                   
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FIRST_NAME,                                               
MFA-TR*               LAST_NAME,                                                
MFA-TR*               MIDDLE_NAME                                               
MFA-TR*          INTO :PF-FIRST-NAME,                                           
MFA-TR*               :PF-LAST-NAME,                                            
MFA-TR*               :PF-MIDDLE-NAME                                           
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE SPACES TO WS-EMB-INPUT                              
               MOVE 50     TO WS-EMB-LENG                               
               STRING PF-FIRST-NAME DELIMITED SIZE                      
                      ' ' DELIMITED SIZE                                
                      PF-MIDDLE-NAME DELIMITED SIZE                     
                      ' ' DELIMITED SIZE                                
                      PF-LAST-NAME DELIMITED SIZE                       
                 INTO WS-EMB-INPUT                                      
               PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6010-EXIT  
               MOVE WS-CMP-TABLE TO WS-USER-NAME                        
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
CBSI           MOVE SPACES                 TO ABEND-SQL-PREDICATES      
CBSI                                          ABEND-TABLES              
               MOVE 'CSS_USER_PROFILE'     TO TABLE-1                   
               MOVE 'USER_ID'              TO TABLE-ELEMENT-1           
CBSI           MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-2           
               MOVE PF-USER-ID             TO HOSTVAR-ELEMENT-1         
CBSI           MOVE PARM-ACCT-NO           TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 4000-MAIL-NAME-ADDRESS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00074                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
       9900-ABEND.                                                      
       99XX-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
TP5109* 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
TP5109 COPY CPD0023C.                                                           
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
