       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02159.                                          
COB303 DATE-WRITTEN.         JUNE 18,2005.                              
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC)    *        
      *                                                                *        
      *  TRANID:        S159                                           *        
      *  PROGRAM:       S159                                           *        
      *  CALLING SP:    PA_S159                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN  WINDOW OF       *        
      *  PANEL251 WHICH INVOLVES TABLES DP, AR, IH, DO, RN, B1,        *        
      *  AU, PF.                                                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------        *        
      *  10/5/95     PP       CODED THIS RPC.                          *        
      *  07/18/96    SR       PCR#052.                                 *        
PCR482*  01/28/97    MAD      ADDED A NUMBER OF NEW COLUMNS            *        
      *                        AND RESTRUCTURED CALCULATIONS IN        *        
      *                        THE REFUND DETAILS DATAWINDOW.          *        
PCR482*  03/19/97    MAD      COMPLETION OF PCR - DCR IMPLEMENT-       *        
      *                        ATION FOR FIELD ACCT_NO_CREDITED        *        
      *                        ON CSS_REFUND.                          *        
T10265*  04/09/97    MAD      FIXED CONCATENATION OF APPROVED BY       *        
      *                        AND REQUESTED BY NAMES BEING            *        
      *                        RETURNED TO THE PANEL.                  *        
T11234*  05/15/97    MAD      CHANGED AR-HIST-CURSOR TO RETURN         *        
      *                        BILL IMMEDIATE DEPOSITS IN THE          *        
      *                        BILL HISTORY DATAWINDOW.                *        
T12274*  07/23/97    MAD      MADE MODIFICATIONS TO PREVENT THE        *        
      *                        RETURN OF REFUND TRANSACTIONS IN        *        
      *                        THE BILL HISTORY DATAWINDOW.            *        
CBSI  *  01/06/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL        *        
CBSI  *              MADRAS   THE ABEND PARAMETERS                     *        
      *  04/05/01   CHANELLE  MCR310 PSNC.  CSS_GL_ACCT_NO             *        
      *                       CHANGES.                                 *        
C26296*  04/25/2005 SS82048   CHANGES TO RETRIEVE BILL HIST            *        
      *                       FOR IMMED BILL DEPOSITS FROM             *        
      *                       CSS_DEP_ON_HAND AS APPL PGM ID           *        
      *                       PANEL141C WILL NOT BE USED AFTER         *        
      *                       CML 26296 AUTOMATE DEPOSITS IS IN        *        
      *                       PROD.                                    *        
REARCH*  06/07/05   CVNS      RPC TO COBOL DB2 CONVERSION              *        
REARCH*             CHENNAI                                            *        
C32206*  07/21/06   LG41184   INCREASED THE WIDTH FOR FIELD            *        
C32206*                       CHECK-ISS-REAS-CD TO 2.                  *        
C37304*  06/05/08   MJ13662   DELETED REFERENCE TO CSS_1099_HIST       *        
A01601*  08/19/09   VV94890   INITIALIZED COMMENTS FIELD.              *        
P00394*  09/08/10   AA97148   FIXED ISSUES WITH REFUND HIST DW         *        
A04527*  06/07/13   MR7E794   REMOVED UNUSED COPYBOOK CWS00056.        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02159'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START           PIC X(40) VALUE                           
REARCH          'WORKING STORAGE FOR CSR02159 STARTS HERE'.             
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DEP_ON_HAND - DO                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPHND                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_INTEREST_HIST - IH                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DEP_PAY_HST - DP                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REFUND - RN                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_AR_TRANS_HIST - AR                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_AR_TRN_HST_DET - AU                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBARHDT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GL_ACCT_NO - GO                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGLATNO                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_USER_PROFILE - PF                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUSRPRF                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_LOCAL_OFFICE - B1                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLOCOFC                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_PREMISE - PR                                               *        
      ******************************************************************        
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482          INCLUDE TBPREM                                                  
PCR482     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REV_DISTRICT - A9                                          *        
      ******************************************************************        
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482          INCLUDE TBRVDST                                                 
PCR482     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DEP_REQ - DR                                            *        
      ******************************************************************        
      *                                                                         
C26296     EXEC SQL                                                             
C26296          INCLUDE TBDEPREQ                                                
C26296     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * COMMON SYSTEM AREA                                             *        
      ******************************************************************        
      *                                                                         
           COPY CCA00001.                                                       
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                 *        
      ******************************************************************        
      *                                                                         
           COPY CWS00027.                                                       
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-FETCH-RETCODE      PIC S9(9) COMP VALUE 0.             
           05 WS-AR-NOT-FOUND-FLAG PIC X(01) VALUE 'N'.                 
           88 WS-AR-NOT-FOUND VALUE 'Y'.                                
           05 WS-IH-NOT-FOUND-FLAG PIC X(01) VALUE 'N'.                 
           88 WS-IH-NOT-FOUND VALUE 'Y'.                                
           05 WS-DP-NOT-FOUND-FLAG PIC X(01) VALUE 'N'.                 
           88 WS-DP-NOT-FOUND VALUE 'Y'.                                
           05 WS-RN-NOT-FOUND-FLAG PIC X(01) VALUE 'N'.                 
           88 WS-RN-NOT-FOUND VALUE 'Y'.                                
           05 WS-NULL-IND1         PIC S9(04) COMP.                     
           05 WS-NULL-IND2         PIC S9(04) COMP.                     
           05 WS-NULL-DUMMY-IND    PIC S9(04) COMP.                     
REARCH     05 PROGRAM-NAME         PIC X(8)  VALUE 'CSR02159'.          
REARCH     05 WS-SQLSTATE          PIC X(5).                            
COB305     05 WS-GL-AR-DEP        PIC S9(4)V9(4) COMP-3 VALUE 0.               
CBSI       05 WS-GL-AR-DEP-ED      PIC -(4)9.9(4).                      
           05 WS-DATE-REFUNDED     PIC X(10) VALUE SPACES.              
           05 WS-DATE-REFUND       PIC X(10) VALUE SPACES.              
           05 WS-DATE-TRANS        PIC X(10) VALUE SPACES.              
           05 WS-DEP-PAY-DT        PIC X(10) VALUE SPACES.              
           05 WS-INT-CREDIT-DT     PIC X(10) VALUE SPACES.              
           05 WS-EFFECTIVE-DT      PIC X(10) VALUE SPACES.              
PCR482     05 WS-ORIG-DEP-AMT      PIC S9(9)V9(2)  COMP-3  VALUE 0.     
PCR482     05 WS-INTEREST-AMT-HOLD PIC S9(9)V9(2)  COMP-3  VALUE 0.     
PCR482     05 WS-DEP-AMT-REFUNDED  PIC S9(9)V9(2)  COMP-3  VALUE 0.     
PCR482     05 WS-TRANS-INP-FIELD   PIC X(13) VALUE SPACES.              
PCR482     05 WS-DEP-CERT-INP-FIELD                                     
PCR482                             PIC X(09) VALUE SPACES.              
PCR482     05 WS-COUNT             PIC S9(04)      COMP    VALUE 0.     
PCR482     05 WS-INPUT-ID          PIC X(01) VALUE SPACES.              
                                                                        
PCR482     05 WS-POSITIVE-FOUND-SW PIC X(01) VALUE 'N'.                 
PCR482        88 POSITIVE-NUM-IS-FOUND       VALUE 'Y'.                 
                                                                        
PCR482     05 WS-TRANSFERRED-TO    PIC S9(13)V     COMP-3  VALUE 0.     
PCR482     05 WS-TRANS-TO-REDEF    PIC 9(13).                           
PCR482     05 WS-TRANS-TO-RED REDEFINES WS-TRANS-TO-REDEF.              
PCR482        10 WS-TRANSFER-TO-RED    PIC X(13).                       
                                                                        
PCR482     05 WS-DEP-CERT-NO-TO    PIC S9(9)       COMP    VALUE 0.     
PCR482     05 WS-DEP-CERT-TO-REDEF PIC 9(9).                            
PCR482     05 WS-CERT-NO-TO-RED REDEFINES WS-DEP-CERT-TO-REDEF.         
PCR482        10 WS-DEPOSIT-TO-RED     PIC X(09).                       
                                                                        
PCR482     05 WS-TRANSFERRED-FROM  PIC S9(13)V     COMP-3  VALUE 0.     
PCR482     05 WS-TRANS-FROM-REDEF  PIC 9(13).                           
PCR482     05 WS-TRANS-FROM-RED REDEFINES WS-TRANS-FROM-REDEF.          
PCR482        10 WS-TRANSFER-FROM-RED  PIC X(13).                       
                                                                        
PCR482     05 WS-DEP-CERT-NO-FROM  PIC S9(9)       COMP    VALUE 0.     
PCR482     05 WS-DEP-CERT-FROM-REDEF PIC 9(9).                          
PCR482     05 WS-CERT-NO-FROM-RED REDEFINES WS-DEP-CERT-FROM-REDEF.     
PCR482        10 WS-DEPOSIT-FROM-RED   PIC X(09).                       
                                                                        
PCR482     05 WS-ACCT-NO-CREDITED  PIC S9(13)V     COMP-3  VALUE 0.     
PCR482     05 WS-ACCT-NO-CRD-REDEF PIC 9(13).                           
PCR482     05 WS-ACCT-NO-CRD-RED REDEFINES WS-ACCT-NO-CRD-REDEF.        
PCR482        10 WS-ACCT-NO-CREDIT-RED PIC X(13).                       
                                                                        
PCR482     05 WS-HOLD-REV-DIST         PIC X(03).                       
PCR482     05 WS-HOLD-ID-INPUT         PIC X(07).                       
PCR482     05 WS-HOLD-NAME-OUTPUT      PIC X(29).                       
PCR482     05 WS-SUB                   PIC S9(8) COMP VALUE ZERO.       
PCR482     05 CN-DELIMITER             PIC X VALUE ';'.                 
PCR482     05 WS-FROM.                                                  
PCR482        10 WS-FROM-X                OCCURS 51 TIMES PIC X.        
C26296     05 WS-USA-DATE.                                              
C26296        10  WS-USA-DATE-MM       PIC X(02) VALUE SPACES.          
C26296        10  FILLER               PIC X(01) VALUE '/'.             
C26296        10  WS-USA-DATE-DD       PIC X(02) VALUE SPACES.          
C26296        10  FILLER               PIC X(01) VALUE '/'.             
C26296        10  WS-USA-DATE-CCYY     PIC X(04) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW       PIC X(01) VALUE 'N'.                    
               88 NOT-ALL-DONE            VALUE 'N'.                    
               88 ALL-DONE                VALUE 'Y'.                    
           05 SEND-DONE-SW      PIC X(01) VALUE 'Y'.                    
               88 SEND-DONE-ERROR         VALUE 'N'.                    
               88 SEND-DONE-OK            VALUE 'Y'.                    
PCR482     05 WS-NUM-TIMES-THRU PIC X(01) VALUE 'Y'.                    
PCR482         88 FIRST-TIME-THRU         VALUE 'Y'.                    
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02159_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05 SNA-SUBC          PIC S9(9) COMP.                         
           05 SNA-CONNECTION-NAME PIC X(8) VALUE SPACES.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN        PIC S9(9) COMP VALUE 1.                 
           05 CTR-ROWS          PIC S9(9) COMP VALUE 0.                 
           05 WS-ROW-COUNT      PIC S9(9) COMP VALUE 0.                 
                                                                        
       01  WORK-FIELDS.                                                 
           05 MAX-LENGTH-PARM   PIC S9(9) COMP.                         
           05 WRKLEN1           PIC S9(9) COMP.                         
           05 WRKLEN2           PIC S9(9) COMP.                         
           05 WRK-DONE-STATUS   PIC S9(9) COMP.                         
                                                                        
                                                                        
       01  FILLER PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA'.        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05 RS-DEPOSIT-CERT-NO      PIC S9(9) COMP VALUE 0.           
PCR482     05 RS-ORIG-DEP-AMT         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-AMT-REFUNDED         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
PCR482     05 RS-TRANSFER-AMT         PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-AMT-DEPOSIT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-TRANSFERRED-TO       PIC X(13).                        
           05 RS-DEP-CERT-NO-TO       PIC X(09).                        
           05 RS-TRANSFERRED-FROM     PIC X(13).                        
           05 RS-DEP-CERT-NO-FROM     PIC X(09).                        
           05 RS-SERVICE-TYPE-CD      PIC X(1)  VALUE SPACES.           
           05 RS-REPEAT-COUNT         PIC S9(4) COMP VALUE 1.           
           05 RS-DATE-TRANS           PIC X(10) VALUE SPACES.           
           05 RS-AMT-POSTED           PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-DEP-PAY-DT           PIC X(10) VALUE SPACES.           
           05 RS-DEP-PAY-AMT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-INT-CREDIT-DT        PIC X(10) VALUE SPACES.           
           05 RS-INTEREST-AMT         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-INTEREST-RT          PIC S9(3)V9(4)  COMP-3 VALUE 0.   
           05 RS-EFFECTIVE-DT         PIC X(10) VALUE SPACES.           
PCR482     05 RS-REV-DISTRICT-DESC    PIC X(35) VALUE SPACES.           
           05 RS-DATE-REFUND          PIC X(10) VALUE SPACES.           
           05 RS-MANUAL-INDICATOR     PIC X(01) VALUE SPACES.           
PCR482     05 RS-DEP-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
PCR482     05 RS-INT-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
PCR482     05 RS-TOT-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
C32206     05 RS-CHECK-ISS-REAS-CD    PIC X(02) VALUE SPACES.           
           05 RS-CHECK-STATUS-CD      PIC X(01) VALUE SPACES.           
           05 RS-USER-NAME-RQSTED-BY  PIC X(29) VALUE SPACES.           
           05 RS-USER-NAME-APPRVD-BY  PIC X(29) VALUE SPACES.           
PCR482     05 RS-ACCT-NO-CREDITED     PIC X(13) VALUE SPACES.           
T12003     05 RS-COMMENTS             PIC X(72) VALUE SPACES.           
PCR482     05 RS-DEPOSIT-STATUS-CD    PIC X(01) VALUE SPACES.           
           05 RS-DATE-TRAN            PIC X(10) VALUE SPACES.           
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05 S-RETURN-CODE           PIC S9(9) COMP VALUE 0.           
REARCH     05 S-DEPOSIT-CERT-NO       PIC S9(9) COMP VALUE 0.           
REARCH     05 S-ORIG-DEP-AMT          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-AMT-REFUNDED          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-TRANSFER-AMT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-AMT-DEPOSIT           PIC S9(7)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-TRANSFERRED-TO        PIC X(13).                        
REARCH     05 S-DEP-CERT-NO-TO        PIC X(09).                        
REARCH     05 S-TRANSFERRED-FROM      PIC X(13).                        
REARCH     05 S-DEP-CERT-NO-FROM      PIC X(09).                        
REARCH     05 S-SERVICE-TYPE-CD       PIC X(1)  VALUE SPACES.           
REARCH     05 S-REPEAT-COUNT          PIC S9(4) COMP VALUE 1.           
REARCH     05 S-DATE-TRANS            PIC X(10) VALUE SPACES.           
REARCH     05 S-AMT-POSTED            PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-DEP-PAY-DT            PIC X(10) VALUE SPACES.           
REARCH     05 S-DEP-PAY-AMT           PIC S9(7)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-INT-CREDIT-DT         PIC X(10) VALUE SPACES.           
REARCH     05 S-INTEREST-AMT          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-INTEREST-RT           PIC S9(3)V9(4)  COMP-3 VALUE 0.   
REARCH     05 S-EFFECTIVE-DT          PIC X(10) VALUE SPACES.           
REARCH     05 S-REV-DISTRICT-DESC     PIC X(35) VALUE SPACES.           
REARCH     05 S-DATE-REFUND           PIC X(10) VALUE SPACES.           
REARCH     05 S-MANUAL-INDICATOR      PIC X(01) VALUE SPACES.           
REARCH     05 S-DEP-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-INT-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
REARCH     05 S-TOT-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
C32206     05 S-CHECK-ISS-REAS-CD     PIC X(02) VALUE SPACES.           
REARCH     05 S-CHECK-STATUS-CD       PIC X(01) VALUE SPACES.           
REARCH     05 S-USER-NAME-RQSTED-BY   PIC X(29) VALUE SPACES.           
REARCH     05 S-USER-NAME-APPRVD-BY   PIC X(29) VALUE SPACES.           
REARCH     05 S-ACCT-NO-CREDITED      PIC X(13) VALUE SPACES.           
REARCH     05 S-COMMENTS              PIC X(72) VALUE SPACES.           
REARCH     05 S-DEPOSIT-STATUS-CD     PIC X(01) VALUE SPACES.           
REARCH     05 S-DATE-TRAN             PIC X(10) VALUE SPACES.           
      *                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH                                                                  
      *                                                                         
      ********************************************************************      
      * CURSOR DECLARATIONS                                            * *      
      ********************************************************************      
      *                                                                         
           EXEC SQL                                                     
           DECLARE DO-CURSOR CURSOR FOR                                 
             SELECT DEPOSIT_CERT_NO,                                    
                 AMT_REFUNDED,                                          
                 SERVICE_TYPE_CD,                                       
                 AMT_DEPOSIT,                                           
                 TOTAL_INTRST,                                          
                 CODE_REFUND_TYPE,                                      
                 CODE_REFUND_REASON,                                    
                 CIS.CHAR2$DATE(DATE_REFUNDED,'USA'),                           
                 DATE_TRAN,                                             
                 TRANSFERRED_TO,                                        
                 DEP_CERT_NO_TO,                                        
                 TRANSFERRED_FROM,                                      
                 DEP_CERT_NO_FROM,                                      
PCR482           TRANSFER_AMT,                                          
PCR482           DEPOSIT_STATUS_CD                                      
              FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                        
             WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                          
P00394         FOR READ ONLY                                    
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DO-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT DEPOSIT_CERT_NO,                                            
MFA-TR*          AMT_REFUNDED,                                                  
MFA-TR*          SERVICE_TYPE_CD,                                               
MFA-TR*          AMT_DEPOSIT,                                                   
MFA-TR*          TOTAL_INTRST,                                                  
MFA-TR*          CODE_REFUND_TYPE,                                              
MFA-TR*          CODE_REFUND_REASON,                                            
MFA-TR*          CHAR(DATE_REFUNDED,USA),                                       
MFA-TR*          DATE_TRAN,                                                     
MFA-TR*          TRANSFERRED_TO,                                                
MFA-TR*          DEP_CERT_NO_TO,                                                
MFA-TR*          TRANSFERRED_FROM,                                              
MFA-TR*          DEP_CERT_NO_FROM,                                              
MFA-TR*          TRANSFER_AMT,                                                  
MFA-TR*          DEPOSIT_STATUS_CD                                              
MFA-TR*       FROM CSS_DEP_ON_HAND                                              
MFA-TR*      WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                                  
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 **      
           EXEC SQL                                                     
           DECLARE RN-CURSOR  CURSOR FOR                                
PCR052       SELECT REFUND_ITEM_ID,                                     
PCR052           REFUND_CHECK_NO,                                       
PCR052           AMT_REFUNDED,                                          
PCR052           CIS.CHAR2$DATE(DATE_REFUNDED,'USA'),                           
PCR052           CHECK_ISS_REAS_CD,                                     
PCR052           PANEL_NO,                                              
                 USER_ID_APPRVD_BY,                                     
                 USER_ID_RQSTED_BY,                                     
PCR052           CHECK_STATUS_CD,                                       
PCR052           MANUAL_INDICATOR,                                      
PCR482           ACCT_NO_CREDITED,                                      
T12003           COMMENTS                                               
             FROM CSS_REFUND WITH(READUNCOMMITTED)                              
             WHERE ACCOUNT_NO      = :RN-ACCOUNT-NO                     
             AND   DEPOSIT_CERT_NO = :RN-DEPOSIT-CERT-NO                
             ORDER BY REFUND_ITEM_ID DESC                               
P00394         FOR READ ONLY                                    
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE RN-CURSOR  CURSOR FOR                                        
MFA-TR*      SELECT REFUND_ITEM_ID,                                             
MFA-TR*          REFUND_CHECK_NO,                                               
MFA-TR*          AMT_REFUNDED,                                                  
MFA-TR*          CHAR(DATE_REFUNDED,USA),                                       
MFA-TR*          CHECK_ISS_REAS_CD,                                             
MFA-TR*          PANEL_NO,                                                      
MFA-TR*          USER_ID_APPRVD_BY,                                             
MFA-TR*          USER_ID_RQSTED_BY,                                             
MFA-TR*          CHECK_STATUS_CD,                                               
MFA-TR*          MANUAL_INDICATOR,                                              
MFA-TR*          ACCT_NO_CREDITED,                                              
MFA-TR*          COMMENTS                                                       
MFA-TR*      FROM CSS_REFUND                                                    
MFA-TR*      WHERE ACCOUNT_NO      = :RN-ACCOUNT-NO                             
MFA-TR*      AND   DEPOSIT_CERT_NO = :RN-DEPOSIT-CERT-NO                        
MFA-TR*      ORDER BY REFUND_ITEM_ID DESC                                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7165                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 **      
           EXEC SQL                                                     
           DECLARE AR-CURSOR CURSOR FOR                                 
           SELECT CIS.CHAR2$DATE(A.DATE_TRANS,'USA'),                           
                  A.DATE_TRANS,                                         
                  B.AMT_POSTED                                          
             FROM CSS_AR_TRANS_HIST A WITH(READUNCOMMITTED),                    
                         CSS_AR_TRN_HST_DET B WITH(READUNCOMMITTED)             
               WHERE A.ACCOUNT_NO = :AR-ACCOUNT-NO                      
               AND A.ACCOUNT_NO = B.ACCOUNT_NO                          
               AND B.ITEM_ID = :DO-DEPOSIT-CERT-NO                      
               AND B.GL_ACCT_DEBIT = :WS-GL-AR-DEP                      
T12274         AND B.CODE_AR_AGE <> 'P'                                 
               AND B.TRANS_HIST_SEQ_NO = A.TRANS_HIST_SEQ_NO            
C26296         AND A.CODE_TRAN_TYPE = 'B'                               
               ORDER BY A.DATE_TRANS DESC                               
P00394         FOR READ ONLY                                    
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE AR-CURSOR CURSOR FOR                                         
MFA-TR*    SELECT CHAR(A.DATE_TRANS,USA),                                       
MFA-TR*           A.DATE_TRANS,                                                 
MFA-TR*           B.AMT_POSTED                                                  
MFA-TR*      FROM CSS_AR_TRANS_HIST A,                                          
MFA-TR*                  CSS_AR_TRN_HST_DET B                                   
MFA-TR*        WHERE A.ACCOUNT_NO = :AR-ACCOUNT-NO                              
MFA-TR*        AND A.ACCOUNT_NO = B.ACCOUNT_NO                                  
MFA-TR*        AND B.ITEM_ID = :DO-DEPOSIT-CERT-NO                              
MFA-TR*        AND B.GL_ACCT_DEBIT = :WS-GL-AR-DEP                              
MFA-TR*        AND B.CODE_AR_AGE <> 'P'                                         
MFA-TR*        AND B.TRANS_HIST_SEQ_NO = A.TRANS_HIST_SEQ_NO                    
MFA-TR*        AND A.CODE_TRAN_TYPE = 'B'                                       
MFA-TR*        ORDER BY A.DATE_TRANS DESC                                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7170                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 **      
           EXEC SQL                                                     
           DECLARE DP-CURSOR CURSOR FOR                                 
             SELECT CIS.CHAR2$DATE(DEP_PAY_DT,'USA'),                           
             DEP_PAY_DT, DEP_PAY_AMT                                    
             FROM CSS_DEP_PAY_HST WITH(READUNCOMMITTED)                         
             WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                          
             AND   DEPOSIT_CERT_NO =:DP-DEPOSIT-CERT-NO                 
             ORDER BY DEP_PAY_DT DESC                                   
P00394         FOR READ ONLY                                    
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DP-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT CHAR(DEP_PAY_DT,USA),                                       
MFA-TR*      DEP_PAY_DT, DEP_PAY_AMT                                            
MFA-TR*      FROM CSS_DEP_PAY_HST                                               
MFA-TR*      WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                                  
MFA-TR*      AND   DEPOSIT_CERT_NO =:DP-DEPOSIT-CERT-NO                         
MFA-TR*      ORDER BY DEP_PAY_DT DESC                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7220                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 **      
           EXEC SQL                                                     
           DECLARE IH-CURSOR CURSOR FOR                                 
             SELECT CIS.CHAR2$DATE(INT_CREDIT_DT,'USA'),                        
                           INT_CREDIT_DT,                               
                           INTEREST_AMT,                                
                           INTEREST_RT,                                 
                           CIS.CHAR2$DATE(EFFECTIVE_DT,'USA'),                  
                           EFFECTIVE_DT,                                
PCR482                     REV_DISTRICT_CD                              
             FROM CSS_INTEREST_HIST A WITH(READUNCOMMITTED),                    
PCR482       CSS_PREMISE B WITH(READUNCOMMITTED), CSS_ACCOUNT C
                           WITH(READUNCOMMITTED)                               
             WHERE A.ACCOUNT_NO = :IH-ACCOUNT-NO                        
             AND A.DEPOSIT_CERT_NO =:IH-DEPOSIT-CERT-NO                 
             AND A.ACCOUNT_NO = C.ACCOUNT_NO                            
             AND C.PREMISE_NO = B.PREMISE_NO                            
             ORDER BY INT_CREDIT_DT DESC                                
P00394         FOR READ ONLY                                    
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE IH-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT CHAR(INT_CREDIT_DT,USA),                                    
MFA-TR*                    INT_CREDIT_DT,                                       
MFA-TR*                    INTEREST_AMT,                                        
MFA-TR*                    INTEREST_RT,                                         
MFA-TR*                    CHAR(EFFECTIVE_DT,USA),                              
MFA-TR*                    EFFECTIVE_DT,                                        
MFA-TR*                    REV_DISTRICT_CD                                      
MFA-TR*      FROM CSS_INTEREST_HIST A,                                          
MFA-TR*      CSS_PREMISE B, CSS_ACCOUNT C                                       
MFA-TR*      WHERE A.ACCOUNT_NO = :IH-ACCOUNT-NO                                
MFA-TR*      AND A.DEPOSIT_CERT_NO =:IH-DEPOSIT-CERT-NO                         
MFA-TR*      AND A.ACCOUNT_NO = C.ACCOUNT_NO                                    
MFA-TR*      AND C.PREMISE_NO = B.PREMISE_NO                                    
MFA-TR*      ORDER BY INT_CREDIT_DT DESC                                        
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7200                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR02159 ENDS HERE  '.            
      *                                                                         
REARCH LINKAGE SECTION.                                                 
      *                                                                         
REARCH 01  PARM-ACCOUNT-NO          PIC  X(13).                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ********************************************************************      
      * 0000-MAINLINE                                                  * *      
      ********************************************************************      
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************************      
      * 0100-INITIALIZE                                                * *      
      ********************************************************************      
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           PERFORM 0110-INIT-DO-RS THRU 0110-EXIT.                      
           PERFORM 0130-INIT-AR-AU-RS THRU 0130-EXIT.                   
           PERFORM 0140-INIT-DP-RS THRU 0140-EXIT.                      
           PERFORM 0150-INIT-IH-RS THRU 0150-EXIT.                      
      *                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH              RETURN_CODE               AS RETURN_CODE            
REARCH             ,DEPOSIT_CERT_NO           AS DEPOSIT_CERT_NO        
REARCH             ,ORIG_DEP_AMT              AS ORIG_DEP_AMT           
REARCH             ,AMT_REFUNDED              AS AMT_REFUNDED           
REARCH             ,TRANSFER_AMT              AS TRANSFER_AMT           
REARCH             ,AMT_DEPOSIT               AS AMT_DEPOSIT            
REARCH             ,LTRIM(RTRIM(TRANSFERRED_TO))     AS TRANSFERRED_TO         
REARCH             ,LTRIM(RTRIM(DEP_CERT_NO_TO))     AS DEP_CERT_NO_TO         
REARCH             ,LTRIM(RTRIM(TRANSFERRED_FROM))   AS TRANSFERRED_FROM       
REARCH             ,LTRIM(RTRIM(DEP_CERT_NO_FROM))   AS DEP_CERT_NO_FROM       
REARCH             ,SERVICE_TYPE_CD           AS SERVICE_TYPE_CD        
REARCH             ,REPEAT_COUNT              AS REPEAT_COUNT           
REARCH             ,LTRIM(RTRIM(DATE_TRANS))         AS DATE_TRANS             
REARCH             ,AMT_POSTED                AS AMT_POSTED             
REARCH             ,LTRIM(RTRIM(DEP_PAY_DT))         AS DEP_PAY_DT             
REARCH             ,DEP_PAY_AMT               AS DEP_PAY_AMT            
REARCH             ,LTRIM(RTRIM(INT_CREDIT_DT))      AS INT_CREDIT_DT          
REARCH             ,INTEREST_AMT              AS INTEREST_AMT           
REARCH             ,INTEREST_RT               AS INTEREST_RT            
REARCH             ,LTRIM(RTRIM(EFFECTIVE_DT))       AS EFFECTIVE_DT           
REARCH             ,LTRIM(RTRIM(REV_DISTRICT_DESC))  AS 
           REV_DISTRICT_DESC      
REARCH             ,LTRIM(RTRIM(DATE_REFUND))        AS DATE_REFUND            
REARCH             ,MANUAL_INDICATOR          AS MANUAL_INDICATOR       
REARCH             ,[DEP-AMT_REFUNDED]          AS DEP_AMT_REFUNDED       
REARCH             ,[INT-AMT_REFUNDED]          AS INT_AMT_REFUNDED       
REARCH             ,[TOT-AMT_REFUNDED]          AS TOT_AMT_REFUNDED       
REARCH             ,[CHECK_ISS-REAS_CD]         AS CHECK_ISS_REAS_CD      
REARCH             ,CHECK_STATUS_CD           AS CHECK_STATUS_CD        
REARCH             ,LTRIM(RTRIM([USER_NAME-RQTED_BY])) AS 
           [USER_NAME-RQTED_BY]     
REARCH             ,LTRIM(RTRIM(USER_NAME_APRVD_BY)) AS 
           USER_NAME_APRVD_BY     
REARCH             ,LTRIM(RTRIM(ACCT_NO_CREDITED))   AS ACCT_NO_CREDITED       
REARCH             ,LTRIM(RTRIM(COMMENTS))           AS COMMENTS               
REARCH             ,DEPOSIT_STATUS_CD         AS DEPOSIT_STATUS_CD      
REARCH             ,LTRIM(RTRIM(DATE_TRAN))          AS DATE_TRAN              
REARCH         FROM                                                     
REARCH             #CSR02159_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE               AS RETURN_CODE                    
MFA-TR*            ,DEPOSIT_CERT_NO           AS DEPOSIT_CERT_NO                
MFA-TR*            ,ORIG_DEP_AMT              AS ORIG_DEP_AMT                   
MFA-TR*            ,AMT_REFUNDED              AS AMT_REFUNDED                   
MFA-TR*            ,TRANSFER_AMT              AS TRANSFER_AMT                   
MFA-TR*            ,AMT_DEPOSIT               AS AMT_DEPOSIT                    
MFA-TR*            ,STRIP(TRANSFERRED_TO)     AS TRANSFERRED_TO                 
MFA-TR*            ,STRIP(DEP_CERT_NO_TO)     AS DEP_CERT_NO_TO                 
MFA-TR*            ,STRIP(TRANSFERRED_FROM)   AS TRANSFERRED_FROM       .       
MFA-TR*            ,STRIP(DEP_CERT_NO_FROM)   AS DEP_CERT_NO_FROM       .       
MFA-TR*            ,SERVICE_TYPE_CD           AS SERVICE_TYPE_CD                
MFA-TR*            ,REPEAT_COUNT              AS REPEAT_COUNT                   
MFA-TR*            ,STRIP(DATE_TRANS)         AS DATE_TRANS                     
MFA-TR*            ,AMT_POSTED                AS AMT_POSTED                     
MFA-TR*            ,STRIP(DEP_PAY_DT)         AS DEP_PAY_DT                     
MFA-TR*            ,DEP_PAY_AMT               AS DEP_PAY_AMT                    
MFA-TR*            ,STRIP(INT_CREDIT_DT)      AS INT_CREDIT_DT                  
MFA-TR*            ,INTEREST_AMT              AS INTEREST_AMT           0.      
MFA-TR*            ,INTEREST_RT               AS INTEREST_RT                    
MFA-TR*            ,STRIP(EFFECTIVE_DT)       AS EFFECTIVE_DT                   
MFA-TR*            ,STRIP(REV_DISTRICT_DESC)  AS REV_DISTRICT_DESC              
MFA-TR*            ,STRIP(DATE_REFUND)        AS DATE_REFUND                    
MFA-TR*            ,MANUAL_INDICATOR          AS MANUAL_INDICATOR               
MFA-TR*            ,DEP-AMT_REFUNDED          AS DEP_AMT_REFUNDED               
MFA-TR*            ,INT-AMT_REFUNDED          AS INT_AMT_REFUNDED               
MFA-TR*            ,TOT-AMT_REFUNDED          AS TOT_AMT_REFUNDED               
MFA-TR*            ,CHECK_ISS-REAS_CD         AS CHECK_ISS_REAS_CD              
MFA-TR*            ,CHECK_STATUS_CD           AS CHECK_STATUS_CD                
MFA-TR*            ,STRIP(USER_NAME-RQTED_BY) AS USER_NAME-RQTED_BY             
MFA-TR*            ,STRIP(USER_NAME_APRVD_BY) AS USER_NAME_APRVD_BY             
MFA-TR*            ,STRIP(ACCT_NO_CREDITED)   AS ACCT_NO_CREDITED               
MFA-TR*            ,STRIP(COMMENTS)           AS COMMENTS                       
MFA-TR*            ,DEPOSIT_STATUS_CD         AS DEPOSIT_STATUS_CD              
MFA-TR*            ,STRIP(DATE_TRAN)          AS DATE_TRAN              02402000
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02159_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************************      
      * 0100A-DECLARE-GTT                                              * *      
      ********************************************************************      
      *                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02159_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH*                                   TO S-SQL-STATEMENT-V.                 
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02159_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02159_R1
               (                                                       
REARCH              RETURN_CODE          INT                        
REARCH             ,DEPOSIT_CERT_NO      INT                        
REARCH             ,ORIG_DEP_AMT         DECIMAL(11,2)                  
REARCH             ,AMT_REFUNDED         DECIMAL(11,2)                  
REARCH             ,TRANSFER_AMT         DECIMAL(09,2)                  
REARCH             ,AMT_DEPOSIT          DECIMAL(09,2)                  
REARCH             ,TRANSFERRED_TO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,DEP_CERT_NO_TO CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,TRANSFERRED_FROM CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,DEP_CERT_NO_FROM CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,SERVICE_TYPE_CD CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,REPEAT_COUNT         SMALLINT                       
REARCH             ,DATE_TRANS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,AMT_POSTED           DECIMAL(11,2)                  
REARCH             ,DEP_PAY_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,DEP_PAY_AMT          DECIMAL(9,2)                   
REARCH             ,INT_CREDIT_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,INTEREST_AMT         DECIMAL(11,2)                  
REARCH             ,INTEREST_RT          DECIMAL(07,4)                  
REARCH             ,EFFECTIVE_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,REV_DISTRICT_DESC CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,DATE_REFUND CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,MANUAL_INDICATOR CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,[DEP-AMT_REFUNDED]     DECIMAL(11,2)                  
REARCH             ,[INT-AMT_REFUNDED]     DECIMAL(11,2)                  
REARCH             ,[TOT-AMT_REFUNDED]     DECIMAL(11,2)                  
REARCH             ,[CHECK_ISS-REAS_CD] CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,CHECK_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,[USER_NAME-RQTED_BY] CHAR(29)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,USER_NAME_APRVD_BY CHAR(29)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,ACCT_NO_CREDITED CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,DEPOSIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02159_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
      ********************************************************************      
      * 0110-INIT-DO-RS                                                * *      
      ********************************************************************      
      *                                                                         
       0110-INIT-DO-RS.                                                 
      *                                                                         
           MOVE ZEROES TO RS-RETURN-CODE.                               
           MOVE ZEROES TO RS-DEPOSIT-CERT-NO                            
                          WS-TRANSFERRED-TO                             
                          WS-DEP-CERT-NO-TO                             
                          WS-TRANSFERRED-FROM                           
                          WS-DEP-CERT-NO-FROM.                          
           MOVE SPACES TO RS-TRANSFERRED-TO                             
                          RS-DEP-CERT-NO-TO                             
                          RS-TRANSFERRED-FROM                           
                          RS-DEP-CERT-NO-FROM.                          
           MOVE SPACES TO RS-SERVICE-TYPE-CD.                           
           MOVE ZEROES TO RS-AMT-DEPOSIT.                               
PCR482     MOVE ZEROES TO RS-TRANSFER-AMT.                              
PCR482     MOVE ZEROES TO RS-ORIG-DEP-AMT.                              
      *                                                                         
       0110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ********************************************************************      
      * 0125-INIT-RN-RS                                                * *      
      ********************************************************************      
      *                                                                         
       0125-INIT-RN-RS.                                                 
      *                                                                         
           MOVE SPACES TO RS-DATE-REFUND.                               
           MOVE SPACES TO RS-CHECK-ISS-REAS-CD.                         
           MOVE SPACES TO RS-USER-NAME-APPRVD-BY.                       
           MOVE SPACES TO RS-USER-NAME-RQSTED-BY.                       
PCR482     MOVE SPACES TO RS-ACCT-NO-CREDITED.                          
PCR482     MOVE ZEROES TO RS-INT-AMT-REFUNDED.                          
PCR482     MOVE ZEROES TO RS-DEP-AMT-REFUNDED.                          
PCR482     MOVE ZEROES TO RS-TOT-AMT-REFUNDED.                          
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ********************************************************************      
      * 0130-INIT-AR-AU-RS                                             * *      
      ********************************************************************      
      *                                                                         
       0130-INIT-AR-AU-RS.                                              
      *                                                                         
           MOVE SPACES TO RS-DATE-TRANS.                                
           MOVE ZEROES TO RS-AMT-POSTED.                                
      *                                                                         
       0130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ********************************************************************      
      * 0140-INIT-DP-RS                                                * *      
      ********************************************************************      
      *                                                                         
       0140-INIT-DP-RS.                                                 
           MOVE SPACES TO RS-DEP-PAY-DT.                                
           MOVE ZEROES TO RS-DEP-PAY-AMT.                               
       0140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ********************************************************************      
      * 0150-INIT-IH-RS                                                * *      
      ********************************************************************      
      *                                                                         
       0150-INIT-IH-RS.                                                 
      *                                                                         
           MOVE SPACES TO RS-INT-CREDIT-DT                              
                          RS-EFFECTIVE-DT                               
PCR482                    RS-REV-DISTRICT-DESC.                         
           MOVE ZEROES TO RS-INTEREST-AMT                               
                          RS-INTEREST-RT.                               
      *                                                                         
       0150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ********************************************************************      
      * 1000-PROCESS-INPUT                                             * *      
      ********************************************************************      
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO     TO DO-ACCOUNT-NO.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************************      
      * 2000-PROCESS-OUTPUT.                                           * *      
      ********************************************************************      
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'        TO ACTIVE-PARAGRAPH.                      
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-DEPOSIT-CERT-NO     TO S-DEPOSIT-CERT-NO.            
REARCH     MOVE RS-ORIG-DEP-AMT        TO S-ORIG-DEP-AMT.               
REARCH     MOVE RS-AMT-REFUNDED        TO S-AMT-REFUNDED.               
REARCH     MOVE RS-TRANSFER-AMT        TO S-TRANSFER-AMT.               
REARCH     MOVE RS-AMT-DEPOSIT         TO S-AMT-DEPOSIT.                
REARCH     MOVE RS-TRANSFERRED-TO      TO S-TRANSFERRED-TO.             
REARCH     MOVE RS-DEP-CERT-NO-TO      TO S-DEP-CERT-NO-TO.             
REARCH     MOVE RS-TRANSFERRED-FROM    TO S-TRANSFERRED-FROM.           
REARCH     MOVE RS-DEP-CERT-NO-FROM    TO S-DEP-CERT-NO-FROM.           
REARCH     MOVE RS-SERVICE-TYPE-CD     TO S-SERVICE-TYPE-CD.            
REARCH     MOVE RS-REPEAT-COUNT        TO S-REPEAT-COUNT.               
REARCH     MOVE RS-DATE-TRANS          TO S-DATE-TRANS.                 
REARCH     MOVE RS-AMT-POSTED          TO S-AMT-POSTED.                 
REARCH     MOVE RS-DEP-PAY-DT          TO S-DEP-PAY-DT.                 
REARCH     MOVE RS-DEP-PAY-AMT         TO S-DEP-PAY-AMT.                
REARCH     MOVE RS-INT-CREDIT-DT       TO S-INT-CREDIT-DT.              
REARCH     MOVE RS-INTEREST-AMT        TO S-INTEREST-AMT.               
REARCH     MOVE RS-INTEREST-RT         TO S-INTEREST-RT.                
REARCH     MOVE RS-EFFECTIVE-DT        TO S-EFFECTIVE-DT.               
REARCH     MOVE RS-REV-DISTRICT-DESC   TO S-REV-DISTRICT-DESC.          
REARCH     MOVE RS-DATE-REFUND         TO S-DATE-REFUND.                
REARCH     MOVE RS-MANUAL-INDICATOR    TO S-MANUAL-INDICATOR.           
REARCH     MOVE RS-DEP-AMT-REFUNDED    TO S-DEP-AMT-REFUNDED.           
REARCH     MOVE RS-INT-AMT-REFUNDED    TO S-INT-AMT-REFUNDED.           
REARCH     MOVE RS-TOT-AMT-REFUNDED    TO S-TOT-AMT-REFUNDED.           
REARCH     MOVE RS-CHECK-ISS-REAS-CD   TO S-CHECK-ISS-REAS-CD.          
REARCH     MOVE RS-CHECK-STATUS-CD     TO S-CHECK-STATUS-CD.            
REARCH     MOVE RS-USER-NAME-RQSTED-BY TO S-USER-NAME-RQSTED-BY.        
REARCH     MOVE RS-USER-NAME-APPRVD-BY TO S-USER-NAME-APPRVD-BY.        
REARCH     MOVE RS-ACCT-NO-CREDITED    TO S-ACCT-NO-CREDITED.           
REARCH     MOVE RS-COMMENTS            TO S-COMMENTS.                   
REARCH     MOVE RS-DEPOSIT-STATUS-CD   TO S-DEPOSIT-STATUS-CD.          
REARCH     MOVE RS-DATE-TRAN           TO S-DATE-TRAN.                  
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 2200-BUILD-RESULT                                              *       *
      **************************************************************************
      *                                                                         
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE '2200'          TO ACTIVE-PARAGRAPH.                    
           MOVE PARM-ACCOUNT-NO     TO DO-ACCOUNT-NO.                   
                                                                        
           PERFORM 7100-OPEN-DO-CURSOR  THRU  7100-EXIT.                
           PERFORM 7110-FETCH-DO-CURSOR THRU  7110-EXIT.                
           MOVE WS-ACTIVE-RETURN-CODE TO WS-FETCH-RETCODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
           PERFORM 2205-PROCESS-DO-CURSOR   THRU 2205-EXIT              
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
           PERFORM 7120-CLOSE-DO-CURSOR THRU 7120-EXIT.                 
      *                                                                         
           IF CTR-ROWS <= 0                                             
              MOVE WS-FETCH-RETCODE TO WS-ACTIVE-RETURN-CODE            
              MOVE WS-FETCH-RETCODE TO RS-RETURN-CODE                   
REARCH        PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 2205-PROCESS-DO-CURSOR                                         *       *
      *     FETCHES ROWS FROM DO TABLE. PROCESSES OTHER DB2 TABLES FOR *       *
      *     EVERY DEPOSIT RETIEVED FROM DO TABLE.                      *       *
      **************************************************************************
      *                                                                         
       2205-PROCESS-DO-CURSOR.                                          
      *                                                                         
           MOVE 'N' TO WS-AR-NOT-FOUND-FLAG.                            
           MOVE 'N' TO WS-IH-NOT-FOUND-FLAG.                            
           MOVE 'N' TO WS-DP-NOT-FOUND-FLAG.                            
           MOVE 'N' TO WS-RN-NOT-FOUND-FLAG.                            
      *                                                                         
           PERFORM 0110-INIT-DO-RS THRU 0110-EXIT.                      
      *                                                                         
PCR482     COMPUTE WS-ORIG-DEP-AMT = DO-AMT-REFUNDED +                  
PCR482         DO-TRANSFER-AMT + DO-AMT-DEPOSIT.                        
      *                                                                         
PCR482     MOVE WS-ORIG-DEP-AMT       TO RS-ORIG-DEP-AMT                
           MOVE DO-DEPOSIT-CERT-NO    TO RS-DEPOSIT-CERT-NO             
           MOVE DO-AMT-REFUNDED       TO RS-AMT-REFUNDED                
           MOVE DO-SERVICE-TYPE-CD    TO RS-SERVICE-TYPE-CD             
           MOVE DO-AMT-DEPOSIT        TO RS-AMT-DEPOSIT                 
PCR482     MOVE DO-DEPOSIT-STATUS-CD  TO RS-DEPOSIT-STATUS-CD           
PCR482     MOVE DO-DATE-TRAN          TO RS-DATE-TRAN                   
PCR482     MOVE DO-TRANSFERRED-TO     TO WS-TRANSFERRED-TO              
PCR482     MOVE DO-DEP-CERT-NO-TO     TO WS-DEP-CERT-NO-TO              
PCR482     MOVE DO-TRANSFERRED-FROM   TO WS-TRANSFERRED-FROM            
PCR482     MOVE DO-DEP-CERT-NO-FROM   TO WS-DEP-CERT-NO-FROM            
      *                                                                         
PCR482     IF WS-TRANSFERRED-TO NOT EQUAL ZERO                          
PCR482       MOVE WS-TRANSFERRED-TO   TO WS-TRANS-TO-REDEF              
PCR482       MOVE WS-TRANSFER-TO-RED  TO RS-TRANSFERRED-TO              
PCR482     ELSE                                                         
PCR482       MOVE SPACES              TO RS-TRANSFERRED-TO              
PCR482     END-IF.                                                      
      *                                                                         
PCR482     IF WS-DEP-CERT-NO-TO NOT EQUAL ZERO                          
PCR482       MOVE WS-DEP-CERT-NO-TO   TO WS-DEP-CERT-TO-REDEF           
PCR482       MOVE WS-DEPOSIT-TO-RED   TO RS-DEP-CERT-NO-TO              
PCR482     ELSE                                                         
PCR482       MOVE SPACES              TO RS-DEP-CERT-NO-TO              
PCR482     END-IF.                                                      
      *                                                                         
PCR482     IF WS-TRANSFERRED-FROM NOT EQUAL ZERO                        
PCR482       MOVE WS-TRANSFERRED-FROM TO WS-TRANS-FROM-REDEF            
PCR482       MOVE WS-TRANSFER-FROM-RED TO RS-TRANSFERRED-FROM           
PCR482     ELSE                                                         
PCR482       MOVE SPACES              TO RS-TRANSFERRED-FROM            
PCR482     END-IF.                                                      
      *                                                                         
PCR482     IF WS-DEP-CERT-NO-FROM NOT EQUAL ZERO                        
PCR482       MOVE WS-DEP-CERT-NO-FROM TO WS-DEP-CERT-FROM-REDEF         
PCR482       MOVE WS-DEPOSIT-FROM-RED TO RS-DEP-CERT-NO-FROM            
PCR482     ELSE                                                         
PCR482       MOVE SPACES              TO RS-DEP-CERT-NO-FROM            
PCR482     END-IF.                                                      
      *                                                                         
PCR482     MOVE RS-DEP-CERT-NO-TO     TO WS-DEP-CERT-INP-FIELD.         
PCR482     MOVE '1'                   TO WS-INPUT-ID.                   
PCR482     PERFORM 3600-DEP-CERT-NO-FMT                 THRU 3600-EXIT. 
      *                                                                         
PCR482     MOVE WS-DEP-CERT-NO-FROM   TO WS-DEP-CERT-INP-FIELD.         
PCR482     MOVE '2'                   TO WS-INPUT-ID.                   
PCR482     PERFORM 3600-DEP-CERT-NO-FMT                 THRU 3600-EXIT. 
      *                                                                         
PCR482     MOVE DO-TRANSFER-AMT       TO RS-TRANSFER-AMT                
           MOVE PARM-ACCOUNT-NO       TO RN-ACCOUNT-NO                  
           MOVE PARM-ACCOUNT-NO     TO AR-ACCOUNT-NO,                   
                                       AT-ACCOUNT-NO.                   
      *                                                                         
           MOVE 'AR-DEP'            TO GO-GL-ACCT-NAME                  
      *                                                                         
           EXEC SQL                                                     
             SELECT GL_ACCT_NO                                          
             INTO :GO-GL-ACCT-NO                                        
             FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                          
             WHERE GL_ACCT_NAME  = :GO-GL-ACCT-NAME                     
MCR310       AND   COMPANY_NO    = '01'                                 
P00394                                                           
P00394                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT GL_ACCT_NO                                                  
MFA-TR*      INTO :GO-GL-ACCT-NO                                                
MFA-TR*      FROM CSS_GL_ACCT_NO                                                
MFA-TR*      WHERE GL_ACCT_NAME  = :GO-GL-ACCT-NAME                             
MFA-TR*      AND   COMPANY_NO    = '01'                                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 2205                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE GO-GL-ACCT-NO TO WS-GL-AR-DEP.                          
      *                                                                         
           MOVE DO-DEPOSIT-CERT-NO TO RN-DEPOSIT-CERT-NO.               
           PERFORM 7165-OPEN-RN-CURSOR  THRU 7165-EXIT.                 
           PERFORM 7166-FETCH-RN-CURSOR THRU 7166-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-RN-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
      *                                                                         
           PERFORM 7170-OPEN-AR-CURSOR  THRU 7170-EXIT.                 
           PERFORM 7180-FETCH-AR-CURSOR THRU 7180-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
      *                                                                         
C26296* A NOT FOUND ON AR-TRANS MEANS THAT IT IS A IMMEDIATE BILL               
C26296* DEPOSIT OR A NEXT BILL/INSTALLMENT DEPOSIT THAT IS NOT BILLED           
C26296*                                                                         
C26296        MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
C26296        MOVE AT-ACCOUNT-NO        TO DR-ACCOUNT-NO                
C26296        MOVE +80                  TO DR-PYMT-PRIORITY-LVL         
C26296        MOVE DO-DEPOSIT-CERT-NO   TO DR-DEP-ITEM-ID               
C26296*                                                                         
C26296        PERFORM 7980-SELECT-DEP-REQ                               
C26296                                  THRU 7980-EXIT                  
C26296*                                                                         
C26296        IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
C26296        OR  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND          
C26296             DR-DEP-BILL-OPTION-CD = 'I')                         
C26296            MOVE DO-AMT-DEPOSIT    TO AU-AMT-POSTED               
C26296            MOVE DO-DATE-TRAN(6:2) TO WS-USA-DATE-MM              
C26296            MOVE DO-DATE-TRAN(9:2) TO WS-USA-DATE-DD              
C26296            MOVE DO-DATE-TRAN(1:4) TO WS-USA-DATE-CCYY            
C26296            MOVE WS-USA-DATE       TO WS-DATE-TRANS               
C26296        ELSE                                                      
C26296*                                                                         
C26296* FOR NEXT BILL OR INSTALLMENT DEPOSITS THAT ARE NOT YET BILLED           
C26296* AND ARE NOT FULLY PAID OFF SO THAT THE ROW IN CSS_DEP_REQ               
C26296* STILL EXISTS.                                                           
C26296*                                                                         
C26296            MOVE 'Y'    TO WS-AR-NOT-FOUND-FLAG                   
C26296            MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                  
C26296        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE PARM-ACCOUNT-NO     TO IH-ACCOUNT-NO                    
           MOVE DO-DEPOSIT-CERT-NO  TO IH-DEPOSIT-CERT-NO.              
           PERFORM 7200-OPEN-IH-CURSOR  THRU 7200-EXIT.                 
           PERFORM 7210-FETCH-IH-CURSOR THRU 7210-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-IH-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
      *                                                                         
           MOVE PARM-ACCOUNT-NO     TO DP-ACCOUNT-NO.                   
           MOVE DO-DEPOSIT-CERT-NO  TO DP-DEPOSIT-CERT-NO.              
           PERFORM 7220-OPEN-DP-CURSOR  THRU 7220-EXIT.                 
           PERFORM 7230-FETCH-DP-CURSOR THRU 7230-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-DP-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
      *                                                                         
           IF  WS-IH-NOT-FOUND-FLAG  = 'Y'                              
           AND WS-AR-NOT-FOUND-FLAG  = 'Y'                              
           AND WS-RN-NOT-FOUND-FLAG  = 'Y'                              
           AND WS-DP-NOT-FOUND-FLAG  = 'Y' THEN                         
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
           END-IF.                                                      
      *                                                                         
PCR482     MOVE ZEROES              TO WS-INTEREST-AMT-HOLD.            
PCR482     MOVE ZEROES              TO WS-DEP-AMT-REFUNDED.             
           PERFORM 2210-PROCESS-OTHER-CURSORS THRU 2210-EXIT            
           UNTIL WS-AR-NOT-FOUND                                        
             AND WS-IH-NOT-FOUND                                        
             AND WS-DP-NOT-FOUND                                        
             AND WS-RN-NOT-FOUND                                        
      *                                                                         
           PERFORM 7184-CLOSE-RN-CURSOR THRU 7184-EXIT.                 
           PERFORM 7185-CLOSE-AR-CURSOR THRU 7185-EXIT.                 
           PERFORM 7215-CLOSE-IH-CURSOR THRU 7215-EXIT.                 
           PERFORM 7235-CLOSE-DP-CURSOR THRU 7235-EXIT.                 
PCR052     PERFORM 0125-INIT-RN-RS THRU 0125-EXIT                       
           PERFORM 0130-INIT-AR-AU-RS THRU 0130-EXIT                    
           PERFORM 0150-INIT-IH-RS THRU 0150-EXIT                       
           PERFORM 0140-INIT-DP-RS THRU 0140-EXIT                       
      *                                                                         
           PERFORM 7110-FETCH-DO-CURSOR THRU 7110-EXIT.                 
           MOVE 1 TO RS-REPEAT-COUNT.                                   
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 2210-PROCESS-OTHER-CURSORS                                     *       *
      * RETRIEVES DATA FROM OTHER DB2 TABLES TO POPULATE RESULT SET    *       *
      * DATA FIELDS. SENDS THE RESULT SET TO THE CLIENT.               *       *
      **************************************************************************
      *                                                                         
       2210-PROCESS-OTHER-CURSORS.                                      
      *                                                                         
           MOVE '2210'  TO ACTIVE-PARAGRAPH.                            
      *                                                                         
PCR052     IF WS-RN-NOT-FOUND                                           
PCR052        PERFORM 0125-INIT-RN-RS THRU 0125-EXIT                    
PCR052     ELSE                                                         
P00394        MOVE DO-ACCOUNT-NO        TO IH-ACCOUNT-NO                
P00394        MOVE DO-DEPOSIT-CERT-NO   TO IH-DEPOSIT-CERT-NO           
P00394        PERFORM 7900-SELECT-TOTAL-INT           THRU 7900-EXIT    
P00394        COMPUTE WS-DEP-AMT-REFUNDED =                             
P00394                RN-AMT-REFUNDED - WS-INTEREST-AMT-HOLD            
P00394*                                                                         
PCR482        MOVE WS-INTEREST-AMT-HOLD TO RS-INT-AMT-REFUNDED          
PCR482        MOVE WS-DEP-AMT-REFUNDED  TO RS-DEP-AMT-REFUNDED          
PCR482        MOVE RN-AMT-REFUNDED      TO RS-TOT-AMT-REFUNDED          
PCR052        MOVE RN-CHECK-ISS-REAS-CD TO RS-CHECK-ISS-REAS-CD         
PCR052        MOVE WS-DATE-REFUND       TO RS-DATE-REFUND               
T12003        MOVE SPACES               TO RS-COMMENTS                  
T12003        MOVE RN-COMMENTS-TEXT     TO RS-COMMENTS                  
      *                                                                         
PCR482        IF RN-USER-ID-APPRVD-BY NOT EQUAL SPACES                  
PCR482          MOVE RN-USER-ID-APPRVD-BY TO PF-USER-ID                 
PCR482          PERFORM 7975-SELECT-USER-NAME           THRU 7975-EXIT  
PCR482          PERFORM 2500-PROCESS-NAME               THRU 2500-EXIT  
PCR482          MOVE WS-HOLD-NAME-OUTPUT  TO RS-USER-NAME-APPRVD-BY     
PCR482        ELSE                                                      
PCR482          MOVE SPACES               TO RS-USER-NAME-APPRVD-BY     
PCR482        END-IF                                                    
      *                                                                         
PCR482        IF RN-USER-ID-RQSTED-BY NOT EQUAL SPACES                  
PCR052          MOVE RN-USER-ID-RQSTED-BY TO PF-USER-ID                 
PCR482          PERFORM 7975-SELECT-USER-NAME           THRU 7975-EXIT  
PCR482          PERFORM 2500-PROCESS-NAME               THRU 2500-EXIT  
PCR482          MOVE WS-HOLD-NAME-OUTPUT  TO RS-USER-NAME-RQSTED-BY     
PCR482        ELSE                                                      
PCR482          MOVE SPACES               TO RS-USER-NAME-RQSTED-BY     
PCR482        END-IF                                                    
      *                                                                         
PCR052        MOVE RN-CHECK-STATUS-CD   TO RS-CHECK-STATUS-CD           
PCR052        MOVE RN-MANUAL-INDICATOR  TO RS-MANUAL-INDICATOR          
PCR482        MOVE RN-ACCT-NO-CREDITED  TO WS-ACCT-NO-CREDITED          
      *                                                                         
PCR482        IF WS-ACCT-NO-CREDITED NOT EQUAL ZERO                     
PCR482          MOVE WS-ACCT-NO-CREDITED TO WS-ACCT-NO-CRD-REDEF        
PCR482          MOVE WS-ACCT-NO-CREDIT-RED                              
PCR482                                   TO RS-ACCT-NO-CREDITED         
PCR482        ELSE                                                      
PCR482          MOVE SPACES              TO RS-ACCT-NO-CREDITED         
PCR482        END-IF                                                    
      *                                                                         
PCR052        PERFORM 7166-FETCH-RN-CURSOR THRU 7166-EXIT               
PCR052        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PCR052           MOVE 'Y'  TO WS-RN-NOT-FOUND-FLAG                      
PCR052           MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
T25426        END-IF                                                    
PCR052     END-IF.                                                      
      *                                                                         
           IF WS-AR-NOT-FOUND                                           
              PERFORM 0130-INIT-AR-AU-RS THRU 0130-EXIT                 
           ELSE                                                         
              MOVE WS-DATE-TRANS TO RS-DATE-TRANS                       
              MOVE AU-AMT-POSTED TO RS-AMT-POSTED                       
              PERFORM 7180-FETCH-AR-CURSOR THRU 7180-EXIT               
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-AR-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-IH-NOT-FOUND                                           
              PERFORM 0150-INIT-IH-RS THRU 0150-EXIT                    
           ELSE                                                         
              MOVE WS-INT-CREDIT-DT TO RS-INT-CREDIT-DT                 
              MOVE IH-INTEREST-AMT  TO RS-INTEREST-AMT                  
              MOVE IH-INTEREST-RT TO   RS-INTEREST-RT                   
              MOVE WS-EFFECTIVE-DT TO  RS-EFFECTIVE-DT                  
PCR482        MOVE PR-REV-DISTRICT-CD   TO WS-HOLD-REV-DIST             
PCR482        PERFORM 7950-SELECT-REV-DIST              THRU 7950-EXIT  
PCR482        MOVE A9-REV-DISTRICT-DESC TO RS-REV-DISTRICT-DESC         
              PERFORM 7210-FETCH-IH-CURSOR THRU 7210-EXIT               
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-IH-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-DP-NOT-FOUND                                           
              PERFORM 0140-INIT-DP-RS THRU 0140-EXIT                    
           ELSE                                                         
              MOVE WS-DEP-PAY-DT TO RS-DEP-PAY-DT                       
              MOVE DP-DEP-PAY-AMT TO RS-DEP-PAY-AMT                     
              PERFORM 7230-FETCH-DP-CURSOR THRU 7230-EXIT               
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-DP-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
           ADD 1 TO RS-REPEAT-COUNT.                                    
      *                                                                         
        2210-EXIT.                                                      
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 2500-PROCESS-NAME                                              *        
      ******************************************************************        
      *                                                                         
PCR482 2500-PROCESS-NAME.                                               
PCR482*                                                                         
           MOVE SPACES           TO    WS-HOLD-NAME-OUTPUT.             
      *                                                                         
PCR482     MOVE PF-FIRST-NAME    TO    WS-FROM.                         
PCR482     PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
PCR482     MOVE WS-FROM          TO    PF-FIRST-NAME.                   
                                                                        
PCR482     MOVE PF-LAST-NAME     TO    WS-FROM.                         
PCR482     PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
PCR482     MOVE WS-FROM          TO    PF-LAST-NAME.                    
                                                                        
PCR482     MOVE PF-MIDDLE-NAME   TO    WS-FROM.                         
PCR482     PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
PCR482     MOVE WS-FROM          TO    PF-MIDDLE-NAME.                  
      *                                                                         
PCR482     STRING PF-LAST-NAME DELIMITED CN-DELIMITER                   
PCR482            ', ' DELIMITED SIZE                                   
PCR482            PF-FIRST-NAME DELIMITED CN-DELIMITER                  
PCR482            ' ' DELIMITED SIZE                                    
T10265            PF-MIDDLE-NAME DELIMITED CN-DELIMITER                 
PCR482       INTO WS-HOLD-NAME-OUTPUT                                   
PCR482     END-STRING.                                                  
      *                                                                         
T11105     IF WS-HOLD-NAME-OUTPUT (1:6) EQUAL 'SYSTEM'                  
T11105        MOVE SPACES TO WS-HOLD-NAME-OUTPUT (7:23)                 
T11105     ELSE                                                         
T11105        IF WS-HOLD-NAME-OUTPUT (1:1) EQUAL ','                    
T11105           MOVE SPACES TO WS-HOLD-NAME-OUTPUT                     
T11105        END-IF                                                    
T11105     END-IF.                                                      
      *                                                                         
PCR482 2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      ******************************************************************        
      *                                                                         
PCR482 2510-PROCESS-FROM-STRING.                                        
      *                                                                         
PCR482     PERFORM                                                      
PCR482        VARYING WS-SUB FROM 15 BY -1                              
PCR482            UNTIL WS-SUB < 1                                      
PCR482            OR WS-FROM-X(WS-SUB) NOT = SPACE                      
PCR482     END-PERFORM.                                                 
PCR482     ADD 1      TO   WS-SUB.                                      
PCR482     MOVE CN-DELIMITER  TO WS-FROM-X(WS-SUB).                     
      *                                                                         
PCR482 2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3600-DEP-CERT-NO-FMT                                           *        
      ******************************************************************        
      *                                                                         
PCR482 3600-DEP-CERT-NO-FMT.                                            
      *                                                                         
PCR482     MOVE WS-N                TO WS-POSITIVE-FOUND-SW.            
      *                                                                         
PCR482     PERFORM VARYING WS-COUNT FROM +1 BY +1                       
PCR482       UNTIL WS-COUNT > 9 OR POSITIVE-NUM-IS-FOUND                
PCR482         IF WS-DEP-CERT-INP-FIELD(WS-COUNT:1) EQUAL '0'           
PCR482           IF WS-INPUT-ID EQUAL '1'                               
PCR482             MOVE SPACES      TO RS-DEP-CERT-NO-TO(WS-COUNT:1)    
PCR482           ELSE                                                   
PCR482             MOVE SPACES      TO RS-DEP-CERT-NO-FROM(WS-COUNT:1)  
PCR482           END-IF                                                 
PCR482         ELSE                                                     
PCR482           MOVE WS-Y          TO WS-POSITIVE-FOUND-SW             
PCR482         END-IF                                                   
PCR482     END-PERFORM.                                                 
      *                                                                         
PCR482 3600-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7100-OPEN-DO-CURSOR                                            *        
      **************************************************************************
      *                                                                         
       7100-OPEN-DO-CURSOR.                                             
      *                                                                         
           MOVE '7100'    TO ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN DO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO '        TO TABLE-ELEMENT-1              
              MOVE DO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7110-FETCH-DO-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7110-FETCH-DO-CURSOR.                                            
      *                                                                         
           MOVE '7110'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
             FETCH DO-CURSOR                                            
             INTO :DO-DEPOSIT-CERT-NO,                                  
                  :DO-AMT-REFUNDED,                                     
                  :DO-SERVICE-TYPE-CD,                                  
                  :DO-AMT-DEPOSIT,                                      
                  :DO-TOTAL-INTRST,                                     
                  :DO-CODE-REFUND-TYPE,                                 
                  :DO-CODE-REFUND-REASON,                               
                  :WS-DATE-REFUNDED :WS-NULL-IND1,                       
                  :DO-DATE-TRAN :WS-NULL-IND2,                           
                  :DO-TRANSFERRED-TO,                                   
                  :DO-DEP-CERT-NO-TO,                                   
                  :DO-TRANSFERRED-FROM,                                 
                  :DO-DEP-CERT-NO-FROM,                                 
PCR482            :DO-TRANSFER-AMT,                                     
PCR482            :DO-DEPOSIT-STATUS-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DATE-REFUNDED                        
           END-IF                                                       
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO DO-DATE-TRAN                            
           END-IF                                                       
      *                                                                         
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE DO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7120-CLOSE-DO-CURSOR                                           *CH    **
      **************************************************************************
      *                                                                         
       7120-CLOSE-DO-CURSOR.                                            
      *                                                                         
           MOVE '7120'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE DO-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE DO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7200-OPEN-IH-CURSOR                                            *      **
      **************************************************************************
      *                                                                         
       7200-OPEN-IH-CURSOR.                                             
      *                                                                         
           MOVE '7200'    TO ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN IH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_INTEREST_HIST'  TO TABLE-1                      
CBSI          MOVE 'CSS_PREMISE'        TO TABLE-2                      
CBSI          MOVE 'CSS_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE IH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE IH-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7210-FETCH-IH-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7210-FETCH-IH-CURSOR.                                            
      *                                                                         
           MOVE '7210'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH IH-CURSOR                                            
             INTO :WS-INT-CREDIT-DT :WS-NULL-IND1,                       
                  :IH-INT-CREDIT-DT :WS-NULL-IND2,                       
                  :IH-INTEREST-AMT,                                     
                  :IH-INTEREST-RT,                                      
                  :WS-EFFECTIVE-DT :WS-NULL-IND1,                        
                  :IH-EFFECTIVE-DT :WS-NULL-IND2,                        
                  :PR-REV-DISTRICT-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-EFFECTIVE-DT                         
                 MOVE SPACES TO WS-INT-CREDIT-DT                        
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO IH-EFFECTIVE-DT                         
                 MOVE SPACES TO IH-INT-CREDIT-DT                        
           END-IF.                                                      
                                                                        
      *                                                                         
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_INTEREST_HIST'  TO TABLE-1                      
CBSI          MOVE 'CSS_PREMISE'        TO TABLE-2                      
CBSI          MOVE 'CSS_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE IH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE IH-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7215-CLOSE-IH-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7215-CLOSE-IH-CURSOR.                                            
      *                                                                         
           MOVE '7215'   TO ACTIVE-PARAGRAPH.                           
      *                                                                         
           EXEC SQL                                                     
                 CLOSE IH-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_INTEREST_HIST'  TO TABLE-1                      
CBSI          MOVE 'CSS_PREMISE'        TO TABLE-2                      
CBSI          MOVE 'CSS_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE IH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE IH-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7220-OPEN-DP-CURSOR                                            *      **
      **************************************************************************
      *                                                                         
       7220-OPEN-DP-CURSOR.                                             
      *                                                                         
           MOVE '7220'    TO ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN DP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_PAY_HST'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE DP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DP-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7230-FETCH-DP-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7230-FETCH-DP-CURSOR.                                            
      *                                                                         
           MOVE '7230'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
             FETCH DP-CURSOR                                            
             INTO :WS-DEP-PAY-DT :WS-NULL-IND1,                          
                  :DP-DEP-PAY-DT :WS-NULL-IND2,                          
                  :DP-DEP-PAY-AMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DEP-PAY-DT                           
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO DP-DEP-PAY-DT                           
           END-IF.                                                      
      *                                                                         
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_PAY_HST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE DP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DP-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7235-CLOSE-DP-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7235-CLOSE-DP-CURSOR.                                            
      *                                                                         
           MOVE '7235'   TO ACTIVE-PARAGRAPH.                           
      *                                                                         
           EXEC SQL                                                     
                 CLOSE DP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_PAY_HST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
CBSI          MOVE DP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DP-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7235-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7170-OPEN-AR-CURSOR                                            *        
      **************************************************************************
      *                                                                         
       7170-OPEN-AR-CURSOR.                                             
      *                                                                         
           MOVE '7170'    TO ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN AR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                 NEXT SENTENCE                                          
           ELSE                                                         
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
CBSI         MOVE 'OPEN'                     TO ABEND-FUNCTION          
CBSI         MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                 
CBSI         MOVE 'CSS_AR_TRN_HST_DET'       TO TABLE-2                 
             MOVE 'ACCOUNT_NO   '            TO TABLE-ELEMENT-1         
CBSI         MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2         
CBSI         MOVE 'GL_ACCT_DEBIT'            TO TABLE-ELEMENT-3         
CBSI         MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
CBSI         MOVE DO-DEPOSIT-CERT-NO         TO HOSTVAR-ELEMENT-2       
CBSI         MOVE WS-GL-AR-DEP               TO WS-GL-AR-DEP-ED         
CBSI         MOVE WS-GL-AR-DEP-ED            TO HOSTVAR-ELEMENT-3       
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7165-OPEN-RN-CURSOR                                            *        
      **************************************************************************
      *                                                                         
       7165-OPEN-RN-CURSOR.                                             
PCR052*                                                                         
PCR052     MOVE '7165'    TO ACTIVE-PARAGRAPH.                          
PCR052*                                                                         
PCR052     EXEC SQL                                                     
PCR052          OPEN RN-CURSOR                                          
PCR052     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR052*                                                                         
PCR052     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
PCR052*                                                                         
PCR052     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
PCR052           NEXT SENTENCE                                          
PCR052     ELSE                                                         
PCR052       MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
CBSI         MOVE 'OPEN'                     TO ABEND-FUNCTION          
PCR052       MOVE 'CSS_REFUND       '        TO TABLE-1                 
PCR052       MOVE 'ACCOUNT_NO   '            TO TABLE-ELEMENT-1         
PCR052       MOVE 'DEPOSIT_CERT_NO '         TO TABLE-ELEMENT-2         
CBSI         MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
CBSI         MOVE RN-DEPOSIT-CERT-NO         TO HOSTVAR-ELEMENT-2       
PCR052       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
PCR052       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
PCR052 7165-EXIT.                                                       
PCR052     EXIT.                                                        
PCR052                                                                  
HPCCDM*    EJECT                                                                
PCR052*                                                                         
PCR052**************************************************************************
PCR052* 7166-FETCH-RN-CURSOR                                           *      **
PCR052**************************************************************************
PCR052*                                                                         
PCR052 7166-FETCH-RN-CURSOR.                                            
PCR052*                                                                         
A01601     MOVE SPACES          TO RN-COMMENTS.                         
PCR052     MOVE '7166'          TO ACTIVE-PARAGRAPH.                    
PCR052*                                                                         
PCR052     EXEC SQL                                                     
PCR052       FETCH RN-CURSOR                                            
PCR052       INTO :RN-REFUND-ITEM-ID,                                   
PCR052            :RN-REFUND-CHECK-NO,                                  
PCR052            :RN-AMT-REFUNDED,                                     
PCR052            :WS-DATE-REFUND :WS-NULL-IND1,                         
PCR052            :RN-CHECK-ISS-REAS-CD,                                
PCR052            :RN-PANEL-NO,                                         
PCR052            :RN-USER-ID-APPRVD-BY,                                
PCR052            :RN-USER-ID-RQSTED-BY,                                
PCR052            :RN-CHECK-STATUS-CD,                                  
PCR052            :RN-MANUAL-INDICATOR,                                 
PCR482            :RN-ACCT-NO-CREDITED,                                 
T12003            :RN-COMMENTS                                          
PCR052     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR052*                                                                         
PCR052     IF WS-NULL-IND1 < 0                                          
PCR052           MOVE SPACES TO WS-DATE-REFUND                          
PCR052     END-IF                                                       
PCR052*                                                                         
PCR052     MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
PCR052*                                                                         
PCR052     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
PCR052                               OR     NOT-FOUND                   
PCR052           NEXT SENTENCE                                          
PCR052     ELSE                                                         
PCR052     MOVE PROGRAM-NAME             TO ABEND-PROGRAM               
CBSI       MOVE 'FETCH'                  TO ABEND-FUNCTION              
PCR052     MOVE 'CSS_REFUND     '        TO TABLE-1                     
CBSI       MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1             
CBSI       MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-2             
CBSI       MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1           
PCR052     MOVE RN-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-2           
PCR052     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
PCR052     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
PCR052 7166-EXIT.                                                       
PCR052     EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7180-FETCH-AR-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7180-FETCH-AR-CURSOR.                                            
      *                                                                         
           MOVE '7180'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
             FETCH AR-CURSOR                                            
             INTO :WS-DATE-TRANS :WS-NULL-IND1,                          
                  :AR-DATE-TRANS :WS-NULL-IND2,                          
                  :AU-AMT-POSTED                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DATE-TRANS                           
           END-IF                                                       
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO AR-DATE-TRANS                           
           END-IF                                                       
      *                                                                         
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                     OR NOT-FOUND                       
                 NEXT SENTENCE                                          
           ELSE                                                         
           MOVE PROGRAM-NAME             TO ABEND-PROGRAM               
CBSI       MOVE 'FETCH'                  TO ABEND-FUNCTION              
           MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                     
CBSI       MOVE 'CSS_AR_TRN_HST_DET'     TO TABLE-2                     
CBSI       MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1             
CBSI       MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2             
CBSI       MOVE 'GL_ACCT_DEBIT'          TO TABLE-ELEMENT-3             
           MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
CBSI       MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-2           
CBSI       MOVE WS-GL-AR-DEP             TO WS-GL-AR-DEP-ED             
CBSI       MOVE WS-GL-AR-DEP-ED          TO HOSTVAR-ELEMENT-3           
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7184-CLOSE-RN-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7184-CLOSE-RN-CURSOR.                                            
      *                                                                         
           MOVE '7184'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE RN-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_REFUND'        TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1               
CBSI          MOVE 'DEPOSIT_CERT_NO'   TO TABLE-ELEMENT-2               
CBSI          MOVE RN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE RN-DEPOSIT-CERT-NO  TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7184-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************************
      * 7185-CLOSE-AR-CURSOR                                           *      **
      **************************************************************************
      *                                                                         
       7185-CLOSE-AR-CURSOR.                                            
      *                                                                         
           MOVE '7185'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE AR-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
CBSI          MOVE 'CSS_AR_TRN_HST_DET'     TO TABLE-2                  
CBSI          MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1          
CBSI          MOVE 'ITEM_ID'                TO TABLE-ELEMENT-2          
CBSI          MOVE 'GL_ACCT_DEBIT'          TO TABLE-ELEMENT-3          
CBSI          MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DO-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-2        
CBSI          MOVE WS-GL-AR-DEP             TO WS-GL-AR-DEP-ED          
CBSI          MOVE WS-GL-AR-DEP-ED          TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7185-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00394******************************************************************        
P00394* 7900-SELECT-TOTAL-INT                                          *        
P00394******************************************************************        
P00394*                                                                         
P00394 7900-SELECT-TOTAL-INT.                                           
P00394*                                                                         
P00394     MOVE '7900'              TO ACTIVE-PARAGRAPH.                
P00394*                                                                         
P00394     IF RN-CHECK-ISS-REAS-CD = 'IN'                               
P00394        EXEC SQL                                                  
P00394          SELECT COALESCE(SUM(INTEREST_AMT),0)                    
P00394            INTO :WS-INTEREST-AMT-HOLD                            
P00394            FROM CSS_INTEREST_HIST WITH(READUNCOMMITTED)                  
P00394           WHERE INT_CREDIT_DT    = IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-REFUND
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-REFUND
              ) <> 0) OR (LEN(:WS-DATE-REFUND) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-REFUND
              ), CONVERT(DATE, :WS-DATE-REFUND) )               
P00394             AND ACCOUNT_NO       = :IH-ACCOUNT-NO                
P00394             AND DEPOSIT_CERT_NO  = :IH-DEPOSIT-CERT-NO           
P00394                                                           
P00394                                                      
P00394        END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT COALESCE(SUM(INTEREST_AMT),0)                            
MFA-TR*           INTO :WS-INTEREST-AMT-HOLD                                    
MFA-TR*           FROM CSS_INTEREST_HIST                                        
MFA-TR*          WHERE INT_CREDIT_DT    = :WS-DATE-REFUND                       
MFA-TR*            AND ACCOUNT_NO       = :IH-ACCOUNT-NO                        
MFA-TR*            AND DEPOSIT_CERT_NO  = :IH-DEPOSIT-CERT-NO                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7901                                                     
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
P00394     ELSE                                                         
P00394        EXEC SQL                                                  
P00394          SELECT COALESCE(SUM(IH.INTEREST_AMT),0)                 
P00394            INTO :WS-INTEREST-AMT-HOLD                            
P00394            FROM CSS_INTEREST_HIST IH WITH(READUNCOMMITTED)               
P00394           WHERE IH.INT_CREDIT_DT    = IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-REFUND
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-REFUND
              ) <> 0) OR (LEN(:WS-DATE-REFUND) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-REFUND
              ), CONVERT(DATE, :WS-DATE-REFUND) )            
P00394             AND IH.ACCOUNT_NO       = :IH-ACCOUNT-NO             
P00394             AND IH.DEPOSIT_CERT_NO  = :IH-DEPOSIT-CERT-NO        
P00394             AND IH.ACCOUNT_NO NOT IN ( SELECT RN.ACCOUNT_NO      
P00394                  FROM CSS_REFUND RN WITH(READUNCOMMITTED)                
P00394                 WHERE RN.ACCOUNT_NO      = IH.ACCOUNT_NO         
P00394                  AND RN.DEPOSIT_CERT_NO = IH.DEPOSIT_CERT_NO     
P00394                  AND RN.DATE_REFUNDED   = IH.INT_CREDIT_DT       
P00394                  AND RN.CHECK_ISS_REAS_CD = 'IN')                
P00394                                                           
P00394                                                      
P00394        END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT COALESCE(SUM(IH.INTEREST_AMT),0)                         
MFA-TR*           INTO :WS-INTEREST-AMT-HOLD                                    
MFA-TR*           FROM CSS_INTEREST_HIST IH                                     
MFA-TR*          WHERE IH.INT_CREDIT_DT    = :WS-DATE-REFUND                    
MFA-TR*            AND IH.ACCOUNT_NO       = :IH-ACCOUNT-NO                     
MFA-TR*            AND IH.DEPOSIT_CERT_NO  = :IH-DEPOSIT-CERT-NO                
MFA-TR*            AND IH.ACCOUNT_NO NOT IN ( SELECT RN.ACCOUNT_NO              
MFA-TR*                 FROM CSS_REFUND RN                                      
MFA-TR*                WHERE RN.ACCOUNT_NO      = IH.ACCOUNT_NO                 
MFA-TR*                 AND RN.DEPOSIT_CERT_NO = IH.DEPOSIT_CERT_NO             
MFA-TR*                 AND RN.DATE_REFUNDED   = IH.INT_CREDIT_DT               
MFA-TR*                 AND RN.CHECK_ISS_REAS_CD = 'IN')                        
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7902                                                     
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
P00394     END-IF.                                                      
      *                                                                         
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PCR482        NEXT SENTENCE                                             
PCR482     ELSE                                                         
PCR482        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR482        MOVE 'SELECT'             TO ABEND-FUNCTION               
PCR482        MOVE 'CSS_INTEREST_HIST'  TO TABLE-1                      
P00394        MOVE 'CSS_REFUND'         TO TABLE-2                      
CBSI          MOVE 'INT_CREDIT_DT'      TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-3              
P00394        MOVE 'CHECK_ISS_REAS_CD'  TO TABLE-ELEMENT-4              
CBSI          MOVE WS-DATE-REFUND       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE IH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
CBSI          MOVE IH-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-3            
P00394        MOVE RN-CHECK-ISS-REAS-CD TO HOSTVAR-ELEMENT-4            
PCR482        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PCR482        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PCR482     END-IF.                                                      
      *                                                                         
PCR482 7900-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                         
PCR482**************************************************************************
PCR482* 7950-SELECT-REV-DIST                                           *        
PCR482**************************************************************************
PCR482*                                                                         
PCR482 7950-SELECT-REV-DIST.                                            
      *                                                                         
PCR482     MOVE '7950'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
PCR482     EXEC SQL                                                     
PCR482       SELECT   REV_DISTRICT_DESC                                 
PCR482         INTO   :A9-REV-DISTRICT-DESC                             
PCR482         FROM   CSS_REV_DISTRICT WITH(READUNCOMMITTED)                    
PCR482        WHERE   REV_DISTRICT_CD  =  :WS-HOLD-REV-DIST             
P00394                                                           
P00394                                                      
PCR482     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   REV_DISTRICT_DESC                                         
MFA-TR*        INTO   :A9-REV-DISTRICT-DESC                                     
MFA-TR*        FROM   CSS_REV_DISTRICT                                          
MFA-TR*       WHERE   REV_DISTRICT_CD  =  :WS-HOLD-REV-DIST                     
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7950                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR482       NEXT SENTENCE                                              
PCR482     ELSE                                                         
PCR482       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
PCR482         MOVE SPACES        TO A9-REV-DISTRICT-DESC               
PCR482       ELSE                                                       
PCR482         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PCR482         MOVE 'SELECT'             TO ABEND-FUNCTION              
PCR482         MOVE 'CSS_REV_DISTRICT'   TO TABLE-1                     
CBSI           MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-1             
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
CBSI           MOVE WS-HOLD-REV-DIST     TO HOSTVAR-ELEMENT-1           
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
PCR482         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
PCR482         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
PCR482       END-IF                                                     
PCR482     END-IF.                                                      
      *                                                                         
PCR482 7950-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7975-SELECT-USER-NAME                                          *        
      ******************************************************************        
      *                                                                         
PCR482 7975-SELECT-USER-NAME.                                           
      *                                                                         
PCR482     MOVE '7975'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
PCR482     EXEC SQL                                                     
PCR482       SELECT   FIRST_NAME,                                       
PCR482                MIDDLE_NAME,                                      
PCR482                LAST_NAME                                         
PCR482         INTO   :PF-FIRST-NAME,                                   
PCR482                :PF-MIDDLE-NAME,                                  
PCR482                :PF-LAST-NAME                                     
PCR482         FROM   CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
PCR482        WHERE   USER_ID   =  :PF-USER-ID                          
P00394                                                           
P00394                                                      
PCR482     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               LAST_NAME                                                 
MFA-TR*        INTO   :PF-FIRST-NAME,                                           
MFA-TR*               :PF-MIDDLE-NAME,                                          
MFA-TR*               :PF-LAST-NAME                                             
MFA-TR*        FROM   CSS_USER_PROFILE                                          
MFA-TR*       WHERE   USER_ID   =  :PF-USER-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7975                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR482       NEXT SENTENCE                                              
PCR482     ELSE                                                         
PCR482       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
PCR482         MOVE SPACES        TO PF-FIRST-NAME,                     
PCR482                               PF-LAST-NAME,                      
PCR482                               PF-MIDDLE-NAME                     
PCR482       ELSE                                                       
PCR482         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PCR482         MOVE 'SELECT'             TO ABEND-FUNCTION              
PCR482         MOVE 'CSS_USER_PROFILE'   TO TABLE-1                     
CBSI           MOVE 'USER_ID'            TO TABLE-ELEMENT-1             
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
CBSI           MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1           
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
PCR482         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
PCR482         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
PCR482       END-IF                                                     
PCR482     END-IF.                                                      
      *                                                                         
PCR482 7975-EXIT.                                                       
PCR482     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* 7980-SELECT-DEP-REQ                                            *        
C26296******************************************************************        
C26296*                                                                         
C26296 7980-SELECT-DEP-REQ.                                             
C26296*                                                                         
C26296     MOVE '7980'              TO ACTIVE-PARAGRAPH.                
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296       SELECT   DEP_BILL_OPTION_CD                                
C26296         INTO  :DR-DEP-BILL-OPTION-CD                             
C26296         FROM   CSS_DEP_REQ DR WITH(READUNCOMMITTED)                      
C26296        WHERE   DR.ACCOUNT_NO        = :DR-ACCOUNT-NO             
C26296          AND   DR.PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL      
C26296          AND   DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID            
P00394                                                           
P00394                                                      
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   DEP_BILL_OPTION_CD                                        
MFA-TR*        INTO  :DR-DEP-BILL-OPTION-CD                                     
MFA-TR*        FROM   CSS_DEP_REQ DR                                            
MFA-TR*       WHERE   DR.ACCOUNT_NO        = :DR-ACCOUNT-NO                     
MFA-TR*         AND   DR.PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL              
MFA-TR*         AND   DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID                    
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7980                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
C26296*                                                                         
C26296     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C26296         NEXT SENTENCE                                            
C26296     ELSE                                                         
C26296       IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C26296           MOVE SPACES               TO DR-DEP-BILL-OPTION-CD     
C26296       ELSE                                                       
C26296           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
C26296           MOVE 'SELECT'             TO ABEND-FUNCTION            
C26296           MOVE 'CSS_DEP_REQ'        TO TABLE-1                   
C26296           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
C26296           MOVE 'DEP_ITEM_ID'        TO TABLE-ELEMENT-2           
C26296           MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2           
C26296           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
C26296           MOVE DR-DEP-ITEM-ID       TO HOSTVAR-ELEMENT-2         
C26296           MOVE DR-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2         
C26296           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C26296           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C26296       END-IF                                                     
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7980-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                          *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02159_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02159_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02159_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                               *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02159_R1                        
REARCH           (                                                      
REARCH                RETURN_CODE                                       
REARCH               ,DEPOSIT_CERT_NO                                   
REARCH               ,ORIG_DEP_AMT                                      
REARCH               ,AMT_REFUNDED                                      
REARCH               ,TRANSFER_AMT                                      
REARCH               ,AMT_DEPOSIT                                       
REARCH               ,TRANSFERRED_TO                                    
REARCH               ,DEP_CERT_NO_TO                                    
REARCH               ,TRANSFERRED_FROM                                  
REARCH               ,DEP_CERT_NO_FROM                                  
REARCH               ,SERVICE_TYPE_CD                                   
REARCH               ,REPEAT_COUNT                                      
REARCH               ,DATE_TRANS                                        
REARCH               ,AMT_POSTED                                        
REARCH               ,DEP_PAY_DT                                        
REARCH               ,DEP_PAY_AMT                                       
REARCH               ,INT_CREDIT_DT                                     
REARCH               ,INTEREST_AMT                                      
REARCH               ,INTEREST_RT                                       
REARCH               ,EFFECTIVE_DT                                      
REARCH               ,REV_DISTRICT_DESC                                 
REARCH               ,DATE_REFUND                                       
REARCH               ,MANUAL_INDICATOR                                  
REARCH               ,[DEP-AMT_REFUNDED]                                  
REARCH               ,[INT-AMT_REFUNDED]                                  
REARCH               ,[TOT-AMT_REFUNDED]                                  
REARCH               ,[CHECK_ISS-REAS_CD]                                 
REARCH               ,CHECK_STATUS_CD                                   
REARCH               ,[USER_NAME-RQTED_BY]                                
REARCH               ,USER_NAME_APRVD_BY                                
REARCH               ,ACCT_NO_CREDITED                                  
REARCH               ,COMMENTS                                          
REARCH               ,DEPOSIT_STATUS_CD                                 
REARCH               ,DATE_TRAN                                         
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-DEPOSIT-CERT-NO                                
REARCH               ,:S-ORIG-DEP-AMT                                   
REARCH               ,:S-AMT-REFUNDED                                   
REARCH               ,:S-TRANSFER-AMT                                   
REARCH               ,:S-AMT-DEPOSIT                                    
REARCH               ,:S-TRANSFERRED-TO                                 
REARCH               ,:S-DEP-CERT-NO-TO                                 
REARCH               ,:S-TRANSFERRED-FROM                               
REARCH               ,:S-DEP-CERT-NO-FROM                               
REARCH               ,:S-SERVICE-TYPE-CD                                
REARCH               ,:S-REPEAT-COUNT                                   
REARCH               ,:S-DATE-TRANS                                     
REARCH               ,:S-AMT-POSTED                                     
REARCH               ,:S-DEP-PAY-DT                                     
REARCH               ,:S-DEP-PAY-AMT                                    
REARCH               ,:S-INT-CREDIT-DT                                  
REARCH               ,:S-INTEREST-AMT                                   
REARCH               ,:S-INTEREST-RT                                    
REARCH               ,:S-EFFECTIVE-DT                                   
REARCH               ,:S-REV-DISTRICT-DESC                              
REARCH               ,:S-DATE-REFUND                                    
REARCH               ,:S-MANUAL-INDICATOR                               
REARCH               ,:S-DEP-AMT-REFUNDED                               
REARCH               ,:S-INT-AMT-REFUNDED                               
REARCH               ,:S-TOT-AMT-REFUNDED                               
REARCH               ,:S-CHECK-ISS-REAS-CD                              
REARCH               ,:S-CHECK-STATUS-CD                                
REARCH               ,:S-USER-NAME-RQSTED-BY                            
REARCH               ,:S-USER-NAME-APPRVD-BY                            
REARCH               ,:S-ACCT-NO-CREDITED                               
REARCH               ,:S-COMMENTS                                       
REARCH               ,:S-DEPOSIT-STATUS-CD                              
REARCH               ,:S-DATE-TRAN                                      
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02159_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,ORIG_DEP_AMT                                              
MFA-TR*              ,AMT_REFUNDED                                              
MFA-TR*              ,TRANSFER_AMT                                              
MFA-TR*              ,AMT_DEPOSIT                                               
MFA-TR*              ,TRANSFERRED_TO                                            
MFA-TR*              ,DEP_CERT_NO_TO                                            
MFA-TR*              ,TRANSFERRED_FROM                                  .       
MFA-TR*              ,DEP_CERT_NO_FROM                                  .       
MFA-TR*              ,SERVICE_TYPE_CD                                           
MFA-TR*              ,REPEAT_COUNT                                              
MFA-TR*              ,DATE_TRANS                                                
MFA-TR*              ,AMT_POSTED                                                
MFA-TR*              ,DEP_PAY_DT                                                
MFA-TR*              ,DEP_PAY_AMT                                               
MFA-TR*              ,INT_CREDIT_DT                                             
MFA-TR*              ,INTEREST_AMT                                      0.      
MFA-TR*              ,INTEREST_RT                                               
MFA-TR*              ,EFFECTIVE_DT                                              
MFA-TR*              ,REV_DISTRICT_DESC                                         
MFA-TR*              ,DATE_REFUND                                               
MFA-TR*              ,MANUAL_INDICATOR                                          
MFA-TR*              ,DEP-AMT_REFUNDED                                          
MFA-TR*              ,INT-AMT_REFUNDED                                          
MFA-TR*              ,TOT-AMT_REFUNDED                                          
MFA-TR*              ,CHECK_ISS-REAS_CD                                         
MFA-TR*              ,CHECK_STATUS_CD                                           
MFA-TR*              ,USER_NAME-RQTED_BY                                        
MFA-TR*              ,USER_NAME_APRVD_BY                                        
MFA-TR*              ,ACCT_NO_CREDITED                                          
MFA-TR*              ,COMMENTS                                                  
MFA-TR*              ,DEPOSIT_STATUS_CD                                         
MFA-TR*              ,DATE_TRAN                                         02402000
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-DEPOSIT-CERT-NO                                        
MFA-TR*              ,:S-ORIG-DEP-AMT                                           
MFA-TR*              ,:S-AMT-REFUNDED                                           
MFA-TR*              ,:S-TRANSFER-AMT                                           
MFA-TR*              ,:S-AMT-DEPOSIT                                            
MFA-TR*              ,:S-TRANSFERRED-TO                                         
MFA-TR*              ,:S-DEP-CERT-NO-TO                                         
MFA-TR*              ,:S-TRANSFERRED-FROM                               .       
MFA-TR*              ,:S-DEP-CERT-NO-FROM                               .       
MFA-TR*              ,:S-SERVICE-TYPE-CD                                        
MFA-TR*              ,:S-REPEAT-COUNT                                           
MFA-TR*              ,:S-DATE-TRANS                                             
MFA-TR*              ,:S-AMT-POSTED                                             
MFA-TR*              ,:S-DEP-PAY-DT                                             
MFA-TR*              ,:S-DEP-PAY-AMT                                            
MFA-TR*              ,:S-INT-CREDIT-DT                                          
MFA-TR*              ,:S-INTEREST-AMT                                   0.      
MFA-TR*              ,:S-INTEREST-RT                                            
MFA-TR*              ,:S-EFFECTIVE-DT                                           
MFA-TR*              ,:S-REV-DISTRICT-DESC                                      
MFA-TR*              ,:S-DATE-REFUND                                            
MFA-TR*              ,:S-MANUAL-INDICATOR                                       
MFA-TR*              ,:S-DEP-AMT-REFUNDED                                       
MFA-TR*              ,:S-INT-AMT-REFUNDED                                       
MFA-TR*              ,:S-TOT-AMT-REFUNDED                                       
MFA-TR*              ,:S-CHECK-ISS-REAS-CD                                      
MFA-TR*              ,:S-CHECK-STATUS-CD                                        
MFA-TR*              ,:S-USER-NAME-RQSTED-BY                                    
MFA-TR*              ,:S-USER-NAME-APPRVD-BY                                    
MFA-TR*              ,:S-ACCT-NO-CREDITED                                       
MFA-TR*              ,:S-COMMENTS                                               
MFA-TR*              ,:S-DEPOSIT-STATUS-CD                                      
MFA-TR*              ,:S-DATE-TRAN                                      02402000
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02159_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    END PROGRAM COPYLIB                                         *        
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
      *                                                                         
