       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02157.                                     
COB303 DATE-WRITTEN.      JUNE 27, 2005.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S157                                           *        
      *  PROGRAM:       S157                                           *        
      *  CALLING SP:    PA_S157                                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES SURETY BOND / LETTER OF CREDIT DETAILS   *        
      *  FOR A CUSTOMER ACCOUNT. ONE BOND MAY HAVE MORE THAN ONE       *        
      *  ACCOUNT ATTACHED TO IT. ALL THOSE ACCOUNT NUMBERS AND         *        
      *  CORRESPONDING SURETY AMOUNTS ARE SENT TO THE RPC AS ONE       *        
      *  STRING SO THAT THE UPDATES CAN BE PERFORMED AS SINGLE         *        
      *  TRANSACTION.                                                  *        
      *                                                                *        
      *  PARAMETERS:                                                   *        
      *    USERID                                                      *        
      *    RESP-AREA-ID                                                *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE                                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/18/95    SK       RPC ORIGINALLY ADDED.                    *        
      *  01/08/96    PD       ADDED NULL INDICATOR TO 7000- PARA       *        
      *  05/06/96    CDS      PCR195 - MODIFIED TO SELECT GUARANTORS   *        
      *                       WITH ONLY ACTIVE AND NOT PENDING STATUS  *        
T15584*  04/01/98    AMG      - CHANGED THE OCCURS STATEMENT FROM 10   *        
      *                       TO 110 FOR SB-ACCT-DETAIL.  MUST BE THE  *        
      *                       SAME AS (OR MORE THAN) LL_MAX_ROWS IN    *        
      *                       UE_EDITINSERT FOR PANEL 247.             *        
      *                       - ALSO CHANGED THE NUMBER OF PARAMETERS  *        
      *                       RECEIVED TO BREAK UP THE ACCT_DETAIL     *        
      *                       PARM IN ORDER TO GET AROUND THE 255 CHAR *        
      *                       LIMIT FOR A STRING PASSED FROM PB        *        
      *                       THROUGH CICS.                            *        
CBSI  *  08/29/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
REARCH*  06/27/05    CVNS     RPC TO DB2 SP CONVERSION.                *        
REARCH*              CHENNAI                                           *        
T35434*  07/10/07    MK92804  REPLACED MODEL_SQL TO SET STATEMENT AND  *        
T35434*                       ADDED FOR FETCH ONLY WITH UR FOR CURSORS *        
T35434*                       AND WITH UR FOR SELECT STATEMENTS.       *        
P26289*  06/24/08    RB19957  FOR THE EXPIRATION DATE ON AN INSERT     *        
P26289*          RICK BLACK   OR READ THE NEW CODE WILL READ THE       *        
P26289*                       DELINQUENCY TABLE AND ADD THAT AMOUNT TO *        
P26289*                       THE START DATE TO GET A EXPIRATION DATE. *        
P26289*  07/10/08    RB19957  LAST UPDATE INFORMATION WILL STORED BE IN*        
P26289*          RICK BLACK   THE TWO NEW SURETY BOND TABLE COLUMNS.   *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02157'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02157 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_SURETY_BOND  - SB >                                             
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT      - AT>                                              
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_USER_PROFILE  - PF >                                            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_GUARANTOR     - GU >                                            
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
P26289*---< CSS_CSS_DELINQUENCY C8 >                                            
P26289     EXEC SQL                                                             
P26289        INCLUDE TBDELQ                                                    
P26289     END-EXEC.                                                            
P26289                                                                  
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      * ADDED FOR JOURNALING                                                    
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      *---  WS LAYOUT FOR CODES-DATA-PRESENT IN CSS_ACCOUNT                     
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02157_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-BOND-TOT-AMT-TEMP  PIC X(11).                       
REARCH     05  PARM-BOND-TOTAL-AMT-R   REDEFINES PARM-BOND-TOT-AMT-TEMP 
                                       PIC 9(9)V9(2).                   
COB305     05 PARM-BOND-TOTAL-AMT-N        PIC S9(09)V9(02) 
COB305       USAGE COMP-3 VALUE 0.   
           05  PARM-ACCT-DETAIL.                                        
T15584         10  SB-ACCT-DETAIL OCCURS 110 TIMES.                     
                   20  PARM-ACTION-CODE   PIC X(01).                    
                   20  PARM-ACCT-NO       PIC X(13).                    
                   20  PARM-BOND-AMT      PIC X(11).                    
           05  PARM-TRAN-COMMENT.                                       
               49  PARM-TRAN-COMMENT-LEN                                
                                   PIC S9(04) COMP SYNC VALUE +0.       
               49  PARM-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.      
                                                                        
       01  WS-MISC.                                                     
           05  WS-BOND-AMT             PIC X(11).                       
           05  WS-BOND-AMT-R           REDEFINES WS-BOND-AMT            
                                       PIC 9(9)V9(2).                   
COB305     05 WS-BOND-AMT-N        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.     
           05  WS-WAIV-ITEM-ID         PIC S9(9) USAGE COMP.            
           05  WS-AMOUNT-X             PIC ZZZZZZZZ9.99.                
COB305     05 WS-BOND-CO-NO        PIC S9(6)V USAGE COMP-3 VALUE 0.         
           05  WS-ACCT-CNT             PIC 99.                          
           05  WS-USER-ID-ORIG-BY      PIC X(07).                       
           05  WS-ORIGINATED-BY        PIC X(20) VALUE SPACE.           
           05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
P26289     05  WS-SB-COMMENT.                                           
P26289         10  WS-SB-COMMENT-A     PIC X(15)                        
P26289                                 VALUE 'SURETY BOND NO '.         
P26289         10  WS-SB-COMMENT-B     PIC X(16) VALUE SPACES.          
P26289         10  WS-SB-COMMENT-C     PIC X(3) VALUE ' ; '.            
P26289         10  WS-SB-COMMENT-D     PIC X(176) VALUE SPACES.         
P26289     05  WS-ILOC-COMMENT.                                         
P26289         10  WS-ILOC-COMMENT-A   PIC X(10)                        
P26289                                 VALUE 'LETTER NO '.              
P26289         10  WS-ILOC-COMMENT-B   PIC X(16) VALUE SPACES.          
P26289         10  WS-ILOC-COMMENT-C   PIC X(3) VALUE ' ; '.            
P26289         10  WS-ILOC-COMMENT-D   PIC X(181) VALUE SPACES.         
P26289     05  WS-LIMIT-MONTH          PIC S9(04) COMP.                 
P26289     05  WS-DEPOSIT-TYPE         PIC X(1).                        
P26289         88 WS-COM-IND-DEPOSIT          VALUE 'C'                 
P26289                                              'I'.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-WAIV-ITEM-ID          PIC X(09) VALUE SPACES.          
REARCH     05  S-ORIGINATED-BY         PIC X(20) VALUE SPACE.           
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-DATE-BOND-ISSUED-NI    PIC S9(4) COMP VALUE 0.        
           05  WS-TRIGGER-DATE-NI        PIC S9(4) COMP VALUE 0.        
           05  WS-BOND-EXPIRATION-DT-NI  PIC S9(4) COMP VALUE 0.        
           05  WS-BOND-WAIV-ITEM-ID-NI   PIC S9(4) COMP VALUE 0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SECURITY-EXISTS-SW      PIC X(01) VALUE 'N'.             
               88 SECURITY-EXISTS                VALUE 'Y'.             
               88 NO-SECURITY-EXISTS             VALUE 'N'.             
P26289     05  MAN-UPDATE-EXPIRE-DT-SW PIC X(01) VALUE 'N'.             
P26289         88 MAN-UPDATE-EXPIRE-DT           VALUE 'Y'.             
P26289         88 NO-MAN-UPDATE-EXPIRE-DT        VALUE 'N'.             
                                                                        
       01  WS-MISC1.                                                    
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
                                                                        
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02157'.     
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                  
              SELECT 'Y'                                                
               FROM  CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO  AND                  
                     CODE_STATUS = :WS-ACTIVE                           
               OPTION(FAST 1)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR*    EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                          
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        FROM  CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO  AND                          
MFA-TR*              CODE_STATUS = :WS-ACTIVE                                   
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                   
              SELECT 'Y'                                                
              FROM   CSS_GUARANTOR                                      
              WHERE  ACCOUNT_NO     = :GU-ACCOUNT-NO AND                
                     GUAR_STATUS_CD = :WS-ACTIVE                        
              OPTION(FAST 1)                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR*    EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                           
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       FROM   CSS_GUARANTOR                                              
MFA-TR*       WHERE  ACCOUNT_NO     = :GU-ACCOUNT-NO AND                        
MFA-TR*              GUAR_STATUS_CD = :WS-ACTIVE                                
MFA-TR*       OPTIMIZE FOR 1 ROW                                                
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-BOND-TYPE          PIC X(01).                           
REARCH 01  PARM-BOND-ACTION-CODE   PIC X(01).                           
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-BOND-CO-NO         PIC X(06).                           
REARCH 01  PARM-BOND-STATUS        PIC X(01).                           
REARCH 01  PARM-TRIGGER-DATE       PIC X(10).                           
REARCH 01  PARM-CODE-STATUS-REAS   PIC X(20).                           
REARCH 01  PARM-BOND-NO            PIC X(16).                           
REARCH 01  PARM-BOND-TOTAL-AMT     PIC X(11).                           
REARCH 01  PARM-ISSUE-DATE         PIC X(10).                           
REARCH 01  PARM-EXPIRATION-DATE    PIC X(10).                           
REARCH 01  PARM-WAIV-ITEM-ID       PIC X(09).                           
REARCH 01  PARM-ACCT-DETAIL1       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL2       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL3       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL4       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL5       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL6       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL7       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL8       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL9       PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL10      PIC X(250).                          
REARCH 01  PARM-ACCT-DETAIL11      PIC X(250).                          
REARCH 01  PARM-USER-ID            PIC X(09).                           
REARCH 01  PARM-RESP-AREA-ID       PIC X(03).                           
REARCH 01  PARM-TRAN-CMNT-LEN      PIC S9(04) COMP.                     
REARCH 01  PARM-TRAN-CMNT-TEXT     PIC X(210).                          
REARCH PROCEDURE DIVISION USING PARM-BOND-TYPE                          
REARCH                          PARM-BOND-ACTION-CODE                   
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-BOND-CO-NO                         
REARCH                          PARM-BOND-STATUS                        
REARCH                          PARM-TRIGGER-DATE                       
REARCH                          PARM-CODE-STATUS-REAS                   
REARCH                          PARM-BOND-NO                            
REARCH                          PARM-BOND-TOTAL-AMT                     
REARCH                          PARM-ISSUE-DATE                         
REARCH                          PARM-EXPIRATION-DATE                    
REARCH                          PARM-WAIV-ITEM-ID                       
REARCH                          PARM-ACCT-DETAIL1                       
REARCH                          PARM-ACCT-DETAIL2                       
REARCH                          PARM-ACCT-DETAIL3                       
REARCH                          PARM-ACCT-DETAIL4                       
REARCH                          PARM-ACCT-DETAIL5                       
REARCH                          PARM-ACCT-DETAIL6                       
REARCH                          PARM-ACCT-DETAIL7                       
REARCH                          PARM-ACCT-DETAIL8                       
REARCH                          PARM-ACCT-DETAIL9                       
REARCH                          PARM-ACCT-DETAIL10                      
REARCH                          PARM-ACCT-DETAIL11                      
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-TRAN-CMNT-LEN                      
REARCH                          PARM-TRAN-CMNT-TEXT.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE      AS  RETURN_CODE                  
REARCH            ,:S-WAIV-ITEM-ID     AS  WAIV_ITEM_ID                 
REARCH            ,:S-ORIGINATED-BY    AS  ORIGINATED_BY                
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE      AS  RETURN_CODE                          
MFA-TR*           ,:S-WAIV-ITEM-ID     AS  WAIV_ITEM_ID                         
MFA-TR*           ,:S-ORIGINATED-BY    AS  ORIGINATED_BY                        
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *        
      *     2.  FORMAT PACKED NUMERICS.                                *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
T15584     INITIALIZE PARM-ACCT-DETAIL.                                 
T15584     STRING PARM-ACCT-DETAIL1  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL2  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL3  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL4  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL5  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL6  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL7  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL8  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL9  DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL10 DELIMITED BY ' '                   
T15584            PARM-ACCT-DETAIL11 DELIMITED BY ' '                   
T15584       INTO PARM-ACCT-DETAIL.                                     
                                                                        
REARCH     MOVE PARM-TRAN-CMNT-LEN      TO PARM-TRAN-COMMENT-LEN.       
REARCH     MOVE PARM-TRAN-CMNT-TEXT     TO PARM-TRAN-COMMENT-TEXT.      
REARCH     MOVE PARM-BOND-TOTAL-AMT     TO PARM-BOND-TOT-AMT-TEMP.      
           MOVE PARM-WAIV-ITEM-ID       TO WS-WAIV-ITEM-ID.             
           MOVE PARM-BOND-TOTAL-AMT-R   TO PARM-BOND-TOTAL-AMT-N.       
           MOVE PARM-BOND-TOTAL-AMT-R   TO WS-AMOUNT-X.                 
           MOVE PARM-BOND-CO-NO         TO WS-BOND-CO-NO.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   2000-PROCESS-OUTPUT                                          *        
      *                                                                *        
      *       1. DESCRIBE RESULT SET                                   *        
      *       2. UPDATE DB2 DATA                                       *        
      *       3. BUILD RESULT SET                                      *        
      *       4. SEND RESULT SET                                       *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE.            
           MOVE WS-WAIV-ITEM-ID            TO S-WAIV-ITEM-ID.           
           MOVE WS-ORIGINATED-BY           TO S-ORIGINATED-BY.          
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
REARCH     ADD +1                          TO   CTR-ROWS.               
P26289     MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
REARCH*    PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   5000-UPDATE.                                                 *        
      *                                                                *        
      *       1.   BASED ON THE ACTION CODE (INSERT/UPDATE/DELETE),    *        
      *            PERFORM FUNCTIONALITY.                              *        
      *                                                                *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           MOVE 1                TO WS-ACCT-CNT.                        
                                                                        
      *--- GET THE USER-ID OF THE USER WHO CREATED THE BOND FOR THE             
      *--- FIRST TIME                                                           
           IF PARM-BOND-ACTION-CODE = 'U'                               
P26289        MOVE WS-WAIV-ITEM-ID      TO SB-BOND-WAIV-ITEM-ID         
P26289        MOVE PARM-ACCOUNT-NO      TO SB-ACCOUNT-NO                
P26289        PERFORM 7100-SELECT-SURETY-BOND  THRU 7100-EXIT           
P26289        IF PARM-ISSUE-DATE = SB-DATE-BOND-ISSUED AND              
P26289           PARM-EXPIRATION-DATE NOT = SB-BOND-EXPIRATION-DT       
P26289            MOVE 'Y' TO MAN-UPDATE-EXPIRE-DT-SW                   
P26289        ELSE                                                      
P26289            MOVE 'N' TO MAN-UPDATE-EXPIRE-DT-SW                   
P26289        END-IF                                                    
              IF WS-WAIV-ITEM-ID = 0                                    
                 MOVE PARM-USER-ID         TO WS-USER-ID-ORIG-BY        
              ELSE                                                      
                 MOVE SB-USER-ID-ORIG-BY   TO WS-USER-ID-ORIG-BY        
              END-IF                                                    
           END-IF                                                       
                                                                        
      *--- FOR NEW BOND/LETTER OF CREDIT GET NEXT WAIV-ITEM-ID                  
           IF WS-WAIV-ITEM-ID = 0                                       
              PERFORM 7000-GET-WAIV-ITEM-ID     THRU 7000-EXIT          
              MOVE SB-BOND-WAIV-ITEM-ID    TO WS-WAIV-ITEM-ID           
              ADD  1                       TO WS-WAIV-ITEM-ID           
              MOVE PARM-USER-ID            TO PF-USER-ID                
              PERFORM 7200-SELECT-USER-PROFILE  THRU 7200-EXIT          
           END-IF.                                                      
                                                                        
      *--- FOR EACH ACCOUNT ATTACHED TO THE BOND / LETTER CREATE                
      *--- APPROPRIATE JOURNAL RECORDS AND UPDATE SURETY_BOND TABLE             
                                                                        
           PERFORM                                                      
T15584        UNTIL WS-ACCT-CNT > 110 OR                                
T15584              PARM-ACTION-CODE(WS-ACCT-CNT) = SPACES              
                                                                        
              MOVE PARM-ACCT-NO(WS-ACCT-CNT)   TO SB-ACCOUNT-NO         
                                                  AT-ACCOUNT-NO         
                                                  GU-ACCOUNT-NO         
              MOVE PARM-BOND-AMT(WS-ACCT-CNT)  TO WS-BOND-AMT           
              MOVE WS-BOND-AMT-R               TO WS-BOND-AMT-N         
              MOVE WS-BOND-AMT-R               TO WS-AMOUNT-X           
                                                                        
              PERFORM 5100-JRNL-TRAN-HEAD         THRU 5100-EXIT        
                                                                        
              MOVE WS-WAIV-ITEM-ID        TO SB-BOND-WAIV-ITEM-ID       
                                                                        
              IF PARM-ACTION-CODE(WS-ACCT-CNT) = 'U' OR 'I'             
                 IF PARM-ACTION-CODE(WS-ACCT-CNT) = 'I'                 
                    PERFORM 6000-JRNL-INSERT-BOND  THRU 6000-EXIT       
                 ELSE                                                   
                    PERFORM 7100-SELECT-SURETY-BOND   THRU 7100-EXIT    
                    PERFORM 6010-JRNL-UPDATE-BOND  THRU 6010-EXIT       
                 END-IF                                                 
                                                                        
                 MOVE PARM-BOND-TYPE        TO SB-CODE-BOND-TYPE        
                 MOVE PARM-BOND-NO          TO SB-BOND-NO               
                 MOVE PARM-ISSUE-DATE       TO SB-DATE-BOND-ISSUED      
                 IF PARM-ISSUE-DATE = SPACES                            
                    MOVE -1                 TO WS-DATE-BOND-ISSUED-NI   
                 ELSE                                                   
                    MOVE +0                 TO WS-DATE-BOND-ISSUED-NI   
                 END-IF                                                 
                 MOVE PARM-BOND-CO-NO       TO SB-BOND-CO-NO            
                 MOVE PARM-BOND-STATUS      TO SB-CODE-STATUS           
                 MOVE PARM-CODE-STATUS-REAS TO SB-CODE-STATUS-REAS      
                 MOVE PARM-BOND-TOTAL-AMT-N TO SB-BOND-TOTAL-AMT        
                 MOVE PARM-TRIGGER-DATE     TO SB-TRIGGER-DATE          
                 IF PARM-TRIGGER-DATE = SPACES                          
                    MOVE -1                 TO WS-TRIGGER-DATE-NI       
                 ELSE                                                   
                    MOVE +0                 TO WS-TRIGGER-DATE-NI       
                 END-IF                                                 
                 MOVE PARM-EXPIRATION-DATE  TO SB-BOND-EXPIRATION-DT    
                 IF PARM-EXPIRATION-DATE = SPACES                       
                    MOVE -1                 TO WS-BOND-EXPIRATION-DT-NI 
                 ELSE                                                   
                    MOVE +0                 TO WS-BOND-EXPIRATION-DT-NI 
                 END-IF                                                 
                 MOVE WS-BOND-AMT-N         TO SB-AMT-BOND              
P26289           PERFORM 7350-SELECT-ACCOUNT-TYPE THRU 7350-EXIT        
P26289           MOVE AT-ACCOUNT-TYPE-CODE TO WS-DEPOSIT-TYPE           
P26289           IF WS-COM-IND-DEPOSIT AND                              
P26289              SB-DATE-BOND-ISSUED NOT = SPACES AND                
P26289              NO-MAN-UPDATE-EXPIRE-DT                             
P26289              MOVE +0 TO WS-BOND-EXPIRATION-DT-NI                 
P26289              MOVE AT-COMPANY-NO TO  C8-COMPANY-NO                
P26289              IF AT-ACCOUNT-TYPE-CODE = 'C'                       
P26289                 MOVE 'RETAIN-COMMER-DEP' TO  C8-DELINQ-CD        
P26289              ELSE                                                
P26289                 MOVE 'RETAIN-INDUST-DEP' TO  C8-DELINQ-CD        
P26289              END-IF                                              
P26289              PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT        
P26289              MOVE C8-DELINQ-VALUE TO WS-LIMIT-MONTH              
P26289              PERFORM 7375-SET-EXPIRE-DATE THRU 7375-EXIT         
P26289           END-IF                                                 
P26289           PERFORM 5150-LOAD-UPDT-DATE THRU 5150-EXIT             
P26289           MOVE PARM-USER-ID TO SB-LAST-UPDATE-USERID             
P26289           IF PARM-ACTION-CODE(WS-ACCT-CNT) = 'I'                 
                    PERFORM 8200-INSERT-SURETY-BOND    THRU 8200-EXIT   
                 ELSE                                                   
P26289              IF MAN-UPDATE-EXPIRE-DT                             
P26289                MOVE +0 TO WS-BOND-EXPIRATION-DT-NI               
P26289                MOVE PARM-EXPIRATION-DATE TO SB-BOND-EXPIRATION-DT
P26289              END-IF                                              
                    PERFORM 8210-UPDATE-SURETY-BOND    THRU 8210-EXIT   
                 END-IF                                                 
                                                                        
                 PERFORM 7300-SELECT-ACCOUNT      THRU 7300-EXIT        
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
                 IF PARM-BOND-STATUS = WS-ACTIVE                        
                    MOVE 'A'                TO WS-CODE-SEC-ACCT         
                 ELSE                                                   
                    PERFORM 5050-CHECK-SEC-DEP   THRU 5050-EXIT         
                    IF NO-SECURITY-EXISTS                               
                       MOVE SPACES             TO WS-CODE-SEC-ACCT      
                    END-IF                                              
                 END-IF                                                 
                 MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT    
                 PERFORM 8300-UPDATE-ACCOUNT      THRU 8300-EXIT        
              END-IF                                                    
                                                                        
              IF PARM-ACTION-CODE(WS-ACCT-CNT) = 'D'                    
                 PERFORM 6020-JRNL-DELETE-BOND      THRU 6020-EXIT      
                 PERFORM 8220-DELETE-SURETY-BOND    THRU 8220-EXIT      
                                                                        
                 PERFORM 7300-SELECT-ACCOUNT      THRU 7300-EXIT        
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
                 PERFORM 5050-CHECK-SEC-DEP   THRU 5050-EXIT            
                 IF NO-SECURITY-EXISTS                                  
                    MOVE SPACES             TO WS-CODE-SEC-ACCT         
                 END-IF                                                 
                 MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT    
                 PERFORM 8300-UPDATE-ACCOUNT      THRU 8300-EXIT        
              END-IF                                                    
                                                                        
              ADD 1                   TO WS-ACCT-CNT                    
           END-PERFORM.                                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5050-CHECK-SEC-DEP                                            *         
      *                                                               *         
      *      CHECK FOR EXISTENCE OF ANY SECURITIES IN CSS_SURETY_BOND *         
      *      OR ANY GUARANTOR DETAIL IN CSS_GUARANTOR TABLE. IF ANY   *         
      *      OF THESE EXISTS THEN THE SECURED-ACCOUNT-INDICATOR       *         
      *      IN CODES-DATA-PRESENT COLUMN OF CSS_ACCOUNT SHOULD NOT   *         
      *      BE MODIFIED                                              *         
      *****************************************************************         
       5050-CHECK-SEC-DEP.                                              
                                                                        
           MOVE 'N'         TO SECURITY-EXISTS-SW.                      
           PERFORM 7400-OPEN-SURETY-CURSOR     THRU 7400-EXIT.          
           PERFORM 7410-FETCH-SURETY-CURSOR    THRU 7410-EXIT.          
           PERFORM 7420-CLOSE-SURETY-CURSOR    THRU 7420-EXIT.          
           IF NO-SECURITY-EXISTS                                        
              PERFORM 7430-OPEN-GUARNT-CURSOR     THRU 7430-EXIT        
              PERFORM 7440-FETCH-GUARNT-CURSOR    THRU 7440-EXIT        
              PERFORM 7450-CLOSE-GUARNT-CURSOR    THRU 7450-EXIT        
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   5100-JRNL-TRAN-HEAD.                                         *        
      *                                                                *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      *                                                                *        
      ******************************************************************        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
           IF PARM-TRAN-COMMENT-TEXT = SPACES                           
              MOVE ZERO                   TO MH-TRAN-COMMENT-LEN        
           ELSE                                                         
              MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN        
           END-IF.                                                      
P26289     EVALUATE PARM-BOND-TYPE                                      
P26289      WHEN 'A'                                                    
P26289        MOVE PARM-BOND-NO TO WS-SB-COMMENT-B                      
P26289        IF MH-TRAN-COMMENT-LEN = ZERO                             
P26289           MOVE SPACES TO WS-SB-COMMENT-C                         
P26289        END-IF                                                    
P26289        MOVE PARM-TRAN-COMMENT-TEXT TO WS-SB-COMMENT-D            
P26289        MOVE WS-SB-COMMENT TO MH-TRAN-COMMENT-TEXT                
P26289        COMPUTE MH-TRAN-COMMENT-LEN = MH-TRAN-COMMENT-LEN + 34    
P26289      WHEN 'B'                                                    
P26289        MOVE PARM-BOND-NO TO WS-ILOC-COMMENT-B                    
P26289        IF MH-TRAN-COMMENT-LEN = ZERO                             
P26289           MOVE SPACES TO WS-ILOC-COMMENT-C                       
P26289        END-IF                                                    
P26289        MOVE PARM-TRAN-COMMENT-TEXT TO WS-ILOC-COMMENT-D          
P26289        MOVE WS-ILOC-COMMENT TO MH-TRAN-COMMENT-TEXT              
P26289        COMPUTE MH-TRAN-COMMENT-LEN = MH-TRAN-COMMENT-LEN + 29    
P26289      WHEN OTHER                                                  
P26289       MOVE PARM-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-TEXT        
P26289     END-EVALUATE.                                                
           MOVE SB-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
           MOVE ZEROES                    TO MH-CUSTOMER-NO.            
           MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
           MOVE 'PANEL247'                TO MH-APPL-PROGRAM-ID.        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P26289******************************************************************        
P26289*   5150-LOAD-UPDT-DATE.                                         *        
P26289*                                                                *        
P26289*   GET THE CURRENT DATE FOR UPDATE DATE.                        *        
P26289*                                                                *        
P26289******************************************************************        
P26289 5150-LOAD-UPDT-DATE.                                             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :SB-LAST-UPDATE-DT                      
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :SB-LAST-UPDATE-DT= CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P26289        NEXT SENTENCE                                             
P26289     ELSE                                                         
P26289        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P26289        MOVE '5150'                TO ACTIVE-PARAGRAPH            
P26289        MOVE 'SET'                 TO ABEND-FUNCTION              
P26289        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P26289                                      ABEND-TABLES                
P26289        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P26289        MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
P26289        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P26289        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P26289     END-IF.                                                      
P26289*                                                                         
P26289 5150-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
      ******************************************************************        
      * 6000-JRNL-INSERT-BOND                                          *        
      *                                                                *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       6000-JRNL-INSERT-BOND.                                           
                                                                        
           MOVE '6000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_CO_NO >                              
           IF PARM-BOND-CO-NO > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-BOND-CO-NO                            
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-BOND-CO-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BANK/BOND CO NAME'   TO MI-COLUMN-DESC              
              MOVE 'BO'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_STATUS >                             
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-BOND-STATUS TO                           
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE PARM-BOND-STATUS      TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'BOND STATUS'         TO MI-COLUMN-DESC.                
           MOVE '56'                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < TRIGGER_DATE >                            
           IF PARM-TRIGGER-DATE > SPACES                                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-TRIGGER-DATE                          
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-TRIGGER-DATE      TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'TRIGGER DATE'         TO MI-COLUMN-DESC             
              MOVE SPACES                 TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_STATUS_REAS >                        
           IF PARM-CODE-STATUS-REAS  > SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF PARM-CODE-STATUS-REAS                      
                                      TO MI-CHG-COLUMN-VALUE-LEN        
              MOVE PARM-CODE-STATUS-REAS TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'STATUS REASON  '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_NO >                                 
           IF PARM-BOND-CO-NO > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-BOND-NO                               
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-BOND-NO          TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BOND/LETTER NO '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_TOTAL_AMT >                          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE PARM-BOND-TOTAL-AMT-N TO WS-AMOUNT-X.                   
           MOVE WS-AMOUNT-X           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'TOTAL AMOUNT'        TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < DATE_BOND_ISSUED >                        
           IF PARM-ISSUE-DATE > SPACES                                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ISSUE-DATE                            
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ISSUE-DATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ISSUE DATE     '      TO MI-COLUMN-DESC             
              MOVE SPACES                 TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_EXPIRATION_DT >                      
           IF PARM-EXPIRATION-DATE > SPACES                             
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-EXPIRATION-DATE                       
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-EXPIRATION-DATE   TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'EXPIRATION DATE'      TO MI-COLUMN-DESC             
              MOVE SPACES                 TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_AMT >                                
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF WS-AMOUNT-X TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE WS-BOND-AMT-R         TO WS-AMOUNT-X.                   
           MOVE WS-AMOUNT-X           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'SURETY AMOUNT'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6010-JRNL-UPDATE-BOND                                          *        
      *                                                                *        
      * 1.   JOURNAL ANY FIELDS THAT THE USER HAS CHANGED BY FORMATING *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       6010-JRNL-UPDATE-BOND.                                           
                                                                        
           MOVE '6010' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_CO_NO >                              
           IF WS-BOND-CO-NO  NOT = SB-BOND-CO-NO                        
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE LENGTH OF PARM-BOND-CO-NO                            
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                                                MI-PRV-COLUMN-VALUE-LEN 
              MOVE PARM-BOND-CO-NO     TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE SB-BOND-CO-NO       TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'BANK/BOND CO NO'         TO MI-COLUMN-DESC          
              MOVE 'BO'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_STATUS >                             
           IF PARM-BOND-STATUS NOT = SB-CODE-STATUS                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-BOND-STATUS TO                        
                                            MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-BOND-STATUS      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-CODE-STATUS        TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BOND STATUS    '     TO MI-COLUMN-DESC              
              MOVE '56'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < TRIGGER_DATE >                            
           IF PARM-TRIGGER-DATE NOT = SB-TRIGGER-DATE                   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-TRIGGER-DATE                          
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN    
              MOVE PARM-TRIGGER-DATE   TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE SB-TRIGGER-DATE        TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'TRIGGER-DATE   '      TO MI-COLUMN-DESC             
              MOVE SPACES                 TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_STATUS_REAS >                        
           IF PARM-CODE-STATUS-REAS NOT = SB-CODE-STATUS-REAS           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-CODE-STATUS-REAS                      
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-CODE-STATUS-REAS TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-CODE-STATUS-REAS   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATUS REASON  '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_NO >                                 
           IF PARM-BOND-NO NOT = SB-BOND-NO                             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-BOND-NO                               
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-BOND-NO          TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-BOND-NO            TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BOND/LETTER NO '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND-TOTAL-AMT >                          
           IF PARM-BOND-TOTAL-AMT-N NOT = SB-BOND-TOTAL-AMT             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF WS-AMOUNT-X                                
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-BOND-TOTAL-AMT-N TO WS-AMOUNT-X                 
              MOVE WS-AMOUNT-X           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-BOND-TOTAL-AMT     TO WS-AMOUNT-X                 
              MOVE WS-AMOUNT-X           TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BOND TOTAL AMT '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < DATE_BOND_ISSUED >                        
           IF PARM-ISSUE-DATE NOT = SB-DATE-BOND-ISSUED                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-ISSUE-DATE                            
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-ISSUE-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-DATE-BOND-ISSUED   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ISSUE DATE     '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_EXPIRATION_DT >                      
           IF PARM-EXPIRATION-DATE NOT = SB-BOND-EXPIRATION-DT          
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-EXPIRATION-DATE                       
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-EXPIRATION-DATE  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-BOND-EXPIRATION-DT TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EXPIRATION DATE'     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_AMT >                                
           IF SB-AMT-BOND NOT = WS-BOND-AMT-N                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF WS-AMOUNT-X                                
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-BOND-AMT-N         TO WS-AMOUNT-X                 
              MOVE WS-AMOUNT-X           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SB-AMT-BOND           TO WS-AMOUNT-X                 
              MOVE WS-AMOUNT-X           TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SURETY AMOUNT  '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6020-JRNL-DELETE-BOND                                          *        
      * 1.   CREATE JOURNAL ENTRIES FOR DELETION OF SURETY-BOND DETAILS*        
      *      FOR THE ACCOUNT.                                          *        
      *                                                                *        
      ******************************************************************        
       6020-JRNL-DELETE-BOND.                                           
                                                                        
           MOVE '6020'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < BOND_CO_NO >                              
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE LENGTH OF PARM-BOND-NO     TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE PARM-BOND-NO               TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE '*DELETED*'                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE 'BOND/LETTER NO '          TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
P26289*****************************************************************         
P26289* 6600-GET-DELINQ-VALUE.                                        *         
P26289*     SELECTS VALUES FROM CSS_DELINQUENCY                       *         
P26289*****************************************************************         
P26289 6600-GET-DELINQ-VALUE.                                           
P26289                                                                  
P26289     EXEC SQL                                                     
P26289        SELECT DELINQ_VALUE                                       
P26289          INTO :C8-DELINQ-VALUE                                   
P26289          FROM CSS_DELINQUENCY                                    
P26289         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P26289           AND COMPANY_NO = :AT-COMPANY-NO                        
P26289     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289                                                                  
P26289     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P26289                                                                  
P26289     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P26289         NEXT SENTENCE                                            
P26289     ELSE                                                         
P26289         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P26289         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
P26289         MOVE '6600'                TO ACTIVE-PARAGRAPH           
P26289         MOVE 'SELECT'              TO ABEND-FUNCTION             
P26289         MOVE SPACES                TO ABEND-SQL-PREDICATES       
P26289                                       ABEND-TABLES               
P26289         MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
P26289         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
P26289         MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
P26289         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P26289         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P26289     END-IF.                                                      
P26289                                                                  
P26289 6600-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
      *****************************************************************         
      * 7000-GET-WAIV-ITEM-ID                                         *         
      *                                                               *         
      *      SELECT THE LAST WAIV-ITEMID USED IN CSS_SURETY_BOND TABLE*         
      *****************************************************************         
                                                                        
       7000-GET-WAIV-ITEM-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT MAX(BOND_WAIV_ITEM_ID)                            
               INTO   :SB-BOND-WAIV-ITEM-ID :WS-BOND-WAIV-ITEM-ID-NI     
               FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BOND_WAIV_ITEM_ID)                                    
MFA-TR*        INTO   :SB-BOND-WAIV-ITEM-ID:WS-BOND-WAIV-ITEM-ID-NI             
MFA-TR*        FROM   CSS_SURETY_BOND                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                  
                 WS-BOND-WAIV-ITEM-ID-NI < 0                            
                  MOVE 0      TO SB-BOND-WAIV-ITEM-ID                   
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-SURETY-BOND                                        *        
      *                                                                *        
      *    1.  RETRIEVE EXISTING DATA FROM CSS_SURETY_BOND             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-SELECT-SURETY-BOND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT BOND_NO,                                           
                     DATE_BOND_ISSUED,                                  
                     AMT_BOND,                                          
                     BOND_CO_NO,                                        
                     CODE_STATUS,                                       
                     CODE_STATUS_REAS,                                  
                     BOND_TOTAL_AMT,                                    
                     TRIGGER_DATE,                                      
                     BOND_EXPIRATION_DT,                                
                     USER_ID_ORIG_BY                                    
              INTO   :SB-BOND-NO,                                       
                     :SB-DATE-BOND-ISSUED :WS-DATE-BOND-ISSUED-NI,       
                     :SB-AMT-BOND,                                      
                     :SB-BOND-CO-NO,                                    
                     :SB-CODE-STATUS,                                   
                     :SB-CODE-STATUS-REAS,                              
                     :SB-BOND-TOTAL-AMT,                                
                     :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI,               
                     :SB-BOND-EXPIRATION-DT :WS-BOND-EXPIRATION-DT-NI,   
                     :SB-USER-ID-ORIG-BY                                
              FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
              WHERE  BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID AND      
                     ACCOUNT_NO = :SB-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BOND_NO,                                                   
MFA-TR*              DATE_BOND_ISSUED,                                          
MFA-TR*              AMT_BOND,                                                  
MFA-TR*              BOND_CO_NO,                                                
MFA-TR*              CODE_STATUS,                                               
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              BOND_TOTAL_AMT,                                            
MFA-TR*              TRIGGER_DATE,                                              
MFA-TR*              BOND_EXPIRATION_DT,                                        
MFA-TR*              USER_ID_ORIG_BY                                            
MFA-TR*       INTO   :SB-BOND-NO,                                               
MFA-TR*              :SB-DATE-BOND-ISSUED:WS-DATE-BOND-ISSUED-NI,               
MFA-TR*              :SB-AMT-BOND,                                              
MFA-TR*              :SB-BOND-CO-NO,                                            
MFA-TR*              :SB-CODE-STATUS,                                           
MFA-TR*              :SB-CODE-STATUS-REAS,                                      
MFA-TR*              :SB-BOND-TOTAL-AMT,                                        
MFA-TR*              :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                       
MFA-TR*              :SB-BOND-EXPIRATION-DT:WS-BOND-EXPIRATION-DT-NI,           
MFA-TR*              :SB-USER-ID-ORIG-BY                                        
MFA-TR*       FROM   CSS_SURETY_BOND                                            
MFA-TR*       WHERE  BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID AND              
MFA-TR*              ACCOUNT_NO = :SB-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-TRIGGER-DATE-NI < 0                                 
                 MOVE SPACES             TO SB-TRIGGER-DATE             
              END-IF                                                    
              IF WS-DATE-BOND-ISSUED-NI < 0                             
                 MOVE SPACES             TO SB-DATE-BOND-ISSUED         
              END-IF                                                    
              IF WS-BOND-EXPIRATION-DT-NI < 0                           
                 MOVE SPACES             TO SB-BOND-EXPIRATION-DT       
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-USER-PROFILE                                       *        
      *                                                                *        
      *    1.  RETRIEVE USER NAME DATE FROM CSS_SURETY_BOND            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME, LAST_NAME                              
                INTO :PF-FIRST-NAME, :PF-LAST-NAME                      
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME, LAST_NAME                                      
MFA-TR*         INTO :PF-FIRST-NAME, :PF-LAST-NAME                              
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              STRING PF-FIRST-NAME DELIMITED ' '                        
                     ' ' DELIMITED SIZE                                 
                     PF-LAST-NAME DELIMITED ' '                         
                INTO WS-ORIGINATED-BY                                   
              END-STRING                                                
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-SELECT-ACCOUNT                                           *         
      *                                                               *         
      *      SELECT CODES-DATA-PRESENT FROM CSS_ACCOUUNT TABLE        *         
      *****************************************************************         
                                                                        
       7300-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
              INTO   :AT-CODES-DATA-PRESENT                             
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODES_DATA_PRESENT                                         
MFA-TR*       INTO   :AT-CODES-DATA-PRESENT                                     
MFA-TR*       FROM   CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P26289*****************************************************************         
P26289* 7350-SELECT-ACCOUNT-TYPE                                      *         
P26289*      SELECT ACCOUNT TYPE FROM CSS_ACCOUNT TABLE               *         
P26289*****************************************************************         
P26289 7350-SELECT-ACCOUNT-TYPE.                                        
P26289                                                                  
P26289     EXEC SQL                                                     
P26289        SELECT COMPANY_NO                                         
P26289              ,ACCOUNT_TYPE_CODE                                  
P26289        INTO   :AT-COMPANY-NO                                     
P26289              ,:AT-ACCOUNT-TYPE-CODE                              
P26289        FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
P26289        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
P26289                                                           
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*             ,ACCOUNT_TYPE_CODE                                          
MFA-TR*       INTO   :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*       FROM   CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289                                                                  
P26289     MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
P26289                                                                  
P26289     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P26289        CONTINUE                                                  
P26289     ELSE                                                         
P26289        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P26289        MOVE '7350'               TO ACTIVE-PARAGRAPH             
P26289        MOVE 'SELECT'             TO ABEND-FUNCTION               
P26289        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P26289                                     ABEND-TABLES                 
P26289        MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
P26289        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P26289        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P26289        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P26289        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P26289     END-IF.                                                      
P26289                                                                  
P26289 7350-EXIT.                                                       
P26289     EXIT.                                                        
P26289                                                                  
P26289******************************************************************        
P26289*   7375-SET-EXPIRE-DATE.                                        *        
P26289*                                                                *        
P26289*   -- THIS MODULE CALCULATES THE EXPIRATION DATE AS BOND ISSUED *        
P26289*      DATE PLUS WS-LIMIT-MONTHS.                                *        
P26289*                                                                *        
P26289******************************************************************        
P26289 7375-SET-EXPIRE-DATE.                                            
P26289                                                                  
P26289     EXEC SQL                                                     
P26289        SELECT
              DATEADD( MONTH, :WS-LIMIT-MONTH, IIF(TRY_CONVERT(DATE, 
                                                   :SB-DATE-BOND-ISSUED
              ) IS NULL OR (PATINDEX('%.%', :SB-DATE-BOND-ISSUED
              ) <> 0) OR (LEN(:SB-DATE-BOND-ISSUED
              ) <> 10), CIS.CHAR2DATE(:SB-DATE-BOND-ISSUED
              ), CONVERT(DATE, :SB-DATE-BOND-ISSUED) ) )
            INTO
              :SB-BOND-EXPIRATION-DT                         
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :SB-BOND-EXPIRATION-DT                                       
MFA-TR*             =  DATE(:SB-DATE-BOND-ISSUED)                               
MFA-TR*                + :WS-LIMIT-MONTH MONTHS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289                                                                  
P26289     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P26289                                                                  
P26289     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P26289        NEXT SENTENCE                                             
P26289     ELSE                                                         
P26289        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P26289        MOVE '7375'                TO ACTIVE-PARAGRAPH            
P26289        MOVE 'SET'                 TO ABEND-FUNCTION              
P26289        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P26289                                      ABEND-TABLES                
P26289        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P26289        MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
P26289        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P26289        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P26289     END-IF.                                                      
P26289                                                                  
P26289 7375-EXIT.                                                       
P26289     EXIT.                                                        
                                                                        
      **************************************************************            
      * 7400-OPEN-SURETY-CURSOR                                    *            
      **************************************************************            
       7400-OPEN-SURETY-CURSOR.                                         
           MOVE '7400'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN SECURITY-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7410-FETCH-SURETY-CURSOR                                   *            
      **************************************************************            
       7410-FETCH-SURETY-CURSOR.                                        
           MOVE '7410'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH SECURITY-CURSOR                                     
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'           TO SECURITY-EXISTS-SW               
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7420-CLOSE-SURETY-CURSOR                                   *            
      **************************************************************            
       7420-CLOSE-SURETY-CURSOR.                                        
           MOVE '7420'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE SECURITY-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7430-OPEN-GUARNT-CURSOR                                    *            
      **************************************************************            
       7430-OPEN-GUARNT-CURSOR.                                         
           MOVE '7430'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN GUARNTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
CBSI                                       ABEND-SQL-PREDICATES         
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'GUAR_STATUS_CD'     TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7440-FETCH-GUARNT-CURSOR                                   *            
      **************************************************************            
       7440-FETCH-GUARNT-CURSOR.                                        
           MOVE '7440'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH GUARNTR-CURSOR                                      
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'     TO SECURITY-EXISTS-SW                     
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
CBSI                                       ABEND-SQL-PREDICATES         
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'GUAR_STATUS_CD'     TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7450-CLOSE-GUARNT-CURSOR                                   *            
      **************************************************************            
       7450-CLOSE-GUARNT-CURSOR.                                        
           MOVE '7450'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE GUARNTR-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
CBSI                                       ABEND-SQL-PREDICATES         
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'GUAR_STATUS_CD'     TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACTIVE            TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * 8200-INSERT-SURETY-BOND                                        *        
      *                                                                *        
      *    1.  INSERT CSS_SURETY_BOND DETAILS                          *        
      *                                                                *        
      ******************************************************************        
       8200-INSERT-SURETY-BOND.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SURETY_BOND                               
                   ( CODE_BOND_TYPE,                                    
                     BOND_WAIV_ITEM_ID,                                 
                     ACCOUNT_NO,                                        
                     BOND_NO,                                           
                     DATE_BOND_ISSUED,                                  
                     AMT_BOND,                                          
                     BOND_CO_NO,                                        
                     CODE_STATUS,                                       
                     CODE_STATUS_REAS,                                  
                     BOND_TOTAL_AMT,                                    
                     TRIGGER_DATE,                                      
                     BOND_EXPIRATION_DT,                                
P26289               LAST_UPDATE_DT,                                    
P26289               LAST_UPDATE_USERID,                                
                     USER_ID_ORIG_BY)                                   
              VALUES                                                    
                   ( :SB-CODE-BOND-TYPE,                                
                     :SB-BOND-WAIV-ITEM-ID,                             
                     :SB-ACCOUNT-NO,                                    
                     :SB-BOND-NO,                                       
                     IIF(TRY_CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                           :WS-DATE-BOND-ISSUED-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 0) OR (LEN(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 10), CIS.CHAR2DATE(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ), CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) ),       
                     :SB-AMT-BOND,                                      
                     :SB-BOND-CO-NO,                                    
                     :SB-CODE-STATUS,                                   
                     :SB-CODE-STATUS-REAS,                              
                     :SB-BOND-TOTAL-AMT,                                
                     IIF(TRY_CONVERT(DATE, :SB-TRIGGER-DATE 
                                           :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI) ),        
                     IIF(TRY_CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                           :WS-BOND-EXPIRATION-DT-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 0) OR (LEN(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 10), CIS.CHAR2DATE(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ), CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) ),   
P26289               IIF(TRY_CONVERT(DATE, :SB-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :SB-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:SB-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:SB-LAST-UPDATE-DT
              ), CONVERT(DATE, :SB-LAST-UPDATE-DT) ),                          
P26289               :SB-LAST-UPDATE-USERID,                            
                     :WS-USER-ID-ORIG-BY )                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SURETY_BOND                                       
MFA-TR*            ( CODE_BOND_TYPE,                                            
MFA-TR*              BOND_WAIV_ITEM_ID,                                         
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              BOND_NO,                                                   
MFA-TR*              DATE_BOND_ISSUED,                                          
MFA-TR*              AMT_BOND,                                                  
MFA-TR*              BOND_CO_NO,                                                
MFA-TR*              CODE_STATUS,                                               
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              BOND_TOTAL_AMT,                                            
MFA-TR*              TRIGGER_DATE,                                              
MFA-TR*              BOND_EXPIRATION_DT,                                        
MFA-TR*              LAST_UPDATE_DT,                                            
MFA-TR*              LAST_UPDATE_USERID,                                        
MFA-TR*              USER_ID_ORIG_BY)                                           
MFA-TR*       VALUES                                                            
MFA-TR*            ( :SB-CODE-BOND-TYPE,                                        
MFA-TR*              :SB-BOND-WAIV-ITEM-ID,                                     
MFA-TR*              :SB-ACCOUNT-NO,                                            
MFA-TR*              :SB-BOND-NO,                                               
MFA-TR*              :SB-DATE-BOND-ISSUED:WS-DATE-BOND-ISSUED-NI,               
MFA-TR*              :SB-AMT-BOND,                                              
MFA-TR*              :SB-BOND-CO-NO,                                            
MFA-TR*              :SB-CODE-STATUS,                                           
MFA-TR*              :SB-CODE-STATUS-REAS,                                      
MFA-TR*              :SB-BOND-TOTAL-AMT,                                        
MFA-TR*              :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                       
MFA-TR*              :SB-BOND-EXPIRATION-DT:WS-BOND-EXPIRATION-DT-NI,           
MFA-TR*              :SB-LAST-UPDATE-DT,                                        
MFA-TR*              :SB-LAST-UPDATE-USERID,                                    
MFA-TR*              :WS-USER-ID-ORIG-BY )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'DATE_BOND_ISSUED'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'TRIGGER_DATE'       TO TABLE-ELEMENT-4              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
CBSI          MOVE SB-DATE-BOND-ISSUED  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE SB-TRIGGER-DATE      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8210-UPDATE-SURETY-BOND                                        *        
      *                                                                *        
      *    1. UPDATES SURETY BOND / LETTER OF CREDIT DETAILS           *        
      *                                                                *        
      ******************************************************************        
       8210-UPDATE-SURETY-BOND.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SURETY_BOND                                    
              SET    BOND_NO            = :SB-BOND-NO,                  
                     DATE_BOND_ISSUED   =                               
                       IIF(TRY_CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                             :WS-DATE-BOND-ISSUED-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 0) OR (LEN(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 10), CIS.CHAR2DATE(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ), CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) ),     
                     AMT_BOND           = :SB-AMT-BOND,                 
                     BOND_CO_NO         = :SB-BOND-CO-NO,               
                     CODE_STATUS        = :SB-CODE-STATUS,              
                     CODE_STATUS_REAS   = :SB-CODE-STATUS-REAS,         
                     BOND_TOTAL_AMT     = :SB-BOND-TOTAL-AMT,           
                     TRIGGER_DATE       =                               
                       IIF(TRY_CONVERT(DATE, :SB-TRIGGER-DATE 
                                             :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI) ),        
P26289               LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :SB-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :SB-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:SB-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:SB-LAST-UPDATE-DT
              ), CONVERT(DATE, :SB-LAST-UPDATE-DT) ),           
P26289               LAST_UPDATE_USERID = :SB-LAST-UPDATE-USERID,       
                     BOND_EXPIRATION_DT =                               
                       IIF(TRY_CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                             :WS-BOND-EXPIRATION-DT-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 0) OR (LEN(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 10), CIS.CHAR2DATE(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ), CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) )  
              WHERE  BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID AND      
                     ACCOUNT_NO        = :SB-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SURETY_BOND                                            
MFA-TR*       SET    BOND_NO            = :SB-BOND-NO,                          
MFA-TR*              DATE_BOND_ISSUED   =                                       
MFA-TR*                :SB-DATE-BOND-ISSUED:WS-DATE-BOND-ISSUED-NI,             
MFA-TR*              AMT_BOND           = :SB-AMT-BOND,                         
MFA-TR*              BOND_CO_NO         = :SB-BOND-CO-NO,                       
MFA-TR*              CODE_STATUS        = :SB-CODE-STATUS,                      
MFA-TR*              CODE_STATUS_REAS   = :SB-CODE-STATUS-REAS,                 
MFA-TR*              BOND_TOTAL_AMT     = :SB-BOND-TOTAL-AMT,                   
MFA-TR*              TRIGGER_DATE       =                                       
MFA-TR*                :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                     
MFA-TR*              LAST_UPDATE_DT     = :SB-LAST-UPDATE-DT,                   
MFA-TR*              LAST_UPDATE_USERID = :SB-LAST-UPDATE-USERID,               
MFA-TR*              BOND_EXPIRATION_DT =                                       
MFA-TR*                :SB-BOND-EXPIRATION-DT:WS-BOND-EXPIRATION-DT-NI          
MFA-TR*       WHERE  BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID AND              
MFA-TR*              ACCOUNT_NO        = :SB-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'DATE_BOND_ISSUED'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'TRIGGER_DATE'       TO TABLE-ELEMENT-4              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
CBSI          MOVE SB-DATE-BOND-ISSUED  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE SB-TRIGGER-DATE      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8220-DELETE-SURETY-BOND                                        *        
      *                                                                *        
      *    1.  DELETE RECORDS FROM CSS_SURETY_BOND TABLE               *        
      *                                                                *        
      ******************************************************************        
       8220-DELETE-SURETY-BOND.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SURETY_BOND                               
              WHERE  BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID AND      
                     ACCOUNT_NO        = :SB-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8220'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
              MOVE 'BOND_WAIV_ITEM_ID'   TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE SB-BOND-WAIV-ITEM-ID  TO HOSTVAR-ELEMENT-1           
              MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8300-UPDATE-ACCOUNT                                           *         
      *                                                               *         
      *      UPDATE CODES-DATA-PRESENT FROM CSS_ACCOUUNT TABLE        *         
      *****************************************************************         
                                                                        
       8300-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
