       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02153.                                         
       DATE-WRITTEN.     SEPTEMBER 5, 1995.                             
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S153 CONVERTED TO DB2 SP CSR02153 ON 09/22/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
      *                                                                *00100000
      *  TRANID:        S153                                           *00110000
      *  PROGRAM:       S153                                           *00120000
      *  CALLING SP:    PN_S153                                        *00130000
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES THE DEPOSIT REFUND INFORMATION         *00210000
      *                                                                *00220000
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *00230000
      *                                                                *00240000
      *  TABLE                  TABLE ID     DCLGEN                    *00250000
      *  -----                  --------     ------                    *00260000
      *  CSS_DEP_ON_HAND           DO        TBDEPHND                  *00270000
      *  CSS_DEP_REQ               DR        TBDEPREQ                  *00280000
      *  CSS_DEP_PAY_HST           DP        TBDEPHST                  *00290000
      *  CSS_DEP_INT_RATE          P6        TBDEPINT                  *00300000
      *  CSS_AR_CNTL               AC        TBARCNTL                  *00310000
      *  CSS_ACCOUNT               AT        TBACCT                    *00320000
      *  CSS_PREMISE               PR        TBPREM                    *00330000
      *  CSS_ZIP_CODE              A4        TBZIPCD                   *00340000
      *                                                                *00350000
      ******************************************************************00360000
      *                                                                *00370000
      *                     PROGRAM MODIFICATION LOG                   *00380000
      *                                                                *00390000
      *    DATE    INITIALS   COMMENTS                                 *00400000
      *  --------  --------   -----------------                        *00410000
      *  09/05/95    HC       CREATED.                                 *00420000
      *  06/25/96    CS       TPR 3753 - ADD COMPOUND INTEREST CALC AND*00421000
      *                       REMOVE PROGRAM SPECIFIC INTEREST CALC    *00422000
      *                       LOGIC AND REPLACE IT WITH CPD00023 AND   *00423000
      *                       CPD00127.                                *00430000
PCR482*  03/05/97    MD       PERFORM DEPOSIT ON HAND CALCS BASED ON   *00431000
      *                       'BILLED' AND 'PAID' DEPOSITS ONLY.       *00432000
CBSI  *  08/31/98    KP       MC05 ABEND LOGS CORRECTED TO INCLUDE     *00433000
      *                       ALL REQUIRED PARAMETERS                  *00434000
T21024*  02/09/00  CBSI       MODIFIED RESULT SET TO SEND LAST-UPDAT-TS*00434101
T21024*            CHENNAI    TO PANEL 259                             *00435001
T20626*  04/04/00  CBSI       CHANGES MADE TO CHANGE MANUAL REFUND     *00436004
T20626*            CHENNAI    LOGIC TO USE DELINQUENCY TABLE VALUE.    *00437004
T23501*   02/02/01   SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 6791 TO SUPPORT MULTI-COMPANY.      *        
T23980*   11/19/01     SM19366  MODIFIED THE PROGRAM COPYBOOK          *        
T23980*                         CPD00023 SO NEEDED TO ADD COPYBOOK     *        
T23980*                         CWS0024B FOR SEB DEPOSIT REFUND.       *        
C29752*   12/9/03  MDJ        IN PARA 7300, DO NOT ADD 1 DAY TO        *        
      *                       DO-DATE-INTST-CALC-TO. THIS IS USED IN   *        
      *                       CPD00023.                                *        
T28160*   01/5/04  DP19151    ADDED CODE TO RETRIEVE THE DEP TYPE AND  *        
      *                       THE REFUND ELIG CODE.                    *        
REARCH* 09/26/05   CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
T35434* 11/27/07   PC97415    REPLACED MODEL_SQL TO SET STATEMENT AND  *        
T35434*                       ADDED FOR FETCH ONLY WITH UR FOR CURSORS *        
T35434*                       AND WITH UR FOR SINGLETON SELECTS.       *        
      ******************************************************************00450000
      *                                                                *00460000
      *                -- BASIC SEQUENCE STRUCTURE --                  *00470000
      *                                                                *00480000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00490000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00500000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00510000
      *  3000 - 4999  NOT USED                                         *00520000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00530000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00540000
      *  7000 - 7999  INPUT MODULES                                    *00550000
      *  8000 - 8999  OUTPUT MODULES                                   *00560000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00570000
      *                                                                *00580000
      ******************************************************************00590000
      *                                                                 00600000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02153'.
MSQ017     COPY MFASQLM.
      *                                                                 00640000
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02153 STARTS HERE'.                  
      *                                                                 00670000
      ******************************************************************00680000
      *    DB2 INCLUDES                                                *00690000
      ******************************************************************00700000
      *                                                                 00710000
           EXEC SQL                                                     00720000
              INCLUDE SQLCA                                             00730000
           END-EXEC.                                                    00740000
      *                                                                 00840000
      *---< CSS_DEP_ON_HAND >                                           00850000
           EXEC SQL                                                     00860000
              INCLUDE TBDEPHND                                          00870000
           END-EXEC.                                                    00880000
      *                                                                 00890000
      *---< CSS_AR_CNTL >                                               00900000
           EXEC SQL                                                     00910000
              INCLUDE TBARCNTL                                          00920000
           END-EXEC.                                                    00930000
      *                                                                 00940000
      *---< CSS_ACCOUNT >                                               00950000
           EXEC SQL                                                     00960000
              INCLUDE TBACCT                                            00970000
           END-EXEC.                                                    00980000
      *                                                                 00990000
      *---< CSS_DEP_REQ >                                               01000000
           EXEC SQL                                                     01010000
              INCLUDE TBDEPREQ                                          01020000
           END-EXEC.                                                    01030000
      *                                                                 01040000
      *---< CSS_DEP_PAY_HST >                                           01050000
           EXEC SQL                                                     01060000
              INCLUDE TBDEPHST                                          01070000
           END-EXEC.                                                    01080000
      *                                                                 01090000
      *---< CSS_DEP_INT_RATE >                                          01100000
           EXEC SQL                                                     01110000
              INCLUDE TBDEPINT                                          01120000
           END-EXEC.                                                    01130000
      *                                                                 01140000
      *---< CSS_PREMISE >                                               01150000
           EXEC SQL                                                     01160000
              INCLUDE TBPREM                                            01170000
           END-EXEC.                                                    01180000
      *                                                                 01190000
      *---< CSS_AR_TRANS_HIST >                                         01200000
           EXEC SQL                                                     01210000
              INCLUDE TBARHIST                                          01220000
           END-EXEC.                                                    01230000
      *                                                                 01240000
      *---< CSS_AR_TRN_HST_DET >                                        01250000
           EXEC SQL                                                     01260000
              INCLUDE TBARHDT                                           01270000
           END-EXEC.                                                    01280000
      *                                                                 01290000
      ******************************************************************01310000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01320000
      ******************************************************************01330000
      *                                                                 01340000
      *----< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >          01350000
      *----< SYBASE OPEN SERVER FOR CICS FACILITIES.             >      01360000
CVT999*    COPY SYGWCOB.                                                01370000
      *----< ADDED TO SUPPORT CICS RPCS >                               01380000
CVT999*    COPY SYDBCOB.                                                01390000
      *----<COMMON SYSTEM AREA >                                        01400000
           COPY CCA00001.                                               01410000
      *----< ERROR HANDLING >                                           01420000
CVT999*    COPY CWS00010.                                               01430000
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >           01440000
           COPY CWS00027.                                               01450000
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                      01460000
           COPY CWS00303.                                               01470000
      *----< CODES-DATA-PRESENT WORKING STORAGE  >                      01480000
           COPY CWS00056.                                               01490000
      *                                                                 01500000
T23980     EXEC SQL                                                             
T23980         INCLUDE CWS0024B                                                 
T23980     END-EXEC.                                                            
      *                                                                         
      ******************************************************************01510000
      *    WORK AREAS                                                  *01520000
      ******************************************************************01530000
      *                                                                 01540000
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR02153'.  
      *                                                                 01660000
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
      *                                                                 01680000
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.      
           05  PARM-SERVICE-TYPE         PIC X(01)   VALUE SPACES.      
           05  PARM-DEPOSIT-CERT-NO      PIC X(09)   VALUE SPACES.      
           05  PARM-PREMISE-NO           PIC X(10)   VALUE SPACES.      
      *                                                                 01760000
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
      *                                                                 01800000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
      *                                                                 01850000
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
COB305     05 WS-DEL-CAL-DAYS        PIC S9(3) COMP-3 VALUE 0.            
COB305     05 WS-DEL-DAYS        PIC S9(3) COMP-3 VALUE 0.            
COB305     05 WS-DAY        PIC S9(3) COMP-3 VALUE 0.            
COB305     05 WS-NEXT-DATE-COUNT        PIC S9(3) COMP-3 VALUE 0.            
      *                                                                 01910000
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
      *                                                                 01960000
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-FETCH-HIST          PIC S9(09) COMP VALUE 0.          
           05  WS-FETCH-DET           PIC S9(09) COMP VALUE 0.          
           05  WS-FETCH-DO            PIC S9(09) COMP VALUE 0.          
T20626     05  WS-DATE-TRANS-10       PIC X(10) VALUE SPACES.           
      *                                                                 02130000
       01  WS-CALCULATIONS.                                             
COB305     05 WS-MONTHS-SINCE-INTRST-CALC        PIC S9(02) COMP-3 
COB305       VALUE 0.        
COB305     05 WS-DAYS-SINCE-DEP-PD        PIC S9(03) COMP-3 VALUE 0.        
      *                                                                 02200000
       01  WS-TEMP-VARIABLES.                                           
           05  WS-INTR-DATE-FROM           PIC X(10).                   
           05  WS-INTR-DATE-TO             PIC X(10).                   
COB305     05 WS-AMOUNT-TEMP        PIC S9(07)V99 COMP-3 VALUE 0.        
COB305     05 WS-AMOUNT-TEMP2        PIC S9(07)V99 COMP-3 VALUE 0.        
           05  WS-DETAIL-END-BAL           PIC S9(07)V99  VALUE ZERO.   
           05  WS-DETAIL-END-AR-BAL        PIC S9(07)V99  VALUE ZERO.   
           05  WS-DATE-1-YEAR-AGO          PIC X(10).                   
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-DATE-10-DAYS-AGO         PIC X(10).                   
           05  WS-DATE-6-MOS-AGO           PIC X(10).                   
           05  WS-MAX-DEP-PAY-DT           PIC X(10).                   
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-TEMP-DT                  PIC X(10).                   
           05  WS-TEMP-TIMESTAMP           PIC X(29).                   
           05  WS-NO-OF-PAYMENTS           PIC S9(04) COMP VALUE 0.     
           05  WS-NO-OF-PYMTS           PIC S9(04) COMP VALUE 0.        
           05  WS-MAX-DATE-TRANS           PIC X(10).                   
           05  ONE-YEAR                    PIC S9(03) COMP VALUE +365.  
T20626     05  WS-WORK-DATE                PIC X(10)  VALUE SPACES.     
COB305     05 WS-VA-ACCT-NO-P        PIC S9(13)V USAGE COMP-3 VALUE 0.    
      *                                                                 02550000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02570000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
           05  RS-DPP-ACCT               PIC X(01)   VALUE SPACE.       
           05  RS-NON-CLEAR-CHECK-IND    PIC X(01)   VALUE 'N'.         
           05  RS-INTEREST-AMT           PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE ZERO.      
           05  RS-MAX-DATE-TRANS         PIC X(10)   VALUE SPACES.      
T21024     05  RS-AT-LAST-UPD-TS         PIC X(26)   VALUE SPACES.      
T28160     05  RS-CODE-DEP-TYPE          PIC X(01)   VALUE SPACES.      
T28160     05  RS-CODE-REF-ELIG          PIC X(01)   VALUE SPACES.      
      *                                                                 02660000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
REARCH     05  S-DPP-ACCT                PIC X(01)   VALUE SPACE.       
REARCH     05  S-NON-CLEAR-CHECK-IND     PIC X(01)   VALUE 'N'.         
REARCH     05  S-INTEREST-AMT            PIC S9(09)V99 USAGE COMP-3     
REARCH                                                 VALUE ZERO.      
REARCH     05  S-MAX-DATE-TRANS          PIC X(10)   VALUE SPACES.      
REARCH     05  S-AT-LAST-UPD-TS          PIC X(26)   VALUE SPACES.      
REARCH     05  S-CODE-DEP-TYPE           PIC X(01)   VALUE SPACES.      
REARCH     05  S-CODE-REF-ELIG           PIC X(01)   VALUE SPACES.      
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO             PIC X(13)   VALUE SPACES.      
           05  WS-ACCOUNT-NO-NUM         PIC S9(13) COMP-3 VALUE ZERO.  
           05  WS-PREMISE-NO             PIC X(10)   VALUE SPACES.      
           05  WS-PREMISE-NO-NUM         PIC S9(10) COMP-3 VALUE ZERO.  
           05  WS-NULL-IND-1             PIC S9(04) COMP.               
           05  WS-NULL-IND-2             PIC S9(04) COMP.               
           05  WS-NULL-IND-3             PIC S9(04) COMP.               
           05  WS-NULL-IND-4             PIC S9(04) COMP.               
           05  WS-NULL-IND-5             PIC S9(04) COMP.               
           05  WS-MAX-DEP-PAY-DT-NI      PIC S9(04) COMP.               
           05  WS-FETCH-RN               PIC S9(09) COMP VALUE 0.       
      *                                                                 02950000
       01  WS-DEPOSIT-CERT-NO-REDEF.                                    
           05  WS-DEPOSIT-CERT-NO      PIC X(09).                       
           05  WS-DEPOSIT-CERT-NUM REDEFINES WS-DEPOSIT-CERT-NO         
                                       PIC 9(09).                       
           05  WS-DEPOSIT-CERT-NO-NO   PIC S9(09) USAGE COMP.           
      *                                                                 03010000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T20626     05  WS-DATE-FOUND           PIC X(01) VALUE 'N'.             
T20626     05  WS-HOLIDAY-EXISTS       PIC X(01) VALUE 'N'.             
      *                                                                 03090000
HPCCDM*EJECT                                                            03100000
      *                                                                 03110000
      ******************************************************************03120000
      **       CURSOR DECLARATIONS                                     *03130000
      ******************************************************************03140000
      *                                                                 03150000
           EXEC SQL                                                     
                DECLARE DEP_PAY_HST CURSOR FOR                          
                SELECT   ACCOUNT_NO,                                    
                         DEPOSIT_CERT_NO,                               
                         DEP_PAY_DT,                                    
                         DEP_PAY_AMT,                                   
                         CIS.DECIMAL2DAY (CIS.DIFFDATE( 
           CAST(SYSDATETIMEOFFSET() AS DATE), DEP_PAY_DT ))                
                FROM     CSS_DEP_PAY_HST WITH(READUNCOMMITTED)                  
                WHERE    ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM           
                  AND    DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO          
                ORDER BY DEP_PAY_DT                                     
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                     03320000
MFA-TR*         DECLARE DEP_PAY_HST CURSOR FOR                          03330000
MFA-TR*         SELECT   ACCOUNT_NO,                                    03340000
MFA-TR*                  DEPOSIT_CERT_NO,                               03350000
MFA-TR*                  DEP_PAY_DT,                                    03360000
MFA-TR*                  DEP_PAY_AMT,                                   03370000
MFA-TR*                  DAY (CURRENT DATE - DEP_PAY_DT)                03380000
MFA-TR*         FROM     CSS_DEP_PAY_HST                                03390000
MFA-TR*         WHERE    ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM           03400000
MFA-TR*           AND    DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO          03410000
MFA-TR*         ORDER BY DEP_PAY_DT                                     03420000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    03430000
      *                                                                 03440000
           EXEC SQL                                                     
             DECLARE AR_HISTORY  CURSOR FOR                             
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                               
                   FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                 
                  WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                 
                    AND DATE_TRANS >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-10-DAYS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-10-DAYS-AGO
              ) <> 0) OR (LEN(:WS-DATE-10-DAYS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-10-DAYS-AGO
              ), CONVERT(DATE, :WS-DATE-10-DAYS-AGO) )              
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03560000
MFA-TR*      DECLARE AR_HISTORY  CURSOR FOR                             03570000
MFA-TR*          SELECT TRANS_HIST_SEQ_NO                               03580000
MFA-TR*            FROM CSS_AR_TRANS_HIST                               03590000
MFA-TR*           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                 03600000
MFA-TR*             AND DATE_TRANS >= :WS-DATE-10-DAYS-AGO              03610000
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    03620000
      *                                                                 03630000
           EXEC SQL                                                     
             DECLARE AR_HISTORY_DET  CURSOR FOR                         
             SELECT  COUNT(*)                                           
                FROM  CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                  
                WHERE                                                   
                  TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )             
                  AND ACCOUNT_NO    = :WS-ACCOUNT-NO-NUM                
                  AND CURRENCY_TYPE IN ('C', 'D')                       
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03640000
MFA-TR*      DECLARE AR_HISTORY_DET  CURSOR FOR                         03650000
MFA-TR*      SELECT  COUNT(*)                                           03660000
MFA-TR*         FROM  CSS_AR_TRN_HST_DET                                03670000
MFA-TR*         WHERE                                                   03680000
MFA-TR*           TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO             03690000
MFA-TR*           AND ACCOUNT_NO    = :WS-ACCOUNT-NO-NUM                03700000
MFA-TR*           AND CURRENCY_TYPE IN ('C', 'D')                       03710000
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    03720000
      *                                                                 03730000
      * SUPPORTS DEP INT CALC.                                          03730100
           EXEC SQL                                                     03730200
              INCLUDE CWS0223B                                          03730300
           END-EXEC.                                                    03730400
      *                                                                 03731000
T20626     EXEC SQL                                                     03730602
T20626         INCLUDE TBDELQ                                           03730702
T20626     END-EXEC.                                                    03730802
      *                                                                 03730902
T20626     EXEC SQL                                                     03731002
T20626         INCLUDE TBHLDAY                                          03731102
T20626     END-EXEC.                                                    03731202
      *                                                                 03732000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-SERVICE-TYPE        PIC X(01)                .          
CVT000 01  LINK-DEPOSIT-CERT-NO     PIC X(09)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-SERVICE-TYPE                                       
CVT000         ,LINK-DEPOSIT-CERT-NO                                    
CVT000         ,LINK-PREMISE-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              03740000
                                                                        
      ******************************************************************03760000
      * 0000-MAINLINE                                                  *03770000
      *     CALLS 0100-INITIALIZE                                      *03780000
      *           1000-PROCESS-INPUT                                   *03790000
      *           2000-PROCESS-OUTPUT                                  *03800000
      *           9999-END-PROGRAM                                     *03810000
      *                                                                *03820000
      *     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *03830000
      ******************************************************************03840000
      *                                                                 03850000
       0000-MAINLINE.                                                   
      *                                                                 03870000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 03920000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03950000
      ******************************************************************03960000
      * 0100-INITIALIZE                                                *03970000
      *     CALLS 9000-SEND-ERROR-RESULT                               *03980000
      *           9900-SQL-ERROR-ROUTINE                               *03990000
      *                                                                *04000000
      *     CALLED FROM 0000-MAINLINE                                  *04010000
      *                                                                *04020000
      *     1. RESET DB2 ERROR HANDLERS                                *04030000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04040000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04050000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04060000
      *                                                                *04070000
      ******************************************************************04080000
      *                                                                 04090000
       0100-INITIALIZE.                                                 
      *                                                                 04110000
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
      *                                                                 04130000
T20621     MOVE ZEROS                         TO WS-DEL-DAYS.           
T20621     MOVE ZEROS                         TO WS-DEL-CAL-DAYS.       
      *                                                                 04133008
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE                AS    RETURN_CODE           
CVT000       ,LTRIM(RTRIM(:S-DPP-ACCT))            AS    DPP_ACCT              
CVT000       ,LTRIM(RTRIM(:S-NON-CLEAR-CHECK-IND)) AS    
           NON_CLEAR_CHCK_IND    
CVT000       ,:S-INTEREST-AMT               AS    INTEREST_AMT          
CVT000       ,LTRIM(RTRIM(:S-MAX-DATE-TRANS))      AS    MAX_DATE_TRANS        
CVT000       ,LTRIM(RTRIM(:S-AT-LAST-UPD-TS))      AS    AT_LAST_UPD_TS        
CVT000       ,LTRIM(RTRIM(:S-CODE-DEP-TYPE))       AS    CODE_DEP_TYPE         
CVT000       ,LTRIM(RTRIM(:S-CODE-REF-ELIG))       AS    CODE_REF_ELIG         
REARCH       ,''                            AS    DUMMY1                
REARCH       ,''                            AS    DUMMY2                
REARCH       ,''                            AS    DUMMY3                
REARCH       ,''                            AS    DUMMY4                
REARCH       ,''                            AS    DUMMY5                
REARCH       ,''                            AS    DUMMY6                
REARCH       ,0                             AS    DUMMY7                
REARCH       ,0                             AS    DUMMY8                
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE                AS    RETURN_CODE                   
MFA-TR*      ,STRIP(:S-DPP-ACCT)            AS    DPP_ACCT                      
MFA-TR*      ,STRIP(:S-NON-CLEAR-CHECK-IND) AS    NON_CLEAR_CHCK_IND            
MFA-TR*      ,:S-INTEREST-AMT               AS    INTEREST_AMT                  
MFA-TR*      ,STRIP(:S-MAX-DATE-TRANS)      AS    MAX_DATE_TRANS                
MFA-TR*      ,STRIP(:S-AT-LAST-UPD-TS)      AS    AT_LAST_UPD_TS                
MFA-TR*      ,STRIP(:S-CODE-DEP-TYPE)       AS    CODE_DEP_TYPE                 
MFA-TR*      ,STRIP(:S-CODE-REF-ELIG)       AS    CODE_REF_ELIG                 
MFA-TR*      ,''                            AS    DUMMY1                        
MFA-TR*      ,''                            AS    DUMMY2                        
MFA-TR*      ,''                            AS    DUMMY3                        
MFA-TR*      ,''                            AS    DUMMY4                        
MFA-TR*      ,''                            AS    DUMMY5                        
MFA-TR*      ,''                            AS    DUMMY6                        
MFA-TR*      ,0                             AS    DUMMY7                        
MFA-TR*      ,0                             AS    DUMMY8                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-SERVICE-TYPE         TO PARM-SERVICE-TYPE        . 
CVT000     MOVE LINK-DEPOSIT-CERT-NO      TO PARM-DEPOSIT-CERT-NO     . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04350000
      ******************************************************************04360000
      * 1000-PROCESS-INPUT                                             *04370000
      *     CALLS 1100-RECEIVE-PARMS                                   *04380000
      *                                                                *04390000
      *     CALLED FROM 0000-MAINLINE                                  *04400000
      *                                                                *04410000
      *     1. RECEIVE PARMS.                                          *04420000
      ******************************************************************04430000
      *                                                                 04440000
       1000-PROCESS-INPUT.                                              
      *                                                                 04460000
           PERFORM 1150-ASSIGN-WS-VARS   THRU 1150-EXIT.                
      *                                                                 04490000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05121000
      ******************************************************************05130000
      * 1150 ASSIGN-WS-VARS                                            *05140000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05150000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *05160000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *05170000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *05180000
      *        PROCESSING WITHIN THIS PROGRAM.                         *05190000
      ******************************************************************05200000
      *                                                                 05201000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 05220000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM.             
      *                                                                 05250000
           MOVE PARM-DEPOSIT-CERT-NO  TO WS-DEPOSIT-CERT-NO.            
           MOVE WS-DEPOSIT-CERT-NUM   TO WS-DEPOSIT-CERT-NO-NO.         
           MOVE WS-DEPOSIT-CERT-NO-NO TO DO-DEPOSIT-CERT-NO.            
      *                                                                 05290000
           MOVE PARM-PREMISE-NO       TO WS-PREMISE-NO.                 
           MOVE WS-PREMISE-NO         TO WS-PREMISE-NO-NUM.             
      *                                                                 05311000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05340000
      ******************************************************************05400000
      * 2000-PROCESS-OUTPUT.                                           *05410000
      *     CALLS 2100-DESCRIBE-RESULT                                 *05420000
      *           2400-BUILD-RESULT                                    *05430000
      *           8100-SEND-RESULT                                     *05440000
      *                                                                *05450000
      *      CALLED FROM 0000-MAINLINE                                 *05460000
      *                                                                *05470000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *05480000
      *      AND SENDS THEM BACK                                       *05490000
      ******************************************************************05500000
      *                                                                 05510000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05530000
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
      *                                                                 05550000
           PERFORM 2400-BUILD-RESULT             THRU 2400-EXIT.        
      *                                                                 05580000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05610000
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-DPP-ACCT              TO S-DPP-ACCT.                
REARCH     MOVE  RS-NON-CLEAR-CHECK-IND   TO S-NON-CLEAR-CHECK-IND.     
REARCH     MOVE  RS-INTEREST-AMT          TO S-INTEREST-AMT.            
REARCH     MOVE  RS-MAX-DATE-TRANS        TO S-MAX-DATE-TRANS.          
REARCH     MOVE  RS-AT-LAST-UPD-TS        TO S-AT-LAST-UPD-TS.          
REARCH     MOVE  RS-CODE-DEP-TYPE         TO S-CODE-DEP-TYPE.           
REARCH     MOVE  RS-CODE-REF-ELIG         TO S-CODE-REF-ELIG.           
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 07110000
      ******************************************************************07120000
      * 2400-BUILD-RESULT                                              *07130000
      *                                                                *07140000
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *07150000
      *                                                                *07160000
      *     BUILD THE RESULT SET.                                      *07170000
      ******************************************************************07180000
      *                                                                 07190000
       2400-BUILD-RESULT.                                               
      *                                                                 07210000
           MOVE '2400'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 07230000
      *** GET BASIC DATA FROM CSS_ACCOUNT AND CSS_PREMISE               07240000
      *                                                                 07230000
           PERFORM 7260-SELECT-ACCOUNT              THRU 7260-EXIT.     
      *                                                                 07241000
T20626     MOVE 'DAY-REFUND-CHECK-CAL'       TO C8-DELINQ-CD.           
T20626     PERFORM 6791-SELECT-DELINQUENCY          THRU 6791-EXIT.     
T20626     MOVE C8-DELINQ-VALUE              TO WS-DEL-CAL-DAYS.        
T20626*                                                                 07245008
           PERFORM 7060-GET-CURRENT-DATE            THRU 7060-EXIT.     
      *                                                                 07260100
           MOVE WS-ACCOUNT-NO-NUM            TO AT-ACCOUNT-NO.          
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
T21024                                                                  
T21024     PERFORM 2600-GET-LAST-UPDATE-TS          THRU 2600-EXIT.     
      *                                                                 07271000
           IF WS-CODE-DPP-ACCT = 'A'                                    
            AND (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)               
              MOVE 'Y'                       TO RS-DPP-ACCT             
           ELSE                                                         
              MOVE 'N'                       TO RS-DPP-ACCT             
           END-IF.                                                      
      *                                                                 07340000
           PERFORM 7265-SELECT-PREMISE              THRU 7265-EXIT.     
T20626                                                                  
T20626     MOVE 'DAY-REFUND-CHECK'           TO C8-DELINQ-CD.           
T20626     PERFORM 6791-SELECT-DELINQUENCY          THRU 6791-EXIT.     
T20626     MOVE C8-DELINQ-VALUE              TO WS-DEL-DAYS.            
      *                                                                 07470000
      *** CHECK IF ANY PAYMENTS WERE MADE BY CHECK W/IN LAST 10 DAYS    07480000
      *** GET DATE OF MOST RECENT PAYMENT BY CHECK                      07490000
      *                                                                 07490100
           MOVE WS-ACCOUNT-NO-NUM            TO AR-ACCOUNT-NO.          
           MOVE WS-DATE-10-DAYS-AGO          TO AR-DATE-TRANS.          
      *                                                                 07493000
           PERFORM 7090-GET-NO-OF-PYMTS             THRU 7090-EXIT.     
      *                                                                 07510000
           IF WS-NO-OF-PAYMENTS > 0                                     
               MOVE 'Y'                      TO RS-NON-CLEAR-CHECK-IND  
           ELSE                                                         
               MOVE 'N'                      TO RS-NON-CLEAR-CHECK-IND  
           END-IF.                                                      
      *                                                                 07570000
T20626     IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND  OR                    
T20626         WS-MAX-DATE-TRANS EQUAL LOW-VALUES OR SPACES             
T20626         CONTINUE                                                 
T20626     ELSE                                                         
T20626         MOVE 'N'                      TO WS-DATE-FOUND           
T20626         MOVE WS-MAX-DATE-TRANS        TO WS-WORK-DATE            
T20626         PERFORM 2450-GET-NEXT-BUSINESS-DAY        THRU 2450-EXIT 
T20626              VARYING WS-NEXT-DATE-COUNT   FROM 1  BY 1 UNTIL     
T20626                      WS-NEXT-DATE-COUNT > WS-DEL-DAYS            
T20626         MOVE WS-WORK-DATE             TO WS-DATE-TRANS-10        
T20626         MOVE ZEROS                    TO WS-ACTIVE-RETURN-CODE   
T20626     END-IF.                                                      
T20626     MOVE WS-DATE-TRANS-10             TO RS-MAX-DATE-TRANS.      
           MOVE WS-N                         TO WS-BILL-IMMEDIATELY.    
      *                                                                 07590200
      *** USING DEP-ON-HAND INFO, CALCULATE INTEREST                    07600000
      *                                                                 07601000
           PERFORM 7300-SELECT-DEP-ON-HAND           THRU 7300-EXIT.    
T28160     MOVE DO-CODE-DEP-TYPE             TO RS-CODE-DEP-TYPE.       
T28160     MOVE DO-CODE-REFUND-ELIG          TO RS-CODE-REF-ELIG.       
      *                                                                         
           PERFORM 5995-DEPOSIT-INTEREST-CALC        THRU 5995-EXIT.    
           MOVE WS-INTEREST-CALC             TO RS-INTEREST-AMT.        
      *                                                                 07750000
REARCH     PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT.    
           PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT.     
      *                                                                 07770000
       2400-EXIT.                                                       
           EXIT.                                                        
T20626***************************************************************** 07790102
T20626**                                                             ** 07790202
T20626**    2450-GET-NEXT-BUSINESS-DAY                               ** 07790302
T20626**                                                             ** 07790402
T20626***************************************************************** 07790502
T20626*                                                                 07790602
T20626 2450-GET-NEXT-BUSINESS-DAY.                                      
T20626*                                                                 07790802
T20626     PERFORM 7997-GET-NEXT-DAY                 THRU 7997-EXIT.    
T20626     IF WS-DAY EQUAL 6                                            
T20626        OR WS-DAY EQUAL ZEROES                                    
T20626        PERFORM 2460-GET-NEXT-DATE             THRU 2460-EXIT     
T20626           UNTIL WS-DATE-FOUND EQUAL WS-Y                         
T20626        IF WS-NEXT-DATE-COUNT > +1                                
T20626           SUBTRACT +1 FROM WS-NEXT-DATE-COUNT                    
T20626        END-IF                                                    
T20626     ELSE                                                         
T20626        MOVE WS-WORK-DATE     TO J8-HOLIDAY-DT                    
T20626        PERFORM 7995-SELECT-HOLIDAY THRU 7995-EXIT                
T20626        IF WS-HOLIDAY-EXISTS = 'Y'                                
T20626           PERFORM 2460-GET-NEXT-DATE THRU 2460-EXIT              
T20626              UNTIL WS-DATE-FOUND EQUAL WS-Y                      
T20626           IF WS-NEXT-DATE-COUNT > +1                             
T20626              SUBTRACT +1 FROM WS-NEXT-DATE-COUNT                 
T20626           END-IF                                                 
T20626        ELSE                                                      
T20626           MOVE WS-Y TO WS-DATE-FOUND                             
T20626        END-IF                                                    
T20626     END-IF.                                                      
T20626*                                                                 07793002
T20626 2450-EXIT.                                                       
T20626     EXIT.                                                        
T20626*                                                                 07793302
T20626***************************************************************** 07793402
T20626**                                                             ** 07793502
T20626**    2460-GET-NEXT-DATE                                       ** 07793602
T20626**                                                             ** 07793702
T20626***************************************************************** 07793802
T20626*                                                                 07793902
T20626 2460-GET-NEXT-DATE.                                              
T20626*                                                                 07794102
T20626     PERFORM 7997-GET-NEXT-DAY THRU 7997-EXIT.                    
T20626     IF WS-DAY EQUAL 6                                            
T20626        OR WS-DAY EQUAL ZEROES                                    
T20626        NEXT SENTENCE                                             
T20626     ELSE                                                         
T20626        MOVE WS-WORK-DATE     TO J8-HOLIDAY-DT                    
T20626        PERFORM 7995-SELECT-HOLIDAY THRU 7995-EXIT                
T20626        IF WS-HOLIDAY-EXISTS = 'Y'                                
T20626           NEXT SENTENCE                                          
T20626        ELSE                                                      
T20626           MOVE WS-Y TO WS-DATE-FOUND                             
T20626        END-IF                                                    
T20626     END-IF.                                                      
T20626*                                                                 07795502
T20626 2460-EXIT.                                                       
T20626     EXIT.                                                        
T21024                                                                  
T21024****************************************************************  07790201
T21024*GETS THE LAST-UPDATE-TS FROM CSS_ACCOUNT                      *  07790301
T21024****************************************************************  07790401
T21024 2600-GET-LAST-UPDATE-TS.                                         
T21024                                                                  
T21024     PERFORM 7500-SELECT-UPDATE-TS  THRU 7500-EXIT.               
T21024     MOVE AT-LAST-UPDATE-TS         TO RS-AT-LAST-UPD-TS.         
T21024                                                                  
T21024 2600-EXIT.                                                       
T21024     EXIT.                                                        
HPCCDM*EJECT                                                            07792001
T21024                                                                  
      *                                                                 08290000
      ******************************************************************09290100
      *  INCLUDE CPD00023 TO PROCESS DEPOSIT INTEREST CALCULATIONS     *09290200
      ******************************************************************09290300
      *                                                                 09290400
           EXEC SQL                                                     09291000
              INCLUDE CPD00023                                          09292000
           END-EXEC.                                                    09293000
      *                                                                 09293100
      ******************************************************************09293200
      *  6050-PROCESS-INTEREST-HIST                                    *09293300
      *  THIS PARAGRAPH IS CALLED BY CPD00023 TO UPDATE AND INSERT     *09293400
      *  RECORDS INTO TABLE CSS_INTEREST_HST.  THAT FUNCTIONALITY      *09293500
      *  EXISTS IN CPD00128.  BECAUSE THIS COMPONENT DOES NOT NEED TO  *09293600
      *  PROCESS INTEREST HISTORY CPD00128 IS NOT INCLUDED AND THIS    *09293700
      *  DUMMY PARAGRAPH IS ADDED.                                     *09293800
      ******************************************************************09293900
      *                                                                 09294000
       6050-PROCESS-INTEREST-HIST.                                      
      *                                                                 09295000
       6050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09298000
T20626******************************************************************09298202
T20626* 6791-SELECT-DELINQUENCY.                                       *09298302
T20626*          SELECTING THE NO. OF DAYS FOR THE CREDIT GROUP USING  *09298402
T20626*          THE TABLE CSS_DELINQUENCY                             *09298507
T20626*                                                                *09298602
T20626******************************************************************09298702
T20626*                                                                 09298807
T20626 6791-SELECT-DELINQUENCY.                                         
T20626*                                                                 09299007
T20626     EXEC SQL                                                     
T20626        SELECT DELINQ_VALUE                                       
T20626          INTO :C8-DELINQ-VALUE                                   
T20626          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
T20626         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
T35434                                                          
T20626     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09299102
MFA-TR*       SELECT DELINQ_VALUE                                       09299202
MFA-TR*         INTO :C8-DELINQ-VALUE                                   09299302
MFA-TR*         FROM CSS_DELINQUENCY                                    09299402
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                          09299502
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*        WITH  UR                                                         
MFA-TR*    END-EXEC.                                                    09299602

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20626     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20626     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20626        NEXT SENTENCE                                             
T20626     ELSE                                                         
T20626        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
T20626        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
T20626        MOVE '6791'                   TO ACTIVE-PARAGRAPH         
T20626        MOVE 'SELECT'                 TO ABEND-FUNCTION           
T20626        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
T20626                                         ABEND-TABLES             
T20626        MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
T20626        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
T20626        MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
T20626        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20626        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T20626     END-IF.                                                      
T20626*                                                                 09301302
T20626 6791-EXIT.                                                       
T20626     EXIT.                                                        
      *                                                                 09320002
       7060-GET-CURRENT-DATE.                                           
      *                                                                 10611000
           MOVE '7060'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 10630000
           EXEC SQL                                                     
T35434          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( DAY, -:WS-DEL-CAL-DAYS, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )
            INTO
              :WS-CURRENT-DATE,
              :WS-DATE-10-DAYS-AGO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     10640000
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE,                    10650000
MFA-TR*             :WS-DATE-10-DAYS-AGO =                              10670008
MFA-TR*                     CURRENT DATE - :WS-DEL-CAL-DAYS DAYS        10680000
MFA-TR*    END-EXEC.                                                    10720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10721000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 10731000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI  *       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             10800002
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 10821000
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10870000
       7090-GET-NO-OF-PYMTS.                                            
      *                                                                 10880100
           MOVE '7090'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 10882000
           EXEC SQL                                                     
               SELECT COUNT(*),                                         
                      MAX(DATE_TRANS)                                   
               INTO :WS-NO-OF-PAYMENTS,                                 
                    :WS-MAX-DATE-TRANS :WS-NULL-IND-4                   
               FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED),                 
                    CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                 
               WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              
                 AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO               
                 AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
                 AND AR.DATE_TRANS        > IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )              
                 AND AU.CURRENCY_TYPE    IN ('C', 'D')                  
                 AND AR.CODE_TRAN_TYPE    = 'P'                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10890000
MFA-TR*        SELECT COUNT(*),                                         10900000
MFA-TR*               MAX(DATE_TRANS)                                   10910000
MFA-TR*        INTO :WS-NO-OF-PAYMENTS,                                 10920000
MFA-TR*             :WS-MAX-DATE-TRANS :WS-NULL-IND-4                   10930000
MFA-TR*        FROM CSS_AR_TRANS_HIST AR,                               10940000
MFA-TR*             CSS_AR_TRN_HST_DET AU                               10950000
MFA-TR*        WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              10960000
MFA-TR*          AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO               10970000
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        10980000
MFA-TR*          AND AR.DATE_TRANS        > :AR-DATE-TRANS              10990000
MFA-TR*          AND AU.CURRENCY_TYPE    IN ('C', 'D')                  11000000
MFA-TR*          AND AR.CODE_TRAN_TYPE    = 'P'                         11010000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    11020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11021000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 11031000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-4 < ZERO                                   
                  MOVE LOW-VALUES            TO WS-MAX-DATE-TRANS       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
              MOVE WS-DATE-10-DAYS-AGO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                 11181000
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11210000
       7100-FETCH-AR-HISTORY.                                           
      *                                                                 11230100
CBSI       MOVE '7100'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 11232000
           EXEC SQL                                                     
                FETCH  AR_HISTORY                                       
                INTO   :AR-TRANS-HIST-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11271000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-FETCH-HIST.          
      *                                                                 11291000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
CBSI          MOVE WS-DATE-10-DAYS-AGO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                 11401000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11430000
       7110-CLOSE-AR-HISTORY.                                           
      *                                                                 11441000
           EXEC SQL                                                     
                CLOSE AR_HISTORY                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11471000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 11481000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
CBSI          MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
CBSI          MOVE WS-DATE-10-DAYS-AGO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 11591000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11630000
       7120-OPEN-AR-HIST-DET.                                           
      *                                                                 11643001
           EXEC SQL                                                     
               OPEN AR_HISTORY_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11671000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 11681000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
CBSI          MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
CBSI          MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                 11781000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11810000
       7130-FETCH-AR-HIST-DET.                                          
      *                                                                 11821000
           EXEC SQL                                                     
                FETCH  AR_HISTORY_DET                                   
                INTO   :WS-NO-OF-PYMTS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11861000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-FETCH-DET.           
      *                                                                 11881000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
CBSI          MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                 11991000
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12020000
       7140-CLOSE-AR-HIST-DET.                                          
      *                                                                 12031000
           EXEC SQL                                                     
                CLOSE AR_HISTORY_DET                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12061000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 12071000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
CBSI          MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 12181000
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12210000
      ******************************************************************12920000
      * 7260-SELECT-ACCOUNT                                            *12930000
      *                                                                *12940000
      *     CALLS       9000-SEND-ERROR-RESULT                         *12950000
      *                 9900-SQL-ERROR-ROUTINE                         *12960000
      *                                                                *12970000
      *     CALLED FROM 2400-BUILD-RESULT                              *12980000
      *                                                                *12990000
      *     RETRIEVE ACCOUNT INFORMATION.                              *13000000
      ******************************************************************13010000
      *                                                                 13020000
       7260-SELECT-ACCOUNT.                                             
      *                                                                 13040000
           MOVE '7260'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 13060000
           EXEC SQL                                                     
              SELECT  CODES_DATA_PRESENT,                               
                      ADDRESS_ID,                                       
                      ADDRESS_FORMAT,                                   
                      COMPANY_NO,                                       
                      LOCAL_OFFICE                                      
              INTO    :AT-CODES-DATA-PRESENT,                           
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :AT-COMPANY-NO,                                   
                      :AT-LOCAL-OFFICE                                  
              FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                         
              WHERE   ACCOUNT_NO    = :WS-ACCOUNT-NO-NUM                
T35434                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13070000
MFA-TR*       SELECT  CODES_DATA_PRESENT,                               13080000
MFA-TR*               ADDRESS_ID,                                       13090000
MFA-TR*               ADDRESS_FORMAT,                                   13100000
MFA-TR*               COMPANY_NO,                                       13110000
MFA-TR*               LOCAL_OFFICE                                      13120000
MFA-TR*       INTO    :AT-CODES-DATA-PRESENT,                           13130000
MFA-TR*               :AT-ADDRESS-ID,                                   13140000
MFA-TR*               :AT-ADDRESS-FORMAT,                               13150000
MFA-TR*               :AT-COMPANY-NO,                                   13160000
MFA-TR*               :AT-LOCAL-OFFICE                                  13170000
MFA-TR*       FROM    CSS_ACCOUNT                                       13180000
MFA-TR*       WHERE   ACCOUNT_NO    = :WS-ACCOUNT-NO-NUM                13190000
MFA-TR*       WITH    UR                                                        
MFA-TR*    END-EXEC.                                                    13200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13210000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 13230000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI  *       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             13320002
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 13350000
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13380000
      ******************************************************************13390000
      * 7265-SELECT-PREMISE                                            *13400000
      *                                                                *13410000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13420000
      *                 9900-SQL-ERROR-ROUTINE                         *13430000
      *                                                                *13440000
      *     CALLED FROM 2400-BUILD-RESULT                              *13450000
      *                                                                *13460000
      *     RETRIEVE PREMISE INFORMATION.                              *13470000
      ******************************************************************13480000
      *                                                                 13490000
       7265-SELECT-PREMISE.                                             
      *                                                                 13510000
           MOVE '7265'                        TO ACTIVE-PARAGRAPH.      
      *                                                                 13530000
           EXEC SQL                                                     
              SELECT  REV_DISTRICT_CD,                                  
                      ADDRESS_ID,                                       
                      ADDRESS_FORMAT                                    
              INTO    :PR-REV-DISTRICT-CD,                              
                      :PR-ADDRESS-ID,                                   
                      :PR-ADDRESS-FORMAT                                
              FROM    CSS_PREMISE WITH(READUNCOMMITTED)                         
              WHERE   PREMISE_NO     = :WS-PREMISE-NO-NUM               
T35434                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13540000
MFA-TR*       SELECT  REV_DISTRICT_CD,                                  13550000
MFA-TR*               ADDRESS_ID,                                       13560000
MFA-TR*               ADDRESS_FORMAT                                    13570000
MFA-TR*       INTO    :PR-REV-DISTRICT-CD,                              13580000
MFA-TR*               :PR-ADDRESS-ID,                                   13590000
MFA-TR*               :PR-ADDRESS-FORMAT                                13600000
MFA-TR*       FROM    CSS_PREMISE                                       13610000
MFA-TR*       WHERE   PREMISE_NO     = :WS-PREMISE-NO-NUM               13620000
MFA-TR*       WITH    UR                                                        
MFA-TR*    END-EXEC.                                                    13630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13640000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 13660000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO-NUM          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE WS-ACCOUNT-NO-NUM          TO HOSTVAR-ELEMENT-2      
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 13780000
       7265-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13810000
      ******************************************************************13820000
      * 7300-SELECT-DEP-ON-HAND                                        *13830000
      *                                                                *13840000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13850000
      *                 9900-SQL-ERROR-ROUTINE                         *13860000
      *                                                                *13870000
      *     CALLED FROM 2400-BUILD-RESULT                              *13880000
      *                                                                *13890000
      *     SELECT DEP ON HAND INFO FOR A SINGLE DEPOSIT               *13900000
      ******************************************************************13910000
      *                                                                 13920000
       7300-SELECT-DEP-ON-HAND.                                         
      *                                                                 13940000
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
      *                                                                 13960000
           EXEC SQL                                                     
               SELECT                                                   
                      AMT_DEPOSIT,                                      
                      SERVICE_TYPE_CD,                                  
                      DEPOSIT_CERT_NO,                                  
                      DATE_PYMT_START,                                  
                      DATE_CERT_ISSUE,                                  
                      COMMENTS,                                         
C29752                DATE_INTST_CALC_TO,                               
T28160                CODE_DEP_TYPE,                                    
T28160                CODE_REFUND_ELIG                                  
               INTO  :DO-AMT-DEPOSIT,                                   
                     :DO-SERVICE-TYPE-CD,                               
                     :DO-DEPOSIT-CERT-NO,                               
                     :DO-DATE-PYMT-START :WS-NULL-IND-1,                
                     :DO-DATE-CERT-ISSUE :WS-NULL-IND-2,                
                     :DO-COMMENTS,                                      
                     :DO-DATE-INTST-CALC-TO :WS-NULL-IND-3,             
T28160               :DO-CODE-DEP-TYPE,                                 
T28160               :DO-CODE-REFUND-ELIG                               
               FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO          = :WS-ACCOUNT-NO-NUM           
                 AND DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO          
PCR482           AND (DEPOSIT_STATUS_CD = 'A' OR                        
PCR482                DEPOSIT_STATUS_CD = 'P')                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13970000
MFA-TR*        SELECT                                                   13980000
MFA-TR*               AMT_DEPOSIT,                                      13990000
MFA-TR*               SERVICE_TYPE_CD,                                  14000000
MFA-TR*               DEPOSIT_CERT_NO,                                  14010000
MFA-TR*               DATE_PYMT_START,                                  14020000
MFA-TR*               DATE_CERT_ISSUE,                                  14030000
MFA-TR*               COMMENTS,                                         14040000
MFA-TR*               DATE_INTST_CALC_TO,                               14050000
MFA-TR*               CODE_DEP_TYPE,                                            
MFA-TR*               CODE_REFUND_ELIG                                          
MFA-TR*        INTO  :DO-AMT-DEPOSIT,                                   14060000
MFA-TR*              :DO-SERVICE-TYPE-CD,                               14070000
MFA-TR*              :DO-DEPOSIT-CERT-NO,                               14080000
MFA-TR*              :DO-DATE-PYMT-START :WS-NULL-IND-1,                14090000
MFA-TR*              :DO-DATE-CERT-ISSUE :WS-NULL-IND-2,                14100000
MFA-TR*              :DO-COMMENTS,                                      14110000
MFA-TR*              :DO-DATE-INTST-CALC-TO :WS-NULL-IND-3,             14120000
MFA-TR*              :DO-CODE-DEP-TYPE,                                         
MFA-TR*              :DO-CODE-REFUND-ELIG                                       
MFA-TR*        FROM CSS_DEP_ON_HAND                                     14130000
MFA-TR*        WHERE ACCOUNT_NO          = :WS-ACCOUNT-NO-NUM           14140000
MFA-TR*          AND DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO          14150000
MFA-TR*          AND (DEPOSIT_STATUS_CD = 'A' OR                        14160000
MFA-TR*               DEPOSIT_STATUS_CD = 'P')                          14161000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    14170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14171000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 14181000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1 < ZERO                                   
                  MOVE LOW-VALUES            TO DO-DATE-PYMT-START      
              END-IF                                                    
              IF WS-NULL-IND-2 < ZERO                                   
                  MOVE LOW-VALUES            TO DO-DATE-CERT-ISSUE      
              END-IF                                                    
              IF WS-NULL-IND-3 < ZERO                                   
                  MOVE LOW-VALUES            TO DO-DATE-INTST-CALC-TO   
              END-IF                                                    
T28160        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T28160            MOVE 'Z'                   TO DO-CODE-DEP-TYPE        
T28160            MOVE 'Z'                   TO DO-CODE-REFUND-ELIG     
T28160        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEP_ON_HAND'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'DEPOSIT_CERT_NO'         TO TABLE-ELEMENT-2         
CBSI          MOVE DO-DEPOSIT-CERT-NO        TO HOSTVAR-ELEMENT-2       
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 14371000
       7300-EXIT.                                                       
           EXIT.                                                        
T28160*                                                                 14371000
T21024******************************************************************14390101
T21024* GETS LAST_UPDATE_TS FROM CSS_ACCOUNT FOR THE PARM-ACCOUNT-NO   *14390201
T21024******************************************************************14390301
T21024 7500-SELECT-UPDATE-TS.                                           
T21024*                                                                 14390501
T21024     EXEC SQL                                                     
T21024         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
T21024           INTO :AT-LAST-UPDATE-TS                                
T21024           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T21024           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
T35434                                                           
T21024     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14390601
MFA-TR*        SELECT LAST_UPDATE_TS                                    14390701
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                14390801
MFA-TR*          FROM CSS_ACCOUNT                                       14390901
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      14391001
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    14391101

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21024*                                                                 14391201
T21024     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T21024     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T21024         CONTINUE                                                 
T21024     ELSE                                                         
T21024         MOVE WS-ACTIVE-RETURN-CODE                               
T21024                                       TO   RS-RETURN-CODE        
T21024         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
T21024         MOVE '7500'                   TO   ACTIVE-PARAGRAPH      
T21024         MOVE 'SELECT'                 TO   ABEND-FUNCTION        
T21024         MOVE SPACES                   TO   ABEND-SQL-PREDICATES  
T21024                                            ABEND-TABLES          
T21024         MOVE 'CSS_ACCOUNT'            TO   TABLE-1               
T21024         MOVE 'ACCOUNT_NO'             TO   TABLE-ELEMENT-1       
T21024         MOVE AT-ACCOUNT-NO            TO   HOSTVAR-ELEMENT-1     
T21024         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T21024         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T21024     END-IF.                                                      
T21024                                                                  
T21024 7500-EXIT.                                                       
T21024     EXIT.                                                        
      *                                                                 15690000
T20626***************************************************************** 14393402
T20626* 7995-SELECT-HOLIDAY                                           * 14393502
T20626*     SELECTS CSS_HOLIDAY TABLE TO CHECK HOLIDAY                * 14393602
T20626***************************************************************** 14393702
T20626*                                                                 14393802
T20626 7995-SELECT-HOLIDAY.                                             
T20626     MOVE 'N' TO WS-HOLIDAY-EXISTS.                               
T20626*                                                                 14394102
T20626     EXEC SQL                                                     
T20626       SELECT    DISTINCT ('Y')                                   
T20626       INTO      :WS-HOLIDAY-EXISTS                               
T20626       FROM      CSS_HOLIDAY WITH(READUNCOMMITTED)                        
T20626       WHERE     HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                      
T35434                                                           
T20626     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14394202
MFA-TR*      SELECT    DISTINCT ('Y')                                   14394302
MFA-TR*      INTO      :WS-HOLIDAY-EXISTS                               14394402
MFA-TR*      FROM      CSS_HOLIDAY                                      14394502
MFA-TR*      WHERE     HOLIDAY_DT = :J8-HOLIDAY-DT                      14394602
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    14394702

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20626*                                                                 14394802
T20626     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T20626*                                                                 14395002
T20626     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T20626        OR NOT-FOUND                                              
T20626         NEXT SENTENCE                                            
T20626     ELSE                                                         
T20626        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T20626        MOVE '7995'                     TO ACTIVE-PARAGRAPH       
T20626        MOVE 'SELECT            '       TO ABEND-FUNCTION         
T20626        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T20626                                           ABEND-TABLES           
T20626        MOVE 'CSS_HOLIDAY       '       TO TABLE-1                
T20626        MOVE 'HOLIDAY_DT'               TO TABLE-ELEMENT-1        
T20626        MOVE J8-HOLIDAY-DT              TO HOSTVAR-ELEMENT-1      
T20626        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T20626        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
T20626        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T20626        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T20626     END-IF.                                                      
T20626*                                                                 14396802
T20626 7995-EXIT.                                                       
T20626     EXIT.                                                        
T20626*                                                                 14397102
T20626***************************************************************** 14397202
T20626* 7997-GET-NEXT-DAY                                             * 14397302
T20626*                                                               * 14397402
T20626*     GETS THE DAY( 0 THRU 6) OF THE NEXT DAY                   * 14397502
T20626*                 (SUNDAY THRU SATURDAY)                        * 14397602
T20626***************************************************************** 14397702
T20626*                                                                 14397802
T20626 7997-GET-NEXT-DAY.                                               
T20626     EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))          
T35434                           - (CIS.DAYS(DATEADD( DAY, 1, 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY                      
T20626     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     14398002
MFA-TR*      SET :WS-WORK-DATE = DATE(:WS-WORK-DATE) + 1 DAYS,          14398102
MFA-TR*          :WS-DAY = DAYS (DATE(:WS-WORK-DATE) + 1 DAYS)          14398202
MFA-TR*                          - (INTEGER(DAYS(DATE(:WS-WORK-DATE)    14398302
MFA-TR*                          + 1 DAYS)/7) * 7)                      14398402
MFA-TR*    END-EXEC.                                                    14398802

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20626*                                                                 14398902
T20626     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T20626*                                                                 14399102
T20626     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T20626        CONTINUE                                                  
T20626     ELSE                                                         
T20626        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T20626        MOVE '7997'                     TO ACTIVE-PARAGRAPH       
T35434        MOVE 'SET               '       TO ABEND-FUNCTION         
T20626        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T20626                                           ABEND-TABLES           
T20626        MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
T20626        MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
T20626        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T20626        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
T20626        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T20626        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T20626     END-IF.                                                      
T20626*                                                                 14400802
T20626 7997-EXIT.                                                       
T20626     EXIT.                                                        
      *                                                                 15690000
      ******************************************************************15700000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     15710000
      ******************************************************************15720000
      *                                                                 15721000
           EXEC SQL                                                     15730000
              INCLUDE CPDSP300                                          15740000
           END-EXEC.                                                    15750000
      *                                                                 15760000
      ******************************************************************15770000
      *       CICS ABEND PARAGRAPH FOR CPD00023                        *15780000
      ******************************************************************15790000
      *                                                                 15791000
           COPY CPD0023C.                                               15800000
      *                                                                 15800100
      ******************************************************************15801000
      *       END PROGRAM COPYLIB                                      *15802000
      ******************************************************************15803000
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
