       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02150.                                     
COB303 DATE-WRITTEN.                                                    
COB303            JUNE 23, 2005.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S150                                           *        
      *  PROGRAM:       S150                                           *        
      *  CALLING SP:    PA_S150                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ZERO TO MANY INSTANCES OF A CUSTOMER'S *        
      *  SURETY BOND OR LETTER OF CREDIT DETAILS (INCLUDING THOSE OF   *        
      *  OTHER CUSTOMERS ATTACHED TO THE SELECTED LATTER OF CREDIT)    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/25/95    SK       CREATED.                                 *        
      *                                                                *        
MAD617*  06/17/97    MAD      MODIFIED PROGRAM TO LOOK FOR THE ADDRESS *        
      *                        ID AND FORMAT ON CSS_PREMISE RATHER THAN*        
      *                        CSS_ACCOUNT (SERVICE ADDRESS RATHER THAN*        
      *                        MAILING ADDRESS).                       *        
T15454*  03/18/98    SHF      MODIFIED ACCT-CURSOR SO THAT ROWS FROM   *        
      *                       CSS_SURETY_BOND WOULD BE RETRIEVED       *        
      *                       REGARDLESS OF WHETHER THERE IS AN USERID *        
      *                       ON CSS_USER_PROFILE TABLE.               *        
T15850*  04/15/98    SHF      ADDED RS-CODE-ACCT-STAT TO THE RESULT SET*        
CBSI  *  09/11/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
REARCH*  06/23/05    CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02150'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02150 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_SURETY_BOND >                                                   
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME_ACCT_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FORMATTED >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FREEFORM >                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_USER_PROFILE  >                                                 
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
MAD617     EXEC SQL                                                             
MAD617        INCLUDE TBPREM                                                    
MAD617     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                POINTER.                                 
REARCH*    05  GWL-INIT-HANDLE         POINTER.                                 
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02150_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH 01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-BOND-TYPE          PIC X(01) VALUE SPACES.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.                  
REARCH     05  PARM-ACCOUNT-NO-NUM     PIC S9(13)V USAGE COMP-3         
                                                 VALUE 0.               
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
       01  WS-MISC.                                                     
REARCH     05  WS-SQLSTATE             PIC X(5).                        
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02150'.      
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 50 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-MONTH                PIC X(02) VALUE SPACES.          
           05  WS-DAY                  PIC X(02) VALUE SPACES.          
           05  WS-YEAR                 PIC X(04) VALUE SPACES.          
                                                                        
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-DATE-BOND-ISSUED-NI    PIC S9(4) COMP VALUE 0.        
           05  WS-TRIGGER-DATE-NI        PIC S9(4) COMP VALUE 0.        
           05  WS-BOND-EXPIRATION-DT-NI  PIC S9(4) COMP VALUE 0.        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-WAIV-ITEM-ID         PIC X(09) VALUE SPACE.           
           05  RS-ACCOUNT-NO           PIC X(13) VALUE SPACE.           
           05  RS-AMT-BOND             PIC S9(9)V9(2) USAGE COMP-3      
                                           VALUE 0.                     
REARCH*    05  RS-BOND-CO-NO           PIC 9(06) COMP VALUE 0.                  
REARCH     05  RS-BOND-CO-NO           PIC S9(6)V USAGE COMP-3          
REARCH                                     VALUE 0.                     
           05  RS-CODE-STATUS          PIC X(01) VALUE SPACE.           
           05  RS-TRIGGER-DATE         PIC X(08) VALUE SPACE.           
           05  RS-CODE-STATUS-REAS     PIC X(20) VALUE SPACE.           
           05  RS-ORIGINATED-BY        PIC X(20) VALUE SPACE.           
           05  RS-BOND-NO              PIC X(16) VALUE SPACE.           
           05  RS-BOND-TOTAL-AMT       PIC S9(9)V9(2) USAGE COMP-3      
                                           VALUE 0.                     
           05  RS-ISSUE-DATE           PIC X(08) VALUE SPACE.           
           05  RS-EXPIRATION-DATE      PIC X(08) VALUE SPACE.           
           05  RS-NAME                 PIC X(50) VALUE SPACE.           
           05  RS-ADDRESS              PIC X(50) VALUE SPACE.           
T15850     05  RS-CODE-ACCT-STAT       PIC X(01) VALUE SPACE.           
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-WAIV-ITEM-ID         PIC X(09) VALUE SPACE.            
REARCH     05  S-ACCOUNT-NO           PIC X(13) VALUE SPACE.            
REARCH     05  S-AMT-BOND             PIC S9(9)V9(2) USAGE COMP-3       
REARCH                                     VALUE 0.                     
REARCH     05  S-BOND-CO-NO           PIC S9(6)V USAGE COMP-3           
REARCH                                     VALUE 0.                     
REARCH     05  S-CODE-STATUS          PIC X(01) VALUE SPACE.            
REARCH     05  S-TRIGGER-DATE         PIC X(08) VALUE SPACE.            
REARCH     05  S-CODE-STATUS-REAS     PIC X(20) VALUE SPACE.            
REARCH     05  S-ORIGINATED-BY        PIC X(20) VALUE SPACE.            
REARCH     05  S-BOND-NO              PIC X(16) VALUE SPACE.            
REARCH     05  S-BOND-TOTAL-AMT       PIC S9(9)V9(2) USAGE COMP-3       
REARCH                                     VALUE 0.                     
REARCH     05  S-ISSUE-DATE           PIC X(08) VALUE SPACE.            
REARCH     05  S-EXPIRATION-DATE      PIC X(08) VALUE SPACE.            
REARCH     05  S-NAME                 PIC X(50) VALUE SPACE.            
REARCH     05  S-ADDRESS              PIC X(50) VALUE SPACE.            
REARCH     05  S-CODE-ACCT-STAT       PIC X(01) VALUE SPACE.            
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE        PIC X(11) VALUE                           
REARCH*                                       'RETURN_CODE'.                    
REARCH*    05  CNS-WAIV-ITEM-ID       PIC X(12) VALUE                           
REARCH*                                       'WAIV_ITEM_ID'.                   
REARCH*    05  CNS-ACCOUNT-NO         PIC X(10) VALUE                           
REARCH*                                       'ACCOUNT_NO'.                     
REARCH*    05  CNS-AMT-BOND           PIC X(08) VALUE 'AMT_BOND'.               
REARCH*    05  CNS-BOND-CO-NO         PIC X(10) VALUE 'BOND_CO_NO'.             
REARCH*    05  CNS-CODE-STATUS        PIC X(11) VALUE 'CODE_STATUS'.            
REARCH*    05  CNS-TRIGGER-DATE       PIC X(12) VALUE 'TRIGGER_DATE'.           
REARCH*    05  CNS-CODE-STATUS-REAS   PIC X(16) VALUE                           
REARCH*                                         'CODE_STATUS_REAS'.             
REARCH*    05  CNS-ORIGINATED-BY      PIC X(13) VALUE 'ORIGINATED_BY'.          
REARCH*    05  CNS-BOND-NO            PIC X(07) VALUE 'BOND_NO'.                
REARCH*    05  CNS-BOND-TOTAL-AMT     PIC X(14) VALUE                           
REARCH*                                          'BOND_TOTAL_AMT'.              
REARCH*    05  CNS-ISSUE-DATE         PIC X(10) VALUE 'ISSUE_DATE'.             
REARCH*    05  CNS-EXPIRATION-DATE    PIC X(15) VALUE                           
REARCH*                                          'EXPIRATION_DATE'.             
REARCH*    05  CNS-NAME               PIC X(04) VALUE 'NAME'.                   
REARCH*    05  CNS-ADDRESS            PIC X(07) VALUE 'ADDRESS'.                
REARCH*    05  CNS-CODE-ACCT-STAT     PIC X(14) VALUE 'CODE_ACCT_STAT'.         
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE BOND-CURSOR CURSOR FOR                      
              SELECT BOND_WAIV_ITEM_ID                                  
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO = :PARM-ACCOUNT-NO-NUM AND              
                     CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                
           END-EXEC.                                                    
                                                                        
           EXEC SQL DECLARE ACCT-CURSOR CURSOR FOR                      
              SELECT SB.ACCOUNT_NO, SB.BOND_NO,                         
                     SB.USER_ID_ORIG_BY,                                
                     CIS.CHAR2$DATE(SB.DATE_BOND_ISSUED,'USA'),                 
                     SB.AMT_BOND, SB.BOND_CO_NO, SB.CODE_STATUS,        
                     SB.CODE_STATUS_REAS, SB.BOND_TOTAL_AMT,            
                     CIS.CHAR2$DATE(SB.TRIGGER_DATE, 'USA'),                    
                     CIS.CHAR2$DATE(SB.BOND_EXPIRATION_DT,'USA')                
                FROM CSS_SURETY_BOND SB                                 
               WHERE BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE ACCT-CURSOR CURSOR FOR                              
MFA-TR*       SELECT SB.ACCOUNT_NO, SB.BOND_NO,                                 
MFA-TR*              SB.USER_ID_ORIG_BY,                                        
MFA-TR*              CHAR(SB.DATE_BOND_ISSUED,USA),                             
MFA-TR*              SB.AMT_BOND, SB.BOND_CO_NO, SB.CODE_STATUS,                
MFA-TR*              SB.CODE_STATUS_REAS, SB.BOND_TOTAL_AMT,                    
MFA-TR*              CHAR(SB.TRIGGER_DATE, USA),                                
MFA-TR*              CHAR(SB.BOND_EXPIRATION_DT,USA)                            
MFA-TR*         FROM CSS_SURETY_BOND SB                                         
MFA-TR*        WHERE BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID                  
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-BOND-TYPE          PIC X(01).                           
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH PROCEDURE DIVISION USING PARM-BOND-TYPE                          
REARCH                          PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           RETURN_CODE                                            
REARCH          ,LTRIM(RTRIM(ACCOUNT_NO))          AS ACCOUNT_NO               
REARCH          ,AMT_BOND                                               
REARCH          ,LTRIM(RTRIM(WAIV_ITEM_ID))        AS WAIV_ITEM_ID             
REARCH          ,BOND_CO_NO                                             
REARCH          ,CODE_STATUS                                            
REARCH          ,TRIGGER_DATE                                           
REARCH          ,LTRIM(RTRIM(CODE_STATUS_REAS))    AS CODE_STATUS_REAS         
REARCH          ,LTRIM(RTRIM(ORIGINATED_BY))       AS ORIGINATED_BY            
REARCH          ,LTRIM(RTRIM(BOND_NO))             AS BOND_NO                  
REARCH          ,BOND_TOTAL_AMT                                         
REARCH          ,ISSUE_DATE                                             
REARCH          ,EXPIRATION_DATE                                        
REARCH          ,LTRIM(RTRIM(NAME))                AS NAME                     
REARCH          ,LTRIM(RTRIM(ADDRESS))             AS ADDRESS                  
REARCH          ,CODE_ACCT_STAT                                         
REARCH         FROM                                                     
REARCH             #CSR02150_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          RETURN_CODE                                                    
MFA-TR*         ,STRIP(ACCOUNT_NO)          AS ACCOUNT_NO                       
MFA-TR*         ,AMT_BOND                                                       
MFA-TR*         ,STRIP(WAIV_ITEM_ID)        AS WAIV_ITEM_ID                     
MFA-TR*         ,BOND_CO_NO                                                     
MFA-TR*         ,CODE_STATUS                                                    
MFA-TR*         ,TRIGGER_DATE                                                   
MFA-TR*         ,STRIP(CODE_STATUS_REAS)    AS CODE_STATUS_REAS                 
MFA-TR*         ,STRIP(ORIGINATED_BY)       AS ORIGINATED_BY                    
MFA-TR*         ,STRIP(BOND_NO)             AS BOND_NO                          
MFA-TR*         ,BOND_TOTAL_AMT                                                 
MFA-TR*         ,ISSUE_DATE                                                     
MFA-TR*         ,EXPIRATION_DATE                                                
MFA-TR*         ,STRIP(NAME)                AS NAME                             
MFA-TR*         ,STRIP(ADDRESS)             AS ADDRESS                          
MFA-TR*         ,CODE_ACCT_STAT                                                 
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02150_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02150_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02150_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02150_R1
               (                                                       
REARCH             RETURN_CODE         INT                          
REARCH            ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,AMT_BOND            DECIMAL(11,2)                    
REARCH            ,WAIV_ITEM_ID CHAR(09)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH            ,BOND_CO_NO          DECIMAL(6,0)                     
REARCH            ,CODE_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,TRIGGER_DATE CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH            ,CODE_STATUS_REAS CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH            ,ORIGINATED_BY CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH            ,BOND_NO CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH            ,BOND_TOTAL_AMT      DECIMAL(11,2)                    
REARCH            ,ISSUE_DATE CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,EXPIRATION_DATE CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH            ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2               
REARCH            ,ADDRESS CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH            ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02150_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
           MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-NUM.       
           MOVE PARM-BOND-TYPE            TO SB-CODE-BOND-TYPE.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*    MOVE 1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-BOND-TYPE   TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-BOND-TYPE,                                
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                           TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                  
REARCH     MOVE RS-AMT-BOND           TO S-AMT-BOND.                    
REARCH     MOVE RS-WAIV-ITEM-ID       TO S-WAIV-ITEM-ID.                
REARCH     MOVE RS-BOND-CO-NO         TO S-BOND-CO-NO.                  
REARCH     MOVE RS-CODE-STATUS        TO S-CODE-STATUS.                 
REARCH     MOVE RS-TRIGGER-DATE       TO S-TRIGGER-DATE.                
REARCH     MOVE RS-CODE-STATUS-REAS   TO S-CODE-STATUS-REAS.            
REARCH     MOVE RS-ORIGINATED-BY      TO S-ORIGINATED-BY.               
REARCH     MOVE RS-BOND-NO            TO S-BOND-NO.                     
REARCH     MOVE RS-BOND-TOTAL-AMT     TO S-BOND-TOTAL-AMT.              
REARCH     MOVE RS-ISSUE-DATE         TO S-ISSUE-DATE.                  
REARCH     MOVE RS-EXPIRATION-DATE    TO S-EXPIRATION-DATE.             
REARCH     MOVE RS-NAME               TO S-NAME.                        
REARCH     MOVE RS-ADDRESS            TO S-ADDRESS.                     
REARCH     MOVE RS-CODE-ACCT-STAT     TO S-CODE-ACCT-STAT.              
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*    MOVE '2100'          TO ACTIVE-PARAGRAPH                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-RETURN-CODE>                                            
REARCH*    MOVE 1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RETURN-CODE,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-ACCOUNT-NO >                                            
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ACCOUNT-NO      TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-ACCOUNT-NO     TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ACCOUNT-NO,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ACCOUNT-NO,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-AMT-BOND >                                              
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSDECIMAL   TO DB-HOST-TYPE.                                   
REARCH*    MOVE TDSFLT8      TO DB-CLIENT-TYPE.                                 
REARCH*    MOVE LENGTH OF RS-AMT-BOND        TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-AMT-BOND       TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-AMT-BOND,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-AMT-BOND,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    MOVE +2               TO WRKLEN2.                                    
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-WAIV-ITEM-ID >                                          
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-WAIV-ITEM-ID     TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-WAIV-ITEM-ID    TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-WAIV-ITEM-ID,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-WAIV-ITEM-ID,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-BOND-CO-NO >                                            
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-BOND-CO-NO     TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CNS-BOND-CO-NO    TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BOND-CO-NO,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BOND-CO-NO,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-CODE-STATUS >                                           
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-CODE-STATUS     TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-CODE-STATUS    TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-STATUS,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-CODE-STATUS,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-TRIGGER-DATE >                                          
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-TRIGGER-DATE   TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CNS-TRIGGER-DATE  TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TRIGGER-DATE,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TRIGGER-DATE,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-CODE-STATUS-REAS >                                      
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-CODE-STATUS-REAS  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-CODE-STATUS-REAS TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-STATUS-REAS,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-CODE-STATUS-REAS,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-ORIGINATED-BY >                                         
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ORIGINATED-BY  TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CNS-ORIGINATED-BY TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ORIGINATED-BY,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ORIGINATED-BY,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-BOND-NO >                                               
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-BOND-NO           TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-BOND-NO          TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BOND-NO,                                    
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BOND-NO,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-BOND-TOTAL-AMT >                                        
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSDECIMAL   TO DB-HOST-TYPE.                                   
REARCH*    MOVE TDSFLT8      TO DB-CLIENT-TYPE.                                 
REARCH*    MOVE LENGTH OF RS-BOND-TOTAL-AMT  TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-BOND-TOTAL-AMT TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BOND-TOTAL-AMT,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BOND-TOTAL-AMT,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    MOVE +2               TO WRKLEN2.                                    
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-ISSUE-DATE >                                            
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ISSUE-DATE   TO WRKLEN1.                           
REARCH*    MOVE LENGTH OF CNS-ISSUE-DATE  TO WRKLEN2.                           
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ISSUE-DATE,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ISSUE-DATE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-EXPIRATION-DATE >                                       
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-EXPIRATION-DATE  TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-EXPIRATION-DATE TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-EXPIRATION-DATE,                            
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-EXPIRATION-DATE,                           
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-NAME >                                                  
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-NAME  TO WRKLEN1.                                  
REARCH*    MOVE LENGTH OF CNS-NAME TO WRKLEN2.                                  
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-NAME,                                       
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-NAME,                                      
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-ADDRESS >                                               
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ADDRESS           TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-ADDRESS          TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDRESS,                                    
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ADDRESS,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*---< DESCRIBE RS-CODE-ACCT-STAT >                                        
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-CODE-ACCT-STAT    TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-CODE-ACCT-STAT   TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-ACCT-STAT,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-CODE-ACCT-STAT,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-BOND-CURSOR        THRU 7000-EXIT.         
           PERFORM 7010-FETCH-BOND-CURSOR       THRU 7010-EXIT.         
                                                                        
           PERFORM                                                      
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              PERFORM 2300-PROCESS-BOND         THRU 2300-EXIT          
              PERFORM 7010-FETCH-BOND-CURSOR    THRU 7010-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7020-CLOSE-BOND-CURSOR       THRU 7020-EXIT.         
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE 100                          TO   RS-RETURN-CODE     
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2300-PROCESS-BOND                                            *          
      *                                                              *          
      *   1. SELECT ALL THE ACCOUNTS COVERED BY THE BOND NUMBER      *          
      *      ALONG WITH THE CORRESPONDING SURETY BOND / LETTER OF    *          
      *      CREDIT DELAILS.                                         *          
      ****************************************************************          
                                                                        
       2300-PROCESS-BOND.                                               
                                                                        
           PERFORM 7100-OPEN-ACCT-CURSOR        THRU 7100-EXIT.         
           PERFORM 7110-FETCH-ACCT-CURSOR       THRU 7110-EXIT.         
T15454     PERFORM 7190-SELECT-USERID-NAME      THRU 7190-EXIT.         
                                                                        
           PERFORM                                                      
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              PERFORM 2400-PROCESS-ACCT         THRU 2400-EXIT          
              PERFORM 7110-FETCH-ACCT-CURSOR    THRU 7110-EXIT          
T15454        PERFORM 7190-SELECT-USERID-NAME   THRU 7190-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-ACCT-CURSOR       THRU 7120-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2400-PROCESS-ACCT                                            *          
      *                                                              *          
      *   1. SELECT ADDRESS & NAME DETAILS FOR THE ACCOUNT  FETCHED  *          
      *   2. SEND THE RESULTS.                                       *          
      ****************************************************************          
                                                                        
       2400-PROCESS-ACCT.                                               
                                                                        
           MOVE SB-ACCOUNT-NO             TO AT-ACCOUNT-NO              
                                             HT-ACCOUNT-NO.             
           PERFORM 7200-SELECT-ACCT           THRU 7200-EXIT.           
T15850     MOVE AT-CODE-ACCT-STAT         TO RS-CODE-ACCT-STAT.         
MAD617     MOVE AT-PREMISE-NO             TO PR-PREMISE-NO.             
MAD617     PERFORM 7250-SELECT-PREM           THRU 7250-EXIT.           
           PERFORM 7300-SELECT-NAME           THRU 7300-EXIT.           
           PERFORM 2500-BUILD-NAME            THRU 2500-EXIT.           
                                                                        
MAD617     IF PR-ADDRESS-FORMAT = 'A'                                   
MAD617        MOVE PR-ADDRESS-ID          TO DY-ADDRESS-ID              
              PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT            
              PERFORM 7410-SELECT-CITY        THRU 7410-EXIT            
              PERFORM 2600-BUILD-ADDR-FORM    THRU 2600-EXIT            
           ELSE                                                         
MAD617        IF PR-ADDRESS-FORMAT = 'B'                                
MAD617           MOVE PR-ADDRESS-ID          TO DZ-ADDRESS-ID           
                 PERFORM 7450-SELECT-ADDR-FREE   THRU 7450-EXIT         
                 PERFORM 2610-BUILD-ADDR-FREE    THRU 2610-EXIT         
              ELSE                                                      
                 MOVE SPACES                 TO RS-ADDRESS              
              END-IF                                                    
           END-IF.                                                      
           PERFORM 2700-SEND-RESULT           THRU 2700-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2500-BUILD-NAME                                               *         
      *                                                               *         
      *      CONCATENATE FIRST, MIDDLE AND LAST NAME INTO A SINGLE    *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2500-BUILD-NAME.                                                 
                                                                        
           MOVE SPACES                 TO RS-NAME.                      
           MOVE SPACES                 TO RS-ORIGINATED-BY.             
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2600-BUILD-ADDR-FORM                                          *         
      *                                                               *         
      *      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2600-BUILD-ADDR-FORM.                                            
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
           MOVE +1     TO WS-ADD-SUB-CNT.                               
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF A4-TOWN  NOT = SPACE                                  
                   MOVE A4-TOWN                        TO WS-FROM       
                   MOVE LENGTH OF A4-TOWN              TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2610-BUILD-ADDR-FREE                                          *         
      *                                                               *         
      *      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2610-BUILD-ADDR-FREE.                                            
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DZ-ADDR-STREET NOT = SPACE                                
              MOVE DZ-ADDR-STREET           TO WS-FROM                  
              MOVE LENGTH OF DZ-ADDR-STREET TO WS-MAX-SZ                
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = SPACE                            
              MOVE DZ-ADDR-CITY-STATE           TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-CITY-STATE TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = SPACE                              
              MOVE DZ-ADDR-ZIP-CODE             TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-ZIP-CODE   TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-COUNTRY    NOT = SPACE                            
              MOVE DZ-ADDR-COUNTRY              TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-COUNTRY    TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW NOT = SPACE                           
              MOVE DZ-ADDRESS-OVERFLOW           TO WS-FROM             
              MOVE LENGTH OF DZ-ADDRESS-OVERFLOW TO WS-MAX-SZ           
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2620-ACCUMULATE-ADDRESS                                        *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2620-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 50        
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
                   ADD +1    TO WS-ADD-SUB-CNT                          
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
           ADD +1    TO WS-ADD-SUB-CNT.                                 
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2700-SEND-RESULT                                              *         
      *                                                               *         
      *     GATHER VALUES INTO RS-... VARIABLES AND SEND THE RESULT   *         
      *****************************************************************         
                                                                        
       2700-SEND-RESULT.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
           MOVE SB-BOND-WAIV-ITEM-ID     TO RS-WAIV-ITEM-ID.            
           MOVE SB-ACCOUNT-NO            TO RS-ACCOUNT-NO.              
           MOVE SB-AMT-BOND              TO RS-AMT-BOND.                
           MOVE SB-BOND-CO-NO            TO RS-BOND-CO-NO.              
           MOVE SB-CODE-STATUS           TO RS-CODE-STATUS.             
           IF WS-TRIGGER-DATE-NI < 0                                    
              MOVE SPACES                TO RS-TRIGGER-DATE             
           ELSE                                                         
              UNSTRING SB-TRIGGER-DATE DELIMITED BY '/'                 
                  INTO WS-MONTH                                         
                       WS-DAY                                           
                       WS-YEAR                                          
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-TRIGGER-DATE                                    
      *       MOVE SB-TRIGGER-DATE       TO RS-TRIGGER-DATE                     
           END-IF.                                                      
           MOVE SB-CODE-STATUS-REAS      TO RS-CODE-STATUS-REAS.        
           STRING PF-FIRST-NAME DELIMITED ' '                           
                  ' ' DELIMITED SIZE                                    
                  PF-LAST-NAME DELIMITED ' '                            
             INTO RS-ORIGINATED-BY                                      
           END-STRING                                                   
           MOVE SB-BOND-NO               TO RS-BOND-NO.                 
           MOVE SB-BOND-TOTAL-AMT        TO RS-BOND-TOTAL-AMT.          
           IF WS-DATE-BOND-ISSUED-NI < 0                                
              MOVE SPACES                TO RS-ISSUE-DATE               
           ELSE                                                         
              UNSTRING SB-DATE-BOND-ISSUED DELIMITED BY '/'             
                  INTO WS-MONTH                                         
                       WS-DAY                                           
                       WS-YEAR                                          
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-ISSUE-DATE                                      
      *       MOVE SB-DATE-BOND-ISSUED   TO RS-ISSUE-DATE                       
           END-IF.                                                      
           IF WS-BOND-EXPIRATION-DT-NI < 0                              
              MOVE SPACES                TO RS-EXPIRATION-DATE          
           ELSE                                                         
              UNSTRING SB-BOND-EXPIRATION-DT DELIMITED BY '/'           
                  INTO WS-MONTH                                         
                       WS-DAY                                           
                       WS-YEAR                                          
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-EXPIRATION-DATE                                 
      *       MOVE SB-BOND-EXPIRATION-DT TO RS-EXPIRATION-DATE                  
           END-IF.                                                      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-BOND-CURSOR                                        *          
      *                                                              *          
      *      OPEN THE BOND-CURSOR (WHICH WILL SELECT ALL THE SURETY  *          
      *      BONDS AVAILABLE FOR THE ACCOUNT NUMBER)                 *          
      ****************************************************************          
                                                                        
       7000-OPEN-BOND-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN BOND-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7000'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'OPEN'             TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
              MOVE PARM-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1              
              MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7010-FETCH-BOND-CURSOR                                       *          
      *                                                              *          
      *      FETCH RECORDS FROM BOND-CURSOR                          *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7010-FETCH-BOND-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH BOND-CURSOR                                         
               INTO :SB-BOND-WAIV-ITEM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7010'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'FETCH'            TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
              MOVE PARM-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1              
              MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7020-CLOSE-BOND-CURSOR                                       *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7020-CLOSE-BOND-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE BOND-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7020'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'CLOSE'            TO ABEND-FUNCTION                 
CBSI          MOVE SPACES             TO ABEND-SQL-PREDICATES           
CBSI                                     ABEND-TABLES                   
              MOVE 'CSS_SURETY_BOND'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE 'CODE_BOND_TYPE'   TO TABLE-ELEMENT-2                
              MOVE PARM-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1              
              MOVE SB-CODE-BOND-TYPE  TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-OPEN-ACCT-CURSOR                                        *          
      *                                                              *          
      *      OPEN THE ACCT-CURSOR (WHICH WILL SELECT ALL THE ACCOUNTS*          
      *      COVERED BY THE SURETY BOND)                             *          
      ****************************************************************          
                                                                        
       7100-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN ACCT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7110-FETCH-ACCT-CURSOR                                       *          
      *                                                              *          
      *      FETCH RECORDS FROM ACCT-CURSOR                          *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7110-FETCH-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH ACCT-CURSOR                                         
               INTO :SB-ACCOUNT-NO, :SB-BOND-NO,                        
T15454              :SB-USER-ID-ORIG-BY,                                
                    :SB-DATE-BOND-ISSUED :WS-DATE-BOND-ISSUED-NI,        
                    :SB-AMT-BOND, :SB-BOND-CO-NO, :SB-CODE-STATUS,      
                    :SB-CODE-STATUS-REAS, :SB-BOND-TOTAL-AMT,           
                    :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI,                
                    :SB-BOND-EXPIRATION-DT :WS-BOND-EXPIRATION-DT-NI     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7120-CLOSE-BOND-CURSOR                                       *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7120-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'BOND_WAIV_ITEM_ID'  TO TABLE-ELEMENT-1              
              MOVE SB-BOND-WAIV-ITEM-ID TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7190-SELECT-USERID-NAME                                      *          
      *                                                              *          
      *      SELECT THE NAME ASSOCIATED WITH THE USERID              *          
      ****************************************************************          
                                                                        
T15454 7190-SELECT-USERID-NAME.                                         
                                                                        
           EXEC SQL                                                     
              SELECT PF.FIRST_NAME, PF.LAST_NAME                        
                INTO :PF-FIRST-NAME, :PF-LAST-NAME                      
                FROM CSS_USER_PROFILE PF                                
               WHERE PF.USER_ID = :SB-USER-ID-ORIG-BY                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7190'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE SB-USER-ID-ORIG-BY   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF SQLCODE = NOT-FOUND                                       
              MOVE SPACES TO PF-FIRST-NAME                              
              MOVE SB-USER-ID-ORIG-BY TO PF-LAST-NAME                   
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-SELECT-ACCT                                             *          
      *                                                              *          
      *      SELECT ADDRESS-ID AND FORMAT FROM CSS_ACCOUNT TABLE     *          
      ****************************************************************          
                                                                        
       7200-SELECT-ACCT.                                                
                                                                        
           EXEC SQL                                                     
MAD617        SELECT PREMISE_NO, CODE_ACCT_STAT                         
MAD617          INTO :AT-PREMISE-NO, :AT-CODE-ACCT-STAT                 
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7250-SELECT-PREM                                             *          
      *                                                              *          
      *      SELECT ADDRESS-ID AND FORMAT FROM CSS_PREMISE TABLE     *          
      ****************************************************************          
                                                                        
MAD617 7250-SELECT-PREM.                                                
                                                                        
MAD617     EXEC SQL                                                     
MAD617        SELECT ADDRESS_ID, ADDRESS_FORMAT                         
MAD617          INTO :PR-ADDRESS-ID, :PR-ADDRESS-FORMAT                 
MAD617          FROM CSS_PREMISE                                        
MAD617         WHERE PREMISE_NO = :PR-PREMISE-NO                        
MAD617     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
MAD617     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
MAD617     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
MAD617        NEXT SENTENCE                                             
MAD617     ELSE                                                         
MAD617        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
MAD617        MOVE '7250'               TO ACTIVE-PARAGRAPH             
MAD617        MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
MAD617        MOVE 'CSS_PREMISE'        TO TABLE-1                      
MAD617        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
MAD617        MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
MAD617        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
MAD617        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
MAD617     END-IF.                                                      
                                                                        
MAD617 7250-EXIT.                                                       
MAD617     EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-SELECT-NAME                                             *          
      *                                                              *          
      *      SELECT CUSTOMER'S NAME FROM CSS_NAME TABLE              *          
      ****************************************************************          
                                                                        
       7300-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DQ.NAME_FORMAT,                                   
                      DQ.LAST_NAME,                                     
                      DQ.FIRST_NAME,                                    
                      DQ.MIDDLE_NAME,                                   
                      DQ.TITLE_PREFIX,                                  
                      DQ.TITLE_SUFFIX_1,                                
                      DQ.TITLE_SUFFIX_2,                                
                      DQ.FULL_NAME                                      
                INTO :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME           DQ,                            
                      CSS_NAME_ACCT_XREF HT                             
                WHERE HT.ACCOUNT_NO           = :HT-ACCOUNT-NO          
                  AND HT.NAME_ID              = DQ.NAME_ID              
                  AND DQ.NAME_TYPE            = 'CN'                    
                  AND HT.CUSTOMER_ROLE_CD     = ' '                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CSS_NAME'           TO TABLE-2                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-SELECT-ADDR-FORM                                        *          
      *                                                              *          
      *      SELECT FROMATTED ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7400-SELECT-ADDR-FORM.                                           
                                                                        
           EXEC SQL                                                     
               SELECT HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_USAGE_CD,                                    
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-SELECT-CITY                                               *        
      *                                                                *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7410-SELECT-CITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7410'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
CBSI               MOVE SPACES                 TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
CBSI               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
CBSI               MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-SELECT-ADDR-FREE                                        *          
      *                                                              *          
      *      SELECT FREE FORM ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7450-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,      
                      ADDR_COUNTRY, ADDRESS_OVERFLOW                    
               INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,             
                      :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,              
                      :DZ-ADDRESS-OVERFLOW                              
                 FROM CSS_ADDR_FREEFORM                                 
                WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7450'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02150_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02150_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02150_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         INSERT INTO #CSR02150_R1                          
REARCH         (                                                        
REARCH              RETURN_CODE                                         
REARCH             ,ACCOUNT_NO                                          
REARCH             ,AMT_BOND                                            
REARCH             ,WAIV_ITEM_ID                                        
REARCH             ,BOND_CO_NO                                          
REARCH             ,CODE_STATUS                                         
REARCH             ,TRIGGER_DATE                                        
REARCH             ,CODE_STATUS_REAS                                    
REARCH             ,ORIGINATED_BY                                       
REARCH             ,BOND_NO                                             
REARCH             ,BOND_TOTAL_AMT                                      
REARCH             ,ISSUE_DATE                                          
REARCH             ,EXPIRATION_DATE                                     
REARCH             ,NAME                                                
REARCH             ,ADDRESS                                             
REARCH             ,CODE_ACCT_STAT                                      
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH              :S-RETURN-CODE                                      
REARCH             ,:S-ACCOUNT-NO                                       
REARCH             ,:S-AMT-BOND                                         
REARCH             ,:S-WAIV-ITEM-ID                                     
REARCH             ,:S-BOND-CO-NO                                       
REARCH             ,:S-CODE-STATUS                                      
REARCH             ,:S-TRIGGER-DATE                                     
REARCH             ,:S-CODE-STATUS-REAS                                 
REARCH             ,:S-ORIGINATED-BY                                    
REARCH             ,:S-BOND-NO                                          
REARCH             ,:S-BOND-TOTAL-AMT                                   
REARCH             ,:S-ISSUE-DATE                                       
REARCH             ,:S-EXPIRATION-DATE                                  
REARCH             ,:S-NAME                                             
REARCH             ,:S-ADDRESS                                          
REARCH             ,:S-CODE-ACCT-STAT                                   
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02150_R1                                  
MFA-TR*        (                                                                
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,AMT_BOND                                                    
MFA-TR*            ,WAIV_ITEM_ID                                                
MFA-TR*            ,BOND_CO_NO                                                  
MFA-TR*            ,CODE_STATUS                                                 
MFA-TR*            ,TRIGGER_DATE                                                
MFA-TR*            ,CODE_STATUS_REAS                                            
MFA-TR*            ,ORIGINATED_BY                                               
MFA-TR*            ,BOND_NO                                                     
MFA-TR*            ,BOND_TOTAL_AMT                                              
MFA-TR*            ,ISSUE_DATE                                                  
MFA-TR*            ,EXPIRATION_DATE                                             
MFA-TR*            ,NAME                                                        
MFA-TR*            ,ADDRESS                                                     
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-AMT-BOND                                                 
MFA-TR*            ,:S-WAIV-ITEM-ID                                             
MFA-TR*            ,:S-BOND-CO-NO                                               
MFA-TR*            ,:S-CODE-STATUS                                              
MFA-TR*            ,:S-TRIGGER-DATE                                             
MFA-TR*            ,:S-CODE-STATUS-REAS                                         
MFA-TR*            ,:S-ORIGINATED-BY                                            
MFA-TR*            ,:S-BOND-NO                                                  
MFA-TR*            ,:S-BOND-TOTAL-AMT                                           
MFA-TR*            ,:S-ISSUE-DATE                                               
MFA-TR*            ,:S-EXPIRATION-DATE                                          
MFA-TR*            ,:S-NAME                                                     
MFA-TR*            ,:S-ADDRESS                                                  
MFA-TR*            ,:S-CODE-ACCT-STAT                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02150_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH      EXIT.                                                       
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
