       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02149.                                         
COB303 DATE-WRITTEN.                                                    
COB303            AUGUST 04, 1995.                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S149 CONVERTED TO DB2 SP CSR02149 ON 09/02/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).            
      *                                                                         
      *  TRANID:        S149                                                    
      *  PROGRAM:       S149                                                    
      *  CALLING SP:    PA_S149                                                 
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM                      
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                                
      *                                                                         
      *  THIS PROGRAM POSTS METER READINGS OR CORRECTIONS.                      
      *                                                                         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  08/04/95    SS       CREATED.                                          
      *  02/22/96    TCB      ADDED CODED TO RETURN A WORK QUEUE CODE,          
      *                       FIXED CODE TO RECORD DEMAND IN CONSUMPTION        
      *                       HISTORY AND ADDED CHECK FOR A FINALLED            
      *                       ACCOUNT. TPR 3177.                                
      *  02/22/96    TCB      ADDED CODE TO OVERRIDE AND POST TO AN             
      *                       INACTIVE METER. TPR 3168.                         
      *  02/27/96    TCB      ADDED CODE TO UPDATE NO_CONSEC_CRD_READ           
      *                       AND TO CHECK FOR READINGS BETWEEN 3 AND           
      *                       -3 AND TO HANDLE NEW READ CODES. TPR 3314.        
      *  03/14/96    TCB      FIXED RPC TO UPDATE CONSUMPTION HISTORY,          
      *                       METERED ENVIRONMENT AND REGISTER READ             
      *                       CORRECTLY.  ALSO FIXED RPC TO GO THROUGH          
      *                       THE EDITS FOR METERED ENVIRONMENT.                
      *                       TPR 3538.                                         
      *  06/26/96    MJL      ADD LOGIC FOR TOU HIGH-LOW CHECK.                 
      *                       TPR 4616.                                         
TP5186*  09/09/96    TCB      ADDED LOGIC TO POST A READING FOR A CODE          
TP5186*                       TIME PERIOD 0 ON THE METERED ENVIRONMENT          
TP5186*                       TABLE AND ADDED ERROR MESSAGE WHEN A              
TP5186*                       READING WAS ADDED FOR OTHER THAN ACTIVE           
TP5186*                       METER AND DID NOT MATCH THE TOTAL KWH.            
TP5296*  09/09/96    TCB      ADDED LOGIC TO POST ONLY 'C' OR 'P' FOR           
TP5296*                       THE SEASON INDICATOR TO CONSUMPTION               
TP5296*                       HISTORY.                                          
TP9495*  02/27/97    AS       ADDED LOGIC IN PARAGRAPH 5450 TO NOT              
TP9495*                       LOOK FOR CONSUMPTION ROWS FOR INACTIVE            
TP9495*                       METERS.                                           
PCR376**   9/3/97    PD       SELECT CSS_XREF_ACCT BY JOINING WITH              
PCR376**                      CSS_CUST_PREM_HIST TO TAKE CARE OF                
PCR376**                      MULTIPLE OLD-ACCOUNT-NO.                          
PCR631*  08/25/98    TDK      ADDED CHANGES TO USE NEW JOB PARMS IN             
PCR631*                       HIGH/LOW COPYBOOK ROUTINE.                        
T17429*  08/25/98    TDK      INSERT REV_DIST INTO BILLING DETAILS              
PCR671*  08/31/98    TDK      DO NOT CODE_ACCT_BILLED TO READY TO BILL          
PCR671*                       IF ACCOUNT IS HELD.                               
PCR672*  09/03/98    TDK      ADD TRANSACTION HISTORY                           
T17934*  09/23/98    TDK      USE REV_MTH_LST_NRML FOR LAST REV MONTH.          
T18001*  09/29/98    TDK      REMOVE RESP AREA ID FROM INSERT.                  
T18004*  09/29/98    TDK      CHANGED TRANS HIST COMMENTS.                      
T18223*  10/14/98    TDK      DON'T SELECT NON-CALC ROWS IN BILL CURSOR         
CBSI  *  10/26/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE             
CBSI  *             MADRAS    ABEND PARAMETERS                                  
T18295*  11/03/98    TDK      ADD MORE INFO TO TRANS HIST MESSAGE.              
T18209*  11/18/98    MJL      REMOVE UPDATE TO SEQ. NO. AND INSTR. CODES        
PCR672*  12/03/98    TDK      ADDED LOGIC FOR NEW MTR RD CD OF CORRECTED        
T18875*  01/14/99    TDK      ADDED NEW JOB PARM PROCESSING LOGIC FOR           
T18875*                       HI/LO PERCENTAGES.                                
T19128*  02/11/99    RGB      CODE CHANGED TO LOAD CODE_SOURCE_ID WITH          
T19128*                       'C' INSTEAD OF 'B' IF IT IS ENTERED FROM          
T19128*                       METER CORRECTION PANEL                            
T20320*  06/30/99    RGB      FOR THREE DIAL METERS CHECK FOR ROLLOVER *        
T20320*                       IS ADDED WHICH IS NOT DONE BEFORE        *        
T20431*  07/31/99    RGB      ADDED LOGIC TO DISPLAY USAGE IN HI\LO    *        
T20431*                       WQ GENERATED AND ALSO INCLUDED TO INFORM *        
T20431*                       IF HI\LO OCCURRED AFTER ROLL OVER        *        
T20560*  09/07/99    CBSI     INCLUDED NEW READ CODE METER-READ-       *        
T20560*              MADRAS   CORRECTION.                              *        
T21543*  02/09/00    RGB      CODE CHANGED TO PERFORM HI\LO ROUTINE    *        
T21543*                       PROPERLY FOR TOU REGISTERS.              *        
T21807*  03/07/00    RGB      CODE CHANGED TO LOAD THE BG-REV-MTH-ORIG-*        
T21807*                       BILL AS ZEROES DURING NEW INSERT OF BG   *        
T22243*  07/25/00    CBSI     CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*              MADRAS   IN METER INVENTORY TABLES.               *        
T21677*  05/04/01   COVANSYS  METER READINGS CANNOT BE ENTERED WHEN    *        
T21677*             CHENNAI   THE ACCOUNT IS ALREADY BILLED FOR THE    *        
T21677*                       CURRENT REVENUE MONTH.                   *        
T22243*              MADRAS   IN METER INVENTORY TABLES.               *        
T23951*  07/27/01    SR16861  CHANGED PGM TO GET COMPANY NO FROM THE   *        
T23951*                       PREMISE ROW BEFORE INSERTING BILLING DET *        
T23951*                       ROW IN 8862 RTN                          *        
C28373*  11/07/03    VD88125  CODE CHANGES MADE TO PROCESS TIME PERIOD *        
C28373*                       ZERO DEMAND REGITERS AND RECEIVING TIME  *        
C28373*                       PERIOD AND SEASON IND THRU TOU STRINGS.  *        
C28373*  03/01/04    VD88125  REPLACE PCSBW105 JOB PARM WITH PCSBW141. *        
T32303*  04/29/05    VV90387  CORRECT ACCOUNTS WITH REMOTE READ IND TO *        
T32303*                       BILL FOR CORRECT DAYS.                   *        
REARCH*  09/08/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C33639*  01/19/06    NC94746  HI-LO ROUTINE FIX TO USE IC-NO           *        
C34424*  03/27/08    PA94870  ADDED ROLLBACK LOGIC TO ROLLBACK IN CASE *        
C34424*               AN ERROR ENCOUNTERED WITH ONE OF REG'S READING   *        
A00795*  02/02/10    NC94746  CHANGES TO USE NEW HIGH-LOW ROUTINE      *        
P00251*  04/08/10    VY95550   INSERT CONSUMPTION AS CREDIT FOR        *        
P00251*                        CO-GEN REGISTERS                        *        
PRJ251*  05/27/10    VY95550  SELECT ACTIVE/INSTALLED METERS ONLY      *        
A02906*  01/04/11    MN90523   HANDLE ADDITIONAL ZERO TIMEPERIOD       *        
A02906*                        KWH REGISTERS                           *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
ACT089*  06/21/13    bd09555  add meter status 'b' to paragraph 7020   *        
ACT089*  06/21/13             a04527                                   *        
ACT245** 12/07/15    VIJAY    POPULATE GAS_BASE_USE WHILE CREATING BG  *        
ACT245** A05136               RECORD.                                  *        
ACT189** 07/05/16    MS7M727  TO REPLACE TALLY BY WS-TALLY VARIABLE,   *        
      *              A5460    REMOVED COMMENTED CODES(CVT999) AND      *        
      *                       UNUSED COPYBOOK CCA00001,CPD00302        *        
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-CWS72-HI-LO-CSR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02149'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
REARCH     VALUE 'WORKING STORAGE FOR CSR02149 STARTS HERE'.            
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRGREAD                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBXREF                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTHGLW                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTUSES                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
PCR376     EXEC SQL                                                             
PCR376        INCLUDE TBCSTPRM                                                  
PCR376     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
PCR631        INCLUDE TBJBPARM                                                  
PCR631     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
PCR672        INCLUDE TBMNHIST                                                  
C30187     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
A00795 COPY FIOJC01.                                                    01540000
A00795 COPY CWS00038.                                                   00840000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
                                                                        
A00795******************************************************************00750000
A00795* HIGH LOW ROUTINE WORKING STORAGE                                00850000
A00795******************************************************************00770000
A00795     EXEC SQL                                                             
A00795         INCLUDE CWSCA072                                                 
A00795     END-EXEC.                                                            
A00795*                                                                         
      *****************************************************************         
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  WS-WORK-AREA.                                                
REARCH     05  PROGRAM-NAME                PIC X(08) VALUE 'CSR02149'.  
ACT189     05  WS-TALLY                    PIC 9(05) VALUE ZERO.        
           05  WS-HOLD-VALID               PIC X(01) VALUE 'Y'.         
           05  WS-NULL-1                   PIC S9(4) COMP.              
           05  WS-NULL-2                   PIC S9(4) COMP.              
           05  WS-NULL-3                   PIC S9(4) COMP.              
           05  WS-NULL-4                   PIC S9(4) COMP.              
           05  WS-NULL-5                   PIC S9(4) COMP.              
           05  IND-DATE-BILLED             PIC S9(4) COMP-4 VALUE 1.    
           05  IND-DATE-ORIG-BILL          PIC S9(4) COMP-4 VALUE 1.    
           05  WS-SUB                      PIC S9(04) COMP.             
           05  WS-CX-ITEM-SEQ-NO-NULL      PIC S9(04) COMP  VALUE ZERO. 
           05  WS-TOU-MTR-IND              PIC X(01) VALUE 'N'.         
               88  WS-TOU-METER                VALUE 'Y'.               
           05  WS-USAGE-VALUES.                                         
               10  WS-CODE-USAGE-TYPE          PIC X(01) VALUE SPACE.   
               10  WS-CODE-USAGE-ID            PIC X(01) VALUE SPACE.   
               10  WS-CODE-USAGE-SOURCE        PIC X(01) VALUE SPACE.   
           05  WS-FREQ-BREAKDOWN           PIC X(03).                   
           05  WS-FREQ-BREAKDOWN-RED       REDEFINES                    
               WS-FREQ-BREAKDOWN.                                       
               10  WS-CODE-FREQ            PIC X(01).                   
                   88  MONTHLY                        VALUE 'M'.        
                   88  BI-MONTHLY                     VALUE 'B'.        
                   88  QUARTERLY                      VALUE 'Q'.        
                   88  SEMI-ANNUALLY                  VALUE 'S'.        
                   88  ANNUAL                         VALUE 'A'.        
               10  WS-FREQ-NO              PIC 9(02).                   
           05  WS-NO-METERS-POSTED         PIC S9(05) COMP-3 VALUE ZERO.
           05  WS-STATUS.                                               
               10  WS-STATUS-ERROR         PIC X(01).                   
               10  WS-STATUS-SQLCODE       PIC 9(03).                   
           05  WS-WORK-DATE.                                            
               10  WS-WORK-CC              PIC 9(02).                   
               10  WS-WORK-YY              PIC 9(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-WORK-MM              PIC 9(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-WORK-DD              PIC 9(02).                   
           05  WS-READ-DATE                PIC X(10) VALUE SPACES.      
           05  WS-TIMESTMP-FROM-DB2-CALL PIC X(26) VALUE SPACES.        
           05  WS-SCREEN-FIELD-KEYS.                                    
               10  WS-METER-NO           PIC X(09).                     
COB305         10 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305         10 WS-CODE-TIME-PERIOD        PIC S9(04) COMP-3 VALUE 0.         
           05  WS-TIME-PERIOD           PIC X(01).                      
           05  WS-TIME-PERIOD-NUM  REDEFINES WS-TIME-PERIOD             
                                        PIC 9(01).                      
           05  WS-MN-STATUS             PIC X(01) VALUE SPACE.          
               88  WS-MN-DONE           VALUE 'Y'.                      
               88  WS-MN-NOT-DONE       VALUE 'N'.                      
           05  WS-RG-STATUS             PIC X(01) VALUE SPACE.          
               88  WS-RG-DONE           VALUE 'Y'.                      
               88  WS-RG-NOT-DONE       VALUE 'N'.                      
           05  WS-TYPE-TO-PROCESS       PIC X(01) VALUE SPACE.          
               88  WS-MN-PROCESS        VALUE 'M'.                      
               88  WS-RG-PROCESS        VALUE 'R'.                      
TP5186     05  WS-MN-TOU-FLAG           PIC X(01) VALUE 'N'.            
P00251     05  WS-MN-REG-TYPE.                                          
P00251         10 WS-MN-CODE-USAGE-TYPE    PIC X(01) VALUE SPACES.      
P00251         10 WS-MN-CODE-USAGE-ID      PIC X(01) VALUE SPACES.      
P00251         10 WS-MN-CODE-USAGE-SOURCE  PIC X(01) VALUE SPACES.      
TP5186     05  WS-REG-PROCESSED-FLAG    PIC X(01) VALUE 'N'.            
C34424     05  WS-ROLLBACK-FLAG         PIC X(01) VALUE 'N'.            
           05  WS-DEM-WITHOUT-CONST PIC S9(08)V9(03) COMP-3 VALUE ZERO. 
           05  WS-DEM-WITHOUT-CONST7 REDEFINES WS-DEM-WITHOUT-CONST     
                                    PIC S9(11)     COMP-3.              
           05  WS-READING          PIC X(15).                           
           05  WS-READING-NUM REDEFINES WS-READING PIC 9(12)V999.       
           05  WS-METER-READ-NUM   PIC S9(12)V999 COMP-3 VALUE ZERO.    
           05  WS-MTR-WO-ROLLOVER  PIC S9(12)V999 COMP-3 VALUE ZERO.    
T20431     05  WS-CRNT-USE         PIC S9(12) COMP-3 VALUE ZERO.        
T20321     05  WS-LENGTH-3         PIC S9(3)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-4         PIC S9(4)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-5         PIC S9(5)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-6         PIC S9(6)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-7         PIC S9(7)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-8         PIC S9(8)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-9         PIC S9(9)V999 COMP-3 VALUE ZERO.     
           05  WS-LENGTH-10        PIC S9(10)V999 COMP-3 VALUE ZERO.    
           05  WS-READ-CODE        PIC X(1) VALUE SPACES.               
           05  WS-NO-RD-CODE       PIC X(1) VALUE SPACES.               
           05  WS-TOTAL-KWH        PIC S9(12)V999 COMP-3 VALUE ZERO.    
TP5186     05  WS-MN-KWH           PIC S9(12)V999 COMP-3 VALUE ZERO.    
           05  WS-CALC-NO-DAYS     PIC S9(9)        COMP.               
           05  WS-DATE-CALC-1      PIC X(10).                           
           05  WS-DATE-CALC-2      PIC X(10).                           
           05  WS-SEASON-IND       PIC X(1) VALUE SPACES.               
TP5296     05  WS-HOLD-SEASON      PIC X(1) VALUE SPACES.               
           05  WS-END-DATE         PIC X(10).                           
           05  WS-END-DAYS         PIC 9(07).                           
           05  WS-START-DATE       PIC X(10).                           
           05  WS-START-DAYS       PIC 9(07).                           
           05  WS-READ-MONTH.                                           
               10 WS-READ-MTH-MM   PIC X(02) VALUE '00'.                
               10 WS-READ-MTH-DD   PIC X(02) VALUE '01'.                
           05  WS-READ-MTH-NUM REDEFINES WS-READ-MONTH                  
                                   PIC 9(04).                           
           05  WS-DATE-NUM.                                             
               10  WS-DATE-NUM-YYYY    PIC 9(04)  VALUE ZERO.           
               10  WS-NUM-YEAR REDEFINES WS-DATE-NUM-YYYY.              
                   15  WS-DATE-NUM-CC  PIC 9(02).                       
                   15  WS-DATE-NUM-YY  PIC 9(02).                       
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-MM      PIC 9(02)  VALUE ZERO.           
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-DD      PIC 9(02)  VALUE ZERO.           
           05  WS-DAYS-REMAINDER   PIC 9(01).                           
           05  WS-NO-OF-DAYS       PIC 9(03) VALUE ZERO.                
           05  WS-NO-OF-UNITS      PIC S9(09)    COMP-3 VALUE ZERO.     
A00795     05  WS-REV-MONTH1       PIC X(06).                           
A00795     05  WS-REV-MNTH-RED     REDEFINES WS-REV-MONTH1.             
T21677         10  WS-REV-MNTH     PIC 9(06).                           
           05  WS-MEM-NO                   PIC S9(04) COMP VALUE ZERO.  
PCR672     05  WS-ADJ-NULL-IND             PIC S9(4) COMP.              
A00795     05  WS-HL-CODE-TIME-PERIOD  PIC S9(4)  COMP VALUE -1.        
A00795     05  WS-HL-CODE-USAGE-ID     PIC X(01) VALUE ' '.             
      *                                                                         
PCR672 01  WS-MNT-TRANS-HIST.                                           
PCR672     05  WS-USERID                  PIC X(08) VALUE SPACES.       
PCR672     05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
PCR672     05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
PCR672     05  WS-COMMENT                 PIC X(210).                   
PCR672     05  WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.       
PCR672     05  WS-PANEL-NO                PIC X(09) VALUE 'PANEL208'.   
PCR672     05  WS-CODE-TRAN-TYPE          PIC X(01) VALUE 'F'.          
T20431     05  WS-ROLL-FLAG               PIC X(1) VALUE 'N'.           
      *                                                                         
T18004 01  WS-MNT-TRANS-HIST-MSG              PIC X(23) VALUE           
T18004          'MANUAL METER READ ENTRY'.                              
PCR672*01  WS-MNT-TRANS-HIST-MSG              PIC X(19) VALUE                   
PCR672*         'ON-LINE METER ENTRY'.                                          
      *                                                                         
       01  WS-COMPUTE-DAYS.                                             
           05  WS-TOTAL-DAYS-LAST-READ     PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-TOTAL-DAYS-NEW-READ      PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-NO-OF-DAYS-USAGE         PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-30-DAY-USAGE-CALC        PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-30-DAY-USAGE-CALC-REDF REDEFINES WS-30-DAY-USAGE-CALC 
                                           PIC S9(04)V999 COMP-3.       
           05  WS-REMAINDER                PIC S9(03) COMP-3 VALUE ZERO.
           05  WS-DAYS-VALUES.                                          
               10  FILLER                  PIC S9(03) COMP-3 VALUE +000.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +031.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +059.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +090.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +120.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +151.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +181.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +212.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +243.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +273.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +304.
               10  FILLER                  PIC S9(03) COMP-3 VALUE +334.
           05  WS-DAYS-TABLE REDEFINES WS-DAYS-VALUES.                  
               10  WS-DAYS                 PIC S9(03)   COMP-3          
                                           OCCURS 12 TIMES.             
                                                                        
A02906 01  WS-PARM-KWH-TOU                 PIC X(176) VALUE SPACES.     
       01  WS-KWH-TOU-TABLE REDEFINES WS-PARM-KWH-TOU.                  
           05  WS-KWH-TOU                                               
A02906         OCCURS 8 TIMES.                                          
               10  KWH-TOU-READ            PIC X(15).                   
               10  KWH-TOU-USAGVAL.                                     
                   15  KWH-TOU-USAG-TYPE   PIC X(1).                    
                   15  KWH-TOU-USAG-ID     PIC X(1).                    
                   15  KWH-TOU-USAG-SOURCE PIC X(1).                    
               10  KWH-TOU-RD-CD           PIC X(1).                    
               10  KWH-TOU-NO-RD           PIC X(1).                    
C28373         10  KWH-TOU-TIME-PRD        PIC X(1).                    
C28373         10  KWH-TOU-SESN-IND        PIC X(1).                    
C28373 01  WS-PARM-KW-TOU                  PIC X(176) VALUE SPACES.     
       01  WS-KW-TOU-TABLE REDEFINES WS-PARM-KW-TOU.                    
           05  WS-KW-TOU                                                
C28373         OCCURS 8 TIMES.                                          
               10  KW-TOU-READ             PIC X(15).                   
               10  KW-TOU-USAGVAL.                                      
                   15 KW-TOU-USAG-TYPE     PIC X(1).                    
                   15 KW-TOU-USAG-ID       PIC X(1).                    
                   15 KW-TOU-USAG-SOURCE   PIC X(1).                    
               10  KW-TOU-RD-CD            PIC X(1).                    
               10  KW-TOU-NO-RD            PIC X(1).                    
C28373         10  KW-TOU-TIME-PRD         PIC X(1).                    
C28373         10  KW-TOU-SESN-IND         PIC X(1).                    
       01  WS-PARM-KVA-TOU                 PIC X(176) VALUE SPACES.     
       01  WS-KVA-TOU-TABLE REDEFINES WS-PARM-KVA-TOU.                  
           05  WS-KVA-TOU                                               
               OCCURS 8 TIMES.                                          
               10  KVA-TOU-READ            PIC X(15).                   
               10  KVA-TOU-USAGVAL.                                     
                   15  KVA-TOU-USAG-TYPE   PIC X(1).                    
                   15  KVA-TOU-USAG-ID     PIC X(1).                    
                   15  KVA-TOU-USAG-SOURCE PIC X(1).                    
               10  KVA-TOU-RD-CD           PIC X(1).                    
               10  KVA-TOU-NO-RD           PIC X(1).                    
C28373         10  KVA-TOU-TIME-PRD        PIC X(1).                    
C28373         10  KVA-TOU-SESN-IND        PIC X(1).                    
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-NEG-ONE                  PIC S9(04) COMP-3 VALUE -1.  
           05  WS-0                        PIC S9      VALUE +0.        
           05  WS-1                        PIC S9      VALUE +1.        
           05  WS-2                        PIC S9      VALUE +2.        
           05  WS-4                        PIC S9      VALUE +4.        
           05  WS-5                        PIC S9      VALUE +5.        
           05  WS-6                        PIC S9      VALUE +6.        
           05  WS-7                        PIC S9      VALUE +7.        
           05  WS-8                        PIC S9      VALUE +8.        
           05  WS-9                        PIC S9      VALUE +9.        
           05  WS-10                       PIC S9(03)  VALUE +10.       
           05  WS-11                       PIC S99     VALUE +11.       
           05  WS-100                      PIC S9(03)  VALUE +100.      
           05  WS-D                        PIC X(01)   VALUE 'D'.       
           05  WS-E                        PIC X(01)   VALUE 'E'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-G                        PIC X(01)   VALUE 'G'.       
           05  WS-H                        PIC X(01)   VALUE 'H'.       
           05  WS-I                        PIC X(01)   VALUE 'I'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-L                        PIC X(01)   VALUE 'L'.       
           05  WS-M                        PIC X(01)   VALUE 'M'.       
           05  WS-O                        PIC X(01)   VALUE 'O'.       
           05  WS-P                        PIC X(01)   VALUE 'P'.       
           05  WS-R                        PIC X(01)   VALUE 'R'.       
           05  WS-U                        PIC X(01)   VALUE 'U'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-T                        PIC X(01)   VALUE 'T'.       
           05  WS-W                        PIC X(01)   VALUE 'W'.       
           05  WS-Z                        PIC X(01)   VALUE 'Z'.       
           05  WS-NO                       PIC X(01)   VALUE 'N'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-BAB                      PIC X(03)   VALUE 'BAB'.     
           05  WS-BAC                      PIC X(03)   VALUE 'BAC'.     
           05  WS-CAB                      PIC X(03)   VALUE 'CAB'.     
           05  WS-CAD                      PIC X(03)   VALUE 'CAD'.     
           05  WS-JAC                      PIC X(03)   VALUE 'JAC'.     
           05  WS-JAD                      PIC X(03)   VALUE 'JAD'.     
           05  WS-EAC                      PIC X(03)   VALUE 'EAC'.     
           05  WS-EAD                      PIC X(03)   VALUE 'EAD'.     
           05  WS-TIME                     PIC X(08)   VALUE '00.00.00'.
           05  WS-UNKNOWN            PIC X(07)   VALUE 'UNKNOWN'.       
PCR631*    05  WS-PCSBW105                 PIC X(08)   VALUE 'PCSBW105'.        
PCR671     05  WS-HOLD-NO-READING          PIC X(01)   VALUE 'H'.       
T18223     05  WS-NON-CALC                 PIC X(01)  VALUE 'S'.        
T21677     05  WS-ACCT-BILLED              PIC X(01)  VALUE 'N'.        
                                                                        
       01  WS-SUBSYSTEM-ERROR-MSG.                                      
      *    .... ACCOUNT FINALLED. NO UPDATES PERFORMED                          
           05  WS-ERR-MSG-D0716               PIC X(05) VALUE 'D0716'.  
      *    .... RD DTE PRIOR TO LAST RD                                         
           05  WS-ERR-MSG-D0545               PIC X(05) VALUE 'D0545'.  
      *    .... NOT RD-SUB METER                                                
           05  WS-ERR-MSG-D0546               PIC X(05) VALUE 'D0546'.  
      *    .... ACT MTR-RD IS EXP                                               
           05  WS-ERR-MSG-D0548               PIC X(05) VALUE 'D0548'.  
      *    .... OFF MTR-RD IS EXP                                               
           05  WS-ERR-MSG-D0549               PIC X(05) VALUE 'D0549'.  
      *    .... INACT MTR HAS USE                                               
           05  WS-ERR-MSG-D0550               PIC X(05) VALUE 'D0550'.  
      *    .... RMV METER HAS RD                                                
           05  WS-ERR-MSG-D0547               PIC X(05) VALUE 'D0547'.  
      *    .... FAILED LOW-READ                                                 
           05  WS-ERR-MSG-D0551               PIC X(05) VALUE 'D0551'.  
      *    .... FAILED HIGH-READ                                                
           05  WS-ERR-MSG-D0552               PIC X(05) VALUE 'D0552'.  
      *    .... FAILED LOW-DEM                                                  
           05  WS-ERR-MSG-D0553               PIC X(05) VALUE 'D0553'.  
      *    .... FAILED HIGH-DEM                                                 
           05  WS-ERR-MSG-D0554               PIC X(05) VALUE 'D0554'.  
      *    .... CHK RD ON DIAL                                                  
T20431     05  WS-ERR-MSG-D1019               PIC X(05) VALUE 'D1019'.  
T20431*    .... FAILED LOW-READ AFTER ROLL OVER                         05160000
T20431     05  WS-ERR-MSG-D1020               PIC X(05) VALUE 'D1020'.  
T20431*    .... FAILED HIGH-READ AFTER ROLL OVER                        05180000
T20431     05  WS-ERR-MSG-D1021               PIC X(05) VALUE 'D1021'.  
T20431*    .... FAILED LOW-DEM AFTER ROLL OVER                          05200000
T20431     05  WS-ERR-MSG-D1022               PIC X(05) VALUE 'D1022'.  
T20431*    .... FAILED HIGH-DEM AFTER ROLL OVER                         05200000
           05  WS-ERR-MSG-D0555               PIC X(05) VALUE 'D0555'.  
      *    .... INVALID REG. TYPE                                               
           05  WS-ERR-MSG-D0544               PIC X(05) VALUE 'D0544'.  
      *    .... INVALID ACCOUNT NO                                              
           05  WS-ERR-MSG-D0142               PIC X(05) VALUE 'D0142'.  
      *    .... RATE NOT IN HI/LO TABLE                                         
           05  WS-ERR-MSG-D0535               PIC X(05) VALUE 'D0535'.  
      *    .... NO MTRD ENVRNMT                                                 
           05  WS-ERR-MSG-D0536               PIC X(05) VALUE 'D0536'.  
      *    .... NO UTIL ENVRNMT                                                 
           05  WS-ERR-MSG-D0537               PIC X(05) VALUE 'D0537'.  
      *    .... NO MTR CAPABILITY                                               
           05  WS-ERR-MSG-D0538               PIC X(05) VALUE 'D0538'.  
      *    .... NO REGISTER ENVRNMT                                             
           05  WS-ERR-MSG-D0539               PIC X(05) VALUE 'D0539'.  
      *    .... INITIAL BILL.  CANNOT ESTIMATE.                                 
           05  WS-ERR-MSG-D0733               PIC X(05) VALUE 'D0733'.  
      *    .... IC FLAGGED 'NO ESTIMATE'                                        
           05  WS-ERR-MSG-D0734               PIC X(05) VALUE 'D0734'.  
      *    .... ESTIMATE MORE THAN 40 DAYS                                      
           05  WS-ERR-MSG-D0735               PIC X(05) VALUE 'D0735'.  
      *    .... ESTIMATE LESS THAN 10 DAYS                                      
           05  WS-ERR-MSG-D0736               PIC X(05) VALUE 'D0736'.  
      *    .... NO ESTIMATE. METER CONSTANT EQUAL ZERO                          
           05  WS-ERR-MSG-D0737               PIC X(05) VALUE 'D0737'.  
TP5186*    .... TIME PERIOD 0 DOES NOT MATCH TOTAL KWH                          
TP5186     05  WS-ERR-MSG-D0843               PIC X(05) VALUE 'D0843'.  
T21677     05  WS-ERR-MSG-D5318               PIC X(05) VALUE 'D5318'.  
T21677*    .... ACCOUNT IS ALREADY BILLED FOR THE CURRENT REVENUE MONTH 05480000
                                                                        
       01  WS-ABEND-MESSAGES.                                           
           05  ABND-IN-SCHEDULE        PIC X(21)   VALUE                
               'PSB SCHEDULE ABEND   '.                                 
                                                                        
       01  WS-MISC.                                                     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'Y'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
                                                                        
                                                                        
       01  WS-END                       PIC X(40)                       
REARCH     VALUE 'WORKING STORAGE FOR CSR02149 ENDS HERE  '.            
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED                                      
                            REDEFINES PARM-ACCOUNT-NO PIC 9(13).        
           05  PARM-METER-NO           PIC X(9)   VALUE SPACES.         
           05  PARM-READ-DATE          PIC X(10)  VALUE SPACES.         
           05  PARM-OVERRIDE-IND       PIC X(01)  VALUE SPACES.         
           05  PARM-READER-ID          PIC X(05)  VALUE SPACES.         
A02906     05  PARM-KWH-TOU            PIC X(176) VALUE SPACES.         
RGB        05  PARM-KW-TOU             PIC X(176) VALUE SPACES.         
RGB        05  PARM-KVA-TOU            PIC X(176) VALUE SPACES.         
PCR672     05  PARM-USER-ID            PIC X(08) VALUE SPACES.          
PCR672     05  PARM-ADJ-REASON-CD      PIC X(04) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-ERROR-CODE            PIC X(5) VALUE SPACES.          
           05  RS-TIME-PERIOD           PIC S9(4) COMP VALUE 0.         
           05  RS-REG-TYPE              PIC X(3) VALUE SPACES.          
           05  RS-WORK-QUEUE-CODE       PIC X(3) VALUE SPACES.          
T20431     05  RS-USAGE-UNITS           PIC X(12) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-ERROR-CODE             PIC X(5) VALUE SPACES.          
REARCH     05  S-TIME-PERIOD            PIC S9(4) COMP VALUE 0.         
REARCH     05  S-REG-TYPE               PIC X(3) VALUE SPACES.          
REARCH     05  S-WORK-QUEUE-CODE        PIC X(3) VALUE SPACES.          
REARCH     05  S-USAGE-UNITS            PIC X(12) VALUE SPACES.         
      *****************************************************************         
      * CURSOR DECLARATIONS                                           *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE MN_CRSR CURSOR FOR                                
               SELECT REG_ID_NO,                                        
                      METER_NO,                                         
                      MTR_REF_NO,                                       
                      CODE_CRNT_REG_READ,                               
                      CODE_METER_STATUS                                 
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE             
                  AND IC_NO            = :MN-IC-NO                      
                  AND CODE_METER_STATUS <> 'J'                          
                  AND CODE_METER_STATUS <> 'K'                          
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE RG_CRSR CURSOR FOR                                
               SELECT REG_ID_NO,                                        
                      CODE_CRNT_REG_READ                                
                 FROM CSS_REGISTER_READ                                 
                WHERE ACCOUNT_NO      = :RG-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :RG-CODE-UTIL-TYPE              
                  AND IC_NO           = :RG-IC-NO                       
                  AND MTR_REF_NO      = :RG-MTR-REF-NO                  
                  AND CODE_REG_STATUS <> 'J'                            
                  AND CODE_REG_STATUS <> 'K'                            
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE UT_CRSR CURSOR FOR                                
               SELECT CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      CODE_REVENUE_CLASS,                               
                      CODE_ESTIMATE_OK,                                 
                      RATE_PLAN_NO, CODE_SIC_NO,                        
                      CODE_MTR_READ_FREQ,                               
                      CODE_CURTAIL_PRTY,                                
                      DATE_LST_NRML_BILL                                
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE <> 'U'                             
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILLING_HDR CURSOR FOR                            
               SELECT PREMISE_NO,                                       
                      BILL_NO,                                          
                      DATE_BILLED                                       
                 FROM CSS_BILLING_HDR                                   
                WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                       
             ORDER BY BILL_NO DESC                                      
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_CNSMPTN_HIST CURSOR FOR                       
               SELECT 'Y'                                               
                 FROM CSS_CNSMPTN_HIST                                  
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND METER_NO           = :CX-METER-NO                 
                  AND REG_ID_NO          = :CX-REG-ID-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_CNSMPTN_HIST CURSOR FOR                               
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND METER_NO           = :CX-METER-NO                         
MFA-TR*           AND REG_ID_NO          = :CX-REG-ID-NO                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILLING_DET_CUR2 CURSOR FOR                       
               SELECT ACCOUNT_NO,                                       
                      PREMISE_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                               
                      DATE_ORIG_BILL,                                   
                      AMT_BILL_ITEM,                                    
                      CODE_BILL_CALC,                                   
                      CODE_BILL_ITM_TYPE,                               
                      CODE_BILL_ITM_IND,                                
                      CODE_DR_CR_CNSMPTN,                               
                      AMT_STATE_TAX,                                    
                      AMT_CITY_TAX,                                     
                      AMT_OTHER_TAX,                                    
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      CODE_CURTAIL_PRTY,                                
                      CODE_STAT_TAX_XMT,                                
                      CODE_CITY_TAX_XMT,                                
                      CODE_OTHR_TAX_XMT                                 
                 FROM CSS_BILLING_DET                                   
                WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                 
                  AND BILL_NO          = :BG-BILL-NO                    
                  AND CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE             
                  AND IC_NO            = :BG-IC-NO                      
                  AND DATE_ORIG_BILL IS NULL                            
T18223            AND CODE_BILL_CALC <> :WS-NON-CALC                    
             ORDER BY BILL_ITEM_TIMESTMP DESC                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILLING_DET_CUR2 CURSOR FOR                               
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               DATE_ORIG_BILL,                                           
MFA-TR*               AMT_BILL_ITEM,                                            
MFA-TR*               CODE_BILL_CALC,                                           
MFA-TR*               CODE_BILL_ITM_TYPE,                                       
MFA-TR*               CODE_BILL_ITM_IND,                                        
MFA-TR*               CODE_DR_CR_CNSMPTN,                                       
MFA-TR*               AMT_STATE_TAX,                                            
MFA-TR*               AMT_CITY_TAX,                                             
MFA-TR*               AMT_OTHER_TAX,                                            
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               CODE_SIC_NO,                                              
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT                                         
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                         
MFA-TR*           AND BILL_NO          = :BG-BILL-NO                            
MFA-TR*           AND CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE                     
MFA-TR*           AND IC_NO            = :BG-IC-NO                              
MFA-TR*           AND DATE_ORIG_BILL IS NULL                                    
MFA-TR*           AND CODE_BILL_CALC <> :WS-NON-CALC                            
MFA-TR*      ORDER BY BILL_ITEM_TIMESTMP DESC                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-METER-NO            PIC X(9)                 .          
CVT000 01  LINK-READ-DATE           PIC X(10)                .          
CVT000 01  LINK-OVERRIDE-IND        PIC X(01)                .          
CVT000 01  LINK-READER-ID           PIC X(05)                .          
A02906 01  LINK-KWH-TOU             PIC X(176)               .          
CVT000 01  LINK-KW-TOU              PIC X(176)               .          
CVT000 01  LINK-KVA-TOU             PIC X(176)               .          
CVT000 01  LINK-USER-ID             PIC X(08)                .          
CVT000 01  LINK-ADJ-REASON-CD       PIC X(04)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-METER-NO                                           
CVT000         ,LINK-READ-DATE                                          
CVT000         ,LINK-OVERRIDE-IND                                       
CVT000         ,LINK-READER-ID                                          
CVT000         ,LINK-KWH-TOU                                            
CVT000         ,LINK-KW-TOU                                             
CVT000         ,LINK-KVA-TOU                                            
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-ADJ-REASON-CD                                      
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU 0100-EXIT.              
REARCH*    PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.                      
           PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE              AS    RETURN_CODE             
REARCH       ,LTRIM(RTRIM(:S-ERROR-CODE))        AS    ERROR_CODE              
REARCH       ,:S-TIME-PERIOD              AS    TIME_PERIOD             
REARCH       ,LTRIM(RTRIM(:S-REG-TYPE))          AS    REG_TYPE                
REARCH       ,LTRIM(RTRIM(:S-WORK-QUEUE-CODE))   AS    WORK_QUEUE_CODE         
REARCH       ,LTRIM(RTRIM(:S-USAGE-UNITS))       AS    USAGE_UNITS             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,STRIP(:S-ERROR-CODE)        AS    ERROR_CODE                      
MFA-TR*      ,:S-TIME-PERIOD              AS    TIME_PERIOD                     
MFA-TR*      ,STRIP(:S-REG-TYPE)          AS    REG_TYPE                        
MFA-TR*      ,STRIP(:S-WORK-QUEUE-CODE)   AS    WORK_QUEUE_CODE                 
MFA-TR*      ,STRIP(:S-USAGE-UNITS)       AS    USAGE_UNITS                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
CVT000     MOVE LINK-READ-DATE            TO PARM-READ-DATE           . 
CVT000     MOVE LINK-OVERRIDE-IND         TO PARM-OVERRIDE-IND        . 
CVT000     MOVE LINK-READER-ID            TO PARM-READER-ID           . 
CVT000     MOVE LINK-KWH-TOU              TO PARM-KWH-TOU             . 
CVT000     MOVE LINK-KW-TOU               TO PARM-KW-TOU              . 
CVT000     MOVE LINK-KVA-TOU              TO PARM-KVA-TOU             . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-ADJ-REASON-CD        TO PARM-ADJ-REASON-CD       . 
       0100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *****************************************************************         
REARCH*1000-PROCESS-INPUT.                                                      
      *                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
      *                                                                         
REARCH*1000-EXIT.                                                               
REARCH*    EXIT.                                                                
      *****************************************************************         
      * 1100-RECEIVE-PARMS                                                      
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE                    
      *****************************************************************         
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
C34424     MOVE WS-NO            TO  WS-ROLLBACK-FLAG                   
           PERFORM 2050-EDIT-TOU-PARMS THRU 2050-EXIT.                  
      *                                                                         
PCR672     IF RS-ERROR-CODE = SPACES                                    
PCR672        PERFORM 2350-SET-MNT-TRANS-VARS    THRU 2350-EXIT         
PCR672        PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
PCR672     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE      TO S-RETURN-CODE                   
REARCH     MOVE  RS-ERROR-CODE       TO S-ERROR-CODE                    
REARCH     MOVE  RS-TIME-PERIOD      TO S-TIME-PERIOD                   
REARCH     MOVE  RS-REG-TYPE         TO S-REG-TYPE                      
REARCH     MOVE  RS-WORK-QUEUE-CODE  TO S-WORK-QUEUE-CODE               
REARCH     MOVE  RS-USAGE-UNITS      TO S-USAGE-UNITS.                  
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                         
       2050-EDIT-TOU-PARMS.                                             
A00795     PERFORM 7650-GET-TIME    THRU 7650-EXIT.                     
      *                                                                         
           MOVE PARM-OVERRIDE-IND TO CX-EXCEPT-OVERRIDE-CD              
                                     MN-EXCEPT-OVERRIDE-CD.             
      * CHECK FOR VALID ACCOUNT NUMBER                                          
           MOVE PARM-ACCOUNT-NO-RED TO WS-ACCOUNT-NO                    
                                       AT-ACCOUNT-NO.                   
           PERFORM 7010-SELECT-ACCOUNT   THRU 7010-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                  
               PERFORM 5400-GET-OLD-ACCOUNT    THRU 5400-EXIT           
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE WS-ERR-MSG-D0142 TO RS-ERROR-CODE                   
TP5186         PERFORM 5600-SEND-ERROR THRU 5600-EXIT                   
           END-IF.                                                      
           IF AT-CODE-ACCT-STAT = 'B'                                   
               MOVE WS-ERR-MSG-D0716 TO RS-ERROR-CODE                   
TP5186         PERFORM 5600-SEND-ERROR THRU 5600-EXIT                   
           END-IF.                                                      
           MOVE AT-ACCOUNT-NO         TO MN-ACCOUNT-NO                  
                                         UT-ACCOUNT-NO                  
T21677                                   BG-ACCOUNT-NO                  
T21677                                   BI-ACCOUNT-NO.                 
           MOVE WS-E                  TO MN-CODE-UTIL-TYPE              
                                         UT-CODE-UTIL-TYPE              
                                         BG-CODE-UTIL-TYPE.             
T21677**************************************************************            
T21677* TO CHECK WHETHER THE ACCOUNT IS ALREADY BILLED OR NOT      *            
T21677**************************************************************            
T21677     MOVE AT-COMPANY-NO               TO G6-COMPANY-NO.           
T21677     PERFORM 6260-GET-REVENUE-MONTH   THRU 6260-EXIT.             
T21677     MOVE WS-REV-MNTH                 TO BG-REVENUE-MONTH.        
T21677     PERFORM 7090-GET-BILL-STATUS     THRU 7090-EXIT.             
T21677**************************************************************            
           MOVE PARM-METER-NO         TO WS-METER-NO                    
                                         MN-METER-NO.                   
T22243     MOVE AT-COMPANY-NO         TO MC-COMPANY-NO.                 
           MOVE PARM-READ-DATE        TO WS-READ-DATE.                  
           MOVE PARM-KWH-TOU          TO WS-PARM-KWH-TOU.               
           MOVE PARM-KW-TOU           TO WS-PARM-KW-TOU.                
           MOVE PARM-KVA-TOU          TO WS-PARM-KVA-TOU.               
PCR672     MOVE PARM-USER-ID          TO WS-USERID.                     
PCR672     MOVE PARM-ADJ-REASON-CD    TO BG-ADJ-REASON-CD.              
PCR672     IF BG-ADJ-REASON-CD = LOW-VALUES                             
PCR672        MOVE -1           TO WS-ADJ-NULL-IND                      
PCR672     ELSE                                                         
PCR672        MOVE ZERO         TO WS-ADJ-NULL-IND                      
PCR672     END-IF.                                                      
           PERFORM 2060-MOVE-KWH-FIELDS THRU 2060-EXIT                  
               VARYING WS-MEM-NO FROM 1 BY 1                            
A02906                 UNTIL WS-MEM-NO GREATER THAN 8.                  
           PERFORM 2070-MOVE-KW-FIELDS THRU 2070-EXIT                   
               VARYING WS-MEM-NO FROM 1 BY 1                            
C28373                 UNTIL WS-MEM-NO GREATER THAN 8.                  
C28373*               UNTIL WS-MEM-NO GREATER THAN 6.                           
           PERFORM 2080-MOVE-KVA-FIELDS THRU 2080-EXIT                  
               VARYING WS-MEM-NO FROM 1 BY 1                            
                       UNTIL WS-MEM-NO GREATER THAN 8.                  
           PERFORM 2090-MOVE-TOT-KWH THRU 2090-EXIT.                    
           PERFORM 5410-UPDATE-BILLING-INFO THRU 5410-EXIT.             
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2060-MOVE-KWH-FIELDS.                                            
           MOVE SPACE TO WS-MN-STATUS.                                  
           MOVE SPACE TO WS-RG-STATUS.                                  
           MOVE KWH-TOU-READ (WS-MEM-NO)    TO WS-READING.              
           IF WS-READING > SPACES                                       
              MOVE WS-READING-NUM           TO WS-METER-READ-NUM        
              MOVE KWH-TOU-USAG-TYPE (WS-MEM-NO)                        
                                            TO WS-CODE-USAGE-TYPE       
              MOVE KWH-TOU-USAG-ID (WS-MEM-NO)                          
                                            TO WS-CODE-USAGE-ID         
              MOVE KWH-TOU-USAG-SOURCE (WS-MEM-NO)                      
                                            TO WS-CODE-USAGE-SOURCE     
              MOVE KWH-TOU-RD-CD (WS-MEM-NO)                            
                                            TO WS-READ-CODE             
              MOVE KWH-TOU-NO-RD (WS-MEM-NO)                            
                                            TO WS-NO-RD-CODE            
              MOVE WS-R                     TO WS-TYPE-TO-PROCESS       
C28373        MOVE KWH-TOU-TIME-PRD (WS-MEM-NO)                         
C28373                                      TO WS-TIME-PERIOD           
C28373        MOVE WS-TIME-PERIOD-NUM       TO WS-CODE-TIME-PERIOD      
C28373        MOVE KWH-TOU-SESN-IND (WS-MEM-NO)                         
C28373                                      TO WS-SEASON-IND            
C28373                                         WS-HOLD-SEASON           
              MOVE WS-CODE-TIME-PERIOD      TO RS-TIME-PERIOD           
              MOVE KWH-TOU-USAGVAL (WS-MEM-NO)                          
                                            TO RS-REG-TYPE              
A02906        IF WS-MEM-NO NOT EQUAL 8                                  
TP5186           MOVE WS-YES                TO WS-REG-PROCESSED-FLAG    
                 PERFORM 2100-EDIT-PARMS THRU 2100-EXIT                 
A02906           IF WS-CODE-USAGE-ID = 'F' AND WS-CODE-TIME-PERIOD = 0  
A02906              MOVE WS-NO              TO WS-REG-PROCESSED-FLAG    
A02906           END-IF                                                 
TP5186        ELSE                                                      
TP5186           MOVE WS-METER-READ-NUM     TO WS-MN-KWH                
C28373           MOVE WS-YES                TO WS-MN-TOU-FLAG           
P00251           MOVE KWH-TOU-USAGVAL(WS-MEM-NO)                        
P00251                                      TO WS-MN-REG-TYPE           
P00251           MOVE KWH-TOU-USAG-TYPE(WS-MEM-NO)                      
P00251                                      TO WS-MN-CODE-USAGE-TYPE    
P00251           MOVE KWH-TOU-USAG-ID(WS-MEM-NO)                        
P00251                                      TO WS-MN-CODE-USAGE-ID      
P00251           MOVE KWH-TOU-USAG-SOURCE(WS-MEM-NO)                    
P00251                                      TO WS-MN-CODE-USAGE-SOURCE  
TP5186        END-IF                                                    
           END-IF.                                                      
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2070-MOVE-KW-FIELDS.                                             
           MOVE SPACE TO WS-MN-STATUS.                                  
           MOVE SPACE TO WS-RG-STATUS.                                  
           MOVE KW-TOU-READ (WS-MEM-NO)     TO WS-READING.              
           IF WS-READING > SPACES                                       
              MOVE WS-READING-NUM           TO WS-METER-READ-NUM        
              MOVE KW-TOU-USAG-TYPE (WS-MEM-NO)                         
                                            TO WS-CODE-USAGE-TYPE       
              MOVE KW-TOU-USAG-ID (WS-MEM-NO)                           
                                            TO WS-CODE-USAGE-ID         
              MOVE KW-TOU-USAG-SOURCE (WS-MEM-NO)                       
                                            TO WS-CODE-USAGE-SOURCE     
              MOVE KW-TOU-RD-CD (WS-MEM-NO) TO WS-READ-CODE             
              MOVE KW-TOU-NO-RD (WS-MEM-NO) TO WS-NO-RD-CODE            
              MOVE WS-R                     TO WS-TYPE-TO-PROCESS       
C28373        MOVE KW-TOU-TIME-PRD (WS-MEM-NO)                          
C28373                                      TO WS-TIME-PERIOD           
C28373        MOVE WS-TIME-PERIOD-NUM       TO WS-CODE-TIME-PERIOD      
C28373        MOVE KW-TOU-SESN-IND (WS-MEM-NO)                          
C28373                                      TO WS-SEASON-IND            
C28373                                         WS-HOLD-SEASON           
              MOVE WS-CODE-TIME-PERIOD      TO RS-TIME-PERIOD           
              MOVE KW-TOU-USAGVAL (WS-MEM-NO)                           
                                            TO RS-REG-TYPE              
              PERFORM 2100-EDIT-PARMS THRU 2100-EXIT                    
           END-IF.                                                      
       2070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2080-MOVE-KVA-FIELDS.                                            
           MOVE SPACE TO WS-MN-STATUS.                                  
           MOVE SPACE TO WS-RG-STATUS.                                  
           MOVE KVA-TOU-READ (WS-MEM-NO)    TO WS-READING.              
           IF WS-READING > SPACES                                       
              MOVE WS-READING-NUM           TO WS-METER-READ-NUM        
              MOVE KVA-TOU-USAG-TYPE (WS-MEM-NO)                        
                                            TO WS-CODE-USAGE-TYPE       
              MOVE KVA-TOU-USAG-ID (WS-MEM-NO)                          
                                            TO WS-CODE-USAGE-ID         
              MOVE KVA-TOU-USAG-SOURCE (WS-MEM-NO)                      
                                            TO WS-CODE-USAGE-SOURCE     
              MOVE KVA-TOU-RD-CD (WS-MEM-NO)                            
                                            TO WS-READ-CODE             
              MOVE KVA-TOU-NO-RD (WS-MEM-NO)                            
                                            TO WS-NO-RD-CODE            
              MOVE WS-R                     TO WS-TYPE-TO-PROCESS       
C28373        MOVE KVA-TOU-TIME-PRD (WS-MEM-NO)                         
C28373                                      TO WS-TIME-PERIOD           
C28373        MOVE WS-TIME-PERIOD-NUM       TO WS-CODE-TIME-PERIOD      
C28373        MOVE KVA-TOU-SESN-IND (WS-MEM-NO)                         
C28373                                      TO WS-SEASON-IND            
C28373                                         WS-HOLD-SEASON           
              MOVE WS-CODE-TIME-PERIOD      TO RS-TIME-PERIOD           
              MOVE KVA-TOU-USAGVAL (WS-MEM-NO)                          
                                            TO RS-REG-TYPE              
              PERFORM 2100-EDIT-PARMS THRU 2100-EXIT                    
           END-IF.                                                      
       2080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2090-MOVE-TOT-KWH.                                               
P00251     MOVE WS-MN-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE             
P00251                                   MN-CODE-USAGE-TYPE.            
P00251     MOVE WS-MN-CODE-USAGE-ID   TO WS-CODE-USAGE-ID.              
P00251     MOVE WS-MN-CODE-USAGE-SOURCE                                 
P00251                              TO WS-CODE-USAGE-SOURCE.            
           MOVE WS-0                TO MN-CODE-TIME-PERIOD.             
           MOVE WS-M                TO WS-TYPE-TO-PROCESS.              
           MOVE WS-0                TO RS-TIME-PERIOD.                  
P00251     MOVE WS-MN-REG-TYPE      TO RS-REG-TYPE                      
           MOVE WS-TIME             TO MN-LAST-REG-READ-TIME.           
           PERFORM 2100-EDIT-PARMS  THRU 2100-EXIT.                     
       2090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-EDIT-PARMS.                                                 
           PERFORM 7020-SELECT-MTRD-ENVRNMT THRU 7020-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-ERR-MSG-D0536 TO RS-ERROR-CODE                    
              PERFORM 5600-SEND-ERROR THRU 5600-EXIT                    
           END-IF.                                                      
           MOVE MN-IC-NO TO UT-IC-NO                                    
           PERFORM 7030-SELECT-UTIL-ENVRNMT THRU 7030-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-ERR-MSG-D0537 TO RS-ERROR-CODE                    
              PERFORM 5600-SEND-ERROR THRU 5600-EXIT                    
           END-IF.                                                      
           IF WS-MN-PROCESS                                             
              IF WS-READ-CODE EQUAL WS-J OR WS-K OR WS-L                
                 MOVE ZEROES           TO MN-NO-CONSEC-CRD-READ         
              ELSE                                                      
T20560           IF WS-READ-CODE = WS-S OR WS-M                         
                    ADD +1                TO MN-NO-CONSEC-CRD-READ      
                 END-IF                                                 
                 IF WS-READ-CODE EQUAL WS-L                             
                    MOVE ZEROES           TO MN-NO-CONSEC-CRD-READ      
                    IF MN-LAST-REG-READ-DATE = LOW-VALUES               
                       MOVE ZERO TO WS-CALC-NO-DAYS                     
                    ELSE                                                
                       MOVE MN-LAST-REG-READ-DATE TO WS-DATE-CALC-1     
                       MOVE PARM-READ-DATE        TO WS-DATE-CALC-2     
                       PERFORM 7590-CALC-NO-DAYS     THRU 7590-EXIT     
                    END-IF                                              
                    IF PARM-OVERRIDE-IND NOT EQUAL 'Y' AND              
PCR672                PARM-OVERRIDE-IND NOT EQUAL 'Z'                   
                       IF WS-CALC-NO-DAYS > 40                          
                          MOVE WS-ERR-MSG-D0735 TO RS-ERROR-CODE        
TP5186                    PERFORM 5600-SEND-ERROR THRU 5600-EXIT        
                       ELSE                                             
                          IF WS-CALC-NO-DAYS < 10                       
                             MOVE WS-ERR-MSG-D0736 TO RS-ERROR-CODE     
TP5186                       PERFORM 5600-SEND-ERROR THRU 5600-EXIT     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              IF MN-NO-CONSEC-CRD-READ > 11                             
                 MOVE 'CRL'            TO RS-WORK-QUEUE-CODE            
              END-IF                                                    
              MOVE MN-CODE-UTIL-TYPE   TO MC-CODE-UTIL-TYPE             
              MOVE MN-METER-NO         TO MC-METER-NO                   
              MOVE MN-REG-ID-NO        TO MC-REG-ID-NO                  
              PERFORM 7050-SELECT-MTR-CAP THRU 7050-EXIT                
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-ERR-MSG-D0538 TO RS-ERROR-CODE                 
TP5186           PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              ELSE                                                      
                 IF WS-READ-CODE EQUAL WS-L                             
                    IF MC-CONSTANT EQUAL ZERO                           
                       MOVE WS-ERR-MSG-D0737 TO RS-ERROR-CODE           
TP5186                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              MOVE UT-CODE-MTR-READ-FREQ TO WS-FREQ-BREAKDOWN           
              MOVE WS-TIME               TO MN-LAST-REG-READ-TIME       
              PERFORM 2200-PROCESS-PRIMARY-METER THRU 2200-EXIT         
           END-IF.                                                      
           IF WS-RG-PROCESS                                             
              MOVE MN-ACCOUNT-NO TO RG-ACCOUNT-NO                       
              MOVE MN-MTR-REF-NO TO RG-MTR-REF-NO                       
              MOVE MN-IC-NO TO RG-IC-NO                                 
              MOVE MN-CODE-UTIL-TYPE TO RG-CODE-UTIL-TYPE               
              MOVE WS-CODE-USAGE-TYPE TO RG-CODE-USAGE-TYPE             
              MOVE WS-CODE-USAGE-ID TO RG-CODE-USAGE-ID                 
              MOVE WS-CODE-USAGE-SOURCE TO RG-CODE-USAGE-SOURCE         
              MOVE WS-CODE-TIME-PERIOD TO RG-CODE-TIME-PERIOD           
              PERFORM 7040-SELECT-REGISTER-READ THRU 7040-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-ERR-MSG-D0539 TO RS-ERROR-CODE                 
TP5186           PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
              MOVE RG-CODE-UTIL-TYPE   TO MC-CODE-UTIL-TYPE             
              MOVE RG-METER-NO         TO MC-METER-NO                   
              MOVE RG-REG-ID-NO        TO MC-REG-ID-NO                  
              PERFORM 7050-SELECT-MTR-CAP THRU 7050-EXIT                
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-ERR-MSG-D0538 TO RS-ERROR-CODE                 
TP5186           PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              ELSE                                                      
                 IF WS-READ-CODE EQUAL WS-L                             
                    IF MC-CONSTANT EQUAL ZERO                           
                       MOVE WS-ERR-MSG-D0737 TO RS-ERROR-CODE           
TP5186                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              MOVE UT-CODE-MTR-READ-FREQ TO WS-FREQ-BREAKDOWN           
              MOVE RG-LAST-REG-READ-DT   TO MN-LAST-REG-READ-DATE       
              MOVE RG-LAST-REG-READ-TM   TO MN-LAST-REG-READ-TIME       
              MOVE WS-TIME               TO RG-LAST-REG-READ-TM         
              PERFORM 2250-PROCESS-ADD-REGISTER THRU 2250-EXIT          
           END-IF.                                                      
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-PROCESS-PRIMARY-METER.                                      
           IF WS-READ-DATE LESS THAN MN-LAST-REG-READ-DATE              
              MOVE WS-ERR-MSG-D0545 TO RS-ERROR-CODE                    
              PERFORM 5600-SEND-ERROR THRU 5600-EXIT                    
           END-IF.                                                      
           MOVE UT-CODE-UTIL-TYPE      TO RS-CODE-UTIL-TYPE.            
           MOVE UT-RATE-PLAN-NO        TO RS-RATE-PLAN-NO.              
           MOVE 'C'                    TO RS-CODE-USE-INST-TYPE.        
           PERFORM 7510-SELECT-MAX-VERSION       THRU 7510-EXIT.        
           PERFORM 7500-SELECT-RATE-USE-SEASN    THRU 7500-EXIT.        
           MOVE WS-WORK-MM TO WS-READ-MTH-MM                            
           IF WS-READ-MTH-NUM >= RS-DATE-FROM                           
            AND WS-READ-MTH-NUM <= RS-DATE-TO                           
              IF WS-SEASON-IND = 'C'                                    
                 MOVE RS-CODE-SEASON TO WS-SEASON-IND                   
              ELSE                                                      
                 IF RS-CODE-SEASON = 'S'                                
                    MOVE 'N' TO WS-SEASON-IND                           
                 ELSE                                                   
                    MOVE 'S' TO WS-SEASON-IND                           
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-SEASON-IND = 'P'                                    
                 MOVE RS-CODE-SEASON TO WS-SEASON-IND                   
              ELSE                                                      
                 IF RS-CODE-SEASON = 'S'                                
                    MOVE 'N' TO WS-SEASON-IND                           
                 ELSE                                                   
                    MOVE 'S' TO WS-SEASON-IND                           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 5000-UPDATE             THRU 5000-EXIT.              
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2220-CHECK-ROLLOVER.                                             
TP5186     MOVE WS-MN-KWH           TO WS-MTR-WO-ROLLOVER.              
TP5186        IF (WS-MN-KWH -                                           
                  MN-LAST-READ-VALUE) LESS THAN ZERO                    
T20431            MOVE 'Y'   TO WS-ROLL-FLAG                            
                  EVALUATE MC-NO-DIALS                                  
T20321            WHEN 3                                                
T20321               ADD       1000  TO WS-MN-KWH                       
                  WHEN 4                                                
TP5186               ADD       10000 TO WS-MN-KWH                       
                  WHEN 5                                                
TP5186               ADD      100000 TO WS-MN-KWH                       
                  WHEN 6                                                
TP5186               ADD     1000000 TO WS-MN-KWH                       
                  WHEN 7                                                
TP5186               ADD    10000000 TO WS-MN-KWH                       
                  WHEN 8                                                
TP5186               ADD   100000000 TO WS-MN-KWH                       
                  WHEN 9                                                
TP5186               ADD  1000000000 TO WS-MN-KWH                       
                  WHEN 10                                               
TP5186               ADD 10000000000 TO WS-MN-KWH                       
              END-IF.                                                   
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2235-TOTAL-ROLLOVER.                                             
           EVALUATE MC-NO-DIALS                                         
T20321        WHEN 3                                                    
T20321           MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-3                
T20321           MOVE WS-LENGTH-3         TO MN-LAST-READ-VALUE         
              WHEN 4                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-4                
                 MOVE WS-LENGTH-4         TO MN-LAST-READ-VALUE         
              WHEN 5                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-5                
                 MOVE WS-LENGTH-5         TO MN-LAST-READ-VALUE         
              WHEN 6                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-6                
                 MOVE WS-LENGTH-6         TO MN-LAST-READ-VALUE         
              WHEN 7                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-7                
                 MOVE WS-LENGTH-7         TO MN-LAST-READ-VALUE         
              WHEN 8                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-8                
                 MOVE WS-LENGTH-8         TO MN-LAST-READ-VALUE         
              WHEN 9                                                    
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-9                
                 MOVE WS-LENGTH-9         TO MN-LAST-READ-VALUE         
              WHEN 10                                                   
                 MOVE MN-LAST-READ-VALUE  TO WS-LENGTH-10               
                 MOVE WS-LENGTH-10        TO MN-LAST-READ-VALUE.        
       2235-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2250-PROCESS-ADD-REGISTER.                                       
T20431     MOVE 'N'              TO  WS-ROLL-FLAG                       
T16520     IF WS-READ-DATE = RG-LAST-REG-READ-DT                        
T16520       AND WS-METER-READ-NUM = 0                                  
T16520        GO TO 2250-EXIT                                           
T16520     END-IF.                                                      
           IF WS-READ-DATE LESS THAN RG-LAST-REG-READ-DT                
              MOVE WS-ERR-MSG-D0545 TO RS-ERROR-CODE                    
              PERFORM 5600-SEND-ERROR THRU 5600-EXIT                    
           END-IF.                                                      
           IF WS-CODE-USAGE-TYPE = 'B' OR 'C'                           
              IF RG-CODE-REG-STATUS = 'K'                               
                 IF WS-METER-READ-NUM EQUAL 0                           
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-ERR-MSG-D0547 TO RS-ERROR-CODE              
                    PERFORM 5600-SEND-ERROR THRU 5600-EXIT              
                 END-IF                                                 
              ELSE                                                      
                 IF RG-CODE-REG-STATUS = 'J'                            
                    IF WS-METER-READ-NUM EQUAL RG-LAST-READ-VALUE       
                       PERFORM 2262-UPDATE-REG-FIELDS THRU 2262-EXIT    
                       GO TO 2250-EXIT                                  
                    ELSE                                                
                       MOVE WS-ERR-MSG-D0550 TO RS-ERROR-CODE           
                       PERFORM 5600-SEND-ERROR THRU 5600-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF RG-CODE-REG-STATUS = 'K'                               
                 IF WS-METER-READ-NUM EQUAL 0                           
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-ERR-MSG-D0547 TO RS-ERROR-CODE              
                    PERFORM 5600-SEND-ERROR THRU 5600-EXIT              
                 END-IF                                                 
              ELSE                                                      
                 IF RG-CODE-REG-STATUS = 'J'                            
                    IF WS-CODE-USAGE-TYPE = 'J' OR 'E'                  
                       PERFORM 2262-UPDATE-REG-FIELDS THRU 2262-EXIT    
                       GO TO 2250-EXIT                                  
                    ELSE                                                
                       IF WS-METER-READ-NUM EQUAL RG-LAST-READ-VALUE    
                          PERFORM 2262-UPDATE-REG-FIELDS THRU 2262-EXIT 
                          GO TO 2250-EXIT                               
                       ELSE                                             
                          MOVE WS-ERR-MSG-D0550 TO RS-ERROR-CODE        
                          PERFORM 5600-SEND-ERROR THRU 5600-EXIT        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           IF WS-CODE-USAGE-TYPE = 'B' OR 'C'                           
              IF WS-METER-READ-NUM < 10 ** (MC-NO-DIALS + 1)            
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ERR-MSG-D0555 TO RS-ERROR-CODE                 
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
           END-IF.                                                      
           IF WS-CODE-USAGE-TYPE = 'J' OR 'E'                           
              MOVE WS-METER-READ-NUM    TO WS-MTR-WO-ROLLOVER           
           ELSE                                                         
              PERFORM 2270-CHECK-ROLLOVER THRU 2270-EXIT                
           END-IF.                                                      
           MOVE UT-CODE-UTIL-TYPE           TO RS-CODE-UTIL-TYPE.       
           MOVE UT-RATE-PLAN-NO             TO RS-RATE-PLAN-NO.         
           MOVE 'C'                         TO RS-CODE-USE-INST-TYPE.   
           PERFORM 7510-SELECT-MAX-VERSION       THRU 7510-EXIT.        
           PERFORM 7500-SELECT-RATE-USE-SEASN    THRU 7500-EXIT.        
           MOVE WS-WORK-MM TO WS-READ-MTH-MM                            
           IF WS-READ-MTH-NUM >= RS-DATE-FROM                           
             AND WS-READ-MTH-NUM <= RS-DATE-TO                          
               IF WS-SEASON-IND = 'C'                                   
                   MOVE RS-CODE-SEASON TO WS-SEASON-IND                 
               ELSE                                                     
                   IF RS-CODE-SEASON = 'S'                              
                       MOVE 'N' TO WS-SEASON-IND                        
                   ELSE                                                 
                       MOVE 'S' TO WS-SEASON-IND                        
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               IF WS-SEASON-IND = 'P'                                   
                   MOVE RS-CODE-SEASON TO WS-SEASON-IND                 
               ELSE                                                     
                   IF RS-CODE-SEASON = 'S'                              
                       MOVE 'N' TO WS-SEASON-IND                        
                   ELSE                                                 
                       MOVE 'S' TO WS-SEASON-IND                        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
PCR672     IF PARM-OVERRIDE-IND = 'Y' OR PARM-OVERRIDE-IND = 'Z'        
               PERFORM 5000-UPDATE THRU 5000-EXIT                       
               GO TO 2250-EXIT                                          
           END-IF                                                       
A00795     MOVE UT-RATE-PLAN-NO        TO CWS72-RATE-PLAN               
A00795     MOVE UT-CODE-UTIL-TYPE      TO CWS72-UTIL-TYPE               
A00795                                    BG-CODE-UTIL-TYPE             
A00795     MOVE UT-ACCOUNT-NO          TO CWS72-ACCOUNT-NO              
A00795                                    BG-ACCOUNT-NO                 
A00795     MOVE UT-IC-NO               TO BG-IC-NO                      
A00795                                    CWS72-IC-NO                   
A00795     MOVE MN-MTR-REF-NO          TO CWS72-MTR-REF-NO              
A00795     MOVE AT-REV-MTH-LST-NRML    TO CWS72-REV-MTH-LST-NRML        
A00795     MOVE WS-CODE-TIME-PERIOD    TO CX-CODE-TIME-PERIOD           
A00795                                    CWS72-TIME-PERIOD             
A00795     MOVE WS-CODE-USAGE-ID       TO CWS72-CODE-USAGE-ID           
A00795     SET CWS72-ONLINE-CALL       TO TRUE                          
           IF AT-LAST-NRML-BILL-NO = 0                                  
              MOVE 1 TO AT-LAST-NRML-BILL-NO                            
           END-IF                                                       
           MOVE AT-LAST-NRML-BILL-NO   TO BG-BILL-NO                    
A00795*                                                                         
A00795     IF CWS72-TIME-PERIOD       = WS-HL-CODE-TIME-PERIOD          
A00795        AND CWS72-CODE-USAGE-ID = WS-HL-CODE-USAGE-ID             
A00795        CONTINUE                                                  
A00795     ELSE                                                         
A00795        MOVE CWS72-TIME-PERIOD   TO WS-HL-CODE-TIME-PERIOD        
A00795        MOVE CWS72-CODE-USAGE-ID TO WS-HL-CODE-USAGE-ID           
A00795        PERFORM 6351-CPD72-HI-LO-MAIN THRU 6351-CPD72-EXIT        
A00795        PERFORM 6399-CHECK-HI-LO-ERROR THRU 6399-EXIT             
A00795     END-IF.                                                      
A00795*                                                                         
A00795     IF WS-CODE-USAGE-TYPE = 'B'                                  
A00795        COMPUTE WS-CRNT-USE  ROUNDED                              
A00795                = (( WS-METER-READ-NUM                            
A00795                    - RG-LAST-READ-VALUE) * MC-CONSTANT )         
A00795        IF WS-CRNT-USE < (CWS72-LO-KWH * CX-NO-DAYS)              
A00795           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1019        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0551        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
A00795        IF WS-CRNT-USE > (CWS72-HI-KWH * CX-NO-DAYS)              
A00795           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1020        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0552        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
           END-IF                                                       
A00795     IF WS-CODE-USAGE-TYPE = 'J'                                  
A00795        COMPUTE  WS-CRNT-USE = WS-METER-READ-NUM * MC-CONSTANT    
A00795        IF WS-CRNT-USE < CWS72-LO-KW                              
A00795           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1021        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0553        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
A00795        IF WS-CRNT-USE > CWS72-HI-KW                              
T20431           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1022        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0554        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
A00795     END-IF                                                       
A00795     IF WS-CODE-USAGE-TYPE = 'E'                                  
A00795        COMPUTE  WS-CRNT-USE = WS-METER-READ-NUM * MC-CONSTANT    
A00795        IF WS-CRNT-USE < CWS72-LO-KVA                             
T20431           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1021        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0553        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
A00795        IF WS-CRNT-USE > CWS72-HI-KVA                             
T20431           MOVE WS-CRNT-USE                 TO RS-USAGE-UNITS     
T20431           IF WS-ROLL-FLAG  = 'Y'                                 
T20431               MOVE WS-ERR-MSG-D1022        TO RS-ERROR-CODE      
T20431           ELSE                                                   
                     MOVE WS-ERR-MSG-D0554        TO RS-ERROR-CODE      
T20431           END-IF                                                 
C34424           MOVE WS-YES                      TO WS-ROLLBACK-FLAG   
                 PERFORM 5600-SEND-ERROR THRU 5600-EXIT                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2262-UPDATE-REG-FIELDS.                                          
           MOVE PARM-READ-DATE TO RG-LAST-REG-READ-DT.                  
           MOVE WS-TIME TO RG-LAST-REG-READ-TM.                         
           MOVE SPACE TO RG-CODE-NO-RD-REASON.                          
           MOVE 'J' TO RG-CODE-CRNT-REG-READ.                           
           PERFORM 8843-UPDATE-REGISTER-READ THRU 8843-EXIT.            
       2262-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2270-CHECK-ROLLOVER.                                             
           MOVE WS-METER-READ-NUM    TO WS-MTR-WO-ROLLOVER.             
           IF (WS-METER-READ-NUM -                                      
              RG-LAST-READ-VALUE) LESS THAN ZERO                        
T20431        MOVE 'Y'   TO WS-ROLL-FLAG                                
              EVALUATE MC-NO-DIALS                                      
T20321        WHEN 3                                                    
T20321           ADD       1000  TO WS-METER-READ-NUM                   
              WHEN 4                                                    
                 ADD       10000 TO WS-METER-READ-NUM                   
              WHEN 5                                                    
                 ADD      100000 TO WS-METER-READ-NUM                   
              WHEN 6                                                    
                 ADD     1000000 TO WS-METER-READ-NUM                   
              WHEN 7                                                    
                 ADD    10000000 TO WS-METER-READ-NUM                   
              WHEN 8                                                    
                 ADD   100000000 TO WS-METER-READ-NUM                   
              WHEN 9                                                    
                 ADD  1000000000 TO WS-METER-READ-NUM                   
              WHEN 10                                                   
                 ADD 10000000000 TO WS-METER-READ-NUM                   
           END-IF.                                                      
       2270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PCR672******************************************************************        
      * 2350-SET-MNT-TRANS-VARS                                        *        
      *      -- THIS MODULE SETS UP THE HOST VARIABLES WITH SYSTEM     *        
      *         WORKING STORAGE OR HARD-CODED VALUES FOR INSERTING INTO*        
      *         CSS_MNT_TRANS_HIST IN ORDER TO COMPLETE THE            *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       2350-SET-MNT-TRANS-VARS.                                         
      *                                                                         
T18001*    PERFORM 7060-GET-RESP-AREA-ID    THRU 7060-EXIT.                     
           PERFORM 7070-GET-CURRENT-DATE    THRU 7070-EXIT.             
           PERFORM 7080-ACCEPT-TIMESTAMP    THRU 7080-EXIT.             
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
T18001*    MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.                 
T18001     MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USERID                   TO MH-USER-ID.              
           MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
      *    MOVE WS-MNT-TRANS-HIST-MSG       TO WS-COMMENT.                      
T18295     STRING WS-MNT-TRANS-HIST-MSG                                 
T18295            ' READ DATE = '                                       
T18295            WS-READ-DATE                                          
T18295            ' METER NUMBER = '                                    
T18295            WS-METER-NO                                           
T18295     DELIMITED BY SIZE                                            
T18295       INTO WS-COMMENT                                            
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT.    
T18295     MOVE 95                          TO MH-TRAN-COMMENT-LEN.     
      *    MOVE 23                          TO MH-TRAN-COMMENT-LEN.             
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * 5000-UPDATE.                                                            
      *     UPDATE BILLING HEADER AND BILLING DETAIL FOR METER.                 
      *     CHECK FOR HIGH/LOW FAILURE.                                         
      *     UPDATE METER ENVIRONMENT OR REGISTER READ TABLES.                   
      *     INSERT CONSUMPTION HISTORY.                                         
      *     IF METER CANNOT BE READ (READ-TYPE-CODE = N) THEN                   
      *     UPDATE METER OR REGISTER ONLY. DO NOT UPDATE BILLING                
      *     OR CONSUMPTION HISTORY FOR METER THAT IS NOT READ.                  
      ************************************************************              
       5000-UPDATE.                                                     
           MOVE ZERO TO WS-NO-OF-UNITS.                                 
           IF WS-READ-CODE EQUAL WS-NO                                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE AT-ACCOUNT-NO        TO BI-ACCOUNT-NO                
              PERFORM 7230-OPEN-BILLING-HDR THRU 7230-EXIT              
              PERFORM 7231-FETCH-BILLING-HDR THRU 7231-EXIT             
              IF (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                
                OR (IND-DATE-BILLED NOT EQUAL WS-NEG-ONE)               
                  PERFORM 5030-LOAD-DATA-TO-UNBILLED THRU 5030-EXIT     
              END-IF                                                    
              PERFORM 7232-CLOSE-BILLING-HDR THRU 7232-EXIT             
              PERFORM 5050-VERIFY-BILLING-DET THRU 5050-EXIT            
           END-IF.                                                      
           IF WS-MN-PROCESS                                             
              IF WS-READ-CODE EQUAL WS-NO                               
                 MOVE WS-NO-RD-CODE TO MN-CODE-NO-RD-REASON             
                 PERFORM 8845-UPDATE-MTRD-ENVRNMT THRU 8845-EXIT        
                 GO TO 5000-EXIT                                        
              ELSE                                                      
                 PERFORM 5010-PROCESS-MN THRU 5010-EXIT                 
              END-IF                                                    
           ELSE                                                         
              IF WS-READ-CODE EQUAL WS-NO                               
                 MOVE WS-NO-RD-CODE TO RG-CODE-NO-RD-REASON             
                 PERFORM 8843-UPDATE-REGISTER-READ THRU 8843-EXIT       
                 GO TO 5000-EXIT                                        
              ELSE                                                      
                 PERFORM 5020-PROCESS-RG THRU 5020-EXIT                 
              END-IF                                                    
           END-IF.                                                      
       5000-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5010-PROCESS-MN                                                         
      ************************************************************              
       5010-PROCESS-MN.                                                 
T20431     MOVE 'N'              TO  WS-ROLL-FLAG                       
           MOVE MN-LAST-REG-READ-DATE       TO WS-START-DATE.           
           MOVE PARM-READ-DATE              TO MN-LAST-REG-READ-DATE.   
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE WS-MTR-WO-ROLLOVER       TO MN-LAST-READ-VALUE       
           ELSE                                                         
TP5186        IF WS-MN-TOU-FLAG EQUAL WS-YES                            
TP5186           IF WS-REG-PROCESSED-FLAG EQUAL WS-NO                   
TP5186             PERFORM 2220-CHECK-ROLLOVER   THRU 2220-EXIT         
TP5186             IF PARM-OVERRIDE-IND EQUAL WS-NO                     
TP5186               IF WS-MN-KWH NOT EQUAL 0                           
A00795                  MOVE UT-RATE-PLAN-NO     TO CWS72-RATE-PLAN     
A00795                  MOVE UT-CODE-UTIL-TYPE   TO CWS72-UTIL-TYPE     
A00795                  MOVE UT-ACCOUNT-NO       TO CWS72-ACCOUNT-NO    
A00795                  MOVE MN-MTR-REF-NO       TO CWS72-MTR-REF-NO    
A00795                  MOVE WS-CODE-TIME-PERIOD TO CWS72-TIME-PERIOD   
A00795                                           CX-CODE-TIME-PERIOD    
A00795                  MOVE WS-CODE-USAGE-ID    TO CWS72-CODE-USAGE-ID 
A00795                  MOVE UT-IC-NO            TO CWS72-IC-NO         
A00795                  MOVE AT-REV-MTH-LST-NRML                        
A00795                                      TO CWS72-REV-MTH-LST-NRML   
A00795                  SET CWS72-ONLINE-CALL    TO TRUE                
A00795*                                                                         
A00795                  IF CWS72-TIME-PERIOD = WS-HL-CODE-TIME-PERIOD   
A00795                  AND CWS72-CODE-USAGE-ID = WS-HL-CODE-USAGE-ID   
A00795                     CONTINUE                                     
A00795                  ELSE                                            
A00795                     MOVE CWS72-TIME-PERIOD                       
A00795                                      TO WS-HL-CODE-TIME-PERIOD   
A00795                     MOVE CWS72-CODE-USAGE-ID                     
A00795                                      TO WS-HL-CODE-USAGE-ID      
A00795                     PERFORM 6351-CPD72-HI-LO-MAIN                
A00795                        THRU 6351-CPD72-EXIT                      
A00795                     PERFORM 6399-CHECK-HI-LO-ERROR               
A00795                        THRU 6399-EXIT                            
A00795                  END-IF                                          
TP5186               END-IF                                             
A00795               IF WS-CODE-USAGE-TYPE = 'B'                        
A00795                  COMPUTE WS-CRNT-USE  ROUNDED                    
A00795                      = (( WS-MN-KWH                              
A00795                        - MN-LAST-READ-VALUE) * MC-CONSTANT )     
A00795                  IF WS-CRNT-USE < (CWS72-LO-KWH * CX-NO-DAYS)    
T20431                     MOVE WS-CRNT-USE        TO RS-USAGE-UNITS    
T20431                     IF WS-ROLL-FLAG  = 'Y'                       
T20431                        MOVE WS-ERR-MSG-D1019 TO RS-ERROR-CODE    
T20431                     ELSE                                         
                              MOVE WS-ERR-MSG-D0551 TO RS-ERROR-CODE    
T20431                     END-IF                                       
C34424                     MOVE WS-YES          TO WS-ROLLBACK-FLAG     
                           PERFORM 5600-SEND-ERROR THRU 5600-EXIT       
TP5186                  END-IF                                          
A00795                  IF WS-CRNT-USE > (CWS72-HI-KWH * CX-NO-DAYS)    
T20431                     MOVE WS-CRNT-USE      TO RS-USAGE-UNITS      
T20431                     IF WS-ROLL-FLAG  = 'Y'                       
T20431                        MOVE WS-ERR-MSG-D1020   TO RS-ERROR-CODE  
T20431                     ELSE                                         
                              MOVE WS-ERR-MSG-D0552   TO RS-ERROR-CODE  
T20431                     END-IF                                       
C34424                     MOVE WS-YES TO WS-ROLLBACK-FLAG              
                           PERFORM 5600-SEND-ERROR THRU 5600-EXIT       
TP5186                  END-IF                                          
TP5186               END-IF                                             
TP5186             END-IF                                               
TP5186             COMPUTE WS-NO-OF-UNITS ROUNDED EQUAL                 
TP5186                ((WS-MN-KWH -                                     
TP5186                 MN-LAST-READ-VALUE) * MC-CONSTANT)               
TP5186             MOVE WS-MTR-WO-ROLLOVER    TO MN-LAST-READ-VALUE     
TP5186           ELSE                                                   
TP5186              IF PARM-OVERRIDE-IND EQUAL WS-NO                    
TP5186                 IF WS-TOTAL-KWH NOT EQUAL WS-MN-KWH              
C34424                    MOVE WS-YES TO WS-ROLLBACK-FLAG               
TP5186                    MOVE WS-ERR-MSG-D0843 TO RS-ERROR-CODE        
                          PERFORM 5600-SEND-ERROR THRU 5600-EXIT        
TP5186                 END-IF                                           
TP5186              END-IF                                              
TP5186              MOVE WS-MN-KWH          TO MN-LAST-READ-VALUE       
TP5186              MOVE WS-TOTAL-KWH       TO WS-NO-OF-UNITS           
TP5186           END-IF                                                 
TP5186        ELSE                                                      
                 MOVE WS-MN-KWH             TO MN-LAST-READ-VALUE       
                 MOVE WS-TOTAL-KWH          TO WS-NO-OF-UNITS           
              END-IF                                                    
              PERFORM 2235-TOTAL-ROLLOVER  THRU 2235-EXIT               
           END-IF.                                                      
           MOVE MN-CODE-CRNT-REG-READ       TO MN-CODE-LAST-REG-READ.   
           IF WS-READ-CODE EQUAL WS-J OR WS-K                           
              MOVE WS-TIME            TO MN-LAST-VALID-READ-TM          
              MOVE PARM-READ-DATE     TO MN-LAST-VALID-READ-DT          
              MOVE MN-LAST-READ-VALUE TO MN-LAST-VAL-RD-VALUE           
              MOVE WS-READ-CODE       TO MN-CODE-LAST-VALID-RD          
           END-IF                                                       
           IF WS-READ-CODE EQUAL WS-L                                   
              MOVE WS-NO-RD-CODE    TO MN-CODE-NO-RD-REASON             
              ADD +1                TO MN-NO-CONSEC-ESTIMATE            
           ELSE                                                         
T20560        IF WS-READ-CODE EQUAL WS-J OR WS-K OR WS-S OR WS-M        
                 MOVE ZEROES        TO MN-NO-CONSEC-ESTIMATE            
              END-IF                                                    
              MOVE SPACES           TO MN-CODE-NO-RD-REASON             
           END-IF                                                       
      *************************************************************             
      * CHECK FOR KVAR METERS                                                   
      *************************************************************             
           IF WS-CODE-USAGE-TYPE = WS-S                                 
              IF MN-CODE-METER-STATUS EQUAL '0'                         
                 MOVE '1'                   TO MN-CODE-METER-STATUS     
              ELSE                                                      
              IF MN-CODE-METER-STATUS EQUAL '1'                         
A00795           MOVE 'A'                   TO MN-CODE-METER-STATUS     
              END-IF                                                    
           END-IF
           END-IF.                                                      
           PERFORM 8845-UPDATE-MTRD-ENVRNMT THRU 8845-EXIT.             
           IF WS-CODE-USAGE-TYPE = 'J' OR 'E'                           
T14273        COMPUTE WS-NO-OF-UNITS ROUNDED =                          
                (MC-CONSTANT * MN-LAST-READ-VALUE)                      
           END-IF.                                                      
           PERFORM 5070-LOAD-MN-UNITS-TO-CX THRU 5070-EXIT.             
       5010-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5020-PROCESS-RG                                                         
      ************************************************************              
       5020-PROCESS-RG.                                                 
           MOVE RG-LAST-REG-READ-DT         TO WS-START-DATE.           
           MOVE WS-READ-DATE                TO RG-LAST-REG-READ-DT.     
           MOVE RG-CODE-CRNT-REG-READ       TO RG-CODE-LAST-REG-READ.   
           MOVE SPACE                       TO RG-CODE-NO-RD-REASON.    
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE WS-MTR-WO-ROLLOVER       TO RG-LAST-READ-VALUE       
           ELSE                                                         
              COMPUTE WS-NO-OF-UNITS ROUNDED EQUAL                      
                 ((WS-METER-READ-NUM -                                  
                  RG-LAST-READ-VALUE) * MC-CONSTANT)                    
              ADD WS-NO-OF-UNITS            TO WS-TOTAL-KWH             
              MOVE WS-MTR-WO-ROLLOVER       TO RG-LAST-READ-VALUE       
           END-IF.                                                      
           IF WS-READ-CODE EQUAL WS-J OR WS-K                           
              MOVE WS-TIME            TO RG-LAST-VALID-READ-TM          
              MOVE PARM-READ-DATE     TO RG-LAST-VALID-READ-DT          
              MOVE RG-LAST-READ-VALUE TO RG-LAST-VAL-RD-VALUE           
              MOVE WS-READ-CODE       TO RG-CODE-LAST-VALID-RD          
           END-IF                                                       
           IF WS-READ-CODE EQUAL WS-L                                   
              MOVE WS-NO-RD-CODE      TO RG-CODE-NO-RD-REASON           
           ELSE                                                         
           IF WS-CODE-USAGE-TYPE EQUAL WS-S                             
              IF RG-CODE-REG-STATUS EQUAL '0'                           
                 MOVE '1'                   TO RG-CODE-REG-STATUS       
              ELSE                                                      
              IF RG-CODE-REG-STATUS EQUAL '1'                           
A00795           MOVE 'A'                   TO RG-CODE-REG-STATUS       
              END-IF                                                    
           END-IF
           END-IF
           END-IF.                                                      
           PERFORM 8843-UPDATE-REGISTER-READ THRU 8843-EXIT.            
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
T14273        COMPUTE WS-NO-OF-UNITS ROUNDED =                          
                (MC-CONSTANT * RG-LAST-READ-VALUE)
           END-IF.                     
TP5296     MOVE WS-HOLD-SEASON              TO CX-CODE-TOU-SEASN.       
           PERFORM 5071-LOAD-RG-UNITS-TO-CX      THRU 5071-EXIT.        
       5020-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5030-LOAD-DATA-TO-UNBILLED                                              
      ************************************************************              
       5030-LOAD-DATA-TO-UNBILLED.                                      
           MOVE AT-ACCOUNT-NO               TO BI-ACCOUNT-NO.           
           MOVE AT-PREMISE-NO               TO BI-PREMISE-NO.           
           MOVE AT-CUSTOMER-NO              TO BI-CUSTOMER-NO.          
           MOVE AT-COMPANY-NO               TO BI-COMPANY-NO.           
           MOVE AT-NXT-BILL-NO              TO BI-BILL-NO.              
           ADD +1                           TO AT-NXT-BILL-NO.          
           MOVE WS-NEG-ONE                  TO IND-DATE-BILLED.         
A00795     MOVE 'A'                         TO BI-CODE-BILL-STATUS      
                                               BI-CODE-BILL-TYPE        
                                               BI-CODE-BILL-REASON.     
           MOVE SPACES                      TO BI-CODE-SPCL-BILL.       
           PERFORM 8860-ISRT-BILLING-HDR    THRU 8860-EXIT.             
           PERFORM 8001-UPDATE-ACCOUNT      THRU 8001-EXIT.             
       5030-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5050-VERIFY-BILLING-DET                                                 
      ************************************************************              
       5050-VERIFY-BILLING-DET.                                         
           MOVE BI-ACCOUNT-NO               TO BG-ACCOUNT-NO.           
           MOVE BI-PREMISE-NO               TO BG-PREMISE-NO.           
           MOVE BI-BILL-NO                  TO BG-BILL-NO.              
           MOVE UT-CODE-UTIL-TYPE           TO BG-CODE-UTIL-TYPE.       
           MOVE UT-IC-NO                    TO BG-IC-NO.                
A00795     MOVE 'C'                         TO BG-CODE-BILL-ITM-TYPE.   
           MOVE UT-RATE-PLAN-NO             TO BG-RATE-PLAN-NO.         
           MOVE UT-CODE-REVENUE-CLASS       TO BG-CODE-REVENUE-CLASS.   
           PERFORM 7250-OPEN-BILLING-DET-CUR2 THRU 7250-EXIT.           
           PERFORM 7251-FETCH-BILLING-DET-CUR2 THRU 7251-EXIT.          
A00795     MOVE 'A'                         TO BG-CODE-BILL-ITM-IND     
                                               BG-CODE-BILL-CALC.       
           MOVE 'D'                         TO BG-CODE-DR-CR-CNSMPTN.   
           MOVE UT-RATE-PLAN-NO             TO BG-RATE-PLAN-NO.         
           MOVE UT-CODE-REVENUE-CLASS       TO BG-CODE-REVENUE-CLASS.   
           MOVE UT-CODE-SIC-NO              TO BG-CODE-SIC-NO.          
           MOVE UT-CODE-CURTAIL-PRTY        TO BG-CODE-CURTAIL-PRTY.    
           MOVE WS-NEG-ONE                  TO IND-DATE-ORIG-BILL.      
ACT245     MOVE UT-GAS-BASE-USE             TO BG-GAS-BASE-USE.         
           MOVE ZEROS                       TO BG-AMT-BILL-ITEM         
                                               BG-AMT-STATE-TAX         
                                               BG-AMT-CITY-TAX          
                                               BG-AMT-OTHER-TAX.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 8864-UPDATE-BILLING-DET THRU 8864-EXIT            
           ELSE                                                         
              MOVE BG-PREMISE-NO            TO PR-PREMISE-NO            
              PERFORM 7000-SELECT-PREMISE   THRU 7000-EXIT              
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE WS-TIMESTMP-FROM-DB2-CALL                         
                                            TO BG-BILL-ITEM-TIMESTMP    
T17429           MOVE PR-REV-DISTRICT-CD    TO BG-REV-DISTRICT-CD       
T23951           MOVE PR-COMPANY-NO         TO BG-COMPANY-NO            
T21807           MOVE ZEROES                TO BG-REV-MTH-ORIG-BILL     
                 PERFORM 8862-INSERT-BILLING-DET THRU 8862-EXIT         
              ELSE                                                      
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '5050'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_ACCOUNT'         TO TABLE-1                  
                 MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1          
                 MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7252-CLOSE-BILLING-DET-CUR2 THRU 7252-EXIT.          
       5050-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5070-LOAD-MN-UNITS-TO-CX                                                
      ************************************************************              
       5070-LOAD-MN-UNITS-TO-CX.                                        
           MOVE BG-ACCOUNT-NO               TO CX-ACCOUNT-NO.           
           MOVE BG-BILL-NO                  TO CX-BILL-NO.              
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO CX-IC-NO.                
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP.   
           MOVE MN-CODE-TIME-PERIOD         TO CX-CODE-TIME-PERIOD.     
           MOVE MN-MTR-REF-NO               TO CX-MTR-REF-NO.           
           MOVE MN-CODE-USAGE-TYPE          TO CX-CODE-USAGE-TYPE.      
           MOVE MN-CODE-USAGE-ID            TO CX-CODE-USAGE-ID.        
           MOVE MN-CODE-USAGE-SOURCE        TO CX-CODE-USAGE-SOURCE.    
           MOVE MN-METER-NO                 TO CX-METER-NO.             
           MOVE MN-REG-ID-NO                TO CX-REG-ID-NO.            
           MOVE MN-LAST-REG-READ-DATE       TO CX-DATE-READ.            
           MOVE MN-CODE-CRNT-REG-READ       TO CX-CODE-METER-READ.      
           MOVE MN-CODE-NO-RD-REASON        TO CX-CODE-METER-NO-READ.   
           MOVE AT-COMPANY-NO               TO CX-COMPANY-NO.           
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE WS-DEM-WITHOUT-CONST     TO CX-DEMAND-READING        
              MOVE ZEROES                   TO CX-METER-READING         
           ELSE                                                         
              MOVE MN-LAST-READ-VALUE       TO CX-METER-READING         
              MOVE ZEROES                   TO CX-DEMAND-READING        
           END-IF.                                                      
           MOVE PARM-READER-ID              TO CX-EMPLOYEE-NO.          
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE ZEROES                   TO CX-NO-UNITS              
T14273        MOVE WS-NO-OF-UNITS           TO CX-NO-DEMAND-UNITS       
           ELSE                                                         
              MOVE WS-NO-OF-UNITS           TO CX-NO-UNITS              
              MOVE ZEROES                   TO CX-NO-DEMAND-UNITS       
           END-IF.                                                      
           MOVE MN-DIGTL-MTR-TYPE           TO CX-DIGTL-MTR-TYPE.       
           MOVE ZERO                        TO CX-DEMAND-READING.       
T32303     IF WS-NO-OF-DAYS EQUAL ZERO                                  
T32303        MOVE MN-LAST-REG-READ-DATE       TO WS-END-DATE           
T32303        PERFORM 5090-CALCULATE-NO-OF-DAYS THRU 5090-EXIT          
T32303     END-IF                                                       
           MOVE WS-NO-OF-DAYS               TO CX-NO-DAYS.              
T19082*    MOVE WS-B                        TO CX-CODE-SOURCE-ID.               
A00795     MOVE 'C'                         TO CX-CODE-SOURCE-ID.       
           IF MN-CODE-USAGE-SOURCE EQUAL WS-J                           
P00251      OR WS-MN-CODE-USAGE-ID EQUAL WS-F                           
A00795        MOVE 'C'                      TO CX-CODE-DEBIT-CREDIT     
           ELSE                                                         
              MOVE WS-D                     TO CX-CODE-DEBIT-CREDIT
           END-IF.    
           MOVE MN-CODE-METER-STATUS        TO CX-CODE-ITEM-STATUS.     
           MOVE MN-CODE-DISCOUNT            TO CX-CODE-DISCOUNT.        
           MOVE MC-CONSTANT                 TO CX-CONSTANT.             
           MOVE MC-NO-READ-DIALS            TO CX-NO-DIALS.             
           IF WS-READ-CODE = 'S'                                        
              MOVE 'C'                      TO CX-MTR-READ-SOURCE-CD    
           ELSE                                                         
              MOVE 'B'                      TO CX-MTR-READ-SOURCE-CD    
           END-IF                                                       
TP5186     IF WS-MN-TOU-FLAG EQUAL WS-YES                               
TP5186            AND WS-REG-PROCESSED-FLAG EQUAL WS-NO                 
A00795        MOVE 'C'                      TO CX-CODE-TOU-SEASN        
TP5186     ELSE                                                         
TP5186        MOVE SPACES                   TO CX-CODE-TOU-SEASN        
TP5186     END-IF.                                                      
           PERFORM 7515-SELECT-MAX-CNSMPTN-HIST THRU 7515-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE +0001                    TO CX-ITEM-SEQ-NO           
           ELSE                                                         
              ADD  +0001                    TO CX-ITEM-SEQ-NO
           END-IF.          
           PERFORM 8870-ISRT-CNSMPTN-HIST   THRU 8870-EXIT.             
       5070-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * 5071-LOAD-RG-UNITS-TO-CX                                                
      ************************************************************              
       5071-LOAD-RG-UNITS-TO-CX.                                        
           MOVE BG-ACCOUNT-NO               TO CX-ACCOUNT-NO.           
           MOVE BG-BILL-NO                  TO CX-BILL-NO.              
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO CX-IC-NO.                
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP.   
           MOVE RG-CODE-TIME-PERIOD         TO CX-CODE-TIME-PERIOD.     
           MOVE RG-MTR-REF-NO               TO CX-MTR-REF-NO.           
           MOVE RG-CODE-USAGE-TYPE          TO CX-CODE-USAGE-TYPE.      
           MOVE RG-CODE-USAGE-ID            TO CX-CODE-USAGE-ID.        
           MOVE RG-CODE-USAGE-SOURCE        TO CX-CODE-USAGE-SOURCE.    
           MOVE RG-METER-NO                 TO CX-METER-NO.             
           MOVE RG-REG-ID-NO                TO CX-REG-ID-NO.            
           MOVE RG-LAST-REG-READ-DT         TO CX-DATE-READ.            
           MOVE RG-CODE-CRNT-REG-READ       TO CX-CODE-METER-READ.      
           MOVE RG-CODE-NO-RD-REASON        TO CX-CODE-METER-NO-READ.   
           MOVE AT-COMPANY-NO               TO CX-COMPANY-NO.           
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE ZEROES               TO CX-METER-READING             
              MOVE RG-LAST-READ-VALUE   TO CX-DEMAND-READING            
           ELSE                                                         
              MOVE ZEROES             TO CX-DEMAND-READING              
              MOVE RG-LAST-READ-VALUE TO CX-METER-READING               
           END-IF.                                                      
           MOVE PARM-READER-ID              TO CX-EMPLOYEE-NO.          
           IF WS-CODE-USAGE-TYPE EQUAL WS-J OR WS-E                     
              MOVE ZEROES                   TO CX-NO-UNITS              
T14273        MOVE WS-NO-OF-UNITS           TO CX-NO-DEMAND-UNITS       
           ELSE                                                         
              MOVE WS-NO-OF-UNITS           TO CX-NO-UNITS              
              MOVE ZEROES                   TO CX-NO-DEMAND-UNITS       
           END-IF.                                                      
           MOVE MN-DIGTL-MTR-TYPE           TO CX-DIGTL-MTR-TYPE.       
           IF WS-NO-OF-DAYS EQUAL ZERO                                  
              MOVE RG-LAST-REG-READ-DT         TO WS-END-DATE           
              PERFORM 5090-CALCULATE-NO-OF-DAYS THRU 5090-EXIT          
           END-IF                                                       
           MOVE WS-NO-OF-DAYS               TO CX-NO-DAYS.              
T19082*    MOVE WS-B                        TO CX-CODE-SOURCE-ID.               
A00795     MOVE 'C'                         TO CX-CODE-SOURCE-ID.       
P00251     IF WS-CODE-USAGE-ID EQUAL WS-F                               
P00251        MOVE WS-C                     TO CX-CODE-DEBIT-CREDIT     
P00251     ELSE                                                         
P00251        MOVE WS-D                     TO CX-CODE-DEBIT-CREDIT     
P00251     END-IF.                                                      
           MOVE RG-CODE-REG-STATUS          TO CX-CODE-ITEM-STATUS.     
A00795     MOVE 'A'                         TO CX-CODE-DISCOUNT.        
           MOVE MC-CONSTANT                 TO CX-CONSTANT.             
           MOVE MC-NO-READ-DIALS            TO CX-NO-DIALS.             
           IF WS-READ-CODE = 'S'                                        
              MOVE 'C'                      TO CX-MTR-READ-SOURCE-CD    
           ELSE                                                         
              MOVE 'B'                      TO CX-MTR-READ-SOURCE-CD    
           END-IF                                                       
           PERFORM 7515-SELECT-MAX-CNSMPTN-HIST THRU 7515-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE +0001                    TO CX-ITEM-SEQ-NO           
           ELSE                                                         
              ADD  +0001                    TO CX-ITEM-SEQ-NO
           END-IF.          
           PERFORM 8870-ISRT-CNSMPTN-HIST   THRU 8870-EXIT.             
       5071-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 5090-CALCULATE-NO-OF-DAYS                                               
      ************************************************************              
       5090-CALCULATE-NO-OF-DAYS.                                       
           MOVE WS-START-DATE               TO WS-DATE-NUM.             
           COMPUTE WS-START-DAYS =                                      
              ((WS-DATE-NUM-YYYY - 1) * 365) + (WS-DATE-NUM-YYYY * .25) 
                 + WS-DAYS (WS-DATE-NUM-MM) + WS-DATE-NUM-DD .          
           DIVIDE WS-DATE-NUM-YYYY BY 4                                 
ACT189         GIVING WS-TALLY                                          
               REMAINDER WS-DAYS-REMAINDER.                             
           IF WS-DAYS-REMAINDER EQUAL ZERO                              
              IF WS-DATE-NUM-MM LESS THAN 3                             
                 SUBTRACT 1 FROM WS-START-DAYS
              END-IF
           END-IF.                         
           MOVE WS-END-DATE                 TO WS-DATE-NUM.             
           COMPUTE WS-END-DAYS =                                        
              ((WS-DATE-NUM-YYYY - 1) * 365) + (WS-DATE-NUM-YYYY * .25) 
                 + WS-DAYS (WS-DATE-NUM-MM) + WS-DATE-NUM-DD.           
           DIVIDE WS-DATE-NUM-YYYY BY 4                                 
ACT189         GIVING WS-TALLY                                          
               REMAINDER WS-DAYS-REMAINDER.                             
           IF WS-DAYS-REMAINDER EQUAL ZERO                              
              IF WS-DATE-NUM-MM LESS THAN 3                             
                 SUBTRACT 1 FROM WS-END-DAYS
              END-IF
           END-IF.                           
           SUBTRACT WS-START-DAYS FROM WS-END-DAYS                      
                 GIVING WS-NO-OF-DAYS.                                  
       5090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5400-GET-OLD-ACCOUNT.                                            
           MOVE AT-ACCOUNT-NO TO XR-OLD-ACCOUNT-NO.                     
           PERFORM 7810-GET-XREF-ACCOUNT THRU 7810-EXIT                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE XR-NEW-ACCOUNT-NO TO AT-ACCOUNT-NO                   
              PERFORM 7010-SELECT-ACCOUNT THRU 7010-EXIT                
           END-IF.                                                      
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5410-UPDATE-BILLING-INFO.                                        
           PERFORM 7200-OPEN-UTIL-ENVRNMT THRU 7200-EXIT.               
           PERFORM 7210-FETCH-UTIL-ENVRNMT THRU 7210-EXIT.              
           PERFORM 5425-CHECK-MTR-POSTING THRU 5425-EXIT                
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                OR EXISTS-NO.                                           
           PERFORM 7220-CLOSE-UTIL-ENVRNMT THRU 7220-EXIT.              
           IF EXISTS-NO                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
PCR671        IF AT-CODE-ACCT-BILLED EQUAL WS-HOLD-NO-READING           
PCR671           CONTINUE                                               
PCR671        ELSE                                                      
                 MOVE 'R'                     TO AT-CODE-ACCT-BILLED    
                 PERFORM 8887-UPDATE-CODE-BILLED THRU 8887-EXIT         
PCR671        END-IF                                                    
           END-IF.                                                      
       5410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5425-CHECK-MTR-POSTING.                                          
           MOVE UT-ACCOUNT-NO          TO BG-ACCOUNT-NO.                
           MOVE UT-CODE-UTIL-TYPE      TO BG-CODE-UTIL-TYPE.            
           MOVE UT-IC-NO               TO BG-IC-NO.                     
           PERFORM 7250-OPEN-BILLING-DET-CUR2 THRU 7250-EXIT.           
           PERFORM 7251-FETCH-BILLING-DET-CUR2 THRU 7251-EXIT.          
           PERFORM 7252-CLOSE-BILLING-DET-CUR2 THRU 7252-EXIT.          
           MOVE UT-ACCOUNT-NO          TO MN-ACCOUNT-NO.                
           MOVE UT-CODE-UTIL-TYPE      TO MN-CODE-UTIL-TYPE.            
           MOVE UT-IC-NO               TO MN-IC-NO.                     
           PERFORM 7400-OPEN-MTR-READ THRU 7400-EXIT.                   
           PERFORM 7410-FETCH-MTR-READ THRU 7410-EXIT.                  
           PERFORM 5450-UPDATE-ACCT-BILLED THRU 5450-EXIT               
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                OR EXISTS-NO.                                           
           PERFORM 7420-CLOSE-MTR-READ THRU 7420-EXIT.                  
           PERFORM 7210-FETCH-UTIL-ENVRNMT THRU 7210-EXIT.              
       5425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5450-UPDATE-ACCT-BILLED.                                         
           IF MN-CODE-CRNT-REG-READ = 'D' OR 'K'                        
              SET EXISTS-NO TO TRUE                                     
              GO TO 5450-EXIT                                           
           END-IF.                                                      
           MOVE MN-REG-ID-NO           TO CX-REG-ID-NO.                 
           MOVE MN-ACCOUNT-NO          TO CX-ACCOUNT-NO.                
           MOVE MN-CODE-UTIL-TYPE      TO CX-CODE-UTIL-TYPE.            
           MOVE MN-IC-NO               TO CX-IC-NO.                     
           MOVE BG-BILL-NO             TO CX-BILL-NO.                   
           MOVE BG-BILL-ITEM-TIMESTMP  TO CX-BILL-ITEM-TIMESTMP.        
           MOVE MN-METER-NO            TO CX-METER-NO.                  
           PERFORM 7300-OPEN-CNSMPTN-HIST THRU 7300-EXIT.               
           PERFORM 7310-FETCH-CNSMPTN-HIST THRU 7310-EXIT.              
           PERFORM 7320-CLOSE-CNSMPTN-HIST THRU 7320-EXIT.              
           IF EXISTS-NO                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MN-ACCOUNT-NO       TO RG-ACCOUNT-NO                 
              MOVE MN-CODE-UTIL-TYPE   TO RG-CODE-UTIL-TYPE             
              MOVE MN-IC-NO            TO RG-IC-NO                      
              MOVE MN-MTR-REF-NO       TO RG-MTR-REF-NO                 
              PERFORM 7350-OPEN-REG-READ THRU 7350-EXIT                 
              PERFORM 7360-FETCH-REG-READ THRU 7360-EXIT                
              PERFORM 5500-CHECK-CNSMPTN THRU 5500-EXIT                 
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
                   OR EXISTS-NO                                         
              PERFORM 7370-CLOSE-REG-READ THRU 7370-EXIT                
           END-IF.                                                      
           PERFORM 7410-FETCH-MTR-READ THRU 7410-EXIT.                  
       5450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5500-CHECK-CNSMPTN.                                              
           IF RG-CODE-CRNT-REG-READ = 'D' OR 'K'                        
              SET EXISTS-NO TO TRUE                                     
              GO TO 5500-EXIT                                           
           END-IF.                                                      
           MOVE RG-REG-ID-NO           TO CX-REG-ID-NO.                 
           PERFORM 7300-OPEN-CNSMPTN-HIST THRU 7300-EXIT.               
           PERFORM 7310-FETCH-CNSMPTN-HIST THRU 7310-EXIT.              
           PERFORM 7320-CLOSE-CNSMPTN-HIST THRU 7320-EXIT.              
           PERFORM 7360-FETCH-REG-READ THRU 7360-EXIT.                  
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP5186 5600-SEND-ERROR.                                                 
TP5186     MOVE 0 TO RS-RETURN-CODE.                                    
C34424     IF WS-ROLLBACK-FLAG = WS-YES                                 
C34424        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C34424     END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
TP5186     PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
TP5186     PERFORM 8900-SEND-DONE    THRU 8900-EXIT                     
TP5186     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
TP5186 5600-EXIT.                                                       
TP5186     EXIT.                                                        
      *                                                                         
T21677****************************************************************          
T21677**                                                            **          
T21677**  6260-GET-REVENUE-MONTH                                    **          
T21677**                                                            **          
T21677****************************************************************          
T21677 6260-GET-REVENUE-MONTH.                                          
T21677*                                                                         
A00795     MOVE SPACES                   TO WS-SYSIPT                   
A00795     MOVE 'COMMON'                 TO WS-PROGRAM                  
A00795     MOVE WS-DATE                  TO WS-COMMAND                  
A00795     MOVE ZEROS                    TO WS-SEQUENCE                 
A00795     MOVE WS-KEY-AREA              TO E-FJC01-KEY                 
A00795*                                                                         
A00795     PERFORM 7600-START-FCSJC01    THRU  7600-EXIT                
A00795*                                                                         
A00795     PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT                
A00795        UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                    
A00795              OR END-OF-SYSIPT                                    
A00795*                                                                         
A00795     IF REVENUE-MONTH AND INPUT-ACTIVE                            
A00795        MOVE WS-REVENUE-MONTH-PARM TO WS-REV-MONTH1               
A00795        PERFORM 7611-CLOSE         THRU  7611-EXIT                
A00795     ELSE                                                         
T21677        MOVE SPACES               TO ABEND-TABLES                 
T21677        MOVE SPACES               TO ABEND-SQL-PREDICATES         
T21677        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21677        MOVE '6260'               TO ACTIVE-PARAGRAPH             
T21677        MOVE 'SELECT'             TO ABEND-FUNCTION               
T21677        MOVE 'CSS_JOB_PARM'       TO TABLE-1                      
T21677        MOVE 'PROGRAM_NAME'       TO TABLE-ELEMENT-1              
T21677        MOVE 'CMND_CODE'          TO TABLE-ELEMENT-2              
T21677        MOVE 'STATUS'             TO TABLE-ELEMENT-3              
T21677        MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4              
T21677        MOVE 'COMMON'             TO HOSTVAR-ELEMENT-1            
T21677        MOVE 'DATE'               TO HOSTVAR-ELEMENT-2            
A00795        MOVE 'A'                  TO HOSTVAR-ELEMENT-3            
T21677        MOVE G6-COMPANY-NO        TO HOSTVAR-ELEMENT-4            
T21677        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T21677        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T21677     END-IF.                                                      
T21677*                                                                         
T21677 6260-EXIT.                                                       
T21677     EXIT.                                                        
T21677*                                                                         
A00795*                                                                         
A00795******************************************************************05050000
A00795* 6351-CPD72-HI-LO-MAIN                                          *05060003
A00795******************************************************************05070000
A00795     EXEC SQL                                                     02000000
A00795         INCLUDE CPDCA072                                                 
A00795     END-EXEC.                                                            
A00795                                                                  
A00795                                                                  
A00795*================================================================*05050000
A00795 6399-CHECK-HI-LO-ERROR.                                          
A00795*================================================================*05050000
A00795*                                                                 05070000
A00795     IF CWS72-WARNING                                             
A00795        MOVE WS-ERR-MSG-D0535        TO RS-ERROR-CODE             
A00795        PERFORM 5600-SEND-ERROR THRU 5600-EXIT                    
A00795     END-IF.                                                      
A00795     IF CWS72-ERROR                                               
A00795        MOVE CWS72-ERROR-SQLCODE     TO WS-ACTIVE-RETURN-CODE     
A00795        MOVE 'CPDCA072'              TO ABEND-PROGRAM             
A00795        MOVE CWS72-ERROR-PARAGRAPH-NO TO ACTIVE-PARAGRAPH         
A00795        MOVE CWS72-ERROR-FUNCTION    TO ABEND-FUNCTION            
A00795        MOVE CWS72-ERROR-TABLE1      TO TABLE-1                   
A00795        MOVE CWS72-ERROR-TABLE2      TO TABLE-2                   
A00795        MOVE CWS72-ERROR-TAB-COLUMN-1 TO TABLE-ELEMENT-1          
A00795        MOVE CWS72-ERROR-TAB-COLUMN-2 TO TABLE-ELEMENT-2          
A00795        MOVE CWS72-ERROR-TAB-COLUMN-3 TO TABLE-ELEMENT-3          
A00795        MOVE CWS72-ERROR-TAB-COLUMN-4 TO TABLE-ELEMENT-4          
A00795        MOVE CWS72-ERROR-HOSTVAR-1   TO HOSTVAR-ELEMENT-1         
A00795        MOVE CWS72-ERROR-HOSTVAR-2   TO HOSTVAR-ELEMENT-2         
A00795        MOVE CWS72-ERROR-HOSTVAR-3   TO HOSTVAR-ELEMENT-3         
A00795        MOVE CWS72-ERROR-HOSTVAR-4   TO HOSTVAR-ELEMENT-4         
A00795        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00795        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00795     END-IF.                                                      
A00795*                                                                 05070000
A00795 6399-EXIT.                                                       
A00795     EXIT.                                                        
A00795*                                                                 05330000
PCR672****************************************************************          
      **                                                            **          
      **  6540-INSERT-MNT-TRANS-HIST                                **          
      **                                                            **          
      ****************************************************************          
       6540-INSERT-MNT-TRANS-HIST.                                      
      *                                                                         
           MOVE '6540' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                               
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                             
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                               
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                          
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,                       
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,                     
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                       
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,                  
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE '6540'         TO ACTIVE-PARAGRAPH                   
              MOVE 'INSERT'       TO ABEND-FUNCTION                     
CBSI          MOVE SPACES         TO ABEND-SQL-PREDICATES               
CBSI                                 ABEND-TABLES                       
              MOVE 'CSS_MNT_TRANS_HIST'                                 
                                  TO TABLE-1                            
CBSI          MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
CBSI          MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-2                    
CBSI          MOVE 'PREMISE_NO'   TO TABLE-ELEMENT-3                    
CBSI          MOVE 'DATE_TRANS'   TO TABLE-ELEMENT-4                    
              MOVE MH-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              MOVE MH-CUSTOMER-NO TO HOSTVAR-ELEMENT-2                  
              MOVE MH-PREMISE-NO  TO HOSTVAR-ELEMENT-3                  
              MOVE MH-DATE-TRANS  TO HOSTVAR-ELEMENT-4                  
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
      *                                                                         
       6540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7000-SELECT-PREMISE.                                             
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     PREMISE_NO,                                        
                     PREM_ACCT_SEQ_NO,                                  
T17429               REV_DISTRICT_CD,                                   
T23951               COMPANY_NO,                                        
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :PR-LOCAL-OFFICE,                                  
                     :PR-PREMISE-NO,                                    
                     :PR-PREM-ACCT-SEQ-NO,                              
T17429               :PR-REV-DISTRICT-CD,                               
T23951               :PR-COMPANY-NO,                                    
                     :WS-TIMESTMP-FROM-DB2-CALL                         
                FROM CSS_PREMISE                                        
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              PREM_ACCT_SEQ_NO,                                          
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              CURRENT TIMESTAMP                                          
MFA-TR*         INTO :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-PREMISE-NO,                                            
MFA-TR*              :PR-PREM-ACCT-SEQ-NO,                                      
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :PR-COMPANY-NO,                                            
MFA-TR*              :WS-TIMESTMP-FROM-DB2-CALL                                 
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SPACES               TO ABEND-TABLES                
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7000'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_PREMISE'        TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
               MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7010-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
                     CODE_COMPANY_ACCT,                                 
                     CODE_ACCT_BILLED,                                  
                     CODE_ACCT_STAT,                                    
                     LOCAL_OFFICE,                                      
                     COMPANY_NO,                                        
                     NXT_BILL_NO,                                       
                     LAST_NRML_BILL_NO,                                 
T17934               REV_MTH_LST_NRML                                   
                INTO :AT-PREMISE-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-CODE-COMPANY-ACCT,                             
                     :AT-CODE-ACCT-BILLED,                              
                     :AT-CODE-ACCT-STAT,                                
                     :AT-LOCAL-OFFICE,                                  
                     :AT-COMPANY-NO,                                    
                     :AT-NXT-BILL-NO,                                   
                     :AT-LAST-NRML-BILL-NO,                             
T17934               :AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7010'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-SELECT-MTRD-ENVRNMT.                                        
           EXEC SQL                                                     
              SELECT MTR_REF_NO,                                        
                     CODE_TIME_PERIOD,                                  
                     METER_NO,                                          
                     IC_NO,                                             
                     CODE_METER_STATUS,                                 
                     DIGTL_MTR_TYPE,                                    
                     EST_USAGE,                                         
                     SPCL_MTR_CONDITION,                                
                     CODE_USAGE_TYPE,                                   
                     CODE_USAGE_ID,                                     
                     CODE_USAGE_SOURCE,                                 
                     REG_ID_NO,                                         
                     CODE_CRNT_REG_READ,                                
                     CODE_LAST_REG_READ,                                
                     LAST_REG_READ_DATE,                                
                     REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME, 108), 
           ':', '.') LAST_REG_READ_TIME,                                
                     LAST_READ_VALUE,                                   
                     NO_CONSEC_ESTIMATE,                                
                     NO_CONSEC_CRD_READ,                                
                     CODE_DISCOUNT,                                     
                     LAST_VALID_READ_DT,                                
                     REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM,                                
                     LAST_VAL_RD_VALUE,                                 
                     IDR_RECIPIENT_CD,                                  
                     REMOTE_READ_IND,                                   
                     CODE_LAST_VALID_RD                                 
                INTO :MN-MTR-REF-NO,                                    
                     :MN-CODE-TIME-PERIOD,                              
                     :MN-METER-NO,                                      
                     :MN-IC-NO,                                         
                     :MN-CODE-METER-STATUS,                             
                     :MN-DIGTL-MTR-TYPE,                                
                     :MN-EST-USAGE,                                     
                     :MN-SPCL-MTR-CONDITION,                            
                     :MN-CODE-USAGE-TYPE,                               
                     :MN-CODE-USAGE-ID,                                 
                     :MN-CODE-USAGE-SOURCE,                             
                     :MN-REG-ID-NO,                                     
                     :MN-CODE-CRNT-REG-READ,                            
                     :MN-CODE-LAST-REG-READ,                            
                     :MN-LAST-REG-READ-DATE :WS-NULL-1,                 
                     :MN-LAST-REG-READ-TIME :WS-NULL-2,                 
                     :MN-LAST-READ-VALUE,                               
                     :MN-NO-CONSEC-ESTIMATE,                            
                     :MN-NO-CONSEC-CRD-READ,                            
                     :MN-CODE-DISCOUNT,                                 
                     :MN-LAST-VALID-READ-DT :WS-NULL-3,                 
                     :MN-LAST-VALID-READ-TM :WS-NULL-4,                 
                     :MN-LAST-VAL-RD-VALUE,                             
                     :MN-IDR-RECIPIENT-CD,                              
                     :MN-REMOTE-READ-IND,                               
                     :MN-CODE-LAST-VALID-RD                             
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO        = :MN-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE             
                 AND METER_NO          = :MN-METER-NO                   
ACT089           AND CODE_METER_STATUS IN ('A', 'B', 'I')               
PRJ251                                                           
PRJ251                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_REF_NO,                                                
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              METER_NO,                                                  
MFA-TR*              IC_NO,                                                     
MFA-TR*              CODE_METER_STATUS,                                         
MFA-TR*              DIGTL_MTR_TYPE,                                            
MFA-TR*              EST_USAGE,                                                 
MFA-TR*              SPCL_MTR_CONDITION,                                        
MFA-TR*              CODE_USAGE_TYPE,                                           
MFA-TR*              CODE_USAGE_ID,                                             
MFA-TR*              CODE_USAGE_SOURCE,                                         
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_CRNT_REG_READ,                                        
MFA-TR*              CODE_LAST_REG_READ,                                        
MFA-TR*              LAST_REG_READ_DATE,                                        
MFA-TR*              LAST_REG_READ_TIME,                                        
MFA-TR*              LAST_READ_VALUE,                                           
MFA-TR*              NO_CONSEC_ESTIMATE,                                        
MFA-TR*              NO_CONSEC_CRD_READ,                                        
MFA-TR*              CODE_DISCOUNT,                                             
MFA-TR*              LAST_VALID_READ_DT,                                        
MFA-TR*              LAST_VALID_READ_TM,                                        
MFA-TR*              LAST_VAL_RD_VALUE,                                         
MFA-TR*              IDR_RECIPIENT_CD,                                          
MFA-TR*              REMOTE_READ_IND,                                           
MFA-TR*              CODE_LAST_VALID_RD                                         
MFA-TR*         INTO :MN-MTR-REF-NO,                                            
MFA-TR*              :MN-CODE-TIME-PERIOD,                                      
MFA-TR*              :MN-METER-NO,                                              
MFA-TR*              :MN-IC-NO,                                                 
MFA-TR*              :MN-CODE-METER-STATUS,                                     
MFA-TR*              :MN-DIGTL-MTR-TYPE,                                        
MFA-TR*              :MN-EST-USAGE,                                             
MFA-TR*              :MN-SPCL-MTR-CONDITION,                                    
MFA-TR*              :MN-CODE-USAGE-TYPE,                                       
MFA-TR*              :MN-CODE-USAGE-ID,                                         
MFA-TR*              :MN-CODE-USAGE-SOURCE,                                     
MFA-TR*              :MN-REG-ID-NO,                                             
MFA-TR*              :MN-CODE-CRNT-REG-READ,                                    
MFA-TR*              :MN-CODE-LAST-REG-READ,                                    
MFA-TR*              :MN-LAST-REG-READ-DATE :WS-NULL-1,                         
MFA-TR*              :MN-LAST-REG-READ-TIME :WS-NULL-2,                         
MFA-TR*              :MN-LAST-READ-VALUE,                                       
MFA-TR*              :MN-NO-CONSEC-ESTIMATE,                                    
MFA-TR*              :MN-NO-CONSEC-CRD-READ,                                    
MFA-TR*              :MN-CODE-DISCOUNT,                                         
MFA-TR*              :MN-LAST-VALID-READ-DT :WS-NULL-3,                         
MFA-TR*              :MN-LAST-VALID-READ-TM :WS-NULL-4,                         
MFA-TR*              :MN-LAST-VAL-RD-VALUE,                                     
MFA-TR*              :MN-IDR-RECIPIENT-CD,                                      
MFA-TR*              :MN-REMOTE-READ-IND,                                       
MFA-TR*              :MN-CODE-LAST-VALID-RD                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO        = :MN-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                     
MFA-TR*          AND METER_NO          = :MN-METER-NO                           
MFA-TR*          AND CODE_METER_STATUS IN ('A', 'B', 'I')                       
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-1 < ZERO                                       
                 MOVE LOW-VALUES TO MN-LAST-REG-READ-DATE               
              END-IF                                                    
              IF WS-NULL-2 < ZERO                                       
                 MOVE LOW-VALUES TO MN-LAST-REG-READ-TIME               
              END-IF                                                    
              IF WS-NULL-3 < ZERO                                       
                 MOVE LOW-VALUES TO MN-LAST-VALID-READ-DT               
              END-IF                                                    
              IF WS-NULL-4 < ZERO                                       
                 MOVE LOW-VALUES TO MN-LAST-VALID-READ-TM               
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7020'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'METER_NO'          TO TABLE-ELEMENT-3               
              MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE MN-METER-NO         TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7030-SELECT-UTIL-ENVRNMT.                                        
           EXEC SQL                                                     
              SELECT CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     CODE_REVENUE_CLASS,                                
                     CODE_ESTIMATE_OK,                                  
                     RATE_PLAN_NO,                                      
                     CODE_SIC_NO,                                       
                     CODE_MTR_READ_FREQ,                                
                     CODE_CURTAIL_PRTY,                                 
                     DATE_LST_NRML_BILL                                 
ACT245             , GAS_BASE_USE                                       
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-IC-NO,                                         
                     :UT-CODE-REVENUE-CLASS,                            
                     :UT-CODE-ESTIMATE-OK,                              
                     :UT-RATE-PLAN-NO,                                  
                     :UT-CODE-SIC-NO,                                   
                     :UT-CODE-MTR-READ-FREQ,                            
                     :UT-CODE-CURTAIL-PRTY,                             
                     :UT-DATE-LST-NRML-BILL :WS-NULL-5                   
ACT245              ,:UT-GAS-BASE-USE                                   
                FROM CSS_UTIL_ENVRNMT                                   
               WHERE ACCOUNT_NO        = :UT-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE             
                 AND IC_NO             = :UT-IC-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-5 < ZERO                                       
                 MOVE LOW-VALUES       TO UT-DATE-LST-NRML-BILL         
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7030'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE UT-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7040-SELECT-REGISTER-READ.                                       
           EXEC SQL                                                     
              SELECT CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     MTR_REF_NO,                                        
                     REG_ID_NO,                                         
                     METER_NO,                                          
                     CODE_USAGE_TYPE,                                   
                     CODE_USAGE_ID,                                     
                     CODE_USAGE_SOURCE,                                 
                     CODE_TIME_PERIOD,                                  
                     CODE_REG_STATUS,                                   
                     CODE_STATUS_REAS,                                  
                     CODE_LAST_REG_READ,                                
                     LAST_REG_READ_DT,                                  
                     LAST_READ_VALUE,                                   
                     CODE_CRNT_REG_READ,                                
                     CODE_NO_RD_REASON,                                 
                     REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM,                                  
                     CODE_LAST_VALID_RD,                                
                     LAST_VALID_READ_DT,                                
                     REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM,                                
                     LAST_VAL_RD_VALUE,                                 
                     SEASONAL_USE_CD                                    
                INTO :RG-CODE-UTIL-TYPE,                                
                     :RG-IC-NO,                                         
                     :RG-MTR-REF-NO,                                    
                     :RG-REG-ID-NO,                                     
                     :RG-METER-NO,                                      
                     :RG-CODE-USAGE-TYPE,                               
                     :RG-CODE-USAGE-ID,                                 
                     :RG-CODE-USAGE-SOURCE,                             
                     :RG-CODE-TIME-PERIOD,                              
                     :RG-CODE-REG-STATUS,                               
                     :RG-CODE-STATUS-REAS,                              
                     :RG-CODE-LAST-REG-READ,                            
                     :RG-LAST-REG-READ-DT,                              
                     :RG-LAST-READ-VALUE,                               
                     :RG-CODE-CRNT-REG-READ,                            
                     :RG-CODE-NO-RD-REASON,                             
                     :RG-LAST-REG-READ-TM,                              
                     :RG-CODE-LAST-VALID-RD,                            
                     :RG-LAST-VALID-READ-DT,                            
                     :RG-LAST-VALID-READ-TM,                            
                     :RG-LAST-VAL-RD-VALUE,                             
                     :RG-SEASONAL-USE-CD                                
                FROM CSS_REGISTER_READ                                  
               WHERE ACCOUNT_NO        = :RG-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE             
                 AND IC_NO             = :RG-IC-NO                      
                 AND MTR_REF_NO        = :RG-MTR-REF-NO                 
                 AND CODE_USAGE_TYPE   = :RG-CODE-USAGE-TYPE            
                 AND CODE_USAGE_ID     = :RG-CODE-USAGE-ID              
                 AND CODE_USAGE_SOURCE = :RG-CODE-USAGE-SOURCE          
                 AND CODE_TIME_PERIOD  = :RG-CODE-TIME-PERIOD           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_UTIL_TYPE,                                            
MFA-TR*              IC_NO,                                                     
MFA-TR*              MTR_REF_NO,                                                
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              METER_NO,                                                  
MFA-TR*              CODE_USAGE_TYPE,                                           
MFA-TR*              CODE_USAGE_ID,                                             
MFA-TR*              CODE_USAGE_SOURCE,                                         
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              CODE_REG_STATUS,                                           
MFA-TR*              CODE_STATUS_REAS,                                          
MFA-TR*              CODE_LAST_REG_READ,                                        
MFA-TR*              LAST_REG_READ_DT,                                          
MFA-TR*              LAST_READ_VALUE,                                           
MFA-TR*              CODE_CRNT_REG_READ,                                        
MFA-TR*              CODE_NO_RD_REASON,                                         
MFA-TR*              LAST_REG_READ_TM,                                          
MFA-TR*              CODE_LAST_VALID_RD,                                        
MFA-TR*              LAST_VALID_READ_DT,                                        
MFA-TR*              LAST_VALID_READ_TM,                                        
MFA-TR*              LAST_VAL_RD_VALUE,                                         
MFA-TR*              SEASONAL_USE_CD                                            
MFA-TR*         INTO :RG-CODE-UTIL-TYPE,                                        
MFA-TR*              :RG-IC-NO,                                                 
MFA-TR*              :RG-MTR-REF-NO,                                            
MFA-TR*              :RG-REG-ID-NO,                                             
MFA-TR*              :RG-METER-NO,                                              
MFA-TR*              :RG-CODE-USAGE-TYPE,                                       
MFA-TR*              :RG-CODE-USAGE-ID,                                         
MFA-TR*              :RG-CODE-USAGE-SOURCE,                                     
MFA-TR*              :RG-CODE-TIME-PERIOD,                                      
MFA-TR*              :RG-CODE-REG-STATUS,                                       
MFA-TR*              :RG-CODE-STATUS-REAS,                                      
MFA-TR*              :RG-CODE-LAST-REG-READ,                                    
MFA-TR*              :RG-LAST-REG-READ-DT,                                      
MFA-TR*              :RG-LAST-READ-VALUE,                                       
MFA-TR*              :RG-CODE-CRNT-REG-READ,                                    
MFA-TR*              :RG-CODE-NO-RD-REASON,                                     
MFA-TR*              :RG-LAST-REG-READ-TM,                                      
MFA-TR*              :RG-CODE-LAST-VALID-RD,                                    
MFA-TR*              :RG-LAST-VALID-READ-DT,                                    
MFA-TR*              :RG-LAST-VALID-READ-TM,                                    
MFA-TR*              :RG-LAST-VAL-RD-VALUE,                                     
MFA-TR*              :RG-SEASONAL-USE-CD                                        
MFA-TR*         FROM CSS_REGISTER_READ                                          
MFA-TR*        WHERE ACCOUNT_NO        = :RG-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :RG-IC-NO                              
MFA-TR*          AND MTR_REF_NO        = :RG-MTR-REF-NO                         
MFA-TR*          AND CODE_USAGE_TYPE   = :RG-CODE-USAGE-TYPE                    
MFA-TR*          AND CODE_USAGE_ID     = :RG-CODE-USAGE-ID                      
MFA-TR*          AND CODE_USAGE_SOURCE = :RG-CODE-USAGE-SOURCE                  
MFA-TR*          AND CODE_TIME_PERIOD  = :RG-CODE-TIME-PERIOD                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7040'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_REGISTER_READ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE 'MTR_REF_NO'        TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE RG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE RG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE RG-MTR-REF-NO       TO HOSTVAR-ELEMENT-3             
CBSI          MOVE RG-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7050-SELECT-MTR-CAP.                                             
           EXEC SQL                                                     
              SELECT K_Q_LEAD_LAG_IND,                                  
                     NO_DIALS,                                          
                     NO_READ_DIALS,                                     
                     CONSTANT                                           
                INTO :MC-K-Q-LEAD-LAG-IND,                              
                     :MC-NO-DIALS,                                      
                     :MC-NO-READ-DIALS,                                 
                     :MC-CONSTANT                                       
                FROM CSS_MTR_CAP                                        
T22243         WHERE COMPANY_NO     = :MC-COMPANY-NO AND                
                     CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE AND            
                     METER_NO = :MC-METER-NO AND                        
                     REG_ID_NO = :MC-REG-ID-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7050'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MTR_CAP'       TO TABLE-1                       
T22243        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'METER_NO'          TO TABLE-ELEMENT-2               
CBSI          MOVE 'REG_ID_NO'         TO TABLE-ELEMENT-3               
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-4               
T22243        MOVE MC-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MC-METER-NO         TO HOSTVAR-ELEMENT-2             
              MOVE MC-REG-ID-NO        TO HOSTVAR-ELEMENT-3             
CBSI          MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
PCR672******************************************************************        
      * 7060-GET RESP AREA ID                                          *        
      *         THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7060-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :WS-USERID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7060'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-TABLES               
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE 'CSS_USER_PROFILE  '  TO TABLE-1                    
CBSI           MOVE 'USER_ID'             TO TABLE-ELEMENT-1            
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
CBSI           MOVE WS-USERID             TO HOSTVAR-ELEMENT-1          
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
        7060-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
PCR672******************************************************************        
      * 7070-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7070-GET-CURRENT-DATE.                                           
           EXEC SQL                                                     
                SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                        
                  INTO :WS-CURRENT-DATE                                 
                  FROM CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CURRENT DATE                                             
MFA-TR*           INTO :WS-CURRENT-DATE                                         
MFA-TR*           FROM CSS_MODEL_SQL                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PCR672******************************************************************        
      * 7080-ACCEPT-TIMESTAMP                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
       7080-ACCEPT-TIMESTAMP.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                 INTO :WS-CURRENT-TIMESTAMP                             
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP                                         
MFA-TR*          INTO :WS-CURRENT-TIMESTAMP                                     
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7080'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_MODEL_SQL'      TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
        7080-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
T21677 7090-GET-BILL-STATUS.                                            
T21677*                                                                         
T21677     EXEC SQL                                                     
T21677         SELECT 'Y'                                               
T21677           INTO :WS-ACCT-BILLED                                   
T21677           FROM CSS_BILLING_DET BG                                
T21677          WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO             
T21677            AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE         
T21677            AND BG.BILL_NO           =                            
T21677               ( SELECT MAX(BI.BILL_NO)                           
T21677                   FROM CSS_BILLING_HDR BI                        
T21677                  WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO            
T21677                    AND BI.DATE_BILLED IS NOT NULL )              
T21677          AND BG.CODE_BILL_ITM_TYPE <> 'B'                        
T21677          AND BG.REV_MTH_ORIG_BILL  = 0                           
T21677          AND BG.REBILL_IND         <> 'Y'                        
T21677          AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH           
T21677   END-EXEC.                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21677     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21677     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21677        OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
T21677        MOVE 500              TO RS-RETURN-CODE                   
T21677        MOVE WS-ERR-MSG-D5318 TO RS-ERROR-CODE                    
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T21677        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
T21677        GO TO 2050-EXIT                                           
T21677     ELSE                                                         
T21677        CONTINUE                                                  
T21677     END-IF.                                                      
T21677*                                                                         
T21677 7090-EXIT.                                                       
T21677     EXIT.                                                        
T21677*                                                                         
       7200-OPEN-UTIL-ENVRNMT.                                          
           EXEC SQL                                                     
              OPEN UT_CRSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7210-FETCH-UTIL-ENVRNMT.                                         
           EXEC SQL                                                     
              FETCH UT_CRSR                                             
               INTO :UT-CODE-UTIL-TYPE,                                 
                    :UT-IC-NO,                                          
                    :UT-CODE-REVENUE-CLASS,                             
                    :UT-CODE-ESTIMATE-OK,                               
                    :UT-RATE-PLAN-NO,                                   
                    :UT-CODE-SIC-NO,                                    
                    :UT-CODE-MTR-READ-FREQ,                             
                    :UT-CODE-CURTAIL-PRTY,                              
                    :UT-DATE-LST-NRML-BILL :WS-NULL-5                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-5 < ZERO                                       
                 MOVE LOW-VALUES TO UT-DATE-LST-NRML-BILL               
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7220-CLOSE-UTIL-ENVRNMT.                                         
           EXEC SQL                                                     
              CLOSE UT_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7220'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
       7230-OPEN-BILLING-HDR.                                           
           EXEC SQL                                                     
               OPEN BILLING_HDR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7230'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_HDR'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7231-FETCH-BILLING-HDR.                                          
           EXEC SQL                                                     
              FETCH BILLING_HDR                                         
               INTO :BI-PREMISE-NO,                                     
                    :BI-BILL-NO,                                        
                    :BI-DATE-BILLED :IND-DATE-BILLED                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7231'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_HDR'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7231-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7232-CLOSE-BILLING-HDR.                                          
           EXEC SQL                                                     
               CLOSE BILLING_HDR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7232'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_HDR'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7232-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7250-OPEN-BILLING-DET-CUR2.                                      
           EXEC SQL                                                     
               OPEN BILLING_DET_CUR2                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7250'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
CBSI          MOVE 'CSS_BILLING_DET'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE BG-BILL-NO          TO HOSTVAR-ELEMENT-2             
              MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
              MOVE BG-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7251-FETCH-BILLING-DET-CUR2.                                     
           EXEC SQL                                                     
              FETCH BILLING_DET_CUR2                                    
              INTO :BG-ACCOUNT-NO,                                      
                   :BG-PREMISE-NO,                                      
                   :BG-BILL-NO,                                         
                   :BG-CODE-UTIL-TYPE,                                  
                   :BG-IC-NO,                                           
                   :BG-BILL-ITEM-TIMESTMP,                              
                   :BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL,              
                   :BG-AMT-BILL-ITEM,                                   
                   :BG-CODE-BILL-CALC,                                  
                   :BG-CODE-BILL-ITM-TYPE,                              
                   :BG-CODE-BILL-ITM-IND,                               
                   :BG-CODE-DR-CR-CNSMPTN,                              
                   :BG-AMT-STATE-TAX,                                   
                   :BG-AMT-CITY-TAX,                                    
                   :BG-AMT-OTHER-TAX,                                   
                   :BG-CODE-REVENUE-CLASS,                              
                   :BG-CODE-SIC-NO,                                     
                   :BG-RATE-PLAN-NO,                                    
                   :BG-CODE-CURTAIL-PRTY,                               
                   :BG-CODE-STAT-TAX-XMT,                               
                   :BG-CODE-CITY-TAX-XMT,                               
                   :BG-CODE-OTHR-TAX-XMT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7251'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
CBSI          MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7251-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7252-CLOSE-BILLING-DET-CUR2.                                     
           EXEC SQL                                                     
               CLOSE BILLING_DET_CUR2                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7252'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
CBSI          MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7252-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7260-SELECT-LAST-BILL-DET.                                       
           EXEC SQL                                                     
              SELECT REVENUE_MONTH                                      
                INTO :BG-REVENUE-MONTH                                  
                FROM CSS_BILLING_DET                                    
               WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                    
                 AND BILL_NO        = :BG-BILL-NO                       
                 AND IC_NO          = :BG-IC-NO                         
                 AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE 0 TO BG-REVENUE-MONTH                                
           WHEN OTHER                                                   
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7300-OPEN-CNSMPTN-HIST.                                          
           EXEC SQL                                                     
               OPEN GET_CNSMPTN_HIST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_CNSMPTN_HIST'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'BILL_NO'            TO TABLE-ELEMENT-4              
              MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE CX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE CX-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE CX-BILL-NO           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7310-FETCH-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
              FETCH GET_CNSMPTN_HIST                                    
               INTO :EXISTS-SW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET EXISTS-NO TO TRUE                                  
              ELSE                                                      
                 MOVE SPACES               TO ABEND-TABLES              
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                 MOVE '7310'               TO ACTIVE-PARAGRAPH          
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_CNSMPTN_HIST'   TO TABLE-1                   
CBSI             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2           
CBSI             MOVE 'IC_NO'              TO TABLE-ELEMENT-3           
CBSI             MOVE 'BILL_NO'            TO TABLE-ELEMENT-4           
                 MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE CX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2         
                 MOVE CX-IC-NO             TO HOSTVAR-ELEMENT-3         
CBSI             MOVE CX-BILL-NO           TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7320-CLOSE-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
               CLOSE GET_CNSMPTN_HIST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7320'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_CNSMPTN_HIST'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'BILL_NO'            TO TABLE-ELEMENT-4              
              MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE CX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE CX-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE CX-BILL-NO           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7350-OPEN-REG-READ.                                              
           EXEC SQL                                                     
               OPEN RG_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7350'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE RG-MTR-REF-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7360-FETCH-REG-READ.                                             
           EXEC SQL                                                     
               FETCH RG_CRSR                                            
                INTO :RG-REG-ID-NO,                                     
                     :RG-CODE-CRNT-REG-READ                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7360'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE RG-MTR-REF-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7370-CLOSE-REG-READ.                                             
           EXEC SQL                                                     
               CLOSE RG_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7370'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE RG-MTR-REF-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7400-OPEN-MTR-READ.                                              
           EXEC SQL                                                     
               OPEN MN_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MN-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7410-FETCH-MTR-READ.                                             
           EXEC SQL                                                     
              FETCH MN_CRSR                                             
               INTO :MN-REG-ID-NO,                                      
                    :MN-METER-NO,                                       
                    :MN-MTR-REF-NO,                                     
                    :MN-CODE-CRNT-REG-READ,                             
T9495               :MN-CODE-METER-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7410'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MN-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7420-CLOSE-MTR-READ.                                             
           EXEC SQL                                                     
               CLOSE MN_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7420'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MN-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7500-SELECT-RATE-USE-SEASN.                                      
           EXEC SQL                                                     
              SELECT DATE_FROM,                                         
                     DATE_TO,                                           
                     CODE_SEASON                                        
                INTO :RS-DATE-FROM,                                     
                     :RS-DATE-TO,                                       
                     :RS-CODE-SEASON                                    
                FROM CSS_RATE_USE_SEASN                                 
               WHERE CODE_UTIL_TYPE     = :RS-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RS-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RS-VERSION-NO-CNTRL          
                 AND CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_RATE_USE_SEASN'  TO TABLE-1                     
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
              MOVE 'VERSION_NO_CNTRL'    TO TABLE-ELEMENT-3             
              MOVE 'CODE_USE_INST_TYPE'  TO TABLE-ELEMENT-4             
              MOVE RS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
              MOVE RS-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
              MOVE RS-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3           
              MOVE RS-CODE-USE-INST-TYPE TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7510-SELECT-MAX-VERSION.                                         
           EXEC SQL                                                     
               SELECT MAX(VERSION_NO_CNTRL)                             
                 INTO :RS-VERSION-NO-CNTRL                              
                 FROM CSS_RATE_USE_SEASN                                
                WHERE CODE_UTIL_TYPE     = :RS-CODE-UTIL-TYPE           
                  AND RATE_PLAN_NO       = :RS-RATE-PLAN-NO             
                  AND CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI          MOVE '7510'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_RATE_USE_SEASN'  TO TABLE-1                     
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
              MOVE 'CODE_USE_INST_TYPE'  TO TABLE-ELEMENT-3             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-4             
              MOVE RS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
              MOVE RS-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
              MOVE RS-CODE-USE-INST-TYPE TO HOSTVAR-ELEMENT-3           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7515-SELECT-MAX-CNSMPTN-HIST.                                    
           EXEC SQL                                                     
               SELECT MAX (ITEM_SEQ_NO)                                 
                 INTO :CX-ITEM-SEQ-NO :WS-CX-ITEM-SEQ-NO-NULL           
                 FROM CSS_CNSMPTN_HIST                                  
                WHERE ACCOUNT_NO            = :CX-ACCOUNT-NO            
                  AND BILL_NO               = :CX-BILL-NO               
                  AND CODE_UTIL_TYPE        = :CX-CODE-UTIL-TYPE        
                  AND IC_NO                 = :CX-IC-NO                 
                  AND BILL_ITEM_TIMESTMP    = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                  AND MTR_REF_NO            = :CX-MTR-REF-NO            
                  AND REG_ID_NO             = :CX-REG-ID-NO             
                  AND CODE_TIME_PERIOD      = :CX-CODE-TIME-PERIOD      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX (ITEM_SEQ_NO)                                         
MFA-TR*          INTO :CX-ITEM-SEQ-NO :WS-CX-ITEM-SEQ-NO-NULL                   
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO            = :CX-ACCOUNT-NO                    
MFA-TR*           AND BILL_NO               = :CX-BILL-NO                       
MFA-TR*           AND CODE_UTIL_TYPE        = :CX-CODE-UTIL-TYPE                
MFA-TR*           AND IC_NO                 = :CX-IC-NO                         
MFA-TR*           AND BILL_ITEM_TIMESTMP    = :CX-BILL-ITEM-TIMESTMP            
MFA-TR*           AND MTR_REF_NO            = :CX-MTR-REF-NO                    
MFA-TR*           AND REG_ID_NO             = :CX-REG-ID-NO                     
MFA-TR*           AND CODE_TIME_PERIOD      = :CX-CODE-TIME-PERIOD              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-CX-ITEM-SEQ-NO-NULL LESS THAN ZERO                     
               MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE
           END-IF.                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7515'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CNSMPTN_HIST'   TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'BILL_NO'            TO TABLE-ELEMENT-2              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-4              
              MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE CX-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE CX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
CBSI          MOVE CX-IC-NO             TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7515-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7590-CALC-NO-DAYS.                                               
           EXEC SQL                                                     
                SELECT CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-DATE-CALC-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC-2
              ) <> 0) OR (LEN(:WS-DATE-CALC-2) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-CALC-2
              ), CONVERT(DATE, :WS-DATE-CALC-2) ) )                            
                        - CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-CALC-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CALC-1
              ) <> 0) OR (LEN(:WS-DATE-CALC-1) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-CALC-1
              ), CONVERT(DATE, :WS-DATE-CALC-1) ) )                         
                INTO :WS-CALC-NO-DAYS                                   
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DAYS(:WS-DATE-CALC-2)                                    
MFA-TR*                 - DAYS(:WS-DATE-CALC-1)                                 
MFA-TR*         INTO :WS-CALC-NO-DAYS                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7590'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_MODEL_SQL'      TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7590-EXIT.                                                       
           EXIT.                                                        
A00795*                                                                         
A00795******************************************************************05050000
A00795* 7600-START-FCSJC01.                                           * 05060003
A00795******************************************************************05070000
A00795     EXEC SQL                                                     02000000
A00795         INCLUDE CPDCA038                                                 
A00795     END-EXEC.                                                            
A00795                                                                  
A00795 7650-GET-TIME.                                                   
           EXEC SQL                                                     
                SELECT REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME()
           , 108), ':', '.')                                     
                INTO :WS-TIME                                           
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CURRENT TIME                                             
MFA-TR*         INTO :WS-TIME                                                   
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
A00795        MOVE '7650'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_MODEL_SQL'      TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
A00795 7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-GET-XREF-ACCOUNT.                                           
PCR376     EXEC SQL                                                     
PCR376        SELECT XR.NEW_ACCOUNT_NO                                  
PCR376          INTO :XR-NEW-ACCOUNT-NO                                 
PCR376          FROM CSS_XREF_ACCT      XR,                             
PCR376               CSS_ACCOUNT        AT,                             
PCR376               CSS_CUST_PREM_HIST CH                              
PCR376          WHERE XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO            
PCR376            AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                 
PCR376            AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                 
PCR376            AND AT.PREMISE_NO     = CH.PREMISE_NO                 
PCR376            AND CH.DATE_UTIL_SVC_STRT =                           
PCR376                (SELECT MAX(DATE_UTIL_SVC_STRT)                   
PCR376                   FROM CSS_CUST_PREM_HIST                        
PCR376                  WHERE PREMISE_NO = AT.PREMISE_NO)               
PCR376     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7810'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_XREF_ACCT'      TO TABLE-1                      
CBSI          MOVE 'CSS_ACCOUNT'        TO TABLE-2                      
CBSI          MOVE 'CSS_CUST_PREM_HIST' TO TABLE-3                      
CBSI          MOVE 'OLD_ACCOUNT_NO'     TO TABLE-ELEMENT-1              
              MOVE XR-OLD-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       8001-UPDATE-ACCOUNT.                                             
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET NXT_BILL_NO = :AT-NXT-BILL-NO                      
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'NXT_BILL_NO'            TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE AT-NXT-BILL-NO           TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8843-UPDATE-REGISTER-READ.                                       
           MOVE WS-READ-CODE TO RG-CODE-CRNT-REG-READ                   
                                RG-CODE-LAST-REG-READ.                  
           IF RG-LAST-REG-READ-DT = LOW-VALUES                          
              MOVE -1 TO WS-NULL-1                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-1                                    
           END-IF.                                                      
                                                                        
           IF RG-LAST-REG-READ-TM = LOW-VALUES                          
              MOVE -1 TO WS-NULL-2                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-2                                    
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-3                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-3                                    
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-TM = LOW-VALUES                        
              MOVE -1 TO WS-NULL-4                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-4                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_REGISTER_READ                                 
                  SET CODE_REG_STATUS       = :RG-CODE-REG-STATUS,      
                      CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ,   
                      CODE_LAST_REG_READ    = :RG-CODE-LAST-REG-READ,   
                      CODE_NO_RD_REASON     = :RG-CODE-NO-RD-REASON,    
                      LAST_READ_VALUE       = :RG-LAST-READ-VALUE,      
                      LAST_REG_READ_DT      = IIF(TRY_CONVERT(DATE, 
                                                  :RG-LAST-REG-READ-DT 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-REG-READ-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:RG-LAST-REG-READ-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-REG-READ-DT :WS-NULL-1
              ), CONVERT(DATE, :RG-LAST-REG-READ-DT :WS-NULL-1) ),             
                      LAST_REG_READ_TM      = CIS.CHAR2TIME(
                                                  :RG-LAST-REG-READ-TM 
                                                            :WS-NULL-2
              ),               
                      CODE_LAST_VALID_RD    = :RG-CODE-LAST-VALID-RD,   
                      LAST_VALID_READ_DT    = IIF(TRY_CONVERT(DATE, 
                                                :RG-LAST-VALID-READ-DT 
                                                             :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-VALID-READ-DT 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:RG-LAST-VALID-READ-DT :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-VALID-READ-DT :WS-NULL-3
              ), CONVERT(DATE, :RG-LAST-VALID-READ-DT :WS-NULL-3) ),           
                      LAST_VALID_READ_TM    = CIS.CHAR2TIME(
                                                :RG-LAST-VALID-READ-TM 
                                                            :WS-NULL-4
              ),               
                      LAST_VAL_RD_VALUE     = :RG-LAST-VAL-RD-VALUE,    
                      SEASONAL_USE_CD       = :RG-SEASONAL-USE-CD,      
                      LAST_UPDATE_TS        = CIS.CURRENT$TIMESTAMP()         
                WHERE ACCOUNT_NO            = :RG-ACCOUNT-NO            
                  AND CODE_UTIL_TYPE        = :RG-CODE-UTIL-TYPE        
                  AND IC_NO                 = :RG-IC-NO                 
                  AND MTR_REF_NO            = :RG-MTR-REF-NO            
                  AND REG_ID_NO             = :RG-REG-ID-NO             
                  AND CODE_TIME_PERIOD      = :RG-CODE-TIME-PERIOD      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REGISTER_READ                                         
MFA-TR*           SET CODE_REG_STATUS       = :RG-CODE-REG-STATUS,              
MFA-TR*               CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ,           
MFA-TR*               CODE_LAST_REG_READ    = :RG-CODE-LAST-REG-READ,           
MFA-TR*               CODE_NO_RD_REASON     = :RG-CODE-NO-RD-REASON,            
MFA-TR*               LAST_READ_VALUE       = :RG-LAST-READ-VALUE,              
MFA-TR*               LAST_REG_READ_DT      = :RG-LAST-REG-READ-DT              
MFA-TR*                                       :WS-NULL-1,                       
MFA-TR*               LAST_REG_READ_TM      = :RG-LAST-REG-READ-TM              
MFA-TR*                                       :WS-NULL-2,                       
MFA-TR*               CODE_LAST_VALID_RD    = :RG-CODE-LAST-VALID-RD,           
MFA-TR*               LAST_VALID_READ_DT    = :RG-LAST-VALID-READ-DT            
MFA-TR*                                       :WS-NULL-3,                       
MFA-TR*               LAST_VALID_READ_TM    = :RG-LAST-VALID-READ-TM            
MFA-TR*                                       :WS-NULL-4,                       
MFA-TR*               LAST_VAL_RD_VALUE     = :RG-LAST-VAL-RD-VALUE,            
MFA-TR*               SEASONAL_USE_CD       = :RG-SEASONAL-USE-CD,              
MFA-TR*               LAST_UPDATE_TS        = CURRENT TIMESTAMP                 
MFA-TR*         WHERE ACCOUNT_NO            = :RG-ACCOUNT-NO                    
MFA-TR*           AND CODE_UTIL_TYPE        = :RG-CODE-UTIL-TYPE                
MFA-TR*           AND IC_NO                 = :RG-IC-NO                         
MFA-TR*           AND MTR_REF_NO            = :RG-MTR-REF-NO                    
MFA-TR*           AND REG_ID_NO             = :RG-REG-ID-NO                     
MFA-TR*           AND CODE_TIME_PERIOD      = :RG-CODE-TIME-PERIOD              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8843'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
CBSI          MOVE 'CSS_REGISTER_READ'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
CBSI          MOVE 'MTR_REF_NO'              TO TABLE-ELEMENT-4         
              MOVE RG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE RG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE RG-IC-NO                  TO HOSTVAR-ELEMENT-3       
CBSI          MOVE RG-MTR-REF-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8843-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8845-UPDATE-MTRD-ENVRNMT.                                        
           MOVE WS-READ-CODE TO MN-CODE-CRNT-REG-READ                   
                                MN-CODE-LAST-REG-READ.                  
           IF MN-LAST-REG-READ-DATE = LOW-VALUES                        
              MOVE -1 TO WS-NULL-1                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-1                                    
           END-IF.                                                      
                                                                        
           IF MN-LAST-REG-READ-TIME = LOW-VALUES                        
              MOVE -1 TO WS-NULL-2                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-2                                    
           END-IF.                                                      
                                                                        
           IF MN-LAST-VALID-READ-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-3                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-3                                    
           END-IF.                                                      
                                                                        
           IF MN-LAST-VALID-READ-TM = LOW-VALUES                        
              MOVE -1 TO WS-NULL-4                                      
           ELSE                                                         
              MOVE ZERO TO WS-NULL-4                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
                  SET CODE_NO_RD_REASON     = :MN-CODE-NO-RD-REASON,    
                      CODE_LAST_REG_READ    = :MN-CODE-LAST-REG-READ,   
                      LAST_REG_READ_DATE    = IIF(TRY_CONVERT(DATE, 
                                                :MN-LAST-REG-READ-DATE 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE :WS-NULL-1
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE :WS-NULL-1) ),           
                      LAST_REG_READ_TIME    = CIS.CHAR2TIME(
                                                :MN-LAST-REG-READ-TIME 
                                                            :WS-NULL-2
              ),               
                      LAST_READ_VALUE       = :MN-LAST-READ-VALUE,      
                      LAST_VALID_READ_DT    = IIF(TRY_CONVERT(DATE, 
                                                :MN-LAST-VALID-READ-DT 
                                                             :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT :WS-NULL-3
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT :WS-NULL-3) ),           
                      LAST_VALID_READ_TM    = CIS.CHAR2TIME(
                                                :MN-LAST-VALID-READ-TM 
                                                            :WS-NULL-4
              ),               
                      LAST_VAL_RD_VALUE     = :MN-LAST-VAL-RD-VALUE,    
                      NO_CONSEC_ESTIMATE    = :MN-NO-CONSEC-ESTIMATE,   
                      NO_CONSEC_CRD_READ    = :MN-NO-CONSEC-CRD-READ,   
                      CODE_CRNT_REG_READ    = :MN-CODE-CRNT-REG-READ,   
                      EXCEPT_OVERRIDE_CD    = :MN-EXCEPT-OVERRIDE-CD,   
                      CODE_LAST_VALID_RD    = :MN-CODE-LAST-VALID-RD,   
                      LAST_UPDATE_TS        = CIS.CURRENT$TIMESTAMP()         
                WHERE ACCOUNT_NO            = :MN-ACCOUNT-NO            
                  AND CODE_UTIL_TYPE        = :MN-CODE-UTIL-TYPE        
                  AND IC_NO                 = :MN-IC-NO                 
                  AND MTR_REF_NO            = :MN-MTR-REF-NO            
                  AND METER_NO              = :MN-METER-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*           SET CODE_NO_RD_REASON     = :MN-CODE-NO-RD-REASON,            
MFA-TR*               CODE_LAST_REG_READ    = :MN-CODE-LAST-REG-READ,           
MFA-TR*               LAST_REG_READ_DATE    = :MN-LAST-REG-READ-DATE            
MFA-TR*                                       :WS-NULL-1,                       
MFA-TR*               LAST_REG_READ_TIME    = :MN-LAST-REG-READ-TIME            
MFA-TR*                                       :WS-NULL-2,                       
MFA-TR*               LAST_READ_VALUE       = :MN-LAST-READ-VALUE,              
MFA-TR*               LAST_VALID_READ_DT    = :MN-LAST-VALID-READ-DT            
MFA-TR*                                       :WS-NULL-3,                       
MFA-TR*               LAST_VALID_READ_TM    = :MN-LAST-VALID-READ-TM            
MFA-TR*                                       :WS-NULL-4,                       
MFA-TR*               LAST_VAL_RD_VALUE     = :MN-LAST-VAL-RD-VALUE,            
MFA-TR*               NO_CONSEC_ESTIMATE    = :MN-NO-CONSEC-ESTIMATE,           
MFA-TR*               NO_CONSEC_CRD_READ    = :MN-NO-CONSEC-CRD-READ,           
MFA-TR*               CODE_CRNT_REG_READ    = :MN-CODE-CRNT-REG-READ,           
MFA-TR*               EXCEPT_OVERRIDE_CD    = :MN-EXCEPT-OVERRIDE-CD,           
MFA-TR*               CODE_LAST_VALID_RD    = :MN-CODE-LAST-VALID-RD,           
MFA-TR*               LAST_UPDATE_TS        = CURRENT TIMESTAMP                 
MFA-TR*         WHERE ACCOUNT_NO            = :MN-ACCOUNT-NO                    
MFA-TR*           AND CODE_UTIL_TYPE        = :MN-CODE-UTIL-TYPE                
MFA-TR*           AND IC_NO                 = :MN-IC-NO                         
MFA-TR*           AND MTR_REF_NO            = :MN-MTR-REF-NO                    
MFA-TR*           AND METER_NO              = :MN-METER-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8845'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'MTR_REF_NO'              TO TABLE-ELEMENT-4         
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE MN-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE MN-MTR-REF-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8845-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8860-ISRT-BILLING-HDR.                                           
           MOVE '8860'       TO ACTIVE-PARAGRAPH                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_HDR                              
                 (ACCOUNT_NO,                                           
                  PREMISE_NO,                                           
                  BILL_NO,                                              
                  DATE_BILLED,                                          
                  CODE_BILL_REASON,                                     
                  CODE_BILL_STATUS,                                     
                  CODE_BILL_TYPE,                                       
                  COMPANY_NO,                                           
                  CUSTOMER_NO,                                          
                  CODE_SPCL_BILL,                                       
                  PREM_ACCT_SEQ_NO,                                     
                  SMRY_BILL_NO,                                         
                  SMRY_REBILL_NO)                                       
               VALUES                                                   
                 (:BI-ACCOUNT-NO,                                       
                  :BI-PREMISE-NO,                                       
                  :BI-BILL-NO,                                          
                  IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED :IND-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                       :IND-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED :IND-DATE-BILLED
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :IND-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED :IND-DATE-BILLED) ),            
                  :BI-CODE-BILL-REASON,                                 
                  :BI-CODE-BILL-STATUS,                                 
                  :BI-CODE-BILL-TYPE,                                   
                  :BI-COMPANY-NO,                                       
                  :BI-CUSTOMER-NO,                                      
                  :BI-CODE-SPCL-BILL,                                   
                  :BI-PREM-ACCT-SEQ-NO,                                 
                  :BI-SMRY-BILL-NO,                                     
                  :BI-SMRY-REBILL-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_HDR                                      
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           PREMISE_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           DATE_BILLED,                                                  
MFA-TR*           CODE_BILL_REASON,                                             
MFA-TR*           CODE_BILL_STATUS,                                             
MFA-TR*           CODE_BILL_TYPE,                                               
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           CUSTOMER_NO,                                                  
MFA-TR*           CODE_SPCL_BILL,                                               
MFA-TR*           PREM_ACCT_SEQ_NO,                                             
MFA-TR*           SMRY_BILL_NO,                                                 
MFA-TR*           SMRY_REBILL_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*          (:BI-ACCOUNT-NO,                                               
MFA-TR*           :BI-PREMISE-NO,                                               
MFA-TR*           :BI-BILL-NO,                                                  
MFA-TR*           :BI-DATE-BILLED:IND-DATE-BILLED,                              
MFA-TR*           :BI-CODE-BILL-REASON,                                         
MFA-TR*           :BI-CODE-BILL-STATUS,                                         
MFA-TR*           :BI-CODE-BILL-TYPE,                                           
MFA-TR*           :BI-COMPANY-NO,                                               
MFA-TR*           :BI-CUSTOMER-NO,                                              
MFA-TR*           :BI-CODE-SPCL-BILL,                                           
MFA-TR*           :BI-PREM-ACCT-SEQ-NO,                                         
MFA-TR*           :BI-SMRY-BILL-NO,                                             
MFA-TR*           :BI-SMRY-REBILL-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_BILLING_HDR'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-3          
CBSI          MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-4          
              MOVE BI-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BI-PREMISE-NO            TO HOSTVAR-ELEMENT-2        
              MOVE BI-BILL-NO               TO HOSTVAR-ELEMENT-3        
CBSI          MOVE BI-CUSTOMER-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8862-INSERT-BILLING-DET.                                         
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_DET                              
                 (ACCOUNT_NO,                                           
                  PREMISE_NO,                                           
                  BILL_NO,                                              
                  CODE_UTIL_TYPE,                                       
                  IC_NO,                                                
                  BILL_ITEM_TIMESTMP,                                   
                  DATE_ORIG_BILL,                                       
                  AMT_BILL_ITEM,                                        
                  COMPANY_NO,                                           
                  CODE_BILL_CALC,                                       
                  CODE_BILL_ITM_TYPE,                                   
                  CODE_BILL_ITM_IND,                                    
                  CODE_DR_CR_CNSMPTN,                                   
                  AMT_STATE_TAX,                                        
                  AMT_CITY_TAX,                                         
                  AMT_OTHER_TAX,                                        
                  CODE_REVENUE_CLASS,                                   
                  CODE_SIC_NO,                                          
                  RATE_PLAN_NO,                                         
                  CODE_CURTAIL_PRTY,                                    
                  CODE_STAT_TAX_XMT,                                    
                  CODE_CITY_TAX_XMT,                                    
                  CODE_OTHR_TAX_XMT,                                    
PCR672            ADJ_REASON_CD,                                        
                  REV_MTH_ORIG_BILL,                                    
T17429            REV_DISTRICT_CD                                       
ACT245           ,GAS_BASE_USE )                                        
               VALUES                                                   
                 (:BG-ACCOUNT-NO,                                       
                  :BG-PREMISE-NO,                                       
                  :BG-BILL-NO,                                          
                  :BG-CODE-UTIL-TYPE,                                   
                  :BG-IC-NO,                                            
                  CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP),                   
                  IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                        :IND-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                    :IND-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                    :IND-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL
              ) ),                
                  :BG-AMT-BILL-ITEM,                                    
                  :BG-COMPANY-NO,                                       
                  :BG-CODE-BILL-CALC,                                   
                  :BG-CODE-BILL-ITM-TYPE,                               
                  :BG-CODE-BILL-ITM-IND,                                
                  :BG-CODE-DR-CR-CNSMPTN,                               
                  :BG-AMT-STATE-TAX,                                    
                  :BG-AMT-CITY-TAX,                                     
                  :BG-AMT-OTHER-TAX,                                    
                  :BG-CODE-REVENUE-CLASS,                               
                  :BG-CODE-SIC-NO,                                      
                  :BG-RATE-PLAN-NO,                                     
                  :BG-CODE-CURTAIL-PRTY,                                
                  :BG-CODE-STAT-TAX-XMT,                                
                  :BG-CODE-CITY-TAX-XMT,                                
                  :BG-CODE-OTHR-TAX-XMT,                                
PCR672            :BG-ADJ-REASON-CD :WS-ADJ-NULL-IND,                    
                  :BG-REV-MTH-ORIG-BILL,                                
T17429            :BG-REV-DISTRICT-CD                                   
ACT245           ,:BG-GAS-BASE-USE )                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_DET                                      
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           PREMISE_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           CODE_UTIL_TYPE,                                               
MFA-TR*           IC_NO,                                                        
MFA-TR*           BILL_ITEM_TIMESTMP,                                           
MFA-TR*           DATE_ORIG_BILL,                                               
MFA-TR*           AMT_BILL_ITEM,                                                
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           CODE_BILL_CALC,                                               
MFA-TR*           CODE_BILL_ITM_TYPE,                                           
MFA-TR*           CODE_BILL_ITM_IND,                                            
MFA-TR*           CODE_DR_CR_CNSMPTN,                                           
MFA-TR*           AMT_STATE_TAX,                                                
MFA-TR*           AMT_CITY_TAX,                                                 
MFA-TR*           AMT_OTHER_TAX,                                                
MFA-TR*           CODE_REVENUE_CLASS,                                           
MFA-TR*           CODE_SIC_NO,                                                  
MFA-TR*           RATE_PLAN_NO,                                                 
MFA-TR*           CODE_CURTAIL_PRTY,                                            
MFA-TR*           CODE_STAT_TAX_XMT,                                            
MFA-TR*           CODE_CITY_TAX_XMT,                                            
MFA-TR*           CODE_OTHR_TAX_XMT,                                            
MFA-TR*           ADJ_REASON_CD,                                                
MFA-TR*           REV_MTH_ORIG_BILL,                                            
MFA-TR*           REV_DISTRICT_CD                                               
MFA-TR*          ,GAS_BASE_USE )                                                
MFA-TR*        VALUES                                                           
MFA-TR*          (:BG-ACCOUNT-NO,                                               
MFA-TR*           :BG-PREMISE-NO,                                               
MFA-TR*           :BG-BILL-NO,                                                  
MFA-TR*           :BG-CODE-UTIL-TYPE,                                           
MFA-TR*           :BG-IC-NO,                                                    
MFA-TR*           :BG-BILL-ITEM-TIMESTMP,                                       
MFA-TR*           :BG-DATE-ORIG-BILL:IND-DATE-ORIG-BILL,                        
MFA-TR*           :BG-AMT-BILL-ITEM,                                            
MFA-TR*           :BG-COMPANY-NO,                                               
MFA-TR*           :BG-CODE-BILL-CALC,                                           
MFA-TR*           :BG-CODE-BILL-ITM-TYPE,                                       
MFA-TR*           :BG-CODE-BILL-ITM-IND,                                        
MFA-TR*           :BG-CODE-DR-CR-CNSMPTN,                                       
MFA-TR*           :BG-AMT-STATE-TAX,                                            
MFA-TR*           :BG-AMT-CITY-TAX,                                             
MFA-TR*           :BG-AMT-OTHER-TAX,                                            
MFA-TR*           :BG-CODE-REVENUE-CLASS,                                       
MFA-TR*           :BG-CODE-SIC-NO,                                              
MFA-TR*           :BG-RATE-PLAN-NO,                                             
MFA-TR*           :BG-CODE-CURTAIL-PRTY,                                        
MFA-TR*           :BG-CODE-STAT-TAX-XMT,                                        
MFA-TR*           :BG-CODE-CITY-TAX-XMT,                                        
MFA-TR*           :BG-CODE-OTHR-TAX-XMT,                                        
MFA-TR*           :BG-ADJ-REASON-CD:WS-ADJ-NULL-IND,                            
MFA-TR*           :BG-REV-MTH-ORIG-BILL,                                        
MFA-TR*           :BG-REV-DISTRICT-CD                                           
MFA-TR*          ,:BG-GAS-BASE-USE )                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8862'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI          MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
CBSI          MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
CBSI          MOVE BG-PREMISE-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8862-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8864-UPDATE-BILLING-DET.                                         
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
               SET AMT_BILL_ITEM      = :BG-AMT-BILL-ITEM,              
                   CODE_BILL_CALC     = :BG-CODE-BILL-CALC,             
                   CODE_BILL_ITM_IND  = :BG-CODE-BILL-ITM-IND,          
                   CODE_DR_CR_CNSMPTN = :BG-CODE-DR-CR-CNSMPTN,         
                   AMT_STATE_TAX      = :BG-AMT-STATE-TAX,              
                   AMT_CITY_TAX       = :BG-AMT-CITY-TAX,               
                   AMT_OTHER_TAX      = :BG-AMT-OTHER-TAX,              
                   CODE_SIC_NO        = :BG-CODE-SIC-NO,                
                   CODE_CURTAIL_PRTY  = :BG-CODE-CURTAIL-PRTY,          
PCR672             ADJ_REASON_CD      = :BG-ADJ-REASON-CD 
                                        :WS-ADJ-NULL-IND                
             WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND              
                   BILL_NO            = :BG-BILL-NO AND                 
                   CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND          
                   IC_NO              = :BG-IC-NO AND                   
                   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*        SET AMT_BILL_ITEM      = :BG-AMT-BILL-ITEM,                      
MFA-TR*            CODE_BILL_CALC     = :BG-CODE-BILL-CALC,                     
MFA-TR*            CODE_BILL_ITM_IND  = :BG-CODE-BILL-ITM-IND,                  
MFA-TR*            CODE_DR_CR_CNSMPTN = :BG-CODE-DR-CR-CNSMPTN,                 
MFA-TR*            AMT_STATE_TAX      = :BG-AMT-STATE-TAX,                      
MFA-TR*            AMT_CITY_TAX       = :BG-AMT-CITY-TAX,                       
MFA-TR*            AMT_OTHER_TAX      = :BG-AMT-OTHER-TAX,                      
MFA-TR*            CODE_SIC_NO        = :BG-CODE-SIC-NO,                        
MFA-TR*            CODE_CURTAIL_PRTY  = :BG-CODE-CURTAIL-PRTY,                  
MFA-TR*            ADJ_REASON_CD      = :BG-ADJ-REASON-CD                       
MFA-TR*                                 :WS-ADJ-NULL-IND                        
MFA-TR*      WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND                      
MFA-TR*            BILL_NO            = :BG-BILL-NO AND                         
MFA-TR*            CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND                  
MFA-TR*            IC_NO              = :BG-IC-NO AND                           
MFA-TR*            BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8864'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
CBSI          MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
CBSI          MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8864-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8870-ISRT-CNSMPTN-HIST.                                          
           EXEC SQL                                                     
               INSERT INTO CSS_CNSMPTN_HIST                             
                (ACCOUNT_NO, BILL_NO,                                   
                 CODE_UTIL_TYPE, IC_NO,                                 
                 BILL_ITEM_TIMESTMP,                                    
                 CODE_TIME_PERIOD, MTR_REF_NO,                          
                 CODE_USAGE_TYPE, CODE_USAGE_ID,                        
                 CODE_USAGE_SOURCE, ITEM_SEQ_NO, METER_NO,              
                 DATE_READ, CODE_METER_READ,                            
                 CODE_METER_NO_READ,                                    
                 COMPANY_NO, NO_DEMAND_UNITS,                           
                 METER_READING, EMPLOYEE_NO,                            
                 NO_UNITS, CODE_TOU_SEASN,                              
                 NO_DAYS, CODE_SOURCE_ID,                               
                 CODE_DEBIT_CREDIT, CODE_DISCOUNT,                      
                 CONSTANT, NO_DIALS,                                    
                 REG_ID_NO, DEMAND_READING,                             
                 EXCEPT_OVERRIDE_CD, CODE_ITEM_STATUS,                  
                 DIGTL_MTR_TYPE, MTR_READ_SOURCE_CD)                    
               VALUES                                                   
                (:CX-ACCOUNT-NO, :CX-BILL-NO,                           
                 :CX-CODE-UTIL-TYPE, :CX-IC-NO,                         
                 CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP),                    
                 :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,                  
                 :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,                
                 :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO, :CX-METER-NO,  
                 IIF(TRY_CONVERT(DATE, :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) ), :CX-CODE-METER-READ,          
                 :CX-CODE-METER-NO-READ,                                
                 :CX-COMPANY-NO, :CX-NO-DEMAND-UNITS,                   
                 :CX-METER-READING, :CX-EMPLOYEE-NO,                    
                 :CX-NO-UNITS, :CX-CODE-TOU-SEASN,                      
                 :CX-NO-DAYS, :CX-CODE-SOURCE-ID,                       
                 :CX-CODE-DEBIT-CREDIT, :CX-CODE-DISCOUNT,              
                 :CX-CONSTANT, :CX-NO-DIALS,                            
                 :CX-REG-ID-NO, :CX-DEMAND-READING,                     
                 :CX-EXCEPT-OVERRIDE-CD, :CX-CODE-ITEM-STATUS,          
                 :CX-DIGTL-MTR-TYPE, :CX-MTR-READ-SOURCE-CD)            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CNSMPTN_HIST                                     
MFA-TR*         (ACCOUNT_NO, BILL_NO,                                           
MFA-TR*          CODE_UTIL_TYPE, IC_NO,                                         
MFA-TR*          BILL_ITEM_TIMESTMP,                                            
MFA-TR*          CODE_TIME_PERIOD, MTR_REF_NO,                                  
MFA-TR*          CODE_USAGE_TYPE, CODE_USAGE_ID,                                
MFA-TR*          CODE_USAGE_SOURCE, ITEM_SEQ_NO, METER_NO,                      
MFA-TR*          DATE_READ, CODE_METER_READ,                                    
MFA-TR*          CODE_METER_NO_READ,                                            
MFA-TR*          COMPANY_NO, NO_DEMAND_UNITS,                                   
MFA-TR*          METER_READING, EMPLOYEE_NO,                                    
MFA-TR*          NO_UNITS, CODE_TOU_SEASN,                                      
MFA-TR*          NO_DAYS, CODE_SOURCE_ID,                                       
MFA-TR*          CODE_DEBIT_CREDIT, CODE_DISCOUNT,                              
MFA-TR*          CONSTANT, NO_DIALS,                                            
MFA-TR*          REG_ID_NO, DEMAND_READING,                                     
MFA-TR*          EXCEPT_OVERRIDE_CD, CODE_ITEM_STATUS,                          
MFA-TR*          DIGTL_MTR_TYPE, MTR_READ_SOURCE_CD)                            
MFA-TR*        VALUES                                                           
MFA-TR*         (:CX-ACCOUNT-NO, :CX-BILL-NO,                                   
MFA-TR*          :CX-CODE-UTIL-TYPE, :CX-IC-NO,                                 
MFA-TR*          :CX-BILL-ITEM-TIMESTMP,                                        
MFA-TR*          :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,                          
MFA-TR*          :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,                        
MFA-TR*          :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO, :CX-METER-NO,          
MFA-TR*          :CX-DATE-READ, :CX-CODE-METER-READ,                            
MFA-TR*          :CX-CODE-METER-NO-READ,                                        
MFA-TR*          :CX-COMPANY-NO, :CX-NO-DEMAND-UNITS,                           
MFA-TR*          :CX-METER-READING, :CX-EMPLOYEE-NO,                            
MFA-TR*          :CX-NO-UNITS, :CX-CODE-TOU-SEASN,                              
MFA-TR*          :CX-NO-DAYS, :CX-CODE-SOURCE-ID,                               
MFA-TR*          :CX-CODE-DEBIT-CREDIT, :CX-CODE-DISCOUNT,                      
MFA-TR*          :CX-CONSTANT, :CX-NO-DIALS,                                    
MFA-TR*          :CX-REG-ID-NO, :CX-DEMAND-READING,                             
MFA-TR*          :CX-EXCEPT-OVERRIDE-CD, :CX-CODE-ITEM-STATUS,                  
MFA-TR*          :CX-DIGTL-MTR-TYPE, :CX-MTR-READ-SOURCE-CD)                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8870'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
CBSI          MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE CX-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CX-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE CX-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
CBSI          MOVE CX-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8870-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8887-UPDATE-CODE-BILLED.                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED            
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8887'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'CODE_ACCT_BILLED'       TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE AT-CODE-ACCT-BILLED      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8887-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
A00795*                                                                *        
A00795******************************************************************        
A00795*   PROCESS ABENDS                                                        
A00795******************************************************************        
A00795 COPY CPD0023c.                                                           
A00795*                                                                *        
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
