       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02147.                                     
COB303 DATE-WRITTEN.      MAY 19, 2005.                                 
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S147                                           *00120000
      *  PROGRAM:       S147                                           *00130000
      *  CALLING SP:    PA_S147                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM UPDATES DEPOSIT RECORDS.                         *00190000
      *  WHEN A DEPOSIT RECORD IS UPDATED, THE CSS_AR_CNTL,            *00200000
      *  CSS_DEP_ON_HAND AND CSS_ACCOUNT TABLES ARE UPDATED.           *00210000
      *  A CASH DRAWER 101 AND AR-TRANSACTION HISTORY JOURNALS         *00220000
      *  ARE WRITTEN.                                                  *00230000
      *                                                                *00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                     PROGRAM MODIFICATION LOG                   *00270000
      *                                                                *00280000
      *    DATE    INITIALS   COMMENTS                                 *00290000
      *  --------  --------   ---------------------------------------  *00300000
      *  08/17/95    HC       CREATED.                                 *00310000
      *  03/12/96    SK       FCS/CIS INTERFACE MODIFICATIONS          *00311000
      *  07/22/96    SR       PCR#052 INSERT ROW INTO CSS_REFUND       *00312000
*T5855*  10/31/96    AG       TPR 5855  IF THE DEPOSIT HAS A BILLING   *00312100
*T5855*                       OPTION OF 'I' OR 'O' DELETE THE ROW FROM *00313000
*T5855*                       CSS_CRED_COLL.                           *00313100
03/12 *  03/12/97    MAD      FIX FOR TRANSACTION COMMENTS NOTED BY P&T*00313200
TP9767*  03/19/97    MAD      ADDED NULL INDICATORS TO THE CODE WHICH  *00313300
      *                       WAS ADDED IN RESOLUTION OF TPR 5855.     *00313400
PCR404*  03/27/97    MAD      CHANGED AR-CODE-TRAN-TYPE FROM 'A'       *00313500
      *                        (ADJUSTMENT) TO 'I' (CREDIT).           *00313600
T10315*  04/10/97    MAD      CHECK_STATUS_CD FOR REFUNDS OTHER THAN   *00313700
      *                        CASH OR CHECK WILL BE SPACES.           *00313800
T11846*  06/26/97    MAD      THE RPC WAS DELETING 'I' AND 'O' ROWS FOR*00313900
      *                        BILL IMMEDIATE DEPOSITS EVEN IF THE     *00314000
      *                        DEPOSIT WAS NOT BEING FULLY CREDITED.   *00314100
      *                        MODIFIED THE RPC TO UPDATE THE 'I' AND  *00314200
      *                        'O' ROWS WHEN THE DEPOSIT IS ONLY BEING *00314300
      *                        PARTIALLY CREDITED.                     *00314400
T14605*  02/09/98    SV       TO DELETE THE SUMMARY RECORD FROM        *00314500
      *                       CSS_AR_CNTL WHEN THERE AREN'T ANY MORE   *00314600
      *                       DEPOSIT RECORDS.                         *00314700
CBSI  *  09/07/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00314806
CBSI  *             MADRAS    ABEND PARAMETERS                         *00314900
T17634*  09/17/98   MDJ       IF THE LENGTH OF WS-COMMENT-TEXT > 72    *        
T17634*                       MOVE +72 TO WS-COMMENT-LEN-NUMBER        *        
T17634*                       AND ONLY MOVE 1 - 72 BYTES OF PARM-      *        
T17634*                       COMMENTS TO WS-COMMENT-TEXT.             *        
T17762*  09/25/98   SHF       CHANGED AR-APPL-PROGRAM-ID VALUE FROM    *        
      *                       "S147" TO "PANEL063" SO THAT THE PROPER  *        
      *                       MESSAGE WILL DISPLAY ON TRANSACTION HIST.*        
T18662*  01/25/99   MDJ       CREATE ADJ ROW IN TRANSACTION HISTORY    *        
      *                       TO SHOW PORTION OF THE DEPOSIT GOING INTO*        
      *                       BILLED BALANCE WHEN ENTIRE CREDIT DEPOSIT*        
      *                       AMOUNT IS NOT GOING INTO BILLED BALANCE. *        
T21069*  11/02/99   CBSI      UPDATE CSS_ACCOUNT WITH LAST-UPDATE-TS   *        
T21069*             MADRAS                                             *        
T21203*  01/31/2000  CBSI     CALL SUB ROUTINE SCSCA182 AND CHECK IF   *        
T21203*              MADRAS   THE PARM-AT-LAST-UPDATE-TS AND THE ONE   *        
T21203*                       OBTAINED FROM THE SUB ROUTINE ARE SAME,  *        
T21203*                       IF THEY ARE SAME UPDATES AR_CNTL ELSE    *        
T21203*                       SENDS ERROR MSG TO THE PANEL             *        
      *                                                                *00310000
T21713*  02/25/00   MDJ       CHANGE SELECT IN 8300 TO SELECT DISTINCT *        
      *                       DUE TO MORE THAN 1 ROW POSSIBLY EXISTING.*        
T21714*                       MOVED SQLCODE TO WS-ACTIVE-RETURN-CODE SO*        
      *                       THAT PANEL WOULD BE AWARE OF BAD RETURN  *        
      *                       CODE.                                    *        
      *  04/04/01 CHANELLE K  MCR310 PSNC.  CSS_GL_ACCT_NO CHANGES.    *        
      *                       RECOMPILE FOR CPD00006.                  *        
C26296*  02/18/05   MDJ    1) WHEN DEP_ON_HAND IS DELETED, CHECK IF    *        
      *                       DEPOSIT-CERT-NO EXISTS ON NSF_HIST.  IF  *        
      *                       IT DOES, MOVE ZERO  TO NH-DEPOSIT-CERT-NO.        
      *                    2) IF DEPOSIT IS IMMEDIATE AND TYPE IS AUTO *        
      *                       DNP DEPOSIT, IF A ROW IS FOUND ON        *        
      *                       CSS_RECONNECT AND DO-DEPOSIT-CERT-NO IS  *        
      *                       EQUAL TO DL-AUTO-DEP-CERT-NO SUBTRACT    *        
      *                       DEPOSIT-CREDIT-AMT FROM DL-AMT-TOT-RECONN*        
      *                       IF DL-AMT-TOT-RECONNECT IS LESS THAN 0,  *        
      *                       MOVE 0 TO IT AND UPDATE.                 *        
      *             SS82048   IF DL-AMT-TOT-RECONNECT IS UPDATED AS 0  *        
      *                       SEND A UNIQUE RETURN CODE FOR THE PANEL  *        
      *                       TO DISPLAY A MESSAGE TO CANCEL DNPFB     *        
REARCH*  05/19/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
C32206*  05/19/06   LG41184   INCREASED THE LENGTH OF CHECK-ISS-REAS-CD*        
PRDFIX*  12/19/06   BASKAR V  FIX TRAN ID PROBLEM                      *        
A00956*  03/26/09   CVNS      REPLACE CPD00006 WITH CPD0006A.          *        
A00956*             CHENNAI                                            *        
P00599*  09/25/12   GV7A828   AUTO DEPOSIT LETTER CHANGES DONE TO      *        
P00599*                       UPDATE CORRESP_STATUS TO 'C' FOR THE     *        
P00599*                       SELECTED ACCOUNT AND DELETE THE SELECTED *        
P00599*                       RECORD AFTER UPDATE                      *        
ACT163* 05/17/16   TP7R341    REMOVE UNUSED COPYBOOKS CWS00076,        *        
ACT163*            APPL5460   CCA00001 AND CPD00302                    *        
      ******************************************************************00314800
      ******************************************************************00315000
      *                                                                *00316000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00317000
      *                                                                *00318000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00319000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00320000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00330000
      *  3000 - 4999  NOT USED                                         *00340000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00350000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00360000
      *  7000 - 7999  INPUT MODULES                                    *00370000
      *  8000 - 8999  OUTPUT MODULES                                   *00380000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00390000
      *                                                                *00400000
      ******************************************************************00410000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02147'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02147 STARTS HERE'.                  
                                                                        
      ******************************************************************00500000
      *    DB2 INCLUDES                                                *00510000
      ******************************************************************00520000
      *                                                                 00530000
           EXEC SQL                                                     00540000
              INCLUDE SQLCA                                             00550000
           END-EXEC.                                                    00560000
                                                                        
      *** CSS_MODEL_SQL                                                 00580000
           EXEC SQL                                                     00590000
              INCLUDE TBMODEL                                           00600000
           END-EXEC.                                                    00610000
                                                                        
      *** CSS_DEP_ON_HAND                                               00630000
           EXEC SQL                                                     00640000
              INCLUDE TBDEPHND                                          00650000
           END-EXEC.                                                    00660000
                                                                        
C26926*** CSS_NSF_HIST                                                  00630000
C26296     EXEC SQL                                                     00640000
C26296        INCLUDE TBNSFHST                                          00650000
C26296     END-EXEC.                                                    00660000
C26296                                                                  
C26296*** CSS_RECONNECT                                                 00630000
C26296     EXEC SQL                                                     00640000
C26296        INCLUDE TBRECNCT                                          00650000
C26296     END-EXEC.                                                    00660000
                                                                        
      *** CSS_AR_CNTL                                                   00680000
           EXEC SQL                                                     00690000
              INCLUDE TBARCNTL                                          00700000
           END-EXEC.                                                    00710000
                                                                        
      *** CSS_AR_LOCKOUT                                                00730000
           EXEC SQL                                                     00740000
              INCLUDE TBARLOCK                                          00750000
           END-EXEC.                                                    00760000
                                                                        
      *** CSS_ACCOUNT                                                   00780000
           EXEC SQL                                                     00790000
              INCLUDE TBACCT                                            00791000
           END-EXEC.                                                    00792000
                                                                        
      *** CSS_AR_TRANS_HIST                                             00794000
           EXEC SQL                                                     00795000
              INCLUDE TBARHIST                                          00796000
           END-EXEC.                                                    00797000
                                                                        
      *** CSS_AR_TRN_HST_DET                                            00799000
           EXEC SQL                                                     00800000
              INCLUDE TBARHDT                                           00810000
           END-EXEC.                                                    00820000
                                                                        
      *** CSS_USER_PROFILE                                              00840000
           EXEC SQL                                                     00850000
              INCLUDE TBUSRPRF                                          00860000
           END-EXEC.                                                    00870000
                                                                        
      *** CSS_ACCOUNT                                                   00890000
                                                                        
      *** CSS_CUSTOMER                                                  00940000
           EXEC SQL                                                     00950000
              INCLUDE TBCUST                                            00960000
           END-EXEC.                                                    00970000
                                                                        
      *** CSS_PREMISE                                                   00990000
           EXEC SQL                                                     01000000
              INCLUDE TBPREM                                            01010000
           END-EXEC.                                                    01020000
                                                                        
      *** CSS_DEP_REQ                                                   01040000
           EXEC SQL                                                     01050000
              INCLUDE TBDEPREQ                                          01060000
           END-EXEC.                                                    01070000
                                                                        
      *                                                                 01090000
           EXEC SQL                                                     01100000
              INCLUDE TBGLATNO                                          01110000
           END-EXEC.                                                    01120000
      *                                                                 01130000
           EXEC SQL                                                     01140000
              INCLUDE TBBJCNTL                                          01150000
           END-EXEC.                                                    01160000
      *                                                                 01170000
           EXEC SQL                                                     01180000
              INCLUDE TBBTJRNL                                          01190000
           END-EXEC.                                                    01200000
      *                                                                 01210000
           EXEC SQL                                                     01220000
              INCLUDE TBMSJRNL                                          01230000
           END-EXEC.                                                    01240000
      *                                                                 01250000
           EXEC SQL                                                     01260000
              INCLUDE TBCDJRNL                                          01270000
           END-EXEC.                                                    01280000
      *                                                                 01290000
           EXEC SQL                                                     01300000
              INCLUDE TBCDCNTL                                          01310000
           END-EXEC.                                                    01320000
      *                                                                 01330000
           EXEC SQL                                                     01340000
              INCLUDE TBREFUND                                          01350000
           END-EXEC.                                                    01360000
      *                                                                 01370000
*T5855     EXEC SQL                                                     01371000
*T5855        INCLUDE TBCRCOLL                                          01372000
*T5855     END-EXEC.                                                    01373000
      *                                                                 01374000
PCR482     EXEC SQL                                                     01375000
PCR482        INCLUDE TBDEPHST                                          01376000
PCR482     END-EXEC.                                                    01377000
P00599* CSS_CORRESP_HDR - 1J                                            01380000
P00599     EXEC SQL                                                     01782000
P00599        INCLUDE TBCORHDR                                          01783000
P00599     END-EXEC.                                                    01784000
P00599* CSS_CORRESP_VAR - 1K                                            01785000
P00599     EXEC SQL                                                     01782000
P00599        INCLUDE TBCORVAR                                          01783000
P00599     END-EXEC.                                                    01784000
      ******************************************************************01390000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01400000
      ******************************************************************01410000
                                                                        
REARCH*    COPY SYGWCOB.                                                01430000
REARCH*    COPY SYDBCOB.                                                01440000
           COPY CJF00101.                                               01450000
           COPY CJF00102.                                               01460000
           COPY CJF00113.                                               01470000
           COPY CJF00201.                                               01480000
REARCH*    COPY CWS00010.                                               01500000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01510000
           COPY CWS00056.                                               01520000
           COPY CWS00100.                                               01540000
           COPY CWS00303.                                               01550000
                                                                        
           EXEC SQL                                                     01551000
               INCLUDE CWS00131                                         01560000
           END-EXEC.                                                    01561000
                                                                        
           EXEC SQL                                                     01580000
A00956         INCLUDE CWS0013B                                         01590000
           END-EXEC.                                                    01600000
      *                                                                 01610000
      *                                                                 01620000
      ******************************************************************01630000
      *    WORK AREAS                                                  *01640000
      ******************************************************************01650000
      *                                                                 01660000
REARCH*01  GW-LIB-MISC-FIELDS.                                          01670000
REARCH*    05  GWL-PROC                POINTER.                         01680000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         01690000
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  01700000
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01710000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01720000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01730000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01740000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01750000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  01760000
      *                                                                 01770000
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02147_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
PCR482     05  WS-DELETE-DEP-SW        PIC X(01) VALUE 'N'.             
PCR482         88 DELETE-NOT-PROCESSED           VALUE 'N'.             
PCR482         88 DELETE-WAS-PROCESSED           VALUE 'Y'.             
      *                                                                 01850000
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
      *                                                                 01890000
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01930000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 01990000
       01  MISCELLANEOUS-WS-FIELDS.                                     
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'S147'.          02010007
           05  VALUE-YES               PIC X(01) VALUE 'Y'.             
           05  VALUE-NO                PIC X(01) VALUE 'N'.             
           05  VALUE-SPACES            PIC X(01) VALUE ' '.             
C26296     05  IMMEDIATE-BILL          PIC X(01) VALUE 'I'.             
C26296     05  AUTO-DNP-DEPOSIT        PIC X(01) VALUE 'B'.             
C26296     05  WS-RECNCT-AMT-ZERO-UPDT PIC X(01) VALUE 'N'.             
C26296         88 RECONNECT-AMT-ZERO-UPDT        VALUE 'Y'.             
           05  DEP-PYMT-PRIORITY-LVL   PIC S9(04) COMP VALUE +80.       
           05  VALUE-ZERO              PIC S9(05) COMP VALUE 0.         
           05  VALUE-ONE               PIC S9(05) COMP VALUE 1.         
           05  ACTIVE                  PIC X(01) VALUE 'A'.             
           05  NULL-INDICATOR          PIC S9(04) COMP VALUE -1.        
           05  WS-NULL-IND-1           PIC S9(04) COMP VALUE -1.        
           05  WS-NULL-IND-2           PIC S9(04) COMP VALUE -1.        
           05  WS-RN-NULL-IND-1        PIC S9(04) COMP VALUE -1.        
           05  WS-RN-NULL-ITEM         PIC S9(04) COMP VALUE -1.        
           05  NULL-DATE               PIC X(10).                       
PCR482     05  WS-TOTAL-PAYMENTS-NI    PIC S9(04) COMP VALUE 0.         
TP9767     05  DATE-CREDIT-ACTION-NI   PIC S9(04) COMP VALUE 0.         
TP9767     05  DATE-NOTICE-MAIL-NI     PIC S9(04) COMP VALUE 0.         
           05  ZERO-AMOUNT             PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-DEP-CRED-AMT-REMAIN  PIC S9(07)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-HOLD-DEP-CRED-AMT-REMAIN  PIC S9(07)V99 USAGE COMP-3  
                                                        VALUE 0.        
           05  WS-AMT-DEPOSIT-NEW      PIC S9(07)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-AMT-TRAN-BAL-REMAIN  PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-AMT-TRAN-BAL         PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-TOTAL-AR-BALANCE     PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
COB305     05 SUMM-AMT-AR-DAY-00        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 SUMM-AMT-AR-DAY-30        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 SUMM-AMT-AR-DAY-60        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 SUMM-AMT-AR-DAY-90        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
           05  SUMM-LAST-UPDATE-TS     PIC X(26).                       
COB305     05 WS-AMT-BILLED        PIC S9(09)V99 USAGE COMP-3 VALUE 0.      
COB305     05 WS-AMT-UNBILLED        PIC S9(09)V99 USAGE COMP-3 VALUE 0.      
           05  WS-DATE-CERT-ISSUE-NEW  PIC X(10) VALUE SPACES.          
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE +1.        
           05  WS-AC-EXISTS            PIC X(01) VALUE 'N'.             
           05  WS-DR-EXISTS            PIC X(01) VALUE 'N'.             
           05  WS-DEP-REQ-EXISTS       PIC X(01) VALUE 'N'.             
           05  WS-DEP-ON-HAND-EXISTS   PIC X(01) VALUE 'N'.             
           05  WS-AC-ROW-DELETED       PIC X(01) VALUE 'N'.             
           05  ACC-ACCT-NO             PIC X(13).                       
           05  ACC-ACCT-NO-NUM         REDEFINES ACC-ACCT-NO            
                                       PIC 9(13).                       
*T5855     05  WS-CURRENT-DATE         PIC X(10).                       
PCR482     05  WS-TOTAL-PAYMENTS       PIC S9(09)V9(2) COMP-3 VALUE 0.  
T14605     05  WS-DEP-DET-FOUND        PIC X(01) VALUE 'N'.             
T21203     05  WS-LAST-UPDATE-TS       PIC X(26).                       
REARCH*    05  SCSCA182                PIC X(08) VALUE 'SCSCA182'.              
REARCH     05  MCSCA182                PIC X(08) VALUE 'MCSCA182'.      
REARCH     05  WS-100                  PIC S9(03)  VALUE 100.           
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02147'.      
REARCH     05  WS-SQLSTATE             PIC X(05).                       
      *                                                                 02293600
      *                                                                 02294000
      ******************************************************************02295000
      * WORKING STORAGE FOR JOURNALING                                 *02296000
      ******************************************************************02297000
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
           05  WS-DATE-ORIG-PYMT-IND   PIC S9(04) COMP.                 
           05  WS-GL-ACCT-NAME         PIC X(10) VALUE 'AR-DEP'.        
           05  WS-GL-ACCT-NAME-2       PIC X(10) VALUE 'DEP-DEP'.       
T18662     05  WS-GL-ACCT-NAME-3       PIC X(10) VALUE 'AR-DFA'.        
      *                                                                 02340000
       01  CASH-DRAWER-JOURNALING.                                      
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO    PIC X(02).                       
               10  WS-CD-LOCAL-OFFICE  PIC X(03).                       
               10  WS-CD-REPORT-NO     PIC X(03).                       
               10  WS-CD-REPORT-DATE   PIC X(10).                       
               10  WS-CASH-DRAWER-ID   PIC S9(04) COMP.                 
           05  WS-GL-EREV-CCC-KEY      PIC X(10) VALUE 'EREV-CCC  '.    
           05  WS-GL-GREV-CCC-KEY      PIC X(10) VALUE 'GREV-CCC  '.    
           05  WS-GL-WREV-CCC-KEY      PIC X(10) VALUE 'WREV-CCC  '.    
COB305     05 WS-GL-ACCT-NO-2        PIC S999V9999 COMP-3 VALUE 0.            
COB305     05 WS-GL-ACCT-NO-3        PIC S999V9999 COMP-3 VALUE 0.            
      *                                                                 02460000
      *                                                                 02470000
      ****************************************************************  02480000
      *                                                                 02490000
REARCH*01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  02500000
      *                                                                 02510000
REARCH*01  PARM-FIELDS.                                                 02520000
REARCH*    05  PARM-L                   PIC S9(9) COMP.                 02530000
REARCH*    05  PARM-ID1                 PIC S9(9) COMP VALUE 1.         02540000
REARCH*                                                                 02550000
REARCH*    05  PARM-ACCOUNT-NO          PIC X(13).                      02560000
REARCH*    05  PARM-SERVICE-TYPE-CD     PIC X(01).                      02570000
REARCH*    05  PARM-DEPOSIT-CERT-NO     PIC X(09).                      02580000
REARCH*    05  PARM-DEPOSIT-CRED-AMT    PIC X(09).                      02590000
REARCH*    05  PARM-REASON              PIC X(1).                       02600000
REARCH*    05  PARM-CODE-REFUND-TYPE    PIC X(1).                       02610000
REARCH*    05  PARM-COMMENTS            PIC X(210).                     02620000
REARCH*    05  PARM-COMMENTS-LEN        PIC X(04).                      02630000
REARCH*    05  PARM-USER-ID-UPDT-BY     PIC X(07).                      02640000
REARCH*    05  PARM-RESP-AREA-ID        PIC X(03).                      02650000
REARCH*    05  PARM-LAST-UPDATE-TS      PIC X(26).                              
      *                                                                 02660000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02680000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP            
                                                        VALUE 0.        
           05  RS-AMT-DEPOSIT          PIC S9(07)V99 VALUE 0 COMP-3.    
           05  RS-AMT-TRAN-BALANCE     PIC S9(09)V99 VALUE 0 COMP-3.    
           05  RS-DEP-CRED-AMT-REMAIN  PIC S9(07)V99 VALUE 0 COMP-3.    
C32206     05  RS-REASON               PIC X(02) VALUE SPACE.           
           05  RS-AR-LOCKOUT-IND       PIC X(01) VALUE SPACE.           
           05  RS-ACCT-XFER-TO         PIC X(13) VALUE SPACE.           
           05  RS-COMMENTS             PIC X(72) VALUE SPACES.          
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(09) USAGE COMP             
REARCH                                                  VALUE 0.        
REARCH     05  S-AMT-DEPOSIT          PIC S9(07)V99 VALUE 0 COMP-3.     
REARCH     05  S-AMT-TRAN-BALANCE     PIC S9(09)V99 VALUE 0 COMP-3.     
REARCH     05  S-DEP-CRED-AMT-REMAIN  PIC S9(07)V99 VALUE 0 COMP-3.     
C32206     05  S-REASON               PIC X(02) VALUE SPACE.            
REARCH     05  S-AR-LOCKOUT-IND       PIC X(01) VALUE SPACE.            
REARCH     05  S-ACCT-XFER-TO         PIC X(13) VALUE SPACE.            
REARCH     05  S-COMMENTS             PIC X(72) VALUE SPACES.           
      *                                                                 02790000
REARCH*01  CN-COLUMN-NAMES.                                             02800000
REARCH*    05  CN-RETURN-CODE          PIC X(11) VALUE                  02810000
REARCH*                                       'RETURN_CODE'.            02820000
REARCH*    05  CN-AMT-DEPOSIT          PIC X(11) VALUE                  02830000
REARCH*                                       'AMT_DEPOSIT'.            02840000
REARCH*    05  CN-AMT-TRAN-BALANCE     PIC X(12) VALUE                  02850000
REARCH*                                       'AMT_TRAN_BAL'.           02860000
REARCH*    05  CN-DEP-CRED-AMT-REMAIN  PIC X(19) VALUE                  02870000
REARCH*                                       'DEP_CRED_AMT_REMAIN'.    02880000
REARCH*    05  CN-REASON               PIC X(06) VALUE                  02890000
REARCH*                                       'REASON'.                 02900000
REARCH*    05  CN-COMMENTS             PIC X(08) VALUE                  02910000
REARCH*                                       'COMMENTS'.               02920000
REARCH*    05  CN-AR-LOCKOUT-IND       PIC X(14) VALUE                  02930000
REARCH*                                       'AR_LOCKOUT_IND'.         02940000
REARCH*    05  CN-ACCT-XFER-TO         PIC X(15) VALUE                  02950000
REARCH*                                       'AT_ACCT_XFER_TO'.        02951000
      *                                                                 02952000
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                 02953000
      ***************************************************************   02954000
      *    WORKING STORAGE AREA FOR REDEFINING PARAMETERS PASSED    *   02955000
      *    IN FROM THE DESKTOP ENVIRONMENT.                         *   02956000
      ***************************************************************   02957000
       01  WS-ACCOUNT-NO-REDEFINITION.                                  
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
      *                                                                 02990000
       01  WS-DEPOSIT-CERT-NO-REDEF.                                    
           05  WS-DEPOSIT-CERT-NO      PIC X(09).                       
           05  WS-DEPOSIT-CERT-NUM REDEFINES WS-DEPOSIT-CERT-NO         
                                       PIC 9(09).                       
           05  WS-DEPOSIT-CERT-NO-NO   PIC S9(09) USAGE COMP.           
      *                                                                 03050000
       01  WS-DEP-CRED-AMT-REDEFINITION.                                
           05  WS-DEPOSIT-CREDIT-AMT   PIC X(09).                       
           05  WS-DEP-CRED-AMT    REDEFINES WS-DEPOSIT-CREDIT-AMT       
                                       PIC 9(07)V99.                    
           05  WS-DEP-CRED-AMT-DEC     PIC S9(07)V99 USAGE COMP-3       
                                                     VALUE +0.          
      *                                                                 03120000
       01  WS-COMMNENT-LEN-REDEFINITION.                                
           05  WS-COMMENT-LEN          PIC X(04).                       
           05  WS-COMMENT-LENGTH REDEFINES WS-COMMENT-LEN               
                                       PIC 9(04).                       
           05  WS-COMMENT-LEN-NO       PIC S9(04) USAGE COMP.           
           05  WS-PANEL-COM-LEN-NO     PIC S9(04) USAGE COMP.           
      *                                                                 03190000
       01  WS-TEMP-FIELD               PIC S9(04) USAGE COMP.           
      *                                                                 03210000
      *                                                                 03220000
T21203 COPY CWS00182.                                                           
HPCCDM*EJECT                                                            03230000
                                                                        
      ******************************************************************03250000
      * CURSOR DECLARATION                                             *03260000
      ******************************************************************03270000
                                                                        
           EXEC SQL                                                     
              DECLARE DEP_REQ CURSOR FOR                                
              SELECT   'Y'                                              
              FROM     CSS_DEP_REQ                                      
              WHERE    ACCOUNT_NO = :WS-ACCOUNT-NO  AND                 
                       PYMT_PRIORITY_LVL = 080                          
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE DEP_ON_HAND CURSOR FOR                            
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND                                  
              WHERE    ACCOUNT_NO = :WS-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD IN ('A', 'P')                  
           END-EXEC.                                                    
                                                                        
*T5855*    EXEC SQL                                                     03312300
*T5855*       DECLARE CL-CURSOR CURSOR FOR                              03312400
*T5855*       SELECT   CODE_NOTICE_TYPE                                 03312500
*T5855*       FROM     CSS_CRED_COLL                                    03312600
*T5855*       WHERE    ACCOUNT_NO = :CL-ACCOUNT-NO  AND                 03312700
*T5855*                ITEM_ID    = :CL-ITEM-ID     AND                 03312800
*T5855*                (CODE_NOTICE_TYPE = 'I' OR                       03312900
*T5855*                 CODE_NOTICE_TYPE = 'O' )                        03313000
*T5855*    END-EXEC.                                                    03313100
                                                                        
      *                                                                 03313300
T21203 LINKAGE SECTION.                                                 
REARCH*01  DFHCOMMAREA                   PIC X(4000).                           
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH 01  PARM-SERVICE-TYPE-CD          PIC X(01).                     
REARCH 01  PARM-DEPOSIT-CERT-NO          PIC X(09).                     
REARCH 01  PARM-DEPOSIT-CRED-AMT         PIC X(09).                     
C32206 01  PARM-REASON                   PIC X(2).                      
REARCH 01  PARM-CODE-REFUND-TYPE         PIC X(1).                      
REARCH 01  PARM-COMMENTS                 PIC X(210).                    
REARCH 01  PARM-COMMENTS-LEN             PIC X(04).                     
REARCH 01  PARM-USER-ID-UPDT-BY          PIC X(07).                     
REARCH 01  PARM-RESP-AREA-ID             PIC X(03).                     
REARCH 01  PARM-LAST-UPDATE-TS           PIC X(26).                     
      *                                                                 03313400
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO,                        
REARCH                          PARM-SERVICE-TYPE-CD,                   
REARCH                          PARM-DEPOSIT-CERT-NO,                   
REARCH                          PARM-DEPOSIT-CRED-AMT,                  
REARCH                          PARM-REASON,                            
REARCH                          PARM-RESP-AREA-ID,                      
REARCH                          PARM-USER-ID-UPDT-BY,                   
REARCH                          PARM-COMMENTS,                          
REARCH                          PARM-COMMENTS-LEN,                      
REARCH                          PARM-CODE-REFUND-TYPE,                  
REARCH                          PARM-LAST-UPDATE-TS.                    
      *                                                                 03313600
      *                                                                 03313700
      ******************************************************************03313800
      * 0000-MAINLINE                                                  *03313900
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03314000
      ******************************************************************03314100
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03380000
      * 0100-INITIALIZE                                                *03390000
      *                                                                *03400000
      *     1. RESET DB2 ERROR HANDLERS                                *03410000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03420000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03430000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03440000
      *                                                                *03450000
      ******************************************************************03460000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03540000
REARCH*                                                                 03550000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03560000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03570000
REARCH*                                                                 03580000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03590000
REARCH*                                                                 03600000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03610000
REARCH*        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM      03620000
REARCH*        MOVE '0100'                        TO ACTIVE-PARAGRAPH   03630000
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION     03640000
REARCH*        MOVE 'CICS TRANSACTION'            TO TABLE-1            03650000
REARCH*        MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE       03660000
REARCH*        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           03670000
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           03680000
REARCH*    END-IF.                                                      03690000
      *                                                                 03700000
REARCH                                                                  
REARCH     EXEC SQL                                                     
A00956         DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR
REARCH         SELECT                                                   
RERACH             :S-RETURN-CODE          AS  RETURN_CODE              
REARCH            ,:S-AMT-DEPOSIT          AS  AMT_DEPOSIT              
REARCH            ,:S-AMT-TRAN-BALANCE     AS  AMT_TRAN_BALANCE         
REARCH            ,:S-DEP-CRED-AMT-REMAIN  AS  DEP_CRED_AMT_REMAI       
REARCH            ,:S-REASON               AS  REASON                   
REARCH            ,LTRIM(RTRIM(:S-COMMENTS))      AS  COMMENTS                 
REARCH            ,:S-AR-LOCKOUT-IND       AS  AR_LOCKOUT_IND           
REARCH            ,LTRIM(RTRIM(:S-ACCT-XFER-TO))  AS  ACCT_XFER_TO             
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*           ,:S-AMT-DEPOSIT          AS  AMT_DEPOSIT                      
MFA-TR*           ,:S-AMT-TRAN-BALANCE     AS  AMT_TRAN_BALANCE                 
MFA-TR*           ,:S-DEP-CRED-AMT-REMAIN  AS  DEP_CRED_AMT_REMAI               
MFA-TR*           ,:S-REASON               AS  REASON                           
MFA-TR*           ,STRIP(:S-COMMENTS)      AS  COMMENTS                         
MFA-TR*           ,:S-AR-LOCKOUT-IND       AS  AR_LOCKOUT_IND                   
MFA-TR*           ,STRIP(:S-ACCT-XFER-TO)  AS  ACCT_XFER_TO                     
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03740000
      * 1000-PROCESS-INPUT                                             *03750000
      *                                                                *03760000
      *     1. RECEIVE PARMS.                                          *03770000
      *                                                                *03780000
      ******************************************************************03790000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               03830000
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03890000
      * 1100-RECEIVE-PARMS                                             *03900000
      *                                                                *03910000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *03920000
      *                                                                *03930000
      ******************************************************************03940000
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              03960000
REARCH*                                                                 03970000
REARCH*                                                                 03980000
REARCH*    MOVE 1                            TO PARM-ID1.               03990000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM,        04000000
REARCH*                                                                 04010000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04020000
REARCH*                          GWL-RC,                                04030000
REARCH*                          PARM-ID1,                              04040000
REARCH*                          PARM-ACCOUNT-NO,                       04050000
REARCH*                          TDSCHAR,                               04060000
REARCH*                          MAX-LENGTH-PARM,                       04070000
REARCH*                          PARM-L.                                04080000
REARCH*                                                                 04090000
REARCH*    ADD 1                               TO PARM-ID1.             04100000
REARCH*    MOVE LENGTH OF PARM-SERVICE-TYPE-CD TO MAX-LENGTH-PARM,      04110000
REARCH*                                                                 04120000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04130000
REARCH*                          GWL-RC,                                04140000
REARCH*                          PARM-ID1,                              04150000
REARCH*                          PARM-SERVICE-TYPE-CD,                  04160000
REARCH*                          TDSCHAR,                               04170000
REARCH*                          MAX-LENGTH-PARM,                       04180000
REARCH*                          PARM-L.                                04190000
REARCH*                                                                 04200000
REARCH*    ADD 1                             TO PARM-ID1.               04210000
REARCH*    MOVE LENGTH OF PARM-DEPOSIT-CERT-NO TO MAX-LENGTH-PARM,      04220000
REARCH*                                                                 04230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04240000
REARCH*                          GWL-RC,                                04250000
REARCH*                          PARM-ID1,                              04260000
REARCH*                          PARM-DEPOSIT-CERT-NO,                  04270000
REARCH*                          TDSCHAR,                               04280000
REARCH*                          MAX-LENGTH-PARM,                       04290000
REARCH*                          PARM-L.                                04300000
REARCH*                                                                 04310000
REARCH*                                                                 04320000
REARCH*    ADD 1                                TO PARM-ID1.            04330000
REARCH*    MOVE LENGTH OF PARM-DEPOSIT-CRED-AMT TO MAX-LENGTH-PARM,     04340000
REARCH*                                                                 04350000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04360000
REARCH*                          GWL-RC,                                04370000
REARCH*                          PARM-ID1,                              04380000
REARCH*                          PARM-DEPOSIT-CRED-AMT,                 04390000
REARCH*                          TDSCHAR,                               04400000
REARCH*                          MAX-LENGTH-PARM,                       04410000
REARCH*                          PARM-L.                                04420000
REARCH*                                                                 04430000
REARCH*    ADD 1                                 TO PARM-ID1.           04440000
REARCH*    MOVE LENGTH OF PARM-REASON            TO MAX-LENGTH-PARM,    04450000
REARCH*                                                                 04460000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04470000
REARCH*                          GWL-RC,                                04480000
REARCH*                          PARM-ID1,                              04490000
REARCH*                          PARM-REASON,                           04500000
REARCH*                          TDSCHAR,                               04510000
REARCH*                          MAX-LENGTH-PARM,                       04520000
REARCH*                          PARM-L.                                04530000
REARCH*                                                                 04540000
REARCH*    ADD 1                               TO PARM-ID1.             04550000
REARCH*    MOVE LENGTH OF PARM-RESP-AREA-ID    TO MAX-LENGTH-PARM,      04560000
REARCH*                                                                 04570000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04580000
REARCH*                          GWL-RC,                                04590000
REARCH*                          PARM-ID1,                              04600000
REARCH*                          PARM-RESP-AREA-ID,                     04610000
REARCH*                          TDSCHAR,                               04620000
REARCH*                          MAX-LENGTH-PARM,                       04630000
REARCH*                          PARM-L.                                04640000
REARCH*                                                                 04650000
REARCH*    ADD 1                               TO PARM-ID1.             04660000
REARCH*    MOVE LENGTH OF PARM-USER-ID-UPDT-BY TO MAX-LENGTH-PARM,      04670000
REARCH*                                                                 04680000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04690000
REARCH*                          GWL-RC,                                04700000
REARCH*                          PARM-ID1,                              04710000
REARCH*                          PARM-USER-ID-UPDT-BY,                  04720000
REARCH*                          TDSCHAR,                               04730000
REARCH*                          MAX-LENGTH-PARM,                       04740000
REARCH*                          PARM-L.                                04750000
REARCH*                                                                 04760000
REARCH*    ADD 1                               TO PARM-ID1.             04770000
REARCH*    MOVE LENGTH OF PARM-COMMENTS        TO MAX-LENGTH-PARM,      04780000
REARCH*                                                                 04790000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04800000
REARCH*                          GWL-RC,                                04810000
REARCH*                          PARM-ID1,                              04820000
REARCH*                          PARM-COMMENTS,                         04830000
REARCH*                          TDSCHAR,                               04840000
REARCH*                          MAX-LENGTH-PARM,                       04850000
REARCH*                          PARM-L.                                04860000
REARCH*                                                                 04870000
REARCH*    ADD 1                               TO PARM-ID1.             04880000
REARCH*    MOVE LENGTH OF PARM-COMMENTS-LEN    TO MAX-LENGTH-PARM,      04890000
REARCH*                                                                 04900000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04910000
REARCH*                          GWL-RC,                                04920000
REARCH*                          PARM-ID1,                              04930000
REARCH*                          PARM-COMMENTS-LEN,                     04940000
REARCH*                          TDSCHAR,                               04950000
REARCH*                          MAX-LENGTH-PARM,                       04960000
REARCH*                          PARM-L.                                04970000
REARCH*                                                                 04980000
REARCH*    ADD 1                                TO PARM-ID1.            04990000
REARCH*    MOVE LENGTH OF PARM-CODE-REFUND-TYPE TO MAX-LENGTH-PARM,     05000000
REARCH*                                                                 05010000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              05020000
REARCH*                          GWL-RC,                                05030000
REARCH*                          PARM-ID1,                              05040000
REARCH*                          PARM-CODE-REFUND-TYPE,                 05050000
REARCH*                          TDSCHAR,                               05060000
REARCH*                          MAX-LENGTH-PARM,                       05070000
REARCH*                          PARM-L.                                05080000
REARCH*                                                                 05090000
REARCH*    ADD 1                                 TO PARM-ID1.           10460300
REARCH*    MOVE LENGTH OF PARM-LAST-UPDATE-TS    TO MAX-LENGTH-PARM.    10460400
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              10460500
REARCH*                          GWL-RC,                                10460600
REARCH*                          PARM-ID1,                              10460700
REARCH*                          PARM-LAST-UPDATE-TS,                   10460800
REARCH*                          TDSCHAR,                               10460900
REARCH*                          MAX-LENGTH-PARM,                       10461000
REARCH*                          PARM-L.                                10461100
REARCH*                                                                 05090000
REARCH*                                                                 05100000
REARCH*1100-EXIT.                                                       05110000
REARCH*    EXIT.                                                        05120000
      *                                                                 05130000
      *                                                                 05140000
      ******************************************************************05150000
      * 1150 ASSIGN-WS-VARS                                            *05160000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05170000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *05180000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *05190000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *05200000
      *        PROCESSING WITHIN THIS PROGRAM.                         *05210000
      ******************************************************************05220000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 05240000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT.                    
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO                  
                                         RN-ACCOUNT-NO.                 
      *                                                                 05280000
           MOVE PARM-DEPOSIT-CERT-NO  TO WS-DEPOSIT-CERT-NO.            
           MOVE WS-DEPOSIT-CERT-NUM   TO WS-DEPOSIT-CERT-NO-NO          
                                         WS-DEPOSIT-CERT-NUMBER.        
      *                                                                 05320000
           MOVE PARM-DEPOSIT-CRED-AMT TO WS-DEPOSIT-CREDIT-AMT.         
      *    DIVIDE 100 INTO WS-DEP-CRED-AMT.                             05340000
           MOVE WS-DEP-CRED-AMT       TO WS-DEP-CRED-AMT-DEC.           
      *                                                                 05360000
           MOVE PARM-COMMENTS-LEN     TO WS-COMMENT-LEN.                
           MOVE WS-COMMENT-LENGTH     TO WS-COMMENT-LEN-NUMBER.         
T21203     INITIALIZE SCSCA182-LINK-RECORD.                             
T21203     MOVE PARM-ACCOUNT-NO       TO SCSCA182-ACCOUNT-NO.           
      *                                                                 05390000
      *                                                                 05400000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05430000
      *                                                                 05440000
      ******************************************************************05450000
      * 2000-PROCESS-OUTPUT.                                           *05460000
      *                                                                *05470000
      *     1. DESCRIBE RESULT SET                                     *05480000
      *     2. GET CURRENT VALUES OF FIELDS THAT WILL BE CHANGED       *05490000
      *     3. UPDATE TABLES                                           *05500000
      *     4. WRITE APPROPRIATE JOURNALS                              *05510000
      *     5. SEND RESULT SET                                         *05520000
      *                                                                *05530000
      ******************************************************************05540000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05560000
                                                                        
*T5855     PERFORM 7500-GET-CURRENT-DATE            THRU 7500-EXIT.     
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT             THRU 2100-EXIT.     05570000
      *                                                                 05580000
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
              MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND        
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO CTR-ROWS                 
REARCH*       PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              05630000
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
T21203     PERFORM 9200-LINK-SCSCA182          THRU 9200-EXIT.          
T21203     IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                      
REARCH*        MOVE ABEND-FILE-LK              TO ABEND-FILE                    
T21203         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
T21203         MOVE SCSCA182-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE 
T21203                                            SQLCODE               
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
REARCH         ADD +1                          TO CTR-ROWS              
T21203         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21203         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21203     ELSE                                                         
T21203         MOVE SCSCA182-LAST-UPDATE-TS    TO WS-LAST-UPDATE-TS     
T21203         IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS              
T21203             NEXT SENTENCE                                        
T21203         ELSE                                                     
T21203             MOVE 5272                   TO RS-RETURN-CODE        
REARCH             PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
REARCH             ADD +1                      TO CTR-ROWS              
REARCH*            PERFORM 8100-SEND-RESULT    THRU 8100-EXIT           10606000
T21203             GO TO 2000-EXIT                                      
T21203         END-IF                                                   
T21203     END-IF.                                                      
T21203*                                                                         
           MOVE WS-ACCOUNT-DEC  TO AT-ACCOUNT-NO.                       
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           IF AT-ACCT-XFER-TO > ZERO                                    
              MOVE 5000 TO RS-RETURN-CODE                               
              MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO          
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO CTR-ROWS                 
REARCH*       PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              05700000
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
      ***  GET CURRENT VALUES IN DB2 TABLES                             05702000
      *                                                                 05703000
           PERFORM 2150-SELECT-DEP-ON-HAND          THRU 2150-EXIT.     
           PERFORM 2730-GET-ACCOUNT-INFO            THRU 2730-EXIT.     
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE AT-TOTAL-AR-BALANCE   TO WS-TOTAL-AR-BALANCE.           
      *                                                                 05708000
      ***  UPDATE TABLES WITH DATA PASSED FROM PANEL063                 05709000
      *                                                                 05710000
C26296     PERFORM 2160-SELECT-RECONNECT            THRU 2160-EXIT.     
C26296     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
C26296        SUBTRACT WS-DEP-CRED-AMT-DEC FROM DL-AMT-TOT-RECONNECT    
C26296        IF DL-AMT-TOT-RECONNECT < 0                               
C26296           MOVE 0               TO DL-AMT-TOT-RECONNECT           
C26296        END-IF                                                    
C26296        PERFORM 7815-UPDATE-RECONNECT        THRU 7815-EXIT       
C26296        IF  DL-AMT-TOT-RECONNECT = 0                              
C26296            MOVE 'Y'            TO WS-RECNCT-AMT-ZERO-UPDT        
C26296        END-IF                                                    
C26296     END-IF.                                                      
           PERFORM 3000-CHECK-OUTSTND-RECVBL        THRU 3000-EXIT.     
           IF (WS-AC-EXISTS = 'N') AND (WS-DR-EXISTS = 'N')             
               PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
               PERFORM 2400-UPDATE-DEPHND-DETAIL        THRU 2400-EXIT  
T21069         PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
T21069         MOVE CURRENT-TIMESTAMP TO AT-LAST-UPDATE-TS              
               PERFORM 2920-UPDATE-AT                   THRU 2920-EXIT  
           ELSE                                                         
               PERFORM 2815-GET-AR-CNTL-INFO            THRU 2815-EXIT  
               PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
               PERFORM 2201-UPDATE-ARCNTL-DETAIL        THRU 2201-EXIT  
               PERFORM 2400-UPDATE-DEPHND-DETAIL        THRU 2400-EXIT  
T21069         PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
T21069         MOVE CURRENT-TIMESTAMP TO AT-LAST-UPDATE-TS              
               PERFORM 2920-UPDATE-AT                   THRU 2920-EXIT  
           END-IF.                                                      
                                                                        
PCR482*    MOVE 'A' TO RN-CHECK-STATUS-CD                               05850000
PCR482*    MOVE ' ' TO RN-CHECK-ISS-REAS-CD.                            05860000
      *                                                                 05861000
           IF DELETE-NOT-PROCESSED                                      
PCR052         PERFORM 4000-INSERT-REFUND           THRU 4000-EXIT      
           END-IF.                                                      
      *                                                                 05880000
           PERFORM 2700-PERFORM-JOURNALING          THRU 2700-EXIT.     
      *                                                                 05900000
      ***  RE-RETRIEVE UPDATED VALUES TO SEND BACK TO PANEL063          05910000
      *                                                                 05920000
           PERFORM 2150-SELECT-DEP-ON-HAND          THRU 2150-EXIT.     
PCR482     MOVE WS-N                  TO WS-DELETE-DEP-SW.              
           IF WS-AC-ROW-DELETED = 'N'                                   
               PERFORM 2815-GET-AR-CNTL-INFO        THRU 2815-EXIT      
           ELSE                                                         
               MOVE 0                       TO AC-AMT-TRAN-BALANCE      
           END-IF.                                                      
                                                                        
*T5855     MOVE WS-ACCOUNT-NO         TO CL-ACCOUNT-NO.                 
*T5855     MOVE WS-DEPOSIT-CERT-NO-NO TO CL-ITEM-ID.                    
*T5855     MOVE 'I'                   TO CL-CODE-NOTICE-TYPE.           
                                                                        
*T5855     PERFORM 7300-SELECT-CRED-COLL    THRU 7300-EXIT.             
*T5855                                                                  
*T5855     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
*T5855        IF CL-DATE-CREDIT-ACTION >= WS-CURRENT-DATE               
T11846           IF WS-AMT-DEPOSIT-NEW <= ZEROES                        
*T5855              PERFORM 7310-DELETE-CRED-COLL  THRU 7310-EXIT       
T11846           ELSE                                                   
T11846              PERFORM 7320-UPDATE-CRED-COLL  THRU 7320-EXIT       
T11846           END-IF                                                 
*T5855        END-IF                                                    
*T5855     END-IF                                                       
                                                                        
*T5855     MOVE 'O'                   TO CL-CODE-NOTICE-TYPE.           
                                                                        
*T5855     PERFORM 7300-SELECT-CRED-COLL    THRU 7300-EXIT.             
*T5855                                                                  
*T5855     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
*T5855        IF CL-DATE-NOTICE-MAIL   >= WS-CURRENT-DATE               
C26296* THERE WILL BE NO MAIL DATE FOR 'O' ROWS CREATED FOR AUTO DNP            
C26296* DEPOSITS. CHECK CODE-SPECIAL-TYPE 'R' AND DEPOSIT TYPE 'B'              
C26296        OR (DO-CODE-DEP-TYPE  = AUTO-DNP-DEPOSIT AND              
C26296             CL-CODE-SPECIAL-TYPE = 'R')                          
T11846           IF WS-AMT-DEPOSIT-NEW <= ZEROES                        
*T5855              PERFORM 7310-DELETE-CRED-COLL  THRU 7310-EXIT       
T11846           ELSE                                                   
T11846              PERFORM 7320-UPDATE-CRED-COLL  THRU 7320-EXIT       
T11846           END-IF                                                 
*T5855        END-IF                                                    
*T5855     END-IF                                                       
      *                                                                 05991000
      ***  SET RETURN PARMS                                             06000000
      *                                                                 06010000
           MOVE DO-AMT-DEPOSIT              TO RS-AMT-DEPOSIT.          
           MOVE AC-AMT-TRAN-BALANCE         TO RS-AMT-TRAN-BALANCE.     
           MOVE WS-DEP-CRED-AMT-REMAIN      TO RS-DEP-CRED-AMT-REMAIN.  
PCR482     MOVE WS-CHECK-ISS-REAS-CD        TO RS-REASON.               
PCR482     MOVE WS-COMMENT-TEXT             TO RS-COMMENTS.             
           MOVE AL-AR-LOCKOUT-IND           TO RS-AR-LOCKOUT-IND.       
           MOVE AT-ACCT-XFER-TO             TO RS-ACCT-XFER-TO.         
      *                                                                 06090000
C26296     IF  RECONNECT-AMT-ZERO-UPDT                                  
C26296         MOVE 200                     TO RS-RETURN-CODE           
C26296     END-IF.                                                      
      *                                                                 06090000
REARCH     PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT.    
REARCH     ADD +1                                   TO CTR-ROWS.        
REARCH*    PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT.     06100000
      *                                                                 06110000
      *                                                                 06120000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06150000
      *                                                                 06160000
      ******************************************************************06170000
      * 2100-DESCRIBE-RESULT                                           *06180000
      *                                                                *06190000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *06200000
      *                                                                *06210000
      ******************************************************************06220000
REARCH*2100-DESCRIBE-RESULT.                                            06230000
REARCH*                                                                 06240000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  06250000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                06260000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              06270000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE        TO WRKLEN1.             06280000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE        TO WRKLEN2.             06290000
REARCH*                                                                 06300000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06310000
REARCH*                          GWL-RC,                                06320000
REARCH*                          CTR-COLUMN,                            06330000
REARCH*                          DB-HOST-TYPE,                          06340000
REARCH*                          WRKLEN1,                               06350000
REARCH*                          RS-RETURN-CODE,                        06360000
REARCH*                          DB-NULL-INDICATOR,                     06370000
REARCH*                          TDS-FALSE,                             06380000
REARCH*                          DB-CLIENT-TYPE,                        06390000
REARCH*                          WRKLEN1,                               06400000
REARCH*                          CN-RETURN-CODE,                        06410000
REARCH*                          WRKLEN2.                               06420000
REARCH*                                                                 06430000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06440000
REARCH*                                                                 06450000
REARCH*    ADD 1        TO CTR-COLUMN.                                  06460000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             06470000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              06480000
REARCH*    MOVE LENGTH OF RS-AMT-DEPOSIT        TO WRKLEN1.             06490000
REARCH*    MOVE LENGTH OF CN-AMT-DEPOSIT        TO WRKLEN2.             06500000
REARCH*                                                                 06510000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06520000
REARCH*                          GWL-RC,                                06530000
REARCH*                          CTR-COLUMN,                            06540000
REARCH*                          DB-HOST-TYPE,                          06550000
REARCH*                          WRKLEN1,                               06560000
REARCH*                          RS-AMT-DEPOSIT,                        06570000
REARCH*                          DB-NULL-INDICATOR,                     06580000
REARCH*                          TDS-FALSE,                             06590000
REARCH*                          DB-CLIENT-TYPE,                        06600000
REARCH*                          WRKLEN1,                               06610000
REARCH*                          CN-AMT-DEPOSIT,                        06620000
REARCH*                          WRKLEN2.                               06630000
REARCH*                                                                 06640000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06650000
REARCH*                                                                 06660000
REARCH*    MOVE +2 TO WRKLEN2.                                          06670000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              06680000
REARCH*                          GWL-RC,                                06690000
REARCH*                          TDS-OBJECT-COL,                        06700000
REARCH*                          CTR-COLUMN,                            06710000
REARCH*                          WRKLEN1,                               06720000
REARCH*                          WRKLEN2.                               06730000
REARCH*                                                                 06740000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06750000
REARCH*                                                                 06760000
REARCH*                                                                 06770000
REARCH*    ADD 1        TO CTR-COLUMN.                                  06780000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             06790000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              06800000
REARCH*    MOVE LENGTH OF RS-AMT-TRAN-BALANCE   TO WRKLEN1.             06810000
REARCH*    MOVE LENGTH OF CN-AMT-TRAN-BALANCE   TO WRKLEN2.             06820000
REARCH*                                                                 06830000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06840000
REARCH*                          GWL-RC,                                06850000
REARCH*                          CTR-COLUMN,                            06860000
REARCH*                          DB-HOST-TYPE,                          06870000
REARCH*                          WRKLEN1,                               06880000
REARCH*                          RS-AMT-TRAN-BALANCE,                   06890000
REARCH*                          DB-NULL-INDICATOR,                     06900000
REARCH*                          TDS-FALSE,                             06910000
REARCH*                          DB-CLIENT-TYPE,                        06920000
REARCH*                          WRKLEN1,                               06930000
REARCH*                          CN-AMT-TRAN-BALANCE,                   06940000
REARCH*                          WRKLEN2.                               06950000
REARCH*                                                                 06960000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06970000
REARCH*                                                                 06980000
REARCH*    MOVE +2 TO WRKLEN2.                                          06990000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              07000000
REARCH*                          GWL-RC,                                07010000
REARCH*                          TDS-OBJECT-COL,                        07020000
REARCH*                          CTR-COLUMN,                            07030000
REARCH*                          WRKLEN1,                               07040000
REARCH*                          WRKLEN2.                               07050000
REARCH*                                                                 07060000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07070000
REARCH*                                                                 07080000
REARCH*    ADD 1        TO CTR-COLUMN.                                  07090000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             07100000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              07110000
REARCH*    MOVE LENGTH OF RS-DEP-CRED-AMT-REMAIN TO WRKLEN1.            07120000
REARCH*    MOVE LENGTH OF CN-DEP-CRED-AMT-REMAIN TO WRKLEN2.            07130000
REARCH*                                                                 07140000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07150000
REARCH*                          GWL-RC,                                07160000
REARCH*                          CTR-COLUMN,                            07170000
REARCH*                          DB-HOST-TYPE,                          07180000
REARCH*                          WRKLEN1,                               07190000
REARCH*                          RS-DEP-CRED-AMT-REMAIN,                07200000
REARCH*                          DB-NULL-INDICATOR,                     07210000
REARCH*                          TDS-FALSE,                             07220000
REARCH*                          DB-CLIENT-TYPE,                        07230000
REARCH*                          WRKLEN1,                               07240000
REARCH*                          CN-DEP-CRED-AMT-REMAIN,                07250000
REARCH*                          WRKLEN2.                               07260000
REARCH*                                                                 07270000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07280000
REARCH*                                                                 07290000
REARCH*    MOVE +2 TO WRKLEN2.                                          07300000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              07310000
REARCH*                          GWL-RC,                                07320000
REARCH*                          TDS-OBJECT-COL,                        07330000
REARCH*                          CTR-COLUMN,                            07340000
REARCH*                          WRKLEN1,                               07350000
REARCH*                          WRKLEN2.                               07360000
REARCH*                                                                 07370000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07380000
REARCH*                                                                 07390000
REARCH*    ADD 1        TO CTR-COLUMN.                                  07400000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                07410000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              07420000
REARCH*    MOVE LENGTH OF RS-REASON TO WRKLEN1.                         07430000
REARCH*    MOVE LENGTH OF CN-REASON TO WRKLEN2.                         07440000
REARCH*                                                                 07450000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07460000
REARCH*                          GWL-RC,                                07470000
REARCH*                          CTR-COLUMN,                            07480000
REARCH*                          DB-HOST-TYPE,                          07490000
REARCH*                          WRKLEN1,                               07500000
REARCH*                          RS-REASON,                             07510000
REARCH*                          DB-NULL-INDICATOR,                     07520000
REARCH*                          TDS-FALSE,                             07530000
REARCH*                          DB-CLIENT-TYPE,                        07540000
REARCH*                          WRKLEN1,                               07550000
REARCH*                          CN-REASON,                             07560000
REARCH*                          WRKLEN2.                               07570000
REARCH*                                                                 07580000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07590000
REARCH*                                                                 07600000
REARCH*    ADD 1        TO CTR-COLUMN.                                  07610000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                07620000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              07630000
REARCH*    MOVE LENGTH OF RS-COMMENTS TO WRKLEN1.                       07640000
REARCH*    MOVE LENGTH OF CN-COMMENTS TO WRKLEN2.                       07650000
REARCH*                                                                 07660000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07670000
REARCH*                          GWL-RC,                                07680000
REARCH*                          CTR-COLUMN,                            07690000
REARCH*                          DB-HOST-TYPE,                          07700000
REARCH*                          WRKLEN1,                               07710000
REARCH*                          RS-COMMENTS,                           07720000
REARCH*                          DB-NULL-INDICATOR,                     07730000
REARCH*                          TDS-FALSE,                             07740000
REARCH*                          DB-CLIENT-TYPE,                        07750000
REARCH*                          WRKLEN1,                               07760000
REARCH*                          CN-COMMENTS,                           07770000
REARCH*                          WRKLEN2.                               07780000
REARCH*                                                                 07790000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07800000
REARCH*                                                                 07810000
REARCH*    ADD 1        TO CTR-COLUMN.                                  07820000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                07830000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              07831000
REARCH*    MOVE LENGTH OF RS-AR-LOCKOUT-IND TO WRKLEN1.                 07832000
REARCH*    MOVE LENGTH OF CN-AR-LOCKOUT-IND TO WRKLEN2.                 07833000
REARCH*                                                                 07834000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07835000
REARCH*                          GWL-RC,                                07836000
REARCH*                          CTR-COLUMN,                            07837000
REARCH*                          DB-HOST-TYPE,                          07838000
REARCH*                          WRKLEN1,                               07839000
REARCH*                          RS-AR-LOCKOUT-IND,                     07839100
REARCH*                          DB-NULL-INDICATOR,                     07839200
REARCH*                          TDS-FALSE,                             07839300
REARCH*                          DB-CLIENT-TYPE,                        07839400
REARCH*                          WRKLEN1,                               07839500
REARCH*                          CN-AR-LOCKOUT-IND,                     07839600
REARCH*                          WRKLEN2.                               07839700
REARCH*                                                                 07839800
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07839900
REARCH*                                                                 07840000
REARCH*    ADD 1        TO CTR-COLUMN.                                  07840100
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                07840200
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              07840300
REARCH*    MOVE LENGTH OF RS-ACCT-XFER-TO TO WRKLEN1.                   07840400
REARCH*    MOVE LENGTH OF CN-ACCT-XFER-TO TO WRKLEN2.                   07840500
REARCH*                                                                 07840600
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07840700
REARCH*                          GWL-RC,                                07840800
REARCH*                          CTR-COLUMN,                            07840900
REARCH*                          DB-HOST-TYPE,                          07841000
REARCH*                          WRKLEN1,                               07841100
REARCH*                          RS-ACCT-XFER-TO,                       07841200
REARCH*                          DB-NULL-INDICATOR,                     07841300
REARCH*                          TDS-FALSE,                             07841400
REARCH*                          DB-CLIENT-TYPE,                        07841500
REARCH*                          WRKLEN1,                               07841600
REARCH*                          CN-ACCT-XFER-TO,                       07841700
REARCH*                          WRKLEN2.                               07841800
REARCH*                                                                 07841900
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07842000
REARCH*                                                                 07843000
REARCH*2100-EXIT.                                                       07844000
REARCH*    EXIT.                                                        07845000
      *                                                                 07846000
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-AMT-DEPOSIT         TO S-AMT-DEPOSIT.                
REARCH     MOVE RS-AMT-TRAN-BALANCE    TO S-AMT-TRAN-BALANCE.           
REARCH     MOVE RS-DEP-CRED-AMT-REMAIN TO S-DEP-CRED-AMT-REMAIN.        
REARCH     MOVE RS-REASON              TO S-REASON.                     
REARCH     MOVE RS-AR-LOCKOUT-IND      TO S-AR-LOCKOUT-IND.             
REARCH     MOVE RS-ACCT-XFER-TO        TO S-ACCT-XFER-TO.               
REARCH     MOVE RS-COMMENTS            TO S-COMMENTS.                   
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************07847000
      * 2150-SELECT-DEP-ON-HAND                                        *07848000
      *     -- GET CURRENT VALUES IN DB2                               *07849000
      ******************************************************************07850000
       2150-SELECT-DEP-ON-HAND.                                         
      *                                                                 07870000
           EXEC SQL                                                     
               SELECT AMT_DEPOSIT,                                      
                      DATE_CERT_ISSUE,                                  
                      DATE_REFUNDED,                                    
                      AMT_REFUNDED,                                     
                      CODE_REFUND_REASON,                               
                      COMMENTS                                          
C26296               ,CODE_DEP_TYPE                                     
                 INTO :DO-AMT-DEPOSIT,                                  
                      :DO-DATE-CERT-ISSUE :WS-NULL-IND-1,               
                      :DO-DATE-REFUNDED :WS-NULL-IND-2,                 
                      :DO-AMT-REFUNDED,                                 
                      :DO-CODE-REFUND-REASON,                           
                      :DO-COMMENTS                                      
C26296               ,:DO-CODE-DEP-TYPE                                 
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND DEPOSIT_CERT_NO = :WS-DEPOSIT-CERT-NO-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08050000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 08070000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               IF WS-NULL-IND-1 < ZERO                                  
                   MOVE LOW-VALUES TO DO-DATE-CERT-ISSUE                
               END-IF                                                   
               IF WS-NULL-IND-2 < ZERO                                  
                   MOVE LOW-VALUES TO DO-DATE-REFUNDED                  
               END-IF                                                   
           ELSE                                                         
             IF SQLCODE EQUAL NOT-FOUND AND DELETE-WAS-PROCESSED        
              NEXT SENTENCE                                             
             ELSE                                                       
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
             END-IF                                                     
           END-IF.                                                      
      *                                                                 08250000
       2150-EXIT.                                                       
           EXIT.                                                        
C26296******************************************************************10381000
      * 2160-SELECT-RECONNECT                                          *10382000
      *     -- THIS MODULE PERFORMS A CHECK ON CSS_DEP_ON_HAND &       *10383000
      *        CSS_DEP_REQ AND CSS_RECONNECT FOR BILL IMMEDIATE AUTO   *10384000
      *        DNP DEPOSIT.                                            *        
      *        IF IT EXISTS, WS-DEP-CRED-AMT-DEC WILL BE SUBTRACTED    *10385000
      *        FROM CSS_RECONNECT.                                     *10386000
      ******************************************************************10389000
C26296 2160-SELECT-RECONNECT.                                           
      *                                                                 10389200
           MOVE WS-ACCOUNT-NO               TO DL-ACCOUNT-NO.           
      *                                                                 10389400
           EXEC SQL                                                     
               SELECT DL.AMT_TOT_RECONNECT                              
C26296               ,DL.AUTO_DEP_CERT_NO                               
               INTO   :DL-AMT-TOT-RECONNECT                             
C26296               ,:DL-AUTO-DEP-CERT-NO                              
               FROM   CSS_RECONNECT DL,                                 
                      CSS_DEP_REQ DR,                                   
                      CSS_DEP_ON_HAND AS DO                             
               WHERE  DL.ACCOUNT_NO         = :DL-ACCOUNT-NO            
               AND    DL.AUTO_DEP_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO    
               AND    DL.AUTO_DEP_CERT_NO   =  DO.DEPOSIT_CERT_NO       
               AND    DL.ACCOUNT_NO         =  DO.ACCOUNT_NO            
               AND    DO.CODE_DEP_TYPE      = :AUTO-DNP-DEPOSIT         
               AND    DL.AUTO_DEP_CERT_NO   =  DR.DEP_ITEM_ID           
               AND    DL.ACCOUNT_NO         =  DR.ACCOUNT_NO            
               AND    DR.DEP_BILL_OPTION_CD = :IMMEDIATE-BILL           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10390800
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '2160'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_RECONNECT'              TO TABLE-1              
              MOVE 'CSS_DEP_REQ'                TO TABLE-2              
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-3              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
              MOVE DL-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE DL-AUTO-DEP-CERT-NO          TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10393300
C26296 2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08280000
      *                                                                 08290000
      ******************************************************************08300000
      *2201-UPDATE-ARCNTL-DETAIL.                                      *08310000
      *    -- THIS MODULE UPDATES THE AMT_TRAN_BALANCE DEPENDING ON    *08320000
      *       THE DEPOSIT CRED AMT.                                    *08330000
      ******************************************************************08340000
       2201-UPDATE-ARCNTL-DETAIL.                                       
                                                                        
           PERFORM 7000-SELECT-AR-CNTL-SUMM   THRU 7000-EXIT.           
           ADD AC-AMT-AR-DAY-00, AC-AMT-AR-DAY-30,                      
               AC-AMT-AR-DAY-60, AC-AMT-AR-DAY-90                       
               GIVING WS-AMT-BILLED.                                    
           SUBTRACT WS-AMT-BILLED    FROM AC-AMT-TRAN-BALANCE           
               GIVING WS-AMT-UNBILLED.                                  
           MOVE WS-DEP-CRED-AMT-DEC   TO WS-DEP-CRED-AMT-REMAIN.        
                                                                        
T18662     MOVE 0 TO WS-HOLD-DEP-CRED-AMT-REMAIN.                       
      *--- REDUCE THE UNBILLED AMOUNT                                   08432000
           IF WS-AMT-UNBILLED > WS-DEP-CRED-AMT-REMAIN                  
              SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-AMT-UNBILLED      
              MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                          
           ELSE                                                         
              SUBTRACT WS-AMT-UNBILLED FROM WS-DEP-CRED-AMT-REMAIN      
T18662        IF WS-AMT-UNBILLED    NOT = ZERO                          
T18662           MOVE WS-DEP-CRED-AMT-REMAIN TO                         
T18662                                       WS-HOLD-DEP-CRED-AMT-REMAIN
T18662        END-IF                                                    
              MOVE 0 TO WS-AMT-UNBILLED                                 
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 90 DAY A/R                                        08450000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-90 > 0       
             IF AC-AMT-AR-DAY-90 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-90   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-90 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-90 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-90 FROM SUMM-AMT-AR-DAY-90       
                SUBTRACT AC-AMT-AR-DAY-90 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-90                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 60 DAY A/R                                        08521700
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-60 > 0       
             IF AC-AMT-AR-DAY-60 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-60   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-60 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-60 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-60 FROM SUMM-AMT-AR-DAY-60       
                SUBTRACT AC-AMT-AR-DAY-60 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-60                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 30 DAY A/R                                        08524100
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-30 > 0       
             IF AC-AMT-AR-DAY-30 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-30   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-30 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-30 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-30 FROM SUMM-AMT-AR-DAY-30       
                SUBTRACT AC-AMT-AR-DAY-30 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-30                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 00 DAY A/R                                        08540000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-00 > 0       
             IF AC-AMT-AR-DAY-00 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-00   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-00 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-00 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-00 FROM SUMM-AMT-AR-DAY-00       
                SUBTRACT AC-AMT-AR-DAY-00 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-00                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 8200-UPDATE-AR-CNTL-SUMM    THRU 8200-EXIT.          
                                                                        
           SUBTRACT WS-DEP-CRED-AMT-DEC FROM AC-AMT-TRAN-BALANCE        
           IF AC-AMT-TRAN-BALANCE = 0                                   
               EXEC SQL                                                 
                   DELETE FROM CSS_AR_CNTL                              
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    
                      AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    
                      AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )        
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 08640000
MFA-TR*            DELETE FROM CSS_AR_CNTL                              08650000
MFA-TR*             WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            08660000
MFA-TR*               AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    08670000
MFA-TR*               AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    08680000
MFA-TR*               AND LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS        08690000
MFA-TR*        END-EXEC                                                 08700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE                  TO RS-RETURN-CODE          
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF SQLCODE EQUAL TO SUCCESSFUL-CALL                      
                  MOVE 'Y' TO WS-AC-ROW-DELETED                         
                                                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '2201'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
CBSI              MOVE SPACES                TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                  MOVE 'CSS_AR_CNTL'         TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2         
                  MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2       
                  MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3         
                  MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3       
CBSI              MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-4         
CBSI              MOVE AC-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-4       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
T14605         PERFORM 8300-SELECT-ARCNTL    THRU 8300-EXIT             
T14605         IF WS-DEP-DET-FOUND = 'N'                                
T14605            PERFORM 8400-DELETE-SUMMARY THRU 8400-EXIT            
T14605         END-IF                                                   
           ELSE                                                         
               EXEC SQL                                                 
                   UPDATE CSS_AR_CNTL                                   
                      SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,     
                          LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP(),        
                          AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,        
                          AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,        
                          AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,        
                          AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90         
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    
                      AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    
                      AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )        
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 08910000
MFA-TR*            UPDATE CSS_AR_CNTL                                   08920000
MFA-TR*               SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,     08930000
MFA-TR*                   LAST_UPDATE_TS    = CURRENT TIMESTAMP,        08940000
MFA-TR*                   AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,        08950000
MFA-TR*                   AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,        08960000
MFA-TR*                   AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,        08970000
MFA-TR*                   AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90         08980000
MFA-TR*             WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            08990000
MFA-TR*               AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    09000000
MFA-TR*               AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    09010000
MFA-TR*               AND LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS        09020000
MFA-TR*        END-EXEC                                                 09030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09040000
               MOVE SQLCODE                  TO RS-RETURN-CODE          
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
      *                                                                 09070000
               IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                
                   (SQLCODE EQUAL TO NOT-FOUND))                        
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '2201'                TO ACTIVE-PARAGRAPH        
                  MOVE 'UPDATE'              TO ABEND-FUNCTION          
CBSI              MOVE SPACES                TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                  MOVE 'CSS_AR_CNTL'         TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2         
                  MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2       
                  MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3         
                  MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3       
CBSI              MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-4         
CBSI              MOVE AC-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-4       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09260000
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09290000
      *                                                                 09300000
      ******************************************************************09310000
      *2400-UPDATE-DEPHND-DETAIL.                                      *09320000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *09330000
      *       CSS_DEP_ON_HAND TABLE.                                   *09340000
      ******************************************************************09350000
       2400-UPDATE-DEPHND-DETAIL.                                       
      *                                                                 09370000
           SUBTRACT WS-DEP-CRED-AMT-DEC FROM DO-AMT-DEPOSIT             
               GIVING WS-AMT-DEPOSIT-NEW.                               
                                                                        
PCR482     MOVE WS-ACCOUNT-NO       TO DP-ACCOUNT-NO.                   
PCR482     MOVE WS-DEPOSIT-CERT-NO-NO                                   
PCR482                              TO DP-DEPOSIT-CERT-NO.              
                                                                        
PCR482     PERFORM 7990-SELECT-DEP-PAY-AMT           THRU 7990-EXIT.    
                                                                        
PCR482     IF WS-AMT-DEPOSIT-NEW = 0                                    
             IF WS-TOTAL-PAYMENTS > ZEROES                              
               EXEC SQL                                                 
                   UPDATE CSS_DEP_ON_HAND                               
PCR482             SET  DEPOSIT_STATUS_CD   = 'R'                       
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO    
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09409900
               MOVE SQLCODE                  TO RS-RETURN-CODE          
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
      *                                                                 09410200
               IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '2400'                TO ACTIVE-PARAGRAPH        
                  MOVE 'UPDATE'              TO ABEND-FUNCTION          
CBSI              MOVE SPACES                TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                  MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2         
                  MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
             ELSE                                                       
               PERFORM 2500-DELETE-DEPOSIT           THRU 2500-EXIT     
             END-IF                                                     
           ELSE                                                         
PCR482       IF WS-AMT-DEPOSIT-NEW = WS-TOTAL-PAYMENTS                  
               EXEC SQL                                                 
                   UPDATE CSS_DEP_ON_HAND                               
                      SET DATE_CERT_ISSUE = CAST(SYSDATETIMEOFFSET() 
           AS DATE),               
PCR482*               DATE_REFUNDED       = CURRENT DATE,               09450000
PCR482*               CODE_REFUND_STATUS  = '0',                        09460000
PCR482                DEPOSIT_STATUS_CD   = 'P'                         
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO    
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*        EXEC SQL                                                 09420000
MFA-TR*            UPDATE CSS_DEP_ON_HAND                               09430000
MFA-TR*               SET DATE_CERT_ISSUE = CURRENT DATE,               09440000
MFA-TR*               DATE_REFUNDED       = CURRENT DATE,               09450000
MFA-TR*               CODE_REFUND_STATUS  = '0',                        09460000
MFA-TR*               DEPOSIT_STATUS_CD   = 'P'                         09470000
MFA-TR*             WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            09480000
MFA-TR*               AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO    09490000
MFA-TR*        END-EXEC                                                 09500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09510000
               MOVE SQLCODE                  TO RS-RETURN-CODE          
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
      *                                                                 09540000
               IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '2400'                TO ACTIVE-PARAGRAPH        
                  MOVE 'UPDATE'              TO ABEND-FUNCTION          
CBSI              MOVE SPACES                TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                  MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2         
                  MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF DELETE-NOT-PROCESSED                                      
             ADD  WS-DEP-CRED-AMT-DEC    TO DO-AMT-REFUNDED             
                                                                        
             EXEC SQL                                                   
               UPDATE CSS_DEP_ON_HAND                                   
                  SET AMT_DEPOSIT        = :WS-AMT-DEPOSIT-NEW,         
                      AMT_REFUNDED       = :DO-AMT-REFUNDED,            
PCR482*               CODE_REFUND_REASON = :PARM-REASON,                09750000
PCR482*               CODE_REFUND_TYPE   = :PARM-CODE-REFUND-TYPE,      09760000
                      CODE_REFUND_FROM   = 'B',                         
                      USER_ID_UPDT_BY    = :PARM-USER-ID-UPDT-BY        
                WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO               
                  AND DEPOSIT_CERT_NO    =  :WS-DEPOSIT-CERT-NO-NO      
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09820000
             MOVE SQLCODE                TO RS-RETURN-CODE              
             MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE       
      *                                                                 09850000
             IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                  
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2400'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2            
CBSI           MOVE 'AMT_DEPOSIT'         TO TABLE-ELEMENT-3            
CBSI           MOVE 'AMT_REFUNDED'        TO TABLE-ELEMENT-4            
               MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2          
CBSI           MOVE WS-AMT-DEPOSIT-NEW    TO HOSTVAR-ELEMENT-3-N        
CBSI           MOVE DO-AMT-REFUNDED       TO HOSTVAR-ELEMENT-4-N        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
      *                                                                 09980000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10020000
      *                                                                 10030000
PCR482******************************************************************10031000
PCR482* 2500-DELETE-DEPOSIT                                            *10032000
PCR482*    -- THIS MODULE DELETES A DEPOSIT WHEN THE AMOUNT IS FORGIVEN*10033000
PCR482*       AND NO PAYMENTS HAVE BEEN MADE.                          *10034000
      ******************************************************************10035000
PCR482 2500-DELETE-DEPOSIT.                                             
      *                                                                 10037000
PCR482     MOVE WS-Y                TO WS-DELETE-DEP-SW.                
      *                                                                 10037200
PCR482     MOVE WS-ACCOUNT-NO       TO DO-ACCOUNT-NO,                   
PCR482                                 DR-ACCOUNT-NO.                   
      *                                                                 10037500
PCR482     MOVE WS-DEPOSIT-CERT-NO-NO                                   
PCR482                              TO DO-DEPOSIT-CERT-NO,              
PCR482                                 DR-DEP-ITEM-ID.                  
      *                                                                 10037900
PCR482     MOVE +80                 TO DR-PYMT-PRIORITY-LVL.            
      *                                                                 10038200
PCR482     PERFORM 7800-DELETE-DEP-ON-HAND           THRU 7800-EXIT.    
C26296     IF WS-ACTIVE-RETURN-CODE          = SUCCESSFUL-CALL          
C26296        PERFORM 7805-UPDATE-NSF-HIST           THRU 7805-EXIT     
P00599        MOVE WS-DEPOSIT-CERT-NO-NO TO WS-DEPOSIT-CERT-NUM         
P00599        MOVE 'DEP-CERT-NO'         TO 1K-CORRESP-VAR-NM           
P00599        MOVE WS-DEPOSIT-CERT-NO    TO 1K-CORRESP-VAR-NUM          
P00599        MOVE AT-ACCOUNT-NO         TO 1J-ACCOUNT-NO               
P00599        MOVE 'I'                   TO 1J-CORRESP-STATUS-CD        
P00599        PERFORM 8000-GET-CORRESP-ID    THRU 8000-EXIT             
P00599        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00599           MOVE 'C'                TO 1J-CORRESP-STATUS-CD        
P00599           PERFORM 8100-UPDATE-CORRESP-HDR                        
P00599                                       THRU 8100-EXIT             
P00599           PERFORM 8500-DELETE-CORRESP-HDR                        
P00599                                       THRU 8500-EXIT             
P00599        END-IF                                                    
C26296     END-IF.                                                      
PCR482     PERFORM 7810-DELETE-DEP-REQ               THRU 7810-EXIT.    
      *                                                                 10039500
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10040000
      * 2700-PERFORM-JOURNALING.                                       *10050000
      *    -- THIS MODULE PREPARES WORKING STORAGE VARIABLES FOR THE   *10060000
      *       JOURNALING PROCESSING THAT IS TO BE COMPLETED AS A       *10070000
      *       RESULT OF UPDATING A DEPOSIT ON HAND RECORD.             *10080000
      ******************************************************************10090000
       2700-PERFORM-JOURNALING.                                         
      *                                                                 10110000
           PERFORM 2710-GET-TIMESTAMP-AND-DATE        THRU 2710-EXIT.   
           PERFORM 2720-GET-RESP-AREA-ID              THRU 2720-EXIT.   
           PERFORM 2740-GET-GL-ACCT                   THRU 2740-EXIT.   
           PERFORM 2741-GET-GL-ACCT-2                 THRU 2741-EXIT.   
T18662     PERFORM 2742-GET-GL-ACCT-3                 THRU 2742-EXIT.   
                                                                        
      *--- ASSIGN DUMMY CASH DRAWER VALUES                              10170000
           MOVE '01'                       TO WS-CD-COMPANY-NO.         
           MOVE '998'                      TO WS-CD-LOCAL-OFFICE.       
           MOVE '998'                      TO WS-CD-REPORT-NO.          
           MOVE CURRENT-DATE               TO WS-CD-REPORT-DATE.        
           MOVE 9999                       TO WS-CASH-DRAWER-ID.        
                                                                        
           PERFORM 2750-AR-TRANS-JOURNALING           THRU 2750-EXIT.   
           PERFORM 2760-CASH-DRAWER-101               THRU 2760-EXIT.   
      *                                                                 10260000
      *                                                                 10270000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10300000
      *                                                                 10310000
      ******************************************************************10320000
      * 2710-GET-TIMESTAMP-AND-DATE.                                   *10330000
      *   -- THIS MODULE OBTAINS THE CURRENT TIME AND DATE FOR CRATING *10340000
      *      THE JOURNAL ENTRIES.                                      *10350000
      ******************************************************************10360000
       2710-GET-TIMESTAMP-AND-DATE.                                     
      *                                                                 10380000
      *    EXEC SQL                                                     10390000
      *        SELECT CURRENT TIMESTAMP,                                10400000
      *               CURRENT DATE                                      10410000
      *          INTO :CURRENT-TIMESTAMP,                               10420000
      *               :CURRENT-DATE                                     10430000
      *          FROM CSS_MODEL_SQL                                     10440000
      *    END-EXEC.                                                    10450000
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :CURRENT-TIMESTAMP               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10470000
MFA-TR*       SET :CURRENT-TIMESTAMP =  CURRENT TIMESTAMP               10480000
MFA-TR*    END-EXEC.                                                    10490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10510000
MFA-TR*       SET :CURRENT-DATE  =  CURRENT DATE                        10520000
MFA-TR*    END-EXEC.                                                    10530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2710'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CURRENT TIMESTAMP'   TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE  CURRENT-TIMESTAMP    TO HOSTVAR-ELEMENT-1           
CBSI          MOVE  PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 10670000
      *                                                                 10680000
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10710000
      *                                                                 10720000
      ******************************************************************10730000
      * 2720-GET-RESP-AREA-ID                                          *10740000
      *    -- THIS MODULE OBTAINS THE USER'S RESPONSIBLE AREA ID.      *10750000
      ******************************************************************10760000
        2720-GET-RESP-AREA-ID.                                          
      *                                                                 10780000
           EXEC SQL                                                     
               SELECT RESP_AREA_ID,                                     
                      CASH_DRAWER                                       
                 INTO :PF-RESP-AREA-ID,                                 
                      :PF-CASH-DRAWER                                   
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PARM-USER-ID-UPDT-BY                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10870000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 10900000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2720'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-USER-ID-UPDT-BY  TO HOSTVAR-ELEMENT-1           
CBSI          MOVE  PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 11010000
      *                                                                 11020000
       2720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11050000
      *                                                                 11060000
      ******************************************************************11070000
      * 2730-GET-ACCOUNT-INFO                                          *11080000
      *    -- THIS MODULE OBTAINS INFORMATION ON A SPECIFIC ACCOUNT    *11090000
      ******************************************************************11100000
       2730-GET-ACCOUNT-INFO.                                           
      *                                                                 11120000
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
                      CODE_COMPANY_ACCT,                                
                      CODE_ACCT_STAT,                                   
                      PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      DATE_LAST_ACTION,                                 
                      LOCAL_OFFICE,                                     
                      ACCOUNT_NO,                                       
                      TOTAL_AR_BALANCE,                                 
                      CODES_DATA_PRESENT                                
                 INTO :AT-COMPANY-NO,                                   
                      :AT-CODE-COMPANY-ACCT,                            
                      :AT-CODE-ACCT-STAT,                               
                      :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-DATE-LAST-ACTION,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-ACCOUNT-NO,                                   
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODES-DATA-PRESENT                            
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11370000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 11400000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2730'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 11510000
      *                                                                 11520000
       2730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11550000
      *                                                                 11560000
      ******************************************************************11570000
      * 2740-GET-GL-ACCT                                               *11580000
      *    -- THIS MODULE OBTAINS THE GL ACCOUNT NUMBER FOR A DEPOSIT  *11590000
      ******************************************************************11600000
       2740-GET-GL-ACCT.                                                
      *                                                                 11620000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO                                    
MCR310*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     11670000
MCR310          WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11700000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 11730000
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO GO-GL-ACCT-NO               
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2740'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
              MOVE WS-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
CBSI          MOVE  PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 11900000
      *                                                                 11910000
       2740-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11940000
      *                                                                 11950000
      ******************************************************************11960000
      * 2741-GET-GL-ACCT-2                                             *11970000
      *    -- THIS MODULE OBTAINS THE OFFSET GL ACCOUNT NUMBER         *11980000
      *       FOR A DEPOSIT.                                           *11990000
      ******************************************************************12000000
       2741-GET-GL-ACCT-2.                                              
      *                                                                 12020000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :WS-GL-ACCT-NO-2                                  
                 FROM CSS_GL_ACCT_NO                                    
MCR310*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     12070000
MCR310          WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME-2                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12100000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 12130000
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO WS-GL-ACCT-NO-2             
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2741'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
CBSI          MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-1             
CBSI          MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
CBSI          MOVE WS-GL-ACCT-NAME-2     TO HOSTVAR-ELEMENT-1           
CBSI          MOVE '01'                  TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 12280000
      *                                                                 12290000
       2741-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12320000
T18662******************************************************************11960000
T18662* 2742-GET-GL-ACCT-3                                             *11970000
T18662*    -- THIS MODULE OBTAINS THE AR-DFA    ACCOUNT NUMBER.        *11980000
T18662******************************************************************12000000
T18662 2742-GET-GL-ACCT-3.                                              
      *                                                                 12020000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :WS-GL-ACCT-NO-3                                  
                 FROM CSS_GL_ACCT_NO                                    
MCR310*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     12070000
MCR310          WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME-3                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12100000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 12130000
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO WS-GL-ACCT-NO-3             
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2742'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE WS-GL-ACCT-NAME-3     TO HOSTVAR-ELEMENT-1           
              MOVE '01'                  TO HOSTVAR-ELEMENT-2           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 12290000
T18662 2742-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12330000
      ******************************************************************12340000
      * 2750-AR-TRANS-JOURNALING.                                      *12350000
      *     -- THIS MODULE WRITES AN A/R TRANSACTION JOURNAL           *12360000
      ******************************************************************12370000
       2750-AR-TRANS-JOURNALING.                                        
      *                                                                 12390000
           MOVE WS-ACCOUNT-NO              TO AR-ACCOUNT-NO             
                                              AU-ACCOUNT-NO.            
           MOVE CURRENT-TIMESTAMP          TO AR-TRANS-HIST-SEQ-NO      
                                              AU-TRANS-HIST-SEQ-NO.     
           MOVE CURRENT-DATE               TO AR-DATE-TRANS.            
           MOVE WS-TOTAL-AR-BALANCE        TO AR-AMT-BILLED-UNPAID.     
           MOVE PF-RESP-AREA-ID            TO AR-RESP-AREA-ID.          
T17762     MOVE 'PANEL063'                 TO AR-APPL-PROGRAM-ID.       
           MOVE VALUE-SPACES               TO AR-PYMT-FACILITY-CD.      
           MOVE PARM-USER-ID-UPDT-BY       TO AR-USER-ID.               
           MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
           MOVE PARM-COMMENTS              TO AR-TRAN-COMMENT-TEXT.     
03/12      MOVE WS-COMMENT-LEN-NUMBER      TO AR-TRAN-COMMENT-LEN.      
           MOVE VALUE-SPACES               TO AR-RECORD-ONLY-FL.        
           MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
      *                                                                 12570000
           MOVE WS-CD-COMPANY-NO           TO AR-CASH-COMPANY-NO.       
           MOVE WS-CD-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.     
           MOVE WS-CD-REPORT-NO            TO AR-CASH-REPORT-NO.        
           MOVE WS-CD-REPORT-DATE          TO AR-DATE-CASH-REPORT.      
           MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
      *                                                                 12630000
      ***  RECORD PORTION THAT HAS BEEN PAID                            12640000
           MOVE 1                          TO AU-TRAN-APPL-NO.          
           MOVE WS-DEPOSIT-CERT-NO-NO      TO AU-ITEM-ID.               
           MOVE VALUE-SPACES               TO AU-CODE-AR-AGE            
                                              AU-CODE-CONTRACT-TYPE.    
           MOVE ' '                        TO AU-CURRENCY-TYPE.         
      *                                                                 12740000
T18662     IF WS-HOLD-DEP-CRED-AMT-REMAIN  >  ZERO                      
T18662         MOVE 'A'                         TO AR-CODE-TRAN-TYPE    
T18662         MOVE WS-HOLD-DEP-CRED-AMT-REMAIN TO AR-AMT-ORIG-ENTERED  
T18662                                             AU-CURRENCY-AMT      
T18662                                             AU-AMT-POSTED        
T18662         MOVE WS-GL-ACCT-NO-3             TO AU-GL-ACCT-CREDIT    
T18662         MOVE GO-GL-ACCT-NO               TO AU-GL-ACCT-DEBIT     
T18662         PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST    THRU 6500-EXIT  
T18662         PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
               MOVE CURRENT-TIMESTAMP      TO AR-TRANS-HIST-SEQ-NO      
                                              AU-TRANS-HIST-SEQ-NO
           END-IF.     
      *                                                                 12760000
PCR402     MOVE 'I'                        TO AR-CODE-TRAN-TYPE.        
T18662     MOVE WS-DEP-CRED-AMT-DEC        TO AR-AMT-ORIG-ENTERED       
T18662                                        AU-CURRENCY-AMT           
                                              AU-AMT-POSTED.            
           MOVE GO-GL-ACCT-NO              TO AU-GL-ACCT-CREDIT.        
           MOVE WS-GL-ACCT-NO-2            TO AU-GL-ACCT-DEBIT.         
      *                                                                 12740000
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST      THRU 6500-EXIT.   
      *                                                                 12770000
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12800000
      *                                                                 12810000
      ******************************************************************12820000
      * 2755-SET-100-JRNL-VARS.                                        *12830000
      *     -- THIS MODULE SETS UP ALL 100 CODE WORKING STORAGE        *12840000
      *        VARIABLES THAT ARE USED IN THE CASH AND MISCELLANEOUS   *12850000
      *        JOURNALING PROCESS.                                     *12860000
      ******************************************************************12870000
       2755-SET-100-JRNL-VARS.                                          
      *                                                                 12890000
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00020 *****       12900000
      ***** (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.*****       12910000
      *                                                                 12920000
           MOVE 9                          TO WS-TRAN-OPER-LEVEL.       
           MOVE 1                          TO WS-TRAN-OCAP-FIELD.       
           MOVE 1                          TO WS-TRAN-OCAP-VALUE.       
           MOVE 'C'                        TO WS-TRAN-JRNL-TYPE         
           MOVE 'N'                        TO WS-TRAN-HOLD-EXEMPT-FLAG. 
      *                                                                 12980000
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00021 *****       12990000
      ***** (PARAGRAPH 5980) TO VERIFY USER-ID.             *****       13000000
      *                                                                 13010000
           MOVE PARM-USER-ID-UPDT-BY       TO WS-JRNL-OL-TEMP-ID.       
           MOVE WS-JRNL-CK-OPER-ID         TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 13050000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 13120000
           MOVE WS-JRNL-OL-OPR-LOC         TO WS-TERM-LOC.              
      *                                                                 13140000
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00022 *****       13150000
      ***** (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL. *****       13160000
      *                                                                 13170000
      *    IF WS-JRNL-OL-CASH-DRWR-CHECK EQUAL SPACES                   13180000
      *       MOVE 'A'                     TO WS-CASH-DRAWER-ID         13190000
      *    ELSE                                                         13200000
      *       MOVE WS-JRNL-OL-CASH-DRWR-ID TO WS-CASH-DRAWER-ID.        13210000
      *    MOVE WS-CASH-DRAWER             TO WS-JRNL-OL-CASH-DRWR.     13220000
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
                                                                        
           MOVE WS-CD-COMPANY-NO           TO WS-JRNL-OL-COMPANY.       
           MOVE WS-CD-LOCAL-OFFICE         TO WS-JRNL-OL-LOC-OFF.       
           MOVE WS-CD-REPORT-NO            TO WS-JRNL-OL-REPORT-NO.     
           MOVE WS-CD-REPORT-DATE          TO WS-JRNL-OL-REPORT-DT.     
           MOVE WS-CASH-DRAWER-ID          TO WS-JRNL-OL-CASH-DRWR.     
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER      TO WS-JRNL-OPERATION-RQST.   
           MOVE 'C'                        TO WS-JRNL-SOURCE-CODE.      
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 13400000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 13470000
      *                                                                 13480000
REARCH*    MOVE EIBTRNID                TO WS-100-CODE-TERMINAL-TRAN.   13490000
PRDFIX     MOVE 'S147'                  TO WS-100-CODE-TERMINAL-TRAN.   
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE AT-COMPANY-NO           TO WS-100-COMPANY-NO.           
           MOVE AT-ACCOUNT-NO           TO WS-100-ACCT-NO.              
           MOVE AT-CUSTOMER-NO          TO WS-100-CUSTOMER-NO.          
           MOVE AT-PREMISE-NO           TO WS-100-PREMISE-NO.           
           MOVE AT-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE 1                       TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE AT-DATE-LAST-ACTION     TO WS-100-DATE-LAST-ACTION.     
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
      *                                                                 13610000
      *                                                                 13620000
       2755-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13650000
      *                                                                 13660000
      ******************************************************************13670000
      * 2760-CASH-DRAWER-101.                                          *13680000
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *13690000
      ******************************************************************13700000
       2760-CASH-DRAWER-101.                                            
      *                                                                 13720000
           PERFORM 2770-GET-CUSTOMER-INFO             THRU 2770-EXIT.   
           PERFORM 2780-GET-PREMISE-INFO              THRU 2780-EXIT.   
           PERFORM 2755-SET-100-JRNL-VARS             THRU 2755-EXIT.   
      *                                                                 13760000
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
      *    IF PF-CASH-DRAWER = SPACES                                   13780000
      *        MOVE 'A'                 TO WS-101-CASH-DRAWER-USED      13790000
      *    ELSE                                                         13800000
ECC   *        MOVE PF-CASH-DRAWER      TO WS-CASH-DRAWER               13810000
ECC        MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE WS-DEP-CRED-AMT-DEC     TO WS-101-AMOUNT-ENTERED        
                                           WS-101-AMT-POSTED.           
           MOVE AU-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE AU-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE AU-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE CURRENT-DATE            TO WS-101-DATE-AR-BILLED.       
           MOVE WS-DEPOSIT-CERT-NO-NO   TO WS-101-ITEM-ID-NO            
           MOVE AC-AMT-TRAN-BALANCE     TO WS-101-DETAIL-END-BAL        
           ADD  AC-AMT-AR-DAY-00, AC-AMT-AR-DAY-30,                     
                AC-AMT-AR-DAY-60, AC-AMT-AR-DAY-90                      
                GIVING  WS-101-DETAIL-END-AR-BAL.                       
           MOVE AT-TOTAL-AR-BALANCE     TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
           MOVE AU-AMT-POSTED           TO WS-JRNL-GEN-LEG-DEBIT-AMT    
                                           WS-JRNL-RCV-CREDIT-AMT.      
      *                                                                 14030000
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
      *                                                                 14050000
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 14080000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 14150000
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 14180000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 14250000
      *                                                                 14260000
       2760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14290000
      *                                                                 14300000
      ******************************************************************14310000
      * 2770-GET-CUSTOMER-INFO.                                        *14320000
      *    -- THIS MODULE OBTAINS THE EMPLOYEE ACCOUNT CODE.           *14330000
      ******************************************************************14340000
       2770-GET-CUSTOMER-INFO.                                          
      *                                                                 14360000
           EXEC SQL                                                     
               SELECT CODE_EMPL_ACCT                                    
                 INTO :CU-CODE-EMPL-ACCT                                
                 FROM CSS_CUSTOMER                                      
                WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14430000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 14460000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2770'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 14570000
       2770-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14600000
      *                                                                 14610000
      ******************************************************************14620000
      * 2780-GET-PREMISE-INFO.                                         *14630000
      *    -- THIS MODULE OBTAINS THE REVENUE DISTRICT AND THE         *14640000
      *       PREMISE ACCOUNT CODE.                                    *14650000
      ******************************************************************14660000
       2780-GET-PREMISE-INFO.                                           
      *                                                                 14680000
           EXEC SQL                                                     
               SELECT REV_DISTRICT_CD,                                  
                      CODE_PREMISE_STAT                                 
                 INTO :PR-REV-DISTRICT-CD,                              
                      :PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE                                       
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14770000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 14800000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2780'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
CBSI          MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 14910000
       2780-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14940000
      *                                                                 14950000
      ******************************************************************14960000
      * 2815-GET-AR-CNTL-INFO.                                         *14970000
      *     -- THIS MODULE GETS THE AGING BUCKET INFORMATION FROM THE  *14980000
      *        DEPOSIT RECORD IN THE CSS_AR_CNTL TABLE.                *14990000
      ******************************************************************15000000
       2815-GET-AR-CNTL-INFO.                                           
      *                                                                 15020000
           EXEC SQL                                                     
               SELECT AMT_TRAN_BALANCE,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90                                     
                 INTO :AC-AMT-TRAN-BALANCE,                             
                      :AC-LAST-UPDATE-TS,                               
                      :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90                                 
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        
                  AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15030000
MFA-TR*        SELECT AMT_TRAN_BALANCE,                                 15040000
MFA-TR*               LAST_UPDATE_TS,                                   15050000
MFA-TR*               AMT_AR_DAY_00,                                    15060000
MFA-TR*               AMT_AR_DAY_30,                                    15070000
MFA-TR*               AMT_AR_DAY_60,                                    15080000
MFA-TR*               AMT_AR_DAY_90                                     15090000
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE,                             15100000
MFA-TR*               :AC-LAST-UPDATE-TS,                               15110000
MFA-TR*               :AC-AMT-AR-DAY-00,                                15120000
MFA-TR*               :AC-AMT-AR-DAY-30,                                15130000
MFA-TR*               :AC-AMT-AR-DAY-60,                                15140000
MFA-TR*               :AC-AMT-AR-DAY-90                                 15150000
MFA-TR*          FROM CSS_AR_CNTL                                       15160000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                15170000
MFA-TR*           AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        15180000
MFA-TR*           AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO        15190000
MFA-TR*    END-EXEC.                                                    15200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15210000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 15240000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2815'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE  DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2          
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE  WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       2815-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15440000
      * 2920-UPDATE-AT.                                                *15450000
      *    -- THIS MODULE UPDATES THE TOTAL_AR_BALANCE FOR             *15460000
      *       THIS ACCOUNT TO THE CSS_ACCOUNT TABLE.                   *15470000
      ******************************************************************15480000
       2920-UPDATE-AT.                                                  
      *                                                                 15500000
           PERFORM 2930-CHECK-DEP-PRESENT    THRU 2930-EXIT.            
           MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT.    
           MOVE WS-TOTAL-AR-BALANCE        TO AT-TOTAL-AR-BALANCE.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,        
                      CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,      
T21069                LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )           
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15550000
MFA-TR*        UPDATE CSS_ACCOUNT                                       15560000
MFA-TR*           SET TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,        15570000
MFA-TR*               CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,      15580000
MFA-TR*               LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                   
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       15590000
MFA-TR*    END-EXEC.                                                    15600000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15610000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 15640000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2920'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'TOTAL_AR_BALANCE'    TO TABLE-ELEMENT-2             
CBSI          MOVE 'CODES_DATA_PRESENT'  TO TABLE-ELEMENT-3             
T21069        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-4             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE AT-TOTAL-AR-BALANCE   TO HOSTVAR-ELEMENT-2-N         
CBSI          MOVE AT-CODES-DATA-PRESENT TO HOSTVAR-ELEMENT-3           
T21069        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 15750000
      *                                                                 15760000
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15790000
      ******************************************************************15800000
      * 2930-CHECK-DEP-PRESENT                                         *15810000
      *    -- THIS MODULE CHECKS IF ANY DEP_REQ AND DEP_ON_HAND RECORD *15820000
      *       PRESENT TO UPDATE THE CODES_DATA_PRESENT OF CSS_ACCOUNT  *15830000
      ******************************************************************15840000
       2930-CHECK-DEP-PRESENT.                                          
                                                                        
           PERFORM 7100-OPEN-DEP-REQ         THRU 7100-EXIT.            
           PERFORM 7110-FETCH-DEP-REQ        THRU 7110-EXIT.            
           PERFORM 7120-CLOSE-DEP-REQ        THRU 7120-EXIT.            
                                                                        
           IF WS-DEP-REQ-EXISTS = 'N'                                   
              MOVE SPACES         TO WS-CODE-DEP-REQ                    
           END-IF.                                                      
                                                                        
           PERFORM 7200-OPEN-DEP-ON-HAND     THRU 7200-EXIT.            
           PERFORM 7210-FETCH-DEP-ON-HAND    THRU 7210-EXIT.            
           PERFORM 7220-CLOSE-DEP-ON-HAND    THRU 7220-EXIT.            
                                                                        
           IF WS-DEP-ON-HAND-EXISTS = 'N'                               
              MOVE SPACES          TO WS-CODE-DEP-ON-HAND               
           END-IF.                                                      
                                                                        
       2930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 16060000
      ******************************************************************16070000
      * 3000-CHECK-OUTSTND-RECVBL                                      *16080000
      *    -- THIS MODULE CHECKS IF THERE ARE ROW ON AR_CNTL AND       *16090000
      *       DEP_REQ.  IF THERE ARE NO ROWS ON EITHER, THE DEPOSIT    *16100000
      *       HAS BEEN PAID ALREADY.  IF THERE ARE ROWS ON BOTH,       *16110000
      *       NOTHING HAS BEEN PAID ON THE DEPOSIT.                    *16120000
      ******************************************************************16130000
       3000-CHECK-OUTSTND-RECVBL.                                       
           EXEC SQL                                                     
                SELECT 'Y'                                              
                INTO :WS-AC-EXISTS                                      
                FROM CSS_AR_CNTL                                        
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL =  80                           
                  AND ITEM_ID           =  :WS-DEPOSIT-CERT-NO-NO       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = NOT-FOUND                                       
               MOVE 'N'   TO WS-AC-EXISTS
           END-IF.                              
           IF SQLCODE EQUAL TO SUCCESSFUL-CALL                          
                                     OR NOT-FOUND                       
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'ITEM_ID'             TO TABLE-ELEMENT-2             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                INTO :WS-DR-EXISTS                                      
                FROM CSS_DEP_REQ                                        
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL =  80                           
                  AND DEP_ITEM_ID       =  :WS-DEPOSIT-CERT-NO-NO       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = NOT-FOUND                                       
               MOVE 'N'   TO WS-DR-EXISTS
           END-IF.                              
           IF SQLCODE EQUAL TO SUCCESSFUL-CALL                          
                                     OR NOT-FOUND                       
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 80                    TO HOSTVAR-ELEMENT-2           
              MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-3             
              MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 16740000
      *                                                                 16750000
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR052****************************************************************  16790000
PCR052* 4000-INSERT-REFUND                                           *  16800000
PCR052*     -- THIS MODULES GETS THE REFUND ITEM NUMBER AND POPULATES*  16810000
PCR052*        FIELDS REQUIRED FOR INSERT INTO CSS_REFUND.           *  16820000
PCR052****************************************************************  16830000
PCR052 4000-INSERT-REFUND.                                              
PCR052                                                                  
PCR052     MOVE '0'                   TO WS-ORIGINAL-CHECK-NO           
PCR052                                   WS-REFUND-CHECK-NO.            
PCR052     MOVE 'P063'                TO WS-PANEL-NO.                   
PCR052     MOVE PARM-REASON           TO WS-RETURNED-REASON             
PCR052     MOVE SPACES                TO WS-USER-ID-APPRVD-BY.          
PCR052     MOVE PARM-USER-ID-UPDT-BY  TO WS-USER-ID-RQSTED-BY.          
PCR482     MOVE PARM-CODE-REFUND-TYPE TO WS-MANUAL-INDICATOR.           
T17634     IF WS-COMMENT-LEN-NUMBER    > +72                            
T17634         MOVE +72 TO WS-COMMENT-LEN-NUMBER                        
T17634         MOVE PARM-COMMENTS(1:72)     TO WS-COMMENT-TEXT          
T17634     ELSE                                                         
T17634         MOVE PARM-COMMENTS     TO WS-COMMENT-TEXT                
T17634     END-IF.                                                      
PCR482     MOVE PARM-REASON           TO WS-CHECK-ISS-REAS-CD.          
PCR052     MOVE WS-DEP-CRED-AMT-DEC   TO WS-AMT-REFUND.                 
PCR052     MOVE CURRENT-DATE          TO WS-DATE-REFUNDED.              
PCR052     MOVE AT-LOCAL-OFFICE       TO WS-LOCAL-OFF.                  
PCR052     MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM.             
PCR052     MOVE 0                     TO WS-ADDRESS-ID.                 
T10315     MOVE SPACES                TO RN-CHECK-STATUS-CD.            
PCR052     PERFORM 5950-INSERT-REFUND THRU 5950-EXIT.                   
PCR052                                                                  
PCR052 4000-EXIT.                                                       
PCR052     EXIT.                                                        
PCR052                                                                  
      ******************************************************************17060000
      * 7000-SELECT-AR-CNTL-SUMM                                       *17070000
      *     -- THIS MODULE GETS THE AGING BUCKET INFORMATION FROM THE  *17080000
      *        SUMMARY RECORD IN THE CSS_AR_CNTL TABLE.                *17090000
      ******************************************************************17100000
       7000-SELECT-AR-CNTL-SUMM.                                        
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90                                     
                 INTO :SUMM-LAST-UPDATE-TS,                             
                      :SUMM-AMT-AR-DAY-00,                              
                      :SUMM-AMT-AR-DAY-30,                              
                      :SUMM-AMT-AR-DAY-60,                              
                      :SUMM-AMT-AR-DAY-90                               
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        
                  AND ITEM_ID           = 0                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17130000
MFA-TR*        SELECT LAST_UPDATE_TS,                                   17140000
MFA-TR*               AMT_AR_DAY_00,                                    17150000
MFA-TR*               AMT_AR_DAY_30,                                    17160000
MFA-TR*               AMT_AR_DAY_60,                                    17170000
MFA-TR*               AMT_AR_DAY_90                                     17180000
MFA-TR*          INTO :SUMM-LAST-UPDATE-TS,                             17190000
MFA-TR*               :SUMM-AMT-AR-DAY-00,                              17200000
MFA-TR*               :SUMM-AMT-AR-DAY-30,                              17210000
MFA-TR*               :SUMM-AMT-AR-DAY-60,                              17220000
MFA-TR*               :SUMM-AMT-AR-DAY-90                               17230000
MFA-TR*          FROM CSS_AR_CNTL                                       17240000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                17250000
MFA-TR*           AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        17260000
MFA-TR*           AND ITEM_ID           = 0                             17270000
MFA-TR*    END-EXEC.                                                    17280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO RS-RETURN-CODE,             
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE  DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2          
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE  0                    TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 17394400
      *                                                                 17394500
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17394900
      * 7100-OPEN-DEP-REQ                                              *17395000
      *      OPEN THE CURSOR TO SELECT DEP_REQ DETAILS FOR A GIVEN     *17395100
      *      ACCOUNT-NO WITH PAYMENT PRIORITY = 80                     *17395200
      ******************************************************************17395300
                                                                        
       7100-OPEN-DEP-REQ.                                               
                                                                        
           EXEC SQL                                                     
                OPEN DEP_REQ                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE '7100'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'          TO TABLE-ELEMENT-2      
              MOVE 80                           TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-DEP-REQ.                                              
                                                                        
           EXEC SQL                                                     
                FETCH  DEP_REQ     INTO                                 
                       :WS-DEP-REQ-EXISTS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-DEP-REQ-EXISTS                       
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7110'                       TO ACTIVE-PARAGRAPH     
              MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT-PRIORITY-LVL'          TO TABLE-ELEMENT-2      
              MOVE '080'                        TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-DEP-REQ.                                              
                                                                        
           EXEC SQL                                                     
                CLOSE DEP_REQ                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7120'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_REQ'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'          TO TABLE-ELEMENT-2      
              MOVE '080'                        TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17403000
      * 7200-OPEN-DEP-ON-HAND                                          *17403100
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *17403200
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A' OR 'P'               *17403300
      ******************************************************************17403400
                                                                        
       7200-OPEN-DEP-ON-HAND.                                           
                                                                        
           EXEC SQL                                                     
                OPEN DEP_ON_HAND                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE '7200'                       TO ACTIVE-PARAGRAPH     
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-DEP-ON-HAND.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DEP_ON_HAND INTO                                 
                       :WS-DEP-ON-HAND-EXISTS                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-DEP-ON-HAND-EXISTS                   
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7210'                       TO ACTIVE-PARAGRAPH     
              MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-DEP-ON-HAND.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE DEP_ON_HAND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7220'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
*T5855 7300-SELECT-CRED-COLL.                                           
*T5855                                                                  
*T5855     EXEC SQL                                                     
*T5855          SELECT DATE_CREDIT_ACTION,                              
*T5855                 DATE_NOTICE_MAIL                                 
C26296                ,CODE_SPECIAL_TYPE                                
TP9767          INTO   :CL-DATE-CREDIT-ACTION :DATE-CREDIT-ACTION-NI,    
TP9767                 :CL-DATE-NOTICE-MAIL :DATE-NOTICE-MAIL-NI         
C26296                ,:CL-CODE-SPECIAL-TYPE                            
*T5855          FROM   CSS_CRED_COLL                                    
*T5855          WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
*T5855                 ITEM_ID          = :CL-ITEM-ID    AND            
*T5855                 CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
*T5855     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

*T5855                                                                  
*T5855     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
*T5855     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP9767        IF DATE-CREDIT-ACTION-NI < ZEROES                         
TP9767           MOVE SPACES                    TO CL-DATE-CREDIT-ACTION
TP9767        END-IF                                                    
TP9767        IF DATE-NOTICE-MAIL-NI < ZEROES                           
TP9767           MOVE SPACES                    TO CL-DATE-NOTICE-MAIL  
TP9767        END-IF                                                    
TP9767     ELSE                                                         
TP9767        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
TP9767           NEXT SENTENCE                                          
*T5855        ELSE                                                      
CBSI             MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
*T5855           MOVE '7300'                    TO ACTIVE-PARAGRAPH     
*T5855           MOVE 'SELECT'                  TO ABEND-FUNCTION       
CBSI             MOVE SPACES                    TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
*T5855           MOVE 'CSS_CRED_COLL'           TO TABLE-1              
*T5855           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
*T5855           MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2      
*T5855           MOVE 'CODE_NOTICE_TYPE'        TO TABLE-ELEMENT-3      
*T5855           MOVE CL-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
*T5855           MOVE CL-ITEM-ID                TO HOSTVAR-ELEMENT-2    
*T5855           MOVE CL-CODE-NOTICE-TYPE       TO HOSTVAR-ELEMENT-3    
*T5855           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
*T5855           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
TP9767        END-IF                                                    
*T5855     END-IF.                                                      
*T5855                                                                  
*T5855 7300-EXIT.                                                       
*T5855     EXIT.                                                        
                                                                        
                                                                        
*T5855 7310-DELETE-CRED-COLL.                                           
*T5855                                                                  
*T5855     EXEC SQL                                                     
*T5855          DELETE FROM CSS_CRED_COLL                               
*T5855          WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
*T5855                 ITEM_ID          = :CL-ITEM-ID    AND            
*T5855                 CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
*T5855     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

*T5855                                                                  
*T5855     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
*T5855     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
*T5855        NEXT SENTENCE                                             
*T5855     ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
*T5855        MOVE '7310'                       TO ACTIVE-PARAGRAPH     
*T5855        MOVE 'DELETE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
*T5855        MOVE 'CSS_CRED_COLL'              TO TABLE-1              
*T5855        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
*T5855        MOVE 'ITEM_ID'                    TO TABLE-ELEMENT-2      
*T5855        MOVE 'CODE_NOTICE_TYPE'           TO TABLE-ELEMENT-3      
*T5855        MOVE CL-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
*T5855        MOVE CL-ITEM-ID                   TO HOSTVAR-ELEMENT-2    
*T5855        MOVE CL-CODE-NOTICE-TYPE          TO HOSTVAR-ELEMENT-3    
*T5855        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
*T5855        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
*T5855     END-IF.                                                      
*T5855                                                                  
*T5855 7310-EXIT.                                                       
*T5855     EXIT.                                                        
                                                                        
T11846 7320-UPDATE-CRED-COLL.                                           
                                                                        
T11846     EXEC SQL                                                     
                UPDATE CSS_CRED_COLL                                    
                SET    AMT_NOTICE       = :WS-AMT-DEPOSIT-NEW           
                WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO AND            
                       ITEM_ID          = :CL-ITEM-ID    AND            
                       CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T11846     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7320'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_CRED_COLL'              TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE 'ITEM_ID'                    TO TABLE-ELEMENT-2      
              MOVE 'CODE_NOTICE_TYPE'           TO TABLE-ELEMENT-3      
CBSI          MOVE 'AMT_NOTICE'                 TO TABLE-ELEMENT-4      
              MOVE CL-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE CL-ITEM-ID                   TO HOSTVAR-ELEMENT-2    
              MOVE CL-CODE-NOTICE-TYPE          TO HOSTVAR-ELEMENT-3    
CBSI          MOVE WS-AMT-DEPOSIT-NEW           TO HOSTVAR-ELEMENT-4-N  
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
T11846 7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
*T5855 7500-GET-CURRENT-DATE.                                           
*T5855                                                                  
*T5855     EXEC SQL                                                     
*T5855          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
*T5855     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     17421200
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     17421300
MFA-TR*    END-EXEC.                                                    17421400
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
*T5855 7500-EXIT.                                                       
*T5855     EXIT.                                                        
                                                                        
PCR482****************************************************************  17421900
PCR482* 7800-DELETE-DEP-ON-HAND                                      *  17422000
PCR482*  - THIS MODULE WILL DELETE THE CURRENT DEPOSIT FROM CSS_DEP_ *  17422100
PCR482*    ON_HAND.                                                  *  17422200
PCR482****************************************************************  17422300
      *                                                                 17422400
PCR482 7800-DELETE-DEP-ON-HAND.                                         
                                                                        
PCR482     EXEC SQL                                                     
PCR482          DELETE FROM CSS_DEP_ON_HAND                             
PCR482          WHERE  ACCOUNT_NO       = :DO-ACCOUNT-NO AND            
PCR482                 DEPOSIT_CERT_NO  = :DO-DEPOSIT-CERT-NO           
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR482     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR482     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR482        NEXT SENTENCE                                             
PCR482     ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
PCR482        MOVE '7800'                       TO ACTIVE-PARAGRAPH     
PCR482        MOVE 'DELETE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
PCR482        MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
PCR482        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
PCR482        MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2      
PCR482        MOVE DO-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
PCR482        MOVE DO-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2    
PCR482        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
PCR482        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
PCR482     END-IF.                                                      
PCR482                                                                  
PCR482 7800-EXIT.                                                       
PCR482     EXIT.                                                        
                                                                        
C26296****************************************************************  17421900
      * 7805-UPDATE-NSF-HIST                                         *  17422000
      *  - THIS MODULE WILL UPDATE DEPOSIT-CERT-NO ON NSF_HIST WHEN  *  17422100
      *    FOR ON DEP_ON_HAND IS DELETED.                            *  17422200
      ****************************************************************  17422300
C26296 7805-UPDATE-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NSF_HIST                                      
               SET  DEPOSIT_CERT_NO     = 0                             
                WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                
                  AND DEPOSIT_CERT_NO   = :DO-DEPOSIT-CERT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09409900
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 09410200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7805'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DO-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
C26296 7805-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
PCR482****************************************************************  17425100
PCR482* 7810-DELETE-DEP-REQ                                          *  17425200
PCR482*  - THIS MODULE WILL DELETE THE CURRENT DEPOSIT FROM CSS_DEP_ *  17425300
PCR482*    REQ.                                                      *  17425400
PCR482****************************************************************  17425500
      *                                                                 17425600
PCR482 7810-DELETE-DEP-REQ.                                             
                                                                        
PCR482     EXEC SQL                                                     
PCR482          DELETE FROM CSS_DEP_REQ                                 
PCR482          WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO AND           
PCR482                 PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL AND    
PCR482                 DEP_ITEM_ID       = :DR-DEP-ITEM-ID              
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR482     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR482     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR482        NEXT SENTENCE                                             
PCR482     ELSE                                                         
CBSI          MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
PCR482        MOVE '7810'                       TO ACTIVE-PARAGRAPH     
PCR482        MOVE 'DELETE'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
PCR482        MOVE 'CSS_DEP_REQ'                TO TABLE-1              
PCR482        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
PCR482        MOVE 'PYMT_PRIORITY_LVL'          TO TABLE-ELEMENT-2      
PCR482        MOVE 'DEP_ITEM_ID'                TO TABLE-ELEMENT-3      
PCR482        MOVE DR-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
PCR482        MOVE DR-PYMT-PRIORITY-LVL         TO HOSTVAR-ELEMENT-2    
PCR482        MOVE DR-DEP-ITEM-ID               TO HOSTVAR-ELEMENT-3    
PCR482        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
PCR482        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
PCR482     END-IF.                                                      
PCR482                                                                  
PCR482 7810-EXIT.                                                       
PCR482     EXIT.                                                        
                                                                        
C26296****************************************************************  17421900
      * 7815-UPDATE-RECONNECT                                        *  17422000
      *  - THIS MODULE WILL UPDATE AMT-TOT-RECONNECT ON CSS_RECONNECT*  17422100
      ****************************************************************  17422300
C26296 7815-UPDATE-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RECONNECT                                     
               SET AMT_TOT_RECONNECT   = :DL-AMT-TOT-RECONNECT          
                WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                 
                  AND AUTO_DEP_CERT_NO = :DL-AUTO-DEP-CERT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09409900
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 09410200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7815'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DL-AUTO-DEP-CERT-NO   TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
C26296 7815-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ***************************************************************** 17433300
      * 7990-SELECT-DEP-PAY-AMT                                       * 17433400
      *                                                               * 17433500
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 17433600
      ***************************************************************** 17433700
      *                                                                 17433800
PCR482 7990-SELECT-DEP-PAY-AMT.                                         
      *                                                                 17434000
PCR482     EXEC SQL                                                     
PCR482        SELECT   SUM(DEP_PAY_AMT)                                 
PCR482          INTO   :WS-TOTAL-PAYMENTS :WS-TOTAL-PAYMENTS-NI          
PCR482          FROM   CSS_DEP_PAY_HST                                  
PCR482         WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
PCR482           AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17434800
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 17435000
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PCR482         IF WS-TOTAL-PAYMENTS-NI < 0                              
PCR482             MOVE ZEROES      TO WS-TOTAL-PAYMENTS                
PCR482         END-IF                                                   
PCR482     ELSE                                                         
CBSI           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
PCR482         MOVE '7990'                       TO ACTIVE-PARAGRAPH    
PCR482         MOVE 'SELECT'                     TO ABEND-FUNCTION      
CBSI           MOVE SPACES                       TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
PCR482         MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1             
PCR482         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
CBSI           MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2     
PCR482         MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
CBSI           MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2   
PCR482         PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
PCR482         PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
PCR482     END-IF.                                                      
      *                                                                 17436500
PCR482 7990-EXIT.                                                       
PCR482     EXIT.                                                        
                                                                        
P00599******************************************************************13310000
P00599*8000-GET-CORRESP-ID.                                            *13320000
P00599*    -- THIS MODULE SELECTS THE CORRESPONDING ID FOR CERTIFICATE *13330000
P00599*       NUMBER .                                                 *13340000
P00599******************************************************************13350000
P00599 8000-GET-CORRESP-ID.                                             
P00599*                                                                 13370000
P00599     EXEC SQL                                                     
P00599         SELECT A.CORRESP_ID                                      
P00599         INTO   :1J-CORRESP-ID                                    
P00599         FROM   CSS_CORRESP_HDR A                                 
P00599               ,CSS_CORRESP_VAR B                                 
P00599         WHERE  A.ACCOUNT_NO         = :1J-ACCOUNT-NO             
P00599         AND    A.CORRESP_STATUS_CD  = :1J-CORRESP-STATUS-CD      
P00599         AND    B.CORRESP_VAR_NM     = :1K-CORRESP-VAR-NM         
P00599         AND    B.CORRESP_VAR_NUM    = :1K-CORRESP-VAR-NUM        
P00599         AND    A.CORRESP_ID         = B.CORRESP_ID               
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 13480000
P00599     MOVE SQLCODE                  TO RS-RETURN-CODE              
P00599                                      WS-ACTIVE-RETURN-CODE.      
P00599*                                                                 13510000
P00599     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
P00599        OR NOT-FOUND                                              
P00599         CONTINUE                                                 
P00599     ELSE                                                         
P00599        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8000'                TO ACTIVE-PARAGRAPH            
P00599        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00599        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CSS_CORRESP_VAR'     TO TABLE-2                     
P00599        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00599        MOVE 'CORRESP_VAR_NM'      TO TABLE-ELEMENT-2             
P00599        MOVE 'CORRESP_VAR_CHAR'    TO TABLE-ELEMENT-3             
P00599        MOVE 1J-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00599        MOVE 1K-CORRESP-VAR-NM     TO HOSTVAR-ELEMENT-2           
P00599        MOVE 1K-CORRESP-VAR-CHAR   TO HOSTVAR-ELEMENT-3           
P00599        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00599     END-IF.                                                      
P00599*                                                                 13620000
P00599*                                                                 13630000
P00599 8000-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 13660000
P00599*                                                                 13670000
P00599******************************************************************13310000
P00599*8100-UPDATE-CORRESP-HDR.                                        *13320000
P00599*    -- THIS MODULE UPDATES AN CORRESP_STATUS_CD TO 'C' FOR THE  *13330000
P00599*       CORRESP_ID ON CSS_CORRESP_HDR TABLE.                     *13340000
P00599******************************************************************13350000
P00599 8100-UPDATE-CORRESP-HDR.                                         
P00599*                                                                 13370000
P00599     EXEC SQL                                                     
P00599         UPDATE CSS_CORRESP_HDR                                   
P00599            SET CORRESP_STATUS_CD = :1J-CORRESP-STATUS-CD         
P00599               ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
P00599          WHERE CORRESP_ID        = :1J-CORRESP-ID                
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     13380000
MFA-TR*        UPDATE CSS_CORRESP_HDR                                   13390000
MFA-TR*           SET CORRESP_STATUS_CD = :1J-CORRESP-STATUS-CD         13400000
MFA-TR*              ,LAST_UPDATE_TS    = CURRENT TIMESTAMP             13400000
MFA-TR*         WHERE CORRESP_ID        = :1J-CORRESP-ID                13450000
MFA-TR*    END-EXEC.                                                    13470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 13480000
P00599     MOVE SQLCODE                  TO RS-RETURN-CODE              
P00599                                      WS-ACTIVE-RETURN-CODE.      
P00599*                                                                 13510000
P00599     IF SQLCODE = SUCCESSFUL-CALL                                 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8100'                TO ACTIVE-PARAGRAPH            
P00599        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00599        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
P00599        MOVE 1J-CORRESP-ID         TO HOSTVAR-ELEMENT-1           
P00599        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00599     END-IF.                                                      
P00599*                                                                 13620000
P00599*                                                                 13630000
P00599 8100-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 13660000
P00599*                                                                 13670000
      ***************************************************************** 17436900
      * 8200-UPDATE-AR-CNTL-SUMM                                      * 17437000
      *                                                               * 17437100
      *     UPDATE THE SUMMARY RECORD IN AR-CNTL TABLE FOR THE        * 17437200
      *     DEPOSITS. (PYMT-PRIORITY-LVL = 80 AND ITEM-ID = 0         * 17437300
      ***************************************************************** 17437400
       8200-UPDATE-AR-CNTL-SUMM.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
              SET    LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP(),             
                     AMT_AR_DAY_00     = :SUMM-AMT-AR-DAY-00,           
                     AMT_AR_DAY_30     = :SUMM-AMT-AR-DAY-30,           
                     AMT_AR_DAY_60     = :SUMM-AMT-AR-DAY-60,           
                     AMT_AR_DAY_90     = :SUMM-AMT-AR-DAY-90            
              WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO                 
                AND  PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL         
                AND  ITEM_ID           = 0                              
                AND  LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                   :SUMM-LAST-UPDATE-TS
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17437700
MFA-TR*       UPDATE CSS_AR_CNTL                                        17437800
MFA-TR*       SET    LAST_UPDATE_TS    = CURRENT TIMESTAMP,             17437900
MFA-TR*              AMT_AR_DAY_00     = :SUMM-AMT-AR-DAY-00,           17438000
MFA-TR*              AMT_AR_DAY_30     = :SUMM-AMT-AR-DAY-30,           17438100
MFA-TR*              AMT_AR_DAY_60     = :SUMM-AMT-AR-DAY-60,           17438200
MFA-TR*              AMT_AR_DAY_90     = :SUMM-AMT-AR-DAY-90            17438300
MFA-TR*       WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO                 17438400
MFA-TR*         AND  PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL         17438500
MFA-TR*         AND  ITEM_ID           = 0                              17438600
MFA-TR*         AND  LAST_UPDATE_TS    = :SUMM-LAST-UPDATE-TS           17438700
MFA-TR*    END-EXEC.                                                    17438800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO RS-RETURN-CODE,                      
                                   WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-4             
              MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              MOVE  DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2          
              MOVE  0                    TO HOSTVAR-ELEMENT-3           
              MOVE SUMM-LAST-UPDATE-TS   TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************     17441300
      * THIS PARA READS CSS_AR_CNTL TO FIND IF THERE ARE ANY DEPOSIT    17441400
      * RECORD. IF NOT FOUND, THEN THE SUMMARY RECORD CAN BE DELETED.   17441500
      *************************************************************     17441600
T14605 8300-SELECT-ARCNTL.                                              
                                                                        
           EXEC SQL                                                     
T21713        SELECT DISTINCT ('Y')                                     
                 INTO :WS-DEP-DET-FOUND                                 
              FROM CSS_AR_CNTL                                          
                 WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO AND                
                        PYMT_PRIORITY_LVL = 080      AND                
                        ITEM_ID  <>  0               AND                
                        ITEM_ID  <> :WS-DEPOSIT-CERT-NO-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T21714     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-4             
              MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              MOVE  DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2          
              MOVE  0                    TO HOSTVAR-ELEMENT-3           
              MOVE SUMM-LAST-UPDATE-TS   TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *************************************************************     17445200
      * THIS PARA DELETES THE SUMMARY RECORD FROM CSS_AR_CNTL           17445300
      *************************************************************     17445400
      *                                                                 17445500
T14605 8400-DELETE-SUMMARY.                                             
                                                                        
            EXEC SQL                                                    
               DELETE                                                   
                 FROM CSS_AR_CNTL                                       
                 WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO AND                
                        PYMT_PRIORITY_LVL = 080      AND                
                        ITEM_ID = 0                                     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF (SQLCODE EQUAL TO SUCCESSFUL-CALL)                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              MOVE  DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2          
              MOVE  0                    TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17448700
P00599*************************************************************     17445200
P00599* THIS PARA DELETES RECORD FROM CSS_CORRESP_HDR                   17445300
P00599*************************************************************     17445400
P00599*                                                                 17445500
P00599 8500-DELETE-CORRESP-HDR.                                         
P00599                                                                  
P00599      EXEC SQL                                                    
P00599         DELETE                                                   
P00599           FROM CSS_CORRESP_HDR                                   
P00599           WHERE  CORRESP_ID        = :1J-CORRESP-ID              
P00599      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     IF (SQLCODE EQUAL TO SUCCESSFUL-CALL)                        
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8500'                TO ACTIVE-PARAGRAPH            
P00599        MOVE 'DELETE'              TO ABEND-FUNCTION              
P00599        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
P00599        MOVE  1J-CORRESP-ID        TO HOSTVAR-ELEMENT-1           
P00599        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00599        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00599     END-IF.                                                      
P00599                                                                  
P00599 8500-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 17448700
      ******************************************************************17448800
      *  INCLUDE COPYBOOKS FOR A/R AND CASH DRAWER JOURNALING          *17448900
      ******************************************************************17449000
      *                                                                 17449100
           EXEC SQL                                                     17449200
A00956        INCLUDE CPD0006A                                          17449300
           END-EXEC.                                                    17449400
      *                                                                 17449500
           EXEC SQL                                                     17450000
              INCLUDE CPD00008                                          17460000
           END-EXEC.                                                    17470000
      *                                                                 17480000
      ******************************************************************17490000
      *  INCLUDE COPYBOOKS FOR AR LOCKOUT AND AT XREF.                 *17500000
      ******************************************************************17501000
      *                                                                 17502000
           EXEC SQL                                                     17503000
              INCLUDE CPD00075                                          17504000
           END-EXEC.                                                    17505000
      *                                                                 17506000
           EXEC SQL                                                     17507000
              INCLUDE CPD00307                                          17508000
           END-EXEC.                                                    17509000
      *                                                                 17510000
      ******************************************************************17510100
      *  INCLUDE COPYBOOKS FOR INSERTING ROWS INTO CSS_REFUND          *17510200
      ******************************************************************17510300
      *                                                                 17510400
           EXEC SQL                                                     17510500
              INCLUDE CPD00080                                          17510600
           END-EXEC.                                                    17510700
      *                                                                 17510800
T21203*****************************************************************         
T21203*  CALLS THE SUBPROGRAM SCSCA182                                          
T21203*****************************************************************         
T21203*                                                                         
T21203 9200-LINK-SCSCA182.                                              
T21203*                                                                         
T21203     MOVE '9200'                        TO ACTIVE-PARAGRAPH.      
T21203                                                                  
REARCH     CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
REARCH                          ,SCSCA182-RETURN-CODE                   
REARCH                          ,SCSCA182-LAST-UPDATE-TS                
REARCH                          ,ABEND-FILE.                            
REARCH*    EXEC CICS                                                    23990000
REARCH*        HANDLE ABEND CANCEL                                      24000000
REARCH*    END-EXEC.                                                    24010000
REARCH*                                                                 24020000
REARCH*    EXEC CICS LINK                                                       
REARCH*              PROGRAM ('SCSCA182')                                       
REARCH*              COMMAREA (SCSCA182-LINK-RECORD)                            
REARCH*              LENGTH (LENGTH OF SCSCA182-LINK-RECORD)                    
REARCH*    END-EXEC.                                                            
REARCH*                                                                 24080000
REARCH*    EXEC CICS                                                    24090000
REARCH*        HANDLE ABEND LABEL(9250-CALL-ABEND)                      24100000
REARCH*    END-EXEC.                                                    24110000
T21203                                                                  
T21203 9200-EXIT.                                                       
T21203     EXIT.                                                        
T21203*                                                                         
T21203******************************************************************        
T21203*  PERFORMS THE ABEND  WHEN THE CICS STATMENT FAILS                       
T21203******************************************************************        
T21203*                                                                         
T21203 9250-CALL-ABEND.                                                 
T21203*                                                                         
T21203     MOVE PROGRAM-NAME                  TO ABEND-PROGRAM.         
T21203     MOVE 'LINKFAIL'                    TO ABEND-FUNCTION.        
T21203     MOVE WS-100                        TO WS-ACTIVE-RETURN-CODE  
T21203                                           SQLCODE.               
T21203     PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT.           
T21203                                                                  
T21203 9250-EXIT.                                                       
T21203     EXIT.                                                        
T21203*                                                                         
      ******************************************************************17510900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *17511000
      ******************************************************************17512000
REARCH*    EXEC SQL                                                     17513000
REARCH*       INCLUDE CPD00300                                          17514000
REARCH*    END-EXEC.                                                    17515000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
T21203     EXEC SQL                                                             
T21203        INCLUDE CPD0023C                                                  
T21203     END-EXEC.                                                            
T21203                                                                  
      ******************************************************************17517000
      * 9999- END PROGRAM COPYLIB                                      *17518000
      ******************************************************************17519000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
