       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02142.                                         
COB303 DATE-WRITTEN.      AUGUST 15, 1995.                              
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S142 CONVERTED TO DB2 SP CSR02142 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:     S142                                              *00120000
      *  PROGRAM:    S142                                              *00130000
      *  CALLING SP: PA_S142                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES DATA FOR SERVICE ORDER ACCOUNT       *00190000
      *  TRANSFERS                                                     *00200000
      *  THIS INFORMATION EXISTS TO SUPPORT THE MANAGEMENT OF THE      *00210000
      *  REGISTER INFORMATION.                                         *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  08/15/95    MAR      PROCEDURE ORIGINALLY CODED.              *00290000
      *                                                                *00300000
      *  01/23/96    MR       MODIFIED 7000- SELECT FOR CSS_ACCOUNT    *00310000
      *                       RE: TPR 2826 CHANGES IN CPD00068.        *00320000
      *                                                                *00330000
      *  03/06/96    SK       MODIFIED TO RETRIEVE AMT-TRAN-BALANCE FOR*00340000
      *                       EPP RECEIVABLE (TPR#3334)                *00350000
      *  03/26/96    MJL      TPR 3659 ADDED NULL INDICATORS TO ACCOUNT*00360000
      *                       DATE FIELDS.                             *00370000
PCR361*  10/02/96    JTH      PCR 361 REMOVE DATE CREDIT ACTION CALL   *00380000
PCR361*                       AND REPLACE WITH DNP DATE AND ADD FLAGS  *00390000
      *                                                                *00400000
TP8177*  12/11/96    XX279A8  ADDITIONAL SQL ADDED TO CHECK THE        *00410000
TP8177*                       EXISTANCY OF THE CONTRACT AND ONE MORE   *00420000
TP8177*                       FLAG IS RETURNED TO THE CALLER TO        *00430000
TP8177*                       INDICATE THE EXISTANCTY OF THE CONTRACT  *00440000
TP8177*                                                                *00450000
TP8142*  12/23/96    PP       ADDED CODE_ACCT_STAT FROM CSS_ACCOUNT FOR*00460000
TP8142*                       TPR8142                                  *00470000
      *                                                                *00480000
T9857 *  03/31/97    EMM      ADDED DCLGEN TBFINLWO AND TBCHGOFF FOR   *00481000
T9857 *                       CHANGES IN CPD68.                        *00482000
T12460*  08/01/97    EMS      ADDED CSS_DNP DCLGEN FOR CPD68 CHANGES   *00483000
T16853*  06/23/98    EMS      ADDED CSS_AR_TRN_HST_DET FRO CPD68 CHGS  *00484000
CBSI  *  08/21/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18466*  11/18/98   CBSI      INCLUDED LOGIC TO CHECK FOR GUARANTOR,   *        
T18466*             MADRAS    SURETY-BOND AND WAIVER FOR THE ACCOUNT-NOS        
T17071*  11/20/98   MDJ       ADDED INCLUDE TBCSTALT FOR CUST_ALERT    *        
      *                       DUE TO CPD00068 CHANGES.                 *        
T19909*  06/16/99   KP        EPP ALSO INCLUDED IN OTHER RECEIVABLES            
T21383*  01/04/2000 CB18344   EPP ALSO INCLUDED IN OTHER RECEIVABLES            
T19557*  02/01/00   CBSI      COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*             MADRAS    SCSCO068.                                *        
T22359*  06/21/00   CBSI      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
      *             MADRAS    CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
      *                       ALWAYS SCSCO068 OR SCSCB068.             *        
T22489*  07/25/00   PPR       ADDED DISTINCT IN A SELECT STATEMENT IN  *        
      *                       PARAGRAPH 7010.                          *        
T23549*  03/25/01   JS83520   EPAY CHANGES                             *        
T21671*  08/21/01   FB        RETURN ADDRESS FIELDS TO POPULATE FINAL  *        
T21671*                       BILL ADDRESS.                            *        
C28788*  07/07/03   MDJ       GET IVR-EXEMPT-CD FOR CPD00068.          *        
T36932*  05/13/08   SRIDHAR   NAME AND ADDRESS LENGTH INCREASE         *        
A37538*  03/09/09   FB        HANDLE SPACES IN PARM-ACCOUNT-NO.        *        
      ******************************************************************00490000
      ******************************************************************00500000
      *                                                                *00510000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00520000
      *                                                                *00530000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00540000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00550000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00560000
      *  3000 - 4999  NOT USED                                         *00570000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00580000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00590000
      *  7000 - 7999  INPUT MODULES                                    *00600000
      *  8000 - 8999  OUTPUT MODULES                                   *00610000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00620000
      *                                                                *00630000
      ******************************************************************00640000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02142'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                             PIC X(45) VALUE         
           'WORKING STORAGE FOR RPC CSR02142 STARTS HERE'.              
                                                                        
      ******************************************************************00730000
      *    DB2 INCLUDES                                                *00740000
      ******************************************************************00750000
      *                                                                 00760000
           EXEC SQL                                                     00770000
              INCLUDE SQLCA                                             00780000
           END-EXEC.                                                    00790000
      *                                                                 00800000
           EXEC SQL                                                     00810000
              INCLUDE TBMODEL                                           00820000
           END-EXEC.                                                    00830000
      *                                                                 00840000
           EXEC SQL                                                     00850000
              INCLUDE TBACCT                                            00860000
           END-EXEC.                                                    00870000
      *                                                                 00880000
C28788     EXEC SQL                                                             
C28788        INCLUDE TBUTLENV                                                  
C28788     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     00890000
              INCLUDE TBCNTRCT                                          00900000
           END-EXEC.                                                    00910000
      *                                                                 00920000
           EXEC SQL                                                     00930000
              INCLUDE TBCNTINF                                          00940000
           END-EXEC.                                                    00950000
      *                                                                 00960000
           EXEC SQL                                                     00970000
              INCLUDE TBARCNTL                                          00980000
           END-EXEC.                                                    00990000
      *                                                                 01000000
           EXEC SQL                                                     01010000
              INCLUDE TBSTYBND                                          01020000
           END-EXEC.                                                    01030000
      *                                                                 01040000
           EXEC SQL                                                     01050000
              INCLUDE TBROOMT                                           01100000
           END-EXEC.                                                    01110000
      *                                                                 01120000
           EXEC SQL                                                     01130000
              INCLUDE TBCOAPP                                           01140000
           END-EXEC.                                                    01150000
      *                                                                 01160000
T23549     EXEC SQL                                                     01130000
T23549        INCLUDE TBBNKEFT                                          01140000
T23549     END-EXEC.                                                    01150000
      *                                                                 01160000
T21671     EXEC SQL                                                     01130000
T21671        INCLUDE TBPREM                                            01140000
T21671     END-EXEC.                                                    01150000
      *                                                                 01160000
T21671     EXEC SQL                                                     01130000
T21671        INCLUDE TBADRFMT                                          01140000
T21671     END-EXEC.                                                    01150000
      *                                                                 01160000
T21671     EXEC SQL                                                     01130000
T21671        INCLUDE TBADRFRE                                          01140000
T21671     END-EXEC.                                                    01150000
      *                                                                 01160000
      ******************************************************************01438000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01440000
      ******************************************************************01450000
                                                                        
           COPY CCA00001.                                               01490000
           COPY CWS00027.                                               01510000
           COPY CWS00303.                                               01520000
T19557*    COPY CWS0068L.                                               01680000
      *                                                                 01530000
           EXEC SQL                                                     01540000
PCR361         INCLUDE CWS00068                                         01550000
           END-EXEC.                                                    01560000
      *                                                                 01570000
           EXEC SQL                                                     01580000
               INCLUDE CWS00056                                         01590000
           END-EXEC.                                                    01600000
      *                                                                 01610000
                                                                        
      ******************************************************************01630000
      *    WORK AREAS                                                  *01640000
      ******************************************************************01650000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE         PIC S9(9) COMP.               
                                                                        
       01  FILLER                         PIC X(11) VALUE 'PARM FIELDS'.
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9) COMP.               
           05  PARM-ACCOUNT-NO            PIC X(13)      VALUE SPACES.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02000000
       01  GTT-RETURN-FIELDS.                                           
           10 RS-DNP-DATE                 PIC X(10).                    
           10 RS-PAST-DUE-BAL             PIC S9(09)V99 COMP-3 VALUE +0.
           10 RS-EPP-TRAN-BALANCE         PIC S9(09)V99 COMP-3 VALUE +0.
           10 RS-BILL-DATE                PIC X(10) VALUE SPACES.       
           10 RS-CREDIT-GROUP             PIC X(01)     VALUE SPACES.   
           10 RS-ACCT-XFER-FROM-LST       PIC X(13)     VALUE SPACES.   
           10 RS-STA-IND                  PIC X(01)     VALUE SPACES.   
           10 RS-UTL-IND                  PIC X(01)     VALUE SPACES.   
           10 RS-BANK-DRAFT-IND           PIC X(01)     VALUE SPACES.   
           10 RS-EPP-IND                  PIC X(01)     VALUE SPACES.   
           10 RS-DEPOSIT-IND              PIC X(01)     VALUE SPACES.   
           10 RS-OTHER-RECV-IND           PIC X(01)     VALUE SPACES.   
           10 RS-PROJ-SHARE-IND           PIC X(01)     VALUE SPACES.   
           10 RS-WRITE-OFF-IND            PIC X(01)     VALUE SPACES.   
           10 RS-IN-LIEU-DEP-IND          PIC X(01)     VALUE SPACES.   
           10 RS-ROOMMATE-IND             PIC X(01)     VALUE SPACES.   
           10 RS-CO-APP-IND               PIC X(01)     VALUE SPACES.   
           10 RS-MEDICAL-IND              PIC X(01)     VALUE SPACES.   
           10 RS-WHITE-CROSS-IND          PIC X(01)     VALUE SPACES.   
TP8177     10 RS-CONTRACT-FLAG            PIC X(01)     VALUE 'N'.      
TP8142     10 RS-CODE-ACCT-STAT           PIC X(01)     VALUE SPACES.   
T21671     10 RS-ADDRESS-FORMAT           PIC X(01)     VALUE SPACES.   
T36932     10 RS-HOUSE-NO                 PIC X(15)     VALUE SPACES.   
T21671     10 RS-ADDR-PREFIX-1            PIC X(03)     VALUE SPACES.   
T21671     10 RS-ADDR-PREFIX-2            PIC X(02)     VALUE SPACES.   
T36932     10 RS-STREET-NAME              PIC X(30)     VALUE SPACES.   
T21671     10 RS-STREET-SUFFIX            PIC X(04)     VALUE SPACES.   
T21671     10 RS-ADDR-SUFFIX              PIC X(02)     VALUE SPACES.   
T21671     10 RS-STREET-LOCATION-1        PIC X(04)     VALUE SPACES.   
T36932     10 RS-STREET-LOCATION-2        PIC X(11)     VALUE SPACES.   
T21671     10 RS-ZIP-CODE                 PIC X(05)     VALUE SPACES.   
T21671     10 RS-ZIP-CODE-PLUS-FOUR       PIC X(04)     VALUE SPACES.   
T21671     10 RS-ZIP-CODE-TOKEN           PIC X(01)     VALUE SPACES.   
T21671     10 RS-ADDRESS-OVERFLOW         PIC X(35)     VALUE SPACES.   
T36932     10 RS-ADDR-STREET              PIC X(55)     VALUE SPACES.   
T36932     10 RS-ADDR-CITY-STATE          PIC X(30)     VALUE SPACES.   
T21671     10 RS-ADDR-ZIP-CODE            PIC X(09)     VALUE SPACES.   
T21671     10 RS-ADDR-COUNTRY             PIC X(35)     VALUE SPACES.   
T21671     10 RS-ADDR-OVERFLOW            PIC X(35)     VALUE SPACES.   
                                                                        
           05  RS-RETURN-CODE             PIC S9(09)    COMP VALUE 0.   
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR02142'.   
      *                                                                 02810000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
                                                                        
       01  STORAGE-FIELDS.                                              
           05  WS-PARM-FIELDS.                                          
               10 WS-ACCOUNT-NO.                                        
                  11 WS-ACCOUNT-NO-N      PIC S9(13)V.                  
COB305         10 WS-ACCOUNT-NO-COMP        PIC S9(13)V COMP-3 VALUE 0.         
           05  WS-EDITS.                                                
               10 WS-DB2-DATE.                                          
                  15 WS-DB2-YYYY          PIC X(04).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-MM            PIC X(02).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-DD            PIC X(02).                    
           05  WS-CODES-DATA.                                           
               10 WS-CODE-OTHER-RECV-IND  PIC X      VALUE SPACES.      
               10 WS-CODE-ROOMMATE-IND    PIC X      VALUE SPACES.      
               10 WS-CODE-COAPPLICANT-IND PIC X      VALUE SPACES.      
TP8177     05  WS-CONTRACT-EXISTS-FLAG    PIC X      VALUE 'N'.         
TP3334     05  WS-EPP-TRAN-BALANCE        PIC S9(09)V99 COMP-3 VALUE +0.
T18466     05  WS-GUARANTOR-FLAG          PIC X(01)  VALUE 'N'.         
T18466     05  WS-SECURED-ACCT-FLAG       PIC X(01)  VALUE 'N'.         
T18466     05  WS-WAIVER-FLAG             PIC X(01)  VALUE 'N'.         
T18466     05  WS-A                       PIC X(1)   VALUE 'A'.         
           05  WS-CURRENT-DATE            PIC X(10).                    
           05  WS-NULL-INDICATORS.                                      
               10 WS-NULL-DNP-DATE        PIC S9(04)   COMP.            
               10 WS-NULL-VALUE           PIC S9(04)   COMP VALUE -1.   
               10 WS-NULL-DAY-00          PIC S9(04)   COMP VALUE 0.    
               10 WS-NULL-DAY-30          PIC S9(04)   COMP VALUE 0.    
               10 WS-NULL-DAY-60          PIC S9(04)   COMP VALUE 0.    
               10 WS-NULL-DAY-90          PIC S9(04)   COMP VALUE 0.    
PCR361     05  WS-MULTIPLE                PIC X(10) VALUE 'MULTIPLE'.   
           05  WS-811                     PIC S9(9)    COMP VALUE -811. 
           05  WS-ACCT-XFER-FROM-LST.                                   
               10 WS-ACCT-XFER-FROM-LST-NUM                             
                                          PIC 9(13).                    
PCR361     05  WS-NULL-DNP-DATE           PIC S9(04)   COMP.            
PCR361     05  WS-NULL-VALUE              PIC S9(04)   COMP VALUE -1.   
PCR361     05  WS-DNP-DATE.                                             
PCR361         10 WS-DNP-MM            PIC X(02)     VALUE SPACES.      
PCR361         10 FILLER               PIC X         VALUE '/'.         
PCR361         10 WS-DNP-DD            PIC X(02)     VALUE SPACES.      
PCR361         10 FILLER               PIC X         VALUE '/'.         
PCR361         10 WS-DNP-YYYY          PIC X(04)     VALUE SPACES.      
T19557     05 WS-EIBRESP               PIC S9(8)                        
T19557                                 COMP SYNC     VALUE ZERO.        
            05 WS-BILL-DATE.                                            
                  15 RS-BILL-MM           PIC X(02)     VALUE SPACES.   
                  15 FILLER               PIC X         VALUE '/'.      
                  15 RS-BILL-DD           PIC X(02)     VALUE SPACES.   
                  15 FILLER               PIC X         VALUE '/'.      
                  15 RS-BILL-YYYY         PIC X(04)     VALUE SPACES.   
      *                                                                 03300000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000     10  MCSCB068                  PIC X(08) VALUE 'MCSCB068'.    
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************03330000
      * 0000-MAINLINE                                                  *03340000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03350000
      ******************************************************************03360000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03480000
      * 0100-INITIALIZE                                                *03490000
      *                                                                *03500000
      *     1. RESET DB2 ERROR HANDLERS                                *03510000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03520000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03530000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03540000
      *                                                                *03550000
      ******************************************************************03560000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-DNP-DATE                 AS    DNP_DATE               
CVT000       ,:RS-PAST-DUE-BAL             AS    PAST_DUE_BAL           
CVT000       ,:RS-BILL-DATE                AS    BILL_DATE              
CVT000       ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP           
CVT000       ,:RS-ACCT-XFER-FROM-LST       AS    ACCT_XFER_FROM_LST     
CVT000       ,:RS-STA-IND                  AS    STA_IND                
CVT000       ,:RS-UTL-IND                  AS    UTL_IND                
CVT000       ,:RS-BANK-DRAFT-IND           AS    BANK_DRAFT_IND         
CVT000       ,:RS-EPP-IND                  AS    EPP_IND                
CVT000       ,:RS-DEPOSIT-IND              AS    DEPOSIT_IND            
CVT000       ,:RS-OTHER-RECV-IND           AS    OTHER_RECV_IND         
CVT000       ,:RS-PROJ-SHARE-IND           AS    PROJ_SHARE_IND         
CVT000       ,:RS-WRITE-OFF-IND            AS    WRITE_OFF_IND          
CVT000       ,:RS-IN-LIEU-DEP-IND          AS    IN_LIEU_DEP_IND        
CVT000       ,:RS-ROOMMATE-IND             AS    ROOMMATE_IND           
CVT000       ,:RS-CO-APP-IND               AS    CO_APP_IND             
CVT000       ,:RS-MEDICAL-IND              AS    MEDICAL_IND            
CVT000       ,:RS-WHITE-CROSS-IND          AS    WHITE_CROSS_IND        
CVT000       ,:RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-EPP-TRAN-BALANCE         AS    EPP_TRAN_BALANCE       
CVT000       ,:RS-CONTRACT-FLAG            AS    CONTRACT_FLAG          
CVT000       ,:RS-CODE-ACCT-STAT           AS    CODE_ACCT_STAT         
CVT000       ,:RS-ADDRESS-FORMAT           AS    ADDRESS_FORMAT         
CVT000       ,:RS-HOUSE-NO                 AS    HOUSE_NO               
CVT000       ,:RS-ADDR-PREFIX-1            AS    ADDR_PREFIX_1          
CVT000       ,:RS-ADDR-PREFIX-2            AS    ADDR_PREFIX_2          
CVT000       ,:RS-STREET-NAME              AS    STREET_NAME            
CVT000       ,:RS-STREET-SUFFIX            AS    STREET_SUFFIX          
CVT000       ,:RS-ADDR-SUFFIX              AS    ADDR_SUFFIX            
CVT000       ,:RS-STREET-LOCATION-1        AS    STREET_LOCATION_1      
CVT000       ,:RS-STREET-LOCATION-2        AS    STREET_LOCATION_2      
CVT000       ,:RS-ZIP-CODE                 AS    ZIP_CODE               
CVT000       ,:RS-ZIP-CODE-PLUS-FOUR       AS    ZIP_CODE_PLUS_FOUR     
CVT000       ,:RS-ZIP-CODE-TOKEN           AS    ZIP_CODE_TOKEN         
CVT000       ,:RS-ADDRESS-OVERFLOW         AS    ADDRESS_OVERFLOW       
CVT000       ,:RS-ADDR-STREET              AS    ADDR_STREET            
CVT000       ,:RS-ADDR-CITY-STATE          AS    ADDR_CITY_STATE        
CVT000       ,:RS-ADDR-ZIP-CODE            AS    ADDR_ZIP_CODE          
CVT000       ,:RS-ADDR-COUNTRY             AS    ADDR_COUNTRY           
CVT000       ,:RS-ADDR-OVERFLOW            AS    ADDR_OVERFLOW          
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-DNP-DATE                 AS    DNP_DATE                       
MFA-TR*      ,:RS-PAST-DUE-BAL             AS    PAST_DUE_BAL                   
MFA-TR*      ,:RS-BILL-DATE                AS    BILL_DATE                      
MFA-TR*      ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP                   
MFA-TR*      ,:RS-ACCT-XFER-FROM-LST       AS    ACCT_XFER_FROM_LST             
MFA-TR*      ,:RS-STA-IND                  AS    STA_IND                        
MFA-TR*      ,:RS-UTL-IND                  AS    UTL_IND                        
MFA-TR*      ,:RS-BANK-DRAFT-IND           AS    BANK_DRAFT_IND                 
MFA-TR*      ,:RS-EPP-IND                  AS    EPP_IND                        
MFA-TR*      ,:RS-DEPOSIT-IND              AS    DEPOSIT_IND                    
MFA-TR*      ,:RS-OTHER-RECV-IND           AS    OTHER_RECV_IND                 
MFA-TR*      ,:RS-PROJ-SHARE-IND           AS    PROJ_SHARE_IND                 
MFA-TR*      ,:RS-WRITE-OFF-IND            AS    WRITE_OFF_IND                  
MFA-TR*      ,:RS-IN-LIEU-DEP-IND          AS    IN_LIEU_DEP_IND                
MFA-TR*      ,:RS-ROOMMATE-IND             AS    ROOMMATE_IND                   
MFA-TR*      ,:RS-CO-APP-IND               AS    CO_APP_IND                     
MFA-TR*      ,:RS-MEDICAL-IND              AS    MEDICAL_IND                    
MFA-TR*      ,:RS-WHITE-CROSS-IND          AS    WHITE_CROSS_IND                
MFA-TR*      ,:RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-EPP-TRAN-BALANCE         AS    EPP_TRAN_BALANCE               
MFA-TR*      ,:RS-CONTRACT-FLAG            AS    CONTRACT_FLAG                  
MFA-TR*      ,:RS-CODE-ACCT-STAT           AS    CODE_ACCT_STAT                 
MFA-TR*      ,:RS-ADDRESS-FORMAT           AS    ADDRESS_FORMAT                 
MFA-TR*      ,:RS-HOUSE-NO                 AS    HOUSE_NO                       
MFA-TR*      ,:RS-ADDR-PREFIX-1            AS    ADDR_PREFIX_1                  
MFA-TR*      ,:RS-ADDR-PREFIX-2            AS    ADDR_PREFIX_2                  
MFA-TR*      ,:RS-STREET-NAME              AS    STREET_NAME                    
MFA-TR*      ,:RS-STREET-SUFFIX            AS    STREET_SUFFIX                  
MFA-TR*      ,:RS-ADDR-SUFFIX              AS    ADDR_SUFFIX                    
MFA-TR*      ,:RS-STREET-LOCATION-1        AS    STREET_LOCATION_1              
MFA-TR*      ,:RS-STREET-LOCATION-2        AS    STREET_LOCATION_2              
MFA-TR*      ,:RS-ZIP-CODE                 AS    ZIP_CODE                       
MFA-TR*      ,:RS-ZIP-CODE-PLUS-FOUR       AS    ZIP_CODE_PLUS_FOUR             
MFA-TR*      ,:RS-ZIP-CODE-TOKEN           AS    ZIP_CODE_TOKEN                 
MFA-TR*      ,:RS-ADDRESS-OVERFLOW         AS    ADDRESS_OVERFLOW               
MFA-TR*      ,:RS-ADDR-STREET              AS    ADDR_STREET                    
MFA-TR*      ,:RS-ADDR-CITY-STATE          AS    ADDR_CITY_STATE                
MFA-TR*      ,:RS-ADDR-ZIP-CODE            AS    ADDR_ZIP_CODE                  
MFA-TR*      ,:RS-ADDR-COUNTRY             AS    ADDR_COUNTRY                   
MFA-TR*      ,:RS-ADDR-OVERFLOW            AS    ADDR_OVERFLOW                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03840000
      * 1000-PROCESS-INPUT                                             *03850000
      *                                                                *03860000
      *     1. RECEIVE PARMS.                                          *03870000
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *03880000
      *                                                                *03890000
      ******************************************************************03900000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
           PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04260000
      * 1150 ASSIGN-WS-VARS                                            *04270000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *04280000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *04290000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *04300000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *04310000
      *        SELECT STATEMENTS.                                      *04320000
      ******************************************************************04330000
       1150-ASSIGN-WS-VARS.                                             
           MOVE '1150'                        TO ACTIVE-PARAGRAPH.      
      *                                                                 04360000
A37538     IF PARM-ACCOUNT-NO NOT NUMERIC                               
A37538         MOVE ZEROES TO PARM-ACCOUNT-NO
           END-IF.                          
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO-N               TO WS-ACCOUNT-NO-COMP.    
           MOVE WS-ACCOUNT-NO-COMP            TO AT-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO-COMP            TO CT-ACCOUNT-NO.         
T23549     MOVE WS-ACCOUNT-NO-COMP            TO BE-ACCOUNT-NO.         
      *                                                                 04410000
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04460000
      * 2000-PROCESS-OUTPUT.                                           *04470000
      *                                                                *04480000
      *     1. DESCRIBE RESULT SET                                     *04490000
      *     2. RETRIVE DB2 DATA                                        *04500000
      *     3. BUILD RESULT SET                                        *04510000
      *     4. SEND RESULT SET                                         *04520000
      *                                                                *04530000
      ******************************************************************04540000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
      *                                                                 04570000
           PERFORM 5000-RETRIEVE-DB2-DATA      THRU 5000-EXIT.          
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
      *                                                                 04620000
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09630000
      * 2200-BUILD RESULT.                                             *09640000
      *       -- THIS MODULE BUILDS THE RESULT SET DEPENDING ON DATA   *09650000
      *          PREVIOUSLY RETRIEVED.                                 *09660000
      ******************************************************************09670000
       2200-BUILD-RESULT.                                               
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 09700000
PCR361     IF WS-DATE-DISC > SPACES                                     
PCR361        IF WS-DATE-DISC = WS-MULTIPLE                             
PCR361           MOVE WS-DATE-DISC             TO RS-DNP-DATE           
PCR361        ELSE                                                      
PCR361           MOVE WS-DATE-DISC             TO WS-DB2-DATE           
                 MOVE WS-DB2-YYYY              TO WS-DNP-YYYY           
                 MOVE WS-DB2-MM                TO WS-DNP-MM             
                 MOVE WS-DB2-DD                TO WS-DNP-DD             
PCR361           MOVE WS-DNP-DATE              TO RS-DNP-DATE           
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-AMT-PAST-DUE             TO RS-PAST-DUE-BAL.         
TP3334     MOVE WS-EPP-TRAN-BALANCE         TO RS-EPP-TRAN-BALANCE.     
           MOVE AT-DATE-BILL-DAY-00         TO WS-DB2-DATE.             
           MOVE WS-DB2-YYYY                 TO RS-BILL-YYYY.            
           MOVE WS-DB2-MM                   TO RS-BILL-MM.              
           MOVE WS-DB2-DD                   TO RS-BILL-DD.              
           MOVE WS-BILL-DATE                TO RS-BILL-DATE             
           MOVE AT-CREDIT-GROUP             TO RS-CREDIT-GROUP.         
           IF AT-ACCT-XFER-FROM-LST = 0                                 
              MOVE SPACES                   TO RS-ACCT-XFER-FROM-LST    
           ELSE                                                         
              MOVE AT-ACCT-XFER-FROM-LST    TO WS-ACCT-XFER-FROM-LST-NUM
              MOVE WS-ACCT-XFER-FROM-LST    TO RS-ACCT-XFER-FROM-LST    
           END-IF.                                                      
                                                                        
           MOVE WS-CODE-UTL                 TO RS-UTL-IND.              
           MOVE WS-CODE-STA-ACCT            TO RS-STA-IND.              
           MOVE WS-CODE-BANK-EFT            TO RS-BANK-DRAFT-IND.       
           MOVE WS-CODE-BUDGET              TO RS-EPP-IND.              
           MOVE WS-CODE-DEP-ON-HAND         TO RS-DEPOSIT-IND.          
           MOVE WS-CODE-OTHER-RECV-IND      TO RS-OTHER-RECV-IND        
           MOVE WS-CODE-PROJECT-SHARE       TO RS-PROJ-SHARE-IND.       
           MOVE WS-CODE-CHRG-OFF            TO RS-WRITE-OFF-IND.        
T18466*    MOVE WS-CODE-SEC-ACCT            TO RS-IN-LIEU-DEP-IND.      10040000
T18466     PERFORM 7010-SELECT-GUARANTOR    THRU 7010-EXIT.             
T18466     IF (WS-GUARANTOR-FLAG  EQUAL TO 'Y')                         
T18466         MOVE WS-A                    TO RS-IN-LIEU-DEP-IND       
T18466     ELSE                                                         
T18466        PERFORM 7015-SELECT-SURETY-BOND  THRU 7015-EXIT           
T18466        IF (WS-SECURED-ACCT-FLAG  EQUAL TO 'Y')                   
T18466            MOVE WS-A                 TO RS-IN-LIEU-DEP-IND       
T18466        ELSE                                                      
T18466            PERFORM 7020-SELECT-WAIVER       THRU 7020-EXIT       
T18466            IF (WS-WAIVER-FLAG  EQUAL TO 'Y')                     
T18466               MOVE WS-A              TO RS-IN-LIEU-DEP-IND       
T18466            ELSE                                                  
T18466               MOVE SPACES            TO RS-IN-LIEU-DEP-IND       
T18466            END-IF                                                
T18466        END-IF                                                    
T18466     END-IF.                                                      
           MOVE WS-CODE-ROOMMATE-IND        TO RS-ROOMMATE-IND.         
TP8142     MOVE AT-CODE-ACCT-STAT           TO RS-CODE-ACCT-STAT.       
           MOVE WS-CODE-COAPPLICANT-IND     TO RS-CO-APP-IND.           
           MOVE WS-CODE-MEDICAL             TO RS-MEDICAL-IND.          
           IF AT-CODE-CRIT-OUTAGE = 'WC'                                
              MOVE 'A'                      TO RS-WHITE-CROSS-IND       
           END-IF.                                                      
      *                                                                 10120000
TP8177     MOVE WS-CONTRACT-EXISTS-FLAG     TO RS-CONTRACT-FLAG.        
      *                                                                 10140000
      *                                                                 10150000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10180000
      *                                                                 10190000
      ******************************************************************10200000
      * 5000 RETRIEVE DB2 DATA.                                        *10210000
      *   -- THIS MODULE CONTROLS THE RETRIEVAL FO DATA FROM VARIOUS   *10220000
      *      DBS TABLES.                                               *10230000
      ******************************************************************10240000
       5000-RETRIEVE-DB2-DATA.                                          
           MOVE '5000'                         TO ACTIVE-PARAGRAPH.     
      *                                                                 10270000
           PERFORM 7000-GET-ACCOUNT          THRU 7000-EXIT.            
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
           MOVE WS-CURRENT-DATE                TO WS-CL-DATE-NOTICE-MAIL
                                                  WS-CL-DATE-NOTICE-DUE.
                                                                        
PCR361*  SET CPD00068 SWITCHES THAT ARE NEEDED                          10330000
PCR361     MOVE 'Y'           TO CALC-PAST-DUE-SW                       
PCR361                           LOAD-DNP-DATE-SW                       
PCR361                           CALC-BALANCE-SW                        
PCR361                           CALC-ARREARS-SW.                       
                                                                        
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
T19557*    MOVE CWS00068-FIELDS            TO WS-CWS68-FIELDS-LK.               
T19557*    MOVE WS-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT-LK.         
T19557*    MOVE DCLCSS-ACCOUNT             TO WS-DCLCSS-ACCOUNT-LK.             
T19557*    MOVE ABEND-FILE                 TO WS-ABEND-FILE-LK.                 
T19557*    MOVE RS-RETURN-CODE             TO WS-RETURN-CODE-LK.                
T19557     MOVE SPACES                     TO ABEND-FUNCTION .          
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557*    MOVE WS-CWS68-FIELDS-LK         TO CWS00068-FIELDS                   
T19557*    MOVE WS-ABEND-FILE-LK           TO ABEND-FILE                        
T19557*    MOVE WS-DCLCSS-ACCOUNT-LK       TO DCLCSS-ACCOUNT                    
T19557*    MOVE WS-CODES-DATA-PRESENT-LK   TO WS-CODES-DATA-PRESENT             
T19557*    MOVE WS-RETURN-CODE-LK          TO RS-RETURN-CODE                    
T19557     MOVE RS-RETURN-CODE             TO  WS-ACTIVE-RETURN-CODE,   
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
           PERFORM 7200-GET-AR-RECV          THRU 7200-EXIT.            
           PERFORM 7300-GET-ROOMMATE         THRU 7300-EXIT.            
           PERFORM 7400-GET-COAPPLICANT      THRU 7400-EXIT.            
TP3334     IF WS-CODE-BUDGET = 'A'                                      
              MOVE WS-ACCOUNT-NO-COMP    TO AC-ACCOUNT-NO               
              MOVE +050                  TO AC-PYMT-PRIORITY-LVL        
              MOVE +1                    TO AC-ITEM-ID                  
              PERFORM 7500-GET-EPP-TRAN-BALANCE    THRU 7500-EXIT       
              MOVE AC-AMT-TRAN-BALANCE   TO WS-EPP-TRAN-BALANCE         
           ELSE                                                         
              MOVE 0                     TO WS-EPP-TRAN-BALANCE         
TP3334     END-IF.                                                      
      *                                                                 10530000
TP8177     PERFORM 7600-GET-CONTRACT-INFO    THRU 7600-EXIT.            
      *                                                                 10550000
T23549     PERFORM 7700-GET-EPAY-INFO        THRU 7700-EXIT.            
                                                                        
T21671     IF AT-ADDRESS-ID > 0                                         
T21671         EVALUATE AT-ADDRESS-FORMAT                               
T21671             WHEN 'A'                                             
T21671                 MOVE AT-ADDRESS-ID TO DY-ADDRESS-ID              
T21671                 PERFORM 7810-FORMATTED-ADDRESS THRU 7810-EXIT    
T21671             WHEN 'B'                                             
T21671                 MOVE AT-ADDRESS-ID TO DZ-ADDRESS-ID              
T21671                 PERFORM 7820-FREEFORM-ADDRESS THRU 7820-EXIT     
T21671         END-EVALUATE                                             
T21671     ELSE                                                         
T21671         PERFORM 7800-GET-PREMISE THRU 7800-EXIT                  
T21671         MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID                      
T21671         PERFORM 7810-FORMATTED-ADDRESS THRU 7810-EXIT
           END-IF.           
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10580000
      ******************************************************************10680000
      * 7000 GET ACCOUNT.                                              *10690000
      *       -- THIS MODULE RETRIEVES ACCOUNT INFORAMTION.            *10700000
      ******************************************************************10710000
       7000-GET-ACCOUNT.                                                
      *                                                                 10740000
           EXEC SQL                                                     
               SELECT DATE_BILL_DAY_00,                                 
                      CREDIT_GROUP,                                     
                      ACCT_XFER_FROM_LST,                               
                      CODE_CRIT_OUTAGE,                                 
                      CODES_DATA_PRESENT,                               
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      CODE_DISC_OK,                                     
PCR361                COMPANY_NO,                                       
PCR361                LOCAL_OFFICE,                                     
PCR361                BANKRUPTCY_IND,                                   
                      NOTICE_EXEMPT_CD,                                 
                      CAST(SYSDATETIMEOFFSET() AS DATE),                        
                      CODE_ACCT_STAT,                                   
T21671                ADDRESS_ID,                                       
T21671                ADDRESS_FORMAT,                                   
T21671                PREMISE_NO,                                       
C28788                IVR_EXEMPT_CD                                     
                 INTO :AT-DATE-BILL-DAY-00 :WS-NULL-DAY-00,             
                      :AT-CREDIT-GROUP,                                 
                      :AT-ACCT-XFER-FROM-LST,                           
                      :AT-CODE-CRIT-OUTAGE,                             
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-DATE-BILL-DAY-30 :WS-NULL-DAY-30,             
                      :AT-DATE-BILL-DAY-60 :WS-NULL-DAY-60,             
                      :AT-DATE-BILL-DAY-90 :WS-NULL-DAY-90,             
                      :AT-CODE-DISC-OK,                                 
PCR361                :AT-COMPANY-NO,                                   
PCR361                :AT-LOCAL-OFFICE,                                 
PCR361                :AT-BANKRUPTCY-IND,                               
                      :AT-NOTICE-EXEMPT-CD,                             
                      :WS-CURRENT-DATE,                                 
                      :AT-CODE-ACCT-STAT,                               
T21671                :AT-ADDRESS-ID,                                   
T21671                :AT-ADDRESS-FORMAT,                               
T21671                :AT-PREMISE-NO,                                   
C28788                :AT-IVR-EXEMPT-CD                                 
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10750000
MFA-TR*        SELECT DATE_BILL_DAY_00,                                 10760000
MFA-TR*               CREDIT_GROUP,                                     10770000
MFA-TR*               ACCT_XFER_FROM_LST,                               10780000
MFA-TR*               CODE_CRIT_OUTAGE,                                 10790000
MFA-TR*               CODES_DATA_PRESENT,                               10800000
MFA-TR*               DATE_BILL_DAY_30,                                 10810000
MFA-TR*               DATE_BILL_DAY_60,                                 10820000
MFA-TR*               DATE_BILL_DAY_90,                                 10830000
MFA-TR*               CODE_DISC_OK,                                     10840000
MFA-TR*               COMPANY_NO,                                       10850000
MFA-TR*               LOCAL_OFFICE,                                     10860000
MFA-TR*               BANKRUPTCY_IND,                                   10870000
MFA-TR*               NOTICE_EXEMPT_CD,                                 10880000
MFA-TR*               CURRENT DATE,                                     10890000
MFA-TR*               CODE_ACCT_STAT,                                   10900000
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               IVR_EXEMPT_CD                                             
MFA-TR*          INTO :AT-DATE-BILL-DAY-00 :WS-NULL-DAY-00,             10910000
MFA-TR*               :AT-CREDIT-GROUP,                                 10920000
MFA-TR*               :AT-ACCT-XFER-FROM-LST,                           10930000
MFA-TR*               :AT-CODE-CRIT-OUTAGE,                             10940000
MFA-TR*               :AT-CODES-DATA-PRESENT,                           10950000
MFA-TR*               :AT-DATE-BILL-DAY-30 :WS-NULL-DAY-30,             10960000
MFA-TR*               :AT-DATE-BILL-DAY-60 :WS-NULL-DAY-60,             10970000
MFA-TR*               :AT-DATE-BILL-DAY-90 :WS-NULL-DAY-90,             10980000
MFA-TR*               :AT-CODE-DISC-OK,                                 10990000
MFA-TR*               :AT-COMPANY-NO,                                   11000000
MFA-TR*               :AT-LOCAL-OFFICE,                                 11010000
MFA-TR*               :AT-BANKRUPTCY-IND,                               11020000
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                             11030000
MFA-TR*               :WS-CURRENT-DATE,                                 11040000
MFA-TR*               :AT-CODE-ACCT-STAT,                               11050000
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*          FROM CSS_ACCOUNT                                       11060000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       11070000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11090000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
PCR361         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
      *                                                                 11250000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11280000
T18466******************************************************************        
T18466* 7010-SELECT-GUARANTOR.                                         *        
T18466*    CHECKS FOR THE GUARANTOR FOR THE ACCOUNT-NOS                *        
T18466******************************************************************        
T18466*                                                                         
T18466  7010-SELECT-GUARANTOR.                                          
T18466     EXEC SQL                                                     
T22489        SELECT TOP(1) 'Y'                                                
T18466        INTO  :WS-GUARANTOR-FLAG                                  
T18466        FROM   CSS_GUARANTOR GU WITH(READUNCOMMITTED),                    
T18466               CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                     
T18466        WHERE  GU.ACCOUNT_NO      = :WS-ACCOUNT-NO-COMP           
T18466          AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                 
T18466          AND  AT.CODE_ACCT_STAT  = 'A'                           
T18466          AND  GU.GUAR_STATUS_CD  IN ('A','P')                    
T18466                                       
T18466     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO  :WS-GUARANTOR-FLAG                                          
MFA-TR*       FROM   CSS_GUARANTOR GU,                                          
MFA-TR*              CSS_ACCOUNT   AT                                           
MFA-TR*       WHERE  GU.ACCOUNT_NO      = :WS-ACCOUNT-NO-COMP                   
MFA-TR*         AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                         
MFA-TR*         AND  AT.CODE_ACCT_STAT  = 'A'                                   
MFA-TR*         AND  GU.GUAR_STATUS_CD  IN ('A','P')                            
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18466                                                                  
T18466     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
T18466                                                                  
T18466     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T18466        NEXT SENTENCE                                             
T18466     ELSE                                                         
T18466        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T18466        MOVE '7010'               TO ACTIVE-PARAGRAPH             
T18466        MOVE 'SELECT'             TO ABEND-FUNCTION               
T18466        MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
T18466        MOVE 'CSS_ACCOUNT'        TO TABLE-2                      
T18466        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T18466        MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1            
T18466        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T18466        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T18466     END-IF.                                                      
T18466*                                                                         
T18466 7010-EXIT.                                                       
T18466     EXIT.                                                        
T18466*                                                                         
T18466******************************************************************        
T18466* 7015-SELECT-SURETY-BOND.                                       *        
T18466*   THIS PARA CHECKS FOR THE SURETY-BOND FOR THE ACCOUNT-NO      *        
T18466******************************************************************        
T18466*                                                                         
T18466  7015-SELECT-SURETY-BOND.                                        
T18466                                                                  
T18466     EXEC SQL                                                     
T18466        SELECT TOP(1) 'Y'                                                
T18466        INTO  :WS-SECURED-ACCT-FLAG                               
T18466        FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
T18466        WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                   
T18466        AND CODE_BOND_TYPE IN('A','B')                            
T18466        AND CODE_STATUS IN('A','P')                               
T18466                                       
T18466     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO  :WS-SECURED-ACCT-FLAG                                       
MFA-TR*       FROM   CSS_SURETY_BOND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                           
MFA-TR*       AND CODE_BOND_TYPE IN('A','B')                                    
MFA-TR*       AND CODE_STATUS IN('A','P')                                       
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18466                                                                  
T18466     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18466                                                                  
T18466     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T18466                                NOT-FOUND                         
T18466        NEXT SENTENCE                                             
T18466     ELSE                                                         
T18466        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
T18466        MOVE '7015'          TO ACTIVE-PARAGRAPH                  
T18466        MOVE 'SELECT'             TO ABEND-FUNCTION               
T18466        MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
T18466        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T18466        MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1            
T18466        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T18466        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T18466     END-IF.                                                      
T18466*                                                                         
T18466 7015-EXIT.                                                       
T18466     EXIT.                                                        
T18466*                                                                         
T18466******************************************************************        
T18466* 7020-SELECT-WAIVER.                                            *        
T18466*      THIS PARA CHECKS FOR THE WAIVER FOR THE ACCOUNT-NOS       *        
T18466******************************************************************        
T18466*                                                                         
T18466 7020-SELECT-WAIVER.                                              
T18466                                                                  
T18466     EXEC SQL                                                     
T18466        SELECT TOP(1) 'Y'                                                
T18466        INTO  :WS-WAIVER-FLAG                                     
T18466        FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
T18466        WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                   
T18466        AND  CODE_BOND_TYPE = 'C'                                 
T18466        AND CODE_STATUS IN('A','P')                               
T18466                                       
T18466     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO  :WS-WAIVER-FLAG                                             
MFA-TR*       FROM   CSS_SURETY_BOND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                           
MFA-TR*       AND  CODE_BOND_TYPE = 'C'                                         
MFA-TR*       AND CODE_STATUS IN('A','P')                                       
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18466                                                                  
T18466     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18466                                                                  
T18466     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T18466                                NOT-FOUND                         
T21383                             OR WS-811                            
T18466        NEXT SENTENCE                                             
T18466     ELSE                                                         
T18466        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
T18466        MOVE '7020'          TO ACTIVE-PARAGRAPH                  
T18466        MOVE 'SELECT'             TO ABEND-FUNCTION               
T18466        MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
T18466        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T18466        MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1            
T18466        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T18466        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T18466     END-IF.                                                      
T18466*                                                                         
T18466 7020-EXIT.                                                       
T18466     EXIT.                                                        
      *                                                                 11290000
      ******************************************************************11300000
      * 7300 GET AR RECV                                               *11310000
      *       -- THIS MODULE DETERMINES THE EXISTENCE OF A RECV.       *11320000
      ******************************************************************11330000
       7200-GET-AR-RECV.                                                
           MOVE '7200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 11360000
           EXEC SQL                                                     
              SELECT TOP(1) 'A'                                                
                INTO :WS-CODE-OTHER-RECV-IND                            
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                AND PYMT_PRIORITY_LVL IN (39,40,45,29,20,60,30,19,70,47,
T19909                                    90,50)                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11370000
MFA-TR*       SELECT 'A'                                                11380000
MFA-TR*         INTO :WS-CODE-OTHER-RECV-IND                            11390000
MFA-TR*         FROM CSS_AR_CNTL                                        11400000
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 11410000
MFA-TR*         AND PYMT_PRIORITY_LVL IN (39,40,45,29,20,60,30,19,70,47,11420000
MFA-TR*                                   90,50)                        11430000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                    11440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR WS-811                                                 
              MOVE 0                      TO RS-RETURN-CODE             
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
PCR361         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 11580000
      *                                                                 11590000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11620000
      *                                                                 11630000
      ******************************************************************11640000
      * 7300 GET ROOMMATE                                              *11650000
      *   -- THIS MODULE CHECKS FOR THE EXISTENCE OF A ROOMMATE        *11660000
      ******************************************************************11670000
       7300-GET-ROOMMATE.                                               
           MOVE '7300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 11700000
           EXEC SQL                                                     
              SELECT TOP(1) 'A'                                                
                INTO :WS-CODE-ROOMMATE-IND                              
                FROM CSS_ROOMMATE WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11710000
MFA-TR*       SELECT 'A'                                                11720000
MFA-TR*         INTO :WS-CODE-ROOMMATE-IND                              11730000
MFA-TR*         FROM CSS_ROOMMATE                                       11740000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        11750000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                    11760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11770000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR WS-811                                                 
              MOVE 0                      TO RS-RETURN-CODE             
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_ROOMMATE'        TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
PCR361         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 11910000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11940000
      *                                                                 11950000
      ******************************************************************11960000
      * 7400 GET COAPPLICANT.                                          *11970000
      *   -- THIS MODULE CHECKS FOR THE EXISTENCE OF A COAPPLICANT.    *11980000
      ******************************************************************11990000
       7400-GET-COAPPLICANT.                                            
           MOVE '7400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 12020000
           EXEC SQL                                                     
              SELECT TOP(1) 'A'                                                
                INTO :WS-CODE-COAPPLICANT-IND                           
                FROM CSS_COAPPLICANT WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12030000
MFA-TR*       SELECT 'A'                                                12040000
MFA-TR*         INTO :WS-CODE-COAPPLICANT-IND                           12050000
MFA-TR*         FROM CSS_COAPPLICANT                                    12060000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        12070000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                    12080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR WS-811                                                 
              MOVE 0                      TO RS-RETURN-CODE             
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_COAPPLICANT'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
PCR361         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12220000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12250000
TP3334******************************************************************12260000
      * 7500 GET EPP TRAN BALANCE                                      *12270000
      *   -- THIS MODULE GETS THE AMT TRAN BALANCE FOR EPP FROM        *12280000
      *   -- CSS_AR_CONTROL TABLE                                      *12290000
      ******************************************************************12300000
       7500-GET-EPP-TRAN-BALANCE.                                       
                                                                        
           MOVE '7500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 12340000
           EXEC SQL                                                     
              SELECT AMT_TRAN_BALANCE                                   
                INTO :AC-AMT-TRAN-BALANCE                               
                FROM CSS_AR_CNTL                                        
               WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                        
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID = :AC-ITEM-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2            
               MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3            
               MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2          
               MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3          
PCR361         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 12590000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12620000
TP8177*                                                                 12630000
TP8177******************************************************************12640000
TP8177* 7600 GET CONTRACT INFO                                         *12650000
TP8177*   -- THIS PARA CHECKS FOR THE EXISTANCY OF CONTRACTS FOR THIS  *12660000
TP8177*   -- ACCOUNT NUMBER, AND SET A FLAG.                           *12670000
TP8177******************************************************************12680000
TP8177 7600-GET-CONTRACT-INFO.                                          
TP8177                                                                  
CBSI       MOVE '7600'                    TO ACTIVE-PARAGRAPH.          
TP8177*                                                                 12720000
TP8177     EXEC SQL                                                     
TP8177        SELECT TOP(1) 'Y'                                                
TP8177          INTO :WS-CONTRACT-EXISTS-FLAG                           
TP8177          FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
TP8177         WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                    
TP8177                                       
TP8177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12730000
MFA-TR*       SELECT 'Y'                                                12740000
MFA-TR*         INTO :WS-CONTRACT-EXISTS-FLAG                           12750000
MFA-TR*         FROM CSS_CONTRACT CT                                    12760000
MFA-TR*        WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                    12770000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                    12780000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8177                                                                  
TP8177     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
TP8177                                                                  
TP8177     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
TP8177        MOVE 'Y' TO WS-CONTRACT-EXISTS-FLAG                       
TP8177     ELSE                                                         
TP8177        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
TP8177           MOVE 'N' TO WS-CONTRACT-EXISTS-FLAG                    
TP8177        ELSE                                                      
CBSI             MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
TP8177           MOVE 'SELECT'              TO ABEND-FUNCTION           
CBSI             MOVE SPACES                TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
TP8177           MOVE 'CSS_CONTRACT'        TO TABLE-1                  
TP8177           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
TP8177           MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
TP8177           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
TP8177        END-IF                                                    
TP8177     END-IF.                                                      
TP8177*                                                                 12950000
TP8177 7600-EXIT.                                                       
TP8177     EXIT.                                                        
TP8177*                                                                 12630000
T23549******************************************************************12640000
T23549* 7700 GET EPAY INFO                                             *12650000
T23549*   -- THIS PARA CHECKS FOR THE EXISTANCY OF EPAY FOR THIS       *12660000
T23549*   -- ACCOUNT NUMBER, AND SETS A FLAG                           *12670000
T23549******************************************************************12680000
T23549 7700-GET-EPAY-INFO.                                              
T23549                                                                  
T23549     MOVE '7700'                    TO ACTIVE-PARAGRAPH.          
T23549*                                                                 12720000
T23549     EXEC SQL                                                     
T23549        SELECT STATUS_CODE                                        
T23549          INTO :BE-STATUS-CODE                                    
T23549          FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)                      
T23549         WHERE BE.ACCOUNT_NO  = :BE-ACCOUNT-NO                    
T23549           AND BE.STATUS_CODE IN ('M', 'N')                       
T23549                                                           
T23549     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12730000
MFA-TR*       SELECT STATUS_CODE                                        12740000
MFA-TR*         INTO :BE-STATUS-CODE                                            
MFA-TR*         FROM CSS_BANK_EFT BE                                    12760000
MFA-TR*        WHERE BE.ACCOUNT_NO  = :BE-ACCOUNT-NO                    12770000
MFA-TR*          AND BE.STATUS_CODE IN ('M', 'N')                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    12780000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23549                                                                  
T23549     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T23549                                                                  
T23549     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
T23549        MOVE 'E'                    TO WS-CODE-BANK-EFT           
T23549     ELSE                                                         
T23549        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T23549           CONTINUE                                               
T23549        ELSE                                                      
T23549           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
T23549           MOVE 'SELECT'              TO ABEND-FUNCTION           
T23549           MOVE SPACES                TO ABEND-SQL-PREDICATES     
T23549                                         ABEND-TABLES             
T23549           MOVE 'CSS_BANK_EFT'        TO TABLE-1                  
T23549           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T23549           MOVE BE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
T23549           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
T23549        END-IF                                                    
T23549     END-IF.                                                      
T23549*                                                                 12950000
T23549 7700-EXIT.                                                       
T23549     EXIT.                                                        
                                                                        
T21671 7800-GET-PREMISE.                                                
T21671                                                                  
T21671     MOVE '7800'                    TO ACTIVE-PARAGRAPH.          
T21671                                                                  
T21671     EXEC SQL                                                     
T21671        SELECT ADDRESS_ID                                         
T21671          INTO :PR-ADDRESS-ID                                     
T21671          FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
T21671         WHERE PREMISE_NO = :AT-PREMISE-NO                        
T21671                                                           
T21671     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12350000
MFA-TR*       SELECT ADDRESS_ID                                         12360000
MFA-TR*         INTO :PR-ADDRESS-ID                                     12370000
MFA-TR*         FROM CSS_PREMISE                                        12380000
MFA-TR*        WHERE PREMISE_NO = :AT-PREMISE-NO                        12390000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    12420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21671     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T21671                                       RS-RETURN-CODE.            
T21671                                                                  
T21671     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21671        NEXT SENTENCE                                             
T21671     ELSE                                                         
T21671         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21671         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21671         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21671                                       ABEND-TABLES               
T21671         MOVE 'CSS_PREMISE'         TO TABLE-1                    
T21671         MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1            
T21671         MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
T21671         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
T21671     END-IF.                                                      
T21671                                                                  
T21671 7800-EXIT.                                                       
T21671     EXIT.                                                        
                                                                        
T21671 7810-FORMATTED-ADDRESS.                                          
T21671                                                                  
T21671     MOVE '7810'                    TO ACTIVE-PARAGRAPH.          
T21671                                                                  
T21671     EXEC SQL                                                     
T21671        SELECT HOUSE_NO,                                          
T21671               ADDR_PREFIX_1,                                     
T21671               ADDR_PREFIX_2,                                     
T21671               STREET_NAME,                                       
T21671               STREET_SUFFIX,                                     
T21671               ADDR_SUFFIX,                                       
T21671               STREET_LOCATION_1,                                 
T21671               STREET_LOCATION_2,                                 
T21671               ZIP_CODE,                                          
T21671               ZIP_CODE_PLUS_FOUR,                                
T21671               ZIP_CODE_TOKEN,                                    
T21671               ADDRESS_OVERFLOW                                   
T21671          INTO :DY-HOUSE-NO,                                      
T21671               :DY-ADDR-PREFIX-1,                                 
T21671               :DY-ADDR-PREFIX-2,                                 
T21671               :DY-STREET-NAME,                                   
T21671               :DY-STREET-SUFFIX,                                 
T21671               :DY-ADDR-SUFFIX,                                   
T21671               :DY-STREET-LOCATION-1,                             
T21671               :DY-STREET-LOCATION-2,                             
T21671               :DY-ZIP-CODE,                                      
T21671               :DY-ZIP-CODE-PLUS-FOUR,                            
T21671               :DY-ZIP-CODE-TOKEN,                                
T21671               :DY-ADDRESS-OVERFLOW                               
T21671          FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
T21671         WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
T21671                                                           
T21671     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12350000
MFA-TR*       SELECT HOUSE_NO,                                          12360000
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              ZIP_CODE,                                                  
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              ZIP_CODE_TOKEN,                                            
MFA-TR*              ADDRESS_OVERFLOW                                           
MFA-TR*         INTO :DY-HOUSE-NO,                                      12370000
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM CSS_ADDR_FORMATTED                                 12380000
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                        12390000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    12420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21671     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T21671                                       RS-RETURN-CODE.            
T21671                                                                  
T21671     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21671        NEXT SENTENCE                                             
T21671     ELSE                                                         
T21671         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21671         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21671         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21671                                       ABEND-TABLES               
T21671         MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                    
T21671         MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
T21671         MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
T21671         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
T21671     END-IF.                                                      
T21671                                                                  
T21671     MOVE 'A'                   TO RS-ADDRESS-FORMAT.             
T21671     MOVE DY-HOUSE-NO           TO RS-HOUSE-NO.                   
T21671     MOVE DY-ADDR-PREFIX-1      TO RS-ADDR-PREFIX-1.              
T21671     MOVE DY-ADDR-PREFIX-2      TO RS-ADDR-PREFIX-2.              
T21671     MOVE DY-STREET-NAME        TO RS-STREET-NAME.                
T21671     MOVE DY-STREET-SUFFIX      TO RS-STREET-SUFFIX.              
T21671     MOVE DY-ADDR-SUFFIX        TO RS-ADDR-SUFFIX.                
T21671     MOVE DY-STREET-LOCATION-1  TO RS-STREET-LOCATION-1.          
T21671     MOVE DY-STREET-LOCATION-2  TO RS-STREET-LOCATION-2.          
T21671     MOVE DY-ZIP-CODE           TO RS-ZIP-CODE.                   
T21671     MOVE DY-ZIP-CODE-PLUS-FOUR TO RS-ZIP-CODE-PLUS-FOUR.         
T21671     MOVE DY-ZIP-CODE-TOKEN     TO RS-ZIP-CODE-TOKEN.             
T21671     MOVE DY-ADDRESS-OVERFLOW   TO RS-ADDRESS-OVERFLOW.           
T21671                                                                  
T21671 7810-EXIT.                                                       
T21671     EXIT.                                                        
                                                                        
T21671 7820-FREEFORM-ADDRESS.                                           
T21671                                                                  
T21671     MOVE '7820'                    TO ACTIVE-PARAGRAPH.          
T21671                                                                  
T21671     EXEC SQL                                                     
T21671        SELECT ADDR_CITY_STATE,                                   
T21671               ADDR_COUNTRY,                                      
T21671               ADDR_STREET,                                       
T21671               ADDR_ZIP_CODE,                                     
T21671               ADDRESS_OVERFLOW                                   
T21671          INTO :DZ-ADDR-CITY-STATE,                               
T21671               :DZ-ADDR-COUNTRY,                                  
T21671               :DZ-ADDR-STREET,                                   
T21671               :DZ-ADDR-ZIP-CODE,                                 
T21671               :DZ-ADDRESS-OVERFLOW                               
T21671          FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
T21671         WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
T21671                                                           
T21671     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12350000
MFA-TR*       SELECT ADDR_CITY_STATE,                                   12360000
MFA-TR*              ADDR_COUNTRY,                                              
MFA-TR*              ADDR_STREET,                                               
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDRESS_OVERFLOW                                           
MFA-TR*         INTO :DZ-ADDR-CITY-STATE,                               12370000
MFA-TR*              :DZ-ADDR-COUNTRY,                                          
MFA-TR*              :DZ-ADDR-STREET,                                           
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                         
MFA-TR*              :DZ-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM CSS_ADDR_FREEFORM                                  12380000
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        12390000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    12420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21671     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T21671                                       RS-RETURN-CODE.            
T21671                                                                  
T21671     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21671        NEXT SENTENCE                                             
T21671     ELSE                                                         
T21671         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21671         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21671         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21671                                       ABEND-TABLES               
T21671         MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                    
T21671         MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
T21671         MOVE DZ-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
T21671         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
T21671     END-IF.                                                      
T21671                                                                  
T21671     MOVE 'B'                   TO RS-ADDRESS-FORMAT.             
T21671     MOVE DZ-ADDR-STREET        TO RS-ADDR-STREET.                
T21671     MOVE DZ-ADDR-CITY-STATE    TO RS-ADDR-CITY-STATE.            
T21671     MOVE DZ-ADDR-ZIP-CODE      TO RS-ADDR-ZIP-CODE.              
T21671     MOVE DZ-ADDR-COUNTRY       TO RS-ADDR-COUNTRY.               
T21671     MOVE DZ-ADDRESS-OVERFLOW   TO RS-ADDR-OVERFLOW.              
T21671                                                                  
T21671 7820-EXIT.                                                       
T21671     EXIT.                                                        
                                                                        
T19557 9500-CALL-CPD00068.                                              
                                                                        
CVT000         CALL MCSCB068   USING CWS00068-FIELDS,                   
CVT000                               WS-CODES-DATA-PRESENT,             
CVT000                               DCLCSS-ACCOUNT,                    
CVT000                               ABEND-FILE,                        
CVT000                               RS-RETURN-CODE.                    
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
                                                                        
PCR361******************************************************************12990000
PCR361* 9700- PROCESS-ABEND ERROR HANDLING INCLUDE                     *13000000
PCR361******************************************************************13010000
PCR361     EXEC SQL                                                     13020000
PCR361        INCLUDE CPD0023C                                          13030000
PCR361     END-EXEC.                                                    13040000
PCR361*                                                                 13050000
      ******************************************************************13060000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *13070000
      ******************************************************************13080000
           EXEC SQL                                                     13090000
              INCLUDE CPDSP300                                          13100000
           END-EXEC.                                                    13110000
      *                                                                 13120000
      ******************************************************************13130000
      * 9999- END PROGRAM COPYLIB                                      *13140000
      ******************************************************************13150000
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
