       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02141.                                         
COB303 DATE-WRITTEN.                                                    
COB303            AUGUST 14, 1995.                                      
       DATE-COMPILED.                                                   
      ***************************************************************** 00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                    00080000
      *                                                                 00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).    00100000
      *                                                                 00110000
      *  TRANID:        S141                                            00120000
      *  PROGRAM:       S141                                            00130000
      *  CALLING SP:    PA_S141                                         00140000
      *                                                                 00150000
      ***************************************************************** 00160000
      *                 P R O G R A M  S U M M A R Y                    00170000
      *                                                                 00180000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              00190000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        00200000
      *                                                                 00210000
      *  THIS PROGRAM RETRIEVES TIME PERIODS FOR A TOU METER.           00220000
      *                                                                 00230000
      ***************************************************************** 00240000
      *                     PROGRAM MODIFICATION LOG                    00250000
      *                                                                 00260000
      *    DATE    INITIALS   COMMENTS                                  00270000
      *  --------  --------   ---------------------------------------   00280000
      *  08/14/95    SS       CREATED.                                  00290000
TP5186*  09/09/96    TCB      ADDED CODE TO RETRIEVE FROM               00300000
TP5186*                       CSS_MTRD_ENVRNMT THE KWH REGISTER FOR A   00310000
TP5186*                       TOU METER.                                00320000
TP5297*  09/11/96    TCB      ADDED PARAMETER FOR READ DATE AND ADDED   00330000
TP5297*                       SEASON-IND TO THE RESULT SET. USING THE   00340000
TP5297*                       READ DATE AND THE LAST READ DATE FROM     00350000
TP5297*                       CSS_REGISTER_READ THIS IS COMPARED TO     00360000
TP5297*                       DATE_FROM AND DATE_TO FROM                00370000
TP5297*                       CSS_RATE_USE_SEASN.  IF THERE IS A SEASON 00380000
TP5297*                       SPLIT AN EXTRA ROW FOR EACH REGISTER IS   00390000
TP5297*                       RETURNED TO THE USER TO ENTER PREVIOUS    00400000
TP5297*                       SEASON READS.                             00410000
T5221 *  11/06/96    JBW      TPR 5221.  SET WS-TOU-RATE-IND IN PARA    00411000
T5221 *                       7850 INSTEAD OF IN GET-UTIL-ENVRN CURSOR. 00412000
T5221 *                       ALSO CHANGED VERIFICATION OF CTR-ROW > 0  00413000
T5221 *                       TO SEE IF TOU-RATE-IND = 'N' TO DETERMINE 00414000
T5221 *                       IF LOGIC SHOULD CONTINUE. ERROR IN T5186. 00415000
      *                                                                 00420000
PCR376**   9/3/97    PD       SELECT CSS_XREF_ACCT BY JOINING WITH      00421000
PCR376**                      CSS_CUST_PREM_HIST TO TAKE CARE OF        00422000
PCR376**                      MULTIPLE OLD-ACCOUNT-NO.                  00423000
      *                                                                 00423100
T16353**  05/20/98   TDK      ADD NULL INDICATOR TO DATE_LST_NRML_BILL  00424000
T16353**                      TO PREVENT -305.                          00425000
      **  07/28/98   RTO      ADDED PREMISE NO AND IC_NO AND RATE_PLAN  00530000
CBSI  *   08/21/98   CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
C28373**  11/06/03   GSR      CHANGES MADE TO HANDLE THE NEW WQS FROM   00424000
C28373**                      PCSBW143.                                 00425000
REARCH*  09/06/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C34424*  04/04/08    PA94870  MADE CHANGES TO IDENTIFY SEASON CHANGE   *        
C34424*              WHEN READDATE IS SAME AS STRT DAY OF SEASONCHANGE *        
C34424*              ALSO, MADE CHANGES TO IDENTIFY SEASON CHANGE      *        
C34424*              WHEN READDATE IS SAME AS LAST DAY OF SEASONCHANGE *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
A05248*  10/30/15    BE09555  REMOVED UNUSED COPYBOOK CPD00033.        *        
      ** A05248-ACT004                                                  00540000
      ***************************************************************** 00430000
      ***************************************************************** 00440000
      *                                                                 00450000
      *                ---- BASIC SEQUENCE STRUCTURE ----               00460000
      *                                                                 00470000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              00480000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                     00490000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    00500000
      *  3000 - 4999  NOT USED                                          00510000
      *  5000 - 5999  COMMON PROGRAM MODULES                            00520000
      *  6000 - 6999  COMMON SYSTEM MODULES                             00530000
      *  7000 - 7999  INPUT MODULES                                     00540000
      *  8000 - 8999  OUTPUT MODULES                                    00550000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              00560000
      *                                                                 00570000
      ***************************************************************** 00580000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02141'.
MSQ017     COPY MFASQLM.
      *                                                                 00630000
       01  WS-START                    PIC X(40)                        
REARCH     VALUE 'WORKING STORAGE FOR CSR02141 STARTS HERE'.            
      ***************************************************************** 00680000
      * DB2 INCLUDES                                                  * 00690000
      ***************************************************************** 00700000
           EXEC SQL                                                     00720000
               INCLUDE TBMODEL                                          00730000
           END-EXEC.                                                    00740000
                                                                        
           EXEC SQL                                                     00760000
               INCLUDE SQLCA                                            00770000
           END-EXEC.                                                    00780000
                                                                        
           EXEC SQL                                                     00800000
               INCLUDE TBACCT                                           00810000
           END-EXEC.                                                    00820000
                                                                        
TP5186     EXEC SQL                                                     00840000
TP5186         INCLUDE TBMTRENV                                         00850000
TP5186     END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00880000
               INCLUDE TBRGREAD                                         00890000
           END-EXEC.                                                    00900000
                                                                        
TP5297     EXEC SQL                                                     00920000
TP5297         INCLUDE TBRTDESC                                         00930000
TP5297     END-EXEC.                                                    00940000
                                                                        
TP5297     EXEC SQL                                                     00960000
TP5297         INCLUDE TBRTUSES                                         00970000
TP5297     END-EXEC.                                                    00980000
                                                                        
           EXEC SQL                                                     01000000
               INCLUDE TBUTLENV                                         01010000
           END-EXEC.                                                    01020000
                                                                        
           EXEC SQL                                                     01040000
               INCLUDE TBXREF                                           01050000
           END-EXEC.                                                    01060000
      *                                                                 01070000
PCR376     EXEC SQL                                                     01080000
PCR376        INCLUDE TBCSTPRM                                          01081000
PCR376     END-EXEC.                                                    01082000
C28373* CSS_RATE_VRSN_DEF                                                       
C28373     EXEC SQL                                                             
C28373         INCLUDE TBRTVRSN                                                 
C28373     END-EXEC.                                                            
      ***************************************************************** 01090000
      *    COBOL WORKING STORAGE COPY BOOKS                             01100000
      ***************************************************************** 01110000
REARCH*COPY SYGWCOB.                                                    01130000
REARCH*COPY SYDBCOB.                                                    01140000
       COPY CCA00001.                                                   01150000
       COPY CWS00004.                                                   01160000
       COPY CWS00005.                                                   01170000
REARCH*COPY CWS00010.                                                   01180000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
       COPY CWS00027.                                                   01190000
       COPY CWS00031.                                                   01200000
       COPY CWS00033.                                                   01210000
       COPY CWS00303.                                                   01230000
           EXEC SQL                                                     01250000
               INCLUDE CWS00013                                         01260000
           END-EXEC.                                                    01270000
      ***************************************************************** 01290000
      * WORK AREAS                                                    * 01300000
      ***************************************************************** 01310000
       01  WS-WORK-AREA.                                                
REARCH     05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02141'.    
           05  WS-SCREEN-FIELD-KEYS.                                    
               10  WS-METER-NO           PIC X(09).                     
               10  WS-MTR-REF-NO         PIC S9(04) COMP.               
COB305         10 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
               10  WS-ACTIVE-RETURN-CODE-MC PIC S9(04) USAGE COMP.      
           05  WS-FEEDBACK-KEY-IC.                                      
               10  FILLER                  PIC X(06).                   
               10  WS-UTIL-TYPE            PIC X.                       
COB305         10 WS-IC-NO        PIC S9(03) COMP-3 VALUE 0.           
               10  WS-CODE-TIME-PERIOD     PIC X.                       
COB305         10 WS-PRIMARY-SEQ-NO        PIC S9(03) COMP-3 VALUE 0.           
               10  WS-CODE-USAGE-VALUES    PIC XXX.                     
           05  WS-REGISTER-TYPE.                                        
               10  WS-CODE-USAGE-TYPE   PIC X(1) VALUE SPACES.          
               10  WS-CODE-USAGE-ID     PIC X(1) VALUE SPACES.          
               10  WS-CODE-USAGE-SOURCE PIC X(1) VALUE SPACES.          
TP5297     05  WS-DATE-BREAKDWN.                                        
TP5297         10  WS-YEAR              PIC X(4) VALUE SPACES.          
TP5297         10  FILLER               PIC X(1) VALUE SPACES.          
TP5297         10  WS-MONTH             PIC X(2) VALUE SPACES.          
TP5297         10  FILLER               PIC X(1) VALUE SPACES.          
TP5297         10  WS-DAY               PIC X(2) VALUE SPACES.          
TP5297     05  WS-MONTH-DAY-NUM         PIC 9(4) VALUE ZEROES.          
TP5297     05  WS-MONTH-DAY-NUM-COMP    PIC 9(4) USAGE COMP.            
TP5297     05  WS-MONTH-DAY.                                            
TP5297         10  WS-MONTH-RED         PIC X(2) VALUE SPACES.          
TP5297         10  WS-DAY-RED           PIC X(2) VALUE SPACES.          
TP5297     05  WS-DATE-BREAKDWN2.                                       
TP5297         10  WS-YEAR2             PIC X(4) VALUE SPACES.          
TP5297         10  FILLER               PIC X(1) VALUE SPACES.          
TP5297         10  WS-MONTH2            PIC X(2) VALUE SPACES.          
TP5297         10  FILLER               PIC X(1) VALUE SPACES.          
TP5297         10  WS-DAY2              PIC X(2) VALUE SPACES.          
TP5297     05  WS-MONTH-DAY-NUM2        PIC 9(4) VALUE ZEROES.          
TP5297     05  WS-MONTH-DAY-NUM-COMP2   PIC 9(4) USAGE COMP.            
TP5297     05  WS-MONTH-DAY2.                                           
TP5297         10  WS-MONTH-RED2        PIC X(2) VALUE SPACES.          
TP5297         10  WS-DAY-RED2          PIC X(2) VALUE SPACES.          
TP5297     05  WS-NULL-IND2             PIC S9(4) COMP.                 
T16353     05  WS-NULL-IND3             PIC S9(4) COMP.                 
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-NEG-ONE                  PIC S9(04) COMP-3 VALUE -1.  
           05  WS-0                        PIC S9      VALUE +0.        
           05  WS-100                      PIC S9(03)  VALUE +100.      
           05  WS-200                      PIC S9(03)  VALUE +200.      
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
TP5297     05  WS-C                        PIC X(01)   VALUE 'C'.       
           05  WS-E                        PIC X(01)   VALUE 'E'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
TP5186     05  WS-K                        PIC X(01)   VALUE 'K'.       
TP5297     05  WS-P                        PIC X(01)   VALUE 'P'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
TP5297     05  WS-U                        PIC X(01)   VALUE 'U'.       
           05  WS-KW                       PIC X(02)   VALUE 'KW'.      
           05  WS-KWH                      PIC X(03)   VALUE 'KWH'.     
           05  WS-KVA                      PIC X(03)   VALUE 'KVA'.     
           05  WS-KVR                      PIC X(03)   VALUE 'KVR'.     
       01  WS-MISC.                                                     
REARCH     05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
T5221      05  WS-TOU-IND               PIC X(01) VALUE 'N'.            
               88 TOU-METER                       VALUE 'Y'.            
               88 NOT-TOU-METER                   VALUE 'N'.            
REARCH*01  GW-LIB-MISC-FIELDS.                                          02230000
REARCH*    05  GWL-PROC                 POINTER.                        02240000
REARCH*    05  GWL-INIT-HANDLE          POINTER.                        02250000
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                 02260000
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 02270000
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 02280000
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 02290000
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 02300000
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 02310000
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 02320000
REARCH*                                                                 02330000
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02141_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  WS-END                       PIC X(40)                       
REARCH     VALUE 'WORKING STORAGE FOR CSR02141 ENDS HERE  '.            
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH 01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9) COMP.                  02410000
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          02420000
REARCH*    05  PARM-SELECT-TYPE        PIC X(1) VALUE SPACES.           02320003
REARCH*    05  PARM-CODE-UTIL-TYPE     PIC X(1) VALUE SPACES.           02330003
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          02430000
REARCH*    05  PARM-ACCOUNT-NO-RED                                      02440000
REARCH*                     REDEFINES PARM-ACCOUNT-NO PIC 9(13).        02450000
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED                                      
REARCH                      REDEFINES PARM-ACCOUNT-NO-TEMP PIC 9(13).   
REARCH*    05  PARM-METER-NO           PIC X(9)  VALUE SPACES.          02460000
TP5297*    05  PARM-READ-DATE          PIC X(10) VALUE SPACES.          02470000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-ERROR-CODE            PIC S9(9) COMP VALUE 0.         
           05  RS-TIME-PERIOD           PIC S9(4) COMP VALUE 0.         
           05  RS-REGISTER-TYPE         PIC X(03) VALUE SPACES.         
           05  RS-UTILITY-TYPE          PIC X(01) VALUE SPACES.         
TP5297     05  RS-SEASON-IND            PIC X(01) VALUE SPACES.         
           05  RS-PREMISE-NO            PIC X(10) VALUE SPACES.         
           05  RS-IC-NO                PIC S9(04)                       
                                                 VALUE 0 COMP.          
           05  RS-RATE-PLAN-NO-RET     PIC X(03) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-ERROR-CODE            PIC S9(9) COMP VALUE 0.          
REARCH     05  S-TIME-PERIOD           PIC S9(4) COMP VALUE 0.          
REARCH     05  S-REGISTER-TYPE         PIC X(03) VALUE SPACES.          
REARCH     05  S-UTILITY-TYPE          PIC X(01) VALUE SPACES.          
REARCH     05  S-SEASON-IND            PIC X(01) VALUE SPACES.          
REARCH     05  S-PREMISE-NO            PIC X(10) VALUE SPACES.          
REARCH     05  S-IC-NO                 PIC S9(04)                       
REARCH                                           COMP VALUE 0.          
REARCH     05  S-RATE-PLAN-NO-RET      PIC X(03) VALUE SPACES.          
REARCH*01  CN-COLUMN-NAMES.                                             02720000
REARCH*    05  CN-RETURN-CODE   PIC X(11) VALUE 'RETURN_CODE'.          02730000
REARCH*    05  CN-ERROR-CODE    PIC X(10) VALUE 'ERROR_CODE'.           02740000
REARCH*    05  CN-TIME-PERIOD   PIC X(11) VALUE 'TIME_PERIOD'.          02750000
REARCH*    05  CN-REGISTER-TYPE PIC X(13) VALUE 'REGISTER_TYPE'.        02760000
REARCH*    05  CN-UTILITY-TYPE  PIC X(12) VALUE 'UTILITY_TYPE'.         02770000
TP5297*    05  CN-SEASON-IND    PIC X(10) VALUE 'SEASON_IND'.           02780000
REARCH*    05  CN-PREMISE-NO    PIC X(10) VALUE 'PREMISE_NO'.           02740000
REARCH*    05  CN-IC-NO         PIC X(10) VALUE 'IC_NO'.                02750000
REARCH*    05  CN-RATE-PLAN-NO-RET  PIC X(12) VALUE 'RATE_PLAN_NO'.     02760001
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ***************************************************************** 02800000
      * CURSOR DECLARATIONS                                           * 02810000
      ***************************************************************** 02820000
           EXEC SQL                                                     
              DECLARE RG_CRSR CURSOR FOR                                
               SELECT MTR_REF_NO,                                       
                      METER_NO,                                         
                      CODE_USAGE_TYPE,                                  
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      CODE_TIME_PERIOD,                                 
TP5297                LAST_REG_READ_DT                                  
                 FROM CSS_REGISTER_READ                                 
                WHERE ACCOUNT_NO     = :RG-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :RG-CODE-UTIL-TYPE               
                  AND IC_NO          = :RG-IC-NO                        
           END-EXEC.                                                    
REARCH*                                                                         
       LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-SELECT-TYPE        PIC X(1).                            
REARCH 01  PARM-CODE-UTIL-TYPE     PIC X(1).                            
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-METER-NO           PIC X(9).                            
REARCH 01  PARM-READ-DATE          PIC X(10).                           
      *                                                                 03110000
REARCH PROCEDURE DIVISION USING PARM-SELECT-TYPE                        
                                PARM-CODE-UTIL-TYPE                     
                                PARM-ACCOUNT-NO                         
                                PARM-METER-NO                           
                                PARM-READ-DATE.                         
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03140000
      **                                                              **03150000
      **    0000-MAINLINE                                             **03160000
      **                                                              **03170000
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **03180000
      **                                                              **03190000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03200000
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03230000
           PERFORM 0100-INITIALIZE         THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
      *                                                                 03280000
       0000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 03320000
      * 0100-INITIALIZE                                                 03330000
      *                                                                 03340000
      *     1. RESET DB2 ERROR HANDLERS                                 03350000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                   03360000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)    03370000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT) 03380000
      *                                                                 03390000
      ***************************************************************** 03400000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03480000
REARCH*                                                                 03490000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03500000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03501000
REARCH*                                                                 03510000
REARCH*                                                                 03520000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03530000
REARCH*                                                                 03540000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03550000
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     03560000
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  03570000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      03580000
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      03590000
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        03600000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            03610000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            03620000
REARCH*    END-IF.                                                      03630000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,ERROR_CODE                                         
REARCH              ,TIME_PERIOD                                        
REARCH              ,LTRIM(RTRIM(REGISTER_TYPE))  AS  REGISTER_TYPE            
REARCH              ,LTRIM(RTRIM(UTILITY_TYPE))   AS  UTILITY_TYPE             
REARCH              ,LTRIM(RTRIM(SEASON_IND))     AS  SEASON_IND               
REARCH              ,LTRIM(RTRIM(PREMISE_NO))     AS  PREMISE_NO               
REARCH              ,IC_NO                                              
REARCH              ,LTRIM(RTRIM(RATE_PLAN_NO))   AS  RATE_PLAN_NO             
REARCH          FROM                                                    
REARCH               #CSR02141_R1                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ERROR_CODE                                                 
MFA-TR*             ,TIME_PERIOD                                                
MFA-TR*             ,STRIP(REGISTER_TYPE)  AS  REGISTER_TYPE                    
MFA-TR*             ,STRIP(UTILITY_TYPE)   AS  UTILITY_TYPE                     
MFA-TR*             ,STRIP(SEASON_IND)     AS  SEASON_IND                       
MFA-TR*             ,STRIP(PREMISE_NO)     AS  PREMISE_NO                       
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,STRIP(RATE_PLAN_NO)   AS  RATE_PLAN_NO                     
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02141_R1                                        
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT                                               *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02141_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02141_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02141_R1
              (                                                       
REARCH               RETURN_CODE        INT                         
REARCH              ,ERROR_CODE         INT                         
REARCH              ,TIME_PERIOD        SMALLINT                        
REARCH              ,REGISTER_TYPE CHAR(3)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,UTILITY_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,SEASON_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,PREMISE_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,IC_NO              SMALLINT                        
REARCH              ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH                NEXT SENTENCE                                     
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
REARCH            MOVE SQLCODE            TO ABEND-SQLCODE              
REARCH            MOVE SQLSTATE           TO ABEND-SQLSTATE             
REARCH            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
REARCH            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
REARCH            MOVE SPACES             TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH            MOVE 'CSR02141_R1'      TO TABLE-1                    
REARCH            MOVE SPACES             TO TABLE-ELEMENT-1            
REARCH            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                    THRU  9900-EXIT               
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ***************************************************************** 03690000
      * 1000-PROCESS-INPUT                                              03700000
      *     1. RECEIVE PARMS.                                           03710000
      ***************************************************************** 03720000
       1000-PROCESS-INPUT.                                              
      *                                                                 03750000
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               03760000
      *                                                                 03770000
       1000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 03810000
      * 1100-RECEIVE-PARMS                                              03820000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE            03830000
      ***************************************************************** 03840000
REARCH*1100-RECEIVE-PARMS.                                              03860000
REARCH*                                                                 03870000
REARCH*    MOVE 1                           TO PARM-ID1.                03640003
REARCH*    MOVE LENGTH OF PARM-SELECT-TYPE TO MAX-LENGTH-PARM,          03650003
REARCH*                                                                 03660000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03670000
REARCH*                          GWL-RC,                                03680000
REARCH*                          PARM-ID1,                              03690000
REARCH*                          PARM-SELECT-TYPE,                      03700003
REARCH*                          TDSCHAR,                               03710000
REARCH*                          MAX-LENGTH-PARM,                       03720000
REARCH*                          PARM-L.                                03730000
REARCH*                                                                 03740000
REARCH*    ADD 1                            TO PARM-ID1.                03750003
REARCH*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE TO MAX-LENGTH-PARM,       03760003
REARCH*                                                                 03770003
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03780003
REARCH*                          GWL-RC,                                03790003
REARCH*                          PARM-ID1,                              03800003
REARCH*                          PARM-CODE-UTIL-TYPE,                   03810003
REARCH*                          TDSCHAR,                               03820003
REARCH*                          MAX-LENGTH-PARM,                       03830003
REARCH*                          PARM-L.                                03840003
REARCH*                                                                 03850003
REARCH*    ADD  1                            TO PARM-ID1.               03860003
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM,        03890000
REARCH*                                                                 03900000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03910000
REARCH*                          GWL-RC,                                03920000
REARCH*                          PARM-ID1,                              03930000
REARCH*                          PARM-ACCOUNT-NO,                       03940000
REARCH*                          TDSCHAR,                               03950000
REARCH*                          MAX-LENGTH-PARM,                       03960000
REARCH*                          PARM-L.                                03970000
REARCH*                                                                 03980000
REARCH*    ADD 1                            TO PARM-ID1.                03990000
REARCH*    MOVE LENGTH OF PARM-METER-NO      TO MAX-LENGTH-PARM,        04000000
REARCH*                                                                 04010000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04020000
REARCH*                          GWL-RC,                                04030000
REARCH*                          PARM-ID1,                              04040000
REARCH*                          PARM-METER-NO,                         04050000
REARCH*                          TDSCHAR,                               04060000
REARCH*                          MAX-LENGTH-PARM,                       04070000
REARCH*                          PARM-L.                                04080000
REARCH*                                                                 04090000
TP5297*    ADD 1                            TO PARM-ID1.                04100000
TP5297*    MOVE LENGTH OF PARM-READ-DATE     TO MAX-LENGTH-PARM,        04110000
TP5297*                                                                 04120000
TP5297*    CALL 'TDRCVPRM' USING GWL-PROC,                              04130000
TP5297*                          GWL-RC,                                04140000
TP5297*                          PARM-ID1,                              04150000
TP5297*                          PARM-READ-DATE,                        04160000
TP5297*                          TDSCHAR,                               04170000
TP5297*                          MAX-LENGTH-PARM,                       04180000
TP5297*                          PARM-L.                                04190000
REARCH*                                                                 04200000
REARCH*1100-EXIT.                                                       04210000
REARCH*    EXIT.                                                        04220000
      ***************************************************************** 04250000
      * 2000-PROCESS-OUTPUT.                                            04260000
      *                                                                 04270000
      *     1. DESCRIBE RESULT SET                                      04280000
      *     2. UPDATE DB2 DATA                                          04290000
      *     3. BUILD RESULT SET                                         04300000
      *     4. SEND RESULT SET                                          04310000
      *                                                                 04320000
      ***************************************************************** 04330000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 04360000
REARCH*    PERFORM 2010-DESCRIBE-RESULT THRU 2010-EXIT.                 04370000
           PERFORM 2100-EDIT-PARMS      THRU 2100-EXIT.                 
      *                                                                 04390000
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE      TO S-RETURN-CODE.                  
REARCH     MOVE  RS-ERROR-CODE       TO S-ERROR-CODE.                   
REARCH     MOVE  RS-TIME-PERIOD      TO S-TIME-PERIOD.                  
REARCH     MOVE  RS-REGISTER-TYPE    TO S-REGISTER-TYPE.                
REARCH     MOVE  RS-UTILITY-TYPE     TO S-UTILITY-TYPE.                 
REARCH     MOVE  RS-SEASON-IND       TO S-SEASON-IND.                   
REARCH     MOVE  RS-PREMISE-NO       TO S-PREMISE-NO.                   
REARCH     MOVE  RS-IC-NO            TO S-IC-NO.                        
REARCH     MOVE  RS-RATE-PLAN-NO-RET TO S-RATE-PLAN-NO-RET.             
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ***************************************************************** 04430000
      * 2010-DESCRIBE-RESULT                                            04440000
      *                                                                 04450000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                     04460000
      *                                                                 04470000
      ***************************************************************** 04480000
REARCH*                                                                         
REARCH*2010-DESCRIBE-RESULT.                                            04500000
REARCH*                                                                 04530000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  04540000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                04550000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              04560000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    04570000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    04580000
REARCH*                                                                 04590000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04600000
REARCH*                          GWL-RC,                                04610000
REARCH*                          CTR-COLUMN,                            04620000
REARCH*                          DB-HOST-TYPE,                          04630000
REARCH*                          WRKLEN1,                               04640000
REARCH*                          RS-RETURN-CODE,                        04650000
REARCH*                          DB-NULL-INDICATOR,                     04660000
REARCH*                          TDS-FALSE,                             04670000
REARCH*                          DB-CLIENT-TYPE,                        04680000
REARCH*                          WRKLEN1,                               04690000
REARCH*                          CN-RETURN-CODE,                        04700000
REARCH*                          WRKLEN2.                               04710000
REARCH*                                                                 04720000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04730000
REARCH*                                                                 04740000
REARCH*    ADD  1       TO CTR-COLUMN.                                  04750000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                04760000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              04770000
REARCH*    MOVE LENGTH OF RS-ERROR-CODE  TO WRKLEN1.                    04780000
REARCH*    MOVE LENGTH OF CN-ERROR-CODE  TO WRKLEN2.                    04790000
REARCH*                                                                 04800000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04810000
REARCH*                          GWL-RC,                                04820000
REARCH*                          CTR-COLUMN,                            04830000
REARCH*                          DB-HOST-TYPE,                          04840000
REARCH*                          WRKLEN1,                               04850000
REARCH*                          RS-ERROR-CODE,                         04860000
REARCH*                          DB-NULL-INDICATOR,                     04870000
REARCH*                          TDS-FALSE,                             04880000
REARCH*                          DB-CLIENT-TYPE,                        04890000
REARCH*                          WRKLEN1,                               04900000
REARCH*                          CN-ERROR-CODE,                         04910000
REARCH*                          WRKLEN2.                               04920000
REARCH*                                                                 04930000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04940000
REARCH*                                                                 04950000
REARCH*    ADD  1       TO CTR-COLUMN.                                  04960000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                04970000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              04980000
REARCH*    MOVE LENGTH OF RS-TIME-PERIOD TO WRKLEN1.                    04990000
REARCH*    MOVE LENGTH OF CN-TIME-PERIOD TO WRKLEN2.                    05000000
REARCH*                                                                 05010000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05020000
REARCH*                          GWL-RC,                                05030000
REARCH*                          CTR-COLUMN,                            05040000
REARCH*                          DB-HOST-TYPE,                          05050000
REARCH*                          WRKLEN1,                               05060000
REARCH*                          RS-TIME-PERIOD,                        05070000
REARCH*                          DB-NULL-INDICATOR,                     05080000
REARCH*                          TDS-FALSE,                             05090000
REARCH*                          DB-CLIENT-TYPE,                        05100000
REARCH*                          WRKLEN1,                               05110000
REARCH*                          CN-TIME-PERIOD,                        05120000
REARCH*                          WRKLEN2.                               05130000
REARCH*                                                                 05140000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05150000
REARCH*                                                                 05160000
REARCH*    ADD  1       TO CTR-COLUMN.                                  05170000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05180000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05190000
REARCH*    MOVE LENGTH OF RS-REGISTER-TYPE TO WRKLEN1.                  05200000
REARCH*    MOVE LENGTH OF CN-REGISTER-TYPE TO WRKLEN2.                  05210000
REARCH*                                                                 05220000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05230000
REARCH*                          GWL-RC,                                05240000
REARCH*                          CTR-COLUMN,                            05250000
REARCH*                          DB-HOST-TYPE,                          05260000
REARCH*                          WRKLEN1,                               05270000
REARCH*                          RS-REGISTER-TYPE,                      05280000
REARCH*                          DB-NULL-INDICATOR,                     05290000
REARCH*                          TDS-FALSE,                             05300000
REARCH*                          DB-CLIENT-TYPE,                        05310000
REARCH*                          WRKLEN1,                               05320000
REARCH*                          CN-REGISTER-TYPE,                      05330000
REARCH*                          WRKLEN2.                               05340000
REARCH*                                                                 05350000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05360000
REARCH*                                                                 05370000
REARCH*    ADD  1       TO CTR-COLUMN.                                  05380000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05390000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05400000
REARCH*    MOVE LENGTH OF RS-UTILITY-TYPE TO WRKLEN1.                   05410000
REARCH*    MOVE LENGTH OF CN-UTILITY-TYPE TO WRKLEN2.                   05420000
REARCH*                                                                 05430000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05440000
REARCH*                          GWL-RC,                                05450000
REARCH*                          CTR-COLUMN,                            05460000
REARCH*                          DB-HOST-TYPE,                          05470000
REARCH*                          WRKLEN1,                               05480000
REARCH*                          RS-UTILITY-TYPE,                       05490000
REARCH*                          DB-NULL-INDICATOR,                     05500000
REARCH*                          TDS-FALSE,                             05510000
REARCH*                          DB-CLIENT-TYPE,                        05520000
REARCH*                          WRKLEN1,                               05530000
REARCH*                          CN-UTILITY-TYPE,                       05540000
REARCH*                          WRKLEN2.                               05550000
REARCH*                                                                 05560000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05570000
REARCH*                                                                 05580000
TP5297*    ADD  1       TO CTR-COLUMN.                                  05590000
TP5297*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05600000
TP5297*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05610000
TP5297*    MOVE LENGTH OF RS-SEASON-IND TO WRKLEN1.                     05620000
TP5297*    MOVE LENGTH OF CN-SEASON-IND TO WRKLEN2.                     05630000
REARCH*                                                                 05640000
TP5297*    CALL 'TDESCRIB' USING GWL-PROC,                              05650000
TP5297*                          GWL-RC,                                05660000
TP5297*                          CTR-COLUMN,                            05670000
TP5297*                          DB-HOST-TYPE,                          05680000
TP5297*                          WRKLEN1,                               05690000
TP5297*                          RS-SEASON-IND,                         05700000
TP5297*                          DB-NULL-INDICATOR,                     05710000
TP5297*                          TDS-FALSE,                             05720000
TP5297*                          DB-CLIENT-TYPE,                        05730000
TP5297*                          WRKLEN1,                               05740000
TP5297*                          CN-SEASON-IND,                         05750000
TP5297*                          WRKLEN2.                               05760000
REARCH*                                                                 05770000
TP5297*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05780000
REARCH*                                                                 05790000
REARCH*    ADD  1       TO CTR-COLUMN.                                  05710000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05720000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05730000
REARCH*    MOVE LENGTH OF RS-PREMISE-NO TO WRKLEN1.                     05740000
REARCH*    MOVE LENGTH OF CN-PREMISE-NO TO WRKLEN2.                     05750000
REARCH*                                                                 05760000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05770000
REARCH*                          GWL-RC,                                05780000
REARCH*                          CTR-COLUMN,                            05790000
REARCH*                          DB-HOST-TYPE,                          05800000
REARCH*                          WRKLEN1,                               05810000
REARCH*                          RS-PREMISE-NO,                         05820000
REARCH*                          DB-NULL-INDICATOR,                     05830000
REARCH*                          TDS-FALSE,                             05840000
REARCH*                          DB-CLIENT-TYPE,                        05850000
REARCH*                          WRKLEN1,                               05860000
REARCH*                          CN-PREMISE-NO,                         05870000
REARCH*                          WRKLEN2.                               05880000
REARCH*                                                                 05890000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05900000
REARCH*                                                                 05910000
REARCH*    ADD  1       TO CTR-COLUMN.                                  05920000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                05930000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              05940000
REARCH*    MOVE LENGTH OF RS-IC-NO TO WRKLEN1.                          05950000
REARCH*    MOVE LENGTH OF CN-IC-NO TO WRKLEN2.                          05960000
REARCH*                                                                 05970000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05980000
REARCH*                          GWL-RC,                                05990000
REARCH*                          CTR-COLUMN,                            06000000
REARCH*                          DB-HOST-TYPE,                          06010000
REARCH*                          WRKLEN1,                               06020000
REARCH*                          RS-IC-NO,                              06030000
REARCH*                          DB-NULL-INDICATOR,                     06040000
REARCH*                          TDS-FALSE,                             06050000
REARCH*                          DB-CLIENT-TYPE,                        06060000
REARCH*                          WRKLEN1,                               06070000
REARCH*                          CN-IC-NO,                              06080000
REARCH*                          WRKLEN2.                               06090000
REARCH*                                                                 06100000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06110000
REARCH*                                                                 06120000
REARCH*    ADD  1       TO CTR-COLUMN.                                  06130000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                06140000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              06150000
REARCH*    MOVE LENGTH OF RS-RATE-PLAN-NO-RET TO WRKLEN1.               06160001
REARCH*    MOVE LENGTH OF CN-RATE-PLAN-NO-RET TO WRKLEN2.               06170001
REARCH*                                                                 06180000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06190000
REARCH*                          GWL-RC,                                06200000
REARCH*                          CTR-COLUMN,                            06210000
REARCH*                          DB-HOST-TYPE,                          06220000
REARCH*                          WRKLEN1,                               06230000
REARCH*                          RS-RATE-PLAN-NO-RET,                   06240001
REARCH*                          DB-NULL-INDICATOR,                     06250000
REARCH*                          TDS-FALSE,                             06260000
REARCH*                          DB-CLIENT-TYPE,                        06270000
REARCH*                          WRKLEN1,                               06280000
REARCH*                          CN-RATE-PLAN-NO-RET,                   06290001
REARCH*                          WRKLEN2.                               06300000
REARCH*                                                                 06310000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06320000
REARCH*                                                                 06330000
REARCH*2010-EXIT.                                                       05800000
REARCH*    EXIT.                                                        05810000
      *                                                                 05820000
       2100-EDIT-PARMS.                                                 
           MOVE PARM-ACCOUNT-NO-RED TO WS-ACCOUNT-NO                    
                                       AT-ACCOUNT-NO.                   
           PERFORM 7010-SELECT-ACCOUNT   THRU 7010-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                  
              PERFORM 5400-GET-OLD-ACCOUNT    THRU 5400-EXIT            
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 0 TO RS-RETURN-CODE                                  
              MOVE 100 TO RS-ERROR-CODE                                 
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              GO TO 2100-EXIT                                           
           END-IF.                                                      
           MOVE AT-ACCOUNT-NO     TO MN-ACCOUNT-NO                      
                                     UT-ACCOUNT-NO.                     
           MOVE PARM-METER-NO     TO WS-METER-NO                        
                                     MN-METER-NO.                       
      *    MOVE 'E'               TO MN-CODE-UTIL-TYPE.                 06540003
           MOVE PARM-CODE-UTIL-TYPE TO MN-CODE-UTIL-TYPE.               
TP5297     MOVE PARM-READ-DATE    TO WS-DATE-BREAKDWN2.                 
TP5297     MOVE WS-MONTH2         TO WS-MONTH-RED2.                     
TP5297     MOVE WS-DAY2           TO WS-DAY-RED2.                       
TP5297     MOVE WS-MONTH-DAY2     TO WS-MONTH-DAY-NUM2.                 
TP5297     MOVE WS-MONTH-DAY-NUM2 TO WS-MONTH-DAY-NUM-COMP2.            
           PERFORM 7020-SELECT-MTRD-ENVRNMT THRU 7020-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 0 TO RS-RETURN-CODE                                  
              MOVE 200 TO RS-ERROR-CODE                                 
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              GO TO 2100-EXIT                                           
           END-IF.                                                      
           MOVE MN-IC-NO TO UT-IC-NO.                                   
           MOVE MN-MTR-REF-NO TO WS-MTR-REF-NO.                         
      *    MOVE 'E' TO UT-CODE-UTIL-TYPE.                               06700003
           MOVE PARM-CODE-UTIL-TYPE TO UT-CODE-UTIL-TYPE.               
           PERFORM 7030-SELECT-UTIL-ENVRNMT THRU 7030-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 0 TO RS-RETURN-CODE                                  
              MOVE 200 TO RS-ERROR-CODE                                 
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              GO TO 2100-EXIT                                           
           END-IF.                                                      
           MOVE UT-RATE-PLAN-NO TO RS-RATE-PLAN-NO-RET.                 
           MOVE UT-IC-NO TO RS-IC-NO.                                   
      * SINCE THIS RETRIEVE WILL BE DONE FOR EITHER GAS OR ELECTRIC     06810004
      * ONLY EXECUTE THE FOLLOWING CODE IF TOU WAS SELECT FROM PANEL    06820004
           IF PARM-SELECT-TYPE = 2                                      
              PERFORM 2110-FIND-REGISTERS THRU 2110-EXIT
           END-IF.               
           IF CTR-ROWS < 1                                              
              MOVE 0 TO RS-RETURN-CODE                                  
              MOVE 0 TO RS-ERROR-CODE                                   
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06240000
       2110-FIND-REGISTERS.                                             
C28373     SET NOT-TOU-METER           TO TRUE.                         
T5221      PERFORM 7850-SELECT-TOU-IND THRU 7850-EXIT.                  
C28373*IF RRI IS TOU OR TOU-IDR OR TOU-MANUAL, SET THE FLAG TO TRUE     06285000
C28373     IF MN-REMOTE-READ-IND EQUAL 'T' OR 'B' OR 'M'                
C28373        SET TOU-METER            TO TRUE                          
C28373     END-IF.                                                      
T5221      IF NOT-TOU-METER                                             
T5221         MOVE 0 TO RS-RETURN-CODE                                  
T5221         MOVE 200 TO RS-ERROR-CODE                                 
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T5221         PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
T5221         GO TO 2100-EXIT                                           
T5221      END-IF.                                                      
           MOVE MN-CODE-USAGE-TYPE     TO WS-CODE-USAGE-TYPE            
           MOVE MN-CODE-USAGE-ID       TO WS-CODE-USAGE-ID              
           MOVE MN-CODE-USAGE-SOURCE   TO WS-CODE-USAGE-SOURCE          
           MOVE WS-REGISTER-TYPE       TO RS-REGISTER-TYPE              
           MOVE MN-CODE-UTIL-TYPE      TO RS-UTILITY-TYPE               
           MOVE MN-CODE-TIME-PERIOD    TO RS-TIME-PERIOD                
           MOVE 'C'                    TO RS-SEASON-IND                 
           MOVE 0                      TO RS-RETURN-CODE                
           MOVE 0                      TO RS-ERROR-CODE                 
      * SEND PRIMARY REGISTER INFORMATION                               06451000
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
      *                                                                 06470000
TP5297     MOVE UT-CODE-UTIL-TYPE      TO RS-CODE-UTIL-TYPE             
TP5297                                    RD-CODE-UTIL-TYPE             
C28373                                    J4-CODE-UTIL-TYPE.            
TP5297     MOVE UT-RATE-PLAN-NO        TO RS-RATE-PLAN-NO               
TP5297                                    RD-RATE-PLAN-NO               
C28373                                    J4-RATE-PLAN-NO.              
TP5297     MOVE 'C'                    TO RS-CODE-USE-INST-TYPE.        
TP5297     PERFORM 7510-SELECT-MAX-VERSION       THRU 7510-EXIT.        
TP5297     PERFORM 7500-SELECT-RATE-USE-SEASN    THRU 7500-EXIT.        
TP5297     PERFORM 7520-SELECT-RATE-PLAN-DESC    THRU 7520-EXIT.        
C28373     MOVE RS-VERSION-NO-CNTRL    TO J4-VERSION-NO-CNTRL           
C28373     PERFORM 7530-SELECT-SEASN-PRT-TYPE    THRU 7530-EXIT         
           MOVE UT-CODE-UTIL-TYPE      TO RG-CODE-UTIL-TYPE.            
           MOVE UT-IC-NO               TO RG-IC-NO.                     
           MOVE UT-ACCOUNT-NO          TO RG-ACCOUNT-NO.                
           PERFORM 7350-OPEN-REG-READ            THRU 7350-EXIT.        
           PERFORM 7360-FETCH-REG-READ           THRU 7360-EXIT.        
           PERFORM 2120-PROCESS-RG               THRU 2120-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7370-CLOSE-REG-READ           THRU 7370-EXIT.        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06630000
       2120-PROCESS-RG.                                                 
           IF  RG-METER-NO EQUAL WS-METER-NO                            
            AND TOU-METER                                               
              PERFORM 2130-GET-REG-TYPE THRU 2130-EXIT                  
              MOVE RG-CODE-UTIL-TYPE   TO RS-UTILITY-TYPE               
              MOVE RG-CODE-TIME-PERIOD TO RS-TIME-PERIOD                
              MOVE WS-0                TO RS-RETURN-CODE                
              MOVE WS-0                TO RS-ERROR-CODE                 
TP5297        IF WS-NULL-IND2 >= 0                                      
TP5297           MOVE RG-LAST-REG-READ-DT TO WS-DATE-BREAKDWN           
TP5297           MOVE WS-MONTH            TO WS-MONTH-RED               
TP5297           MOVE WS-DAY              TO WS-DAY-RED                 
TP5297           MOVE WS-MONTH-DAY        TO WS-MONTH-DAY-NUM           
TP5297           MOVE WS-MONTH-DAY-NUM    TO WS-MONTH-DAY-NUM-COMP      
TP5297           IF (WS-MONTH-DAY-NUM-COMP < RS-DATE-FROM               
C34424               AND WS-MONTH-DAY-NUM-COMP2 >= RS-DATE-FROM)        
C34424            OR (WS-MONTH-DAY-NUM-COMP <= RS-DATE-TO               
TP5297                AND WS-MONTH-DAY-NUM-COMP2 > RS-DATE-TO)          
C28373              IF J4-SEAS-PRORATE-CD EQUAL WS-U                    
TP5297                 MOVE 'P' TO RS-SEASON-IND                        
REARCH                 PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT        
TP5297                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
TP5297              END-IF                                              
TP5297           END-IF                                                 
TP5297        END-IF                                                    
TP5297        MOVE 'C' TO RS-SEASON-IND                                 
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
           PERFORM 7360-FETCH-REG-READ THRU 7360-EXIT.                  
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06970000
       2130-GET-REG-TYPE.                                               
           MOVE RG-CODE-USAGE-TYPE      TO WS-CODE-USAGE-TYPE.          
           MOVE RG-CODE-USAGE-ID        TO WS-CODE-USAGE-ID.            
           MOVE RG-CODE-USAGE-SOURCE    TO WS-CODE-USAGE-SOURCE.        
           MOVE WS-REGISTER-TYPE        TO RS-REGISTER-TYPE.            
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07070000
      *                                                                 07100000
       5400-GET-OLD-ACCOUNT.                                            
           MOVE AT-ACCOUNT-NO TO XR-OLD-ACCOUNT-NO.                     
           PERFORM 7810-GET-XREF-ACCOUNT THRU 7810-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE XR-NEW-ACCOUNT-NO TO AT-ACCOUNT-NO                   
              PERFORM 7010-SELECT-ACCOUNT THRU 7010-EXIT                
           END-IF.                                                      
       5400-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 07240000
      * SELECT ACCOUNT INFORMATION FROM CSS_ACCOUNT TABLE             * 07250000
      ***************************************************************** 07260000
       7010-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
                     CODE_COMPANY_ACCT,                                 
                     CODE_ACCT_BILLED,                                  
                     LOCAL_OFFICE,                                      
                     COMPANY_NO,                                        
                     NXT_BILL_NO                                        
               INTO :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-CODE-COMPANY-ACCT,                              
                    :AT-CODE-ACCT-BILLED,                               
                    :AT-LOCAL-OFFICE,                                   
                    :AT-COMPANY-NO,                                     
                    :AT-NXT-BILL-NO                                     
               FROM CSS_ACCOUNT                                         
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7010'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-PREMISE-NO TO RS-PREMISE-NO                       
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660000
       7030-SELECT-UTIL-ENVRNMT.                                        
           EXEC SQL                                                     
              SELECT CODE_UTIL_TYPE,                                    
                     CODE_REVENUE_CLASS,                                
                     CODE_ESTIMATE_OK,                                  
                     RATE_PLAN_NO,                                      
                     CODE_SIC_NO,                                       
                     CODE_MTR_READ_FREQ,                                
                     CODE_CURTAIL_PRTY,                                 
                     DATE_LST_NRML_BILL                                 
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-CODE-REVENUE-CLASS,                            
                     :UT-CODE-ESTIMATE-OK,                              
                     :UT-RATE-PLAN-NO,                                  
                     :UT-CODE-SIC-NO,                                   
                     :UT-CODE-MTR-READ-FREQ,                            
                     :UT-CODE-CURTAIL-PRTY,                             
T16353               :UT-DATE-LST-NRML-BILL :WS-NULL-IND3                
                FROM CSS_UTIL_ENVRNMT                                   
               WHERE ACCOUNT_NO        = :UT-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE             
                 AND IC_NO             = :UT-IC-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7030'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE UT-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07680000
       7350-OPEN-REG-READ.                                              
           EXEC SQL                                                     
               OPEN RG_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7350'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08700000
       7360-FETCH-REG-READ.                                             
           EXEC SQL                                                     
               FETCH RG_CRSR                                            
                INTO :RG-MTR-REF-NO,                                    
                     :RG-METER-NO,                                      
                     :RG-CODE-USAGE-TYPE,                               
                     :RG-CODE-USAGE-ID,                                 
                     :RG-CODE-USAGE-SOURCE,                             
                     :RG-CODE-TIME-PERIOD,                              
TP5297               :RG-LAST-REG-READ-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7360'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09030000
       7370-CLOSE-REG-READ.                                             
           EXEC SQL                                                     
               CLOSE RG_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7370'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_REGISTER_READ'  TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE RG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE RG-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09290000
TP5297 7500-SELECT-RATE-USE-SEASN.                                      
TP5297     EXEC SQL                                                     
TP5297        SELECT DATE_FROM,                                         
TP5297               DATE_TO                                            
TP5297          INTO :RS-DATE-FROM,                                     
TP5297               :RS-DATE-TO                                        
TP5297          FROM CSS_RATE_USE_SEASN                                 
TP5297         WHERE CODE_UTIL_TYPE     = :RS-CODE-UTIL-TYPE            
TP5297           AND RATE_PLAN_NO       = :RS-RATE-PLAN-NO              
TP5297           AND VERSION_NO_CNTRL   = :RS-VERSION-NO-CNTRL          
TP5297           AND CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE        
TP5297     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5297     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5297     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP5297        NEXT SENTENCE                                             
TP5297     ELSE                                                         
TP5297        MOVE SPACES                TO ABEND-TABLES                
TP5297        MOVE SPACES                TO ABEND-SQL-PREDICATES        
TP5297        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
TP5297        MOVE '7500'                TO ACTIVE-PARAGRAPH            
TP5297        MOVE 'SELECT'              TO ABEND-FUNCTION              
TP5297        MOVE 'CSS_RATE_USE_SEASN'  TO TABLE-1                     
TP5297        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
TP5297        MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
TP5297        MOVE 'VERSION_NO_CNTRL'    TO TABLE-ELEMENT-3             
TP5297        MOVE 'CODE_USE_INST_TYPE'  TO TABLE-ELEMENT-4             
TP5297        MOVE RS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
TP5297        MOVE RS-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
TP5297        MOVE RS-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3           
TP5297        MOVE RS-CODE-USE-INST-TYPE TO HOSTVAR-ELEMENT-4           
TP5297        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
TP5297        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
TP5297     END-IF.                                                      
TP5297 7500-EXIT.                                                       
TP5297     EXIT.                                                        
                                                                        
TP5297 7510-SELECT-MAX-VERSION.                                         
TP5297     EXEC SQL                                                     
TP5297        SELECT MAX(VERSION_NO_CNTRL)                              
TP5297          INTO :RS-VERSION-NO-CNTRL :WS-NULL-IND2                  
TP5297          FROM CSS_RATE_USE_SEASN                                 
TP5297         WHERE CODE_UTIL_TYPE     = :RS-CODE-UTIL-TYPE            
TP5297           AND RATE_PLAN_NO       = :RS-RATE-PLAN-NO              
TP5297           AND CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE        
TP5297     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5297     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5297     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP5297        NEXT SENTENCE                                             
TP5297     ELSE                                                         
TP5297        MOVE SPACES                TO ABEND-TABLES                
TP5297        MOVE SPACES                TO ABEND-SQL-PREDICATES        
TP5297        MOVE '7510'                TO ACTIVE-PARAGRAPH            
TP5297        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
TP5297        MOVE 'SELECT'              TO ABEND-FUNCTION              
TP5297        MOVE 'CSS_RATE_USE_SEASN'  TO TABLE-1                     
TP5297        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
TP5297        MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
TP5297        MOVE 'CODE_USE_INST_TYPE'  TO TABLE-ELEMENT-3             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-4             
TP5297        MOVE RS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
TP5297        MOVE RS-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
TP5297        MOVE RS-CODE-USE-INST-TYPE TO HOSTVAR-ELEMENT-3           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-4           
TP5297        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
TP5297        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
TP5297     END-IF.                                                      
TP5297 7510-EXIT.                                                       
TP5297     EXIT.                                                        
      *                                                                 09960000
TP5297 7520-SELECT-RATE-PLAN-DESC.                                      
TP5297     EXEC SQL                                                     
TP5297        SELECT VERS_PRORATE_CD                                    
TP5297          INTO :RD-VERS-PRORATE-CD                                
TP5297          FROM CSS_RATE_PLAN_DESC                                 
TP5297         WHERE CODE_UTIL_TYPE     = :RS-CODE-UTIL-TYPE            
TP5297           AND RATE_PLAN_NO       = :RS-RATE-PLAN-NO              
TP5297     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5297     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5297     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP5297        NEXT SENTENCE                                             
TP5297     ELSE                                                         
TP5297        MOVE SPACES                TO ABEND-TABLES                
TP5297        MOVE SPACES                TO ABEND-SQL-PREDICATES        
TP5297        MOVE '7520'                TO ACTIVE-PARAGRAPH            
TP5297        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
TP5297        MOVE 'SELECT'              TO ABEND-FUNCTION              
TP5297        MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-1                     
TP5297        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
TP5297        MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
TP5297        MOVE RD-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
TP5297        MOVE RD-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
TP5297        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
TP5297        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
TP5297     END-IF.                                                      
TP5297 7520-EXIT.                                                       
TP5297     EXIT.                                                        
      *                                                                 10240000
C28373*---------------------------*                                             
C28373 7530-SELECT-SEASN-PRT-TYPE.                                      
C28373*---------------------------*                                             
C28373     EXEC SQL                                                     
C28373         SELECT SEAS_PRORATE_CD                                   
C28373           INTO :J4-SEAS-PRORATE-CD                               
C28373           FROM CSS_RATE_VRSN_DEF                                 
C28373          WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE             
C28373            AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO               
C28373            AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
C28373     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28373     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28373     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C28373        NEXT SENTENCE                                             
C28373     ELSE                                                         
C28373        MOVE SPACES                TO ABEND-TABLES                
C28373        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C28373        MOVE '7530'                TO ACTIVE-PARAGRAPH            
C28373        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C28373        MOVE 'SELECT'              TO ABEND-FUNCTION              
C28373        MOVE 'CSS_RATE_VRSN_DEF'   TO TABLE-1                     
C28373        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
C28373        MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
C28373        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
C28373        MOVE J4-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
C28373        MOVE J4-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
C28373        MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
C28373        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C28373        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C28373     END-IF.                                                      
C28373 7530-EXIT.                                                       
C28373     EXIT.                                                        
C28373*                                                                 39390000
TP5186 7020-SELECT-MTRD-ENVRNMT.                                        
TP5186     EXEC SQL                                                     
TP5186        SELECT MTR_REF_NO,                                        
TP5186               METER_NO,                                          
TP5186               IC_NO,                                             
TP5186               CODE_USAGE_TYPE,                                   
TP5186               CODE_USAGE_ID,                                     
TP5186               CODE_USAGE_SOURCE,                                 
TP5186               CODE_TIME_PERIOD                                   
TP5186          INTO :MN-MTR-REF-NO,                                    
TP5186               :MN-METER-NO,                                      
TP5186               :MN-IC-NO,                                         
TP5186               :MN-CODE-USAGE-TYPE,                               
TP5186               :MN-CODE-USAGE-ID,                                 
TP5186               :MN-CODE-USAGE-SOURCE,                             
TP5186               :MN-CODE-TIME-PERIOD                               
TP5186          FROM CSS_MTRD_ENVRNMT                                   
TP5186          WHERE ACCOUNT_NO        = :MN-ACCOUNT-NO                
TP5186            AND CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE            
TP5186            AND METER_NO          = :MN-METER-NO                  
TP5186            AND CODE_METER_STATUS <> :WS-K                        
TP5186     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5186     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5186     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
TP5186        NEXT SENTENCE                                             
TP5186     ELSE                                                         
TP5186        MOVE SPACES               TO ABEND-TABLES                 
TP5186        MOVE SPACES               TO ABEND-SQL-PREDICATES         
TP5186        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
TP5186        MOVE '7020'               TO ACTIVE-PARAGRAPH             
TP5186        MOVE 'SELECT'             TO ABEND-FUNCTION               
TP5186        MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                      
TP5186        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
TP5186        MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
TP5186        MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
TP5186        MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
TP5186        MOVE MN-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
TP5186        MOVE MN-METER-NO          TO HOSTVAR-ELEMENT-3            
TP5186        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
TP5186        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
TP5186     END-IF.                                                      
TP5186 7020-EXIT.                                                       
TP5186     EXIT.                                                        
      *                                                                 10700000
       7810-GET-XREF-ACCOUNT.                                           
PCR376     EXEC SQL                                                     
PCR376        SELECT XR.NEW_ACCOUNT_NO                                  
PCR376          INTO :XR-NEW-ACCOUNT-NO                                 
PCR376          FROM CSS_XREF_ACCT      XR,                             
PCR376               CSS_ACCOUNT        AT,                             
PCR376               CSS_CUST_PREM_HIST CH                              
PCR376          WHERE XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO            
PCR376            AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                 
PCR376            AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                 
PCR376            AND AT.PREMISE_NO     = CH.PREMISE_NO                 
PCR376            AND CH.DATE_UTIL_SVC_STRT =                           
PCR376                (SELECT MAX(DATE_UTIL_SVC_STRT)                   
PCR376                   FROM CSS_CUST_PREM_HIST                        
PCR376                  WHERE PREMISE_NO = AT.PREMISE_NO)               
PCR376     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7810'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_XREF_ACCT'      TO TABLE-1                      
CBSI          MOVE 'CSS_ACCOUNT'        TO TABLE-2                      
CBSI          MOVE 'CSS_CUST_PREM_HIST' TO TABLE-3                      
              MOVE 'OLD_ACCOUNT_NO'     TO TABLE-ELEMENT-1              
              MOVE XR-OLD-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7810-EXIT.                                                       
           EXIT.                                                        
T5221 ****************************************************************  10971000
T5221 * 7850- THIS PARAGRAPH WILL DETERMINE WHETHER THE RATE IS A       10972000
T5221 * TIME OF USE OR NOT.  THIS IS CALLED AFTER EACH OCCURENCE OF     10973000
T5221 * THE GET-UTIL-ENVRN CURSOR.                                      10974000
T5221 ****************************************************************  10975000
T5221  7850-SELECT-TOU-IND.                                             
T9445      EXEC SQL                                                     
C28373        SELECT REMOTE_READ_IND                                    
C28373          INTO :MN-REMOTE-READ-IND                                
C28373          FROM CSS_MTRD_ENVRNMT                                   
T9445          WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                  
T9445            AND CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE              
T9445            AND IC_NO            = :UT-IC-NO                       
T9445            AND MTR_REF_NO       = :WS-MTR-REF-NO                  
T9445      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
CBSI          MOVE '7850'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
C28373        MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
T9445         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
T9445         MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
T9445         MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
T9445         MOVE 'MTR_REF_NO'             TO TABLE-ELEMENT-4          
T9445         MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
T9445         MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
T9445         MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
T9445         MOVE WS-MTR-REF-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
T5221  7850-EXIT.                                                       
T5221      EXIT.                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02141_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02141_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02141_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02141_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,ERROR_CODE                                         
REARCH              ,TIME_PERIOD                                        
REARCH              ,REGISTER_TYPE                                      
REARCH              ,UTILITY_TYPE                                       
REARCH              ,SEASON_IND                                         
REARCH              ,PREMISE_NO                                         
REARCH              ,IC_NO                                              
REARCH              ,RATE_PLAN_NO                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-ERROR-CODE                                      
REARCH              ,:S-TIME-PERIOD                                     
REARCH              ,:S-REGISTER-TYPE                                   
REARCH              ,:S-UTILITY-TYPE                                    
REARCH              ,:S-SEASON-IND                                      
REARCH              ,:S-PREMISE-NO                                      
REARCH              ,:S-IC-NO                                           
REARCH              ,:S-RATE-PLAN-NO-RET                                
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02141_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ERROR_CODE                                                 
MFA-TR*             ,TIME_PERIOD                                                
MFA-TR*             ,REGISTER_TYPE                                              
MFA-TR*             ,UTILITY_TYPE                                               
MFA-TR*             ,SEASON_IND                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ERROR-CODE                                              
MFA-TR*             ,:S-TIME-PERIOD                                             
MFA-TR*             ,:S-REGISTER-TYPE                                           
MFA-TR*             ,:S-UTILITY-TYPE                                            
MFA-TR*             ,:S-SEASON-IND                                              
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*             ,:S-IC-NO                                                   
MFA-TR*             ,:S-RATE-PLAN-NO-RET                                        
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02141_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ****************************************************************  11000000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     11010000
      ****************************************************************  11020000
REARCH*       EXEC SQL                                                  11030000
REARCH*          INCLUDE CPD00300                                       11040000
REARCH*       END-EXEC.                                                 11050000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
      ****************************************************************  11070000
      *       END PROGRAM COPYLIB                                       11080000
      ****************************************************************  11090000
REARCH*COPY CPD00302.                                                   11100000
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00320                                        16360000
REARCH     END-EXEC.                                                    16360000
