       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02139.                                         
       DATE-WRITTEN.     AUG 08, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
      *                                                                *00100000
      *  TRANID:        S139                                           *00110000
      *  PROGRAM:       S139                                           *00120000
      *  CALLING SP:    PN_S139                                        *00130000
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES THE ADDRESSES FOR THE CUSTOMER         *00210000
      *  INCLUDING FORMATTED AND FREEFORM.                             *00220000
      *                                                                *00230000
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *00240000
      *                                                                *00250000
      *  TABLE                  TABLE ID     DCLGEN                    *00260000
      *  -----                  --------     ------                    *00270000
      *  CSS_ACCOUNT               AT        TBACCT                    *00280000
      *  CSS_ADDR_FORMATTED        DY        TBADRFMT                  *00290000
      *  CSS_ADDR_FREEFORM         DZ        TBADRFRE                  *00300000
      *  CSS_ZIP_CODE              A4        TBZIPCD                   *00310000
      *                                                                *00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                     PROGRAM MODIFICATION LOG                   *00350000
      *                                                                *00360000
      *    DATE    INITIALS   COMMENTS                                 *00370000
      *  --------  --------   -----------------                        *00380000
      *  08/08/95    SK       CREATED.                                 *00390000
      *  03/04/96    SK       MODIFIED TO GET ADDRESS-ID FROM          *00400000
      *                       CSS_NAME_ACCT_XREF TABLE                 *00410000
TP5935*  11/21/96    PP       MODIFIED RETRIEVAL LOGIC. AS PER TPR5935 *00420000
TP5935*                       IF BILLING ADDRESS IS NOT FOUND, SERVICE *00430000
TP5935*                       ADDRESS IN SELECTED.                     *00440000
T11430*  06/03/97    AS       CORRECTED RETRIEVAL LOGIC TO LOOK FOR    *00441000
T11430*                       BILLING ADDRESS AND THEN FOR SERVICE     *00442000
T11430*                       ADDRESS   ONLY IF NO BILLING ADDRESS IS  *00443000
T11430*                       FOUND FOR A NEW LANDLORD. ALSO MODIFIED  *00444000
T11430*                       LOGIC TO LOOK FOR ADDRESSES FOR ALL THE  *00445000
T11430*                       ACCOUNTS THAT THE NEW LANDLORD HAS.      *00446000
CBSI  *  12/17/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *00446101
CBSI  *              MADRAS   ABEND PARAMETERS                         *00447001
T19254*  03/15/99    CBSI     REMOVED PARM-ACCOUNT-NO AND INCLUDED     *        
T19254*              MADRAS   PARM-PREMISE-NO AND PARM-CUSTOMER-NO     *        
T19254*                       IN THE ABEND LOG AND CHANGED "PERFORM    *        
T19254*                       7000-OPEN-ADDR-CURSOR THRU 7100-EXIT"    *        
T19254*                       TO 7000-EXIT IN THE PARAGRAPH            *        
T19254*                       2200-BUILD-RESULT.                       *        
C32615*  06/20/06    FMB      CREATE NEW ADDRESS RECORD IF LANDLORD    *        
C32615*                       HAS NO BILLING ADDRESS TO AVOID ADDRESS  *        
C32615*                       ID SHARING.                              *        
REARCH*  07/12/06    CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
C35134*  11/13/07    SC       INCREASED THE LENGTH OF FULL ADDRESS AND *        
C35134*                       ADDRESS OVERFLOW                         *        
T36932*  05/07/08    SV85244  INCREASED LENGTH OF ADDRESS FIELDS       *        
T36932*                                                                *        
C35665*  01/05/09    FMB      RETRIEVE ONLY ACCOUNTS WITH BILL         *        
C35665*                       ADDRESSES IN ACCT_CURSOR.                *        
P00740*  01/29/15    FMB      POPULATE FULL_ADDRESS. MOD WILL USE THIS *        
P00740*                       FIELD; LEGACY WILL CONTINUE TO BUILD IT  *        
P00740*                       IN FW_I_MAKE_ADDRESS OF PANEL062.        *        
      ******************************************************************00450000
      ******************************************************************00460000
      *                                                                *00470000
      *                -- BASIC SEQUENCE STRUCTURE --                  *00480000
      *                                                                *00490000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00500000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00510000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00520000
      *  3000 - 4999  NOT USED                                         *00530000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00540000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00550000
      *  7000 - 7999  INPUT MODULES                                    *00560000
      *  8000 - 8999  OUTPUT MODULES                                   *00570000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00580000
      *                                                                *00590000
      ******************************************************************00600000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02139'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02139 STARTS HERE'.                  
                                                                        
      ******************************************************************00690000
      *    DB2 INCLUDES                                                *00700000
      ******************************************************************00710000
                                                                        
           EXEC SQL                                                     00730000
              INCLUDE SQLCA                                             00740000
           END-EXEC.                                                    00750000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBMODEL                                           00780000
           END-EXEC.                                                    00790000
                                                                        
      *----< CSS_ACCOUNT >                                              00810000
           EXEC SQL                                                     00820000
              INCLUDE TBACCT                                            00830000
           END-EXEC.                                                    00840000
                                                                        
      *----< CSS_LANDLORD >                                             00860000
           EXEC SQL                                                     00870000
              INCLUDE TBLNDLRD                                          00880000
           END-EXEC.                                                    00890000
                                                                        
      *----< CSS_NAME_ACCT_XREF - HT >                                  00910000
           EXEC SQL                                                     00920000
              INCLUDE TBNMACTX                                          00930000
           END-EXEC.                                                    00940000
                                                                        
      *----< CSS_NAME  - DQ >                                           00960000
           EXEC SQL                                                     00970000
              INCLUDE TBNAME                                            00980000
           END-EXEC.                                                    00990000
                                                                        
      *----< CSS_ADDR_FORMATTED >                                       01010000
           EXEC SQL                                                     01020000
              INCLUDE TBADRFMT                                          01030000
           END-EXEC.                                                    01040000
                                                                        
      *----< CSS_ADDR_FREEFORM >                                        01060000
           EXEC SQL                                                     01070000
              INCLUDE TBADRFRE                                          01080000
           END-EXEC.                                                    01090000
                                                                        
      *---< CSS_ZIP_CODE >                                              01110000
           EXEC SQL                                                     01120000
              INCLUDE TBZIPCD                                           01130000
           END-EXEC.                                                    01140000
                                                                        
C32615*---< CSS_PREMISE >                                               01110000
C32615     EXEC SQL                                                     01120000
C32615        INCLUDE TBPREM                                            01130000
C32615     END-EXEC.                                                    01140000
                                                                        
C32615*---< CSS_ADDR_ID_CNTL                                            01110000
C32615     EXEC SQL                                                     01120000
C32615         INCLUDE TBADDRID                                         01130000
C32615     END-EXEC.                                                    01140000
                                                                        
      ******************************************************************01160000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01170000
      ******************************************************************01180000
                                                                        
      *----<COMMON SYSTEM AREA >                                        01250000
           COPY CCA00001.                                               01260000
                                                                        
REARCH     EXEC SQL                                                     00000010
REARCH         INCLUDE CWSX0010                                         00000020
REARCH     END-EXEC.                                                    00000030
                                                                        
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >           01290000
           COPY CWS00027.                                               01300000
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                      01310000
           COPY CWS00303.                                               01320000
C32615     COPY CWS00071.                                               01320000
C32615         EXEC SQL                                                         
C32615             INCLUDE CWS0090A                                             
C32615         END-EXEC.                                                        
                                                                        
      ******************************************************************01340000
      *    WORK AREAS                                                  *01350000
      ******************************************************************01360000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02139'.      
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02139_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP VALUE 0.         
REARCH         49 GTT-ROW-CHAR         PIC X(1024) VALUE SPACES.        
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH     10  WS-ABEND-SQLERRMC.                                       
REARCH         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
REARCH         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
           05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9)   COMP.              
           05  WRKLEN1                   PIC S9(9)   COMP.              
           05  WRKLEN2                   PIC S9(9)   COMP.              
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
           05  RS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
           05  RS-ADDRESS-ID             PIC X(13)   VALUE SPACES.      
T36932     05  RS-FO-HOUSE-NO            PIC X(15)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-1       PIC X(03)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-2       PIC X(02)   VALUE SPACES.      
T36932     05  RS-FO-STREET-NAME         PIC X(30)   VALUE SPACES.      
           05  RS-FO-STREET-SUFFIX       PIC X(04)   VALUE SPACES.      
           05  RS-FO-STREET-LOCATION-1   PIC X(04)   VALUE SPACES.      
T36932     05  RS-FO-STREET-LOCATION-2   PIC X(11)   VALUE SPACES.      
           05  RS-FO-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE            PIC X(05)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE-PL-FOUR    PIC X(04)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE-TOKEN      PIC X(01)   VALUE SPACES.      
           05  RS-FO-ADDR-USAGE-CD       PIC X(01)   VALUE SPACES.      
           05  RS-FO-TOWN                PIC X(26)   VALUE SPACES.      
           05  RS-FO-STATE               PIC X(02)   VALUE SPACES.      
T36932     05  RS-FR-ADDR-STREET         PIC X(55)   VALUE SPACES.      
           05  RS-FR-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
T36932     05  RS-FR-CITY-STATE          PIC X(30)   VALUE SPACES.      
           05  RS-FR-ZIP-CODE            PIC X(09)   VALUE SPACES.      
           05  RS-FR-COUNTRY             PIC X(35)   VALUE SPACES.      
           05  RS-ADDR-SUFFIX            PIC X(02)   VALUE SPACES.      
           05  RS-CARRIER-ROUTE          PIC X(05)   VALUE SPACES.      
T36932     05  RS-FULL-ADDRESS           PIC X(75)   VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
REARCH     05   S-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
REARCH     05   S-ADDRESS-ID             PIC X(13)   VALUE SPACES.      
T36932     05   S-FO-HOUSE-NO            PIC X(15)   VALUE SPACES.      
REARCH     05   S-FO-ADDR-PREFIX-1       PIC X(03)   VALUE SPACES.      
REARCH     05   S-FO-ADDR-PREFIX-2       PIC X(02)   VALUE SPACES.      
T36932     05   S-FO-STREET-NAME         PIC X(30)   VALUE SPACES.      
REARCH     05   S-FO-STREET-SUFFIX       PIC X(04)   VALUE SPACES.      
REARCH     05   S-FO-STREET-LOCATION-1   PIC X(04)   VALUE SPACES.      
T36932     05   S-FO-STREET-LOCATION-2   PIC X(11)   VALUE SPACES.      
REARCH     05   S-FO-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
REARCH     05   S-FO-ZIP-CODE            PIC X(05)   VALUE SPACES.      
REARCH     05   S-FO-ZIP-CODE-PL-FOUR    PIC X(04)   VALUE SPACES.      
REARCH     05   S-FO-ZIP-CODE-TOKEN      PIC X(01)   VALUE SPACES.      
REARCH     05   S-FO-ADDR-USAGE-CD       PIC X(01)   VALUE SPACES.      
REARCH     05   S-FO-TOWN                PIC X(26)   VALUE SPACES.      
REARCH     05   S-FO-STATE               PIC X(02)   VALUE SPACES.      
T36932     05   S-FR-ADDR-STREET         PIC X(55)   VALUE SPACES.      
REARCH     05   S-FR-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
T36932     05   S-FR-CITY-STATE          PIC X(30)   VALUE SPACES.      
REARCH     05   S-FR-ZIP-CODE            PIC X(09)   VALUE SPACES.      
REARCH     05   S-FR-COUNTRY             PIC X(35)   VALUE SPACES.      
REARCH     05   S-ADDR-SUFFIX            PIC X(02)   VALUE SPACES.      
REARCH     05   S-CARRIER-ROUTE          PIC X(05)   VALUE SPACES.      
T36932     05   S-FULL-ADDRESS           PIC X(75)   VALUE SPACES.      
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-ADDRESS-ID-S           PIC X(13)   VALUE SPACES.      
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  WS-CUSTOMER-NO-S          PIC X(10)   VALUE SPACES.      
           05  WS-ZIP-CODE               PIC X(05)   VALUE SPACES.      
           05  WS-ZIP-CODE-TOKEN         PIC X(01)   VALUE SPACES.      
           05  WS-NEW-ADDRESS-FLAG       PIC X(01)   VALUE 'Y'.         
           05  WS-ACCOUNT-EXISTS-FLAG    PIC X(01)   VALUE 'N'.         
           05  WS-LNDLRD-EXISTS-FLAG     PIC X(01)   VALUE 'Y'.         
               88 LNDLRD-EXISTS                      VALUE 'Y'.         
               88 LNDLRD-NOT-EXISTS                  VALUE 'N'.         
C35802     05  WS-HOLD-ADDRESS-ID        PIC S9(13)V  COMP-3 VALUE 0.   
C35665     05  WS-PREMISE-ADDR-FL        PIC X(01)   VALUE 'N'.         
P00740     05  WS-ADDRESS-LINE           PIC X(80) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************02800000
      *    CURSOR DECLARATIONS                                         *02810000
      ******************************************************************02820000
                                                                        
           EXEC SQL DECLARE ADDR_CURSOR CURSOR FOR                      
              SELECT  DISTINCT HT.ADDRESS_ID, 'A'                       
              FROM    CSS_NAME_ACCT_XREF HT
                           WITH(READUNCOMMITTED), CSS_NAME DQ
                           WITH(READUNCOMMITTED)                
              WHERE   HT.CUSTOMER_NO        = :WS-CUSTOMER-NO           
                AND   HT.CUSTOMER_ROLE_CD   = ' '                       
                AND   HT.NAME_ID            = DQ.NAME_ID                
                AND   DQ.NAME_TYPE          = 'CN'                      
C32615                                                           
C32615        FOR READ ONLY                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE ADDR_CURSOR CURSOR FOR                      02840000
MFA-TR*       SELECT  DISTINCT HT.ADDRESS_ID, 'A'                       02850000
MFA-TR*       FROM    CSS_NAME_ACCT_XREF HT, CSS_NAME DQ                02860000
MFA-TR*       WHERE   HT.CUSTOMER_NO        = :WS-CUSTOMER-NO           02870000
MFA-TR*         AND   HT.CUSTOMER_ROLE_CD   = ' '                       02880000
MFA-TR*         AND   HT.NAME_ID            = DQ.NAME_ID                02890000
MFA-TR*         AND   DQ.NAME_TYPE          = 'CN'                      02900000
MFA-TR*       WITH UR                                                           
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*    END-EXEC.                                                    02910000
                                                                        
T11430     EXEC SQL DECLARE ACCT_CURSOR CURSOR FOR                      
T11430        SELECT  ACCOUNT_NO,                                       
T11430                ADDRESS_ID,                                       
T11430                ADDRESS_FORMAT,                                   
C32615                PREMISE_NO                                        
T11430        FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T11430        WHERE   AT.CUSTOMER_NO = :WS-CUSTOMER-NO                  
C35665          AND   ADDRESS_ID > 0                                    
C35802        ORDER BY ADDRESS_ID                                       
C32615                                                           
C32615        FOR READ ONLY                                            
T11430     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE ACCT_CURSOR CURSOR FOR                      02922000
MFA-TR*       SELECT  ACCOUNT_NO,                                       02923001
MFA-TR*               ADDRESS_ID,                                       02923100
MFA-TR*               ADDRESS_FORMAT,                                   02923200
MFA-TR*               PREMISE_NO                                        02923200
MFA-TR*       FROM    CSS_ACCOUNT AT                                    02924000
MFA-TR*       WHERE   AT.CUSTOMER_NO = :WS-CUSTOMER-NO                  02925000
MFA-TR*         AND   ADDRESS_ID > 0                                            
MFA-TR*       ORDER BY ADDRESS_ID                                               
MFA-TR*       WITH UR                                                           
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*    END-EXEC.                                                    02929000
                                                                        
REARCH LINKAGE SECTION .                                                
REARCH 01  PARM-CUSTOMER-NO     PIC X(10).                              
REARCH 01  PARM-PREMISE-NO      PIC X(10).                              
REARCH 01  PARM-ACCOUNT-NO      PIC X(13).                              
                                                                        
HPCCDM*EJECT                                                            02931000
REARCH PROCEDURE DIVISION USING  PARM-CUSTOMER-NO,                      
REARCH                           PARM-PREMISE-NO,                       
REARCH                           PARM-ACCOUNT-NO.                       
                                                                        
      ******************************************************************02960000
      * 0000-MAINLINE                                                  *02970000
      *     CALLS 0100-INITIALIZE                                      *02980000
      *           1000-PROCESS-INPUT                                   *02990000
      *           2000-PROCESS-OUTPUT                                  *03000000
      *           9999-END-PROGRAM                                     *03010000
      *                                                                *03020000
      *     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *03030000
      ******************************************************************03040000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03160000
      * 0100-INITIALIZE                                                *03170000
      *     CALLS 9000-SEND-ERROR-RESULT                               *03180000
      *           9900-SQL-ERROR-ROUTINE                               *03190000
      *                                                                *03200000
      *     CALLED FROM 0000-MAINLINE                                  *03210000
      *                                                                *03220000
      *     1. RESET DB2 ERROR HANDLERS                                *03230000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03240000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03250000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03260000
      *                                                                *03270000
      ******************************************************************03280000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
P00740         SELECT DISTINCT                                          
REARCH              RETURN_CODE                                         
REARCH             ,LTRIM(RTRIM(ADDRESS_FORMAT))      AS ADDRESS_FORMAT        
REARCH             ,LTRIM(RTRIM(ADDRESS_ID))          AS ADDRESS_ID            
REARCH             ,LTRIM(RTRIM(FO_HOUSE_NO))         AS FO_HOUSE_NO           
REARCH             ,LTRIM(RTRIM(FO_ADDR_PREFIX_1))    AS 
           FO_ADDR_PREFIX_1      
REARCH             ,LTRIM(RTRIM(FO_ADDR_PREFIX_2))    AS 
           FO_ADDR_PREFIX_2      
REARCH             ,LTRIM(RTRIM(FO_STREET_NAME))      AS FO_STREET_NAME        
REARCH             ,LTRIM(RTRIM(FO_STREET_SUFFIX))    AS 
           FO_STREET_SUFFIX      
REARCH             ,LTRIM(RTRIM(FO_STREET_LOCATN_1))  AS 
           FO_STREET_LOCATN_1    
REARCH             ,LTRIM(RTRIM(FO_STREET_LOCATN_2))  AS 
           FO_STREET_LOCATN_2    
REARCH             ,LTRIM(RTRIM(FO_ADDRESS_OVFLOW))   AS 
           FO_ADDRESS_OVFLOW     
REARCH             ,LTRIM(RTRIM(FO_ZIP_CODE))         AS FO_ZIP_CODE           
REARCH             ,LTRIM(RTRIM(FO_ZIP_CDE_PL_FOU))   AS 
           FO_ZIP_CDE_PL_FOU     
REARCH             ,LTRIM(RTRIM(FO_ZIP_CODE_TOKEN))   AS 
           FO_ZIP_CODE_TOKEN     
REARCH             ,LTRIM(RTRIM(FO_ADDR_USAGE_CD))    AS 
           FO_ADDR_USAGE_CD      
REARCH             ,LTRIM(RTRIM(FO_TOWN))             AS FO_TOWN               
REARCH             ,LTRIM(RTRIM(FO_STATE))            AS FO_STATE              
REARCH             ,LTRIM(RTRIM(FR_ADDR_STREET))      AS FR_ADDR_STREET        
REARCH             ,LTRIM(RTRIM(FR_ADDRESS_OVRFLOW))  AS 
           FR_ADDRESS_OVRFLOW    
REARCH             ,LTRIM(RTRIM(FR_CITY_STATE))       AS FR_CITY_STATE         
REARCH             ,LTRIM(RTRIM(FR_ZIP_CODE))         AS FR_ZIP_CODE           
REARCH             ,LTRIM(RTRIM(FR_COUNTRY))          AS FR_COUNTRY            
REARCH             ,LTRIM(RTRIM(ADDR_SUFFIX))         AS ADDR_SUFFIX           
REARCH             ,LTRIM(RTRIM(CARRIER_ROUTE))       AS CARRIER_ROUTE         
REARCH             ,LTRIM(RTRIM(FULL_ADDRESS))        AS FULL_ADDRESS          
REARCH         FROM #CSR02139_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT DISTINCT                                          00000400
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STRIP(ADDRESS_FORMAT)      AS ADDRESS_FORMAT                
MFA-TR*            ,STRIP(ADDRESS_ID)          AS ADDRESS_ID                    
MFA-TR*            ,STRIP(FO_HOUSE_NO)         AS FO_HOUSE_NO                   
MFA-TR*            ,STRIP(FO_ADDR_PREFIX_1)    AS FO_ADDR_PREFIX_1              
MFA-TR*            ,STRIP(FO_ADDR_PREFIX_2)    AS FO_ADDR_PREFIX_2              
MFA-TR*            ,STRIP(FO_STREET_NAME)      AS FO_STREET_NAME                
MFA-TR*            ,STRIP(FO_STREET_SUFFIX)    AS FO_STREET_SUFFIX              
MFA-TR*            ,STRIP(FO_STREET_LOCATN_1)  AS FO_STREET_LOCATN_1            
MFA-TR*            ,STRIP(FO_STREET_LOCATN_2)  AS FO_STREET_LOCATN_2            
MFA-TR*            ,STRIP(FO_ADDRESS_OVFLOW)   AS FO_ADDRESS_OVFLOW             
MFA-TR*            ,STRIP(FO_ZIP_CODE)         AS FO_ZIP_CODE                   
MFA-TR*            ,STRIP(FO_ZIP_CDE_PL_FOU)   AS FO_ZIP_CDE_PL_FOU             
MFA-TR*            ,STRIP(FO_ZIP_CODE_TOKEN)   AS FO_ZIP_CODE_TOKEN             
MFA-TR*            ,STRIP(FO_ADDR_USAGE_CD)    AS FO_ADDR_USAGE_CD              
MFA-TR*            ,STRIP(FO_TOWN)             AS FO_TOWN                       
MFA-TR*            ,STRIP(FO_STATE)            AS FO_STATE                      
MFA-TR*            ,STRIP(FR_ADDR_STREET)      AS FR_ADDR_STREET                
MFA-TR*            ,STRIP(FR_ADDRESS_OVRFLOW)  AS FR_ADDRESS_OVRFLOW            
MFA-TR*            ,STRIP(FR_CITY_STATE)       AS FR_CITY_STATE                 
MFA-TR*            ,STRIP(FR_ZIP_CODE)         AS FR_ZIP_CODE                   
MFA-TR*            ,STRIP(FR_COUNTRY)          AS FR_COUNTRY                    
MFA-TR*            ,STRIP(ADDR_SUFFIX)         AS ADDR_SUFFIX                   
MFA-TR*            ,STRIP(CARRIER_ROUTE)       AS CARRIER_ROUTE                 
MFA-TR*            ,STRIP(FULL_ADDRESS)        AS FULL_ADDRESS                  
MFA-TR*        FROM SESSION.CSR02139_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************02670000
REARCH* 0100A-DECLARE-GTT.                                             *02680000
REARCH******************************************************************02700000
REARCH 0100A-DECLARE-GTT.                                               
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02139_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02139_R1
              (                                                          
REARCH         RETURN_CODE              INT                         
REARCH        ,ADDRESS_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,ADDRESS_ID CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
T36932        ,FO_HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,FO_ADDR_PREFIX_1 CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_ADDR_PREFIX_2 CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
T36932        ,FO_STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,FO_STREET_SUFFIX CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_STREET_LOCATN_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
T36932        ,FO_STREET_LOCATN_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_ADDRESS_OVFLOW CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,FO_ZIP_CDE_PL_FOU CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_ZIP_CODE_TOKEN CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_ADDR_USAGE_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,FO_TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                
REARCH        ,FO_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2               
T36932        ,FR_ADDR_STREET CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,FR_ADDRESS_OVRFLOW CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
T36932        ,FR_CITY_STATE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH        ,FR_ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,FR_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH        ,ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,CARRIER_ROUTE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
C35134        ,FULL_ADDRESS CHAR(75)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE TO WS-SQLSTATE.                                
REARCH     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
REARCH                                                                  
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE SQLCODE              TO ABEND-SQLCODE            
REARCH            MOVE SQLSTATE             TO ABEND-SQLSTATE           
REARCH            MOVE '0100A'               TO ACTIVE-PARAGRAPH        
REARCH            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
REARCH            MOVE SPACES               TO ABEND-SQL-PREDICATES     
REARCH                                         ABEND-TABLES             
REARCH            MOVE 'CSR02139_R1'        TO TABLE-1                  
REARCH            MOVE SPACES               TO TABLE-ELEMENT-1          
REARCH            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH       EXIT.                                                      
                                                                        
      ******************************************************************03560000
      * 1000-PROCESS-INPUT                                             *03570000
      *     CALLS 1100-RECEIVE-PARMS                                   *03580000
      *                                                                *03590000
      *     CALLED FROM 0000-MAINLINE                                  *03600000
      *                                                                *03610000
      *     1. RECEIVE PARMS.                                          *03620000
      ******************************************************************03630000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO   TO WS-CUSTOMER-NO-S.                 
           MOVE WS-CUSTOMER-NO-S   TO WS-CUSTOMER-NO.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04250000
      * 2000-PROCESS-OUTPUT.                                           *04260000
      *     CALLS 2100-DESCRIBE-RESULT                                 *04270000
      *           2200-BUILD-RESULT                                    *04280000
      *                                                                *04290000
      *      CALLED FROM 0000-MAINLINE                                 *04300000
      *                                                                *04310000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *04320000
      *      AND SENDS THEM BACK                                       *04330000
      ******************************************************************04340000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
REARCH     ADD 1 TO CTR-ROWS.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************02670000
REARCH* 2000A-MOVE-RESULT.                                             *02680000
REARCH******************************************************************02700000
REARCH 2000A-MOVE-RESULT.                                               
REARCH      MOVE  RS-RETURN-CODE            TO  S-RETURN-CODE.          
REARCH      MOVE  RS-ADDRESS-FORMAT         TO  S-ADDRESS-FORMAT.       
REARCH      MOVE  RS-ADDRESS-ID             TO  S-ADDRESS-ID.           
REARCH      MOVE  RS-FO-HOUSE-NO            TO  S-FO-HOUSE-NO.          
REARCH      MOVE  RS-FO-ADDR-PREFIX-1       TO  S-FO-ADDR-PREFIX-1.     
REARCH      MOVE  RS-FO-ADDR-PREFIX-2       TO  S-FO-ADDR-PREFIX-2.     
REARCH      MOVE  RS-FO-STREET-NAME         TO  S-FO-STREET-NAME.       
REARCH      MOVE  RS-FO-STREET-SUFFIX       TO  S-FO-STREET-SUFFIX.     
REARCH      MOVE  RS-FO-STREET-LOCATION-1   TO  S-FO-STREET-LOCATION-1. 
REARCH      MOVE  RS-FO-STREET-LOCATION-2   TO  S-FO-STREET-LOCATION-2. 
REARCH      MOVE  RS-FO-ADDRESS-OVERFLOW    TO  S-FO-ADDRESS-OVERFLOW.  
REARCH      MOVE  RS-FO-ZIP-CODE            TO  S-FO-ZIP-CODE.          
REARCH      MOVE  RS-FO-ZIP-CODE-PL-FOUR    TO  S-FO-ZIP-CODE-PL-FOUR.  
REARCH      MOVE  RS-FO-ZIP-CODE-TOKEN      TO  S-FO-ZIP-CODE-TOKEN.    
REARCH      MOVE  RS-FO-ADDR-USAGE-CD       TO  S-FO-ADDR-USAGE-CD.     
REARCH      MOVE  RS-FO-TOWN                TO  S-FO-TOWN.              
REARCH      MOVE  RS-FO-STATE               TO  S-FO-STATE.             
REARCH      MOVE  RS-FR-ADDR-STREET         TO  S-FR-ADDR-STREET.       
REARCH      MOVE  RS-FR-ADDRESS-OVERFLOW    TO  S-FR-ADDRESS-OVERFLOW.  
REARCH      MOVE  RS-FR-CITY-STATE          TO  S-FR-CITY-STATE.        
REARCH      MOVE  RS-FR-ZIP-CODE            TO  S-FR-ZIP-CODE.          
REARCH      MOVE  RS-FR-COUNTRY             TO  S-FR-COUNTRY.           
REARCH      MOVE  RS-ADDR-SUFFIX            TO  S-ADDR-SUFFIX.          
REARCH      MOVE  RS-CARRIER-ROUTE          TO  S-CARRIER-ROUTE.        
REARCH      MOVE  RS-FULL-ADDRESS           TO  S-FULL-ADDRESS.         
                                                                        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************10370000
      * 2200-BUILD-RESULT                                              *10380000
      *                                                                *10390000
      *     CALLS  7000-OPEN-ADDR-CURSOR                               *10400000
      *            7400-CLOSE-ADR-CURSOR                               *10410000
      *            2300-PROCESS-ADDR-ID                                *10420000
      *                                                                *10430000
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *10440000
      *                                                                *10450000
      *     SELECT UNIQUE ADDRESS IDS FOR THE CUSTOMER                 *10460000
      *     FOR EACH ADDRESS ID                                        *10470000
      *        IF FORMAT = 'A' THEN SELECT ADDRESS FROM FORMATTED      *10480000
      *           ADDRESS TABLE ELSE                                   *10490000
      *           SELECT ADDRESS FROM FREEFORM ADDRESS TABLE           *10500000
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *10510000
      *     IF THE ADDRESS-ID IN LANDLORD TABLE IS NEWLY ADDED         *10520000
      *        ADDRESS THEN SEND THAT ADDRESS ALSO.                    *10530000
      ******************************************************************10540000
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           MOVE PARM-PREMISE-NO                 TO SI-PREMISE-NO.       
           MOVE PARM-ACCOUNT-NO                 TO AT-ACCOUNT-NO.       
           PERFORM 7500-SELECT-LANDLORD         THRU 7500-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N'                   TO WS-LNDLRD-EXISTS-FLAG       
              MOVE +0                    TO SI-ADDRESS-ID               
           END-IF.                                                      
                                                                        
           IF WS-NEW-ADDRESS-FLAG = 'Y' AND LNDLRD-EXISTS               
              MOVE SI-ADDRESS-ID      TO WS-ADDRESS-ID                  
              MOVE WS-ADDRESS-ID      TO WS-ADDRESS-ID-S                
              MOVE SI-ADDRESS-FORMAT  TO WS-ADDRESS-FORMAT              
TP5935        IF WS-ADDRESS-FORMAT = 'A'                                
TP5935           PERFORM 7200-SELECT-ADDR-FORM     THRU 7200-EXIT       
TP5935*          MOVE DY-ZIP-CODE               TO A4-ZIP-CODE          10740000
TP5935*          MOVE DY-ZIP-CODE-TOKEN         TO A4-ZIP-CODE-TOKEN    10750000
TP5935*          PERFORM 7240-SELECT-TOWN-ST    THRU 7240-EXIT          10760000
TP5935           PERFORM 2400-SEND-ADDR-FORM THRU 2400-EXIT             
TP5935        END-IF                                                    
TP5935        IF WS-ADDRESS-FORMAT = 'B'                                
TP5935           PERFORM 7300-SELECT-ADDR-FREE  THRU 7300-EXIT          
TP5935           PERFORM 2500-SEND-ADDR-FREE THRU 2500-EXIT             
TP5935        END-IF                                                    
TP5935                                                                  
TP5935     ELSE                                                         
                                                                        
T11430        MOVE 0  TO WS-ACTIVE-RETURN-CODE                          
T11430        PERFORM 7110-OPEN-ACCT-CURSOR        THRU 7110-EXIT       
T11430        PERFORM 2250-PROCESS-ACCT-ADDR       THRU 2250-EXIT       
T11430             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T11430        PERFORM 7130-CLOSE-ACCT-CURSOR       THRU 7130-EXIT       
                                                                        
T11430        IF WS-ACCOUNT-EXISTS-FLAG = 'N'                           
T19254           PERFORM 7000-OPEN-ADDR-CURSOR        THRU 7000-EXIT    
T11430           PERFORM 2300-PROCESS-ADDR-ID         THRU 2300-EXIT    
T11430              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
T11430           PERFORM 7400-CLOSE-ADDR-CURSOR       THRU 7400-EXIT    
T11430        END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T11430******************************************************************11261000
T11430* 2250-PROCESS-ACCT-ADDR                                         *11262000
T11430*                                                                *11263000
T11430*     CALLS  7120-FETCH-ACCT-CURSOR                              *11264000
T11430*            7200-SELECT-ADDR-FORM                               *11265000
T11430*            7300-SELECT-ADDR-FREE                               *11266000
T11430*            2400-SEND-ADDR-FORM                                 *11267000
T11430*            2500-SEND-ADDR-FREE                                 *11268000
T11430*     CALLED FROM 2200-BUILD-RESULTS                             *11269100
T11430*                                                                *11269200
T11430*     RETRIEVE AND SEND ACCOUNT BILLING/SERVICE ADDRESSES FOR    *11269300
T11430*     ALL ACCOUNTS FOR THE NEW LANDLORD.                         *11269400
C32615*     DO NOT SEND SERVICE ADDRESS TO AVOID SHARING               *11269400
T11430******************************************************************11269500
T11430                                                                  
T11430 2250-PROCESS-ACCT-ADDR.                                          
T11430                                                                  
T11430     MOVE '2250'                          TO ACTIVE-PARAGRAPH.    
T11430                                                                  
T11430     PERFORM 7120-FETCH-ACCT-CURSOR       THRU 7120-EXIT.         
T11430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35802        IF AT-ADDRESS-ID = WS-HOLD-ADDRESS-ID                     
C35802            CONTINUE                                              
C35802        ELSE                                                      
C35802            MOVE AT-ADDRESS-ID            TO WS-HOLD-ADDRESS-ID   
T11430            MOVE AT-ADDRESS-ID            TO WS-ADDRESS-ID        
T11430            MOVE WS-ADDRESS-ID            TO WS-ADDRESS-ID-S      
T11430            MOVE AT-ADDRESS-FORMAT        TO WS-ADDRESS-FORMAT    
T11430            IF WS-ADDRESS-ID > 0                                  
T11430*------     SEND BACK THE BILLING ADDRESS                         11271000
T11430               IF WS-ADDRESS-FORMAT = 'A'                         
T11430                  PERFORM 7200-SELECT-ADDR-FORM THRU 7200-EXIT    
T11430*                 MOVE DY-ZIP-CODE           TO A4-ZIP-CODE       11271300
T11430*                 MOVE DY-ZIP-CODE-TOKEN     TO A4-ZIP-CODE-TOKEN 11271400
T11430*                 PERFORM 7240-SELECT-TOWN-ST THRU 7240-EXIT      11271500
T11430                  PERFORM 2400-SEND-ADDR-FORM THRU 2400-EXIT      
T11430               ELSE                                               
T11430                  IF WS-ADDRESS-FORMAT = 'B'                      
T11430                     PERFORM 7300-SELECT-ADDR-FREE THRU 7300-EXIT 
T11430                     PERFORM 2500-SEND-ADDR-FREE THRU 2500-EXIT   
T11430                  END-IF                                          
T11430               END-IF                                             
C32615            ELSE                                                  
C32615                MOVE AT-PREMISE-NO TO PR-PREMISE-NO               
C32615                PERFORM 7600-SERVICE-ADDRESS THRU 7600-EXIT       
C32615                PERFORM 2600-GET-ADDRESS-ID THRU 2600-EXIT        
C32615                PERFORM 8000-INSERT-ADDRESS THRU 8000-EXIT        
C32615*               MOVE DY-ZIP-CODE TO A4-ZIP-CODE                   11271300
C32615*               MOVE DY-ZIP-CODE-TOKEN TO A4-ZIP-CODE-TOKEN       11271400
C32615*               PERFORM 7240-SELECT-TOWN-ST THRU 7240-EXIT        11271500
C32615                MOVE 'A' TO WS-ADDRESS-FORMAT                     
C32615                MOVE DY-ADDRESS-ID TO WS-ADDRESS-ID               
C32615                MOVE WS-ADDRESS-ID TO WS-ADDRESS-ID-S             
C32615                PERFORM 2400-SEND-ADDR-FORM THRU 2400-EXIT        
T11430            END-IF                                                
T11430            MOVE 'Y' TO WS-ACCOUNT-EXISTS-FLAG                    
C35802         END-IF                                                   
T11430     END-IF.                                                      
T11430                                                                  
T11430 2250-EXIT.                                                       
T11430     EXIT.                                                        
                                                                        
      ******************************************************************11275000
      * 2300-PROCESS-ADDR-ID                                           *11280000
      *                                                                *11290000
      *     CALLS  7100-FETCH-ADDR-ID                                  *11300000
      *            7200-SELECT-ADDR-FORM                               *11310000
      *            7300-SELECT-ADDR-FREE                               *11320000
      *            2400-SEND-ADDR-FORM                                 *11330000
      *            2500-SEND-ADDR-FREE                                 *11340000
      *                                                                *11350000
      *     CALLED FROM 2200-BUILD-RESULTS                             *11360000
      *                                                                *11370000
      *     RETRIEVE ADDRESSES BASED ON ADDRESS IDS.                   *11380000
      ******************************************************************11390000
                                                                        
       2300-PROCESS-ADDR-ID.                                            
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7100-FETCH-ADDR-ID           THRU 7100-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE HT-ADDRESS-ID                TO WS-ADDRESS-ID        
              MOVE WS-ADDRESS-ID                TO WS-ADDRESS-ID-S      
                                                                        
              IF WS-ADDRESS-ID = SI-ADDRESS-ID                          
                         AND WS-ADDRESS-ID > 0                          
                 MOVE 'N'                TO WS-NEW-ADDRESS-FLAG         
              END-IF                                                    
                                                                        
              IF WS-ADDRESS-FORMAT = 'A' AND WS-ADDRESS-ID > 0          
C35665           MOVE 'N' TO WS-PREMISE-ADDR-FL                         
C35665           PERFORM 7700-CHECK-PREMISE THRU 7700-EXIT              
C35665           IF WS-PREMISE-ADDR-FL = 'Y'                            
C35665               MOVE PR-PREMISE-NO TO AT-PREMISE-NO                
C35665               PERFORM 7600-SERVICE-ADDRESS THRU 7600-EXIT        
C35665               PERFORM 2600-GET-ADDRESS-ID THRU 2600-EXIT         
C35665               PERFORM 8000-INSERT-ADDRESS THRU 8000-EXIT         
C35665*              MOVE DY-ZIP-CODE TO A4-ZIP-CODE                    11271300
C35665*              MOVE DY-ZIP-CODE-TOKEN TO A4-ZIP-CODE-TOKEN        11271400
C35665*              PERFORM 7240-SELECT-TOWN-ST THRU 7240-EXIT         11271500
C35665               MOVE 'A' TO WS-ADDRESS-FORMAT                      
C35665               MOVE DY-ADDRESS-ID TO WS-ADDRESS-ID                
C35665               MOVE WS-ADDRESS-ID TO WS-ADDRESS-ID-S              
C35665               PERFORM 2400-SEND-ADDR-FORM THRU 2400-EXIT         
C35665           ELSE                                                   
                     PERFORM 7200-SELECT-ADDR-FORM THRU 7200-EXIT       
      *              MOVE DY-ZIP-CODE           TO A4-ZIP-CODE          11570000
      *              MOVE DY-ZIP-CODE-TOKEN     TO A4-ZIP-CODE-TOKEN    11580000
      *              PERFORM 7240-SELECT-TOWN-ST THRU 7240-EXIT         11590000
                     PERFORM 2400-SEND-ADDR-FORM THRU 2400-EXIT         
C35665           END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-ADDRESS-FORMAT = 'B' AND WS-ADDRESS-ID > 0          
                 PERFORM 7300-SELECT-ADDR-FREE  THRU 7300-EXIT          
                 PERFORM 2500-SEND-ADDR-FREE THRU 2500-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11730000
      * 2400-SEND-ADDR-FORM                                            *11740000
      *                                                                *11750000
      *     CALLS       2700-PROCESS-BILL-HDR                          *11760000
      *                 8100-SEND-RESULT                               *11770000
      *                                                                *11780000
      *     CALLED FROM 2300-PROCESS-ADDR-ID                           *11790000
      *                                                                *11800000
      *     SENDS THE FORMATTED BILLING ADDRESS RESULT SET.            *11810000
      ******************************************************************11820000
                                                                        
       2400-SEND-ADDR-FORM.                                             
                                                                        
           MOVE '2400'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-ADDRESS-ID-S            TO RS-ADDRESS-ID.            
           MOVE DY-HOUSE-NO                TO RS-FO-HOUSE-NO.           
           MOVE DY-ADDR-PREFIX-1           TO RS-FO-ADDR-PREFIX-1.      
           MOVE DY-ADDR-PREFIX-2           TO RS-FO-ADDR-PREFIX-2.      
           MOVE DY-STREET-NAME             TO RS-FO-STREET-NAME.        
           MOVE DY-STREET-SUFFIX           TO RS-FO-STREET-SUFFIX.      
           MOVE DY-STREET-LOCATION-1       TO RS-FO-STREET-LOCATION-1.  
           MOVE DY-STREET-LOCATION-2       TO RS-FO-STREET-LOCATION-2.  
           MOVE DY-ADDRESS-OVERFLOW        TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE DY-ZIP-CODE                TO RS-FO-ZIP-CODE.           
           MOVE DY-ZIP-CODE-PLUS-FOUR      TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE DY-ZIP-CODE-TOKEN          TO RS-FO-ZIP-CODE-TOKEN.     
           MOVE DY-ADDR-USAGE-CD           TO RS-FO-ADDR-USAGE-CD.      
           MOVE A4-TOWN                    TO RS-FO-TOWN.               
           MOVE A4-STATE                   TO RS-FO-STATE.              
           MOVE SPACES                     TO RS-FR-ADDR-STREET.        
           MOVE SPACES                     TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FR-CITY-STATE.         
           MOVE SPACES                     TO RS-FR-ZIP-CODE.           
           MOVE SPACES                     TO RS-FR-COUNTRY.            
           MOVE DY-ADDR-SUFFIX             TO RS-ADDR-SUFFIX.           
           MOVE DY-CARRIER-ROUTE           TO RS-CARRIER-ROUTE.         
P00740     MOVE WS-ADDRESS-LINE            TO RS-FULL-ADDRESS.          
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12190000
      * 2500-SEND-ADDR-FREE                                            *12200000
      *                                                                *12210000
      *     CALLS       2700-PROCESS-BILL-HDR                          *12220000
      *                 8100-SEND-RESULT                               *12230000
      *                                                                *12240000
      *     CALLED FROM 2300-PROCESS-ADDR-ID                           *12250000
      *                                                                *12260000
      *     SENDS THE FREEFORM BILLING ADDRESS RESULT SET.             *12270000
      ******************************************************************12280000
                                                                        
       2500-SEND-ADDR-FREE.                                             
                                                                        
           MOVE '2500'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-ADDRESS-ID-S            TO RS-ADDRESS-ID.            
           MOVE SPACES                     TO RS-FO-HOUSE-NO.           
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-1.      
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-2.      
           MOVE SPACES                     TO RS-FO-STREET-NAME.        
           MOVE SPACES                     TO RS-FO-STREET-SUFFIX.      
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-1.  
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-2.  
           MOVE SPACES                     TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE.           
           MOVE SPACES                     TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE-TOKEN.     
           MOVE SPACES                     TO RS-FO-ADDR-USAGE-CD.      
           MOVE SPACES                     TO RS-FO-TOWN.               
           MOVE SPACES                     TO RS-FO-STATE.              
           MOVE DZ-ADDR-STREET             TO RS-FR-ADDR-STREET.        
           MOVE DZ-ADDRESS-OVERFLOW        TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE DZ-ADDR-CITY-STATE         TO RS-FR-CITY-STATE.         
           MOVE DZ-ADDR-ZIP-CODE           TO RS-FR-ZIP-CODE.           
           MOVE DZ-ADDR-COUNTRY            TO RS-FR-COUNTRY.            
           MOVE SPACES                     TO RS-ADDR-SUFFIX.           
           MOVE SPACES                     TO RS-CARRIER-ROUTE.         
P00740     MOVE WS-ADDRESS-LINE            TO RS-FULL-ADDRESS.          
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32615 2600-GET-ADDRESS-ID.                                             
C32615                                                                  
C32615     MOVE SPACES                        TO WS-90-PANEL-NO.        
C32615     MOVE SPACES                        TO WS-90-USERID.          
C32615     MOVE ZEROES                        TO WS-90-ACCOUNT-NO.      
C32615     MOVE ZEROES                        TO WS-90-CUSTOMER-NO.     
C32615     MOVE ZEROES                        TO WS-90-PREMISE-NO.      
C32615                                                                  
C32615     PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT.           
C32615                                                                  
C32615 2600-EXIT.                                                       
C32615     EXIT.                                                        
                                                                        
C32615     EXEC SQL                                                             
C32615         INCLUDE CPD00090                                                 
C32615     END-EXEC.                                                            
C32615     EXEC SQL                                                             
C32615         INCLUDE CPD00071                                                 
C32615     END-EXEC.                                                            
                                                                        
      ******************************************************************12650000
      * 7000-OPEN-ADDR-CURSOR                                          *12660000
      *                                                                *12670000
      *     CALLS       9000-SEND-ERROR-RESULT                         *12680000
      *                 9900-SQL-ERROR-ROUTINE                         *12690000
      *                                                                *12700000
      *     CALLED FROM 2200-BUILD-RESULT                              *12710000
      *                                                                *12720000
      *     OPENS THE ADDR-CURSOR                                      *12730000
      ******************************************************************12740000
                                                                        
       7000-OPEN-ADDR-CURSOR.                                           
                                                                        
           MOVE '7000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              OPEN ADDR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
CBSI          MOVE 'CSS_NAME'                   TO TABLE-2              
              MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-CUSTOMER-NO-S             TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13010000
      * 7100-FETCH-ADDR-ID                                             *13020000
      *                                                                *13030000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13040000
      *                 9900-SQL-ERROR-ROUTINE                         *13050000
      *                                                                *13060000
      *     CALLED FROM  2300-PROCESS-ADDR-ID                          *13070000
      *                                                                *13080000
      *     RETRIEVE THE ADDRESS-ID FROM CURSOR INTO WORKING STORAGE.  *13090000
      ******************************************************************13100000
                                                                        
       7100-FETCH-ADDR-ID.                                              
                                                                        
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              FETCH   ADDR_CURSOR                                       
              INTO    :HT-ADDRESS-ID, :WS-ADDRESS-FORMAT                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
CBSI          MOVE 'CSS_NAME'                   TO TABLE-2              
CBSI          MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-CUSTOMER-NO-S             TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T11430******************************************************************13781000
T11430* 7110-OPEN-ACCT-CURSOR                                          *13782000
T11430*                                                                *13783000
T11430*     CALLS       9000-SEND-ERROR-RESULT                         *13784000
T11430*                 9900-SQL-ERROR-ROUTINE                         *13785000
T11430*                                                                *13786000
T11430*     CALLED FROM 2200-BUILD-RESULT                              *13787000
T11430*                                                                *13788000
T11430*     OPEN ACCT_CURSOR.                                          *13789000
T11430******************************************************************13789100
                                                                        
T11430 7110-OPEN-ACCT-CURSOR.                                           
T11430                                                                  
T11430     MOVE '7110'                          TO ACTIVE-PARAGRAPH.    
T11430                                                                  
T11430     EXEC SQL                                                     
T11430        OPEN ACCT_CURSOR                                          
T11430     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11430                                                                  
T11430     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11430                                                                  
T11430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11430        NEXT SENTENCE                                             
T11430     ELSE                                                         
T11430        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
T11430        MOVE 'CSS_ACCOUNT'                TO TABLE-1              
T11430        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
T11430        MOVE WS-CUSTOMER-NO-S             TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
T11430        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T11430        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T11430     END-IF.                                                      
T11430                                                                  
T11430 7110-EXIT.                                                       
T11430     EXIT.                                                        
                                                                        
T11430******************************************************************13791800
T11430* 7120-FETCH-ACCT-CURSOR                                         *13791900
T11430*                                                                *13792000
T11430*     CALLS       9000-SEND-ERROR-RESULT                         *13793000
T11430*                 9900-SQL-ERROR-ROUTINE                         *13794000
T11430*                                                                *13794100
T11430*     CALLED FROM  2300-PROCESS-ADDR-ID                          *13794200
T11430*                                                                *13794300
T11430*     RETRIEVE ACCOUNT NUMBER, ADDRESS ID AND AADDRESS FORMAT.   *13794400
T11430******************************************************************13794500
                                                                        
T11430 7120-FETCH-ACCT-CURSOR.                                          
T11430                                                                  
T11430     MOVE '7120'                          TO ACTIVE-PARAGRAPH.    
T11430                                                                  
T11430     EXEC SQL                                                     
T11430        FETCH   ACCT_CURSOR                                       
T11430        INTO    :AT-ACCOUNT-NO,                                   
T11430                :AT-ADDRESS-ID,                                   
T11430                :AT-ADDRESS-FORMAT,                               
C32615                :AT-PREMISE-NO                                    
T11430     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11430                                                                  
T11430     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11430                                                                  
T11430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T11430        NEXT SENTENCE                                             
T11430     ELSE                                                         
T11430        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
T11430        MOVE 'CSS_ACCOUNT'                TO TABLE-1              
CBSI          MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
T11430        MOVE WS-CUSTOMER-NO-S             TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
T11430        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T11430        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T11430     END-IF.                                                      
T11430                                                                  
T11430 7120-EXIT.                                                       
T11430     EXIT.                                                        
                                                                        
T11430******************************************************************13797300
T11430* 7130-CLOSE-ACCT-CURSOR                                         *13797400
T11430*                                                                *13797500
T11430*     CALLS       9000-SEND-ERROR-RESULT                         *13797600
T11430*                 9900-SQL-ERROR-ROUTINE                         *13797700
T11430*                                                                *13797800
T11430*     CALLED FROM 2200-BUILD-RESULT                              *13797900
T11430*                                                                *13798000
T11430*     CLOSES THE ACCT_CURSOR                                     *13798100
T11430******************************************************************13798200
                                                                        
T11430 7130-CLOSE-ACCT-CURSOR.                                          
T11430                                                                  
T11430     MOVE '7130'                          TO ACTIVE-PARAGRAPH.    
T11430                                                                  
T11430     EXEC SQL                                                     
T11430        CLOSE ACCT_CURSOR                                         
T11430     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11430                                                                  
T11430     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11430                                                                  
T11430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11430        NEXT SENTENCE                                             
T11430     ELSE                                                         
T11430        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
CBSI          MOVE 'CLOSE'                       TO ABEND-FUNCTION      
T11430        MOVE 'CSS_ACCOUNT'                 TO TABLE-1             
T11430        MOVE 'CUSTOMER_NO'                 TO TABLE-ELEMENT-1     
T19254        MOVE 'PREMISE_NO'                  TO TABLE-ELEMENT-2     
T11430        MOVE WS-CUSTOMER-NO-S              TO HOSTVAR-ELEMENT-1   
T19254        MOVE PARM-PREMISE-NO               TO HOSTVAR-ELEMENT-2   
T11430        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
T11430        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
T11430     END-IF.                                                      
T11430                                                                  
T11430 7130-EXIT.                                                       
T11340     EXIT.                                                        
                                                                        
      ******************************************************************13800900
      * 7200-SELECT-ADDR-FORM                                          *13801000
      *                                                                *13810000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13820000
      *                 9900-SQL-ERROR-ROUTINE                         *13830000
      *                                                                *13840000
      *     CALLED FROM 2300-PROCESS-ADDR-ID                           *13850000
      *                                                                *13860000
      *     RETRIEVE THE FORMATTED ADDRESS DETAILS.                    *13870000
      ******************************************************************13880000
                                                                        
       7200-SELECT-ADDR-FORM.                                           
                                                                        
           MOVE '7200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ADDRESS_OVERFLOW,                                 
                      DY.ZIP_CODE,                                      
                      ZIP_CODE_PLUS_FOUR,                               
                      DY.ZIP_CODE_TOKEN,                                
                      ADDR_SUFFIX,                                      
                      CARRIER_ROUTE,                                    
P00740                TOWN,                                             
P00740                STATE,                                            
P00740                RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE) + '-' + LTRIM(RTRIM(
           DY.ZIP_CODE_PLUS_FOUR))))))))))))))   
              INTO    :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX,                                  
                      :DY-CARRIER-ROUTE,                                
P00740                :A4-TOWN,                                         
P00740                :A4-STATE,                                        
P00740                :WS-ADDRESS-LINE                                  
P00740        FROM    CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
P00740                CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
P00740          AND   DY.ZIP_CODE = A4.ZIP_CODE                         
P00740          AND   DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     13940000
MFA-TR*       SELECT  HOUSE_NO,                                         13950000
MFA-TR*               ADDR_PREFIX_1,                                    13960000
MFA-TR*               ADDR_PREFIX_2,                                    13970000
MFA-TR*               STREET_NAME,                                      13980000
MFA-TR*               STREET_SUFFIX,                                    13990000
MFA-TR*               STREET_LOCATION_1,                                14000000
MFA-TR*               STREET_LOCATION_2,                                14010000
MFA-TR*               ADDRESS_OVERFLOW,                                 14020000
MFA-TR*               DY.ZIP_CODE,                                      14030000
MFA-TR*               ZIP_CODE_PLUS_FOUR,                               14040000
MFA-TR*               DY.ZIP_CODE_TOKEN,                                14050000
MFA-TR*               ADDR_SUFFIX,                                      14060000
MFA-TR*               CARRIER_ROUTE,                                    14070000
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                   
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                              
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                              
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE) || '-' ||                        
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE_PLUS_FOUR))))))))))))))           
MFA-TR*       INTO    :DY-HOUSE-NO,                                     14080000
MFA-TR*               :DY-ADDR-PREFIX-1,                                14090000
MFA-TR*               :DY-ADDR-PREFIX-2,                                14100000
MFA-TR*               :DY-STREET-NAME,                                  14110000
MFA-TR*               :DY-STREET-SUFFIX,                                14120000
MFA-TR*               :DY-STREET-LOCATION-1,                            14130000
MFA-TR*               :DY-STREET-LOCATION-2,                            14140000
MFA-TR*               :DY-ADDRESS-OVERFLOW,                             14150000
MFA-TR*               :DY-ZIP-CODE,                                     14160000
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                           14170000
MFA-TR*               :DY-ZIP-CODE-TOKEN,                               14180000
MFA-TR*               :DY-ADDR-SUFFIX,                                  14190000
MFA-TR*               :DY-CARRIER-ROUTE,                                14200000
MFA-TR*               :A4-TOWN,                                         14200000
MFA-TR*               :A4-STATE,                                        14200000
MFA-TR*               :WS-ADDRESS-LINE                                  14200000
MFA-TR*       FROM    CSS_ADDR_FORMATTED DY,                            14210000
MFA-TR*               CSS_ZIP_CODE A4                                   14210000
MFA-TR*       WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        14220000
MFA-TR*         AND   DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*         AND   DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    14230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
T19254        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-3      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
T19254        MOVE PARM-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14420000
      * 7240-SELECT-TOWN-ST                                            *14430000
      *                                                                *14440000
      *     CALLS       9000-SEND-ERROR-RESULT                         *14450000
      *                 9900-SQL-ERROR-ROUTINE                         *14460000
      *                                                                *14470000
      *     CALLED FROM 2400-BUILD-RESULT                              *14480000
      *                                                                *14490000
      *     RETRIEVE THE TOWN AND STATE FOR A GIVEN ZIP CODE.          *14500000
      ******************************************************************14510000
                                                                        
       7240-SELECT-TOWN-ST.                                             
                                                                        
           MOVE '7240'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  TOWN,                                             
                      STATE                                             
              INTO    :A4-TOWN,                                         
                      :A4-STATE                                         
              FROM    CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
              WHERE   ZIP_CODE  = :A4-ZIP-CODE AND                      
                      ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN               
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14570000
MFA-TR*       SELECT  TOWN,                                             14580000
MFA-TR*               STATE                                             14590000
MFA-TR*       INTO    :A4-TOWN,                                         14600000
MFA-TR*               :A4-STATE                                         14610000
MFA-TR*       FROM    CSS_ZIP_CODE                                      14620000
MFA-TR*       WHERE   ZIP_CODE  = :A4-ZIP-CODE AND                      14630000
MFA-TR*               ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN               14640000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    14650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ZIP_CODE'               TO TABLE-1              
              MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-1      
              MOVE 'ZIP_CODE_TOKEN'             TO TABLE-ELEMENT-2      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-3      
T19254        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-4      
              MOVE A4-ZIP-CODE                  TO HOSTVAR-ELEMENT-1    
              MOVE A4-ZIP-CODE-TOKEN            TO HOSTVAR-ELEMENT-2    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-3    
T19254        MOVE PARM-CUSTOMER-NO             TO HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14860000
      * 7300-SELECT-ADDR-FREE                                          *14870000
      *                                                                *14880000
      *     CALLS       9000-SEND-ERROR-RESULT                         *14890000
      *                 9900-SQL-ERROR-ROUTINE                         *14900000
      *                                                                *14910000
      *     CALLED FROM 2300-PROCESS-ADDR-ID                           *14920000
      *                                                                *14930000
      *     RETRIEVE THE FREEFORM ADDRESS DETAILS.                     *14940000
      ******************************************************************14950000
                                                                        
       7300-SELECT-ADDR-FREE.                                           
                                                                        
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  ADDR_STREET,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_CITY_STATE,                                  
                      ADDR_ZIP_CODE,                                    
                      ADDR_COUNTRY,                                     
P00740                RTRIM(LTRIM(RTRIM(ADDR_STREET) + ' ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(ADDR_CITY_STATE
           ) + ' ' + LTRIM(RTRIM(ADDR_ZIP_CODE) + ' ' + LTRIM(RTRIM(
           ADDR_COUNTRY)))))))                   
              INTO    :DZ-ADDR-STREET,                                  
                      :DZ-ADDRESS-OVERFLOW,                             
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY,                                 
P00740                :WS-ADDRESS-LINE                                  
              FROM    CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     15010000
MFA-TR*       SELECT  ADDR_STREET,                                      15020000
MFA-TR*               ADDRESS_OVERFLOW,                                 15030000
MFA-TR*               ADDR_CITY_STATE,                                  15040000
MFA-TR*               ADDR_ZIP_CODE,                                    15050000
MFA-TR*               ADDR_COUNTRY,                                     15060000
MFA-TR*               RTRIM(LTRIM(RTRIM(ADDR_STREET) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(ADDR_CITY_STATE) || ' ' ||                    
MFA-TR*               LTRIM(RTRIM(ADDR_ZIP_CODE) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_COUNTRY)))))))                           
MFA-TR*       INTO    :DZ-ADDR-STREET,                                  15070000
MFA-TR*               :DZ-ADDRESS-OVERFLOW,                             15080000
MFA-TR*               :DZ-ADDR-CITY-STATE,                              15090000
MFA-TR*               :DZ-ADDR-ZIP-CODE,                                15100000
MFA-TR*               :DZ-ADDR-COUNTRY,                                 15110000
MFA-TR*               :WS-ADDRESS-LINE                                  15110000
MFA-TR*       FROM    CSS_ADDR_FREEFORM                                 15120000
MFA-TR*       WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        15130000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
T19254        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-3      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
T19254        MOVE PARM-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15330000
      * 7400-CLOSE-ADDR-CURSOR                                         *15340000
      *                                                                *15350000
      *     CALLS       9000-SEND-ERROR-RESULT                         *15360000
      *                 9900-SQL-ERROR-ROUTINE                         *15370000
      *                                                                *15380000
      *     CALLED FROM 2200-BUILD-RESULT                              *15390000
      *                                                                *15400000
      *     CLOSES THE ADDR-CURSOR                                     *15410000
      ******************************************************************15420000
                                                                        
       7400-CLOSE-ADDR-CURSOR.                                          
                                                                        
           MOVE '7400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              CLOSE ADDR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
CBSI          MOVE 'CSS_NAME'                   TO TABLE-2              
              MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
T19254        MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-CUSTOMER-NO-S             TO HOSTVAR-ELEMENT-1    
T19254        MOVE PARM-PREMISE-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15690000
      * 7500-SELECT-LANDLORD                                           *15700000
      *                                                                *15710000
      *    1.  RETRIEVE EXISTING DATA FOR LANDLORD.                    *15720000
      *                                                                *15730000
      ******************************************************************15740000
                                                                        
       7500-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     LL_MASTER_ACCT_NO,                                 
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT                                     
              INTO   :SI-CUSTOMER-NO,                                   
                     :SI-LL-MASTER-ACCT-NO,                             
                     :SI-ADDRESS-ID,                                    
                     :SI-ADDRESS-FORMAT                                 
              FROM   CSS_LANDLORD WITH(READUNCOMMITTED)                         
              WHERE  PREMISE_NO = :SI-PREMISE-NO                        
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15780000
MFA-TR*       SELECT CUSTOMER_NO,                                       15790000
MFA-TR*              LL_MASTER_ACCT_NO,                                 15800000
MFA-TR*              ADDRESS_ID,                                        15810000
MFA-TR*              ADDRESS_FORMAT                                     15820000
MFA-TR*       INTO   :SI-CUSTOMER-NO,                                   15830000
MFA-TR*              :SI-LL-MASTER-ACCT-NO,                             15840000
MFA-TR*              :SI-ADDRESS-ID,                                    15850000
MFA-TR*              :SI-ADDRESS-FORMAT                                 15860000
MFA-TR*       FROM   CSS_LANDLORD                                       15870000
MFA-TR*       WHERE  PREMISE_NO = :SI-PREMISE-NO                        15880000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMSIE_NO'         TO TABLE-ELEMENT-1              
T19254        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
T19254        MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32615******************************************************************15690000
C32615* 7600-SERVICE-ADDRESS                                           *15700000
C32615*                                                                *15710000
C32615*    1.  RETRIEVE SERVICE ADDRESS FOR LANDLORD.                  *15720000
C32615*                                                                *15730000
C32615******************************************************************15740000
C32615                                                                  
C32615 7600-SERVICE-ADDRESS.                                            
C32615                                                                  
C32615     EXEC SQL                                                     
C32615        SELECT ADDR_PREFIX_1,                                     
C32615               ADDR_PREFIX_2,                                     
C32615               ADDR_SUFFIX,                                       
C32615               ADDR_USAGE_CD,                                     
C32615               DY.ADDRESS_ID,                                     
C32615               ADDRESS_OVERFLOW,                                  
C32615               CARRIER_ROUTE,                                     
C32615               HOUSE_NO,                                          
C32615               STREET_LOCATION_1,                                 
C32615               STREET_LOCATION_2,                                 
C32615               STREET_NAME,                                       
C32615               STREET_SUFFIX,                                     
C32615               USPS_DELIV_PT_CD,                                  
C32615               DY.ZIP_CODE,                                       
C32615               ZIP_CODE_PLUS_FOUR,                                
C32615               DY.ZIP_CODE_TOKEN,                                 
P00740               TOWN,                                              
P00740               STATE,                                             
P00740               RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))               
C32615        INTO   :DY-ADDR-PREFIX-1,                                 
C32615               :DY-ADDR-PREFIX-2,                                 
C32615               :DY-ADDR-SUFFIX,                                   
C32615               :DY-ADDR-USAGE-CD,                                 
C32615               :DY-ADDRESS-ID,                                    
C32615               :DY-ADDRESS-OVERFLOW,                              
C32615               :DY-CARRIER-ROUTE,                                 
C32615               :DY-HOUSE-NO,                                      
C32615               :DY-STREET-LOCATION-1,                             
C32615               :DY-STREET-LOCATION-2,                             
C32615               :DY-STREET-NAME,                                   
C32615               :DY-STREET-SUFFIX,                                 
C32615               :DY-USPS-DELIV-PT-CD,                              
C32615               :DY-ZIP-CODE,                                      
C32615               :DY-ZIP-CODE-PLUS-FOUR,                            
C32615               :DY-ZIP-CODE-TOKEN,                                
P00740               :A4-TOWN,                                          
P00740               :A4-STATE,                                         
P00740               :WS-ADDRESS-LINE                                   
C32615        FROM   CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
C32615               CSS_PREMISE PR WITH(READUNCOMMITTED),                      
P00740               CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
C32615        WHERE  PREMISE_NO = :AT-PREMISE-NO                        
C32615          AND  PR.ADDRESS_ID = DY.ADDRESS_ID                      
P00740          AND  DY.ZIP_CODE = A4.ZIP_CODE                          
P00740          AND  DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
C32615                                                           
C32615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     15780000
MFA-TR*       SELECT ADDR_PREFIX_1,                                     15790000
MFA-TR*              ADDR_PREFIX_2,                                     15800000
MFA-TR*              ADDR_SUFFIX,                                       15810000
MFA-TR*              ADDR_USAGE_CD,                                     15820000
MFA-TR*              DY.ADDRESS_ID,                                             
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              CARRIER_ROUTE,                                             
MFA-TR*              HOUSE_NO,                                                  
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                    
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                               
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                               
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*       INTO   :DY-ADDR-PREFIX-1,                                 15830000
MFA-TR*              :DY-ADDR-PREFIX-2,                                 15800000
MFA-TR*              :DY-ADDR-SUFFIX,                                   15810000
MFA-TR*              :DY-ADDR-USAGE-CD,                                 15820000
MFA-TR*              :DY-ADDRESS-ID,                                            
MFA-TR*              :DY-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DY-CARRIER-ROUTE,                                         
MFA-TR*              :DY-HOUSE-NO,                                              
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-USPS-DELIV-PT-CD,                                      
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :A4-TOWN,                                          14200000
MFA-TR*              :A4-STATE,                                         14200000
MFA-TR*              :WS-ADDRESS-LINE                                           
MFA-TR*       FROM   CSS_ADDR_FORMATTED DY,                             15870000
MFA-TR*              CSS_PREMISE PR,                                    15870000
MFA-TR*              CSS_ZIP_CODE A4                                    15870000
MFA-TR*       WHERE  PREMISE_NO = :AT-PREMISE-NO                        15880000
MFA-TR*         AND  PR.ADDRESS_ID = DY.ADDRESS_ID                      15880000
MFA-TR*         AND  DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*         AND  DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32615                                                                  
C32615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C32615                                                                  
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C32615         NEXT SENTENCE                                            
C32615     ELSE                                                         
C32615        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C32615        MOVE '7600'               TO ACTIVE-PARAGRAPH             
C32615        MOVE 'SELECT'             TO ABEND-FUNCTION               
C32615        MOVE 'CSS_PREMISE'        TO TABLE-1                      
C32615        MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                      
C32615        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
C32615        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
C32615        MOVE AT-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
C32615        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
C32615        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C32615        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C32615     END-IF.                                                      
C32615                                                                  
C32615 7600-EXIT.                                                       
C32615     EXIT.                                                        
                                                                        
C35665******************************************************************15690000
C35665* 7700-CHECK-PREMISE                                             *15700000
C35665*                                                                *15710000
C35665*    1.  SEE IF THE ADDRESS IS USED AS A PREMISE ADDRESS.        *15720000
C35665*                                                                *15730000
C35665******************************************************************15740000
C35665                                                                  
C35665 7700-CHECK-PREMISE.                                              
C35665                                                                  
C35665     EXEC SQL                                                     
C35665        SELECT TOP(1) 'Y',
              PREMISE_NO                                         
C35665        INTO   :WS-PREMISE-ADDR-FL,                               
C35665               :PR-PREMISE-NO                                     
C35665        FROM   CSS_PREMISE WITH(READUNCOMMITTED)                          
C35665        WHERE  ADDRESS_ID = :HT-ADDRESS-ID                        
                                                 
C35665                                                           
C35665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15780000
MFA-TR*       SELECT 'Y',                                               15790000
MFA-TR*              PREMISE_NO                                                 
MFA-TR*       INTO   :WS-PREMISE-ADDR-FL,                               15830000
MFA-TR*              :PR-PREMISE-NO                                     15830000
MFA-TR*       FROM   CSS_PREMISE                                        15870000
MFA-TR*       WHERE  ADDRESS_ID = :HT-ADDRESS-ID                        15880000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35665                                                                  
C35665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35665                                                                  
C35665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C35665         NEXT SENTENCE                                            
C35665     ELSE                                                         
C35665        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C35665        MOVE '7700'               TO ACTIVE-PARAGRAPH             
C35665        MOVE 'SELECT'             TO ABEND-FUNCTION               
C35665        MOVE 'CSS_PREMISE'        TO TABLE-1                      
C35665        MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
C35665        MOVE HT-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
C35665        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C35665        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C35665     END-IF.                                                      
C35665                                                                  
C35665 7700-EXIT.                                                       
C35665     EXIT.                                                        
                                                                        
C32615 8000-INSERT-ADDRESS.                                             
C32615                                                                  
C32615     MOVE WS-90-NEW-ADDRESS-ID          TO DY-ADDRESS-ID.         
C32615     EXEC SQL                                                     
C32615        INSERT INTO CSS_ADDR_FORMATTED                            
C32615              (ADDRESS_ID        ,                                
C32615               HOUSE_NO          ,                                
C32615               ADDR_PREFIX_1     ,                                
C32615               ADDR_PREFIX_2     ,                                
C32615               STREET_NAME       ,                                
C32615               STREET_LOCATION_1 ,                                
C32615               STREET_LOCATION_2 ,                                
C32615               STREET_SUFFIX     ,                                
C32615               ADDR_SUFFIX       ,                                
C32615               ADDRESS_OVERFLOW  ,                                
C32615               CARRIER_ROUTE     ,                                
C32615               ZIP_CODE          ,                                
C32615               ZIP_CODE_PLUS_FOUR,                                
C32615               ZIP_CODE_TOKEN    ,                                
C32615               USPS_DELIV_PT_CD  ,                                
C32615               ADDR_USAGE_CD)                                     
C32615         VALUES                                                   
C32615             (:DY-ADDRESS-ID        ,                             
C32615              :DY-HOUSE-NO          ,                             
C32615              :DY-ADDR-PREFIX-1     ,                             
C32615              :DY-ADDR-PREFIX-2     ,                             
C32615              :DY-STREET-NAME       ,                             
C32615              :DY-STREET-LOCATION-1 ,                             
C32615              :DY-STREET-LOCATION-2 ,                             
C32615              :DY-STREET-SUFFIX     ,                             
C32615              :DY-ADDR-SUFFIX       ,                             
C32615              :DY-ADDRESS-OVERFLOW  ,                             
C32615              :DY-CARRIER-ROUTE     ,                             
C32615              :DY-ZIP-CODE          ,                             
C32615              :DY-ZIP-CODE-PLUS-FOUR,                             
C32615              :DY-ZIP-CODE-TOKEN    ,                             
C32615              :DY-USPS-DELIV-PT-CD  ,                             
C32615              :DY-ADDR-USAGE-CD)                                  
C32615     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C32615                                                                  
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C32615         NEXT SENTENCE                                            
C32615     ELSE                                                         
C32615        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C32615        MOVE '8000'               TO ACTIVE-PARAGRAPH             
C32615        MOVE 'INSERT'             TO ABEND-FUNCTION               
C32615        MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
C32615        MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
C32615        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
C32615        MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
C32615        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
C32615        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C32615        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C32615     END-IF.                                                      
C32615                                                                  
C32615 8000-EXIT.                                                       
C32615     EXIT.                                                        
                                                                        
REARCH******************************************************************00000100
REARCH* 8000A-DELETE-GTT-ROWS.                                         *00000200
REARCH******************************************************************00000300
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH                                                                  
REARCH     MOVE                                                         
REARCH     'DELETE ROWS'                                                
REARCH         TO S-SQL-STATEMENT-V.                                    
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02139_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02139_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
REARCH                                                                  
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'DELETE'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02139_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
REARCH******************************************************************00000100
REARCH*8100-SEND-RESULT.                                               *00000200
REARCH******************************************************************00000300
REARCH 8100-SEND-RESULT.                                                
REARCH     EXEC SQL                                                     
REARCH       INSERT INTO #CSR02139_R1                            
REARCH       (                                                          
REARCH        RETURN_CODE                                               
REARCH       ,ADDRESS_FORMAT                                            
REARCH       ,ADDRESS_ID                                                
REARCH       ,FO_HOUSE_NO                                               
REARCH       ,FO_ADDR_PREFIX_1                                          
REARCH       ,FO_ADDR_PREFIX_2                                          
REARCH       ,FO_STREET_NAME                                            
REARCH       ,FO_STREET_SUFFIX                                          
REARCH       ,FO_STREET_LOCATN_1                                        
REARCH       ,FO_STREET_LOCATN_2                                        
REARCH       ,FO_ADDRESS_OVFLOW                                         
REARCH       ,FO_ZIP_CODE                                               
REARCH       ,FO_ZIP_CDE_PL_FOU                                         
REARCH       ,FO_ZIP_CODE_TOKEN                                         
REARCH       ,FO_ADDR_USAGE_CD                                          
REARCH       ,FO_TOWN                                                   
REARCH       ,FO_STATE                                                  
REARCH       ,FR_ADDR_STREET                                            
REARCH       ,FR_ADDRESS_OVRFLOW                                        
REARCH       ,FR_CITY_STATE                                             
REARCH       ,FR_ZIP_CODE                                               
REARCH       ,FR_COUNTRY                                                
REARCH       ,ADDR_SUFFIX                                               
REARCH       ,CARRIER_ROUTE                                             
REARCH       ,FULL_ADDRESS                                              
REARCH       )                                                          
REARCH       VALUES                                                     
REARCH       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-ADDRESS-FORMAT                                         
REARCH       ,:S-ADDRESS-ID                                             
REARCH       ,:S-FO-HOUSE-NO                                            
REARCH       ,:S-FO-ADDR-PREFIX-1                                       
REARCH       ,:S-FO-ADDR-PREFIX-2                                       
REARCH       ,:S-FO-STREET-NAME                                         
REARCH       ,:S-FO-STREET-SUFFIX                                       
REARCH       ,:S-FO-STREET-LOCATION-1                                   
REARCH       ,:S-FO-STREET-LOCATION-2                                   
REARCH       ,:S-FO-ADDRESS-OVERFLOW                                    
REARCH       ,:S-FO-ZIP-CODE                                            
REARCH       ,:S-FO-ZIP-CODE-PL-FOUR                                    
REARCH       ,:S-FO-ZIP-CODE-TOKEN                                      
REARCH       ,:S-FO-ADDR-USAGE-CD                                       
REARCH       ,:S-FO-TOWN                                                
REARCH       ,:S-FO-STATE                                               
REARCH       ,:S-FR-ADDR-STREET                                         
REARCH       ,:S-FR-ADDRESS-OVERFLOW                                    
REARCH       ,:S-FR-CITY-STATE                                          
REARCH       ,:S-FR-ZIP-CODE                                            
REARCH       ,:S-FR-COUNTRY                                             
REARCH       ,:S-ADDR-SUFFIX                                            
REARCH       ,:S-CARRIER-ROUTE                                          
REARCH       ,:S-FULL-ADDRESS                                           
REARCH       )                                                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02139_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ADDRESS_FORMAT                                                    
MFA-TR*      ,ADDRESS_ID                                                        
MFA-TR*      ,FO_HOUSE_NO                                                       
MFA-TR*      ,FO_ADDR_PREFIX_1                                                  
MFA-TR*      ,FO_ADDR_PREFIX_2                                                  
MFA-TR*      ,FO_STREET_NAME                                                    
MFA-TR*      ,FO_STREET_SUFFIX                                                  
MFA-TR*      ,FO_STREET_LOCATN_1                                                
MFA-TR*      ,FO_STREET_LOCATN_2                                                
MFA-TR*      ,FO_ADDRESS_OVFLOW                                                 
MFA-TR*      ,FO_ZIP_CODE                                                       
MFA-TR*      ,FO_ZIP_CDE_PL_FOU                                                 
MFA-TR*      ,FO_ZIP_CODE_TOKEN                                                 
MFA-TR*      ,FO_ADDR_USAGE_CD                                                  
MFA-TR*      ,FO_TOWN                                                           
MFA-TR*      ,FO_STATE                                                          
MFA-TR*      ,FR_ADDR_STREET                                                    
MFA-TR*      ,FR_ADDRESS_OVRFLOW                                                
MFA-TR*      ,FR_CITY_STATE                                                     
MFA-TR*      ,FR_ZIP_CODE                                                       
MFA-TR*      ,FR_COUNTRY                                                        
MFA-TR*      ,ADDR_SUFFIX                                                       
MFA-TR*      ,CARRIER_ROUTE                                                     
MFA-TR*      ,FULL_ADDRESS                                                      
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-ADDRESS-FORMAT                                                 
MFA-TR*      ,:S-ADDRESS-ID                                                     
MFA-TR*      ,:S-FO-HOUSE-NO                                                    
MFA-TR*      ,:S-FO-ADDR-PREFIX-1                                               
MFA-TR*      ,:S-FO-ADDR-PREFIX-2                                               
MFA-TR*      ,:S-FO-STREET-NAME                                                 
MFA-TR*      ,:S-FO-STREET-SUFFIX                                               
MFA-TR*      ,:S-FO-STREET-LOCATION-1                                           
MFA-TR*      ,:S-FO-STREET-LOCATION-2                                           
MFA-TR*      ,:S-FO-ADDRESS-OVERFLOW                                            
MFA-TR*      ,:S-FO-ZIP-CODE                                                    
MFA-TR*      ,:S-FO-ZIP-CODE-PL-FOUR                                            
MFA-TR*      ,:S-FO-ZIP-CODE-TOKEN                                              
MFA-TR*      ,:S-FO-ADDR-USAGE-CD                                               
MFA-TR*      ,:S-FO-TOWN                                                        
MFA-TR*      ,:S-FO-STATE                                                       
MFA-TR*      ,:S-FR-ADDR-STREET                                                 
MFA-TR*      ,:S-FR-ADDRESS-OVERFLOW                                            
MFA-TR*      ,:S-FR-CITY-STATE                                                  
MFA-TR*      ,:S-FR-ZIP-CODE                                                    
MFA-TR*      ,:S-FR-COUNTRY                                                     
MFA-TR*      ,:S-ADDR-SUFFIX                                                    
MFA-TR*      ,:S-CARRIER-ROUTE                                                  
MFA-TR*      ,:S-FULL-ADDRESS                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARCH        MOVE '8900'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02139_R1'        TO TABLE-1                      
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH     ADD 1 TO CTR-ROWS.                                           
REARCH                                                                  
REARCH 8100-EXIT.                                                       
REARCH      EXIT.                                                       
                                                                        
      ******************************************************************16095000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16100000
      ******************************************************************16110000
                                                                        
REARCH     EXEC SQL                                                     16120000
REARCH        INCLUDE CPDSP300                                          16130000
REARCH     END-EXEC.                                                    16140000
                                                                        
      ******************************************************************16160000
      *       END PROGRAM COPYLIB                                      *16170000
      ******************************************************************16180000
                                                                        
REARCH                                                                  
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00330                                                 
REARCH     END-EXEC.                                                            
