       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02130.                                         
COB303 DATE-WRITTEN.      JULY 24, 1995.                                
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S130 CONVERTED TO DB2 SP CSR02130 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S130                                           *00120000
      *  PROGRAM:       S130                                           *00130000
      *  CALLING SP:    PN_S130                                        *00140000
      *                                                                *00150000
      *                                                                *00160000
      ******************************************************************00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM FETCHES TAX RATES FOR THE REVENUE DISTRICT.      *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  07/24/95    RC       RPC PROGRAM ORIGINALLY CODED.            *00270000
      *  10/04/95    SG       MINOR MODIFICATIONS.                     *00280000
CBSI  *  08/17/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00280100
CBSI  *             MADRAS    ABEND PARAMETERS                         *00281000
A00406*  06/01/10   SVALLURI                                           *00290000
      *                                                                *00290000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02130'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S130 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
           EXEC SQL                                                     00620000
              INCLUDE TBPREM                                            00630000
           END-EXEC.                                                    00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBTXCNTL                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
              INCLUDE TBTXRATE                                          00710000
           END-EXEC.                                                    00720000
                                                                        
           EXEC SQL                                                     00740000
              INCLUDE TBTXUSE                                           00750000
           END-EXEC.                                                    00760000
                                                                        
           EXEC SQL                                                     00780000
              INCLUDE TBMODEL                                           00790000
           END-EXEC.                                                    00800000
                                                                        
      ******************************************************************00820000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00830000
      ******************************************************************00840000
                                                                        
      ******************************************************************00860000
      *    COPYBOOKS                                                   *00870000
      ******************************************************************00880000
                                                                        
CVT999*    COPY SYGWCOB.                                                00900000
CVT999*    COPY SYDBCOB.                                                00910000
           COPY CCA00001.                                               00920000
CVT999*    COPY CWS00010.                                               00930000
           COPY CWS00027.                                               00940000
           COPY CWS00303.                                               00950000
                                                                        
                                                                        
      ******************************************************************00980000
      *    WORK AREAS                                                  *00990000
      ******************************************************************01000000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                         01030000
CVT999*    05  GWL-INIT-HANDLE         POINTER.                         01040000
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                  01050000
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01060000
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01070000
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01080000
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01090000
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01100000
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
CVT999*    05  PARM-ID1                 PIC S9(9) COMP VALUE 1.         01170000
           05  PARM-PREMISE-NO          PIC X(10).                      
           05  WS-PREMISE-NO-NUM REDEFINES PARM-PREMISE-NO              
                                        PIC 9(10).                      
           05  PARM-DATE-COMP           PIC X(10).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          01250000
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          01280000
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  01320000
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                  01330000
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                  01340000
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-TAX-TYPE             PIC X(1)  VALUE SPACES.          
           05  RS-TAX-ELEC             PIC X(1)  VALUE SPACES.          
           05  RS-TAX-GAS              PIC X(1)  VALUE SPACES.          
           05  RS-TAX-MDSE             PIC X(1)  VALUE SPACES.          
           05  RS-TAX-WATER            PIC X(1)  VALUE SPACES.          
           05  RS-TAX-SEWER            PIC X(1)  VALUE SPACES.          
           05  RS-TAX-TRASH            PIC X(1) VALUE SPACES.           
           05  RS-TAX-RATE             PIC S9V9(4) COMP-3 VALUE 0.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                            01490000
CVT999*    05  CNS-RETURN-CODE          PIC X(11) VALUE                 01500000
CVT999*                                'RETURN_CODE'.                   01510000
CVT999*    05  CNS-TAX-TYPE             PIC X(8) VALUE                  01520000
CVT999*                                'TAX_TYPE'.                      01530000
CVT999*    05  CNS-TAX-ELEC            PIC X(8) VALUE                   01540000
CVT999*                                'TAX_ELEC'.                      01550000
CVT999*    05  CNS-TAX-GAS             PIC X(7) VALUE                   01560000
CVT999*                                'TAX_GAS'.                       01570000
CVT999*    05  CNS-TAX-MDSE            PIC X(8) VALUE                   01580000
CVT999*                                'TAX_MDSE'.                      01590000
CVT999*    05  CNS-TAX-WATER           PIC X(9) VALUE                   01600000
CVT999*                                'TAX_WATER'.                     01610000
CVT999*    05  CNS-TAX-SEWER           PIC X(9) VALUE                   01620000
CVT999*                                'TAX_SEWER'.                     01630000
CVT999*    05  CNS-TAX-TRASH           PIC X(9) VALUE                   01640000
CVT999*                                'TAX_TRASH'.                     01650000
CVT999*    05  CNS-TAX-RATE            PIC X(8) VALUE                   01660000
CVT999*                                'TAX_RATE'.                      01670000
CVT999*                                                                 01680000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME          PIC X(08) VALUE 'S130    '.        
           05  WS-PREMISE-NO         PIC S9(10)V USAGE COMP-3 VALUE 0.  
           05  WS-REV-DIST-CD        PIC X(3)   VALUE SPACES.           
           05  WS-COMP-DATE          PIC X(10)  VALUE SPACES.           
                                                                        
      *---------CURSOR DECLARATION---------------->                     01830000
           EXEC SQL DECLARE TAX-CURSOR CURSOR FOR                       
              SELECT TC.TAX_TYPE,                                       
                     TU.TAX_ELEC,                                       
                     TU.TAX_GAS,                                        
                     TU.TAX_MDSE,                                       
                     TU.TAX_WATER,                                      
                     TU.TAX_SEWER,                                      
                     TU.TAX_TRASH,                                      
                     TR.TAX_RATE                                        
              FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED),                       
                   CSS_TAX_RATE TR WITH(READUNCOMMITTED),                       
                   CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)                    
              WHERE TC.TAX_CNTRL_NO = TU.TAX_CNTRL_NO                   
              AND   TC.TAX_CNTRL_NO = TR.TAX_CNTRL_NO                   
              AND   TC.OPER_MODE    = 'A'                               
              AND   TC.OPER_MODE    = TU.OPER_MODE                      
              AND   TC.OPER_MODE    = TR.OPER_MODE                      
              AND   TR.DETAIL_ID    = :WS-REV-DIST-CD                   
              AND   TR.DETAIL_ID    = TU.DETAIL_ID                      
              AND   TR.DATE_FROM   <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-COMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMP-DATE
              ) <> 0) OR (LEN(:WS-COMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-COMP-DATE
              ), CONVERT(DATE, :WS-COMP-DATE) )                     
              AND   TR.DATE_TO     >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-COMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMP-DATE
              ) <> 0) OR (LEN(:WS-COMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-COMP-DATE
              ), CONVERT(DATE, :WS-COMP-DATE) )                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE TAX-CURSOR CURSOR FOR                       01840000
MFA-TR*       SELECT TC.TAX_TYPE,                                       01850000
MFA-TR*              TU.TAX_ELEC,                                       01860000
MFA-TR*              TU.TAX_GAS,                                        01870000
MFA-TR*              TU.TAX_MDSE,                                       01880000
MFA-TR*              TU.TAX_WATER,                                      01890000
MFA-TR*              TU.TAX_SEWER,                                      01900000
MFA-TR*              TU.TAX_TRASH,                                      01910000
MFA-TR*              TR.TAX_RATE                                        01920000
MFA-TR*       FROM CSS_TAX_CNTL TC,                                     01930000
MFA-TR*            CSS_TAX_RATE TR,                                     01940000
MFA-TR*            CSS_TAX_USE_CNTL TU                                  01950000
MFA-TR*       WHERE TC.TAX_CNTRL_NO = TU.TAX_CNTRL_NO                   01960000
MFA-TR*       AND   TC.TAX_CNTRL_NO = TR.TAX_CNTRL_NO                   01970000
MFA-TR*       AND   TC.OPER_MODE    = 'A'                               01980000
MFA-TR*       AND   TC.OPER_MODE    = TU.OPER_MODE                      01990000
MFA-TR*       AND   TC.OPER_MODE    = TR.OPER_MODE                      02000000
MFA-TR*       AND   TR.DETAIL_ID    = :WS-REV-DIST-CD                   02010000
MFA-TR*       AND   TR.DETAIL_ID    = TU.DETAIL_ID                      02020000
MFA-TR*       AND   TR.DATE_FROM   <= :WS-COMP-DATE                     02030000
MFA-TR*       AND   TR.DATE_TO     >= :WS-COMP-DATE                     02040000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    02050000
                                                                        
HPCCDM*EJECT                                                            02070000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR                             
A00406                          WITH ROWSET POSITIONING FOR             
CVT000         SELECT *                                                 
CVT000         FROM #CSR02130_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02130_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-DATE-COMP           PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-PREMISE-NO                                         
CVT000         ,LINK-DATE-COMP                                          
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              02080000
                                                                        
      ******************************************************************02100000
      * 0000-MAINLINE                                                  *02110000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02120000
      ******************************************************************02130000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02250000
      * 0100-INITIALIZE                                                *02260000
      *                                                                *02270000
      *     1. RESET DB2 ERROR HANDLERS                                *02280000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02290000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02300000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02310000
      *                                                                *02320000
      ******************************************************************02330000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              02370000
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              02380000
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              02390000
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     02410000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     02430000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         02440000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      02460000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02480000
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     02490000
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      02500000
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      02510000
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        02520000
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            02530000
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            02540000
CVT999*    END-IF.                                                      02550000
                                                                        
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-DATE-COMP            TO PARM-DATE-COMP           . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02130_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02130_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,TAX_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,TAX_ELEC CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,TAX_GAS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                 
CVT000        ,TAX_MDSE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,TAX_WATER CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,TAX_SEWER CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,TAX_TRASH CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,TAX_RATE                 DECIMAL(01,1)                   
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************02600000
      * 1000-PROCESS-INPUT                                             *02610000
      *                                                                *02620000
      *     1. RECEIVE PARMS.                                          *02630000
      *                                                                *02640000
      ******************************************************************02650000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 02740000
      *   1100-RECEIVE-PARMS                                          * 02750000
      ***************************************************************** 02760000
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                              TO PARM-ID1.             02800000
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO      TO MAX-LENGTH-PARM,      02810000
CVT999*                                                                 02820000
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02830000
CVT999*                          GWL-RC,                                02840000
CVT999*                          PARM-ID1,                              02850000
CVT999*                          PARM-PREMISE-NO,                       02860000
CVT999*                          TDSCHAR,                               02870000
CVT999*                          MAX-LENGTH-PARM,                       02880000
CVT999*                          PARM-L.                                02890000
                                                                        
CVT999*    ADD 1                                  TO PARM-ID1.          02910000
CVT999*    MOVE LENGTH OF PARM-DATE-COMP          TO MAX-LENGTH-PARM,   02920000
CVT999*                                                                 02930000
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02940000
CVT999*                          GWL-RC,                                02950000
CVT999*                          PARM-ID1,                              02960000
CVT999*                          PARM-DATE-COMP,                        02970000
CVT999*                          TDSCHAR,                               02980000
CVT999*                          MAX-LENGTH-PARM,                       02990000
CVT999*                          PARM-L.                                03000000
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      03050000
      *   2000-PROCESS-OUTPUT                                    *      03060000
      *                                                          *      03070000
      *   1. DESCRIBE RESULT SET                                 *      03080000
      *   2. RETRIEVE DB2 DATA                                   *      03090000
      *   3. BUILD RESULT SET                                    *      03100000
      *   4. SEND RESULT SET                                     *      03110000
      *                                                          *      03120000
      ************************************************************      03130000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            PERFORM 2100-DESCRIBE-RESULT    THRU 2100-EXIT.             
            PERFORM 2300-BUILD-RESULT       THRU 2300-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************     03230000
      *   2100-DESCRIBE-RESULT                                    *     03240000
      *                                                           *     03250000
      *       DESCRIBE EACH COLUMN IN THE RESULT SET.             *     03260000
      *                                                           *     03270000
      *************************************************************     03280000
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
      *------DESCRIBE RETURN CODE ---------->                           03320000
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                  03340000
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                03350000
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              03360000
CVT999*    MOVE LENGTH OF RS-RETURN-CODE    TO WRKLEN1.                 03370000
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                03380000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03400000
CVT999*                          GWL-RC,                                03410000
CVT999*                          CTR-COLUMN,                            03420000
CVT999*                          DB-HOST-TYPE,                          03430000
CVT999*                          WRKLEN1,                               03440000
CVT999*                          RS-RETURN-CODE,                        03450000
CVT999*                          DB-NULL-INDICATOR,                     03460000
CVT999*                          TDS-FALSE,                             03470000
CVT999*                          DB-CLIENT-TYPE,                        03480000
CVT999*                          WRKLEN1,                               03490000
CVT999*                          CNS-RETURN-CODE,                       03500000
CVT999*                          WRKLEN2.                               03510000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03530000
                                                                        
      *------DESCRIBE TAX TYPE    ---------->                           03550000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  03570000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                03580000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              03590000
CVT999*    MOVE LENGTH OF RS-TAX-TYPE       TO WRKLEN1.                 03600000
CVT999*    MOVE LENGTH OF CNS-TAX-TYPE      TO WRKLEN2.                 03610000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03630000
CVT999*                          GWL-RC,                                03640000
CVT999*                          CTR-COLUMN,                            03650000
CVT999*                          DB-HOST-TYPE,                          03660000
CVT999*                          WRKLEN1,                               03670000
CVT999*                          RS-TAX-TYPE,                           03680000
CVT999*                          DB-NULL-INDICATOR,                     03690000
CVT999*                          TDS-FALSE,                             03700000
CVT999*                          DB-CLIENT-TYPE,                        03710000
CVT999*                          WRKLEN1,                               03720000
CVT999*                          CNS-TAX-TYPE,                          03730000
CVT999*                          WRKLEN2.                               03740000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03760000
                                                                        
                                                                        
      *------DESCRIBE TAX ELEC    ---------->                           03790000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  03810000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                03820000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              03830000
CVT999*    MOVE LENGTH OF RS-TAX-ELEC       TO WRKLEN1.                 03840000
CVT999*    MOVE LENGTH OF CNS-TAX-ELEC      TO WRKLEN2.                 03850000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03870000
CVT999*                          GWL-RC,                                03880000
CVT999*                          CTR-COLUMN,                            03890000
CVT999*                          DB-HOST-TYPE,                          03900000
CVT999*                          WRKLEN1,                               03910000
CVT999*                          RS-TAX-ELEC,                           03920000
CVT999*                          DB-NULL-INDICATOR,                     03930000
CVT999*                          TDS-FALSE,                             03940000
CVT999*                          DB-CLIENT-TYPE,                        03950000
CVT999*                          WRKLEN1,                               03960000
CVT999*                          CNS-TAX-ELEC,                          03970000
CVT999*                          WRKLEN2.                               03980000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04000000
                                                                        
                                                                        
      *------DESCRIBE TAX GAS     ---------->                           04030000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  04050000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                04060000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              04070000
CVT999*    MOVE LENGTH OF RS-TAX-GAS        TO WRKLEN1.                 04080000
CVT999*    MOVE LENGTH OF CNS-TAX-GAS       TO WRKLEN2.                 04090000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              04110000
CVT999*                          GWL-RC,                                04120000
CVT999*                          CTR-COLUMN,                            04130000
CVT999*                          DB-HOST-TYPE,                          04140000
CVT999*                          WRKLEN1,                               04150000
CVT999*                          RS-TAX-GAS,                            04160000
CVT999*                          DB-NULL-INDICATOR,                     04170000
CVT999*                          TDS-FALSE,                             04180000
CVT999*                          DB-CLIENT-TYPE,                        04190000
CVT999*                          WRKLEN1,                               04200000
CVT999*                          CNS-TAX-GAS,                           04210000
CVT999*                          WRKLEN2.                               04220000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04240000
                                                                        
                                                                        
      *------DESCRIBE TAX MDSE    ---------->                           04270000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  04290000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                04300000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              04310000
CVT999*    MOVE LENGTH OF RS-TAX-MDSE       TO WRKLEN1.                 04320000
CVT999*    MOVE LENGTH OF CNS-TAX-MDSE      TO WRKLEN2.                 04330000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              04350000
CVT999*                          GWL-RC,                                04360000
CVT999*                          CTR-COLUMN,                            04370000
CVT999*                          DB-HOST-TYPE,                          04380000
CVT999*                          WRKLEN1,                               04390000
CVT999*                          RS-TAX-MDSE,                           04400000
CVT999*                          DB-NULL-INDICATOR,                     04410000
CVT999*                          TDS-FALSE,                             04420000
CVT999*                          DB-CLIENT-TYPE,                        04430000
CVT999*                          WRKLEN1,                               04440000
CVT999*                          CNS-TAX-MDSE,                          04450000
CVT999*                          WRKLEN2.                               04460000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04480000
                                                                        
                                                                        
      *------DESCRIBE TAX WATER   ---------->                           04510000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  04530000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                04540000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              04550000
CVT999*    MOVE LENGTH OF RS-TAX-WATER      TO WRKLEN1.                 04560000
CVT999*    MOVE LENGTH OF CNS-TAX-WATER     TO WRKLEN2.                 04570000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              04590000
CVT999*                          GWL-RC,                                04600000
CVT999*                          CTR-COLUMN,                            04610000
CVT999*                          DB-HOST-TYPE,                          04620000
CVT999*                          WRKLEN1,                               04630000
CVT999*                          RS-TAX-WATER,                          04640000
CVT999*                          DB-NULL-INDICATOR,                     04650000
CVT999*                          TDS-FALSE,                             04660000
CVT999*                          DB-CLIENT-TYPE,                        04670000
CVT999*                          WRKLEN1,                               04680000
CVT999*                          CNS-TAX-WATER,                         04690000
CVT999*                          WRKLEN2.                               04700000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04720000
                                                                        
                                                                        
      *------DESCRIBE TAX SEWER   ---------->                           04750000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  04770000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                04780000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              04790000
CVT999*    MOVE LENGTH OF RS-TAX-SEWER      TO WRKLEN1.                 04800000
CVT999*    MOVE LENGTH OF CNS-TAX-SEWER     TO WRKLEN2.                 04810000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              04830000
CVT999*                          GWL-RC,                                04840000
CVT999*                          CTR-COLUMN,                            04850000
CVT999*                          DB-HOST-TYPE,                          04860000
CVT999*                          WRKLEN1,                               04870000
CVT999*                          RS-TAX-SEWER,                          04880000
CVT999*                          DB-NULL-INDICATOR,                     04890000
CVT999*                          TDS-FALSE,                             04900000
CVT999*                          DB-CLIENT-TYPE,                        04910000
CVT999*                          WRKLEN1,                               04920000
CVT999*                          CNS-TAX-SEWER,                         04930000
CVT999*                          WRKLEN2.                               04940000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04960000
                                                                        
      *------DESCRIBE TAX TRASH   ---------->                           04980000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  05000000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05010000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05020000
CVT999*    MOVE LENGTH OF RS-TAX-TRASH      TO WRKLEN1.                 05030000
CVT999*    MOVE LENGTH OF CNS-TAX-TRASH     TO WRKLEN2.                 05040000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              05060000
CVT999*                          GWL-RC,                                05070000
CVT999*                          CTR-COLUMN,                            05080000
CVT999*                          DB-HOST-TYPE,                          05090000
CVT999*                          WRKLEN1,                               05100000
CVT999*                          RS-TAX-TRASH,                          05110000
CVT999*                          DB-NULL-INDICATOR,                     05120000
CVT999*                          TDS-FALSE,                             05130000
CVT999*                          DB-CLIENT-TYPE,                        05140000
CVT999*                          WRKLEN1,                               05150000
CVT999*                          CNS-TAX-TRASH,                         05160000
CVT999*                          WRKLEN2.                               05170000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05190000
                                                                        
      *------DESCRIBE TAX RATE    ---------->                           05210000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  05230000
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             05240000
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           05250000
CVT999*    MOVE LENGTH OF RS-TAX-RATE       TO WRKLEN1.                 05260000
CVT999*    MOVE LENGTH OF CNS-TAX-RATE      TO WRKLEN2.                 05270000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              05290000
CVT999*                          GWL-RC,                                05300000
CVT999*                          CTR-COLUMN,                            05310000
CVT999*                          DB-HOST-TYPE,                          05320000
CVT999*                          WRKLEN1,                               05330000
CVT999*                          RS-TAX-RATE,                           05340000
CVT999*                          DB-NULL-INDICATOR,                     05350000
CVT999*                          TDS-FALSE,                             05360000
CVT999*                          DB-CLIENT-TYPE,                        05370000
CVT999*                          WRKLEN1,                               05380000
CVT999*                          CNS-TAX-RATE,                          05390000
CVT999*                          WRKLEN2.                               05400000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05420000
                                                                        
CVT999*    MOVE +4 TO WRKLEN2.                                          05440000
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              05450000
CVT999*                          GWL-RC,                                05460000
CVT999*                          TDS-OBJECT-COL,                        05470000
CVT999*                          CTR-COLUMN,                            05480000
CVT999*                          WRKLEN1,                               05490000
CVT999*                          WRKLEN2.                               05500000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05520000
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05570000
      *   2300-BUILD-RESULT.                                           *05580000
      *                                                                *05590000
      *   1.   SELECT REVENUE DISTRICT CODE FROM CSS_PREMISE.          *05600000
      *   2.   FETCH AND SEND TAX RATES.                               *05610000
      *                                                                *05620000
      ******************************************************************05630000
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE WS-PREMISE-NO-NUM          TO WS-PREMISE-NO.            
           MOVE PARM-DATE-COMP             TO WS-COMP-DATE.             
           PERFORM 7000-SELECT-REV-DIST    THRU 7000-EXIT.              
           PERFORM 7100-OPEN-TAX-CURSOR    THRU 7100-EXIT.              
           PERFORM 7200-FETCH-TAX-RATES    THRU 7200-EXIT.              
           PERFORM 5000-PROCESS-FETCH-TAX  THRU 5000-EXIT               
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7300-CLOSE-TAX-CURSOR   THRU 7300-EXIT.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05790000
      *   5000-PROCESS-FETCH-TAX                                       *05800000
      *                                                                *05810000
      *   1.   FETCH AND SEND TAX RATES.                               *05820000
      *                                                                *05830000
      ******************************************************************05840000
                                                                        
       5000-PROCESS-FETCH-TAX.                                          
                                                                        
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 7200-FETCH-TAX-RATES    THRU 7200-EXIT.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************05950000
      * 7000-SELECT-REV-DIST.                                          *05960000
      ******************************************************************05970000
                                                                        
       7000-SELECT-REV-DIST.                                            
                                                                        
           EXEC SQL                                                     
               SELECT REV_DISTRICT_CD                                   
               INTO   :WS-REV-DIST-CD                                   
               FROM   CSS_PREMISE WITH(READUNCOMMITTED)                         
               WHERE  PREMISE_NO = :WS-PREMISE-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06010000
MFA-TR*        SELECT REV_DISTRICT_CD                                   06020000
MFA-TR*        INTO   :WS-REV-DIST-CD                                   06030000
MFA-TR*        FROM   CSS_PREMISE                                       06040000
MFA-TR*        WHERE  PREMISE_NO = :WS-PREMISE-NO                       06050000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06260000
      * 7100-OPEN-TAX-CURSOR.                                          *06270000
      ******************************************************************06280000
                                                                        
       7100-OPEN-TAX-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN TAX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_TAX_CNTL'       TO TABLE-1                      
              MOVE 'CSS_TAX_RATE'       TO TABLE-2                      
              MOVE 'CSS_TAX_USE_CNTL'   TO TABLE-3                      
CBSI          MOVE 'DETAIL_ID'          TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_FROM'          TO TABLE-ELEMENT-2              
CBSI          MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE WS-REV-DIST-CD       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-COMP-DATE         TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06560000
      * 7200-FETCH-TAX-RATES                                           *06570000
      ******************************************************************06580000
                                                                        
       7200-FETCH-TAX-RATES.                                            
                                                                        
           EXEC SQL                                                     
               FETCH TAX-CURSOR                                         
               INTO  :RS-TAX-TYPE,                                      
                     :RS-TAX-ELEC,                                      
                     :RS-TAX-GAS,                                       
                     :RS-TAX-MDSE,                                      
                     :RS-TAX-WATER,                                     
                     :RS-TAX-SEWER,                                     
                     :RS-TAX-TRASH,                                     
                     :RS-TAX-RATE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_TAX_CNTL'       TO TABLE-1                      
              MOVE 'CSS_TAX_RATE'       TO TABLE-2                      
              MOVE 'CSS_TAX_USE_CNTL'   TO TABLE-3                      
CBSI          MOVE 'DETAIL_ID'          TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_FROM'          TO TABLE-ELEMENT-2              
CBSI          MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE WS-REV-DIST-CD       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-COMP-DATE         TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06940000
      * 7300-CLOSE-TAX-CURSOR                                          *06950000
      ******************************************************************06960000
                                                                        
       7300-CLOSE-TAX-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE TAX-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_TAX_CNTL'       TO TABLE-1                      
              MOVE 'CSS_TAX_RATE'       TO TABLE-2                      
              MOVE 'CSS_TAX_USE_CNTL'   TO TABLE-3                      
CBSI          MOVE 'DETAIL_ID'          TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_FROM'          TO TABLE-ELEMENT-2              
CBSI          MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE WS-REV-DIST-CD       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-COMP-DATE         TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07240000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07250000
      ******************************************************************07260000
           EXEC SQL                                                     07270000
              INCLUDE CPDSP300                                          07280000
           END-EXEC.                                                    07290000
                                                                        
      ******************************************************************07310000
      *       END PROGRAM COPYLIB                                      *07320000
      ******************************************************************07330000
CVT999*    COPY CPD00302.                                               07340000
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02130_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,TAX_TYPE                                                  
CVT000       ,TAX_ELEC                                                  
CVT000       ,TAX_GAS                                                   
CVT000       ,TAX_MDSE                                                  
CVT000       ,TAX_WATER                                                 
CVT000       ,TAX_SEWER                                                 
CVT000       ,TAX_TRASH                                                 
CVT000       ,TAX_RATE                                                  
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-TAX-TYPE                                              
CVT000       ,:RS-TAX-ELEC                                              
CVT000       ,:RS-TAX-GAS                                               
CVT000       ,:RS-TAX-MDSE                                              
CVT000       ,:RS-TAX-WATER                                             
CVT000       ,:RS-TAX-SEWER                                             
CVT000       ,:RS-TAX-TRASH                                             
CVT000       ,:RS-TAX-RATE                                              
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02130_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TAX_TYPE                                                          
MFA-TR*      ,TAX_ELEC                                                          
MFA-TR*      ,TAX_GAS                                                           
MFA-TR*      ,TAX_MDSE                                                          
MFA-TR*      ,TAX_WATER                                                         
MFA-TR*      ,TAX_SEWER                                                         
MFA-TR*      ,TAX_TRASH                                                         
MFA-TR*      ,TAX_RATE                                                          
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-TAX-TYPE                                                      
MFA-TR*      ,:RS-TAX-ELEC                                                      
MFA-TR*      ,:RS-TAX-GAS                                                       
MFA-TR*      ,:RS-TAX-MDSE                                                      
MFA-TR*      ,:RS-TAX-WATER                                                     
MFA-TR*      ,:RS-TAX-SEWER                                                     
MFA-TR*      ,:RS-TAX-TRASH                                                     
MFA-TR*      ,:RS-TAX-RATE                                                      
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02130_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02130_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02130_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
