       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02125.                                         
COB303 DATE-WRITTEN.     JUNE 14, 1995.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S125                                           *        
      *  PROGRAM:       S125                                           *        
      *  CALLING SP:    PN_S125                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              *        
      * DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        *        
      *                                                                *        
      * THIS PROGRAM PERFORMS REGISTER VALIDATIONS, RETURNING VALID    *        
      * REGISTER INFORMATION FOR A GIVEN PROGRAM ID.                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/14/95    JHR      CREATED.                                 *        
      *  02/26/95    JHR      ADDED ORDER BY CLAUSE TO T3 CURSOR PER   *        
      *                       TPR #3345.                               *        
      *  03/25/95    JHR      CHANGED THE RETURN OF THE REGISTER'S     *        
      *                       USAGE SOURCE FOR TIME-OF-USE METERS PER  *        
      *                       TPR #3605.                               *        
      *  02/10/97    DB       FOR TOU METER DO NOT CREATE A 0 TIME     *        
      *                       TIME PERIOD FOR REGISTERS WITH REG_ID_NO *        
      *                       GREATER THAN 1.                          *        
CBSI  *  08/10/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T22243*  07/25/00    CBSI     CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*              MADRAS   IN METER INVENTORY TABLES.               *        
T23539*  05/10/01    RR       PASSING COMPANY_NO TO RPC FOR MULTI-     *        
T23539*                       COMPANY.  REPLACES HARD-CODED '01' FOR   *        
T23539*                       WS-DEFAULT-COMPANY-NO                    *        
T25422*  10/16/01    MJG      CHANGE THE DMT CURSOR TO ONLY BRING BACK *        
T25422*                       VALID ROWS BY ADDING THE CNSMPTN_READ_FL *        
T25422*                       COLUMN TO THE CURSOR.   IN ADDITION I    *        
T25422*                       2500- TO HANDLE CCF AND KWH ONE WAY AND  *        
T25422*                       ALL OTHER VALID CAPABILITIES THE 2ND WAY *        
C26121*  08/13/02    SR82046  CHANGED TO GET THE REGISTER INFORMATION  *        
C26121*                       BASED IN PROGRAM ID.                     *        
P00251*  02/11/10    MSR      REPLACE CSS_DMT_PGM_ID_CAP TABLE WITH    *        
P00251*                       CSS_MTR_RD_FMT TABLE.                    *        
A04527*  06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.         *        
A05317*  10/15/15    FMB      RETURN FIELDS FOR CLICK.                 *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02125'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S125 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
P00251                                                                  
P00251     EXEC SQL                                                             
P00251        INCLUDE TBRDFMT                                                   
P00251     END-EXEC.                                                            
P00251                                                                  
P00251     EXEC SQL                                                             
P00251        INCLUDE TBMTRPGM                                                  
P00251     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S125    '.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CODE-UTIL-TYPE     PIC X(01)      VALUE SPACES.     
           05  PARM-METER-NO           PIC X(09)      VALUE SPACES.     
           05  PARM-DIGTL-MTR-TYPE     PIC X(03)      VALUE SPACES.     
           05  PARM-PROGRAM-ID         PIC X(02)      VALUE SPACES.     
           05  PARM-RATE-PLAN-NO       PIC X(03)      VALUE SPACES.     
T23539     05  PARM-COMPANY-NO         PIC X(02)      VALUE SPACES.     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-METER-CAP-TYPE.                                           
           05  WS-KWH-CCF              PIC X(01) VALUE 'A'.             
           05  WS-KW-UNCOR-GAL         PIC X(01) VALUE 'B'.             
           05  WS-KVAR                 PIC X(01) VALUE 'C'.             
           05  WS-QHR                  PIC X(01) VALUE 'D'.             
           05  WS-KVA-MNLN             PIC X(01) VALUE 'E'.             
           05  WS-PRI-BYPS             PIC X(01) VALUE 'F'.             
           05  WS-SEC-BYPS             PIC X(01) VALUE 'G'.             
                                                                        
       01  WS-USAGE-SOURCE.                                             
           05  WS-PRIMARY              PIC X(01) VALUE 'B'.             
           05  WS-COMBINED             PIC X(01) VALUE 'C'.             
           05  WS-DEMAND               PIC X(01) VALUE 'D'.             
                                                                        
       01  WS-TOU-DETERMINATION.                                        
           05  WS-TOU-IND                 PIC X(01) VALUE 'N'.          
           05  WS-CMPNT-ID-CD             PIC X(02) VALUE '10'.         
           05  WS-MAX-VERS-NO-CNTRL       PIC S9(4) USAGE COMP.         
           05  WS-MAX-VERS-NO-CNTRL-NULL  PIC S9(4) USAGE COMP.         
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-ELEC-UTIL            PIC X(01) VALUE 'E'.             
           05  WS-DATA-ERROR-FLAG      PIC X(03)      VALUE SPACES.     
           05  WS-YES                  PIC X(03)      VALUE 'YES'.      
T25422     05  WS-Y                    PIC X(01)      VALUE 'Y'.        
           05  WS-PGM-CAP-COUNTER      PIC S9(4) COMP VALUE 0.          
           05  WS-MTR-CAP-COUNTER      PIC S9(4) COMP VALUE 0.          
           05  WS-TOU-COUNTER          PIC S9(4) COMP VALUE 0.          
T22243     05  WS-DEFAULT-COMPANY-NO   PIC X(02)      VALUE SPACES.     
T23539                                                                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-TIME-PERIOD          PIC S9(4) COMP VALUE 0.          
           05  RS-REG-ID-NO            PIC S9(4) COMP VALUE 0.          
           05  RS-CONSTANT             PIC S9(6)V9(3) COMP-3 VALUE 0.   
           05  RS-NO-DIALS             PIC S9(4) COMP VALUE 0.          
           05  RS-CODE-CAP-TYPE        PIC X(01)      VALUE SPACES.     
           05  RS-CODE-USAGE-SOURCE    PIC X(01)      VALUE SPACES.     
P00251     05  RS-CODE-USAGE-TYPE      PIC X(01)      VALUE SPACES.     
P00251     05  RS-CODE-USAGE-ID        PIC X(01)      VALUE SPACES.     
A05317     05  RS-READ-SEQUENCE-NO     PIC S9(4) COMP VALUE ZEROES.     
A05317     05  RS-MTR-RD-DISP-CD       PIC X(03)      VALUE SPACES.     
A05317     05  RS-INDEX-VALUE-CD       PIC X(01)      VALUE SPACES.     
A05317     05  RS-NO-READ-DIGITS       PIC S9(4) COMP VALUE ZEROES.     
A05317     05  RS-NO-READ-DECIMALS     PIC S9(4) COMP VALUE ZEROES.     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
P00251* CSS_MTR_RD_FMT CURSOR.                                                  
P00251*                                                                         
P00251     EXEC SQL DECLARE OA-PGM-CAP-CURSOR CURSOR FOR                
P00251        SELECT CODE_CAP_TYPE,                                     
P00251               CODE_USAGE_SOURCE,                                 
P00251               REG_ID_NO,                                         
P00251               CODE_TIME_PERIOD,                                  
P00251               CODE_USAGE_TYPE,                                   
P00251               CODE_USAGE_ID,                                     
A05317               READ_SEQUENCE_NO,                                  
A05317               MTR_RD_DISP_CD,                                    
A05317               INDEX_VALUE_CD,                                    
A05317               NO_READ_DIGITS,                                    
A05317               NO_READ_DECIMALS                                   
P00251          FROM CSS_MTR_RD_FMT OA WITH(READUNCOMMITTED)                    
P00251         WHERE CODE_UTIL_TYPE  = :OA-CODE-UTIL-TYPE               
P00251           AND DIGTL_MTR_TYPE  = :OA-DIGTL-MTR-TYPE               
P00251           AND PROGRAM_ID      = :OA-PROGRAM-ID                   
P00251           AND REMOTE_READ_IND = :O8-DFLT-REMOTE-RD-IND           
P00251           AND MTR_READ_SOURCE_CD = :O8-DEF-RD-SOURCE-CD          
P00251           AND CNSMPTN_READ_FL = 'Y'                              
P00251           AND SO_REGISTER_CD <> 'I'                              
P00251           AND CODE_TOU_SEASN = 'C'                               
P00251         ORDER BY REG_ID_NO ASC, CODE_TIME_PERIOD ASC             
P00251         FOR READ ONLY                                           
P00251                                                           
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE OA-PGM-CAP-CURSOR CURSOR FOR                        
MFA-TR*       SELECT CODE_CAP_TYPE,                                             
MFA-TR*              CODE_USAGE_SOURCE,                                         
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              CODE_USAGE_TYPE,                                           
MFA-TR*              CODE_USAGE_ID,                                             
MFA-TR*              READ_SEQUENCE_NO,                                          
MFA-TR*              MTR_RD_DISP_CD,                                            
MFA-TR*              INDEX_VALUE_CD,                                            
MFA-TR*              NO_READ_DIGITS,                                            
MFA-TR*              NO_READ_DECIMALS                                           
MFA-TR*         FROM CSS_MTR_RD_FMT OA                                          
MFA-TR*        WHERE CODE_UTIL_TYPE  = :OA-CODE-UTIL-TYPE                       
MFA-TR*          AND DIGTL_MTR_TYPE  = :OA-DIGTL-MTR-TYPE                       
MFA-TR*          AND PROGRAM_ID      = :OA-PROGRAM-ID                           
MFA-TR*          AND REMOTE_READ_IND = :O8-DFLT-REMOTE-RD-IND                   
MFA-TR*          AND MTR_READ_SOURCE_CD = :O8-DEF-RD-SOURCE-CD                  
MFA-TR*          AND CNSMPTN_READ_FL = 'Y'                                      
MFA-TR*          AND SO_REGISTER_CD <> 'I'                                      
MFA-TR*          AND CODE_TOU_SEASN = 'C'                                       
MFA-TR*        ORDER BY REG_ID_NO ASC, CODE_TIME_PERIOD ASC                     
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            
P00251*                                                                         
      * CSS_MTR_CAP CURSOR.                                                     
                                                                        
           EXEC SQL DECLARE MC-MTR-CAP-CURSOR CURSOR FOR                
              SELECT CONSTANT,                                          
                     NO_READ_DIALS                                      
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
T22243         WHERE COMPANY_NO     = :MC-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                
                 AND METER_NO       = :MC-METER-NO                      
                 AND CODE_CAP_TYPE  = :MC-CODE-CAP-TYPE                 
P00251           AND REG_ID_NO      = :MC-REG-ID-NO                     
P00251           FOR READ ONLY                                         
P00251                                                           
P00251                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MC-MTR-CAP-CURSOR CURSOR FOR                        
MFA-TR*       SELECT CONSTANT,                                                  
MFA-TR*              NO_READ_DIALS                                              
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*        WHERE COMPANY_NO     = :MC-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :MC-METER-NO                              
MFA-TR*          AND CODE_CAP_TYPE  = :MC-CODE-CAP-TYPE                         
MFA-TR*          AND REG_ID_NO      = :MC-REG-ID-NO                             
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7550                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000*REARCH - CHANGE THE FOLLOWING CURSOR TO RETURN ALL REQD FLDS     00001800
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
CVT000              RETURN_CODE                                         
CVT000             ,TIME_PERIOD                                         
CVT000             ,REG_ID_NO                                           
CVT000             ,CONSTANT                                            
CVT000             ,NO_DIALS                                            
CVT000             ,CODE_CAP_TYPE                                       
CVT000             ,CODE_USAGE_SOURCE                                   
CVT000             ,0   AS LAST_READ_VALUE                              
CVT000             ,0   AS READ_VALUE_IS                                
CVT000             ,' ' AS CODE_STATUS_IS                               
CVT000             ,' ' AS CODE_STATUS_REA_IS                           
P00251             ,CODE_USAGE_TYPE                                     
P00251             ,CODE_USAGE_ID                                       
CVT000             ,' ' AS CODE_REG_STATUS_WS                           
CVT000             ,' ' AS CODE_STATUS_REA_WS                           
CVT000             ,CAST(SYSDATETIMEOFFSET() AS DATE) AS 
           LAST_REG_READ_DATE                  
CVT000             ,'                                   '               
CVT000                          AS REGISTER_USAGE                       
A05317             ,READ_SEQUENCE_NO                                    
A05317             ,MTR_RD_DISP_CD                                      
A05317             ,INDEX_VALUE_CD                                      
A05317             ,NO_READ_DIGITS                                      
A05317             ,NO_READ_DECIMALS                                    
CVT000         FROM #CSR02125_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,TIME_PERIOD                                                 
MFA-TR*            ,REG_ID_NO                                                   
MFA-TR*            ,CONSTANT                                                    
MFA-TR*            ,NO_DIALS                                                    
MFA-TR*            ,CODE_CAP_TYPE                                               
MFA-TR*            ,CODE_USAGE_SOURCE                                           
MFA-TR*            ,0   AS LAST_READ_VALUE                                      
MFA-TR*            ,0   AS READ_VALUE_IS                                        
MFA-TR*            ,' ' AS CODE_STATUS_IS                                       
MFA-TR*            ,' ' AS CODE_STATUS_REA_IS                                   
MFA-TR*            ,CODE_USAGE_TYPE                                             
MFA-TR*            ,CODE_USAGE_ID                                               
MFA-TR*            ,' ' AS CODE_REG_STATUS_WS                                   
MFA-TR*            ,' ' AS CODE_STATUS_REA_WS                                   
MFA-TR*            ,CURRENT DATE AS LAST_REG_READ_DATE                          
MFA-TR*            ,'                                   '                       
MFA-TR*                         AS REGISTER_USAGE                               
MFA-TR*            ,READ_SEQUENCE_NO                                            
MFA-TR*            ,MTR_RD_DISP_CD                                              
MFA-TR*            ,INDEX_VALUE_CD                                              
MFA-TR*            ,NO_READ_DIGITS                                              
MFA-TR*            ,NO_READ_DECIMALS                                            
MFA-TR*        FROM SESSION.CSR02125_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-METER-NO            PIC X(09)                .          
CVT000 01  LINK-DIGTL-MTR-TYPE      PIC X(03)                .          
CVT000 01  LINK-PROGRAM-ID          PIC X(02)                .          
CVT000 01  LINK-RATE-PLAN-NO        PIC X(03)                .          
CVT000 01  LINK-COMPANY-NO          PIC X(02)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-METER-NO                                           
CVT000         ,LINK-DIGTL-MTR-TYPE                                     
CVT000         ,LINK-PROGRAM-ID                                         
CVT000         ,LINK-RATE-PLAN-NO                                       
CVT000         ,LINK-COMPANY-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     RESET DB2 ERROR HANDLERS.                                  *        
      *     ESTABLISH GATEWAY ENVIRONMENT (TDINIT).                    *        
      *     ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT).     *        
      *     DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT).  *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
CVT000     MOVE LINK-DIGTL-MTR-TYPE       TO PARM-DIGTL-MTR-TYPE      . 
CVT000     MOVE LINK-PROGRAM-ID           TO PARM-PROGRAM-ID          . 
CVT000     MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO        . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02125_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02125_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,TIME_PERIOD              SMALLINT                        
CVT000        ,REG_ID_NO                SMALLINT                        
CVT000        ,CONSTANT                 DECIMAL(09,3)                   
CVT000        ,NO_DIALS                 SMALLINT                        
CVT000        ,CODE_CAP_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P00251        ,CODE_USAGE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00251        ,CODE_USAGE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
A05317        ,READ_SEQUENCE_NO         SMALLINT                        
A05317        ,MTR_RD_DISP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
A05317        ,INDEX_VALUE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
A05317        ,NO_READ_DIGITS           SMALLINT                        
A05317        ,NO_READ_DECIMALS         SMALLINT                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
P00251     MOVE PARM-CODE-UTIL-TYPE           TO OA-CODE-UTIL-TYPE      
                                                 MC-CODE-UTIL-TYPE      
                                                 J1-CODE-UTIL-TYPE      
P00251                                           O8-CODE-UTIL-TYPE.     
P00251     MOVE PARM-DIGTL-MTR-TYPE           TO OA-DIGTL-MTR-TYPE      
P00251                                           O8-DIGTL-MTR-TYPE.     
P00251     MOVE PARM-PROGRAM-ID               TO OA-PROGRAM-ID          
P00251                                           O8-PROGRAM-ID.         
           MOVE PARM-METER-NO                 TO MC-METER-NO.           
T23539     MOVE PARM-COMPANY-NO               TO WS-DEFAULT-COMPANY-NO. 
T22243     MOVE WS-DEFAULT-COMPANY-NO         TO MC-COMPANY-NO.         
           MOVE PARM-RATE-PLAN-NO             TO J1-RATE-PLAN-NO.       
           MOVE WS-CMPNT-ID-CD                TO J1-CMPNT-ID-CD.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY: 2000-PROCESS-OUTPUT                             *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
      * PROCESS EACH DIGITAL METER'S PROGRAM ID CAPABILITY ROW.                 
P00251     PERFORM 7200-GET-MTR-PGM-DTLS            THRU 7200-EXIT.     
           PERFORM 7000-OPEN-PGM-CAP-CURSOR         THRU 7000-EXIT.     
                                                                        
           PERFORM 5000-PROCESS-PGM-CAP-CURSOR      THRU 5000-EXIT      
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                 OR WS-DATA-ERROR-FLAG    = WS-YES.                     
                                                                        
           PERFORM 7100-CLOSE-PGM-CAP-CURSOR        THRU 7100-EXIT.     
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2210-SELECT-MAX-VERSION-NO.                                    *        
      *     SELECTS MAXIMUM VERSION CONTROL NO. FROM CSS_RATE_CERATOR  *        
      *                                                                *        
      ******************************************************************        
       2210-SELECT-MAX-VERSION-NO.                                      
                                                                        
           MOVE '2210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
               INTO :WS-MAX-VERS-NO-CNTRL :WS-MAX-VERS-NO-CNTRL-NULL     
               FROM  CSS_RATE_CREATOR                                   
              WHERE  CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                AND  RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
P00251                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                                      
MFA-TR*        INTO :WS-MAX-VERS-NO-CNTRL:WS-MAX-VERS-NO-CNTRL-NULL             
MFA-TR*        FROM  CSS_RATE_CREATOR                                           
MFA-TR*       WHERE  CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                      
MFA-TR*         AND  RATE_PLAN_NO     = :J1-RATE-PLAN-NO                        
MFA-TR*       QUERYNO 2210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-3        
CBSI          MOVE PARM-METER-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2215-SELECT-TOU-PERIODS.                                       *        
      *     DETERMINE THE ENERGY AND DEMAND TIME-OF-USE PERIODS,       *        
      *     AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.                 *        
      *     A NOT-FOUND SQLCODE INDICATES THAT THE RATE IS IDR         *        
      *     (BECAUSE WE USED A COMPONENT ID CODE OF '10' IN THE WHERE  *        
      *     CLAUSE).                                                   *        
      *                                                                *        
      ******************************************************************        
       2215-SELECT-TOU-PERIODS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT A.REG_TYPE_CD,                                     
                     A.DEM_REG_TYPE_CD,                                 
                     A.DEM_UNIT_CD                                      
               INTO  :J1-REG-TYPE-CD,                                   
                     :J1-DEM-REG-TYPE-CD,                               
                     :J1-DEM-UNIT-CD                                    
               FROM  CSS_RATE_COMP_DEF A                                
              WHERE  A.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE          
                AND  A.RATE_PLAN_NO       = :J1-RATE-PLAN-NO            
                AND  A.CMPNT_ID_CD        = :J1-CMPNT-ID-CD             
                AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL       
P00251                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.REG_TYPE_CD,                                             
MFA-TR*              A.DEM_REG_TYPE_CD,                                         
MFA-TR*              A.DEM_UNIT_CD                                              
MFA-TR*        INTO  :J1-REG-TYPE-CD,                                           
MFA-TR*              :J1-DEM-REG-TYPE-CD,                                       
MFA-TR*              :J1-DEM-UNIT-CD                                            
MFA-TR*        FROM  CSS_RATE_COMP_DEF A                                        
MFA-TR*       WHERE  A.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE                  
MFA-TR*         AND  A.RATE_PLAN_NO       = :J1-RATE-PLAN-NO                    
MFA-TR*         AND  A.CMPNT_ID_CD        = :J1-CMPNT-ID-CD                     
MFA-TR*         AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL               
MFA-TR*       QUERYNO 2215                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2215'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE J1-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
CBSI          MOVE WS-MAX-VERS-NO-CNTRL       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5000-PROCESS-PGM-CAP-CURSOR.                                   *        
      *     FETCH EACH DIGITAL METER PROGRAM ID'S CAPABILITY ROW TO    *        
      *     ENSURE IT MATCHES THE METER'S CAPABILITY.                  *        
      *                                                                *        
      *     CALLED BY: 2200-BUILD-RESULT.                              *        
      ******************************************************************        
       5000-PROCESS-PGM-CAP-CURSOR.                                     
                                                                        
      * PROCESS EACH DIGITAL METER PROGRAM CAPABILITY ROW.                      
                                                                        
           PERFORM 7500-FETCH-PGM-CAP-CURSOR        THRU 7500-EXIT.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                          TO WS-PGM-CAP-COUNTER     
P00251        MOVE OA-CODE-CAP-TYPE           TO MC-CODE-CAP-TYPE       
P00251        MOVE OA-REG-ID-NO               TO MC-REG-ID-NO           
                                                                        
              PERFORM 7050-OPEN-MTR-CAP-CURSOR      THRU 7050-EXIT      
                                                                        
              PERFORM 5100-PROCESS-MTR-CAP-CURSOR   THRU 5100-EXIT      
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                    OR WS-DATA-ERROR-FLAG    = WS-YES                   
                                                                        
              MOVE 0                          TO WS-MTR-CAP-COUNTER     
                                                                        
              PERFORM 7150-CLOSE-MTR-CAP-CURSOR     THRU 7150-EXIT      
                                                                        
           ELSE                                                         
              IF WS-PGM-CAP-COUNTER > 0                                 
                 NEXT SENTENCE                                          
              ELSE                                                      
      *          AT LEAST 1 PROGRAM CAPABILITY ROW SHOULD HAVE EXISTED.         
                 MOVE WS-YES                  TO WS-DATA-ERROR-FLAG     
                 MOVE 0                       TO RS-REG-ID-NO           
                 MOVE 0                       TO RS-TIME-PERIOD         
                 MOVE 0                       TO RS-CONSTANT            
                 MOVE 0                       TO RS-NO-DIALS            
                 MOVE SPACES                  TO RS-CODE-CAP-TYPE       
                 MOVE SPACES                  TO RS-CODE-USAGE-SOURCE   
P00251           MOVE SPACES                  TO RS-CODE-USAGE-TYPE     
P00251           MOVE SPACES                  TO RS-CODE-USAGE-ID       
A05317           MOVE 0                       TO RS-READ-SEQUENCE-NO    
A05317           MOVE SPACES                  TO RS-MTR-RD-DISP-CD      
A05317           MOVE SPACES                  TO RS-INDEX-VALUE-CD      
A05317           MOVE 0                       TO RS-NO-READ-DIGITS      
A05317           MOVE 0                       TO RS-NO-READ-DECIMALS    
                 PERFORM 8100-SEND-RESULT           THRU 8100-EXIT      
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-PROCESS-MTR-CAP-CURSOR.                                   *        
      *     FETCH AND SEND EACH OF THE METER'S CAPABILITIES ROWS.      *        
      *     IF, BASED ON THE TOU_RATE_SW_IND AND THE NUMBER OF METER   *        
      *     CAPABILITIES ROWS, THERE IS A MISMATCH, HALT PROCESSING.   *        
      *                                                                *        
      *     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
      ******************************************************************        
       5100-PROCESS-MTR-CAP-CURSOR.                                     
                                                                        
      * PROCESS EACH METER CAPABILITY ROW.                                      
                                                                        
           PERFORM 7550-FETCH-MTR-CAP-CURSOR     THRU 7550-EXIT.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                             TO WS-MTR-CAP-COUNTER  
                                                                        
              IF WS-MTR-CAP-COUNTER = 1                                 
P00251           MOVE OA-REG-ID-NO         TO RS-REG-ID-NO              
P00251           MOVE MC-CONSTANT          TO RS-CONSTANT               
P00251           MOVE MC-NO-READ-DIALS     TO RS-NO-DIALS               
P00251           MOVE MC-CODE-CAP-TYPE     TO RS-CODE-CAP-TYPE          
P00251           MOVE OA-CODE-USAGE-SOURCE TO RS-CODE-USAGE-SOURCE      
P00251           MOVE OA-CODE-TIME-PERIOD  TO RS-TIME-PERIOD            
P00251           MOVE OA-CODE-USAGE-TYPE   TO RS-CODE-USAGE-TYPE        
P00251           MOVE OA-CODE-USAGE-ID     TO RS-CODE-USAGE-ID          
A05317           MOVE OA-READ-SEQUENCE-NO  TO RS-READ-SEQUENCE-NO       
A05317           MOVE OA-MTR-RD-DISP-CD    TO RS-MTR-RD-DISP-CD         
A05317           MOVE OA-INDEX-VALUE-CD    TO RS-INDEX-VALUE-CD         
A05317           MOVE OA-NO-READ-DIGITS    TO RS-NO-READ-DIGITS         
A05317           MOVE OA-NO-READ-DECIMALS  TO RS-NO-READ-DECIMALS       
A05317           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT     
              ELSE                                                      
      *          ONLY ONE METER CAPABILITY ROW SHOULD HAVE EXISTED.             
                 MOVE WS-YES                  TO WS-DATA-ERROR-FLAG     
                 MOVE 0                       TO RS-REG-ID-NO           
                 MOVE 0                       TO RS-TIME-PERIOD         
                 MOVE 0                       TO RS-CONSTANT            
                 MOVE 0                       TO RS-NO-DIALS            
                 MOVE SPACES                  TO RS-CODE-CAP-TYPE       
                 MOVE SPACES                  TO RS-CODE-USAGE-SOURCE   
P00251           MOVE SPACES                  TO RS-CODE-USAGE-TYPE     
P00251           MOVE SPACES                  TO RS-CODE-USAGE-ID       
A05317           MOVE 0                       TO RS-READ-SEQUENCE-NO    
A05317           MOVE SPACES                  TO RS-MTR-RD-DISP-CD      
A05317           MOVE SPACES                  TO RS-INDEX-VALUE-CD      
A05317           MOVE 0                       TO RS-NO-READ-DIGITS      
A05317           MOVE 0                       TO RS-NO-READ-DECIMALS    
                 PERFORM 8100-SEND-RESULT            THRU 8100-EXIT     
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              IF WS-MTR-CAP-COUNTER = +1                                
                 NEXT SENTENCE                                          
              ELSE                                                      
      *          ONLY ONE METER CAPABILITY ROW SHOULD HAVE EXISTED.             
                 MOVE WS-YES                  TO WS-DATA-ERROR-FLAG     
                 MOVE 0                       TO RS-REG-ID-NO           
                 MOVE 0                       TO RS-TIME-PERIOD         
                 MOVE 0                       TO RS-CONSTANT            
                 MOVE 0                       TO RS-NO-DIALS            
                 MOVE SPACES                  TO RS-CODE-CAP-TYPE       
                 MOVE SPACES                  TO RS-CODE-USAGE-SOURCE   
P00251           MOVE SPACES                  TO RS-CODE-USAGE-TYPE     
P00251           MOVE SPACES                  TO RS-CODE-USAGE-ID       
A05317           MOVE 0                       TO RS-READ-SEQUENCE-NO    
A05317           MOVE SPACES                  TO RS-MTR-RD-DISP-CD      
A05317           MOVE SPACES                  TO RS-INDEX-VALUE-CD      
A05317           MOVE 0                       TO RS-NO-READ-DIGITS      
A05317           MOVE 0                       TO RS-NO-READ-DECIMALS    
                 PERFORM 8100-SEND-RESULT            THRU 8100-EXIT     
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-PGM-CAP-CURSOR.                                      *        
      *     OPEN THE DIGITAL METER'S PROGRAM ID CURSOR.                *        
      *                                                                *        
      *     CALLED BY: 2200-BUILD-RESULT.                              *        
      ******************************************************************        
       7000-OPEN-PGM-CAP-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
P00251        OPEN OA-PGM-CAP-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
P00251        MOVE 'CSS_MTR_RD_FMT'           TO TABLE-1                
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00251        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00251        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00251        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-METER-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-OPEN-MTR-CAP-CURSOR.                                      *        
      *     OPEN THE METER'S CAPABILITIES CURSOR.                      *        
      *                                                                *        
      *     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
      ******************************************************************        
       7050-OPEN-MTR-CAP-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN MC-MTR-CAP-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTR_CAP'              TO TABLE-1                
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_CAP_TYPE'            TO TABLE-ELEMENT-3        
T22243        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE MC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE MC-METER-NO                TO HOSTVAR-ELEMENT-2      
CBSI          MOVE MC-CODE-CAP-TYPE           TO HOSTVAR-ELEMENT-3      
T22243        MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-CLOSE-PGM-CAP-CURSOR.                                     *        
      *     CLOSE THE DIGITAL METER'S PROGRAM ID CURSOR.               *        
      *                                                                *        
      *     CALLED BY: 2200-BUILD-RESULT.                              *        
      ******************************************************************        
       7100-CLOSE-PGM-CAP-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
P00251        CLOSE OA-PGM-CAP-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
P00251        MOVE 'CSS_MTR_RD_FMT'           TO TABLE-1                
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00251        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00251        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00251        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-METER-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-CLOSE-MTR-CAP-CURSOR.                                     *        
      *     CLOSE THE METER'S CAPABILITIES CURSOR.                     *        
      *                                                                *        
      *     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
      ******************************************************************        
       7150-CLOSE-MTR-CAP-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE MC-MTR-CAP-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTR_CAP'              TO TABLE-1                
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_CAP_TYPE'            TO TABLE-ELEMENT-3        
T22243        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE MC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE MC-METER-NO                TO HOSTVAR-ELEMENT-2      
CBSI          MOVE MC-CODE-CAP-TYPE           TO HOSTVAR-ELEMENT-3      
T22243        MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00251******************************************************************        
P00251* 7200-GET-MTR-PGM-DTLS.                                         *        
P00251*     GET METER PGM DETAILS.                                     *        
P00251*                                                                *        
P00251*     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
P00251******************************************************************        
P00251 7200-GET-MTR-PGM-DTLS.                                           
P00251                                                                  
P00251     EXEC SQL                                                     
P00251        SELECT DFLT_REMOTE_RD_IND                                 
P00251              ,DEF_RD_SOURCE_CD                                   
P00251          INTO :O8-DFLT-REMOTE-RD-IND                             
P00251              ,:O8-DEF-RD-SOURCE-CD                               
P00251          FROM CSS_METER_PGM WITH(READUNCOMMITTED)                        
P00251         WHERE CODE_UTIL_TYPE = :O8-CODE-UTIL-TYPE                
P00251           AND DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE                
P00251           AND PROGRAM_ID     = :O8-PROGRAM-ID                    
P00251                                                           
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DFLT_REMOTE_RD_IND                                         
MFA-TR*             ,DEF_RD_SOURCE_CD                                           
MFA-TR*         INTO :O8-DFLT-REMOTE-RD-IND                                     
MFA-TR*             ,:O8-DEF-RD-SOURCE-CD                                       
MFA-TR*         FROM CSS_METER_PGM                                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :O8-CODE-UTIL-TYPE                        
MFA-TR*          AND DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE                        
MFA-TR*          AND PROGRAM_ID     = :O8-PROGRAM-ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00251        NEXT SENTENCE                                             
P00251     ELSE                                                         
P00251        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00251        MOVE '7200'                     TO ACTIVE-PARAGRAPH       
P00251        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00251        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00251                                           ABEND-TABLES           
P00251        MOVE 'CSS_METER_PGM'            TO TABLE-1                
P00251        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00251        MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
P00251        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
P00251        MOVE O8-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00251        MOVE O8-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00251        MOVE O8-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
P00251        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00251        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00251     END-IF.                                                      
P00251                                                                  
P00251 7200-EXIT.                                                       
P00251     EXIT.                                                        
P00251                                                                  
      ******************************************************************        
      * 7500-FETCH-PGM-CAP-CURSOR.                                     *        
      *     FETCH THE DIGITAL METER'S PROGRAM ID CAPABILITIES.         *        
      *                                                                *        
      *     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
      ******************************************************************        
       7500-FETCH-PGM-CAP-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
P00251        FETCH OA-PGM-CAP-CURSOR                                   
P00251         INTO :OA-CODE-CAP-TYPE,                                  
P00251              :OA-CODE-USAGE-SOURCE,                              
P00251              :OA-REG-ID-NO,                                      
P00251              :OA-CODE-TIME-PERIOD,                               
P00251              :OA-CODE-USAGE-TYPE,                                
P00251              :OA-CODE-USAGE-ID,                                  
A05317              :OA-READ-SEQUENCE-NO,                               
A05317              :OA-MTR-RD-DISP-CD,                                 
A05317              :OA-INDEX-VALUE-CD,                                 
A05317              :OA-NO-READ-DIGITS,                                 
A05317              :OA-NO-READ-DECIMALS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
P00251        MOVE 'CSS_MTR_RD_FMT '           TO TABLE-1               
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00251        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00251        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00251        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-METER-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-FETCH-MTR-CAP-CURSOR.                                     *        
      *     FETCH THE METER'S CAPABILITIES.                            *        
      *                                                                *        
      *     CALLED BY: 5100-PROCESS-MTR-CAP-CURSOR.                    *        
      ******************************************************************        
       7550-FETCH-MTR-CAP-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH MC-MTR-CAP-CURSOR                                   
               INTO :MC-CONSTANT,                                       
                    :MC-NO-READ-DIALS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7550'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTR_CAP'              TO TABLE-1                
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_CAP_TYPE'            TO TABLE-ELEMENT-3        
P00251        MOVE 'REG_ID_NO'                TO TABLE-ELEMENT-4        
CBSI          MOVE MC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE MC-METER-NO                TO HOSTVAR-ELEMENT-2      
CBSI          MOVE MC-CODE-CAP-TYPE           TO HOSTVAR-ELEMENT-3      
P00251        MOVE MC-REG-ID-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02125_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE,                                              
CVT000        TIME_PERIOD,                                              
CVT000        REG_ID_NO,                                                
CVT000        CONSTANT,                                                 
CVT000        NO_DIALS,                                                 
CVT000        CODE_CAP_TYPE,                                            
CVT000        CODE_USAGE_SOURCE,                                        
P00251        CODE_USAGE_TYPE,                                          
P00251        CODE_USAGE_ID,                                            
A05317        READ_SEQUENCE_NO,                                         
A05317        MTR_RD_DISP_CD,                                           
A05317        INDEX_VALUE_CD,                                           
A05317        NO_READ_DIGITS,                                           
A05317        NO_READ_DECIMALS                                          
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE,                                          
CVT000        :RS-TIME-PERIOD,                                          
CVT000        :RS-REG-ID-NO,                                            
CVT000        :RS-CONSTANT,                                             
CVT000        :RS-NO-DIALS,                                             
CVT000        :RS-CODE-CAP-TYPE,                                        
CVT000        :RS-CODE-USAGE-SOURCE,                                    
P00251        :RS-CODE-USAGE-TYPE,                                      
P00251        :RS-CODE-USAGE-ID,                                        
A05317        :RS-READ-SEQUENCE-NO,                                     
A05317        :RS-MTR-RD-DISP-CD,                                       
A05317        :RS-INDEX-VALUE-CD,                                       
A05317        :RS-NO-READ-DIGITS,                                       
A05317        :RS-NO-READ-DECIMALS                                      
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02125_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       TIME_PERIOD,                                                      
MFA-TR*       REG_ID_NO,                                                        
MFA-TR*       CONSTANT,                                                         
MFA-TR*       NO_DIALS,                                                         
MFA-TR*       CODE_CAP_TYPE,                                                    
MFA-TR*       CODE_USAGE_SOURCE,                                                
MFA-TR*       CODE_USAGE_TYPE,                                                  
MFA-TR*       CODE_USAGE_ID,                                                    
MFA-TR*       READ_SEQUENCE_NO,                                                 
MFA-TR*       MTR_RD_DISP_CD,                                                   
MFA-TR*       INDEX_VALUE_CD,                                                   
MFA-TR*       NO_READ_DIGITS,                                                   
MFA-TR*       NO_READ_DECIMALS                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE,                                                  
MFA-TR*       :RS-TIME-PERIOD,                                                  
MFA-TR*       :RS-REG-ID-NO,                                                    
MFA-TR*       :RS-CONSTANT,                                                     
MFA-TR*       :RS-NO-DIALS,                                                     
MFA-TR*       :RS-CODE-CAP-TYPE,                                                
MFA-TR*       :RS-CODE-USAGE-SOURCE,                                            
MFA-TR*       :RS-CODE-USAGE-TYPE,                                              
MFA-TR*       :RS-CODE-USAGE-ID,                                                
MFA-TR*       :RS-READ-SEQUENCE-NO,                                             
MFA-TR*       :RS-MTR-RD-DISP-CD,                                               
MFA-TR*       :RS-INDEX-VALUE-CD,                                               
MFA-TR*       :RS-NO-READ-DIGITS,                                               
MFA-TR*       :RS-NO-READ-DECIMALS                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02125_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02125_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02125_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
