       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02124.                                         
       DATE-WRITTEN.     JULY 12, 1995.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S124 CONVERTED TO DB2 SP CSR02124 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S124                                           *        
      *  PROGRAM:       S124                                           *        
      *  CALLING SP:    PN_S124                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES LIGHTING CONTRACT DATA.                *        
      *                                                                *        
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *        
      *                                                                *        
      *  TABLE                  TABLE ID     DCLGEN                    *        
      *  -----                  --------     ------                    *        
      *  CSS_BILL_CONTRACT         BK        TBBLCNTR                  *        
      *  CSS_UTIL_ENVRNMT          UT        TBUTLENV                  *        
      *  CSS_BILL_CNCL_CNTR        BV        TBBILLCC                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  07/12/95    HC       CREATED.                                 *        
      *  12/20/95    JHR      FIXED CURSOR AND SELECT LOGIC.           *        
      *  02/27/96    JHR      TPR 3219 - ADDED CONTRACT START DATE TO  *        
      *                       CURSOR WHERE CLAUSE.                     *        
      *  05/22/96    WMG      TPR 4176 - ADD PARAMETER AND LOGIC TO    *        
      *                       RETURN THE TOTAL CONTRACT(S) AMOUNT.     *        
      *  05/30/96    WMG      TPR 4157 - ADD THE ACCOUNT STATUS TO     *        
      *                       THE RETURN VARIABLE LIST.                *        
CBSI  *  08/14/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
T20443*  03/24/00    PRA      BRING INFO BACK REGARDLESS OF AMOUNT     *        
PERFOR*  03/28/07    VIJAY    PERFORMANCE TUNING CHANGES.                       
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02124'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S124 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCOUNT >                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *----< CSS_BILL_CONTRACT >                                                
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_BILL_CNCL_CNTR >                                               
           EXEC SQL                                                             
              INCLUDE TBBILLCC                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_RATE_PLAN_DESC >                                               
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_UTIL_ENVRNMT >                                                  
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONTRACT     >                                                  
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_AR_CNTL      >                                                  
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >                  
      *----< SYBASE OPEN SERVER FOR CICS FACILITIES.             >              
CVT999*    COPY SYGWCOB.                                                        
      *----< ADDED TO SUPPORT CICS RPCS >                                       
CVT999*    COPY SYDBCOB.                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
CVT999*    COPY CWS00010.                                                       
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08)   VALUE 'S124    '.  
CVT999*    05  GWL-PROC                  POINTER.                               
CVT999*    05  GWL-INIT-HANDLE           POINTER.                               
CVT999*    05  GWL-RC                    PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-NR             PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-DONE           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COUNT          PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COMM           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-RETURN-CODE    PIC S9(9)   COMP.                      
           05  GWL-STATUS-SUBCODE        PIC S9(9)   COMP.              
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9)   COMP.              
CVT999*    05  PARM-ID1                  PIC S9(9)   COMP VALUE 1.              
           05  PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
CVT999*    05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.              
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM           PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN1                   PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN2                   PIC S9(9)   COMP.                      
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
           05  WS-NULL-IND-1             PIC S9(04)  COMP.              
           05  WS-NULL-IND               PIC S9(04)  COMP.              
           05  WS-CANCEL-PERIOD-COMP     PIC S9(04)  COMP.              
           05  WS-CANCEL-PERIOD-NUM      PIC 9(04)   VALUE 0.           
           05  WS-CANCEL-PERIOD          PIC X(04)   VALUE SPACE.       
           05  WS-ACTIVE-CONTRACT        PIC X(01)   VALUE 'B'.         
           05  WS-ONE-TIME-CHARGE        PIC X(01)   VALUE 'A'.         
           05  WS-MONTHLY-CHARGE         PIC X(01)   VALUE 'B'.         
           05  WS-INSTALLMENTS           PIC X(01)   VALUE 'C'.         
           05  WS-90-DAY-SAME-AS-CASH    PIC X(01)   VALUE 'D'.         
           05  WS-MONTHLY-CREDIT         PIC X(01)   VALUE 'E'.         
           05  WS-SERVICE-CARE-CNT       PIC X(01)   VALUE 'F'.         
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)    COMP VALUE 0.    
           05  RS-RATE-PLAN-NO           PIC X(03)     VALUE SPACES.    
           05  RS-IC-NO                  PIC S9(04)    COMP VALUE 0.    
COB305     05 RS-REV-INSTALL-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 RS-AMOUNT-OWED        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
           05  RS-RATE-DESC              PIC X(25)     VALUE SPACES.    
           05  RS-TOTAL-CNT-AMT          PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE 0.         
           05  RS-PRIOR-ACCOUNT-STATUS   PIC X(01)     VALUE SPACES.    
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE           PIC X(11) VALUE                        
CVT999*                                            'RETURN_CODE'.               
CVT999*    05  CNS-RATE-PLAN-NO          PIC X(12) VALUE                        
CVT999*                                            'RATE_PLAN_NO'.              
CVT999*    05  CNS-IC-NO                 PIC X(05) VALUE                        
CVT999*                                            'IC_NO'.                     
CVT999*    05  CNS-REV-INSTALL-AMT       PIC X(15) VALUE                        
CVT999*                                            'REV_INSTALL_AMT'.           
CVT999*    05  CNS-AMOUNT-OWED           PIC X(11) VALUE                        
CVT999*                                            'AMOUNT_OWED'.               
CVT999*    05  CNS-RATE-DESC             PIC X(09) VALUE                        
CVT999*                                            'RATE_DESC'.                 
CVT999*    05  CNS-TOTAL-CNT-AMT         PIC X(13) VALUE                        
CVT999*                                            'TOTAL_CNT_AMT'.             
CVT999*    05  CNS-PRIOR-ACCOUNT-STATUS  PIC X(17) VALUE                        
CVT999*                                            'PRIOR_ACCT_STATUS'.         
CVT999*                                                                         
CVT999*                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO             PIC X(13)     VALUE SPACES.    
           05  WS-ACCOUNT-NO-I           PIC S9(13)    USAGE COMP.      
COB305     05 WS-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 VALUE 0.    
           05  WS-FETCH-BK               PIC S9(09)    COMP VALUE 0.    
           05  WS-CONTRACT-PPL           PIC S9(04)    COMP VALUE 100.  
           05  WS-TOTAL-CNT-AMT          PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE 0.         
           05  WS-TYPE1-SUM              PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE 0.         
           05  WS-TYPE2-SUM              PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE 0.         
           05  WS-TYPE3-SUM              PIC S9(09)V99 USAGE COMP-3     
                                                       VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
HPCCDM*EJECT                                                                    
                                                                        
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BK-UT-CURSOR CURSOR FOR                           
               SELECT A.IC_NO,                                          
                      A.CNTRCT_START_DT,                                
                      B.RATE_PLAN_NO   ,                                
                      C.RATE_DESC                                       
                 FROM CSS_BILL_CONTRACT  A WITH(READUNCOMMITTED),               
                      CSS_UTIL_ENVRNMT   B WITH(READUNCOMMITTED),               
                      CSS_RATE_PLAN_DESC C WITH(READUNCOMMITTED)                
                WHERE A.ACCOUNT_NO     = B.ACCOUNT_NO                   
                  AND A.ACCOUNT_NO     = :BK-ACCOUNT-NO                 
                  AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE               
                  AND B.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE               
                  AND A.CODE_UTIL_TYPE = 'U'                            
                  AND B.RATE_PLAN_NO   = C.RATE_PLAN_NO                 
                  AND B.RATE_PLAN_NO   <> '064'                         
                  AND A.IC_NO          = B.IC_NO                        
                  AND A.CNTRCT_END_DT  > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                  AND CNTRCT_START_DT  =                                
                     (SELECT MAX(D.CNTRCT_START_DT)                     
                        FROM CSS_BILL_CONTRACT D WITH(READUNCOMMITTED)          
                       WHERE D.ACCOUNT_NO     = A.ACCOUNT_NO            
                         AND D.CODE_UTIL_TYPE = A.CODE_UTIL_TYPE        
                         AND D.IC_NO          = A.IC_NO                 
                         AND D.CNTRCT_START_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE))         
PERFOR            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BK-UT-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT A.IC_NO,                                                  
MFA-TR*               A.CNTRCT_START_DT,                                        
MFA-TR*               B.RATE_PLAN_NO   ,                                        
MFA-TR*               C.RATE_DESC                                               
MFA-TR*          FROM CSS_BILL_CONTRACT  A,                                     
MFA-TR*               CSS_UTIL_ENVRNMT   B,                                     
MFA-TR*               CSS_RATE_PLAN_DESC C                                      
MFA-TR*         WHERE A.ACCOUNT_NO     = B.ACCOUNT_NO                           
MFA-TR*           AND A.ACCOUNT_NO     = :BK-ACCOUNT-NO                         
MFA-TR*           AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE                       
MFA-TR*           AND B.CODE_UTIL_TYPE = C.CODE_UTIL_TYPE                       
MFA-TR*           AND A.CODE_UTIL_TYPE = 'U'                                    
MFA-TR*           AND B.RATE_PLAN_NO   = C.RATE_PLAN_NO                         
MFA-TR*           AND B.RATE_PLAN_NO   <> '064'                                 
MFA-TR*           AND A.IC_NO          = B.IC_NO                                
MFA-TR*           AND A.CNTRCT_END_DT  > CURRENT DATE                           
MFA-TR*           AND CNTRCT_START_DT  =                                        
MFA-TR*              (SELECT MAX(D.CNTRCT_START_DT)                             
MFA-TR*                 FROM CSS_BILL_CONTRACT D                                
MFA-TR*                WHERE D.ACCOUNT_NO     = A.ACCOUNT_NO                    
MFA-TR*                  AND D.CODE_UTIL_TYPE = A.CODE_UTIL_TYPE                
MFA-TR*                  AND D.IC_NO          = A.IC_NO                         
MFA-TR*                  AND D.CNTRCT_START_DT <= CURRENT DATE)                 
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT  RETURN_CODE                                      
                      ,LTRIM(RTRIM(RATE_PLAN_NO))                              
                      ,IC_NO                                            
                      ,REV_INSTALL_AMT                                  
                      ,AMOUNT_OWED                                      
                      ,RATE_DESC                                        
                      ,TOTAL_CNT_AMT                                    
                      ,PRIOR_ACCOUNT_STAT                               
CVT000         FROM #CSR02124_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT  RETURN_CODE                                      00000400
MFA-TR*               ,STRIP(RATE_PLAN_NO)                                      
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,REV_INSTALL_AMT                                          
MFA-TR*               ,AMOUNT_OWED                                              
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,TOTAL_CNT_AMT                                            
MFA-TR*               ,PRIOR_ACCOUNT_STAT                                       
MFA-TR*        FROM SESSION.CSR02124_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      *                                                                *        
      * PERFORMS: 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM.                                    *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 0000-MAINLINE.                                      *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                     TO ACTIVE-PARAGRAPH.         
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                  TO ABEND-PROGRAM               
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'            TO TABLE-1                     
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02124_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02124_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,IC_NO                    SMALLINT                        
CVT000        ,REV_INSTALL_AMT          DECIMAL(11,2)                   
CVT000        ,AMOUNT_OWED              DECIMAL(11,2)                   
CVT000        ,RATE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,TOTAL_CNT_AMT            DECIMAL(11,2)                   
CVT004        ,PRIOR_ACCOUNT_STAT CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      * PERFORMS:  1100-RECEIVE-PARMS.                                 *        
      *                                                                *        
      * CALLED BY: 0000-MAINLINE.                                      *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS         THRU 1100-EXIT.           
                                                                        
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO                 TO BK-ACCOUNT-NO          
                                                 BV-ACCOUNT-NO          
                                                 CT-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS.                                            *        
      *                                                                *        
      * CALLED BY: 1000-PROCESS-INPUT.                                 *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
                                                                        
      *----< GET ACCOUNT-NO >                                                   
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      * PERFORMS:  F 2100-SCRIBE-RESULT                                *        
      *            5000-BUILD-RESULT                                   *        
      *            8100-SEND-RESULT.                                   *        
      *                                                                *        
      * CALLED BY: 0000-MAINLINE.                                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.           
           PERFORM 5000-BUILD-RESULT          THRU 5000-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT.                                          *        
      *                                                                *        
      * CALLED BY: 2000-PROCESS-OUTPUT.                                *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT999*    MOVE 1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSINT4                       TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-RATE-PLAN-NO     TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RATE-PLAN-NO    TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-PLAN-NO,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RATE-PLAN-NO,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSINT2                       TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSINT2                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-IC-NO            TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-IC-NO           TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-IC-NO,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-IC-NO,                                     
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-REV-INSTALL-AMT  TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-REV-INSTALL-AMT TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-REV-INSTALL-AMT,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-REV-INSTALL-AMT,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-AMOUNT-OWED      TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-AMOUNT-OWED     TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AMOUNT-OWED,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-AMOUNT-OWED,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-RATE-DESC        TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RATE-DESC       TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-DESC,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RATE-DESC,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-TOTAL-CNT-AMT    TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-TOTAL-CNT-AMT   TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOTAL-CNT-AMT,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOTAL-CNT-AMT,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
                                                                        
CVT999*    ADD  1                                  TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-PRIOR-ACCOUNT-STATUS  TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-PRIOR-ACCOUNT-STATUS TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PRIOR-ACCOUNT-STATUS,                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PRIOR-ACCOUNT-STATUS,                      
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5000-BUILD-RESULT.                                             *        
      *                                                                *        
      * CALLED BY: 2000-PROCESS-OUTPUT.                                *        
      ******************************************************************        
       5000-BUILD-RESULT.                                               
                                                                        
           MOVE '5000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7500-GET-CNT-TOTAL         THRU 7500-EXIT.           
           PERFORM 7550-GET-PRIOR-ACCT-STAT   THRU 7550-EXIT.           
                                                                        
           PERFORM 7000-OPEN-BK-UT-CURSOR     THRU 7000-EXIT.           
           PERFORM 7100-FETCH-BK-UT-CURSOR    THRU 7100-EXIT.           
                                                                        
           PERFORM UNTIL WS-FETCH-BK = NOT-FOUND                        
              MOVE BK-IC-NO                   TO RS-IC-NO               
              MOVE UT-RATE-PLAN-NO            TO RS-RATE-PLAN-NO        
              MOVE ZERO                       TO RS-REV-INSTALL-AMT     
              MOVE RD-RATE-DESC               TO RS-RATE-DESC           
              PERFORM 5100-GET-AMT-OWED       THRU 5100-EXIT            
T20443        IF RS-AMOUNT-OWED >= ZERO                                 
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
              END-IF                                                    
              PERFORM 7100-FETCH-BK-UT-CURSOR THRU 7100-EXIT            
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-BK-UT-CURSOR    THRU 7200-EXIT.           
                                                                        
      *    ENSURE AT LEAST ONE ROW HAS BEEN SENT.                               
           IF CTR-ROWS < 1                                              
              MOVE ZERO                       TO RS-RETURN-CODE         
              MOVE SPACES                     TO RS-RATE-PLAN-NO        
              MOVE ZERO                       TO RS-IC-NO               
              MOVE ZERO                       TO RS-REV-INSTALL-AMT     
              MOVE ZERO                       TO RS-AMOUNT-OWED         
              MOVE SPACES                     TO RS-RATE-DESC           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5100-GET-AMT-OWED.                                             *        
      *                                                                *        
      * PERFORMS:  7300-SELECT-CANCEL-PERIOD                           *        
      *            7400-SELECT-AMOUNT-OWED.                            *        
      *                                                                *        
      * CALLED BY:  5000-BUILD-RESULT.                                 *        
      ******************************************************************        
       5100-GET-AMT-OWED.                                               
                                                                        
           MOVE '5100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7300-SELECT-CANCEL-PERIOD  THRU 7300-EXIT.           
                                                                        
      *    ADD ONE YEAR TO RESULT TO REFLECT 0-365 DAYS AS THE 1ST YEAR.        
           ADD 1                              TO WS-CANCEL-PERIOD-COMP. 
                                                                        
           MOVE WS-CANCEL-PERIOD-COMP         TO WS-CANCEL-PERIOD-NUM.  
           MOVE WS-CANCEL-PERIOD-NUM          TO WS-CANCEL-PERIOD.      
           MOVE WS-CANCEL-PERIOD (4:1)        TO BV-CANCEL-PERIOD-CD.   
                                                                        
           PERFORM 7400-SELECT-AMOUNT-OWED    THRU 7400-EXIT.           
           MOVE BV-CANCEL-CHRG-AM             TO RS-AMOUNT-OWED.        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-BK-UT-CURSOR.                                        *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 5000-BUILD-RESULT.                                  *        
      ******************************************************************        
       7000-OPEN-BK-UT-CURSOR.                                          
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN BK-UT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'CSS_BILL_CONTRACT'        TO TABLE-1                
CBSI          MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
CBSI          MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-3                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BK-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'U'                        TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-BK-UT-CURSOR.                                       *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 5000-BUILD-RESULT.                                  *        
      ******************************************************************        
       7100-FETCH-BK-UT-CURSOR.                                         
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH BK-UT-CURSOR                                        
               INTO :BK-IC-NO          ,                                
                    :BK-CNTRCT-START-DT,                                
                    :UT-RATE-PLAN-NO   ,                                
                    :RD-RATE-DESC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                              WS-FETCH-BK.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'CSS_BILL_CONTRACT'        TO TABLE-1                
CBSI          MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
CBSI          MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-3                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BK-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'U'                        TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-BK-UT-CURSOR.                                       *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 5000-BUILD-RESULT.                                  *        
      ******************************************************************        
       7200-CLOSE-BK-UT-CURSOR.                                         
                                                                        
                                                                        
           EXEC SQL                                                     
              CLOSE BK-UT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'CSS_BILL_CONTRACT'        TO TABLE-1                
CBSI          MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
CBSI          MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-3                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BK-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'U'                        TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-CANCEL-PERIOD.                                     *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 5000-BUILD-RESULT.                                  *        
      ******************************************************************        
       7300-SELECT-CANCEL-PERIOD.                                       
                                                                        
                                                                        
           EXEC SQL                                                     
PERFOR       SELECT
              CIS.DECIMAL2YEAR(CIS.DIFFDATE( CAST(SYSDATETIMEOFFSET() 
           AS DATE), IIF(TRY_CONVERT(DATE, :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) ) ))
            INTO
              :WS-CANCEL-PERIOD-COMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CANCEL-PERIOD-COMP =                                       
MFA-TR*              YEAR(CURRENT DATE - :BK-CNTRCT-START-DT)                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
PERFOR        MOVE 'SET '                     TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'CNTRCT_START_DT'          TO TABLE-ELEMENT-2        
CBSI          MOVE BK-CNTRCT-START-DT         TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-AMOUNT-OWED.                                       *        
      *                                                                *        
      * PERFORMS:  9000-SEND-ERROR-RESULT                              *        
      *            9900-SQL-ERROR-ROUTINE.                             *        
      *                                                                *        
      * CALLED BY: 5000-BUILD-RESULT.                                  *        
      ******************************************************************        
       7400-SELECT-AMOUNT-OWED.                                         
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT CANCEL_CHRG_AM                                     
                INTO :BV-CANCEL-CHRG-AM                                 
                FROM CSS_BILL_CNCL_CNTR WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO       = :BV-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = 'U'                             
                 AND IC_NO            = :BK-IC-NO                       
                 AND CNTRCT_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) )             
                 AND CANCEL_PERIOD_CD = :BV-CANCEL-PERIOD-CD            
PERFOR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CANCEL_CHRG_AM                                             
MFA-TR*         INTO :BV-CANCEL-CHRG-AM                                         
MFA-TR*         FROM CSS_BILL_CNCL_CNTR                                         
MFA-TR*        WHERE ACCOUNT_NO       = :BV-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = 'U'                                     
MFA-TR*          AND IC_NO            = :BK-IC-NO                               
MFA-TR*          AND CNTRCT_START_DT  = :BK-CNTRCT-START-DT                     
MFA-TR*          AND CANCEL_PERIOD_CD = :BV-CANCEL-PERIOD-CD                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_CNCL_CNTR'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'U'                        TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE BK-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'CNTRCT_START_DT'          TO TABLE-ELEMENT-4        
CBSI          MOVE BK-CNTRCT-START-DT         TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-CNT-TOTAL                                             *        
      *    SUM THE TOTAL OF ALL ACTIVE CONTRACTS:                      *        
      *      1. FOR INSTALLMENT AND 90-DAY SAME AS CASH CONTRACTS,     *        
      *         SUM AMT_TRAN_BALANCE - (00 + 30 + 60 + 90 BUCKETS)     *        
      *      2. FOR MONTHY CHARGE AND MONTHLY CREDIT CONTRACTS, SUM THE*        
      *         AMT_MO_PYMT FOR ALL ACTIVE CONTRACTS THAT ARE NOT      *        
      *         SERVICE CARE CONTRACT TYPES                            *        
      *      3. FOR ONE-TIME CHARGE CONTRACTS, ACCUMULATE AMT_MO_PYMT  *        
      *                                                                *        
      ******************************************************************        
       7500-GET-CNT-TOTAL.                                              
                                                                        
           PERFORM 7510-GET-TYPE1-SUM         THRU 7510-EXIT.           
           PERFORM 7520-GET-TYPE2-SUM         THRU 7520-EXIT.           
           PERFORM 7530-GET-TYPE3-SUM         THRU 7530-EXIT.           
                                                                        
           COMPUTE WS-TOTAL-CNT-AMT = WS-TYPE1-SUM +                    
                                      WS-TYPE2-SUM +                    
                                      WS-TYPE3-SUM.                     
                                                                        
           MOVE WS-TOTAL-CNT-AMT              TO RS-TOTAL-CNT-AMT.      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7510-GET-TYPE1-SUM                                             *        
      *     GET THE SUM OF THE CONTRACTS THAT HAVE AN INSTALLMENTS OR  *        
      *     90-DAY SAME AS CASH BILLING OPTION.                        *        
      ******************************************************************        
       7510-GET-TYPE1-SUM.                                              
                                                                        
           MOVE '7510'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT SUM(A.AMT_TRAN_BALANCE) - (SUM(A.AMT_AR_DAY_00) +  
                                                SUM(A.AMT_AR_DAY_30) +  
                                                SUM(A.AMT_AR_DAY_60) +  
                                                SUM(A.AMT_AR_DAY_90))   
                INTO :WS-TYPE1-SUM :WS-NULL-IND                          
                FROM CSS_AR_CNTL  A WITH(READUNCOMMITTED),                      
                     CSS_CONTRACT B WITH(READUNCOMMITTED)                       
               WHERE A.ACCOUNT_NO        = :CT-ACCOUNT-NO               
                 AND B.PYMT_PRIORITY_LVL = :WS-CONTRACT-PPL             
                 AND B.PYMT_PRIORITY_LVL = A.PYMT_PRIORITY_LVL          
                 AND A.ACCOUNT_NO        = B.ACCOUNT_NO                 
                 AND A.ITEM_ID           = B.CNT_ITEM_ID                
                 AND B.CNT_STATUS_CD     = :WS-ACTIVE-CONTRACT          
                 AND (B.CODE_BILL_TYPE   = :WS-INSTALLMENTS             
                  OR  B.CODE_BILL_TYPE   = :WS-90-DAY-SAME-AS-CASH)     
PERFOR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(A.AMT_TRAN_BALANCE) - (SUM(A.AMT_AR_DAY_00) +          
MFA-TR*                                         SUM(A.AMT_AR_DAY_30) +          
MFA-TR*                                         SUM(A.AMT_AR_DAY_60) +          
MFA-TR*                                         SUM(A.AMT_AR_DAY_90))           
MFA-TR*         INTO :WS-TYPE1-SUM:WS-NULL-IND                                  
MFA-TR*         FROM CSS_AR_CNTL  A,                                            
MFA-TR*              CSS_CONTRACT B                                             
MFA-TR*        WHERE A.ACCOUNT_NO        = :CT-ACCOUNT-NO                       
MFA-TR*          AND B.PYMT_PRIORITY_LVL = :WS-CONTRACT-PPL                     
MFA-TR*          AND B.PYMT_PRIORITY_LVL = A.PYMT_PRIORITY_LVL                  
MFA-TR*          AND A.ACCOUNT_NO        = B.ACCOUNT_NO                         
MFA-TR*          AND A.ITEM_ID           = B.CNT_ITEM_ID                        
MFA-TR*          AND B.CNT_STATUS_CD     = :WS-ACTIVE-CONTRACT                  
MFA-TR*          AND (B.CODE_BILL_TYPE   = :WS-INSTALLMENTS                     
MFA-TR*           OR  B.CODE_BILL_TYPE   = :WS-90-DAY-SAME-AS-CASH)             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND = -1                                       
                 MOVE 0                       TO WS-TYPE1-SUM           
              END-IF                                                    
              MOVE 0                          TO WS-NULL-IND            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'CSS_AR_CNTL'              TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CNT_STATUS_CD'            TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-CONTRACT         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_BILL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-INSTALLMENTS            TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-4        
CBSI          MOVE WS-CONTRACT-PPL            TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7520-GET-TYPE2-SUM                                             *        
      *     GET THE SUM OF THE CONTRACTS THAT HAVE A MONTHLY CHARGE OR *        
      *     MONTHLY CREDIT BILLING OPTION.                             *        
      ******************************************************************        
       7520-GET-TYPE2-SUM.                                              
                                                                        
           MOVE '7520'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_MO_PYMT)                                   
                INTO :WS-TYPE2-SUM :WS-NULL-IND                          
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO          = :CT-ACCOUNT-NO               
                 AND PYMT_PRIORITY_LVL   = :WS-CONTRACT-PPL             
                 AND CNT_STATUS_CD       = :WS-ACTIVE-CONTRACT          
                 AND (CODE_BILL_TYPE     = :WS-MONTHLY-CHARGE           
                  OR  CODE_BILL_TYPE     = :WS-MONTHLY-CREDIT)          
                 AND CODE_CONTRACT_TYPE <> :WS-SERVICE-CARE-CNT         
PERFOR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_MO_PYMT)                                           
MFA-TR*         INTO :WS-TYPE2-SUM:WS-NULL-IND                                  
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO          = :CT-ACCOUNT-NO                       
MFA-TR*          AND PYMT_PRIORITY_LVL   = :WS-CONTRACT-PPL                     
MFA-TR*          AND CNT_STATUS_CD       = :WS-ACTIVE-CONTRACT                  
MFA-TR*          AND (CODE_BILL_TYPE     = :WS-MONTHLY-CHARGE                   
MFA-TR*           OR  CODE_BILL_TYPE     = :WS-MONTHLY-CREDIT)                  
MFA-TR*          AND CODE_CONTRACT_TYPE <> :WS-SERVICE-CARE-CNT                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND = -1                                       
                 MOVE 0                       TO WS-TYPE2-SUM           
              END-IF                                                    
              MOVE 0                          TO WS-NULL-IND            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CNT_STATUS_CD'            TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-CONTRACT         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_BILL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-MONTHLY-CHARGE          TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-4        
CBSI          MOVE WS-CONTRACT-PPL            TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7530-GET-TYPE3-SUM                                             *        
      *     GET THE SUM OF THE CONTRACTS THAT HAVE A ONE TIME CHARGE   *        
      ******************************************************************        
       7530-GET-TYPE3-SUM.                                              
                                                                        
           MOVE '7530'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_MO_PYMT)                                   
                INTO :WS-TYPE3-SUM :WS-NULL-IND                          
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :WS-CONTRACT-PPL               
                 AND CNT_STATUS_CD     = :WS-ACTIVE-CONTRACT            
                 AND CODE_BILL_TYPE    = :WS-ONE-TIME-CHARGE            
PERFOR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_MO_PYMT)                                           
MFA-TR*         INTO :WS-TYPE3-SUM:WS-NULL-IND                                  
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :WS-CONTRACT-PPL                       
MFA-TR*          AND CNT_STATUS_CD     = :WS-ACTIVE-CONTRACT                    
MFA-TR*          AND CODE_BILL_TYPE    = :WS-ONE-TIME-CHARGE                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND = -1                                       
                 MOVE 0                       TO WS-TYPE3-SUM           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CNT_STATUS_CD'            TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-CONTRACT         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_BILL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-ONE-TIME-CHARGE         TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-4        
CBSI          MOVE WS-CONTRACT-PPL            TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7550-GET-PRIOR-ACCT-STAT                                       *        
      *     GET THE STATUS OF THE PRIOR ACCOUNT.                       *        
      ******************************************************************        
       7550-GET-PRIOR-ACCT-STAT.                                        
                                                                        
           MOVE '7550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_STAT                                     
                INTO :RS-PRIOR-ACCOUNT-STATUS                           
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
PERFOR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_STAT                                             
MFA-TR*         INTO :RS-PRIOR-ACCOUNT-STATUS                                   
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02124_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,RATE_PLAN_NO                                              
CVT000       ,IC_NO                                                     
CVT000       ,REV_INSTALL_AMT                                           
CVT000       ,AMOUNT_OWED                                               
CVT000       ,RATE_DESC                                                 
CVT000       ,TOTAL_CNT_AMT                                             
CVT000       ,PRIOR_ACCOUNT_STAT                                        
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-RATE-PLAN-NO                                          
CVT000       ,:RS-IC-NO                                                 
CVT000       ,:RS-REV-INSTALL-AMT                                       
CVT000       ,:RS-AMOUNT-OWED                                           
CVT000       ,:RS-RATE-DESC                                             
CVT000       ,:RS-TOTAL-CNT-AMT                                         
CVT000       ,:RS-PRIOR-ACCOUNT-STATUS                                  
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02124_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,REV_INSTALL_AMT                                                   
MFA-TR*      ,AMOUNT_OWED                                                       
MFA-TR*      ,RATE_DESC                                                         
MFA-TR*      ,TOTAL_CNT_AMT                                                     
MFA-TR*      ,PRIOR_ACCOUNT_STAT                                                
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-RATE-PLAN-NO                                                  
MFA-TR*      ,:RS-IC-NO                                                         
MFA-TR*      ,:RS-REV-INSTALL-AMT                                               
MFA-TR*      ,:RS-AMOUNT-OWED                                                   
MFA-TR*      ,:RS-RATE-DESC                                                     
MFA-TR*      ,:RS-TOTAL-CNT-AMT                                                 
MFA-TR*      ,:RS-PRIOR-ACCOUNT-STATUS                                          
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02124_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02124_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02124_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
