       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02123.                                         
       DATE-WRITTEN.     JULY 7, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S123 CONVERTED TO DB2 SP CSR02123 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S123                                           *        
      *  PROGRAM:       S123                                           *        
      *  CALLING SP:    PN_S123                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ACCOUNT BILLING ADDRESS INCLUDING  *        
      *  FORMATTED OR FREEFORM.                                        *        
      *                                                                *        
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *        
      *                                                                *        
      *  TABLE                  TABLE ID     DCLGEN                    *        
      *  -----                  --------     ------                    *        
      *  CSS_ACCOUNT               AT        TBACCT                    *        
      *  CSS_AR_CNTL               AC        TBARCNTL                  *        
      *  CSS_ADDR_FORMATTED        DY        TBADRFMT                  *        
      *  CSS_ADDR_FREEFORM         DZ        TBADRFRE                  *        
      *  CSS_ZIP_CODE              A4        TBZIPCD                   *        
      *  CSS_DEP_REQ               DR        TBDEPREQ                  *        
      *  CSS_DEP_ON_HAND           DO        TBDEPHND                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  07/07/95    HC       CREATED.                                 *        
      *  01/09/96    JHR      ADDED ZIP_CODE_TOKEN TO RETURN LIST.     *        
      *  08/09/96    DB       RETURNS FLAG INDICATING LIGHTING         *        
      *                       CONTRACT EXISTS.                         *        
PCR482*  03/05/97    MAD      MODIFIED PARAGRAPH 7310 TO RETURN ONLY   *        
      *                       'BILLING' AND 'PAID' DEPOSITS.           *        
      *  04/22/97    WMG      REMOVED PARAGRAPH 7300 DUE TO CHANGES    *        
      *                       IN THE DEPOSIT FUNCTIONALITY.            *        
CBSI  *  08/17/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
C37649*  10/20/08    COVANSYS NAME AND ADDRESS FORMATTED CHANGES                
C37649*              CHENNAI                                           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02123'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S123 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCOUNT >                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCT_BILL_NMES >                                               
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FORMATTED >                                               
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FREEFORM >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_DEP_REQ >                                                       
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_DEP_ON_HAND >                                                   
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_AR_CNTL >                                                       
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >                  
      *----< SYBASE OPEN SERVER FOR CICS FACILITIES.             >              
CVT999*    COPY SYGWCOB.                                                        
      *----< ADDED TO SUPPORT CICS RPCS >                                       
CVT999*    COPY SYDBCOB.                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
CVT999*    COPY CWS00010.                                                       
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08)   VALUE 'S123    '.  
CVT999*    05  GWL-PROC                  POINTER.                               
CVT999*    05  GWL-INIT-HANDLE           POINTER.                               
CVT999*    05  GWL-RC                    PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-NR             PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-DONE           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COUNT          PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COMM           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-RETURN-CODE    PIC S9(9)   COMP.                      
           05  GWL-STATUS-SUBCODE        PIC S9(9)   COMP.              
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9)   COMP.              
CVT999*    05  PARM-ID1                  PIC S9(9)   COMP VALUE 1.              
           05  PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
CVT999*    05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.              
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM           PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN1                   PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN2                   PIC S9(9)   COMP.                      
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
           05  WS-080                    PIC S9(04)  COMP VALUE +080.   
           05  WS-NULL-IND-1             PIC S9(04)  COMP.              
           05  WS-LC-EXISTS              PIC S9(04)  COMP VALUE 0.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
COB305     05 RS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  RS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
COB305     05 RS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 RS-DEPOSITS        PIC S9(11)V99 USAGE COMP-3 VALUE 0.    
           05  RS-CRED-REF-IND           PIC X(01)   VALUE SPACE.       
           05  RS-LOC-OFFICE-IND         PIC X(01)   VALUE SPACE.       
C37649*    05  RS-FO-HOUSE-NO            PIC X(05)   VALUE SPACES.              
C37649     05  RS-FO-HOUSE-NO            PIC X(15)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-1       PIC X(03)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-2       PIC X(02)   VALUE SPACES.      
C37649*    05  RS-FO-STREET-NAME         PIC X(16)   VALUE SPACES.              
C37649     05  RS-FO-STREET-NAME         PIC X(30)   VALUE SPACES.      
           05  RS-FO-STREET-SUFFIX       PIC X(04)   VALUE SPACES.      
           05  RS-FO-ADDR-SUFFIX         PIC X(02)   VALUE SPACES.      
           05  RS-FO-STREET-LOCATION-1   PIC X(04)   VALUE SPACES.      
C37649*    05  RS-FO-STREET-LOCATION-2   PIC X(04)   VALUE SPACES.              
C37649     05  RS-FO-STREET-LOCATION-2   PIC X(11)   VALUE SPACES.      
           05  RS-FO-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE            PIC X(05)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE-PL-FOUR    PIC X(04)   VALUE SPACES.      
           05  RS-FO-CARRIER-ROUTE       PIC X(05)   VALUE SPACES.      
           05  RS-FO-TOWN                PIC X(26)   VALUE SPACES.      
           05  RS-FO-STATE               PIC X(02)   VALUE SPACES.      
C37649*    05  RS-FR-ADDR-STREET         PIC X(35)   VALUE SPACES.              
C37649     05  RS-FR-ADDR-STREET         PIC X(55)   VALUE SPACES.      
           05  RS-FR-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
C37649*    05  RS-FR-CITY-STATE          PIC X(20)   VALUE SPACES.              
C37649     05  RS-FR-CITY-STATE          PIC X(30)   VALUE SPACES.      
           05  RS-FR-ZIP-CODE            PIC X(09)   VALUE SPACES.      
           05  RS-FR-COUNTRY             PIC X(35)   VALUE SPACES.      
           05  RS-BYPASS-CODE1           PIC X(01)   VALUE SPACES.      
           05  RS-BILL-ADDR              PIC X(01)   VALUE SPACES.      
           05  RS-ZIP-CODE-TOKEN         PIC X(01)   VALUE SPACES.      
           05  RS-LC-EXISTS              PIC X(01)   VALUE 'N'.         
           05  RS-ACCT-STATUS            PIC X(01)   VALUE ' '.         
                                                                        
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE           PIC X(11) VALUE                        
CVT999*                                            'RETURN_CODE'.               
CVT999*    05  CNS-ACCOUNT-NO            PIC X(10) VALUE                        
CVT999*                                            'ACCOUNT_NO'.                
CVT999*    05  CNS-ADDRESS-FORMAT        PIC X(14) VALUE                        
CVT999*                                            'ADDRESS_FORMAT'.            
CVT999*    05  CNS-ADDRESS-ID            PIC X(10) VALUE                        
CVT999*                                            'ADDRESS_ID'.                
CVT999*    05  CNS-DEPOSITS              PIC X(08) VALUE                        
CVT999*                                            'DEPOSITS'.                  
CVT999*    05  CNS-CRED-REF-IND          PIC X(12) VALUE                        
CVT999*                                            'CRED_REF_IND'.              
CVT999*    05  CNS-LOC-OFFICE-IND        PIC X(14) VALUE                        
CVT999*                                            'LOC_OFFICE_IND'.            
CVT999*    05  CNS-FO-HOUSE-NO           PIC X(11) VALUE                        
CVT999*                                            'FO_HOUSE_NO'.               
CVT999*    05  CNS-FO-ADDR-PREFIX-1      PIC X(16) VALUE                        
CVT999*                                            'FO_ADDR_PREFIX_1'.          
CVT999*    05  CNS-FO-ADDR-PREFIX-2      PIC X(16) VALUE                        
CVT999*                                            'FO_ADDR_PREFIX_2'.          
CVT999*    05  CNS-FO-STREET-NAME        PIC X(14) VALUE                        
CVT999*                                            'FO_STREET_NAME'.            
CVT999*    05  CNS-FO-STREET-SUFFIX      PIC X(16) VALUE                        
CVT999*                                            'FO_STREET_SUFFIX'.          
CVT999*    05  CNS-FO-ADDR-SUFFIX        PIC X(14) VALUE                        
CVT999*                                            'FO_ADDR_SUFFIX'.            
CVT999*    05  CNS-FO-STREET-LOCATION-1  PIC X(20) VALUE                        
CVT999*                                      'FO_STREET_LOCATION_1'.            
CVT999*    05  CNS-FO-STREET-LOCATION-2  PIC X(20) VALUE                        
CVT999*                                      'FO_STREET_LOCATION_2'.            
CVT999*    05  CNS-FO-ADDRESS-OVERFLOW   PIC X(19) VALUE                        
CVT999*                                      'FO_ADDRESS_OVERFLOW'.             
CVT999*    05  CNS-FO-ZIP-CODE           PIC X(11) VALUE                        
CVT999*                                            'FO_ZIP_CODE'.               
CVT999*    05  CNS-FO-ZIP-CODE-PL-FOUR   PIC X(19) VALUE                        
CVT999*                                      'FO_ZIP_CODE_PL_FOUR'.             
CVT999*    05  CNS-FO-CARRIER-ROUTE      PIC X(16) VALUE                        
CVT999*                                            'FO_CARRIER_ROUTE'.          
CVT999*    05  CNS-FO-TOWN               PIC X(07) VALUE                        
CVT999*                                            'FO_TOWN'.                   
CVT999*    05  CNS-FO-STATE              PIC X(08) VALUE                        
CVT999*                                            'FO_STATE'.                  
CVT999*    05  CNS-FR-ADDR-STREET        PIC X(14) VALUE                        
CVT999*                                            'FR_ADDR_STREET'.            
CVT999*    05  CNS-FR-ADDRESS-OVERFLOW   PIC X(19) VALUE                        
CVT999*                                      'FR_ADDRESS_OVERFLOW'.             
CVT999*    05  CNS-FR-CITY-STATE         PIC X(13) VALUE                        
CVT999*                                            'FR_CITY_STATE'.             
CVT999*    05  CNS-FR-ZIP-CODE           PIC X(11) VALUE                        
CVT999*                                            'FR_ZIP_CODE'.               
CVT999*    05  CNS-FR-COUNTRY            PIC X(10) VALUE                        
CVT999*                                            'FR_COUNTRY'.                
CVT999*    05  CNS-BYPASS-CODE1          PIC X(12) VALUE                        
CVT999*                                            'BYPASS_CODE1'.              
CVT999*    05  CNS-BILL-ADDR             PIC X(09) VALUE                        
CVT999*                                            'BILL_ADDR'.                 
CVT999*    05  CNS-ZIP-CODE-TOKEN        PIC X(14) VALUE                        
CVT999*                                            'ZIP_CODE_TOKEN'.            
CVT999*    05  CNS-LC-EXISTS             PIC X(09) VALUE                        
CVT999*                                            'LC_EXISTS'.                 
CVT999*    05  CNS-ACCT-STATUS           PIC X(11) VALUE                        
CVT999*                                            'ACCT STATUS'.               
CVT999*                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO             PIC X(13)   VALUE SPACES.      
           05  WS-ACCOUNT-NO-NUM         PIC S9(13) COMP-3 VALUE ZERO.  
           05  WS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-ADDRESS-ID-S           PIC X(13)   VALUE SPACES.      
           05  WS-ZIP-CODE               PIC X(05)   VALUE SPACES.      
           05  WS-ZIP-CODE-TOKEN         PIC X(01)   VALUE SPACES.      
COB305     05 WS-DEPOSITS        PIC S9(11)V99 USAGE COMP-3 VALUE 0.    
           05  WS-ACCT-STATUS            PIC X(01)   VALUE ' '.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
SOFIX              RETURN_CODE                                          
SOFIX             ,ACCOUNT_NO                                           
SOFIX             ,ADDRESS_FORMAT                                       
SOFIX             ,ADDRESS_ID                                           
SOFIX             ,DEPOSITS                                             
SOFIX             ,CRED_REF_IND                                         
SOFIX             ,LOC_OFFICE_IND                                       
SOFIX             ,LTRIM(RTRIM(FO_HOUSE_NO))        AS FO_HOUSE_NO             
SOFIX             ,LTRIM(RTRIM(FO_ADDR_PREFIX_1))   AS FO_ADDR_PREFIX_1        
SOFIX             ,LTRIM(RTRIM(FO_ADDR_PREFIX_2))   AS FO_ADDR_PREFIX_2        
SOFIX             ,LTRIM(RTRIM(FO_STREET_NAME))     AS FO_STREET_NAME          
SOFIX             ,LTRIM(RTRIM(FO_STREET_SUFFIX))   AS FO_STREET_SUFFIX        
SOFIX             ,LTRIM(RTRIM(FO_ADDR_SUFFIX))     AS FO_ADDR_SUFFIX          
SOFIX             ,LTRIM(RTRIM(FO_STREET_LOCATIO1)) AS 
           FO_STREET_LOCATIO1      
SOFIX             ,LTRIM(RTRIM(FO_STREET_LOCATIO2)) AS 
           FO_STREET_LOCATIO2      
SOFIX             ,LTRIM(RTRIM(FO_ADDRESS_OVERFLO)) AS 
           FO_ADDRESS_OVERFLO      
SOFIX             ,LTRIM(RTRIM(FO_ZIP_CODE))        AS FO_ZIP_CODE             
SOFIX             ,LTRIM(RTRIM(FO_ZIP_CODE_PL_FOU)) AS 
           FO_ZIP_CODE_PL_FOU      
SOFIX             ,LTRIM(RTRIM(FO_CARRIER_ROUTE))   AS FO_CARRIER_ROUTE        
SOFIX             ,LTRIM(RTRIM(FO_TOWN))            AS FO_TOWN                 
SOFIX             ,LTRIM(RTRIM(FO_STATE))           AS FO_STATE                
SOFIX             ,LTRIM(RTRIM(FR_ADDR_STREET))     AS FR_ADDR_STREET          
SOFIX             ,LTRIM(RTRIM(FR_ADDRESS_OVERFLO)) AS 
           FR_ADDRESS_OVERFLO      
SOFIX             ,LTRIM(RTRIM(FR_CITY_STATE))      AS FR_CITY_STATE           
SOFIX             ,LTRIM(RTRIM(FR_ZIP_CODE))        AS FR_ZIP_CODE             
SOFIX             ,LTRIM(RTRIM(FR_COUNTRY))         AS FR_COUNTRY              
SOFIX             ,LTRIM(RTRIM(BYPASS_CODE1))       AS BYPASS_CODE1            
SOFIX             ,BILL_ADDR                                            
SOFIX             ,ZIP_CODE_TOKEN                                       
SOFIX             ,LC_EXISTS                                            
SOFIX             ,ACCT_STATUS                                          
CVT000         FROM #CSR02123_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,ADDRESS_FORMAT                                               
MFA-TR*           ,ADDRESS_ID                                                   
MFA-TR*           ,DEPOSITS                                                     
MFA-TR*           ,CRED_REF_IND                                                 
MFA-TR*           ,LOC_OFFICE_IND                                               
MFA-TR*           ,STRIP(FO_HOUSE_NO)        AS FO_HOUSE_NO                     
MFA-TR*           ,STRIP(FO_ADDR_PREFIX_1)   AS FO_ADDR_PREFIX_1                
MFA-TR*           ,STRIP(FO_ADDR_PREFIX_2)   AS FO_ADDR_PREFIX_2                
MFA-TR*           ,STRIP(FO_STREET_NAME)     AS FO_STREET_NAME                  
MFA-TR*           ,STRIP(FO_STREET_SUFFIX)   AS FO_STREET_SUFFIX                
MFA-TR*           ,STRIP(FO_ADDR_SUFFIX)     AS FO_ADDR_SUFFIX                  
MFA-TR*           ,STRIP(FO_STREET_LOCATIO1) AS FO_STREET_LOCATIO1              
MFA-TR*           ,STRIP(FO_STREET_LOCATIO2) AS FO_STREET_LOCATIO2              
MFA-TR*           ,STRIP(FO_ADDRESS_OVERFLO) AS FO_ADDRESS_OVERFLO              
MFA-TR*           ,STRIP(FO_ZIP_CODE)        AS FO_ZIP_CODE                     
MFA-TR*           ,STRIP(FO_ZIP_CODE_PL_FOU) AS FO_ZIP_CODE_PL_FOU              
MFA-TR*           ,STRIP(FO_CARRIER_ROUTE)   AS FO_CARRIER_ROUTE                
MFA-TR*           ,STRIP(FO_TOWN)            AS FO_TOWN                         
MFA-TR*           ,STRIP(FO_STATE)           AS FO_STATE                        
MFA-TR*           ,STRIP(FR_ADDR_STREET)     AS FR_ADDR_STREET                  
MFA-TR*           ,STRIP(FR_ADDRESS_OVERFLO) AS FR_ADDRESS_OVERFLO              
MFA-TR*           ,STRIP(FR_CITY_STATE)      AS FR_CITY_STATE                   
MFA-TR*           ,STRIP(FR_ZIP_CODE)        AS FR_ZIP_CODE                     
MFA-TR*           ,STRIP(FR_COUNTRY)         AS FR_COUNTRY                      
MFA-TR*           ,STRIP(BYPASS_CODE1)       AS BYPASS_CODE1                    
MFA-TR*           ,BILL_ADDR                                                    
MFA-TR*           ,ZIP_CODE_TOKEN                                               
MFA-TR*           ,LC_EXISTS                                                    
MFA-TR*           ,ACCT_STATUS                                                  
MFA-TR*        FROM SESSION.CSR02123_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'         TO TABLE-1                        
CVT999*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02123_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02123_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,ACCOUNT_NO               DECIMAL(13,0)                   
CVT000        ,ADDRESS_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,ADDRESS_ID               DECIMAL(13,0)                   
CVT000        ,DEPOSITS                 DECIMAL(13,2)                   
CVT000        ,CRED_REF_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,LOC_OFFICE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
C37649        ,FO_HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,FO_ADDR_PREFIX_1 CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,FO_ADDR_PREFIX_2 CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
C37649        ,FO_STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,FO_STREET_SUFFIX CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,FO_ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT004        ,FO_STREET_LOCATIO1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
C37649        ,FO_STREET_LOCATIO2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT004        ,FO_ADDRESS_OVERFLO CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,FO_ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT004        ,FO_ZIP_CODE_PL_FOU CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,FO_CARRIER_ROUTE CHAR(05)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,FO_TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,FO_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2               
C37649        ,FR_ADDR_STREET CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT004        ,FR_ADDRESS_OVERFLO CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
C37649        ,FR_CITY_STATE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,FR_ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,FR_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,BYPASS_CODE1 CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,BILL_ADDR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,ZIP_CODE_TOKEN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,LC_EXISTS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,ACCT_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
                                                                        
                                                                        
           MOVE PARM-ACCOUNT-NO    TO WS-ACCOUNT-NO.                    
           MOVE WS-ACCOUNT-NO      TO WS-ACCOUNT-NO-NUM.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
      *----< GET ACCOUNT-NO >                                                   
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2400-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2400-BUILD-RESULT             THRU 2400-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     DESCRIBE EACH RESULT FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                   TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSFLT8                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ACCOUNT-NO     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCOUNT-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ADDRESS-FORMAT  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ADDRESS-FORMAT TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDRESS-FORMAT,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ADDRESS-FORMAT,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                   TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSFLT8                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ADDRESS-ID      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ADDRESS-ID     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDRESS-ID,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ADDRESS-ID,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                   TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSFLT8                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-DEPOSITS        TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-DEPOSITS       TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEPOSITS,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DEPOSITS,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-CRED-REF-IND      TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-CRED-REF-IND     TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CRED-REF-IND,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CRED-REF-IND,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-LOC-OFFICE-IND    TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-LOC-OFFICE-IND   TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LOC-OFFICE-IND,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LOC-OFFICE-IND,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-HOUSE-NO     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-HOUSE-NO    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-HOUSE-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-HOUSE-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-FO-ADDR-PREFIX-1  TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-FO-ADDR-PREFIX-1 TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ADDR-PREFIX-1,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ADDR-PREFIX-1,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-FO-ADDR-PREFIX-2  TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-FO-ADDR-PREFIX-2 TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ADDR-PREFIX-2,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ADDR-PREFIX-2,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-STREET-NAME  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-STREET-NAME TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-STREET-NAME,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-STREET-NAME,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-FO-STREET-SUFFIX  TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-FO-STREET-SUFFIX TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-STREET-SUFFIX,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-STREET-SUFFIX,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-ADDR-SUFFIX  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-ADDR-SUFFIX TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ADDR-SUFFIX,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ADDR-SUFFIX,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                  TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-FO-STREET-LOCATION-1  TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-FO-STREET-LOCATION-1 TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-STREET-LOCATION-1,                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-STREET-LOCATION-1,                      
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                  TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-FO-STREET-LOCATION-2  TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-FO-STREET-LOCATION-2 TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-STREET-LOCATION-2,                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-STREET-LOCATION-2,                      
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                 TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-FO-ADDRESS-OVERFLOW  TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-FO-ADDRESS-OVERFLOW TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ADDRESS-OVERFLOW,                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ADDRESS-OVERFLOW,                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-ZIP-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-ZIP-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ZIP-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ZIP-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                 TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-FO-ZIP-CODE-PL-FOUR  TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-FO-ZIP-CODE-PL-FOUR TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-ZIP-CODE-PL-FOUR,                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-ZIP-CODE-PL-FOUR,                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-FO-CARRIER-ROUTE   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-FO-CARRIER-ROUTE  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-CARRIER-ROUTE,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-CARRIER-ROUTE,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-TOWN         TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-TOWN        TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-TOWN,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-TOWN,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FO-STATE        TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FO-STATE       TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FO-STATE,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FO-STATE,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FR-ADDR-STREET  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FR-ADDR-STREET TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FR-ADDR-STREET,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FR-ADDR-STREET,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                 TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-FR-ADDRESS-OVERFLOW  TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-FR-ADDRESS-OVERFLOW TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FR-ADDRESS-OVERFLOW,                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FR-ADDRESS-OVERFLOW,                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FR-CITY-STATE   TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FR-CITY-STATE  TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FR-CITY-STATE,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FR-CITY-STATE,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FR-ZIP-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FR-ZIP-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FR-ZIP-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FR-ZIP-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FR-COUNTRY      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FR-COUNTRY     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FR-COUNTRY,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FR-COUNTRY,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-BYPASS-CODE1    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-BYPASS-CODE1   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BYPASS-CODE1,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BYPASS-CODE1,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-BILL-ADDR       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-BILL-ADDR      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BILL-ADDR,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BILL-ADDR,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ZIP-CODE-TOKEN  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ZIP-CODE-TOKEN TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ZIP-CODE-TOKEN,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ZIP-CODE-TOKEN,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-LC-EXISTS         TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-LC-EXISTS        TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LC-EXISTS,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LC-EXISTS,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-ACCT-STATUS       TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-ACCT-STATUS      TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCT-STATUS,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCT-STATUS,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS  7000-SELECT-ADDR-FRMT                               *        
      *            7200-SELECT-ADDR-ID                                 *        
      *            7220-SELECT-ADDR-FORM                               *        
      *            7240-SELECT-TOWN-ST                                 *        
      *            7260-SELECT-ADDR-FREE                               *        
      *            2500-PROCES-NAME-ID                                 *        
      *            2600-SEND-ADDR-FORM                                 *        
      *            2620-SEND-ADDR-FREE                                 *        
      *            2640-SEND-ADDR-NONE                                 *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2400-BUILD-RESULT.                                               
                                                                        
           MOVE '2400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7320-SELECT-LC THRU 7320-EXIT.                       
SOREAR*    IF WS-LC-EXISTS > 0                                                  
SOREAR*       MOVE 'Y' TO RS-LC-EXISTS                                          
SOREAR*    END-IF.                                                              
                                                                        
                                                                        
           PERFORM 7310-SELECT-DEP-ON-HAND      THRU 7310-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-DEPOSITS                  TO RS-DEPOSITS          
           ELSE                                                         
              MOVE ZERO                         TO RS-DEPOSITS          
           END-IF.                                                      
                                                                        
           PERFORM 7000-SELECT-ADDR-FRMT        THRU 7000-EXIT.         
           MOVE AT-ADDRESS-FORMAT            TO WS-ADDRESS-FORMAT.      
           MOVE WS-ACCT-STATUS               TO RS-ACCT-STATUS.         
                                                                        
                                                                        
           IF WS-ADDRESS-FORMAT = ' '                                   
              MOVE ZERO                         TO WS-ADDRESS-ID        
              PERFORM 2640-SEND-ADDR-NONE                               
           ELSE                                                         
              MOVE AT-ADDRESS-ID                TO WS-ADDRESS-ID        
              MOVE WS-ADDRESS-ID                TO WS-ADDRESS-ID-S      
           END-IF.                                                      
                                                                        
           MOVE SPACE                           TO RS-LOC-OFFICE-IND    
                                                   RS-CRED-REF-IND      
                                                   RS-BYPASS-CODE1.     
                                                                        
           MOVE 'Y'                             TO RS-BILL-ADDR.        
                                                                        
           IF WS-ADDRESS-FORMAT = 'A'                                   
              PERFORM 7220-SELECT-ADDR-FORM     THRU 7220-EXIT          
              MOVE DY-ZIP-CODE                  TO WS-ZIP-CODE          
              MOVE DY-ZIP-CODE-TOKEN            TO WS-ZIP-CODE-TOKEN    
              PERFORM 7240-SELECT-TOWN-ST       THRU 7240-EXIT          
              PERFORM 2600-SEND-ADDR-FORM       THRU 2600-EXIT          
           ELSE IF WS-ADDRESS-FORMAT = 'B'                              
              PERFORM 7260-SELECT-ADDR-FREE     THRU 7260-EXIT          
              PERFORM 2620-SEND-ADDR-FREE       THRU 2620-EXIT          
           END-IF
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-SEND-ADDR-FORM                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS THE FORMATTED BILLING ADDRESS RESULT SET.            *        
      ******************************************************************        
                                                                        
       2600-SEND-ADDR-FORM.                                             
                                                                        
           MOVE '2600'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-NUM          TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE DY-HOUSE-NO                TO RS-FO-HOUSE-NO.           
           MOVE DY-ADDR-PREFIX-1           TO RS-FO-ADDR-PREFIX-1.      
           MOVE DY-ADDR-PREFIX-2           TO RS-FO-ADDR-PREFIX-2.      
           MOVE DY-STREET-NAME             TO RS-FO-STREET-NAME.        
           MOVE DY-STREET-SUFFIX           TO RS-FO-STREET-SUFFIX.      
           MOVE DY-ADDR-SUFFIX             TO RS-FO-ADDR-SUFFIX.        
           MOVE DY-STREET-LOCATION-1       TO RS-FO-STREET-LOCATION-1.  
           MOVE DY-STREET-LOCATION-2       TO RS-FO-STREET-LOCATION-2.  
           MOVE DY-ADDRESS-OVERFLOW        TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE DY-ZIP-CODE                TO RS-FO-ZIP-CODE.           
           MOVE DY-ZIP-CODE-PLUS-FOUR      TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE DY-CARRIER-ROUTE           TO RS-FO-CARRIER-ROUTE.      
           MOVE DY-ZIP-CODE-TOKEN          TO RS-ZIP-CODE-TOKEN.        
           MOVE A4-TOWN                    TO RS-FO-TOWN.               
           MOVE A4-STATE                   TO RS-FO-STATE.              
           MOVE SPACES                     TO RS-FR-ADDR-STREET.        
           MOVE SPACES                     TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FR-CITY-STATE.         
           MOVE SPACES                     TO RS-FR-ZIP-CODE.           
           MOVE SPACES                     TO RS-FR-COUNTRY.            
                                                                        
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2620-SEND-ADDR-FREE                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS THE FREEFORM BILLING ADDRESS RESULT SET.             *        
      ******************************************************************        
                                                                        
       2620-SEND-ADDR-FREE.                                             
                                                                        
           MOVE '2620'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-NUM          TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE SPACES                     TO RS-FO-HOUSE-NO.           
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-1.      
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-2.      
           MOVE SPACES                     TO RS-FO-STREET-NAME.        
           MOVE SPACES                     TO RS-FO-STREET-SUFFIX.      
           MOVE SPACES                     TO RS-FO-ADDR-SUFFIX.        
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-1.  
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-2.  
           MOVE SPACES                     TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE.           
           MOVE SPACES                     TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE SPACES                     TO RS-FO-CARRIER-ROUTE.      
           MOVE SPACES                     TO RS-ZIP-CODE-TOKEN.        
           MOVE SPACES                     TO RS-FO-TOWN.               
           MOVE SPACES                     TO RS-FO-STATE.              
           MOVE DZ-ADDR-STREET             TO RS-FR-ADDR-STREET.        
           MOVE DZ-ADDRESS-OVERFLOW        TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE DZ-ADDR-CITY-STATE         TO RS-FR-CITY-STATE.         
           MOVE DZ-ADDR-ZIP-CODE           TO RS-FR-ZIP-CODE.           
           MOVE DZ-ADDR-COUNTRY            TO RS-FR-COUNTRY.            
                                                                        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2640-SEND-ADDR-NONE                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE RESULT SET.                           *        
      *     THAT IS, AN ACCOUNT BILLING ADDRESS DOES NOT EXIST.        *        
      ******************************************************************        
                                                                        
       2640-SEND-ADDR-NONE.                                             
                                                                        
           MOVE '2640'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-NUM          TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE SPACES                     TO RS-FO-HOUSE-NO.           
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-1.      
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-2.      
           MOVE SPACES                     TO RS-FO-STREET-NAME.        
           MOVE SPACES                     TO RS-FO-STREET-SUFFIX.      
           MOVE SPACES                     TO RS-FO-ADDR-SUFFIX.        
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-1.  
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-2.  
           MOVE SPACES                     TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE.           
           MOVE SPACES                     TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE SPACES                     TO RS-FO-CARRIER-ROUTE.      
           MOVE SPACES                     TO RS-ZIP-CODE-TOKEN.        
           MOVE SPACES                     TO RS-FO-TOWN.               
           MOVE SPACES                     TO RS-FO-STATE.              
           MOVE SPACES                     TO RS-FR-ADDR-STREET.        
           MOVE SPACES                     TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FR-CITY-STATE.         
           MOVE SPACES                     TO RS-FR-ZIP-CODE.           
           MOVE SPACES                     TO RS-FR-COUNTRY.            
                                                                        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ADDR-FRMT                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE ADDRESS FORMAT INTO WORKING STORAGE.          *        
      ******************************************************************        
                                                                        
       7000-SELECT-ADDR-FRMT.                                           
                                                                        
           MOVE '7000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDRESS_FORMAT,
              CODE_ACCT_STAT,
              ADDRESS_ID                                        
              INTO    :AT-ADDRESS-FORMAT,                               
                      :WS-ACCT-STATUS,                                  
                      :AT-ADDRESS-ID                                    
              FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                         
              WHERE   ACCOUNT_NO                = :WS-ACCOUNT-NO-NUM    
SOREAR                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ADDRESS_FORMAT,                                           
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               ADDRESS_ID                                                
MFA-TR*       INTO    :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :WS-ACCT-STATUS,                                          
MFA-TR*               :AT-ADDRESS-ID                                            
MFA-TR*       FROM    CSS_ACCOUNT                                               
MFA-TR*       WHERE   ACCOUNT_NO                = :WS-ACCOUNT-NO-NUM            
MFA-TR*       FETCH FIRST 1 ROWS ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCOUNT'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO-NUM            TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7220-SELECT-ADDR-FORM                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE FORMATTED ADDRESS DETAILS.                    *        
      ******************************************************************        
                                                                        
       7220-SELECT-ADDR-FORM.                                           
                                                                        
           MOVE '7220'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ADDRESS_OVERFLOW,
              ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              ZIP_CODE_TOKEN,
              CARRIER_ROUTE                                     
              INTO    :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-CARRIER-ROUTE                                 
              FROM    CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
SOREAR                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               CARRIER_ROUTE                                             
MFA-TR*       INTO    :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-CARRIER-ROUTE                                         
MFA-TR*       FROM    CSS_ADDR_FORMATTED                                        
MFA-TR*       WHERE   ADDRESS_ID                = :WS-ADDRESS-ID                
MFA-TR*       FETCH FIRST 1 ROWS ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7240-SELECT-TOWN-ST                                            *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE TOWN AND STATE FOR A GIVEN ZIP CODE.          *        
      ******************************************************************        
                                                                        
       7240-SELECT-TOWN-ST.                                             
                                                                        
           MOVE '7240'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) TOWN,
              STATE                                             
              INTO    :A4-TOWN,                                         
                      :A4-STATE                                         
              FROM    CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
              WHERE   ZIP_CODE                  = :WS-ZIP-CODE          
              AND     ZIP_CODE_TOKEN            = :WS-ZIP-CODE-TOKEN    
SOREAR                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*       INTO    :A4-TOWN,                                                 
MFA-TR*               :A4-STATE                                                 
MFA-TR*       FROM    CSS_ZIP_CODE                                              
MFA-TR*       WHERE   ZIP_CODE                  = :WS-ZIP-CODE                  
MFA-TR*       AND     ZIP_CODE_TOKEN            = :WS-ZIP-CODE-TOKEN            
MFA-TR*       FETCH FIRST 1 ROWS ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ZIP_CODE'               TO TABLE-1              
              MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-1      
              MOVE 'ZIP_CODE_TOKEN'             TO TABLE-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-3      
              MOVE WS-ZIP-CODE                  TO HOSTVAR-ELEMENT-1    
              MOVE WS-ZIP-CODE-TOKEN            TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-SELECT-ADDR-FREE                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE FREEFORM ADDRESS DETAILS.                     *        
      ******************************************************************        
                                                                        
       7260-SELECT-ADDR-FREE.                                           
                                                                        
           MOVE '7260'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                      
              INTO    :DZ-ADDR-STREET,                                  
                      :DZ-ADDRESS-OVERFLOW,                             
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY                                  
              FROM    CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
SOREAR                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ADDR_STREET,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_CITY_STATE,                                          
MFA-TR*               ADDR_ZIP_CODE,                                            
MFA-TR*               ADDR_COUNTRY                                              
MFA-TR*       INTO    :DZ-ADDR-STREET,                                          
MFA-TR*               :DZ-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DZ-ADDR-CITY-STATE,                                      
MFA-TR*               :DZ-ADDR-ZIP-CODE,                                        
MFA-TR*               :DZ-ADDR-COUNTRY                                          
MFA-TR*       FROM    CSS_ADDR_FREEFORM                                         
MFA-TR*       WHERE   ADDRESS_ID                = :WS-ADDRESS-ID                
MFA-TR*       FETCH FIRST 1 ROWS ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-SELECT-DEP-ON-HAND                                        *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE DEPOSIT AMOUNT.                               *        
      ******************************************************************        
       7310-SELECT-DEP-ON-HAND.                                         
                                                                        
           MOVE '7310'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :WS-DEPOSITS :WS-NULL-IND-1                         
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
PCR482           AND (DEPOSIT_STATUS_CD = 'A'                           
PCR482            OR DEPOSIT_STATUS_CD  = 'P')                          
SOREAR                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*         INTO :WS-DEPOSITS:WS-NULL-IND-1                                 
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM                    
MFA-TR*          AND (DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*           OR DEPOSIT_STATUS_CD  = 'P')                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1 < ZERO                                   
                  MOVE ZERO                     TO WS-DEPOSITS          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_DEP_ON_HAND'            TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO-NUM            TO HOSTVAR-ELEMENT-1    
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SELECT-LC                                                 *        
      *                                                                *        
      * CALLS 9000-SEND-ERROR-RESULT                                   *        
      *       9900-SQL-ERROR-ROUTINE                                   *        
      *                                                                *        
      * CALLED FROM 2400-BUILD-RESULT                                  *        
      *                                                                *        
      * CHECK TO SEE IF LIGHTING CONTRACT INFO EXISTS.                 *        
      ******************************************************************        
                                                                        
       7320-SELECT-LC.                                                  
                                                                        
           MOVE '7320' TO ACTIVE-PARAGRAPH.                             
                                                                        
SOREAR     EXEC SQL                                                     
SOREAR      SELECT 'Y'                                                  
SOREAR      INTO :RS-LC-EXISTS                                          
SOREAR      FROM CSS_BILL_CONTRACT WITH(READUNCOMMITTED)                        
SOREAR      WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                       
SOREAR         AND CODE_UTIL_TYPE = 'U'                                 
SOREAR         AND CNTRCT_END_DT > CAST(SYSDATETIMEOFFSET() AS DATE)            
SOREAR                                                           
SOREAR     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT 'Y'                                                          
MFA-TR*     INTO :RS-LC-EXISTS                                                  
MFA-TR*     FROM CSS_BILL_CONTRACT                                              
MFA-TR*     WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                               
MFA-TR*        AND CODE_UTIL_TYPE = 'U'                                         
MFA-TR*        AND CNTRCT_END_DT > CURRENT DATE                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE 'SELECT'                  TO ABEND-FUNCTION          
CBSI          MOVE SPACES                    TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
              MOVE 'CSS_BILL_CONTRACT'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02123_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,ACCOUNT_NO                                                
CVT000       ,ADDRESS_FORMAT                                            
CVT000       ,ADDRESS_ID                                                
CVT000       ,DEPOSITS                                                  
CVT000       ,CRED_REF_IND                                              
CVT000       ,LOC_OFFICE_IND                                            
CVT000       ,FO_HOUSE_NO                                               
CVT000       ,FO_ADDR_PREFIX_1                                          
CVT000       ,FO_ADDR_PREFIX_2                                          
CVT000       ,FO_STREET_NAME                                            
CVT000       ,FO_STREET_SUFFIX                                          
CVT000       ,FO_ADDR_SUFFIX                                            
CVT000       ,FO_STREET_LOCATIO1                                        
CVT000       ,FO_STREET_LOCATIO2                                        
CVT000       ,FO_ADDRESS_OVERFLO                                        
CVT000       ,FO_ZIP_CODE                                               
CVT000       ,FO_ZIP_CODE_PL_FOU                                        
CVT000       ,FO_CARRIER_ROUTE                                          
CVT000       ,FO_TOWN                                                   
CVT000       ,FO_STATE                                                  
CVT000       ,FR_ADDR_STREET                                            
CVT000       ,FR_ADDRESS_OVERFLO                                        
CVT000       ,FR_CITY_STATE                                             
CVT000       ,FR_ZIP_CODE                                               
CVT000       ,FR_COUNTRY                                                
CVT000       ,BYPASS_CODE1                                              
CVT000       ,BILL_ADDR                                                 
CVT000       ,ZIP_CODE_TOKEN                                            
CVT000       ,LC_EXISTS                                                 
CVT000       ,ACCT_STATUS                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-ACCOUNT-NO                                            
CVT000       ,:RS-ADDRESS-FORMAT                                        
CVT000       ,:RS-ADDRESS-ID                                            
CVT000       ,:RS-DEPOSITS                                              
CVT000       ,:RS-CRED-REF-IND                                          
CVT000       ,:RS-LOC-OFFICE-IND                                        
CVT000       ,:RS-FO-HOUSE-NO                                           
CVT000       ,:RS-FO-ADDR-PREFIX-1                                      
CVT000       ,:RS-FO-ADDR-PREFIX-2                                      
CVT000       ,:RS-FO-STREET-NAME                                        
CVT000       ,:RS-FO-STREET-SUFFIX                                      
CVT000       ,:RS-FO-ADDR-SUFFIX                                        
CVT000       ,:RS-FO-STREET-LOCATION-1                                  
CVT000       ,:RS-FO-STREET-LOCATION-2                                  
CVT000       ,:RS-FO-ADDRESS-OVERFLOW                                   
CVT000       ,:RS-FO-ZIP-CODE                                           
CVT000       ,:RS-FO-ZIP-CODE-PL-FOUR                                   
CVT000       ,:RS-FO-CARRIER-ROUTE                                      
CVT000       ,:RS-FO-TOWN                                               
CVT000       ,:RS-FO-STATE                                              
CVT000       ,:RS-FR-ADDR-STREET                                        
CVT000       ,:RS-FR-ADDRESS-OVERFLOW                                   
CVT000       ,:RS-FR-CITY-STATE                                         
CVT000       ,:RS-FR-ZIP-CODE                                           
CVT000       ,:RS-FR-COUNTRY                                            
CVT000       ,:RS-BYPASS-CODE1                                          
CVT000       ,:RS-BILL-ADDR                                             
CVT000       ,:RS-ZIP-CODE-TOKEN                                        
CVT000       ,:RS-LC-EXISTS                                             
CVT000       ,:RS-ACCT-STATUS                                           
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02123_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,ADDRESS_FORMAT                                                    
MFA-TR*      ,ADDRESS_ID                                                        
MFA-TR*      ,DEPOSITS                                                          
MFA-TR*      ,CRED_REF_IND                                                      
MFA-TR*      ,LOC_OFFICE_IND                                                    
MFA-TR*      ,FO_HOUSE_NO                                                       
MFA-TR*      ,FO_ADDR_PREFIX_1                                                  
MFA-TR*      ,FO_ADDR_PREFIX_2                                                  
MFA-TR*      ,FO_STREET_NAME                                                    
MFA-TR*      ,FO_STREET_SUFFIX                                                  
MFA-TR*      ,FO_ADDR_SUFFIX                                                    
MFA-TR*      ,FO_STREET_LOCATIO1                                                
MFA-TR*      ,FO_STREET_LOCATIO2                                                
MFA-TR*      ,FO_ADDRESS_OVERFLO                                                
MFA-TR*      ,FO_ZIP_CODE                                                       
MFA-TR*      ,FO_ZIP_CODE_PL_FOU                                                
MFA-TR*      ,FO_CARRIER_ROUTE                                                  
MFA-TR*      ,FO_TOWN                                                           
MFA-TR*      ,FO_STATE                                                          
MFA-TR*      ,FR_ADDR_STREET                                                    
MFA-TR*      ,FR_ADDRESS_OVERFLO                                                
MFA-TR*      ,FR_CITY_STATE                                                     
MFA-TR*      ,FR_ZIP_CODE                                                       
MFA-TR*      ,FR_COUNTRY                                                        
MFA-TR*      ,BYPASS_CODE1                                                      
MFA-TR*      ,BILL_ADDR                                                         
MFA-TR*      ,ZIP_CODE_TOKEN                                                    
MFA-TR*      ,LC_EXISTS                                                         
MFA-TR*      ,ACCT_STATUS                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-ACCOUNT-NO                                                    
MFA-TR*      ,:RS-ADDRESS-FORMAT                                                
MFA-TR*      ,:RS-ADDRESS-ID                                                    
MFA-TR*      ,:RS-DEPOSITS                                                      
MFA-TR*      ,:RS-CRED-REF-IND                                                  
MFA-TR*      ,:RS-LOC-OFFICE-IND                                                
MFA-TR*      ,:RS-FO-HOUSE-NO                                                   
MFA-TR*      ,:RS-FO-ADDR-PREFIX-1                                              
MFA-TR*      ,:RS-FO-ADDR-PREFIX-2                                              
MFA-TR*      ,:RS-FO-STREET-NAME                                                
MFA-TR*      ,:RS-FO-STREET-SUFFIX                                              
MFA-TR*      ,:RS-FO-ADDR-SUFFIX                                                
MFA-TR*      ,:RS-FO-STREET-LOCATION-1                                          
MFA-TR*      ,:RS-FO-STREET-LOCATION-2                                          
MFA-TR*      ,:RS-FO-ADDRESS-OVERFLOW                                           
MFA-TR*      ,:RS-FO-ZIP-CODE                                                   
MFA-TR*      ,:RS-FO-ZIP-CODE-PL-FOUR                                           
MFA-TR*      ,:RS-FO-CARRIER-ROUTE                                              
MFA-TR*      ,:RS-FO-TOWN                                                       
MFA-TR*      ,:RS-FO-STATE                                                      
MFA-TR*      ,:RS-FR-ADDR-STREET                                                
MFA-TR*      ,:RS-FR-ADDRESS-OVERFLOW                                           
MFA-TR*      ,:RS-FR-CITY-STATE                                                 
MFA-TR*      ,:RS-FR-ZIP-CODE                                                   
MFA-TR*      ,:RS-FR-COUNTRY                                                    
MFA-TR*      ,:RS-BYPASS-CODE1                                                  
MFA-TR*      ,:RS-BILL-ADDR                                                     
MFA-TR*      ,:RS-ZIP-CODE-TOKEN                                                
MFA-TR*      ,:RS-LC-EXISTS                                                     
MFA-TR*      ,:RS-ACCT-STATUS                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02123_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02123_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02123_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
