       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02122.                                         
COB303 DATE-WRITTEN.     JUL 06, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S122 CONVERTED TO DB2 SP CSR02122 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S122                                           *        
      *  PROGRAM:       S122                                           *        
      *  CALLING SP:    PA_S122                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM UPDATES FLAGS ON CSS_ACCOUNT AND                 *        
      *  CSS_CREDIT_PROFILE.                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/06/95    RC       CREATED.                                 *        
      *  06/03/96    WMG      TPR 3971 - MODIFIED PARAGRAPH 8300 TO    *        
      *                       INCLUDE ALL PERMUTATIONS OF ORDER REASON *        
      *                       AND CANCEL REASON WHEN WRITING TO CREDIT *        
      *                       PROFILE.                                 *        
PCR360*  09/26/96    JTH      PCR360 - MOD FOR NEW ORDER REASON CODE   *        
PCR360*                       AND ACCEPT UPDATE_PROFILE PARM           *        
      *  01/27/97    WMG      TPR 8807 - SKIP ACCOUNT FUNCTIONALITY    *        
      *                       WHEN PROCESSING PREMISE ONLY ORDERS.     *        
T15560*  03/27/98    FB       CHANGED PROGRAM-NAME VARAIBLE FROM       *        
T15560*                       S210 TO S122.                            *        
T16122*  04/27/98    FB       ADDED DATE THE THE ABEND DISPLAYS IN     *        
T16122*                       8400-.                                   *        
T16303*  08/04/98    FB       REASON-NOT-DNP SET TO 'C' WHEN PANEL     *        
T16303*                       NUMBER IS U100.                          *        
CBSI  *  08/14/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
T19006*  02/16/99    FB       RESET PRORATE_CD WHEN A DNP IS           *        
T19006*                       CANCELLED.                               *        
T23235*  05/09/01    PRA      ADD ORDER_TYPE AS A PARAMETER            *        
T23235*  07/09/01    LEF      ADD "NOT" PROCESSING                     *        
T30876*  07/11/04    GOKUL    DO NOT INSERT MANUALLY CANCELLED DNPFB'S *        
T30876*                       INTO CSS_DNP_NOT_WORKED TABLE.           *        
T32480*  05/19/05    JIJU     GET CODE VALUES FOR DISCONNECT HISTORY   *        
T32480*                       FROM  CSS_DNP_CANCEL_RSN INSTEAD OF HARD *        
T32480*                       CODED CONSTANTS.                         *        
C32930*  08/08/05    MDJ      DO NOT UPDATE CREDIT HISTORIES IF VALUE  *        
C32930*                       IS A '4' (DNP POSTED).                   *        
C33147*  08/29/05    SS82048  1. UPDATE CANCEL REASON AS 'S' WHEN      *        
      *                          STA PANEL 300 CANCELS DNP.            *        
      *                       2. FOR SEB SONPS CANCELED BY PBTRANSDRIVR*        
      *                          STORE CANCEL REASON AS 'T' WHEN       *        
      *                          PANEL NO PASSED IS RMCL OR DERR.      *        
      *                       3. STOP DNPFB CANCELS GETTING INSERTED   *        
      *                          TO CSS_DNP_NOT_WORKED.                *        
      *                       4. FOR DNPS CANCELED BY CUSTOMER CHANGE/ *        
      *                          OFF/RECONNECT ORDER POSTING STORE     *        
      *                          CANCEL REASON AS 'C' SYSTEM CANCELED  *        
C35517*  03/20/07    AW41078  FIXING REARCH CHANGES.  CSR00206 CALLED  *        
C35517*                       AS IF IT WILL RETURN MULT RESULT SETS    *        
C35517*                       EVEN THOUGH IT RETURNS NONE. THIS IS     *        
C35517*                       CAUSING CSR02122 TO FAIL EVERY TIME      *        
C35517*                       CSR00206 IS CALLED.                      *        
A01016*  06/25/09    AW41078  DNP CANCEL CLEANUP -                     *        
A01016*                       1. DNPS CANCELED DUE TO POSTING OF CC, OC*        
A01016*                       OFF, OR RECON WILL HAVE CANCEL_RSN_CD AND*        
A01016*                       REASON_NOT_DNP OF 'P'/SERVICE ORDER      *        
A01016*                       POSTED.                                  *        
A01016*                       2. REMOVING LOGIC WHICH RECORDS DNPS     *        
A01016*                       CANCELED DUE TO STA SETUP IN CSS_DNP_NOT_*        
A01016*                       WORKED.                                  *        
A01016*                       3. PREVENT CREDIT PROFILE FROM GETTING   *        
A01016*                       UPDATED WHEN IT WAS A DNPFB NOT A DNP01  *        
A01016*                       THAT WAS CANCELED.                       *        
A01016*                       4. PREVENT DNPFB CANCELS FROM GETTING    *        
A01016*                       INSERTED INTO CSS_DNP_NOT_WORKED.        *        
A01016*                       5.  ADD LOGIC TO RECORD ALL MANUAL DNP01 *        
A01016*                       CANCELS REGARDLESS OF RESOLVED CODE IN   *        
A01016*                       CSS_DNP_NOT_WORKED.                      *        
A01016*                       6.  INCORPORATE NEW REMARK_TX COLUMN INTO*        
A01016*                       CSS_DNP_NOT_WORKED INSERT.               *        
A01016*                       7.  REMOVING CODE WHICH SETS REASON NOT  *        
A01016*                       DNP TO 'C' WHEN PANEL-NO IS U100         *        
A00976*  11/11/09    FB       DON'T SET PRORATE_CD FOR CC/OC/OFF       *        
A01016*  11/16/09    FB       REMOVE DERR AND RMCL CANCEL REASON       *        
P00471*  04/18/11    PK98692  CHANGES TO ADD RESCHEDULED DNP WHEN      *        
P00471*                       DNP01 (NORMAL OR NORMAL W/RET CHECK)     *        
P00471*                       IS CANCELLED MANUALLY WITH A CANCEL      *        
P00471*                       REASON OF WEATHER AND WORKLOAD; AND      *        
P00471*                       CANCELLED BY SYSTEM WITH A CANCEL REASON *        
P00471*                       OF EXPIRED. FOR SCEG/PSNC ONLY           *        
P00471*  08/02/11    PK98692  DPP DROP CHANGES-ADD 4 NEW ORDER REASONS *        
P00471*                       J-NORMAL DPP, K-NORM DPP W/ RET CHK,     *        
P00471*                       U-DROPPED DPP,V-DROPPED DPP W/RET CHK    *        
P00471*                       IN FOLLOWING PARAS :                     *        
P00471*                       8300-UPDATE-CRED-PROFILE                 *        
P00471*                       8310-INSERT-DNPNW                        *        
ACT057*  03/08/17    RS7V450  DELETE TABLES CSS_DNP,CSS_DNP_NOT_WORKED.*        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02122'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S122 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                                     
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CREDIT_PROFILE >                                    
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_PREMISE        >                                    
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
T19006*-------< INCLUDE CSS_BILLING_DET >                                       
           EXEC SQL                                                             
T19006        INCLUDE TBBLLDET                                                  
T19006     END-EXEC.                                                            
T19006*-------< INCLUDE CSS_BILLING_HDR >                                       
T19006     EXEC SQL                                                             
T19006        INCLUDE TBBLLHDR                                                  
T19006     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
T32480******************************************************************        
T32480* CSS_DNP_CANCEL_RSN, DC                                         *        
T32480******************************************************************        
T32480     EXEC SQL                                                             
T32480        INCLUDE TBDNPRSN                                                  
T32480     END-EXEC.                                                            
                                                                        
POO471******************************************************************        
P00471* CSS_HOLIDAY                                                    *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBHLDAY                                                   
P00471     END-EXEC.                                                            
P00471                                                                  
                                                                        
P00471******************************************************************        
P00471* CSS_READ_WINDOW                                                *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBRDWNDW                                                  
P00471     END-EXEC.                                                            
P00471                                                                  
                                                                        
P00471******************************************************************        
P00471* CSS_CRED_COLL                                                  *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBCRCOLL                                                  
P00471     END-EXEC.                                                            
P00471                                                                  
                                                                        
P00471******************************************************************        
P00471* CSS_MT_TRN_HST_DET                                             *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBMNHDT                                                   
P00471     END-EXEC.                                                            
P00471                                                                  
                                                                        
P00471******************************************************************        
P00471* CSS_MNT_TRANS_HIST                                             *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBMNHIST                                                  
P00471     END-EXEC.                                                            
P00471                                                                  
                                                                        
P00471******************************************************************        
P00471* CSS_COMM_DATA                                                  *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBCOMDAT                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_AR_CNTL                                                    *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBARCNTL                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_AR_TRANS_HIST                                              *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBARHIST                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_DFA_ACCT                                                   *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBDFAACT                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_NSF_HIST                                                   *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBNSFHST                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_LOCAL_OFFICE                                               *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBLOCOFC                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_FINAL_WO                                                   *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBFINLWO                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_CHRG_OFF                                                   *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBCHGOFF                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_CUST_ALERT                                                 *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBCSTALT                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_UTIL_ENVRNMT                                               *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBUTLENV                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_DELINQUENCY                                                *        
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBDELQ                                                    
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_AR_TRN_HST_DET                                                      
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBARHDT                                                   
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_REG_PROFILE                                                         
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBREGPRF                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_BILL_WINDOW                                                         
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBBILWDW                                                  
A05020     END-EXEC.                                                            
                                                                        
P00471******************************************************************        
P00471* CSS_FIN_WO_ACTION                                                       
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE TBFWACTN                                                  
P00471     END-EXEC.                                                            
P00471******************************************************************        
P00471*--------< WORKING STORAGE TO SUPPORT CPD00068 >                          
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE CWS00068                                                  
P00471     END-EXEC.                                                            
P00471******************************************************************        
P00471*--------< WORKING STORAGE TO SUPPORT CPD00335 >                          
P00471******************************************************************        
P00471     EXEC SQL                                                             
P00471        INCLUDE CWS00335                                                  
P00471     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *--------< CODES DATA PRESENT ON CSS_ACCOUNT   >                          
           COPY CWS00056.                                                       
      *--------< LINKAGE SECTION FOR MCSCB068        >                          
           COPY CWS0068L.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
T15560     05  PROGRAM-NAME            PIC X(08) VALUE 'S122    '.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                       PIC S9(13).                      
           05  PARM-PREMISE-NO         PIC X(10).                       
           05  PARM-PREMISE-NO-NUM REDEFINES PARM-PREMISE-NO            
                                       PIC S9(10).                      
           05  PARM-ORDER-REASON       PIC X(1).                        
           05  PARM-CANCEL-REASON      PIC X(1).                        
           05  PARM-PENDING-SO-FLAG    PIC X(1).                        
PCR360     05  PARM-UPDATE-PROFILE     PIC X(1).                        
           05  PARM-AMOUNT-DISC-BAL    PIC X(11).                       
REARCH*    05  PARM-AMOUNT-DISC-BAL-N REDEFINES PARM-AMOUNT-DISC-BAL            
REARCH*                                PIC S9(9)V99.                            
           05  PARM-PANEL-NO           PIC X(04).                       
T23235     05  PARM-ORDER-TYPE-CD      PIC X(05).                       
           05  PARM-SO-OFF-DATE        PIC X(10).                       
A01016     05  PARM-REMARK-TX.                                          
A01016         49 PARM-REMARK-TX-LEN   PIC S9(4) USAGE COMP VALUE 0.    
A01016         49 PARM-REMARK-TX-TEXT  PIC X(210) VALUE SPACES.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-AMOUNT-DISC-BAL        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY        PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-DATE-MM          PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-DATE-DD          PIC X(02) VALUE SPACES.          
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-DATE2-DD         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-DATE2-CCYY       PIC X(04) VALUE SPACES.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH*01  LOC1            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
P00471     05  WS-PROGRAM              PIC X(08) VALUE 'CSR02122'.      
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.         
COB305     05 WS-PREMISE-NO        PIC S9(10) USAGE COMP-3 VALUE 0.         
           05  WS-NULL-INDICATOR       PIC S9(4) USAGE COMP VALUE 0.    
T19006     05  WS-NULL-INDICATOR-2     PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-CODES-PRESENT        PIC X(32) VALUE SPACES.          
           05  WS-DISC-HIST            PIC X(24) VALUE SPACES.          
           05  WS-DISC-EXCEPTN-HIST    PIC X(24) VALUE SPACES.          
           05  WS-UPDATE-PROFILE       PIC X(01) VALUE SPACES.          
           05  WS-PENDING-SO-FLAG      PIC X(01) VALUE SPACES.          
T23235     05  WS-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.          
           05  WS-SO-OFF-DATE          PIC X(10) VALUE SPACES.          
           05  WS-CALLED-FROM-UCSSO100 PIC X(04) VALUE 'U100'.          
           05  WS-CHECK-BILL-DATE      PIC X(03) VALUE 'CHK'.           
P00471     05  WS-CALLED-FROM-PANEL16  PIC X(03) VALUE '016'.           
P00471     05  WS-CALLED-FROM-PANEL75  PIC X(03) VALUE '075'.           
P00471     05  WS-CALLED-FROM-PCSSO103 PIC X(04) VALUE 'P103'.          
           05  WS-NO-OF-DAYS           PIC S9(4) COMP.                  
           05  WS-AT-BILLED-TODAY      PIC S9(4) COMP VALUE 0.          
           05  WS-AT-BILLED-YESTERDAY  PIC S9(4) COMP VALUE -1.         
A00976     05  WS-UPDATE-PRORATE-CD    PIC X(01) VALUE 'N'.             
P00471     05  WS-MIN-DATE-EXTRACT     PIC X(10) VALUE SPACES.          
P00471     05  WS-ADJ-DAY              PIC S9(9) COMP VALUE 0.          
P00471     05  WS-WORK-DATE            PIC X(10) VALUE SPACES.          
P00471     05  WS-CPD00335-ABEND-CODE  PIC S9(9) COMP VALUE 4000.       
P00471* WS VARIABLES USED IN CPD00310  ***                                      
P00471     05  WS-NULL-IND-CPD       PIC S9(4) USAGE COMP VALUE 0.      
P00471     05  WS-CPD310-NULL-IND    PIC S9(4) USAGE COMP VALUE 0.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
P00471     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
P00471         88  CSR-DATABASE                  VALUE 1.               
P00471         88  SEB-DATABASE                  VALUE 2.               
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-ORDER-REASON        PIC X(1)                 .          
CVT000 01  LINK-CANCEL-REASON       PIC X(1)                 .          
CVT000 01  LINK-PENDING-SO-FLAG     PIC X(1)                 .          
CVT000 01  LINK-UPDATE-PROFILE      PIC X(1)                 .          
CVT000 01  LINK-AMOUNT-DISC-BAL     PIC X(11)                .          
CVT000 01  LINK-PANEL-NO            PIC X(04)                .          
CVT000 01  LINK-ORDER-TYPE-CD       PIC X(05)                .          
CVT000*01  LINK-SO-OFF-DATE         PIC X(10)                .                  
A01016 01  LINK-REMARK-TX           PIC X(210)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-ORDER-REASON                                       
CVT000         ,LINK-CANCEL-REASON                                      
CVT000         ,LINK-PENDING-SO-FLAG                                    
CVT000         ,LINK-UPDATE-PROFILE                                     
CVT000         ,LINK-AMOUNT-DISC-BAL                                    
CVT000         ,LINK-PANEL-NO                                           
CVT000         ,LINK-ORDER-TYPE-CD                                      
CVT000*        ,LINK-SO-OFF-DATE                                                
A01016         ,LINK-REMARK-TX                                          
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-ORDER-REASON(1:1)    TO PARM-ORDER-REASON        . 
CVT000     MOVE LINK-CANCEL-REASON        TO PARM-CANCEL-REASON       . 
CVT000     MOVE LINK-PENDING-SO-FLAG      TO PARM-PENDING-SO-FLAG     . 
CVT000     MOVE LINK-UPDATE-PROFILE       TO PARM-UPDATE-PROFILE      . 
CVT000     MOVE LINK-AMOUNT-DISC-BAL      TO PARM-AMOUNT-DISC-BAL     . 
CVT000     MOVE LINK-PANEL-NO             TO PARM-PANEL-NO            . 
CVT000     MOVE LINK-ORDER-TYPE-CD        TO PARM-ORDER-TYPE-CD       . 
CVT000*    MOVE LINK-SO-OFF-DATE          TO PARM-SO-OFF-DATE         .         
A01016     MOVE LINK-REMARK-TX            TO PARM-REMARK-TX           . 
A00976     IF LINK-REMARK-TX(17:5) = 'FM006' OR 'RECON'                 
A00976         MOVE 'Y' TO WS-UPDATE-PRORATE-CD
           END-IF.                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
T8807      IF PARM-ACCOUNT-NO <= ZEROS                                  
T8807         MOVE ZEROS                      TO PARM-ACCOUNT-NO        
T8807      END-IF.                                                      
                                                                        
PCR360     IF PARM-PREMISE-NO <= ZEROES                                 
PCR360        MOVE ZEROES                     TO PARM-PREMISE-NO        
PCR360     END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM           TO WS-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO.         
           MOVE PARM-PREMISE-NO-NUM           TO WS-PREMISE-NO.         
REARCH     PERFORM 1500-CONVERT-DISC-BAL      THRU 1500-EXIT.           
REARCH*    MOVE PARM-AMOUNT-DISC-BAL-N        TO WS-AMOUNT-DISC-BAL.            
REARCH*    DIVIDE 100                         INTO WS-AMOUNT-DISC-BAL.          
                                                                        
REARCH     PERFORM 7900-CALL-CSR00206         THRU 7900-EXIT.           
           MOVE PARM-PENDING-SO-FLAG          TO WS-PENDING-SO-FLAG.    
T23235     MOVE PARM-ORDER-TYPE-CD            TO WS-ORDER-TYPE-CD.      
           MOVE PARM-SO-OFF-DATE              TO WS-SO-OFF-DATE.        
           IF WS-SO-OFF-DATE = SPACES                                   
              MOVE -1                         TO WS-NULL-INDICATOR      
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1500-CONVERT-DISC-BAL.                                           
                                                                        
           MOVE '1500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  CAST(CIS.CHAR2DECIMAL3( LTRIM(RTRIM(
                                                  :PARM-AMOUNT-DISC-BAL
           )), 13, 2 ) AS DECIMAL(13,2))                               
                       INTO :WS-AMOUNT-DISC-BAL                         
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ051
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CAST(STRIP(:PARM-AMOUNT-DISC-BAL)                        
MFA-TR*                 AS DECIMAL(13,2))                                       
MFA-TR*                INTO :WS-AMOUNT-DISC-BAL                                 
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SYSDUMMY1'                TO TABLE-1                
              MOVE 'PARM-AMOUNT-DISC-BAL'     TO TABLE-ELEMENT-1        
              MOVE PARM-AMOUNT-DISC-BAL       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     CALLS       2210-PROCESS-FETCH                             *        
      *                 7700-OPEN-IA-CURSOR                            *        
      *                 7800-CLOSE-IA-CURSOR                           *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF PARM-PANEL-NO = WS-CHECK-BILL-DATE                        
              PERFORM 7000-SELECT-CODES       THRU 7000-EXIT            
              PERFORM 7500-CHECK-BILL-DATE    THRU 7500-EXIT            
              IF WS-NO-OF-DAYS = WS-AT-BILLED-TODAY OR                  
                 WS-NO-OF-DAYS = WS-AT-BILLED-YESTERDAY                 
                 MOVE 1000                    TO RS-RETURN-CODE         
              ELSE                                                      
                 MOVE 0                       TO RS-RETURN-CODE         
              END-IF                                                    
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-NO > ZEROS                                     
              PERFORM 7000-SELECT-CODES            THRU 7000-EXIT       
                                                                        
C23235        IF WS-ORDER-TYPE-CD NOT = 'NOT01'                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 7100-SELECT-CRED-PROF     THRU 7100-EXIT    
                 END-IF                                                 
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-CODES-PRESENT TO WS-CODES-DATA-PRESENT      
                    PERFORM 8200-UPDATE-ACCOUNT       THRU 8200-EXIT    
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 8300-UPDATE-CRED-PROFILE  THRU 8300-EXIT 
A00976                 IF WS-UPDATE-PRORATE-CD = 'Y'                    
T19006                     PERFORM 7200-GET-CURRENT-BILL THRU 7200-EXIT 
T19006                     IF BI-BILL-NO > 0                            
T19006                        PERFORM 8500-UPDATE-BILLING-DET THRU      
T19006                                8500-EXIT                         
T19006                     END-IF                                       
A00976                 END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
C23235     END-IF.                                                      
                                                                        
PCR360     IF WS-PREMISE-NO <= ZEROES                                   
PCR360        MOVE AT-PREMISE-NO                   TO WS-PREMISE-NO     
PCR360     END-IF.                                                      
                                                                        
           IF PARM-PANEL-NO NOT = WS-CALLED-FROM-UCSSO100               
              PERFORM 8400-UPDATE-PREMISE          THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT                THRU 8100-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-CODES                                              *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVES CODES DATA PRESENT COLUMN FROM CSS_ACCOUNT       *        
      ******************************************************************        
       7000-SELECT-CODES.                                               
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
PCR360        SELECT CODES_DATA_PRESENT,                                
PCR360               PREMISE_NO        ,                                
                     DATE_BILL_DAY_00  ,                                
T32480               COMPANY_NO        ,                                
P00471               ACCOUNT_TYPE_CODE ,                                
P00471               BILL_CYCLE        ,                                
P00471               REV_MTH_LST_NRML  ,                                
P00471               CODE_DISC_OK      ,                                
P00471               NOTICE_EXEMPT_CD  ,                                
P00471               DATE_BILL_DAY_30  ,                                
P00471               DATE_BILL_DAY_60  ,                                
P00471               DATE_BILL_DAY_90  ,                                
P00471               LOCAL_OFFICE      ,                                
P00471               BANKRUPTCY_IND    ,                                
P00471               CODE_ACCT_STAT    ,                                
P00471               CREDIT_GROUP      ,                                
P00471               CUSTOMER_NO                                        
PCR360          INTO :WS-CODES-PRESENT   ,                              
PCR360               :AT-PREMISE-NO      ,                              
                     :AT-DATE-BILL-DAY-00,                              
T32480               :AT-COMPANY-NO        ,                            
P00471               :AT-ACCOUNT-TYPE-CODE ,                            
P00471               :AT-BILL-CYCLE        ,                            
P00471               :AT-REV-MTH-LST-NRML  ,                            
P00471               :AT-CODE-DISC-OK      ,                            
P00471               :AT-NOTICE-EXEMPT-CD  ,                            
P00471               :AT-DATE-BILL-DAY-30  ,                            
P00471               :AT-DATE-BILL-DAY-60  ,                            
P00471               :AT-DATE-BILL-DAY-90  ,                            
P00471               :AT-LOCAL-OFFICE      ,                            
P00471               :AT-BANKRUPTCY-IND    ,                            
P00471               :AT-CODE-ACCT-STAT    ,                            
P00471               :AT-CREDIT-GROUP      ,                            
P00471               :AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15560        MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-CRED-PROF                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE DISC_HIST AND EXCEPTN_HIST FROM CSS_CREDIT_PROFILE*        
      ******************************************************************        
       7100-SELECT-CRED-PROF.                                           
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT DISCONNECT_HIST,                                   
                     DISC_EXCEPTN_HIST                                  
                INTO :WS-DISC-HIST,                                     
                     :WS-DISC-EXCEPTN-HIST                              
                FROM CSS_CREDIT_PROFILE                                 
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15560        MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T19006* 7200-GET-CURRENT-BILL                                          *        
T19006*     CALLS       9000-SEND-ERROR-RESULT                         *        
T19006*                 9900-SQL-ERROR-ROUTINE                         *        
T19006*                                                                *        
T19006*     CALLED FROM 2200-BUILD-RESULT                              *        
T19006*                                                                *        
T19006*     GET CURRENT BILL NUMBER                                    *        
T19006******************************************************************        
T19006 7200-GET-CURRENT-BILL.                                           
T19006                                                                  
T19006     MOVE '7200'                        TO ACTIVE-PARAGRAPH.      
T19006                                                                  
T19006     EXEC SQL                                                     
T19006        SELECT MAX(BILL_NO)                                       
T19006          INTO :BI-BILL-NO :WS-NULL-INDICATOR-2                   
T19006          FROM CSS_BILLING_HDR                                    
T19006         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
T19006           AND DATE_BILLED IS NULL                                
T19006     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19006                                                                  
T19006     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T19006                                                                  
T19006     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T19006        IF WS-NULL-INDICATOR-2 < 0                                
T19006            MOVE 0 TO BI-BILL-NO                                  
T19006        END-IF                                                    
T19006     ELSE                                                         
T19006        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T19006        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T19006        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T19006                                           ABEND-TABLES           
T19006        MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
T19006        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T19006        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T19006        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T19006        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T19006     END-IF.                                                      
T19006                                                                  
T19006 7200-EXIT.                                                       
T19006     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7500-CHECK-BILL-DATE.                                          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7500-CHECK-BILL-DATE.                                            
                                                                        
           MOVE '7500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT CIS.DAYS(IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )) -                 
                     CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))                
                INTO :WS-NO-OF-DAYS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DAYS(DATE(:AT-DATE-BILL-DAY-00)) -                         
MFA-TR*              DAYS(DATE(CURRENT DATE))                                   
MFA-TR*         INTO :WS-NO-OF-DAYS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
T32480*******************************************************************       
T32480*                                                                *        
T32480*7600-SELECT-DNP-CANCEL-RSN                                      *        
T32480*******************************************************************       
T32480 7600-SELECT-DNP-CANCEL-RSN.                                      
T32480                                                                  
T32480     EXEC SQL                                                     
T32480        SELECT  DC.RESOLVED_CD,                                   
A01016                DC.CANCEL_MODE_CD                                 
T32480          INTO :DC-RESOLVED-CD,                                   
A01016               :DC-CANCEL-MODE-CD                                 
T32480          FROM CSS_DNP_CANCEL_RSN DC                              
T32480         WHERE COMPANY_NO     = :DC-COMPANY-NO                    
T32480           AND CANCEL_RSN_CD  = :DC-CANCEL-RSN-CD                 
T32480     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32480                                                                  
T32480     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T32480                                                                  
T32480     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T32480        NEXT SENTENCE                                             
T32480     ELSE                                                         
T32480        MOVE '7600'                     TO ACTIVE-PARAGRAPH       
T32480        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T32480        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T32480        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T32480        MOVE SPACES                     TO ABEND-TABLES           
T32480        MOVE 'CSS_DNP_CANCEL_RSN'       TO TABLE-1                
T32480        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
T32480        MOVE 'CANCEL_RSN_CD'            TO TABLE-ELEMENT-2        
T32480        MOVE DC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
T32480        MOVE DC-CANCEL-RSN-CD           TO HOSTVAR-ELEMENT-2      
T32480        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T32480        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T32480     END-IF.                                                      
T32480                                                                  
T32480 7600-EXIT.                                                       
T32480     EXIT.                                                        
                                                                        
P00471*****************************************************************         
P00471* 7700-GET-DATABASE.                                            *         
P00471*     SELECTS   DATABASE     (SEB OR SCEG) FROM CSS_DELINQUENCY *         
P00471*****************************************************************         
P00471 7700-GET-DATABASE.                                               
P00471                                                                  
P00471     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
P00471     MOVE AT-COMPANY-NO                    TO   C8-COMPANY-NO.    
P00471     EXEC SQL                                                     
P00471        SELECT DELINQ_VALUE                                       
P00471          INTO :C8-DELINQ-VALUE                                   
P00471          FROM CSS_DELINQUENCY                                    
P00471         WHERE DELINQ_CD = :C8-DELINQ-CD                          
P00471           AND COMPANY_NO = :C8-COMPANY-NO                        
P00471     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471                                                                  
P00471     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00471                                                                  
P00471     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00471        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
P00471     ELSE                                                         
P00471        MOVE '7700'                     TO ACTIVE-PARAGRAPH       
P00471        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00471        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00471        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
P00471        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00471        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00471        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00471        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00471     END-IF.                                                      
P00471                                                                  
P00471 7700-EXIT.                                                       
P00471     EXIT.                                                        
                                                                        
REARCH 7900-CALL-CSR00206.                                              
REARCH                                                                  
REARCH     EXEC SQL CALL CSR00206                                       
REARCH                 ( :WS-PREMISE-NO
                  , :PARM-PENDING-SO-FLAG OUTPUT
                  , :PARM-SO-OFF-DATE OUTPUT
                  )                                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL CALL CSR00206                                               
MFA-TR*                ( :WS-PREMISE-NO                                         
MFA-TR*                 ,:PARM-PENDING-SO-FLAG                                  
MFA-TR*                 ,:PARM-SO-OFF-DATE                                      
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
REARCH*    IF  WS-ACTIVE-RETURN-CODE = +466                                     
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE                 
REARCH*         CSR00206                                                        
REARCH*       END-EXEC                                                          
REARCH*       EXEC SQL ALLOCATE C2  CURSOR FOR RESULT SET :LOC1                 
REARCH*       END-EXEC                                                          
REARCH*       DISPLAY 'ALLOCATE  SQLCODE' SQLCODE                               
REARCH*       EXEC SQL                                                          
REARCH*       FETCH C2  INTO                                                    
REARCH*                :PARM-PENDING-SO-FLAG                                    
REARCH*               ,:PARM-SO-OFF-DATE                                        
REARCH*       END-EXEC                                                          
REARCH*       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE            
REARCH*       IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
REARCH*           CONTINUE                                                      
REARCH*         ELSE                                                            
REARCH*             MOVE '7700'               TO ACTIVE-PARAGRAPH               
REARCH*             MOVE PROGRAM-NAME         TO ABEND-PROGRAM                  
REARCH*             MOVE 'FETCH'              TO ABEND-FUNCTION                 
REARCH*             MOVE 'CSR00206'           TO TABLE-1                        
REARCH*             MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                
REARCH*             MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1              
REARCH*             MOVE 'SQLCODE '           TO TABLE-ELEMENT-1                
REARCH*             MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1             
REARCH*             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                   
REARCH*         END-IF                                                          
REARCH*         EXEC SQL                                                        
REARCH*           CLOSE C2                                                      
REARCH*         END-EXEC                                                        
REARCH*         MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE          
REARCH*         IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                     
REARCH*             CONTINUE                                                    
REARCH*         ELSE                                                            
REARCH*             MOVE '7700'               TO ACTIVE-PARAGRAPH               
REARCH*             MOVE PROGRAM-NAME         TO ABEND-PROGRAM                  
REARCH*             MOVE 'CLOSE'              TO ABEND-FUNCTION                 
REARCH*             MOVE 'CSR00206'           TO TABLE-1                        
REARCH*             MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                
REARCH*             MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1              
REARCH*             MOVE 'SQLCODE '           TO TABLE-ELEMENT-1                
REARCH*             MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1             
REARCH*             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                   
REARCH*         END-IF                                                          
REARCH*     ELSE                                                                
C35517      IF WS-ACTIVE-RETURN-CODE NOT = 0                            
REARCH              MOVE '7900'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'CALLSP'             TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00206'           TO TABLE-1                
REARCH              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
REARCH              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
REARCH      END-IF.                                                     
REARCH 7900-EXIT.                                                       
REARCH     EXIT.                                                        
      ******************************************************************        
      * 8200-UPDATE-ACCOUNT                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATES THE PENDING DNP FLAG ON CSS_ACCOUNT                *        
      ******************************************************************        
       8200-UPDATE-ACCOUNT.                                             
                                                                        
           MOVE '8200'                        TO ACTIVE-PARAGRAPH.      
           MOVE ' '                           TO WS-CODE-PENDING-DNP.   
           MOVE WS-CODES-DATA-PRESENT         TO WS-CODES-PRESENT.      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :WS-CODES-PRESENT,            
PCR360               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODES_DATA_PRESENT = :WS-CODES-PRESENT,                    
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15560        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-CRED-PROFILE                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATES FLAGS ON TABLE CSS_CREDIT_PROFILE FOR              *        
      *     ACCOUNT NO PASSED AS PARAMTER                              *        
      ******************************************************************        
       8300-UPDATE-CRED-PROFILE.                                        
                                                                        
           MOVE '8300'                      TO ACTIVE-PARAGRAPH.        
PCR360     MOVE PARM-UPDATE-PROFILE         TO WS-UPDATE-PROFILE.       
                                                                        
T32480     MOVE PARM-CANCEL-REASON           TO DC-CANCEL-RSN-CD        
T32480     MOVE AT-COMPANY-NO                TO DC-COMPANY-NO           
                                                                        
T32480     PERFORM 7600-SELECT-DNP-CANCEL-RSN  THRU 7600-EXIT.          
                                                                        
T32480     IF PARM-ORDER-REASON = 'N' OR PARM-ORDER-REASON = 'O' OR     
P00471        PARM-ORDER-REASON = 'J' OR PARM-ORDER-REASON = 'K' OR     
P00471        PARM-ORDER-REASON = 'U' OR PARM-ORDER-REASON = 'V'        
C32930        IF WS-DISC-HIST(1:1) NOT = '4'                            
T32480           MOVE DC-RESOLVED-CD            TO WS-DISC-HIST(1:1)    
C32930        END-IF                                                    
T32480     ELSE                                                         
C32930        IF WS-DISC-EXCEPTN-HIST(1:1) NOT = '4'                    
T32480           MOVE DC-RESOLVED-CD       TO WS-DISC-EXCEPTN-HIST(1:1) 
C32930        END-IF                                                    
T32480     END-IF.                                                      
                                                                        
P00471***RESCHEDULED DNP CHANGES *****************                              
P00471     PERFORM 7700-GET-DATABASE       THRU  7700-EXIT.             
P00471     IF CSR-DATABASE AND AT-CODE-ACCT-STAT = 'A' AND              
P00471        (PARM-ORDER-REASON = 'N' OR PARM-ORDER-REASON = 'O' OR    
P00471         PARM-ORDER-REASON = 'J' OR PARM-ORDER-REASON = 'K' OR    
P00471         PARM-ORDER-REASON = 'U' OR PARM-ORDER-REASON = 'V')      
P00471        IF PARM-CANCEL-REASON = '2' OR PARM-CANCEL-REASON = '4' OR
P00471           PARM-CANCEL-REASON = 'G'                               
P00471           PERFORM 6100-PROCESS-RESCH-DNPS THRU                   
P00471                                      6100-RESCH-DNPS-EXIT        
P00471           IF PARM-PANEL-NO = WS-CALLED-FROM-PANEL16              
P00471              MOVE WS-RETURN-CODE-C335 TO RS-RETURN-CODE          
P00471           END-IF                                                 
P00471           IF (PARM-PANEL-NO = WS-CALLED-FROM-PANEL75 OR          
P00471               PARM-PANEL-NO = WS-CALLED-FROM-PCSSO103) AND       
P00471               WS-RETURN-CODE-C335 = WS-CPD00335-ABEND-CODE       
P00471              MOVE WS-RETURN-CODE-C335 TO RS-RETURN-CODE          
P00471           END-IF                                                 
P00471        END-IF                                                    
P00471     END-IF.                                                      
P00471                                                                  
A01016*** PREVENT CREDIT PROFILE FROM GETTING UPDATED WHEN IT WAS A             
A01016*** A DNPFB AND NOT A DNP01 THAT WAS CANCELED.                            
           IF WS-UPDATE-PROFILE = 'Y' AND WS-ORDER-TYPE-CD NOT = 'DNPFB'
              EXEC SQL                                                  
                 UPDATE CSS_CREDIT_PROFILE                              
                    SET DISCONNECT_HIST = :WS-DISC-HIST,                
                        DISC_EXCEPTN_HIST = :WS-DISC-EXCEPTN-HIST,      
PCR360                  LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()           
                  WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                     
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*          UPDATE CSS_CREDIT_PROFILE                                      
MFA-TR*             SET DISCONNECT_HIST = :WS-DISC-HIST,                        
MFA-TR*                 DISC_EXCEPTN_HIST = :WS-DISC-EXCEPTN-HIST,              
MFA-TR*                 LAST_UPDATE_TS    = CURRENT TIMESTAMP                   
MFA-TR*           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                             
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
T15560           MOVE 'UPDATE'                   TO ABEND-FUNCTION      
CBSI             MOVE SPACES                     TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
                 MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1             
                 MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1   
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8400-UPDATE-PREMISE                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATES THE PENDING SO  FLAG ON CSS_PREMISE                *        
      ******************************************************************        
       8400-UPDATE-PREMISE.                                             
                                                                        
           MOVE '8400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET SERV_ORDER_PEND = :WS-PENDING-SO-FLAG,             
                     PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-SO-OFF-DATE 
                                                     :WS-NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :WS-SO-OFF-DATE 
                                                     :WS-NULL-INDICATOR
              ) <> 0) OR (LEN(:WS-SO-OFF-DATE :WS-NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:WS-SO-OFF-DATE 
                                                     :WS-NULL-INDICATOR
              ), CONVERT(DATE, :WS-SO-OFF-DATE :WS-NULL-INDICATOR) )
               WHERE PREMISE_NO = :WS-PREMISE-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET SERV_ORDER_PEND = :WS-PENDING-SO-FLAG,                     
MFA-TR*              PEND_OFF_ORD_DT = :WS-SO-OFF-DATE:WS-NULL-INDICATOR        
MFA-TR*        WHERE PREMISE_NO = :WS-PREMISE-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15560        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
T16122        MOVE 'PEND_OFF_ORD_DT'          TO TABLE-ELEMENT-2        
T16122        MOVE WS-SO-OFF-DATE             TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'SERV_ORDER_PEND'          TO TABLE-ELEMENT-3        
CBSI          MOVE WS-PENDING-SO-FLAG         TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19006******************************************************************        
T19006* 8500-UPDATE-BILLING-DET                                        *        
T19006*     CALLS       9000-SEND-ERROR-RESULT                         *        
T19006*                 9900-SQL-ERROR-ROUTINE                         *        
T19006*                                                                *        
T19006*     CALLED FROM 2200-BUILD-RESULT                              *        
T19006*                                                                *        
T19006*     UPDATES THE PRORATE CODE ON CSS_BILLING_DET                *        
T19006******************************************************************        
T19006 8500-UPDATE-BILLING-DET.                                         
T19006                                                                  
T19006     MOVE '8500'                        TO ACTIVE-PARAGRAPH.      
T19006                                                                  
T19006     EXEC SQL                                                     
T19006        UPDATE CSS_BILLING_DET                                    
T19006           SET PRORATE_CD = ' '                                   
T19006         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
T19006           AND BILL_NO = :BI-BILL-NO                              
T19006     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19006                                                                  
T19006     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T19006                                                                  
T19006     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T19006        NEXT SENTENCE                                             
T19006     ELSE                                                         
T19006        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T19006        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T19006        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T19006                                           ABEND-TABLES           
T19006        MOVE 'CSS_BILLING_DET'          TO TABLE-1                
T19006        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T19006        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T19006        MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
T19006        MOVE BI-BILL-NO                 TO HOSTVAR-ELEMENT-2      
T19006        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T19006        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T19006     END-IF.                                                      
T19006                                                                  
T19006 8500-EXIT.                                                       
T19006     EXIT.                                                        
                                                                        
A05020                                                                  
A05020******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD0023C                                                  
REARCH     END-EXEC.                                                            
P00471     EXEC SQL                                                             
P00471        INCLUDE CPD00067                                                  
P00471     END-EXEC.                                                            
P00471     EXEC SQL                                                             
P00471        INCLUDE CPD00068                                                  
P00471     END-EXEC.                                                            
P00471     EXEC SQL                                                             
P00471        INCLUDE CPD00310                                                  
P00471     END-EXEC.                                                            
P00471     EXEC SQL                                                             
P00471        INCLUDE CPD00335                                                  
P00471     END-EXEC.                                                            
