       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02121.                                         
COB303 DATE-WRITTEN.     JUNE 14, 1995.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S121 CONVERTED TO DB2 SP CSR02121 ON 09/29/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S121                                           *        
      *  PROGRAM:       S121                                           *        
      *  CALLING SP:    PN_S121                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              *        
      * DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        *        
      *                                                                *        
      * THIS PROGRAM PERFORMS METER NUMBER VALIDATIONS AND RETURNS     *        
      * THE METER'S DIGITAL METER TYPE.                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/14/95    JHR      CREATED.                                 *        
CBSI  *  08/14/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
T22243*  07/25/00    CBSI     CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*              MADRAS   IN METER INVENTORY TABLES                *        
T23539*  05/10/01    RR       PASSING COMPANY_NO TO RPC FOR MULTI-     *        
T23539*                       COMPANY.  REPLACES HARD-CODED '01' FOR   *        
T23539*                       WS-DEFAULT-COMPANY-NO                    *        
T26373*  08/13/02    SR82046  PASSING PROGRAM ID AND IDR RECIPIENT CODE*        
T26373*                       TO THE PANEL FROM THE METER TABLES.      *        
C30989*  06/09/06    VV90387  DEFAULT READ SOURCE BASED ON CSS_METER_PGM        
      *                                                                *        
C36457*  11/02/07    RC41079  DELETE REFERENCES TO CSS_WTR_SWR_METER   *        
C36457*                       AND TBWSMTR                              *        
      *                                                                *        
A01610*  11/01/11    MC95456  REMOVE UNUSED 7150- PARAGRAPH            *        
A04527*  06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02121'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S121 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDGMTYP                                                  
           END-EXEC.                                                            
C26373     EXEC SQL                                                             
C26373        INCLUDE TBMTRPGM                                                  
C26373     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SYBASE OPEN SERVER FOR CICS FACILITIES                                  
CVT999*    COPY SYGWCOB.                                                        
      * ADDED TO SUPPORT CICS RPCS                                              
CVT999*    COPY SYDBCOB.                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
CVT999*    COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S121    '.      
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-UTILITY-TYPE       PIC X(01)      VALUE SPACES.     
           05  PARM-METER-NO           PIC X(09)      VALUE SPACES.     
           05  PARM-PREMISE-NO         PIC X(10)      VALUE SPACES.     
           05  PARM-PREMISE-NO-RED     REDEFINES PARM-PREMISE-NO        
                                       PIC 9(10).                       
           05  PARM-PREMISE-NO-NUM     PIC S9(10)V COMP-3 VALUE 0.      
T23539     05  PARM-COMPANY-NO         PIC X(02)      VALUE SPACES.     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-UTILITY-TYPES.                                            
           05  WS-ELECTRIC             PIC X(01) VALUE 'E'.             
           05  WS-GAS                  PIC X(01) VALUE 'G'.             
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-INVENTORY-LOC        PIC X(01) VALUE 'A'.             
           05  WS-IN-TRANSIT-LOC       PIC X(01) VALUE 'C'.             
           05  WS-PREMISE-LOC          PIC X(01) VALUE 'J'.             
T22243     05  WS-DEFAULT-COMPANY-NO   PIC X(02) VALUE SPACES.          
T23539                                                                  
       01  WS-FLAGS.                                                    
           05  WS-EQUIP-EXISTS-FLAG    PIC X(03) VALUE 'NO '.           
               88 EQUIP-EXISTS                   VALUE 'YES'.           
           05  WS-MTR-EXISTS-FLAG      PIC X(03) VALUE 'NO '.           
               88 MTR-EXISTS                     VALUE 'YES'.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-EQUIP-EXISTS        PIC X(01)      VALUE SPACES.      
           05  RS-IN-INVENTORY        PIC X(01)      VALUE SPACES.      
           05  RS-AT-PREMISE          PIC X(01)      VALUE SPACES.      
           05  RS-DIGTL-MTR-TYPE      PIC X(03)      VALUE SPACES.      
           05  RS-DFLT-REMOTE-RD-IND  PIC X(01)      VALUE SPACES.      
C26373     05  RS-PROGRAM-ID          PIC X(02)      VALUE SPACES.      
C26373     05  RS-IDR-RECIPIENT-CD    PIC X(01)      VALUE SPACES.      
C30989     05  RS-DEF-RD-SOURCE-CD    PIC X(01)      VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE        PIC X(11) VALUE                           
CVT999*                                         'RETURN_CODE'.                  
CVT999*    05  CNS-EQUIP-EXISTS       PIC X(12) VALUE                           
CVT999*                                         'EQUIP_EXISTS'.                 
CVT999*    05  CNS-IN-INVENTORY       PIC X(12) VALUE                           
CVT999*                                         'IN_INVENTORY'.                 
CVT999*    05  CNS-AT-PREMISE         PIC X(10) VALUE                           
CVT999*                                         'AT_PREMISE'.                   
CVT999*    05  CNS-DIGTL-MTR-TYPE     PIC X(14) VALUE                           
CVT999*                                         'DIGTL_MTR_TYPE'.               
CVT999*    05  CNS-DFLT-REMOTE-RD-IND PIC X(18) VALUE                           
CVT999*                                         'DFLT_REMOTE_RD_IND'.           
CVT999*    05  CNS-PROGRAM-ID         PIC X(10) VALUE                           
CVT999*                                         'PROGRAM_ID'.                   
CVT999*    05  CNS-IDR-RECIPIENT-CD   PIC X(16) VALUE                           
CVT999*                                         'IDR_RECIPIENT_CD'.             
CVT999*    05  CNS-DEF-RD-SOURCE-CD   PIC X(16) VALUE                           
CVT999*                                         'DEF_RD_SOURCE_CD'.             
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-UTILITY-TYPE        PIC X(01)                .          
CVT000 01  LINK-METER-NO            PIC X(09)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-COMPANY-NO          PIC X(02)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-UTILITY-TYPE                                       
CVT000         ,LINK-METER-NO                                           
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-COMPANY-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          GWL-INIT-HANDLE.                               
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          GWL-INIT-HANDLE,                               
CVT999*                          SNA-CONNECTION-NAME,                           
CVT999*                          SNA-SUBC.                                      
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC,                                      
CVT999*                          GWL-RC.                                        
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
CVT999*       MOVE 'TDRESULT- NO RPC PARM SENT' TO ABEND-FUNCTION               
CVT999*       MOVE 'CICS TRANSACTION'           TO TABLE-1                      
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-EQUIP-EXISTS             AS    EQUIP_EXISTS           
CVT000       ,:RS-IN-INVENTORY             AS    IN_INVENTORY           
CVT000       ,:RS-AT-PREMISE               AS    AT_PREMISE             
CVT000       ,:RS-DIGTL-MTR-TYPE           AS    DIGTL_MTR_TYPE         
CVT000       ,:RS-DFLT-REMOTE-RD-IND       AS    DFLT_REMOTE_RD_IND     
CVT000       ,:RS-PROGRAM-ID               AS    PROGRAM_ID             
CVT000       ,:RS-IDR-RECIPIENT-CD         AS    IDR_RECIPIENT_CD       
CVT000       ,:RS-DEF-RD-SOURCE-CD         AS    DEF_RD_SOURCE_CD       
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-EQUIP-EXISTS             AS    EQUIP_EXISTS                   
MFA-TR*      ,:RS-IN-INVENTORY             AS    IN_INVENTORY                   
MFA-TR*      ,:RS-AT-PREMISE               AS    AT_PREMISE                     
MFA-TR*      ,:RS-DIGTL-MTR-TYPE           AS    DIGTL_MTR_TYPE                 
MFA-TR*      ,:RS-DFLT-REMOTE-RD-IND       AS    DFLT_REMOTE_RD_IND             
MFA-TR*      ,:RS-PROGRAM-ID               AS    PROGRAM_ID                     
MFA-TR*      ,:RS-IDR-RECIPIENT-CD         AS    IDR_RECIPIENT_CD               
MFA-TR*      ,:RS-DEF-RD-SOURCE-CD         AS    DEF_RD_SOURCE_CD               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-UTILITY-TYPE         TO PARM-UTILITY-TYPE        . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS         THRU 1100-EXIT.           
                                                                        
           MOVE PARM-PREMISE-NO-RED           TO PARM-PREMISE-NO-NUM.   
T23539     MOVE PARM-COMPANY-NO               TO WS-DEFAULT-COMPANY-NO. 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     RECEIVE PASSED PARAMETERS.                                 *        
      *                                                                *        
      *     CALLED BY:  1000-PROCESS-INPUT                             *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-UTILITY-TYPE      TO MAX-LENGTH-PARM.            
           MOVE 'CODE-UTIL-TYPE'                 TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-UTILITY-TYPE,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-METER-NO          TO MAX-LENGTH-PARM.            
           MOVE 'METER-NO'                       TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-METER-NO,                                 
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO        TO MAX-LENGTH-PARM.            
           MOVE 'PREMISE-NO'                     TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMPANY-NO        TO MAX-LENGTH-PARM             
CVT999*    MOVE 'COMPANY-NO'                     TO WS-RCVPRM.                  
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMPANY-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
T23539     PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1150-CHECK-ERROR.                                              *        
      *     CHECK FOR ERRORS RECEIVING PARAMETERS.                     *        
      *                                                                *        
      *      CALLED BY: 1100-RECEIVE-PARMS.                            *        
      ******************************************************************        
       1150-CHECK-ERROR.                                                
                                                                        
CVT999*    IF GWL-RC NOT = TDS-OK                                               
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
CVT999*       MOVE 'TDRCVPRM - PARAMETER ERROR' TO ABEND-FUNCTION               
CVT999*       MOVE WS-RCVPRM                    TO TABLE-1                      
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
           MOVE '2000'               TO ACTIVE-PARAGRAPH.               
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     DESCRIBE RESULT SET.                                       *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-EQUIP-EXISTS       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-EQUIP-EXISTS      TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-EQUIP-EXISTS,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-EQUIP-EXISTS,                              
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-IN-INVENTORY       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-IN-INVENTORY      TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-IN-INVENTORY,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-IN-INVENTORY,                              
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-AT-PREMISE         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-AT-PREMISE        TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AT-PREMISE,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-AT-PREMISE,                                
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-DIGTL-MTR-TYPE     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-DIGTL-MTR-TYPE    TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DIGTL-MTR-TYPE,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DIGTL-MTR-TYPE,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DFLT-REMOTE-RD-IND  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DFLT-REMOTE-RD-IND TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DFLT-REMOTE-RD-IND,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DFLT-REMOTE-RD-IND,                        
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
C26373                                                                  
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-PROGRAM-ID          TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-PROGRAM-ID         TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PROGRAM-ID,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PROGRAM-ID,                                
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
C26373                                                                  
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-IDR-RECIPIENT-CD    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-IDR-RECIPIENT-CD   TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-IDR-RECIPIENT-CD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-IDR-RECIPIENT-CD,                          
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
C26373                                                                  
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DEF-RD-SOURCE-CD    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DEF-RD-SOURCE-CD   TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEF-RD-SOURCE-CD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DEF-RD-SOURCE-CD,                          
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
C30989                                                                  
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
      * ENSURE THE METER EXISTS IN THE EQUIPMENT TABLE AND                      
      * ITS LOCATION IS IN INVENTORY OR AT THE CURRENT PREMISE.                 
           MOVE PARM-UTILITY-TYPE              TO EQ-CODE-UTIL-TYPE.    
           MOVE PARM-METER-NO                  TO EQ-DEVICE-NO.         
T22243     MOVE WS-DEFAULT-COMPANY-NO          TO EQ-COMPANY-NO         
T22243                                            EM-COMPANY-NO         
T22243                                            GM-COMPANY-NO.        
           PERFORM 7000-SELECT-EQUIPMENT            THRU 7000-EXIT.     
           IF EQUIP-EXISTS                                              
              MOVE WS-YES                      TO RS-EQUIP-EXISTS       
              IF EQ-CODE-CRNT-LOC = WS-INVENTORY-LOC OR                 
                                    WS-IN-TRANSIT-LOC                   
                 MOVE WS-YES                   TO RS-IN-INVENTORY       
                 MOVE WS-NO                    TO RS-AT-PREMISE         
              ELSE                                                      
                 IF EQ-CODE-CRNT-LOC = WS-PREMISE-LOC AND               
                    EQ-CRNT-LOC-NO   = PARM-PREMISE-NO-NUM              
                    MOVE WS-YES                TO RS-AT-PREMISE         
                    MOVE WS-NO                 TO RS-IN-INVENTORY       
                 ELSE                                                   
                    MOVE WS-NO                 TO RS-AT-PREMISE         
                    MOVE WS-NO                 TO RS-IN-INVENTORY       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                       TO RS-EQUIP-EXISTS       
              MOVE WS-NO                       TO RS-IN-INVENTORY       
              MOVE WS-NO                       TO RS-AT-PREMISE         
           END-IF.                                                      
                                                                        
      * DETERMINE THE METER'S DIGITAL METER TYPE FROM                           
      * THE ELECTRIC, GAS, OR WATER/SEWER METER TABLES.                         
           IF PARM-UTILITY-TYPE       = WS-ELECTRIC                     
              MOVE PARM-UTILITY-TYPE           TO EM-CODE-UTIL-TYPE     
C26373                                            O8-CODE-UTIL-TYPE     
              MOVE PARM-METER-NO               TO EM-METER-NO           
              PERFORM 7100-SELECT-ELEC-MTR          THRU 7100-EXIT      
              IF MTR-EXISTS                                             
                 MOVE EM-DIGTL-MTR-TYPE        TO RS-DIGTL-MTR-TYPE     
C26373                                            O8-DIGTL-MTR-TYPE     
C26373           MOVE EM-PROGRAM-ID            TO O8-PROGRAM-ID         
C26373                                            RS-PROGRAM-ID         
              ELSE                                                      
                 MOVE SPACES                   TO RS-DIGTL-MTR-TYPE     
C26373           MOVE SPACES                   TO O8-PROGRAM-ID         
              END-IF                                                    
           ELSE                                                         
              IF PARM-UTILITY-TYPE    = WS-GAS                          
                 MOVE PARM-UTILITY-TYPE        TO GM-CODE-UTIL-TYPE     
C26373                                            O8-CODE-UTIL-TYPE     
                 MOVE PARM-METER-NO            TO GM-METER-NO           
                 PERFORM 7200-SELECT-GAS-MTR          THRU 7200-EXIT    
                 IF MTR-EXISTS                                          
                    MOVE GM-DIGTL-MTR-TYPE     TO RS-DIGTL-MTR-TYPE     
C26373                                            O8-DIGTL-MTR-TYPE     
C26373              MOVE GM-PROGRAM-ID         TO O8-PROGRAM-ID         
C26373                                            RS-PROGRAM-ID         
                 ELSE                                                   
                    MOVE SPACES                TO RS-DIGTL-MTR-TYPE     
C26373              MOVE SPACES                TO O8-PROGRAM-ID         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
C26373     PERFORM 7400-SELECT-MTR-PGM         THRU 7400-EXIT.          
C26373     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C26373        MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
C26373        MOVE SPACES                      TO RS-DFLT-REMOTE-RD-IND 
C26373        MOVE SPACES                      TO RS-IDR-RECIPIENT-CD   
C30989        MOVE SPACES                      TO RS-DEF-RD-SOURCE-CD   
C26373     ELSE                                                         
C26373        MOVE O8-DFLT-REMOTE-RD-IND       TO RS-DFLT-REMOTE-RD-IND 
C26373        MOVE O8-IDR-RECIPIENT-CD         TO RS-IDR-RECIPIENT-CD   
C30989        MOVE O8-DEF-RD-SOURCE-CD         TO RS-DEF-RD-SOURCE-CD   
C26373     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-EQUIPMENT.                                         *        
      *     DETERMINE THE METER'S LOCATION.                            *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-SELECT-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     CODE_CRNT_LOC,                                     
                     CRNT_LOC_NO                                        
                INTO :WS-EQUIP-EXISTS-FLAG,                             
                     :EQ-CODE-CRNT-LOC,                                 
                     :EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
T22243         WHERE COMPANY_NO         = :EQ-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE            
                 AND DEVICE_NO          = :EQ-DEVICE-NO                 
A01610                                                           
A01610                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              CODE_CRNT_LOC,                                             
MFA-TR*              CRNT_LOC_NO                                                
MFA-TR*         INTO :WS-EQUIP-EXISTS-FLAG,                                     
MFA-TR*              :EQ-CODE-CRNT-LOC,                                         
MFA-TR*              :EQ-CRNT-LOC-NO                                            
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO         = :EQ-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND DEVICE_NO          = :EQ-DEVICE-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_EQUIPMENT'            TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE EQ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'DEVICE_NO'                TO TABLE-ELEMENT-2        
              MOVE EQ-DEVICE-NO               TO HOSTVAR-ELEMENT-2      
T22243        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
T22243        MOVE EQ-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-ELEC-MTR.                                          *        
      *     DETERMINE THE DIGITAL METER TYPE FOR THE ELECTRIC METER.   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-SELECT-ELEC-MTR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     DIGTL_MTR_TYPE                                     
C26373              ,PROGRAM_ID                                         
                INTO :WS-MTR-EXISTS-FLAG,                               
                     :EM-DIGTL-MTR-TYPE,                                
C26373               :EM-PROGRAM-ID                                     
                FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
T22243         WHERE COMPANY_NO         = :EM-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE            
                 AND METER_NO           = :EM-METER-NO                  
A01610                                                           
A01610                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              DIGTL_MTR_TYPE                                             
MFA-TR*             ,PROGRAM_ID                                                 
MFA-TR*         INTO :WS-MTR-EXISTS-FLAG,                                       
MFA-TR*              :EM-DIGTL-MTR-TYPE,                                        
MFA-TR*              :EM-PROGRAM-ID                                             
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*        WHERE COMPANY_NO         = :EM-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE                    
MFA-TR*          AND METER_NO           = :EM-METER-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ELEC_METER'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE EM-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
              MOVE EM-METER-NO                TO HOSTVAR-ELEMENT-2      
T22243        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
T22243        MOVE EM-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-GAS-MTR.                                           *        
      *     DETERMINE THE DIGITAL METER TYPE FOR THE GAS METER.        *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7200-SELECT-GAS-MTR.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     DIGTL_MTR_TYPE                                     
C26373              ,PROGRAM_ID                                         
                INTO :WS-MTR-EXISTS-FLAG,                               
                     :GM-DIGTL-MTR-TYPE,                                
C26373               :GM-PROGRAM-ID                                     
                FROM CSS_GAS_METER WITH(READUNCOMMITTED)                        
T22243         WHERE COMPANY_NO         = :GM-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :GM-CODE-UTIL-TYPE            
                 AND METER_NO           = :GM-METER-NO                  
A01610                                                           
A01610                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              DIGTL_MTR_TYPE                                             
MFA-TR*             ,PROGRAM_ID                                                 
MFA-TR*         INTO :WS-MTR-EXISTS-FLAG,                                       
MFA-TR*              :GM-DIGTL-MTR-TYPE,                                        
MFA-TR*              :GM-PROGRAM-ID                                             
MFA-TR*         FROM CSS_GAS_METER                                              
MFA-TR*        WHERE COMPANY_NO         = :GM-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :GM-CODE-UTIL-TYPE                    
MFA-TR*          AND METER_NO           = :GM-METER-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_GAS_METER'            TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE GM-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
              MOVE GM-METER-NO                TO HOSTVAR-ELEMENT-2      
T22243        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
T22243        MOVE GM-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26373******************************************************************        
C26373* 7400-SELECT-MTR-PGM.                                           *        
C26373*     SELECTS THE PROGRAM ID AND IDR RECIPIENT CD.               *        
C26373*                                                                *        
C26373*     CALLED BY:  2200-BUILD-RESULT                              *        
C26373******************************************************************        
C26373 7400-SELECT-MTR-PGM.                                             
C26373                                                                  
C26373     EXEC SQL                                                     
C26373        SELECT DFLT_REMOTE_RD_IND                                 
C26373              ,IDR_RECIPIENT_CD                                   
C30989              ,DEF_RD_SOURCE_CD                                   
C26373          INTO :O8-DFLT-REMOTE-RD-IND                             
C26373              ,:O8-IDR-RECIPIENT-CD                               
C30989              ,:O8-DEF-RD-SOURCE-CD                               
C26373          FROM CSS_METER_PGM WITH(READUNCOMMITTED)                        
C26373         WHERE CODE_UTIL_TYPE     = :O8-CODE-UTIL-TYPE            
C26373           AND DIGTL_MTR_TYPE     = :O8-DIGTL-MTR-TYPE            
C26373           AND PROGRAM_ID         = :O8-PROGRAM-ID                
A01610                                                           
A01610                                                      
C26373     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DFLT_REMOTE_RD_IND                                         
MFA-TR*             ,IDR_RECIPIENT_CD                                           
MFA-TR*             ,DEF_RD_SOURCE_CD                                           
MFA-TR*         INTO :O8-DFLT-REMOTE-RD-IND                                     
MFA-TR*             ,:O8-IDR-RECIPIENT-CD                                       
MFA-TR*             ,:O8-DEF-RD-SOURCE-CD                                       
MFA-TR*         FROM CSS_METER_PGM                                              
MFA-TR*        WHERE CODE_UTIL_TYPE     = :O8-CODE-UTIL-TYPE                    
MFA-TR*          AND DIGTL_MTR_TYPE     = :O8-DIGTL-MTR-TYPE                    
MFA-TR*          AND PROGRAM_ID         = :O8-PROGRAM-ID                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26373                                                                  
C26373     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26373                                                                  
C26373     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26373        NEXT SENTENCE                                             
C26373     ELSE                                                         
C26373        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C26373        MOVE '7400'                     TO ACTIVE-PARAGRAPH       
C26373        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C26373        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C26373                                           ABEND-TABLES           
C26373        MOVE 'CSS_METER_PGM'            TO TABLE-1                
C26373        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
C26373        MOVE O8-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
C26373        MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
C26373        MOVE O8-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
C26373        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
C26373        MOVE O8-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
C26373        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C26373        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C26373     END-IF.                                                      
C26373                                                                  
C26373 7400-EXIT.                                                       
C26373     EXIT.                                                        
C26373*                                                                         
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
