       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02120.                                         
COB303 DATE-WRITTEN.  JULY 03, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S120 CONVERTED TO DB2 SP CSR02120 ON 06/13/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S120                                           *        
      *  PROGRAM:       S120                                           *        
      *  CALLING SP:    PA_S120                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES THE SERV_ORDER_PEND COL ON CSS_PREMISE.*        
      *                                                                *        
      *                                                                *        
      *  INPUT PARAMETERS                OUTPUT PARAMETERS             *        
      *  -------------------------       -----------------------       *        
      *  PREMISE-NO         S9(10)V      RETURN-CODE        S9(9)      *        
      *  SERV_ORDER_PEND    X(01)                                      *        
      *                                                                *        
      *  THE FOLLOWING TABLES ARE USED :                               *        
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID              *        
      *      ------------------  -----------    ---------              *        
      *      CSS_PREMISE         TBPREM         PR                     *        
      *      CSS_ACCOUNT         TBACCT         AT                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/03/95    FAM      PROCEDURE ORIGINALLY CODED.              *        
      *  11/20/95    AS       PARMS PARM-DNP-ORDER-PEND                *        
      *                       AND   PARM-ACCOUNT-NO ADDED.             *        
      *  01/27/97    WMG      TPR 8807 - SKIP ACCOUNT FUNCTIONALITY    *        
      *                       WHEN PROCESSING PREMISE ONLY ORDERS.     *        
CBSI  *  08/14/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
REARCH*  03/14/07    VD41351  PROGRAM DIDN'T RETURN CORRECT RETURN-CODE*        
REARCH*                       EVEN THOUGH IT WAS FAILED IN UPDATE STATE*        
REARCH*                       MENT AND WRITTEN AN ERROR IN ERRORLOG.   *        
ACT188*  05/30/16    MR7E794  REMOVED UNUSED COPYBOOKS.                *        
ACT188*              A05460                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02120'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02120 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
      *--------< CSS_ACCOUNT  >                                                 
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
CVT200*--------< CSS_SO_DATA  >                                                 
                                                                        
CVT200     EXEC SQL                                                             
CVT200        INCLUDE TBSODAT                                                   
CVT200     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *--------< CONTAINS BREAKDOWN FOR CODES-DATA-PRESENT >                    
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02120'.    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-SCRTCH-CHANGED-FLAG    PIC X(03) VALUE 'NO '.         
               88 SCRTCH-CHANGED                   VALUE 'YES'.         
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
ACT188     05  WS-YES                   PIC X(1) VALUE SPACES.          
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05  WS-NULLIND               PIC S9(4)   COMP.               
COB305     05 WS-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.             
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.             
           05  WS-SERV-ORDER-PEND       PIC X(01).                      
           05  WS-DNP-ORDER-PEND        PIC X(01).                      
           05  WS-SO-OFF-DATE           PIC X(10).                      
           05  WS-ASSIGNED-DATE         PIC X(10).                      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-COMMON                PIC X(1) VALUE 'C'.             
           05  WS-SUMMER                PIC X(1) VALUE 'S'.             
           05  WS-TEST                  PIC X(1) VALUE 'T'.             
           05  WS-ACTIVE                PIC X(1) VALUE 'A'.             
           05  WS-INACTIVE              PIC X(1) VALUE 'I'.             
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                 POINTER.                                
CVT999*    05  GWL-INIT-HANDLE          POINTER.                                
CVT999*    05  GWL-RC                   PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
CVT999*    05  PARM-ID1                 PIC S9(9) COMP VALUE 1.                 
           05  PARM-PREMISE-NO          PIC X(10) VALUE SPACES.         
           05  PARM-PREMISE-NO-RED      REDEFINES PARM-PREMISE-NO       
                                        PIC 9(10).                      
           05  PARM-ACCOUNT-NO          PIC X(13) VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                        PIC 9(13).                      
           05  PARM-SERV-ORDER-PEND     PIC X(01).                      
           05  PARM-DNP-ORDER-PEND      PIC X(01).                      
           05  PARM-SO-OFF-DATE         PIC X(10).                      
           05  PARM-ORDER-TYPE-CD       PIC X(05).                      
           05  PARM-ORDER-STATE-CD      PIC X(01).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-NULL-IND             PIC S9(04) COMP VALUE 0.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RETURN-CODE           PIC X(11) VALUE                         
CVT999*                                        'RETURN_CODE'.                   
CVT999*                                                                         
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ORDER-TYPE-CD       PIC X(05)                .          
CVT000 01  LINK-ORDER-STATE-CD      PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-PREMISE-NO                                         
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-ORDER-TYPE-CD                                      
CVT000         ,LINK-ORDER-STATE-CD                                     
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                         
REARCH     IF  CTR-ROWS < 1                                             
REARCH         INITIALIZE GTT-RETURN-FIELDS                             
REARCH         MOVE +100               TO RS-RETURN-CODE                
REARCH                                    S-RETURN-CODE                 
REARCH        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
REARCH     END-IF.                                                      
      *                                                                         
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000        DECLARE C1 CURSOR  FOR                         
CVT000            SELECT :S-RETURN-CODE AS RETURN_CODE                  
CVT000            FROM CIS.SYSDUMMY1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*           SELECT :S-RETURN-CODE AS RETURN_CODE                          
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-ORDER-TYPE-CD        TO PARM-ORDER-TYPE-CD       . 
CVT000     MOVE LINK-ORDER-STATE-CD       TO PARM-ORDER-STATE-CD      . 
                                                                        
CVT200* D0000206 HAS BEEN MANUALLY CONVERTED INTO THIS RPC                      
CVT200     MOVE PARM-PREMISE-NO-RED       TO VO-PREMISE-NO.             
CVT200     IF PARM-ORDER-TYPE-CD(1:3) = 'DNP'                           
CVT200          MOVE 'Y'                  TO PARM-DNP-ORDER-PEND        
CVT200     ELSE                                                         
CVT200          MOVE 'N'                  TO PARM-DNP-ORDER-PEND        
CVT200     END-IF                                                       
CVT200     PERFORM 7100-SELECT-SODATA     THRU 7100-EXIT.               
CVT200     IF WS-ACTIVE-RETURN-CODE = 0 THEN                            
CVT200        MOVE 'Y'                    TO PARM-SERV-ORDER-PEND       
CVT200     ELSE                                                         
CVT200        MOVE 'N'                    TO PARM-SERV-ORDER-PEND       
CVT200     END-IF.                                                      
CVT200     PERFORM 7200-SELECT-ASSGNDT    THRU 7200-EXIT.               
CVT200     IF WS-ACTIVE-RETURN-CODE = 0 THEN                            
CVT200        MOVE WS-ASSIGNED-DATE       TO PARM-SO-OFF-DATE           
CVT200     ELSE                                                         
CVT200        MOVE SPACES                 TO PARM-SO-OFF-DATE           
CVT200     END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS        THRU 1100-EXIT.            
                                                                        
           MOVE PARM-PREMISE-NO-RED          TO WS-PREMISE-NO.          
           MOVE PARM-ACCOUNT-NO-RED          TO WS-ACCOUNT-NO.          
           MOVE PARM-SERV-ORDER-PEND         TO WS-SERV-ORDER-PEND.     
           MOVE PARM-DNP-ORDER-PEND          TO WS-DNP-ORDER-PEND.      
           MOVE PARM-SO-OFF-DATE             TO WS-SO-OFF-DATE.         
                                                                        
           IF WS-SO-OFF-DATE = SPACES                                   
              MOVE -1                        TO WS-NULL-IND             
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                                  TO PARM-ID1.                  
CVT999*    MOVE LENGTH OF PARM-SERV-ORDER-PEND    TO MAX-LENGTH-PARM.           
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-SERV-ORDER-PEND,                          
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                                  TO PARM-ID1.                  
CVT999*    MOVE LENGTH OF PARM-DNP-ORDER-PEND     TO MAX-LENGTH-PARM.           
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-DNP-ORDER-PEND,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                                  TO PARM-ID1.                  
CVT999*    MOVE LENGTH OF PARM-SO-OFF-DATE        TO MAX-LENGTH-PARM.           
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-SO-OFF-DATE,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           5000-UPDATE                                          *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.           
           PERFORM 5000-UPDATE                THRU 5000-EXIT.           
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     CALLS 9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET. HERE IT IS THE     *        
      *     RETURN CODE ONLY.                                          *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                   TO ACTIVE-PARAGRAPH.           
                                                                        
CVT999*    MOVE 1                        TO CTR-COLUMN.                         
CVT999*    MOVE TDSINT4                  TO DB-HOST-TYPE.                       
CVT999*    MOVE TDSINT4                  TO DB-CLIENT-TYPE.                     
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR      THRU 9100-EXIT.                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      *     CALLS 8200-UPDATE-PREMISE                                  *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     UPDATES THE PREMISE TABLE DEPENDING ON THE FLAG SENT.      *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           IF WS-SERV-ORDER-PEND NOT = SPACES OR                        
              WS-SO-OFF-DATE     NOT = SPACES                           
              PERFORM 8200-UPDATE-PREMISE  THRU 8200-EXIT               
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-NO > ZEROS                                     
              IF PARM-DNP-ORDER-PEND = 'Y'                              
                 PERFORM 7000-SELECT-ACCOUNT  THRU 7000-EXIT            
                                                                        
                 MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT  
                 MOVE 'A'                     TO WS-CODE-PENDING-DNP    
                 MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT  
                                                                        
                 PERFORM 8300-UPDATE-ACCOUNT  THRU 8300-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7000-SELECT-ACCOUNT                                           *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     SELECTS CODES-DATA-PRESENT FROM CSS_ACCOUNT               *         
      *****************************************************************         
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
                INTO :AT-CODES-DATA-PRESENT                             
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7100-SELECT-SODATA.                                           *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     SELECTS IF ORDER EXISTS FOR ORDER STATE CD Z OR C         *         
      *****************************************************************         
       7100-SELECT-SODATA.                                              
                                                                        
           MOVE '7000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
REARCH*    EXEC SQL                                                             
REARCH*       SELECT DISTINCT 'Y'                                               
REARCH*         INTO :WS-Y                                                      
REARCH*         FROM CSS_SO_DATA                                                
REARCH*        WHERE PREMISE_NO =  :VO-PREMISE-NO                               
REARCH*          AND ORDER_STATE_CD NOT IN ('Z','C')                            
REARCH*    END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                     
REARCH        SELECT TOP(1) 'Y'                                                
ACT188          INTO :WS-YES                                            
REARCH          FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
REARCH         WHERE PREMISE_NO =  :VO-PREMISE-NO                       
REARCH           AND ORDER_STATE_CD NOT IN ('Z','C')                    
REARCH                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-YES                                                    
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO =  :VO-PREMISE-NO                               
MFA-TR*          AND ORDER_STATE_CD NOT IN ('Z','C')                            
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-PREMISE-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7200-SELECT-ASSGNDT.                                          *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     SELECTS CSS_SO_DATA TO FIND OUT MIN ASSIGNDATE FOR A PREMISE        
      *****************************************************************         
       7200-SELECT-ASSGNDT.                                             
                                                                        
           MOVE '7200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) COALESCE(CAST ( CIS.CHAR2$DATE(CAST(MIN(
           ASSIGNED_DATETIME) AS DATE),'USA') AS CHAR(10)), ' ' )            
               INTO :WS-ASSIGNED-DATE                                   
               FROM CSS_SO_DATA WITH(READUNCOMMITTED)                           
              WHERE PREMISE_NO = :VO-PREMISE-NO                         
                AND ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03','CC001'   
                                      ,'CC002','CC003','NC001','DNPFB') 
                AND ORDER_STATE_CD NOT IN ('Z','C')                     
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COALESCE(CAST ( CHAR(DATE(MIN(ASSIGNED_DATETIME)            
MFA-TR*                           ),USA) AS CHAR(10)), ' ' )                    
MFA-TR*        INTO :WS-ASSIGNED-DATE                                           
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*       WHERE PREMISE_NO = :VO-PREMISE-NO                                 
MFA-TR*         AND ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03','CC001'           
MFA-TR*                               ,'CC002','CC003','NC001','DNPFB')         
MFA-TR*         AND ORDER_STATE_CD NOT IN ('Z','C')                             
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-PREMISE-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8200-UPDATE-PREMISE                                           *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     UPDATES CSS_PREMISE.                                      *         
      *****************************************************************         
       8200-UPDATE-PREMISE.                                             
                                                                        
           MOVE '8200'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET SERV_ORDER_PEND = :WS-SERV-ORDER-PEND,             
                     PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-SO-OFF-DATE 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-SO-OFF-DATE 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:WS-SO-OFF-DATE :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-SO-OFF-DATE :WS-NULL-IND
              ), CONVERT(DATE, :WS-SO-OFF-DATE :WS-NULL-IND) )      
               WHERE PREMISE_NO = :WS-PREMISE-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET SERV_ORDER_PEND = :WS-SERV-ORDER-PEND,                     
MFA-TR*              PEND_OFF_ORD_DT = :WS-SO-OFF-DATE:WS-NULL-IND              
MFA-TR*        WHERE PREMISE_NO = :WS-PREMISE-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'SERV_ORDER_PEND'          TO TABLE-ELEMENT-2        
CBSI          MOVE WS-SERV-ORDER-PEND         TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'PEND_OFF_ORD_DT'          TO TABLE-ELEMENT-3        
CBSI          MOVE WS-SO-OFF-DATE             TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8300-UPDATE-ACCOUNT                                           *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     UPDATES CSS_ACCOUNT.                                      *         
      *****************************************************************         
       8300-UPDATE-ACCOUNT.                                             
                                                                        
           MOVE '8300'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
