       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02109.                                         
COB303 DATE-WRITTEN.     JUNE 14, 1995.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S109 CONVERTED TO DB2 SP CSR02109 ON 06/13/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S109                                           *        
      *  PROGRAM:       S109                                           *        
      *  CALLING SP:    PN_S109                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              *        
      * DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        *        
      *                                                                *        
      * THIS PROGRAM RETURNS ICP, METER, ACCOUNT AND PREMISE DETAILS.  *        
      *                                                                *        
      * INCLUDED DETAILS FOR THE ICP: FLAGS INDICATING WHETHER FIXED   *        
      * FACTOR, BILL CONTRACT, AND/OR INTERRUPT ACCOUNT ITEMS EXIST;   *        
      * TIME-OF-USE INFORMATION FOR THE ICP'S RATE.                    *        
      *                                                                *        
      * INCLUDED DETAILS FOR THE METER: INDICATORS FOR A MASTER/       *        
      * DEPENDENT METER RELATIONSHIP.                                  *        
      *                                                                *        
      * INCLUDED DETAILS FOR THE ACCOUNT: INDICATOR FOR AN EPP ACCOUNT.*        
      *                                                                *        
      * INCLUDED DETAILS FOR THE PREMISE: REVENUE DISTRICT.            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/14/95    JHR      CREATED.                                 *        
      *                                                                *        
CBSI  *  08/11/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
P00251* 11/04/10   AW41078   ADD FETCH FIRST 1 ROW ONLY TO 7700 DUE TO*         
P00251*                      CSS_UTL_BILL_REL PRIMARY KEY CHANGES TO   *        
P00251*                      AVOID ANY -811 ERRORS.                    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02109'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S109 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBINTACT                                                  
           END-EXEC.                                                            
      *    EXEC SQL                                                             
      *       INCLUDE TBMODEL                                                   
      *    END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SYBASE OPEN SERVER FOR CICS FACILITIES                                  
CVT999*    COPY SYGWCOB.                                                        
      * ADDED TO SUPPORT CICS RPCS                                              
CVT999*    COPY SYDBCOB.                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
CVT999*    COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      * CODES DATA PRESENT WORK AREA                                            
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S109    '.      
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACTION-CODE        PIC X(01) VALUE SPACES.          
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-ACCOUNT-NO-NUM     PIC S9(13)V COMP-3 VALUE 0.      
           05  PARM-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.          
           05  PARM-IC-NO              PIC S9(4) COMP VALUE 0.          
           05  PARM-PREMISE-NO         PIC X(10) VALUE SPACES.          
           05  PARM-PREMISE-NO-RED     REDEFINES PARM-PREMISE-NO        
                                       PIC 9(10).                       
           05  PARM-PREMISE-NO-NUM     PIC S9(10)V COMP-3 VALUE 0.      
           05  PARM-RATE-PLAN-NO       PIC X(03) VALUE SPACES.          
           05  PARM-METER-REF-NO       PIC S9(4) COMP VALUE 0.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-EPP-ACCOUNT          PIC X(01) VALUE 'A'.             
           05  WS-IDR-TYPE             PIC X(01) VALUE 'I'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-UPDATE-CODE          PIC X(01) VALUE 'U'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-CMPNT-ID-CD          PIC X(02) VALUE '10'.            
           05  MULTIPLE-ROWS           PIC S9(3) VALUE -811.            
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-FCTR-EXISTS-FLAG     PIC X(03) VALUE 'NO '.           
               88 FCTR-EXISTS                    VALUE 'YES'.           
           05  WS-CNTRCT-EXISTS-FLAG   PIC X(03) VALUE 'NO '.           
               88 CNTRCT-EXISTS                  VALUE 'YES'.           
           05  WS-INTRRPT-EXISTS-FLAG  PIC X(03) VALUE 'NO '.           
               88 INTRRPT-EXISTS                 VALUE 'YES'.           
           05  WS-MASTER-METER-FLAG    PIC X(03) VALUE 'NO '.           
               88 MASTER-METER                   VALUE 'YES'.           
           05  WS-DEPEND-METER-FLAG    PIC X(03) VALUE 'NO '.           
               88 DEPEND-METER                   VALUE 'YES'.           
           05  WS-TOU-EXISTS-FLAG      PIC X(03) VALUE 'NO '.           
               88 TOU-EXISTS                     VALUE 'YES'.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-FIXED-FACTORS-IND   PIC X(01)      VALUE SPACES.      
           05  RS-BILL-CONTRACT-IND   PIC X(01)      VALUE SPACES.      
           05  RS-INTERRUPT-ACCT-IND  PIC X(01)      VALUE SPACES.      
           05  RS-EPP-ACCOUNT-IND     PIC X(01)      VALUE SPACES.      
           05  RS-REV-DISTRICT-CD     PIC X(03)      VALUE SPACES.      
           05  RS-ENERGY-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-DEMAND-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-MASTER-MTR-IND      PIC X(01)      VALUE SPACES.      
           05  RS-DEPEND-MTR-IND      PIC X(01)      VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE        PIC X(11) VALUE                           
CVT999*                                         'RETURN_CODE'.                  
CVT999*    05  CNS-FIXED-FACTORS-IND  PIC X(17) VALUE                           
CVT999*                                         'FIXED_FACTORS_IND'.            
CVT999*    05  CNS-BILL-CONTRACT-IND  PIC X(17) VALUE                           
CVT999*                                         'BILL_CONTRACT_IND'.            
CVT999*    05  CNS-INTERRUPT-ACCT-IND PIC X(18) VALUE                           
CVT999*                                         'INTERRUPT_ACCT_IND'.           
CVT999*    05  CNS-EPP-ACCOUNT-IND    PIC X(15) VALUE                           
CVT999*                                         'EPP_ACCOUNT_IND'.              
CVT999*    05  CNS-REV-DISTRICT-CD    PIC X(15) VALUE                           
CVT999*                                         'REV_DISTRICT_CD'.              
CVT999*    05  CNS-ENERGY-TYPE-CD     PIC X(14) VALUE                           
CVT999*                                        'ENERGY_TYPE_CD'.                
CVT999*    05  CNS-DEMAND-TYPE-CD     PIC X(14) VALUE                           
CVT999*                                        'DEMAND_TYPE_CD'.                
CVT999*    05  CNS-MASTER-MTR-IND     PIC X(14) VALUE                           
CVT999*                                        'MASTER_MTR_IND'.                
CVT999*    05  CNS-DEPEND-MTR-IND     PIC X(14) VALUE                           
CVT999*                                        'DEPEND_MTR_IND'.                
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      * NO CURSORS IN THIS PROCEDURE.                                           
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACTION-CODE         PIC X(01)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
COB305 01 LINK-ACCOUNT-NO-NUM        PIC S9(13)V COMP-3 VALUE 0.          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-IC-NO               PIC S9(4) COMP           .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
COB305 01 LINK-PREMISE-NO-NUM        PIC S9(10)V COMP-3 VALUE 0.          
CVT000 01  LINK-RATE-PLAN-NO        PIC X(03)                .          
CVT000 01  LINK-METER-REF-NO        PIC S9(4) COMP           .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACTION-CODE                                        
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-RATE-PLAN-NO                                       
CVT000         ,LINK-METER-REF-NO                                       
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          GWL-INIT-HANDLE.                               
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          GWL-INIT-HANDLE,                               
CVT999*                          SNA-CONNECTION-NAME,                           
CVT999*                          SNA-SUBC.                                      
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC,                                      
CVT999*                          GWL-RC.                                        
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
CVT999*       MOVE 'TDRESULT- NO RPC PARM SENT' TO ABEND-FUNCTION               
CVT999*       MOVE 'CICS TRANSACTION'           TO TABLE-1                      
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-FIXED-FACTORS-IND        AS    FIXED_FACTORS_IND      
CVT000       ,:RS-BILL-CONTRACT-IND        AS    BILL_CONTRACT_IND      
CVT000       ,:RS-INTERRUPT-ACCT-IND       AS    INTERRUPT_ACCT_IND     
CVT000       ,:RS-EPP-ACCOUNT-IND          AS    EPP_ACCOUNT_IND        
CVT000       ,:RS-REV-DISTRICT-CD          AS    REV_DISTRICT_CD        
CVT000       ,:RS-ENERGY-TYPE-CD           AS    ENERGY_TYPE_CD         
CVT000       ,:RS-DEMAND-TYPE-CD           AS    DEMAND_TYPE_CD         
CVT000       ,:RS-MASTER-MTR-IND           AS    MASTER_MTR_IND         
CVT000       ,:RS-DEPEND-MTR-IND           AS    DEPEND_MTR_IND         
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-FIXED-FACTORS-IND        AS    FIXED_FACTORS_IND              
MFA-TR*      ,:RS-BILL-CONTRACT-IND        AS    BILL_CONTRACT_IND              
MFA-TR*      ,:RS-INTERRUPT-ACCT-IND       AS    INTERRUPT_ACCT_IND             
MFA-TR*      ,:RS-EPP-ACCOUNT-IND          AS    EPP_ACCOUNT_IND                
MFA-TR*      ,:RS-REV-DISTRICT-CD          AS    REV_DISTRICT_CD                
MFA-TR*      ,:RS-ENERGY-TYPE-CD           AS    ENERGY_TYPE_CD                 
MFA-TR*      ,:RS-DEMAND-TYPE-CD           AS    DEMAND_TYPE_CD                 
MFA-TR*      ,:RS-MASTER-MTR-IND           AS    MASTER_MTR_IND                 
MFA-TR*      ,:RS-DEPEND-MTR-IND           AS    DEPEND_MTR_IND                 
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACTION-CODE          TO PARM-ACTION-CODE         . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO        . 
CVT000     MOVE LINK-METER-REF-NO         TO PARM-METER-REF-NO        . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
                                                                        
           MOVE PARM-ACCOUNT-NO-RED      TO PARM-ACCOUNT-NO-NUM.        
           MOVE PARM-PREMISE-NO-RED      TO PARM-PREMISE-NO-NUM.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     RECEIVE PASSED PARAMETERS.                                 *        
      *                                                                *        
      *     CALLED BY:  1000-PROCESS-INPUT                             *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACTION-CODE       TO MAX-LENGTH-PARM.            
           MOVE 'ACTION-CODE'                    TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACTION-CODE,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
           MOVE 'ACCOUNT-NO'                     TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
           MOVE 'CODE-UTIL-TYPE'                 TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-IC-NO             TO MAX-LENGTH-PARM.            
           MOVE 'IC-NO'                          TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-IC-NO,                                    
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO        TO MAX-LENGTH-PARM.            
           MOVE 'PREMISE-NO'                     TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-RATE-PLAN-NO      TO MAX-LENGTH-PARM.            
           MOVE 'RATE-PLAN-NO'                   TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-RATE-PLAN-NO,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-METER-REF-NO      TO MAX-LENGTH-PARM.            
           MOVE 'RATE-PLAN-NO'                   TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-METER-REF-NO,                             
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
           PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1150-CHECK-ERROR.                                              *        
      *     CHECK FOR ERROR RECEIVING PARAMETERS.                      *        
      *                                                                *        
      *      CALLED BY: 1100-RECEIVE-PARMS.                            *        
      ******************************************************************        
       1150-CHECK-ERROR.                                                
                                                                        
CVT999*    IF GWL-RC NOT = TDS-OK                                               
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
CVT999*       MOVE 'TDRCVPRM - PARAMETER ERROR' TO ABEND-FUNCTION               
CVT999*       MOVE WS-RCVPRM                    TO TABLE-1                      
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
CVT999*    END-IF.                                                              
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     DESCRIBE RESULT SET.                                       *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-FIXED-FACTORS-IND  TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-FIXED-FACTORS-IND TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FIXED-FACTORS-IND,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FIXED-FACTORS-IND,                         
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-BILL-CONTRACT-IND  TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-BILL-CONTRACT-IND TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BILL-CONTRACT-IND,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BILL-CONTRACT-IND,                         
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-INTERRUPT-ACCT-IND  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-INTERRUPT-ACCT-IND TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-INTERRUPT-ACCT-IND,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-INTERRUPT-ACCT-IND,                        
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-EPP-ACCOUNT-IND     TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-EPP-ACCOUNT-IND    TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-EPP-ACCOUNT-IND,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-EPP-ACCOUNT-IND,                           
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-REV-DISTRICT-CD     TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-REV-DISTRICT-CD    TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-REV-DISTRICT-CD,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-REV-DISTRICT-CD,                           
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-ENERGY-TYPE-CD      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-ENERGY-TYPE-CD     TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ENERGY-TYPE-CD,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ENERGY-TYPE-CD,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DEMAND-TYPE-CD      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DEMAND-TYPE-CD     TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEMAND-TYPE-CD,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DEMAND-TYPE-CD,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MASTER-MTR-IND      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MASTER-MTR-IND     TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MASTER-MTR-IND,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MASTER-MTR-IND,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DEPEND-MTR-IND      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DEPEND-MTR-IND     TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEPEND-MTR-IND,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DEPEND-MTR-IND,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     IF THE ACTION CODE IS UPDATE: CHECK IF THE ICP HAS         *        
      *     ASSOCIATED FIXED FACTORS, BILL CONTRACTS, AND/OR INTERRUPT *        
      *     ACCOUNT DETAILS; DETERMINE IF THE METER IS IN A MASTER/    *        
      *     DEPENDENT RELATIONSHIP; DETERMINE IF THE RATE IS TIME-OF-  *        
      *     USE.                                                       *        
      *                                                                *        
      *     FOR ALL ACTION CODES: DETERMINE IF THE ACCOUNT IS EPP;     *        
      *     DETERMINE THE REVENUE DISTRICT OF THE PREMISE (USED IN     *        
      *     READ ROUTE VALIDATIONS AGAINST SYBASE USER TABLES).        *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           IF PARM-ACTION-CODE = WS-UPDATE-CODE                         
                                                                        
              MOVE PARM-ACCOUNT-NO-NUM   TO FF-ACCOUNT-NO               
                                            BK-ACCOUNT-NO               
                                            IP-ACCOUNT-NO               
              MOVE PARM-CODE-UTIL-TYPE   TO FF-CODE-UTIL-TYPE           
                                            BK-CODE-UTIL-TYPE           
                                            IP-CODE-UTIL-TYPE           
                                            J1-CODE-UTIL-TYPE           
                                            RT-CODE-UTIL-TYPE           
              MOVE PARM-IC-NO            TO FF-IC-NO                    
                                            BK-IC-NO                    
                                            IP-IC-NO                    
              MOVE PARM-RATE-PLAN-NO     TO J1-RATE-PLAN-NO             
                                            RT-RATE-PLAN-NO             
              MOVE WS-CMPNT-ID-CD        TO J1-CMPNT-ID-CD              
              MOVE WS-ACTIVE-CODE        TO RT-CODE-STATUS              
                                                                        
      *       DETERMINE IF FIXED FACTORS EXIST.                                 
              PERFORM 7000-SELECT-FIXED-FCTRS     THRU 7000-EXIT        
              IF FCTR-EXISTS                                            
                 MOVE WS-YES             TO RS-FIXED-FACTORS-IND        
              ELSE                                                      
                 MOVE WS-NO              TO RS-FIXED-FACTORS-IND        
              END-IF                                                    
              MOVE SUCCESSFUL-CALL       TO WS-ACTIVE-RETURN-CODE       
                                                                        
      *       DETERMINE IF BILL CONTRACT ITEMS EXIST.                           
              PERFORM 7100-SELECT-BILL-CNTRCT     THRU 7100-EXIT        
              IF CNTRCT-EXISTS                                          
                 MOVE WS-YES             TO RS-BILL-CONTRACT-IND        
              ELSE                                                      
                 MOVE WS-NO              TO RS-BILL-CONTRACT-IND        
              END-IF                                                    
              MOVE SUCCESSFUL-CALL       TO WS-ACTIVE-RETURN-CODE       
                                                                        
      *       DETERMINE IF INTERRUPT ACCOUNT ITEMS EXIST.                       
              PERFORM 7200-SELECT-INTRRPT-ACCT    THRU 7200-EXIT        
              IF INTRRPT-EXISTS                                         
                 MOVE WS-YES             TO RS-INTERRUPT-ACCT-IND       
              ELSE                                                      
                 MOVE WS-NO              TO RS-INTERRUPT-ACCT-IND       
              END-IF                                                    
              MOVE SUCCESSFUL-CALL       TO WS-ACTIVE-RETURN-CODE       
                                                                        
              IF PARM-METER-REF-NO > 0                                  
      *          DETERMINE IF THE METER IS A MASTER METER.                      
                 MOVE PARM-ACCOUNT-NO-NUM TO UR-ACCOUNT-NO-MST          
                 MOVE PARM-CODE-UTIL-TYPE TO UR-CODE-UTIL-TYPE-MST      
                 MOVE PARM-IC-NO          TO UR-IC-NO-MST               
                 MOVE PARM-METER-REF-NO   TO UR-MTR-REF-NO-MST          
                                                                        
                 PERFORM 7600-SELECT-MST-MTR-REL  THRU 7600-EXIT        
                 IF MASTER-METER                                        
                    MOVE WS-YES           TO RS-MASTER-MTR-IND          
                 ELSE                                                   
                    MOVE WS-NO            TO RS-MASTER-MTR-IND          
                 END-IF                                                 
                 MOVE SUCCESSFUL-CALL     TO WS-ACTIVE-RETURN-CODE      
                                                                        
      *          DETERMINE IF THE METER IS A DEPENDENT METER.                   
                 MOVE PARM-ACCOUNT-NO-NUM TO UR-ACCOUNT-NO-DEP          
                 MOVE PARM-CODE-UTIL-TYPE TO UR-CODE-UTIL-TYPE-DEP      
                 MOVE PARM-IC-NO          TO UR-IC-NO-DEP               
                 MOVE PARM-METER-REF-NO   TO UR-MTR-REF-NO-DEP          
                                                                        
                 PERFORM 7700-SELECT-DEP-MTR-REL  THRU 7700-EXIT        
                 IF DEPEND-METER                                        
                    MOVE WS-YES           TO RS-DEPEND-MTR-IND          
                 ELSE                                                   
                    MOVE WS-NO            TO RS-DEPEND-MTR-IND          
                 END-IF                                                 
                 MOVE SUCCESSFUL-CALL     TO WS-ACTIVE-RETURN-CODE      
              ELSE                                                      
                 MOVE WS-NO               TO RS-MASTER-MTR-IND          
                 MOVE WS-NO               TO RS-DEPEND-MTR-IND          
              END-IF                                                    
                                                                        
      *       SELECT THE DEMAND AND ENERGY TIME-OF-USE CODES.                   
      *       A NOT-FOUND CALL INDICATES THAT THE RATE IS IDR.                  
              PERFORM 7500-SELECT-TOU-PERIODS     THRU 7500-EXIT        
              IF TOU-EXISTS                                             
                 MOVE J1-REG-TYPE-CD     TO RS-ENERGY-TYPE-CD           
                 MOVE J1-DEM-REG-TYPE-CD TO RS-DEMAND-TYPE-CD           
              ELSE                                                      
                 MOVE WS-IDR-TYPE        TO RS-ENERGY-TYPE-CD           
                 MOVE WS-IDR-TYPE        TO RS-DEMAND-TYPE-CD           
                 MOVE SUCCESSFUL-CALL    TO WS-ACTIVE-RETURN-CODE       
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              MOVE WS-NO                 TO RS-FIXED-FACTORS-IND        
              MOVE WS-NO                 TO RS-BILL-CONTRACT-IND        
              MOVE WS-NO                 TO RS-INTERRUPT-ACCT-IND       
              MOVE WS-NO                 TO RS-MASTER-MTR-IND           
              MOVE WS-NO                 TO RS-DEPEND-MTR-IND           
                                                                        
           END-IF.                                                      
                                                                        
      *    DETERMINE IF THE ACCOUNT IS EPP.                                     
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM      TO AT-ACCOUNT-NO.              
                                                                        
           PERFORM 7300-SELECT-ACCOUNT        THRU 7300-EXIT.           
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           IF WS-CODE-BUDGET = WS-EPP-ACCOUNT                           
              MOVE WS-YES                TO RS-EPP-ACCOUNT-IND          
           ELSE                                                         
              MOVE WS-NO                 TO RS-EPP-ACCOUNT-IND          
           END-IF.                                                      
                                                                        
      *    DETERMINE THE REVENUE DISTRICT OF THE PREMISE.                       
                                                                        
           MOVE PARM-PREMISE-NO-NUM      TO PR-PREMISE-NO.              
                                                                        
           PERFORM 7400-SELECT-PREMISE        THRU 7400-EXIT.           
           MOVE PR-REV-DISTRICT-CD       TO RS-REV-DISTRICT-CD.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-FIXED-FCTRS.                                       *        
      *     DETERMINE IF ONE OR MANY ROWS OF FIXED FACTORS EXIST FOR   *        
      *     A GIVEN ICP.                                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-SELECT-FIXED-FCTRS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'YES'                                              
              INTO   :WS-FCTR-EXISTS-FLAG                               
              FROM   CSS_FIXED_FCTR                                     
              WHERE  CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE            
              AND    IC_NO              = :FF-IC-NO                     
              AND    ACCOUNT_NO         = :FF-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
                                      OR NOT-FOUND                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_FIXED_FCTR'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-2        
              MOVE FF-IC-NO                   TO HOSTVAR-ELEMENT-2      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE FF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-BILL-CNTRCT.                                       *        
      *     DETERMINE IF ONE OR MANY ROWS OF BILL CONTRACTS EXIST FOR  *        
      *     A GIVEN ICP.                                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-SELECT-BILL-CNTRCT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'YES'                                              
              INTO   :WS-CNTRCT-EXISTS-FLAG                             
              FROM   CSS_BILL_CONTRACT                                  
              WHERE  CODE_UTIL_TYPE     = :BK-CODE-UTIL-TYPE            
              AND    IC_NO              = :BK-IC-NO                     
              AND    ACCOUNT_NO         = :BK-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
                                OR NOT-FOUND                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_CONTRACT'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE BK-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-2        
              MOVE BK-IC-NO                   TO HOSTVAR-ELEMENT-2      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE BK-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-INTRRPT-ACCT.                                      *        
      *     DETERMINE IF ONE OR MANY ROWS OF INTERRUPT ACCOUNTS EXIST  *        
      *     FOR A GIVEN ICP.                                           *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7200-SELECT-INTRRPT-ACCT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT 'YES'                                              
              INTO   :WS-INTRRPT-EXISTS-FLAG                            
              FROM   CSS_INTERRUPT_ACCT                                 
              WHERE  CODE_UTIL_TYPE     = :IP-CODE-UTIL-TYPE            
              AND    IC_NO              = :IP-IC-NO                     
              AND    ACCOUNT_NO         = :IP-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
                                      OR NOT-FOUND                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
CBSI          MOVE SPACES                    TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
              MOVE 'CSS_INTERRUPT_ACCT'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE IP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-2         
              MOVE IP-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE IP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-SELECT-ACCOUNT.                                         *          
      *     SELECT ACCOUNT DATA CODES AND COMPANY NUMBER.            *          
      *                                                              *          
      *     CALLED BY:  2200-BUILD-RESULT                            *          
      ****************************************************************          
       7300-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
              INTO   :AT-CODES-DATA-PRESENT                             
              FROM   CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-PREMISE.                                           *        
      *     DETERMINE THE PREMISE'S REVENUE DISTRICT.                  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7400-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
             SELECT  REV_DISTRICT_CD                                    
               INTO  :PR-REV-DISTRICT-CD                                
               FROM  CSS_PREMISE                                        
              WHERE  PREMISE_NO = :PR-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-SELECT-TOU-PERIODS.                                       *        
      *     DETERMINE THE ENERGY AND DEMAND TIME-OF-USE PERIODS.       *        
      *                                                                *        
      *     A NOT-FOUND SQLCODE INDICATES THAT THE RATE IS IDR.        *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7500-SELECT-TOU-PERIODS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     A.REG_TYPE_CD,                                     
                     A.DEM_REG_TYPE_CD                                  
                INTO :WS-TOU-EXISTS-FLAG,                               
                     :J1-REG-TYPE-CD,                                   
                     :J1-DEM-REG-TYPE-CD                                
                FROM CSS_RATE_COMP_DEF A                                
               WHERE A.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE          
                 AND A.RATE_PLAN_NO       = :J1-RATE-PLAN-NO            
                 AND A.CMPNT_ID_CD        = :J1-CMPNT-ID-CD             
                 AND A.VERSION_NO_CNTRL   =                             
                     (SELECT MAX(B.VERSION_NO_CNTRL)                    
                        FROM CSS_RATE_CREATOR B                         
                       WHERE B.CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE      
                         AND B.RATE_PLAN_NO   = :RT-RATE-PLAN-NO        
                         AND B.CODE_STATUS    = :RT-CODE-STATUS)        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
CBSI          MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE J1-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-4        
CBSI          MOVE RT-CODE-STATUS             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-SELECT-MST-MTR-REL.                                       *        
      *     DETERMINE IF THE METER EXISTS AS A MASTER METER.           *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7600-SELECT-MST-MTR-REL.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'YES'                                              
                INTO :WS-MASTER-METER-FLAG                              
                FROM CSS_UTL_BILL_REL                                   
               WHERE ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST            
                 AND CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST        
                 AND IC_NO_MST          = :UR-IC-NO-MST                 
                 AND MTR_REF_NO_MST     = :UR-MTR-REF-NO-MST            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                   OR MULTIPLE-ROWS                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UTL_BILL_REL'         TO TABLE-1                
              MOVE 'ACCOUNT_NO_MST'           TO TABLE-ELEMENT-1        
              MOVE UR-ACCOUNT-NO-MST          TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE_MST'       TO TABLE-ELEMENT-2        
              MOVE UR-CODE-UTIL-TYPE-MST      TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO_MST'                TO TABLE-ELEMENT-3        
              MOVE UR-IC-NO-MST               TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'MTR_REF_NO_MST'           TO TABLE-ELEMENT-4        
CBSI          MOVE UR-MTR-REF-NO-MST          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SELECT-DEP-MTR-REL.                                       *        
      *     DETERMINE IF THE METER EXISTS AS A DEPENDENT METER.        *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7700-SELECT-DEP-MTR-REL.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES'                                              
                INTO :WS-DEPEND-METER-FLAG                              
                FROM CSS_UTL_BILL_REL                                   
               WHERE ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP            
                 AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP        
                 AND IC_NO_DEP          = :UR-IC-NO-DEP                 
                 AND MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP            
P00251                                            
P00251                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES'                                                      
MFA-TR*         INTO :WS-DEPEND-METER-FLAG                                      
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                    
MFA-TR*          AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP                
MFA-TR*          AND IC_NO_DEP          = :UR-IC-NO-DEP                         
MFA-TR*          AND MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UTL_BILL_REL'         TO TABLE-1                
              MOVE 'ACCOUNT_NO_DEP'           TO TABLE-ELEMENT-1        
              MOVE UR-ACCOUNT-NO-DEP          TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE_DEP'       TO TABLE-ELEMENT-2        
              MOVE UR-CODE-UTIL-TYPE-DEP      TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO_DEP'                TO TABLE-ELEMENT-3        
              MOVE UR-IC-NO-DEP               TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'MTR_REF_NO_DEP'           TO TABLE-ELEMENT-4        
CBSI          MOVE UR-MTR-REF-NO-DEP          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
