       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02108.                                         
COB303 DATE-WRITTEN. JUNE 14, 1995.                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S108 CONVERTED TO DB2 SP CSR02108 ON 10/21/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S108                                           *        
      *  PROGRAM:       S108                                           *        
      *  CALLING SP:    PA_S108                                                 
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES EPP OFFER INFORMATION FROM CSS_BUDGET_ *        
      *  HIST                                                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/14/95    SS       CREATED.                                 *        
      *                                                                *        
      *  02/26/97    WMG      TPR 9429 - RETURN THE MOST RECENT EPP    *        
      *                       OFFER AMOUNT AND DATE.                   *        
      *  03/19/98    SV       TPR 15469 - NO MC05 TO BE WRITTEN IF     *        
      *                       ACCOUNT NOT ON EPP                       *        
CBSI  *  08/11/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
C26130*  07/11/02   SRIDEVI   SEND ZEROES TO EPP-OFFER-AMT AND SPACES  *        
C26130*                       TO EPP-OFFER-DATE IF OFFER WAS REJECTED  *        
C28085*  01/08/03   SRIDEVI   SEND ZEROS TO EPP-OFFER-AMT AND SPACES TO*        
C28085*                       EPP-OFFER-DATE WHEN OFFER DETAILS ON     *        
C28085*                       CSS_ACCOUNT TABLE ARE WIPED OUT.         *        
REARCH*  10/21/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02108'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02108 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
C28085     EXEC SQL                                                             
C28085        INCLUDE TBACCT                                                    
C28085     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02108'.      
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-NULL-IND             PIC S9(4) COMP.                  
C28085     05  WS-NULL-IND-1           PIC S9(4) COMP.                  
           05  WS-EPP-PPL              PIC S9(4) COMP VALUE 50.         
           05  WS-OFFER-CHANGE-REASON  PIC X(01) VALUE 'O'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-EPP-OFFER-AMT        PIC S9(7)V99 COMP-3 VALUE 0.     
           05  RS-EPP-OFFER-DATE       PIC X(10) VALUE SPACES.          
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-EPP-OFFER-AMT         PIC S9(7)V99 COMP-3 VALUE 0.     
REARCH     05  S-EPP-OFFER-DATE        PIC X(10) VALUE SPACES.          
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE                          
CVT999*                                   'RETURN_CODE'.                        
CVT999*    05  CNS-EPP-OFFER-AMT       PIC X(13) VALUE                          
CVT999*                                   'EPP_OFFER_AMT'.                      
CVT999*    05  CNS-EPP-OFFER-DATE      PIC X(14) VALUE                          
CVT999*                                   'EPP_OFFER_DATE'.                     
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      *****************************************************************         
      *                                                                         
      * 0000-MAINLINE                                                           
      *                                                                         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *                                                                         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000       ,:S-EPP-OFFER-AMT            AS    EPP_OFFER_AMT           
CVT000       ,:S-EPP-OFFER-DATE           AS    EPP_OFFER_DATE          
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-EPP-OFFER-AMT            AS    EPP_OFFER_AMT                   
MFA-TR*      ,:S-EPP-OFFER-DATE           AS    EPP_OFFER_DATE                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS.                                            *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
REARCH*1100-RECEIVE-PARMS.                                                      
                                                                        
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM.                   
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
REARCH     MOVE RS-EPP-OFFER-AMT        TO S-EPP-OFFER-AMT.             
REARCH     MOVE RS-EPP-OFFER-DATE       TO S-EPP-OFFER-DATE.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
REARCH*2100-DESCRIBE-RESULT.                                                    
                                                                        
REARCH*    MOVE '2000' TO ACTIVE-PARAGRAPH.                                     
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSDECIMAL         TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSFLT8            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-EPP-OFFER-AMT    TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-EPP-OFFER-AMT   TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-EPP-OFFER-AMT,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-EPP-OFFER-AMT,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-EPP-OFFER-DATE   TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-EPP-OFFER-DATE  TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-EPP-OFFER-DATE,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-EPP-OFFER-DATE,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7100-SELECT-EPP-OFFER      THRU 7100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              MOVE 0                          TO RS-RETURN-CODE         
C28085        IF WS-NULL-IND-1 = -1                                     
C28085           MOVE SPACES                  TO AT-EPP-OFFER-DATE      
C28085        END-IF                                                    
C26130        IF AT-EPP-OFFER-DATE IS EQUAL TO SPACES AND               
C26130           AT-EPP-OFFER-AMOUNT = 0                                
C26130           MOVE 0                       TO RS-EPP-OFFER-AMT       
C26130           MOVE SPACES                  TO RS-EPP-OFFER-DATE      
C26130        ELSE                                                      
                 MOVE BH-EPP-ESTIMATE         TO RS-EPP-OFFER-AMT       
                 MOVE BH-DATE-PYMT-STRT       TO RS-EPP-OFFER-DATE      
REARCH           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
C26130        END-IF                                                    
           END-IF.                                                      
T15469     IF CTR-ROWS < 1                                              
T15469        INITIALIZE GTT-RETURN-FIELDS                              
T15469        MOVE SQLCODE  TO RS-RETURN-CODE                           
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
T15469        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
T15469     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7100-SELECT-EPP-OFFER.                                        *         
      *                                                               *         
      * SELECT EPP OFFER DATE AND AMOUNT                              *         
      *                                                               *         
      *****************************************************************         
       7100-SELECT-EPP-OFFER.                                           
                                                                        
           EXEC SQL                                                     
              SELECT BH.EPP_ESTIMATE,                                   
                     CIS.CHAR2$DATE(BH.DATE_PYMT_STRT, 'USA'),                  
C26130*              REMARKS                                                    
C28085               AT.EPP_OFFER_DATE,                                 
C28085               AT.EPP_OFFER_AMOUNT                                
                INTO :BH-EPP-ESTIMATE,                                  
                     :BH-DATE-PYMT-STRT :WS-NULL-IND,                    
C26130*              :BH-REMARKS                                                
C28085               :AT-EPP-OFFER-DATE :WS-NULL-IND-1,                 
C28085               :AT-EPP-OFFER-AMOUNT                               
                FROM CSS_BUDGET_HIST BH                                 
C28085              ,CSS_ACCOUNT     AT                                 
               WHERE BH.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
C28085           AND BH.ACCOUNT_NO        = AT.ACCOUNT_NO               
                 AND BH.PYMT_PRIORITY_LVL = :WS-EPP-PPL                 
                 AND BH.CHANGE_REASON     = :WS-OFFER-CHANGE-REASON     
                 AND BH.BUD_HIST_SEQ_NO   =                             
                              (SELECT MAX(BUD_HIST_SEQ_NO)              
                                 FROM CSS_BUDGET_HIST                   
                                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BH.EPP_ESTIMATE,                                           
MFA-TR*              CHAR(BH.DATE_PYMT_STRT, USA),                              
MFA-TR*              REMARKS                                                    
MFA-TR*              AT.EPP_OFFER_DATE,                                         
MFA-TR*              AT.EPP_OFFER_AMOUNT                                        
MFA-TR*         INTO :BH-EPP-ESTIMATE,                                          
MFA-TR*              :BH-DATE-PYMT-STRT:WS-NULL-IND,                            
MFA-TR*              :BH-REMARKS                                                
MFA-TR*              :AT-EPP-OFFER-DATE :WS-NULL-IND-1,                         
MFA-TR*              :AT-EPP-OFFER-AMOUNT                                       
MFA-TR*         FROM CSS_BUDGET_HIST BH                                         
MFA-TR*             ,CSS_ACCOUNT     AT                                         
MFA-TR*        WHERE BH.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*          AND BH.ACCOUNT_NO        = AT.ACCOUNT_NO                       
MFA-TR*          AND BH.PYMT_PRIORITY_LVL = :WS-EPP-PPL                         
MFA-TR*          AND BH.CHANGE_REASON     = :WS-OFFER-CHANGE-REASON             
MFA-TR*          AND BH.BUD_HIST_SEQ_NO   =                                     
MFA-TR*                       (SELECT MAX(BUD_HIST_SEQ_NO)                      
MFA-TR*                          FROM CSS_BUDGET_HIST                           
MFA-TR*                         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
T15469     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST'          TO TABLE-1                
C28085        MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2        
              MOVE 'CHANGE_REASON'            TO TABLE-ELEMENT-3        
              MOVE WS-ACCOUNT-NO-NUM          TO HOSTVAR-ELEMENT-1      
              MOVE '50'                       TO HOSTVAR-ELEMENT-2      
              MOVE WS-OFFER-CHANGE-REASON     TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
