       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02102.                                         
COB303 DATE-WRITTEN.     MAY 31, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S102 CONVERTED TO DB2 SP CSR02102 ON 08/09/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ****             SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S102                                           *        
      *  PROGRAM:       S102                                           *        
      *  CALLING SP:    PA_S102                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN TOP WINDOW OF    *        
      *  PANEL105 WHICH INVOLVES TABLES  BG, UC.                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  -------    -----------------------------------------*        
TP5406*  01/21/97  MACM       TPR5406-                                 *        
      *                       7920-SELECT-CP-DATE-START REMOVEDTHE     *        
      *                       CONDITION DATE_PLAN_START = :WS_DATE.    *        
      *                       _DIFFERENCE.                             *        
T15116*  03/02/97  MAO        ADDED CODE TO DETERMINE LATEST RATE      *        
      *                       VERSION. THIS WILL ENABLE THE RATE_ITEM  *        
      *                       _DESC TO BE PROPERLY RETRIEVED FROM      *        
      *                       UM_EQUIPMENT.                            *        
CBSI  *  08/05/98    CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE   *        
CBSI  *              MADRAS    ABEND PARAMETERS                        *        
REARCH*  08/09/05    CVNS      RPC TO COBOL CONVERSION.                *        
REARCH*              CHENNAI                                           *        
A04527*  06/07/13    AS7C117   REMOVE UNUSED COPYBOOK CWS00056.        *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02102'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02102 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
T15116     EXEC SQL                                                             
T15116        INCLUDE TBRTCRTR                                                  
T15116     END-EXEC.                                                            
T15116                                                                  
           EXEC SQL                                                             
               INCLUDE TBUMEQP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUMPLAN                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05 WS-NULL-INDICATORS.                                       
              10 WS-BG-DT-BILL-NULL-IND        PIC S9(4) COMP.          
              10 WS-UC-NO-UNITS-NULL-IND       PIC S9(4) COMP.          
              10 WS-UC-NO-DAYS-NULL-IND        PIC S9(4) COMP.          
              10 WS-UC-USAGE-FIXED-NULL-IND    PIC S9(4) COMP.          
              10 WS-UC-DT-ENDS-NULL-IND        PIC S9(4) COMP.          
              10 WS-UC-DIFF-NULL-IND           PIC S9(4) COMP.          
              10 WS-CP-REMOVE-DT-NULL-IND      PIC S9(4) COMP.          
              10 WS-CP-DT-START-NULL-IND       PIC S9(4) COMP.          
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                       PIC 9(13).                       
           05 WS-LIGHT-NO              PIC 9(7).                        
           05 WS-RS-LIGHT-NO  REDEFINES WS-LIGHT-NO                     
                                       PIC X(07).                       
           05 WS-ITM-IND-STATUS.                                        
              10 WS-CODE-BILL-ITM-IND  PIC X(01).                       
              10 WS-CODE-ITEM-STATUS   PIC X(01).                       
           05 WS-END-OF-BG             PIC X(01) VALUE 'N'.             
           05 WS-DB2-DATE              PIC X(10).                       
           05 WS-DB2-DATE-BREAK   REDEFINES WS-DB2-DATE.                
              10 WS-DB2-YYYY           PIC X(04).                       
              10 FILLER                PIC X(01).                       
              10 WS-DB2-MM             PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-DB2-DD             PIC X(02).                       
           05 WS-RS-FORMATED-DATE.                                      
              10 WS-RS-MM              PIC X(02).                       
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RS-DD              PIC X(02).                       
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-RS-YYYY            PIC X(04).                       
           05 WS-L9-UM-EQUIP-KWH       PIC S9(9) COMP.                  
           05 WS-CP-REMOVE-DATE        PIC X(10).                       
           05 WS-CP-CODE-PLAN-STATUS   PIC X(01).                       
           05 WS-SELECT-RETURN-CODE    PIC S9(9) COMP.                  
REARCH     05 PROGRAM-NAME             PIC X(08) VALUE 'CSR02102'.      
      * TO BE USED AS A HOST VARIABLE BY THE UC-FETCH-CURSOR. *                 
           05 WS-DATE-DIFFERENCE       PIC X(10).                       
T15116     05 WS-ACTIVE                PIC X(1) VALUE 'A'.              
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROCESS-1ST-BG-ROW-SW   PIC X(01) VALUE 'N'.             
               88 PROCESS-1ST-BG-ROW             VALUE 'Y'.             
           05  PROCESS-1ST-UC-ROW-SW   PIC X(01) VALUE 'N'.             
               88 PROCESS-1ST-UC-ROW             VALUE 'Y'.             
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-BILL-NO            PIC S9(9) COMP.                  
           05  PARM-CODE-UTIL-TYPE     PIC X(01).                       
           05  PARM-IC-NO              PIC S9(4) COMP.                  
           05  PARM-BILL-ITEM-TIMESTMP PIC X(26).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
            05 RS-DATE-ORIG-BILL      PIC X(10)      VALUE SPACES.      
            05 RS-IC-NO               PIC S9(4) COMP VALUE ZEROES.      
            05 RS-RATE-PLAN-NO        PIC X(3)       VALUE SPACES.      
            05 RS-RATE-DESC           PIC X(25)      VALUE SPACES.      
            05 RS-UM-EQUIP-SHRT-DESC  PIC X(36)      VALUE SPACES.      
            05 RS-NO-UNITS            PIC S999999999V COMP-3            
                                                     VALUE ZEROES.      
            05 RS-LIGHT-POLE-NO       PIC X(7)       VALUE SPACES.      
            05 RS-NO-DAYS             PIC S9(4) COMP VALUE ZEROES.      
            05 RS-USAGE-FIXED         PIC S999999999V COMP-3            
                                                     VALUE ZEROES.      
            05 RS-INSTALL-DATE        PIC X(10)      VALUE SPACES.      
            05 RS-REMOVE-DATE         PIC X(10)      VALUE SPACES.      
            05 RS-CODE-PLAN-STATUS    PIC X(1)       VALUE SPACE.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH      05 S-DATE-ORIG-BILL       PIC X(10)      VALUE SPACES.      
REARCH      05 S-IC-NO                PIC S9(4) COMP VALUE ZEROES.      
REARCH      05 S-RATE-PLAN-NO         PIC X(3)       VALUE SPACES.      
REARCH      05 S-RATE-DESC            PIC X(25)      VALUE SPACES.      
REARCH      05 S-UM-EQUIP-SHRT-DESC   PIC X(36)      VALUE SPACES.      
REARCH      05 S-NO-UNITS             PIC S999999999V COMP-3            
REARCH                                               VALUE ZEROES.      
REARCH      05 S-LIGHT-POLE-NO        PIC X(7)       VALUE SPACES.      
REARCH      05 S-NO-DAYS              PIC S9(4) COMP VALUE ZEROES.      
REARCH      05 S-USAGE-FIXED          PIC S999999999V COMP-3            
REARCH                                               VALUE ZEROES.      
REARCH      05 S-INSTALL-DATE         PIC X(10)      VALUE SPACES.      
REARCH      05 S-REMOVE-DATE          PIC X(10)      VALUE SPACES.      
REARCH      05 S-CODE-PLAN-STATUS     PIC X(1)       VALUE SPACE.       
REARCH                                                                  
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*     05 CNS-DATE-ORIG-BILL     PIC X(09) VALUE 'BILL_DATE'.              
CVT999*     05 CNS-IC-NO              PIC X(05) VALUE 'IC_NO'.                  
CVT999*     05 CNS-RATE-PLAN-NO       PIC X(12) VALUE 'RATE_PLAN_NO'.           
CVT999*     05 CNS-RATE-DESC          PIC X(09) VALUE 'RATE_DESC'.              
CVT999*     05 CNS-UM-EQUIP-SHRT-DESC PIC X(14) VALUE 'RATE_ITEM_DESC'.         
CVT999*     05 CNS-USAGE-FIXED        PIC X(05) VALUE 'USAGE'.                  
CVT999*     05 CNS-LIGHT-POLE-NO      PIC X(13) VALUE 'LIGHT_POLE_NO'.          
CVT999*     05 CNS-NO-DAYS            PIC X(04) VALUE 'DAYS'.                   
CVT999*     05 CNS-NO-UNITS           PIC X(08) VALUE 'NO_UNITS'.               
CVT999*     05 CNS-INSTALL-DATE       PIC X(12) VALUE 'INSTALL_DATE'.           
CVT999*     05 CNS-REMOVE-DATE        PIC X(11) VALUE 'REMOVE_DATE'.            
CVT999*     05 CNS-CODE-PLAN-STATUS   PIC X(06) VALUE 'STATUS'.                 
CVT999******************************************************************        
CVT999*    CURSOR DECLARATIONS                                         *        
CVT999******************************************************************        
CVT999*                                                                         
CVT999******************************************************************        
CVT999**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
CVT999**  ROWS FROM THE CSS_BILLING_DET TABLE WHERE THE PREMISE       **        
CVT999**  NUMBER AND BILL NUMBER ARE EQUAL TO THE PREMISE NUMBER AND  **        
CVT999**  BILL NUMBER ON THE CURRENT CSS_BILLING_HDR ROW.             **        
CVT999******************************************************************        
           EXEC SQL                                                     
             DECLARE BG-CURSOR CURSOR FOR                               
             SELECT DATE_ORIG_BILL,                                     
                    RATE_PLAN_NO                                        
                   FROM CSS_BILLING_DET                                 
                   WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO           
                   AND    BILL_NO            = :BG-BILL-NO              
                   AND    CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
                   AND    IC_NO              = :BG-IC-NO                
                   AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG-CURSOR CURSOR FOR                                       
MFA-TR*      SELECT DATE_ORIG_BILL,                                             
MFA-TR*             RATE_PLAN_NO                                                
MFA-TR*            FROM CSS_BILLING_DET                                         
MFA-TR*            WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*            AND    BILL_NO            = :BG-BILL-NO                      
MFA-TR*            AND    CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
MFA-TR*            AND    IC_NO              = :BG-IC-NO                        
MFA-TR*            AND    BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_UM_CNSMPT_HIST TABLE.                     **        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE UC-CURSOR CURSOR FOR                               
             SELECT ITEM_SEQ_NO,                                        
                    RATE_ITEM_CODE,                                     
                    NO_UNITS,                                           
                    LIGHT_NO,                                           
                    POLE_NO,                                            
                    NO_DAYS,                                            
                    USAGE_FIXED,                                        
                    DATE_USAGE_ENDS,                                    
                    DATEADD( DAY, -NO_DAYS, DATE_USAGE_ENDS )                   
                   FROM CSS_UM_CNSMPT_HIST                              
                   WHERE  ACCOUNT_NO         = :UC-ACCOUNT-NO           
                   AND    BILL_NO            = :UC-BILL-NO              
                   AND    CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE       
                   AND    IC_NO              = :UC-IC-NO                
                   AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )   
                   ORDER BY ITEM_SEQ_NO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UC-CURSOR CURSOR FOR                                       
MFA-TR*      SELECT ITEM_SEQ_NO,                                                
MFA-TR*             RATE_ITEM_CODE,                                             
MFA-TR*             NO_UNITS,                                                   
MFA-TR*             LIGHT_NO,                                                   
MFA-TR*             POLE_NO,                                                    
MFA-TR*             NO_DAYS,                                                    
MFA-TR*             USAGE_FIXED,                                                
MFA-TR*             DATE_USAGE_ENDS,                                            
MFA-TR*             DATE_USAGE_ENDS - NO_DAYS DAYS                              
MFA-TR*            FROM CSS_UM_CNSMPT_HIST                                      
MFA-TR*            WHERE  ACCOUNT_NO         = :UC-ACCOUNT-NO                   
MFA-TR*            AND    BILL_NO            = :UC-BILL-NO                      
MFA-TR*            AND    CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE               
MFA-TR*            AND    IC_NO              = :UC-IC-NO                        
MFA-TR*            AND    BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP           
MFA-TR*            ORDER BY ITEM_SEQ_NO                                         
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(DATE_ORIG_BILL))       AS BILL_DATE             
REARCH            ,IC_NO                                                
REARCH            ,LTRIM(RTRIM(RATE_PLAN_NO))         AS RATE_PLAN_NO          
REARCH            ,LTRIM(RTRIM(RATE_DESC))            AS RATE_DESC             
REARCH            ,LTRIM(RTRIM(UM_EQUIP_SHRT_DESC))   AS RATE_ITEM_DESC        
REARCH            ,NO_UNITS                                             
REARCH            ,LTRIM(RTRIM(LIGHT_POLE_NO))        AS LIGHT_POLE_NO         
REARCH            ,NO_DAYS                     AS DAYS                  
REARCH            ,USAGE_FIXED                 AS USAGE                 
REARCH            ,LTRIM(RTRIM(INSTALL_DATE))         AS INSTALL_DATE          
REARCH            ,LTRIM(RTRIM(REMOVE_DATE))          AS REMOVE_DATE           
REARCH            ,CODE_PLAN_STATUS            AS STATUS                
CVT000         FROM #CSR02102_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                          00000400
MFA-TR*           ,STRIP(DATE_ORIG_BILL)       AS BILL_DATE             00000400
MFA-TR*           ,IC_NO                                                00000400
MFA-TR*           ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO          00000400
MFA-TR*           ,STRIP(RATE_DESC)            AS RATE_DESC             00000400
MFA-TR*           ,STRIP(UM_EQUIP_SHRT_DESC)   AS RATE_ITEM_DESC        00000400
MFA-TR*           ,NO_UNITS                                             00000400
MFA-TR*           ,STRIP(LIGHT_POLE_NO)        AS LIGHT_POLE_NO         00000400
MFA-TR*           ,NO_DAYS                     AS DAYS                  00000400
MFA-TR*           ,USAGE_FIXED                 AS USAGE                 00000400
MFA-TR*           ,STRIP(INSTALL_DATE)         AS INSTALL_DATE          00000400
MFA-TR*           ,STRIP(REMOVE_DATE)          AS REMOVE_DATE           00000400
MFA-TR*           ,CODE_PLAN_STATUS            AS STATUS                00000400
MFA-TR*        FROM SESSION.CSR02102_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-BILL-NO             PIC S9(9) COMP           .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-IC-NO               PIC S9(4) COMP           .          
CVT000 01  LINK-BILL-ITEM-TIMESTMP  PIC X(26)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-BILL-NO                                            
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-BILL-ITEM-TIMESTMP                                 
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-BILL-NO              TO PARM-BILL-NO             . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP  . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02102_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02102_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,DATE_ORIG_BILL CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,IC_NO                    SMALLINT                        
CVT000        ,RATE_PLAN_NO CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,RATE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,UM_EQUIP_SHRT_DESC CHAR(36)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,NO_UNITS                 DECIMAL(09,0)                   
CVT000        ,LIGHT_POLE_NO CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,NO_DAYS                  SMALLINT                        
CVT000        ,USAGE_FIXED              DECIMAL(09,0)                   
CVT000        ,INSTALL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,REMOVE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CODE_PLAN_STATUS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
REARCH            MOVE 'CSR02102_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-NUM     TO BG-ACCOUNT-NO.                 
           MOVE PARM-BILL-NO          TO BG-BILL-NO.                    
           MOVE PARM-CODE-UTIL-TYPE   TO BG-CODE-UTIL-TYPE.             
           MOVE PARM-IC-NO            TO BG-IC-NO.                      
           MOVE PARM-BILL-ITEM-TIMESTMP TO BG-BILL-ITEM-TIMESTMP.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                               TO PARM-ID1.                    
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO       TO MAX-LENGTH-PARM.             
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-BILL-NO           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-BILL-NO,                                  
CVT999*                          TDSINT4,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-IC-NO             TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-IC-NO,                                    
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-BILL-ITEM-TIMESTMP TO MAX-LENGTH-PARM.           
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-BILL-ITEM-TIMESTMP,                       
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-DATE-ORIG-BILL      TO S-DATE-ORIG-BILL.             
REARCH     MOVE RS-IC-NO               TO S-IC-NO.                      
REARCH     MOVE RS-RATE-PLAN-NO        TO S-RATE-PLAN-NO.               
REARCH     MOVE RS-RATE-DESC           TO S-RATE-DESC.                  
REARCH     MOVE RS-UM-EQUIP-SHRT-DESC  TO S-UM-EQUIP-SHRT-DESC.         
REARCH     MOVE RS-NO-UNITS            TO S-NO-UNITS.                   
REARCH     MOVE RS-LIGHT-POLE-NO       TO S-LIGHT-POLE-NO.              
REARCH     MOVE RS-NO-DAYS             TO S-NO-DAYS.                    
REARCH     MOVE RS-USAGE-FIXED         TO S-USAGE-FIXED.                
REARCH     MOVE RS-INSTALL-DATE        TO S-INSTALL-DATE.               
REARCH     MOVE RS-REMOVE-DATE         TO S-REMOVE-DATE.                
REARCH     MOVE RS-CODE-PLAN-STATUS    TO S-CODE-PLAN-STATUS.           
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-BG-UC-DATA                                *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2110'                             TO ACTIVE-PARAGRAPH. 
           PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.      
           PERFORM 2140-DESC-BG-UC-DATA            THRU 2140-EXIT.      
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
       2110-DESC-RET-CODE.                                              
                                                                        
           MOVE '2110'                       TO ACTIVE-PARAGRAPH.       
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2140-DESC-BI-BG-DATA                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE BILLING HEADER RESULT FIELDS TO THE CLIENT      *          
      *                                                                *        
      ******************************************************************        
                                                                        
       2140-DESC-BG-UC-DATA.                                            
           MOVE '2140'                          TO ACTIVE-PARAGRAPH.    
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-DATE-ORIG-BILL     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-DATE-ORIG-BILL    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DATE-ORIG-BILL,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DATE-ORIG-BILL,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSINT2                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-IC-NO              TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-IC-NO             TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-IC-NO,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-IC-NO,                                     
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-RATE-PLAN-NO       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-RATE-PLAN-NO      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-PLAN-NO,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RATE-PLAN-NO,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-RATE-DESC          TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-RATE-DESC         TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-DESC,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RATE-DESC,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-UM-EQUIP-SHRT-DESC TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-UM-EQUIP-SHRT-DESC TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-UM-EQUIP-SHRT-DESC,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-UM-EQUIP-SHRT-DESC,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDS-PACKED-DECIMAL           TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSFLT8                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-NO-UNITS        TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-NO-UNITS       TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NO-UNITS,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NO-UNITS,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-LIGHT-POLE-NO      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-LIGHT-POLE-NO     TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LIGHT-POLE-NO,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LIGHT-POLE-NO,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSINT2                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-NO-DAYS            TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-NO-DAYS           TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NO-DAYS,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NO-DAYS,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDS-PACKED-DECIMAL              TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-USAGE-FIXED        TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-USAGE-FIXED       TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-USAGE-FIXED,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-USAGE-FIXED,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-INSTALL-DATE       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-INSTALL-DATE      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-INSTALL-DATE,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-INSTALL-DATE,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-REMOVE-DATE        TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-REMOVE-DATE       TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-REMOVE-DATE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-REMOVE-DATE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CODE-PLAN-STATUS   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CODE-PLAN-STATUS  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-PLAN-STATUS,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-PLAN-STATUS,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
           MOVE PARM-ACCOUNT-NO   TO WS-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO BG-ACCOUNT-NO.                     
           MOVE PARM-BILL-NO      TO BG-BILL-NO.                        
           MOVE PARM-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE.               
           MOVE PARM-IC-NO        TO BG-IC-NO.                          
           MOVE PARM-BILL-ITEM-TIMESTMP TO BG-BILL-ITEM-TIMESTMP.       
                                                                        
           PERFORM 2205-BUILD-BG-UC THRU 2205-EXIT.                     
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2205-BUILD-BG-UC.                                                
           PERFORM 7100-OPEN-BG-CURSOR  THRU  7100-EXIT.                
           PERFORM 7110-FETCH-BG-ROW    THRU  7110-EXIT.                
                                                                        
           PERFORM 2210-PROCESS-BG-CURSOR   THRU 2210-EXIT              
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           IF NOT PROCESS-1ST-BG-ROW                                    
              MOVE SPACES   TO  RS-DATE-ORIG-BILL                       
              MOVE ZEROES   TO  RS-IC-NO                                
              MOVE SPACES   TO  RS-RATE-PLAN-NO                         
              MOVE SPACES   TO  RS-RATE-DESC                            
              MOVE SPACES   TO  RS-UM-EQUIP-SHRT-DESC                   
              MOVE ZEROES   TO  RS-NO-UNITS                             
              MOVE SPACES   TO  RS-LIGHT-POLE-NO                        
              MOVE ZEROES   TO  RS-NO-DAYS                              
              MOVE ZEROES   TO  RS-USAGE-FIXED                          
              MOVE SPACES   TO  RS-INSTALL-DATE                         
              MOVE SPACES   TO  RS-REMOVE-DATE                          
              MOVE SPACES   TO  RS-CODE-PLAN-STATUS                     
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF                                                       
           PERFORM 7120-CLOSE-BG-CURSOR THRU 7120-EXIT.                 
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08721000
      *   THIS PARAGRAPH FETCHES THE CSS_BILLING_DET CURSOR.                    
      *      DECLARE BG-CURSOR CURSOR FOR                                       
      *      SELECT DATE_ORIG_BILL,                                             
      *             RATE_PLAN_NO                                                
      *            FROM CSS_BILLING_DET                                         
      *            WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                   
      *            AND    BILL_NO            = :BG-BILL-NO                      
      *            AND    CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
      *            AND    IC_NO              = :BG-IC-NO                        
      *            AND    BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
      ******************************************************************        
                                                                        
       2210-PROCESS-BG-CURSOR.                                          
           MOVE 'Y' TO PROCESS-1ST-BG-ROW-SW.                           
                                                                        
      ** TO DISPLAY 'BILL DATE'.                                                
           IF WS-BG-DT-BILL-NULL-IND = -1                               
              MOVE SPACES               TO RS-DATE-ORIG-BILL            
           ELSE                                                         
              MOVE BG-DATE-ORIG-BILL    TO WS-DB2-DATE                  
              PERFORM 2230-FORMAT-RS-DATE THRU 2230-EXIT                
              MOVE WS-RS-FORMATED-DATE  TO RS-DATE-ORIG-BILL            
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'IC NO'.                                                    
           MOVE BG-IC-NO             TO RS-IC-NO.                       
      ** TO DISPLAY 'RATE PLAN NO'  AND 'RATE PLAN DESCRIPTION'.                
           IF  BG-RATE-PLAN-NO NOT EQUAL SPACES                         
               MOVE BG-RATE-PLAN-NO   TO RS-RATE-PLAN-NO                
               MOVE BG-RATE-PLAN-NO   TO RD-RATE-PLAN-NO                
               MOVE BG-CODE-UTIL-TYPE TO RD-CODE-UTIL-TYPE              
               PERFORM 7800-SELECT-RATE-DESC THRU 7800-EXIT             
      ***************************************************************           
      *                7800-SELECT-RATE-DESC.                                   
      *                SELECT RATE_DESC                                         
      *                    INTO :RD-RATE-DESC                                   
      *                    FROM CSS_RATE_PLAN_DESC                              
      *                    WHERE RATE_PLAN_NO      = :RD-RATE-PLAN-NO           
      *                    AND   CODE_UTIL_TYPE    = :RD-CODE-UTIL-TYPE         
      ***************************************************************           
               IF WS-SELECT-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE RD-RATE-DESC TO RS-RATE-DESC                     
               ELSE                                                     
                  MOVE SPACES       TO RS-RATE-DESC                     
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES  TO RS-RATE-PLAN-NO                          
               MOVE SPACES  TO RS-RATE-DESC                             
           END-IF.                                                      
                                                                        
           MOVE BG-ACCOUNT-NO         TO UC-ACCOUNT-NO.                 
           MOVE BG-BILL-NO            TO UC-BILL-NO.                    
           MOVE BG-CODE-UTIL-TYPE     TO UC-CODE-UTIL-TYPE.             
           MOVE BG-IC-NO              TO UC-IC-NO.                      
           MOVE BG-BILL-ITEM-TIMESTMP TO UC-BILL-ITEM-TIMESTMP.         
                                                                        
           PERFORM 7400-OPEN-UC-CURSOR  THRU  7400-EXIT.                
           PERFORM 7410-FETCH-UC-ROW    THRU  7410-EXIT.                
                                                                        
           PERFORM 2215-PROCESS-UC-CURSOR THRU 2215-EXIT                
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           IF NOT PROCESS-1ST-UC-ROW                                    
              MOVE SPACES   TO  RS-DATE-ORIG-BILL                       
              MOVE ZEROES   TO  RS-IC-NO                                
              MOVE SPACES   TO  RS-RATE-PLAN-NO                         
              MOVE SPACES   TO  RS-RATE-DESC                            
              MOVE SPACES   TO  RS-UM-EQUIP-SHRT-DESC                   
              MOVE ZEROES   TO  RS-NO-UNITS                             
              MOVE SPACES   TO  RS-LIGHT-POLE-NO                        
              MOVE ZEROES   TO  RS-NO-DAYS                              
              MOVE ZEROES   TO  RS-USAGE-FIXED                          
              MOVE SPACES   TO  RS-INSTALL-DATE                         
              MOVE SPACES   TO  RS-REMOVE-DATE                          
              MOVE SPACES   TO  RS-CODE-PLAN-STATUS                     
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-UC-CURSOR THRU 7420-EXIT.                 
           PERFORM 7110-FETCH-BG-ROW    THRU  7110-EXIT.                
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2215-PROCESS-UC-CURSOR.                                          
      ****************************************************************          
      * THIS PARAGRAPH FETCHES A UC CURSOR FROM THE TABLE                       
      * CSS_UM_CNSMPT_HIST.                                                     
      *      DECLARE UC-CURSOR CURSOR FOR                                       
      *      SELECT ITEM_SEQ_NO,                                                
      *             RATE_ITEM_CODE,                                             
      *             NO_UNITS,                                                   
      *             LIGHT_NO,                                                   
      *             POLE_NO,                                                    
      *             NO_DAYS,                                                    
      *             USAGE_FIXED,                                                
      *             DATE_USAGE_ENDS,                                            
      ***           CHAR(DATE_USAGE_ENDS,USA),                                  
      *             DATE_USAGE_ENDS - NO_DAYS DAYS                              
      *            FROM CSS_UM_CNSMPT_HIST                                      
      *            WHERE  ACCOUNT_NO         = :UC-ACCOUNT-NO                   
      *            AND    BILL_NO            = :UC-BILL-NO                      
      *            AND    CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE               
      *            AND    IC_NO              = :UC-IC-NO                        
      *            AND    BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP           
      *            ORDER  BY ITEM_SEQ_NO                                        
      ****************************************************************          
           MOVE 'Y' TO PROCESS-1ST-UC-ROW-SW.                           
                                                                        
           MOVE UC-ACCOUNT-NO         TO CP-ACCOUNT-NO.                 
           MOVE UC-CODE-UTIL-TYPE     TO CP-CODE-UTIL-TYPE              
           MOVE UC-IC-NO              TO CP-IC-NO.                      
           MOVE UC-ITEM-SEQ-NO        TO CP-ITEM-SEQ-NO.                
           MOVE UC-RATE-ITEM-CODE     TO CP-RATE-ITEM-CODE              
                                                                        
      ** FETCH FIELDS FROM CSS_CUST_PLAN WHICH WILL BE REQUIRED DOWN            
      ** THE LINE IN THIS PARAGRAPH.                                            
           PERFORM 7900-SELECT-CP-USAGE THRU 7900-EXIT                  
      ***************************************************************           
      *       7900-SELECT-CP-USAGE.                                             
      *       SELECT REMOVE_DATE , CODE_PLAN_STATUS                             
      *            INTO :CP-REMOVE-DATE:WS-CP-REMOVE-DT-NULL-IND,               
      *                 :CP-CODE-PLAN-STATUS                                    
      *            FROM CSS_CUST_PLAN                                           
      *            WHERE  ACCOUNT_NO      = :CP-ACCOUNT-NO     AND              
      *                   CODE_UTIL_TYPE  = :CP-CODE-UTIL-TYPE AND              
      *                   IC_NO           = :CP-IC-NO          AND              
      *                   ITEM_SEQ_NO     = :CP-ITEM-SEQ-NO    AND              
      *                   RATE_ITEM_CODE  = :CP-RATE-ITEM-CODE                  
      ***************************************************************           
           IF WS-SELECT-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-CP-REMOVE-DT-NULL-IND = -1                          
                 MOVE SPACES          TO RS-REMOVE-DATE                 
              ELSE                                                      
                 MOVE CP-REMOVE-DATE  TO WS-CP-REMOVE-DATE              
              END-IF                                                    
              MOVE CP-CODE-PLAN-STATUS TO WS-CP-CODE-PLAN-STATUS        
           ELSE                                                         
              MOVE SPACES     TO RS-REMOVE-DATE                         
              MOVE SPACES     TO WS-CP-CODE-PLAN-STATUS                 
           END-IF.                                                      
      ** TO DISPLAY 'RATE-ITEM DESCRIPTION'.                                    
           IF UC-CODE-UTIL-TYPE = ('E' OR 'G')                          
              MOVE 'SPECIAL UNMTR PROVISION FOR MTR RATE'               
                                       TO RS-UM-EQUIP-SHRT-DESC         
           ELSE                                                         
              MOVE UC-CODE-UTIL-TYPE   TO UP-CODE-UTIL-TYPE             
T15116                                    RT-CODE-UTIL-TYPE             
              MOVE UC-RATE-ITEM-CODE   TO UP-RATE-ITEM-CODE             
              MOVE BG-RATE-PLAN-NO     TO UP-RATE-PLAN-NO               
T15116                                    RT-RATE-PLAN-NO               
T15116        MOVE WS-ACTIVE           TO RT-CODE-STATUS                
                                                                        
T15116        PERFORM 7820-SELECT-MAX-VERSION THRU 7820-EXIT            
T15116        MOVE RT-VERSION-NO-CNTRL TO UP-VERSION-NO-CNTRL           
T15116                                                                  
              PERFORM 7840-SELECT-EQUIP-ID THRU 7840-EXIT               
      ****************************************************************          
      *      7840-SELECT-EQUIP-ID.                                              
      *      SELECT B.UM_EQUIP_SHRT_DESC , B.UM-EQUIP-KWH                       
      *            INTO :L9-UM-EQUIP-SHRT-DESC,:L9-UM-EQUIP-KWH                 
      *            FROM CSS_UNMTR_PLAN A , CSS_UM_EQUIPMENT B                   
      *            WHERE  A.UM_EQUIP_ID     = B.UM_EQUIP_ID AND                 
      *                   A.CODE_UTIL_TYPE  = :UP-CODE-UTIL-TYPE AND            
      *                   A.RATE_ITEM_CODE  = :UP-RATE-ITEM-CODE AND            
      *                   A.RATE_PLAN_NO    = :UP-RATE-PLAN-NO   AND            
      *                   A.VERSION_NO_CNTRL = 1                                
      *****************************************************************         
              IF WS-SELECT-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE L9-UM-EQUIP-SHRT-DESC TO RS-UM-EQUIP-SHRT-DESC    
                 MOVE L9-UM-EQUIP-KWH       TO WS-L9-UM-EQUIP-KWH       
              ELSE                                                      
                 MOVE SPACES      TO RS-UM-EQUIP-SHRT-DESC              
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'NO UNITS'.                                                 
           IF WS-UC-NO-UNITS-NULL-IND NOT EQUAL TO -1                   
              MOVE UC-NO-UNITS       TO RS-NO-UNITS                     
           ELSE                                                         
              MOVE ZEROES            TO RS-NO-UNITS                     
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'LIGHT NO / POLE NO'.                                       
           IF UC-NO-UNITS > 1                                           
              MOVE SPACES   TO RS-LIGHT-POLE-NO                         
           ELSE                                                         
              IF UC-LIGHT-NO IS GREATER THAN ZERO                       
                 MOVE UC-LIGHT-NO    TO WS-LIGHT-NO                     
                 MOVE WS-RS-LIGHT-NO TO RS-LIGHT-POLE-NO                
              ELSE                                                      
                 MOVE UC-POLE-NO     TO RS-LIGHT-POLE-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'DAYS'                                                      
           IF WS-UC-NO-DAYS-NULL-IND NOT EQUAL TO -1                    
              MOVE UC-NO-DAYS TO  RS-NO-DAYS                            
           ELSE                                                         
              MOVE ZEROES     TO  RS-NO-DAYS                            
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'USAGE'.                                                    
           IF UC-CODE-UTIL-TYPE = ('E' OR 'G')                          
              IF (WS-UC-USAGE-FIXED-NULL-IND NOT = -1)                  
                 MOVE UC-USAGE-FIXED  TO RS-USAGE-FIXED                 
              ELSE                                                      
                 MOVE ZEROES          TO RS-USAGE-FIXED                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-L9-UM-EQUIP-KWH TO RS-USAGE-FIXED                 
           END-IF.                                                      
                                                                        
TP5406        PERFORM 7920-SELECT-CP-DATE-START THRU 7920-EXIT          
      ****************************************************************          
      *       7920-SELECT-CP-DATE-START.                                        
      *         SELECT DATE_PLAN_START                                          
      *            INTO :CP-DATE-PLAN-START:WS-CP-DT-START-NULL-IND             
      *            FROM CSS_CUST_PLAN                                           
      *            WHERE DATE_PLAN_START = :WS-DATE-DIFFERENCE AND              
      *                  ACCOUNT_NO      = :CP-ACCOUNT-NO      AND              
      *                  CODE_UTIL_TYPE  = :CP-CODE-UTIL-TYPE  AND              
      *                  IC_NO           = :CP-IC-NO           AND              
      *                  ITEM_SEQ_NO     = :CP-ITEM-SEQ-NO     AND              
      *                  RATE_ITEM_CODE  = :CP-RATE-ITEM-CODE                   
      ****************************************************************          
              IF WS-SELECT-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-CP-DT-START-NULL-IND = -1                        
                    MOVE SPACES TO RS-INSTALL-DATE                      
                 ELSE                                                   
                    MOVE CP-DATE-PLAN-START  TO WS-DB2-DATE             
                    PERFORM 2230-FORMAT-RS-DATE THRU 2230-EXIT          
                    MOVE WS-RS-FORMATED-DATE TO RS-INSTALL-DATE
                 END-IF         
              ELSE                                                      
                 MOVE SPACES             TO RS-INSTALL-DATE             
              END-IF.                                                   
                                                                        
      ** TO DISPLAY 'REMOVE DATE'.                                              
           IF WS-CP-REMOVE-DATE > SPACE                                 
              MOVE WS-CP-REMOVE-DATE   TO WS-DB2-DATE                   
              PERFORM 2230-FORMAT-RS-DATE THRU 2230-EXIT                
              MOVE WS-RS-FORMATED-DATE TO RS-REMOVE-DATE                
           ELSE                                                         
              MOVE SPACES            TO RS-REMOVE-DATE                  
           END-IF.                                                      
                                                                        
      ** TO DISPLAY 'STATUS'                                                    
           MOVE WS-CP-CODE-PLAN-STATUS TO RS-CODE-PLAN-STATUS.          
      **                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
           PERFORM 7410-FETCH-UC-ROW    THRU  7410-EXIT.                
       2215-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2230-FORMAT-RS-DATE.                                             
      *****************************************************************         
      ** THIS PARAGRAPH CHANGES THE DATE-ORIG-BILL TO THE FORMAT     **         
      ** MM/DD/YYYY THAT WILL DISPLAYED IN THE FRONTEND.**                      
      *****************************************************************         
           MOVE WS-DB2-YYYY TO WS-RS-YYYY.                              
           MOVE WS-DB2-MM   TO WS-RS-MM.                                
           MOVE WS-DB2-DD   TO WS-RS-DD.                                
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-BG-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7100'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN'              TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_BILLING_DET  ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
CBSI          MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE BG-BILL-NO          TO HOSTVAR-ELEMENT-2             
CBSI          MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
CBSI          MOVE BG-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       7110-FETCH-BG-ROW.                                               
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_DET TABLE WHERE THE PREMISE NUMBER IS EQUAL TO  **        
      **  THE PREMISE NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA PREMISE NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
               INTO :BG-DATE-ORIG-BILL :WS-BG-DT-BILL-NULL-IND,          
                    :BG-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7110'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'FETCH  '           TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_BILLING_DET  ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
CBSI          MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE BG-BILL-NO          TO HOSTVAR-ELEMENT-2             
CBSI          MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
CBSI          MOVE BG-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7110-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7120-CLOSE-BG-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7120'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CLOSE '                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
CBSI          MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
CBSI          MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7120-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       7400-OPEN-UC-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_CNSMPTN_HIST  TABLE.                                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN UC-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7400'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN  '            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
CBSI          MOVE 'CSS_UM_CNSMPT_HIST' TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1               
CBSI          MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE UC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE UC-BILL-NO          TO HOSTVAR-ELEMENT-2             
CBSI          MOVE UC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
CBSI          MOVE UC-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-FETCH-UC-ROW.                                               
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_CNSMPTN_HIST  TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH UC-CURSOR                                          
                 INTO :UC-ITEM-SEQ-NO,                                  
                      :UC-RATE-ITEM-CODE,                               
                      :UC-NO-UNITS :WS-UC-NO-UNITS-NULL-IND,             
                      :UC-LIGHT-NO,                                     
                      :UC-POLE-NO,                                      
                      :UC-NO-DAYS :WS-UC-NO-DAYS-NULL-IND,               
                      :UC-USAGE-FIXED :WS-UC-USAGE-FIXED-NULL-IND,       
                      :UC-DATE-USAGE-ENDS :WS-UC-DT-ENDS-NULL-IND,       
                      :WS-DATE-DIFFERENCE :WS-UC-DIFF-NULL-IND           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7410'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'FETCH '            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
CBSI          MOVE 'CSS_UM_CNSMPT_HIST' TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1               
CBSI          MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE UC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE UC-BILL-NO          TO HOSTVAR-ELEMENT-2             
CBSI          MOVE UC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
CBSI          MOVE UC-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7410-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7420-CLOSE-UC-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE UC-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7420'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'CLOSE'             TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
CBSI          MOVE 'CSS_UM_CNSMPT_HIST' TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1               
CBSI          MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-4               
              MOVE UC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE UC-BILL-NO          TO HOSTVAR-ELEMENT-2             
CBSI          MOVE UC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
CBSI          MOVE UC-IC-NO            TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7420-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       7800-SELECT-RATE-DESC.                                           
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE  **        
      **  CSS_RATE_DESC   TABLE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             SELECT RATE_DESC                                           
                   INTO :RD-RATE-DESC                                   
                   FROM CSS_RATE_PLAN_DESC                              
                   WHERE  RATE_PLAN_NO      = :RD-RATE-PLAN-NO          
                   AND    CODE_UTIL_TYPE    = :RD-CODE-UTIL-TYPE        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-SELECT-RETURN-CODE.        
      *                                                                         
           IF WS-SELECT-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7800'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
CBSI          MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                      
CBSI          MOVE 'RATE_PLAN_NO  '    TO TABLE-ELEMENT-1               
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-3               
              MOVE RD-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1             
CBSI          MOVE RD-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-3             
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            10240000
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7800-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
T15116*                                                                         
T15116 7820-SELECT-MAX-VERSION.                                         
T15116     MOVE '7820' TO ACTIVE-PARAGRAPH.                             
T15116*                                                                         
T15116     EXEC SQL                                                     
T15116        SELECT MAX(VERSION_NO_CNTRL)                              
T15116          INTO :RT-VERSION-NO-CNTRL                               
T15116          FROM CSS_RATE_CREATOR                                   
T15116         WHERE CODE_UTIL_TYPE    = :RT-CODE-UTIL-TYPE             
T15116           AND RATE_PLAN_NO      = :RT-RATE-PLAN-NO               
T15116           AND CODE_STATUS       = :RT-CODE-STATUS                
T15116     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15116*                                                                         
T15116     MOVE SQLCODE TO WS-SELECT-RETURN-CODE.                       
T15116*                                                                         
T15116     IF WS-SELECT-RETURN-CODE = SUCCESSFUL-CALL                   
T15116        NEXT SENTENCE                                             
T15116     ELSE                                                         
T15116        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T15116        MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
T15116        MOVE 'CSS_RATE_CREATOR'   TO TABLE-1                      
T15116        MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1              
T15116        MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2              
T15116        MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
T15116        MOVE RT-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1            
T15116        MOVE RT-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2            
T15116        MOVE RT-CODE-STATUS       TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
T15116        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T15116        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T15116     END-IF.                                                      
T15116*                                                                         
T15116 7820-EXIT.                                                       
T15116     EXIT.                                                        
T15116                                                                  
HPCCDM*EJECT                                                                    
       7840-SELECT-EQUIP-ID.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE  **        
      **  CSS_UM_EQUIPMENT                                            **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             SELECT B.UM_EQUIP_SHRT_DESC , B.UM_EQUIP_KWH               
                   INTO :L9-UM-EQUIP-SHRT-DESC, :L9-UM-EQUIP-KWH        
                   FROM CSS_UNMTR_PLAN A , CSS_UM_EQUIPMENT B           
                   WHERE  A.UM_EQUIP_ID      = B.UM_EQUIP_ID      AND   
                          A.CODE_UTIL_TYPE   = :UP-CODE-UTIL-TYPE AND   
                          A.RATE_ITEM_CODE   = :UP-RATE-ITEM-CODE AND   
                          A.RATE_PLAN_NO     = :UP-RATE-PLAN-NO   AND   
T15116                    A.VERSION_NO_CNTRL = :UP-VERSION-NO-CNTRL     
T15116*                   A.VERSION_NO_CNTRL = 1                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-SELECT-RETURN-CODE.        
      *                                                                         
           IF WS-SELECT-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7840'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_UNMTR_PLAN   ' TO TABLE-1                       
CBSI          MOVE 'CSS_UM_EQUIPMENT'  TO TABLE-2                       
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1               
CBSI          MOVE 'RATE_ITEM_CODE'    TO TABLE-ELEMENT-2               
CBSI          MOVE 'RATE_PLAN_NO  '    TO TABLE-ELEMENT-3               
CBSI          MOVE 'VERSION_NO_CNTRL'  TO TABLE-ELEMENT-4               
CBSI          MOVE UP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1             
CBSI          MOVE UP-RATE-ITEM-CODE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE UP-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-3             
CBSI          MOVE UP-VERSION-NO-CNTRL TO HOSTVAR-ELEMENT-4             
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            10240000
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7840-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       7900-SELECT-CP-USAGE.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE  **        
      **  CSS_CUST_PLAN                                               **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             SELECT REMOVE_DATE , CODE_PLAN_STATUS                      
                   INTO :CP-REMOVE-DATE :WS-CP-REMOVE-DT-NULL-IND,       
                        :CP-CODE-PLAN-STATUS                            
                   FROM CSS_CUST_PLAN                                   
                   WHERE  ACCOUNT_NO      = :CP-ACCOUNT-NO     AND      
                          CODE_UTIL_TYPE  = :CP-CODE-UTIL-TYPE AND      
                          IC_NO           = :CP-IC-NO          AND      
                          ITEM_SEQ_NO     = :CP-ITEM-SEQ-NO    AND      
                          RATE_ITEM_CODE  = :CP-RATE-ITEM-CODE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-SELECT-RETURN-CODE         
      *                                                                         
           IF WS-SELECT-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7900'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_CUST_PLAN    ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
CBSI          MOVE 'IC_NO   '          TO TABLE-ELEMENT-2               
CBSI          MOVE 'ITEM_SEQ_NO'       TO TABLE-ELEMENT-3               
CBSI          MOVE 'RATE_ITEM_CODE'    TO TABLE-ELEMENT-4               
              MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE CP-IC-NO            TO HOSTVAR-ELEMENT-2             
CBSI          MOVE CP-ITEM-SEQ-NO      TO HOSTVAR-ELEMENT-3             
CBSI          MOVE CP-RATE-ITEM-CODE   TO HOSTVAR-ELEMENT-4             
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            10240000
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7920-SELECT-CP-DATE-START.                                       
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE  **        
      **  CSS_CUST_PLAN                                               **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_PLAN_START                                     
                   INTO :CP-DATE-PLAN-START :WS-CP-DT-START-NULL-IND     
                   FROM CSS_CUST_PLAN                                   
                   WHERE ACCOUNT_NO      = :CP-ACCOUNT-NO      AND      
                         CODE_UTIL_TYPE  = :CP-CODE-UTIL-TYPE  AND      
                         IC_NO           = :CP-IC-NO           AND      
                         ITEM_SEQ_NO     = :CP-ITEM-SEQ-NO     AND      
                         RATE_ITEM_CODE  = :CP-RATE-ITEM-CODE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-SELECT-RETURN-CODE.        
      *                                                                         
           IF WS-SELECT-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7920'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_CUST_PLAN    ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
CBSI          MOVE 'IC_NO   '          TO TABLE-ELEMENT-2               
CBSI          MOVE 'ITEM_SEQ_NO'       TO TABLE-ELEMENT-3               
CBSI          MOVE 'RATE_ITEM_CODE'    TO TABLE-ELEMENT-4               
              MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE CP-IC-NO            TO HOSTVAR-ELEMENT-2             
CBSI          MOVE CP-ITEM-SEQ-NO      TO HOSTVAR-ELEMENT-3             
CBSI          MOVE CP-RATE-ITEM-CODE   TO HOSTVAR-ELEMENT-4             
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            10240000
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02102_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,DATE_ORIG_BILL                                            
CVT000       ,IC_NO                                                     
CVT000       ,RATE_PLAN_NO                                              
CVT000       ,RATE_DESC                                                 
CVT000       ,UM_EQUIP_SHRT_DESC                                        
CVT000       ,NO_UNITS                                                  
CVT000       ,LIGHT_POLE_NO                                             
CVT000       ,NO_DAYS                                                   
CVT000       ,USAGE_FIXED                                               
CVT000       ,INSTALL_DATE                                              
CVT000       ,REMOVE_DATE                                               
CVT000       ,CODE_PLAN_STATUS                                          
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-DATE-ORIG-BILL                                         
REARCH       ,:S-IC-NO                                                  
REARCH       ,:S-RATE-PLAN-NO                                           
REARCH       ,:S-RATE-DESC                                              
REARCH       ,:S-UM-EQUIP-SHRT-DESC                                     
REARCH       ,:S-NO-UNITS                                               
REARCH       ,:S-LIGHT-POLE-NO                                          
REARCH       ,:S-NO-DAYS                                                
REARCH       ,:S-USAGE-FIXED                                            
REARCH       ,:S-INSTALL-DATE                                           
REARCH       ,:S-REMOVE-DATE                                            
REARCH       ,:S-CODE-PLAN-STATUS                                       
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02102_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,DATE_ORIG_BILL                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,RATE_DESC                                                         
MFA-TR*      ,UM_EQUIP_SHRT_DESC                                                
MFA-TR*      ,NO_UNITS                                                          
MFA-TR*      ,LIGHT_POLE_NO                                                     
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,USAGE_FIXED                                                       
MFA-TR*      ,INSTALL_DATE                                                      
MFA-TR*      ,REMOVE_DATE                                                       
MFA-TR*      ,CODE_PLAN_STATUS                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-DATE-ORIG-BILL                                                 
MFA-TR*      ,:S-IC-NO                                                          
MFA-TR*      ,:S-RATE-PLAN-NO                                                   
MFA-TR*      ,:S-RATE-DESC                                                      
MFA-TR*      ,:S-UM-EQUIP-SHRT-DESC                                             
MFA-TR*      ,:S-NO-UNITS                                                       
MFA-TR*      ,:S-LIGHT-POLE-NO                                                  
MFA-TR*      ,:S-NO-DAYS                                                        
MFA-TR*      ,:S-USAGE-FIXED                                                    
MFA-TR*      ,:S-INSTALL-DATE                                                   
MFA-TR*      ,:S-REMOVE-DATE                                                    
MFA-TR*      ,:S-CODE-PLAN-STATUS                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02102_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02102_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02102_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02102_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
