       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02098.                                          
COB303 DATE-WRITTEN.      MAY 18, 1995.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S098                                           *        
      *  PROGRAM:       S098                                           *        
      *  CALLING SP:    PA_S098                                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES LANDLORD INFORMATION FOR A PREMISE       *        
      *  PARAMETERS:                                                   *        
      *    UPDATE-TYPE (IUD)                                         *        
      *    USERID                                                      *        
      *    RESP-AREA-ID                                                *        
      *    PREMISE-NO (AS STRING)                                      *        
      *    CODE-RENTAL-PROP                                            *        
      *    CUSTOMER-NO (AS STRING)                                     *        
      *    LL-MASTER-ACCT-NO (AS STRING)                               *        
      *    ADDRESS-ID                                                  *        
      *    ADDRESS-FORMAT                                              *        
      *    ADDR-STREET                                                 *        
      *    CITY-STATE                                                  *        
      *    ZIP-CODE                                                    *        
      *    COUNTRY                                                     *        
      *    ADDRESS-OVERFLOE                                            *        
      *    PREV-ADDR-OVERFLOW                                                   
      *    PREV-ADDRESS                                                *        
      *    NEW-ADDRESS                                                 *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE                                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/18/95    TOR      RPC ORIGINALLY ADDED.                    *        
      *                                                                *        
      *  01/10/96    MR       ADDED FUNCTIONALITY. IF PREMISE IS       *        
      *                       ATTACHED TO ACCOUNT, THE LANDLORD INFO   *        
      *                       SHOULD BE UPDATED IN CSS-ACCOUNT. ALSO,  *        
      *                       IF LANDLORD DELETED, THEN THE LANDLORD   *        
      *                       INFO SHOULD BE REMOVED IN CSS_ACCOUNT.   *        
      *                                                                *        
      *                       INCLUDE: CWS00056                        *        
      *                                CSS_ACCOUNT                     *        
      *                       ADDED :                                  *        
      *                       7500-SELECT-ACCOUNT (SELECTS CODES...)   *        
      *                       8610-UPDATE-CODES                        *        
      *                                                                *        
      *  03/12/96    PP       REMOVED 6210-CALCULATE-CHECK-DIGIT       *        
      *                       FOR CREATING NEW ADDRESS-ID              *        
*T4158*  09/04/96    AG       TPR 4158     GET NEW ADDRESS-ID FROM     *        
*T4158*                       COPYBOOK.                                *        
*T8522*  01/25/97    RPG      TPR 8522 - INCLUDED TABLE ID OF '59' IN  *        
*T8522*                       REVERSION PART OF MODULES JRNL-INSERT AND*        
*T8522*                       JRNL-UPDATE.                             *        
*T9753*  03/19/97    AS       ADDED CALL TO PARAGRAPH                  *        
*T9753*                       7500-SELECT-ACCOUNT IN 5000-UPDATE.      *        
CBSI  *  08/05/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19368*  03/11/98    FB       DO NOT UPDATE WS-CODE-LANDLD.  FIELD ON  *        
T19368*                       CSS_PREMISE IS NOW USED AS LANDLORD FLAG.*        
REARCH*  09/02/06    CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
C31664*  07/09/07    FB       CHANGE ORDER REASON FROM REVERT TO       *        
C31664*                       FORCED IF LANDLORD IS DELETED            *        
C35134*  11/20/07    SC       PREVENT ERROR WHILE DELETING LANDLORD    *        
T36932*  05/08/08    SV       INCREASE ADDRESS LENGTH                  *        
C35665*  09/04/08    FB       REMOVE BILL ADDRESS FROM ACCOUNTS WHEN   *        
C35665*                       LANDLORD IS DELETED FROM PREMISE.        *        
C35665*                       COMMENTED OUT FREEFORM ADDRESS DELETE.   *        
C35665*  02/25/09    FB       DELETE ROWS FROM CSS_BILL_ADDR_XREF      *        
C35665*                       WHEN LANDLORD IS DELETED FROM PREMISE.   *        
P00422*  06/01/10    FB       SET LANDLORD_REVERT_FL FOR CUSTOMER WHEN *        
P00422*                       PREMISE IS SET TO REVERT (PROP MGR).     *        
P00740*  02/28/14    FB       UPDATE LANDLORD FLAG FOR CUSTOMER.       *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02098'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02098 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_PREMISE >                                                       
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_LANDLORD >                                                      
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_ID_CNTL >                                                  
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FREEFORM >                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME_ACCT_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_BILL_ADDR_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBBLADRX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT - ADDED BY MR 1/10 >                                    
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
C31664     EXEC SQL                                                             
C31664        INCLUDE TBSODAT                                                   
C31664     END-EXEC.                                                            
                                                                        
P00422     EXEC SQL                                                             
P00422        INCLUDE TBCUST                                                    
P00422     END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBCSTMSC                                                  
P00740     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      * ADDED FOR JOURNALING                                                    
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
      *    ADDED COPYBOOK                                                       
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CWS00071                                                  
*T4158     END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CWS0090A                                                  
*T4158     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                       VALUE                      
REARCH                                  'SESSION.CSR02098_R1'.          
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-UPDATE-TYPE        PIC X(01) VALUE SPACES.          
           05  PARM-PREMISE-NO         PIC X(10).                       
           05  PARM-PREMISE-NO-RED     REDEFINES PARM-PREMISE-NO        
                                       PIC 9(10).                       
COB305     05 PARM-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
           05  PARM-CODE-RENTAL-PROP   PIC X(1).                        
           05  PARM-CUSTOMER-NO        PIC X(10).                       
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
COB305     05 PARM-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
           05  PARM-MASTER-ACCT-NO     PIC X(13).                       
           05  PARM-MASTER-ACCT-NO-RED REDEFINES PARM-MASTER-ACCT-NO    
                                       PIC 9(13).                       
COB305     05 PARM-MASTER-ACCT-NO-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
COB305     05 PARM-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
           05  PARM-ADDRESS-ID         PIC X(13).                       
           05  PARM-ADDRESS-ID-RED     REDEFINES PARM-ADDRESS-ID        
                                       PIC 9(13).                       
COB305     05 PARM-ADDRESS-ID-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
           05  PARM-ADDRESS-FORMAT     PIC X(01).                       
T36932     05  PARM-ADDR-STREET        PIC X(55).                       
T36932     05  PARM-CITY-STATE         PIC X(30).                       
           05  PARM-ZIP-CODE           PIC X(09).                       
           05  PARM-COUNTRY            PIC X(35).                       
           05  PARM-ADDRESS-OVERFLOW   PIC X(35).                       
SRI        05  PARM-PREV-ADDR-OVERFLOW PIC X(35).                       
T36932     05  PARM-PREV-ADDRESS       PIC X(75).                       
T36932     05  PARM-NEW-ADDRESS        PIC X(75).                       
           05  PARM-USER-ID            PIC X(09).                       
           05  PARM-RESP-AREA-ID       PIC X(03).                       
           05  PARM-TRAN-COMMENT.                                       
               49  PARM-TRAN-COMMENT-LEN                                
                                   PIC S9(04) COMP SYNC VALUE +0.       
               49  PARM-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ADDRESS-ID           PIC X(13) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-ADDRESS-ID           PIC X(13) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      * CODE-RENTAL-PROP VALUES                                                 
       01  WS-CODES.                                                    
           05  WS-NON-RENTAL-PROP       PIC X(01) VALUE 'A'.            
           05  WS-NO-REVERT             PIC X(01) VALUE 'C'.            
           05  WS-AUTO-REVERT           PIC X(01) VALUE 'D'.            
                                                                        
       01  WS-MISC.                                                     
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-CODE-RENTAL-PROP      PIC X(01) VALUE SPACE.          
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.       
                                                                        
           05  WS-CUSTOMER-NO           PIC X(10)   VALUE SPACES.       
           05  WS-CUSTOMER-NO-RED       REDEFINES WS-CUSTOMER-NO        
                                        PIC 9(10).                      
                                                                        
COB305     05 WS-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05  WS-PREMISE-NO            PIC X(10)   VALUE SPACES.       
           05  WS-PREMISE-NO-RED        REDEFINES WS-PREMISE-NO         
                                        PIC 9(10).                      
                                                                        
COB305     05 WS-MASTER-ACCT-NO-NUM        PIC S9(13) USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-MASTER-ACCT-NO        PIC X(13) VALUE SPACES.         
           05  WS-MASTER-ACCT-NO-RED    REDEFINES WS-MASTER-ACCT-NO     
                                        PIC 9(13).                      
                                                                        
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  WS-ACCOUNT-NO-RED        REDEFINES WS-ACCOUNT-NO         
                                        PIC 9(13).                      
                                                                        
COB305     05 WS-ADDRESS-ID-NUM        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-ADDRESS-ID            PIC X(13) VALUE SPACES.         
           05  WS-ADDRESS-ID-RED        REDEFINES WS-ADDRESS-ID         
                                        PIC 9(13).                      
           05  WS-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.         
                                                                        
COB305     05 NEW-ADDRESS-ID-NUM        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  NEW-ADDRESS-ID           PIC X(13) VALUE SPACES.         
           05  NEW-ADDRESS-ID-RED       REDEFINES NEW-ADDRESS-ID        
                                        PIC 9(13).                      
           05  NEW-ADDRESS-FORMAT       PIC X(01) VALUE SPACES.         
           05  WS-ADDR-DEL-FLAG         PIC X(01) VALUE 'N'.            
                                                                        
           05  WS-NULL-IND-1            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-2            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-3            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-4            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-5            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-6            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-7            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-8            PIC S9(04) COMP VALUE ZERO.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02098'.     
           05  WS-NULL-IND-9            PIC S9(04) COMP VALUE ZERO.     
P00740     05  WS-MISC-INFO-FL          PIC X(01) VALUE SPACES.         
P00740     05  WS-LANDLORD-FL           PIC X(01) VALUE SPACES.         
P00740     05  WS-CUST-CHG-FL           PIC X(01) VALUE SPACES.         
P00740     05  WS-LL-ON-OTHER-FL        PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-NEW-ADDR-COMP.                                            
           05  WS-NEW-ADDR-IDENT           PIC 9(13).                   
           05  FILLER REDEFINES WS-NEW-ADDR-IDENT.                      
               10  WS-NEW-ADDR-CHECK-DIGIT PIC 9.                       
               10  WS-NEW-ADDR-ID          PIC 9(12).                   
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  LINK-UPDATE-TYPE        PIC X(01).                           
REARCH 01  LINK-PREMISE-NO         PIC X(10).                           
REARCH 01  LINK-CODE-RENTAL-PROP   PIC X(1).                            
REARCH 01  LINK-CUSTOMER-NO        PIC X(10).                           
REARCH 01  LINK-MASTER-ACCT-NO     PIC X(13).                           
REARCH 01  LINK-ACCOUNT-NO         PIC X(13).                           
REARCH 01  LINK-ADDRESS-ID         PIC X(13).                           
REARCH 01  LINK-ADDRESS-FORMAT     PIC X(01).                           
T36932 01  LINK-ADDR-STREET        PIC X(55).                           
T36932 01  LINK-CITY-STATE         PIC X(30).                           
REARCH 01  LINK-ZIP-CODE           PIC X(09).                           
REARCH 01  LINK-COUNTRY            PIC X(35).                           
REARCH 01  LINK-ADDRESS-OVERFLOW   PIC X(35).                           
C35134 01  LINK-PREV-ADDR-OVERFLOW PIC X(35).                           
T36932 01  LINK-PREV-ADDRESS       PIC X(75).                           
T36932 01  LINK-NEW-ADDRESS        PIC X(75).                           
REARCH 01  LINK-USER-ID            PIC X(09).                           
REARCH 01  LINK-RESP-AREA-ID       PIC X(03).                           
REARCH 01  LINK-TRAN-COMMENT-LEN   PIC S9(04) COMP.                     
REARCH 01  LINK-TRAN-COMMENT-TEXT  PIC X(210).                          
REARCH                                                                  
REARCH PROCEDURE DIVISION USING                                         
REARCH                    LINK-UPDATE-TYPE                              
REARCH                    LINK-PREMISE-NO                               
REARCH                    LINK-CODE-RENTAL-PROP                         
REARCH                    LINK-CUSTOMER-NO                              
REARCH                    LINK-MASTER-ACCT-NO                           
REARCH                    LINK-ACCOUNT-NO                               
REARCH                    LINK-ADDRESS-ID                               
REARCH                    LINK-ADDRESS-FORMAT                           
REARCH                    LINK-ADDR-STREET                              
REARCH                    LINK-CITY-STATE                               
REARCH                    LINK-ZIP-CODE                                 
REARCH                    LINK-COUNTRY                                  
REARCH                    LINK-ADDRESS-OVERFLOW                         
C35134                    LINK-PREV-ADDR-OVERFLOW                       
REARCH                    LINK-PREV-ADDRESS                             
REARCH                    LINK-NEW-ADDRESS                              
REARCH                    LINK-USER-ID                                  
REARCH                    LINK-RESP-AREA-ID                             
REARCH                    LINK-TRAN-COMMENT-LEN                         
REARCH                    LINK-TRAN-COMMENT-TEXT.                       
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           :S-RETURN-CODE      AS RETURN_CODE                     
REARCH          ,:S-ADDRESS-ID       AS ADDRESS_ID                      
REARCH        FROM                                                      
REARCH           CIS.SYSDUMMY1                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE      AS RETURN_CODE                             
MFA-TR*         ,:S-ADDRESS-ID       AS ADDRESS_ID                              
MFA-TR*       FROM                                                              
MFA-TR*          SYSIBM.SYSDUMMY1                                               
MFA-TR*    END-EXEC.                                                            
REARCH                                                                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *        
      *     2.  FORMAT PACKED NUMERICS.                                *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE LINK-UPDATE-TYPE           TO PARM-UPDATE-TYPE.         
REARCH     MOVE LINK-PREMISE-NO            TO PARM-PREMISE-NO.          
REARCH     MOVE LINK-CODE-RENTAL-PROP      TO PARM-CODE-RENTAL-PROP.    
REARCH     MOVE LINK-CUSTOMER-NO           TO PARM-CUSTOMER-NO .        
REARCH     MOVE LINK-MASTER-ACCT-NO        TO PARM-MASTER-ACCT-NO .     
REARCH     MOVE LINK-ACCOUNT-NO            TO PARM-ACCOUNT-NO.          
REARCH     MOVE LINK-ADDRESS-ID            TO PARM-ADDRESS-ID.          
REARCH     MOVE LINK-ADDRESS-FORMAT        TO PARM-ADDRESS-FORMAT.      
REARCH     MOVE LINK-ADDR-STREET           TO PARM-ADDR-STREET.         
REARCH     MOVE LINK-CITY-STATE            TO PARM-CITY-STATE.          
REARCH     MOVE LINK-ZIP-CODE              TO PARM-ZIP-CODE.            
REARCH     MOVE LINK-COUNTRY               TO PARM-COUNTRY.             
REARCH     MOVE LINK-ADDRESS-OVERFLOW      TO PARM-ADDRESS-OVERFLOW.    
C35134     MOVE LINK-PREV-ADDR-OVERFLOW    TO PARM-PREV-ADDR-OVERFLOW.  
REARCH     MOVE LINK-PREV-ADDRESS          TO PARM-PREV-ADDRESS.        
REARCH     MOVE LINK-NEW-ADDRESS           TO PARM-NEW-ADDRESS.         
REARCH     MOVE LINK-USER-ID               TO PARM-USER-ID.             
REARCH     MOVE LINK-RESP-AREA-ID          TO PARM-RESP-AREA-ID.        
REARCH     MOVE LINK-TRAN-COMMENT-TEXT     TO PARM-TRAN-COMMENT-TEXT.   
REARCH     MOVE LINK-TRAN-COMMENT-LEN      TO PARM-TRAN-COMMENT-LEN.    
           MOVE PARM-PREMISE-NO-RED        TO PARM-PREMISE-NO-NUM.      
           MOVE PARM-CUSTOMER-NO-RED       TO PARM-CUSTOMER-NO-NUM.     
           MOVE PARM-MASTER-ACCT-NO-RED    TO PARM-MASTER-ACCT-NO-NUM.  
           MOVE PARM-ACCOUNT-NO-RED        TO PARM-ACCOUNT-NO-NUM.      
           MOVE PARM-ADDRESS-ID-RED        TO PARM-ADDRESS-ID-NUM.      
P00422     MOVE PARM-CUSTOMER-NO-NUM       TO CU-CUSTOMER-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   2000-PROCESS-OUTPUT                                          *        
      *                                                                *        
      *       1. DESCRIBE RESULT SET                                   *        
      *       2. UPDATE DB2 DATA                                       *        
      *       3. BUILD RESULT SET                                      *        
      *       4. SEND RESULT SET                                       *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE NEW-ADDRESS-ID             TO RS-ADDRESS-ID.            
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARCH     ADD     1                           TO  CTR-ROWS.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*   2000A-MOVE-RESULT                                            *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH       MOVE RS-RETURN-CODE   TO S-RETURN-CODE.                    
REARCH       MOVE RS-ADDRESS-ID    TO S-ADDRESS-ID .                    
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
                                                                        
      ******************************************************************        
      *   5000-UPDATE.                                                 *        
      *                                                                *        
      *       1.   BASED ON THE ACTION CODE (INSERT/UPDATE/DELETE),    *        
      *            PERFORM FUNCTIONALITY.                              *        
      *       2.   IN UPDATE MODE WHEN NEW ADDRESS IS SELECTED,        *        
      *            DELETE THE OLD ADDRESS IF IT WAS CREATED THROUGH    *        
      *            THE LANDLORD PANEL (CHECK WITH NAME_ADDR_XREF AND   *        
      *            BILL_ADDR_XREF TABLE).                              *        
      *       3.   IN DELETE MODE DELETE THE ADDRESS ROCORD IF IT      *        
      *            WAS CREATED BY THE LANDLORD PANEL                   *        
      *                                                                *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
              PERFORM 5100-JRNL-TRAN-HEAD         THRU 5100-EXIT        
      *-------------------------------*                                         
      * PROCESS LANDLORD INSERT.      *                                         
      *-------------------------------*                                         
           IF PARM-UPDATE-TYPE = 'I'                                    
                                                                        
              PERFORM 7000-SELECT-PREMISE         THRU 7000-EXIT        
              PERFORM 5400-PROCESS-INSERT-ADDR    THRU 5400-EXIT        
                                                                        
              MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO    
                                                MI-TRANS-HIST-SEQ-NO    
              MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS           
              PERFORM 5200-JRNL-INSERT            THRU 5200-EXIT        
                                                                        
              PERFORM 8300-UPDATE-PREMISE         THRU 8300-EXIT        
P00422        IF PARM-CODE-RENTAL-PROP = 'D' OR 'S'                     
P00422           PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT            
P00422           IF CU-LANDLORD-REVERT-FL = ' ' OR 'N'                  
P00422               PERFORM 5330-CUSTOMER-TRANSHIST THRU 5330-EXIT     
P00422               PERFORM 8400-UPDATE-CUSTOMER THRU 8400-EXIT        
P00422           END-IF                                                 
P00422        END-IF                                                    
              PERFORM 8125-INSERT-LANDLORD        THRU 8125-EXIT        
P00740        MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO                     
P00740        PERFORM 7300-SELECT-CUST-MISC THRU 7300-EXIT              
P00740        IF WS-MISC-INFO-FL = 'Y'                                  
P00740            EVALUATE LQ-LANDLORD-FL                               
P00740                WHEN 'Y'                                          
P00740                    CONTINUE                                      
P00740                WHEN OTHER                                        
P00740                    MOVE 'Y' TO WS-LANDLORD-FL                    
P00740                    PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT  
P00740            END-EVALUATE                                          
P00740        ELSE                                                      
P00740            PERFORM 8820-INSERT-CUST-MISC THRU 8820-EXIT          
P00740        END-IF                                                    
      *--------------------------*                                              
      * PROCESS LANDLORD DELETE. *                                              
      *--------------------------*                                              
           ELSE IF PARM-UPDATE-TYPE = 'D'                               
                                                                        
              PERFORM 7000-SELECT-PREMISE         THRU 7000-EXIT        
              PERFORM 7100-SELECT-LANDLORD        THRU 7100-EXIT        
              PERFORM 5250-JRNL-DELETE            THRU 5250-EXIT        
              PERFORM 8300-UPDATE-PREMISE         THRU 8300-EXIT        
              PERFORM 8200-DELETE-LANDLORD        THRU 8200-EXIT        
C31664        PERFORM 8700-UPDATE-ORDERS          THRU 8700-EXIT        
C35665        PERFORM 8800-UPDATE-ACCOUNT         THRU 8800-EXIT        
P00740        MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO                     
P00740        PERFORM 7310-SELECT-LANDLORD THRU 7310-EXIT               
P00740        IF WS-LL-ON-OTHER-FL = 'N'                                
P00740            PERFORM 7300-SELECT-CUST-MISC THRU 7300-EXIT          
P00740            IF WS-MISC-INFO-FL = 'Y'                              
P00740                MOVE 'N' TO WS-LANDLORD-FL                        
P00740                PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT      
P00740                PERFORM 8830-DELETE-NULL-MISC THRU 8830-EXIT      
P00740            END-IF                                                
P00740        END-IF                                                    
                                                                        
      *--------------------------*                                              
      * PROCESS LANDLORD UPDATE. *                                              
      *--------------------------*                                              
           ELSE IF PARM-UPDATE-TYPE = 'U'                               
                                                                        
              PERFORM 7000-SELECT-PREMISE         THRU 7000-EXIT        
              PERFORM 7100-SELECT-LANDLORD        THRU 7100-EXIT        
              PERFORM 5400-PROCESS-INSERT-ADDR    THRU 5400-EXIT        
                                                                        
              MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO    
                                                MI-TRANS-HIST-SEQ-NO    
              PERFORM 5300-JRNL-UPDATE            THRU 5300-EXIT        
              PERFORM 8300-UPDATE-PREMISE         THRU 8300-EXIT        
P00422        IF PARM-CODE-RENTAL-PROP = 'D' OR 'S'                     
P00422            PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT           
P00422            IF CU-LANDLORD-REVERT-FL = ' ' OR 'N'                 
P00422                PERFORM 5330-CUSTOMER-TRANSHIST THRU 5330-EXIT    
P00422                PERFORM 8400-UPDATE-CUSTOMER THRU 8400-EXIT       
P00422            END-IF                                                
P00422        END-IF                                                    
              PERFORM 8150-UPDATE-LANDLORD        THRU 8150-EXIT        
P00740        IF WS-CUST-CHG-FL = 'Y'                                   
P00740            MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO                 
P00740            PERFORM 7300-SELECT-CUST-MISC   THRU 7300-EXIT        
P00740            IF WS-MISC-INFO-FL = 'Y'                              
P00740                EVALUATE LQ-LANDLORD-FL                           
P00740                    WHEN 'Y'                                      
P00740                        CONTINUE                                  
P00740                    WHEN OTHER                                    
P00740                        MOVE 'Y' TO WS-LANDLORD-FL                
P00740                        PERFORM 8810-UPDATE-CUST-MISC THRU        
P00740                                8810-EXIT                         
P00740                END-EVALUATE                                      
P00740            ELSE                                                  
P00740                PERFORM 8820-INSERT-CUST-MISC THRU 8820-EXIT      
P00740            END-IF                                                
P00740            MOVE WS-CUSTOMER-NO-RED TO LQ-CUSTOMER-NO             
P00740            PERFORM 7310-SELECT-LANDLORD THRU 7310-EXIT           
P00740            IF WS-LL-ON-OTHER-FL = 'N'                            
P00740                PERFORM 7300-SELECT-CUST-MISC   THRU 7300-EXIT    
P00740                IF WS-MISC-INFO-FL = 'Y'                          
P00740                    MOVE 'N' TO WS-LANDLORD-FL                    
P00740                    PERFORM 8810-UPDATE-CUST-MISC THRU 8810-EXIT  
P00740                    PERFORM 8830-DELETE-NULL-MISC THRU 8830-EXIT  
P00740                END-IF                                            
P00740            END-IF                                                
P00740        END-IF                                                    
                                                                        
      *--------------------------------*                                        
      * PROCESS PROGRAMMER LOGIC ERROR.*                                        
      *--------------------------------*                                        
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '5000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
              MOVE 'PROGRAMMER LOGIC'           TO TABLE-1              
              MOVE 'PARM-UPDATE-TYPE'           TO TABLE-ELEMENT-1      
              MOVE PARM-UPDATE-TYPE             TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
                                                                        
           END-IF
                END-IF
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   5100-JRNL-TRAN-HEAD.                                         *        
      *                                                                *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      *                                                                *        
      ******************************************************************        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :WS-CURRENT-TIMESTAMP,                             
                     :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP,                                     
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO       
           MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS              
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
           IF PARM-TRAN-COMMENT-TEXT = SPACES                           
              MOVE ZERO                   TO MH-TRAN-COMMENT-LEN        
           ELSE                                                         
              MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN        
           END-IF.                                                      
           MOVE PARM-TRAN-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.      
           MOVE ZEROES                    TO MH-ACCOUNT-NO.             
           MOVE ZEROES                    TO MH-CUSTOMER-NO.            
           MOVE PARM-PREMISE-NO           TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
           MOVE 'PANEL062'                TO MH-APPL-PROGRAM-ID.        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-JRNL-INSERT.                                              *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5200-JRNL-INSERT.                                                
                                                                        
           MOVE '5200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CUSTOMER-NO >                             
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-CUSTOMER-NO                              
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-CUSTOMER-NO   TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'LL CUSTOMER NO '     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_RENTAL_PROP >                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-CODE-RENTAL-PROP TO                      
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE PARM-CODE-RENTAL-PROP TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'REVERSION TYPE '     TO MI-COLUMN-DESC.                
T8522      MOVE '59'                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
T8522      MOVE SPACES                TO MI-TABLE-ID.                   
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < LL_MASTER_ACCT_NO >                       
           IF PARM-MASTER-ACCT-NO-NUM > 0                               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-MASTER-ACCT-NO                        
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-MASTER-ACCT-NO TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'LL MASTER ACCT '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS_ID IN CSS_LANDLORD >              
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE LENGTH OF PARM-NEW-ADDRESS                              
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-NEW-ADDRESS      TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'LL ADDRESS    '      TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
           IF PARM-ADDRESS-OVERFLOW > SPACES                            
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN        
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT       
           MOVE LENGTH OF PARM-ADDRESS-OVERFLOW                         
                                      TO MI-CHG-COLUMN-VALUE-LEN        
           MOVE PARM-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT       
           MOVE 'LL ADDR OVERFLOW'    TO MI-COLUMN-DESC                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT             
           ADD 1 TO WS-TRAN-APPL-NO                                     
           END-IF                                                       
                                                                        
           IF PARM-ADDRESS-ID-NUM = 0                                   
              PERFORM 5320-JRNL-ADDRESS      THRU 5320-EXIT             
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5250-JRNL-DELETE.                                              *        
      * 1.   CREATE JOURNAL ENTRIES FOR DELETION OF LANDLORD DETAILS   *        
      *      FOR THE PREMISE.                                          *        
      *                                                                *        
      ******************************************************************        
       5250-JRNL-DELETE.                                                
                                                                        
           MOVE '5250'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CUSTOMER-NO >                             
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE LENGTH OF PARM-CUSTOMER-NO TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE PARM-CUSTOMER-NO           TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE '*DELETED*'                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE 'LL CUSTOMER    '          TO MI-COLUMN-DESC.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-JRNL-UPDATE.                                              *        
      *                                                                *        
      * 1.   JOURNAL ANY FIELDS THAT THE USER HAS CHANGED BY FORMATING *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5300-JRNL-UPDATE.                                                
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE SI-CUSTOMER-NO               TO WS-CUSTOMER-NO-RED.     
           MOVE SI-LL-MASTER-ACCT-NO         TO WS-MASTER-ACCT-NO-RED.  
           MOVE SI-ADDRESS-ID                TO WS-ADDRESS-ID-RED.      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CUSTOMER_NO >                             
           IF WS-CUSTOMER-NO NOT = PARM-CUSTOMER-NO                     
P00740        MOVE 'Y' TO WS-CUST-CHG-FL                                
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE LENGTH OF PARM-CUSTOMER-NO                           
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                                                MI-PRV-COLUMN-VALUE-LEN 
              MOVE PARM-CUSTOMER-NO    TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE WS-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'LL CUSTOMER NO '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CODE_RENTAL_PROP >                        
           IF PARM-CODE-RENTAL-PROP NOT = PR-CODE-RENTAL-PROP           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-CODE-RENTAL-PROP TO                   
                                            MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-CODE-RENTAL-PROP TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE PR-CODE-RENTAL-PROP   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REVERSION TYPE '     TO MI-COLUMN-DESC              
T8522         MOVE '59'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
T8522         MOVE SPACES                TO MI-TABLE-ID                 
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < LL_MASTER_ACCT_NO >                       
           IF PARM-MASTER-ACCT-NO NOT = WS-MASTER-ACCT-NO               
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-MASTER-ACCT-NO                        
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN    
              MOVE PARM-MASTER-ACCT-NO TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE WS-MASTER-ACCT-NO      TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'LL MASTER ACCT '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS_ID IN CSS_LANDLORD >              
           IF   (PARM-PREV-ADDRESS NOT = PARM-NEW-ADDRESS)              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE LENGTH OF PARM-PREV-ADDRESS                          
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-NEW-ADDRESS      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE PARM-PREV-ADDRESS     TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LL ADDRESS    '      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
C35134        IF ((PARM-ADDRESS-OVERFLOW > SPACES) OR                   
C35134               (PARM-PREV-ADDR-OVERFLOW > SPACES))                
C35134        MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
C35134        MOVE LENGTH OF PARM-PREV-ADDR-OVERFLOW                    
C35134                                  TO MI-CHG-COLUMN-VALUE-LEN      
C35134                                    MI-PRV-COLUMN-VALUE-LEN       
C35134        MOVE PARM-ADDRESS-OVERFLOW    TO MI-CHG-COLUMN-VALUE-TEXT 
C35134        MOVE PARM-PREV-ADDR-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT 
C35134        MOVE 'LL ADDR OVERFLOW    '      TO MI-COLUMN-DESC        
C35134        PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
C35134        ADD 1 TO WS-TRAN-APPL-NO                                  
C35134        END-IF                                                    
           END-IF.                                                      
                                                                        
           IF PARM-ADDRESS-ID-NUM = 0                                   
              PERFORM 5320-JRNL-ADDRESS      THRU 5320-EXIT             
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5320-JRNL-ADDRESS                                             *         
      *                                                               *         
      *      CREATE JOURNAL RECORD FOR ALL ADDRESS FIELDS IN          *         
      *      CSS_ADDR_FREEFORM FOR NEWLY ADDRED ADDRESS               *         
      *****************************************************************         
                                                                        
       5320-JRNL-ADDRESS.                                               
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDR_STREET >                             
           IF PARM-ADDR-STREET > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ADDR-STREET                           
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDR-STREET       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDRESS STREET '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CITY_STATE >                              
           IF PARM-CITY-STATE > SPACES                                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-CITY-STATE                            
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-CITY-STATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'CITY, STATE    '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ZIP_CODE >                                
           IF PARM-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ZIP-CODE                              
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ZIP-CODE          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE '            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < COUNTRY >                                 
           IF PARM-COUNTRY > SPACES                                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-COUNTRY                               
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-COUNTRY           TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'COUNTRY NAME   '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS_OVERFLOW >                        
           IF PARM-ADDRESS-OVERFLOW > SPACES                            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ADDRESS-OVERFLOW                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR OVERFLOW '       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5330-CUSTOMER-TRANSHIST.                                         
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                                     
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
           MOVE ZEROES                    TO MH-ACCOUNT-NO.             
           MOVE CU-CUSTOMER-NO            TO MH-CUSTOMER-NO.            
           MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
           MOVE 'PANEL062'                TO MH-APPL-PROGRAM-ID.        
           MOVE ZERO                      TO MH-TRAN-COMMENT-LEN.       
           MOVE SPACES                    TO MH-TRAN-COMMENT-TEXT.      
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'Y'                       TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE CU-LANDLORD-REVERT-FL     TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'REVERT ELIGIBLE'         TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5400-PROCESS-INSERT-ADDR                                      *         
      *                                                               *         
      *      WHEN PARM-ADDRESS-ID IS 0 (NEW ADDRESS) GET NEXT         *         
      *      ADDRESS-ID FROM CSS_ADDR_ID_CNTL AND INSERT RECORD       *         
      *      IN CSS_ADDR_FREEFORM TABLE                               *         
      *****************************************************************         
                                                                        
       5400-PROCESS-INSERT-ADDR.                                        
                                                                        
           IF PARM-ADDRESS-ID-NUM = 0                                   
                                                                        
*T4158        MOVE 'PANEL062'             TO WS-90-PANEL-NO             
*T4158        MOVE PARM-USER-ID           TO WS-90-USERID               
*T4158        MOVE PARM-ACCOUNT-NO-RED    TO WS-90-ACCOUNT-NO           
*T4158        MOVE ZEROES                 TO WS-90-CUSTOMER-NO          
*T4158        MOVE ZEROES                 TO WS-90-PREMISE-NO           
                                                                        
*T4158        PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT            
*T4158        MOVE WS-90-NEW-ADDRESS-ID   TO WS-NEW-ADDR-IDENT          
*T4158        MOVE WS-NEW-ADDR-IDENT      TO NEW-ADDRESS-ID-NUM         
*T4158        MOVE NEW-ADDRESS-ID-NUM     TO NEW-ADDRESS-ID-RED         
*T4158        MOVE 'B'                    TO NEW-ADDRESS-FORMAT         
                                                                        
              PERFORM 8500-INSERT-ADDRESS      THRU 8500-EXIT           
           ELSE                                                         
              MOVE PARM-ADDRESS-ID-NUM    TO NEW-ADDRESS-ID-NUM         
              MOVE NEW-ADDRESS-ID-NUM     TO NEW-ADDRESS-ID-RED         
              MOVE PARM-ADDRESS-FORMAT    TO NEW-ADDRESS-FORMAT         
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-SELECT-PREMISE                                           *         
      *                                                               *         
      *      SELECT THE DETAILS FROM CSS_PREMISE TABLE                *         
      *****************************************************************         
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODE_RENTAL_PROP                                  
               INTO   :PR-CODE-RENTAL-PROP                              
               FROM   CSS_PREMISE WITH(READUNCOMMITTED)                         
               WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_RENTAL_PROP                                          
MFA-TR*        INTO   :PR-CODE-RENTAL-PROP                                      
MFA-TR*        FROM   CSS_PREMISE                                               
MFA-TR*        WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
CBSI          MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-LANDLORD                                           *        
      *                                                                *        
      *    1.  RETRIEVE EXISTING DATA FOR LANDLORD.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     LL_MASTER_ACCT_NO,                                 
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT                                     
              INTO   :SI-CUSTOMER-NO,                                   
                     :SI-LL-MASTER-ACCT-NO,                             
                     :SI-ADDRESS-ID,                                    
                     :SI-ADDRESS-FORMAT                                 
              FROM   CSS_LANDLORD WITH(READUNCOMMITTED)                         
              WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              LL_MASTER_ACCT_NO,                                         
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*       INTO   :SI-CUSTOMER-NO,                                           
MFA-TR*              :SI-LL-MASTER-ACCT-NO,                                     
MFA-TR*              :SI-ADDRESS-ID,                                            
MFA-TR*              :SI-ADDRESS-FORMAT                                         
MFA-TR*       FROM   CSS_LANDLORD                                               
MFA-TR*       WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
CBSI          MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00422 7200-SELECT-CUSTOMER.                                            
P00422                                                                  
P00422     EXEC SQL                                                     
P00422        SELECT LANDLORD_REVERT_FL                                 
P00422        INTO   :CU-LANDLORD-REVERT-FL                             
P00422        FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                         
P00422        WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                                 
                                                            
P00422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LANDLORD_REVERT_FL                                         
MFA-TR*       INTO   :CU-LANDLORD-REVERT-FL                                     
MFA-TR*       FROM   CSS_CUSTOMER                                               
MFA-TR*       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00422                                                                  
P00422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00422                                                                  
P00422     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00422         NEXT SENTENCE                                            
P00422     ELSE                                                         
P00422        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00422        MOVE '7200'               TO ACTIVE-PARAGRAPH             
P00422        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00422        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00422                                      ABEND-TABLES                
P00422        MOVE 'CSS_CUSTOMER'       TO TABLE-1                      
P00422        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
P00422        MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
P00422        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00422        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00422     END-IF.                                                      
P00422                                                                  
P00422                                                                  
P00422 7200-EXIT.                                                       
P00422     EXIT.                                                        
                                                                        
P00740 7300-SELECT-CUST-MISC.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        SELECT LANDLORD_FL                                        
P00740        INTO   :LQ-LANDLORD-FL                                    
P00740        FROM   CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
P00740        WHERE  CUSTOMER_NO = :LQ-CUSTOMER-NO                      
P00740                                                           
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LANDLORD_FL                                                
MFA-TR*       INTO   :LQ-LANDLORD-FL                                            
MFA-TR*       FROM   CSS_CUST_MISC_INFO                                         
MFA-TR*       WHERE  CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             MOVE 'Y' TO WS-MISC-INFO-FL                          
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             MOVE 'N' TO WS-MISC-INFO-FL                          
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
P00740             MOVE '7300'          TO ACTIVE-PARAGRAPH             
P00740             MOVE 'SELECT'        TO ABEND-FUNCTION               
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                           ABEND-TABLES           
P00740             MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
P00740             MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
P00740             MOVE LQ-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
P00740             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00740             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7300-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
                                                                        
P00740 7310-SELECT-LANDLORD.                                            
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        SELECT TOP(1) PREMISE_NO                                         
P00740          INTO :SI-PREMISE-NO                                     
P00740          FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
P00740         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
P00740       AND NOT PREMISE_NO = :PARM-PREMISE-NO-NUM                  
P00740                                           
P00740                                                           
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :SI-PREMISE-NO                                             
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*      AND NOT PREMISE_NO = :PARM-PREMISE-NO-NUM                          
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             MOVE 'Y' TO WS-LL-ON-OTHER-FL                        
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             MOVE 'N' TO WS-LL-ON-OTHER-FL                        
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
P00740             MOVE '7310'          TO ACTIVE-PARAGRAPH             
P00740             MOVE 'SELECT'        TO ABEND-FUNCTION               
P00740             MOVE SPACES          TO ABEND-SQL-PREDICATES         
P00740                                          ABEND-TABLES            
P00740             MOVE 'CSS_LANDLORD'  TO TABLE-1                      
P00740             MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
P00740             MOVE SI-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
P00740             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00740             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7310-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  CHECK DIGITS COPYBOOKS.                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CPD00090                                                  
*T4158     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * 8125-INSERT-LANDLORD                                           *        
      *                                                                *        
      *    1.  INSERT CSS_LANDLORD VALUES.                             *        
      *                                                                *        
      ******************************************************************        
       8125-INSERT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_LANDLORD                                  
                   ( PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
                     LL_MASTER_ACCT_NO,                                 
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:PARM-PREMISE-NO-NUM,                               
                    :PARM-CUSTOMER-NO-NUM,                              
                    :PARM-MASTER-ACCT-NO-NUM,                           
                    :NEW-ADDRESS-ID-NUM,                                
                    :NEW-ADDRESS-FORMAT)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8125'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'LL_MASTER_ACCT_NO'  TO TABLE-ELEMENT-3              
CBSI          MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-4              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-MASTER-ACCT-NO-NUM  TO HOSTVAR-ELEMENT-3        
CBSI          MOVE NEW-ADDRESS-ID-NUM   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-UPDATE-LANDLORD                                           *        
      *                                                                *        
      *    1. UPDATES LANDLORD INFORMATION.                            *        
      *                                                                *        
      ******************************************************************        
       8150-UPDATE-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_LANDLORD                                       
              SET    CUSTOMER_NO    = :PARM-CUSTOMER-NO-NUM,            
                     LL_MASTER_ACCT_NO = :PARM-MASTER-ACCT-NO-NUM,      
                     ADDRESS_ID        = :NEW-ADDRESS-ID-NUM,           
                     ADDRESS_FORMAT    = :NEW-ADDRESS-FORMAT            
              WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_LANDLORD                                               
MFA-TR*       SET    CUSTOMER_NO    = :PARM-CUSTOMER-NO-NUM,                    
MFA-TR*              LL_MASTER_ACCT_NO = :PARM-MASTER-ACCT-NO-NUM,              
MFA-TR*              ADDRESS_ID        = :NEW-ADDRESS-ID-NUM,                   
MFA-TR*              ADDRESS_FORMAT    = :NEW-ADDRESS-FORMAT                    
MFA-TR*       WHERE  PREMISE_NO = :PARM-PREMISE-NO-NUM                          
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'LL_MASTER_ACCT_NO'  TO TABLE-ELEMENT-3              
CBSI          MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-4              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-MASTER-ACCT-NO-NUM  TO HOSTVAR-ELEMENT-3        
CBSI          MOVE NEW-ADDRESS-ID-NUM   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-DELETE-LANDLORD                                           *        
      *                                                                *        
      *    1.  DELETE RECORDS FROM CSS_LANDLORD BASED ON PREMISE NO.   *        
      *                                                                *        
      ******************************************************************        
       8200-DELETE-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_LANDLORD                                  
              WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_LANDLORD                                          
MFA-TR*       WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                           
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_LANDLORD'        TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8300-UPDATE-PREMISE                                           *         
      *                                                               *         
      *      UPDATE CSS_PREMISE TABLE WITH PARAMETERS PASSED          *         
      *****************************************************************         
                                                                        
       8300-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
              SET CODE_RENTAL_PROP = :PARM-CODE-RENTAL-PROP             
              WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*       SET CODE_RENTAL_PROP = :PARM-CODE-RENTAL-PROP                     
MFA-TR*       WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                           
MFA-TR*       QUERYNO 8300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_RENTAL_PROP'   TO TABLE-ELEMENT-2              
              MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CODE-RENTAL-PROP TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00422 8400-UPDATE-CUSTOMER.                                            
P00422                                                                  
P00422     EXEC SQL                                                     
P00422        UPDATE CSS_CUSTOMER                                       
P00422        SET LANDLORD_REVERT_FL = 'Y'                              
P00422        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                                                            
P00422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*       SET LANDLORD_REVERT_FL = 'Y'                                      
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                               
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00422                                                                  
P00422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00422                                                                  
P00422     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00422         WHEN SUCCESSFUL-CALL                                     
P00422         WHEN NOT-FOUND                                           
P00422             CONTINUE                                             
P00422         WHEN OTHER                                               
P00422             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
P00422             MOVE '8400'          TO ACTIVE-PARAGRAPH             
P00422             MOVE 'UPDATE'        TO ABEND-FUNCTION               
P00422             MOVE SPACES          TO ABEND-SQL-PREDICATES         
P00422                                          ABEND-TABLES            
P00422             MOVE 'CSS_CUSTOMER'  TO TABLE-1                      
P00422             MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
P00422             MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
P00422             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00422             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00422     END-EVALUATE.                                                
P00422                                                                  
P00422 8400-EXIT.                                                       
P00422     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8500-INSERT-ADDRESS                                           *         
      *****************************************************************         
                                                                        
       8500-INSERT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   (:NEW-ADDRESS-ID-NUM,                                
                    :PARM-ADDR-STREET,                                  
                    :PARM-CITY-STATE,                                   
                    :PARM-ZIP-CODE,                                     
                    :PARM-COUNTRY,                                      
                    :PARM-ADDRESS-OVERFLOW)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
CBSI          MOVE 'ADDR_COUNTRY'       TO TABLE-ELEMENT-4              
              MOVE NEW-ADDRESS-ID       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ADDR-STREET     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ZIP-CODE        TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-COUNTRY         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-UPDATE-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_REASON = 'F'                                
                WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                 
                  AND ORDER_REASON = 'R'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET ORDER_REASON = 'F'                                        
MFA-TR*         WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                         
MFA-TR*           AND ORDER_REASON = 'R'                                        
MFA-TR*       QUERYNO 8700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8700'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
CBSI               MOVE SPACES          TO ABEND-SQL-PREDICATES         
CBSI                                             ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'   TO TABLE-1                      
CBSI               MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE PARM-PREMISE-NO TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C35665 8800-UPDATE-ACCOUNT.                                             
C35665                                                                  
C35665     EXEC SQL                                                     
C35665         UPDATE CSS_ACCOUNT                                       
C35665            SET ADDRESS_ID = 0,                                   
C35665                ADDRESS_FORMAT = ' '                              
C35665          WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                 
C35665            AND ADDRESS_ID = :SI-ADDRESS-ID                       
C35665            AND ADDRESS_FORMAT = :SI-ADDRESS-FORMAT               
                                                           
C35665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET ADDRESS_ID = 0,                                           
MFA-TR*               ADDRESS_FORMAT = ' '                                      
MFA-TR*         WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                         
MFA-TR*           AND ADDRESS_ID = :SI-ADDRESS-ID                               
MFA-TR*           AND ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                       
MFA-TR*       QUERYNO 88001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35665                                                                  
C35665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35665                                                                  
C35665     EVALUATE WS-ACTIVE-RETURN-CODE                               
C35665         WHEN SUCCESSFUL-CALL                                     
C35665             CONTINUE                                             
C35665         WHEN NOT-FOUND                                           
C35665             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
C35665         WHEN OTHER                                               
C35665             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
C35665             MOVE '8800'          TO ACTIVE-PARAGRAPH             
C35665             MOVE 'UPDATE'        TO ABEND-FUNCTION               
C35665             MOVE SPACES          TO ABEND-SQL-PREDICATES         
C35665                                           ABEND-TABLES           
C35665             MOVE 'CSS_ACCOUNT'   TO TABLE-1                      
C35665             MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
C35665             MOVE PARM-PREMISE-NO TO HOSTVAR-ELEMENT-1            
C35665             MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-2              
C35665             MOVE SI-ADDRESS-ID   TO HOSTVAR-ELEMENT-2            
C35665             MOVE 'ADDRESS_FMT'   TO TABLE-ELEMENT-3              
C35665             MOVE SI-ADDRESS-FORMAT TO HOSTVAR-ELEMENT-3          
C35665             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C35665             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C35665     END-EVALUATE.                                                
C35665                                                                  
C35665     EXEC SQL                                                     
C35665         DELETE FROM CSS_BILL_ADDR_XREF                           
C35665          WHERE ADDRESS_ID = :SI-ADDRESS-ID                       
C35665            AND ACCOUNT_NO IN                                     
C35665             (SELECT ACCOUNT_NO                                   
C35665                FROM CSS_ACCOUNT                                  
C35665              WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM)            
                                                           
C35665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILL_ADDR_XREF                                   
MFA-TR*         WHERE ADDRESS_ID = :SI-ADDRESS-ID                               
MFA-TR*           AND ACCOUNT_NO IN                                             
MFA-TR*            (SELECT ACCOUNT_NO                                           
MFA-TR*               FROM CSS_ACCOUNT                                          
MFA-TR*             WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM)                    
MFA-TR*       QUERYNO 88002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35665                                                                  
C35665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35665                                                                  
C35665     EVALUATE WS-ACTIVE-RETURN-CODE                               
C35665         WHEN SUCCESSFUL-CALL                                     
C35665             CONTINUE                                             
C35665         WHEN NOT-FOUND                                           
C35665             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
C35665         WHEN OTHER                                               
C35665             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
C35665             MOVE '8800'          TO ACTIVE-PARAGRAPH             
C35665             MOVE 'DELETE'        TO ABEND-FUNCTION               
C35665             MOVE SPACES          TO ABEND-SQL-PREDICATES         
C35665                                           ABEND-TABLES           
C35665             MOVE 'CSS_ACCOUNT'   TO TABLE-1                      
C35665             MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
C35665             MOVE PARM-PREMISE-NO TO HOSTVAR-ELEMENT-1            
C35665             MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-2              
C35665             MOVE SI-ADDRESS-ID   TO HOSTVAR-ELEMENT-2            
C35665             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C35665             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C35665     END-EVALUATE.                                                
C35665                                                                  
C35665 8800-EXIT.                                                       
C35665     EXIT.                                                        
                                                                        
P00740 8810-UPDATE-CUST-MISC.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         UPDATE CSS_CUST_MISC_INFO                                
P00740            SET LANDLORD_FL = :WS-LANDLORD-FL                     
P00740          WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                     
                                                            
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_MISC_INFO                                        
MFA-TR*           SET LANDLORD_FL = :WS-LANDLORD-FL                             
MFA-TR*         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                             
MFA-TR*       QUERYNO 8810                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
P00740             MOVE '8810'          TO ACTIVE-PARAGRAPH             
P00740             MOVE 'UPDATE'        TO ABEND-FUNCTION               
P00740             MOVE SPACES          TO ABEND-SQL-PREDICATES         
P00740                                           ABEND-TABLES           
P00740             MOVE 'CSS_CUST_MISC_INFO'  TO TABLE-1                
P00740             MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
P00740             MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
P00740             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00740             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 8810-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8820-INSERT-CUST-MISC.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        INSERT INTO CSS_CUST_MISC_INFO                            
P00740             ( CUSTOMER_NO,                                       
P00740               LANDLORD_FL)                                       
P00740        VALUES                                                    
P00740             (:LQ-CUSTOMER-NO,                                    
P00740              'Y')                                                
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740        NEXT SENTENCE                                             
P00740     ELSE                                                         
P00740        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00740        MOVE '8820'               TO ACTIVE-PARAGRAPH             
P00740        MOVE 'INSERT'             TO ABEND-FUNCTION               
P00740        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P00740                                     ABEND-TABLES                 
P00740        MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
P00740        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
P00740        MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
P00740        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00740        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00740     END-IF.                                                      
P00740                                                                  
P00740 8820-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8830-DELETE-NULL-MISC.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        DELETE FROM CSS_CUST_MISC_INFO                            
P00740         WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO              
P00740           AND INFLUENTIAL_CUST   =  ' '                          
P00740           AND KEY_CUSTOMER       =  ' '                          
P00740           AND SPECIAL_CUST       =  ' '                          
P00740           AND CONSULTING_PROJECT =  ' '                          
P00740           AND CONSLT_PRJ_END_DT  IS NULL                         
P00740           AND LOSS_RESERVE_CD    =  0                            
P00740           AND LOSS_RESRVE_EFF_DT IS NULL                         
P00740           AND IVR_NDO_EXEMPT     = 'N'                           
P00740           AND BUILDER_FL         = 'N'                           
P00740           AND REALTOR_FL         = 'N'                           
P00740           AND LANDLORD_FL        = 'N'                           
P00740           AND DBA_NAME           = ' '                           
P00740           AND DBA_TAX_ID         = ' '                           
P00740           AND WEBSITE_ADDR       = ' '                           
P00740           AND INTR_CO_IND        = ' '                           
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_MISC_INFO                                    
MFA-TR*        WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO                      
MFA-TR*          AND INFLUENTIAL_CUST   =  ' '                                  
MFA-TR*          AND KEY_CUSTOMER       =  ' '                                  
MFA-TR*          AND SPECIAL_CUST       =  ' '                                  
MFA-TR*          AND CONSULTING_PROJECT =  ' '                                  
MFA-TR*          AND CONSLT_PRJ_END_DT  IS NULL                                 
MFA-TR*          AND LOSS_RESERVE_CD    =  0                                    
MFA-TR*          AND LOSS_RESRVE_EFF_DT IS NULL                                 
MFA-TR*          AND IVR_NDO_EXEMPT     = 'N'                                   
MFA-TR*          AND BUILDER_FL         = 'N'                                   
MFA-TR*          AND REALTOR_FL         = 'N'                                   
MFA-TR*          AND LANDLORD_FL        = 'N'                                   
MFA-TR*          AND DBA_NAME           = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND INTR_CO_IND        = ' '                                   
MFA-TR*       QUERYNO 8830                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
P00740             MOVE '8830'          TO ACTIVE-PARAGRAPH             
P00740             MOVE 'DELETE'        TO ABEND-FUNCTION               
P00740             MOVE SPACES          TO ABEND-SQL-PREDICATES         
P00740                                          ABEND-TABLES            
P00740             MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
P00740             MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
P00740             MOVE LQ-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
P00740             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00740             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 8830-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *    END PROGRAM COPYLIB                                                  
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00331                                                 
REARCH     END-EXEC.                                                            
