       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02092.                                         
COB303 DATE-WRITTEN.      MAY 8, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00110000
      ******************************************************************00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROCEDURE DEPOSIT DETAIL INFORMATION ON AN ACCOUNT.      *00200000
      *  IT FIRST CALCULATES THE DEPOSIT ESTIMATE FROM PAST ACCOUNT    *00210000
      *  BILLING INFORMATION AND THEN RETRIEVES THE DEPOSIT RECORD     *00220000
      *  DETAILS.                                                      *00230000
      *                                                                *00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                     PROGRAM MODIFICATION LOG                   *00270000
      *                                                                *00280000
      *    DATE    INITIALS   COMMENTS                                 *00290000
      *  --------  --------   ---------------------------------------  *00300000
      *  05/08/95    WMG      PROCEDURE ORIGINALLY CODED.              *00310000
      *  12/15/95    MJL      TPR 2369 -- CHANGED PROGRAM TO FETCH ONLY*00320000
      *                       12 MONTHS BILL HISTORY INTO INTERNAL     *00330000
      *                       TABLE.                                   *00340000
      *  02/21/96    WMG      TPR 3259 -- MODIFIED 'DEPOSITS' CURSOR   *00350000
      *                       TO FETCH ROWS IN CSS_DEP_ON_HAND THAT ARE*00360000
      *                       NOT IN CSS_DEP_REQ.                      *00370000
      *  02/28/96    WMG      CHANGED TO RETRIEVE DEPOSIT AMOUNT FROM  *00380000
      *                       CSS_DEP_ON_HAND.AMT_DEPOSIT; CHANGE      *00390000
      *                       COMPUTATION OF AMOUNT PAID FOR A DEPOSIT.*00400000
      *  03/07/96    WMG      ALLOW DEPOSITS FOR PENDING ACCOUNTS BY   *00410000
      *                       SKIPPING BILL DATE CALCULATIONS (CAN ONLY*00420000
      *                       PERFORM IMMEDIATE BILLING).              *00430000
      *  04/10/96    JHR      TPR 3771 -- COMMENTED OUT MOVE OF NOT-   *00440000
      *                       FOUND TO RS-RETURN-CODE IN PARAGRAPH     *00450000
      *                       7100 IN THE CASE OF A SUCCESSFUL CALL.   *00460000
      *                       ADDED MOVE OF SUCCESSFUL CALL TO         *00470000
      *                       RS-RETURN-CODE IN PARAGRAPH 5150 BEFORE  *00480000
      *                       SENDING A RESULT SET.                    *00490000
P136  *  09/18/96    JRX      PCR136 -- PASS THE CODE-DISC-OK TO PANEL *00500000
      *                       141                                      *00510000
TP6204*  12/03/96    SG       TPR 6204 - CORRECTED RESULT SET          *00520000
TP6204*                       DEFINITION ERRORS.                       *00521000
TP8452*  01/20/97    JEP      TPR 8456 - ORDERED RESULT SET BY STATUS  *00522000
TP8452*                       AND DATE_TRANS DESC.                     *00523000
TP8767*  02/06/97   JEP       TPR 8767 MODIFICATIONS FOR NEXT BILLING  *00524000
TP8767*                       DATE POPULATION.  ADDED REFERENCES TO    *00525000
TP8767*                       CPD00309 AND CWS00309.  CPD0023C WAS     *00526000
TP8767*                       ALSO ADDED FOR ERROR-HANDLING.           *00527000
TP9171*  02/13/97   PD        TPR 9171 TO DISABLE AMT INSTALLMENTS AND *00528000
TP9171*                       NO OF INSTALLMENTS WHEN THE DEP IS BILLED*00529000
TP9422*  02/26/97   PD        TPR 9422 GET ACCOUNT DETAILS BEFORE      *00529100
TP9422*                       CALCULATING MAX DEP AMOUNT.              *00529200
PCR482*  03/06/97    MAD      MODIFIED THE CALCULATION FOR TOTAL PAY-  *00529300
      *                       MENTS ON A DEPOSIT.                      *00529400
TP9642*  03/14/97    MAD      RPC MUST RETURN THE CREDIT GROUP TO THE  *00529500
      *                       PANEL - IF CREDIT GROUP IS 'C' (EXEMPT), *00529600
      *                       INSERT OF DEPOSITS IS NOT PERMITTED.     *00529700
T10290*  04/10/97    MAD      ADDED CSS_CUST_PREM_HIST DCLGEN TO       *00529800
      *                       SUPPORT CPD00308 CHANGES.                *00529900
T11039*  05/10/97    MAD      MODIFICATIONS TO GET THE NEXT BILLING    *00530000
      *                       DATES CORRECT ON THE PANEL.              *00530100
100197*  10/01/97    BAB      SECOND SELECT STATEMENT IN UNION DOES NOT*00530200
      *                       NEED A REFERENCE TO CSS_DEP_REQ.         *00530300
T12902*  03/11/98    SV       PANEL 141 SHOWS ONLY 1 RECORD EVEN IF    *00530402
      *                       RECORDS WHERE FOUND. SQLCODE WAS SET TO  *00530502
      *                       ZERO BEFORE READING CSS_DEP_ON_HAND      *00530602
T15605*  04/16/98    SHF      MODIFIED SO THAT VARIABLES ARE LOADING   *00530706
      *                       CORRECTLY BEFORE WRITING TO MC05 ERROR   *00530806
      *                       LOG.                                     *00530906
CBSI  *  08/21/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T17856*  09/24/98    SHF      MOVED CWS00308 INCLUDE TO BE AFTER WS    *        
      *                       DECLARATIONS AND ADDED HOST VARIABLE     *        
      *                       WS-ACCOUNT-NO TO COMPONENT CWS00308.     *        
T19396*  03/12/99    SHF      IF WS-DATE-MM IS EQUAL TO 0 THEN 1 (JAN) *        
      *                       WILL BE USED TO PREVENT -180 SQLCODE.    *        
T21202*  05/12/00   CBSI      SELECT LAST-UPDATE-TS FROM CSS_ACCOUNT   *        
T21202*             MADRAS    AND ADD IT TO THE RESULT SET.            *        
T22668*  08/23/00    SFH      CPD00308 NEEDS TO KNOW IF ACCOUNT        *        
      *                       IS SCEG OR SEB.                          *        
T23513*  01/24/01    AS       CHANGES MADE TO DISTINGUISH DATABASES SEB*        
T23513*                       AND NON SEB TO INCORPORATE PSNC IN NON   *        
T23513*                       SEB                                      *        
T23501*  02/02/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 2650 TO SUPPORT MULTI-COMPANY.      *        
T23179*  05/03/01    SS82048  CHANGES FOR PSNC TO COMPUTE MAXIMUM      *        
T23179*                       DEPOSIT AMOUNT FOR SEASONAL /            *        
T23179*                       NON-SEASONAL RATES.                      *        
T24646*  08/15/01    SS82048  TO FIX DB2 V.6. RESERVED WORDS PROBLEM   *        
      *                       CSS_DEP_ON_HAND USES DO AS ALIAS NAME    *        
      *                                                                         
REARCH*  07/23/03   MR90712    RPC CONVERTED TO COBOL SP               *        
REARC2*  10/01/03   BASKAR  1.REMOVE ROWICMS CALL AND USE STATIC INSERT*        
REARC2*                     2.DELETE COMMENTED CODES FOR CLEAN UP      *        
REARC2*                       PROCESSING AS PER BRUCE BIERNASKI        *        
T28160*  10/24/03   DP19151   ADDED CODE_REFUND_ELIG TO THE RESULTS    *        
T28160*                       SET FOR PANEL 141.                       *        
T26296*  01/12/05   DL85939   CHANGES FOR AUTOMATED DEPOSITS PROJECT.  *        
C33201*  09/14/05    SS82048  INCLUDE DCLGEN FOR CSS_REG_PROFILE       *        
      *                       AND CSS_LOCAL_OFFICE                              
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
T34822*  10/09/06    CVNS     INTRODUCED A NEW TABLE TO CALCULATE      *        
T34822*             CHENNAI   THE NEXT DUE DATE FOR SEB DATABASE AND   *        
T34822*                       AT-CREDIT-GROUP = 'B'                    *        
T34621*  07/02/07   VIJAY     REPLACED COPYBOOK CPD00309 WITH          *        
T34621*                       CPD0309A.                                         
P00453*  08/23/11   GOKUL     POPULATE AT-ACCOUNT-NO TO BE USED BY     *        
P00453*                       CPD0309A.                                         
A04527*  08/08/13   RB19957   ADDED ORDER BY DEPOSIT_CERT_NO 4 VENKATP *        
P00705*  09/09/13   VENKATP   FIXED RC # -181 ISSUE WITH PSNC ACCTS    *        
A05091** 01/23/16   RB19957   ADDED TBATMISC WHICH IS NOW NEEDED       *        
A05091**                      IN CPD00308 FOR SEB SEASONAL FLAG.       *        
      ******************************************************************00531000
      ******************************************************************00540000
      *                                                                *00550000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00560000
      *                                                                *00570000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00580000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00590000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00600000
      *  3000 - 4999  NOT USED                                         *00610000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00620000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00630000
      *  7000 - 7999  INPUT MODULES                                    *00640000
      *  8000 - 8999  OUTPUT MODULES                                   *00650000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00660000
      *                                                                *00670000
      ******************************************************************00680000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02092'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02092 STARTS HERE'.                  
                                                                        
      ******************************************************************00770000
      *    DB2 INCLUDES                                                *00780000
      ******************************************************************00790000
      *                                                                 00800000
           EXEC SQL                                                     00810000
              INCLUDE SQLCA                                             00820000
           END-EXEC.                                                    00830000
      *                                                                 00840000
           EXEC SQL                                                     00850000
              INCLUDE TBMODEL                                           00860000
           END-EXEC.                                                    00870000
      *                                                                 00880000
           EXEC SQL                                                     00890000
              INCLUDE TBDEPHND                                          00900000
           END-EXEC.                                                    00910000
      *                                                                 00911000
           EXEC SQL                                                     00912000
              INCLUDE TBBLLHDR                                          00913000
           END-EXEC.                                                    00914000
      *                                                                 00920000
           EXEC SQL                                                     00930000
              INCLUDE TBBLLDET                                          00940000
           END-EXEC.                                                    00950000
      *                                                                 00960000
           EXEC SQL                                                     00970000
              INCLUDE TBDEPREQ                                          00980000
           END-EXEC.                                                    00990000
      *                                                                 01000000
           EXEC SQL                                                     01010000
              INCLUDE TBACCT                                            01020000
           END-EXEC.                                                    01030000
      *                                                                 01040000
           EXEC SQL                                                     01050000
              INCLUDE TBBILWDW                                          01060000
           END-EXEC.                                                    01070000
      *                                                                 01080000
           EXEC SQL                                                     01090000
              INCLUDE TBARCNTL                                          01100000
           END-EXEC.                                                    01110000
      *                                                                 01120000
           EXEC SQL                                                     01130000
              INCLUDE TBDELQ                                            01140000
           END-EXEC.                                                    01150000
      *                                                                 01160000
           EXEC SQL                                                     01170000
              INCLUDE TBHLDAY                                           01180000
           END-EXEC.                                                    01190000
      *                                                                 01200000
           EXEC SQL                                                     01201000
              INCLUDE TBCRCOLL                                          01202000
           END-EXEC.                                                    01203000
      *                                                                 01210000
PCR482     EXEC SQL                                                     01211000
PCR482        INCLUDE TBDEPHST                                          01212000
PCR482     END-EXEC.                                                    01213000
      *                                                                 01214000
T10290     EXEC SQL                                                     01215000
T10290        INCLUDE TBCSTPRM                                          01216000
T10290     END-EXEC.                                                    01217000
      *                                                                 00933000
T23179     EXEC SQL                                                     00930000
T23179        INCLUDE TBUTLENV                                          00931000
T23179     END-EXEC.                                                    00932000
      *                                                                 00933000
T23179     EXEC SQL                                                     00930000
T23179        INCLUDE TBRTCRTR                                          00931000
T23179     END-EXEC.                                                    00932000
      *                                                                         
T34822     EXEC SQL                                                     00930000
T34822        INCLUDE TBCRFCST                                          00931000
T34822     END-EXEC.                                                    00932000
      *                                                                 00933000
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
C33201************************************************************              
C33201**   CSS_LOCAL_OFFICE (B1)                                                
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBLOCOFC                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
A05091************************************************************              
A05091**   CSS_ACCT_MISC_INFO TA                                                
A05091************************************************************              
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
      *                                                                 01218000
      ******************************************************************01220000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01230000
      ******************************************************************01240000
                                                                        
REARCH*    COPY SYGWCOB.                                                01260000
REARCH*    COPY SYDBCOB.                                                01270000
           COPY CCA00001.                                               01280000
REARCH*    COPY CWS00010.                                               01290000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01300000
           COPY CWS00303.                                               01310000
      *                                                                 01310100
TP8452     EXEC SQL                                                     01312000
TP8767        INCLUDE CWS00309                                          01317000
TP8767     END-EXEC.                                                    01318000
      *                                                                 01319000
      ******************************************************************01330000
      *    WORK AREAS                                                  *01340000
      ******************************************************************01350000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01620000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 01680000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T23513     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
T23513         88  CSR-DATABASE                  VALUE 1.               
T23513         88  SEB-DATABASE                  VALUE 2.               
      *                                                                 01760000
       01  NULL-INDICATORS.                                             
           05  NEXT-BILL-DATE-IND      PIC S9(04) COMP VALUE 0.         
           05  NEXT-DUE-DATE-IND       PIC S9(04) COMP VALUE 0.         
           05  DATE-TRAN-IND           PIC S9(04) COMP VALUE 0.         
           05  REBILLED-DEP-DATE-IND   PIC S9(04) COMP VALUE 0.         
           05  NULL-CERT-NO            PIC S9(04) COMP VALUE 0.         
           05  NULL-VALUE              PIC S9(04) COMP VALUE -1.        
           05  NULL-DUE-DATE           PIC S9(04) COMP VALUE 0.         
           05  NULL-CUT-DATE           PIC S9(04) COMP VALUE 0.         
           05  DATE-PYMT-START-IND     PIC S9(04) COMP VALUE 0.         
           05  DATE-PYMT-START-IND-WS  PIC S9(04) COMP VALUE 0.         
           05  DATE-BILLED-IND         PIC S9(04) COMP VALUE 0.         
           05  LAST-NRML-BILL-NO-IND   PIC S9(04) COMP VALUE 0.         
PCR482     05  WS-TOTAL-PAYMENTS-NI    PIC S9(04) COMP VALUE 0.         
T26296     05  NULL-AUTODEP-LTR-DT     PIC S9(04) COMP VALUE 0.         
T26296     05  DEP-COUNT-NULL-IND      PIC S9(04) COMP VALUE 0.         
      *                                                                 01870000
       01  PROGRAM-LITS.                                                
           05  VALUE-YES               PIC X(01) VALUE 'Y'.             
           05  VALUE-NO                PIC X(01) VALUE 'N'.             
           05  DETAILS-EXIST           PIC X(01) VALUE 'N'.             
           05  DATE-IS-HOLIDAY         PIC X(01) VALUE 'Y'.             
           05  DATE-IS-WEEKEND         PIC X(01) VALUE 'Y'.             
           05  DAY-NUMBER              PIC S9(04) COMP.                 
           05  PENDING-ACCOUNT         PIC X(01) VALUE 'P'.             
           05  WS-AMT-DEPDNPLIM        PIC X(20) VALUE                  
                                          'AMT-DEPDNPLIM'.              
      *                                                                 02010000
       01  WS-TEMPORARY-VARS.                                           
           05  WS-SUMMARY-COLUMN-NAME  PIC X(30)     VALUE SPACES.      
TP9171     05  WS-DATE-PYMT-START      PIC X(10)     VALUE SPACES.      
COB305     05 WS-COLUMN-SUBTOTAL        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
           05  NO-COMMENTS.                                             
               10 COMMENT-LENGTH       PIC S9(04)    USAGE COMP         
                                                     VALUE 72.          
               10 COMMENT              PIC X(72)     VALUE SPACES.      
T26296     05  WS-BILL-DATE            PIC X(10)     VALUE SPACES.      
T26296     05  WS-BILL-TIME            PIC X(08)     VALUE SPACES.      
T26296     05  WS-DELINQ-TOTAL-DEP     PIC S99999V   COMP-3 VALUE 0.    
T26296     05  WS-TOTAL-DEP-CNT        PIC S99999V   COMP-3 VALUE 0.    
T26296     05  WS-DEPTOT-TRNHST        PIC S99999V   COMP-3 VALUE 0.    
T26296     05  WS-DEP-EXISTS-FLAG      PIC X(01)     VALUE 'N'.         
      *                                                                 02360000
       01  RS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-PARM          PIC X(13).                      
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                 02440000
       01  WS-HOST-VARIABLE.                                            
           05  WS-CASH-DEPOSITS-COUNT  PIC S9(04)    USAGE COMP.        
PCR482     05  WS-TOTAL-PAYMENTS       PIC S9(09)V9(2) COMP-3 VALUE 0.  
T11039     05  WS-HOLD-ACCT-REV-MTH    PIC S9(6)V COMP-3  VALUE 0.      
T34822     05  WS-CURR-CHG-DUE-DT      PIC X(10).                       
      *                                                                 02520000
       01  BILL-DATE-CALCULATIONS.                                      
           05  WS-MIN-DATE             PIC X(10).                       
           05  WS-MAX-DATE             PIC X(10).                       
           05  WS-HOLD-DATE.                                            
               10  WS-DATE-MM          PIC 9(02).                       
               10  WS-DATE-MM-X REDEFINES WS-DATE-MM PIC X(02).         
               10  WS-FILLER-1         PIC X(01).                       
               10  WS-DATE-DD          PIC 9(02).                       
               10  WS-FILLER-2         PIC X(01).                       
               10  WS-DATE-CCYY        PIC 9(04).                       
           05  COMPARE-DATE            PIC X(10).                       
T34822     05  WS-NEXT-BILL-DATE       PIC X(10) VALUE SPACES.          
           05  WS-BILL-FREQ.                                            
               10  WS-FREQ-CODE        PIC X(01).                       
               10  WS-START-MONTH      PIC 9(02).                       
           05  BILL-DATE-SEARCH        PIC X(10).                       
           05  WS-CURRENT-DATE         PIC X(10).                       
TP8767     05  REFORMAT-DATE.                                           
TP8767         10  WS-FORMAT-YEAR      PIC X(04).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-MONTH     PIC X(02).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-DAY       PIC X(02).                       
TP8767     05  USA-DATE-FORMAT.                                         
TP8767         10  USA-MONTH           PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-DAY             PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-YEAR            PIC X(04).                       
T34822     05  NEXT-BILL-DATE.                                          
T34822         10  WS-NXT-BILL-YEAR    PIC X(04).                       
T34822         10  FILLER              PIC X(01).                       
T34822         10  WS-NXT-BILL-MONTH   PIC X(02).                       
T34822         10  FILLER              PIC X(01).                       
T34822         10  WS-NXT-BILL-DAY     PIC X(02).                       
      *                                                                 02680000
       01  DELINQUENCY-CODE.                                            
           05  WS-DAY-STATIC           PIC X(04) VALUE 'DAY-'.          
           05  DELINQUENCY-CD          PIC X(01).                       
           05  DELINQUENCY-TEXT        PIC X(08) VALUE 'TOTALDUE'.      
      *                                                                 02730000
       01  WS-PROGRAM-NAME.                                             
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'S092    '.      02750000
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02092'.      
REARCH     05  WS-SQLSTATE             PIC X(5)  VALUE SPACES.          
      *                                                                 02760000
       01  ACCOUNT-STATUS-VARIABLES.                                    
           05  ACCT-HAS-MASTER         PIC X(01) VALUE 'N'.             
      *                                                                 02840000
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02092_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
      *                                                                 02910000
      *                                                                 02920000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02940000
      *                                                                 02950000
      *                                                                 02960000
       01  TDS-RETURN-FIELDS.                                           
TP8452     05  RS-BILL-COUNT           PIC S9(04)     COMP VALUE 0.     
TP8452     05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-MAX-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-USAGE-HISTORY-FLAG   PIC X(01)      VALUE SPACES.     
T26296     05  RS-DEP-EXISTS-FLAG      PIC X(01)      VALUE 'N'.        
T26296     05  RS-DELQ-DEP-NTFY-LTR    PIC S99999V    USAGE COMP-3      
T26296                                                VALUE 0.          
           05  RS-DEP-ACTION-CODE      PIC X(01)      VALUE SPACES.     
           05  RS-DEPOSIT-STATUS-CD    PIC X(01)      VALUE SPACES.     
           05  RS-DATE-TRAN            PIC X(10)      VALUE SPACES.     
           05  RS-SERVICE-TYPE-CD      PIC X(01)      VALUE SPACES.     
           05  RS-DEPOSIT-CERT-NO      PIC S9(09)     USAGE COMP.       
           05  RS-AMT-ORIG-ENTERED     PIC S9(09)V99  USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-AMT-PAID             PIC S9(09)V99  USAGE COMP-3      
                                                      VALUE 0.          
TP6204     05  RS-COMMENTS.                                             
TP6204         10 RS-COMMENT-LENGTH    PIC S9(4)      COMP.             
TP6204         10 RS-COMMENT           PIC X(72)      VALUE SPACES.     
           05  RS-CODE-DEP-TYPE        PIC X(01)      VALUE SPACES.     
           05  RS-NO-SCHED-PYMTS       PIC S9(04)     USAGE COMP.       
           05  RS-AMT-MO-PYMT          PIC S9(07)V99  USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-BILL-OPTION-CD       PIC X(01)      VALUE SPACES.     
           05  RS-BILLED-FLAG          PIC X(10)      VALUE SPACES.     
           05  RS-USER-ID-UPDT-BY      PIC X(07)      VALUE SPACES.     
           05  RS-DATE-PYMT-START      PIC X(10)      VALUE SPACES.     
           05  RS-OLD-BILL-DATE        PIC X(10)      VALUE SPACES.     
           05  RS-2ND-OLD-BILL-DATE    PIC X(10)      VALUE SPACES.     
           05  RS-NEXT-BILL-DATE       PIC X(10)      VALUE SPACES.     
C34822     05  RS-NEXT-DUE-DATE        PIC X(10)      VALUE SPACES.     
           05  RS-2ND-NEXT-BILL-DATE   PIC X(10)      VALUE SPACES.     
           05  RS-LAST-BILL-DATE       PIC X(10)      VALUE SPACES.     
           05  RS-MST-SUB-ACCT-IND     PIC X(01)      VALUE SPACES.     
           05  RS-DELINQUENCY-VALUE    PIC S99999V    USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-DEP-DNP-LIMIT        PIC S99999V    USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-REBILLED-DEP-AMT     PIC S9(07)V99  USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-REBILLED-DEP-DATE    PIC X(10)      VALUE SPACES.     
           05  RS-IMME-DUE-DATE        PIC X(10)      VALUE SPACES.     
           05  RS-IMME-CUT-DATE        PIC X(10)      VALUE SPACES.     
P136       05  RS-CODE-DISC-OK         PIC X(01)      VALUE SPACES.     
TP9642     05  RS-CREDIT-GROUP         PIC X(01)      VALUE SPACES.     
T11039     05  RS-NOT-CURR-MTH-FLAG    PIC X(01)      VALUE SPACES.     
           05  RS-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
T21202     05  RS-AT-LAST-UPDATE-TS    PIC X(26)      VALUE SPACES.     
T28160     05  RS-CODE-REFUND-ELIG     PIC X(01)      VALUE SPACES.     
T28160     05  RS-AGENCY-TEXTS.                                         
T28160         10 RS-AGENCY-TXT-LEN    PIC S9(4)      COMP.             
T28160         10 RS-AGENCY-TEXT       PIC X(72)      VALUE SPACES.     
T26296     05  RS-AUTODEP-LTR-DT       PIC X(10)      VALUE SPACES.     
T26296     05  RS-AUTODEP-LTR-IND      PIC X(01)      VALUE SPACES.     
      *                                                                 03360000
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-MIN-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP-3      
REARCH                                 VALUE 0.                         
REARCH     05  S-MAX-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP-3      
REARCH                                 VALUE 0.                         
REARCH     05  S-USAGE-HISTORY-FLAG    PIC X(01)      VALUE SPACES.     
T26296     05  S-DEP-EXISTS-FLAG       PIC X(01)      VALUE SPACES.     
T26296     05  S-DELQ-DEP-NTFY-LTR     PIC S99999V    USAGE COMP-3      
T26296                                                      VALUE 0.    
REARCH     05  S-DEP-ACTION-CODE       PIC X(01)      VALUE SPACES.     
REARCH     05  S-DEPOSIT-STATUS-CD     PIC X(01)      VALUE SPACES.     
REARCH     05  S-DATE-TRAN             PIC X(10)      VALUE SPACES.     
REARCH     05  S-SERVICE-TYPE-CD       PIC X(01)      VALUE SPACES.     
REARCH     05  S-DEPOSIT-CERT-NO       PIC S9(09)     USAGE COMP.       
REARCH     05  S-AMT-ORIG-ENTERED      PIC S9(09)V99  USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-BILL-OPTION-CD        PIC X(01)      VALUE SPACES.     
REARCH     05  S-BILLED-FLAG           PIC X(10)      VALUE SPACES.     
REARCH     05  S-AMT-PAID              PIC S9(09)V99  USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-COMMENT               PIC X(72)      VALUE SPACES.     
REARCH     05  S-CODE-DEP-TYPE         PIC X(01)      VALUE SPACES.     
REARCH     05  S-NO-SCHED-PYMTS        PIC S9(04)     USAGE COMP.       
REARCH     05  S-AMT-MO-PYMT           PIC S9(07)V99  USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-BILL-COUNT            PIC S9(04)     COMP VALUE 0.     
REARCH     05  S-USER-ID-UPDT-BY       PIC X(07)      VALUE SPACES.     
REARCH     05  S-DATE-PYMT-START       PIC X(10)      VALUE SPACES.     
REARCH     05  S-OLD-BILL-DATE         PIC X(10)      VALUE SPACES.     
REARCH     05  S-2ND-OLD-BILL-DATE     PIC X(10)      VALUE SPACES.     
REARCH     05  S-NEXT-BILLING-DATE     PIC X(10)      VALUE SPACES.     
REARCH     05  S-2ND-NEXT-BILL-DATE    PIC X(10)      VALUE SPACES.     
REARCH     05  S-LAST-BILL-DATE        PIC X(10)      VALUE SPACES.     
REARCH     05  S-MST-SUB-ACCT-IND      PIC X(01)      VALUE SPACES.     
REARCH     05  S-DELINQUENCY-VALUE     PIC S99999V    USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-DEP-DNP-LIMIT         PIC S99999V    USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-REBILLED-DEP-AMT      PIC S9(07)V99  USAGE COMP-3      
REARCH                                                VALUE 0.          
REARCH     05  S-REBILLED-DEP-DATE     PIC X(10)      VALUE SPACES.     
REARCH     05  S-IMME-DUE-DATE         PIC X(10)      VALUE SPACES.     
REARCH     05  S-IMME-CUT-DATE         PIC X(10)      VALUE SPACES.     
REARCH     05  S-CODE-DISC-OK          PIC X(01)      VALUE SPACES.     
REARCH     05  S-CREDIT-GROUP          PIC X(01)      VALUE SPACES.     
REARCH     05  S-NOT-CURR-MTH-FLAG     PIC X(01)      VALUE SPACES.     
REARCH     05  S-RETURN-CODE           PIC S9(9)      COMP VALUE 0.     
REARCH     05  S-AT-LAST-UPDATE-TS     PIC X(26)      VALUE SPACES.     
REARCH     05  S-DATE-FIRST-NOTICE     PIC X(10)      VALUE SPACES.     
REARCH     05  S-INSTLMNT-STRT-DATE    PIC X(10)      VALUE SPACES.     
REARCH     05  S-NEXT-BILL-DATE        PIC X(10)      VALUE SPACES.     
REARCH     05  S-NEXT-DUE-DATE         PIC X(10)      VALUE SPACES.     
REARCH     05  S-IMMED-DUE-DATE        PIC X(10)      VALUE SPACES.     
REARCH     05  S-DATE-FIRST-DUE        PIC X(10)      VALUE SPACES.     
REARCH     05  S-DATE-SECOND-DUE       PIC X(10)      VALUE SPACES.     
REARCH     05  S-CURRENT-BILL-DUE      PIC X(10)      VALUE SPACES.     
REARCH     05  S-ORIG-IMMED-DUE        PIC X(10)      VALUE SPACES.     
REARCH     05  S-CUR-IMMED-DUE         PIC X(10)      VALUE SPACES.     
REARCH     05  S-DT-FST-NTCE-OLD       PIC X(10)      VALUE SPACES.     
REARCH     05  S-CUT-DATE              PIC X(10)      VALUE SPACES.     
REARCH     05  S-FINAL-INSTLMNT-AMT    PIC S9(9) COMP VALUE 0.          
T28160     05  S-CODE-REFUND-ELIG      PIC X(01)      VALUE SPACES.     
T28160     05  S-AGENCY-TEXT           PIC X(72)      VALUE SPACES.     
T26296     05  S-AUTODEP-LTR-DT        PIC X(10)      VALUE SPACES.     
T26296     05  S-AUTODEP-LTR-IND       PIC X(01)      VALUE SPACES.     
REARCH*                                                                         
      *                                                                 04060000
TP8452     EXEC SQL                                                     01312000
TP8452        INCLUDE CWS00308                                          01313000
TP8452     END-EXEC.                                                    01314000
      *                                                                 04260000
      *                                                                 04260000
      * CURSOR FOR OBTAINING DEPOSIT RECORDS FOR AN ACCOUNT             04270000
      *                                                                 04280000
           EXEC SQL                                                     
               DECLARE DEPOSITS CURSOR FOR                              
                  SELECT DO.DEP_ACTION_CODE           ,                 
                         DO.DEPOSIT_STATUS_CD         ,                 
                         CIS.CHAR2$DATE(DO.DATE_TRAN, 'USA')      ,             
                         DO.SERVICE_TYPE_CD           ,                 
                         DO.DEPOSIT_CERT_NO           ,                 
                         DO.AMT_DEPOSIT               ,                 
                         DO.COMMENTS                  ,                 
                         DO.CODE_DEP_TYPE             ,                 
                         DR.NO_SCHED_PYMTS            ,                 
                         DR.AMT_MO_PYMT               ,                 
                         DR.DEP_BILL_OPTION_CD        ,                 
                         DO.USER_ID_UPDT_BY           ,                 
                         CIS.CHAR2$DATE(DO.DATE_PYMT_START, 'USA'),             
                         DO.DATE_PYMT_START           ,                 
                         DR.REBILLED_DEP_AMT          ,                 
                         CAST(DR.REBILLED_DEP_DATE AS CHAR(10))   ,             
                         DO.TRANSFER_AMT              ,                 
T28160                   DO.CODE_REFUND_ELIG          ,                 
T26296                   CIS.CHAR2$DATE(DO.AUTO_DEP_LTR_DT, 'USA'),             
T26296                   DO.AUTO_DEP_LTR_IND                            
T24646              FROM CSS_DEP_ON_HAND AS DO,                         
                         CSS_DEP_REQ     DR                             
                   WHERE DO.ACCOUNT_NO        = :WS-ACCOUNT-NO          
                     AND DR.ACCOUNT_NO        = :WS-ACCOUNT-NO          
                     AND DR.PYMT_PRIORITY_LVL = 80                      
                     AND DO.DEPOSIT_CERT_NO   = DR.DEP_ITEM_ID          
                 UNION                                                  
                  SELECT DO.DEP_ACTION_CODE           ,                 
                         DO.DEPOSIT_STATUS_CD         ,                 
                         CIS.CHAR2$DATE(DO.DATE_TRAN, 'USA')      ,             
                         DO.SERVICE_TYPE_CD           ,                 
                         DO.DEPOSIT_CERT_NO           ,                 
                         DO.AMT_DEPOSIT               ,                 
                         DO.COMMENTS                  ,                 
                         DO.CODE_DEP_TYPE             ,                 
                         0                            ,                 
                         0                            ,                 
                         ''                           ,                 
                         DO.USER_ID_UPDT_BY           ,                 
                         CIS.CHAR2$DATE(DO.DATE_PYMT_START, 'USA'),             
                         DO.DATE_PYMT_START           ,                 
                         0                            ,                 
                         ''                           ,                 
                         DO.TRANSFER_AMT              ,                 
T28160                   DO.CODE_REFUND_ELIG          ,                 
T26296                   CIS.CHAR2$DATE(DO.AUTO_DEP_LTR_DT, 'USA'),             
T26296                   DO.AUTO_DEP_LTR_IND                            
T24646            FROM CSS_DEP_ON_HAND AS DO                            
100197*                CSS_DEP_REQ     DQ                               04710000
                 WHERE DO.ACCOUNT_NO = :WS-ACCOUNT-NO                   
                   AND NOT EXISTS                                       
                       (SELECT 'Y'                                      
                          FROM CSS_DEP_REQ DQ                           
                         WHERE DO.ACCOUNT_NO      = DQ.ACCOUNT_NO       
                           AND DO.DEPOSIT_CERT_NO = DQ.DEP_ITEM_ID)     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04290000
MFA-TR*        DECLARE DEPOSITS CURSOR FOR                              04300000
MFA-TR*           SELECT DO.DEP_ACTION_CODE           ,                 04310000
MFA-TR*                  DO.DEPOSIT_STATUS_CD         ,                 04320000
MFA-TR*                  CHAR(DO.DATE_TRAN, USA)      ,                 04330000
MFA-TR*                  DO.SERVICE_TYPE_CD           ,                 04340000
MFA-TR*                  DO.DEPOSIT_CERT_NO           ,                 04350000
MFA-TR*                  DO.AMT_DEPOSIT               ,                 04360000
MFA-TR*                  DO.COMMENTS                  ,                 04370000
MFA-TR*                  DO.CODE_DEP_TYPE             ,                 04380000
MFA-TR*                  DR.NO_SCHED_PYMTS            ,                 04390000
MFA-TR*                  DR.AMT_MO_PYMT               ,                 04400000
MFA-TR*                  DR.DEP_BILL_OPTION_CD        ,                 04410000
MFA-TR*                  DO.USER_ID_UPDT_BY           ,                 04420000
MFA-TR*                  CHAR(DO.DATE_PYMT_START, USA),                 04430000
MFA-TR*                  DO.DATE_PYMT_START           ,                 04431000
MFA-TR*                  DR.REBILLED_DEP_AMT          ,                 04440000
MFA-TR*                  CHAR(DR.REBILLED_DEP_DATE)   ,                 04450000
MFA-TR*                  DO.TRANSFER_AMT              ,                 04460000
MFA-TR*                  DO.CODE_REFUND_ELIG          ,                 04460000
MFA-TR*                  CHAR(DO.AUTO_DEP_LTR_DT, USA),                         
MFA-TR*                  DO.AUTO_DEP_LTR_IND                                    
MFA-TR*             FROM CSS_DEP_ON_HAND AS DO,                         04470000
MFA-TR*                  CSS_DEP_REQ     DR                             04480000
MFA-TR*            WHERE DO.ACCOUNT_NO        = :WS-ACCOUNT-NO          04490000
MFA-TR*              AND DR.ACCOUNT_NO        = :WS-ACCOUNT-NO          04500000
MFA-TR*              AND DR.PYMT_PRIORITY_LVL = 80                      04510000
MFA-TR*              AND DO.DEPOSIT_CERT_NO   = DR.DEP_ITEM_ID          04520000
MFA-TR*          UNION                                                  04530000
MFA-TR*           SELECT DO.DEP_ACTION_CODE           ,                 04540000
MFA-TR*                  DO.DEPOSIT_STATUS_CD         ,                 04550000
MFA-TR*                  CHAR(DO.DATE_TRAN, USA)      ,                 04560000
MFA-TR*                  DO.SERVICE_TYPE_CD           ,                 04570000
MFA-TR*                  DO.DEPOSIT_CERT_NO           ,                 04580000
MFA-TR*                  DO.AMT_DEPOSIT               ,                 04590000
MFA-TR*                  DO.COMMENTS                  ,                 04600000
MFA-TR*                  DO.CODE_DEP_TYPE             ,                 04610000
MFA-TR*                  0                            ,                 04620000
MFA-TR*                  0                            ,                 04630000
MFA-TR*                  ''                           ,                 04640000
MFA-TR*                  DO.USER_ID_UPDT_BY           ,                 04650000
MFA-TR*                  CHAR(DO.DATE_PYMT_START, USA),                 04660000
MFA-TR*                  DO.DATE_PYMT_START           ,                 04661000
MFA-TR*                  0                            ,                 04670000
MFA-TR*                  ''                           ,                 04680000
MFA-TR*                  DO.TRANSFER_AMT              ,                 04690000
MFA-TR*                  DO.CODE_REFUND_ELIG          ,                 04690000
MFA-TR*                  CHAR(DO.AUTO_DEP_LTR_DT, USA),                         
MFA-TR*                  DO.AUTO_DEP_LTR_IND                                    
MFA-TR*           FROM CSS_DEP_ON_HAND AS DO                            04700000
MFA-TR*                CSS_DEP_REQ     DQ                               04710000
MFA-TR*          WHERE DO.ACCOUNT_NO = :WS-ACCOUNT-NO                   04720000
MFA-TR*            AND NOT EXISTS                                       04730000
MFA-TR*                (SELECT 'Y'                                      04740000
MFA-TR*                   FROM CSS_DEP_REQ DQ                           04750000
MFA-TR*                  WHERE DO.ACCOUNT_NO      = DQ.ACCOUNT_NO       04760000
MFA-TR*                    AND DO.DEPOSIT_CERT_NO = DQ.DEP_ITEM_ID)     04770000
MFA-TR*    END-EXEC.                                                    04780000
      *                                                                 04790000
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
      *                                                                 04800000
HPCCDM*EJECT                                                            04810000
      *                                                                 04820000
      *                                                                 04830000
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 04850000
      *                                                                 04860000
      ******************************************************************04870000
      * 0000-MAINLINE                                                  *04880000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04890000
      ******************************************************************04900000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05020000
      * 0100-INITIALIZE                                                *05030000
      *                                                                *05040000
      *     1. RESET DB2 ERROR HANDLERS                                *05050000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *05060000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *05070000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*05080000
      *                                                                *05090000
      ******************************************************************05100000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
      *                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             MIN_DEPOSIT_AMT                                      
REARCH            ,MAX_DEPOSIT_AMT                                      
REARCH            ,USAGE_HISTORY_FLAG                                   
T26296            ,DEP_EXISTS_FLAG                                      
T26296            ,DELQ_DEP_NTFY_LTR                                    
REARCH            ,DEP_ACTION_CODE                                      
REARCH            ,DEPOSIT_STATUS_CD                                    
REARCH            ,DATE_TRAN                                            
REARCH            ,SERVICE_TYPE_CD                                      
REARCH            ,DEPOSIT_CERT_NO                                      
REARCH            ,AMT_ORIG_ENTERED                                     
REARCH            ,BILL_OPTION_CD                                       
REARCH            ,RTRIM(BILLED_FLAG)  AS BILLED_FLAG                   
REARCH            ,AMT_PAID                                             
REARCH            ,RTRIM(COMMENTS)     AS COMMENTS                      
REARCH            ,CODE_DEP_TYPE                                        
REARCH            ,NO_SCHED_PYMTS                                       
REARCH            ,AMT_MO_PYMT                                          
REARCH            ,BILL_COUNT                                           
REARCH            ,USER_ID_UPDT_BY                                      
REARCH            ,DATE_PYMT_START                                      
REARCH            ,OLD_BILL_DATE                                        
REARCH            ,[2ND_OLD_BILL_DATE]                                    
REARCH            ,NEXT_BILLING_DATE                                    
REARCH            ,[2ND_NEXT_BILL_DATE]                                   
REARCH            ,LAST_BILL_DATE                                       
REARCH            ,MST_SUB_ACCT_IND                                     
REARCH            ,DELINQUENCY_VALUE                                    
REARCH            ,DEP_DNP_LIMIT                                        
REARCH            ,REBILLED_DEP_AMT                                     
REARCH            ,REBILLED_DEP_DATE                                    
REARCH            ,IMME_DUE_DATE                                        
REARCH            ,IMME_CUT_DATE                                        
REARCH            ,CODE_DISC_OK                                         
REARCH            ,CREDIT_GROUP                                         
REARCH            ,NOT_CURR_MTH_FLAG                                    
REARCH            ,RETURN_CODE                                          
REARCH            ,AT_LAST_UPDATE_TS                                    
REARCH            ,DATE_FIRST_NOTICE                                    
REARCH            ,INSTLMNT_STRT_DATE                                   
REARCH            ,NEXT_BILL_DATE                                       
REARCH            ,NEXT_DUE_DATE                                        
REARCH            ,IMMED_DUE_DATE                                       
REARCH            ,DATE_FIRST_DUE                                       
REARCH            ,DATE_SECOND_DUE                                      
REARCH            ,CURRENT_BILL_DUE                                     
REARCH            ,ORIG_IMMED_DUE                                       
REARCH            ,CUR_IMMED_DUE                                        
REARCH            ,DT_FST_NTCE_OLD                                      
REARCH            ,CUT_DATE                                             
REARCH            ,FINAL_INSTLMNT_AMT                                   
T28160            ,CODE_REFUND_ELIG                                     
T28160            ,AGENCY_TEXT                                          
T26296            ,AUTODEP_LTR_DT                                       
T26296            ,AUTODEP_LTR_IND                                      
REARCH         FROM                                                     
REARCH             #CSR02092_R1                                  
A04527         ORDER BY DEPOSIT_CERT_NO                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            MIN_DEPOSIT_AMT                                              
MFA-TR*           ,MAX_DEPOSIT_AMT                                              
MFA-TR*           ,USAGE_HISTORY_FLAG                                           
MFA-TR*           ,DEP_EXISTS_FLAG                                              
MFA-TR*           ,DELQ_DEP_NTFY_LTR                                            
MFA-TR*           ,DEP_ACTION_CODE                                              
MFA-TR*           ,DEPOSIT_STATUS_CD                                            
MFA-TR*           ,DATE_TRAN                                                    
MFA-TR*           ,SERVICE_TYPE_CD                                              
MFA-TR*           ,DEPOSIT_CERT_NO                                              
MFA-TR*           ,AMT_ORIG_ENTERED                                             
MFA-TR*           ,BILL_OPTION_CD                                               
MFA-TR*           ,RTRIM(BILLED_FLAG)  AS BILLED_FLAG                           
MFA-TR*           ,AMT_PAID                                                     
MFA-TR*           ,RTRIM(COMMENTS)     AS COMMENTS                              
MFA-TR*           ,CODE_DEP_TYPE                                                
MFA-TR*           ,NO_SCHED_PYMTS                                               
MFA-TR*           ,AMT_MO_PYMT                                                  
MFA-TR*           ,BILL_COUNT                                                   
MFA-TR*           ,USER_ID_UPDT_BY                                              
MFA-TR*           ,DATE_PYMT_START                                              
MFA-TR*           ,OLD_BILL_DATE                                                
MFA-TR*           ,2ND_OLD_BILL_DATE                                            
MFA-TR*           ,NEXT_BILLING_DATE                                            
MFA-TR*           ,2ND_NEXT_BILL_DATE                                           
MFA-TR*           ,LAST_BILL_DATE                                               
MFA-TR*           ,MST_SUB_ACCT_IND                                             
MFA-TR*           ,DELINQUENCY_VALUE                                            
MFA-TR*           ,DEP_DNP_LIMIT                                                
MFA-TR*           ,REBILLED_DEP_AMT                                             
MFA-TR*           ,REBILLED_DEP_DATE                                            
MFA-TR*           ,IMME_DUE_DATE                                                
MFA-TR*           ,IMME_CUT_DATE                                                
MFA-TR*           ,CODE_DISC_OK                                                 
MFA-TR*           ,CREDIT_GROUP                                                 
MFA-TR*           ,NOT_CURR_MTH_FLAG                                            
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*           ,AT_LAST_UPDATE_TS                                            
MFA-TR*           ,DATE_FIRST_NOTICE                                            
MFA-TR*           ,INSTLMNT_STRT_DATE                                           
MFA-TR*           ,NEXT_BILL_DATE                                               
MFA-TR*           ,NEXT_DUE_DATE                                                
MFA-TR*           ,IMMED_DUE_DATE                                               
MFA-TR*           ,DATE_FIRST_DUE                                               
MFA-TR*           ,DATE_SECOND_DUE                                              
MFA-TR*           ,CURRENT_BILL_DUE                                             
MFA-TR*           ,ORIG_IMMED_DUE                                               
MFA-TR*           ,CUR_IMMED_DUE                                                
MFA-TR*           ,DT_FST_NTCE_OLD                                              
MFA-TR*           ,CUT_DATE                                                     
MFA-TR*           ,FINAL_INSTLMNT_AMT                                           
MFA-TR*           ,CODE_REFUND_ELIG                                             
MFA-TR*           ,AGENCY_TEXT                                                  
MFA-TR*           ,AUTODEP_LTR_DT                                               
MFA-TR*           ,AUTODEP_LTR_IND                                              
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02092_R1                                          
MFA-TR*        ORDER BY DEPOSIT_CERT_NO                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*                                                                *        
REARCH*     DECLARING GLOBAL TEMPORARY TABLE AND CHECKING TO DELETE    *        
REARCH*     GTT ROWS IF IT EXISTS.                                     *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE                                                         
REARCH     'DECLARE GLOBAL TEMPORARY TABLE CSR02092_R1'                 
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02092_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02092_R1
              (                                                        
REARCH              MIN_DEPOSIT_AMT      DECIMAL(11,2)                  
REARCH             ,MAX_DEPOSIT_AMT      DECIMAL(11,2)                  
REARCH             ,USAGE_HISTORY_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
T26296             ,DEP_EXISTS_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
T26296             ,DELQ_DEP_NTFY_LTR    DECIMAL(5,0)                   
REARCH             ,DEP_ACTION_CODE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DEPOSIT_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,SERVICE_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DEPOSIT_CERT_NO      INT                        
REARCH             ,AMT_ORIG_ENTERED     DECIMAL(11,2)                  
REARCH             ,BILL_OPTION_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,BILLED_FLAG CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,AMT_PAID             DECIMAL(11,2)                  
REARCH             ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,CODE_DEP_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,NO_SCHED_PYMTS       SMALLINT                       
REARCH             ,AMT_MO_PYMT          DECIMAL(09,2)                  
REARCH             ,BILL_COUNT           SMALLINT                       
REARCH             ,USER_ID_UPDT_BY CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DATE_PYMT_START CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,OLD_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,[2ND_OLD_BILL_DATE] CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,NEXT_BILLING_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,[2ND_NEXT_BILL_DATE] CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,LAST_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DELINQUENCY_VALUE    DECIMAL(5,0)                   
REARCH             ,DEP_DNP_LIMIT        DECIMAL(5,0)                   
REARCH             ,REBILLED_DEP_AMT     DECIMAL(09,2)                  
REARCH             ,REBILLED_DEP_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,IMME_DUE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,IMME_CUT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CODE_DISC_OK CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CREDIT_GROUP CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,NOT_CURR_MTH_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,RETURN_CODE          INT                        
REARCH             ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DATE_FIRST_NOTICE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,INSTLMNT_STRT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,NEXT_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,NEXT_DUE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,IMMED_DUE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DATE_FIRST_DUE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DATE_SECOND_DUE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CURRENT_BILL_DUE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,ORIG_IMMED_DUE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CUR_IMMED_DUE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,DT_FST_NTCE_OLD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CUT_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,FINAL_INSTLMNT_AMT   INT                        
T28160             ,CODE_REFUND_ELIG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
T28160             ,AGENCY_TEXT CHAR(72)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
T26296             ,AUTODEP_LTR_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
T26296             ,AUTODEP_LTR_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                   THRU 8000A-EXIT                
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
REARCH             MOVE '0100A'          TO ACTIVE-PARAGRAPH            
REARCH             MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
REARCH             MOVE SPACES           TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH             MOVE SQLCODE          TO ABEND-SQLCODE               
REARCH             MOVE SQLSTATE         TO ABEND-SQLSTATE              
REARCH             MOVE 'CSR02092_R1'    TO TABLE-1                     
REARCH             MOVE SPACES           TO TABLE-ELEMENT-1             
REARCH             MOVE SPACES           TO HOSTVAR-ELEMENT-1           
REARCH             PERFORM 9900-SQL-ERROR-ROUTINE                       
REARCH                                   THRU  9900-EXIT                
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************05380000
      * 1000-PROCESS-INPUT                                             *05390000
      *                                                                *05400000
      *     1. RECEIVE PARMS.                                          *05410000
      *                                                                *05420000
      ******************************************************************05430000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS         THRU 1100-EXIT.           05470000
           PERFORM 1150-ASSIGN-WS-VARS        THRU 1150-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 05770000
      ******************************************************************05780000
      * 1150 ASSIGN-WS-VARS                                            *05790000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05800000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *05810000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *05820000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *05830000
      *        SELECT STATEMENTS.                                      *05840000
      ******************************************************************05850000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 05870000
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-PARM.       
           MOVE WS-ACCOUNT-DEC                TO WS-ACCOUNT-NO.         
P00453     MOVE WS-ACCOUNT-NO                 TO AT-ACCOUNT-NO.         
      *                                                                 05900000
      *                                                                 05910000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05940000
      *                                                                 05950000
      ******************************************************************05960000
      * 2000-PROCESS-OUTPUT.                                           *05970000
      *                                                                *05980000
      *     1. DESCRIBE RESULT SET                                     *05990000
      *     2. DETERMINE MIN/MAX SUGGESTED DEPOSITS.                   *06000000
      *     3. GET CASH DEPOSIT SUMMARY                                *06010000
      *     4. GET GUARANTOR SUMMARY                                   *06020000
      *     5. GET SURETY BOND SUMMARY                                 *06030000
      *     6. GET IRREVOCABLE LETTERS OF CREDIT SUMMARY               *06040000
      *     7  GET WAIVERS SUMMARY                                     *06050000
      *     8. SEND RESULT SET                                         *06060000
      *                                                                *06070000
      ******************************************************************06080000
      *                                                                 06090000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 06110000
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        06120000
           PERFORM 2600-GET-ACCT-INFO            THRU 2600-EXIT.        
                                                                        
T23513     MOVE ZEROS                            TO WS-DATABASE.        
T23513     MOVE 'DATABASE'                       TO C8-DELINQ-CD.       
T23501     PERFORM 2650-GET-DELINQUENT-CONST     THRU 2650-EXIT.        
T23501     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23501        MOVE C8-DELINQ-VALUE            TO WS-DATABASE            
T23501     ELSE                                                         
T23501        MOVE '2650'                     TO ACTIVE-PARAGRAPH       
T23501        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T23501        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T23501        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
T23501        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T23501        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T23501        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T23501        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T23501     END-IF.                                                      
                                                                        
TP8452     PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
           PERFORM 2400-GET-DEPOSIT-INFO         THRU 2400-EXIT.        
      *                                                                 06170000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06200000
REARCH*                                                                         
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-MIN-DEPOSIT-AMT       TO S-MIN-DEPOSIT-AMT.         
REARCH     MOVE  RS-MAX-DEPOSIT-AMT       TO S-MAX-DEPOSIT-AMT.         
REARCH     MOVE  RS-USAGE-HISTORY-FLAG    TO S-USAGE-HISTORY-FLAG.      
T26296     MOVE  RS-DEP-EXISTS-FLAG       TO S-DEP-EXISTS-FLAG.         
T26296     MOVE  RS-DELQ-DEP-NTFY-LTR     TO S-DELQ-DEP-NTFY-LTR.       
REARCH     MOVE  RS-DEP-ACTION-CODE       TO S-DEP-ACTION-CODE.         
REARCH     MOVE  RS-DEPOSIT-STATUS-CD     TO S-DEPOSIT-STATUS-CD.       
REARCH     MOVE  RS-SERVICE-TYPE-CD       TO S-SERVICE-TYPE-CD.         
REARCH     MOVE  RS-DEPOSIT-CERT-NO       TO S-DEPOSIT-CERT-NO.         
REARCH     MOVE  RS-AMT-ORIG-ENTERED      TO S-AMT-ORIG-ENTERED.        
REARCH     MOVE  RS-BILL-OPTION-CD        TO S-BILL-OPTION-CD.          
REARCH     MOVE  RS-BILLED-FLAG           TO S-BILLED-FLAG.             
REARCH     MOVE  RS-AMT-PAID              TO S-AMT-PAID.                
REARCH     MOVE  RS-COMMENT               TO S-COMMENT.                 
REARCH     MOVE  RS-CODE-DEP-TYPE         TO S-CODE-DEP-TYPE.           
REARCH     MOVE  RS-NO-SCHED-PYMTS        TO S-NO-SCHED-PYMTS.          
REARCH     MOVE  RS-AMT-MO-PYMT           TO S-AMT-MO-PYMT.             
REARCH     MOVE  RS-BILL-COUNT            TO S-BILL-COUNT.              
REARCH     MOVE  RS-USER-ID-UPDT-BY       TO S-USER-ID-UPDT-BY.         
REARCH     MOVE  RS-DATE-PYMT-START       TO S-DATE-PYMT-START.         
REARCH     MOVE  RS-OLD-BILL-DATE         TO S-OLD-BILL-DATE.           
REARCH     MOVE  RS-2ND-OLD-BILL-DATE     TO S-2ND-OLD-BILL-DATE.       
REARCH     MOVE  RS-NEXT-BILL-DATE        TO S-NEXT-BILLING-DATE.       
C34822     MOVE  RS-NEXT-DUE-DATE         TO S-NEXT-DUE-DATE.           
REARCH     MOVE  RS-2ND-NEXT-BILL-DATE    TO S-2ND-NEXT-BILL-DATE.      
REARCH     MOVE  RS-LAST-BILL-DATE        TO S-LAST-BILL-DATE.          
REARCH     MOVE  RS-MST-SUB-ACCT-IND      TO S-MST-SUB-ACCT-IND.        
REARCH     MOVE  RS-DELINQUENCY-VALUE     TO S-DELINQUENCY-VALUE.       
REARCH     MOVE  RS-DEP-DNP-LIMIT         TO S-DEP-DNP-LIMIT.           
REARCH     MOVE  RS-REBILLED-DEP-AMT      TO S-REBILLED-DEP-AMT.        
REARCH     MOVE  RS-REBILLED-DEP-DATE     TO S-REBILLED-DEP-DATE.       
REARCH     MOVE  RS-IMME-DUE-DATE         TO S-IMME-DUE-DATE.           
REARCH     MOVE  RS-IMME-CUT-DATE         TO S-IMME-CUT-DATE.           
REARCH     MOVE  RS-CODE-DISC-OK          TO S-CODE-DISC-OK.            
REARCH     MOVE  RS-CREDIT-GROUP          TO S-CREDIT-GROUP.            
REARCH     MOVE  RS-NOT-CURR-MTH-FLAG     TO S-NOT-CURR-MTH-FLAG.       
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-AT-LAST-UPDATE-TS     TO S-AT-LAST-UPDATE-TS.       
REARCH     MOVE  RS-DATE-TRAN             TO S-DATE-TRAN.               
T28160     MOVE  RS-CODE-REFUND-ELIG      TO S-CODE-REFUND-ELIG.        
T28160     MOVE  RS-AGENCY-TEXT           TO S-AGENCY-TEXT.             
T26296     MOVE  RS-AUTODEP-LTR-DT        TO S-AUTODEP-LTR-DT.          
T26296     MOVE  RS-AUTODEP-LTR-IND       TO S-AUTODEP-LTR-IND.         
REARCH     MOVE  SPACES                   TO S-DATE-FIRST-NOTICE.       
REARCH     MOVE  SPACES                   TO S-INSTLMNT-STRT-DATE.      
REARCH     MOVE  SPACES                   TO S-NEXT-BILL-DATE.          
REARCH*    MOVE  SPACES                   TO S-NEXT-DUE-DATE.                   
REARCH     MOVE  SPACES                   TO S-IMMED-DUE-DATE.          
REARCH     MOVE  SPACES                   TO S-DATE-FIRST-DUE.          
REARCH     MOVE  SPACES                   TO S-DATE-SECOND-DUE.         
REARCH     MOVE  SPACES                   TO S-CURRENT-BILL-DUE.        
REARCH     MOVE  SPACES                   TO S-ORIG-IMMED-DUE.          
REARCH     MOVE  SPACES                   TO S-CUR-IMMED-DUE.           
REARCH     MOVE  SPACES                   TO S-DT-FST-NTCE-OLD.         
REARCH     MOVE  SPACES                   TO S-CUT-DATE.                
REARCH     MOVE  0                        TO S-FINAL-INSTLMNT-AMT.      
REARCH     MOVE  NO-COMMENTS              TO RS-COMMENTS.               
REARCH*                                                                 06210000
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 13610000
      ******************************************************************13611000
      * INCLUDE COPYBOOK FOR DETERMINING MAX-DEPOSIT ESTIMATES         *13612000
      ******************************************************************13613000
TP8452*                                                                 13614000
TP8452     EXEC SQL                                                     13615000
TP8452        INCLUDE CPD00308                                          13616000
TP8452     END-EXEC.                                                    13617000
TP8452*                                                                 13618000
      *                                                                 13620000
      ******************************************************************15360000
      * 2400-GET-DEPOSIT-INFO.                                         *15370000
      *     -- THIS MODULE OPENS THE DEPOSIT CURSOR, FETCHES THE       *15380000
      *        DEPOSIT RECORD DETAILS, SENDS THEM BACK TO THE DESKTOP  *15390000
      *        ENVIRONMENT, AND THEN CLOSES THE CURSOR.                *15400000
      *        THE BILL-CYCLE FOR THE ACCOUNT IS ALSO OBTAINED HERE    *15410000
      ******************************************************************15420000
       2400-GET-DEPOSIT-INFO.                                           
      *                                                                 15440000
                                                                        
           IF AT-CODE-ACCT-STAT = PENDING-ACCOUNT                       
              CONTINUE                                                  
           ELSE                                                         
P00705        IF WS-CURRENT-DATE-CWS308 = LOW-VALUES  OR                
P00705                                    HIGH-VALUES OR                
P00705                                    SPACES                        
P00705           PERFORM 7025-SELECT-BILL-DATE                          
P00705              THRU 7025-SELECT-BILL-DATE-EXIT                     
P00705           MOVE WS-DATE-CWS00308         TO WS-CURRENT-DATE-CWS308
P00705        END-IF                                                    
              MOVE WS-CURRENT-DATE-CWS308      TO WS-CURRENT-DATE       
TP8996        MOVE DELINQUENCY-CODE            TO C8-DELINQ-CD          
              PERFORM 2650-GET-DELINQUENT-CONST    THRU 2650-EXIT       
TP8996        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
TP8996           MOVE C8-DELINQ-VALUE       TO RS-DELINQUENCY-VALUE     
TP8996        ELSE                                                      
TP8996           MOVE 0                     TO RS-DELINQUENCY-VALUE     
TP8996        END-IF                                                    
TP8996        MOVE WS-AMT-DEPDNPLIM         TO C8-DELINQ-CD             
TP8996        PERFORM 2650-GET-DELINQUENT-CONST    THRU 2650-EXIT       
TP8996        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
TP8996           MOVE C8-DELINQ-VALUE       TO RS-DEP-DNP-LIMIT         
TP8996        ELSE                                                      
TP8996           MOVE 0                     TO RS-DEP-DNP-LIMIT         
TP8996        END-IF                                                    
TP8767        PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT 
TP8767        IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                      
T34822           MOVE BN-DATE-EXTRACT      TO WS-NEXT-BILL-DATE         
TP8767           MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE             
TP8767           MOVE WS-FORMAT-YEAR       TO USA-YEAR                  
TP8767           MOVE WS-FORMAT-MONTH      TO USA-MONTH                 
TP8767           MOVE WS-FORMAT-DAY        TO USA-DAY                   
TP8767           MOVE USA-DATE-FORMAT      TO RS-NEXT-BILL-DATE         
TP8767           MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE           
TP8767           MOVE BN-REVENUE-MONTH     TO AT-REV-MTH-LST-NRML       
T11039           IF WS-HOLD-ACCT-REV-MTH EQUAL BN-REVENUE-MONTH         
T11039            OR WS-HOLD-ACCT-REV-MTH EQUAL ZEROES                  
T11039              MOVE 'Y'               TO RS-NOT-CURR-MTH-FLAG      
T11039           ELSE                                                   
T11039              MOVE 'N'               TO RS-NOT-CURR-MTH-FLAG      
T11039           END-IF                                                 
TP8767        ELSE                                                      
TP8767           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
TP8767           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
TP8767           MOVE '5900'                TO ACTIVE-PARAGRAPH         
TP8767           MOVE 'SELECT'              TO ABEND-FUNCTION           
TP8767           MOVE SPACES                TO ABEND-SQL-PREDICATES     
TP8767                                         ABEND-TABLES             
TP8767           MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                  
T15605           MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-1          
T15605           MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-2          
T15605           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3          
T15605           MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-1        
T15605           MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-2        
TP8767           MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3        
TP8767           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
TP8767        END-IF                                                    
                                                                        
TP8767        PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT 
TP8767        IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                      
TP8767           MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE             
TP8767           MOVE WS-FORMAT-YEAR       TO USA-YEAR                  
TP8767           MOVE WS-FORMAT-MONTH      TO USA-MONTH                 
TP8767           MOVE WS-FORMAT-DAY        TO USA-DAY                   
TP8767           MOVE USA-DATE-FORMAT      TO RS-2ND-NEXT-BILL-DATE     
TP8767        ELSE                                                      
TP8767           MOVE SPACES               TO RS-2ND-NEXT-BILL-DATE     
TP8767        END-IF                                                    
              PERFORM 2566-FORMAT-MAX-DATE         THRU 2566-EXIT       
              PERFORM 2590-GET-LAST-BILL-DATE      THRU 2590-EXIT       
              PERFORM 7100-SELECT-MAX-CERT-NO      THRU 7100-EXIT       
           END-IF.                                                      
T34822     IF SEB-DATABASE AND AT-CREDIT-GROUP = 'B'                    
T34822        IF WS-NEXT-BILL-DATE > SPACES                             
T34822           PERFORM 7160-SELECT-CURR-CHG-DUE-DT  THRU 7160-EXIT    
T34822           MOVE  WS-CURR-CHG-DUE-DT  TO RS-NEXT-DUE-DATE          
T34822        ELSE                                                      
T34822           MOVE  SPACES              TO RS-NEXT-DUE-DATE          
T34822        END-IF                                                    
T34822     END-IF.                                                      
T26296     IF CSR-DATABASE                                              
T26296        PERFORM 5180-CHK-BILLED-DEP-EXISTS   THRU 5180-EXIT       
T26296     ELSE                                                         
T26296        MOVE 'N'                             TO WS-DEP-EXISTS-FLAG
T26296     END-IF.                                                      
      *                                                                 15570000
           PERFORM 5050-OPEN-DEPOSITS-CURSOR       THRU 5050-EXIT.      
           PERFORM 5150-FETCH-DEPOSITS-CURSOR      THRU 5150-EXIT       
              UNTIL SQLCODE = NOT-FOUND.                                
      *                                                                 15610000
           PERFORM 7050-CLOSE-DEPOSITS-CURSOR      THRU 7050-EXIT.      
      *                                                                 15630000
           PERFORM 7100-SELECT-MAX-CERT-NO         THRU 7100-EXIT.      
      *                                                                 15650000
           IF DETAILS-EXIST = 'N'                                       
               PERFORM 8050-RETURNS-NOT-FOUND      THRU 8050-EXIT       
REARCH         PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT      
               PERFORM 8100-SEND-RESULT            THRU 8100-EXIT
           END-IF.      
      *                                                                 15680000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15710000
      *                                                                 15720000
      ******************************************************************15720100
      * 2450-FIND-DEPOSIT-BILLED                                       *15720200
      *     -- FIND IF THE DEPOSIT WAS BILLED.                         *15720300
      ******************************************************************15720700
       2450-FIND-DEPOSIT-BILLED.                                        
TP9171     IF LAST-NRML-BILL-NO-IND >= 0 AND AT-LAST-NRML-BILL-NO > 0   
TP9171        PERFORM 2610-LAST-NRML-BILL-DATE   THRU 2610-EXIT         
TP9171        IF BI-DATE-BILLED >= WS-DATE-PYMT-START                   
TP9171            AND DATE-BILLED-IND >= 0                              
TP9171              MOVE 'Y'                    TO RS-BILLED-FLAG       
TP9171        ELSE                                                      
TP9171              MOVE 'N'                    TO RS-BILLED-FLAG       
TP9171        END-IF                                                    
TP9171     ELSE                                                         
TP9171        MOVE 'N'                          TO RS-BILLED-FLAG       
TP9171     END-IF.                                                      
TP9171                                                                  
TP9171 2450-EXIT.                                                       
TP9171     EXIT.                                                        
      ******************************************************************15730000
      * 2500-GET-TRAN-BALANCE.                                         *15740000
      *       -- THIS MODULE GETS THE AMT TRAN BALANCE FOR A DEPOSIT   *15750000
      *          RECORD. *                                              15760000
      ******************************************************************15770000
       2500-GET-TRAN-BALANCE.                                           
      *                                                                 15790000
           EXEC SQL                                                     
               SELECT AMT_TRAN_BALANCE,                                 
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90                                     
                 INTO :AC-AMT-TRAN-BALANCE,                             
                      :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90                                 
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 80                            
                  AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15880000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 15910000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               MOVE 0                          TO AC-AMT-TRAN-BALANCE   
               MOVE 0                          TO AC-AMT-AR-DAY-00      
               MOVE 0                          TO AC-AMT-AR-DAY-30      
               MOVE 0                          TO AC-AMT-AR-DAY-60      
               MOVE 0                          TO AC-AMT-AR-DAY-90      
               MOVE SUCCESSFUL-CALL            TO SQLCODE               
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
               MOVE 'CSS_AR_CNTL'              TO TABLE-1               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2       
CBSI           MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
CBSI           MOVE DO-DEPOSIT-CERT-NO         TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 16070000
      *                                                                 16080000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16110000
      ******************************************************************16120000
PCR263* 2510-GET-DNP-DATE.                                         *    16130000
PCR263*       -- THIS MODULE GETS DNP DATE  FROM CSS_CRED_COLL *        16140000
      *          FOR IMMEDIATE BILLING TYPE RECORDS.                    16150000
      ******************************************************************16160000
PCR263 2510-GET-DNP-DATE.                                               
      *                                                                 16180000
           EXEC SQL                                                     
PCR263         SELECT CIS.CHAR2$DATE(DATE_CREDIT_ACTION,'USA')                  
PCR263           INTO :RS-IMME-CUT-DATE :NULL-CUT-DATE                   
                 FROM CSS_CRED_COLL                                     
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           
                  AND CODE_NOTICE_TYPE  = 'I'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     16190000
MFA-TR*        SELECT CHAR(DATE_CREDIT_ACTION,USA)                      16200000
MFA-TR*          INTO :RS-IMME-CUT-DATE:NULL-CUT-DATE                   16210000
MFA-TR*          FROM CSS_CRED_COLL                                     16220000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                16230000
MFA-TR*           AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           16240000
MFA-TR*           AND CODE_NOTICE_TYPE  = 'I'                           16250000
MFA-TR*    END-EXEC.                                                    16260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16270000
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 16300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR -305            
               MOVE SPACES                    TO RS-IMME-CUT-DATE       
               MOVE SUCCESSFUL-CALL           TO SQLCODE                
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '2510'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE SPACES                    TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
               MOVE 'CSS_CRED_COLL'           TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T15605         MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T15605         MOVE DO-DEPOSIT-CERT-NO        TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
      *                                                                 16460000
      *                                                                 16470000
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16500000
PCR263******************************************************************16510000
PCR263* 2520-GET-DUE-DATE.                                         *    16520000
PCR263*       -- THIS MODULE GETS DUE DATE  FROM CSS_CRED_COLL *        16530000
PCR263*          FOR IMMEDIATE BILLING TYPE RECORDS.                    16540000
PCR263******************************************************************16550000
PCR263 2520-GET-DUE-DATE.                                               
PCR263*                                                                 16570000
PCR263     EXEC SQL                                                     
PCR263         SELECT CIS.CHAR2$DATE(DATE_NOTICE_DUE,'USA')                     
PCR263           INTO :RS-IMME-DUE-DATE :NULL-DUE-DATE                   
PCR263           FROM CSS_CRED_COLL                                     
PCR263          WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
PCR263            AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           
PCR263            AND CODE_NOTICE_TYPE  = 'O'                           
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     16580000
MFA-TR*        SELECT CHAR(DATE_NOTICE_DUE,USA)                         16590000
MFA-TR*          INTO :RS-IMME-DUE-DATE:NULL-DUE-DATE                   16600000
MFA-TR*          FROM CSS_CRED_COLL                                     16610000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                16620000
MFA-TR*           AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           16630000
MFA-TR*           AND CODE_NOTICE_TYPE  = 'O'                           16640000
MFA-TR*    END-EXEC.                                                    16650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263*                                                                 16660000
PCR263     MOVE SQLCODE                       TO RS-RETURN-CODE.        
PCR263     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PCR263*                                                                 16690000
PCR263     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR263         NEXT SENTENCE                                            
PCR263     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR -305            
PCR263         MOVE SPACES                    TO RS-IMME-DUE-DATE       
PCR263         MOVE SUCCESSFUL-CALL           TO SQLCODE                
PCR263     ELSE                                                         
PCR263         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR263         MOVE '2520'                    TO ACTIVE-PARAGRAPH       
PCR263         MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE SPACES                    TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
PCR263         MOVE 'CSS_CRED_COLL'           TO TABLE-1                
PCR263         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T15605         MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2        
PCR263         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T15605         MOVE DO-DEPOSIT-CERT-NO        TO HOSTVAR-ELEMENT-2      
PCR263         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR263         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR263     END-IF
           END-IF.                                                      
PCR263*                                                                 16850000
PCR263*                                                                 16860000
PCR263 2520-EXIT.                                                       
PCR263     EXIT.                                                        
      *                                                                 16890000
      *                                                                 16900000
      ******************************************************************16910000
      * 2550-GET-OLD-BILL-DATE                                         *16920000
      *       -- THIS MODULE GETS THE OLD BILL DATE GIVEN BY THE       *16930000
      *          DATE THE CERTIFICATE WAS ISSUED ON THE DEPOSIT RECORD.*16940000
      ******************************************************************16950000
       2550-GET-OLD-BILL-DATE.                                          
      *                                                                 16970000
           IF REBILLED-DEP-DATE-IND = NULL-VALUE                        
               MOVE DO-DATE-TRAN          TO BILL-DATE-SEARCH           
               MOVE SPACES                TO DR-REBILLED-DEP-DATE       
           ELSE                                                         
               MOVE DR-REBILLED-DEP-DATE  TO BILL-DATE-SEARCH           
           END-IF.                                                      
      *                                                                 17040000
           EXEC SQL                                                     
               SELECT CIS.CHAR2$DATE(MIN(DATE_EXTRACT), 'USA')                  
                 INTO :RS-OLD-BILL-DATE :NEXT-BILL-DATE-IND              
                 FROM CSS_BILL_WINDOW                                   
                WHERE BILL_CYCLE    = :AT-BILL-CYCLE                    
                  AND DATE_EXTRACT  > IIF(TRY_CONVERT(DATE, 
                                                      :BILL-DATE-SEARCH
              ) IS NULL OR (PATINDEX('%.%', :BILL-DATE-SEARCH
              ) <> 0) OR (LEN(:BILL-DATE-SEARCH) <> 10), CIS.CHAR2DATE(
                                                      :BILL-DATE-SEARCH
              ), CONVERT(DATE, :BILL-DATE-SEARCH) )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17050000
MFA-TR*        SELECT CHAR(MIN(DATE_EXTRACT), USA)                      17060000
MFA-TR*          INTO :RS-OLD-BILL-DATE:NEXT-BILL-DATE-IND              17070000
MFA-TR*          FROM CSS_BILL_WINDOW                                   17080000
MFA-TR*         WHERE BILL_CYCLE    = :AT-BILL-CYCLE                    17090000
MFA-TR*           AND DATE_EXTRACT  > :BILL-DATE-SEARCH                 17100000
MFA-TR*    END-EXEC.                                                    17110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17120000
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 17150000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               IF NEXT-BILL-DATE-IND = NULL-VALUE                       
                   MOVE SPACES                TO RS-OLD-BILL-DATE       
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '2550'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE SPACES                    TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
               MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                
               MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-1        
T15605         MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-2        
T15605         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
T15605         MOVE BILL-DATE-SEARCH          TO HOSTVAR-ELEMENT-1      
T15605         MOVE AT-BILL-CYCLE             TO HOSTVAR-ELEMENT-2      
T15605         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 17310000
      *                                                                 17320000
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17350000
      *                                                                 17360000
      ******************************************************************17370000
      * 2565-FORMAT-MIN-DATE                                           *17380000
      *       -- THIS MODULE FORMATS THE MIN DATE AS SEARCH CRITERIA   *17390000
      *          FOR FINDING THE 2ND BILL DATE FOR A DEPOSIT RECORD.   *17400000
      ******************************************************************17410000
       2565-FORMAT-MIN-DATE.                                            
      *                                                                 17430000
           MOVE '/' TO WS-FILLER-1.                                     
           MOVE '/' TO WS-FILLER-2.                                     
           STRING WS-CURRENT-CENTURY DELIMITED BY SIZE                  
                  WS-CURRENT-YEAR    DELIMITED BY SIZE                  
                INTO WS-DATE-CCYY.                                      
           MOVE '01'                      TO WS-DATE-DD.                
           IF WS-FREQ-CODE = 'M'                                        
               IF COMPARE-DATE(1:2) = WS-DATE-MM-X                      
                   ADD 1                  TO WS-DATE-MM                 
                   IF WS-DATE-MM > 12                                   
                       MOVE 1             TO WS-DATE-MM                 
                       ADD 1              TO WS-DATE-CCYY               
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               IF WS-START-MONTH < WS-DATE-MM                           
                   ADD 1                  TO WS-DATE-CCYY               
                   MOVE WS-START-MONTH    TO WS-DATE-MM                 
               ELSE                                                     
                   MOVE WS-START-MONTH    TO WS-DATE-MM                 
               END-IF                                                   
T19396         IF WS-DATE-MM = 0                                        
T19396             MOVE 1                 TO WS-DATE-MM                 
T19396         END-IF                                                   
           END-IF                                                       
           MOVE WS-HOLD-DATE              TO WS-MIN-DATE.               
      *                                                                 17670000
      *                                                                 17680000
       2565-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17710000
      *                                                                 17720000
      ******************************************************************17730000
      * 2566-FORMAT-MAX-DATE                                           *17740000
      *       -- THIS MODULE FORMATS THE MAX DATE AS SEARCH CRITERIA   *17750000
      *          FOR FINDING THE LAST BILL DATE FOR A DEPOSIT RECORD.  *17760000
      ******************************************************************17770000
       2566-FORMAT-MAX-DATE.                                            
      *                                                                 17790000
           MOVE RS-NEXT-BILL-DATE         TO WS-HOLD-DATE.              
           MOVE '/' TO WS-FILLER-1.                                     
           MOVE '/' TO WS-FILLER-2.                                     
           STRING WS-CURRENT-CENTURY DELIMITED BY SIZE                  
                  WS-CURRENT-YEAR    DELIMITED BY SIZE                  
                INTO WS-DATE-CCYY.                                      
           IF WS-FREQ-CODE = 'M'                                        
               SUBTRACT 1                 FROM WS-DATE-MM               
               IF WS-DATE-MM = 0                                        
                  MOVE '12'               TO WS-DATE-MM                 
               END-IF                                                   
               MOVE '01'                  TO WS-DATE-DD                 
           ELSE                                                         
               MOVE '01'                  TO WS-DATE-DD                 
               MOVE '12'                  TO WS-DATE-MM                 
           END-IF.                                                      
           MOVE WS-HOLD-DATE              TO WS-MAX-DATE.               
      *                                                                 17970000
       2566-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18000000
      *                                                                 18010000
      ******************************************************************18020000
      * 2570-GET-2ND-BILL-DATE                                         *18030000
      *       -- THIS MODULE GETS THE 2ND BILL DATE FROM THE DATE      *18040000
      *          DATE THE CERTIFICATE WAS ISSUED ON THE DEPOSIT RECORD.*18050000
      ******************************************************************18060000
       2570-GET-2ND-BILL-DATE.                                          
      *                                                                 18080000
           MOVE RS-OLD-BILL-DATE          TO WS-HOLD-DATE               
                                             COMPARE-DATE.              
           PERFORM 2565-FORMAT-MIN-DATE        THRU 2565-EXIT.          
      *                                                                 18120000
           EXEC SQL                                                     
               SELECT CIS.CHAR2$DATE(MIN(DATE_EXTRACT), 'USA')                  
                 INTO :RS-2ND-OLD-BILL-DATE :NEXT-BILL-DATE-IND          
                 FROM CSS_BILL_WINDOW                                   
                WHERE BILL_CYCLE    = :AT-BILL-CYCLE                    
                  AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, :WS-MIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE
              ) <> 0) OR (LEN(:WS-MIN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MIN-DATE
              ), CONVERT(DATE, :WS-MIN-DATE) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18130000
MFA-TR*        SELECT CHAR(MIN(DATE_EXTRACT), USA)                      18140000
MFA-TR*          INTO :RS-2ND-OLD-BILL-DATE:NEXT-BILL-DATE-IND          18150000
MFA-TR*          FROM CSS_BILL_WINDOW                                   18160000
MFA-TR*         WHERE BILL_CYCLE    = :AT-BILL-CYCLE                    18170000
MFA-TR*           AND DATE_EXTRACT >= :WS-MIN-DATE                      18180000
MFA-TR*    END-EXEC.                                                    18190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18200000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 18230000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               IF NEXT-BILL-DATE-IND = NULL-VALUE OR                    
                  NEXT-BILL-DATE-IND < 0                                
                   MOVE SPACES                 TO RS-2ND-OLD-BILL-DATE  
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2570'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
               MOVE 'CSS_BILL_WINDOW'          TO TABLE-1               
               MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-1       
T15605         MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-2       
T15605         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3       
T15605         MOVE WS-MIN-DATE                TO HOSTVAR-ELEMENT-1     
T15605         MOVE AT-BILL-CYCLE              TO HOSTVAR-ELEMENT-2     
T15605         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18400000
      *                                                                 18410000
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18440000
      *                                                                 18450000
      ******************************************************************18460000
      * 2590-GET-LAST-BILL-DATE                                        *18470000
      *       -- THIS MODULE GETS THE LAST BILL DATE FROM THE CURRENT  *18480000
      *          DATE.                                                 *18490000
      ******************************************************************18500000
       2590-GET-LAST-BILL-DATE.                                         
      *                                                                 18520000
           IF WS-FREQ-CODE = 'M'                                        
               EXEC SQL                                                 
                   SELECT CIS.CHAR2$DATE(MIN(DATE_EXTRACT), 'USA')              
                     INTO :RS-LAST-BILL-DATE :NEXT-BILL-DATE-IND         
                     FROM CSS_BILL_WINDOW                               
                    WHERE BILL_CYCLE   = :AT-BILL-CYCLE                 
                      AND DATE_EXTRACT > IIF(TRY_CONVERT(DATE, 
                                                           :WS-MAX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE
              ) <> 0) OR (LEN(:WS-MAX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-DATE
              ), CONVERT(DATE, :WS-MAX-DATE) )                   
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 18540000
MFA-TR*            SELECT CHAR(MIN(DATE_EXTRACT), USA)                  18550000
MFA-TR*              INTO :RS-LAST-BILL-DATE:NEXT-BILL-DATE-IND         18560000
MFA-TR*              FROM CSS_BILL_WINDOW                               18570000
MFA-TR*             WHERE BILL_CYCLE   = :AT-BILL-CYCLE                 18580000
MFA-TR*               AND DATE_EXTRACT > :WS-MAX-DATE                   18590000
MFA-TR*        END-EXEC                                                 18600000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           ELSE                                                         
               EXEC SQL                                                 
                   SELECT CIS.CHAR2$DATE(MIN(DATE_EXTRACT), 'USA')              
                     INTO :RS-LAST-BILL-DATE :NEXT-BILL-DATE-IND         
                     FROM CSS_BILL_WINDOW                               
                    WHERE BILL_CYCLE    = :AT-BILL-CYCLE                
                      AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-MAX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE
              ) <> 0) OR (LEN(:WS-MAX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-DATE
              ), CONVERT(DATE, :WS-MAX-DATE) )                  
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 18620000
MFA-TR*            SELECT CHAR(MIN(DATE_EXTRACT), USA)                  18630000
MFA-TR*              INTO :RS-LAST-BILL-DATE:NEXT-BILL-DATE-IND         18640000
MFA-TR*              FROM CSS_BILL_WINDOW                               18650000
MFA-TR*             WHERE BILL_CYCLE    = :AT-BILL-CYCLE                18660000
MFA-TR*               AND DATE_EXTRACT >= :WS-MAX-DATE                  18670000
MFA-TR*        END-EXEC                                                 18680000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           END-IF.                                                      
      *                                                                 18700000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 18730000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
            WS-ACTIVE-RETURN-CODE = NOT-FOUND                           
               IF NEXT-BILL-DATE-IND = NULL-VALUE OR                    
                   NEXT-BILL-DATE-IND < 0                               
                   MOVE SPACES                 TO RS-LAST-BILL-DATE     
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2590'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
               MOVE 'CSS_BILL_WINDOW'          TO TABLE-1               
               MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-1       
T15605         MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-2       
T15605         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3       
T15605         MOVE WS-MAX-DATE                TO HOSTVAR-ELEMENT-1     
T15605         MOVE AT-BILL-CYCLE              TO HOSTVAR-ELEMENT-2     
CBSI           MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18900000
      *                                                                 18910000
       2590-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18940000
      *                                                                 18950000
      ******************************************************************18960000
      * 2600-GET-ACCT-INFO.                                            *18970000
      *    -- THIS MODULE GETS INFORMATION ON THE ACCOUNT THAT HOLDS   *18980000
      *       THE DEPOSIT RECORDS.                                     *18990000
      ******************************************************************19000000
       2600-GET-ACCT-INFO.                                              
      *                                                                 19020000
           EXEC SQL                                                     
               SELECT BILL_CYCLE      ,                                 
                      CREDIT_GROUP    ,                                 
                      CODE_BILL_FREQ  ,                                 
                      MST_SUB_ACCT_IND,                                 
P136                  CODE_DISC_OK    ,                                 
                      CODE_ACCT_STAT  ,                                 
TP8767                REV_MTH_LST_NRML,                                 
TP8767                LAST_NRML_BILL_NO,                                
T21202                REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS  ,                      
T23501                COMPANY_NO                                        
                 INTO :AT-BILL-CYCLE      ,                             
                      :AT-CREDIT-GROUP    ,                             
                      :AT-CODE-BILL-FREQ  ,                             
                      :AT-MST-SUB-ACCT-IND,                             
P136                  :AT-CODE-DISC-OK    ,                             
                      :AT-CODE-ACCT-STAT  ,                             
TP8767                :AT-REV-MTH-LST-NRML,                             
                      :AT-LAST-NRML-BILL-NO :LAST-NRML-BILL-NO-IND,      
T21202                :AT-LAST-UPDATE-TS,                               
T23501                :AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     19030000
MFA-TR*        SELECT BILL_CYCLE      ,                                 19040000
MFA-TR*               CREDIT_GROUP    ,                                 19050000
MFA-TR*               CODE_BILL_FREQ  ,                                 19060000
MFA-TR*               MST_SUB_ACCT_IND,                                 19070000
MFA-TR*               CODE_DISC_OK    ,                                 19080000
MFA-TR*               CODE_ACCT_STAT  ,                                 19090000
MFA-TR*               REV_MTH_LST_NRML,                                 19092000
MFA-TR*               LAST_NRML_BILL_NO,                                19093000
MFA-TR*               LAST_UPDATE_TS  ,                                         
MFA-TR*               COMPANY_NO                                                
MFA-TR*          INTO :AT-BILL-CYCLE      ,                             19100000
MFA-TR*               :AT-CREDIT-GROUP    ,                             19110000
MFA-TR*               :AT-CODE-BILL-FREQ  ,                             19120000
MFA-TR*               :AT-MST-SUB-ACCT-IND,                             19130000
MFA-TR*               :AT-CODE-DISC-OK    ,                             19140000
MFA-TR*               :AT-CODE-ACCT-STAT  ,                             19150000
MFA-TR*               :AT-REV-MTH-LST-NRML,                             19152000
MFA-TR*               :AT-LAST-NRML-BILL-NO:LAST-NRML-BILL-NO-IND,      19153000
MFA-TR*               :AT-LAST-UPDATE-TS,                                       
MFA-TR*               :AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                       19160000
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       19170000
MFA-TR*    END-EXEC.                                                    19180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19190000
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 19220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AT-CREDIT-GROUP            TO DELINQUENCY-CD,       
TP9642                                            RS-CREDIT-GROUP       
               MOVE AT-CODE-BILL-FREQ          TO WS-BILL-FREQ          
T19396         IF AT-CODE-BILL-FREQ = SPACES                            
T19396             MOVE ZEROES TO WS-START-MONTH                        
T19396         END-IF                                                   
                                                                        
               MOVE AT-MST-SUB-ACCT-IND        TO RS-MST-SUB-ACCT-IND   
               IF AT-CODE-DISC-OK = SPACES                              
P136             MOVE LOW-VALUES                 TO RS-CODE-DISC-OK     
               ELSE                                                     
P136             MOVE AT-CODE-DISC-OK            TO RS-CODE-DISC-OK     
               END-IF                                                   
T11039         MOVE AT-REV-MTH-LST-NRML        TO WS-HOLD-ACCT-REV-MTH  
T21202         MOVE AT-LAST-UPDATE-TS          TO RS-AT-LAST-UPDATE-TS  
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 19400000
      *                                                                 19410000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19440000
      *                                                                 19450000
      *                                                                 19451000
      ******************************************************************19452000
      * 2610-LAST-NRML-BILL-DATE.                                      *19453000
      *    -- THIS MODULE GETS LAST NORMAL BILL DATE FOR THE ACCOUNT   *19454000
      ******************************************************************19456000
       2610-LAST-NRML-BILL-DATE.                                        
      *                                                                 19458000
           EXEC SQL                                                     
               SELECT DATE_BILLED                                       
                 INTO :BI-DATE-BILLED :DATE-BILLED-IND                   
                 FROM CSS_BILLING_HDR                                   
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                AND   BILL_NO    = :AT-LAST-NRML-BILL-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19461100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 19461400
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2610'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BILLING_HDR'          TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
T15605         MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2       
               MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
T15605         MOVE AT-LAST-NRML-BILL-NO       TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 19463100
      *                                                                 19463200
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19463500
      *                                                                 19463600
      ******************************************************************19464000
      * 2650-GET-DELINQUENT-CONST.                                     *19470000
      *       -- THIS MODULE GETS THE DELINQUENT CONSTANT FOR OBTAINING*19480000
      *          THE DUE DATE FOR A DEPOSIT BILL.                      *19490000
T23501*       -- IT ALSO RETRIEVES THE DELINQUENCY VALUE TO DETERMINE  *        
T23501*          THE CORRECT DATABASE (SEB OR SCEG).                   *        
      ******************************************************************19500000
       2650-GET-DELINQUENT-CONST.                                       
      *                                                                 19520000
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD = :C8-DELINQ-CD                         
T23501            AND COMPANY_NO = :AT-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19610000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 19640000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2650'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
T15605         MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1            
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
T15605         MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1          
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 19790000
      *                                                                 19800000
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19830000
      *                                                                 21010000
      ******************************************************************21020000
      * 5050-OPEN-DEPOSITS-CURSOR                                      *21030000
      *       -- THIS MODULE OPENS THE DEPOSITS CURSOR                 *21040000
      ******************************************************************21050000
       5050-OPEN-DEPOSITS-CURSOR.                                       
      *                                                                 21070000
           EXEC SQL                                                     
               OPEN DEPOSITS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21110000
           MOVE SQLCODE                      TO RS-RETURN-CODE.         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 21140000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '5050'                     TO ACTIVE-PARAGRAPH      
CBSI           MOVE 'OPEN'                     TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
CBSI           MOVE 'CSS_DEP_ON_HAND'          TO TABLE-1               
CBSI           MOVE 'CSS_DEP_REQ'              TO TABLE-2               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 21270000
      *                                                                 21280000
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21310000
      ******************************************************************21680000
      * 5150-FETCH-DEPOSITS-CURSOR                                     *21690000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF DEPOSIT RECORDS  *21700000
      *        FOR AN ACCOUNT                                          *21710000
      ******************************************************************21720000
       5150-FETCH-DEPOSITS-CURSOR.                                      
                                                                        
REARCH     INITIALIZE DO-COMMENTS.                                      
           EXEC SQL                                                     
               FETCH DEPOSITS                                           
                  INTO :DO-DEP-ACTION-CODE                        ,     
                       :DO-DEPOSIT-STATUS-CD                      ,     
                       :DO-DATE-TRAN :DATE-TRAN-IND                ,     
                       :DO-SERVICE-TYPE-CD                        ,     
                       :DO-DEPOSIT-CERT-NO                        ,     
                       :DO-AMT-DEPOSIT                            ,     
                       :DO-COMMENTS                               ,     
                       :DO-CODE-DEP-TYPE                          ,     
                       :DR-NO-SCHED-PYMTS                         ,     
                       :DR-AMT-MO-PYMT                            ,     
                       :DR-DEP-BILL-OPTION-CD                     ,     
                       :DO-USER-ID-UPDT-BY                        ,     
                       :DO-DATE-PYMT-START :DATE-PYMT-START-IND    ,     
                       :WS-DATE-PYMT-START :DATE-PYMT-START-IND-WS ,     
                       :DR-REBILLED-DEP-AMT                       ,     
                       :DR-REBILLED-DEP-DATE :REBILLED-DEP-DATE-IND,     
                       :DO-TRANSFER-AMT                           ,     
T28160                 :DO-CODE-REFUND-ELIG                       ,     
T26296                 :DO-AUTO-DEP-LTR-DT :NULL-AUTODEP-LTR-DT    ,     
T26296                 :DO-AUTO-DEP-LTR-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21940000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 21970000
           IF (SQLCODE EQUAL TO SUCCESSFUL-CALL)                        
T15291         PERFORM 5155-CONTINUE-PROCESS THRU 5155-EXIT             
           ELSE IF (SQLCODE = NOT-FOUND)                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5150'                TO ACTIVE-PARAGRAPH           
               MOVE 'FETCH'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
T15605         MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
T15605         MOVE 'CSS_DEP_REQ'         TO TABLE-2                    
T15605         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15605         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 22380000
      *                                                                 22390000
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22411000
       5155-CONTINUE-PROCESS.                                           
      *                                                                 22411200
               IF DATE-TRAN-IND = NULL-VALUE                            
                   MOVE SPACES            TO DO-DATE-TRAN               
               END-IF.                                                  
               MOVE VALUE-YES             TO DETAILS-EXIST.             
               IF DR-REBILLED-DEP-DATE = SPACE                          
                   MOVE NULL-VALUE        TO REBILLED-DEP-DATE-IND      
               END-IF.                                                  
               IF DATE-PYMT-START-IND = NULL-VALUE                      
                   MOVE SPACES            TO DO-DATE-PYMT-START         
               END-IF.                                                  
T26296         IF NULL-AUTODEP-LTR-DT = NULL-VALUE                      
T26296            MOVE SPACES             TO DO-AUTO-DEP-LTR-DT         
T26296         END-IF.                                                  
      *                                                                 22440000
               PERFORM 2500-GET-TRAN-BALANCE     THRU 2500-EXIT.        
PCR263         PERFORM 2510-GET-DNP-DATE         THRU 2510-EXIT.        
PCR263         PERFORM 2520-GET-DUE-DATE         THRU 2520-EXIT.        
               IF AT-CODE-ACCT-STAT = PENDING-ACCOUNT                   
                  MOVE SPACES                    TO RS-OLD-BILL-DATE    
                                                    RS-2ND-OLD-BILL-DATE
               ELSE                                                     
                  PERFORM 2550-GET-OLD-BILL-DATE THRU 2550-EXIT         
                  PERFORM 2570-GET-2ND-BILL-DATE THRU 2570-EXIT         
               END-IF.                                                  
                                                                        
      *        TPR 3771 - MOVE SUCCESSFUL CALL TO RETURN CODE.          22560000
               MOVE SUCCESSFUL-CALL              TO RS-RETURN-CODE.     
                                                                        
               PERFORM 8000-SET-RETURNS          THRU 8000-EXIT.        
REARCH         PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.       
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.        
T15291         MOVE  SUCCESSFUL-CALL     TO      SQLCODE.               
                                                                        
       5155-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
T26296******************************************************************        
T26296* 5180-CHK-BILLED-DEP-EXISTS                                              
T26296* TO CHECK IF BILLED DEPOSIT EXISTS ON THE ACCT.                          
T26296******************************************************************        
T26296 5180-CHK-BILLED-DEP-EXISTS.                                      
T26296     PERFORM 7125-GET-LAST-UPDATE-TS       THRU 7125-EXIT.        
T26296     MOVE 'NO-TOTAL-DEP'                   TO C8-DELINQ-CD.       
T26296     PERFORM 2650-GET-DELINQUENT-CONST     THRU 2650-EXIT.        
T26296     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T26296        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
T26296        MOVE '2650'                        TO ACTIVE-PARAGRAPH    
T26296        MOVE 'SELECT'                      TO ABEND-FUNCTION      
T26296        MOVE SPACES                        TO ABEND-SQL-PREDICATES
T26296                                              ABEND-TABLES        
T26296        MOVE 'CSS_DELINQUENCY'             TO TABLE-1             
T26296        MOVE 'DELINQ_CD'                   TO TABLE-ELEMENT-1     
T26296        MOVE 'COMPANY_NO'                  TO TABLE-ELEMENT-2     
T26296        MOVE C8-DELINQ-CD                  TO HOSTVAR-ELEMENT-1   
T26296        MOVE AT-COMPANY-NO                 TO HOSTVAR-ELEMENT-2   
T26296        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
T26296        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
T26296     END-IF.                                                      
T26296     MOVE C8-DELINQ-VALUE                  TO WS-DELINQ-TOTAL-DEP.
T26296* DELINQ VALUE FOR DEP-NOTIFY-LETTER                                      
T26296     MOVE 'DEP-NOTIFY-LETTER'              TO C8-DELINQ-CD.       
T26296     PERFORM 2650-GET-DELINQUENT-CONST     THRU 2650-EXIT.        
T26296     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T26296        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
T26296        MOVE '2650'                        TO ACTIVE-PARAGRAPH    
T26296        MOVE 'SELECT'                      TO ABEND-FUNCTION      
T26296        MOVE SPACES                        TO ABEND-SQL-PREDICATES
T26296                                              ABEND-TABLES        
T26296        MOVE 'CSS_DELINQUENCY'             TO TABLE-1             
T26296        MOVE 'DELINQ_CD'                   TO TABLE-ELEMENT-1     
T26296        MOVE 'COMPANY_NO'                  TO TABLE-ELEMENT-2     
T26296        MOVE C8-DELINQ-CD                  TO HOSTVAR-ELEMENT-1   
T26296        MOVE AT-COMPANY-NO                 TO HOSTVAR-ELEMENT-2   
T26296        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
T26296        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
T26296     END-IF.                                                      
T26296     MOVE C8-DELINQ-VALUE                  TO                     
T26296                                           RS-DELQ-DEP-NTFY-LTR.  
T26296     PERFORM 7150-GET-DEPOSIT-CNT          THRU 7150-EXIT.        
T26296     IF WS-TOTAL-DEP-CNT >= WS-DELINQ-TOTAL-DEP                   
T26296        MOVE 'Y'                           TO WS-DEP-EXISTS-FLAG  
T26296     ELSE                                                         
T26296        PERFORM 7155-DEPTOT-FROM-TRNHST    THRU 7155-EXIT         
T26296        ADD WS-DEPTOT-TRNHST               TO WS-TOTAL-DEP-CNT    
T26296        IF WS-TOTAL-DEP-CNT >= WS-DELINQ-TOTAL-DEP                
T26296           MOVE 'Y'                        TO WS-DEP-EXISTS-FLAG  
T26296        ELSE                                                      
T26296           MOVE 'N'                        TO WS-DEP-EXISTS-FLAG  
T26296        END-IF                                                    
T26296     END-IF.                                                      
T26296 5180-EXIT.                                                       
T26296      EXIT.                                                       
T26296*                                                                         
      ******************************************************************22760000
      * 7050-CLOSE-DEPOSITS-CURSOR                                     *22770000
      *       -- THIS MODULE CLOSES THE DEPOSITS CURSOR                *22780000
      ******************************************************************22790000
       7050-CLOSE-DEPOSITS-CURSOR.                                      
      *                                                                 22810000
           EXEC SQL                                                     
               CLOSE DEPOSITS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22850000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 22880000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
CBSI           MOVE 'CLOSE'                    TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
CBSI           MOVE 'CSS_DEP_ON_HAND'          TO TABLE-1               
CBSI           MOVE 'CSS_DEP_REQ'              TO TABLE-2               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 23020000
      *                                                                 23030000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23060000
      *                                                                 23070000
      ******************************************************************23080000
      * 7100-SELECT-MAX-CERT-NO                                        *23090000
      *    -- SELECT THE MAX CERT NO FROM CSS_DEP_ON_HAND. IF          *23100000
      *       THERE ARE NO DEPOSITS THEN SET THE DEPOSIT CERT NO. TO 0 *23110000
      ******************************************************************23120000
       7100-SELECT-MAX-CERT-NO.                                         
      *                                                                 23140000
           EXEC SQL                                                     
               SELECT MAX(DEPOSIT_CERT_NO)                              
                 INTO :RS-DEPOSIT-CERT-NO :NULL-CERT-NO                  
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 23240000
           IF NULL-CERT-NO = NULL-VALUE                                 
               MOVE NOT-FOUND                 TO RS-RETURN-CODE         
               MOVE NO-COMMENTS               TO RS-COMMENTS            
               MOVE 1                         TO RS-DEPOSIT-CERT-NO     
           ELSE IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
      *        MOVE NOT-FOUND                 TO RS-RETURN-CODE         23300000
      *        MOVE NO-COMMENTS               TO RS-COMMENTS            23310000
               ADD 1                          TO RS-DEPOSIT-CERT-NO     
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE '7100'                    TO ACTIVE-PARAGRAPH       
CBSI           MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE SPACES                    TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
               MOVE 'CSS_DEP_ON_HAND'         TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 23440000
       7100-EXIT.                                                       
      *                                                                 23460000
T26296******************************************************************19464000
T26296* 7125-GET-LAST-UPDATE-TS.                                       *19470000
T26296* LAST_UPDATE_TS FROM BILLING_HDR                                *19470000
T26296******************************************************************19464000
T26296 7125-GET-LAST-UPDATE-TS.                                         
T26296*                                                                 19470000
T26296     EXEC SQL                                                     
T26296         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
T26296                CAST(LAST_UPDATE_TS AS DATE),                             
T26296                REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(LAST_UPDATE_TS AS TIME)), CAST(
           LAST_UPDATE_TS AS TIME)), 108), ':', '.')                           
T26296           INTO :BI-LAST-UPDATE-TS,                               
T26296                :WS-BILL-DATE,                                    
T26296                :WS-BILL-TIME                                     
T26296           FROM CSS_BILLING_HDR                                   
T26296          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
T26296            AND BILL_NO = (SELECT MAX(BI.BILL_NO)                 
T26296                             FROM CSS_BILLING_HDR BI              
T26296                            WHERE BI.ACCOUNT_NO = :WS-ACCOUNT-NO) 
T26296            AND DATE_BILLED IS NULL                               
T26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     19459000
MFA-TR*        SELECT LAST_UPDATE_TS,                                   19459100
MFA-TR*               DATE(LAST_UPDATE_TS),                             19459100
MFA-TR*               TIME(LAST_UPDATE_TS)                              19459100
MFA-TR*          INTO :BI-LAST-UPDATE-TS,                               19459900
MFA-TR*               :WS-BILL-DATE,                                    19459900
MFA-TR*               :WS-BILL-TIME                                     19459900
MFA-TR*          FROM CSS_BILLING_HDR                                   19460700
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       19460800
MFA-TR*           AND BILL_NO = (SELECT MAX(BI.BILL_NO)                 19460900
MFA-TR*                            FROM CSS_BILLING_HDR BI                      
MFA-TR*                           WHERE BI.ACCOUNT_NO = :WS-ACCOUNT-NO)         
MFA-TR*           AND DATE_BILLED IS NULL                                       
MFA-TR*    END-EXEC.                                                    19461000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26296*                                                                 19461100
T26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T26296         NEXT SENTENCE                                            
T26296     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
T26296         MOVE '1900-01-01'              TO WS-BILL-DATE           
T26296         MOVE '00.00.00'                TO WS-BILL-TIME           
T26296     ELSE                                                         
T26296         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T26296         MOVE '7125'                    TO ACTIVE-PARAGRAPH       
T26296         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T26296         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
T26296                                           ABEND-TABLES           
T26296         MOVE 'CSS_BILLING_HDR'         TO TABLE-1                
T26296         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T26296         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T26296         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T26296         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T26296     END-IF
           END-IF.                                                      
T26296 7125-EXIT.                                                       
T26296     EXIT.                                                        
T26296*                                                                 19820000
T26296*****************************************************************         
T26296* 7150-GET-DEPOSIT-CNT.                                         *         
T26296*  FIND NO OF DEPOSITS FROM DEP_ON_HAND.                        *         
T26296*****************************************************************         
T26296 7150-GET-DEPOSIT-CNT.                                            
T26296     EXEC SQL                                                     
T26296         SELECT COUNT(*)                                          
T26296           INTO :WS-TOTAL-DEP-CNT :DEP-COUNT-NULL-IND              
T26296           FROM CSS_DEP_ON_HAND                                   
T26296          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
T26296            AND DATE_TRAN  > IIF(TRY_CONVERT(DATE, :WS-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DATE
              ) <> 0) OR (LEN(:WS-BILL-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-BILL-DATE
              ), CONVERT(DATE, :WS-BILL-DATE) )                  
T26296     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOTAL-DEP-CNT:DEP-COUNT-NULL-IND                      
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*           AND DATE_TRAN  > DATE(:WS-BILL-DATE)                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26296*                                                                         
T26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T26296        IF DEP-COUNT-NULL-IND EQUAL NULL-VALUE                    
T26296             MOVE ZEROS                 TO DEP-COUNT-NULL-IND,    
T26296                                           WS-TOTAL-DEP-CNT       
T26296        END-IF                                                    
T26296     ELSE                                                         
T26296         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T26296         MOVE '7150'                    TO ACTIVE-PARAGRAPH       
T26296         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T26296         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
T26296                                           ABEND-TABLES           
T26296         MOVE 'CSS_DEP_ON_HAND'         TO TABLE-1                
T26296         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T26296         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T26296         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T26296         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T26296     END-IF.                                                      
T26296 7150-EXIT.                                                       
T26296     EXIT.                                                        
T26296*                                                                         
T26296*****************************************************************         
T26296* 7155-DEPTOT-FROM-TRNHST.                                      *         
T26296*  FIND IF THERE ARE ANY DEPOSITS ADDED USING AR TRANS HIST     *         
T26296*****************************************************************         
T26296 7155-DEPTOT-FROM-TRNHST.                                         
T26296     EXEC SQL                                                     
T26296         SELECT COUNT(*)                                          
T26296           INTO :WS-DEPTOT-TRNHST :DEP-COUNT-NULL-IND              
T26296           FROM CSS_AR_TRANS_HIST                                 
T26296          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
T26296            AND CAST(TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DATE
              ) <> 0) OR (LEN(:WS-BILL-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-BILL-DATE
              ), CONVERT(DATE, :WS-BILL-DATE) )     
T26296            AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) > CIS.CHAR2TIME(:WS-BILL-TIME)     
T26296            AND APPL_PROGRAM_ID IN ('PANEL141', 'PANEL141C',      
T26296                                    'PANEL164', 'PANEL125D',      
T26296                                    'PANEL181D', 'PCSSO67D')      
T26296     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-DEPTOT-TRNHST:DEP-COUNT-NULL-IND                      
MFA-TR*          FROM CSS_AR_TRANS_HIST                                         
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*           AND DATE(TRANS_HIST_SEQ_NO) = DATE(:WS-BILL-DATE)             
MFA-TR*           AND TIME(TRANS_HIST_SEQ_NO) > TIME(:WS-BILL-TIME)             
MFA-TR*           AND APPL_PROGRAM_ID IN ('PANEL141', 'PANEL141C',              
MFA-TR*                                   'PANEL164', 'PANEL125D',              
MFA-TR*                                   'PANEL181D', 'PCSSO67D')              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26296*                                                                         
T26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T26296        IF DEP-COUNT-NULL-IND = NULL-VALUE                        
T26296           MOVE ZEROS                   TO DEP-COUNT-NULL-IND,    
T26296                                           WS-DEPTOT-TRNHST       
T26296        END-IF                                                    
T26296     ELSE                                                         
T26296         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T26296         MOVE '7155'                    TO ACTIVE-PARAGRAPH       
T26296         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T26296         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
T26296                                           ABEND-TABLES           
T26296         MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                
T26296         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T26296         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T26296         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T26296         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T26296     END-IF.                                                      
T26296 7155-EXIT.                                                       
T26296     EXIT.                                                        
      *                                                                 23460100
T34822******************************************************************        
T34822* 7160-SELECT-CURR-CHG-DUE-DT                                             
T34822* TO GET CUREENT CHARGE DUE DATE.                                         
T34822******************************************************************        
T34822 7160-SELECT-CURR-CHG-DUE-DT.                                     
T34822*                                                                         
T34822     EXEC SQL                                                     
T34822         SELECT COALESCE(CIS.CHAR2$DATE(
           CURR_CHG_DUE_DT,'USA'),' ')             
T34822           INTO :WS-CURR-CHG-DUE-DT                               
T34822           FROM CSS_CRED_FORECAST                                 
T34822          WHERE BILL_DT    = IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEXT-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-BILL-DATE
              ) <> 0) OR (LEN(:WS-NEXT-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEXT-BILL-DATE
              ), CONVERT(DATE, :WS-NEXT-BILL-DATE) )                   
T34822            AND BILL_CYCLE = :AT-BILL-CYCLE                       
T34822            AND CRED_FORECAST_CD = 'A'                            
T34822     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(CHAR(CURR_CHG_DUE_DT,USA),' ')                     
MFA-TR*          INTO :WS-CURR-CHG-DUE-DT                                       
MFA-TR*          FROM CSS_CRED_FORECAST                                         
MFA-TR*         WHERE BILL_DT    = :WS-NEXT-BILL-DATE                           
MFA-TR*           AND BILL_CYCLE = :AT-BILL-CYCLE                               
MFA-TR*           AND CRED_FORECAST_CD = 'A'                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34822*                                                                         
T34822     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T34822     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T34822        CONTINUE                                                  
T34822     ELSE                                                         
T34822         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T34822         MOVE '7160'                    TO ACTIVE-PARAGRAPH       
T34822         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T34822         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
T34822                                           ABEND-TABLES           
T34822         MOVE 'CSS_CRED_FORECAST'       TO TABLE-1                
T34822         MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-1        
T34822         MOVE AT-BILL-CYCLE             TO HOSTVAR-ELEMENT-1      
T34822         MOVE 'BILL_DT '                TO TABLE-ELEMENT-2        
T34822         MOVE WS-NEXT-BILL-DATE         TO HOSTVAR-ELEMENT-2      
T34822         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T34822         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T34822     END-IF.                                                      
T34822 7160-EXIT.                                                       
T34822      EXIT.                                                       
T34822*                                                                         
      ***************************************************************** 23460200
      * 7990-SELECT-DEP-PAY-AMT                                       * 23460300
      *                                                               * 23460400
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 23460500
      ***************************************************************** 23460600
      *                                                                 23460700
      *                                                                 23460800
PCR482 7990-SELECT-DEP-PAY-AMT.                                         
      *                                                                 23461000
PCR482     EXEC SQL                                                     
PCR482        SELECT   SUM(DEP_PAY_AMT)                                 
PCR482          INTO   :WS-TOTAL-PAYMENTS :WS-TOTAL-PAYMENTS-NI          
PCR482          FROM   CSS_DEP_PAY_HST                                  
PCR482         WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
PCR482           AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23461800
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 23462000
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PCR482         IF WS-TOTAL-PAYMENTS-NI < 0                              
PCR482             MOVE ZEROES      TO WS-TOTAL-PAYMENTS                
PCR482         END-IF                                                   
PCR482     ELSE                                                         
CBSI           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
PCR482         MOVE '7990'                       TO ACTIVE-PARAGRAPH    
PCR482         MOVE 'SELECT'                     TO ABEND-FUNCTION      
CBSI           MOVE SPACES                       TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
PCR482         MOVE 'CSS_DEP_PAY_HST'            TO TABLE-1             
PCR482         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
T15605         MOVE 'DEPOSIT_CERT_NO'            TO TABLE-ELEMENT-2     
PCR482         MOVE DP-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
T15605         MOVE DP-DEPOSIT-CERT-NO           TO HOSTVAR-ELEMENT-2   
PCR482         PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT      
PCR482     END-IF.                                                      
      *                                                                 23463300
PCR482 7990-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                 23470000
      *                                                                 23471000
      ******************************************************************23480000
      * 8000 SET RETURNS                                               *23490000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*23500000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *23510000
      ******************************************************************23520000
       8000-SET-RETURNS.                                                
      *                                                                 23540000
TP8452     MOVE WS-NUMBER-OF-BILLS        TO RS-BILL-COUNT.             
TP8452     MOVE WS-MIN-DEPOSIT-AMT        TO RS-MIN-DEPOSIT-AMT.        
TP8452     MOVE WS-MAX-DEPOSIT-AMT        TO RS-MAX-DEPOSIT-AMT.        
TP8452     MOVE WS-USAGE-HISTORY-FLAG     TO RS-USAGE-HISTORY-FLAG.     
T26296     MOVE WS-DEP-EXISTS-FLAG        TO RS-DEP-EXISTS-FLAG.        
           MOVE DO-DEP-ACTION-CODE        TO RS-DEP-ACTION-CODE.        
           MOVE DO-DEPOSIT-STATUS-CD      TO RS-DEPOSIT-STATUS-CD.      
           MOVE DO-DATE-TRAN              TO RS-DATE-TRAN.              
           MOVE DO-SERVICE-TYPE-CD        TO RS-SERVICE-TYPE-CD.        
           MOVE DO-DEPOSIT-CERT-NO        TO RS-DEPOSIT-CERT-NO.        
           MOVE DO-AMT-DEPOSIT            TO RS-AMT-ORIG-ENTERED.       
      *                                                                 23601000
PCR482     MOVE WS-ACCOUNT-NO             TO DP-ACCOUNT-NO.             
PCR482     MOVE DO-DEPOSIT-CERT-NO        TO DP-DEPOSIT-CERT-NO.        
      *                                                                 23604000
PCR482     PERFORM 7990-SELECT-DEP-PAY-AMT           THRU 7990-EXIT.    
      *                                                                 23606000
PCR482     MOVE WS-TOTAL-PAYMENTS         TO RS-AMT-PAID.               
      *                                                                 23608000
TP9171     IF WS-DATE-PYMT-START > SPACES                               
TP9171        PERFORM 2450-FIND-DEPOSIT-BILLED THRU 2450-EXIT           
TP9171     ELSE                                                         
TP9171        MOVE SPACES                 TO RS-BILLED-FLAG             
TP9171     END-IF                                                       
                                                                        
           MOVE DO-COMMENTS               TO RS-COMMENTS.               
T28160     MOVE DO-COMMENTS               TO RS-AGENCY-TEXTS.           
           MOVE DO-CODE-DEP-TYPE          TO RS-CODE-DEP-TYPE.          
           MOVE DR-NO-SCHED-PYMTS         TO RS-NO-SCHED-PYMTS.         
           MOVE DR-AMT-MO-PYMT            TO RS-AMT-MO-PYMT.            
           MOVE DR-DEP-BILL-OPTION-CD     TO RS-BILL-OPTION-CD.         
           MOVE DO-USER-ID-UPDT-BY        TO RS-USER-ID-UPDT-BY.        
           MOVE DO-DATE-PYMT-START        TO RS-DATE-PYMT-START.        
           MOVE DR-REBILLED-DEP-AMT       TO RS-REBILLED-DEP-AMT.       
           MOVE DR-REBILLED-DEP-DATE      TO RS-REBILLED-DEP-DATE.      
T28160     MOVE DO-CODE-REFUND-ELIG       TO RS-CODE-REFUND-ELIG.       
T26296     MOVE DO-AUTO-DEP-LTR-DT        TO RS-AUTODEP-LTR-DT.         
T26296     MOVE DO-AUTO-DEP-LTR-IND       TO RS-AUTODEP-LTR-IND.        
      *                                                                 23730000
      *                                                                 23740000
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*                                                                *        
REARCH* 8000A-DELETE-GTT-ROWS.                                         *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE '8000A'                  TO ACTIVE-PARAGRAPH.           
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02092_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02092_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH          MOVE PROGRAM-NAME        TO ABEND-PROGRAM               
REARCH          MOVE '8000A'             TO ACTIVE-PARAGRAPH            
REARCH          MOVE 'DELETE'            TO ABEND-FUNCTION              
REARCH          MOVE SPACES              TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH          MOVE 'CSR02092_R1'       TO TABLE-1                     
REARCH          MOVE SPACES              TO TABLE-ELEMENT-1             
REARCH          MOVE SPACES              TO HOSTVAR-ELEMENT-1           
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE                          
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************23761000
      * 8050-RETURNS-NOT-FOUND                                         *23762000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*23763000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT IS DEP NOT     *23764000
      *       FOUND.                                                   *23764100
      ******************************************************************23765000
       8050-RETURNS-NOT-FOUND.                                          
      *                                                                 23767000
TP8452     MOVE WS-NUMBER-OF-BILLS        TO RS-BILL-COUNT.             
TP8452     MOVE WS-MIN-DEPOSIT-AMT        TO RS-MIN-DEPOSIT-AMT.        
TP8452     MOVE WS-MAX-DEPOSIT-AMT        TO RS-MAX-DEPOSIT-AMT.        
TP8452     MOVE WS-USAGE-HISTORY-FLAG     TO RS-USAGE-HISTORY-FLAG.     
      *                                                                 23771700
       8050-EXIT.                                                       
           EXIT.                                                        
REARC2                                                                  
REARC2******************************************************************        
REARC2*                                                                         
REARC2* 8100-SEND-RESULT                                               *        
REARC2******************************************************************        
REARC2 8100-SEND-RESULT.                                                
REARC2                                                                  
REARC2     MOVE 'INSERT INTO CSR02092_R1'                               
REARC2                                   TO S-SQL-STATEMENT-V.          
REARC2                                                                  
REARC2     EXEC SQL                                                     
REARC2                                                                  
REARC2         INSERT INTO #CSR02092_R1                          
REARC2             (                                                    
REARC2             MIN_DEPOSIT_AMT                                      
REARC2            ,MAX_DEPOSIT_AMT                                      
REARC2            ,USAGE_HISTORY_FLAG                                   
T26296            ,DEP_EXISTS_FLAG                                      
T26296            ,DELQ_DEP_NTFY_LTR                                    
REARC2            ,DEP_ACTION_CODE                                      
REARC2            ,DEPOSIT_STATUS_CD                                    
REARC2            ,DATE_TRAN                                            
REARC2            ,SERVICE_TYPE_CD                                      
REARC2            ,DEPOSIT_CERT_NO                                      
REARC2            ,AMT_ORIG_ENTERED                                     
REARC2            ,BILL_OPTION_CD                                       
REARC2            ,BILLED_FLAG                                          
REARC2            ,AMT_PAID                                             
REARC2            ,COMMENTS                                             
REARC2            ,CODE_DEP_TYPE                                        
REARC2            ,NO_SCHED_PYMTS                                       
REARC2            ,AMT_MO_PYMT                                          
REARC2            ,BILL_COUNT                                           
REARC2            ,USER_ID_UPDT_BY                                      
REARC2            ,DATE_PYMT_START                                      
REARC2            ,OLD_BILL_DATE                                        
REARC2            ,[2ND_OLD_BILL_DATE]                                    
REARC2            ,NEXT_BILLING_DATE                                    
REARC2            ,[2ND_NEXT_BILL_DATE]                                   
REARC2            ,LAST_BILL_DATE                                       
REARC2            ,MST_SUB_ACCT_IND                                     
REARC2            ,DELINQUENCY_VALUE                                    
REARC2            ,DEP_DNP_LIMIT                                        
REARC2            ,REBILLED_DEP_AMT                                     
REARC2            ,REBILLED_DEP_DATE                                    
REARC2            ,IMME_DUE_DATE                                        
REARC2            ,IMME_CUT_DATE                                        
REARC2            ,CODE_DISC_OK                                         
REARC2            ,CREDIT_GROUP                                         
REARC2            ,NOT_CURR_MTH_FLAG                                    
REARC2            ,RETURN_CODE                                          
REARC2            ,AT_LAST_UPDATE_TS                                    
REARC2            ,DATE_FIRST_NOTICE                                    
REARC2            ,INSTLMNT_STRT_DATE                                   
REARC2            ,NEXT_BILL_DATE                                       
REARC2            ,NEXT_DUE_DATE                                        
REARC2            ,IMMED_DUE_DATE                                       
REARC2            ,DATE_FIRST_DUE                                       
REARC2            ,DATE_SECOND_DUE                                      
REARC2            ,CURRENT_BILL_DUE                                     
REARC2            ,ORIG_IMMED_DUE                                       
REARC2            ,CUR_IMMED_DUE                                        
REARC2            ,DT_FST_NTCE_OLD                                      
REARC2            ,CUT_DATE                                             
REARC2            ,FINAL_INSTLMNT_AMT                                   
T28160            ,CODE_REFUND_ELIG                                     
T28160            ,AGENCY_TEXT                                          
T26296            ,AUTODEP_LTR_DT                                       
T26296            ,AUTODEP_LTR_IND                                      
REARC2             )                                                    
REARC2         VALUES                                                   
REARC2             (                                                    
REARC2             :S-MIN-DEPOSIT-AMT                                   
REARC2            ,:S-MAX-DEPOSIT-AMT                                   
REARC2            ,:S-USAGE-HISTORY-FLAG                                
T26296            ,:S-DEP-EXISTS-FLAG                                   
T26296            ,:S-DELQ-DEP-NTFY-LTR                                 
REARC2            ,:S-DEP-ACTION-CODE                                   
REARC2            ,:S-DEPOSIT-STATUS-CD                                 
REARC2            ,:S-DATE-TRAN                                         
REARC2            ,:S-SERVICE-TYPE-CD                                   
REARC2            ,:S-DEPOSIT-CERT-NO                                   
REARC2            ,:S-AMT-ORIG-ENTERED                                  
REARC2            ,:S-BILL-OPTION-CD                                    
REARC2            ,:S-BILLED-FLAG                                       
REARC2            ,:S-AMT-PAID                                          
REARC2            ,:S-COMMENT                                           
REARC2            ,:S-CODE-DEP-TYPE                                     
REARC2            ,:S-NO-SCHED-PYMTS                                    
REARC2            ,:S-AMT-MO-PYMT                                       
REARC2            ,:S-BILL-COUNT                                        
REARC2            ,:S-USER-ID-UPDT-BY                                   
REARC2            ,:S-DATE-PYMT-START                                   
REARC2            ,:S-OLD-BILL-DATE                                     
REARC2            ,:S-2ND-OLD-BILL-DATE                                 
REARC2            ,:S-NEXT-BILLING-DATE                                 
REARC2            ,:S-2ND-NEXT-BILL-DATE                                
REARC2            ,:S-LAST-BILL-DATE                                    
REARC2            ,:S-MST-SUB-ACCT-IND                                  
REARC2            ,:S-DELINQUENCY-VALUE                                 
REARC2            ,:S-DEP-DNP-LIMIT                                     
REARC2            ,:S-REBILLED-DEP-AMT                                  
REARC2            ,:S-REBILLED-DEP-DATE                                 
REARC2            ,:S-IMME-DUE-DATE                                     
REARC2            ,:S-IMME-CUT-DATE                                     
REARC2            ,:S-CODE-DISC-OK                                      
REARC2            ,:S-CREDIT-GROUP                                      
REARC2            ,:S-NOT-CURR-MTH-FLAG                                 
REARC2            ,:S-RETURN-CODE                                       
REARC2            ,:S-AT-LAST-UPDATE-TS                                 
REARC2            ,:S-DATE-FIRST-NOTICE                                 
REARC2            ,:S-INSTLMNT-STRT-DATE                                
REARC2            ,:S-NEXT-BILL-DATE                                    
REARC2            ,:S-NEXT-DUE-DATE                                     
REARC2            ,:S-IMMED-DUE-DATE                                    
REARC2            ,:S-DATE-FIRST-DUE                                    
REARC2            ,:S-DATE-SECOND-DUE                                   
REARC2            ,:S-CURRENT-BILL-DUE                                  
REARC2            ,:S-ORIG-IMMED-DUE                                    
REARC2            ,:S-CUR-IMMED-DUE                                     
REARC2            ,:S-DT-FST-NTCE-OLD                                   
REARC2            ,:S-CUT-DATE                                          
REARC2            ,:S-FINAL-INSTLMNT-AMT                                
T28160            ,:S-CODE-REFUND-ELIG                                  
T28160            ,:S-AGENCY-TEXT                                       
T26296            ,:S-AUTODEP-LTR-DT                                    
T26296            ,:S-AUTODEP-LTR-IND                                   
REARC2             )                                                    
REARC2     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR02092_R1                                  
MFA-TR*            (                                                            
MFA-TR*            MIN_DEPOSIT_AMT                                              
MFA-TR*           ,MAX_DEPOSIT_AMT                                              
MFA-TR*           ,USAGE_HISTORY_FLAG                                           
MFA-TR*           ,DEP_EXISTS_FLAG                                              
MFA-TR*           ,DELQ_DEP_NTFY_LTR                                            
MFA-TR*           ,DEP_ACTION_CODE                                              
MFA-TR*           ,DEPOSIT_STATUS_CD                                            
MFA-TR*           ,DATE_TRAN                                                    
MFA-TR*           ,SERVICE_TYPE_CD                                              
MFA-TR*           ,DEPOSIT_CERT_NO                                              
MFA-TR*           ,AMT_ORIG_ENTERED                                             
MFA-TR*           ,BILL_OPTION_CD                                               
MFA-TR*           ,BILLED_FLAG                                                  
MFA-TR*           ,AMT_PAID                                                     
MFA-TR*           ,COMMENTS                                                     
MFA-TR*           ,CODE_DEP_TYPE                                                
MFA-TR*           ,NO_SCHED_PYMTS                                               
MFA-TR*           ,AMT_MO_PYMT                                                  
MFA-TR*           ,BILL_COUNT                                                   
MFA-TR*           ,USER_ID_UPDT_BY                                              
MFA-TR*           ,DATE_PYMT_START                                              
MFA-TR*           ,OLD_BILL_DATE                                                
MFA-TR*           ,2ND_OLD_BILL_DATE                                            
MFA-TR*           ,NEXT_BILLING_DATE                                            
MFA-TR*           ,2ND_NEXT_BILL_DATE                                           
MFA-TR*           ,LAST_BILL_DATE                                               
MFA-TR*           ,MST_SUB_ACCT_IND                                             
MFA-TR*           ,DELINQUENCY_VALUE                                            
MFA-TR*           ,DEP_DNP_LIMIT                                                
MFA-TR*           ,REBILLED_DEP_AMT                                             
MFA-TR*           ,REBILLED_DEP_DATE                                            
MFA-TR*           ,IMME_DUE_DATE                                                
MFA-TR*           ,IMME_CUT_DATE                                                
MFA-TR*           ,CODE_DISC_OK                                                 
MFA-TR*           ,CREDIT_GROUP                                                 
MFA-TR*           ,NOT_CURR_MTH_FLAG                                            
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*           ,AT_LAST_UPDATE_TS                                            
MFA-TR*           ,DATE_FIRST_NOTICE                                            
MFA-TR*           ,INSTLMNT_STRT_DATE                                           
MFA-TR*           ,NEXT_BILL_DATE                                               
MFA-TR*           ,NEXT_DUE_DATE                                                
MFA-TR*           ,IMMED_DUE_DATE                                               
MFA-TR*           ,DATE_FIRST_DUE                                               
MFA-TR*           ,DATE_SECOND_DUE                                              
MFA-TR*           ,CURRENT_BILL_DUE                                             
MFA-TR*           ,ORIG_IMMED_DUE                                               
MFA-TR*           ,CUR_IMMED_DUE                                                
MFA-TR*           ,DT_FST_NTCE_OLD                                              
MFA-TR*           ,CUT_DATE                                                     
MFA-TR*           ,FINAL_INSTLMNT_AMT                                           
MFA-TR*           ,CODE_REFUND_ELIG                                             
MFA-TR*           ,AGENCY_TEXT                                                  
MFA-TR*           ,AUTODEP_LTR_DT                                               
MFA-TR*           ,AUTODEP_LTR_IND                                              
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*            :S-MIN-DEPOSIT-AMT                                   03000000
MFA-TR*           ,:S-MAX-DEPOSIT-AMT                                   03020000
MFA-TR*           ,:S-USAGE-HISTORY-FLAG                                03022000
MFA-TR*           ,:S-DEP-EXISTS-FLAG                                           
MFA-TR*           ,:S-DELQ-DEP-NTFY-LTR                                         
MFA-TR*           ,:S-DEP-ACTION-CODE                                   03030000
MFA-TR*           ,:S-DEPOSIT-STATUS-CD                                 03040000
MFA-TR*           ,:S-DATE-TRAN                                                 
MFA-TR*           ,:S-SERVICE-TYPE-CD                                   03060000
MFA-TR*           ,:S-DEPOSIT-CERT-NO                                   03070000
MFA-TR*           ,:S-AMT-ORIG-ENTERED                                  03080000
MFA-TR*           ,:S-BILL-OPTION-CD                                    03180000
MFA-TR*           ,:S-BILLED-FLAG                                       03181000
MFA-TR*           ,:S-AMT-PAID                                          03100000
MFA-TR*           ,:S-COMMENT                                           03121000
MFA-TR*           ,:S-CODE-DEP-TYPE                                     03130000
MFA-TR*           ,:S-NO-SCHED-PYMTS                                    03140000
MFA-TR*           ,:S-AMT-MO-PYMT                                       03150000
MFA-TR*           ,:S-BILL-COUNT                                        02980000
MFA-TR*           ,:S-USER-ID-UPDT-BY                                   03190000
MFA-TR*           ,:S-DATE-PYMT-START                                   03200000
MFA-TR*           ,:S-OLD-BILL-DATE                                     03210000
MFA-TR*           ,:S-2ND-OLD-BILL-DATE                                 03220000
MFA-TR*           ,:S-NEXT-BILLING-DATE                                 03230000
MFA-TR*           ,:S-2ND-NEXT-BILL-DATE                                03240000
MFA-TR*           ,:S-LAST-BILL-DATE                                    03250000
MFA-TR*           ,:S-MST-SUB-ACCT-IND                                  03260000
MFA-TR*           ,:S-DELINQUENCY-VALUE                                 03270000
MFA-TR*           ,:S-DEP-DNP-LIMIT                                     03271000
MFA-TR*           ,:S-REBILLED-DEP-AMT                                  03290000
MFA-TR*           ,:S-REBILLED-DEP-DATE                                 03310000
MFA-TR*           ,:S-IMME-DUE-DATE                                     03320000
MFA-TR*           ,:S-IMME-CUT-DATE                                     03330000
MFA-TR*           ,:S-CODE-DISC-OK                                      03340000
MFA-TR*           ,:S-CREDIT-GROUP                                      03341000
MFA-TR*           ,:S-NOT-CURR-MTH-FLAG                                 03342000
MFA-TR*           ,:S-RETURN-CODE                                       03350000
MFA-TR*           ,:S-AT-LAST-UPDATE-TS                                         
MFA-TR*           ,:S-DATE-FIRST-NOTICE                                         
MFA-TR*           ,:S-INSTLMNT-STRT-DATE                                        
MFA-TR*           ,:S-NEXT-BILL-DATE                                            
MFA-TR*           ,:S-NEXT-DUE-DATE                                             
MFA-TR*           ,:S-IMMED-DUE-DATE                                            
MFA-TR*           ,:S-DATE-FIRST-DUE                                            
MFA-TR*           ,:S-DATE-SECOND-DUE                                           
MFA-TR*           ,:S-CURRENT-BILL-DUE                                          
MFA-TR*           ,:S-ORIG-IMMED-DUE                                            
MFA-TR*           ,:S-CUR-IMMED-DUE                                             
MFA-TR*           ,:S-DT-FST-NTCE-OLD                                           
MFA-TR*           ,:S-CUT-DATE                                                  
MFA-TR*           ,:S-FINAL-INSTLMNT-AMT                                        
MFA-TR*           ,:S-CODE-REFUND-ELIG                                          
MFA-TR*           ,:S-AGENCY-TEXT                                               
MFA-TR*           ,:S-AUTODEP-LTR-DT                                            
MFA-TR*           ,:S-AUTODEP-LTR-IND                                           
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARC2                                                                  
REARC2     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
REARC2                                                                  
REARC2     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARC2        CONTINUE                                                  
REARC2     ELSE                                                         
REARC2        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARC2        MOVE SQLCODE              TO ABEND-SQLCODE                
REARC2        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARC2        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARC2        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARC2        MOVE 'CSR02092_R1'        TO TABLE-1                      
REARC2        MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-1              
REARC2        MOVE SPACES               TO TABLE-ELEMENT-2              
REARC2        MOVE S-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-1            
REARC2        MOVE SPACES               TO HOSTVAR-ELEMENT-2            
REARC2        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARC2     END-IF                                                       
REARC2                                                                  
REARC2     ADD 1 TO CTR-ROWS                                            
REARC2     INITIALIZE GTT-RETURN-FIELDS                                 
REARC2     .                                                            
REARC2 8100-EXIT.                                                       
REARC2     EXIT.                                                        
REARC2                                                                  
      *                                                                 23772100
      ******************************************************************23772200
      * INCLUDE CPD00309 FOR NEXT BILL DATE CALCULATION                *23772300
      ******************************************************************23772400
TP8767     EXEC SQL                                                     23772500
T34621        INCLUDE CPD0309A                                          23772600
TP8767     END-EXEC.                                                    23773000
      *                                                                 23780000
      ******************************************************************23780100
      * INCLUDE CPD0023C FOR ERROR HANDLING                            *23780200
      ******************************************************************23780300
TP8767     EXEC SQL                                                     23781000
TP8767        INCLUDE CPD0023C                                          23782000
TP8767     END-EXEC.                                                    23783000
      *                                                                 23784000
      *                                                                 23785000
      ******************************************************************23790000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *23800000
      ******************************************************************23810000
           EXEC SQL                                                     23820000
REARCH        INCLUDE CPDSP300                                                  
           END-EXEC.                                                    23840000
                                                                        
      ******************************************************************23860000
      * 9999- END PROGRAM COPYLIB                                      *23870000
      ******************************************************************23880000
REARCH     EXEC SQL                                                             
REARC2        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
REARCH*                                                                         
                                                                        
