       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02089.                                         
COB303 DATE-WRITTEN.     MAY 4, 1995.                                   
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S089 CONVERTED TO DB2 SP CSR02089 ON 08/09/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S089                                           *        
      *  PROGRAM:       S089                                           *        
      *  CALLING SP:    PN_S089                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES DETAIL INFORMATION FOR ALL METERS AND  *        
      *  REGISTERS ASSOCIATED WITH A GIVEN IC.                         *        
      *                                                                         
      *  INPUT PARAMETERS                OUTPUT PARAMETERS             *        
      *  -------------------------       -----------------------       *        
      *  ACCOUNT_NO           S9(13)     RETURN_CODE        S9(4)      *        
      *  BILL_NO              S9(9)      DATE_READ          X(10)      *        
      *  IC_NO                S9(4)                                    *        
      *  CODE_UTIL_TYPE       X(1)       CODE_ITEM_STATUS   X(1)       *        
      *  BILL_ITEM_TIMESTMP   X(26)      METER_NO           X(9)       *        
      *                                  CURR_UNITS         S9(9)      *        
      *                                  METER_READING      S9(11)     *        
      *                                  DEMAND_READING     S9(8)V9(3) *        
      *                                  PREV_READING_ND    S9(11)     *        
      *                                  PREV_READING_D     S9(8)V9(3) *        
      *                                  PREV_READ_DATE     X(10)      *        
      *                                  CONSTANT           S9(6)V9(5) *        
      *                                  CODE_METER_READ    X(1)       *        
      *                                  CODE_METER_NO_READ X(1)       *        
      *                                  NO_DAYS            S9(4)      *        
      *                                  MTR_REF_NO         S9(4)      *        
      *                                  MTR_READ_SOURCE_CD X(1)       *        
      *                                  CODE_TIME_PERIOD   PIC S9(4)  *        
      *                                  CODE_TOU_SEASN     X(1)       *        
      *                                  BILL_DATE          X(10)      *        
      *                                  METER_DESC         X(35)      *        
T23632*                                  RATIO              S9(9)V999  *        
      *                                                                *        
      *  THE FOLLOWING TABLES ARE USED :                               *        
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID              *        
      *      ------------------  -----------    ---------              *        
      *      CSS_CNSMPTN_HIST    TBCNSMP        CX                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/04/95    MM       CREATED.                                 *        
      *  10/26/95    TCB      FIXED TPR 1478. PREVIOUS USAGE IS NOW    *        
      *                       RETRIEVED FROM THE PRIOR MONTHS HISTORY  *        
      *                       RECORD INSTEAD OF BEING CALCULATED.      *        
T10863*  05/07/97    MJG      THE 7200- SELECT PREVIOUS USAGE WAS      *        
      *                       GETTING A -811 BECAUSE IT WAS NOT USING  *        
      *                       THE PROPER KEY.  CHANGED CURSOR TO       *        
      *                       RETRIEVE ALL THE NEEDED INFORMATION AND  *        
      *                       CHANGED SELECT TO USE IT AS THE KEY.     *        
T16000*  06/30/98    VK       TPR 16000                                *        
      *                       CORRECTED THE 'FAILED TO SEND' ERROR.    *        
CBSI  *  08/03/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T17818*  10/05/98   RGB       CODE CHANGED TO SHOW CORRECT BILL DATE   *        
T17818*                       ON THE TOP OF PANEL 106                  *        
T23632*  07/08/01   COVANSYS  ADD NEW FIELD RATIO , CALCULATE AND SEND *        
T23632*             CHENNAI   RESULTSET TO PANEL 106                   *        
T24987*  09/11/01   SK88120   CHANGED THE CURSOR NOT TO FETCH USING    *        
      *                       ITEM_SEQ_NO .                            *        
T27236*  09/26/02   SK88120   ADD NEW FIELD BTU FACTOR. RETRIEVE AND   *        
      *                       SEND RESULT SET TO PANEL106.             *        
T27236*  12/12/02   ANAND     ADD NEW FIELD THERMS, CALCULATE AND SEND *        
T27236*                       RESULT SET TO PANEL 106                  *        
T28169*  12/26/02   LAT       INITIALIZE WS-HOLD-CORR-UNITS TO ZERO TO *        
T28169*                       FIX S0C7 ABEND. *                                 
T30989*  04/12/05   JAYANTHI  ADDED NEW FIELD PCOMP_FCT TO RESULTSET   *        
REARCH*  08/09/05   CVNS      RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*             CHENNAI                                                     
REARCH*  12/21/05   VD41351   FIX THE CONSTANT DATA TYPE IN GT TABLE.  *        
P00251*  02/10/10   CVNS      RETURNED CODE_USAGE_ID AND HANDLED -VE   *        
P00251*             CHENNAI   CONSUMPTION USAGE                                 
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02089'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S089 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRVAL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02089'.      
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
CVT999*    05  PARM-ID1                  PIC S9(9) COMP VALUE 1.                
           05  PARM-ACCOUNT-NO           PIC X(13).                     
           05  PARM-BILL-NO              PIC S9(9) COMP.                
           05  PARM-IC-NO                PIC S9(4) COMP.                
           05  PARM-CODE-UTIL-TYPE       PIC X(1).                      
           05  PARM-BILL-ITEM-TIMESTMP   PIC X(26).                     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
           05  WS-ACTIVE-CODE            PIC X(01) VALUE 'A'.           
           05  WS-CX-ACTIVE-RETURN-CODE  PIC S9(4) COMP.                
           05  WS-HOLD-BILL-TIMESTMP     PIC X(26).                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) USAGE COMP VALUE 0.    
           05  RS-DATE-READ            PIC X(10) VALUE SPACE.           
           05  RS-CODE-ITEM-STATUS     PIC X(1)  VALUE SPACE.           
           05  RS-METER-NO             PIC X(9)  VALUE SPACE.           
           05  RS-CURR-UNITS           PIC S9(9) USAGE COMP-3 VALUE 0.  
           05  RS-CURRENT-READING      PIC X(12) VALUE SPACE.           
           05  RS-PREVIOUS-READING     PIC X(12) VALUE SPACE.           
           05  RS-PREV-READ-DATE       PIC X(10) VALUE SPACE.           
           05  RS-CONSTANT             PIC S9(6)V9(5) USAGE COMP-3      
                                                               VALUE 0. 
           05  RS-CODE-METER-READ      PIC X(1) VALUE SPACE.            
           05  RS-CODE-METER-NO-READ   PIC X(1) VALUE SPACE.            
           05  RS-NO-DAYS              PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-MTR-REF-NO           PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-MTR-READ-SOURCE-CD   PIC X(1) VALUE SPACE.            
           05  RS-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-CODE-TOU-SEASN       PIC X(1) VALUE SPACE.            
           05  RS-BILL-DATE            PIC X(10) VALUE SPACE.           
           05  RS-METER-DESC           PIC X(35) VALUE SPACE.           
           05  RS-NO-DIALS             PIC S9(4) USAGE COMP VALUE 0.    
T23632     05  RS-RATIO                PIC S9(9)V999 USAGE COMP-3       
T23632                                                      VALUE 0.    
T27236     05  RS-BTU-FACTOR           PIC S9(2)V9(5) USAGE COMP-3      
T27236                                                      VALUE 0.    
T27236     05  RS-THERMS               PIC S9(9)V USAGE COMP-3 VALUE 0. 
T30989     05  RS-PCOMP-FCT            PIC S9(2)V9(5) USAGE COMP-3      
T30989                                                      VALUE 0.    
P00251     05  RS-CODE-USAGE-ID        PIC X(1) VALUE SPACES.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) USAGE COMP VALUE 0.     
           05  S-DATE-READ            PIC X(10) VALUE SPACE.            
           05  S-CODE-ITEM-STATUS     PIC X(1)  VALUE SPACE.            
           05  S-METER-NO             PIC X(9)  VALUE SPACE.            
           05  S-CURR-UNITS           PIC S9(9) USAGE COMP-3 VALUE 0.   
           05  S-CURRENT-READING      PIC X(12) VALUE SPACE.            
           05  S-PREVIOUS-READING     PIC X(12) VALUE SPACE.            
           05  S-PREV-READ-DATE       PIC X(10) VALUE SPACE.            
           05  S-CONSTANT             PIC S9(6)V9(5) USAGE COMP-3       
                                                               VALUE 0. 
           05  S-CODE-METER-READ      PIC X(1) VALUE SPACE.             
           05  S-CODE-METER-NO-READ   PIC X(1) VALUE SPACE.             
           05  S-NO-DAYS              PIC S9(4) USAGE COMP VALUE 0.     
           05  S-MTR-REF-NO           PIC S9(4) USAGE COMP VALUE 0.     
           05  S-MTR-READ-SOURCE-CD   PIC X(1) VALUE SPACE.             
           05  S-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP VALUE 0.     
           05  S-CODE-TOU-SEASN       PIC X(1) VALUE SPACE.             
           05  S-BILL-DATE            PIC X(10) VALUE SPACE.            
           05  S-METER-DESC           PIC X(35) VALUE SPACE.            
           05  S-NO-DIALS             PIC S9(4) USAGE COMP VALUE 0.     
T23632     05  S-RATIO                PIC S9(9)V999 USAGE COMP-3        
T23632                                                      VALUE 0.    
T27236     05  S-BTU-FACTOR           PIC S9(2)V9(5) USAGE COMP-3       
T27236                                                     VALUE 0.     
T27236     05  S-THERMS               PIC S9(9)V USAGE COMP-3 VALUE 0.  
T30989     05  S-PCOMP-FCT            PIC S9(2)V9(5) USAGE COMP-3       
T30989                                                      VALUE 0.    
P00251     05  S-CODE-USAGE-ID        PIC X(1) VALUE SPACES.            
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*    05  CNS-DATE-READ          PIC X(09) VALUE 'DATE_READ'.              
CVT999*    05  CNS-CODE-ITEM-STATUS   PIC X(16) VALUE                           
CVT999*                                             'CODE_ITEM_STATUS'.         
CVT999*    05  CNS-METER-NO           PIC X(08) VALUE 'METER_NO'.               
CVT999*    05  CNS-CURR-UNITS         PIC X(10) VALUE 'CURR_UNITS'.             
CVT999*    05  CNS-CURRENT-READING    PIC X(15) VALUE 'CURRENT_READING'.        
CVT999*    05  CNS-PREVIOUS-READING   PIC X(16) VALUE                           
CVT999*                                             'PREVIOUS_READING'.         
CVT999*    05  CNS-PREV-READ-DATE     PIC X(14) VALUE 'PREV_READ_DATE'.         
CVT999*    05  CNS-CONSTANT           PIC X(08) VALUE 'CONSTANT'.               
CVT999*    05  CNS-CODE-METER-READ    PIC X(15) VALUE 'CODE_METER_READ'.        
CVT999*    05  CNS-CODE-METER-NO-READ PIC X(18) VALUE                           
CVT999*                                           'CODE_METER_NO_READ'.         
CVT999*    05  CNS-NO-DAYS            PIC X(7)  VALUE 'NO_DAYS'.                
CVT999*    05  CNS-MTR-REF-NO         PIC X(12) VALUE 'METER_REF_NO'.           
CVT999*    05  CNS-MTR-READ-SOURCE-CD PIC X(18) VALUE                           
CVT999*                                            'MTR_READ_SOURCE_CD'.        
CVT999*    05  CNS-CODE-TIME-PERIOD   PIC X(16) VALUE                           
CVT999*                                            'CODE_TIME_PERIOD'.          
CVT999*    05  CNS-CODE-TOU-SEASN     PIC X(14) VALUE                           
CVT999*                                            'CODE_TOU_SEASN'.            
CVT999*    05  CNS-BILL-DATE          PIC X(09) VALUE 'BILL_DATE'.              
CVT999*    05  CNS-METER-DESC         PIC X(10) VALUE 'METER_DESC'.             
CVT999*    05  CNS-NO-DIALS           PIC X(08) VALUE 'NO_DIALS'.               
CVT999*    05  CNS-RATIO              PIC X(05) VALUE 'RATIO'.                  
CVT999*    05  CNS-BTU-FACTOR         PIC X(10) VALUE 'BTU_FACTOR'.             
CVT999*    05  CNS-THERMS             PIC X(06) VALUE 'THERMS'.                 
CVT999*    05  CNS-PCOMP-FCT          PIC X(09) VALUE 'PCOMP FCT'.              
CVT999*                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.               
           05  WS-BILL-NO              PIC S9(9) COMP.                  
           05  WS-IC-NO                PIC S9(4) COMP.                  
           05  WS-CODE-UTIL-TYPE       PIC X(1).                        
           05  WS-BILL-ITEM-TIMESTMP   PIC X(26).                       
           05  WS-REG-ID-NO            PIC S9(4) COMP.                  
           05  WS-RCVPRM               PIC X(20) VALUE SPACE.           
T17818*    05  WS-BILL-DATE            PIC X(10).                               
           05  WS-PREV-READ-DATE       PIC X(10) VALUE SPACES.          
COB305     05 WS-METER-READING-CMP3        PIC S9(11)V USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-METER-READING-NUM    PIC S9(11)V VALUE ZEROES.        
           05  WS-METER-READING        PIC Z(12) VALUE ZEROES.          
COB305     05 WS-DEMAND-READING-CMP3        PIC S9(8)V9(3) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-DEMAND-READING-NUM   PIC S9(8)V9(3) VALUE ZEROES.     
           05  WS-DEMAND-READING       PIC Z(7)9.999 VALUE ZEROES.      
           05  WS-NULL-IND1            PIC S9(4) COMP.                  
T23632     05  WS-PREV-MTR-REF-NO      PIC S9(4) USAGE COMP.            
T23632     05  WS-HOLD-CORR-UNITS      PIC S9(9)V USAGE COMP-3          
T28169                                            VALUE ZEROES.         
T23632     05  WS-RATIO                PIC S9(9)V999 USAGE COMP-3       
T23632                                               VALUE ZEROES.      
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR CSS-CNSMPTN-HIST >                                      
                                                                        
           EXEC SQL DECLARE CX-CURSOR CURSOR FOR                        
               SELECT     CODE_UTIL_TYPE,                               
                          CIS.CHAR2$DATE(DATE_READ,'USA'),                    
                          CODE_ITEM_STATUS,                             
                          METER_NO,                                     
                          CODE_USAGE_TYPE,                              
                          CODE_USAGE_ID,                                
                          CODE_USAGE_SOURCE,                            
                          NO_UNITS,                                     
                          NO_DEMAND_UNITS,                              
                          METER_READING,                                
                          DEMAND_READING,                               
                          CONSTANT,                                     
                          CODE_METER_READ,                              
                          CODE_METER_NO_READ,                           
                          NO_DAYS,                                      
                          CIS.CHAR2$DATE(DATEADD( DAY, -NO_DAYS, 
           DATE_READ ),'USA'),     
                          DATEADD( DAY, -NO_DAYS, DATE_READ ),               
                          MTR_REF_NO,                                   
                          MTR_READ_SOURCE_CD,                           
                          CODE_TIME_PERIOD,                             
                          CODE_TOU_SEASN,                               
                          ITEM_SEQ_NO,                                  
                          NO_DIALS,                                     
                          REG_ID_NO,                                    
T27236                    BTU_FACTOR,                                   
T30989                    PCOMP_FCT                                     
P00251                   ,CODE_DEBIT_CREDIT                             
               FROM       CSS_CNSMPTN_HIST                              
               WHERE      ACCOUNT_NO         =:WS-ACCOUNT-NO            
               AND        BILL_NO            =:WS-BILL-NO               
               AND        CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE        
               AND        IC_NO              =:WS-IC-NO                 
               AND        BILL_ITEM_TIMESTMP =CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
T10863         AND        CODE_USAGE_ID NOT IN ('1','2','3','4','5',    
                                 '6','7','8','9')                       
               ORDER BY MTR_REF_NO,                                     
                        CODE_USAGE_TYPE,                                
                        CODE_USAGE_ID,                                  
                        CODE_USAGE_SOURCE,                              
                        ITEM_SEQ_NO                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE CX-CURSOR CURSOR FOR                                
MFA-TR*        SELECT     CODE_UTIL_TYPE,                                       
MFA-TR*                   CHAR(DATE(DATE_READ),USA),                            
MFA-TR*                   CODE_ITEM_STATUS,                                     
MFA-TR*                   METER_NO,                                             
MFA-TR*                   CODE_USAGE_TYPE,                                      
MFA-TR*                   CODE_USAGE_ID,                                        
MFA-TR*                   CODE_USAGE_SOURCE,                                    
MFA-TR*                   NO_UNITS,                                             
MFA-TR*                   NO_DEMAND_UNITS,                                      
MFA-TR*                   METER_READING,                                        
MFA-TR*                   DEMAND_READING,                                       
MFA-TR*                   CONSTANT,                                             
MFA-TR*                   CODE_METER_READ,                                      
MFA-TR*                   CODE_METER_NO_READ,                                   
MFA-TR*                   NO_DAYS,                                              
MFA-TR*                   CHAR(DATE(DATE_READ - NO_DAYS DAYS),USA),             
MFA-TR*                   DATE(DATE_READ - NO_DAYS DAYS),                       
MFA-TR*                   MTR_REF_NO,                                           
MFA-TR*                   MTR_READ_SOURCE_CD,                                   
MFA-TR*                   CODE_TIME_PERIOD,                                     
MFA-TR*                   CODE_TOU_SEASN,                                       
MFA-TR*                   ITEM_SEQ_NO,                                          
MFA-TR*                   NO_DIALS,                                             
MFA-TR*                   REG_ID_NO,                                            
MFA-TR*                   BTU_FACTOR,                                           
MFA-TR*                   PCOMP_FCT                                             
MFA-TR*                  ,CODE_DEBIT_CREDIT                                     
MFA-TR*        FROM       CSS_CNSMPTN_HIST                                      
MFA-TR*        WHERE      ACCOUNT_NO         =:WS-ACCOUNT-NO                    
MFA-TR*        AND        BILL_NO            =:WS-BILL-NO                       
MFA-TR*        AND        CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE                
MFA-TR*        AND        IC_NO              =:WS-IC-NO                         
MFA-TR*        AND        BILL_ITEM_TIMESTMP =:WS-BILL-ITEM-TIMESTMP            
MFA-TR*        AND        CODE_USAGE_ID NOT IN ('1','2','3','4','5',            
MFA-TR*                          '6','7','8','9')                               
MFA-TR*        ORDER BY MTR_REF_NO,                                             
MFA-TR*                 CODE_USAGE_TYPE,                                        
MFA-TR*                 CODE_USAGE_ID,                                          
MFA-TR*                 CODE_USAGE_SOURCE,                                      
MFA-TR*                 ITEM_SEQ_NO                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE PREV-CX-CURSOR CURSOR FOR                   
               SELECT     METER_READING,                                
                          DEMAND_READING,                               
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                            
               FROM       CSS_CNSMPTN_HIST                              
               WHERE      ACCOUNT_NO         =:WS-ACCOUNT-NO            
               AND        DATE_READ          =IIF(TRY_CONVERT(DATE, 
                                                     :WS-PREV-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-READ-DATE
              ) <> 0) OR (LEN(:WS-PREV-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-READ-DATE
              ), CONVERT(DATE, :WS-PREV-READ-DATE) )        
               AND        CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE        
               AND        IC_NO              =:WS-IC-NO                 
               AND        REG_ID_NO          =:WS-REG-ID-NO             
T10863         AND        MTR_REF_NO         =:CX-MTR-REF-NO            
T10863         AND        CODE_TIME_PERIOD   =:CX-CODE-TIME-PERIOD      
T10863*T24987  AND        ITEM_SEQ_NO        =:CX-ITEM-SEQ-NO                   
T10863         AND        CODE_USAGE_ID      =:CX-CODE-USAGE-ID         
T10863         AND        CODE_USAGE_TYPE    =:CX-CODE-USAGE-TYPE       
T10863         AND        CODE_USAGE_SOURCE  =:CX-CODE-USAGE-SOURCE     
               ORDER BY BILL_ITEM_TIMESTMP DESC                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PREV-CX-CURSOR CURSOR FOR                           
MFA-TR*        SELECT     METER_READING,                                        
MFA-TR*                   DEMAND_READING,                                       
MFA-TR*                   BILL_ITEM_TIMESTMP                                    
MFA-TR*        FROM       CSS_CNSMPTN_HIST                                      
MFA-TR*        WHERE      ACCOUNT_NO         =:WS-ACCOUNT-NO                    
MFA-TR*        AND        DATE_READ          =:WS-PREV-READ-DATE                
MFA-TR*        AND        CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE                
MFA-TR*        AND        IC_NO              =:WS-IC-NO                         
MFA-TR*        AND        REG_ID_NO          =:WS-REG-ID-NO                     
MFA-TR*        AND        MTR_REF_NO         =:CX-MTR-REF-NO                    
MFA-TR*        AND        CODE_TIME_PERIOD   =:CX-CODE-TIME-PERIOD              
MFA-TR*T24987  AND        ITEM_SEQ_NO        =:CX-ITEM-SEQ-NO                   
MFA-TR*        AND        CODE_USAGE_ID      =:CX-CODE-USAGE-ID                 
MFA-TR*        AND        CODE_USAGE_TYPE    =:CX-CODE-USAGE-TYPE               
MFA-TR*        AND        CODE_USAGE_SOURCE  =:CX-CODE-USAGE-SOURCE             
MFA-TR*        ORDER BY BILL_ITEM_TIMESTMP DESC                                 
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
CVT000            RETURN_CODE                                           
CVT000           ,DATE_READ                                             
CVT000           ,CODE_ITEM_STATUS                                      
CVT000           ,LTRIM(RTRIM(METER_NO))            AS  METER_NO               
CVT000           ,CURR_UNITS                                            
CVT000           ,LTRIM(RTRIM(CURRENT_READING))     AS  CURRENT_READING        
CVT000           ,LTRIM(RTRIM(PREVIOUS_READING))    AS  PREVIOUS_READING       
CVT000           ,PREV_READ_DATE                                        
CVT000           ,CONSTANT                                              
CVT000           ,CODE_METER_READ                                       
CVT000           ,CODE_METER_NO_READ                                    
CVT000           ,NO_DAYS                                               
CVT000           ,MTR_REF_NO                                            
CVT000           ,MTR_READ_SOURCE_CD                                    
CVT000           ,CODE_TIME_PERIOD                                      
CVT000           ,CODE_TOU_SEASN                                        
CVT000           ,BILL_DATE                                             
CVT000           ,LTRIM(RTRIM(METER_DESC))          AS  METER_DESC             
CVT000           ,NO_DIALS                                              
CVT000           ,RATIO                                                 
CVT000           ,BTU_FACTOR                                            
CVT000           ,THERMS                                                
CVT000           ,PCOMP_FCT                                             
P00251           ,CODE_USAGE_ID                                         
CVT000         FROM #CSR02089_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,DATE_READ                                                     
MFA-TR*          ,CODE_ITEM_STATUS                                              
MFA-TR*          ,STRIP(METER_NO)            AS  METER_NO                       
MFA-TR*          ,CURR_UNITS                                                    
MFA-TR*          ,STRIP(CURRENT_READING)     AS  CURRENT_READING                
MFA-TR*          ,STRIP(PREVIOUS_READING)    AS  PREVIOUS_READING               
MFA-TR*          ,PREV_READ_DATE                                                
MFA-TR*          ,CONSTANT                                                      
MFA-TR*          ,CODE_METER_READ                                               
MFA-TR*          ,CODE_METER_NO_READ                                            
MFA-TR*          ,NO_DAYS                                                       
MFA-TR*          ,MTR_REF_NO                                                    
MFA-TR*          ,MTR_READ_SOURCE_CD                                            
MFA-TR*          ,CODE_TIME_PERIOD                                              
MFA-TR*          ,CODE_TOU_SEASN                                                
MFA-TR*          ,BILL_DATE                                                     
MFA-TR*          ,STRIP(METER_DESC)          AS  METER_DESC                     
MFA-TR*          ,NO_DIALS                                                      
MFA-TR*          ,RATIO                                                         
MFA-TR*          ,BTU_FACTOR                                                    
MFA-TR*          ,THERMS                                                        
MFA-TR*          ,PCOMP_FCT                                                     
MFA-TR*          ,CODE_USAGE_ID                                                 
MFA-TR*        FROM SESSION.CSR02089_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-BILL-NO             PIC S9(9) COMP           .          
CVT000 01  LINK-IC-NO               PIC S9(4) COMP           .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(1)                 .          
CVT000 01  LINK-BILL-ITEM-TIMESTMP  PIC X(26)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-BILL-NO                                            
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-BILL-ITEM-TIMESTMP                                 
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                         
T16000     IF CTR-ROWS < 1                                              
T16000        INITIALIZE GTT-RETURN-FIELDS                              
T16000        MOVE 100 TO RS-RETURN-CODE                                
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T16000        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
T16000     END-IF.                                                      
      *                                                                         
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'               TO ACTIVE-PARAGRAPH.               
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-BILL-NO              TO PARM-BILL-NO             . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP  . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02089_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02089_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,CODE_ITEM_STATUS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,CURR_UNITS               DECIMAL(09,0)                   
CVT000        ,CURRENT_READING CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,PREVIOUS_READING CHAR(12)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,PREV_READ_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,CONSTANT                 DECIMAL(11,5)                   
CVT000        ,CODE_METER_READ CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,CODE_METER_NO_READ CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,NO_DAYS                  SMALLINT                        
CVT000        ,MTR_REF_NO               SMALLINT                        
CVT000        ,MTR_READ_SOURCE_CD CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,CODE_TIME_PERIOD         SMALLINT                        
CVT000        ,CODE_TOU_SEASN CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,BILL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,METER_DESC CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,NO_DIALS                 SMALLINT                        
CVT000        ,RATIO                    DECIMAL(12,3)                   
REARCH        ,BTU_FACTOR               DECIMAL(7,5)                    
CVT000        ,THERMS                   DECIMAL(09,0)                   
REARCH        ,PCOMP_FCT                DECIMAL(7,5)                    
P00251        ,CODE_USAGE_ID CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02089_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                           
                                                                        
           MOVE PARM-ACCOUNT-NO            TO WS-ACCOUNT-NO.            
           MOVE PARM-BILL-NO               TO WS-BILL-NO.               
           MOVE PARM-IC-NO                 TO WS-IC-NO.                 
           MOVE PARM-CODE-UTIL-TYPE        TO WS-CODE-UTIL-TYPE.        
           MOVE PARM-BILL-ITEM-TIMESTMP    TO WS-BILL-ITEM-TIMESTMP.    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
      *-------------< GET ACCOUNT-NO >                                          
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
REARCH*    MOVE 'ACCOUNT-NO'                     TO WS-RCVPRM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *-------------< GET BILL-NO >                                             
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-BILL-NO           TO MAX-LENGTH-PARM.            
REARCH*    MOVE 'BILL-NO'                        TO WS-RCVPRM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-BILL-NO,                                  
CVT999*                          TDSINT4,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *-------------< GET IC-NO >                                               
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-IC-NO             TO MAX-LENGTH-PARM.            
REARCH*    MOVE 'IC-NO'                          TO WS-RCVPRM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-IC-NO,                                    
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *-------------< GET CODE-UTIL-TYPE >                                      
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
REARCH*    MOVE 'CODE-UTIL-TYPE'                 TO WS-RCVPRM.                  
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *-------------< GET BILL-ITEM-TIMESTMP >                                  
CVT999*    ADD  1                                 TO PARM-ID1.                  
CVT999*    MOVE LENGTH OF PARM-BILL-ITEM-TIMESTMP TO MAX-LENGTH-PARM.           
REARCH*    MOVE 'BILL-ITEM-TIMESTMP'              TO WS-RCVPRM.                 
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-BILL-ITEM-TIMESTMP,                       
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.                   
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************16245000
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************16245000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-DATE-READ          TO S-DATE-READ.                   
REARCH     MOVE RS-CODE-ITEM-STATUS   TO S-CODE-ITEM-STATUS.            
REARCH     MOVE RS-METER-NO           TO S-METER-NO.                    
REARCH     MOVE RS-CURR-UNITS         TO S-CURR-UNITS.                  
REARCH     MOVE RS-CURRENT-READING    TO S-CURRENT-READING.             
REARCH     MOVE RS-PREVIOUS-READING   TO S-PREVIOUS-READING.            
REARCH     MOVE RS-PREV-READ-DATE     TO S-PREV-READ-DATE.              
REARCH     MOVE RS-CONSTANT           TO S-CONSTANT.                    
REARCH     MOVE RS-CODE-METER-READ    TO S-CODE-METER-READ.             
REARCH     MOVE RS-CODE-METER-NO-READ TO S-CODE-METER-NO-READ.          
REARCH     MOVE RS-NO-DAYS            TO S-NO-DAYS.                     
REARCH     MOVE RS-MTR-REF-NO         TO S-MTR-REF-NO.                  
REARCH     MOVE RS-MTR-READ-SOURCE-CD TO S-MTR-READ-SOURCE-CD.          
REARCH     MOVE RS-CODE-TIME-PERIOD   TO S-CODE-TIME-PERIOD.            
REARCH     MOVE RS-CODE-TOU-SEASN     TO S-CODE-TOU-SEASN.              
REARCH     MOVE RS-BILL-DATE          TO S-BILL-DATE.                   
REARCH     MOVE RS-METER-DESC         TO S-METER-DESC.                  
REARCH     MOVE RS-NO-DIALS           TO S-NO-DIALS.                    
REARCH     MOVE RS-RATIO              TO S-RATIO.                       
REARCH     MOVE RS-BTU-FACTOR         TO S-BTU-FACTOR.                  
REARCH     MOVE RS-THERMS             TO S-THERMS.                      
REARCH     MOVE RS-PCOMP-FCT          TO S-PCOMP-FCT.                   
P00251     MOVE RS-CODE-USAGE-ID      TO S-CODE-USAGE-ID.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     CALLS 2110-DESC-RET-CODE                                   *        
      *           2115-DESC-DATE-READ                                  *        
      *           2125-DESC-CODE-ITEM-STATUS                           *        
      *           2130-DESC-METER-NO                                   *        
      *           2150-DESC-CURR-UNITS                                 *        
      *           2155-DESC-CURRENT-READING                            *        
      *           2162-DESC-PREV-READING                               *        
      *           2166-DESC-PREV-READ-DATE                             *        
      *           2168-DESC-CONSTANT                                   *        
      *           2170-DESC-CODE-METER-READ                            *        
      *           2171-DESC-CODE-METER-NO-READ                         *        
      *           2172-DESC-NO-DAYS                                    *        
      *           2174-DESC-MTR-REF-NO                                 *        
      *           2176-DESC-MTR-READ-SOURCE-CD                         *        
      *           2178-DESC-CODE-TIME-PERIOD                           *        
      *           2180-DESC-CODE-TOU-SEASN                             *        
      *           2182-DESC-BILL-DATE                                  *        
      *           2184-DESC-METER-DESC                                 *        
      *           2186-DESC-NO-DIALS                                   *        
T23632*           2188-DESC-RATIO                                      *        
T27236*           2189-DESC-BTU-FACTOR                                 *        
T27236*           2190-DESC-THERMS                                     *        
      *                                                                *        
      *      CALLED FROM 2000-PROCESS-OUTPUT                           *        
      *                                                                *        
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                  *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.              
REARCH*    PERFORM 2115-DESC-DATE-READ             THRU 2115-EXIT.              
REARCH*    PERFORM 2125-DESC-CODE-ITEM-STATUS      THRU 2125-EXIT.              
REARCH*    PERFORM 2130-DESC-METER-NO              THRU 2130-EXIT.              
REARCH*    PERFORM 2150-DESC-CURR-UNITS            THRU 2150-EXIT.              
REARCH*    PERFORM 2155-DESC-CURRENT-READING       THRU 2155-EXIT.              
REARCH*    PERFORM 2162-DESC-PREV-READING          THRU 2162-EXIT.              
REARCH*    PERFORM 2166-DESC-PREV-READ-DATE        THRU 2166-EXIT.              
REARCH*    PERFORM 2168-DESC-CONSTANT              THRU 2168-EXIT.              
REARCH*    PERFORM 2170-DESC-CODE-METER-READ       THRU 2170-EXIT.              
REARCH*    PERFORM 2171-DESC-CODE-METER-NO-READ    THRU 2171-EXIT.              
REARCH*    PERFORM 2172-DESC-NO-DAYS               THRU 2172-EXIT.              
REARCH*    PERFORM 2174-DESC-MTR-REF-NO            THRU 2174-EXIT.              
REARCH*    PERFORM 2176-DESC-MTR-READ-SOURCE-CD    THRU 2176-EXIT.              
REARCH*    PERFORM 2178-DESC-CODE-TIME-PERIOD      THRU 2178-EXIT.              
REARCH*    PERFORM 2180-DESC-CODE-TOU-SEASN        THRU 2180-EXIT.              
REARCH*    PERFORM 2182-DESC-BILL-DATE             THRU 2182-EXIT.              
REARCH*    PERFORM 2184-DESC-METER-DESC            THRU 2184-EXIT.              
REARCH*    PERFORM 2186-DESC-NO-DIALS              THRU 2186-EXIT.              
REARCH*    PERFORM 2188-DESC-RATIO                 THRU 2188-EXIT.              
REARCH*    PERFORM 2189-DESC-BTU-FACTOR            THRU 2189-EXIT.              
REARCH*    PERFORM 2190-DESC-THERMS                THRU 2190-EXIT.              
REARCH*    PERFORM 2191-DESC-PCOMP-FCT             THRU 2191-EXIT.              
                                                                        
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2110-DESC-RET-CODE.                                                      
REARCH*                                                                         
REARCH*    MOVE '2110'                       TO ACTIVE-PARAGRAPH.               
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2110-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2115-DESC-DATE-READ                                            *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE DATE READ   FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2115-DESC-DATE-READ.                                                     
REARCH*                                                                         
REARCH*    MOVE '2115'                       TO ACTIVE-PARAGRAPH.               
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-DATE-READ       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-DATE-READ      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DATE-READ,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DATE-READ,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2115-EXIT.                                                               
REARCH*    EXIT.                                                                
      ******************************************************************        
      * 2125-DESC-CODE-ITEM-STATUS                                     *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CODE-ITEM-STATUS        FIELD TO THE CLIENT       *        
      ******************************************************************        
                                                                        
REARCH*2125-DESC-CODE-ITEM-STATUS.                                              
REARCH*                                                                         
REARCH*    MOVE '2125'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CODE-ITEM-STATUS    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CODE-ITEM-STATUS   TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-ITEM-STATUS,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-ITEM-STATUS,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2125-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2130-DESC-METER-NO                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE METER-NO          RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
                                                                        
REARCH*2130-DESC-METER-NO.                                                      
REARCH*                                                                         
REARCH*    MOVE '2130'                          TO ACTIVE-PARAGRAPH.            
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-METER-NO           TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-METER-NO          TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-METER-NO,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-METER-NO,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2130-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2150-DESC-CURR-UNITS                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CURR-UNITS        RESULT FIELD TO THE CLIENT      *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*2150-DESC-CURR-UNITS.                                                    
REARCH*                                                                         
REARCH*    MOVE '2150'                          TO ACTIVE-PARAGRAPH.            
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CURR-UNITS         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CURR-UNITS        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CURR-UNITS,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CURR-UNITS,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2150-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2155-DESC-CURRENT-READING                                      *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CURRENT-READING FIELD TO THE CLIENT               *        
      ******************************************************************        
                                                                        
REARCH*2155-DESC-CURRENT-READING.                                               
REARCH*                                                                         
REARCH*    MOVE '2155'                        TO ACTIVE-PARAGRAPH.              
CVT999*    ADD  1                             TO CTR-COLUMN.                    
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
CVT999*    MOVE LENGTH OF RS-CURRENT-READING  TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-CURRENT-READING TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CURRENT-READING,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CURRENT-READING,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2155-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2162-DESC-PREV-READING                                         *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE PREVIOUS-READING  FIELD TO THE CLIENT             *        
      ******************************************************************        
                                                                        
REARCH*2162-DESC-PREV-READING.                                                  
REARCH*                                                                         
REARCH*    MOVE '2162'                         TO ACTIVE-PARAGRAPH.             
CVT999*    ADD  1                              TO CTR-COLUMN.                   
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
CVT999*    MOVE LENGTH OF RS-PREVIOUS-READING  TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-PREVIOUS-READING TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PREVIOUS-READING,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PREVIOUS-READING,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2162-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2166-DESC-PREV-READ-DATE                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE USAGE-SOURCE RESULT FIELD TO THE CLIENT           *        
      ******************************************************************        
                                                                        
REARCH*2166-DESC-PREV-READ-DATE.                                                
REARCH*                                                                         
REARCH*    MOVE '2166'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-PREV-READ-DATE      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-PREV-READ-DATE     TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PREV-READ-DATE,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PREV-READ-DATE,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2166-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2168-DESC-CONSTANT                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CONSTANT        RESULT FIELD TO THE CLIENT        *        
      ******************************************************************        
                                                                        
REARCH*2168-DESC-CONSTANT.                                                      
REARCH*                                                                         
REARCH*    MOVE '2168'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.               
CVT999*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CONSTANT            TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CONSTANT           TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CONSTANT,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CONSTANT,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +5 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2168-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2170-DESC-CODE-METER-READ                                      *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CODE-METER-READ    RESULT FIELD TO THE CLIENT     *        
      ******************************************************************        
                                                                        
REARCH*2170-DESC-CODE-METER-READ.                                               
REARCH*                                                                         
REARCH*    MOVE '2170'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CODE-METER-READ     TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CODE-METER-READ    TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-METER-READ,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-METER-READ,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2170-EXIT.                                                               
REARCH*    EXIT.                                                                
      ******************************************************************        
      * 2171-DESC-CODE-METER-NO-READ                                   *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CODE-METER-NO-READ RESULT FIELD TO THE CLIENT     *        
      ******************************************************************        
                                                                        
REARCH*2171-DESC-CODE-METER-NO-READ.                                            
REARCH*                                                                         
REARCH*    MOVE '2171'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CODE-METER-NO-READ  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CODE-METER-NO-READ TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-METER-NO-READ,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-METER-NO-READ,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2171-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2172-DESC-NO-DAYS                                              *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE NO-DAYS     FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2172-DESC-NO-DAYS.                                                       
REARCH*                                                                         
REARCH*    MOVE '2172'                       TO ACTIVE-PARAGRAPH.               
CVT999*    ADD +1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT2                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT2                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-NO-DAYS         TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-NO-DAYS        TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NO-DAYS,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NO-DAYS,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2172-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2174-DESC-MTR-REF-NO                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE NO-DAYS     FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2174-DESC-MTR-REF-NO.                                                    
REARCH*                                                                         
REARCH*    MOVE '2174'                       TO ACTIVE-PARAGRAPH.               
CVT999*    ADD +1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT2                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT2                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-MTR-REF-NO      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-MTR-REF-NO     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-REF-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-REF-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2174-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2176-DESC-MTR-READ-SOURCE-CD                                   *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE MTR-READ-SOURCE-CD RESULT FIELD TO THE CLIENT     *        
      ******************************************************************        
                                                                        
REARCH*2176-DESC-MTR-READ-SOURCE-CD.                                            
REARCH*                                                                         
REARCH*    MOVE '2176'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MTR-READ-SOURCE-CD  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MTR-READ-SOURCE-CD TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-READ-SOURCE-CD,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-READ-SOURCE-CD,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2176-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2178-DESC-CODE-TIME-PERIOD.                                    *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CODE-TIME-PERIOD      FIELD TO THE CLIENT         *        
      ******************************************************************        
                                                                        
REARCH*2178-DESC-CODE-TIME-PERIOD.                                              
REARCH*                                                                         
REARCH*    MOVE '2178'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD +1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT2                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT2                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CODE-TIME-PERIOD    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CODE-TIME-PERIOD   TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-TIME-PERIOD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-TIME-PERIOD,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2178-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2180-DESC-CODE-TOU-SEASN                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE CODE-TOU-SEASN     RESULT FIELD TO THE CLIENT     *        
      ******************************************************************        
                                                                        
REARCH*2180-DESC-CODE-TOU-SEASN.                                                
REARCH*                                                                         
REARCH*    MOVE '2180'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CODE-TOU-SEASN      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CODE-TOU-SEASN     TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-TOU-SEASN,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-TOU-SEASN,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2180-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2182-DESC-BILL-DATE                                            *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE BILL-DATE       RESULT FIELD TO THE CLIENT        *        
      ******************************************************************        
                                                                        
REARCH*2182-DESC-BILL-DATE.                                                     
REARCH*                                                                         
REARCH*    MOVE '2182'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-BILL-DATE           TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-BILL-DATE          TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BILL-DATE,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BILL-DATE,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2182-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2184-DESC-METER-DESC                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE METER-DESC      RESULT FIELD TO THE CLIENT        *        
      ******************************************************************        
                                                                        
REARCH*2184-DESC-METER-DESC.                                                    
REARCH*                                                                         
REARCH*    MOVE '2184'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-METER-DESC          TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-METER-DESC         TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-METER-DESC,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-METER-DESC,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2184-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2186-DESC-NO-DIALS                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           TDSETBCD                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE NO-DIALS        RESULT FIELD TO THE CLIENT        *        
      ******************************************************************        
                                                                        
REARCH*2186-DESC-NO-DIALS.                                                      
REARCH*                                                                         
REARCH*    MOVE '2186'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT2                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT2                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NO-DIALS            TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NO-DIALS           TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NO-DIALS,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NO-DIALS,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2186-EXIT.                                                               
REARCH*    EXIT.                                                                
T23632******************************************************************        
T23632* 2188-DESC-RATIO                                                *        
T23632*                                                                *        
T23632*     CALLS TDESCRIB                                             *        
T23632*           TDSETBCD                                             *        
T23632*           9100-CHECK-ERROR                                     *        
T23632*                                                                *        
T23632*     CALLED FROM 2100-DESCRIBE-RESULT                           *        
T23632*                                                                *        
T23632*     DESCRIBE RATIO           RESULT FIELD TO THE CLIENT        *        
T23632******************************************************************        
T23632                                                                  
REARCH*2188-DESC-RATIO.                                                         
REARCH*                                                                         
REARCH*    MOVE '2188'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.               
CVT999*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-RATIO               TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RATIO              TO WRKLEN2.                    
T23632                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATIO,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RATIO,                                     
CVT999*                          WRKLEN2.                                       
T23632                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T23632                                                                  
CVT999*    MOVE +3 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T23632                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*2188-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
T23632******************************************************************        
T27236* 2189-DESC-BTU-FACTOR                                           *        
T27236*                                                                *        
T27236*     CALLS TDESCRIB                                             *        
T27236*           TDSETBCD                                             *        
T27236*           9100-CHECK-ERROR                                     *        
T27236*                                                                *        
T27236*     CALLED FROM 2100-DESCRIBE-RESULT                           *        
T27236*                                                                *        
T27236*     DESCRIBE BTU-FACTOR      RESULT FIELD TO THE CLIENT        *        
T27236******************************************************************        
T27236                                                                  
REARCH*2189-DESC-BTU-FACTOR.                                                    
REARCH*                                                                         
REARCH*    MOVE '2189'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.               
CVT999*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-BTU-FACTOR          TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-BTU-FACTOR         TO WRKLEN2.                    
T27236                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BTU-FACTOR,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BTU-FACTOR,                                
CVT999*                          WRKLEN2.                                       
T27236                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T27236                                                                  
CVT999*    MOVE +5 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T27236                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*2189-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
T27236******************************************************************        
T27236* 2190-DESC-THERMS                                               *        
T27236*                                                                *        
T27236*     CALLS TDESCRIB                                             *        
T27236*           TDSETBCD                                             *        
T27236*           9100-CHECK-ERROR                                     *        
T27236*                                                                *        
T27236*     CALLED FROM 2100-DESCRIBE-RESULT                           *        
T27236*                                                                *        
T27236*     DESCRIBE THERMS RESULT FIELD TO THE CLIENT                 *        
T27236******************************************************************        
T27236                                                                  
REARCH*2190-DESC-THERMS.                                                        
REARCH*                                                                         
REARCH*    MOVE '2190'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.               
CVT999*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-THERMS              TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-THERMS             TO WRKLEN2.                    
T27236                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-THERMS,                                     
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-THERMS,                                    
CVT999*                          WRKLEN2.                                       
T27236                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T27236                                                                  
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T27236                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*2190-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
T30989******************************************************************        
T30989* 2191-DESC-PCOMP-FCT                                            *        
T30989*                                                                *        
T30989*     CALLS TDESCRIB                                             *        
T30989*           TDSETBCD                                             *        
T30989*           9100-CHECK-ERROR                                     *        
T30989*                                                                *        
T30989*     CALLED FROM 2100-DESCRIBE-RESULT                           *        
T30989*                                                                *        
T30989*     DESCRIBE PCOMP-FCT       RESULT FIELD TO THE CLIENT        *        
T30989******************************************************************        
T30989                                                                  
REARCH*2191-DESC-PCOMP-FCT.                                                     
REARCH*                                                                         
REARCH*    MOVE '2191'                           TO ACTIVE-PARAGRAPH.           
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.               
CVT999*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-PCOMP-FCT           TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-PCOMP-FCT          TO WRKLEN2.                    
T30989                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PCOMP-FCT,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PCOMP-FCT,                                 
CVT999*                          WRKLEN2.                                       
T30989                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T30989                                                                  
CVT999*    MOVE +5 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T30989                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*2191-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS 7000-SELECT-RATE-USE-SEASN                           *        
      *     CALLS 7100-SELECT-RATE-VRSN-DEF                            *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7700-OPEN-CX-CURSOR            THRU 7700-EXIT.       
                                                                        
T23632     MOVE ZERO                              TO WS-PREV-MTR-REF-NO.
                                                                        
           PERFORM 2210-PROCESS-FETCH             THRU 2210-EXIT        
             UNTIL WS-CX-ACTIVE-RETURN-CODE = NOT-FOUND.                
                                                                        
           PERFORM 7800-CLOSE-CX-CURSOR           THRU 7800-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-PROCESS-FETCH                                             *        
      *     CALLS       7000-FETCH-CONSUMPTION                         *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     READ EACH RETURNED ROW OF   CSS-DEMAND-RATCHET, FORMAT IT  *        
      *     AND SEND IT BACK                                           *        
      ******************************************************************        
                                                                        
       2210-PROCESS-FETCH.                                              
                                                                        
           PERFORM 7000-FETCH-CONSUMPTION         THRU 7000-EXIT.       
           PERFORM 2220-PROCESS-FORMAT            THRU 2220-EXIT.       
T23632     MOVE CX-MTR-REF-NO                     TO WS-PREV-MTR-REF-NO.
       2210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2220-PROCESS-FORAMT                                            *        
      *                                                                *        
      *     CALLS 7000-SELECT-RATE-USE-SEASN                           *        
      *     CALLS 7100-SELECT-RATE-VRSN-DEF                            *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2220-PROCESS-FORMAT.                                             
                                                                        
           IF WS-CX-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
             PERFORM 7100-SELECT-USAGE-TYPE                             
                                        THRU 7100-EXIT                  
             MOVE CX-DATE-READ          TO RS-DATE-READ                 
             MOVE CX-CODE-ITEM-STATUS   TO RS-CODE-ITEM-STATUS          
             MOVE CX-METER-NO           TO RS-METER-NO                  
             MOVE CX-MTR-REF-NO         TO RS-MTR-REF-NO                
             IF CX-NO-UNITS > ZERO                                      
               MOVE CX-NO-UNITS         TO RS-CURR-UNITS                
T23632***IF THIS IS A NEW METER, SET THE CORRECTED UNITS TO ZERO.               
T23632         IF CX-MTR-REF-NO NOT EQUAL  WS-PREV-MTR-REF-NO           
T23632         MOVE ZERO                TO WS-HOLD-CORR-UNITS           
T23632         END-IF                                                   
T23632                                                                  
T23632         IF CX-CODE-USAGE-TYPE ='C' AND                           
T23632            CX-CODE-USAGE-ID ='A'   AND                           
T23632            CX-CODE-USAGE-SOURCE ='B'                             
T23632***THIS IS CHECKING FOR 'CORRECTED USAGE'.                                
T23632            MOVE ZERO             TO RS-RATIO                     
T23632            MOVE CX-NO-UNITS      TO WS-HOLD-CORR-UNITS           
T23632                                                                  
T23632         ELSE                                                     
T23632***THIS IS CHECKING FOR 'UNCORRECTED USAGE'.                              
T23632             IF CX-CODE-USAGE-TYPE ='U' AND                       
T23632                CX-CODE-USAGE-SOURCE ='C'                         
T23632               IF WS-HOLD-CORR-UNITS > 0                          
T23632                  COMPUTE WS-RATIO =                              
T23632                  WS-HOLD-CORR-UNITS / CX-NO-UNITS                
T23632                  MOVE WS-RATIO   TO RS-RATIO                     
T23632               ELSE                                               
T23632                  MOVE ZERO       TO RS-RATIO                     
T23632               END-IF                                             
T23632             ELSE                                                 
T23632***THIS IS CHECKING FOR 'INTERNAL USAGE'.                                 
T23632               IF CX-CODE-USAGE-TYPE = 'I' AND                    
T23632                  CX-CODE-USAGE-SOURCE = 'C'                      
T23632                  IF WS-HOLD-CORR-UNITS > 0                       
T23632                     COMPUTE WS-RATIO =                           
T23632                     WS-HOLD-CORR-UNITS / CX-NO-UNITS             
T23632                     MOVE WS-RATIO                                
T23632                                  TO RS-RATIO                     
T23632                  ELSE                                            
T23632                     MOVE ZERO    TO RS-RATIO                     
T23632                  END-IF                                          
T23632               END-IF                                             
T23632             END-IF                                               
T23632         END-IF                                                   
T23632       ELSE                                                       
T23632         MOVE CX-NO-DEMAND-UNITS  TO RS-CURR-UNITS                
T23632         MOVE ZERO                TO RS-RATIO                     
T23632       END-IF                                                     
P00251     IF CX-CODE-DEBIT-CREDIT = 'C'                                
P00251        MULTIPLY RS-CURR-UNITS BY -1 GIVING RS-CURR-UNITS         
P00251     END-IF                                                       
           IF CX-DEMAND-READING > ZERO                                  
              MOVE CX-DEMAND-READING      TO WS-DEMAND-READING-CMP3     
              MOVE WS-DEMAND-READING-CMP3 TO WS-DEMAND-READING-NUM      
              MOVE WS-DEMAND-READING-NUM  TO WS-DEMAND-READING          
              MOVE WS-DEMAND-READING      TO RS-CURRENT-READING         
           ELSE                                                         
              MOVE CX-METER-READING       TO WS-METER-READING-CMP3      
              MOVE WS-METER-READING-CMP3  TO WS-METER-READING-NUM       
              MOVE WS-METER-READING-NUM   TO WS-METER-READING           
              MOVE WS-METER-READING       TO RS-CURRENT-READING         
           END-IF                                                       
           MOVE CX-CONSTANT           TO RS-CONSTANT                    
           MOVE CX-CODE-METER-READ    TO RS-CODE-METER-READ             
           MOVE CX-CODE-METER-NO-READ TO RS-CODE-METER-NO-READ          
           MOVE CX-NO-DAYS            TO RS-NO-DAYS                     
           MOVE CX-CODE-TIME-PERIOD   TO RS-CODE-TIME-PERIOD            
           MOVE CX-CODE-TOU-SEASN     TO RS-CODE-TOU-SEASN              
           MOVE CX-MTR-READ-SOURCE-CD TO RS-MTR-READ-SOURCE-CD          
T27236     MOVE CX-BTU-FACTOR         TO RS-BTU-FACTOR                  
T30989     MOVE CX-PCOMP-FCT          TO RS-PCOMP-FCT                   
T27236     IF WS-CODE-UTIL-TYPE = 'G'                                   
T27236        IF RS-BTU-FACTOR = 0                                      
T27236           PERFORM 7400-SELECT-BG-BTU-FACTOR                      
T27236                                THRU 7400-EXIT                    
T27236           COMPUTE RS-THERMS ROUNDED = CX-NO-UNITS * BG-BTU-FACTOR
T27236           MOVE BG-BTU-FACTOR   TO RS-BTU-FACTOR                  
T27236         ELSE                                                     
T27236           COMPUTE RS-THERMS ROUNDED = CX-NO-UNITS * RS-BTU-FACTOR
T27236         END-IF                                                   
T27236     END-IF                                                       
           PERFORM 7900-OPEN-PREV-CX-CURSOR THRU 7900-EXIT              
           PERFORM 7200-SELECT-PREV-USAGE   THRU 7200-EXIT              
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
              MOVE '0'                TO RS-PREVIOUS-READING            
            ELSE                                                        
              IF CX-DEMAND-READING > ZERO                               
                MOVE CX-DEMAND-READING     TO WS-DEMAND-READING-CMP3    
                MOVE WS-DEMAND-READING-CMP3 TO WS-DEMAND-READING-NUM    
                MOVE WS-DEMAND-READING-NUM  TO WS-DEMAND-READING        
                MOVE WS-DEMAND-READING     TO RS-PREVIOUS-READING       
              ELSE                                                      
                MOVE CX-METER-READING      TO WS-METER-READING-CMP3     
                MOVE WS-METER-READING-CMP3 TO WS-METER-READING-NUM      
                MOVE WS-METER-READING-NUM  TO WS-METER-READING          
                MOVE WS-METER-READING      TO RS-PREVIOUS-READING       
              END-IF                                                    
             END-IF                                                     
             PERFORM 7905-CLOSE-PREV-CX-CURSOR THRU 7905-EXIT           
             MOVE CX-NO-DIALS           TO RS-NO-DIALS                  
                                                                        
T17818*      MOVE WS-BILL-DATE          TO RS-BILL-DATE                         
T17818       MOVE WS-ACCOUNT-NO         TO BI-ACCOUNT-NO                
T17818       MOVE WS-BILL-NO            TO BI-BILL-NO                   
T17818       PERFORM 7300-SELECT-BILL-DATE THRU 7300-EXIT               
T17818       MOVE BI-DATE-BILLED        TO RS-BILL-DATE                 
             MOVE S5-METER-USAGE-DESC   TO RS-METER-DESC                
           ELSE                                                         
             GO TO  2220-EXIT                                           
           END-IF.                                                      
                                                                        
P00251     MOVE CX-CODE-USAGE-ID                  TO RS-CODE-USAGE-ID.  
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 7000-FETCH-CONSUMPTION                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE CSS_CNSMPTN_HIST WHERE       *         
      *     THE (FULL) KEY IS EQUAL TO THE PASSED PARAMETERS           *        
      ******************************************************************        
                                                                        
       7000-FETCH-CONSUMPTION.                                          
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
              FETCH  CX-CURSOR                                          
              INTO  :CX-CODE-UTIL-TYPE,                                 
                    :CX-DATE-READ,                                      
                    :CX-CODE-ITEM-STATUS,                               
                    :CX-METER-NO,                                       
                    :CX-CODE-USAGE-TYPE,                                
                    :CX-CODE-USAGE-ID,                                  
                    :CX-CODE-USAGE-SOURCE,                              
                    :CX-NO-UNITS,                                       
                    :CX-NO-DEMAND-UNITS,                                
                    :CX-METER-READING,                                  
                    :CX-DEMAND-READING,                                 
                    :CX-CONSTANT,                                       
                    :CX-CODE-METER-READ,                                
                    :CX-CODE-METER-NO-READ,                             
                    :CX-NO-DAYS,                                        
                    :RS-PREV-READ-DATE,                                 
                    :WS-PREV-READ-DATE,                                 
                    :CX-MTR-REF-NO,                                     
                    :CX-MTR-READ-SOURCE-CD,                             
                    :CX-CODE-TIME-PERIOD,                               
                    :CX-CODE-TOU-SEASN,                                 
                    :CX-ITEM-SEQ-NO,                                    
                    :CX-NO-DIALS,                                       
                    :WS-REG-ID-NO,                                      
                    :CX-BTU-FACTOR,                                     
C30989              :CX-PCOMP-FCT                                       
P00251             ,:CX-CODE-DEBIT-CREDIT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-CX-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-CX-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-USAGE-TYPE.                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7100-SELECT-USAGE-TYPE.                                          
                                                                        
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               SELECT     METER_USAGE_DESC                              
               INTO       :S5-METER-USAGE-DESC                          
               FROM       CSS_MTR_USAGE_VALS                            
               WHERE      CODE_USAGE_TYPE    =:CX-CODE-USAGE-TYPE       
               AND        CODE_USAGE_ID      =:CX-CODE-USAGE-ID         
               AND        CODE_USAGE_SOURCE  =:CX-CODE-USAGE-SOURCE     
               AND        CODE_UTIL_TYPE     =:CX-CODE-UTIL-TYPE        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTR_USAGE_VALS'       TO TABLE-1                
              MOVE 'CODE_USAGE_TYPE'          TO TABLE-ELEMENT-1        
              MOVE 'CODE_USAGE_ID'            TO TABLE-ELEMENT-2        
              MOVE 'CODE_USAGE_SOURCE'        TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
              MOVE CX-CODE-USAGE-TYPE         TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-USAGE-ID           TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-USAGE-SOURCE       TO HOSTVAR-ELEMENT-3      
CBSI          MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-PREV-USAGE.                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     SELECTS THE PREVIOUS USAGE FROM CONSUMPTION HISTORY        *        
      ******************************************************************        
                                                                        
       7200-SELECT-PREV-USAGE.                                          
                                                                        
           MOVE '7200'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
              FETCH  PREV-CX-CURSOR                                     
               INTO  :CX-METER-READING,                                 
                     :CX-DEMAND-READING,                                
                     :WS-HOLD-BILL-TIMESTMP                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'REG_ID_NO'                TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE WS-REG-ID-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
    ST* 7300-SELECT-BILL-DATE.                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7300-SELECT-BILL-DATE.                                           
                                                                        
           MOVE '7300'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               SELECT     CIS.CHAR2$DATE(DATE_BILLED,'USA')                   
               INTO       :BI-DATE-BILLED :WS-NULL-IND1                 
               FROM       CSS_BILLING_HDR                               
               WHERE      ACCOUNT_NO         =:BI-ACCOUNT-NO            
               AND        BILL_NO            =:BI-BILL-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT     CHAR(DATE(DATE_BILLED),USA)                           
MFA-TR*        INTO       :BI-DATE-BILLED :WS-NULL-IND1                         
MFA-TR*        FROM       CSS_BILLING_HDR                                       
MFA-TR*        WHERE      ACCOUNT_NO         =:BI-ACCOUNT-NO                    
MFA-TR*        AND        BILL_NO            =:BI-BILL-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES TO BI-DATE-BILLED                             
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BI-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
    ED 7300-EXIT.                                                       
T17818     EXIT.                                                        
T27236******************************************************************        
T27236* 7400-SELECT-BG-BTU-FACTOR.                                     *        
T27236*     CALLS       9000-SEND-ERROR-RESULT                         *        
T27236*                 9900-SQL-ERROR-ROUTINE                         *        
T27236*                                                                *        
T27236*     CALLED FROM 2200-BUILD-RESULT                              *        
T27236*                                                                *        
T27236*                                                                *        
T27236******************************************************************        
T27236                                                                  
T27236 7400-SELECT-BG-BTU-FACTOR.                                       
T27236                                                                  
T27236     MOVE '7300'               TO ACTIVE-PARAGRAPH.               
T27236     EXEC SQL                                                     
T27236         SELECT BTU_FACTOR                                        
T27236           INTO :BG-BTU-FACTOR                                    
T27236           FROM CSS_BILLING_DET                                   
T27236          WHERE ACCOUNT_NO         =:WS-ACCOUNT-NO                
T27236            AND BILL_NO            =:WS-BILL-NO                   
T27236            AND CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE            
T27236            AND IC_NO              =:WS-IC-NO                     
T27236            AND BILL_ITEM_TIMESTMP =CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )        
T27236     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BTU_FACTOR                                                
MFA-TR*          INTO :BG-BTU-FACTOR                                            
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO         =:WS-ACCOUNT-NO                        
MFA-TR*           AND BILL_NO            =:WS-BILL-NO                           
MFA-TR*           AND CODE_UTIL_TYPE     =:WS-CODE-UTIL-TYPE                    
MFA-TR*           AND IC_NO              =:WS-IC-NO                             
MFA-TR*           AND BILL_ITEM_TIMESTMP =:WS-BILL-ITEM-TIMESTMP                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27236                                                                  
T27236     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27236                                                                  
T27236     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27236        NEXT SENTENCE                                             
T27236     ELSE                                                         
T27236        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T27236        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T27236        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T27236                                           ABEND-TABLES           
T27236        MOVE 'CSS_BILLING_DET'          TO TABLE-1                
T27236        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T27236        MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
T27236        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
T27236        MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
T27236        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T27236        MOVE WS-BILL-NO                 TO HOSTVAR-ELEMENT-2      
T27236        MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
T27236        MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-4      
T27236        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T27236        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T27236     END-IF.                                                      
T27236 7400-EXIT.                                                       
T27236     EXIT.                                                        
      ******************************************************************        
      * 7700-OPEN-CX-CURSOR                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7700-OPEN-CX-CURSOR.                                             
                                                                        
           MOVE '7700'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              OPEN CX-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CLOSE-CX-CURSOR                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7800-CLOSE-CX-CURSOR.                                            
                                                                        
           MOVE '7800'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              CLOSE  CX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-OPEN-PREV-CX-CURSOR                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7900-OPEN-PREV-CX-CURSOR.                                        
                                                                        
           MOVE '7900'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              OPEN PREV-CX-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'REG_ID_NO'                TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE WS-REG-ID-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7905-CLOSE-PREV-CX-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7905-CLOSE-PREV-CX-CURSOR.                                       
                                                                        
           MOVE '7905'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              CLOSE  PREV-CX-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'REG_ID_NO'                TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE WS-REG-ID-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7905-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02089_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,DATE_READ                                                 
CVT000       ,CODE_ITEM_STATUS                                          
CVT000       ,METER_NO                                                  
CVT000       ,CURR_UNITS                                                
CVT000       ,CURRENT_READING                                           
CVT000       ,PREVIOUS_READING                                          
CVT000       ,PREV_READ_DATE                                            
CVT000       ,CONSTANT                                                  
CVT000       ,CODE_METER_READ                                           
CVT000       ,CODE_METER_NO_READ                                        
CVT000       ,NO_DAYS                                                   
CVT000       ,MTR_REF_NO                                                
CVT000       ,MTR_READ_SOURCE_CD                                        
CVT000       ,CODE_TIME_PERIOD                                          
CVT000       ,CODE_TOU_SEASN                                            
CVT000       ,BILL_DATE                                                 
CVT000       ,METER_DESC                                                
CVT000       ,NO_DIALS                                                  
CVT000       ,RATIO                                                     
CVT000       ,BTU_FACTOR                                                
CVT000       ,THERMS                                                    
CVT000       ,PCOMP_FCT                                                 
P00251       ,CODE_USAGE_ID                                             
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :S-RETURN-CODE                                            
CVT000       ,:S-DATE-READ                                              
CVT000       ,:S-CODE-ITEM-STATUS                                       
CVT000       ,:S-METER-NO                                               
CVT000       ,:S-CURR-UNITS                                             
CVT000       ,:S-CURRENT-READING                                        
CVT000       ,:S-PREVIOUS-READING                                       
CVT000       ,:S-PREV-READ-DATE                                         
CVT000       ,:S-CONSTANT                                               
CVT000       ,:S-CODE-METER-READ                                        
CVT000       ,:S-CODE-METER-NO-READ                                     
CVT000       ,:S-NO-DAYS                                                
CVT000       ,:S-MTR-REF-NO                                             
CVT000       ,:S-MTR-READ-SOURCE-CD                                     
CVT000       ,:S-CODE-TIME-PERIOD                                       
CVT000       ,:S-CODE-TOU-SEASN                                         
CVT000       ,:S-BILL-DATE                                              
CVT000       ,:S-METER-DESC                                             
CVT000       ,:S-NO-DIALS                                               
CVT000       ,:S-RATIO                                                  
CVT000       ,:S-BTU-FACTOR                                             
CVT000       ,:S-THERMS                                                 
CVT000       ,:S-PCOMP-FCT                                              
P00251       ,:S-CODE-USAGE-ID                                          
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02089_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,DATE_READ                                                         
MFA-TR*      ,CODE_ITEM_STATUS                                                  
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,CURR_UNITS                                                        
MFA-TR*      ,CURRENT_READING                                                   
MFA-TR*      ,PREVIOUS_READING                                                  
MFA-TR*      ,PREV_READ_DATE                                                    
MFA-TR*      ,CONSTANT                                                          
MFA-TR*      ,CODE_METER_READ                                                   
MFA-TR*      ,CODE_METER_NO_READ                                                
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,MTR_REF_NO                                                        
MFA-TR*      ,MTR_READ_SOURCE_CD                                                
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,CODE_TOU_SEASN                                                    
MFA-TR*      ,BILL_DATE                                                         
MFA-TR*      ,METER_DESC                                                        
MFA-TR*      ,NO_DIALS                                                          
MFA-TR*      ,RATIO                                                             
MFA-TR*      ,BTU_FACTOR                                                        
MFA-TR*      ,THERMS                                                            
MFA-TR*      ,PCOMP_FCT                                                         
MFA-TR*      ,CODE_USAGE_ID                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-DATE-READ                                                      
MFA-TR*      ,:S-CODE-ITEM-STATUS                                               
MFA-TR*      ,:S-METER-NO                                                       
MFA-TR*      ,:S-CURR-UNITS                                                     
MFA-TR*      ,:S-CURRENT-READING                                                
MFA-TR*      ,:S-PREVIOUS-READING                                               
MFA-TR*      ,:S-PREV-READ-DATE                                                 
MFA-TR*      ,:S-CONSTANT                                                       
MFA-TR*      ,:S-CODE-METER-READ                                                
MFA-TR*      ,:S-CODE-METER-NO-READ                                             
MFA-TR*      ,:S-NO-DAYS                                                        
MFA-TR*      ,:S-MTR-REF-NO                                                     
MFA-TR*      ,:S-MTR-READ-SOURCE-CD                                             
MFA-TR*      ,:S-CODE-TIME-PERIOD                                               
MFA-TR*      ,:S-CODE-TOU-SEASN                                                 
MFA-TR*      ,:S-BILL-DATE                                                      
MFA-TR*      ,:S-METER-DESC                                                     
MFA-TR*      ,:S-NO-DIALS                                                       
MFA-TR*      ,:S-RATIO                                                          
MFA-TR*      ,:S-BTU-FACTOR                                                     
MFA-TR*      ,:S-THERMS                                                         
MFA-TR*      ,:S-PCOMP-FCT                                                      
MFA-TR*      ,:S-CODE-USAGE-ID                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02089_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02089_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02089_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02089_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
