       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02087.                                     
COB303 DATE-WRITTEN.      MAY, 1995                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060001
      *                                                                *00070001
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080001
      *                                                                *00090001
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100001
      *                                                                *00110001
      *  TRANID:        S087                                           *00120001
      *  PROGRAM:       S087                                           *00130001
      *  CALLING SP:    PN_S087                                        *00140001
      *                                                                *00150001
      ******************************************************************00160001
      *                 P R O G R A M  S U M M A R Y                   *00170001
      *                                                                *00180001
      *  THIS PROGRAM RECEIVES PARMS FROM THE CALLING PROGRAM.  IT     *00190001
      *  WILL THEN USE THE PASSED INFORMATION TO ACCESS THE CONSUMPTION*00200001
      *  INFORMATION ON DB2,  EITHER CX OR UC DEPENDING ON THE IC.  IT *00201001
      *  WILL PASS THE CONSUMPTION INFO BACK TO POWERBUILDER.          *00201001
      ******************************************************************00210001
      *                                                                *00220001
      *                     PROGRAM MODIFICATION LOG                   *00230001
      *                                                                *00240001
      *    DATE    INITIALS   COMMENTS                                 *00250001
      *  --------  --------   ---------------------------------------  *00260001
      *  05/08/95    RAH      PROCEDURE ORIGINALLY CODED.              *00270001
T15519*  03/23/98    RGB      CHANGED PROGRAM TO WRITE MC05 WITH       *00270001
      *              CBSI     ACCOUNT NO AND OTHER PERTINENT INFO      *00310001
T15998*  04/21/98    RAH      MAKE PROGRAM HANDLE UNMETERED CONSUMPTION*00270001
      *                       ROWS WITH ELECTRIC OR GAS UTIL TYPES.    *00270001
T16694*  06/05/98    RAH      GETTING -811 ON CUST PLAN SELECT, MAKE   *00270001
      *                       THE SELECT GET A UNIQUE ROW.             *00270001
T17305*  08/03/98    RAH      UNMETERED DESCRIPTION SHOWING UP AS      *00270001
      *                       UNKNOWN.                                 *00270001
T18085*  10/08/98    RAH      GETTING -811 ON UM DESCRIPTION, MAKE     *00270001
      *                       THE SELECT GET A UNIQUE ROW.             *00270001
T19312*  03/16/99    RAH      GETTING -811 ON CSS_CUST_PLAN, ALLOW THAT*00270001
      *                       AND HANDLE THE RESULT.                   *00270001
BILGEN*  01/04/02   COVANSYS  ADDED BGEN-ACCT-IC-IND TO THE RESULT SET *        
BILGEN*             CHENNAI                                            *        
      *  08/08/02   COVANSYS  BILLGEN CHANGES REMOVED.                 *        
      *             CHENNAI                                            *        
C30989*  04/11/05   JS83520   ADD NEW COLUMN PCOMP_FCT TO RESULTSET    *        
REARCH*  09/21/05   CVNS      RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*             CHENNAI                                            *        
T35434*  10/10/07   MR97640   REPLACED MODEL_SQL WITH SET STATEMENT AND*00340001
T35434*                       ADDED WITH UR TO AVOID -911 ABENDS.      *00340001
T35434*                                                                *00340001
T36309*  06/26/08   SV95326   MOVE SPACES TO CUR_UC_DET_UPD FIELD      *        
P00251*  02/17/10   SB93596   IN RETURN CURSOR C1, ADDING A NEW COLUMN *        
P00251*                       AT THE END WHICH CONCATENATES THE THREE  *        
P00251*                       COLUMNS CODE_USAGE_TYPE,CODE_USAGE_ID    *        
P00251*                       AND CODE_USAGE_SOURCE.                   *        
A02912*  12/06/10   MN90523   ADD NEW COLUMN BILLEDUNITS_PERCENT TO RS *        
      ******************************************************************00330001
      *                                                                *00340001
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350001
      *                                                                *00360001
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370001
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380001
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390001
      *  3000 - 4999  NOT USED                                         *00400001
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410001
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420001
      *  7000 - 7999  OUTPUT MODULES                                   *00430001
      *  8000 - 8999  DB2 CALLS                                        *00440001
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450001
      *                                                                *00460001
      ******************************************************************00470001
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02087'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02087 STARTS HERE'.                  
                                                                        
      ******************************************************************00560001
      *    DB2 INCLUDES                                                *00570001
      ******************************************************************00580001
                                                                        
           EXEC SQL                                                     00600001
              INCLUDE SQLCA                                             00610001
           END-EXEC.                                                    00620001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBCNSMP                                           00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBCSTPLN                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBUMCNSM                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBBLLDET                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBBLLHDR                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBRTCRTR                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBUMPLAN                                          00930001
           END-EXEC.                                                    00940001
                                                                        
           EXEC SQL                                                     00920001
              INCLUDE TBUMEQP                                           00930001
           END-EXEC.                                                    00940001
                                                                        
      ******************************************************************01080001
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090001
      ******************************************************************01100001
                                                                        
           COPY CWS00303.                                               01170001
REARCH*    COPY CWS00010.                                               01150001
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CCA00001.                                               01140001
           COPY CWS00027.                                               01160001
REARCH*    COPY SYGWCOB.                                                01120001
REARCH*    COPY SYDBCOB.                                                01130001
                                                                        
           EXEC SQL                                                     01200001
              INCLUDE CWS00013                                          01210001
           END-EXEC.                                                    01220001
                                                                        
       01  WORK-VARIABLES.                                              
           03  WS-NO-ROWS              PIC S9(4) COMP.                  
           03  WS-DATE-READ-NULL       PIC S9(4) COMP.                  
           03  WS-DATE-USAGE-ENDS-NULL PIC S9(4) COMP.                  
           03  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           03  WS-CURRENT-DATE       PIC X(10).                         
                                                                        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH*    05  GWL-PROC                 POINTER.                        01540001
REARCH*    05  GWL-INIT-HANDLE          POINTER.                        01550001
           05  GWL-RC                   PIC S9(9) COMP.                 
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 01570001
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 01580001
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 01590001
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 01600001
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 01610001
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 01620001
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02087'.     
REARCH     05  WS-SQLSTATE              PIC X(05).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-BI-DATE-BILLED        PIC X(10).                      
           05  WS-BILL-NO               PIC S9(9) COMP.                 
           05  WS-BILL-NO-DEC           PIC 9(9).                       
           05  WS-TIMESTMP              PIC X(26).                      
           05  WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
           05  WS-IC-NO                 PIC S9(4) USAGE COMP.           
           05  WS-IC-NO-DEC             PIC 9(4).                       
           05  WS-DESCRIPTION           PIC X(17).                      
           05  WS-FIRST-RECORD          PIC X(1) VALUE 'Y'.             
REARCH     05  WS-FIRST-UC-RECORD       PIC X(1) VALUE 'N'.             
           05  WS-RATE-ITEM-CODE        PIC S9(4) USAGE COMP.           
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02087_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
REARCH*01  PARM-FIELDS.                                                 01650001
REARCH*    05  PARM-L                            PIC S9(9) COMP.        01660001
REARCH*    05  PARM-ID1                        PIC S9(9) COMP VALUE 1.  01670001
REARCH*    05  PARM-ACCOUNT-NO                   PIC X(13).             01730001
REARCH*    05  PARM-BILL-NO                      PIC X(9).              01740001
REARCH*    05  PARM-CODE-UTIL-TYPE               PIC X(1).              01750001
REARCH*    05  PARM-IC-NO                        PIC X(4).              01750001
REARCH*    05  PARM-BILL-ITEM-TIMESTAMP          PIC X(26).             01750001
REARCH*    05  PARM-BI-DATE-BILLED               PIC X(10).             01750001
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP.            
           05  RS-MTR-REF-NO           PIC S9(4) USAGE COMP.            
           05  RS-CODE-USAGE-TYPE      PIC X(1).                        
           05  RS-CODE-USAGE-ID        PIC X(1).                        
           05  RS-CODE-USAGE-SOURCE    PIC X(1).                        
           05  RS-ITEM-SEQ-NO          PIC S9(4) USAGE COMP.            
           05  RS-METER-NO             PIC X(9).                        
           05  RS-REG-ID-NO            PIC S9(4) USAGE COMP.            
           05  RS-DATE-READ            PIC X(10).                       
           05  RS-CODE-METER-READ      PIC X(1).                        
           05  RS-CODE-METER-NO-READ   PIC X(1).                        
COB305     05 RS-METER-READING        PIC S9(11)V USAGE COMP-3 VALUE 0.        
COB305     05 RS-DEMAND-READING        PIC S9(8)V9(3) USAGE COMP-3 
COB305       VALUE 0.     
           05  RS-EMPLOYEE-NO          PIC S9(9) USAGE COMP.            
COB305     05 RS-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
COB305     05 RS-NO-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.        
           05  RS-NO-DAYS              PIC S9(4) USAGE COMP.            
           05  RS-CODE-SOURCE-ID       PIC X(1).                        
           05  RS-CODE-DEBIT-CREDIT    PIC X(1).                        
           05  RS-CODE-ITEM-STATUS     PIC X(1).                        
           05  RS-CODE-DISCOUNT        PIC X(1).                        
COB305     05 RS-CONSTANT        PIC S9(6)V9(5) USAGE COMP-3 VALUE 0.     
           05  RS-NO-DIALS             PIC S9(4) USAGE COMP.            
           05  RS-COMPANY-NO           PIC X(2).                        
           05  RS-EXCEPT-OVERRIDE-CD   PIC X(1).                        
           05  RS-REQUESTED-USAGE      PIC S9(9) USAGE COMP.            
           05  RS-DIGTL-INTRL-MTR-NO   PIC X(18).                       
           05  RS-DIGTL-MTR-TYPE       PIC X(3).                        
           05  RS-CODE-TOU-SEASN       PIC X(1).                        
           05  RS-EXCL-DMD-RCHT-IND    PIC X(1).                        
           05  RS-MTR-READ-SOURCE-CD   PIC X(1).                        
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CHANGE-IND           PIC X(1) VALUE SPACE.            
COB305     05 RS-PCOMP-FCT        PIC S9(2)V9(5) USAGE COMP-3 VALUE 0.     
P00251     05  RS-CODE-USAGE-VALS      PIC X(3).                        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-CODE-TIME-PERIOD      PIC S9(4) USAGE COMP.            
REARCH     05  S-MTR-REF-NO            PIC S9(4) USAGE COMP.            
REARCH     05  S-CODE-USAGE-TYPE       PIC X(1).                        
REARCH     05  S-CODE-USAGE-ID         PIC X(1).                        
REARCH     05  S-CODE-USAGE-SOURCE     PIC X(1).                        
REARCH     05  S-ITEM-SEQ-NO           PIC S9(4) USAGE COMP.            
REARCH     05  S-METER-NO              PIC X(9).                        
REARCH     05  S-REG-ID-NO             PIC S9(4) USAGE COMP.            
REARCH     05  S-DATE-READ             PIC X(10).                       
REARCH     05  S-CODE-METER-READ       PIC X(1).                        
REARCH     05  S-CODE-METER-NO-READ    PIC X(1).                        
COB305     05 S-METER-READING        PIC S9(11)V USAGE COMP-3 VALUE 0.        
COB305     05 S-DEMAND-READING        PIC S9(8)V9(3) USAGE COMP-3 
COB305       VALUE 0.     
REARCH     05  S-EMPLOYEE-NO           PIC S9(9) USAGE COMP.            
COB305     05 S-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
COB305     05 S-NO-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
REARCH     05  S-NO-DAYS               PIC S9(4) USAGE COMP.            
REARCH     05  S-CODE-SOURCE-ID        PIC X(1).                        
REARCH     05  S-CODE-DEBIT-CREDIT     PIC X(1).                        
REARCH     05  S-CODE-ITEM-STATUS      PIC X(1).                        
REARCH     05  S-CODE-DISCOUNT         PIC X(1).                        
COB305     05 S-CONSTANT        PIC S9(6)V9(5) USAGE COMP-3 VALUE 0.     
REARCH     05  S-NO-DIALS              PIC S9(4) USAGE COMP.            
REARCH     05  S-COMPANY-NO            PIC X(2).                        
REARCH     05  S-EXCEPT-OVERRIDE-CD    PIC X(1).                        
REARCH     05  S-REQUESTED-USAGE       PIC S9(9) USAGE COMP.            
REARCH     05  S-DIGTL-INTRL-MTR-NO    PIC X(18).                       
REARCH     05  S-DIGTL-MTR-TYPE        PIC X(3).                        
REARCH     05  S-CODE-TOU-SEASN        PIC X(1).                        
REARCH     05  S-EXCL-DMD-RCHT-IND     PIC X(1).                        
REARCH     05  S-MTR-READ-SOURCE-CD    PIC X(1).                        
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-CHANGE-IND            PIC X(1) VALUE SPACE.            
COB305     05 S-PCOMP-FCT        PIC S9(2)V9(5) USAGE COMP-3 VALUE 0.     
P00251     05  S-CODE-USAGE-VALS       PIC X(3).                        
REARCH*01  CN-CX-COLUMN-NAMES.                                          02070001
REARCH*    05  CN-CODE-TIME-PERIOD      PIC X(16) VALUE                 02080001
REARCH*                                        'CODE_TIME_PERIOD'.      02090001
REARCH*    05  CN-MTR-REF-NO            PIC X(10) VALUE                 02080001
REARCH*                                        'MTR_REF_NO'.            02090001
REARCH*    05  CN-CODE-USAGE-TYPE       PIC X(15) VALUE                 02080001
REARCH*                                        'CODE_USAGE_TYPE'.       02090001
REARCH*    05  CN-CODE-USAGE-ID         PIC X(13) VALUE                 02080001
REARCH*                                        'CODE_USAGE_ID'.         02090001
REARCH*    05  CN-CODE-USAGE-SOURCE     PIC X(17) VALUE                 02080001
REARCH*                                        'CODE_USAGE_SOURCE'.     02090001
REARCH*    05  CN-ITEM-SEQ-NO           PIC X(11) VALUE                 02080001
REARCH*                                        'ITEM_SEQ_NO'.           02090001
REARCH*    05  CN-METER-NO              PIC X(08) VALUE                 02080001
REARCH*                                        'METER_NO'.              02090001
REARCH*    05  CN-REG-ID-NO             PIC X(09) VALUE                 02080001
REARCH*                                        'REG_ID_NO'.             02090001
REARCH*    05  CN-DATE-READ             PIC X(09) VALUE                 02080001
REARCH*                                        'DATE_READ'.             02090001
REARCH*    05  CN-CODE-METER-READ       PIC X(15) VALUE                 02080001
REARCH*                                        'CODE_METER_READ'.       02090001
REARCH*    05  CN-CODE-METER-NO-READ    PIC X(18) VALUE                 02080001
REARCH*                                        'CODE_METER_NO_READ'.    02090001
REARCH*    05  CN-METER-READING         PIC X(13) VALUE                 02080001
REARCH*                                        'METER_READING'.         02090001
REARCH*    05  CN-DEMAND-READING        PIC X(14) VALUE                 02080001
REARCH*                                        'DEMAND_READING'.        02090001
REARCH*    05  CN-EMPLOYEE-NO           PIC X(11) VALUE                 02080001
REARCH*                                        'EMPLOYEE_NO'.           02090001
REARCH*    05  CN-NO-UNITS              PIC X(08) VALUE                 02080001
REARCH*                                        'NO_UNITS'.              02090001
REARCH*    05  CN-NO-DEMAND-UNITS       PIC X(15) VALUE                 02080001
REARCH*                                        'NO_DEMAND_UNITS'.       02090001
REARCH*    05  CN-NO-DAYS               PIC X(07) VALUE                 02080001
REARCH*                                        'NO_DAYS'.               02090001
REARCH*    05  CN-CODE-SOURCE-ID        PIC X(14) VALUE                 02080001
REARCH*                                        'CODE_SOURCE_ID'.        02090001
REARCH*    05  CN-CODE-DEBIT-CREDIT     PIC X(17) VALUE                 02080001
REARCH*                                        'CODE_DEBIT_CREDIT'.     02090001
REARCH*    05  CN-CODE-ITEM-STATUS      PIC X(16) VALUE                 02080001
REARCH*                                        'CODE_ITEM_STATUS'.      02090001
REARCH*    05  CN-CODE-DISCOUNT         PIC X(13) VALUE                 02080001
REARCH*                                        'CODE_DISCOUNT'.         02090001
REARCH*    05  CN-CONSTANT              PIC X(08) VALUE                 02080001
REARCH*                                        'CONSTANT'.              02090001
REARCH*    05  CN-NO-DIALS              PIC X(08) VALUE                 02080001
REARCH*                                        'NO_DIALS'.              02090001
REARCH*    05  CN-COMPANY-NO            PIC X(10) VALUE                 02080001
REARCH*                                        'COMPANY_NO'.            02090001
REARCH*    05  CN-EXCEPT-OVERRIDE-CD    PIC X(18) VALUE                 02080001
REARCH*                                        'EXCEPT_OVERRIDE_CD'.    02090001
REARCH*    05  CN-REQUESTED-USAGE       PIC X(15) VALUE                 02080001
REARCH*                                        'REQUESTED_USAGE'.       02090001
REARCH*    05  CN-DIGTL-INTRL-MTR-NO    PIC X(18) VALUE                 02080001
REARCH*                                        'DIGTL_INTRL_MTR_NO'.    02090001
REARCH*    05  CN-DIGTL-MTR-TYPE        PIC X(14) VALUE                 02080001
REARCH*                                        'DIGTL_MTR_TYPE'.        02090001
REARCH*    05  CN-CODE-TOU-SEASN        PIC X(14) VALUE                 02080001
REARCH*                                        'CODE_TOU_SEASN'.        02090001
REARCH*    05  CN-EXCL-DMD-RCHT-IND     PIC X(17) VALUE                 02080001
REARCH*                                        'EXCL_DMD_RCHT_IND'.     02090001
REARCH*    05  CN-MTR-READ-SOURCE-CD    PIC X(18) VALUE                 02080001
REARCH*                                        'MTR_READ_SOURCE_CD'.    02090001
REARCH*    05  CN-RETURN-CODE           PIC X(11) VALUE                 02080001
REARCH*                                        'RETURN_CODE'.           02090001
REARCH*    05  CN-CHANGE-IND            PIC X(10) VALUE                 02080001
REARCH*                                        'CHANGE_IND'.            02090001
REARCH*    05  CN-PCOMP-FCT             PIC X(09) VALUE                 02080001
REARCH*                                        'PCOMP_FCT'.             02090001
                                                                        
       01  TDS-UC-RETURN-FIELDS.                                        
           05  RS-UM-DESCRIPTION       PIC X(17).                       
           05  RS-RATE-ITEM-CODE       PIC S9(4) USAGE COMP.            
           05  RS-UC-ITEM-SEQ-NO       PIC S9(4) USAGE COMP.            
           05  RS-NO-UC-UNITS          PIC S9(9) USAGE COMP.            
           05  RS-NO-UC-DAYS           PIC S9(4) USAGE COMP.            
           05  RS-UC-CODE-DEBIT-CREDIT PIC X(1).                        
COB305     05 RS-USAGE-FIXED        PIC S9(9)V USAGE COMP-3 VALUE 0.         
           05  RS-DATE-USAGE-ENDS      PIC X(10).                       
           05  RS-CODE-SERVICE-TYPE    PIC X(1).                        
           05  RS-UC-CODE-ITEM-STATUS  PIC X(1).                        
           05  RS-UC-CODE-SOURCE-ID    PIC X(1).                        
COB305     05 RS-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  RS-DIST-NO              PIC X(3).                        
           05  RS-LIGHT-NO             PIC S9(4) USAGE COMP.            
           05  RS-POLE-NO              PIC X(7).                        
           05  RS-UC-RETURN-CODE       PIC S9(9) COMP VALUE 0.          
           05  RS-UC-CHANGE-IND        PIC X(1) VALUE SPACE.            
                                                                        
REARCH 01  GTT-UC-RETURN-FIELDS.                                        
REARCH     05  S-UM-DESCRIPTION        PIC X(17).                       
REARCH     05  S-RATE-ITEM-CODE        PIC S9(4) USAGE COMP.            
REARCH     05  S-UC-ITEM-SEQ-NO        PIC S9(4) USAGE COMP.            
REARCH     05  S-NO-UC-UNITS           PIC S9(9) USAGE COMP.            
REARCH     05  S-NO-UC-DAYS            PIC S9(4) USAGE COMP.            
REARCH     05  S-UC-CODE-DEBIT-CREDIT  PIC X(1).                        
COB305     05 S-USAGE-FIXED        PIC S9(9)V USAGE COMP-3 VALUE 0.         
REARCH     05  S-DATE-USAGE-ENDS       PIC X(10).                       
REARCH     05  S-CODE-SERVICE-TYPE     PIC X(1).                        
REARCH     05  S-UC-CODE-ITEM-STATUS   PIC X(1).                        
REARCH     05  S-UC-CODE-SOURCE-ID     PIC X(1).                        
COB305     05 S-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
REARCH     05  S-DIST-NO               PIC X(3).                        
REARCH     05  S-LIGHT-NO              PIC S9(4) USAGE COMP.            
REARCH     05  S-POLE-NO               PIC X(7).                        
REARCH     05  S-UC-RETURN-CODE        PIC S9(9) COMP VALUE 0.          
REARCH     05  S-UC-CHANGE-IND         PIC X(1) VALUE SPACE.            
REARCH*01  CN-UC-COLUMN-NAMES.                                          02070001
REARCH*    05  CN-UM-DESCRIPTION        PIC X(11) VALUE                 02080001
REARCH*                                        'DESCRIPTION'.           02090001
REARCH*    05  CN-RATE-ITEM-CODE        PIC X(14) VALUE                 02080001
REARCH*                                        'RATE_ITEM_CODE'.        02090001
REARCH*    05  CN-UC-ITEM-SEQ-NO        PIC X(11) VALUE                 02080001
REARCH*                                        'ITEM-SEQ-NO'.           02090001
REARCH*    05  CN-NO-UC-UNITS           PIC X(08) VALUE                 02080001
REARCH*                                        'NO_UNITS'.              02090001
REARCH*    05  CN-NO-UC-DAYS            PIC X(07) VALUE                 02080001
REARCH*                                        'NO_DAYS'.               02090001
REARCH*    05  CN-UC-CODE-DEBIT-CREDIT  PIC X(17) VALUE                 02080001
REARCH*                                        'CODE_DEBIT_CREDIT'.     02090001
REARCH*    05  CN-USAGE-FIXED           PIC X(11) VALUE                 02080001
REARCH*                                        'USAGE_FIXED'.           02090001
REARCH*    05  CN-DATE-USAGE-ENDS       PIC X(15) VALUE                 02080001
REARCH*                                        'DATE_USAGE_ENDS'.       02090001
REARCH*    05  CN-CODE-SERVICE-TYPE     PIC X(17) VALUE                 02080001
REARCH*                                        'CODE_SERVICE_TYPE'.     02090001
REARCH*    05  CN-UC-CODE-ITEM-STATUS   PIC X(16) VALUE                 02080001
REARCH*                                        'CODE_ITEM_STATUS'.      02090001
REARCH*    05  CN-UC-CODE-SOURCE-ID     PIC X(14) VALUE                 02080001
REARCH*                                        'CODE_SOURCE_ID'.        02090001
REARCH*    05  CN-MTHLY-AMOUNT-FIXED    PIC X(18) VALUE                 02080001
REARCH*                                        'MTHLY_AMOUNT_FIXED'.    02090001
REARCH*    05  CN-DIST-NO               PIC X(07) VALUE                 02080001
REARCH*                                        'DIST_NO'.               02090001
REARCH*    05  CN-LIGHT-NO              PIC X(08) VALUE                 02080001
REARCH*                                        'LIGHT_NO'.              02090001
REARCH*    05  CN-POLE-NO               PIC X(07) VALUE                 02080001
REARCH*                                        'POLE_NO'.               02090001
REARCH*    05  CN-UC-RETURN-CODE        PIC X(11) VALUE                 02080001
REARCH*                                        'RETURN_CODE'.           02090001
REARCH*    05  CN-UC-CHANGE-IND         PIC X(08) VALUE                 02080001
REARCH*                                        'UPD_CODE'.              02090001
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
      ******************************************************************        
      *  DECLARE CURSOR FOR CONSUMPTION HISTORY                        *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE CNSMPTN_HIST CURSOR FOR                         
                SELECT                                                  
                   CODE_TIME_PERIOD,                                    
                   MTR_REF_NO,                                          
                   CODE_USAGE_TYPE,                                     
                   CODE_USAGE_ID,                                       
                   CODE_USAGE_SOURCE,                                   
                   ITEM_SEQ_NO,                                         
                   METER_NO,                                            
                   REG_ID_NO,                                           
                   DATE_READ,                                           
                   CODE_METER_READ,                                     
                   CODE_METER_NO_READ,                                  
                   METER_READING,                                       
                   DEMAND_READING,                                      
                   EMPLOYEE_NO,                                         
                   NO_UNITS,                                            
                   NO_DEMAND_UNITS,                                     
                   NO_DAYS,                                             
                   CODE_SOURCE_ID,                                      
                   CODE_DEBIT_CREDIT,                                   
                   CODE_ITEM_STATUS,                                    
                   CODE_DISCOUNT,                                       
                   CONSTANT,                                            
                   NO_DIALS,                                            
                   COMPANY_NO,                                          
                   EXCEPT_OVERRIDE_CD,                                  
                   REQUESTED_USAGE,                                     
                   DIGTL_INTRL_MTR_NO,                                  
                   DIGTL_MTR_TYPE,                                      
                   CODE_TOU_SEASN,                                      
                   EXCL_DMD_RCHT_IND,                                   
                   MTR_READ_SOURCE_CD,                                  
                   PCOMP_FCT                                            
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO      AND      
                      BILL_NO            = :WS-BILL-NO         AND      
                      IC_NO              = :WS-IC-NO           AND      
                      CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE  AND      
                      BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                           :WS-TIMESTMP
              )                 
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CNSMPTN_HIST CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            MTR_REF_NO,                                                  
MFA-TR*            CODE_USAGE_TYPE,                                             
MFA-TR*            CODE_USAGE_ID,                                               
MFA-TR*            CODE_USAGE_SOURCE,                                           
MFA-TR*            ITEM_SEQ_NO,                                                 
MFA-TR*            METER_NO,                                                    
MFA-TR*            REG_ID_NO,                                                   
MFA-TR*            DATE_READ,                                                   
MFA-TR*            CODE_METER_READ,                                             
MFA-TR*            CODE_METER_NO_READ,                                          
MFA-TR*            METER_READING,                                               
MFA-TR*            DEMAND_READING,                                              
MFA-TR*            EMPLOYEE_NO,                                                 
MFA-TR*            NO_UNITS,                                                    
MFA-TR*            NO_DEMAND_UNITS,                                             
MFA-TR*            NO_DAYS,                                                     
MFA-TR*            CODE_SOURCE_ID,                                              
MFA-TR*            CODE_DEBIT_CREDIT,                                           
MFA-TR*            CODE_ITEM_STATUS,                                            
MFA-TR*            CODE_DISCOUNT,                                               
MFA-TR*            CONSTANT,                                                    
MFA-TR*            NO_DIALS,                                                    
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            EXCEPT_OVERRIDE_CD,                                          
MFA-TR*            REQUESTED_USAGE,                                             
MFA-TR*            DIGTL_INTRL_MTR_NO,                                          
MFA-TR*            DIGTL_MTR_TYPE,                                              
MFA-TR*            CODE_TOU_SEASN,                                              
MFA-TR*            EXCL_DMD_RCHT_IND,                                           
MFA-TR*            MTR_READ_SOURCE_CD,                                          
MFA-TR*            PCOMP_FCT                                                    
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*         WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO      AND              
MFA-TR*               BILL_NO            = :WS-BILL-NO         AND              
MFA-TR*               IC_NO              = :WS-IC-NO           AND              
MFA-TR*               CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE  AND              
MFA-TR*               BILL_ITEM_TIMESTMP = :WS-TIMESTMP                         
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR UNMETERED CONSUMPTION                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE UM_CNSMPT_HIST CURSOR FOR                       
                SELECT                                                  
                   RATE_ITEM_CODE,                                      
                   ITEM_SEQ_NO,                                         
                   NO_UNITS,                                            
                   NO_DAYS,                                             
                   CODE_DEBIT_CREDIT,                                   
                   USAGE_FIXED,                                         
                   DATE_USAGE_ENDS,                                     
                   CODE_SERVICE_TYPE,                                   
                   CODE_ITEM_STATUS,                                    
                   CODE_SOURCE_ID,                                      
                   MTHLY_AMOUNT_FIXED,                                  
                   DIST_NO,                                             
                   LIGHT_NO,                                            
                   POLE_NO                                              
                FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO     AND           
                      BILL_NO        = :WS-BILL-NO        AND           
                      CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND           
                      IC_NO          = :WS-IC-NO          AND           
                      BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                           :WS-TIMESTMP
              )                 
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE UM_CNSMPT_HIST CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*            RATE_ITEM_CODE,                                              
MFA-TR*            ITEM_SEQ_NO,                                                 
MFA-TR*            NO_UNITS,                                                    
MFA-TR*            NO_DAYS,                                                     
MFA-TR*            CODE_DEBIT_CREDIT,                                           
MFA-TR*            USAGE_FIXED,                                                 
MFA-TR*            DATE_USAGE_ENDS,                                             
MFA-TR*            CODE_SERVICE_TYPE,                                           
MFA-TR*            CODE_ITEM_STATUS,                                            
MFA-TR*            CODE_SOURCE_ID,                                              
MFA-TR*            MTHLY_AMOUNT_FIXED,                                          
MFA-TR*            DIST_NO,                                                     
MFA-TR*            LIGHT_NO,                                                    
MFA-TR*            POLE_NO                                                      
MFA-TR*         FROM CSS_UM_CNSMPT_HIST                                         
MFA-TR*         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO     AND                   
MFA-TR*               BILL_NO        = :WS-BILL-NO        AND                   
MFA-TR*               CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND                   
MFA-TR*               IC_NO          = :WS-IC-NO          AND           02110001
MFA-TR*               BILL_ITEM_TIMESTMP = :WS-TIMESTMP                 02120001
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    02130001
                                                                        
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACCOUNT-NO                   PIC X(13).                  
REARCH 01 PARM-BILL-NO                      PIC X(9).                   
REARCH 01 PARM-CODE-UTIL-TYPE               PIC X(1).                   
REARCH 01 PARM-IC-NO                        PIC X(4).                   
REARCH 01 PARM-BILL-ITEM-TIMESTAMP          PIC X(26).                  
REARCH 01 PARM-BI-DATE-BILLED               PIC X(10).                  
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-BILL-NO                            
REARCH                          PARM-CODE-UTIL-TYPE                     
REARCH                          PARM-IC-NO                              
REARCH                          PARM-BILL-ITEM-TIMESTAMP                
REARCH                          PARM-BI-DATE-BILLED.                    
                                                                        
      ******************************************************************02140001
      * 0000-MAINLINE                                                  *02150001
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160001
      ******************************************************************02170001
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290001
      * 0100-INITIALIZE                                                *02300001
      *                                                                *02310001
      *     1. RESET DB2 ERROR HANDLERS                                *02320001
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330001
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340001
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350001
      *                                                                *02360001
      ******************************************************************02370001
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                    02400001
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                   02400001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434                                                                  
T35434      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
T35434                                                                  
T35434      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T35434        NEXT SENTENCE                                             
T35434      ELSE                                                        
T35434         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
T35434         MOVE SQLCODE            TO ABEND-SQLCODE                 
T35434         MOVE 'SET DATE '        TO TABLE-1                       
T35434         PERFORM 9900-SQL-ERROR-ROUTINE                           
T35434                                 THRU     9900-EXIT               
T35434      END-IF.                                                     
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           INITIALIZE TDS-UC-RETURN-FIELDS.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     02450001
REARCH*                                                                 02460001
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     02470001
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         02480001
REARCH*                                                                 02490001
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      02500001
REARCH*                                                                 02510001
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02520001
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     02530001
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  02540001
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      02550001
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      02560001
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        02570001
REARCH*                                    RS-RETURN-CODE                       
REARCH*       PERFORM 8100-SEND-RESULT THRU 8100-EXIT                           
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            02580001
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            02590001
REARCH*    END-IF.                                                      02600001
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH         EXEC SQL                                                 
REARCH             DECLARE C1 CURSOR  FOR                    
REARCH             SELECT                                               
REARCH               CODE_TIME_PERIOD                                   
REARCH              ,MTR_REF_NO                                         
REARCH              ,LTRIM(RTRIM(CODE_USAGE_TYPE))       AS 
           CODE_USAGE_TYPE    
REARCH              ,LTRIM(RTRIM(CODE_USAGE_ID))         AS 
           CODE_USAGE_ID      
REARCH              ,LTRIM(RTRIM(CODE_USAGE_SOURCE))     AS 
           CODE_USAGE_SOURCE  
REARCH              ,ITEM_SEQ_NO                                        
REARCH              ,LTRIM(RTRIM(METER_NO))              AS METER_NO           
REARCH              ,REG_ID_NO                                          
REARCH              ,DATE_READ                                          
REARCH              ,LTRIM(RTRIM(CODE_METER_READ))       AS 
           CODE_METER_READ    
REARCH              ,LTRIM(RTRIM(CODE_METER_NO_READ))    AS 
           CODE_METER_NO_READ 
REARCH              ,METER_READING                                      
REARCH              ,DEMAND_READING                                     
REARCH              ,EMPLOYEE_NO                                        
REARCH              ,NO_UNITS                                           
REARCH              ,NO_DEMAND_UNITS                                    
REARCH              ,NO_DAYS                                            
REARCH              ,LTRIM(RTRIM(CODE_SOURCE_ID))        AS 
           CODE_SOURCE_ID     
REARCH              ,LTRIM(RTRIM(CODE_DEBIT_CREDIT))     AS 
           CODE_DEBIT_CREDIT  
REARCH              ,LTRIM(RTRIM(CODE_ITEM_STATUS))      AS 
           CODE_ITEM_STATUS   
REARCH              ,LTRIM(RTRIM(CODE_DISCOUNT))         AS 
           CODE_DISCOUNT      
REARCH              ,CONSTANT                                           
REARCH              ,NO_DIALS                                           
REARCH              ,LTRIM(RTRIM(COMPANY_NO))            AS COMPANY_NO         
REARCH              ,LTRIM(RTRIM(EXCEPT_OVERRIDE_CD))    AS 
           EXCEPT_OVERRIDE_CD 
REARCH              ,REQUESTED_USAGE                                    
REARCH              ,LTRIM(RTRIM(DIGTL_INTRL_MTR_NO))    AS 
           DIGTL_INTRL_MTR_NO 
REARCH              ,LTRIM(RTRIM(DIGTL_MTR_TYPE))        AS 
           DIGTL_MTR_TYPE     
REARCH              ,LTRIM(RTRIM(CODE_TOU_SEASN))        AS 
           CODE_TOU_SEASN     
REARCH              ,LTRIM(RTRIM(EXCL_DMD_RCHT_IND))     AS 
           EXCL_DMD_RCHT_IND  
REARCH              ,LTRIM(RTRIM(MTR_READ_SOURCE_CD))    AS 
           MTR_READ_SOURCE_CD 
REARCH              ,RETURN_CODE                                        
REARCH              ,LTRIM(RTRIM(CHANGE_IND))            AS CHANGE_IND         
REARCH              ,PCOMP_FCT                                          
T36309              ,' '                          AS CUR_UC_DET_UPD     
P00251              ,CODE_USAGE_VALS                                    
A02912              ,0                            AS BILLEDUNITS_PERCENT
REARCH             FROM                                                 
REARCH                 #CSR02087_R1                              
REARCH         END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*              CODE_TIME_PERIOD                                           
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,STRIP(CODE_USAGE_TYPE)       AS CODE_USAGE_TYPE            
MFA-TR*             ,STRIP(CODE_USAGE_ID)         AS CODE_USAGE_ID              
MFA-TR*             ,STRIP(CODE_USAGE_SOURCE)     AS CODE_USAGE_SOURCE          
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,STRIP(METER_NO)              AS METER_NO                   
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,STRIP(CODE_METER_READ)       AS CODE_METER_READ            
MFA-TR*             ,STRIP(CODE_METER_NO_READ)    AS CODE_METER_NO_READ         
MFA-TR*             ,METER_READING                                              
MFA-TR*             ,DEMAND_READING                                             
MFA-TR*             ,EMPLOYEE_NO                                                
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,NO_DEMAND_UNITS                                            
MFA-TR*             ,NO_DAYS                                                    
MFA-TR*             ,STRIP(CODE_SOURCE_ID)        AS CODE_SOURCE_ID             
MFA-TR*             ,STRIP(CODE_DEBIT_CREDIT)     AS CODE_DEBIT_CREDIT          
MFA-TR*             ,STRIP(CODE_ITEM_STATUS)      AS CODE_ITEM_STATUS           
MFA-TR*             ,STRIP(CODE_DISCOUNT)         AS CODE_DISCOUNT              
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*             ,STRIP(COMPANY_NO)            AS COMPANY_NO                 
MFA-TR*             ,STRIP(EXCEPT_OVERRIDE_CD)    AS EXCEPT_OVERRIDE_CD         
MFA-TR*             ,REQUESTED_USAGE                                            
MFA-TR*             ,STRIP(DIGTL_INTRL_MTR_NO)    AS DIGTL_INTRL_MTR_NO         
MFA-TR*             ,STRIP(DIGTL_MTR_TYPE)        AS DIGTL_MTR_TYPE             
MFA-TR*             ,STRIP(CODE_TOU_SEASN)        AS CODE_TOU_SEASN             
MFA-TR*             ,STRIP(EXCL_DMD_RCHT_IND)     AS EXCL_DMD_RCHT_IND          
MFA-TR*             ,STRIP(MTR_READ_SOURCE_CD)    AS MTR_READ_SOURCE_CD         
MFA-TR*             ,RETURN_CODE                                                
MFA-TR*             ,STRIP(CHANGE_IND)            AS CHANGE_IND                 
MFA-TR*             ,PCOMP_FCT                                                  
MFA-TR*             ,' '                          AS CUR_UC_DET_UPD             
MFA-TR*             ,CODE_USAGE_VALS                                            
MFA-TR*             ,0                            AS BILLEDUNITS_PERCENT        
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR02087_R1                                      
MFA-TR*        END-EXEC.                                                        
REARCH*                                                                         
REARCH         EXEC SQL                                                 
REARCH             DECLARE C2 CURSOR  FOR                    
REARCH             SELECT                                               
REARCH               LTRIM(RTRIM(UM_DESCRIPTION))        AS 
           UM_DESCRIPTION     
REARCH              ,RATE_ITEM_CODE                                     
REARCH              ,UC_ITEM_SEQ_NO                                     
REARCH              ,NO_UC_UNITS                                        
REARCH              ,NO_UC_DAYS                                         
REARCH              ,LTRIM(RTRIM(UC_CDE_DEBIT_CREDT))    AS 
           UC_CDE_DEBIT_CREDT 
REARCH              ,USAGE_FIXED                                        
REARCH              ,DATE_USAGE_ENDS                                    
REARCH              ,LTRIM(RTRIM(CODE_SERVICE_TYPE))     AS 
           CODE_SERVICE_TYPE  
REARCH              ,LTRIM(RTRIM(UC_CDE_ITEM_STATUS))    AS 
           UC_CDE_ITEM_STATUS 
REARCH              ,LTRIM(RTRIM(UC_CODE_SOURCE_ID))     AS 
           UC_CODE_SOURCE_ID  
REARCH              ,MTHLY_AMOUNT_FIXED                                 
REARCH              ,LTRIM(RTRIM(DIST_NO))               AS DIST_NO            
REARCH              ,LIGHT_NO                                           
REARCH              ,LTRIM(RTRIM(POLE_NO))               AS POLE_NO            
REARCH              ,UC_RETURN_CODE                                     
REARCH              ,LTRIM(RTRIM(UC_CHANGE_IND))         AS 
           UC_CHANGE_IND      
REARCH              ,' '                          AS CUR_UC_DET_UPD     
REARCH             FROM                                                 
REARCH                 #CSR02087_R2                              
REARCH         END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C2 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*              STRIP(UM_DESCRIPTION)        AS UM_DESCRIPTION             
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,UC_ITEM_SEQ_NO                                             
MFA-TR*             ,NO_UC_UNITS                                                
MFA-TR*             ,NO_UC_DAYS                                                 
MFA-TR*             ,STRIP(UC_CDE_DEBIT_CREDT)    AS UC_CDE_DEBIT_CREDT         
MFA-TR*             ,USAGE_FIXED                                                
MFA-TR*             ,DATE_USAGE_ENDS                                            
MFA-TR*             ,STRIP(CODE_SERVICE_TYPE)     AS CODE_SERVICE_TYPE          
MFA-TR*             ,STRIP(UC_CDE_ITEM_STATUS)    AS UC_CDE_ITEM_STATUS         
MFA-TR*             ,STRIP(UC_CODE_SOURCE_ID)     AS UC_CODE_SOURCE_ID          
MFA-TR*             ,MTHLY_AMOUNT_FIXED                                         
MFA-TR*             ,STRIP(DIST_NO)               AS DIST_NO                    
MFA-TR*             ,LIGHT_NO                                                   
MFA-TR*             ,STRIP(POLE_NO)               AS POLE_NO                    
MFA-TR*             ,UC_RETURN_CODE                                             
MFA-TR*             ,STRIP(UC_CHANGE_IND)         AS UC_CHANGE_IND              
MFA-TR*             ,' '                          AS CUR_UC_DET_UPD             
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR02087_R2                                      
MFA-TR*        END-EXEC.                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02087_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH        EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR02087_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR02087_R1
                 (                                                       
REARCH              CODE_TIME_PERIOD       SMALLINT                     
REARCH             ,MTR_REF_NO             SMALLINT                     
REARCH             ,CODE_USAGE_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_USAGE_ID CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,ITEM_SEQ_NO            SMALLINT                     
REARCH             ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,REG_ID_NO              SMALLINT                     
REARCH             ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,CODE_METER_READ CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_METER_NO_READ CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,METER_READING          DECIMAL(11,0)                
REARCH             ,DEMAND_READING         DECIMAL(11,3)                
REARCH             ,EMPLOYEE_NO            INT                      
REARCH             ,NO_UNITS               DECIMAL(9,0)                 
REARCH             ,NO_DEMAND_UNITS        DECIMAL(9,0)                 
REARCH             ,NO_DAYS                SMALLINT                     
REARCH             ,CODE_SOURCE_ID CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_DEBIT_CREDIT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_ITEM_STATUS CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_DISCOUNT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CONSTANT               DECIMAL(11,5)                
REARCH             ,NO_DIALS               SMALLINT                     
REARCH             ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,EXCEPT_OVERRIDE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,REQUESTED_USAGE        INT                      
REARCH             ,DIGTL_INTRL_MTR_NO CHAR(18)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,DIGTL_MTR_TYPE CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_TOU_SEASN CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,EXCL_DMD_RCHT_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,MTR_READ_SOURCE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,RETURN_CODE            INT                      
REARCH             ,CHANGE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,PCOMP_FCT              DECIMAL(7,5)                 
P00251             ,CODE_USAGE_VALS CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH          )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02087_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02087_R2'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH        EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR02087_R2')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR02087_R2
                 (                                                       
REARCH              UM_DESCRIPTION CHAR(17)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,RATE_ITEM_CODE       SMALLINT                       
REARCH             ,UC_ITEM_SEQ_NO       SMALLINT                       
REARCH             ,NO_UC_UNITS          SMALLINT                       
REARCH             ,NO_UC_DAYS           SMALLINT                       
REARCH             ,UC_CDE_DEBIT_CREDT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,USAGE_FIXED          DECIMAL(9,0)                   
REARCH             ,DATE_USAGE_ENDS CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,UC_CDE_ITEM_STATUS CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,UC_CODE_SOURCE_ID CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH             ,MTHLY_AMOUNT_FIXED   DECIMAL(11,2)                  
REARCH             ,DIST_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,LIGHT_NO             SMALLINT                       
REARCH             ,POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,UC_RETURN_CODE       INT                        
REARCH             ,UC_CHANGE_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH          )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000B-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000B-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02087_R2'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************02650001
      * 1000-PROCESS-INPUT                                             *02660001
      *                                                                *02670001
      *     1. RECEIVE PARMS.                                          *02680001
      *                                                                *02690001
      ******************************************************************02700001
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   02740001
           MOVE PARM-ACCOUNT-NO TO WS-ACCOUNT-NO.                       
           MOVE PARM-BILL-NO TO WS-BILL-NO-DEC.                         
           MOVE WS-BILL-NO-DEC TO WS-BILL-NO.                           
           MOVE PARM-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE.               
           MOVE PARM-IC-NO TO WS-IC-NO-DEC.                             
           MOVE WS-IC-NO-DEC TO WS-IC-NO.                               
           MOVE PARM-BILL-ITEM-TIMESTAMP TO WS-TIMESTMP.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02790001
      * 1100-RECEIVE-PARMS                                             *02800001
      *                                                                *02810001
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *02820001
      *                                                                *02830001
      ******************************************************************02840001
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              02860001
REARCH*                                                                 02870001
REARCH*    MOVE 1                            TO PARM-ID1.               02990001
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,           03330001
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-ACCOUNT-NO,                       03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*                                                                 03310001
REARCH*    ADD 1 TO PARM-ID1.                                           03320001
REARCH*    MOVE LENGTH OF PARM-BILL-NO TO MAX-LENGTH-PARM,              03330001
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-BILL-NO,                          03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*                                                                 03310001
REARCH*    ADD 1 TO PARM-ID1.                                           03320001
REARCH*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE TO MAX-LENGTH-PARM,       03330001
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-CODE-UTIL-TYPE,                   03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*                                                                 03310001
REARCH*    ADD 1 TO PARM-ID1.                                           03320001
REARCH*    MOVE LENGTH OF PARM-IC-NO TO MAX-LENGTH-PARM,                03330001
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-IC-NO,                            03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*                                                                 03310001
REARCH*    ADD 1 TO PARM-ID1.                                           03320001
REARCH*    MOVE LENGTH OF PARM-BILL-ITEM-TIMESTAMP                      03330001
REARCH*                         TO MAX-LENGTH-PARM,                             
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-BILL-ITEM-TIMESTAMP,              03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*                                                                 03310001
REARCH*    ADD 1 TO PARM-ID1.                                           03320001
REARCH*    MOVE LENGTH OF PARM-BI-DATE-BILLED                           03330001
REARCH*                         TO MAX-LENGTH-PARM,                             
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350001
REARCH*                          GWL-RC,                                03360001
REARCH*                          PARM-ID1,                              03370001
REARCH*                          PARM-BI-DATE-BILLED,                   03380001
REARCH*                          TDSCHAR,                               03390001
REARCH*                          MAX-LENGTH-PARM,                       03400001
REARCH*                          PARM-L.                                03410001
REARCH*                                                                 05080422
REARCH*1100-EXIT.                                                       05081001
REARCH*    EXIT.                                                        05090001
                                                                        
      ******************************************************************05110001
      * 2000-PROCESS-OUTPUT.                                           *05120001
      ******************************************************************05190001
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
T15998     MOVE WS-ACCOUNT-NO TO CP-ACCOUNT-NO.                         
T15998     MOVE WS-CODE-UTIL-TYPE TO CP-CODE-UTIL-TYPE.                 
T15998     MOVE WS-IC-NO TO CP-IC-NO.                                   
T15998     PERFORM 8225-SELECT-CUST-PLAN THRU 8225-EXIT.                
T15998     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
REARCH        MOVE 'Y' TO WS-FIRST-UC-RECORD                            
REARCH*       PERFORM 2100-DESCRIBE-UC-RESULT THRU 2100-EXIT            05230001
              PERFORM 8200-OPEN-UNMTRD-CNSMPTN THRU 8200-EXIT           
              PERFORM 8210-FETCH-UNMTRD-CNSMPTN THRU 8210-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T15519           MOVE 'N' TO WS-FIRST-RECORD                            
                 MOVE UC-RATE-ITEM-CODE TO WS-RATE-ITEM-CODE            
                 PERFORM 5130-LOAD-UNMTRD-CNSMPTN THRU 5130-EXIT        
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
                 PERFORM 8220-CLOSE-UNMTRD-CNSMPTN THRU 8220-EXIT       
              ELSE                                                      
                 PERFORM 8220-CLOSE-UNMTRD-CNSMPTN THRU  8220-EXIT      
              END-IF                                                    
           ELSE                                                         
REARCH*       PERFORM 2200-DESCRIBE-CX-RESULT THRU 2200-EXIT            05230001
              PERFORM 8000-OPEN-CNSMPTN-HIST THRU 8000-EXIT             
              PERFORM 8010-FETCH-CNSMPTN-HIST THRU 8010-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T15519           MOVE 'N' TO WS-FIRST-RECORD                            
                 PERFORM 5100-LOAD-MTRD-CNSMPTN THRU 5100-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                 PERFORM 8020-CLOSE-CNSMPTN-HIST THRU 8020-EXIT         
              ELSE                                                      
                 PERFORM 8020-CLOSE-CNSMPTN-HIST THRU 8020-EXIT         
              END-IF                                                    
           END-IF.                                                      
T15519     IF WS-FIRST-RECORD = 'Y'                                     
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T15519        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
REARCH     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH       IF (WS-FIRST-RECORD = 'N' AND WS-FIRST-UC-RECORD = 'N')    
REARCH          OR (WS-FIRST-RECORD = 'Y' AND WS-FIRST-UC-RECORD = 'N') 
REARCH         MOVE RS-CODE-TIME-PERIOD   TO S-CODE-TIME-PERIOD         
REARCH         MOVE RS-MTR-REF-NO         TO S-MTR-REF-NO               
REARCH         MOVE RS-CODE-USAGE-TYPE    TO S-CODE-USAGE-TYPE          
REARCH         MOVE RS-CODE-USAGE-ID      TO S-CODE-USAGE-ID            
REARCH         MOVE RS-CODE-USAGE-SOURCE  TO S-CODE-USAGE-SOURCE        
REARCH         MOVE RS-ITEM-SEQ-NO        TO S-ITEM-SEQ-NO              
REARCH         MOVE RS-METER-NO           TO S-METER-NO                 
REARCH         MOVE RS-REG-ID-NO          TO S-REG-ID-NO                
REARCH         MOVE RS-DATE-READ          TO S-DATE-READ                
REARCH         MOVE RS-CODE-METER-READ    TO S-CODE-METER-READ          
REARCH         MOVE RS-CODE-METER-NO-READ TO S-CODE-METER-NO-READ       
REARCH         MOVE RS-METER-READING      TO S-METER-READING            
REARCH         MOVE RS-DEMAND-READING     TO S-DEMAND-READING           
REARCH         MOVE RS-EMPLOYEE-NO        TO S-EMPLOYEE-NO              
REARCH         MOVE RS-NO-UNITS           TO S-NO-UNITS                 
REARCH         MOVE RS-NO-DEMAND-UNITS    TO S-NO-DEMAND-UNITS          
REARCH         MOVE RS-NO-DAYS            TO S-NO-DAYS                  
REARCH         MOVE RS-CODE-SOURCE-ID     TO S-CODE-SOURCE-ID           
REARCH         MOVE RS-CODE-DEBIT-CREDIT  TO S-CODE-DEBIT-CREDIT        
REARCH         MOVE RS-CODE-ITEM-STATUS   TO S-CODE-ITEM-STATUS         
REARCH         MOVE RS-CODE-DISCOUNT      TO S-CODE-DISCOUNT            
REARCH         MOVE RS-CONSTANT           TO S-CONSTANT                 
REARCH         MOVE RS-NO-DIALS           TO S-NO-DIALS                 
REARCH         MOVE RS-COMPANY-NO         TO S-COMPANY-NO               
REARCH         MOVE RS-EXCEPT-OVERRIDE-CD TO S-EXCEPT-OVERRIDE-CD       
REARCH         MOVE RS-REQUESTED-USAGE    TO S-REQUESTED-USAGE          
REARCH         MOVE RS-DIGTL-INTRL-MTR-NO TO S-DIGTL-INTRL-MTR-NO       
REARCH         MOVE RS-DIGTL-MTR-TYPE       TO S-DIGTL-MTR-TYPE         
REARCH         MOVE RS-CODE-TOU-SEASN       TO S-CODE-TOU-SEASN         
REARCH         MOVE RS-EXCL-DMD-RCHT-IND    TO S-EXCL-DMD-RCHT-IND      
REARCH         MOVE RS-MTR-READ-SOURCE-CD   TO S-MTR-READ-SOURCE-CD     
REARCH         MOVE RS-RETURN-CODE          TO S-RETURN-CODE            
REARCH         MOVE RS-CHANGE-IND           TO S-CHANGE-IND             
REARCH         MOVE RS-PCOMP-FCT            TO S-PCOMP-FCT              
P00251         MOVE RS-CODE-USAGE-VALS      TO S-CODE-USAGE-VALS        
REARCH       ELSE                                                       
REARCH         MOVE RS-UM-DESCRIPTION       TO S-UM-DESCRIPTION         
REARCH         MOVE RS-RATE-ITEM-CODE       TO S-RATE-ITEM-CODE         
REARCH         MOVE RS-UC-ITEM-SEQ-NO       TO S-UC-ITEM-SEQ-NO         
REARCH         MOVE RS-NO-UC-UNITS          TO S-NO-UC-UNITS            
REARCH         MOVE RS-NO-UC-DAYS           TO S-NO-UC-DAYS             
REARCH         MOVE RS-UC-CODE-DEBIT-CREDIT TO S-UC-CODE-DEBIT-CREDIT   
REARCH         MOVE RS-USAGE-FIXED          TO S-USAGE-FIXED            
REARCH         MOVE RS-DATE-USAGE-ENDS      TO S-DATE-USAGE-ENDS        
REARCH         MOVE RS-CODE-SERVICE-TYPE    TO S-CODE-SERVICE-TYPE      
REARCH         MOVE RS-UC-CODE-ITEM-STATUS  TO S-UC-CODE-ITEM-STATUS    
REARCH         MOVE RS-UC-CODE-SOURCE-ID    TO S-UC-CODE-SOURCE-ID      
REARCH         MOVE RS-MTHLY-AMOUNT-FIXED   TO S-MTHLY-AMOUNT-FIXED     
REARCH         MOVE RS-DIST-NO              TO S-DIST-NO                
REARCH         MOVE RS-LIGHT-NO             TO S-LIGHT-NO               
REARCH         MOVE RS-POLE-NO              TO S-POLE-NO                
REARCH         MOVE RS-UC-RETURN-CODE       TO S-UC-RETURN-CODE         
REARCH         MOVE RS-UC-CHANGE-IND        TO S-UC-CHANGE-IND          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************01993000
      *  DESCRIBE THE RESULT SET FOR UNMETERED CONSUMPTION             *01995000
      ******************************************************************02000000
                                                                        
REARCH*2100-DESCRIBE-UC-RESULT.                                         01992000
REARCH*                                                                 05370001
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             05390001
REARCH*                                                                 02001000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UM-DESCRIPTION TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-UM-DESCRIPTION TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UM-DESCRIPTION,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UM-DESCRIPTION,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD 1 TO CTR-COLUMN.                                         02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-RATE-ITEM-CODE TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-RATE-ITEM-CODE TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-RATE-ITEM-CODE,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-RATE-ITEM-CODE,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UC-ITEM-SEQ-NO TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-UC-ITEM-SEQ-NO TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UC-ITEM-SEQ-NO,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UC-ITEM-SEQ-NO,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-UC-UNITS TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-NO-UC-UNITS TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-UC-UNITS,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-UC-UNITS,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-UC-DAYS TO WRKLEN1.                     02001000
REARCH*    MOVE LENGTH OF CN-NO-UC-DAYS TO WRKLEN2.                     02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-UC-DAYS,                         02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-UC-DAYS,                         02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UC-CODE-DEBIT-CREDIT TO WRKLEN1.           02001000
REARCH*    MOVE LENGTH OF CN-UC-CODE-DEBIT-CREDIT TO WRKLEN2.           02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UC-CODE-DEBIT-CREDIT,               02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UC-CODE-DEBIT-CREDIT,               02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           02001000
REARCH*    MOVE LENGTH OF RS-USAGE-FIXED TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-USAGE-FIXED TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-USAGE-FIXED,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-USAGE-FIXED,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +0 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DATE-USAGE-ENDS TO WRKLEN1.                02001000
REARCH*    MOVE LENGTH OF CN-DATE-USAGE-ENDS TO WRKLEN2.                02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DATE-USAGE-ENDS,                    02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DATE-USAGE-ENDS,                    02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-SERVICE-TYPE TO WRKLEN1.              02001000
REARCH*    MOVE LENGTH OF CN-CODE-SERVICE-TYPE TO WRKLEN2.              02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-SERVICE-TYPE,                  02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-SERVICE-TYPE,                  02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UC-CODE-ITEM-STATUS TO WRKLEN1.            02001000
REARCH*    MOVE LENGTH OF CN-UC-CODE-ITEM-STATUS TO WRKLEN2.            02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UC-CODE-ITEM-STATUS,                02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UC-CODE-ITEM-STATUS,                02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UC-CODE-SOURCE-ID TO WRKLEN1.              02001000
REARCH*    MOVE LENGTH OF CN-UC-CODE-SOURCE-ID TO WRKLEN2.              02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UC-CODE-SOURCE-ID,                  02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UC-CODE-SOURCE-ID,                  02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           02001000
REARCH*    MOVE LENGTH OF RS-MTHLY-AMOUNT-FIXED TO WRKLEN1.             02001000
REARCH*    MOVE LENGTH OF CN-MTHLY-AMOUNT-FIXED TO WRKLEN2.             02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-MTHLY-AMOUNT-FIXED,                 02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-MTHLY-AMOUNT-FIXED,                 02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +2 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DIST-NO TO WRKLEN1.                        02001000
REARCH*    MOVE LENGTH OF CN-DIST-NO TO WRKLEN2.                        02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DIST-NO,                            02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DIST-NO,                            02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1 TO CTR-COLUMN.                                        02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-LIGHT-NO TO WRKLEN1.                       02001000
REARCH*    MOVE LENGTH OF CN-LIGHT-NO TO WRKLEN2.                       02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-LIGHT-NO,                           02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-LIGHT-NO,                           02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-POLE-NO TO WRKLEN1.                        02001000
REARCH*    MOVE LENGTH OF CN-POLE-NO TO WRKLEN2.                        02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-POLE-NO,                            02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-POLE-NO,                            02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-RETURN-CODE,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-RETURN-CODE,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-UC-CHANGE-IND TO WRKLEN1.                  02001000
REARCH*    MOVE LENGTH OF CN-UC-CHANGE-IND TO WRKLEN2.                  02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-UC-CHANGE-IND,                      02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-UC-CHANGE-IND,                      02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*2100-EXIT.                                                       05620001
REARCH*    EXIT.                                                        05630001
                                                                        
      ******************************************************************01993000
      *  DESCRIBE THE RESULT SET FOR METERED CONSUMPTION               *01995000
      ******************************************************************02000000
                                                                        
REARCH*2200-DESCRIBE-CX-RESULT.                                         01992000
REARCH*                                                                 05370001
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             05390001
REARCH*                                                                 02001000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-TIME-PERIOD TO WRKLEN1.               02001000
REARCH*    MOVE LENGTH OF CN-CODE-TIME-PERIOD TO WRKLEN2.               02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-TIME-PERIOD,                   02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-TIME-PERIOD,                   02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-MTR-REF-NO TO WRKLEN1.                     02001000
REARCH*    MOVE LENGTH OF CN-MTR-REF-NO TO WRKLEN2.                     02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-MTR-REF-NO,                         02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-MTR-REF-NO,                         02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-USAGE-TYPE TO WRKLEN1.                02001000
REARCH*    MOVE LENGTH OF CN-CODE-USAGE-TYPE TO WRKLEN2.                02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-USAGE-TYPE,                    02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-USAGE-TYPE,                    02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-USAGE-ID TO WRKLEN1.                  02001000
REARCH*    MOVE LENGTH OF CN-CODE-USAGE-ID TO WRKLEN2.                  02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-USAGE-ID,                      02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-USAGE-ID,                      02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-USAGE-SOURCE TO WRKLEN1.              02001000
REARCH*    MOVE LENGTH OF CN-CODE-USAGE-SOURCE TO WRKLEN2.              02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-USAGE-SOURCE,                  02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-USAGE-SOURCE,                  02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-ITEM-SEQ-NO TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-ITEM-SEQ-NO TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-ITEM-SEQ-NO,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-ITEM-SEQ-NO,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-METER-NO TO WRKLEN1.                       02001000
REARCH*    MOVE LENGTH OF CN-METER-NO TO WRKLEN2.                       02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-METER-NO,                           02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-METER-NO,                           02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-REG-ID-NO TO WRKLEN1.                      02001000
REARCH*    MOVE LENGTH OF CN-REG-ID-NO TO WRKLEN2.                      02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-REG-ID-NO,                          02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-REG-ID-NO,                          02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DATE-READ TO WRKLEN1.                      02001000
REARCH*    MOVE LENGTH OF CN-DATE-READ TO WRKLEN2.                      02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DATE-READ,                          02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DATE-READ,                          02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-METER-READ TO WRKLEN1.                02001000
REARCH*    MOVE LENGTH OF CN-CODE-METER-READ TO WRKLEN2.                02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-METER-READ,                    02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-METER-READ,                    02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-METER-NO-READ TO WRKLEN1.             02001000
REARCH*    MOVE LENGTH OF CN-CODE-METER-NO-READ TO WRKLEN2.             02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-METER-NO-READ,                 02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-METER-NO-READ,                 02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-METER-READING TO WRKLEN1.                  02001000
REARCH*    MOVE LENGTH OF CN-METER-READING TO WRKLEN2.                  02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-METER-READING,                      02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-METER-READING,                      02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +0 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1 TO CTR-COLUMN.                                        02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DEMAND-READING TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-DEMAND-READING TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DEMAND-READING,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DEMAND-READING,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +3 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-EMPLOYEE-NO TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-EMPLOYEE-NO TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-EMPLOYEE-NO,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-EMPLOYEE-NO,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-UNITS TO WRKLEN1.                       02001000
REARCH*    MOVE LENGTH OF CN-NO-UNITS TO WRKLEN2.                       02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-UNITS,                           02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-UNITS,                           02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +0 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-DEMAND-UNITS TO WRKLEN1.                02001000
REARCH*    MOVE LENGTH OF CN-NO-DEMAND-UNITS TO WRKLEN2.                02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-DEMAND-UNITS,                    02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-DEMAND-UNITS,                    02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +0 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-DAYS TO WRKLEN1.                        02001000
REARCH*    MOVE LENGTH OF CN-NO-DAYS TO WRKLEN2.                        02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-DAYS,                            02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-DAYS,                            02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-SOURCE-ID TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-CODE-SOURCE-ID TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-SOURCE-ID,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-SOURCE-ID,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-DEBIT-CREDIT TO WRKLEN1.              02001000
REARCH*    MOVE LENGTH OF CN-CODE-DEBIT-CREDIT TO WRKLEN2.              02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-DEBIT-CREDIT,                  02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-DEBIT-CREDIT,                  02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-ITEM-STATUS TO WRKLEN1.               02001000
REARCH*    MOVE LENGTH OF CN-CODE-ITEM-STATUS TO WRKLEN2.               02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-ITEM-STATUS,                   02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-ITEM-STATUS,                   02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-DISCOUNT TO WRKLEN1.                  02001000
REARCH*    MOVE LENGTH OF CN-CODE-DISCOUNT TO WRKLEN2.                  02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-DISCOUNT,                      02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-DISCOUNT,                      02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CONSTANT TO WRKLEN1.                       02001000
REARCH*    MOVE LENGTH OF CN-CONSTANT TO WRKLEN2.                       02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CONSTANT,                           02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CONSTANT,                           02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +5 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT2 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-NO-DIALS TO WRKLEN1.                       02001000
REARCH*    MOVE LENGTH OF CN-NO-DIALS TO WRKLEN2.                       02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-NO-DIALS,                           02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-NO-DIALS                            02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-COMPANY-NO TO WRKLEN1.                     02001000
REARCH*    MOVE LENGTH OF CN-COMPANY-NO TO WRKLEN2.                     02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-COMPANY-NO,                         02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-COMPANY-NO,                         02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-EXCEPT-OVERRIDE-CD TO WRKLEN1.             02001000
REARCH*    MOVE LENGTH OF CN-EXCEPT-OVERRIDE-CD TO WRKLEN2.             02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-EXCEPT-OVERRIDE-CD,                 02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-EXCEPT-OVERRIDE-CD,                 02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-REQUESTED-USAGE TO WRKLEN1.                02001000
REARCH*    MOVE LENGTH OF CN-REQUESTED-USAGE TO WRKLEN2.                02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-REQUESTED-USAGE,                    02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-REQUESTED-USAGE,                    02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DIGTL-INTRL-MTR-NO TO WRKLEN1.             02001000
REARCH*    MOVE LENGTH OF CN-DIGTL-INTRL-MTR-NO TO WRKLEN2.             02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DIGTL-INTRL-MTR-NO,                 02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DIGTL-INTRL-MTR-NO,                 02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-DIGTL-MTR-TYPE TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-DIGTL-MTR-TYPE TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-DIGTL-MTR-TYPE,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-DIGTL-MTR-TYPE,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CODE-TOU-SEASN TO WRKLEN1.                 02001000
REARCH*    MOVE LENGTH OF CN-CODE-TOU-SEASN TO WRKLEN2.                 02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CODE-TOU-SEASN,                     02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CODE-TOU-SEASN,                     02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-EXCL-DMD-RCHT-IND TO WRKLEN1.              02001000
REARCH*    MOVE LENGTH OF CN-EXCL-DMD-RCHT-IND TO WRKLEN2.              02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-EXCL-DMD-RCHT-IND,                  02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-EXCL-DMD-RCHT-IND,                  02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-MTR-READ-SOURCE-CD TO WRKLEN1.             02001000
REARCH*    MOVE LENGTH OF CN-MTR-READ-SOURCE-CD TO WRKLEN2.             02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-MTR-READ-SOURCE-CD,                 02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-MTR-READ-SOURCE-CD,                 02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    02001000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-RETURN-CODE,                        02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-RETURN-CODE,                        02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*                                                                         
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                02001000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-CHANGE-IND TO WRKLEN1.                     02001000
REARCH*    MOVE LENGTH OF CN-CHANGE-IND TO WRKLEN2.                     02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-CHANGE-IND,                         02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-CHANGE-IND,                         02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*    ADD  1       TO CTR-COLUMN.                                  02001000
REARCH*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             02001000
REARCH*    MOVE TDSFLT8 TO DB-CLIENT-TYPE.                              02001000
REARCH*    MOVE LENGTH OF RS-PCOMP-FCT TO WRKLEN1.                      02001000
REARCH*    MOVE LENGTH OF CN-PCOMP-FCT TO WRKLEN2.                      02001000
REARCH*                                                                 02001000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02001000
REARCH*                          GWL-RC,                                02001000
REARCH*                          CTR-COLUMN,                            02001000
REARCH*                          DB-HOST-TYPE,                          02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          RS-PCOMP-FCT,                          02001000
REARCH*                          DB-NULL-INDICATOR,                     02001000
REARCH*                          TDS-FALSE,                             02001000
REARCH*                          DB-CLIENT-TYPE,                        02001000
REARCH*                          WRKLEN1,                               02001000
REARCH*                          CN-PCOMP-FCT,                          02001000
REARCH*                          WRKLEN2.                               02001000
REARCH*                                                                 02001000
REARCH*     MOVE +5 TO WRKLEN2.                                         02001000
REARCH*     CALL 'TDSETBCD' USING GWL-PROC,                             02001000
REARCH*                           GWL-RC,                               02001000
REARCH*                           TDS-OBJECT-COL,                       02001000
REARCH*                           CTR-COLUMN,                           02001000
REARCH*                           WRKLEN1,                              02001000
REARCH*                           WRKLEN2.                              02001000
REARCH*                                                                 02001000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02001000
REARCH*                                                                 02001000
REARCH*2200-EXIT.                                                       05620001
REARCH*    EXIT.                                                        05630001
                                                                        
BILGEN******************************************************************        
      *   MOVE DB2 DATA TO RESULT SET FOR METERED CONSUMPTION                   
      ******************************************************************        
                                                                        
       5100-LOAD-MTRD-CNSMPTN.                                          
                                                                        
           MOVE CX-CODE-TIME-PERIOD TO RS-CODE-TIME-PERIOD.             
           MOVE CX-MTR-REF-NO TO RS-MTR-REF-NO.                         
           MOVE CX-CODE-USAGE-TYPE TO RS-CODE-USAGE-TYPE.               
           MOVE CX-CODE-USAGE-ID TO RS-CODE-USAGE-ID.                   
           MOVE CX-CODE-USAGE-SOURCE TO RS-CODE-USAGE-SOURCE.           
           MOVE CX-ITEM-SEQ-NO TO RS-ITEM-SEQ-NO.                       
           MOVE CX-METER-NO TO RS-METER-NO.                             
           MOVE CX-REG-ID-NO TO RS-REG-ID-NO.                           
           MOVE CX-DATE-READ TO RS-DATE-READ.                           
           MOVE CX-CODE-METER-READ TO RS-CODE-METER-READ.               
           MOVE CX-CODE-METER-NO-READ TO RS-CODE-METER-NO-READ.         
           MOVE CX-METER-READING TO RS-METER-READING.                   
           MOVE CX-DEMAND-READING TO RS-DEMAND-READING.                 
           MOVE CX-EMPLOYEE-NO TO RS-EMPLOYEE-NO.                       
           MOVE CX-NO-UNITS TO RS-NO-UNITS.                             
           MOVE CX-NO-DEMAND-UNITS TO RS-NO-DEMAND-UNITS.               
           MOVE CX-NO-DAYS TO RS-NO-DAYS.                               
           MOVE CX-CODE-SOURCE-ID TO RS-CODE-SOURCE-ID.                 
           MOVE CX-CODE-DEBIT-CREDIT TO RS-CODE-DEBIT-CREDIT.           
           MOVE CX-CODE-ITEM-STATUS TO RS-CODE-ITEM-STATUS.             
           MOVE CX-CODE-DISCOUNT TO RS-CODE-DISCOUNT.                   
           MOVE CX-CONSTANT TO RS-CONSTANT.                             
           MOVE CX-NO-DIALS TO RS-NO-DIALS.                             
           MOVE CX-COMPANY-NO TO RS-COMPANY-NO.                         
           MOVE CX-EXCEPT-OVERRIDE-CD TO RS-EXCEPT-OVERRIDE-CD.         
           MOVE CX-REQUESTED-USAGE TO RS-REQUESTED-USAGE.               
           MOVE CX-DIGTL-INTRL-MTR-NO TO RS-DIGTL-INTRL-MTR-NO.         
           MOVE CX-DIGTL-MTR-TYPE TO RS-DIGTL-MTR-TYPE.                 
           MOVE CX-CODE-TOU-SEASN TO RS-CODE-TOU-SEASN.                 
           MOVE CX-EXCL-DMD-RCHT-IND TO RS-EXCL-DMD-RCHT-IND.           
           MOVE CX-MTR-READ-SOURCE-CD TO RS-MTR-READ-SOURCE-CD.         
           MOVE CX-PCOMP-FCT TO RS-PCOMP-FCT.                           
P00251     STRING           CX-CODE-USAGE-TYPE                          
P00251                      CX-CODE-USAGE-ID                            
P00251                      CX-CODE-USAGE-SOURCE DELIMITED BY SIZE      
P00251                INTO  RS-CODE-USAGE-VALS.                         
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                      
           PERFORM 8010-FETCH-CNSMPTN-HIST THRU 8010-EXIT.              
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   MOVE DB2 DATA TO RESULT SET FOR UNMETERED CONSUMPTION                 
      ******************************************************************        
                                                                        
       5130-LOAD-UNMTRD-CNSMPTN.                                        
                                                                        
           PERFORM 8310-SELECT-UM-DESCRIPTION THRU 8310-EXIT.           
           MOVE WS-DESCRIPTION TO RS-UM-DESCRIPTION.                    
           MOVE UC-RATE-ITEM-CODE TO RS-RATE-ITEM-CODE.                 
           MOVE UC-ITEM-SEQ-NO TO RS-UC-ITEM-SEQ-NO.                    
           MOVE UC-NO-UNITS TO RS-NO-UC-UNITS.                          
           MOVE UC-NO-DAYS TO RS-NO-UC-DAYS.                            
           MOVE UC-CODE-DEBIT-CREDIT TO RS-UC-CODE-DEBIT-CREDIT.        
           MOVE UC-USAGE-FIXED TO RS-USAGE-FIXED.                       
           MOVE UC-DATE-USAGE-ENDS TO RS-DATE-USAGE-ENDS.               
           MOVE UC-CODE-SERVICE-TYPE TO RS-CODE-SERVICE-TYPE.           
           MOVE UC-CODE-ITEM-STATUS TO RS-UC-CODE-ITEM-STATUS.          
           MOVE UC-CODE-SOURCE-ID TO RS-UC-CODE-SOURCE-ID.              
           MOVE UC-MTHLY-AMOUNT-FIXED TO RS-MTHLY-AMOUNT-FIXED.         
           MOVE UC-DIST-NO TO RS-DIST-NO.                               
           MOVE UC-LIGHT-NO TO RS-LIGHT-NO.                             
           MOVE UC-POLE-NO TO RS-POLE-NO.                               
REARCH     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                      
           PERFORM 8210-FETCH-UNMTRD-CNSMPTN THRU 8210-EXIT.            
           MOVE UC-RATE-ITEM-CODE TO WS-RATE-ITEM-CODE.                 
                                                                        
       5130-EXIT.                                                       
           EXIT.                                                        
                                                                        
BILGEN******************************************************************        
      *   PERFORM SQL FUNCTIONS FOR CONSUMPTION HISTORY                         
      ******************************************************************        
                                                                        
          8000-OPEN-CNSMPTN-HIST.                                       
                                                                        
              EXEC SQL                                                  
                   OPEN CNSMPTN_HIST                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8000'          TO ACTIVE-PARAGRAPH               
                 MOVE 'OPEN CNSMPTN HIST' TO ABEND-FUNCTION             
T15519           MOVE 'CNS_MPTN_HIST'     TO TABLE-1                    
T15519           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
T15519           MOVE 'BILL_NO'           TO TABLE-ELEMENT-2            
T15519           MOVE 'IC_NO'             TO TABLE-ELEMENT-3            
T15519           MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-4            
T15519           MOVE  WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1          
T15519           MOVE  WS-BILL-NO         TO HOSTVAR-ELEMENT-2          
T15519           MOVE  WS-IC-NO           TO HOSTVAR-ELEMENT-3          
T15519           MOVE  WS-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-4          
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8000-EXIT.                                                    
              EXIT.                                                     
                                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH        MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.       
REARCH*                                                                         
REARCH        EXEC SQL                                                  
REARCH            DELETE FROM #CSR02087_R1                       
REARCH        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                          
MFA-TR*           DELETE FROM SESSION.CSR02087_R1                               
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.   
REARCH*                                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME          TO  ABEND-PROGRAM           
REARCH           MOVE SQLCODE             TO ABEND-SQLCODE              
REARCH           MOVE '8000A'             TO  ACTIVE-PARAGRAPH          
REARCH           MOVE 'DELETE'            TO  ABEND-FUNCTION            
REARCH           MOVE SPACES              TO  ABEND-SQL-PREDICATES      
REARCH                                          ABEND-TABLES            
REARCH           MOVE 'CSR02087_R1'       TO  TABLE-1                   
REARCH           MOVE SPACES              TO  TABLE-ELEMENT-1           
REARCH           MOVE SPACES              TO  HOSTVAR-ELEMENT-1         
REARCH           PERFORM 9000-SEND-ERROR-RESULT                         
REARCH                                      THRU 9000-EXIT              
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                      THRU 9900-EXIT              
REARCH        END-IF.                                                   
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH******************************************************************        
REARCH*8000B-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000B-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH        MOVE 'DELETE ROWS'          TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH        EXEC SQL                                                  
REARCH            DELETE FROM #CSR02087_R2                       
REARCH        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                          
MFA-TR*           DELETE FROM SESSION.CSR02087_R2                               
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH        MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME        TO  ABEND-PROGRAM             
REARCH           MOVE SQLCODE             TO ABEND-SQLCODE              
REARCH           MOVE '8000B'             TO  ACTIVE-PARAGRAPH          
REARCH           MOVE 'DELETE'            TO  ABEND-FUNCTION            
REARCH           MOVE SPACES              TO  ABEND-SQL-PREDICATES      
REARCH                                          ABEND-TABLES            
REARCH           MOVE 'CSR02087_R2'       TO  TABLE-1                   
REARCH           MOVE SPACES              TO  TABLE-ELEMENT-1           
REARCH           MOVE SPACES              TO  HOSTVAR-ELEMENT-1         
REARCH           PERFORM 9000-SEND-ERROR-RESULT                         
REARCH                                      THRU 9000-EXIT              
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                      THRU 9900-EXIT              
REARCH        END-IF.                                                   
REARCH*                                                                         
REARCH 8000B-EXIT.                                                      
REARCH      EXIT.                                                       
          8010-FETCH-CNSMPTN-HIST.                                      
                                                                        
              EXEC SQL                                                  
                 FETCH CNSMPTN_HIST INTO                                
                       :CX-CODE-TIME-PERIOD,                            
                       :CX-MTR-REF-NO,                                  
                       :CX-CODE-USAGE-TYPE,                             
                       :CX-CODE-USAGE-ID,                               
                       :CX-CODE-USAGE-SOURCE,                           
                       :CX-ITEM-SEQ-NO,                                 
                       :CX-METER-NO,                                    
                       :CX-REG-ID-NO,                                   
                       :CX-DATE-READ :WS-DATE-READ-NULL,                 
                       :CX-CODE-METER-READ,                             
                       :CX-CODE-METER-NO-READ,                          
                       :CX-METER-READING,                               
                       :CX-DEMAND-READING,                              
                       :CX-EMPLOYEE-NO,                                 
                       :CX-NO-UNITS,                                    
                       :CX-NO-DEMAND-UNITS,                             
                       :CX-NO-DAYS,                                     
                       :CX-CODE-SOURCE-ID,                              
                       :CX-CODE-DEBIT-CREDIT,                           
                       :CX-CODE-ITEM-STATUS,                            
                       :CX-CODE-DISCOUNT,                               
                       :CX-CONSTANT,                                    
                       :CX-NO-DIALS,                                    
                       :CX-COMPANY-NO,                                  
                       :CX-EXCEPT-OVERRIDE-CD,                          
                       :CX-REQUESTED-USAGE,                             
                       :CX-DIGTL-INTRL-MTR-NO,                          
                       :CX-DIGTL-MTR-TYPE,                              
                       :CX-CODE-TOU-SEASN,                              
                       :CX-EXCL-DMD-RCHT-IND,                           
                       :CX-MTR-READ-SOURCE-CD,                          
                       :CX-PCOMP-FCT                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
                  NEXT SENTENCE                                         
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8010'          TO ACTIVE-PARAGRAPH               
                 MOVE 'FETCH CNSMPTN HIST' TO ABEND-FUNCTION            
T15519           MOVE 'CNS_MPTN_HIST'     TO TABLE-1                    
T15519           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
T15519           MOVE 'BILL_NO'           TO TABLE-ELEMENT-2            
T15519           MOVE 'IC_NO'             TO TABLE-ELEMENT-3            
T15519           MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-4            
T15519           MOVE  WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1          
T15519           MOVE  WS-BILL-NO         TO HOSTVAR-ELEMENT-2          
T15519           MOVE  WS-IC-NO           TO HOSTVAR-ELEMENT-3          
T15519           MOVE  WS-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-4          
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8010-EXIT.                                                    
              EXIT.                                                     
                                                                        
          8020-CLOSE-CNSMPTN-HIST.                                      
                                                                        
              EXEC SQL                                                  
                   CLOSE CNSMPTN_HIST                                   
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8020'          TO ACTIVE-PARAGRAPH               
                 MOVE 'CLOSE CNSMPTN HIST' TO ABEND-FUNCTION            
T15519           MOVE 'CNS_MPTN_HIST'     TO TABLE-1                    
T15519           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
T15519           MOVE 'BILL_NO'           TO TABLE-ELEMENT-2            
T15519           MOVE 'IC_NO'             TO TABLE-ELEMENT-3            
T15519           MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-4            
T15519           MOVE  WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1          
T15519           MOVE  WS-BILL-NO         TO HOSTVAR-ELEMENT-2          
T15519           MOVE  WS-IC-NO           TO HOSTVAR-ELEMENT-3          
T15519           MOVE  WS-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-4          
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8020-EXIT.                                                    
              EXIT.                                                     
                                                                        
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      IF (WS-FIRST-RECORD = 'N' AND WS-FIRST-UC-RECORD = 'N')     
REARCH         OR (WS-FIRST-RECORD = 'Y' AND WS-FIRST-UC-RECORD = 'N')  
REARCH        EXEC SQL                                                  
REARCH             INSERT INTO #CSR02087_R1                      
REARCH             (                                                    
REARCH                  CODE_TIME_PERIOD                                
REARCH                 ,MTR_REF_NO                                      
REARCH                 ,CODE_USAGE_TYPE                                 
REARCH                 ,CODE_USAGE_ID                                   
REARCH                 ,CODE_USAGE_SOURCE                               
REARCH                 ,ITEM_SEQ_NO                                     
REARCH                 ,METER_NO                                        
REARCH                 ,REG_ID_NO                                       
REARCH                 ,DATE_READ                                       
REARCH                 ,CODE_METER_READ                                 
REARCH                 ,CODE_METER_NO_READ                              
REARCH                 ,METER_READING                                   
REARCH                 ,DEMAND_READING                                  
REARCH                 ,EMPLOYEE_NO                                     
REARCH                 ,NO_UNITS                                        
REARCH                 ,NO_DEMAND_UNITS                                 
REARCH                 ,NO_DAYS                                         
REARCH                 ,CODE_SOURCE_ID                                  
REARCH                 ,CODE_DEBIT_CREDIT                               
REARCH                 ,CODE_ITEM_STATUS                                
REARCH                 ,CODE_DISCOUNT                                   
REARCH                 ,CONSTANT                                        
REARCH                 ,NO_DIALS                                        
REARCH                 ,COMPANY_NO                                      
REARCH                 ,EXCEPT_OVERRIDE_CD                              
REARCH                 ,REQUESTED_USAGE                                 
REARCH                 ,DIGTL_INTRL_MTR_NO                              
REARCH                 ,DIGTL_MTR_TYPE                                  
REARCH                 ,CODE_TOU_SEASN                                  
REARCH                 ,EXCL_DMD_RCHT_IND                               
REARCH                 ,MTR_READ_SOURCE_CD                              
REARCH                 ,RETURN_CODE                                     
REARCH                 ,CHANGE_IND                                      
REARCH                 ,PCOMP_FCT                                       
P00251                 ,CODE_USAGE_VALS                                 
REARCH             )                                                    
REARCH             VALUES                                               
REARCH             (                                                    
REARCH                  :S-CODE-TIME-PERIOD                             
REARCH                 ,:S-MTR-REF-NO                                   
REARCH                 ,:S-CODE-USAGE-TYPE                              
REARCH                 ,:S-CODE-USAGE-ID                                
REARCH                 ,:S-CODE-USAGE-SOURCE                            
REARCH                 ,:S-ITEM-SEQ-NO                                  
REARCH                 ,:S-METER-NO                                     
REARCH                 ,:S-REG-ID-NO                                    
REARCH                 ,:S-DATE-READ                                    
REARCH                 ,:S-CODE-METER-READ                              
REARCH                 ,:S-CODE-METER-NO-READ                           
REARCH                 ,:S-METER-READING                                
REARCH                 ,:S-DEMAND-READING                               
REARCH                 ,:S-EMPLOYEE-NO                                  
REARCH                 ,:S-NO-UNITS                                     
REARCH                 ,:S-NO-DEMAND-UNITS                              
REARCH                 ,:S-NO-DAYS                                      
REARCH                 ,:S-CODE-SOURCE-ID                               
REARCH                 ,:S-CODE-DEBIT-CREDIT                            
REARCH                 ,:S-CODE-ITEM-STATUS                             
REARCH                 ,:S-CODE-DISCOUNT                                
REARCH                 ,:S-CONSTANT                                     
REARCH                 ,:S-NO-DIALS                                     
REARCH                 ,:S-COMPANY-NO                                   
REARCH                 ,:S-EXCEPT-OVERRIDE-CD                           
REARCH                 ,:S-REQUESTED-USAGE                              
REARCH                 ,:S-DIGTL-INTRL-MTR-NO                           
REARCH                 ,:S-DIGTL-MTR-TYPE                               
REARCH                 ,:S-CODE-TOU-SEASN                               
REARCH                 ,:S-EXCL-DMD-RCHT-IND                            
REARCH                 ,:S-MTR-READ-SOURCE-CD                           
REARCH                 ,:S-RETURN-CODE                                  
REARCH                 ,:S-CHANGE-IND                                   
REARCH                 ,:S-PCOMP-FCT                                    
P00251                 ,:S-CODE-USAGE-VALS                              
REARCH             )                                                    
REARCH             END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                          
MFA-TR*            INSERT INTO SESSION.CSR02087_R1                              
MFA-TR*            (                                                            
MFA-TR*                 CODE_TIME_PERIOD                                        
MFA-TR*                ,MTR_REF_NO                                              
MFA-TR*                ,CODE_USAGE_TYPE                                         
MFA-TR*                ,CODE_USAGE_ID                                           
MFA-TR*                ,CODE_USAGE_SOURCE                                       
MFA-TR*                ,ITEM_SEQ_NO                                             
MFA-TR*                ,METER_NO                                                
MFA-TR*                ,REG_ID_NO                                               
MFA-TR*                ,DATE_READ                                               
MFA-TR*                ,CODE_METER_READ                                         
MFA-TR*                ,CODE_METER_NO_READ                                      
MFA-TR*                ,METER_READING                                           
MFA-TR*                ,DEMAND_READING                                          
MFA-TR*                ,EMPLOYEE_NO                                             
MFA-TR*                ,NO_UNITS                                                
MFA-TR*                ,NO_DEMAND_UNITS                                         
MFA-TR*                ,NO_DAYS                                                 
MFA-TR*                ,CODE_SOURCE_ID                                          
MFA-TR*                ,CODE_DEBIT_CREDIT                                       
MFA-TR*                ,CODE_ITEM_STATUS                                        
MFA-TR*                ,CODE_DISCOUNT                                           
MFA-TR*                ,CONSTANT                                                
MFA-TR*                ,NO_DIALS                                                
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,EXCEPT_OVERRIDE_CD                                      
MFA-TR*                ,REQUESTED_USAGE                                         
MFA-TR*                ,DIGTL_INTRL_MTR_NO                                      
MFA-TR*                ,DIGTL_MTR_TYPE                                          
MFA-TR*                ,CODE_TOU_SEASN                                          
MFA-TR*                ,EXCL_DMD_RCHT_IND                                       
MFA-TR*                ,MTR_READ_SOURCE_CD                                      
MFA-TR*                ,RETURN_CODE                                             
MFA-TR*                ,CHANGE_IND                                              
MFA-TR*                ,PCOMP_FCT                                               
MFA-TR*                ,CODE_USAGE_VALS                                         
MFA-TR*            )                                                            
MFA-TR*            VALUES                                                       
MFA-TR*            (                                                            
MFA-TR*                 :S-CODE-TIME-PERIOD                                     
MFA-TR*                ,:S-MTR-REF-NO                                           
MFA-TR*                ,:S-CODE-USAGE-TYPE                                      
MFA-TR*                ,:S-CODE-USAGE-ID                                        
MFA-TR*                ,:S-CODE-USAGE-SOURCE                                    
MFA-TR*                ,:S-ITEM-SEQ-NO                                          
MFA-TR*                ,:S-METER-NO                                             
MFA-TR*                ,:S-REG-ID-NO                                            
MFA-TR*                ,:S-DATE-READ                                            
MFA-TR*                ,:S-CODE-METER-READ                                      
MFA-TR*                ,:S-CODE-METER-NO-READ                                   
MFA-TR*                ,:S-METER-READING                                        
MFA-TR*                ,:S-DEMAND-READING                                       
MFA-TR*                ,:S-EMPLOYEE-NO                                          
MFA-TR*                ,:S-NO-UNITS                                             
MFA-TR*                ,:S-NO-DEMAND-UNITS                                      
MFA-TR*                ,:S-NO-DAYS                                              
MFA-TR*                ,:S-CODE-SOURCE-ID                                       
MFA-TR*                ,:S-CODE-DEBIT-CREDIT                                    
MFA-TR*                ,:S-CODE-ITEM-STATUS                                     
MFA-TR*                ,:S-CODE-DISCOUNT                                        
MFA-TR*                ,:S-CONSTANT                                             
MFA-TR*                ,:S-NO-DIALS                                             
MFA-TR*                ,:S-COMPANY-NO                                           
MFA-TR*                ,:S-EXCEPT-OVERRIDE-CD                                   
MFA-TR*                ,:S-REQUESTED-USAGE                                      
MFA-TR*                ,:S-DIGTL-INTRL-MTR-NO                                   
MFA-TR*                ,:S-DIGTL-MTR-TYPE                                       
MFA-TR*                ,:S-CODE-TOU-SEASN                                       
MFA-TR*                ,:S-EXCL-DMD-RCHT-IND                                    
MFA-TR*                ,:S-MTR-READ-SOURCE-CD                                   
MFA-TR*                ,:S-RETURN-CODE                                          
MFA-TR*                ,:S-CHANGE-IND                                           
MFA-TR*                ,:S-PCOMP-FCT                                            
MFA-TR*                ,:S-CODE-USAGE-VALS                                      
MFA-TR*            )                                                            
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02087_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF                                                     
REARCH      ELSE                                                        
REARCH        EXEC SQL                                                  
REARCH             INSERT INTO #CSR02087_R2                      
REARCH             (                                                    
REARCH                  UM_DESCRIPTION                                  
REARCH                 ,RATE_ITEM_CODE                                  
REARCH                 ,UC_ITEM_SEQ_NO                                  
REARCH                 ,NO_UC_UNITS                                     
REARCH                 ,NO_UC_DAYS                                      
REARCH                 ,UC_CDE_DEBIT_CREDT                              
REARCH                 ,USAGE_FIXED                                     
REARCH                 ,DATE_USAGE_ENDS                                 
REARCH                 ,CODE_SERVICE_TYPE                               
REARCH                 ,UC_CDE_ITEM_STATUS                              
REARCH                 ,UC_CODE_SOURCE_ID                               
REARCH                 ,MTHLY_AMOUNT_FIXED                              
REARCH                 ,DIST_NO                                         
REARCH                 ,LIGHT_NO                                        
REARCH                 ,POLE_NO                                         
REARCH                 ,UC_RETURN_CODE                                  
REARCH                 ,UC_CHANGE_IND                                   
REARCH             )                                                    
REARCH             VALUES                                               
REARCH             (                                                    
REARCH                  :S-UM-DESCRIPTION                               
REARCH                 ,:S-RATE-ITEM-CODE                               
REARCH                 ,:S-UC-ITEM-SEQ-NO                               
REARCH                 ,:S-NO-UC-UNITS                                  
REARCH                 ,:S-NO-UC-DAYS                                   
REARCH                 ,:S-UC-CODE-DEBIT-CREDIT                         
REARCH                 ,:S-USAGE-FIXED                                  
REARCH                 ,:S-DATE-USAGE-ENDS                              
REARCH                 ,:S-CODE-SERVICE-TYPE                            
REARCH                 ,:S-UC-CODE-ITEM-STATUS                          
REARCH                 ,:S-UC-CODE-SOURCE-ID                            
REARCH                 ,:S-MTHLY-AMOUNT-FIXED                           
REARCH                 ,:S-DIST-NO                                      
REARCH                 ,:S-LIGHT-NO                                     
REARCH                 ,:S-POLE-NO                                      
REARCH                 ,:S-UC-RETURN-CODE                               
REARCH                 ,:S-UC-CHANGE-IND                                
REARCH             )                                                    
REARCH             END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                          
MFA-TR*            INSERT INTO SESSION.CSR02087_R2                              
MFA-TR*            (                                                            
MFA-TR*                 UM_DESCRIPTION                                          
MFA-TR*                ,RATE_ITEM_CODE                                          
MFA-TR*                ,UC_ITEM_SEQ_NO                                          
MFA-TR*                ,NO_UC_UNITS                                             
MFA-TR*                ,NO_UC_DAYS                                              
MFA-TR*                ,UC_CDE_DEBIT_CREDT                                      
MFA-TR*                ,USAGE_FIXED                                             
MFA-TR*                ,DATE_USAGE_ENDS                                         
MFA-TR*                ,CODE_SERVICE_TYPE                                       
MFA-TR*                ,UC_CDE_ITEM_STATUS                                      
MFA-TR*                ,UC_CODE_SOURCE_ID                                       
MFA-TR*                ,MTHLY_AMOUNT_FIXED                                      
MFA-TR*                ,DIST_NO                                                 
MFA-TR*                ,LIGHT_NO                                                
MFA-TR*                ,POLE_NO                                                 
MFA-TR*                ,UC_RETURN_CODE                                          
MFA-TR*                ,UC_CHANGE_IND                                           
MFA-TR*            )                                                            
MFA-TR*            VALUES                                                       
MFA-TR*            (                                                            
MFA-TR*                 :S-UM-DESCRIPTION                                       
MFA-TR*                ,:S-RATE-ITEM-CODE                                       
MFA-TR*                ,:S-UC-ITEM-SEQ-NO                                       
MFA-TR*                ,:S-NO-UC-UNITS                                          
MFA-TR*                ,:S-NO-UC-DAYS                                           
MFA-TR*                ,:S-UC-CODE-DEBIT-CREDIT                                 
MFA-TR*                ,:S-USAGE-FIXED                                          
MFA-TR*                ,:S-DATE-USAGE-ENDS                                      
MFA-TR*                ,:S-CODE-SERVICE-TYPE                                    
MFA-TR*                ,:S-UC-CODE-ITEM-STATUS                                  
MFA-TR*                ,:S-UC-CODE-SOURCE-ID                                    
MFA-TR*                ,:S-MTHLY-AMOUNT-FIXED                                   
MFA-TR*                ,:S-DIST-NO                                              
MFA-TR*                ,:S-LIGHT-NO                                             
MFA-TR*                ,:S-POLE-NO                                              
MFA-TR*                ,:S-UC-RETURN-CODE                                       
MFA-TR*                ,:S-UC-CHANGE-IND                                        
MFA-TR*            )                                                            
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02087_R2'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF                                                     
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************        
      *   PERFORM SQL FUNCTIONS FOR UNMETERED CONSUMPTION                       
      ******************************************************************        
                                                                        
          8200-OPEN-UNMTRD-CNSMPTN.                                     
                                                                        
              EXEC SQL                                                  
                   OPEN UM_CNSMPT_HIST                                  
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE GWL-RC.             
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
T15998           OR NOT-FOUND                                           
T15998              NEXT SENTENCE                                       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '8200' TO ACTIVE-PARAGRAPH                        
                 MOVE 'OPEN UNMTRD CNSMPTN' TO ABEND-FUNCTION           
T15519           MOVE 'CNS_UM_CNSMPT_HIST'  TO TABLE-1                  
T15519           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T15519           MOVE 'BILL_NO'             TO TABLE-ELEMENT-2          
T15519           MOVE 'IC_NO'               TO TABLE-ELEMENT-3          
T15519           MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4          
T15519           MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
T15519           MOVE  WS-BILL-NO           TO HOSTVAR-ELEMENT-2        
T15519           MOVE  WS-IC-NO             TO HOSTVAR-ELEMENT-3        
T15519           MOVE  WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8200-EXIT.                                                    
              EXIT.                                                     
                                                                        
          8210-FETCH-UNMTRD-CNSMPTN.                                    
                                                                        
              EXEC SQL                                                  
                 FETCH UM_CNSMPT_HIST INTO                              
                         :UC-RATE-ITEM-CODE,                            
                         :UC-ITEM-SEQ-NO,                               
                         :UC-NO-UNITS,                                  
                         :UC-NO-DAYS,                                   
                         :UC-CODE-DEBIT-CREDIT,                         
                         :UC-USAGE-FIXED,                               
                         :UC-DATE-USAGE-ENDS :WS-DATE-USAGE-ENDS-NULL,   
                         :UC-CODE-SERVICE-TYPE,                         
                         :UC-CODE-ITEM-STATUS,                          
                         :UC-CODE-SOURCE-ID,                            
                         :UC-MTHLY-AMOUNT-FIXED,                        
                         :UC-DIST-NO,                                   
                         :UC-LIGHT-NO,                                  
                         :UC-POLE-NO                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE GWL-RC.             
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
                  NEXT SENTENCE                                         
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8210' TO ACTIVE-PARAGRAPH                        
                 MOVE 'FETCH UNMTRD CNSMPTN' TO ABEND-FUNCTION          
T15519           MOVE 'CNS_UM_CNSMPT_HIST'  TO TABLE-1                  
T15519           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T15519           MOVE 'BILL_NO'             TO TABLE-ELEMENT-2          
T15519           MOVE 'IC_NO'               TO TABLE-ELEMENT-3          
T15519           MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4          
T15519           MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
T15519           MOVE  WS-BILL-NO           TO HOSTVAR-ELEMENT-2        
T15519           MOVE  WS-IC-NO             TO HOSTVAR-ELEMENT-3        
T15519           MOVE  WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8210-EXIT.                                                    
              EXIT.                                                     
                                                                        
          8220-CLOSE-UNMTRD-CNSMPTN.                                    
                                                                        
              EXEC SQL                                                  
                   CLOSE UM_CNSMPT_HIST                                 
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE GWL-RC.             
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8220' TO ACTIVE-PARAGRAPH                        
                 MOVE 'CLOSE UNMTRD CNSMPTN' TO ABEND-FUNCTION          
T15519           MOVE 'CNS_UM_CNSMPT_HIST'  TO TABLE-1                  
T15519           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T15519           MOVE 'BILL_NO'             TO TABLE-ELEMENT-2          
T15519           MOVE 'IC_NO'               TO TABLE-ELEMENT-3          
T15519           MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4          
T15519           MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
T15519           MOVE  WS-BILL-NO           TO HOSTVAR-ELEMENT-2        
T15519           MOVE  WS-IC-NO             TO HOSTVAR-ELEMENT-3        
T15519           MOVE  WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF.        
                                                                        
          8220-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
T15998*   PERFORM SELECT ON CSS_CUST_PLAN TO DETERMINE IF WE ARE DEALING        
T15998*   WITH UNMETERED CONSUMPTION OR CONSUMPTION HISTORY                     
T15998******************************************************************        
                                                                        
T15998    8225-SELECT-CUST-PLAN.                                        
                                                                        
T15998        EXEC SQL                                                  
T16694          SELECT DISTINCT POLE_NO                                 
T15998             INTO :CP-POLE-NO                                     
T15998            FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
T15998        WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                     
T15998          AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                 
T15998          AND IC_NO          = :CP-IC-NO                          
T35434                                                           
T15998        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT DISTINCT POLE_NO                                 00040012
MFA-TR*            INTO :CP-POLE-NO                                     02400001
MFA-TR*           FROM CSS_CUST_PLAN                                    00050006
MFA-TR*       WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                     00110006
MFA-TR*         AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                 00120006
MFA-TR*         AND IC_NO          = :CP-IC-NO                          00130006
MFA-TR*        WITH UR                                                          
MFA-TR*       END-EXEC.                                                 02130001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15998        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE GWL-RC.             
T15998        IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
T19312           OR WS-ACTIVE-RETURN-CODE EQUAL TO -811                 
T19312              MOVE 0 TO WS-ACTIVE-RETURN-CODE                     
T15998        ELSE                                                      
T15998           IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND            
T15998              NEXT SENTENCE                                       
T15998           ELSE                                                   
T15998              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
REARCH              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT          
                    PERFORM 8100-SEND-RESULT THRU 8100-EXIT             
T15998              MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
T15998              MOVE '8225' TO ACTIVE-PARAGRAPH                     
T15998              MOVE 'SELECT CUST PLAN'      TO ABEND-FUNCTION      
T15998              MOVE 'CSS_CUST_PLAN'         TO TABLE-1             
T15998              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1     
T15998              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2     
T15998              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3     
T15998              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
T15998              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
                 END-IF
              END-IF.     
                                                                        
T15998    8225-EXIT.                                                    
T15998        EXIT.                                                     
                                                                        
      ******************************************************************        
      *   PERFORM SELECT FOR UNMETERED RATE DESCRIPTION                         
      ******************************************************************        
                                                                        
          8310-SELECT-UM-DESCRIPTION.                                   
                                                                        
              EXEC SQL                                                  
T18085          SELECT DISTINCT F.UM_EQUIP_SHRT_DESC                    
                   INTO :WS-DESCRIPTION                                 
                  FROM CSS_BILLING_HDR A WITH(READUNCOMMITTED),                 
                       CSS_BILLING_DET B WITH(READUNCOMMITTED),                 
                       CSS_UM_CNSMPT_HIST C WITH(READUNCOMMITTED),              
                       CSS_RATE_CREATOR D WITH(READUNCOMMITTED),                
                       CSS_UNMTR_PLAN E WITH(READUNCOMMITTED),                  
                       CSS_UM_EQUIPMENT F WITH(READUNCOMMITTED)                 
                  WHERE A.ACCOUNT_NO = :WS-ACCOUNT-NO                   
                    AND A.BILL_NO = :WS-BILL-NO                         
                    AND B.ACCOUNT_NO = A.ACCOUNT_NO                     
                    AND B.BILL_NO = A.BILL_NO                           
T17305              AND B.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE           
                    AND B.IC_NO = :WS-IC-NO                             
                    AND B.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                           :WS-TIMESTMP
              )             
                    AND C.ACCOUNT_NO = B.ACCOUNT_NO                     
                    AND C.BILL_NO = B.BILL_NO                           
                    AND C.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE             
                    AND C.IC_NO = B.IC_NO                               
                    AND C.BILL_ITEM_TIMESTMP = B.BILL_ITEM_TIMESTMP     
                    AND C.RATE_ITEM_CODE = :WS-RATE-ITEM-CODE           
                    AND D.CODE_STATUS <> 'T'                            
                    AND D.RATE_PLAN_NO = B.RATE_PLAN_NO                 
                    AND D.FROM_EFFECTIVE_DT =                           
                      (SELECT MAX(X.FROM_EFFECTIVE_DT)                  
                         FROM CSS_RATE_CREATOR X WITH(READUNCOMMITTED)          
                         WHERE X.RATE_PLAN_NO = D.RATE_PLAN_NO          
                           AND X.CODE_STATUS <> 'T'                     
                           AND ((B.DATE_ORIG_BILL IS NOT NULL           
                           AND (X.FROM_EFFECTIVE_DT <=                  
                                           B.DATE_ORIG_BILL))           
                               OR (B.DATE_ORIG_BILL IS NULL             
                           AND (X.FROM_EFFECTIVE_DT <=                  
                                            A.DATE_BILLED))))           
                    AND E.CODE_UTIL_TYPE = D.CODE_UTIL_TYPE             
                    AND E.RATE_PLAN_NO   = D.RATE_PLAN_NO               
                    AND E.VERSION_NO_CNTRL = D.VERSION_NO_CNTRL         
                    AND E.RATE_ITEM_CODE = C.RATE_ITEM_CODE             
                    AND F.UM_EQUIP_ID = E.UM_EQUIP_ID                   
T35434                                                           
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT DISTINCT F.UM_EQUIP_SHRT_DESC                    00040012
MFA-TR*            INTO :WS-DESCRIPTION                                 02400001
MFA-TR*           FROM CSS_BILLING_HDR A,                               00050006
MFA-TR*                CSS_BILLING_DET B,                               00060006
MFA-TR*                CSS_UM_CNSMPT_HIST C,                            00070007
MFA-TR*                CSS_RATE_CREATOR D,                              00080009
MFA-TR*                CSS_UNMTR_PLAN E,                                00090008
MFA-TR*                CSS_UM_EQUIPMENT F                               00100008
MFA-TR*           WHERE A.ACCOUNT_NO = :WS-ACCOUNT-NO                   00110006
MFA-TR*             AND A.BILL_NO = :WS-BILL-NO                         00120006
MFA-TR*             AND B.ACCOUNT_NO = A.ACCOUNT_NO                     00130006
MFA-TR*             AND B.BILL_NO = A.BILL_NO                           00140006
MFA-TR*             AND B.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE           00150006
MFA-TR*             AND B.IC_NO = :WS-IC-NO                             00160006
MFA-TR*             AND B.BILL_ITEM_TIMESTMP = :WS-TIMESTMP             00161006
MFA-TR*             AND C.ACCOUNT_NO = B.ACCOUNT_NO                     00170006
MFA-TR*             AND C.BILL_NO = B.BILL_NO                           00180006
MFA-TR*             AND C.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE             00190006
MFA-TR*             AND C.IC_NO = B.IC_NO                               00200006
MFA-TR*             AND C.BILL_ITEM_TIMESTMP = B.BILL_ITEM_TIMESTMP     00210006
MFA-TR*             AND C.RATE_ITEM_CODE = :WS-RATE-ITEM-CODE           00211011
MFA-TR*             AND D.CODE_STATUS <> 'T'                            00220006
MFA-TR*             AND D.RATE_PLAN_NO = B.RATE_PLAN_NO                 00230006
MFA-TR*             AND D.FROM_EFFECTIVE_DT =                           00240006
MFA-TR*               (SELECT MAX(X.FROM_EFFECTIVE_DT)                  00250006
MFA-TR*                  FROM CSS_RATE_CREATOR X                        00260006
MFA-TR*                  WHERE X.RATE_PLAN_NO = D.RATE_PLAN_NO          00270006
MFA-TR*                    AND X.CODE_STATUS <> 'T'                     00280006
MFA-TR*                    AND ((B.DATE_ORIG_BILL IS NOT NULL           00281006
MFA-TR*                    AND (X.FROM_EFFECTIVE_DT <=                  00290006
MFA-TR*                                    B.DATE_ORIG_BILL))           00300006
MFA-TR*                        OR (B.DATE_ORIG_BILL IS NULL             00310006
MFA-TR*                    AND (X.FROM_EFFECTIVE_DT <=                  00320006
MFA-TR*                                     A.DATE_BILLED))))           00330006
MFA-TR*             AND E.CODE_UTIL_TYPE = D.CODE_UTIL_TYPE             00340008
MFA-TR*             AND E.RATE_PLAN_NO   = D.RATE_PLAN_NO               00350008
MFA-TR*             AND E.VERSION_NO_CNTRL = D.VERSION_NO_CNTRL         00360008
MFA-TR*             AND E.RATE_ITEM_CODE = C.RATE_ITEM_CODE             00361010
MFA-TR*             AND F.UM_EQUIP_ID = E.UM_EQUIP_ID                   00370008
MFA-TR*            WITH UR                                                      
MFA-TR*       END-EXEC.                                                 02130001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE GWL-RC.             
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                  NEXT SENTENCE                                         
              ELSE                                                      
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                 MOVE 'UNKNOWN          ' TO WS-DESCRIPTION             
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
REARCH           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '8310' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT UM DESCRIPTION' TO ABEND-FUNCTION         
T15519           MOVE 'CSS_BILLING_HDR'       TO TABLE-1                
T15519           MOVE 'CSS_BILLING_DET'       TO TABLE-2                
T15519           MOVE 'CSS_UM_CNSMPT_HIST'    TO TABLE-3                
T15519           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
T15519           MOVE 'BILL_NO'               TO TABLE-ELEMENT-2        
T15519           MOVE 'IC_NO'                 TO TABLE-ELEMENT-3        
T15519           MOVE  WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
T15519           MOVE  WS-BILL-NO             TO HOSTVAR-ELEMENT-2      
T15519           MOVE  WS-IC-NO               TO HOSTVAR-ELEMENT-3      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF
              END-IF.        
                                                                        
          8310-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************12550001
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12560001
      ******************************************************************12570001
REARCH*    EXEC SQL                                                     12580001
REARCH*       INCLUDE CPD00300                                          12590001
REARCH*    END-EXEC.                                                    12600001
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************12620001
      *       END PROGRAM COPYLIB                                      *12630001
      ******************************************************************12640001
REARCH*    COPY CPD00302.                                               12650001
REARCH******************************************************************12660001
REARCH*   8900-SEND-DONE                                               *        
REARCH******************************************************************        
REARCH 8900-SEND-DONE.                                                  
REARCH*                                                                         
REARCH       IF (WS-FIRST-RECORD = 'N' AND WS-FIRST-UC-RECORD = 'N')    
REARCH          OR (WS-FIRST-RECORD = 'Y' AND WS-FIRST-UC-RECORD = 'N') 
REARCH           EXEC SQL                                               
REARCH               OPEN C1                                            
REARCH           END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
REARCH       ELSE                                                       
REARCH           EXEC SQL                                               
REARCH               OPEN C2                                            
REARCH           END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH 8900-EXIT.                                                       
REARCH         EXIT.                                                    
REARCH******************************************************************        
REARCH* 9000-SEND-ERROR-RESULT                                         *        
REARCH******************************************************************        
REARCH 9000-SEND-ERROR-RESULT.                                          
REARCH*                                                                         
REARCH       MOVE 'N'                 TO SEND-DONE-SW.                  
REARCH       INITIALIZE GTT-RETURN-FIELDS.                              
REARCH       MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                
REARCH                                     ABEND-SQLCODE.               
REARCH       MOVE SQLERRMC            TO ABEND-SQLERRMC.                
REARCH*                                                                         
REARCH       EXEC SQL                                                   
REARCH           ROLLBACK                                               
REARCH       END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       IF SQLCODE = 0                                             
REARCH          CONTINUE                                                
REARCH       ELSE                                                       
REARCH          MOVE 'ROLLBACK'       TO ABEND-FUNCTION                 
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH       PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                 
REARCH                                                                  
REARCH       PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                   
REARCH*                                                                         
REARCH 9000-EXIT.                                                       
REARCH         EXIT.                                                    
REARCH*                                                                         
REARCH******************************************************************        
REARCH*   9999-END-PROGRAM                                             *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 9999-END-PROGRAM.                                                
REARCH                                                                  
REARCH       IF CTR-ROWS < 1                                            
REARCH******************************************************************        
REARCH*           PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!   *        
REARCH******************************************************************        
REARCH                                                                  
REARCH          MOVE PROGRAM-NAME       TO ABEND-PROGRAM                
REARCH          MOVE '9999-END-PROGRAM' TO ABEND-FUNCTION               
REARCH          MOVE 'PROGRAMMER LOGIC' TO TABLE-1                      
REARCH          MOVE 'FAILED TO SEND'   TO TABLE-ELEMENT-1              
REARCH          MOVE 'RESULT SET'       TO HOSTVAR-ELEMENT-1            
REARCH          MOVE -1                 TO WS-ACTIVE-RETURN-CODE        
REARCH          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
REARCH       ELSE                                                       
REARCH          PERFORM 8900-SEND-DONE  THRU 8900-EXIT                  
REARCH       END-IF.                                                    
REARCH                                                                  
REARCH       
MSQ016        GOBACK.                                                  
REARCH                                                                  
REARCH  9999-EXIT.                                                      
REARCH         EXIT.                                                    
