       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR02086.                                      
COB303 DATE-WRITTEN.     MAY 12, 2005.                                  
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).  *         
      *                                                               *         
      *  TRANID:        S086                                          *         
      *  PROGRAM:       S086                                          *         
      *  CALLING SP:    PA_S086                                       *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM            *         
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                      *         
      *  THIS PROGRAM RETRIEVES ALL THE GUARANTEED ACCOUNTS THAT A    *         
      *  GUARANTOR ACCOUNT HAS. THIS SENDS BACK THE GUARANTEED NAME,  *         
      *  ADDRESS, AND THE AMOUNT HE IS GUARANTEED FOR                 *         
      *                                                               *         
      *                                                               *         
      *  INPUT PARAMETERS               OUTPUT PARAMETERS             *         
      *  -------------------------      -----------------------       *         
      *  ACCOUNT-NO          X(13)      RETURN-CODE        S9(9)      *         
      *                                 GUAR-ACCT-NO       X(13)      *         
      *                                 AMT-GUARANTEED     S9(09)V99  *         
      *                                 NAME-FORMAT        X(01)      *         
      *                                 TITLE-PREFIX       X(09)      *         
      *                                 FIRST-NAME         X(15)      *         
      *                                 MIDDLE-INITIAL     X(01)      *         
T36933*                                 LAST-NAME          X(40)      *         
T36933*                                 FULL-NAME          X(70)      *         
      *                                 TITLE-SUFFIX-1     X(03)      *         
      *                                 TITLE-SUFFIX-2     X(03)      *         
      *                                 ADDR-PREFIX-1      X(03)      *         
      *                                 ADDR-PREFIX-2      X(02)      *         
T36933*                                 HOUSE-NO           X(15)      *         
T36933*                                 STREET-NAME        X(30)      *         
      *                                 ADDR-SUFFIX        X(02)      *         
      *                                 TOWN               X(26)      *         
      *                                 STATE              X(02)      *         
      *                                 ZIP-CODE           X(05)      *         
      *                                                               *         
      *  THE FOLLOWING TABLES ARE USED :                              *         
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID             *         
      *      ------------------  -----------    ---------             *         
      *      CSS_NAME            TBNAME         DQ                    *         
      *      CSS_ADDR_FORMATTED  TBADRFMT       DY                    *         
      *      CSS_GUARANTOR       TBGTNTR        GU                    *         
      *      CSS_NAME_ACCT_XREF  TBNMACTX       HT                    *         
      *      CSS_ZIP_CODE        TBZIPCD        HT                    *         
      *****************************************************************         
      *                                                               *         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   --------------------------------------  *         
      *  03/03/95    GP       CREATED.                                *         
      *  07/06/95    WMG      1. MODIFIED CURSOR LOGIC TO RETURN ALL  *         
      *                          GUARANTEED ACCOUNTS.                 *         
      *                       2. MODIFIED PROGRAM LOGIC TO RETURN     *         
      *                          A "NOT-FOUND" CODE (+100) WHEN NO    *         
      *                          GUARANTEED ACCOUNTS ARE FOUND.       *         
      *                                                               *         
      *  08/10/96    JXR      RETRIEVE GUAR_ESTBLSH_DT FROM THE TABLE.*         
      *                       PCR 194                                 *         
      *  07/29/96    JEP      REMOVE CWS00068.  TPR 4800.             *         
CBSI  *  08/03/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE   *         
CBSI  *             MADRAS    ABEND PARAMETERS                        *         
REARCH*  05/23/05   CVNS      RPC TO COBOL SP CONVERSION              *         
REARCH*             CHENNAI                                           *         
T36933*  06/24/08   SRIDHAR   INCREASE LENGTH OF LAST NAME, FULL NAME *         
T36933*             VALURI    HOUSE NO AND STREET NAME FIELDS.        *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02086'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02086 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
REARCH*    COPY SYGWCOB.                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
REARCH*    COPY SYDBCOB.                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_NAME >                                                
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_GUARANTOR  >                                          
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_ADDR_FORMATTED >                                      
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_NAME_ACCT_XREF >                                      
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_NAME_ACCT_XREF >                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'S086    '.              
REARCH*    05  GWL-PROC                POINTER.                                 
REARCH*    05  GWL-INIT-HANDLE         POINTER.                                 
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02086_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH*01  PARM-FIELDS.                                                         
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13).                               
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  GUARANTOR-ROWS-FOUND    PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-FORMAT.                                          
               10  WS-MONTH            PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-DAY              PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-YEAR             PIC X(04) VALUE SPACES.          
           05  WS-ESTBLSH-DATE-NI      PIC S9(04) COMP VALUE ZERO.      
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02086'.      
REARCH     05  WS-SQLSTATE             PIC X(05).                       
      *                                                                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-GUAR-ACCT-NO         PIC X(13) VALUE SPACE.           
           05  RS-GUAR-ESTBLSH-DT      PIC X(10) VALUE SPACES.          
           05  RS-AMT-GUARANTEED       PIC S9(09)V99 COMP-3 VALUE +0.   
           05  RS-GUAR-STAT-CD         PIC X(01) VALUE SPACE.           
           05  RS-NAME-FORMAT          PIC X(1)  VALUE SPACE.           
           05  RS-TITLE-PREFIX         PIC X(9)  VALUE SPACE.           
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACES.          
           05  RS-MIDDLE-INITIAL       PIC X(01) VALUE SPACES.          
T36933*    05  RS-LAST-NAME            PIC X(20) VALUE SPACES.                  
T36933*    05  RS-FULL-NAME            PIC X(50) VALUE SPACES.                  
T36933     05  RS-LAST-NAME            PIC X(40) VALUE SPACES.          
T36933     05  RS-FULL-NAME            PIC X(70) VALUE SPACES.          
           05  RS-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.          
           05  RS-TITLE-SUFFIX-2       PIC X(03) VALUE SPACES.          
           05  RS-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.          
           05  RS-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.          
T36933*    05  RS-HOUSE-NO             PIC X(05) VALUE SPACES.                  
T36933*    05  RS-STREET-NAME          PIC X(16) VALUE SPACES.                  
T36933     05  RS-HOUSE-NO             PIC X(15) VALUE SPACES.          
T36933     05  RS-STREET-NAME          PIC X(30) VALUE SPACES.          
           05  RS-STREET-SUFFIX        PIC X(04) VALUE SPACES.          
           05  RS-ADDR-SUFFIX          PIC X(02) VALUE SPACES.          
           05  RS-TOWN                 PIC X(26) VALUE SPACES.          
           05  RS-STATE                PIC X(02) VALUE SPACES.          
           05  RS-ZIP-CODE             PIC X(05) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-GUAR-ACCT-NO         PIC X(13) VALUE SPACE.            
REARCH     05  S-GUAR-ESTBLSH-DT      PIC X(10) VALUE SPACES.           
REARCH     05  S-AMT-GUARANTEED       PIC S9(09)V99 COMP-3 VALUE +0.    
REARCH     05  S-GUAR-STAT-CD         PIC X(01) VALUE SPACE.            
REARCH     05  S-NAME-FORMAT          PIC X(1)  VALUE SPACE.            
REARCH     05  S-TITLE-PREFIX         PIC X(9)  VALUE SPACE.            
REARCH     05  S-FIRST-NAME           PIC X(15) VALUE SPACES.           
REARCH     05  S-MIDDLE-INITIAL       PIC X(01) VALUE SPACES.           
T36933*    05  S-LAST-NAME            PIC X(20) VALUE SPACES.                   
T36933*    05  S-FULL-NAME            PIC X(50) VALUE SPACES.                   
T36933     05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
T36933     05  S-FULL-NAME            PIC X(70) VALUE SPACES.           
REARCH     05  S-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.           
REARCH     05  S-TITLE-SUFFIX-2       PIC X(03) VALUE SPACES.           
REARCH     05  S-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.           
REARCH     05  S-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.           
T36933*    05  S-HOUSE-NO             PIC X(05) VALUE SPACES.                   
T36933*    05  S-STREET-NAME          PIC X(16) VALUE SPACES.                   
T36933     05  S-HOUSE-NO             PIC X(15) VALUE SPACES.           
T36933     05  S-STREET-NAME          PIC X(30) VALUE SPACES.           
REARCH     05  S-STREET-SUFFIX        PIC X(04) VALUE SPACES.           
REARCH     05  S-ADDR-SUFFIX          PIC X(02) VALUE SPACES.           
REARCH     05  S-TOWN                 PIC X(26) VALUE SPACES.           
REARCH     05  S-STATE                PIC X(02) VALUE SPACES.           
REARCH     05  S-ZIP-CODE             PIC X(05) VALUE SPACES.           
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
REARCH*    05  CNS-GUAR-ACCT-NO       PIC X(10) VALUE 'ACCOUNT_NO'.             
REARCH*    05  CNS-GUAR-ESTBLSH-DT    PIC X(15) VALUE                           
REARCH*                               'GUAR_ESTBLSH_DT'.                        
REARCH*    05  CNS-AMT-GUARANTEED     PIC X(06) VALUE 'AMOUNT'.                 
REARCH*    05  CNS-GUAR-STAT-CD       PIC X(06) VALUE 'STATUS'.                 
REARCH*    05  CNS-NAME-FORMAT        PIC X(11) VALUE 'NAME_FORMAT'.            
REARCH*    05  CNS-TITLE-PREFIX       PIC X(06) VALUE 'PREFIX'.                 
REARCH*    05  CNS-FIRST-NAME         PIC X(05) VALUE 'FIRST'.                  
REARCH*    05  CNS-MIDDLE-INITIAL     PIC X(06) VALUE 'MIDDLE'.                 
REARCH*    05  CNS-LAST-NAME          PIC X(04) VALUE 'LAST'.                   
REARCH*    05  CNS-FULL-NAME          PIC X(09) VALUE 'FULL_NAME'.              
REARCH*    05  CNS-TITLE-SUFFIX-1     PIC X(14) VALUE 'TITLE_SUFFIX_1'.         
REARCH*    05  CNS-TITLE-SUFFIX-2     PIC X(14) VALUE 'TITLE_SUFFIX_2'.         
REARCH*    05  CNS-ADDR-PREFIX-1      PIC X(13) VALUE 'ADDR_PREFIX_1'.          
REARCH*    05  CNS-ADDR-PREFIX-2      PIC X(13) VALUE 'ADDR_PREFIX_2'.          
REARCH*    05  CNS-HOUSE-NO           PIC X(08) VALUE 'HOUSE_NO'.               
REARCH*    05  CNS-STREET-NAME        PIC X(11) VALUE 'STREET_NAME'.            
REARCH*    05  CNS-STREET-SUFFIX      PIC X(11) VALUE 'STREET_SUFF'.            
REARCH*    05  CNS-ADDR-SUFFIX        PIC X(11) VALUE 'ADDR_SUFFIX'.            
REARCH*    05  CNS-TOWN               PIC X(04) VALUE 'TOWN'.                   
REARCH*    05  CNS-STATE              PIC X(05) VALUE 'STATE'.                  
REARCH*    05  CNS-ZIP-CODE           PIC X(08) VALUE 'ZIP_CODE'.               
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NUM          PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-GUAR-ACCOUNT-NO      PIC 9(13).                       
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  LITERALS.                                                    
           05  WS-A                    PIC X(1)  VALUE 'A'.             
           05  WS-B                    PIC X(1)  VALUE 'B'.             
           05  WS-C                    PIC X(1)  VALUE 'C'.             
           05  WS-D                    PIC X(1)  VALUE 'D'.             
           05  WS-F                    PIC X(1)  VALUE 'F'.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE GUARANTEED_CSR CURSOR FOR                          
                 SELECT ACCOUNT_NO,                                     
                        GUAR_STATUS_CD,                                 
                        AMOUNT_GUARANTEED,                              
                        GUAR_ESTBLSH_DT                                 
                   FROM CSS_GUARANTOR                                   
                  WHERE GUARNTR_ACCT_NO = :WS-ACCOUNT-NO                
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'         TO TABLE-1                        
REARCH*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(GUAR_ACCT_NO))       AS GUAR_ACCT_NO            
REARCH            ,LTRIM(RTRIM(GUAR_ESTBLSH_DT))    AS GUAR_ESTBLSH_DT         
REARCH            ,AMT_GUARANTEED                                       
REARCH            ,GUAR_STAT_CD                                         
REARCH            ,NAME_FORMAT                                          
REARCH            ,LTRIM(RTRIM(TITLE_PREFIX))       AS TITLE_PREFIX            
REARCH            ,LTRIM(RTRIM(FIRST_NAME))         AS FIRST_NAME              
REARCH            ,MIDDLE_INITIAL                                       
REARCH            ,LTRIM(RTRIM(LAST_NAME))          AS LAST_NAME               
REARCH            ,LTRIM(RTRIM(FULL_NAME))          AS FULL_NAME               
REARCH            ,LTRIM(RTRIM(TITLE_SUFFIX_1))     AS TITLE_SUFFIX_1          
REARCH            ,LTRIM(RTRIM(TITLE_SUFFIX_2))     AS TITLE_SUFFIX_2          
REARCH            ,LTRIM(RTRIM(ADDR_PREFIX_1))      AS ADDR_PREFIX_1           
REARCH            ,LTRIM(RTRIM(ADDR_PREFIX_2))      AS ADDR_PREFIX_2           
REARCH            ,LTRIM(RTRIM(HOUSE_NO))           AS HOUSE_NO                
REARCH            ,LTRIM(RTRIM(STREET_NAME))        AS STREET_NAME             
REARCH            ,LTRIM(RTRIM(STREET_SUFFIX))      AS STREET_SUFFIX           
REARCH            ,LTRIM(RTRIM(ADDR_SUFFIX))        AS ADDR_SUFFIX             
REARCH            ,LTRIM(RTRIM(TOWN))               AS TOWN                    
REARCH            ,LTRIM(RTRIM(STATE))              AS STATE                   
REARCH            ,LTRIM(RTRIM(ZIP_CODE))           AS ZIP_CODE                
REARCH         FROM                                                     
REARCH             #CSR02086_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(GUAR_ACCT_NO)       AS GUAR_ACCT_NO                    
MFA-TR*           ,STRIP(GUAR_ESTBLSH_DT)    AS GUAR_ESTBLSH_DT                 
MFA-TR*           ,AMT_GUARANTEED                                               
MFA-TR*           ,GUAR_STAT_CD                                                 
MFA-TR*           ,NAME_FORMAT                                                  
MFA-TR*           ,STRIP(TITLE_PREFIX)       AS TITLE_PREFIX                    
MFA-TR*           ,STRIP(FIRST_NAME)         AS FIRST_NAME                      
MFA-TR*           ,MIDDLE_INITIAL                                               
MFA-TR*           ,STRIP(LAST_NAME)          AS LAST_NAME                       
MFA-TR*           ,STRIP(FULL_NAME)          AS FULL_NAME                       
MFA-TR*           ,STRIP(TITLE_SUFFIX_1)     AS TITLE_SUFFIX_1                  
MFA-TR*           ,STRIP(TITLE_SUFFIX_2)     AS TITLE_SUFFIX_2                  
MFA-TR*           ,STRIP(ADDR_PREFIX_1)      AS ADDR_PREFIX_1                   
MFA-TR*           ,STRIP(ADDR_PREFIX_2)      AS ADDR_PREFIX_2                   
MFA-TR*           ,STRIP(HOUSE_NO)           AS HOUSE_NO                        
MFA-TR*           ,STRIP(STREET_NAME)        AS STREET_NAME                     
MFA-TR*           ,STRIP(STREET_SUFFIX)      AS STREET_SUFFIX                   
MFA-TR*           ,STRIP(ADDR_SUFFIX)        AS ADDR_SUFFIX                     
MFA-TR*           ,STRIP(TOWN)               AS TOWN                            
MFA-TR*           ,STRIP(STATE)              AS STATE                           
MFA-TR*           ,STRIP(ZIP_CODE)           AS ZIP_CODE                        
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02086_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02086_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02086_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02086_R1
               (                                                       
REARCH              RETURN_CODE              INT                    
REARCH             ,GUAR_ACCT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,GUAR_ESTBLSH_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,AMT_GUARANTEED           DECIMAL(11,2)              
REARCH             ,GUAR_STAT_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,NAME_FORMAT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,TITLE_PREFIX CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,MIDDLE_INITIAL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
T36933*            ,LAST_NAME                CHAR(20)                           
T36933*            ,FULL_NAME                CHAR(50)                           
T36933             ,LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
T36933             ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,TITLE_SUFFIX_1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,TITLE_SUFFIX_2 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,ADDR_PREFIX_1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,ADDR_PREFIX_2 CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
T36933*            ,HOUSE_NO                 CHAR(05)                           
T36933*            ,STREET_NAME              CHAR(16)                           
T36933             ,HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
T36933             ,STREET_NAME CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,STREET_SUFFIX CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,ADDR_SUFFIX CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH             ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH             ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02086_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS         THRU 1100-EXIT.                   
                                                                        
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NUM.        
           MOVE WS-ACCOUNT-DEC                TO WS-ACCOUNT-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*-------------< GET ACCOUNT-NUM >                                         
REARCH*    MOVE 1                                TO PARM-ID1.                   
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.                   
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-GUAR-ACCT-NO        TO S-GUAR-ACCT-NO.               
REARCH     MOVE RS-GUAR-ESTBLSH-DT     TO S-GUAR-ESTBLSH-DT.            
REARCH     MOVE RS-AMT-GUARANTEED      TO S-AMT-GUARANTEED.             
REARCH     MOVE RS-GUAR-STAT-CD        TO S-GUAR-STAT-CD.               
REARCH     MOVE RS-NAME-FORMAT         TO S-NAME-FORMAT.                
REARCH     MOVE RS-TITLE-PREFIX        TO S-TITLE-PREFIX.               
REARCH     MOVE RS-FIRST-NAME          TO S-FIRST-NAME.                 
REARCH     MOVE RS-MIDDLE-INITIAL      TO S-MIDDLE-INITIAL.             
REARCH     MOVE RS-LAST-NAME           TO S-LAST-NAME.                  
REARCH     MOVE RS-FULL-NAME           TO S-FULL-NAME.                  
REARCH     MOVE RS-TITLE-SUFFIX-1      TO S-TITLE-SUFFIX-1.             
REARCH     MOVE RS-TITLE-SUFFIX-2      TO S-TITLE-SUFFIX-2.             
REARCH     MOVE RS-ADDR-PREFIX-1       TO S-ADDR-PREFIX-1.              
REARCH     MOVE RS-ADDR-PREFIX-2       TO S-ADDR-PREFIX-2.              
REARCH     MOVE RS-HOUSE-NO            TO S-HOUSE-NO.                   
REARCH     MOVE RS-STREET-NAME         TO S-STREET-NAME.                
REARCH     MOVE RS-STREET-SUFFIX       TO S-STREET-SUFFIX.              
REARCH     MOVE RS-ADDR-SUFFIX         TO S-ADDR-SUFFIX.                
REARCH     MOVE RS-TOWN                TO S-TOWN.                       
REARCH     MOVE RS-STATE               TO S-STATE.                      
REARCH     MOVE RS-ZIP-CODE            TO S-ZIP-CODE.                   
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     CALLS 2110-DESC-RET-CODE                                   *        
      *           2112-DESC-GUAR-ACCT-NO                               *        
      *           2114-DESC-AMT-GUARANTEED                             *        
      *           2116-DESC-NAME-FORMAT                                *        
      *           2118-DESC-TITLE-PREFIX                               *        
      *           2120-DESC-FIRST-NAME                                 *        
      *           2122-DESC-MIDDLE-INITIAL                             *        
      *           2124-DESC-LAST-NAME                                  *        
      *           2124A-DESC-FULL-NAME                                 *        
      *           2125-DESC-TITLE-SUFFIX-1                             *        
      *           2126-DESC-TITLE-SUFFIX-2                             *        
      *           2127-DESC-ADDR-PREFIX-1                              *        
      *           2128-DESC-ADDR-PREFIX-2                              *        
      *           2129-DESC-HOUSE-NO                                   *        
      *           2130-DESC-STREET-NAME                                *        
      *           2131-DESC-ADDR-SUFFIX                                *        
      *           2132-DESC-TOWN                                       *        
      *           2133-DESC-STATE                                      *        
      *           2134-DESC-ZIP-CODE                                   *        
      *      CALLED FROM 2000-PROCESS-OUTPUT                           *        
      *                                                                *        
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                  *        
      ******************************************************************        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    PERFORM 2110-DESC-RET-CODE         THRU 2110-EXIT.                   
REARCH*    PERFORM 2112-DESC-GUAR-ACCT-NO     THRU 2112-EXIT.                   
REARCH*    PERFORM 2113-DESC-ESTABLISH-DATE   THRU 2113-EXIT.                   
REARCH*    PERFORM 2114-DESC-AMT-GUARANTEED   THRU 2114-EXIT.                   
REARCH*    PERFORM 2115-DESC-GUAR-STAT-CD     THRU 2115-EXIT.                   
REARCH*    PERFORM 2116-DESC-NAME-FORMAT      THRU 2116-EXIT.                   
REARCH*    PERFORM 2118-DESC-TITLE-PREFIX     THRU 2118-EXIT.                   
REARCH*    PERFORM 2120-DESC-FIRST-NAME       THRU 2120-EXIT.                   
REARCH*    PERFORM 2122-DESC-MIDDLE-INITIAL   THRU 2122-EXIT.                   
REARCH*    PERFORM 2124-DESC-LAST-NAME        THRU 2124-EXIT.                   
REARCH*    PERFORM 2124A-DESC-FULL-NAME       THRU 2124A-EXIT.                  
REARCH*    PERFORM 2125-DESC-TITLE-SUFFIX-1   THRU 2125-EXIT.                   
REARCH*    PERFORM 2126-DESC-TITLE-SUFFIX-2   THRU 2126-EXIT.                   
REARCH*    PERFORM 2127-DESC-ADDR-PREFIX-1    THRU 2127-EXIT.                   
REARCH*    PERFORM 2128-DESC-ADDR-PREFIX-2    THRU 2128-EXIT.                   
REARCH*    PERFORM 2129-DESC-HOUSE-NO         THRU 2129-EXIT.                   
REARCH*    PERFORM 2130-DESC-STREET-NAME      THRU 2130-EXIT.                   
REARCH*    PERFORM 2130A-DESC-STREET-SUFFIX   THRU 2130A-EXIT.                  
REARCH*    PERFORM 2131-DESC-ADDR-SUFFIX      THRU 2131-EXIT.                   
REARCH*    PERFORM 2132-DESC-TOWN             THRU 2132-EXIT.                   
REARCH*    PERFORM 2133-DESC-STATE            THRU 2133-EXIT.                   
REARCH*    PERFORM 2134-DESC-ZIP-CODE         THRU 2134-EXIT.                   
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
REARCH*2110-DESC-RET-CODE.                                                      
REARCH*                                                                         
REARCH*    MOVE '2110'                        TO ACTIVE-PARAGRAPH.              
REARCH*    MOVE 1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSINT4                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RETURN-CODE,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2110-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2112-DESC-GUAR-ACCT-NO                                         *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE GUARANTEED ACCOUNT NUMBER TO THE CLIENT           *        
      ******************************************************************        
REARCH*2112-DESC-GUAR-ACCT-NO.                                                  
REARCH*                                                                         
REARCH*    MOVE '2112'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-GUAR-ACCT-NO     TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-GUAR-ACCT-NO    TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-GUAR-ACCT-NO,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-GUAR-ACCT-NO,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2112-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2113-DESC-ESTABLISH-DATE                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE ESTABLISH DATE FIELD TO THE CLIENT                *        
      ******************************************************************        
REARCH*2113-DESC-ESTABLISH-DATE.                                                
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR      TO DB-HOST-TYPE.                                   
REARCH*    MOVE TDSCHAR      TO DB-CLIENT-TYPE.                                 
REARCH*    MOVE LENGTH OF RS-GUAR-ESTBLSH-DT TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-GUAR-ESTBLSH-DT TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-GUAR-ESTBLSH-DT,                            
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-GUAR-ESTBLSH-DT,                           
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*2113-EXIT.                                                               
REARCH*    EXIT.                                                                
      ******************************************************************        
      * 2114-DESC-AMT-GUARANTEED                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE AMT-GUARANTEED FIELD TO THE CLIENT                *        
      ******************************************************************        
REARCH*2114-DESC-AMT-GUARANTEED.                                                
REARCH*                                                                         
REARCH*    MOVE '2114'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-AMT-GUARANTEED   TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-AMT-GUARANTEED  TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-AMT-GUARANTEED,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-AMT-GUARANTEED,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2114-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2115-DESC-GUAR-STAT-CD                                         *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE AMT-GUARANTEED FIELD TO THE CLIENT                *        
      ******************************************************************        
REARCH*2115-DESC-GUAR-STAT-CD.                                                  
REARCH*                                                                         
REARCH*    MOVE '2115'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-GUAR-STAT-CD     TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-GUAR-STAT-CD    TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-GUAR-STAT-CD,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-GUAR-STAT-CD,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2115-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2116-NAME-FORMAT                                               *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE NAME-FORMAT FIELD TO THE CLIENT                   *        
      ******************************************************************        
REARCH*2116-DESC-NAME-FORMAT.                                                   
REARCH*                                                                         
REARCH*    MOVE '2116'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-NAME-FORMAT      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-NAME-FORMAT     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-NAME-FORMAT,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-NAME-FORMAT,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2116-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2118-DESC-TITLE-PREFIX                                         *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE TITLE-PREFIX  FIELD TO THE CLIENT                 *        
      ******************************************************************        
REARCH*2118-DESC-TITLE-PREFIX.                                                  
REARCH*                                                                         
REARCH*    MOVE '2118'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-TITLE-PREFIX     TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-TITLE-PREFIX    TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TITLE-PREFIX,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TITLE-PREFIX,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2118-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2120-DESC-FIRST-NAME                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE FIRST-NAME              FIELD TO THE CLIENT       *        
      ******************************************************************        
REARCH*2120-DESC-FIRST-NAME.                                                    
REARCH*                                                                         
REARCH*    MOVE '2120'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD  1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-FIRST-NAME       TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-FIRST-NAME      TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-FIRST-NAME,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-FIRST-NAME,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2120-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2122-DESC-MIDDLE-INITIAL                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE MIDDLE INITIAL    RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2122-DESC-MIDDLE-INITIAL.                                                
REARCH*                                                                         
REARCH*    MOVE '2122'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-MIDDLE-INITIAL   TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-MIDDLE-INITIAL  TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-MIDDLE-INITIAL,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-MIDDLE-INITIAL,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2122-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2124-DESC-LAST-NAME                                            *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE LAST-NAME         RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2124-DESC-LAST-NAME.                                                     
REARCH*                                                                         
REARCH*    MOVE '2124'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-LAST-NAME        TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-LAST-NAME       TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LAST-NAME,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-LAST-NAME,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2124-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
REARCH*                                                                         
      ******************************************************************        
      * 2124A-DESC-FULL-NAME                                           *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE FULL-NAME         RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2124A-DESC-FULL-NAME.                                                    
REARCH*                                                                         
REARCH*    MOVE '2124A'                       TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-FULL-NAME        TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-FULL-NAME       TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-FULL-NAME,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-FULL-NAME,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2124A-EXIT.                                                              
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2125-DESC-TITLE-SUFFIX-1                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE TITLE-SUFFIX-1    RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2125-DESC-TITLE-SUFFIX-1.                                                
REARCH*                                                                         
REARCH*    MOVE '2125'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-TITLE-SUFFIX-1   TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-TITLE-SUFFIX-1  TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TITLE-SUFFIX-1,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TITLE-SUFFIX-1,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*                                                                         
REARCH*2125-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2126-DESC-TITLE-SUFFIX-2                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE TITLE-SUFFIX-2    RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2126-DESC-TITLE-SUFFIX-2.                                                
REARCH*                                                                         
REARCH*    MOVE '2126'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-TITLE-SUFFIX-2   TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-TITLE-SUFFIX-2  TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TITLE-SUFFIX-2,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TITLE-SUFFIX-2,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*                                                                         
REARCH*2126-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2127-DESC-ADDR-PREFIX-1                                        *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE ADDR-PREFIX-1     RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2127-DESC-ADDR-PREFIX-1.                                                 
REARCH*                                                                         
REARCH*    MOVE '2127'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-ADDR-PREFIX-1    TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-ADDR-PREFIX-1   TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDR-PREFIX-1,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ADDR-PREFIX-1,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2127-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2128-DESC-ADDR-PREFIX-2                                        *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE ADDR-PREFIX-2     RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2128-DESC-ADDR-PREFIX-2.                                                 
REARCH*                                                                         
REARCH*    MOVE '2128'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-ADDR-PREFIX-2    TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-ADDR-PREFIX-2   TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDR-PREFIX-2,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ADDR-PREFIX-2,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2128-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2129-DESC-HOUSE-NO                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE HOUSE-NO            RESULT FIELD TO THE CLIENT    *        
      ******************************************************************        
REARCH*2129-DESC-HOUSE-NO.                                                      
REARCH*                                                                         
REARCH*    MOVE '2129'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-HOUSE-NO         TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-HOUSE-NO        TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-HOUSE-NO,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-HOUSE-NO,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2129-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2130-DESC-STREET-NAME                                          *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE STREET-NAME       RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2130-DESC-STREET-NAME.                                                   
REARCH*                                                                         
REARCH*    MOVE '2130'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-STREET-NAME      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-STREET-NAME     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-STREET-NAME,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-STREET-NAME,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2130-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2130A-DESC-STREET-SUFFIX                                       *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE STREET-NAME       RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2130A-DESC-STREET-SUFFIX.                                                
REARCH*                                                                         
REARCH*    MOVE '2130A'                       TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-STREET-SUFFIX    TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-STREET-SUFFIX   TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-STREET-SUFFIX,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-STREET-SUFFIX,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2130A-EXIT.                                                              
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2131-DESC-ADDR-SUFFIX                                          *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE ADDR-SUFFIX       RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2131-DESC-ADDR-SUFFIX.                                                   
REARCH*                                                                         
REARCH*    MOVE '2131'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-ADDR-SUFFIX      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-ADDR-SUFFIX     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDR-SUFFIX,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ADDR-SUFFIX,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2131-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2132-DESC-TOWN                                                 *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE TOWN              RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2132-DESC-TOWN.                                                          
REARCH*                                                                         
REARCH*    MOVE '2132'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-TOWN             TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-TOWN            TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TOWN,                                       
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TOWN,                                      
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2132-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2133-DESC-STATE                                                *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE STATE             RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2133-DESC-STATE.                                                         
REARCH*                                                                         
REARCH*    MOVE '2133'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-STATE            TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-STATE           TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-STATE,                                      
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-STATE,                                     
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2133-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2134-DESC-ZIP-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE ZIP-CODE          RESULT FIELD TO THE CLIENT      *        
      ******************************************************************        
REARCH*2134-DESC-ZIP-CODE.                                                      
REARCH*                                                                         
REARCH*    MOVE '2134'                        TO ACTIVE-PARAGRAPH.              
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSCHAR                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-ZIP-CODE         TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-ZIP-CODE        TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ZIP-CODE,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ZIP-CODE,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2134-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-GUARANTOR        THRU 7000-EXIT.           
           PERFORM 7010-FETCH-GUARANTOR       THRU 7010-EXIT            
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
REARCH     IF GUARANTOR-ROWS-FOUND = 'N'                                
REARCH        PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
REARCH        PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
REARCH     END-IF.                                                      
           PERFORM 7020-CLOSE-GUARANTOR       THRU 7020-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2300-PROCESS-ALL-ROWS                                        *          
      *                                                              *          
      * CALLS 7010-FETCH-GUARANTOR                                   *          
      *                                                              *          
      * CALLED FROM 2200-BUILD-RESULT                                *          
      *                                                              *          
      * FETCHES EACH GUARANTEED ACCOUNT AND GRABS ITS NAME AND ADDR  *          
      ****************************************************************          
       2300-PROCESS-ALL-ROWS.                                           
                                                                        
           PERFORM 7100-SELECT-NAME-ADDR      THRU 7100-EXIT.           
           PERFORM 7200-SELECT-CITY-STATE     THRU 7200-EXIT.           
                                                                        
           MOVE GU-ACCOUNT-NO                 TO WS-GUAR-ACCOUNT-NO.    
           MOVE WS-GUAR-ACCOUNT-NO            TO RS-GUAR-ACCT-NO.       
           IF WS-ESTBLSH-DATE-NI < 0                                    
                MOVE SPACES                   TO RS-GUAR-ESTBLSH-DT     
           ELSE                                                         
                UNSTRING GU-GUAR-ESTBLSH-DT DELIMITED BY '-'            
                    INTO WS-YEAR                                        
                         WS-MONTH                                       
                         WS-DAY                                         
                MOVE WS-DATE-FORMAT           TO RS-GUAR-ESTBLSH-DT     
           END-IF.                                                      
           MOVE GU-GUAR-STATUS-CD             TO RS-GUAR-STAT-CD.       
           MOVE GU-AMOUNT-GUARANTEED          TO RS-AMT-GUARANTEED.     
           MOVE DQ-NAME-FORMAT                TO RS-NAME-FORMAT.        
           MOVE DQ-FIRST-NAME                 TO RS-FIRST-NAME.         
           MOVE DQ-LAST-NAME                  TO RS-LAST-NAME.          
           MOVE DQ-FULL-NAME                  TO RS-FULL-NAME.          
           MOVE DQ-TITLE-SUFFIX-2             TO RS-TITLE-SUFFIX-2.     
           MOVE DY-ADDR-PREFIX-2              TO RS-ADDR-PREFIX-2.      
           MOVE DY-STREET-NAME                TO RS-STREET-NAME.        
           MOVE DY-ZIP-CODE                   TO RS-ZIP-CODE.           
           MOVE DQ-TITLE-PREFIX               TO RS-TITLE-PREFIX.       
           MOVE DQ-MIDDLE-NAME (1:1)          TO RS-MIDDLE-INITIAL.     
           MOVE DQ-TITLE-SUFFIX-1             TO RS-TITLE-SUFFIX-1.     
           MOVE DY-ADDR-PREFIX-1              TO RS-ADDR-PREFIX-1.      
           MOVE DY-HOUSE-NO                   TO RS-HOUSE-NO.           
           MOVE DY-ADDR-SUFFIX                TO RS-ADDR-SUFFIX.        
           MOVE DY-STREET-SUFFIX              TO RS-STREET-SUFFIX.      
           MOVE A4-STATE                      TO RS-STATE.              
           MOVE A4-TOWN                       TO RS-TOWN.               
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-GUARANTOR                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE GUARANTOR CURSOR                                 *        
      ******************************************************************        
       7000-OPEN-GUARANTOR.                                             
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN GUARANTEED_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_GUARANTOR'            TO TABLE-1                
CBSI          MOVE 'GUARNTR_ACCT_NO'          TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-GUARANTOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-GUARANTOR.                                            
                                                                        
           MOVE '7010'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH GUARANTEED_CSR                                      
               INTO :GU-ACCOUNT-NO,                                     
                    :GU-GUAR-STATUS-CD,                                 
                    :GU-AMOUNT-GUARANTEED,                              
                    :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-YES                     TO GUARANTOR-ROWS-FOUND   
              PERFORM 2300-PROCESS-ALL-ROWS   THRU 2300-EXIT            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
REARCH*         IF GUARANTOR-ROWS-FOUND = 'N'                                   
REARCH*            PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT              
REARCH*            PERFORM 8100-SEND-RESULT        THRU 8100-EXIT               
REARCH*         END-IF                                                          
REARCH        NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_GUARANTOR'            TO TABLE-1                
CBSI          MOVE 'GUARNTR_ACCT_NO'          TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-GUARANTOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      ******************************************************************        
       7020-CLOSE-GUARANTOR.                                            
                                                                        
           MOVE '7020'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE GUARANTEED_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_GUARANTOR'            TO TABLE-1                
CBSI          MOVE 'GUARNTR_ACCT_NO'          TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-NAME-ADDR                                          *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      ******************************************************************        
       7100-SELECT-NAME-ADDR.                                           
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT  A.NAME_FORMAT,        A.TITLE_PREFIX,             
                      A.FIRST_NAME,         A.MIDDLE_NAME,              
                      A.LAST_NAME,          A.TITLE_SUFFIX_1,           
                      A.TITLE_SUFFIX_2,     C.ADDR_PREFIX_1,            
                      C.ADDR_PREFIX_2,      C.HOUSE_NO,                 
                      C.STREET_NAME,        C.ADDR_SUFFIX,              
                      C.ZIP_CODE,           C.ZIP_CODE_TOKEN,           
                      A.FULL_NAME,          C.STREET_SUFFIX             
                INTO :DQ-NAME-FORMAT,      :DQ-TITLE-PREFIX,            
                     :DQ-FIRST-NAME,       :DQ-MIDDLE-NAME,             
                     :DQ-LAST-NAME,        :DQ-TITLE-SUFFIX-1,          
                     :DQ-TITLE-SUFFIX-2,   :DY-ADDR-PREFIX-1,           
                     :DY-ADDR-PREFIX-2,    :DY-HOUSE-NO,                
                     :DY-STREET-NAME,      :DY-ADDR-SUFFIX,             
                     :DY-ZIP-CODE,         :DY-ZIP-CODE-TOKEN,          
                     :DQ-FULL-NAME,        :DY-STREET-SUFFIX            
                FROM CSS_NAME A,                                        
                     CSS_NAME_ACCT_XREF B,                              
                     CSS_ADDR_FORMATTED C                               
               WHERE B.ACCOUNT_NO = :GU-ACCOUNT-NO                      
                 AND B.NAME_ID    = A.NAME_ID                           
                 AND A.NAME_TYPE  = 'CN'                                
                 AND B.CUSTOMER_ROLE_CD = ' '                           
                 AND B.ADDRESS_ID = C.ADDRESS_ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
CBSI          MOVE 'CSS_NAME'                 TO TABLE-2                
CBSI          MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-3                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE  GU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-CITY-STATE.                                        *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      ******************************************************************        
       7200-SELECT-CITY-STATE.                                          
                                                                        
           MOVE '7200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT  TOWN, STATE                                       
                INTO :A4-TOWN, :A4-STATE                                
                FROM CSS_ZIP_CODE                                       
               WHERE ZIP_CODE       = :DY-ZIP-CODE                      
                 AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ZIP_CODE'             TO TABLE-1                
CBSI          MOVE 'ZIP_CODE'                 TO TABLE-ELEMENT-1        
CBSI          MOVE 'ZIP_CODE_TOKEN'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE DY-ZIP-CODE                TO HOSTVAR-ELEMENT-1      
CBSI          MOVE DY-ZIP-CODE-TOKEN          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02086_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02086_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02086_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02086_R1                        
REARCH           (                                                      
REARCH                RETURN_CODE                                       
REARCH               ,GUAR_ACCT_NO                                      
REARCH               ,GUAR_ESTBLSH_DT                                   
REARCH               ,AMT_GUARANTEED                                    
REARCH               ,GUAR_STAT_CD                                      
REARCH               ,NAME_FORMAT                                       
REARCH               ,TITLE_PREFIX                                      
REARCH               ,FIRST_NAME                                        
REARCH               ,MIDDLE_INITIAL                                    
REARCH               ,LAST_NAME                                         
REARCH               ,FULL_NAME                                         
REARCH               ,TITLE_SUFFIX_1                                    
REARCH               ,TITLE_SUFFIX_2                                    
REARCH               ,ADDR_PREFIX_1                                     
REARCH               ,ADDR_PREFIX_2                                     
REARCH               ,HOUSE_NO                                          
REARCH               ,STREET_NAME                                       
REARCH               ,STREET_SUFFIX                                     
REARCH               ,ADDR_SUFFIX                                       
REARCH               ,TOWN                                              
REARCH               ,STATE                                             
REARCH               ,ZIP_CODE                                          
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-GUAR-ACCT-NO                                   
REARCH               ,:S-GUAR-ESTBLSH-DT                                
REARCH               ,:S-AMT-GUARANTEED                                 
REARCH               ,:S-GUAR-STAT-CD                                   
REARCH               ,:S-NAME-FORMAT                                    
REARCH               ,:S-TITLE-PREFIX                                   
REARCH               ,:S-FIRST-NAME                                     
REARCH               ,:S-MIDDLE-INITIAL                                 
REARCH               ,:S-LAST-NAME                                      
REARCH               ,:S-FULL-NAME                                      
REARCH               ,:S-TITLE-SUFFIX-1                                 
REARCH               ,:S-TITLE-SUFFIX-2                                 
REARCH               ,:S-ADDR-PREFIX-1                                  
REARCH               ,:S-ADDR-PREFIX-2                                  
REARCH               ,:S-HOUSE-NO                                       
REARCH               ,:S-STREET-NAME                                    
REARCH               ,:S-STREET-SUFFIX                                  
REARCH               ,:S-ADDR-SUFFIX                                    
REARCH               ,:S-TOWN                                           
REARCH               ,:S-STATE                                          
REARCH               ,:S-ZIP-CODE                                       
REARCH           )                                                      
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02086_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,GUAR_ACCT_NO                                              
MFA-TR*              ,GUAR_ESTBLSH_DT                                           
MFA-TR*              ,AMT_GUARANTEED                                            
MFA-TR*              ,GUAR_STAT_CD                                              
MFA-TR*              ,NAME_FORMAT                                               
MFA-TR*              ,TITLE_PREFIX                                              
MFA-TR*              ,FIRST_NAME                                                
MFA-TR*              ,MIDDLE_INITIAL                                            
MFA-TR*              ,LAST_NAME                                                 
MFA-TR*              ,FULL_NAME                                                 
MFA-TR*              ,TITLE_SUFFIX_1                                            
MFA-TR*              ,TITLE_SUFFIX_2                                            
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,HOUSE_NO                                                  
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-GUAR-ACCT-NO                                           
MFA-TR*              ,:S-GUAR-ESTBLSH-DT                                        
MFA-TR*              ,:S-AMT-GUARANTEED                                         
MFA-TR*              ,:S-GUAR-STAT-CD                                           
MFA-TR*              ,:S-NAME-FORMAT                                            
MFA-TR*              ,:S-TITLE-PREFIX                                           
MFA-TR*              ,:S-FIRST-NAME                                             
MFA-TR*              ,:S-MIDDLE-INITIAL                                         
MFA-TR*              ,:S-LAST-NAME                                              
MFA-TR*              ,:S-FULL-NAME                                              
MFA-TR*              ,:S-TITLE-SUFFIX-1                                         
MFA-TR*              ,:S-TITLE-SUFFIX-2                                         
MFA-TR*              ,:S-ADDR-PREFIX-1                                          
MFA-TR*              ,:S-ADDR-PREFIX-2                                          
MFA-TR*              ,:S-HOUSE-NO                                               
MFA-TR*              ,:S-STREET-NAME                                            
MFA-TR*              ,:S-STREET-SUFFIX                                          
MFA-TR*              ,:S-ADDR-SUFFIX                                            
MFA-TR*              ,:S-TOWN                                                   
MFA-TR*              ,:S-STATE                                                  
MFA-TR*              ,:S-ZIP-CODE                                               
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02086_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
