       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02085.                                         
COB303 DATE-WRITTEN.                                                    
COB303         SEPTEMBER 19, 2005.                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S085 CONVERTED TO DB2 SP CSR02085 ON 09/19/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S085                                           *        
      *  PROGRAM:       S085                                           *        
      *  CALLING SP:    PA_S085                                                 
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM INSERTS/UPDATES/DELETES FROM CSS_MSTSUB_ACCT AND *        
      *  UPDATES CSS_ACCOUNT BASED ON THE ACTION PARAMETER.            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/02/95    HC       CREATED.                                 *        
      *  05/05/95    HC       ADD LOGIC TO PROCESS TRANS COMMENTS.     *        
      *  04/11/96    MR       TPR 3817 - CHECK FOR DFA-ACCT ADDED      *        
      *                       ADDED COPYLIB  CWS00056                  *        
      *  05/02/96    RSN      FIX THE XFER INDICATORS ASSOCIATED WITH  *        
      *                       PARM-BILL-TYPE-CODE                      *        
      *                                                                *        
      *  06/04/96    ALI      MODIFIED TO ASSIGN BILL-HIST-XFER-IND    *        
      *                       AND AR-XFER-IND SPACES FOR MASTER ACCT.  *        
      *                       WHEN A SUB IS ADDED.                     *        
      *                                                                         
      *  07/15/96    ALI      MODIFIED PARA 8600-UPDATE-ACCT-AFTER-DEL *        
      *                       TO RESET THE VALUES OF BILL_HIST_XFER_IND*        
      *                       AR_XFER_IND & ACCT_XFER_TO WHEN A SUB ACCT        
      *                       IS REMOVED FROM THE MASTER. (TPR#4791)   *        
T6024 *  04/07/97    AS       MODIFIED TO NOT CHANGE THE CREDIT GROUP  *        
      *                       OF SUB-ACCOUNTS.                         *        
T11895*  07/09/97    AS       ADDED LOGIC TO CHECK FOR EXISTING        *        
      *                       CONTRACTS ON THE MASTER ACCOUNT WHEN THE *        
      *                       SUB ACCOUNT IS DELETED.                  *        
PCR549*  07/09/97    AS       UPDATE CREDIT GROUPS FOR MASTER/SUB ACCT *        
T12439*  07/31/97    AS       MODIFIED RECORDS WRITTEN TO MNT TRAN HIST*        
T12581*  08/06/97    AS       DEFAULT  THE BILLED OK COLUMN TO NO WHEN *        
T12581*                       ADDING SUB ACCOUNTS.                     *        
T14630*  02/04/98    GC       CHECK THAT THE SUB ACCOUNT DOESN'T HAVE  *        
T14630*                       ACTIVE RECEIVABLES OR DEPOSITS.          *        
T16154*  05/01/98    VIJI     MASTER ACCOUNT SHD BE ACTIVE AFTER ALL   *        
      *                       SUBS ARE REMOVED.  ALSO, WHEN ALL SUBS   *        
      *                       SEVERED FROM MASTER A/C, THE CREDIT GRP  *        
      *                       SHOULD BECOME "NON UTILITY".             *        
PCR638*  05/13/98    AMG      CHANGED PARM-CODE-SUB-TOTAL TO PIC X(18) *        
PCR638*                       AND CHANGED THE LENGTH FROM +4 TO +18    *        
PCR638*                       IN 5300 PARA.                            *        
T16471*  05/22/98    VIJI     MSTR/SUB IND SHD BE SET TO ALLOW THE MSTR*        
      *                       TO BILL ON THE OPEN OF ITS CYCLE NO MATTER        
      *                       WHEN THE RELATIONSHIP WAS SET UP.        *        
T16567*  05/27/98    VIJI     MST_SUB_ACCT_IND IS SET TO 'M' WHEN THE  *        
      *                       FIRST SUB A/C IS ADDED TO A MASTER.      *        
      *                       IT IS SET TO SPACES WHEN THE MASTER      *        
      *                       NO LONGER HAS ANY SUBS ATTACHED TO IT.   *        
T16592*  06/01/98    GAC      WHEN ADDING A SUB, SET THE CSS_ACCOUNT   *        
      *                       FIELD CODE_PRNT_BLL_MST TO THE SAME AS   *        
      *                       THAT OF THE MASTER.                      *        
T17007*  07/08/98    GAC      ALTERED TPR16471 CODE TO SET SUB_BILLED_OK        
      *                       FIELD.                                   *        
CBSI  *  08/03/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T17243*  08/06/98    KTB      ACCOUNT-TYPE-CODE SET TO 'N' WHEN ALL    *        
T17243*                       SUBS ARE DELETED                         *        
T18346*  12/17/98     SV      ALLOW DELETE OF FINAL BILLED SUBS        *        
T19676*  04/12/99    BAB      UPDATE CREDIT GROUP TO 'C' WHEN SUB IS   *        
      *                       DISCONNECTED FROM MASTER AND IS A        *        
      *                       UTILITY ACCOUNT                          *        
T20378*  07/12/99    SWR      WHEN ADDING A SUB ACCT, DEFAULT THE      *        
      *                       SUB-ACCT-BLLD-OK FIELD TO 'B' (BYPASS).  *        
T19479*  07/21/99    SWR      ADDED CODE TO UPDATE CSS_HELD_BP_SUBS TBL*        
      *                       WITH A 'D' IN THE PULL_FL COLUMN, IF THE *        
      *                       PARM-SUB-PRNT-BILL = 'Y'. ALSO, IF THERE *        
      *                       ARE NOT BILL PRINT ROWS ON THIS TABLE FOR*        
      *                       THE SUB, IT WILL PASS AN INDICATOR TO THE*        
      *                       THE PANEL AND IT WILL DISPLAY AN INFO MSG*        
      *                       TO THAT EFFECT.                          *        
T20001*  09/30/99    SWR      CHANGED CODE THAT WAS PREVENTING THIS    *        
      *                       PANEL FROM WORKING ON NON-BUSINESS DAYS. *        
T20864*  09/30/99    SWR      CHANGED CODE TO ALWAYS PUT A 'Y' IN THE  *        
      *                       AR_XFER_IND AND THE BILL_HIST_XFER_IND   *        
      *                       ON THE ACCOUNT TABLE FOR THE SUB ACCOUNT *        
      *                       WHEN IT IS SET-UP AS A SUB.              *        
T20859*  10/27/99    CB18344  CHANGED CODE TO RESET MEMO BILL IND WHEN *        
      *                       AN EXISTING ACCOUNT IS CHANGED TO A SUB  *        
      *                       ACCOUNT.                                 *        
T22382*  06/27/00    DS19153  CHANGED CODE TO PREVENT S0C7 WHICH WAS   *        
      *                       SHOWING UP IN ABEND-AID.                 *        
T23549*  03/21/01    COVANSYS  CHANGES MADE FOR EPAYMENT.              *        
T23549*              CHENNAI                                           *        
T28783*  08/21/03    COVANSYS CHANGES MADE TO REMOVE THE MASTER FROM   *        
T28783*              CHENNAI  CSS_LANDLORD WHEN THE MASTER HAS NO SUBS *        
T28783*                       ATTACHED TO IT,IN CASE OF LANDLORD MASTER*        
REARCH*  09/19/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
A01118*  04/29/09    DM94438  MST-SUB DELINK SHOULD NOT CHECK FOR VALIDA        
A01118*                       TIONS, IT SHOULD HAPPEN ONLY IN LINKING  *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02085'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02085 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
T19479     EXEC SQL                                                             
T19479        INCLUDE TBHLDBPS                                                  
T19479     END-EXEC.                                                            
T19479                                                                  
      * ADDED TABLE INCLUDES FOR JOURNALING                                     
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
T11895     EXEC SQL                                                             
T11895        INCLUDE TBCNTRCT                                                  
T11895     END-EXEC.                                                            
                                                                        
T11895     EXEC SQL                                                             
T11895        INCLUDE TBARCNTL                                                  
T11895     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ** CONTAINS THE COBOL EQUATES NEDDED FOR USING THE SYBASE OPEN            
      ** SERVER FOR CICS FACILITIES                                             
CVT999*    COPY SYGWCOB.                                                        
      ** ADDED TO SUPPORT CICS RPCS                                             
CVT999*    COPY SYDBCOB.                                                        
      ** COMMON SYSTEM AREA                                                     
           COPY CCA00001.                                                       
      ** ERROR HANDLING                                                         
CVT999*    COPY CWS00010.                                                       
      ** ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                         
           COPY CWS00027.                                                       
      ** SUPPORTS DB2 AND SQL ERROR CHECKING                                    
           COPY CWS00303.                                                       
      ** CODES DATA PRESENT                 - ADDED BY MR                       
           COPY CWS00056.                                                       
      *---------------------------------------------------------------*         
      *    COPY CJF00112.                                             *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
T16471     EXEC SQL                                                             
T16471        INCLUDE TBBILWDW                                                  
T16741     END-EXEC.                                                            
                                                                        
T23549*-------<INCLUDE CSS_BANK_EFT>                                            
T23549     EXEC SQL                                                             
T23549        INCLUDE TBBNKEFT                                                  
T23549     END-EXEC.                                                            
T23549*                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  USAGE COMP.           
           05  PARM-USERID             PIC X(07)  VALUE SPACES.         
           05  PARM-RESP-AREA-ID       PIC X(03)  VALUE SPACES.         
                                                                        
           05  PARM-MST-ACCT-NO        PIC X(13).                       
           05  PARM-MST-ACCT-NO-RED    REDEFINES PARM-MST-ACCT-NO       
                                       PIC 9(13).                       
           05  PARM-SUB-ACCT-NO        PIC X(13).                       
           05  PARM-SUB-ACCT-NO-RED    REDEFINES PARM-SUB-ACCT-NO       
                                       PIC 9(13).                       
           05  PARM-MST-SUB-ACCT-IND   PIC X(01).                       
PCR638     05  PARM-CODE-SUB-TOTAL     PIC X(18).                       
           05  PARM-BILL-TYPE-CODE     PIC X(01).                       
           05  PARM-ACTION-IND         PIC X(01).                       
           05  PARM-TRAN-COMMENT       PIC X(210).                      
           05  PARM-COMMENT-LEN        PIC X(04)  VALUE SPACES.         
           05  PARM-COMMENT-LEN-RED    REDEFINES PARM-COMMENT-LEN       
                                       PIC 9(04).                       
T19479     05  PARM-SUB-PRNT-BILL      PIC X(01).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02085'.      
           05  WS-CMPNT-ID             PIC X(02) VALUE SPACES.          
COB305     05 WS-MST-ACCT-NO-NUM        PIC S9(13)V COMP-3 VALUE 0.             
COB305     05 WS-LL-MST-ACCT-NUM        PIC S9(13)V COMP-3 VALUE 0.             
COB305     05 WS-SUB-ACCT-NO-NUM        PIC S9(13)V COMP-3 VALUE 0.             
           05  WS-UPDATE-SUCCESSFUL    PIC X(01).                       
               88 UPDATE-SUCCESSFUL    VALUE 'Y'.                       
           05  WS-NO-OF-UPDATE-TRIES   PIC S9(04) COMP-3 VALUE 0.       
           05  WS-SPACE                PIC X(01)  VALUE SPACE.          
           05  WS-AR-XFER-IND          PIC X(01).                       
           05  WS-BILL-HIST-XFER-IND   PIC X(01).                       
           05  WS-MST-SUB-ACCT-IND     PIC X(01).                       
           05  WS-CREDIT-GROUP         PIC X(01).                       
T17243     05  WS-ACCOUNT-TYPE-CODE    PIC X(01).                       
           05  WS-MASTER-SAME          PIC X(01)  VALUE 'N'.            
           05  WS-COUNT-SUB-ACCT       PIC S9(04) COMP VALUE 0.         
           05  WS-COUNT-CONTRACT       PIC S9(04) COMP VALUE 0.         
           05  WS-ACCT-STATUS          PIC X(01).                       
           05  WS-INACTIVE             PIC X(01)  VALUE 'J'.            
           05  WS-ACTIVE               PIC X(01)  VALUE 'A'.            
PCR549     05  WS-NON-UTIL-ACCT        PIC X(01)  VALUE 'N'.            
T14630     05  WS-REC-EXISTS           PIC X(01)  VALUE 'N'.            
T14630     05  WS-DEP-EXISTS           PIC X(01)  VALUE 'N'.            
T14630     05  WS-REC-AND-DEP-RC       PIC S9(9)  COMP VALUE +98.       
T14630     05  WS-REC-RC               PIC S9(9)  COMP VALUE +97.       
T14630     05  WS-DEP-RC               PIC S9(9)  COMP VALUE +96.       
T16471     05  WS-MASTER-BILL-CYCLE    PIC X(02)  VALUE SPACES.         
T16471     05  WS-SUB-BILL-CYCLE       PIC X(02)  VALUE SPACES.         
COB305     05 WS-MST-REV-MTH-LST        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-SUB-REV-MTH-LST        PIC S9(6)V USAGE COMP-3 VALUE 0.        
T16592     05  WS-CODE-PRNT-BLL-MST    PIC X(01)  VALUE SPACE.          
T17007     05  WS-NULL-IND-1           PIC S9(4)  COMP.                 
T17007     05  WS-MST-00-DAY-NULL      PIC S9(4)  COMP.                 
T17007     05  WS-SUB-00-DAY-NULL      PIC S9(4)  COMP.                 
                                                                        
T17007 01  WS-IS-MST-CYCLE-OPEN        PIC X(01).                       
T17007     88 WS-MST-CYCLE-OPEN        VALUE 'Y'.                       
T17007     88 WS-MST-CYCLE-NOT-OPEN    VALUE 'N'.                       
                                                                        
T20001 01  WS-CURRENT-DATE             PIC X(10).                       
T20001 01  WS-CURRENT-DATE-R REDEFINES WS-CURRENT-DATE.                 
T20001     05  WS-CURRENT-CCYY         PIC X(04).                       
T20001     05  FILLER                  PIC X(01).                       
T20001     05  WS-CURRENT-MM           PIC X(02).                       
T20001     05  FILLER                  PIC X(01).                       
T20001     05  WS-CURRENT-DD           PIC X(02).                       
T20001                                                                  
T16471 01  WS-FLAG                     PIC X(01).                       
T16471     88  WS-YY                   VALUE 'Y'.                       
T16471     88  WS-NN                   VALUE 'N'.                       
T16471     88  WS-TT                   VALUE 'T'.                       
T20378     88  WS-BB                   VALUE 'B'.                       
                                                                        
T17007 01  WS-HAS-MST-BILLED           PIC X(01).                       
T17007     88 WS-MST-HAS-BILLED        VALUE 'Y'.                       
T17007     88 WS-MST-HAS-NOT-BILLED    VALUE 'N'.                       
                                                                        
T17007 01  WS-HAS-SUB-BILLED           PIC X(01).                       
T17007     88 WS-SUB-HAS-BILLED        VALUE 'Y'.                       
T17007     88 WS-SUB-HAS-NOT-BILLED    VALUE 'N'.                       
                                                                        
T28783 01  WS-LANDLORD-EXISTS          PIC X(01) VALUE 'N'.             
T28783     88 LANDLORD-EXISTS          VALUE 'Y'.                       
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-SUB-ACCT-BLLED-OK    PIC X(01)  VALUE SPACES.         
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-SUB                  PIC X(01)  VALUE 'S'.            
           05  WS-MASTER               PIC X(01)  VALUE 'M'.            
           05  WS-A                    PIC X(01)  VALUE 'A'.            
           05  WS-B                    PIC X(01)  VALUE 'B'.            
T19676     05  WS-C                    PIC X(01)  VALUE 'C'.            
           05  WS-D                    PIC X(01)  VALUE 'D'.            
           05  WS-E                    PIC X(01)  VALUE 'E'.            
           05  WS-F                    PIC X(01)  VALUE 'F'.            
           05  WS-M                    PIC X(01)  VALUE 'M'.            
           05  WS-P                    PIC X(01)  VALUE 'P'.            
           05  WS-S                    PIC X(01)  VALUE 'S'.            
           05  WS-UPDATE               PIC X(01)  VALUE 'U'.            
           05  WS-DELETE               PIC X(01)  VALUE 'D'.            
           05  WS-INSERT               PIC X(01)  VALUE 'I'.            
T28783     05  WS-MULTIPLE-ROWS        PIC S9(03) VALUE -811.           
                                                                        
T23549 01  WS-STATUS-CODE.                                              
T23549     05  WS-M1                   PIC X(01)  VALUE 'M'.            
T23549     05  WS-N1                   PIC X(01)  VALUE 'N'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH*                                                                         
REARCH 01  TDS-RETURN-FIELDS.                                           
REARCH     05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
REARCH     05  RS-EPP-IND              PIC X(01)      VALUE SPACES.     
REARCH     05  RS-EXIST-IND            PIC X(01)      VALUE SPACES.     
REARCH     05  RS-SEC-IND              PIC X(01)      VALUE SPACES.     
REARCH     05  RS-MST-SAME-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  RS-FINAL-BILL           PIC X(01)      VALUE SPACES.     
REARCH     05  RS-INACTIVE-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  RS-WRITE-OFF            PIC X(01)      VALUE SPACES.     
REARCH     05  RS-BANKRUPT-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  RS-SUB-EXISTS           PIC X(01)      VALUE SPACES.     
REARCH     05  RS-DPP-IND              PIC X(01)      VALUE SPACES.     
REARCH     05  RS-DFA-ACCT-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  RS-CONTRACT-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  RS-SUB-BP-IND           PIC X(01)      VALUE SPACES.     
REARCH     05  RS-ACCT-ON-EPAY-IND     PIC X(01)      VALUE SPACES.     
REARCH*                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-EPP-IND              PIC X(01)      VALUE SPACES.      
           05  S-EXIST-IND            PIC X(01)      VALUE SPACES.      
           05  S-SEC-IND              PIC X(01)      VALUE SPACES.      
           05  S-MST-SAME-IND         PIC X(01)      VALUE SPACES.      
           05  S-FINAL-BILL           PIC X(01)      VALUE SPACES.      
           05  S-INACTIVE-IND         PIC X(01)      VALUE SPACES.      
           05  S-WRITE-OFF            PIC X(01)      VALUE SPACES.      
           05  S-BANKRUPT-IND         PIC X(01)      VALUE SPACES.      
           05  S-SUB-EXISTS           PIC X(01)      VALUE SPACES.      
           05  S-DPP-IND              PIC X(01)      VALUE SPACES.      
           05  S-DFA-ACCT-IND         PIC X(01)      VALUE SPACES.      
           05  S-CONTRACT-IND         PIC X(01)      VALUE SPACES.      
T19479     05  S-SUB-BP-IND           PIC X(01)      VALUE SPACES.      
T23549     05  S-ACCT-ON-EPAY-IND     PIC X(01)      VALUE SPACES.      
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE         PIC X(01) VALUE 'B'.           
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
           05  WS-COLUMN-DESC            PIC X(04) VALUE '****'.        
           05  WS-CHG-COLUMN-VALUE-TEXT  PIC X(04) VALUE '****'.        
           05  WS-CHG-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
           05  WS-PRV-COLUMN-VALUE-TEXT  PIC X(04) VALUE 'NONE'.        
           05  WS-PRV-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-USERID              PIC X(07)                .          
CVT000 01  LINK-RESP-AREA-ID        PIC X(03)                .          
CVT000 01  LINK-MST-ACCT-NO         PIC X(13)                .          
CVT000 01  LINK-SUB-ACCT-NO         PIC X(13)                .          
CVT000 01  LINK-MST-SUB-ACCT-IND    PIC X(01)                .          
CVT000 01  LINK-CODE-SUB-TOTAL      PIC X(18)                .          
CVT000 01  LINK-BILL-TYPE-CODE      PIC X(01)                .          
CVT000 01  LINK-ACTION-IND          PIC X(01)                .          
CVT000 01  LINK-TRAN-COMMENT        PIC X(210)               .          
CVT000 01  LINK-COMMENT-LEN         PIC X(04)                .          
CVT000 01  LINK-SUB-PRNT-BILL       PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-MST-ACCT-NO                                        
CVT000         ,LINK-SUB-ACCT-NO                                        
CVT000         ,LINK-CODE-SUB-TOTAL                                     
CVT000         ,LINK-BILL-TYPE-CODE                                     
CVT000         ,LINK-ACTION-IND                                         
CVT000         ,LINK-TRAN-COMMENT                                       
CVT000         ,LINK-COMMENT-LEN                                        
CVT000         ,LINK-RESP-AREA-ID                                       
CVT000         ,LINK-USERID                                             
CVT000         ,LINK-SUB-PRNT-BILL                                      
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000       ,:S-EPP-IND                  AS    EPP_IND                 
CVT000       ,:S-EXIST-IND                AS    EXIST_IND               
CVT000       ,:S-SEC-IND                  AS    SEC_IND                 
CVT000       ,:S-MST-SAME-IND             AS    MST_SAME_IND            
CVT000       ,:S-FINAL-BILL               AS    FINAL_BILL              
CVT000       ,:S-INACTIVE-IND             AS    INACTIVE_IND            
CVT000       ,:S-WRITE-OFF                AS    WRITE_OFF               
CVT000       ,:S-BANKRUPT-IND             AS    BANKRUPT_IND            
CVT000       ,:S-SUB-EXISTS               AS    SUB_EXISTS              
CVT000       ,:S-DPP-IND                  AS    DPP_IND                 
CVT000       ,:S-DFA-ACCT-IND             AS    DFA_ACCT_IND            
CVT000       ,:S-CONTRACT-IND             AS    CONTRACT_IND            
CVT000       ,:S-ACCT-ON-EPAY-IND         AS    EPAYACCT_IND            
CVT000       ,:S-SUB-BP-IND               AS    SUB_BP_IND              
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-EPP-IND                  AS    EPP_IND                         
MFA-TR*      ,:S-EXIST-IND                AS    EXIST_IND                       
MFA-TR*      ,:S-SEC-IND                  AS    SEC_IND                         
MFA-TR*      ,:S-MST-SAME-IND             AS    MST_SAME_IND                    
MFA-TR*      ,:S-FINAL-BILL               AS    FINAL_BILL                      
MFA-TR*      ,:S-INACTIVE-IND             AS    INACTIVE_IND                    
MFA-TR*      ,:S-WRITE-OFF                AS    WRITE_OFF                       
MFA-TR*      ,:S-BANKRUPT-IND             AS    BANKRUPT_IND                    
MFA-TR*      ,:S-SUB-EXISTS               AS    SUB_EXISTS                      
MFA-TR*      ,:S-DPP-IND                  AS    DPP_IND                         
MFA-TR*      ,:S-DFA-ACCT-IND             AS    DFA_ACCT_IND                    
MFA-TR*      ,:S-CONTRACT-IND             AS    CONTRACT_IND                    
MFA-TR*      ,:S-ACCT-ON-EPAY-IND         AS    EPAYACCT_IND                    
MFA-TR*      ,:S-SUB-BP-IND               AS    SUB_BP_IND                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-MST-ACCT-NO          TO PARM-MST-ACCT-NO         . 
CVT000     MOVE LINK-SUB-ACCT-NO          TO PARM-SUB-ACCT-NO         . 
CVT000     MOVE LINK-CODE-SUB-TOTAL       TO PARM-CODE-SUB-TOTAL      . 
CVT000     MOVE LINK-BILL-TYPE-CODE       TO PARM-BILL-TYPE-CODE      . 
CVT000     MOVE LINK-ACTION-IND           TO PARM-ACTION-IND          . 
CVT000     MOVE LINK-TRAN-COMMENT         TO PARM-TRAN-COMMENT        . 
CVT000     MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN         . 
CVT000     MOVE LINK-RESP-AREA-ID         TO PARM-RESP-AREA-ID        . 
CVT000     MOVE LINK-USERID               TO PARM-USERID              . 
CVT000     MOVE LINK-SUB-PRNT-BILL        TO PARM-SUB-PRNT-BILL       . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-MST-ACCT-NO-RED     TO WS-MST-ACCT-NO-NUM.         
           MOVE PARM-SUB-ACCT-NO-RED     TO WS-SUB-ACCT-NO-NUM.         
T23549     MOVE WS-SUB-ACCT-NO-NUM       TO BE-ACCOUNT-NO.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-PROCESS-SUBACCT           THRU 2200-EXIT.       
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
T14630     IF WS-REC-EXISTS = WS-YES                                    
T14630        IF WS-DEP-EXISTS = WS-YES                                 
T14630           MOVE WS-REC-AND-DEP-RC TO RS-RETURN-CODE               
T14630        ELSE                                                      
T14630           MOVE WS-REC-RC         TO RS-RETURN-CODE               
T14630        END-IF                                                    
T14630     ELSE                                                         
T14630        IF WS-DEP-EXISTS = WS-YES                                 
T14630           MOVE WS-DEP-RC         TO RS-RETURN-CODE               
T14630        END-IF                                                    
T14630     END-IF.                                                      
T14630                                                                  
T11895     IF RS-RETURN-CODE = 0                                        
T11895        IF WS-COUNT-CONTRACT > 0                                  
T11895           MOVE 9999 TO RS-RETURN-CODE                            
T11895        END-IF                                                    
T11895     END-IF.                                                      
           MOVE '2000'                TO ACTIVE-PARAGRAPH.              
REARCH     PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT.                                             *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
REARCH     MOVE RS-EPP-IND                 TO S-EPP-IND.                
REARCH     MOVE RS-EXIST-IND               TO S-EXIST-IND.              
REARCH     MOVE RS-SEC-IND                 TO S-SEC-IND.                
REARCH     MOVE RS-MST-SAME-IND            TO S-MST-SAME-IND.           
REARCH     MOVE RS-FINAL-BILL              TO S-FINAL-BILL.             
REARCH     MOVE RS-INACTIVE-IND            TO S-INACTIVE-IND.           
REARCH     MOVE RS-WRITE-OFF               TO S-WRITE-OFF.              
REARCH     MOVE RS-BANKRUPT-IND            TO S-BANKRUPT-IND.           
REARCH     MOVE RS-SUB-EXISTS              TO S-SUB-EXISTS.             
REARCH     MOVE RS-DPP-IND                 TO S-DPP-IND.                
REARCH     MOVE RS-DFA-ACCT-IND            TO S-DFA-ACCT-IND.           
REARCH     MOVE RS-CONTRACT-IND            TO S-CONTRACT-IND.           
REARCH     MOVE RS-SUB-BP-IND              TO S-SUB-BP-IND.             
REARCH     MOVE RS-ACCT-ON-EPAY-IND        TO S-ACCT-ON-EPAY-IND.       
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-SUBACCT                                           *        
      *                                                                *        
      *     1. EDIT SUBACCOUNT NO                                      *        
      *     2. PERFORM DATABASE UPDATE/INSERT/DELETE BASED ON          *        
      *        USER SELECTION                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-SUBACCT.                                            
                                                                        
           MOVE WS-N TO RS-EPP-IND                                      
                        RS-SEC-IND                                      
                        RS-MST-SAME-IND                                 
                        RS-FINAL-BILL                                   
                        RS-BANKRUPT-IND                                 
                        RS-WRITE-OFF                                    
                        RS-INACTIVE-IND                                 
                        RS-SUB-EXISTS                                   
                        RS-DPP-IND                                      
                        RS-DFA-ACCT-IND                                 
                        RS-CONTRACT-IND.                                
PCR549     MOVE WS-SUB-ACCT-NO-NUM      TO AT-ACCOUNT-NO.               
                                                                        
T23549     PERFORM 7450-SELECT-EPAY-ACCOUNT                             
T23549                                   THRU 7450-EXIT.                
T23549     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T23549        NEXT SENTENCE                                             
T23549     ELSE                                                         
T23549        MOVE WS-YES                TO   RS-ACCT-ON-EPAY-IND       
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
T23549        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
T23549        PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
T23549     END-IF.                                                      
           PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT.                
                                                                        
      ** CHECK IF SUBACCOUNT EXISTS ON TABLE                                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE WS-YES                  TO RS-EXIST-IND             
T22382         MOVE AT-MST-SUB-ACCT-IND     TO WS-MST-SUB-ACCT-IND      
T22382         MOVE AT-CREDIT-GROUP         TO WS-CREDIT-GROUP          
T22382         MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT    
T22382         MOVE AT-BILL-CYCLE           TO WS-SUB-BILL-CYCLE        
T22382         MOVE AT-REV-MTH-LST-NRML     TO WS-SUB-REV-MTH-LST       
T22382         MOVE WS-NULL-IND-1           TO WS-SUB-00-DAY-NULL       
           ELSE                                                         
               MOVE WS-NO                   TO RS-EXIST-IND             
           END-IF.                                                      
                                                                        
      ************************************************************              
      ** CHANGED ALL AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT             
      ** ELEMENTS TO CONFORM TO STANDARDS - MR                                  
      ************************************************************              
      ** CHECK FOR EPP, ACTIVE SECURITIES, DPP, ACCOUNT STATUS                  
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
             AND (RS-EXIST-IND = WS-YES)                                
               IF   WS-CODE-BUDGET           = 'A'                      
                    MOVE WS-YES TO RS-EPP-IND                           
               ELSE IF (WS-CODE-DEP-ON-HAND  = 'A')                     
                    OR (WS-CODE-GUARANTOR    = 'A')                     
                    MOVE WS-YES TO RS-SEC-IND                           
               ELSE IF (AT-CODE-ACCT-STAT    = 'B')                     
                    MOVE WS-YES TO RS-FINAL-BILL                        
               ELSE IF (AT-CODE-ACCT-STAT    = 'J')                     
                    MOVE WS-YES TO RS-INACTIVE-IND                      
               ELSE IF (AT-CODE-ACCT-STAT    = 'S')                     
                    MOVE WS-YES TO RS-WRITE-OFF                         
               ELSE IF (AT-BANKRUPTCY-IND    = 'B')                     
                    MOVE WS-YES TO RS-BANKRUPT-IND                      
               ELSE IF (WS-CODE-DPP-ACCT     = 'A')                     
                    MOVE WS-YES TO RS-DPP-IND                           
               ELSE IF (WS-CODE-DFA-ACCT     = 'A')                     
                    MOVE WS-YES TO RS-DFA-ACCT-IND                      
               ELSE IF (WS-CODE-CONTRACT     = 'A')                     
                    MOVE WS-YES TO RS-CONTRACT-IND                      
               END-IF                                                   
           END-IF
                    END-IF
                    END-IF
                    END-IF
                    END-IF
                    END-IF
                    END-IF
               END-IF
           END-IF.                                                      
                                                                        
      ** CHECK THAT SUBACCOUNT IS NOT ALREADY AN EXISTING MASTER ACCT           
           IF (RS-EPP-IND = WS-NO) AND (RS-SEC-IND = WS-NO)             
             AND (RS-EXIST-IND = WS-YES)                                
             AND (RS-INACTIVE-IND = WS-NO) AND (RS-WRITE-OFF = WS-NO)   
             AND (RS-BANKRUPT-IND = WS-NO) AND (RS-DPP-IND = WS-NO)     
             AND (RS-DFA-ACCT-IND = WS-NO)                              
             AND (RS-CONTRACT-IND = WS-NO)                              
               PERFORM 7100-SELECT-MASTER    THRU 7100-EXIT             
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   MOVE WS-YES          TO RS-MST-SAME-IND              
               ELSE                                                     
                   MOVE WS-NO           TO RS-MST-SAME-IND              
                   MOVE SUCCESSFUL-CALL TO WS-ACTIVE-RETURN-CODE        
               END-IF                                                   
           END-IF.                                                      
                                                                        
      ** ALSO CHECK THAT FOR INSERT DETAIL, IF SUB ACCT ALREADY EXISTS          
           IF (PARM-ACTION-IND = 'I') AND (AT-MST-SUB-ACCT-IND = 'S')   
               MOVE WS-YES              TO RS-SUB-EXISTS                
           END-IF.                                                      
                                                                        
T20864                                                                  
T20864     MOVE WS-YES TO WS-AR-XFER-IND                                
T20864                    WS-BILL-HIST-XFER-IND.                        
                                                                        
PCR549** CHECK IF THE SUB ACCOUNT IS A NON UTILITY ACCOUNT                      
           IF WS-CODE-UTL       =  SPACES AND                           
              WS-CODE-BUDGET    =  SPACES AND                           
              AT-CODE-ACCT-STAT NOT = WS-P                              
              MOVE WS-YES TO WS-NON-UTIL-ACCT                           
           ELSE                                                         
              MOVE WS-NO  TO WS-NON-UTIL-ACCT                           
           END-IF                                                       
                                                                        
      ** PERFORM UPDATE/INSERT/DELETE BASED ON USER SELECTION                   
A01118     IF PARM-ACTION-IND = WS-DELETE  OR                           
             ((RS-EPP-IND = WS-NO) AND (RS-SEC-IND = WS-NO)             
             AND (RS-MST-SAME-IND = WS-NO) AND (RS-EXIST-IND = WS-YES)  
             AND (RS-INACTIVE-IND = WS-NO) AND (RS-WRITE-OFF = WS-NO)   
             AND (RS-BANKRUPT-IND = WS-NO) AND (RS-SUB-EXISTS = WS-NO)  
             AND (RS-DPP-IND = WS-NO)                                   
             AND (RS-DFA-ACCT-IND = WS-NO)                              
A01118       AND (RS-CONTRACT-IND = WS-NO))                             
T14630**CHECK IF SUB HAS ANY ACTIVE RECEIVABLES OR DEPOSITS                     
T14630         PERFORM 7425-SELECT-SUB-RECVBLS          THRU 7425-EXIT  
T14630         PERFORM 7426-SELECT-SUB-DEPOSITS         THRU 7426-EXIT  
T14630         IF (WS-REC-EXISTS = WS-NO) AND (WS-DEP-EXISTS = WS-NO)   
                  PERFORM 5000-PROCESS-TRAN-COMM        THRU 5000-EXIT  
                  EVALUATE PARM-ACTION-IND                              
                      WHEN WS-DELETE                                    
PCR549                  IF WS-NON-UTIL-ACCT = WS-YES                    
PCR549                     MOVE WS-D TO WS-CREDIT-GROUP                 
PCR549                  ELSE                                            
T19676                     MOVE WS-C TO WS-CREDIT-GROUP                 
PCR549                  END-IF                                          
T11895                  PERFORM 8801-CHK-CONTRACT       THRU 8801-EXIT  
                        PERFORM 8300-DELETE-SUBACCT     THRU 8300-EXIT  
                        PERFORM 8600-UPDATE-ACCT-AFTER-DEL              
                                                        THRU 8600-EXIT  
T19479                  PERFORM 8650-CK-PRINT-SUB-BILL  THRU 8650-EXIT  
                        PERFORM 8700-CHK-LEFT-SUBACCT   THRU 8700-EXIT  
                        IF WS-COUNT-SUB-ACCT = 0                        
PCR549*                   ** RESET CREDIT GROUP TO NON-UTILITY                  
PCR549*                   ** IF MASTER ACCOUNT IS NON UTILITY.                  
PCR549                    MOVE WS-MST-ACCT-NO-NUM    TO                 
PCR549                                               AT-ACCOUNT-NO      
T28783                                               WS-LL-MST-ACCT-NUM 
PCR549                    PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT  
PCR549                    MOVE AT-CREDIT-GROUP       TO WS-CREDIT-GROUP 
PCR549                    MOVE AT-CODES-DATA-PRESENT TO                 
PCR549                                             WS-CODES-DATA-PRESENT
T16154                    MOVE WS-D              TO WS-CREDIT-GROUP     
T16154                    MOVE WS-ACTIVE         TO WS-ACCT-STATUS      
T16567                    MOVE SPACES            TO WS-MST-SUB-ACCT-IND 
T17243                    MOVE WS-N              TO WS-ACCOUNT-TYPE-CODE
                          PERFORM 8800-UPDATE-MST-ACCT THRU 8800-EXIT   
T28783                    PERFORM 7200-CHK-LANDLORD-EXISTS              
T28783                                                 THRU 7200-EXIT   
T28783                    IF LANDLORD-EXISTS                            
T28783                    PERFORM 8450-UPDATE-LANDLORD-ACCT             
T28783                                                 THRU 8450-EXIT   
T28783                    END-IF                                        
                        END-IF                                          
                      WHEN WS-INSERT                                    
T18346* CANNOT ADD A FINAL BILLED SUB.  PB HANDLES BY GIVING APPROPRIATE        
T18346* MESSAGE EVENTHOUGH RETURN CODE FROM RPC IS ZERO                         
T18346                 IF RS-FINAL-BILL = WS-NO THEN                    
PCR549                  MOVE WS-S TO WS-CREDIT-GROUP                    
T16471                  MOVE WS-MST-ACCT-NO-NUM      TO AT-ACCOUNT-NO   
T16471                  PERFORM 7000-SELECT-ACCOUNT  THRU 7000-EXIT     
T16471                  MOVE AT-BILL-CYCLE       TO WS-MASTER-BILL-CYCLE
T16471                  MOVE AT-REV-MTH-LST-NRML TO WS-MST-REV-MTH-LST  
T17007                  MOVE WS-NULL-IND-1       TO WS-MST-00-DAY-NULL  
T16592                  MOVE AT-CODE-PRNT-BLL-MST TO                    
T16592                       WS-CODE-PRNT-BLL-MST                       
T16471                  PERFORM 7500-SET-BLLD-OK-FLAG   THRU 7500-EXIT  
                        PERFORM 8200-INSERT-SUBACCT     THRU 8200-EXIT  
                        PERFORM 8500-UPDATE-SUBACCT     THRU 8500-EXIT  
                        PERFORM 8700-CHK-LEFT-SUBACCT   THRU 8700-EXIT  
                        IF WS-COUNT-SUB-ACCT = 1                        
PCR549*                   ** SET CREDIT GROUP TO MASTER                         
PCR549*                   ** IF MASTER ACCOUNT IS NON-UTILITY.                  
PCR549                    MOVE WS-MST-ACCT-NO-NUM      TO AT-ACCOUNT-NO 
PCR549                    PERFORM 7000-SELECT-ACCOUNT  THRU 7000-EXIT   
PCR549                    MOVE AT-CODES-DATA-PRESENT   TO               
PCR549                                             WS-CODES-DATA-PRESENT
T16567*  WHEN THE FIRST SUB A/C IS ADDED, SET THE CREDIT GRP TO MASTER.         
T16567*  ALSO, SET THE MST SUB ACCT IND TO 'M' FOR MASTER A/C.                  
PCR549                       MOVE WS-M   TO WS-CREDIT-GROUP             
T16567                    MOVE WS-MASTER        TO WS-MST-SUB-ACCT-IND  
                          MOVE WS-ACTIVE        TO WS-ACCT-STATUS       
T17243                    MOVE WS-B              TO WS-ACCOUNT-TYPE-CODE
                          PERFORM 8800-UPDATE-MST-ACCT THRU 8800-EXIT   
                        END-IF                                          
T18346                 END-IF                                           
                      WHEN WS-UPDATE                                    
                        PERFORM 8400-UPDATE-MSTSUB     THRU 8400-EXIT   
                  END-EVALUATE                                          
T14630        END-IF                                                    
T18346     ELSE                                                         
T18346        MOVE  5000      TO     WS-ACTIVE-RETURN-CODE              
           END-IF.                                                      
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5000-PROCESS-TRAN-COMM                                      *           
      *                                                             *           
      * PROCESS JOURNALING FOR TRANSACTION COMMENTS (MH, MI)        *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
                                                                        
       5000-PROCESS-TRAN-COMM.                                          
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD            THRU 5100-EXIT.       
                                                                        
           EVALUATE PARM-ACTION-IND                                     
             WHEN WS-INSERT                                             
               MOVE WS-SUB         TO WS-MST-SUB-ACCT-IND               
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
             WHEN WS-UPDATE                                             
               PERFORM 7300-SELECT-MSTSUB         THRU 7300-EXIT        
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
             WHEN WS-DELETE                                             
               PERFORM 7300-SELECT-MSTSUB         THRU 7300-EXIT        
               PERFORM 5400-MOVE-DEL-TRAN-DET     THRU 5400-EXIT        
               MOVE WS-SPACE       TO WS-MST-SUB-ACCT-IND               
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
           END-EVALUATE.                                                
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      * 5100-MOVE-TRAN-HEAD                                         *           
      *                                                             *           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
                                                                        
       5100-MOVE-TRAN-HEAD.                                             
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
              INTO :MH-TRANS-HIST-SEQ-NO                                
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP                                          
MFA-TR*       INTO :MH-TRANS-HIST-SEQ-NO                                        
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
CBSI           MOVE '5100'                  TO ACTIVE-PARAGRAPH         
CBSI           MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
               MOVE 'CSS_MODEL_SQL'         TO TABLE-1                  
CBSI           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
CBSI           MOVE PARM-SUB-ACCT-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
              INTO :MH-DATE-TRANS                                       
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*       INTO :MH-DATE-TRANS                                               
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
CBSI           MOVE '5100'                  TO ACTIVE-PARAGRAPH         
CBSI           MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
               MOVE 'CSS_MODEL_SQL'         TO TABLE-1                  
CBSI           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
CBSI           MOVE PARM-SUB-ACCT-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                  TO MH-CODE-TRAN-TYPE.              
           MOVE PARM-RESP-AREA-ID    TO MH-RESP-AREA-ID.                
           MOVE WS-SUB-ACCT-NO-NUM   TO MH-ACCOUNT-NO.                  
           MOVE ZERO                 TO MH-CUSTOMER-NO.                 
           MOVE ZERO                 TO MH-PREMISE-NO.                  
           MOVE PARM-USERID          TO MH-USER-ID.                     
           MOVE 'PANEL301'           TO MH-APPL-PROGRAM-ID.             
           MOVE PARM-COMMENT-LEN-RED TO MH-TRAN-COMMENT-LEN.            
           MOVE PARM-TRAN-COMMENT    TO MH-TRAN-COMMENT-TEXT.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5300-MOVE-UPD-TRAN-DET.                                     *           
      *                                                             *           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5300-MOVE-UPD-TRAN-DET.                                          
             MOVE '5300' TO ACTIVE-PARAGRAPH.                           
             MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             IF (PARM-CODE-SUB-TOTAL NOT = MU-CODE-SUB-TOTAL)           
               AND (PARM-ACTION-IND = WS-UPDATE)                        
PCR638           MOVE +18                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE MU-CODE-SUB-TOTAL     TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE PARM-CODE-SUB-TOTAL   TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 'CODE-SUB-TOTAL '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1       TO WS-TRAN-APPL-NO                         
             END-IF.                                                    
                                                                        
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             IF WS-MST-ACCT-NO-NUM    NOT = AT-ACCT-XFER-TO             
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-MST-ACCT-NO-NUM    TO MI-CHG-COLUMN-VALUE-TEXT 
T12439           IF AT-ACCT-XFER-TO EQUAL ZEROS                         
T12439              MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT            
T12439           ELSE                                                   
T12439              MOVE AT-ACCT-XFER-TO  TO MI-PRV-COLUMN-VALUE-TEXT   
T12439           END-IF                                                 
                 MOVE 'ACCT XFER TO   '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             IF WS-CREDIT-GROUP       NOT = AT-CREDIT-GROUP             
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CREDIT-GROUP       TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE AT-CREDIT-GROUP       TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 'CREDIT GROUP   '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5400-MOVE-DEL-TRAN-DET                                      *           
      *                                                             *           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5400-MOVE-DEL-TRAN-DET.                                          
             MOVE '5400' TO ACTIVE-PARAGRAPH.                           
             MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +2  TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11 TO MI-CHG-COLUMN-VALUE-LEN.                       
             MOVE '**DELETED**' TO MI-CHG-COLUMN-VALUE-TEXT.            
             MOVE MU-CODE-SUB-TOTAL     TO MI-PRV-COLUMN-VALUE-TEXT.    
             MOVE 'CODE SUB TOTAL '     TO MI-COLUMN-DESC.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1       TO WS-TRAN-APPL-NO.                            
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +13 TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11 TO MI-CHG-COLUMN-VALUE-LEN.                       
             MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT.      
             MOVE WS-MST-ACCT-NO-NUM  TO MI-PRV-COLUMN-VALUE-TEXT.      
             MOVE 'MST ACCT NO    '   TO MI-COLUMN-DESC.                
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1 TO WS-TRAN-APPL-NO.                                  
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +1  TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11 TO MI-CHG-COLUMN-VALUE-LEN.                       
             MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT.      
             MOVE WS-SPACE            TO MI-PRV-COLUMN-VALUE-TEXT.      
             MOVE 'SUB ACT BLLD OK'   TO MI-COLUMN-DESC.                
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1 TO WS-TRAN-APPL-NO.                                  
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +13 TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11 TO MI-CHG-COLUMN-VALUE-LEN.                       
             MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT.      
             MOVE WS-SUB-ACCT-NO-NUM  TO MI-PRV-COLUMN-VALUE-TEXT.      
             MOVE 'SUB ACCT NO    '   TO MI-COLUMN-DESC.                
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1 TO WS-TRAN-APPL-NO.                                  
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      **  6530-LOAD-MNT-TRANS-HIST                                              
      **  6540-INSERT-MNT-TRANS-HIST                                            
      **  6550-INSERT-MT-TRN-HST-DET                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *    SELECT ACCOUNT DATA FOR MASTER/SUB ACCOUNT NO               *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT,                                
                     ACCT_XFER_TO,                                      
                     AR_XFER_IND,                                       
                     BILL_HIST_XFER_IND,                                
                     MST_SUB_ACCT_IND,                                  
                     CREDIT_GROUP,                                      
                     CODE_ACCT_STAT,                                    
                     BANKRUPTCY_IND,                                    
T16471               BILL_CYCLE,                                        
T16471               REV_MTH_LST_NRML,                                  
T16592               CODE_PRNT_BLL_MST,                                 
T17007               DATE_BILL_DAY_00,                                  
T20859               MEMO_BILL_IND                                      
                INTO :AT-CODES-DATA-PRESENT,                            
                     :AT-ACCT-XFER-TO,                                  
                     :AT-AR-XFER-IND,                                   
                     :AT-BILL-HIST-XFER-IND,                            
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-CREDIT-GROUP,                                  
                     :AT-CODE-ACCT-STAT,                                
                     :AT-BANKRUPTCY-IND,                                
T16471               :AT-BILL-CYCLE,                                    
T16471               :AT-REV-MTH-LST-NRML,                              
T16592               :AT-CODE-PRNT-BLL-MST,                             
T17007               :AT-DATE-BILL-DAY-00 :WS-NULL-IND-1,                
T20859               :AT-MEMO-BILL-IND                                  
                FROM CSS_ACCOUNT                                        
PCR549*         WHERE ACCOUNT_NO = :WS-SUB-ACCT-NO-NUM                          
PCR549          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-MASTER                                             *        
      *    DETERMINE IF SUB ACCOUNT NO ALREADY EXISTS AS A MASTER ACCT *        
      ******************************************************************        
       7100-SELECT-MASTER.                                              
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :RS-MST-SAME-IND                                   
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO = :WS-SUB-ACCT-NO-NUM                  
                  AND MST_SUB_ACCT_IND = :WS-MASTER                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7100'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'MST_SUB_ACCT_IND'   TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-MASTER            TO HOSTVAR-ELEMENT-1            
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28783************************************************************              
T28783* 7200-CHK-LANDLORD-EXISTS.                                *              
T28783*                                                          *              
T28783* CHECKS IF THE ACCOUNT IS A LANDLORD ACCOUNT.             *              
T28783************************************************************              
T28783 7200-CHK-LANDLORD-EXISTS.                                        
T28783     EXEC SQL                                                     
T28783         SELECT 'Y'                                               
T28783         INTO :WS-LANDLORD-EXISTS                                 
T28783         FROM CSS_LANDLORD                                        
T28783         WHERE  LL_MASTER_ACCT_NO = :WS-LL-MST-ACCT-NUM           
T28783     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28783                                                                  
T28783     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T28783                                                                  
T28783     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T28783                                             OR WS-MULTIPLE-ROWS  
T28783        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR         
T28783                                                WS-MULTIPLE-ROWS  
T28783           SET LANDLORD-EXISTS          TO TRUE                   
T28783        END-IF                                                    
T28783     ELSE                                                         
T28783        MOVE '7200'                     TO ACTIVE-PARAGRAPH       
T28783        MOVE 'CSS_LANDLORD'             TO TABLE-1                
T28783        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T28783        MOVE WS-LL-MST-ACCT-NUM         TO HOSTVAR-ELEMENT-1      
T28783        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T28783        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T28783     END-IF.                                                      
T28783 7200-EXIT.                                                       
T28783     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-MSTSUB                                             *        
      *    SELECT DATA RELATING TO MASTER/SUB RELATIONSHIP             *        
      ******************************************************************        
       7300-SELECT-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SUB_TOTAL,                                    
                     SUB_ACCT_BLLD_OK                                   
                INTO :MU-CODE-SUB-TOTAL,                                
                     :MU-SUB-ACCT-BLLD-OK                               
                FROM CSS_MSTSUB_ACCT                                    
               WHERE MST_ACCT_NO = :WS-MST-ACCT-NO-NUM                  
                 AND SUB_ACCT_NO = :WS-SUB-ACCT-NO-NUM                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'        TO TABLE-ELEMENT-1              
              MOVE 'SUB_ACCT_NO'        TO TABLE-ELEMENT-2              
              MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-SUB-ACCT                                           *        
      *    SELECT ACCOUNT DATA RELATING TO MASTER/SUB RELATIONSHIP     *        
      ******************************************************************        
       7400-SELECT-SUB-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT MST_SUB_ACCT_IND,                                  
                     ACCT_XFER_TO,                                      
                     AR_XFER_IND,                                       
                     BILL_HIST_XFER_IND                                 
                INTO :AT-MST-SUB-ACCT-IND,                              
                     :AT-ACCT-XFER-TO,                                  
                     :AT-AR-XFER-IND,                                   
                     :AT-BILL-HIST-XFER-IND                             
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :WS-SUB-ACCT-NO-NUM                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-SUB-ACCT-NO     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7425-SELECT-SUB-RECVBLS                                        *        
      *    CHECK IF THERE ARE ANY ACTIVE RECEIVABLES ON THE SUB ACCT.  *        
      ******************************************************************        
       7425-SELECT-SUB-RECVBLS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-REC-EXISTS                                     
                FROM CSS_AR_CNTL                                        
               WHERE ACCOUNT_NO = :WS-SUB-ACCT-NO-NUM                   
                 AND ITEM_ID    = 0                                     
                 AND (AMT_AR_DAY_00    > 0                              
                   OR AMT_AR_DAY_30    > 0                              
                   OR AMT_AR_DAY_60    > 0                              
                   OR AMT_AR_DAY_90    > 0                              
                   OR AMT_TRAN_BALANCE > 0)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7425'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7426-SELECT-SUB-DEPOSITS                                       *        
      *    CHECK IF THERE ARE ANY DEPOSITS ON THE SUB ACCT.            *        
      ******************************************************************        
       7426-SELECT-SUB-DEPOSITS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-DEP-EXISTS                                     
                FROM CSS_DEP_ON_HAND                                    
               WHERE ACCOUNT_NO = :WS-SUB-ACCT-NO-NUM                   
                 AND DEPOSIT_STATUS_CD IN ('A','P')                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7426'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_DEP_ON_HAND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7426-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23549******************************************************************        
T23549* 7450-SELECT-EPAY-ACCOUNT                                       *        
T23549*    CHECK FOR  EPAYMENT ACCOUNT NUMBERS                         *        
T23549******************************************************************        
T23549*                                                                         
T23549 7450-SELECT-EPAY-ACCOUNT.                                        
T23549                                                                  
T23549     MOVE '7450'                     TO ACTIVE-PARAGRAPH.         
T23549                                                                  
T23549     EXEC SQL                                                     
T23549         SELECT 'Y'                                               
T23549         INTO :RS-ACCT-ON-EPAY-IND                                
T23549         FROM CSS_BANK_EFT                                        
T23549         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        
T23549         AND STATUS_CODE IN (:WS-M1,:WS-N1)                       
T23549     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23549                                                                  
T23549     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23549                                                                  
T23549     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T23549        NOT-FOUND                                                 
T23549        NEXT SENTENCE                                             
T23549     ELSE                                                         
T23549        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T23549        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T23549        MOVE 'CSS_BANK_EFT      '       TO TABLE-1                
T23549        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T23549        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T23549        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T23549     END-IF.                                                      
T23549 7450-EXIT.                                                       
T23549     EXIT.                                                        
                                                                        
T16471 7500-SET-BLLD-OK-FLAG.                                           
                                                                        
           MOVE SPACES    TO  WS-FLAG.                                  
T17007*    OBTAIN TODAY'S DATE                                                  
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
                   INTO :BN-DATE-EXTRACT                                
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*            INTO :BN-DATE-EXTRACT                                        
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
CBSI           MOVE '7500'                   TO ACTIVE-PARAGRAPH        
CBSI           MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
               MOVE 'CSS_MODEL_SQL'          TO TABLE-1                 
CBSI           MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
CBSI           MOVE PARM-SUB-ACCT-NO         TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
T20001     MOVE BN-DATE-EXTRACT TO WS-CURRENT-DATE.                     
T20378     MOVE 'B' TO WS-SUB-ACCT-BLLED-OK.                            
                                                                        
       7500-EXIT.                                                       
T16471      EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8200-INSERT-SUBACCT                                            *        
      *    INSERT ROW FOR NEW SUB ACCOUNT NO                           *        
      ******************************************************************        
       8200-INSERT-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MSTSUB_ACCT                               
                    ( CODE_SUB_TOTAL                                    
                    , MST_ACCT_NO                                       
                    , SUB_ACCT_BLLD_OK                                  
                    , SUB_ACCT_NO)                                      
              VALUES (:PARM-CODE-SUB-TOTAL                              
                    , :WS-MST-ACCT-NO-NUM                               
T16471              , :WS-SUB-ACCT-BLLED-OK                             
                    , :WS-SUB-ACCT-NO-NUM)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                      
              MOVE 'MST_ACCT_NO'        TO TABLE-ELEMENT-1              
              MOVE 'SUB_ACCT_NO'        TO TABLE-ELEMENT-2              
              MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-DELETE-SUBACCT                                            *        
      *    DELETE ROW FROM CSS_MSTSUB_ACCT                             *        
      ******************************************************************        
       8300-DELETE-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_MSTSUB_ACCT                               
              WHERE MST_ACCT_NO    = :WS-MST-ACCT-NO-NUM                
                AND SUB_ACCT_NO    = :WS-SUB-ACCT-NO-NUM                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8300'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                     
               MOVE 'MST_ACCT_NO'        TO TABLE-ELEMENT-1             
               MOVE 'SUB_ACCT_NO'        TO TABLE-ELEMENT-2             
               MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1           
               MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-UPDATE-MSTSUB                                             *        
      *    UPDATE CSS_MSTSUB_ACCT                                      *        
      ******************************************************************        
       8400-UPDATE-MSTSUB.                                              
                                                                        
               EXEC SQL                                                 
                  UPDATE CSS_MSTSUB_ACCT                                
                     SET CODE_SUB_TOTAL    = :PARM-CODE-SUB-TOTAL       
                  WHERE  MST_ACCT_NO       = :WS-MST-ACCT-NO-NUM        
                    AND  SUB_ACCT_NO       = :WS-SUB-ACCT-NO-NUM        
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                   
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '8400'               TO ACTIVE-PARAGRAPH        
                   MOVE 'UPDATE'             TO ABEND-FUNCTION          
CBSI               MOVE SPACES               TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                   MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                 
                   MOVE 'MST_ACCT_NO'        TO TABLE-ELEMENT-1         
                   MOVE 'SUB_ACCT_NO'        TO TABLE-ELEMENT-2         
                   MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1       
                   MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28783************************************************************              
T28783* 8450-UPDATE-LANDLORD-ACCT.                               *              
T28783*                                                          *              
T28783* SET LL_MASTER_ACCT_NO TO ZERO FOR FINALLING MASTER ACCTS *              
T28783************************************************************              
T28783 8450-UPDATE-LANDLORD-ACCT.                                       
T28783     EXEC SQL                                                     
T28783         UPDATE CSS_LANDLORD                                      
T28783            SET LL_MASTER_ACCT_NO  = 0                            
T28783          WHERE LL_MASTER_ACCT_NO  = :WS-LL-MST-ACCT-NUM          
T28783     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28783                                                                  
T28783     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T28783                                                                  
T28783     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T28783        NEXT SENTENCE                                             
T28783     ELSE                                                         
T28783        MOVE '8450'                    TO ACTIVE-PARAGRAPH        
T28783        MOVE 'CSS_LANDLORD'            TO TABLE-1                 
T28783        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
T28783        MOVE WS-LL-MST-ACCT-NUM        TO HOSTVAR-ELEMENT-1       
T28783        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T28783        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T28783     END-IF.                                                      
T28783                                                                  
T28783 8450-EXIT.                                                       
T28783     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-UPDATE-SUBACCT                                            *        
      *    UPDATE ACCOUNT DATA FOR SUB ACCOUNT NO                      *        
      ******************************************************************        
       8500-UPDATE-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET  MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND          
                   , ACCT_XFER_TO       = :WS-MST-ACCT-NO-NUM           
T20864             , AR_XFER_IND        = :WS-YES                       
T20864             , BILL_HIST_XFER_IND = :WS-YES                       
                   , CREDIT_GROUP       = :WS-CREDIT-GROUP              
T16592             , CODE_PRNT_BLL_MST  = :WS-CODE-PRNT-BLL-MST         
T20859             , MEMO_BILL_IND      = :WS-SPACE                     
              WHERE ACCOUNT_NO          = :WS-SUB-ACCT-NO-NUM           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8500'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8600-UPDATE-ACCT-AFTER-DEL                                     *        
      *     UPDATE MST_SUB_ACCT_IND ON CSS_ACCOUNT                     *        
      ******************************************************************        
       8600-UPDATE-ACCT-AFTER-DEL.                                      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                SET    MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND,       
                       CREDIT_GROUP       = :WS-CREDIT-GROUP,           
                       AR_XFER_IND        = :WS-SPACE,                  
                       BILL_HIST_XFER_IND = :WS-SPACE,                  
                       ACCT_XFER_TO       = 0                           
                WHERE  ACCOUNT_NO         = :WS-SUB-ACCT-NO-NUM         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8600'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19479******************************************************************        
T19479* 8650-CK-PRINT-SUB-BILL                                         *        
T19479* CK IF INDICATOR IS SET TO 'Y' (PRINT THE SUBS BILL AFTER IT HAS*        
T19479* BEEN DELETED). IF SO, UPDATE THE CSS_HELD_BP_SUBS TABLE,       *        
T19479* PULL-FL COLUMN WITH A 'D'. THIS WILL TRIGGER BILL PRINT TO     *        
T19479* PRINT THE SUB'S BILL.                                          *        
T19479******************************************************************        
T19479 8650-CK-PRINT-SUB-BILL.                                          
T19479     IF PARM-SUB-PRNT-BILL = 'Y'                                  
T19479        EXEC SQL                                                  
T19479          UPDATE CSS_HELD_BP_SUBS                                 
T19479             SET PULL_FL           = :WS-D                        
T19479           WHERE ACCOUNT_NO        = :WS-SUB-ACCT-NO-NUM          
T19479        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19479                                                                  
T19479        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
T19479        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T19479           MOVE 'Y'                   TO RS-SUB-BP-IND            
T19479        ELSE                                                      
T19479           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
T19479              MOVE 'N'                TO RS-SUB-BP-IND            
T19479           ELSE                                                   
T19479              MOVE '8650'             TO ACTIVE-PARAGRAPH         
T19479              MOVE 'UPDATE'           TO ABEND-FUNCTION           
T19479              MOVE SPACES             TO ABEND-SQL-PREDICATES     
T19479                                         ABEND-TABLES             
T19479              MOVE 'CSS_HELD_BP_SUBS' TO TABLE-1                  
T19479              MOVE 'ACCOUNT-NO'       TO TABLE-ELEMENT-1          
T19479              MOVE WS-SUB-ACCT-NO-NUM TO HOSTVAR-ELEMENT-1        
T19479              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
T19479              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
T19479           END-IF                                                 
T19479        END-IF                                                    
T19749     END-IF.                                                      
T19479                                                                  
T19479 8650-EXIT.                                                       
T19479     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8700-CHK-LEFT-SUBACCT                                          *        
      *     CHECK THE EXISTENCE OF SUB-ACCOUNTS AGAINST A MAST. AC.    *        
      ******************************************************************        
       8700-CHK-LEFT-SUBACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT-SUB-ACCT                                 
                FROM CSS_MSTSUB_ACCT                                    
               WHERE MST_ACCT_NO = :WS-MST-ACCT-NO-NUM                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8700'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8800-UPDATE-MST-ACCTT                                          *        
      ******************************************************************        
       8800-UPDATE-MST-ACCT.                                            
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                SET    CODE_ACCT_STAT     = :WS-ACCT-STATUS,            
                       AR_XFER_IND        = :WS-SPACE,                  
                       BILL_HIST_XFER_IND = :WS-SPACE,                  
PCR549                 CREDIT_GROUP       = :WS-CREDIT-GROUP,           
T17243                 ACCOUNT_TYPE_CODE  = :WS-ACCOUNT-TYPE-CODE,      
T16567                 MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND        
                WHERE  ACCOUNT_NO         = :WS-MST-ACCT-NO-NUM         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8800'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8801-CHK-CONTRACT  - ADDED TO FIX TPR11895                     *        
      *     CHECK THE EXISTENCE OF CONTRACTS TRANSFERRED TO MASTER ACCT*        
      ******************************************************************        
       8801-CHK-CONTRACT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
               INTO :WS-COUNT-CONTRACT                                  
               FROM CSS_CONTRACT CT, CSS_AR_CNTL AC                     
               WHERE CT.ACCOUNT_NO       = AC.ACCOUNT_NO                
               AND   CT.ACCOUNT_NO       = :WS-MST-ACCT-NO-NUM          
               AND   CT.CNT_XFER_ACCT_NO = :WS-SUB-ACCT-NO-NUM          
               AND   AC.PYMT_PRIORITY_LVL= 100                          
               AND   AC.ITEM_ID          = CT.CNT_ITEM_ID               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-COUNT-CONTRACT > 0                                  
                 NEXT SENTENCE                                          
              ELSE                                                      
      *--- LOOK FOR ACTIVE/PENDING MONTHLY CREDIT CONTRACTS. MONTHLY            
      *--- CREDIT CONTRACT ROWS MAY NOT BE PRESENT IN AR CONTROL.               
                 EXEC SQL                                               
                    SELECT COUNT(*)                                     
                     INTO :WS-COUNT-CONTRACT                            
                     FROM CSS_CONTRACT CT                               
                     WHERE CT.ACCOUNT_NO       = :WS-MST-ACCT-NO-NUM    
                     AND   CT.CNT_XFER_ACCT_NO = :WS-SUB-ACCT-NO-NUM    
                     AND   CT.CODE_BILL_TYPE   = :WS-E                  
                     AND  (CT.CNT_STATUS_CD    = :WS-B                  
                           OR CT.CNT_STATUS_CD = :WS-A)                 
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8801'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
CBSI          MOVE 'CSS_AR_CNTL AC'           TO TABLE-2                
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CNT_XFER_ACCT_NO'   TO TABLE-ELEMENT-2              
              MOVE WS-MST-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-SUB-ACCT-NO-NUM   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8801-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
