       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02083.                                         
COB303 DATE-WRITTEN.  JUNE  7, 1995                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S083 CONVERTED TO DB2 SP CSR02083 ON 06/01/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S083                                           *00120063
      *  PROGRAM:       S083                                           *00130063
      *  CALLING SP:    PA_S083                                        *00140075
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00190021
      *  1. RETRIEVES INFO       FROM CSS_DFA_RECV FOR AN ACCOUNT NO.  *00200089
      *                                                                *00209321
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  06/07/95    RTO      PROCEDURE ORIGINALLY CODED.              *00270063
      *  09/08/95    MAR      ADD DPP CODE.                            *      63
      *  02/01/96    RTO      SEPARATED DPP AND DFA CURSORS            *00270063
PCR328*  10/08/96    RPM      RETRIEVE BILLING DATES FOR ACTIVE ACCTS  *        
T5115 *  10/24/96    RTO      MODIFIED FOR TPR 5115 TO REFLECT THE     *        
T5115 *                       CORRECT DPP AND DFA BALANCES.            *        
T5168 *  11/06/96    RTO      MODIFIED TO START NEW DFA/DPP ITEM ID    *        
T5168 *                       AT 40,000,001 AND 30,000,001.            *        
TP8767*   02/05/97     JEP    ADDED REFERENCES TO CPD00309 & CWS00309  *        
TP8767*                       WHICH ARE USED TO CORRECTLY DETERMINE    *        
TP8767*                       THE NEXT BILL DATE.                      *        
TP9215*   02/24/97     KOG    CORRECTED THE CALCULATION FOR CONTRACT-  *        
TP9215*                       AMT.                                     *        
TP9449*   02/28/97   RTO      MODIFED TO CORRECT RETRIEVAL OF ACTIVE   *        
TP9449*                       DPP WITH EARNEST PAY PAID OFF.....       *        
T10741*   04/30/97   MJG      ADD EARNEST AMT_TRAN_BALANCES TO THE     *        
T10741*                       AMT_TRAN_BALANCE OF THE DPP.             *        
PCR393*   06/03/97   MAD      RPC MODIFIED TO RETURN VALID CONTRACTS   *        
      *                       WHICH MAY BE ESTABLISHED ON A DPP - CNT_ *        
      *                       ITEM_ID WILL BE PASSED FOR USE IN THE    *        
      *                       UPDATE BY THE PANEL.                     *        
T12918*   08/22/97   EMS      ADDED LPN AND NSN AS VALID RECEIVABLES   *        
      *                       FOR DPP.                                 *        
T16176*   05/15/98   SHF      FIXED ERRORS IN WRITING TO MC05 LOG.     *        
CBSI  *  08/27/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE   *         
CBSI  *             MADRAS    ABEND PARAMETERS                        *         
T18788*    01/05/98  SV       DONOT INCLUDE CONTRACTS IN DPP           *        
T21221*    12/08/99  CB18344  IF PARM-NEW-FLAG = S, THE CURRENT        *        
T21221*                       DATE IS CHANGED TO 03/15 OF THE CURRENT  *        
T21221*                       YEAR (SEB SEASONAL DPP).  IF THE PARM-NEW*        
T21221*                       NEW-FLAG = Z, THE CURRENT DATE IS NOT    *        
T21221*                       CHANGED .  THIS IS NEEDED IF A CUSTOMER  *        
T21221*                       WANTS SEASONAL DPP THEN CHANGES THEIR    *        
T21221*                       AND DECIDES THAT THEY WANT NORMAL DPP    *        
T21221*                       INSTEAD.                                 *        
T22180*    05/30/00  SS82048  UTIL/NON-UTIL CHANGES - TO EXCLUDE NSC   *        
      *                       FROM DPP ELIGIBLE RECEIVABLES            *        
T22460*    07/10/00  SFH      REMOVED NSN & LPN FROM DPP ELIGIBLE      *        
      *                       RECEIVABLES.                             *        
T21691*    09/06/00  SFH      ADDED LOGIC TO USE SEASONAL DPP START AND*        
      *                       END DATES FROM CSS_DELINQUENCY TABLE.    *        
      *                       ALSO, SEASONAL DPPS WILL BE SETUP WITH A *        
      *                       PAYMENT START DATE OF THE FOLLOWING YEAR *        
      *                       IF THE DPP IS BEING ENTERED AFTER 3/15.  *        
      *                       ANYTHING ENTERED ON OR BEFORE 3/15 WILL  *        
      *                       USE THE CURRENT YEAR.  REMOVED LOGIC THAT*        
      *                       ONLY USED THE FOLLOWING YEAR IF THE      *        
      *                       CURRENT MONTH WAS GREATER THAN OCTOBER.  *        
T23501*    04/07/01  COVANSYS ADDED COMPANY_NO TO THE SELECT CLAUSE IN *        
      *               CHENNAI PARA 7510 AND WHERE CLAUSE IN 7810 TO    *        
      *                       SUPPORT MULTI COMPANY CHANGES            *        
T23447*    05/25/01  SFH      MODIFIED DATE LOGIC TO PREVENT ABENDS    *        
      *                       AFTER DATES ARE RETRIEVED FROM           *        
      *                       CSS_DELINQUENCY TABLE.                   *        
C24880*    11/19/02  SRIDEVI  ADDED LOGIC RELATED TO CONNECTION CHARGES*        
C24880*                       AS DFA                                   *        
REARCH*    08/12/05  CVNS     RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*              CHENNAI                                           *        
T34621*    02/12/07  SS82048  ADDED A NEW SQL TO GET START DATE FOR    *        
T34621*                       SEB SEASONAL DPP.                        *        
T35434*    10/10/07  MR97640  REPLACED MODEL_SQL WITH SET STATEMENT AND*00310000
T35434*                       ADDED WITH UR TO AVOID -911 ABENDS.      *00310000
T35434*                                                                *00310000
A00406*    06/08/10  SV85244  ADDED BLOCK FETCH.                       *00310000
A00406*                                                                *00310000
ACT278*    10/08/16  TP7R341  REMOVE UNWANTED COLUMNS FROM CONTRACT    *00310000
ACT278*     A05460            INFO USER TABLE                          *00310000
      ******************************************************************00290000
      ******************************************************************00300000
      *                                                                *00310000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00320000
      *                                                                *00330000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00340000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00350000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00360000
      *  3000 - 4999  NOT USED                                         *00370000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00380000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00390000
      *  7000 - 7999  INPUT MODULES                                    *00400000
      *  8000 - 8999  OUTPUT MODULES                                   *00410000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00420000
      *                                                                *00430000
      ******************************************************************00440000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02083'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02083 STARTS HERE'.                  
                                                                        
      ******************************************************************00610000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00620000
      ******************************************************************00630000
                                                                        
CVT999*    COPY SYGWCOB.                                                00650000
CVT999*    COPY SYDBCOB.                                                00660000
CVT999*    COPY CWS00010.                                               00680013
           COPY CWS00027.                                               00690013
           COPY CWS00056.                                               00691014
           COPY CWS00303.                                               00700013
                                                                        
TP8767     EXEC SQL                                                             
TP8767        INCLUDE CWS00309                                                  
TP8767     END-EXEC.                                                            
                                                                        
      ******************************************************************00770000
      *    WORK AREAS                                                  *00780000
      ******************************************************************00790000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02083'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-ACCOUNT-NO            PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.              
TP8767     05  REFORMAT-DATE.                                           
TP8767         10  WS-FORMAT-YEAR      PIC X(04).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-MONTH     PIC X(02).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-DAY       PIC X(02).                       
TP8767     05  USA-DATE-FORMAT.                                         
TP8767         10  USA-MONTH           PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-DAY             PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-YEAR            PIC X(04).                       
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                 POINTER.                        00910000
CVT999*    05  GWL-INIT-HANDLE          POINTER.                        00920000
CVT999*    05  GWL-RC                   PIC S9(9) COMP.                 00930000
CVT999*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 00940000
CVT999*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 00950000
CVT999*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 00960000
CVT999*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 00970000
CVT999*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 00980000
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(09) COMP.                
CVT999*    05  PARM-ID1                 PIC S9(09) COMP VALUE 1.        01005002
           05  PARM-ACCOUNT-NO          PIC  X(13).                     
           05  PARM-DFA-TYPE            PIC  X(1).                      
           05  PARM-NEW-FLAG            PIC  X(1).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          01040000
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          01070000
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  01110000
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                  01120000
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                  01130000
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-DATEOF-AGREE         PIC  X(10).                      
           05  WS-DATE-25-DAYS-AGO     PIC  X(10).                      
           05  WS-AGREEMENT-NO         PIC S9(9) COMP.                  
           05  WS-CURRENT-CHARGES      PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-ARREARS          PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-00-DAY           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-30-DAY           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-60-DAY           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-90-DAY           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-UNUSED-CR        PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-AMT-TRAN-BAL         PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-MAX-AGREEMENT-NO     PIC S9(9) COMP.                  
C24880     05  WS-CHARGE-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.    
C24880     05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-LAST-BILL-DATE       PIC X(10).                       
           05  WS-MIN-DATE             PIC X(10).                       
           05  WS-NEXT1-BILL-DATE      PIC X(10).                       
           05  WS-NEXT2-BILL-DATE      PIC X(10).                       
T23447     05  WS-MESSAGE              PIC X(01) VALUE SPACES.          
           05  WS-HOLD-DATE.                                            
               10  WS-DATE-CCYY        PIC 9(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATE-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATE-DD          PIC 9(02).                       
           05  WS-BILL-FREQ.                                            
               10  WS-FREQ-CODE        PIC X(01).                       
               10  WS-START-MONTH      PIC 9(02).                       
           05  WS-INTERVAL             PIC 9(02).                       
           05  WS-NULL-DATE-IND        PIC S9(04) COMP.                 
           05  WS-NULL-ITEM-IND        PIC S9(04) COMP.                 
           05  WS-NULL-IND1            PIC S9(04) COMP.                 
           05  WS-NULL-IND2            PIC S9(04) COMP.                 
C24880     05  WS-SEQUENCE-NO-NULL     PIC S9(04) COMP.                 
           05  WS-CURRENT-DATE         PIC  X(10).                      
T21221     05  WS-HOLD-CURRENT-DATE.                                    
T21221         10  WS-CURRENT-YEAR     PIC  X(4).                       
T21221         10  WS-CURRENT-YEAR-N REDEFINES WS-CURRENT-YEAR          
T21221                                 PIC  9(4).                       
T21221         10  FILLER              PIC  X(1).                       
T21221         10  WS-CURRENT-MONTH    PIC  9(2).                       
T21221         10  FILLER              PIC  X(1).                       
T21221         10  WS-CURRENT-DAY      PIC  X(2).                       
T23447     05  WS-CURRENT-MONTH-DAY    PIC  X(4).                       
           05  WS-DPP-ERNST-PAY-DT.                                     
               10 WS-DPP-DATE-CC        PIC  X(02).                     
               10 WS-DPP-DATE-YY        PIC  X(02).                     
               10 FILLER                PIC  X(01).                     
               10 WS-DPP-DATE-MM        PIC  X(02).                     
               10 FILLER                PIC  X(01).                     
               10 WS-DPP-DATE-DD        PIC  X(02).                     
           05 WS-DATE-8.                                                
               10 WS-DATE-8-CC          PIC  X(02).                     
               10 WS-DATE-8-YY          PIC  X(02).                     
               10 WS-DATE-8-MM          PIC  X(02).                     
               10 WS-DATE-8-DD          PIC  X(02).                     
           05  WS-DATE-8-NUM    REDEFINES WS-DATE-8                     
                                        PIC  9(08).                     
T21691     05  WS-DATE-SEAS-DPP-START   PIC S9(4)V9(5) USAGE DISPLAY.   
T21691     05  WS-DATE-SEAS-DPP-END     PIC S9(4)V9(5) USAGE DISPLAY.   
T21691 01  WS-DPP-START-DATE.                                           
T21691     05  WS-DPP-START-YEAR        PIC X(4) VALUE ZERO.            
T21691     05  FILLER                   PIC X(1) VALUE '-'.             
T21691     05  WS-DPP-START-MONTH       PIC X(2) VALUE ZERO.            
T21691     05  FILLER                   PIC X(1) VALUE '-'.             
T21691     05  WS-DPP-START-DAY         PIC X(2) VALUE ZERO.            
T23447 01  WS-DPP-START-MONTH-DAY       PIC X(4) VALUE ZERO.            
T21691 01  WS-DPP-END-DATE.                                             
T21691     05  WS-DPP-END-YEAR          PIC X(4) VALUE ZERO.            
T21691     05  FILLER                   PIC X(1) VALUE '-'.             
T21691     05  WS-DPP-END-MONTH         PIC X(2) VALUE ZERO.            
T21691     05  FILLER                   PIC X(1) VALUE '-'.             
T21691     05  WS-DPP-END-DAY           PIC X(2) VALUE ZERO.            
T23447 01  WS-DPP-END-MONTH-DAY         PIC X(4) VALUE ZERO.            
                                                                        
T21221 01  SEB-SEAS-DATE.                                               
T21221     05  SEB-SEAS-YEAR            PIC  X(4).                      
T21221     05  SEB-SEAS-YEAR-N REDEFINES SEB-SEAS-YEAR                  
T21221                                  PIC  9(4).                      
T21221     05  FILLER                   PIC  X(1) VALUE '-'.            
T21221     05  SEB-SEAS-MONTH           PIC  X(2) VALUE '03'.           
T21221     05  FILLER                   PIC  X(1) VALUE '-'.            
T21221     05  SEB-SEAS-DAY             PIC  X(2) VALUE '15'.           
T23447 01  SEB-SEAS-MONTH-DAY           PIC  X(4) VALUE SPACES.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-DFA-ITEM-ID           PIC S9(09) COMP VALUE +0.       
           05  RS-REC-TYPE              PIC  X(03) VALUE SPACES.        
           05  RS-CURRENT-CHARGES       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-ARREARS               PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-BILLED-BALANCE        PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-TOTAL-BILL-BAL        PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-CONTRACT-AMT          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-LAST-TS               PIC X(26)    VALUE SPACES.      
           05  RS-EDIT-FLAG             PIC X(1)     VALUE SPACE.       
           05  RS-DATE-PYMT-START-1     PIC X(10)    VALUE SPACES.      
           05  RS-DATE-PYMT-START-2     PIC X(10)    VALUE SPACES.      
PCR393     05  RS-RECV-DESC             PIC X(25)    VALUE SPACES.      
PCR393     05  RS-ITEM-ID               PIC S9(09) COMP VALUE +0.       
C24880     05  RS-RECV-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
REARCH     05  S-DFA-ITEM-ID           PIC S9(09) COMP VALUE +0.        
REARCH     05  S-REC-TYPE              PIC  X(03) VALUE SPACES.         
REARCH     05  S-CURRENT-CHARGES       PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-ARREARS               PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-BILLED-BALANCE        PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-TOTAL-BILL-BAL        PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-CONTRACT-AMT          PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-LAST-TS               PIC X(26)    VALUE SPACES.       
REARCH     05  S-EDIT-FLAG             PIC X(1)     VALUE SPACE.        
REARCH     05  S-DATE-PYMT-START-1     PIC X(10)    VALUE SPACES.       
REARCH     05  S-DATE-PYMT-START-2     PIC X(10)    VALUE SPACES.       
REARCH     05  S-RECV-DESC             PIC X(25)    VALUE SPACES.       
REARCH     05  S-ITEM-ID               PIC S9(09) COMP VALUE +0.        
REARCH     05  S-RECV-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.   
CVT999*01  CNS-COLUMN-NAMES.                                            01200064
CVT999*    05  CNS-RETURN-CODE          PIC X(11) VALUE                 01210072
CVT999*                                       'RETURN_CODE'.            01223064
CVT999*    05  CNS-DFA-ITEM-ID          PIC X(15) VALUE                 01224064
CVT999*                                       'DFA_ITEM_ID'.            01225064
CVT999*                                                                         
CVT999*    05  CNS-REC-TYPE             PIC X(08) VALUE                 01224064
CVT999*                                       'REC-TYPE'.               01225064
CVT999*    05  CNS-CURRENT-CHARGES      PIC X(15) VALUE                 01224064
CVT999*                                       'CURRENT-CHARGES'.        01225064
CVT999*                                                                         
CVT999*    05  CNS-ARREARS              PIC X(15) VALUE                 01224064
CVT999*                                       'DATE-PYMT-START'.        01225064
CVT999*                                                                         
CVT999*    05  CNS-BILLED-BALANCE       PIC X(15) VALUE                 01224064
CVT999*                                       'BILLED-BALANCE'.         01225064
CVT999*                                                                         
CVT999*    05  CNS-TOTAL-BILL-BAL       PIC X(15) VALUE                 01224064
CVT999*                                       'TOTAL-BILL-BAL'.         01225064
CVT999*                                                                         
CVT999*    05  CNS-CONTRACT-AMT         PIC X(17) VALUE                 01224064
CVT999*                                       'CONTRACT-AMT'.           01225064
CVT999*                                                                         
CVT999*    05  CNS-LAST-TS              PIC X(17) VALUE                 01224064
CVT999*                                       'LAST-UPDATE-TS'.         01225064
CVT999*    05  CNS-EDIT-FLAG            PIC X(17) VALUE                 01224064
CVT999*                                       'EDIT-FLAG'.              01225064
CVT999*                                                                         
CVT999*    05  CNS-DATE-PYMT-START-1    PIC X(17) VALUE                 01224064
CVT999*                                       'DATE-PYMT-START-1'.      01225064
CVT999*                                                                         
CVT999*    05  CNS-DATE-PYMT-START-2    PIC X(17) VALUE                 01224064
CVT999*                                       'DATE-PYMT-START-2'.      01225064
CVT999*                                                                         
CVT999*    05  CNS-RECV-DESC            PIC X(09) VALUE                         
CVT999*                                       'RECV-DESC'.                      
CVT999*                                                                         
CVT999*    05  CNS-ITEM-ID              PIC X(07) VALUE                         
CVT999*                                       'ITEM-ID'.                        
CVT999*    05  CNS-RECV-BALANCE         PIC X(13) VALUE                 01224064
CVT999*                                       'RECV-BALANCE'.           01225064
CVT999*                                                                         
           EXEC SQL                                                     01229612
              INCLUDE SQLCA                                             01229712
           END-EXEC.                                                    01229812
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBDFARCV                                          01232965
           END-EXEC.                                                    01233065
                                                                        
           EXEC SQL                                                     01232412
              INCLUDE TBARCNTL                                          01232565
           END-EXEC.                                                    01232612
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBACCT                                            01232965
           END-EXEC.                                                    01233065
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBDFAACT                                          01232965
           END-EXEC.                                                    01233065
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBARTYPE                                          01232965
           END-EXEC.                                                    01233065
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBBILWDW                                          01232965
           END-EXEC.                                                    01233065
                                                                        
PCR393     EXEC SQL                                                             
PCR393        INCLUDE TBCNTRCT                                                  
PCR393     END-EXEC.                                                            
                                                                        
PCR393     EXEC SQL                                                             
PCR393        INCLUDE TBCNTINF                                                  
PCR393     END-EXEC.                                                            
                                                                        
T21691     EXEC SQL                                                             
T21691        INCLUDE TBDELQ                                                    
T21691     END-EXEC.                                                            
                                                                        
C24880* CSS_CHARGE_RECV                                                         
C24880     EXEC SQL                                                             
C24880        INCLUDE TBCHGRCV                                                  
C24880     END-EXEC.                                                            
C24880                                                                  
C24880* CSS_CHARGE_TYPE                                                         
C24880     EXEC SQL                                                             
C24880        INCLUDE TBCHGTYP                                                  
C24880     END-EXEC.                                                            
      ***********************************************************       01235014
      *** DFARECV-CURSOR CURSOR: FETCH ALL ROWS IN THE CSS_DFA_RECV *   01236073
      *** TABLE WITH THE PASSED ACCOUNT NUMBER AND DFA-TYPE      *      01237014
      ***********************************************************       01238014
           EXEC SQL                                                     
             DECLARE DFARECV-CURSOR  CURSOR FOR                         
             SELECT DA.DATE_OF_AGREE,                                   
                    DA.CODE_DFA_STATUS,                                 
                    DA.FRST_ERNST_PAY_DT,                               
                    DA.SCND_ERNST_PAY_DT,                               
                    DV.AGREEMENT_NO,                                    
PCR393              L5.AR_TYPE_SHORT_DESC,                              
PCR393              L5.AR_TYPE_LONG_DESC,                               
                    DV.AMT_DAY_00,                                      
                    DV.AMT_DAY_30 + DV.AMT_DAY_60 + DV.AMT_DAY_90,      
                    DV.AMT_DAY_00 + DV.AMT_DAY_30 +                     
                    DV.AMT_DAY_60 + DV.AMT_DAY_90,                      
                    DV.AMT_CONTRACT_DEFR,                               
                    DV.AMT_DAY_00,                                      
                    DV.AMT_DAY_30,                                      
                    DV.AMT_DAY_60,                                      
                    DV.AMT_DAY_90,                                      
PCR393              DV.CNT_ITEM_ID                                      
             FROM CSS_DFA_ACCT    DA WITH(READUNCOMMITTED),                     
                  CSS_DFA_RECVBLE DV WITH(READUNCOMMITTED),                     
                  CSS_AR_TYPE     L5 WITH(READUNCOMMITTED)                      
             WHERE DA.ACCOUNT_NO = :DA-ACCOUNT-NO AND                   
                   DV.ACCOUNT_NO = DA.ACCOUNT_NO AND                    
                   DA.PYMT_PRIORITY_LVL = 90 AND                        
                   DV.PYMT_PRIORITY_LVL = DA.PYMT_PRIORITY_LVL AND      
                   DA.CODE_DFA_TYPE = :PARM-DFA-TYPE AND                
                   DV.AGREEMENT_NO  = DA.DFA_ITEM_ID AND                
                   L5.PYMT_PRIORITY_LVL = DV.DFA_PYMT_PRIORITY          
             ORDER BY DA.DATE_OF_AGREE                                  
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01239768
MFA-TR*      DECLARE DFARECV-CURSOR  CURSOR FOR                         01239867
MFA-TR*      SELECT DA.DATE_OF_AGREE,                                   01240186
MFA-TR*             DA.CODE_DFA_STATUS,                                 01240186
MFA-TR*             DA.FRST_ERNST_PAY_DT,                               01240186
MFA-TR*             DA.SCND_ERNST_PAY_DT,                               01240186
MFA-TR*             DV.AGREEMENT_NO,                                    01240186
MFA-TR*             L5.AR_TYPE_SHORT_DESC,                                      
MFA-TR*             L5.AR_TYPE_LONG_DESC,                                       
MFA-TR*             DV.AMT_DAY_00,                                      01240186
MFA-TR*             DV.AMT_DAY_30 + DV.AMT_DAY_60 + DV.AMT_DAY_90,      01240186
MFA-TR*             DV.AMT_DAY_00 + DV.AMT_DAY_30 +                     01240186
MFA-TR*             DV.AMT_DAY_60 + DV.AMT_DAY_90,                      01240186
MFA-TR*             DV.AMT_CONTRACT_DEFR,                               01240186
MFA-TR*             DV.AMT_DAY_00,                                              
MFA-TR*             DV.AMT_DAY_30,                                              
MFA-TR*             DV.AMT_DAY_60,                                              
MFA-TR*             DV.AMT_DAY_90,                                              
MFA-TR*             DV.CNT_ITEM_ID                                              
MFA-TR*      FROM CSS_DFA_ACCT    DA,                                   01241764
MFA-TR*           CSS_DFA_RECVBLE DV,                                   01241764
MFA-TR*           CSS_AR_TYPE     L5                                    01241764
MFA-TR*      WHERE DA.ACCOUNT_NO = :DA-ACCOUNT-NO AND                   01241889
MFA-TR*            DV.ACCOUNT_NO = DA.ACCOUNT_NO AND                    01241889
MFA-TR*            DA.PYMT_PRIORITY_LVL = 90 AND                                
MFA-TR*            DV.PYMT_PRIORITY_LVL = DA.PYMT_PRIORITY_LVL AND              
MFA-TR*            DA.CODE_DFA_TYPE = :PARM-DFA-TYPE AND                        
MFA-TR*            DV.AGREEMENT_NO  = DA.DFA_ITEM_ID AND                        
MFA-TR*            L5.PYMT_PRIORITY_LVL = DV.DFA_PYMT_PRIORITY                  
MFA-TR*      ORDER BY DA.DATE_OF_AGREE                                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    01242468
                                                                        
      ***********************************************************       01235014
      *** DFACNTL-CURSOR CURSOR: FETCH ALL ROWS IN THE CSS_AR-CNTL *    01236073
      *** TABLE WITH THE PASSED ACCOUNT NUMBER.                  *      01237014
      ***********************************************************       01238014
           EXEC SQL                                                     
             DECLARE DFACNTL-CURSOR  CURSOR FOR                         
               SELECT AC.AMT_AR_DAY_00,                                 
                      AC.AMT_AR_DAY_30,                                 
                      AC.AMT_AR_DAY_60,                                 
                      AC.AMT_AR_DAY_90,                                 
                      AC.AMT_UNUSED_CR,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      L5.AR_TYPE_SHORT_DESC,                            
PCR393                L5.AR_TYPE_LONG_DESC                              
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED),                     
                      CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                      
                 WHERE ((AC.ACCOUNT_NO = :AC-ACCOUNT-NO                 
                   AND AC.ITEM_ID = 0                                   
                   AND L5.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL)     
                   AND (AC.PYMT_PRIORITY_LVL IN (30,40,45,47)))         
T35434             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01239768
MFA-TR*      DECLARE DFACNTL-CURSOR  CURSOR FOR                               67
MFA-TR*        SELECT AC.AMT_AR_DAY_00,                                         
MFA-TR*               AC.AMT_AR_DAY_30,                                         
MFA-TR*               AC.AMT_AR_DAY_60,                                         
MFA-TR*               AC.AMT_AR_DAY_90,                                         
MFA-TR*               AC.AMT_UNUSED_CR,                                         
MFA-TR*               AC.LAST_UPDATE_TS,                                        
MFA-TR*               L5.AR_TYPE_SHORT_DESC,                                    
MFA-TR*               L5.AR_TYPE_LONG_DESC                                      
MFA-TR*          FROM CSS_AR_CNTL AC,                                           
MFA-TR*               CSS_AR_TYPE L5                                            
MFA-TR*          WHERE ((AC.ACCOUNT_NO = :AC-ACCOUNT-NO                         
MFA-TR*            AND AC.ITEM_ID = 0                                           
MFA-TR*            AND L5.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL)             
MFA-TR*            AND (AC.PYMT_PRIORITY_LVL IN (30,40,45,47)))                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      ***********************************************************       01235014
      *** DPPCNTL-CURSOR CURSOR: FETCH ALL ROWS IN THE CSS_AR-CNTL *    01236073
      *** TABLE WITH THE PASSED ACCOUNT NUMBER.                  *      01237014
      ***********************************************************       01238014
           EXEC SQL                                                     
             DECLARE DPPCNTL-CURSOR  CURSOR FOR                         
               SELECT AC.AMT_AR_DAY_00,                                 
                      AC.AMT_AR_DAY_30,                                 
                      AC.AMT_AR_DAY_60,                                 
                      AC.AMT_AR_DAY_90,                                 
                      AC.AMT_UNUSED_CR,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      L5.AR_TYPE_SHORT_DESC,                            
PCR393                L5.AR_TYPE_LONG_DESC                              
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED),                     
                      CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                      
                 WHERE ((AC.ACCOUNT_NO = :AC-ACCOUNT-NO                 
                   AND AC.ITEM_ID = 0                                   
                   AND L5.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL)     
T12918*            AND (AC.PYMT_PRIORITY_LVL IN (19,20,29,30,39,40,             
T22180*            AND (AC.PYMT_PRIORITY_LVL IN (20,29,30,39,40,                
T22460             AND (AC.PYMT_PRIORITY_LVL IN (20,30,40,              
                                                 45,47,60)))            
T35434             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01239768
MFA-TR*      DECLARE DPPCNTL-CURSOR  CURSOR FOR                               67
MFA-TR*        SELECT AC.AMT_AR_DAY_00,                                         
MFA-TR*               AC.AMT_AR_DAY_30,                                         
MFA-TR*               AC.AMT_AR_DAY_60,                                         
MFA-TR*               AC.AMT_AR_DAY_90,                                         
MFA-TR*               AC.AMT_UNUSED_CR,                                         
MFA-TR*               AC.LAST_UPDATE_TS,                                        
MFA-TR*               L5.AR_TYPE_SHORT_DESC,                                    
MFA-TR*               L5.AR_TYPE_LONG_DESC                                      
MFA-TR*          FROM CSS_AR_CNTL AC,                                           
MFA-TR*               CSS_AR_TYPE L5                                            
MFA-TR*          WHERE ((AC.ACCOUNT_NO = :AC-ACCOUNT-NO                         
MFA-TR*            AND AC.ITEM_ID = 0                                           
MFA-TR*            AND L5.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL)             
MFA-TR*            AND (AC.PYMT_PRIORITY_LVL IN (19,20,29,30,39,40,             
MFA-TR*            AND (AC.PYMT_PRIORITY_LVL IN (20,29,30,39,40,                
MFA-TR*            AND (AC.PYMT_PRIORITY_LVL IN (20,30,40,                      
MFA-TR*                                          45,47,60)))                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
PCR393****************************************************************          
PCR393**  CONTRACT-CURSOR  -  RETRIEVES ALL CONTRACTS WHICH MAY BE  **          
PCR393**                       SET-UP ON DPP.                       **          
PCR393****************************************************************          
                                                                        
PCR393     EXEC SQL                                                     
PCR393       DECLARE CONTRACT-CURSOR  CURSOR FOR                        
PCR393         SELECT AC.AMT_AR_DAY_00,                                 
PCR393                AC.AMT_AR_DAY_30,                                 
PCR393                AC.AMT_AR_DAY_60,                                 
PCR393                AC.AMT_AR_DAY_90,                                 
PCR393                AC.AMT_UNUSED_CR,                                 
PCR393                REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
PCR393                AC.ITEM_ID,                                       
PCR393                L5.AR_TYPE_SHORT_DESC,                            
ACT278                K6.CNT_NAME_DESC                                  
PCR393           FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED),                     
PCR393                CSS_CONTRACT CT WITH(READUNCOMMITTED),                    
PCR393                CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED),               
PCR393                CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                      
PCR393           WHERE AC.ACCOUNT_NO           = :AC-ACCOUNT-NO         
PCR393             AND AC.PYMT_PRIORITY_LVL    = 100                    
PCR393             AND L5.PYMT_PRIORITY_LVL    = AC.PYMT_PRIORITY_LVL   
PCR393             AND CT.ACCOUNT_NO           = AC.ACCOUNT_NO          
PCR393             AND CT.PYMT_PRIORITY_LVL    = AC.PYMT_PRIORITY_LVL   
PCR393             AND CT.CNT_ITEM_ID          = AC.ITEM_ID             
PCR393             AND CT.CODE_CONTRACT_TYPE IN ('C','D','E')           
PCR393             AND CT.CNT_STATUS_CD        = 'B'                    
PCR393             AND K6.CNT_NAME_CD          = CT.CNT_NAME_CD         
T35434             FOR READ ONLY                                
PCR393     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01239768
MFA-TR*      DECLARE CONTRACT-CURSOR  CURSOR FOR                              67
MFA-TR*        SELECT AC.AMT_AR_DAY_00,                                         
MFA-TR*               AC.AMT_AR_DAY_30,                                         
MFA-TR*               AC.AMT_AR_DAY_60,                                         
MFA-TR*               AC.AMT_AR_DAY_90,                                         
MFA-TR*               AC.AMT_UNUSED_CR,                                         
MFA-TR*               AC.LAST_UPDATE_TS,                                        
MFA-TR*               AC.ITEM_ID,                                               
MFA-TR*               L5.AR_TYPE_SHORT_DESC,                                    
MFA-TR*               K6.CNT_NAME_DESC                                          
MFA-TR*          FROM CSS_AR_CNTL AC,                                           
MFA-TR*               CSS_CONTRACT CT,                                          
MFA-TR*               CSS_CONTRACT_INFO K6,                                     
MFA-TR*               CSS_AR_TYPE L5                                            
MFA-TR*          WHERE AC.ACCOUNT_NO           = :AC-ACCOUNT-NO                 
MFA-TR*            AND AC.PYMT_PRIORITY_LVL    = 100                            
MFA-TR*            AND L5.PYMT_PRIORITY_LVL    = AC.PYMT_PRIORITY_LVL           
MFA-TR*            AND CT.ACCOUNT_NO           = AC.ACCOUNT_NO                  
MFA-TR*            AND CT.PYMT_PRIORITY_LVL    = AC.PYMT_PRIORITY_LVL           
MFA-TR*            AND CT.CNT_ITEM_ID          = AC.ITEM_ID                     
MFA-TR*            AND CT.CODE_CONTRACT_TYPE IN ('C','D','E')                   
MFA-TR*            AND CT.CNT_STATUS_CD        = 'B'                            
MFA-TR*            AND K6.CNT_NAME_CD          = CT.CNT_NAME_CD                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
C24880****************************************************************          
C24880** CURSOR DECLARATION TO SELECT DETAILS FROM CSS_CHARGE_RECV  **          
C24880****************************************************************          
C24880     EXEC SQL DECLARE CHARGE_DETAILS CURSOR FOR                   
C24880        SELECT  Z6.PYMT_PRIORITY_LVL                              
C24880               ,Z6.CHARGE_PERCENT_RT                              
C24880               ,Z8.CHARGE_AM                                      
C24880          FROM  CSS_CHARGE_RECV Z6 WITH(READUNCOMMITTED)                  
C24880               ,CSS_CHARGE_TYPE Z8 WITH(READUNCOMMITTED)                  
C24880         WHERE  Z6.COMPANY_NO         = :Z8-COMPANY-NO            
C24880           AND  Z6.COMPANY_NO         =  Z8.COMPANY_NO            
C24880           AND  Z6.CHARGE_TYPE_CD     =  Z8.CHARGE_TYPE_CD        
C24880           AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC         
C24880           AND  Z8.CHARGE_STATUS_CD   = 'A'                       
C24880           AND  Z6.CHARGE_SEQUENCE_NO = :Z8-CHARGE-SEQUENCE-NO    
T35434           FOR READ ONLY                                 
C24880     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CHARGE_DETAILS CURSOR FOR                   02338214
MFA-TR*       SELECT  Z6.PYMT_PRIORITY_LVL                              02338214
MFA-TR*              ,Z6.CHARGE_PERCENT_RT                                      
MFA-TR*              ,Z8.CHARGE_AM                                              
MFA-TR*         FROM  CSS_CHARGE_RECV Z6                                02338214
MFA-TR*              ,CSS_CHARGE_TYPE Z8                                02338214
MFA-TR*        WHERE  Z6.COMPANY_NO         = :Z8-COMPANY-NO            02338214
MFA-TR*          AND  Z6.COMPANY_NO         =  Z8.COMPANY_NO            02338214
MFA-TR*          AND  Z6.CHARGE_TYPE_CD     =  Z8.CHARGE_TYPE_CD        02338214
MFA-TR*          AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC                 
MFA-TR*          AND  Z8.CHARGE_STATUS_CD   = 'A'                               
MFA-TR*          AND  Z6.CHARGE_SEQUENCE_NO = :Z8-CHARGE-SEQUENCE-NO    02338214
MFA-TR*          FOR  FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC                                                     02338214
                                                                        
HPCCDM*EJECT                                                            01245000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR                             
A00406                     WITH ROWSET POSITIONING FOR                  
CVT000         SELECT                                                   
CVT000            RETURN_CODE                                           
CVT000           ,DFA_ITEM_ID                                           
CVT000           ,LTRIM(RTRIM(REC_TYPE))          AS  REC_TYPE                 
CVT000           ,CURRENT_CHARGES                                       
CVT000           ,ARREARS                                               
CVT000           ,BILLED_BALANCE                                        
CVT000           ,CONTRACT_AMT                                          
CVT000           ,LTRIM(RTRIM(LAST_TS))           AS  LAST_TS                  
CVT000           ,LTRIM(RTRIM(EDIT_FLAG))         AS  EDIT_FLAG                
CVT000           ,LTRIM(RTRIM(DATE_PYMT_START_1)) AS  DATE_PYMT_START_1        
CVT000           ,LTRIM(RTRIM(DATE_PYMT_START_2)) AS  DATE_PYMT_START_2        
CVT000           ,TOTAL_BILL_BAL                                        
CVT000           ,LTRIM(RTRIM(RECV_DESC))         AS  RECV_DESC                
CVT000           ,ITEM_ID                                               
CVT000           ,RECV_BALANCE                                          
CVT000         FROM #CSR02083_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                    WITH ROWSET POSITIONING FOR                          
MFA-TR*        SELECT                                                   00000400
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,DFA_ITEM_ID                                                   
MFA-TR*          ,STRIP(REC_TYPE)          AS  REC_TYPE                         
MFA-TR*          ,CURRENT_CHARGES                                               
MFA-TR*          ,ARREARS                                                       
MFA-TR*          ,BILLED_BALANCE                                                
MFA-TR*          ,CONTRACT_AMT                                                  
MFA-TR*          ,STRIP(LAST_TS)           AS  LAST_TS                          
MFA-TR*          ,STRIP(EDIT_FLAG)         AS  EDIT_FLAG                        
MFA-TR*          ,STRIP(DATE_PYMT_START_1) AS  DATE_PYMT_START_1                
MFA-TR*          ,STRIP(DATE_PYMT_START_2) AS  DATE_PYMT_START_2                
MFA-TR*          ,TOTAL_BILL_BAL                                                
MFA-TR*          ,STRIP(RECV_DESC)         AS  RECV_DESC                        
MFA-TR*          ,ITEM_ID                                                       
MFA-TR*          ,RECV_BALANCE                                                  
MFA-TR*        FROM SESSION.CSR02083_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC  X(13)               .          
CVT000 01  LINK-DFA-TYPE            PIC  X(1)                .          
CVT000 01  LINK-NEW-FLAG            PIC  X(1)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-DFA-TYPE                                           
CVT000         ,LINK-NEW-FLAG                                           
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              01250000
                                                                        
      ******************************************************************01270000
      * 0000-MAINLINE                                                  *01280000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01290000
      ******************************************************************01300000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
REARCH*    PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  01350002
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF CTR-ROWS < 1                                              
T21691        IF RS-RETURN-CODE = +555                                  
T21691           CONTINUE                                               
T21691        ELSE                                                      
                 MOVE +100                   TO RS-RETURN-CODE          
T21691        END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
           END-IF.                                                      
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01410000
      * 0100-INITIALIZE                                                *01420000
      *                                                                *01430000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01440000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01450000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01460000
      *                                                                *01470000
      ******************************************************************01480000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              01510080
CVT999*    EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                01511080
CVT999*    EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               01512080
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     01520000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     01540000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         01550000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      01570000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             01590000
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     01600000
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  01610000
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      01620000
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      01630000
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        01640000
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            01650000
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            01660000
CVT999*    END-IF.                                                      01670000
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-DFA-TYPE             TO PARM-DFA-TYPE            . 
CVT000     MOVE LINK-NEW-FLAG             TO PARM-NEW-FLAG            . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02083_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02083_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,DFA_ITEM_ID              INT                         
CVT000        ,REC_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,CURRENT_CHARGES          DECIMAL(11,2)                   
CVT000        ,ARREARS                  DECIMAL(13,2)                   
CVT000        ,BILLED_BALANCE           DECIMAL(13,2)                   
CVT000        ,CONTRACT_AMT             DECIMAL(11,2)                   
CVT000        ,LAST_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,EDIT_FLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,DATE_PYMT_START_1 CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,DATE_PYMT_START_2 CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,TOTAL_BILL_BAL           DECIMAL(13,2)                   
CVT000        ,RECV_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,ITEM_ID                  INT                         
CVT000        ,RECV_BALANCE             DECIMAL(13,2)                   
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02083_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
      ******************************************************************01720000
      * 1000-PROCESS-INPUT.                                            *01730002
      *                                                                *01740000
      *     1. RECEIVE PARMS.                                          *01750002
      *                                                                *01790000
      ******************************************************************01800000
                                                                        
REARCH*1000-PROCESS-INPUT.                                              01820002
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   01840002
REARCH*1000-EXIT.                                                       01890002
REARCH*    EXIT.                                                        01900000
                                                                        
      ***************************************************************** 01910202
      * 1100-RECEIVE-PARMS                                            * 01910502
      *                                                               * 01910602
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          * 01911002
      *                                                               * 01911102
      ***************************************************************** 01911502
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              01911804
CVT999*      MOVE 1                           TO PARM-ID1.              01912804
CVT999*      MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,         01912989
CVT999*      CALL 'TDRCVPRM' USING GWL-PROC,                            01913002
CVT999*                            GWL-RC,                              01913104
CVT999*                            PARM-ID1,                            01913204
CVT999*                            PARM-ACCOUNT-NO,                     01913389
CVT999*                            TDSCHAR,                             01913404
CVT999*                            MAX-LENGTH-PARM,                     01913504
CVT999*                            PARM-L.                              01913604
                                                                        
CVT999*      ADD  1                           TO PARM-ID1.              01912804
CVT999*      MOVE LENGTH OF PARM-DFA-TYPE   TO MAX-LENGTH-PARM,         01912989
CVT999*      CALL 'TDRCVPRM' USING GWL-PROC,                            01913002
CVT999*                            GWL-RC,                              01913104
CVT999*                            PARM-ID1,                            01913204
CVT999*                            PARM-DFA-TYPE,                       01913389
CVT999*                            TDSCHAR,                             01913404
CVT999*                            MAX-LENGTH-PARM,                     01913504
CVT999*                            PARM-L.                              01913604
                                                                        
CVT999*      ADD  1                           TO PARM-ID1.              01912804
CVT999*      MOVE LENGTH OF PARM-NEW-FLAG   TO MAX-LENGTH-PARM,         01912989
CVT999*      CALL 'TDRCVPRM' USING GWL-PROC,                            01913002
CVT999*                            GWL-RC,                              01913104
CVT999*                            PARM-ID1,                            01913204
CVT999*                            PARM-NEW-FLAG,                       01913389
CVT999*                            TDSCHAR,                             01913404
CVT999*                            MAX-LENGTH-PARM,                     01913504
CVT999*                            PARM-L.                              01913604
                                                                        
                                                                        
REARCH*1100-EXIT.                                                       01920802
REARCH*    EXIT.                                                        01920902
                                                                        
      ******************************************************************01921202
      * 2000-PROCESS-OUTPUT.                                           *01921302
      *                                                                *01921402
      *     1. DESCRIBE RESULT SET                                     *01921502
      *     2. UPDATE DB2 DATA                                         *01921602
      *     3. BUILD RESULT SET                                        *01921702
      *     4. SEND RESULT SET                                         *01921802
      *                                                                *01921902
      ******************************************************************01922002
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT                  01922402
           PERFORM 2200-PROCESS-FETCH THRU 2200-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************13000001
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************13000001
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-DFA-ITEM-ID        TO S-DFA-ITEM-ID.                 
REARCH     MOVE RS-REC-TYPE           TO S-REC-TYPE.                    
REARCH     MOVE RS-CURRENT-CHARGES    TO S-CURRENT-CHARGES.             
REARCH     MOVE RS-ARREARS            TO S-ARREARS.                     
REARCH     MOVE RS-BILLED-BALANCE     TO S-BILLED-BALANCE.              
REARCH     MOVE RS-TOTAL-BILL-BAL     TO S-TOTAL-BILL-BAL.              
REARCH     MOVE RS-CONTRACT-AMT       TO S-CONTRACT-AMT.                
REARCH     MOVE RS-LAST-TS            TO S-LAST-TS.                     
REARCH     MOVE RS-EDIT-FLAG          TO S-EDIT-FLAG.                   
REARCH     MOVE RS-DATE-PYMT-START-1  TO S-DATE-PYMT-START-1.           
REARCH     MOVE RS-DATE-PYMT-START-2  TO S-DATE-PYMT-START-2.           
REARCH     MOVE RS-RECV-DESC          TO S-RECV-DESC.                   
REARCH     MOVE RS-ITEM-ID            TO S-ITEM-ID.                     
REARCH     MOVE RS-RECV-BALANCE       TO S-RECV-BALANCE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************01924000
      * 2100-DESCRIBE-RESULT                                           *01930000
      *                                                                *01940000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *01950000
      *                                                                *01960000
      ******************************************************************01970000
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                            01990000
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             02010000
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                  02030000
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02040000
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02050000
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    02060000
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE TO WRKLEN2.                   02070064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02090000
CVT999*                          GWL-RC,                                02100000
CVT999*                          CTR-COLUMN,                            02110000
CVT999*                          DB-HOST-TYPE,                          02120000
CVT999*                          WRKLEN1,                               02130000
CVT999*                          RS-RETURN-CODE,                        02140000
CVT999*                          DB-NULL-INDICATOR,                     02150000
CVT999*                          TDS-FALSE,                             02160000
CVT999*                          DB-CLIENT-TYPE,                        02170000
CVT999*                          WRKLEN1,                               02180000
CVT999*                          CNS-RETURN-CODE,                       02190064
CVT999*                          WRKLEN2.                               02200000
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02220000
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  02231032
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                02232064
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              02233064
CVT999*    MOVE LENGTH OF RS-DFA-ITEM-ID   TO WRKLEN1.                  02234064
CVT999*    MOVE LENGTH OF CNS-DFA-ITEM-ID  TO WRKLEN2.                  02235064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02237032
CVT999*                          GWL-RC,                                02238032
CVT999*                          CTR-COLUMN,                            02239032
CVT999*                          DB-HOST-TYPE,                          02239132
CVT999*                          WRKLEN1,                               02239232
CVT999*                          RS-DFA-ITEM-ID,                        02239364
CVT999*                          DB-NULL-INDICATOR,                     02239432
CVT999*                          TDS-FALSE,                             02239532
CVT999*                          DB-CLIENT-TYPE,                        02239632
CVT999*                          WRKLEN1,                               02239732
CVT999*                          CNS-DFA-ITEM-ID,                       02239864
CVT999*                          WRKLEN2.                               02239932
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-REC-TYPE       TO WRKLEN1.                 02240186
CVT999*    MOVE LENGTH OF CNS-REC-TYPE      TO WRKLEN2.                 02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-REC-TYPE,                            02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-REC-TYPE,                           01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-CURRENT-CHARGES      TO WRKLEN1.           01191064
CVT999*    MOVE LENGTH OF CNS-CURRENT-CHARGES  TO WRKLEN2.              01191064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-CURRENT-CHARGES,                   01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-CURRENT-CHARGES,                  01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-ARREARS      TO WRKLEN1.                   01191064
CVT999*    MOVE LENGTH OF CNS-ARREARS     TO WRKLEN2.                   01191064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-ARREARS,                           01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-ARREARS,                          01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-BILLED-BALANCE TO WRKLEN1.                 01191064
CVT999*    MOVE LENGTH OF CNS-BILLED-BALANCE TO WRKLEN2.                01191064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-BILLED-BALANCE,                    01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-BILLED-BALANCE,                   01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-CONTRACT-AMT   TO WRKLEN1.                 01191064
CVT999*    MOVE LENGTH OF CNS-CONTRACT-AMT   TO WRKLEN2.                01191064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-CONTRACT-AMT,                      01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-CONTRACT-AMT,                     01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-LAST-TS        TO WRKLEN1.                 02240186
CVT999*    MOVE LENGTH OF CNS-LAST-TS       TO WRKLEN2.                 02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-LAST-TS,                             02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-LAST-TS,                            01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-EDIT-FLAG      TO WRKLEN1.                 02240186
CVT999*    MOVE LENGTH OF CNS-EDIT-FLAG     TO WRKLEN2.                 02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-EDIT-FLAG,                           02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-EDIT-FLAG,                          01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-DATE-PYMT-START-1  TO WRKLEN1.             02240186
CVT999*    MOVE LENGTH OF CNS-DATE-PYMT-START-1 TO WRKLEN2.             02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-DATE-PYMT-START-1,                   02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-DATE-PYMT-START-1,                  01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-DATE-PYMT-START-2  TO WRKLEN1.             02240186
CVT999*    MOVE LENGTH OF CNS-DATE-PYMT-START-2 TO WRKLEN2.             02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-DATE-PYMT-START-2,                   02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-DATE-PYMT-START-2,                  01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-TOTAL-BILL-BAL TO WRKLEN1.                 01191064
CVT999*    MOVE LENGTH OF CNS-TOTAL-BILL-BAL TO WRKLEN2.                01191064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-TOTAL-BILL-BAL,                    01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-TOTAL-BILL-BAL,                   01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02240186
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02240186
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02240186
CVT999*    MOVE LENGTH OF RS-RECV-DESC           TO WRKLEN1.            02240186
CVT999*    MOVE LENGTH OF CNS-RECV-DESC          TO WRKLEN2.            02240186
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02240186
CVT999*                         GWL-RC,                                 02240186
CVT999*                         CTR-COLUMN,                             02240186
CVT999*                         DB-HOST-TYPE,                           02240186
CVT999*                         WRKLEN1,                                02240186
CVT999*                         RS-RECV-DESC,                           02240186
CVT999*                         DB-NULL-INDICATOR,                      02240186
CVT999*                         TDS-FALSE,                              02240186
CVT999*                         DB-CLIENT-TYPE,                         02240186
CVT999*                         WRKLEN1,                                01191064
CVT999*                         CNS-RECV-DESC,                          01191064
CVT999*                         WRKLEN2.                                01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
                                                                        
CVT999*    ADD 1                           TO CTR-COLUMN.               02231032
CVT999*    MOVE TDSINT4                    TO DB-HOST-TYPE.             02232064
CVT999*    MOVE TDSINT4                    TO DB-CLIENT-TYPE.           02233064
CVT999*    MOVE LENGTH OF RS-ITEM-ID       TO WRKLEN1.                  02234064
CVT999*    MOVE LENGTH OF CNS-ITEM-ID      TO WRKLEN2.                  02235064
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02237032
CVT999*                          GWL-RC,                                02238032
CVT999*                          CTR-COLUMN,                            02239032
CVT999*                          DB-HOST-TYPE,                          02239132
CVT999*                          WRKLEN1,                               02239232
CVT999*                          RS-ITEM-ID,                            02239364
CVT999*                          DB-NULL-INDICATOR,                     02239432
CVT999*                          TDS-FALSE,                             02239532
CVT999*                          DB-CLIENT-TYPE,                        02239632
CVT999*                          WRKLEN1,                               02239732
CVT999*                          CNS-ITEM-ID,                           02239864
CVT999*                          WRKLEN2.                               02239932
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02240086
C24880*                                                                         
CVT999*    ADD 1        TO CTR-COLUMN.                                  01191064
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                             01191064
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                           01191064
CVT999*    MOVE LENGTH OF RS-RECV-BALANCE   TO WRKLEN1.                 01191064
CVT999*    MOVE LENGTH OF CNS-RECV-BALANCE  TO WRKLEN2.                 01191064
C24880                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              01191064
CVT999*                           GWL-RC,                               01191064
CVT999*                           CTR-COLUMN,                           01191064
CVT999*                           DB-HOST-TYPE,                         01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           RS-RECV-BALANCE,                      01191064
CVT999*                           DB-NULL-INDICATOR,                    01191064
CVT999*                           TDS-FALSE,                            01191064
CVT999*                           DB-CLIENT-TYPE,                       01191064
CVT999*                           WRKLEN1,                              01191064
CVT999*                           CNS-RECV-BALANCE,                     01191064
CVT999*                           WRKLEN2.                              01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
CVT999*    MOVE +2 TO WRKLEN2.                                          01191064
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              01191064
CVT999*                          GWL-RC,                                01191064
CVT999*                          TDS-OBJECT-COL,                        01191064
CVT999*                          CTR-COLUMN,                            01191064
CVT999*                          WRKLEN1,                               01191064
CVT999*                          WRKLEN2.                               01191064
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     01191064
C24880*                                                                         
                                                                        
REARCH*2100-EXIT.                                                       02249800
REARCH*    EXIT.                                                        02250000
                                                                        
       2200-PROCESS-FETCH.                                              
           MOVE PARM-ACCOUNT-NO   TO WS-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO   TO WS-ACCOUNT-NO-NUM.                   
           MOVE WS-ACCOUNT-NO-NUM TO DA-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO.                     
           PERFORM 7510-GET-ACCT-INFO THRU 7510-EXIT.                   
           MOVE AT-TOTAL-AR-BALANCE   TO RS-TOTAL-BILL-BAL.             
T21221     IF PARM-NEW-FLAG = 'S'                                       
T21691        PERFORM 7800-GET-DPP-SETUP-DATES THRU 7800-EXIT           
T21691        PERFORM 7900-CALC-DPP-SETUP-DATES THRU 7900-EXIT          
T21221        MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO                   
T21221                                  CT-ACCOUNT-NO                   
T21221        MOVE 100               TO CT-PYMT-PRIORITY-LVL            
T21221        MOVE 100               TO CT-PYMT-PRIORITY-LVL            
T21221        MOVE WS-CURRENT-DATE TO WS-HOLD-CURRENT-DATE              
T23447        MOVE SEB-SEAS-MONTH TO SEB-SEAS-MONTH-DAY(1:2)            
T23447        MOVE SEB-SEAS-DAY TO SEB-SEAS-MONTH-DAY(3:2)              
T23447        IF WS-CURRENT-MONTH-DAY > SEB-SEAS-MONTH-DAY              
T21221           COMPUTE SEB-SEAS-YEAR-N = (WS-CURRENT-YEAR-N + 1)      
T21221        ELSE                                                      
T21221           MOVE WS-CURRENT-YEAR TO SEB-SEAS-YEAR                  
T21221        END-IF                                                    
T21221        MOVE SEB-SEAS-DATE TO WS-CURRENT-DATE                     
T21221        PERFORM 7520-GET-MAX-ITEM-ID THRU 7520-EXIT               
T34621        PERFORM 2710-SELECT-SEAS-BILLING-DATES THRU 2710-EXIT     
T21221        PERFORM 7400-OPEN-DPPCNTL-CURSOR THRU 7400-EXIT           
T21221        PERFORM 2600-PROCESS-NEW-DPP THRU 2600-EXIT               
T21221            UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
T21221        PERFORM 7420-CLOSE-DPPCNTL-CURSOR THRU 7420-EXIT          
T21221        GO TO 2200-EXIT                                           
T21221     END-IF                                                       
T21221     IF PARM-NEW-FLAG = 'Z'                                       
T21221        MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO                   
T21221                                  CT-ACCOUNT-NO                   
T21221        MOVE 100               TO CT-PYMT-PRIORITY-LVL            
T21221        MOVE 100               TO CT-PYMT-PRIORITY-LVL            
T21221        PERFORM 7520-GET-MAX-ITEM-ID THRU 7520-EXIT               
T21221        PERFORM 2700-SELECT-BILLING-DATES THRU 2700-EXIT          
T21221        PERFORM 7400-OPEN-DPPCNTL-CURSOR THRU 7400-EXIT           
T21221        PERFORM 2600-PROCESS-NEW-DPP THRU 2600-EXIT               
T21221            UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
T21221        PERFORM 7420-CLOSE-DPPCNTL-CURSOR THRU 7420-EXIT          
T21221        GO TO 2200-EXIT                                           
T21221     END-IF                                                       
           IF PARM-NEW-FLAG = 'N'                                       
PCR393        MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO                   
PCR393                                  CT-ACCOUNT-NO                   
PCR393        MOVE 100               TO CT-PYMT-PRIORITY-LVL            
PCR328        PERFORM 2700-SELECT-BILLING-DATES THRU 2700-EXIT          
              PERFORM 7200-OPEN-CURSOR THRU 7200-EXIT                   
              PERFORM 2300-PROCESS-AGREEMENT THRU 2300-EXIT             
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
              PERFORM 7220-CLOSE-CURSOR THRU 7220-EXIT                  
C24880     ELSE                                                         
C24880        IF PARM-NEW-FLAG = 'C'                                    
C24880           MOVE AT-CODES-DATA-PRESENT        TO                   
C24880                                        WS-CODES-DATA-PRESENT     
C24880           MOVE AT-COMPANY-NO                TO Z8-COMPANY-NO     
C24880           MOVE PARM-DFA-TYPE                TO Z8-CODE-DFA-DESC  
C24880           PERFORM 2700-SELECT-BILLING-DATES THRU 2700-EXIT       
C24880           PERFORM 7530-GET-CEC-ITEM-ID      THRU 7530-EXIT       
C24880           PERFORM 7525-GET-CHARGE-DETAILS   THRU 7525-EXIT       
C24880           PERFORM 7526-OPEN-CHARGES-CURSOR  THRU 7526-EXIT       
C24880           PERFORM 7527-FETCH-CHARGES-CURSOR THRU 7527-EXIT       
C24880*                                                                         
C24880           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
C24880              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE    
C24880              GO TO 2200-EXIT                                     
C24880           END-IF                                                 
C24880*                                                                         
C24880           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND    
C24880              PERFORM 2260-PROCESS-CHARGES   THRU 2260-EXIT       
C24880           END-PERFORM                                            
C24880*                                                                         
C24880           PERFORM 7528-CLOSE-CHARGES-CURSOR THRU 7528-EXIT       
C24880                                                                  
              ELSE                                                      
                 PERFORM 7520-GET-MAX-ITEM-ID THRU 7520-EXIT            
                 PERFORM 2700-SELECT-BILLING-DATES THRU 2700-EXIT       
                 IF PARM-DFA-TYPE = 'A'                                 
                    PERFORM 7300-OPEN-DFACNTL-CURSOR THRU 7300-EXIT     
                    PERFORM 2500-PROCESS-NEW-DFA THRU 2500-EXIT         
                       UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND      
                    PERFORM 7320-CLOSE-DFACNTL-CURSOR THRU 7320-EXIT    
                 ELSE                                                   
                    PERFORM 7400-OPEN-DPPCNTL-CURSOR THRU 7400-EXIT     
                    PERFORM 2600-PROCESS-NEW-DPP THRU 2600-EXIT         
                       UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND      
                    PERFORM 7420-CLOSE-DPPCNTL-CURSOR THRU 7420-EXIT    
T18788*FOLLOWING FOUR LINES ARE COMMENTED TO EXCLUDE CNT IN DPP                 
PCR393*          PERFORM 7450-OPEN-CONTRACT-CURSOR THRU 7450-EXIT       02289664
PCR393*          PERFORM 2625-PROCESS-CONTRACT THRU 2625-EXIT           02289784
PCR393*              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND        02289984
PCR393*          PERFORM 7470-CLOSE-CONTRACT-CURSOR THRU 7470-EXIT      02290064
                 END-IF                                                 
C24880        END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2250-CALC-BALANCES.                                              
      **********                                                                
      * SUM INDIVIDUAL AGING BUCKETS, ALL RECEIVABLE TYPES..S.                  
      **********                                                                
           MOVE DV-AGREEMENT-NO TO AC-ITEM-ID.                          
           MOVE ZEROES        TO WS-AMT-00-DAY                          
                                 WS-AMT-30-DAY                          
                                 WS-AMT-60-DAY                          
                                 WS-AMT-90-DAY                          
C24880                           RS-RECV-BALANCE.                       
           PERFORM 7600-SELECT-AR-CNTL THRU 7600-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2250-EXIT
           END-IF.                                          
C24880     COMPUTE RS-RECV-BALANCE = WS-AMT-00-DAY+                     
C24880                               WS-AMT-30-DAY+                     
C24880                               WS-AMT-60-DAY+                     
C24880                               WS-AMT-90-DAY+                     
C24880                               WS-AMT-UNUSED-CR.                  
           MOVE AC-AMT-TRAN-BALANCE TO WS-AMT-TRAN-BAL.                 
           MOVE ZEROES TO WS-CURRENT-CHARGES.                           
           IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
              COMPUTE WS-AMT-ARREARS =                                  
                      (WS-AMT-30-DAY + WS-AMT-60-DAY +                  
                       WS-AMT-90-DAY)                                   
              COMPUTE WS-CURRENT-CHARGES =                              
                      WS-AMT-00-DAY + WS-AMT-UNUSED-CR                  
           ELSE                                                         
              IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
                 COMPUTE WS-AMT-ARREARS = (WS-AMT-60-DAY +              
                         WS-AMT-90-DAY)                                 
                 COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +           
                         WS-AMT-30-DAY + WS-AMT-UNUSED-CR               
              ELSE                                                      
                 IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO   
                    MOVE WS-AMT-90-DAY TO WS-AMT-ARREARS                
                    COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +        
                            WS-AMT-30-DAY + WS-AMT-60-DAY +             
                            WS-AMT-UNUSED-CR
                 END-IF
              END-IF
           END-IF.                           
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880 2260-PROCESS-CHARGES.                                            
C24880*                                                                         
C24880     MOVE Z6-PYMT-PRIORITY-LVL         TO AC-PYMT-PRIORITY-LVL.   
C24880     MOVE ZEROS                        TO AC-ITEM-ID              
C24880                                          WS-AMT-ARREARS          
C24880                                          WS-CURRENT-CHARGES      
C24880                                          WS-CHARGE-AMOUNT        
C24880                                          WS-AMT-00-DAY           
C24880                                          WS-AMT-30-DAY           
C24880                                          WS-AMT-60-DAY           
C24880                                          WS-AMT-90-DAY.          
C24880     PERFORM 7550-GET-AR-CNTL-DET      THRU 7550-EXIT.            
C24880                                                                  
C24880     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C24880        PERFORM 7575-GET-TIMESTAMP     THRU 7575-EXIT             
C24880        PERFORM 2270-POP-AR-VARIABLES  THRU 2270-EXIT             
C24880     ELSE                                                         
C24880        IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO      
C24880           COMPUTE WS-AMT-ARREARS =                               
C24880                   (WS-AMT-30-DAY + WS-AMT-60-DAY +               
C24880                   WS-AMT-90-DAY)                                 
C24880           MOVE WS-AMT-00-DAY          TO WS-CURRENT-CHARGES      
C24880        ELSE                                                      
C24880           IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO   
C24880              COMPUTE WS-AMT-ARREARS = (WS-AMT-60-DAY +           
C24880                    WS-AMT-90-DAY)                                
C24880              COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +        
C24880                    WS-AMT-30-DAY                                 
C24880           ELSE                                                   
C24880              IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO
C24880                 MOVE WS-AMT-90-DAY    TO WS-AMT-ARREARS          
C24880                 COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +     
C24880                        WS-AMT-30-DAY + WS-AMT-60-DAY             
C24880              END-IF                                              
C24880           END-IF                                                 
C24880        END-IF                                                    
C24880     END-IF.                                                      
C24880*                                                                         
C24880     MOVE 'Y'                          TO RS-EDIT-FLAG            
C24880     MOVE AC-ITEM-ID                   TO RS-ITEM-ID              
C24880     MOVE WS-CURRENT-CHARGES           TO RS-CURRENT-CHARGES.     
C24880     MOVE WS-AMT-ARREARS               TO RS-ARREARS.             
C24880     COMPUTE RS-BILLED-BALANCE = WS-AMT-00-DAY +                  
C24880             WS-AMT-30-DAY + WS-AMT-60-DAY + WS-AMT-90-DAY +      
C24880             AC-AMT-UNUSED-CR.                                    
C24880     MOVE AC-LAST-UPDATE-TS            TO RS-LAST-TS.             
C24880     COMPUTE WS-CHARGE-AMOUNT                                     
C24880                = ((Z8-CHARGE-AM * Z6-CHARGE-PERCENT-RT) / 100)   
C24880     MOVE WS-CHARGE-AMOUNT             TO RS-CONTRACT-AMT         
C24880     PERFORM 7560-GET-PYMT-PRTY        THRU 7560-EXIT             
C24880*                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
C24880     PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
C24880     PERFORM 7527-FETCH-CHARGES-CURSOR THRU 7527-EXIT.            
C24880*                                                                         
C24880 2260-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 2270-POP-AR-VARIABLES.                                           
C24880*                                                                         
C24880     MOVE ZEROS                       TO AC-ITEM-ID               
C24880                                         AC-AMT-AR-DAY-00         
C24880                                         AC-AMT-AR-DAY-30         
C24880                                         AC-AMT-AR-DAY-60         
C24880                                         AC-AMT-AR-DAY-90         
C24880                                         AC-AMT-UNUSED-CR         
C24880                                         AC-AMT-TRAN-BALANCE      
C24880                                         AC-TOT-SUMM-UNBILLED.    
C24880     MOVE WS-CURRENT-TIMESTAMP        TO AC-LAST-UPDATE-TS.       
C24880*                                                                         
C24880 2270-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
       2275-ADD-EARNEST-PAY.                                            
           IF DA-FRST-ERNST-PAY-DT EQUAL SPACES                         
              GO TO 2275-EXIT
           END-IF.                                          
                                                                        
           MOVE DA-FRST-ERNST-PAY-DT        TO WS-DPP-ERNST-PAY-DT.     
           MOVE WS-DPP-DATE-MM              TO WS-DATE-8-MM.            
           MOVE WS-DPP-DATE-DD              TO WS-DATE-8-DD.            
           MOVE WS-DPP-DATE-YY              TO WS-DATE-8-YY.            
           MOVE WS-DPP-DATE-CC              TO WS-DATE-8-CC.            
           MOVE WS-DATE-8-NUM               TO AC-ITEM-ID.              
                                                                        
           PERFORM 7600-SELECT-AR-CNTL THRU 7600-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2275-EXIT
           END-IF.                                          
                                                                        
T10741     ADD AC-AMT-TRAN-BALANCE TO WS-AMT-TRAN-BAL.                  
                                                                        
           IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
              COMPUTE WS-AMT-ARREARS = WS-AMT-ARREARS +                 
                      (WS-AMT-30-DAY + WS-AMT-60-DAY +                  
                       WS-AMT-90-DAY)                                   
              COMPUTE WS-CURRENT-CHARGES = WS-CURRENT-CHARGES +         
                      WS-AMT-00-DAY + WS-AMT-UNUSED-CR                  
           ELSE                                                         
              IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
                 COMPUTE WS-AMT-ARREARS = (WS-AMT-ARREARS +             
                         WS-AMT-60-DAY + WS-AMT-90-DAY)                 
                 COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +           
                         WS-AMT-30-DAY + WS-AMT-UNUSED-CR               
              ELSE                                                      
                 IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO   
                    COMPUTE WS-AMT-ARREARS = WS-AMT-ARREARS +           
                            WS-AMT-90-DAY                               
                    COMPUTE WS-CURRENT-CHARGES = WS-CURRENT-CHARGES +   
                            WS-AMT-00-DAY + WS-AMT-30-DAY +             
                            WS-AMT-60-DAY + WS-AMT-UNUSED-CR
                 END-IF
              END-IF
           END-IF.           
                                                                        
           IF DA-SCND-ERNST-PAY-DT EQUAL SPACES                         
              GO TO 2275-EXIT
           END-IF.                                          
                                                                        
           MOVE DA-SCND-ERNST-PAY-DT        TO WS-DPP-ERNST-PAY-DT.     
           MOVE WS-DPP-DATE-MM              TO WS-DATE-8-MM.            
           MOVE WS-DPP-DATE-DD              TO WS-DATE-8-DD.            
           MOVE WS-DPP-DATE-YY              TO WS-DATE-8-YY.            
           MOVE WS-DPP-DATE-CC              TO WS-DATE-8-CC.            
           MOVE WS-DATE-8-NUM               TO AC-ITEM-ID.              
                                                                        
           PERFORM 7600-SELECT-AR-CNTL THRU 7600-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2275-EXIT
           END-IF.                                          
                                                                        
T10741     ADD AC-AMT-TRAN-BALANCE TO WS-AMT-TRAN-BAL.                  
                                                                        
           IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
              COMPUTE WS-AMT-ARREARS = WS-AMT-ARREARS +                 
                      (WS-AMT-30-DAY + WS-AMT-60-DAY +                  
                       WS-AMT-90-DAY)                                   
              COMPUTE WS-CURRENT-CHARGES = WS-CURRENT-CHARGES +         
                      WS-AMT-00-DAY + WS-AMT-UNUSED-CR                  
           ELSE                                                         
              IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
                 COMPUTE WS-AMT-ARREARS = (WS-AMT-ARREARS +             
                         WS-AMT-60-DAY + WS-AMT-90-DAY)                 
                 COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +           
                         WS-AMT-30-DAY + WS-AMT-UNUSED-CR               
              ELSE                                                      
                 IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO   
                    COMPUTE WS-AMT-ARREARS = WS-AMT-ARREARS +           
                            WS-AMT-90-DAY                               
                    COMPUTE WS-CURRENT-CHARGES = WS-CURRENT-CHARGES +   
                            WS-AMT-00-DAY + WS-AMT-30-DAY +             
                            WS-AMT-60-DAY + WS-AMT-UNUSED-CR
                 END-IF
              END-IF
           END-IF.           
                                                                        
       2275-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PROCESS-AGREEMENT.                                          
           MOVE SPACES TO RS-LAST-TS.                                   
           MOVE 'N'    TO RS-EDIT-FLAG.                                 
           PERFORM 7210-FETCH-CURSOR THRU 7210-EXIT.                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           AND DA-CODE-DFA-STATUS = WS-A                                
              IF DV-AGREEMENT-NO NOT = WS-AGREEMENT-NO                  
                 MOVE DV-AGREEMENT-NO TO AC-ITEM-ID                     
                 MOVE DV-AGREEMENT-NO TO WS-AGREEMENT-NO                
                 PERFORM 2250-CALC-BALANCES THRU 2250-EXIT              
                 IF PARM-DFA-TYPE = 'B'                                 
                    PERFORM 2275-ADD-EARNEST-PAY THRU 2275-EXIT         
                 END-IF                                                 
                 MOVE '---' TO RS-REC-TYPE                              
                 MOVE WS-CURRENT-CHARGES TO RS-CURRENT-CHARGES          
                 MOVE WS-AMT-ARREARS     TO RS-ARREARS                  
                 MOVE WS-AMT-TRAN-BAL    TO RS-BILLED-BALANCE           
TP9215           COMPUTE RS-CONTRACT-AMT =                              
TP9215                  WS-AMT-TRAN-BAL - (WS-CURRENT-CHARGES +         
TP9215                                     WS-AMT-ARREARS)              
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
TP9449           MOVE ZEROS TO WS-ACTIVE-RETURN-CODE
              END-IF
           END-IF.                   
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-PROCESS-NEW-DFA.                                            
           PERFORM 7310-FETCH-DFACNTL-CURSOR THRU 7310-EXIT.            
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              GO TO  2500-EXIT
           END-IF.                                         
           MOVE 'Y'    TO RS-EDIT-FLAG.                                 
           MOVE ZEROES TO WS-AMT-ARREARS.                               
           MOVE ZEROES TO WS-CURRENT-CHARGES.                           
           IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
              COMPUTE WS-AMT-ARREARS =                                  
                         (WS-AMT-30-DAY + WS-AMT-60-DAY +               
                         WS-AMT-90-DAY)                                 
              MOVE WS-AMT-00-DAY TO WS-CURRENT-CHARGES                  
           ELSE                                                         
              IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
                 COMPUTE WS-AMT-ARREARS = (WS-AMT-60-DAY +              
                         WS-AMT-90-DAY)                                 
                 COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +           
                         WS-AMT-30-DAY                                  
              ELSE                                                      
                 IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO   
                    MOVE WS-AMT-90-DAY TO WS-AMT-ARREARS                
                    COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +        
                              WS-AMT-30-DAY + WS-AMT-60-DAY
                 END-IF
              END-IF
           END-IF.            
                                                                        
           MOVE WS-CURRENT-CHARGES TO RS-CURRENT-CHARGES.               
           MOVE WS-AMT-ARREARS TO RS-ARREARS.                           
           COMPUTE RS-BILLED-BALANCE = WS-AMT-00-DAY +                  
                   WS-AMT-30-DAY + WS-AMT-60-DAY + WS-AMT-90-DAY +      
                   AC-AMT-UNUSED-CR.                                    
           MOVE RS-BILLED-BALANCE     TO RS-CONTRACT-AMT.               
           MOVE AC-LAST-UPDATE-TS     TO RS-LAST-TS.                    
PCR393     MOVE L5-AR-TYPE-LONG-DESC  TO RS-RECV-DESC.                  
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-PROCESS-NEW-DPP.                                            
           PERFORM 7410-FETCH-DPPCNTL-CURSOR THRU 7410-EXIT.            
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              GO TO  2600-EXIT                                          
PCR393     END-IF.                                                      
                                                                        
PCR393     MOVE ZEROES               TO RS-ITEM-ID.                     
PCR393     MOVE L5-AR-TYPE-LONG-DESC TO RS-RECV-DESC.                   
PCR393     PERFORM 2650-PROCESS-DPP-CONTRACT THRU 2650-EXIT.            
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR393 2625-PROCESS-CONTRACT.                                           
PCR393     PERFORM 7460-FETCH-CONTRACT-CURSOR THRU 7460-EXIT.           
PCR393     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
PCR393        GO TO  2625-EXIT                                          
PCR393     END-IF.                                                      
                                                                        
ACT278     MOVE K6-CNT-NAME-DESC      TO RS-RECV-DESC.                  
PCR393     MOVE AC-ITEM-ID            TO RS-ITEM-ID.                    
PCR393     MOVE L5-AR-TYPE-SHORT-DESC TO RS-REC-TYPE.                   
PCR393     PERFORM 2650-PROCESS-DPP-CONTRACT THRU 2650-EXIT.            
                                                                        
PCR393 2625-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
PCR393 2650-PROCESS-DPP-CONTRACT.                                       
PCR393     MOVE 'Y'    TO RS-EDIT-FLAG.                                 
PCR393     MOVE ZEROES TO WS-AMT-ARREARS.                               
PCR393     MOVE ZEROES TO WS-CURRENT-CHARGES.                           
                                                                        
PCR393     IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
PCR393        COMPUTE WS-AMT-ARREARS =                                  
PCR393                   (WS-AMT-30-DAY + WS-AMT-60-DAY +               
PCR393                   WS-AMT-90-DAY)                                 
PCR393        MOVE WS-AMT-00-DAY TO WS-CURRENT-CHARGES                  
PCR393     ELSE                                                         
PCR393        IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
PCR393           COMPUTE WS-AMT-ARREARS = (WS-AMT-60-DAY +              
PCR393                   WS-AMT-90-DAY)                                 
PCR393           COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +           
PCR393                   WS-AMT-30-DAY                                  
PCR393        ELSE                                                      
PCR393           IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO   
PCR393              MOVE WS-AMT-90-DAY TO WS-AMT-ARREARS                
PCR393              COMPUTE WS-CURRENT-CHARGES = WS-AMT-00-DAY +        
PCR393                        WS-AMT-30-DAY + WS-AMT-60-DAY             
PCR393           END-IF                                                 
PCR393        END-IF                                                    
PCR393     END-IF.                                                      
                                                                        
PCR393     MOVE WS-CURRENT-CHARGES TO RS-CURRENT-CHARGES.               
PCR393     MOVE WS-AMT-ARREARS TO RS-ARREARS.                           
                                                                        
PCR393     COMPUTE RS-BILLED-BALANCE = WS-AMT-00-DAY +                  
PCR393             WS-AMT-30-DAY + WS-AMT-60-DAY + WS-AMT-90-DAY +      
PCR393             AC-AMT-UNUSED-CR.                                    
                                                                        
PCR393     MOVE RS-BILLED-BALANCE     TO RS-CONTRACT-AMT.               
PCR393     MOVE AC-LAST-UPDATE-TS     TO RS-LAST-TS.                    
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
PCR393     PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
PCR393 2650-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
PCR328******************************************************************        
PCR328* 2700-SELECT-BILLING-DATES                                      *        
PCR328******************************************************************        
PCR328                                                                  
PCR328 2700-SELECT-BILLING-DATES.                                       
                                                                        
TP8767     PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT.   
TP8767     IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                         
TP8767        MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE                
TP8767        MOVE WS-FORMAT-YEAR       TO USA-YEAR                     
TP8767        MOVE WS-FORMAT-MONTH      TO USA-MONTH                    
TP8767        MOVE WS-FORMAT-DAY        TO USA-DAY                      
TP8767        MOVE USA-DATE-FORMAT      TO RS-DATE-PYMT-START-1         
TP8767        MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE              
TP8767        MOVE BN-REVENUE-MONTH     TO AT-REV-MTH-LST-NRML          
TP8767     ELSE                                                         
TP8767        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
TP8767        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
TP8767        MOVE '5900'                TO ACTIVE-PARAGRAPH            
TP8767        MOVE 'SELECT'              TO ABEND-FUNCTION              
TP8767        MOVE SPACES                TO ABEND-SQL-PREDICATES        
TP8767                                      ABEND-TABLES                
TP8767        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T16176        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
TP8767        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
TP8767        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
TP8767     END-IF.                                                      
TP8767     PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT.   
TP8767     IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                         
TP8767        MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE                
TP8767        MOVE WS-FORMAT-YEAR       TO USA-YEAR                     
TP8767        MOVE WS-FORMAT-MONTH      TO USA-MONTH                    
TP8767        MOVE WS-FORMAT-DAY        TO USA-DAY                      
TP8767        MOVE USA-DATE-FORMAT      TO RS-DATE-PYMT-START-2         
TP8767     ELSE                                                         
TP8767        MOVE SPACES               TO RS-DATE-PYMT-START-2         
TP8767     END-IF.                                                      
                                                                        
PCR328 2700-EXIT.                                                       
PCR328     EXIT.                                                        
                                                                        
      *                                                                         
T34621*                                                                         
T34621******************************************************************        
T34621* 2710-SELECT-SEAS-BILLING-DATES                                 *        
T34621******************************************************************        
T34621*                                                                         
T34621 2710-SELECT-SEAS-BILLING-DATES.                                  
T34621*                                                                         
T34621     MOVE AT-BILL-CYCLE           TO BN-BILL-CYCLE.               
T34621     MOVE AT-REV-MTH-LST-NRML     TO WS-LST-REV-MTH-NRML.         
T34621     PERFORM 7925-GET-SEAS-BILLING-DATES                          
T34621        THRU 7925-EXIT                                            
T34621     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T34621        MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE                
T34621        MOVE WS-FORMAT-YEAR       TO USA-YEAR                     
T34621        MOVE WS-FORMAT-MONTH      TO USA-MONTH                    
T34621        MOVE WS-FORMAT-DAY        TO USA-DAY                      
T34621        MOVE USA-DATE-FORMAT      TO RS-DATE-PYMT-START-1         
T34621        MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE              
T34621        MOVE BN-REVENUE-MONTH     TO WS-LST-REV-MTH-NRML          
T34621     ELSE                                                         
T34621        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T34621        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34621        MOVE '7925'                TO ACTIVE-PARAGRAPH            
T34621        MOVE 'SELECT'              TO ABEND-FUNCTION              
T34621        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T34621        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T34621        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T34621        MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
T34621        MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
T34621        MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-3             
T34621        MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-3           
T34621        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T34621     END-IF.                                                      
T34621     PERFORM 7925-GET-SEAS-BILLING-DATES                          
T34621        THRU 7925-EXIT                                            
T34621     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T34621        MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE                
T34621        MOVE WS-FORMAT-YEAR       TO USA-YEAR                     
T34621        MOVE WS-FORMAT-MONTH      TO USA-MONTH                    
T34621        MOVE WS-FORMAT-DAY        TO USA-DAY                      
T34621        MOVE USA-DATE-FORMAT      TO RS-DATE-PYMT-START-2         
T34621     ELSE                                                         
T34621        MOVE SPACES               TO RS-DATE-PYMT-START-2         
T34621     END-IF.                                                      
T34621*                                                                         
T34621 2710-EXIT.                                                       
T34621     EXIT.                                                        
T34621*                                                                         
      *************************************************************             
      * INCLUDE FOR CPD00309                                      *             
      *************************************************************             
      *                                                                         
TP8767      EXEC SQL                                                            
TP8767         INCLUDE CPD00309                                                 
TP8767      END-EXEC.                                                           
      *                                                                         
       7200-OPEN-CURSOR.                                                
           EXEC SQL                                                     
                OPEN DFARECV-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
T16176        MOVE 'CSS_DFA_ACCT'      TO TABLE-1                       
CBSI          MOVE 'CSS_DFA_RECVBLE'   TO TABLE-2                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-3                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'CODE_DFA_TYPE'     TO TABLE-ELEMENT-2               
T16176        MOVE DA-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-DFA-TYPE       TO HOSTVAR-ELEMENT-2             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-CURSOR.                                               
           EXEC SQL                                                     
              FETCH DFARECV-CURSOR                                      
              INTO :DA-DATE-OF-AGREE,                                   
                   :DA-CODE-DFA-STATUS,                                 
                   :DA-FRST-ERNST-PAY-DT :WS-NULL-IND1,                  
                   :DA-SCND-ERNST-PAY-DT :WS-NULL-IND2,                  
                   :DV-AGREEMENT-NO,                                    
                   :RS-REC-TYPE,                                        
PCR393             :L5-AR-TYPE-LONG-DESC,                               
                   :RS-CURRENT-CHARGES,                                 
                   :RS-ARREARS,                                         
                   :RS-BILLED-BALANCE,                                  
                   :RS-CONTRACT-AMT,                                    
                   :DV-AMT-DAY-00,                                      
                   :DV-AMT-DAY-30,                                      
                   :DV-AMT-DAY-60,                                      
                   :DV-AMT-DAY-90,                                      
PCR393             :DV-CNT-ITEM-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES TO DA-FRST-ERNST-PAY-DT                    
              END-IF                                                    
              IF WS-NULL-IND2 < 0                                       
                 MOVE SPACES TO DA-SCND-ERNST-PAY-DT                    
              END-IF                                                    
              MOVE DV-AGREEMENT-NO       TO RS-DFA-ITEM-ID              
PCR393        IF RS-REC-TYPE = 'DFA' OR 'CNT'                           
                 IF PARM-DFA-TYPE = 'B'                                 
                    MOVE DV-AMT-DAY-00     TO RS-CURRENT-CHARGES        
                    MOVE DV-AMT-DAY-30     TO RS-ARREARS                
                    MOVE DV-AMT-DAY-60     TO RS-BILLED-BALANCE         
                    MOVE DV-AMT-DAY-90     TO RS-CONTRACT-AMT           
PCR393              MOVE DV-CNT-ITEM-ID       TO RS-ITEM-ID             
PCR393              MOVE L5-AR-TYPE-LONG-DESC TO RS-RECV-DESC           
PCR393              IF DV-CNT-ITEM-ID > 0                               
PCR393                 MOVE DV-CNT-ITEM-ID TO CT-CNT-ITEM-ID            
PCR393                 PERFORM 7700-SELECT-CONTRACT-NAME THRU 7700-EXIT 
PCR393              END-IF                                              
REARCH              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT THRU 8100-EXIT             
                 END-IF                                                 
              ELSE                                                      
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 7210-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
T16176        MOVE 'CSS_DFA_ACCT'      TO TABLE-1                       
T16176        MOVE 'CSS_DFA_RECVBLE'   TO TABLE-2                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-3                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE 'CODE_DFA_TYPE'     TO TABLE-ELEMENT-2               
T16176        MOVE DA-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
T16176        MOVE PARM-DFA-TYPE       TO HOSTVAR-ELEMENT-2             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF
           END-IF.          
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
       7220-CLOSE-CURSOR.                                               
           EXEC SQL                                                     
                CLOSE DFARECV-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7220'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_DFA_ACCT'      TO TABLE-1                       
T16176        MOVE 'CSS_DFA_RECVBLE'   TO TABLE-2                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-3                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'CODE_DFA_TYPE'     TO TABLE-ELEMENT-2               
T16176        MOVE DA-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-DFA-TYPE       TO HOSTVAR-ELEMENT-2             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-OPEN-DFACNTL-CURSOR.                                        
           EXEC SQL                                                     
                OPEN DFACNTL-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
T16176        MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-2                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-FETCH-DFACNTL-CURSOR.                                       
           EXEC SQL                                                     
              FETCH DFACNTL-CURSOR                                      
                 INTO :WS-AMT-00-DAY,                                   
                      :WS-AMT-30-DAY,                                   
                      :WS-AMT-60-DAY,                                   
                      :WS-AMT-90-DAY,                                   
                      :AC-AMT-UNUSED-CR,                                
                      :AC-LAST-UPDATE-TS,                               
                      :RS-REC-TYPE,                                     
PCR393                :L5-AR-TYPE-LONG-DESC                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AC-LAST-UPDATE-TS    TO RS-LAST-TS                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 7310-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7310'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-2                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF
           END-IF.          
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
       7320-CLOSE-DFACNTL-CURSOR.                                       
           EXEC SQL                                                     
                CLOSE DFACNTL-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7320'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_CNTL'      TO TABLE-1                        
T16176        MOVE 'CSS_AR_TYPE'      TO TABLE-2                        
T16176        MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
T16176        MOVE AC-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-OPEN-DPPCNTL-CURSOR.                                        
           EXEC SQL                                                     
                OPEN DPPCNTL-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
T16176        MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-2                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-FETCH-DPPCNTL-CURSOR.                                       
           EXEC SQL                                                     
              FETCH DPPCNTL-CURSOR                                      
                 INTO :WS-AMT-00-DAY,                                   
                      :WS-AMT-30-DAY,                                   
                      :WS-AMT-60-DAY,                                   
                      :WS-AMT-90-DAY,                                   
                      :AC-AMT-UNUSED-CR,                                
                      :AC-LAST-UPDATE-TS,                               
                      :RS-REC-TYPE,                                     
PCR393                :L5-AR-TYPE-LONG-DESC                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AC-LAST-UPDATE-TS    TO RS-LAST-TS                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 7410-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7410'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-2                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF
           END-IF.          
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
       7420-CLOSE-DPPCNTL-CURSOR.                                       
           EXEC SQL                                                     
                CLOSE DPPCNTL-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7420'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_CNTL'      TO TABLE-1                        
T16176        MOVE 'CSS_AR_TYPE'      TO TABLE-2                        
T16176        MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR393 7450-OPEN-CONTRACT-CURSOR.                                       
PCR393     EXEC SQL                                                     
PCR393          OPEN CONTRACT-CURSOR                                    
PCR393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR393     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PCR393                     RS-RETURN-CODE.                              
                                                                        
PCR393     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR393         NEXT SENTENCE                                            
PCR393     ELSE                                                         
PCR393        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
PCR393        MOVE '7450'              TO ACTIVE-PARAGRAPH              
PCR393        MOVE 'OPEN'              TO ABEND-FUNCTION                
PCR393        MOVE SPACES              TO ABEND-SQL-PREDICATES          
PCR393                                    ABEND-TABLES                  
PCR393        MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
T16176        MOVE 'CSS_CONTRACT'      TO TABLE-2                       
T16176        MOVE 'CSS_CONTRACT_INFO' TO TABLE-3                       
T16176        MOVE 'CSS_AR_TYPE'       TO TABLE-4                       
T16176        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T16176        MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
PCR393        PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
PCR393     END-IF.                                                      
                                                                        
PCR393 7450-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
PCR393 7460-FETCH-CONTRACT-CURSOR.                                      
PCR393     EXEC SQL                                                     
PCR393        FETCH CONTRACT-CURSOR                                     
PCR393           INTO :WS-AMT-00-DAY,                                   
PCR393                :WS-AMT-30-DAY,                                   
PCR393                :WS-AMT-60-DAY,                                   
PCR393                :WS-AMT-90-DAY,                                   
PCR393                :AC-AMT-UNUSED-CR,                                
PCR393                :AC-LAST-UPDATE-TS,                               
PCR393                :AC-ITEM-ID,                                      
PCR393                :L5-AR-TYPE-SHORT-DESC,                           
ACT278                :K6-CNT-NAME-DESC                                 
PCR393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR393     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PCR393                     RS-RETURN-CODE.                              
                                                                        
PCR393     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR393         MOVE AC-LAST-UPDATE-TS    TO RS-LAST-TS                  
PCR393     ELSE                                                         
PCR393         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
PCR393            GO TO 7460-EXIT                                       
PCR393         ELSE                                                     
PCR393            MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
PCR393            MOVE '7460'              TO ACTIVE-PARAGRAPH          
PCR393            MOVE 'FETCH'             TO ABEND-FUNCTION            
PCR393            MOVE SPACES              TO ABEND-SQL-PREDICATES      
PCR393                                        ABEND-TABLES              
PCR393            MOVE 'CSS_AR_CNTL'       TO TABLE-1                   
T16176            MOVE 'CSS_CONTRACT'      TO TABLE-2                   
T16176            MOVE 'CSS_CONTRACT_INFO' TO TABLE-3                   
T16176            MOVE 'CSS_AR_TYPE'       TO TABLE-4                   
T16176            MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1           
T16176            MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1         
PCR393            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
PCR393         END-IF                                                   
PCR393     END-IF.                                                      
                                                                        
PCR393 7460-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
PCR393 7470-CLOSE-CONTRACT-CURSOR.                                      
PCR393     EXEC SQL                                                     
PCR393          CLOSE CONTRACT-CURSOR                                   
PCR393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR393     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PCR393                     RS-RETURN-CODE.                              
                                                                        
PCR393     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR393         NEXT SENTENCE                                            
PCR393     ELSE                                                         
PCR393        MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
PCR393        MOVE '7470'            TO ACTIVE-PARAGRAPH                
PCR393        MOVE 'CLOSE'           TO ABEND-FUNCTION                  
PCR393        MOVE SPACES            TO ABEND-SQL-PREDICATES            
PCR393                                  ABEND-TABLES                    
PCR393        MOVE 'CSS_AR_CNTL'     TO TABLE-1                         
T16176        MOVE 'CSS_CONTRACT'    TO TABLE-2                         
T16176        MOVE 'CSS_CONTRACT_INFO' TO TABLE-3                       
T16176        MOVE 'CSS_AR_TYPE'     TO TABLE-4                         
T16176        MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                 
T16176        MOVE AC-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
PCR393        PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
PCR393     END-IF.                                                      
                                                                        
PCR393 7470-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
       7510-GET-ACCT-INFO.                                              
      **********                                                        02338214
      *                                                                 02338214
      **********                                                        02338214
             EXEC SQL                                                   
                 SELECT CAST(SYSDATETIMEOFFSET() AS DATE),                      
                        DATEADD( DAY, -25, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ),                         
                        DATE_BILL_DAY_00,                               
                        DATE_BILL_DAY_30,                               
                        DATE_BILL_DAY_60,                               
                        DATE_BILL_DAY_90,                               
                        BILL_CYCLE,                                     
                        CODE_BILL_FREQ,                                 
TP8767                  REV_MTH_LST_NRML,                               
T10231                  TOTAL_AR_BALANCE,                               
T23501                  COMPANY_NO                                      
                   INTO :WS-CURRENT-DATE,                               
                        :WS-DATE-25-DAYS-AGO,                           
                        :AT-DATE-BILL-DAY-00 :WS-NULL-DATE-IND,          
                        :AT-DATE-BILL-DAY-30 :WS-NULL-DATE-IND,          
                        :AT-DATE-BILL-DAY-60 :WS-NULL-DATE-IND,          
                        :AT-DATE-BILL-DAY-90 :WS-NULL-DATE-IND,          
                        :AT-BILL-CYCLE,                                 
                        :AT-CODE-BILL-FREQ,                             
TP8767                  :AT-REV-MTH-LST-NRML,                           
T10231                  :AT-TOTAL-AR-BALANCE,                           
T23501                  :AT-COMPANY-NO                                  
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
T35434                                                           
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*      EXEC SQL                                                   02338214
MFA-TR*          SELECT CURRENT DATE,                                   02338214
MFA-TR*                 CURRENT DATE - 25 DAYS,                         02338214
MFA-TR*                 DATE_BILL_DAY_00,                               02338214
MFA-TR*                 DATE_BILL_DAY_30,                               02338214
MFA-TR*                 DATE_BILL_DAY_60,                               02338214
MFA-TR*                 DATE_BILL_DAY_90,                               02338214
MFA-TR*                 BILL_CYCLE,                                     02338214
MFA-TR*                 CODE_BILL_FREQ,                                 02338214
MFA-TR*                 REV_MTH_LST_NRML,                                       
MFA-TR*                 TOTAL_AR_BALANCE,                                       
MFA-TR*                 COMPANY_NO                                              
MFA-TR*            INTO :WS-CURRENT-DATE,                               02338214
MFA-TR*                 :WS-DATE-25-DAYS-AGO,                           02338214
MFA-TR*                 :AT-DATE-BILL-DAY-00:WS-NULL-DATE-IND,          02338214
MFA-TR*                 :AT-DATE-BILL-DAY-30:WS-NULL-DATE-IND,          02338214
MFA-TR*                 :AT-DATE-BILL-DAY-60:WS-NULL-DATE-IND,          02338214
MFA-TR*                 :AT-DATE-BILL-DAY-90:WS-NULL-DATE-IND,          02338214
MFA-TR*                 :AT-BILL-CYCLE,                                 02338214
MFA-TR*                 :AT-CODE-BILL-FREQ,                             02338214
MFA-TR*                 :AT-REV-MTH-LST-NRML,                                   
MFA-TR*                 :AT-TOTAL-AR-BALANCE,                                   
MFA-TR*                 :AT-COMPANY-NO                                          
MFA-TR*          FROM CSS_ACCOUNT                                       02338214
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      02338214
MFA-TR*          WITH UR                                                        
MFA-TR*      END-EXEC.                                                  02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '7510'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSS_ACCOUNT'             TO TABLE-1               
T16176          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
             END-IF.          
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-GET-MAX-ITEM-ID.                                            
T5168 *NOTE NEW DFA'S MUST BEGIN AT ITEM ID 40000001 AND NEW DPP'S      02338214
T5168 *MUST START AT 30000001                                           02338214
T5168      IF PARM-DFA-TYPE = 'B'                                       
T5168         EXEC SQL                                                  
T5168              SELECT MAX(DFA_ITEM_ID)                              
T5168              INTO :WS-MAX-AGREEMENT-NO :WS-NULL-ITEM-IND           
T5168               FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                     
T5168               WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO            
T5168               AND PYMT_PRIORITY_LVL = 90                          
T5168               AND DFA_ITEM_ID > 30000000                          
T5168               AND DFA_ITEM_ID < 40000000                          
T35434                                                           
T5168         END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  02338214
MFA-TR*            SELECT MAX(DFA_ITEM_ID)                              02338214
MFA-TR*            INTO :WS-MAX-AGREEMENT-NO:WS-NULL-ITEM-IND                 14
MFA-TR*             FROM CSS_DFA_ACCT                                   02338214
MFA-TR*             WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO            02338214
MFA-TR*             AND PYMT_PRIORITY_LVL = 90                          02338214
MFA-TR*             AND DFA_ITEM_ID > 30000000                          02338214
MFA-TR*             AND DFA_ITEM_ID < 40000000                          02338214
MFA-TR*             WITH UR                                                     
MFA-TR*       END-EXEC                                                  02338214
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
T5168      ELSE                                                         
T5168         EXEC SQL                                                  
T5168            SELECT MAX(DFA_ITEM_ID)                                
T5168              INTO :WS-MAX-AGREEMENT-NO :WS-NULL-ITEM-IND           
T5168              FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                      
T5168              WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO             
T5168               AND PYMT_PRIORITY_LVL = 90                          
T5168               AND DFA_ITEM_ID > 40000000                          
C24880              AND DFA_ITEM_ID < 45000000                          
T35434                                                           
T5168         END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  02338214
MFA-TR*          SELECT MAX(DFA_ITEM_ID)                                02338214
MFA-TR*            INTO :WS-MAX-AGREEMENT-NO:WS-NULL-ITEM-IND                 14
MFA-TR*            FROM CSS_DFA_ACCT                                    02338214
MFA-TR*            WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO             02338214
MFA-TR*             AND PYMT_PRIORITY_LVL = 90                          02338214
MFA-TR*             AND DFA_ITEM_ID > 40000000                          02338214
MFA-TR*             AND DFA_ITEM_ID < 45000000                          02338214
MFA-TR*             WITH UR                                                     
MFA-TR*       END-EXEC                                                  02338214
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
T5168      END-IF.                                                      
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-AGREEMENT-NO = 0                                
                 IF PARM-DFA-TYPE = 'B'                                 
                    MOVE 30000000 TO WS-MAX-AGREEMENT-NO                
                 ELSE                                                   
                    MOVE 40000000 TO WS-MAX-AGREEMENT-NO                
                 END-IF                                                 
              END-IF                                                    
              COMPUTE RS-DFA-ITEM-ID = WS-MAX-AGREEMENT-NO + 1          
           ELSE                                                         
                MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '7520'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSS_DFA_ACCT'            TO TABLE-1               
T16176          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE DA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.          
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880 7525-GET-CHARGE-DETAILS.                                         
C24880     MOVE -1                             TO WS-SEQUENCE-NO-NULL   
C24880     EXEC SQL                                                     
C24880        SELECT  MAX(Z8.CHARGE_SEQUENCE_NO)                        
C24880          INTO  :Z8-CHARGE-SEQUENCE-NO :WS-SEQUENCE-NO-NULL       
C24880          FROM  CSS_CHARGE_TYPE Z8 WITH(READUNCOMMITTED)                  
C24880         WHERE  Z8.COMPANY_NO         = :Z8-COMPANY-NO            
C24880           AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC         
C24880           AND  Z8.CHARGE_STATUS_CD   = 'A'                       
T35434                                                          
C24880     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02338214
MFA-TR*       SELECT  MAX(Z8.CHARGE_SEQUENCE_NO)                        02338214
MFA-TR*         INTO  :Z8-CHARGE-SEQUENCE-NO :WS-SEQUENCE-NO-NULL               
MFA-TR*         FROM  CSS_CHARGE_TYPE Z8                                02338214
MFA-TR*        WHERE  Z8.COMPANY_NO         = :Z8-COMPANY-NO            02338214
MFA-TR*          AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC                 
MFA-TR*          AND  Z8.CHARGE_STATUS_CD   = 'A'                               
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC                                                     02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880*                                                                         
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND              
C24880         WS-SEQUENCE-NO-NULL = 0                                  
C24880         CONTINUE                                                 
C24880     ELSE                                                         
C24880         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C24880         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C24880         MOVE '7525'                     TO ACTIVE-PARAGRAPH      
C24880         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C24880         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880         MOVE 'CSS_CHARGE_TYPE'          TO TABLE-1               
C24880         MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
C24880         MOVE 'CODE_DFA_DESC'            TO TABLE-ELEMENT-2       
C24880         MOVE Z8-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
C24880         MOVE Z8-CODE-DFA-DESC           TO HOSTVAR-ELEMENT-2     
C24880         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C24880         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7525-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                 02338214
C24880                                                                  
C24880 7526-OPEN-CHARGES-CURSOR.                                        
C24880*                                                                         
C24880     EXEC SQL                                                     
C24880         OPEN CHARGE_DETAILS                                      
C24880     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        CONTINUE                                                  
C24880     ELSE                                                         
C24880          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
C24880          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
C24880          MOVE '7526'                    TO ACTIVE-PARAGRAPH      
C24880          MOVE 'OPEN'                    TO ABEND-FUNCTION        
C24880          MOVE SPACES                    TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880          MOVE 'CSS_CHARGE_RECV'         TO TABLE-1               
C24880          MOVE 'CSS_CHARGE_TYPE'         TO TABLE-2               
C24880          MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1       
C24880          MOVE 'CHARGE_SEQUENCE_NO'      TO TABLE-ELEMENT-2       
C24880          MOVE Z8-COMPANY-NO             TO HOSTVAR-ELEMENT-1     
C24880          MOVE Z8-CHARGE-SEQUENCE-NO     TO HOSTVAR-ELEMENT-2     
C24880          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
C24880          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7526-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 7527-FETCH-CHARGES-CURSOR.                                       
C24880     EXEC SQL                                                     
C24880         FETCH CHARGE_DETAILS                                     
C24880          INTO  :Z6-PYMT-PRIORITY-LVL                             
C24880               ,:Z6-CHARGE-PERCENT-RT                             
C24880               ,:Z8-CHARGE-AM                                     
C24880     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C24880        CONTINUE                                                  
C24880     ELSE                                                         
C24880          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
C24880          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
C24880          MOVE '7527'                    TO ACTIVE-PARAGRAPH      
C24880          MOVE 'FETCH'                   TO ABEND-FUNCTION        
C24880          MOVE SPACES                    TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880          MOVE 'CSS_CHARGE_RECV'         TO TABLE-1               
C24880          MOVE 'CSS_CHARGE_TYPE'         TO TABLE-2               
C24880          MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1       
C24880          MOVE 'CHARGE_SEQUENCE_NO'      TO TABLE-ELEMENT-2       
C24880          MOVE Z8-COMPANY-NO             TO HOSTVAR-ELEMENT-1     
C24880          MOVE Z8-CHARGE-SEQUENCE-NO     TO HOSTVAR-ELEMENT-2     
C24880          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
C24880          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7527-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 7528-CLOSE-CHARGES-CURSOR.                                       
C24880     EXEC SQL                                                     
C24880         CLOSE CHARGE_DETAILS                                     
C24880     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        CONTINUE                                                  
C24880     ELSE                                                         
C24880          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
C24880          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
C24880          MOVE '7528'                    TO ACTIVE-PARAGRAPH      
C24880          MOVE 'CLOSE'                   TO ABEND-FUNCTION        
C24880          MOVE SPACES                    TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880          MOVE 'CSS_CHARGE_RECV'         TO TABLE-1               
C24880          MOVE 'CSS_CHARGE_TYPE'         TO TABLE-2               
C24880          MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1       
C24880          MOVE 'CHARGE_SEQUENCE_NO'      TO TABLE-ELEMENT-2       
C24880          MOVE Z8-COMPANY-NO             TO HOSTVAR-ELEMENT-1     
C24880          MOVE Z8-CHARGE-SEQUENCE-NO     TO HOSTVAR-ELEMENT-2     
C24880          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
C24880          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7528-EXIT.                                                       
C24880     EXIT.                                                        
C24880                                                                  
C24880 7530-GET-CEC-ITEM-ID.                                            
C24880*NOTE NEW CONNECTION CHARGE DFA'S MUST START AT 45000001          02338214
C24880        EXEC SQL                                                  
C24880           SELECT MAX(DFA_ITEM_ID)                                
C24880             INTO :WS-MAX-AGREEMENT-NO :WS-NULL-ITEM-IND           
C24880             FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                      
C24880            WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO              
C24880              AND PYMT_PRIORITY_LVL = 90                          
C24880              AND DFA_ITEM_ID       > 45000000                    
T35434                                                           
C24880        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  02338214
MFA-TR*          SELECT MAX(DFA_ITEM_ID)                                02338214
MFA-TR*            INTO :WS-MAX-AGREEMENT-NO:WS-NULL-ITEM-IND                 14
MFA-TR*            FROM CSS_DFA_ACCT                                    02338214
MFA-TR*           WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO              02338214
MFA-TR*             AND PYMT_PRIORITY_LVL = 90                          02338214
MFA-TR*             AND DFA_ITEM_ID       > 45000000                    02338214
MFA-TR*            WITH UR                                                      
MFA-TR*       END-EXEC                                                  02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        IF WS-MAX-AGREEMENT-NO = 0                                
C24880           MOVE 45000000                 TO WS-MAX-AGREEMENT-NO   
C24880        END-IF                                                    
C24880        COMPUTE RS-DFA-ITEM-ID = WS-MAX-AGREEMENT-NO + 1          
C24880     ELSE                                                         
C24880          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
C24880          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
C24880          MOVE '7530'                    TO ACTIVE-PARAGRAPH      
C24880          MOVE 'SELECT'                  TO ABEND-FUNCTION        
C24880          MOVE SPACES                    TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880          MOVE 'CSS_DFA_ACCT'            TO TABLE-1               
C24880          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
C24880          MOVE DA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
C24880          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
C24880          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7530-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 7550-GET-AR-CNTL-DET.                                            
C24880*                                                                         
C24880     IF  AC-PYMT-PRIORITY-LVL < 50                                
C24880         EXEC SQL                                                 
C24880            SELECT AC.AMT_AR_DAY_00,                              
C24880                   AC.AMT_AR_DAY_30,                              
C24880                   AC.AMT_AR_DAY_60,                              
C24880                   AC.AMT_AR_DAY_90,                              
C24880                   AC.AMT_UNUSED_CR,                              
C24880                   AC.AMT_TRAN_BALANCE,                           
C24880                   AC.ITEM_ID,                                    
C24880                   REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
C24880              INTO :WS-AMT-00-DAY,                                
C24880                   :WS-AMT-30-DAY,                                
C24880                   :WS-AMT-60-DAY,                                
C24880                   :WS-AMT-90-DAY,                                
C24880                   :AC-AMT-UNUSED-CR,                             
C24880                   :AC-AMT-TRAN-BALANCE,                          
C24880                   :AC-ITEM-ID,                                   
C24880                   :AC-LAST-UPDATE-TS                             
C24880              FROM CSS_AR_CNTL     AC WITH(READUNCOMMITTED)               
C24880             WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO          
C24880               AND AC.ITEM_ID           = :AC-ITEM-ID             
C24880               AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL   
T35434                                                           
C24880         END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                 02340014
MFA-TR*           SELECT AC.AMT_AR_DAY_00,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_30,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_60,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_90,                              02340014
MFA-TR*                  AC.AMT_UNUSED_CR,                              02340014
MFA-TR*                  AC.AMT_TRAN_BALANCE,                           02340014
MFA-TR*                  AC.ITEM_ID,                                            
MFA-TR*                  AC.LAST_UPDATE_TS                                      
MFA-TR*             INTO :WS-AMT-00-DAY,                                02340014
MFA-TR*                  :WS-AMT-30-DAY,                                02340014
MFA-TR*                  :WS-AMT-60-DAY,                                02340014
MFA-TR*                  :WS-AMT-90-DAY,                                02340014
MFA-TR*                  :AC-AMT-UNUSED-CR,                             02340014
MFA-TR*                  :AC-AMT-TRAN-BALANCE,                          02340014
MFA-TR*                  :AC-ITEM-ID,                                   02340014
MFA-TR*                  :AC-LAST-UPDATE-TS                                     
MFA-TR*             FROM CSS_AR_CNTL     AC                             02340014
MFA-TR*            WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO          02340014
MFA-TR*              AND AC.ITEM_ID           = :AC-ITEM-ID             02340014
MFA-TR*              AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL   02340014
MFA-TR*             WITH UR                                                     
MFA-TR*        END-EXEC                                                 02340014
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
C24880     ELSE                                                         
C24880         EXEC SQL                                                 
C24880            SELECT AC.AMT_AR_DAY_00,                              
C24880                   AC.AMT_AR_DAY_30,                              
C24880                   AC.AMT_AR_DAY_60,                              
C24880                   AC.AMT_AR_DAY_90,                              
C24880                   AC.AMT_UNUSED_CR,                              
C24880                   AC.AMT_TRAN_BALANCE,                           
C24880                   AC.ITEM_ID,                                    
C24880                   REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
C24880              INTO :WS-AMT-00-DAY,                                
C24880                   :WS-AMT-30-DAY,                                
C24880                   :WS-AMT-60-DAY,                                
C24880                   :WS-AMT-90-DAY,                                
C24880                   :WS-AMT-UNUSED-CR,                             
C24880                   :AC-AMT-TRAN-BALANCE,                          
C24880                   :AC-ITEM-ID,                                   
C24880                   :AC-LAST-UPDATE-TS                             
C24880              FROM CSS_AR_CNTL     AC WITH(READUNCOMMITTED)               
C24880             WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO          
C24880               AND AC.ITEM_ID           > :AC-ITEM-ID             
C24880               AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL   
T35434                                                           
C24880         END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                 02340014
MFA-TR*           SELECT AC.AMT_AR_DAY_00,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_30,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_60,                              02340014
MFA-TR*                  AC.AMT_AR_DAY_90,                              02340014
MFA-TR*                  AC.AMT_UNUSED_CR,                              02340014
MFA-TR*                  AC.AMT_TRAN_BALANCE,                           02340014
MFA-TR*                  AC.ITEM_ID,                                            
MFA-TR*                  AC.LAST_UPDATE_TS                                      
MFA-TR*             INTO :WS-AMT-00-DAY,                                02340014
MFA-TR*                  :WS-AMT-30-DAY,                                02340014
MFA-TR*                  :WS-AMT-60-DAY,                                02340014
MFA-TR*                  :WS-AMT-90-DAY,                                02340014
MFA-TR*                  :WS-AMT-UNUSED-CR,                             02340014
MFA-TR*                  :AC-AMT-TRAN-BALANCE,                          02340014
MFA-TR*                  :AC-ITEM-ID,                                   02340014
MFA-TR*                  :AC-LAST-UPDATE-TS                                     
MFA-TR*             FROM CSS_AR_CNTL     AC                             02340014
MFA-TR*            WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO          02340014
MFA-TR*              AND AC.ITEM_ID           > :AC-ITEM-ID             02340014
MFA-TR*              AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL   02340014
MFA-TR*             WITH UR                                                     
MFA-TR*        END-EXEC                                                 02340014
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
C24880     END-IF.                                                      
C24880                                                                  
C24880     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C24880        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C24880        MOVE '7550'                    TO ACTIVE-PARAGRAPH        
C24880        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C24880        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C24880                                          ABEND-TABLES            
C24880        MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
C24880        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
C24880        MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2         
C24880        MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-3         
C24880        MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C24880        MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-2       
C24880        MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-3       
C24880        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24880        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7550-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 7560-GET-PYMT-PRTY.                                              
C24880*                                                                 02338214
C24880        EXEC SQL                                                  
C24880           SELECT AR_TYPE_SHORT_DESC,                             
C24880                  AR_TYPE_LONG_DESC                               
C24880             INTO :RS-REC-TYPE,                                   
C24880                  :RS-RECV-DESC                                   
C24880             FROM CSS_AR_TYPE WITH(READUNCOMMITTED)                       
C24880            WHERE PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       
T35434                                                           
C24880        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  02338214
MFA-TR*          SELECT AR_TYPE_SHORT_DESC,                             02338214
MFA-TR*                 AR_TYPE_LONG_DESC                                       
MFA-TR*            INTO :RS-REC-TYPE,                                         14
MFA-TR*                 :RS-RECV-DESC                                           
MFA-TR*            FROM CSS_AR_TYPE                                     02338214
MFA-TR*           WHERE PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       02338214
MFA-TR*            WITH UR                                                      
MFA-TR*       END-EXEC                                                  02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C24880         CONTINUE                                                 
C24880     ELSE                                                         
C24880          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
C24880          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
C24880          MOVE '7560'                    TO ACTIVE-PARAGRAPH      
C24880          MOVE 'SELECT'                  TO ABEND-FUNCTION        
C24880          MOVE SPACES                    TO ABEND-SQL-PREDICATES  
C24880                                            ABEND-TABLES          
C24880          MOVE 'CSS_AR_TYPE'             TO TABLE-1               
C24880          MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-1       
C24880          MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-1     
C24880          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
C24880          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7560-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C24880 7575-GET-TIMESTAMP.                                              
C24880*                                                                         
C24880     EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02340014
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C24880        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C24880        MOVE '7575'                    TO ACTIVE-PARAGRAPH        
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
C24880        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C24880                                          ABEND-TABLES            
C24880        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24880        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7575-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
      ******************************************************************02340014
      * 7600-SELECT-AR-CNTL.                                           *02340014
      ******************************************************************02340014
       7600-SELECT-AR-CNTL.                                             
           EXEC SQL                                                     
               SELECT AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90,                                    
                      AMT_UNUSED_CR,                                    
                      AMT_TRAN_BALANCE                                  
                 INTO :WS-AMT-00-DAY,                                   
                      :WS-AMT-30-DAY,                                   
                      :WS-AMT-60-DAY,                                   
                      :WS-AMT-90-DAY,                                   
                      :WS-AMT-UNUSED-CR,                                
                      :AC-AMT-TRAN-BALANCE                              
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                 WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      
                   AND ITEM_ID = :AC-ITEM-ID                            
                   AND PYMT_PRIORITY_LVL = +90                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02340014
MFA-TR*        SELECT AMT_AR_DAY_00,                                    02340014
MFA-TR*               AMT_AR_DAY_30,                                    02340014
MFA-TR*               AMT_AR_DAY_60,                                    02340014
MFA-TR*               AMT_AR_DAY_90,                                    02340014
MFA-TR*               AMT_UNUSED_CR,                                    02340014
MFA-TR*               AMT_TRAN_BALANCE                                  02340014
MFA-TR*          INTO :WS-AMT-00-DAY,                                   02340014
MFA-TR*               :WS-AMT-30-DAY,                                   02340014
MFA-TR*               :WS-AMT-60-DAY,                                   02340014
MFA-TR*               :WS-AMT-90-DAY,                                   02340014
MFA-TR*               :WS-AMT-UNUSED-CR,                                02340014
MFA-TR*               :AC-AMT-TRAN-BALANCE                              02340014
MFA-TR*          FROM CSS_AR_CNTL                                       02340014
MFA-TR*          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      02340014
MFA-TR*            AND ITEM_ID = :AC-ITEM-ID                            02340014
MFA-TR*            AND PYMT_PRIORITY_LVL = +90                          02340014
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
T16176        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
T16176        MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-2         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
T16176        MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR393 7700-SELECT-CONTRACT-NAME.                                       
PCR393     EXEC SQL                                                     
ACT278         SELECT K6.CNT_NAME_DESC                                  
ACT278           INTO :K6-CNT-NAME-DESC                                 
PCR393           FROM CSS_CONTRACT CT WITH(READUNCOMMITTED),                    
PCR393                CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)                
PCR393           WHERE CT.ACCOUNT_NO          = :CT-ACCOUNT-NO          
PCR393             AND CT.PYMT_PRIORITY_LVL   = :CT-PYMT-PRIORITY-LVL   
PCR393             AND CT.CNT_ITEM_ID         = :CT-CNT-ITEM-ID         
PCR393             AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD          
T35434                                                           
PCR393     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02340014
MFA-TR*        SELECT K6.CNT_NAME_DESC                                  02340014
MFA-TR*          INTO :K6-CNT-NAME-DESC                                 02340014
MFA-TR*          FROM CSS_CONTRACT CT,                                  02340014
MFA-TR*               CSS_CONTRACT_INFO K6                                      
MFA-TR*          WHERE CT.ACCOUNT_NO          = :CT-ACCOUNT-NO          02340014
MFA-TR*            AND CT.PYMT_PRIORITY_LVL   = :CT-PYMT-PRIORITY-LVL   02340014
MFA-TR*            AND CT.CNT_ITEM_ID         = :CT-CNT-ITEM-ID         02340014
MFA-TR*            AND CT.CNT_NAME_CD         = K6.CNT_NAME_CD                  
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR393     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
PCR393     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT278        MOVE K6-CNT-NAME-DESC TO RS-RECV-DESC                     
PCR393     ELSE                                                         
PCR393        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PCR393           MOVE 'NOT FOUND'   TO RS-RECV-DESC                     
PCR393        ELSE                                                      
PCR393           MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE       
PCR393           MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
PCR393           MOVE '7700'                    TO ACTIVE-PARAGRAPH     
PCR393           MOVE 'SELECT'                  TO ABEND-FUNCTION       
PCR393           MOVE SPACES                    TO ABEND-SQL-PREDICATES 
PCR393                                             ABEND-TABLES         
T16176           MOVE 'CSS_CONTRACT'            TO TABLE-1              
PCR393           MOVE 'CSS_CONTRACT_INFO'       TO TABLE-2              
T16176           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
T16176           MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2      
T16176           MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-3      
PCR393           MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
T16176           MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2    
T16176           MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3    
PCR393           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
PCR393           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
PCR393        END-IF                                                    
PCR393     END-IF.                                                      
                                                                        
PCR393 7700-EXIT.                                                       
PCR393     EXIT.                                                        
                                                                        
T21691******************************************************************02340014
T21691* SELECTS SEASONAL DPP START AND END DATES                       *02340014
T21691* FROM CSS_DELINQUENCY.                                          *02340014
T21691******************************************************************02340014
T21691 7800-GET-DPP-SETUP-DATES.                                        
T21691                                                                  
T21691     MOVE 'DATE-SEAS-DPP-START' TO C8-DELINQ-CD.                  
T21691     PERFORM 7810-GET-DELINQ-VALUES THRU 7810-EXIT.               
T21691     MOVE C8-DELINQ-VALUE TO WS-DATE-SEAS-DPP-START.              
T21691                                                                  
T21691     MOVE 'DATE-SEAS-DPP-END' TO C8-DELINQ-CD.                    
T21691     PERFORM 7810-GET-DELINQ-VALUES THRU 7810-EXIT.               
T21691     MOVE C8-DELINQ-VALUE TO WS-DATE-SEAS-DPP-END.                
T21691                                                                  
T21691 7800-EXIT.                                                       
T21691     EXIT.                                                        
T21691                                                                  
T21691******************************************************************02340014
T21691* SELECTS VALUES FROM CSS_DELINQUENCY.                           *02340014
T21691******************************************************************02340014
T21691 7810-GET-DELINQ-VALUES.                                          
T21691     EXEC SQL                                                     
T21691        SELECT DELINQ_VALUE                                       
T21691          INTO :C8-DELINQ-VALUE                                   
T21691          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
T21691         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
T35434                                                           
T21691     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                       02333314
MFA-TR*         INTO :C8-DELINQ-VALUE                                   02333464
MFA-TR*         FROM CSS_DELINQUENCY                                    02333514
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                          02333514
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    02333614

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21691                                                                  
T21691     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T21691                                                                  
T21691     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21691        CONTINUE                                                  
T21691     ELSE                                                         
T21691        MOVE '7800'                     TO ACTIVE-PARAGRAPH       
T21691        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T21691        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T21691        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
T21691        MOVE 'C8-DELINQ-CD'             TO TABLE-ELEMENT-1        
T21691        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
T21691        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T21691        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T21691     END-IF.                                                      
T21691                                                                  
T21691 7810-EXIT.                                                       
T21691     EXIT.                                                        
T21691******************************************************************02340014
T21691* SELECTS SEASONAL DPP START AND END DATES                       *02340014
T21691* FROM CSS_DELINQUENCY.                                          *02340014
T21691******************************************************************02340014
T21691 7900-CALC-DPP-SETUP-DATES.                                       
T21691                                                                  
T21691     MOVE WS-CURRENT-DATE TO WS-HOLD-CURRENT-DATE.                
T21691                                                                  
T21691     MOVE WS-DATE-SEAS-DPP-START(1:2) TO WS-DPP-START-MONTH.      
T21691     MOVE WS-DATE-SEAS-DPP-START(3:2) TO WS-DPP-START-DAY.        
T23447     MOVE WS-DATE-SEAS-DPP-START(1:4) TO WS-DPP-START-MONTH-DAY.  
T21691     MOVE WS-DATE-SEAS-DPP-END(1:2) TO WS-DPP-END-MONTH.          
T21691     MOVE WS-DATE-SEAS-DPP-END(3:2) TO WS-DPP-END-DAY.            
T23447     MOVE WS-DATE-SEAS-DPP-END(1:4) TO WS-DPP-END-MONTH-DAY.      
T23447     MOVE WS-CURRENT-MONTH TO WS-CURRENT-MONTH-DAY(1:2).          
T23447     MOVE WS-CURRENT-DAY   TO WS-CURRENT-MONTH-DAY(3:2).          
T21691                                                                  
T21691*****IF SEASONAL DPP IS ENTERED ON DATES THAT ARE OUTSIDE THE             
T21691*****THE DATE RANGE THEN AN ERROR MESSAGE WILL BE DISPLAYED.              
T23447     MOVE 'Y' TO WS-MESSAGE.                                      
T23447     IF WS-DPP-END-MONTH-DAY < WS-DPP-START-MONTH-DAY             
T23447        IF WS-CURRENT-MONTH-DAY <= WS-DPP-START-MONTH-DAY         
T23447        AND WS-CURRENT-MONTH-DAY <= WS-DPP-END-MONTH-DAY          
T23447           MOVE 'N' TO WS-MESSAGE                                 
T23447        ELSE                                                      
T23447           IF WS-CURRENT-MONTH-DAY >= WS-DPP-START-MONTH-DAY      
T23447           AND WS-CURRENT-MONTH-DAY >= WS-DPP-END-MONTH-DAY       
T23447              MOVE 'N' TO WS-MESSAGE                              
T23447           END-IF                                                 
T23447        END-IF                                                    
T23447        IF WS-MESSAGE = 'Y'                                       
T23447           MOVE +555 TO RS-RETURN-CODE                            
T23447           GO TO 2200-EXIT                                        
T23447        END-IF                                                    
T23447     ELSE                                                         
T23447        IF WS-DPP-END-MONTH-DAY = WS-DPP-START-MONTH-DAY          
T23447           CONTINUE                                               
T23447        ELSE                                                      
T23447           IF WS-CURRENT-MONTH-DAY < WS-DPP-START-MONTH-DAY       
T23447           OR WS-CURRENT-MONTH-DAY > WS-DPP-END-MONTH-DAY         
T21691              MOVE +555 TO RS-RETURN-CODE                         
T21691              GO TO 2200-EXIT                                     
T21691           END-IF                                                 
T23447        END-IF                                                    
T21691     END-IF.                                                      
T21691                                                                  
T21691 7900-EXIT.                                                       
T21691     EXIT.                                                        
T34621*                                                                         
T34621 7925-GET-SEAS-BILLING-DATES.                                     
T34621*                                                                         
T34621     EXEC SQL                                                     
T34621         SELECT TOP(1) DATE_EXTRACT,
              REVENUE_MONTH                                     
T34621           INTO :BN-DATE-EXTRACT                                  
T34621               ,:BN-REVENUE-MONTH                                 
T34621           FROM CSS_BILL_WINDOW                                   
T34621          WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    
T34621          AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
T34621          AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                
T34621          ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                
T34621                                              
T34621     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_EXTRACT                                              
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*              ,:BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                            
MFA-TR*         AND DATE_EXTRACT >= :WS-CURRENT-DATE                            
MFA-TR*         AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                        
MFA-TR*         ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34621                                                                  
T34621     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
T34621                     WS-DISP-RETURN-CODE.                         
T34621                                                                  
T34621     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34621        CONTINUE                                                  
T34621     ELSE                                                         
T34621        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34621        MOVE '7925'                TO ACTIVE-PARAGRAPH            
T34621        MOVE 'SELECT'              TO ABEND-FUNCTION              
T34621        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T34621        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T34621        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T34621        MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
T34621        MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
T34621        MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-3             
T34621        MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-3           
T34621        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T34621     END-IF.                                                      
T34621                                                                  
T34621 7925-EXIT.                                                       
           EXIT.                                                        
T34621*                                                                         
TP8767******************************************************************        
TP8767* 9700 - SPECIAL / ERROR HANDLING ROUTINE                        *        
TP8767******************************************************************        
TP8767     EXEC SQL                                                             
TP8767        INCLUDE CPD0023C                                                  
TP8767     END-EXEC.                                                            
      *                                                                 02340014
      ******************************************************************02354600
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *02354600
      ******************************************************************02354600
           EXEC SQL                                                     02354600
              INCLUDE CPDSP300                                          02354600
           END-EXEC.                                                    02354600
                                                                        
      ******************************************************************02354600
      *       END PROGRAM COPYLIB                                      *02354600
      ******************************************************************02354600
CVT999*    COPY CPD00302.                                               02354600
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02083_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,DFA_ITEM_ID                                               
CVT000       ,REC_TYPE                                                  
CVT000       ,CURRENT_CHARGES                                           
CVT000       ,ARREARS                                                   
CVT000       ,BILLED_BALANCE                                            
CVT000       ,CONTRACT_AMT                                              
CVT000       ,LAST_TS                                                   
CVT000       ,EDIT_FLAG                                                 
CVT000       ,DATE_PYMT_START_1                                         
CVT000       ,DATE_PYMT_START_2                                         
CVT000       ,TOTAL_BILL_BAL                                            
CVT000       ,RECV_DESC                                                 
CVT000       ,ITEM_ID                                                   
CVT000       ,RECV_BALANCE                                              
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-DFA-ITEM-ID                                            
REARCH       ,:S-REC-TYPE                                               
REARCH       ,:S-CURRENT-CHARGES                                        
REARCH       ,:S-ARREARS                                                
REARCH       ,:S-BILLED-BALANCE                                         
REARCH       ,:S-CONTRACT-AMT                                           
REARCH       ,:S-LAST-TS                                                
REARCH       ,:S-EDIT-FLAG                                              
REARCH       ,:S-DATE-PYMT-START-1                                      
REARCH       ,:S-DATE-PYMT-START-2                                      
REARCH       ,:S-TOTAL-BILL-BAL                                         
REARCH       ,:S-RECV-DESC                                              
REARCH       ,:S-ITEM-ID                                                
REARCH       ,:S-RECV-BALANCE                                           
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02083_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,DFA_ITEM_ID                                                       
MFA-TR*      ,REC_TYPE                                                          
MFA-TR*      ,CURRENT_CHARGES                                                   
MFA-TR*      ,ARREARS                                                           
MFA-TR*      ,BILLED_BALANCE                                                    
MFA-TR*      ,CONTRACT_AMT                                                      
MFA-TR*      ,LAST_TS                                                           
MFA-TR*      ,EDIT_FLAG                                                         
MFA-TR*      ,DATE_PYMT_START_1                                                 
MFA-TR*      ,DATE_PYMT_START_2                                                 
MFA-TR*      ,TOTAL_BILL_BAL                                                    
MFA-TR*      ,RECV_DESC                                                         
MFA-TR*      ,ITEM_ID                                                           
MFA-TR*      ,RECV_BALANCE                                                      
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-DFA-ITEM-ID                                                    
MFA-TR*      ,:S-REC-TYPE                                                       
MFA-TR*      ,:S-CURRENT-CHARGES                                                
MFA-TR*      ,:S-ARREARS                                                        
MFA-TR*      ,:S-BILLED-BALANCE                                                 
MFA-TR*      ,:S-CONTRACT-AMT                                                   
MFA-TR*      ,:S-LAST-TS                                                        
MFA-TR*      ,:S-EDIT-FLAG                                                      
MFA-TR*      ,:S-DATE-PYMT-START-1                                              
MFA-TR*      ,:S-DATE-PYMT-START-2                                              
MFA-TR*      ,:S-TOTAL-BILL-BAL                                                 
MFA-TR*      ,:S-RECV-DESC                                                      
MFA-TR*      ,:S-ITEM-ID                                                        
MFA-TR*      ,:S-RECV-BALANCE                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02083_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02083_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02083_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02083_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
