       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02082.                                         
COB303 DATE-WRITTEN.   MAY 01, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                 *       
      *                 SOUTH CAROLINA ELECTRIC & GAS                   *       
      *                                                                 *       
      *   THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *       
      *                                                                 *       
      *   TRANID:        S082                                           *       
      *   PROGRAM:       S082                                           *       
      *   CALLING SP:    PA_S082                                        *       
      *                                                                 *       
      ******************************************************************        
      *                  P R O G R A M  S U M M A R Y                   *       
      *                                                                *        
      *   THIS PROCEDURE RETRIEVES LANDLORD INFORMATION FOR A          *        
      *   PARTICULAR PREMISE IN A SINGLE ROW.  THIS INCLUDES LANDLORD  *        
      *   DATA DIRECTLY, AND ADDITIONAL INFORMATION ABOUT THE LANDLORD *        
      *   SUCH AS NAME, ADDRESS.                                       *        
      *                                                                *        
      *   PARAMETERS:                                                  *        
      *     PREMISE-NO (STRING)                                        *        
      *   RETURNS:                                                     *        
      *     RETURN-CODE (INT - SUCCESS INDICATOR)                      *        
      *     CODE-RENTAL-PROP                                           *        
      *     LL-CUSTOMER-NO                                             *        
      *     LL-MASTER-ACCT-NO                                          *        
      *     (FOLLOWING FIELDS ARE ALL LOOKED UP FOR THE LANDLORD)      *        
      *     FIRST-NAME                                                 *        
      *     MIDDLE-NAME                                                *        
      *     LAST-NAME                                                  *        
      *     FULL-NAME                                                  *        
      *     NAME-FORMAT                                                *        
      *     ADDR-STREET                                                *        
      *     ADDRESS-OVERFLOW                                           *        
      *     ADDR-CITY-STATE                                            *        
      *     ADDR-ZIP-CODE                                              *        
      *     ADDR-COUNTRY                                               *        
      *     LL-PREMISE (STRING)                                        *        
      *     LL-ACCOUNT (STRING)                                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                      PROGRAM MODIFICATION LOG                  *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *   --------  --------   --------------------------------------- *        
      *   05/01/95    TOR      PROCEDURE ORIGINALLY CODED.             *        
      *                                                                *        
CBSI  *   08/03/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE   *        
CBSI  *               MADRAS   ABEND PARAMETERS                        *        
T23618*   03/28/01    RR       ADDED WS-SEASONAL-REVERT                *        
      *                        TO LANDLORD RETRIEVE                    *        
REARCH*   02/22/06    CVNS     RPC TO DB2 SP CONVERSION                *        
REARCH*               CHENNAI                                          *        
T36931*   05/08/08    SRIDHAR  INCREASE OF NAME LENGTH                 *        
A04527*   06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                 ---- BASIC SEQUENCE STRUCTURE ----             *        
      *                                                                *        
      *   0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *        
      *   1000 - 1999  INPUT PROCESSING CONTROL PATH                   *        
      *   2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *        
      *   3000 - 4999  NOT USED                                        *        
      *   5000 - 5999  COMMON PROGRAM MODULES                          *        
      *   6000 - 6999  COMMON SYSTEM MODULES                           *        
      *   7000 - 7999  INPUT MODULES                                   *        
      *   8000 - 8999  OUTPUT MODULES                                  *        
      *   9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02082'.
MSQ017     COPY MFASQLM.
                                                                        
       01   WS-START                                   PIC X(40) VALUE  
REARCH     'WORKING STORAGE FOR CSR02082 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *     DB2 INCLUDES                                                *       
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *     COBOL WORKING STORAGE COPY BOOKS                            *       
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CJF00113.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   WORK AREA                                                     *       
      ******************************************************************        
                                                                        
       01   WS-MISC.                                                    
REARCH*    05   PROGRAM-NAME             PIC X(08) VALUE 'S082    '.            
REARCH     05   PROGRAM-NAME             PIC X(08) VALUE 'CSR02082'.    
           05   WS-PREMISE-NO            PIC X(10).                     
           05   WS-PREMISE-NO-RED        REDEFINES WS-PREMISE-NO        
                                         PIC 9(10).                     
COB305     05 WS-PREMISE-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05   WS-LL-MASTER-ACCT-NO     PIC X(13).                     
           05   WS-LL-MASTER-ACCT-RED    REDEFINES WS-LL-MASTER-ACCT-NO 
                                         PIC 9(13).                     
           05   WS-ADDRESS-ID            PIC 9(13).                     
           05   WS-ADDRESS-ID-S          REDEFINES WS-ADDRESS-ID        
                                         PIC X(13).                     
                                                                        
           05   ALL-DONE-SW              PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05   SEND-DONE-SW             PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
COB305     05 WS-LL-PREMISE-DEC        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-LL-ACCOUNT-DEC        PIC S9(13)V USAGE COMP-3 VALUE 0.      
                                                                        
REARCH*01   GW-LIB-MISC-FIELDS.                                                 
REARCH*    05   GWL-PROC                 POINTER.                               
REARCH*    05   GWL-INIT-HANDLE          POINTER.                               
REARCH*    05   GWL-RC                   PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-NR            PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-DONE          PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-COUNT         PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-COMM          PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                        
REARCH*    05   GWL-STATUS-SUBCODE       PIC S9(9) COMP.                        
       01   FILLER                       PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
REARCH*01   PARM-FIELDS.                                                        
REARCH*    05   PARM-L                     PIC S9(9) COMP.                      
REARCH*    05   PARM-ID1                   PIC S9(9) COMP VALUE 1.              
REARCH*    05   PARM-PREMISE-NO            PIC X(10).                           
                                                                        
       01   SNA-FIELDS.                                                 
           05   SNA-SUBC                PIC S9(9) COMP.                 
           05   SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.         
                                                                        
       01   COUNTER-FIELDS.                                             
           05   CTR-COLUMN              PIC S9(9) COMP VALUE 1.         
           05   CTR-ROWS                PIC S9(9) COMP VALUE 0.         
                                                                        
       01   WORK-FIELDS.                                                
           05   MAX-LENGTH-PARM         PIC S9(9) COMP.                 
           05   WRKLEN1                 PIC S9(9) COMP.                 
           05   WRKLEN2                 PIC S9(9) COMP.                 
           05   WRK-DONE-STATUS         PIC S9(9) COMP.                 
                                                                        
       01   MESSAGE-FIELDS.                                             
           05   MSG-TYPE                PIC S9(9) COMP.                 
           05   MSG-SEVERITY            PIC S9(9) COMP VALUE 11.        
           05   MSG-NR                  PIC S9(9) COMP VALUE  2.        
           05   MSG-RPC                 PIC X(4)       VALUE 'S288'.    
           05   MSG-RPC-L               PIC S9(9) COMP.                 
           05   MSG-TEXT                PIC X(100).                     
           05   MSG-TEXT-L              PIC S9(9) COMP.                 
           05   MSG-SQL-ERROR.                                          
               10   FILLER              PIC X(10) VALUE 'SQLCODE = '.   
               10   MSG-SQL-ERROR-C     PIC -9(3) DISPLAY.              
               10   FILLER              PIC X(16)                       
                   VALUE ', ERROR TOKENS: '.                            
               10   MSG-SQL-ERROR-K     PIC X(70).                      
               10   MSG-SQL-ERROR-K-CHARS                               
                                       REDEFINES MSG-SQL-ERROR-K        
                                       OCCURS 70 TIMES                  
                                       PIC X.                           
           05   MSG-SQL-ERROR-SS        PIC S9(4) COMP.                 
                                                                        
       01   FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.     
                                                                        
       01   TDS-RETURN-FIELDS.                                          
           05   RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.       
           05   RS-CODE-RENTAL-PROP      PIC X(01) VALUE SPACES.        
           05   RS-LL-CUSTOMER-NO        PIC X(10) VALUE SPACES.        
           05   RS-LL-MASTER-ACCT-NO     PIC X(13) VALUE SPACES.        
           05   RS-FIRST-NAME            PIC X(15) VALUE SPACES.        
           05   RS-MIDDLE-NAME           PIC X(15) VALUE SPACES.        
T36931     05   RS-LAST-NAME             PIC X(40) VALUE SPACES.        
T36931     05   RS-FULL-NAME             PIC X(70) VALUE SPACES.        
           05   RS-NAME-FORMAT           PIC X(01) VALUE SPACES.        
           05   RS-ADDRESS-ID            PIC X(13) VALUE SPACES.        
           05   RS-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.        
           05   RS-ADDRESS-TYPE          PIC X(01) VALUE SPACES.        
           05   RS-LL-PREMISE            PIC X(10) VALUE SPACES.        
           05   RS-LL-PREMISE-NUM        REDEFINES RS-LL-PREMISE        
                                         PIC 9(10).                     
           05   RS-LL-ACCOUNT            PIC X(13) VALUE SPACES.        
           05   RS-LL-ACCOUNT-NUM        REDEFINES RS-LL-ACCOUNT        
                                         PIC 9(13).                     
                                                                        
REARCH 01   GTT-RETURN-FIELDS.                                          
REARCH     05    S-RETURN-CODE           PIC S9(09) COMP VALUE 0.       
REARCH     05    S-CODE-RENTAL-PROP      PIC X(01) VALUE SPACES.        
REARCH     05    S-LL-CUSTOMER-NO        PIC X(10) VALUE SPACES.        
REARCH     05    S-LL-MASTER-ACCT-NO     PIC X(13) VALUE SPACES.        
REARCH     05    S-FIRST-NAME            PIC X(15) VALUE SPACES.        
REARCH     05    S-MIDDLE-NAME           PIC X(15) VALUE SPACES.        
T36931     05    S-LAST-NAME             PIC X(40) VALUE SPACES.        
T36931     05    S-FULL-NAME             PIC X(70) VALUE SPACES.        
REARCH     05    S-NAME-FORMAT           PIC X(01) VALUE SPACES.        
REARCH     05    S-ADDRESS-ID            PIC X(13) VALUE SPACES.        
REARCH     05    S-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.        
REARCH     05    S-ADDRESS-TYPE          PIC X(01) VALUE SPACES.        
REARCH     05    S-LL-PREMISE            PIC X(10) VALUE SPACES.        
REARCH     05    S-LL-PREMISE-NUM        REDEFINES S-LL-PREMISE         
REARCH                                   PIC 9(10).                     
REARCH     05    S-LL-ACCOUNT            PIC X(13) VALUE SPACES.        
REARCH     05    S-LL-ACCOUNT-NUM        REDEFINES S-LL-ACCOUNT         
REARCH                                   PIC 9(13).                     
REARCH*01   CN-COLUMN-NAMES.                                                    
REARCH*    05   CN-RETURN-CODE           PIC X(11)                              
REARCH*                                  VALUE 'RETURN_CODE'.                   
REARCH*    05   CN-CODE-RENTAL-PROP      PIC X(16)                              
REARCH*                                  VALUE 'CODE_RENTAL_PROP'.              
REARCH*    05   CN-LL-CUSTOMER-NO        PIC X(14)                              
REARCH*                                  VALUE 'LL_CUSTOMER_NO'.                
REARCH*    05   CN-LL-MASTER-ACCT-NO     PIC X(17)                              
REARCH*                                  VALUE 'LL_MASTER_ACCT_NO'.             
REARCH*    05   CN-FIRST-NAME            PIC X(10)                              
REARCH*                                  VALUE 'FIRST_NAME'.                    
REARCH*    05   CN-MIDDLE-NAME           PIC X(11)                              
REARCH*                                  VALUE 'MIDDLE_NAME'.                   
REARCH*    05   CN-LAST-NAME             PIC X(09)                              
REARCH*                                  VALUE 'LAST_NAME'.                     
REARCH*    05   CN-FULL-NAME             PIC X(09)                              
REARCH*                                  VALUE 'FULL_NAME'.                     
REARCH*    05   CN-NAME-FORMAT           PIC X(11)                              
REARCH*                                  VALUE 'NAME_FORMAT'.                   
REARCH*    05   CN-ADDRESS-ID            PIC X(10)                              
REARCH*                                  VALUE 'ADDRESS_ID'.                    
REARCH*    05   CN-ADDRESS-FORMAT        PIC X(14)                              
REARCH*                                  VALUE 'ADDRESS_FORMAT'.                
REARCH*    05   CN-LL-ACCOUNT            PIC X(10)                              
REARCH*                                  VALUE 'LL-ACCOUNT'.                    
REARCH*    05   CN-LL-PREMISE            PIC X(13)                              
REARCH*                                  VALUE 'LL-PREMISE'.                    
                                                                        
      * CODE-RENTAL-PROP-VALUES                                                 
       01  WS-CODES.                                                    
           05  WS-NON-RENTAL-PROP       PIC X(01) VALUE 'A'.            
           05  WS-NO-REVERT             PIC X(01) VALUE 'C'.            
           05  WS-AUTO-REVERT           PIC X(01) VALUE 'D'.            
T23618     05  WS-SEASONAL-REVERT       PIC X(01) VALUE 'S'.            
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-PREMISE-NO            PIC X(10).                         
REARCH*PROCEDURE DIVISION.                                                      
REARCH PROCEDURE DIVISION USING                                         
REARCH                    PARM-PREMISE-NO.                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *      CONTROLS THE MAIN PATH OF THE PROGRAM                     *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-INPUT   THRU 1000-EXIT.                 
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM THRU 9999-EXIT.                     
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR    CONTINUE END-EXEC.             
           EXEC SQL WHENEVER NOT FOUND   CONTINUE END-EXEC.             
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH              :S-RETURN-CODE              AS RETURN_CODE          
REARCH             ,LTRIM(RTRIM(:S-LL-CUSTOMER-NO))    AS LL_CUSTOMER_NO       
REARCH             ,LTRIM(RTRIM(:S-CODE-RENTAL-PROP))  AS 
           CODE_RENTAL_PROP     
REARCH             ,LTRIM(RTRIM(:S-LL-MASTER-ACCT-NO)) AS 
           LL_MASTER_ACCT_NO    
REARCH             ,LTRIM(RTRIM(:S-FIRST-NAME))        AS FIRST_NAME           
REARCH             ,LTRIM(RTRIM(:S-MIDDLE-NAME))       AS MIDDLE_NAME          
REARCH             ,LTRIM(RTRIM(:S-LAST-NAME))         AS LAST_NAME            
REARCH             ,LTRIM(RTRIM(:S-FULL-NAME))         AS FULL_NAME            
REARCH             ,LTRIM(RTRIM(:S-NAME-FORMAT))       AS NAME_FORMAT          
REARCH             ,LTRIM(RTRIM(:S-ADDRESS-ID))        AS ADDRESS_ID           
REARCH             ,LTRIM(RTRIM(:S-ADDRESS-FORMAT))    AS ADDRESS_FORMAT       
REARCH             ,LTRIM(RTRIM(:S-LL-PREMISE))        AS LL_PREMISE           
REARCH             ,LTRIM(RTRIM(:S-LL-ACCOUNT))        AS LL_ACCOUNT           
REARCH         FROM                                                     
REARCH              CIS.SYSDUMMY1                                    
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             :S-RETURN-CODE              AS RETURN_CODE                  
MFA-TR*            ,STRIP(:S-LL-CUSTOMER-NO)    AS LL_CUSTOMER_NO               
MFA-TR*            ,STRIP(:S-CODE-RENTAL-PROP)  AS CODE_RENTAL_PROP             
MFA-TR*            ,STRIP(:S-LL-MASTER-ACCT-NO) AS LL_MASTER_ACCT_NO            
MFA-TR*            ,STRIP(:S-FIRST-NAME)        AS FIRST_NAME                   
MFA-TR*            ,STRIP(:S-MIDDLE-NAME)       AS MIDDLE_NAME                  
MFA-TR*            ,STRIP(:S-LAST-NAME)         AS LAST_NAME                    
MFA-TR*            ,STRIP(:S-FULL-NAME)         AS FULL_NAME                    
MFA-TR*            ,STRIP(:S-NAME-FORMAT)       AS NAME_FORMAT                  
MFA-TR*            ,STRIP(:S-ADDRESS-ID)        AS ADDRESS_ID                   
MFA-TR*            ,STRIP(:S-ADDRESS-FORMAT)    AS ADDRESS_FORMAT               
MFA-TR*            ,STRIP(:S-LL-PREMISE)        AS LL_PREMISE                   
MFA-TR*            ,STRIP(:S-LL-ACCOUNT)        AS LL_ACCOUNT                   
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
REARCH*    CALL 'TDINIT'    USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.            
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME     TO ABEND-PROGRAM                            
REARCH*       MOVE '0100'           TO ACTIVE-PARAGRAPH                         
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'    TO TABLE-1                             
REARCH*       MOVE GWL-RC                TO WS-ACTIVE-RETURN-CODE               
REARCH*       PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT                   
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT                   
REARCH*    END-IF.                                                              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                              *       
      *                                                                 *       
      *      1. RECEIVE PARMS.                                          *       
      *                                                                 *       
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS      THRU 1100-EXIT.                      
                                                                        
           MOVE PARM-PREMISE-NO    TO WS-PREMISE-NO.                    
           MOVE WS-PREMISE-NO-RED  TO WS-PREMISE-NUM.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                              *       
      *                                                                 *       
      *      RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *       
      *                                                                 *       
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*    MOVE 1                             TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-PREMISE-NO     TO MAX-LENGTH-PARM,               
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-PREMISE-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                            *       
      *                                                                 *       
      *      1. DESCRIBE RESULT SET                                     *       
      *      2. UPDATE DB2 DATA                                         *       
      *      3. BUILD RESULT SET                                        *       
      *      4. SEND RESULT SET                                         *       
      *                                                                 *       
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                         
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                               *       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH       MOVE RS-RETURN-CODE       TO  S-RETURN-CODE.               
REARCH       MOVE RS-CODE-RENTAL-PROP  TO  S-CODE-RENTAL-PROP.          
REARCH       MOVE RS-LL-CUSTOMER-NO    TO  S-LL-CUSTOMER-NO.            
REARCH       MOVE RS-LL-MASTER-ACCT-NO TO  S-LL-MASTER-ACCT-NO.         
REARCH       MOVE RS-FIRST-NAME        TO  S-FIRST-NAME.                
REARCH       MOVE RS-MIDDLE-NAME       TO  S-MIDDLE-NAME.               
REARCH       MOVE RS-LAST-NAME         TO  S-LAST-NAME.                 
REARCH       MOVE RS-FULL-NAME         TO  S-FULL-NAME.                 
REARCH       MOVE RS-NAME-FORMAT       TO  S-NAME-FORMAT.               
REARCH       MOVE RS-ADDRESS-ID        TO  S-ADDRESS-ID.                
REARCH       MOVE RS-ADDRESS-FORMAT    TO  S-ADDRESS-FORMAT.            
REARCH       MOVE RS-ADDRESS-TYPE      TO  S-ADDRESS-TYPE.              
REARCH       MOVE RS-LL-PREMISE        TO  S-LL-PREMISE .               
REARCH       MOVE RS-LL-ACCOUNT        TO  S-LL-ACCOUNT.                
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                            *       
      *                                                                 *       
      *      DESCRIBE EACH COLUMN IN THE RESULT SET.                    *       
      *                                                                 *       
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE 1        TO CTR-COLUMN.                                         
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-LL-CUSTOMER-NO TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-LL-CUSTOMER-NO TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LL-CUSTOMER-NO,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-LL-CUSTOMER-NO,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-CODE-RENTAL-PROP TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-CODE-RENTAL-PROP TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CODE-RENTAL-PROP,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-CODE-RENTAL-PROP,                           
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*                                                                         
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*                                                                         
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-LL-MASTER-ACCT-NO TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CN-LL-MASTER-ACCT-NO TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LL-MASTER-ACCT-NO,                          
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-LL-MASTER-ACCT-NO,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*                                                                         
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-FIRST-NAME    TO WRKLEN1.                          
REARCH*    MOVE LENGTH OF CN-FIRST-NAME    TO WRKLEN2.                          
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-FIRST-NAME,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-FIRST-NAME,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-MIDDLE-NAME TO WRKLEN1.                            
REARCH*    MOVE LENGTH OF CN-MIDDLE-NAME TO WRKLEN2.                            
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-MIDDLE-NAME,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-MIDDLE-NAME,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-LAST-NAME TO WRKLEN1.                              
REARCH*    MOVE LENGTH OF CN-LAST-NAME TO WRKLEN2.                              
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LAST-NAME,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-LAST-NAME,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-FULL-NAME TO WRKLEN1.                              
REARCH*    MOVE LENGTH OF CN-FULL-NAME TO WRKLEN2.                              
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-FULL-NAME,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-FULL-NAME,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-NAME-FORMAT    TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-NAME-FORMAT    TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-NAME-FORMAT,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-NAME-FORMAT,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ADDRESS-ID     TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-ADDRESS-ID     TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDRESS-ID,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-ADDRESS-ID,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-ADDRESS-FORMAT TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-ADDRESS-FORMAT TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ADDRESS-FORMAT,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-ADDRESS-FORMAT,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-LL-PREMISE TO WRKLEN1.                             
REARCH*    MOVE LENGTH OF CN-LL-PREMISE TO WRKLEN2.                             
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LL-PREMISE,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-LL-PREMISE,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-LL-ACCOUNT TO WRKLEN1.                             
REARCH*    MOVE LENGTH OF CN-LL-ACCOUNT TO WRKLEN2.                             
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-LL-ACCOUNT,                                 
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-LL-ACCOUNT,                                 
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
REARCH*                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                               *       
      *   NB - RESULT IS A SINGLE ROW                                   *       
      *   1. FIND LANDLORD CUSTOMER NO FOR PREMISE                      *       
      *   2. IF THERE IS A LANDLORD, FIND ITS CUSTOMER DATA             *       
      *   3. IF THERE IS A LANDLORD, FIND ITS ADDRESS                   *       
      *   4. SEND RESULT                                                *       
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7100-FETCH-PREM THRU 7100-EXIT.                      
           PERFORM 2500-POPULATE-PREM THRU 2500-EXIT.                   
                                                                        
           IF PR-CODE-RENTAL-PROP = WS-NO-REVERT OR WS-AUTO-REVERT      
T23618                              OR WS-SEASONAL-REVERT               
              PERFORM 7300-FETCH-LANDLORD THRU 7300-EXIT                
              PERFORM 2550-POPULATE-LANDLORD THRU 2550-EXIT             
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7400-FETCH-CUST THRU 7400-EXIT                 
                 PERFORM 2600-POPULATE-CUST THRU 2600-EXIT              
                                                                        
              END-IF                                                    
           ELSE                                                         
              MOVE 100     TO  RS-RETURN-CODE                           
           END-IF.                                                      
REARCH     ADD 1 TO CTR-ROWS.                                           
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
REARCH*    PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                             
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-POPULATE-PREM                                              *       
      ******************************************************************        
                                                                        
       2500-POPULATE-PREM.                                              
                                                                        
           MOVE PR-CODE-RENTAL-PROP TO RS-CODE-RENTAL-PROP.             
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-POPULATE-LANDLORD                                          *       
      ******************************************************************        
                                                                        
       2550-POPULATE-LANDLORD.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
           MOVE SI-CUSTOMER-NO TO RS-LL-CUSTOMER-NO.                    
           MOVE SI-LL-MASTER-ACCT-NO TO WS-LL-MASTER-ACCT-RED.          
           MOVE WS-LL-MASTER-ACCT-NO TO RS-LL-MASTER-ACCT-NO.           
           MOVE SI-ADDRESS-ID        TO WS-ADDRESS-ID.                  
           MOVE WS-ADDRESS-ID-S      TO RS-ADDRESS-ID.                  
           MOVE SI-ADDRESS-FORMAT    TO RS-ADDRESS-FORMAT.              
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-POPULATE-CUST                                             *        
      ******************************************************************        
                                                                        
       2600-POPULATE-CUST.                                              
                                                                        
           MOVE DQ-FIRST-NAME TO RS-FIRST-NAME.                         
           MOVE DQ-MIDDLE-NAME TO RS-MIDDLE-NAME.                       
           MOVE DQ-LAST-NAME TO RS-LAST-NAME.                           
           MOVE DQ-FULL-NAME TO RS-FULL-NAME.                           
           MOVE DQ-NAME-FORMAT TO RS-NAME-FORMAT.                       
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-FETCH-PREM                                               *         
      ****************************************************************          
                                                                        
       7100-FETCH-PREM.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT CODE_RENTAL_PROP                                  
               INTO   :PR-CODE-RENTAL-PROP                              
               FROM   CSS_PREMISE                                       
               WHERE  PREMISE_NO = :WS-PREMISE-NUM                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_PREMSIE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE WS-PREMISE-NUM       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7300-FETCH-LANDLORD                                           *         
      ****************************************************************          
                                                                        
       7300-FETCH-LANDLORD.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      LL_MASTER_ACCT_NO,                                
                      ADDRESS_ID,                                       
                      ADDRESS_FORMAT                                    
               INTO   :SI-CUSTOMER-NO,                                  
                      :SI-LL-MASTER-ACCT-NO,                            
                      :SI-ADDRESS-ID,                                   
                      :SI-ADDRESS-FORMAT                                
               FROM   CSS_LANDLORD                                      
               WHERE  PREMISE_NO = :WS-PREMISE-NUM                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE WS-PREMISE-NUM       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7400-FETCH-CUST                                              *          
      ****************************************************************          
                                                                        
       7400-FETCH-CUST.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT N.FIRST_NAME                                      
                    , N.MIDDLE_NAME                                     
                    , N.LAST_NAME                                       
                    , N.FULL_NAME                                       
                    , N.NAME_FORMAT                                     
            INTO    :DQ-FIRST-NAME                                      
              , :DQ-MIDDLE-NAME                                         
              , :DQ-LAST-NAME                                           
              , :DQ-FULL-NAME                                           
              , :DQ-NAME-FORMAT                                         
               FROM    CSS_NAME N, CSS_CUSTOMER C                       
               WHERE   C.CUSTOMER_NO = :SI-CUSTOMER-NO                  
                  AND C.NAME_ID = N.NAME_ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUSTOMER'       TO TABLE-1                      
              MOVE 'CSS_NAME'           TO TABLE-2                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE SI-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
REARCH*       EXEC SQL                                                          
REARCH*          INCLUDE CPD00300                                               
REARCH*       END-EXEC.                                                         
                                                                        
REARCH        EXEC SQL                                                          
REARCH           INCLUDE CPDSP300                                               
REARCH        END-EXEC.                                                         
      ****************************************************************          
      *        END PROGRAM COPYLIB                                              
      ****************************************************************          
REARCH*COPY CPD00302.                                                           
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00321                                                
REARCH     END-EXEC.                                                            
