000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.    CSR02080.                                         
COB303 DATE-WRITTEN.      APRIL 17, 1995.                               
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************00060000
000700*                                                                *00070000
000800*                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
000900*                                                                *00090000
001000*  TH S PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
001100*                                                                *00110000
001200*  TRANID:     S080                                              *00120000
001300*  PROGRAM:    S080                                              *00130000
001400*  CALLING SP: PA_S080                                           *00140000
001500*                                                                *00150000
001600******************************************************************00160000
001700*                 P R O G R A M  S U M M A R Y                   *00170000
001800*                                                                *00180000
001900*  THIS PROCEDURE UPDATES METER AND THE REGISTER READ DATA.      *00190000
002000*  THIS INFORMATION EXISTS TO SUPPORT THE MANAGEMENT OF THE      *00200000
002100*  REGISTER INFORMATION.                                         *00210000
002200******************************************************************00220000
002300*                                                                *00230000
002400*                     PROGRAM MODIFICATION LOG                   *00240000
002500*                                                                *00250000
002600*    DATE    INITIALS   COMMENTS                                 *00260000
002700*  --------  --------   ---------------------------------------  *00270000
002800*  05/01/95    MAR      PROCEDURE ORIGINALLY CODED.              *00280000
002810*  09/05/95    PD       ADDED METER READ INSTRUCTION 1 2 AND 3   *00290000
002820*                       FOR UPDATE.                              *00300000
002830*  09/13/95    PD       CHANGED TRAN HISTORY TO WRITE ONLY ACCT  *00310000
002840*                       NUMBER.                                  *00320000
002850*  09/14/95    PD       PREVENT S080 FROM OVERWRITTING METER RD  *00330000
002860*                       INSTRUCTION 1 2 AND 3 FROM PANEL 464     *00340000
002870*  10/09/95    ECC      ADDED REGISTER READ SEQ TO PARM LIST     *00350000
002880*                                                                *00360000
002881*  06/10/96    MR       CHANGED 2220-.. AND 2230-.. TO READ      *00370000
002882*                       CODE-LAST-VALID-RD AND UPDATE TABLE.     *00380000
002883*                       TPR FIX # 4380                           *00390000
002884*                                                                *00400000
002885*  06/18/96    MR       UPDATED TRANS_HIST WITH MI-TABLE-ID FOR  *00410000
002886*                       FIELDS CD-LAST-REG-RD, CD-CRNT-REG-RD,   *00420000
002887*                       CODE-LAST-VALID-RD                       *00430000
002888*                                                                *00440000
TP5004*  07/25/96    JTH      TPR 5004 - CHANGE LAST READ TIME AND     *00450000
TP5004*                       LAST VALID READ TIME TO 00:00:00 FROM    *00460000
TP5004*                       12:00 AM.                                *00470000
002888*                                                                *00480000
T4755 *  11/06/96  CSG        CHANGE DEFINITION OF POINT-ID WORKING    *00490000
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *00500000
T9469 *  2/25/97   RPG        ADDED TO MODULE 2230 - TABLE ID INFO FOR *00510000
T9469 *                       CODE-REG-STATUS.                         *00520000
14661 *  2/09/98   MAO        CORRECTED (NOT FOUND) -1 ERROR ON TOU    *00530000
14661 *                       MULTIPLE REG UPDATE CONDITION            *00540000
T16866* 06/22/98   TDK        CORRECTED READ TIME JOURNALING ERROR.    *00550000
T17072* 07/10/98   TDK        CORRECTED REG_READ_SEQ JOURNALLING ERROR.*00560000
CBSI  * 07/30/98   CBSI       ABEND LOG MODIFIED TO INCLUDE ALL THE    *00570000
CBSI  *            MADRAS     ABEND PARAMETERS                         *00580000
T18805* 02/05/99   RGB        CODE CHANGED TO DELETE REMOVED METER FROM*00590000
T18805*                       ACCOUNT WITHOUT ANY ERRORS               *00600000
C27236* 09/19/02   SR82046    CHANGED TO INCLUDE INDUST BTU ID TO      *00610000
C27236*                       UPDATE CSS_MTRD_ENVRNMT TABLE.           *00620000
C27236* 01/03/03   SR82046    CHANGED TO HANDLE ASRA WHEN DELETING.    *00630000
C27236* 01/14/03   SR82046    CHANGED TO HANDLE LARGE VALUES FOR MAX   *00640000
C27236*                       AND MIN UNITS FIELDS ON THE PANEL.       *00650000
C24056* 03/05/03   DPS        ADDED GIS POINT ID UPDATE                *00660000
C30989* 04/04/05   JS83520    ADDED METER PRESSURE TO UPDATE FOR AMR   *00670000
C30989*                       READONE LINK CIS PROJECT                 *00680000
C30989* 06/22/05   SG18894    CHANGES MADE TO HANDLE BILL MESSAGE FOR  *00690000
C30989*                       P COMP FACTOR                            *00700000
REARCH* 09/06/05   CVNS       RPC TO COBOL SP CONVERSION.              *00710000
REARCH*            CHENNAI                                             *00720000
C34345* 06/22/06   AW41078    REMOVE 8050 PARAGRAPH TO GET RID OF ALL  *00730000
C34345*                       CODE REFERENCING CSS_SVC_DELVRY_PT TABLE *00740000
C36313* 12/20/07   PC97415    UPDATE CURRENT DATE TO METER INACTIVE    *00750000
C36313*                       AND METER REMOVED DATE FOR METER STATUS  *00760000
C36313*                       CHANGE                                   *00770000
C34590* 06/13/08   VV90387    CLEAR OUT THE METER REMOVED/INACTIVE DATES00780000
C34590*                       IF METER STATUS CHANGED TO ACTIVE.       *00790000
C37571* 08/14/08   VIJAY  1.  IN CASE OF NOT-FOUND IN SNE_POINT, MOVE   00800000
C37571*                       SPACES TO WS-OLD-TAG AND WSOLD-GIS-LO    *00810000
C37571*                   2.  CSS_MODEL_SQL REPLACED BY SET .           00820000
C37571*                   3.  ADDED WITH UR FOR SELECT STATEMENTS.      00830000
C37571*                   4.  DELETED ALL COMMENTED LINES FOR EASY      00840000
C37571*                       READABILITY.                              00850000
C37571*                   5.  DISPLAY METER AND REGISTER DETAILS IN     00860000
C37571*                       TRANS COMMENTS.                           00870000
C33743* 05/14/08   SC41135    POINT-ID PROJECT. REPLACE SNE_POINT TABLE*00880000
C33743*                       CSS_PIM_POINT TABLE.                     *00890000
P00178* 08/02/09   AW41078    CORRECT ISSUE WITH METER TAMPER FLAGS    *00900000
P00178*                       GETTING OVERWRITTEN WITH SPACES DURING   *00910000
P00178*                       METERDETAILS PANEL266 UPDATE.            *00920000
A00839* 27/05/10   SP94986    UPDATE GIS-POINT-ID IN CSS_ACCT_WHT_CROSS*00921000
A00839*            -ACT003    FOR SELECTED ACCOUNTS WHEN POINT_ID IS   *00922000
A00839*                       CHANGED IN PANEL 266.                    *00923000
P00251*  10/29/10   AW41078   CHECK FOR MASTER/DEPEND METER            *00924000
P00251*                       RELATIONSHIP BEFORE DELETE.  RETURN MSG  *00925000
P00251*                       IF RELATIONSHIP EXISTS AND DON'T DELETE  *00926000
P00251*                       METER.                                   *00927000
002900******************************************************************00930000
003000*                                                                *00940000
003100*                ---- BASIC SEQUENCE STRUCTURE ----              *00950000
003200*                                                                *00960000
003300*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00970000
003400*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00980000
003500*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00990000
003600*  3000 - 4999  NOT USED                                         *01000000
003700*  5000 - 5999  COMMON PROGRAM MODULES                           *01010000
003800*  6000 - 6999  COMMON SYSTEM MODULES                            *01020000
003900*  7000 - 7999  INPUT MODULES                                    *01030000
004000*  8000 - 8999  OUTPUT MODULES                                   *01040000
004100*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01050000
004200*                                                                *01060000
004300******************************************************************01070000
004400                                                                  
004500 ENVIRONMENT DIVISION.                                            
004600 DATA DIVISION.                                                   
004700 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02080'.
MSQ017     COPY MFASQLM.
004800                                                                  
004900 01  WS-START                          PIC X(40) VALUE            
REARCH     'WORKING STORAGE FOR CSR02080 STARTS HERE'.                  
005100                                                                  
005200******************************************************************01160000
005300*    DB2 INCLUDES                                                *01170000
005400******************************************************************01180000
005500*                                                                 01190000
005600     EXEC SQL                                                     01200000
005700        INCLUDE SQLCA                                             01210000
005800     END-EXEC.                                                    01220000
005900*                                                                 01230000
006000     EXEC SQL                                                     01240000
006100        INCLUDE TBMODEL                                           01250000
006200     END-EXEC.                                                    01260000
006300*                                                                 01270000
006400     EXEC SQL                                                     01280000
006500        INCLUDE TBACCT                                            01290000
006600     END-EXEC.                                                    01300000
006700*                                                                 01310000
006800     EXEC SQL                                                     01320000
006900        INCLUDE TBMTRENV                                          01330000
007000     END-EXEC.                                                    01340000
007100*                                                                 01350000
007200     EXEC SQL                                                     01360000
007300        INCLUDE TBRGREAD                                          01370000
007400     END-EXEC.                                                    01380000
007500*                                                                 01390000
007600     EXEC SQL                                                     01400000
007700        INCLUDE TBMNHDT                                           01410000
007800     END-EXEC.                                                    01420000
007900*                                                                 01430000
008000     EXEC SQL                                                     01440000
008100        INCLUDE TBMNHIST                                          01450000
008200     END-EXEC.                                                    01460000
008300*                                                                 01470000
008400     EXEC SQL                                                     01480000
008500        INCLUDE TBUSRPRF                                          01490000
008600     END-EXEC.                                                    01500000
P00251*                                                                 01501001
P00251**** CSS_UTL_BILL_REL ****                                        01502001
P00251     EXEC SQL                                                     01503001
P00251        INCLUDE TBUTLREL                                          01504001
P00251     END-EXEC.                                                    01505001
P00251*                                                                 01510001
A00839************************************************************      01510100
A00839**   CSS_ACCT_WHT_CROSS - WH                                      01510200
A00839************************************************************      01510300
A00839     EXEC SQL                                                     01511000
A00839        INCLUDE TBWCACCT                                          01512000
A00839     END-EXEC.                                                    01513000
                                                                        
C33743* CSS_PIM_POINT TABLE                                             01520000
C33743     EXEC SQL                                                     01530000
C33743        INCLUDE TBPIMPNT                                          01540000
C33743     END-EXEC.                                                    01550000
C33743*                                                                 01560000
C30989****************************************************************  01570000
C30989*   DCLGEN COPYBOOK FOR CSS_SPCL_BILL_MSG                      *  01580000
C30989****************************************************************  01590000
C30989     EXEC SQL                                                     01600000
C30989         INCLUDE TBSBLMSG                                         01610000
C30989     END-EXEC.                                                    01620000
008700*                                                                 01630000
008800*                                                                 01640000
008900******************************************************************01650000
009000*    COBOL WORKING STORAGE COPY BOOKS                            *01660000
009100******************************************************************01670000
009200                                                                  
009500     COPY CCA00001.                                               01690000
REARCH     EXEC SQL                                                     01700000
REARCH        INCLUDE CWSX0010                                          01710000
REARCH     END-EXEC.                                                    01720000
009700     COPY CWS00027.                                               01730000
009800     COPY CWS00303.                                               01740000
009900                                                                  
010000******************************************************************01760000
010100*    WORK AREAS                                                  *01770000
010200******************************************************************01780000
010300                                                                  
011600                                                                  
015800*                                                                 01810000
015900                                                                  
016000 01  SNA-FIELDS.                                                  
016100     05  SNA-SUBC                   PIC S9(9) COMP.               
016200     05  SNA-CONNECTION-NAME        PIC X(8)  VALUE SPACES.       
016300                                                                  
016400 01  COUNTER-FIELDS.                                              
016500     05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.       
016600     05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
016700                                                                  
016800 01  WORK-FIELDS.                                                 
016900     05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
017000     05  WRKLEN1                    PIC S9(9) COMP.               
017100     05  WRKLEN2                    PIC S9(9) COMP.               
017200     05  WRK-DONE-STATUS            PIC S9(9) COMP.               
017300                                                                  
017400                                                                  
017500 01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
017600*                                                                 01990000
017700 01  TDS-RETURN-FIELDS.                                           
017800     05  RS-LAST-UPDATE-TS          PIC X(26).                    
017900     05  RS-RETURN-CODE             PIC S9(09) COMP VALUE 0.      
018000     05  RS-RETURN-MESSAGE          PIC X(50).                    
018100*                                                                 02040000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-LAST-UPDATE-TS          PIC X(26).                    
REARCH     05   S-RETURN-CODE             PIC S9(09) COMP VALUE 0.      
REARCH     05   S-RETURN-MESSAGE          PIC X(50).                    
018900*                                                                 02090000
019000 01  SWITCHES.                                                    
019100     05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
019200         88 NOT-ALL-DONE                      VALUE 'N'.          
019300         88 ALL-DONE                          VALUE 'Y'.          
019400     05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
019500         88 SEND-DONE-ERROR                   VALUE 'N'.          
019600         88 SEND-DONE-OK                      VALUE 'Y'.          
019700     05  REGISTER-SW                PIC X(01) VALUE ' '.          
019800         88 NO-REGISTER-DETAILS               VALUE ' '.          
019900         88 REGISTER-DETAILS                  VALUE 'A'.          
020000     05  METER-UPDATE-SW            PIC X(01) VALUE ' '.          
020100         88 METER-UPDATE                      VALUE 'Y'.          
020200     05  REGISTER-UPDATE-SW         PIC X(01) VALUE ' '.          
020300         88 REGISTER-UPDATE                   VALUE 'Y'.          
                                                                        
020400*                                                                 02240000
020500*                                                                 02250000
020600 01  WS-PROGRAM-NAME.                                             
REARCH     05  PROGRAM-NAME               PIC X(08) VALUE 'CSR02080'.   
020800*                                                                 02280000
020900 01  STORAGE-FIELDS.                                              
021000     05  MISC-STORAGE-FIELDS.                                     
000000         10 WS-UNPACK-ALPHA-NUM.                                  
000000            15 WS-UNPACK-NUMBER     PIC 9(9).                     
021300         10 WS-UNPACK-ALPHA-NUM4.                                 
021400            15 WS-UNPACK-NUMBER4    PIC 9(04).                    
021500         10 WS-UNPACK-VALUES.                                     
021600            15 WS-UNPACK-VALUES-N   PIC 9(12)V9(3).               
021700         10 WS-ACCOUNT-NO.                                        
021800            11 WS-ACCOUNT-NO-N      PIC S9(13)V.                  
COB305         10 WS-ACCOUNT-NO-COMP        PIC S9(13)V COMP-3 VALUE 0.         
022000         10 WS-CUSTOMER-NO.                                       
022100            11 WS-CUSTOMER-NO-N     PIC S9(10)V.                  
022200         10 WS-PREMISE-NO.                                        
022300            11 WS-PREMISE-NO-N      PIC S9(10)V.                  
022400         10 MULTIPLE-ROWS-CALL      PIC S9(9) VALUE -811 COMP.    
022500         10 WS-ENTITY-KEY-DESC.                                   
022600            15 FILLER               PIC X(12)                     
022700                                    VALUE 'METER NO  - '.         
022800            15 WS-EKS-METER-NO      PIC X(13).                    
022900            15 FILLER               PIC X(15)                     
023000                                    VALUE 'REGISTER NO -  '.      
023100            15 WS-EKS-REG-ID-NO     PIC 9(4).                     
C37571         10 WS-METER-LEN            PIC 9(4) VALUE 25.            
C37571         10 WS-REGISTER-LEN         PIC 9(4) VALUE 44.            
C24056         10 WS-OLD-GIS-LO           PIC X(3).                     
C24056         10 WS-NEW-GIS-LO           PIC X(3).                     
C24056         10 WS-OLD-TAG              PIC X(7).                     
C24056         10 WS-NEW-TAG              PIC X(7).                     
A00839         10 WS-WHT-CROSS-CHECK      PIC X(1) VALUE ' '.           
A00839         10 WS-WHT-CROSS-UPDATE     PIC X(1) VALUE ' '.           
A00839         10 WS-GIS-POINT-ID-OLD     PIC S9(9) USAGE COMP.         
023400     05  PARM-STORAGE-FIELDS.                                     
023500         10 WS-L                    PIC S9(9) COMP.               
023600         10 WS-ID1                  PIC S9(9) COMP VALUE 0.       
023700         10 WS-UPDATE-TYPE          PIC X(1).                     
023800         10 WS-LAST-UPDATE-TS       PIC X(26)      VALUE SPACES.  
023900         10 WS-USER-ID              PIC X(08)      VALUE SPACES.  
024000         10 WS-PANEL-ID             PIC X(08)      VALUE SPACES.  
024100         10 WS-CODE-UTIL-TYPE       PIC X(1)       VALUE SPACES.  
024200         10 WS-CODE-MTR-RD-INST1    PIC X(2)       VALUE SPACES.  
024300         10 WS-CODE-MTR-RD-INST2    PIC X(2)       VALUE SPACES.  
024400         10 WS-CODE-MTR-RD-INST3    PIC X(2)       VALUE SPACES.  
024500         10 WS-COMMENT-LEN          PIC S9(4) COMP VALUE 0.       
024600     05  WS-METER-DETAILS.                                        
024700         10 WS-METER-NO             PIC X(9).                     
024800         10 WS-MTR-REF-NO           PIC S9(4) COMP.               
024900         10 WS-DATE-MTR-INSTALL     PIC X(10).                    
C24056*        10 WS-POINT-ID             PIC X(10).                    02740000
025100         10 WS-METER-SUPPLYING      PIC X(15).                    
025200         10 WS-CODE-METER-LOC       PIC X(2).                     
025300         10 WS-NO-CONSEC-ESTIMATE   PIC S9(4) COMP VALUE 0.       
025400         10 WS-NO-CONSEC-CRD-READ   PIC S9(4) COMP VALUE 0.       
025500         10 WS-MTR-READ-SOURCE-CD   PIC X(1).                     
025600         10 WS-HEXAGRAM-LOCATION    PIC X(2).                     
025700         10 WS-SEAL-CODE-ID         PIC X(1).                     
025800         10 WS-INSULATED-IND        PIC X(1).                     
025900         10 WS-LOCK-TYPE-ID         PIC X(1).                     
026000         10 WS-IDR-RECIPIENT-CD     PIC X(1).                     
026100         10 WS-DELIVERY-LEVEL-CD    PIC X(1).                     
026200         10 WS-UTILITY-SOURCE-CD    PIC X(1).                     
               10 WS-REMOTE-READ-IND      PIC X(1).                     
C27236         10 WS-INDUST-BTU-ID        PIC X(03).                    
C27236         10 WS-MAX-NO-UNITS         PIC S9(9)V USAGE COMP-3       
C27236                                               VALUE ZEROS.       
C27236         10 WS-MIN-NO-UNITS         PIC S9(9)V USAGE COMP-3       
C27236                                               VALUE ZEROS.       
C24056         10 WS-GIS-POINT-ID         PIC S9(9)  USAGE COMP         
C24056                                               VALUE ZEROS.       
C30989         10 WS-METER-PRESSURE       PIC X(03).                    
C30989         10 WS-METER-PRESSURE-NO  REDEFINES WS-METER-PRESSURE.    
C30989            15 WS-METER-PRESSURE-NUM PIC 9(03).                   
C30989         10 WS-MN-METER-PRESSURE    PIC 9(03).                    
P00545         10 WS-GIS-MISMATCH-FL      PIC X(1).                     
C24056                                                                  
026300     05  WS-REGISTER-DETAILS.                                     
026400         10 WS-REG-ID-NO            PIC S9(4) COMP VALUE 0.       
026500         10 WS-CODE-TIME-PERIOD     PIC S9(4) COMP.               
026600         10 WS-CODE-REG-STATUS      PIC X(1).                     
026700         10 WS-CODE-STATUS-REAS     PIC X(1).                     
026800         10 WS-LAST-READ-VALUE      PIC S9(12)V999 COMP-3 VALUE 0.
026900         10 WS-LAST-REG-READ-DT     PIC X(10).                    
027000         10 WS-LAST-REG-READ-TM     PIC X(8).                     
027100         10 WS-CODE-LAST-REG-READ   PIC X(1).                     
027200         10 WS-LAST-VAL-RD-VALUE    PIC S9(12)V999 COMP-3 VALUE 0.
027300         10 WS-LAST-VALID-READ-DT   PIC X(10).                    
027400         10 WS-LAST-VALID-READ-TM   PIC X(8).                     
027500         10 WS-CODE-LAST-VALID-RD   PIC X(1).                     
027600         10 WS-CODE-CRNT-REG-READ   PIC X(1).                     
027700         10 WS-CODE-NO-RD-REASON    PIC X(1).                     
027800         10 WS-REGISTER-RD-SEQ      PIC 9(09) COMP.               
027900*                                                                 03160000
028000 01  WS-MNT-TRANS-HIST.                                           
028100     05  WS-USERID                  PIC X(08) VALUE SPACES.       
028200     05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
028300     05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
028400     05  WS-ACCOUNT-EXISTS          PIC X(01) VALUE 'N'.          
028500     05  WS-PANEL-NO                PIC X(09) VALUE '        '.   
028600     05  WS-COMMENT                 PIC X(210).                   
028700     05  WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.       
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.     
029000*                                                                 03270000
029100 01  WS-MNT-TRANS-DET.                                            
029200     05  WS-CODE-TRAN-TYPE          PIC X(01) VALUE 'F'.          
029300     05  WS-TRAN-APPL-NO            PIC S9(02) VALUE 0.           
029400     05  WS-COLUMN-DESC             PIC X(15).                    
029500     05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30).                    
029600     05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02).                   
029700     05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30).                    
029800     05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02).                   
029900 77  WS-STATUS-CHNG-DT-N            PIC S9(04) COMP VALUE 0.      
030000 77  WS-DATE-MTR-INSTALL-N          PIC S9(04) COMP VALUE 0.      
030100 77  WS-LAST-VALID-READ-DT-N        PIC S9(04) COMP VALUE 0.      
C36313 77  WS-METER-REMOVED-DT-N          PIC S9(04) COMP VALUE 0.      
C36313 77  WS-METER-INACTIVE-DT-N         PIC S9(04) COMP VALUE 0.      
C36313 77  WS-MTR-STATUS-CHNG-DT-N        PIC S9(04) COMP VALUE 0.      
030200*                                                                 03420000
P00251 01  FLAGS.                                                       
P00251     05  WS-MSTDEP-REL-EXISTS-FL    PIC X(01) VALUE 'N'.          
P00251         88 MSTDEP-REL-EXISTS                 VALUE 'Y'.          
P00251*                                                                 03424000
HPCCDM*EJECT                                                            03430000
030400*                                                                 03440000
030500*                                                                 03450000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-UPDATE-TYPE            PIC X(1).                        
REARCH 01  PARM-LAST-UPDATE-TS         PIC X(26).                       
REARCH 01  PARM-USER-ID                PIC X(08).                       
REARCH 01  PARM-PANEL-ID               PIC X(08).                       
REARCH 01  PARM-ACCOUNT-NO             PIC X(13).                       
REARCH 01  PARM-CUSTOMER-NO            PIC X(10).                       
REARCH 01  PARM-PREMISE-NO             PIC X(10).                       
REARCH 01  PARM-CODE-UTIL-TYPE         PIC X(1).                        
REARCH 01  PARM-METER-NO               PIC X(9).                        
REARCH 01  PARM-CODE-MTR-RD-INST1      PIC X(2).                        
REARCH 01  PARM-CODE-MTR-RD-INST2      PIC X(2).                        
REARCH 01  PARM-CODE-MTR-RD-INST3      PIC X(2).                        
REARCH 01  PARM-REG-ID-NO              PIC S9(4) COMP.                  
REARCH 01  PARM-COMMENT                PIC X(210).                      
REARCH 01  PARM-COMMENT-LEN            PIC S9(4) COMP.                  
REARCH 01  PARM-MTR-REF-NO             PIC S9(4) COMP.                  
REARCH 01  PARM-DATE-MTR-INSTALL       PIC X(10).                       
REARCH 01  PARM-POINT-ID               PIC X(10).                       
REARCH 01  PARM-METER-SUPPLYING        PIC X(15).                       
REARCH 01  PARM-CODE-METER-LOC         PIC X(2).                        
REARCH 01  PARM-NO-CONSEC-ESTIMATE     PIC S9(4) COMP.                  
REARCH 01  PARM-NO-CONSEC-CRD-READ     PIC S9(4) COMP.                  
REARCH 01  PARM-MTR-READ-SOURCE-CD     PIC X(1).                        
REARCH 01  PARM-HEXAGRAM-LOCATION      PIC X(2).                        
REARCH 01  PARM-SEAL-CODE-ID           PIC X(1).                        
REARCH 01  PARM-INSULATED-IND          PIC X(1).                        
REARCH 01  PARM-LOCK-TYPE-ID           PIC X(1).                        
REARCH 01  PARM-IDR-RECIPIENT-CD       PIC X(1).                        
REARCH 01  PARM-DELIVERY-LEVEL-CD      PIC X(1).                        
REARCH 01  PARM-UTILITY-SOURCE-CD      PIC X(1).                        
REARCH 01  PARM-REMOTE-READ-IND        PIC X(1).                        
REARCH 01  PARM-INDUST-BTU-ID          PIC X(03).                       
COB305 01 PARM-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
COB305 01 PARM-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
COB305 01 PARM-GIS-POINT-ID        PIC S9(9) COMP-3 VALUE 0.                
REARCH 01  PARM-CODE-TIME-PERIOD       PIC S9(4) COMP.                  
REARCH 01  PARM-CODE-REG-STATUS        PIC X(1).                        
REARCH 01  PARM-CODE-STATUS-REAS       PIC X(1).                        
REARCH 01  PARM-LAST-READ-VALUE        PIC S9(9) COMP.                  
REARCH 01  PARM-LAST-REG-READ-DT       PIC X(10).                       
REARCH 01  PARM-LAST-REG-READ-TM       PIC X(8).                        
REARCH 01  PARM-CODE-LAST-REG-READ     PIC X(1).                        
REARCH 01  PARM-LAST-VAL-RD-VALUE      PIC S9(9) COMP.                  
REARCH 01  PARM-LAST-VALID-READ-DT     PIC X(10).                       
REARCH 01  PARM-LAST-VALID-READ-TM     PIC X(8).                        
REARCH 01  PARM-CODE-LAST-VALID-RD     PIC X(1).                        
REARCH 01  PARM-CODE-CRNT-REG-READ     PIC X(1).                        
REARCH 01  PARM-CODE-NO-RD-REASON      PIC X(1).                        
REARCH 01  PARM-REGISTER-RD-SEQ        PIC 9(09) COMP.                  
REARCH 01  PARM-METER-PRESSURE         PIC X(03).                       
P00545 01  PARM-GIS-MISMATCH-FL        PIC X(01).                       
030600 PROCEDURE DIVISION USING PARM-UPDATE-TYPE                        
REARCH                          PARM-LAST-UPDATE-TS                     
REARCH                          PARM-USER-ID                            
REARCH                          PARM-PANEL-ID                           
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-CUSTOMER-NO                        
REARCH                          PARM-PREMISE-NO                         
REARCH                          PARM-CODE-UTIL-TYPE                     
REARCH                          PARM-METER-NO                           
REARCH                          PARM-CODE-MTR-RD-INST1                  
REARCH                          PARM-CODE-MTR-RD-INST2                  
REARCH                          PARM-CODE-MTR-RD-INST3                  
REARCH                          PARM-REG-ID-NO                          
REARCH                          PARM-COMMENT                            
REARCH                          PARM-COMMENT-LEN                        
REARCH                          PARM-MTR-REF-NO                         
REARCH                          PARM-DATE-MTR-INSTALL                   
REARCH                          PARM-POINT-ID                           
REARCH                          PARM-METER-SUPPLYING                    
REARCH                          PARM-CODE-METER-LOC                     
REARCH                          PARM-NO-CONSEC-ESTIMATE                 
REARCH                          PARM-NO-CONSEC-CRD-READ                 
REARCH                          PARM-MTR-READ-SOURCE-CD                 
REARCH                          PARM-HEXAGRAM-LOCATION                  
REARCH                          PARM-SEAL-CODE-ID                       
REARCH                          PARM-INSULATED-IND                      
REARCH                          PARM-LOCK-TYPE-ID                       
REARCH                          PARM-IDR-RECIPIENT-CD                   
REARCH                          PARM-DELIVERY-LEVEL-CD                  
REARCH                          PARM-UTILITY-SOURCE-CD                  
REARCH                          PARM-REMOTE-READ-IND                    
REARCH                          PARM-INDUST-BTU-ID                      
REARCH                          PARM-MAX-NO-UNITS                       
REARCH                          PARM-MIN-NO-UNITS                       
REARCH                          PARM-GIS-POINT-ID                       
REARCH                          PARM-CODE-TIME-PERIOD                   
REARCH                          PARM-CODE-REG-STATUS                    
REARCH                          PARM-CODE-STATUS-REAS                   
REARCH                          PARM-LAST-READ-VALUE                    
REARCH                          PARM-LAST-REG-READ-DT                   
REARCH                          PARM-LAST-REG-READ-TM                   
REARCH                          PARM-CODE-LAST-REG-READ                 
REARCH                          PARM-LAST-VAL-RD-VALUE                  
REARCH                          PARM-LAST-VALID-READ-DT                 
REARCH                          PARM-LAST-VALID-READ-TM                 
REARCH                          PARM-CODE-LAST-VALID-RD                 
REARCH                          PARM-CODE-CRNT-REG-READ                 
REARCH                          PARM-CODE-NO-RD-REASON                  
REARCH                          PARM-REGISTER-RD-SEQ                    
REARCH                          PARM-METER-PRESSURE                     
P00545                          PARM-GIS-MISMATCH-FL.                   
REARCH*                                                                 04470000
030800*                                                                 04480000
030900******************************************************************04490000
031000* 0000-MAINLINE                                                  *04500000
031100*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04510000
031200******************************************************************04520000
031300                                                                  
031400 0000-MAINLINE.                                                   
031500                                                                  
031600     PERFORM 0100-INITIALIZE        THRU 0100-EXIT.               
031700     PERFORM 1000-PROCESS-INPUT     THRU 1000-EXIT.               
031800     PERFORM 2000-PROCESS-OUTPUT    THRU 2000-EXIT.               
REARCH     PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT.              
REARCH     ADD +1                         TO   CTR-ROWS.                
032000     PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
032100                                                                  
032200 0000-EXIT.                                                       
032300     EXIT.                                                        
032400                                                                  
032500******************************************************************04660000
032600* 0100-INITIALIZE                                                *04670000
032700*                                                                *04680000
032800*     1. RESET DB2 ERROR HANDLERS                                *04690000
032900*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04700000
033000*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04710000
033100*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04720000
033200*                                                                *04730000
033300******************************************************************04740000
033400                                                                  
033500 0100-INITIALIZE.                                                 
033600*                                                                 04770000
033700     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
033800     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
033900     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
034000                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             LTRIM(RTRIM(:S-LAST-UPDATE-TS))   AS  TIME_STAMP            
REARCH            ,:S-RETURN-CODE             AS  RETURN_CODE           
REARCH            ,LTRIM(RTRIM(:S-RETURN-MESSAGE))   AS  RETURN_MESSAGE        
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04820000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        04830000
MFA-TR*        SELECT                                                   04840000
MFA-TR*            STRIP(:S-LAST-UPDATE-TS)   AS  TIME_STAMP            04850000
MFA-TR*           ,:S-RETURN-CODE             AS  RETURN_CODE           04860000
MFA-TR*           ,STRIP(:S-RETURN-MESSAGE)   AS  RETURN_MESSAGE        04870000
MFA-TR*        FROM                                                     04880000
MFA-TR*            SYSIBM.SYSDUMMY1                                     04890000
MFA-TR*    END-EXEC.                                                    04900000
035900 0100-EXIT.                                                       
036000     EXIT.                                                        
036100                                                                  
036200******************************************************************04940000
036300* 1000-PROCESS-INPUT                                             *04950000
036400*                                                                *04960000
036500*     1. RECEIVE PARMS.                                          *04970000
036600*     2. ASSIGN PARMS TO WORKING STORAGE                         *04980000
036700*     3. RETRIEVE MISC. FIELDS                                   *04990000
036800*     4. CHECK FOR CORRECT REGISTER DATA                         *05000000
036900*                                                                *05010000
037000******************************************************************05020000
037100                                                                  
037200 1000-PROCESS-INPUT.                                              
037300                                                                  
037500     PERFORM 1150-ASSIGN-WS-VARS     THRU 1150-EXIT.              
037600     PERFORM 1200-CHECK-MTR-REG-DATA THRU 1200-EXIT.              
037700                                                                  
037800 1000-EXIT.                                                       
037900     EXIT.                                                        
038000                                                                  
038100******************************************************************05120000
038200* 1100-RECEIVE-PARMS                                             *05130000
038300*                                                                *05140000
038400*     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *05150000
038500*                                                                *05160000
038600******************************************************************05170000
083500*                                                                 05180000
083600*                                                                 05190000
083700******************************************************************05200000
083800* 1150 ASSIGN-WS-VARS  (KEY FIELDS)                              *05210000
083900*     1. THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05220000
084000*        MOVES THEM INTO WORKING STORAGE VARIABLES.              *05230000
084100*     2. IF NOT AN UPDATE PROCESS NO OTHER DATA NEED PROCESSING. *05240000
084200*        IF UPDATE MOVE REGISTER DATA.                           *05250000
084300******************************************************************05260000
084400 1150-ASSIGN-WS-VARS.                                             
084500*                                                                 05280000
084600     MOVE PARM-UPDATE-TYPE         TO WS-UPDATE-TYPE.             
084700     MOVE PARM-LAST-UPDATE-TS      TO WS-LAST-UPDATE-TS.          
084800     MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO.              
084900     MOVE WS-ACCOUNT-NO-N          TO WS-ACCOUNT-NO-COMP.         
085000     MOVE PARM-CUSTOMER-NO         TO WS-CUSTOMER-NO.             
085100     MOVE WS-CUSTOMER-NO-N         TO WS-CUSTOMER-NO-COMP.        
085200     MOVE PARM-PREMISE-NO          TO WS-PREMISE-NO.              
085300     MOVE WS-PREMISE-NO-N          TO WS-PREMISE-NO-COMP.         
085400     MOVE PARM-CODE-UTIL-TYPE      TO WS-CODE-UTIL-TYPE.          
085500     MOVE PARM-METER-NO            TO WS-METER-NO.                
085600     MOVE PARM-CODE-MTR-RD-INST1   TO WS-CODE-MTR-RD-INST1.       
085610     MOVE PARM-CODE-MTR-RD-INST2   TO WS-CODE-MTR-RD-INST2.       
085620     MOVE PARM-CODE-MTR-RD-INST3   TO WS-CODE-MTR-RD-INST3.       
085630     MOVE PARM-USER-ID             TO WS-USER-ID                  
085640                                      WS-USERID.                  
085650     MOVE PARM-PANEL-ID            TO WS-PANEL-ID                 
085660                                      WS-PANEL-NO.                
085670     MOVE PARM-CODE-UTIL-TYPE      TO WS-CODE-UTIL-TYPE.          
085680     MOVE PARM-COMMENT             TO WS-COMMENT.                 
085690     MOVE PARM-COMMENT-LEN         TO WS-COMMENT-LEN.             
085700     MOVE PARM-MTR-REF-NO          TO WS-MTR-REF-NO.              
085800     MOVE PARM-REG-ID-NO           TO WS-REG-ID-NO.               
085900                                                                  
086000     IF WS-UPDATE-TYPE = 'U'                                      
086100        IF WS-PANEL-ID = 'PANEL266'                               
086200           PERFORM 1155-ASSIGN-METER           THRU 1155-EXIT     
086300        ELSE                                                      
086400           IF WS-PANEL-ID = 'PANEL464'                            
086500              PERFORM 1157-ASSIGN-REGISTER     THRU 1157-EXIT     
086600           END-IF                                                 
086700        END-IF                                                    
086800     END-IF.                                                      
086900*                                                                 05610000
087000 1150-EXIT.                                                       
087100     EXIT.                                                        
087200*                                                                 05640000
087300*                                                                 05650000
087400******************************************************************05660000
087500* 1155 ASSIGN-METER.                                             *05670000
087600*     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05680000
087700*        MOVES THEM INTO WORKING STORAGE VARIABLES.              *05690000
087800******************************************************************05700000
087900 1155-ASSIGN-METER.                                               
088000                                                                  
088100                                                                  
088200     MOVE PARM-DATE-MTR-INSTALL    TO WS-DATE-MTR-INSTALL.        
C24056* UNUSED FIELD                                                    05750000
088400     MOVE PARM-METER-SUPPLYING     TO WS-METER-SUPPLYING.         
088500     MOVE PARM-CODE-METER-LOC      TO WS-CODE-METER-LOC.          
088600     MOVE PARM-NO-CONSEC-ESTIMATE  TO WS-NO-CONSEC-ESTIMATE.      
088700     MOVE PARM-NO-CONSEC-CRD-READ  TO WS-NO-CONSEC-CRD-READ.      
088800     MOVE PARM-MTR-READ-SOURCE-CD  TO WS-MTR-READ-SOURCE-CD.      
088900     MOVE PARM-HEXAGRAM-LOCATION   TO WS-HEXAGRAM-LOCATION.       
089000     MOVE PARM-SEAL-CODE-ID        TO WS-SEAL-CODE-ID.            
089100     MOVE PARM-INSULATED-IND       TO WS-INSULATED-IND.           
089200     MOVE PARM-LOCK-TYPE-ID        TO WS-LOCK-TYPE-ID.            
089300     MOVE PARM-IDR-RECIPIENT-CD    TO WS-IDR-RECIPIENT-CD.        
089400     MOVE PARM-DELIVERY-LEVEL-CD   TO WS-DELIVERY-LEVEL-CD.       
089500     MOVE PARM-UTILITY-SOURCE-CD   TO WS-UTILITY-SOURCE-CD.       
           MOVE PARM-REMOTE-READ-IND     TO WS-REMOTE-READ-IND.         
C27236     MOVE PARM-INDUST-BTU-ID       TO WS-INDUST-BTU-ID.           
C27236     MOVE PARM-MAX-NO-UNITS        TO WS-MAX-NO-UNITS.            
C27236     MOVE PARM-MIN-NO-UNITS        TO WS-MIN-NO-UNITS.            
C24056     MOVE PARM-GIS-POINT-ID        TO WS-GIS-POINT-ID.            
C30989     MOVE PARM-METER-PRESSURE      TO WS-METER-PRESSURE.          
C30989     INSPECT WS-METER-PRESSURE                                    
C30989             REPLACING LEADING SPACES BY ZEROES.                  
P00545     MOVE PARM-GIS-MISMATCH-FL     TO WS-GIS-MISMATCH-FL.         
089600*                                                                 05960000
089700 1155-EXIT.                                                       
089800     EXIT.                                                        
089900*                                                                 05990000
090000*                                                                 06000000
090100******************************************************************06010000
090200* 1157 ASSIGN-REGISTER.                                         * 06020000
090300*     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *06030000
090400*        MOVES THEM INTO WORKING STORAGE VARIABLES.              *06040000
090500******************************************************************06050000
090600 1157-ASSIGN-REGISTER.                                            
090700     MOVE PARM-CODE-TIME-PERIOD    TO WS-CODE-TIME-PERIOD.        
090800     MOVE PARM-CODE-REG-STATUS     TO WS-CODE-REG-STATUS.         
090900     MOVE PARM-CODE-STATUS-REAS    TO WS-CODE-STATUS-REAS.        
091000     COMPUTE WS-LAST-READ-VALUE =                                 
091100                             PARM-LAST-READ-VALUE / 1000.         
091200     MOVE PARM-LAST-REG-READ-DT    TO WS-LAST-REG-READ-DT.        
091300     MOVE PARM-LAST-REG-READ-TM    TO WS-LAST-REG-READ-TM.        
TP5004     IF WS-LAST-REG-READ-TM = '12:00 AM'                          
TP5004         MOVE '00:00:00'   TO WS-LAST-REG-READ-TM                 
TP5004     END-IF.                                                      
091400     MOVE PARM-CODE-LAST-REG-READ  TO WS-CODE-LAST-REG-READ.      
091500     COMPUTE WS-LAST-VAL-RD-VALUE =                               
091600                      PARM-LAST-VAL-RD-VALUE / 1000.              
091700     MOVE PARM-LAST-VALID-READ-DT  TO WS-LAST-VALID-READ-DT.      
091800     MOVE PARM-LAST-VALID-READ-TM  TO WS-LAST-VALID-READ-TM.      
TP5004     IF WS-LAST-VALID-READ-TM = '12:00 AM'                        
TP5004         MOVE '00:00:00'   TO WS-LAST-VALID-READ-TM               
TP5004     END-IF.                                                      
091900     MOVE PARM-CODE-LAST-VALID-RD  TO WS-CODE-LAST-VALID-RD.      
092000     MOVE PARM-CODE-CRNT-REG-READ  TO WS-CODE-CRNT-REG-READ.      
092100     MOVE PARM-CODE-NO-RD-REASON   TO WS-CODE-NO-RD-REASON.       
092200     MOVE PARM-REGISTER-RD-SEQ     TO WS-REGISTER-RD-SEQ.         
092300*                                                                 06290000
092400 1157-EXIT.                                                       
092500     EXIT.                                                        
092600*                                                                 06320000
092700*                                                                 06330000
092800******************************************************************06340000
092900* 1200-CHECK-MTR-REG-DATA.                                       *06350000
093000*     CHECK TO FOR PROPER DATA RETRIEVAL FOR UPDATE OR DELETE    *06360000
093100*        AND METER VERSUS REGISTER.                              *06370000
093200*                                                                *06380000
093300******************************************************************06390000
093400 1200-CHECK-MTR-REG-DATA.                                         
093500*                                                                 06410000
093600     PERFORM 7000-GET-CURRENT-DATE    THRU 7000-EXIT              
T14661     PERFORM 7100-GET-METER           THRU 7100-EXIT              
T14661     IF WS-ACTIVE-RETURN-CODE= NOT-FOUND                          
T14661        PERFORM 7200-GET-REGISTER     THRU 7200-EXIT              
T18805        MOVE  0                       TO MN-IC-NO                 
T14661        MOVE 'A'                      TO REGISTER-SW              
T14661     END-IF.                                                      
094700 1200-EXIT.                                                       
094800     EXIT.                                                        
094900*                                                                 06510000
095000*                                                                 06520000
095100******************************************************************06530000
095200* 2000-PROCESS-OUTPUT.                                           *06540000
095300*                                                                *06550000
095400*     1. DESCRIBE RESULT SET                                     *06560000
095500*     2. IF UPDATE  -  UPDATE CHANGED FIELDS                     *06570000
095600*     3. IF DELETE - DETERMINE IF METER OF REGISTER DATA AND     *06580000
095700*            DELETE DATA                                         *06590000
095800*                                                                *06600000
095900******************************************************************06610000
096000*                                                                 06620000
096100 2000-PROCESS-OUTPUT.                                             
096200*                                                                 06640000
096300     MOVE '0'                      TO RS-RETURN-MESSAGE           
096500     IF WS-UPDATE-TYPE = 'U'                                      
096600        PERFORM 2200-UPDATE-DATA             THRU 2200-EXIT       
096700     ELSE                                                         
096800        IF WS-UPDATE-TYPE = 'D'                                   
096900           PERFORM 2100-DELETE-DATA          THRU 2100-EXIT       
097000        END-IF                                                    
097100     END-IF.                                                      
097200                                                                  
097300*                                                                 06740000
097400 2000-EXIT.                                                       
097500     EXIT.                                                        
REARCH******************************************************************06770000
REARCH*2000A-MOVE-RESULT.                                               06780000
REARCH******************************************************************06790000
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-LAST-UPDATE-TS      TO S-LAST-UPDATE-TS.             
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-RETURN-MESSAGE      TO S-RETURN-MESSAGE.             
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                 06860000
097800******************************************************************06870000
097900* 2100-DELETE-DATA.                                              *06880000
098000*      --THIS MODULE DETERMINES WHICH FILE WILL BE USED FOR THE  *06890000
098100*        DELETE DEPENDING ON PANEL NUMBER AND REGISTER DETAILS.  *06900000
098200******************************************************************06910000
098300 2100-DELETE-DATA.                                                
098400     PERFORM 7010-ACCEPT-TIMESTAMP            THRU 7010-EXIT.     
098500                                                                  
P00251     MOVE WS-ACCOUNT-NO-COMP TO UR-ACCOUNT-NO-MST                 
P00251                                UR-ACCOUNT-NO-DEP.                
P00251     MOVE WS-CODE-UTIL-TYPE  TO UR-CODE-UTIL-TYPE-MST             
P00251                                UR-CODE-UTIL-TYPE-DEP.            
P00251     MOVE MN-IC-NO           TO UR-IC-NO-MST                      
P00251                                UR-IC-NO-DEP.                     
P00251     MOVE WS-MTR-REF-NO      TO UR-MTR-REF-NO-MST                 
P00251                                UR-MTR-REF-NO-DEP.                
098600     IF WS-PANEL-ID = 'PANEL266'                                  
P00251        PERFORM 7500-CHECK-DEP-UTL-BILL-REL   THRU 7500-EXIT      
P00251        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00251           PERFORM 7510-CHECK-MST-UTL-BILL-REL THRU 7510-EXIT     
P00251        END-IF                                                    
P00251        IF MSTDEP-REL-EXISTS                                      
P00251           MOVE 5904                      TO RS-RETURN-CODE       
P00251           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
P00251           ADD +1                         TO   CTR-ROWS           
P00251           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
P00251        END-IF                                                    
098700        PERFORM 2210-CHANGE-METER-DATA        THRU 2210-EXIT      
T18805        PERFORM 8040-DELETE-IRRGLR-MTR-RD     THRU 8040-EXIT      
T18805        PERFORM 8060-DELETE-REG-RD            THRU 8060-EXIT      
P00251**      PERFORM 8070-DELMST-UTL-BILL-REL      THRU 8070-EXIT      06990000
P00251**      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      07000000
P00251**         PERFORM 8080-DELDEP-UTL-BILL-REL   THRU 8080-EXIT      07010000
P00251**      END-IF                                                    07020000
098800        PERFORM 8020-DELETE-MTRD-ENV          THRU 8020-EXIT      
098900     ELSE                                                         
099000        IF REGISTER-DETAILS                                       
099100           PERFORM 2230-CHANGE-REG-READ-DATA  THRU 2230-EXIT      
099200           PERFORM 8030-DELETE-REG-READ       THRU 8030-EXIT      
099300           PERFORM 7300-CHECK-DATA-PRESENT    THRU 7300-EXIT      
099400           IF WS-ACTIVE-RETURN-CODE          = NOT-FOUND          
099500              MOVE SPACE                TO MN-CODE-DATA-PRESENT   
099600              MOVE WS-CURRENT-TIMESTAMP TO MN-LAST-UPDATE-TS      
099700              PERFORM 8005-UPDATE-DATA-PRSNT  THRU 8005-EXIT      
099800           END-IF                                                 
099900        ELSE                                                      
P00251        PERFORM 7500-CHECK-DEP-UTL-BILL-REL   THRU 7500-EXIT      
P00251        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00251           PERFORM 7510-CHECK-MST-UTL-BILL-REL THRU 7510-EXIT     
P00251        END-IF                                                    
P00251        IF MSTDEP-REL-EXISTS                                      
P00251           MOVE 5904                      TO RS-RETURN-CODE       
P00251           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
P00251           ADD +1                         TO   CTR-ROWS           
P00251           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
P00251        END-IF                                                    
100000           PERFORM 2220-CHANGE-REGISTER-DATA  THRU 2220-EXIT      
T18805           PERFORM 8040-DELETE-IRRGLR-MTR-RD  THRU 8040-EXIT      
T18805           PERFORM 8060-DELETE-REG-RD         THRU 8060-EXIT      
P00251*          PERFORM 8070-DELMST-UTL-BILL-REL   THRU 8070-EXIT      07180000
P00251*          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   07190000
P00251*             PERFORM 8080-DELDEP-UTL-BILL-REL   THRU 8080-EXIT   07200000
P00251*          END-IF                                                 07210000
100100           PERFORM 8020-DELETE-MTRD-ENV       THRU 8020-EXIT      
100200        END-IF                                                    
100300     END-IF.                                                      
100400     MOVE WS-CURRENT-TIMESTAMP          TO RS-LAST-UPDATE-TS.     
100500*                                                                 07260000
100600 2100-EXIT.                                                       
100700     EXIT.                                                        
100800*                                                                 07290000
100900*                                                                 07300000
101000******************************************************************07310000
101100* 2200-UPDATE-DATA.                                              *07320000
101200*                                                                *07330000
101300*     -- THIS MODULES CONTROLS THE FIELD UPDATES AND TABLE       *07340000
101400*        UPDATING PROCESS.                                       *07350000
101500*                                                                *07360000
101600******************************************************************07370000
101700 2200-UPDATE-DATA.                                                
101800*                                                                 07390000
101900     PERFORM 7010-ACCEPT-TIMESTAMP            THRU 7010-EXIT.     
102000     MOVE WS-CURRENT-TIMESTAMP          TO RS-LAST-UPDATE-TS.     
102100                                                                  
102200     IF WS-PANEL-ID = 'PANEL266'                                  
P00178        MOVE MN-CODE-MTR-RD-INST2 TO WS-CODE-MTR-RD-INST2         
P00178        MOVE MN-CODE-MTR-RD-INST3 TO WS-CODE-MTR-RD-INST3         
102300        PERFORM 2210-CHANGE-METER-DATA        THRU 2210-EXIT      
102400     END-IF.                                                      
102500                                                                  
102600     IF WS-PANEL-ID = 'PANEL464'                                  
102700        MOVE MN-CODE-MTR-RD-INST1 TO WS-CODE-MTR-RD-INST1         
102800        MOVE MN-CODE-MTR-RD-INST2 TO WS-CODE-MTR-RD-INST2         
102900        MOVE MN-CODE-MTR-RD-INST3 TO WS-CODE-MTR-RD-INST3         
103000        IF REGISTER-DETAILS                                       
103100           PERFORM 2230-CHANGE-REG-READ-DATA  THRU 2230-EXIT      
103200        ELSE                                                      
103300           PERFORM 2220-CHANGE-REGISTER-DATA  THRU 2220-EXIT      
103400        END-IF                                                    
103500     END-IF.                                                      
103600                                                                  
103700     IF METER-UPDATE                                              
103800        PERFORM 8000-UPDATE-MTRD-ENV          THRU 8000-EXIT      
A00839*                                                                 07601100
A00839        IF WS-WHT-CROSS-CHECK = 'Y'                               
A00839           MOVE WS-ACCOUNT-NO-COMP      TO WH-ACCOUNT-NO          
A00839           MOVE WS-GIS-POINT-ID-OLD     TO WH-GIS-POINT-ID        
A00839           PERFORM 7400-SELECT-ACCT-WHT-CROSS    THRU 7400-EXIT   
A00839           IF WS-WHT-CROSS-UPDATE = 'Y'                           
A00839              MOVE MN-GIS-POINT-ID      TO WH-GIS-POINT-ID        
A00839              PERFORM 8100-UPDATE-ACCT-WHT-CROSS THRU 8100-EXIT   
A00839           END-IF                                                 
A00839        END-IF                                                    
A00839*                                                                 07607000
103900     END-IF.                                                      
104000     IF REGISTER-UPDATE                                           
104100        PERFORM 8010-UPDATE-REG-READ          THRU 8010-EXIT      
104200     END-IF.                                                      
104300     MOVE WS-CURRENT-TIMESTAMP          TO RS-LAST-UPDATE-TS.     
P00462*                                                                 07670100
104500 2200-EXIT.                                                       
104600     EXIT.                                                        
104700*                                                                 07700000
104800*                                                                 07710000
104900******************************************************************07720000
105000* 2210-CHANGE-METER-DATA.                                        *07730000
105100*                                                                *07740000
105200*     -- THIS MODULE CHECK EACH FIELD TO DETERMINE IF IT HAS     *07750000
105300*        CHANGED AND PROCESS ALL JOURNALING.                     *07760000
105400*                                                                *07770000
105500******************************************************************07780000
105600 2210-CHANGE-METER-DATA.                                          
105700*                                                                 07800000
105800     PERFORM 7030-GET-RESP-AREA-ID            THRU 7030-EXIT.     
105900*                                                                 07820000
106000     MOVE WS-CURRENT-TIMESTAMP      TO  MN-LAST-UPDATE-TS.        
106100*                                                                 07840000
106200     IF WS-DATE-MTR-INSTALL NOT = MN-DATE-MTR-INSTALL             
106300        ADD  +1                     TO  WS-TRAN-APPL-NO           
106400        MOVE 'INSTALL DATE'         TO  WS-COLUMN-DESC            
106500        MOVE MN-DATE-MTR-INSTALL    TO  WS-PRV-COLUMN-VALUE-TEXT  
106600        MOVE 10                     TO  WS-PRV-COLUMN-VALUE-LEN   
106700        MOVE WS-DATE-MTR-INSTALL    TO  WS-CHG-COLUMN-VALUE-TEXT  
106800                                        MN-DATE-MTR-INSTALL       
106900        MOVE 10                     TO  WS-CHG-COLUMN-VALUE-LEN   
107000        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
107100        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
107200        SET METER-UPDATE            TO TRUE                       
107300     END-IF                                                       
107400*                                                                 07970000
C24056     IF WS-GIS-POINT-ID     NOT = MN-GIS-POINT-ID                 
A00839        MOVE MN-GIS-POINT-ID        TO WS-GIS-POINT-ID-OLD        
A00839        MOVE 'Y'                    TO WS-WHT-CROSS-CHECK         
C24056        PERFORM 7110-GET-OLD-GIS-TAG THRU 7110-EXIT               
C24056        PERFORM 7120-GET-NEW-GIS-TAG THRU 7120-EXIT               
C24056        ADD +1                      TO WS-TRAN-APPL-NO            
C24056        MOVE 'GIS LOC OFF'          TO  WS-COLUMN-DESC            
C24056        MOVE WS-OLD-GIS-LO          TO  WS-PRV-COLUMN-VALUE-TEXT  
C24056        MOVE 3                      TO  WS-PRV-COLUMN-VALUE-LEN   
C24056        MOVE WS-NEW-GIS-LO          TO  WS-CHG-COLUMN-VALUE-TEXT  
C24056        MOVE 3                      TO  WS-CHG-COLUMN-VALUE-LEN   
C24056        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C24056        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C24056        ADD +1                      TO WS-TRAN-APPL-NO            
C24056        MOVE 'TAG NO'               TO  WS-COLUMN-DESC            
C24056        MOVE WS-OLD-TAG             TO  WS-PRV-COLUMN-VALUE-TEXT  
C24056        MOVE 7                      TO  WS-PRV-COLUMN-VALUE-LEN   
C24056        MOVE WS-NEW-TAG             TO  WS-CHG-COLUMN-VALUE-TEXT  
C24056        MOVE 7                      TO  WS-CHG-COLUMN-VALUE-LEN   
C24056        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C24056        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C24056        ADD +1                      TO  WS-TRAN-APPL-NO           
C24056        MOVE MN-GIS-POINT-ID        TO  WS-UNPACK-NUMBER          
C24056        MOVE 'GIS POINT ID'         TO  WS-COLUMN-DESC            
C24056        MOVE WS-UNPACK-ALPHA-NUM    TO  WS-PRV-COLUMN-VALUE-TEXT  
C24056        MOVE 9                      TO  WS-PRV-COLUMN-VALUE-LEN   
C24056        MOVE WS-GIS-POINT-ID        TO  WS-UNPACK-NUMBER          
C24056        MOVE WS-UNPACK-ALPHA-NUM    TO  WS-CHG-COLUMN-VALUE-TEXT  
C24056        MOVE 9                      TO  WS-CHG-COLUMN-VALUE-LEN   
C24056        MOVE WS-GIS-POINT-ID        TO  MN-GIS-POINT-ID           
C24056        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C24056        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C24056        SET METER-UPDATE            TO TRUE                       
C24056     END-IF                                                       
108900*                                                                 08300000
109000     IF WS-METER-SUPPLYING  NOT = MN-METER-SUPPLYING              
109100        ADD  +1                     TO  WS-TRAN-APPL-NO           
109200        MOVE '25'                   TO  MI-TABLE-ID               
109300        MOVE 'METER SUPPLYING'      TO  WS-COLUMN-DESC            
109400        MOVE MN-METER-SUPPLYING     TO  WS-PRV-COLUMN-VALUE-TEXT  
109500        MOVE 15                     TO  WS-PRV-COLUMN-VALUE-LEN   
109600        MOVE WS-METER-SUPPLYING     TO  WS-CHG-COLUMN-VALUE-TEXT  
109700                                        MN-METER-SUPPLYING        
109800        MOVE 15                     TO  WS-CHG-COLUMN-VALUE-LEN   
109900        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
110000        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
110100        MOVE SPACES                 TO  MI-TABLE-ID               
110200        SET METER-UPDATE            TO TRUE                       
110300     END-IF                                                       
110400*                                                                 08450000
110500     IF WS-CODE-METER-LOC   NOT = MN-CODE-METER-LOC               
110600        ADD +1                      TO  WS-TRAN-APPL-NO           
110700        MOVE 'Q4'                   TO  MI-TABLE-ID               
110800        MOVE 'CODE-METER-LOC'       TO  WS-COLUMN-DESC            
110900        MOVE MN-CODE-METER-LOC      TO  WS-PRV-COLUMN-VALUE-TEXT  
111000        MOVE 2                      TO  WS-PRV-COLUMN-VALUE-LEN   
111100        MOVE WS-CODE-METER-LOC      TO  WS-CHG-COLUMN-VALUE-TEXT  
111200                                        MN-CODE-METER-LOC         
111300        MOVE 2                      TO  WS-CHG-COLUMN-VALUE-LEN   
111400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
111500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
111600        MOVE SPACES                 TO  MI-TABLE-ID               
111700        SET METER-UPDATE            TO TRUE                       
111800     END-IF                                                       
111900*                                                                 08600000
112000     IF WS-NO-CONSEC-ESTIMATE NOT = MN-NO-CONSEC-ESTIMATE         
112100        ADD +1                      TO  WS-TRAN-APPL-NO           
112200        MOVE 'NO-CONSEC-EST.'       TO  WS-COLUMN-DESC            
112300        MOVE MN-NO-CONSEC-ESTIMATE  TO  WS-UNPACK-NUMBER4         
112400        MOVE WS-UNPACK-ALPHA-NUM4   TO  WS-PRV-COLUMN-VALUE-TEXT  
112500        MOVE 4                      TO  WS-PRV-COLUMN-VALUE-LEN   
112600        MOVE WS-NO-CONSEC-ESTIMATE  TO  WS-UNPACK-NUMBER4         
112700        MOVE WS-UNPACK-ALPHA-NUM4   TO  WS-CHG-COLUMN-VALUE-TEXT  
112800        MOVE WS-NO-CONSEC-ESTIMATE  TO  MN-NO-CONSEC-ESTIMATE     
112900        MOVE 4                      TO  WS-CHG-COLUMN-VALUE-LEN   
113000        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
113100        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
113200        SET METER-UPDATE            TO TRUE                       
113300     END-IF                                                       
113400*                                                                 08750000
113500     IF WS-NO-CONSEC-CRD-READ NOT = MN-NO-CONSEC-CRD-READ         
113600        ADD +1                      TO  WS-TRAN-APPL-NO           
113700        MOVE 'NO-CONSEC-CRD.'       TO  WS-COLUMN-DESC            
113800        MOVE MN-NO-CONSEC-CRD-READ  TO  WS-UNPACK-NUMBER4         
113900        MOVE WS-UNPACK-ALPHA-NUM4   TO  WS-PRV-COLUMN-VALUE-TEXT  
114000        MOVE 4                      TO  WS-PRV-COLUMN-VALUE-LEN   
114100        MOVE WS-NO-CONSEC-CRD-READ  TO  WS-UNPACK-NUMBER4         
114200        MOVE WS-UNPACK-ALPHA-NUM4   TO  WS-CHG-COLUMN-VALUE-TEXT  
114300        MOVE WS-NO-CONSEC-CRD-READ  TO  MN-NO-CONSEC-CRD-READ     
114400        MOVE 4                      TO  WS-CHG-COLUMN-VALUE-LEN   
114500        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
114600        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
114700        SET METER-UPDATE            TO TRUE                       
114800     END-IF                                                       
114900*                                                                 08900000
115000     IF WS-MTR-READ-SOURCE-CD NOT = MN-MTR-READ-SOURCE-CD         
115100        ADD +1                      TO  WS-TRAN-APPL-NO           
115200        MOVE '24'                   TO  MI-TABLE-ID               
115300        MOVE 'MTR-READ-SOURCE'      TO  WS-COLUMN-DESC            
115400        MOVE MN-MTR-READ-SOURCE-CD  TO  WS-PRV-COLUMN-VALUE-TEXT  
115500        MOVE 4                      TO  WS-PRV-COLUMN-VALUE-LEN   
115600        MOVE WS-MTR-READ-SOURCE-CD  TO  WS-CHG-COLUMN-VALUE-TEXT  
115700                                        MN-MTR-READ-SOURCE-CD     
115800        MOVE 4                      TO  WS-CHG-COLUMN-VALUE-LEN   
115900        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
116000        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
116100        MOVE SPACES                 TO  MI-TABLE-ID               
116200        SET METER-UPDATE            TO TRUE                       
116300     END-IF                                                       
116400*                                                                 09050000
116500     IF WS-HEXAGRAM-LOCATION  NOT = MN-HEXAGRAM-LOCATION          
116600        ADD +1                      TO  WS-TRAN-APPL-NO           
116700        MOVE 'Q4'                   TO  MI-TABLE-ID               
116800        MOVE 'HEXAGRAM-LOC   '      TO  WS-COLUMN-DESC            
116900        MOVE MN-HEXAGRAM-LOCATION   TO  WS-PRV-COLUMN-VALUE-TEXT  
117000        MOVE 2                      TO  WS-PRV-COLUMN-VALUE-LEN   
117100        MOVE WS-HEXAGRAM-LOCATION   TO  WS-CHG-COLUMN-VALUE-TEXT  
117200                                        MN-HEXAGRAM-LOCATION      
117300        MOVE 2                      TO  WS-CHG-COLUMN-VALUE-LEN   
117400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
117500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
117600        MOVE SPACES                 TO  MI-TABLE-ID               
117700        SET METER-UPDATE            TO TRUE                       
117800     END-IF                                                       
117900*                                                                 09200000
118000     IF WS-SEAL-CODE-ID       NOT = MN-SEAL-CODE-ID               
118100        ADD +1                      TO  WS-TRAN-APPL-NO           
118200        MOVE 'B4'                   TO  MI-TABLE-ID               
118300        MOVE 'SEAL-CODE-ID   '      TO  WS-COLUMN-DESC            
118400        MOVE MN-SEAL-CODE-ID        TO  WS-PRV-COLUMN-VALUE-TEXT  
118500        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
118600        MOVE WS-SEAL-CODE-ID        TO  WS-CHG-COLUMN-VALUE-TEXT  
118700                                        MN-SEAL-CODE-ID           
118800        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
118900        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
119000        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
119100        MOVE SPACES                 TO  MI-TABLE-ID               
119200        SET METER-UPDATE            TO TRUE                       
119300     END-IF                                                       
119400*                                                                 09350000
119500     IF WS-INSULATED-IND      NOT = MN-INSULATED-IND              
119600        ADD +1                      TO  WS-TRAN-APPL-NO           
119700        MOVE 'INSULATED-IND  '      TO  WS-COLUMN-DESC            
119800        MOVE MN-INSULATED-IND       TO  WS-PRV-COLUMN-VALUE-TEXT  
119900        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
120000        MOVE WS-INSULATED-IND       TO  WS-CHG-COLUMN-VALUE-TEXT  
120100                                        MN-INSULATED-IND          
120200        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
120300        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
120400        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
120500        SET METER-UPDATE            TO TRUE                       
120600     END-IF                                                       
120700*                                                                 09480000
120800     IF WS-LOCK-TYPE-ID       NOT = MN-LOCK-TYPE-ID               
120900        ADD +1                      TO  WS-TRAN-APPL-NO           
121000        MOVE 'B3'                   TO  MI-TABLE-ID               
121100        MOVE 'LOCK-TYPE-ID   '      TO  WS-COLUMN-DESC            
121200        MOVE MN-LOCK-TYPE-ID        TO  WS-PRV-COLUMN-VALUE-TEXT  
121300        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
121400        MOVE WS-LOCK-TYPE-ID        TO  WS-CHG-COLUMN-VALUE-TEXT  
121500                                        MN-LOCK-TYPE-ID           
121600        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
121700        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
121800        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
121900        MOVE SPACES                 TO  MI-TABLE-ID               
122000        SET METER-UPDATE            TO TRUE                       
122100     END-IF                                                       
122200*                                                                 09630000
122300     IF WS-IDR-RECIPIENT-CD   NOT = MN-IDR-RECIPIENT-CD           
122400        ADD +1                      TO  WS-TRAN-APPL-NO           
122500        MOVE '26'                   TO  MI-TABLE-ID               
122600        MOVE 'IDR-RECIP-CD   '      TO  WS-COLUMN-DESC            
122700        MOVE MN-IDR-RECIPIENT-CD    TO  WS-PRV-COLUMN-VALUE-TEXT  
122800        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
122900        MOVE WS-IDR-RECIPIENT-CD    TO  WS-CHG-COLUMN-VALUE-TEXT  
123000                                        MN-IDR-RECIPIENT-CD       
123100        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
123200        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
123300        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
123400        MOVE SPACES                 TO  MI-TABLE-ID               
123500        SET METER-UPDATE            TO TRUE                       
123600     END-IF                                                       
123700*                                                                 09780000
123800     IF WS-DELIVERY-LEVEL-CD  NOT = MN-DELIVERY-LEVEL-CD          
123900        ADD +1                      TO  WS-TRAN-APPL-NO           
124000        MOVE 'R2'                   TO  MI-TABLE-ID               
124100        MOVE 'DELIVERY LEVEL '      TO  WS-COLUMN-DESC            
124200        MOVE MN-DELIVERY-LEVEL-CD   TO  WS-PRV-COLUMN-VALUE-TEXT  
124300        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
124400        MOVE WS-DELIVERY-LEVEL-CD   TO  WS-CHG-COLUMN-VALUE-TEXT  
124500                                        MN-DELIVERY-LEVEL-CD      
124600        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
124700        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
124800        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
124900        MOVE SPACES                 TO  MI-TABLE-ID               
125000        SET METER-UPDATE            TO TRUE                       
125100     END-IF                                                       
125200*                                                                 09930000
125300     IF WS-UTILITY-SOURCE-CD  NOT = MN-UTILITY-SOURCE-CD          
125400        ADD +1                      TO  WS-TRAN-APPL-NO           
125500        MOVE '27'                   TO  MI-TABLE-ID               
125600        MOVE 'UTIL-SOURCE-CD '      TO  WS-COLUMN-DESC            
125700        MOVE MN-UTILITY-SOURCE-CD   TO  WS-PRV-COLUMN-VALUE-TEXT  
125800        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
125900        MOVE WS-UTILITY-SOURCE-CD   TO  WS-CHG-COLUMN-VALUE-TEXT  
126000                                        MN-UTILITY-SOURCE-CD      
126100        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
126200        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
126300        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
126400        MOVE SPACES                 TO  MI-TABLE-ID               
126500        SET METER-UPDATE            TO TRUE                       
126600     END-IF.                                                      
126700*                                                                 10080000
           IF WS-REMOTE-READ-IND  NOT = MN-REMOTE-READ-IND              
              ADD +1                      TO WS-TRAN-APPL-NO            
              MOVE '69'                   TO MI-TABLE-ID                
              MOVE 'REMOTE-READ-IND'      TO WS-COLUMN-DESC             
              MOVE MN-REMOTE-READ-IND     TO WS-PRV-COLUMN-VALUE-TEXT   
              MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN    
              MOVE WS-REMOTE-READ-IND     TO WS-CHG-COLUMN-VALUE-TEXT   
                                             MN-REMOTE-READ-IND         
              MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN    
              PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
              MOVE SPACES                 TO MI-TABLE-ID                
              SET METER-UPDATE            TO TRUE                       
           END-IF.                                                      
C27236     IF WS-INDUST-BTU-ID  NOT = MN-INDUST-BTU-ID                  
C27236        ADD +1                      TO WS-TRAN-APPL-NO            
C27236        MOVE '69'                   TO MI-TABLE-ID                
C27236        MOVE 'INDUST-BTU-ID'        TO WS-COLUMN-DESC             
C27236        MOVE MN-INDUST-BTU-ID       TO WS-PRV-COLUMN-VALUE-TEXT   
C27236        MOVE 3                      TO WS-PRV-COLUMN-VALUE-LEN    
C27236        MOVE WS-INDUST-BTU-ID       TO WS-CHG-COLUMN-VALUE-TEXT   
C27236                                       MN-INDUST-BTU-ID           
C27236        MOVE 3                      TO WS-CHG-COLUMN-VALUE-LEN    
C27236        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C27236        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C27236        MOVE SPACES                 TO MI-TABLE-ID                
C27236        SET METER-UPDATE            TO TRUE                       
C27236     END-IF.                                                      
C27236     IF (WS-MAX-NO-UNITS  NOT = MN-MAX-NO-UNITS) OR               
C27236        (WS-UPDATE-TYPE = 'D' AND MN-MAX-NO-UNITS = ZEROS)        
C27236        ADD +1                      TO WS-TRAN-APPL-NO            
C27236        MOVE '69'                   TO MI-TABLE-ID                
C27236        MOVE 'MAX-NO-UNITS'         TO WS-COLUMN-DESC             
C27236        MOVE MN-MAX-NO-UNITS        TO WS-PRV-COLUMN-VALUE-TEXT   
C27236        MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN    
C27236        MOVE WS-MAX-NO-UNITS        TO WS-CHG-COLUMN-VALUE-TEXT   
C27236                                       MN-MAX-NO-UNITS            
C27236        MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN    
C27236        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C27236        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C27236        MOVE SPACES                 TO MI-TABLE-ID                
C27236        SET METER-UPDATE            TO TRUE                       
C27236     END-IF.                                                      
C27236     IF WS-MIN-NO-UNITS  NOT = MN-MIN-NO-UNITS OR                 
C27236        (WS-UPDATE-TYPE = 'D' AND MN-MIN-NO-UNITS = ZEROS)        
C27236        ADD +1                      TO WS-TRAN-APPL-NO            
C27236        MOVE '69'                   TO MI-TABLE-ID                
C27236        MOVE 'MIN-NO-UNITS'         TO WS-COLUMN-DESC             
C27236        MOVE MN-MIN-NO-UNITS        TO WS-PRV-COLUMN-VALUE-TEXT   
C27236        MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN    
C27236        MOVE WS-MIN-NO-UNITS        TO WS-CHG-COLUMN-VALUE-TEXT   
C27236                                       MN-MIN-NO-UNITS            
C27236        MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN    
C27236        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C27236        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C27236        MOVE SPACES                 TO MI-TABLE-ID                
C27236        SET METER-UPDATE            TO TRUE                       
C27236     END-IF.                                                      
126800*                                                                 10680000
126900     IF WS-CODE-MTR-RD-INST1 NOT = MN-CODE-MTR-RD-INST1           
127000        ADD +1                      TO  WS-TRAN-APPL-NO           
127100        MOVE 'Q5'                   TO  MI-TABLE-ID               
127200        MOVE 'MTR-RD-INST1    '     TO  WS-COLUMN-DESC            
127210        MOVE MN-CODE-MTR-RD-INST1   TO  WS-PRV-COLUMN-VALUE-TEXT  
127220        MOVE 2                      TO  WS-PRV-COLUMN-VALUE-LEN   
127230        MOVE WS-CODE-MTR-RD-INST1   TO  WS-CHG-COLUMN-VALUE-TEXT  
127240                                        MN-CODE-MTR-RD-INST1      
127250        MOVE 2                      TO  WS-CHG-COLUMN-VALUE-LEN   
127260        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
127270        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
127280        MOVE SPACES                 TO  MI-TABLE-ID               
127290        SET METER-UPDATE            TO TRUE                       
127291     END-IF.                                                      
127293*                                                                 10840000
127294     IF WS-CODE-MTR-RD-INST2 NOT = MN-CODE-MTR-RD-INST2           
127295        ADD +1                      TO  WS-TRAN-APPL-NO           
127296        MOVE 'Q5'                   TO  MI-TABLE-ID               
127297        MOVE 'MTR-RD-INST2    '     TO  WS-COLUMN-DESC            
127298        MOVE MN-CODE-MTR-RD-INST2   TO  WS-PRV-COLUMN-VALUE-TEXT  
127299        MOVE 2                      TO  WS-PRV-COLUMN-VALUE-LEN   
127300        MOVE WS-CODE-MTR-RD-INST2   TO  WS-CHG-COLUMN-VALUE-TEXT  
127301                                        MN-CODE-MTR-RD-INST2      
127302        MOVE 2                      TO  WS-CHG-COLUMN-VALUE-LEN   
127303        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
127304        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
127305        MOVE SPACES                 TO  MI-TABLE-ID               
127306        SET METER-UPDATE            TO TRUE                       
127307     END-IF.                                                      
127309*                                                                 11000000
127310     IF WS-CODE-MTR-RD-INST3 NOT = MN-CODE-MTR-RD-INST3           
127311        ADD +1                      TO  WS-TRAN-APPL-NO           
127312        MOVE 'Q5'                   TO  MI-TABLE-ID               
127313        MOVE 'MTR-RD-INST3    '     TO  WS-COLUMN-DESC            
127314        MOVE MN-CODE-MTR-RD-INST3   TO  WS-PRV-COLUMN-VALUE-TEXT  
127315        MOVE 2                      TO  WS-PRV-COLUMN-VALUE-LEN   
127316        MOVE WS-CODE-MTR-RD-INST3   TO  WS-CHG-COLUMN-VALUE-TEXT  
127317                                        MN-CODE-MTR-RD-INST3      
127318        MOVE 2                      TO  WS-CHG-COLUMN-VALUE-LEN   
127319        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
127320        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
127321        MOVE SPACES                 TO  MI-TABLE-ID               
127322        SET METER-UPDATE            TO TRUE                       
127323     END-IF.                                                      
127324*                                                                 11150000
C30989     IF WS-METER-PRESSURE-NUM NOT = MN-METER-PRESSURE             
C30989        PERFORM 2211-CHK-PCOMP-BILL-MSG THRU 2211-EXIT            
C30989        ADD +1                      TO  WS-TRAN-APPL-NO           
C30989        MOVE SPACES                 TO  MI-TABLE-ID               
C30989        MOVE 'METER PRESSURE  '     TO  WS-COLUMN-DESC            
C30989        MOVE MN-METER-PRESSURE      TO  WS-MN-METER-PRESSURE      
C30989        MOVE WS-MN-METER-PRESSURE   TO  WS-PRV-COLUMN-VALUE-TEXT  
C30989        MOVE 3                      TO  WS-PRV-COLUMN-VALUE-LEN   
C30989        MOVE WS-METER-PRESSURE-NUM  TO  WS-CHG-COLUMN-VALUE-TEXT  
C30989                                        MN-METER-PRESSURE         
C30989        MOVE 3                      TO  WS-CHG-COLUMN-VALUE-LEN   
C30989        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
C30989        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
C30989        MOVE SPACES                 TO  MI-TABLE-ID               
C30989        SET METER-UPDATE            TO TRUE                       
C30989     END-IF.                                                      
127325*                                                                 11330000
P00545     IF WS-GIS-MISMATCH-FL NOT = MN-GIS-MISMATCH-FL               
P00545        ADD +1                      TO  WS-TRAN-APPL-NO           
P00545        MOVE '  '                   TO  MI-TABLE-ID               
P00545        MOVE 'GIS MISMATCH FL'      TO  WS-COLUMN-DESC            
115400        MOVE MN-GIS-MISMATCH-FL     TO  WS-PRV-COLUMN-VALUE-TEXT  
P00545        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
P00545        MOVE WS-GIS-MISMATCH-FL     TO  WS-CHG-COLUMN-VALUE-TEXT  
P00545                                        MN-GIS-MISMATCH-FL        
P00545        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
P00545        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
P00545        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
P00545        MOVE SPACES                 TO  MI-TABLE-ID               
P00545        SET METER-UPDATE            TO TRUE                       
116300     END-IF.                                                      
P00545*                                                                 11331500
127326 2210-EXIT.                                                       
127327     EXIT.                                                        
127328*                                                                 11360000
C30989******************************************************************11370000
C30989* MODULE TO CHECK WHETHER THE CUSTOMER NEEDS A BILL MESSAGE FOR  *11380000
C30989* P COMP FACTOR NOTIFICATION                                     *11390000
C30989******************************************************************11400000
C30989 2211-CHK-PCOMP-BILL-MSG.                                         
C30989*                                                                 11420000
C30989     IF  MN-METER-PRESSURE > 0 AND WS-METER-PRESSURE-NUM > 0      
C30989         CONTINUE                                                 
C30989     ELSE                                                         
C30989         MOVE WS-ACCOUNT-NO-COMP         TO AT-ACCOUNT-NO         
C30989                                            U1-ACCOUNT-NO         
C30989         PERFORM 7350-SELECT-ACCT THRU 7350-EXIT                  
C30989*                                                                 11490000
C30989*NEW ACCOUNTS DO NOT NEED THE MESSAGE                             11500000
C30989         IF  AT-REV-MTH-LST-NRML > 0                              
C30989             CONTINUE                                             
C30989         ELSE                                                     
C30989             GO TO 2211-EXIT                                      
C30989         END-IF                                                   
C30989*                                                                 11560000
C30989*P COMP BILL MESSAGE ID = 95079                                   11570000
C30989         MOVE '95079'                    TO U1-BILL-MSG-ID        
C30989         MOVE 'M'                        TO U1-MSG-TYPE-CD        
C30989         MOVE AT-COMPANY-NO              TO U1-COMPANY-NO         
C30989         COMPUTE U1-REVENUE-MO-END                                
C30989                            = AT-REV-MTH-LST-NRML + 1             
C30989*                                                                 11630000
C30989         IF  MN-METER-PRESSURE > 0 AND WS-METER-PRESSURE-NUM = 0  
C30989*DELETE IF THE MESSAGE EXISTS, IF PRESSURE IS CHANGED TO ZEROS    11650000
C30989             PERFORM 8110-DELETE-BILL-MSG THRU 8110-EXIT          
C30989         ELSE                                                     
C30989*                                                                 11680000
C30989             IF  MN-METER-PRESSURE = 0 AND                        
C30989                        WS-METER-PRESSURE-NUM > 0                 
C30989*INSERT THE BILL MESSAGE, IF PRESSURE IS CHANGED TO > ZEROS       11710000
C30989*                                                                 11720000
C30989                 MOVE 1                  TO U1-BILL-CYCLE-ST      
C30989                 MOVE 21                 TO U1-BILL-CYCLE-END     
C30989                 MOVE  U1-REVENUE-MO-END TO U1-REVENUE-MO-ST      
C30989                 PERFORM 8120-INSERT-BILL-MSG THRU 8120-EXIT      
C30989             END-IF                                               
C30989         END-IF                                                   
C30989     END-IF.                                                      
C30989*                                                                 11800000
C30989 2211-EXIT.                                                       
C30989     EXIT.                                                        
127329*                                                                 11830000
127330******************************************************************11840000
127340* 2220-CHANGE-REGISTER-DATA.                                     *11850000
127350*     -- THIS MODULE COMPARES AND CHANGES THE DATA FOR           *11860000
127360*          REGISTER DATA ON THE METER TABLE AND PROCESSES ALL    *11870000
127370*         JOURNALING.                                            *11880000
127380******************************************************************11890000
127390 2220-CHANGE-REGISTER-DATA.                                       
127400*                                                                 11910000
127500     PERFORM 7030-GET-RESP-AREA-ID            THRU 7030-EXIT.     
127600*                                                                 11930000
127700     MOVE WS-CURRENT-TIMESTAMP      TO  MN-LAST-UPDATE-TS.        
127800*                                                                 11950000
127900     IF WS-CODE-REG-STATUS    NOT = MN-CODE-METER-STATUS          
C34590*                                                                 11970000
C34590        IF WS-CODE-REG-STATUS = 'A'                               
C34590           MOVE SPACES              TO  MN-METER-INACTIVE-DT      
C34590                                        MN-METER-REMOVED-DT       
C34590        END-IF                                                    
C36313*                                                                 12020000
C36313        IF (WS-CODE-REG-STATUS = 'K' AND                          
C36313            MN-CODE-METER-STATUS NOT = 'J')                       
C36313         OR WS-CODE-REG-STATUS = 'J'                              
C36313           MOVE WS-CURRENT-DATE  TO MN-METER-INACTIVE-DT          
C36313        END-IF                                                    
C36313*                                                                 12080000
C36313        IF WS-CODE-REG-STATUS = 'K'                               
C36313           MOVE WS-CURRENT-DATE  TO MN-METER-REMOVED-DT           
C36313        END-IF                                                    
C36313*                                                                 12120000
128000        ADD +1                      TO WS-TRAN-APPL-NO            
128100        MOVE '28'                   TO  MI-TABLE-ID               
128200        MOVE 'CODE-REG-STATUS'      TO  WS-COLUMN-DESC            
128300        MOVE MN-CODE-METER-STATUS   TO  WS-PRV-COLUMN-VALUE-TEXT  
128400        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
128500        MOVE WS-CODE-REG-STATUS     TO  WS-CHG-COLUMN-VALUE-TEXT  
128600                                        MN-CODE-METER-STATUS      
128700        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
128800        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
128900        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
129000        MOVE SPACES                 TO  MI-TABLE-ID               
129100        IF WS-REG-ID-NO = 1                                       
129200           MOVE WS-CURRENT-DATE  TO MN-MTR-STATUS-CHNG-DT         
129300        END-IF                                                    
129400        SET METER-UPDATE            TO TRUE                       
129500     END-IF.                                                      
129600*                                                                 12290000
129700     IF WS-CODE-STATUS-REAS   NOT = MN-CODE-STATUS-REAS           
129800        ADD +1                      TO WS-TRAN-APPL-NO            
129900        MOVE '29'                   TO MI-TABLE-ID                
130000        MOVE 'CD-STATUS-REAS '      TO  WS-COLUMN-DESC            
130100        MOVE MN-CODE-STATUS-REAS    TO  WS-PRV-COLUMN-VALUE-TEXT  
130200        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
130300        MOVE WS-CODE-STATUS-REAS    TO  WS-CHG-COLUMN-VALUE-TEXT  
130400                                        MN-CODE-STATUS-REAS       
130500        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
130600        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
130700        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
130800        SET METER-UPDATE            TO TRUE                       
130900     END-IF                                                       
131000*                                                                 12430000
131100     IF WS-LAST-READ-VALUE    NOT = MN-LAST-READ-VALUE            
131200        ADD +1                      TO WS-TRAN-APPL-NO            
131300        MOVE 'LAST-READ-VALUE'      TO  WS-COLUMN-DESC            
131400        MOVE MN-LAST-READ-VALUE     TO  WS-UNPACK-VALUES-N        
131500        MOVE WS-UNPACK-VALUES       TO  WS-PRV-COLUMN-VALUE-TEXT  
131600        MOVE 15                     TO  WS-PRV-COLUMN-VALUE-LEN   
131700        MOVE WS-LAST-READ-VALUE     TO  WS-UNPACK-VALUES-N        
131800        MOVE WS-UNPACK-VALUES       TO  WS-CHG-COLUMN-VALUE-TEXT  
131900        MOVE WS-LAST-READ-VALUE     TO  MN-LAST-READ-VALUE        
132000        MOVE 15                     TO  WS-CHG-COLUMN-VALUE-LEN   
132100        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
132200        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
132300        SET METER-UPDATE            TO TRUE                       
132400     END-IF                                                       
132500*                                                                 12580000
132600     IF WS-LAST-REG-READ-DT   NOT = MN-LAST-REG-READ-DATE         
132700        ADD +1                      TO WS-TRAN-APPL-NO            
132800        MOVE 'LAST-REG-RD-DT '      TO  WS-COLUMN-DESC            
132900        MOVE MN-LAST-REG-READ-DATE  TO  WS-PRV-COLUMN-VALUE-TEXT  
133000        MOVE 10                     TO  WS-PRV-COLUMN-VALUE-LEN   
133100        MOVE WS-LAST-REG-READ-DT    TO  WS-CHG-COLUMN-VALUE-TEXT  
133200                                        MN-LAST-REG-READ-DATE     
133300        MOVE 10                     TO  WS-CHG-COLUMN-VALUE-LEN   
133400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
133500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
133600        SET METER-UPDATE            TO TRUE                       
133700     END-IF                                                       
133800*                                                                 12710000
133900     IF WS-LAST-REG-READ-TM   NOT = MN-LAST-REG-READ-TIME         
T16866        IF (MN-LAST-REG-READ-TIME NOT EQUAL '00:00 AM' OR         
T16866          WS-LAST-REG-READ-TM   NOT EQUAL '00:00:00')             
134000           ADD +1                      TO WS-TRAN-APPL-NO         
134100           MOVE 'LAST-REG-RD-TM '      TO  WS-COLUMN-DESC         
134200           MOVE MN-LAST-REG-READ-TIME TO  WS-PRV-COLUMN-VALUE-TEXT
134300           MOVE 8                     TO  WS-PRV-COLUMN-VALUE-LEN 
134400           MOVE WS-LAST-REG-READ-TM   TO  WS-CHG-COLUMN-VALUE-TEXT
134500                                          MN-LAST-REG-READ-TIME   
134600           MOVE 8                     TO  WS-CHG-COLUMN-VALUE-LEN 
134700           PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT   
134800           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT   
134900           SET METER-UPDATE            TO TRUE                    
135000        END-IF                                                    
135000     END-IF                                                       
135100*                                                                 12870000
135200     IF WS-CODE-LAST-REG-READ NOT = MN-CODE-LAST-REG-READ         
135300        ADD +1                      TO WS-TRAN-APPL-NO            
135400        MOVE '30'                   TO MI-TABLE-ID                
135500        MOVE 'CD-LAST-REG-RD '      TO  WS-COLUMN-DESC            
135600        MOVE MN-CODE-LAST-REG-READ  TO  WS-PRV-COLUMN-VALUE-TEXT  
135700        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
135800        MOVE WS-CODE-LAST-REG-READ  TO  WS-CHG-COLUMN-VALUE-TEXT  
135900                                        MN-CODE-LAST-REG-READ     
136000        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
136100        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
136200        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
136300        MOVE SPACES                 TO MI-TABLE-ID                
136400        SET METER-UPDATE            TO TRUE                       
136500     END-IF                                                       
136600*                                                                 13020000
136700     IF WS-LAST-VAL-RD-VALUE  NOT = MN-LAST-VAL-RD-VALUE          
136800        ADD +1                      TO WS-TRAN-APPL-NO            
136900        MOVE '31'                   TO MI-TABLE-ID                
137000        MOVE 'LAST-VAL-RD-VAL'      TO  WS-COLUMN-DESC            
137100        MOVE MN-LAST-VAL-RD-VALUE   TO  WS-UNPACK-VALUES-N        
137200        MOVE WS-UNPACK-VALUES       TO  WS-PRV-COLUMN-VALUE-TEXT  
137300        MOVE 15                     TO  WS-PRV-COLUMN-VALUE-LEN   
137400        MOVE WS-LAST-VAL-RD-VALUE   TO  WS-UNPACK-VALUES-N        
137500        MOVE WS-UNPACK-VALUES       TO  WS-CHG-COLUMN-VALUE-TEXT  
137600        MOVE WS-LAST-VAL-RD-VALUE   TO  MN-LAST-VAL-RD-VALUE      
137700        MOVE 15                     TO  WS-CHG-COLUMN-VALUE-LEN   
137800        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
137900        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
138000        MOVE SPACES                 TO MI-TABLE-ID                
138100        SET METER-UPDATE            TO TRUE                       
138200     END-IF                                                       
138300*                                                                 13190000
138400     IF WS-LAST-VALID-READ-DT NOT = MN-LAST-VALID-READ-DT         
138500        ADD +1                      TO WS-TRAN-APPL-NO            
138600        MOVE 'LAST-VAL-RD-DT '      TO  WS-COLUMN-DESC            
138700        MOVE MN-LAST-VALID-READ-DT  TO  WS-PRV-COLUMN-VALUE-TEXT  
138800        MOVE 10                     TO  WS-PRV-COLUMN-VALUE-LEN   
138900        MOVE WS-LAST-VALID-READ-DT  TO  WS-CHG-COLUMN-VALUE-TEXT  
139000                                        MN-LAST-VALID-READ-DT     
139100        MOVE 10                     TO  WS-CHG-COLUMN-VALUE-LEN   
139200        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
139300        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
139400        SET METER-UPDATE            TO TRUE                       
139500     END-IF                                                       
139600*                                                                 13320000
139700     IF WS-LAST-VALID-READ-TM NOT = MN-LAST-VALID-READ-TM         
T16866        IF (MN-LAST-VALID-READ-TM NOT EQUAL '00:00 AM' OR         
T16866          WS-LAST-VALID-READ-TM NOT EQUAL '00:00:00')             
139800           ADD +1                      TO WS-TRAN-APPL-NO         
139900           MOVE 'LAST-VAL-RD-TM '      TO  WS-COLUMN-DESC         
140000           MOVE MN-LAST-VALID-READ-TM TO WS-PRV-COLUMN-VALUE-TEXT 
140100           MOVE 8                     TO WS-PRV-COLUMN-VALUE-LEN  
140200           MOVE WS-LAST-VALID-READ-TM TO WS-CHG-COLUMN-VALUE-TEXT 
140300                                         MN-LAST-VALID-READ-TM    
140400           MOVE 8                      TO  WS-CHG-COLUMN-VALUE-LEN
140500           PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT   
140600           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT   
140700           SET METER-UPDATE            TO TRUE                    
140800        END-IF                                                    
140800     END-IF                                                       
140900*                                                                 13480000
141000     IF WS-CODE-CRNT-REG-READ NOT = MN-CODE-CRNT-REG-READ         
141100        ADD +1                      TO WS-TRAN-APPL-NO            
141200        MOVE '30'                   TO MI-TABLE-ID                
141300        MOVE 'CD-CRNT-REG-RD '      TO  WS-COLUMN-DESC            
141400        MOVE MN-CODE-CRNT-REG-READ  TO  WS-PRV-COLUMN-VALUE-TEXT  
141500        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
141600        MOVE WS-CODE-CRNT-REG-READ  TO  WS-CHG-COLUMN-VALUE-TEXT  
141700                                        MN-CODE-CRNT-REG-READ     
141800        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
141900        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
142000        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
142100        MOVE SPACES                 TO MI-TABLE-ID                
142200        SET METER-UPDATE            TO TRUE                       
142300     END-IF                                                       
142400*                                                                 13630000
142500     IF WS-CODE-NO-RD-REASON  NOT = MN-CODE-NO-RD-REASON          
142600        ADD +1                      TO WS-TRAN-APPL-NO            
142700        MOVE 'S4'                   TO MI-TABLE-ID                
142800        MOVE 'CD-NO-RD-REASON'      TO  WS-COLUMN-DESC            
142900        MOVE MN-CODE-NO-RD-REASON   TO  WS-PRV-COLUMN-VALUE-TEXT  
143000        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
143100        MOVE WS-CODE-NO-RD-REASON   TO  WS-CHG-COLUMN-VALUE-TEXT  
143200                                        MN-CODE-NO-RD-REASON      
143300        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
143400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
143500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
143600        MOVE SPACES                 TO MI-TABLE-ID                
143700        SET METER-UPDATE            TO TRUE                       
143800     END-IF.                                                      
143900*                                                                 13780000
144000     IF WS-REGISTER-RD-SEQ    NOT = MN-REGISTER-RD-SEQ            
144100        ADD +1                      TO WS-TRAN-APPL-NO            
144200        MOVE SPACES                 TO MI-TABLE-ID                
144300        MOVE 'REGISTER-RD-SEQ'      TO WS-COLUMN-DESC             
144400        MOVE MN-REGISTER-RD-SEQ     TO WS-PRV-COLUMN-VALUE-TEXT   
T17072        MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN    
144600        MOVE WS-REGISTER-RD-SEQ     TO WS-CHG-COLUMN-VALUE-TEXT   
144700                                       MN-REGISTER-RD-SEQ         
T17072        MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN    
144810        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
144820        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
144830        MOVE SPACES                 TO MI-TABLE-ID                
144840        SET METER-UPDATE            TO TRUE                       
144850     END-IF.                                                      
144860*                                                                 13930000
144861*  ADDED - MR 6/10/96 - TPR # 4380                                13940000
144862*                                                                 13950000
144863     IF WS-CODE-LAST-VALID-RD NOT = MN-CODE-LAST-VALID-RD         
144864        ADD +1                      TO WS-TRAN-APPL-NO            
144865        MOVE '30'                   TO MI-TABLE-ID                
144866        MOVE 'CODE-LAST-VALID-RD'   TO WS-COLUMN-DESC             
144867        MOVE MN-CODE-LAST-VALID-RD  TO WS-PRV-COLUMN-VALUE-TEXT   
144868        MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN    
144869        MOVE WS-CODE-LAST-VALID-RD  TO WS-CHG-COLUMN-VALUE-TEXT   
144870                                       MN-CODE-LAST-VALID-RD      
144871        MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN    
144872        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
144873        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
144874        MOVE SPACES                 TO MI-TABLE-ID                
144875        SET METER-UPDATE            TO TRUE                       
144876     END-IF.                                                      
144877*                                                                 14100000
144878 2220-EXIT.                                                       
144880     EXIT.                                                        
144890*                                                                 14130000
144900*                                                                 14140000
145000******************************************************************14150000
145100* 2230-CHANGE-REG-READ-DATA.                                     *14160000
145200*     -- THIS MODULE COMPARES AND CHANGES THE DATA FOR           *14170000
145300*          REGISTER DATA ON THE REGISTER READ TABLE AND          *14180000
145400*          PROCESSES ALL JOURNALING                              *14190000
145500******************************************************************14200000
145600 2230-CHANGE-REG-READ-DATA.                                       
145700*                                                                 14220000
145800     PERFORM 7030-GET-RESP-AREA-ID            THRU 7030-EXIT.     
145900*                                                                 14240000
146000     MOVE WS-CURRENT-TIMESTAMP      TO RG-LAST-UPDATE-TS.         
146100*                                                                 14260000
146200     IF WS-CODE-REG-STATUS    NOT = RG-CODE-REG-STATUS            
146300        ADD  +1                     TO  WS-TRAN-APPL-NO           
T9469         MOVE '28'                   TO  MI-TABLE-ID               
146400        MOVE 'CODE-REG-STATUS'      TO  WS-COLUMN-DESC            
146500        MOVE RG-CODE-REG-STATUS     TO  WS-PRV-COLUMN-VALUE-TEXT  
146600        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
146700        MOVE WS-CODE-REG-STATUS     TO  WS-CHG-COLUMN-VALUE-TEXT  
146800                                        RG-CODE-REG-STATUS        
146900        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
147000        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
147100        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
T9469         MOVE SPACES                 TO  MI-TABLE-ID               
147200        SET REGISTER-UPDATE         TO TRUE                       
147300     END-IF                                                       
147400*                                                                 14410000
147500     IF WS-CODE-STATUS-REAS   NOT = RG-CODE-STATUS-REAS           
147600        ADD +1                      TO WS-TRAN-APPL-NO            
T9469         MOVE '29'                   TO MI-TABLE-ID                
147700        MOVE 'CD-STATUS-REAS '      TO  WS-COLUMN-DESC            
147800        MOVE RG-CODE-STATUS-REAS    TO  WS-PRV-COLUMN-VALUE-TEXT  
147900        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
148000        MOVE WS-CODE-STATUS-REAS    TO  WS-CHG-COLUMN-VALUE-TEXT  
148100                                        RG-CODE-STATUS-REAS       
148200        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
148300        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
148400        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
T9469         MOVE SPACES                 TO MI-TABLE-ID                
148500        SET REGISTER-UPDATE         TO TRUE                       
148600     END-IF                                                       
148700*                                                                 14560000
148800     IF WS-LAST-READ-VALUE    NOT = RG-LAST-READ-VALUE            
148900        ADD +1                      TO WS-TRAN-APPL-NO            
149000        MOVE 'LAST-READ-VALUE'      TO  WS-COLUMN-DESC            
149100        MOVE RG-LAST-READ-VALUE     TO  WS-UNPACK-VALUES-N        
149200        MOVE WS-UNPACK-VALUES       TO  WS-PRV-COLUMN-VALUE-TEXT  
149300        MOVE 15                     TO  WS-PRV-COLUMN-VALUE-LEN   
149400        MOVE WS-LAST-READ-VALUE     TO  WS-UNPACK-VALUES-N        
149500        MOVE WS-UNPACK-VALUES       TO  WS-CHG-COLUMN-VALUE-TEXT  
149600        MOVE WS-LAST-READ-VALUE     TO  RG-LAST-READ-VALUE        
149700        MOVE 15                     TO  WS-CHG-COLUMN-VALUE-LEN   
149800        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
149900        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
150000        SET REGISTER-UPDATE         TO TRUE                       
150100     END-IF                                                       
150200*                                                                 14710000
150300     IF WS-LAST-REG-READ-DT   NOT = RG-LAST-REG-READ-DT           
150400        ADD +1                      TO WS-TRAN-APPL-NO            
150500        MOVE 'LAST-REG-RD-DT '      TO  WS-COLUMN-DESC            
150600        MOVE RG-LAST-REG-READ-DT    TO  WS-PRV-COLUMN-VALUE-TEXT  
150700        MOVE 10                     TO  WS-PRV-COLUMN-VALUE-LEN   
150800        MOVE WS-LAST-REG-READ-DT    TO  WS-CHG-COLUMN-VALUE-TEXT  
150900                                        RG-LAST-REG-READ-DT       
151000        MOVE 10                     TO  WS-CHG-COLUMN-VALUE-LEN   
151100        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
151200        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
151300        SET REGISTER-UPDATE         TO TRUE                       
151400     END-IF                                                       
151500*                                                                 14840000
151600     IF WS-LAST-REG-READ-TM   NOT = RG-LAST-REG-READ-TM           
151700        ADD +1                      TO WS-TRAN-APPL-NO            
151800        MOVE 'LAST-REG-RD-TM '      TO  WS-COLUMN-DESC            
151900        MOVE RG-LAST-REG-READ-TM    TO  WS-PRV-COLUMN-VALUE-TEXT  
152000        MOVE 8                      TO  WS-PRV-COLUMN-VALUE-LEN   
152100        MOVE WS-LAST-REG-READ-TM    TO  WS-CHG-COLUMN-VALUE-TEXT  
152200                                        RG-LAST-REG-READ-TM       
152300        MOVE 8                      TO  WS-CHG-COLUMN-VALUE-LEN   
152400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
152500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
152600        SET REGISTER-UPDATE         TO TRUE                       
152700     END-IF                                                       
152800*                                                                 14970000
152900     IF WS-CODE-LAST-REG-READ NOT = RG-CODE-LAST-REG-READ         
153000        ADD +1                      TO  WS-TRAN-APPL-NO           
153010        MOVE '30'                   TO  MI-TABLE-ID               
153100        MOVE 'CD-LAST-REG-RD '      TO  WS-COLUMN-DESC            
153200        MOVE RG-CODE-LAST-REG-READ  TO  WS-PRV-COLUMN-VALUE-TEXT  
153300        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
153400        MOVE WS-CODE-LAST-REG-READ  TO  WS-CHG-COLUMN-VALUE-TEXT  
153500                                        RG-CODE-LAST-REG-READ     
153600        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
153700        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
153800        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
153900        SET REGISTER-UPDATE         TO TRUE                       
154000     END-IF                                                       
154100*                                                                 15110000
154200     IF WS-LAST-VAL-RD-VALUE  NOT = RG-LAST-VAL-RD-VALUE          
154300        ADD +1                      TO WS-TRAN-APPL-NO            
154400        MOVE 'LAST-VAL-RD-VAL'      TO  WS-COLUMN-DESC            
154500        MOVE RG-LAST-VAL-RD-VALUE   TO  WS-UNPACK-VALUES-N        
154600        MOVE WS-UNPACK-VALUES       TO  WS-PRV-COLUMN-VALUE-TEXT  
154700        MOVE 15                     TO  WS-PRV-COLUMN-VALUE-LEN   
154800        MOVE WS-LAST-VAL-RD-VALUE   TO  WS-UNPACK-VALUES-N        
154900        MOVE WS-UNPACK-VALUES       TO  WS-CHG-COLUMN-VALUE-TEXT  
155000        MOVE WS-LAST-VAL-RD-VALUE   TO  RG-LAST-VAL-RD-VALUE      
155100        MOVE 15                     TO  WS-CHG-COLUMN-VALUE-LEN   
155200        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
155300        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
155400        SET REGISTER-UPDATE         TO TRUE                       
155500     END-IF                                                       
155600*                                                                 15260000
155700     IF WS-LAST-VALID-READ-DT NOT = RG-LAST-VALID-READ-DT         
155800        ADD +1                      TO WS-TRAN-APPL-NO            
155900        MOVE 'LAST-VAL-RD-DT '      TO  WS-COLUMN-DESC            
156000        MOVE RG-LAST-VALID-READ-DT  TO  WS-PRV-COLUMN-VALUE-TEXT  
156100        MOVE 10                     TO  WS-PRV-COLUMN-VALUE-LEN   
156200        MOVE WS-LAST-VALID-READ-DT  TO  WS-CHG-COLUMN-VALUE-TEXT  
156300                                        RG-LAST-VALID-READ-DT     
156400        MOVE 10                     TO  WS-CHG-COLUMN-VALUE-LEN   
156500        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
156600        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
156700        SET REGISTER-UPDATE         TO TRUE                       
156800     END-IF                                                       
156900*                                                                 15390000
157000     IF WS-LAST-VALID-READ-TM NOT = RG-LAST-VALID-READ-TM         
157100        ADD +1                      TO WS-TRAN-APPL-NO            
157200        MOVE 'LAST-VAL-RD-TM '      TO  WS-COLUMN-DESC            
157300        MOVE RG-LAST-VALID-READ-TM  TO  WS-PRV-COLUMN-VALUE-TEXT  
157400        MOVE 8                      TO  WS-PRV-COLUMN-VALUE-LEN   
157500        MOVE WS-LAST-VALID-READ-TM  TO  WS-CHG-COLUMN-VALUE-TEXT  
157600                                        RG-LAST-VALID-READ-TM     
157700        MOVE 8                      TO  WS-CHG-COLUMN-VALUE-LEN   
157800        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
157900        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
158000        SET REGISTER-UPDATE         TO TRUE                       
158100     END-IF                                                       
158200*                                                                 15520000
158300     IF WS-CODE-CRNT-REG-READ NOT = RG-CODE-CRNT-REG-READ         
158400        ADD +1                      TO WS-TRAN-APPL-NO            
158410        MOVE '30'                   TO  MI-TABLE-ID               
158500        MOVE 'CD-CRNT-REG-RD '      TO  WS-COLUMN-DESC            
158600        MOVE RG-CODE-CRNT-REG-READ  TO  WS-PRV-COLUMN-VALUE-TEXT  
158700        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
158800        MOVE WS-CODE-CRNT-REG-READ  TO  WS-CHG-COLUMN-VALUE-TEXT  
158900                                        RG-CODE-CRNT-REG-READ     
159000        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
159100        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
159200        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
159300        SET REGISTER-UPDATE         TO TRUE                       
159400     END-IF                                                       
159500*                                                                 15660000
159600     IF WS-CODE-NO-RD-REASON  NOT = RG-CODE-NO-RD-REASON          
159700        ADD +1                      TO WS-TRAN-APPL-NO            
159800        MOVE 'CD-NO-RD-REASON'      TO  WS-COLUMN-DESC            
159900        MOVE RG-CODE-NO-RD-REASON   TO  WS-PRV-COLUMN-VALUE-TEXT  
160000        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
160100        MOVE WS-CODE-NO-RD-REASON   TO  WS-CHG-COLUMN-VALUE-TEXT  
160200                                        RG-CODE-NO-RD-REASON      
160300        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
160400        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
160500        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
160600        SET REGISTER-UPDATE         TO TRUE                       
160700     END-IF.                                                      
160800*                                                                 15790000
160900     IF WS-REGISTER-RD-SEQ    NOT = RG-REGISTER-RD-SEQ            
161000        ADD +1                      TO  WS-TRAN-APPL-NO           
161100        MOVE 'REGISTER-RD-SEQ'      TO  WS-COLUMN-DESC            
161110        MOVE RG-REGISTER-RD-SEQ     TO  WS-PRV-COLUMN-VALUE-TEXT  
T17072        MOVE 9                      TO  WS-PRV-COLUMN-VALUE-LEN   
161130        MOVE WS-REGISTER-RD-SEQ     TO  WS-CHG-COLUMN-VALUE-TEXT  
161140                                        RG-REGISTER-RD-SEQ        
T17072        MOVE 9                      TO  WS-CHG-COLUMN-VALUE-LEN   
161160        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
161170        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
161180        SET REGISTER-UPDATE         TO TRUE                       
161190     END-IF.                                                      
161200*                                                                 15920000
161210*                                                                 15930000
161220*  ADDED - MR 6/10/96 - TPR # 4380                                15940000
161230*                                                                 15950000
161240     IF WS-CODE-LAST-VALID-RD NOT = RG-CODE-LAST-VALID-RD         
161250        ADD +1                      TO  WS-TRAN-APPL-NO           
161251        MOVE '30'                   TO  MI-TABLE-ID               
161260        MOVE 'CODE-LAST-VALID-RD'   TO  WS-COLUMN-DESC            
161270        MOVE RG-CODE-LAST-VALID-RD  TO  WS-PRV-COLUMN-VALUE-TEXT  
161280        MOVE 1                      TO  WS-PRV-COLUMN-VALUE-LEN   
161290        MOVE WS-CODE-LAST-VALID-RD  TO  WS-CHG-COLUMN-VALUE-TEXT  
161291                                        RG-CODE-LAST-VALID-RD     
161292        MOVE 1                      TO  WS-CHG-COLUMN-VALUE-LEN   
161293        PERFORM 2250-SET-MNT-TRANS-VARS       THRU 2250-EXIT      
161294        PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT      
161295        SET REGISTER-UPDATE         TO TRUE                       
161296     END-IF.                                                      
161299*                                                                 16090000
161300 2230-EXIT.                                                       
161400     EXIT.                                                        
161500*                                                                 16120000
161600*                                                                 16130000
161700******************************************************************16140000
161800* 2250 SET MNT TRANS VARS                                        *16150000
161900*      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *16160000
162000*         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *16170000
162100*         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *16180000
162200*         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *16190000
162300*         REQUIRED MAINTENANCE TRANSACTION RECORD.               *16200000
162400******************************************************************16210000
162500 2250-SET-MNT-TRANS-VARS.                                         
162600*                                                                 16230000
162700     MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
162800     MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
162900     MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
163000     MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
163100     MOVE WS-ACCOUNT-NO-COMP          TO MH-ACCOUNT-NO.           
163200     MOVE 0                           TO MH-CUSTOMER-NO.          
163300     MOVE 0                           TO MH-PREMISE-NO.           
163400     MOVE WS-USERID                   TO MH-USER-ID.              
163500     MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
163800     MOVE WS-METER-NO                 TO WS-EKS-METER-NO.         
163900     MOVE WS-REG-ID-NO                TO WS-EKS-REG-ID-NO.        
C37571     MOVE WS-ENTITY-KEY-DESC          TO MH-TRAN-COMMENT-TEXT.    
C37571     MOVE WS-REGISTER-LEN             TO MH-TRAN-COMMENT-LEN.     
164000     MOVE WS-ENTITY-KEY-DESC          TO MH-ENTITY-KEY-DESC-TEXT  
164100     IF WS-PANEL-NO = 'PANEL266'                                  
164200        MOVE WS-METER-LEN             TO MH-ENTITY-KEY-DESC-LEN   
164300     ELSE                                                         
164400        MOVE WS-REGISTER-LEN          TO MH-ENTITY-KEY-DESC-LEN   
164500     END-IF.                                                      
164600*                                                                 16430000
P00545     MOVE '. '                        TO                          
P00545        MH-TRAN-COMMENT-TEXT (WS-REGISTER-LEN + 1:2)              
P00545     MOVE WS-COMMENT                  TO                          
P00545        MH-TRAN-COMMENT-TEXT (WS-REGISTER-LEN + 3:WS-COMMENT-LEN) 
P00545     COMPUTE MH-TRAN-COMMENT-LEN      = MH-TRAN-COMMENT-LEN +     
P00545                                        WS-COMMENT-LEN     + 3.   
P00545*                                                                 16430400
164700     MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
164800     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
164900     MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
165000     MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
165100     MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
165200     IF WS-UPDATE-TYPE = 'D'                                      
165300        MOVE '*DELETED'               TO MI-CHG-COLUMN-VALUE-TEXT 
165400        MOVE 8                        TO MI-CHG-COLUMN-VALUE-LEN  
165500     ELSE                                                         
165600        MOVE WS-CHG-COLUMN-VALUE-TEXT TO MI-CHG-COLUMN-VALUE-TEXT 
165700        MOVE WS-CHG-COLUMN-VALUE-LEN  TO MI-CHG-COLUMN-VALUE-LEN  
165800     END-IF.                                                      
165900*                                                                 16560000
166000 2250-EXIT.                                                       
166100     EXIT.                                                        
166200*                                                                 16590000
166300*                                                                 16600000
166400                                                                  
166500******************************************************************16620000
166600* 2300-DESCRIBE-RESULT                                           *16630000
166700*                                                                *16640000
166800*     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *16650000
166900*                                                                *16660000
167000******************************************************************16670000
174300     EXEC SQL                                                     16680000
174400        INCLUDE CPD00067                                          16690000
174500     END-EXEC.                                                    16700000
174600*                                                                 16710000
174700*                                                                 16720000
174800******************************************************************16730000
174900* 7000-GET-CURRENT-DATE                                          *16740000
175000*      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *16750000
175100*        MAINTENANCE TRANSACTION RECORD.                         *16760000
175200******************************************************************16770000
175300*                                                                 16780000
175400 7000-GET-CURRENT-DATE.                                           
175500     EXEC SQL                                                     
C37571          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
175900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16800000
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     16810000
MFA-TR*    END-EXEC.                                                    16820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

176000                                                                  
176100     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
176200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
176300        NEXT SENTENCE                                             
176400     ELSE                                                         
176500        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
176600        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
176700        MOVE '7000'                    TO ACTIVE-PARAGRAPH        
176800        MOVE 'SELECT'                  TO ABEND-FUNCTION          
176900        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
177000                                          ABEND-TABLES            
C37571        MOVE 'SET '                    TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
177300        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
177400        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
177500*                                                                 16990000
177600 7000-EXIT.                                                       
177700     EXIT.                                                        
177800*                                                                 17020000
177900*                                                                 17030000
178000******************************************************************17040000
178100* 7010 ACCEPT TIMESTAMP                                          *17050000
178200*      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *17060000
178300*        MAINTENANCE TRANSACTION RECORD.                         *17070000
178400******************************************************************17080000
178500 7010-ACCEPT-TIMESTAMP.                                           
178600*                                                                 17100000
178700     EXEC SQL                                                     
C37571         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
179100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17110000
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP            17120000
MFA-TR*    END-EXEC.                                                    17130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

179200*                                                                 17140000
179300*                                                                 17150000
179400     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
179500                                                                  
179600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
179700         NEXT SENTENCE                                            
179800     ELSE                                                         
179900         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
180000         MOVE '7010'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
C37571         MOVE 'SET '               TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
180500         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
180600         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
180700     END-IF.                                                      
180800*                                                                 17320000
180900  7010-EXIT.                                                      
181000      EXIT.                                                       
181100*                                                                 17350000
181200*                                                                 17360000
181300******************************************************************17370000
181400* 7030 GET RESP AREA ID                                          *17380000
181500*      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *17390000
181600*         ACCORDING TO A USERS ID.                               *17400000
181700******************************************************************17410000
181800 7030-GET-RESP-AREA-ID.                                           
181900*                                                                 17430000
182000     EXEC SQL                                                     
182100         SELECT RESP_AREA_ID                                      
182200           INTO :WS-RESP-AREA-ID                                  
182300           FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
182400          WHERE USER_ID = :WS-USERID                              
C37571                                                           
A00839                                                      
182500     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17440000
MFA-TR*        SELECT RESP_AREA_ID                                      17450000
MFA-TR*          INTO :WS-RESP-AREA-ID                                  17460000
MFA-TR*          FROM CSS_USER_PROFILE                                  17470000
MFA-TR*         WHERE USER_ID = :WS-USERID                              17480000
MFA-TR*        WITH UR                                                  17490000
MFA-TR*        QUERYNO 7030                                             17491000
MFA-TR*    END-EXEC.                                                    17500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

182600*                                                                 17510000
182700*                                                                 17520000
182800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
182900                                                                  
183000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
183100         NEXT SENTENCE                                            
183200     ELSE                                                         
183300         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
183400         MOVE '7030'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
183600         MOVE 'CSS_USER_PROFILE  '  TO TABLE-1                    
CBSI           MOVE 'USER_ID'             TO TABLE-ELEMENT-1            
CBSI           MOVE WS-USER-ID            TO HOSTVAR-ELEMENT-1          
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
183900         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
184000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
184100     END-IF.                                                      
184200*                                                                 17710000
184300  7030-EXIT.                                                      
184400      EXIT.                                                       
184500*                                                                 17740000
184600*                                                                 17750000
184700******************************************************************17760000
184800* 7100-GET-METER.                                                *17770000
184900*       -- THIS MODULE RETRIEVES THE METER DATA TO CREATE THE    *17780000
185000*          RESULT SET.                                           *17790000
185100******************************************************************17800000
185200 7100-GET-METER.                                                  
185300*                                                                 17820000
185400     EXEC SQL                                                     
185500         SELECT MTR_REF_NO,                                       
T18805                IC_NO,                                            
185600                DATE_MTR_INSTALL,                                 
185700                POINT_ID,                                         
185800                DIGTL_MTR_TYPE,                                   
185900                METER_SUPPLYING,                                  
186000                CODE_METER_LOC,                                   
186100                NO_CONSEC_ESTIMATE,                               
186200                NO_CONSEC_CRD_READ,                               
186300                MTR_READ_SOURCE_CD,                               
186400                HEXAGRAM_LOCATION,                                
186500                SEAL_CODE_ID,                                     
186600                INSULATED_IND,                                    
186700                LOCK_TYPE_ID,                                     
186800                IDR_RECIPIENT_CD,                                 
186900                DELIVERY_LEVEL_CD,                                
187000                UTILITY_SOURCE_CD,                                
187100                CODE_DATA_PRESENT,                                
187200                REG_ID_NO,                                        
187210                REGISTER_RD_SEQ,                                  
187220                CODE_METER_STATUS,                                
187230                CODE_STATUS_REAS,                                 
187240                LAST_READ_VALUE,                                  
187250                LAST_REG_READ_DATE,                               
187260                CIS.CHAR2$TIME(LAST_REG_READ_TIME,'USA'),                 
187270                CODE_LAST_REG_READ,                               
187280                LAST_VAL_RD_VALUE,                                
187290                LAST_VALID_READ_DT,                               
187300                CIS.CHAR2$TIME(LAST_VALID_READ_TM,'USA'),                 
187400                CODE_LAST_VALID_RD,                               
187500                CODE_CRNT_REG_READ,                               
187600                CODE_NO_RD_REASON,                                
187700                MTR_STATUS_CHNG_DT,                               
187800                CODE_MTR_RD_INST1,                                
187900                CODE_MTR_RD_INST2,                                
188000                CODE_MTR_RD_INST3,                                
                      REMOTE_READ_IND,                                  
C27236                INDUST_BTU_ID,                                    
C27236                MAX_NO_UNITS,                                     
C27236                MIN_NO_UNITS,                                     
C24056                GIS_POINT_ID,                                     
C30989                METER_PRESSURE,                                   
C36313                METER_INACTIVE_DT,                                
C36313                METER_REMOVED_DT,                                 
P00545                GIS_MISMATCH_FL                                   
188100           INTO :MN-MTR-REF-NO,                                   
T18805                :MN-IC-NO,                                        
188200                :MN-DATE-MTR-INSTALL :WS-DATE-MTR-INSTALL-N,       
188300                :MN-POINT-ID,                                     
188400                :MN-DIGTL-MTR-TYPE,                               
188500                :MN-METER-SUPPLYING,                              
188600                :MN-CODE-METER-LOC,                               
188700                :MN-NO-CONSEC-ESTIMATE,                           
188800                :MN-NO-CONSEC-CRD-READ,                           
188900                :MN-MTR-READ-SOURCE-CD,                           
189000                :MN-HEXAGRAM-LOCATION,                            
189100                :MN-SEAL-CODE-ID,                                 
189200                :MN-INSULATED-IND,                                
189300                :MN-LOCK-TYPE-ID,                                 
189400                :MN-IDR-RECIPIENT-CD,                             
189500                :MN-DELIVERY-LEVEL-CD,                            
189600                :MN-UTILITY-SOURCE-CD,                            
189700                :MN-CODE-DATA-PRESENT,                            
189800                :MN-REG-ID-NO,                                    
189900                :MN-REGISTER-RD-SEQ,                              
190000                :MN-CODE-METER-STATUS,                            
190100                :MN-CODE-STATUS-REAS,                             
190200                :MN-LAST-READ-VALUE,                              
190300                :MN-LAST-REG-READ-DATE,                           
190400                :MN-LAST-REG-READ-TIME,                           
190500                :MN-CODE-LAST-REG-READ,                           
190600                :MN-LAST-VAL-RD-VALUE,                            
190700                :MN-LAST-VALID-READ-DT :WS-LAST-VALID-READ-DT-N,   
190800                :MN-LAST-VALID-READ-TM,                           
190900                :MN-CODE-LAST-VALID-RD,                           
191000                :MN-CODE-CRNT-REG-READ,                           
191100                :MN-CODE-NO-RD-REASON,                            
191200                :MN-MTR-STATUS-CHNG-DT :WS-STATUS-CHNG-DT-N,       
191300                :MN-CODE-MTR-RD-INST1,                            
191400                :MN-CODE-MTR-RD-INST2,                            
191500                :MN-CODE-MTR-RD-INST3,                            
                      :MN-REMOTE-READ-IND,                              
C27236                :MN-INDUST-BTU-ID,                                
C27236                :MN-MAX-NO-UNITS,                                 
C27236                :MN-MIN-NO-UNITS,                                 
C24056                :MN-GIS-POINT-ID,                                 
C30989                :MN-METER-PRESSURE,                               
C36313                :MN-METER-INACTIVE-DT :WS-METER-INACTIVE-DT-N,     
C36313                :MN-METER-REMOVED-DT :WS-METER-REMOVED-DT-N,       
P00545                :MN-GIS-MISMATCH-FL                               
191600           FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
191700          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP              
191800            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
T14661            AND MTR_REF_NO     = :WS-MTR-REF-NO                   
191900            AND METER_NO       = :WS-METER-NO                     
192000            AND LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )               
T14661            AND REG_ID_NO      = :WS-REG-ID-NO                    
T14661            AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD           
C37571                                                           
A00839                                                      
192100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17830000
MFA-TR*        SELECT MTR_REF_NO,                                       17840000
MFA-TR*               IC_NO,                                            17850000
MFA-TR*               DATE_MTR_INSTALL,                                 17860000
MFA-TR*               POINT_ID,                                         17870000
MFA-TR*               DIGTL_MTR_TYPE,                                   17880000
MFA-TR*               METER_SUPPLYING,                                  17890000
MFA-TR*               CODE_METER_LOC,                                   17900000
MFA-TR*               NO_CONSEC_ESTIMATE,                               17910000
MFA-TR*               NO_CONSEC_CRD_READ,                               17920000
MFA-TR*               MTR_READ_SOURCE_CD,                               17930000
MFA-TR*               HEXAGRAM_LOCATION,                                17940000
MFA-TR*               SEAL_CODE_ID,                                     17950000
MFA-TR*               INSULATED_IND,                                    17960000
MFA-TR*               LOCK_TYPE_ID,                                     17970000
MFA-TR*               IDR_RECIPIENT_CD,                                 17980000
MFA-TR*               DELIVERY_LEVEL_CD,                                17990000
MFA-TR*               UTILITY_SOURCE_CD,                                18000000
MFA-TR*               CODE_DATA_PRESENT,                                18010000
MFA-TR*               REG_ID_NO,                                        18020000
MFA-TR*               REGISTER_RD_SEQ,                                  18030000
MFA-TR*               CODE_METER_STATUS,                                18040000
MFA-TR*               CODE_STATUS_REAS,                                 18050000
MFA-TR*               LAST_READ_VALUE,                                  18060000
MFA-TR*               LAST_REG_READ_DATE,                               18070000
MFA-TR*               CHAR(LAST_REG_READ_TIME,USA),                     18080000
MFA-TR*               CODE_LAST_REG_READ,                               18090000
MFA-TR*               LAST_VAL_RD_VALUE,                                18100000
MFA-TR*               LAST_VALID_READ_DT,                               18110000
MFA-TR*               CHAR(LAST_VALID_READ_TM,USA),                     18120000
MFA-TR*               CODE_LAST_VALID_RD,                               18130000
MFA-TR*               CODE_CRNT_REG_READ,                               18140000
MFA-TR*               CODE_NO_RD_REASON,                                18150000
MFA-TR*               MTR_STATUS_CHNG_DT,                               18160000
MFA-TR*               CODE_MTR_RD_INST1,                                18170000
MFA-TR*               CODE_MTR_RD_INST2,                                18180000
MFA-TR*               CODE_MTR_RD_INST3,                                18190000
MFA-TR*               REMOTE_READ_IND,                                  18200000
MFA-TR*               INDUST_BTU_ID,                                    18210000
MFA-TR*               MAX_NO_UNITS,                                     18220000
MFA-TR*               MIN_NO_UNITS,                                     18230000
MFA-TR*               GIS_POINT_ID,                                     18240000
MFA-TR*               METER_PRESSURE,                                   18250000
MFA-TR*               METER_INACTIVE_DT,                                18260000
MFA-TR*               METER_REMOVED_DT,                                 18270000
MFA-TR*               GIS_MISMATCH_FL                                   18270100
MFA-TR*          INTO :MN-MTR-REF-NO,                                   18280000
MFA-TR*               :MN-IC-NO,                                        18290000
MFA-TR*               :MN-DATE-MTR-INSTALL:WS-DATE-MTR-INSTALL-N,       18300000
MFA-TR*               :MN-POINT-ID,                                     18310000
MFA-TR*               :MN-DIGTL-MTR-TYPE,                               18320000
MFA-TR*               :MN-METER-SUPPLYING,                              18330000
MFA-TR*               :MN-CODE-METER-LOC,                               18340000
MFA-TR*               :MN-NO-CONSEC-ESTIMATE,                           18350000
MFA-TR*               :MN-NO-CONSEC-CRD-READ,                           18360000
MFA-TR*               :MN-MTR-READ-SOURCE-CD,                           18370000
MFA-TR*               :MN-HEXAGRAM-LOCATION,                            18380000
MFA-TR*               :MN-SEAL-CODE-ID,                                 18390000
MFA-TR*               :MN-INSULATED-IND,                                18400000
MFA-TR*               :MN-LOCK-TYPE-ID,                                 18410000
MFA-TR*               :MN-IDR-RECIPIENT-CD,                             18420000
MFA-TR*               :MN-DELIVERY-LEVEL-CD,                            18430000
MFA-TR*               :MN-UTILITY-SOURCE-CD,                            18440000
MFA-TR*               :MN-CODE-DATA-PRESENT,                            18450000
MFA-TR*               :MN-REG-ID-NO,                                    18460000
MFA-TR*               :MN-REGISTER-RD-SEQ,                              18470000
MFA-TR*               :MN-CODE-METER-STATUS,                            18480000
MFA-TR*               :MN-CODE-STATUS-REAS,                             18490000
MFA-TR*               :MN-LAST-READ-VALUE,                              18500000
MFA-TR*               :MN-LAST-REG-READ-DATE,                           18510000
MFA-TR*               :MN-LAST-REG-READ-TIME,                           18520000
MFA-TR*               :MN-CODE-LAST-REG-READ,                           18530000
MFA-TR*               :MN-LAST-VAL-RD-VALUE,                            18540000
MFA-TR*               :MN-LAST-VALID-READ-DT:WS-LAST-VALID-READ-DT-N,   18550000
MFA-TR*               :MN-LAST-VALID-READ-TM,                           18560000
MFA-TR*               :MN-CODE-LAST-VALID-RD,                           18570000
MFA-TR*               :MN-CODE-CRNT-REG-READ,                           18580000
MFA-TR*               :MN-CODE-NO-RD-REASON,                            18590000
MFA-TR*               :MN-MTR-STATUS-CHNG-DT:WS-STATUS-CHNG-DT-N,       18600000
MFA-TR*               :MN-CODE-MTR-RD-INST1,                            18610000
MFA-TR*               :MN-CODE-MTR-RD-INST2,                            18620000
MFA-TR*               :MN-CODE-MTR-RD-INST3,                            18630000
MFA-TR*               :MN-REMOTE-READ-IND,                              18640000
MFA-TR*               :MN-INDUST-BTU-ID,                                18650000
MFA-TR*               :MN-MAX-NO-UNITS,                                 18660000
MFA-TR*               :MN-MIN-NO-UNITS,                                 18670000
MFA-TR*               :MN-GIS-POINT-ID,                                 18680000
MFA-TR*               :MN-METER-PRESSURE,                               18690000
MFA-TR*               :MN-METER-INACTIVE-DT:WS-METER-INACTIVE-DT-N,     18700000
MFA-TR*               :MN-METER-REMOVED-DT:WS-METER-REMOVED-DT-N,       18710000
MFA-TR*               :MN-GIS-MISMATCH-FL                               18710100
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                  18720000
MFA-TR*         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP              18730000
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               18740000
MFA-TR*           AND MTR_REF_NO     = :WS-MTR-REF-NO                   18750000
MFA-TR*           AND METER_NO       = :WS-METER-NO                     18760000
MFA-TR*           AND LAST_UPDATE_TS = :WS-LAST-UPDATE-TS               18770000
MFA-TR*           AND REG_ID_NO      = :WS-REG-ID-NO                    18780000
MFA-TR*           AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD           18790000
MFA-TR*        WITH UR                                                  18800000
MFA-TR*        QUERYNO 7100                                             18801000
MFA-TR*    END-EXEC.                                                    18810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

192200*                                                                 18820000
192300     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
192400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T14661        OR WS-ACTIVE-RETURN-CODE= NOT-FOUND                       
192500        NEXT SENTENCE                                             
192600     ELSE                                                         
192700        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
192800        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
192900        MOVE '7100'                    TO ACTIVE-PARAGRAPH        
193000        MOVE 'SELECT'                  TO ABEND-FUNCTION          
193100                                          RS-RETURN-MESSAGE       
193200        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
193300                                          ABEND-TABLES            
193400        MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE WS-ACCOUNT-NO-COMP        TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'METER_NO'                TO TABLE-ELEMENT-2         
CBSI          MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-2       
CBSI          MOVE 'MTR_REF_NO'              TO TABLE-ELEMENT-3         
CBSI          MOVE WS-MTR-REF-NO             TO HOSTVAR-ELEMENT-3       
CBSI          MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
CBSI          MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
193600        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
193700        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
193800     END-IF.                                                      
193900*                                                                 19070000
194000*                                                                 19080000
194100 7100-EXIT.                                                       
194200     EXIT.                                                        
C24056******************************************************************19110000
C24056* 7110-GET-OLD-GIS-TAG.                                          *19120000
C24056*       -- THIS MODULE RETRIEVES THE PRIOR GIS TAG                19130000
C24056*                                                                *19140000
C24056******************************************************************19150000
C24056 7110-GET-OLD-GIS-TAG.                                            
           IF MN-GIS-POINT-ID = 0                                       
            MOVE ' ' TO WS-OLD-TAG                                      
                        WS-OLD-GIS-LO                                   
            GO TO 7110-EXIT                                             
           ELSE                                                         
            NEXT SENTENCE                                               
           END-IF.                                                      
           EXEC SQL                                                     
C33743         SELECT AREA_ID,                                          
                      TAG_NM                                            
C33743           INTO :PP-AREA-ID,                                      
C33743                :PP-TAG-NM                                        
C33743           FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                       
                WHERE POINT_ID = :MN-GIS-POINT-ID                       
A00839                                                           
A00839                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19240000
MFA-TR*        SELECT AREA_ID,                                          19250000
MFA-TR*               TAG_NM                                            19260000
MFA-TR*          INTO :PP-AREA-ID,                                      19270000
MFA-TR*               :PP-TAG-NM                                        19280000
MFA-TR*          FROM CSS_PIM_POINT                                     19290000
MFA-TR*         WHERE POINT_ID = :MN-GIS-POINT-ID                       19300000
MFA-TR*        WITH UR                                                  19300100
MFA-TR*        QUERYNO 7110                                             19301000
MFA-TR*    END-EXEC.                                                    19310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37571     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
C37571        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C33743           MOVE ' ' TO PP-TAG-NM  PP-AREA-ID                      
C37571        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
C33743        MOVE 'CSS_PIM_POINT'           TO TABLE-1                 
              MOVE 'GIS-POINT-ID'            TO TABLE-ELEMENT-1         
              MOVE MN-GIS-POINT-ID           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C24056        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24056     END-IF.                                                      
C33743     MOVE PP-AREA-ID  TO WS-OLD-GIS-LO.                           
C33743     MOVE PP-TAG-NM   TO WS-OLD-TAG.                              
C24056 7110-EXIT.                                                       
C24056     EXIT.                                                        
C24056*                                                                 19540000
C24056******************************************************************19550000
C24056* 7120-GET-NEW-GIS-TAG.                                          *19560000
C24056*       -- THIS MODULE RETRIEVES THE NEW GIS TAG                  19570000
C24056*                                                                *19580000
C24056******************************************************************19590000
C24056  7120-GET-NEW-GIS-TAG.                                           
           IF WS-GIS-POINT-ID = 0                                       
            MOVE ' ' TO WS-NEW-TAG                                      
                        WS-NEW-GIS-LO                                   
            GO TO 7120-EXIT                                             
           ELSE                                                         
            NEXT SENTENCE                                               
           END-IF.                                                      
           EXEC SQL                                                     
C33743         SELECT AREA_ID,                                          
                      TAG_NM                                            
C33743           INTO :PP-AREA-ID,                                      
C33743                :PP-TAG-NM                                        
C33743           FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                       
                WHERE POINT_ID = :WS-GIS-POINT-ID                       
A00839                                                           
A00839                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19680000
MFA-TR*        SELECT AREA_ID,                                          19690000
MFA-TR*               TAG_NM                                            19700000
MFA-TR*          INTO :PP-AREA-ID,                                      19710000
MFA-TR*               :PP-TAG-NM                                        19720000
MFA-TR*          FROM CSS_PIM_POINT                                     19730000
MFA-TR*         WHERE POINT_ID = :WS-GIS-POINT-ID                       19740000
MFA-TR*        WITH UR                                                  19740100
MFA-TR*        QUERYNO 7120                                             19741000
MFA-TR*    END-EXEC.                                                    19750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
C33743       MOVE 'CSS_PIM_POINT'               TO TABLE-1              
              MOVE 'GIS-POINT-ID'            TO TABLE-ELEMENT-1         
              MOVE WS-GIS-POINT-ID           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C24056        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24056     END-IF.                                                      
C33743     MOVE PP-AREA-ID     TO WS-NEW-GIS-LO.                        
C33743     MOVE PP-TAG-NM TO WS-NEW-TAG.                                
C24056 7120-EXIT.                                                       
C24056     EXIT.                                                        
C24056*                                                                 19960000
194300******************************************************************19970000
194400* 7200-GET-REGISTER.                                             *19980000
194500*       -- THIS MODULE RETRIEVES THE METER DATA TO CREATE THE    *19990000
194600*          RESULT SET.                                           *20000000
194700*                                                                *20010000
194800******************************************************************20020000
194900 7200-GET-REGISTER.                                               
195000*                                                                 20040000
195100     EXEC SQL                                                     
195200        SELECT CODE_REG_STATUS,                                   
195300               CODE_STATUS_REAS,                                  
195400               LAST_READ_VALUE,                                   
195500               LAST_REG_READ_DT,                                  
195600               CIS.CHAR2$TIME(LAST_REG_READ_TM,'USA'),                    
195700               CODE_LAST_REG_READ,                                
195800               LAST_VAL_RD_VALUE,                                 
195900               LAST_VALID_READ_DT,                                
196000               CIS.CHAR2$TIME(LAST_VALID_READ_TM,'USA'),                  
196100               CODE_LAST_VALID_RD,                                
196200               CODE_CRNT_REG_READ,                                
196300               CODE_NO_RD_REASON,                                 
196400               REGISTER_RD_SEQ                                    
196500          INTO :RG-CODE-REG-STATUS,                               
196600               :RG-CODE-STATUS-REAS,                              
196700               :RG-LAST-READ-VALUE,                               
196800               :RG-LAST-REG-READ-DT,                              
196900               :RG-LAST-REG-READ-TM,                              
197000               :RG-CODE-LAST-REG-READ,                            
197100               :RG-LAST-VAL-RD-VALUE,                             
197200               :RG-LAST-VALID-READ-DT,                            
197300               :RG-LAST-VALID-READ-TM,                            
197400               :RG-CODE-LAST-VALID-RD,                            
197500               :RG-CODE-CRNT-REG-READ,                            
197600               :RG-CODE-NO-RD-REASON,                             
197610               :RG-REGISTER-RD-SEQ                                
197620          FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
197630         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP             
197640           AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              
197650           AND MTR_REF_NO       = :WS-MTR-REF-NO                  
197660           AND REG_ID_NO        = :WS-REG-ID-NO                   
197670           AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD            
197680           AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )              
C37571                                                           
A00839                                                      
197690     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20050000
MFA-TR*       SELECT CODE_REG_STATUS,                                   20060000
MFA-TR*              CODE_STATUS_REAS,                                  20070000
MFA-TR*              LAST_READ_VALUE,                                   20080000
MFA-TR*              LAST_REG_READ_DT,                                  20090000
MFA-TR*              CHAR(LAST_REG_READ_TM,USA),                        20100000
MFA-TR*              CODE_LAST_REG_READ,                                20110000
MFA-TR*              LAST_VAL_RD_VALUE,                                 20120000
MFA-TR*              LAST_VALID_READ_DT,                                20130000
MFA-TR*              CHAR(LAST_VALID_READ_TM,USA),                      20140000
MFA-TR*              CODE_LAST_VALID_RD,                                20150000
MFA-TR*              CODE_CRNT_REG_READ,                                20160000
MFA-TR*              CODE_NO_RD_REASON,                                 20170000
MFA-TR*              REGISTER_RD_SEQ                                    20180000
MFA-TR*         INTO :RG-CODE-REG-STATUS,                               20190000
MFA-TR*              :RG-CODE-STATUS-REAS,                              20200000
MFA-TR*              :RG-LAST-READ-VALUE,                               20210000
MFA-TR*              :RG-LAST-REG-READ-DT,                              20220000
MFA-TR*              :RG-LAST-REG-READ-TM,                              20230000
MFA-TR*              :RG-CODE-LAST-REG-READ,                            20240000
MFA-TR*              :RG-LAST-VAL-RD-VALUE,                             20250000
MFA-TR*              :RG-LAST-VALID-READ-DT,                            20260000
MFA-TR*              :RG-LAST-VALID-READ-TM,                            20270000
MFA-TR*              :RG-CODE-LAST-VALID-RD,                            20280000
MFA-TR*              :RG-CODE-CRNT-REG-READ,                            20290000
MFA-TR*              :RG-CODE-NO-RD-REASON,                             20300000
MFA-TR*              :RG-REGISTER-RD-SEQ                                20310000
MFA-TR*         FROM CSS_REGISTER_READ                                  20320000
MFA-TR*        WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP             20330000
MFA-TR*          AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              20340000
MFA-TR*          AND MTR_REF_NO       = :WS-MTR-REF-NO                  20350000
MFA-TR*          AND REG_ID_NO        = :WS-REG-ID-NO                   20360000
MFA-TR*          AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD            20370000
MFA-TR*          AND LAST_UPDATE_TS   = :WS-LAST-UPDATE-TS              20380000
MFA-TR*        WITH UR                                                  20390000
MFA-TR*        QUERYNO 7200                                             20391000
MFA-TR*    END-EXEC.                                                    20400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

197700*                                                                 20410000
197800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
197900*                                                                 20430000
198000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
198100        NEXT SENTENCE                                             
198200     ELSE                                                         
198300        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
198400        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
198500        MOVE '7200'                    TO ACTIVE-PARAGRAPH        
198600        MOVE 'SELECT'                  TO ABEND-FUNCTION          
198700                                          RS-RETURN-MESSAGE       
198800        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
198900                                          ABEND-TABLES            
199000        MOVE 'CSS_REGISTER_READ'       TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE WS-ACCOUNT-NO-COMP        TO HOSTVAR-ELEMENT-1       
CBSI          MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
CBSI          MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
CBSI          MOVE 'MTR_REF_NO'              TO TABLE-ELEMENT-3         
CBSI          MOVE WS-MTR-REF-NO             TO HOSTVAR-ELEMENT-3       
CBSI          MOVE 'REG_ID_NO'               TO TABLE-ELEMENT-4         
CBSI          MOVE WS-REG-ID-NO              TO HOSTVAR-ELEMENT-4       
199200        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
199300        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
199400     END-IF.                                                      
199500*                                                                 20660000
199600*                                                                 20670000
199700 7200-EXIT.                                                       
199800     EXIT.                                                        
199900*                                                                 20700000
200000*                                                                 20710000
200100******************************************************************20720000
200200* 7300-CHECK-DATA-PRESENT                                        *20730000
200300*          1. CHECK FOR EXISTING DATA REGISTERS USING ACCOUNT-NO *20740000
200400*             CODE-UTIL-TYPE AND MTR_REF-NO. IF A METER DOES NOT *20750000
200500*             EXIST, THE MTRD-ENVRNMT CODE-DATA-PRESENT FAG WILL *20760000
200600*             NEED TO BE UPDATED.                                *20770000
200700******************************************************************20780000
200800 7300-CHECK-DATA-PRESENT.                                         
200900     EXEC SQL                                                     
201000        SELECT REG_ID_NO                                          
201100          INTO :RG-REG-ID-NO                                      
201200          FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
201300         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP             
201400           AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              
201500           AND MTR_REF_NO       = :WS-MTR-REF-NO                  
C37571                                                           
A00839                                                      
201600     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20800000
MFA-TR*       SELECT REG_ID_NO                                          20810000
MFA-TR*         INTO :RG-REG-ID-NO                                      20820000
MFA-TR*         FROM CSS_REGISTER_READ                                  20830000
MFA-TR*        WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP             20840000
MFA-TR*          AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE              20850000
MFA-TR*          AND MTR_REF_NO       = :WS-MTR-REF-NO                  20860000
MFA-TR*        WITH UR                                                  20870000
MFA-TR*        QUERYNO 7300                                             20871000
MFA-TR*    END-EXEC.                                                    20880000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

201700*                                                                 20890000
201800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
201900*                                                                 20910000
202000     IF WS-ACTIVE-RETURN-CODE            = NOT-FOUND              
202100        OR WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL        
202200        OR WS-ACTIVE-RETURN-CODE         = MULTIPLE-ROWS-CALL     
202300                                                                  
202400        NEXT SENTENCE                                             
202500     ELSE                                                         
202600        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
202700        MOVE '7300'                        TO ACTIVE-PARAGRAPH    
202800        MOVE 'SELECT'                      TO ABEND-FUNCTION      
CBSI          MOVE SPACES                        TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
202900        MOVE 'CSS_REGISTER_READ'           TO TABLE-1             
203000        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
203100        MOVE WS-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
203200        MOVE 'CODE_UTIL_TYPE'              TO TABLE-ELEMENT-2     
203300        MOVE  WS-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
203400        MOVE 'MTR_REF_NO'                  TO TABLE-ELEMENT-3     
203500        MOVE  WS-MTR-REF-NO                TO HOSTVAR-ELEMENT-3   
203600        PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
203700        PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
203800     END-IF.                                                      
203900                                                                  
204000 7300-EXIT.                                                       
204100     EXIT.                                                        
204200                                                                  
C30989******************************************************************21172000
C30989* 7350-SELECT-ACCT                                               *21180000
C30989*   SELECT REVENUE MONTH LAST NORMAL AND COMPANY-NO FROM ACCOUNT *21190000
C30989*   TABLE                                                        *21200000
C30989******************************************************************21210000
C30989 7350-SELECT-ACCT.                                                
C30989     EXEC SQL                                                     
C30989        SELECT COMPANY_NO                                         
C30989              ,REV_MTH_LST_NRML                                   
C30989          INTO :AT-COMPANY-NO                                     
C30989              ,:AT-REV-MTH-LST-NRML                               
C30989          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
C30989         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
C37571                                                           
A00839                                                      
C30989     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21230000
MFA-TR*       SELECT COMPANY_NO                                         21240000
MFA-TR*             ,REV_MTH_LST_NRML                                   21250000
MFA-TR*         INTO :AT-COMPANY-NO                                     21260000
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               21270000
MFA-TR*         FROM CSS_ACCOUNT                                        21280000
MFA-TR*        WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  21290000
MFA-TR*        WITH UR                                                  21300000
MFA-TR*        QUERYNO 7350                                             21301000
MFA-TR*    END-EXEC.                                                    21310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30989*                                                                 21320000
C30989     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30989*                                                                 21340000
C30989     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30989        NEXT SENTENCE                                             
C30989     ELSE                                                         
C30989        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
C30989        MOVE '7350'                        TO ACTIVE-PARAGRAPH    
C30989        MOVE 'SELECT'                      TO ABEND-FUNCTION      
C30989        MOVE SPACES                        TO ABEND-SQL-PREDICATES
C30989                                              ABEND-TABLES        
C30989        MOVE 'CSS_ACCOUNT'                 TO TABLE-1             
C30989        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
C30989        MOVE AT-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
C30989        PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
C30989        PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
C30989     END-IF.                                                      
C30989                                                                  
C30989 7350-EXIT.                                                       
C30989     EXIT.                                                        
C30989*                                                                 21520000
A00839******************************************************************21521000
A00839* 7400-SELECT-ACCT-WHT-CROSS                                     *21522000
A00839*          CHECK IF ANY ROW EXIST IN CSS_ACCT_WHT_CROSS EXISTING *21523000
A00839*          ACCOUNT NO AND OLD MN-GIS-POINT-ID                    *21524000
A00839******************************************************************21525000
A00839 7400-SELECT-ACCT-WHT-CROSS.                                      
A00839                                                                  
A00839     EXEC SQL                                                     
A00839        SELECT TOP(1) 'Y'                                                
A00839          INTO :WS-WHT-CROSS-UPDATE                               
A00839          FROM CSS_ACCT_WHT_CROSS WITH(READUNCOMMITTED)                   
A00839         WHERE ACCOUNT_NO       = :WH-ACCOUNT-NO                  
A00839           AND GIS_POINT_ID     = :WH-GIS-POINT-ID                
A00839                                            
A00839                                                           
A00839                                                      
A00839     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21528000
MFA-TR*       SELECT 'Y'                                                21529000
MFA-TR*         INTO :WS-WHT-CROSS-UPDATE                               21529100
MFA-TR*         FROM CSS_ACCT_WHT_CROSS                                 21529200
MFA-TR*        WHERE ACCOUNT_NO       = :WH-ACCOUNT-NO                  21529300
MFA-TR*          AND GIS_POINT_ID     = :WH-GIS-POINT-ID                21529400
MFA-TR*        FETCH FIRST 1 ROW ONLY                                   21529600
MFA-TR*        WITH UR                                                  21529700
MFA-TR*        QUERYNO 7400                                             21529800
MFA-TR*    END-EXEC.                                                    21529900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00839*                                                                 21530000
A00839     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00839*                                                                 21530200
A00839     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00839        NEXT SENTENCE                                             
A00839     ELSE                                                         
A00839        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
A00839        MOVE '7400'                        TO ACTIVE-PARAGRAPH    
A00839        MOVE 'SELECT'                      TO ABEND-FUNCTION      
A00839        MOVE SPACES                        TO ABEND-SQL-PREDICATES
A00839                                              ABEND-TABLES        
A00839        MOVE 'CSS_ACCT_WHT_CROSS'          TO TABLE-1             
A00839        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
A00839        MOVE WH-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
A00839        MOVE 'GIS-POINT-ID'                TO TABLE-ELEMENT-2     
A00839        MOVE WS-GIS-POINT-ID-OLD           TO HOSTVAR-ELEMENT-2   
A00839        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
A00839        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
A00839     END-IF.                                                      
A00839                                                                  
A00839 7400-EXIT.                                                       
A00839     EXIT.                                                        
A00839                                                                  
P00251******************************************************************21532700
P00251* 7500-CHECK-DEP-UTL-BILL-REL                                    *21532800
P00251*          CHECK IF ANY ROW EXIST IN CSS_UTL_BILL_REL WHERE      *21532900
P00251*          ACCOUNT AND METER IS A DEPENDENT                      *21533000
P00251******************************************************************21533100
P00251 7500-CHECK-DEP-UTL-BILL-REL.                                     
P00251                                                                  
P00251     EXEC SQL                                                     
P00251        SELECT TOP(1) 'Y'                                                
P00251          INTO :WS-MSTDEP-REL-EXISTS-FL                           
P00251          FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
P00251         WHERE ACCOUNT_NO_DEP         = :UR-ACCOUNT-NO-DEP        
P00251           AND CODE_UTIL_TYPE_DEP     = :UR-CODE-UTIL-TYPE-DEP    
P00251           AND IC_NO_DEP              = :UR-IC-NO-DEP             
P00251           AND MTR_REF_NO_DEP         = :UR-MTR-REF-NO-DEP        
P00251                                            
P00251                                                           
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21533400
MFA-TR*       SELECT 'Y'                                                21533500
MFA-TR*         INTO :WS-MSTDEP-REL-EXISTS-FL                           21533600
MFA-TR*         FROM CSS_UTL_BILL_REL                                   21533700
MFA-TR*        WHERE ACCOUNT_NO_DEP         = :UR-ACCOUNT-NO-DEP        21533800
MFA-TR*          AND CODE_UTIL_TYPE_DEP     = :UR-CODE-UTIL-TYPE-DEP    21533900
MFA-TR*          AND IC_NO_DEP              = :UR-IC-NO-DEP             21534000
MFA-TR*          AND MTR_REF_NO_DEP         = :UR-MTR-REF-NO-DEP        21534100
MFA-TR*        FETCH FIRST 1 ROW ONLY                                   21534200
MFA-TR*        WITH UR                                                  21534300
MFA-TR*        QUERYNO 7500                                             21534400
MFA-TR*    END-EXEC.                                                    21534500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251*                                                                 21534600
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251*                                                                 21534800
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00251        NEXT SENTENCE                                             
P00251     ELSE                                                         
P00251        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
P00251        MOVE '7500'                        TO ACTIVE-PARAGRAPH    
P00251        MOVE 'SELECT'                      TO ABEND-FUNCTION      
P00251        MOVE SPACES                        TO ABEND-SQL-PREDICATES
P00251                                              ABEND-TABLES        
P00251        MOVE 'CSS_UTL_BILL_REL'            TO TABLE-1             
P00251        MOVE 'ACCOUNT_NO_DEP'              TO TABLE-ELEMENT-1     
P00251        MOVE UR-ACCOUNT-NO-DEP             TO HOSTVAR-ELEMENT-1   
P00251        MOVE 'CODE_UTIL_TYPE_DEP'          TO TABLE-ELEMENT-2     
P00251        MOVE UR-CODE-UTIL-TYPE-DEP         TO HOSTVAR-ELEMENT-2   
P00251        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00251        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00251     END-IF.                                                      
P00251*                                                                 21536500
P00251 7500-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                 21536800
P00251******************************************************************21536900
P00251* 7510-CHECK-MST-UTL-BILL-REL                                    *21537000
P00251*          CHECK IF ANY ROW EXIST IN CSS_UTL_BILL_REL WHERE      *21537100
P00251*          ACCOUNT AND METER IS A MASTER                         *21537200
P00251******************************************************************21537300
P00251 7510-CHECK-MST-UTL-BILL-REL.                                     
P00251*                                                                 21537500
P00251     EXEC SQL                                                     
P00251        SELECT TOP(1) 'Y'                                                
P00251          INTO :WS-MSTDEP-REL-EXISTS-FL                           
P00251          FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
P00251         WHERE ACCOUNT_NO_MST         = :UR-ACCOUNT-NO-MST        
P00251           AND CODE_UTIL_TYPE_MST     = :UR-CODE-UTIL-TYPE-MST    
P00251           AND IC_NO_MST              = :UR-IC-NO-MST             
P00251           AND MTR_REF_NO_MST         = :UR-MTR-REF-NO-MST        
P00251                                            
P00251                                                           
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21537600
MFA-TR*       SELECT 'Y'                                                21537700
MFA-TR*         INTO :WS-MSTDEP-REL-EXISTS-FL                           21537800
MFA-TR*         FROM CSS_UTL_BILL_REL                                   21537900
MFA-TR*        WHERE ACCOUNT_NO_MST         = :UR-ACCOUNT-NO-MST        21538000
MFA-TR*          AND CODE_UTIL_TYPE_MST     = :UR-CODE-UTIL-TYPE-MST    21538100
MFA-TR*          AND IC_NO_MST              = :UR-IC-NO-MST             21538202
MFA-TR*          AND MTR_REF_NO_MST         = :UR-MTR-REF-NO-MST        21538302
MFA-TR*        FETCH FIRST 1 ROW ONLY                                   21538400
MFA-TR*        WITH UR                                                  21538500
MFA-TR*        QUERYNO 7510                                             21538600
MFA-TR*    END-EXEC.                                                    21538700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251*                                                                 21538800
P00251     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00251*                                                                 21539000
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00251        NEXT SENTENCE                                             
P00251     ELSE                                                         
P00251        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
P00251        MOVE '7510'                        TO ACTIVE-PARAGRAPH    
P00251        MOVE 'SELECT'                      TO ABEND-FUNCTION      
P00251        MOVE SPACES                        TO ABEND-SQL-PREDICATES
P00251                                              ABEND-TABLES        
P00251        MOVE 'CSS_UTL_BILL_REL'            TO TABLE-1             
P00251        MOVE 'ACCOUNT_NO_MST'              TO TABLE-ELEMENT-1     
P00251        MOVE UR-ACCOUNT-NO-MST             TO HOSTVAR-ELEMENT-1   
P00251        MOVE 'CODE_UTIL_TYPE_MST'          TO TABLE-ELEMENT-2     
P00251        MOVE UR-CODE-UTIL-TYPE-MST         TO HOSTVAR-ELEMENT-2   
P00251        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00251        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00251     END-IF.                                                      
P00251*                                                                 21540700
P00251 7510-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                 21541000
204300******************************************************************21541100
204400* 8000-UPDATE-MTRD_ENV.                                          *21542000
204500*       -- THIS MODULE UPDATES CSS_MTRD_ENVRNMT                  *21550000
204600******************************************************************21560000
204700 8000-UPDATE-MTRD-ENV.                                            
C36313*                                                                 21580000
C36313     IF MN-METER-INACTIVE-DT  = LOW-VALUES OR SPACES              
C36313        MOVE -1 TO WS-METER-INACTIVE-DT-N                         
C36313     ELSE                                                         
C36313        MOVE ZERO TO WS-METER-INACTIVE-DT-N                       
C36313     END-IF.                                                      
C36313*                                                                 21640000
C36313     IF MN-METER-REMOVED-DT   = LOW-VALUES OR SPACES              
C36313        MOVE -1 TO WS-METER-REMOVED-DT-N                          
C36313     ELSE                                                         
C36313        MOVE ZERO TO WS-METER-REMOVED-DT-N                        
C36313     END-IF.                                                      
C36313*                                                                 21700000
C36313     IF MN-MTR-STATUS-CHNG-DT = LOW-VALUES OR SPACES              
C36313        MOVE -1 TO WS-MTR-STATUS-CHNG-DT-N                        
C36313     ELSE                                                         
C36313        MOVE ZERO TO WS-MTR-STATUS-CHNG-DT-N                      
C36313     END-IF.                                                      
C36313*                                                                 21760000
204800     EXEC SQL                                                     
204900          UPDATE CSS_MTRD_ENVRNMT                                 
205000          SET    DATE_MTR_INSTALL   = IIF(TRY_CONVERT(DATE, 
                                                   :MN-DATE-MTR-INSTALL
              ) IS NULL OR (PATINDEX('%.%', :MN-DATE-MTR-INSTALL
              ) <> 0) OR (LEN(:MN-DATE-MTR-INSTALL
              ) <> 10), CIS.CHAR2DATE(:MN-DATE-MTR-INSTALL
              ), CONVERT(DATE, :MN-DATE-MTR-INSTALL) ),       
C24056*                POINT_ID           = :MN-POINT-ID,               21800000
205200                 METER_SUPPLYING    = :MN-METER-SUPPLYING,        
205300                 CODE_METER_LOC     = :MN-CODE-METER-LOC,         
205400                 NO_CONSEC_ESTIMATE = :MN-NO-CONSEC-ESTIMATE,     
205500                 NO_CONSEC_CRD_READ = :MN-NO-CONSEC-CRD-READ,     
205600                 MTR_READ_SOURCE_CD = :MN-MTR-READ-SOURCE-CD,     
205700                 HEXAGRAM_LOCATION  = :MN-HEXAGRAM-LOCATION,      
205800                 SEAL_CODE_ID       = :MN-SEAL-CODE-ID,           
205900                 INSULATED_IND      = :MN-INSULATED-IND,          
206000                 LOCK_TYPE_ID       = :MN-LOCK-TYPE-ID,           
206100                 IDR_RECIPIENT_CD   = :MN-IDR-RECIPIENT-CD,       
206200                 DELIVERY_LEVEL_CD  = :MN-DELIVERY-LEVEL-CD,      
206300                 UTILITY_SOURCE_CD  = :MN-UTILITY-SOURCE-CD,      
206400                 CODE_MTR_RD_INST1  = :WS-CODE-MTR-RD-INST1,      
206500                 CODE_MTR_RD_INST2  = :WS-CODE-MTR-RD-INST2,      
206600                 CODE_MTR_RD_INST3  = :WS-CODE-MTR-RD-INST3,      
206700                 CODE_METER_STATUS  = :MN-CODE-METER-STATUS,      
206800                 CODE_STATUS_REAS   = :MN-CODE-STATUS-REAS,       
206900                 LAST_READ_VALUE    = :MN-LAST-READ-VALUE,        
207000                 LAST_REG_READ_DATE = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE) ),     
207100                 LAST_REG_READ_TIME = CIS.CHAR2TIME(
                                                 :MN-LAST-REG-READ-TIME
              ),     
207200                 CODE_LAST_REG_READ = :MN-CODE-LAST-REG-READ,     
207300                 LAST_VAL_RD_VALUE  = :MN-LAST-VAL-RD-VALUE,      
207400                 LAST_VALID_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-VALID-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT) ),     
207500                 LAST_VALID_READ_TM = CIS.CHAR2TIME(
                                                 :MN-LAST-VALID-READ-TM
              ),     
207600                 CODE_LAST_VALID_RD = :MN-CODE-LAST-VALID-RD,     
207700                 CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ,     
207800                 CODE_NO_RD_REASON  = :MN-CODE-NO-RD-REASON,      
207900                 LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :MN-LAST-UPDATE-TS
              ),         
208000                 REGISTER_RD_SEQ    = :MN-REGISTER-RD-SEQ,        
                       REMOTE_READ_IND    = :MN-REMOTE-READ-IND,        
C27236                 INDUST_BTU_ID      = :MN-INDUST-BTU-ID,          
C27236                 MAX_NO_UNITS       = :MN-MAX-NO-UNITS,           
C27236                 MIN_NO_UNITS       = :MN-MIN-NO-UNITS,           
C24056                 GIS_POINT_ID       = :MN-GIS-POINT-ID,           
C30989                 METER_PRESSURE     = :MN-METER-PRESSURE,         
C36313                 METER_INACTIVE_DT                                
C36313                  =IIF(TRY_CONVERT(DATE, :MN-METER-INACTIVE-DT 
                                               :WS-METER-INACTIVE-DT-N
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-INACTIVE-DT 
                                                :WS-METER-INACTIVE-DT-N
              ) <> 0) OR (LEN(:MN-METER-INACTIVE-DT 
                                                :WS-METER-INACTIVE-DT-N
              ) <> 10), CIS.CHAR2DATE(:MN-METER-INACTIVE-DT 
                                                :WS-METER-INACTIVE-DT-N
              ), CONVERT(DATE, :MN-METER-INACTIVE-DT 
                                                :WS-METER-INACTIVE-DT-N
              ) ),  
C36313                 METER_REMOVED_DT                                 
C36313                  =IIF(TRY_CONVERT(DATE, :MN-METER-REMOVED-DT 
                                               :WS-METER-REMOVED-DT-N
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-REMOVED-DT 
                                                 :WS-METER-REMOVED-DT-N
              ) <> 0) OR (LEN(:MN-METER-REMOVED-DT 
                                                 :WS-METER-REMOVED-DT-N
              ) <> 10), CIS.CHAR2DATE(:MN-METER-REMOVED-DT 
                                                 :WS-METER-REMOVED-DT-N
              ), CONVERT(DATE, :MN-METER-REMOVED-DT 
                                                 :WS-METER-REMOVED-DT-N
              ) ),    
C36313                 MTR_STATUS_CHNG_DT                               
C36313                  =IIF(TRY_CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT 
                                               :WS-MTR-STATUS-CHNG-DT-N
              ) IS NULL OR (PATINDEX('%.%', :MN-MTR-STATUS-CHNG-DT 
                                               :WS-MTR-STATUS-CHNG-DT-N
              ) <> 0) OR (LEN(:MN-MTR-STATUS-CHNG-DT 
                                               :WS-MTR-STATUS-CHNG-DT-N
              ) <> 10), CIS.CHAR2DATE(:MN-MTR-STATUS-CHNG-DT 
                                               :WS-MTR-STATUS-CHNG-DT-N
              ), CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT 
                                               :WS-MTR-STATUS-CHNG-DT-N
              ) ),
P00545                 GIS_MISMATCH_FL  = :MN-GIS-MISMATCH-FL           
208100          WHERE  ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           
208200            AND  CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            
208300            AND  METER_NO         = :WS-METER-NO                  
208400            AND  LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )            
208500     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21770000
MFA-TR*         UPDATE CSS_MTRD_ENVRNMT                                 21780000
MFA-TR*         SET    DATE_MTR_INSTALL   = :MN-DATE-MTR-INSTALL,       21790000
MFA-TR*                POINT_ID           = :MN-POINT-ID,               21800000
MFA-TR*                METER_SUPPLYING    = :MN-METER-SUPPLYING,        21810000
MFA-TR*                CODE_METER_LOC     = :MN-CODE-METER-LOC,         21820000
MFA-TR*                NO_CONSEC_ESTIMATE = :MN-NO-CONSEC-ESTIMATE,     21830000
MFA-TR*                NO_CONSEC_CRD_READ = :MN-NO-CONSEC-CRD-READ,     21840000
MFA-TR*                MTR_READ_SOURCE_CD = :MN-MTR-READ-SOURCE-CD,     21850000
MFA-TR*                HEXAGRAM_LOCATION  = :MN-HEXAGRAM-LOCATION,      21860000
MFA-TR*                SEAL_CODE_ID       = :MN-SEAL-CODE-ID,           21870000
MFA-TR*                INSULATED_IND      = :MN-INSULATED-IND,          21880000
MFA-TR*                LOCK_TYPE_ID       = :MN-LOCK-TYPE-ID,           21890000
MFA-TR*                IDR_RECIPIENT_CD   = :MN-IDR-RECIPIENT-CD,       21900000
MFA-TR*                DELIVERY_LEVEL_CD  = :MN-DELIVERY-LEVEL-CD,      21910000
MFA-TR*                UTILITY_SOURCE_CD  = :MN-UTILITY-SOURCE-CD,      21920000
MFA-TR*                CODE_MTR_RD_INST1  = :WS-CODE-MTR-RD-INST1,      21930000
MFA-TR*                CODE_MTR_RD_INST2  = :WS-CODE-MTR-RD-INST2,      21940000
MFA-TR*                CODE_MTR_RD_INST3  = :WS-CODE-MTR-RD-INST3,      21950000
MFA-TR*                CODE_METER_STATUS  = :MN-CODE-METER-STATUS,      21960000
MFA-TR*                CODE_STATUS_REAS   = :MN-CODE-STATUS-REAS,       21970000
MFA-TR*                LAST_READ_VALUE    = :MN-LAST-READ-VALUE,        21980000
MFA-TR*                LAST_REG_READ_DATE = :MN-LAST-REG-READ-DATE,     21990000
MFA-TR*                LAST_REG_READ_TIME = :MN-LAST-REG-READ-TIME,     22000000
MFA-TR*                CODE_LAST_REG_READ = :MN-CODE-LAST-REG-READ,     22010000
MFA-TR*                LAST_VAL_RD_VALUE  = :MN-LAST-VAL-RD-VALUE,      22020000
MFA-TR*                LAST_VALID_READ_DT = :MN-LAST-VALID-READ-DT,     22030000
MFA-TR*                LAST_VALID_READ_TM = :MN-LAST-VALID-READ-TM,     22040000
MFA-TR*                CODE_LAST_VALID_RD = :MN-CODE-LAST-VALID-RD,     22050000
MFA-TR*                CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ,     22060000
MFA-TR*                CODE_NO_RD_REASON  = :MN-CODE-NO-RD-REASON,      22070000
MFA-TR*                LAST_UPDATE_TS     = :MN-LAST-UPDATE-TS,         22080000
MFA-TR*                REGISTER_RD_SEQ    = :MN-REGISTER-RD-SEQ,        22090000
MFA-TR*                REMOTE_READ_IND    = :MN-REMOTE-READ-IND,        22100000
MFA-TR*                INDUST_BTU_ID      = :MN-INDUST-BTU-ID,          22110000
MFA-TR*                MAX_NO_UNITS       = :MN-MAX-NO-UNITS,           22120000
MFA-TR*                MIN_NO_UNITS       = :MN-MIN-NO-UNITS,           22130000
MFA-TR*                GIS_POINT_ID       = :MN-GIS-POINT-ID,           22140000
MFA-TR*                METER_PRESSURE     = :MN-METER-PRESSURE,         22150000
MFA-TR*                METER_INACTIVE_DT                                22160000
MFA-TR*                 =:MN-METER-INACTIVE-DT:WS-METER-INACTIVE-DT-N,  22170000
MFA-TR*                METER_REMOVED_DT                                 22180000
MFA-TR*                 =:MN-METER-REMOVED-DT:WS-METER-REMOVED-DT-N,    22190000
MFA-TR*                MTR_STATUS_CHNG_DT                               22200000
MFA-TR*                 =:MN-MTR-STATUS-CHNG-DT:WS-MTR-STATUS-CHNG-DT-N,22210000
MFA-TR*                GIS_MISMATCH_FL  = :MN-GIS-MISMATCH-FL           22210100
MFA-TR*         WHERE  ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           22220000
MFA-TR*           AND  CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            22230000
MFA-TR*           AND  METER_NO         = :WS-METER-NO                  22240000
MFA-TR*           AND  LAST_UPDATE_TS   = :WS-LAST-UPDATE-TS            22250000
MFA-TR*    END-EXEC.                                                    22260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

208600*                                                                 22270000
208700     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
208800     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
208800         NEXT SENTENCE                                            
209000     ELSE                                                         
CBSI           MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
209100         MOVE '8000'             TO ACTIVE-PARAGRAPH              
209900         MOVE 'UPDATE'           TO ABEND-FUNCTION                
210000                                    RS-RETURN-MESSAGE             
209200         MOVE SPACES             TO ABEND-TABLES                  
209300                                    ABEND-SQL-PREDICATES          
209400         MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                       
CBSI           MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
CBSI           MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
CBSI           MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
CBSI           MOVE WS-ACCOUNT-NO-COMP TO HOSTVAR-ELEMENT-1             
CBSI           MOVE WS-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
CBSI           MOVE WS-METER-NO        TO HOSTVAR-ELEMENT-3             
210100         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
210200     END-IF.                                                      
210300 8000-EXIT.                                                       
210400     EXIT.                                                        
210500*                                                                 22490000
210600******************************************************************22500000
210700* 8005-UPDATE-DATA-PRS.                                          *22510000
210800*       -- THIS MODULE UPDATES CSS_MTRD_ENVRNMT FOR              *22520000
210900*          CODE-DATA-PRESENT IF THE LAST REGISTER HAS BEEN       *22530000
211000*          DELETED.                                              *22540000
211100******************************************************************22550000
211200 8005-UPDATE-DATA-PRSNT.                                          
211300     EXEC SQL                                                     
211400          UPDATE CSS_MTRD_ENVRNMT                                 
211500          SET    CODE_DATA_PRESENT = :MN-CODE-DATA-PRESENT,       
211600                 LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :MN-LAST-UPDATE-TS
              )           
211700          WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP          
211800            AND  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE           
211900            AND  METER_NO          = :WS-METER-NO                 
212000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22570000
MFA-TR*         UPDATE CSS_MTRD_ENVRNMT                                 22580000
MFA-TR*         SET    CODE_DATA_PRESENT = :MN-CODE-DATA-PRESENT,       22590000
MFA-TR*                LAST_UPDATE_TS    = :MN-LAST-UPDATE-TS           22600000
MFA-TR*         WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP          22610000
MFA-TR*           AND  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE           22620000
MFA-TR*           AND  METER_NO          = :WS-METER-NO                 22630000
MFA-TR*    END-EXEC.                                                    22640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

212100*                                                                 22650000
212200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
212300     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
212400         NEXT SENTENCE                                            
212500     ELSE                                                         
CBSI           MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
212600         MOVE '8005'             TO ACTIVE-PARAGRAPH              
213400         MOVE 'UPDATE'           TO ABEND-FUNCTION                
213500                                    RS-RETURN-MESSAGE             
212700         MOVE SPACES             TO ABEND-TABLES                  
212800                                    ABEND-SQL-PREDICATES          
212900         MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                       
CBSI           MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
CBSI           MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
CBSI           MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
CBSI           MOVE WS-ACCOUNT-NO-COMP TO HOSTVAR-ELEMENT-1             
CBSI           MOVE WS-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
CBSI           MOVE WS-METER-NO        TO HOSTVAR-ELEMENT-3             
213600         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
213700     END-IF.                                                      
213800 8005-EXIT.                                                       
213900     EXIT.                                                        
214000*                                                                 22870000
214100*                                                                 22880000
214200******************************************************************22890000
214300* 8010-UPDATE_REG_READ.                                          *22900000
214400*       -- THIS MODULE UPDATES CSS_REGISTER_READ                 *22910000
214500******************************************************************22920000
214600*                                                                 22930000
214700 8010-UPDATE-REG-READ.                                            
214800     EXEC SQL                                                     
214900          UPDATE CSS_REGISTER_READ                                
215000          SET    CODE_REG_STATUS    = :RG-CODE-REG-STATUS,        
215100                 CODE_STATUS_REAS   = :RG-CODE-STATUS-REAS,       
215200                 LAST_READ_VALUE    = :RG-LAST-READ-VALUE,        
215300                 LAST_REG_READ_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :RG-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:RG-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-REG-READ-DT
              ), CONVERT(DATE, :RG-LAST-REG-READ-DT) ),       
215400                 LAST_REG_READ_TM   = CIS.CHAR2TIME(
                                                   :RG-LAST-REG-READ-TM
              ),       
215500                 CODE_LAST_REG_READ = :RG-CODE-LAST-REG-READ,     
215600                 LAST_VAL_RD_VALUE  = :RG-LAST-VAL-RD-VALUE,      
215700                 LAST_VALID_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                 :RG-LAST-VALID-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-VALID-READ-DT
              ) <> 0) OR (LEN(:RG-LAST-VALID-READ-DT
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-VALID-READ-DT
              ), CONVERT(DATE, :RG-LAST-VALID-READ-DT) ),     
215800                 LAST_VALID_READ_TM = CIS.CHAR2TIME(
                                                 :RG-LAST-VALID-READ-TM
              ),     
215900                 CODE_LAST_VALID_RD = :RG-CODE-LAST-VALID-RD,     
216000                 CODE_CRNT_REG_READ = :RG-CODE-CRNT-REG-READ,     
216100                 CODE_NO_RD_REASON  = :RG-CODE-NO-RD-REASON,      
216200                 LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :RG-LAST-UPDATE-TS
              ),         
216300                 REGISTER_RD_SEQ    = :RG-REGISTER-RD-SEQ         
216400          WHERE  ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP         
216500          AND    CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
216600          AND    MTR_REF_NO         = :WS-MTR-REF-NO              
216700          AND    REG_ID_NO          = :WS-REG-ID-NO               
216800          AND    CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD        
216900          AND    LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )          
217000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22950000
MFA-TR*         UPDATE CSS_REGISTER_READ                                22960000
MFA-TR*         SET    CODE_REG_STATUS    = :RG-CODE-REG-STATUS,        22970000
MFA-TR*                CODE_STATUS_REAS   = :RG-CODE-STATUS-REAS,       22980000
MFA-TR*                LAST_READ_VALUE    = :RG-LAST-READ-VALUE,        22990000
MFA-TR*                LAST_REG_READ_DT   = :RG-LAST-REG-READ-DT,       23000000
MFA-TR*                LAST_REG_READ_TM   = :RG-LAST-REG-READ-TM,       23010000
MFA-TR*                CODE_LAST_REG_READ = :RG-CODE-LAST-REG-READ,     23020000
MFA-TR*                LAST_VAL_RD_VALUE  = :RG-LAST-VAL-RD-VALUE,      23030000
MFA-TR*                LAST_VALID_READ_DT = :RG-LAST-VALID-READ-DT,     23040000
MFA-TR*                LAST_VALID_READ_TM = :RG-LAST-VALID-READ-TM,     23050000
MFA-TR*                CODE_LAST_VALID_RD = :RG-CODE-LAST-VALID-RD,     23060000
MFA-TR*                CODE_CRNT_REG_READ = :RG-CODE-CRNT-REG-READ,     23070000
MFA-TR*                CODE_NO_RD_REASON  = :RG-CODE-NO-RD-REASON,      23080000
MFA-TR*                LAST_UPDATE_TS     = :RG-LAST-UPDATE-TS,         23090000
MFA-TR*                REGISTER_RD_SEQ    = :RG-REGISTER-RD-SEQ         23100000
MFA-TR*         WHERE  ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP         23110000
MFA-TR*         AND    CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          23120000
MFA-TR*         AND    MTR_REF_NO         = :WS-MTR-REF-NO              23130000
MFA-TR*         AND    REG_ID_NO          = :WS-REG-ID-NO               23140000
MFA-TR*         AND    CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD        23150000
MFA-TR*         AND    LAST_UPDATE_TS     = :WS-LAST-UPDATE-TS          23160000
MFA-TR*    END-EXEC.                                                    23170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

217100*                                                                 23180000
217200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
217300     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
217400         NEXT SENTENCE                                            
217500     ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
A00839         MOVE '8010'               TO ACTIVE-PARAGRAPH            
218300         MOVE 'UPDATE'             TO ABEND-FUNCTION              
218400                                      RS-RETURN-MESSAGE           
217700         MOVE SPACES               TO ABEND-TABLES                
217800                                      ABEND-SQL-PREDICATES        
217900         MOVE 'CSS_REGISTER_READ ' TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
CBSI           MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-3             
CBSI           MOVE 'REG_ID_NO'          TO TABLE-ELEMENT-4             
CBSI           MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
CBSI           MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
CBSI           MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-3           
CBSI           MOVE WS-REG-ID-NO         TO HOSTVAR-ELEMENT-4           
218500         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
218600     END-IF.                                                      
218700*                                                                 23400000
218800 8010-EXIT.                                                       
218900     EXIT.                                                        
219000*                                                                 23430000
219100*                                                                 23440000
219200******************************************************************23450000
219300* 8020-DELETE-MTRD_ENV                                           *23460000
219400*       -- THIS MODULE DELETES ROWS FROM CSS_MTRD_ENVRNMT        *23470000
219500******************************************************************23480000
219600 8020-DELETE-MTRD-ENV.                                            
219700*                                                                 23500000
219800     EXEC SQL                                                     
219900          DELETE FROM CSS_MTRD_ENVRNMT                            
220000          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP              
220100            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
220200            AND METER_NO       = :WS-METER-NO                     
220300            AND LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )               
220400     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     23510000
MFA-TR*         DELETE FROM CSS_MTRD_ENVRNMT                            23520000
MFA-TR*         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP              23530000
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               23540000
MFA-TR*           AND METER_NO       = :WS-METER-NO                     23550000
MFA-TR*           AND LAST_UPDATE_TS = :WS-LAST-UPDATE-TS               23560000
MFA-TR*    END-EXEC.                                                    23570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

220500*                                                                 23580000
220600     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
220700     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
220800         NEXT SENTENCE                                            
220900     ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
221000         MOVE '8020'               TO ACTIVE-PARAGRAPH            
221700         MOVE 'DELETE'             TO ABEND-FUNCTION              
221800                                      RS-RETURN-MESSAGE           
221100         MOVE SPACES               TO ABEND-TABLES                
221200                                      ABEND-SQL-PREDICATES        
221300         MOVE 'CSS_MTRD_ENVRNMT  ' TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
CBSI           MOVE 'METER_NO'           TO TABLE-ELEMENT-3             
CBSI           MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-4             
CBSI           MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
221500         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
221600         MOVE WS-METER-NO          TO HOSTVAR-ELEMENT-3           
CBSI           MOVE WS-LAST-UPDATE-TS    TO HOSTVAR-ELEMENT-4           
221900         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
222000     END-IF.                                                      
222100*                                                                 23800000
222200 8020-EXIT.                                                       
222300     EXIT.                                                        
222400*                                                                 23830000
222500*                                                                 23840000
222600******************************************************************23850000
222700* 8030-DELETE-REG-READ                                           *23860000
222800*       -- THIS MODULE DELETES ROWS FROM CSS_REGISTER_READ       *23870000
222900******************************************************************23880000
223000 8030-DELETE-REG-READ.                                            
223100*                                                                 23900000
223200     EXEC SQL                                                     
223300          DELETE FROM CSS_REGISTER_READ                           
223400           WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           
223500             AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            
223600             AND MTR_REF_NO       = :WS-MTR-REF-NO                
223700             AND REG_ID_NO        = :WS-REG-ID-NO                 
223800             AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD          
223900             AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )            
224000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     23910000
MFA-TR*         DELETE FROM CSS_REGISTER_READ                           23920000
MFA-TR*          WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           23930000
MFA-TR*            AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            23940000
MFA-TR*            AND MTR_REF_NO       = :WS-MTR-REF-NO                23950000
MFA-TR*            AND REG_ID_NO        = :WS-REG-ID-NO                 23960000
MFA-TR*            AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD          23970000
MFA-TR*            AND LAST_UPDATE_TS   = :WS-LAST-UPDATE-TS            23980000
MFA-TR*    END-EXEC.                                                    23990000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

224100*                                                                 24000000
224200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
224300     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
224400         NEXT SENTENCE                                            
224500     ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
224600         MOVE '8030'               TO ACTIVE-PARAGRAPH            
225300         MOVE 'DELETE'             TO ABEND-FUNCTION              
225400                                      RS-RETURN-MESSAGE           
224700         MOVE SPACES               TO ABEND-TABLES                
224800                                      ABEND-SQL-PREDICATES        
224900         MOVE 'CSS_REGISTER_READ ' TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
CBSI           MOVE 'REG_ID_NO'          TO TABLE-ELEMENT-3             
CBSI           MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
CBSI           MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
CBSI           MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
CBSI           MOVE WS-REG-ID-NO         TO HOSTVAR-ELEMENT-3           
CBSI           MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
225500         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
225600     END-IF.                                                      
225700*                                                                 24220000
225800 8030-EXIT.                                                       
225900     EXIT.                                                        
T18805******************************************************************24250000
 START* 8040-DELETE-IRRGLR-MTR-RD                                      *24260000
      *       -- THIS MODULE DELETES ROWS FROM CSS_IRRGLR-MTR-RD       *24270000
      ******************************************************************24280000
       8040-DELETE-IRRGLR-MTR-RD.                                       
226000*                                                                 24300000
           EXEC SQL                                                     
                DELETE FROM CSS_IRRGLR_MTR_RD                           
                 WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           
                   AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            
                   AND METER_REF_NO       = :WS-MTR-REF-NO              
                   AND IC_NO            = :MN-IC-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24380000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8040'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
                                            RS-RETURN-MESSAGE           
               MOVE SPACES               TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
               MOVE 'CSS_IRRGLR-MTR-RD ' TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'IC_NO'              TO TABLE-ELEMENT-3             
               MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           
               MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 24600000
END    8040-EXIT.                                                       
T18805     EXIT.                                                        
T18805******************************************************************24630000
ST    * 8060-DELETE-REG-RD                                             *24640000
      *       -- THIS MODULE DELETES ROWS FROM CSS_REGISTER_READ       *24650000
      ******************************************************************24660000
       8060-DELETE-REG-RD.                                              
      *                                                                 24680000
           EXEC SQL                                                     
                DELETE FROM CSS_REGISTER_READ                           
                 WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           
                   AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            
                   AND MTR_REF_NO       = :WS-MTR-REF-NO                
                   AND REG_ID_NO        = :WS-REG-ID-NO                 
                   AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD          
                   AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     24690000
MFA-TR*         DELETE FROM CSS_REGISTER_READ                           24700000
MFA-TR*          WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO-COMP           24710000
MFA-TR*            AND CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE            24720000
MFA-TR*            AND MTR_REF_NO       = :WS-MTR-REF-NO                24730000
MFA-TR*            AND REG_ID_NO        = :WS-REG-ID-NO                 24740000
MFA-TR*            AND CODE_TIME_PERIOD = :WS-CODE-TIME-PERIOD          24750000
MFA-TR*            AND LAST_UPDATE_TS   = :WS-LAST-UPDATE-TS            24760000
MFA-TR*    END-EXEC.                                                    24770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24780000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8060'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
                                            RS-RETURN-MESSAGE           
               MOVE SPACES               TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
               MOVE 'CSS_REGISTER_READ ' TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'REG_ID_NO'          TO TABLE-ELEMENT-3             
               MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE WS-REG-ID-NO         TO HOSTVAR-ELEMENT-3           
               MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 25000000
END    8060-EXIT.                                                       
T18805     EXIT.                                                        
T18805******************************************************************25030000
ST    * 8070-DELMST-UTL-BILL-REL                                       *25040000
      *       -- THIS MODULE DELETES ROWS FROM CSS-UTL-BILL-REL IF     *25050000
      *       -- ACCOUNT IS MASTER ACCOUNT                             *25060000
      ******************************************************************25070000
P00251*8070-DELMST-UTL-BILL-REL.                                        25080000
      *                                                                 25090000
      *    EXEC SQL                                                     25100000
      *         DELETE FROM CSS_UTL_BILL_REL                            25110000
      *          WHERE ACCOUNT_NO_MST      = :WS-ACCOUNT-NO-COMP        25120000
      *            AND CODE_UTIL_TYPE_MST  = :WS-CODE-UTIL-TYPE         25130000
      *            AND MTR_REF_NO_MST      = :WS-MTR-REF-NO             25140000
      *            AND IC_NO_MST           = :MN-IC-NO                  25150000
      *    END-EXEC.                                                    25160000
      *                                                                 25170000
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       25180000
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  25190000
      *       NEXT SENTENCE                                             25200000
      *    ELSE                                                         25210000
      *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM               25220000
      *        MOVE '8070'               TO ACTIVE-PARAGRAPH            25230000
      *        MOVE 'DELETE'             TO ABEND-FUNCTION              25240000
      *                                     RS-RETURN-MESSAGE           25250000
      *        MOVE SPACES               TO ABEND-TABLES                25260000
      *                                     ABEND-SQL-PREDICATES        25270000
      *        MOVE 'CSS_UTL_BILL_REL '  TO TABLE-1                     25280000
      *        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             25290000
      *        MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             25300000
      *        MOVE 'IC_NO'               TO TABLE-ELEMENT-3            25310000
      *        MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             25320000
      *        MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           25330000
      *        MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           25340000
      *        MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           25350000
      *        MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           25360000
      *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            25370000
      *    END-IF.                                                      25380000
      *                                                                 25390000
P00251*8070-EXIT.                                                       25400000
P00251*    EXIT.                                                        25410000
T18805******************************************************************25420000
ST    * 8080-DELDEP-UTL-BILL-REL                                       *25430000
      *       -- THIS MODULE DELETES ROWS FROM CSS-UTL-BILL-REL        *25440000
      *       -- ACCOUNT IS DEPENDENT ACCOUNT                          *25450000
      ******************************************************************25460000
P00251*8080-DELDEP-UTL-BILL-REL.                                        25470000
      *                                                                 25480000
      *    EXEC SQL                                                     25490000
      *         DELETE FROM CSS_UTL_BILL_REL                            25500000
      *          WHERE ACCOUNT_NO_DEP      = :WS-ACCOUNT-NO-COMP        25510000
      *            AND CODE_UTIL_TYPE_DEP  = :WS-CODE-UTIL-TYPE         25520000
      *            AND MTR_REF_NO_DEP      = :WS-MTR-REF-NO             25530000
      *            AND IC_NO_DEP           = :MN-IC-NO                  25540000
      *    END-EXEC.                                                    25550000
      *                                                                 25560000
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       25570000
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  25580000
      *       NEXT SENTENCE                                             25590000
      *    ELSE                                                         25600000
      *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM               25610000
      *        MOVE '8080'               TO ACTIVE-PARAGRAPH            25620000
      *        MOVE 'DELETE'             TO ABEND-FUNCTION              25630000
      *                                     RS-RETURN-MESSAGE           25640000
      *        MOVE SPACES               TO ABEND-TABLES                25650000
      *                                     ABEND-SQL-PREDICATES        25660000
      *        MOVE 'CSS_UTL_BILL_REL '  TO TABLE-1                     25670000
      *        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             25680000
      *        MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             25690000
      *        MOVE 'IC_NO'               TO TABLE-ELEMENT-3            25700000
      *        MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             25710000
      *        MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           25720000
      *        MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           25730000
      *        MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           25740000
      *        MOVE WS-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           25750000
      *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            25760000
      *    END-IF.                                                      25770000
      *                                                                 25780000
P00251*8080-EXIT.                                                       25790000
P00251*    EXIT.                                                        25800000
A00839                                                                  
A00839******************************************************************25801100
A00839* 8100-UPDATE-ACCT-WHT-CROSS                                     *25802000
A00839*          UPDATE GIS-POINT-ID IN CSS_ACCT_WHT_CROSS             *25803000
A00839******************************************************************25805000
A00839 8100-UPDATE-ACCT-WHT-CROSS.                                      
A00839                                                                  
A00839     EXEC SQL                                                     
A00839        UPDATE CSS_ACCT_WHT_CROSS                                 
A00839           SET GIS_POINT_ID     = :WH-GIS-POINT-ID                
A00839         WHERE ACCOUNT_NO       = :WH-ACCOUNT-NO                  
A00839     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00839*                                                                 25809800
A00839     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00839*                                                                 25810000
A00839     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00839        NEXT SENTENCE                                             
A00839     ELSE                                                         
A00839        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
A00839        MOVE '8100'                        TO ACTIVE-PARAGRAPH    
A00839        MOVE 'UPDATE'                      TO ABEND-FUNCTION      
A00839        MOVE SPACES                        TO ABEND-SQL-PREDICATES
A00839                                              ABEND-TABLES        
A00839        MOVE 'CSS_ACCT_WHT_CROSS'          TO TABLE-1             
A00839        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
A00839        MOVE WH-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
A00839        MOVE 'GIS-POINT-ID'                TO TABLE-ELEMENT-2     
A00839        MOVE WH-GIS-POINT-ID               TO HOSTVAR-ELEMENT-2   
A00839        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
A00839        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
A00839     END-IF.                                                      
A00839                                                                  
A00839 8100-EXIT.                                                       
A00839     EXIT.                                                        
C30989*                                                                 25813000
C30989******************************************************************25820000
C30989* 8110-DELETE-BILL-MSG                                           *25830000
C30989******************************************************************25840000
C30989 8110-DELETE-BILL-MSG.                                            
C30989     EXEC SQL                                                     
C30989        DELETE FROM CSS_SPCL_BILL_MSG                             
C30989         WHERE ACCOUNT_NO       = :U1-ACCOUNT-NO                  
C30989           AND BILL_MSG_ID      = :U1-BILL-MSG-ID                 
C30989           AND MSG_TYPE_CD      = :U1-MSG-TYPE-CD                 
C30989           AND REVENUE_MO_END  >= :U1-REVENUE-MO-END              
C30989     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30989*                                                                 25930000
C30989     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30989*                                                                 25950000
C30989     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30989        NEXT SENTENCE                                             
C30989     ELSE                                                         
C30989        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
C30989        MOVE '8110'                        TO ACTIVE-PARAGRAPH    
C30989        MOVE 'DELETE'                      TO ABEND-FUNCTION      
C30989        MOVE SPACES                        TO ABEND-SQL-PREDICATES
C30989                                              ABEND-TABLES        
C30989        MOVE 'CSS_SPCL_BILL_MSG'           TO TABLE-1             
C30989        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
C30989        MOVE U1-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
C30989        MOVE 'BILL_MSG_ID'                 TO TABLE-ELEMENT-2     
C30989        MOVE U1-BILL-MSG-ID                TO HOSTVAR-ELEMENT-2   
C30989        MOVE 'MSG_TYPE_CD'                 TO TABLE-ELEMENT-3     
C30989        MOVE U1-MSG-TYPE-CD                TO HOSTVAR-ELEMENT-3   
C30989        MOVE 'REVENUE_MO_END'              TO TABLE-ELEMENT-4     
C30989        MOVE U1-REVENUE-MO-END             TO HOSTVAR-ELEMENT-4   
C30989        PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
C30989        PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
C30989     END-IF.                                                      
C30989                                                                  
C30989 8110-EXIT.                                                       
C30989     EXIT.                                                        
C30989*                                                                 26190000
C30989******************************************************************26200000
C30989* 8120-INSERT-BILL-MSG                                           *26210000
C30989******************************************************************26220000
C30989 8120-INSERT-BILL-MSG.                                            
C30989     EXEC SQL                                                     
C30989       INSERT INTO CSS_SPCL_BILL_MSG                              
C30989            ( REVENUE_MO_ST                                       
C30989             ,ACCOUNT_NO                                          
C30989             ,BILL_MSG_ID                                         
C30989             ,MSG_TYPE_CD                                         
C30989             ,COMPANY_NO                                          
C30989             ,BILL_CYCLE_ST                                       
C30989             ,BILL_CYCLE_END                                      
C30989             ,REVENUE_MO_END )                                    
C30989      VALUES (:U1-REVENUE-MO-ST                                   
C30989             ,:U1-ACCOUNT-NO                                      
C30989             ,:U1-BILL-MSG-ID                                     
C30989             ,:U1-MSG-TYPE-CD                                     
C30989             ,:U1-COMPANY-NO                                      
C30989             ,:U1-BILL-CYCLE-ST                                   
C30989             ,:U1-BILL-CYCLE-END                                  
C30989             ,:U1-REVENUE-MO-END )                                
C30989     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30989*                                                                 26430000
C30989     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30989*                                                                 26450000
C30989     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
C30989        NEXT SENTENCE                                             
C30989     ELSE                                                         
C30989        MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
C30989        MOVE '8120'                        TO ACTIVE-PARAGRAPH    
C30989        MOVE 'INSERT'                      TO ABEND-FUNCTION      
C30989        MOVE SPACES                        TO ABEND-SQL-PREDICATES
C30989                                              ABEND-TABLES        
C30989        MOVE 'CSS_SPCL_BILL_MSG'           TO TABLE-1             
C30989        MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
C30989        MOVE U1-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
C30989        MOVE 'BILL_MSG_ID'                 TO TABLE-ELEMENT-2     
C30989        MOVE U1-BILL-MSG-ID                TO HOSTVAR-ELEMENT-2   
C30989        MOVE 'REVENUE_MO_END'              TO TABLE-ELEMENT-3     
C30989        MOVE U1-REVENUE-MO-END             TO HOSTVAR-ELEMENT-3   
C30989        PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
C30989        PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
C30989     END-IF.                                                      
C30989                                                                  
C30989 8120-EXIT.                                                       
C30989     EXIT.                                                        
226100*                                                                 26670000
226200******************************************************************26680000
226300* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *26690000
226400******************************************************************26700000
REARCH     EXEC SQL                                                     26710000
REARCH        INCLUDE CPDSP300                                          26720000
REARCH     END-EXEC.                                                    26730000
226800******************************************************************26740000
226900* 9999- END PROGRAM COPYLIB                                      *26750000
227000******************************************************************26760000
REARCH     EXEC SQL                                                     26770000
REARCH        INCLUDE CPD00321                                          26780000
REARCH     END-EXEC.                                                    26790000
227300                                                                  
