       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02076.                                         
COB303 DATE-WRITTEN.      APRIL 17, 1995.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:     S076                                              *00120000
      *  PROGRAM:    S076                                              *00130000
      *  CALLING SP: PA_S076                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES METER AND REGISTER READ DATA.        *00190000
      *  THIS INFORMATION EXISTS TO SUPPORT THE MANAGEMENT OF THE      *00200000
      *  REGISTER INFORMATION.                                         *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  04/17/95    MAR      PROCEDURE ORIGINALLY CODED.              *00280000
      *  06/16/95    HC       7200- SELECT WHERE CLAUSE MODIFIED TO    *00290000
      *                       INCLUDE REG-ID-NO. THIS FIXED TPR 5684   *00300000
      *                       7400- MOVE LOW-VALUES TO DATE IF SQLCODE *00310000
      *                       = NOT-FOUND. THIS FIXED TPR 5683         *00320000
      *  06/27/95    PD       NULL INDICATORS ADDED TO                 *00330000
      *                       WS-DATE-LAST-TESTED                      *00340000
      *  10/09/95    ECC      ADDED REGISTER READ SEQ TO RESULT SET    *00350000
      *  02/01/96    WMG      ADDED :WS-CODE-UTIL-TYPE AS A PREDICATE  *00370000
      *                       IN PARAGRAPH 7300 TO IMPROVE PERFORMANCE.*00380000
      *  06/20/96    JHR      TPR 4637 - ADDED THE 7200 PERFORM CALL   *00381000
      *                       IN PARAGRAPH 5130 IN ORDER TO CORRECTLY  *00382000
      *                       RETURN THE REGISTER'S CONSTANT AND DIALS.*00390000
      *  08/28/96    JEP      TPR 2570 - MODIFY SELECT ON CSS_ELEC_    *00390100
      *                       METER TO INCLUDE THE RETRIEVAL ARGUMENT  *00390200
      *                       "ELEC_MTR_SPEC_CD". ADD SELECT FOR CSS_  *00390300
      *                       ELEC_MTR_SPEC TO RETRIEVE "AMR_CAP_FL".  *00390400
T4755 *  11/06/96  CSG        CHANGE DEFINITION OF POINT-ID WORKING    *00390500
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *00390600
      *                                                                *00391000
D2137 *  01/30/97  JPC        MODIFY SELECT OF AMR_FLAG TO ACCOMODATE  *00392000
D2137 *                       D2137.  ADDITIONAL LOGIC WILL BE CODED   *00393000
D2137 *                       WITH PCR487.                             *00393100
T15712*  04/01/98  TDK        CORRECTED MC05 REPORT ABEND INFORMATION  *00393200
T16866*  06/22/98  TDK        IF RD_TIME IS 12:00 AM, ADD 1 TO DATE    *00393200
CBSI  *  07/27/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19090*  04/22/99    CBSI     PARAMETERS IC_NO AND MTR_REF_NO ADDED    *        
T19090*              MADRAS                                            *        
T22243*  07/26/00    CBSI     CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*              MADRAS   IN METER INVENTORY.                      *        
T27236*  09/19/02    SR82046  CHANGED TO INCLUDE INDUST BTU ID FOR CIG *        
T27236*                       CUSTOMERS AND PROGRAM ID FOR ITRON.      *        
T26134*  11/18/00    COVANSYS TO ALLOW THE PROGRAM TO REFER            *        
T26134*                       CSS_CNSMPTN_HIST WHEN CSS_MTR_CAP NOT    *        
T26134*                       FOUND                                    *        
C27236*  01/14/03    MSR      CHANGED THE HARD CODED VALUE TO CHECK FOR*        
C27236*                       CIG CUSTOMERS.                           *        
C24056*  03/04/03    DPS      OMS REVISIONS. USING GIS-POINT-ID INSTEAD*        
C24056*                       OF POINT-ID                                       
T28824*  12/03/04    VD88125 INCLUDED STANDARD COPYBOOK FOR CALCULATING*        
T28824*                       NEXT READ DATE(CPD00310) INSTEAD 7400-GET*        
C28373*  01/31/05    SG18894  CHANGES MADE TO LOOK FOR AMR MODULE AND  *        
C28373*                       SET THE AMR-CAP FLAG                     *        
C30989*  04/06/05    JAYANTHI ADDED METER_PRESSURE TO RESULTSET FOR    *        
C30989*                       AMR READONE LINK CIS PROJECT             *        
C32936*  07/06/05    VD88125  CHANGES MADE TO FIX -100 RETURN CODE FOR *        
C32936*                       INVALID SNE-POINTS.                               
REARCH*  09/08/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
C33887*  05/01/08   PC97415   ADDING FIELDS METER_SIZE_DESC,           *        
C33887*                       MECHANICAL_DIAL_FL AND AMR DETAIL FIELDS *        
C37440*  07/23/08   JC91900   PB 11.0 CONVERSION ISSUES.               *        
P33743*  09/16/08   SC41135   POINT ID PROJECT - REPLACED SNE_POINT    *        
P33743*                       WITH CSS_PIM_POINT TABLE                 *        
C34590*  09/24/08   MA96833   ADDED ELEC_MTR_FORM_CD,MTR_CONNECT_TYP_ID*        
C34590*  09/24/08   MA96833   NO_PHASES,CCF_CAP_PER_HRTO RESULT SET    *        
A00714*  02/21/09   NC94746   HANDLE NOT FOUND CONDITION WHILE FETCHING*        
A00714*                       FROM GAS/ELECTRIC METER TABLES.          *        
P00545*  08/15/11   VP43661   ADDED GIS_MISMATCH_FL TO RESULT SET      *        
      ******************************************************************00400000
      ******************************************************************00410000
      *                                                                *00420000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00430000
      *                                                                *00440000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00450000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00460000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00470000
      *  3000 - 4999  NOT USED                                         *00480000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00490000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00500000
      *  7000 - 7999  INPUT MODULES                                    *00510000
      *  8000 - 8999  OUTPUT MODULES                                   *00520000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00530000
      *                                                                *00540000
      ******************************************************************00550000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02076'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02076 STARTS HERE'.                  
                                                                        
      ******************************************************************00640000
      *    DB2 INCLUDES                                                *00650000
      ******************************************************************00660000
      *                                                                 00670000
           EXEC SQL                                                     00680000
              INCLUDE SQLCA                                             00690000
           END-EXEC.                                                    00700000
      *                                                                 00710000
           EXEC SQL                                                     00720000
              INCLUDE TBMODEL                                           00730000
           END-EXEC.                                                    00740000
      *                                                                 00741000
T28824     EXEC SQL                                                     00742000
T28824        INCLUDE TBACCT                                            00743000
T28824     END-EXEC.                                                    00744000
T28824*                                                                 00750000
           EXEC SQL                                                     00742000
              INCLUDE TBEMTRSP                                          00743000
           END-EXEC.                                                    00744000
      *                                                                 00750000
           EXEC SQL                                                     00760000
              INCLUDE TBUTLENV                                          00770000
           END-EXEC.                                                    00780000
      *                                                                 00790000
           EXEC SQL                                                     00800000
              INCLUDE TBMTRENV                                          00810000
           END-EXEC.                                                    00820000
      *                                                                 00830000
           EXEC SQL                                                     00840000
              INCLUDE TBRGREAD                                          00850000
           END-EXEC.                                                    00860000
      *                                                                 00870000
           EXEC SQL                                                     00880000
              INCLUDE TBMTRCAP                                          00890000
           END-EXEC.                                                    00900000
      *                                                                 00910000
           EXEC SQL                                                     00920000
              INCLUDE TBELMTR                                           00930000
           END-EXEC.                                                    00940000
      *                                                                 00950000
           EXEC SQL                                                     00960000
              INCLUDE TBGASMTR                                          00970000
           END-EXEC.                                                    00980000
      *                                                                 00990000
           EXEC SQL                                                     01000000
              INCLUDE TBRDWNDW                                          01010000
           END-EXEC.                                                    01020000
      *                                                                 01030000
           EXEC SQL                                                     01040000
              INCLUDE TBMTRVAL                                          01050000
           END-EXEC.                                                    01060000
      *                                                                 01070000
T26134     EXEC SQL                                                     01040000
T26134        INCLUDE TBCNSMP                                           01050000
T26134     END-EXEC.                                                    01060000
T26134*                                                                 01070000
C33743* CSS_PIM_POINT TABLE                                                     
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
C33743*                                                                         
C28373* CSS_METER_ATTCHMTS                                                      
C28373     EXEC SQL                                                             
C28373        INCLUDE TBMTRATT                                                  
C28373     END-EXEC.                                                            
C28373*                                                                         
C33887     EXEC SQL                                                     01000000
C33887        INCLUDE TBEMTRSZ                                          01010000
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
C33887     EXEC SQL                                                     01000000
C33887        INCLUDE TBMTRPGM                                          01010000
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
C33887     EXEC SQL                                                     01000000
C33887        INCLUDE TBMTRATP                                          01010000
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
C33887     EXEC SQL                                                     01000000
C33887        INCLUDE TBCDVALU                                          01010000
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
C33887     EXEC SQL                                                     01000000
C33887        INCLUDE TBEQATTH                                          01010000
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
C34590*                                                                         
C34590     EXEC SQL                                                             
C34590        INCLUDE TBEMTRCL                                                  
C34590     END-EXEC.                                                            
C34590*                                                                         
C34590     EXEC SQL                                                             
C34590        INCLUDE TBGASMSZ                                                  
C34590     END-EXEC.                                                            
C34590*                                                                         
C34590     EXEC SQL                                                             
C34590        INCLUDE TBELCLSP                                                  
C33887     END-EXEC.                                                    01020000
C33887*                                                                 00990000
      ******************************************************************01090000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01100000
      ******************************************************************01110000
                                                                        
REARCH*    COPY SYGWCOB.                                                01130000
REARCH*    COPY SYDBCOB.                                                01140000
           COPY CCA00001.                                               01150000
REARCH*    COPY CWS00010.                                               01160000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01170000
           COPY CWS00303.                                               01180000
                                                                        
      ******************************************************************01200000
      *    WORK AREAS                                                  *01210000
      ******************************************************************01220000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01240000
REARCH*    05  GWL-PROC                   POINTER.                      01250000
REARCH*    05  GWL-INIT-HANDLE            POINTER.                      01260000
REARCH*    05  GWL-RC                     PIC S9(9) COMP.               01270000
REARCH*    05  GWL-STATUS-NR              PIC S9(9) COMP.               01280000
REARCH*    05  GWL-STATUS-DONE            PIC S9(9) COMP.               01290000
REARCH*    05  GWL-STATUS-COUNT           PIC S9(9) COMP.               01300000
REARCH*    05  GWL-STATUS-COMM            PIC S9(9) COMP.               01310000
REARCH*    05  GWL-STATUS-RETURN-CODE     PIC S9(9) COMP.               01320000
REARCH*    05  GWL-STATUS-SUBCODE         PIC S9(9) COMP.               01330000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02076_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH 01  FILLER                         PIC X(11) VALUE 'PARM FIELDS'.
                                                                        
REARCH*01  PARM-FIELDS.                                                 01370000
REARCH*    05  PARM-L                     PIC S9(9) COMP.               01380000
REARCH*    05  PARM-ID1                   PIC S9(9) COMP VALUE 0.       01390000
REARCH*    05  PARM-ACCOUNT-NO            PIC X(13)      VALUE SPACES.  01400000
REARCH*    05  PARM-CUSTOMER-NO           PIC X(10)      VALUE SPACES.  01410000
REARCH*    05  PARM-PREMISE-NO            PIC X(10)      VALUE SPACES.  01420000
REARCH*    05  PARM-CODE-UTIL-TYPE        PIC X(1)       VALUE SPACES.  01430000
REARCH*    05  PARM-METER-NO              PIC X(9)       VALUE SPACES.  01440000
REARCH*    05  PARM-IC-NO                 PIC S9(04) COMP.                      
REARCH*    05  PARM-MTR-REF-NO            PIC S9(04) COMP.                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
           05  SNA-CONNECTION-NAME        PIC X(8)  VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
           05  WRKLEN1                    PIC S9(9) COMP.               
           05  WRKLEN2                    PIC S9(9) COMP.               
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 01620000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-METER-DETAILS.                                        
               10 RS-LAST-UPDATE-TS       PIC X(26).                    
               10 RS-METER-NO             PIC X(9).                     
               10 RS-MTR-REF-NO           PIC S9(4) COMP.               
               10 RS-DATE-MTR-INSTALL     PIC X(10).                    
               10 RS-POINT-ID             PIC X(10).                    
               10 RS-DIGTL-MTR-TYPE       PIC X(3).                     
               10 RS-METER-SUPPLYING      PIC X(15).                    
               10 RS-CODE-METER-LOC       PIC X(2).                     
               10 RS-DATE-LAST-TESTED     PIC X(10).                    
               10 RS-AMR-CAP-FL           PIC X.                        
               10 RS-NO-CONSEC-ESTIMATE   PIC S9(4) COMP.               
               10 RS-NO-CONSEC-CRD-READ   PIC S9(4) COMP.               
               10 RS-MTR-READ-SOURCE-CD   PIC X(1).                     
               10 RS-OPTIMUM-READ-DATE    PIC X(10).                    
               10 RS-HEXAGRAM-LOCATION    PIC X(2).                     
               10 RS-MONTHS-INACTIVE      PIC S9(4) COMP.               
               10 RS-SEAL-CODE-ID         PIC X(1).                     
               10 RS-INSULATED-IND        PIC X(1).                     
               10 RS-LOCK-TYPE-ID         PIC X(1).                     
               10 RS-IDR-RECIPIENT-CD     PIC X(1).                     
               10 RS-DELIVERY-LEVEL-CD    PIC X(1).                     
               10 RS-UTILITY-SOURCE-CD    PIC X(1).                     
               10 RS-REMOTE-READ-IND      PIC X(1).                     
C27236         10 RS-PROGRAM-ID           PIC X(02).                    
C27236         10 RS-INDUST-BTU-ID        PIC X(03).                    
COB305         10 RS-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 RS-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.      
C27236         10 RS-INDUS-GAS-CUST       PIC X(01).                    
C24056         10 RS-GIS-POINT-ID         PIC S9(9)  USAGE COMP.        
C33887         10 RS-METER-SIZE-DESC      PIC X(13).                    
C33887         10 RS-MECHANICAL-DIAL-FL   PIC X(01).                    
P00545         10 RS-GIS-MISMATCH-FL      PIC X(01).                    
P00545*                                                                         
           05  RS-REGISTER-DETAILS.                                     
               10 RS-REG-ID-NO            PIC S9(4) COMP.               
               10 RS-CODE-TIME-PERIOD     PIC S9(4) COMP.               
COB305         10 RS-CONSTANT        PIC S999999V999 COMP-3 VALUE 0.       
               10 RS-NO-READ-DIALS        PIC S9(4) COMP.               
               10 RS-CODE-REG-STATUS      PIC X(1).                     
               10 RS-CODE-STATUS-REAS     PIC X(1).                     
               10 RS-METER-USAGE-DESC     PIC X(35).                    
               10 RS-CODE-USAGE-TYPE      PIC X(3).                     
COB305         10 RS-LAST-READ-VALUE        PIC S9(12)V999 COMP-3 
COB305           VALUE 0.        
               10 RS-LAST-REG-READ-DT     PIC X(10).                    
               10 RS-LAST-REG-READ-TM     PIC X(8).                     
               10 RS-CODE-LAST-REG-READ   PIC X(1).                     
COB305         10 RS-LAST-VAL-RD-VALUE        PIC S9(12)V999 COMP-3 
COB305           VALUE 0.        
               10 RS-LAST-VALID-READ-DT   PIC X(10).                    
               10 RS-LAST-VALID-READ-TM   PIC X(8).                     
               10 RS-CODE-LAST-VALID-RD   PIC X(1).                     
               10 RS-CODE-CRNT-REG-READ   PIC X(1).                     
               10 RS-CODE-NO-RD-REASON    PIC X(1).                     
               10 RS-CODE-MTR-RD-INST1    PIC X(2).                     
               10 RS-CODE-MTR-RD-INST2    PIC X(2).                     
               10 RS-CODE-MTR-RD-INST3    PIC X(2).                     
REARCH         10 RS-REGISTER-RD-SEQ      PIC S9(09) COMP.              
C30989         10 RS-METER-PRESSURE       PIC X(03).                    
C33887         10 RS-DEVICE-NO            PIC X(12).                    
C33887         10 RS-CODE-ATT-TYPE        PIC X(02).                    
C33887         10 RS-CODE-SHORT-DESC      PIC X(15).                    
C33887         10 RS-MTR-ATT-TYPE-TX      PIC X(25).                    
C34590         10 RS-ELEC-MTR-FORM-CD     PIC X(4).                     
C34590         10 RS-MTR-CONNECT-TYP-ID   PIC X(10).                    
C34590         10 RS-NO-PHASES            PIC X(1).                     
C34590         10 RS-CCF-CAP-PER-HR       PIC S9(09)  COMP VALUE 0.     
      *                                                                 02090000
           05  RS-RETURN-CODE             PIC S9(09) COMP VALUE 0.      
      *                                                                 02110000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-METER-DETAILS.                                        
REARCH         10  S-LAST-UPDATE-TS       PIC X(26).                    
REARCH         10  S-METER-NO             PIC X(9).                     
REARCH         10  S-MTR-REF-NO           PIC S9(4) COMP.               
REARCH         10  S-DATE-MTR-INSTALL     PIC X(10).                    
REARCH         10  S-POINT-ID             PIC X(10).                    
REARCH         10  S-DIGTL-MTR-TYPE       PIC X(3).                     
REARCH         10  S-METER-SUPPLYING      PIC X(15).                    
REARCH         10  S-CODE-METER-LOC       PIC X(2).                     
REARCH         10  S-DATE-LAST-TESTED     PIC X(10).                    
REARCH         10  S-AMR-CAP-FL           PIC X.                        
REARCH         10  S-NO-CONSEC-ESTIMATE   PIC S9(4) COMP.               
REARCH         10  S-NO-CONSEC-CRD-READ   PIC S9(4) COMP.               
REARCH         10  S-MTR-READ-SOURCE-CD   PIC X(1).                     
REARCH         10  S-OPTIMUM-READ-DATE    PIC X(10).                    
REARCH         10  S-HEXAGRAM-LOCATION    PIC X(2).                     
REARCH         10  S-MONTHS-INACTIVE      PIC S9(4) COMP.               
REARCH         10  S-SEAL-CODE-ID         PIC X(1).                     
REARCH         10  S-INSULATED-IND        PIC X(1).                     
REARCH         10  S-LOCK-TYPE-ID         PIC X(1).                     
REARCH         10  S-IDR-RECIPIENT-CD     PIC X(1).                     
REARCH         10  S-DELIVERY-LEVEL-CD    PIC X(1).                     
REARCH         10  S-UTILITY-SOURCE-CD    PIC X(1).                     
REARCH         10  S-REMOTE-READ-IND      PIC X(1).                     
REARCH         10  S-PROGRAM-ID           PIC X(02).                    
REARCH         10  S-INDUST-BTU-ID        PIC X(03).                    
COB305         10 S-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.      
COB305         10 S-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.      
REARCH         10  S-INDUS-GAS-CUST       PIC X(01).                    
REARCH         10  S-GIS-POINT-ID         PIC S9(9)  USAGE COMP.        
C33887         10  S-METER-SIZE-DESC      PIC X(13).                    
C33887         10  S-MECHANICAL-DIAL-FL   PIC X(01).                    
P00545         10  S-GIS-MISMATCH-FL      PIC X(01).                    
REARCH     05   S-REGISTER-DETAILS.                                     
REARCH         10  S-REG-ID-NO            PIC S9(4) COMP.               
REARCH         10  S-CODE-TIME-PERIOD     PIC S9(4) COMP.               
COB305         10 S-CONSTANT        PIC S999999V999 COMP-3 VALUE 0.       
REARCH         10  S-NO-READ-DIALS        PIC S9(4) COMP.               
REARCH         10  S-CODE-REG-STATUS      PIC X(1).                     
REARCH         10  S-CODE-STATUS-REAS     PIC X(1).                     
REARCH         10  S-METER-USAGE-DESC     PIC X(35).                    
REARCH         10  S-CODE-USAGE-TYPE      PIC X(3).                     
COB305         10 S-LAST-READ-VALUE        PIC S9(12)V999 COMP-3 
COB305           VALUE 0.        
REARCH         10  S-LAST-REG-READ-DT     PIC X(10).                    
REARCH         10  S-LAST-REG-READ-TM     PIC X(8).                     
REARCH         10  S-CODE-LAST-REG-READ   PIC X(1).                     
COB305         10 S-LAST-VAL-RD-VALUE        PIC S9(12)V999 COMP-3 
COB305           VALUE 0.        
REARCH         10  S-LAST-VALID-READ-DT   PIC X(10).                    
REARCH         10  S-LAST-VALID-READ-TM   PIC X(8).                     
REARCH         10  S-CODE-LAST-VALID-RD   PIC X(1).                     
REARCH         10  S-CODE-CRNT-REG-READ   PIC X(1).                     
REARCH         10  S-CODE-NO-RD-REASON    PIC X(1).                     
REARCH         10  S-CODE-MTR-RD-INST1    PIC X(2).                     
REARCH         10  S-CODE-MTR-RD-INST2    PIC X(2).                     
REARCH         10  S-CODE-MTR-RD-INST3    PIC X(2).                     
REARCH         10  S-REGISTER-RD-SEQ      PIC S9(09) COMP.              
REARCH         10  S-METER-PRESSURE       PIC X(03).                    
C33887         10  S-DEVICE-NO            PIC X(12).                    
C33887         10  S-CODE-ATT-TYPE        PIC X(02).                    
C33887         10  S-CODE-SHORT-DESC      PIC X(15).                    
C33887         10  S-MTR-ATT-TYPE-TX      PIC X(25).                    
C34590         10  S-ELEC-MTR-FORM-CD     PIC X(4).                     
C34590         10  S-MTR-CONNECT-TYP-ID   PIC X(10).                    
C34590         10  S-NO-PHASES            PIC X(1).                     
C34590         10  S-CCF-CAP-PER-HR       PIC S9(09)  COMP VALUE 0.     
REARCH*                                                                 02090000
REARCH     05   S-RETURN-CODE             PIC S9(09) COMP VALUE 0.      
REARCH*                                                                 02110000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
           05  REGISTER-SW                PIC X(01) VALUE ' '.          
               88 NO-REGISTER-DETAILS               VALUE ' '.          
               88 REGISTER-DETAILS                  VALUE 'A'.          
C28373     05  WS-AMR-MODULE-EXISTS       PIC X(01) VALUE ' '.          
C28373         88 AMR-MODULE-EXISTS                 VALUE 'Y'.          
      *                                                                 03120000
       01  WS-PROGRAM-NAME.                                             
REARCH     05  PROGRAM-NAME               PIC X(08) VALUE 'CSR02076'.   
REARCH     05  WS-SQLSTATE                PIC X(05)  VALUE  SPACES.     
      *                                                                 03150000
       01  STORAGE-FIELDS.                                              
           05  WS-PARM-FIELDS.                                          
               10 WS-ACCOUNT-NO.                                        
                  11 WS-ACCOUNT-NO-N      PIC S9(13)V.                  
COB305         10 WS-ACCOUNT-NO-COMP        PIC S9(13)V COMP-3 VALUE 0.         
               10 WS-CUSTOMER-NO.                                       
                  11 WS-CUSTOMER-NO-N     PIC S9(10)V.                  
COB305         10 WS-CUSTOMER-NO-COMP        PIC S9(10)V COMP-3 VALUE 0.        
               10 WS-PREMISE-NO.                                        
                  11 WS-PREMISE-NO-N      PIC S9(10)V.                  
COB305         10 WS-PREMISE-NO-COMP        PIC S9(10)V COMP-3 VALUE 0.         
               10 WS-CODE-UTIL-TYPE       PIC X(1).                     
               10 WS-METER-NO             PIC X(9).                     
T19090         10 WS-IC-NO                PIC S9(04) COMP.              
T19090         10 WS-MTR-REF-NO           PIC S9(04) COMP.              
               10 WS-RUN-DATE             PIC X(10).                    
               10 WS-LAST-UPDATE-TS       PIC X(26).                    
               10 WS-DATE-LAST-TESTED     PIC X(10).                    
TP2570         10 WS-E-MTR-SPEC-CD        PIC X(3).                     
TP2570         10 WS-AMR-CAP-FL           PIC X.                        
C27236         10 WS-INDUS-GAS-CUSTOMER   PIC X(01) VALUE 'N'.          
C30989         10 WS-METER-PRESSURE       PIC 9(03).                    
A00714         10 WS-E-MTR-CLASS-CD       PIC X(2).                     
           05  WS-USAGE.                                                
               10 WS-USAGE-ID             PIC X.                        
               10 WS-USAGE-TYPE           PIC X.                        
               10 WS-USAGE-SOURCE         PIC X.                        
               10 WS-METER-USAGE-DESC     PIC X(35).                    
               10 WS-USAGE-TYPE-DESC      PIC X(3).                     
           05  WS-DERIVED-FIELDS.                                       
               10 WS-READ-CYCLE           PIC X(02).                    
               10 WS-INACTIVE-YEAR        PIC S9(2)   COMP.             
               10 WS-INACTIVE-MONTH       PIC S9(2)   COMP.             
           05  WS-NULL-INDICATORS.                                      
               10 WS-NULL-IND-1           PIC S9(04)  COMP.             
               10 WS-NULL-IND-2           PIC S9(04)  COMP.             
               10 WS-NULL-IND-3           PIC S9(04)  COMP.             
               10 WS-NULL-IND-4           PIC S9(04)  COMP.             
               10 WS-NULL-IND-5           PIC S9(04)  COMP.             
               10 WS-NULL-IND-6           PIC S9(04)  COMP.             
               10 WS-NULL-IND-7           PIC S9(04)  COMP.             
               10 WS-DATE-LAST-NULL       PIC S9(04)  COMP.             
T28824         10 WS-NULL-IND-CPD         PIC S9(04)  COMP.             
T28824         10 WS-CPD310-NULL-IND      PIC S9(04)  COMP.             
T16866     05  WS-DATE-READ               PIC X(10).                    
T22243     05  WS-DEFAULT-COMPANY-NO      PIC X(02).                    
T28824     05  WS-DATE-CCYY-MM-DD.                                      
T28824         10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
T28824         10  FILLER             PIC X(01) VALUE SPACES.           
T28824         10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
T28824         10  FILLER             PIC X(01) VALUE SPACES.           
T28824         10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
T28824     05  WS-DATE-MM-DD-YYYY.                                      
T28824         10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
T28824         10  FILLER             PIC X(01) VALUE '/'.              
T28824         10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
T28824         10  FILLER             PIC X(01) VALUE '/'.              
T28824         10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
C33887     05  WS-E-METER-SIZE-ID     PIC X(08) VALUE SPACES.           
C33887     05  WS-G-METER-SIZE-ID     PIC X(08) VALUE SPACES.           
C33887     05  WS-E-DIGTL-MTR-TYPE    PIC X(03) VALUE SPACES.           
C33887     05  WS-G-DIGTL-MTR-TYPE    PIC X(03) VALUE SPACES.           
C33887     05  WS-E-PROGRAM-ID        PIC X(02) VALUE SPACES.           
C33887     05  WS-G-PROGRAM-ID        PIC X(02) VALUE SPACES.           
C33887     05  WS-METER-SIZE-DESC     PIC X(13) VALUE SPACES.           
C33887     05  WS-MECHANICAL-DIAL-FL  PIC X(01) VALUE SPACES.           
C33887     05  WS-DEVICE-NO           PIC X(12) VALUE SPACES.           
C33887     05  WS-CODE-ATT-TYPE       PIC X(02) VALUE SPACES.           
C33887     05  WS-MTR-ATT-TYPE-TX     PIC X(25) VALUE SPACES.           
C33887     05  WS-COMPANY-NO          PIC X(02) VALUE SPACES.           
C33887     05  WS-VERSION-CD          PIC X(03) VALUE SPACES.           
C33887     05  WS-VERSION-CD-VALUE    PIC X(10) VALUE SPACES.           
C33887     05  WS-CODE-SHORT-DESC     PIC X(15) VALUE SPACES.           
C34590     05  WS-ELEC-MTR-FORM-CD    PIC X(4)  VALUE SPACES.           
C34590     05  WS-MTR-CONNECT-TYP-ID  PIC X(10) VALUE SPACES.           
C34590     05  WS-NO-PHASES           PIC X(1)  VALUE SPACES.           
C34590     05  WS-CCF-CAP-PER-HR      PIC S9(09) COMP VALUE 0.          
      *                                                                 03510000
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ******************************************************************03520000
      *                         CURSORS                                *03530000
      ******************************************************************03540000
      *                                                                 03550000
           EXEC SQL                                                     
               DECLARE REGISTERCURSOR CURSOR FOR                        
                  SELECT REG_ID_NO,                                     
                         CODE_TIME_PERIOD,                              
                         CODE_REG_STATUS,                               
                         CODE_STATUS_REAS,                              
                         CODE_USAGE_ID,                                 
                         CODE_USAGE_TYPE,                               
                         CODE_USAGE_SOURCE,                             
ECC                      REGISTER_RD_SEQ,                               
                         LAST_READ_VALUE,                               
                         CIS.CHAR2$DATE(LAST_REG_READ_DT,'USA'),                
                         CIS.CHAR2$TIME(LAST_REG_READ_TM,'USA'),                
                         CODE_LAST_REG_READ,                            
                         LAST_VAL_RD_VALUE,                             
                         CIS.CHAR2$DATE(LAST_VALID_READ_DT,'USA'),              
                         CIS.CHAR2$TIME(LAST_VALID_READ_TM,'USA'),              
                         CODE_LAST_VALID_RD,                            
                         CODE_CRNT_REG_READ,                            
                         CODE_NO_RD_REASON,                             
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                    FROM CSS_REGISTER_READ                              
                   WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP           
                     AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            
                     AND IC_NO          = :MN-IC-NO                     
                     AND MTR_REF_NO     = :MN-MTR-REF-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03560000
MFA-TR*        DECLARE REGISTERCURSOR CURSOR FOR                        03570000
MFA-TR*           SELECT REG_ID_NO,                                     03580000
MFA-TR*                  CODE_TIME_PERIOD,                              03590000
MFA-TR*                  CODE_REG_STATUS,                               03600000
MFA-TR*                  CODE_STATUS_REAS,                              03610000
MFA-TR*                  CODE_USAGE_ID,                                 03620000
MFA-TR*                  CODE_USAGE_TYPE,                               03630000
MFA-TR*                  CODE_USAGE_SOURCE,                             03640000
MFA-TR*                  REGISTER_RD_SEQ,                               03650000
MFA-TR*                  LAST_READ_VALUE,                               03660000
MFA-TR*                  CHAR(LAST_REG_READ_DT,USA),                    03670000
MFA-TR*                  CHAR(LAST_REG_READ_TM,USA),                    03680000
MFA-TR*                  CODE_LAST_REG_READ,                            03690000
MFA-TR*                  LAST_VAL_RD_VALUE,                             03700000
MFA-TR*                  CHAR(LAST_VALID_READ_DT,USA),                  03710000
MFA-TR*                  CHAR(LAST_VALID_READ_TM,USA),                  03720000
MFA-TR*                  CODE_LAST_VALID_RD,                            03730000
MFA-TR*                  CODE_CRNT_REG_READ,                            03740000
MFA-TR*                  CODE_NO_RD_REASON,                             03750000
MFA-TR*                  LAST_UPDATE_TS                                 03760000
MFA-TR*             FROM CSS_REGISTER_READ                              03770000
MFA-TR*            WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP           03780000
MFA-TR*              AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            03790000
MFA-TR*              AND IC_NO          = :MN-IC-NO                     03800000
MFA-TR*              AND MTR_REF_NO     = :MN-MTR-REF-NO                03810000
MFA-TR*    END-EXEC.                                                    03820000
      *                                                                 03830000
      *                                                                 03550000
C33887     EXEC SQL                                                     
C33887         DECLARE AMRCURSOR CURSOR FOR                             
C33887          SELECT  MA.DEVICE_NO,                                   
C33887                  MA.CODE_ATT_TYPE,                               
C33887                  MA.COMPANY_NO,                                  
C33887                  MT.MTR_ATT_TYPE_TX                              
C33887            FROM CSS_METER_ATTCHMTS MA
                           WITH(READUNCOMMITTED), CSS_MTR_ATT_TYPE MT
                           WITH(READUNCOMMITTED)       
C33887           WHERE MA.CODE_UTIL_TYPE    = MT.CODE_UTIL_TYPE         
C33887             AND MA.CODE_ATT_TYPE     = MT.CODE_ATT_TYPE          
C33887             AND MA.COMPANY_NO        = :WS-DEFAULT-COMPANY-NO    
C33887             AND MA.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE        
C33887             AND MT.DEVICE_TYPE_CD    = 'A'                       
C33887             AND MA.METER_NO          = :WS-METER-NO              
C33887           FOR READ ONLY                                  
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03560000
MFA-TR*        DECLARE AMRCURSOR CURSOR FOR                             03570000
MFA-TR*         SELECT  MA.DEVICE_NO,                                           
MFA-TR*                 MA.CODE_ATT_TYPE,                                       
MFA-TR*                 MA.COMPANY_NO,                                          
MFA-TR*                 MT.MTR_ATT_TYPE_TX                                      
MFA-TR*           FROM CSS_METER_ATTCHMTS MA, CSS_MTR_ATT_TYPE MT               
MFA-TR*          WHERE MA.CODE_UTIL_TYPE    = MT.CODE_UTIL_TYPE                 
MFA-TR*            AND MA.CODE_ATT_TYPE     = MT.CODE_ATT_TYPE                  
MFA-TR*            AND MA.COMPANY_NO        = :WS-DEFAULT-COMPANY-NO            
MFA-TR*            AND MA.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                
MFA-TR*            AND MT.DEVICE_TYPE_CD    = 'A'                               
MFA-TR*            AND MA.METER_NO          = :WS-METER-NO                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    03820000
      *                                                                 03830000
      *                                                                 03840000
HPCCDM*EJECT                                                            03850000
      *                                                                 03860000
      *                                                                 03870000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO            PIC X(13).                        
REARCH 01  PARM-CUSTOMER-NO           PIC X(10).                        
REARCH 01  PARM-PREMISE-NO            PIC X(10).                        
REARCH 01  PARM-CODE-UTIL-TYPE        PIC X(1).                         
REARCH 01  PARM-METER-NO              PIC X(9).                         
REARCH 01  PARM-IC-NO                 PIC S9(04) COMP.                  
REARCH 01  PARM-MTR-REF-NO            PIC S9(04) COMP.                  
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-CUSTOMER-NO                        
REARCH                          PARM-PREMISE-NO                         
REARCH                          PARM-CODE-UTIL-TYPE                     
REARCH                          PARM-METER-NO                           
REARCH                          PARM-IC-NO                              
REARCH                          PARM-MTR-REF-NO.                        
REARCH*                                                                         
      *                                                                 03890000
      *                                                                 03900000
      ******************************************************************03910000
      * 0000-MAINLINE                                                  *03920000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03930000
      ******************************************************************03940000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04070000
      * 0100-INITIALIZE                                                *04080000
      *                                                                *04090000
      *     1. RESET DB2 ERROR HANDLERS                                *04100000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04110000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04120000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04130000
      *                                                                *04140000
      ******************************************************************04150000
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                 04180000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                 04400000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH           SELECT                                                 
REARCH             LTRIM(RTRIM(LAST_UPDATE_TS))      AS LAST_UPDATE_TS         
REARCH            ,LTRIM(RTRIM(METER_NO))            AS METER_NO               
REARCH            ,MTR_REF_NO                                           
REARCH            ,LTRIM(RTRIM(DATE_MTR_INSTALL))    AS DATE_MTR_INSTALL       
REARCH            ,LTRIM(RTRIM(POINT_ID))            AS POINT_ID               
REARCH            ,LTRIM(RTRIM(DIGTL_MTR_TYPE))      AS DIGTL_MTR_TYPE         
REARCH            ,LTRIM(RTRIM(METER_SUPPLYING))     AS METER_SUPPLYING        
REARCH            ,LTRIM(RTRIM(CODE_METER_LOC))      AS CODE_METER_LOC         
REARCH            ,LTRIM(RTRIM(DATE_LAST_TESTED))    AS DATE_LAST_TESTED       
REARCH            ,NO_CONSEC_ESTIMATE                                   
REARCH            ,NO_CONSEC_CRD_READ                                   
REARCH            ,LTRIM(RTRIM(MTR_READ_SOURCE_CD))  AS 
           MTR_READ_SOURCE_CD     
REARCH            ,LTRIM(RTRIM(OPTIMUM_READ_DATE))   AS 
           OPTIMUM_READ_DATE      
REARCH            ,LTRIM(RTRIM(HEXAGRAM_LOCATION))   AS 
           HEXAGRAM_LOCATION      
REARCH            ,MONTHS_INACTIVE            AS MONTHS_INACTIVE        
REARCH            ,LTRIM(RTRIM(SEAL_CODE_ID))        AS SEAL_CODE_ID           
REARCH            ,LTRIM(RTRIM(INSULATED_IND))       AS INSULATED_IND          
REARCH            ,LTRIM(RTRIM(LOCK_TYPE_ID))        AS LOCK_TYPE_ID           
REARCH            ,LTRIM(RTRIM(IDR_RECIPIENT_CD))    AS IDR_RECIPIENT_CD       
REARCH            ,LTRIM(RTRIM(DELIVERY_LEVEL_CD))   AS 
           DELIVERY_LEVEL_CD      
REARCH            ,LTRIM(RTRIM(UTILITY_SOURCE_CD))   AS 
           UTILITY_SOURCE_CD      
REARCH            ,LTRIM(RTRIM(REMOTE_READ_IND))     AS REMOTE_READ_IND        
REARCH            ,LTRIM(RTRIM(PROGRAM_ID))          AS PROGRAM_ID             
REARCH            ,LTRIM(RTRIM(INDUST_BTU_ID))       AS INDUST_BTU_ID          
REARCH            ,MAX_NO_UNITS                                         
REARCH            ,MIN_NO_UNITS                                         
REARCH            ,LTRIM(RTRIM(INDUS_GAS_CUST))      AS INDUS_GAS_CUST         
REARCH            ,GIS_POINT_ID                                         
REARCH            ,REG_ID_NO                                            
REARCH            ,CODE_TIME_PERIOD                                     
REARCH            ,CONSTANT                                             
REARCH            ,NO_READ_DIALS                                        
REARCH            ,LTRIM(RTRIM(CODE_REG_STATUS))     AS CODE_REG_STATUS        
REARCH            ,LTRIM(RTRIM(CODE_STATUS_REAS))    AS CODE_STATUS_REAS       
REARCH            ,LTRIM(RTRIM(METER_USAGE_DESC))    AS METER_USAGE_DESC       
REARCH            ,LTRIM(RTRIM(CODE_USAGE_TYPE))     AS CODE_USAGE_TYPE        
REARCH            ,LAST_READ_VALUE                                      
REARCH            ,LTRIM(RTRIM(LAST_REG_READ_DT))    AS LAST_REG_READ_DT       
REARCH            ,LTRIM(RTRIM(LAST_REG_READ_TM))    AS LAST_REG_READ_TM       
REARCH            ,LTRIM(RTRIM(CODE_LAST_REG_READ))  AS 
           CODE_LAST_REG_READ     
REARCH            ,LAST_VAL_RD_VALUE                                    
REARCH            ,LTRIM(RTRIM(LAST_VALID_READ_DT))  AS 
           LAST_VALID_READ_DT     
REARCH            ,LTRIM(RTRIM(LAST_VALID_READ_TM))  AS 
           LAST_VALID_READ_TM     
REARCH            ,LTRIM(RTRIM(CD_LAST_VALID_READ))  AS 
           CD_LAST_VALID_READ     
REARCH            ,LTRIM(RTRIM(CODE_CRNT_REG_READ))  AS 
           CODE_CRNT_REG_READ     
REARCH            ,LTRIM(RTRIM(CODE_NO_RD_REASON))   AS 
           CODE_NO_RD_REASON      
REARCH            ,RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(CODE_MTR_RD_INST1))   AS 
           CODE_MTR_RD_INST1      
REARCH            ,LTRIM(RTRIM(CODE_MTR_RD_INST2))   AS 
           CODE_MTR_RD_INST2      
REARCH            ,LTRIM(RTRIM(CODE_MTR_RD_INST3))   AS 
           CODE_MTR_RD_INST3      
REARCH            ,REGISTER_RD_SEQ                                      
REARCH            ,LTRIM(RTRIM(AMR_CAP_FL))          AS AMR_CAP_FL             
REARCH            ,LTRIM(RTRIM(METER_PRESSURE))      AS METER_PRESSURE         
C33887            ,LTRIM(RTRIM(METER_SIZE_DESC))     AS METER_SIZE_DESC        
C33887            ,LTRIM(RTRIM(MECHANICAL_DIAL_FL))  AS 
           MECHANICAL_DIAL_FL     
C33887            ,LTRIM(RTRIM(DEVICE_NO))           AS DEVICE_NO              
C33887            ,LTRIM(RTRIM(CODE_ATT_TYPE))       AS CODE_ATT_TYPE          
C33887            ,LTRIM(RTRIM(CODE_SHORT_DESC))     AS CODE_SHORT_DESC        
C33887            ,LTRIM(RTRIM(MTR_ATT_TYPE_TX))     AS MTR_ATT_TYPE_TX        
C33887            ,'1900-01-01'                                         
C34590            ,LTRIM(RTRIM(ELEC_MTR_FORM_CD))    AS ELEC_MTR_FORM_CD       
C34590            ,LTRIM(RTRIM(MTR_CONNECT_TYP_ID))  AS 
           MTR_CONNECT_TYP_ID     
C34590            ,LTRIM(RTRIM(NO_PHASES))           AS NO_PHASES              
C34590            ,CCF_CAP_PER_HR             AS CCF_CAP_PER_HR         
P00545            ,GIS_MISMATCH_FL            AS GIS_MISMATCH_FL        
REARCH           FROM                                                   
REARCH              #CSR02076_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*          SELECT                                                         
MFA-TR*            STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS                 
MFA-TR*           ,STRIP(METER_NO)            AS METER_NO                       
MFA-TR*           ,MTR_REF_NO                                                   
MFA-TR*           ,STRIP(DATE_MTR_INSTALL)    AS DATE_MTR_INSTALL               
MFA-TR*           ,STRIP(POINT_ID)            AS POINT_ID                       
MFA-TR*           ,STRIP(DIGTL_MTR_TYPE)      AS DIGTL_MTR_TYPE                 
MFA-TR*           ,STRIP(METER_SUPPLYING)     AS METER_SUPPLYING                
MFA-TR*           ,STRIP(CODE_METER_LOC)      AS CODE_METER_LOC                 
MFA-TR*           ,STRIP(DATE_LAST_TESTED)    AS DATE_LAST_TESTED               
MFA-TR*           ,NO_CONSEC_ESTIMATE                                           
MFA-TR*           ,NO_CONSEC_CRD_READ                                           
MFA-TR*           ,STRIP(MTR_READ_SOURCE_CD)  AS MTR_READ_SOURCE_CD             
MFA-TR*           ,STRIP(OPTIMUM_READ_DATE)   AS OPTIMUM_READ_DATE              
MFA-TR*           ,STRIP(HEXAGRAM_LOCATION)   AS HEXAGRAM_LOCATION              
MFA-TR*           ,MONTHS_INACTIVE            AS MONTHS_INACTIVE                
MFA-TR*           ,STRIP(SEAL_CODE_ID)        AS SEAL_CODE_ID                   
MFA-TR*           ,STRIP(INSULATED_IND)       AS INSULATED_IND                  
MFA-TR*           ,STRIP(LOCK_TYPE_ID)        AS LOCK_TYPE_ID                   
MFA-TR*           ,STRIP(IDR_RECIPIENT_CD)    AS IDR_RECIPIENT_CD               
MFA-TR*           ,STRIP(DELIVERY_LEVEL_CD)   AS DELIVERY_LEVEL_CD              
MFA-TR*           ,STRIP(UTILITY_SOURCE_CD)   AS UTILITY_SOURCE_CD              
MFA-TR*           ,STRIP(REMOTE_READ_IND)     AS REMOTE_READ_IND                
MFA-TR*           ,STRIP(PROGRAM_ID)          AS PROGRAM_ID                     
MFA-TR*           ,STRIP(INDUST_BTU_ID)       AS INDUST_BTU_ID                  
MFA-TR*           ,MAX_NO_UNITS                                                 
MFA-TR*           ,MIN_NO_UNITS                                                 
MFA-TR*           ,STRIP(INDUS_GAS_CUST)      AS INDUS_GAS_CUST                 
MFA-TR*           ,GIS_POINT_ID                                                 
MFA-TR*           ,REG_ID_NO                                                    
MFA-TR*           ,CODE_TIME_PERIOD                                             
MFA-TR*           ,CONSTANT                                                     
MFA-TR*           ,NO_READ_DIALS                                                
MFA-TR*           ,STRIP(CODE_REG_STATUS)     AS CODE_REG_STATUS                
MFA-TR*           ,STRIP(CODE_STATUS_REAS)    AS CODE_STATUS_REAS               
MFA-TR*           ,STRIP(METER_USAGE_DESC)    AS METER_USAGE_DESC               
MFA-TR*           ,STRIP(CODE_USAGE_TYPE)     AS CODE_USAGE_TYPE                
MFA-TR*           ,LAST_READ_VALUE                                              
MFA-TR*           ,STRIP(LAST_REG_READ_DT)    AS LAST_REG_READ_DT               
MFA-TR*           ,STRIP(LAST_REG_READ_TM)    AS LAST_REG_READ_TM               
MFA-TR*           ,STRIP(CODE_LAST_REG_READ)  AS CODE_LAST_REG_READ             
MFA-TR*           ,LAST_VAL_RD_VALUE                                            
MFA-TR*           ,STRIP(LAST_VALID_READ_DT)  AS LAST_VALID_READ_DT             
MFA-TR*           ,STRIP(LAST_VALID_READ_TM)  AS LAST_VALID_READ_TM             
MFA-TR*           ,STRIP(CD_LAST_VALID_READ)  AS CD_LAST_VALID_READ             
MFA-TR*           ,STRIP(CODE_CRNT_REG_READ)  AS CODE_CRNT_REG_READ             
MFA-TR*           ,STRIP(CODE_NO_RD_REASON)   AS CODE_NO_RD_REASON              
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*           ,STRIP(CODE_MTR_RD_INST1)   AS CODE_MTR_RD_INST1              
MFA-TR*           ,STRIP(CODE_MTR_RD_INST2)   AS CODE_MTR_RD_INST2              
MFA-TR*           ,STRIP(CODE_MTR_RD_INST3)   AS CODE_MTR_RD_INST3              
MFA-TR*           ,REGISTER_RD_SEQ                                              
MFA-TR*           ,STRIP(AMR_CAP_FL)          AS AMR_CAP_FL                     
MFA-TR*           ,STRIP(METER_PRESSURE)      AS METER_PRESSURE                 
MFA-TR*           ,STRIP(METER_SIZE_DESC)     AS METER_SIZE_DESC                
MFA-TR*           ,STRIP(MECHANICAL_DIAL_FL)  AS MECHANICAL_DIAL_FL             
MFA-TR*           ,STRIP(DEVICE_NO)           AS DEVICE_NO                      
MFA-TR*           ,STRIP(CODE_ATT_TYPE)       AS CODE_ATT_TYPE                  
MFA-TR*           ,STRIP(CODE_SHORT_DESC)     AS CODE_SHORT_DESC                
MFA-TR*           ,STRIP(MTR_ATT_TYPE_TX)     AS MTR_ATT_TYPE_TX                
MFA-TR*           ,'1900-01-01'                                                 
MFA-TR*           ,STRIP(ELEC_MTR_FORM_CD)    AS ELEC_MTR_FORM_CD               
MFA-TR*           ,STRIP(MTR_CONNECT_TYP_ID)  AS MTR_CONNECT_TYP_ID             
MFA-TR*           ,STRIP(NO_PHASES)           AS NO_PHASES                      
MFA-TR*           ,CCF_CAP_PER_HR             AS CCF_CAP_PER_HR                 
MFA-TR*           ,GIS_MISMATCH_FL            AS GIS_MISMATCH_FL                
MFA-TR*          FROM                                                           
MFA-TR*             SESSION.CSR02076_R1                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02076_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02076_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02076_R1
               (                                                       
REARCH             LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH            ,MTR_REF_NO                 SMALLINT                  
REARCH            ,DATE_MTR_INSTALL CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH            ,DIGTL_MTR_TYPE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,METER_SUPPLYING CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_METER_LOC CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,DATE_LAST_TESTED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,NO_CONSEC_ESTIMATE         SMALLINT                  
REARCH            ,NO_CONSEC_CRD_READ         SMALLINT                  
REARCH            ,MTR_READ_SOURCE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,OPTIMUM_READ_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,HEXAGRAM_LOCATION CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,MONTHS_INACTIVE            SMALLINT                  
REARCH            ,SEAL_CODE_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,INSULATED_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,LOCK_TYPE_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,IDR_RECIPIENT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,DELIVERY_LEVEL_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,UTILITY_SOURCE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,REMOTE_READ_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,PROGRAM_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,INDUST_BTU_ID CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,MAX_NO_UNITS               DECIMAL(9,0)              
REARCH            ,MIN_NO_UNITS               DECIMAL(9,0)              
REARCH            ,INDUS_GAS_CUST CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,GIS_POINT_ID               INT                   
REARCH            ,REG_ID_NO                  SMALLINT                  
REARCH            ,CODE_TIME_PERIOD           SMALLINT                  
REARCH            ,CONSTANT                   DECIMAL(9,3)              
REARCH            ,NO_READ_DIALS              SMALLINT                  
REARCH            ,CODE_REG_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_STATUS_REAS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,METER_USAGE_DESC CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_USAGE_TYPE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,LAST_READ_VALUE            DECIMAL(15,3)             
REARCH            ,LAST_REG_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,LAST_REG_READ_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_LAST_REG_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,LAST_VAL_RD_VALUE          DECIMAL(15,3)             
REARCH            ,LAST_VALID_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,LAST_VALID_READ_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CD_LAST_VALID_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_CRNT_REG_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_NO_RD_REASON CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,RETURN_CODE                INT                   
REARCH            ,CODE_MTR_RD_INST1 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_MTR_RD_INST2 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,CODE_MTR_RD_INST3 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH            ,REGISTER_RD_SEQ            INT                   
REARCH            ,AMR_CAP_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,METER_PRESSURE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C33887            ,METER_SIZE_DESC CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C33887            ,MECHANICAL_DIAL_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C33887            ,DEVICE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
C33887            ,CODE_ATT_TYPE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C33887            ,CODE_SHORT_DESC CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C33887            ,MTR_ATT_TYPE_TX CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C34590            ,ELEC_MTR_FORM_CD CHAR(4)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
C34590            ,MTR_CONNECT_TYP_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C34590            ,NO_PHASES CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
C34590            ,CCF_CAP_PER_HR             INT                   
P00545            ,GIS_MISMATCH_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
REARCH          )
            END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02076_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************04440000
      * 1000-PROCESS-INPUT                                             *04450000
      *                                                                *04460000
      *     1. RECEIVE PARMS.                                          *04470000
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *04480000
      *                                                                *04490000
      ******************************************************************04500000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 05270000
      ******************************************************************05280000
      * 1150 ASSIGN-WS-VARS                                            *05290000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *05300000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *05310000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *05320000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *05330000
      *        SELECT STATEMENTS.                                      *05340000
      ******************************************************************05350000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 05370000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-N       TO WS-ACCOUNT-NO-COMP             
T28824                                   AT-ACCOUNT-NO.                 
           MOVE PARM-CUSTOMER-NO      TO WS-CUSTOMER-NO.                
           MOVE WS-CUSTOMER-NO-N      TO WS-CUSTOMER-NO-COMP.           
           MOVE PARM-PREMISE-NO       TO WS-PREMISE-NO.                 
           MOVE WS-PREMISE-NO-N       TO WS-PREMISE-NO-COMP.            
           MOVE PARM-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE.             
           MOVE PARM-METER-NO         TO WS-METER-NO.                   
T19090     MOVE PARM-IC-NO            TO WS-IC-NO.                      
T19090     MOVE PARM-MTR-REF-NO       TO WS-MTR-REF-NO.                 
      *                                                                 05460000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05490000
      *                                                                 05500000
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      *                                                                *05530000
      *     1. DESCRIBE RESULT SET                                     *05540000
      *     2. RETRIVE DB2 DATA                                        *05550000
      *     3. BUILD RESULT SET                                        *05560000
      *     4. SEND RESULT SET                                         *05570000
      *                                                                *05580000
      ******************************************************************05590000
      *                                                                 05600000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05620000
           PERFORM 5000-GET-METER-DETAILS        THRU 5000-EXIT.        
           IF REGISTER-DETAILS                                          
              PERFORM 5100-GET-REGISTER-DETAILS  THRU 5100-EXIT         
           END-IF.                                                      
      *                                                                 05680000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05710000
      *                                                                 05720000
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH  2000A-MOVE-RESULT.                                              
REARCH       MOVE RS-LAST-UPDATE-TS       TO S-LAST-UPDATE-TS.          
REARCH       MOVE RS-METER-NO             TO S-METER-NO.                
REARCH       MOVE RS-MTR-REF-NO           TO S-MTR-REF-NO.              
REARCH       MOVE RS-DATE-MTR-INSTALL     TO S-DATE-MTR-INSTALL.        
REARCH       MOVE RS-POINT-ID             TO S-POINT-ID.                
REARCH       MOVE RS-DIGTL-MTR-TYPE       TO S-DIGTL-MTR-TYPE.          
REARCH       MOVE RS-METER-SUPPLYING      TO S-METER-SUPPLYING.         
REARCH       MOVE RS-CODE-METER-LOC       TO S-CODE-METER-LOC.          
REARCH       MOVE RS-DATE-LAST-TESTED     TO S-DATE-LAST-TESTED.        
REARCH       MOVE RS-AMR-CAP-FL           TO S-AMR-CAP-FL.              
REARCH       MOVE RS-NO-CONSEC-ESTIMATE   TO S-NO-CONSEC-ESTIMATE.      
REARCH       MOVE RS-NO-CONSEC-CRD-READ   TO S-NO-CONSEC-CRD-READ.      
REARCH       MOVE RS-MTR-READ-SOURCE-CD   TO S-MTR-READ-SOURCE-CD.      
REARCH       MOVE RS-OPTIMUM-READ-DATE    TO S-OPTIMUM-READ-DATE.       
REARCH       MOVE RS-HEXAGRAM-LOCATION    TO S-HEXAGRAM-LOCATION.       
REARCH       MOVE RS-MONTHS-INACTIVE      TO S-MONTHS-INACTIVE.         
REARCH       MOVE RS-SEAL-CODE-ID         TO S-SEAL-CODE-ID.            
REARCH       MOVE RS-INSULATED-IND        TO S-INSULATED-IND.           
REARCH       MOVE RS-LOCK-TYPE-ID         TO S-LOCK-TYPE-ID.            
REARCH       MOVE RS-IDR-RECIPIENT-CD     TO S-IDR-RECIPIENT-CD.        
REARCH       MOVE RS-DELIVERY-LEVEL-CD    TO S-DELIVERY-LEVEL-CD.       
REARCH       MOVE RS-UTILITY-SOURCE-CD    TO S-UTILITY-SOURCE-CD.       
REARCH       MOVE RS-REMOTE-READ-IND      TO S-REMOTE-READ-IND.         
REARCH       MOVE RS-PROGRAM-ID           TO S-PROGRAM-ID.              
REARCH       MOVE RS-INDUST-BTU-ID        TO S-INDUST-BTU-ID.           
REARCH       MOVE RS-MAX-NO-UNITS         TO S-MAX-NO-UNITS.            
REARCH       MOVE RS-MIN-NO-UNITS         TO S-MIN-NO-UNITS.            
REARCH       MOVE RS-INDUS-GAS-CUST       TO S-INDUS-GAS-CUST.          
REARCH       MOVE RS-GIS-POINT-ID         TO S-GIS-POINT-ID.            
REARCH       MOVE RS-REG-ID-NO            TO S-REG-ID-NO.               
REARCH       MOVE RS-CODE-TIME-PERIOD     TO S-CODE-TIME-PERIOD.        
REARCH       MOVE RS-CONSTANT             TO S-CONSTANT.                
REARCH       MOVE RS-NO-READ-DIALS        TO S-NO-READ-DIALS.           
REARCH       MOVE RS-CODE-REG-STATUS      TO S-CODE-REG-STATUS.         
REARCH       MOVE RS-CODE-STATUS-REAS     TO S-CODE-STATUS-REAS.        
REARCH       MOVE RS-METER-USAGE-DESC     TO S-METER-USAGE-DESC.        
REARCH       MOVE RS-CODE-USAGE-TYPE      TO S-CODE-USAGE-TYPE.         
REARCH       MOVE RS-LAST-READ-VALUE      TO S-LAST-READ-VALUE.         
REARCH       MOVE RS-LAST-REG-READ-DT     TO S-LAST-REG-READ-DT.        
REARCH       MOVE RS-LAST-REG-READ-TM     TO S-LAST-REG-READ-TM.        
REARCH       MOVE RS-CODE-LAST-REG-READ   TO S-CODE-LAST-REG-READ.      
REARCH       MOVE RS-LAST-VAL-RD-VALUE    TO S-LAST-VAL-RD-VALUE.       
REARCH       MOVE RS-LAST-VALID-READ-DT   TO S-LAST-VALID-READ-DT.      
REARCH       MOVE RS-LAST-VALID-READ-TM   TO S-LAST-VALID-READ-TM.      
REARCH       MOVE RS-CODE-LAST-VALID-RD   TO S-CODE-LAST-VALID-RD.      
REARCH       MOVE RS-CODE-CRNT-REG-READ   TO S-CODE-CRNT-REG-READ.      
REARCH       MOVE RS-CODE-NO-RD-REASON    TO S-CODE-NO-RD-REASON.       
REARCH       MOVE RS-CODE-MTR-RD-INST1    TO S-CODE-MTR-RD-INST1.       
REARCH       MOVE RS-CODE-MTR-RD-INST2    TO S-CODE-MTR-RD-INST2.       
REARCH       MOVE RS-CODE-MTR-RD-INST3    TO S-CODE-MTR-RD-INST3.       
REARCH       MOVE RS-REGISTER-RD-SEQ      TO S-REGISTER-RD-SEQ.         
REARCH       MOVE RS-METER-PRESSURE       TO S-METER-PRESSURE.          
P00545       MOVE RS-GIS-MISMATCH-FL      TO S-GIS-MISMATCH-FL.         
REARCH       MOVE RS-RETURN-CODE          TO S-RETURN-CODE.             
C33887       MOVE RS-METER-SIZE-DESC      TO S-METER-SIZE-DESC.         
C33887       MOVE RS-MECHANICAL-DIAL-FL   TO S-MECHANICAL-DIAL-FL.      
C33887       MOVE RS-DEVICE-NO            TO S-DEVICE-NO.               
C33887       MOVE RS-CODE-ATT-TYPE        TO S-CODE-ATT-TYPE.           
C33887       MOVE RS-CODE-SHORT-DESC      TO S-CODE-SHORT-DESC.         
C33887       MOVE RS-MTR-ATT-TYPE-TX      TO S-MTR-ATT-TYPE-TX.         
C34590       MOVE RS-ELEC-MTR-FORM-CD     TO S-ELEC-MTR-FORM-CD.        
C34590       MOVE RS-MTR-CONNECT-TYP-ID   TO S-MTR-CONNECT-TYP-ID.      
C34590       MOVE RS-NO-PHASES            TO S-NO-PHASES.               
C34590       MOVE RS-CCF-CAP-PER-HR       TO S-CCF-CAP-PER-HR.          
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH                                                                  
                                                                        
      ******************************************************************15470000
      * 5000-GET-METER-DETAILS.                                        *15480000
      *       -- THIS MODULE RETRIEVES AND VERIFIES ALL METER DATA FOR *15490000
      *          THE RESULT SET.                                       *15500000
      ******************************************************************15510000
       5000-GET-METER-DETAILS.                                          
                                                                        
           PERFORM 7000-GET-CURRENT-DATE    THRU 7000-EXIT.             
           PERFORM 7100-GET-METER                THRU 7100-EXIT.        
C24056     PERFORM 7110-GET-GIS-LOC-AND-TAG      THRU 7110-EXIT.        
           PERFORM 7600-GET-READ-CYCLE           THRU 7600-EXIT.        
T28824     PERFORM 5901-NEXT-READ-DATE                                  
T28824                            THRU 5901-NEXT-READ-DATE-EXIT.        
T28824     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T28824        IF RW-THIRD-PTY-READ-DT > SPACES                          
T28824           MOVE RW-THIRD-PTY-READ-DT  TO WS-DATE-CCYY-MM-DD       
T28824        ELSE                                                      
T28824           MOVE RW-OPTIMUM-READ-DATE  TO WS-DATE-CCYY-MM-DD       
T28824        END-IF                                                    
T28824        MOVE WS-DATE-CCYY      TO WS-DATE2-CCYY                   
T28824        MOVE WS-DATE-MM        TO WS-DATE2-MM                     
T28824        MOVE WS-DATE-DD        TO WS-DATE2-DD                     
T28824        MOVE WS-DATE-MM-DD-YYYY TO RS-OPTIMUM-READ-DATE           
T28824     ELSE                                                         
T28824        MOVE LOW-VALUES TO RS-OPTIMUM-READ-DATE                   
T28824     END-IF.                                                      
T28824*                                                                         
T22243     PERFORM 7010-GET-COMPANY-NO           THRU 7010-EXIT.        
T22243     MOVE WS-DEFAULT-COMPANY-NO            TO EM-COMPANY-NO       
T22243                                              GM-COMPANY-NO       
C28373                                              MA-COMPANY-NO       
T22243                                              MC-COMPANY-NO.      
A00714***                                                                       
A00714     MOVE SPACES                   TO WS-DATE-LAST-TESTED         
           IF WS-CODE-UTIL-TYPE = 'E'                                   
A00714        PERFORM 5010-ELEC-MTR-DETAILS      THRU 5010-EXIT         
           ELSE                                                         
A00714        PERFORM 5020-GAS-MTR-DETAILS       THRU 5020-EXIT         
           END-IF.                                                      
A00714***                                                                       
C33887     MOVE WS-METER-SIZE-DESC    TO  RS-METER-SIZE-DESC.           
C33887     MOVE WS-MECHANICAL-DIAL-FL TO  RS-MECHANICAL-DIAL-FL.        
A00714***                                                                       
           PERFORM 7200-GET-METER-CAP-DETAILS    THRU 7200-EXIT.        
           PERFORM 7500-GET-USAGE-VALS           THRU 7500-EXIT.        
A00714     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A00714        MOVE SPACES                TO WS-METER-USAGE-DESC         
A00714                                      WS-USAGE-TYPE-DESC          
A00714     END-IF                                                       
A00714***                                                                       
C33887     PERFORM 7450-OPEN-AMRCURSOR           THRU 7450-EXIT.        
C33887     PERFORM 7460-FETCH-AMRCURSOR          THRU 7460-EXIT.        
C33887*                                                                 16910000
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887        PERFORM 7480-GET-AMR-DETAILS        THRU 7480-EXIT        
C33887     END-IF.                                                      
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887        PERFORM 7490-GET-EQP-ATTCHMTS-DESC THRU 7490-EXIT         
C33887     END-IF.                                                      
C33887*                                                                 16910000
C33887     MOVE WS-DEVICE-NO                  TO RS-DEVICE-NO.          
C33887     MOVE WS-CODE-ATT-TYPE              TO RS-CODE-ATT-TYPE.      
C33887     MOVE WS-CODE-SHORT-DESC            TO RS-CODE-SHORT-DESC.    
C33887     MOVE WS-MTR-ATT-TYPE-TX            TO RS-MTR-ATT-TYPE-TX.    
           PERFORM 5040-SET-METER-RETURNS        THRU 5040-EXIT.        
           PERFORM 5050-SET-MET-REG-RETURNS      THRU 5050-EXIT.        
REARCH     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
REARCH     PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
      *                                                                 15630000
       5000-EXIT.                                                       
           EXIT.                                                        
A00714*                                                                 15740000
A00714*===============================================================* 15660000
A00714 5010-ELEC-MTR-DETAILS.                                           
A00714*===============================================================* 15660000
A00714*                                                                 15740000
A00714     PERFORM 7300-GET-ELEC-METER        THRU 7300-EXIT            
A00714     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00714        PERFORM 7310-GET-RMT-RD-CD      THRU 7310-EXIT            
A00714        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE SPACES             TO WS-AMR-CAP-FL               
A00714                                      WS-ELEC-MTR-FORM-CD         
A00714                                      WS-MTR-CONNECT-TYP-ID       
A00714                                      WS-NO-PHASES                
A00714        END-IF                                                    
A00714        PERFORM 7800-GET-ELEC-METER-SIZE    THRU 7800-EXIT        
A00714        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE SPACES             TO WS-METER-SIZE-DESC          
A00714        END-IF                                                    
A00714        PERFORM 7900-GET-ELEC-MECHDIAL-FL   THRU 7900-EXIT        
A00714        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE SPACES             TO WS-MECHANICAL-DIAL-FL       
A00714        END-IF                                                    
A00714     ELSE                                                         
A00714        MOVE SPACES                TO WS-E-MTR-SPEC-CD            
A00714                                      WS-E-MTR-CLASS-CD           
A00714                                      WS-E-METER-SIZE-ID          
A00714                                      WS-E-DIGTL-MTR-TYPE         
A00714                                      WS-E-PROGRAM-ID             
A00714                                      WS-AMR-CAP-FL               
A00714                                      WS-ELEC-MTR-FORM-CD         
A00714                                      WS-MTR-CONNECT-TYP-ID       
A00714                                      WS-NO-PHASES                
A00714                                      WS-METER-SIZE-DESC          
A00714                                      WS-MECHANICAL-DIAL-FL       
A00714     END-IF.                                                      
A00714*                                                                 15630000
A00714 5010-EXIT.                                                       
A00714     EXIT.                                                        
A00714*                                                                 15660000
A00714 5020-GAS-MTR-DETAILS.                                            
A00714*                                                                 15740000
A00714     PERFORM 7320-GET-GAS-METER         THRU 7320-EXIT            
A00714     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00714        PERFORM 7810-GET-GAS-METER-SIZE     THRU 7810-EXIT        
A00714        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE SPACES             TO WS-METER-SIZE-DESC          
A00714           MOVE ZEROS              TO WS-CCF-CAP-PER-HR           
A00714        END-IF                                                    
A00714        PERFORM 7910-GET-GAS-MECHDIAL-FL    THRU 7910-EXIT        
A00714        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE SPACES             TO WS-MECHANICAL-DIAL-FL       
A00714        END-IF                                                    
A00714     ELSE                                                         
A00714        MOVE SPACES                TO WS-G-METER-SIZE-ID          
A00714                                      WS-G-DIGTL-MTR-TYPE         
A00714                                      WS-G-PROGRAM-ID             
A00714                                      WS-METER-SIZE-DESC          
A00714                                      WS-MECHANICAL-DIAL-FL       
A00714        MOVE ZEROS                 TO WS-CCF-CAP-PER-HR           
A00714     END-IF.                                                      
A00714*                                                                 15630000
A00714 5020-EXIT.                                                       
A00714     EXIT.                                                        
A00714*                                                                 15660000
      ******************************************************************15680000
      * 5040-SET-METER-RETURNS.                                        *15690000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*15700000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *15710000
      ******************************************************************15720000
       5040-SET-METER-RETURNS.                                          
      *                                                                 15740000
           MOVE WS-LAST-UPDATE-TS        TO RS-LAST-UPDATE-TS.          
           MOVE WS-METER-NO              TO RS-METER-NO.                
           MOVE MN-MTR-REF-NO            TO RS-MTR-REF-NO.              
           MOVE MN-DATE-MTR-INSTALL      TO RS-DATE-MTR-INSTALL.        
C24056*    MOVE MN-POINT-ID              TO RS-POINT-ID.                15790000
C24056     IF MN-GIS-POINT-ID = 0                                       
C24056       MOVE SPACE TO RS-POINT-ID                                  
C24056     ELSE                                                         
P33743       STRING PP-AREA-ID(1:3)  DELIMITED BY SIZE                  
P33743            PP-TAG-NM(1:7)     DELIMITED BY SIZE                  
C24056            INTO RS-POINT-ID                                      
C24056        END-STRING                                                
C24056     END-IF.                                                      
C24056     MOVE MN-GIS-POINT-ID          TO RS-GIS-POINT-ID.            
           MOVE MN-DIGTL-MTR-TYPE        TO RS-DIGTL-MTR-TYPE.          
           MOVE MN-METER-SUPPLYING       TO RS-METER-SUPPLYING.         
           IF WS-DATE-LAST-NULL < 0                                     
              MOVE SPACES               TO RS-DATE-LAST-TESTED          
           ELSE                                                         
              MOVE WS-DATE-LAST-TESTED  TO RS-DATE-LAST-TESTED          
           END-IF.                                                      
                                                                        
D2137      IF WS-AMR-CAP-FL EQUAL ('A' OR 'B')                          
D2137         MOVE 'Y' TO RS-AMR-CAP-FL                                 
D2137      ELSE                                                         
D2137         MOVE 'N' TO RS-AMR-CAP-FL                                 
C28373                   WS-AMR-MODULE-EXISTS                           
C28273        MOVE WS-CODE-UTIL-TYPE     TO MA-CODE-UTIL-TYPE           
C28273        MOVE WS-METER-NO           TO MA-METER-NO                 
C28373        PERFORM 7720-CHECK-AMR-MODULE THRU 7720-EXIT              
C28373        IF  AMR-MODULE-EXISTS                                     
C28373            MOVE 'Y' TO RS-AMR-CAP-FL                             
C28373        END-IF                                                    
D2137      END-IF.                                                      
                                                                        
           MOVE MN-CODE-METER-LOC        TO RS-CODE-METER-LOC.          
           MOVE MN-NO-CONSEC-ESTIMATE    TO RS-NO-CONSEC-ESTIMATE.      
           MOVE MN-NO-CONSEC-CRD-READ    TO RS-NO-CONSEC-CRD-READ.      
           MOVE MN-CODE-MTR-RD-INST1     TO RS-CODE-MTR-RD-INST1.       
           MOVE MN-CODE-MTR-RD-INST2     TO RS-CODE-MTR-RD-INST2.       
           MOVE MN-CODE-MTR-RD-INST3     TO RS-CODE-MTR-RD-INST3.       
           MOVE MN-CODE-MTR-RD-INST3     TO RS-CODE-MTR-RD-INST3.       
           MOVE MN-MTR-READ-SOURCE-CD    TO RS-MTR-READ-SOURCE-CD.      
T28824*    MOVE RW-OPTIMUM-READ-DATE     TO RS-OPTIMUM-READ-DATE.       15950000
           MOVE MN-HEXAGRAM-LOCATION     TO RS-HEXAGRAM-LOCATION.       
           COMPUTE RS-MONTHS-INACTIVE = (WS-INACTIVE-YEAR * 12) +       
                                         WS-INACTIVE-MONTH.             
           MOVE MN-SEAL-CODE-ID          TO RS-SEAL-CODE-ID.            
           MOVE MN-INSULATED-IND         TO RS-INSULATED-IND.           
           MOVE MN-LOCK-TYPE-ID          TO RS-LOCK-TYPE-ID.            
           MOVE MN-IDR-RECIPIENT-CD      TO RS-IDR-RECIPIENT-CD.        
           MOVE MN-DELIVERY-LEVEL-CD     TO RS-DELIVERY-LEVEL-CD.       
           MOVE MN-UTILITY-SOURCE-CD     TO RS-UTILITY-SOURCE-CD.       
           MOVE MN-REMOTE-READ-IND       TO RS-REMOTE-READ-IND.         
C27236     MOVE MN-PROGRAM-ID            TO RS-PROGRAM-ID.              
C27236     PERFORM 7700-CHECK-INDUS-GAS-CUST THRU 7700-EXIT.            
C27236     MOVE WS-INDUS-GAS-CUSTOMER    TO RS-INDUS-GAS-CUST.          
C27236     MOVE MN-INDUST-BTU-ID         TO RS-INDUST-BTU-ID.           
C27236     MOVE MN-MAX-NO-UNITS          TO RS-MAX-NO-UNITS.            
C27236     MOVE MN-MIN-NO-UNITS          TO RS-MIN-NO-UNITS.            
C30989     MOVE MN-METER-PRESSURE        TO WS-METER-PRESSURE.          
C30989     MOVE WS-METER-PRESSURE        TO RS-METER-PRESSURE.          
P00545     MOVE MN-GIS-MISMATCH-FL       TO RS-GIS-MISMATCH-FL.         
C34590     MOVE WS-ELEC-MTR-FORM-CD      TO RS-ELEC-MTR-FORM-CD.        
C34590     MOVE WS-MTR-CONNECT-TYP-ID    TO RS-MTR-CONNECT-TYP-ID.      
C34590     MOVE WS-NO-PHASES             TO RS-NO-PHASES.               
C34590     MOVE WS-CCF-CAP-PER-HR        TO RS-CCF-CAP-PER-HR.          
      * THIS SWITCH DETERMINES IF THERE IS MORE THAN ONE REGISTER FOR   16050000
      *            A GIVEN METER.                                       16060000
           MOVE MN-CODE-DATA-PRESENT     TO REGISTER-SW.                
      *                                                                 16080000
       5040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16110000
      *                                                                 16120000
      ******************************************************************16130000
      * 5050-SET-MET-REG-RETURNS.                                      *16140000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE REGISTER VARIABLES*16150000
      *       FROM THE METER FILE TO BE RETURNED TO THE DESKTOP.       *16160000
      ******************************************************************16170000
       5050-SET-MET-REG-RETURNS.                                        
           MOVE MN-REG-ID-NO            TO RS-REG-ID-NO.                
           MOVE MN-CODE-TIME-PERIOD     TO RS-CODE-TIME-PERIOD.         
           MOVE MC-CONSTANT             TO RS-CONSTANT.                 
           MOVE MC-NO-READ-DIALS        TO RS-NO-READ-DIALS.            
           MOVE MN-CODE-METER-STATUS    TO RS-CODE-REG-STATUS.          
           MOVE MN-CODE-STATUS-REAS     TO RS-CODE-STATUS-REAS.         
           MOVE WS-METER-USAGE-DESC     TO RS-METER-USAGE-DESC.         
           MOVE WS-USAGE-TYPE-DESC      TO RS-CODE-USAGE-TYPE.          
ECC        MOVE MN-REGISTER-RD-SEQ      TO RS-REGISTER-RD-SEQ.          
           MOVE MN-LAST-READ-VALUE      TO RS-LAST-READ-VALUE.          
      *                                                                         
T16866     IF MN-LAST-REG-READ-TIME EQUAL '12:00 AM'                    
T16866        MOVE MN-LAST-REG-READ-DATE   TO WS-DATE-READ              
T16866        PERFORM 8650-ADD-ONE-DAY     THRU 8650-EXIT               
T16866        MOVE WS-DATE-READ            TO RS-LAST-REG-READ-DT       
T16866     ELSE                                                         
              MOVE MN-LAST-REG-READ-DATE   TO RS-LAST-REG-READ-DT       
T16866     END-IF.                                                      
      *                                                                         
           MOVE MN-LAST-REG-READ-TIME   TO RS-LAST-REG-READ-TM.         
           MOVE MN-CODE-LAST-REG-READ   TO RS-CODE-LAST-REG-READ.       
           MOVE MN-LAST-VAL-RD-VALUE    TO RS-LAST-VAL-RD-VALUE.        
      *                                                                         
T16866     IF MN-LAST-VALID-READ-TM EQUAL '12:00 AM'                    
T16866        MOVE MN-LAST-VALID-READ-DT   TO WS-DATE-READ              
T16866        PERFORM 8650-ADD-ONE-DAY     THRU 8650-EXIT               
T16866        MOVE WS-DATE-READ            TO RS-LAST-VALID-READ-DT     
T16866     ELSE                                                         
              MOVE MN-LAST-VALID-READ-DT   TO RS-LAST-VALID-READ-DT     
T16866     END-IF.                                                      
      *                                                                         
           MOVE MN-LAST-VALID-READ-TM   TO RS-LAST-VALID-READ-TM.       
           MOVE MN-CODE-LAST-VALID-RD   TO RS-CODE-LAST-VALID-RD.       
           MOVE MN-CODE-CRNT-REG-READ   TO RS-CODE-CRNT-REG-READ.       
           MOVE MN-CODE-NO-RD-REASON    TO RS-CODE-NO-RD-REASON.        
           MOVE MN-CODE-MTR-RD-INST1    TO RS-CODE-MTR-RD-INST1.        
           MOVE MN-CODE-MTR-RD-INST2    TO RS-CODE-MTR-RD-INST2.        
           MOVE MN-CODE-MTR-RD-INST3    TO RS-CODE-MTR-RD-INST3.        
                                                                        
      *                                                                 16420000
      *                                                                 16430000
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16460000
      *                                                                 16470000
      ******************************************************************16480000
      * 5100-GET-REGISTER-DETAILS.                                     *16490000
      *       -- THIS MODULE RETRIEVES THE REGISTER DATA FOR A GIVEN   *16500000
      *          METER.                                                *16510000
      ******************************************************************16520000
       5100-GET-REGISTER-DETAILS.                                       
      *                                                                 16540000
           PERFORM 7420-OPEN-REGISTER-CURSOR   THRU 7420-EXIT.          
           PERFORM 7430-FETCH-REGISTER-CURSOR  THRU 7430-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 5120-FETCH-ALL-REG-DATA      THRU 5120-EXIT       
                  UNTIL SQLCODE = +100                                  
           END-IF.                                                      
           PERFORM 7440-CLOSE-REGISTER-CURSOR  THRU 7440-EXIT.          
C33887     PERFORM 7470-CLOSE-AMRCURSOR         THRU 7470-EXIT.         
      *                                                                 16590000
      *                                                                 16600000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16630000
      *                                                                 17510000
      ******************************************************************17520000
      * 5110- SET-REGISTER-RETURNS.                                    *17530000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*17540000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *17550000
      ******************************************************************17560000
       5110-SET-REGISTER-RETURNS.                                       
      *                                                                 17580000
           PERFORM 5040-SET-METER-RETURNS THRU 5040-EXIT.               
           MOVE RG-REG-ID-NO              TO RS-REG-ID-NO.              
           MOVE RG-CODE-TIME-PERIOD       TO RS-CODE-TIME-PERIOD.       
                                                                        
      *    TPR #4637 - NEED TO GET THE NEW REGISTER'S CONSTANT AND      17620100
      *    DIALS FROM CSS_MTR_CAP.                                      17620200
           MOVE RG-REG-ID-NO              TO MN-REG-ID-NO.              
           PERFORM 7200-GET-METER-CAP-DETAILS   THRU 7200-EXIT.         
                                                                        
           MOVE MC-CONSTANT               TO RS-CONSTANT                
           MOVE MC-NO-READ-DIALS          TO RS-NO-READ-DIALS           
           MOVE RG-CODE-REG-STATUS        TO RS-CODE-REG-STATUS.        
           MOVE RG-CODE-STATUS-REAS       TO RS-CODE-STATUS-REAS.       
                                                                        
ECC        PERFORM 7500-GET-USAGE-VALS    THRU 7500-EXIT.               
A00714     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A00714        MOVE SPACES                TO WS-METER-USAGE-DESC         
A00714                                      WS-USAGE-TYPE-DESC          
A00714     END-IF                                                       
                                                                        
           MOVE WS-METER-USAGE-DESC       TO RS-METER-USAGE-DESC.       
           MOVE WS-USAGE-TYPE-DESC        TO RS-CODE-USAGE-TYPE.        
                                                                        
ECC        MOVE RG-REGISTER-RD-SEQ        TO RS-REGISTER-RD-SEQ.        
           MOVE RG-LAST-READ-VALUE        TO RS-LAST-READ-VALUE.        
      *                                                                         
T16866     IF RG-LAST-REG-READ-TM EQUAL '12:00 AM'                      
T16866        MOVE RG-LAST-REG-READ-DT     TO WS-DATE-READ              
T16866        PERFORM 8650-ADD-ONE-DAY     THRU 8650-EXIT               
T16866        MOVE WS-DATE-READ            TO RS-LAST-REG-READ-DT       
T16866     ELSE                                                         
              MOVE RG-LAST-REG-READ-DT     TO RS-LAST-REG-READ-DT       
T16866     END-IF.                                                      
      *                                                                         
           MOVE RG-LAST-REG-READ-TM       TO RS-LAST-REG-READ-TM.       
           MOVE RG-CODE-LAST-REG-READ     TO RS-CODE-LAST-REG-READ.     
           MOVE RG-LAST-VAL-RD-VALUE      TO RS-LAST-VAL-RD-VALUE.      
      *                                                                         
T16866     IF RG-LAST-VALID-READ-TM EQUAL '12:00 AM'                    
T16866        MOVE RG-LAST-VALID-READ-DT   TO WS-DATE-READ              
T16866        PERFORM 8650-ADD-ONE-DAY     THRU 8650-EXIT               
T16866        MOVE WS-DATE-READ            TO RS-LAST-VALID-READ-DT     
T16866     ELSE                                                         
              MOVE RG-LAST-VALID-READ-DT   TO RS-LAST-VALID-READ-DT     
T16866     END-IF.                                                      
      *                                                                         
           MOVE RG-LAST-VALID-READ-TM     TO RS-LAST-VALID-READ-TM.     
           MOVE RG-CODE-LAST-VALID-RD     TO RS-CODE-LAST-VALID-RD.     
           MOVE RG-CODE-CRNT-REG-READ     TO RS-CODE-CRNT-REG-READ.     
           MOVE RG-CODE-NO-RD-REASON      TO RS-CODE-NO-RD-REASON.      
      *                                                                 17840000
      *                                                                 17850000
       5110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17880000
      *                                                                 16950000
      ******************************************************************16960000
      * 5120-FETCH-ALL-REG-DATA.                                    *   16970000
      *     -- THIS MODULE GETS THE DATA FOR ALL REGISTERS          *   16980000
      ******************************************************************16990000
       5120-FETCH-ALL-REG-DATA.                                         
      *                                                                 17010000
C33887     PERFORM 7460-FETCH-AMRCURSOR        THRU 7460-EXIT.          
C33887*                                                                 16910000
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887         PERFORM 7480-GET-AMR-DETAILS        THRU 7480-EXIT       
C33887     END-IF.                                                      
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887         PERFORM 7490-GET-EQP-ATTCHMTS-DESC THRU 7490-EXIT        
C33887     END-IF.                                                      
C33887*                                                                 16910000
C33887     MOVE WS-DEVICE-NO          TO RS-DEVICE-NO                   
C33887     MOVE WS-CODE-ATT-TYPE      TO RS-CODE-ATT-TYPE               
C33887     MOVE WS-CODE-SHORT-DESC    TO RS-CODE-SHORT-DESC             
C33887     MOVE WS-MTR-ATT-TYPE-TX    TO RS-MTR-ATT-TYPE-TX             
           PERFORM 5110-SET-REGISTER-RETURNS   THRU 5110-EXIT.          
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARCH     PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 7430-FETCH-REGISTER-CURSOR  THRU 7430-EXIT.          
      *                                                                 17450000
      *                                                                 17460000
       5120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17490000
      ******************************************************************18210000
      * 7000- RETRIEVE SYSTEM DATE                                     *18220000
      *       -- THIS MODULE RETRIEVES THE SYSTEM DATE FOR RETRIEVING  *18230000
      *          READ DATE.                                            *18240000
      ******************************************************************18250000
      *                                                                 18260000
       7000-GET-CURRENT-DATE.                                           
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     18280000
MFA-TR*         SET :WS-RUN-DATE = CURRENT DATE                         18290000
MFA-TR*    END-EXEC.                                                    18320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CURRENT DATE'            TO TABLE-ELEMENT-1         
              MOVE WS-RUN-DATE               TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 18490000
       7000-EXIT.                                                       
           EXIT.                                                        
T22243*                                                                         
T22243*****************************************************************         
T22243*7010-GET-COMPANY-NO.                                           *         
T22243*      TO GET COMPANY NUMBER FROM CSS_ACCOUNT TABLE             *         
T22243*****************************************************************         
T22243 7010-GET-COMPANY-NO.                                             
T22243     EXEC SQL                                                     
T22243         SELECT   COMPANY_NO                                      
T22243           INTO  :WS-DEFAULT-COMPANY-NO                           
T22243           FROM   CSS_ACCOUNT                                     
T22243          WHERE   ACCOUNT_NO  = :WS-ACCOUNT-NO-COMP               
T22243     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243*                                                                 19530000
T22243     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T22243     IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
T22243        CONTINUE                                                  
T22243     ELSE                                                         
T22243        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
T22243        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T22243        MOVE '7010'                    TO ACTIVE-PARAGRAPH        
T22243        MOVE 'SELECT'                  TO ABEND-FUNCTION          
T22243        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
T22243                                          ABEND-TABLES            
T22243        MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
T22243        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
T22243        MOVE WS-ACCOUNT-NO-COMP        TO HOSTVAR-ELEMENT-1       
T22243        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T22243        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T22243     END-IF.                                                      
T22243*                                                                 19900000
T22243 7010-EXIT.                                                       
T22243     EXIT.                                                        
      *                                                                 18520000
      *                                                                 18530000
      ******************************************************************18540000
      * 7100-GET-METER.                                                *18550000
      *       -- THIS MODULE RETRIEVES THE METER DATA TO CREATE THE    *18560000
      *          RESULT SET.                                           *18570000
      ******************************************************************18580000
       7100-GET-METER.                                                  
      *                                                                 18600000
           EXEC SQL                                                     
               SELECT IC_NO,                                            
                      MTR_REF_NO,                                       
                      CIS.CHAR2$DATE(DATE_MTR_INSTALL,'USA'),                   
C24056*               POINT_ID,                                         18650000
                      DIGTL_MTR_TYPE,                                   
                      METER_SUPPLYING,                                  
                      CODE_METER_LOC,                                   
                      NO_CONSEC_ESTIMATE,                               
                      NO_CONSEC_CRD_READ,                               
                      MTR_READ_SOURCE_CD,                               
                      HEXAGRAM_LOCATION,                                
                      CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ), MTR_STATUS_CHNG_DT )),         
                      CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ), MTR_STATUS_CHNG_DT )),         
                      SEAL_CODE_ID,                                     
                      INSULATED_IND,                                    
                      LOCK_TYPE_ID,                                     
                      IDR_RECIPIENT_CD,                                 
                      DELIVERY_LEVEL_CD,                                
                      UTILITY_SOURCE_CD,                                
                      IC_NO,                                            
                      CODE_DATA_PRESENT,                                
                      REG_ID_NO,                                        
                      CODE_TIME_PERIOD,                                 
                      CODE_METER_STATUS,                                
                      CODE_STATUS_REAS,                                 
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_TYPE,                                  
                      CODE_USAGE_SOURCE,                                
ECC                   REGISTER_RD_SEQ,                                  
                      LAST_READ_VALUE,                                  
                      CIS.CHAR2$DATE(LAST_REG_READ_DATE,'USA'),                 
                      CIS.CHAR2$TIME(LAST_REG_READ_TIME,'USA'),                 
                      CODE_LAST_REG_READ,                               
                      LAST_VAL_RD_VALUE,                                
                      CIS.CHAR2$DATE(LAST_VALID_READ_DT,'USA'),                 
                      CIS.CHAR2$TIME(LAST_VALID_READ_TM,'USA'),                 
                      CODE_LAST_VALID_RD,                               
                      CODE_CRNT_REG_READ,                               
                      CODE_MTR_RD_INST1,                                
                      CODE_MTR_RD_INST2,                                
                      CODE_MTR_RD_INST3,                                
                      CODE_NO_RD_REASON,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      REMOTE_READ_IND,                                  
C27236                PROGRAM_ID,                                       
C27236                INDUST_BTU_ID,                                    
C27236                MAX_NO_UNITS,                                     
C27236                MIN_NO_UNITS,                                     
C24056                GIS_POINT_ID,                                     
C30989                METER_PRESSURE,                                   
P00545                GIS_MISMATCH_FL                                   
                 INTO :MN-IC-NO,                                        
                      :MN-MTR-REF-NO,                                   
                      :MN-DATE-MTR-INSTALL :WS-NULL-IND-1,              
C24056*               :MN-POINT-ID,                                     19080000
                      :MN-DIGTL-MTR-TYPE,                               
                      :MN-METER-SUPPLYING,                              
                      :MN-CODE-METER-LOC,                               
                      :MN-NO-CONSEC-ESTIMATE,                           
                      :MN-NO-CONSEC-CRD-READ,                           
                      :MN-MTR-READ-SOURCE-CD,                           
                      :MN-HEXAGRAM-LOCATION,                            
                      :WS-INACTIVE-YEAR :WS-NULL-IND-6,                 
                      :WS-INACTIVE-MONTH :WS-NULL-IND-7,                
                      :MN-SEAL-CODE-ID,                                 
                      :MN-INSULATED-IND,                                
                      :MN-LOCK-TYPE-ID,                                 
                      :MN-IDR-RECIPIENT-CD,                             
                      :MN-DELIVERY-LEVEL-CD,                            
                      :MN-UTILITY-SOURCE-CD,                            
                      :MN-IC-NO,                                        
                      :MN-CODE-DATA-PRESENT,                            
                      :MN-REG-ID-NO,                                    
                      :MN-CODE-TIME-PERIOD,                             
                      :MN-CODE-METER-STATUS,                            
                      :MN-CODE-STATUS-REAS,                             
                      :WS-USAGE-ID,                                     
                      :WS-USAGE-TYPE,                                   
                      :WS-USAGE-SOURCE,                                 
ECC                   :MN-REGISTER-RD-SEQ,                              
                      :MN-LAST-READ-VALUE,                              
                      :MN-LAST-REG-READ-DATE :WS-NULL-IND-2,            
                      :MN-LAST-REG-READ-TIME :WS-NULL-IND-3,            
                      :MN-CODE-LAST-REG-READ,                           
                      :MN-LAST-VAL-RD-VALUE,                            
                      :MN-LAST-VALID-READ-DT :WS-NULL-IND-4,            
                      :MN-LAST-VALID-READ-TM :WS-NULL-IND-5,            
                      :MN-CODE-LAST-VALID-RD,                           
                      :MN-CODE-CRNT-REG-READ,                           
                      :MN-CODE-MTR-RD-INST1,                            
                      :MN-CODE-MTR-RD-INST2,                            
                      :MN-CODE-MTR-RD-INST3,                            
                      :MN-CODE-NO-RD-REASON,                            
                      :WS-LAST-UPDATE-TS,                               
                      :MN-REMOTE-READ-IND,                              
C27236                :MN-PROGRAM-ID,                                   
C27236                :MN-INDUST-BTU-ID,                                
C27236                :MN-MAX-NO-UNITS,                                 
C27236                :MN-MIN-NO-UNITS,                                 
C24056                :MN-GIS-POINT-ID,                                 
C30989                :MN-METER-PRESSURE,                               
P00545                :MN-GIS-MISMATCH-FL                               
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP           
                  AND CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND METER_NO          = :WS-METER-NO                  
T19090            AND IC_NO             = :WS-IC-NO                     
T19090            AND MTR_REF_NO        = :WS-MTR-REF-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     18610000
MFA-TR*        SELECT IC_NO,                                            18620000
MFA-TR*               MTR_REF_NO,                                       18630000
MFA-TR*               CHAR(DATE_MTR_INSTALL,USA),                       18640000
MFA-TR*               POINT_ID,                                         18650000
MFA-TR*               DIGTL_MTR_TYPE,                                   18660000
MFA-TR*               METER_SUPPLYING,                                  18670000
MFA-TR*               CODE_METER_LOC,                                   18680000
MFA-TR*               NO_CONSEC_ESTIMATE,                               18690000
MFA-TR*               NO_CONSEC_CRD_READ,                               18700000
MFA-TR*               MTR_READ_SOURCE_CD,                               18710000
MFA-TR*               HEXAGRAM_LOCATION,                                18720000
MFA-TR*               YEAR(:WS-RUN-DATE - MTR_STATUS_CHNG_DT),          18730000
MFA-TR*               MONTH(:WS-RUN-DATE - MTR_STATUS_CHNG_DT),         18740000
MFA-TR*               SEAL_CODE_ID,                                     18750000
MFA-TR*               INSULATED_IND,                                    18760000
MFA-TR*               LOCK_TYPE_ID,                                     18770000
MFA-TR*               IDR_RECIPIENT_CD,                                 18780000
MFA-TR*               DELIVERY_LEVEL_CD,                                18790000
MFA-TR*               UTILITY_SOURCE_CD,                                18800000
MFA-TR*               IC_NO,                                            18810000
MFA-TR*               CODE_DATA_PRESENT,                                18820000
MFA-TR*               REG_ID_NO,                                        18830000
MFA-TR*               CODE_TIME_PERIOD,                                 18840000
MFA-TR*               CODE_METER_STATUS,                                18850000
MFA-TR*               CODE_STATUS_REAS,                                 18860000
MFA-TR*               CODE_USAGE_ID,                                    18870000
MFA-TR*               CODE_USAGE_TYPE,                                  18880000
MFA-TR*               CODE_USAGE_SOURCE,                                18890000
MFA-TR*               REGISTER_RD_SEQ,                                  18900000
MFA-TR*               LAST_READ_VALUE,                                  18910000
MFA-TR*               CHAR(LAST_REG_READ_DATE,USA),                     18920000
MFA-TR*               CHAR(LAST_REG_READ_TIME,USA),                     18930000
MFA-TR*               CODE_LAST_REG_READ,                               18940000
MFA-TR*               LAST_VAL_RD_VALUE,                                18950000
MFA-TR*               CHAR(LAST_VALID_READ_DT,USA),                     18960000
MFA-TR*               CHAR(LAST_VALID_READ_TM,USA),                     18970000
MFA-TR*               CODE_LAST_VALID_RD,                               18980000
MFA-TR*               CODE_CRNT_REG_READ,                               18990000
MFA-TR*               CODE_MTR_RD_INST1,                                19000000
MFA-TR*               CODE_MTR_RD_INST2,                                19010000
MFA-TR*               CODE_MTR_RD_INST3,                                19020000
MFA-TR*               CODE_NO_RD_REASON,                                19030000
MFA-TR*               LAST_UPDATE_TS,                                   19040000
MFA-TR*               REMOTE_READ_IND,                                  19041000
MFA-TR*               PROGRAM_ID,                                               
MFA-TR*               INDUST_BTU_ID,                                            
MFA-TR*               MAX_NO_UNITS,                                             
MFA-TR*               MIN_NO_UNITS,                                             
MFA-TR*               GIS_POINT_ID,                                             
MFA-TR*               METER_PRESSURE,                                           
MFA-TR*               GIS_MISMATCH_FL                                           
MFA-TR*          INTO :MN-IC-NO,                                        19050000
MFA-TR*               :MN-MTR-REF-NO,                                   19060000
MFA-TR*               :MN-DATE-MTR-INSTALL :WS-NULL-IND-1,              19070000
MFA-TR*               :MN-POINT-ID,                                     19080000
MFA-TR*               :MN-DIGTL-MTR-TYPE,                               19090000
MFA-TR*               :MN-METER-SUPPLYING,                              19100000
MFA-TR*               :MN-CODE-METER-LOC,                               19110000
MFA-TR*               :MN-NO-CONSEC-ESTIMATE,                           19120000
MFA-TR*               :MN-NO-CONSEC-CRD-READ,                           19130000
MFA-TR*               :MN-MTR-READ-SOURCE-CD,                           19140000
MFA-TR*               :MN-HEXAGRAM-LOCATION,                            19150000
MFA-TR*               :WS-INACTIVE-YEAR :WS-NULL-IND-6,                 19160000
MFA-TR*               :WS-INACTIVE-MONTH :WS-NULL-IND-7,                19170000
MFA-TR*               :MN-SEAL-CODE-ID,                                 19180000
MFA-TR*               :MN-INSULATED-IND,                                19190000
MFA-TR*               :MN-LOCK-TYPE-ID,                                 19200000
MFA-TR*               :MN-IDR-RECIPIENT-CD,                             19210000
MFA-TR*               :MN-DELIVERY-LEVEL-CD,                            19220000
MFA-TR*               :MN-UTILITY-SOURCE-CD,                            19230000
MFA-TR*               :MN-IC-NO,                                        19240000
MFA-TR*               :MN-CODE-DATA-PRESENT,                            19250000
MFA-TR*               :MN-REG-ID-NO,                                    19260000
MFA-TR*               :MN-CODE-TIME-PERIOD,                             19270000
MFA-TR*               :MN-CODE-METER-STATUS,                            19280000
MFA-TR*               :MN-CODE-STATUS-REAS,                             19290000
MFA-TR*               :WS-USAGE-ID,                                     19300000
MFA-TR*               :WS-USAGE-TYPE,                                   19310000
MFA-TR*               :WS-USAGE-SOURCE,                                 19320000
MFA-TR*               :MN-REGISTER-RD-SEQ,                              19330000
MFA-TR*               :MN-LAST-READ-VALUE,                              19340000
MFA-TR*               :MN-LAST-REG-READ-DATE :WS-NULL-IND-2,            19350000
MFA-TR*               :MN-LAST-REG-READ-TIME :WS-NULL-IND-3,            19360000
MFA-TR*               :MN-CODE-LAST-REG-READ,                           19370000
MFA-TR*               :MN-LAST-VAL-RD-VALUE,                            19380000
MFA-TR*               :MN-LAST-VALID-READ-DT :WS-NULL-IND-4,            19390000
MFA-TR*               :MN-LAST-VALID-READ-TM :WS-NULL-IND-5,            19400000
MFA-TR*               :MN-CODE-LAST-VALID-RD,                           19410000
MFA-TR*               :MN-CODE-CRNT-REG-READ,                           19420000
MFA-TR*               :MN-CODE-MTR-RD-INST1,                            19430000
MFA-TR*               :MN-CODE-MTR-RD-INST2,                            19440000
MFA-TR*               :MN-CODE-MTR-RD-INST3,                            19450000
MFA-TR*               :MN-CODE-NO-RD-REASON,                            19460000
MFA-TR*               :WS-LAST-UPDATE-TS,                               19470000
MFA-TR*               :MN-REMOTE-READ-IND,                              19471000
MFA-TR*               :MN-PROGRAM-ID,                                           
MFA-TR*               :MN-INDUST-BTU-ID,                                        
MFA-TR*               :MN-MAX-NO-UNITS,                                         
MFA-TR*               :MN-MIN-NO-UNITS,                                         
MFA-TR*               :MN-GIS-POINT-ID,                                         
MFA-TR*               :MN-METER-PRESSURE,                                       
MFA-TR*               :MN-GIS-MISMATCH-FL                                       
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                  19480000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP           19490000
MFA-TR*           AND CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            19500000
MFA-TR*           AND METER_NO          = :WS-METER-NO                  19510000
MFA-TR*           AND IC_NO             = :WS-IC-NO                             
MFA-TR*           AND MTR_REF_NO        = :WS-MTR-REF-NO                        
MFA-TR*    END-EXEC.                                                    19520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19530000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-1 < ZERO                                   
                  MOVE LOW-VALUES            TO MN-DATE-MTR-INSTALL     
              END-IF                                                    
              IF WS-NULL-IND-2 < ZERO                                   
                  MOVE LOW-VALUES            TO MN-LAST-REG-READ-TIME   
              END-IF                                                    
              IF WS-NULL-IND-3 < ZERO                                   
                  MOVE LOW-VALUES            TO MN-LAST-REG-READ-DATE   
              END-IF                                                    
              IF WS-NULL-IND-4 < ZERO                                   
                  MOVE LOW-VALUES            TO MN-LAST-VALID-READ-TM   
              END-IF                                                    
              IF WS-NULL-IND-5 < ZERO                                   
                  MOVE LOW-VALUES            TO MN-LAST-VALID-READ-DT   
              END-IF                                                    
              IF WS-NULL-IND-6 < ZERO                                   
                  MOVE ZERO                  TO WS-INACTIVE-YEAR        
              END-IF                                                    
              IF WS-NULL-IND-7 < ZERO                                   
                  MOVE ZERO                  TO WS-INACTIVE-MONTH       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'MTR_NO'                  TO TABLE-ELEMENT-3         
CBSI          MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-4         
              MOVE WS-ACCOUNT-NO-COMP        TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-3       
CBSI          MOVE PARM-CUSTOMER-NO          TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 19890000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19930000
      ******************************************************************18540000
C24056* 7110-GET-GIS-LOC-AND-TAG.                                       18550000
      *       -- THIS MODULE RETRIEVES THE GIS LOCAL OFFICE CODE AND  * 18560000
      *          TAG TO COMPLETE THE RETRIEVE SET.                     *18570000
      ******************************************************************18580000
       7110-GET-GIS-LOC-AND-TAG.                                        
C32936*    IF MN-GIS-POINT-ID = 0                                               
C32936     IF MN-GIS-POINT-ID <= 0                                      
C32936        MOVE 0 TO MN-GIS-POINT-ID                                 
              GO TO 7110-EXIT                                           
           ELSE                                                         
            NEXT SENTENCE                                               
           END-IF.                                                      
           EXEC SQL                                                     
P33743         SELECT AREA_ID,                                          
                      TAG_NM                                            
P33743           INTO :PP-AREA-ID,                                      
P33743                :PP-TAG-NM                                        
P33743           FROM CSS_PIM_POINT                                     
                WHERE POINT_ID = :MN-GIS-POINT-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
C32936     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C32936        MOVE 0 TO MN-GIS-POINT-ID                                 
C32936        CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
P33743        MOVE 'CSS_PIM_POINT'           TO TABLE-1                 
P33743        MOVE 'GIS-POINT-ID'            TO TABLE-ELEMENT-1         
              MOVE MN-GIS-POINT-ID           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C32936     END-IF                                                       
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
C24056*                                                                         
      *                                                                 19940000
      ******************************************************************19950000
      * 7200-GET-METER-CAP-DETAILS                                     *19960000
      *       -- THIS MODULE RETRIEVES THE METER CAP DETAILS FOR THE   *19970000
      *          RESULT SET.                                           *19980000
      ******************************************************************19990000
       7200-GET-METER-CAP-DETAILS.                                      
           EXEC SQL                                                     
                SELECT CONSTANT,                                        
                       NO_READ_DIALS                                    
                  INTO :MC-CONSTANT,                                    
                       :MC-NO-READ-DIALS                                
                  FROM CSS_MTR_CAP                                      
                 WHERE METER_NO       = :WS-METER-NO                    
                   AND REG_ID_NO      = :MN-REG-ID-NO                   
                   AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
T22243             AND COMPANY_NO     = :MC-COMPANY-NO                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20110000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T26134         NEXT SENTENCE                                            
           ELSE                                                         
T26134        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00714           MOVE ZEROS                 TO CX-CONSTANT              
A00714                                         CX-NO-DIALS              
T26134           PERFORM 7210-GET-DET-CONSUMP-HIST                      
T26134                                       THRU 7210-EXIT             
T26134        MOVE CX-CONSTANT               TO MC-CONSTANT             
T26134        MOVE CX-NO-DIALS               TO MC-NO-READ-DIALS        
T26134                                                                  
T26134        ELSE                                                      
T26134                                                                  
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_CAP'             TO TABLE-1                 
              MOVE 'MTR_NO'                  TO TABLE-ELEMENT-1         
T22243        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-1       
T22243        MOVE MC-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T26134       END-IF                                                     
           END-IF.                                                      
      *                                                                 20270000
      *                                                                 20280000
      *                                                                 20290000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20320000
T26134 7210-GET-DET-CONSUMP-HIST.                                       
      *                                                                         
T26134     EXEC SQL                                                     
T26134          SELECT TOP(1) CONSTANT,
              NO_DIALS                                         
T26134            INTO :CX-CONSTANT,                                    
T26134                 :CX-NO-DIALS                                     
T26134            FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                
T26134           WHERE METER_NO       = :WS-METER-NO                    
T26134             AND ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP             
T26134             AND IC_NO          = :WS-IC-NO                       
T26134             AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
T26134             AND COMPANY_NO     = :MC-COMPANY-NO                  
T26134             AND MTR_REF_NO     = :WS-MTR-REF-NO                  
A00714          ORDER BY BILL_NO DESC                                   
A00714                                       
T26134     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CONSTANT,                                                
MFA-TR*                NO_DIALS                                                 
MFA-TR*           INTO :CX-CONSTANT,                                            
MFA-TR*                :CX-NO-DIALS                                             
MFA-TR*           FROM CSS_CNSMPTN_HIST CX                                      
MFA-TR*          WHERE METER_NO       = :WS-METER-NO                            
MFA-TR*            AND ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP                     
MFA-TR*            AND IC_NO          = :WS-IC-NO                               
MFA-TR*            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                      
MFA-TR*            AND COMPANY_NO     = :MC-COMPANY-NO                          
MFA-TR*            AND MTR_REF_NO     = :WS-MTR-REF-NO                          
MFA-TR*         ORDER BY BILL_NO DESC                                           
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26134*                                                                         
T26134     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T26134     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811           
A00714                                                OR NOT-FOUND      
T26134        NEXT SENTENCE                                             
T26134     ELSE                                                         
T26134        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
T26134        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T26134        MOVE '7210'                 TO ACTIVE-PARAGRAPH           
T26134        MOVE 'SELECT'               TO ABEND-FUNCTION             
T26134        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
T26134                                       ABEND-TABLES               
T26134        MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                    
T26134        MOVE 'MTR_NO'               TO TABLE-ELEMENT-1            
T26134        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2            
T26134        MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3            
T26134        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-4            
T26134        MOVE WS-METER-NO            TO HOSTVAR-ELEMENT-1          
T26134        MOVE MC-COMPANY-NO          TO HOSTVAR-ELEMENT-2          
T26134        MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3          
T26134        MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4          
T26134        PERFORM 9000-SEND-ERROR-RESULT                            
T26134                                   THRU 9000-EXIT                 
T26134        PERFORM 9900-SQL-ERROR-ROUTINE                            
T26134                                    THRU 9900-EXIT                
T26134     END-IF.                                                      
T26134*                                                                         
T26134 7210-EXIT.                                                       
T26134     EXIT.                                                        
T26134*                                                                 20330000
      ******************************************************************20340000
      * 7300-GET-ELEC-METER.                                           *20350000
      *    -- THIS MODULE GETS THE DATA FROM THE APPROPRIATE UTILITY   *20360000
      *       TABLE FOR THE METER RESULT SET.                          *20370000
      ******************************************************************20380000
       7300-GET-ELEC-METER.                                             
      *                                                                 20400000
              EXEC SQL                                                  
                  SELECT CIS.CHAR2$DATE(DATE_LAST_TESTED,'USA'),                
TP2570                   EM.ELEC_MTR_SPEC_CD,                           
C33887                   EM.METER_SIZE_ID,                              
C33887                   EM.DIGTL_MTR_TYPE,                             
C33887                   EM.PROGRAM_ID,                                 
A00714                   EM.ELEC_MTR_CLASS_CD                           
                    INTO :WS-DATE-LAST-TESTED :WS-DATE-LAST-NULL,        
                         :WS-E-MTR-SPEC-CD,                             
C33887                   :WS-E-METER-SIZE-ID,                           
C33887                   :WS-E-DIGTL-MTR-TYPE,                          
C33887                   :WS-E-PROGRAM-ID,                              
A00714                   :WS-E-MTR-CLASS-CD                             
                    FROM CSS_ELEC_METER     EM                          
                   WHERE EM.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE       
                     AND EM.METER_NO         = :WS-METER-NO             
T22243               AND EM.COMPANY_NO       = :EM-COMPANY-NO           
      *                                                                 20480000
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                  20420000
MFA-TR*           SELECT CHAR(DATE_LAST_TESTED,USA),                    20430000
MFA-TR*                  EM.ELEC_MTR_SPEC_CD,                           20431000
MFA-TR*                  EM.METER_SIZE_ID,                              20431000
MFA-TR*                  EM.DIGTL_MTR_TYPE,                             20431000
MFA-TR*                  EM.PROGRAM_ID,                                 20431000
MFA-TR*                  EM.ELEC_MTR_CLASS_CD                           20431000
MFA-TR*             INTO :WS-DATE-LAST-TESTED:WS-DATE-LAST-NULL,        20440000
MFA-TR*                  :WS-E-MTR-SPEC-CD,                             20441000
MFA-TR*                  :WS-E-METER-SIZE-ID,                           20441000
MFA-TR*                  :WS-E-DIGTL-MTR-TYPE,                          20441000
MFA-TR*                  :WS-E-PROGRAM-ID,                              20441000
MFA-TR*                  :WS-E-MTR-CLASS-CD                             20441000
MFA-TR*             FROM CSS_ELEC_METER     EM                          20450000
MFA-TR*            WHERE EM.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE       20460000
MFA-TR*              AND EM.METER_NO         = :WS-METER-NO             20470000
MFA-TR*              AND EM.COMPANY_NO       = :EM-COMPANY-NO                   
MFA-TR*                                                                 20480000
MFA-TR*       END-EXEC                                                  20490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
A00714        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7300'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                   ABEND-TABLES         
                 MOVE 'CSS_ELEC_MTR'          TO TABLE-1                
                 MOVE 'MTR_NO'                TO TABLE-ELEMENT-1        
                 MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2        
CBSI             MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3        
T22243           MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-4        
                 MOVE WS-METER-NO             TO HOSTVAR-ELEMENT-1      
                 MOVE WS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
CBSI             MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3      
T22243           MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-4      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF.                                                   
      *                                                                 20900000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20940000
      ******************************************************************20340000
      * 7310-GET-RMT-RD-CD.                                           * 20350000
      *    -- THIS MODULE GETS THE DATA FROM THE APPROPRIATE UTILITY   *20360000
      *       TABLE FOR THE METER RESULT SET.                          *20370000
      ******************************************************************20380000
       7310-GET-RMT-RD-CD.                                              
      *                                                                 20400000
D2137         EXEC SQL                                                  
A00714            SELECT U5.REMOTE_READ_CODE                            
A00714                  ,U0.ELEC_MTR_FORM_CD                            
A00714                  ,U0.MTR_CONNECT_TYP_ID                          
A00714                  ,U4.NO_PHASES                                   
D2137               INTO :WS-AMR-CAP-FL                                 
A00714                  ,:WS-ELEC-MTR-FORM-CD                           
A00714                  ,:WS-MTR-CONNECT-TYP-ID                         
A00714                  ,:WS-NO-PHASES                                  
D2137               FROM CSS_ELEC_MTR_SPEC  U5                          
A00714                  ,CSS_ELEC_MTR_CLASS U4                          
A00714                  ,CSS_ELEC_CL_SPEC   U0                          
A00714             WHERE U5.ELEC_MTR_SPEC_CD  = :WS-E-MTR-SPEC-CD       
A00714               AND U4.ELEC_MTR_CLASS_CD = :WS-E-MTR-CLASS-CD      
A00714               AND U0.ELEC_MTR_SPEC_CD  = U5.ELEC_MTR_SPEC_CD     
A00714               AND U0.ELEC_MTR_CLASS_CD = U4.ELEC_MTR_CLASS_CD    
D2137         END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20649900
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
A00714        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7310'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                   ABEND-TABLES         
CBSI             MOVE 'CSS_ELEC_CL_SPEC'      TO TABLE-1                
                 MOVE 'ELEC_MTR_SPEC_CD'      TO TABLE-ELEMENT-1        
A00714           MOVE 'ELEC_MTR_CLASS_CD'     TO TABLE-ELEMENT-2        
CBSI             MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3        
                 MOVE WS-E-MTR-SPEC-CD        TO HOSTVAR-ELEMENT-1      
A00714           MOVE WS-E-MTR-CLASS-CD       TO HOSTVAR-ELEMENT-2      
CBSI             MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF.                                                   
      *                                                                 20900000
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************20340000
      * 7320-GET-GAS-METER.                                      *      20350000
      *    -- THIS MODULE GETS THE DATA FROM THE APPROPRIATE UTILITY   *20360000
      *       TABLE FOR THE METER RESULT SET.                          *20370000
      ******************************************************************20380000
       7320-GET-GAS-METER.                                              
      *                                                                 20400000
              EXEC SQL                                                  
                  SELECT CIS.CHAR2$DATE(DATE_LAST_TESTED,'USA'),                
C33887                   METER_SIZE_ID,                                 
C33887                   DIGTL_MTR_TYPE,                                
C33887                   PROGRAM_ID                                     
                    INTO :WS-DATE-LAST-TESTED :WS-DATE-LAST-NULL,        
C33887                   :WS-G-METER-SIZE-ID,                           
C33887                   :WS-G-DIGTL-MTR-TYPE,                          
C33887                   :WS-G-PROGRAM-ID                               
                    FROM CSS_GAS_METER                                  
                   WHERE CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            
                     AND METER_NO       = :WS-METER-NO                  
T22243               AND COMPANY_NO     = :GM-COMPANY-NO                
      *                                                                 20720000
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                  20660000
MFA-TR*           SELECT CHAR(DATE_LAST_TESTED,USA),                    20670000
MFA-TR*                  METER_SIZE_ID,                                 20431000
MFA-TR*                  DIGTL_MTR_TYPE,                                20431000
MFA-TR*                  PROGRAM_ID                                     20431000
MFA-TR*             INTO :WS-DATE-LAST-TESTED:WS-DATE-LAST-NULL,        20680000
MFA-TR*                  :WS-G-METER-SIZE-ID,                           20441000
MFA-TR*                  :WS-G-DIGTL-MTR-TYPE,                          20441000
MFA-TR*                  :WS-G-PROGRAM-ID                               20441000
MFA-TR*             FROM CSS_GAS_METER                                  20690000
MFA-TR*            WHERE CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            20700000
MFA-TR*              AND METER_NO       = :WS-METER-NO                  20710000
MFA-TR*              AND COMPANY_NO     = :GM-COMPANY-NO                20710000
MFA-TR*                                                                 20720000
MFA-TR*       END-EXEC                                                  20730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
A00714        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7320'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                   ABEND-TABLES         
CBSI             MOVE 'CSS_GAS_METER'         TO TABLE-1                
CBSI             MOVE 'METER_NO'              TO TABLE-ELEMENT-1        
                 MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2        
T22243           MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3        
                 MOVE WS-METER-NO             TO HOSTVAR-ELEMENT-1      
                 MOVE WS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
T22243           MOVE GM-COMPANY-NO           TO HOSTVAR-ELEMENT-3      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF.                                                   
      *                                                                 20900000
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 16640000
      ******************************************************************16650000
      * 7420-OPEN-REGISTER-CURSOR.                                     *16660000
      *       -- THIS MODULE OPENS THE CURSOR THAT WILL CREATE THE     *16670000
      *          RESULT SET OF REGISTERS FOR A PARTICULAR METER.       *16680000
      ******************************************************************16690000
       7420-OPEN-REGISTER-CURSOR.                                       
      *                                                                 16710000
           EXEC SQL                                                     
               OPEN REGISTERCURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16750000
      *                                                                 16760000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7420'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'OPEN'               TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_REGISTER_READ'  TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'IC_NO'              TO TABLE-ELEMENT-3             
               MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           
               MOVE MN-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 16910000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16940000
      *                                                                 16950000
      ******************************************************************16960000
      * 7430-FETCH-REGISTER-CURSOR.                                    *16970000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF REGISTERS.       *16980000
      ******************************************************************16990000
       7430-FETCH-REGISTER-CURSOR.                                      
      *                                                                 17010000
           EXEC SQL                                                     
               FETCH REGISTERCURSOR                                     
                INTO :RG-REG-ID-NO,                                     
                     :RG-CODE-TIME-PERIOD,                              
                     :RG-CODE-REG-STATUS,                               
                     :RG-CODE-STATUS-REAS,                              
                     :WS-USAGE-ID,                                      
                     :WS-USAGE-TYPE,                                    
                     :WS-USAGE-SOURCE,                                  
ECC                  :RG-REGISTER-RD-SEQ,                               
                     :RG-LAST-READ-VALUE,                               
                     :RG-LAST-REG-READ-DT,                              
                     :RG-LAST-REG-READ-TM,                              
                     :RG-CODE-LAST-REG-READ,                            
                     :RG-LAST-VAL-RD-VALUE,                             
                     :RG-LAST-VALID-READ-DT,                            
                     :RG-LAST-VALID-READ-TM,                            
                     :RG-CODE-LAST-VALID-RD,                            
                     :RG-CODE-CRNT-REG-READ,                            
                     :RG-CODE-NO-RD-REASON,                             
                     :WS-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17240000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 17260000
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33887          NEXT SENTENCE                                           
C33887     ELSE                                                         
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7430'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'FETCH'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
C33887         MOVE 'CSS_REGISTER_READ'  TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'IC_NO'              TO TABLE-ELEMENT-3             
               MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           
               MOVE MN-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT     
               PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                 17460000
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17490000
      *                                                                 17500000
      *                                                                 17890000
      ******************************************************************17900000
      * 7440-CLOSE-REGISTER-CURSOR                                     *17910000
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *17920000
      ******************************************************************17930000
       7440-CLOSE-REGISTER-CURSOR.                                      
      *                                                                 17950000
           EXEC SQL                                                     
               CLOSE REGISTERCURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17990000
      *                                                                 18000000
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7440'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'CLOSE'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_REGISTER_READ'  TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'IC_NO'              TO TABLE-ELEMENT-3             
               MOVE 'MTR_REF_NO'         TO TABLE-ELEMENT-4             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-3           
               MOVE MN-MTR-REF-NO        TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18150000
      *                                                                 18160000
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18190000
C33887******************************************************************16650000
C33887* 7450-OPEN-AMRCURSOR                                            *16660000
C33887******************************************************************16690000
C33887 7450-OPEN-AMRCURSOR.                                             
C33887*                                                                 16710000
C33887     EXEC SQL                                                     
C33887         OPEN AMRCURSOR                                           
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                 16750000
C33887*                                                                 16760000
C33887     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C33887                                                                  
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887         NEXT SENTENCE                                            
C33887     ELSE                                                         
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7450'               TO ACTIVE-PARAGRAPH            
C33887         MOVE 'OPEN'               TO ABEND-FUNCTION              
C33887         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C33887                                      ABEND-TABLES                
C33887         MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                     
C33887         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C33887         MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2             
C33887         MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
C33887         MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4             
C33887         MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
C33887         MOVE WS-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2           
C33887         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
C33887         MOVE WS-DEFAULT-COMPANY-NO TO HOSTVAR-ELEMENT-4          
C33887         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C33887         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C33887     END-IF.                                                      
C33887*                                                                 16910000
C33887 7450-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                 16710000
C33887******************************************************************16650000
C33887* 7460-FETCH-AMRCURSOR                                           *16660000
C33887******************************************************************16690000
C33887 7460-FETCH-AMRCURSOR.                                            
C33887*                                                                 17010000
C33887     EXEC SQL                                                     
C33887         FETCH AMRCURSOR                                          
C33887           INTO :WS-DEVICE-NO,                                    
C33887                :WS-CODE-ATT-TYPE,                                
C33887                :WS-COMPANY-NO,                                   
C33887                :WS-MTR-ATT-TYPE-TX                               
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                 16760000
C33887     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C33887                                                                  
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33887         NEXT SENTENCE                                            
C33887     ELSE                                                         
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7460'               TO ACTIVE-PARAGRAPH            
C33887         MOVE 'FETCH'              TO ABEND-FUNCTION              
C33887         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C33887                                      ABEND-TABLES                
C33887         MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                     
C33887         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C33887         MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2             
C33887         MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
C33887         MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4             
C33887         MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
C33887         MOVE WS-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2           
C33887         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
C33887         MOVE WS-DEFAULT-COMPANY-NO TO HOSTVAR-ELEMENT-4          
C33887         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C33887         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C33887     END-IF.                                                      
C33887*                                                                 16910000
C33887 7460-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                 18190000
C33887******************************************************************16650000
C33887* 7470-CLOSE-AMRCURSOR                                           *16660000
C33887******************************************************************16690000
C33887 7470-CLOSE-AMRCURSOR.                                            
C33887*                                                                 16710000
C33887     EXEC SQL                                                     
C33887         CLOSE AMRCURSOR                                          
C33887     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                 16750000
C33887     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C33887                                                                  
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33887         NEXT SENTENCE                                            
C33887     ELSE                                                         
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7470'               TO ACTIVE-PARAGRAPH            
C33887         MOVE 'CLOSE'              TO ABEND-FUNCTION              
C33887         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C33887                                      ABEND-TABLES                
C33887         MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                     
C33887         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C33887         MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2             
C33887         MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
C33887         MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4             
C33887         MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
C33887         MOVE WS-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2           
C33887         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
C33887         MOVE WS-DEFAULT-COMPANY-NO TO HOSTVAR-ELEMENT-4          
C33887         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C33887         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C33887     END-IF.                                                      
C33887*                                                                 16910000
C33887 7470-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                 16710000
C33887******************************************************************17900000
C33887* 7480-GET-AMR-DETAILS                                           *17910000
C33887******************************************************************17930000
C33887 7480-GET-AMR-DETAILS.                                            
C33887*                                                                 17950000
C33887     EXEC SQL                                                     
C33887          SELECT VERSION_CD                                       
C33887            INTO :WS-VERSION-CD                                   
C33887            FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
C33887           WHERE CODE_ATT_TYPE     = :WS-CODE-ATT-TYPE            
C33887             AND COMPANY_NO        = :WS-DEFAULT-COMPANY-NO       
C33887             AND CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE           
C33887             AND DEVICE_NO         = :WS-DEVICE-NO                
C33887                                                           
C33887     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*         SELECT VERSION_CD                                               
MFA-TR*           INTO :WS-VERSION-CD                                           
MFA-TR*           FROM CSS_EQUIP_ATTCHMTS                                       
MFA-TR*          WHERE CODE_ATT_TYPE     = :WS-CODE-ATT-TYPE                    
MFA-TR*            AND COMPANY_NO        = :WS-DEFAULT-COMPANY-NO               
MFA-TR*            AND CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                   
MFA-TR*            AND DEVICE_NO         = :WS-DEVICE-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    17980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                 18000000
C33887     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
C33887                                                                  
C33887     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33887         NEXT SENTENCE                                            
C33887     ELSE                                                         
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7480'               TO ACTIVE-PARAGRAPH            
C33887         MOVE 'SELECT'             TO ABEND-FUNCTION              
C33887         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C33887                                      ABEND-TABLES                
C33887         MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                     
C33887         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C33887         MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2             
C33887         MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
C33887         MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4             
C33887         MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
C33887         MOVE WS-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2           
C33887         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
C33887         MOVE WS-DEFAULT-COMPANY-NO TO HOSTVAR-ELEMENT-4          
C33887         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C33887         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C33887     END-IF.                                                      
C33887*                                                                 18160000
C33887 7480-EXIT.                                                       
C33887     EXIT.                                                        
C33887*                                                                 18190000
C33887******************************************************************17900000
C33887* 7490-GET-EQP-ATTCHMTS-DESC                                     *17910000
C33887******************************************************************17930000
C33887 7490-GET-EQP-ATTCHMTS-DESC.                                      
C33887*                                                                 17950000
C33887*                                                                         
C33887     STRING WS-CODE-UTIL-TYPE                                     
C33887            WS-CODE-ATT-TYPE                                      
C33887            WS-VERSION-CD                                         
C33887            DELIMITED BY SIZE                                     
C33887            INTO WS-VERSION-CD-VALUE.                             
C33887*                                                                         
C33887*                                                                         
C33887       EXEC SQL                                                   
C33887            SELECT  CODE_SHORT_DESC                               
C33887              INTO :WS-CODE-SHORT-DESC                            
C33887              FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                   
C33887             WHERE COMPANY_NO    = :WS-COMPANY-NO                 
C33887               AND TABLE_NA      = 'CSS_EQUIP_ATTCHMTS'           
C33887               AND COLUMN_NA     = 'VERSION_CD'                   
C33887               AND CODE_VALUE    = :WS-VERSION-CD-VALUE           
C33887                                                           
C33887       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                   17960000
MFA-TR*           SELECT  CODE_SHORT_DESC                                       
MFA-TR*             INTO :WS-CODE-SHORT-DESC                                    
MFA-TR*             FROM CSS_CODE_VALUE                                         
MFA-TR*            WHERE COMPANY_NO    = :WS-COMPANY-NO                         
MFA-TR*              AND TABLE_NA      = 'CSS_EQUIP_ATTCHMTS'                   
MFA-TR*              AND COLUMN_NA     = 'VERSION_CD'                           
MFA-TR*              AND CODE_VALUE    = :WS-VERSION-CD-VALUE                   
MFA-TR*            WITH UR                                                      
MFA-TR*      END-EXEC                                                   17980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887*                                                                 17990000
C33887       MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE          
C33887                                                                  
C33887       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
C33887           NEXT SENTENCE                                          
C33887       ELSE                                                       
C33887         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C33887         MOVE '7490'               TO ACTIVE-PARAGRAPH            
C33887         MOVE 'SELECT'             TO ABEND-FUNCTION              
C33887         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C33887                                      ABEND-TABLES                
C33887         MOVE 'CSS_CODE_VALUE    ' TO TABLE-1                     
C33887         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C33887         MOVE 'COMPANY_NO '        TO TABLE-ELEMENT-2             
C33887         MOVE 'CODE_VALUE'         TO TABLE-ELEMENT-3             
C33887         MOVE WS-COMPANY-NO        TO HOSTVAR-ELEMENT-1           
C33887         MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
C33887         MOVE WS-VERSION-CD        TO HOSTVAR-ELEMENT-3           
C33887         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C33887         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C33887       END-IF.                                                    
C33887*                                                                 18150000
C33887*                                                                 18160000
C33887 7490-EXIT.                                                       
C33887     EXIT.                                                        
      ******************************************************************21390000
      * 7500-GET-USAGE-VALS.                                           *21400000
      *    -- THIS MODULE GETS THE VALUE FOR THE USAGE DATA FOR THE    *21410000
      *       RESULT SET.                                              *21420000
      ******************************************************************21430000
       7500-GET-USAGE-VALS.                                             
      *                                                                 21450000
           EXEC SQL                                                     
               SELECT METER_USAGE_DESC,                                 
                      USAGE_TYPE_DESC                                   
                 INTO :WS-METER-USAGE-DESC,                             
                      :WS-USAGE-TYPE-DESC                               
                 FROM CSS_MTR_USAGE_VALS                                
                WHERE CODE_USAGE_ID     = :WS-USAGE-ID                  
                  AND CODE_USAGE_TYPE   = :WS-USAGE-TYPE                
                  AND CODE_USAGE_SOURCE = :WS-USAGE-SOURCE              
                                                                        
      *                                                                 21560000
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00714     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_USAGE_VALS'       TO TABLE-1                
              MOVE 'CODE_USAGE_ID'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_USAGE_TYPE'         TO TABLE-ELEMENT-2         
              MOVE 'CODE_USAGE_SOURCE'       TO TABLE-ELEMENT-3         
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE WS-USAGE-ID               TO HOSTVAR-ELEMENT-1       
              MOVE WS-USAGE-TYPE             TO HOSTVAR-ELEMENT-2       
              MOVE WS-USAGE-SOURCE           TO HOSTVAR-ELEMENT-3       
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 21730000
      *                                                                 21740000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21770000
      *                                                                 21780000
      ******************************************************************21790000
      * 7600 GET READ CYCLE                                            *21800000
      *      -- THIS MODULE OBTAINS THE READ CYCLE                     *21810000
      ******************************************************************21820000
       7600-GET-READ-CYCLE.                                             
      *                                                                 21840000
           EXEC SQL                                                     
               SELECT READ_CYCLE                                        
C27236               ,RATE_PLAN_NO                                      
                 INTO :WS-READ-CYCLE                                    
C27236               ,:UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-COMP              
                  AND IC_NO          = :MN-IC-NO                        
                  AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21930000
      *                                                                 21940000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7600'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
               MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'IC_NO'              TO TABLE-ELEMENT-2             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
               MOVE WS-ACCOUNT-NO-COMP   TO HOSTVAR-ELEMENT-1           
               MOVE MN-IC-NO             TO HOSTVAR-ELEMENT-2           
               MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 22110000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22140000
C27236******************************************************************21790000
C27236* 7700 CHECK-INDUS-GAS-CUST                                      *21800000
C27236*      -- THIS MODULE CHECKS THE ACCOUNTS FOR INDUS GAS CUSTOMERS*21810000
C27236******************************************************************21820000
C27236 7700-CHECK-INDUS-GAS-CUST.                                       
C27236*                                                                 21840000
C27236     EXEC SQL                                                     
C27236          SELECT  'Y'                                             
C27236            INTO :WS-INDUS-GAS-CUSTOMER                           
C27236            FROM CSS_RATE_COMP_DEF J1                             
C27236           WHERE J1.RATE_PLAN_NO  = :UT-RATE-PLAN-NO              
C27236             AND J1.REG_TYPE_CD = 'D'                             
C27236             AND J1.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE           
C27236             AND J1.VERSION_NO_CNTRL IN                           
C27236                 (SELECT MAX(A1.VERSION_NO_CNTRL)                 
C27236                    FROM CSS_RATE_COMP_DEF A1                     
C27236                   WHERE A1.RATE_PLAN_NO  = :UT-RATE-PLAN-NO      
C27236                     AND A1.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)  
C27236     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27236*                                                                 21930000
C27236     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C27236                                                                  
C27236     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C27236        OR -811                                                   
C27236         NEXT SENTENCE                                            
C27236     ELSE                                                         
C27236         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C27236         MOVE '7700'               TO ACTIVE-PARAGRAPH            
C27236         MOVE 'SELECT'             TO ABEND-FUNCTION              
C27236         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C27236                                      ABEND-TABLES                
C27236         MOVE 'CSS_RATE_COMP_DEF'  TO TABLE-1                     
C27236         MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-1             
C27236         MOVE UT-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-1           
C27236         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C27236         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C27236     END-IF.                                                      
C27236*                                                                 22110000
C27236 7700-EXIT.                                                       
C27236     EXIT.                                                        
      *                                                                         
C28373******************************************************************21790000
C28373* 7720-CHECK-AMR-MODULE                                          *21800000
C28373*      -- THIS MODULE CHECKS WHETHER METER HAS AN AMR MODULE     *21810000
C28373******************************************************************21820000
C28373 7720-CHECK-AMR-MODULE.                                           
C28373*                                                                 21840000
C28373     EXEC SQL                                                     
C28373          SELECT  'Y'                                             
C28373            INTO :WS-AMR-MODULE-EXISTS                            
C28373            FROM CSS_METER_ATTCHMTS                               
C28373           WHERE COMPANY_NO     = :MA-COMPANY-NO                  
C28373             AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE              
C28373             AND METER_NO       = :MA-METER-NO                    
C28373             AND CODE_ATT_TYPE  = 'IT'                            
C28373     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28373*                                                                 21930000
C28373     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28373                                                                  
C28373     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C28373                 OR -811                                          
C28373         NEXT SENTENCE                                            
C28373     ELSE                                                         
C28373         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C28373         MOVE '7720'               TO ACTIVE-PARAGRAPH            
C28373         MOVE 'SELECT'             TO ABEND-FUNCTION              
C28373         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C28373                                      ABEND-TABLES                
C28373         MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                     
C28373         MOVE 'MA-METER-NO'        TO TABLE-ELEMENT-1             
C28373         MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1           
C28373         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C28373         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C28373     END-IF.                                                      
C28373*                                                                 22110000
C28373 7720-EXIT.                                                       
C28373     EXIT.                                                        
      *                                                                         
C33887******************************************************************21790000
C33887* 7800-GET-ELEC-METER-SIZE                                       *21800000
C33887******************************************************************21820000
C33887 7800-GET-ELEC-METER-SIZE.                                        
C33887                                                                  
C33887       EXEC SQL                                                   
C33887           SELECT METER_SIZE_DESC                                 
C33887            INTO :WS-METER-SIZE-DESC                              
C33887            FROM CSS_ELEC_MTR_SIZE                                
C33887            WHERE METER_SIZE_ID  = :WS-E-METER-SIZE-ID            
C33887       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887                                                                  
C33887       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
A00714       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
C33887          NEXT SENTENCE                                           
C33887       ELSE                                                       
C33887           MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
C33887           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
C33887           MOVE '7800'                  TO ACTIVE-PARAGRAPH       
C33887           MOVE 'SELECT'                TO ABEND-FUNCTION         
C33887           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
C33887                                             ABEND-TABLES         
C33887           MOVE 'CSS_ELEC_MTR_SIZE'     TO TABLE-1                
C33887           MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1        
C33887           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2        
C33887           MOVE WS-E-METER-SIZE-ID        TO HOSTVAR-ELEMENT-1    
C33887           MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
C33887           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C33887           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C33887       END-IF.                                                    
C33887*                                                                         
C33887 7800-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
      *                                                                         
C33887******************************************************************21790000
C33887* 7810-GET-GAS-METER-SIZE.                                       *21800000
C33887******************************************************************21820000
C33887 7810-GET-GAS-METER-SIZE.                                         
C33887                                                                  
C33887       EXEC SQL                                                   
C33887           SELECT METER_SIZE_DESC                                 
C34590                 ,CCF_CAP_PER_HR                                  
C33887            INTO :WS-METER-SIZE-DESC                              
                      ,:WS-CCF-CAP-PER-HR                               
C33887            FROM CSS_GAS_METER_SIZE                               
C33887            WHERE METER_SIZE_ID  = :WS-G-METER-SIZE-ID            
C33887       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887                                                                  
C33887       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
A00714       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
C33887          NEXT SENTENCE                                           
C33887       ELSE                                                       
C33887           MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
C33887           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
C33887           MOVE '7810'                  TO ACTIVE-PARAGRAPH       
C33887           MOVE 'SELECT'                TO ABEND-FUNCTION         
C33887           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
C33887                                             ABEND-TABLES         
C33887           MOVE 'CSS_GAS_METER_SIZE'    TO TABLE-1                
C33887           MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1        
C33887           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2        
C33887           MOVE WS-G-METER-SIZE-ID      TO HOSTVAR-ELEMENT-1      
C33887           MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
C33887           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C33887           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C33887       END-IF.                                                    
C33887*                                                                         
C33887 7810-EXIT.                                                       
C33887     EXIT.                                                        
C33887******************************************************************21790000
C33887* 7900-GET-ELEC-MECHDIAL-FL                                      *21800000
C33887******************************************************************21820000
C33887 7900-GET-ELEC-MECHDIAL-FL.                                       
C33887                                                                  
C33887       EXEC SQL                                                   
C33887           SELECT MECHANICAL_DIAL_FL                              
C33887            INTO :WS-MECHANICAL-DIAL-FL                           
C33887            FROM CSS_METER_PGM                                    
C33887            WHERE DIGTL_MTR_TYPE = :WS-E-DIGTL-MTR-TYPE           
C33887              AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
C33887              AND PROGRAM_ID     = :WS-E-PROGRAM-ID               
C33887       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887                                                                  
C33887       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
A00714       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
C33887          NEXT SENTENCE                                           
C33887       ELSE                                                       
C33887           MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
C33887           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
C33887           MOVE '7900'                  TO ACTIVE-PARAGRAPH       
C33887           MOVE 'SELECT'                TO ABEND-FUNCTION         
C33887           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
C33887                                             ABEND-TABLES         
C33887           MOVE 'CSS_METER_PGM'         TO TABLE-1                
C33887           MOVE 'DIGTL_MTR_TYPE '       TO TABLE-ELEMENT-1        
C33887           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2        
C33887           MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-3        
C33887           MOVE WS-E-DIGTL-MTR-TYPE     TO HOSTVAR-ELEMENT-1      
C33887           MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
C33887           MOVE WS-E-PROGRAM-ID         TO HOSTVAR-ELEMENT-3      
C33887           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C33887           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C33887       END-IF.                                                    
C33887*                                                                         
C33887 7900-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
C33887******************************************************************21790000
C33887* 7910-GET-GAS-MECHDIAL-FL                                       *21800000
C33887******************************************************************21820000
C33887 7910-GET-GAS-MECHDIAL-FL.                                        
C33887                                                                  
C33887       EXEC SQL                                                   
C33887           SELECT MECHANICAL_DIAL_FL                              
C33887            INTO :WS-MECHANICAL-DIAL-FL                           
C33887            FROM CSS_METER_PGM                                    
C33887            WHERE DIGTL_MTR_TYPE = :WS-G-DIGTL-MTR-TYPE           
C33887              AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
C33887              AND PROGRAM_ID     = :WS-G-PROGRAM-ID               
C33887       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33887                                                                  
C33887       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
A00714       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
C33887          NEXT SENTENCE                                           
C33887       ELSE                                                       
C33887           MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
C33887           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
C33887           MOVE '7910'                  TO ACTIVE-PARAGRAPH       
C33887           MOVE 'SELECT'                TO ABEND-FUNCTION         
C33887           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
C33887                                             ABEND-TABLES         
C33887           MOVE 'CSS_METER_PGM'         TO TABLE-1                
C33887           MOVE 'DIGTL_MTR_TYPE '       TO TABLE-ELEMENT-1        
C33887           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2        
C33887           MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-3        
C33887           MOVE WS-G-DIGTL-MTR-TYPE     TO HOSTVAR-ELEMENT-1      
C33887           MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
C33887           MOVE WS-G-PROGRAM-ID         TO HOSTVAR-ELEMENT-3      
C33887           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C33887           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C33887       END-IF.                                                    
C33887*                                                                         
C33887 7910-EXIT.                                                       
C33887     EXIT.                                                        
      *                                                                         
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02076_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02076_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02076_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         INSERT INTO #CSR02076_R1                          
REARCH         (                                                        
REARCH             LAST_UPDATE_TS                                       
REARCH            ,METER_NO                                             
REARCH            ,MTR_REF_NO                                           
REARCH            ,DATE_MTR_INSTALL                                     
REARCH            ,POINT_ID                                             
REARCH            ,DIGTL_MTR_TYPE                                       
REARCH            ,METER_SUPPLYING                                      
REARCH            ,CODE_METER_LOC                                       
REARCH            ,DATE_LAST_TESTED                                     
REARCH            ,NO_CONSEC_ESTIMATE                                   
REARCH            ,NO_CONSEC_CRD_READ                                   
REARCH            ,MTR_READ_SOURCE_CD                                   
REARCH            ,OPTIMUM_READ_DATE                                    
REARCH            ,HEXAGRAM_LOCATION                                    
REARCH            ,MONTHS_INACTIVE                                      
REARCH            ,SEAL_CODE_ID                                         
REARCH            ,INSULATED_IND                                        
REARCH            ,LOCK_TYPE_ID                                         
REARCH            ,IDR_RECIPIENT_CD                                     
REARCH            ,DELIVERY_LEVEL_CD                                    
REARCH            ,UTILITY_SOURCE_CD                                    
REARCH            ,REMOTE_READ_IND                                      
REARCH            ,PROGRAM_ID                                           
REARCH            ,INDUST_BTU_ID                                        
REARCH            ,MAX_NO_UNITS                                         
REARCH            ,MIN_NO_UNITS                                         
REARCH            ,INDUS_GAS_CUST                                       
REARCH            ,GIS_POINT_ID                                         
REARCH            ,REG_ID_NO                                            
REARCH            ,CODE_TIME_PERIOD                                     
REARCH            ,CONSTANT                                             
REARCH            ,NO_READ_DIALS                                        
REARCH            ,CODE_REG_STATUS                                      
REARCH            ,CODE_STATUS_REAS                                     
REARCH            ,METER_USAGE_DESC                                     
REARCH            ,CODE_USAGE_TYPE                                      
REARCH            ,LAST_READ_VALUE                                      
REARCH            ,LAST_REG_READ_DT                                     
REARCH            ,LAST_REG_READ_TM                                     
REARCH            ,CODE_LAST_REG_READ                                   
REARCH            ,LAST_VAL_RD_VALUE                                    
REARCH            ,LAST_VALID_READ_DT                                   
REARCH            ,LAST_VALID_READ_TM                                   
REARCH            ,CD_LAST_VALID_READ                                   
REARCH            ,CODE_CRNT_REG_READ                                   
REARCH            ,CODE_NO_RD_REASON                                    
REARCH            ,RETURN_CODE                                          
REARCH            ,CODE_MTR_RD_INST1                                    
REARCH            ,CODE_MTR_RD_INST2                                    
REARCH            ,CODE_MTR_RD_INST3                                    
REARCH            ,REGISTER_RD_SEQ                                      
REARCH            ,AMR_CAP_FL                                           
REARCH            ,METER_PRESSURE                                       
C33887            ,METER_SIZE_DESC                                      
C33887            ,MECHANICAL_DIAL_FL                                   
C33887            ,DEVICE_NO                                            
C33887            ,CODE_ATT_TYPE                                        
C33887            ,CODE_SHORT_DESC                                      
C33887            ,MTR_ATT_TYPE_TX                                      
C34590            ,ELEC_MTR_FORM_CD                                     
C34590            ,MTR_CONNECT_TYP_ID                                   
C34590            ,NO_PHASES                                            
C34590            ,CCF_CAP_PER_HR                                       
P00545            ,GIS_MISMATCH_FL                                      
REARCH         )                                                        
REARCH         VALUES                                                   
REARCH         (                                                        
REARCH             :S-LAST-UPDATE-TS                                    
REARCH            ,:S-METER-NO                                          
REARCH            ,:S-MTR-REF-NO                                        
REARCH            ,:S-DATE-MTR-INSTALL                                  
REARCH            ,:S-POINT-ID                                          
REARCH            ,:S-DIGTL-MTR-TYPE                                    
REARCH            ,:S-METER-SUPPLYING                                   
REARCH            ,:S-CODE-METER-LOC                                    
REARCH            ,:S-DATE-LAST-TESTED                                  
REARCH            ,:S-NO-CONSEC-ESTIMATE                                
REARCH            ,:S-NO-CONSEC-CRD-READ                                
REARCH            ,:S-MTR-READ-SOURCE-CD                                
REARCH            ,:S-OPTIMUM-READ-DATE                                 
REARCH            ,:S-HEXAGRAM-LOCATION                                 
REARCH            ,:S-MONTHS-INACTIVE                                   
REARCH            ,:S-SEAL-CODE-ID                                      
REARCH            ,:S-INSULATED-IND                                     
REARCH            ,:S-LOCK-TYPE-ID                                      
REARCH            ,:S-IDR-RECIPIENT-CD                                  
REARCH            ,:S-DELIVERY-LEVEL-CD                                 
REARCH            ,:S-UTILITY-SOURCE-CD                                 
REARCH            ,:S-REMOTE-READ-IND                                   
REARCH            ,:S-PROGRAM-ID                                        
REARCH            ,:S-INDUST-BTU-ID                                     
REARCH            ,:S-MAX-NO-UNITS                                      
REARCH            ,:S-MIN-NO-UNITS                                      
REARCH            ,:S-INDUS-GAS-CUST                                    
REARCH            ,:S-GIS-POINT-ID                                      
REARCH            ,:S-REG-ID-NO                                         
REARCH            ,:S-CODE-TIME-PERIOD                                  
REARCH            ,:S-CONSTANT                                          
REARCH            ,:S-NO-READ-DIALS                                     
REARCH            ,:S-CODE-REG-STATUS                                   
REARCH            ,:S-CODE-STATUS-REAS                                  
REARCH            ,:S-METER-USAGE-DESC                                  
REARCH            ,:S-CODE-USAGE-TYPE                                   
REARCH            ,:S-LAST-READ-VALUE                                   
REARCH            ,:S-LAST-REG-READ-DT                                  
REARCH            ,:S-LAST-REG-READ-TM                                  
REARCH            ,:S-CODE-LAST-REG-READ                                
REARCH            ,:S-LAST-VAL-RD-VALUE                                 
REARCH            ,:S-LAST-VALID-READ-DT                                
REARCH            ,:S-LAST-VALID-READ-TM                                
REARCH            ,:S-CODE-LAST-VALID-RD                                
REARCH            ,:S-CODE-CRNT-REG-READ                                
REARCH            ,:S-CODE-NO-RD-REASON                                 
REARCH            ,:S-RETURN-CODE                                       
REARCH            ,:S-CODE-MTR-RD-INST1                                 
REARCH            ,:S-CODE-MTR-RD-INST2                                 
REARCH            ,:S-CODE-MTR-RD-INST3                                 
REARCH            ,:S-REGISTER-RD-SEQ                                   
REARCH            ,:S-AMR-CAP-FL                                        
REARCH            ,:S-METER-PRESSURE                                    
C33887            ,:S-METER-SIZE-DESC                                   
C33887            ,:S-MECHANICAL-DIAL-FL                                
C33887            ,:S-DEVICE-NO                                         
C33887            ,:S-CODE-ATT-TYPE                                     
C33887            ,:S-CODE-SHORT-DESC                                   
C33887            ,:S-MTR-ATT-TYPE-TX                                   
C34590            ,:S-ELEC-MTR-FORM-CD                                  
C34590            ,:S-MTR-CONNECT-TYP-ID                                
C34590            ,:S-NO-PHASES                                         
C34590            ,:S-CCF-CAP-PER-HR                                    
P00545            ,:S-GIS-MISMATCH-FL                                   
REARCH         )                                                        
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02076_R1                                  
MFA-TR*        (                                                                
MFA-TR*            LAST_UPDATE_TS                                               
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,MTR_REF_NO                                                   
MFA-TR*           ,DATE_MTR_INSTALL                                             
MFA-TR*           ,POINT_ID                                                     
MFA-TR*           ,DIGTL_MTR_TYPE                                               
MFA-TR*           ,METER_SUPPLYING                                              
MFA-TR*           ,CODE_METER_LOC                                               
MFA-TR*           ,DATE_LAST_TESTED                                             
MFA-TR*           ,NO_CONSEC_ESTIMATE                                           
MFA-TR*           ,NO_CONSEC_CRD_READ                                           
MFA-TR*           ,MTR_READ_SOURCE_CD                                           
MFA-TR*           ,OPTIMUM_READ_DATE                                            
MFA-TR*           ,HEXAGRAM_LOCATION                                            
MFA-TR*           ,MONTHS_INACTIVE                                              
MFA-TR*           ,SEAL_CODE_ID                                                 
MFA-TR*           ,INSULATED_IND                                                
MFA-TR*           ,LOCK_TYPE_ID                                                 
MFA-TR*           ,IDR_RECIPIENT_CD                                             
MFA-TR*           ,DELIVERY_LEVEL_CD                                            
MFA-TR*           ,UTILITY_SOURCE_CD                                            
MFA-TR*           ,REMOTE_READ_IND                                              
MFA-TR*           ,PROGRAM_ID                                                   
MFA-TR*           ,INDUST_BTU_ID                                                
MFA-TR*           ,MAX_NO_UNITS                                                 
MFA-TR*           ,MIN_NO_UNITS                                                 
MFA-TR*           ,INDUS_GAS_CUST                                               
MFA-TR*           ,GIS_POINT_ID                                                 
MFA-TR*           ,REG_ID_NO                                                    
MFA-TR*           ,CODE_TIME_PERIOD                                             
MFA-TR*           ,CONSTANT                                                     
MFA-TR*           ,NO_READ_DIALS                                                
MFA-TR*           ,CODE_REG_STATUS                                              
MFA-TR*           ,CODE_STATUS_REAS                                             
MFA-TR*           ,METER_USAGE_DESC                                             
MFA-TR*           ,CODE_USAGE_TYPE                                              
MFA-TR*           ,LAST_READ_VALUE                                              
MFA-TR*           ,LAST_REG_READ_DT                                             
MFA-TR*           ,LAST_REG_READ_TM                                             
MFA-TR*           ,CODE_LAST_REG_READ                                           
MFA-TR*           ,LAST_VAL_RD_VALUE                                            
MFA-TR*           ,LAST_VALID_READ_DT                                           
MFA-TR*           ,LAST_VALID_READ_TM                                           
MFA-TR*           ,CD_LAST_VALID_READ                                           
MFA-TR*           ,CODE_CRNT_REG_READ                                           
MFA-TR*           ,CODE_NO_RD_REASON                                            
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*           ,CODE_MTR_RD_INST1                                            
MFA-TR*           ,CODE_MTR_RD_INST2                                            
MFA-TR*           ,CODE_MTR_RD_INST3                                            
MFA-TR*           ,REGISTER_RD_SEQ                                              
MFA-TR*           ,AMR_CAP_FL                                                   
MFA-TR*           ,METER_PRESSURE                                               
MFA-TR*           ,METER_SIZE_DESC                                              
MFA-TR*           ,MECHANICAL_DIAL_FL                                           
MFA-TR*           ,DEVICE_NO                                                    
MFA-TR*           ,CODE_ATT_TYPE                                                
MFA-TR*           ,CODE_SHORT_DESC                                              
MFA-TR*           ,MTR_ATT_TYPE_TX                                              
MFA-TR*           ,ELEC_MTR_FORM_CD                                             
MFA-TR*           ,MTR_CONNECT_TYP_ID                                           
MFA-TR*           ,NO_PHASES                                                    
MFA-TR*           ,CCF_CAP_PER_HR                                               
MFA-TR*           ,GIS_MISMATCH_FL                                              
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*            :S-LAST-UPDATE-TS                                            
MFA-TR*           ,:S-METER-NO                                                  
MFA-TR*           ,:S-MTR-REF-NO                                                
MFA-TR*           ,:S-DATE-MTR-INSTALL                                          
MFA-TR*           ,:S-POINT-ID                                                  
MFA-TR*           ,:S-DIGTL-MTR-TYPE                                            
MFA-TR*           ,:S-METER-SUPPLYING                                           
MFA-TR*           ,:S-CODE-METER-LOC                                            
MFA-TR*           ,:S-DATE-LAST-TESTED                                          
MFA-TR*           ,:S-NO-CONSEC-ESTIMATE                                        
MFA-TR*           ,:S-NO-CONSEC-CRD-READ                                        
MFA-TR*           ,:S-MTR-READ-SOURCE-CD                                        
MFA-TR*           ,:S-OPTIMUM-READ-DATE                                         
MFA-TR*           ,:S-HEXAGRAM-LOCATION                                         
MFA-TR*           ,:S-MONTHS-INACTIVE                                           
MFA-TR*           ,:S-SEAL-CODE-ID                                              
MFA-TR*           ,:S-INSULATED-IND                                             
MFA-TR*           ,:S-LOCK-TYPE-ID                                              
MFA-TR*           ,:S-IDR-RECIPIENT-CD                                          
MFA-TR*           ,:S-DELIVERY-LEVEL-CD                                         
MFA-TR*           ,:S-UTILITY-SOURCE-CD                                         
MFA-TR*           ,:S-REMOTE-READ-IND                                           
MFA-TR*           ,:S-PROGRAM-ID                                                
MFA-TR*           ,:S-INDUST-BTU-ID                                             
MFA-TR*           ,:S-MAX-NO-UNITS                                              
MFA-TR*           ,:S-MIN-NO-UNITS                                              
MFA-TR*           ,:S-INDUS-GAS-CUST                                            
MFA-TR*           ,:S-GIS-POINT-ID                                              
MFA-TR*           ,:S-REG-ID-NO                                                 
MFA-TR*           ,:S-CODE-TIME-PERIOD                                          
MFA-TR*           ,:S-CONSTANT                                                  
MFA-TR*           ,:S-NO-READ-DIALS                                             
MFA-TR*           ,:S-CODE-REG-STATUS                                           
MFA-TR*           ,:S-CODE-STATUS-REAS                                          
MFA-TR*           ,:S-METER-USAGE-DESC                                          
MFA-TR*           ,:S-CODE-USAGE-TYPE                                           
MFA-TR*           ,:S-LAST-READ-VALUE                                           
MFA-TR*           ,:S-LAST-REG-READ-DT                                          
MFA-TR*           ,:S-LAST-REG-READ-TM                                          
MFA-TR*           ,:S-CODE-LAST-REG-READ                                        
MFA-TR*           ,:S-LAST-VAL-RD-VALUE                                         
MFA-TR*           ,:S-LAST-VALID-READ-DT                                        
MFA-TR*           ,:S-LAST-VALID-READ-TM                                        
MFA-TR*           ,:S-CODE-LAST-VALID-RD                                        
MFA-TR*           ,:S-CODE-CRNT-REG-READ                                        
MFA-TR*           ,:S-CODE-NO-RD-REASON                                         
MFA-TR*           ,:S-RETURN-CODE                                               
MFA-TR*           ,:S-CODE-MTR-RD-INST1                                         
MFA-TR*           ,:S-CODE-MTR-RD-INST2                                         
MFA-TR*           ,:S-CODE-MTR-RD-INST3                                         
MFA-TR*           ,:S-REGISTER-RD-SEQ                                           
MFA-TR*           ,:S-AMR-CAP-FL                                                
MFA-TR*           ,:S-METER-PRESSURE                                            
MFA-TR*           ,:S-METER-SIZE-DESC                                           
MFA-TR*           ,:S-MECHANICAL-DIAL-FL                                        
MFA-TR*           ,:S-DEVICE-NO                                                 
MFA-TR*           ,:S-CODE-ATT-TYPE                                             
MFA-TR*           ,:S-CODE-SHORT-DESC                                           
MFA-TR*           ,:S-MTR-ATT-TYPE-TX                                           
MFA-TR*           ,:S-ELEC-MTR-FORM-CD                                          
MFA-TR*           ,:S-MTR-CONNECT-TYP-ID                                        
MFA-TR*           ,:S-NO-PHASES                                                 
MFA-TR*           ,:S-CCF-CAP-PER-HR                                            
MFA-TR*           ,:S-GIS-MISMATCH-FL                                           
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02076_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH      EXIT.                                                       
T28824***************************************************************** 22150000
T28824* COPYBOOK FOR CALCLATE NEXT READ DATE                                    
T28824***************************************************************** 22150000
T28824                                                                  
T28824     EXEC SQL                                                             
T28824        INCLUDE CPD00310                                                  
T28824     END-EXEC.                                                            
T28824                                                                  
T28824******************************************************************22160000
      * 8650-ADD-ONE-DAY.                                               22170000
      ******************************************************************22180000
       8650-ADD-ONE-DAY.                                                
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) ) )
            INTO
              :WS-DATE-READ    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-READ = DATE(DATE(:WS-DATE-READ) + 1 DAY)            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8650-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28824******************************************************************        
T28824* INCLUDE CPD0023C                                               *        
T28824******************************************************************        
T28824     EXEC SQL                                                             
T28824        INCLUDE CPD0023C                                                  
T28824     END-EXEC.                                                            
T28824                                                                  
      ******************************************************************22160000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *22170000
      ******************************************************************22180000
REARCH*    EXEC SQL                                                     22190000
REARCH*       INCLUDE CPD00300                                          22200000
REARCH*    END-EXEC.                                                    22210000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************22220000
      * 9999- END PROGRAM COPYLIB                                      *22230000
      ******************************************************************22240000
REARCH*    COPY CPD00302.                                               22250000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
