       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02075.                                         
COB303 DATE-WRITTEN.  APRIL 18, 1995.                                   
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00050001
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00050002
CVT000*         S075 CONVERTED TO DB2 SP CSR02075 ON 06/13/2006        *00050003
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00050004
CVT000*                                                                *00050005
CVT000*                    CVT000 - CONVERTED CODE                     *00050006
CVT000*                    CVT004 - NEEDED REVIEW                      *00050007
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00050008
CVT000*                             POTENTIALLY BE DELETED             *00050009
CVT000*                                                                *00050010
CVT000******************************************************************00050020
      ***************************************************************** 00060000
      *                                                               * 00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00080000
      *                                                               * 00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).  * 00100000
      *                                                               * 00110000
      *  TRANID:        S075                                          * 00120000
      *  PROGRAM:       S075                                          * 00130000
      *  CALLING SP:    PA_S075                                       * 00140000
      *                                                               * 00150000
      ***************************************************************** 00160000
      *                P R O G R A M  S U M M A R Y                   * 00170000
      *                                                               * 00180000
      *  S075 RETRIEVES PREMISE AND FORMATTED ADDRESS INFORMATION     * 00190000
      *  FROM CSS_PREMISE CSS_ADDR_FORMATTED TABLES.                  * 00191000
      *  RETRIEVES SERVICE INFORMATION AT PREMISE AND SUBDIVISION     * 00192000
      *  LIGHTING INFORMATION.                                        * 00193000
      *                                                               * 00200000
      ***************************************************************** 00230000
      *                                                               * 00240000
      *                     PROGRAM MODIFICATION LOG                  * 00250000
      *                                                               * 00260000
      *    DATE    INITIALS   COMMENTS                                * 00270000
      *  --------  --------   --------------------------------------- * 00280000
      *  04/18/95    MJL      REMOTE PROCEDURE ORIGINALLY CODED.      * 00290000
      *  08/02/95    TCB      INCREASED THE SIZE OF                   * 00291000
      *                       RS-STREET-LOCATION-2 FROM X(4) TO X(6). * 00292000
      *  01/29/96    MJL      TPR 2665 ADD COMPANY-NO TO RETRIEVE.    * 00293000
      *  02/01/96    MJL      TPR 2888 COMBINE ALL RPC'S ON PANEL077  * 00294000
      *                       INTO 1.                                 * 00295000
      *  11/12/96    SG       TPR 5843 CHANGE ACCOUNT_TYPE_DESC TO    * 00296000
      *                       ONLY RETURN CODE. USE EDIT STYLE.       * 00297000
TP8615*  11/06/97    BAB      THE READ CYCLE NEEDS TO BE RETRIEVED.   * 00298000
T14391*  01/15/98    GAC      MOVE 0 TO PR-ADDRESS-ID IF NOT-FOUND    * 00299000
T14391*                       RESULT IN 7000 TO PREVENT SOC-7.        * 00299100
T14475*  02/19/98    FB       7410- ROUTINE INCREMENTS WS-MN-COUNT,   * 00299200
T14475*                       CAUSING THE METER-IND TO BE SET TO      * 00299300
T14475*                       'YES' REGARDLESS OF MN.  CHANGED TO     * 00299400
T14475*                       INCREMENT ONLY FOR A SUCCESSFUL CALL.   * 00299500
T14863*  03/02/98    FB       GET INSTALL DATE                        * 00299600
T14863*  03/25/98    FB       CLEAN UP ABEND ROUTINE DISPLAYS.        * 00299701
      *                                                               * 00300000
CBSI  *  07/31/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE   * 00300100
CBSI  *             MADRAS    ABEND PARAMETERS                        * 00300101
T21118*  12/30/99    FB       SET PARM ACCOUNT TO ZERO IF NOT         * 00300102
T21118*                       NUMERIC.                                * 00300103
T31591*  11/24/04    FB       RETURN LAST BILL DATE.                  * 00300104
T22254*  03/10/05    FB       LEAK SURVEY DATE IN USA FORMAT.         * 00300105
C33254*  11/07/05    AW       INSTALL DATE SHOULD BE LAST BILL DATE   * 00300106
C33254*                       WHEN CERTAIN CRITERIA ARE MET AND       * 00300107
C33254*                       LAST BILL DATE SHOULD BE RETURNED TO    * 00300108
C33254*                       PANEL 077 INSTEAD OF DATE PLAN START    * 00300109
C33254*  12/13/05    AW       ADDED RS-LIGHT-NOT-BILLED AND RS-MSG-   * 00300110
C33254*                       DISPLAY-DT TO RESULT SET                * 00300120
REARCH*   06/29/06   CVNS     RPC TO DB2 SP CONVERSION                * 00300130
REARCH*              CHENNAI                                          * 00300140
T35434*  10/07/07    PA97450  REPLACED CSS_MODEL_SQL WITH SET STMTS   * 00300150
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR    * 00300160
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGELTON* 00300170
T35434*                       SELECTS.                                * 00300180
C35979*  04/03/07    MA       ADD CROSS-STREET-1 AND 2 FOR SELECT     * 00300190
CML376*  17/10/08    CVNS     ADDRESS FORMAT CHANGES                  * 00300191
      *              SJ97149                                          * 00300192
A37342*  21/05/09    MC95456  ADDED ROWSET POSITIONING TO CURSOR      *         
A37342*                       CML 37342 TO  IMPROVE PERFORMANCE       *         
      ***************************************************************** 00300200
      ***************************************************************** 00320000
      *                                                               * 00330000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00340000
      *                                                               * 00350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00380000
      *  3000 - 4999  NOT USED                                        * 00390000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00400000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00410000
      *  7000 - 7999  INPUT MODULES                                   * 00420000
      *  8000 - 8999  OUTPUT MODULES                                  * 00430000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES           * 00440000
      *                                                               * 00450000
      ***************************************************************** 00460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02075'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
REARCH     'WORKING STORAGE FOR CSR02075 STARTS HERE'.                  
                                                                        
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
      *--< CSS_ACCOUNT >                                                00580000
           EXEC SQL                                                     00581000
              INCLUDE TBACCT                                            00582000
           END-EXEC.                                                    00583000
                                                                        
      *--< CSS_PREMISE >                                                00590000
           EXEC SQL                                                     00670000
              INCLUDE TBPREM                                            00680000
           END-EXEC.                                                    00690000
                                                                        
      *--< CSS_ADDR_FORMATTED >                                         00691200
           EXEC SQL                                                     00691400
              INCLUDE TBADRFMT                                          00691500
           END-EXEC.                                                    00691600
                                                                        
      *--< CSS_UTIL_ENVRNMT >                                           00786000
           EXEC SQL                                                     00790000
              INCLUDE TBUTLENV                                          00800000
           END-EXEC.                                                    00810000
                                                                        
      *--< CSS_MTRD_ENVRNMT >                                           00811200
           EXEC SQL                                                     00811400
              INCLUDE TBMTRENV                                          00811500
           END-EXEC.                                                    00811600
                                                                        
      *--< CSS_UNMETERED_EQUIPMENT >                                    00811900
           EXEC SQL                                                     00812100
              INCLUDE TBUMEQP                                           00812200
           END-EXEC.                                                    00812300
                                                                        
      *--< CSS_UNMTR_PLAN >                                             00812600
           EXEC SQL                                                     00812800
              INCLUDE TBUMPLAN                                          00812900
           END-EXEC.                                                    00813000
                                                                        
      *--< CSS_RATE_CREATOR >                                           00813300
           EXEC SQL                                                     00813500
              INCLUDE TBRTCRTR                                          00813600
           END-EXEC.                                                    00813700
                                                                        
      *--< CSS_CUST_PLAN >                                              00814000
           EXEC SQL                                                     00814200
              INCLUDE TBCSTPLN                                          00814300
           END-EXEC.                                                    00814400
                                                                        
                                                                        
C31591*--< CSS_BILLING_HDR >                                            00815201
C31591     EXEC SQL                                                     00815202
C31591        INCLUDE TBBLLHDR                                          00815203
C31591     END-EXEC.                                                    00815204
                                                                        
C33254*--< CSS_CUST_PREM_HIS >                                          00815206
C33254     EXEC SQL                                                     00815207
C33254        INCLUDE  TBCSTPRM                                         00815208
C33254     END-EXEC.                                                    00815209
                                                                        
      *--< INCLUDE SQLCA >                                              00815400
           EXEC SQL                                                     00815600
              INCLUDE SQLCA                                             00815700
           END-EXEC.                                                    00816000
                                                                        
      ******************************************************************00830000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00840000
      ******************************************************************00850000
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >      00861000
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >      00862000
CVT999*    COPY SYGWCOB.                                                00870000
      *--------< ADDED TO SUPPORT CICS RPCS >                           00871000
CVT999*    COPY SYDBCOB.                                                00880000
      *--------<COMMON SYSTEM AREA >                                    00881000
           COPY CCA00001.                                               00890000
      *--------< ERROR HANDLING >                                       00891000
CVT999*    COPY CWS00010.                                               00900000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00901000
           COPY CWS00303.                                               00910000
                                                                        
      ******************************************************************00940000
      *    WORK AREAS                                                  *00950000
      ******************************************************************00960000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02075_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP VALUE 0.         
REARCH         49 GTT-ROW-CHAR         PIC X(1024) VALUE SPACES.        
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH 01  PARM-FIELDS.                                                 
REARCH     05  PARM-PREMISE-NO         PIC X(10) VALUE SPACES.          
REARCH     05  PARM-PREMISE-NO-RED     REDEFINES PARM-PREMISE-NO        
REARCH                                 PIC 9(10).                       
REARCH     05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
REARCH                                 PIC S9(13).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(09) COMP VALUE 0.         
           05  WS-ROW-COUNT            PIC S9(09) COMP VALUE 0.         
           05  WS-MN-COUNT             PIC S9(04) COMP VALUE 0.         
           05  WS-UT-COUNT             PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(03) VALUE 'YES'.           
           05  WS-NO                   PIC X(03) VALUE 'NO'.            
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-W                    PIC X(01) VALUE 'W'.             
           05  WS-S                    PIC X(01) VALUE 'S'.             
           05  WS-U                    PIC X(01) VALUE 'U'.             
           05  WS-A                    PIC X(01) VALUE 'A'.             
           05  WS-ELECTRIC             PIC X(15) VALUE 'ELECTRIC'.      
           05  WS-GAS                  PIC X(15) VALUE 'GAS'.           
           05  WS-WATER                PIC X(15) VALUE 'WATER'.         
           05  WS-SEWAGE               PIC X(15) VALUE 'SEWAGE'.        
           05  WS-UNKNOWN              PIC X(15) VALUE 'UNKNOWN'.       
           05  WS-RATE-64              PIC X(03) VALUE '064'.           
           05  WS-CODE-STATUS          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE ZERO.       
           05  RS-DATAWINDOW-ID        PIC X(01) VALUE  SPACES.         
           05  RS-ADDRESS-ID           PIC X(13) VALUE  ZEROES.         
           05  RS-LOCAL-OFFICE         PIC X(03) VALUE  SPACES.         
           05  RS-COMPANY-NO           PIC X(02) VALUE  SPACES.         
           05  RS-BLOCK                PIC X(05) VALUE  SPACES.         
           05  RS-LOT                  PIC X(05) VALUE  SPACES.         
           05  RS-PREMISE-DESC         PIC X(15) VALUE  SPACES.         
           05  RS-COMPLEX-TYPE         PIC X(15) VALUE  SPACES.         
           05  RS-COMPLEX-NAME         PIC X(22) VALUE  SPACES.         
           05  RS-COUNTY               PIC X(03) VALUE  SPACES.         
           05  RS-LIGHT-CODE           PIC X(03) VALUE  SPACES.         
           05  RS-LOCATOR-ID           PIC X(09) VALUE  SPACES.         
CML376     05  RS-HOUSE-NO             PIC X(15) VALUE  SPACES.         
           05  RS-ADDR-PREFIX-1        PIC X(03) VALUE  SPACES.         
           05  RS-ADDR-PREFIX-2        PIC X(02) VALUE  SPACES.         
CML376     05  RS-STREET-NAME          PIC X(30) VALUE  SPACES.         
           05  RS-STREET-LOCATION-1    PIC X(04) VALUE  SPACES.         
CML376     05  RS-STREET-LOCATION-2    PIC X(11) VALUE  SPACES.         
           05  RS-STREET-SUFFIX        PIC X(04) VALUE  SPACES.         
           05  RS-ADDR-SUFFIX          PIC X(04) VALUE  SPACES.         
           05  RS-ADDRESS-OVERFLOW     PIC X(35) VALUE  SPACES.         
           05  RS-CARRIER-ROUTE        PIC X(05) VALUE  SPACES.         
           05  RS-ZIP-CODE             PIC X(05) VALUE  SPACES.         
           05  RS-ZIP-CODE-PLUS-FOUR   PIC X(04) VALUE  SPACES.         
           05  RS-ZIP-CODE-TOKEN       PIC X(01) VALUE  SPACES.         
           05  RS-PERSONAL-CNTCT-CD    PIC X(01) VALUE  SPACES.         
           05  RS-REVENUE-PROTECTION   PIC X(02) VALUE  SPACES.         
           05  RS-SUBDIVISION-ID       PIC X(03) VALUE  SPACES.         
           05  RS-CITY-GATE-ID         PIC X(07) VALUE  SPACES.         
           05  RS-GAS-LEAK-SURVEY-DT   PIC X(10) VALUE  SPACES.         
           05  RS-GAS-LK-SURVEY-FREQ   PIC X(02) VALUE  SPACES.         
           05  RS-ADDR-USAGE-CD        PIC X(01) VALUE  SPACES.         
           05  RS-REV-DISTRICT-CD      PIC X(03) VALUE  SPACES.         
TP5843     05  RS-ACCOUNT-TYPE-DESC    PIC X(25) VALUE  SPACES.         
           05  RS-READ-ROUTE           PIC X(04) VALUE  SPACES.         
T98615     05  RS-READ-CYCLE           PIC X(02) VALUE  SPACES.         
T14863     05  RS-INSTALL-DATE         PIC X(10) VALUE  SPACES.         
T31591     05  RS-LAST-BILL-DATE       PIC X(10) VALUE  SPACES.         
           05  RS-RATE-ITEM-CODE       PIC X(04) VALUE  SPACES.         
           05  RS-PRICE-PER-SERV       PIC S9(3)V9(6) COMP-3 VALUE +0.  
           05  RS-B-UTIL-TYPE          PIC X(15) VALUE  SPACES.         
           05  RS-B-READ-ROUTE         PIC S9(4) COMP   VALUE 0.        
           05  RS-B-RATE-PLAN-NO       PIC X(3)  VALUE  SPACES.         
           05  RS-B-METER-IND          PIC X(3)  VALUE  SPACES.         
           05  RS-C-RATE-ITEM-CODE     PIC X(04) VALUE  SPACES.         
           05  RS-C-PRICE-PER-SERV     PIC S9(3)V9(6) COMP-3 VALUE 0.   
           05  RS-C-CUST-PER-SERVICE   PIC X(04) VALUE  SPACES.         
           05  RS-C-EQUIP-SHRT-DESC    PIC X(17) VALUE  SPACES.         
C33254     05  RS-LIGHT-NOT-BILLED     PIC X(01) VALUE  SPACES.         
C33254     05  RS-MSG-DISPLAY-DT       PIC X(10) VALUE  SPACES.         
C35979     05  RS-CROSS-STREET-1       PIC X(35) VALUE  SPACES.         
C35979     05  RS-CROSS-STREET-2       PIC X(35) VALUE  SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-RETURN-CODE          PIC S9(9) COMP VALUE ZERO.       
REARCH     05   S-DATAWINDOW-ID        PIC X(01) VALUE  SPACES.         
REARCH     05   S-ADDRESS-ID           PIC X(13) VALUE  ZEROES.         
REARCH     05   S-LOCAL-OFFICE         PIC X(03) VALUE  SPACES.         
REARCH     05   S-COMPANY-NO           PIC X(02) VALUE  SPACES.         
REARCH     05   S-BLOCK                PIC X(05) VALUE  SPACES.         
REARCH     05   S-LOT                  PIC X(05) VALUE  SPACES.         
REARCH     05   S-PREMISE-DESC         PIC X(15) VALUE  SPACES.         
REARCH     05   S-COMPLEX-TYPE         PIC X(15) VALUE  SPACES.         
REARCH     05   S-COMPLEX-NAME         PIC X(22) VALUE  SPACES.         
REARCH     05   S-COUNTY               PIC X(03) VALUE  SPACES.         
REARCH     05   S-LIGHT-CODE           PIC X(03) VALUE  SPACES.         
REARCH     05   S-LOCATOR-ID           PIC X(09) VALUE  SPACES.         
CML376     05   S-HOUSE-NO             PIC X(15) VALUE  SPACES.         
REARCH     05   S-ADDR-PREFIX-1        PIC X(03) VALUE  SPACES.         
REARCH     05   S-ADDR-PREFIX-2        PIC X(02) VALUE  SPACES.         
CML376     05   S-STREET-NAME          PIC X(30) VALUE  SPACES.         
REARCH     05   S-STREET-LOCATION-1    PIC X(04) VALUE  SPACES.         
CML376     05   S-STREET-LOCATION-2    PIC X(11) VALUE  SPACES.         
REARCH     05   S-STREET-SUFFIX        PIC X(04) VALUE  SPACES.         
REARCH     05   S-ADDR-SUFFIX          PIC X(04) VALUE  SPACES.         
REARCH     05   S-ADDRESS-OVERFLOW     PIC X(35) VALUE  SPACES.         
REARCH     05   S-CARRIER-ROUTE        PIC X(05) VALUE  SPACES.         
REARCH     05   S-ZIP-CODE             PIC X(05) VALUE  SPACES.         
REARCH     05   S-ZIP-CODE-PLUS-FOUR   PIC X(04) VALUE  SPACES.         
REARCH     05   S-ZIP-CODE-TOKEN       PIC X(01) VALUE  SPACES.         
REARCH     05   S-PERSONAL-CNTCT-CD    PIC X(01) VALUE  SPACES.         
REARCH     05   S-REVENUE-PROTECTION   PIC X(02) VALUE  SPACES.         
REARCH     05   S-SUBDIVISION-ID       PIC X(03) VALUE  SPACES.         
REARCH     05   S-CITY-GATE-ID         PIC X(07) VALUE  SPACES.         
REARCH     05   S-GAS-LEAK-SURVEY-DT   PIC X(10) VALUE  SPACES.         
REARCH     05   S-GAS-LK-SURVEY-FREQ   PIC X(02) VALUE  SPACES.         
REARCH     05   S-ADDR-USAGE-CD        PIC X(01) VALUE  SPACES.         
REARCH     05   S-REV-DISTRICT-CD      PIC X(03) VALUE  SPACES.         
REARCH     05   S-ACCOUNT-TYPE-DESC    PIC X(25) VALUE  SPACES.         
REARCH     05   S-READ-ROUTE           PIC X(04) VALUE  SPACES.         
REARCH     05   S-READ-CYCLE           PIC X(02) VALUE  SPACES.         
REARCH     05   S-INSTALL-DATE         PIC X(10) VALUE  SPACES.         
REARCH     05   S-LAST-BILL-DATE       PIC X(10) VALUE  SPACES.         
REARCH     05   S-RATE-ITEM-CODE       PIC X(04) VALUE  SPACES.         
REARCH     05   S-PRICE-PER-SERV       PIC S9(3)V9(6) COMP-3 VALUE +0.  
REARCH     05   S-B-UTIL-TYPE          PIC X(15) VALUE  SPACES.         
REARCH     05   S-B-READ-ROUTE         PIC S9(4) COMP   VALUE 0.        
REARCH     05   S-B-RATE-PLAN-NO       PIC X(3)  VALUE  SPACES.         
REARCH     05   S-B-METER-IND          PIC X(3)  VALUE  SPACES.         
REARCH     05   S-C-RATE-ITEM-CODE     PIC X(04) VALUE  SPACES.         
REARCH     05   S-C-PRICE-PER-SERV     PIC S9(3)V9(6) COMP-3 VALUE 0.   
REARCH     05   S-C-CUST-PER-SERVICE   PIC X(04) VALUE  SPACES.         
REARCH     05   S-C-EQUIP-SHRT-DESC    PIC X(17) VALUE  SPACES.         
REARCH     05   S-LIGHT-NOT-BILLED     PIC X(01) VALUE  SPACES.         
REARCH     05   S-MSG-DISPLAY-DT       PIC X(10) VALUE  SPACES.         
C35979     05   S-CROSS-STREET-1       PIC X(35) VALUE  SPACES.         
C35979     05   S-CROSS-STREET-2       PIC X(35) VALUE  SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
C33254     05  ACCT-BILLED-SW          PIC X(01) VALUE 'N'.             
C33254         88 ACCT-NOT-BILLED                VALUE 'N'.             
C33254         88 ACCT-HAS-BILLED                VALUE 'Y'.             
C33254     05  ACCT-BILLED-SUBD-SW   PIC X(01)   VALUE 'N'.             
C33254         88 NOT-BILLED-SUBD                VALUE 'N'.             
C33254         88 HAS-BILLED-SUBD                VALUE 'Y'.             
                                                                        
       01  WS-MISCELLANEOUS.                                            
REARCH     05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR02075'.    
           05  WS-PREMISE-NO           PIC S9(10) COMP-3 VALUE 0.       
           05  WS-ADDRESS-ID           PIC S9(13) COMP-3 VALUE 0.       
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE 0.       
           05  WS-VERSION-NO-CNTRL     PIC S9(04) COMP VALUE 0.         
           05  WS-RATE-ITEM-CODE       PIC S9(04) COMP VALUE 0.         
T14863     05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
T14863     05  WS-CURRENT-DATE-USA     PIC X(10) VALUE SPACES.          
           05  WS-NULL-INDICATOR       PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND             PIC S9(04) COMP VALUE 0.         
T14863     05  WS-NULL-IND-1           PIC S9(04) COMP VALUE 0.         
C31591     05  WS-NULL-IND-2           PIC S9(04) COMP VALUE 0.         
C33254     05  WS-NULL-IND-3           PIC S9(04) COMP VALUE 0.         
C33254     05  WS-NO-OF-DAYS           PIC S9(04) COMP VALUE 0.         
C33254     05  WS-DATE-UTIL-SVC-STRT   PIC X(10) VALUE SPACES.          
      ******************************************************************02613000
      *    CURSOR DECLARATIONS                                         *02614000
      ******************************************************************02615000
                                                                        
      *--- < CURSOR FOR CSS_UTIL_ENVRNMT >                              02617000
                                                                        
           EXEC SQL DECLARE UT-CURSOR CURSOR FOR                        
               SELECT CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      READ_ROUTE,                                       
                      RATE_PLAN_NO                                      
               FROM   CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO    = :WS-ACCOUNT-NO                    
               ORDER BY CODE_UTIL_TYPE                                  
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UT-CURSOR CURSOR FOR                        02619000
MFA-TR*        SELECT CODE_UTIL_TYPE,                                   02620000
MFA-TR*               IC_NO,                                            02630000
MFA-TR*               READ_ROUTE,                                       02640000
MFA-TR*               RATE_PLAN_NO                                      02650000
MFA-TR*        FROM   CSS_UTIL_ENVRNMT                                  02660000
MFA-TR*        WHERE  ACCOUNT_NO    = :WS-ACCOUNT-NO                    02670000
MFA-TR*        ORDER BY CODE_UTIL_TYPE                                  02680000
MFA-TR*        FOR FETCH ONLY WITH UR                                   02680100
MFA-TR*    END-EXEC.                                                    02690000
                                                                        
      *--- < CURSOR FOR CSS_MTRD_ENVRNMT >                              02692000
                                                                        
           EXEC SQL DECLARE MN-CURSOR CURSOR FOR                        
               SELECT MTR_REF_NO,                                       
                      IC_NO,                                            
                      CODE_UTIL_TYPE                                    
               FROM   CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO     = :WS-ACCOUNT-NO                   
               AND    CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
               AND    IC_NO          = :UT-IC-NO                        
               AND    CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MN-CURSOR CURSOR FOR                        02694000
MFA-TR*        SELECT MTR_REF_NO,                                       02695000
MFA-TR*               IC_NO,                                            02696000
MFA-TR*               CODE_UTIL_TYPE                                    02697000
MFA-TR*        FROM   CSS_MTRD_ENVRNMT                                  02698000
MFA-TR*        WHERE  ACCOUNT_NO     = :WS-ACCOUNT-NO                   02699000
MFA-TR*        AND    CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               02699100
MFA-TR*        AND    IC_NO          = :UT-IC-NO                        02699200
MFA-TR*        AND    CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    02699300
MFA-TR*        FOR FETCH ONLY WITH UR                                   02699310
MFA-TR*    END-EXEC.                                                    02699400
                                                                        
      *--- < CURSOR FOR UNMETERED PLAN >                                02699600
                                                                        
           EXEC SQL DECLARE UP-CURSOR CURSOR FOR                        
               SELECT UP.RATE_ITEM_CODE,                                
                      UP.CUST_PER_SERVICE,                              
                      UP.PRICE_PER_SERV,                                
                      L9.UM_EQUIP_SHRT_DESC                             
               FROM   CSS_UNMTR_PLAN UP
                           WITH(READUNCOMMITTED), CSS_UM_EQUIPMENT L9
                           WITH(READUNCOMMITTED)            
               WHERE  UP.RATE_PLAN_NO   = :WS-RATE-64                   
               AND    UP.CODE_UTIL_TYPE = 'U'                           
               AND    L9.UM_EQUIP_ID    = UP.UM_EQUIP_ID                
               AND    UP.VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL        
               ORDER BY RATE_ITEM_CODE                                  
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UP-CURSOR CURSOR FOR                        02699800
MFA-TR*        SELECT UP.RATE_ITEM_CODE,                                02699900
MFA-TR*               UP.CUST_PER_SERVICE,                              02700000
MFA-TR*               UP.PRICE_PER_SERV,                                02700100
MFA-TR*               L9.UM_EQUIP_SHRT_DESC                             02700200
MFA-TR*        FROM   CSS_UNMTR_PLAN UP, CSS_UM_EQUIPMENT L9            02700300
MFA-TR*        WHERE  UP.RATE_PLAN_NO   = :WS-RATE-64                   02700400
MFA-TR*        AND    UP.CODE_UTIL_TYPE = 'U'                           02700500
MFA-TR*        AND    L9.UM_EQUIP_ID    = UP.UM_EQUIP_ID                02700600
MFA-TR*        AND    UP.VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL        02700700
MFA-TR*        ORDER BY RATE_ITEM_CODE                                  02701200
MFA-TR*        FOR FETCH ONLY WITH UR                                   02701210
MFA-TR*    END-EXEC.                                                    02701300
                                                                        
      ******************************************************************02703200
      *    END CURSOR DECLARATIONS                                      02703300
      ******************************************************************02704000
                                                                        
CVT000     EXEC SQL                                                     02710001
CVT000         INCLUDE CWSX0010                                         02710002
CVT000     END-EXEC.                                                    02710003
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-PREMISE-NO                                         
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              02730000
      ******************************************************************02731000
      * 0000-MAINLINE                                                  *02740000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02750000
      ******************************************************************02760000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02880000
      * 0100-INITIALIZE                                                *02890000
      *                                                                *02900000
      *     1. RESET DB2 ERROR HANDLERS                                *02910000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02920000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02930000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02940000
      *                                                                *02950000
      ******************************************************************02960000
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR                             
A37342         WITH ROWSET POSITIONING FOR                              
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(DATAWINDOW_ID))      AS DATAWINDOW_ID           
REARCH            ,LTRIM(RTRIM(ADDRESS_ID))         AS ADDRESS_ID              
REARCH            ,LTRIM(RTRIM(HOUSE_NO))           AS HOUSE_NO                
REARCH            ,LTRIM(RTRIM(ADDR_PREFIX_1))      AS ADDR_PREFIX_1           
REARCH            ,LTRIM(RTRIM(ADDR_PREFIX_2))      AS ADDR_PREFIX_2           
REARCH            ,LTRIM(RTRIM(STREET_NAME))        AS STREET_NAME             
REARCH            ,LTRIM(RTRIM(STREET_LOCATION_1))  AS STREET_LOCATION_1       
REARCH            ,LTRIM(RTRIM(STREET_LOCATION_2))  AS STREET_LOCATION_2       
REARCH            ,LTRIM(RTRIM(STREET_SUFFIX))      AS STREET_SUFFIX           
REARCH            ,LTRIM(RTRIM(ADDR_SUFFIX))        AS ADDR_SUFFIX             
REARCH            ,LTRIM(RTRIM(ADDRESS_OVERFLOW))   AS ADDRESS_OVERFLOW        
REARCH            ,LTRIM(RTRIM(CARRIER_ROUTE))      AS CARRIER_ROUTE           
REARCH            ,LTRIM(RTRIM(ZIP_CODE))           AS ZIP_CODE                
REARCH            ,LTRIM(RTRIM(ZIP_CODE_PLUS_FOUR)) AS 
           ZIP_CODE_PLUS_FOUR      
REARCH            ,LTRIM(RTRIM(ZIP_CODE_TOKEN))     AS ZIP_CODE_TOKEN          
REARCH            ,LTRIM(RTRIM(LOCAL_OFFICE))       AS LOCAL_OFFICE            
REARCH            ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO              
REARCH            ,LTRIM(RTRIM(BLOCK))              AS BLOCK                   
REARCH            ,LTRIM(RTRIM(COMPLEX_NAME))       AS COMPLEX_NAME            
REARCH            ,LTRIM(RTRIM(COMPLEX_TYPE))       AS COMPLEX_TYPE            
REARCH            ,LTRIM(RTRIM(COUNTY))             AS COUNTY                  
REARCH            ,LTRIM(RTRIM(LIGHT_CODE))         AS LIGHT_CODE              
REARCH            ,LTRIM(RTRIM(LOCATOR_ID))         AS LOCATOR_ID              
REARCH            ,LTRIM(RTRIM(LOT))                AS LOT                     
REARCH            ,LTRIM(RTRIM(PREMISE_DESC))       AS PREMISE_DESC            
REARCH            ,LTRIM(RTRIM(PERSONAL_CNTCT_CD))  AS PERSONAL_CNTCT_CD       
REARCH            ,LTRIM(RTRIM(REVENUE_PROTECTION)) AS 
           REVENUE_PROTECTION      
REARCH            ,LTRIM(RTRIM(SUBDIVISION_ID))     AS SUBDIVISION_ID          
REARCH            ,LTRIM(RTRIM(CITY_GATE_ID))       AS CITY_GATE_ID            
REARCH            ,LTRIM(RTRIM(GAS_LEAK_SURVEY_DT)) AS 
           GAS_LEAK_SURVEY_DT      
REARCH            ,LTRIM(RTRIM(GAS_LK_SURVEY_FREQ)) AS 
           GAS_LK_SURVEY_FREQ      
REARCH            ,LTRIM(RTRIM(ADDR_USAGE_CD))      AS ADDR_USAGE_CD           
REARCH            ,LTRIM(RTRIM(REV_DISTRICT_CD))    AS REV_DISTRICT_CD         
REARCH            ,LTRIM(RTRIM(ACCOUNT_TYPE_DESC))  AS ACCOUNT_TYPE_DESC       
REARCH            ,LTRIM(RTRIM(READ_ROUTE))         AS READ_ROUTE              
REARCH            ,LTRIM(RTRIM(RATE_ITEM_CODE))     AS RATE_ITEM_CODE          
REARCH            ,PRICE_PER_SERV                                       
REARCH            ,LTRIM(RTRIM(B_UTIL_TYPE))        AS B_UTIL_TYPE             
REARCH            ,B_READ_ROUTE                                         
REARCH            ,LTRIM(RTRIM(B_RATE_PLAN_NO))     AS B_RATE_PLAN_NO          
REARCH            ,LTRIM(RTRIM(B_METER_IND))        AS B_METER_IND             
REARCH            ,LTRIM(RTRIM(C_RATE_ITEM_CODE))   AS C_RATE_ITEM_CODE        
REARCH            ,C_PRICE_PER_SERV                                     
REARCH            ,LTRIM(RTRIM(C_CUST_PER_SERVICE)) AS 
           C_CUST_PER_SERVICE      
REARCH            ,LTRIM(RTRIM(C_EQUIP_DESC))       AS C_EQUIP_DESC            
REARCH            ,LTRIM(RTRIM(READ_CYCLE))         AS READ_CYCLE              
REARCH            ,LTRIM(RTRIM(INSTALL_DATE))       AS INSTALL_DATE            
REARCH            ,LTRIM(RTRIM(LAST_BILL_DT))       AS LAST_BILL_DT            
REARCH            ,LTRIM(RTRIM(NO_LIGHT))           AS NO_LIGHT                
REARCH            ,LTRIM(RTRIM(DISPLAY_DT))         AS DISPLAY_DT              
REARCH            ,CAST(SYSDATETIMEOFFSET() AS DATE)          AS 
           GAS_LEAK_SURVEY_DT          
REARCH            ,''  AS CITY                                          
REARCH            ,'' AS STATE                                          
REARCH            ,'' AS SEB_REG_IND                                    
C35979            ,CROSS_STREET_1                                       
C35979            ,CROSS_STREET_2                                       
REARCH            FROM #CSR02075_R1                              
REARCH        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03200600
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            03200700
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                   03200800
MFA-TR*            RETURN_CODE                                          03200900
MFA-TR*           ,STRIP(DATAWINDOW_ID)      AS DATAWINDOW_ID           03201000
MFA-TR*           ,STRIP(ADDRESS_ID)         AS ADDRESS_ID              03201100
MFA-TR*           ,STRIP(HOUSE_NO)           AS HOUSE_NO                03201200
MFA-TR*           ,STRIP(ADDR_PREFIX_1)      AS ADDR_PREFIX_1           03201300
MFA-TR*           ,STRIP(ADDR_PREFIX_2)      AS ADDR_PREFIX_2           03201400
MFA-TR*           ,STRIP(STREET_NAME)        AS STREET_NAME             03201500
MFA-TR*           ,STRIP(STREET_LOCATION_1)  AS STREET_LOCATION_1       03201600
MFA-TR*           ,STRIP(STREET_LOCATION_2)  AS STREET_LOCATION_2       03201700
MFA-TR*           ,STRIP(STREET_SUFFIX)      AS STREET_SUFFIX           03201800
MFA-TR*           ,STRIP(ADDR_SUFFIX)        AS ADDR_SUFFIX             03201900
MFA-TR*           ,STRIP(ADDRESS_OVERFLOW)   AS ADDRESS_OVERFLOW        03202000
MFA-TR*           ,STRIP(CARRIER_ROUTE)      AS CARRIER_ROUTE           03202100
MFA-TR*           ,STRIP(ZIP_CODE)           AS ZIP_CODE                03202200
MFA-TR*           ,STRIP(ZIP_CODE_PLUS_FOUR) AS ZIP_CODE_PLUS_FOUR      03202300
MFA-TR*           ,STRIP(ZIP_CODE_TOKEN)     AS ZIP_CODE_TOKEN          03202400
MFA-TR*           ,STRIP(LOCAL_OFFICE)       AS LOCAL_OFFICE            03202500
MFA-TR*           ,STRIP(COMPANY_NO)         AS COMPANY_NO              03202600
MFA-TR*           ,STRIP(BLOCK)              AS BLOCK                   03202700
MFA-TR*           ,STRIP(COMPLEX_NAME)       AS COMPLEX_NAME            03202800
MFA-TR*           ,STRIP(COMPLEX_TYPE)       AS COMPLEX_TYPE            03202900
MFA-TR*           ,STRIP(COUNTY)             AS COUNTY                  03203000
MFA-TR*           ,STRIP(LIGHT_CODE)         AS LIGHT_CODE              03203100
MFA-TR*           ,STRIP(LOCATOR_ID)         AS LOCATOR_ID              03203200
MFA-TR*           ,STRIP(LOT)                AS LOT                     03203300
MFA-TR*           ,STRIP(PREMISE_DESC)       AS PREMISE_DESC            03203400
MFA-TR*           ,STRIP(PERSONAL_CNTCT_CD)  AS PERSONAL_CNTCT_CD       03203500
MFA-TR*           ,STRIP(REVENUE_PROTECTION) AS REVENUE_PROTECTION      03203600
MFA-TR*           ,STRIP(SUBDIVISION_ID)     AS SUBDIVISION_ID          03203700
MFA-TR*           ,STRIP(CITY_GATE_ID)       AS CITY_GATE_ID            03203800
MFA-TR*           ,STRIP(GAS_LEAK_SURVEY_DT) AS GAS_LEAK_SURVEY_DT      03203900
MFA-TR*           ,STRIP(GAS_LK_SURVEY_FREQ) AS GAS_LK_SURVEY_FREQ      03204000
MFA-TR*           ,STRIP(ADDR_USAGE_CD)      AS ADDR_USAGE_CD           03204100
MFA-TR*           ,STRIP(REV_DISTRICT_CD)    AS REV_DISTRICT_CD         03204200
MFA-TR*           ,STRIP(ACCOUNT_TYPE_DESC)  AS ACCOUNT_TYPE_DESC       03204300
MFA-TR*           ,STRIP(READ_ROUTE)         AS READ_ROUTE              03204400
MFA-TR*           ,STRIP(RATE_ITEM_CODE)     AS RATE_ITEM_CODE          03204500
MFA-TR*           ,PRICE_PER_SERV                                       03204600
MFA-TR*           ,STRIP(B_UTIL_TYPE)        AS B_UTIL_TYPE             03204700
MFA-TR*           ,B_READ_ROUTE                                         03204800
MFA-TR*           ,STRIP(B_RATE_PLAN_NO)     AS B_RATE_PLAN_NO          03204900
MFA-TR*           ,STRIP(B_METER_IND)        AS B_METER_IND             03205000
MFA-TR*           ,STRIP(C_RATE_ITEM_CODE)   AS C_RATE_ITEM_CODE        03205100
MFA-TR*           ,C_PRICE_PER_SERV                                     03205200
MFA-TR*           ,STRIP(C_CUST_PER_SERVICE) AS C_CUST_PER_SERVICE      03205300
MFA-TR*           ,STRIP(C_EQUIP_DESC)       AS C_EQUIP_DESC            03205400
MFA-TR*           ,STRIP(READ_CYCLE)         AS READ_CYCLE              03205500
MFA-TR*           ,STRIP(INSTALL_DATE)       AS INSTALL_DATE            03205600
MFA-TR*           ,STRIP(LAST_BILL_DT)       AS LAST_BILL_DT            03205700
MFA-TR*           ,STRIP(NO_LIGHT)           AS NO_LIGHT                03205800
MFA-TR*           ,STRIP(DISPLAY_DT)         AS DISPLAY_DT              03205900
MFA-TR*           ,CURRENT DATE          AS GAS_LEAK_SURVEY_DT          03206000
MFA-TR*           ,''  AS CITY                                          03206100
MFA-TR*           ,'' AS STATE                                          03206200
MFA-TR*           ,'' AS SEB_REG_IND                                    03206300
MFA-TR*           ,CROSS_STREET_1                                       03206400
MFA-TR*           ,CROSS_STREET_2                                       03206500
MFA-TR*           FROM SESSION.CSR02075_R1                              03206600
MFA-TR*       END-EXEC.                                                 03206700
REARCH 0100-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
REARCH******************************************************************03220200
REARCH*0100A-DECLARE-GTT                                               *03220300
REARCH******************************************************************03220400
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02075_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02075_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,DATAWINDOW_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,ADDRESS_ID CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
CML376        ,HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,ADDR_PREFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,ADDR_PREFIX_2 CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
CML376        ,STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,STREET_LOCATION_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CML376        ,STREET_LOCATION_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,STREET_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,ADDR_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,CARRIER_ROUTE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,ZIP_CODE_TOKEN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,LOCAL_OFFICE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,BLOCK CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2                  
CVT000        ,COMPLEX_NAME CHAR(22)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,COMPLEX_TYPE CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,COUNTY CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2                 
CVT000        ,LIGHT_CODE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,LOCATOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,LOT CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2                    
CVT000        ,PREMISE_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,PERSONAL_CNTCT_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,REVENUE_PROTECTION CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SUBDIVISION_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,CITY_GATE_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,GAS_LEAK_SURVEY_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,GAS_LK_SURVEY_FREQ CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,ADDR_USAGE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,REV_DISTRICT_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,ACCOUNT_TYPE_DESC CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,READ_ROUTE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,RATE_ITEM_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,PRICE_PER_SERV           DECIMAL(9,6)                    
CVT000        ,B_UTIL_TYPE CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,B_READ_ROUTE             SMALLINT                        
CVT000        ,B_RATE_PLAN_NO CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,B_METER_IND CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,C_RATE_ITEM_CODE CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,C_PRICE_PER_SERV         DECIMAL(9,6)                    
CVT000        ,C_CUST_PER_SERVICE CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,C_EQUIP_DESC CHAR(17)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,INSTALL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,LAST_BILL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,NO_LIGHT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,DISPLAY_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
C35979        ,CROSS_STREET_1 CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2         
C35979        ,CROSS_STREET_2 CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
REARCH            MOVE 'CSR02075_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************03240000
      * 1000-PROCESS-INPUT                                             *03250000
      *     CALLS       1100-RECEIVE-PARMS                             *03251000
      *                                                                *03260000
      *     CALLED FROM 0000-MAINLINE                                  *03261000
      *                                                                *03262000
      *     RECEIVE PARMS FROM THE CALLING STORED PROCEDURE.           *03270000
      ******************************************************************03290000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PREMISE-NO-RED   TO WS-PREMISE-NO.                 
T21118     IF PARM-ACCOUNT-NO NOT NUMERIC                               
T21118         MOVE '0000000000000' TO PARM-ACCOUNT-NO
           END-IF.                 
           MOVE PARM-ACCOUNT-NO-RED   TO WS-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03580000
      * 2000-PROCESS-OUTPUT                                           * 03590000
      *                                                               * 03600000
      *   1. DESCRIBE RESULT SET                                      * 03610000
      *   2. RETRIEVE DB2 DATA AND BUILD RESULT SET                   * 03620000
      *   3. SEND RESULT SET                                          * 03630000
      *                                                               * 03640000
      ***************************************************************** 03650000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************03760001
REARCH* 2000A-MOVE-RESULT.                                             *03760002
REARCH******************************************************************03760003
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                *03760005
REARCH      MOVE RS-RETURN-CODE          TO S-RETURN-CODE.              
REARCH      MOVE RS-DATAWINDOW-ID        TO S-DATAWINDOW-ID.            
REARCH      MOVE RS-ADDRESS-ID           TO S-ADDRESS-ID.               
REARCH      MOVE RS-LOCAL-OFFICE         TO S-LOCAL-OFFICE.             
REARCH      MOVE RS-COMPANY-NO           TO S-COMPANY-NO.               
REARCH      MOVE RS-BLOCK                TO S-BLOCK.                    
REARCH      MOVE RS-LOT                  TO S-LOT.                      
REARCH      MOVE RS-PREMISE-DESC         TO S-PREMISE-DESC.             
REARCH      MOVE RS-COMPLEX-TYPE         TO S-COMPLEX-TYPE.             
REARCH      MOVE RS-COMPLEX-NAME         TO S-COMPLEX-NAME.             
REARCH      MOVE RS-COUNTY               TO S-COUNTY.                   
REARCH      MOVE RS-LIGHT-CODE           TO S-LIGHT-CODE.               
REARCH      MOVE RS-LOCATOR-ID           TO S-LOCATOR-ID.               
REARCH      MOVE RS-HOUSE-NO             TO S-HOUSE-NO.                 
REARCH      MOVE RS-ADDR-PREFIX-1        TO S-ADDR-PREFIX-1.            
REARCH      MOVE RS-ADDR-PREFIX-2        TO S-ADDR-PREFIX-2.            
REARCH      MOVE RS-STREET-NAME          TO S-STREET-NAME.              
REARCH      MOVE RS-STREET-LOCATION-1    TO S-STREET-LOCATION-1.        
REARCH      MOVE RS-STREET-LOCATION-2    TO S-STREET-LOCATION-2.        
REARCH      MOVE RS-STREET-SUFFIX        TO S-STREET-SUFFIX.            
REARCH      MOVE RS-ADDR-SUFFIX          TO S-ADDR-SUFFIX.              
REARCH      MOVE RS-ADDRESS-OVERFLOW     TO S-ADDRESS-OVERFLOW.         
REARCH      MOVE RS-CARRIER-ROUTE        TO S-CARRIER-ROUTE.            
REARCH      MOVE RS-ZIP-CODE             TO S-ZIP-CODE.                 
REARCH      MOVE RS-ZIP-CODE-PLUS-FOUR   TO S-ZIP-CODE-PLUS-FOUR.       
REARCH      MOVE RS-ZIP-CODE-TOKEN       TO S-ZIP-CODE-TOKEN.           
REARCH      MOVE RS-PERSONAL-CNTCT-CD    TO S-PERSONAL-CNTCT-CD.        
REARCH      MOVE RS-REVENUE-PROTECTION   TO S-REVENUE-PROTECTION.       
REARCH      MOVE RS-SUBDIVISION-ID       TO S-SUBDIVISION-ID.           
REARCH      MOVE RS-CITY-GATE-ID         TO S-CITY-GATE-ID.             
REARCH      MOVE RS-GAS-LEAK-SURVEY-DT   TO S-GAS-LEAK-SURVEY-DT.       
REARCH      MOVE RS-GAS-LK-SURVEY-FREQ   TO S-GAS-LK-SURVEY-FREQ.       
REARCH      MOVE RS-ADDR-USAGE-CD        TO S-ADDR-USAGE-CD.            
REARCH      MOVE RS-REV-DISTRICT-CD      TO S-REV-DISTRICT-CD.          
REARCH      MOVE RS-ACCOUNT-TYPE-DESC    TO S-ACCOUNT-TYPE-DESC.        
REARCH      MOVE RS-READ-ROUTE           TO S-READ-ROUTE.               
REARCH      MOVE RS-READ-CYCLE           TO S-READ-CYCLE.               
REARCH      MOVE RS-INSTALL-DATE         TO S-INSTALL-DATE.             
REARCH      MOVE RS-LAST-BILL-DATE       TO S-LAST-BILL-DATE.           
REARCH      MOVE RS-RATE-ITEM-CODE       TO S-RATE-ITEM-CODE.           
REARCH      MOVE RS-PRICE-PER-SERV       TO S-PRICE-PER-SERV.           
REARCH      MOVE RS-B-UTIL-TYPE          TO S-B-UTIL-TYPE.              
REARCH      MOVE RS-B-READ-ROUTE         TO S-B-READ-ROUTE.             
REARCH      MOVE RS-B-RATE-PLAN-NO       TO S-B-RATE-PLAN-NO.           
REARCH      MOVE RS-B-METER-IND          TO S-B-METER-IND.              
REARCH      MOVE RS-C-RATE-ITEM-CODE     TO S-C-RATE-ITEM-CODE.         
REARCH      MOVE RS-C-PRICE-PER-SERV     TO S-C-PRICE-PER-SERV.         
REARCH      MOVE RS-C-CUST-PER-SERVICE   TO S-C-CUST-PER-SERVICE.       
REARCH      MOVE RS-C-EQUIP-SHRT-DESC    TO S-C-EQUIP-SHRT-DESC.        
REARCH      MOVE RS-LIGHT-NOT-BILLED     TO S-LIGHT-NOT-BILLED.         
REARCH      MOVE RS-MSG-DISPLAY-DT       TO S-MSG-DISPLAY-DT.           
C35979      MOVE RS-CROSS-STREET-1       TO S-CROSS-STREET-1.           
C35979      MOVE RS-CROSS-STREET-2       TO S-CROSS-STREET-2.           
                                                                        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************06640909
      * 2200-BUILD-RESULT                                              *06640910
      *   CALLS       5000-PROCESS-FETCH-UT                            *06640911
      *               5100-PROCESS-FETCH-UP                            *06640912
      *               7000-SELECT-PREMISE                              *06640913
      *               7200-OPEN-UT-CURSOR                              *06640914
      *               7100-SELECT-ADDR-FORMATTED                       *06640915
      *               7220-CLOSE-UT-CURSOR                             *06640916
      *               7300-OPEN-UP-CURSOR                              *06640917
      *               7320-CLOSE-UP-CURSOR                             *06640918
      *               7500-SELECT-RATE-ITEM-CODE                       *06640919
      *               7510-GET-CURRENT-DATE                            *06640920
      *               7600-SELECT-VERSION-NO-CNTRL                     *06640921
      *               7700-SELECT-PRICE-PER-SERV                       *06640922
      *               7800-SELECT-ACCOUNT-TYPE                         *06640923
      *               7900-SELECT-READ-ROUTE                           *06640924
      *               8100-SEND-RESULT                                 *06640925
      *                                                                *06640926
      *   CALLED FROM 2000-PROCESS-OUTPUT                              *06640927
      *                                                                *06641000
      *   SELECT AND FORMAT ALL PREMISE DETAIL INFORMATION,            *06641100
      *   SERVICE INFORMATION AND SUBDIVISION LIGHT INFOR TO BE        *06641200
      *   RETURNED.                                                    *06641300
      ******************************************************************06641400
       2200-BUILD-RESULT.                                               
                                                                        
      *---< RETRIEVE AND SEND ADDRESS INFORMATION >                     06642000
           MOVE 'A' TO RS-DATAWINDOW-ID.                                
           PERFORM 7000-SELECT-PREMISE             THRU 7000-EXIT.      
           MOVE PR-ADDRESS-ID TO WS-ADDRESS-ID                          
           PERFORM 7100-SELECT-ADDR-FORMATTED      THRU 7100-EXIT.      
           PERFORM 7600-SELECT-VERSION-NO-CNTRL    THRU 7600-EXIT       
T14863     PERFORM 7510-GET-CURRENT-DATE           THRU 7510-EXIT       
           IF WS-ACCOUNT-NO > 0                                         
      *------< RETRIEVE ACCOUNT TYPE,READ ROUTE,AND DATE_UTIL_SVC_STRT> 12710400
C33254        PERFORM 7790-SELECT-CUST-PREM-HIST   THRU 7790-EXIT       
              PERFORM 7800-SELECT-ACCOUNT-TYPE     THRU 7800-EXIT       
              PERFORM 7900-SELECT-READ-ROUTE       THRU 7900-EXIT       
                                                                        
TP8615** ONLY RETRIEVE READ CYCLE IF THE READ ROUTE IS NOT NULL.        12710800
              IF WS-NULL-IND >= 0                                       
                  PERFORM 7950-SELECT-READ-CYCLE   THRU 7950-EXIT       
              END-IF                                                    
                                                                        
      *------< RETRIEVE ACCOUNT SUBDIV LIGHT INFORMATION >              12711500
              PERFORM 7500-SELECT-RATE-ITEM-CODE   THRU 7500-EXIT       
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7700-SELECT-PRICE-PER-SERV   THRU 7700-EXIT    
              END-IF                                                    
           END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT               THRU 2000A-EXIT.     
           PERFORM 8100-SEND-RESULT                THRU 8100-EXIT.      
                                                                        
      *---< RETRIEVE AND SEND SERVICE INFORMATION >                     12712300
           IF WS-ACCOUNT-NO > 0                                         
              MOVE 'B' TO RS-DATAWINDOW-ID                              
              PERFORM 7200-OPEN-UT-CURSOR          THRU 7200-EXIT       
              PERFORM 5000-PROCESS-FETCH-UT        THRU 5000-EXIT       
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
              PERFORM 7220-CLOSE-UT-CURSOR         THRU 7220-EXIT       
           END-IF.                                                      
                                                                        
      *---< RETRIEVE AND SEND SUBDIVISION LIGHTING INFORMATION >        12713200
           MOVE 'C' TO RS-DATAWINDOW-ID                                 
           PERFORM 7300-OPEN-UP-CURSOR             THRU 7300-EXIT.      
           PERFORM 5100-PROCESS-FETCH-UP           THRU 5100-EXIT       
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7320-CLOSE-UP-CURSOR            THRU 7320-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12731000
      * 5000-PROCESS-FETCH-UT                                          *12732000
      *     CALLS       7210-FETCH-UTIL-ENVRNMT                        *12733000
      *                 7400-OPEN-MN-CURSOR                            *12733100
      *                 7410-FETCH-MTRD-ENVRNMT                        *12733200
      *                 7420-CLOSE-MN-CURSOR                           *12733400
      *                 8100-SEND-RESULT                               *12734000
      *                                                                *12735000
      *     CALLED FROM 2200-BUILD-RESULT                              *12736000
      *                                                                *12737000
      *     READ EACH RETURNED ROW OF CSS_UTIL_ENVRNMT,  FORMAT IT     *12738000
      *     AND SEND IT BACK.                                          *12739000
      ******************************************************************12739100
       5000-PROCESS-FETCH-UT.                                           
                                                                        
           PERFORM 7210-FETCH-UTIL-ENVRNMT        THRU 7210-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE UT-CODE-UTIL-TYPE        TO RS-B-UTIL-TYPE           
              MOVE UT-READ-ROUTE            TO RS-B-READ-ROUTE          
              MOVE UT-RATE-PLAN-NO          TO RS-B-RATE-PLAN-NO        
                                                                        
              IF UT-CODE-UTIL-TYPE = 'U'                                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 ADD  1 TO WS-UT-COUNT                                  
                 MOVE 0 TO WS-MN-COUNT                                  
                 PERFORM 7400-OPEN-MN-CURSOR       THRU 7400-EXIT       
                 PERFORM 7410-FETCH-MTRD-ENVRNMT   THRU 7410-EXIT       
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND            
                 PERFORM 7420-CLOSE-MN-CURSOR      THRU 7420-EXIT       
                                                                        
                 IF WS-MN-COUNT > 0                                     
                    MOVE WS-YES TO RS-B-METER-IND                       
                 ELSE                                                   
                    MOVE WS-NO  TO RS-B-METER-IND                       
                 END-IF                                                 
                 EVALUATE UT-CODE-UTIL-TYPE                             
                    WHEN WS-E                                           
                        MOVE WS-ELECTRIC TO RS-B-UTIL-TYPE              
                    WHEN WS-G                                           
                        MOVE WS-GAS TO RS-B-UTIL-TYPE                   
                    WHEN WS-W                                           
                        MOVE WS-WATER TO RS-B-UTIL-TYPE                 
                    WHEN WS-S                                           
                        MOVE WS-SEWAGE TO RS-B-UTIL-TYPE                
                    WHEN OTHER                                          
                        MOVE WS-UNKNOWN TO RS-B-UTIL-TYPE               
                 END-EVALUATE                                           
                 MOVE 0 TO RS-RETURN-CODE                               
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT  THRU 8100-EXIT               
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13190000
      * 5100-PROCESS-FETCH-UP                                          *13200000
      *     CALLS       7300-FETCH-UP-CURSOR                           *13210000
      *                 8100-SEND-RESULT                               *13220000
      *                                                                *13230000
      *     CALLED FROM 2200-BUILD-RESULT                              *13240000
      *                                                                *13241000
      *     READ EACH RETURNED ROW OF CSS_UNMTR_PLAN, FORMAT IT        *13242000
      *     AND SEND IT BACK                                           *13243000
      ******************************************************************13244000
       5100-PROCESS-FETCH-UP.                                           
                                                                        
           PERFORM 7310-FETCH-UP-CURSOR            THRU 7310-EXIT.      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE UP-RATE-ITEM-CODE     TO RS-C-RATE-ITEM-CODE         
      *                                     RS-RATE-ITEM-CODE           13249600
              MOVE UP-PRICE-PER-SERV     TO RS-C-PRICE-PER-SERV         
      *                                     RS-PRICE-PER-SERV           13249800
              MOVE UP-CUST-PER-SERVICE   TO RS-C-CUST-PER-SERVICE       
              MOVE L9-UM-EQUIP-SHRT-DESC TO RS-C-EQUIP-SHRT-DESC        
REARCH        PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT      
              PERFORM 8100-SEND-RESULT             THRU 8100-EXIT       
              ADD 1 TO WS-ROW-COUNT                                     
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13265000
      * 7000-SELECT-PREMISE                                            *13270000
      *     CALLS       9000-SEND-ERROR-RESULT                         *13270200
      *                 9900-SQL-ERROR-ROUTINE                         *13270300
      *                                                                *13270500
      *     CALLED FROM 2200-BUILD-RESULT                              *13270600
      *                                                                *13271000
      *     SELECT PREMISE INFORMATION                                 *13272000
      ******************************************************************13280000
       7000-SELECT-PREMISE.                                             
           MOVE '7000' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID,                                        
                     LOCAL_OFFICE,                                      
                     COMPANY_NO,                                        
                     BLOCK,                                             
                     LOT,                                               
                     PREMISE_DESC,                                      
                     COMPLEX_TYPE,                                      
                     COMPLEX_NAME,                                      
                     SUBDIVISION_ID,                                    
                     COUNTY,                                            
                     LIGHT_CODE,                                        
                     LOCATOR_ID,                                        
                     PERSONAL_CNTCT_CD,                                 
                     REVENUE_PROTECTION,                                
                     CITY_GATE_ID,                                      
C22254               CIS.CHAR2$DATE(GAS_LEAK_SURVEY_DT,'USA'),                  
                     GAS_LK_SURVEY_FREQ,                                
                     REV_DISTRICT_CD,                                   
C35979               CROSS_STREET_1,                                    
C35979               CROSS_STREET_2                                     
               INTO :PR-ADDRESS-ID,                                     
                    :PR-LOCAL-OFFICE,                                   
                    :PR-COMPANY-NO,                                     
                    :PR-BLOCK,                                          
                    :PR-LOT,                                            
                    :PR-PREMISE-DESC,                                   
                    :PR-COMPLEX-TYPE,                                   
                    :PR-COMPLEX-NAME,                                   
                    :PR-SUBDIVISION-ID,                                 
                    :PR-COUNTY,                                         
                    :PR-LIGHT-CODE,                                     
                    :PR-LOCATOR-ID,                                     
                    :PR-PERSONAL-CNTCT-CD,                              
                    :PR-REVENUE-PROTECTION,                             
                    :PR-CITY-GATE-ID,                                   
                    :PR-GAS-LEAK-SURVEY-DT :WS-NULL-IND,                
                    :PR-GAS-LK-SURVEY-FREQ,                             
                    :PR-REV-DISTRICT-CD,                                
C35979              :PR-CROSS-STREET-1,                                 
C35979              :PR-CROSS-STREET-2                                  
              FROM   CSS_PREMISE WITH(READUNCOMMITTED)                          
              WHERE  PREMISE_NO = :WS-PREMISE-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT ADDRESS_ID,                                        13330300
MFA-TR*              LOCAL_OFFICE,                                      13330400
MFA-TR*              COMPANY_NO,                                        13330500
MFA-TR*              BLOCK,                                             13330600
MFA-TR*              LOT,                                               13330700
MFA-TR*              PREMISE_DESC,                                      13330800
MFA-TR*              COMPLEX_TYPE,                                      13330900
MFA-TR*              COMPLEX_NAME,                                      13331000
MFA-TR*              SUBDIVISION_ID,                                    13331100
MFA-TR*              COUNTY,                                            13331200
MFA-TR*              LIGHT_CODE,                                        13331300
MFA-TR*              LOCATOR_ID,                                        13331400
MFA-TR*              PERSONAL_CNTCT_CD,                                 13331500
MFA-TR*              REVENUE_PROTECTION,                                13331600
MFA-TR*              CITY_GATE_ID,                                      13331900
MFA-TR*              CHAR(GAS_LEAK_SURVEY_DT,USA),                      13332000
MFA-TR*              GAS_LK_SURVEY_FREQ,                                13332100
MFA-TR*              REV_DISTRICT_CD,                                   13333000
MFA-TR*              CROSS_STREET_1,                                    13333100
MFA-TR*              CROSS_STREET_2                                     13333200
MFA-TR*        INTO :PR-ADDRESS-ID,                                     13334000
MFA-TR*             :PR-LOCAL-OFFICE,                                   13335000
MFA-TR*             :PR-COMPANY-NO,                                     13335100
MFA-TR*             :PR-BLOCK,                                          13336000
MFA-TR*             :PR-LOT,                                            13337000
MFA-TR*             :PR-PREMISE-DESC,                                   13338000
MFA-TR*             :PR-COMPLEX-TYPE,                                   13339000
MFA-TR*             :PR-COMPLEX-NAME,                                   13340000
MFA-TR*             :PR-SUBDIVISION-ID,                                 13350000
MFA-TR*             :PR-COUNTY,                                         13360000
MFA-TR*             :PR-LIGHT-CODE,                                     13370000
MFA-TR*             :PR-LOCATOR-ID,                                     13380000
MFA-TR*             :PR-PERSONAL-CNTCT-CD,                              13390000
MFA-TR*             :PR-REVENUE-PROTECTION,                             13400000
MFA-TR*             :PR-CITY-GATE-ID,                                   13440000
MFA-TR*             :PR-GAS-LEAK-SURVEY-DT :WS-NULL-IND,                13450000
MFA-TR*             :PR-GAS-LK-SURVEY-FREQ,                             13451000
MFA-TR*             :PR-REV-DISTRICT-CD,                                13460000
MFA-TR*             :PR-CROSS-STREET-1,                                 13460100
MFA-TR*             :PR-CROSS-STREET-2                                  13460200
MFA-TR*       FROM   CSS_PREMISE                                        13550000
MFA-TR*       WHERE  PREMISE_NO = :WS-PREMISE-NO                        13560000
MFA-TR*       WITH UR                                                   13560100
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE PR-ADDRESS-ID           TO RS-ADDRESS-ID             
              MOVE PR-LOCAL-OFFICE         TO RS-LOCAL-OFFICE           
              MOVE PR-COMPANY-NO           TO RS-COMPANY-NO             
              MOVE PR-BLOCK                TO RS-BLOCK                  
              MOVE PR-LOT                  TO RS-LOT                    
              MOVE PR-PREMISE-DESC         TO RS-PREMISE-DESC           
              MOVE PR-COMPLEX-TYPE         TO RS-COMPLEX-TYPE           
              MOVE PR-COMPLEX-NAME         TO RS-COMPLEX-NAME           
              MOVE PR-SUBDIVISION-ID       TO RS-SUBDIVISION-ID         
              MOVE PR-COUNTY               TO RS-COUNTY                 
              MOVE PR-LIGHT-CODE           TO RS-LIGHT-CODE             
              MOVE PR-LOCATOR-ID           TO RS-LOCATOR-ID             
              MOVE PR-PERSONAL-CNTCT-CD    TO RS-PERSONAL-CNTCT-CD      
              MOVE PR-REVENUE-PROTECTION   TO RS-REVENUE-PROTECTION     
              MOVE PR-CITY-GATE-ID         TO RS-CITY-GATE-ID           
              IF WS-NULL-IND < 0                                        
REARCH           MOVE '01/01/1900'         TO RS-GAS-LEAK-SURVEY-DT     
              ELSE                                                      
                 MOVE PR-GAS-LEAK-SURVEY-DT TO RS-GAS-LEAK-SURVEY-DT    
              END-IF                                                    
              MOVE PR-GAS-LK-SURVEY-FREQ   TO RS-GAS-LK-SURVEY-FREQ     
              MOVE PR-REV-DISTRICT-CD      TO RS-REV-DISTRICT-CD        
C35979        MOVE PR-CROSS-STREET-1       TO RS-CROSS-STREET-1         
C35979        MOVE PR-CROSS-STREET-2       TO RS-CROSS-STREET-2         
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE ZEROES                  TO RS-ADDRESS-ID             
T14391        MOVE ZEROES                  TO PR-ADDRESS-ID             
              MOVE SPACES                  TO RS-LOCAL-OFFICE           
              MOVE SPACES                  TO RS-COMPANY-NO             
              MOVE SPACES                  TO RS-BLOCK                  
              MOVE SPACES                  TO RS-LOT                    
              MOVE SPACES                  TO RS-PREMISE-DESC           
              MOVE SPACES                  TO RS-COMPLEX-TYPE           
              MOVE SPACES                  TO RS-COMPLEX-NAME           
              MOVE SPACES                  TO RS-SUBDIVISION-ID         
              MOVE SPACES                  TO RS-COUNTY                 
              MOVE SPACES                  TO RS-LIGHT-CODE             
              MOVE SPACES                  TO RS-LOCATOR-ID             
              MOVE SPACES                  TO RS-PERSONAL-CNTCT-CD      
              MOVE SPACES                  TO RS-REVENUE-PROTECTION     
              MOVE SPACES                  TO RS-CITY-GATE-ID           
              MOVE SPACES                  TO RS-GAS-LEAK-SURVEY-DT     
              MOVE SPACES                  TO RS-GAS-LK-SURVEY-FREQ     
              MOVE SPACES                  TO RS-REV-DISTRICT-CD        
C35979        MOVE SPACES                  TO RS-CROSS-STREET-1         
C35979        MOVE SPACES                  TO RS-CROSS-STREET-2         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15251100
      * 7100-SELECT-ADDR-FORMATTED                                     *15251200
      *     CALLS       9000-SEND-ERROR-RESULT                         *15251300
      *                 9900-SQL-ERROR-ROUTINE                         *15251400
      *                                                                *15251500
      *     CALLED FROM 2200-BUILD-RESULT                              *15251600
      *                                                                *15251700
      *     SELECT ADDRESS INFORMATION FOR PREMISE USING ADDRESS ID    *15251800
      *     FROM PREMISE TABLE                                         *15251900
      ******************************************************************15252100
       7100-SELECT-ADDR-FORMATTED.                                      
           MOVE '7100' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT HOUSE_NO,                                          
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     STREET_NAME,                                       
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     STREET_SUFFIX,                                     
                     ADDR_SUFFIX,                                       
                     ADDRESS_OVERFLOW,                                  
                     CARRIER_ROUTE,                                     
                     ZIP_CODE,                                          
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN,                                    
                     ADDR_USAGE_CD                                      
              INTO  :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-STREET-SUFFIX,                                  
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ADDRESS-OVERFLOW,                               
                    :DY-CARRIER-ROUTE,                                  
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDR-USAGE-CD                                   
              FROM   CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
              WHERE  ADDRESS_ID = :WS-ADDRESS-ID                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15252500
MFA-TR*       SELECT HOUSE_NO,                                          15252600
MFA-TR*              ADDR_PREFIX_1,                                     15252700
MFA-TR*              ADDR_PREFIX_2,                                     15252800
MFA-TR*              STREET_NAME,                                       15252900
MFA-TR*              STREET_LOCATION_1,                                 15253000
MFA-TR*              STREET_LOCATION_2,                                 15253100
MFA-TR*              STREET_SUFFIX,                                     15253200
MFA-TR*              ADDR_SUFFIX,                                       15253300
MFA-TR*              ADDRESS_OVERFLOW,                                  15253400
MFA-TR*              CARRIER_ROUTE,                                     15253500
MFA-TR*              ZIP_CODE,                                          15253600
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                15253700
MFA-TR*              ZIP_CODE_TOKEN,                                    15253800
MFA-TR*              ADDR_USAGE_CD                                      15253900
MFA-TR*       INTO  :DY-HOUSE-NO,                                       15254000
MFA-TR*             :DY-ADDR-PREFIX-1,                                  15254100
MFA-TR*             :DY-ADDR-PREFIX-2,                                  15254200
MFA-TR*             :DY-STREET-NAME,                                    15254300
MFA-TR*             :DY-STREET-LOCATION-1,                              15254400
MFA-TR*             :DY-STREET-LOCATION-2,                              15254500
MFA-TR*             :DY-STREET-SUFFIX,                                  15254600
MFA-TR*             :DY-ADDR-SUFFIX,                                    15254700
MFA-TR*             :DY-ADDRESS-OVERFLOW,                               15254800
MFA-TR*             :DY-CARRIER-ROUTE,                                  15254900
MFA-TR*             :DY-ZIP-CODE,                                       15255000
MFA-TR*             :DY-ZIP-CODE-PLUS-FOUR,                             15255100
MFA-TR*             :DY-ZIP-CODE-TOKEN,                                 15255200
MFA-TR*             :DY-ADDR-USAGE-CD                                   15255300
MFA-TR*       FROM   CSS_ADDR_FORMATTED                                 15255500
MFA-TR*       WHERE  ADDRESS_ID = :WS-ADDRESS-ID                        15255600
MFA-TR*       WITH UR                                                   15255610
MFA-TR*    END-EXEC.                                                    15255700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI          MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE WS-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE DY-HOUSE-NO           TO RS-HOUSE-NO                 
              MOVE DY-ADDR-PREFIX-1      TO RS-ADDR-PREFIX-1            
              MOVE DY-ADDR-PREFIX-2      TO RS-ADDR-PREFIX-2            
              MOVE DY-STREET-NAME        TO RS-STREET-NAME              
              MOVE DY-STREET-LOCATION-1  TO RS-STREET-LOCATION-1        
              MOVE DY-STREET-LOCATION-2  TO RS-STREET-LOCATION-2        
              MOVE DY-STREET-SUFFIX      TO RS-STREET-SUFFIX            
              MOVE DY-ADDR-SUFFIX        TO RS-ADDR-SUFFIX              
              MOVE DY-ADDRESS-OVERFLOW   TO RS-ADDRESS-OVERFLOW         
              MOVE DY-CARRIER-ROUTE      TO RS-CARRIER-ROUTE            
              MOVE DY-ZIP-CODE           TO RS-ZIP-CODE                 
              MOVE DY-ZIP-CODE-PLUS-FOUR TO RS-ZIP-CODE-PLUS-FOUR       
              MOVE DY-ZIP-CODE-TOKEN     TO RS-ZIP-CODE-TOKEN           
              MOVE DY-ADDR-USAGE-CD      TO RS-ADDR-USAGE-CD            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO RS-HOUSE-NO                 
              MOVE SPACES                TO RS-ADDR-PREFIX-1            
              MOVE SPACES                TO RS-ADDR-PREFIX-2            
              MOVE SPACES                TO RS-STREET-NAME              
              MOVE SPACES                TO RS-STREET-LOCATION-1        
              MOVE SPACES                TO RS-STREET-LOCATION-2        
              MOVE SPACES                TO RS-STREET-SUFFIX            
              MOVE SPACES                TO RS-ADDR-SUFFIX              
              MOVE SPACES                TO RS-ADDRESS-OVERFLOW         
              MOVE SPACES                TO RS-CARRIER-ROUTE            
              MOVE SPACES                TO RS-ZIP-CODE                 
              MOVE SPACES                TO RS-ZIP-CODE-PLUS-FOUR       
              MOVE SPACES                TO RS-ZIP-CODE-TOKEN           
              MOVE SPACES                TO RS-ADDR-USAGE-CD            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15263300
      * 7200-OPEN-UT-CURSOR                                            *15263400
      *     CALLS       9000-SEND-ERROR-RESULT                         *15263500
      *                 9900-SQL-ERROR-ROUTINE                         *15263600
      *                                                                *15263700
      *     CALLED FROM 5000-PROCESS-FETCH-UT                          *15263800
      *                                                                *15263900
      *     OPENS UT-CURSOR                                            *15264000
      ******************************************************************15264200
       7200-OPEN-UT-CURSOR.                                             
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN UT-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15266800
      * 7210-FETCH-UTIL-ENVRNMT                                        *15266900
      *     CALLS       9000-SEND-ERROR-RESULT                         *15267000
      *                 9900-SQL-ERROR-ROUTINE                         *15267100
      *                                                                *15267200
      *     CALLED FROM 5000-PROCESS-FETCH-UT                          *15267300
      *                                                                *15267400
      *     FETCHES ROWS FROM THE TABLE CSS_UTIL_ENVRNMT FOR THE       *15267500
      *     ACCOUNT NO PASSED AS PARAMTER                              *15267600
      ******************************************************************15267700
       7210-FETCH-UTIL-ENVRNMT.                                         
           MOVE '7210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH  UT-CURSOR                                          
              INTO  :UT-CODE-UTIL-TYPE,                                 
                    :UT-IC-NO,                                          
                    :UT-READ-ROUTE,                                     
                    :UT-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15270800
      * 7220-CLOSE-UT-CURSOR                                           *15270900
      *     CALLS       9000-SEND-ERROR-RESULT                         *15271000
      *                 9900-SQL-ERROR-ROUTINE                         *15271100
      *                                                                *15271200
      *     CALLED FROM 2200-BUILD-RESULT                              *15271300
      *                                                                *15271400
      *     CLOSES UT-CURSOR                                           *15271500
      ******************************************************************15271600
       7220-CLOSE-UT-CURSOR.                                            
           MOVE '7220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE  UT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15274100
      * 7300-OPEN-UP-CURSOR                                            *15274200
      *     CALLS       9000-SEND-ERROR-RESULT                         *15274300
      *                 9900-SQL-ERROR-ROUTINE                         *15274400
      *                                                                *15274500
      *     CALLED FROM 2200-BUILD-RESULT                              *15274600
      *                                                                *15274700
      *     OPENS UP-CURSOR                                            *15274800
      ******************************************************************15274900
       7300-OPEN-UP-CURSOR.                                             
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN UP-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
CBSI          MOVE 'CSS_UM_EQUIPMENT'         TO TABLE-2                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-RATE-64                 TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'VERSION-NO-CNTRL'         TO TABLE-ELEMENT-2        
CBSI          MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15277500
      * 7310-FETCH-UP-CURSOR                                           *15277600
      *     CALLS       9000-SEND-ERROR-RESULT                         *15277700
      *                 9900-SQL-ERROR-ROUTINE                         *15277800
      *                                                                *15277900
      *     CALLED FROM 5000-PROCESS-FETCH-UP                          *15278000
      *                                                                *15278100
      *     FETCHES ROWS FROM THE TABLE CSS_UTIL_ENVRNMT FOR THE       *15278200
      *     ACCOUNT NO PASSED AS PARAMTER                              *15278300
      ******************************************************************15278400
       7310-FETCH-UP-CURSOR.                                            
           MOVE '7310' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH  UP-CURSOR                                          
              INTO  :UP-RATE-ITEM-CODE,                                 
                    :UP-CUST-PER-SERVICE,                               
                    :UP-PRICE-PER-SERV,                                 
                    :L9-UM-EQUIP-SHRT-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
CBSI          MOVE 'CSS_UM_EQUIPMENT'         TO TABLE-2                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-RATE-64                 TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'VERSION-NO-CNTRL'         TO TABLE-ELEMENT-2        
CBSI          MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15281500
      * 7320-CLOSE-UP-CURSOR                                          * 15281600
      *     CALLS       9000-SEND-ERROR-RESULT                        * 15281800
      *                 9900-SQL-ERROR-ROUTINE                        * 15282000
      *                                                               * 15282300
      *     CALLED FROM 2200-BUILD-RESULT                             * 15282400
      *                                                               * 15282700
      *     CLOSES UP-CURSOR                                          * 15282800
      ***************************************************************** 15283000
       7320-CLOSE-UP-CURSOR.                                            
           MOVE '7320' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE UP-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
CBSI          MOVE 'CSS_UM_EQUIPMENT'         TO TABLE-2                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-RATE-64                 TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'VERSION-NO-CNTRL'         TO TABLE-ELEMENT-2        
CBSI          MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15286000
      * 7400-OPEN-MN-CURSOR                                            *15286100
      *     CALLS       9000-SEND-ERROR-RESULT                         *15286200
      *                 9900-SQL-ERROR-ROUTINE                         *15286300
      *                                                                *15286400
      *     CALLED FROM 2200-BUILD-RESULT                              *15286500
      *                                                                *15286600
      *     OPENS MN-CURSOR                                            *15286700
      ******************************************************************15286800
       7400-OPEN-MN-CURSOR.                                             
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN MN-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T15612        MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T16512        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
T16512        MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15289200
      * 7410-FETCH-MTRD-ENVRNMT                                        *15289300
      *     CALLS       9000-SEND-ERROR-RESULT                         *15289400
      *                 9900-SQL-ERROR-ROUTINE                         *15289500
      *                                                                *15289600
      *     CALLED FROM 5000-PROCESS-FETCH-UT                          *15289700
      *                                                                *15289800
      *     FETCHES ROWS FROM THE TABLE CSS_MTRD_ENVRNMT FOR THE       *15289900
      *     ACCOUNT NO PASSED AS PARAMTER                              *15290000
      ******************************************************************15290100
       7410-FETCH-MTRD-ENVRNMT.                                         
           MOVE '7410' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH  MN-CURSOR                                          
              INTO  :MN-MTR-REF-NO,                                     
                    :MN-IC-NO,                                          
                    :MN-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   ADD 1 TO WS-MN-COUNT                                 
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
CBSI               MOVE SPACES                TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                   MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
T16512             MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
CBSI               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
T16512             MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2      
CBSI               MOVE 'IC_NO'               TO TABLE-ELEMENT-3        
CBSI               MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15293409
      * 7420-CLOSE-MN-CURSOR                                           *15293500
      *     CALLS       9000-SEND-ERROR-RESULT                         *15293600
      *                 9900-SQL-ERROR-ROUTINE                         *15293700
      *                                                                *15293800
      *     CALLED FROM 5000-PROCESS-FETCH-UT                          *15293900
      *                                                                *15294000
      *     CLOSES MN-CURSOR                                           *15294100
      ******************************************************************15294200
       7420-CLOSE-MN-CURSOR.                                            
           MOVE '7420' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE  MN-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T16512        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'UTIL_TYPE'                TO TABLE-ELEMENT-2        
T16512        MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15299700
      * 7500-SELECT-RATE-ITEM-CODE.                                   * 15299800
      *     CALLS       9000-SEND-ERROR-RESULT                        * 15299900
      *                 9900-SQL-ERROR-ROUTINE                        * 15300000
      *                                                               * 15300300
      *     CALLED FROM 2200-BUILD-RESULT                             * 15300400
      *                                                               * 15300500
      *     SELECT RATE ITEM CODE FROM UT AND CP.                     * 15300600
      ***************************************************************** 15300700
       7500-SELECT-RATE-ITEM-CODE.                                      
           MOVE '7500' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT CP.RATE_ITEM_CODE,                                 
T14863               CIS.CHAR2$DATE(CP.DATE_PLAN_START,'USA'),                  
C33254               CIS.CHAR2$DATE(CP.LAST_BILL_DATE,'USA')                    
              INTO  :WS-RATE-ITEM-CODE,                                 
T14863              :CP-DATE-PLAN-START :WS-NULL-IND-1,                 
C33254              :CP-LAST-BILL-DATE :WS-NULL-IND-3                    
              FROM   CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                    
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO               
                AND  UT.ACCOUNT_NO       = :WS-ACCOUNT-NO               
                AND  UT.RATE_PLAN_NO     = :WS-RATE-64                  
                AND  UT.CODE_UTIL_TYPE   = 'U'                          
                AND  CP.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE            
                AND  CP.IC_NO            = UT.IC_NO                     
                AND  CP.CODE_PLAN_STATUS = :WS-CODE-STATUS              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15301700
MFA-TR*       SELECT CP.RATE_ITEM_CODE,                                 15301800
MFA-TR*              CHAR(CP.DATE_PLAN_START,USA),                      15301900
MFA-TR*              CHAR(CP.LAST_BILL_DATE,USA)                        15301910
MFA-TR*       INTO  :WS-RATE-ITEM-CODE,                                 15302000
MFA-TR*             :CP-DATE-PLAN-START :WS-NULL-IND-1,                 15302100
MFA-TR*             :CP-LAST-BILL-DATE:WS-NULL-IND-3                    15302110
MFA-TR*       FROM   CSS_CUST_PLAN CP,                                  15302200
MFA-TR*              CSS_UTIL_ENVRNMT UT                                15302300
MFA-TR*       WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO               15302400
MFA-TR*         AND  UT.ACCOUNT_NO       = :WS-ACCOUNT-NO               15302500
MFA-TR*         AND  UT.RATE_PLAN_NO     = :WS-RATE-64                  15302600
MFA-TR*         AND  UT.CODE_UTIL_TYPE   = 'U'                          15302700
MFA-TR*         AND  CP.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE            15302800
MFA-TR*         AND  CP.IC_NO            = UT.IC_NO                     15302900
MFA-TR*         AND  CP.CODE_PLAN_STATUS = :WS-CODE-STATUS              15303000
MFA-TR*         WITH UR                                                 15303010
MFA-TR*    END-EXEC.                                                    15303100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
T14863             IF WS-NULL-IND-1 < 0 OR                              
C33254                WS-NULL-IND-3 < 0                                 
T14863                CONTINUE                                          
T14863             ELSE                                                 
C33254                IF AT-LAST-NRML-BILL-NO > 0 AND                   
C33254                   CP-DATE-PLAN-START NOT = CP-LAST-BILL-DATE     
C33254                   MOVE CP-LAST-BILL-DATE TO RS-INSTALL-DATE      
C33254                END-IF                                            
T14863             END-IF                                               
                   MOVE WS-RATE-ITEM-CODE TO RS-RATE-ITEM-CODE          
               WHEN NOT-FOUND                                           
                   MOVE WS-RATE-ITEM-CODE TO RS-RATE-ITEM-CODE          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
CBSI               MOVE SPACES               TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                   MOVE 'CSS_CUST_PLAN'      TO TABLE-1                 
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2         
                   MOVE WS-RATE-64           TO HOSTVAR-ELEMENT-2       
CBSI               MOVE 'CODE_PLAN_STATUS'   TO TABLE-ELEMENT-3         
CBSI               MOVE WS-CODE-STATUS       TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
T14863***************************************************************** 15307000
T14863* 7510-GET-CURRENT-DATE.                                        * 15307100
T14863*     CALLS       9000-SEND-ERROR-RESULT                        * 15307200
T14863*                 9900-SQL-ERROR-ROUTINE                        * 15307300
T14863*                                                               * 15307400
T14863*     CALLED FROM 2200-BUILD-RESULT                             * 15307500
T14863*                                                               * 15307700
T14863*     GETS THE CURRENT DATE.                                    * 15307800
T14863***************************************************************** 15307900
T14863 7510-GET-CURRENT-DATE.                                           
T14863                                                                  
T14863     MOVE '7510'          TO ACTIVE-PARAGRAPH.                    
T14863                                                                  
T14863     MOVE SPACES TO WS-CURRENT-DATE.                              
T14863     EXEC SQL                                                     
T35434        SELECT
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-CURRENT-DATE             
T14863     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15308500
MFA-TR*       SET :WS-CURRENT-DATE = CHAR(CURRENT DATE,USA)             15308800
MFA-TR*    END-EXEC.                                                    15309100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T14863                                                                  
T14863     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T14863                                                                  
T14863     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T14863        NEXT SENTENCE                                             
T14863     ELSE                                                         
T14863        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T14863        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T14863        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T14863     END-IF.                                                      
T14863                                                                  
T14863                                                                  
T14863 7510-EXIT.                                                       
T14863     EXIT.                                                        
                                                                        
C33254***************************************************************** 15312300
C33254* 7520-GET-NUMBER-OF-DAYS.                                      * 15312400
C33254*     CALLS       9000-SEND-ERROR-RESULT                        * 15312500
C33254*                 9900-SQL-ERROR-ROUTINE                        * 15312600
C33254*                                                               * 15312700
C33254*     CALLED FROM 2200-BUILD-RESULT                             * 15312800
C33254*                                                               * 15312900
C33254*     GET THE TOTAL NUMBER OF DAYS FROM WHEN SERVICE STARTED    * 15313000
C33254***************************************************************** 15313100
C33254                                                                  
C33254 7520-GET-NUMBER-OF-DAYS.                                         
C33254                                                                  
C33254     MOVE '7520'          TO ACTIVE-PARAGRAPH.                    
C33254                                                                  
C33254     EXEC SQL                                                     
T35434        SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))-                      
T35434               CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                 :WS-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:WS-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT) ))
            INTO
              :WS-NO-OF-DAYS                 
C33254     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15313700
MFA-TR*       SET    :WS-NO-OF-DAYS =                                   15313800
MFA-TR*              DAYS(DATE(:WS-CURRENT-DATE))-                      15313900
MFA-TR*              DAYS(DATE(:WS-DATE-UTIL-SVC-STRT))                 15314000
MFA-TR*    END-EXEC.                                                    15314100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33254                                                                  
C33254     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33254                                                                  
C33254     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33254        NEXT SENTENCE                                             
C33254     ELSE                                                         
C33254        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
C33254        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C33254                                           ABEND-TABLES           
C33254        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C33254        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C33254        MOVE 'DATE_UTIL_SVC_STRT'       TO TABLE-ELEMENT-2        
C33254        MOVE WS-DATE-UTIL-SVC-STRT      TO HOSTVAR-ELEMENT-2      
C33254        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C33254        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C33254     END-IF.                                                      
C33254 7520-EXIT.                                                       
C33254     EXIT.                                                        
                                                                        
      ***************************************************************** 15316300
      * 7600-SELECT-VERSION-NO-CNTRL.                                 * 15316400
      *     CALLS       9000-SEND-ERROR-RESULT                        * 15316500
      *                 9900-SQL-ERROR-ROUTINE                        * 15316600
      *                                                               * 15316700
      *     CALLED FROM 2200-BUILD-RESULT                             * 15316800
      *                                                               * 15316900
      *     SELECT VERSION NO CNTRL FROM CSS_RATE_CREATOR.            * 15317000
      ***************************************************************** 15317100
       7600-SELECT-VERSION-NO-CNTRL.                                    
           MOVE '7600' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
              INTO  :RT-VERSION-NO-CNTRL :WS-NULL-IND                   
              FROM   CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
              WHERE  CODE_UTIL_TYPE    = 'U'                            
                AND  RATE_PLAN_NO      = :WS-RATE-64                    
                AND  CODE_STATUS       = :WS-CODE-STATUS                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15317500
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                              15317600
MFA-TR*       INTO  :RT-VERSION-NO-CNTRL :WS-NULL-IND                   15317700
MFA-TR*       FROM   CSS_RATE_CREATOR                                   15317800
MFA-TR*       WHERE  CODE_UTIL_TYPE    = 'U'                            15317900
MFA-TR*         AND  RATE_PLAN_NO      = :WS-RATE-64                    15318000
MFA-TR*         AND  CODE_STATUS       = :WS-CODE-STATUS                15318100
MFA-TR*         WITH UR                                                 15318110
MFA-TR*    END-EXEC.                                                    15318200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_RATE_CREATOR'   TO TABLE-1                      
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1              
              MOVE 'U'                  TO HOSTVAR-ELEMENT-1            
              MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2              
              MOVE WS-RATE-64           TO HOSTVAR-ELEMENT-2            
              MOVE 'CODE_STATUS'        TO TABLE-ELEMENT-3              
              MOVE WS-CODE-STATUS       TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              IF WS-NULL-IND < 0                                        
                 MOVE ZERO                TO WS-VERSION-NO-CNTRL        
              ELSE                                                      
                 MOVE RT-VERSION-NO-CNTRL TO WS-VERSION-NO-CNTRL        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE ZERO                   TO WS-VERSION-NO-CNTRL        
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15321700
      * 7700-SELECT-PRICE-PER-SERV                                    * 15321800
      *     CALLS       9000-SEND-ERROR-RESULT                        * 15321900
      *                 9900-SQL-ERROR-ROUTINE                        * 15322000
      *                                                               * 15322100
      *     CALLED FROM 2200-BUILD-RESULT                             * 15322200
      *                                                               * 15322300
      *     SELECT PRICE PER SERVICE FROM CSS_UNMTR_PLAN.             * 15322400
      ***************************************************************** 15322500
       7700-SELECT-PRICE-PER-SERV.                                      
           MOVE '7700' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT PRICE_PER_SERV                                     
              INTO  :RS-PRICE-PER-SERV                                  
              FROM   CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                       
              WHERE  CODE_UTIL_TYPE    = 'U'                            
                AND  RATE_PLAN_NO      = :WS-RATE-64                    
                AND  VERSION_NO_CNTRL  = :WS-VERSION-NO-CNTRL           
                AND  RATE_ITEM_CODE    = :WS-RATE-ITEM-CODE             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15322900
MFA-TR*       SELECT PRICE_PER_SERV                                     15323000
MFA-TR*       INTO  :RS-PRICE-PER-SERV                                  15323100
MFA-TR*       FROM   CSS_UNMTR_PLAN                                     15323200
MFA-TR*       WHERE  CODE_UTIL_TYPE    = 'U'                            15323300
MFA-TR*         AND  RATE_PLAN_NO      = :WS-RATE-64                    15323400
MFA-TR*         AND  VERSION_NO_CNTRL  = :WS-VERSION-NO-CNTRL           15323500
MFA-TR*         AND  RATE_ITEM_CODE    = :WS-RATE-ITEM-CODE             15323600
MFA-TR*         WITH UR                                                 15323610
MFA-TR*    END-EXEC.                                                    15323700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_UNMTR_PLAN'     TO TABLE-1                      
              MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-1              
              MOVE WS-RATE-64           TO HOSTVAR-ELEMENT-1            
              MOVE 'VERSION_NO_CNTRL'   TO TABLE-ELEMENT-2              
              MOVE WS-VERSION-NO-CNTRL  TO HOSTVAR-ELEMENT-2            
              MOVE 'RATE_ITEM_CODE'     TO TABLE-ELEMENT-3              
              MOVE WS-RATE-ITEM-CODE    TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33254******************************************************************15326000
C33254*7790-SELECT-CUST-PREM-HIST                                      *15326100
C33254*                                                                *15326200
C33254*SELECT DATE_UTIL_SVC_STRT FROM CSS_CUST_PREM_HIST               *15326300
C33254******************************************************************15326400
C33254 7790-SELECT-CUST-PREM-HIST.                                      
C33254     MOVE '7790' TO ACTIVE-PARAGRAPH                              
C33254                                                                  
C33254     EXEC SQL                                                     
C33254        SELECT CIS.CHAR2$DATE(DATE_UTIL_SVC_STRT,'USA')                   
C33254          INTO :CH-DATE-UTIL-SVC-STRT                             
C33254          FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                   
C33254         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
C33254           AND PREMISE_NO = :WS-PREMISE-NO                        
T35434                                                           
C33254     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15326800
MFA-TR*       SELECT CHAR(DATE_UTIL_SVC_STRT,USA)                       15326900
MFA-TR*         INTO :CH-DATE-UTIL-SVC-STRT                             15327000
MFA-TR*         FROM CSS_CUST_PREM_HIST                                 15327100
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        15327200
MFA-TR*          AND PREMISE_NO = :WS-PREMISE-NO                        15327300
MFA-TR*        WITH UR                                                  15327400
MFA-TR*    END-EXEC.                                                    15327500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33254                                                                  
C33254     MOVE CH-DATE-UTIL-SVC-STRT TO WS-DATE-UTIL-SVC-STRT          
C33254     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33254                                                                  
C33254     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33254        NEXT SENTENCE                                             
C33254     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C33254        MOVE WS-CURRENT-DATE       TO WS-DATE-UTIL-SVC-STRT       
C33254     ELSE                                                         
C33254        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C33254        MOVE 'SELECT'              TO ABEND-FUNCTION              
C33254        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C33254                                      ABEND-TABLES                
C33254        MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                     
C33254        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C33254        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C33254        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
C33254        MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
C33254        MOVE 'DATE_UTIL_SVC_STRT'  TO TABLE-ELEMENT-3             
C33254        MOVE CH-DATE-UTIL-SVC-STRT TO HOSTVAR-ELEMENT-3           
C33254        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C33254        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C33254     END-IF
           END-IF.                                                      
C33254 7790-EXIT.                                                       
C33254     EXIT.                                                        
                                                                        
      ******************************************************************15330002
      * 7800-SELECT-ACCOUNT-TYPE                                       *15330003
      *     CALLS       9000-SEND-ERROR-RESULT                         *15330004
      *                 9900-SQL-ERROR-ROUTINE                         *15330005
      *                                                                *15330006
      *     CALLED FROM 2200-BUILD-RESULT                              *15330007
      *                                                                *15330008
      *     FETCH PREMISE TYPE FROM CSS_ACCOUNT AND CSS_ACCOUNT_TYPE   *15330009
      ******************************************************************15330010
       7800-SELECT-ACCOUNT-TYPE.                                        
           MOVE '7800'           TO ACTIVE-PARAGRAPH.                   
                                                                        
           EXEC SQL                                                     
TP5843         SELECT AT.ACCOUNT_TYPE_CODE,                             
C31591                CIS.CHAR2$DATE(AT.DATE_BILL_DAY_00,'USA'),                
C33254                AT.LAST_NRML_BILL_NO,                             
C33254                AT.CODE_ACCT_STAT                                 
               INTO  :RS-ACCOUNT-TYPE-DESC,                             
C31581               :AT-DATE-BILL-DAY-00 :WS-NULL-IND-2,                
C33254               :AT-LAST-NRML-BILL-NO,                             
C33254               :AT-CODE-ACCT-STAT                                 
               FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO        = :WS-ACCOUNT-NO             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15330014
MFA-TR*        SELECT AT.ACCOUNT_TYPE_CODE,                             15330015
MFA-TR*               CHAR(AT.DATE_BILL_DAY_00,USA),                    15330016
MFA-TR*               AT.LAST_NRML_BILL_NO,                             15330017
MFA-TR*               AT.CODE_ACCT_STAT                                 15330018
MFA-TR*        INTO  :RS-ACCOUNT-TYPE-DESC,                             15330019
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-IND-2,                15330020
MFA-TR*              :AT-LAST-NRML-BILL-NO,                             15330030
MFA-TR*              :AT-CODE-ACCT-STAT                                 15330031
MFA-TR*        FROM   CSS_ACCOUNT AT                                    15330032
MFA-TR*        WHERE  AT.ACCOUNT_NO        = :WS-ACCOUNT-NO             15330033
MFA-TR*        WITH UR                                                  15330034
MFA-TR*    END-EXEC.                                                    15330035

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C31591     EVALUATE WS-ACTIVE-RETURN-CODE                               
C31591         WHEN SUCCESSFUL-CALL                                     
C31591             IF WS-NULL-IND-2 < 0                                 
C31591               MOVE SPACES TO RS-LAST-BILL-DATE                   
C31591             ELSE                                                 
C33254              PERFORM 7820-BILLING-HDR-EXISTS THRU 7820-EXIT      
C33254              EVALUATE TRUE                                       
C33254               WHEN ACCT-HAS-BILLED AND NOT-BILLED-SUBD           
C33254                  PERFORM 7520-GET-NUMBER-OF-DAYS THRU 7520-EXIT  
C33254                  IF WS-NO-OF-DAYS  > 90                          
C33254                    MOVE AT-DATE-BILL-DAY-00 TO RS-LAST-BILL-DATE 
C33254                                                RS-MSG-DISPLAY-DT 
C33254                    MOVE '2'         TO RS-LIGHT-NOT-BILLED       
C33254                  ELSE                                            
C33254                    MOVE WS-CURRENT-DATE TO RS-LAST-BILL-DATE     
C33254                                            RS-MSG-DISPLAY-DT     
C33254                    MOVE '2' TO RS-LIGHT-NOT-BILLED               
C33254                  END-IF                                          
C33254                                                                  
C33254               WHEN ACCT-NOT-BILLED                               
C33254                 MOVE WS-CURRENT-DATE TO RS-LAST-BILL-DATE        
C33254                 IF AT-CODE-ACCT-STAT = 'A'                       
C33254                  MOVE WS-DATE-UTIL-SVC-STRT TO RS-MSG-DISPLAY-DT 
C33254                  MOVE '2' TO RS-LIGHT-NOT-BILLED                 
C33254                 END-IF                                           
C33254                 IF AT-CODE-ACCT-STAT = 'P'                       
C33254                  MOVE WS-CURRENT-DATE TO RS-MSG-DISPLAY-DT       
C33254                 END-IF                                           
C31951               WHEN ACCT-HAS-BILLED AND HAS-BILLED-SUBD           
C31591                  MOVE AT-DATE-BILL-DAY-00 TO RS-LAST-BILL-DATE   
C33254                                              RS-MSG-DISPLAY-DT   
C33254                  MOVE '1' TO RS-LIGHT-NOT-BILLED                 
C31951               END-EVALUATE                                       
C31591             END-IF                                               
C31591         WHEN NOT-FOUND                                           
C31591             MOVE SPACES TO RS-LAST-BILL-DATE                     
C31591         WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
CBSI               MOVE SPACES                TO ABEND-SQL-PREDICATES   
CBSI                                                  ABEND-TABLES      
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C31591     END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-BILLING-HDR.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BI.ACCOUNT_NO                                      
              INTO  :BI-ACCOUNT-NO                                      
              FROM   CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                  
                     CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
              WHERE  BI.ACCOUNT_NO  = :WS-ACCOUNT-NO                    
                AND  BI.DATE_BILLED IS NOT NULL                         
                AND  BI.ACCOUNT_NO = BG.ACCOUNT_NO                      
                AND  BI.BILL_NO = BG.BILL_NO                            
                AND  BG.CODE_UTIL_TYPE = 'U'                            
                AND  BG.RATE_PLAN_NO = '064'                            
                                                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15332918
MFA-TR*       SELECT BI.ACCOUNT_NO                                      15332919
MFA-TR*       INTO  :BI-ACCOUNT-NO                                      15332920
MFA-TR*       FROM   CSS_BILLING_HDR BI,                                15332930
MFA-TR*              CSS_BILLING_DET BG                                 15332940
MFA-TR*       WHERE  BI.ACCOUNT_NO  = :WS-ACCOUNT-NO                    15332950
MFA-TR*         AND  BI.DATE_BILLED IS NOT NULL                         15332960
MFA-TR*         AND  BI.ACCOUNT_NO = BG.ACCOUNT_NO                      15332970
MFA-TR*         AND  BI.BILL_NO = BG.BILL_NO                            15332980
MFA-TR*         AND  BG.CODE_UTIL_TYPE = 'U'                            15332990
MFA-TR*         AND  BG.RATE_PLAN_NO = '064'                            15333000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   15333100
MFA-TR*       WITH UR                                                   15333200
MFA-TR*    END-EXEC.                                                    15333201

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_BILLING_HDR'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33254******************************************************************15333240
C33254* 7820-BILLING-HDR-EXISTS                                        *15333250
C33254*                                                                *15333260
C33254*     CALLS             9000-SEND-ERROR-RESULT                   *15333270
C33254*                       9900-SQL-ERROR-ROUTINE                   *15333280
C33254*                       7830-BILLING-SUBDIV                  *    15333290
C33254*                                                                *15333300
C33254*     CALLED FROM       7800-SELECT-ACCOUNT-TYPE                 *15333400
C33254*                                                                *15333500
C33254*     FETCHES THE ACCOUNT NUMBER AND SETS A FLAG IF THE ACCOUNT  *15333600
C33254*     HAS EVER BILLED BEFORE.                                    *15333700
C33254******************************************************************15333800
C33254                                                                  
C33254 7820-BILLING-HDR-EXISTS.                                         
C33254                                                                  
C33254     MOVE '7820' TO ACTIVE-PARAGRAPH                              
C33254                                                                  
C33254     EXEC SQL                                                     
C33254        SELECT TOP(1) ACCOUNT_NO                                         
C33254        INTO   :BI-ACCOUNT-NO                                     
C33254        FROM  CSS_BILLING_HDR WITH(READUNCOMMITTED)                       
C33254        WHERE ACCOUNT_NO =  :WS-ACCOUNT-NO                        
C33254          AND DATE_BILLED IS NOT NULL                             
C33254                                           
T35434                                                           
C33254     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15334400
MFA-TR*       SELECT ACCOUNT_NO                                         15334500
MFA-TR*       INTO   :BI-ACCOUNT-NO                                     15334600
MFA-TR*       FROM  CSS_BILLING_HDR                                     15334700
MFA-TR*       WHERE ACCOUNT_NO =  :WS-ACCOUNT-NO                        15334800
MFA-TR*         AND DATE_BILLED IS NOT NULL                             15334900
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   15335000
MFA-TR*       WITH UR                                                   15335100
MFA-TR*    END-EXEC.                                                    15335200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33254                                                                  
C33254     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33254                                                                  
C33254     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33254        WHEN SUCCESSFUL-CALL                                      
C33254            MOVE 'Y' TO ACCT-BILLED-SW                            
C33254            PERFORM 7830-BILLING-SUBDIV THRU 7830-EXIT            
C33254        WHEN NOT-FOUND                                            
C33254            MOVE 'N' TO ACCT-BILLED-SW                            
C33254            MOVE 'N' TO ACCT-BILLED-SUBD-SW                       
C33254        WHEN OTHER                                                
C33254            MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
C33254            MOVE 'SELECT'          TO ABEND-FUNCTION              
C33254            MOVE SPACES            TO ABEND-SQL-PREDICATES        
C33254                                      ABEND-TABLES                
C33254            MOVE 'CSS_BILLING_HDR' TO TABLE-1                     
C33254            MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
C33254            MOVE WS-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
C33254            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
C33254            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
C33254     END-EVALUATE.                                                
C33254                                                                  
C33254 7820-EXIT.                                                       
C33254     EXIT.                                                        
                                                                        
                                                                        
                                                                        
C33254******************************************************************15338000
C33254* 7830-BILLING-SUBDIV                                        *    15338100
C33254*                                                                *15338200
C33254*     CALLS             9000-SEND-ERROR-RESULT                   *15338300
C33254*                       9900-SQL-ERROR-ROUTINE                   *15338400
C33254*                                                                *15338500
C33254*     CALLED FROM       7820-BILLING-HDR-EXISTS                  *15338600
C33254*                                                                *15338700
C33254*     FETCHES THE ACCOUNT NUMBER AND SETS A FLAG IF THE ACCOUNT  *15338800
C33254*     IS CURRENTLY BILLING FOR SUBDIVISION LIGHTING.             *15338900
C33254******************************************************************15339000
C33254                                                                  
C33254 7830-BILLING-SUBDIV.                                             
C33254                                                                  
C33254     MOVE '7830' TO ACTIVE-PARAGRAPH                              
C33254                                                                  
C33254     EXEC SQL                                                     
C33254        SELECT TOP(1) BI.ACCOUNT_NO                                      
C33254        INTO   :BI-ACCOUNT-NO                                     
C33254        FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                    
C33254             CSS_BILLING_DET BG WITH(READUNCOMMITTED),                    
C33254             CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
C33254        WHERE BI.ACCOUNT_NO =  :WS-ACCOUNT-NO                     
C33254          AND BI.DATE_BILLED IS NOT NULL                          
C33254          AND BI.ACCOUNT_NO = BG.ACCOUNT_NO                       
C33254          AND BG.ACCOUNT_NO = AT.ACCOUNT_NO                       
C33254          AND BG.BILL_NO = AT.LAST_NRML_BILL_NO                   
C33254          AND BI.BILL_NO = BG.BILL_NO                             
C33254          AND BG.CODE_UTIL_TYPE = 'U'                             
C33254          AND BG.RATE_PLAN_NO = '064'                             
C33254                                           
T35434                                                           
C33254     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15339600
MFA-TR*       SELECT BI.ACCOUNT_NO                                      15339700
MFA-TR*       INTO   :BI-ACCOUNT-NO                                     15339800
MFA-TR*       FROM CSS_BILLING_HDR BI,                                  15339900
MFA-TR*            CSS_BILLING_DET BG,                                  15340000
MFA-TR*            CSS_ACCOUNT AT                                       15340100
MFA-TR*       WHERE BI.ACCOUNT_NO =  :WS-ACCOUNT-NO                     15340200
MFA-TR*         AND BI.DATE_BILLED IS NOT NULL                          15340300
MFA-TR*         AND BI.ACCOUNT_NO = BG.ACCOUNT_NO                       15340400
MFA-TR*         AND BG.ACCOUNT_NO = AT.ACCOUNT_NO                       15340500
MFA-TR*         AND BG.BILL_NO = AT.LAST_NRML_BILL_NO                   15340600
MFA-TR*         AND BI.BILL_NO = BG.BILL_NO                             15340700
MFA-TR*         AND BG.CODE_UTIL_TYPE = 'U'                             15340800
MFA-TR*         AND BG.RATE_PLAN_NO = '064'                             15340900
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   15341000
MFA-TR*       WITH UR                                                   15341100
MFA-TR*    END-EXEC.                                                    15341200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33254                                                                  
C33254     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33254                                                                  
C33254     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33254       WHEN SUCCESSFUL-CALL                                       
C33254           MOVE 'Y' TO ACCT-BILLED-SUBD-SW                        
C33254       WHEN NOT-FOUND                                             
C33254           MOVE 'N' TO ACCT-BILLED-SUBD-SW                        
C33254       WHEN OTHER                                                 
C33254           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
C33254           MOVE 'SELECT'             TO ABEND-FUNCTION            
C33254           MOVE SPACES               TO ABEND-SQL-PREDICATES      
C33254                                        ABEND-TABLES              
C33254           MOVE 'CSS_BILLING_HDR'    TO TABLE-1                   
C33254           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
C33254           MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
C33254           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
C33254           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
C33254     END-EVALUATE.                                                
C33254                                                                  
C33254 7830-EXIT.                                                       
C33254     EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************15343701
      * 7900-SELECT-READ-ROUTE                                         *15343702
      *     CALLS       9000-SEND-ERROR-RESULT                         *15343703
      *                 9900-SQL-ERROR-ROUTINE                         *15343704
      *                                                                *15343705
      *     CALLED FROM 2200-BUILD-RESULT                              *15343706
      *                                                                *15343707
      *     SELECT METER READ ROUTE FROM UTILITY ENVIRONMENT TABLE     *15343708
      ******************************************************************15343709
       7900-SELECT-READ-ROUTE.                                          
           MOVE '7900' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT MAX(READ_ROUTE)                                    
                INTO :UT-READ-ROUTE :WS-NULL-IND                         
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15343713
MFA-TR*       SELECT MAX(READ_ROUTE)                                    15343714
MFA-TR*         INTO :UT-READ-ROUTE:WS-NULL-IND                         15343715
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   15343716
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        15343717
MFA-TR*        WITH UR                                                  15343718
MFA-TR*    END-EXEC.                                                    15343719

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             AND WS-NULL-IND >= 0                                       
              MOVE UT-READ-ROUTE TO RS-READ-ROUTE                       
           ELSE                                                         
              MOVE SPACES TO RS-READ-ROUTE                              
TP8615                       RS-READ-CYCLE                              
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************15343749
      * 7950-SELECT-READ-CYCLE                                         *15343750
      *     CALLS       9000-SEND-ERROR-RESULT                         *15343751
      *                 9900-SQL-ERROR-ROUTINE                         *15343752
      *                                                                *15343753
      *     CALLED FROM 2200-BUILD-RESULT                              *15343754
      *                                                                *15343755
      *     SELECT METER READ CYCLE FROM UTILITY ENVIRONMENT TABLE     *15343756
TP8615*     THE READ CYCLE NEEDS TO BE RETRIEVED SEPARATELY FROM THE   *15343757
TP8615*     READ ROUTE DUE TO THE USE OF MAX.  THE MAXIMUM READ ROUTE  *15343758
TP8615*     FOR AN ACCOUNT NEEDS TO BE SELECTED AND THEN THE MAXIMUM   *15343759
TP8615*     READ CYCLE FOR THAT ACCOUNT WITH THAT MAX READ ROUTE NEEDS *15343760
TP8615*     TO BE RETRIEVED.                                           *15343761
      ******************************************************************15343762
TP8615 7950-SELECT-READ-CYCLE.                                          
           MOVE '7950' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
              SELECT MAX(READ_CYCLE)                                    
                INTO :UT-READ-CYCLE :WS-NULL-IND                         
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND READ_ROUTE = :UT-READ-ROUTE                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15343766
MFA-TR*       SELECT MAX(READ_CYCLE)                                    15343767
MFA-TR*         INTO :UT-READ-CYCLE:WS-NULL-IND                         15343768
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   15343769
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        15343770
MFA-TR*          AND READ_ROUTE = :UT-READ-ROUTE                        15343780
MFA-TR*          WITH UR                                                15343781
MFA-TR*    END-EXEC.                                                    15343782

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'READ ROUTE'         TO TABLE-ELEMENT-2              
              MOVE UT-READ-ROUTE        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             AND WS-NULL-IND >= 0                                       
              MOVE UT-READ-CYCLE TO RS-READ-CYCLE                       
           ELSE                                                         
              MOVE SPACES TO RS-READ-CYCLE                              
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 15343822
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 15343823
      ***************************************************************** 15343824
           EXEC SQL                                                     15343825
               INCLUDE CPDSP300                                         15343826
           END-EXEC.                                                    15343827
                                                                        
      ***************************************************************** 15343829
      *     END PROGRAM COPYLIB  *                                      15343830
      ***************************************************************** 15343831
CVT999*    COPY CPD00302.                                               15343832
                                                                        
REARCH******************************************************************15350100
REARCH* 8100-SEND-RESULT                                               *15350200
REARCH******************************************************************15350300
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02075_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,DATAWINDOW_ID                                             
CVT000       ,ADDRESS_ID                                                
CVT000       ,HOUSE_NO                                                  
CVT000       ,ADDR_PREFIX_1                                             
CVT000       ,ADDR_PREFIX_2                                             
CVT000       ,STREET_NAME                                               
CVT000       ,STREET_LOCATION_1                                         
CVT000       ,STREET_LOCATION_2                                         
CVT000       ,STREET_SUFFIX                                             
CVT000       ,ADDR_SUFFIX                                               
CVT000       ,ADDRESS_OVERFLOW                                          
CVT000       ,CARRIER_ROUTE                                             
CVT000       ,ZIP_CODE                                                  
CVT000       ,ZIP_CODE_PLUS_FOUR                                        
CVT000       ,ZIP_CODE_TOKEN                                            
CVT000       ,LOCAL_OFFICE                                              
CVT000       ,COMPANY_NO                                                
CVT000       ,BLOCK                                                     
CVT000       ,COMPLEX_NAME                                              
CVT000       ,COMPLEX_TYPE                                              
CVT000       ,COUNTY                                                    
CVT000       ,LIGHT_CODE                                                
CVT000       ,LOCATOR_ID                                                
CVT000       ,LOT                                                       
CVT000       ,PREMISE_DESC                                              
CVT000       ,PERSONAL_CNTCT_CD                                         
CVT000       ,REVENUE_PROTECTION                                        
CVT000       ,SUBDIVISION_ID                                            
CVT000       ,CITY_GATE_ID                                              
CVT000       ,GAS_LEAK_SURVEY_DT                                        
CVT000       ,GAS_LK_SURVEY_FREQ                                        
CVT000       ,ADDR_USAGE_CD                                             
CVT000       ,REV_DISTRICT_CD                                           
CVT000       ,ACCOUNT_TYPE_DESC                                         
CVT000       ,READ_ROUTE                                                
CVT000       ,RATE_ITEM_CODE                                            
CVT000       ,PRICE_PER_SERV                                            
CVT000       ,B_UTIL_TYPE                                               
CVT000       ,B_READ_ROUTE                                              
CVT000       ,B_RATE_PLAN_NO                                            
CVT000       ,B_METER_IND                                               
CVT000       ,C_RATE_ITEM_CODE                                          
CVT000       ,C_PRICE_PER_SERV                                          
CVT000       ,C_CUST_PER_SERVICE                                        
CVT000       ,C_EQUIP_DESC                                              
CVT000       ,READ_CYCLE                                                
CVT000       ,INSTALL_DATE                                              
CVT000       ,LAST_BILL_DT                                              
CVT000       ,NO_LIGHT                                                  
CVT000       ,DISPLAY_DT                                                
C35979       ,CROSS_STREET_1                                            
C35979       ,CROSS_STREET_2                                            
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-DATAWINDOW-ID                                         
CVT000       ,:RS-ADDRESS-ID                                            
CVT000       ,:RS-HOUSE-NO                                              
CVT000       ,:RS-ADDR-PREFIX-1                                         
CVT000       ,:RS-ADDR-PREFIX-2                                         
CVT000       ,:RS-STREET-NAME                                           
CVT000       ,:RS-STREET-LOCATION-1                                     
CVT000       ,:RS-STREET-LOCATION-2                                     
CVT000       ,:RS-STREET-SUFFIX                                         
CVT000       ,:RS-ADDR-SUFFIX                                           
CVT000       ,:RS-ADDRESS-OVERFLOW                                      
CVT000       ,:RS-CARRIER-ROUTE                                         
CVT000       ,:RS-ZIP-CODE                                              
CVT000       ,:RS-ZIP-CODE-PLUS-FOUR                                    
CVT000       ,:RS-ZIP-CODE-TOKEN                                        
CVT000       ,:RS-LOCAL-OFFICE                                          
CVT000       ,:RS-COMPANY-NO                                            
CVT000       ,:RS-BLOCK                                                 
CVT000       ,:RS-COMPLEX-NAME                                          
CVT000       ,:RS-COMPLEX-TYPE                                          
CVT000       ,:RS-COUNTY                                                
CVT000       ,:RS-LIGHT-CODE                                            
CVT000       ,:RS-LOCATOR-ID                                            
CVT000       ,:RS-LOT                                                   
CVT000       ,:RS-PREMISE-DESC                                          
CVT000       ,:RS-PERSONAL-CNTCT-CD                                     
CVT000       ,:RS-REVENUE-PROTECTION                                    
CVT000       ,:RS-SUBDIVISION-ID                                        
CVT000       ,:RS-CITY-GATE-ID                                          
CVT000       ,:RS-GAS-LEAK-SURVEY-DT                                    
CVT000       ,:RS-GAS-LK-SURVEY-FREQ                                    
CVT000       ,:RS-ADDR-USAGE-CD                                         
CVT000       ,:RS-REV-DISTRICT-CD                                       
CVT000       ,:RS-ACCOUNT-TYPE-DESC                                     
CVT000       ,:RS-READ-ROUTE                                            
CVT000       ,:RS-RATE-ITEM-CODE                                        
CVT000       ,:RS-PRICE-PER-SERV                                        
CVT000       ,:RS-B-UTIL-TYPE                                           
CVT000       ,:RS-B-READ-ROUTE                                          
CVT000       ,:RS-B-RATE-PLAN-NO                                        
CVT000       ,:RS-B-METER-IND                                           
CVT000       ,:RS-C-RATE-ITEM-CODE                                      
CVT000       ,:RS-C-PRICE-PER-SERV                                      
CVT000       ,:RS-C-CUST-PER-SERVICE                                    
CVT000       ,:RS-C-EQUIP-SHRT-DESC                                     
CVT000       ,:RS-READ-CYCLE                                            
CVT000       ,:RS-INSTALL-DATE                                          
CVT000       ,:RS-LAST-BILL-DATE                                        
CVT000       ,:RS-LIGHT-NOT-BILLED                                      
CVT000       ,:RS-MSG-DISPLAY-DT                                        
C35979       ,:RS-CROSS-STREET-1                                        
C35979       ,:RS-CROSS-STREET-2                                        
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     15350500
MFA-TR*      INSERT INTO SESSION.CSR02075_R1                            15350600
MFA-TR*      (                                                          15350700
MFA-TR*       RETURN_CODE                                               15350800
MFA-TR*      ,DATAWINDOW_ID                                             15350900
MFA-TR*      ,ADDRESS_ID                                                15351000
MFA-TR*      ,HOUSE_NO                                                  15351100
MFA-TR*      ,ADDR_PREFIX_1                                             15351200
MFA-TR*      ,ADDR_PREFIX_2                                             15351300
MFA-TR*      ,STREET_NAME                                               15351400
MFA-TR*      ,STREET_LOCATION_1                                         15351500
MFA-TR*      ,STREET_LOCATION_2                                         15351600
MFA-TR*      ,STREET_SUFFIX                                             15351700
MFA-TR*      ,ADDR_SUFFIX                                               15351800
MFA-TR*      ,ADDRESS_OVERFLOW                                          15351900
MFA-TR*      ,CARRIER_ROUTE                                             15352000
MFA-TR*      ,ZIP_CODE                                                  15352100
MFA-TR*      ,ZIP_CODE_PLUS_FOUR                                        15352200
MFA-TR*      ,ZIP_CODE_TOKEN                                            15352300
MFA-TR*      ,LOCAL_OFFICE                                              15352400
MFA-TR*      ,COMPANY_NO                                                15352500
MFA-TR*      ,BLOCK                                                     15352600
MFA-TR*      ,COMPLEX_NAME                                              15352700
MFA-TR*      ,COMPLEX_TYPE                                              15352800
MFA-TR*      ,COUNTY                                                    15352900
MFA-TR*      ,LIGHT_CODE                                                15353000
MFA-TR*      ,LOCATOR_ID                                                15353100
MFA-TR*      ,LOT                                                       15353200
MFA-TR*      ,PREMISE_DESC                                              15353300
MFA-TR*      ,PERSONAL_CNTCT_CD                                         15353400
MFA-TR*      ,REVENUE_PROTECTION                                        15353500
MFA-TR*      ,SUBDIVISION_ID                                            15353600
MFA-TR*      ,CITY_GATE_ID                                              15353700
MFA-TR*      ,GAS_LEAK_SURVEY_DT                                        15353800
MFA-TR*      ,GAS_LK_SURVEY_FREQ                                        15353900
MFA-TR*      ,ADDR_USAGE_CD                                             15354000
MFA-TR*      ,REV_DISTRICT_CD                                           15354100
MFA-TR*      ,ACCOUNT_TYPE_DESC                                         15354200
MFA-TR*      ,READ_ROUTE                                                15354300
MFA-TR*      ,RATE_ITEM_CODE                                            15354400
MFA-TR*      ,PRICE_PER_SERV                                            15354500
MFA-TR*      ,B_UTIL_TYPE                                               15354600
MFA-TR*      ,B_READ_ROUTE                                              15354700
MFA-TR*      ,B_RATE_PLAN_NO                                            15354800
MFA-TR*      ,B_METER_IND                                               15354900
MFA-TR*      ,C_RATE_ITEM_CODE                                          15355000
MFA-TR*      ,C_PRICE_PER_SERV                                          15355100
MFA-TR*      ,C_CUST_PER_SERVICE                                        15355200
MFA-TR*      ,C_EQUIP_DESC                                              15355300
MFA-TR*      ,READ_CYCLE                                                15355400
MFA-TR*      ,INSTALL_DATE                                              15355500
MFA-TR*      ,LAST_BILL_DT                                              15355600
MFA-TR*      ,NO_LIGHT                                                  15355700
MFA-TR*      ,DISPLAY_DT                                                15355800
MFA-TR*      ,CROSS_STREET_1                                            15355900
MFA-TR*      ,CROSS_STREET_2                                            15356000
MFA-TR*      )                                                          15356100
MFA-TR*      VALUES                                                     15356200
MFA-TR*      (                                                          15356300
MFA-TR*       :RS-RETURN-CODE                                           15356400
MFA-TR*      ,:RS-DATAWINDOW-ID                                         15356500
MFA-TR*      ,:RS-ADDRESS-ID                                            15356600
MFA-TR*      ,:RS-HOUSE-NO                                              15356700
MFA-TR*      ,:RS-ADDR-PREFIX-1                                         15356800
MFA-TR*      ,:RS-ADDR-PREFIX-2                                         15356900
MFA-TR*      ,:RS-STREET-NAME                                           15357000
MFA-TR*      ,:RS-STREET-LOCATION-1                                     15357100
MFA-TR*      ,:RS-STREET-LOCATION-2                                     15357200
MFA-TR*      ,:RS-STREET-SUFFIX                                         15357300
MFA-TR*      ,:RS-ADDR-SUFFIX                                           15357400
MFA-TR*      ,:RS-ADDRESS-OVERFLOW                                      15357500
MFA-TR*      ,:RS-CARRIER-ROUTE                                         15357600
MFA-TR*      ,:RS-ZIP-CODE                                              15357700
MFA-TR*      ,:RS-ZIP-CODE-PLUS-FOUR                                    15357800
MFA-TR*      ,:RS-ZIP-CODE-TOKEN                                        15357900
MFA-TR*      ,:RS-LOCAL-OFFICE                                          15358000
MFA-TR*      ,:RS-COMPANY-NO                                            15358100
MFA-TR*      ,:RS-BLOCK                                                 15358200
MFA-TR*      ,:RS-COMPLEX-NAME                                          15358300
MFA-TR*      ,:RS-COMPLEX-TYPE                                          15358400
MFA-TR*      ,:RS-COUNTY                                                15358500
MFA-TR*      ,:RS-LIGHT-CODE                                            15358600
MFA-TR*      ,:RS-LOCATOR-ID                                            15358700
MFA-TR*      ,:RS-LOT                                                   15358800
MFA-TR*      ,:RS-PREMISE-DESC                                          15358900
MFA-TR*      ,:RS-PERSONAL-CNTCT-CD                                     15359000
MFA-TR*      ,:RS-REVENUE-PROTECTION                                    15359100
MFA-TR*      ,:RS-SUBDIVISION-ID                                        15359200
MFA-TR*      ,:RS-CITY-GATE-ID                                          15359300
MFA-TR*      ,:RS-GAS-LEAK-SURVEY-DT                                    15359400
MFA-TR*      ,:RS-GAS-LK-SURVEY-FREQ                                    15359500
MFA-TR*      ,:RS-ADDR-USAGE-CD                                         15359600
MFA-TR*      ,:RS-REV-DISTRICT-CD                                       15359700
MFA-TR*      ,:RS-ACCOUNT-TYPE-DESC                                     15359800
MFA-TR*      ,:RS-READ-ROUTE                                            15359900
MFA-TR*      ,:RS-RATE-ITEM-CODE                                        15360000
MFA-TR*      ,:RS-PRICE-PER-SERV                                        15360100
MFA-TR*      ,:RS-B-UTIL-TYPE                                           15360200
MFA-TR*      ,:RS-B-READ-ROUTE                                          15360300
MFA-TR*      ,:RS-B-RATE-PLAN-NO                                        15360400
MFA-TR*      ,:RS-B-METER-IND                                           15360500
MFA-TR*      ,:RS-C-RATE-ITEM-CODE                                      15360600
MFA-TR*      ,:RS-C-PRICE-PER-SERV                                      15360700
MFA-TR*      ,:RS-C-CUST-PER-SERVICE                                    15360800
MFA-TR*      ,:RS-C-EQUIP-SHRT-DESC                                     15360900
MFA-TR*      ,:RS-READ-CYCLE                                            15361000
MFA-TR*      ,:RS-INSTALL-DATE                                          15361100
MFA-TR*      ,:RS-LAST-BILL-DATE                                        15361200
MFA-TR*      ,:RS-LIGHT-NOT-BILLED                                      15361300
MFA-TR*      ,:RS-MSG-DISPLAY-DT                                        15361400
MFA-TR*      ,:RS-CROSS-STREET-1                                        15361500
MFA-TR*      ,:RS-CROSS-STREET-2                                        15361600
MFA-TR*      )                                                          15361700
MFA-TR*    END-EXEC.                                                    15361701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02075_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************15361721
CVT000* 8000A-DELETE-GTT-ROWS.                                         *15361722
CVT000******************************************************************15361723
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 15361725
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 15361729
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02075_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15361730
MFA-TR*         DELETE FROM SESSION.CSR02075_R1                         15361731
MFA-TR*     END-EXEC.                                                   15361732

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 15361733
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 15361735
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02075_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 15361751
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 15361754
CVT000     EXEC SQL                                                     15361755
CVT000         INCLUDE CPD00320                                         15361756
CVT000     END-EXEC.                                                    15361757
