       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02074.                                         
COB303 DATE-WRITTEN.  APRIL 18, 1995.                                   
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S074 CONVERTED TO DB2 SP CSR02074 ON 06/13/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S074                                           *        
      *  PROGRAM:       S074                                           *        
      *  CALLING SP:    PA_S074                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES ALL UTILITY INFORMATION FOR A        *        
      *  PARTICULAR ACCOUNT.                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/19/95    MJG      PROCEDURE ORIGINALLY CODED.              *        
      *  03/21/95     BB      PCR 0208 : DISPLAY PUBLISHED RATE        *        
      *                       SCHEDULED INSTEAD OF IC NUMBER ON PANEL  *        
      *                       268 SIDEBAR                              *        
      *  06/27/96    CDS      TPR 4601 - REMOVE PUB_RATE_PLAN_NO AND   *        
      *                       REPLACE IT WITH RATE_PLAN_NO FROM UT.    *        
TP5184*  08/19/96    TCB      CHANGED SORT ON CSS_CUST_PLAN AND MOVED  *        
TP5184*                       RATE-ITEM-CODE TO THE RS-DESCRIPTION.    *        
PCR618*  03/20/98    TDK      PCR 618 : CHANGED OUTLINE OBJECT ON      *        
PCR618*                       UTILITIY PANELS TO ONLY SHOW SUBDIVISION *        
PCR618*                       LIGHTING PLANS THAT HAVE A STATUS OF     *        
PCR618*                       ACTIVE.                                  *        
CBSI  *  08/05/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T27237*  08/23/02   ANAND     PRIORITY SERVICE CATEGORY CODE IS ADDED  *        
T27237*                       NEXT TO THE RATE IN THE PARENT WINDOW    *        
A37342*  03/14/09   SJ97149   IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*                       POSITIONING FOR GLOBAL TEMP TABLES &     *        
A37342*                       WITH UR CHANGES TO CURSORS*              *        
A01942*  31/12/09   SJ97149   ADDING STATUS FOR UNMETERED ACCOUNTS ON  *        
A01942*                       PANEL 268 UNDER IC DETAILS               *        
A03959*  01/02/2013 MS93554   CODE_METER_STATUS = 'B' CHANGED          *        
      *                       TO NOW BE "BACKUP METER".                *        
A04527*  06/11/2013 MC95456   REMOVED UNUSED COPYBOOK CWS00056         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02074'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S288 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    TABLE CSS_RATE_PLAN_DESC IS NEEDED FOR PCR 208              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
T27237******************************************************************        
T27237*    CSS_ACCOUNT                                                 *        
T27237******************************************************************        
T27237     EXEC SQL                                                             
T27237        INCLUDE TBACCT                                                    
T27237     END-EXEC.                                                            
                                                                        
T27237******************************************************************        
T27237*    CSS_PRTY_SVC_CAT                                            *        
T27237******************************************************************        
T27237     EXEC SQL                                                             
T27237        INCLUDE TBSVCCAT                                                  
T27237     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
      *    COPY CWS00303.                                                       
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CJF00113.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  WORK AREA                                                     *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'S074    '.     
           05  WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO         
                                        PIC S9(13).                     
           05  WS-IC-NO                 PIC X(04) VALUE SPACES.         
           05  WS-MTR-REF-NO            PIC X(04) VALUE SPACES.         
           05  WS-ITEM-SEQ-NO           PIC X(04) VALUE SPACES.         
           05  WS-RATE-ITEM-CODE        PIC X(04) VALUE SPACES.         
      ***********************************************************               
      * THE FOLLOWING WORKING STORAGE VARIABLES ARE ADDED  FOR  *               
      * PCR0208                                                 *               
      ***********************************************************               
           05  WS-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
A01942     05  WS-CODE-PLAN-STAT        PIC X(04) VALUE SPACES.         
           05  WS-CODE-METER-STATUS     PIC X(04) VALUE SPACES.         
PCR618     05  WS-RATE-PLN-NO           PIC X(03) VALUE SPACES.         
PCR618     05  WS-CODE-PLAN-STATUS      PIC X(01) VALUE SPACES.         
                                                                        
T27237     05  WS-PRTY-SVC-CAT-CD       PIC X(02) VALUE SPACES.         
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                 POINTER.                                
CVT999*    05  GWL-INIT-HANDLE          POINTER.                                
CVT999*    05  GWL-RC                   PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9) COMP.               
CVT999*    05  PARM-ID1                   PIC S9(9) COMP VALUE 1.               
           05  PARM-ACCOUNT-NO            PIC X(13).                    
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                PIC S9(9) COMP.                  
           05  MSG-SEVERITY            PIC S9(9) COMP VALUE 11.         
           05  MSG-NR                  PIC S9(9) COMP VALUE  2.         
           05  MSG-RPC                 PIC X(4)       VALUE 'S288'.     
           05  MSG-RPC-L               PIC S9(9) COMP.                  
           05  MSG-TEXT                PIC X(100).                      
           05  MSG-TEXT-L              PIC S9(9) COMP.                  
           05  MSG-SQL-ERROR.                                           
               10  FILLER              PIC X(10) VALUE 'SQLCODE = '.    
               10  MSG-SQL-ERROR-C     PIC -9(3) DISPLAY.               
               10  FILLER              PIC X(16)                        
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K     PIC X(70).                       
               10  MSG-SQL-ERROR-K-CHARS                                
                                       REDEFINES MSG-SQL-ERROR-K        
                                       OCCURS 70 TIMES                  
                                       PIC X.                           
           05  MSG-SQL-ERROR-SS        PIC S9(4) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.        
           05  RS-DESCRIPTION           PIC X(14) VALUE SPACES.         
           05  RS-SORTORDER             PIC X(40) VALUE SPACES.         
           05  RS-LEVEL                 PIC S9(04) COMP VALUE 0.        
           05  RS-VISIBLE               PIC S9(04) COMP VALUE 0.        
           05  RS-SELECTED              PIC S9(04) COMP VALUE 0.        
           05  RS-OPEN                  PIC S9(04) COMP VALUE 0.        
           05  RS-TYPE                  PIC X(07) VALUE 'FOLDER'.       
           05  RS-CHILDREN              PIC S9(04) COMP VALUE 0.        
           05  RS-LASTROW               PIC S9(04) COMP VALUE 0.        
           05  RS-LASTROW2              PIC X(01) VALUE SPACES.         
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RETURN-CODE           PIC X(11)                               
CVT999*                                  VALUE 'RETURN CODE'.                   
CVT999*    05  CN-DESCRIPTION           PIC X(11)                               
CVT999*                                  VALUE 'DESCRIPTION'.                   
CVT999*    05  CN-SORTORDER             PIC X(10)                               
CVT999*                                  VALUE 'UNIQUE KEY'.                    
CVT999*    05  CN-LEVEL                 PIC X(05)                               
CVT999*                                  VALUE 'LEVEL'.                         
CVT999*    05  CN-VISIBLE               PIC X(07)                               
CVT999*                                  VALUE 'VISIBLE'.                       
CVT999*    05  CN-SELECTED              PIC X(08)                               
CVT999*                                  VALUE 'SELECTED'.                      
CVT999*    05  CN-OPEN                  PIC X(04)                               
CVT999*                                  VALUE 'OPEN'.                          
CVT999*    05  CN-TYPE                  PIC X(04)                               
CVT999*                                  VALUE 'TYPE'.                          
CVT999*    05  CN-CHILDREN              PIC X(08)                               
CVT999*                                  VALUE 'CHILDREN'.                      
CVT999*    05  CN-LASTROW               PIC X(08)                               
CVT999*                                  VALUE 'LAST ROW'.                      
CVT999*    05  CN-LASTROW2              PIC X(09)                               
CVT999*                                  VALUE 'LAST ROW2'.                     
       77  WS-PROVISION-FLAG            PIC X(01) VALUE 'N'.            
                                                                        
      ***********************************************************               
      * THE UTIL CURSOR HAS BEEN CHANGED FOR PCR 0208           *               
      *                                                         *               
      *    EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR              *               
      *        SELECT  UT.CODE_UTIL_TYPE                        *               
      *              , UT.RATE_PLAN_NO                          *               
      *              , UT.IC_NO                                 *               
      *        FROM    CSS_UTIL_ENVRNMT UT,                     *               
      *        WHERE   UT.ACCOUNT_NO        = :UT-ACCOUNT-NO    *               
      *    END-EXEC.                                            *               
      ***********************************************************               
           EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      
               SELECT  UT.CODE_UTIL_TYPE                                
                     , UT.RATE_PLAN_NO                                  
                     , UT.IC_NO                                         
T27237               , UT.CODE_CURTAIL_PRTY                             
               FROM    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
               WHERE   UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
               ORDER   BY UT.IC_NO                                      
A37342         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                              
MFA-TR*        SELECT  UT.CODE_UTIL_TYPE                                        
MFA-TR*              , UT.RATE_PLAN_NO                                          
MFA-TR*              , UT.IC_NO                                                 
MFA-TR*              , UT.CODE_CURTAIL_PRTY                                     
MFA-TR*        FROM    CSS_UTIL_ENVRNMT UT                                      
MFA-TR*        WHERE   UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*        ORDER   BY UT.IC_NO                                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***********************************************************               
      * THE METER-CURSOR HAS BEEN CHANGED FOR PCR 0208          *               
      *                                                         *               
      *    EXEC SQL DECLARE METER-CURSOR CURSOR FOR             *               
      *        SELECT  MTR_REF_NO                               *               
      *              , METER_NO                                 *               
      *              , CODE_UTIL_TYPE                           *               
      *              , IC_NO                                    *               
      *        FROM    CSS_MTRD_ENVRNMT                         *               
      *        WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO       *               
      *    END-EXEC.                                            *               
      ***********************************************************               
           EXEC SQL DECLARE METER-CURSOR CURSOR FOR                     
               SELECT  MTR_REF_NO                                       
                     , METER_NO                                         
                     , CODE_UTIL_TYPE                                   
                     , IC_NO                                            
                     , CODE_METER_STATUS                                
               FROM    CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                   
               WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO               
               ORDER BY IC_NO                                           
A37342         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE METER-CURSOR CURSOR FOR                             
MFA-TR*        SELECT  MTR_REF_NO                                               
MFA-TR*              , METER_NO                                                 
MFA-TR*              , CODE_UTIL_TYPE                                           
MFA-TR*              , IC_NO                                                    
MFA-TR*              , CODE_METER_STATUS                                        
MFA-TR*        FROM    CSS_MTRD_ENVRNMT                                         
MFA-TR*        WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO                       
MFA-TR*        ORDER BY IC_NO                                                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE PLAN-CURSOR CURSOR FOR                      
               SELECT  CP.ITEM_SEQ_NO                                   
                     , CP.RATE_ITEM_CODE                                
                     , CP.CODE_UTIL_TYPE                                
                     , CP.IC_NO                                         
PCR618               , CP.CODE_PLAN_STATUS                              
PCR618               , UT.RATE_PLAN_NO                                  
               FROM    CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                  
PCR618                 CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
               WHERE   CP.ACCOUNT_NO        = :CP-ACCOUNT-NO            
PCR618           AND   CP.ACCOUNT_NO        = UT.ACCOUNT_NO             
PCR618           AND   CP.IC_NO             = UT.IC_NO                  
PCR618*          AND   UT.RATE_PLAN_NO      = :WS-RATE-PLAN-NO                  
PCR618           AND   CP.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         
TP5184         ORDER BY IC_NO, RATE_ITEM_CODE                           
A37342         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PLAN-CURSOR CURSOR FOR                              
MFA-TR*        SELECT  CP.ITEM_SEQ_NO                                           
MFA-TR*              , CP.RATE_ITEM_CODE                                        
MFA-TR*              , CP.CODE_UTIL_TYPE                                        
MFA-TR*              , CP.IC_NO                                                 
MFA-TR*              , CP.CODE_PLAN_STATUS                                      
MFA-TR*              , UT.RATE_PLAN_NO                                          
MFA-TR*        FROM    CSS_CUST_PLAN CP,                                        
MFA-TR*                CSS_UTIL_ENVRNMT UT                                      
MFA-TR*        WHERE   CP.ACCOUNT_NO        = :CP-ACCOUNT-NO                    
MFA-TR*          AND   CP.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*          AND   CP.IC_NO             = UT.IC_NO                          
MFA-TR*          AND   UT.RATE_PLAN_NO      = :WS-RATE-PLAN-NO                  
MFA-TR*          AND   CP.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                 
MFA-TR*        ORDER BY IC_NO, RATE_ITEM_CODE                                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
CVT000         SELECT                                                   
CVT000         LTRIM(RTRIM(DESCRIPTION)) AS DESCRIPTION                        
CVT000        ,LTRIM(RTRIM(SORTORDER))   AS SORTORDER                          
CVT000        ,LEVEL                                                    
CVT000        ,VISIBLE                                                  
CVT000        ,SELECTED                                                 
CVT000        ,[OPEN]                                                     
CVT000        ,CHILDREN                                                 
CVT000        ,LASTROW                                                  
CVT000        ,LASTROW2                                                 
CVT000        ,LTRIM(RTRIM(TYPE))        AS TYPE                               
CVT000        ,RETURN_CODE                                              
CVT000         FROM #CSR02074_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                   00000400
MFA-TR*        STRIP(DESCRIPTION) AS DESCRIPTION                                
MFA-TR*       ,STRIP(SORTORDER)   AS SORTORDER                                  
MFA-TR*       ,LEVEL                                                            
MFA-TR*       ,VISIBLE                                                          
MFA-TR*       ,SELECTED                                                         
MFA-TR*       ,OPEN                                                             
MFA-TR*       ,CHILDREN                                                         
MFA-TR*       ,LASTROW                                                          
MFA-TR*       ,LASTROW2                                                         
MFA-TR*       ,STRIP(TYPE)        AS TYPE                                       
MFA-TR*       ,RETURN_CODE                                                      
MFA-TR*        FROM SESSION.CSR02074_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM THRU 9999-EXIT.                     
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02074_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02074_R1
              (                                                          
CVT000         DESCRIPTION CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,SORTORDER CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,LEVEL                    SMALLINT                        
CVT000        ,VISIBLE                  SMALLINT                        
CVT000        ,SELECTED                 SMALLINT                        
CVT000        ,[OPEN]                     SMALLINT                        
CVT000        ,CHILDREN                 SMALLINT                        
CVT000        ,LASTROW                  SMALLINT                        
CVT000        ,LASTROW2 CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,TYPE CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2                   
CVT000        ,RETURN_CODE              INT                         
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                            TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM,                
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           UNSTRING PARM-ACCOUNT-NO DELIMITED BY SPACES                 
                    INTO WS-ACCOUNT-NO.                                 
           MOVE WS-ACCOUNT-NO-NUM TO UT-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO MN-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO CP-ACCOUNT-NO.                     
                                                                        
           PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                 
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-DESCRIPTION TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-DESCRIPTION TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DESCRIPTION,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-DESCRIPTION,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-SORTORDER TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-SORTORDER TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SORTORDER,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-SORTORDER,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-LEVEL TO WRKLEN1.                                  
CVT999*    MOVE LENGTH OF CN-LEVEL TO WRKLEN2.                                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LEVEL,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-LEVEL,                                      
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-VISIBLE   TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-VISIBLE   TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-VISIBLE,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-VISIBLE,                                    
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-SELECTED TO WRKLEN1.                               
CVT999*    MOVE LENGTH OF CN-SELECTED TO WRKLEN2.                               
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SELECTED,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-SELECTED,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT2 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-OPEN TO WRKLEN1.                                   
CVT999*    MOVE LENGTH OF CN-OPEN TO WRKLEN2.                                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-OPEN,                                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-OPEN,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2  TO DB-HOST-TYPE.                                       
CVT999*    MOVE TDSINT2  TO DB-CLIENT-TYPE.                                     
CVT999*    MOVE LENGTH OF RS-CHILDREN TO WRKLEN1.                               
CVT999*    MOVE LENGTH OF CN-CHILDREN TO WRKLEN2.                               
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CHILDREN,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CHILDREN,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT2  TO DB-HOST-TYPE.                                       
CVT999*    MOVE TDSINT2  TO DB-CLIENT-TYPE.                                     
CVT999*    MOVE LENGTH OF RS-LASTROW   TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-LASTROW   TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LASTROW,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-LASTROW,                                    
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSCHAR  TO DB-HOST-TYPE.                                       
CVT999*    MOVE TDSCHAR  TO DB-CLIENT-TYPE.                                     
CVT999*    MOVE LENGTH OF RS-LASTROW2     TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CN-LASTROW2     TO WRKLEN2.                           
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LASTROW2,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-LASTROW2,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-TYPE TO WRKLEN1.                                   
CVT999*    MOVE LENGTH OF CN-TYPE TO WRKLEN2.                                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TYPE,                                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-TYPE,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *  1. FIND ALL AVAILABLE ICS FOR A PARTICULAR ACCOUNT            *        
      *  2. FIND ALL AVAILABLE METERS FOR A PARTICULAR ACCOUNT         *        
      *  3. FIND ALL AVAILABLE REGISTERS FOR A PARTICULAR ACCOUNT      *        
      *  3. SEND RESULT                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-UTIL THRU 7000-EXIT.                       
                                                                        
           PERFORM 7100-FETCH-UTIL THRU 7100-EXIT.                      
                                                                        
           PERFORM 2500-POPULATE-UTIL   THRU 2500-EXIT                  
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
                                                                        
           PERFORM 7200-CLOSE-UTIL  THRU 7200-EXIT.                     
                                                                        
           PERFORM 7300-OPEN-METER THRU 7300-EXIT.                      
                                                                        
           PERFORM 7400-FETCH-METER THRU 7400-EXIT.                     
                                                                        
           PERFORM 2600-POPULATE-METER  THRU 2600-EXIT                  
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
                                                                        
           PERFORM 7500-CLOSE-METER  THRU 7500-EXIT.                    
                                                                        
           PERFORM 7600-OPEN-PLAN THRU 7600-EXIT.                       
                                                                        
           PERFORM 7700-FETCH-PLAN THRU 7700-EXIT.                      
                                                                        
           PERFORM 2700-POPULATE-PLAN    THRU 2700-EXIT                 
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
                                                                        
           PERFORM 7800-CLOSE-PLAN THRU 7800-EXIT.                      
           IF CTR-ROWS < 1                                              
              MOVE 2 TO RS-VISIBLE                                      
              MOVE NOT-FOUND TO RS-RETURN-CODE                          
              STRING PARM-ACCOUNT-NO DELIMITED BY ' '                   
                  '.' DELIMITED BY SIZE                                 
                  ' ' DELIMITED BY SIZE                                 
                  '.' DELIMITED BY SIZE                                 
                  '    ' DELIMITED BY SIZE                              
                  ';' DELIMITED BY SIZE                                 
                  INTO RS-SORTORDER                                     
                                                                        
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-POPULATE-UTIL                                             *        
      ******************************************************************        
                                                                        
       2500-POPULATE-UTIL.                                              
      **************************************************************            
      *   THE FOLLOWING LINES WERE CHANGED FOR PCR 0208            *            
      *   MOVE UT-IC-NO TO WS-IC-NO.                               *            
      *   STRING UT-CODE-UTIL-TYPE DELIMITED BY ' '                *            
      *          '-' DELIMITED BY SIZE                             *            
      *           WS-IC-NO DELIMITED BY ' '                        *            
      *           INTO RS-DESCRIPTION.                             *            
      **************************************************************            
           MOVE UT-IC-NO TO WS-IC-NO.                                   
           MOVE UT-RATE-PLAN-NO TO WS-RATE-PLAN-NO.                     
                                                                        
T27237     IF UT-CODE-CURTAIL-PRTY > 0                                  
T27237        PERFORM 7950-GET-COMPANY-NO                               
T27237                                  THRU 7950-EXIT                  
T27237        PERFORM 8000-GET-PRTY-SVC THRU 8000-EXIT                  
T27237        MOVE Z4-PRTY-SVC-CAT-CD TO WS-PRTY-SVC-CAT-CD             
T27237        STRING UT-CODE-UTIL-TYPE DELIMITED BY ' '                 
T27237               '-' DELIMITED BY SIZE                              
T27237               WS-IC-NO DELIMITED BY ' '                          
T27237               ',' DELIMITED BY SIZE                              
T27237               WS-RATE-PLAN-NO DELIMITED BY ' '                   
T27237               ',' DELIMITED BY SIZE                              
T27237               WS-PRTY-SVC-CAT-CD DELIMITED BY ' '                
T27237               INTO RS-DESCRIPTION                                
T27237     ELSE                                                         
              STRING UT-CODE-UTIL-TYPE DELIMITED BY ' '                 
                     '-' DELIMITED BY SIZE                              
                     WS-IC-NO DELIMITED BY ' '                          
                     ',' DELIMITED BY SIZE                              
                     WS-RATE-PLAN-NO  DELIMITED BY ' '                  
                     INTO RS-DESCRIPTION                                
T27237     END-IF.                                                      
                                                                        
           MOVE SPACES TO RS-SORTORDER.                                 
                                                                        
           STRING PARM-ACCOUNT-NO DELIMITED BY ' '                      
                  '.' DELIMITED BY SIZE                                 
                  UT-CODE-UTIL-TYPE DELIMITED BY ' '                    
                  '.' DELIMITED BY SIZE                                 
                  WS-IC-NO DELIMITED BY ' '                             
                  ';' DELIMITED BY SIZE                                 
                  INTO RS-SORTORDER.                                    
                                                                        
           MOVE 2 TO RS-VISIBLE.                                        
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           MOVE SPACES TO RS-DESCRIPTION.                               
                                                                        
           PERFORM 7100-FETCH-UTIL THRU 7100-EXIT.                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-POPULATE-METER                                            *        
      ******************************************************************        
                                                                        
       2600-POPULATE-METER.                                             
      **************************************************************            
      *   THE FOLLOWING LINES WERE ADDED FOR PCR 0208              *            
      **************************************************************            
      *  MJG 4/9/02                                                             
      *  DECODED METER STATUS CODES TO MAKE MORE SENSE                          
      *  THIS CODE ALSO NEEDS TO BE KEPT IN SYNC WITH PANEL464                  
      *  REGISTER DETAILS BECAUSE IT NEEDS TO USE THE SAME DECODES.             
      *                                                                         
      *    MOVE MN-CODE-METER-STATUS  TO WS-CODE-METER-STATUS                   
                                                                        
           MOVE SPACES       TO WS-CODE-METER-STATUS                    
           EVALUATE MN-CODE-METER-STATUS                                
              WHEN 'A'                                                  
                 MOVE 'ACT ' TO WS-CODE-METER-STATUS                    
              WHEN 'B'                                                  
A03959           MOVE 'BKP ' TO WS-CODE-METER-STATUS                    
              WHEN 'K'                                                  
                 MOVE 'REM ' TO WS-CODE-METER-STATUS                    
              WHEN 'I'                                                  
                 MOVE 'INST' TO WS-CODE-METER-STATUS                    
              WHEN 'J'                                                  
                 MOVE 'OFF ' TO WS-CODE-METER-STATUS                    
              WHEN OTHER                                                
                 MOVE MN-CODE-METER-STATUS TO WS-CODE-METER-STATUS      
           END-EVALUATE.                                                
                                                                        
           STRING MN-METER-NO DELIMITED BY ' '                          
                  '-' DELIMITED BY SIZE                                 
                  WS-CODE-METER-STATUS   DELIMITED BY ' '               
                  INTO RS-DESCRIPTION.                                  
      *    MOVE MN-METER-NO TO RS-DESCRIPTION.                                  
                                                                        
           MOVE 'N' TO WS-PROVISION-FLAG                                
                                                                        
           MOVE MN-IC-NO       TO WS-IC-NO                              
           MOVE MN-MTR-REF-NO  TO WS-MTR-REF-NO.                        
                                                                        
           MOVE SPACES TO RS-SORTORDER.                                 
                                                                        
           STRING PARM-ACCOUNT-NO DELIMITED BY ' '                      
                  '.' DELIMITED BY SIZE                                 
                  MN-CODE-UTIL-TYPE DELIMITED BY ' '                    
                  '.' DELIMITED BY SIZE                                 
                  WS-IC-NO DELIMITED BY ' '                             
                  ';' DELIMITED BY SIZE                                 
                  WS-MTR-REF-NO DELIMITED BY ' '                        
                  '.' DELIMITED BY SIZE                                 
                  MN-METER-NO DELIMITED BY ' '                          
                  '.' DELIMITED BY SIZE                                 
                  WS-PROVISION-FLAG DELIMITED BY ' '                    
                  ';' DELIMITED BY SIZE                                 
                  INTO RS-SORTORDER.                                    
                                                                        
           MOVE 0 TO RS-VISIBLE.                                        
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           MOVE SPACES TO RS-DESCRIPTION.                               
                                                                        
           PERFORM 7400-FETCH-METER THRU 7400-EXIT.                     
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-POPULATE-PLAN                                             *        
      ******************************************************************        
                                                                        
       2700-POPULATE-PLAN.                                              
                                                                        
A01942     MOVE CP-RATE-ITEM-CODE   TO WS-RATE-ITEM-CODE.               
A01942     EVALUATE CP-CODE-PLAN-STATUS                                 
A01942        WHEN 'A'                                                  
A01942           MOVE 'ACT ' TO WS-CODE-PLAN-STAT                       
A01942        WHEN 'I'                                                  
A01942           MOVE 'INAC' TO WS-CODE-PLAN-STAT                       
A01942        WHEN 'B'                                                  
A01942           MOVE 'INAC' TO WS-CODE-PLAN-STAT                       
A01942        WHEN 'D'                                                  
A01942           MOVE 'INAC' TO WS-CODE-PLAN-STAT                       
A01942        WHEN 'R'                                                  
A01942           MOVE 'REM ' TO WS-CODE-PLAN-STAT                       
A01942        WHEN 'M'                                                  
A01942           MOVE 'MON ' TO WS-CODE-PLAN-STAT                       
A01942        WHEN OTHER                                                
A01942           MOVE CP-CODE-PLAN-STATUS  TO WS-CODE-PLAN-STAT         
A01942     END-EVALUATE.                                                
A01942     STRING WS-RATE-ITEM-CODE DELIMITED BY ' '                    
A01942            '-' DELIMITED BY SIZE                                 
A01942            WS-CODE-PLAN-STAT     DELIMITED BY ' '                
A01942            INTO RS-DESCRIPTION.                                  
A01942*    MOVE CP-RATE-ITEM-CODE TO RS-DESCRIPTION.                            
                                                                        
           PERFORM 7900-UNMETER-PROVISION THRU 7900-EXIT.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N' TO WS-PROVISION-FLAG                             
           END-IF.                                                      
                                                                        
           MOVE CP-IC-NO            TO WS-IC-NO                         
           MOVE CP-ITEM-SEQ-NO      TO WS-ITEM-SEQ-NO.                  
PCR618     MOVE CP-CODE-UTIL-TYPE   TO WS-ITEM-SEQ-NO(1:1).             
PCR618*    MOVE 'U'                 TO WS-ITEM-SEQ-NO(1:1).                     
A01942*    MOVE CP-RATE-ITEM-CODE   TO WS-RATE-ITEM-CODE.                       
                                                                        
PCR618     MOVE CP-CODE-PLAN-STATUS TO WS-CODE-PLAN-STATUS.             
PCR618     MOVE UT-RATE-PLAN-NO     TO WS-RATE-PLN-NO.                  
      *                                                                         
           MOVE SPACES TO RS-SORTORDER.                                 
                                                                        
PCR618     IF WS-RATE-PLN-NO EQUAL '064' AND                            
PCR618       WS-CODE-PLAN-STATUS NOT EQUAL 'A'                          
PCR618        CONTINUE                                                  
PCR618     ELSE                                                         
              STRING PARM-ACCOUNT-NO DELIMITED BY ' '                   
                     '.' DELIMITED BY SIZE                              
                     CP-CODE-UTIL-TYPE DELIMITED BY ' '                 
                     '.' DELIMITED BY SIZE                              
                     WS-IC-NO DELIMITED BY ' '                          
                     ';' DELIMITED BY SIZE                              
                     WS-ITEM-SEQ-NO DELIMITED BY ' '                    
                     '.' DELIMITED BY SIZE                              
                     WS-RATE-ITEM-CODE DELIMITED BY ' '                 
                     '.' DELIMITED BY SIZE                              
                     WS-PROVISION-FLAG DELIMITED BY ' '                 
                     ';' DELIMITED BY SIZE                              
                     INTO RS-SORTORDER                                  
                                                                        
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
PCR618     END-IF.                                                      
      *                                                                         
           MOVE SPACES TO RS-DESCRIPTION.                               
                                                                        
           PERFORM 7700-FETCH-PLAN THRU 7700-EXIT.                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-UTIL                                               *          
      ****************************************************************          
                                                                        
       7000-OPEN-UTIL.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN UTIL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7000'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'OPEN'               TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE '7000-OPEN-UTIL-CURSOR' TO MSG-TEXT                 
               MOVE 21                    TO MSG-TEXT-L                 
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7100-FETCH-UTIL                                              *          
      ****************************************************************          
                                                                        
       7100-FETCH-UTIL.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH UTIL-CURSOR                                        
               INTO                                                     
                    :UT-CODE-UTIL-TYPE                                  
                 ,  :UT-RATE-PLAN-NO                                    
                 ,  :UT-IC-NO                                           
T27237           ,  :UT-CODE-CURTAIL-PRTY                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7100'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'FETCH'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE '7100-FETCH-UTIL' TO MSG-TEXT                       
               MOVE 15                     TO MSG-TEXT-L                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-CLOSE-UTIL                                              *          
      ****************************************************************          
                                                                        
       7200-CLOSE-UTIL.                                                 
                                                                        
            EXEC SQL                                                    
                CLOSE UTIL-CURSOR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7200'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'CLOSE'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
                MOVE '7200-CLOSE-UTIL-CURSOR'   TO MSG-TEXT             
                MOVE 22                         TO MSG-TEXT-L           
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
CBSI            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
CBSI  *         PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                  
CBSI  *         PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                  
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-OPEN-METER                                              *          
      ****************************************************************          
                                                                        
       7300-OPEN-METER.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN METER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7300'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'OPEN'               TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE '7300-OPEN-METER-CURSOR'   TO MSG-TEXT              
               MOVE 22                         TO MSG-TEXT-L            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7400-FETCH-METER                                             *          
      ****************************************************************          
                                                                        
       7400-FETCH-METER.                                                
                                                                        
           EXEC SQL                                                     
               FETCH METER-CURSOR                                       
               INTO                                                     
                    :MN-MTR-REF-NO                                      
                 ,  :MN-METER-NO                                        
                 ,  :MN-CODE-UTIL-TYPE                                  
                 ,  :MN-IC-NO                                           
                 ,  :MN-CODE-METER-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7400'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'FETCH'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE '7400-FETCH-METER-CURSOR' TO MSG-TEXT               
               MOVE 23                    TO MSG-TEXT-L                 
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7500-CLOSE-METER                                             *          
      ****************************************************************          
                                                                        
       7500-CLOSE-METER.                                                
                                                                        
            EXEC SQL                                                    
                CLOSE METER-CURSOR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7500'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'CLOSE'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
                MOVE '7500-CLOSE-UTIL-CURSOR'   TO MSG-TEXT             
                MOVE 22                         TO MSG-TEXT-L           
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
CBSI            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
CBSI  *         PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                  
CBSI  *         PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                  
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7600-OPEN-PLAN                                               *          
      ****************************************************************          
                                                                        
       7600-OPEN-PLAN.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN PLAN-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7600'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'OPEN'               TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2             
CBSI           MOVE CP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE WS-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2           
               MOVE '7600-OPEN-PLAN-CURSOR' TO MSG-TEXT                 
               MOVE 20                    TO MSG-TEXT-L                 
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7700-FETCH-PLAN                                              *          
      ****************************************************************          
                                                                        
       7700-FETCH-PLAN.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH PLAN-CURSOR                                        
               INTO                                                     
                    :CP-ITEM-SEQ-NO                                     
                 ,  :CP-RATE-ITEM-CODE                                  
                 ,  :CP-CODE-UTIL-TYPE                                  
                 ,  :CP-IC-NO                                           
PCR618           ,  :CP-CODE-PLAN-STATUS                                
PCR618           ,  :UT-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7700'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'FETCH'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2             
CBSI           MOVE CP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE WS-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2           
               MOVE '7700-FETCH-PLAN-CURSOR' TO MSG-TEXT                
               MOVE 21                     TO MSG-TEXT-L                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
CBSI  *        PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                   
CBSI  *        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7800-CLOSE-PLAN                                              *          
      ****************************************************************          
                                                                        
       7800-CLOSE-PLAN.                                                 
                                                                        
            EXEC SQL                                                    
                CLOSE PLAN-CURSOR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7800'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'CLOSE'              TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
CBSI           MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2             
CBSI           MOVE CP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE WS-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2           
                MOVE '7800-CLOSE-PLAN-CURSOR'  TO MSG-TEXT              
                MOVE 22                         TO MSG-TEXT-L           
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
CBSI            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
CBSI  *         PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                  
CBSI  *         PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                  
            END-IF.                                                     
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7900-UNMETER-PROVISION                                       *          
      ****************************************************************          
                                                                        
       7900-UNMETER-PROVISION.                                          
           EXEC SQL                                                     
               SELECT  DISTINCT 'Y'                                     
               INTO    :WS-PROVISION-FLAG                               
               FROM    CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
               WHERE   ACCOUNT_NO        = :CP-ACCOUNT-NO               
               AND     CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE           
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DISTINCT 'Y'                                             
MFA-TR*        INTO    :WS-PROVISION-FLAG                                       
MFA-TR*        FROM    CSS_CUST_PLAN                                            
MFA-TR*        WHERE   ACCOUNT_NO        = :CP-ACCOUNT-NO                       
MFA-TR*        AND     CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               OR NOT-FOUND                                             
                NEXT SENTENCE                                           
            ELSE                                                        
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CBSI           MOVE '7900'               TO ACTIVE-PARAGRAPH            
CBSI           MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI           MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
CBSI           MOVE CP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE CP-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
                MOVE '7900-UNMETER-PROVISION'  TO MSG-TEXT              
                MOVE 22                         TO MSG-TEXT-L           
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
CBSI            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
CBSI  *         PERFORM 9100-CHECK-ERROR        THRU 9100-EXIT                  
CBSI  *         PERFORM 9999-END-PROGRAM        THRU 9999-EXIT                  
            END-IF.                                                     
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27237****************************************************************          
T27237* 7950-GET-COMPANY-NO.                                         *          
T27237****************************************************************          
T27237                                                                  
T27237 7950-GET-COMPANY-NO.                                             
T27237     EXEC SQL                                                     
T27237         SELECT  COMPANY_NO                                       
T27237         INTO    :AT-COMPANY-NO                                   
T27237         FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                        
T27237         WHERE   ACCOUNT_NO        = :UT-ACCOUNT-NO               
A37342                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NO                                               
MFA-TR*        INTO    :AT-COMPANY-NO                                           
MFA-TR*        FROM    CSS_ACCOUNT                                              
MFA-TR*        WHERE   ACCOUNT_NO        = :UT-ACCOUNT-NO                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
T27237                                                                  
T27237      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T27237          NEXT SENTENCE                                           
T27237      ELSE                                                        
T27237         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
T27237         MOVE '7950'               TO ACTIVE-PARAGRAPH            
T27237         MOVE 'SELECT'             TO ABEND-FUNCTION              
T27237         MOVE SPACES               TO ABEND-SQL-PREDICATES        
T27237                                      ABEND-TABLES                
T27237         MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
T27237         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
T27237         MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
T27237         MOVE '7950-GET-COMPANY-NO'      TO MSG-TEXT              
T27237         MOVE 19                         TO MSG-TEXT-L            
T27237         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T27237         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T27237     END-IF.                                                      
T27237                                                                  
T27237 7950-EXIT.                                                       
T27237     EXIT.                                                        
                                                                        
T27237****************************************************************          
T27237* 8000-GET-PRTY-SVC.                                           *          
T27237****************************************************************          
T27237                                                                  
T27237 8000-GET-PRTY-SVC.                                               
T27237     EXEC SQL                                                     
T27237         SELECT  PRTY_SVC_CAT_CD                                  
T27237           INTO  :Z4-PRTY-SVC-CAT-CD                              
T27237           FROM  CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                   
T27237          WHERE  CODE_CURTAIL_PRTY = :UT-CODE-CURTAIL-PRTY        
T27237            AND  COMPANY_NO        = :AT-COMPANY-NO               
A37342                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PRTY_SVC_CAT_CD                                          
MFA-TR*          INTO  :Z4-PRTY-SVC-CAT-CD                                      
MFA-TR*          FROM  CSS_PRTY_SVC_CAT                                         
MFA-TR*         WHERE  CODE_CURTAIL_PRTY = :UT-CODE-CURTAIL-PRTY                
MFA-TR*           AND  COMPANY_NO        = :AT-COMPANY-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
T27237                                                                  
T27237      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T27237          NEXT SENTENCE                                           
T27237      ELSE                                                        
T27237          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
T27237             MOVE SPACES               TO Z4-PRTY-SVC-CAT-CD      
T27237          ELSE                                                    
T27237                                                                  
T27237             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
T27237             MOVE '8000'               TO ACTIVE-PARAGRAPH        
T27237             MOVE 'SELECT'             TO ABEND-FUNCTION          
T27237             MOVE SPACES               TO ABEND-SQL-PREDICATES    
T27237                                          ABEND-TABLES            
T27237             MOVE 'CSS_PRTY_SVC_CAT'   TO TABLE-1                 
T27237             MOVE 'CODE_CURTAIL_PRTY'  TO TABLE-ELEMENT-1         
T27237             MOVE UT-CODE-CURTAIL-PRTY TO HOSTVAR-ELEMENT-1-N     
T27237             MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2         
T27237             MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-2       
T27237             MOVE '8000-GET-PRTY-SVC'  TO MSG-TEXT                
T27237             MOVE 17                   TO MSG-TEXT-L              
T27237             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
T27237             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
T27237          END-IF                                                  
T27237      END-IF.                                                     
T27237                                                                  
T27237 8000-EXIT.                                                       
T27237     EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
CVT999*COPY CPD00302.                                                           
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02074_R1                            
CVT000       (                                                          
CVT000        DESCRIPTION                                               
CVT000       ,SORTORDER                                                 
CVT000       ,LEVEL                                                     
CVT000       ,VISIBLE                                                   
CVT000       ,SELECTED                                                  
CVT000       ,[OPEN]                                                      
CVT000       ,CHILDREN                                                  
CVT000       ,LASTROW                                                   
CVT000       ,LASTROW2                                                  
CVT000       ,TYPE                                                      
CVT000       ,RETURN_CODE                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-DESCRIPTION                                           
CVT000       ,:RS-SORTORDER                                             
CVT000       ,:RS-LEVEL                                                 
CVT000       ,:RS-VISIBLE                                               
CVT000       ,:RS-SELECTED                                              
CVT000       ,:RS-OPEN                                                  
CVT000       ,:RS-CHILDREN                                              
CVT000       ,:RS-LASTROW                                               
CVT000       ,:RS-LASTROW2                                              
CVT000       ,:RS-TYPE                                                  
CVT000       ,:RS-RETURN-CODE                                           
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02074_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       DESCRIPTION                                                       
MFA-TR*      ,SORTORDER                                                         
MFA-TR*      ,LEVEL                                                             
MFA-TR*      ,VISIBLE                                                           
MFA-TR*      ,SELECTED                                                          
MFA-TR*      ,OPEN                                                              
MFA-TR*      ,CHILDREN                                                          
MFA-TR*      ,LASTROW                                                           
MFA-TR*      ,LASTROW2                                                          
MFA-TR*      ,TYPE                                                              
MFA-TR*      ,RETURN_CODE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-DESCRIPTION                                                   
MFA-TR*      ,:RS-SORTORDER                                                     
MFA-TR*      ,:RS-LEVEL                                                         
MFA-TR*      ,:RS-VISIBLE                                                       
MFA-TR*      ,:RS-SELECTED                                                      
MFA-TR*      ,:RS-OPEN                                                          
MFA-TR*      ,:RS-CHILDREN                                                      
MFA-TR*      ,:RS-LASTROW                                                       
MFA-TR*      ,:RS-LASTROW2                                                      
MFA-TR*      ,:RS-TYPE                                                          
MFA-TR*      ,:RS-RETURN-CODE                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02074_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02074_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02074_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
