       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02072.                                         
COB303 DATE-WRITTEN.      MAY 19, 1995.                                 
       DATE-COMPILED.                                                   
      *                                                                 00050002
      ******************************************************************00060002
      *                                                                 00070002
      *                 SOUTH CAROLINA ELECTRIC & GAS                   00080002
      *                                                                 00090002
      ******************************************************************00100002
      *                 P R O G R A M  S U M M A R Y                   *00110002
      *                                                                *00120002
      *     THIS PROGRAM UPDATES AND INSERTS  DEPOSIT RECORDS.         *00130002
      *  WHEN A DEPOSIT RECORD IS INSERTED, THE CSS_AR_CNTL,           *00140002
      *  CSS_DEP_ON_HAND AND CSS_DEP_REQ TABLES ARE UPDATED (IF THE    *00150002
      *  DEPOSIT RECORD IS THE FIRST FOR THE ACCOUNT, THEN A SUMMARY   *00160002
      *  ROW IS INSERTED INTO THE CSS_AR_CNTL TABLE AS WELL). THEN,    *00170002
      *  A CASH DRAWER 101 AND AR-TRANSACTION HISTORY JOURNALS ARE     *00180002
      *  WRITTEN.                                                      *00190002
      *     WHEN A DEPOSIT RECORD IS UPDATED, THE SAME TABLES ABOVE ARE*00200002
      *  UPDATED AND A MISCELLANEOUS JOURNAL IS WRITTEN.               *00210002
      *                                                                *00220002
      ******************************************************************00230002
      *                                                                *00240002
      *                     PROGRAM MODIFICATION LOG                   *00250002
      *                                                                *00260002
      *    DATE    INITIALS   COMMENTS                                 *00270002
      *  --------  --------   ---------------------------------------  *00280002
      *  05/19/95    WMG      PROCEDURE ORIGINALLY CODED.              *00290002
      *  11/14/95    MJL      TPR 1700                                 *00300002
      *                       CHANGED 2150 TO SELECT FROM AR_CNTL TO   *00310002
      *  CHECK FOR A SUMMARY ROW INSTEAD OF SELECTING MAX CERT NO.     *00320002
      *  FROM DEP_ON_HAND.                                             *00330002
      *  MOVED CURRENT DATE TO DATE MAILED ON CRED_COLL TABLE FOR      *00340002
      *  IMMEDIATE DEPOSIT.                                            *00350002
      *  1/9/96      MJL      TPR ?                                    *00360002
      *                       CHANGED 2981 TO BE SUCCESSFUL IF THE     *00370002
      *  THE DELETE FROM OFF CYCLE WAS SUCCESSFUL OR NOT FOUND BECAUSE *00380002
      *  IF AN OFF CYCLE ACCOUNT IS BILLED THEN THE OFF CYCLE RECORD   *00390002
      *  WILL BE DELETED AND WILL RETURN A NOT FOUND WHEN DELETED      *00400002
      *  AGAIN IN THIS PROGRAM S072.                                   *00410002
      *                                                                *00420002
      *  1/11/96     PD      TPR 2414                                   00430002
      *                       IF THERE IS A NORMAL DNP FOR AN ACCOUNT  *00440002
      *  AND PANEL 141 BILLING OPTION IS IMMEDIATE , THE DEPOSIT       *00450002
      *  DNP DATE SHOULD MERGE WITH THE NORMAL DNP DATE IF THE         *00460002
      *  DEPOSIT DNP DATE IS 5 WORKING DAYS BEFORE OR AFTER NORMAL     *00470002
      *  DNP DATE.                                                     *00480002
      *                                                                *00490002
      *  1/22/96     WMG     TPR 2741                                  *00500002
      *                       PROCESSING IN BEFORE THE 2200 PARAGRAPH  *00510002
      *                       WHEN INSERTING A DEPOSIT CHANGED TO PUT  *00520002
      *                       ZERO IN THE AMOUNT_TRAN_BALANCE COLUMN   *00530002
      *                       IN THE CSS_AR_CNTL TABLE FOR AN ITEM_ID  *00540002
      *                       OF ZERO.                                 *00550002
      *                                                                *00560002
      *  3/06/96     SR      TPR ****                                  *00570002
      *                       CHANGED PROGRAM-NAME WORKING STORAGE     *00580002
      *                       VARIABLE TO HOLD THE PROGRAM NAME (S072) *00590002
      *                       INSTEAD OF THE PANEL NAME (PANEL141).    *00600002
      *                                                                *00610002
      *  3/11/96     WMG     CHANGES MADE FOR FCS/GL IMPLEMENTATION.   *00620002
      *                                                                *00630002
      *  3/26/96     CJF     TPR 3614, CHANGE MESSAGE TYPE TO 90204    *00640002
      *                      AND DATE NOTICE MAILED CURRENT DATE PLUS  *00650002
      *                      ONE FOR INSERTION TO CSS_CRED_COLL ON     *00660002
      *                      BILL IMMEDIATE.                           *00670002
      *                                                                *00680002
      *  5/20/96      MR     TPR FIX # 3587.                           *00690002
      *                      ADDED CHECK FOR DEPOSITS AGAINST IMMEDIATE*00700002
      *                      BILLING - EXISTING DEPOSITS CHECKED AT    *00710002
      *                      2160-CHECK-ACTIVE-DEP.                    *00720002
      *                                                                *00730002
PCR263*  9/30/96     JRX     PCR #263                                  *00740002
PCR263*                      PROGRAM LOGIC NEEDS TO BE ADDED TO SUPPORT*00750002
PCR263*                      THE NEW NOTICE TYPES.                     *00760002
      *                                                                *00770002
TP5519* 11/01/96     TCB     ADDED MAINTENANCE TRANSACTION HISTORY.    *00780002
      *                                                                *00790002
TP9634* 03/14/97     MAD     COMPONENT WAS SETTING CODE_REFUND_ELIG TO *00800002
      *                      'A' - BILLING SUBROUTINE SCSCA101 IS      *00810002
      *                      LOOKING FOR REFUND ELIGIBILITY THROUGH A  *00820002
      *                      VALUE OF '0'.                             *00830002
T9857 * 03/31/97     EMM     ADDED TBFINLWO DCLGEN FOR CPD68 CHANGES   *00840002
      *                      ADDED TBCHGOFF DCLGEN FOR CPD68 CHANGES   *00850002
PCR404* 04/04/97     MAD     ADDED CODE TO WRITE TRANSACTION HISTORY   *00860002
      *                      WHEN DEPOSIT TYPE CHANGES. REMOVED CODE   *00870002
      *                      WHICH WAS WRITING TRANSACTION HISTORY ON  *00880002
      *                      THE INSERT. MADE SOME COSMETIC TRANS HIST *00890002
      *                      CHANGES.                                  *00900002
PCR404* 04/07/97     MAD     FIXED A TRANSACTION HISTORY PROBLEM THAT  *00910002
      *                      WAS CAUSED BY REMOVING THE RECORD OF THE  *00920002
      *                      DEPOSIT INSERT.                           *00930002
T10326* 04/11/97     MAD     COMMENTED OUT PARAGRAPH WHICH WAS REDUCING*00940002
      *                      THE ACCOUNT AR BALANCE WHEN A DEPOSIT WAS *00950002
      *                      CHANGED FROM BILL-IMMEDIATE TO ANOTHER    *00960002
      *                      BILLING OPTION (SHOULD BE DONE THROUGH    *00970002
      *                      BILLING).                                 *00980002
MAD422* 04/22/97     MAD     CHANGED PROGRAM ID ON TRANS-HIST RECORDS  *00990002
      *                      TO MATCH PCR404 DESIGN SPECS.             *01000002
T10578* 04/23/97     MAD     FIXED JOURNALS TO SHOW DEPOSIT CERTIFICATE*01010002
      *                      NUMBER AND DETAIL BALANCE.                *01020002
T10841* 05/05/97     PD      NOT UPDATING CODES DATA PRESENT WITH      *01030002
      *                      WS-CODE-DEP-REQ WHEN THERE ARE OTHER      *01040002
      *                      DEPOSITS PRESENT ON THE ACCOUNT.          *01050002
T11234* 05/15/97     MAD     ADDED NEW APPL-PROGRAM ID 'PANEL141C' TO  *01060002
      *                      RETRIEVE BILLING HISTORY ON BILL IMMED.   *01070002
      *                      DEPOSITS (PANEL 251).                     *01080002
MAD602* 06/02/97     MAD     BILL IMMEDIATE DEPOSITS SHOULD JOURNAL TO *01090002
      *                      THE 00-DAY MONEY BUCKET.                  *01100002
T12013* 07/08/97     MAD     JOURNALLING 'BILL IMMEDIATE' MODIFICATIONS*01110002
      *                                                                *01120002
T12460* 08/01/97     EMS     ADDED CSS_DNP DCLGEN FOR CPD68 PROCESSING *01130002
BB0904* 09/04/97     BAB     ADDED CWS00061 FOR GL NEUMONICS AND       *01140002
      *                      LOGIC TO ACCUMULATE THE CASH DRAWER CNTRL *01150002
      *                      TOTALS                                    *01160002
T15605* 04/19/98     SHF     MODIFIED SO THAT VARIABLES ARE LOADING    *01170002
      *                      CORRECTLY BEFORE WRITING TO MC05 ERROR LOG*01180002
T16175* 06/09/98     MDJ     CHANGED INSERT TO CSS_DEP_ON_HAND IN PARA *01190002
      *                      2300, TO UPDATE CSS_COMMENTS WITH PARM-   *01200002
      *                      PANEL-COMMENTS.  IF LENGTH OF              01210002
      *                      COMMENTS > +72, +72 IS MOVED TO COMMENTS- *01220002
      *                      LEN, OTHERWISE LENGTH OF COMMENTS IS MOVED*01230002
CBSI  * 08/24/98     CBSI    ABEND LOG MODIFIED TO INCLUDE ALL THE     *01240002
CBSI  *              MADRAS  ABEND PARAMETERS                          *01250002
T17586* 09/01/98     SHF     ADDED NEW APPL-PROGRAM ID 'PANEL141D' TO  *01260002
      *                      USE INSTEAD OF 'PANEL283' DESCRIPTION.    *01270002
T17843* 11/06/98     SHF     CORRECTED LOADING OF SUMMARY AND DETAIL   *01280002
      *                      AR TRANSACTION HISTORY TABLES.            *01290002
T18821* 02/10/99     SHF     FRO FLAG WAS INCORRECTLY BEING SET WHEN   *01300002
      *                      CORRECTION-OF-AGING = 'Y'.                *01310002
T19931* 05/07/99     MDJ     DO NOT SET AR-RECORD-ONLY-FL (FRO) WHEN   *01320002
      *                      CHANGING BILLING OPTION FROM NEXT BILL    *01330002
      *                      TO INSTALLMENTS.                          *01340002
T21068* 11/02/99     CBSI    UPDATE CSS_ACCOUNT WITH LAST-UPDATE-TS    *01350002
T21068*              MADRAS                                             01360002
T19557* 01/31/00     CBSI    COPYBOOK CDP00068 CHANGED TO SUB PROGRAM  *01370002
T19557*              MADRAS  SCSCO068.                                 *01380002
T21202* 05/12/00     CBSI    CALL SUB ROUTINE SCSCA182 AND CHECK IF    *01390002
T21202*              MADRAS  THE PARM-LAST-UPDATE-TS AND THE ONE       *01400002
T21202*                      OBTAINED FROM THE SUB ROUTINE ARE SAME,   *01410002
T21202*                      IF THEY ARE SAME UPDATES AR_CNTL ELSE     *01420002
T21202*                      SENDS ERROR MSG TO THE PANEL              *01430002
T22359*  06/21/00    MDJ      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *01440002
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *01450002
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *01460002
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *01470002
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *01480002
      *                       ALWAYS SCSCO068 OR SCSCB068.             *01490002
T23005*  10/18/00    SFH      ADDED CODE TO PREVENT SOC7 ABEND.        *01500002
      *  04/11/01    CHANELLE MCR310 PSNC. CSS_GL_ACCT_NO              *01510002
T24646*  08/13/01    SFH      MODIFIED SELECT IN PARA 2160 TO PREVENT  *01520002
      *                       COMPILE ERROR DUE TO DB2 V6 RELEASE.     *01530002
T25962*  02/05/02    SS19371  ADDED CODE TO PREVENT SOC7 ABEND         *01540002
T26103*  02/28/02    SS19371  CHANGED CHECK TO JUST NUMERIC NOT > 0    *01550002
C27353*  09/09/02    SFH      CHANGED SO THAT TRANS HIST WOULD DISPLAY *01560002
      *                       THE DEPOSIT TYPE DESCRIPTION.            *01570002
C28788*  07/03/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *01580002
      * *                                                               01590002
REARCH*  07/23/03   MR90712    RPC CONVERTED TO COBOL SP               *01600002
REARC2*  09/30/03   BASKAR  1.REMOVE ROWICMS CALL AND USE STATIC INSERT*01610002
REARC2*                     2.DELETE COMMENTED CODES FOR CLEAN UP      *01620002
REARC2*                       PROCESSING AS PER BRUCE BIERNASKI        *01630002
T28160*  11/14/03   DP19151 1. ADDED CODE_REFUND_ELIG FIELD            *01640002
T28160*                        FOR BOTH INSERTS AND UPDATES            *01650002
T28160*                     2. ADDED CODE TO UPDATE THE COMMENTS FIELD.*01660002
T28160*                        THIS IS BECAUSE THE AGENCY_TEXT FIELD   *01670002
T28160*                        ON THE PANEL IS CODED IN TEH COMMENTS.  *01680002
T28160*                     3. ADDED MN_TRANS_HIST FOR REF_ELIG CHGS   *01690002
T28160*                     4. MADE A CHANGE TOP ADD DEP ID TO THE     *01700002
T28160*                        TRANS COMMENT.                          *01710002
T28160*                                                                *01720002
T31851*  12/23/04   COVANSYS   MODIFIED TO SAVE REFUND ELIG CORRECTLY  *01730002
T31851*             CHENNAI    FOR UPDATE OF IMMEDIATE BILLED DEPOSITS* 01740002
T26296*  01/13/05   DL85939    CHANGES FOR AUTOMATED DEPOSITS PROJECT. *01750002
T26296*                     1. NEW AUTO DEP FIELDS ADDED TO DEP_ON_HAND*01760002
T26296*                     2. CHANGES FOR DB2 STORED PROCEDURE REUSE  *01770002
T26296*                      A.ERROR-SWITCH PARAMETER IS ADDED         *01780002
T26296*                      B.THE CODE FROM CPDSP300 AND CPD00321 IS  *01790002
T26296*                        INCLUDED HERE. THE COPYBOOKS ARE NOT USED01800002
T26296*                     3. CREATE ONLY CRED_COLL 'O' ROW AND NO 'I'*01810002
T26296*                        ROW FOR AUTO DNP DEPOSITS.              *01820002
T26296*                     4. WHEN THE BILLING OPTION IS CHANGED TO   *01830002
T26296*                        IMMEDIATE FOR AUTO DNP DEPOSIT, ADD     *01840002
T26296*                        DO-AMT-DEPOSIT TO DL-AMT-TOT-RECONNECT  *01850002
T26296*                        FOR THE DEPOSIT-CERT-NO.                *01860002
T32922*  07/29/05   COVANSYS   ADDED CODE TO PREVENT -180 WHEN TRYING  *01870002
T32922*             CHENNAI    TO CHARGE AN IMMEDIATE BILL DEPOSIT.    *01880002
FI1122*  11/23/05   COVANSYS   CHANGED THE PARM-PANEL-COMMENTS LENGTH  *01890002
FI1122*             CHENNAI    FROM CHAR(72) TO CHAR(255). ALSO        *01900002
FI1122*                        ADDED CODE TO VALIDATE PARM-COMMENTS    *01910002
FI1122*                        LENGTH.                                 *01920002
CHANG1*  11/28/05   COVANSYS   CHANGES THAT MADE TO DISPLAY THE        *01930002
CHANG1*             CHENNAI    DEPOSIT ID IN THE TRANSACTION HISTORY   *01940002
CHANG1*                        WHEN DPP IS DONE THROUGH PANEL 164 ALSO.*01950002
CHANG2*  11/28/05   COVANSYS   CHANGES THAT MADE "NOT" TO              *01960002
CHANG2*             CHENNAI    DISPLAY DEPOSIT ID IN THE TRANSACTION   *01970002
CHANG2*                        HISTORY WHEN DPP IS DONE THROUGH        *01980002
CHANG2*                        164.                                    *01990002
T31725*  04/26/06   COVANSYS   AVOID INSERTING ZEROS BEFORE AMOUNT     *02000002
T31725*             CHENNAI    FIELDS VIA PANEL 141.                   *02010002
T32545*  06/05/06   DP19151  1.ADDED LOGIC TO CALCULATE IVR CALL DATE  *02020002
T32545*                        UPON SUCCESSFUL SAVE OF IMMEDIATE DEP.  *02030002
T32545*                      2.ADDED LOGIC TO DETERMINE THE TYPE OF    *02040002
T32545*                        ACCOUNT, RESID VS. COMM.                *02050002
T34097* 03/23/07   MC95456  REPLACED CSS_MODEL_SQL WITH SET STATEMENTS *02060002
A36839* 03/05/09   CVNS        CHANGE MAIL DATE CALCULATION TO 2       *02070002
A36839*            CHENNAI     BUSINESS DAYS                           *02080002
A00956* 03/25/09   CVNS        REPLACE CPD00006 WITH CPD0006A.         *02090002
A00956*            CHENNAI                                             *02100002
A37061* 07/01/09   SP95538     REPLACED  CHECKING MIDDLE DIGIT FROM    *02110002
A37061*                        CODE_REV_CLASS OF CSS_UTIL_ENVRNMT WITH *02120002
A37061*                        ACCOUNT_TYPE_CODE OF CSS_ACCOUNT TABLE. *02130002
A37061*                        ADDED WITH UR TO THE SINGLETON SELECTS. *02140002
A37061*                        ADDED "ROWSET POSITIONING FOR" TO GLOBAL*02150002
A37061*                        TEMPERARY TABLES.                       *02160002
P00599* 09/22/12   GV7A828     CHANGES MADE TO PROGRAM TO INSERT AUTO  *        
P00599*                        DEPOSIT LETTERS INTO CORRESP TABLES AND *        
P00599*                        TO UPDATE CORRESP_STATUS_CD TO 'C' IN   *        
P00599*                        CSS_CORRESP_HDR TABLE FOR THE ACCOUNT   *        
A04527* 04/29/13   MC95456     CHANGES TO CORRECT NOTICE DUE DATE WHEN *        
A04527*     A04527-ACT44       BILL IMMEDIATE DEPOSIT HAPPENS ON HOLIDAY        
P00705*                                                                *        
P00705* 08/08/13   RC41079     CHANGES TO HANDLE RETURN-CODES 5000 AND *        
P00705*                        5272 IN UI VIEWS.                       *        
P00705*                                                                *        
A05323* 09/09/14   MJ13662     REMOVE MERGE LOGIC -NORMAL AND          *        
A05323*                        EXCEPTIONAL CREDIT ACTION.              *        
ACT163* 05/17/16   TP7R341     REMOVE UNUSED COPYBOOKS CWS00076 AND    *        
ACT163*            APPL5460    CCA00001                                *        
      ******************************************************************02170002
      ******************************************************************02180002
      *                                                                *02190002
      *                ---- BASIC SEQUENCE STRUCTURE ----              *02200002
      *                                                                *02210002
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *02220002
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *02230002
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *02240002
      *  3000 - 4999  NOT USED                                         *02250002
      *  5000 - 5999  COMMON PROGRAM MODULES                           *02260002
      *  6000 - 6999  COMMON SYSTEM MODULES                            *02270002
      *  7000 - 7999  INPUT MODULES                                    *02280002
      *  8000 - 8999  OUTPUT MODULES                                   *02290002
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *02300002
      *                                                                *02310002
      ******************************************************************02320002
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02072'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02072 STARTS HERE'.                  
                                                                        
      ******************************************************************02410002
      *    DB2 INCLUDES                                                *02420002
      ******************************************************************02430002
      *                                                                 02440002
           EXEC SQL                                                     02450002
              INCLUDE SQLCA                                             02460002
           END-EXEC.                                                    02470002
      *                                                                 02480002
           EXEC SQL                                                     02490002
              INCLUDE TBDEPHND                                          02500002
           END-EXEC.                                                    02510002
      *                                                                 02520002
           EXEC SQL                                                     02530002
              INCLUDE TBDEPREQ                                          02540002
           END-EXEC.                                                    02550002
      *                                                                 02560002
           EXEC SQL                                                     02570002
              INCLUDE TBARCNTL                                          02580002
           END-EXEC.                                                    02590002
      *                                                                 02600002
           EXEC SQL                                                     02610002
              INCLUDE TBARHIST                                          02620002
           END-EXEC.                                                    02630002
      *                                                                 02640002
           EXEC SQL                                                     02650002
              INCLUDE TBARHDT                                           02660002
           END-EXEC.                                                    02670002
      *                                                                 02680002
           EXEC SQL                                                     02690002
              INCLUDE TBUSRPRF                                          02700002
           END-EXEC.                                                    02710002
      *                                                                 02720002
           EXEC SQL                                                     02730002
              INCLUDE TBACCT                                            02740002
           END-EXEC.                                                    02750002
      *                                                                 02760002
           EXEC SQL                                                     02770002
              INCLUDE TBARLOCK                                          02780002
           END-EXEC.                                                    02790002
      *                                                                 02800002
           EXEC SQL                                                     02810002
              INCLUDE TBCUST                                            02820002
           END-EXEC.                                                    02830002
      *                                                                 02840002
           EXEC SQL                                                     02850002
              INCLUDE TBPREM                                            02860002
           END-EXEC.                                                    02870002
      *                                                                 02880002
           EXEC SQL                                                     02890002
              INCLUDE TBGLATNO                                          02900002
           END-EXEC.                                                    02910002
      *                                                                 02920002
           EXEC SQL                                                     02930002
              INCLUDE TBBJCNTL                                          02940002
           END-EXEC.                                                    02950002
      *                                                                 02960002
           EXEC SQL                                                     02970002
              INCLUDE TBBTJRNL                                          02980002
           END-EXEC.                                                    02990002
      *                                                                 03000002
           EXEC SQL                                                     03010002
              INCLUDE TBMSJRNL                                          03020002
           END-EXEC.                                                    03030002
      *                                                                 03040002
           EXEC SQL                                                     03050002
              INCLUDE TBCDJRNL                                          03060002
           END-EXEC.                                                    03070002
      *                                                                 03080002
           EXEC SQL                                                     03090002
              INCLUDE TBCDCNTL                                          03100002
           END-EXEC.                                                    03110002
      *                                                                 03120002
           EXEC SQL                                                     03130002
              INCLUDE TBCRCOLL                                          03140002
           END-EXEC.                                                    03150002
      *                                                                 03160002
           EXEC SQL                                                     03170002
              INCLUDE TBOFFCYL                                          03180002
           END-EXEC.                                                    03190002
      *                                                                 03200002
      *                                                                 03210002
TP5519     EXEC SQL                                                     03220002
TP5519        INCLUDE TBMNHDT                                           03230002
TP5519     END-EXEC.                                                    03240002
      *                                                                 03250002
TP5519     EXEC SQL                                                     03260002
TP5519        INCLUDE TBMNHIST                                          03270002
TP5519     END-EXEC.                                                    03280002
      *                                                                 03290002
      *---< CSS_SURETY_BOND  - SB >                                     03300002
           EXEC SQL                                                     03310002
              INCLUDE TBSTYBND                                          03320002
           END-EXEC.                                                    03330002
                                                                        
      *---< CSS_GUARANTOR     - GU >                                    03350002
           EXEC SQL                                                     03360002
              INCLUDE TBGTNTR                                           03370002
           END-EXEC.                                                    03380002
PCR263                                                                  
PCR263*---< CSS_CUST_ALERT         >                                    03400002
PCR263     EXEC SQL                                                     03410002
PCR263        INCLUDE TBCSTALT                                          03420002
PCR263     END-EXEC.                                                    03430002
PCR263                                                                  
PCR263*---< CSS_HOLIDAY            >                                    03450002
PCR263     EXEC SQL                                                     03460002
PCR263        INCLUDE TBHLDAY                                           03470002
PCR263     END-EXEC.                                                    03480002
C28788*                                                                 03490002
T26296     EXEC SQL                                                     03500002
T26296        INCLUDE TBRECNCT                                          03510002
T26296     END-EXEC.                                                    03520002
      *                                                                 03530002
T32545* CSS_DELINQUENCY - C8                                           *03540002
T32545     EXEC SQL                                                     03550002
T32545        INCLUDE TBDELQ                                            03560002
T32545     END-EXEC.                                                    03570002
P00599* CSS_CORRESP_HDR - 1J                                            01892000
P00599     EXEC SQL                                                     01782000
P00599        INCLUDE TBCORHDR                                          01783000
P00599     END-EXEC.                                                    01784000
P00599* CSS_CORRESP_VAR - 1K                                            01785000
P00599     EXEC SQL                                                     01782000
P00599        INCLUDE TBCORVAR                                          01783000
P00599     END-EXEC.                                                    01784000
      ******************************************************************03590002
      *    COBOL WORKING STORAGE COPY BOOKS                            *03600002
      ******************************************************************03610002
                                                                        
           COPY CJF00101.                                               03630002
           COPY CJF00102.                                               03640002
           COPY CJF00113.                                               03650002
           COPY CJF00201.                                               03660002
REARCH     EXEC SQL                                                     03680002
REARCH         INCLUDE CWSX0010                                         03690002
REARCH     END-EXEC.                                                    03700002
           COPY CWS00027.                                               03710002
           COPY CWS00056.                                               03720002
           COPY CWS00100.                                               03740002
           COPY CWS00303.                                               03750002
T19557     COPY CWS0068L.                                               03760002
P00599******* CORRESP NOTICE VARIABLES************                              
P00599     COPY CWS00341.                                                       
P00599                                                                  
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00350                                                  
P00599     END-EXEC.                                                            
P00599                                                                  
      ** COPYBOOK FOR GL NEUMONICS *************************************03770002
BB0904     EXEC SQL                                                     03780002
BB0904         INCLUDE CWS00061                                         03790002
BB0904     END-EXEC.                                                    03800002
                                                                        
           EXEC SQL                                                     03820002
A00956         INCLUDE CWS0013B                                         03830002
           END-EXEC.                                                    03840002
      *                                                                 03850002
PCR263     EXEC SQL                                                     03860002
PCR263         INCLUDE CWS00068                                         03870002
PCR263     END-EXEC.                                                    03880002
PCR263*                                                                 03890002
      ******************************************************************03900002
      *    WORK AREAS                                                  *03910002
      ******************************************************************03920002
      *                                                                 03930002
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SECURITY-EXISTS-SW      PIC X(01) VALUE 'N'.             
               88 SECURITY-EXISTS                VALUE 'Y'.             
               88 NO-SECURITY-EXISTS             VALUE 'N'.             
           05  WS-AGING-CORRECT-SW     PIC X(01) VALUE 'N'.             
               88 CORRECTION-OF-AGING            VALUE 'Y'.             
T32545     05  WS-DATABASE             PIC 9(1) VALUE ZERO.             
T32545         88  CSR-DATABASE                   VALUE 1.              
T32545         88  SEB-DATABASE                   VALUE 2.              
      *                                                                 04090002
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 04130002
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 04190002
       01  MISCELLANEOUS-WS-FIELDS.                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02072'.      
REARCH     05  WS-SQLSTATE             PIC X(5)  VALUE SPACES.          
REARCH     05  WS-TERMINAL-TRAN        PIC X(04) VALUE '2072'.          
           05  VALUE-YES               PIC X(01) VALUE 'Y'.             
           05  VALUE-NO                PIC X(01) VALUE 'N'.             
           05  VALUE-SPACES            PIC X(01) VALUE ' '.             
           05  DEP-PYMT-PRIORITY-LVL   PIC S9(04) COMP VALUE +80.       
           05  VALUE-ZERO              PIC S9(05) COMP VALUE 0.         
           05  VALUE-ONE               PIC S9(05) COMP VALUE 1.         
           05  INSERT-DEPOSIT          PIC X(01) VALUE 'I'.             
           05  UPDATE-DEPOSIT          PIC X(01) VALUE 'U'.             
           05  IMMEDIATE-BILL          PIC X(01) VALUE 'I'.             
           05  NEXT-BILLING            PIC X(01) VALUE 'N'.             
           05  INSTALLMENTS            PIC X(01) VALUE 'T'.             
           05  ACTIVE                  PIC X(01) VALUE 'A'.             
           05  REBILLED                PIC X(01) VALUE 'R'.             
           05  DEPOSIT-MESSAGE-TYPE    PIC X(01) VALUE 'I'.             
           05  DEPOSIT-OFF-CYCLE-BILL  PIC X(01) VALUE 'D'.             
PCR263     05  WS-O                    PIC X(01) VALUE 'O'.             
PCR263     05  WS-I                    PIC X(01) VALUE 'I'.             
T26296     05  WS-R                    PIC X(01) VALUE 'R'.             
C27353     05  WS-DEP-TYPE             PIC X(01) VALUE SPACE.           
T26296     05  WS-DEP-TYPE-DESC        PIC X(15) VALUE SPACE.           
T28160     05  WS-REF-ELIG             PIC X(01) VALUE SPACE.           
T28160     05  WS-REF-ELIG-DESC        PIC X(12) VALUE SPACE.           
T26296     05  WS-LTR-IND              PIC X(01) VALUE SPACES.          
T26296     05  WS-LTR-IND-DESC         PIC X(13) VALUE SPACES.          
T26296     05  WS-ORIG-AMT-TOT-RCNT    PIC S9(11)V9(2) USAGE COMP-3     
T26296                                                 VALUE 0.         
           05  NO-DEPOSIT-RECORDS      PIC S9(09) COMP.                 
           05  MAX-DEPOSIT-CERT-NO     PIC S9(09) COMP.                 
           05  MAX-DEPOSIT-IND         PIC S9(04) COMP VALUE 0.         
           05  NULL-INDICATOR          PIC S9(04) COMP VALUE -1.        
           05  NULL-DATE               PIC X(10).                       
           05  DEPOSIT-EXISTS          PIC X(01) VALUE 'N'.             
           05  ACTIVE-DEPOSIT-EXISTS   PIC X(01) VALUE 'N'.             
           05  CRED-COLL-EXISTS        PIC X(01) VALUE 'N'.             
           05  WS-DNP-ROW-EXISTS       PIC X(01) VALUE 'N'.             
           05  DNP-ROW-EXISTS          PIC X(01) VALUE 'A'.             
           05  AGING-BUCKET-DAY-00     PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  ZERO-AMOUNT             PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
           05  WS-TOTAL-AGED           PIC S9(09)V99 USAGE COMP-3       
                                                        VALUE 0.        
P00599     05  MCSKR125                PIC X(08)  VALUE 'MCSKR125'.     
P00599     05  RS-KR125-RETURN-CODE    PIC S9(04) COMP VALUE 0.         
TP5519     05  WS-OLD-DATE-CREDIT-ACTION  PIC X(10) VALUE SPACES.       
TP5519     05  WS-OLD-DATE-NOTICE-DUE     PIC X(10) VALUE SPACES.       
TP5519     05  WS-OLD-DATE-BILL           PIC X(10) VALUE SPACES.       
      *                                                                 04690002
       01  AGING-BUCKET-SUMMATIONS.                                     
COB305     05 SUM-OF-00-DAY        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 SUM-OF-30-DAY        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 SUM-OF-60-DAY        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 SUM-OF-90-DAY        PIC S9(09)V99 COMP-3 VALUE 0.            
      *                                                                 04750002
      *                                                                 04760002
      *                                                                 04770002
      ******************************************************************04780002
      * WORKING STORAGE FOR JOURNALING                                 *04790002
      ******************************************************************04800002
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
           05  WS-DATE-ORIG-PYMT-IND   PIC S9(04) COMP.                 
BB0904*    05  WS-GL-ACCT-NAME         PIC X(06) VALUE 'AR-DEP'.        04850002
BB0904*    05  WS-GL-ACCT-NAME-2       PIC X(07) VALUE 'DEP-DEP'.       04860002
      *                                                                 04870002
       01  CASH-DRAWER-JOURNALING.                                      
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO    PIC X(02) VALUE '01'.            
               10  WS-CD-LOCAL-OFFICE  PIC X(03) VALUE '998'.           
               10  WS-CD-REPORT-NO     PIC X(03) VALUE '998'.           
               10  WS-CD-REPORT-DATE   PIC X(10).                       
               10  WS-CASH-DRAWER-ID   PIC S9(04) COMP VALUE 9999.      
           05  WS-GL-EREV-CCC-KEY      PIC X(10) VALUE 'EREV-CCC  '.    
           05  WS-GL-GREV-CCC-KEY      PIC X(10) VALUE 'GREV-CCC  '.    
           05  WS-GL-WREV-CCC-KEY      PIC X(10) VALUE 'WREV-CCC  '.    
COB305     05 WS-GL-ACCT-NO-2        PIC S999V9999 COMP-3 VALUE 0.            
      *                                                                 04990002
       01  MISCELLANEOUS-JOURNALING.                                    
           05  WS-RM01-RECORD-FIELD-DESC  PIC X(29) VALUE               
                                'DEP RECEIVABLES AGING CHANGED'.        
           05  WS-TRAN-DESC.                                            
               10  FILLER                   PIC X(04) VALUE 'DEP '.     
               10  WS-ACCT-NO               PIC 9(13).                  
      *                                                                 05060002
      *                                                                 05070002
      *                                                                 05080002
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                 05230002
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02072_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                 05320002
      *                                                                 05330002
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 05350002
       01  TDS-RETURN-FIELDS.                                           
           05  RS-ERROR-CODE           PIC X(50) VALUE SPACES.          
           05  RS-AR-LOCKOUT-IND       PIC X(01) VALUE SPACES.          
           05  RS-ACCT-XFER-TO         PIC X(13) VALUE SPACES.          
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP            
                                                        VALUE 0.        
T26296     05  RS-ABEND-PROGRAM        PIC X(08) VALUE SPACES.          
T26296     05  RS-ACTIVE-PARA          PIC X(04) VALUE SPACES.          
T26296     05  RS-ABEND-FUNCTION       PIC X(08) VALUE SPACES.          
T26296     05  RS-ABEND-TABLE          PIC X(20) VALUE SPACES.          
T26296     05  RS-TABLE-ELMT-1         PIC X(20) VALUE SPACES.          
T26296     05  RS-TABLE-ELMT-2         PIC X(20) VALUE SPACES.          
T26296     05  RS-TABLE-ELMT-3         PIC X(20) VALUE SPACES.          
T26296     05  RS-TABLE-ELMT-4         PIC X(20) VALUE SPACES.          
T26296     05  RS-HOSTVAR-ELMT-1       PIC X(20) VALUE SPACES.          
T26296     05  RS-HOSTVAR-ELMT-2       PIC X(20) VALUE SPACES.          
T26296     05  RS-HOSTVAR-ELMT-3       PIC X(20) VALUE SPACES.          
T26296     05  RS-HOSTVAR-ELMT-4       PIC X(20) VALUE SPACES.          
      *                                                                 05540002
REARCH*                                                                 05550002
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-ERROR-CODE            PIC X(50) VALUE SPACES.          
REARCH     05  S-RETURN-CODE           PIC S9(09) USAGE COMP            
REARCH                                                  VALUE 0.        
REARCH     05  S-AR-LOCKOUT-IND        PIC X(01) VALUE SPACES.          
REARCH     05  S-ACCT-XFER-TO          PIC X(13) VALUE SPACES.          
T26296     05  S-ABEND-PROGRAM         PIC X(08) VALUE SPACES.          
T26296     05  S-ACTIVE-PARA           PIC X(04) VALUE SPACES.          
T26296     05  S-ABEND-FUNCTION        PIC X(08) VALUE SPACES.          
T26296     05  S-ABEND-TABLE           PIC X(20) VALUE SPACES.          
T26296     05  S-TABLE-ELMT-1          PIC X(20) VALUE SPACES.          
T26296     05  S-TABLE-ELMT-2          PIC X(20) VALUE SPACES.          
T26296     05  S-TABLE-ELMT-3          PIC X(20) VALUE SPACES.          
T26296     05  S-TABLE-ELMT-4          PIC X(20) VALUE SPACES.          
T26296     05  S-HOSTVAR-ELMT-1        PIC X(20) VALUE SPACES.          
T26296     05  S-HOSTVAR-ELMT-2        PIC X(20) VALUE SPACES.          
T26296     05  S-HOSTVAR-ELMT-3        PIC X(20) VALUE SPACES.          
T26296     05  S-HOSTVAR-ELMT-4        PIC X(20) VALUE SPACES.          
      *                                                                 05740002
      *                                                                 05750002
      ***************************************************************   05760002
      *    WORKING STORAGE AREA FOR REDEFINING PARAMETERS PASSED    *   05770002
      *    IN FROM THE DESKTOP ENVIRONMENT.                         *   05780002
      ***************************************************************   05790002
       01  WS-ACCOUNT-NO-REDEFINITION.                                  
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
      *                                                                 05850002
C28160 01  WS-DEP-CERT-COMMENT.                                         
C28160     05  WS-DEP-NO-TEXT-1  PIC X(13) VALUE 'DEPOSIT ID = '.       
C28160     05  WS-DEP-CERT-NO-3        PIC X(03) VALUE '000'.           
C28160     05  WS-DEP-NO-TEXT-2        PIC X(03) VALUE ' - '.           
C28160     05  WS-NEW-TRANS-CMMTS      PIC X(191) VALUE SPACES.         
                                                                        
       01  WS-DEPOSIT-CERT-NO-REDEF.                                    
           05  WS-DEPOSIT-CERT-NO      PIC X(09).                       
           05  WS-DEPOSIT-CERT-NUM REDEFINES WS-DEPOSIT-CERT-NO         
                                       PIC 9(09).                       
           05  WS-DEPOSIT-CERT-NO-NO   PIC S9(09) USAGE COMP.           
      *                                                                 05970002
       01  WS-AMT-PAYMENT-REDEFINITION.                                 
           05  WS-AMT-PAYMENT          PIC X(11).                       
           05  WS-AMT-PYMT REDEFINES WS-AMT-PAYMENT                     
                                       PIC 9(11).                       
           05  WS-AMOUNT-PYMT-DEC      PIC 9(09)V99.                    
T31725     05  WS-SCHED-PYMTS-Z        PIC Z(03).                       
T31725     05  WS-NINE-LEN-DEC-Z       PIC -Z(07).ZZ.                   
TP5519     05  WS-NINE-LEN-DEC         PIC -9(07).99.                   
TP5519     05  WS-NINE-LEN-DEC-RED     REDEFINES WS-NINE-LEN-DEC        
TP5519                                 PIC X(11).                       
T31725     05  WS-SIGN-FOUR-Z          PIC -Z(2).                       
TP5519     05  WS-SIGN-FOUR            PIC -9(2).                       
TP5519     05  WS-SIGN-FOUR-RED        REDEFINES WS-SIGN-FOUR           
TP5519                                 PIC X(03).                       
T31725     05  WS-ELEVEN-LEN-DEC-Z     PIC -Z(09).ZZ.                   
TP5519     05  WS-ELEVEN-LEN-DEC       PIC -9(09).99.                   
TP5519     05  WS-ELEVEN-LEN-DEC-RED   REDEFINES WS-ELEVEN-LEN-DEC      
TP5519                                 PIC X(13).                       
COB305     05 WS-AMT-ORIG-ENTERED        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-HOLD-ENTERED-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-AMT-MO-PYMT-NO        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
      *                                                                 06190002
       01  NO-SCHED-PYMTS-REDEFINITION.                                 
           05  WS-NO-SCHED-PYMTS       PIC X(03).                       
           05  WS-NO-SCHED-PAYMENTS REDEFINES WS-NO-SCHED-PYMTS         
                                       PIC 9(03).                       
COB305     05 WS-NO-SCHED-PYMTS-NO        PIC S9(03)V USAGE COMP-3 
COB305       VALUE 0.        
      *                                                                 06250002
       01  WS-COMMNENT-LEN-REDEFINITION.                                
           05  WS-COMMENT-LEN          PIC X(04).                       
           05  WS-COMMENT-LENGTH REDEFINES WS-COMMENT-LEN               
                                       PIC 9(04).                       
           05  WS-COMMENT-LEN-NO       PIC S9(04) USAGE COMP.           
C28160     05  WS-NEW-CMMT-LEN-NO      PIC S9(04) USAGE COMP.           
           05  WS-PANEL-COM-LEN-NO     PIC S9(04) USAGE COMP.           
      *                                                                 06330002
       01  WS-MISC.                                                     
           05 WS-WORK-DATE               PIC X(10) VALUE SPACES.        
           05 WS-NOTICE-DATE             PIC X(10) VALUE SPACES.        
           05 WS-BAD-WORKING-DAY         PIC X(01).                     
               88 BAD-WORKING-DAY                  VALUE 'N'.           
               88 GOOD-WORKING-DAY                 VALUE 'Y'.           
           05  WS-TRAN-APPL-NO           PIC S9(04) COMP VALUE 0.       
PCR263     05  WS-DAY                    PIC S9(04) COMP VALUE 0.       
PCR263     05  WS-NEXT-DATE-COUNT        PIC S9(04) COMP.               
PCR263     05  WS-ROW-COUNT              PIC S9(09) COMP VALUE 0.       
PCR263     05  WS-PLUS-5-WDAYS           PIC X(10)  VALUE SPACES.       
MAD806     05  WS-PLUS-15-WDAYS          PIC X(10)  VALUE SPACES.       
PCR263     05  WS-DUE-DATE               PIC X(10)  VALUE SPACES.       
           05  WS-HOLD-ACTION-CODE       PIC X(01)  VALUE SPACES.       
T28160     05  WS-CODE-REFUND-ELIG       PIC X(01)  VALUE SPACES.       
      *                                                                 06490002
PCR263     05  WS-PLUS-9-WDAYS           PIC X(10)  VALUE SPACES.       
PCR263     05  WS-PLUS-10-WDAYS          PIC X(10)  VALUE SPACES.       
PCR263     05  WS-OK-NOT-FOUND           PIC X(01)  VALUE 'N'.          
PCR263     05  WS-DATE-FOUND           PIC X(01)  VALUE 'N'.            
PCR263     05  WS-HOLIDAY-EXISTS       PIC X(01)  VALUE 'N'.            
PCR263         88  HOLIDAY-EXISTS                 VALUE 'Y'.            
A36839     05  WS-NONBUSINESS-DATE     PIC X(01)  VALUE 'N'.            
A36839         88  NONBUSINESS-DATE               VALUE 'Y'.            
           05  WS-NO-MAINT-SW          PIC X(01)  VALUE 'N'.            
               88  MAINT-NEEDED                   VALUE 'Y'.            
T19557     05 WS-EIBRESP                 PIC S9(8)                      
T19557                                   COMP SYNC VALUE ZERO.          
T21202     05  WS-LAST-UPDATE-TS         PIC X(26).                     
T21202     05  SCSCA182                  PIC X(08) VALUE 'SCSCA182'.    
REARCH     05  MCSCB068                  PIC X(8)  VALUE 'MCSCB068'.    
REARCH     05  MCSCA182                  PIC X(8)  VALUE 'MCSCA182'.    
T32545     05  WS-IVR-ROW-INSERTED       PIC X(01)  VALUE 'N'.          
T32545     05  WS-IVR-DAY-SECOND         PIC S9(04) COMP.               
      *                                                                 06720002
PCR263 01  WS-NULL-IND-VARS.                                            
PCR263     05  WS-NULL-INDICATOR-1       PIC S9(04) COMP.               
PCR263     05  WS-NULL-INDICATOR-2       PIC S9(04) COMP.               
PCR263     05  WS-NULL-INDICATOR-3       PIC S9(04) COMP.               
           05  WS-NULL-INDICATOR-4       PIC S9(04) COMP.               
           05  WS-REBILLED-DEP-DATE-NULL PIC S9(04) COMP.               
PCR263*                                                                 06790002
T21202*COPY CWS00182.                                                   06800002
REARCH*                                                                 06810002
REARCH 01 SCSCA182-RECORD.                                              
COB305    05 SCSCA182-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
REARCH    05 SCSCA182-RETURN-CODE      PIC S9(09).                      
REARCH    05 SCSCA182-LAST-UPDATE-TS   PIC X(26).                       
REARCH*                                                                 06860002
PCR263*                                                                 06870002
      ******************************************************************06880002
      *    CURSOR DECLARATIONS                                         *06890002
      ******************************************************************06900002
           EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                  
              SELECT 'Y'                                                
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :SB-ACCOUNT-NO  AND                   
                     CODE_STATUS IN ('A', 'P')                          
A37061         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                  06910002
MFA-TR*       SELECT 'Y'                                                06920002
MFA-TR*         FROM CSS_SURETY_BOND                                    06930002
MFA-TR*        WHERE ACCOUNT_NO = :SB-ACCOUNT-NO  AND                   06940002
MFA-TR*              CODE_STATUS IN ('A', 'P')                          06950002
MFA-TR*        FOR FETCH ONLY WITH UR                                   06960002
MFA-TR*    END-EXEC.                                                    06970002
                                                                        
           EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                   
              SELECT 'Y'                                                
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO AND                    
                     GUAR_STATUS_CD IN ('A', 'P')                       
A37061         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                   06990002
MFA-TR*       SELECT 'Y'                                                07000002
MFA-TR*         FROM CSS_GUARANTOR                                      07010002
MFA-TR*        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO AND                    07020002
MFA-TR*              GUAR_STATUS_CD IN ('A', 'P')                       07030002
MFA-TR*        FOR FETCH ONLY WITH UR                                   07040002
MFA-TR*    END-EXEC.                                                    07050002
                                                                        
           EXEC SQL DECLARE DEPOSIT-CURSOR CURSOR FOR                   
              SELECT 'Y'                                                
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :DO-ACCOUNT-NO AND                    
                     DEPOSIT_STATUS_CD IN ('A', 'P')                    
A37061         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DEPOSIT-CURSOR CURSOR FOR                   07070002
MFA-TR*       SELECT 'Y'                                                07080002
MFA-TR*         FROM CSS_DEP_ON_HAND                                    07090002
MFA-TR*        WHERE ACCOUNT_NO = :DO-ACCOUNT-NO AND                    07100002
MFA-TR*              DEPOSIT_STATUS_CD IN ('A', 'P')                    07110002
MFA-TR*        FOR FETCH ONLY WITH UR                                   07120002
MFA-TR*    END-EXEC.                                                    07130002
      *                                                                 07140002
HPCCDM*EJECT                                                            07150002
      *                                                                 07160002
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACTION-CODE              PIC X(01).                     
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH 01  PARM-AMT-ORIG-ENTERED         PIC X(11).                     
REARCH 01  PARM-DEPOSIT-STATUS-CD        PIC X(01).                     
REARCH 01  PARM-SERVICE-TYPE-CD          PIC X(01).                     
REARCH 01  PARM-DEPOSIT-CERT-NO          PIC X(09).                     
REARCH 01  PARM-DEP-ACTION-CODE          PIC X(01).                     
REARCH 01  PARM-USER-ID-UPDT-BY          PIC X(07).                     
REARCH 01  PARM-COMMENTS                 PIC X(210).                    
REARCH 01  PARM-COMMENTS-LEN             PIC X(04).                     
FI1122 01  PARM-PANEL-COMMENTS           PIC X(255).                    
REARCH 01  PARM-PANEL-COM-LEN            PIC X(04).                     
REARCH 01  PARM-BILL-OPTION-CD           PIC X(01).                     
REARCH 01  PARM-ORIG-BILL-OPTION-CD      PIC X(01).                     
REARCH 01  PARM-NO-SCHED-PYMTS           PIC X(03).                     
REARCH 01  PARM-AMT-MO-PYMT              PIC X(11).                     
REARCH 01  PARM-CODE-DEP-TYPE            PIC X(01).                     
REARCH 01  PARM-CUT-DATE                 PIC X(10).                     
REARCH 01  PARM-PROJECT-CR-DT            PIC X(10).                     
REARCH 01  PARM-DUE-DATE                 PIC X(10).                     
REARCH 01  PARM-PROGRAM-NAME             PIC X(09).                     
REARCH 01  PARM-LAST-UPDATE-TS           PIC X(26).                     
T28160 01  PARM-CODE-REFUND-ELIG         PIC X(01).                     
T26296 01  PARM-ERR-SWITCH               PIC X(01).                     
T26296 01  PARM-AUTO-DEP-LTR-DT          PIC X(10).                     
T26296 01  PARM-AUTO-DEP-LTR-IND         PIC X(01).                     
COB305 01 PARM-AUTO-DEP-NOT-AM        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 PARM-AUTO-DEP-RECALC-AM        PIC S9(09)V99 COMP-3 VALUE 0.          
REARCH*                                                                 07460002
      *                                                                 07470002
REARCH PROCEDURE DIVISION USING PARM-ACTION-CODE                        
REARCH                         ,PARM-ACCOUNT-NO                         
REARCH                         ,PARM-AMT-ORIG-ENTERED                   
REARCH                         ,PARM-DEPOSIT-STATUS-CD                  
REARCH                         ,PARM-SERVICE-TYPE-CD                    
REARCH                         ,PARM-DEPOSIT-CERT-NO                    
REARCH                         ,PARM-DEP-ACTION-CODE                    
REARCH                         ,PARM-USER-ID-UPDT-BY                    
REARCH                         ,PARM-COMMENTS                           
REARCH                         ,PARM-COMMENTS-LEN                       
REARCH                         ,PARM-PANEL-COMMENTS                     
REARCH                         ,PARM-PANEL-COM-LEN                      
REARCH                         ,PARM-BILL-OPTION-CD                     
REARCH                         ,PARM-ORIG-BILL-OPTION-CD                
REARCH                         ,PARM-NO-SCHED-PYMTS                     
REARCH                         ,PARM-AMT-MO-PYMT                        
REARCH                         ,PARM-CODE-DEP-TYPE                      
REARCH                         ,PARM-CUT-DATE                           
REARCH                         ,PARM-PROJECT-CR-DT                      
REARCH                         ,PARM-DUE-DATE                           
REARCH                         ,PARM-PROGRAM-NAME                       
REARCH                         ,PARM-LAST-UPDATE-TS                     
T28160                         ,PARM-CODE-REFUND-ELIG                   
T26296                         ,PARM-ERR-SWITCH                         
T26296                         ,PARM-AUTO-DEP-LTR-DT                    
T26296                         ,PARM-AUTO-DEP-LTR-IND                   
T26296                         ,PARM-AUTO-DEP-NOT-AM                    
T26296                         ,PARM-AUTO-DEP-RECALC-AM.                
      *                                                                 07760002
      *                                                                 07770002
      ******************************************************************07780002
      * 0000-MAINLINE                                                  *07790002
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07800002
      ******************************************************************07810002
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07930002
      * 0100-INITIALIZE                                                *07940002
      *                                                                *07950002
      *     1. RESET DB2 ERROR HANDLERS                                *07960002
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07970002
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07980002
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07990002
      *                                                                *08000002
      ******************************************************************08010002
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                 08090002
REARCH     EXEC SQL                                                     
A37061         DECLARE C1 CURSOR                             
A37061                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT                                                   
REARC2            :S-ERROR-CODE           AS  ERROR_CODE                
REARC2           ,:S-RETURN-CODE          AS  RETURN_CODE               
REARC2           ,:S-AR-LOCKOUT-IND       AS  AR_LOCKOUT_IND            
REARC2           ,:S-ACCT-XFER-TO         AS  ACCT_XFER_TO              
T26296           ,:S-ABEND-PROGRAM        AS  ABEND_PROGRAM             
T26296           ,:S-ACTIVE-PARA          AS  ACTIVE_PARA               
T26296           ,:S-ABEND-FUNCTION       AS  ABEND_FUNCTION            
T26296           ,:S-ABEND-TABLE          AS  ABEND_TABLE               
T26296           ,:S-TABLE-ELMT-1         AS  TABLE_ELMT_1              
T26296           ,:S-TABLE-ELMT-2         AS  TABLE_ELMT_2              
T26296           ,:S-TABLE-ELMT-3         AS  TABLE_ELMT_3              
T26296           ,:S-TABLE-ELMT-4         AS  TABLE_ELMT_4              
T26296           ,:S-HOSTVAR-ELMT-1       AS  HOSTVAR_ELMT_1            
T26296           ,:S-HOSTVAR-ELMT-2       AS  HOSTVAR_ELMT_2            
T26296           ,:S-HOSTVAR-ELMT-3       AS  HOSTVAR_ELMT_3            
T26296           ,:S-HOSTVAR-ELMT-4       AS  HOSTVAR_ELMT_4            
REARCH         FROM                                                     
REARC2             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     08100002
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            08110002
MFA-TR*                          WITH ROWSET POSITIONING FOR            08120002
MFA-TR*        SELECT                                                   08130002
MFA-TR*           :S-ERROR-CODE           AS  ERROR_CODE                08140002
MFA-TR*          ,:S-RETURN-CODE          AS  RETURN_CODE               08150002
MFA-TR*          ,:S-AR-LOCKOUT-IND       AS  AR_LOCKOUT_IND            08160002
MFA-TR*          ,:S-ACCT-XFER-TO         AS  ACCT_XFER_TO              08170002
MFA-TR*          ,:S-ABEND-PROGRAM        AS  ABEND_PROGRAM             08180002
MFA-TR*          ,:S-ACTIVE-PARA          AS  ACTIVE_PARA               08190002
MFA-TR*          ,:S-ABEND-FUNCTION       AS  ABEND_FUNCTION            08200002
MFA-TR*          ,:S-ABEND-TABLE          AS  ABEND_TABLE               08210002
MFA-TR*          ,:S-TABLE-ELMT-1         AS  TABLE_ELMT_1              08220002
MFA-TR*          ,:S-TABLE-ELMT-2         AS  TABLE_ELMT_2              08230002
MFA-TR*          ,:S-TABLE-ELMT-3         AS  TABLE_ELMT_3              08240002
MFA-TR*          ,:S-TABLE-ELMT-4         AS  TABLE_ELMT_4              08250002
MFA-TR*          ,:S-HOSTVAR-ELMT-1       AS  HOSTVAR_ELMT_1            08260002
MFA-TR*          ,:S-HOSTVAR-ELMT-2       AS  HOSTVAR_ELMT_2            08270002
MFA-TR*          ,:S-HOSTVAR-ELMT-3       AS  HOSTVAR_ELMT_3            08280002
MFA-TR*          ,:S-HOSTVAR-ELMT-4       AS  HOSTVAR_ELMT_4            08290002
MFA-TR*        FROM                                                     08300002
MFA-TR*            SYSIBM.SYSDUMMY1                                     08310002
MFA-TR*    END-EXEC.                                                    08320002
      *                                                                 08330002
T21202*    INITIALIZE SCSCA182-LINK-RECORD.                             08340002
REARCH     INITIALIZE SCSCA182-RECORD.                                  
T21202*                                                                 08360002
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08400002
      * 1000-PROCESS-INPUT                                             *08410002
      *                                                                *08420002
      *     1. RECEIVE PARMS.                                          *08430002
      *                                                                *08440002
      ******************************************************************08450002
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 08540002
      ******************************************************************08550002
      * 1150 ASSIGN-WS-VARS                                            *08560002
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *08570002
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *08580002
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *08590002
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *08600002
      *        PROCESSING WITHIN THIS PROGRAM.                         *08610002
      ******************************************************************08620002
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 08640002
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT.                    
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
T21202     MOVE WS-ACCOUNT-NO         TO SCSCA182-ACCOUNT-NO.           
      *                                                                 08680002
C28160     MOVE PARM-DEPOSIT-CERT-NO(7:3)  TO WS-DEP-CERT-NO-3.         
T26103     UNSTRING PARM-DEPOSIT-CERT-NO   DELIMITED BY SPACES          
T26103        INTO WS-DEPOSIT-CERT-NUM                                  
T26103*    MOVE PARM-DEPOSIT-CERT-NO  TO WS-DEPOSIT-CERT-NO.            08720002
T23005     IF WS-ACCOUNT-NO > ZEROES AND                                
T25962*       WS-DEPOSIT-CERT-NUM > ZEROES                              08740002
T26103        WS-DEPOSIT-CERT-NUM >= 0                                  
              MOVE WS-DEPOSIT-CERT-NUM   TO WS-DEPOSIT-CERT-NO-NO       
T23005     ELSE                                                         
T23005        MOVE -1                TO RS-RETURN-CODE                  
T23005        MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
T23005        MOVE '1150'            TO ACTIVE-PARAGRAPH                
T23005        MOVE 'MOVE'            TO ABEND-FUNCTION                  
T23005        MOVE SPACES            TO ABEND-SQL-PREDICATES            
T23005                                  ABEND-TABLES                    
T23005        MOVE 'WS-ACCOUNT-NO'   TO TABLE-ELEMENT-1                 
T23005        MOVE WS-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
T23005        MOVE 'WS-DEPOSIT-CERT-NO' TO TABLE-ELEMENT-2              
T23005        MOVE WS-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T23005        PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
T23005     END-IF.                                                      
      *                                                                 08910002
           MOVE PARM-AMT-ORIG-ENTERED TO WS-AMT-PAYMENT.                
           MOVE WS-AMT-PYMT           TO WS-AMOUNT-PYMT-DEC.            
           MOVE WS-AMOUNT-PYMT-DEC    TO WS-AMT-ORIG-ENTERED.           
           DIVIDE 100                 INTO WS-AMT-ORIG-ENTERED.         
      *                                                                 08960002
           MOVE PARM-NO-SCHED-PYMTS   TO WS-NO-SCHED-PYMTS.             
           MOVE WS-NO-SCHED-PAYMENTS  TO WS-NO-SCHED-PYMTS-NO.          
      *                                                                 08990002
           MOVE PARM-AMT-MO-PYMT      TO WS-AMT-PAYMENT.                
           MOVE WS-AMT-PYMT           TO WS-AMOUNT-PYMT-DEC.            
           MOVE WS-AMOUNT-PYMT-DEC    TO WS-AMT-MO-PYMT-NO.             
           DIVIDE 100                 INTO WS-AMT-MO-PYMT-NO.           
      *                                                                 09040002
           MOVE PARM-COMMENTS-LEN     TO WS-COMMENT-LEN.                
           MOVE WS-COMMENT-LENGTH     TO WS-COMMENT-LEN-NO.             
      *                                                                 09070002
           MOVE PARM-PANEL-COM-LEN    TO WS-COMMENT-LEN.                
           MOVE WS-COMMENT-LENGTH         TO WS-PANEL-COM-LEN-NO.       
T16175     MOVE PARM-PANEL-COMMENTS       TO DO-COMMENTS-TEXT.          
T16175     IF WS-PANEL-COM-LEN-NO > +72                                 
T16175         MOVE +72 TO DO-COMMENTS-LEN                              
T16175     ELSE                                                         
T16175         MOVE WS-PANEL-COM-LEN-NO   TO DO-COMMENTS-LEN
           END-IF.           
T26296     IF PARM-AUTO-DEP-LTR-DT > SPACES                             
T26296         MOVE PARM-AUTO-DEP-LTR-DT  TO DO-AUTO-DEP-LTR-DT         
T26296     ELSE                                                         
T26296         MOVE SPACES                TO DO-AUTO-DEP-LTR-DT
           END-IF.        
T26296*                                                                 09190002
T26296     IF PARM-AUTO-DEP-LTR-IND > SPACES                            
T26296        MOVE PARM-AUTO-DEP-LTR-IND  TO DO-AUTO-DEP-LTR-IND        
T26296     ELSE                                                         
T26296        MOVE SPACES                 TO DO-AUTO-DEP-LTR-IND
           END-IF.       
T26296*                                                                 09240002
T26296     IF PARM-AUTO-DEP-NOT-AM > 0                                  
T26296        MOVE PARM-AUTO-DEP-NOT-AM   TO DO-AUTO-DEP-NOT-AM         
T26296     ELSE                                                         
T26296        MOVE ZEROS                  TO DO-AUTO-DEP-NOT-AM
           END-IF.        
T26296*                                                                 09290002
T26296     IF PARM-AUTO-DEP-RECALC-AM > 0                               
T26296        MOVE PARM-AUTO-DEP-RECALC-AM TO DO-AUTO-DEP-RECALC-AM     
T26296     ELSE                                                         
T26296        MOVE ZEROS                  TO DO-AUTO-DEP-RECALC-AM
           END-IF.     
T26296*                                                                 09340002
T26296     MOVE ZERO                      TO WS-ORIG-AMT-TOT-RCNT,      
T26296                                       DL-AMT-TOT-RECONNECT.      
      *                                                                 09370002
       1150-EXIT.                                                       
           EXIT.                                                        
PCR263***************************************************************** 09400002
PCR263**                                                             ** 09410002
PCR263**    1800-GET-NEXT-BUSINESS-DAY                               ** 09420002
PCR263**                                                             ** 09430002
PCR263***************************************************************** 09440002
PCR263*                                                                 09450002
PCR263 1800-GET-NEXT-BUSINESS-DAY.                                      
PCR263*                                                                 09470002
PCR263     MOVE WS-N                TO WS-DATE-FOUND.                   
PCR263     PERFORM 7997-GET-NEXT-DAY                 THRU 7997-EXIT.    
PCR263     IF WS-DAY EQUAL 6                                            
PCR263        OR WS-DAY EQUAL ZEROES                                    
PCR263        PERFORM 1810-GET-NEXT-DATE             THRU 1810-EXIT     
PCR263           UNTIL WS-DATE-FOUND EQUAL WS-Y                         
PCR263     ELSE                                                         
PCR263        MOVE WS-WORK-DATE     TO J8-HOLIDAY-DT                    
PCR263        PERFORM 7995-SELECT-HOLIDAY            THRU 7995-EXIT     
PCR263        IF HOLIDAY-EXISTS                                         
PCR263           PERFORM 1810-GET-NEXT-DATE          THRU 1810-EXIT     
PCR263              UNTIL WS-DATE-FOUND EQUAL WS-Y                      
PCR263        ELSE                                                      
PCR263           MOVE WS-Y          TO WS-DATE-FOUND                    
PCR263        END-IF                                                    
PCR263     END-IF.                                                      
PCR263*                                                                 09640002
PCR263 1800-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263*                                                                 09670002
PCR263***************************************************************** 09680002
PCR263**                                                             ** 09690002
PCR263**    1810-GET-NEXT-DATE                                       ** 09700002
PCR263**                                                             ** 09710002
PCR263***************************************************************** 09720002
PCR263*                                                                 09730002
PCR263 1810-GET-NEXT-DATE.                                              
PCR263*                                                                 09750002
PCR263     PERFORM 7997-GET-NEXT-DAY                 THRU 7997-EXIT.    
PCR263     IF WS-DAY EQUAL 6                                            
PCR263        OR WS-DAY EQUAL ZEROES                                    
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE WS-WORK-DATE     TO J8-HOLIDAY-DT                    
PCR263        PERFORM 7995-SELECT-HOLIDAY            THRU 7995-EXIT     
PCR263        IF HOLIDAY-EXISTS                                         
PCR263           NEXT SENTENCE                                          
PCR263        ELSE                                                      
PCR263           MOVE WS-Y          TO WS-DATE-FOUND                    
PCR263        END-IF                                                    
PCR263     END-IF.                                                      
PCR263*                                                                 09890002
PCR263 1810-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263*                                                                 09920002
T32545***************************************************************** 09930002
T32545*                                                               * 09940002
T32545* 1850-GET-PREV-BUSINESS-DAY                                    * 09950002
T32545***************************************************************** 09960002
T32545 1850-GET-PREV-BUSINESS-DAY.                                      
T32545*                                                                 09980002
T32545     MOVE WS-N                         TO WS-DATE-FOUND.          
T32545     PERFORM 7998-GET-PREV-DAY           THRU 7998-EXIT.          
T32545     IF WS-DAY EQUAL 6                                            
T32545        OR WS-DAY EQUAL ZEROES                                    
T32545        PERFORM 1860-GET-PREV-DATE             THRU 1860-EXIT     
T32545           UNTIL WS-DATE-FOUND EQUAL WS-Y                         
T32545     ELSE                                                         
T32545        MOVE WS-WORK-DATE              TO J8-HOLIDAY-DT           
T32545        PERFORM 7995-SELECT-HOLIDAY      THRU 7995-EXIT           
T32545        IF HOLIDAY-EXISTS                                         
T32545           PERFORM 1860-GET-PREV-DATE          THRU 1860-EXIT     
T32545              UNTIL WS-DATE-FOUND EQUAL WS-Y                      
T32545        ELSE                                                      
T32545           MOVE WS-Y          TO WS-DATE-FOUND                    
T32545        END-IF                                                    
T32545     END-IF.                                                      
T32545*                                                                 10150002
T32545 1850-EXIT.                                                       
T32545     EXIT.                                                        
T32545*                                                                 10180002
T32545***************************************************************** 10190002
T32545*                                                               * 10200002
T32545* 1860-GET-PREV-DATE                                            * 10210002
T32545***************************************************************** 10220002
T32545 1860-GET-PREV-DATE.                                              
T32545*                                                                 10240002
T32545     PERFORM 7998-GET-PREV-DAY                 THRU 7998-EXIT.    
T32545     IF WS-DAY EQUAL 6                                            
T32545        OR WS-DAY EQUAL ZEROES                                    
T32545        NEXT SENTENCE                                             
T32545     ELSE                                                         
T32545        MOVE WS-WORK-DATE              TO J8-HOLIDAY-DT           
T32545        PERFORM 7995-SELECT-HOLIDAY      THRU 7995-EXIT           
T32545        IF HOLIDAY-EXISTS                                         
T32545           NEXT SENTENCE                                          
T32545        ELSE                                                      
T32545           MOVE WS-Y                   TO WS-DATE-FOUND           
T32545        END-IF                                                    
T32545     END-IF.                                                      
T32545*                                                                 10380002
T32545 1860-EXIT.                                                       
T32545     EXIT.                                                        
A36839*                                                                 10410002
A36839***************************************************************** 10420002
A36839*                                                               * 10430002
A36839* 1870-CHECK-NONBUSINESS-DATE                                   * 10440002
A36839***************************************************************** 10450002
A36839 1870-CHECK-NONBUSINESS-DATE.                                     
A36839*                                                                 10470002
A36839     PERFORM 7990-CHECK-NONBUSINESS-DAY        THRU 7990-EXIT.    
A36839     IF WS-DAY EQUAL 6                                            
A36839        OR WS-DAY EQUAL ZEROES                                    
A36839        MOVE 'Y'                       TO  WS-NONBUSINESS-DATE    
A36839     ELSE                                                         
A36839        MOVE WS-WORK-DATE              TO J8-HOLIDAY-DT           
A36839        PERFORM 7995-SELECT-HOLIDAY      THRU 7995-EXIT           
A36839        IF HOLIDAY-EXISTS                                         
A36839           MOVE 'Y'                    TO  WS-NONBUSINESS-DATE    
A36839        ELSE                                                      
A36839           MOVE WS-Y                   TO WS-DATE-FOUND           
A36839        END-IF                                                    
A36839     END-IF.                                                      
A36839*                                                                 10610002
A36839 1870-EXIT.                                                       
A36839     EXIT.                                                        
A36839*                                                                 10640002
      ******************************************************************10650002
      * 2000-PROCESS-OUTPUT.                                           *10660002
      *                                                                *10670002
      *     1. DESCRIBE RESULT SET                                     *10680002
      *     2. CHECK ACTION CODE FOR THE TYPE OF PROCESS TO BE HANDLED:*10690002
      *     3. WRITE THE SUMMARY/DETAIL RECORDS:                       *10700002
      *          -- WRITE A SUMMARY AND A DETAIL RECORD TO CSS_AR_CNTL,*10710002
      *             CSS_DEP_ON_HAND AND CSS_DEP_REQ IF THE ACCOUNT HAS *10720002
      *             NO DEPOSIT RECORDS ASSOCIATED WITH IT.  ELSE, WRITE*10730002
      *             DETAIL ROWS TO THE CSS_AR_CNTL, CSS_DEP_ON_HAND    *10740002
      *             AND THE CSS_DEP_REQ TABLES                         *10750002
      *          -- WRITE A DETAIL RECORD TO CSS_AR_CNTL, CSS_DEP_REQ  *10760002
      *             AND CSS_DEP_ON_HAND TABLES IF THE ACCOUNT ALREADY  *10770002
      *             HAS A SUMMARY RECORD                               *10780002
      *     4. WRITE APPROPRIATE JOURNALS                              *10790002
      *     5. SEND RESULT SET (ERROR MESSAGE, RETURN CODE)            *10800002
      *                                                                *10810002
      ******************************************************************10820002
       2000-PROCESS-OUTPUT.                                             
      *                                                                 10840002
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
P00705        IF PARM-PROGRAM-NAME = 'CSR02072 '                        
P00705          MOVE  0 TO RS-RETURN-CODE                               
P00705          MOVE 'CMN0000009' TO RS-ERROR-CODE                      
                MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND      
REARCH          PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT           
                PERFORM 9999-END-PROGRAM      THRU 9999-EXIT            
P00705        ELSE                                                      
                MOVE 5000 TO RS-RETURN-CODE                             
                MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND      
REARCH          PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT           
                PERFORM 9999-END-PROGRAM      THRU 9999-EXIT            
P00705        END-IF                                                    
           END-IF.                                                      
                                                                        
T21202     IF PARM-PROGRAM-NAME = 'PANEL141' OR                         
P00705        PARM-PROGRAM-NAME = 'CSR02072 '                           
T21202*       PERFORM 9200-LINK-SCSCA182       THRU 9200-EXIT           10940002
REARCH        CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                 
REARCH                              SCSCA182-RETURN-CODE                
REARCH                              SCSCA182-LAST-UPDATE-TS             
REARCH                              ABEND-FILE                          
T21202                                                                  
T21202        IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                   
T21202*           MOVE ABEND-FILE-LK           TO ABEND-FILE            11010002
T21202            MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
T21202            MOVE SCSCA182-RETURN-CODE    TO WS-ACTIVE-RETURN-CODE 
T21202                                            SQLCODE               
REARCH                                            RS-RETURN-CODE        
REARCH            PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
T21202            PERFORM 9000-SEND-ERROR-RESULT                        
T21202                                         THRU 9000-EXIT           
T21202            PERFORM 9900-SQL-ERROR-ROUTINE                        
T21202                                         THRU 9900-EXIT           
T21202        ELSE                                                      
T21202            MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS     
T21202            IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS           
T21202                NEXT SENTENCE                                     
T21202            ELSE                                                  
P00705                IF PARM-PROGRAM-NAME = 'CSR02072 '                
P00705                  MOVE  0 TO RS-RETURN-CODE                       
P00705                  MOVE 'CMN0000016' TO RS-ERROR-CODE              
REARCH                  PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT       
T21202                  GO TO 2000-EXIT                                 
P00705                ELSE                                              
T21202                  MOVE 5272                 TO RS-RETURN-CODE     
REARCH                  PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT       
T21202                  GO TO 2000-EXIT                                 
P00705                END-IF                                            
T21202            END-IF                                                
T21202        END-IF                                                    
T21202     END-IF.                                                      
T21202*                                                                 11220002
           MOVE WS-ACCOUNT-DEC  TO AT-ACCOUNT-NO.                       
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           IF AT-ACCT-XFER-TO > ZERO                                    
P00705       IF PARM-PROGRAM-NAME = 'CSR02072 '                         
P00705         MOVE  0 TO RS-RETURN-CODE                                
P00705         MOVE 'CMN0000019' TO RS-ERROR-CODE                       
               MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO         
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
               PERFORM 9999-END-PROGRAM      THRU 9999-EXIT             
P00705       ELSE                                                       
               MOVE 5000 TO RS-RETURN-CODE                              
               MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO         
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
               PERFORM 9999-END-PROGRAM      THRU 9999-EXIT             
P00705       END-IF                                                     
           END-IF.                                                      
      *                                                                 11320002
           PERFORM 2710-GET-TIMESTAMP-AND-DATE    THRU 2710-EXIT.       
           MOVE CURRENT-DATE                      TO WS-CD-REPORT-DATE. 
           MOVE PARM-ACTION-CODE            TO WS-HOLD-ACTION-CODE.     
      *                                                                 11360002
T32545     PERFORM 2730-GET-ACCOUNT-INFO                THRU 2730-EXIT. 
T32545     MOVE AT-COMPANY-NO                TO  C8-COMPANY-NO.         
T32545     MOVE 'DATABASE'                   TO  C8-DELINQ-CD.          
T32545     PERFORM 7500-SELECT-DELINQ-VALUES            THRU 7500-EXIT. 
T32545     MOVE C8-DELINQ-VALUE              TO WS-DATABASE             
P00599                                          WS-CWS350-DATABASE.     
      *                                                                 11420002
T28160     IF PARM-DEPOSIT-STATUS-CD NOT EQUAL 'A'                      
T28160        PERFORM 2720-GET-RESP-AREA-ID             THRU 2720-EXIT  
T28160        PERFORM 7000-SELECT-DEP-ON-HAND           THRU 7000-EXIT  
T28160        PERFORM 5100-MOVE-TRAN-HEAD               THRU 5100-EXIT  
T28160        MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO        
T28160        PERFORM 5210-MOVE-TRAN-DET-PAID           THRU 5210-EXIT  
T28160        PERFORM 2410-UPDATE-DEPHND-DETAIL2        THRU 2410-EXIT  
T28160        PERFORM 2000A-MOVE-RESULT                 THRU 2000A-EXIT 
T28160        GO TO 2000-EXIT                                           
T28160     END-IF.                                                      
                                                                        
           IF (PARM-BILL-OPTION-CD = IMMEDIATE-BILL)                    
               PERFORM 2110-CHECK-CRED-COLL             THRU 2110-EXIT  
               IF CRED-COLL-EXISTS = 'N' THEN                           
                                                                        
                   IF WS-DNP-ROW-EXISTS EQUAL VALUE-YES                 
                        MOVE SPACES                TO PARM-ACTION-CODE  
                        MOVE DNP-ROW-EXISTS        TO RS-ERROR-CODE     
                   END-IF                                               
T26296*        ELSE                                                     11620002
T26296*            MOVE SPACES                     TO PARM-ACTION-CODE  11630002
T26296*            MOVE CRED-COLL-EXISTS           TO RS-ERROR-CODE     11640002
               END-IF                                                   
               IF (CRED-COLL-EXISTS = VALUE-YES OR                      
                 WS-DNP-ROW-EXISTS = VALUE-YES) AND                     
                 WS-HOLD-ACTION-CODE = UPDATE-DEPOSIT                   
                   PERFORM 2720-GET-RESP-AREA-ID        THRU 2720-EXIT  
                   PERFORM 7000-SELECT-DEP-ON-HAND      THRU 7000-EXIT  
                   PERFORM 7100-SELECT-DEP-REQ          THRU 7100-EXIT  
                   PERFORM 5100-MOVE-TRAN-HEAD          THRU 5100-EXIT  
                   MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO   
T31851*            PERFORM 5200-MOVE-TRAN-DET-UPD       THRU 5200-EXIT  11740002
T31851             PERFORM 5210-MOVE-TRAN-DET-PAID      THRU 5210-EXIT  
                   PERFORM 2450-UPDATE-DEPHND-IMMED     THRU 2450-EXIT  
               ELSE                                                     
                 IF (CRED-COLL-EXISTS = VALUE-YES OR                    
                   WS-DNP-ROW-EXISTS = VALUE-YES) AND                   
                   WS-HOLD-ACTION-CODE = INSERT-DEPOSIT                 
                     MOVE 'IMMED-DEP-FOUND'        TO RS-ERROR-CODE     
                 END-IF                                                 
               END-IF                                                   
           END-IF.                                                      
      *                                                                 11850002
T26296*    CHECK IF BILL IMMEDIATE DEPOSIT EXISTS DURING UPDATE         11860002
T26296     IF (PARM-ACTION-CODE = UPDATE-DEPOSIT) AND                   
T26296                  (PARM-BILL-OPTION-CD = IMMEDIATE-BILL) AND      
T26296                  (PARM-ORIG-BILL-OPTION-CD NOT = IMMEDIATE-BILL) 
T26296        PERFORM 2160-CHECK-ACTIVE-DEP             THRU 2160-EXIT  
T26296        IF ACTIVE-DEPOSIT-EXISTS = VALUE-YES                      
T26296           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT 
T26296           GO TO 2000-EXIT                                        
T26296        END-IF                                                    
T26296     END-IF.                                                      
T26296*                                                                 11960002
           IF (PARM-ACTION-CODE = INSERT-DEPOSIT)                       
               PERFORM 2150-CHECK-FOR-DEPOSIT           THRU 2150-EXIT  
               IF (PARM-BILL-OPTION-CD = IMMEDIATE-BILL)                
                   PERFORM 2160-CHECK-ACTIVE-DEP        THRU 2160-EXIT  
                   IF ACTIVE-DEPOSIT-EXISTS = VALUE-YES                 
                      NEXT SENTENCE                                     
                   END-IF                                               
               END-IF                                                   
               PERFORM 2175-SELECT-MAX-CERT-NO          THRU 2175-EXIT  
               IF DEPOSIT-EXISTS = VALUE-NO THEN                        
                  MOVE WS-AMT-ORIG-ENTERED TO WS-HOLD-ENTERED-AMT       
                  MOVE VALUE-ZERO          TO WS-DEPOSIT-CERT-NO-NO     
                                              WS-AMT-ORIG-ENTERED       
                  PERFORM 2200-WRITE-ARCNTL-DETAIL      THRU 2200-EXIT  
                  MOVE WS-HOLD-ENTERED-AMT TO WS-AMT-ORIG-ENTERED       
                  ADD 1 TO MAX-DEPOSIT-CERT-NO GIVING                   
                                           WS-DEPOSIT-CERT-NO-NO        
CHANG1            MOVE WS-DEPOSIT-CERT-NO-NO TO WS-DEPOSIT-CERT-NUM     
CHANG1            MOVE WS-DEPOSIT-CERT-NUM (7:3) TO WS-DEP-CERT-NO-3    
                  IF PARM-BILL-OPTION-CD = IMMEDIATE-BILL               
                    MOVE WS-AMT-ORIG-ENTERED TO AGING-BUCKET-DAY-00     
                    PERFORM 2200-WRITE-ARCNTL-DETAIL    THRU 2200-EXIT  
                    MOVE VALUE-ZERO          TO AGING-BUCKET-DAY-00     
                  ELSE                                                  
                    PERFORM 2200-WRITE-ARCNTL-DETAIL    THRU 2200-EXIT  
                  END-IF                                                
                  PERFORM 2300-WRITE-DEPHND-DETAIL      THRU 2300-EXIT  
                  PERFORM 2301-WRITE-DEPREQ-DETAIL      THRU 2301-EXIT  
                  PERFORM 2700-PERFORM-JOURNALING       THRU 2700-EXIT  
               ELSE                                                     
                  ADD 1 TO MAX-DEPOSIT-CERT-NO GIVING                   
                                           WS-DEPOSIT-CERT-NO-NO        
CHANG1            MOVE WS-DEPOSIT-CERT-NO-NO TO WS-DEPOSIT-CERT-NUM     
CHANG1            MOVE WS-DEPOSIT-CERT-NUM (7:3) TO WS-DEP-CERT-NO-3    
                  IF PARM-BILL-OPTION-CD = IMMEDIATE-BILL               
                    MOVE WS-AMT-ORIG-ENTERED TO AGING-BUCKET-DAY-00     
                    PERFORM 2200-WRITE-ARCNTL-DETAIL    THRU 2200-EXIT  
                    MOVE VALUE-ZERO          TO AGING-BUCKET-DAY-00     
                  ELSE                                                  
                    PERFORM 2200-WRITE-ARCNTL-DETAIL    THRU 2200-EXIT  
                  END-IF                                                
                  PERFORM 2300-WRITE-DEPHND-DETAIL      THRU 2300-EXIT  
                  PERFORM 2301-WRITE-DEPREQ-DETAIL      THRU 2301-EXIT  
                  PERFORM 2700-PERFORM-JOURNALING       THRU 2700-EXIT  
               END-IF                                                   
               IF PARM-BILL-OPTION-CD = IMMEDIATE-BILL                  
                  PERFORM 2500-CALCULATE-DNP-DATE       THRU 2500-EXIT  
                  MOVE VALUE-NO TO WS-NO-MAINT-SW                       
PCR263            PERFORM 2910-PROCESS-NOTICES          THRU 2910-EXIT  
                  PERFORM 2950-NOTIFY-CREDIT-COL        THRU 2950-EXIT  
                  MOVE VALUE-NO TO WS-NO-MAINT-SW                       
                  PERFORM 2960-SUM-AR-CONTROL           THRU 2960-EXIT  
                  PERFORM 2961-SET-AR-CONTROL           THRU 2961-EXIT  
      *           PERFORM 2980-INSERT-OFF-CYCLE         THRU 2980-EXIT  12500002
T21068            PERFORM 2710-GET-TIMESTAMP-AND-DATE   THRU 2710-EXIT  
T21068            MOVE CURRENT-TIMESTAMP   TO AT-LAST-UPDATE-TS         
                  PERFORM 2990-ADD-AR-BALANCE           THRU 2990-EXIT  
               END-IF                                                   
T10841         PERFORM 2900-ALTER-AT-CODES              THRU 2900-EXIT  
      *                                                                 12560002
           ELSE IF (PARM-ACTION-CODE = UPDATE-DEPOSIT)                  
TP5519         PERFORM 7000-SELECT-DEP-ON-HAND          THRU 7000-EXIT  
TP5519         PERFORM 7100-SELECT-DEP-REQ              THRU 7100-EXIT  
               PERFORM 2400-UPDATE-DEPHND-DETAIL        THRU 2400-EXIT  
               PERFORM 2401-UPDATE-DEPREQ-DETAIL        THRU 2401-EXIT  
T26296         IF ((PARM-BILL-OPTION-CD = IMMEDIATE-BILL) AND           
T26296               (PARM-ORIG-BILL-OPTION-CD NOT = IMMEDIATE-BILL) AND
T26296               (PARM-CODE-DEP-TYPE EQUAL 'B'))                    
T26296            PERFORM 7455-GET-RECONNECT-AMT        THRU 7455-EXIT  
T26296            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL        
T26296               MOVE DL-AMT-TOT-RECONNECT TO WS-ORIG-AMT-TOT-RCNT  
T26296               ADD DO-AMT-DEPOSIT        TO DL-AMT-TOT-RECONNECT  
T26296               PERFORM 8050-UPDATE-RECONNECT-AMT  THRU 8050-EXIT  
T26296            ELSE                                                  
T26296               MOVE ZERO                 TO WS-ORIG-AMT-TOT-RCNT, 
T26296                                            DL-AMT-TOT-RECONNECT  
T26296            END-IF                                                
T26296         END-IF                                                   
               PERFORM 2700-PERFORM-JOURNALING          THRU 2700-EXIT  
               IF PARM-BILL-OPTION-CD NOT = PARM-ORIG-BILL-OPTION-CD    
                   IF PARM-DEP-ACTION-CODE = REBILLED                   
T21068                PERFORM 2710-GET-TIMESTAMP-AND-DATE               
T21068                                                  THRU 2710-EXIT  
T21068                MOVE CURRENT-TIMESTAMP                            
T21068                                     TO AT-LAST-UPDATE-TS         
                      PERFORM 2992-REBILL-AR-BALANCE    THRU 2992-EXIT  
                   END-IF                                               
                   PERFORM 2201-UPDATE-ARCNTL-DETAIL    THRU 2201-EXIT  
                   PERFORM 2960-SUM-AR-CONTROL          THRU 2960-EXIT  
                   PERFORM 2961-SET-AR-CONTROL          THRU 2961-EXIT  
               END-IF                                                   
               IF ((PARM-BILL-OPTION-CD = IMMEDIATE-BILL) AND           
                   (PARM-ORIG-BILL-OPTION-CD NOT = IMMEDIATE-BILL))     
                  MOVE WS-AMT-ORIG-ENTERED TO AGING-BUCKET-DAY-00       
                  PERFORM 2201-UPDATE-ARCNTL-DETAIL     THRU 2201-EXIT  
                  MOVE VALUE-ZERO          TO AGING-BUCKET-DAY-00       
                  PERFORM 2500-CALCULATE-DNP-DATE       THRU 2500-EXIT  
                  MOVE VALUE-YES TO WS-NO-MAINT-SW                      
PCR263            PERFORM 2910-PROCESS-NOTICES          THRU 2910-EXIT  
                  PERFORM 2950-NOTIFY-CREDIT-COL        THRU 2950-EXIT  
                  MOVE VALUE-NO TO WS-NO-MAINT-SW                       
                  PERFORM 2960-SUM-AR-CONTROL           THRU 2960-EXIT  
                  PERFORM 2961-SET-AR-CONTROL           THRU 2961-EXIT  
      *           PERFORM 2980-INSERT-OFF-CYCLE         THRU 2980-EXIT  13000002
T21068            PERFORM 2710-GET-TIMESTAMP-AND-DATE   THRU 2710-EXIT  
T21068            MOVE CURRENT-TIMESTAMP   TO AT-LAST-UPDATE-TS         
                  PERFORM 2990-ADD-AR-BALANCE           THRU 2990-EXIT  
               ELSE IF ((PARM-BILL-OPTION-CD NOT = IMMEDIATE-BILL) AND  
                        (PARM-ORIG-BILL-OPTION-CD = IMMEDIATE-BILL))    
PCR263            PERFORM 2110-CHECK-CRED-COLL          THRU 2110-EXIT  
PCR263            IF CL-DATE-BILL = CURRENT-DATE                        
PCR263                MOVE WS-I          TO DEPOSIT-MESSAGE-TYPE        
PCR263                PERFORM 2951-DELETE-CREDIT-COL    THRU 2951-EXIT  
PCR263                MOVE WS-O          TO DEPOSIT-MESSAGE-TYPE        
PCR263                PERFORM 2951-DELETE-CREDIT-COL    THRU 2951-EXIT  
PCR263            ELSE                                                  
PCR263                MOVE WS-I          TO DEPOSIT-MESSAGE-TYPE        
PCR263                PERFORM 2111-CHECK-DNP-ROW        THRU 2111-EXIT  
PCR263                IF WS-DNP-ROW-EXISTS EQUAL VALUE-YES              
PCR263                   PERFORM 2951-DELETE-CREDIT-COL THRU 2951-EXIT  
PCR263                END-IF                                            
PCR263            END-IF                                                
                  PERFORM 2960-SUM-AR-CONTROL           THRU 2960-EXIT  
                  PERFORM 2961-SET-AR-CONTROL           THRU 2961-EXIT  
      *           PERFORM 2981-DELETE-OFF-CYCLE         THRU 2981-EXIT  13210002
T21068            PERFORM 2710-GET-TIMESTAMP-AND-DATE   THRU 2710-EXIT  
T21068            MOVE CURRENT-TIMESTAMP TO AT-LAST-UPDATE-TS           
                  PERFORM 2991-SUBTRACT-AR-BALANCE      THRU 2991-EXIT  
               END-IF                                                   
T21202*                                                                 13260002
T21202         PERFORM 2710-GET-TIMESTAMP-AND-DATE      THRU 2710-EXIT  
T21202         MOVE CURRENT-TIMESTAMP    TO AT-LAST-UPDATE-TS           
T32545         PERFORM 7999-UPDATE-AT-TIMESTAMP         THRU 7999-EXIT  
T21202*                                                                 13300002
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 13320002
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
      *                                                                 13340002
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13370002
REARCH***************************************************************** 13380002
REARCH*                                                               * 13390002
REARCH* 2000A-MOVE-RESULT.                                            * 13400002
REARCH*                                                               * 13410002
REARCH***************************************************************** 13420002
REARCH*                                                                 13430002
REARCH*                                                                 13440002
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                 13460002
REARCH     MOVE  RS-ERROR-CODE           TO S-ERROR-CODE.               
REARCH     MOVE  RS-AR-LOCKOUT-IND       TO S-AR-LOCKOUT-IND.           
REARCH     MOVE  RS-ACCT-XFER-TO         TO S-ACCT-XFER-TO.             
REARCH     MOVE  RS-RETURN-CODE          TO S-RETURN-CODE.              
T26296     MOVE  RS-ABEND-PROGRAM        TO S-ABEND-PROGRAM.            
T26296     MOVE  RS-ACTIVE-PARA          TO S-ACTIVE-PARA.              
T26296     MOVE  RS-ABEND-FUNCTION       TO S-ABEND-FUNCTION.           
T26296     MOVE  RS-ABEND-TABLE          TO S-ABEND-TABLE.              
T26296     MOVE  RS-TABLE-ELMT-1         TO S-TABLE-ELMT-1.             
T26296     MOVE  RS-TABLE-ELMT-2         TO S-TABLE-ELMT-2.             
T26296     MOVE  RS-TABLE-ELMT-3         TO S-TABLE-ELMT-3.             
T26296     MOVE  RS-TABLE-ELMT-4         TO S-TABLE-ELMT-4.             
T26296     MOVE  RS-HOSTVAR-ELMT-1       TO S-HOSTVAR-ELMT-1.           
T26296     MOVE  RS-HOSTVAR-ELMT-2       TO S-HOSTVAR-ELMT-2.           
T26296     MOVE  RS-HOSTVAR-ELMT-3       TO S-HOSTVAR-ELMT-3.           
T26296     MOVE  RS-HOSTVAR-ELMT-4       TO S-HOSTVAR-ELMT-4.           
REARC2     ADD   +1  TO CTR-ROWS.                                       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 13660002
      ******************************************************************13670002
      * 2110-CHECK-CRED-COLL                                           *13680002
      *     -- THIS MODULE PERFORMS A CHECK TO SEE IF A CUT DATE NOTICE*13690002
      *        HAS ALREADY BEEN ESTABLISHED FOR A DEPOSIT NOTICE ON    *13700002
      *        THE CURRENT DATE.  IF ONE EXISTS, THEN ALL PROCESSING   *13710002
      *        WILL TERMINATE SINCE BUSINESS RULES WILL NOT ALLOW TWO  *13720002
      *        IMMEDIATE BILLING DEPOSITS TO BE ESTABLISHED ON THE SAME*13730002
      *        DAY.                                                    *13740002
      ******************************************************************13750002
       2110-CHECK-CRED-COLL.                                            
      *                                                                 13770002
PCR263     MOVE VALUE-NO                 TO CRED-COLL-EXISTS            
PCR263*                                                                 13790002
           EXEC SQL                                                     
PCR263         SELECT DATE_CREDIT_ACTION,                               
PCR263                DATE_BILL                                         
T26296           INTO :CL-DATE-CREDIT-ACTION :WS-NULL-INDICATOR-1,       
T26296                :CL-DATE-BILL :WS-NULL-INDICATOR-2                 
PCR263           FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
PCR263          WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
PCR263            AND CODE_NOTICE_TYPE = :DEPOSIT-MESSAGE-TYPE          
PCR263            AND DATE_BILL        = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     13800002
MFA-TR*        SELECT DATE_CREDIT_ACTION,                               13810002
MFA-TR*               DATE_BILL                                         13820002
MFA-TR*          INTO :CL-DATE-CREDIT-ACTION:WS-NULL-INDICATOR-1,       13830002
MFA-TR*               :CL-DATE-BILL:WS-NULL-INDICATOR-2                 13840002
MFA-TR*          FROM CSS_CRED_COLL                                     13850002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 13860002
MFA-TR*           AND CODE_NOTICE_TYPE = :DEPOSIT-MESSAGE-TYPE          13870002
MFA-TR*           AND DATE_BILL        = CURRENT DATE                   13880002
MFA-TR*         WITH UR                                                 13890002
MFA-TR*    END-EXEC.                                                    13900002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13910002
      *                                                                 13920002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 13950002
PCR263     IF  SQLCODE = SUCCESSFUL-CALL                                
PCR263        MOVE  VALUE-YES            TO CRED-COLL-EXISTS            
PCR263     ELSE                                                         
PCR263        IF SQLCODE = NOT-FOUND                                    
PCR263            NEXT SENTENCE                                         
PCR263        ELSE                                                      
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '2110'            TO ACTIVE-PARAGRAPH            
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
CBSI              MOVE SPACES            TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
                  MOVE 'CSS_CRED_COLL'   TO TABLE-1                     
                  MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
T15605            MOVE 'CODE_NOTICE_TYPE' TO TABLE-ELEMENT-2            
T15605            MOVE WS-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
T15605            MOVE DEPOSIT-MESSAGE-TYPE TO HOSTVAR-ELEMENT-2        
PCR263            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
PCR263        END-IF                                                    
           END-IF.                                                      
      *                                                                 14150002
      *                                                                 14160002
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14190002
PCR263*                                                                 14200002
PCR263******************************************************************14210002
PCR263* 2111-CHECK-DNP-ROW                                             *14220002
PCR263*     -- THIS MODULE PERFORMS A CHECK TO SEE IF A CUT DATE NOTICE*14230002
PCR263*        HAS ALREADY BEEN ESTABLISHED FOR A DEPOSIT NOTICE ON    *14240002
PCR263*        THE CURRENT DATE.  IF ONE EXISTS, THEN ALL PROCESSING   *14250002
PCR263*        WILL TERMINATE SINCE BUSINESS RULES WILL NOT ALLOW TWO  *14260002
PCR263*        IMMEDIATE BILLING DEPOSITS TO BE ESTABLISHED ON THE SAME*14270002
PCR263*        DAY.                                                    *14280002
PCR263******************************************************************14290002
PCR263 2111-CHECK-DNP-ROW.                                              
PCR263*                                                                 14310002
PCR263     EXEC SQL                                                     
PCR263         SELECT 'Y'                                               
PCR263           INTO :WS-DNP-ROW-EXISTS                                
PCR263           FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
PCR263          WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
PCR263            AND CODE_NOTICE_TYPE = :DEPOSIT-MESSAGE-TYPE          
PCR263            AND DATE_BILL        < CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
PCR263            AND DATE_CREDIT_ACTION >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
A37061                                                           
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     14320002
MFA-TR*        SELECT 'Y'                                               14330002
MFA-TR*          INTO :WS-DNP-ROW-EXISTS                                14340002
MFA-TR*          FROM CSS_CRED_COLL                                     14350002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 14360002
MFA-TR*           AND CODE_NOTICE_TYPE = :DEPOSIT-MESSAGE-TYPE          14370002
MFA-TR*           AND DATE_BILL        < CURRENT DATE                   14380002
MFA-TR*           AND DATE_CREDIT_ACTION >= CURRENT DATE                14390002
MFA-TR*         WITH UR                                                 14400002
MFA-TR*    END-EXEC.                                                    14410002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263*                                                                 14420002
PCR263*                                                                 14430002
PCR263     MOVE SQLCODE                  TO RS-RETURN-CODE.             
PCR263     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
PCR263*                                                                 14460002
PCR263     IF  SQLCODE = SUCCESSFUL-CALL                                
PCR263        MOVE  VALUE-YES            TO WS-DNP-ROW-EXISTS           
PCR263     ELSE                                                         
PCR263        IF SQLCODE = NOT-FOUND                                    
PCR263            NEXT SENTENCE                                         
PCR263        ELSE                                                      
PCR263            MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
CBSI              MOVE '2111'            TO ACTIVE-PARAGRAPH            
PCR263            MOVE 'SELECT'          TO ABEND-FUNCTION              
CBSI              MOVE SPACES            TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
PCR263            MOVE 'CSS_CRED_COLL'   TO TABLE-1                     
PCR263            MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
T15605            MOVE 'CODE_NOTICE_TYPE' TO TABLE-ELEMENT-2            
T15605            MOVE WS-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
T15605            MOVE DEPOSIT-MESSAGE-TYPE TO HOSTVAR-ELEMENT-2        
PCR263            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
PCR263        END-IF                                                    
PCR263     END-IF.                                                      
PCR263 2111-EXIT.                                                       
PCR263     EXIT.                                                        
      *                                                                 14680002
      ******************************************************************14690002
      * 2150-CHECK-FOR-DEPOSIT                                         *14700002
      *     -- THIS MODULE PERFORMS A CHECK ON CSS_DEP_ON_HAND TO      *14710002
      *        SEE IF DEPOSIT DETAIL EXISTS FOR AN ACCOUNT. IF         *14720002
      *        NOT, A FLAG WILL BE SET THAT WILL SIGNAL WRITING A      *14730002
      *        SUMMARY RECORD TO THE CSS_AR_CNTRL TABLE.  IN EITHER    *14740002
      *        CASE, A DETAIL ROW WILL BE WRITTEN TO THE CSS_AR_CNTL   *14750002
      *        AND CSS_DEP_ON_HAND AND CSS_DEP_REQ TABLES.             *14760002
      ******************************************************************14770002
       2150-CHECK-FOR-DEPOSIT.                                          
      *                                                                 14790002
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :DEPOSIT-EXISTS                                   
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL = 80                            
                  AND ITEM_ID = 0                                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14800002
MFA-TR*        SELECT 'Y'                                               14810002
MFA-TR*          INTO :DEPOSIT-EXISTS                                   14820002
MFA-TR*          FROM CSS_AR_CNTL                                       14830002
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       14840002
MFA-TR*           AND PYMT_PRIORITY_LVL = 80                            14850002
MFA-TR*           AND ITEM_ID = 0                                       14860002
MFA-TR*         WITH UR                                                 14870002
MFA-TR*    END-EXEC.                                                    14880002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14890002
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
      *                                                                 14920002
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
                    (SQLCODE EQUAL TO NOT-FOUND))                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 15070002
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15100002
      ******************************************************************15110002
      * 2160-CHECK-ACTIVE-DEP                                          *15120002
      *     -- THIS MODULE PERFORMS A CHECK ON CSS_DEP_ON_HAND &       *15130002
      *        CSS_DEP_REQ FOR EXISTING ACTIVE IMMEDIATE DEPOSITS.     *15140002
      *        IF IT EXISTS, IT WILL ABORT WITH AN ERROR, OTHERWISE    *15150002
      *        IT WILL ALLOW THE INSERTION OF THE DEPOSIT REQUEST.     *15160002
      * ADDED BY MR - 5/20/96 ; TPR 3587                               *15170002
      ******************************************************************15180002
       2160-CHECK-ACTIVE-DEP.                                           
      *                                                                 15200002
           MOVE WS-ACCOUNT-NO               TO DO-ACCOUNT-NO.           
      *                                                                 15220002
           EXEC SQL                                                     
               SELECT 'Y'                                               
               INTO   :ACTIVE-DEPOSIT-EXISTS                            
T24646         FROM   CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED),              
                      CSS_DEP_REQ DR WITH(READUNCOMMITTED)                      
               WHERE  DO.ACCOUNT_NO         = :DO-ACCOUNT-NO            
               AND    DO.DEPOSIT_STATUS_CD  = :ACTIVE                   
               AND    DR.PYMT_PRIORITY_LVL  = :DEP-PYMT-PRIORITY-LVL    
               AND    DR.DEP_BILL_OPTION_CD = :IMMEDIATE-BILL           
               AND    DO.DEPOSIT_CERT_NO    =  DR.DEP_ITEM_ID           
               AND    DO.ACCOUNT_NO         =  DR.ACCOUNT_NO            
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15230002
MFA-TR*        SELECT 'Y'                                               15240002
MFA-TR*        INTO   :ACTIVE-DEPOSIT-EXISTS                            15250002
MFA-TR*        FROM   CSS_DEP_ON_HAND AS DO,                            15260002
MFA-TR*               CSS_DEP_REQ DR                                    15270002
MFA-TR*        WHERE  DO.ACCOUNT_NO         = :DO-ACCOUNT-NO            15280002
MFA-TR*        AND    DO.DEPOSIT_STATUS_CD  = :ACTIVE                   15290002
MFA-TR*        AND    DR.PYMT_PRIORITY_LVL  = :DEP-PYMT-PRIORITY-LVL    15300002
MFA-TR*        AND    DR.DEP_BILL_OPTION_CD = :IMMEDIATE-BILL           15310002
MFA-TR*        AND    DO.DEPOSIT_CERT_NO    =  DR.DEP_ITEM_ID           15320002
MFA-TR*        AND    DO.ACCOUNT_NO         =  DR.ACCOUNT_NO            15330002
MFA-TR*        WITH UR                                                  15340002
MFA-TR*    END-EXEC.                                                    15350002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15360002
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
      *                                                                 15390002
      ************************************************************      15400002
      * IF A DEPOSIT IS FOUND SEND BACK ERROR CODE = 'Y'                15410002
      *************************************************************     15420002
           IF (SQLCODE EQUAL TO SUCCESSFUL-CALL)                        
              MOVE SPACES                TO PARM-ACTION-CODE            
              MOVE 'IMMED-DEP-FOUND'     TO RS-ERROR-CODE               
           ELSE IF  (SQLCODE EQUAL TO NOT-FOUND)                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2160'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'CSS_DEP_REQ'         TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
T15605        MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 15620002
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15650002
      *                                                                 15660002
      ******************************************************************15670002
      * 2175-SELECT-MAX-CERT-NO.                                        15680002
      *    -- THIS MODULE SELECT THE MAX CERT NO FROM CSS_DEP_ON_HAND   15690002
      ******************************************************************15700002
       2175-SELECT-MAX-CERT-NO.                                         
      *                                                                 15720002
           EXEC SQL                                                     
               SELECT MAX(DEPOSIT_CERT_NO)                              
                 INTO :MAX-DEPOSIT-CERT-NO :MAX-DEPOSIT-IND              
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15730002
MFA-TR*        SELECT MAX(DEPOSIT_CERT_NO)                              15740002
MFA-TR*          INTO :MAX-DEPOSIT-CERT-NO:MAX-DEPOSIT-IND              15750002
MFA-TR*          FROM CSS_DEP_ON_HAND                                   15760002
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       15770002
MFA-TR*         WITH UR                                                 15780002
MFA-TR*    END-EXEC.                                                    15790002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15800002
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
      *                                                                 15830002
           IF ((SQLCODE EQUAL SUCCESSFUL-CALL) AND                      
                                (MAX-DEPOSIT-IND = -1))                 
              MOVE 0                     TO MAX-DEPOSIT-CERT-NO         
           ELSE IF ((SQLCODE EQUAL SUCCESSFUL-CALL) AND                 
                                (MAX-DEPOSIT-IND = 0))                  
              CONTINUE                                                  
      *                                                                 15900002
           ELSE IF ((SQLCODE NOT EQUAL TO SUCCESSFUL-CALL) AND          
                    (SQLCODE NOT EQUAL TO NOT-FOUND))                   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2175'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
PCR263     END-IF
                END-IF
           END-IF.                                                      
      *                                                                 16030002
       2175-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16060002
      *                                                                 16070002
      ******************************************************************16080002
      * 2200-WRITE-ARCNTL-DETAIL.                                      *16090002
      *    -- THIS MODULE WRITES DEPOSIT RECORDS TO THE                *16100002
      *       CSS_AR_CNTL TABLE FOR THIS ACCOUNT.                      *16110002
      ******************************************************************16120002
       2200-WRITE-ARCNTL-DETAIL.                                        
      *                                                                 16140002
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                   (ACCOUNT_NO,                                         
                    PYMT_PRIORITY_LVL,                                  
                    ITEM_ID,                                            
                    AMT_AR_DAY_00,                                      
                    AMT_AR_DAY_30,                                      
                    AMT_AR_DAY_60,                                      
                    AMT_AR_DAY_90,                                      
                    AMT_UNUSED_CR,                                      
                    AMT_TRAN_BALANCE,                                   
                    TOT_SUMM_UNBILLED,                                  
                    LAST_UPDATE_TS)                                     
               VALUES                                                   
                   (:WS-ACCOUNT-NO,                                     
                    :DEP-PYMT-PRIORITY-LVL,                             
                    :WS-DEPOSIT-CERT-NO-NO,                             
                    :AGING-BUCKET-DAY-00,                               
                    :ZERO-AMOUNT,                                       
                    :ZERO-AMOUNT,                                       
                    :ZERO-AMOUNT,                                       
                    :ZERO-AMOUNT,                                       
                    :WS-AMT-ORIG-ENTERED,                               
                    :ZERO-AMOUNT,                                       
                    CIS.CURRENT$TIMESTAMP())                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16150002
MFA-TR*        INSERT INTO CSS_AR_CNTL                                  16160002
MFA-TR*            (ACCOUNT_NO,                                         16170002
MFA-TR*             PYMT_PRIORITY_LVL,                                  16180002
MFA-TR*             ITEM_ID,                                            16190002
MFA-TR*             AMT_AR_DAY_00,                                      16200002
MFA-TR*             AMT_AR_DAY_30,                                      16210002
MFA-TR*             AMT_AR_DAY_60,                                      16220002
MFA-TR*             AMT_AR_DAY_90,                                      16230002
MFA-TR*             AMT_UNUSED_CR,                                      16240002
MFA-TR*             AMT_TRAN_BALANCE,                                   16250002
MFA-TR*             TOT_SUMM_UNBILLED,                                  16260002
MFA-TR*             LAST_UPDATE_TS)                                     16270002
MFA-TR*        VALUES                                                   16280002
MFA-TR*            (:WS-ACCOUNT-NO,                                     16290002
MFA-TR*             :DEP-PYMT-PRIORITY-LVL,                             16300002
MFA-TR*             :WS-DEPOSIT-CERT-NO-NO,                             16310002
MFA-TR*             :AGING-BUCKET-DAY-00,                               16320002
MFA-TR*             :ZERO-AMOUNT,                                       16330002
MFA-TR*             :ZERO-AMOUNT,                                       16340002
MFA-TR*             :ZERO-AMOUNT,                                       16350002
MFA-TR*             :ZERO-AMOUNT,                                       16360002
MFA-TR*             :WS-AMT-ORIG-ENTERED,                               16370002
MFA-TR*             :ZERO-AMOUNT,                                       16380002
MFA-TR*             CURRENT TIMESTAMP)                                  16390002
MFA-TR*    END-EXEC.                                                    16400002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16410002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 16440002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
T15605        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_TRAN_BALANCE'    TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-AMT-ORIG-ENTERED   TO HOSTVAR-ELEMENT-4-N         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16650002
      *                                                                 16660002
      ******************************************************************16670002
      *2201-UPDATE-ARCNTL-DETAIL.                                      *16680002
      *    -- THIS MODULE MOVES ZEROS INTO THE DEPOSIT RECORD IN THE   *16690002
      *       CSS_AR_CNTL TABLE WHEN AN UPDATE IS MADE AND PLACES THE  *16700002
      *       MONTHLY INSTALLATION AMOUNT IN THE 00 AGING BUCKET DAY *  16710002
      *       IF THE STATUS OF THE DEPOSIT RECORD IS "ACTIVE"*          16720002
      ******************************************************************16730002
       2201-UPDATE-ARCNTL-DETAIL.                                       
      *                                                                 16750002
           IF PARM-DEP-ACTION-CODE = REBILLED                           
               EXEC SQL                                                 
                   UPDATE CSS_AR_CNTL                                   
                      SET AMT_AR_DAY_00     = :AGING-BUCKET-DAY-00,     
                          AMT_AR_DAY_30     = :ZERO-AMOUNT,             
                          AMT_AR_DAY_60     = :ZERO-AMOUNT,             
                          AMT_AR_DAY_90     = :ZERO-AMOUNT,             
                          AMT_TRAN_BALANCE  = :WS-AMT-ORIG-ENTERED      
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    
                      AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           ELSE                                                         
               EXEC SQL                                                 
                   UPDATE CSS_AR_CNTL                                   
                      SET AMT_AR_DAY_00 = :AGING-BUCKET-DAY-00,         
                          AMT_AR_DAY_30 = :ZERO-AMOUNT,                 
                          AMT_AR_DAY_60 = :ZERO-AMOUNT,                 
                          AMT_AR_DAY_90 = :ZERO-AMOUNT                  
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    
                      AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           END-IF.                                                      
      *                                                                 17000002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 17030002
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2201'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-2             
T15605        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_AR_DAY_00'       TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
T15605        MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-3           
CBSI          MOVE AGING-BUCKET-DAY-00   TO HOSTVAR-ELEMENT-4-N         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 17240002
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17270002
      *                                                                 17280002
      ******************************************************************17290002
      * 2300-WRITE-DEPHND-DETAIL.                                      *12750000
      *    -- THIS MODULE WRITES DEPOSIT RECORDS TO THE CSS_DEP_ON_HAND*17310002
      *       TABLE FOR AN ACCOUNT.                                    *17320002
      ******************************************************************17330002
       2300-WRITE-DEPHND-DETAIL.                                        
      *                                                                 17350002
P00599     PERFORM 8000-INSERT-DEPHND-DETAIL THRU 8000-EXIT.            
P00599     IF DO-AUTO-DEP-LTR-IND = ('L' OR 'C')                        
P00599         INITIALIZE WS-CORRESP-HDR                                
P00599                    WS-CORRESP-NOTICE                             
P00599                    WS-CORRESP-VAR                                
P00599         IF PARM-BILL-OPTION-CD = (NEXT-BILLING OR INSTALLMENTS)  
P00599            MOVE '90814'           TO WS-CORRESP-MSG-ID           
P00599         ELSE                                                     
P00599            MOVE '90813'           TO WS-CORRESP-MSG-ID           
P00599         END-IF                                                   
P00599         MOVE WS-ACCOUNT-NO        TO WS-NOTICE-ACCOUNT-NO        
P00599         MOVE AT-COMPANY-NO        TO WS-CORRESP-COMPANY-NO       
P00599                                      WS-PROCESS-COMPANY-NO       
P00599         MOVE AT-LOCAL-OFFICE      TO WS-CWS350-LOCAL-OFFICE      
P00599         MOVE AT-CUSTOMER-NO       TO WS-NOTICE-CUSTOMER-NO       
P00599         MOVE ZEROES               TO WS-NOTICE-GUARANTOR-ACCT-NO 
P00599                                      WS-CORRESP-THD-PRTY-ID      
P00599         MOVE SPACES               TO WS-CORRESP-BARCODE-UNIQUE-ID
P00599         PERFORM 2710-GET-TIMESTAMP-AND-DATE                      
P00599                                       THRU 2710-EXIT             
P00599         MOVE CURRENT-DATE         TO WS-CORRESP-CREATE-DT        
P00599                                      WS-COMMON-DATE              
P00599                                      WS-CORRESP-STMT-DT          
P00599         MOVE PROGRAM-NAME         TO                             
P00599                                    WS-CORRESP-CREATED-BY-PGM-ID  
P00599                                    WS-CORRESP-LAST-UPDATE-PGM-ID 
P00599                                    WS-CALLING-PGM-NAME           
      *                                                                 18060002
P00599         MOVE WS-AMT-ORIG-ENTERED  TO WS-AUTO-DEP-CHARGED         
P00599         MOVE WS-DEPOSIT-CERT-NO-NO                               
P00599                                   TO WS-DEPOSIT-CERT-NUM         
P00599         MOVE WS-DEPOSIT-CERT-NO   TO WS-DO-DEPOSIT-CERT-NO       
P00599         PERFORM 2350-GET-DEP-RETAIN-MNTHS THRU 2350-EXIT         
P00599         PERFORM 5005-CALL-NOTICES         THRU 5005-EXIT         
           END-IF.                                                      
      *                                                                 18270002
      *                                                                 18280002
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18310002
      *                                                                 18320002
      ******************************************************************18330002
      * 2301-WRITE-DEPREQ-DETAIL                                       *18340002
      *    -- THIS MODULE WRITES DEPOSIT RECORDS TO THE CSS_DEP_REQ    *18350002
      *       TABLE FOR AN ACCOUNT.                                    *18360002
      ******************************************************************18370002
       2301-WRITE-DEPREQ-DETAIL.                                        
      *                                                                 18390002
           EXEC SQL                                                     
               INSERT INTO CSS_DEP_REQ                                  
                   (ACCOUNT_NO,                                         
                    PYMT_PRIORITY_LVL,                                  
                    DEP_ITEM_ID,                                        
                    DATE_TRAN,                                          
                    AMT_MO_PYMT,                                        
                    DATE_PYMT_START,                                    
                    NO_SCHED_PYMTS,                                     
                    AMT_ORIG_ENTERED,                                   
                    DEP_BILL_OPTION_CD,                                 
                    SERVICE_TYPE_CD,                                    
                    DEP_ACTION_CODE,                                    
                    REBILLED_DEP_AMT,                                   
                    REBILLED_DEP_DATE)                                  
               VALUES                                                   
                   (:WS-ACCOUNT-NO,                                     
                    :DEP-PYMT-PRIORITY-LVL,                             
                    :WS-DEPOSIT-CERT-NO-NO,                             
                    CAST(SYSDATETIMEOFFSET() AS DATE),                          
                    :WS-AMT-MO-PYMT-NO,                                 
                    CAST(SYSDATETIMEOFFSET() AS DATE),                          
                    :WS-NO-SCHED-PYMTS-NO,                              
                    :WS-AMT-ORIG-ENTERED,                               
                    :PARM-BILL-OPTION-CD,                               
                    :PARM-SERVICE-TYPE-CD,                              
                    :PARM-DEP-ACTION-CODE,                              
                    0,                                                  
                    IIF(TRY_CONVERT(DATE, :NULL-DATE :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :NULL-DATE :NULL-INDICATOR
              ) <> 0) OR (LEN(:NULL-DATE :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:NULL-DATE :NULL-INDICATOR
              ), CONVERT(DATE, :NULL-DATE :NULL-INDICATOR) ))                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18400002
MFA-TR*        INSERT INTO CSS_DEP_REQ                                  18410002
MFA-TR*            (ACCOUNT_NO,                                         18420002
MFA-TR*             PYMT_PRIORITY_LVL,                                  18430002
MFA-TR*             DEP_ITEM_ID,                                        18440002
MFA-TR*             DATE_TRAN,                                          18450002
MFA-TR*             AMT_MO_PYMT,                                        18460002
MFA-TR*             DATE_PYMT_START,                                    18470002
MFA-TR*             NO_SCHED_PYMTS,                                     18480002
MFA-TR*             AMT_ORIG_ENTERED,                                   18490002
MFA-TR*             DEP_BILL_OPTION_CD,                                 18500002
MFA-TR*             SERVICE_TYPE_CD,                                    18510002
MFA-TR*             DEP_ACTION_CODE,                                    18520002
MFA-TR*             REBILLED_DEP_AMT,                                   18530002
MFA-TR*             REBILLED_DEP_DATE)                                  18540002
MFA-TR*        VALUES                                                   18550002
MFA-TR*            (:WS-ACCOUNT-NO,                                     18560002
MFA-TR*             :DEP-PYMT-PRIORITY-LVL,                             18570002
MFA-TR*             :WS-DEPOSIT-CERT-NO-NO,                             18580002
MFA-TR*             CURRENT DATE,                                       18590002
MFA-TR*             :WS-AMT-MO-PYMT-NO,                                 18600002
MFA-TR*             CURRENT DATE,                                       18610002
MFA-TR*             :WS-NO-SCHED-PYMTS-NO,                              18620002
MFA-TR*             :WS-AMT-ORIG-ENTERED,                               18630002
MFA-TR*             :PARM-BILL-OPTION-CD,                               18640002
MFA-TR*             :PARM-SERVICE-TYPE-CD,                              18650002
MFA-TR*             :PARM-DEP-ACTION-CODE,                              18660002
MFA-TR*             0,                                                  18670002
MFA-TR*             :NULL-DATE:NULL-INDICATOR)                          18680002
MFA-TR*    END-EXEC.                                                    18690002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18700002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 18730002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2301'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
T15605        MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_MO_PYMT'         TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-AMT-MO-PYMT-NO     TO HOSTVAR-ELEMENT-4-N         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 18910002
      *                                                                 18920002
       2301-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18950002
      *                                                                 18960002
      ******************************************************************18970002
P00599* 2350-GET-DEP-RETAIN-MNTHS.                                     *12750000
P00599*    -- THIS MODULE GETS THE DEPOSIT RETAIN MONTHS FOR DIFFERENT *12760000
P00599*       CONDITIONS.                                              *12770000
P00599******************************************************************12780000
P00599*                                                                 13250000
P00599*                                                                 13260000
P00599  2350-GET-DEP-RETAIN-MNTHS.                                      
P00599*                                                                 13250000
P00599*                                                                 13260000
P00599     EVALUATE TRUE                                                
P00599       WHEN AT-ACCOUNT-TYPE-CODE = 'C'                            
P00599         MOVE 'RETAIN-COMMER-DEP'  TO  C8-DELINQ-CD               
P00599         PERFORM 7500-SELECT-DELINQ-VALUES  THRU 7500-EXIT        
P00599         MOVE C8-DELINQ-VALUE      TO WS-RETAIN-DEP               
P00599                                                                  
P00599       WHEN AT-ACCOUNT-TYPE-CODE = 'I'                            
P00599         MOVE 'RETAIN-INDUST-DEP'  TO  C8-DELINQ-CD               
P00599         PERFORM 7500-SELECT-DELINQ-VALUES  THRU 7500-EXIT        
P00599         MOVE C8-DELINQ-VALUE      TO WS-RETAIN-DEP               
P00599                                                                  
P00599       WHEN (AT-ACCOUNT-TYPE-CODE = 'R' AND AT-COMPANY-NO = '01') 
P00599         MOVE 'RETAIN-RESIDENT-DEP' TO  C8-DELINQ-CD              
P00599         PERFORM 7500-SELECT-DELINQ-VALUES  THRU 7500-EXIT        
P00599         MOVE C8-DELINQ-VALUE      TO WS-RETAIN-DEP               
P00599       WHEN OTHER                                                 
P00599         MOVE 12                   TO WS-RETAIN-DEP               
P00599     END-EVALUATE.                                                
P00599*                                                                 13250000
P00599*                                                                 13260000
P00599 2350-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 13290000
P00599*                                                                 13300000
      ******************************************************************13310000
      *2400-UPDATE-DEPHND-DETAIL.                                      *18980002
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *18990002
      *       CSS_DEP_ON_HAND TABLE.                                   *19000002
      ******************************************************************19010002
       2400-UPDATE-DEPHND-DETAIL.                                       
      *                                                                 19030002
P00599     PERFORM 8100-UPDATE-DEPHND        THRU 8100-EXIT.            
P00599     IF (PARM-AUTO-DEP-LTR-IND NOT EQUAL DO-AUTO-DEP-LTR-IND AND  
P00599        DO-AUTO-DEP-LTR-IND = 'L')                                
      *                                                                 19170002
P00599        MOVE WS-DEPOSIT-CERT-NO-NO TO WS-DEPOSIT-CERT-NUM         
P00599        MOVE 'DEP-CERT-NO'         TO 1K-CORRESP-VAR-NM           
P00599        MOVE WS-DEPOSIT-CERT-NO    TO 1K-CORRESP-VAR-CHAR         
P00599        MOVE AT-ACCOUNT-NO         TO 1J-ACCOUNT-NO               
P00599        MOVE 'I'                   TO 1J-CORRESP-STATUS-CD        
P00599        PERFORM 8200-GET-CORRESP-ID    THRU 8200-EXIT             
P00599        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00599           MOVE 'C'                TO 1J-CORRESP-STATUS-CD        
P00599           PERFORM 8300-UPDATE-CORRESP-HDR                        
P00599                                       THRU 8300-EXIT             
P00599        END-IF                                                    
           END-IF.                                                      
      *                                                                 19390002
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19420002
      *                                                                 19430002
T28160***************************************************************** 19440002
T28160* 2410-UPDATE-DEPHND-DETAIL2                                    * 19450002
T28160*     CALLS 9700-PROCESS-ABENDS                                 * 19460002
T28160*                                                               * 19470002
T28160*     UPDATES CSS_DEP_ON_HAND FOR PAID DEPOSITS                 * 19480002
T28160*                                                               * 19490002
T28160***************************************************************** 19500002
T28160                                                                  
T28160 2410-UPDATE-DEPHND-DETAIL2.                                      
T28160*                                                                 19530002
T28160     EXEC SQL                                                     
T28160         UPDATE CSS_DEP_ON_HAND                                   
T28160            SET CODE_DEP_TYPE     = :PARM-CODE-DEP-TYPE,          
T28160                CODE_REFUND_ELIG  = :PARM-CODE-REFUND-ELIG,       
T28160                COMMENTS          = :DO-COMMENTS                  
T28160          WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
T28160            AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO        
T28160     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28160*                                                                 19620002
T28160     MOVE SQLCODE                  TO RS-RETURN-CODE              
T28160                                      WS-ACTIVE-RETURN-CODE.      
T28160*                                                                 19650002
T28160     IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
T28160        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T28160        MOVE '2410'                TO ACTIVE-PARAGRAPH            
T28160        MOVE 'UPDATE'              TO ABEND-FUNCTION              
T28160        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T28160                                      ABEND-TABLES                
T28160        MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
T28160        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T28160        MOVE 'CODE_REFUND_ELIG'    TO TABLE-ELEMENT-2             
T28160        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T28160        MOVE PARM-CODE-REFUND-ELIG TO HOSTVAR-ELEMENT-2           
T28160        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T28160     END-IF.                                                      
T28160*                                                                 19790002
T28160 2410-EXIT.                                                       
T28160     EXIT.                                                        
T28160*                                                                 19820002
      ******************************************************************19830002
MAD512*2450-UPDATE-DEPHND-IMMED.                                       *19840002
      *    -- THIS MODULE UPDATES AN EXISTING BILL IMMEDIATE DEPOSIT   *19850002
      *       RECORD WITH ALLOWABLE UPDATE FIELDS.                     *19860002
      ******************************************************************19870002
       2450-UPDATE-DEPHND-IMMED.                                        
      *                                                                 19890002
           EXEC SQL                                                     
               UPDATE CSS_DEP_ON_HAND                                   
                  SET USER_ID_UPDT_BY   = :PARM-USER-ID-UPDT-BY,        
                      CODE_DEP_TYPE     = :PARM-CODE-DEP-TYPE,          
T31851                CODE_REFUND_ELIG  = :PARM-CODE-REFUND-ELIG,       
T31851                COMMENTS          = :DO-COMMENTS                  
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19990002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 20020002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2450'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
CBSI          MOVE 'USER_ID_UPDT_BY'     TO TABLE-ELEMENT-3             
CBSI          MOVE 'CODE_DEP_TYPE'       TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-USER-ID-UPDT-BY  TO HOSTVAR-ELEMENT-3           
CBSI          MOVE PARM-CODE-DEP-TYPE    TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 20200002
      *                                                                 20210002
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20240002
      *                                                                 20250002
      ******************************************************************20260002
      *2401-UPDATE-DEPREQ-DETAIL.                                      *20270002
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *20280002
      *       CSS_DEP_REQ TABLE.                                       *20290002
      ******************************************************************20300002
       2401-UPDATE-DEPREQ-DETAIL.                                       
      *                                                                 20320002
           IF ((PARM-DEP-ACTION-CODE = REBILLED) OR                     
               (PARM-BILL-OPTION-CD = PARM-ORIG-BILL-OPTION-CD))        
               EXEC SQL                                                 
                   UPDATE CSS_DEP_REQ                                   
                      SET AMT_MO_PYMT        = :WS-AMT-MO-PYMT-NO,      
                          NO_SCHED_PYMTS     = :WS-NO-SCHED-PYMTS-NO,   
                          DEP_BILL_OPTION_CD = :PARM-BILL-OPTION-CD,    
                          SERVICE_TYPE_CD    = :PARM-SERVICE-TYPE-CD,   
                          DEP_ACTION_CODE    = :PARM-DEP-ACTION-CODE,   
                          REBILLED_DEP_AMT   = :WS-AMT-ORIG-ENTERED,    
                          REBILLED_DEP_DATE  = CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                    WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO           
                      AND DEP_ITEM_ID        = :WS-DEPOSIT-CERT-NO-NO   
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*        EXEC SQL                                                 20350002
MFA-TR*            UPDATE CSS_DEP_REQ                                   20360002
MFA-TR*               SET AMT_MO_PYMT        = :WS-AMT-MO-PYMT-NO,      20370002
MFA-TR*                   NO_SCHED_PYMTS     = :WS-NO-SCHED-PYMTS-NO,   20380002
MFA-TR*                   DEP_BILL_OPTION_CD = :PARM-BILL-OPTION-CD,    20390002
MFA-TR*                   SERVICE_TYPE_CD    = :PARM-SERVICE-TYPE-CD,   20400002
MFA-TR*                   DEP_ACTION_CODE    = :PARM-DEP-ACTION-CODE,   20410002
MFA-TR*                   REBILLED_DEP_AMT   = :WS-AMT-ORIG-ENTERED,    20420002
MFA-TR*                   REBILLED_DEP_DATE  = CURRENT DATE             20430002
MFA-TR*             WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO           20440002
MFA-TR*               AND DEP_ITEM_ID        = :WS-DEPOSIT-CERT-NO-NO   20450002
MFA-TR*        END-EXEC                                                 20460002
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           ELSE                                                         
               EXEC SQL                                                 
                   UPDATE CSS_DEP_REQ                                   
                      SET AMT_MO_PYMT        = :WS-AMT-MO-PYMT-NO,      
                          NO_SCHED_PYMTS     = :WS-NO-SCHED-PYMTS-NO,   
                          DEP_BILL_OPTION_CD = :PARM-BILL-OPTION-CD,    
                          SERVICE_TYPE_CD    = :PARM-SERVICE-TYPE-CD,   
                          DEP_ACTION_CODE    = :PARM-DEP-ACTION-CODE    
                    WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO           
                      AND DEP_ITEM_ID        = :WS-DEPOSIT-CERT-NO-NO   
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           END-IF.                                                      
      *                                                                 20590002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 20620002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2401'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-2             
CBSI          MOVE 'AMT_MO_PYMT'         TO TABLE-ELEMENT-3             
CBSI          MOVE 'DEP_BILL_OPTION_CD'  TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
CBSI          MOVE WS-AMT-MO-PYMT-NO     TO HOSTVAR-ELEMENT-3-N         
CBSI          MOVE PARM-BILL-OPTION-CD   TO HOSTVAR-ELEMENT-4           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 20800002
      *                                                                 20810002
       2401-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20840002
      ******************************************************************20850002
      *2500-CALCULATE-DNP-DATE.                                        *20860002
      *    -- THIS MODULE CALCULATES DNP DATE FOR IMMEDIATE BILLING    *20870002
      ******************************************************************20880002
PCR263 2500-CALCULATE-DNP-DATE.                                         
      *                                                                 20900002
PCR263     MOVE CURRENT-DATE                    TO WS-WORK-DATE.        
PCR263     PERFORM 1800-GET-NEXT-BUSINESS-DAY   THRU 1800-EXIT          
PCR263          VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL            
PCR263          WS-NEXT-DATE-COUNT GREATER THAN 5.                      
PCR263     MOVE WS-WORK-DATE                    TO WS-PLUS-5-WDAYS.     
PCR263*                                                                 20960002
PCR263     MOVE CURRENT-DATE                    TO WS-WORK-DATE.        
A04527     PERFORM 1870-CHECK-NONBUSINESS-DATE  THRU 1870-EXIT          
A04527     IF NONBUSINESS-DATE                                          
A04527        PERFORM 1800-GET-NEXT-BUSINESS-DAY   THRU 1800-EXIT       
A04527          VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL            
A04527          WS-NEXT-DATE-COUNT GREATER THAN 10                      
A04527     ELSE                                                         
A04527        PERFORM 1800-GET-NEXT-BUSINESS-DAY   THRU 1800-EXIT       
A04527          VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL            
A04527          WS-NEXT-DATE-COUNT GREATER THAN 9                       
A04527     END-IF.                                                      
PCR263     MOVE WS-WORK-DATE                    TO WS-PLUS-9-WDAYS.     
PCR263*                                                                 21020002
PCR263     MOVE CURRENT-DATE                    TO WS-WORK-DATE.        
A36839     PERFORM 1870-CHECK-NONBUSINESS-DATE  THRU 1870-EXIT          
A36839     IF NONBUSINESS-DATE                                          
A36839        PERFORM 1800-GET-NEXT-BUSINESS-DAY  THRU 1800-EXIT        
A36839            VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL          
A36839            WS-NEXT-DATE-COUNT GREATER THAN 11                    
A36839     ELSE                                                         
PCR263        PERFORM 1800-GET-NEXT-BUSINESS-DAY   THRU 1800-EXIT       
PCR263             VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL         
PCR263             WS-NEXT-DATE-COUNT GREATER THAN 10                   
A36839     END-IF                                                       
PCR263     MOVE WS-WORK-DATE                    TO WS-PLUS-10-WDAYS.    
PCR263*                                                                 21150002
           MOVE WS-PLUS-10-WDAYS                TO WS-WORK-DATE.        
           PERFORM 1800-GET-NEXT-BUSINESS-DAY   THRU 1800-EXIT          
                VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL            
                WS-NEXT-DATE-COUNT GREATER THAN 5.                      
           MOVE WS-WORK-DATE                    TO WS-PLUS-15-WDAYS.    
      *                                                                 21210002
PCR263 2500-EXIT.                                                       
PCR263     EXIT.                                                        
      ******************************************************************21240002
      *  2550-NOTICE-DATE.                                             *21250002
      *    -- THIS MODULE CALCULATES DATE NOTICE SHOULD BE SENT        *21260002
      ******************************************************************21270002
       2550-NOTICE-DATE.                                                
      *                                                                 21290002
            MOVE CURRENT-DATE          TO WS-WORK-DATE.                 
      *                                                                 21310002
A36839      IF NONBUSINESS-DATE                                         
A36839         PERFORM 1800-GET-NEXT-BUSINESS-DAY  THRU 1800-EXIT       
A36839             VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL         
A36839             WS-NEXT-DATE-COUNT GREATER THAN 2                    
A36839      ELSE                                                        
PCR263         PERFORM 1800-GET-NEXT-BUSINESS-DAY  THRU 1800-EXIT       
PCR263             VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL         
PCR263             WS-NEXT-DATE-COUNT GREATER THAN 1                    
A36839      END-IF                                                      
A36839      MOVE  VALUE-NO             TO WS-NONBUSINESS-DATE           
            MOVE WS-WORK-DATE          TO WS-NOTICE-DATE.               
      *                                                                 21430002
       2550-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************21460002
      * 2700-PERFORM-JOURNALING.                                       *21470002
      *    -- THIS MODULE PREPARES WORKING STORAGE VARIABLES FOR THE   *21480002
      *       JOURNALING PROCESSING THAT IS TO BE COMPLETED AS A       *21490002
      *       RESULT OF INSERTING/UPDATING A DEPOSIT RECORD.           *21500002
      ******************************************************************21510002
       2700-PERFORM-JOURNALING.                                         
      *                                                                 21530002
           MOVE WS-N                   TO WS-AGING-CORRECT-SW.          
           PERFORM 2710-GET-TIMESTAMP-AND-DATE        THRU 2710-EXIT.   
           PERFORM 2720-GET-RESP-AREA-ID              THRU 2720-EXIT.   
           PERFORM 2730-GET-ACCOUNT-INFO              THRU 2730-EXIT.   
           PERFORM 2740-GET-GL-ACCT                   THRU 2740-EXIT.   
           PERFORM 2741-GET-GL-ACCT-2                 THRU 2741-EXIT.   
      *                                                                 21600002
           IF PARM-ACTION-CODE = UPDATE-DEPOSIT                         
               IF PARM-BILL-OPTION-CD = IMMEDIATE-BILL                  
                AND PARM-ORIG-BILL-OPTION-CD NOT EQUAL IMMEDIATE-BILL   
                   MOVE WS-Y               TO WS-AGING-CORRECT-SW       
               END-IF                                                   
PCR404         PERFORM 5100-MOVE-TRAN-HEAD            THRU 5100-EXIT    
PCR404         MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               IF CORRECTION-OF-AGING                                   
                OR PARM-DEP-ACTION-CODE = REBILLED                      
                   PERFORM 2810-MISCELLANEOUS-113     THRU 2810-EXIT    
                   PERFORM 2750-AR-TRANS-JOURNALING   THRU 2750-EXIT    
               END-IF                                                   
TP5519         PERFORM 5200-MOVE-TRAN-DET-UPD         THRU 5200-EXIT    
           ELSE                                                         
               PERFORM 2750-AR-TRANS-JOURNALING       THRU 2750-EXIT    
               PERFORM 2760-CASH-DRAWER-101           THRU 2760-EXIT    
           END-IF.                                                      
      *                                                                 21780002
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21810002
      *                                                                 21820002
      ******************************************************************21830002
      * 2710-GET-TIMESTAMP-AND-DATE.                                   *21840002
      *   -- THIS MODULE OBTAINS THE CURRENT TIME AND DATE FOR CRATING *21850002
      *      THE JOURNAL ENTRIES.                                      *21860002
      ******************************************************************21870002
       2710-GET-TIMESTAMP-AND-DATE.                                     
      *                                                                 21890002
T34097     EXEC SQL                                                     
T34097         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-TIMESTAMP,
              :CURRENT-DATE                
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21900002
MFA-TR*        SET  :CURRENT-TIMESTAMP   =  CURRENT TIMESTAMP           21910002
MFA-TR*            ,:CURRENT-DATE        =  CURRENT DATE                21920002
MFA-TR*    END-EXEC.                                                    21930002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21940002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 21970002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2710'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 22080002
      *                                                                 22090002
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22120002
      *                                                                 22130002
      ******************************************************************22140002
      * 2720-GET-RESP-AREA-ID                                          *22150002
      *    -- THIS MODULE OBTAINS THE USER'S RESPONSIBLE AREA ID.      *22160002
      ******************************************************************22170002
        2720-GET-RESP-AREA-ID.                                          
      *                                                                 22190002
           EXEC SQL                                                     
               SELECT RESP_AREA_ID,                                     
                      CASH_DRAWER                                       
                 INTO :PF-RESP-AREA-ID,                                 
                      :PF-CASH-DRAWER                                   
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PARM-USER-ID-UPDT-BY                   
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22200002
MFA-TR*        SELECT RESP_AREA_ID,                                     22210002
MFA-TR*               CASH_DRAWER                                       22220002
MFA-TR*          INTO :PF-RESP-AREA-ID,                                 22230002
MFA-TR*               :PF-CASH-DRAWER                                   22240002
MFA-TR*          FROM CSS_USER_PROFILE                                  22250002
MFA-TR*         WHERE USER_ID = :PARM-USER-ID-UPDT-BY                   22260002
MFA-TR*         WITH UR                                                 22270002
MFA-TR*    END-EXEC.                                                    22280002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22290002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 22320002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2720'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
T15605        MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
T15605        MOVE PARM-USER-ID-UPDT-BY  TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 22460002
      *                                                                 22470002
       2720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22500002
      *                                                                 22510002
      ******************************************************************22520002
      * 2730-GET-ACCOUNT-INFO                                          *22530002
      *    -- THIS MODULE OBTAINS INFORMATION ON A SPECIFIC ACCOUNT    *22540002
      ******************************************************************22550002
        2730-GET-ACCOUNT-INFO.                                          
      *                                                                 22570002
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
                      TOTAL_AR_BALANCE,                                 
                      CODE_COMPANY_ACCT,                                
                      CODE_ACCT_STAT,                                   
                      PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      DATE_LAST_ACTION,                                 
                      LOCAL_OFFICE,                                     
                      ACCOUNT_NO,                                       
PCR263                CODES_DATA_PRESENT,                               
PCR263                CREDIT_GROUP,                                     
                      TOTAL_AR_BALANCE,                                 
                      NOTICE_EXEMPT_CD,                                 
                      CODE_DISC_OK,                                     
                      DATE_BILL_DAY_00,                                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      BANKRUPTCY_IND,                                   
C28788                IVR_EXEMPT_CD,                                    
A37061                ACCOUNT_TYPE_CODE                                 
                 INTO :AT-COMPANY-NO,                                   
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODE-COMPANY-ACCT,                            
                      :AT-CODE-ACCT-STAT,                               
                      :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-DATE-LAST-ACTION,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-ACCOUNT-NO,                                   
PCR263                :AT-CODES-DATA-PRESENT,                           
PCR263                :AT-CREDIT-GROUP,                                 
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-CODE-DISC-OK,                                 
                      :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,         
                      :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,         
                      :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,         
                      :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,         
                      :AT-BANKRUPTCY-IND,                               
C28788                :AT-IVR-EXEMPT-CD,                                
A37061                :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22580002
MFA-TR*        SELECT COMPANY_NO,                                       22590002
MFA-TR*               TOTAL_AR_BALANCE,                                 22600002
MFA-TR*               CODE_COMPANY_ACCT,                                22610002
MFA-TR*               CODE_ACCT_STAT,                                   22620002
MFA-TR*               PREMISE_NO,                                       22630002
MFA-TR*               CUSTOMER_NO,                                      22640002
MFA-TR*               DATE_LAST_ACTION,                                 22650002
MFA-TR*               LOCAL_OFFICE,                                     22660002
MFA-TR*               ACCOUNT_NO,                                       22670002
MFA-TR*               CODES_DATA_PRESENT,                               22680002
MFA-TR*               CREDIT_GROUP,                                     22690002
MFA-TR*               TOTAL_AR_BALANCE,                                 22700002
MFA-TR*               NOTICE_EXEMPT_CD,                                 22710002
MFA-TR*               CODE_DISC_OK,                                     22720002
MFA-TR*               DATE_BILL_DAY_00,                                 22730002
MFA-TR*               DATE_BILL_DAY_30,                                 22740002
MFA-TR*               DATE_BILL_DAY_60,                                 22750002
MFA-TR*               DATE_BILL_DAY_90,                                 22760002
MFA-TR*               BANKRUPTCY_IND,                                   22770002
MFA-TR*               IVR_EXEMPT_CD,                                    22780002
MFA-TR*               ACCOUNT_TYPE_CODE                                 22790002
MFA-TR*          INTO :AT-COMPANY-NO,                                   22800002
MFA-TR*               :AT-TOTAL-AR-BALANCE,                             22810002
MFA-TR*               :AT-CODE-COMPANY-ACCT,                            22820002
MFA-TR*               :AT-CODE-ACCT-STAT,                               22830002
MFA-TR*               :AT-PREMISE-NO,                                   22840002
MFA-TR*               :AT-CUSTOMER-NO,                                  22850002
MFA-TR*               :AT-DATE-LAST-ACTION,                             22860002
MFA-TR*               :AT-LOCAL-OFFICE,                                 22870002
MFA-TR*               :AT-ACCOUNT-NO,                                   22880002
MFA-TR*               :AT-CODES-DATA-PRESENT,                           22890002
MFA-TR*               :AT-CREDIT-GROUP,                                 22900002
MFA-TR*               :AT-TOTAL-AR-BALANCE,                             22910002
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                             22920002
MFA-TR*               :AT-CODE-DISC-OK,                                 22930002
MFA-TR*               :AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1,         22940002
MFA-TR*               :AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2,         22950002
MFA-TR*               :AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3,         22960002
MFA-TR*               :AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4,         22970002
MFA-TR*               :AT-BANKRUPTCY-IND,                               22980002
MFA-TR*               :AT-IVR-EXEMPT-CD,                                22990002
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                             23000002
MFA-TR*          FROM CSS_ACCOUNT                                       23010002
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       23020002
MFA-TR*         WITH UR                                                 23030002
MFA-TR*    END-EXEC.                                                    23040002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23050002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 23080002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2730'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
PCR263     ELSE                                                         
PCR263        MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
              IF WS-NULL-INDICATOR-1 < 0                                
                MOVE SPACES            TO AT-DATE-BILL-DAY-00           
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < 0                                
                MOVE SPACES            TO AT-DATE-BILL-DAY-30           
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < 0                                
                MOVE SPACES            TO AT-DATE-BILL-DAY-60           
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < 0                                
                MOVE SPACES            TO AT-DATE-BILL-DAY-90           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 23340002
      *                                                                 23350002
       2730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23380002
      *                                                                 23390002
      ******************************************************************23400002
      * 2740-GET-GL-ACCT                                               *23410002
      *    -- THIS MODULE OBTAINS THE GL ACCOUNT NUMBER FOR A DEPOSIT  *23420002
      ******************************************************************23430002
       2740-GET-GL-ACCT.                                                
      *                                                                 23450002
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
MCR310*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     23500002
MCR310          WHERE COMPANY_NO   = '01'                               
BB0904            AND GL_ACCT_NAME = :WS-GL-AR-DEP-KEY                  
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23460002
MFA-TR*        SELECT GL_ACCT_NO                                        23470002
MFA-TR*          INTO :GO-GL-ACCT-NO                                    23480002
MFA-TR*          FROM CSS_GL_ACCT_NO                                    23490002
MFA-TR*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     23500002
MFA-TR*         WHERE COMPANY_NO   = '01'                               23510002
MFA-TR*           AND GL_ACCT_NAME = :WS-GL-AR-DEP-KEY                  23520002
MFA-TR*         WITH UR                                                 23530002
MFA-TR*    END-EXEC.                                                    23540002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23550002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 23580002
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO GO-GL-ACCT-NO               
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2740'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
T15605        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
T15605        MOVE '01'                  TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-GL-AR-DEP-KEY      TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 23780002
      *                                                                 23790002
       2740-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23820002
      *                                                                 23830002
      ******************************************************************23840002
      * 2741-GET-GL-ACCT-2                                             *23850002
      *    -- THIS MODULE OBTAINS THE OFFSET GL ACCOUNT NUMBER         *23860002
      *       FOR A DEPOSIT.                                           *23870002
      ******************************************************************23880002
       2741-GET-GL-ACCT-2.                                              
      *                                                                 23900002
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :WS-GL-ACCT-NO-2                                  
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
MCR310*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     23950002
MCR310          WHERE COMPANY_NO   = '01'                               
BB0904            AND GL_ACCT_NAME = :WS-GL-DEP-DEP-KEY                 
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23910002
MFA-TR*        SELECT GL_ACCT_NO                                        23920002
MFA-TR*          INTO :WS-GL-ACCT-NO-2                                  23930002
MFA-TR*          FROM CSS_GL_ACCT_NO                                    23940002
MFA-TR*         WHERE COMPANY_NO   = :AT-COMPANY-NO                     23950002
MFA-TR*         WHERE COMPANY_NO   = '01'                               23960002
MFA-TR*           AND GL_ACCT_NAME = :WS-GL-DEP-DEP-KEY                 23970002
MFA-TR*         WITH UR                                                 23980002
MFA-TR*    END-EXEC.                                                    23990002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24000002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 24030002
           IF (SQLCODE = SUCCESSFUL-CALL)                               
              NEXT SENTENCE                                             
           ELSE IF (SQLCODE = NOT-FOUND)                                
              MOVE 0                     TO WS-GL-ACCT-NO-2             
           ELSE IF (SQLCODE NOT = SUCCESSFUL-CALL OR NOT-FOUND)         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2741'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
T15605        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
T15605        MOVE '01'                  TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-GL-DEP-DEP-KEY     TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF
                END-IF
           END-IF.                                                      
      *                                                                 24230002
      *                                                                 24240002
       2741-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24270002
      *                                                                 24280002
      ******************************************************************24290002
      * 2750-AR-TRANS-JOURNALING.                                      *24300002
      *     -- THIS MODULE WRITES AN A/R TRANSACTION JOURNAL           *24310002
      ******************************************************************24320002
       2750-AR-TRANS-JOURNALING.                                        
      *                                                                 24340002
           MOVE WS-ACCOUNT-NO              TO AR-ACCOUNT-NO             
                                              AU-ACCOUNT-NO.            
           MOVE CURRENT-TIMESTAMP          TO AR-TRANS-HIST-SEQ-NO      
                                              AU-TRANS-HIST-SEQ-NO.     
           MOVE CURRENT-DATE               TO AR-DATE-TRANS.            
           IF CORRECTION-OF-AGING OR PARM-DEP-ACTION-CODE = REBILLED    
               MOVE 'A'                    TO AR-CODE-TRAN-TYPE         
T17843         MOVE WS-AMT-ORIG-ENTERED    TO AR-AMT-ORIG-ENTERED       
                                              AU-AMT-POSTED             
           ELSE                                                         
               MOVE 'S'                    TO AR-CODE-TRAN-TYPE         
               MOVE WS-AMT-ORIG-ENTERED    TO AR-AMT-ORIG-ENTERED       
                                              AU-AMT-POSTED             
           END-IF.                                                      
           IF PARM-BILL-OPTION-CD = IMMEDIATE-BILL                      
               IF CORRECTION-OF-AGING                                   
                   ADD WS-AMT-ORIG-ENTERED TO                           
                     AT-TOTAL-AR-BALANCE GIVING AR-AMT-BILLED-UNPAID    
T17586             MOVE 'PANEL141D'        TO AR-APPL-PROGRAM-ID        
T17843             MOVE '0'                TO AU-CODE-AR-AGE            
               ELSE                                                     
                   ADD WS-AMT-ORIG-ENTERED TO                           
                     AT-TOTAL-AR-BALANCE GIVING AR-AMT-BILLED-UNPAID    
T26296*            MOVE 'PANEL141C'            TO AR-APPL-PROGRAM-ID    24580002
T26296             MOVE PARM-PROGRAM-NAME      TO AR-APPL-PROGRAM-ID    
MAD602             MOVE '0'                    TO AU-CODE-AR-AGE        
               END-IF                                                   
           ELSE                                                         
               IF PARM-DEP-ACTION-CODE = REBILLED                       
                  SUBTRACT WS-TOTAL-AGED FROM                           
                    AT-TOTAL-AR-BALANCE GIVING AR-AMT-BILLED-UNPAID     
T17586            MOVE 'PANEL141D'         TO AR-APPL-PROGRAM-ID        
                  MOVE 'F'                 TO AU-CODE-AR-AGE            
               ELSE                                                     
                  MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID      
T11234            MOVE PARM-PROGRAM-NAME   TO AR-APPL-PROGRAM-ID        
MAD602            MOVE VALUE-SPACES        TO AU-CODE-AR-AGE            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE PF-RESP-AREA-ID            TO AR-RESP-AREA-ID.          
           MOVE VALUE-SPACES               TO AR-PYMT-FACILITY-CD.      
           MOVE PARM-USER-ID-UPDT-BY       TO AR-USER-ID.               
           MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
                                                                        
           MOVE WS-CD-COMPANY-NO           TO AR-CASH-COMPANY-NO.       
           MOVE WS-CD-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.     
           MOVE WS-CD-REPORT-NO            TO AR-CASH-REPORT-NO.        
           MOVE WS-CD-REPORT-DATE          TO AR-DATE-CASH-REPORT.      
           MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
                                                                        
CHANG2*    IF PARM-DEPOSIT-CERT-NO(7:3) EQUAL SPACES                    24860002
CHANG2*       MOVE PARM-COMMENTS              TO AR-TRAN-COMMENT-TEXT   24870002
CHANG2*    ELSE                                                         24880002
C28160        MOVE PARM-COMMENTS              TO WS-NEW-TRANS-CMMTS     
C28160        MOVE WS-DEP-CERT-COMMENT        TO AR-TRAN-COMMENT-TEXT   
      *       MOVE WS-COMMENT-LEN-NO          TO AR-TRAN-COMMENT-LEN    24910002
FI1122        IF  WS-COMMENT-LEN-NO <= 191                              
C28160            ADD  19                         TO WS-COMMENT-LEN-NO  
FI1122        ELSE                                                      
FI1122            MOVE 210                        TO WS-COMMENT-LEN-NO  
FI1122        END-IF                                                    
CHANG2*    END-IF.                                                      24970002
C28160     MOVE WS-COMMENT-LEN-NO          TO AR-TRAN-COMMENT-LEN.      
T18821     IF PARM-DEP-ACTION-CODE = REBILLED                           
T19931         IF (PARM-ORIG-BILL-OPTION-CD   = 'N'  AND                
T19931             PARM-BILL-OPTION-CD        = 'T')                    
T19931             MOVE VALUE-SPACES       TO AR-RECORD-ONLY-FL         
T19931         ELSE                                                     
                   MOVE 'Y'                TO AR-RECORD-ONLY-FL         
T19931         END-IF                                                   
           ELSE                                                         
               MOVE VALUE-SPACES           TO AR-RECORD-ONLY-FL         
           END-IF.                                                      
           MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
      *                                                                 25100002
           MOVE 1                          TO AU-TRAN-APPL-NO.          
           MOVE WS-DEPOSIT-CERT-NO-NO      TO AU-ITEM-ID.               
           MOVE VALUE-SPACES               TO AU-CODE-CONTRACT-TYPE     
                                              AU-CURRENCY-TYPE.         
           MOVE 0                          TO AU-CURRENCY-AMT.          
           IF PARM-ACTION-CODE = INSERT-DEPOSIT                         
               MOVE GO-GL-ACCT-NO          TO AU-GL-ACCT-DEBIT          
               MOVE WS-GL-ACCT-NO-2        TO AU-GL-ACCT-CREDIT         
           ELSE                                                         
               IF CORRECTION-OF-AGING OR PARM-DEP-ACTION-CODE = REBILLED
                   MOVE GO-GL-ACCT-NO      TO AU-GL-ACCT-CREDIT         
                                              AU-GL-ACCT-DEBIT          
               ELSE                                                     
                   MOVE GO-GL-ACCT-NO      TO AU-GL-ACCT-CREDIT         
                   MOVE WS-GL-ACCT-NO-2    TO AU-GL-ACCT-DEBIT          
               END-IF                                                   
           END-IF.                                                      
      *                                                                 25280002
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST      THRU 6500-EXIT.   
      *                                                                 25300002
      *                                                                 25310002
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25340002
      *                                                                 25350002
      ******************************************************************25360002
      * 2755-SET-100-JRNL-VARS.                                        *25370002
      *     -- THIS MODULE SETS UP ALL 100 CODE WORKING STORAGE        *25380002
      *        VARIABLES THAT ARE USED IN THE CASH AND MISCELLANEOUS   *25390002
      *        JOURNALING PROCESS.                                     *25400002
      ******************************************************************25410002
       2755-SET-100-JRNL-VARS.                                          
      *                                                                 25430002
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00020 *****       25440002
      ***** (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.*****       25450002
      *                                                                 25460002
           MOVE 9                          TO WS-TRAN-OPER-LEVEL.       
           MOVE 1                          TO WS-TRAN-OCAP-FIELD.       
           MOVE 1                          TO WS-TRAN-OCAP-VALUE.       
      *                                                                 25500002
      ***** THIS IS NECESSARY BECAUSE THIS RPC PERFORMS BASE     ***    25510002
      ***** AR14 (INSERT/DELETE) AND BASE RM10 (UPDATE) FUNCTION.***    25520002
           IF PARM-ACTION-CODE EQUAL UPDATE-DEPOSIT                     
              MOVE 'M'                     TO WS-TRAN-JRNL-TYPE         
           ELSE                                                         
              MOVE 'C'                     TO WS-TRAN-JRNL-TYPE
           END-IF.        
           MOVE 'N'                        TO WS-TRAN-HOLD-EXEMPT-FLAG. 
      *                                                                 25580002
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00021 *****       25590002
      ***** (PARAGRAPH 5980) TO VERIFY USER-ID.             *****       25600002
      *                                                                 25610002
           MOVE PARM-USER-ID-UPDT-BY       TO WS-JRNL-OL-TEMP-ID.       
           MOVE WS-JRNL-CK-OPER-ID         TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 25650002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 25710002
           MOVE WS-JRNL-OL-OPR-LOC         TO WS-TERM-LOC.              
      *                                                                 25730002
      ***** THESE FILEDS WERE POPULATED BY CALLING CPD00022 *****       25740002
      ***** (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL. *****       25750002
      *                                                                 25760002
           MOVE WS-CD-COMPANY-NO           TO WS-JRNL-OL-COMPANY.       
           MOVE WS-CD-LOCAL-OFFICE         TO WS-JRNL-OL-LOC-OFF.       
           MOVE WS-CD-REPORT-NO            TO WS-JRNL-OL-REPORT-NO.     
           MOVE WS-CD-REPORT-DATE          TO WS-JRNL-OL-REPORT-DT.     
           MOVE WS-CASH-DRAWER-ID          TO WS-JRNL-OL-CASH-DRWR.     
                                                                        
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
      *                                                                 25860002
           MOVE WS-JRNL-VALIDATE-OPER      TO WS-JRNL-OPERATION-RQST.   
           MOVE 'C'                        TO WS-JRNL-SOURCE-CODE.      
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 25940002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 26000002
      *                                                                 26010002
REARCH     MOVE WS-TERMINAL-TRAN        TO WS-100-CODE-TERMINAL-TRAN.   
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
                                                                        
           MOVE WS-CD-COMPANY-NO        TO WS-JRNL-OL-COMPANY.          
           MOVE WS-CD-LOCAL-OFFICE      TO WS-JRNL-OL-LOC-OFF.          
           MOVE WS-CD-REPORT-NO         TO WS-JRNL-OL-REPORT-NO.        
           MOVE WS-CD-REPORT-DATE       TO WS-JRNL-OL-REPORT-DT.        
           MOVE WS-CASH-DRAWER-ID       TO WS-JRNL-OL-CASH-DRWR.        
                                                                        
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE AT-COMPANY-NO           TO WS-100-COMPANY-NO.           
           MOVE AT-ACCOUNT-NO           TO WS-100-ACCT-NO.              
           MOVE AT-CUSTOMER-NO          TO WS-100-CUSTOMER-NO.          
           MOVE AT-PREMISE-NO           TO WS-100-PREMISE-NO.           
           MOVE AT-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE 1                       TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE AT-DATE-LAST-ACTION     TO WS-100-DATE-LAST-ACTION.     
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
      *                                                                 26210002
      *                                                                 26220002
       2755-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26250002
      *                                                                 26260002
      ******************************************************************26270002
      * 2760-CASH-DRAWER-101.                                          *26280002
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *26290002
      ******************************************************************26300002
       2760-CASH-DRAWER-101.                                            
      *                                                                 26320002
           PERFORM 2770-GET-CUSTOMER-INFO             THRU 2770-EXIT.   
           PERFORM 2780-GET-PREMISE-INFO              THRU 2780-EXIT.   
           PERFORM 2755-SET-100-JRNL-VARS             THRU 2755-EXIT.   
      *                                                                 26360002
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
                                                                        
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE WS-AMT-ORIG-ENTERED     TO WS-101-AMOUNT-ENTERED        
                                           WS-101-AMT-POSTED.           
BB0904     IF PARM-ACTION-CODE = INSERT-DEPOSIT                         
BB0904         MOVE WS-AMT-ORIG-ENTERED    TO WS-JRNL-RCV-DEBIT-AMT     
BB0904                                        WS-JRNL-GEN-LEG-CREDIT-AMT
BB0904     ELSE                                                         
BB0904         IF CORRECTION-OF-AGING OR PARM-DEP-ACTION-CODE = REBILLED
BB0904             MOVE WS-AMT-ORIG-ENTERED TO WS-JRNL-RCV-DEBIT-AMT    
BB0904                                         WS-JRNL-RCV-CREDIT-AMT   
BB0904         ELSE                                                     
BB0904             MOVE WS-AMT-ORIG-ENTERED TO WS-JRNL-RCV-DEBIT-AMT    
BB0904                                        WS-JRNL-GEN-LEG-CREDIT-AMT
BB0904         END-IF                                                   
BB0904     END-IF.                                                      
                                                                        
           MOVE AU-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE AU-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE AU-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE CURRENT-DATE            TO WS-101-DATE-AR-BILLED.       
T10578     MOVE WS-DEPOSIT-CERT-NO-NO   TO WS-101-ITEM-ID-NO.           
T10578     MOVE WS-AMT-ORIG-ENTERED     TO WS-101-DETAIL-END-BAL.       
T12013     IF PARM-BILL-OPTION-CD EQUAL IMMEDIATE-BILL                  
T12013         MOVE WS-AMT-ORIG-ENTERED TO WS-101-DETAIL-END-AR-BAL     
T12013     ELSE                                                         
T12013         MOVE 0                   TO WS-101-DETAIL-END-AR-BAL     
T12013     END-IF.                                                      
T12013     MOVE AR-AMT-BILLED-UNPAID    TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
      *                                                                 26730002
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
      *                                                                 26750002
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 26780002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 26840002
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 26870002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 26930002
      *                                                                 26940002
       2760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26970002
      *                                                                 26980002
      ******************************************************************26990002
      * 2770-GET-CUSTOMER-INFO.                                        *27000002
      *    -- THIS MODULE OBTAINS THE EMPLOYEE ACCOUNT CODE.           *27010002
      ******************************************************************27020002
       2770-GET-CUSTOMER-INFO.                                          
      *                                                                 27040002
           EXEC SQL                                                     
               SELECT CODE_EMPL_ACCT                                    
                 INTO :CU-CODE-EMPL-ACCT                                
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27050002
MFA-TR*        SELECT CODE_EMPL_ACCT                                    27060002
MFA-TR*          INTO :CU-CODE-EMPL-ACCT                                27070002
MFA-TR*          FROM CSS_CUSTOMER                                      27080002
MFA-TR*         WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    27090002
MFA-TR*         WITH UR                                                 27100002
MFA-TR*    END-EXEC.                                                    27110002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27120002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 27150002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2770'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
T15605        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
T15605        MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 27290002
       2770-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27320002
      *                                                                 27330002
      ******************************************************************27340002
      * 2780-GET-PREMISE-INFO.                                         *27350002
      *    -- THIS MODULE OBTAINS THE REVENUE DISTRICE AND THE         *27360002
      *       PREMISE ACCOUNT CODE.                                    *27370002
      ******************************************************************27380002
       2780-GET-PREMISE-INFO.                                           
      *                                                                 27400002
           EXEC SQL                                                     
               SELECT REV_DISTRICT_CD,                                  
                      CODE_PREMISE_STAT                                 
                 INTO :PR-REV-DISTRICT-CD,                              
                      :PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27410002
MFA-TR*        SELECT REV_DISTRICT_CD,                                  27420002
MFA-TR*               CODE_PREMISE_STAT                                 27430002
MFA-TR*          INTO :PR-REV-DISTRICT-CD,                              27440002
MFA-TR*               :PR-CODE-PREMISE-STAT                             27450002
MFA-TR*          FROM CSS_PREMISE                                       27460002
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                       27470002
MFA-TR*         WITH UR                                                 27480002
MFA-TR*    END-EXEC.                                                    27490002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27500002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 27530002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '2780'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
T15605        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 27670002
       2780-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27700002
      *                                                                 27710002
      ******************************************************************27720002
      * 2810-MISCELLANEOUS-113.                                        *27730002
      *     -- THIS MODULE WRITES A FORMAT 113 MISCELLANEOUS JOURNAL   *27740002
      ******************************************************************27750002
       2810-MISCELLANEOUS-113.                                          
      *                                                                 27770002
           PERFORM 2815-GET-AR-AGE-INFO               THRU 2815-EXIT.   
      *                                                                 27790002
           COMPUTE WS-TOTAL-AGED =                                      
             AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 +                      
             AC-AMT-AR-DAY-60 + AC-AMT-AR-DAY-90.                       
      *                                                                 27830002
           PERFORM 2755-SET-100-JRNL-VARS             THRU 2755-EXIT.   
      *                                                                 27850002
           MOVE 113                       TO WS-113-JRNL-FORMAT-NO.     
           MOVE SPACES                    TO WS-113-CASH-DRAWER-USED.   
           MOVE WS-RM01-RECORD-FIELD-DESC TO WS-113-RECORD-FIELD-DESC.  
      *                                                                 27890002
           IF CORRECTION-OF-AGING                                       
              COMPUTE WS-113-ACCT-AR-BAL-IS =                           
                 AT-TOTAL-AR-BALANCE + WS-AMT-ORIG-ENTERED              
           ELSE                                                         
              IF PARM-DEP-ACTION-CODE = REBILLED                        
                 COMPUTE WS-113-ACCT-AR-BAL-IS =                        
                    AT-TOTAL-AR-BALANCE - WS-TOTAL-AGED                 
              ELSE                                                      
                 MOVE AT-TOTAL-AR-BALANCE TO WS-113-ACCT-AR-BAL-IS      
           END-IF
           END-IF.                                                      
      *                                                                 28000002
           MOVE AT-TOTAL-AR-BALANCE       TO WS-113-ACCT-AR-BAL-WAS.    
      *                                                                 28020002
           IF CORRECTION-OF-AGING                                       
              COMPUTE WS-113-AR-DAY-00-IS =                             
                 AC-AMT-AR-DAY-00 + WS-AMT-ORIG-ENTERED                 
           ELSE                                                         
              IF PARM-DEP-ACTION-CODE = REBILLED                        
                 MOVE ZEROES              TO WS-113-AR-DAY-00-IS        
              ELSE                                                      
                 MOVE AC-AMT-AR-DAY-00    TO WS-113-AR-DAY-00-IS        
           END-IF
           END-IF.                                                      
      *                                                                 28120002
           MOVE AC-AMT-AR-DAY-00          TO WS-113-AR-DAY-00-WAS.      
           MOVE AC-AMT-AR-DAY-30          TO WS-113-AR-DAY-30-WAS.      
           MOVE AC-AMT-AR-DAY-60          TO WS-113-AR-DAY-60-WAS.      
           MOVE AC-AMT-AR-DAY-90          TO WS-113-AR-DAY-90-WAS.      
      *                                                                 28170002
           IF PARM-DEP-ACTION-CODE = REBILLED                           
              MOVE ZEROES                 TO WS-113-AR-DAY-30-IS        
                                             WS-113-AR-DAY-60-IS        
                                             WS-113-AR-DAY-90-IS        
           ELSE                                                         
              MOVE AC-AMT-AR-DAY-30       TO WS-113-AR-DAY-30-IS        
              MOVE AC-AMT-AR-DAY-60       TO WS-113-AR-DAY-60-IS        
              MOVE AC-AMT-AR-DAY-90       TO WS-113-AR-DAY-90-IS        
           END-IF.                                                      
      *                                                                 28270002
           ADD  AC-AMT-AR-DAY-00                                        
                AC-AMT-AR-DAY-30                                        
                AC-AMT-AR-DAY-60                                        
                AC-AMT-AR-DAY-90                                        
                             GIVING WS-113-TOTAL-AGED-IS                
                                    WS-113-TOTAL-AGED-WAS.              
      *                                                                 28340002
           IF CORRECTION-OF-AGING                                       
               COMPUTE WS-113-TOTAL-AGED-IS = WS-113-TOTAL-AGED-IS      
                   + WS-AMT-ORIG-ENTERED                                
               COMPUTE WS-113-TOTAL-AGED-WAS = WS-113-TOTAL-AGED-WAS    
                   + WS-AMT-ORIG-ENTERED                                
           ELSE                                                         
               IF PARM-DEP-ACTION-CODE = REBILLED                       
                  MOVE AC-AMT-TRAN-BALANCE TO WS-113-TOTAL-AGED-IS      
                                              WS-113-TOTAL-AGED-WAS     
               END-IF                                                   
           END-IF.                                                      
      *                                                                 28460002
           MOVE PR-REV-DISTRICT-CD    TO WS-113-CODE-REVENUE-DISTRICT.  
           MOVE CU-CODE-EMPL-ACCT     TO WS-113-CODE-EMPL-ACCT.         
           MOVE AT-CODE-COMPANY-ACCT  TO WS-113-CODE-COMPANY-ACCT.      
           MOVE AT-CODE-ACCT-STAT     TO WS-113-CODE-ACCOUNT-STATUS.    
           MOVE PR-CODE-PREMISE-STAT  TO WS-113-CODE-PREMISE-STATUS.    
      *                                                                 28520002
           IF CU-CODE-EMPL-ACCT EQUAL 'B'                               
              MOVE 'W'                TO WS-100-CODE-TRAN-ERRORS (01)   
           ELSE                                                         
              MOVE 'R'                TO WS-100-CODE-TRAN-ERRORS (01)
           END-IF.  
           MOVE CJF00113              TO WS-100-USER-DEFINED-AREA.      
      *                                                                 28580002
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 28610002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 28670002
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE           THRU 6400-EXIT.   
      *                                                                 28700002
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 28760002
      *                                                                 28770002
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28800002
      *                                                                 28810002
      ******************************************************************28820002
      * 2815-GET-AR-AGE-INFO.                                          *28830002
      *     -- THIS MODULE GETS THE AGING BUCKET INFORMATION FROM THE  *28840002
      *        DEPOSIT RECORD IN THE CSS_AR_CNTL TABLE.                *28850002
      ******************************************************************28860002
       2815-GET-AR-AGE-INFO.                                            
      *                                                                 28880002
           EXEC SQL                                                     
               SELECT AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90,                                    
                      AMT_UNUSED_CR,                                    
                      AMT_TRAN_BALANCE                                  
                 INTO :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90,                                
                      :AC-AMT-UNUSED-CR,                                
                      :AC-AMT-TRAN-BALANCE                              
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        
                  AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28890002
MFA-TR*        SELECT AMT_AR_DAY_00,                                    28900002
MFA-TR*               AMT_AR_DAY_30,                                    28910002
MFA-TR*               AMT_AR_DAY_60,                                    28920002
MFA-TR*               AMT_AR_DAY_90,                                    28930002
MFA-TR*               AMT_UNUSED_CR,                                    28940002
MFA-TR*               AMT_TRAN_BALANCE                                  28950002
MFA-TR*          INTO :AC-AMT-AR-DAY-00,                                28960002
MFA-TR*               :AC-AMT-AR-DAY-30,                                28970002
MFA-TR*               :AC-AMT-AR-DAY-60,                                28980002
MFA-TR*               :AC-AMT-AR-DAY-90,                                28990002
MFA-TR*               :AC-AMT-UNUSED-CR,                                29000002
MFA-TR*               :AC-AMT-TRAN-BALANCE                              29010002
MFA-TR*          FROM CSS_AR_CNTL                                       29020002
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                29030002
MFA-TR*           AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        29040002
MFA-TR*           AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO        29050002
MFA-TR*         WITH UR                                                 29060002
MFA-TR*    END-EXEC.                                                    29070002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29080002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 29110002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2815'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
T15605        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
T15605        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE DEP-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 29270002
      *                                                                 29280002
       2815-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29310002
      *                                                                 29320002
      ******************************************************************29330002
      * 2900-ALTER-AT-CODES.                                           *29340002
      *    -- THIS MODULE RETRIEVES THE CODES DATA PRESENT COLUMN FROM *29350002
      *       THE AT TABLE, MOVES AN "A" INTO THE WS-CODE-DEP-ON-HAND  *29360002
      *       AND WS-CODE-DEP-REQ AREAS OF WORKING STORAGE IF THE      *29370002
      *       INSERTED DEPOSIT RECORD IS THE FIRST                     *29380002
      *       RECORD OF ITS KIND FOR THE ACCOUNT OR A SPACE IF THE     *29390002
      *       DELETED RECORD WAS THE LAST DEPOSIT RECORDE, AND THEN    *29400002
      *       UPDATES THE CSS_ACCOUNT TABLE WITH THIS FIELD.           *29410002
      ******************************************************************29420002
       2900-ALTER-AT-CODES.                                             
      *                                                                 29440002
           IF PARM-ACTION-CODE = INSERT-DEPOSIT                         
               MOVE 'A'                       TO WS-CODE-DEP-ON-HAND    
                                                 WS-CODE-DEP-REQ        
                                                 WS-CODE-SEC-ACCT       
      *    SONALI                                                       29490002
           ELSE                                                         
              PERFORM 5050-CHECK-SEC-DEP   THRU 5050-EXIT               
              IF NO-SECURITY-EXISTS                                     
                 MOVE SPACES                  TO WS-CODE-DEP-ON-HAND    
                                                 WS-CODE-DEP-REQ        
                                                 WS-CODE-SEC-ACCT       
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-CODES-DATA-PRESENT         TO AT-CODES-DATA-PRESENT. 
T21068     PERFORM 2710-GET-TIMESTAMP-AND-DATE                          
T21068                                        THRU 2710-EXIT.           
T21068     MOVE CURRENT-TIMESTAMP             TO AT-LAST-UPDATE-TS.     
      *                                                                 29630002
           PERFORM 2920-UPDATE-AT-CODE        THRU 2920-EXIT.           
      *                                                                 29650002
      *                                                                 29660002
       2900-EXIT.                                                       
           EXIT.                                                        
PCR263*                                                                 29690002
PCR263******************************************************************29700002
PCR263* 2910-PROCESS-NOTICES                                           *29710002
PCR263*    CALLS CPD00068 TO PROCESS NOTICES TYPES                     *29720002
PCR263******************************************************************29730002
PCR263*                                                                 29740002
PCR263 2910-PROCESS-NOTICES.                                            
PCR263     MOVE CURRENT-DATE             TO WS-HOLD-DATE.               
PCR263     MOVE VALUE-YES                TO CALC-ARREARS-SW             
PCR263                                      CALC-BALANCE-SW             
PCR263                                      LOAD-WS-AMOUNTS-SW.         
T22359     MOVE PROGRAM-NAME             TO WS-CPD00068-CALLING-PGM.    
T19557*    MOVE CWS00068-FIELDS          TO WS-CWS68-FIELDS-LK.         29840002
T19557*    MOVE WS-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT-LK.   29850002
T19557*    MOVE DCLCSS-ACCOUNT           TO WS-DCLCSS-ACCOUNT-LK.       29860002
T19557*    MOVE ABEND-FILE               TO WS-ABEND-FILE-LK.           29870002
T19557*    MOVE RS-RETURN-CODE           TO WS-RETURN-CODE-LK.          29880002
T19557     MOVE SPACES                   TO ABEND-FUNCTION .            
T19557     PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT.                
T19557*    MOVE WS-CWS68-FIELDS-LK       TO CWS00068-FIELDS             29910002
T19557*    MOVE WS-ABEND-FILE-LK         TO ABEND-FILE                  29920002
T19557*    MOVE WS-DCLCSS-ACCOUNT-LK     TO DCLCSS-ACCOUNT              29930002
T19557*    MOVE WS-CODES-DATA-PRESENT-LK TO WS-CODES-DATA-PRESENT       29940002
T19557*    MOVE WS-RETURN-CODE-LK        TO RS-RETURN-CODE              29950002
T19557     MOVE RS-RETURN-CODE           TO WS-ACTIVE-RETURN-CODE,      
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T19557     END-IF.                                                      
T32545     IF PARM-CODE-DEP-TYPE EQUAL 'B'                              
T32545        MOVE 'R' TO CL-CODE-SPECIAL-TYPE                          
A05323     ELSE                                                         
A05323        MOVE ' ' TO CL-CODE-SPECIAL-TYPE                          
A05323     END-IF.                                                      
PCR263* MOVE COMMON FIELDS HERE                                         30300002
PCR263     MOVE WS-ACCOUNT-NO            TO CL-ACCOUNT-NO.              
PCR263     MOVE SPACES                   TO CL-CODE-FRCST-CR-GRP.       
PCR263     MOVE WS-DEPOSIT-CERT-NO-NO    TO CL-ITEM-ID.                 
PCR263     MOVE ZEROS                    TO CL-CODE-MESSAGE-TYPE.       
PCR263     MOVE WS-AMT-ORIG-ENTERED      TO CL-AMT-NOTICE.              
PCR263     MOVE CURRENT-TIMESTAMP        TO CL-LAST-UPDATE-TS.          
PCR263     MOVE CURRENT-DATE             TO CL-DATE-BILL.               
T26296*    CREATE ONLY 'O' ROW AND NO 'I' ROW FOR AUTO DNP DEPOSIT      30380002
T26296     IF PARM-CODE-DEP-TYPE EQUAL 'B'                              
T26296        GO TO 2910-EXIT
           END-IF.                                          
PCR263* CHECK IF THERE NEEDS TO BE A 'I' NOTICE TYPE WRITTEN            30410002
PCR263     IF WS-CODE-MEDICAL = ACTIVE                                  
PCR263            PERFORM 3000-MEDICAL-CERT-EXP-DATE                    
PCR263                                             THRU 3000-EXIT       
PCR263         END-IF                                                   
PCR263         IF (WS-CODE-MEDICAL = ACTIVE AND                         
PCR263             WS-PLUS-10-WDAYS > CA-DATE-EXPIRE) OR                
PCR263            (WS-CODE-MEDICAL NOT EQUAL ACTIVE)                    
PCR263            IF WS-AMT-ORIG-ENTERED > WS-NOTICE-DNP-LIMIT          
PCR263                MOVE WS-I          TO CL-CODE-SPECIAL-TYPE        
PCR263                MOVE WS-PLUS-10-WDAYS TO CL-DATE-CREDIT-ACTION    
PCR263                MOVE +0            TO WS-NULL-INDICATOR-2         
PCR263                MOVE LOW-VALUES    TO CL-DATE-NOTICE-MAIL         
PCR263                                          CL-DATE-NOTICE-DUE      
PCR263                MOVE -1            TO WS-NULL-INDICATOR-1         
PCR263                                          WS-NULL-INDICATOR-3     
PCR263                MOVE WS-I          TO CL-CODE-NOTICE-TYPE         
PCR263                PERFORM 2950-NOTIFY-CREDIT-COL THRU 2950-EXIT     
A37061                IF AT-ACCOUNT-TYPE-CODE = 'R'  THEN               
T32545                    MOVE 'Y'               TO WS-IVR-ROW-INSERTED 
T32545                END-IF                                            
PCR263            END-IF                                                
A05323     END-IF.                                                      
PCR263* ALWAYS WRITE AN 'O' TYPE NOTICE                                 30660002
PCR263     PERFORM 2550-NOTICE-DATE         THRU 2550-EXIT.             
PCR263     MOVE WS-PLUS-9-WDAYS          TO CL-DATE-NOTICE-DUE.         
PCR263     MOVE WS-NOTICE-DATE           TO CL-DATE-NOTICE-MAIL.        
PCR263     MOVE +0                       TO WS-NULL-INDICATOR-1         
PCR263                                      WS-NULL-INDICATOR-3.        
A05323     MOVE WS-O                TO CL-CODE-SPECIAL-TYPE.            
PCR263     MOVE LOW-VALUES          TO CL-DATE-CREDIT-ACTION.           
PCR263     MOVE -1                  TO WS-NULL-INDICATOR-2.             
      *                                                                 30780002
T32545     IF WS-IVR-ROW-INSERTED = 'Y' AND CSR-DATABASE                
T32545       MOVE 'DAY-SECOND-FIELD'    TO  C8-DELINQ-CD                
T32545       PERFORM 7500-SELECT-DELINQ-VALUES  THRU 7500-EXIT          
T32545       MOVE C8-DELINQ-VALUE       TO WS-IVR-DAY-SECOND            
T32545       MOVE WS-PLUS-10-WDAYS      TO WS-WORK-DATE                 
T32545       PERFORM 1850-GET-PREV-BUSINESS-DAY   THRU 1850-EXIT        
T32545          VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL            
T32545          WS-NEXT-DATE-COUNT GREATER THAN WS-IVR-DAY-SECOND       
T32545       MOVE WS-WORK-DATE          TO CL-DATE-CREDIT-ACTION        
T32545     END-IF.                                                      
      *                                                                 30890002
PCR263     MOVE WS-O                     TO CL-CODE-NOTICE-TYPE.        
PCR263*                                                                 30910002
PCR263 2910-EXIT.                                                       
PCR263     EXIT.                                                        
      *                                                                 30940002
      ******************************************************************30950002
      * 2920-UPDATE-AT-CODE.                                           *30960002
      *    -- THIS MODULE UPDATES THE CODES DATA PRESENT CODE FOR      *30970002
      *       THIS ACCOUNT TO THE CSS_ACCOUNT TABLE.                   *30980002
      ******************************************************************30990002
       2920-UPDATE-AT-CODE.                                             
      *                                                                 31010002
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,      
T21068                LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )           
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31020002
MFA-TR*        UPDATE CSS_ACCOUNT                                       31030002
MFA-TR*           SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,      31040002
MFA-TR*               LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS           31050002
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       31060002
MFA-TR*    END-EXEC.                                                    31070002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31080002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 31110002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2920'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T21068        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-2             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T21068        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 31250002
      *                                                                 31260002
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31290002
      *                                                                 31300002
      ******************************************************************31310002
      * 2950-NOTIFY-CREDIT-COL                                         *31320002
      *    -- THIS MODULE WRITES A RECORD TO THE CSS_CRED_COLL TABLE   *31330002
      *       WHEN THE BILLING IMMEDIATE OPTION IS SELECTED.  THE      *31340002
      *       "DATE_NOTICE_DUE" COLUMN WILL HOLD THE SERVICE "CUT OFF" *31350002
      *       DATE.                                                    *31360002
      ******************************************************************31370002
       2950-NOTIFY-CREDIT-COL.                                          
      *                                                                 31390002
           MOVE VALUE-YES                     TO WS-OK-NOT-FOUND.       
           MOVE CL-CODE-NOTICE-TYPE           TO DEPOSIT-MESSAGE-TYPE.  
TP5519     PERFORM 7200-SEL-CRD-COL-O-TYP     THRU 7200-EXIT.           
TP5519     PERFORM 7300-SEL-CRD-COL-I-TYP     THRU 7300-EXIT.           
T26296     IF PARM-CODE-DEP-TYPE EQUAL 'B'                              
T26296        MOVE WS-R                       TO CL-CODE-SPECIAL-TYPE   
T26296        MOVE WS-O                       TO CL-CODE-NOTICE-TYPE    
T26296        MOVE LOW-VALUES                 TO CL-DATE-NOTICE-MAIL,   
T26296                                           CL-DATE-CREDIT-ACTION, 
T26296                                           CL-DATE-NOTICE-DUE     
T26296        MOVE -1                         TO WS-NULL-INDICATOR-1,   
T26296                                           WS-NULL-INDICATOR-2,   
T26296                                           WS-NULL-INDICATOR-3    
T26296     END-IF.                                                      
           IF MAINT-NEEDED                                              
TP5519        PERFORM 5400-TRN-DET-CL-INS        THRU 5400-EXIT         
           END-IF.                                                      
           PERFORM 2951-DELETE-CREDIT-COL     THRU 2951-EXIT.           
           MOVE VALUE-NO                      TO WS-OK-NOT-FOUND.       
      *                                                                 31590002
T32922     IF CL-DATE-NOTICE-MAIL             EQUAL LOW-VALUES OR SPACES
T32922        MOVE -1                         TO WS-NULL-INDICATOR-1    
T32922     END-IF.                                                      
T32922     IF CL-DATE-CREDIT-ACTION           EQUAL LOW-VALUES OR SPACES
T32922        MOVE -1                         TO WS-NULL-INDICATOR-2    
T32545     ELSE                                                         
T32545        MOVE 0                          TO WS-NULL-INDICATOR-2    
T32922     END-IF.                                                      
T32922     IF CL-DATE-NOTICE-DUE              EQUAL LOW-VALUES OR SPACES
T32922        MOVE -1                         TO WS-NULL-INDICATOR-3    
T32922     END-IF.                                                      
      *                                                                 31710002
           EXEC SQL                                                     
               INSERT INTO CSS_CRED_COLL                                
                   (ACCOUNT_NO,                                         
                    CODE_SPECIAL_TYPE,                                  
                    DATE_NOTICE_MAIL,                                   
                    CODE_FRCST_CR_GRP,                                  
                    ITEM_ID,                                            
                    CODE_MESSAGE_TYPE,                                  
                    DATE_CREDIT_ACTION,                                 
                    DATE_NOTICE_DUE,                                    
                    AMT_NOTICE,                                         
                    CODE_NOTICE_TYPE,                                   
                    DATE_BILL,                                          
                    LAST_UPDATE_TS)                                     
               VALUES                                                   
PCR263             (:CL-ACCOUNT-NO,                                     
PCR263              :CL-CODE-SPECIAL-TYPE,                              
PCR263              IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                          :WS-NULL-INDICATOR-1
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                   :WS-NULL-INDICATOR-1
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-INDICATOR-1
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                   :WS-NULL-INDICATOR-1
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                                   :WS-NULL-INDICATOR-1
              ) ),           
PCR263              :CL-CODE-FRCST-CR-GRP,                              
PCR263              :CL-ITEM-ID,                                        
PCR263              :CL-CODE-MESSAGE-TYPE,                              
PCR263              IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                          :WS-NULL-INDICATOR-2
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-INDICATOR-2
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-INDICATOR-2
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-INDICATOR-2
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-INDICATOR-2
              ) ),         
PCR263              IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                          :WS-NULL-INDICATOR-3
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                   :WS-NULL-INDICATOR-3
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-INDICATOR-3
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                                   :WS-NULL-INDICATOR-3
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-INDICATOR-3
              ) ),            
PCR263              :CL-AMT-NOTICE,                                     
PCR263              :CL-CODE-NOTICE-TYPE,                               
PCR263              IIF(TRY_CONVERT(DATE, :CL-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL
              ) <> 0) OR (LEN(:CL-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :CL-DATE-BILL
              ), CONVERT(DATE, :CL-DATE-BILL) ),                               
PCR263              CIS.CHAR2TIMESTAMP(:CL-LAST-UPDATE-TS))                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31720002
MFA-TR*        INSERT INTO CSS_CRED_COLL                                31730002
MFA-TR*            (ACCOUNT_NO,                                         31740002
MFA-TR*             CODE_SPECIAL_TYPE,                                  31750002
MFA-TR*             DATE_NOTICE_MAIL,                                   31760002
MFA-TR*             CODE_FRCST_CR_GRP,                                  31770002
MFA-TR*             ITEM_ID,                                            31780002
MFA-TR*             CODE_MESSAGE_TYPE,                                  31790002
MFA-TR*             DATE_CREDIT_ACTION,                                 31800002
MFA-TR*             DATE_NOTICE_DUE,                                    31810002
MFA-TR*             AMT_NOTICE,                                         31820002
MFA-TR*             CODE_NOTICE_TYPE,                                   31830002
MFA-TR*             DATE_BILL,                                          31840002
MFA-TR*             LAST_UPDATE_TS)                                     31850002
MFA-TR*        VALUES                                                   31860002
MFA-TR*            (:CL-ACCOUNT-NO,                                     31870002
MFA-TR*             :CL-CODE-SPECIAL-TYPE,                              31880002
MFA-TR*             :CL-DATE-NOTICE-MAIL:WS-NULL-INDICATOR-1,           31890002
MFA-TR*             :CL-CODE-FRCST-CR-GRP,                              31900002
MFA-TR*             :CL-ITEM-ID,                                        31910002
MFA-TR*             :CL-CODE-MESSAGE-TYPE,                              31920002
MFA-TR*             :CL-DATE-CREDIT-ACTION:WS-NULL-INDICATOR-2,         31930002
MFA-TR*             :CL-DATE-NOTICE-DUE:WS-NULL-INDICATOR-3,            31940002
MFA-TR*             :CL-AMT-NOTICE,                                     31950002
MFA-TR*             :CL-CODE-NOTICE-TYPE,                               31960002
MFA-TR*             :CL-DATE-BILL,                                      31970002
MFA-TR*             :CL-LAST-UPDATE-TS)                                 31980002
MFA-TR*    END-EXEC.                                                    31990002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32000002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 32030002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '2950'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2             
T15605        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
CBSI          MOVE 'DATE_NOTICE_MAIL'    TO TABLE-ELEMENT-4             
T15605        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
T15605        MOVE CL-ITEM-ID            TO HOSTVAR-ELEMENT-3           
CBSI          MOVE CL-DATE-NOTICE-MAIL   TO HOSTVAR-ELEMENT-4           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 32210002
      *                                                                 32220002
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32250002
      *                                                                 32260002
      ******************************************************************32270002
      * 2951-DELETE-CREDIT-COL                                         *32280002
      *    -- THIS MODULE DELETES A RECORD FROM THE CSS_CRED_COLL TABLE*32290002
      *       WHEN THE DEPOSIT RECORD IS DELETED AND THE BILLING       *32300002
      *       OPTION IS IMMEDIATE, AND WHEN THE BILLING OPTION IS      *32310002
      *       CHANGED FROM BILL IMMEDIATE TO ANOTHER BILLING OPTION.   *32320002
      ******************************************************************32330002
       2951-DELETE-CREDIT-COL.                                          
      *                                                                 32350002
           EXEC SQL                                                     
               DELETE FROM CSS_CRED_COLL                                
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE = :DEPOSIT-MESSAGE-TYPE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32410002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 32440002
PCR263     IF (SQLCODE NOT EQUAL SUCCESSFUL-CALL)                       
PCR263        IF (SQLCODE EQUAL NOT-FOUND)                              
PCR263           AND (WS-OK-NOT-FOUND EQUAL VALUE-YES)                  
PCR263              NEXT SENTENCE                                       
PCR263        ELSE                                                      
PCR263              MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
PCR263              MOVE '2951'          TO ACTIVE-PARAGRAPH            
PCR263              MOVE 'DELETE'        TO ABEND-FUNCTION              
CBSI                MOVE SPACES          TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
PCR263              MOVE 'CSS_CRED_COLL' TO TABLE-1                     
PCR263              MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
PCR263              MOVE WS-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
PCR263              MOVE 'CODE_NOTICE_TYPE' TO TABLE-ELEMENT-2          
PCR263              MOVE DEPOSIT-MESSAGE-TYPE TO HOSTVAR-ELEMENT-2      
PCR263              MOVE 'ITEM_ID'       TO TABLE-ELEMENT-3             
PCR263              MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-3     
PCR263              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
PCR263        END-IF                                                    
           END-IF.                                                      
      *                                                                 32650002
      *                                                                 32660002
       2951-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32690002
      ******************************************************************32700002
      * 2960-SUM-AR-CONTROL                                            *32710002
      *    -- THIS MODULE SUMS UP THE AGING BUCKETS FROM THE DETAIL    *32720002
      *       DEPOSIT RECORDS (ITEM_ID > 0) IN THE CSS_AR_CNTL TABLE   *32730002
      *       WHEN THE BILL OPTION SELECTED WAS "IMMEDIATE".           *32740002
      ******************************************************************32750002
       2960-SUM-AR-CONTROL.                                             
      *                                                                 32770002
           EXEC SQL                                                     
               SELECT SUM(AMT_AR_DAY_00),                               
                      SUM(AMT_AR_DAY_30),                               
                      SUM(AMT_AR_DAY_60),                               
                      SUM(AMT_AR_DAY_90)                                
                 INTO :SUM-OF-00-DAY,                                   
                      :SUM-OF-30-DAY,                                   
                      :SUM-OF-60-DAY,                                   
                      :SUM-OF-90-DAY                                    
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 80                            
                  AND ITEM_ID           > 0                             
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32780002
MFA-TR*        SELECT SUM(AMT_AR_DAY_00),                               32790002
MFA-TR*               SUM(AMT_AR_DAY_30),                               32800002
MFA-TR*               SUM(AMT_AR_DAY_60),                               32810002
MFA-TR*               SUM(AMT_AR_DAY_90)                                32820002
MFA-TR*          INTO :SUM-OF-00-DAY,                                   32830002
MFA-TR*               :SUM-OF-30-DAY,                                   32840002
MFA-TR*               :SUM-OF-60-DAY,                                   32850002
MFA-TR*               :SUM-OF-90-DAY                                    32860002
MFA-TR*          FROM CSS_AR_CNTL                                       32870002
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                32880002
MFA-TR*           AND PYMT_PRIORITY_LVL = 80                            32890002
MFA-TR*           AND ITEM_ID           > 0                             32900002
MFA-TR*         WITH UR                                                 32910002
MFA-TR*    END-EXEC.                                                    32920002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32930002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 32960002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2960'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 33080002
      *                                                                 33090002
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33120002
      *                                                                 33130002
      ******************************************************************33140002
      * 2961-SET-AR-CONTROL                                            *33150002
      *    -- THIS MODULE SETS THE SUMMED AGING BUCKETS TO THE DEPOSIT *33160002
      *       SUMMARY ROW IN THE CSS_AR_CNTL TABLE.                    *33170002
      ******************************************************************33180002
       2961-SET-AR-CONTROL.                                             
      *                                                                 33200002
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_AR_DAY_00 = :SUM-OF-00-DAY,                   
                      AMT_AR_DAY_30 = :SUM-OF-30-DAY,                   
                      AMT_AR_DAY_60 = :SUM-OF-60-DAY,                   
                      AMT_AR_DAY_90 = :SUM-OF-90-DAY                    
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 80                            
                  AND ITEM_ID           = 0                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33310002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 33340002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2961'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15605        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'AMT_AR_DAY_00'       TO TABLE-ELEMENT-2             
CBSI          MOVE 'AMT_AR_DAY_30'       TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_AR_DAY_60'       TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE SUM-OF-00-DAY         TO HOSTVAR-ELEMENT-2-N         
CBSI          MOVE SUM-OF-30-DAY         TO HOSTVAR-ELEMENT-3-N         
CBSI          MOVE SUM-OF-60-DAY         TO HOSTVAR-ELEMENT-4-N         
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 33520002
      *                                                                 33530002
       2961-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33560002
      *                                                                 33570002
      ******************************************************************33580002
      * 2980-INSERT-OFF-CYCLE                                          *33590002
      *    -- THIS MODULE INSERTS A RECORD INTO THE OFF CYCLE TABLE TO *33600002
      *       POST A NOTICE TO THE BATCH BILLING PROGRAM TO PRINT THE  *33610002
      *       BILL FOR THIS IMMEDIATE DEPOSIT BILL.                    *33620002
      ******************************************************************33630002
      *2980-INSERT-OFF-CYCLE.                                           33640002
      *                                                                 33650002
      *    EXEC SQL                                                     33660002
      *        INSERT INTO CSS_OFF_CYCL_ACCT                            33670002
      *                   (ACCOUNT_NO,                                  33680002
      *                    CODE_BILL_OFF_CYCL,                          33690002
      *                    CUSTOMER_NO,                                 33700002
      *                    ITEM_ID,                                     33710002
      *                    LAST_UPDATE_TS)                              33720002
      *            VALUES (:WS-ACCOUNT-NO,                              33730002
      *                    :DEPOSIT-OFF-CYCLE-BILL,                     33740002
      *                    :AT-CUSTOMER-NO,                             33750002
      *                    :WS-DEPOSIT-CERT-NO-NO,                      33760002
      *                    CURRENT TIMESTAMP)                           33770002
      *    END-EXEC.                                                    33780002
      *                                                                 33790002
      *    MOVE SQLCODE                  TO RS-RETURN-CODE.             33800002
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      33810002
      *                                                                 33820002
      *    IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    33830002
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM               33840002
      *       MOVE '2980'                TO ACTIVE-PARAGRAPH            33850002
      *       MOVE 'INSERT'              TO ABEND-FUNCTION              33860002
      *       MOVE 'CSS_OFF_CYCLE_ACCT'  TO TABLE-1                     33870002
      *       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             33880002
      *       MOVE 'WS-ACCOUNT-NO'       TO HOSTVAR-ELEMENT-1           33890002
PCR263*       PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           33900002
      *    END-IF.                                                      33910002
      *                                                                 33920002
      *                                                                 33930002
      *2980-EXIT.                                                       33940002
      *    EXIT.                                                        33950002
      *                                                                 33960002
      *                                                                 33970002
      ******************************************************************33980002
      * 2981-DELETE-OFF-CYCLE                                          *33990002
      *    -- THIS MODULE DELETES A RECORD FROM THE OFF CYCLE TABLE.   *34000002
      *       THIS PROCEDURE IS PROCESSED WHEN DELETING A DEPOSIT      *34010002
      *       RECORD THAT IS SET UP TO BE BILLED IMMEDIATELY, OR IF    *34020002
      *       THE BILLING OPTION IS CHANGED FROM BEING BILLED          *34030002
      *       IMMEDIATELY IN A DEPOSIT RECORD UPDATE PROCEDURE.        *34040002
      ******************************************************************34050002
      *2981-DELETE-OFF-CYCLE.                                           34060002
      *                                                                 34070002
      *    EXEC SQL                                                     34080002
      *        DELETE FROM CSS_OFF_CYCL_ACCT                            34090002
      *              WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO          34100002
      *                AND CODE_BILL_OFF_CYCL = :DEPOSIT-OFF-CYCLE-BILL 34110002
      *                AND ITEM_ID            = :WS-DEPOSIT-CERT-NO-NO  34120002
      *    END-EXEC.                                                    34130002
      *                                                                 34140002
      *    MOVE SQLCODE                  TO RS-RETURN-CODE.             34150002
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      34160002
      *                                                                 34170002
      *    IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    34180002
      *       CONTINUE                                                  34190002
      *    ELSE                                                         34200002
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM               34210002
      *       MOVE '2981'                TO ACTIVE-PARAGRAPH            34220002
      *       MOVE 'DELETE'              TO ABEND-FUNCTION              34230002
      *       MOVE 'CSS_OFF_CYCLE_ACCT'  TO TABLE-1                     34240002
      *       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             34250002
      *       MOVE 'WS-ACCOUNT-NO'       TO HOSTVAR-ELEMENT-1           34260002
PCR263*       PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           34270002
      *    END-IF.                                                      34280002
      *                                                                 34290002
      *                                                                 34300002
      *2981-EXIT.                                                       34310002
      *    EXIT.                                                        34320002
      *                                                                 34330002
      ******************************************************************34340002
      * 2990-ADD-AR-BALANCE                                            *34350002
      *    -- THIS MODULE UPDATES THE TOTAL_AR_BALANCE COLUMN ON THE   *34360002
      *       CSS_ACCOUNT TABLE WHEN A NEW DEPOSIT IS BEING BILLED     *34370002
      *       IMMEDIATELY.  IT ADDS THE DEPOSIT AMOUNT ENTERED ON      *34380002
      *       THE DEPOSITS PANEL TO THIS COLUMN.                       *34390002
      ******************************************************************34400002
       2990-ADD-AR-BALANCE.                                             
      *                                                                 34420002
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE +             
                                         :WS-AMT-ORIG-ENTERED,          
T21068                LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     34430002
MFA-TR*        UPDATE CSS_ACCOUNT                                       34440002
MFA-TR*           SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE +             34450002
MFA-TR*                                  :WS-AMT-ORIG-ENTERED,          34460002
MFA-TR*               LAST_UPDATE_TS   = :AT-LAST-UPDATE-TS             34470002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 34480002
MFA-TR*    END-EXEC.                                                    34490002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34500002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 34530002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2990'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T21068        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-2             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T21068        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 34670002
      *                                                                 34680002
       2990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34720002
      * 2991-SUBTRACT-AR-BALANCE                                       *34730002
      *    -- THIS MODULE UPDATES THE TOTAL_AR_BALANCE COLUMN ON THE   *34740002
      *       CSS_ACCOUNT TABLE WHEN A NEW DEPOSIT IS BEING DELETED    *34750002
      *       FROM BILL IMMEDIATELY. IT SUBTRACTS THE DEPOSIT AMOUNT   *34760002
      *       ENTERED ON THE DEPOSITS PANEL.                           *34770002
      ******************************************************************34780002
       2991-SUBTRACT-AR-BALANCE.                                        
      *                                                                 34800002
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE -             
                                         :WS-AMT-ORIG-ENTERED,          
T21068                LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     34810002
MFA-TR*        UPDATE CSS_ACCOUNT                                       34820002
MFA-TR*           SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE -             34830002
MFA-TR*                                  :WS-AMT-ORIG-ENTERED,          34840002
MFA-TR*               LAST_UPDATE_TS   = :AT-LAST-UPDATE-TS             34850002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 34860002
MFA-TR*    END-EXEC.                                                    34870002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34880002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 34910002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2991'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T21068        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-2             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T21068        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 35050002
      *                                                                 35060002
       2991-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************35100002
      * 2992-REBILL-AR-BALANCE                                         *35110002
      *    -- THIS MODULE UPDATES THE TOTAL_AR_BALANCE COLUMN ON THE   *35120002
      *       CSS_ACCOUNT TABLE WHEN A DEPOSIT IS BEING REBILLED.      *35130002
      ******************************************************************35140002
       2992-REBILL-AR-BALANCE.                                          
      *                                                                 35160002
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE -             
                                         :WS-TOTAL-AGED,                
T21068                LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35170002
MFA-TR*        UPDATE CSS_ACCOUNT                                       35180002
MFA-TR*           SET TOTAL_AR_BALANCE = TOTAL_AR_BALANCE -             35190002
MFA-TR*                                  :WS-TOTAL-AGED,                35200002
MFA-TR*               LAST_UPDATE_TS   = :AT-LAST-UPDATE-TS             35210002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 35220002
MFA-TR*    END-EXEC.                                                    35230002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35240002
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 35270002
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2992'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T21068        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-2             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T21068        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-2           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 35410002
      *                                                                 35420002
       2992-EXIT.                                                       
           EXIT.                                                        
PCR263*                                                                 35450002
PCR263************************************************************      35460002
PCR263* 3000-MEDICAL-CERT-EXP-DATE                               *      35470002
PCR263*     SELECTS EXPIRATION DATE FOR THE MEDICAL CERTIFICATE  *      35480002
PCR263*     FROM CSS_CUST_ALERT TABLE.                           *      35490002
PCR263*                                                          *      35500002
PCR263************************************************************      35510002
PCR263*                                                                 35520002
PCR263 3000-MEDICAL-CERT-EXP-DATE.                                      
PCR263     EXEC SQL                                                     
PCR263        SELECT DATE_EXPIRE                                        
PCR263        INTO   :CA-DATE-EXPIRE                                    
PCR263        FROM   CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
PCR263        WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                        
PCR263        AND    DATE_EXPIRE >= IIF(TRY_CONVERT(DATE, :CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CURRENT-DATE
              ) <> 0) OR (LEN(:CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                          :CURRENT-DATE
              ), CONVERT(DATE, :CURRENT-DATE) )                       
A37061                                                           
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35540002
MFA-TR*       SELECT DATE_EXPIRE                                        35550002
MFA-TR*       INTO   :CA-DATE-EXPIRE                                    35560002
MFA-TR*       FROM   CSS_CUST_ALERT                                     35570002
MFA-TR*       WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                        35580002
MFA-TR*       AND    DATE_EXPIRE >= :CURRENT-DATE                       35590002
MFA-TR*       WITH UR                                                   35600002
MFA-TR*    END-EXEC.                                                    35610002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263     MOVE SQLCODE                  TO RS-RETURN-CODE              
PCR263                                      WS-ACTIVE-RETURN-CODE.      
PCR263     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
PCR263         NEXT SENTENCE                                            
PCR263     ELSE                                                         
PCR263         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PCR263         MOVE '3000'               TO ACTIVE-PARAGRAPH            
PCR263         MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
PCR263         MOVE 'CSS_CUST_ALERT'     TO TABLE-1                     
PCR263         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
PCR263         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE 'DATE_EXPIRE'        TO TABLE-ELEMENT-2             
CBSI           MOVE CURRENT-DATE         TO HOSTVAR-ELEMENT-2           
PCR263         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
PCR263     END-IF.                                                      
PCR263*                                                                 35790002
PCR263 3000-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263*                                                                 35820002
C27353***************************************************************** 35830002
C27353* 5000-CHECK-DEP-TYPE                                           * 35840002
C27353*                                                               * 35850002
C27353*      DETERMINE THE DEPOSIT TYPE DESCRIPTION THAT SHOULD BE    * 35860002
C27353*      DISPLAYED ON TRANS HIST.                                 * 35870002
C27353***************************************************************** 35880002
C27353                                                                  
C27353 5000-CHECK-DEP-TYPE.                                             
C27353                                                                  
C27353     EVALUATE WS-DEP-TYPE                                         
C27353        WHEN 'I'                                                  
C27353           MOVE 'INITIAL'          TO WS-DEP-TYPE-DESC            
C27353        WHEN 'D'                                                  
C27353           MOVE 'DNP'              TO WS-DEP-TYPE-DESC            
C27353        WHEN 'R'                                                  
C27353           MOVE 'RET CHECK'        TO WS-DEP-TYPE-DESC            
C27353        WHEN 'P'                                                  
C27353           MOVE 'DPP'              TO WS-DEP-TYPE-DESC            
T28160        WHEN 'A'                                                  
T28160           MOVE 'PPA'              TO WS-DEP-TYPE-DESC            
C27353        WHEN 'O'                                                  
C27353           MOVE 'OTHER'            TO WS-DEP-TYPE-DESC            
C27353        WHEN '1'                                                  
C27353           MOVE 'GROUP 1'          TO WS-DEP-TYPE-DESC            
C27353        WHEN '2'                                                  
C27353           MOVE 'GROUP 2'          TO WS-DEP-TYPE-DESC            
T26296        WHEN 'B'                                                  
T26296           MOVE 'AUTO DEP DNP'     TO WS-DEP-TYPE-DESC            
T26296        WHEN 'C'                                                  
T26296           MOVE 'AUTO DEP RT CHK'  TO WS-DEP-TYPE-DESC            
C27353        WHEN OTHER                                                
C27353           MOVE WS-DEP-TYPE        TO WS-DEP-TYPE-DESC            
C27353     END-EVALUATE.                                                
C27353                                                                  
C27353 5000-EXIT.                                                       
C27353     EXIT.                                                        
                                                                        
P00599******************************************************************        
P00599* 5005-CALL-NOTICES                                                       
P00599******************************************************************        
P00599*                                                                         
P00599 5005-CALL-NOTICES.                                               
P00599                                                                  
P00599     CALL MCSKR125 USING   WS-CORRESP-HDR                         
P00599                           WS-CORRESP-NOTICE                      
P00599                           WS-CORRESP-VAR                         
P00599                           WS-MISC-PROCESSING-VARS                
P00599                           WS-KR125-COMM-DATA-VARS                
P00599                           WS-KR125-MNT-TRANS-VARS                
P00599                           ABEND-FILE                             
P00599                           WS-CWS350-MISC                         
P00599                           WS-CORRESP-COMM-VAR                    
P00599                           RS-KR125-RETURN-CODE.                  
P00599                                                                  
P00599     IF ABEND-FUNCTION  > SPACES                                  
P00599        MOVE ABEND-SQLCODE           TO RS-RETURN-CODE            
P00599                                        WS-ACTIVE-RETURN-CODE     
P00599        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P00599     END-IF.                                                      
P00599                                                                  
P00599 5005-EXIT.                                                       
P00599     EXIT.                                                        
T28160***************************************************************** 36200002
T28160* 5010-CHECK-REF-ELIG                                           * 36210002
T28160*                                                               * 36220002
T28160*      DETERMINE THE REFUND ELIG  DESCRIPTION THAT SHOULD BE    * 36230002
T28160*      DISPLAYED ON TRANS HIST.                                 * 36240002
T28160***************************************************************** 36250002
T28160                                                                  
T28160 5010-CHECK-REF-ELIG.                                             
T28160                                                                  
T28160     EVALUATE WS-REF-ELIG                                         
T28160        WHEN '0'                                                  
T28160           MOVE 'ELIGIBLE'      TO WS-REF-ELIG-DESC               
T28160        WHEN 'A'                                                  
T28160           MOVE 'NOT ELIGIBLE'  TO WS-REF-ELIG-DESC               
T28160        WHEN OTHER                                                
T28160           MOVE WS-REF-ELIG     TO WS-REF-ELIG-DESC               
T28160     END-EVALUATE.                                                
T28160                                                                  
T28160 5010-EXIT.                                                       
T28160     EXIT.                                                        
T26296*                                                                 36400002
T26296***************************************************************** 36410002
T26296* 5015-AUTODEP-LTR-IND                                          * 36420002
T26296*    DETERMINE THE AUTO DEPOSIT LETTER NOTIFICATION DESCRIPTION * 36430002
T26296*    THAT SHOULD BE DISPLAYED ON TRANS HIST.                    * 36440002
T26296***************************************************************** 36450002
T26296 5015-AUTODEP-LTR-IND.                                            
T26296                                                                  
T26296     EVALUATE WS-LTR-IND                                          
T26296        WHEN 'Q'                                                  
T26296           MOVE 'QUOTED'        TO WS-LTR-IND-DESC                
T26296        WHEN 'L'                                                  
T26296           MOVE 'LETTER'        TO WS-LTR-IND-DESC                
T26296        WHEN 'C'                                                  
T26296           MOVE 'QUOTED/LETTER' TO WS-LTR-IND-DESC                
T26296     END-EVALUATE.                                                
T26296                                                                  
T26296 5015-EXIT.                                                       
T26296     EXIT.                                                        
T26296*                                                                 36590002
      ***************************************************************** 36600002
      * 5050-CHECK-SEC-DEP                                            * 36610002
      *                                                               * 36620002
      *      CHECK FOR EXISTENCE OF ANY SECURITIES IN CSS_SURETY_BOND * 36630002
      *      OR ANY GUARANTOR DETAIL IN CSS_GUARANTOR TABLE. IF ANY   * 36640002
      *      OF THESE EXISTS THEN THE SECURED-ACCOUNT-INDICATOR       * 36650002
      *      IN CODES-DATA-PRESENT COLUMN OF CSS_ACCOUNT SHOULD NOT   * 36660002
      *      BE MODIFIED                                              * 36670002
      ***************************************************************** 36680002
                                                                        
       5050-CHECK-SEC-DEP.                                              
                                                                        
           MOVE 'N'           TO SECURITY-EXISTS-SW.                    
           MOVE WS-ACCOUNT-NO TO SB-ACCOUNT-NO                          
                                 GU-ACCOUNT-NO.                         
           PERFORM 7400-OPEN-SURETY-CURSOR     THRU 7400-EXIT.          
           PERFORM 7410-FETCH-SURETY-CURSOR    THRU 7410-EXIT.          
           PERFORM 7420-CLOSE-SURETY-CURSOR    THRU 7420-EXIT.          
           IF NO-SECURITY-EXISTS                                        
              PERFORM 7430-OPEN-GUARNT-CURSOR     THRU 7430-EXIT        
              PERFORM 7440-FETCH-GUARNT-CURSOR    THRU 7440-EXIT        
              PERFORM 7450-CLOSE-GUARNT-CURSOR    THRU 7450-EXIT        
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
TP5519******************************************************************36870002
TP5519* 5100-MOVE-TRAN-HEAD                                            *36880002
TP5519******************************************************************36890002
TP5519                                                                  
TP5519 5100-MOVE-TRAN-HEAD.                                             
TP5519                                                                  
TP5519      MOVE CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO.          
TP5519      MOVE CURRENT-DATE         TO MH-DATE-TRANS.                 
TP5519      MOVE 'F'                  TO MH-CODE-TRAN-TYPE.             
TP5519      MOVE PF-RESP-AREA-ID      TO MH-RESP-AREA-ID.               
TP5519      MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO.                 
TP5519      MOVE 0                    TO MH-CUSTOMER-NO.                
TP5519      MOVE 0                    TO MH-PREMISE-NO.                 
TP5519      MOVE PARM-USER-ID-UPDT-BY TO MH-USER-ID.                    
MAD422      MOVE 'PANEL141B'          TO MH-APPL-PROGRAM-ID.            
TP5519*     MOVE WS-COMMENT-LEN-NO    TO MH-TRAN-COMMENT-LEN.           37020002
C28160      ADD  19                   TO WS-COMMENT-LEN-NO.             
C28160      MOVE WS-COMMENT-LEN-NO    TO MH-TRAN-COMMENT-LEN.           
TP5519*     MOVE PARM-COMMENTS        TO MH-TRAN-COMMENT-TEXT.          37050002
C28160      MOVE PARM-COMMENTS        TO WS-NEW-TRANS-CMMTS.            
C28160      MOVE WS-DEP-CERT-COMMENT  TO MH-TRAN-COMMENT-TEXT.          
TP5519                                                                  
TP5519 5100-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
TP5519******************************************************************37120002
TP5519* 5200-MOVE-TRAN-DET-UPD.                                        *37130002
TP5519******************************************************************37140002
TP5519                                                                  
TP5519 5200-MOVE-TRAN-DET-UPD.                                          
TP5519                                                                  
TP5519     MOVE '5200'                      TO ACTIVE-PARAGRAPH.        
TP5519     MOVE +1                          TO MI-TRAN-APPL-NO.         
TP5519                                                                  
TP5519     IF DO-DEP-ACTION-CODE NOT EQUAL PARM-DEP-ACTION-CODE         
TP5519        IF PARM-DEP-ACTION-CODE EQUAL SPACES                      
TP5519           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
TP5519           MOVE PARM-DEP-ACTION-CODE                              
TP5519                                TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +1              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        IF DO-DEP-ACTION-CODE EQUAL SPACES                        
TP5519           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
TP5519           MOVE DO-DEP-ACTION-CODE                                
TP5519                                TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +1              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        MOVE 'REBILL INDICATR'        TO MI-COLUMN-DESC           
TP5519        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP5519        ADD 1                         TO MI-TRAN-APPL-NO          
TP5519     END-IF.                                                      
TP5519                                                                  
TP5519     IF WS-AMT-MO-PYMT-NO NOT EQUAL DR-AMT-MO-PYMT                
TP5519        IF WS-AMT-MO-PYMT-NO EQUAL ZEROES                         
TP5519           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
TP5519           MOVE WS-AMT-MO-PYMT-NO                                 
TP5519                                TO WS-ELEVEN-LEN-DEC              
T31725           MOVE WS-ELEVEN-LEN-DEC                                 
T31725                               TO WS-ELEVEN-LEN-DEC-Z             
T31725*          MOVE WS-ELEVEN-LEN-DEC-RED                             37520002
T31725           MOVE WS-ELEVEN-LEN-DEC-Z                               
TP5519                                TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        IF DR-AMT-MO-PYMT EQUAL ZEROES                            
TP5519           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
TP5519           MOVE DR-AMT-MO-PYMT  TO WS-NINE-LEN-DEC                
T31725           MOVE WS-NINE-LEN-DEC TO WS-NINE-LEN-DEC-Z              
T31725*          MOVE WS-NINE-LEN-DEC-RED                               37630002
T31725           MOVE WS-NINE-LEN-DEC-Z                                 
TP5519                                TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +11             TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        MOVE 'AMT MO PYMT    '        TO MI-COLUMN-DESC           
TP5519        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP5519        ADD 1                         TO MI-TRAN-APPL-NO          
TP5519     END-IF.                                                      
TP5519                                                                  
TP5519     IF WS-NO-SCHED-PYMTS-NO NOT EQUAL DR-NO-SCHED-PYMTS          
TP5519        IF WS-NO-SCHED-PYMTS-NO EQUAL ZEROES                      
TP5519           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
T31725           MOVE PARM-NO-SCHED-PYMTS                               
T31725                                TO WS-SCHED-PYMTS-Z               
T31725*          MOVE PARM-NO-SCHED-PYMTS                               37800002
T31725           MOVE WS-SCHED-PYMTS-Z                                  
TP5519                                TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +3              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        IF DR-NO-SCHED-PYMTS EQUAL ZEROES                         
TP5519           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
TP5519           MOVE DR-NO-SCHED-PYMTS                                 
TP5519                                TO WS-SIGN-FOUR                   
T31725           MOVE WS-SIGN-FOUR    TO WS-SIGN-FOUR-Z                 
T31725*          MOVE WS-SIGN-FOUR-RED                                  37920002
T31725           MOVE WS-SIGN-FOUR-Z                                    
TP5519                                TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +4              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        END-IF                                                    
TP5519        MOVE 'NO SCHED PYMTS '        TO MI-COLUMN-DESC           
TP5519        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP5519        ADD 1                         TO MI-TRAN-APPL-NO          
TP5519     END-IF.                                                      
TP5519                                                                  
TP5519     IF DR-DEP-BILL-OPTION-CD NOT EQUAL PARM-BILL-OPTION-CD       
TP5519        IF PARM-BILL-OPTION-CD EQUAL SPACES                       
TP5519           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
TP5519           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
PCR404           EVALUATE TRUE                                          
PCR404             WHEN PARM-BILL-OPTION-CD = 'N'                       
PCR404               MOVE 'NEXT BILLING'                                
PCR404                                TO MI-CHG-COLUMN-VALUE-TEXT       
PCR404               MOVE +12         TO MI-CHG-COLUMN-VALUE-LEN        
PCR404             WHEN PARM-BILL-OPTION-CD = 'I'                       
PCR404               MOVE 'IMMEDIATELY'                                 
PCR404                                TO MI-CHG-COLUMN-VALUE-TEXT       
PCR404               MOVE +11         TO MI-CHG-COLUMN-VALUE-LEN        
PCR404             WHEN PARM-BILL-OPTION-CD = 'T'                       
PCR404               MOVE 'INSTALLMENTS'                                
PCR404                                TO MI-CHG-COLUMN-VALUE-TEXT       
PCR404               MOVE +12         TO MI-CHG-COLUMN-VALUE-LEN        
PCR404           END-EVALUATE                                           
TP5519        END-IF                                                    
TP5519        IF DR-DEP-BILL-OPTION-CD EQUAL SPACES                     
TP5519           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
TP5519           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
TP5519        ELSE                                                      
PCR404           EVALUATE TRUE                                          
PCR404             WHEN DR-DEP-BILL-OPTION-CD = 'N'                     
PCR404               MOVE 'NEXT BILLING'                                
PCR404                                TO MI-PRV-COLUMN-VALUE-TEXT       
PCR404               MOVE +12         TO MI-PRV-COLUMN-VALUE-LEN        
PCR404             WHEN DR-DEP-BILL-OPTION-CD = 'I'                     
PCR404               MOVE 'IMMEDIATELY'                                 
PCR404                                TO MI-PRV-COLUMN-VALUE-TEXT       
PCR404               MOVE +11         TO MI-PRV-COLUMN-VALUE-LEN        
PCR404             WHEN DR-DEP-BILL-OPTION-CD = 'T'                     
PCR404               MOVE 'INSTALLMENTS'                                
PCR404                                TO MI-PRV-COLUMN-VALUE-TEXT       
PCR404               MOVE +12         TO MI-PRV-COLUMN-VALUE-LEN        
PCR404           END-EVALUATE                                           
TP5519        END-IF                                                    
PCR404        MOVE 'BILLING OPTION'         TO MI-COLUMN-DESC           
TP5519        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP5519        ADD 1                         TO MI-TRAN-APPL-NO          
TP5519     END-IF.                                                      
TP5519                                                                  
PCR404     IF DO-CODE-DEP-TYPE NOT EQUAL PARM-CODE-DEP-TYPE             
PCR404        IF PARM-CODE-DEP-TYPE EQUAL SPACES                        
PCR404           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
PCR404           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
PCR404        ELSE                                                      
C27353           MOVE PARM-CODE-DEP-TYPE TO WS-DEP-TYPE                 
C27353           PERFORM 5000-CHECK-DEP-TYPE THRU 5000-EXIT             
C27353           MOVE WS-DEP-TYPE-DESC                                  
PCR404                                TO MI-CHG-COLUMN-VALUE-TEXT       
PCR404           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
PCR404        END-IF                                                    
PCR404        IF DO-CODE-DEP-TYPE EQUAL SPACES                          
PCR404           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
PCR404           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
PCR404        ELSE                                                      
C27353           MOVE DO-CODE-DEP-TYPE TO WS-DEP-TYPE                   
C27353           PERFORM 5000-CHECK-DEP-TYPE THRU 5000-EXIT             
C27353           MOVE WS-DEP-TYPE-DESC                                  
PCR404                                TO MI-PRV-COLUMN-VALUE-TEXT       
PCR404           MOVE +9              TO MI-PRV-COLUMN-VALUE-LEN        
PCR404        END-IF                                                    
PCR404        MOVE 'DEPOSIT TYPE'           TO MI-COLUMN-DESC           
PCR404        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
PCR404        ADD 1                         TO MI-TRAN-APPL-NO          
PCR404     END-IF.                                                      
PCR404                                                                  
T28160     IF DO-CODE-REFUND-ELIG NOT EQUAL PARM-CODE-REFUND-ELIG       
T28160        IF PARM-CODE-REFUND-ELIG EQUAL SPACES                     
T28160           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE PARM-CODE-REFUND-ELIG TO WS-REF-ELIG              
T28160           PERFORM 5010-CHECK-REF-ELIG THRU 5010-EXIT             
T28160           MOVE WS-REF-ELIG-DESC                                  
T28160                                TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +12             TO MI-CHG-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        IF DO-CODE-REFUND-ELIG EQUAL SPACES                       
T28160           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE DO-CODE-REFUND-ELIG TO WS-REF-ELIG                
T28160           PERFORM 5010-CHECK-REF-ELIG THRU 5010-EXIT             
T28160           MOVE WS-REF-ELIG-DESC                                  
T28160                                TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +12             TO MI-PRV-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        MOVE 'REFUND ELIG'            TO MI-COLUMN-DESC           
T28160        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T28160        ADD 1                         TO MI-TRAN-APPL-NO          
T28160     END-IF.                                                      
T28160                                                                  
TP5519     IF ((PARM-DEP-ACTION-CODE = REBILLED) OR                     
TP5519         (PARM-BILL-OPTION-CD = PARM-ORIG-BILL-OPTION-CD))        
TP5519                                                                  
TP5519        IF CURRENT-DATE NOT EQUAL DR-REBILLED-DEP-DATE            
TP5519           MOVE CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519           MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           IF DR-REBILLED-DEP-DATE EQUAL SPACES                   
TP5519              MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE DR-REBILLED-DEP-DATE                           
TP5519                                   TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +10             TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           MOVE 'REBILLD DEP DTE'        TO MI-COLUMN-DESC        
TP5519           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
TP5519           ADD 1                         TO MI-TRAN-APPL-NO       
TP5519        END-IF                                                    
TP5519                                                                  
TP5519     END-IF.                                                      
T26296*                                                                 39180002
T26296     IF (DO-AUTO-DEP-LTR-IND NOT EQUAL PARM-AUTO-DEP-LTR-IND)     
T26296                      AND (DO-AUTO-DEP-LTR-IND > SPACES OR        
T26296                           PARM-AUTO-DEP-LTR-IND > SPACES)        
T26296        IF DO-AUTO-DEP-LTR-IND > SPACES                           
T26296           MOVE DO-AUTO-DEP-LTR-IND   TO WS-LTR-IND               
T26296           PERFORM 5015-AUTODEP-LTR-IND  THRU 5015-EXIT           
T26296           MOVE WS-LTR-IND-DESC       TO MI-PRV-COLUMN-VALUE-TEXT 
T26296           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
T26296        END-IF                                                    
T26296        IF PARM-AUTO-DEP-LTR-IND > SPACES                         
T26296           MOVE PARM-AUTO-DEP-LTR-IND TO WS-LTR-IND               
T26296           PERFORM 5015-AUTODEP-LTR-IND  THRU 5015-EXIT           
T26296           MOVE WS-LTR-IND-DESC       TO MI-CHG-COLUMN-VALUE-TEXT 
T26296           MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
T26296        END-IF                                                    
T26296        MOVE 'AUTO DEP LTR IND'       TO MI-COLUMN-DESC           
T26296        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T26296        ADD 1                         TO MI-TRAN-APPL-NO          
T26296     END-IF.                                                      
T26296*                                                                 39380002
T26296     IF WS-ORIG-AMT-TOT-RCNT NOT EQUAL DL-AMT-TOT-RECONNECT       
T26296        IF WS-ORIG-AMT-TOT-RCNT > 0                               
T26296           MOVE WS-ORIG-AMT-TOT-RCNT  TO WS-ELEVEN-LEN-DEC        
T26296           MOVE WS-ELEVEN-LEN-DEC-RED TO MI-PRV-COLUMN-VALUE-TEXT 
T26296           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
T26296        END-IF                                                    
T26296        IF DL-AMT-TOT-RECONNECT > 0                               
T26296           MOVE DL-AMT-TOT-RECONNECT  TO WS-ELEVEN-LEN-DEC        
T26296           MOVE WS-ELEVEN-LEN-DEC-RED TO MI-CHG-COLUMN-VALUE-TEXT 
T26296           MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
T26296        END-IF                                                    
T26296        MOVE 'AMT TOT RECONNECT'      TO MI-COLUMN-DESC           
T26296        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T26296        ADD 1                         TO MI-TRAN-APPL-NO          
T26296     END-IF.                                                      
T26296*                                                                 39540002
TP5519 5200-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
T28160                                                                  
T28160******************************************************************39590002
T28160* 5210-MOVE-TRAN-DET-PAID                                        *39600002
T28160******************************************************************39610002
T28160                                                                  
T28160 5210-MOVE-TRAN-DET-PAID.                                         
T28160                                                                  
T28160     MOVE '5210'                      TO ACTIVE-PARAGRAPH.        
T28160     MOVE +1                          TO MI-TRAN-APPL-NO.         
T28160                                                                  
T28160     IF DO-CODE-DEP-TYPE NOT EQUAL PARM-CODE-DEP-TYPE             
T28160        IF PARM-CODE-DEP-TYPE EQUAL SPACES                        
T28160           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE PARM-CODE-DEP-TYPE TO WS-DEP-TYPE                 
T28160           PERFORM 5000-CHECK-DEP-TYPE THRU 5000-EXIT             
T28160           MOVE WS-DEP-TYPE-DESC                                  
T28160                                TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        IF DO-CODE-DEP-TYPE EQUAL SPACES                          
T28160           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE DO-CODE-DEP-TYPE TO WS-DEP-TYPE                   
T28160           PERFORM 5000-CHECK-DEP-TYPE THRU 5000-EXIT             
T28160           MOVE WS-DEP-TYPE-DESC                                  
T28160                                TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +9              TO MI-PRV-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        MOVE 'DEPOSIT TYPE'           TO MI-COLUMN-DESC           
T28160        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T28160        ADD 1                         TO MI-TRAN-APPL-NO          
T28160     END-IF.                                                      
T28160                                                                  
T28160     IF DO-CODE-REFUND-ELIG NOT EQUAL PARM-CODE-REFUND-ELIG       
T28160        IF PARM-CODE-REFUND-ELIG EQUAL SPACES                     
T28160           MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE PARM-CODE-REFUND-ELIG TO WS-REF-ELIG              
T28160           PERFORM 5010-CHECK-REF-ELIG THRU 5010-EXIT             
T28160           MOVE WS-REF-ELIG-DESC                                  
T28160                                TO MI-CHG-COLUMN-VALUE-TEXT       
T28160           MOVE +12             TO MI-CHG-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        IF DO-CODE-REFUND-ELIG EQUAL SPACES                       
T28160           MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN        
T28160        ELSE                                                      
T28160           MOVE DO-CODE-REFUND-ELIG TO WS-REF-ELIG                
T28160           PERFORM 5010-CHECK-REF-ELIG THRU 5010-EXIT             
T28160           MOVE WS-REF-ELIG-DESC                                  
T28160                                TO MI-PRV-COLUMN-VALUE-TEXT       
T28160           MOVE +12             TO MI-PRV-COLUMN-VALUE-LEN        
T28160        END-IF                                                    
T28160        MOVE 'REFUND ELIG'            TO MI-COLUMN-DESC           
T28160        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T28160        ADD 1                         TO MI-TRAN-APPL-NO          
T28160     END-IF.                                                      
T28160                                                                  
T28160 5210-EXIT.                                                       
T28160     EXIT.                                                        
                                                                        
TP5519******************************************************************40230002
TP5519* 5400-TRN-DET-CL-INS.                                           *40240002
TP5519******************************************************************40250002
TP5519                                                                  
TP5519 5400-TRN-DET-CL-INS.                                             
TP5519                                                                  
TP5519     MOVE '5400'                      TO ACTIVE-PARAGRAPH.        
TP5519                                                                  
TP5519     IF CL-CODE-NOTICE-TYPE EQUAL WS-O                            
TP5519        IF WS-OLD-DATE-NOTICE-DUE NOT EQUAL CL-DATE-NOTICE-DUE    
TP5519           IF CL-DATE-NOTICE-DUE EQUAL SPACES                     
TP5519              MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE CL-DATE-NOTICE-DUE                             
TP5519                                   TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +10             TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           IF WS-OLD-DATE-NOTICE-DUE EQUAL SPACES                 
TP5519              MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE WS-OLD-DATE-NOTICE-DUE                         
TP5519                                   TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +1              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           MOVE 'DUE DATE       '        TO MI-COLUMN-DESC        
TP5519           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
TP5519           ADD 1                         TO MI-TRAN-APPL-NO       
TP5519        END-IF                                                    
TP5519        IF WS-OLD-DATE-BILL NOT EQUAL CL-DATE-BILL                
TP5519           IF CL-DATE-BILL EQUAL SPACES                           
TP5519              MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE CL-DATE-BILL                                   
TP5519                                   TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +10             TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           IF WS-OLD-DATE-BILL EQUAL SPACES                       
TP5519              MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE WS-OLD-DATE-BILL                               
TP5519                                   TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +1              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           MOVE 'BILL DATE      '        TO MI-COLUMN-DESC        
TP5519           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
TP5519           ADD 1                         TO MI-TRAN-APPL-NO       
TP5519        END-IF                                                    
TP5519     ELSE                                                         
TP5519        IF WS-OLD-DATE-CREDIT-ACTION                              
TP5519                            NOT EQUAL CL-DATE-CREDIT-ACTION       
TP5519           IF CL-DATE-CREDIT-ACTION EQUAL SPACES                  
TP5519              MOVE '*DELETED*'     TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE CL-DATE-CREDIT-ACTION                          
TP5519                                   TO MI-CHG-COLUMN-VALUE-TEXT    
TP5519              MOVE +10             TO MI-CHG-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           IF WS-OLD-DATE-CREDIT-ACTION EQUAL SPACES              
TP5519              MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           ELSE                                                   
TP5519              MOVE WS-OLD-DATE-CREDIT-ACTION                      
TP5519                                   TO MI-PRV-COLUMN-VALUE-TEXT    
TP5519              MOVE +1              TO MI-PRV-COLUMN-VALUE-LEN     
TP5519           END-IF                                                 
TP5519           MOVE 'DNP DATE       '        TO MI-COLUMN-DESC        
TP5519           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
TP5519           ADD 1                         TO MI-TRAN-APPL-NO       
TP5519        END-IF                                                    
TP5519     END-IF.                                                      
TP5519                                                                  
TP5519 5400-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
TP5519**************************************************************    41020002
TP5519* JOURNALING INCLUDE                                         *    41030002
TP5519**************************************************************    41040002
TP5519     EXEC SQL                                                     41050002
TP5519        INCLUDE CPD00067                                          41060002
TP5519     END-EXEC.                                                    41070002
                                                                        
TP5519***************************************************************** 41090002
TP5519* 7000-SELECT-DEP-ON-HAND.                                      * 41100002
TP5519*     CALLS 9700-PROCESS-ABENDS                                 * 41110002
TP5519*                                                               * 41120002
TP5519*     SELECTS FROM CSS_DEP_ON_HAND                              * 41130002
TP5519*                                                               * 41140002
TP5519***************************************************************** 41150002
TP5519                                                                  
TP5519 7000-SELECT-DEP-ON-HAND.                                         
TP5519                                                                  
TP5519     MOVE '7000'       TO ACTIVE-PARAGRAPH                        
TP5519                                                                  
TP5519     EXEC SQL                                                     
TP5519       SELECT DEPOSIT_STATUS_CD,                                  
TP5519              DEP_ACTION_CODE,                                    
TP5519              USER_ID_UPDT_BY,                                    
TP5519              SERVICE_TYPE_CD,                                    
TP5519              CODE_DEP_TYPE,                                      
T28160              CODE_REFUND_ELIG,                                   
T26296              AUTO_DEP_LTR_IND,                                   
T26296              AMT_DEPOSIT                                         
TP5519       INTO   :DO-DEPOSIT-STATUS-CD,                              
TP5519              :DO-DEP-ACTION-CODE,                                
TP5519              :DO-USER-ID-UPDT-BY,                                
TP5519              :DO-SERVICE-TYPE-CD,                                
TP5519              :DO-CODE-DEP-TYPE,                                  
T28160              :DO-CODE-REFUND-ELIG,                               
T26296              :DO-AUTO-DEP-LTR-IND,                               
T26296              :DO-AMT-DEPOSIT                                     
TP5519       FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                       
TP5519       WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                   
TP5519         AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO           
A37061                                                           
TP5519     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     41210002
MFA-TR*      SELECT DEPOSIT_STATUS_CD,                                  41220002
MFA-TR*             DEP_ACTION_CODE,                                    41230002
MFA-TR*             USER_ID_UPDT_BY,                                    41240002
MFA-TR*             SERVICE_TYPE_CD,                                    41250002
MFA-TR*             CODE_DEP_TYPE,                                      41260002
MFA-TR*             CODE_REFUND_ELIG,                                   41270002
MFA-TR*             AUTO_DEP_LTR_IND,                                   41280002
MFA-TR*             AMT_DEPOSIT                                         41290002
MFA-TR*      INTO   :DO-DEPOSIT-STATUS-CD,                              41300002
MFA-TR*             :DO-DEP-ACTION-CODE,                                41310002
MFA-TR*             :DO-USER-ID-UPDT-BY,                                41320002
MFA-TR*             :DO-SERVICE-TYPE-CD,                                41330002
MFA-TR*             :DO-CODE-DEP-TYPE,                                  41340002
MFA-TR*             :DO-CODE-REFUND-ELIG,                               41350002
MFA-TR*             :DO-AUTO-DEP-LTR-IND,                               41360002
MFA-TR*             :DO-AMT-DEPOSIT                                     41370002
MFA-TR*      FROM   CSS_DEP_ON_HAND                                     41380002
MFA-TR*      WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                   41390002
MFA-TR*        AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO           41400002
MFA-TR*      WITH UR                                                    41410002
MFA-TR*    END-EXEC.                                                    41420002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5519                                                                  
TP5519     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TP5519                                                                  
TP5519     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
TP5519        NEXT SENTENCE                                             
TP5519     ELSE                                                         
TP5519        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
TP5519        MOVE 'SELECT            '       TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
TP5519        MOVE 'CSS_DEP_ON_HAND   '       TO TABLE-1                
TP5519        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'DEPOSIT_CERT_NO'          TO TABLE-ELEMENT-2        
TP5519        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
TP5519        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
TP5519        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
TP5519     END-IF.                                                      
TP5519 7000-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
TP5519***************************************************************** 41630002
TP5519* 7100-SELECT-DEP-REQ.                                          * 41640002
TP5519*     CALLS 9700-PROCESS-ABENDS                                 * 41650002
TP5519*                                                               * 41660002
TP5519*     SELECTS FROM CSS_DEP_REQ                                  * 41670002
TP5519*                                                               * 41680002
TP5519***************************************************************** 41690002
TP5519                                                                  
TP5519 7100-SELECT-DEP-REQ.                                             
TP5519                                                                  
TP5519     MOVE '7100'        TO ACTIVE-PARAGRAPH                       
TP5519                                                                  
TP5519     EXEC SQL                                                     
TP5519       SELECT AMT_MO_PYMT,                                        
TP5519              NO_SCHED_PYMTS,                                     
TP5519              DEP_BILL_OPTION_CD,                                 
TP5519              REBILLED_DEP_AMT,                                   
TP5519              REBILLED_DEP_DATE                                   
TP5519       INTO   :DR-AMT-MO-PYMT,                                    
TP5519              :DR-NO-SCHED-PYMTS,                                 
TP5519              :DR-DEP-BILL-OPTION-CD,                             
TP5519              :DR-REBILLED-DEP-AMT,                               
TP5519              :DR-REBILLED-DEP-DATE :WS-REBILLED-DEP-DATE-NULL     
TP5519       FROM   CSS_DEP_REQ WITH(READUNCOMMITTED)                           
TP5519       WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                   
TP5519         AND DEP_ITEM_ID       = :WS-DEPOSIT-CERT-NO-NO           
A37061                                                           
TP5519     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     41750002
MFA-TR*      SELECT AMT_MO_PYMT,                                        41760002
MFA-TR*             NO_SCHED_PYMTS,                                     41770002
MFA-TR*             DEP_BILL_OPTION_CD,                                 41780002
MFA-TR*             REBILLED_DEP_AMT,                                   41790002
MFA-TR*             REBILLED_DEP_DATE                                   41800002
MFA-TR*      INTO   :DR-AMT-MO-PYMT,                                    41810002
MFA-TR*             :DR-NO-SCHED-PYMTS,                                 41820002
MFA-TR*             :DR-DEP-BILL-OPTION-CD,                             41830002
MFA-TR*             :DR-REBILLED-DEP-AMT,                               41840002
MFA-TR*             :DR-REBILLED-DEP-DATE:WS-REBILLED-DEP-DATE-NULL     41850002
MFA-TR*      FROM   CSS_DEP_REQ                                         41860002
MFA-TR*      WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                   41870002
MFA-TR*        AND DEP_ITEM_ID       = :WS-DEPOSIT-CERT-NO-NO           41880002
MFA-TR*      WITH UR                                                    41890002
MFA-TR*    END-EXEC.                                                    41900002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5519                                                                  
TP5519     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TP5519                                                                  
TP5519     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
TP5519        IF WS-REBILLED-DEP-DATE-NULL EQUAL -1                     
TP5519           MOVE SPACES           TO DR-REBILLED-DEP-DATE          
TP5519        END-IF                                                    
TP5519     ELSE                                                         
TP5519        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
TP5519        MOVE 'SELECT            '       TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
TP5519        MOVE 'CSS_DEP_REQ       '       TO TABLE-1                
TP5519        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'DEP_ITEM_ID'              TO TABLE-ELEMENT-2        
TP5519        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
TP5519        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
TP5519        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
TP5519     END-IF.                                                      
TP5519 7100-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
T28160                                                                  
TP5519***************************************************************** 42140002
TP5519* 7200-SEL-CRD-COL-O-TYP.                                       * 42150002
TP5519*     CALLS 9700-PROCESS-ABENDS                                 * 42160002
TP5519*                                                               * 42170002
TP5519*     SELECTS FROM CSS_CRED_COLL                                * 42180002
TP5519*                                                               * 42190002
TP5519***************************************************************** 42200002
TP5519                                                                  
TP5519 7200-SEL-CRD-COL-O-TYP.                                          
TP5519                                                                  
TP5519     MOVE '7200'        TO ACTIVE-PARAGRAPH                       
TP5519                                                                  
TP5519     EXEC SQL                                                     
TP5519       SELECT DATE_NOTICE_DUE,                                    
TP5519              DATE_BILL                                           
TP5519       INTO   :WS-OLD-DATE-NOTICE-DUE :WS-NULL-INDICATOR-1,        
TP5519              :WS-OLD-DATE-BILL :WS-NULL-INDICATOR-2               
TP5519       FROM   CSS_CRED_COLL WITH(READUNCOMMITTED)                         
TP5519       WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                   
TP5519         AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO           
TP5519         AND CODE_NOTICE_TYPE  = :WS-O                            
A37061                                                           
TP5519     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42260002
MFA-TR*      SELECT DATE_NOTICE_DUE,                                    42270002
MFA-TR*             DATE_BILL                                           42280002
MFA-TR*      INTO   :WS-OLD-DATE-NOTICE-DUE:WS-NULL-INDICATOR-1,        42290002
MFA-TR*             :WS-OLD-DATE-BILL:WS-NULL-INDICATOR-2               42300002
MFA-TR*      FROM   CSS_CRED_COLL                                       42310002
MFA-TR*      WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                   42320002
MFA-TR*        AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO           42330002
MFA-TR*        AND CODE_NOTICE_TYPE  = :WS-O                            42340002
MFA-TR*      WITH UR                                                    42350002
MFA-TR*    END-EXEC.                                                    42360002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5519                                                                  
TP5519     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TP5519                                                                  
TP5519     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP5519                                          OR NOT-FOUND            
T26296        IF WS-NULL-INDICATOR-1 < 0 OR                             
TP5519           WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
TP5519           MOVE SPACES           TO WS-OLD-DATE-NOTICE-DUE        
TP5519        END-IF                                                    
T26296        IF WS-NULL-INDICATOR-2 < 0 OR                             
TP5519           WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
TP5519           MOVE SPACES           TO WS-OLD-DATE-BILL              
TP5519        END-IF                                                    
TP5519     ELSE                                                         
TP5519        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
TP5519        MOVE 'SELECT            '       TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
TP5519        MOVE 'CSS_CRED_COLL     '       TO TABLE-1                
TP5519        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
TP5519        MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2        
TP5519        MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
TP5519        MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
TP5519        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
TP5519        MOVE WS-O                       TO HOSTVAR-ELEMENT-3      
TP5519        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
TP5519     END-IF.                                                      
TP5519 7200-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
TP5519***************************************************************** 42670002
TP5519* 7300-SEL-CRD-COL-I-TYP.                                       * 42680002
TP5519*     CALLS 9700-PROCESS-ABENDS                                 * 42690002
TP5519*                                                               * 42700002
TP5519*     SELECTS FROM CSS_CRED_COLL                                * 42710002
TP5519*                                                               * 42720002
TP5519***************************************************************** 42730002
TP5519                                                                  
TP5519 7300-SEL-CRD-COL-I-TYP.                                          
TP5519                                                                  
TP5519     MOVE '7300'        TO ACTIVE-PARAGRAPH                       
TP5519                                                                  
TP5519     EXEC SQL                                                     
TP5519       SELECT DATE_CREDIT_ACTION                                  
TP5519       INTO   :WS-OLD-DATE-CREDIT-ACTION :WS-NULL-INDICATOR-1      
TP5519       FROM   CSS_CRED_COLL WITH(READUNCOMMITTED)                         
TP5519       WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                   
TP5519         AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO           
TP5519         AND CODE_NOTICE_TYPE  = :WS-I                            
A37061                                                           
TP5519     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42790002
MFA-TR*      SELECT DATE_CREDIT_ACTION                                  42800002
MFA-TR*      INTO   :WS-OLD-DATE-CREDIT-ACTION:WS-NULL-INDICATOR-1      42810002
MFA-TR*      FROM   CSS_CRED_COLL                                       42820002
MFA-TR*      WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                   42830002
MFA-TR*        AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO           42840002
MFA-TR*        AND CODE_NOTICE_TYPE  = :WS-I                            42850002
MFA-TR*      WITH UR                                                    42860002
MFA-TR*    END-EXEC.                                                    42870002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5519                                                                  
TP5519     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TP5519                                                                  
TP5519     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP5519                                          OR NOT-FOUND            
T26296        IF WS-NULL-INDICATOR-1 < 0 OR                             
TP5519           WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
TP5519           MOVE SPACES           TO WS-OLD-DATE-CREDIT-ACTION     
TP5519        END-IF                                                    
TP5519     ELSE                                                         
TP5519        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
TP5519        MOVE 'SELECT            '       TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
TP5519        MOVE 'CSS_CRED_COLL     '       TO TABLE-1                
TP5519        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
TP5519        MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2        
TP5519        MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3        
TP5519        MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
TP5519        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
TP5519        MOVE WS-I                       TO HOSTVAR-ELEMENT-3      
TP5519        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
TP5519     END-IF.                                                      
TP5519                                                                  
TP5519 7300-EXIT.                                                       
TP5519     EXIT.                                                        
                                                                        
      **************************************************************    43150002
      * 7400-OPEN-SURETY-CURSOR                                    *    43160002
      **************************************************************    43170002
        7400-OPEN-SURETY-CURSOR.                                        
            MOVE '7400'                   TO ACTIVE-PARAGRAPH.          
            EXEC SQL                                                    
               OPEN SECURITY-CURSOR                                     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
CBSI           MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SPACES               TO ABEND-TABLES                
               MOVE 'OPEN'               TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
               MOVE 'CSS_SURETY_BOND'    TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
PCR263         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    43410002
      * 7410-FETCH-SURETY-CURSOR                                   *    43420002
      **************************************************************    43430002
       7410-FETCH-SURETY-CURSOR.                                        
           MOVE '7410'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH SECURITY-CURSOR                                     
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'           TO SECURITY-EXISTS-SW               
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR263         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    43700002
      * 7420-CLOSE-SURETY-CURSOR                                   *    43710002
      **************************************************************    43720002
       7420-CLOSE-SURETY-CURSOR.                                        
           MOVE '7420'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE SECURITY-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    43960002
      * 7430-OPEN-GUARNTOR-CURSOR                                  *    43970002
      **************************************************************    43980002
                                                                        
       7430-OPEN-GUARNT-CURSOR.                                         
           MOVE '7430'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN GUARNTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    44230002
      * 7440-FETCH-GUARNT-CURSOR                                   *    44240002
      **************************************************************    44250002
       7440-FETCH-GUARNT-CURSOR.                                        
           MOVE '7440'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH GUARNTR-CURSOR                                      
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'     TO SECURITY-EXISTS-SW                     
              END-IF                                                    
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    44520002
      * 7450-CLOSE-GUARNT-CURSOR                                   *    44530002
      **************************************************************    44540002
       7450-CLOSE-GUARNT-CURSOR.                                        
           MOVE '7450'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE GUARNTR-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
T26296*                                                                 44770002
T26296***************************************************************** 44780002
T26296* 7455-GET-RECONNECT-AMT                                          44790002
T26296*     SELECTS AMT_TOT_RECONNECT FROM CSS_RECONNECT.               44800002
T26296***************************************************************** 44810002
T26296 7455-GET-RECONNECT-AMT.                                          
T26296*                                                                 44830002
T26296     EXEC SQL                                                     
T26296        SELECT AMT_TOT_RECONNECT                                  
T26296          INTO :DL-AMT-TOT-RECONNECT                              
T26296          FROM CSS_RECONNECT WITH(READUNCOMMITTED)                        
T26296         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                  
T26296           AND AUTO_DEP_CERT_NO = :WS-DEPOSIT-CERT-NO-NO          
A37061                                                           
T26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     44840002
MFA-TR*       SELECT AMT_TOT_RECONNECT                                  44850002
MFA-TR*         INTO :DL-AMT-TOT-RECONNECT                              44860002
MFA-TR*         FROM CSS_RECONNECT                                      44870002
MFA-TR*        WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                  44880002
MFA-TR*          AND AUTO_DEP_CERT_NO = :WS-DEPOSIT-CERT-NO-NO          44890002
MFA-TR*        WITH UR                                                  44900002
MFA-TR*    END-EXEC.                                                    44910002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26296                                                                  
T26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T26296        NEXT SENTENCE                                             
T26296     ELSE                                                         
T26296        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T26296        MOVE SPACES                     TO ABEND-TABLES           
T26296        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T26296        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T26296        MOVE 'CSS_RECONNECT'            TO TABLE-1                
T26296        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T26296        MOVE 'AUTO_DEP_CERT_NO'         TO TABLE-ELEMENT-2        
T26296        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T26296        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
T26296        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T26296     END-IF.                                                      
T26296*                                                                 45080002
T26296 7455-EXIT.                                                       
T26296     EXIT.                                                        
                                                                        
T32545******************************************************************45120002
T32545*                                                                *45130002
T32545* 7500-SELECT-DELINQ-VALUES                                      *45140002
T32545******************************************************************45150002
T32545 7500-SELECT-DELINQ-VALUES.                                       
T32545                                                                  
T32545     EXEC SQL                                                     
T32545        SELECT C8.DELINQ_VALUE                                    
T32545          INTO :C8-DELINQ-VALUE                                   
T32545        FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                     
T32545        WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                      
T32545          AND C8.COMPANY_NO  = :C8-COMPANY-NO                     
A37061                                                           
T32545     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     45180002
MFA-TR*       SELECT C8.DELINQ_VALUE                                    45190002
MFA-TR*         INTO :C8-DELINQ-VALUE                                   45200002
MFA-TR*       FROM CSS_DELINQUENCY C8                                   45210002
MFA-TR*       WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                      45220002
MFA-TR*         AND C8.COMPANY_NO  = :C8-COMPANY-NO                     45230002
MFA-TR*       WITH UR                                                   45240002
MFA-TR*    END-EXEC.                                                    45250002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32545                                                                  
T32545     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
T32545                                                                  
T32545     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T32545       NEXT SENTENCE                                              
T32545     ELSE                                                         
T32545        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T32545        MOVE '7500'                    TO ACTIVE-PARAGRAPH        
T32545        MOVE SPACES                    TO ABEND-TABLES            
T32545        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
T32545        MOVE 'SELECT'                  TO ABEND-FUNCTION          
T32545        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
T32545        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
T32545        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
T32545        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
T32545        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
T32545        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T32545     END-IF.                                                      
T32545                                                                  
T32545 7500-EXIT.                                                       
T32545     EXIT.                                                        
      *                                                                 45470002
A36839***************************************************************** 45480002
A36839* 7990-CHECK-NONBUSINESS-DAY                                    * 45490002
A36839*     CALLS 9700-PROCESS-ABENDS                                 * 45500002
A36839*                                                               * 45510002
A36839*    CHECK THE DAY( 0 THRU 6)                                   * 45520002
A36839*                 (SUNDAY THRU SATURDAY)                        * 45530002
A36839***************************************************************** 45540002
A36839                                                                  
A36839 7990-CHECK-NONBUSINESS-DAY.                                      
A36839     EXEC SQL                                                     
A36839       SELECT
              CIS.DAYS (IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ))                          
A36839              - (CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ))/7 * 7)
            INTO
              :WS-DAY        
A36839     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     45570002
MFA-TR*      SET   :WS-DAY          =                                   45580002
MFA-TR*             DAYS (DATE(:WS-WORK-DATE))                          45590002
MFA-TR*             - (INTEGER(DAYS(DATE(:WS-WORK-DATE))/7) * 7)        45600002
MFA-TR*    END-EXEC.                                                    45610002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A36839                                                                  
A36839     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A36839                                                                  
A36839     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
A36839        CONTINUE                                                  
A36839     ELSE                                                         
A36839        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A36839        MOVE '7990'                     TO ACTIVE-PARAGRAPH       
A36839        MOVE 'SET'                      TO ABEND-FUNCTION         
A36839        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A36839                                           ABEND-TABLES           
A36839        MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
A36839        MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
A36839        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
A36839        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
A36839        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A36839     END-IF.                                                      
A36839 7990-EXIT.                                                       
A36839     EXIT.                                                        
                                                                        
      ***************************************************************** 45820002
      * 7995-SELECT-HOLIDAY                                           * 45830002
      *     CALLS 9700-PROCESS-ABENDS                                 * 45840002
      *                                                               * 45850002
      *     SELECTS CSS_HOLIDAY TABLE TO CHECK HOLIDAY                * 45860002
      ***************************************************************** 45870002
                                                                        
                                                                        
PCR263 7995-SELECT-HOLIDAY.                                             
                                                                        
PCR263     MOVE VALUE-NO               TO WS-HOLIDAY-EXISTS.            
PCR263                                                                  
PCR263     EXEC SQL                                                     
PCR263       SELECT    DISTINCT ('Y')                                   
PCR263       INTO      :WS-HOLIDAY-EXISTS                               
PCR263       FROM      CSS_HOLIDAY WITH(READUNCOMMITTED)                        
PCR263       WHERE     HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                      
A37061                                                           
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     45940002
MFA-TR*      SELECT    DISTINCT ('Y')                                   45950002
MFA-TR*      INTO      :WS-HOLIDAY-EXISTS                               45960002
MFA-TR*      FROM      CSS_HOLIDAY                                      45970002
MFA-TR*      WHERE     HOLIDAY_DT = :J8-HOLIDAY-DT                      45980002
MFA-TR*      WITH UR                                                    45990002
MFA-TR*    END-EXEC.                                                    46000002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7995'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT            '       TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
PCR263        MOVE 'CSS_HOLIDAY       '       TO TABLE-1                
T15605        MOVE 'HOLIDAY_DT'               TO TABLE-ELEMENT-1        
T15605        MOVE J8-HOLIDAY-DT              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
PCR263        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 46200002
       7995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 46240002
PCR263* 7997-GET-NEXT-DAY                                             * 46250002
      *     CALLS 9700-PROCESS-ABENDS                                 * 46260002
      *                                                               * 46270002
      *                                                               * 46280002
      *     GETS THE DAY( 0 THRU 6) OF THE NEXT DAY                   * 46290002
      *                 (SUNDAY THRU SATURDAY)                        * 46300002
      ***************************************************************** 46310002
                                                                        
       7997-GET-NEXT-DAY.                                               
T34097     EXEC SQL                                                     
T34097       SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))                 
T34097              - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY                                   
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     46340002
MFA-TR*      SET   :WS-WORK-DATE    =  DATE(:WS-WORK-DATE) + 1 DAYS     46350002
MFA-TR*           ,:WS-DAY          =                                   46360002
MFA-TR*             DAYS (DATE(:WS-WORK-DATE) + 1 DAYS)                 46370002
MFA-TR*             - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                 46380002
MFA-TR*             + 1 DAYS)/7) * 7)                                   46390002
MFA-TR*    END-EXEC.                                                    46400002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7997'                     TO ACTIVE-PARAGRAPH       
T34097        MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
T15605        MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
T15605        MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7997-EXIT.                                                       
           EXIT.                                                        
                                                                        
T32545***************************************************************** 46610002
T32545* 7998-GET-PREV-DAY                                             * 46620002
T32545***************************************************************** 46630002
T32545 7998-GET-PREV-DAY.                                               
T34097     EXEC SQL                                                     
T34097       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))                  
T34097             - (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY                                    
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     46650002
MFA-TR*      SET  :WS-WORK-DATE    =  DATE(:WS-WORK-DATE) - 1 DAYS      46660002
MFA-TR*          ,:WS-DAY          =                                    46670002
MFA-TR*            DAYS (DATE(:WS-WORK-DATE) - 1 DAYS)                  46680002
MFA-TR*            - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                  46690002
MFA-TR*            - 1 DAYS)/7) * 7)                                    46700002
MFA-TR*    END-EXEC.                                                    46710002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32545                                                                  
T32545     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T32545                                                                  
T32545     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T32545        CONTINUE                                                  
T32545     ELSE                                                         
T32545        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T32545        MOVE '7998'                     TO ACTIVE-PARAGRAPH       
T34097        MOVE 'SET'                      TO ABEND-FUNCTION         
T32545        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T32545                                           ABEND-TABLES           
T15605        MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
T15605        MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
T32535        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T32545        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
T32545        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T32545     END-IF.                                                      
                                                                        
T32545 7998-EXIT.                                                       
T32545     EXIT.                                                        
                                                                        
T21202******************************************************************46930002
T21202* 7999-UPDATE-AT-TIMESTAMP.                                      *46940002
T21202*    -- THIS MODULE UPDATES THE LAST_UPDATE_TS COLUMN ON THE     *46950002
T21202*       CSS_ACCOUNT TABLE.                                       *46960002
T32545* PARAGRAPH NAME WAS CHANGED FROM 7998 TO 7999 TO ALLOW FOR ABOVE*46970002
T21202******************************************************************46980002
T21202 7999-UPDATE-AT-TIMESTAMP.                                        
T21202*                                                                 47000002
T21202     EXEC SQL                                                     
T21202         UPDATE CSS_ACCOUNT                                       
T21202            SET LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
T21202          WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
T21202     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     47010002
MFA-TR*        UPDATE CSS_ACCOUNT                                       47020002
MFA-TR*           SET LAST_UPDATE_TS   = :AT-LAST-UPDATE-TS             47030002
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 47040002
MFA-TR*    END-EXEC.                                                    47050002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21202*                                                                 47060002
T21202     MOVE SQLCODE                  TO RS-RETURN-CODE.             
T21202     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T21202*                                                                 47090002
T21202     IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
T21202        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T21202        MOVE '7999'                TO ACTIVE-PARAGRAPH            
T21202        MOVE 'UPDATE'              TO ABEND-FUNCTION              
T21202        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T21202                                      ABEND-TABLES                
T21202        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T21202        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T21202        MOVE 'LAST_UPDATE_TS'      TO TABLE-ELEMENT-2             
T21202        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T21202        MOVE AT-LAST-UPDATE-TS     TO HOSTVAR-ELEMENT-2           
T21202        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T21202     END-IF.                                                      
T21202*                                                                 47230002
T21202 7999-EXIT.                                                       
T21202     EXIT.                                                        
T26296*                                                                 47260002
T26296***************************************************************** 47270002
T26296* 8050-UPDATE-RECONNECT-AMT                                       47280002
T26296*     ADD DO-AMT-DEPOSIT TO DL-AMT-TOT-RECONNECT AND UPDATE       47290002
T26296***************************************************************** 47300002
T26296 8050-UPDATE-RECONNECT-AMT.                                       
T26296*                                                                 47320002
T26296*                                                                 47330002
T26296     EXEC SQL                                                     
T26296        UPDATE CSS_RECONNECT                                      
T26296           SET AMT_TOT_RECONNECT = :DL-AMT-TOT-RECONNECT          
T26296         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                 
T26296           AND AUTO_DEP_CERT_NO  = :WS-DEPOSIT-CERT-NO-NO         
T26296     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26296                                                                  
T26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26296        NEXT SENTENCE                                             
T26296     ELSE                                                         
T26296        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T26296        MOVE SPACES                     TO ABEND-TABLES           
T26296        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T26296        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T26296        MOVE 'CSS_RECONNECT'            TO TABLE-1                
T26296        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T26296        MOVE 'AUTO_DEP_CERT_NO'         TO TABLE-ELEMENT-2        
T26296        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T26296        MOVE WS-DEPOSIT-CERT-NO-NO      TO HOSTVAR-ELEMENT-2      
T26296        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T26296     END-IF.                                                      
T26296*                                                                 47560002
T26296 8050-EXIT.                                                       
T26296     EXIT.                                                        
                                                                        
T21202******************************************************************47600002
P00599* 8000-INSERT-DEPHND-DETAIL                                      *11860000
P00599*   -- THIS MODULE INSERTS DEPOSIT RECORDS TO THE CSS_DEP_ON_HAND*11870000
      *      TABLE FOR AN ACCOUNT.                                    * 11880000
      ******************************************************************11890000
P00599 8000-INSERT-DEPHND-DETAIL.                                       
      *                                                                 11910000
           EXEC SQL                                                     
               INSERT INTO CSS_DEP_ON_HAND                              
                   (ACCOUNT_NO,                                         
                    DEPOSIT_CERT_NO,                                    
                    AMT_DEPOSIT,                                        
                    DATE_CERT_ISSUE,                                    
                    DATE_INTST_CALC_TO,                                 
                    INTRST_YTD,                                         
                    TOTAL_INTRST,                                       
                    CODE_REFUND_ELIG,                                   
                    CODE_REFUND_STATUS,                                 
                    EMPL_HOLD_INIT,                                     
                    DATE_TRAN,                                          
                    CODE_DEP_TYPE,                                      
                    SERVICE_TYPE_CD,                                    
                    PROJECTED_CR_DT,                                    
                    TRANSFERRED_FROM,                                   
                    TRANSFERRED_TO,                                     
                    TRANSFER_AMT,                                       
                    DEPOSIT_STATUS_CD,                                  
                    USER_ID_UPDT_BY,                                    
                    DATE_REFUNDED,                                      
                    CODE_REFUND_TYPE,                                   
                    CODE_REFUND_REASON,                                 
                    CODE_REFUND_FROM,                                   
                    DEP_ACTION_CODE,                                    
                    DEP_CERT_NO_TO,                                     
                    DEP_CERT_NO_FROM,                                   
                    DATE_PYMT_START,                                    
                    AMT_REFUNDED,                                       
                    COMMENTS,                                           
T26296              AUTO_DEP_LTR_DT,                                    
T26296              AUTO_DEP_LTR_IND,                                   
T26296              AUTO_DEP_NOT_AM,                                    
T26296              AUTO_DEP_RECALC_AM)                                 
               VALUES                                                   
                   (:WS-ACCOUNT-NO,                                     
                    :WS-DEPOSIT-CERT-NO-NO,                             
                    :WS-AMT-ORIG-ENTERED,                               
                    IIF(TRY_CONVERT(DATE, :NULL-DATE :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :NULL-DATE :NULL-INDICATOR
              ) <> 0) OR (LEN(:NULL-DATE :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:NULL-DATE :NULL-INDICATOR
              ), CONVERT(DATE, :NULL-DATE :NULL-INDICATOR) ),                  
                    IIF(TRY_CONVERT(DATE, :NULL-DATE :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :NULL-DATE :NULL-INDICATOR
              ) <> 0) OR (LEN(:NULL-DATE :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:NULL-DATE :NULL-INDICATOR
              ), CONVERT(DATE, :NULL-DATE :NULL-INDICATOR) ),                  
                    0,                                                  
                    0,                                                  
T28160              :PARM-CODE-REFUND-ELIG,                             
                    :VALUE-SPACES,                                      
                    :VALUE-SPACES,                                      
                    CAST(SYSDATETIMEOFFSET() AS DATE),                          
                    :PARM-CODE-DEP-TYPE,                                
                    :PARM-SERVICE-TYPE-CD,                              
                    IIF(TRY_CONVERT(DATE, :NULL-DATE :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :NULL-DATE :NULL-INDICATOR
              ) <> 0) OR (LEN(:NULL-DATE :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:NULL-DATE :NULL-INDICATOR
              ), CONVERT(DATE, :NULL-DATE :NULL-INDICATOR) ),                  
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    :PARM-DEPOSIT-STATUS-CD,                            
                    :PARM-USER-ID-UPDT-BY,                              
                    IIF(TRY_CONVERT(DATE, :NULL-DATE :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :NULL-DATE :NULL-INDICATOR
              ) <> 0) OR (LEN(:NULL-DATE :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:NULL-DATE :NULL-INDICATOR
              ), CONVERT(DATE, :NULL-DATE :NULL-INDICATOR) ),                  
                    :VALUE-SPACES,                                      
                    :VALUE-SPACES,                                      
                    :VALUE-SPACES,                                      
                    :PARM-DEP-ACTION-CODE,                              
                    0,                                                  
                    0,                                                  
                    CAST(SYSDATETIMEOFFSET() AS DATE),                          
                    0,                                                  
T16175              :DO-COMMENTS,                                       
T26296              IIF(TRY_CONVERT(DATE, :DO-AUTO-DEP-LTR-DT 
                                          :NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :DO-AUTO-DEP-LTR-DT 
                                                        :NULL-INDICATOR
              ) <> 0) OR (LEN(:DO-AUTO-DEP-LTR-DT :NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:DO-AUTO-DEP-LTR-DT 
                                                        :NULL-INDICATOR
              ), CONVERT(DATE, :DO-AUTO-DEP-LTR-DT :NULL-INDICATOR) ),         
T26296              :DO-AUTO-DEP-LTR-IND,                               
T26296              :DO-AUTO-DEP-NOT-AM,                                
T26296              :DO-AUTO-DEP-RECALC-AM)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11920000
MFA-TR*        INSERT INTO CSS_DEP_ON_HAND                              11930000
MFA-TR*            (ACCOUNT_NO,                                         11940000
MFA-TR*             DEPOSIT_CERT_NO,                                    11950000
MFA-TR*             AMT_DEPOSIT,                                        11960000
MFA-TR*             DATE_CERT_ISSUE,                                    11970000
MFA-TR*             DATE_INTST_CALC_TO,                                 11980000
MFA-TR*             INTRST_YTD,                                         11990000
MFA-TR*             TOTAL_INTRST,                                       12000000
MFA-TR*             CODE_REFUND_ELIG,                                   12010000
MFA-TR*             CODE_REFUND_STATUS,                                 12020000
MFA-TR*             EMPL_HOLD_INIT,                                     12030000
MFA-TR*             DATE_TRAN,                                          12040000
MFA-TR*             CODE_DEP_TYPE,                                      12050000
MFA-TR*             SERVICE_TYPE_CD,                                    12060000
MFA-TR*             PROJECTED_CR_DT,                                    12070000
MFA-TR*             TRANSFERRED_FROM,                                   12080000
MFA-TR*             TRANSFERRED_TO,                                     12090000
MFA-TR*             TRANSFER_AMT,                                       12100000
MFA-TR*             DEPOSIT_STATUS_CD,                                  12110000
MFA-TR*             USER_ID_UPDT_BY,                                    12120000
MFA-TR*             DATE_REFUNDED,                                      12130000
MFA-TR*             CODE_REFUND_TYPE,                                   12140000
MFA-TR*             CODE_REFUND_REASON,                                 12150000
MFA-TR*             CODE_REFUND_FROM,                                   12160000
MFA-TR*             DEP_ACTION_CODE,                                    12170000
MFA-TR*             DEP_CERT_NO_TO,                                     12180000
MFA-TR*             DEP_CERT_NO_FROM,                                   12190000
MFA-TR*             DATE_PYMT_START,                                    12200000
MFA-TR*             AMT_REFUNDED,                                       12210000
MFA-TR*             COMMENTS,                                           12220000
MFA-TR*             AUTO_DEP_LTR_DT,                                            
MFA-TR*             AUTO_DEP_LTR_IND,                                           
MFA-TR*             AUTO_DEP_NOT_AM,                                            
MFA-TR*             AUTO_DEP_RECALC_AM)                                         
MFA-TR*        VALUES                                                   12230000
MFA-TR*            (:WS-ACCOUNT-NO,                                     12240000
MFA-TR*             :WS-DEPOSIT-CERT-NO-NO,                             12250000
MFA-TR*             :WS-AMT-ORIG-ENTERED,                               12260000
MFA-TR*             :NULL-DATE:NULL-INDICATOR,                          12270000
MFA-TR*             :NULL-DATE:NULL-INDICATOR,                          12280000
MFA-TR*             0,                                                  12290000
MFA-TR*             0,                                                  12300000
MFA-TR*             :PARM-CODE-REFUND-ELIG,                             12310000
MFA-TR*             :VALUE-SPACES,                                      12320000
MFA-TR*             :VALUE-SPACES,                                      12330000
MFA-TR*             CURRENT DATE,                                       12340000
MFA-TR*             :PARM-CODE-DEP-TYPE,                                12350000
MFA-TR*             :PARM-SERVICE-TYPE-CD,                              12360000
MFA-TR*             :NULL-DATE:NULL-INDICATOR,                          12370000
MFA-TR*             0,                                                  12380000
MFA-TR*             0,                                                  12390000
MFA-TR*             0,                                                  12400000
MFA-TR*             :PARM-DEPOSIT-STATUS-CD,                            12410000
MFA-TR*             :PARM-USER-ID-UPDT-BY,                              12420000
MFA-TR*             :NULL-DATE:NULL-INDICATOR,                          12430000
MFA-TR*             :VALUE-SPACES,                                      12440000
MFA-TR*             :VALUE-SPACES,                                      12450000
MFA-TR*             :VALUE-SPACES,                                      12460000
MFA-TR*             :PARM-DEP-ACTION-CODE,                              12470000
MFA-TR*             0,                                                  12480000
MFA-TR*             0,                                                  12490000
MFA-TR*             CURRENT DATE,                                       12500000
MFA-TR*             0,                                                  12510000
MFA-TR*             :DO-COMMENTS,                                       12520000
MFA-TR*             :DO-AUTO-DEP-LTR-DT:NULL-INDICATOR,                         
MFA-TR*             :DO-AUTO-DEP-LTR-IND,                                       
MFA-TR*             :DO-AUTO-DEP-NOT-AM,                                        
MFA-TR*             :DO-AUTO-DEP-RECALC-AM)                                     
MFA-TR*    END-EXEC.                                                    12530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12540000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 12570000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
CBSI          MOVE 'AMT_DEPOSIT'         TO TABLE-ELEMENT-3             
CBSI          MOVE 'USER_ID_UPDT_BY'     TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
CBSI          MOVE WS-AMT-ORIG-ENTERED   TO HOSTVAR-ELEMENT-3-N         
CBSI          MOVE PARM-USER-ID-UPDT-BY  TO HOSTVAR-ELEMENT-4           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12680000
      *                                                                 12690000
P00599 8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12720000
      *                                                                 12730000
      ******************************************************************13310000
P00599*8100-UPDATE-DEPHND.                                             *13320000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *13330000
      *       CSS_DEP_ON_HAND TABLE.                                   *13340000
      ******************************************************************13350000
P00599 8100-UPDATE-DEPHND.                                              
      *                                                                 13370000
           EXEC SQL                                                     
               UPDATE CSS_DEP_ON_HAND                                   
                  SET DEPOSIT_STATUS_CD = :PARM-DEPOSIT-STATUS-CD,      
                      DEP_ACTION_CODE   = :PARM-DEP-ACTION-CODE,        
                      USER_ID_UPDT_BY   = :PARM-USER-ID-UPDT-BY,        
                      SERVICE_TYPE_CD   = :PARM-SERVICE-TYPE-CD,        
                      CODE_DEP_TYPE     = :PARM-CODE-DEP-TYPE,          
T28160                CODE_REFUND_ELIG  = :PARM-CODE-REFUND-ELIG,       
T28160                COMMENTS          = :DO-COMMENTS,                 
T26296                AUTO_DEP_LTR_IND  = :PARM-AUTO-DEP-LTR-IND        
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13480000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 13510000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15605        MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
CBSI          MOVE 'DEPOSIT_STATUS_CD'   TO TABLE-ELEMENT-3             
CBSI          MOVE 'USER_ID_UPDT_BY'     TO TABLE-ELEMENT-4             
T15605        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15605        MOVE WS-DEPOSIT-CERT-NO-NO TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-DEPOSIT-STATUS-CD TO HOSTVAR-ELEMENT-3          
CBSI          MOVE PARM-USER-ID-UPDT-BY  TO HOSTVAR-ELEMENT-4           
PCR263        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 13620000
      *                                                                 13630000
P00599 8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13660000
      *                                                                 13670000
P00599******************************************************************13310000
P00599*8200-GET-CORRESP-ID.                                            *13320000
P00599*    -- THIS MODULE SELECTS THE CORRESPONDING ID FOR CERTIFICATE *13330000
P00599*       NUMBER .                                                 *13340000
P00599******************************************************************13350000
P00599 8200-GET-CORRESP-ID.                                             
P00599*                                                                 13370000
P00599     EXEC SQL                                                     
P00599         SELECT A.CORRESP_ID                                      
P00599         INTO   :1J-CORRESP-ID                                    
P00599         FROM   CSS_CORRESP_HDR A                                 
P00599               ,CSS_CORRESP_VAR B                                 
P00599         WHERE  A.ACCOUNT_NO         = :1J-ACCOUNT-NO             
P00599         AND    A.CORRESP_STATUS_CD  = :1J-CORRESP-STATUS-CD      
P00599         AND    B.CORRESP_VAR_NM     = :1K-CORRESP-VAR-NM         
P00599         AND    B.CORRESP_VAR_CHAR   = :1K-CORRESP-VAR-CHAR       
P00599         AND    A.CORRESP_ID         = B.CORRESP_ID               
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 13480000
P00599     MOVE SQLCODE                  TO RS-RETURN-CODE              
P00599                                      WS-ACTIVE-RETURN-CODE.      
P00599*                                                                 13510000
P00599     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
P00599        OR NOT-FOUND                                              
P00599         CONTINUE                                                 
P00599     ELSE                                                         
P00599        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8200'                TO ACTIVE-PARAGRAPH            
P00599        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00599        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CSS_CORRESP_VAR'     TO TABLE-2                     
P00599        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00599        MOVE 'CORRESP_VAR_NM'      TO TABLE-ELEMENT-2             
P00599        MOVE 'CORRESP_VAR_CHAR'    TO TABLE-ELEMENT-3             
P00599        MOVE 1J-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00599        MOVE 1K-CORRESP-VAR-NM     TO HOSTVAR-ELEMENT-2           
P00599        MOVE 1K-CORRESP-VAR-CHAR   TO HOSTVAR-ELEMENT-3           
P00599        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00599     END-IF.                                                      
P00599*                                                                 13620000
P00599*                                                                 13630000
P00599 8200-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 13660000
P00599*                                                                 13670000
P00599******************************************************************13310000
P00599*8300-UPDATE-CORRESP-HDR.                                        *13320000
P00599*    -- THIS MODULE UPDATES AN CORRESP_STATUS_CD TO 'C' FOR THE  *13330000
P00599*       CORRESP_ID ON CSS_CORRESP_HDR TABLE.                     *13340000
P00599******************************************************************13350000
P00599 8300-UPDATE-CORRESP-HDR.                                         
P00599*                                                                 13370000
P00599     EXEC SQL                                                     
P00599         UPDATE CSS_CORRESP_HDR                                   
P00599            SET CORRESP_STATUS_CD = :1J-CORRESP-STATUS-CD         
P00599               ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
P00599          WHERE CORRESP_ID        = :1J-CORRESP-ID                
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     13380000
MFA-TR*        UPDATE CSS_CORRESP_HDR                                   13390000
MFA-TR*           SET CORRESP_STATUS_CD = :1J-CORRESP-STATUS-CD         13400000
MFA-TR*              ,LAST_UPDATE_TS    = CURRENT TIMESTAMP             13400000
MFA-TR*         WHERE CORRESP_ID        = :1J-CORRESP-ID                13450000
MFA-TR*    END-EXEC.                                                    13470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 13480000
P00599     MOVE SQLCODE                  TO RS-RETURN-CODE              
P00599                                      WS-ACTIVE-RETURN-CODE.      
P00599*                                                                 13510000
P00599     IF SQLCODE = SUCCESSFUL-CALL                                 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00599        MOVE '8300'                TO ACTIVE-PARAGRAPH            
P00599        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00599        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
P00599        MOVE 1J-CORRESP-ID         TO HOSTVAR-ELEMENT-1           
P00599        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00599     END-IF.                                                      
P00599*                                                                 13620000
P00599*                                                                 13630000
P00599 8300-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 13660000
P00599*                                                                 13670000
T21202******************************************************************        
T21202*  PERFORMS THE ABEND  WHEN THE CICS STATEMENT FAILS              47610002
T21202******************************************************************47620002
T21202*                                                                 47630002
T21202 9250-CALL-ABEND.                                                 
T21202                                                                  
T21202     MOVE PROGRAM-NAME                  TO ABEND-PROGRAM.         
T21202     MOVE 'LINKFAIL'                    TO ABEND-FUNCTION.        
T21202     MOVE 100                           TO WS-ACTIVE-RETURN-CODE, 
T21202                                           SQLCODE.               
T21202     PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT.           
T21202     PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT.           
T21202                                                                  
T21202 9250-EXIT.                                                       
T21202     EXIT.                                                        
T21202*                                                                 47750002
T19557 9500-CALL-CPD00068.                                              
T19557                                                                  
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO S-RETURN-CODE,             
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH     END-IF.                                                      
REARCH*                                                                 47930002
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
      *                                                                 47970002
      ******************************************************************47980002
      *  INCLUDE COPYBOOKS FOR A/R AND CASH DRAWER JOURNALING          *47990002
      ******************************************************************48000002
      *                                                                 48010002
           EXEC SQL                                                     48020002
A00956        INCLUDE CPD0006A                                          48030002
           END-EXEC.                                                    48040002
      *                                                                 48050002
           EXEC SQL                                                     48060002
              INCLUDE CPD00008                                          48070002
           END-EXEC.                                                    48080002
PCR263*                                                                 48090002
      ******************************************************************48100002
      *                                                                 48110002
PCR263*                                                                 48120002
PCR263     EXEC SQL                                                     48130002
PCR263         INCLUDE CPD0023C                                         48140002
PCR263     END-EXEC.                                                    48150002
PCR263*                                                                 48160002
           EXEC SQL                                                     48170002
               INCLUDE CPD00075                                         48180002
           END-EXEC.                                                    48190002
      *                                                                 48200002
           EXEC SQL                                                     48210002
               INCLUDE CPD00307                                         48220002
           END-EXEC.                                                    48230002
      *                                                                 48240002
T26296*THE USE OF CPDSP300 AND CPD00321 IS COMMENTED.                   48250002
T26296******************************************************************48260002
T26296* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *48270002
T26296******************************************************************48280002
T26296*    EXEC SQL                                                     48290002
T26296*       INCLUDE CPDSP300                                          48300002
T26296*    END-EXEC.                                                    48310002
T26296*                                                                 48320002
T26296******************************************************************48330002
T26296* 9999- END PROGRAM COPYLIB                                      *48340002
T26296******************************************************************48350002
T26296*    EXEC SQL                                                     48360002
T26296*       INCLUDE CPD00321                                          48370002
T26296*    END-EXEC.                                                    48380002
T26296******************************************************************48390002
T26296*  THE CODE BELOW IS FROM CPD00321 WITH THE ERROR-SWITCH ADDED.   48400002
T26296******************************************************************48410002
      *   8900-SEND-DONE                                               *48420002
      ******************************************************************48430002
       8900-SEND-DONE.                                                  
      *                                                                 48450002
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 48490002
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************48520002
      * 9000-SEND-ERROR-RESULT                                         *48530002
      ******************************************************************48540002
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 48560002
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 48620002
T26296     IF PARM-ERR-SWITCH = 'Y'                                     
              EXEC SQL                                                  
                  ROLLBACK                                              
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              IF SQLCODE = 0                                            
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'ROLLBACK'         TO ABEND-FUNCTION              
              END-IF                                                    
T26296     ELSE                                                         
              MOVE ABEND-PROGRAM         TO S-ABEND-PROGRAM             
              MOVE ACTIVE-PARAGRAPH      TO S-ACTIVE-PARA               
              MOVE ABEND-FUNCTION        TO S-ABEND-FUNCTION            
              MOVE TABLE-1               TO S-ABEND-TABLE               
              MOVE TABLE-ELEMENT-1       TO S-TABLE-ELMT-1              
              MOVE TABLE-ELEMENT-2       TO S-TABLE-ELMT-2              
              MOVE TABLE-ELEMENT-3       TO S-TABLE-ELMT-3              
              MOVE TABLE-ELEMENT-4       TO S-TABLE-ELMT-4              
              MOVE HOSTVAR-ELEMENT-1     TO S-HOSTVAR-ELMT-1            
              MOVE HOSTVAR-ELEMENT-2     TO S-HOSTVAR-ELMT-2            
              MOVE HOSTVAR-ELEMENT-3     TO S-HOSTVAR-ELMT-3            
              MOVE HOSTVAR-ELEMENT-4     TO S-HOSTVAR-ELMT-4            
T26296     END-IF.                                                      
      *                                                                 48860002
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 48890002
      ******************************************************************48900002
      *   9999-END-PROGRAM                                             *48910002
      ******************************************************************48920002
      *                                                                 48930002
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************48970002
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *48980002
      ******************************************************************48990002
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
T26296****************************************************************  49170002
T26296*  THE LOGIC BELOW IS FROM CPDSP300 WITH THE ERROR-SWITCH ADDED.  49180002
T26296****************************************************************  49190002
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 49210002
           PERFORM 9975-ABEND-CONTROL-TRANSFER THRU 9975-EXIT.          
      *                                                                 49230002
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49260002
       9975-ABEND-CONTROL-TRANSFER.                                     
      *                                                                 49280002
T26296     IF PARM-ERR-SWITCH = 'Y'                                     
              
MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
              EXEC SQL                                                  
      *                                                                 49310002
                 CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                      
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*       EXEC SQL                                                  49300002
MFA-TR*                                                                 49310002
MFA-TR*          CALL CSRERLOG (                                        49320002
MFA-TR*             :ABEND-PROGRAM,                                     49330002
MFA-TR*             :ABEND-SQLCODE,                                     49340002
MFA-TR*             :ABEND-SQLSTATE,                                    49350002
MFA-TR*             :TABLE-1,                                           49360002
MFA-TR*              VARCHAR(STRIP(                                     49370002
MFA-TR*              CASE                                               49380002
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                49390002
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT    49400002
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                    49410002
MFA-TR*                 ELSE                                            49420002
MFA-TR*                    ''                                           49430002
MFA-TR*              END CONCAT                                         49440002
MFA-TR*              CASE                                               49450002
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                49460002
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT    49470002
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                    49480002
MFA-TR*                 ELSE                                            49490002
MFA-TR*                    ''                                           49500002
MFA-TR*              END CONCAT                                         49510002
MFA-TR*              CASE                                               49520002
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                49530002
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT    49540002
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                    49550002
MFA-TR*                 ELSE                                            49560002
MFA-TR*                    ''                                           49570002
MFA-TR*              END CONCAT                                         49580002
MFA-TR*              CASE                                               49590002
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                49600002
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT    49610002
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                    49620002
MFA-TR*                 ELSE                                            49630002
MFA-TR*                    ''                                           49640002
MFA-TR*              END                                                49650002
MFA-TR*              )),                                                49660002
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                          49670002
MFA-TR*              VARCHAR(                                           49680002
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT49690002
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT 49700002
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                  49710002
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                  49720002
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC) 49730002
MFA-TR*              )                                                  49740002
MFA-TR*          )                                                      49750002
MFA-TR*       END-EXEC                                                  49760002
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
T26296     END-IF.                                                      
      *                                                                 49780002
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
      *                                                                 49810002
T26296 9975-EXIT.                                                       
T26296     EXIT.                                                        
