       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02066.                                         
COB303 DATE-WRITTEN.  MARCH 29, 1995                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S066                                           *00120000
      *  PROGRAM:       S066                                           *00130000
      *  CALLING SP:    PA_S066                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM INSERTS/UPDATES/DELETES INFO FROM THE WHITE      *00190000
      *  CROSS TABLE. IT ALSO UPDATES THE FIELD CODE_CRIT_OUTAGE ON    *00200000
      *  CSS_ACCOUNT TO INDICATE WHETHER THIS ACCOUNT HAS WHITE        *00210000
      *  CROSS INFO OR NOT.                                            *00220000
      *                                                                *00230000
      ******************************************************************00240000
      *                                                                *00250000
      *                     PROGRAM MODIFICATION LOG                   *00260000
      *                                                                *00270000
      *    DATE    INITIALS   COMMENTS                                 *00280000
      *  --------  --------   ---------------------------------------  *00290000
      *  03/29/95  TCB        PROCEDURE ORIGINALLY CODED.              *00300000
      *  09/11/95  TCB        ADDED INSERT/UPDATE/DELETE CAPABILITY    *00310000
      *                       TO THE CSS_ACCT_WHT_CROSS TABLE.         *00320000
TP5295*  08/28/96  SG         CHANGED CODE TO MOVE 'WC' TO THE         *00321000
TP5295*                       AT-CODE-CRIT-OUTAGE FIELD INSTEAD OF     *00330000
TP5295*                       '04', TP#5295.                           *00331000
T4755 *  11/06/96  CSG        CHANGE DEFINITION OF POINT-ID WORKING    *00332000
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *00333000
T9645 *  04/04/97  AS         CHANGED LENGTH OF PARM-POINT-ID FROM     *00334000
      *                       X(9) TO X(10).                           *00335000
T11655*  06/13/97  AS         FIXED PROGRAM TO WRITE MNT TRANS HIST ROW*00336000
      *                       FOR THE COMMENTS FIELD ONLY WHEN IT IS   *00337000
      *                       CHANGED.                                 *00338000
CBSI  *  07/27/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE   * 00338100
CBSI  *             MADRAS    ABEND PARAMETERS                        * 00339000
T19917*  05/20/99  FMB        MAXIMUM LENGTH OF COMMENTS ON MAINTENANCE*00339100
      *                       TRANSACTION HISTORY IS 75.               *00339200
C24056*  01/24/03  FMB        ADD GIS_POINT_ID FOR OMS.                *00339300
T31339*  08/09/04  DD         ADD FETCH FIRST 1 ROWS ONLY TO PARA 3400 *00339400
REARCH*  08/08/05  CVNS       RPC TO COBOL SP CONVERSION               *00339500
REARCH*            CHENNAI                                             *00339600
C32547*  03/26/07  SS82048    UPDATE CODE-CRIT-OUTAGE AFTER CHECKING   *00339700
      *                       WHITE CROSS PLUS.                        *00339800
T35434*  10/09/07  MR97640    REPLACED MODEL_SQL WITH SET STATEMENT    *00339900
T35434*                       AND ADDED WITH UR TO AVOID -911.         *00340000
P33743*  05/09/08  SC41135    POINT ID PROJECT - REPLACED SNE_POINT    *00340100
P33743*                       WITH CSS_PIM_POINT TABLE                 *00340200
      *                                                                *00340300
A05460*  01/27/15  MS7M727   REMOVED COMMENTED CODES AND REFERRED TABLE*00340400
A05460*                                                                *00340500
      ******************************************************************00341000
      ******************************************************************00350000
      *                                                                *00360000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00370000
      *                                                                *00380000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00390000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00400000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00410000
      *  3000 - 4999  DB2 STATEMENTS                                   *00420000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02066'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02066 STARTS HERE'.                  
                                                                        
      ******************************************************************00580000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00590000
      ******************************************************************00600000
                                                                        
REARCH     EXEC SQL                                                     00641000
REARCH          INCLUDE CWSX0010                                        00642000
REARCH     END-EXEC.                                                    00643000
           COPY CWS00027.                                               00650000
           COPY CWS00303.                                               00660000
                                                                        
      ******************************************************************00680000
      *    WORK AREAS                                                  *00690000
      ******************************************************************00700000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02066'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-TRAN-APPL-NO          PIC S9(4) COMP VALUE 0.         
C32547     05  WS-WCP-FLAG              PIC X(01) VALUE 'N'.            
C32547         88  WS-WCP-EXISTS                  VALUE 'Y'.            
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-UPDATE               PIC X(01)  VALUE 'U'.            
           05  WS-DELETE               PIC X(01)  VALUE 'D'.            
           05  WS-INSERT               PIC X(01)  VALUE 'I'.            
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-PRV-COL-VALUE        PIC X(255) VALUE SPACES.         
           05  WS-CHG-COL-VALUE        PIC X(255) VALUE SPACES.         
                                                                        
       01  REDEFINE-FIELDS.                                             
           05  WS-ACCOUNT-NO             PIC X(13).                     
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                         PIC 9(13).                     
           05  WS-ACCOUNT-NO-COMP3       PIC S9999999999999V            
                                         COMP-3 VALUE +0.               
           05  WS-PREMISE-NO             PIC X(10).                     
           05  WS-PREMISE-NO-NUM REDEFINES WS-PREMISE-NO                
                                         PIC 9(10).                     
           05  WS-PREMISE-NO-COMP3       PIC S9999999999V               
                                         COMP-3 VALUE +0.               
T4755      05  WS-POINT-ID-X             PIC X(10) VALUE SPACES.        
           05  WS-WC-BACKUP-HOURS        PIC X(3).                      
           05  WS-WC-BACKUP-HOURS-NUM REDEFINES WS-WC-BACKUP-HOURS      
                                         PIC 9(3).                      
           05  WS-WC-BACKUP-HOURS-COMP3  PIC S999V                      
                                         COMP-3 VALUE +0.               
           05  WS-WC-COMMENTS-LEN        PIC X(4).                      
           05  WS-WC-COMMENTS-LEN-NUM REDEFINES WS-WC-COMMENTS-LEN      
                                         PIC 9(4).                      
           05  WS-WC-COMMENTS-LEN-COMP   PIC S9999V                     
                                         COMP VALUE +0.                 
           05  WS-COMMENT-LEN            PIC X(04).                     
           05  WS-COMMENT-LEN-NUM REDEFINES WS-COMMENT-LEN              
                                         PIC 9(4).                      
           05  WS-COMMENT-LEN-COMP       PIC S9999V                     
                                         COMP VALUE +0.                 
                                                                        
       01  WS-KEY-VALUE.                                                
           05  WS-KEY.                                                  
               10  FILLER    PIC X(11) VALUE 'ACCOUNT-NO='.             
               10  WS-ACCOUNT-NO-KEY            PIC X(13).              
               10  FILLER    PIC X(12) VALUE '/PREMISE-NO='.            
               10  WS-PREMISE-NO-KEY            PIC X(10).              
           05  WS-KEY-LENGTH PIC 9(04) VALUE 46.                        
                                                                        
       01  PREV-VALUES.                                                 
C24056     05  WS-PREV-TAG-NM             PIC X(10).                    
C24056     05  WS-PREV-GIS-LOC-OFF        PIC X(03).                    
           05  WS-PREV-CODE-WC-EQUIP      PIC X(2).                     
           05  WS-PREV-EQUIP-INST-DATE    PIC X(26).                    
COB305     05 WS-PREV-BACKUP-HOURS        PIC S999V USAGE COMP-3 
COB305       VALUE 0.       
           05  WS-PREV-COMMENTS.                                        
              49 WS-PREV-COMMENTS-LEN     PIC S9(4) USAGE COMP.         
              49 WS-PREV-COMMENTS-TEXT    PIC X(200).                   
           05  WS-PREV-CODE-CRIT-OUTAGE   PIC X(2).                     
C24056     05  WS-PREV-GIS-POINT-ID       PIC S9(9) COMP.               
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
REARCH                                                                  
       01  CNS-COLUMN-NAMES.                                            
           05  CNS-RETURN-CODE          PIC X(11) VALUE                 
                                              'RETURN_CODE'.            
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH         10  S-SP-NAME               PIC X(18)      VALUE SPACES. 
REARCH         10  S-SQLCODE               PIC S9(9) COMP VALUE 0.      
REARCH         10  S-SQLSTATE              PIC X(5)       VALUE ' '.    
REARCH         10  S-TABLE-NAME            PIC X(18)      VALUE SPACES. 
REARCH         10  S-HOST-VARIABLES.                                    
REARCH               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.      
REARCH               49  S-HOST-VARIABLES-V  PIC X(255).                
REARCH         10  S-SQL-STATEMENT.                                     
REARCH               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.      
REARCH               49  S-SQL-STATEMENT-V   PIC X(255).                
REARCH         10  S-SQL-DESCRIPTION.                                   
REARCH               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.      
REARCH               49  S-SQL-DESCRIPTION-V PIC X(255).                
REARCH                                                                  
           EXEC SQL                                                     01940000
              INCLUDE SQLCA                                             01950000
           END-EXEC.                                                    01960000
                                                                        
           EXEC SQL                                                     02020000
              INCLUDE TBACCT                                            02030000
           END-EXEC.                                                    02040000
                                                                        
           EXEC SQL                                                     02060000
              INCLUDE TBMNHIST                                          02070000
           END-EXEC.                                                    02080000
                                                                        
           EXEC SQL                                                     02100000
              INCLUDE TBMNHDT                                           02110000
           END-EXEC.                                                    02120000
                                                                        
           EXEC SQL                                                     02140000
              INCLUDE TBUSRPRF                                          02150000
           END-EXEC.                                                    02160000
                                                                        
           EXEC SQL                                                     02180000
              INCLUDE TBWCACCT                                          02190000
           END-EXEC.                                                    02200000
                                                                        
C32547****************************                                      02201000
C32547* WO - CSS_WH_CROSS_PLUS   *                                      02202000
C32547****************************                                      02203000
C32547     EXEC SQL                                                     02204000
C32547         INCLUDE TBWCPLUS                                         02205000
C32547     END-EXEC.                                                    02206000
                                                                        
                                                                        
P33743     EXEC SQL                                                     02214100
P33743        INCLUDE TBPIMPNT                                          02214200
P33743     END-EXEC.                                                    02214300
                                                                        
C24056     EXEC SQL                                                     02215000
C24056        INCLUDE TBMTRENV                                          02216000
C24056     END-EXEC.                                                    02217000
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACTION              PIC  X(01).                          
REARCH 01 PARM-USER-ID             PIC  X(07).                          
REARCH 01 PARM-PREMISE-NO          PIC  X(10).                          
REARCH 01 PARM-POINT-ID            PIC  X(10).                          
REARCH 01 PARM-ACCOUNT-NO          PIC  X(13).                          
REARCH 01 PARM-CODE-WC-EQUIP       PIC  X(02).                          
REARCH 01 PARM-WC-EQUIP-INST-DATE  PIC  X(26).                          
REARCH 01 PARM-WC-BACKUP-HOURS     PIC  X(03).                          
REARCH 01 PARM-WC-COMMENTS-LEN     PIC  X(04).                          
REARCH 01 PARM-WC-COMMENTS-TEXT    PIC  X(200).                         
REARCH 01 PARM-COMMENT-LEN         PIC  X(04).                          
REARCH 01 PARM-COMMENT-TEXT        PIC  X(210).                         
REARCH PROCEDURE DIVISION USING    PARM-ACTION                          
REARCH                             PARM-USER-ID                         
REARCH                             PARM-PREMISE-NO                      
REARCH                             PARM-POINT-ID                        
REARCH                             PARM-ACCOUNT-NO                      
REARCH                             PARM-CODE-WC-EQUIP                   
REARCH                             PARM-WC-EQUIP-INST-DATE              
REARCH                             PARM-WC-BACKUP-HOURS                 
REARCH                             PARM-WC-COMMENTS-LEN                 
REARCH                             PARM-WC-COMMENTS-TEXT                
REARCH                             PARM-COMMENT-LEN                     
REARCH                             PARM-COMMENT-TEXT.                   
                                                                        
      ******************************************************************02250000
      * 0000-MAINLINE                                                  *02260000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02270000
      ******************************************************************02280000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
REARCH     PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
REARCH     ADD +1                           TO CTR-ROWS.                
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02390000
      * 0100-INITIALIZE                                                *02400000
      *                                                                *02410000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02420000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02430000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02440000
      *                                                                *02450000
      ******************************************************************02460000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
REARCH      EXEC SQL                                                    
REARCH             DECLARE C1 CURSOR  FOR                    
REARCH             SELECT                                               
REARCH                 :S-RETURN-CODE      AS RETURN_CODE               
REARCH             FROM                                                 
REARCH                  CIS.SYSDUMMY1                                
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*     EXEC SQL                                                    02680200
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                    02680300
MFA-TR*            SELECT                                               02680400
MFA-TR*                :S-RETURN-CODE      AS RETURN_CODE               02680500
MFA-TR*            FROM                                                 02680600
MFA-TR*                 SYSIBM.SYSDUMMY1                                02680700
MFA-TR*     END-EXEC.                                                   02680800
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************04170000
      * 2000-PROCESS-OUTPUT.                                           *04180000
      *                                                                *04190000
      *     1. DESCRIBE RESULT SET                                     *04200000
      *     2. UPDATE DB2 DATA                                         *04210000
      *     3. BUILD RESULT SET                                        *04220000
      *     4. SEND RESULT SET                                         *04230000
      *                                                                *04240000
      ******************************************************************04250000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-REDEFINE-PARMS    THRU 2200-EXIT.               
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3       TO AT-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO-COMP3       TO WH-ACCOUNT-NO.             
           MOVE WS-PREMISE-NO-COMP3       TO AT-PREMISE-NO.             
           MOVE WS-PREMISE-NO-COMP3       TO WH-PREMISE-NO.             
                                                                        
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 PERFORM 3800-SELECT-ACCOUNT        THRU 3800-EXIT      
C32547           MOVE AT-ACCOUNT-NO                 TO WO-ACCOUNT-NO    
C32547           PERFORM 7120-SELECT-WHITE-CROSS-PLUS                   
C32547              THRU 7120-EXIT                                      
C32547           IF  WS-WCP-EXISTS AND WS-PREV-CODE-CRIT-OUTAGE = 'WX'  
C32547               MOVE 'WP'               TO AT-CODE-CRIT-OUTAGE     
C32547           ELSE                                                   
C32547               MOVE SPACES             TO AT-CODE-CRIT-OUTAGE     
C32547           END-IF                                                 
                 PERFORM 3000-UPDATE-ACCOUNT        THRU 3000-EXIT      
                 PERFORM 3900-SELECT-WHITE-CROSS    THRU 3900-EXIT      
                 PERFORM 3100-DELETE-WHITE-CROSS    THRU 3100-EXIT      
                 PERFORM 5000-JRNL-UPDATE           THRU 5000-EXIT      
              WHEN WS-INSERT                                            
C32547           PERFORM 3800-SELECT-ACCOUNT        THRU 3800-EXIT      
C32547           MOVE AT-ACCOUNT-NO                 TO WO-ACCOUNT-NO    
C32547           PERFORM 7120-SELECT-WHITE-CROSS-PLUS                   
C32547              THRU 7120-EXIT                                      
C32547           IF  WS-WCP-EXISTS AND WS-PREV-CODE-CRIT-OUTAGE = 'WP'  
C32547               MOVE 'WX'               TO AT-CODE-CRIT-OUTAGE     
C32547           ELSE                                                   
C32547               MOVE 'WC'               TO AT-CODE-CRIT-OUTAGE     
C32547           END-IF                                                 
                 PERFORM 3000-UPDATE-ACCOUNT        THRU 3000-EXIT      
C24056           MOVE SPACES                   TO WH-POINT-ID           
C24056           MOVE PP-POINT-ID              TO WH-GIS-POINT-ID       
                 MOVE PARM-CODE-WC-EQUIP       TO WH-CODE-WC-EQUIP      
                 MOVE PARM-WC-EQUIP-INST-DATE  TO WH-WC-EQUIP-INST-DATE 
                 MOVE WS-WC-BACKUP-HOURS-COMP3 TO WH-WC-BACKUP-HOURS    
                 MOVE WS-WC-COMMENTS-LEN-COMP  TO WH-WC-COMMENTS-LEN    
                 MOVE PARM-WC-COMMENTS-TEXT    TO WH-WC-COMMENTS-TEXT   
                 PERFORM 3200-INSERT-WHITE-CROSS    THRU 3200-EXIT      
                 PERFORM 5000-JRNL-UPDATE           THRU 5000-EXIT      
              WHEN WS-UPDATE                                            
C24056           MOVE SPACES                   TO WH-POINT-ID           
C24056           MOVE PP-POINT-ID              TO WH-GIS-POINT-ID       
                 MOVE PARM-CODE-WC-EQUIP       TO WH-CODE-WC-EQUIP      
                 MOVE PARM-WC-EQUIP-INST-DATE  TO WH-WC-EQUIP-INST-DATE 
                 MOVE WS-WC-BACKUP-HOURS-COMP3 TO WH-WC-BACKUP-HOURS    
                 MOVE WS-WC-COMMENTS-LEN-COMP  TO WH-WC-COMMENTS-LEN    
                 MOVE PARM-WC-COMMENTS-TEXT    TO WH-WC-COMMENTS-TEXT   
                 PERFORM 3900-SELECT-WHITE-CROSS    THRU 3900-EXIT      
                 PERFORM 3300-UPDATE-WHITE-CROSS    THRU 3300-EXIT      
                 PERFORM 5000-JRNL-UPDATE           THRU 5000-EXIT      
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************04681001
REARCH*2000A-MOVE-RESULT.                                              *04682001
REARCH******************************************************************04683001
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE   RS-RETURN-CODE  TO   S-RETURN-CODE.                   
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH                                                                  
                                                                        
      ******************************************************************05010000
      *  2200-REDEFINE-PARMS                                           *05020000
      *                                                                *05030000
      *     CONVERT THE NUMERIC PARAMETERS TO COMP OR COMP-3           *05040000
      *     WORKING STORAGE TO USE IN UPDATING THE DATABASE.           *05050000
      ******************************************************************05060000
                                                                        
       2200-REDEFINE-PARMS.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO-COMP3.       
           MOVE PARM-PREMISE-NO           TO WS-PREMISE-NO.             
           MOVE WS-PREMISE-NO-NUM         TO WS-PREMISE-NO-COMP3.       
           MOVE PARM-WC-BACKUP-HOURS      TO WS-WC-BACKUP-HOURS.        
           MOVE WS-WC-BACKUP-HOURS-NUM    TO WS-WC-BACKUP-HOURS-COMP3.  
           MOVE PARM-WC-COMMENTS-LEN      TO WS-WC-COMMENTS-LEN.        
           MOVE WS-WC-COMMENTS-LEN-NUM    TO WS-WC-COMMENTS-LEN-COMP.   
           MOVE PARM-COMMENT-LEN          TO WS-COMMENT-LEN.            
           MOVE WS-COMMENT-LEN-NUM        TO WS-COMMENT-LEN-COMP.       
                                                                        
C24056     IF PARM-ACTION = WS-DELETE                                   
C24056         NEXT SENTENCE                                            
C24056     ELSE                                                         
C24056         PERFORM 3400-GET-TAG-NM        THRU 3400-EXIT
           END-IF.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05260000
      *  3000-UPDATE-ACCOUNT                                           *05270000
      *                                                                *05280000
      *     UPDATE THE CODE_CRIT_OUTAGE IN THE CSS_ACCOUNT TABLE.      *05290000
      *                                                                *05300000
      ******************************************************************05310000
                                                                        
       3000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
               SET CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE              
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05590000
      *  3100-DELETE-WHITE-CROSS                                       *05600000
      *                                                                *05610000
      *     DELETE AN ENTRY FROM THE WHITE CROSS TABLE.                *05620000
      *                                                                *05630000
      ******************************************************************05640000
                                                                        
       3100-DELETE-WHITE-CROSS.                                         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_ACCT_WHT_CROSS                             
             WHERE ACCOUNT_NO = :WH-ACCOUNT-NO AND                      
                   PREMISE_NO = :WH-PREMISE-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WH-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05940000
      *  3200-INSERT-WHITE-CROSS                                       *05950000
      *                                                                *05960000
      *     INSERT AN ENTRY IN THE WHITE CROSS TABLE.                  *05970000
      *                                                                *05980000
      ******************************************************************05990000
                                                                        
       3200-INSERT-WHITE-CROSS.                                         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_ACCT_WHT_CROSS                             
               ( PREMISE_NO,                                            
                 POINT_ID,                                              
                 ACCOUNT_NO,                                            
                 CODE_WC_EQUIP,                                         
                 WC_EQUIP_INST_DATE,                                    
                 WC_BACKUP_HOURS,                                       
                 WC_COMMENTS,                                           
C24056           GIS_POINT_ID )                                         
             VALUES                                                     
               ( :WH-PREMISE-NO,                                        
                 :WH-POINT-ID,                                          
                 :WH-ACCOUNT-NO,                                        
                 :WH-CODE-WC-EQUIP,                                     
                 IIF(TRY_CONVERT(DATE, :WH-WC-EQUIP-INST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WH-WC-EQUIP-INST-DATE
              ) <> 0) OR (LEN(:WH-WC-EQUIP-INST-DATE
              ) <> 10), CIS.CHAR2DATE(:WH-WC-EQUIP-INST-DATE
              ), CONVERT(DATE, :WH-WC-EQUIP-INST-DATE) ),                      
                 :WH-WC-BACKUP-HOURS,                                   
                 :WH-WC-COMMENTS,                                       
C24056           :WH-GIS-POINT-ID)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06030000
MFA-TR*      INSERT INTO CSS_ACCT_WHT_CROSS                             06040000
MFA-TR*        ( PREMISE_NO,                                            06050000
MFA-TR*          POINT_ID,                                              06060000
MFA-TR*          ACCOUNT_NO,                                            06070000
MFA-TR*          CODE_WC_EQUIP,                                         06080000
MFA-TR*          WC_EQUIP_INST_DATE,                                    06090000
MFA-TR*          WC_BACKUP_HOURS,                                       06100000
MFA-TR*          WC_COMMENTS,                                           06110000
MFA-TR*          GIS_POINT_ID )                                         06111000
MFA-TR*      VALUES                                                     06120000
MFA-TR*        ( :WH-PREMISE-NO,                                        06130000
MFA-TR*          :WH-POINT-ID,                                          06140000
MFA-TR*          :WH-ACCOUNT-NO,                                        06150000
MFA-TR*          :WH-CODE-WC-EQUIP,                                     06160000
MFA-TR*          :WH-WC-EQUIP-INST-DATE,                                06170000
MFA-TR*          :WH-WC-BACKUP-HOURS,                                   06180000
MFA-TR*          :WH-WC-COMMENTS,                                       06190000
MFA-TR*          :WH-GIS-POINT-ID)                                      06191000
MFA-TR*    END-EXEC.                                                    06200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WH-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06430000
      *  3300-UPDATE-WHITE-CROSS                                       *06440000
      *                                                                *06450000
      *     UPDATE THE WHITE CROSS TABLE.                              *06460000
      *                                                                *06470000
      ******************************************************************06480000
                                                                        
       3300-UPDATE-WHITE-CROSS.                                         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCT_WHT_CROSS                                  
               SET POINT_ID           = :WH-POINT-ID,                   
                   CODE_WC_EQUIP      = :WH-CODE-WC-EQUIP,              
                   WC_EQUIP_INST_DATE = IIF(TRY_CONVERT(DATE, 
                                                 :WH-WC-EQUIP-INST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WH-WC-EQUIP-INST-DATE
              ) <> 0) OR (LEN(:WH-WC-EQUIP-INST-DATE
              ) <> 10), CIS.CHAR2DATE(:WH-WC-EQUIP-INST-DATE
              ), CONVERT(DATE, :WH-WC-EQUIP-INST-DATE) ),         
                   WC_BACKUP_HOURS    = :WH-WC-BACKUP-HOURS,            
                   WC_COMMENTS        = :WH-WC-COMMENTS,                
C24056             GIS_POINT_ID       = :WH-GIS-POINT-ID                
             WHERE ACCOUNT_NO = :WH-ACCOUNT-NO AND                      
                   PREMISE_NO = :WH-PREMISE-NO                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06520000
MFA-TR*      UPDATE CSS_ACCT_WHT_CROSS                                  06530000
MFA-TR*        SET POINT_ID           = :WH-POINT-ID,                   06540000
MFA-TR*            CODE_WC_EQUIP      = :WH-CODE-WC-EQUIP,              06550000
MFA-TR*            WC_EQUIP_INST_DATE = :WH-WC-EQUIP-INST-DATE,         06560000
MFA-TR*            WC_BACKUP_HOURS    = :WH-WC-BACKUP-HOURS,            06570000
MFA-TR*            WC_COMMENTS        = :WH-WC-COMMENTS,                06580000
MFA-TR*            GIS_POINT_ID       = :WH-GIS-POINT-ID                06581000
MFA-TR*      WHERE ACCOUNT_NO = :WH-ACCOUNT-NO AND                      06590000
MFA-TR*            PREMISE_NO = :WH-PREMISE-NO                          06600000
MFA-TR*    END-EXEC.                                                    06610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WH-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24056 3400-GET-TAG-NM.                                                 
C24056                                                                  
C24056     MOVE WS-ACCOUNT-NO-COMP3    TO MN-ACCOUNT-NO.                
C33743     MOVE PARM-POINT-ID(1:3)     TO PP-AREA-ID.                   
C33743     MOVE PARM-POINT-ID(4:7)     TO PP-TAG-NM.                    
C24056                                                                  
C24056     EXEC SQL                                                     
C33743         SELECT TOP(1) PP.POINT_ID                                       
C33743           INTO :PP-POINT-ID                                      
C33743           FROM CSS_PIM_POINT PP,                                 
C24056                CSS_MTRD_ENVRNMT MN                               
C33743          WHERE TAG_NM          = :PP-TAG-NM                      
C33743            AND AREA_ID         = :PP-AREA-ID                     
C24056            AND MN.ACCOUNT_NO   = :MN-ACCOUNT-NO                  
C33743            AND MN.GIS_POINT_ID = PP.POINT_ID                     
T31339                                           
C24056     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     06831800
MFA-TR*        SELECT PP.POINT_ID                                       06831900
MFA-TR*          INTO :PP-POINT-ID                                      06832000
MFA-TR*          FROM CSS_PIM_POINT PP,                                 06832100
MFA-TR*               CSS_MTRD_ENVRNMT MN                               06832200
MFA-TR*         WHERE TAG_NM          = :PP-TAG-NM                      06832300
MFA-TR*           AND AREA_ID         = :PP-AREA-ID                     06832400
MFA-TR*           AND MN.ACCOUNT_NO   = :MN-ACCOUNT-NO                  06832500
MFA-TR*           AND MN.GIS_POINT_ID = PP.POINT_ID                     06832600
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                 06832700
MFA-TR*    END-EXEC.                                                    06832800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24056                                                                  
C24056     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C24056     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C24056        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
C24056     ELSE                                                         
C24056        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C24056        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C24056        MOVE '3400'                TO ACTIVE-PARAGRAPH            
C24056        MOVE 'SELECT'              TO ABEND-FUNCTION              
C24056        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C24056                                      ABEND-TABLES                
C33743        MOVE 'CSS_PIM_POINT'       TO TABLE-1                     
C24056        MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-2                     
C24056        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C24056        MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C24056        MOVE 'TAG_NM'              TO TABLE-ELEMENT-2             
C24056        MOVE PP-TAG-NM             TO HOSTVAR-ELEMENT-2           
C24056        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24056        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
C24056                                                                  
C24056 3400-EXIT.                                                       
C24056     EXIT.                                                        
                                                                        
      ******************************************************************06840000
      *  3500-GET-TIMESTAMP                                            *06850000
      *                                                                *06860000
      *     GET THE CURRENT TIMESTAMP.                                 *06870000
      *                                                                *06880000
      ******************************************************************06890000
                                                                        
       3500-GET-TIMESTAMP.                                              
                                                                        
           MOVE SPACES    TO WS-CURRENT-TIMESTAMP.                      
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06940000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             06941000
MFA-TR*    END-EXEC.                                                    06980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
               MOVE '3500'    TO ACTIVE-PARAGRAPH                       
T35434         MOVE 'SET'     TO ABEND-FUNCTION                         
               MOVE SPACES    TO ABEND-SQL-PREDICATES                   
                                 ABEND-TABLES                           
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07170000
      *  3600-GET-DATE                                                 *07180000
      *                                                                *07190000
      *     GET THE CURRENT DATE.                                      *07200000
      *                                                                *07210000
      ******************************************************************07220000
                                                                        
       3600-GET-DATE.                                                   
                                                                        
           MOVE SPACES    TO WS-CURRENT-DATE.                           
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07270000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       07271000
MFA-TR*    END-EXEC.                                                    07310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
               MOVE '3600'    TO ACTIVE-PARAGRAPH                       
T35434         MOVE 'SET'     TO ABEND-FUNCTION                         
               MOVE SPACES    TO ABEND-SQL-PREDICATES                   
                                 ABEND-TABLES                           
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       3600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07500000
      *                                                                *07510000
      *   3700-GET-RESP-AREA-ID                                        *07520000
      *                                                                *07530000
      *   GET THE RESPONSIBILTY AREA OF THE USER TO WRITE INTO THE     *07540000
      *   TRANSACTION HISTORY TABLE.                                   *07550000
      *                                                                *07560000
      ******************************************************************07570000
                                                                        
       3700-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
             SELECT RESP_AREA_ID                                        
             INTO :WS-RESP-AREA-ID                                      
             FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                        
             WHERE USER_ID = :PARM-USER-ID                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07610000
MFA-TR*      SELECT RESP_AREA_ID                                        07620000
MFA-TR*      INTO :WS-RESP-AREA-ID                                      07630000
MFA-TR*      FROM CSS_USER_PROFILE                                      07640000
MFA-TR*      WHERE USER_ID = :PARM-USER-ID                              07650000
MFA-TR*      WITH UR                                                    07650100
MFA-TR*    END-EXEC.                                                    07660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07860000
      *                                                                *07870000
      *   3800-SELECT-ACCOUNT                                          *07880000
      *                                                                *07890000
      *   SELECT CODE-CRIT-OUTAGE FROM THE CSS_ACCOUNT TABLE.          *07900000
      *                                                                *07910000
      ******************************************************************07920000
                                                                        
       3800-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT CODE_CRIT_OUTAGE                                    
             INTO :WS-PREV-CODE-CRIT-OUTAGE                             
             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07960000
MFA-TR*      SELECT CODE_CRIT_OUTAGE                                    07970000
MFA-TR*      INTO :WS-PREV-CODE-CRIT-OUTAGE                             07980000
MFA-TR*      FROM CSS_ACCOUNT                                           07990000
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          08000000
MFA-TR*      WITH UR                                                    08001000
MFA-TR*    END-EXEC.                                                    08010000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08210000
      *                                                                *08220000
      *   3900-SELECT-WHITE-CROSS                                      *08230000
      *                                                                *08240000
      *   SELECT FIELDS FROM THE CSS_ACCT_WHT_CROSS TABLE.             *08250000
      *                                                                *08260000
      ******************************************************************08270000
                                                                        
       3900-SELECT-WHITE-CROSS.                                         
                                                                        
           EXEC SQL                                                     
             SELECT CODE_WC_EQUIP,                                      
                    WC_EQUIP_INST_DATE,                                 
                    WC_BACKUP_HOURS,                                    
                    WC_COMMENTS,                                        
C24056              GIS_POINT_ID                                        
             INTO :WS-PREV-CODE-WC-EQUIP,                               
                  :WS-PREV-EQUIP-INST-DATE,                             
                  :WS-PREV-BACKUP-HOURS,                                
                  :WS-PREV-COMMENTS,                                    
C24056            :WS-PREV-GIS-POINT-ID                                 
             FROM CSS_ACCT_WHT_CROSS WITH(READUNCOMMITTED)                      
             WHERE ACCOUNT_NO = :WH-ACCOUNT-NO AND                      
                   PREMISE_NO = :WH-PREMISE-NO                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08310000
MFA-TR*      SELECT CODE_WC_EQUIP,                                      08330000
MFA-TR*             WC_EQUIP_INST_DATE,                                 08340000
MFA-TR*             WC_BACKUP_HOURS,                                    08350000
MFA-TR*             WC_COMMENTS,                                        08360000
MFA-TR*             GIS_POINT_ID                                        08361000
MFA-TR*      INTO :WS-PREV-CODE-WC-EQUIP,                               08380000
MFA-TR*           :WS-PREV-EQUIP-INST-DATE,                             08390000
MFA-TR*           :WS-PREV-BACKUP-HOURS,                                08400000
MFA-TR*           :WS-PREV-COMMENTS,                                    08410000
MFA-TR*           :WS-PREV-GIS-POINT-ID                                 08411000
MFA-TR*      FROM CSS_ACCT_WHT_CROSS                                    08420000
MFA-TR*      WHERE ACCOUNT_NO = :WH-ACCOUNT-NO AND                      08430000
MFA-TR*            PREMISE_NO = :WH-PREMISE-NO                          08440000
MFA-TR*       WITH UR                                                   08441000
MFA-TR*    END-EXEC.                                                    08450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3900'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WH-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
C24056     EXEC SQL                                                     
C33743         SELECT PP.TAG_NM,                                        
C33743                PP.AREA_ID                                        
C24056           INTO :WS-PREV-TAG-NM,                                  
C24056                :WS-PREV-GIS-LOC-OFF                              
C33743           FROM CSS_PIM_POINT PP WITH(READUNCOMMITTED)                    
C24056          WHERE POINT_ID        = :WS-PREV-GIS-POINT-ID           
T35434                                                           
C24056     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08634000
MFA-TR*        SELECT PP.TAG_NM,                                        08635000
MFA-TR*               PP.AREA_ID                                        08635100
MFA-TR*          INTO :WS-PREV-TAG-NM,                                  08636000
MFA-TR*               :WS-PREV-GIS-LOC-OFF                              08636100
MFA-TR*          FROM CSS_PIM_POINT PP                                  08637000
MFA-TR*         WHERE POINT_ID        = :WS-PREV-GIS-POINT-ID           08639000
MFA-TR*          WITH UR                                                08639100
MFA-TR*    END-EXEC.                                                    08639300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24056                                                                  
C24056     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C24056     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C24056        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
C24056     ELSE                                                         
C24056        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C24056        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C24056        MOVE '3900'                TO ACTIVE-PARAGRAPH            
C24056        MOVE 'SELECT'              TO ABEND-FUNCTION              
C24056        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C24056                                      ABEND-TABLES                
C33743        MOVE 'CSS_PIM_POINT'       TO TABLE-1                     
C24056        MOVE 'POINT_ID'            TO TABLE-ELEMENT-1             
C24056        MOVE PP-POINT-ID           TO HOSTVAR-ELEMENT-1           
C24056        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24056        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
C24056                                                                  
       3900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08670000
      *                                                                *08680000
      *   3950-CHECK-TIMESTAMP                                         *08690000
      *                                                                *08700000
      *   CHECK TO SEE IF THE TIMESTAMP IS ALREADY USED AS A KEY IN    *08710000
      *   TRANSACTION HISTORY TABLE.                                   *08720000
      *                                                                *08730000
      ******************************************************************08740000
                                                                        
       3950-CHECK-TIMESTAMP.                                            
                                                                        
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
               INTO :MH-TRANS-HIST-SEQ-NO                               
             FROM CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                      
             WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )            
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08780000
MFA-TR*      SELECT TRANS_HIST_SEQ_NO                                   08790000
MFA-TR*        INTO :MH-TRANS-HIST-SEQ-NO                               08800000
MFA-TR*      FROM CSS_MNT_TRANS_HIST                                    08810000
MFA-TR*      WHERE TRANS_HIST_SEQ_NO = :WS-CURRENT-TIMESTAMP            08820000
MFA-TR*      WITH UR                                                    08821000
MFA-TR*    END-EXEC.                                                    08830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3950'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MNT_TRANS_HIST'  TO TABLE-1                     
              MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-TIMESTAMP  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       3950-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     09030000
             INCLUDE CPD00067                                           09040000
           END-EXEC.                                                    09050000
                                                                        
      ******************************************************************09070000
      *                                                                *09080000
      *   5000-JRNL-UPDATE                                             *09090000
      *                                                                *09100000
      *   WRITE OUT A TRANSACTION HISTORY IF THIS IS AN UPDATE         *09110000
      *   INSTEAD OF AN INSERT.                                        *09120000
      *                                                                *09130000
      ******************************************************************09140000
                                                                        
       5000-JRNL-UPDATE.                                                
                                                                        
           PERFORM 5100-JRNL-HEADER   THRU 5100-EXIT.                   
           PERFORM 5200-JRNL-DETAILS  THRU 5200-EXIT.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   09220000
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *   09230000
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *   09240000
      ***************************************************************   09250000
                                                                        
       5100-JRNL-HEADER.                                                
                                                                        
           PERFORM 3500-GET-TIMESTAMP       THRU 3500-EXIT.             
           PERFORM 3950-CHECK-TIMESTAMP     THRU 3950-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             PERFORM 3500-GET-TIMESTAMP       THRU 3500-EXIT            
             PERFORM 3950-CHECK-TIMESTAMP     THRU 3950-EXIT            
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'TWO ATTEMPTS TO'    TO TABLE-1                     
               MOVE 'CALCULATE UNIQUE'   TO TABLE-ELEMENT-1             
               MOVE 'TIMESTAMP FAILED'   TO HOSTVAR-ELEMENT-1           
               MOVE -1                   TO WS-ACTIVE-RETURN-CODE       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.           
                                                                        
           PERFORM 3600-GET-DATE         THRU 3600-EXIT.                
           MOVE WS-CURRENT-DATE      TO MH-DATE-TRANS.                  
                                                                        
           PERFORM 3700-GET-RESP-AREA-ID THRU 3700-EXIT.                
                                                                        
           MOVE 'F'                  TO MH-CODE-TRAN-TYPE.              
           MOVE WS-RESP-AREA-ID      TO MH-RESP-AREA-ID.                
           MOVE WS-ACCOUNT-NO-COMP3  TO MH-ACCOUNT-NO.                  
           MOVE ZEROES               TO MH-CUSTOMER-NO.                 
           MOVE ZEROES               TO MH-PREMISE-NO.                  
           MOVE PARM-USER-ID         TO MH-USER-ID.                     
           MOVE 'PANEL280'           TO MH-APPL-PROGRAM-ID.             
           MOVE PARM-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.           
           MOVE WS-COMMENT-LEN-COMP  TO MH-TRAN-COMMENT-LEN.            
           MOVE WS-KEY-LENGTH        TO MH-ENTITY-KEY-DESC-LEN          
           MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO-KEY               
           MOVE PARM-PREMISE-NO      TO WS-PREMISE-NO-KEY               
           MOVE WS-KEY               TO MH-ENTITY-KEY-DESC-TEXT.        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09690000
      *                                                                *09700000
      *   5200-JRNL-DETAILS                                            *09710000
      *                                                                *09720000
      *   WRITE OUT THE TRANSACTION HISTORY DETAILS.                   *09730000
      *                                                                *09740000
      ******************************************************************09750000
                                                                        
       5200-JRNL-DETAILS.                                               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 MOVE PARM-POINT-ID           TO WS-PRV-COL-VALUE       
                 MOVE +9                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE '*DELETED*'             TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-INSERT                                            
                 MOVE '*NEW*'                 TO WS-PRV-COL-VALUE       
                 MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-POINT-ID           TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-UPDATE                                            
                 MOVE WS-PREV-GIS-LOC-OFF     TO WS-PRV-COL-VALUE(1:3)  
                 MOVE WS-PREV-TAG-NM          TO WS-PRV-COL-VALUE(4:7)  
                 MOVE +9                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-POINT-ID           TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'POINT ID       '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 MOVE WS-PREV-CODE-WC-EQUIP   TO WS-PRV-COL-VALUE       
                 MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE '*DELETED*'             TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-INSERT                                            
                 MOVE '*NEW*'                 TO WS-PRV-COL-VALUE       
                 MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-CODE-WC-EQUIP      TO WS-CHG-COL-VALUE       
                 MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-UPDATE                                            
                 MOVE WS-PREV-CODE-WC-EQUIP   TO WS-PRV-COL-VALUE       
                 MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-CODE-WC-EQUIP      TO WS-CHG-COL-VALUE       
                 MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'EQUIPMENT      '     TO MI-COLUMN-DESC              
              MOVE '58'                  TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
           MOVE SPACES                TO MI-TABLE-ID.                   
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 MOVE WS-PREV-EQUIP-INST-DATE TO WS-PRV-COL-VALUE       
                 MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE '*DELETED*'             TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-INSERT                                            
                 MOVE '*NEW*'                 TO WS-PRV-COL-VALUE       
                 MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE WH-WC-EQUIP-INST-DATE   TO WS-CHG-COL-VALUE       
                 MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-UPDATE                                            
                 MOVE WS-PREV-EQUIP-INST-DATE TO WS-PRV-COL-VALUE       
                 MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE WH-WC-EQUIP-INST-DATE   TO WS-CHG-COL-VALUE       
                 MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'INSTALLED DATE '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 MOVE WS-PREV-BACKUP-HOURS    TO WS-PRV-COL-VALUE       
                 MOVE +3                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE '*DELETED*'             TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-INSERT                                            
                 MOVE '*NEW*'                 TO WS-PRV-COL-VALUE       
                 MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-WC-BACKUP-HOURS    TO WS-CHG-COL-VALUE       
                 MOVE +3                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-UPDATE                                            
                 MOVE WS-PREV-BACKUP-HOURS    TO WS-PRV-COL-VALUE       
                 MOVE +3                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE WH-WC-BACKUP-HOURS      TO WS-CHG-COL-VALUE       
                 MOVE +3                      TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'BACKUP HOURS   '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                 MOVE WS-PREV-COMMENTS-TEXT   TO WS-PRV-COL-VALUE       
                 MOVE WS-PREV-COMMENTS-LEN    TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE '*DELETED*'             TO WS-CHG-COL-VALUE       
                 MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-INSERT                                            
                 MOVE '*NEW*'                 TO WS-PRV-COL-VALUE       
                 MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-WC-COMMENTS-TEXT   TO WS-CHG-COL-VALUE       
                 MOVE WS-WC-COMMENTS-LEN-COMP TO MI-CHG-COLUMN-VALUE-LEN
              WHEN WS-UPDATE                                            
                 MOVE WS-PREV-COMMENTS-TEXT   TO WS-PRV-COL-VALUE       
                 MOVE WS-PREV-COMMENTS-LEN    TO MI-PRV-COLUMN-VALUE-LEN
                 MOVE PARM-WC-COMMENTS-TEXT   TO WS-CHG-COL-VALUE       
                 MOVE WS-WC-COMMENTS-LEN-COMP TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
T11655     IF (WS-PREV-COMMENTS-LEN     EQUAL ZEROES                    
T11655        AND                                                       
T11655         WS-WC-COMMENTS-LEN-COMP  EQUAL ZEROES)                   
T11655        OR                                                        
T11655        (WS-PREV-COMMENTS-LEN  EQUAL WS-WC-COMMENTS-LEN-COMP      
T11655         AND                                                      
T11655         WS-PREV-COMMENTS-LEN > 0                                 
T11655         AND                                                      
T11655         WS-PRV-COL-VALUE(1:WS-PREV-COMMENTS-LEN)                 
T11655         EQUAL                                                    
T11655         WS-CHG-COL-VALUE(1:WS-WC-COMMENTS-LEN-COMP))             
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'COMMENTS       '     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
T19917        IF MI-CHG-COLUMN-VALUE-LEN > +75                          
T19917            MOVE +75 TO MI-CHG-COLUMN-VALUE-LEN                   
T19917        END-IF                                                    
T19917        IF MI-PRV-COLUMN-VALUE-LEN > +75                          
T19917            MOVE +75 TO MI-PRV-COLUMN-VALUE-LEN                   
T19917        END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
           MOVE SPACES                TO WS-PRV-COL-VALUE               
           MOVE SPACES                TO WS-CHG-COL-VALUE               
           EVALUATE PARM-ACTION                                         
              WHEN WS-DELETE                                            
                MOVE WS-PREV-CODE-CRIT-OUTAGE TO WS-PRV-COL-VALUE       
                MOVE +2                       TO MI-PRV-COLUMN-VALUE-LEN
C32547          IF  AT-CODE-CRIT-OUTAGE = SPACES                        
                    MOVE '*DELETED*'          TO WS-CHG-COL-VALUE       
                    MOVE  +9                  TO MI-CHG-COLUMN-VALUE-LEN
C32547          ELSE                                                    
C32547              MOVE AT-CODE-CRIT-OUTAGE  TO WS-CHG-COL-VALUE       
C32547              MOVE  +2                  TO MI-CHG-COLUMN-VALUE-LEN
C32547          END-IF                                                  
              WHEN WS-INSERT                                            
C32547          IF  WS-PREV-CODE-CRIT-OUTAGE = SPACES                   
                    MOVE '*NEW*'              TO WS-PRV-COL-VALUE       
                    MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN
C32547          ELSE                                                    
C32547              MOVE                                                
C32547              WS-PREV-CODE-CRIT-OUTAGE  TO WS-PRV-COL-VALUE       
C32547              MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN
C32547          END-IF                                                  
C32547          MOVE AT-CODE-CRIT-OUTAGE      TO WS-CHG-COL-VALUE       
                MOVE +2                       TO MI-CHG-COLUMN-VALUE-LEN
           END-EVALUATE                                                 
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'CDE CRIT OUTAGE'     TO MI-COLUMN-DESC              
              MOVE 'Q2'                  TO MI-TABLE-ID                 
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
           MOVE SPACES                TO MI-TABLE-ID.                   
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32547 7120-SELECT-WHITE-CROSS-PLUS.                                    
C32547                                                                  
C32547     MOVE '7120'                        TO ACTIVE-PARAGRAPH.      
C32547                                                                  
C32547     EXEC SQL                                                     
C32547       SELECT TOP(1) 'Y'                                                 
C32547         INTO :WS-WCP-FLAG                                        
C32547         FROM CSS_WH_CROSS_PLUS                                   
C32547        WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                         
C32547          AND STATUS_CD  = 'A'                                    
C32547                                              
C32547     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     11566000
MFA-TR*      SELECT 'Y'                                                 11568000
MFA-TR*        INTO :WS-WCP-FLAG                                        11569000
MFA-TR*        FROM CSS_WH_CROSS_PLUS                                   11569100
MFA-TR*       WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                         11569200
MFA-TR*         AND STATUS_CD  = 'A'                                    11569300
MFA-TR*       FETCH FIRST ROW ONLY                                      11569400
MFA-TR*    END-EXEC.                                                    11569600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32547     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C32547     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C32547         NEXT SENTENCE                                            
C32547     ELSE                                                         
C32547         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
C32547         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
C32547         MOVE 'SELECT'                  TO ABEND-FUNCTION         
C32547         MOVE 'CSS_WH_CROSS_PLUS'       TO TABLE-1                
C32547         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
C32547         MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-1      
C32547         PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
C32547         PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
C32547     END-IF.                                                      
C32547 7120-EXIT.                                                       
C32547     EXIT.                                                        
      ******************************************************************11580000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *11590000
      ******************************************************************11600000
REARCH     EXEC SQL                                                     11631000
REARCH        INCLUDE CPDSP300                                          11632000
REARCH     END-EXEC.                                                    11633000
                                                                        
      ******************************************************************11650000
      *       END PROGRAM COPYLIB                                      *11660000
      ******************************************************************11670000
REARCH     EXEC SQL                                                     11681000
REARCH        INCLUDE CPD00321                                          11682000
REARCH     END-EXEC.                                                    11683000
                                                                        
