       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02065.                                         
       DATE-WRITTEN. MAR 29, 1995.                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S065 CONVERTED TO DB2 SP CSR02065 ON 03/07/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S065                                           *        
      *  PROGRAM:       S065                                           *        
      *  CALLING SP:    PN_S065                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ACCOUNT BILLING ADDRESS IN THE     *        
      *  CROSS REFERENCE TABLES: CSS_NAME_ACCT_XREF AND                *        
      *  CSS_BILL_ADDR_XREF.                                           *        
      *                                                                *        
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *        
      *                                                                *        
      *  TABLE                  TABLE ID     DCLGEN                    *        
      *  -----                  --------     ------                    *        
      *  CSS_BILL_ADDR_XREF        AQ        TBBLADRX                  *        
      *  CSS_NAME_ACCT_XREF        HT        TBNMACTX                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  03/29/95    RKL      CREATED.                                 *        
      *                                                                *        
REARCH*  03/07/06    CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
C32615*  06/08/06    FMB      ADD SERVICE ADDRESS TO RESULTS SET       *        
C35664*  09/06/07    SC       DISPLAY STREET NAME, TOWN & FULL NAME    *        
C35664*                        COMPLETELY                              *        
C35671*  09/12/07    CVNS     NAME AND ADDRESS FORMAT CHANGES          *        
C35671*              CHENNAI                                           *        
C35665*  12/30/08    FMB      REMOVED CSS_NAME_ACCT_XREF CURSOR.       *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02065'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02065 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_BILL_ADDR_XREF >                                               
           EXEC SQL                                                             
              INCLUDE TBBLADRX                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_NAME_ACCT_XREF >                                               
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
C32615*----< CSS_ADDR_FORMATTED >                                               
C32615     EXEC SQL                                                             
C32615        INCLUDE TBADRFMT                                                  
C32615     END-EXEC.                                                            
C32615*----< CSS_ACCOUNT >                                                      
C32615     EXEC SQL                                                             
C32615        INCLUDE TBACCT                                                    
C32615     END-EXEC.                                                            
C32615*----< CSS_PREMISE >                                                      
C32615     EXEC SQL                                                             
C32615        INCLUDE TBPREM                                                    
C32615     END-EXEC.                                                            
C32615*----< CSS_NAME >                                                         
C32615     EXEC SQL                                                             
C32615        INCLUDE TBNAME                                                    
C32615     END-EXEC.                                                            
C32615*----< CSS_ZIP_CODE >                                                     
C32615     EXEC SQL                                                             
C32615        INCLUDE TBZIPCD                                                   
C32615     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR02065'.  
           05  GWL-STATUS-SUBCODE        PIC S9(9)   COMP.              
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9)   COMP.              
           05  PARM-ADDRESS-ID           PIC X(13)   VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
COB305     05 RS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 RS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
C35671     05  RS-FULL-NAME              PIC X(72)   VALUE SPACES.      
           05  RS-ADDR-TYPE              PIC X(15)   VALUE SPACES.      
C37649     05  RS-SERVICE-ADDRESS        PIC X(150)  VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
COB305     05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 S-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
C35671     05  S-FULL-NAME               PIC X(72)   VALUE SPACES.      
REARCH     05  S-ADDR-TYPE               PIC X(15)   VALUE SPACES.      
C37649     05  S-SERVICE-ADDRESS         PIC X(150)  VALUE SPACES.      
                                                                        
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ADDRESS-ID             PIC X(13)   VALUE SPACES.      
           05  WS-ADDRESS-ID-I           PIC S9(13)  USAGE COMP.        
COB305     05 WS-ADDRESS-ID-D        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
C35671     05  WS-FULL-NAME              PIC X(72)   VALUE SPACES.      
           05  WS-ADDR-TYPE              PIC X(15)   VALUE SPACES.      
C32615     05  WS-SERVICE-ADDRESS        PIC X(150)  VALUE SPACES.      
C32615     05  WS-SELECT-SQLCODE         PIC S9(9) VALUE +000 COMP.     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE AQ-CURSOR CURSOR FOR                        
              SELECT  AQ.ACCOUNT_NO,                                    
                      AQ.NAME_ID,                                       
C35664*               DQ.FULL_NAME,                                             
C35664                (CASE WHEN DQ.NAME_FORMAT = 'B'                   
C35664                 THEN RTRIM(DQ.FULL_NAME)                         
C35664             ELSE CIS.CONCAT(CIS.CONCAT(CIS.CONCAT(CIS.CONCAT(
           RTRIM(DQ.LAST_NAME) 
C35664                ,' '),RTRIM(DQ.FIRST_NAME)),' '),                 
C35664                DQ.MIDDLE_NAME)  END) AS FULL_NAME,               
C32615                PR.ADDRESS_ID,                                    
C32615                DY.HOUSE_NO,                                      
C32615                DY.ADDR_PREFIX_1,                                 
C32615                DY.ADDR_PREFIX_2,                                 
C32615                DY.STREET_NAME,                                   
C32615                DY.ADDR_SUFFIX,                                   
C32615                DY.STREET_SUFFIX,                                 
C32615                DY.STREET_LOCATION_1,                             
C32615                DY.STREET_LOCATION_2,                             
C32615                DY.ZIP_CODE,                                      
C32615                DY.ZIP_CODE_TOKEN,                                
C32615                A4.TOWN,                                          
C32615                A4.STATE                                          
              FROM    CSS_BILL_ADDR_XREF        AQ
                           WITH(READUNCOMMITTED),                     
                      CSS_NAME                  DQ
                           WITH(READUNCOMMITTED),                     
C32615                CSS_ACCOUNT               AT
                           WITH(READUNCOMMITTED),                     
C32615                CSS_PREMISE               PR
                           WITH(READUNCOMMITTED),                     
C32615                CSS_ADDR_FORMATTED        DY
                           WITH(READUNCOMMITTED),                     
C32615                CSS_ZIP_CODE              A4 WITH(READUNCOMMITTED)        
              WHERE   AQ.ADDRESS_ID             = :WS-ADDRESS-ID-D      
              AND     AQ.NAME_ID                = DQ.NAME_ID            
C32615        AND     AQ.ACCOUNT_NO             = AT.ACCOUNT_NO         
C32615        AND     AT.PREMISE_NO             = PR.PREMISE_NO         
C32615        AND     PR.ADDRESS_ID             = DY.ADDRESS_ID         
C32615        AND     DY.ZIP_CODE               = A4.ZIP_CODE           
C32615        AND     DY.ZIP_CODE_TOKEN         = A4.ZIP_CODE_TOKEN     
C32615        ORDER BY DY.ZIP_CODE,                                     
C32615                 DY.ZIP_CODE_TOKEN,                               
C32615                 DY.STREET_NAME,                                  
C32615                 DY.HOUSE_NO,                                     
C32615                 DY.STREET_LOCATION_1,                            
C32615                 DY.STREET_LOCATION_2                             
C32615        FOR READ ONLY                                            
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE AQ-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  AQ.ACCOUNT_NO,                                            
MFA-TR*               AQ.NAME_ID,                                               
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               (CASE WHEN DQ.NAME_FORMAT = 'B'                           
MFA-TR*                THEN RTRIM(DQ.FULL_NAME)                                 
MFA-TR*            ELSE CONCAT(CONCAT(CONCAT(CONCAT(RTRIM(DQ.LAST_NAME)         
MFA-TR*               ,' '),RTRIM(DQ.FIRST_NAME)),' '),                         
MFA-TR*               DQ.MIDDLE_NAME)  END) AS FULL_NAME,                       
MFA-TR*               PR.ADDRESS_ID,                                            
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.ADDR_SUFFIX,                                           
MFA-TR*               DY.STREET_SUFFIX,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               A4.TOWN,                                                  
MFA-TR*               A4.STATE                                                  
MFA-TR*       FROM    CSS_BILL_ADDR_XREF        AQ,                             
MFA-TR*               CSS_NAME                  DQ,                             
MFA-TR*               CSS_ACCOUNT               AT,                             
MFA-TR*               CSS_PREMISE               PR,                             
MFA-TR*               CSS_ADDR_FORMATTED        DY,                             
MFA-TR*               CSS_ZIP_CODE              A4                              
MFA-TR*       WHERE   AQ.ADDRESS_ID             = :WS-ADDRESS-ID-D              
MFA-TR*       AND     AQ.NAME_ID                = DQ.NAME_ID                    
MFA-TR*       AND     AQ.ACCOUNT_NO             = AT.ACCOUNT_NO                 
MFA-TR*       AND     AT.PREMISE_NO             = PR.PREMISE_NO                 
MFA-TR*       AND     PR.ADDRESS_ID             = DY.ADDRESS_ID                 
MFA-TR*       AND     DY.ZIP_CODE               = A4.ZIP_CODE                   
MFA-TR*       AND     DY.ZIP_CODE_TOKEN         = A4.ZIP_CODE_TOKEN             
MFA-TR*       ORDER BY DY.ZIP_CODE,                                             
MFA-TR*                DY.ZIP_CODE_TOKEN,                                       
MFA-TR*                DY.STREET_NAME,                                          
MFA-TR*                DY.HOUSE_NO,                                             
MFA-TR*                DY.STREET_LOCATION_1,                                    
MFA-TR*                DY.STREET_LOCATION_2                                     
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE HT-CURSOR CURSOR FOR                        
              SELECT  HT.ACCOUNT_NO,                                    
                      HT.NAME_ID,                                       
C35664*               DQ.FULL_NAME,                                             
C35664                (CASE WHEN DQ.NAME_FORMAT = 'B'                   
C35664                THEN RTRIM(DQ.FULL_NAME)                          
C35664              ELSE CIS.CONCAT(CIS.CONCAT(CIS.CONCAT(CIS.CONCAT(
           RTRIM(DQ.LAST_NAME)
C35664                ,' '),RTRIM(DQ.FIRST_NAME)),' '),                 
C35664                DQ.MIDDLE_NAME)  END) AS FULL_NAME,               
C32615                PR.ADDRESS_ID,                                    
C32615                DY.HOUSE_NO,                                      
C32615                DY.ADDR_PREFIX_1,                                 
C32615                DY.ADDR_PREFIX_2,                                 
C32615                DY.STREET_NAME,                                   
C32615                DY.ADDR_SUFFIX,                                   
C32615                DY.STREET_SUFFIX,                                 
C32615                DY.STREET_LOCATION_1,                             
C32615                DY.STREET_LOCATION_2,                             
C32615                DY.ZIP_CODE,                                      
C32615                DY.ZIP_CODE_TOKEN,                                
C32615                A4.TOWN,                                          
C32615                A4.STATE                                          
              FROM    CSS_NAME_ACCT_XREF   HT WITH(READUNCOMMITTED),            
                      CSS_NAME             DQ WITH(READUNCOMMITTED),            
C32615                CSS_ACCOUNT          AT WITH(READUNCOMMITTED),            
C32615                CSS_PREMISE          PR WITH(READUNCOMMITTED),            
C32615                CSS_ADDR_FORMATTED   DY WITH(READUNCOMMITTED),            
C32615                CSS_ZIP_CODE         A4 WITH(READUNCOMMITTED)             
              WHERE   HT.ADDRESS_ID        = :WS-ADDRESS-ID-D           
              AND     HT.NAME_ID           = DQ.NAME_ID                 
              AND     HT.CUSTOMER_ROLE_CD  = ' '                        
C32615        AND     HT.ACCOUNT_NO             = AT.ACCOUNT_NO         
C32615        AND     AT.PREMISE_NO             = PR.PREMISE_NO         
C32615        AND     PR.ADDRESS_ID             = DY.ADDRESS_ID         
C32615        AND     DY.ZIP_CODE               = A4.ZIP_CODE           
C32615        AND     DY.ZIP_CODE_TOKEN         = A4.ZIP_CODE_TOKEN     
C32615        ORDER BY DY.ZIP_CODE,                                     
C32615                 DY.ZIP_CODE_TOKEN,                               
C32615                 DY.STREET_NAME,                                  
C32615                 DY.HOUSE_NO,                                     
C32615                 DY.STREET_LOCATION_1,                            
C32615                 DY.STREET_LOCATION_2                             
C32615        FOR READ ONLY                                            
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE HT-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  HT.ACCOUNT_NO,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               (CASE WHEN DQ.NAME_FORMAT = 'B'                           
MFA-TR*               THEN RTRIM(DQ.FULL_NAME)                                  
MFA-TR*             ELSE CONCAT(CONCAT(CONCAT(CONCAT(RTRIM(DQ.LAST_NAME)        
MFA-TR*               ,' '),RTRIM(DQ.FIRST_NAME)),' '),                         
MFA-TR*               DQ.MIDDLE_NAME)  END) AS FULL_NAME,                       
MFA-TR*               PR.ADDRESS_ID,                                            
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.ADDR_SUFFIX,                                           
MFA-TR*               DY.STREET_SUFFIX,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               A4.TOWN,                                                  
MFA-TR*               A4.STATE                                                  
MFA-TR*       FROM    CSS_NAME_ACCT_XREF   HT,                                  
MFA-TR*               CSS_NAME             DQ,                                  
MFA-TR*               CSS_ACCOUNT          AT,                                  
MFA-TR*               CSS_PREMISE          PR,                                  
MFA-TR*               CSS_ADDR_FORMATTED   DY,                                  
MFA-TR*               CSS_ZIP_CODE         A4                                   
MFA-TR*       WHERE   HT.ADDRESS_ID        = :WS-ADDRESS-ID-D                   
MFA-TR*       AND     HT.NAME_ID           = DQ.NAME_ID                         
MFA-TR*       AND     HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*       AND     HT.ACCOUNT_NO             = AT.ACCOUNT_NO                 
MFA-TR*       AND     AT.PREMISE_NO             = PR.PREMISE_NO                 
MFA-TR*       AND     PR.ADDRESS_ID             = DY.ADDRESS_ID                 
MFA-TR*       AND     DY.ZIP_CODE               = A4.ZIP_CODE                   
MFA-TR*       AND     DY.ZIP_CODE_TOKEN         = A4.ZIP_CODE_TOKEN             
MFA-TR*       ORDER BY DY.ZIP_CODE,                                             
MFA-TR*                DY.ZIP_CODE_TOKEN,                                       
MFA-TR*                DY.STREET_NAME,                                          
MFA-TR*                DY.HOUSE_NO,                                             
MFA-TR*                DY.STREET_LOCATION_1,                                    
MFA-TR*                DY.STREET_LOCATION_2                                     
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH              RETURN_CODE                                         
REARCH             ,ACCOUNT_NO                                          
REARCH             ,NAME_ID                                             
REARCH             ,LTRIM(RTRIM(FULL_NAME))  AS FULL_NAME                      
REARCH             ,LTRIM(RTRIM(ADDR_TYPE))  AS ADDR_TYPE                      
C32615             ,LTRIM(RTRIM(SERVICE_ADDRESS))  AS SERVICE_ADDRESS          
CVT000         FROM #CSR02065_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,STRIP(FULL_NAME)  AS FULL_NAME                              
MFA-TR*            ,STRIP(ADDR_TYPE)  AS ADDR_TYPE                              
MFA-TR*            ,STRIP(SERVICE_ADDRESS)  AS SERVICE_ADDRESS                  
MFA-TR*        FROM SESSION.CSR02065_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ADDRESS-ID          PIC X(13).                          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ADDRESS-ID.                                        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
CVT000     MOVE LINK-ADDRESS-ID TO PARM-ADDRESS-ID.                     
CVT000     PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02065_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02065_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,ACCOUNT_NO               DECIMAL(13,0)                   
CVT000        ,NAME_ID                  DECIMAL(13,0)                   
C37649        ,FULL_NAME CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,ADDR_TYPE CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2              
C37649        ,SERVICE_ADDRESS CHAR(150)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                       
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*       ,FULL_NAME                CHAR(50)                                
C32615*       ,SERVICE_ADDRESS          CHAR(50)                                
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02065_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE           
                  MOVE SQLERRMC             TO ABEND-SQLERRMC           
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ADDRESS-ID    TO WS-ADDRESS-ID.                    
           MOVE WS-ADDRESS-ID      TO WS-ADDRESS-ID-I.                  
           MOVE WS-ADDRESS-ID-I    TO WS-ADDRESS-ID-D.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2400-BUILD-RESULT             THRU 2400-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT.                                             *        
REARCH******************************************************************        
REARCH                                                                  
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE                   TO S-RETURN-CODE.      
REARCH     MOVE RS-ACCOUNT-NO                    TO S-ACCOUNT-NO.       
REARCH     MOVE RS-NAME-ID                       TO S-NAME-ID.          
REARCH     MOVE RS-FULL-NAME                     TO S-FULL-NAME.        
REARCH     MOVE RS-ADDR-TYPE                     TO S-ADDR-TYPE.        
C32615     MOVE RS-SERVICE-ADDRESS               TO S-SERVICE-ADDRESS.  
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS  7000-OPEN-AQ-CURSOR                                 *        
      *            2500-PROCESS-AQ-BILL-ADDR                           *        
      *            8000-CLOSE-AQ-CURSOR                                *        
      *            7050-OPEN-HT-CURSOR                                 *        
      *            2550-PROCESS-HT-SERV-ADDR                           *        
      *            8050-CLOSE-HT-CURSOR                                *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2400-BUILD-RESULT.                                               
                                                                        
           MOVE '2400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7000-OPEN-AQ-CURSOR          THRU 7000-EXIT.         
           PERFORM 2500-PROCESS-AQ-BILL-ADDR    THRU 2500-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 8000-CLOSE-AQ-CURSOR         THRU 8000-EXIT.         
                                                                        
C35665*    PERFORM 7050-OPEN-HT-CURSOR          THRU 7050-EXIT.                 
C35665*    PERFORM 2550-PROCESS-HT-SERV-ADDR    THRU 2550-EXIT                  
C35665*       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                          
C35665*    PERFORM 8050-CLOSE-HT-CURSOR         THRU 8050-EXIT.                 
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-AQ-BILL-ADDR                                      *        
      *                                                                *        
      *     CALLS  7100-FETCH-AQ-BILL-ADDR                             *        
      *            8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     PROCESS THE BILLING ADDRESSES.                             *        
      ******************************************************************        
                                                                        
       2500-PROCESS-AQ-BILL-ADDR.                                       
                                                                        
           MOVE '2500'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7100-FETCH-AQ-BILL-ADDR      THRU 7100-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE        TO RS-RETURN-CODE       
              MOVE WS-ACCOUNT-NO-D              TO RS-ACCOUNT-NO        
C32615        PERFORM 7200-SERVICE-ADDRESS      THRU 7200-EXIT          
              MOVE WS-NAME-ID                   TO RS-NAME-ID           
              MOVE WS-FULL-NAME                 TO RS-FULL-NAME         
C32615        MOVE WS-SERVICE-ADDRESS           TO RS-SERVICE-ADDRESS   
              MOVE 'BILLING ADDRESS'            TO RS-ADDR-TYPE         
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-PROCESS-HT-SERV-ADDR                                      *        
      *                                                                *        
      *     CALLS  7150-FETCH-HT-SERV-ADDR                             *        
      *            8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     PROCESS THE SERVICE ADDRESSES.                             *        
      ******************************************************************        
                                                                        
       2550-PROCESS-HT-SERV-ADDR.                                       
                                                                        
           MOVE '2550'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7150-FETCH-HT-SERV-ADDR      THRU 7150-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE        TO RS-RETURN-CODE       
              MOVE WS-ACCOUNT-NO-D              TO RS-ACCOUNT-NO        
C32615        PERFORM 7200-SERVICE-ADDRESS      THRU 7200-EXIT          
              MOVE WS-NAME-ID                   TO RS-NAME-ID           
              MOVE WS-FULL-NAME                 TO RS-FULL-NAME         
C32615        MOVE WS-SERVICE-ADDRESS           TO RS-SERVICE-ADDRESS   
              MOVE 'SERVICE ADDRESS'            TO RS-ADDR-TYPE         
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-AQ-CURSOR                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     OEPNS THE AQ-CURSOR CURSOR.                                *        
      ******************************************************************        
                                                                        
       7000-OPEN-AQ-CURSOR.                                             
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN AQ-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '7050-OPEN-AQ-CURSOR'        TO ABEND-FUNCTION       
              MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-OPEN-HT-CURSOR                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE HT-CURSOR CURSOR.                                *        
      ******************************************************************        
                                                                        
       7050-OPEN-HT-CURSOR.                                             
                                                                        
           MOVE '7050' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN HT-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '7050-OPEN-HT-CURSOR'        TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-AQ-BILL-ADDR                                        *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2500-PROCESS-AQ-BILL-ADDR                      *        
      *                                                                *        
      *     RETRIEVES ACCOUNT BILLING ADDRESSES.                       *        
      ******************************************************************        
                                                                        
       7100-FETCH-AQ-BILL-ADDR.                                         
                                                                        
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH   AQ-CURSOR                                         
              INTO    :WS-ACCOUNT-NO-D,                                 
                      :WS-NAME-ID,                                      
                      :WS-FULL-NAME,                                    
                      :PR-ADDRESS-ID,                                   
C32615                :DY-HOUSE-NO,                                     
C32615                :DY-ADDR-PREFIX-1,                                
C32615                :DY-ADDR-PREFIX-2,                                
C32615                :DY-STREET-NAME,                                  
C32615                :DY-ADDR-SUFFIX,                                  
C32615                :DY-STREET-SUFFIX,                                
C32615                :DY-STREET-LOCATION-1,                            
C32615                :DY-STREET-LOCATION-2,                            
C32615                :DY-ZIP-CODE,                                     
C32615                :DY-ZIP-CODE-TOKEN,                               
C32615                :A4-TOWN,                                         
C32615                :A4-STATE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '7100-FETCH-AQ-BILL-ADDR'    TO ABEND-FUNCTION       
              MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-HT-SERV-ADDR                                        *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2550-PROCESS-HT-SERV-ADDR                      *        
      *                                                                *        
      *     RETRIEVES ACCOUNT SERVICE ADDRESSES.                       *        
      ******************************************************************        
                                                                        
       7150-FETCH-HT-SERV-ADDR.                                         
                                                                        
           MOVE '7150' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH   HT-CURSOR                                         
              INTO    :WS-ACCOUNT-NO-D,                                 
                      :WS-NAME-ID,                                      
                      :WS-FULL-NAME,                                    
                      :PR-ADDRESS-ID,                                   
C32615                :DY-HOUSE-NO,                                     
C32615                :DY-ADDR-PREFIX-1,                                
C32615                :DY-ADDR-PREFIX-2,                                
C32615                :DY-STREET-NAME,                                  
C32615                :DY-ADDR-SUFFIX,                                  
C32615                :DY-STREET-SUFFIX,                                
C32615                :DY-STREET-LOCATION-1,                            
C32615                :DY-STREET-LOCATION-2,                            
C32615                :DY-ZIP-CODE,                                     
C32615                :DY-ZIP-CODE-TOKEN,                               
C32615                :A4-TOWN,                                         
C32615                :A4-STATE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '7150-FETCH-HT-SERV-ADDR'    TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32615 7200-SERVICE-ADDRESS.                                            
C32615                                                                  
C32615     MOVE '7200' TO ACTIVE-PARAGRAPH.                             
C32615                                                                  
C32615     MOVE SPACES TO WS-SERVICE-ADDRESS.                           
C32615                                                                  
C32615     STRING DY-HOUSE-NO      DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-ADDR-PREFIX-1 DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-ADDR-PREFIX-2 DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C35664            DY-STREET-NAME   DELIMITED '  ',                      
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-ADDR-SUFFIX   DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-STREET-SUFFIX DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-STREET-LOCATION-1 DELIMITED SPACE,                 
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-STREET-LOCATION-2 DELIMITED SPACE,                 
C32615            ' '              DELIMITED SIZE,                      
C35664            A4-TOWN          DELIMITED '  ',                      
C32615            ' '              DELIMITED SIZE,                      
C32615            A4-STATE         DELIMITED SPACE,                     
C32615            ' '              DELIMITED SIZE,                      
C32615            DY-ZIP-CODE      DELIMITED SPACE                      
C32615     INTO WS-SERVICE-ADDRESS.                                     
C32615                                                                  
C32615 7200-EXIT.                                                       
C32615     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-CLOSE-AQ-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE AQ-CURSOR CURSOR.                               *        
      ******************************************************************        
                                                                        
       8000-CLOSE-AQ-CURSOR.                                            
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE AQ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '8000-CLOSE-AQ-CURSOR'       TO ABEND-FUNCTION       
              MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-CLOSE-HT-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE HT-CURSOR CURSOR.                               *        
      ******************************************************************        
                                                                        
       8050-CLOSE-HT-CURSOR.                                            
                                                                        
           MOVE '8050' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE HT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE '8050-CLOSE-HT-CURSOR'       TO ABEND-FUNCTION       
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02065_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,ACCOUNT_NO                                                
CVT000       ,NAME_ID                                                   
CVT000       ,FULL_NAME                                                 
CVT000       ,ADDR_TYPE                                                 
C32615       ,SERVICE_ADDRESS                                           
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :S-RETURN-CODE                                            
CVT000       ,:S-ACCOUNT-NO                                             
CVT000       ,:S-NAME-ID                                                
CVT000       ,:S-FULL-NAME                                              
CVT000       ,:S-ADDR-TYPE                                              
C32615       ,:S-SERVICE-ADDRESS                                        
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02065_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,NAME_ID                                                           
MFA-TR*      ,FULL_NAME                                                         
MFA-TR*      ,ADDR_TYPE                                                         
MFA-TR*      ,SERVICE_ADDRESS                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-NAME-ID                                                        
MFA-TR*      ,:S-FULL-NAME                                                      
MFA-TR*      ,:S-ADDR-TYPE                                                      
MFA-TR*      ,:S-SERVICE-ADDRESS                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000        MOVE SQLCODE              TO ABEND-SQLCODE                
CVT000        MOVE SQLSTATE             TO ABEND-SQLSTATE               
CVT000        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02065_R1'        TO TABLE-1                      
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE SQLERRMC             TO ABEND-SQLERRMC               
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000                                                                  
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000                                                                  
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000                                                                  
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000                                                                  
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02065_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02065_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000                                                                  
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000                                                                  
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02065_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE SQLERRMC             TO ABEND-SQLERRMC              
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
