       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02052.                                         
COB303 DATE-WRITTEN.     MARCH 13, 1995.                                
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S052 CONVERTED TO DB2 SP CSR02052 ON 08/02/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S052                                           *        
      *  PROGRAM:       S052                                           *        
      *  CALLING SP:    PN_S052                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              *        
      * DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        *        
      *                                                                *        
      * THIS PROGRAM DETERMINES A RATE'S ENERGY AND DEMAND TIME-OF-USE *        
      * PERIODS, AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.  IN        *        
      * ADDITION, THIS PROGRAM DETERMINES IF A RATE SUPPORTS LIFETIME  *        
      * PEAK DEMAND INFORMATION (FOR CSS_BILL_CONTRACT).               *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/13/95    JHR      CREATED.                                 *        
      *                                                                *        
CBSI  *  07/31/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
REARCH*  08/02/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02052'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02052 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDMDINS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SYBASE OPEN SERVER FOR CICS FACILITIES                                  
CVT999*    COPY SYGWCOB.                                                        
      * ADDED TO SUPPORT CICS RPCS                                              
CVT999*    COPY SYDBCOB.                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
CVT999*    COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME           PIC X(08) VALUE 'CSR02052'.       
CVT999*    05  GWL-PROC               POINTER.                                  
CVT999*    05  GWL-INIT-HANDLE        POINTER.                                  
CVT999*    05  GWL-RC                 PIC S9(9) COMP.                           
CVT999*    05  GWL-STATUS-NR          PIC S9(9) COMP.                           
CVT999*    05  GWL-STATUS-DONE        PIC S9(9) COMP.                           
CVT999*    05  GWL-STATUS-COUNT       PIC S9(9) COMP.                           
CVT999*    05  GWL-STATUS-COMM        PIC S9(9) COMP.                           
CVT999*    05  GWL-STATUS-RETURN-CODE PIC S9(9) COMP.                           
           05  GWL-STATUS-SUBCODE     PIC S9(9) COMP.                   
                                                                        
       01  FILLER                     PIC X(11) VALUE 'PARM FIELDS'.    
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                 PIC S9(9) COMP.                   
CVT999*    05  PARM-ID1               PIC S9(9) COMP VALUE 1.                   
           05  PARM-CODE-UTIL-TYPE    PIC X(01)      VALUE SPACES.      
           05  PARM-RATE-PLAN-NO      PIC X(03)      VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC               PIC S9(9) COMP.                   
CVT999*    05  SNA-CONNECTION-NAME    PIC X(8)       VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN             PIC S9(9) COMP VALUE 1.                   
           05  CTR-ROWS               PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
           05  WS-RCVPRM              PIC X(20)      VALUE SPACES.      
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-CMPNT-ID-CD         PIC X(02)      VALUE '10'.        
           05  WS-ACTIVE-CODE         PIC X(01)      VALUE 'A'.         
           05  WS-IDR-TYPE            PIC X(01)      VALUE 'I'.         
           05  WS-YES                 PIC X(01)      VALUE 'Y'.         
           05  WS-NO                  PIC X(01)      VALUE 'N'.         
           05  WS-MAX-VERS-NO-CNTRL       PIC S9(4) USAGE COMP.         
           05  WS-MAX-VERS-NO-CNTRL-NULL  PIC S9(4) USAGE COMP.         
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM        PIC S9(9) COMP.                           
CVT999*    05  WRKLEN1                PIC S9(9) COMP.                           
CVT999*    05  WRKLEN2                PIC S9(9) COMP.                           
           05  WRK-DONE-STATUS        PIC S9(9) COMP.                   
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-ENERGY-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-DEMAND-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-DEMAND-TYPE-UNITS   PIC X(01)      VALUE SPACES.      
           05  RS-ENABLE-PEAK-IND     PIC X(01)      VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-ENERGY-TYPE-CD       PIC X(01)      VALUE SPACES.      
REARCH     05  S-DEMAND-TYPE-CD       PIC X(01)      VALUE SPACES.      
REARCH     05  S-DEMAND-TYPE-UNITS    PIC X(01)      VALUE SPACES.      
REARCH     05  S-ENABLE-PEAK-IND      PIC X(01)      VALUE SPACES.      
REARCH*                                                                         
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CS-RETURN-CODE        PIC X(11) VALUE                            
CVT999*                                        'RETURN_CODE'.                   
CVT999*    05  CS-ENERGY-TYPE-CD     PIC X(14) VALUE                            
CVT999*                                        'ENERGY_TYPE_CD'.                
CVT999*    05  CS-DEMAND-TYPE-CD     PIC X(14) VALUE                            
CVT999*                                        'DEMAND_TYPE_CD'.                
CVT999*    05  CS-DEMAND-TYPE-UNITS  PIC X(17) VALUE                            
CVT999*                                        'DEMAND_TYPE_UNITS'.             
CVT999*    05  CS-ENABLE-PEAK-IND    PIC X(15) VALUE                            
CVT999*                                        'ENABLE_PEAK_IND'.               
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < NO CURSORS IN THIS PROCEDURE >                                     
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-RATE-PLAN-NO        PIC X(03)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-RATE-PLAN-NO                                       
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                TO ABEND-PROGRAM                 
CVT999*       MOVE 'TDRESULT-NO RPC PARM SENT' TO ABEND-FUNCTION                
CVT999*       MOVE 'CICS TRANSACTION'          TO TABLE-1                       
CVT999*       MOVE GWL-RC                      TO WS-ACTIVE-RETURN-CODE         
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE               AS   RETURN_CODE             
CVT000       ,:S-ENERGY-TYPE-CD            AS   ENERGY_TYPE_CD          
CVT000       ,:S-DEMAND-TYPE-CD            AS   DEMAND_TYPE_CD          
REARCH       ,LTRIM(RTRIM(:S-DEMAND-TYPE-UNITS))  AS   DEMAND_TYPE_UNITS       
CVT000       ,:S-ENABLE-PEAK-IND           AS   ENABLE_PEAK_IND         
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE               AS   RETURN_CODE                     
MFA-TR*      ,:S-ENERGY-TYPE-CD            AS   ENERGY_TYPE_CD                  
MFA-TR*      ,:S-DEMAND-TYPE-CD            AS   DEMAND_TYPE_CD                  
MFA-TR*      ,STRIP(:S-DEMAND-TYPE-UNITS)  AS   DEMAND_TYPE_UNITS               
MFA-TR*      ,:S-ENABLE-PEAK-IND           AS   ENABLE_PEAK_IND                 
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO        . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS    THRU 1100-EXIT.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     1. GET THE PASSED UTILITY TYPE AND RATE PLAN NUMBER.       *        
      *                                                                *        
      *     CALLED BY:  1000-PROCESS-INPUT                             *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
           MOVE 'CODE-UTIL-TYPE'                 TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                             
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-RATE-PLAN-NO      TO MAX-LENGTH-PARM.            
           MOVE 'RATE-PLAN-NO'                   TO WS-RCVPRM.          
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-RATE-PLAN-NO,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                             
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1150-CHECK-ERROR.                                              *        
      *     1. CHECK FOR ERROR RECEIVING PARAMETERS.                   *        
      *                                                                *        
      *      CALLED BY: 1100-RECEIVE-PARMS.                            *        
      ******************************************************************        
REARCH*1150-CHECK-ERROR.                                                        
                                                                        
CVT999*    IF GWL-RC NOT = TDS-OK                                               
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
CVT999*       MOVE 'TDRCVPRM - PARAMETER ERROR' TO ABEND-FUNCTION               
CVT999*       MOVE WS-RCVPRM                    TO TABLE-1                      
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE        
CVT999*       PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT                   
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT                   
CVT999*    END-IF.                                                              
                                                                        
REARCH*1150-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT        THRU 2100-EXIT.          
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT.                                             *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
REARCH     MOVE RS-ENERGY-TYPE-CD          TO S-ENERGY-TYPE-CD.         
REARCH     MOVE RS-DEMAND-TYPE-CD          TO S-DEMAND-TYPE-CD.         
REARCH     MOVE RS-DEMAND-TYPE-UNITS       TO S-DEMAND-TYPE-UNITS.      
REARCH     MOVE RS-ENABLE-PEAK-IND         TO S-ENABLE-PEAK-IND.        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     DESCRIBE RESULT SET.                                       *        
      *                                                                *        
      *     CALLED BY:  2100-DESCRIBE-RESULT.                                   
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CS-RETURN-CODE     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CS-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ENERGY-TYPE-CD     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CS-ENERGY-TYPE-CD     TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ENERGY-TYPE-CD,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CS-ENERGY-TYPE-CD,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                               TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-DEMAND-TYPE-CD     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CS-DEMAND-TYPE-CD     TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEMAND-TYPE-CD,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CS-DEMAND-TYPE-CD,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DEMAND-TYPE-UNITS   TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CS-DEMAND-TYPE-UNITS   TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEMAND-TYPE-UNITS,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CS-DEMAND-TYPE-UNITS,                          
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-ENABLE-PEAK-IND     TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CS-ENABLE-PEAK-IND     TO WRKLEN2.                    
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ENABLE-PEAK-IND,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CS-ENABLE-PEAK-IND,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD RESULT SET.                                          *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-CODE-UTIL-TYPE      TO J1-CODE-UTIL-TYPE           
                                            RT-CODE-UTIL-TYPE           
                                            DI-CODE-UTIL-TYPE.          
           MOVE PARM-RATE-PLAN-NO        TO J1-RATE-PLAN-NO             
                                            RT-RATE-PLAN-NO             
                                            DI-RATE-PLAN-NO.            
           MOVE WS-CMPNT-ID-CD           TO J1-CMPNT-ID-CD              
                                            DI-CMPNT-ID-CD.             
           MOVE WS-ACTIVE-CODE           TO RT-CODE-STATUS.             
                                                                        
      *********************************************************                 
      * SELECT THE DEMAND AND ENERGY TIME-OF-USE CODES.       *                 
      * A NOT-FOUND CALL INDICATES THAT THE RATE IS IDR.      *                 
      *********************************************************                 
           PERFORM 2210-SELECT-MAX-VERS-NO THRU 2210-EXIT.              
           PERFORM 7000-SELECT-TOU-PERIODS THRU 7000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE J1-REG-TYPE-CD        TO RS-ENERGY-TYPE-CD           
              MOVE J1-DEM-REG-TYPE-CD    TO RS-DEMAND-TYPE-CD           
              MOVE J1-DEM-UNIT-CD        TO RS-DEMAND-TYPE-UNITS        
           ELSE                                                         
              MOVE SUCCESSFUL-CALL       TO WS-ACTIVE-RETURN-CODE       
              MOVE WS-IDR-TYPE           TO RS-ENERGY-TYPE-CD           
              MOVE WS-IDR-TYPE           TO RS-DEMAND-TYPE-CD           
              MOVE SPACES                TO RS-DEMAND-TYPE-UNITS        
           END-IF.                                                      
                                                                        
      *********************************************************                 
      * BASED ON THE RATE, DETERMINE IF LIFETIME PEAK DEMAND  *                 
      * DETAILS ARE PERTINENT.                                *                 
      *********************************************************                 
           PERFORM 7100-SELECT-PEAK-IND        THRU 7100-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              AND DI-LFTM-PEAK-PCT > 0                                  
              MOVE WS-YES                 TO RS-ENABLE-PEAK-IND         
           ELSE                                                         
              MOVE WS-NO                  TO RS-ENABLE-PEAK-IND         
              MOVE SUCCESSFUL-CALL        TO WS-ACTIVE-RETURN-CODE      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-SELECT-MAX-VERS-NO.                                       *        
      *     SELECTS MAXIMUM VERSION CONTROL NO. FROM CSS_RATE_CERATOR  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2210-SELECT-MAX-VERS-NO.                                         
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
               INTO :WS-MAX-VERS-NO-CNTRL :WS-MAX-VERS-NO-CNTRL-NULL     
               FROM  CSS_RATE_CREATOR                                   
              WHERE  CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                AND  RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                              ABEND-TABLES          
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-TOU-PERIODS.                                       *        
      *     DETERMINE THE ENERGY AND DEMAND TIME-OF-USE PERIODS,       *        
      *     AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.                 *        
      *     A NOT-FOUND SQLCODE INDICATES THAT THE RATE IS IDR         *        
      *     (BECAUSE WE USED A COMPONENT ID CODE OF '10' IN THE WHERE  *        
      *     CLAUSE).                                                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-SELECT-TOU-PERIODS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT A.REG_TYPE_CD,                                     
                     A.DEM_REG_TYPE_CD,                                 
                     A.DEM_UNIT_CD                                      
               INTO  :J1-REG-TYPE-CD,                                   
                     :J1-DEM-REG-TYPE-CD,                               
                     :J1-DEM-UNIT-CD                                    
               FROM  CSS_RATE_COMP_DEF A                                
              WHERE  A.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE          
                AND  A.RATE_PLAN_NO       = :J1-RATE-PLAN-NO            
                AND  A.CMPNT_ID_CD        = :J1-CMPNT-ID-CD             
                AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                              ABEND-TABLES          
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE J1-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
CBSI          MOVE WS-MAX-VERS-NO-CNTRL       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-PEAK-IND.                                          *        
      *     DETERMINE THE LFTM PEAK PERCENTAGE.  IF A RECORD IS NOT    *        
      *     FOUND OR THE PERCENTAGE = 0, THEN THE RATE DOES NOT        *        
      *     HAVE ANY LIFETIME PEAK OR DATE INFORMATION.                *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-SELECT-PEAK-IND.                                            
                                                                        
           EXEC SQL                                                     
              SELECT A.LFTM_PEAK_PCT                                    
                INTO  :DI-LFTM-PEAK-PCT                                 
                FROM  CSS_DEMAND_INSTR A                                
               WHERE  A.CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE         
                 AND  A.RATE_PLAN_NO       = :DI-RATE-PLAN-NO           
                 AND  A.CMPNT_ID_CD        = :DI-CMPNT-ID-CD            
                 AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                              ABEND-TABLES          
              MOVE 'CSS_DEMAND_INSTR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE DI-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE DI-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE DI-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
CBSI          MOVE WS-MAX-VERS-NO-CNTRL       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
