       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02049.                                          
       DATE-WRITTEN.     MAR 17, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
      *                                                                *00100000
      *  TRANID:        S049                                           *00110000
      *  PROGRAM:       S049                                           *00120000
      *  CALLING SP:    PN_S049                                        *00151000
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
      *                                                                *00200000
      *  THIS PROGRAM UPDATES THE ACCOUNT BILLING ADDRESS: (I)NSERTS,  *00210000
      *  (D)ELETES AND (U)PDATES THE ATTENTION LINE NAME, NAME ON BILL *00220000
      *  AS WELL AS FORMATTED AND FREEFORM BILLING ADDRESSES.          *00251000
      *                                                                *00240000
      *  DATA WILL BE MAINTAINED FROM THE FOLLOWING TABLES:            *00250000
      *                                                                *00260000
      *  TABLE                  TABLE ID     DCLGEN                    *00270000
      *  -----                  --------     ------                    *00280000
      *  CSS_ACCOUNT               AT        TBACCT                    *00290000
      *  CSS_ACCT_BILL_NMES        AB        TBATBLNM                  *00510000
      *  CSS_ADDR_FORMATTED        DY        TBADRFMT                  *00310000
      *  CSS_ADDR_FREEFORM         DZ        TBADRFRE                  *00320000
      *  CSS_ADDR_ID_CNTL          I8        TBADDRID                  *00351000
      *  CSS_BILL_ADDR_XREF        AQ        TBBLADRX                  *00340000
      *  CSS_CUSTOMER              CU        TBCUST                    *00350000
      *  CSS_MNT_TRANS_HIST        MN        TBMNHIST                  *00360000
      *  CSS_MT_TRN_HST_DET        MT        TBMNHDT                   *00370000
      *  CSS_NAME                  DQ        TBNAME                    *00380000
      *  CSS_NAME_ACCT_XREF        HT        TBNMACTX                  *00390000
      *  CSS_NAME_ID_CNTL          I7        TBNAMEID                  *00400000
      *  CSS_PREMISE               PR        TBPREM                    *00410000
      *  CSS_USER_PROFILE          PF        TBUSRPRF                  *00420000
      *                                                                *00451000
      ******************************************************************00440000
      *                                                                *00450000
      *                     PROGRAM MODIFICATION LOG                   *00460000
      *                                                                *00470000
      *    DATE    INITIALS   COMMENTS                                 *00480000
      *  --------  --------   -----------------                        *00490000
      *  03/17/95    RKL      CREATED.                                 *00500000
      *  05/24/95    MRB      TPR # 5193 - UPDATE DOES NOT WORK, AND   *00510000
      *                       ADDED TRANSACTION HISTORY JOURNALING.    *00520000
      *  07/12/95    WMG      CHANGED ADDR-PREFIX JOURNALING FIELD     *00551000
      *                       LENGTH TO "3" TO CORRECTLY WRITE ADDRESS *00531000
      *                       CHANGE TO TRANSACTION HISTORY DETAIL     *00531100
      *                       RECORDS                                  *00531200
      *  07/29/95    WMG      MODIFIED IN PART TO FIX TPR #5959:       *00531300
      *                       THE AB-NAME-ID FIELD WAS INITIALIZED TO  *00531400
      *                       ZERO AND SET TO THE CUSTOMER NAME ID     *00531500
      *                       WHEN INSERTING A BILLING ADDRESS.        *00531600
      *                                                                *00531700
      *  09/25/95    PD       ADDED TRANSACTION HISTORY LOGIC FOR      *00531800
      *                       ANY KIND OF CHANGE DONE TO THE PANEL     *00531900
      *  09/29/95    MJL      ADDED DELETE LOGIC AND FIXED UPDATE LOGIC*00532000
      *                       TO UPDATE BILL ADDR XREF TABLE WHICH IS  *00532100
      *                       WAS NOT DOING CORRECTLY                  *00532200
      *  09/04/96    AG       TPR 4158    GET NEW ADDRESS AND NAME ID  *00532300
      *                       FROM COMMON COPYBOOKS                    *00532400
      *                                                                *00532600
TP9650*  04/02/97    CHANDRA  TPR 9650                                 *00532300
TP9650*                       1. IF THE NEW ADDRESS IS ALREADY         *00532400
TP9650*                          AVAILABLE IN ADDR_FORMA TABLE, DO NOT *00532600
TP9650*                          INSERT A NEW ROW ( TO AVOID -811 )    *00532600
TP9650*                       2. MAKE TRANSACTION HISTORY LOG WHENEVER *00532600
TP9650*                          THE ADDRESS IS CHANGED.               *00532600
TP9650*                       3. IF "ALL" IS SELECTED IN PANEL461,     *00532600
TP9650*                          THEN UPDATE ALL THE ACCOUNTS USING THE*00532600
TP9650*                          ADDRESS ID AND LOG TRANSACTION HIST.  *00532600
      *                                                                *00532600
TP9598*  04/02/97    CHANDRA  TPR 9598                                 *00532300
TP9598*                       UNINITIALIZED COMP FIELD WERE GIVING     *00532400
TP9598*                       ASRA, SO ALL THE COMP FIELDS ARE         *00532600
TP9598*                       INITAILIZED WITH VALUE CLAUSE.           *00532600
T11133*  05/13/97    AS       COMMENTED OUT CODE THAT CREATES AN MNT   *00532300
T11133*                       TRANS HIST ROW FOR ZIP CODE TOKEN.       *00532400
T11818*  06/26/97    AS       ADDED ZIP CODE PLUS FOUR IN PARAGRAPH    *00532300
T11818*                       7240-COMPARE-EXACT-MATCH.                *00532400
T12402*  07/30/97    AS       CHANGED DATATYPE OF PARAMETER            *00532300
T12402*                       PARM-FO-STREET-LOCATION-2 TO MATCH       *00532400
T12402*                       DATABASE COLUMN.                         *00532400
T12727*  08/14/97    AS       ADDED LOGIC TO REFORECAST 2ND CREDIT     *00532300
T12727*                       LETTER, COLLECTION AND CREDIT BUREAU     *00532400
T12727*                       DATES FOR FINALED AND WRITTEN OFF ACCTS. *00532400
T12649*  10/08/97    MAD      ADDED LOGIC TO COMPARE EXISTING ADDRESSES*        
T12649*                       USING A CURSOR RATHER THAN A SINGLE      *        
T12649*                       SELECT; WAS FAILING WITH A -811.         *        
T13202*  10/21/97    MAD      ADDED LOGIC TO UPDATE ALL CSS_LANDLORD   *        
T13202*                       ADDRESS IDS AND ADDRESS FORMATS WHEN THE *        
T13202*                       LANDLORD'S BILLING ADDRESS IS MODIFIED   *        
T13202*                       IN ANY MANNER.                           *        
T12829*  01/21/98    AMG      FIXED LOGIC SO THAT CORRECT MAINTENANCE  *        
T12829*                       TRANSACTION ROWS ARE INSERTED INTO       *        
T12829*                       CSS_MT_TRN_HST_DET                       *        
T15277*  03/11/98    FB       CHANGED LENGTH OF FR-ADDRESS-OVERFLOW    *        
T15277*                       FROM 20 TO 35.                           *        
T16679*  06/04/98    RGB      NULL INDICATOR IS ADDED TO FIELD         *        
T16679*                       COLLECTION_DT IN PARA 7630-SELECT-PARA   *        
CBSI  *  07/21/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18896*  01/20/99    FB       ADDED ZIP CODE TOKEN TO EXACT MATCH      *        
T18896*                       CURSOR.  ALSO UNCOMMENTED MAINTENANCE    *        
T18896*                       TRANSACTION HISTORY FOR ZIP CODE TOKEN.  *        
T19462*  03/23/99    FB       SET CODE_PERM_BILL ON CSS_ACCOUNT TO D   *        
T19462*                       IF THE COUNTRY FIELD IS ENTERED.         *        
T19963*  05/18/99    FB       CHANGE SELECT FROM CSS_BILL_ADDR_XREF    *        
T19963*                       TO SELECT DISTINCT 'Y'.                  *        
T19391*  08/05/99    MJG      CHANGED LANDLORD CURSOR TO ONLY UPDATE   *        
T19391*                       LL INFO IF IT HAS THE SAME ADDRESS_ID    *        
T19391*                       AS WELL AS THE SAME CUSTOMER_NO          *        
T20587*  08/05/99    FB       DO NOT PERFORM 5090- FOR 0 ADDRESS IDS.  *        
T20384*  08/25/99    FB       RESET CODE_PERM_BILL TO 'A' WHEN ADDRESS *        
T20384*                       WITH VALUE IN COUNTRY FIELD IS DELETED.  *        
T21091*  11/16/99    FB       USE MATCHED ADDRESS ID ONLY IF IT IS NOT *        
T21091*                       A PREMISE ADDRESS AND CUSTOMER NUMBERS   *        
T21091*                       ARE THE SAME.                            *        
T21093*  12/07/99    FB       CORRECTED DELETE OF BILLING NAME         *        
T21717*  02/28/00    FB       INCLUDE ADDRESS ID IN TRANSACTION HISTORY*        
T21778*  03/03/00    FB       DELETE FROM AQ WHEN FREEFORM DELETED     *        
T20179*  03/03/00    FB       WHEN A BILLING ADDRESS IS DELETED,       *        
T20179*                       DELETE ROWS FROM AQ AND UPDATE AT.       *        
T19391*  03/21/00    FB       SET WS-INS-ADDRESS-ID CORRECTLY WHEN A   *        
T19391*                       FREEFORM BILLING ADDRESS IS UPDATED.     *        
T19391*                       WAS SET TO 0 AND UPDATING LL INCORRECTLY.*        
T22106*  04/19/00    FB       ONLY DELETE FROM AQ AND UPDATE AT FOR    *        
T22106*                       FREEFORM BILLING ADDRESSES.              *        
T22104*  04/19/00    FB       ADD LOCATOR_ID TO SELECT OF CSS_PREMISE  *        
T22104*                       TO USE TABLE INDEX                       *        
T22301*  06/09/00    SK       ADDED STATE, TOWN, AND LOCAL_OFFICE TO   *        
T22301*                       INSERT OF CSS_NAME_ACCT_XREF.            *        
T21931*  06/14/00    FB       DO NOT DELETE FREEFORM ADDRESSES IF THEY *        
T21931*                       EXIST ON CSS_LANDLORD.                   *        
T23501*  02/06/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 7640 TO SUPPORT MULTI-COMPANY.      *        
T25068*  01/29/02    FB       DO NOT DELETE FREEFORM ADDRESSES IF THEY *        
T25068*                       ARE USED ON MULTIPLE ACCOUNTS.  DELETE   *        
T25068*                       FROM BILL ADDRESS XREF REGARDLESS OF     *        
T25068*                       COUNTS.                                  *        
T22945*  01/29/02    FB       POPULATE WS-INS-ADDRESS-ID BEFORE GETTING*        
T22945*                       NEW ADDRESS ID TO MAKE SURE FIELD IS     *        
T22945*                       POPULATED FOR UPDATE TRANSACTIONS.       *        
C26133*  03/05/02    MJ       CREDIT BUREAU DATE SHOULD BE 50 DAYS AFTER        
      *                       COLLECTION AGENCY DATE - NOT THE SAME DATE        
      *                       USE VALUE DAY-ADD-COLL-CB FROM           *        
      *                       CSS_DELINQUENCY TO CALCULATE DATE.       *        
C32615*  05/30/06    FB       ADD DETAIL LINES TO TRANS HISTORY.  IF   *        
C32615*                       ONE ADDRESS CHANGED, DISPLAY 'ONE'.  IF  *        
C32615*                       MULTIPLE, DISPLAY 'ALL'.  ADDED WITH UR  *        
C32615*                       TO DATABASE READS.  REPLACED DISTINCTS   *        
C32615*                       WITH FETCH FIRST 1 ROWS ONLY.            *        
C34809*  09/13/06    FB       CORRECTED TRANSHIST PROCESSING WHEN      *        
C34809*                       SWITCHING FROM FREEFORM TO FORMATTED.    *        
C34867*  09/26/06    FB       DO NOT ALLOW DELETION IF NO NAME PRESENT.*        
REARCH*  06/26/06  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
C30169*  04/03/08    SC       WO RECOVERY PROJECT - REMOVING THE       *        
C30169*                       RE-FORECASTING OF COLLECTION AGENCY AND  *        
C30169*                       CREDIT BUREAU DATES FOR WRITE OFF ACCOUNTS        
C36935*  10/03/08    FB       REFORMAT SEB ADDRESSES TO REMOVE DASHES  *        
C36935*                       AND # SIGNS.                             *        
C37666*  10/03/08    FB       REMOVE DELETES FROM ADDRESS TABLES.      *        
C37666*                       ADDRESSES WILL BE DELETED BY CLEANUP     *        
C37666*                       PROCESS.                                 *        
C37649*  10/20/08   CVNS      NAME & ADDRESS FORMATTED CHANGES         *        
A35665*  04/27/09    FB       DO NOT DELETE FROM CSS_BILL_ADDR_XREF    *        
A35665*                       WHEN DELETING NAME ON BILL OR HEADER     *        
A35665*                       NAME.  UPDATE WITH CUST NAME INSTEAD.    *        
A35665*  09/17/09    FB       IF BOTH BILL ADDRESS AND BILL HEADER     *        
A35665*                       NAME ARE UPDATED, USE CORRECT ADDRESS    *        
A35665*                       WHEN UPDATING CSS_BILL_ADDR_XREF.        *        
A37666*  06/24/10    FB       NAMES WILL BE DELETED BY CLEANUP PROCESS.*        
A02637*  09/30/10    FB       REMOVE ~ FROM ADDRESS FIELDS.            *        
A03961*  02/07/12    FB       REFORMAT SEB ADDRESSES TO REMOVE #       *        
A03018*  02/07/12    FB       CORRECT -530 WHEN BILLING NAME UPDATED   *        
A03018*                       AND BILL ADDRESS ADDED                   *        
P00547*  03/01/12    FB       DO NOT SET EXTRA POSTAGE FLAG IF COUNTRY *        
P00547*                       IS UNITED STATES (IAT PROJECT)           *        
P00594*  04/08/13    FB       TWO NEW FIELDS ON CSS_NAME_ACCT_XREF     *        
P00547*  05/08/13    DB18339  ADDED WQ IF COUNTRY IS NOT UNITED STATES *        
ACT223*  07/10/16    MC95456  REPLACE CSR00028 WITH CSR04675           *        
      ******************************************************************00532700
      ******************************************************************00532800
      *                                                                *00532900
      *                -- BASIC SEQUENCE STRUCTURE --                  *00535100
      *                                                                *00533100
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00533200
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00533300
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00534000
      *  5100 - 4999  NOT USED                                         *00535000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00536000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00537000
      *  7000 - 7999  INPUT MODULES                                    *00538000
      *  8000 - 8999  OUTPUT MODULES                                   *00539000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00540000
      *                                                                *00550000
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02049'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02049 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00751000
              INCLUDE TBMODEL                                           00740000
           END-EXEC.                                                    00750000
                                                                        
      *----< CSS_ACCOUNT >                                              00770000
           EXEC SQL                                                     00780000
              INCLUDE TBACCT                                            00790000
           END-EXEC.                                                    00800000
                                                                        
      *----< CSS_ACCT_BILL_NMES >                                       00820000
           EXEC SQL                                                     00851000
              INCLUDE TBATBLNM                                          00840000
           END-EXEC.                                                    00850000
                                                                        
      *----< CSS_ADDR_FORMATTED >                                       00870000
           EXEC SQL                                                     00880000
              INCLUDE TBADRFMT                                          00890000
           END-EXEC.                                                    00900000
                                                                        
      *----< CSS_ADDR_FREEFORM >                                        00920000
           EXEC SQL                                                     00951000
              INCLUDE TBADRFRE                                          00940000
           END-EXEC.                                                    00950000
                                                                        
      *----< CSS_ADDR_ID_CNTL >                                         00970000
           EXEC SQL                                                     00980000
              INCLUDE TBADDRID                                          00990000
           END-EXEC.                                                    01000000
                                                                        
      *----< CSS_BILL_ADDR_XREF >                                       01020000
           EXEC SQL                                                     01051000
              INCLUDE TBBLADRX                                          01040000
           END-EXEC.                                                    01050000
                                                                        
      *----< CSS_CUSTOMER >                                             01070000
           EXEC SQL                                                     01080000
              INCLUDE TBCUST                                            01090000
           END-EXEC.                                                    01100000
                                                                        
      *---< CSS_MNT_TRANS_HIST >                                        01120000
           EXEC SQL                                                     01151000
              INCLUDE TBMNHIST                                          01140000
           END-EXEC.                                                    01150000
                                                                        
      *---< CSS_MT_TRN_HST_DET >                                        01170000
           EXEC SQL                                                     01180000
              INCLUDE TBMNHDT                                           01190000
           END-EXEC.                                                    01200000
                                                                        
      *---< CSS_NAME_ID_CNTL >                                          01220000
           EXEC SQL                                                     01251000
              INCLUDE TBNAMEID                                          01240000
           END-EXEC.                                                    01250000
                                                                        
      *---< CSS_NAME >                                                  01270000
           EXEC SQL                                                     01280000
              INCLUDE TBNAME                                            01290000
           END-EXEC.                                                    01510000
                                                                        
      *----< CSS_NAME_ACCT_XREF >                                       01320000
           EXEC SQL                                                     01351000
              INCLUDE TBNMACTX                                          01340000
           END-EXEC.                                                    01350000
                                                                        
      *---< CSS_PREMISE >                                               01370000
           EXEC SQL                                                     01380000
              INCLUDE TBPREM                                            01390000
           END-EXEC.                                                    01400000
                                                                        
      *---< CSS_USER_PROFILE >                                          01420000
           EXEC SQL                                                     01451000
              INCLUDE TBUSRPRF                                          01440000
           END-EXEC.                                                    01450000
                                                                        
T12727*---< CSS_HOLIDAY >                                               01420000
T12727     EXEC SQL                                                     01451000
T12727       INCLUDE TBHLDAY                                            01440000
T12727     END-EXEC.                                                    01450000
                                                                        
T13202*---< CSS_LANDLORD >                                              01420000
T13202     EXEC SQL                                                     01451000
T13202       INCLUDE TBLNDLRD                                           01440000
T13202     END-EXEC.                                                    01450000
                                                                        
T22301*---< CSS_ZIP_CODE >                                                      
T22301     EXEC SQL                                                             
T22301       INCLUDE TBZIPCD                                                    
T22301     END-EXEC.                                                            
                                                                        
T36935*---< CSS_DELINQUENCY >                                                   
T36935     EXEC SQL                                                             
T36935       INCLUDE TBDELQ                                                     
T36935     END-EXEC.                                                            
                                                                        
P00547*---< CSS_CATEGORY >                                                      
P00547     EXEC SQL                                                             
P00547       INCLUDE TBCAT                                                      
P00547     END-EXEC.                                                            
                                                                        
      ******************************************************************01470000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01480000
      ******************************************************************01490000
                                                                        
           COPY CCA00001.                                               01570000
C36935     COPY CWS00011.                                               01570000
REARCH     EXEC SQL                                                             
REARCH       INCLUDE CWSX0010                                                   
REARCH     END-EXEC.                                                            
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >           01600000
           COPY CWS00027.                                               01610000
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                      01620000
           COPY CWS00303.                                               01651000
                                                                        
*T4158     EXEC SQL                                                     01632000
*T4158        INCLUDE CWS00071                                          01635100
*T4158     END-EXEC.                                                    01634000
                                                                        
*T4158     EXEC SQL                                                     01636000
*T4158        INCLUDE CWS0090A                                          01637000
*T4158     END-EXEC.                                                    01638000
                                                                        
*T4158     EXEC SQL                                                     01639100
*T4158        INCLUDE CWS0091A                                          01639200
*T4158     END-EXEC.                                                    01639300
                                                                        
                                                                        
      ******************************************************************01650000
      *    WORK AREAS                                                  *01660000
      ******************************************************************01670000
                                                                        
REARCH 01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02049'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02049_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9)   COMP VALUE 0.      
           05  WRKLEN1                   PIC S9(9)   COMP VALUE 0.      
           05  WRKLEN2                   PIC S9(9)   COMP VALUE 0.      
           05  WRK-DONE-STATUS           PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
T12727     05  WS-B                      PIC X(01)   VALUE 'B'.         
T12727     05  WS-S                      PIC X(01)   VALUE 'S'.         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
           05  RS-ADDRESS-ID             PIC X(13)   VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
REARCH     05  S-ADDRESS-ID              PIC X(13)   VALUE SPACES.      
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-ACCOUNT-NO-D           PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
TP9650     05  WS-PARM-ACCOUNT-NO-D      PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-PREMISE-NO-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-PREMISE-NO-S           PIC X(13)   VALUE SPACES.      
           05  WS-CUSTOMER-NO-I          PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-CUSTOMER-NO-S          PIC X(13)   VALUE SPACES.      
           05  WS-NAME-ID                PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-NAME-ID-I              PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-NAME-ID-S              PIC X(13)   VALUE SPACES.      
           05  WS-INS-NAME-ID            PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-MATCH-ADDRESS-ID       PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-INS-ADDRESS-ID         PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-ADDRESS-ID-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-ADDRESS-ID-I-NEW       PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
T19391     05  WS-LL-ADDR-ID             PIC S9(13)V USAGE COMP-3       
T19391                                               VALUE ZERO.        
           05  WS-ADDRESS-ID-S           PIC X(13)   VALUE SPACES.      
           05  WS-TRANS-HIST-SEQ-NO      PIC X(26)   VALUE SPACES.      
           05  WS-TRAN-APPL-NO           PIC S9(4)   COMP VALUE 1.      
           05  WS-DATE-TRANS             PIC X(10)   VALUE SPACES.      
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACES.      
           05  COUNT-ADDR                PIC S9(04)  USAGE COMP         
                                                     VALUE ZERO.        
           05  COUNT-NAME                PIC S9(04)  USAGE COMP         
                                                     VALUE ZERO.        
T12727     05  WS-DAY-COLLECTION         PIC X(20)  VALUE               
T12727                                   'DAY-COLLECTION      '.        
C26133     05  WS-DAY-ADD-COLL-CB        PIC X(20)  VALUE               
C26133                                   'DAY-ADD-COLL-CB     '.        
T12727     05  WS-HOLIDAY-EXISTS         PIC X(01)  VALUE 'N'.          
T12727     05  WS-SATURDAY               PIC 9(01)  VALUE 6.            
T12727     05  WS-SUNDAY                 PIC 9(01)  VALUE 0.            
T12727     05  WS-HOLD-DATE              PIC X(10)  VALUE SPACES.       
T12727     05  WS-DELINQ-CD              PIC X(20)  VALUE SPACES.       
T12727     05  WS-DAY-INDX               PIC S9(04) COMP   VALUE 1.     
T12727     05  WS-DELINQ-LIMIT-NULL      PIC S9(04) COMP   VALUE ZERO.  
T12727     05  WS-SECOND-CR-LTR-NULL     PIC S9(04) COMP   VALUE ZERO.  
T16679     05  WS-COLLECTION-DT-NULL     PIC S9(04) COMP   VALUE ZERO.  
T12727     05  WS-DAY                    PIC S9(04) COMP   VALUE ZERO.  
T12727     05  WS-DELINQ-LIMIT           PIC S9(05) COMP-3 VALUE 0.     
T20384     05  WS-CODE-PERM-BILL         PIC X VALUE ' '.               
T22301     05  WS-STATE                  PIC X(02)   VALUE SPACES.      
T22301     05  WS-TOWN                   PIC X(26)   VALUE SPACES.      
T22301     05  WS-ZIP-CODE               PIC X(05)   VALUE SPACES.      
T22301     05  WS-ZIP-CODE-TOKEN         PIC X(01)   VALUE SPACES.      
T21931     05  WS-LANDLORD-COUNT         PIC S9(04)  COMP VALUE 0.      
T25068     05  WS-FREEFORM-COUNT         PIC S9(04)  COMP VALUE 0.      
C37298     05  WS-AQ-NAME-ID             PIC S9(13)V COMP-3 VALUE 0.    
C37298     05  WS-AQ-COMPANY-NO          PIC X(02)   VALUE SPACES.      
C37298     05  WS-AQ-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.    
C37298     05  WS-AQ-ADDRESS-ID          PIC S9(13)V COMP-3 VALUE 0.    
C37298     05  WS-AQ-ROW-DELETED         PIC X(01) VALUE 'N'.           
C36935     05  WS-DATABASE               PIC 9(01) VALUE 0.             
C36935         88 CSR-DATABASE                     VALUE 1.             
C36935         88 SEB-DATABASE                     VALUE 2.             
C36935     05  WS-COUNT-POUND-SIGN       PIC 9(05) VALUE 0.             
C36935     05  WS-ADDR-FIXED-FL          PIC X(01) VALUE 'N'.           
C36935     05  WS-COUNT-APT              PIC 9(05) VALUE 0.             
C36935     05  WS-COUNT-LOT              PIC 9(05) VALUE 0.             
C36935     05  WS-COUNT-UNIT             PIC 9(05) VALUE 0.             
C36935     05  WS-COUNT-SUITE            PIC 9(05) VALUE 0.             
C36935     05  WS-COUNT-BLDG             PIC 9(05) VALUE 0.             
C36935     05  WS-COUNT-STE              PIC 9(05) VALUE 0.             
C36935     05  WS-INPUT-ADDR-STREET      PIC X(55) VALUE SPACES.        
C36935     05  WS-OUTPUT-ADDR-STREET     PIC X(55) VALUE SPACES.        
C36935     05  WS-INPUT-ADDR-OVERFLOW    PIC X(35) VALUE SPACES.        
C36935     05  WS-OUTPUT-ADDR-OVERFLOW   PIC X(35) VALUE SPACES.        
C36935     05  WS-SUBI                   PIC S9(4) COMP VALUE 0.        
C36935     05  WS-SUBO                   PIC S9(4) COMP VALUE 0.        
C36935     05  WS-FO-STREET-LOCATION-2   PIC X(11) VALUE SPACES.        
P00547     05  WS-IAT-CAT-FOUND          PIC X(01) VALUE 'N'.           
P00547     05  WS-IAT-MESSAGE.                                          
P00547         10  F                           PIC X(51) VALUE          
P00547        'VERIFY OR UPDATE THE INTERNATIONAL ADDRESS ENTERED.'.    
                                                                        
       01  MISC-HOLD-FIELDS.                                            
           05  WS-NAME-TYPE              PIC X(02)   VALUE SPACES.      
           05  WS-NULL-IND               PIC S9(04)  COMP VALUE 0.      
           05  WS-NAME-FORMAT            PIC X(01)   VALUE SPACES.      
           05  WS-FIRST-NAME             PIC X(15)   VALUE SPACES.      
           05  WS-MIDDLE-NAME            PIC X(15)   VALUE SPACES.      
C37649*    05  WS-LAST-NAME              PIC X(20)   VALUE SPACES.      02890000
C37649     05  WS-LAST-NAME              PIC X(40)   VALUE SPACES.      
           05  WS-TITLE-PREFIX           PIC X(09)   VALUE SPACES.      
           05  WS-TITLE-SUFFIX-1         PIC X(03)   VALUE SPACES.      
           05  WS-TITLE-SUFFIX-2         PIC X(03)   VALUE SPACES.      
C37649*    05  WS-FULL-NAME              PIC X(50)   VALUE SPACES.      02951000
C37649     05  WS-FULL-NAME              PIC X(70)   VALUE SPACES.      
           05  HOLD-FIRST-NAME           PIC X(15)   VALUE SPACES.      
           05  HOLD-FULL-NAME            PIC X(50)   VALUE SPACES.      
C37649*    05  HOLD-LAST-NAME            PIC X(20)   VALUE SPACES.      02960000
C37649     05  HOLD-LAST-NAME            PIC X(40)   VALUE SPACES.      
           05  HOLD-MIDDLE-NAME          PIC X(15)   VALUE SPACES.      
           05  HOLD-NAME-FORMAT          PIC X(01)   VALUE SPACES.      
           05  HOLD-NAME-ID              PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  HOLD-NAME-TYPE            PIC X(02)   VALUE SPACES.      
           05  HOLD-TITLE-PREFIX         PIC X(09)   VALUE SPACES.      
           05  HOLD-TITLE-SUFFIX-1       PIC X(03)   VALUE SPACES.      
           05  HOLD-TITLE-SUFFIX-2       PIC X(03)   VALUE SPACES.      
TP9650     05  WS-UPDATED-ADDR-ID        PIC S9999999999999V            
TP9650                                               USAGE COMP-3       
TP9650                                               VALUE ZERO.        
T20179     05  WS-DELETE-ADDR-ID         PIC S9999999999999V            
T20179                                               USAGE COMP-3       
T20179                                               VALUE ZERO.        
C32615     05  WS-WRITE-TRANSHIST        PIC X(01)   VALUE 'N'.         
C32615     05  WS-ADDRESS-INSERT         PIC X(01)   VALUE 'N'.         
C34809     05  WS-HOLD-SEQ-NO            PIC X(26)   VALUE SPACES.      
C32615     05  WS-HOLD-APPL-NO           PIC S9(4)   COMP VALUE 0.      
C32615     05  WS-COUNT-ACCOUNTS         PIC S9(4)   COMP VALUE 0.      
C34809     05  WS-FREEFORM-TO-FORMAT     PIC X(01)   VALUE 'N'.         
                                                                        
       01  MISC-FLAGS.                                                  
           05  ADDR-FORM-EXISTS-FLAG     PIC X(01)   VALUE 'N'.         
               88 ADDR-FORM-EXISTS                   VALUE 'Y'.         
           05  ADDR-FREE-EXISTS-FLAG      PIC X(01)  VALUE 'N'.         
               88 ADDR-FREE-EXISTS                   VALUE 'Y'.         
           05  ACCT-BILL-HDR-EXISTS-FLAG  PIC X(01)  VALUE 'N'.         
               88 ACCT-BILL-HDR-EXISTS               VALUE 'Y'.         
           05  ACCT-BILL-NME-EXISTS-FLAG  PIC X(01)  VALUE 'N'.         
               88 ACCT-BILL-NME-EXISTS               VALUE 'Y'.         
           05  NAME-ACCT-HDR-EXISTS-FLAG PIC X(01)   VALUE 'N'.         
               88 NAME-ACCT-HDR-EXISTS               VALUE 'Y'.         
           05  BILL-ADDR-XREF-EXISTS-FLAG PIC X(01)  VALUE 'N'.         
               88 BILL-ADDR-XREF-EXISTS              VALUE 'Y'.         
           05  WS-MATCH-FOUND-FLAG        PIC X(01)  VALUE 'N'.         
               88 WS-MATCH-FOUND                     VALUE 'Y'.         
T13202     05  WS-RPC-ACTION              PIC X(01)  VALUE 'N'.         
T13202         88 BILL-ADDR-DELETE                   VALUE 'D'.         
T13202         88 BILL-ADDR-ADD                      VALUE 'A'.         
T21091     05  WS-PREMISE-FOUND-FLAG      PIC X(01)  VALUE 'N'.         
T21091         88 WS-PREMISE-FOUND                   VALUE 'Y'.         
T21091         88 WS-PREMISE-NOT-FOUND               VALUE 'N'.         
T21091     05  WS-XREF-FOUND-FLAG         PIC X(01)  VALUE 'N'.         
T21091         88 WS-XREF-FOUND                      VALUE 'Y'.         
T21091         88 WS-XREF-NOT-FOUND                  VALUE 'N'.         
                                                                        
       01  WS-NEW-ADDR-COMP.                                            
           05  WS-NEW-ADDR-ID-COMP         PIC S9(13) COMP-3            
                                                     VALUE ZERO.        
           05  WS-NEW-ADDR-IDENT           PIC 9(13).                   
           05  FILLER REDEFINES WS-NEW-ADDR-IDENT.                      
               10  WS-NEW-ADDR-CHECK-DIGIT PIC 9.                       
               10  WS-NEW-ADDR-ID          PIC 9(12).                   
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
P00547******************************************************************        
ACT223* CSR04675 - INSERT A WORK QUEUE                                 *        
P00547******************************************************************        
P00547                                                                  
ACT223 01  CSR04675-CALL-DATA.                                          
ACT223     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT223     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT223     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT223     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT223     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT223     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT223     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT223     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT223     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT223     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT223     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT223     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT223     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT223     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT223     05  COMMENTS-4675.                                           
ACT223        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT223        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT223     05  FREE-FORM-DATA-4675.                                     
ACT223        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT223        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT223     05  CREATED-BY-4675            PIC X(16) VALUE SPACES.       
P00547                                                                  
ACT223 01  CSR04675-RETURN-DATA.                                        
ACT223     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT223     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
P00547*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT223            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
         
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-USER-ID              PIC X(07)   VALUE SPACES.           
REARCH 01 PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.           
REARCH 01 PARM-BILL-ADDR-ENTERED    PIC X       VALUE SPACES.           
REARCH 01 PARM-BILL-NME-ENTERED     PIC X       VALUE SPACES.           
REARCH 01 PARM-BILL-HDR-ENTERED     PIC X       VALUE SPACES.           
REARCH 01 PARM-ADDRESS-FORMAT       PIC X(01)   VALUE SPACES.           
REARCH 01 PARM-AT-NAME-ID           PIC X(13)   VALUE SPACES.           
REARCH 01 PARM-AT-NAME-FORMAT       PIC X(01)   VALUE SPACES.           
REARCH 01 PARM-AT-NAME-TYPE         PIC X(02)   VALUE SPACES.           
REARCH 01 PARM-AT-FIRST-NAME        PIC X(15)   VALUE SPACES.           
REARCH 01 PARM-AT-MIDDLE-NAME       PIC X(15)   VALUE SPACES.           
REARCH*01 PARM-AT-LAST-NAME         PIC X(20)   VALUE SPACES.           01970000
C37649 01 PARM-AT-LAST-NAME         PIC X(40)   VALUE SPACES.           
REARCH 01 PARM-AT-TITLE-PREFIX      PIC X(09)   VALUE SPACES.           
REARCH 01 PARM-AT-TITLE-SUFFIX-1    PIC X(03)   VALUE SPACES.           
REARCH 01 PARM-AT-TITLE-SUFFIX-2    PIC X(03)   VALUE SPACES.           
REARCH*01 PARM-AT-FULL-NAME         PIC X(50)   VALUE SPACES.           02010000
C37649 01 PARM-AT-FULL-NAME         PIC X(70)   VALUE SPACES.           
REARCH 01 PARM-NB-NAME-ID           PIC X(13)   VALUE SPACES.           
REARCH 01 PARM-NB-NAME-FORMAT       PIC X(01)   VALUE SPACES.           
REARCH 01 PARM-NB-NAME-TYPE         PIC X(02)   VALUE SPACES.           
REARCH 01 PARM-NB-FIRST-NAME        PIC X(15)   VALUE SPACES.           
REARCH 01 PARM-NB-MIDDLE-NAME       PIC X(15)   VALUE SPACES.           
REARCH*01 PARM-NB-LAST-NAME         PIC X(20)   VALUE SPACES.           02070000
C37649 01 PARM-NB-LAST-NAME         PIC X(40)   VALUE SPACES.           
REARCH 01 PARM-NB-TITLE-PREFIX      PIC X(09)   VALUE SPACES.           
REARCH 01 PARM-NB-TITLE-SUFFIX-1    PIC X(03)   VALUE SPACES.           
REARCH 01 PARM-NB-TITLE-SUFFIX-2    PIC X(03)   VALUE SPACES.           
REARCH*01 PARM-NB-FULL-NAME         PIC X(50)   VALUE SPACES.           02110000
C37649 01 PARM-NB-FULL-NAME         PIC X(70)   VALUE SPACES.           
REARCH 01 PARM-ADDRESS-ID           PIC X(13)   VALUE SPACES.           
REARCH 01 PARM-FO-UPDATE-FLG        PIC X(03)   VALUE SPACES.           
REARCH*01 PARM-FO-HOUSE-NO          PIC X(05)   VALUE SPACES.           02140000
C37649 01 PARM-FO-HOUSE-NO          PIC X(15)   VALUE SPACES.           
REARCH 01 PARM-FO-ADDR-PREFIX-1     PIC X(03)   VALUE SPACES.           
REARCH 01 PARM-FO-ADDR-PREFIX-2     PIC X(02)   VALUE SPACES.           
REARCH*01 PARM-FO-STREET-NAME       PIC X(16)   VALUE SPACES.           02170000
C37649 01 PARM-FO-STREET-NAME       PIC X(30)   VALUE SPACES.           
REARCH 01 PARM-FO-STREET-SUFFIX     PIC X(04)   VALUE SPACES.           
REARCH 01 PARM-FO-STREET-LOCATION-1 PIC X(04)   VALUE SPACES.           
REARCH*01 PARM-FO-STREET-LOCATION-2 PIC X(06)   VALUE SPACES.           02200000
C37649 01 PARM-FO-STREET-LOCATION-2 PIC X(11)   VALUE SPACES.           
REARCH 01 PARM-FO-ADDRESS-OVERFLOW  PIC X(26)   VALUE SPACES.           
REARCH 01 PARM-FO-ZIP-CODE          PIC X(05)   VALUE SPACES.           
REARCH 01 PARM-FO-ZIP-CODE-PL-FOUR  PIC X(04)   VALUE SPACES.           
REARCH 01 PARM-FO-ZIP-CODE-TOKEN    PIC X(01)   VALUE SPACES.           
REARCH*01 PARM-FR-ADDR-STREET       PIC X(35)   VALUE SPACES.           02250000
C37649 01 PARM-FR-ADDR-STREET       PIC X(55)   VALUE SPACES.           
REARCH 01 PARM-FR-ADDRESS-OVERFLOW  PIC X(35)   VALUE SPACES.           
REARCH*01 PARM-FR-CITY-STATE        PIC X(20)   VALUE SPACES.           02270000
C37649 01 PARM-FR-CITY-STATE        PIC X(30)   VALUE SPACES.           
REARCH 01 PARM-FR-ZIP-CODE          PIC X(09)   VALUE SPACES.           
REARCH 01 PARM-FR-COUNTRY           PIC X(35)   VALUE SPACES.           
REARCH 01 PARM-FO-ADDR-SUFFIX       PIC X(02)   VALUE SPACES.           
REARCH 01 PARM-COMMENTS-TEXT        PIC X(210)  VALUE SPACES.           
REARCH 01 PARM-COMMENTS-LEN         PIC S9(4)   COMP SYNC VALUE +0.     
                                                                        
           EXEC SQL DECLARE OTHER-ACCT-CSR CURSOR FOR                   
               SELECT  AQ.ACCOUNT_NO                                    
               FROM    CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED),             
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
               WHERE   AQ.ADDRESS_ID = :AQ-ADDRESS-ID                   
                 AND   AQ.ACCOUNT_NO = AT.ACCOUNT_NO                    
                 AND   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                 
C32615         FOR READ ONLY                                           
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE OTHER-ACCT-CSR CURSOR FOR                   03651001
MFA-TR*        SELECT  AQ.ACCOUNT_NO                                    03651101
MFA-TR*        FROM    CSS_BILL_ADDR_XREF AQ,                           03651301
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*        WHERE   AQ.ADDRESS_ID = :AQ-ADDRESS-ID                   03651401
MFA-TR*          AND   AQ.ACCOUNT_NO = AT.ACCOUNT_NO                            
MFA-TR*          AND   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                         
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    03652301
                                                                        
T12649     EXEC SQL DECLARE EXACT-MATCH-CSR CURSOR FOR                  
T12649        SELECT   'Y',                                             
T12649                 ADDRESS_ID                                       
T12649        FROM     CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                 
T12649        WHERE    HOUSE_NO            = :PARM-FO-HOUSE-NO          
T12649          AND    ADDR_PREFIX_1       = :PARM-FO-ADDR-PREFIX-1     
T12649          AND    ADDR_PREFIX_2       = :PARM-FO-ADDR-PREFIX-2     
T12649          AND    STREET_NAME         = :PARM-FO-STREET-NAME       
T12649          AND    STREET_SUFFIX       = :PARM-FO-STREET-SUFFIX     
T12649          AND    STREET_LOCATION_1   = :PARM-FO-STREET-LOCATION-1 
T12649          AND    STREET_LOCATION_2   = :PARM-FO-STREET-LOCATION-2 
T12649          AND    ADDRESS_OVERFLOW    = :PARM-FO-ADDRESS-OVERFLOW  
T12649          AND    ZIP_CODE            = :PARM-FO-ZIP-CODE          
T12649          AND    ZIP_CODE_PLUS_FOUR  = :PARM-FO-ZIP-CODE-PL-FOUR  
T18896          AND    ZIP_CODE_TOKEN      = :PARM-FO-ZIP-CODE-TOKEN    
T12649          AND    ADDR_USAGE_CD       = 'F'                        
T12649          AND    ADDR_SUFFIX         = :PARM-FO-ADDR-SUFFIX
            OPTION(FAST 1)
            FOR READ ONLY
                                                              
T12649     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE EXACT-MATCH-CSR CURSOR FOR                  23910000
MFA-TR*       SELECT   'Y',                                             23920000
MFA-TR*                ADDRESS_ID                                       23951000
MFA-TR*       FROM     CSS_ADDR_FORMATTED                               23960000
MFA-TR*       WHERE    HOUSE_NO            = :PARM-FO-HOUSE-NO          23970000
MFA-TR*         AND    ADDR_PREFIX_1       = :PARM-FO-ADDR-PREFIX-1     23980000
MFA-TR*         AND    ADDR_PREFIX_2       = :PARM-FO-ADDR-PREFIX-2     23990000
MFA-TR*         AND    STREET_NAME         = :PARM-FO-STREET-NAME       24000000
MFA-TR*         AND    STREET_SUFFIX       = :PARM-FO-STREET-SUFFIX     24010000
MFA-TR*         AND    STREET_LOCATION_1   = :PARM-FO-STREET-LOCATION-1 24020000
MFA-TR*         AND    STREET_LOCATION_2   = :PARM-FO-STREET-LOCATION-2 24051000
MFA-TR*         AND    ADDRESS_OVERFLOW    = :PARM-FO-ADDRESS-OVERFLOW  24040000
MFA-TR*         AND    ZIP_CODE            = :PARM-FO-ZIP-CODE          24050000
MFA-TR*         AND    ZIP_CODE_PLUS_FOUR  = :PARM-FO-ZIP-CODE-PL-FOUR  24050000
MFA-TR*         AND    ZIP_CODE_TOKEN      = :PARM-FO-ZIP-CODE-TOKEN    24050000
MFA-TR*         AND    ADDR_USAGE_CD       = 'F'                        24060000
MFA-TR*         AND    ADDR_SUFFIX         = :PARM-FO-ADDR-SUFFIX       24070000
MFA-TR*       OPTIMIZE FOR 1 ROW                                                
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    24080000
                                                                        
T13202     EXEC SQL DECLARE LANDLORD-CSR CURSOR FOR                     
T13202         SELECT  ADDRESS_ID,                                      
T13202                 ADDRESS_FORMAT                                   
T13202         FROM    CSS_LANDLORD                                     
T13202         WHERE   CUSTOMER_NO = :SI-CUSTOMER-NO                    
T19391           AND   ADDRESS_ID  = :WS-LL-ADDR-ID                     
T13202           FOR UPDATE OF ADDRESS_ID, ADDRESS_FORMAT               
T13202     END-EXEC.                                                    
                                                                        
REARCH PROCEDURE DIVISION USING PARM-USER-ID                            
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-BILL-ADDR-ENTERED                  
REARCH                          PARM-BILL-NME-ENTERED                   
REARCH                          PARM-BILL-HDR-ENTERED                   
REARCH                          PARM-ADDRESS-FORMAT                     
REARCH                          PARM-AT-NAME-ID                         
REARCH                          PARM-AT-NAME-FORMAT                     
REARCH                          PARM-AT-NAME-TYPE                       
REARCH                          PARM-AT-FIRST-NAME                      
REARCH                          PARM-AT-MIDDLE-NAME                     
REARCH                          PARM-AT-LAST-NAME                       
REARCH                          PARM-AT-TITLE-PREFIX                    
REARCH                          PARM-AT-TITLE-SUFFIX-1                  
REARCH                          PARM-AT-TITLE-SUFFIX-2                  
REARCH                          PARM-AT-FULL-NAME                       
REARCH                          PARM-NB-NAME-ID                         
REARCH                          PARM-NB-NAME-FORMAT                     
REARCH                          PARM-NB-NAME-TYPE                       
REARCH                          PARM-NB-FIRST-NAME                      
REARCH                          PARM-NB-MIDDLE-NAME                     
REARCH                          PARM-NB-LAST-NAME                       
REARCH                          PARM-NB-TITLE-PREFIX                    
REARCH                          PARM-NB-TITLE-SUFFIX-1                  
REARCH                          PARM-NB-TITLE-SUFFIX-2                  
REARCH                          PARM-NB-FULL-NAME                       
REARCH                          PARM-ADDRESS-ID                         
REARCH                          PARM-FO-UPDATE-FLG                      
REARCH                          PARM-FO-HOUSE-NO                        
REARCH                          PARM-FO-ADDR-PREFIX-1                   
REARCH                          PARM-FO-ADDR-PREFIX-2                   
REARCH                          PARM-FO-STREET-NAME                     
REARCH                          PARM-FO-STREET-SUFFIX                   
REARCH                          PARM-FO-STREET-LOCATION-1               
REARCH                          PARM-FO-STREET-LOCATION-2               
REARCH                          PARM-FO-ADDRESS-OVERFLOW                
REARCH                          PARM-FO-ZIP-CODE                        
REARCH                          PARM-FO-ZIP-CODE-PL-FOUR                
REARCH                          PARM-FO-ZIP-CODE-TOKEN                  
REARCH                          PARM-FR-ADDR-STREET                     
REARCH                          PARM-FR-ADDRESS-OVERFLOW                
REARCH                          PARM-FR-CITY-STATE                      
REARCH                          PARM-FR-ZIP-CODE                        
REARCH                          PARM-FR-COUNTRY                         
REARCH                          PARM-FO-ADDR-SUFFIX                     
REARCH                          PARM-COMMENTS-TEXT                      
REARCH                          PARM-COMMENTS-LEN.                      
                                                                        
      ******************************************************************03690000
      * 0000-MAINLINE                                                  *03700000
      *     CALLS 0100-INITIALIZE                                      *03710000
      *           1000-PROCESS-INPUT                                   *03720000
      *           2000-PROCESS-OUTPUT                                  *03751000
      *           9999-END-PROGRAM                                     *03740000
      *                                                                *03750000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03760000
      ******************************************************************03770000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03890000
      * 0100-INITIALIZE                                                *03900000
      *     CALLS 9000-SEND-ERROR-RESULT                               *03910000
      *           9900-SQL-ERROR-ROUTINE                               *03920000
      *                                                                *03951000
      *     CALLED FROM 0000-MAINLINE                                  *03940000
      *                                                                *03950000
      *     1. RESET DB2 ERROR HANDLERS                                *03960000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03970000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03980000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03990000
      *                                                                *04000000
      ******************************************************************04010000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH              :S-RETURN-CODE          AS RETURN_CODE              
REARCH             ,LTRIM(RTRIM(:S-ADDRESS-ID))    AS ADDRESS_ID               
REARCH         FROM                                                     
REARCH              CIS.SYSDUMMY1                                    
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04250000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             :S-RETURN-CODE          AS RETURN_CODE                      
MFA-TR*            ,STRIP(:S-ADDRESS-ID)    AS ADDRESS_ID                       
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04290000
      * 1000-PROCESS-INPUT                                             *04510000
      *     CALLS 1100-RECEIVE-PARMS                                   *04310000
      *                                                                *04320000
      *     CALLED FROM 0000-MAINLINE                                  *04351000
      *                                                                *04340000
      *     1. RECEIVE PARMS.                                          *04350000
      ******************************************************************04360000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-I.           
           MOVE WS-ACCOUNT-NO-I           TO WS-ACCOUNT-NO-D.           
TP9650     MOVE WS-ACCOUNT-NO-I           TO WS-PARM-ACCOUNT-NO-D.      
                                                                        
A02637     INSPECT PARM-FO-HOUSE-NO REPLACING ALL '~' BY '-'.           
A02637     INSPECT PARM-FO-STREET-NAME REPLACING ALL '~' BY '-'.        
A02637     INSPECT PARM-FO-STREET-LOCATION-2 REPLACING ALL '~' BY '-'.  
A02637     INSPECT PARM-FO-ADDRESS-OVERFLOW REPLACING ALL '~' BY '-'.   
A02637     INSPECT PARM-FR-ADDR-STREET REPLACING ALL '~' BY '-'.        
A02637     INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING ALL '~' BY '-'.   
A02637     INSPECT PARM-FR-CITY-STATE REPLACING ALL '~' BY '-'.         
A02637     INSPECT PARM-FR-COUNTRY REPLACING ALL '~' BY '-'.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09710000
      * 2000-PROCESS-OUTPUT.                                           *09720000
      *     CALLS        2100-DESCRIBE-RESULT                          *09751000
      *                  2300-FIND-OLD-VALUES                          *09740000
      *                  8100-SEND-RESULT                              *09750000
      *                                                                *09760000
      *      CALLED FROM 0000-MAINLINE                                 *09770000
      *                                                                *09780000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *09790000
      *      AND SENDS THEM BACK                                       *09800000
      ******************************************************************09810000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-FIND-OLD-VALUES          THRU 2300-EXIT.        
                                                                        
C36935     MOVE ZEROS                      TO WS-DATABASE.              
C36935     MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
C36935     MOVE AT-COMPANY-NO              TO C8-COMPANY-NO.            
C36935     PERFORM 7800-GET-DELINQ-VALUE   THRU 7800-EXIT.              
C36935     MOVE C8-DELINQ-VALUE            TO WS-DATABASE.              
C36935     IF SEB-DATABASE                                              
C36935         PERFORM 2100-REMOVE-DASH-POUND THRU 2100-EXIT
           END-IF.           
                                                                        
           PERFORM 5000-UPDATE                   THRU 5000-EXIT.        
TP9650     IF PARM-ADDRESS-FORMAT = 'A'  AND                            
TP9650        PARM-FO-UPDATE-FLG = 'ALL' AND                            
T20587        WS-UPDATED-ADDR-ID > 0 AND                                
C34809        WS-FREEFORM-TO-FORMAT = 'N'                               
TP9650                                                                  
TP9650        PERFORM 5090-UPDATE-OTHER-ACCTS    THRU 5090-EXIT         
TP9650                                                                  
TP9650     END-IF                                                       
                                                                        
T20179     IF PARM-BILL-ADDR-ENTERED = 'D' AND                          
T20179        WS-DELETE-ADDR-ID > 0 AND                                 
T22106        PARM-ADDRESS-FORMAT = 'B'                                 
T20179            PERFORM 8910-DELETE-AQ THRU 8910-EXIT                 
T20179            PERFORM 8920-UPDATE-AT THRU 8920-EXIT                 
T20179     END-IF                                                       
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
REARCH     ADD +1                                TO CTR-ROWS.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-ADDRESS-ID          TO S-ADDRESS-ID.                 
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
                                                                        
      ***************************************************************** 05040000
      *  REMOVE DASHES AND # SIGNS FROM FREEFORM AND FORMATTED SEB    * 05040000
      *  ADDRESS FIELDS.                                              * 05040000
      ***************************************************************** 05040000
                                                                        
       2100-REMOVE-DASH-POUND.                                          
                                                                        
           IF PARM-ADDRESS-FORMAT = 'A'                                 
               INSPECT PARM-FO-STREET-NAME REPLACING ALL '-' BY ' '     
               INSPECT PARM-FO-STREET-NAME REPLACING ALL '*' BY ' '     
               INSPECT PARM-FO-STREET-LOCATION-2                        
                   REPLACING ALL '*' BY ' '                             
A03929         INSPECT PARM-FO-STREET-LOCATION-2                        
A03929             REPLACING ALL '#' BY ' '                             
               INSPECT PARM-FO-ADDRESS-OVERFLOW REPLACING ALL '*' BY ' '
               IF PARM-FO-STREET-LOCATION-2 > ' '                       
                   MOVE PARM-FO-STREET-LOCATION-2 TO                    
                        WS-FO-STREET-LOCATION-2                         
                   MOVE SPACES TO PARM-FO-STREET-LOCATION-2             
                   MOVE 1 TO WS-SUBI WS-SUBO                            
                   PERFORM UNTIL WS-SUBI > 11                           
                       IF WS-FO-STREET-LOCATION-2(WS-SUBI:1) > ' '      
                           MOVE WS-FO-STREET-LOCATION-2(WS-SUBI:1) TO   
                                PARM-FO-STREET-LOCATION-2(WS-SUBO:1)    
                           ADD 1 TO WS-SUBO                             
                       END-IF                                           
                       ADD 1 TO WS-SUBI                                 
                   END-PERFORM                                          
               END-IF                                                   
           ELSE                                                         
               INSPECT PARM-FR-ADDR-STREET REPLACING ALL '-' BY ' '     
               INSPECT PARM-FR-ADDR-STREET REPLACING ALL '*' BY ' '     
               MOVE 0 TO WS-COUNT-POUND-SIGN                            
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-POUND-SIGN FOR ALL '#'                      
C36935*        IF WS-COUNT-POUND-SIGN > 0                                       
C36935*            PERFORM 2150-PROCESS-POUND-SIGN THRU 2150-EXIT               
C36935*        END-IF                                                           
               IF PARM-FR-ADDR-STREET > ' '                             
                   MOVE SPACES            TO WS-EMB-INPUT               
                                             WS-CMP-TABLE               
                   MOVE PARM-FR-ADDR-STREET TO WS-EMB-INPUT             
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT   
                   MOVE WS-CMP-TABLE TO PARM-FR-ADDR-STREET             
               END-IF                                                   
                                                                        
               INSPECT PARM-FR-ADDRESS-OVERFLOW                         
                   REPLACING ALL '*' BY ' '                             
               MOVE 0 TO WS-COUNT-POUND-SIGN                            
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-POUND-SIGN FOR ALL '#'                      
C36935*        IF WS-COUNT-POUND-SIGN > 0                                       
C36935*            PERFORM 2180-PROCESS-POUND-SIGN THRU 2180-EXIT               
C36935*        END-IF                                                           
               IF PARM-FR-ADDRESS-OVERFLOW > ' '                        
                   MOVE SPACES            TO WS-EMB-INPUT               
                                             WS-CMP-TABLE               
                   MOVE PARM-FR-ADDRESS-OVERFLOW TO WS-EMB-INPUT        
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT   
                   MOVE WS-CMP-TABLE TO PARM-FR-ADDRESS-OVERFLOW
               END-IF
           END-IF.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05040000
      *  DETERMINE IF LOCATOR IS ALREADY THERE.  IF SO, SPACE OUT #.  * 05040000
      *  IF NOT, ADD APT AS LOCATOR.                                  * 05040000
      *  2150- PROCESSED PARM-FR-ADDR-STREET                          * 05040000
      *  2180- PROCESSED PARM-FR-ADDRESS-OVERFLOW                     * 05040000
      ***************************************************************** 05040000
                                                                        
       2150-PROCESS-POUND-SIGN.                                         
                                                                        
           MOVE 0 TO WS-COUNT-APT                                       
                     WS-COUNT-LOT                                       
                     WS-COUNT-UNIT                                      
                     WS-COUNT-SUITE                                     
                     WS-COUNT-BLDG                                      
                     WS-COUNT-STE.                                      
           MOVE 'N' TO WS-ADDR-FIXED-FL.                                
           INSPECT PARM-FR-ADDR-STREET TALLYING                         
               WS-COUNT-APT FOR ALL 'APT'.                              
           IF WS-COUNT-APT > 0                                          
               INSPECT PARM-FR-ADDR-STREET REPLACING ALL '#' BY ' '     
               MOVE 'Y' TO WS-ADDR-FIXED-FL
           END-IF.                            
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-LOT FOR ALL 'LOT'                           
                   IF WS-COUNT-LOT > 0                                  
                       INSPECT PARM-FR-ADDR-STREET REPLACING            
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-UNIT FOR ALL 'UNIT'                         
                   IF WS-COUNT-UNIT > 0                                 
                       INSPECT PARM-FR-ADDR-STREET REPLACING            
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-SUITE FOR ALL 'SUITE'                       
                   IF WS-COUNT-SUITE > 0                                
                       INSPECT PARM-FR-ADDR-STREET REPLACING            
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-BLDG FOR ALL 'BLDG'                         
                   IF WS-COUNT-BLDG > 0                                 
                       INSPECT PARM-FR-ADDR-STREET REPLACING            
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDR-STREET TALLYING                     
                   WS-COUNT-STE FOR ALL 'STE'                           
                   IF WS-COUNT-STE > 0                                  
                       INSPECT PARM-FR-ADDR-STREET REPLACING            
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-COUNT-APT = 0 AND                                      
              WS-COUNT-LOT = 0 AND                                      
              WS-COUNT-UNIT = 0 AND                                     
              WS-COUNT-SUITE = 0 AND                                    
              WS-COUNT-BLDG = 0 AND                                     
              WS-COUNT-STE = 0                                          
                  PERFORM 2155-INSERT-APT THRU 2155-EXIT
           END-IF.               
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2155-INSERT-APT.                                                 
                                                                        
           MOVE PARM-FR-ADDR-STREET TO WS-INPUT-ADDR-STREET.            
           MOVE 1 TO WS-SUBI WS-SUBO.                                   
           PERFORM UNTIL WS-SUBI > 55                                   
               IF WS-INPUT-ADDR-STREET(WS-SUBI:1) = '#'                 
                   MOVE 'APT ' TO WS-OUTPUT-ADDR-STREET(WS-SUBO:4)      
                   ADD 3 TO WS-SUBO                                     
               ELSE                                                     
                   MOVE WS-INPUT-ADDR-STREET(WS-SUBI:1) TO              
                        WS-OUTPUT-ADDR-STREET(WS-SUBO:1)                
               END-IF                                                   
               ADD 1 TO WS-SUBI WS-SUBO                                 
           END-PERFORM.                                                 
           MOVE WS-OUTPUT-ADDR-STREET TO PARM-FR-ADDR-STREET.           
                                                                        
       2155-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2180-PROCESS-POUND-SIGN.                                         
                                                                        
           MOVE 0 TO WS-COUNT-APT                                       
                     WS-COUNT-LOT                                       
                     WS-COUNT-UNIT                                      
                     WS-COUNT-SUITE                                     
                     WS-COUNT-BLDG                                      
                     WS-COUNT-STE.                                      
           MOVE 'N' TO WS-ADDR-FIXED-FL.                                
           INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                    
               WS-COUNT-APT FOR ALL 'APT'.                              
           IF WS-COUNT-APT > 0                                          
               INSPECT PARM-FR-ADDRESS-OVERFLOW                         
                    REPLACING ALL '#' BY ' '                            
               MOVE 'Y' TO WS-ADDR-FIXED-FL
           END-IF.                            
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-LOT FOR ALL 'LOT'                           
                   IF WS-COUNT-LOT > 0                                  
                       INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING       
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-UNIT FOR ALL 'UNIT'                         
                   IF WS-COUNT-UNIT > 0                                 
                       INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING       
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-SUITE FOR ALL 'SUITE'                       
                   IF WS-COUNT-SUITE > 0                                
                       INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING       
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-BLDG FOR ALL 'BLDG'                         
                   IF WS-COUNT-BLDG > 0                                 
                       INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING       
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-ADDR-FIXED-FL = 'N'                                    
               INSPECT PARM-FR-ADDRESS-OVERFLOW TALLYING                
                   WS-COUNT-STE FOR ALL 'STE'                           
                   IF WS-COUNT-STE > 0                                  
                       INSPECT PARM-FR-ADDRESS-OVERFLOW REPLACING       
                           ALL '#' BY ' '                               
                       MOVE 'Y' TO WS-ADDR-FIXED-FL
                   END-IF
           END-IF.                    
           IF WS-COUNT-APT = 0 AND                                      
              WS-COUNT-LOT = 0 AND                                      
              WS-COUNT-UNIT = 0 AND                                     
              WS-COUNT-SUITE = 0 AND                                    
              WS-COUNT-BLDG = 0 AND                                     
              WS-COUNT-STE = 0                                          
                  PERFORM 2185-INSERT-APT THRU 2185-EXIT
           END-IF.               
                                                                        
       2180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2185-INSERT-APT.                                                 
                                                                        
           MOVE PARM-FR-ADDRESS-OVERFLOW TO WS-INPUT-ADDR-OVERFLOW.     
           MOVE 1 TO WS-SUBI WS-SUBO.                                   
           PERFORM UNTIL WS-SUBI > 35                                   
               IF WS-INPUT-ADDR-OVERFLOW(WS-SUBI:1) = '#'               
                   MOVE 'APT ' TO WS-OUTPUT-ADDR-OVERFLOW(WS-SUBO:4)    
                   ADD 3 TO WS-SUBO                                     
               ELSE                                                     
                   MOVE WS-INPUT-ADDR-OVERFLOW(WS-SUBI:1) TO            
                        WS-OUTPUT-ADDR-OVERFLOW(WS-SUBO:1)              
               END-IF                                                   
               ADD 1 TO WS-SUBI WS-SUBO                                 
           END-PERFORM.                                                 
           MOVE WS-OUTPUT-ADDR-OVERFLOW TO PARM-FR-ADDRESS-OVERFLOW.    
                                                                        
       2185-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10522000
      * 2300-FIND-OLD-VALUES                                           *10551000
      *                                                                *10540000
      *     CALLS 7500-SELECT-ACCOUNT                                  *10550000
      *           7420-SELECT-CUST-NAME-ID                             *10560000
      *           7360-SELECT-PREM-DTLS                                *10570000
      *           7510-SELECT-ADDR-FORMATTED                           *10580000
      *           7520-SELECT-ADDR-FREEFORM                            *10590000
      *           7540-SELECT-ACCT-BILL-HDR                            *10600000
      *           7545-SELECT-ACCT-BILL-NME                            *10610000
      *           7440-SELECT-COUNT-BILL-ADDR                          *10620000
T21931*           7460-SELECT-COUNT-LANDLORD                           *10620000
      *           7560-SELECT-COUNT-NAME-ACCT                          *10651000
      *           7570-SELECT-HDR-NAME                                 *10640000
      *           7575-SELECT-NME-NAME                                 *10650000
T22301*           7579-SELECT-ZIP-CODE                                 *        
T22301*           7580-SELECT-TOWN-STATE                               *        
      *                                                                *10660000
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *10670000
      *                                                                *10680000
      *     GETS ORIGINAL VALUES FOR JOURNALLING.                      *10690000
      ******************************************************************10700000
                                                                        
       2300-FIND-OLD-VALUES.                                            
                                                                        
           MOVE '2300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE 'N'    TO ADDR-FORM-EXISTS-FLAG                         
                          ADDR-FREE-EXISTS-FLAG                         
                          ACCT-BILL-HDR-EXISTS-FLAG                     
                          ACCT-BILL-NME-EXISTS-FLAG                     
                          BILL-ADDR-XREF-EXISTS-FLAG                    
                          NAME-ACCT-HDR-EXISTS-FLAG.                    
           MOVE ZEROS  TO COUNT-ADDR                                    
                          COUNT-NAME                                    
                          AB-NAME-ID                                    
T21931                    WS-LANDLORD-COUNT                             
T25068                    WS-FREEFORM-COUNT.                            
                                                                        
           IF PARM-FO-ADDR-SUFFIX <= SPACES                             
              MOVE SPACES TO PARM-FO-ADDR-SUFFIX                        
           END-IF.                                                      
           PERFORM 7500-SELECT-ACCOUNT            THRU 7500-EXIT.       
           PERFORM 7420-SELECT-CUST-NAME-ID       THRU 7420-EXIT.       
           PERFORM 7360-SELECT-PREM-DTLS          THRU 7360-EXIT.       
                                                                        
      * - A = FORMATTED, B = FREEFORM TYPE ADDRESS                      10900000
           IF AT-ADDRESS-FORMAT = 'A'                                   
              PERFORM 7510-SELECT-ADDR-FORMATTED  THRU 7510-EXIT        
           ELSE                                                         
              PERFORM 7520-SELECT-ADDR-FREEFORM   THRU 7520-EXIT        
           END-IF.                                                      
           PERFORM 7540-SELECT-ACCT-BILL-HDR      THRU 7540-EXIT.       
           PERFORM 7545-SELECT-ACCT-BILL-NME      THRU 7545-EXIT.       
           PERFORM 7546-SELECT-BILL-ADDR-XREF     THRU 7546-EXIT.       
                                                                        
C34867     IF AB-NAME-ID = 0 AND                                        
C34867        PARM-BILL-HDR-ENTERED = 'D'                               
C34867            MOVE ' ' TO PARM-BILL-HDR-ENTERED
           END-IF.                    
C34867     IF HOLD-NAME-ID = 0 AND                                      
C34867        PARM-BILL-NME-ENTERED = 'D'                               
C34867            MOVE ' ' TO PARM-BILL-NME-ENTERED
           END-IF.                    
                                                                        
           IF ADDR-FORM-EXISTS                                          
              PERFORM 7440-SELECT-COUNT-BILL-ADDR THRU 7440-EXIT        
              PERFORM 7560-SELECT-COUNT-NAME-ACCT THRU 7560-EXIT        
           END-IF.                                                      
           IF ACCT-BILL-HDR-EXISTS                                      
              PERFORM 7570-SELECT-HDR-NAME        THRU 7570-EXIT        
           END-IF.                                                      
           IF ACCT-BILL-NME-EXISTS                                      
              PERFORM 7575-SELECT-NME-NAME        THRU 7575-EXIT        
           END-IF.                                                      
                                                                        
T21931     IF AT-ADDRESS-ID > 0                                         
T21931         MOVE AT-ADDRESS-ID TO SI-ADDRESS-ID                      
T21931         PERFORM 7460-SELECT-COUNT-LANDLORD THRU 7460-EXIT
           END-IF.       
T25068     IF AT-ADDRESS-ID > 0                                         
T25068         PERFORM 7470-SELECT-COUNT-FREEFORM THRU 7470-EXIT
           END-IF.       
                                                                        
T22301     PERFORM 7579-SELECT-ZIP-CODE           THRU 7579-EXIT.       
T22301     PERFORM 7580-SELECT-TOWN-STATE         THRU 7580-EXIT.       
                                                                        
           IF DY-ADDR-PREFIX-1 < SPACES                                 
             MOVE SPACES TO     DY-ADDR-PREFIX-1                        
           END-IF                                                       
           IF DY-ADDR-PREFIX-2 < SPACES                                 
             MOVE SPACES TO     DY-ADDR-PREFIX-2                        
           END-IF                                                       
           IF DY-ADDRESS-OVERFLOW < SPACES                              
             MOVE SPACES TO     DY-ADDRESS-OVERFLOW                     
           END-IF                                                       
           IF DY-CARRIER-ROUTE < SPACES                                 
             MOVE SPACES TO     DY-CARRIER-ROUTE                        
           END-IF                                                       
           IF DY-HOUSE-NO < SPACES                                      
             MOVE SPACES TO     DY-HOUSE-NO                             
           END-IF                                                       
           IF DY-STREET-LOCATION-1 < SPACES                             
             MOVE SPACES TO     DY-STREET-LOCATION-1                    
           END-IF                                                       
           IF DY-STREET-LOCATION-2 < SPACES                             
             MOVE SPACES TO     DY-STREET-LOCATION-2                    
           END-IF                                                       
           IF DY-STREET-NAME < SPACES                                   
             MOVE SPACES TO     DY-STREET-NAME                          
           END-IF                                                       
           IF DY-STREET-SUFFIX < SPACES                                 
             MOVE SPACES TO     DY-STREET-SUFFIX                        
           END-IF                                                       
           IF DY-ZIP-CODE < SPACES                                      
             MOVE SPACES TO     DY-ZIP-CODE                             
           END-IF                                                       
           IF DY-ZIP-CODE-PLUS-FOUR < SPACES                            
             MOVE SPACES TO     DY-ZIP-CODE-PLUS-FOUR                   
           END-IF                                                       
           IF DY-ZIP-CODE-TOKEN < SPACES                                
             MOVE SPACES TO     DY-ZIP-CODE-TOKEN                       
           END-IF                                                       
           IF DY-ADDR-SUFFIX < SPACES                                   
             MOVE SPACES TO     DY-ADDR-SUFFIX                          
           END-IF                                                       
           IF DZ-ADDR-COUNTRY < SPACES                                  
               MOVE SPACES TO     DZ-ADDR-COUNTRY                       
           END-IF                                                       
           IF DZ-ADDR-STREET < SPACES                                   
               MOVE SPACES TO     DZ-ADDR-STREET                        
           END-IF                                                       
           IF DZ-ADDR-ZIP-CODE < SPACES                                 
               MOVE SPACES TO     DZ-ADDR-ZIP-CODE                      
           END-IF                                                       
           IF DZ-ADDRESS-OVERFLOW < SPACES                              
               MOVE SPACES TO     DZ-ADDRESS-OVERFLOW                   
           END-IF                                                       
           IF DZ-ADDR-CITY-STATE < SPACES                               
               MOVE SPACES TO     DZ-ADDR-CITY-STATE                    
           END-IF                                                       
                                                                        
           IF DQ-FIRST-NAME < SPACES                                    
             MOVE SPACES TO     DQ-FIRST-NAME                           
           END-IF                                                       
           IF DQ-FULL-NAME < SPACES                                     
             MOVE SPACES TO     DQ-FULL-NAME                            
           END-IF                                                       
           IF DQ-LAST-NAME < SPACES                                     
             MOVE SPACES TO     DQ-LAST-NAME                            
           END-IF                                                       
           IF DQ-MIDDLE-NAME < SPACES                                   
             MOVE SPACES TO     DQ-MIDDLE-NAME                          
           END-IF                                                       
           IF DQ-NAME-FORMAT < SPACES                                   
             MOVE SPACES TO     DQ-NAME-FORMAT                          
           END-IF                                                       
           IF DQ-NAME-TYPE < SPACES                                     
             MOVE SPACES TO     DQ-NAME-TYPE                            
           END-IF                                                       
           IF DQ-TITLE-PREFIX < SPACES                                  
             MOVE SPACES TO     DQ-TITLE-PREFIX                         
           END-IF                                                       
           IF DQ-TITLE-SUFFIX-1 < SPACES                                
             MOVE SPACES TO     DQ-TITLE-SUFFIX-1                       
           END-IF                                                       
           IF DQ-TITLE-SUFFIX-2 < SPACES                                
             MOVE SPACES TO     DQ-TITLE-SUFFIX-2                       
           END-IF                                                       
           IF HOLD-FIRST-NAME < SPACE                                   
             MOVE SPACES TO     HOLD-FIRST-NAME                         
           END-IF                                                       
           IF HOLD-FULL-NAME < SPACE                                    
             MOVE SPACES TO     HOLD-FULL-NAME                          
           END-IF                                                       
           IF HOLD-LAST-NAME < SPACE                                    
             MOVE SPACES TO     HOLD-LAST-NAME                          
           END-IF                                                       
           IF HOLD-MIDDLE-NAME < SPACE                                  
             MOVE SPACES TO     HOLD-MIDDLE-NAME                        
           END-IF                                                       
           IF HOLD-NAME-FORMAT < SPACE                                  
             MOVE SPACES TO     HOLD-NAME-FORMAT                        
           END-IF                                                       
           IF HOLD-NAME-TYPE < SPACE                                    
             MOVE SPACES TO     HOLD-NAME-TYPE                          
           END-IF                                                       
           IF HOLD-TITLE-PREFIX < SPACE                                 
             MOVE SPACES TO     HOLD-TITLE-PREFIX                       
           END-IF                                                       
           IF HOLD-TITLE-SUFFIX-1 < SPACE                               
             MOVE SPACES TO     HOLD-TITLE-SUFFIX-1                     
           END-IF                                                       
           IF HOLD-TITLE-SUFFIX-2 < SPACE                               
             MOVE SPACES TO     HOLD-TITLE-SUFFIX-2                     
           END-IF.                                                      
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00547****************************************************************          
ACT223**  CALL CSR04675 TO INSERT A WQ.                             **          
P00547****************************************************************          
P00547                                                                  
ACT223 4210-CALL-CSR04675.                                              
P00547                                                                  
ACT223     MOVE 0 TO IN-ITEM-ID-4675.                                   
P00547                                                                  
P00547*    EXEC SQL                                                     
ACT223*       CALL CSR04675                                             
ACT223*           (:IN-ITEM-ID-4675,                                    
ACT223*            :ROUTING-CATEGORY-4675,                              
ACT223*            :LOCAL-OFFICE-4675,                                  
ACT223*            :USER-ID-ORIG-4675,                                  
ACT223*            :USER-ID-ASGN-4675,                                  
ACT223*            :RESP-AREA-ID-4675,                                  
ACT223*            :CATEGORY-ID-4675,                                   
ACT223*            :ACCOUNT-NO-4675,                                    
ACT223*            :PREMISE-NO-4675,                                    
ACT223*            :CUSTOMER-NO-4675,                                   
ACT223*            :SERV-ORDER-NO-4675,                                 
ACT223*            :COMMENTS-4675,                                      
ACT223*            :DATE-REQUIRED-4675,                                 
ACT223*            :DATE-CREATED-4675,                                  
ACT223*            :WQ-PRIORITY-4675,                                   
ACT223*            :FREE-FORM-DATA-4675,                                
ACT223*            :CREATED-BY-4675)                                    
P00547*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00547                                                                  
P00547     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00547                                                                  
P00547     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
P00547        IF WS-ACTIVE-RETURN-CODE = 0                              
P00547            MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
P00547        END-IF                                                    
P00547        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00547        MOVE '4210'                TO ACTIVE-PARAGRAPH            
P00547        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT223        MOVE 'CSR04675'            TO TABLE-1                     
P00547        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT223        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
P00547        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT223        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
P00547        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00547        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00547     END-IF.                                                      
P00547                                                                  
P00547*    EXEC SQL                                                     
P00547*       ASSOCIATE LOCATORS                                        
ACT223*       (:LOC4675)                                                
ACT223*       WITH PROCEDURE CSR04675                                   
P00547*    END-EXEC.                                                    
P00547                                                                  
P00547*    EXEC SQL                                                     
ACT223*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT223*       :LOC4675                                                  
P00547*    END-EXEC.                                                    
P00547                                                                  
P00547     EXEC SQL                                                     
ACT223        FETCH RESULT_SET_CSR_4675 INTO                            
ACT223           :RETURN-CODE-4675,                                     
ACT223           :OUT-ITEM-ID-4675                                      
P00547     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00547                                                                  
P00547     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P00547     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00547         WHEN SUCCESSFUL-CALL                                     
ACT223             IF RETURN-CODE-4675 NOT = 0                          
ACT223                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
P00547                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
P00547                 MOVE '4210'            TO ACTIVE-PARAGRAPH       
P00547                 MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT223                 MOVE 'CSR04675'        TO TABLE-1                
P00547                 MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT223                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
P00547                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT223                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
P00547                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
P00547                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
P00547             END-IF                                               
P00547         WHEN OTHER                                               
P00547             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P00547             MOVE '4210'                TO ACTIVE-PARAGRAPH       
P00547             MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT223             MOVE 'CSR04675'            TO TABLE-1                
P00547             MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT223             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
P00547             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT223             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
P00547             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00547             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00547     END-EVALUATE.                                                
P00547                                                                  
P00547 4210-EXIT.                                                       
P00547      EXIT.                                                       
                                                                        
      ******************************************************************11186000
      * 5000-UPDATE                                                    *11187000
      *                                                                *11188000
      *     CALLS 5010-JRNL-TRAN-HEAD                                  *11189000
      *           5020-JRNL-ACCOUNT-DETAILS                            *11190000
      *           5040-JRNL-ATTN-NAME                                  *11200000
      *           5050-JRNL-BILL-NAME                                  *11210000
      *           5060-DEL-ACCOUNT-DETAILS                             *11220000
      *           5070-DEL-BILL-HDR                                    *11251000
      *           5080-DEL-BILL-NME                                    *11240000
      *                                                                *11250000
      *     CALLED FROM 2300-BUILD-RESULT                              *11260000
      *                                                                *11270000
      *     UPDATE THE MAINTENANCE TRANSACTION HISTORY TABLES.         *11280000
      ******************************************************************11290000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 5010-JRNL-TRAN-HEAD          THRU 5010-EXIT.         
           MOVE MH-TRANS-HIST-SEQ-NO                                    
              TO MI-TRANS-HIST-SEQ-NO.                                  
T22945     MOVE PARM-ADDRESS-ID TO WS-INS-ADDRESS-ID.                   
           IF PARM-BILL-ADDR-ENTERED = 'U'                              
              PERFORM 5020-JRNL-ACCOUNT-DETAILS THRU 5020-EXIT          
           ELSE                                                         
               IF PARM-BILL-ADDR-ENTERED = 'D'                          
                   MOVE AT-ADDRESS-ID TO WS-DELETE-ADDR-ID              
                   PERFORM 5060-DEL-ACCOUNT-DETAILS  THRU 5060-EXIT     
           END-IF
           END-IF.                                                      
                                                                        
           IF PARM-BILL-HDR-ENTERED = 'U'                               
               PERFORM 5040-JRNL-ATTN-NAME       THRU 5040-EXIT         
           ELSE                                                         
               IF PARM-BILL-HDR-ENTERED = 'D'                           
                   PERFORM 5070-DEL-BILL-HDR THRU 5070-EXIT             
           END-IF
           END-IF.                                                      
                                                                        
           IF PARM-BILL-NME-ENTERED = 'U'                               
              PERFORM 5050-JRNL-BILL-NAME       THRU 5050-EXIT          
           ELSE                                                         
               IF PARM-BILL-NME-ENTERED = 'D'                           
                   PERFORM 5080-DEL-BILL-NME    THRU 5080-EXIT          
           END-IF
           END-IF.                                                      
           MOVE WS-INS-ADDRESS-ID TO   RS-ADDRESS-ID.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11408000
      * 5010-JRNL-TRAN-HEAD                                            *11409000
      *                                                                *11410000
      *     CALLS 7000-SELECT-CUR-TIME-STATS                           *11420000
      *           7040-SELECT-RESP-AREA-ID                             *11451000
      *                                                                *11440000
      *     CALLED FROM 5000-UPDATE                                    *11450000
      *                                                                *11460000
      *     JOURNALS THE MAINTENANCE TRANSACTION HISTORY HEADER.       *11470000
      ******************************************************************11480000
                                                                        
       5010-JRNL-TRAN-HEAD.                                             
                                                                        
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7000-SELECT-CUR-TIME-STATS   THRU 7000-EXIT.         
           PERFORM 7040-SELECT-RESP-AREA-ID     THRU 7040-EXIT.         
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO            TO MH-TRANS-HIST-SEQ-NO.
           MOVE WS-DATE-TRANS                   TO MH-DATE-TRANS.       
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE.   
           MOVE WS-RESP-AREA-ID                 TO MH-RESP-AREA-ID.     
           MOVE WS-ACCOUNT-NO-D                 TO MH-ACCOUNT-NO.       
           MOVE ZEROS                           TO MH-CUSTOMER-NO.      
           MOVE ZEROS                           TO MH-PREMISE-NO.       
           MOVE PARM-USER-ID                    TO MH-USER-ID.          
           MOVE 'PANEL086'                      TO MH-APPL-PROGRAM-ID.  
           IF PARM-COMMENTS-TEXT = SPACE                                
              MOVE 0                            TO MH-TRAN-COMMENT-TEXT 
           ELSE                                                         
REARCH        MOVE PARM-COMMENTS-TEXT           TO MH-TRAN-COMMENT-TEXT 
REARCH        MOVE PARM-COMMENTS-LEN            TO MH-TRAN-COMMENT-LEN  
           END-IF.                                                      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11750000
      * 5020-JRNL-ACCOUNT-DETAILS                                      *11760000
      *                                                                *11770000
      *     CALLS 5021-CHECK-FOR-MATCH                                 *11780000
      *           5022-GET-NEW-ADDRESS-ID                              *11790000
      *           8400-UPDATE-TBACCT                                   *11800000
      *           8660-INSERT-TBADRFMT                                 *11810000
      *           8680-INSERT-TBADRFRE                                 *11820000
      *           8700-INSERT-TBBLADRX                                 *11851000
      *           8890-DELETE-TRADRFRE                                 *11840000
      *           5023-CHK-DELETE-ADDRESS                              *11850000
      *           5030-JRNL-ADDRESS-DETAILS                            *11860000
      *           6530-LOAD-MNT-TRANS-HIST                             *11870000
      *                                                                *11880000
      *     CALLED FROM 5000-UPDATE                                    *11890000
      *                                                                *11900000
      *     JOURNALS THE MAINTENANCE TRANSACTION DETAILS               *11910000
      ******************************************************************11920000
                                                                        
       5020-JRNL-ACCOUNT-DETAILS.                                       
                                                                        
           MOVE '5020' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF PARM-ADDRESS-FORMAT NOT = AT-ADDRESS-FORMAT               
              IF PARM-ADDRESS-FORMAT = 'A'                              
C34809           IF AT-ADDRESS-FORMAT = 'B'                             
C34809               MOVE 'Y' TO WS-FREEFORM-TO-FORMAT                  
C34809           END-IF                                                 
                 MOVE 'N'                  TO WS-MATCH-FOUND-FLAG       
                 PERFORM 5021-CHECK-FOR-MATCH THRU 5021-EXIT            
                 IF WS-MATCH-FOUND-FLAG = 'N'                           
C32615              MOVE 'Y' TO WS-ADDRESS-INSERT                       
                    PERFORM 5022-GET-NEW-ADDRESS-ID THRU 5022-EXIT      
                    PERFORM 8660-INSERT-TBADRFMT THRU 8660-EXIT         
                    IF BILL-ADDR-XREF-EXISTS                            
                       PERFORM 8550-UPD-TBBLADRX    THRU 8550-EXIT      
                    ELSE                                                
                       PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT      
                    END-IF                                              
T21931              IF ADDR-FREE-EXISTS AND WS-LANDLORD-COUNT = 0 AND   
T25068                                      WS-FREEFORM-COUNT < 2       
                       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO          
                       MOVE 'ADDR FREEFORM'  TO MI-COLUMN-DESC          
                       MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE AT-ADDRESS-ID   TO WS-ADDRESS-ID-I          
                       MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S          
T21717                 MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT 
                       MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN  
                       MOVE 'ADDR DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT 
                       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT  
                       ADD 1 TO WS-TRAN-APPL-NO                         
C37666*                PERFORM 8890-DELETE-TBADRFRE THRU 8890-EXIT      12210000
                    END-IF                                              
                 ELSE                                                   
                    IF BILL-ADDR-XREF-EXISTS                            
                       PERFORM 8550-UPD-TBBLADRX    THRU 8550-EXIT      
                    ELSE                                                
                       PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT      
                    END-IF                                              
T21931              IF ADDR-FREE-EXISTS AND WS-LANDLORD-COUNT = 0 AND   
T25068                                      WS-FREEFORM-COUNT < 2       
                       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO          
                       MOVE 'ADDR FREEFORM' TO MI-COLUMN-DESC           
                       MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE AT-ADDRESS-ID   TO WS-ADDRESS-ID-I          
                       MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S          
T21717                 MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT 
                       MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN  
                       MOVE 'ADDR DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT 
                       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT  
                       ADD 1 TO WS-TRAN-APPL-NO                         
C37666*                PERFORM 8890-DELETE-TBADRFRE THRU 8890-EXIT      12400000
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 5022-GET-NEW-ADDRESS-ID THRU 5022-EXIT         
                 PERFORM 8680-INSERT-TBADRFRE    THRU 8680-EXIT         
                 IF BILL-ADDR-XREF-EXISTS                               
                    PERFORM 8550-UPD-TBBLADRX    THRU 8550-EXIT         
                 ELSE                                                   
                    PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT         
                 END-IF                                                 
                 IF ADDR-FORM-EXISTS                                    
                    PERFORM 5023-CHK-DELETE-ADDRESS THRU 5023-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'ADDRESS-FORMAT'        TO MI-COLUMN-DESC            
              MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE PARM-ADDRESS-FORMAT     TO MI-CHG-COLUMN-VALUE-TEXT  
              IF AT-ADDRESS-FORMAT > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE AT-ADDRESS-FORMAT   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'ADDRESS-ID'            TO MI-COLUMN-DESC            
              MOVE +13                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-INS-ADDRESS-ID       TO WS-ADDRESS-ID-I           
              MOVE WS-ADDRESS-ID-I         TO WS-ADDRESS-ID-S           
              MOVE WS-ADDRESS-ID-S         TO MI-CHG-COLUMN-VALUE-TEXT  
              IF AT-ADDRESS-ID > ZEROS                                  
                 MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE AT-ADDRESS-ID        TO WS-ADDRESS-ID-I           
                 MOVE WS-ADDRESS-ID-I      TO WS-ADDRESS-ID-S           
                 MOVE WS-ADDRESS-ID-S      TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
      *       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           12670000
              ADD 1                         TO WS-TRAN-APPL-NO          
                                                                        
              PERFORM 8400-UPDATE-TBACCT    THRU 8400-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 5030-JRNL-ADDRESS-DETAILS THRU 5030-EXIT.            
                                                                        
T20384     IF PARM-ADDRESS-FORMAT = 'B'                                 
T20384         IF PARM-FR-COUNTRY > ' ' AND                             
T20384            PARM-FR-COUNTRY NOT = 'USA' AND                       
P00547            PARM-FR-COUNTRY NOT = 'UNITED STATES'                 
T20384                MOVE 'D' TO WS-CODE-PERM-BILL                     
P00547                PERFORM 5920-IAT-WQ THRU 5920-EXIT                
T20384         ELSE                                                     
T20384                MOVE 'A' TO WS-CODE-PERM-BILL                     
T20384         END-IF                                                   
T20384         PERFORM 8530-SET-PULL-CODE THRU 8530-EXIT
           END-IF.               
                                                                        
T13202     MOVE 'A'                 TO WS-RPC-ACTION.                   
T13202     PERFORM 5800-PROCESS-LL-UPDATES  THRU 5800-EXIT.             
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12780000
      * 5021-CHECK-FOR-MATCH                                           *12790000
      *                                                                *12800000
      *     CALLS 7240-COMPARE-EXACT-MATCH                             *12810000
      *                                                                *12820000
      *     CALLED FROM 5020-JRNL-ACCOUNT-DETAILS                      *12851000
      *                                                                *12840000
      *     CHECKS FOR A MATCHING FORMATTED ADDRESS RECORD.            *12850000
      ******************************************************************12860000
                                                                        
       5021-CHECK-FOR-MATCH.                                            
                                                                        
           MOVE '5021' TO ACTIVE-PARAGRAPH.                             
                                                                        
T12649     PERFORM 7210-OPEN-EXACT-MATCH    THRU 7210-EXIT.             
T12649                                                                  
T12649     PERFORM 7220-FETCH-EXACT-MATCH   THRU 7220-EXIT.             
                                                                        
T12649     PERFORM 7230-CLOSE-EXACT-MATCH   THRU 7230-EXIT.             
                                                                        
T21091     IF WS-MATCH-FOUND                                            
T21091         PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT               
T21091         IF WS-PREMISE-NOT-FOUND                                  
T21091             PERFORM 7110-SELECT-ACCOUNT THRU 7110-EXIT
               END-IF
           END-IF.          
                                                                        
           IF WS-MATCH-FOUND                                            
              MOVE WS-MATCH-ADDRESS-ID TO WS-INS-ADDRESS-ID             
           ELSE                                                         
              MOVE AT-ADDRESS-ID       TO WS-INS-ADDRESS-ID             
           END-IF.                                                      
                                                                        
                                                                        
       5021-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15100000
      * 5022-GET-NEW-ADDRESS-ID                                        *13010000
      *                                                                *13020000
      *     CALLS 7250-LOCK-ADDR-ID-CNTL                               *13051000
      *           7300-SELECT-ADDR-ID-CNTL                             *13040000
      *           6210-CALCULATE-CHECK-DIGIT                           *13050000
      *                                                                *13070000
      *     CALLED FROM 5020-JRNL-ACCOUNT-DETAILS                      *13080000
      *                                                                *13090000
      *     GETS NEW ADDRESS ID FOR ADDRESS INSERTS                    *13100000
      ******************************************************************13110000
                                                                        
       5022-GET-NEW-ADDRESS-ID.                                         
                                                                        
           MOVE '5022' TO ACTIVE-PARAGRAPH.                             
                                                                        
*T4158     MOVE 'PANEL086'             TO WS-90-PANEL-NO.               
*T4158     MOVE PARM-USER-ID           TO WS-90-USERID.                 
*T4158     MOVE PARM-ACCOUNT-NO        TO WS-90-ACCOUNT-NO.             
*T4158     MOVE ZEROES                 TO WS-90-CUSTOMER-NO.            
*T4158     MOVE ZEROES                 TO WS-90-PREMISE-NO.             
                                                                        
*T4158     PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT.              
*T4158     MOVE WS-90-NEW-ADDRESS-ID      TO WS-NEW-ADDR-IDENT.         
                                                                        
           MOVE WS-NEW-ADDR-IDENT           TO WS-INS-ADDRESS-ID.       
           MOVE I8-ADDRESS-ID               TO WS-ADDRESS-ID-I-NEW.     
           MOVE WS-ADDRESS-ID-I-NEW         TO RS-ADDRESS-ID.           
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-DATE-TRANS               TO MH-DATE-TRANS.           
                                                                        
       5022-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13320000
      * 5023-CHK-DELETE-ADDRESS                                        *13351000
      *                                                                *13340000
      *     CALLS 8860-DELETE-TBBLADRX                                 *13350000
      *           8880-DELETE-TBADRFMT                                 *13360000
      *           6530-LOAD-MNT-TRANS-HIST                             *13370000
      *                                                                *13380000
      *     CALLED FROM 5020-JRNL-ACCOUNT-DETAILS                      *13390000
      *                                                                *13400000
      *     DETERMINES IF FORMATTED ADDRESS CAN BE DELETED, DOES       *13410000
      *     DELETE, AND JOURNALS DELETE ACTION.                        *13420000
      ******************************************************************13451000
                                                                        
       5023-CHK-DELETE-ADDRESS.                                         
                                                                        
           MOVE '5023' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF ((COUNT-NAME < 1) AND (COUNT-ADDR < 2))                   
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ADDR FORMATTED' TO MI-COLUMN-DESC                   
              MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN           
              MOVE AT-ADDRESS-ID   TO WS-ADDRESS-ID-I                   
              MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S                   
T21717        MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT          
              MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN           
              MOVE 'ADDR DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
                                                                        
C37666*       PERFORM 8880-DELETE-TBADRFMT THRU 8880-EXIT               13610000
           END-IF.                                                      
                                                                        
       5023-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13670000
      * 5030-JRNL-ADDRESS-DETAILS                                      *13680000
      *                                                                *13690000
      *     CALLS 8480-UPDATE-TBADRFRM                                 *13700000
      *           8520-UPDATE-TBADRFRE                                 *13710000
      *           6530-LOAD-MNT-TRANS-HIST                             *13720000
      *                                                                *13751000
      *     CALLED FROM 5000-UPDATE                                    *13740000
      *                                                                *13750000
      *     JOURNALS THE MAINTENANCE TRANSACTION DETAILS               *13760000
      ******************************************************************13770000
                                                                        
       5030-JRNL-ADDRESS-DETAILS.                                       
                                                                        
           MOVE '5030' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF PARM-ADDRESS-FORMAT = 'A'                                 
              IF PARM-FO-UPDATE-FLG = 'ALL'                             
TP9650           MOVE    AT-ADDRESS-ID TO       WS-UPDATED-ADDR-ID      
C32615           MOVE 'Y' TO WS-WRITE-TRANSHIST                         
TP9650           PERFORM 5031-WRITE-MI-RECORDS  THRU 5031-EXIT          
                                                                        
                 IF PARM-ADDRESS-FORMAT  = AT-ADDRESS-FORMAT            
TP9650              PERFORM 5021-CHECK-FOR-MATCH    THRU 5021-EXIT      
TP9650              IF WS-MATCH-FOUND-FLAG = 'N'                        
TP9650                 PERFORM 8480-UPDATE-TBADRFMT THRU 8480-EXIT      
TP9650              ELSE                                                
TP9650                 IF BILL-ADDR-XREF-EXISTS                         
TP9650                     PERFORM 8550-UPD-TBBLADRX    THRU 8550-EXIT  
TP9650                 ELSE                                             
TP9650                     PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT  
TP9650                 END-IF                                           
TP9650                 PERFORM 8400-UPDATE-TBACCT   THRU 8400-EXIT      
TP9650              END-IF                                              
                 END-IF                                                 
              ELSE                                                      
C32615           MOVE 'Y' TO WS-WRITE-TRANSHIST                         
TP9650           PERFORM 5031-WRITE-MI-RECORDS  THRU 5031-EXIT          
TP9650           PERFORM 5021-CHECK-FOR-MATCH    THRU 5021-EXIT         
TP9650           IF WS-MATCH-FOUND-FLAG = 'N'                           
                     PERFORM 5022-GET-NEW-ADDRESS-ID THRU 5022-EXIT     
                     IF PARM-ADDRESS-FORMAT = AT-ADDRESS-FORMAT         
                        PERFORM 8660-INSERT-TBADRFMT THRU 8660-EXIT     
                        IF BILL-ADDR-XREF-EXISTS                        
                           PERFORM 8550-UPD-TBBLADRX THRU 8550-EXIT     
                        ELSE                                            
                           PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT  
                        END-IF                                          
                        PERFORM 8400-UPDATE-TBACCT THRU 8400-EXIT       
                     END-IF                                             
TP9650           ELSE                                                   
TP9650               IF BILL-ADDR-XREF-EXISTS                           
TP9650                  PERFORM 8550-UPD-TBBLADRX    THRU 8550-EXIT     
TP9650               ELSE                                               
TP9650                  PERFORM 8700-INSERT-TBBLADRX THRU 8700-EXIT     
TP9650               END-IF                                             
TP9650               PERFORM 8400-UPDATE-TBACCT   THRU 8400-EXIT        
TP9650           END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF PARM-FR-CITY-STATE NOT = DZ-ADDR-CITY-STATE            
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDR CITY ST'  TO MI-COLUMN-DESC                 
                 MOVE +30             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-FR-CITY-STATE                                
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF DZ-ADDR-CITY-STATE > SPACES                         
                    MOVE +30           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE DZ-ADDR-CITY-STATE                             
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
              IF PARM-FR-COUNTRY NOT = DZ-ADDR-COUNTRY                  
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDR COUNTRY'  TO MI-COLUMN-DESC                 
                 MOVE +35             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-FR-COUNTRY                                   
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF DZ-ADDR-COUNTRY > SPACES                            
                    MOVE +35           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE DZ-ADDR-COUNTRY                                
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-FR-ADDR-STREET NOT = DZ-ADDR-STREET               
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDR STREET'   TO MI-COLUMN-DESC                 
                 MOVE +55             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-FR-ADDR-STREET                               
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF DZ-ADDR-STREET > SPACES                             
                    MOVE +55           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE DZ-ADDR-STREET                                 
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-FR-ZIP-CODE NOT = DZ-ADDR-ZIP-CODE                
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDR ZIP'      TO MI-COLUMN-DESC                 
                 MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-FR-ZIP-CODE                                  
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF DZ-ADDR-ZIP-CODE > SPACES                           
                    MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE DZ-ADDR-ZIP-CODE                               
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-FR-ADDRESS-OVERFLOW NOT = DZ-ADDRESS-OVERFLOW     
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDRESS OVER'  TO MI-COLUMN-DESC                 
T15277           MOVE +35             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-FR-ADDRESS-OVERFLOW                          
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF DZ-ADDRESS-OVERFLOW > SPACES                        
T15277              MOVE +35           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE DZ-ADDRESS-OVERFLOW                            
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              PERFORM 8520-UPDATE-TBADRFRE THRU 8520-EXIT               
T19358*       MOVE PARM-ADDRESS-ID TO WS-INS-ADDRESS-ID                         
T19462        IF PARM-FR-COUNTRY > ' ' AND                              
T19462           PARM-FR-COUNTRY NOT = 'USA'                            
T20384               MOVE 'D' TO WS-CODE-PERM-BILL                      
T19462               PERFORM 8530-SET-PULL-CODE THRU 8530-EXIT          
T19462        END-IF                                                    
           END-IF.                                                      
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5031-WRITE-MI-RECORDS.                                           
                                                                        
           IF PARM-FO-HOUSE-NO NOT = DY-HOUSE-NO                        
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-HOUSE-NO                                     
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-HOUSE-NO > SPACES                                   
                 MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-HOUSE-NO         TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ADDR-PREFIX-1 NOT = DY-ADDR-PREFIX-1              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ADDR PREFIX 1' TO MI-COLUMN-DESC                    
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ADDR-PREFIX-1                                
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ADDR-PREFIX-1                                  
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ADDR-PREFIX-2 NOT = DY-ADDR-PREFIX-2              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ADDR PREFIX 2' TO MI-COLUMN-DESC                    
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ADDR-PREFIX-2                                
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ADDR-PREFIX-2 > SPACES                              
                 MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ADDR-PREFIX-2                                  
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-STREET-NAME NOT = DY-STREET-NAME                  
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-STREET-NAME                                  
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-STREET-NAME > SPACES                                
                 MOVE +30                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-STREET-NAME                                    
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-STREET-SUFFIX NOT = DY-STREET-SUFFIX              
              MOVE '22'                  TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'STREET SUFFIX' TO MI-COLUMN-DESC                    
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-STREET-SUFFIX                                
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-STREET-SUFFIX > SPACES                              
                 MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-STREET-SUFFIX                                  
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ADDR-SUFFIX NOT = DY-ADDR-SUFFIX                  
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ADDR-SUFFIX                                  
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ADDR-SUFFIX > SPACES                                
                 MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ADDR-SUFFIX                                    
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-STREET-LOCATION-1 NOT = DY-STREET-LOCATION-1      
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'STREET LOC 1'        TO MI-COLUMN-DESC              
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-STREET-LOCATION-1                            
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-STREET-LOCATION-1                              
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-STREET-LOCATION-2 NOT = DY-STREET-LOCATION-2      
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'STREET LOC 2'        TO MI-COLUMN-DESC              
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-STREET-LOCATION-2                            
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-STREET-LOCATION-2                              
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ADDRESS-OVERFLOW NOT = DY-ADDRESS-OVERFLOW        
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ADDRESS OVER'        TO MI-COLUMN-DESC              
              MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ADDRESS-OVERFLOW                             
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +26                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ADDRESS-OVERFLOW                               
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ZIP-CODE NOT = DY-ZIP-CODE                        
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ZIP-CODE                                     
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ZIP-CODE > SPACES                                   
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ZIP-CODE         TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF                                                       
                                                                        
           IF PARM-FO-ZIP-CODE-PL-FOUR NOT = DY-ZIP-CODE-PLUS-FOUR      
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'ZIP PLUS FOUR' TO MI-COLUMN-DESC                    
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FO-ZIP-CODE-PL-FOUR                             
                 TO MI-CHG-COLUMN-VALUE-TEXT                            
              IF DY-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE DY-ZIP-CODE-PLUS-FOUR                             
                    TO MI-PRV-COLUMN-VALUE-TEXT                         
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO WS-TRAN-APPL-NO            
           END-IF.                                                      
                                                                        
T18896     IF PARM-FO-ZIP-CODE-TOKEN NOT = DY-ZIP-CODE-TOKEN            
T18896        MOVE SPACES                TO MI-TABLE-ID                 
T18896        MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
T18896        MOVE 'ZIP TOKEN'           TO MI-COLUMN-DESC              
T18896        MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
T18896        MOVE PARM-FO-ZIP-CODE-TOKEN                               
T18896           TO MI-CHG-COLUMN-VALUE-TEXT                            
T18896        IF DY-ZIP-CODE-TOKEN > SPACES                             
T18896           MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
T18896           MOVE DY-ZIP-CODE-TOKEN                                 
T18896              TO MI-PRV-COLUMN-VALUE-TEXT                         
T18896        ELSE                                                      
T18896           MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
T18896           MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
T18896        END-IF                                                    
T18896        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T18896        ADD 1                       TO WS-TRAN-APPL-NO            
T18896     END-IF.                                                      
                                                                        
      * DO NOT WRITE ON AN INSERT TRANSACTION                                   
C32615     IF WS-WRITE-TRANSHIST = 'Y' AND WS-ADDRESS-INSERT = 'N'      
C32615        MOVE MI-TRANS-HIST-SEQ-NO  TO WS-HOLD-SEQ-NO              
C32615        MOVE SPACES                TO MI-TABLE-ID                 
C32615        MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
C32615                                      WS-HOLD-APPL-NO             
C32615        MOVE 'UPDATE FLAG'         TO MI-COLUMN-DESC              
C32615        MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
C32615        MOVE PARM-FO-UPDATE-FLG    TO MI-CHG-COLUMN-VALUE-TEXT    
C32615        MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN     
C32615        MOVE ' '                   TO MI-PRV-COLUMN-VALUE-TEXT    
C32615        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C32615        ADD 1                       TO WS-TRAN-APPL-NO            
C32615     END-IF.                                                      
                                                                        
       5031-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************17450900
      * 5040-JRNL-ATTN-NAME                                            *17451000
      *                                                                *17452000
      *     CALLS 6530-LOAD-MNT-TRANS-HIST                             *17460000
      *           8820-DELETE-TBATBLNM                                 *17470000
      *           8840-DELETE-TBNAME                                   *17480000
      *           8800-DELETE-TBNMACTX                                 *17490000
      *           5041-GET-NEW-NAME-ID                                 *17500000
      *           8600-INSERT-TBNAME                                   *17510000
      *           8620-INSERT-TBATBLNM                                 *17520000
      *           8640-INSERT-TBNMACTX                                 *17551000
      *           8460-UPDATE-TBNAME                                   *17540000
      *           8540-UPDATE-TBBLADRX                                 *17550000
      *                                                                *17560000
      *     CALLED FROM 5000-UPDATE                                    *17570000
      *                                                                *17580000
      *     JOURNALS THE ATTENATION HEADER NAME ON THE BILL.           *17590000
      ******************************************************************17600000
                                                                        
       5040-JRNL-ATTN-NAME.                                             
                                                                        
           MOVE '5040' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF ACCT-BILL-HDR-EXISTS                                      
              IF PARM-AT-NAME-TYPE NOT = AB-NAME-TYPE                   
                 MOVE SPACES          TO MI-TABLE-ID                    
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 IF AB-NAME-TYPE = 'AI'                                 
                    MOVE 'IN CARE OF NAME'    TO MI-COLUMN-DESC         
                 END-IF                                                 
                 IF AB-NAME-TYPE = 'AA'                                 
                    MOVE 'ATTENTION  NAME'    TO MI-COLUMN-DESC         
                 END-IF                                                 
                 IF AB-NAME-TYPE = 'AN'                                 
                    MOVE 'NAME ON BILL'    TO MI-COLUMN-DESC            
                 END-IF                                                 
                 IF AB-NAME-TYPE = 'DB'                                 
                    MOVE 'DOING BUS AS'    TO MI-COLUMN-DESC            
                 END-IF                                                 
                 MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE SPACES          TO MI-CHG-COLUMN-VALUE-TEXT       
                 MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN        
                 MOVE AB-NAME-ID      TO WS-NAME-ID-I                   
                 MOVE WS-NAME-ID-I    TO WS-NAME-ID-S                   
                 MOVE 'NAME DELETED'  TO MI-PRV-COLUMN-VALUE-TEXT       
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
                                                                        
                 MOVE AB-NAME-ID       TO WS-NAME-ID                    
                 MOVE AB-NAME-TYPE     TO WS-NAME-TYPE                  
                 PERFORM 8820-DELETE-TBATBLNM THRU 8820-EXIT            
                 PERFORM 8810-DELETE-TBBILLADDRX THRU 8810-EXIT         
A37666*          PERFORM 8840-DELETE-TBNAME THRU  8840-EXIT             17851000
                 PERFORM 8800-DELETE-TBNMACTX THRU 8800-EXIT            
      *          MOVE 'N' TO BILL-ADDR-XREF-EXISTS-FLAG                 17841000
                 PERFORM 5041-GET-NEW-NAME-ID THRU 5041-EXIT            
                                                                        
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 IF PARM-AT-NAME-TYPE = 'AI'                            
                    MOVE 'IN CARE OF NAME'    TO MI-COLUMN-DESC         
                 END-IF                                                 
                 IF PARM-AT-NAME-TYPE = 'AA'                            
                    MOVE 'ATTENTION  NAME'    TO MI-COLUMN-DESC         
                 END-IF                                                 
                 IF PARM-AT-NAME-TYPE = 'AN'                            
                    MOVE 'NAME ON BILL'    TO MI-COLUMN-DESC            
                 END-IF                                                 
                 IF PARM-AT-NAME-TYPE = 'DB'                            
                    MOVE 'DOING BUS AS'    TO MI-COLUMN-DESC            
                 END-IF                                                 
                 MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE WS-INS-NAME-ID  TO WS-NAME-ID-I                   
                 MOVE WS-NAME-ID-I    TO WS-NAME-ID-S                   
                 MOVE 'NEW NAME'      TO MI-CHG-COLUMN-VALUE-TEXT       
                 MOVE +8              TO MI-PRV-COLUMN-VALUE-LEN        
                 MOVE SPACES          TO MI-PRV-COLUMN-VALUE-TEXT       
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
                                                                        
                 MOVE PARM-AT-NAME-TYPE                                 
                    TO WS-NAME-TYPE                                     
                 MOVE PARM-AT-NAME-FORMAT                               
                    TO WS-NAME-FORMAT                                   
                 MOVE PARM-AT-FIRST-NAME                                
                    TO WS-FIRST-NAME                                    
                 MOVE PARM-AT-MIDDLE-NAME                               
                    TO WS-MIDDLE-NAME                                   
                 MOVE PARM-AT-LAST-NAME                                 
                    TO WS-LAST-NAME                                     
                 MOVE PARM-AT-TITLE-PREFIX                              
                    TO WS-TITLE-PREFIX                                  
                 MOVE PARM-AT-TITLE-SUFFIX-1                            
                    TO WS-TITLE-SUFFIX-1                                
                 MOVE PARM-AT-TITLE-SUFFIX-2                            
                    TO WS-TITLE-SUFFIX-2                                
                 MOVE PARM-AT-FULL-NAME                                 
                    TO WS-FULL-NAME                                     
                 PERFORM 8600-INSERT-TBNAME   THRU 8600-EXIT            
                 PERFORM 8620-INSERT-TBATBLNM THRU 8620-EXIT            
                 PERFORM 8640-INSERT-TBNMACTX THRU 8640-EXIT            
C37298           IF WS-AQ-ROW-DELETED = 'Y'                             
A35665              IF PARM-BILL-ADDR-ENTERED = 'U'                     
A35665                  MOVE WS-INS-ADDRESS-ID TO WS-AQ-ADDRESS-ID      
A35665              END-IF                                              
C37298              PERFORM 8750-INSERT-TBBLADRX THRU 8750-EXIT         
C37298              MOVE 'Y' TO BILL-ADDR-XREF-EXISTS-FLAG              
C37298           ELSE                                                   
C37298               IF BILL-ADDR-XREF-EXISTS                           
C37298                   PERFORM 8540-UPDATE-TBBLADRX THRU 8540-EXIT    
C37298               END-IF                                             
C37298           END-IF                                                 
              ELSE                                                      
                                                                        
                 MOVE AB-NAME-ID                                        
                    TO WS-NAME-ID-I                                     
                 MOVE WS-NAME-ID-I                                      
                    TO WS-NAME-ID                                       
                 MOVE PARM-AT-NAME-TYPE                                 
                    TO WS-NAME-TYPE                                     
                 MOVE PARM-AT-NAME-FORMAT                               
                    TO WS-NAME-FORMAT                                   
                 MOVE PARM-AT-FIRST-NAME                                
                    TO WS-FIRST-NAME                                    
                 MOVE PARM-AT-MIDDLE-NAME                               
                    TO WS-MIDDLE-NAME                                   
                 MOVE PARM-AT-LAST-NAME                                 
                    TO WS-LAST-NAME                                     
                 MOVE PARM-AT-TITLE-PREFIX                              
                    TO WS-TITLE-PREFIX                                  
                 MOVE PARM-AT-TITLE-SUFFIX-1                            
                    TO WS-TITLE-SUFFIX-1                                
                 MOVE PARM-AT-TITLE-SUFFIX-2                            
                    TO WS-TITLE-SUFFIX-2                                
                 MOVE PARM-AT-FULL-NAME                                 
                    TO WS-FULL-NAME                                     
                 PERFORM 8460-UPDATE-TBNAME   THRU 8460-EXIT            
              END-IF                                                    
           ELSE                                                         
              PERFORM 5041-GET-NEW-NAME-ID    THRU 5041-EXIT            
                                                                        
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
T12829        MOVE 'NAME TYPE'     TO MI-COLUMN-DESC                    
              MOVE WS-INS-NAME-ID  TO WS-NAME-ID-I                      
              MOVE WS-NAME-ID-I    TO WS-NAME-ID-S                      
                                                                        
T12829        EVALUATE PARM-AT-NAME-TYPE                                
T12829           WHEN 'AI'                                              
T12829              MOVE 'IN CARE OF NAME' TO MI-CHG-COLUMN-VALUE-TEXT  
T12829           WHEN 'AA'                                              
T12829              MOVE 'ATTENTION  NAME' TO MI-CHG-COLUMN-VALUE-TEXT  
T12829           WHEN 'AN'                                              
T12829              MOVE 'NAME ON BILL   ' TO MI-CHG-COLUMN-VALUE-TEXT  
T12829           WHEN 'DB'                                              
T12829              MOVE 'DOING BUS AS   ' TO MI-CHG-COLUMN-VALUE-TEXT  
T12829           WHEN OTHER                                             
T12829              MOVE PARM-AT-NAME-TYPE TO MI-CHG-COLUMN-VALUE-TEXT  
T12829        END-EVALUATE                                              
                                                                        
T12829        MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN         
T12829        MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT          
T12829        MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                TO WS-TRAN-APPL-NO                   
                                                                        
              MOVE PARM-AT-NAME-TYPE                                    
                 TO WS-NAME-TYPE                                        
              MOVE PARM-AT-NAME-FORMAT                                  
                 TO WS-NAME-FORMAT                                      
              MOVE PARM-AT-FIRST-NAME                                   
                 TO WS-FIRST-NAME                                       
              MOVE PARM-AT-MIDDLE-NAME                                  
                 TO WS-MIDDLE-NAME                                      
              MOVE PARM-AT-LAST-NAME                                    
                 TO WS-LAST-NAME                                        
              MOVE PARM-AT-TITLE-PREFIX                                 
                 TO WS-TITLE-PREFIX                                     
              MOVE PARM-AT-TITLE-SUFFIX-1                               
                 TO WS-TITLE-SUFFIX-1                                   
              MOVE PARM-AT-TITLE-SUFFIX-2                               
                 TO WS-TITLE-SUFFIX-2                                   
              MOVE PARM-AT-FULL-NAME                                    
                 TO WS-FULL-NAME                                        
              PERFORM 8600-INSERT-TBNAME      THRU 8600-EXIT            
              PERFORM 8620-INSERT-TBATBLNM    THRU 8620-EXIT            
              PERFORM 8640-INSERT-TBNMACTX    THRU 8640-EXIT            
              IF BILL-ADDR-XREF-EXISTS                                  
                 PERFORM 8540-UPDATE-TBBLADRX THRU 8540-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
                 IF PARM-AT-FIRST-NAME NOT = DQ-FIRST-NAME              
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'FIRST NAME'    TO MI-COLUMN-DESC              
                    MOVE +15             TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-FIRST-NAME                             
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-FIRST-NAME > SPACES                           
                       MOVE +15           TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-FIRST-NAME TO MI-PRV-COLUMN-VALUE-TEXT   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-FULL-NAME NOT = DQ-FULL-NAME                
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'FULL NAME'     TO MI-COLUMN-DESC              
                    MOVE +50             TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-FULL-NAME                              
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-FULL-NAME > SPACES                            
                       MOVE +50           TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-FULL-NAME  TO MI-PRV-COLUMN-VALUE-TEXT   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-LAST-NAME NOT = DQ-LAST-NAME                
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'LAST NAME'     TO MI-COLUMN-DESC              
                    MOVE +40             TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-LAST-NAME                              
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-LAST-NAME > SPACES                            
                       MOVE +40           TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-LAST-NAME  TO MI-PRV-COLUMN-VALUE-TEXT   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-MIDDLE-NAME NOT = DQ-MIDDLE-NAME            
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'MIDDLE NAME'   TO MI-COLUMN-DESC              
                    MOVE +15             TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-MIDDLE-NAME                            
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-MIDDLE-NAME > SPACES                          
                       MOVE +15           TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-MIDDLE-NAME                              
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-NAME-FORMAT NOT = DQ-NAME-FORMAT            
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'NAME FORMAT'  TO MI-COLUMN-DESC               
                    MOVE +1              TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-NAME-FORMAT                            
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-NAME-FORMAT > SPACES                          
                       MOVE +1            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-NAME-FORMAT                              
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-TITLE-PREFIX NOT = DQ-TITLE-PREFIX          
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'TITLE PREFIX'  TO MI-COLUMN-DESC              
                    MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-TITLE-PREFIX                           
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-TITLE-PREFIX > SPACES                         
                       MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-TITLE-PREFIX                             
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-TITLE-SUFFIX-1 NOT = DQ-TITLE-SUFFIX-1      
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'TITLE SUFFIX1' TO MI-COLUMN-DESC              
                    MOVE +3              TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-TITLE-SUFFIX-1                         
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-TITLE-SUFFIX-1 > SPACES                       
                       MOVE +3            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-TITLE-SUFFIX-1                           
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF                                                 
                                                                        
                 IF PARM-AT-TITLE-SUFFIX-2 NOT = DQ-TITLE-SUFFIX-2      
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO             
                    MOVE 'TITLE SUFFIX2' TO MI-COLUMN-DESC              
                    MOVE +3              TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-AT-TITLE-SUFFIX-2                         
                       TO MI-CHG-COLUMN-VALUE-TEXT                      
                    IF DQ-TITLE-SUFFIX-2 > SPACES                       
                       MOVE +3            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE DQ-TITLE-SUFFIX-2                           
                          TO MI-PRV-COLUMN-VALUE-TEXT                   
                    ELSE                                                
                       MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN    
                       MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT   
                    END-IF                                              
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                 TO WS-TRAN-APPL-NO            
                 END-IF.                                                
       5040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20304000
      * 5041-GET-NEW-NAME-ID                                           *20305000
      *                                                                *20306000
      *     CALLS 7251-LOCK-NAME-ID-CNTL                               *20307000
      *           7320-SELECT-NAME-ID-CNTL                             *20308000
      *           6210-CALCULATE-CHECK-DIGIT                           *20309000
      *                                                                *20320000
      *     CALLED FROM 5040-JRNL-ATTN-NAME                            *20351000
      *                                                                *20340000
      *     GETS THE NEW NAME ID VALUE FOR NAME INSERTS.               *20350000
      ******************************************************************20360000
                                                                        
       5041-GET-NEW-NAME-ID.                                            
                                                                        
           MOVE '5041' TO ACTIVE-PARAGRAPH.                             
                                                                        
*T4158     MOVE 'PANEL086'             TO WS-91-PANEL-NO.               
*T4158     MOVE PARM-USER-ID           TO WS-91-USERID.                 
*T4158     MOVE PARM-ACCOUNT-NO        TO WS-91-ACCOUNT-NO.             
*T4158     MOVE ZEROES                 TO WS-91-CUSTOMER-NO.            
*T4158     MOVE ZEROES                 TO WS-91-PREMISE-NO.             
                                                                        
*T4158     PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
*T4158     MOVE WS-91-NEW-NAME-ID      TO WS-INS-NAME-ID.               
                                                                        
                                                                        
       5041-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20570000
      * 5050-JRNL-BILL-NAME                                            *20580000
      *                                                                *20590000
      *     CALLS 6530-LOAD-MNT-TRANS-HIST                             *20600000
      *           5041-GET-NEW-NAME-ID                                 *20610000
      *           8600-INSERT-TBNAME                                   *20620000
      *           8640-INSERT-TBNMACTX                                 *20651000
      *           8460-UPDATE-TBNAME                                   *20640000
      *                                                                *20650000
      *     CALLED FROM 5000-UPDATE                                    *20660000
      *                                                                *20670000
      *     JOURNALS THE NAME ON BILL HEADER NAME.                     *20680000
      ******************************************************************20690000
                                                                        
       5050-JRNL-BILL-NAME.                                             
                                                                        
           MOVE '5050' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF ACCT-BILL-NME-EXISTS-FLAG = 'N'                           
              PERFORM 5041-GET-NEW-NAME-ID THRU 5041-EXIT               
                                                                        
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'NAME ON BILL'  TO MI-COLUMN-DESC                    
              MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN           
              MOVE WS-INS-NAME-ID  TO WS-NAME-ID-I                      
              MOVE WS-NAME-ID-I    TO WS-NAME-ID-S                      
              MOVE 'NEW NAME'      TO MI-CHG-COLUMN-VALUE-TEXT          
              MOVE +8              TO MI-PRV-COLUMN-VALUE-LEN           
              MOVE SPACES          TO MI-PRV-COLUMN-VALUE-TEXT          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                 TO WS-TRAN-APPL-NO                  
                                                                        
              MOVE PARM-NB-NAME-TYPE                                    
                 TO WS-NAME-TYPE                                        
              MOVE PARM-NB-NAME-FORMAT                                  
                 TO WS-NAME-FORMAT                                      
              MOVE PARM-NB-FIRST-NAME                                   
                 TO WS-FIRST-NAME                                       
              MOVE PARM-NB-MIDDLE-NAME                                  
                 TO WS-MIDDLE-NAME                                      
              MOVE PARM-NB-LAST-NAME                                    
                 TO WS-LAST-NAME                                        
              MOVE PARM-NB-TITLE-PREFIX                                 
                 TO WS-TITLE-PREFIX                                     
              MOVE PARM-NB-TITLE-SUFFIX-1                               
                 TO WS-TITLE-SUFFIX-1                                   
              MOVE PARM-NB-TITLE-SUFFIX-2                               
                 TO WS-TITLE-SUFFIX-2                                   
              MOVE PARM-NB-FULL-NAME                                    
                 TO WS-FULL-NAME                                        
              PERFORM 8600-INSERT-TBNAME   THRU 8600-EXIT               
              PERFORM 8620-INSERT-TBATBLNM THRU 8620-EXIT               
              PERFORM 8640-INSERT-TBNMACTX THRU 8640-EXIT               
           END-IF.                                                      
              IF PARM-NB-FIRST-NAME NOT = HOLD-FIRST-NAME               
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL FIRST NAME'  TO MI-COLUMN-DESC              
                 MOVE +15             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-FIRST-NAME                                
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-FIRST-NAME > SPACES                            
                    MOVE +15           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-FIRST-NAME                                
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-FULL-NAME NOT = HOLD-FULL-NAME                 
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL FULL NAME'     TO MI-COLUMN-DESC            
                 MOVE +50             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-FULL-NAME                                 
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-FULL-NAME > SPACES                             
                    MOVE +50           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-FULL-NAME                                 
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-LAST-NAME NOT = HOLD-LAST-NAME                 
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL LAST NAME'     TO MI-COLUMN-DESC            
                 MOVE +40             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-LAST-NAME                                 
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-LAST-NAME > SPACES                             
                    MOVE +40           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-LAST-NAME                                 
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-MIDDLE-NAME NOT = HOLD-MIDDLE-NAME             
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL MID NAME'   TO MI-COLUMN-DESC               
                 MOVE +15             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-MIDDLE-NAME                               
                     TO MI-CHG-COLUMN-VALUE-TEXT                        
                 IF HOLD-MIDDLE-NAME > SPACES                           
                    MOVE +15           TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-MIDDLE-NAME                               
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-NAME-FORMAT NOT = HOLD-NAME-FORMAT             
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL NAME FMT'   TO MI-COLUMN-DESC               
                 MOVE +1              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-NAME-FORMAT                               
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-NAME-FORMAT > SPACES                           
                    MOVE +1            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-NAME-FORMAT                               
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-TITLE-PREFIX NOT = HOLD-TITLE-PREFIX           
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL TITLE PREF'  TO MI-COLUMN-DESC              
                 MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-TITLE-PREFIX                              
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-TITLE-PREFIX > SPACES                          
                    MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-TITLE-PREFIX                              
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-TITLE-SUFFIX-1 NOT = HOLD-TITLE-SUFFIX-1       
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL TITLE SFX1' TO MI-COLUMN-DESC               
                 MOVE +3              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-TITLE-SUFFIX-1                            
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-TITLE-SUFFIX-1 > SPACES                        
                    MOVE +3            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-TITLE-SUFFIX-1                            
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
              IF PARM-NB-TITLE-SUFFIX-2 NOT = HOLD-TITLE-SUFFIX-2       
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'BILL TITLE SFX2' TO MI-COLUMN-DESC               
                 MOVE +3              TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE PARM-NB-TITLE-SUFFIX-2                            
                    TO MI-CHG-COLUMN-VALUE-TEXT                         
                 IF HOLD-TITLE-SUFFIX-2 > SPACES                        
                    MOVE +3            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE HOLD-TITLE-SUFFIX-2                            
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
                 ELSE                                                   
                    MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN       
                    MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
              END-IF                                                    
                                                                        
           IF ACCT-BILL-NME-EXISTS-FLAG = 'N'                           
              NEXT SENTENCE                                             
           ELSE                                                         
                                                                        
              MOVE HOLD-NAME-ID                                         
                 TO WS-NAME-ID-I                                        
              MOVE WS-NAME-ID-I                                         
                 TO WS-NAME-ID                                          
              MOVE PARM-NB-NAME-TYPE                                    
                 TO WS-NAME-TYPE                                        
              MOVE PARM-NB-NAME-FORMAT                                  
                 TO WS-NAME-FORMAT                                      
              MOVE PARM-NB-FIRST-NAME                                   
                 TO WS-FIRST-NAME                                       
              MOVE PARM-NB-MIDDLE-NAME                                  
                 TO WS-MIDDLE-NAME                                      
              MOVE PARM-NB-LAST-NAME                                    
                 TO WS-LAST-NAME                                        
              MOVE PARM-NB-TITLE-PREFIX                                 
                 TO WS-TITLE-PREFIX                                     
              MOVE PARM-NB-TITLE-SUFFIX-1                               
                 TO WS-TITLE-SUFFIX-1                                   
              MOVE PARM-NB-TITLE-SUFFIX-2                               
                 TO WS-TITLE-SUFFIX-2                                   
              MOVE PARM-NB-FULL-NAME                                    
                 TO WS-FULL-NAME                                        
              PERFORM 8460-UPDATE-TBNAME   THRU 8460-EXIT               
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22840000
      * 5060-DEL-ACCOUNT-DETAILS                                      * 22850000
      *                                                                *22860000
      *           8890-DELETE-TRADRFRE                                 *22870000
      *           5030-JRNL-ADDRESS-DETAILS                            *22880000
      *           6530-LOAD-MNT-TRANS-HIST                             *22890000
      *           8860-DELETE-TBBLADRX                                 *22900000
      *           8880-DELETE-TBADRFMT                                 *22910000
      *                                                                *22920000
      *     CALLED FROM 5000-UPDATE                                    *22921000
      *                                                                *22922000
      *     JOURNALS THE MAINTENANCE TRANSACTION DETAILS               *22922100
      ******************************************************************22922200
                                                                        
       5060-DEL-ACCOUNT-DETAILS.                                        
                                                                        
           MOVE '5060' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF AT-ADDRESS-FORMAT = 'A'                                   
              IF ((COUNT-NAME < 1) AND (COUNT-ADDR < 2))                
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
                 MOVE 'ADDR FORMATTED'  TO MI-COLUMN-DESC               
                 MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN        
                 MOVE AT-ADDRESS-ID   TO WS-ADDRESS-ID-I                
                 MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S                
T21717           MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT       
                 MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN        
                 MOVE 'ADDR DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT       
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
C37666*          PERFORM 8880-DELETE-TBADRFMT THRU 8880-EXIT            22924000
              END-IF                                                    
           ELSE                                                         
T21931        IF WS-LANDLORD-COUNT = 0 AND                              
T25068           WS-FREEFORM-COUNT < 2                                  
                     MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO            
                     MOVE 'ADDR FREEFORM' TO MI-COLUMN-DESC             
                     MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN    
                     MOVE AT-ADDRESS-ID   TO WS-ADDRESS-ID-I            
                     MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S            
T21717               MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT   
                     MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN    
                     MOVE 'ADDR DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT   
                     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT    
                     ADD 1 TO WS-TRAN-APPL-NO                           
C37666*              PERFORM 8890-DELETE-TBADRFRE THRU 8890-EXIT        22925400
T21931        END-IF                                                    
T20384        IF AT-CODE-PERM-BILL = 'D'                                
T20384            MOVE 'A' TO WS-CODE-PERM-BILL                         
T20384            PERFORM 8530-SET-PULL-CODE THRU 8530-EXIT             
T20384        END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE 'ADDRESS-FORMAT'        TO MI-COLUMN-DESC.              
           MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE AT-ADDRESS-FORMAT       TO MI-PRV-COLUMN-VALUE-TEXT.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                        TO WS-TRAN-APPL-NO.             
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
C32615     MOVE 'ADDRESS ID'            TO MI-COLUMN-DESC.              
           MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE +13                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE AT-ADDRESS-ID           TO WS-ADDRESS-ID-I.             
           MOVE WS-ADDRESS-ID-I         TO WS-ADDRESS-ID-S.             
T21717     MOVE WS-ADDRESS-ID-S         TO MI-PRV-COLUMN-VALUE-TEXT.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                        TO WS-TRAN-APPL-NO.             
                                                                        
           MOVE 0                       TO WS-INS-ADDRESS-ID.           
           MOVE SPACES                  TO PARM-ADDRESS-FORMAT.         
           PERFORM 8400-UPDATE-TBACCT THRU 8400-EXIT.                   
T25068     PERFORM 8860-DELETE-TBBLADRX THRU 8860-EXIT.                 
                                                                        
T13202     MOVE 'D'                 TO WS-RPC-ACTION.                   
T13202     PERFORM 5800-PROCESS-LL-UPDATES  THRU 5800-EXIT.             
                                                                        
       5060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22932000
      * 5070-DEL-BILL-HDR                                              *22935100
      *                                                                *22934000
      *     CALLS 6530-LOAD-MNT-TRANS-HIST                             *22935000
      *           8820-DELETE-TBATBLNM                                 *22936000
      *           8840-DELETE-TBNAME                                   *22937000
      *           8800-DELETE-TBNMACTX                                 *22938000
      *                                                                *22939000
      *     CALLED FROM 5000-UPDATE                                    *22940000
      *                                                                *22950000
      *     JOURNALS THE NAME ON BILL HEADER NAME.                     *22951000
      ******************************************************************22952000
                                                                        
       5070-DEL-BILL-HDR.                                               
                                                                        
           MOVE '5070' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'ATTN NAME ID'  TO MI-COLUMN-DESC.                      
           MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN.             
           MOVE AB-NAME-ID      TO WS-NAME-ID-I.                        
           MOVE WS-NAME-ID-I    TO WS-NAME-ID-S.                        
           MOVE 'NAME DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT.            
           MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN.             
           MOVE WS-NAME-ID-S    TO MI-PRV-COLUMN-VALUE-TEXT.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE AB-NAME-ID         TO WS-NAME-ID.                       
           MOVE AB-NAME-TYPE       TO WS-NAME-TYPE.                     
           PERFORM 8820-DELETE-TBATBLNM THRU 8820-EXIT.                 
A35665     PERFORM 8815-UPDATE-TBBILLADDRX THRU 8815-EXIT.              
           MOVE 'N' TO BILL-ADDR-XREF-EXISTS-FLAG.                      
A37666*    PERFORM 8840-DELETE-TBNAME  THRU  8840-EXIT.                 22959600
           PERFORM 8800-DELETE-TBNMACTX THRU 8800-EXIT.                 
                                                                        
       5070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22961000
      * 5080-DEL-BILL-NME                                              *22970000
      *                                                                *22971000
      *     CALLS 6530-LOAD-MNT-TRANS-HIST                             *22972000
      *           8820-DELETE-TBATBLNM                                 *22975100
      *           8840-DELETE-TBNAME                                   *22974000
      *           8800-DELETE-TBNMACTX                                 *22975000
      *                                                                *22976000
      *     CALLED FROM 5000-UPDATE                                    *22977000
      *                                                                *22978000
      *     JOURNALS THE NAME ON BILL HEADER NAME.                     *22979000
      ******************************************************************22980000
                                                                        
       5080-DEL-BILL-NME.                                               
                                                                        
           MOVE '5080' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'BILL NAME ID'       TO MI-COLUMN-DESC.                 
           MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN.             
           MOVE HOLD-NAME-ID    TO WS-NAME-ID-I.                        
           MOVE WS-NAME-ID-I    TO WS-NAME-ID-S.                        
           MOVE 'NAME DELETED'  TO MI-CHG-COLUMN-VALUE-TEXT.            
           MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN.             
           MOVE WS-NAME-ID-S    TO MI-PRV-COLUMN-VALUE-TEXT.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE HOLD-NAME-TYPE     TO WS-NAME-TYPE.                     
           MOVE HOLD-NAME-ID       TO WS-NAME-ID.                       
           PERFORM 8820-DELETE-TBATBLNM THRU 8820-EXIT.                 
A35665     PERFORM 8815-UPDATE-TBBILLADDRX THRU 8815-EXIT.              
           MOVE 'N' TO BILL-ADDR-XREF-EXISTS-FLAG.                      
A37666*    PERFORM 8840-DELETE-TBNAME THRU  8840-EXIT.                  22983100
           PERFORM 8800-DELETE-TBNMACTX THRU 8800-EXIT.                 
                                                                        
       5080-EXIT.                                                       
           EXIT.                                                        
                                                                        
TP9650******************************************************************22983701
TP9650* 5090-UPDATE-OTHER-ACCTS.                                       *22983801
TP9650******************************************************************22984801
TP9650                                                                  
TP9650 5090-UPDATE-OTHER-ACCTS.                                         
TP9650                                                                  
TP9650     MOVE '5090'              TO ACTIVE-PARAGRAPH.                
TP9650     MOVE WS-UPDATED-ADDR-ID  TO AQ-ADDRESS-ID                    
TP9650     PERFORM 7600-SEL-OTHER-ACCT-OPEN     THRU 7600-EXIT          
TP9650     PERFORM 7610-SEL-OTHER-ACCT-FETCH    THRU 7610-EXIT          
TP9650     PERFORM UNTIL (WS-ACTIVE-RETURN-CODE =  NOT-FOUND )          
TP9650         MOVE    1             TO WS-TRAN-APPL-NO                 
TP9650         MOVE    AQ-ACCOUNT-NO TO WS-ACCOUNT-NO-D                 
TP9650         IF WS-ACCOUNT-NO-D NOT EQUAL WS-PARM-ACCOUNT-NO-D        
C32615            ADD 1 TO WS-COUNT-ACCOUNTS                            
TP9650            PERFORM 5010-JRNL-TRAN-HEAD       THRU 5010-EXIT      
TP9650            MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO     
C32615            MOVE 'Y' TO WS-WRITE-TRANSHIST                        
TP9650            PERFORM 5031-WRITE-MI-RECORDS     THRU 5031-EXIT      
TP9650            PERFORM 8550-UPD-TBBLADRX         THRU 8550-EXIT      
TP9650            PERFORM 8400-UPDATE-TBACCT        THRU 8400-EXIT      
TP9650         END-IF                                                   
TP9650         PERFORM 7610-SEL-OTHER-ACCT-FETCH THRU 7610-EXIT         
TP9650     END-PERFORM.                                                 
TP9650     PERFORM 7620-SEL-OTHER-ACCT-CLOSE     THRU 7620-EXIT.        
TP9650                                                                  
      * IF ONLY ONE ACCOUNT UPDATED, SWITCH DISPLAY FROM                        
      * 'ALL' TO 'ONE'.  PARM IS 'ALL'.                                         
C32615     IF WS-COUNT-ACCOUNTS = 0                                     
C32615         PERFORM 8410-UPDATE-TRANSHIST THRU 8410-EXIT
           END-IF.            
C32615                                                                  
TP9650 5090-EXIT.                                                       
TP9650     EXIT.                                                        
                                                                        
      *****************************************************************         
T13202**  5800-PROCESS-LL-UPDATES                                    **         
      **                                                             **         
      *****************************************************************         
                                                                        
T13202 5800-PROCESS-LL-UPDATES.                                         
                                                                        
           MOVE AT-CUSTOMER-NO      TO SI-CUSTOMER-NO.                  
                                                                        
T19391     IF AT-ADDRESS-ID = ZERO                                      
T19391        MOVE PR-ADDRESS-ID   TO WS-LL-ADDR-ID                     
T19391     ELSE                                                         
T19391        MOVE AT-ADDRESS-ID   TO WS-LL-ADDR-ID                     
T19391     END-IF.                                                      
                                                                        
           PERFORM 7260-OPEN-LL-CURSOR               THRU 7260-EXIT.    
                                                                        
           PERFORM 7270-FETCH-LL-CURSOR              THRU 7270-EXIT.    
                                                                        
           PERFORM 5810-PROCESS-LL-DETAILS           THRU 5810-EXIT     
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
                                                                        
           PERFORM 7280-CLOSE-LL-CURSOR              THRU 7280-EXIT.    
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
T13202**  5810-PROCESS-LL-DETAILS                                    **         
      **                                                             **         
      *****************************************************************         
                                                                        
T13202 5810-PROCESS-LL-DETAILS.                                         
                                                                        
           IF BILL-ADDR-DELETE                                          
              MOVE PR-ADDRESS-ID    TO SI-ADDRESS-ID                    
              MOVE PR-ADDRESS-FORMAT                                    
                                    TO SI-ADDRESS-FORMAT                
              PERFORM 7700-UPDATE-LL-ADDR            THRU 7700-EXIT     
           ELSE                                                         
              IF BILL-ADDR-ADD                                          
                 MOVE WS-INS-ADDRESS-ID                                 
                                    TO SI-ADDRESS-ID                    
                 MOVE PARM-ADDRESS-FORMAT                               
                                    TO SI-ADDRESS-FORMAT                
                 PERFORM 7700-UPDATE-LL-ADDR         THRU 7700-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7270-FETCH-LL-CURSOR              THRU 7270-EXIT.    
                                                                        
       5810-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00547******************************************************************        
P00547* 5920-IAT-WQ.                                                   *        
P00547* CHECKS IF INTERNATIONAL ACH TRANSACTION WQ NEEDS TO BE SENT    *        
P00547******************************************************************        
P00547 5920-IAT-WQ.                                                     
P00547                                                                  
P00547     MOVE '5920'                    TO ACTIVE-PARAGRAPH.          
P00547                                                                  
P00547     MOVE 'N'                       TO WS-IAT-CAT-FOUND.          
P00547     PERFORM 7850-CHECK-IAT-CATEGORY THRU 7850-EXIT.              
P00547                                                                  
P00547     IF WS-IAT-CAT-FOUND = 'N'                                    
P00547                                                                  
ACT223       MOVE 423                       TO CATEGORY-ID-4675         
ACT223       MOVE SPACES                    TO RESP-AREA-ID-4675        
ACT223       MOVE ZERO                      TO SERV-ORDER-NO-4675       
ACT223       MOVE PARM-USER-ID              TO USER-ID-ORIG-4675        
ACT223       MOVE SPACES                    TO DATE-CREATED-4675        
ACT223       MOVE SPACES                    TO DATE-REQUIRED-4675       
ACT223       MOVE WS-ACCOUNT-NO-D           TO ACCOUNT-NO-4675          
ACT223       MOVE AT-PREMISE-NO             TO PREMISE-NO-4675          
ACT223       MOVE AT-CUSTOMER-NO            TO CUSTOMER-NO-4675         
ACT223       MOVE PR-LOCAL-OFFICE           TO LOCAL-OFFICE-4675        
ACT223       MOVE '4'                       TO ROUTING-CATEGORY-4675    
ACT223       MOVE 'N'                       TO WQ-PRIORITY-4675         
ACT223       MOVE WS-IAT-MESSAGE            TO COMMENTS-4675-TEXT       
ACT223       MOVE 51                        TO COMMENTS-4675-LEN        
ACT223       MOVE SPACES                    TO FREE-FORM-DATA-4675-TEXT 
ACT223       MOVE ZERO                      TO FREE-FORM-DATA-4675-LEN  
ACT223       MOVE PROGRAM-NAME              TO CREATED-BY-4675          
ACT223       PERFORM 4210-CALL-CSR04675     THRU 4210-EXIT              
P00547                                                                  
P00547     END-IF.                                                      
P00547                                                                  
P00547 5920-EXIT.                                                       
P00547     EXIT.                                                        
                                                                        
C36935     COPY CPD00004.                                                       
                                                                        
      ******************************************************************22989309
      *  CHECK DIGITS COPYBOOK.                                        *22989409
      ******************************************************************22989509
                                                                        
           EXEC SQL                                                     22989709
              INCLUDE CPD00071                                          22989809
           END-EXEC.                                                    22989909
                                                                        
*T4158     EXEC SQL                                                     22990109
*T4158        INCLUDE CPD00090                                          22990209
*T4158     END-EXEC.                                                    22990309
                                                                        
*T4158     EXEC SQL                                                     22990509
*T4158        INCLUDE CPD00091                                          22990609
*T4158     END-EXEC.                                                    22990709
                                                                        
HPCCDM*EJECT                                                            22990909
                                                                        
      ******************************************************************22991109
      *  JOURNALING COPYBOOK.                                          *22991209
      ******************************************************************22991309
                                                                        
           EXEC SQL                                                     22991509
              INCLUDE CPD00067                                          22991609
           END-EXEC.                                                    22991709
                                                                        
HPCCDM*EJECT                                                            22991909
                                                                        
      ******************************************************************22995100
      * 7000-SELECT-CUR-TIME-STATS                                     *25100000
      *                                                                *23010000
      *     CALLS 9000-SEND-ERROR-RESULT                               *23020000
      *           9900-SQL-ERROR-ROUTINE                               *23051000
      *                                                                *23040000
      *     CALLED FROM 5020-JRNL-TRAN-HEAD.                           *23050000
      *                                                                *23060000
      *     SELECTS FROM TABLE CSS_MODEL_SQL.                          *23070000
      ******************************************************************23080000
                                                                        
       7000-SELECT-CUR-TIME-STATS.                                      
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
C32615        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-TRANS-HIST-SEQ-NO                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
C32615        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'VALUES'                     TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23350000
      * 7040-SELECT-RESP-AREA-ID                                       *23360000
      *                                                                *23370000
      *     CALLS 9000-SEND-ERROR-RESULT                               *23380000
      *           9900-SQL-ERROR-ROUTINE                               *23390000
      *                                                                *23400000
      *     CALLED FROM 5020-JRNL-TRAN-HEAD.                           *23410000
      *                                                                *23420000
      *     SELECTS FROM TABLE CSS_USER_PROFILE.                       *23451000
      ******************************************************************23440000
                                                                        
       7040-SELECT-RESP-AREA-ID.                                        
                                                                        
           MOVE '7040' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  RESP_AREA_ID                                      
              INTO    :WS-RESP-AREA-ID                                  
              FROM    CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID                   = :PARM-USER-ID         
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23500000
MFA-TR*       SELECT  RESP_AREA_ID                                      23510000
MFA-TR*       INTO    :WS-RESP-AREA-ID                                  23520000
MFA-TR*       FROM    CSS_USER_PROFILE                                  23551000
MFA-TR*       WHERE   USER_ID                   = :PARM-USER-ID         23540000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    23550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE PARM-USER-ID                 TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
T12649******************************************************************23740000
T21091* 7100-SELECT-PREMISE                                            *23750000
T21091*                                                                *23760000
T21091*     CALLS 9000-SEND-ERROR-RESULT                               *23770000
T21091*           9900-SQL-ERROR-ROUTINE                               *23780000
T21091*                                                                *23790000
T21091*     CALLED FROM 5021-CHECK-FOR-MATCH                           *23800000
T21091*                                                                *23810000
T21091******************************************************************23850000
T21091 7100-SELECT-PREMISE.                                             
T21091                                                                  
T21091     MOVE '7100' TO ACTIVE-PARAGRAPH.                             
T21091     EXEC SQL                                                     
T21091         SELECT TOP(1) 'Y'                                               
T21091           INTO :WS-PREMISE-FOUND-FLAG                            
T21091           FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
T21091          WHERE ADDRESS_ID = :WS-MATCH-ADDRESS-ID                 
T22104            AND LOCATOR_ID >= ' '                                 
C32615                                           
C32615                                                           
T21091     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-PREMISE-FOUND-FLAG                                    
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE ADDRESS_ID = :WS-MATCH-ADDRESS-ID                         
MFA-TR*           AND LOCATOR_ID >= ' '                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21091     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21091     EVALUATE WS-ACTIVE-RETURN-CODE                               
T21091         WHEN SUCCESSFUL-CALL                                     
T21091             MOVE 'N' TO WS-MATCH-FOUND-FLAG                      
T21091         WHEN NOT-FOUND                                           
T21091             MOVE 'Y' TO WS-MATCH-FOUND-FLAG                      
T21091         WHEN OTHER                                               
T21091             MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
T21091             MOVE 'SELECT'                TO ABEND-FUNCTION       
T21091             MOVE SPACES                  TO ABEND-SQL-PREDICATES 
T21091                                             ABEND-TABLES         
T21091             MOVE 'CSS_PREMISE'           TO TABLE-1              
T21091             MOVE 'ADDRESS-ID'            TO TABLE-ELEMENT-1      
T21091             MOVE 'ACCOUNT-NO'            TO TABLE-ELEMENT-2      
T21091             MOVE WS-MATCH-ADDRESS-ID     TO HOSTVAR-ELEMENT-1    
T21091             MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2    
T21091             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
T21091             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
T21091     END-EVALUATE.                                                
T21091                                                                  
T21091 7100-EXIT.                                                       
T21091     EXIT.                                                        
T21091                                                                  
T21091******************************************************************23740000
T21091* 7110-SELECT-ACCOUNT                                            *23750000
T21091*                                                                *23760000
T21091*     CALLS 9000-SEND-ERROR-RESULT                               *23770000
T21091*           9900-SQL-ERROR-ROUTINE                               *23780000
T21091*                                                                *23790000
T21091*     CALLED FROM 5021-CHECK-FOR-MATCH                           *23800000
T21091*                                                                *23810000
T21091******************************************************************23850000
T21091 7110-SELECT-ACCOUNT.                                             
T21091                                                                  
T21091     MOVE '7110' TO ACTIVE-PARAGRAPH.                             
T21091     EXEC SQL                                                     
T21091         SELECT TOP(1) 'Y'                                               
T21091           INTO :WS-XREF-FOUND-FLAG                               
T21091           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T21091          WHERE ADDRESS_ID = :WS-MATCH-ADDRESS-ID                 
T21091            AND ADDRESS_FORMAT = 'A'                              
T21091            AND CUSTOMER_NO = :AT-CUSTOMER-NO                     
C32615                                           
C32615                                                           
T21091     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-XREF-FOUND-FLAG                                       
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ADDRESS_ID = :WS-MATCH-ADDRESS-ID                         
MFA-TR*           AND ADDRESS_FORMAT = 'A'                                      
MFA-TR*           AND CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21091     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21091     EVALUATE WS-ACTIVE-RETURN-CODE                               
T21091         WHEN SUCCESSFUL-CALL                                     
T21091             MOVE 'Y' TO WS-MATCH-FOUND-FLAG                      
T21091         WHEN NOT-FOUND                                           
T21091             MOVE 'N' TO WS-MATCH-FOUND-FLAG                      
T21091         WHEN OTHER                                               
T21091             MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
T21091             MOVE 'SELECT'                TO ABEND-FUNCTION       
T21091             MOVE SPACES                  TO ABEND-SQL-PREDICATES 
T21091                                             ABEND-TABLES         
T21091             MOVE 'CSS_NAME_ACCT_XREF'    TO TABLE-1              
T21091             MOVE 'ADDRESS-ID'            TO TABLE-ELEMENT-1      
T21091             MOVE 'ACCOUNT-NO'            TO TABLE-ELEMENT-2      
T21091             MOVE 'CUSTOMER-NO'           TO TABLE-ELEMENT-3      
T21091             MOVE WS-MATCH-ADDRESS-ID     TO HOSTVAR-ELEMENT-1    
T21091             MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2    
T21091             MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-3    
T21091             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
T21091             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
T21091     END-EVALUATE.                                                
T21091                                                                  
T21091 7110-EXIT.                                                       
T21091     EXIT.                                                        
T21091                                                                  
T12649******************************************************************23740000
T12649* 7210-OPEN-EXACT-MATCH                                          *23750000
T12649*                                                                *23760000
T12649*     CALLS 9000-SEND-ERROR-RESULT                               *23770000
T12649*           9900-SQL-ERROR-ROUTINE                               *23780000
T12649*                                                                *23790000
T12649*     CALLED FROM 5021-CHECK-FOR-MATCH                           *23800000
T12649*                                                                *23810000
T12649******************************************************************23850000
                                                                        
T12649 7210-OPEN-EXACT-MATCH.                                           
                                                                        
           MOVE '7210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN EXACT-MATCH-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
CBSI          MOVE 'HOUSE_NO'                   TO TABLE-ELEMENT-1      
CBSI          MOVE 'STREET_NAME'                TO TABLE-ELEMENT-2      
CBSI          MOVE 'STREET_SUFFIX'              TO TABLE-ELEMENT-3      
CBSI          MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-4      
CBSI          MOVE PARM-FO-HOUSE-NO             TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-FO-STREET-NAME          TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-FO-STREET-SUFFIX        TO HOSTVAR-ELEMENT-3    
CBSI          MOVE PARM-FO-ZIP-CODE             TO HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
T12649******************************************************************23740000
T12649* 7220-FETCH-EXACT-MATCH                                         *23750000
T12649*                                                                *23760000
T12649*     CALLS 9000-SEND-ERROR-RESULT                               *23770000
T12649*           9900-SQL-ERROR-ROUTINE                               *23780000
T12649*                                                                *23790000
T12649*     CALLED FROM 5021-CHECK-FOR-MATCH                           *23800000
T12649*                                                                *23810000
T12649******************************************************************23850000
                                                                        
T12649 7220-FETCH-EXACT-MATCH.                                          
                                                                        
           MOVE '7220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH EXACT-MATCH-CSR                                     
                INTO   :WS-MATCH-FOUND-FLAG,                            
                       :WS-MATCH-ADDRESS-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
CBSI          MOVE 'HOUSE_NO'                   TO TABLE-ELEMENT-1      
CBSI          MOVE 'STREET_NAME'                TO TABLE-ELEMENT-2      
CBSI          MOVE 'STREET_SUFFIX'              TO TABLE-ELEMENT-3      
CBSI          MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-4      
CBSI          MOVE PARM-FO-HOUSE-NO             TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-FO-STREET-NAME          TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-FO-STREET-SUFFIX        TO HOSTVAR-ELEMENT-3    
CBSI          MOVE PARM-FO-ZIP-CODE             TO HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
T12649******************************************************************23740000
T12649* 7230-CLOSE-EXACT-MATCH                                         *23750000
T12649*                                                                *23760000
T12649*     CALLS 9000-SEND-ERROR-RESULT                               *23770000
T12649*           9900-SQL-ERROR-ROUTINE                               *23780000
T12649*                                                                *23790000
T12649*     CALLED FROM 5021-CHECK-FOR-MATCH                           *23800000
T12649*                                                                *23810000
T12649******************************************************************23850000
                                                                        
T12649 7230-CLOSE-EXACT-MATCH.                                          
                                                                        
           MOVE '7230' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE EXACT-MATCH-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
CBSI          MOVE 'HOUSE_NO'                   TO TABLE-ELEMENT-1      
CBSI          MOVE 'STREET_NAME'                TO TABLE-ELEMENT-2      
CBSI          MOVE 'STREET_SUFFIX'              TO TABLE-ELEMENT-3      
CBSI          MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-4      
CBSI          MOVE PARM-FO-HOUSE-NO             TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-FO-STREET-NAME          TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-FO-STREET-SUFFIX        TO HOSTVAR-ELEMENT-3    
CBSI          MOVE PARM-FO-ZIP-CODE             TO HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23740000
T13202* 7260-OPEN-LL-CURSOR                                            *23750000
      *                                                                *23760000
      ******************************************************************23850000
                                                                        
T13202 7260-OPEN-LL-CURSOR.                                             
                                                                        
           MOVE '7260' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              OPEN LANDLORD-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_LANDLORD'               TO TABLE-1              
CBSI          MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE SI-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23740000
T13202* 7270-FETCH-LL-CURSOR                                           *23750000
      *                                                                *23760000
      ******************************************************************23850000
                                                                        
T13202 7270-FETCH-LL-CURSOR.                                            
                                                                        
           MOVE '7270' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              FETCH LANDLORD-CSR                                        
                INTO   :SI-ADDRESS-ID,                                  
                       :SI-ADDRESS-FORMAT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_LANDLORD'               TO TABLE-1              
CBSI          MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE SI-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23740000
T13202* 7280-CLOSE-LL-CURSOR                                           *23750000
      *                                                                *23760000
      ******************************************************************23850000
                                                                        
T13202 7280-CLOSE-LL-CURSOR.                                            
                                                                        
           MOVE '7280' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              CLOSE LANDLORD-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_LANDLORD'               TO TABLE-1              
CBSI          MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE SI-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************25710000
      * 7360-SELECT-PREM-DTLS                                          *25720000
      *                                                                *25751000
      *     CALLS 9000-SEND-ERROR-RESULT                               *25740000
      *           9900-SQL-ERROR-ROUTINE                               *25750000
      *                                                                *25760000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *25770000
      *                                                                *25780000
      *     RETRIEVES PREMISE DETAILS FROM CSS_PREMISE TO POPULATE NEW *25790000
      *     ROWS IN TABLE CSS_NAME_ACCT_XREF.                          *25800000
      ******************************************************************25810000
                                                                        
       7360-SELECT-PREM-DTLS.                                           
                                                                        
           MOVE '7360' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT   ADDRESS_ID,                                      
T13202                 ADDRESS_FORMAT,                                  
T22301                 LOCAL_OFFICE                                     
              INTO     :PR-ADDRESS-ID,                                  
T13202                 :PR-ADDRESS-FORMAT,                              
T22301                 :PR-LOCAL-OFFICE                                 
              FROM     CSS_PREMISE WITH(READUNCOMMITTED)                        
              WHERE    PREMISE_NO               = :AT-PREMISE-NO        
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25870000
MFA-TR*       SELECT   ADDRESS_ID,                                      25880000
MFA-TR*                ADDRESS_FORMAT,                                          
MFA-TR*                LOCAL_OFFICE                                             
MFA-TR*       INTO     :PR-ADDRESS-ID,                                  25890000
MFA-TR*                :PR-ADDRESS-FORMAT,                                      
MFA-TR*                :PR-LOCAL-OFFICE                                         
MFA-TR*       FROM     CSS_PREMISE                                      25900000
MFA-TR*       WHERE    PREMISE_NO               = :AT-PREMISE-NO        25910000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    25920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_PREMISE'                TO TABLE-1              
              MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AT-PREMISE-NO                TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************26151000
      * 7400-SELECT-NAME-ID                                            *26140000
      *                                                                *26150000
      *     CALLS 9000-SEND-ERROR-RESULT                               *26160000
      *           9900-SQL-ERROR-ROUTINE                               *26170000
      *                                                                *26180000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *26190000
      *                 5200-PROCESS-NB-NAME                           *26200000
      *                                                                *26210000
      *     RETRIEVES THE NAME_ID ACCORDING TO THE ACCOUNT_NO IN THE   *26220000
      *     TABLE CSS_ACCT_BILL_NMES.                                  *26251000
      ******************************************************************26240000
                                                                        
       7400-SELECT-NAME-ID.                                             
                                                                        
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT   NAME_ID                                          
              INTO     :AB-NAME-ID                                      
              FROM     CSS_ACCT_BILL_NMES WITH(READUNCOMMITTED)                 
              WHERE    ACCOUNT_NO               = :WS-ACCOUNT-NO-D      
              AND      NAME_TYPE                = :WS-NAME-TYPE         
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26510000
MFA-TR*       SELECT   NAME_ID                                          26310000
MFA-TR*       INTO     :AB-NAME-ID                                      26320000
MFA-TR*       FROM     CSS_ACCT_BILL_NMES                               26351000
MFA-TR*       WHERE    ACCOUNT_NO               = :WS-ACCOUNT-NO-D      26340000
MFA-TR*       AND      NAME_TYPE                = :WS-NAME-TYPE         26350000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    26360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'NAME_TYPE'                  TO TABLE-ELEMENT-2      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE WS-NAME-TYPE                 TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************26550000
      * 7420-SELECT-CUST-NAME-ID                                       *26560000
      *                                                                *26570000
      *     CALLS 9000-SEND-ERROR-RESULT                               *26580000
      *           9900-SQL-ERROR-ROUTINE                               *26590000
      *                                                                *26600000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *26610000
      *                                                                *26620000
      *     RETRIEVES THE CUSTOMER NAME_ID IN ORDER TO POPULATE A ROW  *26651000
      *     IN TABLE CSS_ACCT_NAME_XREF.                               *26640000
      ******************************************************************26650000
                                                                        
       7420-SELECT-CUST-NAME-ID.                                        
                                                                        
           MOVE '7420' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT   NAME_ID                                          
              INTO     :CU-NAME-ID                                      
              FROM     CSS_CUSTOMER WITH(READUNCOMMITTED)                       
              WHERE    CUSTOMER_NO              = :AT-CUSTOMER-NO       
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26710000
MFA-TR*       SELECT   NAME_ID                                          26720000
MFA-TR*       INTO     :CU-NAME-ID                                      26751000
MFA-TR*       FROM     CSS_CUSTOMER                                     26740000
MFA-TR*       WHERE    CUSTOMER_NO              = :AT-CUSTOMER-NO       26750000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    26760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_CUSTOMER'               TO TABLE-1              
              MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AT-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************26970000
      * 7440-SELECT-COUNT-BILL-ADDR                                    *26980000
      *                                                                *26990000
      *     CALLS 9000-SEND-ERROR-RESULT                               *27000000
      *           9900-SQL-ERROR-ROUTINE                               *27010000
      *                                                                *27020000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *27051000
      *                                                                *27040000
      *     COUNTS THE NUMBER OF BILL ADDRESS WITH THE SAME ADDRESS_ID *27050000
      *     IN THE TABLE CSS_BILL_ADDR_XREF.                           *27060000
      ******************************************************************27070000
                                                                        
       7440-SELECT-COUNT-BILL-ADDR.                                     
                                                                        
           MOVE '7440' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT   COUNT(*)                                         
              INTO     :COUNT-ADDR                                      
              FROM     CSS_BILL_ADDR_XREF WITH(READUNCOMMITTED)                 
              WHERE    ADDRESS_ID               = :AT-ADDRESS-ID        
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27151000
MFA-TR*       SELECT   COUNT(*)                                         27140000
MFA-TR*       INTO     :COUNT-ADDR                                      27150000
MFA-TR*       FROM     CSS_BILL_ADDR_XREF                               27160000
MFA-TR*       WHERE    ADDRESS_ID               = :AT-ADDRESS-ID        27170000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    27180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AT-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************27390000
T21931* 7460-SELECT-COUNT-LANDLORD.                                    *27400000
T21931*                                                                *27410000
T21931*     CALLS 9000-SEND-ERROR-RESULT                               *27420000
T21931*           9900-SQL-ERROR-ROUTINE                               *27451000
T21931*                                                                *27440000
T21931*     CALLED FROM 2300-FIND-OLD-VALUES                           *27450000
T21931*                                                                *27460000
T21931*     SELECTS FROM TABLE CSS_LANDLORD.                           *27470000
T21931******************************************************************27480000
T21931 7460-SELECT-COUNT-LANDLORD.                                      
T21931                                                                  
T21931     MOVE '7460'                        TO ACTIVE-PARAGRAPH.      
T21931                                                                  
T21931     EXEC SQL                                                     
T21931        SELECT COUNT(*)                                           
T21931          INTO :WS-LANDLORD-COUNT                                 
T21931          FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
T21931         WHERE ADDRESS_ID = :SI-ADDRESS-ID                        
C32615                                                           
T21931     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-LANDLORD-COUNT                                         
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE ADDRESS_ID = :SI-ADDRESS-ID                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21931                                                                  
T21931     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T21931                                                                  
T21931     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T21931        NEXT SENTENCE                                             
T21931     ELSE                                                         
T21931        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T21931        MOVE 'SELECT'                     TO ABEND-FUNCTION       
T21931        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
T21931                                             ABEND-TABLES         
T21931        MOVE 'CSS_LANDLORD'               TO TABLE-1              
T21931        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
T21931        MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
T21931        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T21931        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T21931     END-IF.                                                      
T21931                                                                  
T21931 7460-EXIT.                                                       
T21931     EXIT.                                                        
                                                                        
      ******************************************************************27390000
T25068* 7470-SELECT-COUNT-LANDLORD.                                    *27400000
T25068*                                                                *27410000
T25068*     CALLS 9000-SEND-ERROR-RESULT                               *27420000
T25068*           9900-SQL-ERROR-ROUTINE                               *27451000
T25068*                                                                *27440000
T25068*     CALLED FROM 2300-FIND-OLD-VALUES                           *27450000
T25068*                                                                *27460000
T25068*     SELECTS FROM TABLE CSS_ACCOUNT.                            *27470000
T25068******************************************************************27480000
T25068 7470-SELECT-COUNT-FREEFORM.                                      
T25068                                                                  
T25068     MOVE '7470'                        TO ACTIVE-PARAGRAPH.      
T25068                                                                  
T25068     EXEC SQL                                                     
T25068        SELECT COUNT(*)                                           
T25068          INTO :WS-FREEFORM-COUNT                                 
T25068          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
T25068         WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
C32615                                                           
T25068     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-FREEFORM-COUNT                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25068                                                                  
T25068     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T25068                                                                  
T25068     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T25068        NEXT SENTENCE                                             
T25068     ELSE                                                         
T25068        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T25068        MOVE 'SELECT'                     TO ABEND-FUNCTION       
T25068        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
T25068                                             ABEND-TABLES         
T25068        MOVE 'CSS_ACCOUNT'                TO TABLE-1              
T25068        MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
T25068        MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
T25068        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T25068        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T25068     END-IF.                                                      
T25068                                                                  
T25068 7470-EXIT.                                                       
T25068     EXIT.                                                        
                                                                        
      ******************************************************************27390000
      * 7500-SELECT-ACCOUNT                                            *27400000
      *                                                                *27410000
      *     CALLS 9000-SEND-ERROR-RESULT                               *27420000
      *           9900-SQL-ERROR-ROUTINE                               *27451000
      *                                                                *27440000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *27450000
      *                                                                *27460000
      *     SELECTS FROM TABLE CSS_ACCOUNT.                            *27470000
      ******************************************************************27480000
                                                                        
       7500-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  ADDRESS_FORMAT,                                   
                      ADDRESS_ID,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
T12727                CODE_ACCT_STAT,                                   
T20384                CODE_PERM_BILL,                                   
P00594                ACCOUNT_TYPE_CODE,                                
P00594                CODE_ACCT_STAT                                    
              INTO    :AT-ADDRESS-FORMAT,                               
                      :AT-ADDRESS-ID,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO,                                   
                      :AT-COMPANY-NO,                                   
T12727                :AT-CODE-ACCT-STAT,                               
T20384                :AT-CODE-PERM-BILL,                               
P00594                :AT-ACCOUNT-TYPE-CODE,                            
P00594                :AT-CODE-ACCT-STAT                                
              FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                         
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27540000
MFA-TR*       SELECT  ADDRESS_FORMAT,                                   27550000
MFA-TR*               ADDRESS_ID,                                       27560000
MFA-TR*               CUSTOMER_NO,                                      27570000
MFA-TR*               PREMISE_NO,                                       27580000
MFA-TR*               COMPANY_NO,                                       27590000
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               CODE_PERM_BILL,                                           
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CODE_ACCT_STAT                                            
MFA-TR*       INTO    :AT-ADDRESS-FORMAT,                               27600000
MFA-TR*               :AT-ADDRESS-ID,                                   27610000
MFA-TR*               :AT-CUSTOMER-NO,                                  27620000
MFA-TR*               :AT-PREMISE-NO,                                   27651000
MFA-TR*               :AT-COMPANY-NO,                                   27640000
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-CODE-PERM-BILL,                                       
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-CODE-ACCT-STAT                                        
MFA-TR*       FROM    CSS_ACCOUNT                                       27650000
MFA-TR*       WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     27660000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    27670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCOUNT'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************27860000
      * 7510-SELECT-ADDR-FORMATTED                                     *27870000
      *                                                                *27880000
      *     CALLS 9000-SEND-ERROR-RESULT                               *27890000
      *           9900-SQL-ERROR-ROUTINE                               *27900000
      *                                                                *27910000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *27920000
      *                                                                *27951000
      *     SELECTS FROM TABLE CSS_ADDR_FORMATTED.                     *27940000
      ******************************************************************27950000
                                                                        
       7510-SELECT-ADDR-FORMATTED.                                      
                                                                        
           MOVE '7510' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  'Y',                                              
                      ADDRESS_ID,                                       
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      HOUSE_NO,                                         
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN                                    
              INTO    :ADDR-FORM-EXISTS-FLAG,                           
                      :DY-ADDRESS-ID,                                   
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-HOUSE-NO,                                     
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN                                
              FROM    CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
              WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28010000
MFA-TR*       SELECT  'Y',                                              28020000
MFA-TR*               ADDRESS_ID,                                       28051000
MFA-TR*               ADDR_PREFIX_1,                                    28040000
MFA-TR*               ADDR_PREFIX_2,                                    28050000
MFA-TR*               ADDRESS_OVERFLOW,                                 28060000
MFA-TR*               CARRIER_ROUTE,                                    28070000
MFA-TR*               HOUSE_NO,                                         28080000
MFA-TR*               STREET_LOCATION_1,                                28090000
MFA-TR*               STREET_LOCATION_2,                                28100000
MFA-TR*               STREET_NAME,                                      28110000
MFA-TR*               STREET_SUFFIX,                                    28120000
MFA-TR*               ZIP_CODE,                                         28151000
MFA-TR*               ZIP_CODE_PLUS_FOUR,                               28140000
MFA-TR*               ZIP_CODE_TOKEN                                    28150000
MFA-TR*       INTO    :ADDR-FORM-EXISTS-FLAG,                           28160000
MFA-TR*               :DY-ADDRESS-ID,                                   28170000
MFA-TR*               :DY-ADDR-PREFIX-1,                                28180000
MFA-TR*               :DY-ADDR-PREFIX-2,                                28190000
MFA-TR*               :DY-ADDRESS-OVERFLOW,                             28200000
MFA-TR*               :DY-CARRIER-ROUTE,                                28210000
MFA-TR*               :DY-HOUSE-NO,                                     28220000
MFA-TR*               :DY-STREET-LOCATION-1,                            28251000
MFA-TR*               :DY-STREET-LOCATION-2,                            28240000
MFA-TR*               :DY-STREET-NAME,                                  28250000
MFA-TR*               :DY-STREET-SUFFIX,                                28260000
MFA-TR*               :DY-ZIP-CODE,                                     28270000
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                           28280000
MFA-TR*               :DY-ZIP-CODE-TOKEN                                28290000
MFA-TR*       FROM    CSS_ADDR_FORMATTED                                28510000
MFA-TR*       WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       28310000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AT-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************28551000
      * 7520-SELECT-ADDR-FREEFORM                                      *28540000
      *                                                                *28550000
      *     CALLS 9000-SEND-ERROR-RESULT                               *28560000
      *           9900-SQL-ERROR-ROUTINE                               *28570000
      *                                                                *28580000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *28590000
      *                                                                *28600000
      *     SELECTS FROM TABLE CSS_ADDR_FREEFORM.                      *28610000
      ******************************************************************28620000
                                                                        
       7520-SELECT-ADDR-FREEFORM.                                       
                                                                        
           MOVE '7520' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  'Y',                                              
                      ADDR_CITY_STATE,                                  
                      ADDR_COUNTRY,                                     
                      ADDR_STREET,                                      
                      ADDR_ZIP_CODE,                                    
                      ADDRESS_OVERFLOW                                  
              INTO    :ADDR-FREE-EXISTS-FLAG,                           
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-COUNTRY,                                 
                      :DZ-ADDR-STREET,                                  
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDRESS-OVERFLOW                              
              FROM    CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
              WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28680000
MFA-TR*       SELECT  'Y',                                              28690000
MFA-TR*               ADDR_CITY_STATE,                                  28700000
MFA-TR*               ADDR_COUNTRY,                                     28710000
MFA-TR*               ADDR_STREET,                                      28720000
MFA-TR*               ADDR_ZIP_CODE,                                    28751000
MFA-TR*               ADDRESS_OVERFLOW                                  28740000
MFA-TR*       INTO    :ADDR-FREE-EXISTS-FLAG,                           28750000
MFA-TR*               :DZ-ADDR-CITY-STATE,                              28760000
MFA-TR*               :DZ-ADDR-COUNTRY,                                 28770000
MFA-TR*               :DZ-ADDR-STREET,                                  28780000
MFA-TR*               :DZ-ADDR-ZIP-CODE,                                28790000
MFA-TR*               :DZ-ADDRESS-OVERFLOW                              28800000
MFA-TR*       FROM    CSS_ADDR_FREEFORM                                 28810000
MFA-TR*       WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       28820000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28851000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AT-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29040000
      * 7540-SELECT-ACCT-BILL-HDR                                      *29050000
      *                                                                *29060000
      *     CALLS 9000-SEND-ERROR-RESULT                               *29070000
      *           9900-SQL-ERROR-ROUTINE                               *29080000
      *                                                                *29090000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *29100000
      *                                                                *29110000
      *     SELECTS FROM TABLE CSS_ACCT_BILL_NMES (AI OR AA VALUES).   *29120000
      ******************************************************************29151000
                                                                        
       7540-SELECT-ACCT-BILL-HDR.                                       
                                                                        
           MOVE '7540' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  'Y',                                              
                      NAME_ID,                                          
                      NAME_TYPE                                         
              INTO    :ACCT-BILL-HDR-EXISTS-FLAG,                       
                      :AB-NAME-ID,                                      
                      :AB-NAME-TYPE                                     
              FROM    CSS_ACCT_BILL_NMES WITH(READUNCOMMITTED)                  
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     
              AND     (NAME_TYPE = 'AA' OR NAME_TYPE = 'AI')            
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29190000
MFA-TR*       SELECT  'Y',                                              29200000
MFA-TR*               NAME_ID,                                          29210000
MFA-TR*               NAME_TYPE                                         29220000
MFA-TR*       INTO    :ACCT-BILL-HDR-EXISTS-FLAG,                       29251000
MFA-TR*               :AB-NAME-ID,                                      29240000
MFA-TR*               :AB-NAME-TYPE                                     29250000
MFA-TR*       FROM    CSS_ACCT_BILL_NMES                                29260000
MFA-TR*       WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     29270000
MFA-TR*       AND     (NAME_TYPE = 'AA' OR NAME_TYPE = 'AI')            29280000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    29290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29480000
      * 7545-SELECT-ACCT-BILL-NME                                      *29490000
      *                                                                *29500000
      *     CALLS 9000-SEND-ERROR-RESULT                               *29510000
      *           9900-SQL-ERROR-ROUTINE                               *29520000
      *                                                                *29551000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *29540000
      *                                                                *29550000
      *     SELECTS FROM TABLE CSS_ACCT_BILL_NMES (AN VALUE).          *29560000
      ******************************************************************29570000
                                                                        
       7545-SELECT-ACCT-BILL-NME.                                       
                                                                        
           MOVE '7545' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  'Y',                                              
                      NAME_ID,                                          
                      NAME_TYPE                                         
              INTO    :ACCT-BILL-NME-EXISTS-FLAG,                       
                      :HOLD-NAME-ID,                                    
                      :HOLD-NAME-TYPE                                   
              FROM    CSS_ACCT_BILL_NMES WITH(READUNCOMMITTED)                  
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     
              AND     (NAME_TYPE = 'AN')                                
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29651000
MFA-TR*       SELECT  'Y',                                              29640000
MFA-TR*               NAME_ID,                                          29650000
MFA-TR*               NAME_TYPE                                         29660000
MFA-TR*       INTO    :ACCT-BILL-NME-EXISTS-FLAG,                       29670000
MFA-TR*               :HOLD-NAME-ID,                                    29680000
MFA-TR*               :HOLD-NAME-TYPE                                   29690000
MFA-TR*       FROM    CSS_ACCT_BILL_NMES                                29700000
MFA-TR*       WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     29710000
MFA-TR*       AND     (NAME_TYPE = 'AN')                                29720000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    29751000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7545-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29920000
      * 7546-SELECT-BILL-ADDR-XREF                                     *29951000
      *                                                                *29940000
      *     CALLS 9000-SEND-ERROR-RESULT                               *29950000
      *           9900-SQL-ERROR-ROUTINE                               *29960000
      *                                                                *29970000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *29980000
      *                                                                *29990000
      *     SELECTS FROM TABLE CSS_BILL_ADDR_XREF                      *51000000
      ******************************************************************30010000
                                                                        
       7546-SELECT-BILL-ADDR-XREF.                                      
                                                                        
           MOVE '7546' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              NAME_ID,
              COMPANY_NO,
              ACCOUNT_NO,
              ADDRESS_ID                                        
              INTO    :BILL-ADDR-XREF-EXISTS-FLAG,                      
C37298                :WS-AQ-NAME-ID,                                   
C37298                :WS-AQ-COMPANY-NO,                                
C37298                :WS-AQ-ACCOUNT-NO,                                
C37298                :WS-AQ-ADDRESS-ID                                 
              FROM    CSS_BILL_ADDR_XREF WITH(READUNCOMMITTED)                  
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     
C32615                                                           
C32615                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30070000
MFA-TR*       SELECT  'Y',                                              30080000
MFA-TR*               NAME_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               ADDRESS_ID                                                
MFA-TR*       INTO    :BILL-ADDR-XREF-EXISTS-FLAG,                      30090000
MFA-TR*               :WS-AQ-NAME-ID,                                           
MFA-TR*               :WS-AQ-COMPANY-NO,                                        
MFA-TR*               :WS-AQ-ACCOUNT-NO,                                        
MFA-TR*               :WS-AQ-ADDRESS-ID                                         
MFA-TR*       FROM    CSS_BILL_ADDR_XREF                                30100000
MFA-TR*       WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     30110000
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*    END-EXEC.                                                    30120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7546-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30310000
      * 7560-SELECT-COUNT-NAME-ACCT                                    *30320000
      *                                                                *30351000
      *     CALLS 9000-SEND-ERROR-RESULT                               *30340000
      *           9900-SQL-ERROR-ROUTINE                               *30350000
      *                                                                *30360000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *30370000
      *                                                                *30380000
      *     SELECTS COUNT FROM TABLE CSS_NAME_ACCT_XREF                *30390000
      ******************************************************************30400000
                                                                        
       7560-SELECT-COUNT-NAME-ACCT.                                     
                                                                        
           MOVE '7560' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  COUNT(*)                                          
              INTO    :COUNT-NAME                                       
              FROM    CSS_NAME_ACCT_XREF WITH(READUNCOMMITTED)                  
              WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30460000
MFA-TR*       SELECT  COUNT(*)                                          30470000
MFA-TR*       INTO    :COUNT-NAME                                       30480000
MFA-TR*       FROM    CSS_NAME_ACCT_XREF                                30490000
MFA-TR*       WHERE   ADDRESS_ID = :AT-ADDRESS-ID                       30500000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    30510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_NAME_ACCT_XREF'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-2      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE AT-ADDRESS-ID                TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30700000
      * 7570-SELECT-HDR-NAME                                           *30710000
      *                                                                *30720000
      *     CALLS 9000-SEND-ERROR-RESULT                               *30751000
      *           9900-SQL-ERROR-ROUTINE                               *30740000
      *                                                                *30750000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *30760000
      *                                                                *30770000
      *     SELECTS FROM TABLE CSS_NAME (AA/AI NAME).                  *30780000
      ******************************************************************30790000
                                                                        
       7570-SELECT-HDR-NAME.                                            
                                                                        
           MOVE '7570' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  FIRST_NAME,                                       
                      FULL_NAME,                                        
                      LAST_NAME,                                        
                      MIDDLE_NAME,                                      
                      NAME_FORMAT,                                      
                      NAME_ID,                                          
                      NAME_TYPE,                                        
                      TITLE_PREFIX,                                     
                      TITLE_SUFFIX_1,                                   
                      TITLE_SUFFIX_2                                    
              INTO    :DQ-FIRST-NAME,                                   
                      :DQ-FULL-NAME,                                    
                      :DQ-LAST-NAME,                                    
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-NAME-FORMAT,                                  
                      :DQ-NAME-ID,                                      
                      :DQ-NAME-TYPE,                                    
                      :DQ-TITLE-PREFIX,                                 
                      :DQ-TITLE-SUFFIX-1,                               
                      :DQ-TITLE-SUFFIX-2                                
              FROM    CSS_NAME WITH(READUNCOMMITTED)                            
              WHERE   NAME_ID    = :AB-NAME-ID                          
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30850000
MFA-TR*       SELECT  FIRST_NAME,                                       30860000
MFA-TR*               FULL_NAME,                                        30870000
MFA-TR*               LAST_NAME,                                        30880000
MFA-TR*               MIDDLE_NAME,                                      30890000
MFA-TR*               NAME_FORMAT,                                      30900000
MFA-TR*               NAME_ID,                                          30910000
MFA-TR*               NAME_TYPE,                                        30920000
MFA-TR*               TITLE_PREFIX,                                     30951000
MFA-TR*               TITLE_SUFFIX_1,                                   30940000
MFA-TR*               TITLE_SUFFIX_2                                    30950000
MFA-TR*       INTO    :DQ-FIRST-NAME,                                   30960000
MFA-TR*               :DQ-FULL-NAME,                                    30970000
MFA-TR*               :DQ-LAST-NAME,                                    30980000
MFA-TR*               :DQ-MIDDLE-NAME,                                  30990000
MFA-TR*               :DQ-NAME-FORMAT,                                  31000000
MFA-TR*               :DQ-NAME-ID,                                      31010000
MFA-TR*               :DQ-NAME-TYPE,                                    31020000
MFA-TR*               :DQ-TITLE-PREFIX,                                 31051000
MFA-TR*               :DQ-TITLE-SUFFIX-1,                               31040000
MFA-TR*               :DQ-TITLE-SUFFIX-2                                31050000
MFA-TR*       FROM    CSS_NAME                                          31060000
MFA-TR*       WHERE   NAME_ID    = :AB-NAME-ID                          31070000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    31080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_NAME'                   TO TABLE-1              
              MOVE 'NAME_ID'                    TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
CBSI          MOVE AB-NAME-ID                   TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31290000
      * 7575-SELECT-NME-NAME                                           *31510000
      *                                                                *31310000
      *     CALLS 9000-SEND-ERROR-RESULT                               *31320000
      *           9900-SQL-ERROR-ROUTINE                               *31351000
      *                                                                *31340000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *31350000
      *                                                                *31360000
      *     SELECTS FROM TABLE CSS_NAME (AN NAME).                     *31370000
      ******************************************************************31380000
                                                                        
       7575-SELECT-NME-NAME.                                            
                                                                        
           MOVE '7575' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  FIRST_NAME,                                       
                      FULL_NAME,                                        
                      LAST_NAME,                                        
                      MIDDLE_NAME,                                      
                      NAME_FORMAT,                                      
                      NAME_ID,                                          
                      NAME_TYPE,                                        
                      TITLE_PREFIX,                                     
                      TITLE_SUFFIX_1,                                   
                      TITLE_SUFFIX_2                                    
              INTO    :HOLD-FIRST-NAME,                                 
                      :HOLD-FULL-NAME,                                  
                      :HOLD-LAST-NAME,                                  
                      :HOLD-MIDDLE-NAME,                                
                      :HOLD-NAME-FORMAT,                                
                      :HOLD-NAME-ID,                                    
                      :HOLD-NAME-TYPE,                                  
                      :HOLD-TITLE-PREFIX,                               
                      :HOLD-TITLE-SUFFIX-1,                             
                      :HOLD-TITLE-SUFFIX-2                              
              FROM    CSS_NAME WITH(READUNCOMMITTED)                            
              WHERE   NAME_ID    = :HOLD-NAME-ID                        
C32615                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31440000
MFA-TR*       SELECT  FIRST_NAME,                                       31450000
MFA-TR*               FULL_NAME,                                        31460000
MFA-TR*               LAST_NAME,                                        31470000
MFA-TR*               MIDDLE_NAME,                                      31480000
MFA-TR*               NAME_FORMAT,                                      31490000
MFA-TR*               NAME_ID,                                          31500000
MFA-TR*               NAME_TYPE,                                        31510000
MFA-TR*               TITLE_PREFIX,                                     31520000
MFA-TR*               TITLE_SUFFIX_1,                                   31551000
MFA-TR*               TITLE_SUFFIX_2                                    31540000
MFA-TR*       INTO    :HOLD-FIRST-NAME,                                 31550000
MFA-TR*               :HOLD-FULL-NAME,                                  31560000
MFA-TR*               :HOLD-LAST-NAME,                                  31570000
MFA-TR*               :HOLD-MIDDLE-NAME,                                31580000
MFA-TR*               :HOLD-NAME-FORMAT,                                31590000
MFA-TR*               :HOLD-NAME-ID,                                    31600000
MFA-TR*               :HOLD-NAME-TYPE,                                  31610000
MFA-TR*               :HOLD-TITLE-PREFIX,                               31620000
MFA-TR*               :HOLD-TITLE-SUFFIX-1,                             31651000
MFA-TR*               :HOLD-TITLE-SUFFIX-2                              31640000
MFA-TR*       FROM    CSS_NAME                                          31650000
MFA-TR*       WHERE   NAME_ID    = :HOLD-NAME-ID                        31660000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    31670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_NAME'                   TO TABLE-1              
              MOVE 'NAME_ID'                    TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE HOLD-NAME-ID                 TO WS-NAME-ID-I         
              MOVE WS-NAME-ID-I                 TO WS-NAME-ID-S         
              MOVE WS-NAME-ID-S                 TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7575-EXIT.                                                       
           EXIT.                                                        
                                                                        
TP9650******************************************************************31871001
T22301* 7579-SELECT-ZIP-CODE                                           *        
T22301*                                                                *        
T22301*     CALLS 9000-SEND-ERROR-RESULT                               *        
T22301*           9900-SQL-ERROR-ROUTINE                               *        
T22301*                                                                *        
T22301*     CALLED FROM 2300-FIND-OLD-VALUES                           *        
T22301*                                                                *        
T22301*     SELECTS FROM TABLE CSS_ADDR_FORMATTED.                     *        
T22301******************************************************************        
T22301                                                                  
T22301 7579-SELECT-ZIP-CODE.                                            
T22301                                                                  
T22301     MOVE '7579' TO ACTIVE-PARAGRAPH.                             
T22301                                                                  
T22301     EXEC SQL                                                     
T22301        SELECT  ZIP_CODE,                                         
T22301                ZIP_CODE_TOKEN                                    
T22301          INTO  :WS-ZIP-CODE,                                     
T22301                :WS-ZIP-CODE-TOKEN                                
T22301          FROM  CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
T22301         WHERE  ADDRESS_ID        = :PR-ADDRESS-ID                
C32615                                                           
T22301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*         INTO  :WS-ZIP-CODE,                                             
MFA-TR*               :WS-ZIP-CODE-TOKEN                                        
MFA-TR*         FROM  CSS_ADDR_FORMATTED                                        
MFA-TR*        WHERE  ADDRESS_ID        = :PR-ADDRESS-ID                        
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22301                                                                  
T22301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22301                                                                  
T22301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22301        NEXT SENTENCE                                             
T22301     ELSE                                                         
T22301        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T22301        MOVE 'SELECT'                     TO ABEND-FUNCTION       
T22301        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
T22301                                             ABEND-TABLES         
T22301        MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
T22301        MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
T22301        MOVE PR-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
T22301        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T22301        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T22301     END-IF.                                                      
T22301                                                                  
T22301 7579-EXIT.                                                       
T22301     EXIT.                                                        
T22301                                                                  
T22301******************************************************************        
T22301* 7580-SELECT-TOWN-STATE                                         *        
T22301*                                                                *        
T22301*     CALLS 9000-SEND-ERROR-RESULT                               *        
T22301*           9900-SQL-ERROR-ROUTINE                               *        
T22301*                                                                *        
T22301*     CALLED FROM 2300-FIND-OLD-VALUES                           *        
T22301*                                                                *        
T22301*     SELECTS FROM TABLE CSS_ZIP_CODE.                           *        
T22301******************************************************************        
T22301                                                                  
T22301 7580-SELECT-TOWN-STATE.                                          
T22301                                                                  
T22301     MOVE '7580' TO ACTIVE-PARAGRAPH.                             
T22301                                                                  
T22301     EXEC SQL                                                     
T22301        SELECT  TOWN,                                             
T22301                STATE                                             
T22301          INTO  :WS-TOWN,                                         
T22301                :WS-STATE                                         
T22301          FROM  CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
T22301         WHERE  ZIP_CODE          = :WS-ZIP-CODE                  
T22301           AND  ZIP_CODE_TOKEN    = :WS-ZIP-CODE-TOKEN            
C32615                                                           
T22301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*         INTO  :WS-TOWN,                                                 
MFA-TR*               :WS-STATE                                         31870000
MFA-TR*         FROM  CSS_ZIP_CODE                                              
MFA-TR*        WHERE  ZIP_CODE          = :WS-ZIP-CODE                          
MFA-TR*          AND  ZIP_CODE_TOKEN    = :WS-ZIP-CODE-TOKEN                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22301                                                                  
T22301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22301                                                                  
T22301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22301        NEXT SENTENCE                                             
T22301     ELSE                                                         
T22301        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T22301        MOVE 'SELECT'                     TO ABEND-FUNCTION       
T22301        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
T22301                                             ABEND-TABLES         
T22301        MOVE 'CSS_ZIP_CODE'               TO TABLE-1              
T22301        MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-1      
T22301        MOVE 'ZIP_CODE_TOKEN'             TO TABLE-ELEMENT-2      
T22301        MOVE DY-ZIP-CODE                  TO HOSTVAR-ELEMENT-1    
T22301        MOVE DY-ZIP-CODE-TOKEN            TO HOSTVAR-ELEMENT-2    
T22301        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T22301        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T22301     END-IF.                                                      
T22301                                                                  
T22301 7580-EXIT.                                                       
T22301     EXIT.                                                        
T22301                                                                  
TP9650******************************************************************31871001
TP9650* 7600-SELECT-OTHER-ACCT.                                        *31872001
TP9650******************************************************************31879101
TP9650                                                                  
TP9650 7600-SEL-OTHER-ACCT-OPEN.                                        
TP9650                                                                  
TP9650     MOVE '7600' TO ACTIVE-PARAGRAPH.                             
TP9650                                                                  
TP9650     EXEC SQL                                                     
TP9650         OPEN OTHER-ACCT-CSR                                      
TP9650     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP9650                                                                  
TP9650     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP9650                                                                  
TP9650     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TP9650        NEXT SENTENCE                                             
TP9650     ELSE                                                         
TP9650        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
TP9650        MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
TP9650        MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
TP9650        MOVE AQ-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
TP9650        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
TP9650        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
TP9650     END-IF.                                                      
TP9650                                                                  
TP9650 7600-EXIT.                                                       
TP9650     EXIT.                                                        
TP9650******************************************************************31884101
TP9650* 7610-SELECT-OTHER-ACCT.                                        *31884201
TP9650******************************************************************31884301
TP9650                                                                  
TP9650 7610-SEL-OTHER-ACCT-FETCH.                                       
TP9650                                                                  
TP9650     MOVE '7610' TO ACTIVE-PARAGRAPH.                             
TP9650                                                                  
TP9650     EXEC SQL                                                     
TP9650         FETCH  OTHER-ACCT-CSR                                    
TP9650         INTO   :AQ-ACCOUNT-NO                                    
TP9650     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP9650                                                                  
TP9650     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP9650                                                                  
TP9650     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TP9650        NEXT SENTENCE                                             
TP9650     ELSE                                                         
TP9650        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
TP9650        MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
TP9650        MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
TP9650        MOVE AQ-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
TP9650        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
TP9650        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
TP9650     END-IF.                                                      
TP9650                                                                  
TP9650 7610-EXIT.                                                       
TP9650     EXIT.                                                        
TP9650******************************************************************31887301
TP9650* 7620-SELECT-OTHER-ACCT.                                        *31887401
TP9650******************************************************************31887501
TP9650                                                                  
TP9650 7620-SEL-OTHER-ACCT-CLOSE.                                       
TP9650                                                                  
TP9650     MOVE '7620' TO ACTIVE-PARAGRAPH.                             
TP9650                                                                  
TP9650     EXEC SQL                                                     
TP9650         CLOSE  OTHER-ACCT-CSR                                    
TP9650     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP9650                                                                  
TP9650     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP9650                                                                  
TP9650     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TP9650        NEXT SENTENCE                                             
TP9650     ELSE                                                         
TP9650        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
TP9650        MOVE 'CSS_BILL_ADDR_XREF'         TO TABLE-1              
TP9650        MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
TP9650        MOVE AQ-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
TP9650        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
TP9650        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
TP9650     END-IF.                                                      
TP9650                                                                  
TP9650 7620-EXIT.                                                       
TP9650     EXIT.                                                        
                                                                        
      *****************************************************************         
T13202**  7700-UPDATE-LL-ADDR                                        **         
      **                                                             **         
      *****************************************************************         
                                                                        
T13202 7700-UPDATE-LL-ADDR.                                             
                                                                        
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_LANDLORD                                      
              SET     ADDRESS_ID            = :SI-ADDRESS-ID,           
                      ADDRESS_FORMAT        = :SI-ADDRESS-FORMAT        
              WHERE CURRENT OF LANDLORD-CSR                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_LANDLORD'             TO TABLE-1                
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ADDRESS_FORMAT'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE SI-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE SI-ADDRESS-FORMAT          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C36935 7800-GET-DELINQ-VALUE.                                           
C36935                                                                  
C36935     MOVE '7800'                       TO ACTIVE-PARAGRAPH.       
C36935        EXEC SQL                                                  
C36935           SELECT  DELINQ_VALUE                                   
C36935             INTO :C8-DELINQ-VALUE                                
C36935             FROM  CSS_DELINQUENCY                                
C36935            WHERE  DELINQ_CD  = :C8-DELINQ-CD                     
C36935              AND  COMPANY_NO = :C8-COMPANY-NO                    
C36935        END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36935                                                                  
C36935     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C36935                                                                  
C36935     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36935        NEXT SENTENCE                                             
C36935     ELSE                                                         
C36935        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C36935        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C36935        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C36935                                           ABEND-TABLES           
C36935        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
C36935        MOVE 'DELINQ_VALUE'             TO TABLE-ELEMENT-1        
C36935        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
C36935        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
C36935        MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
C36935        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36935        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36935     END-IF.                                                      
C36935                                                                  
C36935 7800-EXIT.                                                       
C36935     EXIT.                                                        
                                                                        
P00547******************************************************************        
P00547* 7850-CHECK-IAT-CATEGORY.                                       *        
P00547* PERFORMED BY 5920-IAT-WQ.                                      *        
P00547******************************************************************        
P00547 7850-CHECK-IAT-CATEGORY.                                         
P00547                                                                  
P00547     MOVE '7850'                        TO ACTIVE-PARAGRAPH.      
P00547                                                                  
P00547     EXEC SQL                                                     
P00547        SELECT TOP(1) 'Y'                                                
P00547          INTO :WS-IAT-CAT-FOUND                                  
P00547          FROM CSS_CATEGORY WITH(READUNCOMMITTED)                         
P00547         WHERE USER_ID = :PARM-USER-ID                            
P00547           AND CATEGORY_ID = 327                                  
P00547                                       
P00547                                                      
P00547     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-IAT-CAT-FOUND                                          
MFA-TR*         FROM CSS_CATEGORY                                               
MFA-TR*        WHERE USER_ID = :PARM-USER-ID                                    
MFA-TR*          AND CATEGORY_ID = 327                                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00547                                                                  
P00547     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00547                                                                  
P00547     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00547        WHEN SUCCESSFUL-CALL                                      
P00547           CONTINUE                                               
P00547        WHEN NOT-FOUND                                            
P00547           MOVE 'N'                       TO WS-IAT-CAT-FOUND     
P00547        WHEN OTHER                                                
P00547           MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
P00547           MOVE 'CSS_CATEGORY'            TO TABLE-1              
P00547           MOVE 'USER_ID'                 TO TABLE-ELEMENT-1      
P00547           MOVE PARM-USER-ID              TO HOSTVAR-ELEMENT-1    
P00547           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
P00547           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
P00547     END-EVALUATE.                                                
P00547                                                                  
P00547 7850-EXIT.                                                       
P00547     EXIT.                                                        
                                                                        
      ******************************************************************31890500
      * 8400-UPDATE-TBACCT                                             *31891000
      *                                                                *31900000
      *     CALLS       9000-SEND-ERROR-RESULT                         *31910000
      *                 9900-SQL-ERROR-ROUTINE                         *31920000
      *                                                                *31951000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *31940000
      *                                                                *31950000
      *     UPDATE TABLE CSS_ACCOUNT WITH EXISTING ADDRESS-ID.         *31960000
      ******************************************************************31970000
                                                                        
       8400-UPDATE-TBACCT.                                              
                                                                        
           MOVE '8400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_ACCOUNT                                       
              SET     ADDRESS_ID            = :WS-INS-ADDRESS-ID,       
                      ADDRESS_FORMAT        = :PARM-ADDRESS-FORMAT,     
                      DATE_LAST_ACTION      = IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TRANS
              ) <> 0) OR (LEN(:WS-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TRANS
              ), CONVERT(DATE, :WS-DATE-TRANS) ),           
                      LAST_UPDATE_TS        = CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )     
              WHERE   ACCOUNT_NO            = :WS-ACCOUNT-NO-D          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     32051000
MFA-TR*       UPDATE  CSS_ACCOUNT                                       32040000
MFA-TR*       SET     ADDRESS_ID            = :WS-INS-ADDRESS-ID,       32050000
MFA-TR*               ADDRESS_FORMAT        = :PARM-ADDRESS-FORMAT,     32060000
MFA-TR*               DATE_LAST_ACTION      = :WS-DATE-TRANS,           32070000
MFA-TR*               LAST_UPDATE_TS        = :WS-TRANS-HIST-SEQ-NO     32080000
MFA-TR*       WHERE   ACCOUNT_NO            = :WS-ACCOUNT-NO-D          32090000
MFA-TR*    END-EXEC.                                                    32100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'ADDRESS_FORMAT'           TO TABLE-ELEMENT-3        
CBSI          MOVE 'DATE_LAST_ACTION'         TO TABLE-ELEMENT-4        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-INS-ADDRESS-ID          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-ADDRESS-FORMAT        TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-DATE-TRANS              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32615 8410-UPDATE-TRANSHIST.                                           
C32615                                                                  
C32615     MOVE '8410' TO ACTIVE-PARAGRAPH.                             
C32615                                                                  
C32615     MOVE 'ONE' TO MI-CHG-COLUMN-VALUE-TEXT.                      
C32615     MOVE +3    TO MI-CHG-COLUMN-VALUE-LEN.                       
C32615     EXEC SQL                                                     
C32615        UPDATE  CSS_MT_TRN_HST_DET                                
C32615        SET     CHG_COLUMN_VALUE      = :MI-CHG-COLUMN-VALUE      
C32615        WHERE   TRANS_HIST_SEQ_NO     = CIS.CHAR2TIMESTAMP(
                                                        :WS-HOLD-SEQ-NO
              )           
C32615          AND   TRAN_APPL_NO          = :WS-HOLD-APPL-NO          
C32615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     32051000
MFA-TR*       UPDATE  CSS_MT_TRN_HST_DET                                32040000
MFA-TR*       SET     CHG_COLUMN_VALUE      = :MI-CHG-COLUMN-VALUE      32050000
MFA-TR*       WHERE   TRANS_HIST_SEQ_NO     = :WS-HOLD-SEQ-NO           32090000
MFA-TR*         AND   TRAN_APPL_NO          = :WS-HOLD-APPL-NO          32090000
MFA-TR*    END-EXEC.                                                    32100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32615                                                                  
C32615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C32615                                                                  
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C32615        NEXT SENTENCE                                             
C32615     ELSE                                                         
C32615        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C32615        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
C32615        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C32615                                           ABEND-TABLES           
C32615        MOVE 'CSS_MT_TRN_HST_DET'       TO TABLE-1                
C32615        MOVE 'SEQ_NO'                   TO TABLE-ELEMENT-1        
C32615        MOVE 'APPL_NO'                  TO TABLE-ELEMENT-2        
C32615        MOVE WS-HOLD-SEQ-NO             TO HOSTVAR-ELEMENT-1      
C32615        MOVE WS-HOLD-APPL-NO            TO HOSTVAR-ELEMENT-2      
C32615        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C32615        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C32615     END-IF.                                                      
C32615                                                                  
C32615 8410-EXIT.                                                       
C32615     EXIT.                                                        
                                                                        
      ******************************************************************33070000
      * 8460-UPDATE-TBNAME                                             *33080000
      *                                                                *33090000
      *     CALLS 9000-SEND-ERROR-RESULT                               *33100000
      *           9900-SQL-ERROR-ROUTINE                               *33110000
      *                                                                *33120000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *33151000
      *                 5200-PROCESS-NB-NAME                           *33140000
      *                                                                *33150000
      *     UPDATE TABLE CSS_NAME.                                     *33160000
      ******************************************************************33170000
                                                                        
       8460-UPDATE-TBNAME.                                              
                                                                        
           MOVE '8460' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_NAME                                          
              SET     NAME_TYPE               = :WS-NAME-TYPE,          
                      NAME_FORMAT             = :WS-NAME-FORMAT,        
                      FIRST_NAME              = :WS-FIRST-NAME,         
                      MIDDLE_NAME             = :WS-MIDDLE-NAME,        
                      LAST_NAME               = :WS-LAST-NAME,          
                      TITLE_PREFIX            = :WS-TITLE-PREFIX,       
                      TITLE_SUFFIX_1          = :WS-TITLE-SUFFIX-1,     
                      TITLE_SUFFIX_2          = :WS-TITLE-SUFFIX-2,     
                      FULL_NAME               = :WS-FULL-NAME           
              WHERE   NAME_ID                 = :WS-NAME-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
CBSI          MOVE 'NAME_TYPE'                TO TABLE-ELEMENT-2        
CBSI          MOVE 'FULL_NAME'                TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE WS-NAME-ID                 TO WS-NAME-ID-I           
              MOVE WS-NAME-ID-I               TO WS-NAME-ID-S           
              MOVE WS-NAME-ID-S               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-NAME-TYPE               TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-FULL-NAME               TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33560000
      * 8480-UPDATE-TBADRFMT                                           *33570000
      *                                                                *33580000
      *     CALLS 9000-SEND-ERROR-RESULT                               *33590000
      *           9900-SQL-ERROR-ROUTINE                               *33600000
      *                                                                *33610000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *33620000
      *                                                                *33651000
      *     UPDATE TABLE CSS_ADDR_FORMATTED.                           *33640000
      ******************************************************************33650000
                                                                        
       8480-UPDATE-TBADRFMT.                                            
                                                                        
           MOVE '8480' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_ADDR_FORMATTED                                
              SET     HOUSE_NO            = :PARM-FO-HOUSE-NO,          
                      ADDR_PREFIX_1       = :PARM-FO-ADDR-PREFIX-1,     
                      ADDR_PREFIX_2       = :PARM-FO-ADDR-PREFIX-2,     
                      STREET_NAME         = :PARM-FO-STREET-NAME,       
                      STREET_SUFFIX       = :PARM-FO-STREET-SUFFIX,     
                      STREET_LOCATION_1   = :PARM-FO-STREET-LOCATION-1, 
                      STREET_LOCATION_2   = :PARM-FO-STREET-LOCATION-2, 
                      ADDRESS_OVERFLOW    = :PARM-FO-ADDRESS-OVERFLOW,  
                      ZIP_CODE            = :PARM-FO-ZIP-CODE,          
                      ZIP_CODE_TOKEN      = :PARM-FO-ZIP-CODE-TOKEN,    
                      ZIP_CODE_PLUS_FOUR  = :PARM-FO-ZIP-CODE-PL-FOUR,  
                      ADDR_USAGE_CD       = 'F',                        
                      ADDR_SUFFIX         = :PARM-FO-ADDR-SUFFIX        
              WHERE   ADDRESS_ID          = :AT-ADDRESS-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'HOUSE_NO'                 TO TABLE-ELEMENT-2        
CBSI          MOVE 'STREET_NAME'              TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE AT-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-FO-HOUSE-NO           TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-FO-STREET-NAME        TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34080000
      * 8520-UPDATE-TBADRFRE                                           *34090000
      *                                                                *34100000
      *     CALLS 9000-SEND-ERROR-RESULT                               *34110000
      *           9900-SQL-ERROR-ROUTINE                               *34120000
      *                                                                *34151000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *34140000
      *                                                                *34150000
      *     UPDATE TABLE CSS_ADDR_FREEFORM.                            *34160000
      ******************************************************************34170000
                                                                        
       8520-UPDATE-TBADRFRE.                                            
                                                                        
           MOVE '8520' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_ADDR_FREEFORM                                 
              SET     ADDR_STREET           = :PARM-FR-ADDR-STREET,     
                      ADDR_CITY_STATE       = :PARM-FR-CITY-STATE,      
                      ADDR_ZIP_CODE         = :PARM-FR-ZIP-CODE,        
                      ADDR_COUNTRY          = :PARM-FR-COUNTRY,         
                      ADDRESS_OVERFLOW      = :PARM-FR-ADDRESS-OVERFLOW 
              WHERE   ADDRESS_ID            = :AT-ADDRESS-ID            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ADDR_STREET'              TO TABLE-ELEMENT-2        
CBSI          MOVE 'ADDR_CITY_STATE'          TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE AT-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-FR-ADDR-STREET        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-FR-CITY-STATE         TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34520000
      * 8530-SET-PULL-CODE                                             *34090000
      *                                                                *34100000
      *     CALLS 9000-SEND-ERROR-RESULT                               *34110000
      *           9900-SQL-ERROR-ROUTINE                               *34120000
      *                                                                *34151000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *34140000
      *                                                                *34150000
      *     UPDATE TABLE CSS_ACCOUNT IF THE COUNTRY IS ENTERED.        *34160000
      *     FOREIGN ADDRESSES SHOULD BE PULLED FOR EXTRA POSTAGE.      *34160000
      ******************************************************************34170000
                                                                        
T19462 8530-SET-PULL-CODE.                                              
T19462                                                                  
T19462     MOVE '8530' TO ACTIVE-PARAGRAPH.                             
T19462                                                                  
T19462     EXEC SQL                                                     
T19462        UPDATE  CSS_ACCOUNT                                       
T19462        SET     CODE_PERM_BILL        = :WS-CODE-PERM-BILL        
T19462        WHERE   ACCOUNT_NO            = :WS-ACCOUNT-NO-D          
T19462     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19462                                                                  
T19462     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T19462                                                                  
T19462     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T19462        NEXT SENTENCE                                             
T19462     ELSE                                                         
T19462        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T19462        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T19462        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T19462                                           ABEND-TABLES           
T19462        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
T19462        MOVE 'ACCOUNT'                  TO TABLE-ELEMENT-1        
T19462        MOVE WS-ACCOUNT-NO-D            TO HOSTVAR-ELEMENT-1      
T19462        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T19462        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T19462     END-IF.                                                      
T19462                                                                  
T19462                                                                  
T19462 8530-EXIT.                                                       
T19462     EXIT.                                                        
                                                                        
      ******************************************************************34520000
      * 8540-UPDATE-TBBLADRX                                           *34551000
      *                                                                *34540000
      *     CALLS 9000-SEND-ERROR-RESULT                               *34550000
      *           9900-SQL-ERROR-ROUTINE                               *34560000
      *                                                                *34570000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *34580000
      *                                                                *34590000
      *     UPDATE TABLE CSS_BILL_ADDR_XREF.                           *34600000
      ******************************************************************34610000
                                                                        
       8540-UPDATE-TBBLADRX.                                            
                                                                        
           MOVE '8540' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_BILL_ADDR_XREF                                
              SET     NAME_ID               = :WS-INS-NAME-ID           
              WHERE   ACCOUNT_NO            = :WS-ACCOUNT-NO-D          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'NAME_ID'                  TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-INS-NAME-ID             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34900000
      * 8550-UPD-TBBLADRX                                              *34910000
      *                                                                *34920000
      *     CALLS 9000-SEND-ERROR-RESULT                               *34951000
      *           9900-SQL-ERROR-ROUTINE                               *34940000
      *                                                                *34950000
      *     CALLED FROM 5030-JRNL-ADDR-DETAILS                         *34960000
      *                                                                *34970000
      *     UPDATE TABLE CSS_BILL_ADDR_XREF ADDRESS_ID VALUE.          *34980000
      ******************************************************************34990000
                                                                        
       8550-UPD-TBBLADRX.                                               
                                                                        
           MOVE '8550' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_BILL_ADDR_XREF                                
              SET     ADDRESS_ID            = :WS-INS-ADDRESS-ID        
              WHERE   ACCOUNT_NO            = :WS-ACCOUNT-NO-D          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-INS-ADDRESS-ID          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************35280000
      * 8600-INSERT-TBNAME                                             *35290000
      *                                                                *35510000
      *     CALLS       9000-SEND-ERROR-RESULT                         *35310000
      *                 9900-SQL-ERROR-ROUTINE                         *35320000
      *                                                                *35351000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *35340000
      *                 5200-PROCESS-NB-NAME                           *35350000
      *                                                                *35360000
      *     INSERTS A ROW INTO CSS_NAME.                               *35370000
      ******************************************************************35380000
                                                                        
       8600-INSERT-TBNAME.                                              
                                                                        
           MOVE '8600' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                          (NAME_ID,                                     
                          NAME_TYPE,                                    
                          NAME_FORMAT,                                  
                          CREATED_DATE,                                 
                          FIRST_NAME,                                   
                          MIDDLE_NAME,                                  
                          LAST_NAME,                                    
                          TITLE_PREFIX,                                 
                          TITLE_SUFFIX_1,                               
                          TITLE_SUFFIX_2,                               
                          FULL_NAME)                                    
              VALUES      (:WS-INS-NAME-ID,                             
                          :WS-NAME-TYPE,                                
                          :WS-NAME-FORMAT,                              
                          CIS.CHAR2TIMESTAMP(:WS-TRANS-HIST-SEQ-NO),            
                          :WS-FIRST-NAME,                               
                          :WS-MIDDLE-NAME,                              
                          :WS-LAST-NAME,                                
                          :WS-TITLE-PREFIX,                             
                          :WS-TITLE-SUFFIX-1,                           
                          :WS-TITLE-SUFFIX-2,                           
                          :WS-FULL-NAME)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35440000
MFA-TR*       INSERT INTO CSS_NAME                                      35450000
MFA-TR*                   (NAME_ID,                                     35460000
MFA-TR*                   NAME_TYPE,                                    35470000
MFA-TR*                   NAME_FORMAT,                                  35480000
MFA-TR*                   CREATED_DATE,                                 35490000
MFA-TR*                   FIRST_NAME,                                   35500000
MFA-TR*                   MIDDLE_NAME,                                  35510000
MFA-TR*                   LAST_NAME,                                    35520000
MFA-TR*                   TITLE_PREFIX,                                 35551000
MFA-TR*                   TITLE_SUFFIX_1,                               35540000
MFA-TR*                   TITLE_SUFFIX_2,                               35550000
MFA-TR*                   FULL_NAME)                                    35560000
MFA-TR*       VALUES      (:WS-INS-NAME-ID,                             35570000
MFA-TR*                   :WS-NAME-TYPE,                                35580000
MFA-TR*                   :WS-NAME-FORMAT,                              35590000
MFA-TR*                   :WS-TRANS-HIST-SEQ-NO,                        35600000
MFA-TR*                   :WS-FIRST-NAME,                               35610000
MFA-TR*                   :WS-MIDDLE-NAME,                              35620000
MFA-TR*                   :WS-LAST-NAME,                                35651000
MFA-TR*                   :WS-TITLE-PREFIX,                             35640000
MFA-TR*                   :WS-TITLE-SUFFIX-1,                           35650000
MFA-TR*                   :WS-TITLE-SUFFIX-2,                           35660000
MFA-TR*                   :WS-FULL-NAME)                                35670000
MFA-TR*    END-EXEC.                                                    35680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
CBSI          MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
CBSI          MOVE 'NAME_TYPE'                TO TABLE-ELEMENT-2        
CBSI          MOVE 'FULL_NAME'                TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE WS-INS-NAME-ID             TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-NAME-TYPE               TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-FULL-NAME               TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************35850000
      * 8620-INSERT-TBATBLNM                                           *35860000
      *                                                                *35870000
      *     CALLS       9000-SEND-ERROR-RESULT                         *35880000
      *                 9900-SQL-ERROR-ROUTINE                         *35890000
      *                                                                *35900000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *35910000
      *                 5200-PROCESS-NB-NAME                           *35920000
      *                                                                *35951000
      *     INSERTS A ROW INTO CSS_ACCT_BILL_NMES.                     *35940000
      ******************************************************************35950000
                                                                        
       8620-INSERT-TBATBLNM.                                            
                                                                        
           MOVE '8620' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_BILL_NMES                            
                          (ACCOUNT_NO,                                  
                          NAME_TYPE,                                    
                          NAME_ID)                                      
              VALUES      (:WS-ACCOUNT-NO-D,                            
                          :WS-NAME-TYPE,                                
                          :WS-INS-NAME-ID)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCT_BILL_NMES'       TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'NAME_TYPE'                TO TABLE-ELEMENT-2        
CBSI          MOVE 'NAME_ID'                  TO TABLE-ELEMENT-3        
CBSI          MOVE WS-ACCOUNT-NO-D            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-NAME-TYPE               TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-INS-NAME-ID             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************36260000
      * 8640-INSERT-TBNMACTX                                           *36270000
      *                                                                *36280000
      *     CALLS 9000-SEND-ERROR-RESULT                               *36290000
      *           9900-SQL-ERROR-ROUTINE                               *36510000
      *                                                                *36310000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *36320000
      *                 5200-PROCESS-NB-NAME                           *36351000
      *                 5300-PROCESS-ADDR-FORM                         *36340000
      *                                                                *36350000
      *     INSERTS A ROW INTO CSS_NAME_ACCT_XREF.                     *36360000
      ******************************************************************36370000
                                                                        
       8640-INSERT-TBNMACTX.                                            
                                                                        
           MOVE '8640' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                          (NAME_ID,                                     
                          COMPANY_NO,                                   
                          CUSTOMER_NO,                                  
                          ACCOUNT_NO,                                   
                          ADDRESS_ID,                                   
                          PREMISE_NO,                                   
                          CONTACT_ID,                                   
T22301                    STATE,                                        
T22301                    TOWN,                                         
T22301                    LOCAL_OFFICE,                                 
P00594                    ACCOUNT_TYPE_CODE,                            
P00594                    CODE_ACCT_STAT)                               
              VALUES      (:WS-INS-NAME-ID,                             
                          :AT-COMPANY-NO,                               
                          :AT-CUSTOMER-NO,                              
                          :WS-ACCOUNT-NO-D,                             
                          :PR-ADDRESS-ID,                               
                          :AT-PREMISE-NO,                               
                          0,                                            
T22301                    :WS-STATE,                                    
T22301                    :WS-TOWN,                                     
T22301                    :PR-LOCAL-OFFICE,                             
P00594                    :AT-ACCOUNT-TYPE-CODE,                        
P00594                    :AT-CODE-ACCT-STAT)                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
CBSI          MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-ACCOUNT-NO-D            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PR-ADDRESS-ID              TO HOSTVAR-ELEMENT-3      
CBSI          MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************36760000
      * 8660-INSERT-TBADRFMT                                           *36770000
      *                                                                *36780000
      *     CALLS       9000-SEND-ERROR-RESULT                         *36790000
      *                 9900-SQL-ERROR-ROUTINE                         *36800000
      *                                                                *36810000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *36820000
      *                                                                *36851000
      *     INSERTS A ROW INTO TABLE CSS_ADDR_FORMATTED.               *36840000
      ******************************************************************36850000
                                                                        
       8660-INSERT-TBADRFMT.                                            
                                                                        
           MOVE '8660' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                         (ADDRESS_ID,                                   
                          HOUSE_NO,                                     
                          ADDR_PREFIX_1,                                
                          ADDR_PREFIX_2,                                
                          STREET_NAME,                                  
                          STREET_SUFFIX,                                
                          STREET_LOCATION_1,                            
                          STREET_LOCATION_2,                            
                          ADDRESS_OVERFLOW,                             
                          ZIP_CODE,                                     
                          ZIP_CODE_PLUS_FOUR,                           
                          ZIP_CODE_TOKEN,                               
                          ADDR_SUFFIX,                                  
                          CARRIER_ROUTE,                                
                          ADDR_USAGE_CD)                                
              VALUES     (:WS-INS-ADDRESS-ID,                           
                          :PARM-FO-HOUSE-NO,                            
                          :PARM-FO-ADDR-PREFIX-1,                       
                          :PARM-FO-ADDR-PREFIX-2,                       
                          :PARM-FO-STREET-NAME,                         
                          :PARM-FO-STREET-SUFFIX,                       
                          :PARM-FO-STREET-LOCATION-1,                   
                          :PARM-FO-STREET-LOCATION-2,                   
                          :PARM-FO-ADDRESS-OVERFLOW,                    
                          :PARM-FO-ZIP-CODE,                            
                          :PARM-FO-ZIP-CODE-PL-FOUR,                    
                          :PARM-FO-ZIP-CODE-TOKEN,                      
                          :PARM-FO-ADDR-SUFFIX,                         
                          '     ',                                      
                          'F')                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'STREET_NAME'              TO TABLE-ELEMENT-2        
CBSI          MOVE 'ZIP_CODE'                 TO TABLE-ELEMENT-3        
CBSI          MOVE 'TOKEN'                    TO TABLE-ELEMENT-4        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-FO-STREET-NAME        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-FO-ZIP-CODE           TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-FO-ZIP-CODE-TOKEN     TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************37400000
      * 8680-INSERT-TBADRFRE                                           *37410000
      *                                                                *37420000
      *     CALLS       9000-SEND-ERROR-RESULT                         *37451000
      *                 9900-SQL-ERROR-ROUTINE                         *37440000
      *                                                                *37450000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *37460000
      *                                                                *37470000
      *     INSERTS A ROW INTO TABLE CSS_ADDR_FREEFORM.                *37480000
      ******************************************************************37490000
                                                                        
       8680-INSERT-TBADRFRE.                                            
                                                                        
           MOVE '8680' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                         (ADDRESS_ID,                                   
                          ADDR_STREET,                                  
                          ADDR_CITY_STATE,                              
                          ADDR_ZIP_CODE,                                
                          ADDR_COUNTRY,                                 
                          ADDRESS_OVERFLOW)                             
              VALUES     (:WS-INS-ADDRESS-ID,                           
                          :PARM-FR-ADDR-STREET,                         
                          :PARM-FR-CITY-STATE,                          
                          :PARM-FR-ZIP-CODE,                            
                          :PARM-FR-COUNTRY,                             
                          :PARM-FR-ADDRESS-OVERFLOW)                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-1                
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ADDR_STREET'              TO TABLE-ELEMENT-2        
CBSI          MOVE 'ADDR_COUNTRY'             TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE WS-INS-ADDRESS-ID          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-FR-ADDR-STREET        TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-FR-COUNTRY            TO HOSTVAR-ELEMENT-3      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************37860000
      * 8700-INSERT-TBBLADRX                                           *37870000
      *                                                                *37880000
      *     CALLS       9000-SEND-ERROR-RESULT                         *37890000
      *                 9900-SQL-ERROR-ROUTINE                         *37900000
      *                                                                *37910000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *37920000
      *                                                                *37951000
      *     INSERTS A ROW INTO TABLE CSS_BILL_ADDR_XREF.               *37940000
      ******************************************************************37950000
                                                                        
       8700-INSERT-TBBLADRX.                                            
                                                                        
           MOVE '8700' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF AB-NAME-ID = ZERO                                         
               MOVE CU-NAME-ID                 TO AB-NAME-ID            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_ADDR_XREF                            
                         (ADDRESS_ID,                                   
                          NAME_ID,                                      
                          COMPANY_NO,                                   
                          ACCOUNT_NO)                                   
              VALUES     (:WS-INS-ADDRESS-ID,                           
                          :AB-NAME-ID,                                  
                          :AT-COMPANY-NO,                               
                          :WS-ACCOUNT-NO-D)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
CBSI          MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'NAME_ID'                  TO TABLE-ELEMENT-2        
CBSI          MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE WS-INS-ADDRESS-ID          TO HOSTVAR-ELEMENT-1      
CBSI          MOVE AB-NAME-ID                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE AT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-ACCOUNT-NO-D            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37298 8750-INSERT-TBBLADRX.                                            
C37298                                                                  
C37298     MOVE '8750' TO ACTIVE-PARAGRAPH.                             
C37298                                                                  
A03018     IF WS-AQ-COMPANY-NO <= ' '                                   
A03018         MOVE AT-COMPANY-NO TO WS-AQ-COMPANY-NO
           END-IF.                  
A03018     IF WS-AQ-ACCOUNT-NO = 0                                      
A03018         MOVE WS-ACCOUNT-NO-D TO WS-AQ-ACCOUNT-NO
           END-IF.                
C37298                                                                  
C37298     EXEC SQL                                                     
C37298        INSERT INTO CSS_BILL_ADDR_XREF                            
C37298                   (ADDRESS_ID,                                   
C37298                    NAME_ID,                                      
C37298                    COMPANY_NO,                                   
C37298                    ACCOUNT_NO)                                   
C37298        VALUES     (:WS-AQ-ADDRESS-ID,                            
C37298                    :WS-INS-NAME-ID,                              
C37298                    :WS-AQ-COMPANY-NO,                            
C37298                    :WS-AQ-ACCOUNT-NO)                            
C37298     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37298                                                                  
C37298     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37298                                                                  
C37298     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C37298        NEXT SENTENCE                                             
C37298     ELSE                                                         
C37298        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C37298        MOVE 'INSERT'                   TO ABEND-FUNCTION         
C37298        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C37298                                           ABEND-TABLES           
C37298        MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
C37298        MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
C37298        MOVE 'NAME_ID'                  TO TABLE-ELEMENT-2        
C37298        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
C37298        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
C37298        MOVE WS-AQ-ADDRESS-ID           TO HOSTVAR-ELEMENT-1      
A03018        MOVE WS-INS-NAME-ID             TO HOSTVAR-ELEMENT-2      
C37298        MOVE WS-AQ-COMPANY-NO           TO HOSTVAR-ELEMENT-3      
C37298        MOVE WS-AQ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-4      
C37298        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C37298        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C37298     END-IF.                                                      
C37298                                                                  
C37298 8750-EXIT.                                                       
C37298     EXIT.                                                        
                                                                        
      ******************************************************************38320000
      * 8800-DELETE-TBNMACTX                                           *38351000
      *                                                                *38340000
      *     CALLS 9000-SEND-ERROR-RESULT                               *38350000
      *           9900-SQL-ERROR-ROUTINE                               *38360000
      *                                                                *38370000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *38380000
      *                 5200-PROCESS-NB-NAME                           *38390000
      *                                                                *38400000
      *     DELETES A ROW FROM CSS_NAME_ACCT_XREF.                     *38410000
      ******************************************************************38420000
                                                                        
       8800-DELETE-TBNMACTX.                                            
                                                                        
           MOVE '8800' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
              WHERE  NAME_ID                  = :WS-NAME-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-NAME-ID                 TO WS-NAME-ID-I           
              MOVE WS-NAME-ID-I               TO WS-NAME-ID-S           
              MOVE WS-NAME-ID-S               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************38711000
      * 8810-DELETE-TBBILLADDRX                                        *38712000
      *                                                                *38715100
      *     CALLS 9000-SEND-ERROR-RESULT                               *38714000
      *           9900-SQL-ERROR-ROUTINE                               *38715000
      *                                                                *38716000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *38717000
      *                 5200-PROCESS-NB-NAME                           *38718000
      *                                                                *38719000
      *     DELETES A ROW FROM CSS_BILL_ADDR_XREF.                     *38719100
      ******************************************************************38719200
                                                                        
       8810-DELETE-TBBILLADDRX.                                         
                                                                        
           MOVE '8810' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BILL_ADDR_XREF                            
              WHERE  NAME_ID                  = :WS-NAME-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C37298     EVALUATE WS-ACTIVE-RETURN-CODE                               
C37298         WHEN SUCCESSFUL-CALL                                     
C37298             MOVE 'Y' TO WS-AQ-ROW-DELETED                        
C37298         WHEN NOT-FOUND                                           
C37298             CONTINUE                                             
C37298         WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'DELETE'              TO ABEND-FUNCTION         
CBSI               MOVE SPACES                TO ABEND-SQL-PREDICATES   
CBSI                                                  ABEND-TABLES      
                   MOVE 'CSS_BILL_ADDR_XREF'  TO TABLE-1                
                   MOVE 'NAME_ID'             TO TABLE-ELEMENT-1        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
                   MOVE WS-NAME-ID            TO WS-NAME-ID-I           
                   MOVE WS-NAME-ID-I          TO WS-NAME-ID-S           
                   MOVE WS-NAME-ID-S          TO HOSTVAR-ELEMENT-1      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C37298     END-EVALUATE.                                                
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
A35665 8815-UPDATE-TBBILLADDRX.                                         
A35665                                                                  
A35665     MOVE '8815' TO ACTIVE-PARAGRAPH.                             
A35665                                                                  
A35665     EXEC SQL                                                     
A35665        UPDATE CSS_BILL_ADDR_XREF                                 
A35665           SET NAME_ID = :CU-NAME-ID                              
A35665        WHERE  NAME_ID = :WS-NAME-ID                              
A35665          AND  ACCOUNT_NO = :WS-ACCOUNT-NO-D                      
A35665     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35665                                                                  
A35665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35665                                                                  
A35665     EVALUATE WS-ACTIVE-RETURN-CODE                               
A35665         WHEN SUCCESSFUL-CALL                                     
A35665         WHEN NOT-FOUND                                           
A35665             CONTINUE                                             
A35665         WHEN OTHER                                               
A35665             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
A35665             MOVE 'UPDATE'              TO ABEND-FUNCTION         
A35665             MOVE SPACES                TO ABEND-SQL-PREDICATES   
A35665                                                ABEND-TABLES      
A35665             MOVE 'CSS_BILL_ADDR_XREF'  TO TABLE-1                
A35665             MOVE 'NAME_ID'             TO TABLE-ELEMENT-1        
A35665             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
A35665             MOVE WS-NAME-ID            TO WS-NAME-ID-I           
A35665             MOVE WS-NAME-ID-I          TO WS-NAME-ID-S           
A35665             MOVE WS-NAME-ID-S          TO HOSTVAR-ELEMENT-1      
A35665             MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2      
A35665             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A35665             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A35665     END-EVALUATE.                                                
A35665                                                                  
A35665 8815-EXIT.                                                       
A35665     EXIT.                                                        
                                                                        
      ******************************************************************38725100
      * 8820-DELETE-TBATBLNM                                           *38751000
      *                                                                *38740000
      *     CALLS 9000-SEND-ERROR-RESULT                               *38750000
      *           9900-SQL-ERROR-ROUTINE                               *38760000
      *                                                                *38770000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *38780000
      *                 5200-PROCESS-NB-NAME                           *38790000
      *                                                                *38800000
      *     DELETES A ROW FROM CSS_ACCT_BILL_NMES.                     *38810000
      ******************************************************************38820000
                                                                        
       8820-DELETE-TBATBLNM.                                            
                                                                        
           MOVE '8820' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_BILL_NMES                            
              WHERE  ACCOUNT_NO               = :WS-ACCOUNT-NO-D        
              AND    NAME_TYPE                = :WS-NAME-TYPE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCT_BILL_NMES'       TO TABLE-1                
CBSI          MOVE 'NAME_TYPE'                TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE WS-NAME-TYPE               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-ACCOUNT-NO-D            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************39151000
      * 8840-DELETE-TBNAME                                             *39140000
      *                                                                *39150000
      *     CALLS 9000-SEND-ERROR-RESULT                               *39160000
      *           9900-SQL-ERROR-ROUTINE                               *39170000
      *                                                                *39180000
      *     CALLED FROM 5100-PROCESS-AT-NAME                           *39190000
      *                 5200-PROCESS-NB-NAME                           *39200000
      *                                                                *39210000
      *     DELETES A ROW FROM CSS_NAME.                               *39220000
      ******************************************************************39251000
                                                                        
       8840-DELETE-TBNAME.                                              
                                                                        
           MOVE '8840' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME                                      
              WHERE  NAME_ID                  = :WS-NAME-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-NAME-ID                 TO WS-NAME-ID-I           
              MOVE WS-NAME-ID-I               TO WS-NAME-ID-S           
              MOVE WS-NAME-ID-S               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8840-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************39551000
      * 8860-DELETE-TBBLADRX                                           *39540000
      *                                                                *39550000
      *     CALLS 9000-SEND-ERROR-RESULT                               *39560000
      *           9900-SQL-ERROR-ROUTINE                               *39570000
      *                                                                *39580000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *39590000
      *                                                                *39600000
      *     DELETES A ROW FROM CSS_BILL_ADDR_XREF                      *39610000
      ******************************************************************39620000
                                                                        
       8860-DELETE-TBBLADRX.                                            
                                                                        
           MOVE '8860' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BILL_ADDR_XREF                            
              WHERE  ADDRESS_ID               = :AT-ADDRESS-ID          
              AND    ACCOUNT_NO               = :WS-ACCOUNT-NO-D        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T25068     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-2        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
CBSI          MOVE AT-ADDRESS-ID              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************39950000
      * 8880-DELETE-TBADRFMT                                           *39960000
      *                                                                *39970000
      *     CALLS 9000-SEND-ERROR-RESULT                               *39980000
      *           9900-SQL-ERROR-ROUTINE                               *39990000
      *                                                                *40000000
      *     CALLED FROM 5300-PROCESS-ADDR-FORM                         *40010000
      *                                                                *40020000
      *     DELETES A ROW FROM CSS_ADDR_FORMATTED                      *40051000
      ******************************************************************40040000
                                                                        
       8880-DELETE-TBADRFMT.                                            
                                                                        
           MOVE '8880' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FORMATTED                            
              WHERE  ADDRESS_ID               = :AT-ADDRESS-ID          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE AT-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8880-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40340000
      * 8890-DELETE-TBADRFRE                                           *40350000
      *                                                                *40360000
      *     CALLS 9000-SEND-ERROR-RESULT                               *40370000
      *           9900-SQL-ERROR-ROUTINE                               *40380000
      *                                                                *40390000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *40400000
      *                                                                *40410000
      *     DELETES A ROW FROM CSS_ADDR_FREEFORM                       *40420000
      ******************************************************************40451000
                                                                        
       8890-DELETE-TBADRFRE.                                            
                                                                        
           MOVE '8890' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
              WHERE  ADDRESS_ID               = :AT-ADDRESS-ID          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE AT-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8890-EXIT.                                                       
           EXIT.                                                        
                                                                        
T20179 8910-DELETE-AQ.                                                  
T20179                                                                  
T20179     MOVE '8910' TO ACTIVE-PARAGRAPH.                             
T20179                                                                  
T20179     EXEC SQL                                                     
T20179         DELETE FROM CSS_BILL_ADDR_XREF                           
T20179          WHERE ADDRESS_ID          = :WS-DELETE-ADDR-ID          
T20179     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20179                                                                  
T20179     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T20179        NEXT SENTENCE                                             
T20179     ELSE                                                         
T20179        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T20179        MOVE 'DELETE'                   TO ABEND-FUNCTION         
T20179        MOVE 'CSS_BILL_ADDR_XREF'       TO TABLE-1                
T20179        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T20179        MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-2        
T20179        MOVE AT-ADDRESS-ID              TO WS-ADDRESS-ID-I        
T20179        MOVE WS-ADDRESS-ID-I            TO WS-ADDRESS-ID-S        
T20179        MOVE WS-ADDRESS-ID-S            TO HOSTVAR-ELEMENT-1      
T20179        MOVE PARM-ADDRESS-ID            TO HOSTVAR-ELEMENT-2      
T20179        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T20179        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T20179     END-IF.                                                      
T20179                                                                  
T20179 8910-EXIT.                                                       
T20179     EXIT.                                                        
T20179                                                                  
T20179 8920-UPDATE-AT.                                                  
T20179                                                                  
T20179     MOVE '8920' TO ACTIVE-PARAGRAPH.                             
T20179                                                                  
T20179     EXEC SQL                                                     
T20179         UPDATE CSS_ACCOUNT                                       
T20179            SET ADDRESS_ID = 0,                                   
T20179                ADDRESS_FORMAT = ' '                              
T20179          WHERE ADDRESS_ID  = :WS-DELETE-ADDR-ID                  
T20179     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20179                                                                  
T20179     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T20179        NEXT SENTENCE                                             
T20179     ELSE                                                         
T20179        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T20179        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T20179        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
T20179        MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
T20179        MOVE PARM-ADDRESS-ID            TO HOSTVAR-ELEMENT-1      
T20179        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T20179        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T20179     END-IF.                                                      
T20179                                                                  
T20179 8920-EXIT.                                                       
T20179     EXIT.                                                        
                                                                        
      ******************************************************************40751000
      *       END PROGRAM COPYLIB                                      *40740000
      ******************************************************************40750000
REARCH* INCLUDED COPY BOOK HAVING COMMIT LOGIC  BEFORE STOP RUN.        40770000
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00331                                        16360000
REARCH     END-EXEC.                                                    16360000
      ******************************************************************40780000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     40790000
      ******************************************************************40800000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
