       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02048.                                         
       DATE-WRITTEN.     MAR 13, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S048 CONVERTED TO DB2 SP CSR02048 ON 08/28/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S048                                           *        
      *  PROGRAM:       S048                                           *        
      *  CALLING SP:    PN_S048                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ACCOUNT BILLING ADDRESS INCLUDING  *        
      *  FORMATTED OR FREEFORM, INDIVIDUAL OR BUSINESS.                *        
      *                                                                *        
      *  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *        
      *                                                                *        
      *  TABLE                  TABLE ID     DCLGEN                    *        
      *  -----                  --------     ------                    *        
      *  CSS_ACCOUNT               AT        TBACCT                    *        
      *  CSS_ACCT_BILL_NAMES       AB        TBATBLNM                  *        
      *  CSS_ADDR_FORMATTED        DY        TBADRFMT                  *        
      *  CSS_ADDR_FREEFORM         DZ        TBADRFRE                  *        
      *  CSS_NAME                  DQ        TBNAME                    *        
      *  CSS_ZIP_CODE              A4        TBZIPCD                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  03/13/95    RKL      CREATED.                                 *        
      *  05/25/95    MRB      ADDED ADDRESS SUFFIX RETREVAL.           *        
      *  07/25/95    WMG      MODIFIED TO FIX TPR #5959:               *        
      *                       THE LOGIC WHEN SELECTING ADDRESS INFO IN *        
      *                       THE 2400 PARAGRAPH WAS MOVED WITHIN THE  *        
      *                       IF STATEMENT SO THAT A FORMATTED OR A    *        
      *                       FREEFORM ADDRESS SELECT WOULD ONLY BE    *        
      *                       PERFORMED IF THE ADDRESS TYPE IS NOT     *        
      *                       BLANK.                                   *        
T12402*  07/30/97    AS       CHANGED RS-FO-STREET-LOCATION-2 FROM     *        
      *                       X(4) TO X(6) TO CONFIRM WITH DATABASE.   *        
T15277*  03/11/98    FB       CHANGED THE LENGTH OF FR-ADDRESS-        *        
T15277*                       OVERFLOW FROM 20 TO 35.                  *        
T15613*  03/25/98    FB       CLEANED UP ABEND DISPLAY FIELDS.         *        
CBSI  *  07/17/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18202*  10/19/98    FB       ADDED ZIP CODE TOKEN TO 7240.            *        
T18537*  12/02/98    FB       7260- ROUTINE WAS NOT PERFORMING 9000-   *        
      *                       ROUTINE RESULTING IN A WHITE BOX ERROR.  *        
REARCH*  02/13/06    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C35671*  09/03/07    CVNS     NAME AND ADDRESS FORMAT CHANGES          *        
C35671*              CHENNAI                                           *        
P00547*  05/03/13    DB18339  ADDING INTERNATIONAL ADDRESS COLUMNS     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02048'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02048 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCOUNT >                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCT_BILL_NMES >                                               
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FORMATTED >                                               
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FREEFORM >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >                  
      *----< SYBASE OPEN SERVER FOR CICS FACILITIES.             >              
CVT999*    COPY SYGWCOB.                                                        
      *----< ADDED TO SUPPORT CICS RPCS >                                       
CVT999*    COPY SYDBCOB.                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
CVT999*    COPY CWS00010.                                                       
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR02048'.  
CVT999*    05  GWL-PROC                  POINTER.                               
CVT999*    05  GWL-INIT-HANDLE           POINTER.                               
CVT999*    05  GWL-RC                    PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-NR             PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-DONE           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COUNT          PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-COMM           PIC S9(9)   COMP.                      
CVT999*    05  GWL-STATUS-RETURN-CODE    PIC S9(9)   COMP.                      
           05  GWL-STATUS-SUBCODE        PIC S9(9)   COMP.              
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9)   COMP.              
CVT999*    05  PARM-ID1                  PIC S9(9)   COMP VALUE 1.              
           05  PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9)   COMP.              
CVT999*    05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.              
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM           PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN1                   PIC S9(9)   COMP.                      
CVT999*    05  WRKLEN2                   PIC S9(9)   COMP.                      
           05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
           05  RS-ACCOUNT-NO             PIC S9(13)V USAGE COMP-3       
                                                          VALUE 0.      
           05  RS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
           05  RS-AT-NAME-ID             PIC S9(13)V USAGE COMP-3       
                                                          VALUE 0.      
           05  RS-AT-NAME-FORMAT         PIC X(01)   VALUE SPACES.      
           05  RS-AT-NAME-TYPE           PIC X(02)   VALUE SPACES.      
           05  RS-AT-FIRST-NAME          PIC X(15)   VALUE SPACES.      
           05  RS-AT-MIDDLE-NAME         PIC X(15)   VALUE SPACES.      
C35671     05  RS-AT-LAST-NAME           PIC X(40)   VALUE SPACES.      
           05  RS-AT-TITLE-PREFIX        PIC X(09)   VALUE SPACES.      
           05  RS-AT-TITLE-SUFFIX-1      PIC X(03)   VALUE SPACES.      
           05  RS-AT-TITLE-SUFFIX-2      PIC X(03)   VALUE SPACES.      
C35671     05  RS-AT-FULL-NAME           PIC X(70)   VALUE SPACES.      
           05  RS-NB-NAME-ID             PIC S9(13)V USAGE COMP-3       
                                                          VALUE 0.      
           05  RS-NB-NAME-FORMAT         PIC X(01)   VALUE SPACES.      
           05  RS-NB-NAME-TYPE           PIC X(02)   VALUE SPACES.      
           05  RS-NB-FIRST-NAME          PIC X(15)   VALUE SPACES.      
           05  RS-NB-MIDDLE-NAME         PIC X(15)   VALUE SPACES.      
C35671     05  RS-NB-LAST-NAME           PIC X(40)   VALUE SPACES.      
           05  RS-NB-TITLE-PREFIX        PIC X(09)   VALUE SPACES.      
           05  RS-NB-TITLE-SUFFIX-1      PIC X(03)   VALUE SPACES.      
           05  RS-NB-TITLE-SUFFIX-2      PIC X(03)   VALUE SPACES.      
C35671     05  RS-NB-FULL-NAME           PIC X(70)   VALUE SPACES.      
           05  RS-ADDRESS-ID             PIC S9(13)V USAGE COMP-3       
                                                          VALUE 0.      
C35671     05  RS-FO-HOUSE-NO            PIC X(15)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-1       PIC X(03)   VALUE SPACES.      
           05  RS-FO-ADDR-PREFIX-2       PIC X(02)   VALUE SPACES.      
C35671     05  RS-FO-STREET-NAME         PIC X(30)   VALUE SPACES.      
           05  RS-FO-STREET-SUFFIX       PIC X(04)   VALUE SPACES.      
           05  RS-FO-STREET-LOCATION-1   PIC X(04)   VALUE SPACES.      
C35671     05  RS-FO-STREET-LOCATION-2   PIC X(11)   VALUE SPACES.      
           05  RS-FO-ADDRESS-OVERFLOW    PIC X(26)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE            PIC X(05)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE-PL-FOUR    PIC X(04)   VALUE SPACES.      
           05  RS-FO-ZIP-CODE-TOKEN      PIC X(01)   VALUE SPACES.      
           05  RS-FO-ADDR-USAGE-CD       PIC X(01)   VALUE SPACES.      
           05  RS-FO-TOWN                PIC X(26)   VALUE SPACES.      
           05  RS-FO-STATE               PIC X(02)   VALUE SPACES.      
C35671     05  RS-FR-ADDR-STREET         PIC X(55)   VALUE SPACES.      
T15277     05  RS-FR-ADDRESS-OVERFLOW    PIC X(35)   VALUE SPACES.      
C35671     05  RS-FR-CITY-STATE          PIC X(30)   VALUE SPACES.      
           05  RS-FR-ZIP-CODE            PIC X(09)   VALUE SPACES.      
           05  RS-FR-COUNTRY             PIC X(35)   VALUE SPACES.      
           05  RS-ADDR-SUFFIX            PIC X(02)   VALUE SPACES.      
           05  RS-CARRIER-ROUTE          PIC X(05)   VALUE SPACES.      
P00547     05  RS-INTRNTNL-CITY          PIC X(40)   VALUE SPACES.      
P00547     05  RS-INTRNTNL-PROVINCE      PIC X(10)   VALUE SPACES.      
P00547     05  RS-INTRNTNL-POST-CODE     PIC X(25)   VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
REARCH     05  S-ACCOUNT-NO              PIC S9(13)V USAGE COMP-3       
REARCH                                                   VALUE 0.       
REARCH     05  S-ADDRESS-FORMAT          PIC X(01)   VALUE SPACES.      
REARCH     05  S-AT-NAME-ID              PIC S9(13)V USAGE COMP-3       
REARCH                                                   VALUE 0.       
REARCH     05  S-AT-NAME-FORMAT          PIC X(01)   VALUE SPACES.      
REARCH     05  S-AT-NAME-TYPE            PIC X(02)   VALUE SPACES.      
REARCH     05  S-AT-FIRST-NAME           PIC X(15)   VALUE SPACES.      
REARCH     05  S-AT-MIDDLE-NAME          PIC X(15)   VALUE SPACES.      
C35671     05  S-AT-LAST-NAME            PIC X(40)   VALUE SPACES.      
REARCH     05  S-AT-TITLE-PREFIX         PIC X(09)   VALUE SPACES.      
REARCH     05  S-AT-TITLE-SUFFIX-1       PIC X(03)   VALUE SPACES.      
REARCH     05  S-AT-TITLE-SUFFIX-2       PIC X(03)   VALUE SPACES.      
C35671     05  S-AT-FULL-NAME            PIC X(70)   VALUE SPACES.      
REARCH     05  S-NB-NAME-ID              PIC S9(13)V USAGE COMP-3       
REARCH                                                   VALUE 0.       
REARCH     05  S-NB-NAME-FORMAT          PIC X(01)   VALUE SPACES.      
REARCH     05  S-NB-NAME-TYPE            PIC X(02)   VALUE SPACES.      
REARCH     05  S-NB-FIRST-NAME           PIC X(15)   VALUE SPACES.      
REARCH     05  S-NB-MIDDLE-NAME          PIC X(15)   VALUE SPACES.      
C35671     05  S-NB-LAST-NAME            PIC X(40)   VALUE SPACES.      
REARCH     05  S-NB-TITLE-PREFIX         PIC X(09)   VALUE SPACES.      
REARCH     05  S-NB-TITLE-SUFFIX-1       PIC X(03)   VALUE SPACES.      
REARCH     05  S-NB-TITLE-SUFFIX-2       PIC X(03)   VALUE SPACES.      
C35671     05  S-NB-FULL-NAME            PIC X(70)   VALUE SPACES.      
REARCH     05  S-ADDRESS-ID              PIC S9(13)V USAGE COMP-3       
REARCH                                                   VALUE 0.       
C35671     05  S-FO-HOUSE-NO             PIC X(15)   VALUE SPACES.      
REARCH     05  S-FO-ADDR-PREFIX-1        PIC X(03)   VALUE SPACES.      
REARCH     05  S-FO-ADDR-PREFIX-2        PIC X(02)   VALUE SPACES.      
C35671     05  S-FO-STREET-NAME          PIC X(30)   VALUE SPACES.      
REARCH     05  S-FO-STREET-SUFFIX        PIC X(04)   VALUE SPACES.      
REARCH     05  S-FO-STREET-LOCATION-1    PIC X(04)   VALUE SPACES.      
C35671     05  S-FO-STREET-LOCATION-2    PIC X(11)   VALUE SPACES.      
REARCH     05  S-FO-ADDRESS-OVERFLOW     PIC X(26)   VALUE SPACES.      
REARCH     05  S-FO-ZIP-CODE             PIC X(05)   VALUE SPACES.      
REARCH     05  S-FO-ZIP-CODE-PL-FOUR     PIC X(04)   VALUE SPACES.      
REARCH     05  S-FO-ZIP-CODE-TOKEN       PIC X(01)   VALUE SPACES.      
REARCH     05  S-FO-ADDR-USAGE-CD        PIC X(01)   VALUE SPACES.      
REARCH     05  S-FO-TOWN                 PIC X(26)   VALUE SPACES.      
REARCH     05  S-FO-STATE                PIC X(02)   VALUE SPACES.      
C35671     05  S-FR-ADDR-STREET          PIC X(55)   VALUE SPACES.      
REARCH     05  S-FR-ADDRESS-OVERFLOW     PIC X(35)   VALUE SPACES.      
REARCH     05  S-FR-CITY-STATE           PIC X(30)   VALUE SPACES.      
REARCH     05  S-FR-ZIP-CODE             PIC X(09)   VALUE SPACES.      
REARCH     05  S-FR-COUNTRY              PIC X(35)   VALUE SPACES.      
REARCH     05  S-ADDR-SUFFIX             PIC X(02)   VALUE SPACES.      
REARCH     05  S-CARRIER-ROUTE           PIC X(05)   VALUE SPACES.      
P00547     05  S-INTRNTNL-CITY           PIC X(40)   VALUE SPACES.      
P00547     05  S-INTRNTNL-PROVINCE       PIC X(10)   VALUE SPACES.      
P00547     05  S-INTRNTNL-POST-CODE      PIC X(25)   VALUE SPACES.      
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO             PIC X(13)   VALUE SPACES.      
           05  WS-ACCOUNT-NO-I           PIC S9(13)  USAGE COMP.        
COB305     05 WS-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-ADDRESS-FORMAT         PIC X(01)   VALUE SPACES.      
COB305     05 WS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-NAME-ID-S              PIC X(13)   VALUE SPACES.      
           05  WS-NAME-TYPE              PIC X(02)   VALUE SPACES.      
           05  WS-NAME-TYPE-IND          PIC S9(1)   COMP VALUE 0.      
           05  WS-NAME-FORMAT            PIC X(01)   VALUE SPACES.      
COB305     05 WS-AT-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-AT-NAME-FORMAT         PIC X(01)   VALUE SPACES.      
           05  WS-AT-NAME-TYPE           PIC X(02)   VALUE SPACES.      
           05  WS-AT-FIRST-NAME          PIC X(15)   VALUE SPACES.      
           05  WS-AT-MIDDLE-NAME         PIC X(15)   VALUE SPACES.      
C35671     05  WS-AT-LAST-NAME           PIC X(40)   VALUE SPACES.      
           05  WS-AT-TITLE-PREFIX        PIC X(09)   VALUE SPACES.      
           05  WS-AT-TITLE-SUFFIX-1      PIC X(03)   VALUE SPACES.      
           05  WS-AT-TITLE-SUFFIX-2      PIC X(03)   VALUE SPACES.      
C35671     05  WS-AT-FULL-NAME           PIC X(70)   VALUE SPACES.      
COB305     05 WS-NB-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-NB-NAME-FORMAT         PIC X(01)   VALUE SPACES.      
           05  WS-NB-NAME-TYPE           PIC X(02)   VALUE SPACES.      
           05  WS-NB-FIRST-NAME          PIC X(15)   VALUE SPACES.      
           05  WS-NB-MIDDLE-NAME         PIC X(15)   VALUE SPACES.      
C35671     05  WS-NB-LAST-NAME           PIC X(40)   VALUE SPACES.      
           05  WS-NB-TITLE-PREFIX        PIC X(09)   VALUE SPACES.      
           05  WS-NB-TITLE-SUFFIX-1      PIC X(03)   VALUE SPACES.      
           05  WS-NB-TITLE-SUFFIX-2      PIC X(03)   VALUE SPACES.      
C35671     05  WS-NB-FULL-NAME           PIC X(70)   VALUE SPACES.      
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-ADDRESS-ID-S           PIC X(13)   VALUE SPACES.      
           05  WS-ZIP-CODE               PIC X(05)   VALUE SPACES.      
           05  WS-ZIP-CODE-TOKEN         PIC X(01)   VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE AB-CURSOR CURSOR FOR                        
              SELECT  NAME_ID,                                          
                      NAME_TYPE                                         
              FROM    CSS_ACCT_BILL_NMES                                
              WHERE   ACCOUNT_NO = :WS-ACCOUNT-NO-D                     
                AND   NAME_TYPE  IN ('AA','AI','AN')                    
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH         :S-RETURN-CODE                 AS    RETURN_CODE         
REARCH        ,:S-ACCOUNT-NO                  AS    ACCOUNT_NO          
REARCH        ,:S-ADDRESS-FORMAT              AS    ADDRESS_FORMAT      
REARCH        ,:S-AT-NAME-ID                  AS    AT_NAME_ID          
REARCH        ,LTRIM(RTRIM(:S-AT-NAME-FORMAT))       AS    
           AT_NAME_FORMAT      
REARCH        ,LTRIM(RTRIM(:S-AT-NAME-TYPE))         AS    AT_NAME_TYPE        
REARCH        ,LTRIM(RTRIM(:S-AT-FIRST-NAME))        AS    AT_FIRST_NAME       
REARCH        ,LTRIM(RTRIM(:S-AT-MIDDLE-NAME))       AS    
           AT_MIDDLE_NAME      
REARCH        ,LTRIM(RTRIM(:S-AT-LAST-NAME))         AS    AT_LAST_NAME        
REARCH        ,LTRIM(RTRIM(:S-AT-TITLE-PREFIX))      AS    
           AT_TITLE_PREFIX     
REARCH        ,LTRIM(RTRIM(:S-AT-TITLE-SUFFIX-1))    AS    
           AT_TITLE_SUFFIX_1   
REARCH        ,LTRIM(RTRIM(:S-AT-TITLE-SUFFIX-2))    AS    
           AT_TITLE_SUFFIX_2   
REARCH        ,LTRIM(RTRIM(:S-AT-FULL-NAME))         AS    AT_FULL_NAME        
REARCH        ,:S-NB-NAME-ID                  AS    NB_NAME_ID          
REARCH        ,LTRIM(RTRIM(:S-NB-NAME-FORMAT))       AS    
           NB_NAME_FORMAT      
REARCH        ,LTRIM(RTRIM(:S-NB-NAME-TYPE))         AS    NB_NAME_TYPE        
REARCH        ,LTRIM(RTRIM(:S-NB-FIRST-NAME))        AS    NB_FIRST_NAME       
REARCH        ,LTRIM(RTRIM(:S-NB-MIDDLE-NAME))       AS    
           NB_MIDDLE_NAME      
REARCH        ,LTRIM(RTRIM(:S-NB-LAST-NAME))         AS    NB_LAST_NAME        
REARCH        ,LTRIM(RTRIM(:S-NB-TITLE-PREFIX))      AS    
           NB_TITLE_PREFIX     
REARCH        ,LTRIM(RTRIM(:S-NB-TITLE-SUFFIX-1))    AS    
           NB_TITLE_SUFFIX_1   
REARCH        ,LTRIM(RTRIM(:S-NB-TITLE-SUFFIX-2))    AS    
           NB_TITLE_SUFFIX_2   
REARCH        ,LTRIM(RTRIM(:S-NB-FULL-NAME))         AS    NB_FULL_NAME        
REARCH        ,:S-ADDRESS-ID                  AS    ADDRESS_ID          
REARCH        ,LTRIM(RTRIM(:S-FO-HOUSE-NO))          AS    FO_HOUSE_NO         
REARCH        ,LTRIM(RTRIM(:S-FO-ADDR-PREFIX-1))     AS    
           FO_ADDR_PREFIX_1    
REARCH        ,LTRIM(RTRIM(:S-FO-ADDR-PREFIX-2))     AS    
           FO_ADDR_PREFIX_2    
REARCH        ,LTRIM(RTRIM(:S-FO-STREET-NAME))       AS    
           FO_STREET_NAME      
REARCH        ,LTRIM(RTRIM(:S-FO-STREET-SUFFIX))     AS    
           FO_STREET_SUFFIX    
REARCH        ,LTRIM(RTRIM(:S-FO-STREET-LOCATION-1)) AS    
           FO_STREET_LOCTN_1   
REARCH        ,LTRIM(RTRIM(:S-FO-STREET-LOCATION-2)) AS    
           FO_STREET_LOCTN_2   
REARCH        ,LTRIM(RTRIM(:S-FO-ADDRESS-OVERFLOW))  AS    
           FO_ADDRESS_OVRFLOW  
REARCH        ,LTRIM(RTRIM(:S-FO-ZIP-CODE))          AS    FO_ZIP_CODE         
REARCH        ,LTRIM(RTRIM(:S-FO-ZIP-CODE-PL-FOUR))  AS    
           FO_ZIP_CODE_PL_FR   
REARCH        ,LTRIM(RTRIM(:S-FO-ZIP-CODE-TOKEN))    AS    
           FO_ZIP_CODE_TOKEN   
REARCH        ,LTRIM(RTRIM(:S-FO-ADDR-USAGE-CD))     AS    
           FO_ADDR_USAGE_CD    
REARCH        ,LTRIM(RTRIM(:S-FO-TOWN))              AS    FO_TOWN             
REARCH        ,LTRIM(RTRIM(:S-FO-STATE))             AS    FO_STATE            
REARCH        ,LTRIM(RTRIM(:S-FR-ADDR-STREET))       AS    
           FR_ADDR_STREET      
REARCH        ,LTRIM(RTRIM(:S-FR-ADDRESS-OVERFLOW))  AS    
           FR_ADDRESS_OVRFLOW  
REARCH        ,LTRIM(RTRIM(:S-FR-CITY-STATE))        AS    FR_CITY_STATE       
REARCH        ,:S-FR-ZIP-CODE                 AS    FR_ZIP_CODE         
REARCH        ,LTRIM(RTRIM(:S-FR-COUNTRY))           AS    FR_COUNTRY          
REARCH        ,LTRIM(RTRIM(:S-ADDR-SUFFIX))          AS    ADDR_SUFFIX         
REARCH        ,LTRIM(RTRIM(:S-CARRIER-ROUTE))        AS    CARRIER_ROUTE       
P00547        ,LTRIM(RTRIM(:S-INTRNTNL-CITY))        AS    INTRNTNL_CITY       
P00547        ,LTRIM(RTRIM(:S-INTRNTNL-PROVINCE))    AS    
           INTRNTNL_PROVINCE   
P00547        ,LTRIM(RTRIM(:S-INTRNTNL-POST-CODE))   AS    
           INTRNTNL_POST_CODE  
CVT000        FROM CIS.SYSDUMMY1                                     
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*        :S-RETURN-CODE                 AS    RETURN_CODE                 
MFA-TR*       ,:S-ACCOUNT-NO                  AS    ACCOUNT_NO                  
MFA-TR*       ,:S-ADDRESS-FORMAT              AS    ADDRESS_FORMAT              
MFA-TR*       ,:S-AT-NAME-ID                  AS    AT_NAME_ID                  
MFA-TR*       ,STRIP(:S-AT-NAME-FORMAT)       AS    AT_NAME_FORMAT              
MFA-TR*       ,STRIP(:S-AT-NAME-TYPE)         AS    AT_NAME_TYPE                
MFA-TR*       ,STRIP(:S-AT-FIRST-NAME)        AS    AT_FIRST_NAME               
MFA-TR*       ,STRIP(:S-AT-MIDDLE-NAME)       AS    AT_MIDDLE_NAME              
MFA-TR*       ,STRIP(:S-AT-LAST-NAME)         AS    AT_LAST_NAME                
MFA-TR*       ,STRIP(:S-AT-TITLE-PREFIX)      AS    AT_TITLE_PREFIX             
MFA-TR*       ,STRIP(:S-AT-TITLE-SUFFIX-1)    AS    AT_TITLE_SUFFIX_1           
MFA-TR*       ,STRIP(:S-AT-TITLE-SUFFIX-2)    AS    AT_TITLE_SUFFIX_2           
MFA-TR*       ,STRIP(:S-AT-FULL-NAME)         AS    AT_FULL_NAME                
MFA-TR*       ,:S-NB-NAME-ID                  AS    NB_NAME_ID                  
MFA-TR*       ,STRIP(:S-NB-NAME-FORMAT)       AS    NB_NAME_FORMAT              
MFA-TR*       ,STRIP(:S-NB-NAME-TYPE)         AS    NB_NAME_TYPE                
MFA-TR*       ,STRIP(:S-NB-FIRST-NAME)        AS    NB_FIRST_NAME               
MFA-TR*       ,STRIP(:S-NB-MIDDLE-NAME)       AS    NB_MIDDLE_NAME              
MFA-TR*       ,STRIP(:S-NB-LAST-NAME)         AS    NB_LAST_NAME                
MFA-TR*       ,STRIP(:S-NB-TITLE-PREFIX)      AS    NB_TITLE_PREFIX             
MFA-TR*       ,STRIP(:S-NB-TITLE-SUFFIX-1)    AS    NB_TITLE_SUFFIX_1           
MFA-TR*       ,STRIP(:S-NB-TITLE-SUFFIX-2)    AS    NB_TITLE_SUFFIX_2           
MFA-TR*       ,STRIP(:S-NB-FULL-NAME)         AS    NB_FULL_NAME                
MFA-TR*       ,:S-ADDRESS-ID                  AS    ADDRESS_ID                  
MFA-TR*       ,STRIP(:S-FO-HOUSE-NO)          AS    FO_HOUSE_NO                 
MFA-TR*       ,STRIP(:S-FO-ADDR-PREFIX-1)     AS    FO_ADDR_PREFIX_1            
MFA-TR*       ,STRIP(:S-FO-ADDR-PREFIX-2)     AS    FO_ADDR_PREFIX_2            
MFA-TR*       ,STRIP(:S-FO-STREET-NAME)       AS    FO_STREET_NAME              
MFA-TR*       ,STRIP(:S-FO-STREET-SUFFIX)     AS    FO_STREET_SUFFIX            
MFA-TR*       ,STRIP(:S-FO-STREET-LOCATION-1) AS    FO_STREET_LOCTN_1           
MFA-TR*       ,STRIP(:S-FO-STREET-LOCATION-2) AS    FO_STREET_LOCTN_2           
MFA-TR*       ,STRIP(:S-FO-ADDRESS-OVERFLOW)  AS    FO_ADDRESS_OVRFLOW          
MFA-TR*       ,STRIP(:S-FO-ZIP-CODE)          AS    FO_ZIP_CODE                 
MFA-TR*       ,STRIP(:S-FO-ZIP-CODE-PL-FOUR)  AS    FO_ZIP_CODE_PL_FR           
MFA-TR*       ,STRIP(:S-FO-ZIP-CODE-TOKEN)    AS    FO_ZIP_CODE_TOKEN           
MFA-TR*       ,STRIP(:S-FO-ADDR-USAGE-CD)     AS    FO_ADDR_USAGE_CD            
MFA-TR*       ,STRIP(:S-FO-TOWN)              AS    FO_TOWN                     
MFA-TR*       ,STRIP(:S-FO-STATE)             AS    FO_STATE                    
MFA-TR*       ,STRIP(:S-FR-ADDR-STREET)       AS    FR_ADDR_STREET              
MFA-TR*       ,STRIP(:S-FR-ADDRESS-OVERFLOW)  AS    FR_ADDRESS_OVRFLOW          
MFA-TR*       ,STRIP(:S-FR-CITY-STATE)        AS    FR_CITY_STATE               
MFA-TR*       ,:S-FR-ZIP-CODE                 AS    FR_ZIP_CODE                 
MFA-TR*       ,STRIP(:S-FR-COUNTRY)           AS    FR_COUNTRY                  
MFA-TR*       ,STRIP(:S-ADDR-SUFFIX)          AS    ADDR_SUFFIX                 
MFA-TR*       ,STRIP(:S-CARRIER-ROUTE)        AS    CARRIER_ROUTE               
MFA-TR*       ,STRIP(:S-INTRNTNL-CITY)        AS    INTRNTNL_CITY               
MFA-TR*       ,STRIP(:S-INTRNTNL-PROVINCE)    AS    INTRNTNL_PROVINCE           
MFA-TR*       ,STRIP(:S-INTRNTNL-POST-CODE)   AS    INTRNTNL_POST_CODE          
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO    TO WS-ACCOUNT-NO.                    
           MOVE WS-ACCOUNT-NO      TO WS-ACCOUNT-NO-I.                  
           MOVE WS-ACCOUNT-NO-I    TO WS-ACCOUNT-NO-D.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2400-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 2400-BUILD-RESULT             THRU 2400-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*2000A-MOVE-RESULT.                                             *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-ACCOUNT-NO             TO S-ACCOUNT-NO.              
REARCH     MOVE RS-ADDRESS-FORMAT         TO S-ADDRESS-FORMAT.          
REARCH     MOVE RS-AT-NAME-ID             TO S-AT-NAME-ID.              
REARCH     MOVE RS-AT-NAME-FORMAT         TO S-AT-NAME-FORMAT.          
REARCH     MOVE RS-AT-NAME-TYPE           TO S-AT-NAME-TYPE.            
REARCH     MOVE RS-AT-FIRST-NAME          TO S-AT-FIRST-NAME.           
REARCH     MOVE RS-AT-MIDDLE-NAME         TO S-AT-MIDDLE-NAME.          
REARCH     MOVE RS-AT-LAST-NAME           TO S-AT-LAST-NAME.            
REARCH     MOVE RS-AT-TITLE-PREFIX        TO S-AT-TITLE-PREFIX.         
REARCH     MOVE RS-AT-TITLE-SUFFIX-1      TO S-AT-TITLE-SUFFIX-1.       
REARCH     MOVE RS-AT-TITLE-SUFFIX-2      TO S-AT-TITLE-SUFFIX-2.       
REARCH     MOVE RS-AT-FULL-NAME           TO S-AT-FULL-NAME.            
REARCH     MOVE RS-NB-NAME-ID             TO S-NB-NAME-ID.              
REARCH     MOVE RS-NB-NAME-FORMAT         TO S-NB-NAME-FORMAT.          
REARCH     MOVE RS-NB-NAME-TYPE           TO S-NB-NAME-TYPE.            
REARCH     MOVE RS-NB-FIRST-NAME          TO S-NB-FIRST-NAME.           
REARCH     MOVE RS-NB-MIDDLE-NAME         TO S-NB-MIDDLE-NAME.          
REARCH     MOVE RS-NB-LAST-NAME           TO S-NB-LAST-NAME.            
REARCH     MOVE RS-NB-TITLE-PREFIX        TO S-NB-TITLE-PREFIX.         
REARCH     MOVE RS-NB-TITLE-SUFFIX-1      TO S-NB-TITLE-SUFFIX-1.       
REARCH     MOVE RS-NB-TITLE-SUFFIX-2      TO S-NB-TITLE-SUFFIX-2.       
REARCH     MOVE RS-NB-FULL-NAME           TO S-NB-FULL-NAME.            
REARCH     MOVE RS-ADDRESS-ID             TO S-ADDRESS-ID.              
REARCH     MOVE RS-FO-HOUSE-NO            TO S-FO-HOUSE-NO.             
REARCH     MOVE RS-FO-ADDR-PREFIX-1       TO S-FO-ADDR-PREFIX-1.        
REARCH     MOVE RS-FO-ADDR-PREFIX-2       TO S-FO-ADDR-PREFIX-2.        
REARCH     MOVE RS-FO-STREET-NAME         TO S-FO-STREET-NAME.          
REARCH     MOVE RS-FO-STREET-SUFFIX       TO S-FO-STREET-SUFFIX.        
REARCH     MOVE RS-FO-STREET-LOCATION-1   TO S-FO-STREET-LOCATION-1.    
REARCH     MOVE RS-FO-STREET-LOCATION-2   TO S-FO-STREET-LOCATION-2.    
REARCH     MOVE RS-FO-ADDRESS-OVERFLOW    TO S-FO-ADDRESS-OVERFLOW.     
REARCH     MOVE RS-FO-ZIP-CODE            TO S-FO-ZIP-CODE.             
REARCH     MOVE RS-FO-ZIP-CODE-PL-FOUR    TO S-FO-ZIP-CODE-PL-FOUR.     
REARCH     MOVE RS-FO-ZIP-CODE-TOKEN      TO S-FO-ZIP-CODE-TOKEN.       
REARCH     MOVE RS-FO-ADDR-USAGE-CD       TO S-FO-ADDR-USAGE-CD.        
REARCH     MOVE RS-FO-TOWN                TO S-FO-TOWN.                 
REARCH     MOVE RS-FO-STATE               TO S-FO-STATE.                
REARCH     MOVE RS-FR-ADDR-STREET         TO S-FR-ADDR-STREET.          
REARCH     MOVE RS-FR-ADDRESS-OVERFLOW    TO S-FR-ADDRESS-OVERFLOW.     
REARCH     MOVE RS-FR-CITY-STATE          TO S-FR-CITY-STATE.           
REARCH     MOVE RS-FR-ZIP-CODE            TO S-FR-ZIP-CODE.             
REARCH     MOVE RS-FR-COUNTRY             TO S-FR-COUNTRY.              
REARCH     MOVE RS-ADDR-SUFFIX            TO S-ADDR-SUFFIX.             
REARCH     MOVE RS-CARRIER-ROUTE          TO S-CARRIER-ROUTE.           
P00547     MOVE RS-INTRNTNL-CITY          TO S-INTRNTNL-CITY.           
P00547     MOVE RS-INTRNTNL-PROVINCE      TO S-INTRNTNL-PROVINCE.       
P00547     MOVE RS-INTRNTNL-POST-CODE     TO S-INTRNTNL-POST-CODE.      
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS  7000-SELECT-ADDR-FRMT                               *        
      *            7220-SELECT-ADDR-FORM                               *        
      *            7240-SELECT-TOWN-ST                                 *        
      *            7260-SELECT-ADDR-FREE                               *        
      *            2500-PROCESS-NAME-ID                                *        
      *            2600-SEND-ADDR-FORM                                 *        
      *            2620-SEND-ADDR-FREE                                 *        
      *            2640-SEND-ADDR-NONE                                 *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2400-BUILD-RESULT.                                               
                                                                        
           MOVE '2400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7000-SELECT-ADDR-FRMT        THRU 7000-EXIT.         
           MOVE AT-ADDRESS-FORMAT               TO WS-ADDRESS-FORMAT.   
                                                                        
           PERFORM 7020-OPEN-AB-CURSOR          THRU 7020-EXIT.         
           PERFORM 7025-SELECT-NAME-ID          THRU 7025-EXIT.         
           PERFORM 2500-PROCESS-NAME-ID         THRU 2500-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7030-CLOSE-AB-CURSOR         THRU 7030-EXIT.         
                                                                        
           IF WS-ADDRESS-FORMAT = ' '                                   
              MOVE ZERO                         TO WS-ADDRESS-ID        
              PERFORM 2640-SEND-ADDR-NONE                               
           ELSE                                                         
              MOVE AT-ADDRESS-ID                TO WS-ADDRESS-ID        
              MOVE WS-ADDRESS-ID                TO WS-ADDRESS-ID-S      
              IF WS-ADDRESS-FORMAT = 'A'                                
                 PERFORM 7220-SELECT-ADDR-FORM  THRU 7220-EXIT          
                 MOVE DY-ZIP-CODE               TO WS-ZIP-CODE          
                 MOVE DY-ZIP-CODE-TOKEN         TO WS-ZIP-CODE-TOKEN    
                 PERFORM 7240-SELECT-TOWN-ST    THRU 7240-EXIT          
                 PERFORM 2600-SEND-ADDR-FORM    THRU 2600-EXIT          
              ELSE                                                      
                 PERFORM 7260-SELECT-ADDR-FREE  THRU 7260-EXIT          
                 PERFORM 2620-SEND-ADDR-FREE    THRU 2620-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-NAME-ID                                           *        
      *                                                                *        
      *     CALLS  7025-SELECT-NAME-ID                                 *        
      *            7100-SELECT-NAME                                    *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULTS                             *        
      *                                                                *        
      *     RETRIEVE THE NAMES OF THE BILLING ADDRESS HEADER.          *        
      ******************************************************************        
                                                                        
       2500-PROCESS-NAME-ID.                                            
                                                                        
           MOVE '2500'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE AB-NAME-ID                   TO WS-NAME-ID.             
           MOVE WS-NAME-ID                   TO WS-NAME-ID-S.           
           MOVE AB-NAME-TYPE                 TO WS-NAME-TYPE.           
                                                                        
           PERFORM 7100-SELECT-NAME          THRU 7100-EXIT.            
                                                                        
           IF WS-NAME-TYPE = 'AA' OR WS-NAME-TYPE = 'AI'                
              ADD  +1                        TO WS-NAME-TYPE-IND        
              MOVE WS-NAME-ID                TO WS-AT-NAME-ID           
              MOVE WS-NAME-TYPE              TO WS-AT-NAME-TYPE         
              MOVE DQ-NAME-FORMAT            TO WS-AT-NAME-FORMAT       
              MOVE DQ-FIRST-NAME             TO WS-AT-FIRST-NAME        
              MOVE DQ-MIDDLE-NAME            TO WS-AT-MIDDLE-NAME       
              MOVE DQ-LAST-NAME              TO WS-AT-LAST-NAME         
              MOVE DQ-TITLE-PREFIX           TO WS-AT-TITLE-PREFIX      
              MOVE DQ-TITLE-SUFFIX-1         TO WS-AT-TITLE-SUFFIX-1    
              MOVE DQ-TITLE-SUFFIX-2         TO WS-AT-TITLE-SUFFIX-2    
              MOVE DQ-FULL-NAME              TO WS-AT-FULL-NAME         
           END-IF.                                                      
                                                                        
           IF WS-NAME-TYPE = 'AN'                                       
              ADD  +2                        TO WS-NAME-TYPE-IND        
              MOVE WS-NAME-ID                TO WS-NB-NAME-ID           
              MOVE WS-NAME-TYPE              TO WS-NB-NAME-TYPE         
              MOVE DQ-NAME-FORMAT            TO WS-NB-NAME-FORMAT       
              MOVE DQ-FIRST-NAME             TO WS-NB-FIRST-NAME        
              MOVE DQ-MIDDLE-NAME            TO WS-NB-MIDDLE-NAME       
              MOVE DQ-LAST-NAME              TO WS-NB-LAST-NAME         
              MOVE DQ-TITLE-PREFIX           TO WS-NB-TITLE-PREFIX      
              MOVE DQ-TITLE-SUFFIX-1         TO WS-NB-TITLE-SUFFIX-1    
              MOVE DQ-TITLE-SUFFIX-2         TO WS-NB-TITLE-SUFFIX-2    
              MOVE DQ-FULL-NAME              TO WS-NB-FULL-NAME         
           END-IF.                                                      
                                                                        
           PERFORM 7025-SELECT-NAME-ID       THRU 7025-EXIT.            
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-SEND-ADDR-FORM                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS THE FORMATTED BILLING ADDRESS RESULT SET.            *        
      ******************************************************************        
                                                                        
       2600-SEND-ADDR-FORM.                                             
                                                                        
           MOVE '2600'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           PERFORM 2700-PROCESS-BILL-HDR   THRU 2700-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-D            TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-AT-NAME-ID              TO RS-AT-NAME-ID.            
           MOVE WS-AT-NAME-TYPE            TO RS-AT-NAME-TYPE.          
           MOVE WS-AT-NAME-FORMAT          TO RS-AT-NAME-FORMAT.        
           MOVE WS-AT-FIRST-NAME           TO RS-AT-FIRST-NAME.         
           MOVE WS-AT-MIDDLE-NAME          TO RS-AT-MIDDLE-NAME.        
           MOVE WS-AT-LAST-NAME            TO RS-AT-LAST-NAME.          
           MOVE WS-AT-TITLE-PREFIX         TO RS-AT-TITLE-PREFIX.       
           MOVE WS-AT-TITLE-SUFFIX-1       TO RS-AT-TITLE-SUFFIX-1.     
           MOVE WS-AT-TITLE-SUFFIX-2       TO RS-AT-TITLE-SUFFIX-2.     
           MOVE WS-AT-FULL-NAME            TO RS-AT-FULL-NAME.          
           MOVE WS-NB-NAME-ID              TO RS-NB-NAME-ID.            
           MOVE WS-NB-NAME-TYPE            TO RS-NB-NAME-TYPE.          
           MOVE WS-NB-NAME-FORMAT          TO RS-NB-NAME-FORMAT.        
           MOVE WS-NB-FIRST-NAME           TO RS-NB-FIRST-NAME.         
           MOVE WS-NB-MIDDLE-NAME          TO RS-NB-MIDDLE-NAME.        
           MOVE WS-NB-LAST-NAME            TO RS-NB-LAST-NAME.          
           MOVE WS-NB-TITLE-PREFIX         TO RS-NB-TITLE-PREFIX.       
           MOVE WS-NB-TITLE-SUFFIX-1       TO RS-NB-TITLE-SUFFIX-1.     
           MOVE WS-NB-TITLE-SUFFIX-2       TO RS-NB-TITLE-SUFFIX-2.     
           MOVE WS-NB-FULL-NAME            TO RS-NB-FULL-NAME.          
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE DY-HOUSE-NO                TO RS-FO-HOUSE-NO.           
           MOVE DY-ADDR-PREFIX-1           TO RS-FO-ADDR-PREFIX-1.      
           MOVE DY-ADDR-PREFIX-2           TO RS-FO-ADDR-PREFIX-2.      
           MOVE DY-STREET-NAME             TO RS-FO-STREET-NAME.        
           MOVE DY-STREET-SUFFIX           TO RS-FO-STREET-SUFFIX.      
           MOVE DY-STREET-LOCATION-1       TO RS-FO-STREET-LOCATION-1.  
           MOVE DY-STREET-LOCATION-2       TO RS-FO-STREET-LOCATION-2.  
           MOVE DY-ADDRESS-OVERFLOW        TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE DY-ZIP-CODE                TO RS-FO-ZIP-CODE.           
           MOVE DY-ZIP-CODE-PLUS-FOUR      TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE DY-ZIP-CODE-TOKEN          TO RS-FO-ZIP-CODE-TOKEN.     
           MOVE DY-ADDR-USAGE-CD           TO RS-FO-ADDR-USAGE-CD.      
           MOVE A4-TOWN                    TO RS-FO-TOWN.               
           MOVE A4-STATE                   TO RS-FO-STATE.              
           MOVE SPACES                     TO RS-FR-ADDR-STREET.        
           MOVE SPACES                     TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FR-CITY-STATE.         
           MOVE SPACES                     TO RS-FR-ZIP-CODE.           
           MOVE SPACES                     TO RS-FR-COUNTRY.            
           MOVE DY-ADDR-SUFFIX             TO RS-ADDR-SUFFIX.           
           MOVE DY-CARRIER-ROUTE           TO RS-CARRIER-ROUTE.         
P00547     MOVE SPACES                     TO RS-INTRNTNL-CITY.         
P00547     MOVE SPACES                     TO RS-INTRNTNL-PROVINCE.     
P00547     MOVE SPACES                     TO RS-INTRNTNL-POST-CODE.    
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2620-SEND-ADDR-FREE                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS THE FREEFORM BILLING ADDRESS RESULT SET.             *        
      ******************************************************************        
                                                                        
       2620-SEND-ADDR-FREE.                                             
                                                                        
           MOVE '2620'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           PERFORM 2700-PROCESS-BILL-HDR   THRU 2700-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-D            TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-AT-NAME-ID              TO RS-AT-NAME-ID.            
           MOVE WS-AT-NAME-TYPE            TO RS-AT-NAME-TYPE.          
           MOVE WS-AT-NAME-FORMAT          TO RS-AT-NAME-FORMAT.        
           MOVE WS-AT-FIRST-NAME           TO RS-AT-FIRST-NAME.         
           MOVE WS-AT-MIDDLE-NAME          TO RS-AT-MIDDLE-NAME.        
           MOVE WS-AT-LAST-NAME            TO RS-AT-LAST-NAME.          
           MOVE WS-AT-TITLE-PREFIX         TO RS-AT-TITLE-PREFIX.       
           MOVE WS-AT-TITLE-SUFFIX-1       TO RS-AT-TITLE-SUFFIX-1.     
           MOVE WS-AT-TITLE-SUFFIX-2       TO RS-AT-TITLE-SUFFIX-2.     
           MOVE WS-AT-FULL-NAME            TO RS-AT-FULL-NAME.          
           MOVE WS-NB-NAME-ID              TO RS-NB-NAME-ID.            
           MOVE WS-NB-NAME-TYPE            TO RS-NB-NAME-TYPE.          
           MOVE WS-NB-NAME-FORMAT          TO RS-NB-NAME-FORMAT.        
           MOVE WS-NB-FIRST-NAME           TO RS-NB-FIRST-NAME.         
           MOVE WS-NB-MIDDLE-NAME          TO RS-NB-MIDDLE-NAME.        
           MOVE WS-NB-LAST-NAME            TO RS-NB-LAST-NAME.          
           MOVE WS-NB-TITLE-PREFIX         TO RS-NB-TITLE-PREFIX.       
           MOVE WS-NB-TITLE-SUFFIX-1       TO RS-NB-TITLE-SUFFIX-1.     
           MOVE WS-NB-TITLE-SUFFIX-2       TO RS-NB-TITLE-SUFFIX-2.     
           MOVE WS-NB-FULL-NAME            TO RS-NB-FULL-NAME.          
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE SPACES                     TO RS-FO-HOUSE-NO.           
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-1.      
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-2.      
           MOVE SPACES                     TO RS-FO-STREET-NAME.        
           MOVE SPACES                     TO RS-FO-STREET-SUFFIX.      
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-1.  
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-2.  
           MOVE SPACES                     TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE.           
           MOVE SPACES                     TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE-TOKEN.     
           MOVE SPACES                     TO RS-FO-ADDR-USAGE-CD.      
           MOVE SPACES                     TO RS-FO-TOWN.               
           MOVE SPACES                     TO RS-FO-STATE.              
           MOVE DZ-ADDR-STREET             TO RS-FR-ADDR-STREET.        
           MOVE DZ-ADDRESS-OVERFLOW        TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE DZ-ADDR-CITY-STATE         TO RS-FR-CITY-STATE.         
           MOVE DZ-ADDR-ZIP-CODE           TO RS-FR-ZIP-CODE.           
           MOVE DZ-ADDR-COUNTRY            TO RS-FR-COUNTRY.            
           MOVE SPACES                     TO RS-ADDR-SUFFIX.           
           MOVE SPACES                     TO RS-CARRIER-ROUTE.         
P00547     MOVE DZ-INTRNTNL-CITY           TO RS-INTRNTNL-CITY.         
P00547     MOVE DZ-INTRNTNL-PROVINCE       TO RS-INTRNTNL-PROVINCE.     
P00547     MOVE DZ-INTRNTNL-POST-CODE      TO RS-INTRNTNL-POST-CODE.    
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2640-SEND-ADDR-NONE                                            *        
      *                                                                *        
      *     CALLS       2700-PROCESS-BILL-HDR                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE RESULT SET.                           *        
      *     THAT IS, AN ACCOUNT BILLING ADDRESS DOES NOT EXIST.        *        
      ******************************************************************        
                                                                        
       2640-SEND-ADDR-NONE.                                             
                                                                        
           MOVE '2640'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           PERFORM 2700-PROCESS-BILL-HDR   THRU 2700-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE WS-ACCOUNT-NO-D            TO RS-ACCOUNT-NO.            
           MOVE WS-ADDRESS-FORMAT          TO RS-ADDRESS-FORMAT.        
           MOVE WS-AT-NAME-ID              TO RS-AT-NAME-ID.            
           MOVE WS-AT-NAME-TYPE            TO RS-AT-NAME-TYPE.          
           MOVE WS-AT-NAME-FORMAT          TO RS-AT-NAME-FORMAT.        
           MOVE WS-AT-FIRST-NAME           TO RS-AT-FIRST-NAME.         
           MOVE WS-AT-MIDDLE-NAME          TO RS-AT-MIDDLE-NAME.        
           MOVE WS-AT-LAST-NAME            TO RS-AT-LAST-NAME.          
           MOVE WS-AT-TITLE-PREFIX         TO RS-AT-TITLE-PREFIX.       
           MOVE WS-AT-TITLE-SUFFIX-1       TO RS-AT-TITLE-SUFFIX-1.     
           MOVE WS-AT-TITLE-SUFFIX-2       TO RS-AT-TITLE-SUFFIX-2.     
           MOVE WS-AT-FULL-NAME            TO RS-AT-FULL-NAME.          
           MOVE WS-NB-NAME-ID              TO RS-NB-NAME-ID.            
           MOVE WS-NB-NAME-TYPE            TO RS-NB-NAME-TYPE.          
           MOVE WS-NB-NAME-FORMAT          TO RS-NB-NAME-FORMAT.        
           MOVE WS-NB-FIRST-NAME           TO RS-NB-FIRST-NAME.         
           MOVE WS-NB-MIDDLE-NAME          TO RS-NB-MIDDLE-NAME.        
           MOVE WS-NB-LAST-NAME            TO RS-NB-LAST-NAME.          
           MOVE WS-NB-TITLE-PREFIX         TO RS-NB-TITLE-PREFIX.       
           MOVE WS-NB-TITLE-SUFFIX-1       TO RS-NB-TITLE-SUFFIX-1.     
           MOVE WS-NB-TITLE-SUFFIX-2       TO RS-NB-TITLE-SUFFIX-2.     
           MOVE WS-NB-FULL-NAME            TO RS-NB-FULL-NAME.          
           MOVE WS-ADDRESS-ID              TO RS-ADDRESS-ID.            
           MOVE SPACES                     TO RS-FO-HOUSE-NO.           
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-1.      
           MOVE SPACES                     TO RS-FO-ADDR-PREFIX-2.      
           MOVE SPACES                     TO RS-FO-STREET-NAME.        
           MOVE SPACES                     TO RS-FO-STREET-SUFFIX.      
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-1.  
           MOVE SPACES                     TO RS-FO-STREET-LOCATION-2.  
           MOVE SPACES                     TO RS-FO-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE.           
           MOVE SPACES                     TO RS-FO-ZIP-CODE-PL-FOUR.   
           MOVE SPACES                     TO RS-FO-ZIP-CODE-TOKEN.     
           MOVE SPACES                     TO RS-FO-ADDR-USAGE-CD.      
           MOVE SPACES                     TO RS-FO-TOWN.               
           MOVE SPACES                     TO RS-FO-STATE.              
           MOVE SPACES                     TO RS-FR-ADDR-STREET.        
           MOVE SPACES                     TO RS-FR-ADDRESS-OVERFLOW.   
           MOVE SPACES                     TO RS-FR-CITY-STATE.         
           MOVE SPACES                     TO RS-FR-ZIP-CODE.           
           MOVE SPACES                     TO RS-FR-COUNTRY.            
           MOVE SPACES                     TO RS-ADDR-SUFFIX.           
           MOVE SPACES                     TO RS-CARRIER-ROUTE.         
P00547     MOVE SPACES                     TO RS-INTRNTNL-CITY.         
P00547     MOVE SPACES                     TO RS-INTRNTNL-PROVINCE.     
P00547     MOVE SPACES                     TO RS-INTRNTNL-POST-CODE.    
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-PROCESS-BILL-HDR                                          *        
      *                                                                *        
      *     CALLED FROM 2600-SEND-ADDR-FORM                            *        
      *                 2620-SEND-ADDR-FREE                            *        
      *                 2640-SEND-ADDR-NONE                            *        
      *                                                                *        
      *     PROCESSES THE BILL HEADER NAME FIELDS FOR BLANK VALUES.    *        
      *     THE WS-NAME-TYPE-IND IS USED TO CATEGORIZE:                *        
      *       VALUE OF 0: ATN - NO EXIST, NB - NO EXIST                *        
      *       VALUE OF 1: ATN -    EXIST, NB - NO EXIST                *        
      *       VALUE OF 2: ATN - NO EXIST, NB -    EXIST                *        
      *       VALUE OF 3: ATN -    EXIST, NB -    EXIST                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2700-PROCESS-BILL-HDR.                                           
                                                                        
           MOVE '2700'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           IF WS-NAME-TYPE-IND = 0 OR WS-NAME-TYPE-IND = 1              
              MOVE ZERO                         TO WS-NB-NAME-ID        
              MOVE SPACES                       TO WS-NB-NAME-FORMAT    
              MOVE SPACES                       TO WS-NB-NAME-TYPE      
              MOVE SPACES                       TO WS-NB-FIRST-NAME     
              MOVE SPACES                       TO WS-NB-MIDDLE-NAME    
              MOVE SPACES                       TO WS-NB-LAST-NAME      
              MOVE SPACES                       TO WS-NB-TITLE-PREFIX   
              MOVE SPACES                       TO WS-NB-TITLE-SUFFIX-1 
              MOVE SPACES                       TO WS-NB-TITLE-SUFFIX-2 
              MOVE SPACES                       TO WS-NB-FULL-NAME      
           END-IF.                                                      
                                                                        
           IF WS-NAME-TYPE-IND = 0 OR WS-NAME-TYPE-IND = 2              
              MOVE ZERO                         TO WS-AT-NAME-ID        
              MOVE SPACES                       TO WS-AT-NAME-FORMAT    
              MOVE SPACES                       TO WS-AT-NAME-TYPE      
              MOVE SPACES                       TO WS-AT-FIRST-NAME     
              MOVE SPACES                       TO WS-AT-MIDDLE-NAME    
              MOVE SPACES                       TO WS-AT-LAST-NAME      
              MOVE SPACES                       TO WS-AT-TITLE-PREFIX   
              MOVE SPACES                       TO WS-AT-TITLE-SUFFIX-1 
              MOVE SPACES                       TO WS-AT-TITLE-SUFFIX-2 
              MOVE SPACES                       TO WS-AT-FULL-NAME      
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ADDR-FRMT                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE ADDRESS FORMAT INTO WORKING STORAGE.          *        
      ******************************************************************        
                                                                        
       7000-SELECT-ADDR-FRMT.                                           
                                                                        
           MOVE '7000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  ADDRESS_FORMAT,                                   
                      ADDRESS_ID                                        
              INTO    :AT-ADDRESS-FORMAT,                               
                      :AT-ADDRESS-ID                                    
              FROM    CSS_ACCOUNT                                       
              WHERE   ACCOUNT_NO                = :WS-ACCOUNT-NO-D      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCOUNT'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-OPEN-AB-CURSOR                                            *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE AB-CURSOR CURSOR.                                *        
      ******************************************************************        
                                                                        
       7020-OPEN-AB-CURSOR.                                             
                                                                        
           MOVE '7020'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              OPEN AB-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'OPEN'                       TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7025-SELECT-NAME-ID                                            *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM                                                *        
      *                                                                *        
      *     FETCH THE NAME ID AND ADDRESS ID INTO WORKING STORAGE.     *        
      ******************************************************************        
                                                                        
       7025-SELECT-NAME-ID.                                             
                                                                        
           MOVE '7025'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              FETCH AB-CURSOR                                           
               INTO :AB-NAME-ID,                                        
                    :AB-NAME-TYPE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'FETCH'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-CLOSE-AB-CURSOR                                           *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM                                                *        
      *                                                                *        
      *     CLOSES THE AB-NAME-ID CURSOR.                              *        
      ******************************************************************        
                                                                        
       7030-CLOSE-AB-CURSOR.                                            
                                                                        
           MOVE '7030'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              CLOSE AB-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'CLOSE'                      TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ACCT_BILL_NMES'         TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7100-SELECT-NAME                                               *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE ATTN LINE NAME: C/O OR ATN.                   *        
      ******************************************************************        
                                                                        
       7100-SELECT-NAME.                                                
                                                                        
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  NAME_FORMAT,                                      
                      FIRST_NAME,                                       
                      MIDDLE_NAME,                                      
                      LAST_NAME,                                        
                      TITLE_PREFIX,                                     
                      TITLE_SUFFIX_1,                                   
                      TITLE_SUFFIX_2,                                   
                      FULL_NAME                                         
              INTO    :DQ-NAME-FORMAT,                                  
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-TITLE-PREFIX,                                 
                      :DQ-TITLE-SUFFIX-1,                               
                      :DQ-TITLE-SUFFIX-2,                               
                      :DQ-FULL-NAME                                     
              FROM    CSS_NAME                                          
              WHERE   NAME_ID                   = :WS-NAME-ID           
              AND     NAME_TYPE                 = :WS-NAME-TYPE         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_NAME'                   TO TABLE-1              
              MOVE 'NAME_ID'                    TO TABLE-ELEMENT-1      
              MOVE 'NAME_TYPE'                  TO TABLE-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-3      
              MOVE WS-NAME-ID-S                 TO HOSTVAR-ELEMENT-1    
              MOVE WS-NAME-TYPE                 TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-SELECT-ADDR-FORM                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE FORMATTED ADDRESS DETAILS.                    *        
      ******************************************************************        
                                                                        
       7220-SELECT-ADDR-FORM.                                           
                                                                        
           MOVE '7220'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ADDRESS_OVERFLOW,                                 
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_SUFFIX,                                      
                      CARRIER_ROUTE                                     
              INTO    :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX,                                  
                      :DY-CARRIER-ROUTE                                 
              FROM    CSS_ADDR_FORMATTED                                
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
              AND     ADDR_USAGE_CD             = 'F'                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7240-SELECT-TOWN-ST                                            *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE TOWN AND STATE FOR A GIVEN ZIP CODE.          *        
      ******************************************************************        
                                                                        
       7240-SELECT-TOWN-ST.                                             
                                                                        
           MOVE '7240'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  TOWN,                                             
                      STATE                                             
              INTO    :A4-TOWN,                                         
                      :A4-STATE                                         
              FROM    CSS_ZIP_CODE                                      
              WHERE   ZIP_CODE                  = :WS-ZIP-CODE          
                AND   ZIP_CODE_TOKEN            = :WS-ZIP-CODE-TOKEN    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ZIP_CODE'               TO TABLE-1              
              MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-1      
              MOVE 'ZIP_CODE_TOKEN'             TO TABLE-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-3      
              MOVE WS-ZIP-CODE                  TO HOSTVAR-ELEMENT-1    
              MOVE WS-ZIP-CODE-TOKEN            TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-SELECT-ADDR-FREE                                          *        
      *                                                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-BUILD-RESULT                              *        
      *                                                                *        
      *     RETRIEVE THE FREEFORM ADDRESS DETAILS.                     *        
      ******************************************************************        
                                                                        
       7260-SELECT-ADDR-FREE.                                           
                                                                        
           MOVE '7260'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT  ADDR_STREET,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_CITY_STATE,                                  
                      ADDR_ZIP_CODE,                                    
                      ADDR_COUNTRY,                                     
P00547                INTRNTNL_CITY,                                    
P00547                INTRNTNL_PROVINCE,                                
P00547                INTRNTNL_POST_CODE                                
              INTO    :DZ-ADDR-STREET,                                  
                      :DZ-ADDRESS-OVERFLOW,                             
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY,                                 
P00547                :DZ-INTRNTNL-CITY,                                
P00547                :DZ-INTRNTNL-PROVINCE,                            
P00547                :DZ-INTRNTNL-POST-CODE                            
              FROM    CSS_ADDR_FREEFORM                                 
              WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T15613        MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-ADDRESS-ID-S              TO HOSTVAR-ELEMENT-1    
CBSI          MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
T18537        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
