       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR02047.                                      
COB303 DATE-WRITTEN.     MAY 18, 2005.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000600
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000700
      *                                                                *00000800
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00000900
      *                                                                *00001000
      *  TRANID:        S047                                           *00001100
      *  PROGRAM:       S047                                           *00001200
      *  CALLING SP:    PN_S047                                        *00001300
      *                                                                *00001400
      ******************************************************************00001500
      *                 P R O G R A M  S U M M A R Y                   *00001600
      *                                                                *00001700
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00001800
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00001900
      *                                                                *00002000
      *  THIS PROGRAM RETRIEVES THE CUSTOMER CREDIT SUMMARY DETAILS.   *00002100
      *  IF THE PARAMETER SUMMARY_TYPE IS SET TO C THEN IT RETRIEVES   *00002200
      *  CURRENT SUMMARY DETAILS BASED ON THE CUSTOMER'S CURRENT       *00002300
      *  ACCOUNTS.                                                     *00002400
      *  IF THE PARAMETER SUMMARY_TYPE IS SET TO A THEN IT RETRIEVES   *00002500
      *  ARCHIVED DETAILS BASED ON THE CUSTOMER'S ARCHIVED ACCOUNTS.   *00002600
      *                                                                *00002700
      ******************************************************************00002800
      *                                                                *00002900
      *                     PROGRAM MODIFICATION LOG                   *00003000
      *                                                                *00003100
      *    DATE    INITIALS   COMMENTS                                 *00003200
      *  --------  --------   ---------------------------------------  *00003300
      *  03/09/95    GC       CREATED.                                 *00003400
      *  07/07/95    GC       MODIFIED 7140 - MOVE SPACES TO DATES IF  *00003500
      *                       CSS_CUST_PREM_HIST NOT FOUND. IT COULD   *00003600
      *                       BE A NON-UTIL CUSTOMER.                  *00003700
      *  03/01/96    ALI      MODIFIED(TPR # 3325) GET SECURITY AMOUNT *00003800
      *                       ONLY FOR ACTIVE - DEPOSIT ON HAND,       *00003900
      *                       GUARANTOR, SECURITY, AND LOC *            00004000
TP9038*  02/06/97    PD       CHECK FOR SPACES AND LOW VALUES IN THE   *00004100
TP9038*                       ARREAR CREDIT HISTORY ALONG WITH 0S.     *00004200
TP9038*                       FORMATTED THE ADDRESS PROPERLY.          *00004300
TP9123*  02/06/97    PD       IF THE ACCT IS WRITTEN OFF SEND BACK     *00004400
TP9123*                       WRITE OFF AMT INSTEAD OF BILLED BAL.     *00004500
PCR482*  03/05/97    MAD      MODIFIED PARAGRAPH 7600 TO RETURN ONLY   *00004600
      *                       'BILLING' AND 'PAID' DEPOSITS.           *00004700
T10543*  04/22/97    AS       PROGRAM RESTORED TO PRIOR TO TPR10239.   *00004800
T13669*  11/24/97    GAC      ADDED CPD00068 TO CALC WRITE-OFF BALANCE *00004900
T13669*                       INSTEAD OF USING FINAL WRITE OFF TABLE.  *00005000
T15719*  04/06/98    EMS      CHANGED WS-AMT-PAST-DUE WITH             *00005100
      *                       WS-WO-BALANCE.                           *00005200
T16083*  04/26/98    CBSI     INCOMPLETE INFO IN MC05 ERROR LOG IS     *00005300
T16083*                       CORRECTED.                               *00005400
T16853*  06/23/98    EMS      ADDED TBARHDT DCLGEN                     *00005500
CBSI  *  08/04/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00005600
CBSI  *             MADRAS    ABEND PARAMETERS                         *00005700
T17071*  11/19/98   MDJ       ADDED INCLUDE TBCSTALT FOR CUST_ALERT FOR*00005800
      *                       CPD00068.                                *00005900
T19557*  01/28/00    CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *00006000
T19557*              MADRAS   SCSCO068.                                *00006100
T22359*  06/21/00    MDJ      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *00006200
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *00006300
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *00006400
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *00006500
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *00006600
      *                       ALWAYS SCSCO068 OR SCSCB068.             *00006700
T24684*  08/10/01  SS19371    ADDED 'DISTINCT' TO SELECT STATEMENT TO  *00006800
      *                       ALLOW FOR EXISTENCE OF MORE THAN ONE ROW *00006900
C28788*  07/3/03   MDJ        GET IVR-EXEMPT-CD FOR CPD00068.          *00007000
C28788*  03/06/04  MJG        GET REG DE-REG FLAG FOR SEB.             *00007100
REARCH*  05/18/05  CVNS       RPC TO COBOL SP CONVERSION.              *00007200
REARCH*            CHENNAI                                             *00007300
32212 *  07/11/05  CVNS       CML 32212 CHANGES.                       *00007400
32212 *            CHENNAI                                             *00007500
C33438*  01/09/06  KR19687    MADE A CHANGE TO DISPLAY THE CORRECT     *00007600
C33438*                       AMOUNT UNDER TOTAL SECURITES ON PANEL    *00007700
C33438*                       PANEL 60.                                *00007800
C33994*  06/19/06  COVANSYS   PERFORMANCE TUNING                       *00007900
T34097*  07/07/06  COVANSYS   SET THE SWITCH 'CALC-PAST-DUE-SW'.       *00008000
??????*  09/13/06  MH94819    INCORPORATE ON COMMIT DROP FOR PERFRMANCE*00008100
T35434*  06/25/07  VIJAY      ADD WITH UR TO AVOID CONTENTION.          00008200
C37510*  09/11/08  CVNS       NAME AND ADDRESS FORMAT CHANGES          *00008210
C37510*            CHENNAI                                             *00008220
C30169*  10/24/08  CVNS       DELETE THE CODE THAT HAVE REFERENCE      *00008210
C30169*            CHENNAI    TO CSS_FINAL_WO FIELD WHICH ARE          *00008220
C30169*                       DELETED FROM THE DB2.                    *00008220
P00172*  06/10/09  CVNS       DHR INFORMATION HAS BEEN MOVED TO THE    *        
P00172*            CHENNAI    CUSTOMER LEVEL AND TABLE CSS_DHR_HIST    *        
P00172*                       GOT DELETED.A NEW COLUMN IN CSS_CUSTOMER *        
P00172*                       NAMED DHR_FL IS USED TO INDICATE THE     *        
P00172*                       PRESENCE OF DHR INFORMATION ON AN ACCOUNT*        
A37342*  07/17/09  CVNS       IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*            CHENNAI    POSITIONING FOR GLOBAL TEMP TABLES.      *        
A37304*  07/17/09  CVNS       ALL REFERENCE TO THE CSS_ARCHIVED_ACCT   *        
A37304*            CHENNAI    TABLE HAS BEEN COMMENTED OUT.            *        
A37666*  10/01/09  VP94820    CHANGES MADE TO FETCH ARCHIVED ACCOUNTS. *        
A02036*  03/31/10  DB41297    FIX PRODUCTION ABEND WHEN ACCOUNT = 0    *        
A02036*  05/12/10  VP94820    CHANGES MADE TO NOT TO SHOW CROSS COMPANY*        
A02036*                       ACCOUNTS ON EITHER THE DATAWINDOWS.      *        
      ******************************************************************00008300
      ******************************************************************00008400
      *                                                                *00008500
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00008600
      *                                                                *00008700
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00008800
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00008900
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00009000
      *  3000 - 4999  NOT USED                                         *00009100
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00009200
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00009300
      *  7000 - 7999  INPUT MODULES                                    *00009400
      *  8000 - 8999  OUTPUT MODULES                                   *00009500
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00009600
      *                                                                *00009700
      ******************************************************************00009800
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02047'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02047 STARTS HERE'.                  
                                                                        
      ******************************************************************00010700
      *    DB2 INCLUDES                                                *00010800
      ******************************************************************00010900
                                                                        
           EXEC SQL                                                     00011100
              INCLUDE SQLCA                                             00011200
           END-EXEC.                                                    00011300
                                                                        
C28788     EXEC SQL                                                     00012400
C28788        INCLUDE TBUTLENV                                          00012500
C28788     END-EXEC.                                                    00012600
      *                                                                 00012700
      *-------< CSS_CREDIT_PROFILE >                                    00012800
           EXEC SQL                                                     00012900
              INCLUDE  TBCRPROF                                         00013000
           END-EXEC.                                                    00013100
                                                                        
      *-------< CSS_CUST_PREM_HIST >                                    00013300
           EXEC SQL                                                     00013400
              INCLUDE  TBCSTPRM                                         00013500
           END-EXEC.                                                    00013600
                                                                        
      *-------< CSS_ACCOUNT >                                           00013800
           EXEC SQL                                                     00013900
              INCLUDE  TBACCT                                           00014000
           END-EXEC.                                                    00014100
                                                                        
      *-------------< CSS_NSF_HIST >                                    00014300
           EXEC SQL                                                     00014400
              INCLUDE TBNSFHST                                          00014500
           END-EXEC.                                                    00014600
                                                                        
      *-------------< CSS_GUARANTOR >                                   00014800
           EXEC SQL                                                     00014900
              INCLUDE TBGTNTR                                           00015000
           END-EXEC.                                                    00015100
                                                                        
      *-------------< CSS_SURETY_BOND >                                 00015300
           EXEC SQL                                                     00015400
              INCLUDE TBSTYBND                                          00015500
           END-EXEC.                                                    00015600
                                                                        
      *-------------< CSS_DEP_ON_HAND >                                 00015800
           EXEC SQL                                                     00015900
              INCLUDE TBDEPHND                                          00016000
           END-EXEC.                                                    00016100
                                                                        
      *-------------< CSS_ZIP_CODE >                                    00016300
           EXEC SQL                                                     00016400
              INCLUDE TBZIPCD                                           00016500
           END-EXEC.                                                    00016600
                                                                        
      *-------------< CSS_ADDR_FORMATTED >                              00016800
           EXEC SQL                                                     00016900
              INCLUDE TBADRFMT                                          00017000
           END-EXEC.                                                    00017100
                                                                        
      *-------------< CSS_NAME_ACCT_XREF >                              00017300
           EXEC SQL                                                     00017400
              INCLUDE TBNMACTX                                          00017500
           END-EXEC.                                                    00017600
C29631                                                                  
C29631******************************************************************03010001
C29631*    LR - CSS_DELINQUECY                                         *03010002
C29631******************************************************************03010003
C29631                                                                  
C29631     EXEC SQL                                                     03010005
C29631        INCLUDE TBDELQ                                            03010006
C29631     END-EXEC.                                                    03010007
C29631                                                                  
C29631******************************************************************03010009
C29631*    LR - CSS_REG_PROFILE                                        *03010010
C29631******************************************************************03010011
C29631     EXEC SQL                                                     03010012
C29631        INCLUDE TBREGPRF                                          03010013
C29631     END-EXEC.                                                    03010014
C29631                                                                  
C29631******************************************************************03010016
P00172*    CU - CSS_CUSTOMER                                           *03010017
P00172******************************************************************03010018
P00172     EXEC SQL                                                     03010019
P00172        INCLUDE TBCUST                                            03010020
P00172     END-EXEC.                                                    03010021
A37666*                                                                         
A37666******************************************************************03010016
A37666*    HA - HST_ACCOUNT                                            *03010017
A37666******************************************************************03010018
A37666*                                                                         
A37666     EXEC SQL                                                     00012000
A37666        INCLUDE  TBHACCT                                          00012100
A37666     END-EXEC.                                                    00012200
A37666*                                                                         
A37666******************************************************************03010016
A37666*    IA - HST_DEP_ON_HAND                                        *03010017
A37666******************************************************************03010018
A37666*                                                                         
A37666     EXEC SQL                                                     00012000
A37666        INCLUDE  TBHDEPHN                                         00012100
A37666     END-EXEC.                                                    00012200
A37666*                                                                         
A37666******************************************************************03010016
A37666*    HU - HST_REFUND                                             *03010017
A37666******************************************************************03010018
A37666*                                                                         
A37666     EXEC SQL                                                     00012000
A37666        INCLUDE  TBHREFUN                                         00012100
A37666     END-EXEC.                                                    00012200
A37666*                                                                         
C29631                                                                  
T13669*--------< SUPPORTS CALC OF WRITE OFF BALANCE >                   03010023
T13669     EXEC SQL                                                     03010024
T13669        INCLUDE CWS00068                                          03010025
T13669     END-EXEC.                                                    03010026
                                                                        
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                03010028
           EXEC SQL                                                     03010029
              INCLUDE CWS00056                                          03010030
           END-EXEC.                                                    03010040
                                                                        
      ******************************************************************03010060
      *    COBOL WORKING STORAGE COPY BOOKS                            *03010070
      ******************************************************************03010080
      *--------<COMMON SYSTEM AREA >                                    03010600
           COPY CCA00001.                                               03010700
      *--------< ERROR HANDLING >                                       03010800
REARCH     EXEC SQL                                                     03011000
REARCH        INCLUDE CWSX0010                                          03011100
REARCH     END-EXEC.                                                    03011200
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       03011300
           COPY CWS00027.                                               03011400
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  03011500
           COPY CWS00303.                                               03011600
T19557*--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >               03011601
T19557     COPY CWS0068L.                                               03011602
                                                                        
      ******************************************************************03011604
      *    WORK AREAS                                                  *03011605
      ******************************************************************03011606
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02047_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH      05 WS-EIBRESP               PIC S9(8)                       
                                        COMP SYNC VALUE ZERO.           
            05  MCSCB068                PIC X(8)  VALUE 'MCSCB068'.     
            05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02047'.     
            05  WS-SQLSTATE             PIC X(05).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-NULL-IND             PIC S9(04) COMP.                 
A37666     05  WS-DATE-REF-NI          PIC S9(04) COMP.                 
A37666     05  WS-ON-DATE-NI           PIC S9(04) COMP.                 
A37666     05  WS-OFF-DATE-NI          PIC S9(04) COMP.                 
A37666     05  WS-DATE-LAST-PYMT-NI    PIC S9(04) COMP.                 
A37666     05  WS-DATE-ARCHIVED-NI     PIC S9(04) COMP.                 
A37666     05  WS-GROUP-EFF-TS-NI      PIC S9(04) COMP.                 
A37666     05  WS-DEP-ROW-EXISTS       PIC X(01) VALUE 'N'.             
A37666     05  WS-REF-ROW-EXISTS       PIC X(01) VALUE 'N'.             
T13669     05  WS-00-NULL-IND          PIC S9(04) COMP.                 
T13669     05  WS-30-NULL-IND          PIC S9(04) COMP.                 
T13669     05  WS-60-NULL-IND          PIC S9(04) COMP.                 
T13669     05  WS-90-NULL-IND          PIC S9(04) COMP.                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
COB305     05 RS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.            
           05  RS-ACCOUNT-STATUS         PIC X(1)    VALUE SPACE.       
           05  RS-STATUS-REASON          PIC X(1)    VALUE SPACE.       
C37510     05  RS-SERVICE-ADDRESS        PIC X(75)   VALUE SPACE.       
           05  RS-CREDIT-GROUP           PIC X(1)    VALUE SPACE.       
           05  RS-CREDIT-STATUS          PIC X(1)    VALUE SPACE.       
           05  RS-TWELVE-MONTH-ARREARS   PIC S9(04)  COMP VALUE 0.      
           05  RS-TWELVE-MONTH-DNP       PIC S9(04)  COMP VALUE 0.      
           05  RS-TWELVE-MONTH-RET-CHK   PIC S9(04)  COMP VALUE 0.      
           05  RS-SECURITIES-TOTAL       PIC X(14)   VALUE SPACE.       
           05  RS-DATE-LAST-PYMNT        PIC X(10)   VALUE SPACE.       
           05  RS-TOTAL-BILLED-BAL       PIC S9(11)V9(2) COMP-3         
SJ9714                                               VALUE +0.          
           05  RS-CASH-ONLY-FL           PIC X(1)    VALUE SPACE.       
           05  RS-DPP-IND                PIC X(1)    VALUE SPACE.       
           05  RS-EPP-IND                PIC X(1)    VALUE SPACE.       
           05  RS-MED-CERT-IND           PIC X(1)    VALUE SPACE.       
           05  RS-BILL-CYCLE-CHG-IND     PIC X(1)    VALUE SPACE.       
           05  RS-BANK-DRAFT-IND         PIC X(1)    VALUE SPACE.       
           05  RS-ON-DATE                PIC X(10)   VALUE SPACE.       
           05  RS-OFF-DATE               PIC X(10)   VALUE SPACE.       
           05  RS-FINAL-STATUS           PIC X(1)    VALUE SPACE.       
           05  RS-CITY-STATE             PIC X(29)   VALUE SPACE.       
           05  RS-ZIP-CODE               PIC X(9)    VALUE SPACE.       
           05  RS-AMOUNT-LAST-PYMNT      PIC S9(9)V9(2) COMP-3          
SJ9714                                                VALUE +0.         
A37666     05  RS-ACCOUNT-BALANCE        PIC S9(7)V9(2) COMP-3          
A37666                                               VALUE +0.          
           05  RS-DATE-ARCHIVED          PIC X(10)   VALUE SPACE.       
           05  RS-ARCHIVES-EXIST         PIC X(1)    VALUE 'N'.         
C29631     05  RS-GROUP-CD               PIC X(09) VALUE SPACES.        
A37666     05  RS-DEP-STATUS             PIC X(01) VALUE SPACES.        
A37666     05  RS-REF-STATUS             PIC X(01) VALUE SPACES.        
A37666     05  RS-REG-GROUP-CD           PIC X(03) VALUE SPACES.        
A37666     05  RS-GROUP-EFF-TS           PIC X(10) VALUE SPACES.        
A37666     05  RS-SENIOR-FL              PIC X(01) VALUE SPACES.        
A37666     05  RS-DIST-ACCT-NO           PIC X(20) VALUE SPACES.        
A37666     05  RS-ORIGINATION-CD         PIC X(01) VALUE SPACES.        
A37666     05  RS-OLD-ACCOUNT-NO         PIC X(13) VALUE SPACES.        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09)  COMP VALUE 0.       
COB305     05 S-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.             
REARCH     05  S-ACCOUNT-STATUS         PIC X(1)    VALUE SPACE.        
REARCH     05  S-STATUS-REASON          PIC X(1)    VALUE SPACE.        
C37510     05  S-SERVICE-ADDRESS        PIC X(75)   VALUE SPACE.        
REARCH     05  S-CREDIT-GROUP           PIC X(1)    VALUE SPACE.        
REARCH     05  S-CREDIT-STATUS          PIC X(1)    VALUE SPACE.        
REARCH     05  S-TWELVE-MONTH-ARREARS   PIC S9(04)  COMP VALUE 0.       
REARCH     05  S-TWELVE-MONTH-DNP       PIC S9(04)  COMP VALUE 0.       
REARCH     05  S-TWELVE-MONTH-RET-CHK   PIC S9(04)  COMP VALUE 0.       
REARCH     05  S-SECURITIES-TOTAL       PIC X(14)   VALUE SPACE.        
REARCH     05  S-DATE-LAST-PYMNT        PIC X(10)   VALUE SPACE.        
COB305     05 S-TOTAL-BILLED-BAL        PIC S9(11)V9(2) COMP-3 VALUE 0.         
REARCH     05  S-CASH-ONLY-FL           PIC X(1)    VALUE SPACE.        
REARCH     05  S-DPP-IND                PIC X(1)    VALUE SPACE.        
REARCH     05  S-EPP-IND                PIC X(1)    VALUE SPACE.        
REARCH     05  S-MED-CERT-IND           PIC X(1)    VALUE SPACE.        
REARCH     05  S-BILL-CYCLE-CHG-IND     PIC X(1)    VALUE SPACE.        
REARCH     05  S-BANK-DRAFT-IND         PIC X(1)    VALUE SPACE.        
REARCH     05  S-ON-DATE                PIC X(10)   VALUE SPACE.        
REARCH     05  S-OFF-DATE               PIC X(10)   VALUE SPACE.        
REARCH     05  S-FINAL-STATUS           PIC X(1)    VALUE SPACE.        
REARCH     05  S-CITY-STATE             PIC X(29)   VALUE SPACE.        
REARCH     05  S-ZIP-CODE               PIC X(9)    VALUE SPACE.        
COB305     05 S-AMOUNT-LAST-PYMNT        PIC S9(9)V9(2) COMP-3 VALUE 0.         
COB305     05 S-ACCOUNT-BALANCE        PIC S9(7)V9(2) COMP-3 VALUE 0.          
REARCH     05  S-DATE-ARCHIVED          PIC X(10)   VALUE SPACE.        
REARCH     05  S-ARCHIVES-EXIST         PIC X(1)    VALUE 'N'.          
REARCH     05  S-GROUP-CD               PIC X(09) VALUE SPACES.         
A37666     05  S-DEP-STATUS             PIC X(01) VALUE 'N'.            
A37666     05  S-REF-STATUS             PIC X(01) VALUE 'N'.            
A37666     05  S-REG-GROUP-CD           PIC X(03) VALUE SPACES.         
A37666     05  S-GROUP-EFF-TS           PIC X(10) VALUE SPACES.         
A37666     05  S-SENIOR-FL              PIC X(01) VALUE SPACES.         
A37666     05  S-DIST-ACCT-NO           PIC X(20) VALUE SPACES.         
A37666     05  S-ORIGINATION-CD         PIC X(01) VALUE SPACES.         
A37666     05  S-OLD-ACCOUNT-NO         PIC X(13) VALUE SPACES.         
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-CUSTOMER-NUM         PIC X(10).                       
           05  WS-CUSTOMER-DEC REDEFINES WS-CUSTOMER-NUM                
                                       PIC 9(10).                       
32212      05  WS-GROUP-CODE           PIC X(03) VALUE SPACES.          
32212      05  WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
32212      05  WS-ACCOUNT-DEC  REDEFINES WS-ACCOUNT-NO                  
32212                                  PIC 9(13).                       
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-DISCONNECT-HIST      PIC X(24).                       
           05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISCONNECT-HIST         
                                       PIC X(1) OCCURS 24.              
           05  WS-DISC-EXCEPTN-HIST    PIC X(24).                       
           05  WS-EXCEPTIONAL-HIST-BRKDWN  REDEFINES                    
               WS-DISC-EXCEPTN-HIST    PIC X(1) OCCURS 24.              
           05  WS-ARREARS-HIST         PIC X(24).                       
           05  WS-ARREARS-HIST-BRKDWN  REDEFINES                        
               WS-ARREARS-HIST         PIC X(1) OCCURS 24.              
           05  WS-ONE-YEAR-AGO         PIC X(10) VALUE SPACES.          
           05  WS-DATE-HOLD            PIC X(10) VALUE SPACES.          
           05  WS-DATE-HOLD-USA        PIC X(10) VALUE SPACES.          
           05  WS-PREV-MNTH            PIC S9(4) COMP VALUE 0.          
           05  WS-SVC-STRT-NULL-IND    PIC S9(4) COMP VALUE 0.          
           05  WS-SVC-END-NULL-IND     PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-BILLED-NULL-IND PIC S9(4) COMP VALUE 0.          
           05  WS-GUARANTEED-NULL-IND  PIC S9(4) COMP VALUE 0.          
           05  WS-BOND-NULL-IND        PIC S9(4) COMP VALUE 0.          
           05  WS-DEPOSIT-NULL-IND     PIC S9(4) COMP VALUE 0.          
           05  WS-SECURITIES-TOTAL-CMP PIC S9(11)V99 COMP-3 VALUE +0.   
           05  WS-SECURITIES-TOTAL     PIC  9(11)V99 VALUE ZERO.        
           05  WS-SECURITIES-TOTAL-TXT REDEFINES WS-SECURITIES-TOTAL.   
               10  WS-SEC-TOT-1        PIC X(11).                       
               10  WS-SEC-TOT-2        PIC X(2).                        
           05  WS-SEC-TOT-RETURN-TXT.                                   
               10  WS-SEC-TOT-RET-1    PIC X(11).                       
               10  WS-SEC-TOT-POINT    PIC X(1) VALUE '.'.              
               10  WS-SEC-TOT-RET-2    PIC X(2).                        
           05  WS-AMT-GUARANTEED       PIC S9(11)V99 COMP-3 VALUE +0.   
           05  WS-AMT-BOND             PIC S9(11)V99 COMP-3 VALUE +0.   
           05  WS-AMT-DEPOSIT          PIC S9(11)V99 COMP-3 VALUE +0.   
           05  WS-SURETY-BOND-TYPE     PIC X(1)  VALUE SPACES.          
           05  WS-WAIVER-EXISTS        PIC X(1)  VALUE 'N'.             
           05  WS-CITY-STATE.                                           
               10  WS-CITY             PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X     VALUE SPACES.          
               10  WS-STATE            PIC X(2)  VALUE SPACES.          
           05  WS-ACCT-ZIP-CODE.                                        
               10  WS-ACCT-ZIP-CODE-5  PIC X(5)  VALUE SPACES.          
               10  WS-ACCT-ZIP-CODE-4  PIC X(4)  VALUE SPACES.          
           05  WS-ACCT-RETURN-CODE     PIC S9(9) COMP VALUE 0.          
TP9038     05  WS-LENGTH               PIC S9(4) COMP VALUE 0.          
TP9038     05  WS-COUNTER              PIC S9(4) COMP VALUE 0.          
TP9038     05  WS-STRING-ARRAY         PIC X(50) VALUE SPACES.          
TP9038     05  WS-ARRAY                REDEFINES WS-STRING-ARRAY        
TP9038                                 PIC X(01) OCCURS 50.             
T19557     05 WS-EIBRESP               PIC S9(8)                        
T19557                                 COMP SYNC VALUE ZERO.            
C29631     05  WS-TODAYS-DATE          PIC X(10).                       
C29631     05  WS-ACTIVE-DHR           PIC X(01) VALUE ' '.             
                                                                        
       01  WS-ADDRESS.                                                  
C37510     05  WS-STREET-NBR                PIC X(15) VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
           05  WS-PREFIX-1                  PIC X(3)  VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
           05  WS-PREFIX-2                  PIC X(2)  VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
C37510     05  WS-STREET-NAME               PIC X(30) VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
           05  WS-STREET-SUFFIX             PIC X(4)  VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
           05  WS-LOCATION-1                PIC X(4)  VALUE SPACE.      
           05  FILLER                       PIC X     VALUE SPACE.      
C37510     05  WS-LOCATION-2                PIC X(11) VALUE SPACE.      
                                                                        
       01  LITERALS.                                                    
           05  WS-SPACE                  PIC X(1) VALUE ' '.            
           05  WS-2-SPACE                PIC X(2) VALUE '  '.           
           05  WS-A                      PIC X(1) VALUE 'A'.            
           05  WS-C                      PIC X(1) VALUE 'C'.            
           05  WS-P                      PIC X(1) VALUE 'P'.            
           05  WS-FOUR                   PIC X(1) VALUE '4'.            
           05  WS-0-TEXT                 PIC X(1) VALUE '0'.            
           05  WS-WAIVER-TEXT            PIC X(14) VALUE                
                                         'WAIVER        '.              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************12232440
      *    CURSOR DECLARATIONS                                         *12232450
      ******************************************************************12232460
                                                                        
A37666*                                                                 12232490
A37666******************************************************************12232460
A37666*    CURSOR FOR ARCHIVED ACCOUNTS                                *12232480
A37666******************************************************************12232460
A37666*                                                                 12232490
A37666     EXEC SQL DECLARE ARCHIVE-CURSOR CURSOR FOR                   
A37666       SELECT HA.ACCOUNT_NO,                                      
A37666              HA.CUSTOMER_NO,                                     
A37666              HA.ACCT_CREATE_DT,                                  
A37666              HA.ACCT_FINALED_DT,                                 
A37666              HA.CREDIT_GROUP,                                    
A37666              HA.CODE_ACCT_STAT,                                  
A37666              HA.CODE_STATUS_REASON,                              
A37666              HA.LAST_PYMT_DATE,                                  
A37666              HA.LAST_PYMT_AMOUNT,                                
A37666              HA.ACCOUNT_BALANCE_AM,                              
A37666              HA.ARCHIVED_DT,                                     
A37666              HA.REG_GROUP_CD,                                    
A37666              REPLACE(REPLACE(CONVERT(CHAR(26), HA.GROUP_EFF_TS
           , 121), ' ', '-'), ':', '.') GROUP_EFF_TS,                          
A37666              HA.SENIOR_FL,                                       
A37666              HA.DIST_ACCT_NO,                                    
A37666              HA.ORIGINATION_CD,                                  
A37666              HA.OLD_ACCOUNT_NO                                   
A37666       FROM   HST_ACCOUNT HA WITH(READUNCOMMITTED)                        
A37666       WHERE  HA.CUSTOMER_NO      = :HA-CUSTOMER-NO               
A02036       AND    HA.COMPANY_NO       = :HA-COMPANY-NO                
A37666       FOR READ ONLY                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE ARCHIVE-CURSOR CURSOR FOR                   12232500
MFA-TR*      SELECT HA.ACCOUNT_NO,                                      12232600
MFA-TR*             HA.CUSTOMER_NO,                                     12232700
MFA-TR*             HA.ACCT_CREATE_DT,                                  12233000
MFA-TR*             HA.ACCT_FINALED_DT,                                 12233100
MFA-TR*             HA.CREDIT_GROUP,                                    12233200
MFA-TR*             HA.CODE_ACCT_STAT,                                  12233500
MFA-TR*             HA.CODE_STATUS_REASON,                              12233600
MFA-TR*             HA.LAST_PYMT_DATE,                                  12233900
MFA-TR*             HA.LAST_PYMT_AMOUNT,                                12234000
MFA-TR*             HA.ACCOUNT_BALANCE_AM,                              12234100
MFA-TR*             HA.ARCHIVED_DT,                                     12234200
MFA-TR*             HA.REG_GROUP_CD,                                            
MFA-TR*             HA.GROUP_EFF_TS,                                            
MFA-TR*             HA.SENIOR_FL,                                               
MFA-TR*             HA.DIST_ACCT_NO,                                            
MFA-TR*             HA.ORIGINATION_CD,                                          
MFA-TR*             HA.OLD_ACCOUNT_NO                                           
MFA-TR*      FROM   HST_ACCOUNT HA                                      12234300
MFA-TR*      WHERE  HA.CUSTOMER_NO      = :HA-CUSTOMER-NO               12234400
MFA-TR*      AND    HA.COMPANY_NO       = :HA-COMPANY-NO                        
MFA-TR*      FOR FETCH ONLY WITH UR                                     12234500
MFA-TR*    END-EXEC.                                                    12234600
A37666*                                                                 12234700
      *--- < CURSOR FOR ACCOUNTS >                                      12234800
                                                                        
           EXEC SQL DECLARE ACCOUNT-CURSOR CURSOR FOR                   
             SELECT AT.ACCOUNT_NO,                                      
                    AT.CODE_ACCT_STAT,                                  
                    AT.CODE_STATUS_REASON,                              
                    AT.ADDRESS_ID,                                      
                    AT.ADDRESS_FORMAT,                                  
                    AT.CREDIT_GROUP,                                    
                    AT.CREDIT_STATUS_CODE,                              
                    AT.LAST_PYMT_DATE,                                  
                    AT.TOTAL_AR_BALANCE,                                
                    AT.CODES_DATA_PRESENT,                              
                    AT.BILL_CYCLE_CHG_CD,                               
T13669              AT.NOTICE_EXEMPT_CD,                                
T13669              AT.CODE_DISC_OK,                                    
T13669              AT.DATE_BILL_DAY_00,                                
T13669              AT.DATE_BILL_DAY_30,                                
T13669              AT.DATE_BILL_DAY_60,                                
T13669              AT.DATE_BILL_DAY_90,                                
T13669              AT.BANKRUPTCY_IND,                                  
T13669              AT.COMPANY_NO,                                      
T13669              AT.LOCAL_OFFICE,                                    
C28788              AT.IVR_EXEMPT_CD                                    
             FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
             WHERE  AT.CUSTOMER_NO      = :AT-CUSTOMER-NO               
A02036       AND    AT.COMPANY_NO       = :AT-COMPANY-NO                
T35434       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE ACCOUNT-CURSOR CURSOR FOR                   12235000
MFA-TR*      SELECT AT.ACCOUNT_NO,                                      12235100
MFA-TR*             AT.CODE_ACCT_STAT,                                  12235200
MFA-TR*             AT.CODE_STATUS_REASON,                              12235300
MFA-TR*             AT.ADDRESS_ID,                                      12235400
MFA-TR*             AT.ADDRESS_FORMAT,                                  12235500
MFA-TR*             AT.CREDIT_GROUP,                                    12235600
MFA-TR*             AT.CREDIT_STATUS_CODE,                              12235700
MFA-TR*             AT.LAST_PYMT_DATE,                                  12235800
MFA-TR*             AT.TOTAL_AR_BALANCE,                                12235900
MFA-TR*             AT.CODES_DATA_PRESENT,                              12236000
MFA-TR*             AT.BILL_CYCLE_CHG_CD,                               12236100
MFA-TR*             AT.NOTICE_EXEMPT_CD,                                12236200
MFA-TR*             AT.CODE_DISC_OK,                                    12236300
MFA-TR*             AT.DATE_BILL_DAY_00,                                12236400
MFA-TR*             AT.DATE_BILL_DAY_30,                                12236500
MFA-TR*             AT.DATE_BILL_DAY_60,                                12236600
MFA-TR*             AT.DATE_BILL_DAY_90,                                12236700
MFA-TR*             AT.BANKRUPTCY_IND,                                  12236800
MFA-TR*             AT.COMPANY_NO,                                      12236900
MFA-TR*             AT.LOCAL_OFFICE,                                    12237000
MFA-TR*             AT.IVR_EXEMPT_CD                                    12237100
MFA-TR*      FROM   CSS_ACCOUNT AT                                      12237200
MFA-TR*      WHERE  AT.CUSTOMER_NO      = :AT-CUSTOMER-NO               12237300
MFA-TR*      AND    AT.COMPANY_NO       = :AT-COMPANY-NO                        
MFA-TR*      FOR FETCH ONLY WITH UR                                     12237500
MFA-TR*    END-EXEC.                                                    12237600
                                                                        
HPCCDM*EJECT                                                            12237800
      *                                                                         
REARCH LINKAGE SECTION.                                                 
32212  01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-SUMMARY-TYPE       PIC X(1).                            
      *                                                                         
32212  PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-SUMMARY-TYPE.                      
                                                                        
      ******************************************************************12238700
      * 0000-MAINLINE                                                  *12238800
      *     CALLS 0100-INITIALIZE                                      *12238900
      *           1000-PROCESS-INPUT                                   *12239000
      *           2000-PROCESS-OUTPUT                                  *12239100
      *           9999-END-PROGRAM                                     *12239200
      *                                                                *12239300
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *12239400
      ******************************************************************12239500
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT.                   
A02036     IF WS-ACCOUNT-DEC > 0                                        
A02036        PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                
A02036     END-IF.                                                      
                                                                        
T16083     IF CTR-ROWS < 1                                              
T16083        INITIALIZE TDS-RETURN-FIELDS                              
T16083        MOVE 100  TO RS-RETURN-CODE                               
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
T16083        PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
T16083     END-IF.                                                      
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12241300
      * 0100-INITIALIZE                                                *12241400
      *     CALLS 9000-SEND-ERROR-RESULT                               *12241500
      *           9900-SQL-ERROR-ROUTINE                               *12241600
      *                                                                *12241700
      *     CALLED FROM 0000-MAINLINE                                  *12241800
      *                                                                *12241900
      *     1. RESET DB2 ERROR HANDLERS                                *12242000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *12242100
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *12242200
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*12242300
      *                                                                *12242400
      ******************************************************************12242500
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH         EXEC SQL                                                 
A37342             DECLARE C1 CURSOR                         
A37342                               WITH ROWSET POSITIONING FOR        
REARCH             SELECT                                               
REARCH                *                                                 
REARCH             FROM                                                 
REARCH                 #CSR02047_R1                              
REARCH         END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                 12245200
MFA-TR*            DECLARE C1 CURSOR WITH RETURN                        12245300
MFA-TR*                              WITH ROWSET POSITIONING FOR                
MFA-TR*            SELECT                                               12245400
MFA-TR*               *                                                 12245500
MFA-TR*            FROM                                                 12245600
MFA-TR*                SESSION.CSR02047_R1                              12245700
MFA-TR*        END-EXEC.                                                12245800
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************12246200
REARCH*0100A-DECLARE-GTT.                                               12246300
REARCH******************************************************************12246400
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                 12246600
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02047_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      IF PARM-SUMMARY-TYPE = WS-C                                 
REARCH        EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR02047_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR02047_R1
                 (                                                       
REARCH              RETURN_CODE              INT                    
REARCH             ,ACCOUNT_NO               DECIMAL(13,0)              
REARCH             ,ACCOUNT_STATUS CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,STATUS_REASON CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
C37510             ,SERVICE_ADDRESS CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,CITY_STATE CHAR(29)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,CREDIT_GROUP CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,CREDIT_STATUS CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,TWELVE_MNTH_ARRERS       SMALLINT                   
REARCH             ,TWELVE_MONTH_DNP         SMALLINT                   
REARCH             ,TWELVE_MNTH_RET_CK       SMALLINT                   
REARCH             ,SECURITIES_TOTAL CHAR(14)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,DATE_LAST_PYMNT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,TOTAL_BILLED_BAL         DECIMAL(13,2)              
REARCH             ,CASH_ONLY_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,DPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,EPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,MED_CERT_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,BILL_CYCLE_CHG_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,BANK_DRAFT_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,ON_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,OFF_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,ARCHIVES_EXIST CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,GROUP_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
MH9481          )
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
REARCH     ELSE                                                         
REARCH        EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR02047_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR02047_R1
                 (                                                       
REARCH              RETURN_CODE              INT                    
REARCH             ,ACCOUNT_NO               DECIMAL(13,0)              
A37666             ,SERVICE_ADDRESS CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
A37666             ,CITY_STATE CHAR(29)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,ON_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,OFF_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,FINAL_STATUS CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,STATUS_REASON CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,CREDIT_GROUP CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
REARCH             ,AMOUNT_LAST_PYMNT        DECIMAL(11,2)              
REARCH             ,DATE_LAST_PYMNT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,ACCOUNT_BALANCE          DECIMAL(9,2)               
REARCH             ,DATE_ARCHIVED CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,DEP_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
A37666             ,REF_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
A37666             ,REG_GROUP_CD CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,GROUP_EFF_TS CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,SENIOR_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
A37666             ,DIST_ACCT_NO CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,ORIGINATION_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
A37666             ,OLD_ACCOUNT_NO CHAR(13)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
MH9481          )
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
REARCH     END-IF.                                                      
REARCH*                                                                 12252500
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 12252800
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02047_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH     END-IF.                                                      
REARCH*                                                                 12255000
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 12255000
      ******************************************************************12255300
      * 1000-PROCESS-INPUT                                             *12255400
      *     CALLS 1100-RECEIVE-PARMS                                   *12255500
      *                                                                *12255600
      *     CALLED FROM 0000-MAINLINE                                  *12255700
      *                                                                *12255800
      *     1. RECEIVE PARMS.                                          *12255900
      ******************************************************************12256000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
32212      MOVE PARM-ACCOUNT-NO   TO WS-ACCOUNT-NO.                     
A37666     MOVE WS-ACCOUNT-DEC    TO HA-ACCOUNT-NO                      
A37666                               AT-ACCOUNT-NO.                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12261600
      * 2000-PROCESS-OUTPUT.                                           *12261700
      *     CALLS 2100-DESCRIBE-CUST-RESULT                            *12261800
      *           2150-DESCRIBE-ARCH-RESULT                            *12261900
      *           2200-BUILD-CUST-RESULT                               *12262000
      *           2250-BUILD-ARCH-RESULT                               *12262100
      *                                                                *12262200
      *      CALLED FROM 0000-MAINLINE                                 *12262300
      *                                                                *12262400
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *12262500
      *      AND SENDS THEM BACK                                       *12262600
      ******************************************************************12262700
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
C29631                                                                  
C29631     EXEC SQL                                                     
C33994        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                    
C29631     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     12263300
MFA-TR*       SET    :WS-TODAYS-DATE  = CURRENT DATE                    12263500
MFA-TR*    END-EXEC.                                                    12263800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF PARM-SUMMARY-TYPE = WS-C                                  
              PERFORM 2200-BUILD-CUST-RESULT     THRU 2200-EXIT         
A37666     ELSE                                                         
A37666        PERFORM 2250-BUILD-ARCH-RESULT     THRU 2250-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************12265200
REARCH*2000A-MOVE-RESULT.                                               12265300
REARCH******************************************************************12265400
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                 12265600
REARCH     IF PARM-SUMMARY-TYPE = WS-C                                  
REARCH         MOVE RS-RETURN-CODE          TO S-RETURN-CODE            
REARCH         MOVE RS-ACCOUNT-NO           TO S-ACCOUNT-NO             
REARCH         MOVE RS-ACCOUNT-STATUS       TO S-ACCOUNT-STATUS         
REARCH         MOVE RS-STATUS-REASON        TO S-STATUS-REASON          
REARCH         MOVE RS-SERVICE-ADDRESS      TO S-SERVICE-ADDRESS        
REARCH         MOVE RS-CITY-STATE           TO S-CITY-STATE             
REARCH         MOVE RS-ZIP-CODE             TO S-ZIP-CODE               
REARCH         MOVE RS-CREDIT-GROUP         TO S-CREDIT-GROUP           
REARCH         MOVE RS-CREDIT-STATUS        TO S-CREDIT-STATUS          
REARCH         MOVE RS-TWELVE-MONTH-ARREARS TO S-TWELVE-MONTH-ARREARS   
REARCH         MOVE RS-TWELVE-MONTH-DNP     TO S-TWELVE-MONTH-DNP       
REARCH         MOVE RS-TWELVE-MONTH-RET-CHK TO S-TWELVE-MONTH-RET-CHK   
REARCH         MOVE RS-SECURITIES-TOTAL     TO S-SECURITIES-TOTAL       
REARCH         MOVE RS-DATE-LAST-PYMNT      TO S-DATE-LAST-PYMNT        
REARCH         MOVE RS-TOTAL-BILLED-BAL     TO S-TOTAL-BILLED-BAL       
REARCH         MOVE RS-CASH-ONLY-FL         TO S-CASH-ONLY-FL           
REARCH         MOVE RS-DPP-IND              TO S-DPP-IND                
REARCH         MOVE RS-EPP-IND              TO S-EPP-IND                
REARCH         MOVE RS-MED-CERT-IND         TO S-MED-CERT-IND           
REARCH         MOVE RS-BILL-CYCLE-CHG-IND   TO S-BILL-CYCLE-CHG-IND     
REARCH         MOVE RS-BANK-DRAFT-IND       TO S-BANK-DRAFT-IND         
REARCH         MOVE RS-ON-DATE              TO S-ON-DATE                
REARCH         MOVE RS-OFF-DATE             TO S-OFF-DATE               
REARCH         MOVE RS-ARCHIVES-EXIST       TO S-ARCHIVES-EXIST         
REARCH         MOVE RS-GROUP-CD             TO S-GROUP-CD               
A37666     ELSE                                                         
A37666         MOVE RS-RETURN-CODE          TO S-RETURN-CODE            
A37666         MOVE RS-ACCOUNT-NO           TO S-ACCOUNT-NO             
A37666         MOVE RS-SERVICE-ADDRESS      TO S-SERVICE-ADDRESS        
A37666         MOVE RS-ZIP-CODE             TO S-ZIP-CODE               
A37666         MOVE RS-CITY-STATE           TO S-CITY-STATE             
A37666         MOVE RS-ON-DATE              TO S-ON-DATE                
A37666         MOVE RS-OFF-DATE             TO S-OFF-DATE               
A37666         MOVE RS-FINAL-STATUS         TO S-FINAL-STATUS           
A37666         MOVE RS-STATUS-REASON        TO S-STATUS-REASON          
A37666         MOVE RS-CREDIT-GROUP         TO S-CREDIT-GROUP           
A37666         MOVE RS-AMOUNT-LAST-PYMNT    TO S-AMOUNT-LAST-PYMNT      
A37666         MOVE RS-DATE-LAST-PYMNT      TO S-DATE-LAST-PYMNT        
A37666         MOVE RS-ACCOUNT-BALANCE      TO S-ACCOUNT-BALANCE        
A37666         MOVE RS-DATE-ARCHIVED        TO S-DATE-ARCHIVED          
A37666         MOVE RS-DEP-STATUS           TO S-DEP-STATUS             
A37666         MOVE RS-REF-STATUS           TO S-REF-STATUS             
A37666         MOVE RS-REG-GROUP-CD         TO S-REG-GROUP-CD           
A37666         MOVE RS-GROUP-EFF-TS         TO S-GROUP-EFF-TS           
A37666         MOVE RS-SENIOR-FL            TO S-SENIOR-FL              
A37666         MOVE RS-DIST-ACCT-NO         TO S-DIST-ACCT-NO           
A37666         MOVE RS-ORIGINATION-CD       TO S-ORIGINATION-CD         
A37666         MOVE RS-OLD-ACCOUNT-NO       TO S-OLD-ACCOUNT-NO         
REARCH     END-IF.                                                      
REARCH*                                                                 12270300
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************23093800
      * 2200-BUILD-CUST-RESULT                                         *23093900
      *                                                                *23094000
      *     CALLS   7010-OPEN-ACCOUNT-CURSOR                           *23094100
      *             2310-PROCESS-ACCOUNTS                              *23094200
      *             7210-CLOSE-ACCOUNT-CURSOR                          *23094300
      *                                                                *23094400
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *23094500
      *                                                                *23094600
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *23094700
      ******************************************************************23094800
                                                                        
       2200-BUILD-CUST-RESULT.                                          
                                                                        
32212 *CSR < FIND CUSTOMER-NO & COMPANY-NO USING ACCOUNT-NO >           23095200
32212 *SEB < FIND CUSTOMER-NO, GROUP-CODE & COMPANY-NO      >           23095300
32212      IF C8-DELINQ-VALUE = 1 THEN                                  
32212         PERFORM 7960-GET-CSR-CUSTOMER-DETAILS THRU 7960-EXIT      
32212      ELSE                                                         
32212         PERFORM 7970-GET-SEB-CUSTOMER-DETAILS THRU 7970-EXIT      
32212      END-IF.                                                      
A37666*                                                                         
A37666     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A37666        PERFORM 7980-GET-CUST-HST-DETAILS  THRU 7980-EXIT         
A37666        IF HA-CUSTOMER-NO > 0                                     
A37666           MOVE HA-CUSTOMER-NO TO AT-CUSTOMER-NO                  
A02036           MOVE HA-COMPANY-NO  TO AT-COMPANY-NO                   
A37666        END-IF                                                    
A37666     END-IF.                                                      
A37666*                                                                         
      *----< OPEN CURSOR >                                              23095409
                                                                        
C33994        PERFORM 7501-CALCULATE-ONE-YEAR-AGO THRU 7501-EXIT.       
              PERFORM 7010-OPEN-ACCOUNT-CURSOR   THRU 7010-EXIT.        
                                                                        
                                                                        
      *----< FETCH EACH ROW, FORMAT OUTPUT AND SEND >                   23095600
                                                                        
              PERFORM 2310-PROCESS-ACCOUNTS      THRU 2310-EXIT         
                UNTIL WS-ACCT-RETURN-CODE = NOT-FOUND                   
                                                                        
      *----< CLOSE CURSORS >                                            23096100
                                                                        
              PERFORM 7210-CLOSE-ACCOUNT-CURSOR THRU 7210-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
A37666*                                                                 23097900
A37666******************************************************************23096800
A37666* 2250-BUILD-ARCH-RESULT                                         *23096900
A37666******************************************************************23097800
A37666*                                                                 23097900
A37666 2250-BUILD-ARCH-RESULT.                                          
A37666*                                                                 23098100
A37666     PERFORM 7980-GET-CUST-HST-DETAILS  THRU 7980-EXIT.           
A37666*                                                                         
A37666     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A37666        PERFORM 7960-GET-CSR-CUSTOMER-DETAILS THRU 7960-EXIT      
A37666        IF AT-CUSTOMER-NO > 0                                     
A37666           MOVE AT-CUSTOMER-NO TO HA-CUSTOMER-NO                  
A02036           MOVE AT-COMPANY-NO  TO HA-COMPANY-NO                   
A37666        END-IF                                                    
A37666     END-IF.                                                      
A37666*                                                                         
A37666     PERFORM 7060-OPEN-ARCHIVE-CURSOR   THRU 7060-EXIT.           
A37666*                                                                 23098800
A37666     PERFORM 2360-PROCESS-ARCHIVES      THRU 2360-EXIT            
A37666       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
A37666*                                                                 23099200
A37666     PERFORM 7260-CLOSE-ARCHIVE-CURSOR THRU 7260-EXIT.            
A37666*                                                                 23099500
A37666 2250-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 23099800
      ******************************************************************23099900
      * 2310-PROCESS-ACCOUNTS                                          *23100000
      *     CALLS       7110-FETCH-ACCOUNT                             *23100100
      *                 8100-SEND-RESULT                               *23100200
      *                                                                *23100300
      *     CALLED FROM 2250-BUILD-ARCH-RESULT                         *23100400
      *                                                                *23100500
      *     FETCHES THE NEXT ACCOUNT ROW, FORMATS THE OUTPUT AND       *23100600
      *     SENDS THE ROW.                                             *23100700
      ******************************************************************23100800
                                                                        
       2310-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7110-FETCH-ACCOUNT         THRU 7110-EXIT.           
                                                                        
           IF WS-ACCT-RETURN-CODE = NOT-FOUND                           
                                                                        
              IF CTR-ROWS > 0                                           
                 GO TO 2310-EXIT                                        
              END-IF                                                    
                                                                        
              MOVE 100 TO RS-RETURN-CODE                                
              MOVE 0   TO RS-ACCOUNT-NO                                 
              MOVE ' ' TO RS-ACCOUNT-STATUS                             
              MOVE ' ' TO RS-STATUS-REASON                              
              MOVE ' ' TO RS-SERVICE-ADDRESS                            
              MOVE ' ' TO RS-CREDIT-GROUP                               
              MOVE ' ' TO RS-CREDIT-STATUS                              
              MOVE 0   TO RS-TWELVE-MONTH-ARREARS                       
              MOVE 0   TO RS-TWELVE-MONTH-DNP                           
              MOVE 0   TO RS-TWELVE-MONTH-RET-CHK                       
              MOVE SPACES TO RS-SECURITIES-TOTAL                        
              MOVE SPACES TO RS-DATE-LAST-PYMNT                         
              MOVE 0   TO RS-TOTAL-BILLED-BAL                           
              MOVE SPACE  TO RS-CASH-ONLY-FL                            
              MOVE SPACE  TO RS-DPP-IND                                 
              MOVE SPACE TO  RS-EPP-IND                                 
              MOVE SPACE TO  RS-MED-CERT-IND                            
              MOVE SPACE TO  RS-BILL-CYCLE-CHG-IND                      
              MOVE SPACE TO  RS-BANK-DRAFT-IND                          
              MOVE SPACES TO   RS-ON-DATE                               
              MOVE SPACES TO   RS-OFF-DATE                              
              MOVE SPACE TO RS-FINAL-STATUS                             
              MOVE SPACE TO RS-CITY-STATE                               
              MOVE SPACE TO RS-ZIP-CODE                                 
              MOVE 0     TO RS-AMOUNT-LAST-PYMNT                        
A37666        MOVE 0     TO RS-ACCOUNT-BALANCE                          
              MOVE SPACE TO RS-DATE-ARCHIVED                            
           ELSE                                                         
              IF WS-NULL-IND = -1                                       
                 MOVE SPACE TO AT-LAST-PYMT-DATE                        
              END-IF                                                    
T13669        IF WS-00-NULL-IND = -1                                    
T13669           MOVE SPACE TO AT-DATE-BILL-DAY-00                      
T13669        END-IF                                                    
T13669        IF WS-30-NULL-IND = -1                                    
T13669           MOVE SPACE TO AT-DATE-BILL-DAY-30                      
T13669        END-IF                                                    
T13669        IF WS-60-NULL-IND = -1                                    
T13669           MOVE SPACE TO AT-DATE-BILL-DAY-60                      
T13669        END-IF                                                    
T13669        IF WS-90-NULL-IND = -1                                    
T13669           MOVE SPACE TO AT-DATE-BILL-DAY-90                      
T13669        END-IF                                                    
32212         IF C8-DELINQ-VALUE = 2                                    
32212              MOVE SPACES TO LR-REG-GROUP-CD                       
32212              PERFORM 7750-REG-PROFILE      THRU 7750-EXIT         
32212              IF LR-REG-GROUP-CD = SPACES THEN                     
32212                   IF LR-REG-GROUP-CD NOT EQUAL  TO                
32212                                                WS-GROUP-CODE THEN 
32212                        GO TO 2310-EXIT                            
32212                   END-IF                                          
32212              ELSE                                                 
32212                   IF WS-GROUP-CODE = SPACES THEN                  
32212                        GO TO 2310-EXIT                            
32212                   END-IF                                          
32212              END-IF                                               
32212              IF LR-REG-GROUP-CD = '200'                           
32212                   PERFORM 7760-ACTIVE-DHR  THRU 7760-EXIT         
32212              END-IF                                               
32212         ELSE                                                      
32212              MOVE SPACES TO RS-GROUP-CD                           
32212         END-IF                                                    
32212 *---< TO CHECK WHETHER THE FETCHED GROUP CODE IS SAME AS >        23108900
32212 *---< INPUT ACCOUNT NUMBER GROUP CODE.                   >        23109000
32212 *     IF LR-REG-GROUP-CD = WS-GROUP-CODE THEN                     23109100
              PERFORM 7120-SELECT-CREDIT-PROFILE THRU 7120-EXIT         
                                                                        
      *---<    GET SERVICE START AND END DATES >                        23109400
                                                                        
              PERFORM 7140-SELECT-CUST-PREM-HIST THRU 7140-EXIT         
                                                                        
      *---<    GET NUMBER OF DNPS IN THE LAST YEAR >                    23109800
                                                                        
              PERFORM 2320-CALC-NO-OF-DNPS        THRU 2320-EXIT        
                                                                        
      *---<    GET NUMBER OF ARREARS IN THE LAST YEAR >                 23110200
                                                                        
              PERFORM 2330-CALC-NO-OF-ARREARS     THRU 2330-EXIT        
                                                                        
      *---<    GET NUMBER OF RET-CHKS IN THE LAST YEAR >                23110600
                                                                        
C33994*       PERFORM 7501-CALCULATE-ONE-YEAR-AGO THRU 7501-EXIT        23110800
              PERFORM 7130-CALC-NO-OF-RET-CHKS    THRU 7130-EXIT        
                                                                        
      *---<    GET ACTIVE SECURITIES TOTAL >                            23111100
                                                                        
              MOVE ZERO TO WS-SECURITIES-TOTAL                          
                           WS-SECURITIES-TOTAL-CMP                      
              MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT      
                                                                        
              IF WS-CODE-DEP-ON-HAND = WS-A                             
                 PERFORM 7600-GET-DEPOSIT-ON-HAND THRU 7600-EXIT        
                 IF WS-DEPOSIT-NULL-IND = 0                             
                    ADD WS-AMT-DEPOSIT TO WS-SECURITIES-TOTAL-CMP       
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 7700-GET-GUARANTEED-AMT     THRU 7700-EXIT        
              IF WS-GUARANTEED-NULL-IND = 0                             
                 ADD WS-AMT-GUARANTEED TO WS-SECURITIES-TOTAL-CMP       
              END-IF                                                    
                                                                        
              PERFORM 7800-GET-SURETY-BOND-AMT    THRU 7800-EXIT        
              IF WS-BOND-NULL-IND = 0                                   
                 ADD WS-AMT-BOND       TO WS-SECURITIES-TOTAL-CMP       
              END-IF                                                    
                                                                        
C33438        MOVE WS-NO               TO WS-WAIVER-EXISTS              
                                                                        
              IF WS-SECURITIES-TOTAL-CMP = 0                            
                 PERFORM 7900-CHECK-FOR-WAIVERS      THRU 7900-EXIT     
              END-IF                                                    
                                                                        
              IF WS-WAIVER-EXISTS = WS-Y                                
                 MOVE WS-WAIVER-TEXT          TO RS-SECURITIES-TOTAL    
              ELSE                                                      
                 MOVE WS-SECURITIES-TOTAL-CMP TO WS-SECURITIES-TOTAL    
                 MOVE WS-SEC-TOT-1            TO WS-SEC-TOT-RET-1       
                 MOVE WS-SEC-TOT-2            TO WS-SEC-TOT-RET-2       
                 MOVE WS-SEC-TOT-RETURN-TXT   TO RS-SECURITIES-TOTAL    
                 INSPECT RS-SECURITIES-TOTAL                            
                    REPLACING LEADING '0' BY SPACES                     
              END-IF                                                    
32212         MOVE AT-CUSTOMER-NO                 TO HT-CUSTOMER-NO     
              PERFORM 7500-SELECT-ADDRESS         THRU 7500-EXIT        
              PERFORM 7504-GET-CITY               THRU 7504-EXIT        
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2340-FORMAT-ADDRESS THRU 2340-EXIT             
                 MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT   
                 MOVE AT-ACCOUNT-NO          TO RS-ACCOUNT-NO           
                 MOVE AT-CODE-ACCT-STAT      TO RS-ACCOUNT-STATUS       
                 MOVE AT-CODE-STATUS-REASON  TO RS-STATUS-REASON        
                 MOVE AT-CREDIT-GROUP        TO RS-CREDIT-GROUP         
                 MOVE AT-CREDIT-STATUS-CODE  TO RS-CREDIT-STATUS        
                                                                        
                 MOVE AT-LAST-PYMT-DATE      TO WS-DATE-HOLD            
                 IF WS-DATE-HOLD NOT EQUAL  SPACE  OR LOW-VALUES        
                    PERFORM 7502-GET-USA-DATE THRU 7502-EXIT            
                 END-IF                                                 
                 MOVE WS-DATE-HOLD-USA       TO RS-DATE-LAST-PYMNT      
                                                                        
TP9123           IF AT-CODE-ACCT-STAT = 'S'                             
T34097              MOVE 'Y'                 TO CALC-PAST-DUE-SW        
T22359              MOVE PROGRAM-NAME        TO WS-CPD00068-CALLING-PGM 
T19557              MOVE SPACES              TO ABEND-FUNCTION          
T19557              PERFORM 9500-CALL-CPD00068                          
T19557                                       THRU 9500-EXIT             
T19557              MOVE RS-RETURN-CODE      TO  WS-ACTIVE-RETURN-CODE, 
T19557                                        SQLCODE                   
T19557               IF ABEND-FUNCTION  > SPACES                        
T19557                  IF ABEND-FUNCTION EQUAL 'BADDATA'               
T19557                     MOVE -1           TO RS-RETURN-CODE,         
T19557                                          WS-ACTIVE-RETURN-CODE   
T19557                  END-IF                                          
                                                                        
T19557                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT     
T19557               END-IF                                             
T15719              MOVE WS-WO-BALANCE       TO RS-TOTAL-BILLED-BAL     
TP9123           ELSE                                                   
                    MOVE AT-TOTAL-AR-BALANCE TO RS-TOTAL-BILLED-BAL     
                 END-IF                                                 
                                                                        
                 MOVE CZ-CASH-ONLY-FL        TO RS-CASH-ONLY-FL         
                 MOVE WS-CODE-DPP-ACCT       TO RS-DPP-IND              
                 MOVE WS-CODE-BUDGET         TO RS-EPP-IND              
                 MOVE WS-CODE-MEDICAL        TO RS-MED-CERT-IND         
                 MOVE AT-BILL-CYCLE-CHG-CD   TO RS-BILL-CYCLE-CHG-IND   
                 MOVE WS-CODE-BANK-EFT       TO RS-BANK-DRAFT-IND       
                                                                        
                 IF  WS-SVC-STRT-NULL-IND      = 0                      
                 AND CH-DATE-UTIL-SVC-STRT NOT = SPACES                 
                    MOVE CH-DATE-UTIL-SVC-STRT  TO WS-DATE-HOLD         
                    PERFORM 7502-GET-USA-DATE THRU 7502-EXIT            
                    MOVE WS-DATE-HOLD-USA       TO RS-ON-DATE           
                 ELSE                                                   
                    MOVE SPACES TO RS-ON-DATE                           
                 END-IF                                                 
                                                                        
                 IF  WS-SVC-END-NULL-IND      = 0                       
                 AND CH-DATE-UTIL-SVC-END NOT = SPACES                  
                    MOVE CH-DATE-UTIL-SVC-END   TO WS-DATE-HOLD         
                    PERFORM 7502-GET-USA-DATE THRU 7502-EXIT            
                    MOVE WS-DATE-HOLD-USA       TO RS-OFF-DATE          
                 ELSE                                                   
                    MOVE SPACES TO RS-OFF-DATE                          
                 END-IF                                                 
              END-IF                                                    
32212        END-IF.                                                    
32212      PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT                  
32212      PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23125400
      * 2320-CALC-NO-OF-DNPS                                           *23125500
      *                                                                *23125600
      *     CALLS NOTHING                                              *23125700
      *                                                                *23125800
      *     CALLED FROM 2200-BUILD-OUTPUT                              *23125900
      *                                                                *23126000
      *     BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT        *23126100
      *     EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES          *23126200
      *     REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A DNP.      *23126300
      *     WE ARE ONLY CHECKING THE PREVIOUS YEAR.                    *23126400
      ******************************************************************23126500
                                                                        
       2320-CALC-NO-OF-DNPS.                                            
                                                                        
           MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST.            
           MOVE CZ-DISC-EXCEPTN-HIST  TO WS-DISC-EXCEPTN-HIST.          
           MOVE 0                     TO RS-TWELVE-MONTH-DNP.           
           MOVE 1                     TO WS-PREV-MNTH.                  
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR            
                 ADD 1 TO RS-TWELVE-MONTH-DNP                           
              END-IF                                                    
                                                                        
              IF WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR     
                 ADD 1 TO RS-TWELVE-MONTH-DNP                           
              END-IF                                                    
                                                                        
              ADD 1 TO WS-PREV-MNTH                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23129100
      * 2330-CALC-NO-OF-ARREARS                                        *23129200
      *                                                                *23129300
      *     CALLS NOTHING                                              *23129400
      *                                                                *23129500
      *     CALLED FROM 2200-BUILD-OUTPUT                              *23129600
      *                                                                *23129700
      *     BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT        *23129800
      *     EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES          *23129900
      *     REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A ARREAR.   *23130000
      *     WE ARE ONLY CHECKING THE PREVIOUS YEAR.                    *23130100
      ******************************************************************23130200
                                                                        
       2330-CALC-NO-OF-ARREARS.                                         
                                                                        
           MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST.            
           MOVE CZ-ARREARS-HIST       TO WS-ARREARS-HIST.               
           MOVE 0                     TO RS-TWELVE-MONTH-ARREARS.       
           MOVE 1                     TO WS-PREV-MNTH.                  
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-ARREARS-HIST-BRKDWN(WS-PREV-MNTH)  = WS-0-TEXT      
TP9038                           OR SPACES OR LOW-VALUE                 
                 CONTINUE                                               
              ELSE                                                      
                 ADD 1 TO RS-TWELVE-MONTH-ARREARS                       
              END-IF                                                    
                                                                        
              ADD 1 TO WS-PREV-MNTH                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23132700
      * 2340-FORMAT-ADDRESS                                            *23132800
      *                                                                *23132900
      *     CALLS NOTHING                                              *23133000
      *                                                                *23133100
      *     CALLED FROM 2310-PROCESS-ADDRESS                           *23133200
      *                                                                *23133300
      *     FORMATS THE ADRESS BY REMOVING THE SPACES                  *23133400
      ******************************************************************23133500
                                                                        
       2340-FORMAT-ADDRESS.                                             
                                                                        
            MOVE SPACES                 TO RS-SERVICE-ADDRESS.          
            MOVE SPACES                 TO RS-CITY-STATE.               
            MOVE '000000000'            TO RS-ZIP-CODE.                 
                                                                        
            MOVE DY-HOUSE-NO            TO WS-STREET-NBR.               
            MOVE DY-ADDR-PREFIX-1       TO WS-PREFIX-1.                 
            MOVE DY-ADDR-PREFIX-2       TO WS-PREFIX-2.                 
            MOVE DY-STREET-NAME         TO WS-STREET-NAME.              
            MOVE DY-STREET-SUFFIX       TO WS-STREET-SUFFIX.            
            MOVE DY-STREET-LOCATION-1   TO WS-LOCATION-1.               
            MOVE DY-STREET-LOCATION-2   TO WS-LOCATION-2.               
                                                                        
TP9038      MOVE WS-STREET-NAME           TO WS-STRING-ARRAY.           
TP9038      MOVE LENGTH OF WS-STREET-NAME TO WS-LENGTH.                 
TP9038      MOVE WS-LENGTH                TO WS-COUNTER.                
TP9038      PERFORM UNTIL WS-ARRAY (WS-COUNTER)                         
TP9038                             > SPACES                             
TP9038                            OR WS-COUNTER = 1                     
TP9038         MOVE '#'                 TO WS-ARRAY (WS-COUNTER)        
TP9038         COMPUTE WS-COUNTER = WS-COUNTER - 1 END-COMPUTE          
TP9038      END-PERFORM.                                                
TP9038      MOVE WS-STRING-ARRAY        TO WS-STREET-NAME               
                                                                        
TP9038      INSPECT WS-STREET-NAME   REPLACING ALL   ' ' BY '%'.        
            INSPECT WS-ADDRESS       REPLACING ALL   ' ' BY '#'.        
                                                                        
            STRING WS-STREET-NBR                                        
                   WS-SPACE                                             
                   WS-PREFIX-1                                          
                   WS-SPACE                                             
                   WS-PREFIX-2                                          
                   WS-SPACE                                             
                   WS-STREET-NAME                                       
                   WS-SPACE                                             
                   WS-STREET-SUFFIX                                     
                   WS-SPACE                                             
                   WS-LOCATION-1                                        
                   WS-SPACE                                             
                   WS-LOCATION-2                                        
            DELIMITED BY '#'                                            
            INTO RS-SERVICE-ADDRESS.                                    
TP9038      INSPECT RS-SERVICE-ADDRESS REPLACING ALL   '%' BY ' '.      
                                                                        
            MOVE A4-TOWN                TO WS-CITY.                     
            MOVE A4-STATE               TO WS-STATE.                    
                                                                        
TP9038      MOVE WS-CITY                  TO WS-STRING-ARRAY            
TP9038      MOVE LENGTH OF WS-CITY        TO WS-LENGTH                  
TP9038      MOVE WS-LENGTH                TO WS-COUNTER.                
TP9038      PERFORM UNTIL WS-ARRAY (WS-COUNTER) > SPACES                
TP9038                            OR WS-COUNTER = 1                     
TP9038         MOVE '#'                   TO WS-ARRAY(WS-COUNTER)       
TP9038         COMPUTE WS-COUNTER = WS-COUNTER - 1 END-COMPUTE          
TP9038      END-PERFORM.                                                
TP9038      MOVE WS-STRING-ARRAY        TO WS-CITY.                     
                                                                        
TP9038      INSPECT WS-CITY          REPLACING ALL   ' ' BY '%'.        
            INSPECT WS-CITY-STATE    REPLACING ALL   ' ' BY '#'.        
                                                                        
            STRING WS-CITY                                              
                   WS-SPACE                                             
                   WS-STATE                                             
            DELIMITED BY '#'                                            
            INTO RS-CITY-STATE.                                         
TP9038      INSPECT RS-CITY-STATE    REPLACING ALL   '%' BY ' '.        
                                                                        
            MOVE DY-ZIP-CODE            TO WS-ACCT-ZIP-CODE-5.          
            IF DY-ZIP-CODE-PLUS-FOUR = SPACES                           
               MOVE '0000'                 TO WS-ACCT-ZIP-CODE-4        
            ELSE                                                        
               MOVE DY-ZIP-CODE-PLUS-FOUR  TO WS-ACCT-ZIP-CODE-4        
            END-IF.                                                     
            MOVE WS-ACCT-ZIP-CODE       TO RS-ZIP-CODE.                 
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23141600
      * 2360-PROCESS-ARCHIVES                                          *23141700
      *     CALLS       7160-FETCH-ARCHIVE                             *23141800
      *                 8100-SEND-RESULT                               *23141900
      *                                                                *23142000
      *     CALLED FROM 2250-BUILD-ARCH-RESULT                         *23142100
      *                                                                *23142200
      *     FETCHES THE NEXT ARCHIVE ROW, FORMATS THE OUTPUT AND       *23142300
      *     SENDS THE ROW.                                             *23142400
      ******************************************************************23142500
      *                                                                 23142600
A37666 2360-PROCESS-ARCHIVES.                                           
A37666*                                                                 23142800
A37666     PERFORM 7160-FETCH-ARCHIVE         THRU 7160-EXIT.           
A37666*                                                                 23143000
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37666        IF WS-ON-DATE-NI  = -1                                    
A37666           MOVE SPACE               TO HA-ACCT-CREATE-DT          
A37666        END-IF                                                    
A37666        IF WS-OFF-DATE-NI = -1                                    
A37666           MOVE SPACE               TO HA-ACCT-FINALED-DT         
A37666        END-IF                                                    
A37666        IF WS-DATE-LAST-PYMT-NI = -1                              
A37666           MOVE SPACE               TO HA-LAST-PYMT-DATE          
A37666        END-IF                                                    
A37666        IF WS-DATE-ARCHIVED-NI  = -1                              
A37666           MOVE SPACE               TO HA-ARCHIVED-DT             
A37666        END-IF                                                    
A37666        IF WS-GROUP-EFF-TS-NI   = -1                              
A37666           MOVE SPACE               TO HA-GROUP-EFF-TS            
A37666        END-IF                                                    
A37666        MOVE HA-CUSTOMER-NO         TO HT-CUSTOMER-NO             
A37666        MOVE HA-ACCOUNT-NO          TO AT-ACCOUNT-NO              
A37666                                       RS-ACCOUNT-NO              
A37666        MOVE HA-REG-GROUP-CD        TO RS-REG-GROUP-CD            
A37666        MOVE HA-GROUP-EFF-TS(1:10)  TO RS-GROUP-EFF-TS            
A37666        MOVE HA-SENIOR-FL           TO RS-SENIOR-FL               
A37666        MOVE HA-DIST-ACCT-NO        TO RS-DIST-ACCT-NO            
A37666        MOVE HA-ORIGINATION-CD      TO RS-ORIGINATION-CD          
A37666        MOVE HA-OLD-ACCOUNT-NO      TO WS-ACCOUNT-DEC             
A37666        IF HA-OLD-ACCOUNT-NO > 0                                  
A37666           MOVE WS-ACCOUNT-NO       TO RS-OLD-ACCOUNT-NO          
A37666        ELSE                                                      
A37666           MOVE SPACES              TO RS-OLD-ACCOUNT-NO          
A37666        END-IF                                                    
A37666        MOVE HA-ACCT-CREATE-DT      TO WS-DATE-HOLD               
A37666        PERFORM 7502-GET-USA-DATE THRU 7502-EXIT                  
A37666        MOVE WS-DATE-HOLD-USA       TO RS-ON-DATE                 
A37666                                                                  
A37666        MOVE HA-ACCT-FINALED-DT     TO WS-DATE-HOLD               
A37666        PERFORM 7502-GET-USA-DATE THRU 7502-EXIT                  
A37666        MOVE WS-DATE-HOLD-USA       TO RS-OFF-DATE                
A37666        MOVE HA-CREDIT-GROUP        TO RS-CREDIT-GROUP            
A37666        MOVE HA-CODE-ACCT-STAT      TO RS-FINAL-STATUS            
A37666        MOVE HA-CODE-STATUS-REASON  TO RS-STATUS-REASON           
A37666                                                                  
A37666        MOVE HA-LAST-PYMT-DATE      TO WS-DATE-HOLD               
A37666        PERFORM 7502-GET-USA-DATE THRU 7502-EXIT                  
A37666        MOVE WS-DATE-HOLD-USA       TO RS-DATE-LAST-PYMNT         
A37666                                                                  
A37666        MOVE HA-LAST-PYMT-AMOUNT    TO RS-AMOUNT-LAST-PYMNT       
A37666        MOVE HA-ACCOUNT-BALANCE-AM  TO RS-ACCOUNT-BALANCE         
A37666                                                                  
A37666        MOVE HA-ARCHIVED-DT         TO WS-DATE-HOLD               
A37666        PERFORM 7502-GET-USA-DATE THRU 7502-EXIT                  
A37666        MOVE WS-DATE-HOLD-USA       TO RS-DATE-ARCHIVED           
A37666                                                                  
A37666        PERFORM 7300-SELECT-ACCT-FL THRU 7300-EXIT                
A37666        MOVE WS-DEP-ROW-EXISTS      TO RS-DEP-STATUS              
A37666        MOVE WS-REF-ROW-EXISTS      TO RS-REF-STATUS              
A37666                                                                  
A37666        PERFORM 7500-SELECT-ADDRESS THRU 7500-EXIT                
A37666        PERFORM 7504-GET-CITY       THRU 7504-EXIT                
A37666        PERFORM 2340-FORMAT-ADDRESS THRU 2340-EXIT                
A37666                                                                  
A37666        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
A37666        PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
A37666     ELSE                                                         
A37666        IF CTR-ROWS > 0                                           
A37666           GO TO 2360-EXIT                                        
A37666        END-IF                                                    
A37666*                                                                 23102000
A37666        MOVE 100                     TO RS-RETURN-CODE            
A37666        MOVE 0                       TO RS-ACCOUNT-NO             
A37666        MOVE ' '                     TO RS-SERVICE-ADDRESS        
A37666        MOVE ' '                     TO RS-ZIP-CODE               
A37666        MOVE ' '                     TO RS-CITY-STATE             
A37666        MOVE ' '                     TO RS-ON-DATE                
A37666        MOVE ' '                     TO RS-OFF-DATE               
A37666        MOVE ' '                     TO RS-FINAL-STATUS           
A37666        MOVE ' '                     TO RS-STATUS-REASON          
A37666        MOVE ' '                     TO RS-CREDIT-GROUP           
A37666        MOVE 0                       TO RS-AMOUNT-LAST-PYMNT      
A37666        MOVE ' '                     TO RS-DATE-LAST-PYMNT        
A37666        MOVE 0                       TO RS-ACCOUNT-BALANCE        
A37666        MOVE ' '                     TO RS-DATE-ARCHIVED          
A37666        MOVE ' '                     TO RS-DEP-STATUS             
A37666        MOVE ' '                     TO RS-REF-STATUS             
A37666        MOVE ' '                     TO RS-REG-GROUP-CD           
A37666        MOVE ' '                     TO RS-GROUP-EFF-TS           
A37666        MOVE ' '                     TO RS-SENIOR-FL              
A37666        MOVE ' '                     TO RS-DIST-ACCT-NO           
A37666        MOVE ' '                     TO RS-ORIGINATION-CD         
A37666        MOVE ' '                     TO RS-OLD-ACCOUNT-NO         
A37666     END-IF.                                                      
A37666*                                                                 23147300
A37666 2360-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 23147600
T13669******************************************************************23147700
T13669*CPD0023C  -  ERROR PROCESSING FOR CALC OF WRITE OFF BALANCE     *23147800
T13669******************************************************************23147900
T13669     EXEC SQL                                                     23148000
T13669        INCLUDE CPD0023C                                          23148100
T13669     END-EXEC.                                                    23148200
                                                                        
C29631******************************************************************33590100
C29631*DETERMINE IF WE ARE USING SEB OR CSR                            *33590200
C29631******************************************************************33590201
C29631 7000-DETERMINE-REGION.                                           
C29631                                                                  
C29631     EXEC SQL                                                     
C29631        SELECT DELINQ_VALUE                                       
C29631          INTO :C8-DELINQ-VALUE                                   
C29631          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C29631         WHERE DELINQ_CD = 'DATABASE'                             
C29631           AND COMPANY_NO = '01'                                  
T35434                                                           
C29631     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     33590204
MFA-TR*       SELECT DELINQ_VALUE                                       33590205
MFA-TR*         INTO :C8-DELINQ-VALUE                                   33590206
MFA-TR*         FROM CSS_DELINQUENCY                                    33590207
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                             33590208
MFA-TR*          AND COMPANY_NO = '01'                                  33590209
MFA-TR*        WITH UR                                                  33590210
MFA-TR*    END-EXEC.                                                    33590211

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29631                                                                  
C29631     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29631                                                                  
C29631     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29631         NEXT SENTENCE                                            
C29631     ELSE                                                         
C29631         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
C29631         MOVE '7000'                    TO ACTIVE-PARAGRAPH       
C29631         MOVE 'SELECT'                  TO ABEND-FUNCTION         
C29631         MOVE 'CSS_DELINQUENCY'         TO TABLE-1                
C29631         MOVE 'DELINQ_VALUE'            TO TABLE-ELEMENT-1        
C29631         MOVE 'DATABASE'                TO HOSTVAR-ELEMENT-1      
C29631         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
C29631         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C29631     END-IF.                                                      
C29631                                                                  
C29631 7000-EXIT.                                                       
C29631     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************50410006
      * 7010-OPEN-ACCOUNT-CURSOR                                       *50410007
      *     CALLS       9000-SEND-ERROR-RESULT                         *50410008
      *                 9900-SQL-ERROR-ROUTINE                         *50410009
      *                                                                *50410010
      *     CALLED FROM 2200-BUILD-CUST-RESULT                         *50410020
      *                                                                *50410030
      *     OPENS THE CURSOR                                           *50410040
      ******************************************************************50410050
                                                                        
       7010-OPEN-ACCOUNT-CURSOR.                                        
                                                                        
           MOVE '7010'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN ACCOUNT-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
REARCH        MOVE 'CUSTOMER-NO'              TO TABLE-ELEMENT-1        
REARCH        MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
A37666******************************************************************50412700
A37666* 7060-OPEN-ARCHIVE-CURSOR                                       *50412800
A37666*     CALLS       9000-SEND-ERROR-RESULT                         *50412900
A37666*                 9900-SQL-ERROR-ROUTINE                         *50413000
A37666*                                                                *50413100
A37666*     CALLED FROM 2250-BUILD-ARCH-RESULT                         *50413200
A37666*                                                                *50413300
A37666*     OPENS THE CURSOR                                           *50413400
A37666******************************************************************50413500
A37666*                                                                 50413600
A37666 7060-OPEN-ARCHIVE-CURSOR.                                        
A37666                                                                  
A37666     MOVE '7060'              TO ACTIVE-PARAGRAPH.                
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        OPEN ARCHIVE-CURSOR                                       
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37666        NEXT SENTENCE                                             
A37666     ELSE                                                         
A37666        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE 'OPEN'                     TO ABEND-FUNCTION         
A37666        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A37666                                           ABEND-TABLES           
A37666        MOVE 'HST_ACCOUNT'              TO TABLE-1                
A37666        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A37666        MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666                                                                  
A37666 7060-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 50416300
      ******************************************************************50416400
      * 7110-FETCH-ACCOUNT                                             *50416500
      *     CALLS       9000-SEND-ERROR-RESULT                         *50416600
      *                 9900-SQL-ERROR-ROUTINE                         *50416700
      *                                                                *50416800
      *     CALLED FROM 2310-PROCESS-ACCOUNTS                          *50416900
      *                                                                *50417000
      *     FETCHES A ROW FROM THE TABLE                               *50417100
      ******************************************************************50417200
                                                                        
       7110-FETCH-ACCOUNT.                                              
                                                                        
           MOVE '7110'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  ACCOUNT-CURSOR                                     
              INTO  :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-CODE-STATUS-REASON,                             
                    :AT-ADDRESS-ID,                                     
                    :AT-ADDRESS-FORMAT,                                 
                    :AT-CREDIT-GROUP,                                   
                    :AT-CREDIT-STATUS-CODE,                             
                    :AT-LAST-PYMT-DATE :WS-NULL-IND,                     
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-BILL-CYCLE-CHG-CD,                              
T13669              :AT-NOTICE-EXEMPT-CD,                               
T13669              :AT-CODE-DISC-OK,                                   
T13669              :AT-DATE-BILL-DAY-00 :WS-00-NULL-IND,                
T13669              :AT-DATE-BILL-DAY-30 :WS-30-NULL-IND,                
T13669              :AT-DATE-BILL-DAY-60 :WS-60-NULL-IND,                
T13669              :AT-DATE-BILL-DAY-90 :WS-90-NULL-IND,                
T13669              :AT-BANKRUPTCY-IND,                                 
T13669              :AT-COMPANY-NO,                                     
T13669              :AT-LOCAL-OFFICE,                                   
C28788              :AT-IVR-EXEMPT-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACCT-RETURN-CODE.                         
                                                                        
           IF WS-ACCT-RETURN-CODE = SUCCESSFUL-CALL                     
           OR                       NOT-FOUND                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
REARCH        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
REARCH        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50422500
      * 7120-SELECT-CREDIT-PROFILE                                     *50422600
      *                                                                *50422700
      *     CALLS 9000-SEND-ERROR-RESULT                               *50422800
      *           9900-SQL-ERROR-ROUTINE                               *50422900
      *                                                                *50423000
      *     CALLED FROM 2200-BUILD-RESULT                              *50423100
      *                                                                *50423200
      *     SELECTS A ROW FROM THE TABLE CSS_CREDIT_PROFILE            *50423300
      ******************************************************************50423400
                                                                        
       7120-SELECT-CREDIT-PROFILE.                                      
                                                                        
           MOVE '7120'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT  CZ.ARREARS_HIST,                                  
                      CZ.DISCONNECT_HIST,                               
                      CZ.DISC_EXCEPTN_HIST,                             
                      CZ.CASH_ONLY_FL                                   
              INTO   :CZ-ARREARS-HIST,                                  
                     :CZ-DISCONNECT-HIST,                               
                     :CZ-DISC-EXCEPTN-HIST,                             
                     :CZ-CASH-ONLY-FL                                   
              FROM    CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)               
              WHERE   CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                  
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50424000
MFA-TR*       SELECT  CZ.ARREARS_HIST,                                  50424100
MFA-TR*               CZ.DISCONNECT_HIST,                               50424200
MFA-TR*               CZ.DISC_EXCEPTN_HIST,                             50424300
MFA-TR*               CZ.CASH_ONLY_FL                                   50424400
MFA-TR*       INTO   :CZ-ARREARS-HIST,                                  50424500
MFA-TR*              :CZ-DISCONNECT-HIST,                               50424600
MFA-TR*              :CZ-DISC-EXCEPTN-HIST,                             50424700
MFA-TR*              :CZ-CASH-ONLY-FL                                   50424800
MFA-TR*       FROM    CSS_CREDIT_PROFILE CZ                             50424900
MFA-TR*       WHERE   CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                  50425000
MFA-TR*       WITH UR                                                   50425100
MFA-TR*    END-EXEC                                                     50425200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50427500
      * 7130-CALC-NO-OF-RET-CHKS                                       *50427600
      *                                                                *50427700
      *     CALLS 9000-SEND-ERROR-RESULT                               *50427800
      *           9900-SQL-ERROR-ROUTINE                               *50427900
      *                                                                *50428000
      *     CALLED FROM 2200-BUILD-RESULT                              *50428100
      *                                                                *50428200
      *     COUNTS THE NUMBER OF RETURNED CHECKS/DRAFTS IN THE LAST    *50428300
      *     YEAR.                                                      *50428400
      ******************************************************************50428500
                                                                        
       7130-CALC-NO-OF-RET-CHKS.                                        
                                                                        
           MOVE '7130'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :RS-TWELVE-MONTH-RET-CHK                            
              FROM   CSS_NSF_HIST NH WITH(READUNCOMMITTED)                      
              WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                
              AND    NH.NSF_STATUS_CD   = :WS-C                         
              AND    NH.DATE_TRAN       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-ONE-YEAR-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-ONE-YEAR-AGO
              ) <> 0) OR (LEN(:WS-ONE-YEAR-AGO) <> 10), CIS.CHAR2DATE(
                                                       :WS-ONE-YEAR-AGO
              ), CONVERT(DATE, :WS-ONE-YEAR-AGO) )              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     50429100
MFA-TR*       SELECT COUNT(*)                                           50429200
MFA-TR*       INTO  :RS-TWELVE-MONTH-RET-CHK                            50429300
MFA-TR*       FROM   CSS_NSF_HIST NH                                    50429400
MFA-TR*       WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                50429500
MFA-TR*       AND    NH.NSF_STATUS_CD   = :WS-C                         50429600
MFA-TR*       AND    NH.DATE_TRAN       > :WS-ONE-YEAR-AGO              50429700
MFA-TR*       WITH UR                                                   50429800
MFA-TR*    END-EXEC.                                                    50429900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T16083        MOVE 'NSF_STATUS_CD'            TO TABLE-ELEMENT-2        
T16083        MOVE 'DATE_TRAN'                TO TABLE-ELEMENT-3        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T16083        MOVE WS-C                       TO HOSTVAR-ELEMENT-2      
T16083        MOVE WS-ONE-YEAR-AGO            TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50432500
      * 7140-SELECT-CUST-PREM-HIST                                     *50432600
      *                                                                *50432700
      *     CALLS 9000-SEND-ERROR-RESULT                               *50432800
      *           9900-SQL-ERROR-ROUTINE                               *50432900
      *                                                                *50433000
      *     CALLED FROM 2200-BUILD-CUST-RESULT                         *50433100
      *                                                                *50433200
      *     GET THE SERVICE START AND END DATES                        *50433300
      ******************************************************************50433400
                                                                        
       7140-SELECT-CUST-PREM-HIST.                                      
                                                                        
           MOVE '7140'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT CH.DATE_UTIL_SVC_STRT,                             
                     CH.DATE_UTIL_SVC_END                               
              INTO  :CH-DATE-UTIL-SVC-STRT :WS-SVC-STRT-NULL-IND,        
                    :CH-DATE-UTIL-SVC-END :WS-SVC-END-NULL-IND           
              FROM   CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
              WHERE  CH.ACCOUNT_NO      = :AT-ACCOUNT-NO                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50434000
MFA-TR*       SELECT CH.DATE_UTIL_SVC_STRT,                             50434100
MFA-TR*              CH.DATE_UTIL_SVC_END                               50434200
MFA-TR*       INTO  :CH-DATE-UTIL-SVC-STRT:WS-SVC-STRT-NULL-IND,        50434300
MFA-TR*             :CH-DATE-UTIL-SVC-END:WS-SVC-END-NULL-IND           50434400
MFA-TR*       FROM   CSS_CUST_PREM_HIST CH                              50434500
MFA-TR*       WHERE  CH.ACCOUNT_NO      = :AT-ACCOUNT-NO                50434600
MFA-TR*       WITH UR                                                   50434700
MFA-TR*    END-EXEC.                                                    50434800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              MOVE SPACES TO CH-DATE-UTIL-SVC-STRT                      
              MOVE SPACES TO CH-DATE-UTIL-SVC-END                       
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CUST_PREM_HIST'       TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
A37666******************************************************************50437300
A37666* 7160-FETCH-ARCHIVE                                             *50437400
A37666*     CALLS       9000-SEND-ERROR-RESULT                         *50437500
A37666*                 9900-SQL-ERROR-ROUTINE                         *50437600
A37666*                                                                *50437700
A37666*     CALLED FROM 2360-PROCESS-ARCHIVES                          *50437800
A37666*                                                                *50437900
A37666*     FETCHES A ROW FROM THE TABLE                               *50438000
A37666******************************************************************50438100
A37666*                                                                 50438200
A37666 7160-FETCH-ARCHIVE.                                              
A37666*                                                                 50438400
A37666     MOVE '7160'        TO ACTIVE-PARAGRAPH.                      
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        FETCH  ARCHIVE-CURSOR                                     
A37666        INTO  :HA-ACCOUNT-NO,                                     
A37666              :HA-CUSTOMER-NO,                                    
A37666              :HA-ACCT-CREATE-DT :WS-ON-DATE-NI,                  
A37666              :HA-ACCT-FINALED-DT :WS-OFF-DATE-NI,                 
A37666              :HA-CREDIT-GROUP,                                   
A37666              :HA-CODE-ACCT-STAT,                                 
A37666              :HA-CODE-STATUS-REASON,                             
A37666              :HA-LAST-PYMT-DATE :WS-DATE-LAST-PYMT-NI,            
A37666              :HA-LAST-PYMT-AMOUNT,                               
A37666              :HA-ACCOUNT-BALANCE-AM,                             
A37666              :HA-ARCHIVED-DT :WS-DATE-ARCHIVED-NI,                
A37666              :HA-REG-GROUP-CD,                                   
A37666              :HA-GROUP-EFF-TS :WS-GROUP-EFF-TS-NI,                
A37666              :HA-SENIOR-FL,                                      
A37666              :HA-DIST-ACCT-NO,                                   
A37666              :HA-ORIGINATION-CD,                                 
A37666              :HA-OLD-ACCOUNT-NO                                  
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                 50440700
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666*                                                                 50440900
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A37666        NEXT SENTENCE                                             
A37666     ELSE                                                         
A37666        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE 'FETCH'                    TO ABEND-FUNCTION         
A37666        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A37666                                           ABEND-TABLES           
A37666        MOVE 'HST_ACCOUNT'              TO TABLE-1                
A37666        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A37666        MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666*                                                                 50442300
A37666 7160-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 50442600
      ******************************************************************50442700
      * 7210-CLOSE-ACCOUNT-CURSOR                                      *50442800
      *     CALLS       9000-SEND-ERROR-RESULT                         *50442900
      *                 9900-SQL-ERROR-ROUTINE                         *50443000
      *                                                                *50443100
      *     CALLED FROM 2200-BUILD-CUST-RESULT                         *50443200
      *                                                                *50443300
      *     CLOSES THE CURSOR                                          *50443400
      ******************************************************************50443500
                                                                        
       7210-CLOSE-ACCOUNT-CURSOR.                                       
                                                                        
           MOVE '7210'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  ACCOUNT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T16083        MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
CBSI          MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T16083        MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
A37666******************************************************************50446600
A37666* 7260-CLOSE-ARCHIVE-CURSOR                                      *50446700
A37666*     CALLS       9000-SEND-ERROR-RESULT                         *50446800
A37666*                 9900-SQL-ERROR-ROUTINE                         *50446900
A37666*                                                                *50447000
A37666*     CALLED FROM 2250-BUILD-ARCH-RESULT                         *50447100
A37666*                                                                *50447200
A37666*     CLOSES THE CURSOR                                          *50447300
A37666******************************************************************50447400
A37666*                                                                 50447500
A37666 7260-CLOSE-ARCHIVE-CURSOR.                                       
A37666*                                                                 50447700
A37666     MOVE '7260'              TO ACTIVE-PARAGRAPH.                
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        CLOSE  ARCHIVE-CURSOR                                     
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
A37666        NEXT SENTENCE                                             
A37666     ELSE                                                         
A37666        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
A37666        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A37666                                           ABEND-TABLES           
A37666        MOVE 'HST_ACOUNT'               TO TABLE-1                
A37666        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A37666        MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666*                                                                 50449900
A37666 7260-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 50450200
A37666****************************************************************  11472000
A37666**  7300-SELECT-ACCT-FL.                                      **  11474000
A37666**      CHECKS HST_ACCOUNT TABLE FOR REFUND AND DEPOSIT FLAG  **  11475000
A37666****************************************************************  11477000
A37666 7300-SELECT-ACCT-FL.                                             
A37666*                                                                 11479000
A37666     MOVE '7300'              TO ACTIVE-PARAGRAPH.                
A37666*                                                                 11479000
A37666     EXEC SQL                                                     
A37666          SELECT DEPOSIT_FL                                       
A37666                ,REFUND_FL                                        
A37666            INTO :WS-DEP-ROW-EXISTS                               
A37666                ,:WS-REF-ROW-EXISTS                               
A37666          FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
A37666          WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       
A37666                                                           
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11479100
MFA-TR*         SELECT DEPOSIT_FL                                       11479200
MFA-TR*               ,REFUND_FL                                        11479200
MFA-TR*           INTO :WS-DEP-ROW-EXISTS                               11479300
MFA-TR*               ,:WS-REF-ROW-EXISTS                               11479300
MFA-TR*         FROM HST_ACCOUNT                                        11479400
MFA-TR*         WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       11479500
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11479600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                 11479700
A37666     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A37666     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A37666         CONTINUE                                                 
A37666     ELSE                                                         
A37666        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A37666        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A37666                                           ABEND-TABLES           
A37666        MOVE 'HST_ACCOUNT'              TO TABLE-1                
A37666        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A37666        MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666*                                                                 11480900
A37666 7300-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                 50450200
      ******************************************************************50450300
      * 7500-SELECT-ADDRESS                                            *50450400
      *                                                                *50450500
      *     CALLS 9000-SEND-ERROR-RESULT                               *50450600
      *           9900-SQL-ERROR-ROUTINE                               *50450700
      *                                                                *50450800
      *     CALLED FROM 2200-BUILD-RESULT                              *50450900
      *                                                                *50451000
      *     SELECTS THE ADDRESS                                        *50451100
      ******************************************************************50451200
                                                                        
       7500-SELECT-ADDRESS.                                             
                                                                        
           MOVE '7500'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
C33994         SELECT TOP(1) DY.HOUSE_NO,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.STREET_NAME,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.STREET_SUFFIX,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN                                 
               INTO  :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN                                 
                 FROM CSS_ADDR_FORMATTED DY,                            
                      CSS_NAME_ACCT_XREF HT                             
REARCH          WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  
REARCH            AND HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DY.ADDRESS_ID  = HT.ADDRESS_ID                    
C33994                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     50451800
MFA-TR*        SELECT DY.HOUSE_NO,                                      50452000
MFA-TR*               DY.ADDR_PREFIX_1,                                 50452100
MFA-TR*               DY.ADDR_PREFIX_2,                                 50452200
MFA-TR*               DY.STREET_NAME,                                   50452300
MFA-TR*               DY.STREET_LOCATION_1,                             50452400
MFA-TR*               DY.STREET_LOCATION_2,                             50452500
MFA-TR*               DY.STREET_SUFFIX,                                 50452600
MFA-TR*               DY.ZIP_CODE,                                      50452700
MFA-TR*               DY.ZIP_CODE_PLUS_FOUR,                            50452800
MFA-TR*               DY.ZIP_CODE_TOKEN                                 50452900
MFA-TR*        INTO  :DY-HOUSE-NO,                                      50453000
MFA-TR*              :DY-ADDR-PREFIX-1,                                 50453100
MFA-TR*              :DY-ADDR-PREFIX-2,                                 50453200
MFA-TR*              :DY-STREET-NAME,                                   50453300
MFA-TR*              :DY-STREET-LOCATION-1,                             50453400
MFA-TR*              :DY-STREET-LOCATION-2,                             50453500
MFA-TR*              :DY-STREET-SUFFIX,                                 50453600
MFA-TR*              :DY-ZIP-CODE,                                      50453700
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                            50453800
MFA-TR*              :DY-ZIP-CODE-TOKEN                                 50453900
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            50454000
MFA-TR*               CSS_NAME_ACCT_XREF HT                             50454100
MFA-TR*         WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  50454200
MFA-TR*           AND HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   50454400
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                         50454500
MFA-TR*           AND DY.ADDRESS_ID  = HT.ADDRESS_ID                    50454600
MFA-TR*           FETCH FIRST 1 ROWS ONLY                               50454700
MFA-TR*    END-EXEC.                                                    50454800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-2                
CBSI          MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
T16083        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE HT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
T16083        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50457400
      * 7501-CALCULATE-ONE-YEAR-AGO                                    *50457500
      *                                                                *50457600
      *     CALLS 9000-SEND-ERROR-RESULT                               *50457700
      *           9900-SQL-ERROR-ROUTINE                               *50457800
      *                                                                *50457900
      *     CALLED FROM 2200-BUILD-RESULT                              *50458000
      *                                                                *50458100
      *     WORKS OUT THE DATE ONE YEAR AGO                            *50458200
      ******************************************************************50458300
                                                                        
       7501-CALCULATE-ONE-YEAR-AGO.                                     
                                                                        
           MOVE '7501'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
C33994        SELECT
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ONE-YEAR-AGO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     50458900
MFA-TR*       SET  :WS-ONE-YEAR-AGO   =  CURRENT DATE - 12 MONTH        50459100
MFA-TR*    END-EXEC.                                                    50459400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
A37666        MOVE 'WS-ONE-YEAR-AGO'          TO TABLE-1                
REARCH        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
REARCH        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50461700
      * 7502-GET-USA-DATE                                              *50461800
      *                                                                *50461900
      *     CALLS 9000-SEND-ERROR-RESULT                               *50462000
      *           9900-SQL-ERROR-ROUTINE                               *50462100
      *                                                                *50462200
      *     CALLED FROM                                                *50462300
      *                                                                *50462400
      *     FORMATS THE DATE INTO MM/DD/YYYY                           *50462500
      ******************************************************************50462600
                                                                        
       7502-GET-USA-DATE.                                               
                                                                        
           MOVE '7502'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF WS-DATE-HOLD <= SPACES                                    
              MOVE SPACES TO WS-DATE-HOLD-USA                           
              GO TO 7502-EXIT                                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
C33994        SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')
            INTO
              :WS-DATE-HOLD-USA   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     50463700
MFA-TR*       SET  :WS-DATE-HOLD-USA  = CHAR(DATE(:WS-DATE-HOLD),USA)   50463900
MFA-TR*    END-EXEC.                                                    50464200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A37666        MOVE 'SET'               TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
A37666        MOVE 'WS-DATE-HOLD-USA'  TO TABLE-1                       
REARCH        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
REARCH        MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7502-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50471700
      ******************************************************************50471800
      * 7504-GET-CITY                                                  *50471900
      *                                                                *50472000
      *     CALLS 9000-SEND-ERROR-RESULT                               *50472100
      *           9900-SQL-ERROR-ROUTINE                               *50472200
      *                                                                *50472300
      *     CALLED FROM                                                *50472400
      *                                                                *50472500
      *     GETS THE CITY AND STATE                                    *50472600
      ******************************************************************50472700
                                                                        
       7504-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOWN,                                             
                      STATE                                             
               INTO   :A4-TOWN,                                         
                      :A4-STATE                                         
               FROM   CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
               WHERE  ZIP_CODE       = :DY-ZIP-CODE                     
               AND    ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50473100
MFA-TR*        SELECT TOWN,                                             50473200
MFA-TR*               STATE                                             50473300
MFA-TR*        INTO   :A4-TOWN,                                         50473400
MFA-TR*               :A4-STATE                                         50473500
MFA-TR*        FROM   CSS_ZIP_CODE                                      50473600
MFA-TR*        WHERE  ZIP_CODE       = :DY-ZIP-CODE                     50473700
MFA-TR*        AND    ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               50473800
MFA-TR*       WITH UR                                                   50473900
MFA-TR*    END-EXEC.                                                    50474000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES TO A4-TOWN                                 
                 MOVE SPACES TO A4-STATE                                
                 MOVE SUCCESSFUL-CALL TO WS-ACTIVE-RETURN-CODE          
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7504'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
CBSI             MOVE SPACES                 TO ABEND-SQL-PREDICATES    
CBSI                                            ABEND-TABLES            
                 MOVE 'CSS_ZIP_CODE'         TO TABLE-1                 
                 MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1         
                 MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2         
REARCH           MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3         
                 MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1       
                 MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2       
REARCH           MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3       
                 PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT    
                 PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7504-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50477400
      * 7600-GET-DEPOSIT-ON-HAND                                       *50477500
      *                                                                *50477600
      *     CALLS 9000-SEND-ERROR-RESULT                               *50477700
      *           9900-SQL-ERROR-ROUTINE                               *50477800
      *                                                                *50477900
      *     CALLED FROM 2200-BUILD-RESULT                              *50478000
      *                                                                *50478100
      *     GETS THE DEPOSIT ON HAND                                   *50478200
      ******************************************************************50478300
                                                                        
       7600-GET-DEPOSIT-ON-HAND.                                        
                                                                        
           MOVE '7600'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
               INTO  :WS-AMT-DEPOSIT :WS-DEPOSIT-NULL-IND                
               FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND    (DEPOSIT_STATUS_CD = 'A'                          
                OR     DEPOSIT_STATUS_CD = 'P')                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50478900
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                  50479000
MFA-TR*        INTO  :WS-AMT-DEPOSIT:WS-DEPOSIT-NULL-IND                50479100
MFA-TR*        FROM   CSS_DEP_ON_HAND                                   50479200
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       50479300
MFA-TR*        AND    (DEPOSIT_STATUS_CD = 'A'                          50479400
MFA-TR*         OR     DEPOSIT_STATUS_CD = 'P')                         50479500
MFA-TR*        WITH UR                                                  50479600
MFA-TR*    END-EXEC.                                                    50479700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
T16083        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50481800
      * 7700-GET-GUARANTEED-AMT                                        *50481900
      *                                                                *50482000
      *     CALLS 9000-SEND-ERROR-RESULT                               *50482100
      *           9900-SQL-ERROR-ROUTINE                               *50482200
      *                                                                *50482300
      *     CALLED FROM 2200-BUILD-RESULT                              *50482400
      *                                                                *50482500
      *     GET THE GUARANTEED AMOUNT                                  *50482600
      ******************************************************************50482700
                                                                        
       7700-GET-GUARANTEED-AMT.                                         
                                                                        
           MOVE '7700'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMOUNT_GUARANTEED)                            
               INTO  :WS-AMT-GUARANTEED :WS-GUARANTEED-NULL-IND          
               FROM   CSS_GUARANTOR WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND    GUAR_STATUS_CD = 'A'                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50483300
MFA-TR*        SELECT SUM(AMOUNT_GUARANTEED)                            50483400
MFA-TR*        INTO  :WS-AMT-GUARANTEED:WS-GUARANTEED-NULL-IND          50483500
MFA-TR*        FROM   CSS_GUARANTOR                                     50483600
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       50483700
MFA-TR*        AND    GUAR_STATUS_CD = 'A'                              50483800
MFA-TR*        WITH UR                                                  50483900
MFA-TR*    END-EXEC.                                                    50484000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_GUARANTOR'     TO TABLE-1                       
T16083        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29631 7750-REG-PROFILE.                                                
C29631                                                                  
C29631     EXEC SQL                                                     
C29631         SELECT TOP(1) REG_GROUP_CD,
              SENIOR_FL                                         
C29631           INTO :LR-REG-GROUP-CD,                                 
C29631                :LR-SENIOR-FL                                     
C29631           FROM CSS_REG_PROFILE                                   
C29631           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
C29561                                           
C29631     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     50485904
MFA-TR*        SELECT REG_GROUP_CD,                                     50485905
MFA-TR*               SENIOR_FL                                         50485906
MFA-TR*          INTO :LR-REG-GROUP-CD,                                 50485907
MFA-TR*               :LR-SENIOR-FL                                     50485908
MFA-TR*          FROM CSS_REG_PROFILE                                   50485909
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      50485910
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                 50485911
MFA-TR*    END-EXEC.                                                    50485912

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29631                                                                  
C29631     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29631                                                                  
C29631     EVALUATE WS-ACTIVE-RETURN-CODE                               
C29631          WHEN SUCCESSFUL-CALL                                    
C29631              MOVE LR-REG-GROUP-CD TO RS-GROUP-CD(1:3)            
C29631              IF LR-SENIOR-FL = 'Y'                               
C29631                  MOVE '-S' TO RS-GROUP-CD(4:2)                   
C29631              ELSE                                                
C29631                  MOVE '  ' TO RS-GROUP-CD(4:2)                   
C29631              END-IF                                              
C29631          WHEN NOT-FOUND                                          
C29631              MOVE 'NA' TO RS-GROUP-CD                            
C29631          WHEN OTHER                                              
C29631              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C29631              MOVE '7750'               TO ACTIVE-PARAGRAPH       
C29631              MOVE 'SELECT'             TO ABEND-FUNCTION         
C29631              MOVE 'CSS_REG_PROFILE'    TO TABLE-1                
C29631              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C29631              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C29631              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C29631              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C29631     END-EVALUATE.                                                
C29631                                                                  
C29631 7750-EXIT.                                                       
C29631     EXIT.                                                        
C29631                                                                  
C29631 7760-ACTIVE-DHR.                                                 
C29631                                                                  
C29631     EXEC SQL                                                     
C29631         SELECT 'Y'                                               
C29631           INTO :WS-ACTIVE-DHR                                    
P00172           FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
P00172          WHERE CU.CUSTOMER_NO = :AT-CUSTOMER-NO                  
P00172            AND CU.DHR_FL      = 'Y'                              
P00172                                                           
C29631     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50485987
MFA-TR*        SELECT 'Y'                                               50485988
MFA-TR*          INTO :WS-ACTIVE-DHR                                    50485989
MFA-TR*          FROM CSS_CUSTOMER CU                                   50485990
MFA-TR*         WHERE CU.CUSTOMER_NO = :AT-CUSTOMER-NO                  50485991
MFA-TR*           AND CU.DHR_FL      = 'Y'                              50485992
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    50485994

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29631                                                                  
C29631     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29631                                                                  
C29631     EVALUATE WS-ACTIVE-RETURN-CODE                               
C29631          WHEN SUCCESSFUL-CALL                                    
C29631              IF WS-ACTIVE-DHR = 'Y'                              
C29631                  MOVE '-DHR' TO RS-GROUP-CD(6:4)                 
C29631              ELSE                                                
C29631                  MOVE '    ' TO RS-GROUP-CD(6:4)                 
C29631              END-IF                                              
C29631          WHEN NOT-FOUND                                          
C29631              MOVE '    ' TO RS-GROUP-CD(6:4)                     
C29631          WHEN OTHER                                              
C29631              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C29631              MOVE '7760'               TO ACTIVE-PARAGRAPH       
C29631              MOVE 'SELECT'             TO ABEND-FUNCTION         
P00172              MOVE 'CSS_CUSTOMER'       TO TABLE-1                
P00172              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1        
P00172              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1      
C29631              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C29631              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C29631     END-EVALUATE.                                                
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50486615
      * 7800-GET-SURETY-BOND-AMT                                       *50486616
      *                                                                *50486617
      *     CALLS 9000-SEND-ERROR-RESULT                               *50486618
      *           9900-SQL-ERROR-ROUTINE                               *50486619
      *                                                                *50486620
      *     CALLED FROM 2200-BUILD-RESULT                              *50486630
      *                                                                *50486640
      *     GETS AMT FROM SURETY BOND TABLE - COULD BE SURETY BOND (A) *50486650
      *     OR IRREVOCABLE LETTER OF CREDIT (B)                        *50486660
      ******************************************************************50486670
                                                                        
       7800-GET-SURETY-BOND-AMT.                                        
                                                                        
           MOVE '7800'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
               INTO  :WS-AMT-BOND :WS-BOND-NULL-IND                      
               FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
               AND    CODE_BOND_TYPE  IN ('A', 'B')                     
               AND    CODE_STATUS     = 'A'                             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50487000
MFA-TR*        SELECT SUM(AMT_BOND)                                     50487100
MFA-TR*        INTO  :WS-AMT-BOND:WS-BOND-NULL-IND                      50487200
MFA-TR*        FROM   CSS_SURETY_BOND                                   50487300
MFA-TR*        WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  50487400
MFA-TR*        AND    CODE_BOND_TYPE  IN ('A', 'B')                     50487500
MFA-TR*        AND    CODE_STATUS     = 'A'                             50487600
MFA-TR*       WITH UR                                                   50487700
MFA-TR*    END-EXEC.                                                    50487800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_SURETY_BOND'   TO TABLE-1                       
T16083        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50489900
      * 7900-CHECK-FOR-WAIVERS                                         *50490000
      *                                                                *50490100
      *     CALLS 9000-SEND-ERROR-RESULT                               *50490200
      *           9900-SQL-ERROR-ROUTINE                               *50490300
      *                                                                *50490400
      *     CALLED FROM 2200-BUILD-RESULT                              *50490500
      *                                                                *50490600
      *     CHECKS TO SEE IF A WAIVER EXISTS                           *50490700
      ******************************************************************50490800
                                                                        
       7900-CHECK-FOR-WAIVERS.                                          
                                                                        
           MOVE '7900'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33994         SELECT TOP(1) 'Y'                                              
               INTO  :WS-WAIVER-EXISTS                                  
               FROM   CSS_SURETY_BOND                                   
               WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
               AND    CODE_BOND_TYPE  = :WS-C                           
C33994                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     50491600
MFA-TR*        SELECT  'Y'                                              50491800
MFA-TR*        INTO  :WS-WAIVER-EXISTS                                  50491900
MFA-TR*        FROM   CSS_SURETY_BOND                                   50492000
MFA-TR*        WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  50492100
MFA-TR*        AND    CODE_BOND_TYPE  = :WS-C                           50492200
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  50492300
MFA-TR*    END-EXEC.                                                    50492400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C33994     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                       = NOT-FOUND                         
              MOVE SUCCESSFUL-CALL TO  WS-ACTIVE-RETURN-CODE            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
T16083        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T16083        MOVE 'CODE_BOND_TYPE'     TO TABLE-ELEMENT-2              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T16083        MOVE WS-C                 TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
32212 ******************************************************************50499300
32212 *7960-GET-CSR-CUSTOMER-DETAILS.                                   50499400
32212 ******************************************************************50499500
32212  7960-GET-CSR-CUSTOMER-DETAILS.                                   
32212                                                                   
32212 *FOR CSR, USING INPUT ACCOUNT-NO FINDING THE CUSTOMER-NO &        50499800
32212 *        COMPANY-NO.                                              50499801
32212      EXEC SQL                                                     
32212         SELECT COMPANY_NO,CUSTOMER_NO                             
32212           INTO :AT-COMPANY-NO,:AT-CUSTOMER-NO                     
32212           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
A37304          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
32212      END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50499802
MFA-TR*       SELECT COMPANY_NO,CUSTOMER_NO                             50499803
MFA-TR*         INTO :AT-COMPANY-NO,:AT-CUSTOMER-NO                     50499804
MFA-TR*         FROM CSS_ACCOUNT                                        50499805
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       50499806
MFA-TR*         WITH UR                                                 50499807
MFA-TR*    END-EXEC                                                     50499808

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

32212                                                                   
32212      MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE    
32212                                                                   
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
32212         NEXT SENTENCE                                             
32212      ELSE                                                         
32212         MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
32212         MOVE '7960'                  TO ACTIVE-PARAGRAPH          
32212         MOVE 'SELECT'                TO ABEND-FUNCTION            
32212         MOVE 'CSS_ACCOUNT'           TO TABLE-1                   
32212         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
A37666        MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
32212         PERFORM 9000-SEND-ERROR-RESULT                            
32212                                      THRU 9000-EXIT               
32212         PERFORM 9900-SQL-ERROR-ROUTINE                            
32212                                      THRU 9900-EXIT               
32212      END-IF.                                                      
32212  7960-EXIT.                                                       
32212      EXIT.                                                        
32212 ***************************************************************** 50499828
32212 *7970-GET-SEB-CUSTOMER-DETAILS.                                   50499829
32212 ***************************************************************** 50499830
32212  7970-GET-SEB-CUSTOMER-DETAILS.                                   
32212                                                                   
32212 *FOR SEB, USING INPUT ACCOUNT-NO FINDING THE CUSTOMER-NO,         50499860
32212 *         COMPANY-NO & GROUP-CODE.                                50499861
32212      EXEC SQL                                                     
32212         SELECT AT.COMPANY_NO,AT.CUSTOMER_NO,LR.REG_GROUP_CD       
32212          INTO :AT-COMPANY-NO,:AT-CUSTOMER-NO,:LR-REG-GROUP-CD     
32212          FROM CSS_ACCOUNT AT
                           WITH(READUNCOMMITTED), CSS_REG_PROFILE LR
                           WITH(READUNCOMMITTED)                  
A37666         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
32212          AND   AT.ACCOUNT_NO = LR.ACCOUNT_NO                      
T35434                                                           
32212      END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50499862
MFA-TR*       SELECT AT.COMPANY_NO,AT.CUSTOMER_NO,LR.REG_GROUP_CD       50499863
MFA-TR*        INTO :AT-COMPANY-NO,:AT-CUSTOMER-NO,:LR-REG-GROUP-CD     50499864
MFA-TR*        FROM CSS_ACCOUNT AT, CSS_REG_PROFILE LR                  50499865
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     50499866
MFA-TR*        AND   AT.ACCOUNT_NO = LR.ACCOUNT_NO                      50499867
MFA-TR*        WITH UR                                                  50499868
MFA-TR*    END-EXEC                                                     50499869

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

32212                                                                   
32212      MOVE SQLCODE                     TO  WS-ACTIVE-RETURN-CODE   
32212      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
32212           PERFORM 7960-GET-CSR-CUSTOMER-DETAILS                   
32212                                       THRU 7960-EXIT              
32212           MOVE SPACES                 TO WS-GROUP-CODE            
32212      ELSE                                                         
32212           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
32212                MOVE LR-REG-GROUP-CD   TO  WS-GROUP-CODE           
32212           ELSE                                                    
32212                MOVE PROGRAM-NAME      TO ABEND-PROGRAM            
32212                MOVE '7970'            TO ACTIVE-PARAGRAPH         
32212                MOVE 'SELECT'          TO ABEND-FUNCTION           
32212                MOVE 'CSS_ACCOUNT'     TO TABLE-1                  
32212                MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1          
A37666               MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1        
32212                PERFORM 9000-SEND-ERROR-RESULT                     
32212                                       THRU 9000-EXIT              
32212                PERFORM 9900-SQL-ERROR-ROUTINE                     
32212                                       THRU 9900-EXIT              
32212           END-IF                                                  
32212      END-IF.                                                      
32212  7970-EXIT.                                                       
32212      EXIT.                                                        
A37666*                                                                         
A37666******************************************************************50499300
A37666*7980-GET-CUST-HST-DETAILS.                                       50499400
A37666******************************************************************50499500
A37666*                                                                 50499700
A37666 7980-GET-CUST-HST-DETAILS.                                       
A37666*                                                                 50499700
A37666     EXEC SQL                                                     
A37666        SELECT CUSTOMER_NO                                        
A02036              ,COMPANY_NO                                         
A37666          INTO :HA-CUSTOMER-NO                                    
A02036              ,:HA-COMPANY-NO                                     
A37666          FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
A37666          WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       
A37666                                                           
A37666     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50499802
MFA-TR*       SELECT CUSTOMER_NO                                        50499803
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*         INTO :HA-CUSTOMER-NO                                    50499804
MFA-TR*             ,:HA-COMPANY-NO                                     50499804
MFA-TR*         FROM HST_ACCOUNT                                        50499805
MFA-TR*         WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       50499806
MFA-TR*         WITH UR                                                 50499807
MFA-TR*    END-EXEC                                                     50499808

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                 50499809
A37666     MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE    
A37666*                                                                 50499811
A37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37666         WHEN SUCCESSFUL-CALL                                     
A37666              CONTINUE                                            
A37666         WHEN NOT-FOUND                                           
A02036              MOVE ZEROS  TO HA-CUSTOMER-NO                       
A02036              MOVE SPACES TO HA-COMPANY-NO                        
A37666         WHEN OTHER                                               
A37666              MOVE PROGRAM-NAME      TO ABEND-PROGRAM             
A37666              MOVE '7980'            TO ACTIVE-PARAGRAPH          
A37666              MOVE 'SELECT'          TO ABEND-FUNCTION            
A37666              MOVE 'HST_ACCOUNT'     TO TABLE-1                   
A37666              MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1           
A37666              MOVE HA-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1         
A37666              PERFORM 9000-SEND-ERROR-RESULT                      
A37666                                           THRU 9000-EXIT         
A37666              PERFORM 9900-SQL-ERROR-ROUTINE                      
A37666                                           THRU 9900-EXIT         
A37666     END-EVALUATE.                                                
A37666*                                                                 50499825
A37666 7980-EXIT.                                                       
A37666     EXIT.                                                        
A37666*                                                                         
REARCH******************************************************************50502700
REARCH*8100-SEND-RESULT.                                                50502800
REARCH******************************************************************50502900
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     IF PARM-SUMMARY-TYPE = WS-C                                  
REARCH        EXEC SQL                                                  
REARCH             INSERT INTO #CSR02047_R1                      
REARCH             (                                                    
REARCH                  RETURN_CODE                                     
REARCH                 ,ACCOUNT_NO                                      
REARCH                 ,ACCOUNT_STATUS                                  
REARCH                 ,STATUS_REASON                                   
REARCH                 ,SERVICE_ADDRESS                                 
REARCH                 ,CITY_STATE                                      
REARCH                 ,ZIP_CODE                                        
REARCH                 ,CREDIT_GROUP                                    
REARCH                 ,CREDIT_STATUS                                   
REARCH                 ,TWELVE_MNTH_ARRERS                              
REARCH                 ,TWELVE_MONTH_DNP                                
REARCH                 ,TWELVE_MNTH_RET_CK                              
REARCH                 ,SECURITIES_TOTAL                                
REARCH                 ,DATE_LAST_PYMNT                                 
REARCH                 ,TOTAL_BILLED_BAL                                
REARCH                 ,CASH_ONLY_FL                                    
REARCH                 ,DPP_IND                                         
REARCH                 ,EPP_IND                                         
REARCH                 ,MED_CERT_IND                                    
REARCH                 ,BILL_CYCLE_CHG_IND                              
REARCH                 ,BANK_DRAFT_IND                                  
REARCH                 ,ON_DATE                                         
REARCH                 ,OFF_DATE                                        
REARCH                 ,ARCHIVES_EXIST                                  
REARCH                 ,GROUP_CD                                        
REARCH             )                                                    
REARCH             VALUES                                               
REARCH             (                                                    
REARCH                  :S-RETURN-CODE                                  
REARCH                 ,:S-ACCOUNT-NO                                   
REARCH                 ,:S-ACCOUNT-STATUS                               
REARCH                 ,:S-STATUS-REASON                                
REARCH                 ,:S-SERVICE-ADDRESS                              
REARCH                 ,:S-CITY-STATE                                   
REARCH                 ,:S-ZIP-CODE                                     
REARCH                 ,:S-CREDIT-GROUP                                 
REARCH                 ,:S-CREDIT-STATUS                                
REARCH                 ,:S-TWELVE-MONTH-ARREARS                         
REARCH                 ,:S-TWELVE-MONTH-DNP                             
REARCH                 ,:S-TWELVE-MONTH-RET-CHK                         
REARCH                 ,:S-SECURITIES-TOTAL                             
REARCH                 ,:S-DATE-LAST-PYMNT                              
REARCH                 ,:S-TOTAL-BILLED-BAL                             
REARCH                 ,:S-CASH-ONLY-FL                                 
REARCH                 ,:S-DPP-IND                                      
REARCH                 ,:S-EPP-IND                                      
REARCH                 ,:S-MED-CERT-IND                                 
REARCH                 ,:S-BILL-CYCLE-CHG-IND                           
REARCH                 ,:S-BANK-DRAFT-IND                               
REARCH                 ,:S-ON-DATE                                      
REARCH                 ,:S-OFF-DATE                                     
REARCH                 ,:S-ARCHIVES-EXIST                               
REARCH                 ,:S-GROUP-CD                                     
REARCH             )                                                    
REARCH             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                  50503300
MFA-TR*            INSERT INTO SESSION.CSR02047_R1                      50503400
MFA-TR*            (                                                    50503500
MFA-TR*                 RETURN_CODE                                     50503600
MFA-TR*                ,ACCOUNT_NO                                      50503700
MFA-TR*                ,ACCOUNT_STATUS                                  50503800
MFA-TR*                ,STATUS_REASON                                   50503900
MFA-TR*                ,SERVICE_ADDRESS                                 50504000
MFA-TR*                ,CITY_STATE                                      50504100
MFA-TR*                ,ZIP_CODE                                        50504200
MFA-TR*                ,CREDIT_GROUP                                    50504300
MFA-TR*                ,CREDIT_STATUS                                   50504400
MFA-TR*                ,TWELVE_MNTH_ARRERS                              50504500
MFA-TR*                ,TWELVE_MONTH_DNP                                50504600
MFA-TR*                ,TWELVE_MNTH_RET_CK                              50504700
MFA-TR*                ,SECURITIES_TOTAL                                50504800
MFA-TR*                ,DATE_LAST_PYMNT                                 50504900
MFA-TR*                ,TOTAL_BILLED_BAL                                50505000
MFA-TR*                ,CASH_ONLY_FL                                    50505100
MFA-TR*                ,DPP_IND                                         50505200
MFA-TR*                ,EPP_IND                                         50505300
MFA-TR*                ,MED_CERT_IND                                    50505400
MFA-TR*                ,BILL_CYCLE_CHG_IND                              50505500
MFA-TR*                ,BANK_DRAFT_IND                                  50505600
MFA-TR*                ,ON_DATE                                         50505700
MFA-TR*                ,OFF_DATE                                        50505800
MFA-TR*                ,ARCHIVES_EXIST                                  50505900
MFA-TR*                ,GROUP_CD                                        50506000
MFA-TR*            )                                                    50506100
MFA-TR*            VALUES                                               50506200
MFA-TR*            (                                                    50506300
MFA-TR*                 :S-RETURN-CODE                                  50506400
MFA-TR*                ,:S-ACCOUNT-NO                                   50506500
MFA-TR*                ,:S-ACCOUNT-STATUS                               50506600
MFA-TR*                ,:S-STATUS-REASON                                50506700
MFA-TR*                ,:S-SERVICE-ADDRESS                              50506800
MFA-TR*                ,:S-CITY-STATE                                   50506900
MFA-TR*                ,:S-ZIP-CODE                                     50507000
MFA-TR*                ,:S-CREDIT-GROUP                                 50507100
MFA-TR*                ,:S-CREDIT-STATUS                                50507200
MFA-TR*                ,:S-TWELVE-MONTH-ARREARS                         50507300
MFA-TR*                ,:S-TWELVE-MONTH-DNP                             50507400
MFA-TR*                ,:S-TWELVE-MONTH-RET-CHK                         50507500
MFA-TR*                ,:S-SECURITIES-TOTAL                             50507600
MFA-TR*                ,:S-DATE-LAST-PYMNT                              50507700
MFA-TR*                ,:S-TOTAL-BILLED-BAL                             50507800
MFA-TR*                ,:S-CASH-ONLY-FL                                 50507900
MFA-TR*                ,:S-DPP-IND                                      50508000
MFA-TR*                ,:S-EPP-IND                                      50508100
MFA-TR*                ,:S-MED-CERT-IND                                 50508200
MFA-TR*                ,:S-BILL-CYCLE-CHG-IND                           50508300
MFA-TR*                ,:S-BANK-DRAFT-IND                               50508400
MFA-TR*                ,:S-ON-DATE                                      50508500
MFA-TR*                ,:S-OFF-DATE                                     50508600
MFA-TR*                ,:S-ARCHIVES-EXIST                               50508700
MFA-TR*                ,:S-GROUP-CD                                     50508800
MFA-TR*            )                                                    50508900
MFA-TR*            END-EXEC                                             50509000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                             
A37666     ELSE                                                         
A37666        EXEC SQL                                                  
A37666             INSERT INTO #CSR02047_R1                      
A37666             (                                                    
A37666                  RETURN_CODE                                     
A37666                 ,ACCOUNT_NO                                      
A37666                 ,SERVICE_ADDRESS                                 
A37666                 ,ZIP_CODE                                        
A37666                 ,CITY_STATE                                      
A37666                 ,ON_DATE                                         
A37666                 ,OFF_DATE                                        
A37666                 ,FINAL_STATUS                                    
A37666                 ,STATUS_REASON                                   
A37666                 ,CREDIT_GROUP                                    
A37666                 ,AMOUNT_LAST_PYMNT                               
A37666                 ,DATE_LAST_PYMNT                                 
A37666                 ,ACCOUNT_BALANCE                                 
A37666                 ,DATE_ARCHIVED                                   
A37666                 ,DEP_STATUS                                      
A37666                 ,REF_STATUS                                      
A37666                 ,REG_GROUP_CD                                    
A37666                 ,GROUP_EFF_TS                                    
A37666                 ,SENIOR_FL                                       
A37666                 ,DIST_ACCT_NO                                    
A37666                 ,ORIGINATION_CD                                  
A37666                 ,OLD_ACCOUNT_NO                                  
A37666             )                                                    
A37666             VALUES                                               
A37666             (                                                    
A37666                  :S-RETURN-CODE                                  
A37666                 ,:S-ACCOUNT-NO                                   
A37666                 ,:S-SERVICE-ADDRESS                              
A37666                 ,:S-ZIP-CODE                                     
A37666                 ,:S-CITY-STATE                                   
A37666                 ,:S-ON-DATE                                      
A37666                 ,:S-OFF-DATE                                     
A37666                 ,:S-FINAL-STATUS                                 
A37666                 ,:S-STATUS-REASON                                
A37666                 ,:S-CREDIT-GROUP                                 
A37666                 ,:S-AMOUNT-LAST-PYMNT                            
A37666                 ,:S-DATE-LAST-PYMNT                              
A37666                 ,:S-ACCOUNT-BALANCE                              
A37666                 ,:S-DATE-ARCHIVED                                
A37666                 ,:S-DEP-STATUS                                   
A37666                 ,:S-REF-STATUS                                   
A37666                 ,:S-REG-GROUP-CD                                 
A37666                 ,:S-GROUP-EFF-TS                                 
A37666                 ,:S-SENIOR-FL                                    
A37666                 ,:S-DIST-ACCT-NO                                 
A37666                 ,:S-ORIGINATION-CD                               
A37666                 ,:S-OLD-ACCOUNT-NO                               
A37666             )                                                    
A37666            END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*       EXEC SQL                                                  50509200
MFA-TR*            INSERT INTO SESSION.CSR02047_R1                      50509300
MFA-TR*            (                                                    50509400
MFA-TR*                 RETURN_CODE                                     50509500
MFA-TR*                ,ACCOUNT_NO                                      50509600
MFA-TR*                ,SERVICE_ADDRESS                                 50509700
MFA-TR*                ,ZIP_CODE                                        50509800
MFA-TR*                ,CITY_STATE                                      50509900
MFA-TR*                ,ON_DATE                                         50510000
MFA-TR*                ,OFF_DATE                                        50510100
MFA-TR*                ,FINAL_STATUS                                    50510200
MFA-TR*                ,STATUS_REASON                                   50510300
MFA-TR*                ,CREDIT_GROUP                                    50510400
MFA-TR*                ,AMOUNT_LAST_PYMNT                               50510900
MFA-TR*                ,DATE_LAST_PYMNT                                 50511000
MFA-TR*                ,ACCOUNT_BALANCE                                 50511100
MFA-TR*                ,DATE_ARCHIVED                                   50511200
MFA-TR*                ,DEP_STATUS                                      50511200
MFA-TR*                ,REF_STATUS                                      50511200
MFA-TR*                ,REG_GROUP_CD                                    50511200
MFA-TR*                ,GROUP_EFF_TS                                            
MFA-TR*                ,SENIOR_FL                                               
MFA-TR*                ,DIST_ACCT_NO                                            
MFA-TR*                ,ORIGINATION_CD                                          
MFA-TR*                ,OLD_ACCOUNT_NO                                          
MFA-TR*            )                                                    50511300
MFA-TR*            VALUES                                               50511400
MFA-TR*            (                                                    50511500
MFA-TR*                 :S-RETURN-CODE                                  50511600
MFA-TR*                ,:S-ACCOUNT-NO                                   50511700
MFA-TR*                ,:S-SERVICE-ADDRESS                              50511800
MFA-TR*                ,:S-ZIP-CODE                                     50511900
MFA-TR*                ,:S-CITY-STATE                                   50512000
MFA-TR*                ,:S-ON-DATE                                      50512100
MFA-TR*                ,:S-OFF-DATE                                     50512200
MFA-TR*                ,:S-FINAL-STATUS                                 50512300
MFA-TR*                ,:S-STATUS-REASON                                50512400
MFA-TR*                ,:S-CREDIT-GROUP                                 50512500
MFA-TR*                ,:S-AMOUNT-LAST-PYMNT                            50513000
MFA-TR*                ,:S-DATE-LAST-PYMNT                              50513100
MFA-TR*                ,:S-ACCOUNT-BALANCE                              50513200
MFA-TR*                ,:S-DATE-ARCHIVED                                50513300
MFA-TR*                ,:S-DEP-STATUS                                   50513300
MFA-TR*                ,:S-REF-STATUS                                   50513300
MFA-TR*                ,:S-REG-GROUP-CD                                 50513300
MFA-TR*                ,:S-GROUP-EFF-TS                                         
MFA-TR*                ,:S-SENIOR-FL                                            
MFA-TR*                ,:S-DIST-ACCT-NO                                         
MFA-TR*                ,:S-ORIGINATION-CD                                       
MFA-TR*                ,:S-OLD-ACCOUNT-NO                                       
MFA-TR*            )                                                    50513400
MFA-TR*           END-EXEC                                              50513500
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                              
A37666     END-IF.                                                      
REARCH*                                                                 50513700
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                 50513900
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02047_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                 50515400
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 50515700
T19557 9500-CALL-CPD00068.                                              
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1                  TO S-RETURN-CODE,            
REARCH                                        WS-ACTIVE-RETURN-CODE     
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
      ******************************************************************50519500
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     50519600
      ******************************************************************50519700
REARCH     EXEC SQL                                                     50520100
REARCH        INCLUDE CPDSP300                                          50520200
REARCH     END-EXEC.                                                    50520300
                                                                        
      ******************************************************************50520500
      *       END PROGRAM COPYLIB                                      *50520600
      ******************************************************************50520700
REARCH     EXEC SQL                                                     50520900
REARCH        INCLUDE CPD00320                                          50521000
REARCH     END-EXEC.                                                    50521100
                                                                        
