       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR02039.                                      
COB303 DATE-WRITTEN.     OCT 31, 2005.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE PAYMENT HISTORY FROM               *        
      *  CSS_AR_TRANS_HIST.                                            *        
      *                                                                *        
      *  THIS RPC WAS A PART OF CSR02038 BUT WAS BROKEN APART FROM     *        
      *  BECAUSE THE USERS WANTED THE DATAWINDOWS SORTED DIFFERENTLY ON*        
      *  PANEL121/130.  USED IN PANELS 121 AND 130.  THE DATA WINDOW   *        
      *  IS DW_PAYMENTS.                                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    ID #       COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
REARCH*  07/22/03  MN90523    RPC CONVERTED TO COBOL SP                *        
C32122*  10/31/05  RB19957    CREATED.                                 *        
A37342*  03/14/09  SV95326    IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*                       POSITIONING FOR GLOBAL TEMP TABLES       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02039'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02039 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLDA                                                     
           END-EXEC.                                                            
                                                                        
      *-------< CSS_MODEL_SQL >                                                 
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *-------< CSS_AR_TRANS_HIST >                                             
           EXEC SQL                                                             
              INCLUDE  TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH 01  PROGRAM-NAME                PIC X(08) VALUE 'CSR02039'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                  VALUE 'SESSION.CSR02039_R1'.    
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH*                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
REARCH     05  S-AR-AMT-ORIG-ENTERED     PIC X(12)   VALUE SPACE.       
REARCH     05  S-AR-DATE-TRANS           PIC X(10)   VALUE SPACE.       
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
REARCH     05  WS-SQLSTATE               PIC X(05) VALUE '     '.       
           05  WS-ACCOUNT-NUM            PIC X(13).                     
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
                                         PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-SEND-CODE              PIC X(2) OCCURS 5.             
           05  WS-PAYMENT-RETURN-CODE    PIC S9(9) COMP VALUE 0.        
           05  WS-DATE-HOLD              PIC X(10) VALUE SPACES.        
           05  WS-DATE-HOLD-USA          PIC X(10) VALUE SPACES.        
           05  WS-RETRIEVED-ALL          PIC X(1) VALUE 'N'.            
           05  WS-AR-AMT-ORIG-ENTERED-CMP PIC S9(9)V99 COMP-3 VALUE +0. 
           05  WS-AR-AMT-ORIG-ENTERED    PIC  9(9)V99 VALUE ZERO.       
           05  WS-AR-AMT-ORIG-ENTERED-TXT REDEFINES                     
                                          WS-AR-AMT-ORIG-ENTERED.       
               10  WS-AMT-1              PIC X(9).                      
               10  WS-AMT-2              PIC X(2).                      
           05  WS-AR-AMT-ORIG-ENTERED-RET.                              
               10  WS-AMT-RET-1          PIC X(9).                      
               10  WS-AMT-POINT          PIC X(1) VALUE '.'.            
               10  WS-AMT-RET-2          PIC X(2).                      
           05  WS-AR-DATE-NI             PIC S9(4) COMP.                
           05  WS-AR-TRANS-HIST-SEQ-NO   PIC S9(4) COMP.                
           05  WS-CSR-USERID             PIC X(07) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *--- < CURSOR FOR PAYMENTS >                                              
           EXEC SQL DECLARE PAYMENTS-CURSOR CURSOR FOR                  
             SELECT AMT_ORIG_ENTERED                                    
                   ,CIS.CHAR2$DATE(DATE_TRANS,'USA')                            
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
               FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                     
                AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE                 
                AND RECORD_ONLY_FL <> :AR-RECORD-ONLY-FL                
                ORDER BY TRANS_HIST_SEQ_NO DESC                         
              FOR READ ONLY                                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PAYMENTS-CURSOR CURSOR FOR                          
MFA-TR*      SELECT AMT_ORIG_ENTERED                                            
MFA-TR*            ,CHAR(DATE_TRANS,USA)                                        
MFA-TR*            ,TRANS_HIST_SEQ_NO                                           
MFA-TR*        FROM CSS_AR_TRANS_HIST                                           
MFA-TR*       WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                             
MFA-TR*         AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE                         
MFA-TR*         AND RECORD_ONLY_FL <> :AR-RECORD-ONLY-FL                        
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*       FOR READ ONLY                                                     
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NUM              PIC X(13).                     
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NUM.                      
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 0100A-DECLARE-GTT                                    *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
A37342         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT                                                   
REARCH              RETURN_CODE                                         
REARCH             ,LTRIM(RTRIM(AR_AMT_ORIG_ENTRD)) AS AR_AMT_ORIG_ENTRD       
REARCH             ,AR_DATE_TRANS                                       
REARCH         FROM                                                     
REARCH             #CSR02039_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STRIP(AR_AMT_ORIG_ENTRD) AS AR_AMT_ORIG_ENTRD               
MFA-TR*            ,AR_DATE_TRANS                                               
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02039_R1                                          
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*     CALLS 9000-SEND-ERROR-RESULT                               *        
REARCH*           9900-SQL-ERROR-ROUTINE                               *        
REARCH*                                                                *        
REARCH*     CALLED FROM 0100-INITIALIZE                                *        
REARCH*                                                                *        
REARCH*     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02039_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02039_R1
              (                                                        
REARCH              RETURN_CODE            INT                      
REARCH             ,AR_AMT_ORIG_ENTRD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
REARCH             ,AR_DATE_TRANS CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH*  CHECK TO SEE IF THIS TEMP TABLE ALREADY EXISTS.  '42710'               
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH         OR WS-SQLSTATE = '42710'                                 
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
REARCH            MOVE '0100A'           TO ACTIVE-PARAGRAPH            
REARCH            MOVE 'DECLARE GTT'     TO ABEND-FUNCTION              
REARCH            MOVE SPACES            TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH            MOVE 'CSR02039_R1'     TO TABLE-1                     
REARCH            MOVE SPACES            TO TABLE-ELEMENT-1             
REARCH            MOVE SPACES            TO HOSTVAR-ELEMENT-1           
                  MOVE SQLCODE           TO ABEND-SQLCODE               
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                   THRU  9900-EXIT                
REARCH         END-IF.                                                  
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
           MOVE PARM-ACCOUNT-NUM      TO WS-ACCOUNT-NUM.                
           MOVE WS-ACCOUNT-DEC        TO AR-ACCOUNT-NO.                 
           MOVE 'P'                   TO AR-CODE-TRAN-TYPE.             
           MOVE 'Y'                   TO AR-RECORD-ONLY-FL.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2200-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS       7010-OPEN-PAYMENTS-CURSOR                      *        
      *                 2310-PROCESS-FETCH-ALL                         *        
      *                 7210-CLOSE-PAYMENTS-CURSOR                     *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
      *----< OPEN CURSORS >                                                     
              PERFORM 7010-OPEN-PAYMENTS-CURSOR  THRU 7010-EXIT.        
                                                                        
      *----< DO ALL THE FETCHING AND CARRYING >                                 
              PERFORM 2310-PROCESS-FETCH-ALL     THRU 2310-EXIT         
                UNTIL WS-RETRIEVED-ALL = WS-YES.                        
                                                                        
      *----< CLOSE CURSORS >                                                    
              PERFORM 7210-CLOSE-PAYMENTS-CURSOR THRU 7210-EXIT.        
                                                                        
      *--------< IF NOTHING HAS BEEN FOUND, THEN SO FAR NOTHING HAS >           
      *--------< BEEN SENT BACK. SEND BACK A SUCCESSFUL MESSAGE     >           
              IF CTR-ROWS = 0                                           
                 MOVE ZERO                TO S-RETURN-CODE              
                 MOVE SPACES              TO S-AR-DATE-TRANS            
                 MOVE SPACES              TO S-AR-AMT-ORIG-ENTERED      
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF.                                                   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-PROCESS-FETCH-ALL                                         *        
      *     CALLS       7110-FETCH-PAYMENTS                            *        
      *                 2320-POPULATE-RETURN-ROW                       *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES EVERYTHING                                         *        
      ******************************************************************        
       2310-PROCESS-FETCH-ALL.                                          
      *-----< FETCH PAYMENTS IF THERE ARE STILL SOME TO FETCH >                 
           PERFORM 7110-FETCH-PAYMENTS THRU 7110-EXIT.                  
                                                                        
           IF  WS-PAYMENT-RETURN-CODE = NOT-FOUND                       
              MOVE WS-YES TO WS-RETRIEVED-ALL                           
           ELSE                                                         
              PERFORM 2320-POPULATE-RETURN-ROW THRU 2320-EXIT           
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-POPULATE-RETURN-ROW                                       *        
      *     CALLED FROM 2310-PROCESS-FETCH-ALL                         *        
      *                                                                *        
      *     POPULATES THE RETURN ROW                                   *        
      ******************************************************************        
       2320-POPULATE-RETURN-ROW.                                        
           IF WS-AR-DATE-NI < 0                                         
               MOVE SPACES TO S-AR-DATE-TRANS                           
               MOVE SPACES TO S-AR-AMT-ORIG-ENTERED                     
           ELSE                                                         
               MOVE 'AR-DATE-TRANS'            TO TABLE-ELEMENT-1       
               MOVE WS-DATE-HOLD-USA           TO S-AR-DATE-TRANS       
               MOVE WS-AR-AMT-ORIG-ENTERED-CMP TO WS-AR-AMT-ORIG-ENTERED
               MOVE WS-AMT-1                   TO WS-AMT-RET-1          
               MOVE WS-AMT-2                   TO WS-AMT-RET-2          
               MOVE WS-AR-AMT-ORIG-ENTERED-RET TO S-AR-AMT-ORIG-ENTERED 
               INSPECT S-AR-AMT-ORIG-ENTERED                            
                     REPLACING LEADING '0' BY SPACES                    
           END-IF.                                                      
      *                                                                         
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-OPEN-PAYMENTS-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
       7010-OPEN-PAYMENTS-CURSOR.                                       
           MOVE '7010'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN PAYMENTS-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'RECORD_ONLY_FL'           TO TABLE-ELEMENT-3        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AR-CODE-TRAN-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE AR-RECORD-ONLY-FL          TO HOSTVAR-ELEMENT-3      
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-PAYMENTS                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-FETCH-ALL                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
       7110-FETCH-PAYMENTS.                                             
           MOVE '7110'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  PAYMENTS-CURSOR                                    
               INTO :WS-AR-AMT-ORIG-ENTERED-CMP,                        
                    :WS-DATE-HOLD-USA :WS-AR-DATE-NI,                    
                    :AR-TRANS-HIST-SEQ-NO :WS-AR-TRANS-HIST-SEQ-NO       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-PAYMENT-RETURN-CODE.                      
                                                                        
           IF WS-PAYMENT-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'RECORD_ONLY_FL'           TO TABLE-ELEMENT-3        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AR-CODE-TRAN-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE AR-RECORD-ONLY-FL          TO HOSTVAR-ELEMENT-3      
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-CLOSE-PAYMENTS-CURSOR                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7210-CLOSE-PAYMENTS-CURSOR.                                      
           MOVE '7210'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  PAYMENTS-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'RECORD_ONLY_FL'           TO TABLE-ELEMENT-3        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AR-CODE-TRAN-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE AR-RECORD-ONLY-FL          TO HOSTVAR-ELEMENT-3      
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                 2310-PROCESS-FETCH-ALL                         *        
      *                                                                *        
      *     SENDS THE RESULT                                           *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
REARCH         INSERT INTO #CSR02039_R1                          
REARCH         (    RETURN_CODE                                         
REARCH             ,AR_AMT_ORIG_ENTRD                                   
REARCH             ,AR_DATE_TRANS                                       
REARCH         )                                                        
REARCH         VALUES                                                   
REARCH         (   :S-RETURN-CODE                                       
REARCH            ,:S-AR-AMT-ORIG-ENTERED                               
REARCH            ,:S-AR-DATE-TRANS                                     
REARCH         )                                                        
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02039_R1                                  
MFA-TR*        (    RETURN_CODE                                                 
MFA-TR*            ,AR_AMT_ORIG_ENTRD                                           
MFA-TR*            ,AR_DATE_TRANS                                               
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (   :S-RETURN-CODE                                               
MFA-TR*           ,:S-AR-AMT-ORIG-ENTERED                                       
MFA-TR*           ,:S-AR-DATE-TRANS                                             
MFA-TR*        )                                                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS                                        
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02039_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE SQLCODE              TO ABEND-SQLCODE               
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
