       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR02038.                                      
COB303 DATE-WRITTEN.     FEB 21, 1995.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ALERT COMMENTS FROM CSS_CUST_ALERT,*        
      *  THE PAYMENT ARRANGEMENTS FROM CSS_DFA_ACCT.                   *        
      *  ONLY LOOKS FOR DFA IF THE DFA PARAMETER IS A.                 *        
      *                                                                *        
      *  THIS RPC IS POPULATING TWO   GRID STYLE DATAWINDOWS ON        *        
      *  PANEL121. THIS IS TO REDUCE THE NUMBER OF RPC CALLS BY THE    *        
      *  PROGRAM TO INCREASE RETRIEVAL TIME. THE DOWNSIDE OF THIS IS   *        
      *  THAT SPACES HAVE TO BE PASSED BACK WHEN, FOR EXAMPLE, THERE   *        
      *  ARE NO MORE MESSAGES BUT THERE ARE PAYMENTS AND PAYMENT       *        
      *  ARRANGEMENTS STILL TO BE SENT BACK. THE MESSAGES WILL BE      *        
      *  PASSED BACK AS BLANK SPACES AND SO WILL APPEAR AS EMPTY ROWS  *        
      *  ON THE DATAWINDOW. THIS IS THE REASON THAT ALL RETURN FIELDS  *        
      *  ARE DEFINED AS TEXT. SOME TEXT MANIPULATION IS NEEDED TO      *        
      *  REMOVE LEADING TEXT ZEROES FROM NUMERIC FIELDS THAT HAVE BEEN *        
      *  CONVERTED TO TEXT.                                            *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/21/95    GC       CREATED.                                 *        
      *  06/22/95    GC       ADDED CODE TO 2200 TO PREVENT CRASH WHEN *        
      *                       NO ROWS HAVE BEEN SENT BACK. THIS IS     *        
      *                       PERFECTLY VALID. NO TPR.                 *        
      *  06/23/95    GC       CHANGED 2320 TO HANDLE NULL INDICATORS   *        
      *                       CORRECTLY. 7502 SHOULD NOT BE CALLED IF  *        
      *                       SPACES HAVE BEEN MOVED INTO THE DATES.   *        
      *                       NULL INDICATORS WERE ADDED TO PARAS 7130 *        
      *                       AND 7140. SOME OF THE SQL ERROR ROUTINES *        
      *                       WERE CORRECTED. NO TPR.                  *        
      *  09/12/96    WMG      TPR 5408 - RETURN THE AR-DATE-TRANS      *        
      *                       INSTEAD OF THE AR-DATE-ORIG-PYMT.        *        
      *  12/18/96    PP       TPR 8125 - CHANGED THE PAYMENT-CURSOR    *        
      *                       DATE ORDER-BY DESCENDING.                *        
      *                                                                *        
      *  02/12/97    CSS      TPR9091 - STA AND DPP CURSORS HAVE BEEN  *        
      *                       CHANGED TO ORDER BY DESCENDING ON DATE   *        
      *                                                                *        
      *  02/17/97    MAC      TPR9168 - CODE HAS BEEN ADDED TO DISPLAY *        
      *                       MEDICAL CERTIFICATE INFORMATION.         *        
      *                                                                *        
      *  03/19/97    MJG      TPR9703 AND TPR9684.  CHANGED THE PAY-   *        
      *                       MENTS CURSOR TO ONLY RETURN PAYMNETS IF  *        
      *                       THE FOR_RECORDS_ONLY FLAG = 'N'. ALSO    *        
      *                       LIMITED THE MESSAGES THAT ARE RETURNED   *        
      *                       BASED ON THE REQUIREMENTS STATE IN 9684. *        
T12583*  08/18/97    MJG      CHANGED PROGRAM TO RETURN ALL MEDICAL    *        
T12583*                       CERTIFICATES INSTEAD OF JUST THE ACTIVE  *        
T12583*                       ONE.  S261 ALSO NEEDED TO CHANGE SO I    *        
T12583*                       COULD JOIN MAINTENANCE JRNL AND THE      *        
T12583*                       CUST_ALERT TABLE.                        *        
      *                                                                *        
T14170* 01/06/98    EMS       REMOVED THE JOIN BETWEEN CSS_DFA_ACCT    *        
      *                       AND CSS_USER_PROFILE, CSS_STA_SUMMARY    *        
      *                       AND CSS_USER_PROFILE, AND THE MEDICAL    *        
      *                       CERTIFICATE CURSOR AND CSS_USER_PROFILE. *        
      *                       IF THE ENTRY OF THE USER DOES NOT EXIST  *        
      *                       IN CSS_USER_PROFILE, ACTUAL ID IS        *        
      *                       DISPLAYED INSTEAD OF THE FIRST NAME      *        
      *                       AND LAST NAME OF THE USER.               *        
T14509* 01/26/98     BAB      ORDER BY THE TRANS_HIST_SEQ_NO AS WELL.  *        
      *                                                                *        
T16570* 05/26/98    EMS       REMOVED THE LAST NAME AND FIRST NAME     *        
      *                       FROM THE FETCH OF MED-CERT-ID-CURSOR.    *        
CBSI  *  07/24/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19353*  03/09/99    SHF      MODIFIED PARA 7000 TO NOT WRITE TO MC05  *        
      *                       WHEN A +100 (NOT FOUND) IS RETURNED.     *        
C25433*  02/19/02    SFH      PANEL 121 WILL NOW DISPLAY A U WHEN THE  *        
C25433*                       COMPLIANCE INDICATOR FOR A COMPLETED STA *        
C25433*                       HAS SPACES.                              *        
REARCH*  07/22/03    MN90523  RPC CONVERTED TO COBOL SP                *        
C32122*  03/15/05    RB19957  STA AND DPP CURSORS HAVE BEEN CHANGED TO *        
      *                       ORDER BY ASCENDING TEMP SORT_KEY AND     *        
      *                       DATE + NO SEPARATION BY ARRANGEMENT TYPE.*        
      *                       TEMP SORT_KEY IS A TEMP COLUMN WHERE IF  *        
      *                       ACTIVE MEDICAL CERT SORT_KEY = 1 ELSE    *        
      *                       MED CERT & STATUS = SORT_KEY.            *        
      *                       DFA_STATUS = A THEN SORT_KEY = 2 ELSE 3. *        
      *                       IF NO DFA OR STA THEN SORT-KEY = 4.      *        
      *                       IF NO DFA, STA, OR AR PYMT THEN SORT=KEY *        
      *                       = 5.  NEW COLUMN SORT DATE IS FIRST DFA  *        
      *                       OR STA DATE THEN AR DATE FINALLY NULL.   *        
T32122*  03/16/05    RB19957  WHEN TESTING C32122, NOT GETTING CORRECT *        
      *                       RESULTS BECAUSE USER NAMES WHERE NOT IN  *        
      *                       DEVL - MOVED STATEMENTS OUTSIDE OF "IF"  *        
      *                       ALSO NOW MATCHES THE DFA PIECE.          *        
T32122*  06/06/05  RICK BLACK CHANGED BACK TO AR-TRANS-DATE AS BEING   *        
      *                       PRIMARY SORT FIELD.                      *        
T32122*  11/07/05  RICK BLACK REMOVED AR DATA AND PUT IT IN NEW SP     *        
      *                       CALLED CSR02039.                         *        
T33531*  12/20/05   JC91900   CHANGES RELATED WITH DB2 V8 CONVERSION.  *        
T34097*  06/27/06  RICK BLACK REMOVED CODE THAT IS COMMENTED OUT AND   *        
      *                       FINE TUNE SQL CODE.                      *        
      *                       ALSO CHANGED THE SORT ORDER PER USER     *        
A37342*  03/12/09   SP94986   IMPROVE PERFORMANCE - ADDING ROWSET      *        
      *                       POSITIONING FOR GLOBAL TEMP TABLES &     *        
      *                       WITH UR CHANGES TO CURSORS.              *        
P00726*  05/20/13   GOKUL     CREDIT ARRANGEMENT RELEASE 1 CHANGES TO  *        
      *                       SUPPORT CDD OPTION.                      *        
P0726C*  07/16/14   SS42021   CREDIT ARRANGEMENT RELEASE 4 CHANGES TO  *        
      *                       SUPPORT STA AND STA AFTER IN NEW STRUC.  *        
P00948*  07/08/16   VENKAT.P  LEAST AMT TO PAY CHANGES.                *        
ACT348*  11/21/16   TP7R341   REMOVE STA DETAIL & SUMMARY TABLES       *        
      ******************************************************************        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02038'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02038 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLDA                                                     
           END-EXEC.                                                            
                                                                        
      *-------< CSS_CUST_MISC_INFO                                              
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< CSS_ACCOUNT >                                                   
           EXEC SQL                                                             
              INCLUDE  TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *-------< CSS_DFA_ACCT >                                                  
           EXEC SQL                                                             
              INCLUDE  TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
      *-------< CSS_CUST_ALERT >                                                
           EXEC SQL                                                             
              INCLUDE  TBCSTALT                                                 
           END-EXEC.                                                            
                                                                        
      *-------< CSS_USER_PROFILE >                                              
           EXEC SQL                                                             
              INCLUDE  TBUSRPRF                                                 
           END-EXEC.                                                            
                                                                        
      *--------< CSS_MNT_TRANS_HIST                                             
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
P0726C******************************************************************06330000
P0726C* CSS_CRED_ARNGMENT  - X1                                        *06340000
P0726C******************************************************************06350000
P0726C*                                                                         
P0726C     EXEC SQL                                                             
P0726C        INCLUDE TBCRARNG                                                  
P0726C     END-EXEC.                                                            
      *                                                                         
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                  VALUE 'SESSION.CSR02038_R1'.    
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH*                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
           05  RS-MESSAGE                PIC X(2)    VALUE SPACE.       
           05  RS-PA-DATE                PIC X(10)   VALUE SPACE.       
           05  RS-PA-USER-ID             PIC X(23)   VALUE SPACE.       
           05  RS-PA-TYPE                PIC X(1)    VALUE SPACE.       
           05  RS-PA-STATUS              PIC X(1)    VALUE SPACE.       
           05  RS-PA-COMPLIANCE          PIC X(12)   VALUE SPACE.       
C32122     05  RS-PA-SORT-KEY            PIC X(1)    VALUE SPACE.       
C32122     05  RS-PA-SORT-DATE           PIC X(10)   VALUE SPACE.       
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
REARCH     05  S-MESSAGE                 PIC X(2)    VALUE SPACE.       
REARCH     05  S-PA-DATE                 PIC X(10)   VALUE SPACE.       
REARCH     05  S-PA-USER-ID              PIC X(23)   VALUE SPACE.       
REARCH     05  S-PA-TYPE                 PIC X(1)    VALUE SPACE.       
REARCH     05  S-PA-STATUS               PIC X(1)    VALUE SPACE.       
REARCH     05  S-PA-COMPLIANCE           PIC X(12)   VALUE SPACE.       
C32122     05  S-PA-SORT-KEY             PIC X(1)    VALUE SPACE.       
C32122     05  S-PA-SORT-DATE            PIC X(10)   VALUE SPACE.       
REARCH*                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
REARCH     05  WS-SQLSTATE               PIC X(05) VALUE '     '.       
           05  WS-ACCOUNT-NUM            PIC X(13).                     
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
                                         PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-USER-ID                PIC X(07)   VALUE SPACE.       
           05  WS-COMPLIANCE             PIC X(12)   VALUE SPACE.       
           05  WS-COMPLIANCE-BRKDWN REDEFINES WS-COMPLIANCE             
                                         PIC X(1) OCCURS 12.            
           05  WS-CNT                    PIC S9(4) COMP VALUE 1.        
           05  WS-MSG-CNT                PIC S9(4) COMP VALUE 0.        
           05  WS-MSG-IDX                PIC S9(4) COMP VALUE 1.        
           05  WS-SEND-CODE              PIC X(2) OCCURS 5.             
           05  WS-DFA-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
T12583     05  WS-MED-CERT-DAYS          PIC S9(9) COMP VALUE 0.        
T34097     05  WS-DATE-DFA-USA           PIC X(10) VALUE SPACES.        
           05  WS-RETRIEVED-ALL          PIC X(1) VALUE 'N'.            
T14509     05  WS-AR-TRANS-HIST-SEQ-NO   PIC S9(4) COMP.                
           05  WS-USER-NAME              PIC X(23).                     
           05  WS-MED-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
T14170     05  WS-CSR-USERID             PIC X(07) VALUE SPACES.        
C32122     05  WS-SORT-KEY               PIC X(01) VALUE SPACES.        
C32122     05  WS-SORT-DATE              PIC X(10) VALUE SPACES.        
T33531     05  WS-SUB                    PIC S9(8) COMP VALUE ZERO.     
T33531     05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WS-FROM.                                                     
           05  WS-FROM-X               OCCURS 21 TIMES PIC X.           
                                                                        
T33531 01  WS-LITERALS.                                                 
           05  WS-STA                    PIC X(1) VALUE 'C'.            
           05  WS-A                      PIC X(1) VALUE 'A'.            
           05  WS-C                      PIC X(1) VALUE 'C'.            
           05  WS-P                      PIC X(1) VALUE 'P'.            
           05  WS-M                      PIC X(1) VALUE 'M'.            
           05  WS-MC                     PIC X(2) VALUE 'MC'.           
           05  WS-BE                     PIC X(2) VALUE 'BE'.           
           05  WS-SN                     PIC X(2) VALUE 'SN'.           
           05  WS-R                      PIC X(1) VALUE 'R'.            
           05  WS-F                      PIC X(2) VALUE 'F'.            
           05  WS-WC                     PIC X(2) VALUE 'WC'.           
T33531     05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02038'.    
T33531     05  WS-YES                    PIC X(01) VALUE 'Y'.           
T33531     05  WS-NO                     PIC X(01) VALUE 'N'.           
T33531     05  WS-ACTIVE-CODE            PIC X(01) VALUE 'A'.           
T33531     05  WS-UNKNOWN                PIC X(01) VALUE 'U'.           
T33531     05  CN-DELIMITER              PIC X VALUE ';'.               
                                                                        
T33531 01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
T33531     05  WS-SEND-MED-CERT          PIC X(01) VALUE 'N'.           
T33531         88 MED-CERT-NOT-SENT                VALUE 'N'.           
P00726     05  WS-CALLING-CHANNEL        PIC X(01) VALUE 'N'.           
P00726         88 IVR-CALL                         VALUE 'Y'.           
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *----< CURSOR FOR MEDICAL CERTIFICATE ID                                  
           EXEC SQL DECLARE MED-CERT-ID-CURSOR CURSOR FOR               
T34097        SELECT COALESCE(CIS.CHAR2$DATE(
           CA.DATE_ALERT,'USA'),'01/01/1950'),
                     MH.USER_ID,                                        
                     CIS.DAYS(CA.DATE_EXPIRE) - CIS.DAYS(
           CAST(SYSDATETIMEOFFSET() AS DATE))          
                FROM CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED),               
T12583               CSS_CUST_ALERT     CA WITH(READUNCOMMITTED)                
T34097         WHERE CA.ACCOUNT_NO        = :CA-ACCOUNT-NO              
T34097           AND MH.ACCOUNT_NO        = :CA-ACCOUNT-NO              
T34097           AND MH.APPL_PROGRAM_ID   = 'PANEL269'                  
T12583           AND MH.TRANS_HIST_SEQ_NO =  CA.CUST_ALERT_SEQ_NO       
               ORDER BY MH.TRANS_HIST_SEQ_NO DESC                       
T34097         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE MED-CERT-ID-CURSOR CURSOR FOR                       
MFA-TR*       SELECT IFNULL(CHAR(DATE(CA.DATE_ALERT),USA),'01/01/1950'),        
MFA-TR*              MH.USER_ID,                                                
MFA-TR*              DAYS(CA.DATE_EXPIRE) - DAYS(CURRENT DATE)                  
MFA-TR*         FROM CSS_MNT_TRANS_HIST MH,                                     
MFA-TR*              CSS_CUST_ALERT     CA                                      
MFA-TR*        WHERE CA.ACCOUNT_NO        = :CA-ACCOUNT-NO                      
MFA-TR*          AND MH.ACCOUNT_NO        = :CA-ACCOUNT-NO                      
MFA-TR*          AND MH.APPL_PROGRAM_ID   = 'PANEL269'                          
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO =  CA.CUST_ALERT_SEQ_NO               
MFA-TR*        ORDER BY MH.TRANS_HIST_SEQ_NO DESC                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *--- < CURSOR FOR DFA PAYMENT ARRANGEMENTS >                              
           EXEC SQL DECLARE DFA-CURSOR CURSOR FOR                       
T34097       SELECT COALESCE(CAST(DA.DATE_OF_AGREE
            AS CHAR(10)),'          '),        
T34097           COALESCE(CIS.CHAR2$DATE(
           DA.DATE_OF_AGREE,'USA'),'          '), 
                    DA.CSR_USERID      ,                                
                    DA.CODE_DFA_TYPE   ,                                
                    DA.CODE_DFA_STATUS ,                                
                    DA.CODE_COMPLY_HIST                                 
               FROM                                                     
                    CSS_DFA_ACCT     DA WITH(READUNCOMMITTED)                   
T34097        WHERE DA.ACCOUNT_NO = :DA-ACCOUNT-NO                      
T34097         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE DFA-CURSOR CURSOR FOR                               
MFA-TR*      SELECT IFNULL(CHAR(DA.DATE_OF_AGREE),'          '),                
MFA-TR*          IFNULL(CHAR(DATE(DA.DATE_OF_AGREE),USA),'          '),         
MFA-TR*             DA.CSR_USERID      ,                                        
MFA-TR*             DA.CODE_DFA_TYPE   ,                                        
MFA-TR*             DA.CODE_DFA_STATUS ,                                        
MFA-TR*             DA.CODE_COMPLY_HIST                                         
MFA-TR*        FROM                                                             
MFA-TR*             CSS_DFA_ACCT     DA                                         
MFA-TR*       WHERE DA.ACCOUNT_NO = :DA-ACCOUNT-NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NUM              PIC X(13).                     
REARCH 01  PARM-DFA-INDICATOR            PIC X(01).                     
REARCH 01  PARM-STA-INDICATOR            PIC X(01).                     
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NUM                       
REARCH                          ,PARM-DFA-INDICATOR                     
REARCH                          ,PARM-STA-INDICATOR.                    
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
T33531     INITIALIZE GENERAL-WORKING-STORAGE.                          
T33531     INITIALIZE TDS-RETURN-FIELDS.                                
T33531     INITIALIZE CSRERLOG-P.                                       
T33531     INITIALIZE WS-FROM.                                          
                                                                        
T33531     MOVE 'Y'                          TO SEND-DONE-SW.           
T33531     MOVE 'N'                          TO WS-SEND-MED-CERT        
T33531                                          WS-RETRIEVED-ALL.       
P00726     IF PARM-STA-INDICATOR = 'I'                                  
P00726        SET IVR-CALL                   TO TRUE                    
P00726        MOVE 'A'                       TO PARM-STA-INDICATOR      
P00726     END-IF.                                                      
                                                                        
T33531     MOVE 1                            TO WS-CNT                  
T33531                                          WS-MSG-IDX.             
                                                                        
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
A37342         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT                                                   
REARCH              RETURN_CODE                                         
REARCH             ,MESSAGE                                             
REARCH             ,PA_DATE                                             
REARCH             ,LTRIM(RTRIM(PA_USER_ID))        AS PA_USER_ID              
REARCH             ,PA_TYPE                                             
REARCH             ,PA_STATUS                                           
REARCH             ,LTRIM(RTRIM(PA_COMPLIANCE))     AS PA_COMPLIANCE           
C32122             ,PA_SORT_KEY                                         
C32122             ,CIS.CHAR2$DATE(PA_S_DATE,'USA')      AS PA_SORT_DATE        
REARCH         FROM                                                     
REARCH             #CSR02038_R1                                  
C32122          ORDER BY PA_SORT_KEY ASC                                
C34097                  ,PA_S_DATE DESC                                 
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,MESSAGE                                                     
MFA-TR*            ,PA_DATE                                                     
MFA-TR*            ,STRIP(PA_USER_ID)        AS PA_USER_ID                      
MFA-TR*            ,PA_TYPE                                                     
MFA-TR*            ,PA_STATUS                                                   
MFA-TR*            ,STRIP(PA_COMPLIANCE)     AS PA_COMPLIANCE                   
MFA-TR*            ,PA_SORT_KEY                                                 
MFA-TR*            ,CHAR(PA_S_DATE,USA)      AS PA_SORT_DATE                    
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02038_R1                                          
MFA-TR*         ORDER BY PA_SORT_KEY ASC                                        
MFA-TR*                 ,PA_S_DATE DESC                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  0100A-DECLARE-GTT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02038_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02038_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02038_R1
              (                                                        
REARCH              RETURN_CODE            INT                      
REARCH             ,MESSAGE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,PA_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,PA_USER_ID CHAR(23)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,PA_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,PA_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,PA_COMPLIANCE CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
C32122             ,PA_SORT_KEY CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
C32122             ,PA_S_DATE              DATE                         
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH         OR WS-SQLSTATE = '42710'                                 
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
REARCH            MOVE '0100A'           TO ACTIVE-PARAGRAPH            
REARCH            MOVE 'DECLARE GTT'     TO ABEND-FUNCTION              
REARCH            MOVE SPACES            TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH            MOVE 'CSR02038_R1'     TO TABLE-1                     
REARCH            MOVE SPACES            TO TABLE-ELEMENT-1             
REARCH            MOVE SPACES            TO HOSTVAR-ELEMENT-1           
C32122            MOVE SQLCODE           TO ABEND-SQLCODE               
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                   THRU  9900-EXIT                
REARCH         END-IF.                                                  
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NUM      TO WS-ACCOUNT-NUM.                
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO                  
T34097                                   CA-ACCOUNT-NO                  
T34097                                   DA-ACCOUNT-NO                  
                                         AT-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2200-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-MESSAGE                TO S-MESSAGE.                 
REARCH     MOVE RS-PA-DATE                TO S-PA-DATE.                 
REARCH     MOVE RS-PA-USER-ID             TO S-PA-USER-ID.              
REARCH     MOVE RS-PA-TYPE                TO S-PA-TYPE.                 
REARCH     MOVE RS-PA-STATUS              TO S-PA-STATUS.               
REARCH     MOVE RS-PA-COMPLIANCE          TO S-PA-COMPLIANCE.           
C32122     MOVE RS-PA-SORT-KEY            TO S-PA-SORT-KEY.             
C32122     MOVE RS-PA-SORT-DATE           TO S-PA-SORT-DATE.            
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS       7000-SELECT-ACCOUNT                            *        
      *                 7020-OPEN-MED-CERT-ID-CURSOR                   *        
      *                 7120-FETCH-MED-CERT-ID-CURSOR                  *        
      *                 2250-PROCESS-MED-CERT                          *        
      *                 7220-CLOSE-MED-CERT-ID-CURSOR                  *        
      *                 7030-OPEN-DFA-CURSOR                           *        
      *                 2310-PROCESS-FETCH-ALL                         *        
      *                 7230-CLOSE-DFA-CURSOR                          *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
      *----< SELECT ACCOUNT >                                                   
              PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT.          
              MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.
              MOVE 0 TO WS-MSG-CNT.                                     
                                                                        
TP9168*----< GET THE MEDICAL CERTIFICATE INFORMATION >                          
              PERFORM 7020-OPEN-MED-CERT-ID-CURSOR THRU 7020-EXIT.      
              PERFORM 7120-FETCH-MED-CERT-ID-CURSOR THRU 7120-EXIT.     
T12583        PERFORM 2250-PROCESS-MED-CERT THRU 2250-EXIT              
T12583           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.               
              PERFORM 7220-CLOSE-MED-CERT-ID-CURSOR THRU 7220-EXIT      
      *                                                                         
              IF WS-CODE-BANK-EFT = 'A'                                 
                 ADD 1 TO WS-MSG-CNT                                    
                 MOVE WS-BE            TO WS-SEND-CODE(WS-MSG-CNT)      
              END-IF.                                                   
                                                                        
              IF AT-BILL-CYCLE-CHG-CD = WS-F OR WS-R                    
                 ADD 1 TO WS-MSG-CNT                                    
                 MOVE AT-BILL-CYCLE-CHG-CD TO WS-SEND-CODE(WS-MSG-CNT)  
              END-IF.                                                   
                                                                        
              IF AT-CODE-CRIT-OUTAGE = WS-WC                            
                 ADD 1 TO WS-MSG-CNT                                    
                 MOVE AT-CODE-CRIT-OUTAGE  TO WS-SEND-CODE(WS-MSG-CNT)  
              END-IF.                                                   
                                                                        
      *----< SEE IF THIS CUSTOMER IS A SPECIAL NEEDS CUSTOMER                   
T34097        MOVE AT-CUSTOMER-NO TO LQ-CUSTOMER-NO.                    
              PERFORM 7600-SELECT-SPECIAL-NEEDS  THRU 7600-EXIT.        
              IF LQ-SPECIAL-CUST NOT = SPACES                           
                 ADD 1 TO WS-MSG-CNT                                    
                 MOVE WS-SN                TO WS-SEND-CODE(WS-MSG-CNT)  
              END-IF.                                                   
                                                                        
      *----< IF THERE IS A DFA THEN OPEN DFA CURSOR   - MOVING >                
      *----< NOT-FOUND TO THE RET CODE MEANS THAT THE DFA      >                
      *----< PROCESSING IS SKIPPED IN 2310-PROCESS-FETCH-ALL   >                
              IF PARM-DFA-INDICATOR = WS-A                              
                 PERFORM 7030-OPEN-DFA-CURSOR    THRU 7030-EXIT         
                 MOVE ZEROES    TO WS-DFA-RETURN-CODE                   
              ELSE                                                      
                 MOVE NOT-FOUND TO WS-DFA-RETURN-CODE                   
              END-IF.                                                   
                                                                        
      *----< DO ALL THE FETCHING AND CARRYING >                                 
              PERFORM 2310-PROCESS-FETCH-ALL     THRU 2310-EXIT         
                UNTIL WS-RETRIEVED-ALL      = WS-YES.                   
      *----< ONLY CLOSE IF OPENED  >                                            
              IF PARM-DFA-INDICATOR = WS-A                              
                 PERFORM 7230-CLOSE-DFA-CURSOR   THRU 7230-EXIT         
              END-IF.                                                   
                                                                        
      *----< BUILD CDD/CDDA/NEW STA/STAA/STF/STFA  DETAIL ONLY FOR IVR>         
P0726C        IF WS-CODE-CRED-ARNG = 'A' OR                             
P0726C           WS-CODE-STA-ACCT  = 'A'                                
P0726C           PERFORM 7610-GET-ACTIVE-ARNG-INFO                      
P0726C              THRU 7610-EXIT                                      
P0726C           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL        
P00726               MOVE ZERO      TO RS-RETURN-CODE                   
P00726               STRING FUNCTION CURRENT-DATE (1:4)                 
P00726                      '-'                                         
P00726                      FUNCTION CURRENT-DATE (5:2)                 
P00726                      '-'                                         
P00726                      FUNCTION CURRENT-DATE (7:2)                 
P00726                      DELIMITED BY SIZE                           
P00726                      INTO RS-PA-SORT-DATE                        
P0726C               MOVE X1-LAST-UPDATE-USERID TO RS-PA-USER-ID        
P0726C               MOVE X1-ARNG-SETUP-DT      TO RS-PA-DATE           
P0726C               MOVE SPACES                TO RS-PA-COMPLIANCE     
P0726C               IF IVR-CALL                                        
P0726C                  EVALUATE X1-ARNG-TYPE                           
P0726C                     WHEN 'CDD'                                   
P0726C                     WHEN 'CDDA'                                  
P0726C                        MOVE 'D'       TO RS-PA-TYPE              
P00726                     WHEN 'STA'                                   
P0726C                        MOVE 'S'       TO RS-PA-TYPE              
P00726                     WHEN 'STAA'                                  
P0726C                        MOVE 'T'       TO RS-PA-TYPE              
P00948                     WHEN 'STF'                                   
P00948                        MOVE 'F'       TO RS-PA-TYPE              
P00948                     WHEN 'STFA'                                  
P00948                        MOVE 'G'       TO RS-PA-TYPE              
P0726C                  END-EVALUATE                                    
P00726                  MOVE 'A'       TO RS-PA-STATUS                  
P00726                  MOVE ' '       TO WS-SORT-KEY                   
P00726                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT    
P00726                  PERFORM 8100-SEND-RESULT     THRU 8100-EXIT     
P0726C               ELSE                                               
P0726C                  IF X1-ARNG-TYPE = 'STA' OR 'STAA' OR            
P00948                                    'STF' OR 'STFA'               
P0726C                     MOVE 'C'    TO RS-PA-TYPE                    
P00726                     MOVE 'A'    TO RS-PA-STATUS                  
P00726                     MOVE ' '    TO WS-SORT-KEY                   
P00726                     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT    
P00726                     PERFORM 8100-SEND-RESULT  THRU 8100-EXIT     
P0726C                  END-IF                                          
P0726C               END-IF                                             
P0726C           END-IF                                                 
P00726        END-IF.                                                   
                                                                        
      *--------< IF NOTHING HAS BEEN FOUND, THEN SO FAR NOTHING HAS >           
      *--------< BEEN SENT BACK. SEND BACK A SUCCESSFUL MESSAGE     >           
              IF CTR-ROWS = 0                                           
                 MOVE ZERO                TO RS-RETURN-CODE             
C32122           MOVE '1950-01-01'  TO RS-PA-SORT-DATE                  
C32122           MOVE ' '           TO WS-SORT-KEY                      
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF.                                                   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-PROCESS-MED-CERT                                          *        
      *     CALLS 7400-SELECT-USER-PROFILE                             *        
      *           2510-STRIP-SPACES                                    *        
      *           2000A-MOVE-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *           7120-FETCH-MED-CERT-ID-CURSOR                        *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES ALL MEDICAL CERTIFICATES                           *        
      ******************************************************************        
T12583 2250-PROCESS-MED-CERT.                                           
T12583                                                                  
T12583*-----< FETCH MEDICAL CERTIFICATES                                        
T34097     IF CA-DATE-ALERT = '01/01/1950'                              
T34097           MOVE SPACES        TO RS-PA-DATE                       
T34097     ELSE                                                         
T34097           MOVE CA-DATE-ALERT TO RS-PA-DATE                       
T34097     END-IF.                                                      
C32122     MOVE CA-DATE-ALERT TO RS-PA-SORT-DATE.                       
      *                                                                         
T14170     MOVE MH-USER-ID            TO WS-CSR-USERID.                 
T14170     PERFORM 7400-SELECT-USER-PROFILE           THRU 7400-EXIT.   
      *                                                                         
T14170     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T12583         MOVE PF-LAST-NAME      TO WS-FROM                        
T12583         PERFORM 2510-STRIP-SPACES              THRU 2510-EXIT    
T12583         MOVE WS-FROM             TO PF-LAST-NAME                 
T12583         MOVE SPACES              TO WS-FROM                      
T12583         STRING PF-LAST-NAME DELIMITED CN-DELIMITER               
T12583                ', ' DELIMITED SIZE                               
T12583                PF-FIRST-NAME (1:1) DELIMITED CN-DELIMITER        
T12583            INTO RS-PA-USER-ID                                    
T12583         END-STRING                                               
           ELSE                                                         
T14170         MOVE MH-USER-ID      TO RS-PA-USER-ID                    
           END-IF.                                                      
      *                                                                         
T12583     MOVE WS-MC               TO RS-PA-TYPE.                      
T12583     IF WS-MED-CERT-DAYS > 0                                      
T12583        MOVE WS-A             TO RS-PA-STATUS                     
C32122        MOVE '1'              TO RS-PA-SORT-KEY                   
T12583     ELSE                                                         
T12583        MOVE WS-C             TO RS-PA-STATUS                     
C32122        MOVE '3'              TO RS-PA-SORT-KEY                   
T12583     END-IF.                                                      
T12583     MOVE SPACES              TO RS-PA-COMPLIANCE.                
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
T12583     PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
      *                                                                         
T12583     PERFORM 7120-FETCH-MED-CERT-ID-CURSOR THRU 7120-EXIT.        
T12583     IF MED-CERT-NOT-SENT AND RS-PA-STATUS = WS-A                 
T12583        ADD 1 TO WS-MSG-CNT                                       
T12583        MOVE WS-MC    TO WS-SEND-CODE(WS-MSG-CNT)                 
T12583        MOVE 'Y'      TO WS-SEND-MED-CERT                         
T12583     END-IF.                                                      
T12583                                                                  
T12583 2250-EXIT.                                                       
T12583     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-PROCESS-FETCH-ALL                                         *        
      *     CALLS       7130-FETCH-DFA-CURSOR                          *        
      *                 2320-POPULATE-RETURN-ROW                       *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES EVERYTHING                                         *        
      ******************************************************************        
      *                                                                         
       2310-PROCESS-FETCH-ALL.                                          
                                                                        
      *-----< DFA AND STA PROCESSING IS SLIGHTLY DIFFERENT - THEY    >          
      *-----< WILL BOTH APPEAR IN THE SAME DATAWINDOW. I AM FETCHING >          
      *-----< ALL THE DFAS AND THEN ALL THE STAS. FETCHING STAS      >          
      *-----< INVOLVES GETTING THE COMPLIANCE FROM THE DETAIL RECORDS>          
      *-----<           IF NO MORE DFA                               >          
      *-----<              PROCESS STA                               >          
      *-----<           ELSE                                         >          
      *-----<              GET NEXT DFA                              >          
      *-----<              IF NO MORE DFA                            >          
      *-----<                 PROCESS STA                            >          
      *-----<              END IF                                    >          
      *-----<           END IF                                       >          
                                                                        
           IF WS-DFA-RETURN-CODE          = NOT-FOUND                   
ACT348        CONTINUE                                                  
           ELSE                                                         
              PERFORM 7130-FETCH-DFA-CURSOR      THRU 7130-EXIT         
              IF WS-DFA-RETURN-CODE          = NOT-FOUND                
ACT348           CONTINUE                                               
              END-IF                                                    
           END-IF.                                                      
           IF WS-MSG-IDX             > WS-MSG-CNT                       
           AND WS-DFA-RETURN-CODE     = NOT-FOUND                       
              MOVE WS-YES                      TO WS-RETRIEVED-ALL      
           ELSE                                                         
              PERFORM 2320-POPULATE-RETURN-ROW THRU 2320-EXIT           
REARCH        PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
              ADD 1                            TO WS-MSG-IDX            
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-POPULATE-RETURN-ROW                                       *        
      *     CALLS       7502-GET-USA-DATE                              *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-ALL                               *        
      *                                                                *        
      *     POPULATES THE RETURN ROW                                   *        
      ******************************************************************        
       2320-POPULATE-RETURN-ROW.                                        
           IF WS-MSG-IDX < 6                                            
              MOVE WS-SEND-CODE(WS-MSG-IDX) TO RS-MESSAGE               
           ELSE                                                         
              MOVE SPACES                   TO RS-MESSAGE               
           END-IF.                                                      
      *                                                                         
           MOVE SPACES               TO RS-PA-USER-ID.                  
      *                                                                         
           IF WS-DFA-RETURN-CODE     = NOT-FOUND                        
ACT348        MOVE '1950-01-01' TO RS-PA-SORT-DATE                      
ACT348        MOVE '5'          TO WS-SORT-KEY                          
ACT348        MOVE SPACES       TO RS-PA-USER-ID                        
ACT348        MOVE SPACES       TO RS-PA-TYPE                           
ACT348        MOVE SPACES       TO RS-PA-STATUS                         
ACT348        MOVE SPACES       TO RS-PA-COMPLIANCE                     
           ELSE                                                         
T34097        IF DA-DATE-OF-AGREE = SPACES                              
C32122           MOVE '1950-01-01'  TO RS-PA-SORT-DATE                  
T34097           MOVE SPACES        TO RS-PA-DATE                       
C32122           MOVE '5'           TO WS-SORT-KEY                      
              ELSE                                                      
                 MOVE 'DA-DATE-OF-AGREE'                                
                                       TO TABLE-ELEMENT-1               
T34097           MOVE DA-DATE-OF-AGREE TO RS-PA-SORT-DATE               
T34097           MOVE WS-DATE-DFA-USA  TO RS-PA-DATE                    
              END-IF                                                    
      *                                                                         
T14170        MOVE DA-CSR-USERID       TO WS-CSR-USERID                 
T14170        PERFORM 7400-SELECT-USER-PROFILE        THRU 7400-EXIT    
T14170        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  MOVE PF-LAST-NAME    TO WS-FROM                       
                  PERFORM 2510-STRIP-SPACES           THRU 2510-EXIT    
                  MOVE WS-FROM         TO PF-LAST-NAME                  
                  MOVE SPACES          TO WS-FROM                       
                  STRING PF-LAST-NAME DELIMITED CN-DELIMITER            
                         ', ' DELIMITED SIZE                            
                         PF-FIRST-NAME (1:1) DELIMITED CN-DELIMITER     
                     INTO RS-PA-USER-ID                                 
                  END-STRING                                            
              ELSE                                                      
T14170            MOVE DA-CSR-USERID   TO RS-PA-USER-ID                 
              END-IF                                                    
     *                                                                  
              MOVE DA-CODE-DFA-TYPE    TO RS-PA-TYPE                    
              MOVE DA-CODE-DFA-STATUS  TO RS-PA-STATUS                  
              MOVE DA-CODE-COMPLY-HIST TO RS-PA-COMPLIANCE              
           END-IF.                                                      
C32122     IF RS-PA-SORT-DATE = SPACES                                  
C32122         MOVE '1950-01-01'  TO RS-PA-SORT-DATE                    
C32122     END-IF.                                                      
C32122     MOVE WS-SORT-KEY TO RS-PA-SORT-KEY.                          
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
      *                                                                *        
      ******************************************************************        
       2510-STRIP-SPACES.                                               
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 20 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLE CSS_ACCOUNT                   *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT,                             
                     AT.BILL_CYCLE_CHG_CD,                              
T34097               AT.CUSTOMER_NO,                                    
                     AT.CODE_CRIT_OUTAGE                                
                INTO :AT-CODES-DATA-PRESENT,                            
                     :AT-BILL-CYCLE-CHG-CD,                             
T34097               :AT-CUSTOMER-NO,                                   
                     :AT-CODE-CRIT-OUTAGE                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.BILL_CYCLE_CHG_CD,                                      
MFA-TR*              AT.CUSTOMER_NO,                                            
MFA-TR*              AT.CODE_CRIT_OUTAGE                                        
MFA-TR*         INTO :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-BILL-CYCLE-CHG-CD,                                     
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-CRIT-OUTAGE                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T19353        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
REARCH           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
T19353           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
T19353           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
T19353        ELSE                                                      
C32122           MOVE SQLCODE              TO ABEND-SQLCODE             
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
T19353        END-IF                                                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-OPEN-MED-CERT-ID-CURSOR                                   *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
       7020-OPEN-MED-CERT-ID-CURSOR.                                    
                                                                        
           MOVE '7020'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MED-CERT-ID-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
CBSI          MOVE 'CSS_CUST_ALERT'           TO TABLE-2                
CBSI          MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T34097        MOVE 'PANEL269'                 TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7030-OPEN-DFA-CURSOR                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
       7030-OPEN-DFA-CURSOR.                                            
                                                                        
           MOVE '7030'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN DFA-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_DFA_ACCT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE DA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-FETCH-MEDICAL-CERT-ID                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-FETCH-ALL                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-MED-CERT-ID-CURSOR.                                   
                                                                        
           MOVE '7120'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  MED-CERT-ID-CURSOR                                 
T34097          INTO :CA-DATE-ALERT,                                    
                     :MH-USER-ID,                                       
                     :WS-MED-CERT-DAYS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T34097        NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
CBSI          MOVE 'CSS_CUST_ALERT'           TO TABLE-2                
CBSI          MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T34097        MOVE 'PANEL269'                 TO HOSTVAR-ELEMENT-1      
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-FETCH-DFA-CURSOR                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-FETCH-ALL                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
       7130-FETCH-DFA-CURSOR.                                           
                                                                        
           MOVE '7130'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  DFA-CURSOR                                         
T34097         INTO :DA-DATE-OF-AGREE,                                  
T34097              :WS-DATE-DFA-USA,                                   
                    :DA-CSR-USERID,                                     
                    :DA-CODE-DFA-TYPE,                                  
                    :DA-CODE-DFA-STATUS,                                
                    :DA-CODE-COMPLY-HIST                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-DFA-RETURN-CODE.                          
                                                                        
           IF WS-DFA-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND         
T34097        IF WS-DFA-RETURN-CODE = SUCCESSFUL-CALL                   
T34097           IF DA-CODE-DFA-STATUS = 'A'                            
T34097              MOVE '2' TO WS-SORT-KEY                             
T34097           ELSE                                                   
T34097              MOVE '3' TO WS-SORT-KEY                             
T34097           END-IF                                                 
T34097        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_DFA_ACCT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE DA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-CLOSE-MED-CERT-ID-CURSOR                                  *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7220-CLOSE-MED-CERT-ID-CURSOR.                                   
                                                                        
           MOVE '7220'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  MED-CERT-ID-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
CBSI          MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T34097        MOVE 'PANEL269'                 TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230-CLOSE-DFA-CURSOR                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7230-CLOSE-DFA-CURSOR.                                           
                                                                        
           MOVE '7230'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE DFA-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_DFA_ACCT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE DA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C32122        MOVE SQLCODE                    TO ABEND-SQLCODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      *  7400-SELECT-USER-PROFILE                                               
      *                                                                         
      ******************************************************************        
T14170 7400-SELECT-USER-PROFILE.                                        
      *                                                                         
           EXEC SQL                                                     
             SELECT                                                     
               FIRST_NAME,                                              
               LAST_NAME                                                
             INTO                                                       
               :PF-FIRST-NAME,                                          
               :PF-LAST-NAME                                            
             FROM                                                       
               CSS_USER_PROFILE WITH(READUNCOMMITTED)                           
             WHERE                                                      
              USER_ID    = :WS-CSR-USERID                               
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*        FIRST_NAME,                                                      
MFA-TR*        LAST_NAME                                                        
MFA-TR*      INTO                                                               
MFA-TR*        :PF-FIRST-NAME,                                                  
MFA-TR*        :PF-LAST-NAME                                                    
MFA-TR*      FROM                                                               
MFA-TR*        CSS_USER_PROFILE                                                 
MFA-TR*      WHERE                                                              
MFA-TR*       USER_ID    = :WS-CSR-USERID                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACES         TO PF-FIRST-NAME                 
                                          PF-LAST-NAME                  
                                                                        
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
CBSI          MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE  WS-CSR-USERID      TO HOSTVAR-ELEMENT-1             
CBSI          MOVE  PARM-ACCOUNT-NUM   TO HOSTVAR-ELEMENT-2             
C32122        MOVE SQLCODE             TO ABEND-SQLCODE                 
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 7600-SELECT-SPECIAL-NEEDS                                      *        
      *                                                                         
      ******************************************************************        
       7600-SELECT-SPECIAL-NEEDS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT SPECIAL_CUST                                       
                INTO :LQ-SPECIAL-CUST                                   
                FROM CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED)                
T34097         WHERE LQ.CUSTOMER_NO = :LQ-CUSTOMER-NO                   
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SPECIAL_CUST                                               
MFA-TR*         INTO :LQ-SPECIAL-CUST                                           
MFA-TR*         FROM CSS_CUST_MISC_INFO LQ                                      
MFA-TR*        WHERE LQ.CUSTOMER_NO = :LQ-CUSTOMER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES TO LQ-SPECIAL-CUST                        
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
T34097        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
T34097        MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
P0726C******************************************************************16234000
P0726C* 7610-GET-ACTIVE-ARNG-INFO                                      *16240000
P0726C*  GET ACTIVE ARNG INFO.                                         *16260000
P0726C******************************************************************16290000
P0726C                                                                  
P0726C 7610-GET-ACTIVE-ARNG-INFO.                                       
P0726C*                                                                 16310000
P0726C     EXEC SQL                                                     
P0726C        SELECT TOP(1) X1.ARNG_TYPE,
              X1.ARNG_SETUP_DT,
              X1.LAST_UPDATE_USERID                              
P0726C           INTO :X1-ARNG-TYPE                                     
P0726C              , :X1-ARNG-SETUP-DT                                 
P0726C              , :X1-LAST-UPDATE-USERID                            
P0726C          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P0726C         WHERE X1.ACCOUNT_NO     =  :WS-ACCOUNT-NO                
P0726C           AND X1.ARNG_STATUS_CD =  'A'                           
P0726C                                            
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16320000
MFA-TR*       SELECT X1.ARNG_TYPE                                       16330000
MFA-TR*             ,X1.ARNG_SETUP_DT                                   16330000
MFA-TR*             ,X1.LAST_UPDATE_USERID                              16330000
MFA-TR*          INTO :X1-ARNG-TYPE                                             
MFA-TR*             , :X1-ARNG-SETUP-DT                                 16330000
MFA-TR*             , :X1-LAST-UPDATE-USERID                            16330000
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                               16350000
MFA-TR*        WHERE X1.ACCOUNT_NO     =  :WS-ACCOUNT-NO                16390000
MFA-TR*          AND X1.ARNG_STATUS_CD =  'A'                           16420000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                    16430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C*                                                                 16440000
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C*                                                                 16460000
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C         NEXT SENTENCE                                            
P0726C     ELSE                                                         
P0726C         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P0726C         MOVE '7610'                    TO ACTIVE-PARAGRAPH       
P0726C         MOVE 'SELECT'                  TO ABEND-FUNCTION         
P0726C         MOVE 'CSS_CRED_ARNGMENT'       TO TABLE-1                
P0726C         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
P0726C         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
P0726C         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P0726C         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P0726C     END-IF.                                                      
P0726C*                                                                 16590000
P0726C 7610-EXIT.                                                       
P0726C     EXIT.                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
REARCH         INSERT INTO #CSR02038_R1                          
REARCH         (    RETURN_CODE                                         
REARCH             ,MESSAGE                                             
REARCH             ,PA_DATE                                             
REARCH             ,PA_USER_ID                                          
REARCH             ,PA_TYPE                                             
REARCH             ,PA_STATUS                                           
REARCH             ,PA_COMPLIANCE                                       
C32122             ,PA_SORT_KEY                                         
C32122             ,PA_S_DATE                                           
C32122         )                                                        
REARCH         VALUES                                                   
REARCH         (   :S-RETURN-CODE                                       
REARCH            ,:S-MESSAGE                                           
REARCH            ,:S-PA-DATE                                           
REARCH            ,:S-PA-USER-ID                                        
REARCH            ,:S-PA-TYPE                                           
REARCH            ,:S-PA-STATUS                                         
REARCH            ,:S-PA-COMPLIANCE                                     
C32122            ,:S-PA-SORT-KEY                                       
C32122            ,IIF(TRY_CONVERT(DATE, :S-PA-SORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :S-PA-SORT-DATE
              ) <> 0) OR (LEN(:S-PA-SORT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :S-PA-SORT-DATE
              ), CONVERT(DATE, :S-PA-SORT-DATE) )                              
REARCH         )                                                        
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02038_R1                                  
MFA-TR*        (    RETURN_CODE                                                 
MFA-TR*            ,MESSAGE                                                     
MFA-TR*            ,PA_DATE                                                     
MFA-TR*            ,PA_USER_ID                                                  
MFA-TR*            ,PA_TYPE                                                     
MFA-TR*            ,PA_STATUS                                                   
MFA-TR*            ,PA_COMPLIANCE                                               
MFA-TR*            ,PA_SORT_KEY                                                 
MFA-TR*            ,PA_S_DATE                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (   :S-RETURN-CODE                                               
MFA-TR*           ,:S-MESSAGE                                                   
MFA-TR*           ,:S-PA-DATE                                                   
MFA-TR*           ,:S-PA-USER-ID                                                
MFA-TR*           ,:S-PA-TYPE                                                   
MFA-TR*           ,:S-PA-STATUS                                                 
MFA-TR*           ,:S-PA-COMPLIANCE                                             
MFA-TR*           ,:S-PA-SORT-KEY                                               
MFA-TR*           ,:S-PA-SORT-DATE                                              
MFA-TR*        )                                                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS                                        
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02038_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
C32122         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
T33351******************************************************************12710000
T33351*   END PROGRAM COPY LIB FOR STORED PROCEDURE TYPE SUB           *12720000
T33351******************************************************************12730000
T33531     EXEC SQL                                                             
T33531         INCLUDE CPD00323                                                 
T33531     END-EXEC.                                                            
