       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02035.                                     
COB303 DATE-WRITTEN.      MAY 16, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060001
      *                                                                *00070001
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080001
      *                                                                *00090001
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100001
      *                                                                *00110001
      *  TRANID:        S035                                           *00120099
      *  PROGRAM:       S035                                           *00130099
      *  CALLING SP:    PA_S035                                        *00140099
      *  PANEL:         057 -- SECURITIES                              *00141099
      *                                                                *00150001
      ******************************************************************00160001
      *                 P R O G R A M  S U M M A R Y                   *00170001
      *                                                                *00180001
      *  THIS PROCEDURE RETRIEVES WAIVER SECURITIES DETAIL INFORMATION.*00190099
      *                                                                *00203099
      ******************************************************************00210001
      *                                                                *00220001
      *                     PROGRAM MODIFICATION LOG                   *00230001
      *                                                                *00240001
      *    DATE    INITIALS   COMMENTS                                 *00250001
      *  --------  --------   ---------------------------------------  *00260001
      *  02/21/95    WMG      PROCEDURE ORIGINALLY CODED.              *00270099
T15609*  04/20/98    SHF      MODIFIED SO THAT VARIABLES LOAD CORRECTLY*00270100
      *                       BEFORE WRITING TO MC05 ERROR LOG.        *00270200
CBSI  *  07/18/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    TABLE PARAMETERS                         *        
REARCH*  05/16/05   CVNS      RPC TO COBOL SP CONVERSION.              *        
REARCH*             CHENNAI                                            *        
      ******************************************************************00280001
      ******************************************************************00290001
      *                                                                *00300001
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310001
      *                                                                *00320001
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330001
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340001
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350001
      *  3000 - 4999  NOT USED                                         *00360001
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370001
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380001
      *  7000 - 7999  INPUT MODULES                                    *00390001
      *  8000 - 8999  OUTPUT MODULES                                   *00400001
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410001
      *                                                                *00420001
      ******************************************************************00430001
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02035'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02035 STARTS HERE'.                  
                                                                        
      ******************************************************************00520001
      *    DB2 INCLUDES                                                *00530001
      ******************************************************************00540001
      *                                                                 00550099
           EXEC SQL                                                     00560001
              INCLUDE SQLCA                                             00570001
           END-EXEC.                                                    00580001
      *                                                                 00580116
           EXEC SQL                                                     00580299
              INCLUDE TBMODEL                                           00580399
           END-EXEC.                                                    00580499
      *                                                                 00580599
           EXEC SQL                                                     00940099
              INCLUDE TBSTYBND                                          00950099
           END-EXEC.                                                    00960099
      *                                                                 00970099
           EXEC SQL                                                     00980099
              INCLUDE TBWAIVER                                          00990099
           END-EXEC.                                                    01000099
      *                                                                 01010099
      *                                                                 01030099
      ******************************************************************01100001
      *    COBOL WORKING STORAGE COPY BOOKS                            *01110001
      ******************************************************************01120001
                                                                        
REARCH*    COPY SYGWCOB.                                                01140001
REARCH*    COPY SYDBCOB.                                                01150001
           COPY CCA00001.                                               01160001
REARCH*    COPY CWS00010.                                               01170001
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01180001
           COPY CWS00303.                                               01190001
                                                                        
      ******************************************************************01210001
      *    WORK AREAS                                                  *01220001
      ******************************************************************01230001
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01250001
REARCH*    05  GWL-PROC                POINTER.                         01260001
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         01270001
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  01280001
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01290001
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01300001
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01310001
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01320001
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01330001
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  01340001
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02035_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH      05  WS-SQLSTATE             PIC X(05).                      
REARCH      05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02035'.     
REARCH*01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   01360001
                                                                        
REARCH*01  PARM-FIELDS.                                                 01380001
REARCH*    05  PARM-L                  PIC S9(9) COMP.                  01390001
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          01400001
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          01410099
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01620099
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 02378799
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 02379799
       01  RS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-PARM          PIC X(13).                      
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                 02383599
       01  PROGRAM-LITERALS.                                            
           05  WAIVER-TYPE              PIC X(01) VALUE 'C'.            
      *                                                                 02383899
REARCH*01  WS-PROGRAM-NAME.                                             02383999
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02035'.      02384099
      *                                                                 02384199
      *                                                                 02384299
      *                                                                 02384399
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02384578
      *                                                                 02384699
      *                                                                 02384799
       01  TDS-RETURN-FIELDS.                                           
           05  RS-CODE-STATUS          PIC X(01) VALUE SPACES.          
           05  RS-WAIVER-DESC          PIC X(30) VALUE SPACES.          
           05  RS-COMMENTS             PIC X(72) VALUE SPACES.          
           05  RS-BOND-NO              PIC X(16) VALUE SPACES.          
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                 02576699
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-CODE-STATUS          PIC X(01) VALUE SPACES.           
REARCH     05  S-WAIVER-DESC          PIC X(30) VALUE SPACES.           
REARCH     05  S-COMMENTS             PIC X(72) VALUE SPACES.           
REARCH     05  S-BOND-NO              PIC X(16) VALUE SPACES.           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH*01  CN-COLUMN-DEFINITIONS.                                       02576799
REARCH*    05  CN-CODE-STATUS          PIC X(11) VALUE                  02580099
REARCH*                                      'CODE STATUS'.             02590099
REARCH*    05  CN-WAIVER-DESC          PIC X(11) VALUE                  02600099
REARCH*                                      'WAIVER DESC'.             02601099
REARCH*    05  CN-COMMENTS             PIC X(08) VALUE                  02877599
REARCH*                                      'COMMENTS'.                02877699
REARCH*    05  CN-BOND-NO              PIC X(07) VALUE                  02877799
REARCH*                                      'BOND NO'.                 02877899
REARCH*    05  CN-RETURN-CODE          PIC X(11) VALUE                  02879599
REARCH*                                      'RETURN CODE'.             02880099
      *                                                                 03981699
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
      ******************************************************************03981778
      *                         CURSORS                                *03982078
      ******************************************************************03983078
      *                                                                 03984078
           EXEC SQL                                                     
               DECLARE WAIVER CURSOR FOR                                
                  SELECT SB.CODE_STATUS,                                
                         A6.WAIVER_DESC,                                
                         SB.COMMENTS,                                   
                         SB.BOND_NO                                     
                    FROM CSS_SURETY_BOND SB,                            
                         CSS_WAIVER A6                                  
                   WHERE SB.ACCOUNT_NO     = :WS-ACCOUNT-NO             
                     AND SB.CODE_BOND_TYPE = :WAIVER-TYPE               
                     AND A6.WAIVER_TYPE_CD = SB.WAIVER_TYPE_CD          
           END-EXEC.                                                    
      *                                                                 04090099
      *                                                                 04100099
HPCCDM*EJECT                                                            06760001
      *                                                                 06761056
      *                                                                 06762056
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 06780156
      *                                                                 06785056
      ******************************************************************06790001
      * 0000-MAINLINE                                                  *06800001
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06810001
      ******************************************************************06820001
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06940001
      * 0100-INITIALIZE                                                *06950001
      *                                                                *06960001
      *     1. RESET DB2 ERROR HANDLERS                                *06970001
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *06980001
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *06990001
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07000001
      *                                                                *07010001
      ******************************************************************07020001
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     07100001
REARCH*                                                                 07110001
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     07120001
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         07130001
REARCH*                                                                 07140001
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      07150001
REARCH*                                                                 07160001
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             07170001
REARCH*        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    07180001
REARCH*        MOVE '0100'          TO ACTIVE-PARAGRAPH                 07190001
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION     07200001
REARCH*        MOVE 'CICS TRANSACTION'   TO TABLE-1                     07210001
REARCH*        MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE       07220001
REARCH*        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           07230001
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           07240001
REARCH*    END-IF.                                                      07250001
      *                                                                 07264059
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             CODE_STATUS                                          
REARCH            ,LTRIM(RTRIM(WAIVER_DESC))   AS WAIVER_DESC                  
REARCH            ,LTRIM(RTRIM(COMMENTS))      AS COMMENTS                     
REARCH            ,LTRIM(RTRIM(BOND_NO))       AS BOND_NO                      
REARCH            ,RETURN_CODE                                          
REARCH         FROM                                                     
REARCH             #CSR02035_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            CODE_STATUS                                                  
MFA-TR*           ,STRIP(WAIVER_DESC)   AS WAIVER_DESC                          
MFA-TR*           ,STRIP(COMMENTS)      AS COMMENTS                             
MFA-TR*           ,STRIP(BOND_NO)       AS BOND_NO                              
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02035_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************07300001
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************07300001
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02035_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02035_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02035_R1
               (                                                       
REARCH              CODE_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,WAIVER_DESC CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,BOND_NO CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,RETURN_CODE     INT                             
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02035_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************07300001
      * 1000-PROCESS-INPUT                                             *07310001
      *                                                                *07320001
      *     1. RECEIVE PARMS.                                          *07330001
      *                                                                *07350001
      ******************************************************************07360001
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               07400099
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07590001
      * 1100-RECEIVE-PARMS                                             *07600001
      *                                                                *07610001
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *07620001
      *                                                                *07630001
      ******************************************************************07640001
REARCH*1100-RECEIVE-PARMS.                                              07660099
REARCH*                                                                 07670099
REARCH*                                                                 07671099
REARCH*    MOVE 1                          TO PARM-ID1.                 07680099
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM,          07690099
REARCH*                                                                 07700099
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07710099
REARCH*                          GWL-RC,                                07720099
REARCH*                          PARM-ID1,                              07730001
REARCH*                          PARM-ACCOUNT-NO,                       07740099
REARCH*                          TDSCHAR,                               07750001
REARCH*                          MAX-LENGTH-PARM,                       07760001
REARCH*                          PARM-L.                                07770001
REARCH*                                                                 12762799
REARCH*                                                                 12763899
REARCH*1100-EXIT.                                                       12764099
REARCH*    EXIT.                                                        12764199
      *                                                                 12764299
      *                                                                 12764399
      ******************************************************************12764418
      * 1150 ASSIGN-WS-VARS                                            *12764520
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *12764618
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *12764724
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *12764824
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *12764924
      *        SELECT STATEMENTS.                                      *12765024
      ******************************************************************12765118
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 12767018
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-PARM.               
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
      *                                                                 12770299
      *                                                                 12770699
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12770919
      *                                                                 12771099
      *                                                                 12771199
      ******************************************************************12772001
      * 2000-PROCESS-OUTPUT.                                           *12780001
      *                                                                *12790001
      *     1. DESCRIBE RESULT SET                                     *12800001
      *     2. FETCH CASH WAIVER DETAIL INFORMATION                    *12810099
      *                                                                *12840001
      ******************************************************************12850001
      *                                                                 12860099
       2000-PROCESS-OUTPUT.                                             
      *                                                                 12880099
REARCH*    PERFORM 2100-DESCRIBE-RESULT            THRU 2100-EXIT.      12890099
           PERFORM 2200-GET-WAIVER-DETAILS         THRU 2200-EXIT.      
      *                                                                 12911099
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12940099
      *                                                                 12941099
      ******************************************************************12950001
      * 2100-DESCRIBE-RESULT                                           *12960001
      *                                                                *12970001
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *12980001
      *                                                                *12990001
      ******************************************************************13000001
REARCH*2100-DESCRIBE-RESULT.                                            13020001
REARCH*                                                                 13021099
REARCH*                                                                 13037799
REARCH*    MOVE 1                               TO CTR-COLUMN.          13037899
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        13037999
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      13038099
REARCH*    MOVE LENGTH OF RS-CODE-STATUS        TO WRKLEN1.             13038199
REARCH*    MOVE LENGTH OF CN-CODE-STATUS        TO WRKLEN2.             13038299
REARCH*                                                                 13038399
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              13038499
REARCH*                          GWL-RC,                                13038599
REARCH*                          CTR-COLUMN,                            13038699
REARCH*                          DB-HOST-TYPE,                          13038799
REARCH*                          WRKLEN1,                               13038899
REARCH*                          RS-CODE-STATUS,                        13038999
REARCH*                          DB-NULL-INDICATOR,                     13039099
REARCH*                          TDS-FALSE,                             13039199
REARCH*                          DB-CLIENT-TYPE,                        13039299
REARCH*                          WRKLEN1,                               13039399
REARCH*                          CN-CODE-STATUS,                        13039499
REARCH*                          WRKLEN2.                               13039599
REARCH*                                                                 13039699
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     13039799
REARCH*                                                                 13040899
REARCH*    ADD 1                                TO CTR-COLUMN.          13041099
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        13041199
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      13041299
REARCH*    MOVE LENGTH OF RS-WAIVER-DESC        TO WRKLEN1.             13041399
REARCH*    MOVE LENGTH OF CN-WAIVER-DESC        TO WRKLEN2.             13041499
REARCH*                                                                 13041599
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              13041699
REARCH*                          GWL-RC,                                13041799
REARCH*                          CTR-COLUMN,                            13041899
REARCH*                          DB-HOST-TYPE,                          13041999
REARCH*                          WRKLEN1,                               13042099
REARCH*                          RS-WAIVER-DESC,                        13042199
REARCH*                          DB-NULL-INDICATOR,                     13042299
REARCH*                          TDS-FALSE,                             13042399
REARCH*                          DB-CLIENT-TYPE,                        13042499
REARCH*                          WRKLEN1,                               13042599
REARCH*                          CN-WAIVER-DESC,                        13042699
REARCH*                          WRKLEN2.                               13042799
REARCH*                                                                 13042899
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     13042999
REARCH*                                                                 13043099
REARCH*    ADD 1                                TO CTR-COLUMN.          13043199
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        13043299
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      13043399
REARCH*    MOVE LENGTH OF RS-COMMENTS           TO WRKLEN1.             13043499
REARCH*    MOVE LENGTH OF CN-COMMENTS           TO WRKLEN2.             13043599
REARCH*                                                                 13043699
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              13043799
REARCH*                          GWL-RC,                                13043899
REARCH*                          CTR-COLUMN,                            13043999
REARCH*                          DB-HOST-TYPE,                          13044099
REARCH*                          WRKLEN1,                               13044199
REARCH*                          RS-COMMENTS,                           13044299
REARCH*                          DB-NULL-INDICATOR,                     13044399
REARCH*                          TDS-FALSE,                             13044499
REARCH*                          DB-CLIENT-TYPE,                        13044599
REARCH*                          WRKLEN1,                               13044699
REARCH*                          CN-COMMENTS,                           13044799
REARCH*                          WRKLEN2.                               13044899
REARCH*                                                                 13044999
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     13045099
REARCH*                                                                 16237699
REARCH*    ADD 1                                TO CTR-COLUMN.          16237799
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        16237899
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      16237999
REARCH*    MOVE LENGTH OF RS-BOND-NO            TO WRKLEN1.             16238099
REARCH*    MOVE LENGTH OF CN-BOND-NO            TO WRKLEN2.             16238199
REARCH*                                                                 16238299
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              16238399
REARCH*                          GWL-RC,                                16238499
REARCH*                          CTR-COLUMN,                            16238599
REARCH*                          DB-HOST-TYPE,                          16238699
REARCH*                          WRKLEN1,                               16238799
REARCH*                          RS-BOND-NO,                            16238899
REARCH*                          DB-NULL-INDICATOR,                     16238999
REARCH*                          TDS-FALSE,                             16239099
REARCH*                          DB-CLIENT-TYPE,                        16239199
REARCH*                          WRKLEN1,                               16239299
REARCH*                          CN-BOND-NO,                            16239399
REARCH*                          WRKLEN2.                               16239499
REARCH*                                                                 16239599
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     16239699
REARCH*                                                                 16241999
REARCH*    ADD 1                                TO CTR-COLUMN.          16242099
REARCH*    MOVE TDSINT4                         TO DB-HOST-TYPE.        16242199
REARCH*    MOVE TDSINT4                         TO DB-CLIENT-TYPE.      16242299
REARCH*    MOVE LENGTH OF RS-RETURN-CODE        TO WRKLEN1.             16242399
REARCH*    MOVE LENGTH OF CN-RETURN-CODE        TO WRKLEN2.             16242499
REARCH*                                                                 16242599
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              16242699
REARCH*                          GWL-RC,                                16242799
REARCH*                          CTR-COLUMN,                            16242899
REARCH*                          DB-HOST-TYPE,                          16242999
REARCH*                          WRKLEN1,                               16243099
REARCH*                          RS-RETURN-CODE,                        16243199
REARCH*                          DB-NULL-INDICATOR,                     16243299
REARCH*                          TDS-FALSE,                             16243399
REARCH*                          DB-CLIENT-TYPE,                        16243499
REARCH*                          WRKLEN1,                               16243599
REARCH*                          CN-RETURN-CODE,                        16243699
REARCH*                          WRKLEN2.                               16243799
REARCH*                                                                 16243899
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     16243999
REARCH*                                                                 16244082
REARCH*                                                                 16244182
REARCH*2100-EXIT.                                                       16244201
REARCH*    EXIT.                                                        16244301
REARCH*                                                                 16244447
REARCH*                                                                 16245099
REARCH******************************************************************13000001
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************13000001
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-CODE-STATUS        TO S-CODE-STATUS.                 
REARCH     MOVE RS-WAIVER-DESC        TO S-WAIVER-DESC.                 
REARCH     MOVE RS-COMMENTS           TO S-COMMENTS.                    
REARCH     MOVE RS-BOND-NO            TO S-BOND-NO.                     
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************42243699
      * 2200-GET-WAIVER-DETAILS                                        *42243799
      *    -- THIS MODULE OPENS THE WAIVER CURSOR, FETCHES THE         *42243899
      *       DETAIL INFORMATION FOR EACH GUARANTOR, SENDS THE RESULT, *42243999
      *       AND THEN CLOSES THE CURSOR.                              *42244099
      ******************************************************************42244599
       2200-GET-WAIVER-DETAILS.                                         
      *                                                                 42244799
      *                                                                 42244899
           PERFORM 5000-OPEN-WAIVER-CURSOR       THRU 5000-EXIT.        
           PERFORM 5100-FETCH-WAIVER-CURSOR THRU 5100-EXIT              
               UNTIL SQLCODE = NOT-FOUND.                               
           PERFORM 7000-CLOSE-WAIVER-CURSOR THRU 7000-EXIT.             
      *                                                                 42245799
      *                                                                 42247999
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42248299
      *                                                                 42284699
      ******************************************************************42284799
      * 5000-OPEN-WAIVER-CURSOR                                        *42284899
      *       -- THIS MODULE OPENS THE COMPUTE WAIVER CURSOR           *42284999
      ******************************************************************42285099
       5000-OPEN-WAIVER-CURSOR.                                         
      *                                                                 42285299
           EXEC SQL                                                     
               OPEN WAIVER                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42285699
      *                                                                 42285799
           MOVE SQLCODE TO RS-RETURN-CODE.                              
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'OPEN'                TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
CBSI           MOVE 'CSS_WAIVER'          TO TABLE-2                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE WAIVER-TYPE           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42287399
      *                                                                 42287499
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42287799
      *                                                                 42287880
      ******************************************************************42287999
      * 5100-FETCH-WAIVER-CURSOR                                       *42288099
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF CASH WAIVER      *42288199
      *        DETAILS                                                 *42288299
      *                                                                *42288399
      ******************************************************************42288499
       5100-FETCH-WAIVER-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH WAIVER                                             
                  INTO :SB-CODE-STATUS,                                 
                       :A6-WAIVER-DESC,                                 
                       :SB-COMMENTS,                                    
                       :SB-BOND-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42289599
      *                                                                 42289699
           MOVE SQLCODE TO RS-RETURN-CODE.                              
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 42289999
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               PERFORM 8000-SET-RETURNS           THRU 8000-EXIT        
REARCH         PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT       
               PERFORM 8100-SEND-RESULT           THRU 8100-EXIT        
           ELSE IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5100'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'FETCH'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
T15609         MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'CSS_WAIVER'          TO TABLE-2                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE WAIVER-TYPE           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 42291599
      *                                                                 42291699
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42291999
      *                                                                 42292099
      ******************************************************************42292199
      * 7000-CLOSE-WAIVER-CURSOR                                       *42292299
      *       -- THIS MODULE CLOSES THE WAIVER CURSOR                  *42292399
      ******************************************************************42292499
       7000-CLOSE-WAIVER-CURSOR.                                        
      *                                                                 42292699
           EXEC SQL                                                     
               CLOSE WAIVER                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42293099
      *                                                                 42293199
           MOVE SQLCODE TO RS-RETURN-CODE.                              
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'CLOSE'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
CBSI           MOVE 'CSS_WAIVER'          TO TABLE-2                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE WAIVER-TYPE           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42294899
      *                                                                 42294999
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42295299
      *                                                                 42295399
      ******************************************************************42295499
      * 8000 SET RETURNS                                               *42295599
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*42295699
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *42295799
      ******************************************************************42295899
       8000-SET-RETURNS.                                                
      *                                                                 42296099
           MOVE SB-CODE-STATUS            TO RS-CODE-STATUS.            
           MOVE A6-WAIVER-DESC            TO RS-WAIVER-DESC.            
           MOVE SB-COMMENTS-TEXT          TO RS-COMMENTS.               
           MOVE SB-BOND-NO                TO RS-BOND-NO.                
      *                                                                 42296699
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42296999
REARCH******************************************************************42295899
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************42295899
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02035_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02035_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02035_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************42295899
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************42295899
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02035_R1                        
REARCH           (                                                      
REARCH                CODE_STATUS                                       
REARCH               ,WAIVER_DESC                                       
REARCH               ,COMMENTS                                          
REARCH               ,BOND_NO                                           
REARCH               ,RETURN_CODE                                       
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (    :S-CODE-STATUS                                    
REARCH               ,:S-WAIVER-DESC                                    
REARCH               ,:S-COMMENTS                                       
REARCH               ,:S-BOND-NO                                        
REARCH               ,:S-RETURN-CODE                                    
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02035_R1                                
MFA-TR*          (                                                              
MFA-TR*               CODE_STATUS                                               
MFA-TR*              ,WAIVER_DESC                                               
MFA-TR*              ,COMMENTS                                                  
MFA-TR*              ,BOND_NO                                                   
MFA-TR*              ,RETURN_CODE                                               
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (    :S-CODE-STATUS                                            
MFA-TR*              ,:S-WAIVER-DESC                                            
MFA-TR*              ,:S-COMMENTS                                               
MFA-TR*              ,:S-BOND-NO                                                
MFA-TR*              ,:S-RETURN-CODE                                            
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02035_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      *                                                                 42297099
      ******************************************************************42297101
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *42297201
      ******************************************************************42297301
REARCH*    EXEC SQL                                                     42297401
REARCH*       INCLUDE CPD00300                                          42297501
REARCH*    END-EXEC.                                                    42297601
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42300001
      * 9999- END PROGRAM COPYLIB                                      *42310001
      ******************************************************************42320001
REARCH*    COPY CPD00302.                                               42330001
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
