       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02034.                                     
COB303 DATE-WRITTEN.      MAY 16, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S034                                           *00120000
      *  PROGRAM:       S034                                           *00130000
      *  CALLING SP:    PA_S034                                        *00140000
      *  PANEL:         057 -- SECURITIES                              *00141000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES IRREVOCABLE LETTERS OF CREDIT        *00190000
      *  SECURITIES DETAIL INFORMATION.                                *00202000
      *                                                                *00203000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  02/21/95    WMG      PROCEDURE ORIGINALLY CODED.              *00270000
T15609*  04/20/98    SHF      MODIFIED SO THAT VARIABLES LOAD CORRECTLY*00270100
      *                       BEFORE WRITING TO MC05 ERROR LOG.        *00270200
CBSI  *  07/18/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    TABLE PARAMETERS                         *        
REARCH*  05/16/05   CVNS      RPC TO COBOL SP CONVERSION.              *        
REARCH*             CHENNAI                                            *        
P26289*  06/25/08   RB19957   ADDED DATE LAST UPDATED AND              *        
P26289*          RICK BLACK   USER ID LAST UPDATED.                    *        
      ******************************************************************00280000
      ******************************************************************00290000
      *                                                                *00300000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310000
      *                                                                *00320000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350000
      *  3000 - 4999  NOT USED                                         *00360000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380000
      *  7000 - 7999  INPUT MODULES                                    *00390000
      *  8000 - 8999  OUTPUT MODULES                                   *00400000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410000
      *                                                                *00420000
      ******************************************************************00430000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02034'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02034 STARTS HERE'.                  
                                                                        
      ******************************************************************00520000
      *    DB2 INCLUDES                                                *00530000
      ******************************************************************00540000
      *                                                                 00550000
           EXEC SQL                                                     00560000
              INCLUDE SQLCA                                             00570000
           END-EXEC.                                                    00580000
      *                                                                 00580100
           EXEC SQL                                                     00580200
              INCLUDE TBMODEL                                           00580300
           END-EXEC.                                                    00580400
      *                                                                 00580500
           EXEC SQL                                                     00940000
              INCLUDE TBSTYBND                                          00950000
           END-EXEC.                                                    00960000
      *                                                                 00970000
           EXEC SQL                                                     00980000
              INCLUDE TBBONDCO                                          00990000
           END-EXEC.                                                    01000000
      *                                                                 01010000
      *                                                                 01030000
      ******************************************************************01100000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01110000
      ******************************************************************01120000
                                                                        
           COPY CCA00001.                                               01160000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01180000
           COPY CWS00303.                                               01190000
                                                                        
      ******************************************************************01210000
      *    WORK AREAS                                                  *01220000
      ******************************************************************01230000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02034_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
            05  WS-SQLSTATE             PIC X(05).                      
REARCH      05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02034'.     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01620000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 02378700
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 02379700
       01  RS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-PARM          PIC X(13).                      
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-NULL-IND              PIC S9(4) COMP.                 
      *                                                                 02383500
       01  PROGRAM-LITERALS.                                            
           05  IRR-LETTER-TYPE          PIC X(01) VALUE 'B'.            
P26289*                                                                 02383600
P26289 01  NULL-INDICATORS.                                             
P26289     05  DATE-BOND-ISSUE-IND     PIC S9(04) COMP VALUE 0.         
P26289     05  NULL-VALUE              PIC S9(04) COMP VALUE -1.        
      *                                                                 02383800
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02384500
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-CODE-STATUS          PIC X(01)      VALUE SPACES.      
P26289     05  S-DATE-LAST-UPDATED    PIC X(10)      VALUE SPACES.      
P26289     05  S-USERID-LAST-UPDATED  PIC X(7)       VALUE SPACES.      
REARCH     05  S-BANK-NAME            PIC X(50)      VALUE SPACES.      
COB305     05 S-AMT-BOND        PIC S9(09)V99 USAGE COMP-3 VALUE 0.      
REARCH     05  S-BOND-NO              PIC X(16)      VALUE SPACES.      
REARCH     05  S-RETURN-CODE          PIC S9(9)      COMP VALUE 0.      
      *                                                                 02576600
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
      ******************************************************************03981700
      *                         CURSORS                                *03982000
      ******************************************************************03983000
      *                                                                 03984000
           EXEC SQL                                                     
               DECLARE IRR-LETTER CURSOR FOR                            
                  SELECT SB.CODE_STATUS,                                
                         SB.BOND_CO_NO,                                 
                         SB.AMT_BOND,                                   
P26289                   CIS.CHAR2$DATE(SB.DATE_BOND_ISSUED, 'USA'),            
P26289                   SB.USER_ID_ORIG_BY,                            
P26289                   CIS.CHAR2$DATE(SB.LAST_UPDATE_DT, 'USA'),              
P26289                   SB.LAST_UPDATE_USERID,                         
                         SB.BOND_NO                                     
                    FROM CSS_SURETY_BOND SB                             
                   WHERE SB.ACCOUNT_NO     = :WS-ACCOUNT-NO             
                     AND SB.CODE_BOND_TYPE = :IRR-LETTER-TYPE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04010000
MFA-TR*        DECLARE IRR-LETTER CURSOR FOR                            04020000
MFA-TR*           SELECT SB.CODE_STATUS,                                04030000
MFA-TR*                  SB.BOND_CO_NO,                                 04030100
MFA-TR*                  SB.AMT_BOND,                                   04031000
MFA-TR*                  CHAR(SB.DATE_BOND_ISSUED, USA),                04032000
MFA-TR*                  SB.USER_ID_ORIG_BY,                            04032000
MFA-TR*                  CHAR(SB.LAST_UPDATE_DT, USA),                  04032000
MFA-TR*                  SB.LAST_UPDATE_USERID,                         04032000
MFA-TR*                  SB.BOND_NO                                     04032000
MFA-TR*             FROM CSS_SURETY_BOND SB                             04040000
MFA-TR*            WHERE SB.ACCOUNT_NO     = :WS-ACCOUNT-NO             04060000
MFA-TR*              AND SB.CODE_BOND_TYPE = :IRR-LETTER-TYPE           04070000
MFA-TR*    END-EXEC.                                                    04080000
      *                                                                 04100000
HPCCDM*EJECT                                                            06760000
      *                                                                 06762000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 06780100
      ******************************************************************06790000
      * 0000-MAINLINE                                                  *06800000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06810000
      ******************************************************************06820000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06940000
      * 0100-INITIALIZE                                                *06950000
      *                                                                *06960000
      *     1. RESET DB2 ERROR HANDLERS                                *06970000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *06980000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *06990000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07000000
      *                                                                *07010000
      ******************************************************************07020000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 07264000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             CODE_STATUS                                          
P26289            ,DATE_LAST_UPDATED                                    
P26289            ,USERID_LAST_UPDATED                                  
REARCH            ,LTRIM(RTRIM(BANK_NAME))        AS  BANK_NAME                
REARCH            ,AMT_BOND                                             
REARCH            ,LTRIM(RTRIM(BOND_NO))          AS  BOND_NO                  
REARCH            ,RETURN_CODE                                          
REARCH         FROM                                                     
REARCH             #CSR02034_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            CODE_STATUS                                                  
MFA-TR*           ,DATE_LAST_UPDATED                                            
MFA-TR*           ,USERID_LAST_UPDATED                                          
MFA-TR*           ,STRIP(BANK_NAME)        AS  BANK_NAME                        
MFA-TR*           ,AMT_BOND                                                     
MFA-TR*           ,STRIP(BOND_NO)          AS  BOND_NO                          
MFA-TR*           ,RETURN_CODE                                                  
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02034_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************07300000
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************07300000
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02034_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02034_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02034_R1
               (                                                       
REARCH              CODE_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P26289             ,DATE_LAST_UPDATED CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P26289             ,USERID_LAST_UPDATED CHAR(07)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,BANK_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,AMT_BOND            DECIMAL(11,2)                   
REARCH             ,BOND_NO CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,RETURN_CODE         INT                         
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02034_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************07300000
      * 1000-PROCESS-INPUT                                             *07310000
      *                                                                *07320000
      *     1. RECEIVE PARMS.                                          *07330000
      *                                                                *07350000
      ******************************************************************07360000
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12764300
      ******************************************************************12764400
      * 1150 ASSIGN-WS-VARS                                            *12764500
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *12764600
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *12764700
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *12764800
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *12764900
      *        SELECT STATEMENTS.                                      *12765000
      ******************************************************************12765100
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 12767000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-PARM.               
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
      *                                                                 12770600
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12771100
      ******************************************************************12772000
      * 2000-PROCESS-OUTPUT.                                           *12780000
      *                                                                *12790000
      *     1. DESCRIBE RESULT SET                                     *12800000
      *     2. FETCH CASH IRR-LETTER DETAIL INFORMATION                *12810000
      *                                                                *12840000
      ******************************************************************12850000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 12880000
           PERFORM 2200-GET-IRR-LETTER-DETAILS     THRU 2200-EXIT.      
      *                                                                 12911000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16245000
      ******************************************************************42243600
      * 2200-GET-IRR-LETTER-DETAILS                                    *42243700
      *    -- THIS MODULE OPENS THE IRR-LETTER CURSOR, FETCHES THE     *42243800
      *       DETAIL INFORMATION FOR EACH GUARANTOR, SENDS THE RESULT, *42243900
      *       AND THEN CLOSES THE CURSOR.                              *42244000
      ******************************************************************42244500
       2200-GET-IRR-LETTER-DETAILS.                                     
      *                                                                 42244700
           PERFORM 5000-OPEN-IRR-LETTER-CURSOR   THRU 5000-EXIT.        
           PERFORM 5100-FETCH-IRR-LETTER-CURSOR THRU 5100-EXIT          
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7000-CLOSE-IRR-LETTER-CURSOR THRU 7000-EXIT.         
      *                                                                 42247900
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42284600
      ******************************************************************42284700
      * 5000-OPEN-IRR-LETTER-CURSOR                                    *42284800
      *       -- THIS MODULE OPENS THE COMPUTE IRR-LETTER CURSOR       *42284900
      ******************************************************************42285000
       5000-OPEN-IRR-LETTER-CURSOR.                                     
      *                                                                 42285200
           EXEC SQL                                                     
               OPEN IRR-LETTER                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42285700
           MOVE SQLCODE TO S-RETURN-CODE.                               
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'OPEN'                TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE IRR-LETTER-TYPE       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42287300
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42287800
      ******************************************************************42287900
      * 5100-FETCH-IRR-LETTER-CURSOR                                   *42288000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF CASH IRR-LETTER  *42288100
      *        DETAILS                                                 *42288200
      *                                                                *42288300
      ******************************************************************42288400
       5100-FETCH-IRR-LETTER-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH IRR-LETTER                                         
                  INTO :SB-CODE-STATUS,                                 
                       :BO-BOND-CO-NO,                                  
                       :SB-AMT-BOND,                                    
P26289                 :SB-DATE-BOND-ISSUED :DATE-BOND-ISSUE-IND,        
P26289                 :SB-USER-ID-ORIG-BY,                             
P26289                 :SB-LAST-UPDATE-DT,                              
P26289                 :SB-LAST-UPDATE-USERID,                          
                       :SB-BOND-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42289600
           MOVE SQLCODE TO S-RETURN-CODE.                               
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 42289900
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               PERFORM 7100-SELECT-BOND-CO        THRU 7100-EXIT        
P26289         IF SB-LAST-UPDATE-USERID = SPACES                        
P26289            IF DATE-BOND-ISSUE-IND = NULL-VALUE                   
P26289                MOVE SPACES TO S-DATE-LAST-UPDATED                
P26289            ELSE                                                  
P26289                MOVE SB-DATE-BOND-ISSUED TO S-DATE-LAST-UPDATED   
P26289            END-IF                                                
P26289            MOVE SB-USER-ID-ORIG-BY TO S-USERID-LAST-UPDATED      
P26289         ELSE                                                     
P26289            MOVE SB-LAST-UPDATE-DT TO S-DATE-LAST-UPDATED         
P26289            MOVE SB-LAST-UPDATE-USERID TO S-USERID-LAST-UPDATED   
P26289         END-IF                                                   
               PERFORM 8000-SET-RETURNS           THRU 8000-EXIT        
               PERFORM 8100-SEND-RESULT           THRU 8100-EXIT        
           ELSE IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5100'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'FETCH'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
T15609         MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE IRR-LETTER-TYPE       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 42291900
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42292300
      ******************************************************************42292400
      * 7000-CLOSE-IRR-LETTER-CURSOR                                   *42292500
      *       -- THIS MODULE CLOSES THE IRR-LETTER CURSOR              *42292600
      ******************************************************************42292700
       7000-CLOSE-IRR-LETTER-CURSOR.                                    
      *                                                                 42292900
           EXEC SQL                                                     
               CLOSE IRR-LETTER                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42293400
           MOVE SQLCODE TO S-RETURN-CODE.                               
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'CLOSE'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE IRR-LETTER-TYPE       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42295100
      *                                                                 42295200
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42295500
      *                                                                 42295600
      ******************************************************************42295700
      * 7100-SELECT-BOND-CO                                            *42295800
      *       -- THIS MODULE SELECT THE BOND CO NAME                   *42295900
      ******************************************************************42296000
       7100-SELECT-BOND-CO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT BOND_CO_NM                                        
               INTO   :BO-BOND-CO-NM                                    
               FROM   CSS_BOND_CO                                       
               WHERE  BOND_CO_NO = :BO-BOND-CO-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO S-RETURN-CODE.                               
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               MOVE SUCCESSFUL-CALL TO WS-ACTIVE-RETURN-CODE            
                                       S-RETURN-CODE                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE '7100'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
T15609         MOVE 'CSS_BOND_CO'         TO TABLE-1                    
T15609         MOVE 'BOND_CO_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
T15609         MOVE BO-BOND-CO-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 42299000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42299400
      ******************************************************************42299500
      * 8000 SET RETURNS                                               *42299600
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*42299700
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *42299800
      ******************************************************************42299900
       8000-SET-RETURNS.                                                
      *                                                                 42300100
           MOVE SB-CODE-STATUS            TO S-CODE-STATUS.             
           MOVE BO-BOND-CO-NM             TO S-BANK-NAME.               
           MOVE SB-AMT-BOND               TO S-AMT-BOND.                
           MOVE SB-BOND-NO                TO S-BOND-NO.                 
      *                                                                 42300600
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42300900
REARCH******************************************************************42299900
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************42299900
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02034_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02034_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02034_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************42299900
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************42299900
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02034_R1                        
REARCH           (                                                      
REARCH                CODE_STATUS                                       
P26289               ,DATE_LAST_UPDATED                                 
P26289               ,USERID_LAST_UPDATED                               
REARCH               ,BANK_NAME                                         
REARCH               ,AMT_BOND                                          
REARCH               ,BOND_NO                                           
REARCH               ,RETURN_CODE                                       
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (    :S-CODE-STATUS                                    
P26289               ,:S-DATE-LAST-UPDATED                              
P26289               ,:S-USERID-LAST-UPDATED                            
REARCH               ,:S-BANK-NAME                                      
REARCH               ,:S-AMT-BOND                                       
REARCH               ,:S-BOND-NO                                        
REARCH               ,:S-RETURN-CODE                                    
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02034_R1                                
MFA-TR*          (                                                              
MFA-TR*               CODE_STATUS                                               
MFA-TR*              ,DATE_LAST_UPDATED                                         
MFA-TR*              ,USERID_LAST_UPDATED                                       
MFA-TR*              ,BANK_NAME                                                 
MFA-TR*              ,AMT_BOND                                                  
MFA-TR*              ,BOND_NO                                                   
MFA-TR*              ,RETURN_CODE                                               
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (    :S-CODE-STATUS                                            
MFA-TR*              ,:S-DATE-LAST-UPDATED                                      
MFA-TR*              ,:S-USERID-LAST-UPDATED                                    
MFA-TR*              ,:S-BANK-NAME                                              
MFA-TR*              ,:S-AMT-BOND                                               
MFA-TR*              ,:S-BOND-NO                                                
MFA-TR*              ,:S-RETURN-CODE                                            
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02034_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      *                                                                 42301000
      ******************************************************************42301100
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *42301200
      ******************************************************************42301300
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************42302000
      * 9999- END PROGRAM COPYLIB                                      *42310000
      ******************************************************************42320000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
