       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02031.                                     
COB303 DATE-WRITTEN.      MAY 24, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S031                                           *00120006
      *  PROGRAM:       S031                                           *00130006
      *  CALLING SP:    PA_S031                                        *00140006
      *  PANEL:         057 -- SECURITIES                              *00141000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES CASH DEPOSITS SECURITES DETAIL       *00190000
      *  INFORMATION.                                                  *00202000
      *                                                                *00203000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  02/16/95    WMG      PROCEDURE ORIGINALLY CODED.              *00270000
      *  08/30/95    HC       CURRENT AMOUNT COLUMN ON PANEL057 SHOULD *00270100
      *                       BE = DO.AMT_DEPOSIT                      *00271000
TP5663*  10/01/96   ELJ       TPR 5663. PROBLEM EXIST WERE AN INVALID  *00271100
      *                       DATE IS CAUSING A -180 RETURN CODE. ALSO *00272000
      *                       THE PROGRAM IS RETURNING A NOT-FOUND     *00273000
      *                       RETURN CODE WHEN DATA IS SUCCESSFULLY    *00274000
      *                       RETRIEVED.                               *00275000
TP8081*  12/11/96   RTO       TPR 8081. MODIFIED TO MOVE ZEROS TO      *00276000
TP8081*                       INTEREST RATE IF TOTAL INTEREST OR       *00277000
TP8081*                       DATE-INST-CLAC-TO  HAVE NONVALID VALUES  *00278000
TP8109*  12/12/96   RTO       TPR 8109. MODIFIED TO INCREASE THE       *00279000
TP8109*                       WS-INTEREST-PERIOD TABLE TO HANDLE MORE  *00279100
TP8109*                       ENTRIES FROM THE DATABASE.               *00279200
TP8211*  01/17/97   MAC       MODIFIED TO MOVE WS-DEP-LESS-PAYMENT     *00279300
      *                       INTO RS-DEP-LESS-PAYMENT.                *00279400
PCR482*  02/06/97   MAD       MODIFIED THE DEPOSITS DATAWINDOW TO      *        
      *                       INCLUDE A NUMBER OF ADDITIONAL FIELDS.   *        
      *                       ALSO DEVELOPED CODE TO CALCULATE THE     *        
      *                       PROJECTED INTEREST AMOUNT AND PROJECTED  *        
      *                       INTEREST DATE AT TIME OF EXECUTION.      *        
TP9421*  02/20/97   PD        DELETED STRING PROCESSING FOR MIDDLE     *        
      *                       NAME AS WE WANT ONLY THE FIRST CHAR.     *        
TP9420*  02/20/97   PD        INITIALIZE ALL INTERNAL TABLE AT THE     *        
      *                       ENTRY OF THE PROGRAM.                    *        
TP9710*  03/18/97   MAD       ADDED A HOLD FIELD SO CPD00023 WOULD NOT *        
      *                       CHANGE THE VALUE OF DATE_INTST_CALC_TO.  *        
T12026*  07/09/97   MAD       DEPOSITS MUST BE HELD FOR AT LEAST ONE   *        
      *                       YEAR BEFORE THEY ARE ELIGIBLE FOR REFUND *        
      *                       THEREFORE 13 MONTHS WILL BE ADDED TO THE *        
      *                       DATE_PYMT_START FOR REFUND DATE DETER-   *        
      *                       MINATION.                                *        
MAD714*  07/14/97   MAD       PROJECTED REFUND DATE SHOULD DISPLAY FOR *        
      *                       ALL DEPOSITS THAT ARE 'BILLING' OR 'PAID'*        
      *                       - PROJECTED INTEREST APPLICATION DATE    *        
      *                       WILL NOW BE USED IN COMPUTING THE        *        
      *                       PROJECTED INTEREST AMOUNT (DATE WILL NOT *        
      *                       DISPLAY ON THE PANEL).                   *        
T14098*  12/18/97   MAD       MODIFIED THE PROJECTED INTEREST AMOUNT   *        
      *                       CALCULATION TO COMPUTE BASED ON THE      *        
      *                       FIRST DAY OF THE PROJECTED REFUND MONTH  *        
      *                       RATHER THAN THE LAST DAY - USERS WERE    *        
      *                       CONCERNED WITH THE POSSIBILITY OF QUOTING*        
      *                       A HIGHER INTEREST AMOUNT TO CUSTOMERS    *        
      *                       THAN THE WOULD ACTUALLY RECEIVE.         *        
T15609*  04/20/98    SHF      MODIFIED SO THAT VARIABLES LOAD CORRECTLY*        
      *                       BEFORE WRITING TO MC05 ERROR LOG.        *        
T16026*  04/21/98    SHF      IF DO-DATE-PYMT-START IS NULL, DO NOT    *        
      *                       PERFORM 7950-CALC-1YR-FROM-PMT.          *        
T16061*  04/23/98    SHF      FIX PROBLEM OF WRITING TO MC05 ERROR LOG *        
      *                       WHEN A ROW IS NOT RETURNED.              *        
T16204*  05/08/98    MDJ      CHANGED PROJECTED REFUND LOGIC TO NOT    *        
      *                       CONSIDER CONSECUTIVE ARREARS WHEN DOING  *        
      *                       DEPOSIT REFUND LOGIC.                    *        
CBSI  *  18/07/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    TABLE PARAMETERS                         *        
T21237*  01/17/00   MDJ       IF NORMAL OR EXCEPTIONAL CREDIT HISTORY  *        
      *                       OF 3,4,I,R EXISTS FOR THE LAST 12 MTHS   *        
      *                       DO NOT PROJECT THE DEP REFUND.  IF THESE *        
      *                       VALUES ARE NOT FOUND, CHECK ARREARS HIST.*        
T21844*  05/22/01   SMS       CORRECT SO THAT DEP REFUND WILL STILL BE *        
      *                      PROJECTED IF 2,3,4,I,R ARE FOUND IN CREDIT*        
      *                       HISTORY.  DATE WILL BE 13 MONTH FROM     *        
      *                       OCCURRENCE OF ONE OF THESE VALUES.       *        
C24646*  08/16/01   SR82046   CHANGED FOR V6 DB2 AS PER KENT           *        
C24808*  08/22/01   MDJ       PROJECTED REFUND DATE FOR PSNC, COMP=26  *        
      *                       SHOULD BE BLANK.                         *        
C25248*  10/02/01   MDJ       DECISION MADE 10/1 TO MOVE SPACES TO     *        
      *                       PROJ INTEREST RATE FOR PSNC.             *        
C27566*  12/31/02   BASKAR    ENABLE PROJECTED REFUND DATE AND INTEREST*        
C27566*                       AMOUNT FOR PSNC ACCOUNTS.                *        
T29249*  10/14/03   COVANSYS  CORRECT THE PROJECTED REFUND CRETERIA TO *        
T29249*                       NOT CONSIDER '2'S(SECOND NOTICES) IN     *        
T29249*                       CREDIT HISTORY WHEN FORECASTING THE PROJ-*        
T29249*                       ECTED REFUND DATE. ONLY CONSIDER 3,4,I   *        
T29249*                       AND R.                                   *        
C29752*  11/17/03   MDJ       IF MORE THAN 1 INTEREST RATE IS USED TO  *        
      *                       CALCULATE PROJ INTEREST, SEND ALL 9'S TO *        
      *                       PANEL 57.  PANEL 57 TRANSLATES THIS TO   *        
      *                       'MULTIPLE'.                              *        
C29752*  01/29/04   MDJ       CHANGED CALL SO THAT DATE-CERT-ISSUE     *        
      *                       IS SENT TO PB AS MM-DD-YYYY.             *        
T31662*  10/29/04   COVANSYS  MODIFIED THE CODE TO INCLUDE THE NEW SEB *        
T31662*             CHENNAI   REFUND RULE.                             *        
REARCH*  05/23/04   CVNS      RPC TO COBOL SP CONVERSION.              *        
REARCH*             CHENNAI                                            *        
T34097*  07/02/07   MC95456  REPLACED CSS_MODEL_SQL WITH SET STATEMENTS*        
P26289*  06/13/08   RB19957  FOR COMMERCIAL/INDUSTRIAL ACCTS USE THE   *        
P26289*          RICK BLACK  VALUES IN THE DELIQUENCY TABLE TO         *        
P26289*                      DETERMINE THE PROJECTED REFUND DATE.      *        
P00394*  06/24/10   SP95538  FOR RESIDENTIAL  DEPOSITS USE THE VALUES  *        
P00394*                      FROM THE DELINQUENCY TABLE.               *        
P00394*  08/20/10   VP94820  REMOVED HARD CODED VALUES IN COMPUTING             
P00394*                      REFUND FORECASTED DATE.                            
P00399*  08/20/10   MJ13662  FOR CSR ONLY, USE NEW COPYBOOK FOR GOOD   *        
P00399*                      CREDIT RULE - CPD00334.                   *        
P00399*                      CHANGED PROJECTED REFUND DATE CALCULATION.*        
P00399*                      REMOVED GRANDFATHERED LOGIC.              *        
P00399*                      ONCE THE OLDEST DEPOSIT PROJECTED REFUND  *        
P00399*                      DATE IS CALCULATED, COMPARE THIS DATE TO  *        
P00399*                      RATCHET DATE CALCULATED FOR ALL 'A' AND 'P'        
P00399*                      DEPOSITS.                                 *        
P00399* 11/10/10    MJ13662  MOVE COMPANY NO TO WS-COMPANY-CPD334.     *        
P00518**                                                                        
P00518**06/14/2011  WR19680   CHANGES DELINQUENCY VALUE FOR RESIDENTIAL         
P00518**                      DEPOSIT FROM 12 TO 24 MONTHS.  CHANGE   **        
P00518**                      TO CALCULATE REFUND PROJECTION DATE.  USE         
P00518**                      12 MTHS IF BEFORE WS-RES-SEC-DATE. THIS           
P00518**                      IS ONLY FOR SCEG RESIDENTIAL.                     
P00471**09/13/2011  SP95538   ADD '4' FOR PSNC GOOD CREDIT RULE.      **        
A04041**03/12/2012  MJ13662   IF CODE-REFUND-ELG = '0'OR ' ' CALCULATE**        
A04041**                      PROJ REFUND DATE, OTHERWISE SEND        **        
A04041**                      'INELIGIBLE' TO PANEL.                  **        
      ******************************************************************00290000
      *                                                                *00300000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310000
      *                                                                *00320000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350000
      *  3000 - 4999  NOT USED                                         *00360000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380000
      *  7000 - 7999  INPUT MODULES                                    *00390000
      *  8000 - 8999  OUTPUT MODULES                                   *00400000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410000
      *                                                                *00420000
      ******************************************************************00430000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02031'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02031 STARTS HERE'.                  
                                                                        
      ******************************************************************00520000
      *    DB2 INCLUDES                                                *00530000
      ******************************************************************00540000
      *                                                                 00550000
           EXEC SQL                                                     00560000
              INCLUDE SQLCA                                             00570000
           END-EXEC.                                                    00580000
      *                                                                 00580100
           EXEC SQL                                                     00580200
              INCLUDE TBMODEL                                           00580300
           END-EXEC.                                                    00580400
      *                                                                 00580500
           EXEC SQL                                                     00580600
              INCLUDE TBDEPHND                                          00580700
           END-EXEC.                                                    00580800
      *                                                                 00580900
           EXEC SQL                                                     00860000
              INCLUDE TBDEPHST                                          00870000
           END-EXEC.                                                    00880000
      *                                                                 00890000
           EXEC SQL                                                     00900000
              INCLUDE TBPREM                                            00910000
           END-EXEC.                                                    00920000
      *                                                                 00930000
           EXEC SQL                                                     00940000
              INCLUDE TBRVDST                                           00950000
           END-EXEC.                                                    00960000
      *                                                                 00970000
           EXEC SQL                                                     00980000
              INCLUDE TBDEPINT                                          00990000
           END-EXEC.                                                    00991000
      *                                                                 00992000
           EXEC SQL                                                     00993000
              INCLUDE TBARCNTL                                          00994000
           END-EXEC.                                                    00995000
      *                                                                 00996000
PCR482     EXEC SQL                                                     00997000
PCR482        INCLUDE TBCRPROF                                          00998000
PCR482     END-EXEC.                                                    00999000
      *                                                                 00996000
PCR482     EXEC SQL                                                     00997000
PCR482        INCLUDE TBUSRPRF                                          00998000
PCR482     END-EXEC.                                                    00999000
      *                                                                 01000000
PCR482     EXEC SQL                                                             
PCR482        INCLUDE TBINTHST                                                  
PCR482     END-EXEC.                                                            
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482        INCLUDE TBACCT                                                    
PCR482     END-EXEC.                                                            
      *                                                                         
T31662     EXEC SQL                                                             
T31662        INCLUDE TBDELQ                                                    
T31662     END-EXEC.                                                            
      *                                                                         
      ******************************************************************01100000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01110000
      ******************************************************************01120000
                                                                        
           COPY CCA00001.                                               01160000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
P00399******************************************************************        
P00399*  GOOD CREDIT RULE COPY WORKING STORAGE.                        *        
P00399******************************************************************        
P00399     COPY CWS00334.                                                       
           COPY CWS00027.                                               01180000
           COPY CWS00303.                                               01190000
      *                                                                         
T23980     EXEC SQL                                                             
T23980         INCLUDE CWS0024B                                                 
T23980     END-EXEC.                                                            
      *                                                                         
                                                                        
      ******************************************************************01210000
      *    WORK AREAS                                                  *01220000
      ******************************************************************01230000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02031_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH      05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02031'.     
REARCH      05  WS-SQLSTATE             PIC X(5).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01620000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)   COMP.                
           05  WRKLEN1                 PIC S9(9)   COMP.                
           05  WRKLEN2                 PIC S9(9)   COMP.                
           05  WRK-DONE-STATUS         PIC S9(9)   COMP.                
           05  WS-COUNT                PIC S9(04)V USAGE COMP-3         
                                                   VALUE +1.            
PCR482     05  WS-COUNTER              PIC S9(04) COMP.                 
           05  WS-INTEREST-PERIODS     PIC S9(04)V USAGE COMP-3         
                                                   VALUE +0.            
COB305     05 WS-DAYS        PIC S9(04)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-DAYS-CHECK        PIC S9(04)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-TEMP-INTEREST        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-PERIOD-1             PIC X(10)   VALUE SPACES.        
           05  WS-PERIOD-2             PIC X(10)   VALUE SPACES.        
           05  STOP-SEARCH             PIC X(01)   VALUE 'N'.           
           05  VALUE-YES               PIC X(01)   VALUE 'Y'.           
           05  VALUE-NO                PIC X(01)   VALUE 'N'.           
           05  PERCENTAGE              PIC S9(04)V USAGE COMP-3         
                                                   VALUE +100.          
           05  ONE-YEAR                PIC S9(04)V USAGE COMP-3         
                                                   VALUE +365.          
           05  BILL-ACTIVE             PIC X(01)   VALUE 'A'.           
           05  BILL-DELETED            PIC X(01)   VALUE 'D'.           
           05  DEPOSIT-TYPE            PIC S9(04) COMP VALUE 80.        
TP9710     05  WS-DT-INT-CALC-TO-HOLD  PIC X(10)   VALUE SPACES.        
           05  WS-LAST-BILL-DATE       PIC X(10)   VALUE SPACES.        
C24808     05  WS-PSNC                 PIC X(02)   VALUE '26'.          
C29752     05  WS-NINES                PIC S9(02)V9(04) VALUE +99.9999. 
T31662     05  WS-LIMIT-MONTH          PIC S9(04) COMP.                 
T31662     05  WS-DATE-DEP-PAID        PIC X(10) VALUE SPACES.          
T31662     05  WS-REFUND-RULE          PIC 9(01) VALUE ZERO.            
T31662         88  CSR-REFUND-RULE               VALUE 1.               
T31662         88  SEB-REFUND-RULE               VALUE 2.               
P00399     05  WS-OLDEST-PMT-SW        PIC 9(01) VALUE 1.               
P00399         88  DO-NOT-HAVE-OLDEST-PMT        VALUE 1.               
P00399         88  HAVE-OLDEST-PMT               VALUE 2.               
P26289     05  WS-GRAND-FATHER-DEPOSIT PIC X(01) VALUE SPACE.           
P26289     05  WS-DELINQ-VALUE9        PIC 9999V9999.                   
P26289     05  WS-DELINQ-VALUEX REDEFINES WS-DELINQ-VALUE9 PIC X(09).   
P26289     05  WS-DEP-DATE-TRAN.                                        
P26289         10  WS-DEP-DATE-TRAN-CCYY PIC X(4) VALUE SPACES.         
P26289         10  WS-FILLER1            PIC X(1) VALUE '-'.            
P26289         10  WS-DEP-DATE-TRAN-MM   PIC X(2) VALUE SPACES.         
P26289         10  WS-FILLER2            PIC X(1) VALUE '-'.            
P26289         10  WS-DEP-DATE-TRAN-DD   PIC X(2) VALUE SPACES.         
P26289     05  WS-DEPOSIT-TYPE           PIC X(1).                      
P26289         88 WS-COM-IND-DEPOSIT          VALUE 'C'                 
P26289                                              'I'.                
P00471     05  WS-DISCONNECT-HIST-CZ     PIC X(24)  VALUE SPACES.       
P00471     05  WS-DISC-EXCEPTN-HIST-CZ   PIC X(24)  VALUE SPACES.       
P00518     05  WS-RES-SECUR-START-DATE.                                 
P00518         10  WS-RES-SECUR-DATE.                                   
P00518             15  WS-RES-DATE-CCYY      PIC X(4) VALUE SPACES.     
P00518             15  WS-FILLER1-RES        PIC X(1) VALUE '-'.        
P00518             15  WS-RES-DATE-MM        PIC X(2) VALUE SPACES.     
P00518             15  WS-FILLER2-RES        PIC X(1) VALUE '-'.        
P00518             15  WS-RES-DATE-DD        PIC X(2) VALUE SPACES.     
P00518 01  WS-DO-DATE-TRANS                  PIC X(10) VALUE SPACES.    
      *                                                                         
      *                                                                 02380800
       01  WS-INTEREST-ARRAY.                                           
TP8109     05  WS-INTEREST-PERIOD OCCURS 240 TIMES.                     
                10  WS-INTEREST-RATE   PIC S9(02)V9(04) USAGE COMP-3    
                                                        VALUE 0.        
                10  WS-INTEREST-DATE   PIC X(10) VALUE SPACES.          
      *                                                                 02381500
      *                                                                 02381800
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T31662     05  WS-UTILITY-ARREARS-SW   PIC X(01) VALUE 'N'.             
T31662         88 UTILITY-ARREARS-FOUND          VALUE 'Y'.             
T31662         88 UTILITY-ARREARS-NOT-FOUND      VALUE 'N'.             
T21237     05  WS-DISC-HIST-SW         PIC X(01) VALUE 'N'.             
T21237         88 DISC-HIST-FOUND                VALUE 'Y'.             
T21237         88 DISC-HIST-NOT-FOUND            VALUE 'N'.             
PCR482     05  WS-PREVIOUS-ARREARS-SW  PIC X(01) VALUE 'N'.             
PCR482         88 PREVIOUS-ARREARS-FOUND         VALUE 'Y'.             
           05  WS-2ND-PREV-ARREARS-SW  PIC X(01) VALUE 'N'.             
               88 2ND-PREV-ARREARS-FOUND         VALUE 'Y'.             
PCR482     05  WS-NON-CONSEC-ARREARS-SW PIC X(01) VALUE 'N'.            
PCR482         88 NON-CONS-ARREARS-FOUND         VALUE 'Y'.             
PCR482         88 NON-CONS-ARREARS-NOT-FOUND     VALUE 'N'.             
           05  WS-DEPOSITS-SW           PIC X(01) VALUE 'N'.            
               88 NO-MORE-DEPOSITS               VALUE 'Y'.             
      *                                                                 02383600
A04041 01  WS-LITERALS.                                                 
A04041     05  WS-INELIGIBLE           PIC X(10)  VALUE 'INELIGIBLE'.   
A04041*                                                                         
       01  NULL-INDICATORS.                                             
           05  DATE-CERT-ISSUE-IND     PIC S9(04) COMP VALUE 0.         
           05  DATE-TRAN-IND           PIC S9(04) COMP VALUE 0.         
PCR482     05  DATE-TRAN-IND2          PIC S9(04) COMP VALUE 0.         
           05  PROJECTED-CR-DT-IND     PIC S9(04) COMP VALUE 0.         
           05  INTRST-RATE-IND         PIC S9(04) COMP VALUE 0.         
           05  REV-DISTRICT-DESC-IND   PIC S9(04) COMP VALUE 0.         
           05  DATE-INTST-CALC-TO-IND  PIC S9(04) COMP VALUE 0.         
           05  GENERAL-IND             PIC S9(04) COMP VALUE 0.         
           05  DEP-LESS-PAYMENT-IND    PIC S9(04) COMP VALUE 0.         
           05  NULL-VALUE              PIC S9(04) COMP VALUE -1.        
PCR482     05  WS-NULL-PAYMENT         PIC S9(04) COMP VALUE 0.         
PCR482     05  WS-NULL-LAST-PAY        PIC S9(04) COMP VALUE 0.         
TP9710     05  DT-INT-CALC-TO-HOLD-IND PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-BILL-DAY-00-NI  PIC S9(04) COMP VALUE 0.         
T12026     05  DATE-PYMT-START-IND     PIC S9(04) COMP VALUE 0.         
      *                                                                 02384800
       01  RS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-PARM          PIC X(13).                      
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-PREMISE-PARM          PIC X(10).                      
           05  WS-PREMISE-DEC REDEFINES WS-PREMISE-PARM                 
                                        PIC 9(10).                      
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05  WS-LOCAL-OFFICE-NO       PIC X(03) VALUE SPACES.         
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
           05  WS-REVENUE-DIST          PIC X(03) VALUE SPACES.         
COB305     05 WS-TOTAL-PAYMENTS        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-NEW-PAYOFF        PIC S9(07)V99 USAGE COMP-3 VALUE 0.     
PCR482     05  WS-CREDIT-PROFILE        PIC X(24) VALUE SPACES.         
T31662     05  WS-HOLD-UTILITY-ARREARS  PIC S9(04) COMP VALUE +0.       
PCR482     05  WS-HOLD-NON-CONSEC-ARREARS                               
PCR482                                  PIC S9(04) COMP VALUE +0.       
T21844     05  WS-HOLD-DISC-HIST        PIC S9(04) COMP VALUE +0.       
T21844     05  WS-HOLD-DISC-EXC-HIST    PIC S9(04) COMP VALUE +0.       
PCR482     05  WS-MONTHS-TEMP           PIC S9(04) COMP VALUE +0.       
PCR482     05  WS-MONTHS-SQL            PIC S9(04) COMP VALUE +0.       
P00399     05  WS-CALC                  PIC S9(04) COMP VALUE +0.       
T31662     05  WS-CALC-DT-FROM-PMT      PIC X(10) VALUE SPACES.         
T31662     05  WS-NEXT-DATE-FOR-CALC    PIC X(10) VALUE SPACES.         
           05  WS-INTEREST-CALC-DATE    PIC X(10) VALUE SPACES.         
PCR482     05  WS-PROJ-RFND-DATE        PIC X(10) VALUE SPACES.         
PCR482     05  WS-RFND-DATE-HOLD.                                       
PCR482         10  WS-RFND-DATE-MM      PIC X(02) VALUE SPACES.         
PCR482         10  FILLER               PIC X(01) VALUE '/'.            
PCR482         10  WS-RFND-DATE-YY      PIC X(02) VALUE SPACES.         
PCR482     05  WS-RFND-DATE-PASS.                                       
PCR482         10  WS-RFND-PASS-YYYY    PIC X(04).                      
PCR482         10  FILLER               PIC X(01) VALUE '-'.            
PCR482         10  WS-RFND-PASS-MM      PIC X(02).                      
PCR482         10  FILLER               PIC X(01) VALUE '-'.            
PCR482         10  WS-RFND-PASS-DD      PIC X(02).                      
C29752     05  WS-DCERT-ISSUE.                                          
C29752         10  WS-DCERT-MM          PIC X(02).                      
C29752         10  FILLER               PIC X(01) VALUE '/'.            
C29752         10  WS-DCERT-DD          PIC X(02).                      
C29752         10  FILLER               PIC X(01) VALUE '/'.            
C29752         10  WS-DCERT-YYYY        PIC X(04).                      
PCR482     05  WS-HOLD-SQL-COMP-DT      PIC X(10) VALUE '1900-01-01'.   
PCR482     05  WS-HOLD-ID-INPUT         PIC X(07).                      
PCR482     05  WS-HOLD-NAME-OUTPUT      PIC X(29).                      
PCR482     05  WS-SUB                   PIC S9(8) COMP VALUE ZERO.      
PCR482     05  CN-DELIMITER             PIC X VALUE ';'.                
PCR482     05  WS-FROM.                                                 
PCR482         10  WS-FROM-X              OCCURS 51 TIMES PIC X.        
           05  WS-REV-MTH-HOLD          PIC 9(06).                      
           05  WS-REV-MTH-CHAR REDEFINES WS-REV-MTH-HOLD                
                                        PIC X(06).                      
      *                                                                 02387000
      *                                                                 02387500
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02387900
       01  WS-HOST-VARIABLES.                                           
           05  WS-DEP-LESS-REFUND      PIC S9(09)V99 USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-DEP-LESS-PAYMENT     PIC S9(09)V99 USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-PROJ-INT-AMT         PIC S9(09)V99 USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-CURRENT-DATE         PIC X(10)     VALUE SPACES.      
PCR482     05  WS-DUMMY-TRAN           PIC X(10)     VALUE SPACES.      
PCR482     05  WS-LAST-PAY-DT          PIC X(10)     VALUE SPACES.      
           05  RS-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
      *                                                                 02576600
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-DEPOSIT-STATUS-CD    PIC X(01)        VALUE SPACES.    
COB305     05 S-DEP-LESS-REFUND        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.    
REARCH     05  S-DATE-TRAN            PIC X(10)        VALUE SPACES.    
REARCH     05  S-DATE-CERT-ISSUE      PIC X(10)        VALUE SPACES.    
REARCH     05  S-SERVICE-TYPE-CD      PIC X(01)        VALUE SPACES.    
REARCH     05  S-USER-NAME-UPDT-BY    PIC X(29)        VALUE SPACES.    
COB305     05 S-DEP-LESS-PAYMENT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.    
REARCH     05  S-DEPOSIT-CERT-NO      PIC S9(09)       USAGE COMP.      
A04041     05  S-PROJECTED-CR-DT      PIC X(10)        VALUE SPACES.    
REARCH     05  S-PROJ-INT-AMT         PIC S9(09)V99    USAGE COMP-3     
REARCH                                                 VALUE 0.         
REARCH     05  S-REV-DISTRICT-DESC    PIC X(35)        VALUE SPACES.    
COB305     05 S-INTRST-RATE        PIC S9(02)V9(04) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 S-TOTAL-INTRST        PIC S9(07)V99 USAGE COMP-3 VALUE 0.    
REARCH     05  S-DATE-INTST-CALC-TO   PIC X(10)        VALUE SPACES.    
COB305     05 S-DEPOSIT-PAYOFF        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.    
REARCH*                                                                 02520000
REARCH     05  S-RETURN-CODE          PIC S9(9)      COMP VALUE 0.      
      *                                                                 02387416
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *****************************************************************         
      *               INCLUDE EXTERNAL WORKING STORAGE                *         
      *****************************************************************         
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482         INCLUDE CWS0223B                                                 
PCR482     END-EXEC.                                                            
      *                                                                         
      ******************************************************************03981700
      *                         CURSORS                                *03982000
      ******************************************************************03983000
      *                                                                 03984000
           EXEC SQL                                                     
               DECLARE DEPOSITS CURSOR FOR                              
                  SELECT DO.DEPOSIT_STATUS_CD,                          
                         DO.SERVICE_TYPE_CD,                            
                         DO.AMT_DEPOSIT,                                
                         CIS.CHAR2$DATE(DO.DATE_TRAN, 'USA'),                   
                         DO.DATE_TRAN,                                  
                         DO.USER_ID_UPDT_BY,                            
                         CIS.CHAR2$DATE(DO.DATE_CERT_ISSUE, 'USA'),             
                         DO.DEPOSIT_CERT_NO,                            
                         CIS.CHAR2$DATE(DO.PROJECTED_CR_DT, 'USA'),             
                         DO.TOTAL_INTRST,                               
                         CIS.CHAR2$DATE(DO.DATE_INTST_CALC_TO, 'USA'),          
                         DO.DATE_INTST_CALC_TO,                         
                         DO.CODE_REFUND_STATUS,                         
T12026                   DO.DATE_PYMT_START,                            
A04041                   DO.CODE_REFUND_ELIG                            
                    FROM CSS_DEP_ON_HAND AS DO                          
                   WHERE DO.ACCOUNT_NO = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04010000
MFA-TR*        DECLARE DEPOSITS CURSOR FOR                              04020000
MFA-TR*           SELECT DO.DEPOSIT_STATUS_CD,                          04030000
MFA-TR*                  DO.SERVICE_TYPE_CD,                            04031000
MFA-TR*                  DO.AMT_DEPOSIT,                                04032000
MFA-TR*                  CHAR(DO.DATE_TRAN, USA),                       04033000
MFA-TR*                  DO.DATE_TRAN,                                          
MFA-TR*                  DO.USER_ID_UPDT_BY,                            04034000
MFA-TR*                  CHAR(DO.DATE_CERT_ISSUE, USA),                 04035000
MFA-TR*                  DO.DEPOSIT_CERT_NO,                            04037000
MFA-TR*                  CHAR(DO.PROJECTED_CR_DT, USA),                 04038000
MFA-TR*                  DO.TOTAL_INTRST,                               04039900
MFA-TR*                  CHAR(DO.DATE_INTST_CALC_TO, USA),              04040000
MFA-TR*                  DO.DATE_INTST_CALC_TO,                                 
MFA-TR*                  DO.CODE_REFUND_STATUS,                                 
MFA-TR*                  DO.DATE_PYMT_START,                                    
MFA-TR*                  DO.CODE_REFUND_ELIG                                    
MFA-TR*             FROM CSS_DEP_ON_HAND AS DO                          04041000
MFA-TR*            WHERE DO.ACCOUNT_NO = :WS-ACCOUNT-NO                 04060000
MFA-TR*    END-EXEC.                                                    04080000
      *                                                                 04090000
      ******************************************************************04100000
      *                                                                 04101000
      ******************************************************************06763000
      *                                                                 06763100
HPCCDM*EJECT                                                            06763200
      *                                                                 06764000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-PREMISE-NO         PIC X(10).                           
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-PREMISE-NO.                       
      *                                                                 06780100
      *                                                                 06785000
      ******************************************************************06790000
      * 0000-MAINLINE                                                  *06800000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06810000
      ******************************************************************06820000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06940000
      * 0100-INITIALIZE                                                *06950000
      *                                                                *06960000
      *     1. RESET DB2 ERROR HANDLERS                                *06970000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *06980000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *06990000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07000000
      *                                                                *07010000
      ******************************************************************07020000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           DEPOSIT_STATUS_CD                                      
REARCH          ,DEP_LESS_REFUND                                        
REARCH          ,DATE_TRAN                                              
REARCH          ,DATE_CERT_ISSUE                                        
REARCH          ,DEPOSIT_PAYOFF                                         
REARCH          ,DEPOSIT_CERT_NO                                        
REARCH          ,PROJECTED_CR_DT                                        
REARCH          ,PROJ_INT_AMT                                           
REARCH          ,INTRST_RATE                                            
REARCH          ,TOTAL_INTRST                                           
REARCH          ,DATE_INTST_CALC_TO                                     
REARCH          ,LTRIM(RTRIM(REV_DISTRICT_DESC))   AS REV_DISTRICT_DESC        
REARCH          ,LTRIM(RTRIM(USER_NAME_UPDT_BY))   AS USER_NAME_UPDT_BY        
REARCH          ,SERVICE_TYPE_CD                                        
REARCH          ,RETURN_CODE                                            
REARCH         FROM                                                     
REARCH             #CSR02031_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          DEPOSIT_STATUS_CD                                              
MFA-TR*         ,DEP_LESS_REFUND                                                
MFA-TR*         ,DATE_TRAN                                                      
MFA-TR*         ,DATE_CERT_ISSUE                                                
MFA-TR*         ,DEPOSIT_PAYOFF                                                 
MFA-TR*         ,DEPOSIT_CERT_NO                                                
MFA-TR*         ,PROJECTED_CR_DT                                                
MFA-TR*         ,PROJ_INT_AMT                                                   
MFA-TR*         ,INTRST_RATE                                                    
MFA-TR*         ,TOTAL_INTRST                                                   
MFA-TR*         ,DATE_INTST_CALC_TO                                             
MFA-TR*         ,STRIP(REV_DISTRICT_DESC)   AS REV_DISTRICT_DESC                
MFA-TR*         ,STRIP(USER_NAME_UPDT_BY)   AS USER_NAME_UPDT_BY                
MFA-TR*         ,SERVICE_TYPE_CD                                                
MFA-TR*         ,RETURN_CODE                                                    
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02031_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02031_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02031_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02031_R1
               (                                                       
REARCH              DEPOSIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,DEP_LESS_REFUND        DECIMAL(11,2)                
REARCH             ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,DATE_CERT_ISSUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,DEPOSIT_PAYOFF         DECIMAL(9,2)                 
REARCH             ,DEPOSIT_CERT_NO        INT                      
REARCH             ,PROJECTED_CR_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,PROJ_INT_AMT           DECIMAL(11,2)                
REARCH             ,INTRST_RATE            DECIMAL(6,4)                 
REARCH             ,TOTAL_INTRST           DECIMAL(9,2)                 
REARCH             ,DATE_INTST_CALC_TO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,REV_DISTRICT_DESC CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,USER_NAME_UPDT_BY CHAR(29)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,SERVICE_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,RETURN_CODE            INT                      
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02031_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************07300000
      * 1000-PROCESS-INPUT                                             *07310000
      *                                                                *07320000
      *     1. RECEIVE PARMS.                                          *07330000
      *                                                                *07350000
      ******************************************************************07360000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12764300
      ******************************************************************12764400
      * 1150 ASSIGN-WS-VARS                                            *12764500
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *12764600
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *12764700
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *12764800
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *12764900
      *        SELECT STATEMENTS.                                      *12765000
      ******************************************************************12765100
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 12767000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-PARM.               
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
      *                                                                 12770200
           MOVE PARM-PREMISE-NO       TO WS-PREMISE-PARM.               
           MOVE WS-PREMISE-DEC        TO WS-PREMISE-NO.                 
      *                                                                 12770600
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12771100
      ******************************************************************12772000
      * 2000-PROCESS-OUTPUT.                                           *12780000
      *                                                                *12790000
      *     1. DESCRIBE RESULT SET                                     *12800000
      *     2. FETCH CASH DEPOSITS DETAIL INFORMATION                  *12810000
      *                                                                *12840000
      ******************************************************************12850000
      *                                                                 12860000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 12880000
           PERFORM 2050-INITIALIZE               THRU 2050-EXIT.        
           PERFORM 2125-GET-CURRENT-DATE         THRU 2125-EXIT.        
           PERFORM 2171-GET-LOCAL-OFFICE         THRU 2171-EXIT.        
           PERFORM 2150-GET-REVENUE-DISTRICT     THRU 2150-EXIT.        
PCR482     PERFORM 2400-GET-PROJ-RFND-DATE       THRU 2400-EXIT.        
           PERFORM 2200-GET-CASH-DEPOSIT-DETAILS THRU 2200-EXIT.        
      *                                                                 12911000
T16061     IF CTR-ROWS < 1                                              
T16061         INITIALIZE GTT-RETURN-FIELDS                             
T16061         MOVE -1 TO RS-RETURN-CODE                                
P26289         MOVE RS-RETURN-CODE        TO S-RETURN-CODE              
T16061         PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
T16061     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12940000
      ******************************************************************12950000
      * 2050-INITIALIZE.                                               *12960000
      *                                                                *12970000
      *     INITIALIZE ALL INTERNAL TABLES.                            *12980000
      *                                                                *12990000
      ******************************************************************13000000
       2050-INITIALIZE.                                                 
                                                                        
           INITIALIZE        WS-INTEREST-RATE-TABLE.                    
      *                                                                 13021000
       2050-EXIT.                                                       
P00399     EXIT.                                                        
      *                                                                 13021000
      ******************************************************************16248800
      * 2125-GET-CURRENT-DATE                                          *16248900
      *       -- THIS MODULE GETS THE CURRENT SYSTEM DATE              *16249000
      ******************************************************************16249100
       2125-GET-CURRENT-DATE.                                           
      *                                                                 16249300
           EXEC SQL                                                     
T34097         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16249400
MFA-TR*        SET :WS-CURRENT-DATE  =  CURRENT DATE                            
MFA-TR*    END-EXEC.                                                    16249800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16249900
           MOVE SQLCODE                 TO RS-RETURN-CODE.              
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 16250200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '2125'              TO ACTIVE-PARAGRAPH             
T34097         MOVE 'SET'               TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
CBSI           MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 16251600
       2125-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16251600
      ******************************************************************16254100
      * 2150-GET-REVENUE-DISTRICT                                      *16254200
      *       -- THIS MODULE GETS THE REVENUE DISTRICT FOR THE ACCOUNT *16254300
      *          DEPOSIT.                                               16254400
      ******************************************************************16254500
       2150-GET-REVENUE-DISTRICT.                                       
      *                                                                 16254700
           EXEC SQL                                                     
               SELECT REV_DISTRICT_DESC,                                
                      REV_DISTRICT_CD                                   
                 INTO :A9-REV-DISTRICT-DESC :REV-DISTRICT-DESC-IND,      
                      :A9-REV-DISTRICT-CD                               
                 FROM CSS_REV_DISTRICT                                  
                WHERE REV_DISTRICT_CD =                                 
                                (SELECT REV_DISTRICT_CD                 
                                   FROM CSS_PREMISE                     
                                  WHERE PREMISE_NO = :WS-PREMISE-NO)    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16255700
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 16256000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
               (REV-DISTRICT-DESC-IND = SUCCESSFUL-CALL))               
               MOVE A9-REV-DISTRICT-DESC  TO S-REV-DISTRICT-DESC        
               MOVE A9-REV-DISTRICT-CD    TO WS-REVENUE-DIST            
           ELSE IF ((WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR              
                    (REV-DISTRICT-DESC-IND = NULL-VALUE))               
               MOVE 'NONE'                TO S-REV-DISTRICT-DESC        
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2150'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_REV_DISTRICT'    TO TABLE-1                    
CBSI           MOVE 'CSS_PREMISE'         TO TABLE-2                    
T15609         MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
T15609         MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 16360000
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16400000
      ******************************************************************16410000
      * 2171-GET-LOCAL-OFFICE                                          *16420000
      *       -- THIS MODULE GETS THE LOCAL OFFICE                     *16430000
      ******************************************************************16450000
       2171-GET-LOCAL-OFFICE.                                           
      *                                                                 16470000
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     COMPANY_NO                                         
               INTO :WS-LOCAL-OFFICE-NO,                                
                    :WS-COMPANY-NO                                      
               FROM CSS_PREMISE                                         
              WHERE PREMISE_NO = :WS-PREMISE-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16571000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 16610000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2171'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_PREMISE'         TO TABLE-1                    
               MOVE 'PREMISE_NO '         TO TABLE-ELEMENT-1            
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
T15609         MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 16659200
       2171-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************42243600
      * 2200-GET-CASH-DEPOSIT-DETAILS                                  *42243700
      *    -- THIS MODULE OPENS THE DEPOSITS CURSOR, FETCHES THE       *42243800
      *       DETAIL INFORMATION FOR EACH DEPOSIT, SENDS THE RESULT,   *42243900
      *       AND THEN CLOSES THE CURSOR.                              *42244000
      ******************************************************************42244500
       2200-GET-CASH-DEPOSIT-DETAILS.                                   
      *                                                                 42244700
           PERFORM 5000-OPEN-DEPOSITS-CURSOR     THRU 5000-EXIT.        
           PERFORM 5100-FETCH-DEPOSITS-CURSOR    THRU 5100-EXIT         
               UNTIL NO-MORE-DEPOSITS.                                  
           PERFORM 7000-CLOSE-DEPOSITS-CURSOR    THRU 7000-EXIT.        
      *                                                                 42245700
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42248200
      ******************************************************************42285900
      * 2301-GET-DEP-LESS-PAY.                                         *42286000
      *       -- THIS MODULE CHECKS TO SEE IF THE DEPOSIT HAS A PAYMENT*42287000
      *          ASSOCIATED WITH IT FROM THE A/R CNTL TABLE.           *42288000
      ******************************************************************42289400
       2301-GET-DEP-LESS-PAY.                                           
      *                                                                 42289900
           EXEC SQL                                                     
               SELECT AMT_TRAN_BALANCE                                  
                 INTO :WS-DEP-LESS-PAYMENT :DEP-LESS-PAYMENT-IND         
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND ITEM_ID           = :DO-DEPOSIT-CERT-NO           
                  AND PYMT_PRIORITY_LVL = :DEPOSIT-TYPE                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42291000
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 42291400
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               IF DEP-LESS-PAYMENT-IND = NULL-VALUE                     
                   MOVE 0               TO WS-DEP-LESS-PAYMENT          
               END-IF                                                   
           ELSE IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                  
               MOVE 0                   TO WS-DEP-LESS-PAYMENT          
               MOVE SUCCESSFUL-CALL     TO SQLCODE                      
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '2301'              TO ACTIVE-PARAGRAPH             
               MOVE 'SELECT'            TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
               MOVE 'CSS_AR_CNTL'       TO TABLE-1                      
               MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
T15609         MOVE 'ITEM_ID'           TO TABLE-ELEMENT-2              
T15609         MOVE 'PYMT-PRIORITY-LVL' TO TABLE-ELEMENT-3              
T15609         MOVE WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
T15609         MOVE DO-DEPOSIT-CERT-NO  TO HOSTVAR-ELEMENT-2            
T15609         MOVE DEPOSIT-TYPE        TO HOSTVAR-ELEMENT-3            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 42293400
       2301-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42293800
      ******************************************************************42293900
      * 2400-GET-PROJ-RFND-DATE                                        *42294000
      *       -- THIS MODULE CALCULATES THE PROJECTED REFUND DATE WHICH*42294100
      *          WILL BE SENT BACK TO THE DESKTOP.                     *42294200
T16204* CONSECUTIVE ARREARS LOGIC HAS BEEN REMOVED.                    *        
T21237* NORMAL & EXCEPTIONAL CREDIT HISTORY WILL ALSO BE CHECKED FOR   *        
      * 3, 4, I OR R IN THE LAST 12 MTHS.  IF EXISTS DO NOT PROJECT REF*        
P00399* FOR CSR, COPYBOOK CPD00334 WILL BE USED FOR 'GOOD CREDIT RULE'.*        
P00399* SEB STAYS AS IS FOR NOW.                                       *        
      ******************************************************************42294300
PCR482 2400-GET-PROJ-RFND-DATE.                                         
      *                                                                 42294500
PCR482     MOVE WS-ACCOUNT-NO       TO CZ-ACCOUNT-NO,                   
                                       AT-ACCOUNT-NO,                   
P00518                                 DO-ACCOUNT-NO.                   
      *                                                                 42294700
T31662     MOVE 'DATABASE'               TO C8-DELINQ-CD.               
T31662     MOVE WS-COMPANY-NO            TO AT-COMPANY-NO.              
T31662     PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT.                
T31662     MOVE C8-DELINQ-VALUE          TO WS-REFUND-RULE.             
      *                                                                         
P00394     MOVE 'RETAIN-RESIDENT-DEP'    TO  C8-DELINQ-CD               
P00394     PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT.                
P00394     MOVE C8-DELINQ-VALUE          TO WS-LIMIT-MONTH.             
      *                                                                         
PCR482     PERFORM 7800-GET-CRED-PROFILE            THRU 7800-EXIT.     
P00471     MOVE CZ-DISCONNECT-HIST   TO WS-DISCONNECT-HIST-CZ.          
P00471     MOVE CZ-DISC-EXCEPTN-HIST TO WS-DISC-EXCEPTN-HIST-CZ.        
P00471     MOVE WS-DISCONNECT-HIST-CZ    TO WS-ACCT-DISCONNECT-HST.     
P00471     MOVE WS-DISC-EXCEPTN-HIST-CZ  TO WS-ACCT-DISC-EXCEPTN-HST.   
      *                                                                 42294900
P26289     PERFORM 7850-GET-LAST-BILL-DT-ACCT-TYP THRU 7850-EXIT.       
P26289     MOVE AT-ACCOUNT-TYPE-CODE TO WS-DEPOSIT-TYPE.                
P26289     IF WS-COM-IND-DEPOSIT AND CSR-REFUND-RULE                    
P26289        MOVE AT-COMPANY-NO                TO  C8-COMPANY-NO       
P26289        IF AT-ACCOUNT-TYPE-CODE = 'C'                             
P26289            MOVE 'RETAIN-COMMER-DEP' TO  C8-DELINQ-CD             
P26289        ELSE                                                      
P26289            MOVE 'RETAIN-INDUST-DEP' TO  C8-DELINQ-CD             
P26289        END-IF                                                    
P26289        PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT              
P26289        MOVE C8-DELINQ-VALUE              TO WS-LIMIT-MONTH       
P26289*                                                                         
P26289        MOVE AT-COMPANY-NO                TO  C8-COMPANY-NO       
P26289        MOVE 'COM-IND-START-DATE'         TO  C8-DELINQ-CD        
P26289        PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT              
P26289        MOVE C8-DELINQ-VALUE              TO WS-DELINQ-VALUE9     
P26289        MOVE WS-DELINQ-VALUEX(1:4)        TO WS-DEP-DATE-TRAN-CCYY
P26289        MOVE WS-DELINQ-VALUEX(5:2)        TO WS-DEP-DATE-TRAN-MM  
P26289        MOVE WS-DELINQ-VALUEX(7:2)        TO WS-DEP-DATE-TRAN-DD  
P26289*                                                                         
P26289        MOVE WS-ACCOUNT-NO TO DO-ACCOUNT-NO                       
P26289        MOVE WS-DEP-DATE-TRAN TO DO-DATE-TRAN                     
P00518     ELSE                                                         
P00518        IF CSR-REFUND-RULE AND AT-COMPANY-NO = '01'               
P00518           MOVE 'RES-SECUR-START-DATE' TO  C8-DELINQ-CD           
P00518           PERFORM 6600-GET-DELINQ-VALUE THRU 6600-EXIT           
P00518           MOVE C8-DELINQ-VALUE   TO WS-DELINQ-VALUE9             
P00518           MOVE WS-DELINQ-VALUEX(1:4) TO WS-RES-DATE-CCYY         
P00518           MOVE WS-DELINQ-VALUEX(5:2) TO WS-RES-DATE-MM           
P00518           MOVE WS-DELINQ-VALUEX(7:2) TO WS-RES-DATE-DD           
P00518           MOVE '-'                   TO WS-FILLER1-RES           
P00518                                         WS-FILLER2-RES           
P00518           MOVE WS-RES-SECUR-DATE     TO WS-DO-DATE-TRANS         
P00518           MOVE 'N' TO WS-GRAND-FATHER-DEPOSIT                    
P00518           PERFORM 7511-CHECK-GF-DEPOSIT THRU 7511-EXIT           
P00518           IF WS-GRAND-FATHER-DEPOSIT = 'Y'                       
P00518               MOVE +12 TO WS-LIMIT-MONTH                         
P00518           END-IF                                                 
P00518        END-IF                                                    
P00518     END-IF.                                                      
      *                                                                         
P00399     IF SEB-REFUND-RULE                                           
P00399        PERFORM 2405-CHK-DISC-HIST             THRU 2405-EXIT     
P00399        PERFORM 2420-CHK-UTILITY-ARREARS       THRU 2420-EXIT     
P00399        PERFORM 2430-CHK-NON-CONS-ARREARS      THRU 2430-EXIT     
P00399        MOVE 2                    TO WS-CALC                      
T31662        IF WS-HOLD-UTILITY-ARREARS <= WS-HOLD-NON-CONSEC-ARREARS  
T31662           AND  WS-HOLD-UTILITY-ARREARS <= WS-HOLD-DISC-HIST      
T31662           AND  WS-HOLD-UTILITY-ARREARS <= WS-HOLD-DISC-EXC-HIST  
T31662               MOVE WS-HOLD-UTILITY-ARREARS                       
PCR482                                  TO WS-MONTHS-TEMP               
PCR482        ELSE                                                      
T21844           IF WS-HOLD-DISC-HIST <= WS-HOLD-NON-CONSEC-ARREARS     
T31662              AND WS-HOLD-DISC-HIST <= WS-HOLD-UTILITY-ARREARS    
T21844              AND WS-HOLD-DISC-HIST <= WS-HOLD-DISC-EXC-HIST      
T21844                 MOVE WS-HOLD-DISC-HIST                           
T21844                                  TO WS-MONTHS-TEMP               
T21844           ELSE                                                   
T21844              IF WS-HOLD-DISC-EXC-HIST                            
P00399                               <= WS-HOLD-NON-CONSEC-ARREARS      
T31662              AND WS-HOLD-DISC-EXC-HIST <= WS-HOLD-UTILITY-ARREARS
T21844              AND WS-HOLD-DISC-EXC-HIST <= WS-HOLD-DISC-HIST      
T21844                  MOVE WS-HOLD-DISC-EXC-HIST                      
T21844                                  TO WS-MONTHS-TEMP               
T21844              ELSE                                                
PCR482                  MOVE WS-HOLD-NON-CONSEC-ARREARS                 
PCR482                                  TO WS-MONTHS-TEMP               
T21844              END-IF                                              
T21844           END-IF
              END-IF                                                 
P00399     ELSE                                                         
P00399        PERFORM 2435-CSR-CALC-GOOD-CREDIT      THRU 2435-EXIT     
P00399        MOVE 1                    TO WS-CALC                      
P00399     END-IF.                                                      
PCR482     MOVE WS-MONTHS-TEMP          TO WS-MONTHS-SQL.               
PCR482     PERFORM 2440-DATE-RATCHET                 THRU 2440-EXIT.    
           IF WS-PROJ-RFND-DATE (1:4) = WS-REV-MTH-CHAR (1:4)           
              AND WS-PROJ-RFND-DATE (6:2) = WS-REV-MTH-CHAR (5:2)       
                PERFORM 7925-ADD-ONE-MONTH           THRU 7925-EXIT     
           END-IF.                                                      
      *                                                                 42299700
PCR482 2400-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                 42300000
      ***************************************************************** 42300200
      * 2405-CHK-DISC-HIST                                            * 42300300
      *       -- THIS MODULE CHECKS NORMAL & EXCEPTIONAL CREDIT HISTORY 42300400
      *          IN THE PREVIOUS 12 MONTHS.                           * 42300500
      ***************************************************************** 42300600
T21237 2405-CHK-DISC-HIST.                                              
      *                                                                 42300800
           MOVE WS-N                TO WS-DISC-HIST-SW.                 
      *                                                                 42301000
T31662     PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
T31662      UNTIL WS-COUNTER > WS-LIMIT-MONTH OR DISC-HIST-FOUND        
T29249       IF CZ-DISCONNECT-HIST(WS-COUNTER:1) = '3'                  
T29249                              OR '4' OR 'I' OR 'R'                
               MOVE WS-Y            TO WS-DISC-HIST-SW                  
T21844         MOVE WS-COUNTER      TO WS-HOLD-DISC-HIST                
             END-IF                                                     
           END-PERFORM                                                  
      *                                                                 42301800
P00399     IF DISC-HIST-NOT-FOUND                                       
P00394        COMPUTE WS-HOLD-DISC-HIST  = WS-LIMIT-MONTH + 1           
T21844     END-IF.                                                      
                                                                        
T21844     MOVE WS-N                TO WS-DISC-HIST-SW                  
                                                                        
T31662     PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
T31662       UNTIL WS-COUNTER > WS-LIMIT-MONTH OR DISC-HIST-FOUND       
T29249          IF CZ-DISC-EXCEPTN-HIST(WS-COUNTER:1) =                 
T29249                                     '3' OR '4' OR 'I' OR 'R'     
                  MOVE WS-Y            TO WS-DISC-HIST-SW               
T21844            MOVE WS-COUNTER      TO WS-HOLD-DISC-EXC-HIST         
                END-IF                                                  
           END-PERFORM                                                  
                                                                        
T21844     IF DISC-HIST-NOT-FOUND                                       
P00394        COMPUTE WS-HOLD-DISC-EXC-HIST  = WS-LIMIT-MONTH + 1       
P00399     END-IF.                                                      
                                                                        
T21237 2405-EXIT.                                                       
           EXIT.                                                        
T31662*                                                                 42300100
T31662******************************************************************42300200
T31662*                                                                *42300500
T31662* 2420-CHK-UTILITY-ARREARS                                       *42300300
T31662******************************************************************42300600
T31662 2420-CHK-UTILITY-ARREARS.                                        
T31662*                                                                 42300800
T31662     MOVE WS-N                TO  WS-UTILITY-ARREARS-SW.          
P00399     PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
T31662       UNTIL WS-COUNTER > WS-LIMIT-MONTH OR UTILITY-ARREARS-FOUND 
T31662        IF CZ-ARREARS-HIST(WS-COUNTER:1) >= '1'                   
T31662          MOVE WS-Y            TO WS-UTILITY-ARREARS-SW           
T31662          MOVE WS-COUNTER      TO WS-HOLD-UTILITY-ARREARS         
T31662        END-IF                                                    
P00399     END-PERFORM                                                  
T31662                                                                  
T31662     IF UTILITY-ARREARS-NOT-FOUND                                 
P00394        COMPUTE WS-HOLD-UTILITY-ARREARS = WS-LIMIT-MONTH + 1      
P00399     END-IF.                                                      
T31662                                                                  
T31662 2420-EXIT.                                                       
T31662     EXIT.                                                        
T31662*                                                                 42302500
      ***************************************************************** 42306100
      * 2430-CHK-NON-CONS-ARREARS                                     * 42306200
      *       -- THIS MODULE CHECKS FOR THE EXISTENCE OF MORE THAN 2  * 42306300
T16204*          30-DAY ARREARS IN THE PAST TWELVE MONTHS.            * 42306400
      ***************************************************************** 42306500
PCR482 2430-CHK-NON-CONS-ARREARS.                                       
      *                                                                 42306700
PCR482     MOVE WS-N                TO WS-PREVIOUS-ARREARS-SW.          
           MOVE WS-N                TO WS-2ND-PREV-ARREARS-SW.          
PCR482     MOVE WS-N                TO WS-NON-CONSEC-ARREARS-SW.        
      *                                                                 42307000
T31662     PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
T31662      UNTIL NON-CONS-ARREARS-FOUND OR WS-COUNTER > WS-LIMIT-MONTH 
T16204       IF (CZ-ARREARS-HIST(WS-COUNTER:1) = '1')                   
PCR482        AND PREVIOUS-ARREARS-FOUND                                
              AND 2ND-PREV-ARREARS-FOUND                                
PCR482         MOVE WS-Y            TO WS-NON-CONSEC-ARREARS-SW         
PCR482         MOVE WS-COUNTER      TO WS-HOLD-NON-CONSEC-ARREARS       
PCR482       ELSE                                                       
T16204         IF CZ-ARREARS-HIST(WS-COUNTER:1) = '1'                   
                 IF PREVIOUS-ARREARS-FOUND                              
                   MOVE WS-Y        TO WS-2ND-PREV-ARREARS-SW           
                 ELSE                                                   
PCR482             MOVE WS-Y        TO WS-PREVIOUS-ARREARS-SW           
                 END-IF                                                 
PCR482         END-IF                                                   
PCR482       END-IF                                                     
PCR482     END-PERFORM.                                                 
      *                                                                 42308300
PCR482     IF NON-CONS-ARREARS-NOT-FOUND                                
P00394        COMPUTE WS-HOLD-NON-CONSEC-ARREARS = WS-LIMIT-MONTH + 1   
P00399     END-IF.                                                      
PCR482 2430-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                 42309000
P00399***************************************************************** 42306100
P00399* 2435-CSR-CALC-GOOD-CREDIT                                    *  42306200
P00399***************************************************************** 42306500
P00399 2435-CSR-CALC-GOOD-CREDIT.                                       
P00399      MOVE CZ-ARREARS-HIST(1:WS-LIMIT-MONTH) TO WS-ACCT-HST.      
P00399      MOVE WS-LIMIT-MONTH                    TO WS-DELINQ-MTH     
P00399                                                WS-ELIG-NO-MTHS.  
P00399      MOVE PROGRAM-NAME                      TO WS-PROGRAM-CPD334.
P00399      MOVE WS-Y                              TO                   
P00399                                           WS-NOT-USE-CR-HIST-FL. 
P00399      MOVE WS-N                              TO                   
P00399                                           WS-FORECAST-CRED-GR-FL.
P00399      MOVE AT-COMPANY-NO                     TO WS-COMPANY-CPD334.
P00399      PERFORM 6565-PROCESS-CREDIT-RULE       THRU 6565-EXIT.      
P00399      MOVE WS-PROJ-REF-POSITION              TO WS-MONTHS-TEMP.   
P00399                                                                  
P00399 2435-EXIT.                                                       
P00399     EXIT.                                                        
      ***************************************************************** 42309200
      * 2440-DATE-RATCHET                                             * 42309300
      *       -- THIS MODULE GETS THE PROJECTED REFUND DATE USING     * 42309400
      *          SET.                                                 * 42309500
      ***************************************************************** 42309600
PCR482 2440-DATE-RATCHET.                                               
      *                                                                 42309800
PCR482     MOVE '2440'              TO ACTIVE-PARAGRAPH.                
      *                                                                 42310000
PCR482     EXEC SQL                                                     
T34097       SELECT
              DATEADD( MONTH, (:WS-LIMIT-MONTH + :WS-CALC), (DATEADD( 
              MONTH, -:WS-MONTHS-SQL, IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) ) )) )
            INTO
              :WS-PROJ-RFND-DATE                 
PCR482     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     42310100
MFA-TR*      SET :WS-PROJ-RFND-DATE                                             
MFA-TR*           = (DATE(:WS-LAST-BILL-DATE) -                                 
MFA-TR*             :WS-MONTHS-SQL MONTHS) +                                    
MFA-TR*             (:WS-LIMIT-MONTH + :WS-CALC) MONTHS                         
MFA-TR*    END-EXEC.                                                    42310700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42310800
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 42311000
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR482       NEXT SENTENCE                                              
PCR482     ELSE                                                         
PCR482       MOVE PROGRAM-NAME      TO ABEND-PROGRAM                    
PCR482       MOVE '2440'            TO ACTIVE-PARAGRAPH                 
T34097       MOVE 'SET'             TO ABEND-FUNCTION                   
CBSI         MOVE SPACES            TO ABEND-SQL-PREDICATES             
CBSI                                   ABEND-TABLES                     
CBSI         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                  
CBSI         MOVE 'WS-LAST-BILL-DATE'                                   
CBSI                                TO TABLE-ELEMENT-2                  
CBSI         MOVE 'WS-MONTHS-SQL'   TO TABLE-ELEMENT-3                  
CBSI         MOVE PARM-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                
CBSI         MOVE WS-LAST-BILL-DATE TO HOSTVAR-ELEMENT-2                
CBSI         MOVE WS-MONTHS-SQL     TO HOSTVAR-ELEMENT-3                
PCR482       PERFORM 9000-SEND-ERROR-RESULT             THRU 9000-EXIT  
PCR482       PERFORM 9900-SQL-ERROR-ROUTINE             THRU 9900-EXIT  
PCR482     END-IF.                                                      
      *                                                                 42312100
PCR482 2440-EXIT.                                                       
PCR482     EXIT.                                                        
      *                                                                 42322200
      *****************************************************************         
      * 2500-PROCESS-NAME                                             *         
      *    -- THIS MODULE RETRIEVES THE USER NAME TO THE PANEL --     *         
      *       PERFORMANCE ISSUES HAVE CAUSED THIS TO BE HANDLED LIKE  *         
      *       THIS.                                                   *         
      *****************************************************************         
PCR482 2500-PROCESS-NAME.                                               
                                                                        
PCR482     MOVE PF-FIRST-NAME    TO    WS-FROM.                         
PCR482     PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
PCR482     MOVE WS-FROM          TO    PF-FIRST-NAME.                   
                                                                        
PCR482     MOVE PF-LAST-NAME     TO    WS-FROM.                         
PCR482     PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
PCR482     MOVE WS-FROM          TO    PF-LAST-NAME.                    
                                                                        
TP9421* DELETED THE SAME PROCESSING FOR MIDDLE NAME AS WE NEED ONLY             
TP9421* THE FIRST CHARACTER OF THAT.                                            
                                                                        
PCR482     STRING PF-LAST-NAME DELIMITED CN-DELIMITER                   
PCR482            ', ' DELIMITED SIZE                                   
PCR482            PF-FIRST-NAME DELIMITED CN-DELIMITER                  
PCR482            ' ' DELIMITED SIZE                                    
PCR482            PF-MIDDLE-NAME(1:1) DELIMITED SIZE                    
PCR482       INTO WS-HOLD-NAME-OUTPUT                                   
PCR482     END-STRING.                                                  
                                                                        
           IF WS-HOLD-NAME-OUTPUT (1:6) EQUAL 'SYSTEM'                  
             MOVE SPACES TO WS-HOLD-NAME-OUTPUT (7:23)                  
           ELSE                                                         
             IF WS-HOLD-NAME-OUTPUT (1:1) EQUAL ','                     
               MOVE SPACES TO WS-HOLD-NAME-OUTPUT                       
             END-IF                                                     
           END-IF.                                                      
                                                                        
PCR482 2500-EXIT.                                                       
                                                                        
PCR482 2510-PROCESS-FROM-STRING.                                        
                                                                        
PCR482     PERFORM                                                      
PCR482        VARYING WS-SUB FROM 15 BY -1                              
PCR482            UNTIL WS-SUB < 1                                      
PCR482            OR WS-FROM-X(WS-SUB) NOT = SPACE                      
PCR482     END-PERFORM.                                                 
PCR482     ADD 1      TO   WS-SUB.                                      
PCR482     MOVE CN-DELIMITER  TO WS-FROM-X(WS-SUB).                     
                                                                        
PCR482 2510-EXIT.                                                       
P00399     EXIT.                                                        
      ******************************************************************42322300
      * 5000-OPEN-DEPOSITS-CURSOR                                      *42322400
      *       -- THIS MODULE OPENS THE COMPUTE DEPOSITS CURSOR         *42322500
      ******************************************************************42322600
       5000-OPEN-DEPOSITS-CURSOR.                                       
      *                                                                 42322800
           EXEC SQL                                                     
               OPEN DEPOSITS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42323200
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 42323500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'OPEN'                TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42324800
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42325300
      ******************************************************************42328500
      * 5100-FETCH-DEPOSITS-CURSOR                                     *42328600
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF CASH DEPOSIT     *42328700
      *        DETAILS                                                 *42328800
A04041* IF INELG CODE SET TO '0' OR ' ' CALC REFUND DATE.              *42328900
      ******************************************************************42329000
       5100-FETCH-DEPOSITS-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DEPOSITS                                           
                  INTO :DO-DEPOSIT-STATUS-CD,                           
                       :DO-SERVICE-TYPE-CD,                             
                       :WS-DEP-LESS-REFUND,                             
                       :DO-DATE-TRAN :DATE-TRAN-IND,                     
                       :WS-DUMMY-TRAN :DATE-TRAN-IND2,                   
                       :DO-USER-ID-UPDT-BY,                             
                       :DO-DATE-CERT-ISSUE :DATE-CERT-ISSUE-IND,         
                       :DO-DEPOSIT-CERT-NO,                             
                       :DO-PROJECTED-CR-DT :PROJECTED-CR-DT-IND,         
                       :DO-TOTAL-INTRST,                                
                       :WS-DT-INT-CALC-TO-HOLD :DT-INT-CALC-TO-HOLD-IND, 
                       :DO-DATE-INTST-CALC-TO :DATE-INTST-CALC-TO-IND,   
                       :DO-CODE-REFUND-STATUS,                          
T12026                 :DO-DATE-PYMT-START :DATE-PYMT-START-IND,         
A04041                 :DO-CODE-REFUND-ELIG                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42330600
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 42330900
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               IF DATE-INTST-CALC-TO-IND = NULL-VALUE                   
                   MOVE SPACES           TO DO-DATE-INTST-CALC-TO       
               END-IF                                                   
               IF DATE-CERT-ISSUE-IND = NULL-VALUE                      
                   MOVE SPACES           TO DO-DATE-CERT-ISSUE          
               END-IF                                                   
T16026         IF DATE-PYMT-START-IND = NULL-VALUE                      
T16026             MOVE SPACES           TO DO-DATE-PYMT-START          
T16026         END-IF                                                   
      *                                                                         
               PERFORM 2301-GET-DEP-LESS-PAY            THRU 2301-EXIT  
      *                                                                 42331500
PCR482         MOVE WS-ACCOUNT-NO        TO DP-ACCOUNT-NO               
PCR482         MOVE DO-DEPOSIT-CERT-NO   TO DP-DEPOSIT-CERT-NO          
PCR482         PERFORM 7900-GET-DEPOSIT-PAYOFF          THRU 7900-EXIT  
PCR482         COMPUTE WS-NEW-PAYOFF = WS-DEP-LESS-REFUND -             
PCR482             WS-TOTAL-PAYMENTS                                    
      *                                                                 42332100
MAD714         IF (DO-DEPOSIT-STATUS-CD EQUAL 'A' OR 'P')               
A04041            IF DO-CODE-REFUND-ELIG = '0' OR ' '                   
PCR482               PERFORM 5200-CALC-RFND-PROJ          THRU 5200-EXIT
MAD714               IF DO-DEPOSIT-STATUS-CD EQUAL 'P'                  
PCR482                 MOVE A9-REV-DISTRICT-CD TO PR-REV-DISTRICT-CD    
PCR482                 MOVE WS-LOCAL-OFFICE-NO TO AT-LOCAL-OFFICE       
PCR482                 MOVE WS-COMPANY-NO      TO AT-COMPANY-NO         
PCR482                 MOVE WS-ACCOUNT-NO      TO AT-ACCOUNT-NO         
PCR482                 MOVE WS-Y               TO WS-BILL-IMMEDIATELY   
PCR482                 MOVE WS-Y               TO WS-S031-CALL-SWITCH   
PCR482                 PERFORM 5995-DEPOSIT-INTEREST-CALC THRU 5995-EXIT
C29752                 IF DO-DATE-CERT-ISSUE NOT EQUAL SPACES           
C29752                    MOVE DO-DATE-CERT-ISSUE(1:4) TO               
C29752                                            WS-DCERT-YYYY         
C29752                    MOVE DO-DATE-CERT-ISSUE(6:2) TO               
C29752                                            WS-DCERT-MM           
C29752                    MOVE DO-DATE-CERT-ISSUE(9:2) TO               
C29752                                            WS-DCERT-DD           
C29752                    MOVE WS-DCERT-ISSUE          TO               
C29752                                            DO-DATE-CERT-ISSUE    
C29752                 END-IF                                           
PCR482                 MOVE WS-INTEREST-CALC   TO S-PROJ-INT-AMT        
C29752                 IF WS-MULTIPLE-INT-RATES                         
C29752                    MOVE WS-NINES TO S-INTRST-RATE                
C29752                 ELSE                                             
PCR482                    MOVE WS-INTRST-RATE (WS-INT-INDX)             
PCR482                                          TO S-INTRST-RATE        
C29752                 END-IF                                           
MAD714               ELSE                                               
MAD714                 MOVE ZEROES        TO S-INTRST-RATE              
MAD714               END-IF                                             
A04041            ELSE                                                  
A04041               MOVE ZEROES         TO S-INTRST-RATE               
A04041               MOVE WS-INELIGIBLE  TO S-PROJECTED-CR-DT           
A04041            END-IF                                                
               ELSE                                                     
                 MOVE ZEROES        TO S-INTRST-RATE                    
                 MOVE SPACES        TO S-PROJECTED-CR-DT                
PCR482         END-IF                                                   
      *                                                                         
               PERFORM 8000-SET-RETURNS               THRU 8000-EXIT    
P26289         MOVE RS-RETURN-CODE TO S-RETURN-CODE                     
               PERFORM 8100-SEND-RESULT               THRU 8100-EXIT    
           ELSE IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                  
               MOVE WS-Y                  TO WS-DEPOSITS-SW             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5100'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'FETCH'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
T15609         MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 42333600
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42334000
      ******************************************************************        
      * 5200-CALC-RFND-PROJ                                            *        
      *       -- THIS MODULE DETERMINES WHICH DATE THE INTEREST WILL   *        
      *          BE CALCULATED FOR : ONE YEAR FROM FINAL PAYMENT OR    *        
      *          A SPECIFIED TIME BASED ON ARREARS.                    *        
P00399*       FOR CSR, ONCE THE ELIGIBLE DATE IS CALCULATED FROM THE   *        
P00399*       OLDEST DEPOSIT'S PAYMENT DATE, ALL OTHER DEPOSITS USE    *        
P00399*       THIS DATE.                                               *        
      ******************************************************************        
       5200-CALC-RFND-PROJ.                                             
      *                                                                         
T16026     IF DO-DATE-PYMT-START NOT EQUAL SPACES                       
T31662       IF SEB-REFUND-RULE AND DO-DATE-CERT-ISSUE NOT EQUAL SPACES 
T31662         MOVE DO-DATE-CERT-ISSUE            TO WS-DATE-DEP-PAID   
P00399         PERFORM 7950-CALC-DATE-FROM-PMT            THRU 7950-EXIT
T31662       ELSE                                                       
P00399         IF DO-NOT-HAVE-OLDEST-PMT                                
T31662            MOVE DO-DATE-PYMT-START            TO WS-DATE-DEP-PAID
P00399            PERFORM 7950-CALC-DATE-FROM-PMT         THRU 7950-EXIT
P00399            MOVE '2'                           TO WS-OLDEST-PMT-SW
T31662         END-IF                                                   
T31662       END-IF                                                     
T31662     END-IF.                                                      
      *                                                                         
T31662     IF WS-CALC-DT-FROM-PMT > WS-PROJ-RFND-DATE                   
T31662       MOVE WS-CALC-DT-FROM-PMT(3:2)                              
PCR482                              TO WS-RFND-DATE-YY                  
T31662       MOVE WS-CALC-DT-FROM-PMT(6:2)                              
PCR482                              TO WS-RFND-DATE-MM                  
PCR482       MOVE WS-RFND-DATE-HOLD TO S-PROJECTED-CR-DT                
T31662       MOVE WS-CALC-DT-FROM-PMT                                   
PCR482                              TO WS-RFND-DATE-PASS                
PCR482     ELSE                                                         
PCR482       MOVE WS-PROJ-RFND-DATE(3:2)                                
PCR482                              TO WS-RFND-DATE-YY                  
PCR482       MOVE WS-PROJ-RFND-DATE(6:2)                                
PCR482                              TO WS-RFND-DATE-MM                  
PCR482       MOVE WS-RFND-DATE-HOLD TO S-PROJECTED-CR-DT                
PCR482       MOVE WS-PROJ-RFND-DATE TO WS-RFND-DATE-PASS                
PCR482     END-IF.                                                      
      *                                                                         
T14098     MOVE '01'                TO WS-RFND-PASS-DD.                 
      *                                                                         
MAD714     IF DO-DATE-INTST-CALC-TO NOT EQUAL SPACES                    
MAD714        MOVE DO-DATE-INTST-CALC-TO                                
MAD714                              TO WS-INTEREST-CALC-DATE            
T31662        PERFORM 7955-GET-DATE-INT-CALC     THRU 7955-EXIT         
T31662        IF WS-NEXT-DATE-FOR-CALC < WS-RFND-DATE-PASS              
T31662          MOVE WS-NEXT-DATE-FOR-CALC                              
MAD714                              TO WS-RFND-DATE-PASS                
MAD714        END-IF                                                    
MAD714     ELSE                                                         
MAD714        IF DO-DATE-CERT-ISSUE NOT EQUAL SPACES                    
MAD714           MOVE DO-DATE-CERT-ISSUE                                
MAD714                              TO WS-INTEREST-CALC-DATE            
T31662           PERFORM 7955-GET-DATE-INT-CALC  THRU 7955-EXIT         
T31662           IF WS-NEXT-DATE-FOR-CALC < WS-RFND-DATE-PASS           
T31662             MOVE WS-NEXT-DATE-FOR-CALC                           
MAD714                              TO WS-RFND-DATE-PASS                
MAD714           END-IF                                                 
MAD714        END-IF                                                    
MAD714     END-IF.                                                      
      *                                                                         
PCR482     MOVE WS-RFND-DATE-PASS   TO WS-CURRENT-DATE.                 
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00399*****************************************************************         
P00399* 6565-PROCESS-CREDIT-RULE.                                     *         
P00399*****************************************************************         
P00399*                                                                         
P00399     EXEC SQL                                                             
P00399          INCLUDE CPD00334                                                
P00399     END-EXEC.                                                            
P00399*                                                                         
T31662*****************************************************************         
T31662* 6600-GET-DELINQ-VALUE.                                        *         
T31662*     SELECTS VALUES FROM CSS_DELINQUENCY                       *         
T31662*****************************************************************         
T31662 6600-GET-DELINQ-VALUE.                                           
T31662                                                                  
T31662     EXEC SQL                                                     
T31662        SELECT DELINQ_VALUE                                       
T31662          INTO :C8-DELINQ-VALUE                                   
T31662          FROM CSS_DELINQUENCY                                    
T31662         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
T31662           AND COMPANY_NO = :AT-COMPANY-NO                        
T31662     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31662                                                                  
T31662     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T31662                                                                  
T31662     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T31662         NEXT SENTENCE                                            
T31662     ELSE                                                         
T31662         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T31662         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T31662         MOVE '6600'                TO ACTIVE-PARAGRAPH           
T31662         MOVE 'SELECT'              TO ABEND-FUNCTION             
T31662         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T31662                                       ABEND-TABLES               
T31662         MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
T31662         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T31662         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T31662         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T31662         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T31662     END-IF.                                                      
T31662                                                                  
T31662 6600-EXIT.                                                       
T31662     EXIT.                                                        
T31662*                                                                         
      ******************************************************************42338300
      * 7000-CLOSE-DEPOSITS-CURSOR                                     *42338400
      *       -- THIS MODULE CLOSES THE DEPOSITS CURSOR                *42338500
      ******************************************************************42338600
       7000-CLOSE-DEPOSITS-CURSOR.                                      
      *                                                                 42338800
           EXEC SQL                                                     
               CLOSE DEPOSITS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42339200
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 42339500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'CLOSE'               TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42341000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42341300
P00518******************************************************************40260000
P00518* 7511-CHECK-GF-DEPOSIT.                                         *40280000
P00518*   CHECK TO SEE IF DEPOSIT SHOULD BE GRAND FATHERED             *40290000
P00518******************************************************************40300000
P00518*                                                                         
P00518 7511-CHECK-GF-DEPOSIT.                                           
P00518*                                                                         
P00518     EXEC SQL                                                     
P00518        SELECT TOP(1) 'Y'                                               
P00518          INTO  :WS-GRAND-FATHER-DEPOSIT                          
P00518          FROM  CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                  
P00518         WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                    
P00518           AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                 
P00518           AND  DO.DATE_TRAN <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-DO-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WS-DO-DATE-TRANS
              ) <> 0) OR (LEN(:WS-DO-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                      :WS-DO-DATE-TRANS
              ), CONVERT(DATE, :WS-DO-DATE-TRANS) )                 
P00518         ORDER BY DO.DATE_TRAN                                    
P00518                                     
P00518                                                      
P00518     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-GRAND-FATHER-DEPOSIT                                  
MFA-TR*         FROM  CSS_DEP_ON_HAND DO                                        
MFA-TR*        WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*          AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                         
MFA-TR*          AND  DO.DATE_TRAN <= :WS-DO-DATE-TRANS                         
MFA-TR*        ORDER BY DO.DATE_TRAN                                            
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7511                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00518                                                                  
P00518     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00518*                                                                         
P00518     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00518        CONTINUE                                                  
P00518     ELSE                                                         
P00518         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P00518         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
P00518         MOVE '7511'                TO ACTIVE-PARAGRAPH           
P00518         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00518         MOVE SPACES                TO ABEND-SQL-PREDICATES       
P00518                                       ABEND-TABLES               
P00518         MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
P00518         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
P00518         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
P00518         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00518         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00518     END-IF.                                                      
P00518*                                                                         
P00518 7511-EXIT.                                                       
P00518     EXIT.                                                        
      *                                                                 42348000
      ***************************************************************** 42344700
      * 7800-GET-CRED-PROFILE                                         * 42344800
      *    -- THIS MODULE RETRIEVES THE CREDIT PROFILE FOR THE        * 42344900
      *       SELECTED ACCOUNT - WILL BE USED TO CALCULATE THE        * 42345000
      *       PROJECTED REFUND DATE.                                  * 42345100
      ***************************************************************** 42345200
       7800-GET-CRED-PROFILE.                                           
      *                                                                 42345400
           MOVE '7800'              TO ACTIVE-PARAGRAPH.                
      *                                                                 42345600
           EXEC SQL                                                     
              SELECT    ARREARS_HIST,                                   
T21237                  DISCONNECT_HIST,                                
T21237                  DISC_EXCEPTN_HIST                               
                INTO    :CZ-ARREARS-HIST,                               
T21237                  :CZ-DISCONNECT-HIST,                            
T21237                  :CZ-DISC-EXCEPTN-HIST                           
                FROM    CSS_CREDIT_PROFILE                              
               WHERE    ACCOUNT_NO  = :CZ-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42346300
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 42346500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7800'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE CZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42347700
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42348000
      ***************************************************************** 42344700
      * 7850-GET-LAST-BILL-DT-ACCT-TYP                                * 42344800
      *    -- THIS MODULE RETRIEVES THE LAST BILL DATE FROM THE       * 42344900
      *       SELECTED ACCOUNT - WILL BE USED TO CALCULATE THE        * 42345000
      *       PROJECTED REFUND DATE.                                  * 42345100
P26289*       ALSO GETS THE ACCOUNT TYPE.                             * 42345100
      ***************************************************************** 42345200
P26289 7850-GET-LAST-BILL-DT-ACCT-TYP.                                  
      *                                                                 42345400
           MOVE '7850'              TO ACTIVE-PARAGRAPH.                
      *                                                                 42345600
           EXEC SQL                                                     
              SELECT    DATE_BILL_DAY_00,                               
                        REV_MTH_LST_NRML                                
P26289                 ,ACCOUNT_TYPE_CODE                               
                INTO    :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NI,    
                        :AT-REV-MTH-LST-NRML                            
P26289                 ,:AT-ACCOUNT-TYPE-CODE                           
                FROM    CSS_ACCOUNT                                     
               WHERE    ACCOUNT_NO  = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42346300
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 42346500
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             IF WS-DATE-BILL-DAY-00-NI = SUCCESSFUL-CALL                
               MOVE AT-DATE-BILL-DAY-00   TO WS-LAST-BILL-DATE          
             ELSE                                                       
               MOVE WS-CURRENT-DATE       TO WS-LAST-BILL-DATE          
             END-IF                                                     
             MOVE AT-REV-MTH-LST-NRML     TO WS-REV-MTH-HOLD            
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE WS-CURRENT-DATE       TO WS-LAST-BILL-DATE          
               MOVE ZEROES                TO WS-REV-MTH-HOLD            
             ELSE                                                       
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7850'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
      *                                                                 42347700
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42348100
      ******************************************************************42348200
      * 7900-GET-DEPOSIT-PAYOFF                                        *42348300
      *    -- THIS MODULE GETS THE PAYOFF AMOUNT FOR THE DEPOSIT       *42348400
      *                                                                *42348500
      ******************************************************************42348600
PCR482 7900-GET-DEPOSIT-PAYOFF.                                         
      *                                                                 42348800
PCR482     EXEC SQL                                                     
PCR482         SELECT   SUM(DEP_PAY_AMT),                               
PCR482                  MAX(DEP_PAY_DT)                                 
PCR482           INTO   :WS-TOTAL-PAYMENTS :WS-NULL-PAYMENT,             
PCR482                  :WS-LAST-PAY-DT :WS-NULL-LAST-PAY                
PCR482           FROM   CSS_DEP_PAY_HST                                 
PCR482          WHERE   ACCOUNT_NO       =  :DP-ACCOUNT-NO              
PCR482            AND   DEPOSIT_CERT_NO  =  :DP-DEPOSIT-CERT-NO         
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42349600
PCR482     IF WS-NULL-PAYMENT < 0                                       
PCR482         MOVE ZEROES          TO WS-TOTAL-PAYMENTS                
PCR482     END-IF.                                                      
      *                                                                 42350000
PCR482     IF WS-NULL-LAST-PAY < 0                                      
PCR482         MOVE WS-HOLD-SQL-COMP-DT                                 
PCR482                              TO WS-LAST-PAY-DT                   
PCR482     END-IF.                                                      
      *                                                                         
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 42350200
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PCR482         NEXT SENTENCE                                            
PCR482     ELSE                                                         
PCR482         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
PCR482         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
PCR482         MOVE '7900'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
PCR482         MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2            
T15609         MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2          
PCR482         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
PCR482         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
PCR482     END-IF.                                                      
      *                                                                 42351400
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42351800
      ******************************************************************42348200
      * 7925-ADD-ONE-MONTH                                             *42348300
      *    -- THIS MODULE ADDS ONE MONTH TO THE PROJECTED REFUND       *42348400
      *       DATE IF THE ACCOUNT HAS ALREADY BILLED FOR THE MONTH     *42348500
      *       RETURNED BY THE PROJECTION.                              *        
      ******************************************************************42348600
       7925-ADD-ONE-MONTH.                                              
      *                                                                 42348800
           EXEC SQL                                                     
T34097       SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                     :WS-PROJ-RFND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROJ-RFND-DATE
              ) <> 0) OR (LEN(:WS-PROJ-RFND-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PROJ-RFND-DATE
              ), CONVERT(DATE, :WS-PROJ-RFND-DATE) ) )
            INTO
              :WS-PROJ-RFND-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     42348900
MFA-TR*      SET :WS-PROJ-RFND-DATE                                             
MFA-TR*           = DATE(:WS-PROJ-RFND-DATE) + 1 MONTH                          
MFA-TR*    END-EXEC.                                                    42349500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42349600
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 42350200
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7925'                TO ACTIVE-PARAGRAPH           
T34097         MOVE 'SET'                 TO ABEND-FUNCTION             
CBSI           MOVE SPACES                TO ABEND-SQL-PREDICATES       
CBSI                                         ABEND-TABLES               
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'WS-PROJ-RFND-DATE'   TO TABLE-ELEMENT-2            
CBSI           MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
CBSI           MOVE WS-PROJ-RFND-DATE     TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42351400
       7925-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42351800
      ******************************************************************        
      * 7950-CALC-DATE-FROM-PMT                                       *         
      *    -- THIS MODULE CALCULATES THE DATE ONE YEAR FROM THE LAST   *        
      *       PAYMENT ON THE DEPOSIT.                                  *        
      ******************************************************************        
T31662 7950-CALC-DATE-FROM-PMT.                                         
      *                                                                         
           EXEC SQL                                                     
T34097        SELECT
              DATEADD( MONTH, (:WS-LIMIT-MONTH + 1), 
              IIF(TRY_CONVERT(DATE, :WS-DATE-DEP-PAID
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-DEP-PAID
              ) <> 0) OR (LEN(:WS-DATE-DEP-PAID) <> 10), CIS.CHAR2DATE(
                                                      :WS-DATE-DEP-PAID
              ), CONVERT(DATE, :WS-DATE-DEP-PAID) ) )
            INTO
              :WS-CALC-DT-FROM-PMT                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CALC-DT-FROM-PMT                                         
MFA-TR*             = DATE(:WS-DATE-DEP-PAID)                                   
MFA-TR*               + (:WS-LIMIT-MONTH + 1) MONTHS                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO RS-RETURN-CODE.              
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 16250200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7950'              TO ACTIVE-PARAGRAPH             
T34097         MOVE 'SET'               TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
CBSI           MOVE 'DO-DATE-PYMT-START'                                
CBSI                                    TO TABLE-ELEMENT-2              
CBSI           MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
CBSI           MOVE DO-DATE-PYMT-START  TO HOSTVAR-ELEMENT-2            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7955-GET-DATE-INT-CALC                                         *        
      *    -- THIS MODULE CALCULATES THE DATE ONE YEAR FROM THE LAST   *        
      *       INTEREST APPLICATION DATE ON THE DEPOSIT.                *        
      ******************************************************************        
T31662 7955-GET-DATE-INT-CALC.                                          
      *                                                                         
           EXEC SQL                                                     
T34097       SELECT
              DATEADD( MONTH, :WS-LIMIT-MONTH, IIF(TRY_CONVERT(DATE, 
                                                 :WS-INTEREST-CALC-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INTEREST-CALC-DATE
              ) <> 0) OR (LEN(:WS-INTEREST-CALC-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-INTEREST-CALC-DATE
              ), CONVERT(DATE, :WS-INTEREST-CALC-DATE) ) )
            INTO
              :WS-NEXT-DATE-FOR-CALC                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NEXT-DATE-FOR-CALC                                        
MFA-TR*            =  DATE(:WS-INTEREST-CALC-DATE)                              
MFA-TR*               + :WS-LIMIT-MONTH MONTHS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO RS-RETURN-CODE.              
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 16250200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7955'              TO ACTIVE-PARAGRAPH             
T34097         MOVE 'SET'               TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
CBSI           MOVE 'WS-INTEREST-CALC-DATE'                             
CBSI                                    TO TABLE-ELEMENT-2              
CBSI           MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
CBSI           MOVE WS-INTEREST-CALC-DATE                               
CBSI                                    TO HOSTVAR-ELEMENT-2            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7955-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7975-SELECT-USER-NAME                                         *         
      *    -- THIS MODULE SELECTS THE USER NAME FOR PROCESSING        *         
      *****************************************************************         
PCR482 7975-SELECT-USER-NAME.                                           
                                                                        
PCR482     MOVE '7975'              TO ACTIVE-PARAGRAPH.                
                                                                        
PCR482     EXEC SQL                                                     
PCR482       SELECT   FIRST_NAME,                                       
PCR482                MIDDLE_NAME,                                      
PCR482                LAST_NAME                                         
PCR482         INTO   :PF-FIRST-NAME,                                   
PCR482                :PF-MIDDLE-NAME,                                  
PCR482                :PF-LAST-NAME                                     
PCR482         FROM   CSS_USER_PROFILE                                  
PCR482        WHERE   USER_ID   =  :PF-USER-ID                          
PCR482     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
PCR482     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
PCR482     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR482       NEXT SENTENCE                                              
PCR482     ELSE                                                         
PCR482       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
PCR482         MOVE SPACES        TO PF-FIRST-NAME,                     
PCR482                               PF-LAST-NAME,                      
PCR482                               PF-MIDDLE-NAME                     
PCR482       ELSE                                                       
PCR482         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PCR482         MOVE 'SELECT'             TO ABEND-FUNCTION              
CBSI           MOVE SPACES               TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
PCR482         MOVE 'CSS_USER_PROFILE'   TO TABLE-1                     
T15609         MOVE 'USER_ID'            TO TABLE-ELEMENT-1             
CBSI           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
T15609         MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1           
CBSI           MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
PCR482         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
PCR482         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
PCR482       END-IF                                                     
PCR482     END-IF.                                                      
                                                                        
PCR482 7975-EXIT.                                                       
PCR482     EXIT.                                                        
      ******************************************************************42351900
      * 8000 SET RETURNS                                               *42352000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*42352100
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *42352200
      ******************************************************************42352300
       8000-SET-RETURNS.                                                
      *                                                                 42352500
           MOVE DO-DEPOSIT-STATUS-CD      TO S-DEPOSIT-STATUS-CD.       
           MOVE DO-SERVICE-TYPE-CD        TO S-SERVICE-TYPE-CD.         
           MOVE WS-DEP-LESS-REFUND        TO S-DEP-LESS-REFUND.         
PCR482     MOVE WS-NEW-PAYOFF             TO S-DEPOSIT-PAYOFF.          
      *                                                                 42353000
PCR482     IF S-DEPOSIT-PAYOFF < ZEROES                                 
PCR482         MOVE ZEROES                TO S-DEPOSIT-PAYOFF           
PCR482     END-IF.                                                      
      *                                                                         
           IF DATE-TRAN-IND = SUCCESSFUL-CALL                           
               MOVE DO-DATE-TRAN          TO S-DATE-TRAN                
           ELSE                                                         
               MOVE SPACES                TO S-DATE-TRAN                
           END-IF.                                                      
      *                                                                 42353600
PCR482     IF DO-USER-ID-UPDT-BY NOT EQUAL SPACES                       
PCR482         MOVE DO-USER-ID-UPDT-BY TO PF-USER-ID                    
PCR482         PERFORM 7975-SELECT-USER-NAME           THRU 7975-EXIT   
PCR482         PERFORM 2500-PROCESS-NAME               THRU 2500-EXIT   
PCR482         MOVE WS-HOLD-NAME-OUTPUT  TO S-USER-NAME-UPDT-BY         
PCR482     ELSE                                                         
PCR482         MOVE SPACES               TO S-USER-NAME-UPDT-BY         
PCR482     END-IF.                                                      
      *                                                                 42353800
           IF DATE-CERT-ISSUE-IND = SUCCESSFUL-CALL                     
               MOVE DO-DATE-CERT-ISSUE    TO S-DATE-CERT-ISSUE          
           ELSE                                                         
               MOVE SPACES                TO S-DATE-CERT-ISSUE          
           END-IF.                                                      
      *                                                                 42354400
TP8211     MOVE WS-DEP-LESS-PAYMENT       TO S-DEP-LESS-PAYMENT.        
                                                                        
      *                                                                 42354700
           MOVE DO-DEPOSIT-CERT-NO        TO S-DEPOSIT-CERT-NO.         
      *                                                                 42354900
           IF DO-DEPOSIT-STATUS-CD = BILL-DELETED                       
               MOVE 0                     TO S-TOTAL-INTRST             
           ELSE                                                         
               MOVE DO-TOTAL-INTRST       TO S-TOTAL-INTRST             
           END-IF.                                                      
      *                                                                 42356000
TP9710     IF DT-INT-CALC-TO-HOLD-IND = SUCCESSFUL-CALL                 
TP9710         MOVE WS-DT-INT-CALC-TO-HOLD TO S-DATE-INTST-CALC-TO      
TP9710     ELSE                                                         
TP9710         MOVE SPACES                TO S-DATE-INTST-CALC-TO       
TP9710     END-IF.                                                      
      *                                                                 42356600
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42357500
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02031_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02031_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02031_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02031_R1                        
REARCH           (                                                      
REARCH                DEPOSIT_STATUS_CD                                 
REARCH               ,DEP_LESS_REFUND                                   
REARCH               ,DATE_TRAN                                         
REARCH               ,DATE_CERT_ISSUE                                   
REARCH               ,DEPOSIT_PAYOFF                                    
REARCH               ,DEPOSIT_CERT_NO                                   
REARCH               ,PROJECTED_CR_DT                                   
REARCH               ,PROJ_INT_AMT                                      
REARCH               ,INTRST_RATE                                       
REARCH               ,TOTAL_INTRST                                      
REARCH               ,DATE_INTST_CALC_TO                                
REARCH               ,REV_DISTRICT_DESC                                 
REARCH               ,USER_NAME_UPDT_BY                                 
REARCH               ,SERVICE_TYPE_CD                                   
REARCH               ,RETURN_CODE                                       
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                :S-DEPOSIT-STATUS-CD                              
REARCH               ,:S-DEP-LESS-REFUND                                
REARCH               ,:S-DATE-TRAN                                      
REARCH               ,:S-DATE-CERT-ISSUE                                
REARCH               ,:S-DEPOSIT-PAYOFF                                 
REARCH               ,:S-DEPOSIT-CERT-NO                                
REARCH               ,:S-PROJECTED-CR-DT                                
REARCH               ,:S-PROJ-INT-AMT                                   
REARCH               ,:S-INTRST-RATE                                    
REARCH               ,:S-TOTAL-INTRST                                   
REARCH               ,:S-DATE-INTST-CALC-TO                             
REARCH               ,:S-REV-DISTRICT-DESC                              
REARCH               ,:S-USER-NAME-UPDT-BY                              
REARCH               ,:S-SERVICE-TYPE-CD                                
REARCH               ,:S-RETURN-CODE                                    
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02031_R1                                
MFA-TR*          (                                                              
MFA-TR*               DEPOSIT_STATUS_CD                                         
MFA-TR*              ,DEP_LESS_REFUND                                           
MFA-TR*              ,DATE_TRAN                                                 
MFA-TR*              ,DATE_CERT_ISSUE                                           
MFA-TR*              ,DEPOSIT_PAYOFF                                            
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,PROJECTED_CR_DT                                           
MFA-TR*              ,PROJ_INT_AMT                                              
MFA-TR*              ,INTRST_RATE                                               
MFA-TR*              ,TOTAL_INTRST                                              
MFA-TR*              ,DATE_INTST_CALC_TO                                        
MFA-TR*              ,REV_DISTRICT_DESC                                         
MFA-TR*              ,USER_NAME_UPDT_BY                                         
MFA-TR*              ,SERVICE_TYPE_CD                                           
MFA-TR*              ,RETURN_CODE                                               
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-DEPOSIT-STATUS-CD                                      
MFA-TR*              ,:S-DEP-LESS-REFUND                                        
MFA-TR*              ,:S-DATE-TRAN                                              
MFA-TR*              ,:S-DATE-CERT-ISSUE                                        
MFA-TR*              ,:S-DEPOSIT-PAYOFF                                         
MFA-TR*              ,:S-DEPOSIT-CERT-NO                                        
MFA-TR*              ,:S-PROJECTED-CR-DT                                        
MFA-TR*              ,:S-PROJ-INT-AMT                                           
MFA-TR*              ,:S-INTRST-RATE                                            
MFA-TR*              ,:S-TOTAL-INTRST                                           
MFA-TR*              ,:S-DATE-INTST-CALC-TO                                     
MFA-TR*              ,:S-REV-DISTRICT-DESC                                      
MFA-TR*              ,:S-USER-NAME-UPDT-BY                                      
MFA-TR*              ,:S-SERVICE-TYPE-CD                                        
MFA-TR*              ,:S-RETURN-CODE                                            
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02031_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      *                                                                 42357600
      ****************************************************************          
      *       EXTERNAL ROUTINES NEEDED FOR INTEREST PROCESSING       *          
      ****************************************************************          
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482         INCLUDE CPD00128                                                 
PCR482     END-EXEC.                                                            
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482         INCLUDE CPD00023                                                 
PCR482     END-EXEC.                                                            
      *                                                                         
PCR482     EXEC SQL                                                             
PCR482         INCLUDE CPD0023C                                                 
PCR482     END-EXEC.                                                            
      *                                                                         
      ******************************************************************42357700
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *42357800
      ******************************************************************42357900
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42358400
      * 9999- END PROGRAM COPYLIB                                      *42358500
      ******************************************************************42358600
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
