       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02028.                                         
COB303 DATE-WRITTEN.      FEBRAUARY 20, 1995.                           
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************        
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *        
CVT000*         S028 CONVERTED TO DB2 SP CSR02028 ON 09/05/2005        *        
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *        
CVT000*                                                                *        
CVT000*                    CVT000 - CONVERTED CODE                     *        
CVT000*                    CVT004 - NEEDED REVIEW                      *        
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *        
CVT000*                             POTENTIALLY BE DELETED             *        
CVT000*                                                                *        
CVT000******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S028                                           *        
      *  PROGRAM:       S028                                           *        
      *  CALLING SP:    S028                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CUSTOMER SPOUSE AND RELATIVE INFORMATION *        
      *  SUCH AS SSN, PHONE NUMBERS, OCCUPATION, ETC.                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/20/95    FAM      RPC ORIGINALLY ADDED.                    *        
      *  03/29/95    FAM      INCREASES SIZE OF LICENSE FIELD TO 19.   *        
      *  10/17/95    MJL      INSERT CSS_CONTRACT BEFORE XREF                   
      *  09/04/96    AG       TPR 4158  GET ADDRESS AND CONTACT IDS    *        
      *                       FROM COMMON COPYBOOKS.                   *        
T5707 *  10/04/96    JBW      TPR 5707. ONLY INSERT OR UPDATE SPOUSE   *        
T5707 *                       OR RELATIVE IF NAMES ARE NOT NULL.       *        
T4999 *  10/14/96    JBW      TPR 4999. INSERT/UPDATE SPOUSE IN CSS_   *        
T4999 *                       NAME_ACCT_XREF FOR EVERY ACCOUNT THE     *        
T4999 *                       CUSTOMER HAS, NOT JUST THE CURRENT ONE.\ *        
T7933 *  12/17/96    JEP      TPR 7933. CODES WERE SET TO HARD-CODED   *        
T7933 *                       LITERALS FOR "S" (SPOUSE) AND "R"        *        
T7933 *                       (RELATIVE) FOR THE MAINTENANCE JOURNALS, *        
T7933 *                       CSS_MT_TRN_HST_DET.                      *        
T8661 *  01/23/97    RPG      ADDED LAST NAME SECTION TO MODULE 5300   *        
T8661 *                       IT WAS MISSING THIS SECTION.             *        
T8661 *                       ALSO FIXED THE TRANS HIST OUTPUT, GOT RID*        
T8661 *                       OF NAME ID TRANS HIST. FIXED OTHER ID.   *        
T14139*  01/05/97    GAC      CHANGED CONTACT TYPE FOR RELATIVE FROM R *        
T14139*                       TO RL, AND PHONE TYPE FROM W1 TO H1.     *        
T14497*  01/26/98    GAC      SPOUSE PHONE TYPE WAS IMPROPERLY CHANGED *        
T14497*                       FROM W1 TO H1. CHANGED BACK.  RELATIVE   *        
T14497*                       PHONE TYPE IS CORRECT AS H1.             *        
T15670*  03/28/98    RK       DELETED CODE TO NOT INSERT NAME ACCT XREF*        
T15670*                       FOR NEAREST RELATIVE.                    *        
T16430*  05/18/98    FB       ALLOW NOT FOUND CONDITION ON ALL DELETES.*        
CBSI  *  07/17/98             ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *                       TABLE PARAMETERS                         *        
T18756*  12/29/98    FB       ALLOW NOT FOUND CONDITION ON UPDATE OF   *        
T18756*                       CSS_CUST_PHONE.                          *        
T21254* 01/04/2000   SK       CONTACT_ORDER SHOULD BE ZERO WHEN        *        
T21254*                       UPDATING RELATIVE DETAILS ON PANEL032.   *        
T19981* 01/04/2000   SK       ALLOW NOT FOUND CONDITION ON UPDATE OF   *        
T19981*                       CSS_CONTACT_PHONE.                       *        
T22161* 05/02/2000   SK       WHEN INSERTING TO CSS_NAME_ACCT_XREF     *        
T22161*                       INCLUDE TOWN, STATE, AND LOCAL_OFFICE.   *        
T27707* 02/02/2003   MJG      ADDED NEW PARMS TO LET THE CRS DECIDE THE*        
T27707*                       TYPE OF CONTACT AND INCLUDE SS# WHICH IS *        
      *                       CURRENTLY STORED IN NICKNAME FIELD       *        
T32002* 02/03/2005   DD       CORRECTED TRANS_HIST_DETAILS THAT WERE   *        
      *                       BEING ENTERED INCORRECTLY.               *        
C29586* 04/12/2005   DD       PREVENT SPOUSE WITH ITPA ALERT FROM      *        
C29586*                       BEING LINKED TO AN ACCOUNT.              *        
REARCH*  09/05/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C33453*  12/05/06    CVNS     CHANGES MADE FOR WORK QUEUE SEQ OBJECT   *        
C33453*                                                                *        
T35434*  07/06/07    MR97640  REPLACED MODEL_SQL WITH SET COMMAND AND  *        
T35434*                       ADDED FETCH WITH UR TO AVOID -911.       *        
C37510*  09/11/08    CVNS     NAME AND ADDRESS FORMAT CHANGES          *        
C37510*              CHENNAI                                           *        
A01362*  09/24/09    FB       IF SPOUSE PHONE NOT FOUND, INSERT. IF    *        
A01362*                       FOUND, UPDATE.                           *        
P00201*  03/23/10    FB       NO TRANSHIST BEING WRITTEN IF RELATIVE   *        
P00201*                       PHONE OR ADDRESS CHANGED.                *        
A37666*  04/27/10    FB       COMMENT OUT ADDRESS TABLE DELETES. FIX   *        
A37666*                       RELATIVE CONTACT DELETE LOGIC.           *        
A02292*  06/07/10    PA94870  APPL00002292 - CSS_CONTACT_PHONE         *        
A02292*                       WHEN THERE IS NO ROW IN THE TABLE        *        
A02292*                       UPDATE IS RETURNING NOT FOUND. MODIFIED  *        
A02292*                       TO INSERT NEW ROW, IF PHONENO>SPACES     *        
A02292*                       DELETED THE ROW FROM TABLE IF SPACES ARE *        
A02292*                       BEING UPDATED IN PHONE NO.               *        
A37666*  07/02/10    FB       COMMENT OUT NAME TABLE DELETES.          *        
A01360*  12/14/10   DB18339   ADDED FILTERING OF SSN.                           
A03212*  03/21/11    FB       ADDED TRANSHIST FOR VALID CONTACT        *        
A03212*                       CHECKBOX.                                *        
P00594*  09/17/12    FB       TWO NEW FIELDS ON CSS_NAME_ACCT_XREF     *        
P00757*  11/24/13  MC95456    REPLACED CSR00028 CALL WITH CSR04675     *        
P00740*  05/06/14    FB       POPULATE FIRST AND LAST NAME FOR RELATIVE*        
P00740*                       CONTACT. DEFAULT ACCESS LEVELS.          *        
P00740*  06/26/14    FB       IF BOTH SSN AND ITIN, SWITCH ITIN TO     *        
P00740*                       CONTACT TYPE OTHER.                      *        
A04860*  10/10/14  MC95456    REPLACED CSR04675 CALL WITH MCSCB077     *        
A05317*  03/09/16    FB       SWITCH RL TO OT IF TRANSACTION COMES     *        
A05317*                       FROM WEB.                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02028'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02028 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
A04860*    FOR MCSCB077                                                *        
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
C29586     EXEC SQL                                                             
C29586        INCLUDE TBCRHIST                                                  
C29586     END-EXEC.                                                            
                                                                        
C29586     EXEC SQL                                                             
C29586        INCLUDE TBCRITPA                                                  
C29586     END-EXEC.                                                            
                                                                        
C29586     EXEC SQL                                                             
C29586        INCLUDE TBCOMDAT                                                  
C29586     END-EXEC.                                                            
                                                                        
C29586     EXEC SQL                                                             
C29586        INCLUDE TBDELQ                                                    
C29586     END-EXEC.                                                            
                                                                        
C29586     EXEC SQL                                                             
C29586        INCLUDE TBACCT                                                    
C29586     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      * ADDED FOR JOURNALING                                                    
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
                                                                        
           COPY CWS00071.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0013A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0092A                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9) COMP.               
           05  PARM-UPDATE-TYPE           PIC X(01) VALUE SPACES.       
           05  PARM-CUSTOMER-NO           PIC X(10) VALUE SPACES.       
           05  PARM-CUSTOMER-NO-RED       REDEFINES PARM-CUSTOMER-NO    
                                          PIC 9(10).                    
COB305     05 PARM-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.     
           05  PARM-SPOUSE-FIRST-NAME     PIC X(15).                    
           05  PARM-SPOUSE-MIDDLE-NAME    PIC X(15).                    
           05  PARM-SPOUSE-LAST-NAME      PIC X(40).                    
           05  PARM-SPOUSE-OCCUPATION     PIC X(15).                    
           05  PARM-SPOUSE-WORK-PHONE     PIC X(10).                    
           05  PARM-SPOUSE-WORK-EXT       PIC X(06).                    
           05  PARM-SPOUSE-EMPLOYER       PIC X(23).                    
           05  PARM-SPOUSE-EMPLOYED-DATE  PIC X(10).                    
           05  PARM-SPOUSE-SSN            PIC X(09).                    
           05  PARM-SPOUSE-DATE-OF-BIRTH  PIC X(10).                    
           05  PARM-SPOUSE-LICENSE-NO     PIC X(19).                    
           05  PARM-SPOUSE-CODE-STATE-ID  PIC X(02).                    
           05  PARM-SPOUSE-DRVR-LIC-DT    PIC X(10).                    
           05  PARM-SPOUSE-OTHER-ID       PIC X(16).                    
           05  PARM-SPOUSE-OTHER-ID-TYPE  PIC X(12).                    
           05  PARM-RELATIVE-NAME         PIC X(70).                    
C37510     05  PARM-RELATIVE-STREET       PIC X(55).                    
           05  PARM-RELATIVE-RELNSHIP     PIC X(30).                    
C37510     05  PARM-RELATIVE-CITY-STATE   PIC X(30).                    
           05  PARM-RELATIVE-PHONE        PIC X(10).                    
           05  PARM-RELATIVE-ZIP          PIC X(09).                    
           05  PARM-ADDRESS-OVERFLOW      PIC X(35).                    
           05  PARM-USERID                PIC X(07) VALUE SPACES.       
           05  PARM-COMMENT-TEXT          PIC X(210) VALUE SPACES.      
           05  PARM-COMMENT-LEN           PIC X(04) VALUE SPACES.       
           05  PARM-COMMENT-LEN-RED       REDEFINES PARM-COMMENT-LEN    
                                          PIC 9(04).                    
           05  PARM-COMMENT-LEN-NUM       PIC S9(04) COMP VALUE 0.      
T27707     05  PARM-CONTACT-ASSOC         PIC X(01) VALUE SPACES.       
T27707     05  PARM-RELATIVE-NICKNAME     PIC X(50) VALUE SPACES.       
T27707     05  PARM-ACCOUNT-NO            PIC X(13) VALUE SPACES.       
T27707     05  PARM-ACCOUNT-NO-RED        REDEFINES PARM-ACCOUNT-NO     
T27707                                    PIC 9(13).                    
T27707     05  PARM-PREMISE-NO            PIC X(10) VALUE SPACES.       
T27707     05  PARM-PREMISE-NO-RED        REDEFINES PARM-PREMISE-NO     
T27707                                    PIC 9(10).                    
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-CODES.                                                    
           05  WS-SCEG                  PIC X(05) VALUE 'SCE&G'.        
T14139*    05  WS-CONTACT-TYPE          PIC X(01) VALUE 'R'.                    
T27707*** CREATED A NEW RELATIVE CONTACT TYPE THAT WE WILL FILTER               
T27707*** ON THE CONTACT PANEL.  NC STANDS FOR NON CONTACT.                     
T27707     05  WS-CONTACT-TYPE-NC       PIC X(02) VALUE 'RR'.           
T14139     05  WS-CONTACT-TYPE          PIC X(02) VALUE 'RL'.           
A05317     05  WS-CONTACT-TYPE-OT       PIC X(02) VALUE 'OT'.           
A05317     05  WS-CONTACT-TYPE-LIT-OT   PIC X(08) VALUE 'OTHER'.        
T7933      05  WS-CONTACT-TYPE-LIT      PIC X(08) VALUE 'RELATIVE'.     
           05  WS-CUSTOMER-TYPE         PIC X(01) VALUE 'S'.            
T7933      05  WS-CUSTOMER-TYPE-LIT     PIC X(06) VALUE 'SPOUSE'.       
           05  WS-FREEFORM-CODE         PIC X(01) VALUE 'I'.            
           05  WS-WORK-PHONE-TYPE       PIC X(02) VALUE 'W1'.           
T14139     05  WS-HOME-PHONE-TYPE       PIC X(02) VALUE 'H1'.           
           05  WS-NAME-FORMAT           PIC X(01) VALUE 'I'.            
           05  WS-CONTACT-TABLE         PIC X(01) VALUE 'C'.            
                                                                        
       01  WS-MISC.                                                     
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.       
COB305     05 WS-SPOUSE-CUST-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-CUSTOMER-NO           PIC 9(10)   VALUE ZERO.         
           05  WS-CUSTOMER-NO-RED       REDEFINES WS-CUSTOMER-NO        
                                        PIC X(10).                      
                                                                        
COB305     05 WS-NAME-ID-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-NAME-ID-NO            PIC 9(13)   VALUE ZERO.         
           05  WS-NAME-ID               REDEFINES WS-NAME-ID-NO         
                                        PIC X(13).                      
                                                                        
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
                                                                        
COB305     05 WS-CONT-ID-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05  WS-CONT-ID-NO            PIC 9(10)   VALUE ZERO.         
           05  WS-CONT-ID               REDEFINES WS-CONT-ID-NO         
                                        PIC X(10).                      
                                                                        
COB305     05 WS-ADDR-ID-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-ADDR-ID-NO            PIC 9(13)   VALUE ZERO.         
           05  WS-ADDR-ID               REDEFINES WS-ADDR-ID-NO         
                                        PIC X(13).                      
                                                                        
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-MISC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 MISC-CHANGED                    VALUE 'YES'.          
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-BSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 BSTS-CHANGED                    VALUE 'YES'.          
           05  WS-CUST-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CUST-CHANGED                    VALUE 'YES'.          
                                                                        
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-BSPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 BSPH-EXISTS                     VALUE 'YES'.          
           05  WS-MISC-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 MISC-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-BSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 BSTS-EXISTS                     VALUE 'YES'.          
           05  WS-CUST-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CUST-EXISTS                     VALUE 'YES'.          
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-RELT-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 RELT-EXISTS                     VALUE 'YES'.          
           05  WS-SPOUSE-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.   
               88 SPOUSE-CSTS-EXISTS                     VALUE 'YES'.   
                                                                        
           05  WS-NULL-IND-1            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-2            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-3            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-4            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-5            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-6            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-7            PIC S9(04) COMP VALUE ZERO.     
C29586     05  WS-NULL-IND-8            PIC S9(04) COMP VALUE ZERO.     
C29586     05  WS-NULL-IND-9            PIC S9(04) COMP VALUE ZERO.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02028'.     
A04860     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
C29586     05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
P00740     05  WS-DATABASE              PIC 9(01) VALUE 0.              
P00740         88  CSR-DATABASE                   VALUE 1.              
P00740         88  SEB-DATABASE                   VALUE 2.              
P00740     05  WS-PARSED-FIRST-NAME     PIC X(15) VALUE SPACES.         
P00740     05  WS-PARSED-LAST-NAME      PIC X(40) VALUE SPACES.         
P00740     05  WS-SUB1                  PIC S9(4) COMP VALUE 0.         
                                                                        
           05  WS-FULL-NAME.                                            
               10 WS-LAST-NAME          PIC X(40) VALUE SPACES.         
               10 WS-FIRST-NAME         PIC X(15) VALUE SPACES.         
               10 WS-MIDDLE-NAME        PIC X(15) VALUE SPACES.         
                                                                        
T22161     05  WS-TOWN                  PIC X(26) VALUE SPACES.         
T22161     05  WS-STATE                 PIC X(02) VALUE SPACES.         
T22161     05  WS-LOCAL-OFFICE          PIC X(26) VALUE SPACES.         
P00594     05  WS-ACCOUNT-TYPE-CODE     PIC X(01) VALUE SPACES.         
P00594     05  WS-CODE-ACCT-STAT        PIC X(01) VALUE SPACES.         
C29586     05  WS-WQ-LITERAL.                                           
C29586         10  FILLER               PIC X(47) VALUE                 
C29586            'ATTEMPTED TO ADD SPOUSE WITH UNRESOLVED ITPA - '.    
C29586         10  WS-WQ-NAME           PIC X(50) VALUE SPACES.         
C29586         10  WS-WQ-SSN            PIC X(11) VALUE SPACES.         
                                                                        
       01  LENGTH-VARS.                                                 
           05  WS-VARCHAR-MAX           PIC S9(04) COMP VALUE +30.      
           05  WS-VARCHAR-LEN           PIC S9(04) COMP VALUE ZERO.     
           05  WS-MAX-LEN               PIC S9(04) COMP VALUE ZERO.     
           05  WS-VARCHAR               PIC X(30) VALUE SPACES.         
           05  FILLER REDEFINES WS-VARCHAR.                             
               10 WS-VARCHAR-POS        PIC X(01) OCCURS 30.            
                                                                        
A04860 01  WS-MCSCB077-OUTPUT.                                          
A04860     05  WS-MCSCB077-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
C29586*01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
C29586*                          RESULT-SET-LOCATOR VARYING.            
C29586 01  ERROR-MESSAGE.                                               
C29586     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C29586     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C29586                           INDEXED BY ERROR-INDEX.                
C29586 77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
C29586 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C29586 77  OPENFN                PIC X(12).                             
C29586 77  SSID                  PIC X(4).                              
C29586 77  PLANNAME              PIC X(8).                              
C29586 77  RETCODE               PIC S9(5).                             
C29586 77  REASCODE              PIC S9(5).                             
C29586 77  CLOSFN                PIC X(12).                             
C29586 77  TERMOP                PIC X(4).                              
C29586                                                                  
      ******************************************************************        
      *    CURSOR DECLARATIONS.                                        *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    RETRIEVES ALL OF THE CUSTOMER'S ACCOUNTS FROM NAME-ACCT-XREF*        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE SPOUSE_CURSOR CURSOR FOR                         
                   SELECT HT.ACCOUNT_NO,                                
                          HT.ADDRESS_ID,                                
                          HT.COMPANY_NO,                                
                          HT.PREMISE_NO,                                
T22161                    HT.TOWN,                                      
T22161                    HT.STATE,                                     
T22161                    HT.LOCAL_OFFICE,                              
P00594                    HT.ACCOUNT_TYPE_CODE,                         
P00594                    HT.CODE_ACCT_STAT                             
                     FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),          
                          CSS_NAME DQ WITH(READUNCOMMITTED)                     
                    WHERE HT.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM          
                      AND HT.NAME_ID = DQ.NAME_ID                       
                      AND DQ.NAME_TYPE = 'CN'                           
                      AND HT.CUSTOMER_ROLE_CD = ' '                     
T35434                FOR READ ONLY                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPOUSE_CURSOR CURSOR FOR                                 
MFA-TR*            SELECT HT.ACCOUNT_NO,                                        
MFA-TR*                   HT.ADDRESS_ID,                                        
MFA-TR*                   HT.COMPANY_NO,                                        
MFA-TR*                   HT.PREMISE_NO,                                        
MFA-TR*                   HT.TOWN,                                              
MFA-TR*                   HT.STATE,                                             
MFA-TR*                   HT.LOCAL_OFFICE,                                      
MFA-TR*                   HT.ACCOUNT_TYPE_CODE,                                 
MFA-TR*                   HT.CODE_ACCT_STAT                                     
MFA-TR*              FROM CSS_NAME_ACCT_XREF HT,                                
MFA-TR*                   CSS_NAME DQ                                           
MFA-TR*             WHERE HT.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
MFA-TR*               AND HT.NAME_ID = DQ.NAME_ID                               
MFA-TR*               AND DQ.NAME_TYPE = 'CN'                                   
MFA-TR*               AND HT.CUSTOMER_ROLE_CD = ' '                             
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*             QUERYNO 8400                                                
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE STATS_CURSOR CURSOR FOR                           
              SELECT CUSTOMER_NO                                        
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  SSN   = :CE-SSN                                    
              AND  CUSTOMER_TYPE = 'C'                                  
T35434        FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE STATS_CURSOR CURSOR FOR                                   
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  SSN   = :CE-SSN                                            
MFA-TR*       AND  CUSTOMER_TYPE = 'C'                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 8430                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
CVT000     EXEC SQL                                                             
CVT000         INCLUDE CWSX0010                                                 
CVT000     END-EXEC.                                                            
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.                
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-UPDATE-TYPE          PIC X(01)                .         
CVT000 01  LINK-CUSTOMER-NO          PIC X(10)                .         
CVT000 01  LINK-CUSTOMER-NO-RED      PIC 9(10)                .         
COB305 01 LINK-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.         
CVT000 01  LINK-SPOUSE-FIRST-NAME    PIC X(15)                .         
CVT000 01  LINK-SPOUSE-MIDDLE-NAME   PIC X(15)                .         
CVT000 01  LINK-SPOUSE-LAST-NAME     PIC X(40)                .         
CVT000 01  LINK-SPOUSE-OCCUPATION    PIC X(15)                .         
CVT000 01  LINK-SPOUSE-WORK-PHONE    PIC X(10)                .         
CVT000 01  LINK-SPOUSE-WORK-EXT      PIC X(06)                .         
CVT000 01  LINK-SPOUSE-EMPLOYER      PIC X(23)                .         
CVT000 01  LINK-SPOUSE-EMPLOYED-DATE PIC X(10)                .         
CVT000 01  LINK-SPOUSE-SSN           PIC X(09)                .         
CVT000 01  LINK-SPOUSE-DATE-OF-BIRTH PIC X(10)                .         
CVT000 01  LINK-SPOUSE-LICENSE-NO    PIC X(19)                .         
CVT000 01  LINK-SPOUSE-CODE-STATE-ID PIC X(02)                .         
CVT000 01  LINK-SPOUSE-DRVR-LIC-DT   PIC X(10)                .         
CVT000 01  LINK-SPOUSE-OTHER-ID      PIC X(16)                .         
CVT000 01  LINK-SPOUSE-OTHER-ID-TYPE PIC X(12)                .         
CVT000 01  LINK-RELATIVE-NAME        PIC X(70)                .         
C37510 01  LINK-RELATIVE-STREET      PIC X(55)                .         
CVT000 01  LINK-RELATIVE-RELNSHIP    PIC X(30)                .         
C37510 01  LINK-RELATIVE-CITY-STATE  PIC X(30)                .         
CVT000 01  LINK-RELATIVE-PHONE       PIC X(10)                .         
CVT000 01  LINK-RELATIVE-ZIP         PIC X(09)                .         
CVT000 01  LINK-ADDRESS-OVERFLOW     PIC X(35)                .         
CVT000 01  LINK-USERID               PIC X(07)                .         
CVT000 01  LINK-COMMENT-TEXT         PIC X(210)               .         
CVT000 01  LINK-COMMENT-LEN          PIC X(04)                .         
CVT000 01  LINK-COMMENT-LEN-RED      PIC 9(04)                .         
CVT000 01  LINK-COMMENT-LEN-NUM      PIC S9(04) COMP          .         
CVT000 01  LINK-CONTACT-ASSOC        PIC X(01)                .         
CVT000 01  LINK-RELATIVE-NICKNAME    PIC X(50)                .         
CVT000 01  LINK-ACCOUNT-NO           PIC X(13)                .         
CVT000 01  LINK-ACCOUNT-NO-RED       PIC 9(13)                .         
CVT000 01  LINK-PREMISE-NO           PIC X(10)                .         
CVT000 01  LINK-PREMISE-NO-RED       PIC 9(10)                .         
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-UPDATE-TYPE                                        
CVT000         ,LINK-CUSTOMER-NO                                        
CVT000         ,LINK-SPOUSE-FIRST-NAME                                  
CVT000         ,LINK-SPOUSE-MIDDLE-NAME                                 
CVT000         ,LINK-SPOUSE-LAST-NAME                                   
CVT000         ,LINK-SPOUSE-OCCUPATION                                  
CVT000         ,LINK-SPOUSE-WORK-PHONE                                  
CVT000         ,LINK-SPOUSE-WORK-EXT                                    
CVT000         ,LINK-SPOUSE-EMPLOYER                                    
CVT000         ,LINK-SPOUSE-EMPLOYED-DATE                               
CVT000         ,LINK-SPOUSE-SSN                                         
CVT000         ,LINK-SPOUSE-DATE-OF-BIRTH                               
CVT000         ,LINK-SPOUSE-LICENSE-NO                                  
CVT000         ,LINK-SPOUSE-CODE-STATE-ID                               
CVT000         ,LINK-SPOUSE-DRVR-LIC-DT                                 
CVT000         ,LINK-SPOUSE-OTHER-ID                                    
CVT000         ,LINK-SPOUSE-OTHER-ID-TYPE                               
CVT000         ,LINK-RELATIVE-NAME                                      
CVT000         ,LINK-RELATIVE-STREET                                    
CVT000         ,LINK-RELATIVE-RELNSHIP                                  
CVT000         ,LINK-RELATIVE-CITY-STATE                                
CVT000         ,LINK-RELATIVE-PHONE                                     
CVT000         ,LINK-RELATIVE-ZIP                                       
CVT000         ,LINK-ADDRESS-OVERFLOW                                   
CVT000         ,LINK-USERID                                             
CVT000         ,LINK-COMMENT-TEXT                                       
CVT000         ,LINK-COMMENT-LEN                                        
CVT000         ,LINK-CONTACT-ASSOC                                      
CVT000         ,LINK-RELATIVE-NICKNAME                                  
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-PREMISE-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE               AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE               AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-UPDATE-TYPE          TO PARM-UPDATE-TYPE         . 
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-SPOUSE-FIRST-NAME    TO PARM-SPOUSE-FIRST-NAME   . 
CVT000     MOVE LINK-SPOUSE-MIDDLE-NAME   TO PARM-SPOUSE-MIDDLE-NAME  . 
CVT000     MOVE LINK-SPOUSE-LAST-NAME     TO PARM-SPOUSE-LAST-NAME    . 
CVT000     MOVE LINK-SPOUSE-OCCUPATION    TO PARM-SPOUSE-OCCUPATION   . 
CVT000     MOVE LINK-SPOUSE-WORK-PHONE    TO PARM-SPOUSE-WORK-PHONE   . 
CVT000     MOVE LINK-SPOUSE-WORK-EXT      TO PARM-SPOUSE-WORK-EXT     . 
CVT000     MOVE LINK-SPOUSE-EMPLOYER      TO PARM-SPOUSE-EMPLOYER     . 
CVT000     MOVE LINK-SPOUSE-EMPLOYED-DATE TO PARM-SPOUSE-EMPLOYED-DATE. 
CVT000     MOVE LINK-SPOUSE-SSN           TO PARM-SPOUSE-SSN          . 
CVT000     MOVE LINK-SPOUSE-DATE-OF-BIRTH TO PARM-SPOUSE-DATE-OF-BIRTH. 
CVT000     MOVE LINK-SPOUSE-LICENSE-NO    TO PARM-SPOUSE-LICENSE-NO   . 
CVT000     MOVE LINK-SPOUSE-CODE-STATE-ID TO PARM-SPOUSE-CODE-STATE-ID. 
CVT000     MOVE LINK-SPOUSE-DRVR-LIC-DT   TO PARM-SPOUSE-DRVR-LIC-DT  . 
CVT000     MOVE LINK-SPOUSE-OTHER-ID      TO PARM-SPOUSE-OTHER-ID     . 
CVT000     MOVE LINK-SPOUSE-OTHER-ID-TYPE TO PARM-SPOUSE-OTHER-ID-TYPE. 
CVT000     MOVE LINK-RELATIVE-NAME        TO PARM-RELATIVE-NAME       . 
CVT000     MOVE LINK-RELATIVE-STREET      TO PARM-RELATIVE-STREET     . 
CVT000     MOVE LINK-RELATIVE-RELNSHIP    TO PARM-RELATIVE-RELNSHIP   . 
CVT000     MOVE LINK-RELATIVE-CITY-STATE  TO PARM-RELATIVE-CITY-STATE . 
CVT000     MOVE LINK-RELATIVE-PHONE       TO PARM-RELATIVE-PHONE      . 
CVT000     MOVE LINK-RELATIVE-ZIP         TO PARM-RELATIVE-ZIP        . 
CVT000     MOVE LINK-ADDRESS-OVERFLOW     TO PARM-ADDRESS-OVERFLOW    . 
CVT000     MOVE LINK-USERID               TO PARM-USERID              . 
CVT000     MOVE LINK-COMMENT-TEXT         TO PARM-COMMENT-TEXT        . 
CVT000     MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN         . 
CVT000     MOVE LINK-CONTACT-ASSOC        TO PARM-CONTACT-ASSOC       . 
CVT000     MOVE LINK-RELATIVE-NICKNAME    TO PARM-RELATIVE-NICKNAME   . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * 1.  RECEIVE PARMS FROM THE CLIENT.                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO-RED     TO PARM-CUSTOMER-NO-NUM.       
           MOVE PARM-CUSTOMER-NO-NUM     TO WS-CUSTOMER-NO-NUM.         
           MOVE PARM-ACCOUNT-NO-RED      TO WS-ACCOUNT-NO-NUM.          
           MOVE PARM-PREMISE-NO-RED      TO WS-PREMISE-NO-NUM.          
           MOVE PARM-COMMENT-LEN-RED     TO PARM-COMMENT-LEN-NUM.       
P00740     IF PARM-RELATIVE-NAME > ' '                                  
P00740         MOVE +1 TO WS-SUB1                                       
P00740         PERFORM UNTIL PARM-RELATIVE-NAME (WS-SUB1:1) <= ' '      
P00740             ADD +1 TO WS-SUB1                                    
P00740         END-PERFORM                                              
P00740         MOVE PARM-RELATIVE-NAME (1:WS-SUB1 - 1) TO               
P00740              WS-PARSED-FIRST-NAME                                
P00740         MOVE PARM-RELATIVE-NAME (WS-SUB1 + 1:20) TO              
P00740              WS-PARSED-LAST-NAME                                 
P00740         IF WS-PARSED-LAST-NAME <= SPACES                         
P00740             MOVE WS-PARSED-FIRST-NAME TO WS-PARSED-LAST-NAME
               END-IF
           END-IF.    
P00740         IF PARM-SPOUSE-SSN > SPACES AND                          
P00740            PARM-SPOUSE-OTHER-ID > SPACES AND                     
P00740            PARM-SPOUSE-OTHER-ID-TYPE = 'ITIN'                    
P00740                MOVE 'OTHER' TO PARM-SPOUSE-OTHER-ID-TYPE
               END-IF.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   2000-PROCESS-OUTPUT                                          *        
      *   1. DESCRIBE RESULT SET                                       *        
      *   2. RETRIEVE DB2 DATA                                         *        
      *   3. BUILD RESULT SET                                          *        
      *   4. SEND RESULT SET                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE.              
           MOVE '2000'                  TO ACTIVE-PARAGRAPH.            
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
                                                                        
      ******************************************************************        
      *   5000-UPDATE.                                                 *        
      *   1.   BASED ON THE ACTION CODE (MAINTAIN\DELETE)              *        
      *        PERFORM FUNCTIONALITY.                                  *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID     THRU 7080-EXIT.         
P00740     PERFORM 7170-DETERMINE-REGION THRU 7170-EXIT.                
P00740     MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
                                                                        
           MOVE PARM-SPOUSE-FIRST-NAME     TO WS-FIRST-NAME             
           MOVE PARM-SPOUSE-MIDDLE-NAME    TO WS-MIDDLE-NAME            
           MOVE PARM-SPOUSE-LAST-NAME      TO WS-LAST-NAME              
                                                                        
           PERFORM 5100-JRNL-TRAN-HEAD     THRU 5100-EXIT               
                                                                        
           MOVE 'NO '                      TO WS-CSTS-EXISTS-FLAG       
           PERFORM 7020-SELECT-CUST-STATS  THRU 7020-EXIT               
           IF CSTS-EXISTS                                               
              PERFORM 7030-SELECT-PHONE    THRU 7030-EXIT               
              MOVE CE-NAME-ID              TO DQ-NAME-ID                
              PERFORM 7040-SELECT-NAME     THRU 7040-EXIT               
           END-IF.                                                      
                                                                        
           MOVE 'NO '                      TO WS-RELT-EXISTS-FLAG       
           PERFORM 7100-SELECT-RELATIVE    THRU 7100-EXIT               
           IF RELT-EXISTS                                               
              MOVE CV-NAME-ID              TO DQ-NAME-ID                
              PERFORM 7040-SELECT-NAME     THRU 7040-EXIT               
              MOVE CV-ADDRESS-ID           TO DZ-ADDRESS-ID             
              PERFORM 7050-SELECT-ADDRESS  THRU 7050-EXIT               
              MOVE CV-CONTACT-ID           TO LP-CONTACT-ID             
              PERFORM 7090-SELECT-CONT-PHONE THRU 7090-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-UPDATE-TYPE = 'M'                                    
                                                                        
      *       MOVE PARM-CUSTOMER-NO-NUM      TO CB-CUSTOMER-NO                  
T14139*       MOVE WS-WORK-PHONE-TYPE        TO CB-PHONE-TYPE                   
T14139*       MOVE WS-HOME-PHONE-TYPE        TO CB-PHONE-TYPE                   
T14497*       MOVE WS-WORK-PHONE-TYPE        TO CB-PHONE-TYPE                   
      *       MOVE PARM-SPOUSE-WORK-PHONE    TO CB-PHONE-NO                     
      *       MOVE PARM-SPOUSE-WORK-EXT      TO CB-EXTENSION-NO                 
      *       MOVE WS-CUSTOMER-TYPE          TO CB-CUSTOMER-TYPE                
      *                                                                         
T5707         IF CSTS-EXISTS AND PARM-SPOUSE-LAST-NAME > SPACES         
C29586            IF PARM-SPOUSE-SSN > SPACES                           
C29586              PERFORM 7130-ITPA-CHECK        THRU 7130-EXIT       
                  END-IF                                                
                  PERFORM 7020-SELECT-CUST-STATS THRU 7020-EXIT         
                  MOVE CE-NAME-ID                TO DQ-NAME-ID          
                  PERFORM 7040-SELECT-NAME       THRU 7040-EXIT         
                  PERFORM 5300-JRNL-UPDATE-CUST  THRU 5300-EXIT         
                  MOVE PARM-CUSTOMER-NO-NUM TO CB-CUSTOMER-NO           
T32002*           MOVE WS-WORK-PHONE-TYPE    TO CB-PHONE-TYPE                   
T32002*           MOVE WS-HOME-PHONE-TYPE    TO CB-PHONE-TYPE                   
T32002            MOVE WS-WORK-PHONE-TYPE    TO CB-PHONE-TYPE           
T32002            MOVE PARM-SPOUSE-WORK-PHONE TO CB-PHONE-NO            
T32002            MOVE PARM-SPOUSE-WORK-EXT TO CB-EXTENSION-NO          
T32002            MOVE WS-CUSTOMER-TYPE      TO CB-CUSTOMER-TYPE        
                  MOVE PARM-SPOUSE-FIRST-NAME    TO DQ-FIRST-NAME       
                  MOVE PARM-SPOUSE-MIDDLE-NAME   TO DQ-MIDDLE-NAME      
                  MOVE PARM-SPOUSE-LAST-NAME     TO DQ-LAST-NAME        
                  MOVE WS-FULL-NAME              TO DQ-FULL-NAME        
                  MOVE PARM-CUSTOMER-NO-NUM      TO CE-CUSTOMER-NO      
                  MOVE WS-CUSTOMER-TYPE          TO CE-CUSTOMER-TYPE    
                  MOVE PARM-SPOUSE-SSN           TO CE-SSN              
                  MOVE PARM-SPOUSE-CODE-STATE-ID TO CE-CODE-STATE-ID    
                  MOVE PARM-SPOUSE-LICENSE-NO  TO CE-DRIVERS-LICENSE-NO 
                  MOVE PARM-SPOUSE-EMPLOYER      TO CE-EMPLOYER         
                  MOVE PARM-SPOUSE-EMPLOYED-DATE TO CE-EMPLOYED-DATE    
                  MOVE PARM-SPOUSE-OCCUPATION    TO CE-OCCUPATION       
                  MOVE PARM-SPOUSE-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE    
                  MOVE PARM-SPOUSE-OTHER-ID      TO CE-OTHER-ID         
                  MOVE PARM-SPOUSE-DRVR-LIC-DT   TO CE-DRVR-LIC-ISS-DT  
                  MOVE PARM-SPOUSE-DATE-OF-BIRTH TO CE-DATE-OF-BIRTH    
                                                                        
                  PERFORM 8320-UPDATE-CSTS       THRU 8320-EXIT         
A01362            IF PARM-SPOUSE-WORK-PHONE > ' '                       
                      PERFORM 8330-UPDATE-PHONE      THRU 8330-EXIT     
A01362            ELSE                                                  
A01362                PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT     
A01362            END-IF                                                
                  PERFORM 8340-UPDATE-NAME       THRU 8340-EXIT         
              ELSE                                                      
T5707           IF PARM-SPOUSE-LAST-NAME > SPACES                       
C29586            IF PARM-SPOUSE-SSN > SPACES                           
C29586              PERFORM 7130-ITPA-CHECK        THRU 7130-EXIT       
                  END-IF                                                
                  PERFORM 5200-JRNL-INSERT-CUST  THRU 5200-EXIT         
T32002            MOVE PARM-CUSTOMER-NO-NUM TO CB-CUSTOMER-NO           
T32002*           MOVE WS-WORK-PHONE-TYPE    TO CB-PHONE-TYPE                   
T32002*           MOVE WS-HOME-PHONE-TYPE    TO CB-PHONE-TYPE                   
T32002            MOVE WS-WORK-PHONE-TYPE    TO CB-PHONE-TYPE           
T32002            MOVE PARM-SPOUSE-WORK-PHONE TO CB-PHONE-NO            
T32002            MOVE PARM-SPOUSE-WORK-EXT TO CB-EXTENSION-NO          
T32002            MOVE WS-CUSTOMER-TYPE      TO CB-CUSTOMER-TYPE        
*T4158*           PERFORM 7010-SELECT-NAME-ID    THRU 7010-EXIT                 
*T4158*           ADD 1   TO I7-NAME-ID   GIVING WS-NAME-ID-NO-NUM              
*T4158*           MOVE WS-NAME-ID-NO-NUM  TO WS-NAME-ID-NO                      
*T4158*           PERFORM 8310-UPDATE-NAME-ID    THRU 8310-EXIT                 
                                                                        
*T4158            MOVE 'PANEL032'             TO WS-91-PANEL-NO         
*T4158            MOVE PARM-USERID            TO WS-91-USERID           
*T4158            MOVE ZEROS                  TO WS-91-ACCOUNT-NO       
*T4158            MOVE WS-CUSTOMER-NO-NUM     TO WS-91-CUSTOMER-NO      
*T4158            MOVE ZEROS                  TO WS-91-PREMISE-NO       
                                                                        
*T4158            PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT           
*T4158            MOVE WS-91-NEW-NAME-ID      TO WS-NAME-ID-NO-NUM      
*T4158            MOVE WS-NAME-ID-NO-NUM         TO WS-NAME-ID-NO       
                                                                        
                  MOVE WS-NAME-ID-NO-NUM         TO DQ-NAME-ID          
                  MOVE 'SN'                      TO DQ-NAME-TYPE        
                  MOVE PARM-SPOUSE-FIRST-NAME    TO DQ-FIRST-NAME       
                  MOVE PARM-SPOUSE-MIDDLE-NAME   TO DQ-MIDDLE-NAME      
                  MOVE PARM-SPOUSE-LAST-NAME     TO DQ-LAST-NAME        
                  MOVE WS-FULL-NAME              TO DQ-FULL-NAME        
                  MOVE WS-NAME-FORMAT            TO DQ-NAME-FORMAT      
                  MOVE MH-TRANS-HIST-SEQ-NO      TO DQ-CREATED-DATE     
P00740            MOVE SPACES                    TO DQ-TITLE-PREFIX     
P00740                                              DQ-TITLE-SUFFIX-1   
P00740                                              DQ-TITLE-SUFFIX-2   
                                                                        
                  PERFORM 8010-INSERT-NAME       THRU 8010-EXIT         
                                                                        
                  MOVE WS-NAME-ID-NO-NUM         TO HT-NAME-ID          
                  MOVE WS-CUSTOMER-NO-NUM        TO HT-CUSTOMER-NO      
T4999             PERFORM 8400-OPEN-SPOUSE-CURSOR  THRU 8400-EXIT       
T4999             PERFORM 8410-FETCH-ALL-ACCOUNTS  THRU 8410-EXIT       
T4999             PERFORM 5400-PROCESS-ACCOUNTS    THRU 5400-EXIT       
T4999               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
T4999             PERFORM 8420-CLOSE-SPOUSE-CURSOR THRU 8420-EXIT       
                                                                        
A01362            IF PARM-SPOUSE-WORK-PHONE > ' '                       
                      PERFORM 8030-INSERT-PHONE      THRU 8030-EXIT     
A01362            END-IF                                                
                                                                        
                  MOVE WS-NAME-ID-NO-NUM         TO CE-NAME-ID          
                  MOVE SPACES                    TO CE-EMPLOYEE-NBR     
                  MOVE SPACES                    TO CE-INTR-CO-IND      
                                                                        
                  MOVE PARM-CUSTOMER-NO-NUM      TO CE-CUSTOMER-NO      
                  MOVE WS-CUSTOMER-TYPE          TO CE-CUSTOMER-TYPE    
                  MOVE PARM-SPOUSE-SSN           TO CE-SSN              
                  MOVE PARM-SPOUSE-CODE-STATE-ID TO CE-CODE-STATE-ID    
                  MOVE PARM-SPOUSE-LICENSE-NO  TO CE-DRIVERS-LICENSE-NO 
                  MOVE PARM-SPOUSE-EMPLOYER      TO CE-EMPLOYER         
                  MOVE PARM-SPOUSE-EMPLOYED-DATE TO CE-EMPLOYED-DATE    
                  MOVE PARM-SPOUSE-OCCUPATION    TO CE-OCCUPATION       
                  MOVE PARM-SPOUSE-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE    
                  MOVE PARM-SPOUSE-OTHER-ID      TO CE-OTHER-ID         
                  MOVE PARM-SPOUSE-DRVR-LIC-DT   TO CE-DRVR-LIC-ISS-DT  
                  MOVE PARM-SPOUSE-DATE-OF-BIRTH TO CE-DATE-OF-BIRTH    
P00740            IF CSR-DATABASE                                       
P00740                MOVE '02' TO CE-ACCESS-LEVEL-CD                   
P00740            ELSE                                                  
P00740                MOVE '01' TO CE-ACCESS-LEVEL-CD                   
P00740            END-IF                                                
                                                                        
                  PERFORM 8040-INSERT-CUST-STATS THRU 8040-EXIT         
T5707           END-IF                                                  
              END-IF                                                    
                                                                        
              MOVE +30                       TO WS-MAX-LEN              
              MOVE PARM-RELATIVE-RELNSHIP    TO WS-VARCHAR              
              PERFORM 5900-CALC-VARCHAR-LENGTH THRU 5900-EXIT           
              MOVE WS-VARCHAR-LEN            TO CV-CONTACT-POSITION-LEN 
              MOVE PARM-RELATIVE-RELNSHIP    TO CV-CONTACT-POSITION-TEXT
T27707        IF PARM-CONTACT-ASSOC = 'N'                               
T27707           MOVE WS-CONTACT-TYPE-NC     TO CV-CONTACT-TYPE         
T27707        ELSE                                                      
A05317           IF LINK-USERID = 'WEBTRN1'                             
A05317               MOVE WS-CONTACT-TYPE-OT TO CV-CONTACT-TYPE         
A05317           ELSE                                                   
T27070               MOVE WS-CONTACT-TYPE TO CV-CONTACT-TYPE            
A05317           END-IF                                                 
T27707        END-IF                                                    
                                                                        
                                                                        
T14139*       MOVE WS-WORK-PHONE-TYPE        TO LP-PHONE-TYPE                   
T14139        MOVE WS-HOME-PHONE-TYPE        TO LP-PHONE-TYPE           
      *       MOVE PARM-RELATIVE-PHONE       TO LP-PHONE-NO                     
                                                                        
      *       MOVE PARM-RELATIVE-STREET      TO DZ-ADDR-STREET                  
      *       MOVE PARM-RELATIVE-CITY-STATE  TO DZ-ADDR-CITY-STATE              
      *       MOVE PARM-RELATIVE-ZIP         TO DZ-ADDR-ZIP-CODE                
      *       MOVE PARM-ADDRESS-OVERFLOW     TO DZ-ADDRESS-OVERFLOW             
                                                                        
T5707         IF RELT-EXISTS AND PARM-RELATIVE-NAME > SPACES            
                  PERFORM 7100-SELECT-RELATIVE   THRU 7100-EXIT         
                  MOVE CV-NAME-ID                TO DQ-NAME-ID          
                  PERFORM 7040-SELECT-NAME       THRU 7040-EXIT         
                  PERFORM 5350-JRNL-UPDATE-RELT  THRU 5350-EXIT         
                                                                        
                  MOVE PARM-RELATIVE-NAME        TO DQ-FULL-NAME        
                  MOVE PARM-RELATIVE-NICKNAME    TO DQ-NICKNAME         
                  MOVE CV-ADDRESS-ID             TO DZ-ADDRESS-ID       
                  MOVE CV-CONTACT-ID             TO LP-CONTACT-ID       
                                                                        
                  PERFORM 8340-UPDATE-NAME       THRU 8340-EXIT         
                 MOVE PARM-RELATIVE-STREET      TO DZ-ADDR-STREET       
                 MOVE PARM-RELATIVE-CITY-STATE  TO DZ-ADDR-CITY-STATE   
                 MOVE PARM-RELATIVE-ZIP         TO DZ-ADDR-ZIP-CODE     
                 MOVE PARM-ADDRESS-OVERFLOW     TO DZ-ADDRESS-OVERFLOW  
                                                                        
                 MOVE WS-VARCHAR-LEN         TO CV-CONTACT-POSITION-LEN 
                 MOVE PARM-RELATIVE-RELNSHIP TO CV-CONTACT-POSITION-TEXT
                 MOVE WS-CONTACT-TYPE        TO CV-CONTACT-TYPE         
T14139*          MOVE WS-WORK-PHONE-TYPE     TO LP-PHONE-TYPE                   
T14139           MOVE WS-HOME-PHONE-TYPE     TO LP-PHONE-TYPE           
                 MOVE PARM-RELATIVE-PHONE    TO LP-PHONE-NO             
T27707           IF PARM-CONTACT-ASSOC = 'N'                            
T27707              MOVE WS-CONTACT-TYPE-NC     TO CV-CONTACT-TYPE      
T27707           ELSE                                                   
T27070              MOVE WS-CONTACT-TYPE        TO CV-CONTACT-TYPE      
T27707           END-IF                                                 
                  PERFORM 8350-UPDATE-CONTACT    THRU 8350-EXIT         
                                                                        
A02292            IF LP-PHONE-NO > SPACES                               
                    PERFORM 8360-UPDATE-CONT-PHONE THRU 8360-EXIT       
A02292            ELSE                                                  
A02292              PERFORM 8220-DELETE-CONT-PHONE THRU 8220-EXIT       
A02292            END-IF                                                
                  PERFORM 8370-UPDATE-ADDRESS    THRU 8370-EXIT         
              ELSE                                                      
T5707           IF PARM-RELATIVE-NAME > SPACES                          
                  PERFORM 5250-JRNL-INSERT-RELT  THRU 5250-EXIT         
                                                                        
*T4158*           PERFORM 7060-SELECT-CONTACT-ID THRU 7060-EXIT                 
*T4158*           ADD 1   TO I6-CONTACT-ID GIVING WS-CONT-ID-NO-NUM             
*T4158*           MOVE WS-CONT-ID-NO-NUM         TO WS-CONT-ID-NO               
*T4158*           PERFORM 8380-UPDATE-CONT-ID    THRU 8380-EXIT                 
                                                                        
*T4158            MOVE 'PANEL032'             TO WS-92-PANEL-NO         
*T4158            MOVE PARM-USERID            TO WS-92-USERID           
*T4158            MOVE ZEROS                  TO WS-92-ACCOUNT-NO       
*T4158            MOVE WS-CUSTOMER-NO-NUM     TO WS-92-CUSTOMER-NO      
*T4158            MOVE ZEROS                  TO WS-92-PREMISE-NO       
                                                                        
*T4158            PERFORM 6402-GET-NEW-CNTCT-ID THRU 6402-EXIT          
*T4158            MOVE WS-92-NEW-CONTACT-ID      TO WS-CONT-ID-NO-NUM   
*T4158            MOVE WS-CONT-ID-NO-NUM         TO WS-CONT-ID-NO       
                                                                        
*T4158*           PERFORM 7010-SELECT-NAME-ID    THRU 7010-EXIT                 
*T4158*           ADD 1   TO I7-NAME-ID GIVING WS-NAME-ID-NO-NUM                
*T4158*           MOVE WS-NAME-ID-NO-NUM         TO WS-NAME-ID-NO               
*T4158*           PERFORM 8310-UPDATE-NAME-ID    THRU 8310-EXIT                 
                                                                        
*T4158            MOVE 'PANEL032'             TO WS-91-PANEL-NO         
*T4158            MOVE PARM-USERID            TO WS-91-USERID           
*T4158            MOVE ZEROS                  TO WS-91-ACCOUNT-NO       
*T4158            MOVE WS-CUSTOMER-NO-NUM     TO WS-91-CUSTOMER-NO      
*T4158            MOVE ZEROS                  TO WS-91-PREMISE-NO       
                                                                        
*T4158            PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT           
*T4158            MOVE WS-91-NEW-NAME-ID      TO WS-NAME-ID-NO-NUM      
*T4158            MOVE WS-NAME-ID-NO-NUM         TO WS-NAME-ID-NO       
                                                                        
*T4158*           PERFORM 7070-SELECT-ADDRESS-ID THRU 7070-EXIT                 
*T4158*           ADD 1   TO I8-ADDRESS-ID GIVING WS-ADDR-ID-NO-NUM             
*T4158*           MOVE WS-ADDR-ID-NO-NUM         TO WS-ADDR-ID-NO               
*T4158*           PERFORM 8390-UPDATE-ADDR-ID    THRU 8390-EXIT                 
                                                                        
*T4158            MOVE 'PANEL032'             TO WS-90-PANEL-NO         
*T4158            MOVE PARM-USERID            TO WS-90-USERID           
*T4158            MOVE ZEROS                  TO WS-90-ACCOUNT-NO       
*T4158            MOVE WS-CUSTOMER-NO-NUM     TO WS-90-CUSTOMER-NO      
*T4158            MOVE ZEROS                  TO WS-90-PREMISE-NO       
                                                                        
*T4158            PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT        
*T4158            MOVE WS-90-NEW-ADDRESS-ID      TO WS-ADDR-ID-NO-NUM   
*T4158            MOVE WS-ADDR-ID-NO-NUM         TO WS-ADDR-ID-NO       
                                                                        
                                                                        
                  MOVE PARM-RELATIVE-NICKNAME    TO DQ-NICKNAME         
                  MOVE SPACES                    TO DQ-TITLE-PREFIX     
                  MOVE SPACES                    TO DQ-TITLE-SUFFIX-1   
                  MOVE SPACES                    TO DQ-TITLE-SUFFIX-2   
                  MOVE WS-NAME-ID-NO-NUM         TO DQ-NAME-ID          
                  MOVE 'CC'                      TO DQ-NAME-TYPE        
                  MOVE WS-NAME-FORMAT            TO DQ-NAME-FORMAT      
                  MOVE PARM-RELATIVE-NAME        TO DQ-FULL-NAME        
P00740            MOVE WS-PARSED-FIRST-NAME      TO DQ-FIRST-NAME       
                  MOVE SPACES                    TO DQ-MIDDLE-NAME      
P00740            MOVE WS-PARSED-LAST-NAME       TO DQ-LAST-NAME        
                  MOVE MH-TRANS-HIST-SEQ-NO      TO DQ-CREATED-DATE     
                                                                        
                  PERFORM 8010-INSERT-NAME       THRU 8010-EXIT         
                                                                        
                  MOVE WS-CONT-ID-NO-NUM         TO CV-CONTACT-ID       
                  MOVE MH-DATE-TRANS             TO CV-DATE-CREATED     
                  MOVE WS-NAME-ID-NO-NUM         TO CV-NAME-ID          
                  MOVE WS-ADDR-ID-NO-NUM         TO CV-ADDRESS-ID       
                  MOVE ZEROES                    TO CV-CONTACT-ORDER    
P00740            IF CSR-DATABASE                                       
P00740                MOVE '03' TO CV-ACCESS-LEVEL-CD                   
P00740            ELSE                                                  
P00740                MOVE '  ' TO CV-ACCESS-LEVEL-CD                   
P00740            END-IF                                                
                  PERFORM 8080-INSERT-CONTACT    THRU 8080-EXIT         
                                                                        
                  MOVE WS-CONT-ID-NO-NUM         TO LP-CONTACT-ID       
                  MOVE SPACES                    TO LP-EXTENSION-NO     
P00201            MOVE WS-HOME-PHONE-TYPE        TO LP-PHONE-TYPE       
P00201            MOVE PARM-RELATIVE-PHONE       TO LP-PHONE-NO         
                  PERFORM 8050-INSERT-CONT-PHONE THRU 8050-EXIT         
                                                                        
                  MOVE WS-CONT-ID-NO-NUM         TO DT-CONTACT-ID       
                  MOVE WS-CUSTOMER-NO-NUM        TO DT-CUSTOMER-NO      
                  PERFORM 8060-INSERT-CONT-CUST  THRU 8060-EXIT         
                                                                        
P00201            MOVE PARM-RELATIVE-STREET      TO DZ-ADDR-STREET      
P00201            MOVE PARM-RELATIVE-CITY-STATE  TO DZ-ADDR-CITY-STATE  
P00201            MOVE PARM-RELATIVE-ZIP         TO DZ-ADDR-ZIP-CODE    
P00201            MOVE PARM-ADDRESS-OVERFLOW     TO DZ-ADDRESS-OVERFLOW 
                  MOVE WS-ADDR-ID-NO-NUM         TO DZ-ADDRESS-ID       
                  PERFORM 8070-INSERT-ADDRESS    THRU 8070-EXIT         
T5707           END-IF                                                  
              END-IF                                                    
                                                                        
           ELSE IF PARM-UPDATE-TYPE = 'D'                               
                   IF PARM-SPOUSE-LAST-NAME = SPACES AND CSTS-EXISTS    
                      PERFORM 5300-JRNL-UPDATE-CUST  THRU 5300-EXIT     
T32002                MOVE PARM-CUSTOMER-NO-NUM TO CB-CUSTOMER-NO       
T32002*               MOVE WS-WORK-PHONE-TYPE TO CB-PHONE-TYPE                  
T32002*               MOVE WS-HOME-PHONE-TYPE TO CB-PHONE-TYPE                  
T32002                MOVE WS-WORK-PHONE-TYPE TO CB-PHONE-TYPE          
T32002                MOVE PARM-SPOUSE-WORK-PHONE TO CB-PHONE-NO        
T32002                MOVE PARM-SPOUSE-WORK-EXT TO CB-EXTENSION-NO      
T32002                MOVE WS-CUSTOMER-TYPE  TO CB-CUSTOMER-TYPE        
                      MOVE WS-CUSTOMER-NO-NUM        TO CE-CUSTOMER-NO  
                      PERFORM 8190-DELETE-NULL-CSTS  THRU 8190-EXIT     
                                                                        
                      MOVE CE-NAME-ID                TO   DQ-NAME-ID    
                      MOVE CE-NAME-ID                TO   HT-NAME-ID    
                      PERFORM 8150-DELETE-NAME-ACCT-XREF THRU 8150-EXIT 
A37666*               PERFORM 8120-DELETE-NAME-ID    THRU 8120-EXIT             
                                                                        
                      MOVE WS-CUSTOMER-NO-NUM        TO CB-CUSTOMER-NO  
                      PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT     
                   END-IF                                               
                                                                        
                   IF PARM-RELATIVE-NAME = SPACES AND RELT-EXISTS       
                      PERFORM 7100-SELECT-RELATIVE   THRU 7100-EXIT     
                      MOVE CV-CONTACT-ID             TO LP-CONTACT-ID   
                      PERFORM 5350-JRNL-UPDATE-RELT  THRU 5350-EXIT     
                      PERFORM 8220-DELETE-CONT-PHONE THRU 8220-EXIT     
                                                                        
                      MOVE CV-CONTACT-ID             TO DT-CONTACT-ID   
A37666*               EVALUATE WS-CONTACT-TABLE                                 
A37666*                 WHEN 'C'                                                
A37666*                    PERFORM 8140-DELETE-CUST-CONT THRU 8140-EXIT         
A37666*                 WHEN 'P'                                                
A37666*                    PERFORM 8141-DELETE-PREM-CONT THRU 8141-EXIT         
A37666*                 WHEN OTHER                                              
A37666*                    PERFORM 8142-DELETE-ACCT-CONT THRU 8142-EXIT         
A37666*               END-EVALUATE                                              
                      MOVE CV-NAME-ID                TO DQ-NAME-ID      
                      MOVE CV-NAME-ID                TO HT-NAME-ID      
                      MOVE CV-ADDRESS-ID             TO DZ-ADDRESS-ID   
                      PERFORM 8130-DELETE-CONTACT    THRU 8130-EXIT     
                      PERFORM 8150-DELETE-NAME-ACCT-XREF THRU 8150-EXIT 
A37666*               PERFORM 8120-DELETE-NAME-ID    THRU 8120-EXIT             
A37666*               PERFORM 8110-DELETE-ADDRESS-ID THRU 8110-EXIT             
                   END-IF                                               
                                                                        
              ELSE                                                      
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '5000'                TO ACTIVE-PARAGRAPH          
                MOVE 'UPDATE'              TO ABEND-FUNCTION            
                MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                   
                MOVE 'PARM-UPDATE-TYPE'    TO TABLE-ELEMENT-1           
                MOVE PARM-UPDATE-TYPE      TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT        
                PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT        
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   5100-JRNL-TRAN-HEAD.                                         *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      ******************************************************************        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE WS-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROS                    TO MH-ACCOUNT-NO.              
           MOVE WS-CUSTOMER-NO-NUM       TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE PARM-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL032'               TO MH-APPL-PROGRAM-ID.         
           MOVE PARM-COMMENT-LEN-NUM     TO MH-TRAN-COMMENT-LEN.        
           MOVE PARM-COMMENT-TEXT        TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-JRNL-INSERT-CUST.                                         *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5200-JRNL-INSERT-CUST.                                           
                                                                        
           MOVE '5200'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
T7933      MOVE SPACES                TO MI-TABLE-ID.                   
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
T7933      MOVE +6                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE WS-CUSTOMER-TYPE-LIT  TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'CUSTOMER TYPE  '     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF PARM-SPOUSE-WORK-PHONE > SPACES                           
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-WORK-PHONE  TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WORK PHONE     '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-WORK-EXT     > SPACES                         
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-SPOUSE-WORK-EXT     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK EXTENSION       '  TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-FIRST-NAME  > SPACES                          
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FIRST NAME     '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-MIDDLE-NAME  > SPACES                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MIDDLE NAME    '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-LAST-NAME  > SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LAST NAME      '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-SSN  > SPACES                                 
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-SSN       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SSN            '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-CODE-STATE-ID  > SPACES                       
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-SPOUSE-CODE-STATE-ID TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CODE STATE ID  '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-LICENSE-NO  > SPACES                          
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +14                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-LICENSE-NO TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LICENSE NO     '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-EMPLOYER > SPACES                             
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +23                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-EMPLOYER  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYER       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
T32002*    IF PARM-SPOUSE-EMPLOYED-DATE  > SPACES                               
T32002*       MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG                 
T32002*       MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                     
T32002*       MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN             
T32002*       MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN             
T32002*      MOVE PARM-SPOUSE-EMPLOYED-DATE TO MI-CHG-COLUMN-VALUE-TEXT         
T32002*       MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT            
T32002*       MOVE 'EMPLOYED DATE  '     TO MI-COLUMN-DESC                      
T32002*       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                   
T32002*       ADD 1 TO WS-TRAN-APPL-NO                                          
T32002*    ELSE                                                                 
T32002*       MOVE -1                    TO WS-NULL-IND-1                       
T32002*    END-IF.                                                              
                                                                        
           IF PARM-SPOUSE-OCCUPATION  > SPACES                          
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-OCCUPATION TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OCCUPATION     '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-OTHER-ID-TYPE  > SPACES                       
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-SPOUSE-OTHER-ID-TYPE TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID TYPE  '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-OTHER-ID  > SPACES                            
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +16                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-OTHER-ID  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-DRVR-LIC-DT > SPACES                          
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPOUSE-DRVR-LIC-DT  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
T32002        MOVE 'DRVR LIC EXP DT'     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           ELSE                                                         
              MOVE -1                    TO WS-NULL-IND-2               
           END-IF.                                                      
                                                                        
           IF PARM-SPOUSE-DATE-OF-BIRTH  > SPACES                       
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-SPOUSE-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DATE OF BIRTH  '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           ELSE                                                         
              MOVE -1                    TO WS-NULL-IND-3               
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5250-JRNL-INSERT-RELT.                                         *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5250-JRNL-INSERT-RELT.                                           
                                                                        
           MOVE '5250'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG.           
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
T7933      MOVE SPACES                TO MI-TABLE-ID.                   
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
T7933      MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN.       
A05317     IF LINK-USERID = 'WEBTRN1'                                   
A05317         MOVE WS-CONTACT-TYPE-LIT-OT TO MI-CHG-COLUMN-VALUE-TEXT  
A05317     ELSE                                                         
               MOVE WS-CONTACT-TYPE-LIT   TO MI-CHG-COLUMN-VALUE-TEXT
           END-IF.  
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'CONTACT TYPE   '     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF PARM-RELATIVE-NAME     > SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-RELATIVE-NAME    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'RELATIVE NAME  '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-RELATIVE-RELNSHIP > SPACES                           
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-RELATIVE-RELNSHIP  TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'RELATIONSHIP   '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-RELATIVE-PHONE      > SPACES                         
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-RELATIVE-PHONE      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PHONE                '  TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-RELATIVE-STREET    > SPACES                          
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-RELATIVE-STREET  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET         '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-RELATIVE-CITY-STATE > SPACES                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-RELATIVE-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CITY-STATE     '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-RELATIVE-ZIP      > SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-RELATIVE-ZIP     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'RELATIVE ZIP   '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-ADDRESS-OVERFLOW  > SPACES                           
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR OVERFLOW  '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
A03212     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
A03212     MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN.    
A03212     MOVE +3                       TO MI-CHG-COLUMN-VALUE-LEN.    
A03212     IF PARM-CONTACT-ASSOC = 'N'                                  
A03212         MOVE 'NO' TO MI-CHG-COLUMN-VALUE-TEXT                    
A03212     ELSE                                                         
A03212         MOVE 'YES' TO MI-CHG-COLUMN-VALUE-TEXT
           END-IF.                  
A03212     MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
A03212     MOVE 'VALID CONTACT  '        TO MI-COLUMN-DESC.             
A03212     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03212     ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-JRNL-UPDATE-CUST.                                         *        
      * 1.   JOURNAL ANY FIELDS THAT THE USER HAS CHANGED BY FORMATING *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5300-JRNL-UPDATE-CUST.                                           
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF DQ-FIRST-NAME NOT = PARM-SPOUSE-FIRST-NAME                
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-FIRST-NAME > SPACES                        
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-SPOUSE-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'FIRST NAME    '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = PARM-SPOUSE-MIDDLE-NAME              
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-MIDDLE-NAME > SPACES                       
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-SPOUSE-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'MIDDLE NAME    '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
T8661      IF DQ-LAST-NAME NOT = PARM-SPOUSE-LAST-NAME                  
T8661         MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
T8661         MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
T8661         IF PARM-SPOUSE-LAST-NAME > SPACES                         
T8661           MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN      
T8661           MOVE PARM-SPOUSE-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT  
T8661         ELSE                                                      
T8661           MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN      
T8661           MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT     
T8661         END-IF                                                    
                                                                        
T8661       IF DQ-LAST-NAME > SPACES                                    
T8661           MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN      
T8661           MOVE DQ-LAST-NAME   TO MI-PRV-COLUMN-VALUE-TEXT         
T8661         ELSE                                                      
T8661             MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN    
T8661            MOVE '*NEW*'      TO MI-PRV-COLUMN-VALUE-TEXT          
T8661         END-IF                                                    
                                                                        
T8661         MOVE 'LAST NAME   '    TO MI-COLUMN-DESC                  
T8661         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T8661         ADD 1 TO WS-TRAN-APPL-NO                                  
                                                                        
T8661      END-IF.                                                      
                                                                        
           IF CE-OCCUPATION NOT = PARM-SPOUSE-OCCUPATION                
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-OCCUPATION > SPACES                        
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-SPOUSE-OCCUPATION TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CE-OCCUPATION > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OCCUPATION      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'OCCUPATION    '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-EMPLOYER   NOT = PARM-SPOUSE-EMPLOYER                  
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-EMPLOYER   > SPACES                        
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-SPOUSE-EMPLOYER   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CE-EMPLOYER   > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-EMPLOYER        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'EMPLOYER      '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
T32002*    IF CE-EMPLOYED-DATE NOT = PARM-SPOUSE-EMPLOYED-DATE                  
      *       MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG                
      *       MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                     
      *                                                                         
      *       IF PARM-SPOUSE-EMPLOYED-DATE  > SPACES                            
      *          MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN             
      *     MOVE PARM-SPOUSE-EMPLOYED-DATE TO MI-CHG-COLUMN-VALUE-TEXT          
      *       ELSE                                                              
      *          MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN             
      *          MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT            
      *       END-IF                                                            
      *                                                                         
      *       IF CE-EMPLOYED-DATE   > SPACES                                    
      *          MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN             
      *          MOVE CE-EMPLOYED-DATE   TO MI-PRV-COLUMN-VALUE-TEXT            
      *       ELSE                                                              
      *          MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN             
      *          MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT            
      *       END-IF                                                            
      *                                                                         
      *       MOVE 'EMPLOYED DATE '    TO MI-COLUMN-DESC                        
      *       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                   
      *       ADD 1 TO WS-TRAN-APPL-NO                                          
      *    END-IF.                                                              
                                                                        
           IF CB-PHONE-NO      NOT = PARM-SPOUSE-WORK-PHONE             
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-WORK-PHONE > SPACES                        
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE PARM-SPOUSE-WORK-PHONE TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CB-PHONE-NO   > SPACES                                 
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CB-PHONE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'PHONE NO      '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CB-EXTENSION-NO  NOT = PARM-SPOUSE-WORK-EXT               
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-WORK-EXT   > SPACES                        
                 MOVE +6                   TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE PARM-SPOUSE-WORK-EXT   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CB-EXTENSION-NO > SPACES                               
                 MOVE +6                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CB-EXTENSION-NO    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'EXTENSION NO  '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-SSN        NOT = PARM-SPOUSE-SSN                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-SSN        > SPACES                        
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-SPOUSE-SSN        TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CE-SSN        > SPACES                                 
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-SSN             TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'SSN           '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DATE-OF-BIRTH NOT = PARM-SPOUSE-DATE-OF-BIRTH          
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-DATE-OF-BIRTH > SPACES                     
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
            MOVE PARM-SPOUSE-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CE-DATE-OF-BIRTH  > SPACES                             
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'DATE OF BIRTH '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DRIVERS-LICENSE-NO    NOT = PARM-SPOUSE-LICENSE-NO     
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-LICENSE-NO > SPACES                        
                 MOVE +14                  TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE PARM-SPOUSE-LICENSE-NO TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CE-DRIVERS-LICENSE-NO   > SPACES                       
                 MOVE +14                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DRIVERS-LICENSE-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'LICENSE NO    '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-CODE-STATE-ID NOT = PARM-SPOUSE-CODE-STATE-ID          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-CODE-STATE-ID > SPACES                     
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-SPOUSE-CODE-STATE-ID TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CE-CODE-STATE-ID > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-CODE-STATE-ID   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'CODE STATE ID '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
                                                                        
           IF CE-DRVR-LIC-ISS-DT   NOT = PARM-SPOUSE-DRVR-LIC-DT        
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-DRVR-LIC-DT   > SPACES                     
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
            MOVE PARM-SPOUSE-DRVR-LIC-DT   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CE-DRVR-LIC-ISS-DT > SPACES                            
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DRVR-LIC-ISS-DT TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'DRVR LIC EXP  '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID-TYPE NOT = PARM-SPOUSE-OTHER-ID-TYPE          
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-SPOUSE-OTHER-ID-TYPE > SPACES                     
                 MOVE +12                  TO MI-CHG-COLUMN-VALUE-LEN   
           MOVE PARM-SPOUSE-OTHER-ID-TYPE  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF CE-OTHER-ID-TYPE > SPACES                              
                 MOVE +12                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID-TYPE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'OTHER ID TYPE '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID      NOT = PARM-SPOUSE-OTHER-ID               
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-SPOUSE-OTHER-ID      > SPACES                     
                 MOVE +16                TO MI-CHG-COLUMN-VALUE-LEN     
T8661        MOVE PARM-SPOUSE-OTHER-ID   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CE-OTHER-ID      > SPACES                              
                 MOVE +16                TO MI-PRV-COLUMN-VALUE-LEN     
T8661            MOVE CE-OTHER-ID        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'OTHER ID      '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5350-JRNL-UPDATE-RELT.                                         *        
      * 1.   JOURNAL ANY FIELDS THAT THE USER HAS CHANGED BY FORMATING *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5350-JRNL-UPDATE-RELT.                                           
                                                                        
           MOVE '5350' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF CV-CONTACT-POSITION-TEXT NOT = PARM-RELATIVE-RELNSHIP     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-RELATIVE-RELNSHIP > SPACES                        
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-RELATIVE-RELNSHIP TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF CV-CONTACT-POSITION-TEXT > SPACES                      
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
            MOVE CV-CONTACT-POSITION-TEXT TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'RELATIONSHIP  '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FULL-NAME   NOT = PARM-RELATIVE-NAME                   
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-RELATIVE-NAME      > SPACES                       
                 MOVE +70                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-RELATIVE-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DQ-FULL-NAME   > SPACES                                
                 MOVE +70                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FULL-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'FULL NAME      '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-NICKNAME    NOT = PARM-RELATIVE-NICKNAME               
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-RELATIVE-NICKNAME  > SPACES                       
                 MOVE +50                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE PARM-RELATIVE-NICKNAME                            
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DQ-NICKNAME   > SPACES                                 
                 MOVE +50                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-NICKNAME        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'NICKNAME       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
A03212     IF LP-PHONE-NO < SPACES                                      
A03212         MOVE SPACES TO LP-PHONE-NO
           END-IF.                              
           IF LP-PHONE-NO      NOT = PARM-RELATIVE-PHONE                
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-RELATIVE-PHONE    > SPACES                        
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE PARM-RELATIVE-PHONE    TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF LP-PHONE-NO   > SPACES                                 
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE LP-PHONE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'PHONE NO      '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-STREET NOT = PARM-RELATIVE-STREET                 
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-RELATIVE-STREET   > SPACES                        
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE PARM-RELATIVE-STREET   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DZ-ADDR-STREET > SPACES                                
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-STREET     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'STREET        '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = PARM-RELATIVE-CITY-STATE         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              IF PARM-RELATIVE-CITY-STATE > SPACES                      
                 MOVE +20                TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-RELATIVE-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              IF DZ-ADDR-CITY-STATE > SPACES                            
                 MOVE +20                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-CITY-STATE TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'CITY STATE    '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = PARM-RELATIVE-ZIP                  
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-RELATIVE-ZIP         > SPACES                     
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
            MOVE PARM-RELATIVE-ZIP         TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF DZ-ADDR-ZIP-CODE  > SPACES                             
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-ZIP-CODE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'ZIP CODE      '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW  NOT = PARM-ADDRESS-OVERFLOW          
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
                                                                        
              IF PARM-ADDRESS-OVERFLOW > SPACES                         
                 MOVE +35                  TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE PARM-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF DZ-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE 'ADDR OVERFLOW '    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
A03212     IF PARM-UPDATE-TYPE = 'M' AND                                
A03212       ((CV-CONTACT-TYPE = 'RL' AND PARM-CONTACT-ASSOC = 'N') OR  
A03212        (CV-CONTACT-TYPE = 'RR' AND PARM-CONTACT-ASSOC = 'Y'))    
A03212            MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO       
A03212            MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                    
A03212                       MI-PRV-COLUMN-VALUE-LEN                    
A03212            IF CV-CONTACT-TYPE = 'RL'                             
A03212                MOVE 'YES' TO MI-PRV-COLUMN-VALUE-TEXT            
A03212            ELSE                                                  
A03212                MOVE 'NO' TO MI-PRV-COLUMN-VALUE-TEXT             
A03212            END-IF                                                
A03212            IF PARM-CONTACT-ASSOC = 'Y'                           
A03212                MOVE 'YES' TO MI-CHG-COLUMN-VALUE-TEXT            
A03212            ELSE                                                  
A03212                MOVE 'NO' TO MI-CHG-COLUMN-VALUE-TEXT             
A03212            END-IF                                                
A03212            MOVE 'VALID CONTACT '    TO MI-COLUMN-DESC            
A03212            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
A03212            ADD 1 TO WS-TRAN-APPL-NO                              
A03212     END-IF.                                                      
                                                                        
A03212     IF PARM-UPDATE-TYPE = 'D'                                    
A03212         MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
A03212         MOVE +3 TO MI-PRV-COLUMN-VALUE-LEN                       
A03212         MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                       
A03212         IF CV-CONTACT-TYPE = 'RL'                                
A03212             MOVE 'YES' TO MI-PRV-COLUMN-VALUE-TEXT               
A03212         ELSE                                                     
A03212             MOVE 'NO' TO MI-PRV-COLUMN-VALUE-TEXT                
A03212         END-IF                                                   
A03212         MOVE 'VALID CONTACT '       TO MI-COLUMN-DESC            
A03212         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
A03212         ADD 1 TO WS-TRAN-APPL-NO                                 
A03212     END-IF.                                                      
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
                                                                        
T4999 ******************************************************************        
T4999 * 5400-PROCESS-ACCOUNTS.                                         *        
T4999 * 1.   FOR EACH ROW FETCHED, INSERT AN IDENTICAL ROW FOR THE     *        
T4999 *      SPOUSE INTO THE NAME-ACCOUNT-XREF TABLE.                  *        
T4999 *                                                                *        
T4999 ******************************************************************        
T4999  5400-PROCESS-ACCOUNTS.                                           
T4999                                                                   
T4999      IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T4999         GO TO 5400-EXIT                                           
T4999      ELSE                                                         
T4999         MOVE WS-ACCOUNT-NO         TO HT-ACCOUNT-NO               
T4999         MOVE WS-ADDRESS-ID         TO HT-ADDRESS-ID               
T4999         MOVE WS-COMPANY-NO         TO HT-COMPANY-NO               
T4999         MOVE ZERO                  TO HT-CONTACT-ID               
T4999         MOVE WS-PREMISE-NO         TO HT-PREMISE-NO               
T22161        MOVE WS-TOWN               TO HT-TOWN                     
T22161        MOVE WS-STATE              TO HT-STATE                    
T22161        MOVE WS-LOCAL-OFFICE       TO HT-LOCAL-OFFICE             
P00594        MOVE WS-ACCOUNT-TYPE-CODE  TO HT-ACCOUNT-TYPE-CODE        
P00594        MOVE WS-CODE-ACCT-STAT     TO HT-CODE-ACCT-STAT           
T4999         PERFORM 8020-INSERT-NAME-XREF       THRU 8020-EXIT        
T4999         PERFORM 8410-FETCH-ALL-ACCOUNTS     THRU 8410-EXIT        
T4999      END-IF.                                                      
T4999                                                                   
T4999  5400-EXIT.                                                       
T4999      EXIT.                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00090                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00092                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CALCULATE THE LENGTH OF A FIELD COPYBOOK.                     *        
      ******************************************************************        
                                                                        
           COPY CPD00060.                                                       
                                                                        
                                                                        
           COPY CPD00071.                                                       
                                                                        
      ******************************************************************        
      * 7010-SELECT-NAME-ID.                                           *        
      *    1. SELECT THE LAST NAME ID USED IN ORDER TO CREATE A NEW    *        
      *       NAME ID FOR A NEW CUSTOMER.                              *        
      ******************************************************************        
      *7010-SELECT-NAME-ID.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT NAME_ID                                                    
      *         INTO :I7-NAME-ID                                                
      *         FROM CSS_NAME_ID_CNTL                                           
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
      *       MOVE '7010'          TO ACTIVE-PARAGRAPH                          
      *       MOVE 'SELECT'             TO ABEND-FUNCTION                       
      *       MOVE 'CSS_NAME_ID_CNTL'   TO TABLE-1                              
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7010-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 7020-SELECT-CUST-STATS.                                        *        
      *    1.  SELECT ALL VALUES FROM CSS_CUST_STATS.                  *        
      *                                                                *        
      ******************************************************************        
       7020-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     EMPLOYED_DATE,                                     
                     OCCUPATION,                                        
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DRVR_LIC_ISS_DT,                                   
                     DATE_OF_BIRTH                                      
              INTO   :WS-CSTS-EXISTS-FLAG,                              
                     :CE-SSN,                                           
                     :CE-NAME-ID,                                       
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-EMPLOYED-DATE :WS-NULL-IND-1,                   
                     :CE-OCCUPATION,                                    
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DRVR-LIC-ISS-DT :WS-NULL-IND-2,                 
                     :CE-DATE-OF-BIRTH :WS-NULL-IND-3                    
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO    = :WS-CUSTOMER-NO-NUM               
                AND  CUSTOMER_TYPE  = :WS-CUSTOMER-TYPE                 
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              EMPLOYED_DATE,                                             
MFA-TR*              OCCUPATION,                                                
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DRVR_LIC_ISS_DT,                                           
MFA-TR*              DATE_OF_BIRTH                                              
MFA-TR*       INTO   :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :CE-SSN,                                                   
MFA-TR*              :CE-NAME-ID,                                               
MFA-TR*              :CE-CODE-STATE-ID,                                         
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :CE-EMPLOYER,                                              
MFA-TR*              :CE-EMPLOYED-DATE:WS-NULL-IND-1,                           
MFA-TR*              :CE-OCCUPATION,                                            
MFA-TR*              :CE-OTHER-ID-TYPE,                                         
MFA-TR*              :CE-OTHER-ID,                                              
MFA-TR*              :CE-DRVR-LIC-ISS-DT:WS-NULL-IND-2,                         
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-IND-3                            
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  CUSTOMER_NO    = :WS-CUSTOMER-NO-NUM                       
MFA-TR*         AND  CUSTOMER_TYPE  = :WS-CUSTOMER-TYPE                         
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T32002*    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL              
T32002*       NEXT SENTENCE                                                     
T32002*    ELSE                                                                 
T32002     EVALUATE WS-ACTIVE-RETURN-CODE                               
T32002       WHEN SUCCESSFUL-CALL                                       
T32002          IF WS-NULL-IND-2 < 0                                    
T32002           MOVE SPACES TO CE-DRVR-LIC-ISS-DT                      
T32002          END-IF                                                  
T32002          IF WS-NULL-IND-3 < 0                                    
T32002           MOVE SPACES TO CE-DATE-OF-BIRTH                        
T32002          END-IF                                                  
T32002       WHEN NOT-FOUND                                             
T32002          CONTINUE                                                
T32002       WHEN OTHER                                                 
                MOVE PROGRAM-NAME        TO ABEND-PROGRAM               
                MOVE '7020'              TO ACTIVE-PARAGRAPH            
                MOVE 'SELECT'            TO ABEND-FUNCTION              
CBSI            MOVE SPACES              TO ABEND-SQL-PREDICATES        
CBSI                                          ABEND-TABLES              
                MOVE 'CSS_CUST_STATS'    TO TABLE-1                     
                MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1             
T16430          MOVE WS-CUSTOMER-NO-NUM  TO HOSTVAR-ELEMENT-1           
T16430          MOVE 'CUSTOMER_TYPE'     TO TABLE-ELEMENT-2             
T16430          MOVE WS-CUSTOMER-TYPE    TO HOSTVAR-ELEMENT-2           
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-EVALUATE.                                                
T32002*    END-IF.                                                              
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-SELECT-PHONE.                                             *        
      *    1.  SELECT ALL VALUES FROM CSS_CUST_PHONE.                  *        
      ******************************************************************        
       7030-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO                                       
              INTO  :WS-PHONE-EXISTS-FLAG,                              
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO                                    
              FROM   CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                
                AND  PHONE_TYPE    = :WS-WORK-PHONE-TYPE                
                AND  CUSTOMER_TYPE = :WS-CUSTOMER-TYPE                  
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO                                               
MFA-TR*       INTO  :WS-PHONE-EXISTS-FLAG,                                      
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO                                            
MFA-TR*       FROM   CSS_CUST_PHONE                                             
MFA-TR*       WHERE  CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                        
MFA-TR*         AND  PHONE_TYPE    = :WS-WORK-PHONE-TYPE                        
MFA-TR*         AND  CUSTOMER_TYPE = :WS-CUSTOMER-TYPE                          
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CUST_PHONE'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
              MOVE 'PHONE_TYPE'          TO TABLE-ELEMENT-2             
T14139        MOVE WS-HOME-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
CBSI          MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-3             
              MOVE WS-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-SELECT-NAME.                                              *        
      *    1.  SELECT ALL VALUES FROM CSS_NAME.                        *        
      ******************************************************************        
       7040-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     NICKNAME,                                          
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME                                          
              INTO  :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-NICKNAME,                                       
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME                                       
              FROM   CSS_NAME WITH(READUNCOMMITTED)                             
              WHERE  NAME_ID = :DQ-NAME-ID                              
T35434                                                          
                                                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              NICKNAME,                                                  
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME                                                  
MFA-TR*       INTO  :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-NICKNAME,                                               
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME                                               
MFA-TR*       FROM   CSS_NAME                                                   
MFA-TR*       WHERE  NAME_ID = :DQ-NAME-ID                                      
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-SELECT-ADDRESS.                                           *        
      *    1.  SELECT ALL VALUES FROM CSS_ADDRESS_FREEFORM.            *        
      ******************************************************************        
       7050-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDRESS_OVERFLOW                                   
              INTO  :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDRESS-OVERFLOW                                
              FROM   CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE  ADDRESS_ID    = :DZ-ADDRESS-ID                     
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDRESS_OVERFLOW                                           
MFA-TR*       INTO  :DZ-ADDR-STREET,                                            
MFA-TR*             :DZ-ADDR-CITY-STATE,                                        
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                          
MFA-TR*             :DZ-ADDRESS-OVERFLOW                                        
MFA-TR*       FROM   CSS_ADDR_FREEFORM                                          
MFA-TR*       WHERE  ADDRESS_ID    = :DZ-ADDRESS-ID                             
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DZ-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-SELECT-CONTACT-ID.                                        *        
      *    1. SELECT THE LAST CONTACT USED IN ORDER TO CREATE A NEW    *        
      *       CONTACT ID FOR THE RELATIVE.                             *        
      ******************************************************************        
      *7060-SELECT-CONTACT-ID.                                                  
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT CONTACT_ID                                                 
      *         INTO :I6-CONTACT-ID                                             
      *         FROM CSS_CNTCT_ID_CNTL                                          
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
      *       MOVE '7060'          TO ACTIVE-PARAGRAPH                          
      *       MOVE 'SELECT'             TO ABEND-FUNCTION                       
      *       MOVE 'CSS_CNTCT_ID_CNTL'   TO TABLE-1                             
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7060-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 7070-SELECT-ADDRESS-ID.                                        *        
      *    1. SELECT THE LAST ADDRESS USED IN ORDER TO CREATE A NEW    *        
      *       ADDRESS ID FOR THE RELATIVE.                             *        
      ******************************************************************        
      *7070-SELECT-ADDRESS-ID.                                                  
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT ADDRESS_ID                                                 
      *         INTO :I8-ADDRESS-ID                                             
      *         FROM CSS_ADDR_ID_CNTL                                           
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
      *       MOVE '7070'          TO ACTIVE-PARAGRAPH                          
      *       MOVE 'SELECT'             TO ABEND-FUNCTION                       
      *       MOVE 'CSS_ADDR_ID_CNTL'   TO TABLE-1                              
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7070-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 7080-SELECT-RESP-AREA-ID.                                      *        
      *    1. GET THE USERS ASSOCIATED AREA ID BASED ON USERID.        *        
      ******************************************************************        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PARM-USERID                             
T35434                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PARM-USERID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE PARM-USERID           TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7090-SELECT-CONT-PHONE.                                        *        
      *    1.  SELECT ALL VALUES FROM CSS_CONTACT-PHONE.               *        
      ******************************************************************        
       7090-SELECT-CONT-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_NO                                           
              INTO  :WS-PHONE-EXISTS-FLAG,                              
                    :LP-PHONE-NO                                        
              FROM   CSS_CONTACT_PHONE WITH(READUNCOMMITTED)                    
              WHERE  CONTACT_ID    = :LP-CONTACT-ID                     
                AND  PHONE_TYPE    = :WS-HOME-PHONE-TYPE                
T35434                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_NO                                                   
MFA-TR*       INTO  :WS-PHONE-EXISTS-FLAG,                                      
MFA-TR*             :LP-PHONE-NO                                                
MFA-TR*       FROM   CSS_CONTACT_PHONE                                          
MFA-TR*       WHERE  CONTACT_ID    = :LP-CONTACT-ID                             
MFA-TR*         AND  PHONE_TYPE    = :WS-HOME-PHONE-TYPE                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7090'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT_PHONE'   TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE LP-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
T16430        MOVE 'PHONE_TYPE'          TO TABLE-ELEMENT-2             
T16430        MOVE WS-HOME-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-RELATIVE.                                          *        
      *    1.  SELECT ALL VALUES FROM CSS_CONTACT TABLE FOR CONTACT    *        
      *        TYPE RELATIVE.                                          *        
      ******************************************************************        
       7100-SELECT-RELATIVE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     B.CONTACT_ID,                                      
                     B.CONTACT_TYPE,                                    
                     B.CONTACT_ORDER,                                   
                     B.NAME_ID,                                         
                     B.ADDRESS_ID,                                      
                     B.CONTACT_POSITION                                 
              INTO   :WS-RELT-EXISTS-FLAG,                              
                     :CV-CONTACT-ID,                                    
                     :CV-CONTACT-TYPE,                                  
                     :CV-CONTACT-ORDER,                                 
                     :CV-NAME-ID,                                       
                     :CV-ADDRESS-ID,                                    
                     :CV-CONTACT-POSITION                               
              FROM   CSS_CONTACT_CUST A WITH(READUNCOMMITTED),                  
                     CSS_CONTACT B WITH(READUNCOMMITTED)                        
              WHERE  A.CUSTOMER_NO    = :WS-CUSTOMER-NO-NUM             
                AND  B.CONTACT_ID     = A.CONTACT_ID                    
T27707          AND  B.CONTACT_TYPE   IN ('RR','RL')                    
                AND  B.CONTACT_ORDER  = 0                               
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              B.CONTACT_ID,                                              
MFA-TR*              B.CONTACT_TYPE,                                            
MFA-TR*              B.CONTACT_ORDER,                                           
MFA-TR*              B.NAME_ID,                                                 
MFA-TR*              B.ADDRESS_ID,                                              
MFA-TR*              B.CONTACT_POSITION                                         
MFA-TR*       INTO   :WS-RELT-EXISTS-FLAG,                                      
MFA-TR*              :CV-CONTACT-ID,                                            
MFA-TR*              :CV-CONTACT-TYPE,                                          
MFA-TR*              :CV-CONTACT-ORDER,                                         
MFA-TR*              :CV-NAME-ID,                                               
MFA-TR*              :CV-ADDRESS-ID,                                            
MFA-TR*              :CV-CONTACT-POSITION                                       
MFA-TR*       FROM   CSS_CONTACT_CUST A,                                        
MFA-TR*              CSS_CONTACT B                                              
MFA-TR*       WHERE  A.CUSTOMER_NO    = :WS-CUSTOMER-NO-NUM                     
MFA-TR*         AND  B.CONTACT_ID     = A.CONTACT_ID                            
MFA-TR*         AND  B.CONTACT_TYPE   IN ('RR','RL')                            
MFA-TR*         AND  B.CONTACT_ORDER  = 0                                       
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'C'                TO WS-CONTACT-TABLE               
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              PERFORM 7110-SELECT-REL-ACCT    THRU 7110-EXIT            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT   '      TO TABLE-1                     
              MOVE 'CSS_CONTACT_CUST'    TO TABLE-2                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T16430        MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
T16430        MOVE 'CONTACT_TYPE'        TO TABLE-ELEMENT-1             
T16430        MOVE WS-CONTACT-TYPE       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7110-SELECT-REL-ACCT                                           *        
      *    1.  SELECT ALL VALUES FROM CSS_CONTACT TABLE FOR CONTACT    *        
      *        TYPE RELATIVE THAT IS ASSOC WITH AN ACCOUNT             *        
      ******************************************************************        
       7110-SELECT-REL-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     B.CONTACT_ID,                                      
                     B.CONTACT_TYPE,                                    
                     B.CONTACT_ORDER,                                   
                     B.NAME_ID,                                         
                     B.ADDRESS_ID,                                      
                     B.CONTACT_POSITION                                 
              INTO   :WS-RELT-EXISTS-FLAG,                              
                     :CV-CONTACT-ID,                                    
                     :CV-CONTACT-TYPE,                                  
                     :CV-CONTACT-ORDER,                                 
                     :CV-NAME-ID,                                       
                     :CV-ADDRESS-ID,                                    
                     :CV-CONTACT-POSITION                               
              FROM   CSS_CONTACT_ACCT A WITH(READUNCOMMITTED),                  
                     CSS_CONTACT B WITH(READUNCOMMITTED)                        
              WHERE  A.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM              
                AND  B.CONTACT_ID     = A.CONTACT_ID                    
T27707          AND  B.CONTACT_TYPE   IN ('RR','RL')                    
T27707*         AND  B.CONTACT_TYPE   = :WS-CONTACT-TYPE                        
                AND  B.CONTACT_ORDER  = 0                               
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              B.CONTACT_ID,                                              
MFA-TR*              B.CONTACT_TYPE,                                            
MFA-TR*              B.CONTACT_ORDER,                                           
MFA-TR*              B.NAME_ID,                                                 
MFA-TR*              B.ADDRESS_ID,                                              
MFA-TR*              B.CONTACT_POSITION                                         
MFA-TR*       INTO   :WS-RELT-EXISTS-FLAG,                                      
MFA-TR*              :CV-CONTACT-ID,                                            
MFA-TR*              :CV-CONTACT-TYPE,                                          
MFA-TR*              :CV-CONTACT-ORDER,                                         
MFA-TR*              :CV-NAME-ID,                                               
MFA-TR*              :CV-ADDRESS-ID,                                            
MFA-TR*              :CV-CONTACT-POSITION                                       
MFA-TR*       FROM   CSS_CONTACT_ACCT A,                                        
MFA-TR*              CSS_CONTACT B                                              
MFA-TR*       WHERE  A.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM                      
MFA-TR*         AND  B.CONTACT_ID     = A.CONTACT_ID                            
MFA-TR*         AND  B.CONTACT_TYPE   IN ('RR','RL')                            
MFA-TR*         AND  B.CONTACT_TYPE   = :WS-CONTACT-TYPE                        
MFA-TR*         AND  B.CONTACT_ORDER  = 0                                       
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'A'                TO WS-CONTACT-TABLE               
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              PERFORM 7120-SELECT-REL-PREM    THRU 7120-EXIT            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT   '      TO TABLE-1                     
              MOVE 'CSS_CONTACT_ACCT'    TO TABLE-2                     
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T16430        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
T16430*       MOVE 'CONTACT_TYPE'        TO TABLE-ELEMENT-1                     
T16430*       MOVE WS-CONTACT-TYPE       TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7120-SELECT-REL-PREM.                                          *        
      *    1.  SELECT ALL VALUES FROM CSS_CONTACT TABLE FOR CONTACT    *        
      *        TYPE RELATIVE THAT IS A PREMISE CONTACT                 *        
      ******************************************************************        
       7120-SELECT-REL-PREM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     B.CONTACT_ID,                                      
                     B.CONTACT_TYPE,                                    
                     B.CONTACT_ORDER,                                   
                     B.NAME_ID,                                         
                     B.ADDRESS_ID,                                      
                     B.CONTACT_POSITION                                 
              INTO   :WS-RELT-EXISTS-FLAG,                              
                     :CV-CONTACT-ID,                                    
                     :CV-CONTACT-TYPE,                                  
                     :CV-CONTACT-ORDER,                                 
                     :CV-NAME-ID,                                       
                     :CV-ADDRESS-ID,                                    
                     :CV-CONTACT-POSITION                               
              FROM   CSS_CONTACT_PREM A WITH(READUNCOMMITTED),                  
                     CSS_CONTACT B WITH(READUNCOMMITTED)                        
              WHERE  A.PREMISE_NO     = :WS-PREMISE-NO-NUM              
                AND  B.CONTACT_ID     = A.CONTACT_ID                    
T27707          AND  B.CONTACT_TYPE   IN ('RR','RL')                    
T27707*         AND  B.CONTACT_TYPE   = :WS-CONTACT-TYPE                        
                AND  B.CONTACT_ORDER  = 0                               
T35434                                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              B.CONTACT_ID,                                              
MFA-TR*              B.CONTACT_TYPE,                                            
MFA-TR*              B.CONTACT_ORDER,                                           
MFA-TR*              B.NAME_ID,                                                 
MFA-TR*              B.ADDRESS_ID,                                              
MFA-TR*              B.CONTACT_POSITION                                         
MFA-TR*       INTO   :WS-RELT-EXISTS-FLAG,                                      
MFA-TR*              :CV-CONTACT-ID,                                            
MFA-TR*              :CV-CONTACT-TYPE,                                          
MFA-TR*              :CV-CONTACT-ORDER,                                         
MFA-TR*              :CV-NAME-ID,                                               
MFA-TR*              :CV-ADDRESS-ID,                                            
MFA-TR*              :CV-CONTACT-POSITION                                       
MFA-TR*       FROM   CSS_CONTACT_PREM A,                                        
MFA-TR*              CSS_CONTACT B                                              
MFA-TR*       WHERE  A.PREMISE_NO     = :WS-PREMISE-NO-NUM                      
MFA-TR*         AND  B.CONTACT_ID     = A.CONTACT_ID                            
MFA-TR*         AND  B.CONTACT_TYPE   IN ('RR','RL')                            
MFA-TR*         AND  B.CONTACT_TYPE   = :WS-CONTACT-TYPE                        
MFA-TR*         AND  B.CONTACT_ORDER  = 0                                       
MFA-TR*        WITH  UR                                                         
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'P'                TO WS-CONTACT-TABLE               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7120'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
CBSI             MOVE SPACES                TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
                 MOVE 'CSS_CONTACT   '      TO TABLE-1                  
                 MOVE 'CSS_CONTACT_PREM'    TO TABLE-2                  
                 MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1           
T16430           MOVE WS-PREMISE-NO-NUM    TO HOSTVAR-ELEMENT-1         
T16430*          MOVE 'CONTACT_TYPE'        TO TABLE-ELEMENT-1                  
T16430*          MOVE WS-CONTACT-TYPE       TO HOSTVAR-ELEMENT-1                
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-ITPA-CHECK.                                               *        
      ******************************************************************        
       7130-ITPA-CHECK.                                                 
                                                                        
C29586     MOVE PARM-SPOUSE-SSN         TO CE-SSN.                      
C29586     MOVE 'NO'                    TO WS-SPOUSE-CSTS-EXISTS-FLAG.  
                                                                        
           PERFORM 8430-OPEN-STATS-CURSOR          THRU 8430-EXIT.      
           PERFORM 8440-FETCH-ALL-SPOUSE-CUSTOMER  THRU 8440-EXIT.      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29586     EVALUATE WS-ACTIVE-RETURN-CODE                               
C29586       WHEN SUCCESSFUL-CALL                                       
C29586          PERFORM 7140-GET-CREDIT-HIST THRU 7140-EXIT             
C29586       WHEN NOT-FOUND                                             
C29586          CONTINUE                                                
C29586       WHEN OTHER                                                 
                MOVE PROGRAM-NAME        TO ABEND-PROGRAM               
                MOVE '7130'              TO ACTIVE-PARAGRAPH            
                MOVE 'SELECT'            TO ABEND-FUNCTION              
CBSI            MOVE SPACES              TO ABEND-SQL-PREDICATES        
CBSI                                          ABEND-TABLES              
                MOVE 'CSS_CUST_STATS'    TO TABLE-1                     
                MOVE 'SSN'               TO TABLE-ELEMENT-1             
                MOVE CE-SSN              TO HOSTVAR-ELEMENT-1           
                MOVE 'CUSTOMER_TYPE'     TO TABLE-ELEMENT-2             
                MOVE WS-CUSTOMER-TYPE    TO HOSTVAR-ELEMENT-2           
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 8450-CLOSE-STATS-CURSOR     THRU 8450-EXIT.          
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-GET-CREDIT-HIST.                                          *        
      ******************************************************************        
       7140-GET-CREDIT-HIST.                                            
                                                                        
C29586     EXEC SQL                                                     
               SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD                              
               INTO :CK-CR-HIST-TRAN-DT,                                
                    :CK-CR-HIST-TRAN-TM,                                
                    :LF-ITPA-RSLT-CURR-CD                               
                 FROM CSS_CREDIT_HIST CK,                               
                      CSS_CRED_ITPA_HIST LF                             
                WHERE CK.CUSTOMER_NO = :WS-SPOUSE-CUST-NO               
                  AND LF.ITPA_RSLT_CURR_CD <> 'R'                       
                  AND CK.CR_HIST_TRAN_TM =                              
                     (SELECT MAX(CR_HIST_TRAN_TM)                       
                        FROM CSS_CREDIT_HIST                            
                       WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO           
                         AND CR_HIST_TRAN_DT =                          
                          (SELECT MAX(CR_HIST_TRAN_DT)                  
                             FROM CSS_CREDIT_HIST                       
                            WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO))    
                  AND CK.CR_HIST_TRAN_DT =                              
                   (SELECT MAX(CR_HIST_TRAN_DT)                         
                       FROM CSS_CREDIT_HIST                             
                 WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO)                
                 AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                    
                 AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT            
                 AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM            
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                                       
MFA-TR*               CK.CR_HIST_TRAN_TM,                                       
MFA-TR*               LF.ITPA_RSLT_CURR_CD                                      
MFA-TR*        INTO :CK-CR-HIST-TRAN-DT,                                        
MFA-TR*             :CK-CR-HIST-TRAN-TM,                                        
MFA-TR*             :LF-ITPA-RSLT-CURR-CD                                       
MFA-TR*          FROM CSS_CREDIT_HIST CK,                                       
MFA-TR*               CSS_CRED_ITPA_HIST LF                                     
MFA-TR*         WHERE CK.CUSTOMER_NO = :WS-SPOUSE-CUST-NO                       
MFA-TR*           AND LF.ITPA_RSLT_CURR_CD <> 'R'                               
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                                      
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                               
MFA-TR*                 FROM CSS_CREDIT_HIST                                    
MFA-TR*                WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO                   
MFA-TR*                  AND CR_HIST_TRAN_DT =                                  
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                          
MFA-TR*                      FROM CSS_CREDIT_HIST                               
MFA-TR*                     WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO))            
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                                      
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                                 
MFA-TR*                FROM CSS_CREDIT_HIST                                     
MFA-TR*          WHERE CUSTOMER_NO = :WS-SPOUSE-CUST-NO)                        
MFA-TR*          AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                            
MFA-TR*          AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT                    
MFA-TR*          AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM                    
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29586     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C29586                                                                  
C29586     EVALUATE WS-ACTIVE-RETURN-CODE                               
C29586      WHEN SUCCESSFUL-CALL                                        
C29586               PERFORM 7150-INSERT-COMM THRU 7150-EXIT            
C29586               PERFORM 7200-CREATE-WQ   THRU 7200-EXIT            
C29586               MOVE 5500        TO WS-ACTIVE-RETURN-CODE          
C29586               GO               TO 5000-EXIT                      
C29586      WHEN NOT-FOUND                                              
C29586            CONTINUE                                              
C29586      WHEN OTHER                                                  
C29586            MOVE PROGRAM-NAME    TO ABEND-PROGRAM                 
C29586            MOVE '7140'          TO ACTIVE-PARAGRAPH              
C29586            MOVE 'SELECT'        TO ABEND-FUNCTION                
C29586            MOVE 'CSS_CREDIT_HIST'  TO TABLE-1                    
T31930            MOVE 'CSS_CRED_HIST_ITPA'  TO TABLE-2                 
C29586            MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1               
C29586            MOVE WS-CUSTOMER-NO-NUM TO HOSTVAR-ELEMENT-1          
C29586            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C29586            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C29586     END-EVALUATE.                                                
C29586                                                                  
C29586 7140-EXIT.                                                       
C29586     EXIT.                                                        
                                                                        
C29586 7150-INSERT-COMM.                                                
C29586                                                                  
C29586     EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :KO-COMMUNICATION-ID              
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :KO-COMMUNICATION-ID = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434                                                                  
T35434     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T35434     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35434        NEXT SENTENCE                                             
T35434     ELSE                                                         
T35434        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T35434        MOVE '7150'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
T35434        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T35434                                      ABEND-TABLES                
T35434        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T35434        MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1           
T35434        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T35434        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T35434     END-IF.                                                      
                                                                        
C29586     MOVE PARM-CUSTOMER-NO-NUM TO KO-CUSTOMER-NO.                 
C29586     MOVE WS-PREMISE-NO-NUM    TO KO-PREMISE-NO                   
C29586     MOVE WS-ACCOUNT-NO-NUM    TO KO-ACCOUNT-NO.                  
C29586     PERFORM 7160-GET-COMPANY  THRU 7160-EXIT.                    
C29586     MOVE 'N'                  TO KO-RED-FLAG-IND.                
C29586     MOVE SPACES               TO KO-RED-FLAG-EXPIRE-DT.          
C29586     MOVE -1                   TO WS-NULL-IND-8                   
C29586                                  WS-NULL-IND-9.                  
C29586     MOVE 'O'                  TO KO-COMM-METHOD.                 
C29586     MOVE 'I'                  TO KO-COMM-DIRECTION.              
C29586     MOVE '05'                 TO KO-COMM-TYPE-CD.                
C29586     MOVE '16'                 TO KO-COMM-SUBTYPE-CODE.           
C29586     MOVE PARM-USERID          TO KO-USER-ID-ORIG.                
P00740     IF SEB-DATABASE                                              
C29586         MOVE 'CREDIT DEPARTMENT' TO KO-CONTACT-NAME              
C29586     ELSE                                                         
C29586         MOVE 'RECEIVABLES MANAGEMENT' TO KO-CONTACT-NAME
           END-IF.        
C29586     MOVE SPACES               TO KO-PROMOTION-ID                 
C29586                                  KO-CALL-END-TIME                
C29586                                  KO-RESPONSE-REASON-CD           
C29586                                  KO-RESPONSE-TYPE-CD             
C29586                                  KO-SOLICITATION-CD              
C29586                                  KO-DISCOVERY-MTHD-CD            
C29586                                  KO-PREV-MARKETER-CD.            
C29586     MOVE 'N'                  TO KO-PSC-COMPLIANCE-IND           
C29586                                  KO-COMPLAINT-FL                 
C29586                                  KO-SCREEN-POP-IND.              
C29586     MOVE 'C'                  TO KO-COMM-ASSOC-CD.               
C29586     MOVE 0                    TO KO-CALL-ORIGIN-ID               
C29586                                  KO-NUMBER-TRANSFERS             
C29586                                  KO-HOLD-TIME                    
C29586                                  KO-QUEUE-TIME                   
C29586                                  KO-TOTAL-CALL-TIME.             
C29586     STRING PARM-SPOUSE-FIRST-NAME                                
C29586            PARM-SPOUSE-MIDDLE-NAME                               
C29586            PARM-SPOUSE-LAST-NAME                                 
C29586     DELIMITED BY SIZE INTO WS-WQ-NAME.                           
A01360     STRING '***-**-' PARM-SPOUSE-SSN(6:4)                        
A01360     DELIMITED BY SIZE INTO WS-WQ-SSN.                            
C29586     MOVE WS-WQ-LITERAL        TO KO-INITIAL-COMMENT-TX-TEXT.     
C29586     MOVE +108                 TO KO-INITIAL-COMMENT-TX-LEN.      
C29586                                                                  
C29586     EXEC SQL                                                     
C29586        INSERT INTO CSS_COMM_DATA                                 
C29586             ( COMMUNICATION_ID,                                  
C29586               ACCOUNT_NO,                                        
C29586               CUSTOMER_NO,                                       
C29586               PREMISE_NO,                                        
C29586               COMPANY_NO,                                        
C29586               RED_FLAG_IND,                                      
C29586               RED_FLAG_EXPIRE_DT,                                
C29586               COMM_METHOD,                                       
C29586               COMM_DIRECTION,                                    
C29586               COMM_TYPE_CD,                                      
C29586               COMM_SUBTYPE_CODE,                                 
C29586               USER_ID_ORIG,                                      
C29586               CONTACT_NAME,                                      
C29586               PROMOTION_ID,                                      
C29586               PSC_COMPLIANCE_IND,                                
C29586               CALL_ORIGIN_ID,                                    
C29586               CALL_END_TIME,                                     
C29586               NUMBER_TRANSFERS,                                  
C29586               HOLD_TIME,                                         
C29586               QUEUE_TIME,                                        
C29586               SCREEN_POP_IND,                                    
C29586               TOTAL_CALL_TIME,                                   
C29586               INITIAL_COMMENT_TX,                                
C29586               COMM_ASSOC_CD,                                     
C29586               COMPLAINT_FL,                                      
C29586               DISCOVERY_MTHD_CD,                                 
C29586               PREV_MARKETER_CD)                                  
C29586        VALUES                                                    
C29586             (CIS.CHAR2TIMESTAMP(:KO-COMMUNICATION-ID),                   
C29586              :KO-ACCOUNT-NO,                                     
C29586              :KO-CUSTOMER-NO,                                    
C29586              :KO-PREMISE-NO,                                     
C29586              :KO-COMPANY-NO,                                     
C29586              :KO-RED-FLAG-IND,                                   
C29586              CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                       :WS-NULL-IND-8),               
C29586              :KO-COMM-METHOD,                                    
C29586              :KO-COMM-DIRECTION,                                 
C29586              :KO-COMM-TYPE-CD,                                   
C29586              :KO-COMM-SUBTYPE-CODE,                              
C29586              :KO-USER-ID-ORIG,                                   
C29586              :KO-CONTACT-NAME,                                   
C29586              :KO-PROMOTION-ID,                                   
C29586              :KO-PSC-COMPLIANCE-IND,                             
C29586              :KO-CALL-ORIGIN-ID,                                 
C29586              CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME :WS-NULL-IND-9
              ),                    
C29586              :KO-NUMBER-TRANSFERS,                               
C29586              :KO-HOLD-TIME,                                      
C29586              :KO-QUEUE-TIME,                                     
C29586              :KO-SCREEN-POP-IND,                                 
C29586              :KO-TOTAL-CALL-TIME,                                
C29586              :KO-INITIAL-COMMENT-TX,                             
C29586              :KO-COMM-ASSOC-CD,                                  
C29586              :KO-COMPLAINT-FL,                                   
C29586              :KO-DISCOVERY-MTHD-CD,                              
C29586              :KO-PREV-MARKETER-CD)                               
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COMM_DATA                                         
MFA-TR*            ( COMMUNICATION_ID,                                          
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              COMM_METHOD,                                               
MFA-TR*              COMM_DIRECTION,                                            
MFA-TR*              COMM_TYPE_CD,                                              
MFA-TR*              COMM_SUBTYPE_CODE,                                         
MFA-TR*              USER_ID_ORIG,                                              
MFA-TR*              CONTACT_NAME,                                              
MFA-TR*              PROMOTION_ID,                                              
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              CALL_ORIGIN_ID,                                            
MFA-TR*              CALL_END_TIME,                                             
MFA-TR*              NUMBER_TRANSFERS,                                          
MFA-TR*              HOLD_TIME,                                                 
MFA-TR*              QUEUE_TIME,                                                
MFA-TR*              SCREEN_POP_IND,                                            
MFA-TR*              TOTAL_CALL_TIME,                                           
MFA-TR*              INITIAL_COMMENT_TX,                                        
MFA-TR*              COMM_ASSOC_CD,                                             
MFA-TR*              COMPLAINT_FL,                                              
MFA-TR*              DISCOVERY_MTHD_CD,                                         
MFA-TR*              PREV_MARKETER_CD)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:KO-COMMUNICATION-ID,                                       
MFA-TR*             :KO-ACCOUNT-NO,                                             
MFA-TR*             :KO-CUSTOMER-NO,                                            
MFA-TR*             :KO-PREMISE-NO,                                             
MFA-TR*             :KO-COMPANY-NO,                                             
MFA-TR*             :KO-RED-FLAG-IND,                                           
MFA-TR*             :KO-RED-FLAG-EXPIRE-DT:WS-NULL-IND-8,                       
MFA-TR*             :KO-COMM-METHOD,                                            
MFA-TR*             :KO-COMM-DIRECTION,                                         
MFA-TR*             :KO-COMM-TYPE-CD,                                           
MFA-TR*             :KO-COMM-SUBTYPE-CODE,                                      
MFA-TR*             :KO-USER-ID-ORIG,                                           
MFA-TR*             :KO-CONTACT-NAME,                                           
MFA-TR*             :KO-PROMOTION-ID,                                           
MFA-TR*             :KO-PSC-COMPLIANCE-IND,                                     
MFA-TR*             :KO-CALL-ORIGIN-ID,                                         
MFA-TR*             :KO-CALL-END-TIME:WS-NULL-IND-9,                            
MFA-TR*             :KO-NUMBER-TRANSFERS,                                       
MFA-TR*             :KO-HOLD-TIME,                                              
MFA-TR*             :KO-QUEUE-TIME,                                             
MFA-TR*             :KO-SCREEN-POP-IND,                                         
MFA-TR*             :KO-TOTAL-CALL-TIME,                                        
MFA-TR*             :KO-INITIAL-COMMENT-TX,                                     
MFA-TR*             :KO-COMM-ASSOC-CD,                                          
MFA-TR*             :KO-COMPLAINT-FL,                                           
MFA-TR*             :KO-DISCOVERY-MTHD-CD,                                      
MFA-TR*             :KO-PREV-MARKETER-CD)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '7150'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'INSERT'              TO ABEND-FUNCTION              
C29586        MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
C29586        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
C29586        MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
C29586                                                                  
C29586 7150-EXIT.                                                       
C29586     EXIT.                                                        
C29586                                                                  
C29586 7160-GET-COMPANY.                                                
C29586                                                                  
C29586     EXEC SQL                                                     
C29586        SELECT COMPANY_NO_ORIG                                    
C29586          INTO :KO-COMPANY-NO                                     
C29586          FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
C29586         WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
T35434                                                           
                                                            
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO_ORIG                                            
MFA-TR*         INTO :KO-COMPANY-NO                                             
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                          
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '7160'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29586        MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
C29586        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
C29586        MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
C29586                                                                  
C29586 7160-EXIT.                                                       
C29586     EXIT.                                                        
                                                                        
C29586 7170-DETERMINE-REGION.                                           
C29586                                                                  
C29586     EXEC SQL                                                     
C29586        SELECT DELINQ_VALUE                                       
C29586          INTO :C8-DELINQ-VALUE                                   
C29586          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C29586         WHERE DELINQ_CD = 'DATABASE'                             
C29586           AND COMPANY_NO = '01'                                  
T35434                                                           
                                                            
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '7170'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29586        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
C29586        MOVE 'DELINQ_VALUE'        TO TABLE-ELEMENT-1             
C29586        MOVE 'DATABASE'            TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
C29586                                                                  
C29586 7170-EXIT.                                                       
C29586     EXIT.                                                        
                                                                        
C29586 7200-CREATE-WQ.                                                  
C29586                                                                  
C29586     EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35434*                                                                         
T35434     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T35434     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35434        NEXT SENTENCE                                             
T35434     ELSE                                                         
T35434        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T35434        MOVE '7200'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
T35434        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T35434                                      ABEND-TABLES                
T35434        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T35434        MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1           
T35434        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T35434        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T35434     END-IF.                                                      
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
C29586     IF WS-ACCOUNT-NO-NUM > 0                                     
C29586         PERFORM 7210-GET-LOCAL-OFFICE THRU 7210-EXIT             
A04860         MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE       
C29586     ELSE                                                         
A04860         MOVE SPACES                  TO WS-77-LOCAL-OFFICE
           END-IF.      
A04860     MOVE PARM-USERID                 TO WS-77-USER-ID-ORIG.      
A04860     MOVE SPACES                      TO WS-77-USER-ID-ASGN.      
A04860     MOVE WS-RESP-AREA-ID             TO WS-77-RESP-AREA-ID.      
A04860     MOVE WS-ACCOUNT-NO-NUM           TO WS-77-ACCOUNT-NO.        
A04860     MOVE WS-PREMISE-NO-NUM           TO WS-77-PREMISE-NO.        
A04860     MOVE PARM-CUSTOMER-NO-NUM        TO WS-77-CUSTOMER-NO.       
A04860     MOVE ZERO                        TO WS-77-SERV-ORDER-NO.     
A04860     MOVE WS-CURRENT-TIMESTAMP        TO WS-77-DATE-REQUIRED.     
A04860     MOVE WS-CURRENT-TIMESTAMP        TO WS-77-DATE-CREATED.      
A04860     MOVE 'H'                         TO WS-77-PRIORITY.          
A04860     MOVE '5'                         TO WS-77-ROUTE-CATEGORY.    
A04860     MOVE 370                         TO WS-77-CATEGORY-ID.       
A04860     MOVE WS-WQ-LITERAL               TO WS-77-COMMENTS-TEXT.     
A04860     MOVE +108                        TO WS-77-COMMENTS-LEN.      
A04860     MOVE PROGRAM-NAME                TO WS-77-CREATED-BY.        
C29586     PERFORM 8500-INSERT-WQ           THRU 8500-EXIT.             
C29586                                                                  
C29586 7200-EXIT.                                                       
C29586      EXIT.                                                       
                                                                        
C29586 7210-GET-LOCAL-OFFICE.                                           
C29586                                                                  
C29586     EXEC SQL                                                     
C29586        SELECT LOCAL_OFFICE                                       
C29586          INTO :AT-LOCAL-OFFICE                                   
C29586          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
C29586         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
T35434                                                           
                                                            
C29586     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*         INTO :AT-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                            
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '7210'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29586        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
C29586        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29586        MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
C29586                                                                  
C29586 7210-EXIT.                                                       
C29586     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-INSERT-NAME.                                              *        
      ******************************************************************        
       8010-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     NICKNAME,                                          
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-NICKNAME,                                       
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              NICKNAME,                                                  
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-NICKNAME,                                               
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_NAME'           TO TABLE-1                      
T16430        MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
T16430        MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-NAME-XREF.                                         *        
      *    1.  INSERT CSS_NAME_ACCT_XREF.                              *        
      ******************************************************************        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CONTACT_ID,                                        
T22161               TOWN,                                              
T22161               STATE,                                             
T22161               LOCAL_OFFICE,                                      
P00594               ACCOUNT_TYPE_CODE,                                 
P00594               CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CONTACT-ID,                                     
T22161              :HT-TOWN,                                           
T22161              :HT-STATE,                                          
T22161              :HT-LOCAL-OFFICE,                                   
P00594              :HT-ACCOUNT-TYPE-CODE,                              
P00594              :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
T16430        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
T16430        MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
T16430        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
T16430        MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
CBSI          MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-INSERT-PHONE.                                             *        
      *    1.  INSERT CSS_CUST_PHONE VALUES.                           *        
      ******************************************************************        
       8030-INSERT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO)                                      
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    :WS-CUSTOMER-TYPE,                                  
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8040-INSERT-CUST-STATS.                                        *        
      *    1.  INSERT CSS_CUST_STATS VALUES.                           *        
      ******************************************************************        
       8040-INSERT-CUST-STATS.                                          
                                                                        
           IF PARM-SPOUSE-EMPLOYED-DATE  <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-1               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-1               
           END-IF.                                                      
           IF PARM-SPOUSE-DATE-OF-BIRTH  <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-3               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-3               
           END-IF.                                                      
           IF PARM-SPOUSE-DRVR-LIC-DT    <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-2               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-2               
           END-IF.                                                      
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     EMPLOYED_DATE,                                     
                     OCCUPATION,                                        
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DRVR_LIC_ISS_DT,                                   
                     DATE_OF_BIRTH,                                     
                     EMPLOYEE_NBR,                                      
                     INTR_CO_IND,                                       
P00740               ACCESS_LEVEL_CD)                                   
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-SSN,                                            
                    :CE-NAME-ID,                                        
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    IIF(TRY_CONVERT(DATE, :CE-EMPLOYED-DATE 
                                          :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :CE-EMPLOYED-DATE 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:CE-EMPLOYED-DATE :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:CE-EMPLOYED-DATE :WS-NULL-IND-1
              ), CONVERT(DATE, :CE-EMPLOYED-DATE :WS-NULL-IND-1) ),            
                    :CE-OCCUPATION,                                     
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    IIF(TRY_CONVERT(DATE, :CE-DRVR-LIC-ISS-DT 
                                          :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :CE-DRVR-LIC-ISS-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:CE-DRVR-LIC-ISS-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:CE-DRVR-LIC-ISS-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :CE-DRVR-LIC-ISS-DT :WS-NULL-IND-2) ),          
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH 
                                          :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-IND-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-IND-3) ),            
                    :CE-EMPLOYEE-NBR,                                   
                    :CE-INTR-CO-IND,                                    
P00740              :CE-ACCESS-LEVEL-CD)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              EMPLOYED_DATE,                                             
MFA-TR*              OCCUPATION,                                                
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DRVR_LIC_ISS_DT,                                           
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              EMPLOYEE_NBR,                                              
MFA-TR*              INTR_CO_IND,                                               
MFA-TR*              ACCESS_LEVEL_CD)                                           
MFA-TR*       VALUES                                                            
MFA-TR*            (:CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-SSN,                                                    
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-CODE-STATE-ID,                                          
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-EMPLOYED-DATE:WS-NULL-IND-1,                            
MFA-TR*             :CE-OCCUPATION,                                             
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-DRVR-LIC-ISS-DT:WS-NULL-IND-2,                          
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-IND-3,                            
MFA-TR*             :CE-EMPLOYEE-NBR,                                           
MFA-TR*             :CE-INTR-CO-IND,                                            
MFA-TR*             :CE-ACCESS-LEVEL-CD)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'NAME_ID'            TO TABLE-ELEMENT-3              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-INSERT-CONT-PHONE                                         *        
      *    1.  INSERT CSS_CONTACT_PHONE VALUES.                        *        
      ******************************************************************        
       8050-INSERT-CONT-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_PHONE                             
                   ( CONTACT_ID,                                        
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO)                                      
              VALUES                                                    
                   (:LP-CONTACT-ID,                                     
                    :LP-PHONE-TYPE,                                     
                    :LP-PHONE-NO,                                       
                    :LP-EXTENSION-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8060-INSERT-CONT-CUST                                          *        
      *    1.  INSERT CSS_CONTACT_CUST VALUES                          *        
      ******************************************************************        
       8060-INSERT-CONT-CUST.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_CUST                              
                   ( CONTACT_ID,                                        
                     CUSTOMER_NO)                                       
              VALUES                                                    
                   (:DT-CONTACT-ID,                                     
                    :DT-CUSTOMER-NO)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8070-INSERT-ADDRESS                                            *        
      *    1.  INSERT CSS_ADDR_FREEFORM VALUES.                        *        
      ******************************************************************        
       8070-INSERT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                   ( ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   ( :DZ-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET,                                   
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY,                                  
                     :DZ-ADDRESS-OVERFLOW)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8070'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8080-INSERT-CONTACT                                            *        
      *    1.  INSERT CSS_CONTACT VALUES.                              *        
      ******************************************************************        
       8080-INSERT-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT                                   
                   ( CONTACT_ID,                                        
                     CONTACT_TYPE,                                      
                     CONTACT_ORDER,                                     
                     NAME_ID,                                           
                     ADDRESS_ID,                                        
                     CONTACT_POSITION,                                  
                     DATE_CREATED,                                      
P00740               ACCESS_LEVEL_CD,                                   
P00740               ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:CV-CONTACT-ID,                                     
                    :CV-CONTACT-TYPE,                                   
                    :CV-CONTACT-ORDER,                                  
                    :CV-NAME-ID,                                        
                    :CV-ADDRESS-ID,                                     
                    :CV-CONTACT-POSITION,                               
                    IIF(TRY_CONVERT(DATE, :CV-DATE-CREATED
              ) IS NULL OR (PATINDEX('%.%', :CV-DATE-CREATED
              ) <> 0) OR (LEN(:CV-DATE-CREATED) <> 10), CIS.CHAR2DATE(
                                                       :CV-DATE-CREATED
              ), CONVERT(DATE, :CV-DATE-CREATED) ),                            
P00740              :CV-ACCESS-LEVEL-CD,                                
P00740              'B')                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT                                           
MFA-TR*            ( CONTACT_ID,                                                
MFA-TR*              CONTACT_TYPE,                                              
MFA-TR*              CONTACT_ORDER,                                             
MFA-TR*              NAME_ID,                                                   
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              CONTACT_POSITION,                                          
MFA-TR*              DATE_CREATED,                                              
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              ADDRESS_FORMAT)                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (:CV-CONTACT-ID,                                             
MFA-TR*             :CV-CONTACT-TYPE,                                           
MFA-TR*             :CV-CONTACT-ORDER,                                          
MFA-TR*             :CV-NAME-ID,                                                
MFA-TR*             :CV-ADDRESS-ID,                                             
MFA-TR*             :CV-CONTACT-POSITION,                                       
MFA-TR*             :CV-DATE-CREATED,                                           
MFA-TR*             :CV-ACCESS-LEVEL-CD,                                        
MFA-TR*             'B')                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8080'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT'        TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'NAME_ID'            TO TABLE-ELEMENT-3              
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE CV-NAME-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8110-DELETE-ADDRESS-ID.                                        *        
      *    1.  DELETE CONTACT ADDRESS INFORMATION.                     *        
      ******************************************************************        
       8110-DELETE-ADDRESS-ID.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ADDR_FREEFORM                                     
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8110'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DZ-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8120-DELETE-NAME-ID.                                           *        
      *    1.  DELETE CONTACT NAME INFORMATION.                        *        
      ******************************************************************        
       8120-DELETE-NAME-ID.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME                                      
               WHERE NAME_ID   = :DQ-NAME-ID                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME                                              
MFA-TR*        WHERE NAME_ID   = :DQ-NAME-ID                                    
MFA-TR*       QUERYNO 8120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8120'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8130-DELETE-CONTACT.                                           *        
      *    1.  DELETE CONTACT INFORMATION.                             *        
      ******************************************************************        
       8130-DELETE-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT                                   
               WHERE CONTACT_ID = :DT-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT                                           
MFA-TR*        WHERE CONTACT_ID = :DT-CONTACT-ID                                
MFA-TR*       QUERYNO 8130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8130'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT'         TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'NAME_ID'             TO TABLE-ELEMENT-2             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
              MOVE DT-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-NAME-ID-NO-NUM     TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8140-DELETE-CUST-CONT.                                         *        
      *    1.  DELETE CUSTOMER-CONTACT ASSOCIATIVE INFORMATION.        *        
      ******************************************************************        
       8140-DELETE-CUST-CONT.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_CUST                              
               WHERE CONTACT_ID   = :DT-CONTACT-ID                      
                 AND CUSTOMER_NO  = :WS-CUSTOMER-NO-NUM                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_CUST                                      
MFA-TR*        WHERE CONTACT_ID   = :DT-CONTACT-ID                              
MFA-TR*          AND CUSTOMER_NO  = :WS-CUSTOMER-NO-NUM                         
MFA-TR*       QUERYNO 8140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8140'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT_CUST'    TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE DT-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8141-DELETE-PREM-CONT.                                         *        
      *    1.  DELETE PREMISE-CONTACT  ASSOCIATIVE INFORMATION.        *        
      ******************************************************************        
       8141-DELETE-PREM-CONT.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_PREM                              
               WHERE CONTACT_ID   = :DT-CONTACT-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_PREM                                      
MFA-TR*        WHERE CONTACT_ID   = :DT-CONTACT-ID                              
MFA-TR*       QUERYNO 8141                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8141'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT_PREM'    TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE DT-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8141-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8142-DELETE-ACCT-CONT.                                         *        
      *    1.  DELETE ACCOUNT-CONTACT  ASSOCIATIVE INFORMATION.        *        
      ******************************************************************        
       8142-DELETE-ACCT-CONT.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_ACCT                              
               WHERE CONTACT_ID   = :DT-CONTACT-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_ACCT                                      
MFA-TR*        WHERE CONTACT_ID   = :DT-CONTACT-ID                              
MFA-TR*       QUERYNO 8142                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8142'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_CONTACT_ACCT'    TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE DT-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8142-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-DELETE-NAME-ACCT-XREF.                                    *        
      *    1.  DELETE RECORDS FROM CSS_NAME_ACCT_XREF BASED ON CUST NO.*        
      ******************************************************************        
       8150-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
              WHERE  NAME_ID     = :HT-NAME-ID                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*       WHERE  NAME_ID     = :HT-NAME-ID                                  
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
T16430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8150'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-2             
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-4             
              MOVE HT-NAME-ID            TO HOSTVAR-ELEMENT-1           
CBSI          MOVE DT-CONTACT-ID         TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8190-DELETE-NULL-CSTS.                                         *        
      *    1. THIS PARAGRAPH INGENIOUSLY DELETES A CUST_STATS RECORD   *        
      *       IF THERE ARE NO VALUES IN ANY OF THE FIELDS.             *        
      ******************************************************************        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  :WS-CUSTOMER-TYPE            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  :WS-CUSTOMER-TYPE                    
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE WS-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8210-DELETE-NULL-PHONE.                                        *        
      *    1. THIS PARAGRAPH DELETES A CUST_PHONE RECORD FOR CUSTOMER  *        
      *       TYPE SPOUSE.                                             *        
      ******************************************************************        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO               
                 AND CUSTOMER_TYPE      = :WS-CUSTOMER-TYPE             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO                       
MFA-TR*          AND CUSTOMER_TYPE      = :WS-CUSTOMER-TYPE                     
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE WS-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8220-DELETE-CONT-PHONE.                                        *        
      *    1. THIS PARAGRAPH DELETES A CONTACT PHONE FOR CONTACT TYPE  *        
      *       RELATIVE.                                                *        
      ******************************************************************        
       8220-DELETE-CONT-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_PHONE                             
               WHERE CONTACT_ID         = :LP-CONTACT-ID                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_PHONE                                     
MFA-TR*        WHERE CONTACT_ID         = :LP-CONTACT-ID                        
MFA-TR*       QUERYNO 8220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8310-UPDATE-NAME-ID.                                           *        
      *    1. SAVE THE INCREMENTED LAST NAME ID USED.                  *        
      ******************************************************************        
      *8310-UPDATE-NAME-ID.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       UPDATE CSS_NAME_ID_CNTL                                           
      *          SET NAME_ID   = :WS-NAME-ID-NO-NUM                             
      *        WHERE NAME_ID   = :I7-NAME-ID                                    
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '8310'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'UPDATE'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_NAME_ID_CNTL'    TO TABLE-1                             
      *       MOVE 'NAME_ID'             TO TABLE-ELEMENT-1                     
      *       MOVE WS-NAME-ID-NO-NUM     TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8310-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 8320-UPDATE-CSTS.                                              *        
      *    1. UPDATES MODIFIED FIELDS OF CSS_CUST_STATS.               *        
      ******************************************************************        
       8320-UPDATE-CSTS.                                                
           IF PARM-SPOUSE-EMPLOYED-DATE  <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-1               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-1               
           END-IF.                                                      
           IF PARM-SPOUSE-DATE-OF-BIRTH  <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-3               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-3               
           END-IF.                                                      
           IF PARM-SPOUSE-DRVR-LIC-DT    <= SPACES                      
              MOVE -1                    TO WS-NULL-IND-2               
           ELSE                                                         
              MOVE 0                     TO WS-NULL-IND-2               
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
              SET SSN                = :CE-SSN,                         
                  CODE_STATE_ID      = :CE-CODE-STATE-ID,               
                  DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,          
                  EMPLOYER           = :CE-EMPLOYER,                    
                  EMPLOYED_DATE      =                                  
                  IIF(TRY_CONVERT(DATE, :CE-EMPLOYED-DATE :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :CE-EMPLOYED-DATE 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:CE-EMPLOYED-DATE :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:CE-EMPLOYED-DATE :WS-NULL-IND-1
              ), CONVERT(DATE, :CE-EMPLOYED-DATE :WS-NULL-IND-1) ),            
                  OCCUPATION         = :CE-OCCUPATION,                  
                  OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE,               
                  OTHER_ID           = :CE-OTHER-ID,                    
                  DRVR_LIC_ISS_DT    =                                  
                  IIF(TRY_CONVERT(DATE, :CE-DRVR-LIC-ISS-DT 
                                        :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :CE-DRVR-LIC-ISS-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:CE-DRVR-LIC-ISS-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:CE-DRVR-LIC-ISS-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :CE-DRVR-LIC-ISS-DT :WS-NULL-IND-2) ),          
                  DATE_OF_BIRTH      =                                  
                  IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-IND-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-IND-3) ),            
                  EMPLOYEE_NBR       = :CE-EMPLOYEE-NBR                 
               WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                  
                 AND CUSTOMER_TYPE   = :WS-CUSTOMER-TYPE                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*       SET SSN                = :CE-SSN,                                 
MFA-TR*           CODE_STATE_ID      = :CE-CODE-STATE-ID,                       
MFA-TR*           DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,                  
MFA-TR*           EMPLOYER           = :CE-EMPLOYER,                            
MFA-TR*           EMPLOYED_DATE      =                                          
MFA-TR*           :CE-EMPLOYED-DATE:WS-NULL-IND-1,                              
MFA-TR*           OCCUPATION         = :CE-OCCUPATION,                          
MFA-TR*           OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE,                       
MFA-TR*           OTHER_ID           = :CE-OTHER-ID,                            
MFA-TR*           DRVR_LIC_ISS_DT    =                                          
MFA-TR*           :CE-DRVR-LIC-ISS-DT:WS-NULL-IND-2,                            
MFA-TR*           DATE_OF_BIRTH      =                                          
MFA-TR*           :CE-DATE-OF-BIRTH:WS-NULL-IND-3,                              
MFA-TR*           EMPLOYEE_NBR       = :CE-EMPLOYEE-NBR                         
MFA-TR*        WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                          
MFA-TR*          AND CUSTOMER_TYPE   = :WS-CUSTOMER-TYPE                        
MFA-TR*       QUERYNO 8320                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8320'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
T16430        MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
T16430        MOVE WS-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE 'EMPLOYER'           TO TABLE-ELEMENT-3              
CBSI          MOVE CE-EMPLOYER          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8330-UPDATE-PHONE.                                             *        
      *    1. UPDATES PHONE NUMBERS BASED ON CUST NO AND PHONE TYPE.   *        
      ******************************************************************        
       8330-UPDATE-PHONE.                                               
                                                                        
      *    EXEC SQL                                                             
      *       UPDATE CSS_CUST_PHONE                                             
      *       SET    PHONE_NO      = :CB-PHONE-NO,                              
      *              EXTENSION_NO  = :CB-EXTENSION-NO                           
      *       WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                            
      *         AND  PHONE_TYPE    = :CB-PHONE-TYPE                             
      *         AND  CUSTOMER_TYPE = :WS-CUSTOMER-TYPE                          
      *    END-EXEC.                                                            
                                                                        
A01362     EXEC SQL                                                     
A01362         MERGE INTO CSS_CUST_PHONE CB                             
A01362             USING (VALUES ( :CB-CUSTOMER-NO,                     
A01362                             :CB-PHONE-TYPE,                      
A01362                             :CB-PHONE-NO,                        
A01362                             :CB-EXTENSION-NO,                    
A01362                             :WS-CUSTOMER-TYPE))                  
A01362             AS TCB (CUSTOMER_NO,                                 
A01362                     PHONE_TYPE,                                  
A01362                     PHONE_NO,                                    
A01362                     EXTENSION_NO,                                
A01362                     CUSTOMER_TYPE)                               
A01362              ON   CB.CUSTOMER_NO   = TCB.CUSTOMER_NO             
A01362               AND CB.PHONE_TYPE    = TCB.PHONE_TYPE              
A01362               AND CB.CUSTOMER_TYPE = TCB.CUSTOMER_TYPE           
A01362             WHEN MATCHED THEN                                    
A01362                 UPDATE SET CB.PHONE_NO = TCB.PHONE_NO,           
A01362                            CB.EXTENSION_NO = TCB.EXTENSION_NO    
A01362             WHEN NOT MATCHED THEN                                
A01362                 INSERT (CUSTOMER_NO,                          
A01362                         PHONE_TYPE,                           
A01362                         PHONE_NO,                             
A01362                         EXTENSION_NO,                         
A01362                         CUSTOMER_TYPE)                        
A01362                 VALUES (TCB.CUSTOMER_NO,                         
A01362                         TCB.PHONE_TYPE,                          
A01362                         TCB.PHONE_NO,                            
A01362                         TCB.EXTENSION_NO,                        
A01362                         TCB.CUSTOMER_TYPE)                       
              ;                                              
A01362     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ018
MFA-TR* MSQ058
MFA-TR*    EXEC SQL                                                             
MFA-TR*        MERGE INTO CSS_CUST_PHONE CB                                     
MFA-TR*            USING (VALUES ( :CB-CUSTOMER-NO,                             
MFA-TR*                            :CB-PHONE-TYPE,                              
MFA-TR*                            :CB-PHONE-NO,                                
MFA-TR*                            :CB-EXTENSION-NO,                            
MFA-TR*                            :WS-CUSTOMER-TYPE))                          
MFA-TR*            AS TCB (CUSTOMER_NO,                                         
MFA-TR*                    PHONE_TYPE,                                          
MFA-TR*                    PHONE_NO,                                            
MFA-TR*                    EXTENSION_NO,                                        
MFA-TR*                    CUSTOMER_TYPE)                                       
MFA-TR*             ON   CB.CUSTOMER_NO   = TCB.CUSTOMER_NO                     
MFA-TR*              AND CB.PHONE_TYPE    = TCB.PHONE_TYPE                      
MFA-TR*              AND CB.CUSTOMER_TYPE = TCB.CUSTOMER_TYPE                   
MFA-TR*            WHEN MATCHED THEN                                            
MFA-TR*                UPDATE SET CB.PHONE_NO = TCB.PHONE_NO,                   
MFA-TR*                           CB.EXTENSION_NO = TCB.EXTENSION_NO            
MFA-TR*            WHEN NOT MATCHED THEN                                        
MFA-TR*                INSERT (CB.CUSTOMER_NO,                                  
MFA-TR*                        CB.PHONE_TYPE,                                   
MFA-TR*                        CB.PHONE_NO,                                     
MFA-TR*                        CB.EXTENSION_NO,                                 
MFA-TR*                        CB.CUSTOMER_TYPE)                                
MFA-TR*                VALUES (TCB.CUSTOMER_NO,                                 
MFA-TR*                        TCB.PHONE_TYPE,                                  
MFA-TR*                        TCB.PHONE_NO,                                    
MFA-TR*                        TCB.EXTENSION_NO,                                
MFA-TR*                        TCB.CUSTOMER_TYPE)                               
MFA-TR*       QUERYNO 8330                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T18756     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8330'               TO ACTIVE-PARAGRAPH             
A01362        MOVE 'MERGE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE WS-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
CBSI          MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8340-UPDATE-NAME.                                              *        
      *    1. UPDATES NAME INFORMATION BASED ON CUST NO.               *        
      ******************************************************************        
       8340-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
              SET    NAME_FORMAT     = :DQ-NAME-FORMAT,                 
                     FIRST_NAME      = :DQ-FIRST-NAME,                  
                     MIDDLE_NAME     = :DQ-MIDDLE-NAME,                 
                     LAST_NAME       = :DQ-LAST-NAME,                   
                     NICKNAME        = :DQ-NICKNAME,                    
                     TITLE_PREFIX    = :DQ-TITLE-PREFIX,                
                     TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,              
                     FULL_NAME       = :DQ-FULL-NAME                    
              WHERE  NAME_ID         = :DQ-NAME-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*       SET    NAME_FORMAT     = :DQ-NAME-FORMAT,                         
MFA-TR*              FIRST_NAME      = :DQ-FIRST-NAME,                          
MFA-TR*              MIDDLE_NAME     = :DQ-MIDDLE-NAME,                         
MFA-TR*              LAST_NAME       = :DQ-LAST-NAME,                           
MFA-TR*              NICKNAME        = :DQ-NICKNAME,                            
MFA-TR*              TITLE_PREFIX    = :DQ-TITLE-PREFIX,                        
MFA-TR*              TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,                      
MFA-TR*              FULL_NAME       = :DQ-FULL-NAME                            
MFA-TR*       WHERE  NAME_ID         = :DQ-NAME-ID                              
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8340'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
CBSI          MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8350-UPDATE-CONTACT.                                           *        
      *    1. UPDATES MODIFIED FIELDS OF CSS_CONTACT.                  *        
      ******************************************************************        
       8350-UPDATE-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT                                        
                 SET CONTACT_POSITION = :CV-CONTACT-POSITION,           
                     CONTACT_TYPE     = :CV-CONTACT-TYPE                
               WHERE CONTACT_ID       = :CV-CONTACT-ID                  
                 AND CONTACT_TYPE     IN ('RR','RL')                    
                 AND CONTACT_ORDER    = 0                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT                                                
MFA-TR*          SET CONTACT_POSITION = :CV-CONTACT-POSITION,                   
MFA-TR*              CONTACT_TYPE     = :CV-CONTACT-TYPE                        
MFA-TR*        WHERE CONTACT_ID       = :CV-CONTACT-ID                          
MFA-TR*          AND CONTACT_TYPE     IN ('RR','RL')                            
MFA-TR*          AND CONTACT_ORDER    = 0                                       
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8350'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT   '     TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
T16430        MOVE 'CONTACT_TYPE'       TO TABLE-ELEMENT-2              
T16430        MOVE WS-CONTACT-TYPE      TO HOSTVAR-ELEMENT-2            
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3              
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'CONTACT_POSITION'   TO TABLE-ELEMENT-4              
CBSI          MOVE CV-CONTACT-POSITION  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8360-UPDATE-CONT-PHONE.                                        *        
      *    1. UPDATES PHONE NUMBERS BASED ON CONTACT ID.               *        
      ******************************************************************        
       8360-UPDATE-CONT-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_PHONE                                  
              SET    PHONE_NO      = :LP-PHONE-NO,                      
                     EXTENSION_NO  = :LP-EXTENSION-NO                   
              WHERE  CONTACT_ID    = :LP-CONTACT-ID                     
                AND  PHONE_TYPE    = :WS-HOME-PHONE-TYPE                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_PHONE                                          
MFA-TR*       SET    PHONE_NO      = :LP-PHONE-NO,                              
MFA-TR*              EXTENSION_NO  = :LP-EXTENSION-NO                           
MFA-TR*       WHERE  CONTACT_ID    = :LP-CONTACT-ID                             
MFA-TR*         AND  PHONE_TYPE    = :WS-HOME-PHONE-TYPE                        
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
A02292     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
A02292             IF PARM-RELATIVE-PHONE > SPACES                      
A02292                MOVE 'NO '            TO WS-RELT-EXISTS-FLAG      
A02292                PERFORM 7100-SELECT-RELATIVE THRU 7100-EXIT       
A02292               IF RELT-EXISTS                                     
A02292                MOVE CV-CONTACT-ID       TO LP-CONTACT-ID         
A02292                MOVE SPACES              TO LP-EXTENSION-NO       
A02292                MOVE WS-HOME-PHONE-TYPE  TO LP-PHONE-TYPE         
A02292                MOVE PARM-RELATIVE-PHONE TO LP-PHONE-NO           
A02292                PERFORM 8050-INSERT-CONT-PHONE THRU 8050-EXIT     
A02292               END-IF                                             
A02292             ELSE                                                 
A02292               NEXT SENTENCE                                      
A02292             END-IF                                               
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
CBSI          MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
T16430        MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
T16430        MOVE WS-HOME-PHONE-TYPE   TO HOSTVAR-ELEMENT-2            
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3              
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-3            
CBSI          MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
CBSI          MOVE LP-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8370-UPDATE-ADDRESS                                            *        
      *    1. UPDATES ADDRESS BASED ON THE CONTACT ID                  *        
      ******************************************************************        
       8370-UPDATE-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
              SET    ADDR_STREET      = :DZ-ADDR-STREET,                
                     ADDR_CITY_STATE  = :DZ-ADDR-CITY-STATE,            
                     ADDR_ZIP_CODE    = :DZ-ADDR-ZIP-CODE,              
                     ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW            
              WHERE  ADDRESS_ID       = :DZ-ADDRESS-ID                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                          
MFA-TR*       SET    ADDR_STREET      = :DZ-ADDR-STREET,                        
MFA-TR*              ADDR_CITY_STATE  = :DZ-ADDR-CITY-STATE,                    
MFA-TR*              ADDR_ZIP_CODE    = :DZ-ADDR-ZIP-CODE,                      
MFA-TR*              ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW                    
MFA-TR*       WHERE  ADDRESS_ID       = :DZ-ADDRESS-ID                          
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
CBSI          MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8380-UPDATE-CONT-ID.                                           *        
      *    1. SAVE THE INCREMENTED LAST CONT ID USED.                  *        
      ******************************************************************        
      *8380-UPDATE-CONT-ID.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       UPDATE CSS_CNTCT_ID_CNTL                                          
      *          SET CONTACT_ID   = :WS-CONT-ID-NO-NUM                          
      *        WHERE CONTACT_ID   = :I6-CONTACT-ID                              
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '8380'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'UPDATE'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_CNTCT_ID_CNTL'   TO TABLE-1                             
      *       MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1                     
      *       MOVE WS-CONT-ID-NO-NUM     TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8380-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 8390-UPDATE-ADDR-ID.                                           *        
      *    1. SAVE THE INCREMENTED LAST ADDR ID USED.                  *        
      ******************************************************************        
      *8390-UPDATE-ADDR-ID.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       UPDATE CSS_ADDR_ID_CNTL                                           
      *          SET ADDRESS_ID   = :WS-ADDR-ID-NO-NUM                          
      *        WHERE ADDRESS_ID   = :I8-ADDRESS-ID                              
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '8390'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'UPDATE'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_ADDR_ID_CNTL'    TO TABLE-1                             
      *       MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1                     
      *       MOVE WS-ADDR-ID-NO-NUM     TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8390-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
T4999 ******************************************************************        
T4999 * 8400-OPEN-SPOUSE-CURSOR.                                       *        
T4999 *    1. OPEN THE CURSOR                                          *        
T4999 ******************************************************************        
T4999  8400-OPEN-SPOUSE-CURSOR.                                         
T4999      EXEC SQL                                                     
T4999         OPEN SPOUSE_CURSOR                                        
T4999      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T4999                                                                   
T4999      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T4999                                                                   
T4999      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T4999         NEXT SENTENCE                                             
T4999      ELSE                                                         
T4999         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T4999         MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T4999         MOVE '8400'                TO ACTIVE-PARAGRAPH            
T4999         MOVE 'OPEN'                TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
T4999         MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
T16430        MOVE 'CSS_NAME'            TO TABLE-2                     
T4999         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T4999         MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
T4999         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T4999         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T4999      END-IF.                                                      
T4999                                                                   
T4999  8400-EXIT.                                                       
T4999      EXIT.                                                        
T4999                                                                   
T4999 ******************************************************************        
T4999 * 8410-FETCH-ALL-ACCOUNTS.                                       *        
T4999 *    1. FETCH ALL OF THE CUSTOMER ACCOUNTS                       *        
T4999 ******************************************************************        
T4999  8410-FETCH-ALL-ACCOUNTS.                                         
T4999      EXEC SQL                                                     
T4999         FETCH SPOUSE_CURSOR                                       
T4999          INTO :WS-ACCOUNT-NO,                                     
T4999               :WS-ADDRESS-ID,                                     
T4999               :WS-COMPANY-NO,                                     
T4999               :WS-PREMISE-NO,                                     
T22161              :WS-TOWN,                                           
T22161              :WS-STATE,                                          
T22161              :WS-LOCAL-OFFICE,                                   
P00594              :WS-ACCOUNT-TYPE-CODE,                              
P00594              :WS-CODE-ACCT-STAT                                  
T4999      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T4999                                                                   
T4999      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T4999                                                                   
T4999      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T4999           OR NOT-FOUND                                            
T4999         NEXT SENTENCE                                             
T4999      ELSE                                                         
T4999         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T4999         MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T4999         MOVE '8410'                TO ACTIVE-PARAGRAPH            
T4999         MOVE 'FETCH'               TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
T4999         MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
T16430        MOVE 'CSS_NAME'            TO TABLE-2                     
T4999         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T4999         MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
T4999         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T4999         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T4999      END-IF.                                                      
T4999                                                                   
T4999  8410-EXIT.                                                       
T4999      EXIT.                                                        
T4999                                                                   
T4999 ******************************************************************        
T4999 * 8420-CLOSE-SPOUSE-CURSOR.                                      *        
T4999 *    1. CLOSES THE CURSOR                                        *        
T4999 ******************************************************************        
T4999  8420-CLOSE-SPOUSE-CURSOR.                                        
T4999      EXEC SQL                                                     
T4999         CLOSE SPOUSE_CURSOR                                       
T4999      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T4999                                                                   
T4999      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T4999                                                                   
T4999      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T4999         NEXT SENTENCE                                             
T4999      ELSE                                                         
T4999         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T4999         MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T4999         MOVE '8420'                TO ACTIVE-PARAGRAPH            
T4999         MOVE 'CLOSE'               TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
T4999         MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
T16430        MOVE 'CSS_NAME'            TO TABLE-2                     
T4999         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T4999         MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
T4999         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T4999         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T4999      END-IF.                                                      
T4999                                                                   
T4999  8420-EXIT.                                                       
T4999      EXIT.                                                        
                                                                        
C29586******************************************************************        
C29586* 8430-OPEN-STATS-CURSOR.                                        *        
C29586*    1. OPEN THE CURSOR                                          *        
C29586******************************************************************        
C29586 8430-OPEN-STATS-CURSOR.                                          
C29586     EXEC SQL                                                     
C29586        OPEN STATS_CURSOR                                         
C29586     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '8430'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'OPEN'                TO ABEND-FUNCTION              
C29586        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C29586                                      ABEND-TABLES                
C29586        MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
C29586        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
C29586        MOVE WS-SPOUSE-CUST-NO     TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29586     END-IF.                                                      
C29586                                                                  
C29586 8430-EXIT.                                                       
C29586     EXIT.                                                        
C29586                                                                  
C29586******************************************************************        
C29586* 8440-FETCH-ALL-SPOUSE-CUSTOMER                                 *        
C29586*    1. FETCH ALL OF THE SPOUSE CUSTOMER                         *        
C29586******************************************************************        
C29586 8440-FETCH-ALL-SPOUSE-CUSTOMER.                                  
C29586     EXEC SQL                                                     
C29586        FETCH STATS_CURSOR                                        
C29586        INTO   :WS-SPOUSE-CUST-NO                                 
C29586     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586          OR NOT-FOUND                                            
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T29586        MOVE '8440'                TO ACTIVE-PARAGRAPH            
T29586        MOVE 'FETCH'               TO ABEND-FUNCTION              
C29586        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C29586                                      ABEND-TABLES                
C29586        MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
C29586        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
C29586        MOVE WS-SPOUSE-CUST-NO     TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29586     END-IF.                                                      
C29586                                                                  
C29586 8440-EXIT.                                                       
C29586     EXIT.                                                        
C29586                                                                  
C29586******************************************************************        
C29586* 8450-CLOSE-STATS-CURSOR.                                       *        
C29586*    1. CLOSES THE CURSOR                                        *        
C29586******************************************************************        
C29586 8450-CLOSE-STATS-CURSOR.                                         
C29586     EXEC SQL                                                     
C29586        CLOSE STATS_CURSOR                                        
C29586     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29586                                                                  
C29586     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29586                                                                  
C29586     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29586        NEXT SENTENCE                                             
C29586     ELSE                                                         
C29586        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C29586        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29586        MOVE '8450'                TO ACTIVE-PARAGRAPH            
C29586        MOVE 'CLOSE'               TO ABEND-FUNCTION              
C29586        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C29586                                      ABEND-TABLES                
C29586        MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
C29586        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
C29586        MOVE WS-SPOUSE-CUST-NO     TO HOSTVAR-ELEMENT-1           
C29586        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29586        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29586     END-IF.                                                      
C29586                                                                  
C29586 8450-EXIT.                                                       
C29586     EXIT.                                                        
                                                                        
C29586 8500-INSERT-WQ.                                                  
C29586                                                                  
P00757     INITIALIZE   WS-MCSCB077-OUTPUT.                             
C29586                                                                  
A04860     MOVE ZERO                       TO WS-77-ITEM-ID             
C33453*                                                                         
           CALL MCSCB077  USING   CWS00077-FIELDS,                      
                                  ABEND-FILE,                           
                                  WS-MCSCB077-RET-CODE.                 
      *                                                                         
           MOVE WS-MCSCB077-RET-CODE       TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '8500'                 TO ACTIVE-PARAGRAPH          
A04860         MOVE 'CALL'                 TO ABEND-FUNCTION            
P00757         MOVE 'SCSCB077'             TO TABLE-1                   
C33453         MOVE 'RETURN-CODE'          TO TABLE-ELEMENT-1           
A04860         MOVE WS-MCSCB077-RET-CODE   TO HOSTVAR-ELEMENT-1         
C33453         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
C33453         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
C29586                                                                  
C29586 8500-EXIT.                                                       
C29586     EXIT.                                                        
C29586*                                                                         
C29586******************************************************************        
                                                                        
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000*    EXEC SQL                                                             
CVT000*        INCLUDE CPD00321                                                 
CVT000*    END-EXEC.                                                            
REARCH* INCLUDED COPY BOOK HAVING COMMIT LOGIC  BEFORE STOP RUN.                
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00331                                                
REARCH     END-EXEC.                                                            
