       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02027.                                         
COB303 DATE-WRITTEN.      FEBRUARY 14, 1995.                            
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00060000
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00070000
CVT000*         S027 CONVERTED TO DB2 SP CSR02027 ON 07/19/2005        *00080000
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00090000
CVT000*                                                                *00100000
CVT000*                    CVT000 - CONVERTED CODE                     *00110000
CVT000*                    CVT004 - NEEDED REVIEW                      *00120000
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00130000
CVT000*                             POTENTIALLY BE DELETED             *00140000
CVT000*                                                                *00150000
CVT000******************************************************************00160000
      ***************************************************************** 00170000
      *                                                               * 00180000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00190000
      *                                                               * 00200000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).  * 00210000
      *                                                               * 00220000
      *  TRANID:        S027                                          * 00230000
      *  PROGRAM:       S027                                          * 00240000
      *  CALLING SP:    PA_S027                                       * 00250000
      *                                                               * 00260000
      ***************************************************************** 00270000
      *                P R O G R A M  S U M M A R Y                   * 00280000
      *                                                               * 00290000
      *  THIS PROGRAM RETRIEVES DATA TO POPULATE THE CUSTOMER         * 00300000
      *  RELATIVES WINDOW. DATA SUCH AS SPOUSE NAME, PHONE NUMBER,    * 00310000
      *  OCCUPATION AND OTHER CUSTOMER RELATIVE INFORMATION IS        * 00320000
      *  RETURNED.                                                    * 00330000
      ***************************************************************** 00340000
      *                                                               * 00350000
      *                     PROGRAM MODIFICATION LOG                  * 00360000
      *                                                               * 00370000
      *    DATE    INITIALS   COMMENTS                                * 00380000
      *  --------  --------   --------------------------------------- * 00390000
      *  02/14/95    FAM      REMOTE PROCEDURE ORIGINALLY CODED.      * 00400000
      *  03/28/95    FAM      INCREASE LICENSE_NO SIZE TO 19 CHARS.   * 00410000
T14139*  01/05/98    GAC      CHANGED RELATIVE PHONE TYPE FROM W1 TO  * 00420000
T14139*                       H1, AND RELATIVE CUS TYPE FROM R TO RL. * 00430000
T14497*  01/26/98    GAC      SPOUSE PHONE TYPE SHOULD BE W1. RELATIVE* 00440000
T14497*                       IS STILL H1.                            *F00450000
CBSI  *  07/16/98             ABEND LOG MODIFIED TO INCLUDE ALL THE   * 00460000
CBSI  *                       TABLE PARAMETERS                        * 00470000
      *  01/04/00    SK       CONTACT_ORDER IS ZERO WHEN SELECTING    * 00480000
      *                       RELATIVE DETAILS FOR PANEL032.          * 00490000
      *                                                               * 00500000
REARCH*  08/24/05    CVNS     RPC TO COBOL SP CONVERSION               *00501000
REARCH*              CHENNAI                                           *00502000
C37510*  09/11/08    CVNS     NAME AND ADDRESS FORMAT CHANGES          *00502100
C37510*              CHENNAI                                           *00502200
A02292*  06/02/10    PA94870  APPL00002292                             *00502300
A02292*                       RETRIEVAL OF DATA FAILING WHEN CONTACT   *00502400
A02292*                       UPDATED ON PANEL 32                      *00502500
A02292*                       CHANGED THE JOIN OF CSS_CONTACT_PHONE TO *00502600
A02292*                       OUTER JOIN                                00502700
      ***************************************************************** 00510000
      ***************************************************************** 00520000
      *                                                               * 00530000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00540000
      *                                                               * 00550000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00560000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00570000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00580000
      *  3000 - 4999  NOT USED                                        * 00590000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00600000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00610000
      *  7000 - 7999  INPUT MODULES                                   * 00620000
      *  8000 - 8999  OUTPUT MODULES                                  * 00630000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES           * 00640000
      *                                                               * 00650000
      ***************************************************************** 00660000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02027'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02027 STARTS HERE'.                  
                                                                        
      ******************************************************************00750000
      *    DB2 INCLUDES                                                *00760000
      ******************************************************************00770000
                                                                        
           EXEC SQL                                                     00790000
              INCLUDE SQLCA                                             00800000
           END-EXEC.                                                    00810000
                                                                        
           EXEC SQL                                                     00830000
              INCLUDE TBCSTSTS                                          00840000
           END-EXEC.                                                    00850000
                                                                        
           EXEC SQL                                                     00870000
              INCLUDE TBNAME                                            00880000
           END-EXEC.                                                    00890000
                                                                        
           EXEC SQL                                                     00910000
              INCLUDE TBCSTPHN                                          00920000
           END-EXEC.                                                    00930000
                                                                        
           EXEC SQL                                                     00950000
              INCLUDE TBCNTACT                                          00960000
           END-EXEC.                                                    00970000
                                                                        
           EXEC SQL                                                     00990000
              INCLUDE TBCNTCCS                                          01000000
           END-EXEC.                                                    01010000
                                                                        
           EXEC SQL                                                     01030000
              INCLUDE TBCNTPHN                                          01040000
           END-EXEC.                                                    01050000
                                                                        
           EXEC SQL                                                     01070000
              INCLUDE TBADRFRE                                          01080000
           END-EXEC.                                                    01090000
                                                                        
           EXEC SQL                                                     01110000
              INCLUDE TBMODEL                                           01120000
           END-EXEC.                                                    01130000
                                                                        
      ******************************************************************01150000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01160000
      ******************************************************************01170000
                                                                        
           COPY CCA00001.                                               01210000
           COPY CWS00027.                                               01230000
           COPY CWS00303.                                               01240000
                                                                        
      ******************************************************************01260000
      *    WORK AREAS                                                  *01270000
      ******************************************************************01280000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CUSTOMER-NO        PIC X(10) VALUE SPACES.          
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
           05  PARM-PREMISE-NO         PIC X(10) VALUE SPACES.          
           05  PARM-PREMISE-NO-RED     REDEFINES PARM-PREMISE-NO        
                                       PIC 9(10).                       
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
           05  RS-SPOUSE-FIRST-NAME    PIC X(15) VALUE SPACES.          
           05  RS-SPOUSE-MIDDLE-NAME   PIC X(15) VALUE SPACES.          
           05  RS-SPOUSE-LAST-NAME     PIC X(40) VALUE SPACES.          
           05  RS-SPOUSE-OCCUPATION    PIC X(15) VALUE SPACES.          
           05  RS-SPOUSE-WORK-PHONE    PIC X(10) VALUE SPACES.          
           05  RS-SPOUSE-WORK-EXT      PIC X(06) VALUE SPACES.          
           05  RS-SPOUSE-EMPLOYER      PIC X(23) VALUE SPACES.          
           05  RS-SPOUSE-EMPLOYED-DATE PIC X(08) VALUE SPACES.          
           05  RS-SPOUSE-SSN           PIC X(09) VALUE SPACES.          
           05  RS-SPOUSE-DATE-OF-BIRTH PIC X(08) VALUE SPACES.          
           05  RS-SPOUSE-LICENSE-NO    PIC X(19) VALUE SPACES.          
           05  RS-SPOUSE-CODE-STATE-ID PIC X(02) VALUE SPACES.          
           05  RS-SPOUSE-DRVR-LIC-DT   PIC X(08) VALUE SPACES.          
           05  RS-SPOUSE-OTHER-ID      PIC X(16) VALUE SPACES.          
           05  RS-SPOUSE-OTHER-ID-TYPE PIC X(12) VALUE SPACES.          
           05  RS-RELATIVE-NAME        PIC X(70) VALUE SPACES.          
C37510     05  RS-RELATIVE-STREET      PIC X(55) VALUE SPACES.          
           05  RS-RELATIVE-RELNSHIP    PIC X(30) VALUE SPACES.          
C37510     05  RS-RELATIVE-CITY-STATE  PIC X(30) VALUE SPACES.          
           05  RS-RELATIVE-PHONE       PIC X(10) VALUE SPACES.          
           05  RS-RELATIVE-ZIP         PIC X(09) VALUE SPACES.          
           05  RS-ADDRESS-OVERFLOW     PIC X(35) VALUE SPACES.          
           05  RS-CONTACT-ASSOC        PIC X(01) VALUE SPACES.          
           05  RS-VALID-CONTACT        PIC X(01) VALUE SPACES.          
           05  RS-RELATIVE-NICKNAME    PIC X(50) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
REARCH     05  S-SPOUSE-FIRST-NAME     PIC X(15) VALUE SPACES.          
REARCH     05  S-SPOUSE-MIDDLE-NAME    PIC X(15) VALUE SPACES.          
REARCH     05  S-SPOUSE-LAST-NAME      PIC X(40) VALUE SPACES.          
REARCH     05  S-SPOUSE-OCCUPATION     PIC X(15) VALUE SPACES.          
REARCH     05  S-SPOUSE-WORK-PHONE     PIC X(10) VALUE SPACES.          
REARCH     05  S-SPOUSE-WORK-EXT       PIC X(06) VALUE SPACES.          
REARCH     05  S-SPOUSE-EMPLOYER       PIC X(23) VALUE SPACES.          
REARCH     05  S-SPOUSE-EMPLOYED-DATE  PIC X(08) VALUE SPACES.          
REARCH     05  S-SPOUSE-SSN            PIC X(09) VALUE SPACES.          
REARCH     05  S-SPOUSE-DATE-OF-BIRTH  PIC X(08) VALUE SPACES.          
REARCH     05  S-SPOUSE-LICENSE-NO     PIC X(19) VALUE SPACES.          
REARCH     05  S-SPOUSE-CODE-STATE-ID  PIC X(02) VALUE SPACES.          
REARCH     05  S-SPOUSE-DRVR-LIC-DT    PIC X(08) VALUE SPACES.          
REARCH     05  S-SPOUSE-OTHER-ID       PIC X(16) VALUE SPACES.          
REARCH     05  S-SPOUSE-OTHER-ID-TYPE  PIC X(12) VALUE SPACES.          
REARCH     05  S-RELATIVE-NAME         PIC X(70) VALUE SPACES.          
C37510     05  S-RELATIVE-STREET       PIC X(55) VALUE SPACES.          
REARCH     05  S-RELATIVE-RELNSHIP     PIC X(30) VALUE SPACES.          
C37510     05  S-RELATIVE-CITY-STATE   PIC X(30) VALUE SPACES.          
REARCH     05  S-RELATIVE-PHONE        PIC X(10) VALUE SPACES.          
REARCH     05  S-RELATIVE-ZIP          PIC X(09) VALUE SPACES.          
REARCH     05  S-ADDRESS-OVERFLOW      PIC X(35) VALUE SPACES.          
REARCH     05  S-CONTACT-ASSOC         PIC X(01) VALUE SPACES.          
REARCH     05  S-VALID-CONTACT         PIC X(01) VALUE SPACES.          
REARCH     05  S-RELATIVE-NICKNAME     PIC X(50) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-SELECT-DATE-FORM.                                         
           10  WS-SELECT-YEAR      PIC X(04) VALUE SPACES.              
           10  FILLER              PIC X(01) VALUE SPACES.              
           10  WS-SELECT-MONTH     PIC X(02) VALUE SPACES.              
           10  FILLER              PIC X(01) VALUE SPACES.              
           10  WS-SELECT-DAY       PIC X(02) VALUE SPACES.              
                                                                        
       01  WS-RETURN-DATE-FORM.                                         
           10  WS-RETURN-MONTH     PIC X(02) VALUE SPACES.              
           10  WS-RETURN-DAY       PIC X(02) VALUE SPACES.              
           10  WS-RETURN-YEAR      PIC X(04) VALUE SPACES.              
                                                                        
       01  WS-MISCELLANEOUS.                                            
REARCH     05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR02027'.    
C27707     05  MULTIPLE-ROWS           PIC S9(04) COMP VALUE -811.      
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
COB305     05 WS-PREMISE-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-CUST-CONTACT-ID-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-NULL-REV-PROT-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-EMP-DT          PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CNSLT-END-DT    PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-SERV-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CUST-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-BIRTH-DT        PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-DRV-LIC-DT      PIC S9(04)  COMP VALUE ZERO.     
A02292     05  WS-NULL-LP-PHONE-NO     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-CUST-NAME-TYPE       PIC X(02)   VALUE 'SN'.          
           05  WS-CUST-NAME-FORMAT     PIC X(01)   VALUE 'I'.           
           05  WS-CUST-CUSTOMER-TYPE   PIC X(01)   VALUE 'S'.           
T14139*    05  WS-PHONE-TYPE           PIC X(02)   VALUE 'W1'.          02950000
T14497     05  WS-SPOUSE-PHONE-TYPE    PIC X(02)   VALUE 'W1'.          
T14139     05  WS-REL-PHONE-TYPE       PIC X(02)   VALUE 'H1'.          
T14139*    05  WS-CUSTOMER-RLTV-TYPE   PIC X(01)   VALUE 'R'.           02980000
T14139     05  WS-CUSTOMER-RLTV-TYPE   PIC X(02)   VALUE 'RL'.          
                                                                        
HPCCDM*EJECT                                                            03010000
CVT000     EXEC SQL                                                     03020000
CVT000         INCLUDE CWSX0010                                         03030000
CVT000     END-EXEC.                                                    03040000
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        03230000
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-CUSTOMER-NO-RED     PIC 9(10)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-PREMISE-NO-RED      PIC 9(10)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CUSTOMER-NO                                        
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************03570000
      * 0000-MAINLINE                                                  *03580000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03590000
      ******************************************************************03600000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03720000
      * 0100-INITIALIZE                                                *03730000
      *                                                                *03740000
      *     1. RESET DB2 ERROR HANDLERS                                *03750000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03760000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03770000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03780000
      *                                                                *03790000
      ******************************************************************03800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE                  AS    RETURN_CODE         
REARCH       ,LTRIM(RTRIM(:S-CUSTOMER-NO))           AS    CUSTOMER_NO         
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-FIRST-NAME))     AS    
           SPOUSE_FIRST_NAME   
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-MIDDLE-NAME))    AS    
           SPOUSE_MIDDLE_NAME  
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-LAST-NAME))      AS    
           SPOUSE_LAST_NAME    
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-OCCUPATION))     AS    
           SPOUSE_OCCUPATION   
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-WORK-PHONE))     AS    
           SPOUSE_WORK_PHONE   
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-WORK-EXT))       AS    
           SPOUSE_WORK_EXT     
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-EMPLOYER))       AS    
           SPOUSE_EMPLOYER     
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-EMPLOYED-DATE))  AS    
           SPOUSE_EMPLOYE_DAT  
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-SSN))            AS    SPOUSE_SSN          
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-DATE-OF-BIRTH))  AS    
           SPOUSE_DT_OF_BIRTH  
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-LICENSE-NO))     AS    
           SPOUSE_LICENSE_NO   
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-CODE-STATE-ID))  AS    
           SPOUSE_CD_STATE_ID  
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-DRVR-LIC-DT))    AS    
           SPOUSE_DRVR_LIC_DT  
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-OTHER-ID))       AS    
           SPOUSE_OTHER_ID     
REARCH       ,LTRIM(RTRIM(:S-SPOUSE-OTHER-ID-TYPE))  AS    
           SPOUSE_OTHR_ID_TYP  
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-NAME))         AS    RELATIVE_NAME       
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-STREET))       AS    
           RELATIVE_STREET     
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-RELNSHIP))     AS    
           RELATIVE_RELNSHIP   
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-CITY-STATE))   AS    CITY_STATE          
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-PHONE))        AS    
           RELATIVE_PHONE      
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-ZIP))          AS    RELATIVE_ZIP        
REARCH       ,LTRIM(RTRIM(:S-ADDRESS-OVERFLOW))      AS    
           ADDRESS_OVERFLOW    
REARCH       ,LTRIM(RTRIM(:S-CONTACT-ASSOC))         AS    CONTACT_ASSOC       
REARCH       ,LTRIM(RTRIM(:S-VALID-CONTACT))         AS    VALID_CONTACT       
REARCH       ,LTRIM(RTRIM(:S-RELATIVE-NICKNAME))     AS    
           RELATIVE_NICKNAME   
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04050000
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                          04060000
MFA-TR*      SELECT                                                     04070000
MFA-TR*       :S-RETURN-CODE                  AS    RETURN_CODE         04080000
MFA-TR*      ,STRIP(:S-CUSTOMER-NO)           AS    CUSTOMER_NO         04090000
MFA-TR*      ,STRIP(:S-SPOUSE-FIRST-NAME)     AS    SPOUSE_FIRST_NAME   04100000
MFA-TR*      ,STRIP(:S-SPOUSE-MIDDLE-NAME)    AS    SPOUSE_MIDDLE_NAME  04110000
MFA-TR*      ,STRIP(:S-SPOUSE-LAST-NAME)      AS    SPOUSE_LAST_NAME    04120000
MFA-TR*      ,STRIP(:S-SPOUSE-OCCUPATION)     AS    SPOUSE_OCCUPATION   04130000
MFA-TR*      ,STRIP(:S-SPOUSE-WORK-PHONE)     AS    SPOUSE_WORK_PHONE   04140000
MFA-TR*      ,STRIP(:S-SPOUSE-WORK-EXT)       AS    SPOUSE_WORK_EXT     04150000
MFA-TR*      ,STRIP(:S-SPOUSE-EMPLOYER)       AS    SPOUSE_EMPLOYER     04160000
MFA-TR*      ,STRIP(:S-SPOUSE-EMPLOYED-DATE)  AS    SPOUSE_EMPLOYE_DAT  04170000
MFA-TR*      ,STRIP(:S-SPOUSE-SSN)            AS    SPOUSE_SSN          04180000
MFA-TR*      ,STRIP(:S-SPOUSE-DATE-OF-BIRTH)  AS    SPOUSE_DT_OF_BIRTH  04190000
MFA-TR*      ,STRIP(:S-SPOUSE-LICENSE-NO)     AS    SPOUSE_LICENSE_NO   04200000
MFA-TR*      ,STRIP(:S-SPOUSE-CODE-STATE-ID)  AS    SPOUSE_CD_STATE_ID  04210000
MFA-TR*      ,STRIP(:S-SPOUSE-DRVR-LIC-DT)    AS    SPOUSE_DRVR_LIC_DT  04220000
MFA-TR*      ,STRIP(:S-SPOUSE-OTHER-ID)       AS    SPOUSE_OTHER_ID     04230000
MFA-TR*      ,STRIP(:S-SPOUSE-OTHER-ID-TYPE)  AS    SPOUSE_OTHR_ID_TYP  04240000
MFA-TR*      ,STRIP(:S-RELATIVE-NAME)         AS    RELATIVE_NAME       04250000
MFA-TR*      ,STRIP(:S-RELATIVE-STREET)       AS    RELATIVE_STREET     04260000
MFA-TR*      ,STRIP(:S-RELATIVE-RELNSHIP)     AS    RELATIVE_RELNSHIP   04270000
MFA-TR*      ,STRIP(:S-RELATIVE-CITY-STATE)   AS    CITY_STATE          04280000
MFA-TR*      ,STRIP(:S-RELATIVE-PHONE)        AS    RELATIVE_PHONE      04290000
MFA-TR*      ,STRIP(:S-RELATIVE-ZIP)          AS    RELATIVE_ZIP        04300000
MFA-TR*      ,STRIP(:S-ADDRESS-OVERFLOW)      AS    ADDRESS_OVERFLOW    04310000
MFA-TR*      ,STRIP(:S-CONTACT-ASSOC)         AS    CONTACT_ASSOC       04320000
MFA-TR*      ,STRIP(:S-VALID-CONTACT)         AS    VALID_CONTACT       04330000
MFA-TR*      ,STRIP(:S-RELATIVE-NICKNAME)     AS    RELATIVE_NICKNAME   04340000
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   04350000
MFA-TR*    END-EXEC.                                                    04360000
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04430000
      * 1000-PROCESS-INPUT                                             *04440000
      *                                                                *04450000
      *     RECEIVE PARMS FROM THE CALLING STORED PROCEDURE.           *04460000
      *                                                                *04470000
      ******************************************************************04480000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO      TO RS-CUSTOMER-NO.                
           MOVE PARM-CUSTOMER-NO-RED  TO WS-CUSTOMER-NO-NUM.            
           MOVE PARM-PREMISE-NO-RED   TO WS-PREMISE-NO-NUM.             
           MOVE PARM-ACCOUNT-NO-RED   TO WS-ACCOUNT-NO-NUM.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05040000
      *   2000-PROCESS-OUTPUT                                    *      05050000
      *                                                          *      05060000
      *   1. DESCRIBE RESULT SET                                 *      05070000
      *   2. RETRIEVE DB2 DATA AND BUILD RESULT SET              *      05080000
      *   3. SEND RESULT SET                                     *      05090000
      *                                                          *      05100000
      ************************************************************      05110000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                
            MOVE '2000'          TO ACTIVE-PARAGRAPH.                   
REARCH      PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT                
            PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************** 05221000
REARCH*2000A-MOVE-RESULT.                                              *05222000
REARCH***************************************************************** 05223000
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-CUSTOMER-NO            TO S-CUSTOMER-NO.             
REARCH     MOVE RS-SPOUSE-FIRST-NAME      TO S-SPOUSE-FIRST-NAME.       
REARCH     MOVE RS-SPOUSE-MIDDLE-NAME     TO S-SPOUSE-MIDDLE-NAME.      
REARCH     MOVE RS-SPOUSE-LAST-NAME       TO S-SPOUSE-LAST-NAME.        
REARCH     MOVE RS-SPOUSE-OCCUPATION      TO S-SPOUSE-OCCUPATION.       
REARCH     MOVE RS-SPOUSE-WORK-PHONE      TO S-SPOUSE-WORK-PHONE.       
REARCH     MOVE RS-SPOUSE-WORK-EXT        TO S-SPOUSE-WORK-EXT.         
REARCH     MOVE RS-SPOUSE-EMPLOYER        TO S-SPOUSE-EMPLOYER.         
REARCH     MOVE RS-SPOUSE-EMPLOYED-DATE   TO S-SPOUSE-EMPLOYED-DATE.    
REARCH     MOVE RS-SPOUSE-SSN             TO S-SPOUSE-SSN.              
REARCH     MOVE RS-SPOUSE-DATE-OF-BIRTH   TO S-SPOUSE-DATE-OF-BIRTH.    
REARCH     MOVE RS-SPOUSE-LICENSE-NO      TO S-SPOUSE-LICENSE-NO.       
REARCH     MOVE RS-SPOUSE-CODE-STATE-ID   TO S-SPOUSE-CODE-STATE-ID.    
REARCH     MOVE RS-SPOUSE-DRVR-LIC-DT     TO S-SPOUSE-DRVR-LIC-DT.      
REARCH     MOVE RS-SPOUSE-OTHER-ID        TO S-SPOUSE-OTHER-ID.         
REARCH     MOVE RS-SPOUSE-OTHER-ID-TYPE   TO S-SPOUSE-OTHER-ID-TYPE.    
REARCH     MOVE RS-RELATIVE-NAME          TO S-RELATIVE-NAME.           
REARCH     MOVE RS-RELATIVE-STREET        TO S-RELATIVE-STREET.         
REARCH     MOVE RS-RELATIVE-RELNSHIP      TO S-RELATIVE-RELNSHIP.       
REARCH     MOVE RS-RELATIVE-CITY-STATE    TO S-RELATIVE-CITY-STATE.     
REARCH     MOVE RS-RELATIVE-PHONE         TO S-RELATIVE-PHONE.          
REARCH     MOVE RS-RELATIVE-ZIP           TO S-RELATIVE-ZIP.            
REARCH     MOVE RS-ADDRESS-OVERFLOW       TO S-ADDRESS-OVERFLOW.        
REARCH     MOVE RS-CONTACT-ASSOC          TO S-CONTACT-ASSOC.           
REARCH     MOVE RS-VALID-CONTACT          TO S-VALID-CONTACT.           
REARCH     MOVE RS-RELATIVE-NICKNAME      TO S-RELATIVE-NICKNAME.       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************11060000
      *   2200-BUILD-RESULT                                            *11070000
      *                                                                *11080000
      *   1.  SELECT AND FORMAT ALL CUSTOMER DETAIL INFORMATION        *11090000
      *       TO BE RETURNED.                                          *11100000
      *                                                                *11110000
      ******************************************************************11120000
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
            PERFORM 7000-SELECT-SPOUSE-DTLS     THRU 7000-EXIT.         
                                                                        
             PERFORM 7100-SELECT-PHONE-NO       THRU 7100-EXIT.         
             IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                
                MOVE CB-PHONE-NO         TO RS-SPOUSE-WORK-PHONE        
                MOVE CB-EXTENSION-NO     TO RS-SPOUSE-WORK-EXT          
             ELSE                                                       
                MOVE SPACES              TO RS-SPOUSE-WORK-PHONE        
                MOVE SPACES              TO RS-SPOUSE-WORK-EXT          
             END-IF.                                                    
                                                                        
T27707      PERFORM 7200-SELECT-CUST-REL       THRU 7200-EXIT.          
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE DT-CONTACT-ID         TO WS-CUST-CONTACT-ID-NUM     
            ELSE                                                        
               MOVE 0                     TO WS-CUST-CONTACT-ID-NUM     
            END-IF.                                                     
                                                                        
            PERFORM 7600-SELECT-NAME-INFO       THRU 7600-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11400000
      *   7000-SELECT-SPOUSE-DTLS.                                     *11410000
      *                                                                *11420000
      *   1.  DETERMINE NAME_ID BASED ON PASSED CUSTOMER_NO.           *11430000
      *       USE BOTH CUSTOMER_NO AND NAME_ID TO SELECT CUSTOMER      *11440000
      *       INFORMATION FROM CSS_CUSTOMER AND CSS_NAME TABLES.       *11450000
      *                                                                *11460000
      ******************************************************************11470000
                                                                        
       7000-SELECT-SPOUSE-DTLS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT A.SSN,                                             
                     A.CODE_STATE_ID,                                   
                     A.DRIVERS_LICENSE_NO,                              
                     A.EMPLOYER,                                        
                     A.EMPLOYED_DATE,                                   
                     A.OCCUPATION,                                      
                     A.OTHER_ID_TYPE,                                   
                     A.OTHER_ID,                                        
                     A.DRVR_LIC_ISS_DT,                                 
                     A.DATE_OF_BIRTH,                                   
                     B.NAME_FORMAT,                                     
                     B.FIRST_NAME,                                      
                     B.MIDDLE_NAME,                                     
                     B.LAST_NAME                                        
              INTO  :CE-SSN,                                            
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    :CE-EMPLOYED-DATE :WS-NULL-EMP-DT,                   
                    :CE-OCCUPATION,                                     
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    :CE-DRVR-LIC-ISS-DT :WS-NULL-DRV-LIC-DT,             
                    :CE-DATE-OF-BIRTH :WS-NULL-BIRTH-DT,                 
                    :DQ-NAME-FORMAT,                                    
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME                                       
              FROM   CSS_CUST_STATS A,                                  
                     CSS_NAME B                                         
              WHERE  A.CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM              
                AND  A.CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE           
                AND  B.NAME_ID       = A.NAME_ID                        
                AND  B.NAME_TYPE     = :WS-CUST-NAME-TYPE               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
CBSI          MOVE 'CSS_NAME'           TO TABLE-2                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-3              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-CUST-CUSTOMER-TYPE                                
CBSI                                    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-CUST-NAME-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-SSN                TO RS-SPOUSE-SSN               
              MOVE CE-CODE-STATE-ID      TO RS-SPOUSE-CODE-STATE-ID     
              MOVE CE-DRIVERS-LICENSE-NO TO RS-SPOUSE-LICENSE-NO        
              MOVE CE-EMPLOYER           TO RS-SPOUSE-EMPLOYER          
              MOVE CE-OCCUPATION         TO RS-SPOUSE-OCCUPATION        
              MOVE CE-OTHER-ID-TYPE      TO RS-SPOUSE-OTHER-ID-TYPE     
              MOVE CE-OTHER-ID           TO RS-SPOUSE-OTHER-ID          
              MOVE DQ-FIRST-NAME         TO RS-SPOUSE-FIRST-NAME        
              MOVE DQ-MIDDLE-NAME        TO RS-SPOUSE-MIDDLE-NAME       
              MOVE DQ-LAST-NAME          TO RS-SPOUSE-LAST-NAME         
                                                                        
              IF WS-NULL-EMP-DT = -1                                    
                 MOVE SPACES             TO RS-SPOUSE-EMPLOYED-DATE     
              ELSE                                                      
                 MOVE CE-EMPLOYED-DATE    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-SPOUSE-EMPLOYED-DATE    
              END-IF                                                    
                                                                        
              IF WS-NULL-DRV-LIC-DT = -1                                
                 MOVE SPACES             TO RS-SPOUSE-DRVR-LIC-DT       
              ELSE                                                      
                 MOVE CE-DRVR-LIC-ISS-DT  TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-SPOUSE-DRVR-LIC-DT      
              END-IF                                                    
                                                                        
              IF WS-NULL-BIRTH-DT = -1                                  
                 MOVE SPACES             TO RS-SPOUSE-DATE-OF-BIRTH     
              ELSE                                                      
                 MOVE CE-DATE-OF-BIRTH    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-SPOUSE-DATE-OF-BIRTH    
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE SPACES                 TO RS-SPOUSE-SSN              
              MOVE SPACES                 TO RS-SPOUSE-CODE-STATE-ID    
              MOVE SPACES                 TO RS-SPOUSE-LICENSE-NO       
              MOVE SPACES                 TO RS-SPOUSE-EMPLOYER         
              MOVE SPACES                 TO RS-SPOUSE-OCCUPATION       
              MOVE SPACES                 TO RS-SPOUSE-OTHER-ID-TYPE    
              MOVE SPACES                 TO RS-SPOUSE-OTHER-ID         
              MOVE SPACES                 TO RS-SPOUSE-EMPLOYED-DATE    
              MOVE SPACES                 TO RS-SPOUSE-DRVR-LIC-DT      
              MOVE SPACES                 TO RS-SPOUSE-DATE-OF-BIRTH    
           END-IF.                                                      
                                                                        
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************12730000
      ******************************************************************12740000
      *   7100-SELECT-PHONE-NO.                                        *12750000
      *                                                                *12760000
      *   1. SELECTS PHONE NUMBERS BASED ON THE CUSTOMER NUMBER,       *12770000
      *      CUSTOMER TYPE AND PHONE TYPE.  (FOR SPOUSE)               *12780000
      *                                                                *12790000
      ******************************************************************12800000
                                                                        
       7100-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_NO,                                          
                     EXTENSION_NO                                       
              INTO  :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO                                    
              FROM  CSS_CUST_PHONE                                      
              WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                 
                AND PHONE_TYPE    = :WS-SPOUSE-PHONE-TYPE               
                AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-CUST-CUSTOMER-TYPE                                
CBSI                                    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-SPOUSE-PHONE-TYPE TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13210000
      *   7200-SELECT-CUST-REL                                         *13220000
      *                                                                *13230000
      *   1.  DETERMINE IF THERE IS A CONTACT FOR THIS CUSTOMER.       *13240000
      *                                                                *13250000
      ******************************************************************13260000
                                                                        
       7200-SELECT-CUST-REL.                                            
                                                                        
           EXEC SQL                                                     
              SELECT A.CUSTOMER_NO,                                     
                     A.CONTACT_ID                                       
              INTO  :DT-CUSTOMER-NO,                                    
                    :DT-CONTACT-ID                                      
              FROM   CSS_CONTACT_CUST A,                                
                     CSS_CONTACT B                                      
              WHERE  A.CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM              
                AND  A.CONTACT_ID    = B.CONTACT_ID                     
T27707*         AND  B.CONTACT_TYPE  = :WS-CUSTOMER-RLTV-TYPE           13390000
T27707          AND  B.CONTACT_TYPE  IN ('RR','RL')                     
                AND  B.CONTACT_ORDER = 0                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T27707           PERFORM 7210-SELECT-PREM-REL   THRU 7210-EXIT          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE '7200'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
CBSI             MOVE SPACES               TO ABEND-SQL-PREDICATES      
CBSI                                          ABEND-TABLES              
CBSI             MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                   
                 MOVE 'CSS_CONTACT'        TO TABLE-2                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
CBSI             MOVE 'CONTACT_TYPE'       TO TABLE-ELEMENT-2           
                 MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1         
CBSI  *          MOVE WS-CUSTOMER-RLTV-TYPE                             13620000
CBSI  *                                 TO HOSTVAR-ELEMENT-2            13630000
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
                                                                        
      ******************************************************************13710000
      *   7210-SELECT-PREM-REL                                         *13720000
      *                                                                *13730000
      *   1.  DETERMINE IF THERE IS A CONTACT FOR THIS PREMISE.        *13740000
      *                                                                *13750000
      ******************************************************************13760000
                                                                        
       7210-SELECT-PREM-REL.                                            
                                                                        
           EXEC SQL                                                     
              SELECT A.CONTACT_ID                                       
              INTO  :DT-CONTACT-ID                                      
              FROM   CSS_CONTACT_PREM A,                                
                     CSS_CONTACT B                                      
              WHERE  A.PREMISE_NO    = :WS-PREMISE-NO-NUM               
                AND  A.CONTACT_ID    = B.CONTACT_ID                     
T27707*         AND  B.CONTACT_TYPE  = :WS-CUSTOMER-RLTV-TYPE           13870000
T27707          AND  B.CONTACT_TYPE  IN ('RR','RL')                     
                AND  B.CONTACT_ORDER = 0                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
              MOVE WS-CUSTOMER-NO-NUM    TO DT-CUSTOMER-NO              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T27707           PERFORM 7220-SELECT-ACCT-REL   THRU 7220-EXIT          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE '7210'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
CBSI             MOVE SPACES               TO ABEND-SQL-PREDICATES      
CBSI                                          ABEND-TABLES              
CBSI             MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                   
                 MOVE 'CSS_CONTACT'        TO TABLE-2                   
                 MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CONTACT_TYPE'       TO TABLE-ELEMENT-2           
                 MOVE WS-PREMISE-NO-NUM    TO HOSTVAR-ELEMENT-1         
CBSI  *          MOVE WS-CUSTOMER-RLTV-TYPE                             14100000
CBSI  *                                    TO HOSTVAR-ELEMENT-2         14110000
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
                                                                        
      ******************************************************************14190000
      *   7220-SELECT-ACCT-REL                                         *14200000
      *                                                                *14210000
      *   1.  DETERMINE IF THERE IS A CONTACT FOR THIS ACCOUNT.        *14220000
      *                                                                *14230000
      ******************************************************************14240000
                                                                        
       7220-SELECT-ACCT-REL.                                            
                                                                        
           EXEC SQL                                                     
              SELECT A.CONTACT_ID                                       
              INTO  :DT-CONTACT-ID                                      
              FROM   CSS_CONTACT_ACCT A,                                
                     CSS_CONTACT B                                      
              WHERE  A.ACCOUNT_NO    = :WS-ACCOUNT-NO-NUM               
                AND  A.CONTACT_ID    = B.CONTACT_ID                     
T27707*         AND  B.CONTACT_TYPE  = :WS-CUSTOMER-RLTV-TYPE           14350000
T27707          AND  B.CONTACT_TYPE  IN ('RR','RL')                     
                AND  B.CONTACT_ORDER = 0                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
              MOVE WS-CUSTOMER-NO-NUM    TO DT-CUSTOMER-NO              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE '7220'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
CBSI             MOVE SPACES               TO ABEND-SQL-PREDICATES      
CBSI                                       ABEND-TABLES                 
CBSI             MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                   
                 MOVE 'CSS_CONTACT'        TO TABLE-2                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CONTACT_TYPE'       TO TABLE-ELEMENT-2           
                 MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
T27707*          MOVE WS-CUSTOMER-RLTV-TYPE                             14580000
T27707*                                    TO HOSTVAR-ELEMENT-2         14590000
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
                                                                        
      ******************************************************************14670000
      *   7600-SELECT-RELATIVE-DTLS                                    *14680000
      *                                                                *14690000
      *   1.  DETERMINE NAME_ID BASED ON PASSED CUSTOMER_NO.           *14700000
      *       USE BOTH CUSTOMER_NO AND NAME_ID TO SELECT CUSTOMER      *14710000
      *       INFORMATION FROM CSS_CUSTOMER AND CSS_NAME TABLES.       *14720000
      *                                                                *14730000
      ******************************************************************14740000
                                                                        
       7600-SELECT-NAME-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT C.PHONE_NO,                                        
                     A.ADDR_STREET,                                     
                     A.ADDR_CITY_STATE,                                 
                     A.ADDR_ZIP_CODE,                                   
                     A.ADDRESS_OVERFLOW,                                
                     B.CONTACT_POSITION,                                
                     D.FULL_NAME,                                       
T27707               D.NICKNAME,                                        
T27707               B.CONTACT_TYPE                                     
              INTO  :LP-PHONE-NO :WS-NULL-LP-PHONE-NO,                   
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDRESS-OVERFLOW,                               
                    :CV-CONTACT-POSITION,                               
                    :DQ-FULL-NAME,                                      
T27707              :DQ-NICKNAME,                                       
T27707              :CV-CONTACT-TYPE                                    
A02292        FROM  CSS_CONTACT B                                       
A02292   LEFT OUTER JOIN CSS_CONTACT_PHONE C                            
A02292           ON C.CONTACT_ID = B.CONTACT_ID                         
A02292          AND C.PHONE_TYPE = :WS-REL-PHONE-TYPE                   
A02292   INNER JOIN CSS_ADDR_FREEFORM A                                 
A02292           ON A.ADDRESS_ID = B.ADDRESS_ID                         
A02292   INNER JOIN CSS_NAME D                                          
A02292           ON D.NAME_ID = B.NAME_ID                               
A02292        WHERE B.CONTACT_ID = :WS-CUST-CONTACT-ID-NUM              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI          MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
CBSI          MOVE 'CSS_CONTACT'        TO TABLE-2                      
CBSI          MOVE 'CSS_CONTACT_PHONE'  TO TABLE-3                      
CBSI          MOVE 'CSS_NAME'           TO TABLE-4                      
CBSI          MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3              
CBSI          MOVE WS-CUST-CONTACT-ID-NUM                               
CBSI                                    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-REL-PHONE-TYPE    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LP-PHONE-NO           TO RS-RELATIVE-PHONE           
              MOVE DZ-ADDR-STREET        TO RS-RELATIVE-STREET          
              MOVE DZ-ADDR-CITY-STATE    TO RS-RELATIVE-CITY-STATE      
              MOVE DZ-ADDR-ZIP-CODE      TO RS-RELATIVE-ZIP             
              MOVE DZ-ADDRESS-OVERFLOW   TO RS-ADDRESS-OVERFLOW         
              MOVE CV-CONTACT-POSITION-TEXT TO RS-RELATIVE-RELNSHIP     
              MOVE DQ-FULL-NAME             TO RS-RELATIVE-NAME         
T27707        MOVE DQ-NICKNAME              TO RS-RELATIVE-NICKNAME     
T27707*************************************************************     15430000
      * THE CONTACT TYPE WILL BE RL IF IT IS GOING TO SHOW ON THE *     15440000
      * CONTACT PANEL AND RR IF IT IS GOING TO BE FILTERED        *     15450000
      *************************************************************     15460000
T27707        IF CV-CONTACT-TYPE = 'RL'                                 
T27707           MOVE 'Y'                TO RS-VALID-CONTACT            
T27707        ELSE                                                      
T27707           MOVE 'N'                TO RS-VALID-CONTACT            
T27707        END-IF                                                    
           ELSE                                                         
              MOVE SPACES                TO RS-RELATIVE-PHONE           
              MOVE SPACES                TO RS-RELATIVE-STREET          
              MOVE SPACES                TO RS-RELATIVE-CITY-STATE      
              MOVE SPACES                TO RS-RELATIVE-ZIP             
              MOVE SPACES                TO RS-ADDRESS-OVERFLOW         
              MOVE SPACES                TO RS-RELATIVE-RELNSHIP        
              MOVE SPACES                TO RS-RELATIVE-NAME            
T27707        MOVE SPACES                TO RS-RELATIVE-NICKNAME        
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15660000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     15670000
      ******************************************************************15680000
           EXEC SQL                                                     15690000
              INCLUDE CPDSP300                                          15700000
           END-EXEC.                                                    15710000
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     15820000
CVT000         INCLUDE CPD00321                                         15830000
CVT000     END-EXEC.                                                    15840000
